#ifndef _IMX_REGS_H
#define _IMX_REGS_H
/* ------------------------------------------------------------------------
 *  Motorola IMX system registers
 * ------------------------------------------------------------------------
 *
 */

/*
 *  Register BASEs, based on OFFSETs
 *
 */
#if defined(CONFIG_ARCH_IMX1)

#define IMX_AIPI1_BASE             (0x00000 + IMX_IO_BASE)
#define IMX_WDT_BASE               (0x01000 + IMX_IO_BASE)
#define IMX_TIM1_BASE              (0x02000 + IMX_IO_BASE)
#define IMX_TIM2_BASE              (0x03000 + IMX_IO_BASE)
#define IMX_RTC_BASE               (0x04000 + IMX_IO_BASE)
#define IMX_LCDC_BASE              (0x05000 + IMX_IO_BASE)
#define IMX_UART1_BASE             (0x06000 + IMX_IO_BASE)
#define IMX_UART2_BASE             (0x07000 + IMX_IO_BASE)
#define IMX_PWM_BASE               (0x08000 + IMX_IO_BASE)
#define IMX_DMAC_BASE              (0x09000 + IMX_IO_BASE)
#define IMX_AIPI2_BASE             (0x10000 + IMX_IO_BASE)
#define IMX_SIM_BASE               (0x11000 + IMX_IO_BASE)
#define IMX_USBD_BASE              (0x12000 + IMX_IO_BASE)
#define IMX_SPI1_BASE              (0x13000 + IMX_IO_BASE)
#define IMX_MMC_BASE               (0x14000 + IMX_IO_BASE)
#define IMX_ASP_BASE               (0x15000 + IMX_IO_BASE)
#define IMX_BTA_BASE               (0x16000 + IMX_IO_BASE)
#define IMX_I2C_BASE               (0x17000 + IMX_IO_BASE)
#define IMX_SSI_BASE               (0x18000 + IMX_IO_BASE)
#define IMX_SPI2_BASE              (0x19000 + IMX_IO_BASE)
#define IMX_MSHC_BASE              (0x1A000 + IMX_IO_BASE)
#define IMX_PLL_BASE               (0x1B000 + IMX_IO_BASE)
#define IMX_GPIO_BASE              (0x1C000 + IMX_IO_BASE)
#define IMX_EIM_BASE               (0x20000 + IMX_IO_BASE)
#define IMX_SDRAMC_BASE            (0x21000 + IMX_IO_BASE)
#define IMX_MMA_BASE               (0x22000 + IMX_IO_BASE)
#define IMX_AITC_BASE              (0x23000 + IMX_IO_BASE)
#define IMX_CSI_BASE               (0x24000 + IMX_IO_BASE)

#elif defined(CONFIG_ARCH_IMX21)

#define IMX_AIPI1_BASE             (0x00000 + IMX_IO_BASE)
#define IMX_DMAC_BASE              (0x01000 + IMX_IO_BASE)
#define IMX_WDT_BASE               (0x02000 + IMX_IO_BASE)
#define IMX_TIM1_BASE              (0x03000 + IMX_IO_BASE)
#define IMX_TIM2_BASE              (0x04000 + IMX_IO_BASE)
#define IMX_TIM3_BASE              (0x05000 + IMX_IO_BASE)
#define IMX_PWM_BASE               (0x06000 + IMX_IO_BASE)
#define IMX_RTC_BASE               (0x07000 + IMX_IO_BASE)
#define IMX_KPP_BASE               (0x08000 + IMX_IO_BASE)
#define IMX_OWIRE_BASE             (0x09000 + IMX_IO_BASE)
#define IMX_UART1_BASE             (0x0A000 + IMX_IO_BASE)
#define IMX_UART2_BASE             (0x0B000 + IMX_IO_BASE)
#define IMX_UART3_BASE             (0x0C000 + IMX_IO_BASE)
#define IMX_UART4_BASE             (0x0D000 + IMX_IO_BASE)
#define IMX_CSPI1_BASE             (0x0E000 + IMX_IO_BASE)
#define IMX_CSPI2_BASE             (0x0F000 + IMX_IO_BASE)
#define IMX_SSI1_BASE              (0x10000 + IMX_IO_BASE)
#define IMX_SSI2_BASE              (0x11000 + IMX_IO_BASE)
#define IMX_I2C_BASE               (0x12000 + IMX_IO_BASE)
#define IMX_SDHC1_BASE             (0x13000 + IMX_IO_BASE)
#define IMX_SDHC2_BASE             (0x14000 + IMX_IO_BASE)
#define IMX_GPIO_BASE              (0x15000 + IMX_IO_BASE)
#define IMX_AUDMUX_BASE            (0x16000 + IMX_IO_BASE)
#define IMX_CSPI3_BASE             (0x17000 + IMX_IO_BASE)
#define IMX_AIPI2_BASE             (0x20000 + IMX_IO_BASE)
#define IMX_LCDC_BASE              (0x21000 + IMX_IO_BASE)
#define IMX_SLCDC_BASE             (0x22000 + IMX_IO_BASE)
#define IMX_SAHARA_BASE            (0x23000 + IMX_IO_BASE)
#define IMX_USBOTG_BASE            (0x24000 + IMX_IO_BASE)
#define IMX_EMMA_BASE              (0x26000 + IMX_IO_BASE)
#define IMX_CRM_BASE               (0x27000 + IMX_IO_BASE)

/* added by PCJ */
#define SYS_BASE_ADDR               (0x27800 + IMX_IO_BASE)  //0x10027800 (mx2ads)

#define IMX_FIRI_BASE              (0x28000 + IMX_IO_BASE)
#define IMX_RNGA_BASE              (0x29000 + IMX_IO_BASE)
#define IMX_RTIC_BASE              (0x2A000 + IMX_IO_BASE)
#define IMX_JAM_BASE               (0x3E000 + IMX_IO_BASE)
#define IMX_MAX_BASE               (0x3F000 + IMX_IO_BASE)
#define IMX_AITC_BASE              (0x40000 + IMX_IO_BASE)
#define _reg_AUDMUX_HPCR1	(*((volatile unsigned long *)(IMX_AUDMUX_BASE+0x00)))  //  32bit audmux host config reg 1
#define _reg_AUDMUX_PPCR1	(*((volatile unsigned long *)(IMX_AUDMUX_BASE+0x10)))  //  32bit audmux pripheral config 1
#define _reg_AUDMUX_PPCR2	(*((volatile unsigned long *)(IMX_AUDMUX_BASE+0x14)))  //  32bit audmux pripheral config 2
#define _reg_SSI_SCR(x)		(*((volatile unsigned long *)(IMX_SSI1_BASE+0x10)))	//  32bit ssi1 control reg
#define _reg_SSI_STCR(x)		(*((volatile unsigned long *)(IMX_SSI1_BASE+0x1C)))	//  32bit ssi1 tx config reg
#define _reg_SSI_SRCR(x)		(*((volatile unsigned long *)(IMX_SSI1_BASE+0x20)))	//  32bit ssi1 rx config reg
#define _reg_SSI_SFCSR(x)	(*((volatile unsigned long *)(IMX_SSI1_BASE+0x2C)))	//  32bit ssi1 fifo control/status reg
#define _reg_SSI_SIER(x)		(*((volatile unsigned long *)(IMX_SSI1_BASE+0x18)))	//  32bit ssi1 intr enable reg
#define _reg_SSI_SCR(x)		(*((volatile unsigned long *)(IMX_SSI1_BASE+0x10)))	//  32bit ssi1 control reg
#define _reg_SSI_SOR(x)		(*((volatile unsigned long *)(IMX_SSI1_BASE+0x34)))	//  32bit ssi1 option reg
#define _reg_SSI_SCR(x)		(*((volatile unsigned long *)(IMX_SSI1_BASE+0x10)))	//  32bit ssi1 control reg
#define _reg_SSI_SRCCR(x)	(*((volatile unsigned long *)(IMX_SSI1_BASE+0x28)))	//  32bit ssi1 rx clock control reg
#define _reg_SSI_STMSK(x)	(*((volatile unsigned long *)(IMX_SSI1_BASE+0x48)))	//  32bit ssi1 tx time slot mask reg
#define _reg_SSI_SRMSK(x)	(*((volatile unsigned long *)(IMX_SSI1_BASE+0x4C)))	//  32bit ssi1 rx time slot mask reg	
#define _reg_SSI_STCCR(x)	(*((volatile unsigned long *)(IMX_SSI1_BASE+0x24)))	//  32b
#define _reg_SSI_SISR(x)		(*((volatile unsigned long *)(IMX_SSI1_BASE+0x14)))	//  32bit ssi1 intr status reg


#endif /* defined(CONFIG_ARCH_IMX21) */


/* PLL registers */
#if defined(CONFIG_ARCH_IMX1)

#define CSCR   __REG(IMX_PLL_BASE)        /* Clock Source Control Register */
#define CSCR_SYSTEM_SEL (1<<16)
#define CSCR_MPLL_RESTART (1<<21)

#define MPCTL0 __REG(IMX_PLL_BASE + 0x4)  /* MCU PLL Control Register 0 */
#define MPCTL1 __REG(IMX_PLL_BASE + 0x8)  /* MCU PLL and System Clock Register 1 */
#define SPCTL0 __REG(IMX_PLL_BASE + 0xc)  /* System PLL Control Register 0 */
#define SPCTL1 __REG(IMX_PLL_BASE + 0x10) /* System PLL Control Register 1 */
#define PCDR   __REG(IMX_PLL_BASE + 0x20) /* Peripheral Clock Divider Register */

#elif defined (CONFIG_ARCH_IMX21)

# define CSCR                    __REG(IMX_CRM_BASE + 0x0)
# define CSCR_PRESC_MASK         (0x7<<29)
# define CSCR_PRESC(x)           (((x) & 0x7) << 29)
# define CSCR_USB_DIV_MASK       (0x7<<26)
# define CSCR_USB_DIV(x)         (((x) & 0x7) << 26)
# define CSCR_SD_CNT_MASK        (0x3<<24)
# define CSCR_SD_CNT(x)          (((x) & 0x3) << 24)
# define CSCR_SPLL_RESTART       (1<<22)
# define CSCR_MPLL_RESTART       (1<<21)
# define CSCR_SSI2_SEL           (1<<20)
# define CSCR_SSI1_SEL           (1<<19)
# define CSCR_FIR_SEL            (1<<18)
# define CSCR_SP_SEL             (1<<17)
# define CSCR_MCU_SEL            (1<<16)
# define CSCR_BCLKDIV_MASK       (0xf<<10)
# define CSCR_BCLKDIV(x)         (((x) & 0xf) << 10)
# define CSCR_IPDIV              (1<<9)
# define CSCR_OSC26M_DIV1P5      (1<<4)
# define CSCR_OSC28M_DIS         (1<<3)
# define CSCR_FPM_EN             (1<<2)
# define CSCR_SPEN               (1<<1)
# define CSCR_MPEN               (1<<0)
  
# define MPCTL0                  __REG(IMX_CRM_BASE + 0x4)
# define MPCTL0_CPLM             (1<<31)
# define MPCTL0_PD(x)            (((x) & 0xf) << 26)
# define MPCTL0_MFD(x)           (((x) & 0x3ff) << 16)
# define MPCTL0_MFI(x)           (((x) & 0xf) << 10)
# define MPCTL0_MFN(x)           (((x) & 0x3ff) << 0)
  
# define MPCTL1                  __REG(IMX_CRM_BASE + 0x8)
# define MPCTL1_LF               (1<<15)
# define MPCTL1_BRMO             (1<<6)
  
# define SPCTL0                  __REG(IMX_CRM_BASE + 0xc)
# define SPCTL0_CPLM             (1<<31)
# define SPCTL0_PD(x)            (((x) & 0xf) << 26)
# define SPCTL0_MFD(x)           (((x) & 0x3ff) << 16)
# define SPCTL0_MFI(x)           (((x) & 0xf) << 10)
# define SPCTL0_MFN(x)           (((x) & 0x3ff) << 0)
  
# define SPCTL1                  __REG(IMX_CRM_BASE + 0x10)
# define SPCTL1_LF               (1<<15)
# define SPCTL1_BRMO             (1<<6)
# define OSC26MCTL               (IMX_CRM_BASE + 0x14)
# define OSC26MCTL_OSC26M_PEAK   (0x2<<16)
# define OSC25MCTL_AGC(x)        (((x) & 0x3f) << 8)
  

# define PCDR0                   __REG(IMX_CRM_BASE + 0x18)
# define PCDR0_SSI2DIV(x)        (((x) & 0x3f) << 26)
# define PCDR0_SSI2DIV_MASK      (0x3f << 26)
# define PCDR0_SSI1DIV(x)        (((x) & 0x3f) << 16)
# define PCDR0_SSI1DIV_MASK      (0x3f << 16)
# define PCDR0_NFCDIV(x)         (((x) & 0xf) << 12)
# define PCDR0_NFCDIV_MASK       (0xf << 12)
# define PCDR0_CLKO_48MDIV(x)    (((x) & 0x7) << 5)
# define PCDR0_CLKO_48MDIV_MASK  (0x7 << 5)
# define PCDR0_FIRI_DIV(x)       (((x) & 0x1f) << 0)
# define PCDR0_FIRI_DIV_MASK     (0x1f << 0)


# define PCDR1                   __REG(IMX_CRM_BASE + 0x1c)
# define PCDR1_PERDIV4_POS       24
# define PCDR1_PERDIV4_MASK      (0x3f << PCDR1_PERDIV4_POS)
# define PCDR1_PERDIV4(x)        (((x) << PCDR1_PERDIV4_POS) & \
                                  PCDR1_PERDIV4_MASK)
# define PCDR1_PERDIV3_POS       16
# define PCDR1_PERDIV3_MASK      (0x3f << PCDR1_PERDIV3_POS)
# define PCDR1_PERDIV3(x)        (((x) << PCDR1_PERDIV3_POS) & \
                                  PCDR1_PERDIV3_MASK)
# define PCDR1_PERDIV2_POS       8
# define PCDR1_PERDIV2_MASK      (0x3f << PCDR1_PERDIV2_POS)
# define PCDR1_PERDIV2(x)        (((x) << PCDR1_PERDIV2_POS) & \
                                  PCDR1_PERDIV2_MASK)
# define PCDR1_PERDIV1_POS       0
# define PCDR1_PERDIV1_MASK      (0x3f << PCDR1_PERDIV1_POS)
# define PCDR1_PERDIV1(x)        (((x) << PCDR1_PERDIV1_POS) & \
                                  PCDR1_PERDIV1_MASK)
  
# define PCCR0                   __REG(IMX_CRM_BASE + 0x20) 
# define PCCR0_HCLK_CSI_EN       (1<<31)
# define PCCR0_HCLK_DMA_EN       (1<<30)
# define PCCR0_HCLK_BROM_EN      (1<<28)
# define PCCR0_HCLK_EMMA_EN      (1<<27)
# define PCCR0_HCLK_LCDC_EN      (1<<26)
# define PCCR0_HCLK_SLCDC_EN     (1<<25)
# define PCCR0_HCLK_USBOTG_EN    (1<<24)
# define PCCR0_HCLK_BMI_EN       (1<<23)
# define PCCR0_PERCLK4_EN        (1<<22)
# define PCCR0_SLCDC_EN          (1<<21)
# define PCCR0_FIRI_BAUD_EN      (1<<20)
# define PCCR0_NFC_EN            (1<<19)
# define PCCR0_PERCLK3_EN        (1<<18)
# define PCCR0_SSI1_BAUD_EN      (1<<17)
# define PCCR0_SSI2_BAUD_EN      (1<<16)
# define PCCR0_EMMA_EN           (1<<15)
# define PCCR0_USBOTG_EN         (1<<14)
# define PCCR0_DMA_EN            (1<<13)
# define PCCR0_I2C_EN            (1<<12)
# define PCCR0_GPIO_EN           (1<<11)
# define PCCR0_SDHC2_EN          (1<<10)
# define PCCR0_SDHC1_EN          (1<<9)
# define PCCR0_FIRI_EN           (1<<8)
# define PCCR0_SSI2_EN           (1<<7)
# define PCCR0_SSI1_EN           (1<<6)
# define PCCR0_CSPI2_EN          (1<<5)
# define PCCR0_CSPI1_EN          (1<<4)
# define PCCR0_UART4_EN          (1<<3)
# define PCCR0_UART3_EN          (1<<2)
# define PCCR0_UART2_EN          (1<<1)
# define PCCR0_UART1_EN          (1<<0)
  
# define PCCR1                   __REG(IMX_CRM_BASE + 0x24)
# define PCCR1_OWIRE_EN          (1<<31)
# define PCCR1_KPP_EN            (1<<30)
# define PCCR1_RTC_EN            (1<<29)
# define PCCR1_PWM_EN            (1<<28)
# define PCCR1_GPT3_EN           (1<<27)
# define PCCR1_GPT2_EN           (1<<26)
# define PCCR1_GPT1_EN           (1<<25)
# define PCCR1_WDT_EN            (1<<24)
# define PCCR1_CSPI3_EN          (1<<23)
# define PCCR1_RTIC_EN           (1<<22)
# define PCCR1_RNGA_EN           (1<<21)
  
# define CCSR                    __REG(IMX_CRM_BASE + 0x28)
# define CCSR_32K_SR             (1<<15)
# define CCSR_CLK0_SEL(x)        (((x) & 0x1f) << 0)

# define WKGDCTL                 __REG(IMX_CRM_BASE + 0x34)
# define WKGDCTL_WKDG_EN         (1<<0)
#endif /* defined(CONFIG_ARCH_IMX21) */

//#########################################		
//# KPP                                   #		
//# $1000_8000 to $1000_8FFF              #		
//#########################################		
//#define KPP_BASE_ADDR	0x10008000	
#define KPCR			__REG16(IMX_KPP_BASE+0x00)	//  16bit kpp keypad control reg
#define KPSR			__REG16(IMX_KPP_BASE+0x02)	//  16bit kpp keypad status reg
#define KDDR			__REG16(IMX_KPP_BASE+0x04)	//  16bit kpp keypad data directon reg
#define KPDR			__REG16(IMX_KPP_BASE+0x06)	//  16bit kpp keypad data reg

#define GPIOA	0
#define GPIOB	1
#define GPIOC	2
#define GPIOD	3
#define GPIOE	4
#define GPIOF	5

/*
 *  GPIO Module and I/O Multiplexer
 *  x = 0..3 for reg_A, reg_B, reg_C, reg_D, reg_E, reg_F
 */
#define DDIR(x)    __REG2(IMX_GPIO_BASE + 0x00, ((x) & 7) << 8)
#define OCR1(x)    __REG2(IMX_GPIO_BASE + 0x04, ((x) & 7) << 8)
#define OCR2(x)    __REG2(IMX_GPIO_BASE + 0x08, ((x) & 7) << 8)
#define ICONFA1(x) __REG2(IMX_GPIO_BASE + 0x0c, ((x) & 7) << 8)
#define ICONFA2(x) __REG2(IMX_GPIO_BASE + 0x10, ((x) & 7) << 8)
#define ICONFB1(x) __REG2(IMX_GPIO_BASE + 0x14, ((x) & 7) << 8)
#define ICONFB2(x) __REG2(IMX_GPIO_BASE + 0x18, ((x) & 7) << 8)
#define DR(x)      __REG2(IMX_GPIO_BASE + 0x1c, ((x) & 7) << 8)
#define GIUS(x)    __REG2(IMX_GPIO_BASE + 0x20, ((x) & 7) << 8)
#define SSR(x)     __REG2(IMX_GPIO_BASE + 0x24, ((x) & 7) << 8)
#define ICR1(x)    __REG2(IMX_GPIO_BASE + 0x28, ((x) & 7) << 8)
#define ICR2(x)    __REG2(IMX_GPIO_BASE + 0x2c, ((x) & 7) << 8)
#define IMR(x)     __REG2(IMX_GPIO_BASE + 0x30, ((x) & 7) << 8)
#define ISR(x)     __REG2(IMX_GPIO_BASE + 0x34, ((x) & 7) << 8)
#define GPR(x)     __REG2(IMX_GPIO_BASE + 0x38, ((x) & 7) << 8)
#define SWR(x)     __REG2(IMX_GPIO_BASE + 0x3c, ((x) & 7) << 8)
#define PUEN(x)    __REG2(IMX_GPIO_BASE + 0x40, ((x) & 7) << 8)
#define PMASK      __REG(IMX_GPIO_BASE + 0x600)

/*
 *  GPIO Mode
 *
 *  The pin, port, data direction, pull-up enable, primary/alternate
 *  function, output configuration, and input configuration are encoded in a 
 *  single word as follows.
 *
 *  4:0 Pin (31-0)
 *  7:5 Port (F-A)
 *  8 Direction
 *  9 PUEN
 *  10:11 Primary Function,Alternate Function
 *  13:12 OCR
 *  15:14 ICONF
 * 
 *  [ 15 14 | 13 12 | 11 10 | 9  |  8  | 7 6 5 | 4 3 2 1 0 ]
 *  [ ICONF |  OCR  | P/A   | PU | Dir | Port  |    Pin    ]
 */

#define GPIO_PIN_MASK           0x1f
#define GPIO_PORT_POS           5
#define GPIO_PORT_MASK          (0x3 << GPIO_PORT_POS)

#define GPIO_PORTA              (0<<GPIO_PORT_POS)
#define GPIO_PORTB              (1<<GPIO_PORT_POS)
#define GPIO_PORTC              (2<<GPIO_PORT_POS)
#define GPIO_PORTD              (3<<GPIO_PORT_POS)
#define GPIO_PORTE              (4<<GPIO_PORT_POS)
#define GPIO_PORTF              (5<<GPIO_PORT_POS)

#define GPIO_DIR_MASK           (1<<8)
#define GPIO_IN                 (0<<8)
#define GPIO_OUT                (1<<8)

#define GPIO_PU_MASK            (1<<9)
#define GPIO_PUDIS              (0<<9)
#define GPIO_PUEN               (1<<9)

#define GPIO_FUNC_MASK          (0x3<<10)
#define GPIO_PF                 (0<<10)
#define GPIO_AF                 (1<<10)

#define GPIO_OCR_POS            12
#define GPIO_OCR_MASK           (3<<GPIO_OCR_POS)
#define GPIO_AIN                (0<<GPIO_OCR_POS)
#define GPIO_BIN                (1<<GPIO_OCR_POS)
#define GPIO_CIN                (2<<GPIO_OCR_POS)
#define GPIO_GPIO               (3<<GPIO_OCR_POS)

#define GPIO_ICONF_MASK         (0x3<<14)
#define GPIO_AOUT               (1<<14)
#define GPIO_BOUT               (2<<14)

/*
 *  The GPIO pin naming convention was developed by the original 
 *  unknown author.  Although using defines for variables is always 
 *  a good idea for portability,  in this case the names are as specific 
 *  as the values, and thus lose their portability. Ultimately the pin 
 *  names should be changed to reflect the signal name only.  
 *
 *  The current naming convention is as follows.
 *
 *  P(port)(pin)_(function)_(signal)
 *
 *  port = (A-F)
 *  pin = (0-31)
 *  function = (PF|AF|AIN|BIN|CIN|DR|AOUT|BOUT)
 *  signal = signal name from datasheet
 *
 *  Remember that when in GPIO mode, AIN, BIN, CIN, and DR are inputs to 
 *  the GPIO peripheral module and represent outputs to the pin. 
 *  Similarly AOUT, and BOUT are outputs from the GPIO peripheral 
 *  module and represent inputs to the physical  pin in question. 
 *  Refer to the multiplexing table in the section titled "Signal 
 *  Descriptions and Pin Assignments" in the reference manual.
 */


/* FIXME: This list is not completed. The correct directions are
 * missing on some (many) pins
 */

#if defined(CONFIG_ARCH_IMX1)

#define PA0_PF_A24           ( GPIO_PORTA | GPIO_PF | 0 )
#define PA0_AIN_SPI2_CLK     ( GPIO_PORTA | GPIO_OUT | GPIO_AIN | 0 )
#define PA0_AF_ETMTRACESYNC  ( GPIO_PORTA | GPIO_AF | 0 )
#define PA1_AOUT_SPI2_RXD    ( GPIO_PORTA | GPIO_IN | GPIO_AOUT | 1 )
#define PA1_PF_TIN           ( GPIO_PORTA | GPIO_PF | 1 )
#define PA2_PF_PWM0          ( GPIO_PORTA | GPIO_OUT | GPIO_PF | 2 )
#define PA3_PF_CSI_MCLK      ( GPIO_PORTA | GPIO_PF | 3 )
#define PA4_PF_CSI_D0        ( GPIO_PORTA | GPIO_PF | 4 )
#define PA5_PF_CSI_D1        ( GPIO_PORTA | GPIO_PF | 5 )
#define PA6_PF_CSI_D2        ( GPIO_PORTA | GPIO_PF | 6 )
#define PA7_PF_CSI_D3        ( GPIO_PORTA | GPIO_PF | 7 )
#define PA8_PF_CSI_D4        ( GPIO_PORTA | GPIO_PF | 8 )
#define PA9_PF_CSI_D5        ( GPIO_PORTA | GPIO_PF | 9 )
#define PA10_PF_CSI_D6       ( GPIO_PORTA | GPIO_PF | 10 )
#define PA11_PF_CSI_D7       ( GPIO_PORTA | GPIO_PF | 11 )
#define PA12_PF_CSI_VSYNC    ( GPIO_PORTA | GPIO_PF | 12 )
#define PA13_PF_CSI_HSYNC    ( GPIO_PORTA | GPIO_PF | 13 )
#define PA14_PF_CSI_PIXCLK   ( GPIO_PORTA | GPIO_PF | 14 )
#define PA15_PF_I2C_SDA      ( GPIO_PORTA | GPIO_OUT | GPIO_PF | 15 )
#define PA16_PF_I2C_SCL      ( GPIO_PORTA | GPIO_OUT | GPIO_PF | 16 )
#define PA17_AF_ETMTRACEPKT4 ( GPIO_PORTA | GPIO_AF | 17 )
#define PA17_AIN_SPI2_SS     ( GPIO_PORTA | GPIO_AIN | 17 )
#define PA18_AF_ETMTRACEPKT5 ( GPIO_PORTA | GPIO_AF | 18 )
#define PA19_AF_ETMTRACEPKT6 ( GPIO_PORTA | GPIO_AF | 19 )
#define PA20_AF_ETMTRACEPKT7 ( GPIO_PORTA | GPIO_AF | 20 )
#define PA21_PF_A0           ( GPIO_PORTA | GPIO_PF | 21 )
#define PA22_PF_CS4          ( GPIO_PORTA | GPIO_PF | 22 )
#define PA23_PF_CS5          ( GPIO_PORTA | GPIO_PF | 23 )
#define PA24_PF_A16          ( GPIO_PORTA | GPIO_PF | 24 )
#define PA24_AF_ETMTRACEPKT0 ( GPIO_PORTA | GPIO_AF | 24 )
#define PA25_PF_A17          ( GPIO_PORTA | GPIO_PF | 25 )
#define PA25_AF_ETMTRACEPKT1 ( GPIO_PORTA | GPIO_AF | 25 )
#define PA26_PF_A18          ( GPIO_PORTA | GPIO_PF | 26 )
#define PA26_AF_ETMTRACEPKT2 ( GPIO_PORTA | GPIO_AF | 26 )
#define PA27_PF_A19          ( GPIO_PORTA | GPIO_PF | 27 )
#define PA27_AF_ETMTRACEPKT3 ( GPIO_PORTA | GPIO_AF | 27 )
#define PA28_PF_A20          ( GPIO_PORTA | GPIO_PF | 28 )
#define PA28_AF_ETMPIPESTAT0 ( GPIO_PORTA | GPIO_AF | 28 )
#define PA29_PF_A21          ( GPIO_PORTA | GPIO_PF | 29 )
#define PA29_AF_ETMPIPESTAT1 ( GPIO_PORTA | GPIO_AF | 29 )
#define PA30_PF_A22          ( GPIO_PORTA | GPIO_PF | 30 )
#define PA30_AF_ETMPIPESTAT2 ( GPIO_PORTA | GPIO_AF | 30 )
#define PA31_PF_A23          ( GPIO_PORTA | GPIO_PF | 31 )
#define PA31_AF_ETMTRACECLK  ( GPIO_PORTA | GPIO_AF | 31 )
#define PB8_PF_SD_DAT0       ( GPIO_PORTB | GPIO_OUT | GPIO_PF | GPIO_PUEN | 8 )
#define PB8_AF_MS_PIO        ( GPIO_PORTB | GPIO_AF | 8 )
#define PB9_PF_SD_DAT1       ( GPIO_PORTB | GPIO_OUT | GPIO_PF | GPIO_PUEN  | 9 )
#define PB9_AF_MS_PI1        ( GPIO_PORTB | GPIO_AF | 9 )
#define PB10_PF_SD_DAT2      ( GPIO_PORTB | GPIO_OUT | GPIO_PF | GPIO_PUEN  | 10 )
#define PB10_AF_MS_SCLKI     ( GPIO_PORTB | GPIO_AF | 10 )
#define PB11_PF_SD_DAT3      ( GPIO_PORTB | GPIO_OUT | GPIO_PF | 11 )
#define PB11_AF_MS_SDIO      ( GPIO_PORTB | GPIO_AF | 11 )
#define PB12_PF_SD_CLK       ( GPIO_PORTB | GPIO_OUT | GPIO_PF | 12 )
#define PB12_AF_MS_SCLK0     ( GPIO_PORTB | GPIO_AF | 12 )
#define PB13_PF_SD_CMD       ( GPIO_PORTB | GPIO_OUT | GPIO_PF | GPIO_PUEN | 13 )
#define PB13_AF_MS_BS        ( GPIO_PORTB | GPIO_AF | 13 )
#define PB14_AF_SSI_RXFS     ( GPIO_PORTB | GPIO_AF | 14 )
#define PB15_AF_SSI_RXCLK    ( GPIO_PORTB | GPIO_AF | 15 )
#define PB16_AF_SSI_RXDAT    ( GPIO_PORTB | GPIO_IN | GPIO_AF | 16 )
#define PB17_AF_SSI_TXDAT    ( GPIO_PORTB | GPIO_OUT | GPIO_AF | 17 )
#define PB18_AF_SSI_TXFS     ( GPIO_PORTB | GPIO_AF | 18 )
#define PB19_AF_SSI_TXCLK    ( GPIO_PORTB | GPIO_AF | 19 )
#define PB20_PF_USBD_AFE     ( GPIO_PORTB | GPIO_PF | 20 )
#define PB21_PF_USBD_OE      ( GPIO_PORTB | GPIO_PF | 21 )
#define PB22_PFUSBD_RCV      ( GPIO_PORTB | GPIO_PF | 22 )
#define PB23_PF_USBD_SUSPND  ( GPIO_PORTB | GPIO_PF | 23 )
#define PB24_PF_USBD_VP      ( GPIO_PORTB | GPIO_PF | 24 )
#define PB25_PF_USBD_VM      ( GPIO_PORTB | GPIO_PF | 25 )
#define PB26_PF_USBD_VPO     ( GPIO_PORTB | GPIO_PF | 26 )
#define PB27_PF_USBD_VMO     ( GPIO_PORTB | GPIO_PF | 27 )
#define PB28_PF_UART2_CTS    ( GPIO_PORTB | GPIO_OUT | GPIO_PF | 28 )
#define PB29_PF_UART2_RTS    ( GPIO_PORTB | GPIO_IN | GPIO_PF | 29 )
#define PB30_PF_UART2_TXD    ( GPIO_PORTB | GPIO_OUT | GPIO_PF | 30 )
#define PB31_PF_UART2_RXD    ( GPIO_PORTB | GPIO_IN | GPIO_PF | 31 )
#define PC3_PF_SSI_RXFS      ( GPIO_PORTC | GPIO_PF | 3 )
#define PC4_PF_SSI_RXCLK     ( GPIO_PORTC | GPIO_PF | 4 )
#define PC5_PF_SSI_RXDAT     ( GPIO_PORTC | GPIO_IN | GPIO_PF | 5 )
#define PC6_PF_SSI_TXDAT     ( GPIO_PORTC | GPIO_OUT | GPIO_PF | 6 )
#define PC7_PF_SSI_TXFS      ( GPIO_PORTC | GPIO_PF | 7 )
#define PC8_PF_SSI_TXCLK     ( GPIO_PORTC | GPIO_PF | 8 )
#define PC9_PF_UART1_CTS     ( GPIO_PORTC | GPIO_OUT | GPIO_PF | 9 )
#define PC10_PF_UART1_RTS    ( GPIO_PORTC | GPIO_IN | GPIO_PF | 10 )
#define PC11_PF_UART1_TXD    ( GPIO_PORTC | GPIO_OUT | GPIO_PF | 11 )
#define PC12_PF_UART1_RXD    ( GPIO_PORTC | GPIO_IN | GPIO_PF | 12 )
#define PC13_PF_SPI1_SPI_RDY ( GPIO_PORTC | GPIO_PF | 13 )
#define PC14_PF_SPI1_SCLK    ( GPIO_PORTC | GPIO_PF | 14 )
#define PC15_PF_SPI1_SS      ( GPIO_PORTC | GPIO_PF | 15 )
#define PC16_PF_SPI1_MISO    ( GPIO_PORTC | GPIO_PF | 16 )
#define PC17_PF_SPI1_MOSI    ( GPIO_PORTC | GPIO_PF | 17 )
#define PD6_PF_LSCLK         ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 6 )
#define PD7_PF_REV           ( GPIO_PORTD | GPIO_PF | 7 )
#define PD7_AF_UART2_DTR     ( GPIO_PORTD | GPIO_IN | GPIO_AF | 7 )
#define PD7_AIN_SPI2_SCLK    ( GPIO_PORTD | GPIO_AIN | 7 )
#define PD8_PF_CLS           ( GPIO_PORTD | GPIO_PF | 8 )
#define PD8_AF_UART2_DCD     ( GPIO_PORTD | GPIO_OUT | GPIO_AF | 8 )
#define PD8_AIN_SPI2_SS      ( GPIO_PORTD | GPIO_AIN | 8 )
#define PD9_PF_PS            ( GPIO_PORTD | GPIO_PF | 9 )
#define PD9_AF_UART2_RI      ( GPIO_PORTD | GPIO_OUT | GPIO_AF | 9 )
#define PD9_AOUT_SPI2_RXD    ( GPIO_PORTD | GPIO_IN | GPIO_AOUT | 9 )
#define PD10_PF_SPL_SPR      ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 10 )
#define PD10_AF_UART2_DSR    ( GPIO_PORTD | GPIO_OUT | GPIO_AF | 10 )
#define PD10_AIN_SPI2_TXD    ( GPIO_PORTD | GPIO_OUT | GPIO_AIN | 10 )
#define PD11_PF_CONTRAST     ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 11 )
#define PD12_PF_ACD_OE       ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 12 )
#define PD13_PF_LP_HSYNC     ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 13 )
#define PD14_PF_FLM_VSYNC    ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 14 )
#define PD15_PF_LD0          ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 15 )
#define PD16_PF_LD1          ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 16 )
#define PD17_PF_LD2          ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 17 )
#define PD18_PF_LD3          ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 18 )
#define PD19_PF_LD4          ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 19 )
#define PD20_PF_LD5          ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 20 )
#define PD21_PF_LD6          ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 21 )
#define PD22_PF_LD7          ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 22 )
#define PD23_PF_LD8          ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 23 )
#define PD24_PF_LD9          ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 24 )
#define PD25_PF_LD10         ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 25 )
#define PD26_PF_LD11         ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 26 )
#define PD27_PF_LD12         ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 27 )
#define PD28_PF_LD13         ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 28 )
#define PD29_PF_LD14         ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 29 )
#define PD30_PF_LD15         ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 30 )
#define PD31_PF_TMR2OUT      ( GPIO_PORTD | GPIO_PF | 31 )
#define PD31_BIN_SPI2_TXD    ( GPIO_PORTD | GPIO_BIN | 31 )

#elif defined (CONFIG_ARCH_IMX21)
   
#define PE14_PF_UART1_CTS       ( GPIO_PORTE | 14 | GPIO_PF | GPIO_OUT )
#define PE15_PF_UART1_RTS       ( GPIO_PORTE | 15 | GPIO_PF | GPIO_IN )
#define PE12_PF_UART1_TXD       ( GPIO_PORTE | 12 | GPIO_PF | GPIO_OUT )
#define PE13_PF_UART1_RXD       ( GPIO_PORTE | 13 | GPIO_PF | GPIO_IN )

#define PA5_PF_LSCLK            ( GPIO_PORTA | 5 | GPIO_PF | GPIO_OUT )
#define PA6_PF_LD0              ( GPIO_PORTA | 6 | GPIO_PF | GPIO_OUT )
#define PA7_PF_LD1              ( GPIO_PORTA | 7 | GPIO_PF | GPIO_OUT )
#define PA8_PF_LD2              ( GPIO_PORTA | 8 | GPIO_PF | GPIO_OUT )
#define PA9_PF_LD3              ( GPIO_PORTA | 9 | GPIO_PF | GPIO_OUT )
#define PA10_PF_LD4             ( GPIO_PORTA | 10 | GPIO_PF | GPIO_OUT )
#define PA11_PF_LD5             ( GPIO_PORTA | 11 | GPIO_PF | GPIO_OUT )
#define PA12_PF_LD6             ( GPIO_PORTA | 12 | GPIO_PF | GPIO_OUT )
#define PA13_PF_LD7             ( GPIO_PORTA | 13 | GPIO_PF | GPIO_OUT )
#define PA14_PF_LD8             ( GPIO_PORTA | 14 | GPIO_PF | GPIO_OUT )
#define PA15_PF_LD9             ( GPIO_PORTA | 15 | GPIO_PF | GPIO_OUT )
#define PA16_PF_LD10            ( GPIO_PORTA | 16 | GPIO_PF | GPIO_OUT )
#define PA17_PF_LD11            ( GPIO_PORTA | 17 | GPIO_PF | GPIO_OUT )
#define PA18_PF_LD12            ( GPIO_PORTA | 18 | GPIO_PF | GPIO_OUT )
#define PA19_PF_LD13            ( GPIO_PORTA | 19 | GPIO_PF | GPIO_OUT )
#define PA20_PF_LD14            ( GPIO_PORTA | 20 | GPIO_PF | GPIO_OUT )
#define PA21_PF_LD15            ( GPIO_PORTA | 21 | GPIO_PF | GPIO_OUT )
#define PA22_PF_LD16            ( GPIO_PORTA | 22 | GPIO_PF | GPIO_OUT )
#define PA23_PF_LD17            ( GPIO_PORTA | 23 | GPIO_PF | GPIO_OUT )
#define PA24_PF_REV             ( GPIO_PORTA | 24 | GPIO_PF | GPIO_OUT )
#define PA25_PF_CLS             ( GPIO_PORTA | 25 | GPIO_PF | GPIO_OUT )
#define PA26_PF_PS              ( GPIO_PORTA | 26 | GPIO_PF | GPIO_OUT )
#define PA27_PF_SPL_SPR         ( GPIO_PORTA | 27 | GPIO_PF | GPIO_OUT )
#define PA28_PF_LP_HSYNC        ( GPIO_PORTA | 28 | GPIO_PF | GPIO_OUT )
#define PA29_PF_FLM_VSYNC       ( GPIO_PORTA | 29 | GPIO_PF | GPIO_OUT )
#define PA30_PF_CONTRAST        ( GPIO_PORTA | 30 | GPIO_PF | GPIO_OUT )
#define PA31_PF_ACD_OE          ( GPIO_PORTA | 31 | GPIO_PF | GPIO_OUT )
#define PE18_PF_SD_DAT0   ( GPIO_PORTE | GPIO_OUT | GPIO_PF | GPIO_PUEN | 18 )
#define PE19_PF_SD_DAT1   ( GPIO_PORTE | GPIO_OUT | GPIO_PF | GPIO_PUEN | 19 )
#define PE20_PF_SD_DAT2   ( GPIO_PORTE | GPIO_OUT | GPIO_PF | GPIO_PUEN | 20 )
#define PE21_PF_SD_DAT3   ( GPIO_PORTE | GPIO_OUT | GPIO_PF | GPIO_PUEN | 21 )
#define PE23_PF_SD_CLK    ( GPIO_PORTE | GPIO_OUT | GPIO_PF | 23 )
#define PE22_PF_SD_CMD    ( GPIO_PORTE | GPIO_OUT | GPIO_PF | GPIO_PUEN | 22 )

#define PD17_PF_I2C_SDA      ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 17 )
#define PD18_PF_I2C_SCL      ( GPIO_PORTD | GPIO_OUT | GPIO_PF | 18 )

#endif /* defined(CONFIG_ARCH_IMX21) */

/*
 *  Watchdog Timer
 */
#if defined(CONFIG_ARCH_IMX1)
# define WCR         __REG(IMX_WDT_BASE + 0x00)
# define WSR         __REG(IMX_WDT_BASE + 0x04)
# define WSTR        __REG(IMX_WDT_BASE + 0x08)
# define WCR_WHALT   (1 << 16)
# define WCR_WT(x)   (((x) & 0x7f) << 8)
# define WCR_WT_MASK (0x7f << 8)
# define WCR_WIE     (1 << 4)
# define WCR_TMD     (1 << 3)
# define WCR_SWR     (1 << 2)
# define WCR_WDEC    (1 << 1)
# define WCR_WDE     (1 << 0)
# define WSTR_TINT   (1 << 8)
# define WSTR_TOUT   (1 << 0)
#elif defined(CONFIG_ARCH_IMX21)
# define WCR         __REG16(IMX_WDT_BASE + 0x00)
# define WSR         __REG16(IMX_WDT_BASE + 0x02)
# define WRSR        __REG16(IMX_WDT_BASE + 0x04)
# define WCR_WT(x)   (((x) & 0xff) << 8)
# define WCR_WT_MASK (0xff << 8)
# define WCR_WDA     (1 << 5)
# define WCR_SRS     (1 << 4)
# define WCR_WRE     (1 << 3)
# define WCR_WDE     (1 << 2)
# define WCR_WDBG    (1 << 1)
# define WCR_WDZST   (1 << 0)
# define WRSR_PWR    (1 << 4)
# define WRSR_EXT    (1 << 3)
# define WRSR_TOUT   (1 << 1)
# define WRSR_SFTW   (1 << 0)
#endif /* defined(CONFIG_ARCH_IMX21) */


/*
 *  DMA Controller
 */
#define DCR       __REG(IMX_DMAC_BASE +0x00)	/* DMA Control Register */
#define DISR      __REG(IMX_DMAC_BASE +0x04)	/* DMA Interrupt status Register */
#define DIMR      __REG(IMX_DMAC_BASE +0x08)	/* DMA Interrupt mask Register */
#define DBTOSR    __REG(IMX_DMAC_BASE +0x0c)	/* DMA Burst timeout status Register */
#define DRTOSR    __REG(IMX_DMAC_BASE +0x10)	/* DMA Request timeout Register */
#define DSESR     __REG(IMX_DMAC_BASE +0x14)	/* DMA Transfer Error Status Register */
#define DBOSR     __REG(IMX_DMAC_BASE +0x18)	/* DMA Buffer overflow status Register */
#define DBTOCR    __REG(IMX_DMAC_BASE +0x1c)	/* DMA Burst timeout control Register */
#define WSRA      __REG(IMX_DMAC_BASE +0x40)	/* W-Size Register A */
#define XSRA      __REG(IMX_DMAC_BASE +0x44)	/* X-Size Register A */
#define YSRA      __REG(IMX_DMAC_BASE +0x48)	/* Y-Size Register A */
#define WSRB      __REG(IMX_DMAC_BASE +0x4c)	/* W-Size Register B */
#define XSRB      __REG(IMX_DMAC_BASE +0x50)	/* X-Size Register B */
#define YSRB      __REG(IMX_DMAC_BASE +0x54)	/* Y-Size Register B */
#define SAR(x)    __REG2( IMX_DMAC_BASE + 0x80, (x) << 6)	/* Source Address Registers */
#define DAR(x)    __REG2( IMX_DMAC_BASE + 0x84, (x) << 6)	/* Destination Address Registers */
#define CNTR(x)   __REG2( IMX_DMAC_BASE + 0x88, (x) << 6)	/* Count Registers */
#define CCR(x)    __REG2( IMX_DMAC_BASE + 0x8c, (x) << 6)	/*?Control Registers */
#define RSSR(x)   __REG2( IMX_DMAC_BASE + 0x90, (x) << 6)	/* Request source select Registers */
#define BLR(x)    __REG2( IMX_DMAC_BASE + 0x94, (x) << 6)	/* Burst length Registers */
#define RTOR(x)   __REG2( IMX_DMAC_BASE + 0x98, (x) << 6)	/* Request timeout Registers */
#define BUCR(x)   __REG2( IMX_DMAC_BASE + 0x98, (x) << 6)	/* Bus Utilization Registers */
#define CHCNTR(x) __REG2( IMX_DMAC_BASE + 0x9c, (x) << 6)  /* On IMX21 only */
#define CCNR(x)   __REG2( IMX_DMAC_BASE + 0x9C, (x) << 6) /* for sound driver -kcr */
#define DMA_CH_BASE(x)	(IMX_DMAC_BASE+0x080+0x040*(x))   /* for sound driver kcr */

#define DCR_DAM            (1<<2)  /* On IMX21 only */
#define DCR_DRST           (1<<1)
#define DCR_DEN            (1<<0)
#define DBTOCR_EN          (1<<15)
#define DBTOCR_CNT(x)      ((x) & 0x7fff )
#define CNTR_CNT(x)        ((x) & 0xffffff )
#define CCR_ACRPT          ( 0x1 << 14 )  /* On IMX21 only */
#define CCR_DMOD_LINEAR    ( 0x0 << 12 )
#define CCR_DMOD_2D        ( 0x1 << 12 )
#define CCR_DMOD_FIFO      ( 0x2 << 12 )
#define CCR_DMOD_EOBFIFO   ( 0x3 << 12 )
#define CCR_SMOD_LINEAR    ( 0x0 << 10 )
#define CCR_SMOD_2D        ( 0x1 << 10 )
#define CCR_SMOD_FIFO      ( 0x2 << 10 )
#define CCR_SMOD_EOBFIFO   ( 0x3 << 10 )
#define CCR_MDIR_INC       (0<<9)
#define CCR_MDIR_DEC       (1<<9)
#define CCR_MSEL_A         (0<<8)
#define CCR_MSEL_B         (1<<8)
#define CCR_DSIZ_32        ( 0x0 << 6 )
#define CCR_DSIZ_8         ( 0x1 << 6 )
#define CCR_DSIZ_16        ( 0x2 << 6 )
#define CCR_SSIZ_32        ( 0x0 << 4 )
#define CCR_SSIZ_8         ( 0x1 << 4 )
#define CCR_SSIZ_16        ( 0x2 << 4 )
#define CCR_REN            (1<<3)
#define CCR_RPT            (1<<2)
#define CCR_FRC            (1<<1)
#define CCR_CEN            (1<<0)
#define RTOR_EN            (1<<15)
#define RTOR_CLK           (1<<14)
#define RTOR_PSC           (1<<13)

/*
 *  General purpose timers
 */
#define IMX_TCTL(x)        __REG( 0x00 + (x))
#define TCTL_SWR           (1<<15)
#define TCTL_FRR           (1<<8)
#define TCTL_CAP_RIS       (1<<6)
#define TCTL_CAP_FAL       (2<<6)
#define TCTL_CAP_RIS_FAL   (3<<6)
#define TCTL_OM            (1<<5)
#define TCTL_IRQEN         (1<<4)
#define TCTL_CLK_PCLK1     (1<<1)
#define TCTL_CLK_PCLK1_16  (2<<1)
#define TCTL_CLK_TIN       (3<<1)
#define TCTL_CLK_32        (4<<1)
#define TCTL_TEN           (1<<0)

#define IMX_TPRER(x)       __REG( 0x04 + (x))
#define IMX_TCMP(x)        __REG( 0x08 + (x))
#define IMX_TCR(x)         __REG( 0x0C + (x))
#define IMX_TCN(x)         __REG( 0x10 + (x))
#define IMX_TSTAT(x)       __REG( 0x14 + (x))
#define TSTAT_CAPT         (1<<1)
#define TSTAT_COMP         (1<<0)

#if defined(CONFIG_ARCH_IMX1)

/*
 *  Interrupt controller
 */

#define IMX_INTCNTL        __REG(IMX_AITC_BASE+0x00)
#define INTCNTL_FIAD       (1<<19)
#define INTCNTL_NIAD       (1<<20)

#define IMX_NIMASK         __REG(IMX_AITC_BASE+0x04)
#define IMX_INTENNUM       __REG(IMX_AITC_BASE+0x08)
#define IMX_INTDISNUM      __REG(IMX_AITC_BASE+0x0c)
#define IMX_INTENABLEH     __REG(IMX_AITC_BASE+0x10)
#define IMX_INTENABLEL     __REG(IMX_AITC_BASE+0x14)

/*
 *  General purpose timers
 */
#define IMX_TCTL(x)        __REG( 0x00 + (x))
#define TCTL_SWR           (1<<15)
#define TCTL_FRR           (1<<8)
#define TCTL_CAP_RIS       (1<<6)
#define TCTL_CAP_FAL       (2<<6)
#define TCTL_CAP_RIS_FAL   (3<<6)
#define TCTL_OM            (1<<5)
#define TCTL_IRQEN         (1<<4)
#define TCTL_CLK_PCLK1     (1<<1)
#define TCTL_CLK_PCLK1_16  (2<<1)
#define TCTL_CLK_TIN       (3<<1)
#define TCTL_CLK_32        (4<<1)
#define TCTL_TEN           (1<<0)

#define IMX_TPRER(x)       __REG( 0x04 + (x))
#define IMX_TCMP(x)        __REG( 0x08 + (x))
#define IMX_TCR(x)         __REG( 0x0C + (x))
#define IMX_TCN(x)         __REG( 0x10 + (x))
#define IMX_TSTAT(x)       __REG( 0x14 + (x))
#define TSTAT_CAPT         (1<<1)
#define TSTAT_COMP         (1<<0)

/*
 * LCD Controller (for CONFIG_ARCH_IMX)
 */

#define LCDC_SSA	__REG(IMX_LCDC_BASE+0x00)

#define LCDC_SIZE	__REG(IMX_LCDC_BASE+0x04)
#define SIZE_XMAX(x)	((((x) >> 4) & 0x3f) << 20)
#define SIZE_YMAX(y)    ( (y) & 0x1ff )

#define LCDC_VPW	__REG(IMX_LCDC_BASE+0x08)
#define VPW_VPW(x)	( (x) & 0x3ff )

#define LCDC_CPOS	__REG(IMX_LCDC_BASE+0x0C)
#define CPOS_CC1        (1<<31)
#define CPOS_CC0        (1<<30)
#define CPOS_OP         (1<<28)
#define CPOS_CXP(x)     (((x) & 3ff) << 16)
#define CPOS_CYP(y)     ((y) & 0x1ff)

#define LCDC_LCWHB	__REG(IMX_LCDC_BASE+0x10)
#define LCWHB_BK_EN     (1<<31)
#define LCWHB_CW(w)     (((w) & 0x1f) << 24)
#define LCWHB_CH(h)     (((h) & 0x1f) << 16)
#define LCWHB_BD(x)     ((x) & 0xff)

#define LCDC_LCHCC	__REG(IMX_LCDC_BASE+0x14)
#define LCHCC_CUR_COL_R(r) (((r) & 0x1f) << 11)
#define LCHCC_CUR_COL_G(g) (((g) & 0x3f) << 5)
#define LCHCC_CUR_COL_B(b) ((b) & 0x1f)

#define LCDC_PCR	__REG(IMX_LCDC_BASE+0x18)
#define PCR_TFT         (1<<31)
#define PCR_COLOR       (1<<30)
#define PCR_PBSIZ_1     (0<<28)
#define PCR_PBSIZ_2     (1<<28)
#define PCR_PBSIZ_4     (2<<28)
#define PCR_PBSIZ_8     (3<<28)
#define PCR_BPIX_1      (0<<25)
#define PCR_BPIX_2      (1<<25)
#define PCR_BPIX_4      (2<<25)
#define PCR_BPIX_8      (3<<25)
#define PCR_BPIX_12     (4<<25)
#define PCR_BPIX_16     (4<<25)
#define PCR_PIXPOL      (1<<24)
#define PCR_FLMPOL      (1<<23)
#define PCR_LPPOL       (1<<22)
#define PCR_CLKPOL      (1<<21)
#define PCR_OEPOL       (1<<20)
#define PCR_SCLKIDLE    (1<<19)
#define PCR_END_SEL     (1<<18)
#define PCR_END_BYTE_SWAP (1<<17)
#define PCR_REV_VS      (1<<16)
#define PCR_ACD_SEL     (1<<15)
#define PCR_ACD(x)      (((x) & 0x7f) << 8)
#define PCR_SCLK_SEL    (1<<7)
#define PCR_SHARP       (1<<6)
#define PCR_PCD(x)      ((x) & 0x3f)

#define LCDC_HCR	__REG(IMX_LCDC_BASE+0x1C)
#define HCR_H_WIDTH(x)  (((x) & 0x3f) << 26)
#define HCR_H_WAIT_1(x) (((x) & 0xff) << 8)
#define HCR_H_WAIT_2(x) ((x) & 0xff)

#define LCDC_VCR	__REG(IMX_LCDC_BASE+0x20)
#define VCR_V_WIDTH(x)  (((x) & 0x3f) << 26)
#define VCR_V_WAIT_1(x) (((x) & 0xff) << 8)
#define VCR_V_WAIT_2(x) ((x) & 0xff)

#define LCDC_POS	__REG(IMX_LCDC_BASE+0x24)
#define POS_POS(x)      ((x) & 1f)

#define LCDC_LSCR1	__REG(IMX_LCDC_BASE+0x28)
#define LSCR1_PS_RISE_DELAY(x)    (((x) & 0x7f) << 26)
#define LSCR1_CLS_RISE_DELAY(x)   (((x) & 0x3f) << 16)
#define LSCR1_REV_TOGGLE_DELAY(x) (((x) & 0xf) << 8)
#define LSCR1_GRAY2(x)            (((x) & 0xf) << 4)
#define LSCR1_GRAY1(x)            (((x) & 0xf))

#define LCDC_PWMR	__REG(IMX_LCDC_BASE+0x2C)
#define PWMR_CLS(x)     (((x) & 0x1ff) << 16)
#define PWMR_LDMSK      (1<<15)
#define PWMR_SCR1       (1<<10)
#define PWMR_SCR0       (1<<9)
#define PWMR_CC_EN      (1<<8)
#define PWMR_PW(x)      ((x) & 0xff)

#define LCDC_DMACR	__REG(IMX_LCDC_BASE+0x30)
#define DMACR_BURST     (1<<31)
#define DMACR_HM(x)     (((x) & 0xf) << 16)
#define DMACR_TM(x)     ((x) &0xf)

#define LCDC_RMCR	__REG(IMX_LCDC_BASE+0x34)
#define RMCR_LCDC_EN		(1<<1)
#define RMCR_SELF_REF		(1<<0)

#define LCDC_LCDICR	__REG(IMX_LCDC_BASE+0x38)
#define LCDICR_INT_SYN  (1<<2)
#define LCDICR_INT_CON  (1)

#define LCDC_LCDISR	__REG(IMX_LCDC_BASE+0x40)
#define LCDISR_UDR_ERR (1<<3)
#define LCDISR_ERR_RES (1<<2)
#define LCDISR_EOF     (1<<1)
#define LCDISR_BOF     (1<<0)

#define LCDC_PALETTE(x) __REG2(IMX_LCDC_BASE+0x800, (x)<<2)

/*
 *  UART Module. Takes the UART base address as argument
 */
#define URXD0(x) __REG( 0x0 + (x)) /* Receiver Register */
#define URTX0(x) __REG( 0x40 + (x)) /* Transmitter Register */
#define UCR1(x)  __REG( 0x80 + (x)) /* Control Register 1 */
#define UCR2(x)  __REG( 0x84 + (x)) /* Control Register 2 */
#define UCR3(x)  __REG( 0x88 + (x)) /* Control Register 3 */
#define UCR4(x)  __REG( 0x8c + (x)) /* Control Register 4 */
#define UFCR(x)  __REG( 0x90 + (x)) /* FIFO Control Register */
#define USR1(x)  __REG( 0x94 + (x)) /* Status Register 1 */
#define USR2(x)  __REG( 0x98 + (x)) /* Status Register 2 */
#define UESC(x)  __REG( 0x9c + (x)) /* Escape Character Register */
#define UTIM(x)  __REG( 0xa0 + (x)) /* Escape Timer Register */
#define UBIR(x)  __REG( 0xa4 + (x)) /* BRM Incremental Register */
#define UBMR(x)  __REG( 0xa8 + (x)) /* BRM Modulator Register */
#define UBRC(x)  __REG( 0xac + (x)) /* Baud Rate Count Register */
#define BIPR1(x) __REG( 0xb0 + (x)) /* Incremental Preset Register 1 */
#define BIPR2(x) __REG( 0xb4 + (x)) /* Incremental Preset Register 2 */
#define BIPR3(x) __REG( 0xb8 + (x)) /* Incremental Preset Register 3 */
#define BIPR4(x) __REG( 0xbc + (x)) /* Incremental Preset Register 4 */
#define BMPR1(x) __REG( 0xc0 + (x)) /* BRM Modulator Register 1 */
#define BMPR2(x) __REG( 0xc4 + (x)) /* BRM Modulator Register 2 */
#define BMPR3(x) __REG( 0xc8 + (x)) /* BRM Modulator Register 3 */
#define BMPR4(x) __REG( 0xcc + (x)) /* BRM Modulator Register 4 */
#define UTS(x)   __REG( 0xd0 + (x)) /* UART Test Register */

/* UART Control Register Bit Fields.*/
#define  URXD_CHARRDY    (1<<15)
#define  URXD_ERR        (1<<14)
#define  URXD_OVRRUN     (1<<13)
#define  URXD_FRMERR     (1<<12)
#define  URXD_BRK        (1<<11)
#define  URXD_PRERR      (1<<10)
#define  UCR1_ADEN       (1<<15) /* Auto dectect interrupt */
#define  UCR1_ADBR       (1<<14) /* Auto detect baud rate */
#define  UCR1_TRDYEN     (1<<13) /* Transmitter ready interrupt enable */
#define  UCR1_IDEN       (1<<12) /* Idle condition interrupt */
#define  UCR1_RRDYEN     (1<<9)	 /* Recv ready interrupt enable */
#define  UCR1_RDMAEN     (1<<8)	 /* Recv ready DMA enable */
#define  UCR1_IREN       (1<<7)	 /* Infrared interface enable */
#define  UCR1_TXMPTYEN   (1<<6)	 /* Transimitter empty interrupt enable */
#define  UCR1_RTSDEN     (1<<5)	 /* RTS delta interrupt enable */
#define  UCR1_SNDBRK     (1<<4)	 /* Send break */
#define  UCR1_TDMAEN     (1<<3)	 /* Transmitter ready DMA enable */
#define  UCR1_UARTCLKEN  (1<<2)	 /* UART clock enabled */
#define  UCR1_DOZE       (1<<1)	 /* Doze */
#define  UCR1_UARTEN     (1<<0)	 /* UART enabled */
#define  UCR2_ESCI     	 (1<<15) /* Escape seq interrupt enable */
#define  UCR2_IRTS  	 (1<<14) /* Ignore RTS pin */
#define  UCR2_CTSC  	 (1<<13) /* CTS pin control */
#define  UCR2_CTS        (1<<12) /* Clear to send */
#define  UCR2_ESCEN      (1<<11) /* Escape enable */
#define  UCR2_PREN       (1<<8)  /* Parity enable */
#define  UCR2_PROE       (1<<7)  /* Parity odd/even */
#define  UCR2_STPB       (1<<6)	 /* Stop */
#define  UCR2_WS         (1<<5)	 /* Word size */
#define  UCR2_RTSEN      (1<<4)	 /* Request to send interrupt enable */
#define  UCR2_TXEN       (1<<2)	 /* Transmitter enabled */
#define  UCR2_RXEN       (1<<1)	 /* Receiver enabled */
#define  UCR2_SRST 	 (1<<0)	 /* SW reset */
#define  UCR3_DTREN 	 (1<<13) /* DTR interrupt enable */
#define  UCR3_PARERREN   (1<<12) /* Parity enable */
#define  UCR3_FRAERREN   (1<<11) /* Frame error interrupt enable */
#define  UCR3_DSR        (1<<10) /* Data set ready */
#define  UCR3_DCD        (1<<9)  /* Data carrier detect */
#define  UCR3_RI         (1<<8)  /* Ring indicator */
#define  UCR3_TIMEOUTEN  (1<<7)  /* Timeout interrupt enable */
#define  UCR3_RXDSEN	 (1<<6)  /* Receive status interrupt enable */
#define  UCR3_AIRINTEN   (1<<5)  /* Async IR wake interrupt enable */
#define  UCR3_AWAKEN	 (1<<4)  /* Async wake interrupt enable */
#define  UCR3_REF25 	 (1<<3)  /* Ref freq 25 MHz */
#define  UCR3_REF30 	 (1<<2)  /* Ref Freq 30 MHz */
#define  UCR3_INVT  	 (1<<1)  /* Inverted Infrared transmission */
#define  UCR3_BPEN  	 (1<<0)  /* Preset registers enable */
#define  UCR4_CTSTL_32   (32<<10) /* CTS trigger level (32 chars) */
#define  UCR4_INVR  	 (1<<9)  /* Inverted infrared reception */
#define  UCR4_ENIRI 	 (1<<8)  /* Serial infrared interrupt enable */
#define  UCR4_WKEN  	 (1<<7)  /* Wake interrupt enable */
#define  UCR4_REF16 	 (1<<6)  /* Ref freq 16 MHz */
#define  UCR4_IRSC  	 (1<<5)  /* IR special case */
#define  UCR4_TCEN  	 (1<<3)  /* Transmit complete interrupt enable */
#define  UCR4_BKEN  	 (1<<2)  /* Break condition interrupt enable */
#define  UCR4_OREN  	 (1<<1)  /* Receiver overrun interrupt enable */
#define  UCR4_DREN  	 (1<<0)  /* Recv data ready interrupt enable */
#define  UFCR_RXTL_SHF   0       /* Receiver trigger level shift */
#define  UFCR_RFDIV      (7<<7)  /* Reference freq divider mask */
#define  UFCR_TXTL_SHF   10      /* Transmitter trigger level shift */
#define  USR1_PARITYERR  (1<<15) /* Parity error interrupt flag */
#define  USR1_RTSS  	 (1<<14) /* RTS pin status */
#define  USR1_TRDY  	 (1<<13) /* Transmitter ready interrupt/dma flag */
#define  USR1_RTSD  	 (1<<12) /* RTS delta */
#define  USR1_ESCF  	 (1<<11) /* Escape seq interrupt flag */
#define  USR1_FRAMERR    (1<<10) /* Frame error interrupt flag */
#define  USR1_RRDY       (1<<9)	 /* Receiver ready interrupt/dma flag */
#define  USR1_TIMEOUT    (1<<7)	 /* Receive timeout interrupt status */
#define  USR1_RXDS  	 (1<<6)	 /* Receiver idle interrupt flag */
#define  USR1_AIRINT	 (1<<5)	 /* Async IR wake interrupt flag */
#define  USR1_AWAKE 	 (1<<4)	 /* Aysnc wake interrupt flag */
#define  USR2_ADET  	 (1<<15) /* Auto baud rate detect complete */
#define  USR2_TXFE  	 (1<<14) /* Transmit buffer FIFO empty */
#define  USR2_DTRF  	 (1<<13) /* DTR edge interrupt flag */
#define  USR2_IDLE  	 (1<<12) /* Idle condition */
#define  USR2_IRINT 	 (1<<8)	 /* Serial infrared interrupt flag */
#define  USR2_WAKE  	 (1<<7)	 /* Wake */
#define  USR2_RTSF  	 (1<<4)	 /* RTS edge interrupt flag */
#define  USR2_TXDC  	 (1<<3)	 /* Transmitter complete */
#define  USR2_BRCD  	 (1<<2)	 /* Break condition */
#define  USR2_ORE        (1<<1)	 /* Overrun error */
#define  USR2_RDR        (1<<0)	 /* Recv data ready */
#define  UTS_FRCPERR	 (1<<13) /* Force parity error */
#define  UTS_LOOP        (1<<12) /* Loop tx and rx */
#define  UTS_TXEMPTY	 (1<<6)	 /* TxFIFO empty */
#define  UTS_RXEMPTY	 (1<<5)	 /* RxFIFO empty */
#define  UTS_TXFULL 	 (1<<4)	 /* TxFIFO full */
#define  UTS_RXFULL 	 (1<<3)	 /* RxFIFO full */
#define  UTS_SOFTRST	 (1<<0)	 /* Software reset */

#elif defined(CONFIG_ARCH_IMX21)

/*
 *  Interrupt controller
 */

#define IMX_INTCNTL        __REG(IMX_AITC_BASE+0x00)
#define INTCNTL_FIAD       (1<<19)
#define INTCNTL_NIAD       (1<<20)

#define IMX_NIMASK         __REG(IMX_AITC_BASE+0x04)
#define IMX_INTENNUM       __REG(IMX_AITC_BASE+0x08)
#define IMX_INTDISNUM      __REG(IMX_AITC_BASE+0x0c)
#define IMX_INTENABLEH     __REG(IMX_AITC_BASE+0x10)
#define IMX_INTENABLEL     __REG(IMX_AITC_BASE+0x14)



/*
 * LCD Controller (for CONFIG_ARCH_IMX21)
 *  - copy from mikael
 */

#define LCDC_SSA        __REG(IMX_LCDC_BASE+0x00)

#define LCDC_SIZE       __REG(IMX_LCDC_BASE+0x04)
#define SIZE_XMAX(x)    ((((x) >> 4) & 0x3f) << 20)
#define SIZE_YMAX(y)    ( (y) & 0x1ff )

#define LCDC_VPW        __REG(IMX_LCDC_BASE+0x08)
#define VPW_VPW(x)      ( (x) & 0x3ff )

#define LCDC_CPOS       __REG(IMX_LCDC_BASE+0x0C)
#define CPOS_CC1        (1<<31)
#define CPOS_CC0        (1<<30)
#define CPOS_OP         (1<<28)
#define CPOS_CXP(x)     (((x) & 3ff) << 16)
#define CPOS_CYP(y)     ((y) & 0x1ff)

#define LCDC_LCWHB      __REG(IMX_LCDC_BASE+0x10)
#define LCWHB_BK_EN     (1<<31)
#define LCWHB_CW(w)     (((w) & 0x1f) << 24)
#define LCWHB_CH(h)     (((h) & 0x1f) << 16)
#define LCWHB_BD(x)     ((x) & 0xff)

#define LCDC_LCHCC      __REG(IMX_LCDC_BASE+0x14)
#define LCHCC_CUR_COL_R(r) (((r) & 0x1f) << 11)
#define LCHCC_CUR_COL_G(g) (((g) & 0x3f) << 5)
#define LCHCC_CUR_COL_B(b) ((b) & 0x1f)

#define LCDC_PCR        __REG(IMX_LCDC_BASE+0x18)


// Graphic Window Driver by seongyeol 

//#########################################		
//# Clock  Reset (CRM)                   #		
//# System control                        #		
//# $1002_7000 to $1002_7FFF              #		
//#########################################		
//#define CRM_BASE_ADDR	0x10027000	
//#define _reg_CRM_CSCR	(*((volatile unsigned long *)(MX2_IO_ADDRESS(CRM_BASE_ADDR+0x00))))  //  32bit Clock Source Control Reg
//#define _reg_CRM_MPCTL0	(*((volatile unsigned long *)(MX2_IO_ADDRESS(CRM_BASE_ADDR+0x04))))  //  32bit MCU PLL Control Reg
//#define _reg_CRM_MPCTL1	(*((volatile unsigned long *)(MX2_IO_ADDRESS(CRM_BASE_ADDR+0x08))))  //  32bit MCU PLL 
//#define _reg_CRM_SPCTL0	(*((volatile unsigned long *)(MX2_IO_ADDRESS(CRM_BASE_ADDR+0x0C))))  //  32bit Serial Perpheral PLL Ctrl 0
//#define _reg_CRM_SPCTL1	(*((volatile unsigned long *)(MX2_IO_ADDRESS(CRM_BASE_ADDR+0x10))))  //  32bit Serial Perpheral PLL Ctrl 1
//#define _reg_CRM_OSC26MCTL	(*((volatile unsigned long *)(MX2_IO_ADDRESS(CRM_BASE_ADDR+0x14))))  //  32bit Osc 26M register

//#define _reg_CRM_PCDR0	(*((volatile unsigned long *)(MX2_IO_ADDRESS(CRM_BASE_ADDR+0x18))))  //  32bit Serial Perpheral Clk Div Reg
//#define _reg_CRM_PCDR1	(*((volatile unsigned long *)(MX2_IO_ADDRESS(CRM_BASE_ADDR+0x1C))))  
//#define _reg_CRM_PCCR0	__REG(IMX_LCDC_BASE+(CRM_BASE_ADDR+0x20) )  
//#define _reg_CRM_PCCR1	(*((volatile unsigned long *)(MX2_IO_ADDRESS(CRM_BASE_ADDR+0x24))))  
//#define _reg_CRM_CCSR	(*((volatile unsigned long *)(MX2_IO_ADDRESS(CRM_BASE_ADDR+0x28))))  
//#define _reg_CRM_PMCTL	(*((volatile unsigned long *)(MX2_IO_ADDRESS(CRM_BASE_ADDR+0x2C))))  
//#define _reg_CRM_PMCOUNT	(*((volatile unsigned long *)(MX2_IO_ADDRESS(CRM_BASE_ADDR+0x30))))  
//#define _reg_CRM_WKGDCTL	(*((volatile unsigned long *)(MX2_IO_ADDRESS(CRM_BASE_ADDR+0x34))))  


//#########################################		
//# LCDC                                  #		
//# $1002_1000 to $1002_1FFF              #		
//#########################################		

//#define LCDC_BASE_ADDR	0x10021000	
//#define _reg_LCDC_LSSAR		(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x00))))  //  32bit lcdc screen start addr reg
//#define _reg_LCDC_LSR		(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x04))))  //  32bit lcdc size reg
//#define _reg_LCDC_LVPWR		(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x08))))  //  32bit lcdc virtual page width reg
//#define _reg_LCDC_LCPR		(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x0C))))  //  32bit lcd cursor position reg
//#define _reg_LCDC_LCWHBR	(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x10))))  //  32bit lcd cursor width/heigh/blink
//#define _reg_LCDC_LCCMR		(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x14))))  //  32bit lcd color cursor mapping reg
//#define _reg_LCDC_LPCR		(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x18))))  //  32bit lcdc panel config reg
//#define _reg_LCDC_LHCR		(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x1C))))  //  32bit lcdc horizontal config reg
//#define _reg_LCDC_LVCR		(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x20))))  //  32bit lcdc vertical config reg
//#define _reg_LCDC_LPOR		(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x24))))  //  32bit lcdc panning offset reg
//#define _reg_LCDC_LSCR		(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x28))))  //  32bit lcdc sharp config 1 reg
//#define _reg_LCDC_LPCCR		(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x2C))))  //  32bit lcdc pwm contrast ctrl reg
#define _reg_LCDC_LDCR		__REG(IMX_LCDC_BASE+0x30)  //  32bit lcdc dma control reg
//#define _reg_LCDC_LRMCR		(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x34))))  //  32bit lcdc refresh mode ctrl reg
//#define _reg_LCDC_LICR		(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x38))))  //  32bit lcdc interrupt config reg
//#define _reg_LCDC_LIER		(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x3C))))  //  32bit lcdc interrupt enable reg
//#define _reg_LCDC_LISR		(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x40))))  //  32bit lcdc interrupt status reg

// seongyeol 
#define _reg_LCDC_LGWSAR	__REG(IMX_LCDC_BASE+0x50)  //  32bit lcdc graphic win start add
#define _reg_LCDC_LGWSR	__REG(IMX_LCDC_BASE+0x54)  //  32bit lcdc graphic win size reg
#define _reg_LCDC_LGWVPWR	__REG(IMX_LCDC_BASE+0x58)  //  32bit lcdc graphic win virtual pg
#define _reg_LCDC_LGWPOR	__REG(IMX_LCDC_BASE+0x5c)  //  32bit lcdc graphic win pan offset
#define _reg_LCDC_LGWPR	__REG(IMX_LCDC_BASE+0x60) //  32bit lcdc graphic win positon reg
#define _reg_LCDC_LGWCR	__REG(IMX_LCDC_BASE+0x64)  //  32bit lcdc graphic win control reg
#define _reg_LCDC_LGWDCR	__REG(IMX_LCDC_BASE+0x68) //  32bit lcdc graphic win DMA control reg
		
//#define _reg_LCDC_BPLUT_BASE(regno)	(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0x800+4*(regno)))))  //  Background Plane LUT (800 - BFC)
//#define _reg_LCDC_GWLUT_BASE(regno)	(*((volatile unsigned long *)(MX2_IO_ADDRESS(LCDC_BASE_ADDR+0xC00+4*(regno)))))  //  Background Plane LUT (C00 - FFC)



#define PCR_TFT         (1<<31)
#define PCR_COLOR       (1<<30)
#define PCR_PBSIZ_1     (0<<28)
#define PCR_PBSIZ_2     (1<<28)
#define PCR_PBSIZ_4     (2<<28)
#define PCR_PBSIZ_8     (3<<28)
#define PCR_BPIX_1      (0<<25)
#define PCR_BPIX_2      (1<<25)
#define PCR_BPIX_4      (2<<25)
#define PCR_BPIX_8      (3<<25)
#define PCR_BPIX_12     (4<<25)
#define PCR_BPIX_16     (5<<25)    // color fix by Seong Yeol from 4 to 5
#define PCR_PIXPOL      (1<<24)
#define PCR_FLMPOL      (1<<23)
#define PCR_LPPOL       (1<<22)
#define PCR_CLKPOL      (1<<21)
#define PCR_OEPOL       (1<<20)
#define PCR_SCLKIDLE    (1<<19)
#define PCR_END_SEL     (1<<18)
#define PCR_END_BYTE_SWAP (1<<17)
#define PCR_REV_VS      (1<<16)
#define PCR_ACD_SEL     (1<<15)
#define PCR_ACD(x)      (((x) & 0x7f) << 8)
#define PCR_SCLK_SEL    (1<<7)
#define PCR_SHARP       (1<<6)
#define PCR_PCD(x)      ((x) & 0x3f)

#define LCDC_HCR        __REG(IMX_LCDC_BASE+0x1C)
#define HCR_H_WIDTH(x)  (((x) & 0x3f) << 26)
#define HCR_H_WAIT_1(x) (((x) & 0xff) << 8)
#define HCR_H_WAIT_2(x) ((x) & 0xff)

#define LCDC_VCR        __REG(IMX_LCDC_BASE+0x20)
#define VCR_V_WIDTH(x)  (((x) & 0x3f) << 26)
#define VCR_V_WAIT_1(x) (((x) & 0xff) << 8)
#define VCR_V_WAIT_2(x) ((x) & 0xff)

#define LCDC_POS        __REG(IMX_LCDC_BASE+0x24)
#define POS_POS(x)      ((x) & 1f)

#define LCDC_LSCR1      __REG(IMX_LCDC_BASE+0x28)
#define LSCR1_PS_RISE_DELAY(x)    (((x) & 0x7f) << 26)
#define LSCR1_CLS_RISE_DELAY(x)   (((x) & 0x3f) << 16)
#define LSCR1_REV_TOGGLE_DELAY(x) (((x) & 0xf) << 8)
#define LSCR1_GRAY2(x)            (((x) & 0xf) << 4)
#define LSCR1_GRAY1(x)            (((x) & 0xf))

#define LCDC_PWMR       __REG(IMX_LCDC_BASE+0x2C)
#define PWMR_CLS(x)     (((x) & 0x1ff) << 16)
#define PWMR_LDMSK      (1<<15)
#define PWMR_SCR1       (1<<10)
#define PWMR_SCR0       (1<<9)
#define PWMR_CC_EN      (1<<8)
#define PWMR_PW(x)      ((x) & 0xff)

#define LCDC_DMACR      __REG(IMX_LCDC_BASE+0x30)
#define DMACR_BURST     (1<<31)
#define DMACR_HM(x)     (((x) & 0xf) << 16)
#define DMACR_TM(x)     ((x) &0xf)

#define LCDC_RMCR       __REG(IMX_LCDC_BASE+0x34)
#define RMCR_LCDC_EN            (1<<1)
#define RMCR_SELF_REF           (1<<0)

#define LCDC_LCDICR     __REG(IMX_LCDC_BASE+0x38)
#define LCDICR_INT_SYN  (1<<2)
#define LCDICR_INT_CON  (1)

#define LCDC_LCDISR     __REG(IMX_LCDC_BASE+0x40)
#define LCDISR_UDR_ERR (1<<3)
#define LCDISR_ERR_RES (1<<2)
#define LCDISR_EOF     (1<<1)
#define LCDISR_BOF     (1<<0)

#define LCDC_PALETTE(x) __REG2(IMX_LCDC_BASE+0x800, (x)<<2)



/*
 *  Uart controller registers 
 */

#define UART_1  0
#define UART_2  1
#define UART_3  2
#define UART_4  3


#define URXD0(x) __REG( 0x0 + (x)) /* Receiver Register */
#define URTX0(x) __REG( 0x40 + (x)) /* Transmitter Register */
#define UCR1(x)  __REG( 0x80 + (x)) /* Control Register 1 */
#define UCR2(x)  __REG( 0x84 + (x)) /* Control Register 2 */
#define UCR3(x)  __REG( 0x88 + (x)) /* Control Register 3 */
#define UCR4(x)  __REG( 0x8c + (x)) /* Control Register 4 */
#define UFCR(x)  __REG( 0x90 + (x)) /* FIFO Control Register */
#define USR1(x)  __REG( 0x94 + (x)) /* Status Register 1 */
#define USR2(x)  __REG( 0x98 + (x)) /* Status Register 2 */
#define UESC(x)  __REG( 0x9c + (x)) /* Escape Character Register */
#define UTIM(x)  __REG( 0xa0 + (x)) /* Escape Timer Register */
#define UBIR(x)  __REG( 0xa4 + (x)) /* BRM Incremental Register */
#define UBMR(x)  __REG( 0xa8 + (x)) /* BRM Modulator Register */
#define UBRC(x)  __REG( 0xac + (x)) /* Baud Rate Count Register */
#define ONMES(x) __REG( 0xb0 + (x)) /* One Millisecond Register */
#define UTS(x)   __REG( 0xb4 + (x)) /* UART Test Register */



/* UART Control Register Bit Fields.*/
#define  URXD_CHARRDY    (1<<15)
#define  URXD_ERR        (1<<14)
#define  URXD_OVRRUN     (1<<13)
#define  URXD_FRMERR     (1<<12)
#define  URXD_BRK        (1<<11)
#define  URXD_PRERR      (1<<10)

#define  UCR1_ADEN       (1<<15) /* Auto dectect interrupt */
#define  UCR1_ADBR       (1<<14) /* Auto detect baud rate */
#define  UCR1_TRDYEN     (1<<13) /* Transmitter ready interrupt enable */
#define  UCR1_IDEN       (1<<12) /* Idle condition interrupt */
#define  UCR1_RRDYEN     (1<<9)  /* Recv ready interrupt enable */
#define  UCR1_RDMAEN     (1<<8)  /* Recv ready DMA enable */
#define  UCR1_IREN       (1<<7)  /* Infrared interface enable */
#define  UCR1_TXMPTYEN   (1<<6)  /* Transimitter empty interrupt enable */
#define  UCR1_RTSDEN     (1<<5)  /* RTS delta interrupt enable */
#define  UCR1_SNDBRK     (1<<4)  /* Send break */
#define  UCR1_TDMAEN     (1<<3)  /* Transmitter ready DMA enable */
// not on mx21 #define  UCR1_UARTCLKEN  (1<<2)   /* UART clock enabled */
#define  UCR1_DOZE       (1<<1)  /* Doze */
#define  UCR1_UARTEN     (1<<0)  /* UART enabled */

#define  UCR2_ESCI       (1<<15) /* Escape seq interrupt enable */
#define  UCR2_IRTS       (1<<14) /* Ignore RTS pin */
#define  UCR2_CTSC       (1<<13) /* CTS pin control */
#define  UCR2_CTS        (1<<12) /* Clear to send */
#define  UCR2_ESCEN      (1<<11) /* Escape enable */
#define  UCR2_PREN       (1<<8)  /* Parity enable */
#define  UCR2_PROE       (1<<7)  /* Parity odd/even */
#define  UCR2_STPB       (1<<6)  /* Stop */
#define  UCR2_WS         (1<<5)  /* Word size */
#define  UCR2_RTSEN      (1<<4)  /* Request to send interrupt enable */
#define  UCR2_ATEN       (1<<3)  /* Aging Timer Enable */
#define  UCR2_TXEN       (1<<2)  /* Transmitter enabled */
#define  UCR2_RXEN       (1<<1)  /* Receiver enabled */
#define  UCR2_SRST       (1<<0)  /* SW reset */

#define  UCR3_DTREN      (1<<13) /* DTR interrupt enable */
#define  UCR3_PARERREN   (1<<12) /* Parity enable */
#define  UCR3_FRAERREN   (1<<11) /* Frame error interrupt enable */
#define  UCR3_DSR        (1<<10) /* Data set ready */
#define  UCR3_DCD        (1<<9)  /* Data carrier detect */
#define  UCR3_RI         (1<<8)  /* Ring indicator */
#define  UCR3_ADNIMP     (1<<7)  /* Timeout interrupt enable */
#define  UCR3_RXDSEN     (1<<6)  /* Receive status interrupt enable */
#define  UCR3_AIRINTEN   (1<<5)  /* Async IR wake interrupt enable */
#define  UCR3_AWAKEN     (1<<4)  /* Async wake interrupt enable */
// not on mx21 #define  UCR3_REF25       (1<<3)  /* Ref freq 25 MHz */
#define  UCR3_RXDMUXSEL  (1<<2)  /* RXD Mux Input Select */
#define  UCR3_INVT       (1<<1)  /* Inverted Infrared transmission */
#define  UCR3_ACIEN      (1<<0)  /* Autobaud Counter  Interrupt Enable */
#define  UCR4_INVR       (1<<9)  /* Inverted infrared reception */
#define  UCR4_ENIRI      (1<<8)  /* Serial infrared interrupt enable */
#define  UCR4_WKEN       (1<<7)  /* Wake interrupt enable */
// not on mx21 #define  UCR4_REF16       (1<<6)  /* Ref freq 16 MHz */
#define  UCR4_IRSC       (1<<5)  /* IR special case */
#define  UCR4_LPBYP      (1<<5)  /* Low Power Bypass */
#define  UCR4_TCEN       (1<<3)  /* Transmit complete interrupt enable */
#define  UCR4_BKEN       (1<<2)  /* Break condition interrupt enable */
#define  UCR4_OREN       (1<<1)  /* Receiver overrun interrupt enable */
#define  UCR4_DREN       (1<<0)  /* Recv data ready interrupt enable */

#define  UFCR_RXTL_SHF   0       /* Receiver trigger level shift */
#define  UFCR_RFDIV      (7<<7)  /* Reference freq divider mask */
#define  UFCR_RFDIV_SHF  7       /* Reference freq divider shift */
#define  UFCR_TXTL_SHF   10      /* Transmitter trigger level shift */
#define  UFCR_DCEDTE     (1<<6)  /* DCE/DTE Mode */

#define  USR1_PARITYERR  (1<<15) /* Parity error interrupt flag */
#define  USR1_RTSS       (1<<14) /* RTS pin status */
#define  USR1_TRDY       (1<<13) /* Transmitter ready interrupt/dma flag */
#define  USR1_RTSD       (1<<12) /* RTS delta */
#define  USR1_ESCF       (1<<11) /* Escape seq interrupt flag */
#define  USR1_FRAMERR    (1<<10) /* Frame error interrupt flag */
#define  USR1_RRDY       (1<<9)  /* Receiver ready interrupt/dma flag */
#define  USR1_AGTIM      (1<<8)  /* Aging Timer Interrupt Flag */
// not on mx21 #define  USR1_TIMEOUT    (1<<7)   /* Receive timeout interrupt status */
#define  USR1_RXDS       (1<<6)  /* Receiver idle interrupt flag */
#define  USR1_AIRINT     (1<<5)  /* Async IR wake interrupt flag */
#define  USR1_AWAKE      (1<<4)  /* Aysnc wake interrupt flag */

#define  USR2_ADET       (1<<15) /* Auto baud rate detect complete */
#define  USR2_TXFE       (1<<14) /* Transmit buffer FIFO empty */
#define  USR2_DTRF       (1<<13) /* DTR edge interrupt flag */
#define  USR2_IDLE       (1<<12) /* Idle condition */
#define  USR2_ACST       (1<<11) /* Autobaud Controller Stopped*/
#define  USR2_RIDELT     (1<<10) /* Ring Indicator Delta */
#define  USR2_RIIN       (1<<9)  /* Ring Indicator Input*/
#define  USR2_IRINT      (1<<8)  /* Serial infrared interrupt flag */
#define  USR2_WAKE       (1<<7)  /* Wake */
#define  USR2_DCDDELT    (1<<6)  /* Data Carrier Delta Detect */
#define  USR2_DCDIN      (1<<5)  /* Data Carrier Detect Input */
#define  USR2_RTSF       (1<<4)  /* RTS edge interrupt flag */
#define  USR2_TXDC       (1<<3)  /* Transmitter complete */
#define  USR2_BRCD       (1<<2)  /* Break condition */
#define  USR2_ORE        (1<<1)  /* Overrun error */
#define  USR2_RDR        (1<<0)  /* Recv data ready */
#define  UTS_FRCPERR     (1<<13) /* Force parity error */
#define  UTS_LOOP        (1<<12) /* Loop tx and rx */
#define  UTS_DBGEN       (1<<11) /* /Debug Enable */
#define  UTS_LOOPIR      (1<<10) /* Loop tx and rx for IR */
#define  UTS_RXFIFO      (1<<9)  /* RXFifo Debug */
#define  UTS_TXEMPTY     (1<<6)  /* TxFIFO empty */
#define  UTS_RXEMPTY     (1<<5)  /* RxFIFO empty */
#define  UTS_TXFULL      (1<<4)  /* TxFIFO full */
#define  UTS_RXFULL      (1<<3)  /* RxFIFO full */
#define  UTS_SOFTRST     (1<<0)  /* Software reset */


/*
 *  * USB OTG controller
 *   */
#define USBOTG_HWMODE       __REG(IMX_USBOTG_BASE + 0x00)
#define USBOTG_HWMODE_ANASDBEN          (1 << 14)
#define USBOTG_HWMODE_OTGXCVR_MASK      (3 << 6)
#define USBOTG_HWMODE_OTGXCVR_TD_RD     (0 << 6)
#define USBOTG_HWMODE_OTGXCVR_TS_RD     (2 << 6)
#define USBOTG_HWMODE_OTGXCVR_TD_RS     (1 << 6)
#define USBOTG_HWMODE_OTGXCVR_TS_RS     (3 << 6)
#define USBOTG_HWMODE_HOSTXCVR_MASK     (3 << 4)
#define USBOTG_HWMODE_HOSTXCVR_TD_RD    (0 << 4)
#define USBOTG_HWMODE_HOSTXCVR_TS_RD    (2 << 4)
#define USBOTG_HWMODE_HOSTXCVR_TD_RS    (1 << 4)
#define USBOTG_HWMODE_HOSTXCVR_TS_RS    (3 << 4)
#define USBOTG_HWMODE_CRECFG_MASK       (3 << 0)
#define USBOTG_HWMODE_CRECFG_HOST       (1 << 0)
#define USBOTG_HWMODE_CRECFG_FUNC       (2 << 0)
#define USBOTG_HWMODE_CRECFG_HNP        (3 << 0)

#define USBOTG_CINT_STAT    __REG(IMX_USBOTG_BASE + 0x04)
#define USBOTG_CINT_STEN    __REG(IMX_USBOTG_BASE + 0x08)
#define USBOTG_ASHNPINT                 (1 << 5)
#define USBOTG_ASFCINT                  (1 << 4)
#define USBOTG_ASHCINT                  (1 << 3)
#define USBOTG_SHNPINT                  (1 << 2)
#define USBOTG_FCINT                    (1 << 1)
#define USBOTG_HCINT                    (1 << 0)

#define USBOTG_CLK_CTRL     __REG(IMX_USBOTG_BASE + 0x0c)
#define USBOTG_CLK_CTRL_FUNC            (1 << 2)
#define USBOTG_CLK_CTRL_HST             (1 << 1)
#define USBOTG_CLK_CTRL_MAIN            (1 << 0)

#define USBOTG_RST_CTRL     __REG(IMX_USBOTG_BASE + 0x10)
#define USBOTG_RST_RSTI2C               (1 << 15)
#define USBOTG_RST_RSTCTRL              (1 << 5)
#define USBOTG_RST_RSTFC                (1 << 4)
#define USBOTG_RST_RSTFSKE              (1 << 3)
#define USBOTG_RST_RSTRH                (1 << 2)
#define USBOTG_RST_RSTHSIE              (1 << 1)
#define USBOTG_RST_RSTHC                (1 << 0)

#define USBOTG_FRM_INTVL    __REG(IMX_USBOTG_BASE + 0x14)
#define USBOTG_FRM_REMAIN   __REG(IMX_USBOTG_BASE + 0x18)
#define USBOTG_HNP_CSR      __REG(IMX_USBOTG_BASE + 0x1c)
#define USBOTG_HNP_ISR      __REG(IMX_USBOTG_BASE + 0x2c)
#define USBOTG_HNP_IEN      __REG(IMX_USBOTG_BASE + 0x30)

#define USBOTG_I2C_TXCVR_REG(x)      __REG8(IMX_USBOTG_BASE + 0x100 + (x))
#define USBOTG_I2C_XCVR_DEVAD        __REG8(IMX_USBOTG_BASE + 0x118)
#define USBOTG_I2C_SEQ_OP_REG        __REG8(IMX_USBOTG_BASE + 0x119)
#define USBOTG_I2C_SEQ_RD_STARTAD    __REG8(IMX_USBOTG_BASE + 0x11a)
#define USBOTG_I2C_OP_CTRL_REG       __REG8(IMX_USBOTG_BASE + 0x11b)
#define USBOTG_I2C_SCLK_TO_SCK_HPER  __REG8(IMX_USBOTG_BASE + 0x11e)
#define USBOTG_I2C_MASTER_INT_REG    __REG8(IMX_USBOTG_BASE + 0x11f)

#define USBH_HOST_CTRL      __REG(IMX_USBOTG_BASE + 0x80)
#define USBH_HOST_CTRL_HCRESET                (1 << 31)
#define USBH_HOST_CTRL_SCHDOVR(x)             ((x) << 16)
#define USBH_HOST_CTRL_RMTWUEN                (1 << 4)
#define USBH_HOST_CTRL_HCUSBSTE_RESET         (0 << 2)
#define USBH_HOST_CTRL_HCUSBSTE_RESUME        (1 << 2)
#define USBH_HOST_CTRL_HCUSBSTE_OPERATIONAL   (2 << 2)
#define USBH_HOST_CTRL_HCUSBSTE_SUSPEND       (3 << 2)
#define USBH_HOST_CTRL_CTLBLKSR_1             (0 << 0)
#define USBH_HOST_CTRL_CTLBLKSR_2             (1 << 0)
#define USBH_HOST_CTRL_CTLBLKSR_3             (2 << 0)
#define USBH_HOST_CTRL_CTLBLKSR_4             (3 << 0)

#define USBH_SYSISR         __REG(IMX_USBOTG_BASE + 0x88)
#define USBH_SYSISR_PSCINT                    (1 << 6)
#define USBH_SYSISR_FMOFINT                   (1 << 5)
#define USBH_SYSISR_HERRINT                   (1 << 4)
#define USBH_SYSISR_RESDETINT                 (1 << 3)
#define USBH_SYSISR_SOFINT                    (1 << 2)
#define USBH_SYSISR_DONEINT                   (1 << 1)
#define USBH_SYSISR_SORINT                    (1 << 0)

#define USBH_SYSIEN         __REG(IMX_USBOTG_BASE + 0x8c)
#define USBH_SYSIEN_PSCINT                    (1 << 6)
#define USBH_SYSIEN_FMOFINT                   (1 << 5)
#define USBH_SYSIEN_HERRINT                   (1 << 4)
#define USBH_SYSIEN_RESDETINT                 (1 << 3)
#define USBH_SYSIEN_SOFINT                    (1 << 2)
#define USBH_SYSIEN_DONEINT                   (1 << 1)
#define USBH_SYSIEN_SORINT                    (1 << 0)

#define USBH_XBUFSTAT       __REG(IMX_USBOTG_BASE + 0x98)
#define USBH_YBUFSTAT       __REG(IMX_USBOTG_BASE + 0x9c)
#define USBH_XYINTEN        __REG(IMX_USBOTG_BASE + 0xa0)
#define USBH_XFILLSTAT      __REG(IMX_USBOTG_BASE + 0xa8)
#define USBH_YFILLSTAT      __REG(IMX_USBOTG_BASE + 0xac)
#define USBH_ETDENSET       __REG(IMX_USBOTG_BASE + 0xc0)
#define USBH_ETDENCLR       __REG(IMX_USBOTG_BASE + 0xc4)
#define USBH_IMMEDINT       __REG(IMX_USBOTG_BASE + 0xcc)
#define USBH_ETDDONESTAT    __REG(IMX_USBOTG_BASE + 0xd0)
#define USBH_ETDDONEEN      __REG(IMX_USBOTG_BASE + 0xd4)
#define USBH_FRMNUB         __REG(IMX_USBOTG_BASE + 0xe0)
#define USBH_LSTHRESH       __REG(IMX_USBOTG_BASE + 0xe4)
#define USBH_ROOTHUBA       __REG(IMX_USBOTG_BASE + 0xe8)
#define USBH_ROOTHUBA_PWRTOGOOD_MASK          (0xff)
#define USBH_ROOTHUBA_PWRTOGOOD_SHIFT         (24)
#define USBH_ROOTHUBA_NOOVRCURP               (1 << 12)
#define USBH_ROOTHUBA_OVRCURPM                (1 << 11)
#define USBH_ROOTHUBA_DEVTYPE                 (1 << 10)
#define USBH_ROOTHUBA_PWRSWTMD                (1 << 9)
#define USBH_ROOTHUBA_NOPWRSWT                (1 << 8)
#define USBH_ROOTHUBA_NDNSTMPRT_MASK          (0xff)

#define USBH_ROOTHUBB       __REG(IMX_USBOTG_BASE + 0xec)
#define USBH_ROOTHUBB_PRTPWRCM(x)             (1 << ((x) + 16))
#define USBH_ROOTHUBB_DEVREMOVE(x)            (1 << (x))

#define USBH_ROOTSTAT       __REG(IMX_USBOTG_BASE + 0xf0)
#define USBH_ROOTSTAT_CLRRMTWUE               (1 << 31)
#define USBH_ROOTSTAT_OVRCURCHG               (1 << 17)
#define USBH_ROOTSTAT_DEVCONWUE               (1 << 15)
#define USBH_ROOTSTAT_OVRCURI                 (1 << 1)
#define USBH_ROOTSTAT_LOCPWRS                 (1 << 0)

#define USBH_PORTSTAT(x)    __REG(IMX_USBOTG_BASE + 0xf4 + ((x) * 4))
#define USBH_PORTSTAT_PRTRSTSC                (1 << 20)
#define USBH_PORTSTAT_OVRCURIC                (1 << 19)
#define USBH_PORTSTAT_PRTSTATSC               (1 << 18)
#define USBH_PORTSTAT_PRTENBLSC               (1 << 17)
#define USBH_PORTSTAT_CONNECTSC               (1 << 16)
#define USBH_PORTSTAT_LSDEVCON                (1 << 9)
#define USBH_PORTSTAT_PRTPWRST                (1 << 8)
#define USBH_PORTSTAT_PRTRSTST                (1 << 4)
#define USBH_PORTSTAT_PRTOVRCURI              (1 << 3)
#define USBH_PORTSTAT_PRTSUSPST               (1 << 2)
#define USBH_PORTSTAT_PRTENABST               (1 << 1)
#define USBH_PORTSTAT_CURCONST                (1 << 0)

#define USB_DMAREV          __REG(IMX_USBOTG_BASE + 0x800)
#define USB_DMAINTSTAT      __REG(IMX_USBOTG_BASE + 0x804)
#define USB_DMAINTSTAT_EPERR                  (1 << 1)
#define USB_DMAINTSTAT_ETDERR                 (1 << 0)

#define USB_DMAINTEN        __REG(IMX_USBOTG_BASE + 0x808)
#define USB_DMAINTEN_EPERRINTEN               (1 << 1)
#define USB_DMAINTEN_ETDERRINTEN              (1 << 0)

#define USB_ETDDMAERSTAT    __REG(IMX_USBOTG_BASE + 0x80c)
#define USB_EPDMAERSTAT     __REG(IMX_USBOTG_BASE + 0x810)
#define USB_ETDDMAEN        __REG(IMX_USBOTG_BASE + 0x820)
#define USB_EPDMAEN         __REG(IMX_USBOTG_BASE + 0x824)
#define USB_ETDDMAXTEN      __REG(IMX_USBOTG_BASE + 0x828)
#define USB_EPDMAXTEN       __REG(IMX_USBOTG_BASE + 0x82c)

#define USB_ETDDMAENXYT     __REG(IMX_USBOTG_BASE + 0x830)
#define USB_EPDMAENXYT      __REG(IMX_USBOTG_BASE + 0x834)
#define USB_ETDDMABST4EN    __REG(IMX_USBOTG_BASE + 0x838)
#define USB_EPDMABST4EN     __REG(IMX_USBOTG_BASE + 0x83c)

#define USB_MISCCONTROL     __REG(IMX_USBOTG_BASE + 0x840)
#define USB_MISCCONTROL_ISOPREVFRM            (1 << 3)
#define USB_MISCCONTROL_SKPRTRY               (1 << 2)
#define USB_MISCCONTROL_ARBMODE               (1 << 1)
#define USB_MISCCONTROL_FILTCC                (1 << 0)

#define USB_ETDDMACHANLCLR  __REG(IMX_USBOTG_BASE + 0x848)
#define USB_EPDMACHANLCLR   __REG(IMX_USBOTG_BASE + 0x84c)
#define USB_ETDSMSA(x)      __REG(IMX_USBOTG_BASE + 0x900 + ((x) * 4))
#define USB_EPSMSA(x)       __REG(IMX_USBOTG_BASE + 0x980 + ((x) * 4))
#define USB_ETDDMABUFPTR(x) __REG(IMX_USBOTG_BASE + 0xa00 + ((x) * 4))
#define USB_EPDMABUFPTR(x)  __REG(IMX_USBOTG_BASE + 0xa80 + ((x) * 4))

#define USB_NUM_ETD         32
#define USB_ETD(x)          __REG(IMX_USBOTG_BASE + 0x200 + ((x) * 16))

#define USBCTRL             __REG(IMX_USBOTG_BASE + 0x600)
#define USBCTRL_I2C_WU_INT_STAT         (1 << 27)
#define USBCTRL_OTG_WU_INT_STAT         (1 << 26)
#define USBCTRL_HOST_WU_INT_STAT        (1 << 25)
#define USBCTRL_FNT_WU_INT_STAT         (1 << 24)
#define USBCTRL_I2C_WU_INT_EN           (1 << 19)
#define USBCTRL_OTG_WU_INT_EN           (1 << 18)
#define USBCTRL_HOST_WU_INT_EN          (1 << 17)
#define USBCTRL_FNT_WU_INT_EN           (1 << 16)
#define USBCTRL_OTC_RCV_RXDP            (1 << 13)
#define USBCTRL_HOST1_BYP_TLL           (1 << 12)
#define USBCTRL_OTG_BYP_VAL(x)          ((x) << 10)
#define USBCTRL_HOST1_BYP_VAL(x)        ((x) << 8)
#define USBCTRL_OTG_PWR_MASK            (1 << 6)
#define USBCTRL_HOST1_PWR_MASK          (1 << 5)
#define USBCTRL_HOST2_PWR_MASK          (1 << 4)
#define USBCTRL_USB_BYP                 (1 << 2)
#define USBCTRL_HOST1_TXEN_OE           (1 << 1)


#ifdef CONFIG_ARCH_IMX21
#define CSPI_BASE_ADDR(x)	(0xE000+0x1000*(x-1))
#define MX2_IO_ADDRESS(x)	(IMX_IO_BASE+x)
//#define MX2_IO_ADDRESS(x)	x


#define CSPI_RXDATA(x)      (*((volatile unsigned long *)(MX2_IO_ADDRESS(CSPI_BASE_ADDR(x)+0x00)))) //  32bit cspi1 receive data reg
#define CSPI_TXDATA(x)      (*((volatile unsigned long *)(MX2_IO_ADDRESS(CSPI_BASE_ADDR(x)+0x04)))) //  32bit cspi1 transmit data reg
#define CSPI_CONTROL(x)     (*((volatile unsigned long *)(MX2_IO_ADDRESS(CSPI_BASE_ADDR(x)+0x08)))) //  32bit cspi1 control reg
#define CSPI_INT(x)     (*((volatile unsigned long *)(MX2_IO_ADDRESS(CSPI_BASE_ADDR(x)+0x0C)))) //  32bit cspi1 interrupt stat/ctr reg
#define CSPI_TEST(x)        (*((volatile unsigned long *)(MX2_IO_ADDRESS(CSPI_BASE_ADDR(x)+0x10)))) //  32bit cspi1 test reg
#define CSPI_PERIOD(x)      (*((volatile unsigned long *)(MX2_IO_ADDRESS(CSPI_BASE_ADDR(x)+0x14)))) //  32bit cspi1 sample period ctrl reg
#define CSPI_DMA(x)     (*((volatile unsigned long *)(MX2_IO_ADDRESS(CSPI_BASE_ADDR(x)+0x18)))) //  32bit cspi1 dma ctrl reg
#define CSPI_RESET(x)       (*((volatile unsigned long *)(MX2_IO_ADDRESS(CSPI_BASE_ADDR(x)+0x1C)))) //  32bit cspi1 soft reset reg
    
#define CSPI3_RXDATA        (*((volatile unsigned long *)(MX2_IO_ADDRESS(CSPI3_BASE_ADDR+0x00))))   //  32bit cspi1 receive data reg
#define CSPI3_TXDATA        (*((volatile unsigned long *)(MX2_IO_ADDRESS(CSPI3_BASE_ADDR+0x04))))   //  32bit cspi1 transmit data reg
#define CSPI3_CONTROL       (*((volatile unsigned long *)(MX2_IO_ADDRESS(CSPI3_BASE_ADDR+0x08))))   //  32bit cspi1 control reg
#define CSPI3_INT           (*((volatile unsigned long *)(MX2_IO_ADDRESS(CSPI3_BASE_ADDR+0x0C))))   //  32bit cspi1 interrupt stat/ctr reg
#define CSPI3_TEST          (*((volatile unsigned long *)(MX2_IO_ADDRESS(CSPI3_BASE_ADDR+0x10))))   //  32bit cspi1 test reg
#define CSPI3_PERIOD        (*((volatile unsigned long *)(MX2_IO_ADDRESS(CSPI3_BASE_ADDR+0x14))))   //  32bit cspi1 sample period ctrl reg
#define CSPI3_DMA           (*((volatile unsigned long *)(MX2_IO_ADDRESS(CSPI3_BASE_ADDR+0x18))))   //  32bit cspi1 dma ctrl reg
#define CSPI3_RESET         (*((volatile unsigned long *)(MX2_IO_ADDRESS(CSPI3_BASE_ADDR+0x1C))))   //  32bit cspi1 soft reset reg
#endif


/* Following is related w/ NAND Flash enabling  (by PCJ)    */

//#define SYS_BASE_ADDR   0x10027800      // defined above register map

#define _reg_SYS_SIDR   (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x04))))  //  128bit Silicon ID Reg
#define _reg_SYS_SIDR1  (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x04))))  //  128bit Silicon ID Reg word 1
#define _reg_SYS_SIDR2  (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x08))))  //  128bit Silicon ID Reg word 2
#define _reg_SYS_SIDR3  (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x0C))))  //  128bit Silicon ID Reg word 3
#define _reg_SYS_SIDR4  (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x10))))  //  128bit Silicon ID Reg word 4
#define _reg_SYS_FMCR   (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x14))))  //  Functional Muxing Control Reg
#define _reg_SYS_GPCR   (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x18))))  //  Global Peripheral Control Reg
#define _reg_SYS_WBCR   (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x1C))))  //  Well Bias Control Reg
#define _reg_SYS_DSCR1  (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x20))))  //  Drive Strength Crtl Reg 1
#define _reg_SYS_DSCR2  (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x24))))  //  Drive Strength Crtl Reg 2
#define _reg_SYS_DSCR3  (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x28))))  //  Drive Strength Crtl Reg 3
#define _reg_SYS_DSCR4  (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x2C))))  //  Drive Strength Crtl Reg 4
#define _reg_SYS_DSCR5  (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x30))))  //  Drive Strength Crtl Reg 5
#define _reg_SYS_DSCR6  (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x34))))  //  Drive Strength Crtl Reg 6
#define _reg_SYS_DSCR7  (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x38))))  //  Drive Strength Crtl Reg 7
#define _reg_SYS_DSCR8  (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x3C))))  //  Drive Strength Crtl Reg 8
#define _reg_SYS_DSCR9  (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x40))))  //  Drive Strength Crtl Reg 9
#define _reg_SYS_DSCR10 (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x44))))  //  Drive Strength Crtl Reg 10
#define _reg_SYS_DSCR11 (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x48))))  //  Drive Strength Crtl Reg 11
#define _reg_SYS_DSCR12 (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x4C))))  //  Drive Strength Crtl Reg 12
#define _reg_SYS_PCSR   (*((volatile unsigned long *)(MX2_IO_ADDRESS(SYS_BASE_ADDR+0x50))))  //  Priority Control/select Reg

//#########################################             
//# NFC                                   #             
//# $DF00_3000 to $DF00_3FFF              #             
//#########################################             
#define NFC_BASE_ADDR   0xDF003000     

#define MX2ADS_EMI_BASE		IMX_EMI_PHYS
#define MX2ADS_EMI_SIZE         IMX_EMI_SIZE
#define MX2ADS_EMI_IOBASE       IMX_EMI_VIRT
 
#define NFC_IO_ADDRESS(x)       (((x)-MX2ADS_EMI_BASE)+MX2ADS_EMI_IOBASE)
#define NFC_MX2_IO_ADDRESS 	NFC_IO_ADDRESS

#define NFC_MAB_BASE(x)         (NFC_BASE_ADDR+0x000+0x200*x)   //  main area buffer0 (3000 - 31FE)
#define NFC_SAB_BASE(x)         (NFC_BASE_ADDR+0x800+0x10*x)    //  spare area buffer0 (3800 - 380E)
#define NFC_SAB_8BIT_BASE(x)    (NFC_BASE_ADDR+0x800+0x10*x)    //  spare area buffer0 for 8 bit(3800 - 380E)
#define NFC_SAB_16BIT_BASE(x)   (NFC_BASE_ADDR+0x800+0x10*x)    //  spare area buffer0 for 16 bit(3800 - 380E)          
#define NFC_REG_BASE            (NFC_BASE_ADDR+0xE00)     //  register area (3E00 - 3E1C)   
#define _reg_NFC_BUFSIZE                      (*((volatile unsigned short *)(NFC_MX2_IO_ADDRESS(NFC_REG_BASE+0x00))))   //  16bit nfc internal sram size      
#define _reg_NFC_BLK_ADD_LOCK                 (*((volatile unsigned short *)(NFC_MX2_IO_ADDRESS(NFC_REG_BASE+0x02))))   //  16bit nfc block addr for lock chk 
#define _reg_NFC_RAM_BUF_ADDR                 (*((volatile unsigned short *)(NFC_MX2_IO_ADDRESS(NFC_REG_BASE+0x04))))   //  16bit nfc buffer number           
#define _reg_NFC_NAND_FLASH_ADDR              (*((volatile unsigned short *)(NFC_MX2_IO_ADDRESS(NFC_REG_BASE+0x06))))   //  16bit nfc nand flash address      
#define _reg_NFC_NAND_FLASH_CMD               (*((volatile unsigned short *)(NFC_MX2_IO_ADDRESS(NFC_REG_BASE+0x08))))   //  16bit nfc nand flash command      
#define _reg_NFC_CONFIGURATION                (*((volatile unsigned short *)(NFC_MX2_IO_ADDRESS(NFC_REG_BASE+0x0A))))   //  16bit nfc internal buf lock ctrl  
#define _reg_NFC_ECC_STAT_RES                 (*((volatile unsigned short *)(NFC_MX2_IO_ADDRESS(NFC_REG_BASE+0x0C))))   //  16bit nfc controller status/result
#define _reg_NFC_ECC_RSLT_MA                  (*((volatile unsigned short *)(NFC_MX2_IO_ADDRESS(NFC_REG_BASE+0x0E))))   //  16bit nfc ecc err position in main
#define _reg_NFC_ECC_RSLT_SA                  (*((volatile unsigned short *)(NFC_MX2_IO_ADDRESS(NFC_REG_BASE+0x10))))   //  16bit nfc ecc err pos in spare    
#define _reg_NFC_NF_WR_PROT                   (*((volatile unsigned short *)(NFC_MX2_IO_ADDRESS(NFC_REG_BASE+0x12))))   //  16bit nfc write protection        
#define _reg_NFC_ULOCK_START_BLK              (*((volatile unsigned short *)(NFC_MX2_IO_ADDRESS(NFC_REG_BASE+0x14))))   //  16bit nfc start unlock location   
#define _reg_NFC_ULOCK_END_BLK                (*((volatile unsigned short *)(NFC_MX2_IO_ADDRESS(NFC_REG_BASE+0x16))))   //  16bit nfc end unlock location     
#define _reg_NFC_NF_WR_PROT_STAT              (*((volatile unsigned short *)(NFC_MX2_IO_ADDRESS(NFC_REG_BASE+0x18))))   //  16bit nfc write protection status 
#define _reg_NFC_NF_CONFIG1                   (*((volatile unsigned short *)(NFC_MX2_IO_ADDRESS(NFC_REG_BASE+0x1A))))   //  16bit nfc configuration 1         
#define _reg_NFC_NF_CONFIG2                   (*((volatile unsigned short *)(NFC_MX2_IO_ADDRESS(NFC_REG_BASE+0x1C))))   //  16bit nfc configuration 2         

#define NFC_MAB0_BASE   (NFC_MX2_IO_ADDRESS(NFC_BASE_ADDR+0x000))       //  main area buffer0 (3000 - 31FE)
#define NFC_MAB1_BASE   (NFC_MX2_IO_ADDRESS(NFC_BASE_ADDR+0x200))       //  main area buffer1 (3200 - 33FE)
#define NFC_MAB2_BASE   (NFC_MX2_IO_ADDRESS(NFC_BASE_ADDR+0x400))       //  main area buffer2 (3400 - 35FE)
#define NFC_MAB3_BASE   (NFC_MX2_IO_ADDRESS(NFC_BASE_ADDR+0x600))       //  main area buffer3 (3600 - 37FE)

#define NFC_SAB0_BASE   (NFC_MX2_IO_ADDRESS(NFC_BASE_ADDR+0x800))       //  spare area buffer0 (3800 - 380E)
#define NFC_SAB1_BASE   (NFC_MX2_IO_ADDRESS(NFC_BASE_ADDR+0x810))       //  spare area buffer1 (3810 - 381E)
#define NFC_SAB2_BASE   (NFC_MX2_IO_ADDRESS(NFC_BASE_ADDR+0x820))       //  spare area buffer2 (3820 - 382E)
#define NFC_SAB3_BASE   (NFC_MX2_IO_ADDRESS(NFC_BASE_ADDR+0x830))       //  spare area buffer3 (3830 - 383E)




#else   // ! (#ifdef CONFIG_ARCH_IMX or CONFIG_ARCH_IMX21)
#error No CONFIG_ARCH_ defined
#endif



#endif				// _IMX_REGS_H
