/*
 *  linux/include/asm-arm/arch-mx2ads/ssi.h
 *
 *  Hardware register address and field definitions for the
 *  SSI module of the Freescale i.MX21 Applications Processor
 *
 *  Copyright (C) 2004 Metrowerks
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_SSI_H
#define __ASM_ARCH_SSI_H

#include <asm/arch/hardware.h>

/************************************************************************
 * Module: SSI1, Addr Range: 0x10010000 - 0x10010FFF, Size: 4 Kbyte
 * Module: SSI2, Addr Range: 0x10011000 - 0x10011FFF, Size: 4 Kbyte
 ************************************************************************/
#define SSI1_BASE_ADDR      0x10010000           /* SSI1 Base Address */
#define SSI2_BASE_ADDR      0x10011000           /* SSI2 Base Address */
typedef volatile struct {
	unsigned int stx0;			/* Transmit Data Register 0 */
	unsigned int stx1;          /* Transmit Data Register 1 */
	unsigned int srx0;          /* Receive Data Register 0 */
	unsigned int srx1;          /* Receive Data Register 1 */
	unsigned int scr;           /* Control Register */
	unsigned int sisr;          /* Interrupt Status Register */
	unsigned int sier;          /* Interrupt Enable Register */
	unsigned int stcr;          /* Transmit Configuration Reg*/
	unsigned int srcr;          /* Receive Configuration Reg*/
	unsigned int stccr;         /* Xmit Clock Control Reg*/
	unsigned int srccr;         /* Rcv Clock Control Reg*/
	unsigned int sfcsr;         /* FIFO Control/Status Reg*/
	unsigned int str;           /* Test Register */
	unsigned int sor;           /* Option Register */
	unsigned int sacnt;         /* AC97 Control Register */
	unsigned int sacadd;        /* AC97 Command Address Reg*/
	unsigned int sacdat;        /* AC97 Command Data Reg*/
	unsigned int satag;         /* AC97 Tag Register */
	unsigned int stmsk;         /* Xmit Time Slot Mask Reg*/
	unsigned int srmsk;         /* Rcv Time Slot Mask Reg */
} mx2ads_ssi_t;

extern mx2ads_ssi_t *mx2ads_ssi1;
extern mx2ads_ssi_t *mx2ads_ssi2;

/* SSI Transmit (0/1) Data Register */
#define SSI_STX(x)	((x) & 0x00FFFFFF)	/* 24 bit Transmit Data Reg */

/* SSI Receive (0/1) Data Register */
#define SSI_SRX(x)	((x) & 0x00FFFFFF)	/* 24 bit Receive Data Reg */

/* SSI Control Register */
#define SSI_CLK_IST		(1 <<  9)	/* Clock Idle State */
#define SSI_TCH_EN		(1 <<  8)	/* 2 Chan Operation En */
#define SSI_SYS_CLK_EN		(1 <<  7)	/* System Clk Enable */
#define SSI_I2S_MODE(x)		(((x)&0x3)<<5)	/* I2S Mode Select */
#define SSI_SYN			(1 <<  4)	/* Synchrounous Mode */
#define SSI_NET			(1 <<  3)	/* Network Mode */
#define SSI_RE			(1 <<  2)	/* Receive Mode */
#define SSI_TE			(1 <<  1)	/* Transmit Enable */
#define SSI_SCR_SSIEN		(1 <<  0)	/* SSI Enable */

/* SSI Interrupt Status Register */
#define SSI_CMDAU		(1 << 18)	/* Command Add Reg Updated */
#define SSI_CMDDU		(1 << 17)	/* Command Data Reg Updated */
#define SSI_RXT			(1 << 16)	/* Rcv Tag Updated */
#define SSI_RDR1		(1 << 15)	/* Rcv Data Ready 1 */
#define SSI_RDR0		(1 << 14)	/* Rcv Data Ready 0 */
#define SSI_TDE1		(1 << 13)	/* Xmit Data Reg Empty 1 */
#define SSI_TDE0		(1 << 12)	/* Xmit Data Reg Empty 0 */
#define SSI_ROE1		(1 << 11)	/* Rcv Overrun Error 1 */
#define SSI_ROE0		(1 << 10)	/* Rcv Overrun Error 0 */
#define SSI_TUE1		(1 <<  9)	/* Xmit Underrun Error 1 */
#define SSI_TUE0		(1 <<  8)	/* Xmit Underrun Error 0 */
#define SSI_TFS			(1 <<  7)	/* Xmit Frame Sync */
#define SSI_RFS			(1 <<  6)	/* Rcv Frame Sync */
#define SSI_TLS			(1 <<  5)	/* Xmit Last Time Slot */
#define SSI_RLS			(1 <<  4)	/* Rcv Last Time Slot */
#define SSI_RFF1		(1 <<  3)	/* Rcv FIFO Full 1 */
#define SSI_RFF0		(1 <<  2)	/* Rcv FIFO Full 0 */
#define SSI_TFE1		(1 <<  1)	/* Xmit FIFO Full 1 */
#define SSI_TFE0		(1 <<  0)	/* Xmit FIFO Full 0 */

/* SSI Interrupt Enable Register */
#define SSI_SIER_RDMAE		(1 << 22)	/* Rcv DMA Enable */
#define SSI_SIER_RIE		(1 << 21)	/* Rcv Interrupt Enable */
#define SSI_SIER_TDMAE		(1 << 20)	/* Xmit DMA Enable */
#define SSI_SIER_TIE		(1 << 19)	/* Xmit Interrupt Enable */
#define SSI_SIER_CMDAU_EN	(1 << 18)	/* SISR Status bit Int En */
#define SSI_SIER_CMDDU_EN	(1 << 17)	/* SISR Status bit Int En */
#define SSI_SIER_RXT_EN		(1 << 16)	/* SISR Status bit Int En */
#define SSI_SIER_RDR1_EN	(1 << 15)	/* SISR Status bit Int En */
#define SSI_SIER_RDR0_EN	(1 << 14)	/* SISR Status bit Int En */
#define SSI_SIER_TDE1_EN	(1 << 13)	/* SISR Status bit Int En */
#define SSI_SIER_TDE0_EN	(1 << 12)	/* SISR Status bit Int En */
#define SSI_SIER_ROE1_EN	(1 << 11)	/* SISR Status bit Int En */
#define SSI_SIER_ROE0_EN	(1 << 10)	/* SISR Status bit Int En */
#define SSI_SIER_TUE1_EN	(1 <<  9)	/* SISR Status bit Int En */
#define SSI_SIER_TUE0_EN	(1 <<  8)	/* SISR Status bit Int En */
#define SSI_SIER_TFS_EN		(1 <<  7)	/* SISR Status bit Int En */
#define SSI_SIER_RFS_EN		(1 <<  6)	/* SISR Status bit Int En */
#define SSI_SIER_TLS_EN		(1 <<  5)	/* SISR Status bit Int En */
#define SSI_SIER_RLS_EN		(1 <<  4)	/* SISR Status bit Int En */
#define SSI_SIER_RFE1_EN	(1 <<  3)	/* SISR Status bit Int En */
#define SSI_SIER_RFE0_EN	(1 <<  2)	/* SISR Status bit Int En */
#define SSI_SIER_TFE1_EN	(1 <<  1)	/* SISR Status bit Int En */
#define SSI_SIER_TFE0_EN	(1 <<  0)	/* SISR Status bit Int En */

/* SSI Transmit Configuration Register */
#define SSI_STCR_TCKSEL		(1 << 10)	/* Xmit Serial Sys Clk Sel*/
#define SSI_STCR_TXBIT0		(1 <<  9)	/* Xmit Bit 0 */
#define SSI_STCR_TFEN1		(1 <<  8)	/* Xmit FIFO Enable 1 */
#define SSI_STCR_TFEN0		(1 <<  7)	/* Xmit FIFO Enable 0 */
#define SSI_STCR_TFDIR		(1 <<  6)	/* Xmit Frame Dir */
#define SSI_STCR_TXDIR		(1 <<  5)	/* Xmit Direction */
#define SSI_STCR_TSHFD		(1 <<  4)	/* Xmit Shift Direction */
#define SSI_STCR_TSCKP		(1 <<  3)	/* Xmit Clock Polarity */
#define SSI_STCR_TFSI		(1 <<  2)	/* Xmit Frame Sync Invert */
#define SSI_STCR_TFSL		(1 <<  1)	/* Xmit Frame Sync Length */
#define SSI_STCR_TEFS		(1 <<  0)	/* Xmit Early Frame Sync */

/* SSI Receive Configuration Register */
#define SSI_SRCR_RXSEL		(1 << 10)	/* Rcv Serial Sys Clk Sel */
#define SSI_SRCR_RXBIT0		(1 <<  9)	/* Rcv Bit 0 */
#define SSI_SRCR_RFEN1		(1 <<  8)	/* Rcv FIFO Enable 1 */
#define SSI_SRCR_RFEN0		(1 <<  7)	/* Rcv FIFO Enable 0 */
#define SSI_SRCR_RFDIR		(1 <<  6)	/* Rcv Frame Dir */
#define SSI_SRCR_RXDIR		(1 <<  5)	/* Rcv Direction */
#define SSI_SRCR_RSHFD		(1 <<  4)	/* Rcv Shift Direction */
#define SSI_SRCR_RSCKP		(1 <<  3)	/* Rcv Clock Polarity */
#define SSI_SRCR_RFSI		(1 <<  2)	/* Rcv Frame Sync Invert */
#define SSI_SRCR_RFSL		(1 <<  1)	/* Rcv Frame Sync Length */
#define SSI_SRCR_REFS		(1 <<  0)	/* Rcv Early Frame Sync */

/* SSI Transmit Clock Control Register */
#define SSI_STCCR_DIV2		(1 << 18)	/* Divide by 2 */
#define SSI_STCCR_PSR		(1 << 17)	/* Prescaler Range */
#define SSI_STCCR_WL(x)		(((x)&0xF)<<13)	/* Word Length Control */
#define SSI_STCCR_DC(x)		(((x)&0x1F)<<8)	/* Frame Rate Divider Ctl */
#define SSI_STCCR_PM(x)		((x)&0xFF)	/* Prescaler Modulus Select */

/* SSI Receive Clock Control Register */
#define SSI_SRCCR_DIV2		(1 << 18)	/* Divide by 2 */
#define SSI_SRCCR_PSR		(1 << 17)	/* Prescaler Range */
#define SSI_SRCCR_WL(x)		(((x)&0xF)<<13)	/* Word Length Control */
#define SSI_SRCCR_DC(x)		(((x)&0x1F)<<8)	/* Frame Rate Divider Ctl */
#define SSI_SRCCR_PM(x)		((x)&0xFF)	/* Prescaler Modulus Select */

/* SSI FIFO Control/Status Register */
#define SSI_SFCSR_RFCNT1(x)	(((x)&0xF)<<28)	/* Rcv FIFO Counter 1 */
#define SSI_SFCSR_TFCNT1(x)	(((x)&0xF)<<24)	/* Xmit FIFO Counter 1 */
#define SSI_SFCSR_RFWM1(x)	(((x)&0xF)<<20)	/* Rcv FIFO Full Watermark 1 */
#define SSI_SFCSR_TFWM1(x)	(((x)&0xF)<<16)	/* Xmit FIFO Empty Wtrmrk 1 */
#define SSI_SFCSR_RFCNT0(x)	(((x)&0xF)<<12)	/* Rcv FIFO Counter 0 */
#define SSI_SFCSR_TFCNT0(x)	(((x)&0xF)<< 8)	/* Xmit FIFO Counter 0 */
#define SSI_SFCSR_RFWM0(x)	(((x)&0xF)<< 4)	/* Rcv FIFO Full Watermark 0 */
#define SSI_SFCSR_TFWM0(x)	(((x)&0xF)<< 0)	/* Xmit FIFO Empty Wtrmrk 0 */

/* SSI Test Register */
#define SSI_STR_TEST		(1 << 15)	/* Test Mode Enable */
#define SSI_STR_RCK2TCK		(1 << 14)	/* Rcv/Xmit Clock Loopback */
#define SSI_STR_RFS2TFS		(1 << 13)	/* Rcv/Xmit Frame Loopback */
#define SSI_STR_RXSTATE(x)	(((x)&0x1F)<<8)	/* Rcv State Machine Status */
#define SSI_STR_TXD2RXD		(1 <<  7)	/* Xmit/Rcv Data Loopback */
#define SSI_STR_TCK2RCK		(1 <<  6)	/* Xmit/Rcv Clock Loopback */
#define SSI_STR_TFS2RFS		(1 <<  5)	/* Xmit/Rcv Frame Loopback */
#define SSI_STR_TXSTATE(x)	(((x)&0x1F)<<0)	/* Xmit State Machine Status */

/* SSI Option Register */
#define SSI_SOR_CLKOFF		(1 <<  6)	/* Clock Off */
#define SSI_SOR_RX_CLR		(1 <<  5)	/* Rcv Clear */
#define SSI_SOR_TX_CLR		(1 <<  4)	/* Xmit Clear */
#define SSI_SOR_INIT		(1 <<  3)	/* Initialize */
#define SSI_SOR_WAIT(x)		(((x)&0x3)<<1)	/* Wait */
#define SSI_SOR_SYNRST		(1 <<  0)	/* Frame Syn Reset */

/* SSI AC97 Control Register */
#define SSI_SACNT_FRDIV(x)	(((x)&0x3F)<<5)	/* Frame Rate Divider */
#define SSI_SACNT_WR		(1 <<  4)	/* Write Command */
#define SSI_SACNT_RD		(1 <<  3)	/* Read Command */
#define SSI_SACNT_TIF		(1 <<  2)	/* Tag in FIFO */
#define SSI_SACNT_FV		(1 <<  1)	/* Fixed/Variable Operation */
#define SSI_SACNT_A97EN		(1 <<  0)	/* AC97 Mode Enable */

/* SSI AC97 Command Address Register */
#define SSI_SACADD(x)		((x)&0x7FFFF)	/* AC97 Command Register */

/* SSI AC97 Command Data Register */
#define SSI_SACDAT(x)		((x) & 0xFFFFF)	/* AC97 Command Data */

/* SSI AC97 Tag Register */
#define SSI_SATAG(x)		((x) & 0xFFFF)	/* AC97 Tag Register */

/* SSI Transmit Time Slot Mask Register */
#define SSI_STMSK(x)		(x)		/* Transmit Mask */

/* SSI Receive Time Slot Mask Register */
#define SSI_SRMSK(x)		(x)		/* Receive Mask */

#endif  /* __ASM_ARCH_SSI_H */
