/*
 *  linux/include/asm-arm/arch-imxads/system.h
 *
 *  Copyright (C) 1999 ARM Limited
 *  Copyright (C) 2000 Deep Blue Solutions Ltd
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ASM_ARCH_SYSTEM_H
#define __ASM_ARCH_SYSTEM_H

#include <asm/arch/hardware.h>

static void
arch_idle(void)
{
	/*
	 * This should do all the clock switching
	 * and wait for interrupt tricks
	 */
	HYPERVISOR_sched_op(SCHEDOP_block, 0);
}

static inline void
arch_reset(char mode)
{
#if defined(CONFIG_ARCH_IMX21)
	/* Enable watchdog and assert reset */
	PCCR1 |= PCCR1_WDT_EN;
	WCR = WCR_WDE;
#else /* !defined(CONFIG_ARCH_IMX21) */
	cpu_reset(0);
#endif /* !defined(CONFIG_ARCH_IMX21) */
}

#endif
