#ifndef __ASM_ARM_IRQFLAGS_H
#define __ASM_ARM_IRQFLAGS_H

#ifdef __KERNEL__

#include <asm/ptrace.h>

#ifdef CONFIG_XENOLINUX

#include <linux/types.h>
#include <linux/smp.h>
#include <linux/preempt.h>
#include <asm/page.h>
#include <xen/hypervisor.h>

#ifdef CONFIG_SMP
#define __vcpu_id smp_processor_id()
#else
#define __vcpu_id 0
#endif
 
#define __save_flags(x)                                                 \
	do {                                                            \
		volatile vcpu_info_t *_vcpu;                            \
		preempt_disable();					\
		_vcpu = &HYPERVISOR_shared_info->vcpu_info[__vcpu_id];	\
		(x) = _vcpu->evtchn_upcall_mask;                        \
		preempt_enable_no_resched();					\
		mb();	\
	} while (0)

#define __restore_flags(x)                                              \
	do {                                                            \
		volatile vcpu_info_t *_vcpu;                            \
		unsigned long temp;	\
		preempt_disable();					\
		_vcpu = &HYPERVISOR_shared_info->vcpu_info[__vcpu_id];	\
		temp =xchg(&_vcpu->evtchn_upcall_mask,(!!(x&0xff)));		\
		mb();	\
		if((_vcpu->evtchn_upcall_mask ) == 0) {			\
			barrier();					\
			if(unlikely(_vcpu->evtchn_upcall_pending))	\
				force_evtchn_callback();		\
			preempt_enable();			\
		}else {							\
			preempt_enable_no_resched();			\
		}							\
	} while (0)

#define __disable_evtchn()                                              \
	do {                                                            \
		volatile vcpu_info_t *_vcpu;                            \
		unsigned long temp;	\
		preempt_disable();					\
		_vcpu = &HYPERVISOR_shared_info->vcpu_info[__vcpu_id];	\
		temp = xchg(&_vcpu->evtchn_upcall_mask , 1);					\
		preempt_enable_no_resched();						\
		mb();	\
	} while (0)



#define __enable_evtchn()						\
	do {								\
	volatile vcpu_info_t *_vcpu;				\
		unsigned long temp;	\
		preempt_disable();					\
		_vcpu = &HYPERVISOR_shared_info->vcpu_info[__vcpu_id];	\
		temp =xchg(&_vcpu->evtchn_upcall_mask,0);					\
		mb();	\
		barrier();						\
		if(_vcpu->evtchn_upcall_pending)			\
			force_evtchn_callback();			\
		preempt_enable();					\
	} while (0)

#define __save_and_disable_evtchn(x)                                    \
	do {								\
		volatile vcpu_info_t *_vcpu; 				\
		preempt_disable();					\
		_vcpu = &HYPERVISOR_shared_info->vcpu_info[__vcpu_id]; 	\
		x = xchg(&_vcpu->evtchn_upcall_mask, 1); 			\
		preempt_enable_no_resched();				\
		mb();	\
	} while (0)



#define raw_local_irq_save(x)       __save_and_disable_evtchn(x)
#define raw_local_irq_enable()      __enable_evtchn()
#define raw_local_irq_disable()     __disable_evtchn()
#define local_fiq_enable()      __enable_evtchn()
#define local_fiq_disable()      __disable_evtchn()
#define raw_local_save_flags(x)     __save_flags(x)
#define raw_local_irq_restore(x)    __restore_flags(x)

#define raw_irqs_disabled_flags(flags)  \
	({                                      \
	 (int)((flags) & 0xff);     \
})

#else
/*
 * CPU interrupt mask handling.
 */
#if __LINUX_ARM_ARCH__ >= 6

#define raw_local_irq_save(x)					\
	({							\
	__asm__ __volatile__(					\
	"mrs	%0, cpsr		@ local_irq_save\n"	\
	"cpsid	i"						\
	: "=r" (x) : : "memory", "cc");				\
	})

#define raw_local_irq_enable()  __asm__("cpsie i	@ __sti" : : : "memory", "cc")
#define raw_local_irq_disable() __asm__("cpsid i	@ __cli" : : : "memory", "cc")
#define local_fiq_enable()  __asm__("cpsie f	@ __stf" : : : "memory", "cc")
#define local_fiq_disable() __asm__("cpsid f	@ __clf" : : : "memory", "cc")

#else

/*
 * Save the current interrupt enable state & disable IRQs
 */
#define raw_local_irq_save(x)					\
	({							\
		unsigned long temp;				\
		(void) (&temp == &x);				\
	__asm__ __volatile__(					\
	"mrs	%0, cpsr		@ local_irq_save\n"	\
"	orr	%1, %0, #128\n"					\
"	msr	cpsr_c, %1"					\
	: "=r" (x), "=r" (temp)					\
	:							\
	: "memory", "cc");					\
	})
	
/*
 * Enable IRQs
 */
#define raw_local_irq_enable()					\
	({							\
		unsigned long temp;				\
	__asm__ __volatile__(					\
	"mrs	%0, cpsr		@ local_irq_enable\n"	\
"	bic	%0, %0, #128\n"					\
"	msr	cpsr_c, %0"					\
	: "=r" (temp)						\
	:							\
	: "memory", "cc");					\
	})

/*
 * Disable IRQs
 */
#define raw_local_irq_disable()					\
	({							\
		unsigned long temp;				\
	__asm__ __volatile__(					\
	"mrs	%0, cpsr		@ local_irq_disable\n"	\
"	orr	%0, %0, #128\n"					\
"	msr	cpsr_c, %0"					\
	: "=r" (temp)						\
	:							\
	: "memory", "cc");					\
	})

/*
 * Enable FIQs
 */
#define local_fiq_enable()					\
	({							\
		unsigned long temp;				\
	__asm__ __volatile__(					\
	"mrs	%0, cpsr		@ stf\n"		\
"	bic	%0, %0, #64\n"					\
"	msr	cpsr_c, %0"					\
	: "=r" (temp)						\
	:							\
	: "memory", "cc");					\
	})

/*
 * Disable FIQs
 */
#define local_fiq_disable()					\
	({							\
		unsigned long temp;				\
	__asm__ __volatile__(					\
	"mrs	%0, cpsr		@ clf\n"		\
"	orr	%0, %0, #64\n"					\
"	msr	cpsr_c, %0"					\
	: "=r" (temp)						\
	:							\
	: "memory", "cc");					\
	})

#endif

/*
 * Save the current interrupt enable state.
 */
#define raw_local_save_flags(x)					\
	({							\
	__asm__ __volatile__(					\
	"mrs	%0, cpsr		@ local_save_flags"	\
	: "=r" (x) : : "memory", "cc");				\
	})

/*
 * restore saved IRQ & FIQ state
 */
#define raw_local_irq_restore(x)				\
	__asm__ __volatile__(					\
	"msr	cpsr_c, %0		@ local_irq_restore\n"	\
	:							\
	: "r" (x)						\
	: "memory", "cc")

#define raw_irqs_disabled_flags(flags)	\
({					\
	(int)((flags) & PSR_I_BIT);	\
})

#endif
#endif
#endif
