/*
 * kppif.h
 *   
 * Copyright (C) 2008 Samsung Electronics
 *          Cheol-Ryeon kim  <cr2104.kim@samsung.com>
 *          Dong-Hyuk lee  <dh5050.lee@samsung.com>
 *
 * Secure Xen on ARM architecture designed by Sang-bum Suh consists of
 * Xen on ARM and the associated access control.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public version 2 of License as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#include <linux/types.h>
#include <xen/interface/xen.h>
#include <xen/interface/grant_table.h>
#include <linux/list.h>
#include <linux/vmalloc.h>

typedef struct {
	unsigned char key;
	int value;
}kppif_data_t;

#define MAX_RING_SIZE 80

typedef struct {
	unsigned long rptr;
	unsigned long wptr;
	unsigned int counts;
	kppif_data_t sring[MAX_RING_SIZE];
}kppif_ring_t;

typedef struct kppif_st {
	/* Unique identifier for this interface. */
	domid_t           domid;
	unsigned int      handle;
	/* Physical parameters of the comms window. */
	unsigned int      evtchn;
	unsigned int      irq;
	/* Comms information. */
	struct vm_struct *kpp_ring_area;
	enum { DISCONNECTED, CONNECTED } status;
	grant_handle_t shmem_handle;
	grant_ref_t    shmem_ref;
	struct list_head list;
} kppif_t;

extern struct list_head frontkpps;
