#!/bin/bash
# Python cross build script written by Jaemin Ryu
#

# Modules generated by this script
IUSE="ncurses gdbm ssl readline tk berkdb bootstrap ipv6 ucs2 sqlite doc nocxx nothreads examples"

DISABLE_MODULES=""

TARGET_CC="arm-linux-gcc"

function build_host_python()
{
	make distclean
	sed -i \
	    -e '/^HOSTPYTHON/s:=.*:=$(BUILDPYTHON):' \
	    -e '/^HOSTPGEN/s:=.*:=$(PGEN)$(EXE):' \
	    Makefile.pre.in || return 1

	#
	OPT="-O1" CFLAGS="" LDFALGS="" CC="" ./configure --with-cxx=no

	make python Parser/pgen
	mv python hostpython
	mv Parser/pgen Parser/hostpgen

	return $?
}

function build_target_python()
{

	make distclean

	sed -i \
	    -e '/^HOSTPYTHON/s:=.*:=./hostpython:' \
	    -e '/^HOSTPGEN/s:=.*:=./Parser/hostpgen:' \
	    Makefile.pre.in || die

	CROSS_COMPILE="yes"
	PYTHON_DISABLE_MODULES="readline dbm gdbm _bsddb _curses _curses_panel _tkinter _sqlite3"
	PYTHON_DISBALE_SSL=0

	export CROSS_COMPILE
	export PYTHON_DISABLE_MODULES
	export PYTHON_DISABLE_SSL

	OPT="-mcpu=arm9 -O1" CFLAGS="" LDFLAGS="" CC="$TARGET_CC" \
	./configure --host=arm-linux --with-fpectl --enable-shared --disable-ipv6 --with-cxx=no --prefix="$ROOT_DIR"

	make

	return $?
}

function install_target_python()
{
	make install

	return $?
}

function usage()
{
	echo ""
	echo "Usage : " $0 "[OPTIONS]... [VAR=VALUE]..."
	echo ""
	echo "Options"
	echo "  -root DIR 		install target files into DIR"
	echo "  -compiler COMPILER	use COMPILER for cross-compile"
}

echo "Python 2.5 cross build helper."
echo ""


if [ `expr $# % 2` != 0 -o $# == 0 ]; then
	echo "Arguments not enough"
	usage
	exit -1
fi

i=$#

for arg in "$@"; do
	echo "I = " $i
	if [ `expr $i % 2` == 0 ]; then
		if [ "$arg"x == "-rootx" ]; then
			ROOT_DIR=$2
		elif [ "$arg"x == "-compilerx" ]; then
			TARGET_CC=$2
		else
			echo "Unknown options : " $arg

			exit -1
		fi
	fi
	shift
	i=`expr $i - 1`
done

echo "All target files will be installed in " $ROOT_DIR
echo $TARGET_CC " will be used for cross-compiling"

build_host_python

if [ $? != 0 ]; then
	echo "Host python build failed"

	exit $?
fi

build_target_python

if [ $? != 0 ]; then
	echo "Target python build failed"

	exit $?
fi

install_target_python

if [ $? != 0 ]; then
	echo "Target python installation failed."

	exit $?
fi

echo "DONE"

exit 0
