#if __XEN__
#include <xen/lib.h>
#undef malloc
#define malloc xmalloc_bytes
#undef free
#define free xfree
#else
#include <string.h>
#include <stdlib.h>
#endif
#include <embUnit/embUnit.h>

/*embunit:include=+ */
#include "crypto/crypto.h"
/*embunit:include=- */

extern int __setup_for_unit_test(char* pr, char* pu);


char pr[] = {
0x80, 0x00, 0xca, 0x9d, 0x0b, 0x4d, 0x23, 0xb1, 0xc1, 0x67, 0x89, 0xbe, 0xef, 0x6d, 0xd2, 0x58, 0xea, 0xae, 0xc2, 0x0f, 0x17, 0x4a, 0x33, 0x0d, 0x88, 0x3a, 0x08, 0xa4, 0x7b, 0xa1, 0xd6, 0xe7, 0x35, 0x0a, 0x9e, 0xeb, 0x3c, 0x18, 0xdc, 0x96, 0x38, 0x62, 0x16, 0xde, 0xd0, 0xd7, 0xe4, 0xb1, 0x85, 0x2a, 0x9e, 0x35, 0x17, 0xfe, 0x5e, 0x54, 0x0b, 0x5e, 0xfa, 0xc8, 0xdd, 0xa2, 0x44, 0x3e, 0x7b, 0x57, 0x3c, 0xd0, 0xc2, 0xf6, 0x6f, 0x3e, 0x64, 0x7d, 0xd1, 0x88, 0x27, 0x16, 0xed, 0x8e, 0x83, 0xdd, 0x4e, 0x43, 0x0c, 0xe0, 0xe4, 0x13, 0x9d, 0xcf, 0xe9, 0x7c, 0x08, 0x3b, 0xab, 0xae, 0x35, 0x91, 0x9b, 0x28, 0xee, 0xca, 0xea, 0xdc, 0xba, 0x7a, 0x48, 0xde, 0x32, 0xf4, 0x7f, 0x85, 0x67, 0xdb, 0x4a, 0x8a, 0x62, 0xd1, 0x0e, 0x82, 0x96, 0x88, 0xe3, 0x6f, 0x24, 0xa8, 0x4d, 0xe1, 0x70, 0xbf, 0x03, 0x00, 0x01, 0x00, 0x01, 0x80, 0x00, 0x6f, 0x3c, 0x40, 0xd4, 0x1c, 0xe0, 0x9e, 0x19, 0xc5, 0xd9, 0xf9, 0x81, 0x05, 0x96, 0xa3, 0x61, 0x46, 0x51, 0x1a, 0xac, 0x35, 0xd3, 0x1c, 0x13, 0x20, 0x63, 0x8d, 0x2c, 0x90, 0xdb, 0x66, 0x97, 0x6a, 0x20, 0x23, 0x62, 0x52, 0xd8, 0x76, 0x24, 0x04, 0x02, 0x58, 0x0d, 0xef, 0x14, 0x36, 0xd3, 0xea, 0xff, 0xa3, 0x28, 0x97, 0x88, 0xf4, 0xa5, 0x34, 0x71, 0xca, 0x9c, 0x27, 0x73, 0x56, 0x2a, 0xd8, 0x87, 0xb4, 0xad, 0x17, 0xdc, 0x8a, 0x1f, 0x04, 0x92, 0x7b, 0xac, 0xa3, 0x13, 0xa4, 0x4f, 0xf4, 0x8d, 0x93, 0xd9, 0x82, 0xa7, 0xeb, 0xb3, 0x63, 0x18, 0x2c, 0xd1, 0x6f, 0x9f, 0x77, 0xcf, 0xf5, 0x2a, 0x88, 0xd4, 0xe3, 0xac, 0x29, 0x68, 0xef, 0x05, 0x2f, 0xf2, 0xed, 0xe2, 0x5b, 0x1b, 0x24, 0xf8, 0x5b, 0x85, 0xde, 0xe5, 0x57, 0xa6, 0xa5, 0xb2, 0x3c, 0x50, 0x48, 0x4b, 0x5b, 0xa1, 0x40, 0x00, 0xec, 0xf7, 0x4d, 0x11, 0x0d, 0x82, 0x69, 0x02, 0x6a, 0x61, 0x1f, 0x4d, 0x6e, 0xe3, 0x68, 0x73, 0x46, 0x9f, 0x75, 0x10, 0x42, 0xfe, 0xad, 0xed, 0x5a, 0xc5, 0x16, 0x1f, 0x2f, 0x1f, 0x81, 0x22, 0x38, 0x6c, 0x01, 0xfe, 0x7d, 0x40, 0x7d, 0x8b, 0x6c, 0x83, 0xa6, 0xf8, 0x07, 0xec, 0x74, 0x46, 0x26, 0xbd, 0x6b, 0xc5, 0x00, 0x88, 0x6e, 0x6d, 0x7c, 0x6f, 0x9c, 0x7f, 0x2d, 0x71, 0x33, 0x6d, 0x40, 0x00, 0xda, 0xe3, 0x5b, 0x2a, 0x89, 0x4f, 0x97, 0x72, 0x88, 0x5a, 0xda, 0xd3, 0x7e, 0x44, 0x98, 0xfb, 0xd3, 0x58, 0xbd, 0x5c, 0x4b, 0x59, 0x6c, 0x93, 0x05, 0x06, 0xeb, 0x70, 0xab, 0x39, 0xcf, 0xd8, 0xae, 0x82, 0x89, 0xee, 0x85, 0x1c, 0x6a, 0x51, 0xc1, 0xd0, 0x4b, 0x52, 0xdc, 0x06, 0x49, 0xeb, 0x99, 0xff, 0xe7, 0xc6, 0xcb, 0x28, 0x78, 0xca, 0xbc, 0x83, 0xd4, 0x4d, 0x68, 0xc2, 0x2d, 0x5b, 0x40, 0x00, 0x10, 0xda, 0x61, 0xc3, 0xc5, 0xb7, 0x31, 0xaa, 0xb7, 0x50, 0x22, 0xfe, 0xc9, 0xd5, 0x28, 0x97, 0x92, 0x3d, 0x43, 0x01, 0x1e, 0x12, 0xa8, 0xe2, 0x09, 0xa3, 0x9c, 0xb8, 0x29, 0x0c, 0xcf, 0x8d, 0x54, 0x7f, 0xf2, 0x00, 0x5c, 0x7e, 0x1a, 0xaf, 0xb0, 0xcf, 0x08, 0x2f, 0xf9, 0xb8, 0x4a, 0x68, 0xb6, 0xd6, 0x9f, 0xf4, 0x89, 0xde, 0x2a, 0x24, 0x65, 0x46, 0x36, 0xd6, 0x20, 0xb0, 0x3d, 0x5d, 0x40, 0x00, 0xb0, 0xe0, 0xee, 0x87, 0xb6, 0x03, 0xf2, 0x2f, 0x24, 0x4e, 0xbe, 0xec, 0x0e, 0xea, 0x21, 0xf1, 0xc5, 0x7c, 0xbd, 0x30, 0x7a, 0xd7, 0x1d, 0x6c, 0xc4, 0xb0, 0x2d, 0xcb, 0x93, 0x22, 0x19, 0x7a, 0x50, 0xb2, 0xbe, 0x01, 0x57, 0xe1, 0x79, 0x6c, 0xed, 0xc0, 0x83, 0x4d, 0xc6, 0xec, 0xf2, 0x09, 0x08, 0x1e, 0x0a, 0x4e, 0xd3, 0x56, 0xb6, 0x1d, 0xa6, 0x2e, 0xa5, 0x7d, 0x94, 0x3c, 0xed, 0x67, 0x40, 0x00, 0x6d, 0xc2, 0xc1, 0x29, 0x0f, 0x7b, 0xde, 0xfd, 0x88, 0xff, 0x17, 0xd3, 0x23, 0x81, 0xa3, 0x63, 0xde, 0x66, 0xb0, 0xd7, 0xc5, 0xac, 0x1e, 0xbf, 0xbe, 0x29, 0xf7, 0xf7, 0x27, 0xff, 0x10, 0x45, 0x92, 0x5a, 0xe1, 0xf8, 0x96, 0x0c, 0x54, 0x20, 0x91, 0xe1, 0x29, 0x3b, 0xd1, 0xbb, 0x91, 0xe2, 0xd9, 0x99, 0x25, 0x54, 0xaf, 0x74, 0x3b, 0x71, 0x91, 0xb8, 0x3c, 0x09, 0xdf, 0x36, 0xbf, 0xcd, 0x0a };

char pu[] = {
0x03, 0x00, 0x01, 0x00, 0x01, 0x80, 0x00, 0xca, 0x9d, 0x0b, 0x4d, 0x23, 0xb1, 0xc1, 0x67, 0x89, 0xbe, 0xef, 0x6d, 0xd2, 0x58, 0xea, 0xae, 0xc2, 0x0f, 0x17, 0x4a, 0x33, 0x0d, 0x88, 0x3a, 0x08, 0xa4, 0x7b, 0xa1, 0xd6, 0xe7, 0x35, 0x0a, 0x9e, 0xeb, 0x3c, 0x18, 0xdc, 0x96, 0x38, 0x62, 0x16, 0xde, 0xd0, 0xd7, 0xe4, 0xb1, 0x85, 0x2a, 0x9e, 0x35, 0x17, 0xfe, 0x5e, 0x54, 0x0b, 0x5e, 0xfa, 0xc8, 0xdd, 0xa2, 0x44, 0x3e, 0x7b, 0x57, 0x3c, 0xd0, 0xc2, 0xf6, 0x6f, 0x3e, 0x64, 0x7d, 0xd1, 0x88, 0x27, 0x16, 0xed, 0x8e, 0x83, 0xdd, 0x4e, 0x43, 0x0c, 0xe0, 0xe4, 0x13, 0x9d, 0xcf, 0xe9, 0x7c, 0x08, 0x3b, 0xab, 0xae, 0x35, 0x91, 0x9b, 0x28, 0xee, 0xca, 0xea, 0xdc, 0xba, 0x7a, 0x48, 0xde, 0x32, 0xf4, 0x7f, 0x85, 0x67, 0xdb, 0x4a, 0x8a, 0x62, 0xd1, 0x0e, 0x82, 0x96, 0x88, 0xe3, 0x6f, 0x24, 0xa8, 0x4d, 0xe1, 0x70, 0xbf, 0x0a }; 

static void test_crypto_init(void)
{
	// UB_CR_INIT_1
	TEST_ASSERT(crypto_init() == 0);
	// UB_CR_INIT_2 
	/*
	ssb_image_container_t sp1;
	memset(&sp1, 0, sizeof(sp1));
	ssb_read_sp(&sp1, PART_SP1);
	default_struct_t* pub_key = get_sp_image(&sp1, CERTM_IMG);
	ssb_add_image(&sp1, NULL);
	TEST_ASSERT(crypto_init() != 0);
	ssb_add_image(&sp1, pub_key);
	*/
	// UB_CR_INIT_3 
	/*
	crypto_init();
	*/
}

static void test_crypto_encrypt_data(void)
{
	unsigned char* src = "This is the source text for the encoding test.";
	int src_len = strlen(src);
	unsigned char* dest = (unsigned char*)malloc(256);
	int dest_len = 256;

	TEST_ASSERT(dest != NULL);
	// UB_CR_ENC_1
	TEST_ASSERT(crypto_encrypt_data(src, src_len, &dest, &dest_len) == 0);
	// UB_CR_ENC_3
	dest_len = 10;
	TEST_ASSERT(crypto_encrypt_data(src, src_len, &dest, &dest_len) != 0);
	free(dest);
	// UB_CR_ENC_2
	dest = NULL;
	TEST_ASSERT(crypto_encrypt_data(src, src_len, &dest, &dest_len) == 0);
	crypto_free(dest);
	// UB_CR_ENC_4
	src = NULL;
	TEST_ASSERT(crypto_encrypt_data(src, src_len, &dest, &dest_len) != 0);
}


static void test_crypto_decrypt_data(void)
{
	unsigned char* src = "This is the source text for the decoding test.";
	int src_len = strlen(src);
	unsigned char* dest = (unsigned char*)malloc(256);
	int dest_len = 256;

	TEST_ASSERT(dest != NULL);
	// UB_CR_DEC_1
	TEST_ASSERT(crypto_decrypt_data(src, src_len, &dest, &dest_len) == 0);
	// UB_CR_DEC_3
	dest_len = 10;
	TEST_ASSERT(crypto_decrypt_data(src, src_len, &dest, &dest_len) != 0);
	free(dest);
	// UB_CR_DEC_2
	dest = NULL;
	TEST_ASSERT(crypto_decrypt_data(src, src_len, &dest, &dest_len) == 0);
	crypto_free(dest);
	// UB_CR_DEC_4
	src = NULL;
	TEST_ASSERT(crypto_decrypt_data(src, src_len, &dest, &dest_len) != 0);
}


static void test_crypto_sign_data(void)
{
	unsigned char* src = "This is the source text for the signing test.";
	int src_len = strlen(src);
	unsigned char* sig = (unsigned char*)malloc(256);
	int sig_len = 256;

	TEST_ASSERT(sig != NULL);
	// UB_CR_SIGN_1
	TEST_ASSERT(crypto_sign_data(src, src_len, &sig, &sig_len) == 0);
	// UB_CR_SIGN_3
	sig_len = 10;
	TEST_ASSERT(crypto_sign_data(src, src_len, &sig, &sig_len) != 0);
	free(sig);
	// UB_CR_SIGN_2
	sig = NULL;
	TEST_ASSERT(crypto_sign_data(src, src_len, &sig, &sig_len) == 0);
	crypto_free(sig);
	// UB_CR_SIGN_4
	src = NULL;
	TEST_ASSERT(crypto_sign_data(src, src_len, &sig, &sig_len) != 0);
}


static void test_crypto_verify_data(void)
{
	unsigned char* src = "This is the source text for the signing test.";
	int src_len = strlen(src);
	unsigned char* sig = NULL;
	int sig_len = 0;
	
	// get signature
	TEST_ASSERT(crypto_sign_data(src, src_len, &sig, &sig_len) == 0);
	TEST_ASSERT(sig != NULL && sig_len > 0);

	// UB_CR_VERIFY_1
	TEST_ASSERT(crypto_verify_data(src, src_len, sig, sig_len) == 0);
	// UB_CR_VERIFY_2
	sig_len--;
	TEST_ASSERT(crypto_verify_data(src, src_len, sig, sig_len) != 0);
	// UB_CR_VERIFY_3
	TEST_ASSERT(crypto_verify_data(NULL, src_len, sig, sig_len) == -1);
	TEST_ASSERT(crypto_verify_data(src, -1, sig, sig_len) == -1);
	free(sig);
}

static void test_crypto_hash_data(void)
{
	unsigned char* src = "This is the source text for the hashing test.";
	int src_len = strlen(src);
	unsigned char* hash = malloc(256);
	int hash_len = 256;

	TEST_ASSERT(hash != NULL);
	// UB_CR_HASH_1
	TEST_ASSERT(crypto_hash_data(src, src_len, &hash, &hash_len) == 0);
	// UB_CR_HASH_3
	hash_len = 10;
	TEST_ASSERT(crypto_hash_data(src, src_len, &hash, &hash_len) != 0);
	free(hash);
	// UB_CR_HASH_2
	hash = NULL;
	TEST_ASSERT(crypto_hash_data(src, src_len, &hash, &hash_len) == 0);
	crypto_free(hash);
	// UB_CR_HASH_4
	src = NULL;
	TEST_ASSERT(crypto_hash_data(src, src_len, &hash, &hash_len) != 0);

}

static void test_crypto_free(void)
{
	unsigned char* src = "This is the source text for the hashing test.";
	int src_len = strlen(src);
	unsigned char* hash = NULL;
	int hash_len;
	TEST_ASSERT(crypto_hash_data(src, src_len, &hash, &hash_len) == 0);

	// UB_CR_FRE_1
	crypto_free(hash);
	// UB_CR_FRE_2
	crypto_free(NULL);
}


static void setUp(void)
{
	/* initialize */
	__setup_for_unit_test(pr, pu);
	crypto_init();
}

static void tearDown(void)
{
	/* terminate */
}

/*embunit:impl=+ */
/*embunit:impl=- */
TestRef uboot_sboot_func_test(void)
{
	EMB_UNIT_TESTFIXTURES(fixtures) {
		new_TestFixture("test_crypto_init", test_crypto_init),
		new_TestFixture("test_crypto_encrypt_data", test_crypto_encrypt_data),
		new_TestFixture("test_crypto_decrypt_data", test_crypto_decrypt_data),
		new_TestFixture("test_crypto_sign_data", test_crypto_sign_data),
		new_TestFixture("test_crypto_verify_data", test_crypto_verify_data),
		new_TestFixture("test_crypto_hash_data", test_crypto_hash_data),
		new_TestFixture("test_crypto_free", test_crypto_free)
	/*embunit:fixtures=+ */
	/*embunit:fixtures=- */
	};
	EMB_UNIT_TESTCALLER(test_uboot,"test_uboot",setUp,tearDown,fixtures);
	return (TestRef)&test_uboot;
};
