/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARAPBPM_H_INC_
#define ___ARAPBPM_H_INC_

// Register APBDEV_PMC_CNTRL_0  
#define APBDEV_PMC_CNTRL_0                      _MK_ADDR_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_WORD_COUNT                   0x1
#define APBDEV_PMC_CNTRL_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_RESET_MASK                   _MK_MASK_CONST(0x7fff)
#define APBDEV_PMC_CNTRL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_READ_MASK                    _MK_MASK_CONST(0x7fff)
#define APBDEV_PMC_CNTRL_0_WRITE_MASK                   _MK_MASK_CONST(0x7fff)
// Disable 32KHz clock to KBC 
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_SHIFT)
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_RANGE                    0:0
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_WOFFSET                  0x0
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_DISABLE                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_ENABLE                   _MK_ENUM_CONST(1)

// Disable  32KHz clock to RTC                          
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_SHIFT                    _MK_SHIFT_CONST(1)
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_SHIFT)
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_RANGE                    1:1
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_WOFFSET                  0x0
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_DISABLE                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_ENABLE                   _MK_ENUM_CONST(1)

// Software reset to RTC
#define APBDEV_PMC_CNTRL_0_RTC_RST_SHIFT                        _MK_SHIFT_CONST(2)
#define APBDEV_PMC_CNTRL_0_RTC_RST_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_RTC_RST_SHIFT)
#define APBDEV_PMC_CNTRL_0_RTC_RST_RANGE                        2:2
#define APBDEV_PMC_CNTRL_0_RTC_RST_WOFFSET                      0x0
#define APBDEV_PMC_CNTRL_0_RTC_RST_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_RTC_RST_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_RTC_RST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_RTC_RST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_RTC_RST_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_RTC_RST_ENABLE                       _MK_ENUM_CONST(1)

// Software reset to KBC  
#define APBDEV_PMC_CNTRL_0_KBC_RST_SHIFT                        _MK_SHIFT_CONST(3)
#define APBDEV_PMC_CNTRL_0_KBC_RST_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_KBC_RST_SHIFT)
#define APBDEV_PMC_CNTRL_0_KBC_RST_RANGE                        3:3
#define APBDEV_PMC_CNTRL_0_KBC_RST_WOFFSET                      0x0
#define APBDEV_PMC_CNTRL_0_KBC_RST_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_KBC_RST_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_KBC_RST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_KBC_RST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_KBC_RST_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_KBC_RST_ENABLE                       _MK_ENUM_CONST(1)

// Reset to CAR - generates 2 clock cycle  pulse. 
#define APBDEV_PMC_CNTRL_0_MAIN_RST_SHIFT                       _MK_SHIFT_CONST(4)
#define APBDEV_PMC_CNTRL_0_MAIN_RST_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_MAIN_RST_SHIFT)
#define APBDEV_PMC_CNTRL_0_MAIN_RST_RANGE                       4:4
#define APBDEV_PMC_CNTRL_0_MAIN_RST_WOFFSET                     0x0
#define APBDEV_PMC_CNTRL_0_MAIN_RST_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_MAIN_RST_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_MAIN_RST_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_MAIN_RST_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_MAIN_RST_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_MAIN_RST_ENABLE                      _MK_ENUM_CONST(1)

// Enables latching wakeup events - stops latching   on transition from 1 to 0(sequence - set to 1,set to 0) 
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_SHIFT                   _MK_SHIFT_CONST(5)
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_SHIFT)
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_RANGE                   5:5
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_WOFFSET                 0x0
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_DISABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_ENABLE                  _MK_ENUM_CONST(1)

// Disable  detecting glitch on wakeup event- in default operation glitches are ignored on wakeup lines. if this bit is set to 1, glitch (event shorter than half 32khz clock, will be causing wakeup from lp0
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_SHIFT                  _MK_SHIFT_CONST(6)
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_SHIFT)
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_RANGE                  6:6
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_WOFFSET                        0x0
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_DISABLE                        _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_ENABLE                 _MK_ENUM_CONST(1)

// Enables blinking counter and blink output -works only if BLINK field in DPD_PADS_ORIDE is set to 1
#define APBDEV_PMC_CNTRL_0_BLINK_EN_SHIFT                       _MK_SHIFT_CONST(7)
#define APBDEV_PMC_CNTRL_0_BLINK_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_BLINK_EN_SHIFT)
#define APBDEV_PMC_CNTRL_0_BLINK_EN_RANGE                       7:7
#define APBDEV_PMC_CNTRL_0_BLINK_EN_WOFFSET                     0x0
#define APBDEV_PMC_CNTRL_0_BLINK_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_BLINK_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_BLINK_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_BLINK_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_BLINK_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_BLINK_EN_ENABLE                      _MK_ENUM_CONST(1)

// Inverts power request polarity
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_SHIFT                        _MK_SHIFT_CONST(8)
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_SHIFT)
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_RANGE                        8:8
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_WOFFSET                      0x0
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_NORMAL                       _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_INVERT                       _MK_ENUM_CONST(1)

// Power request output enable. resets to tristate
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_SHIFT                      _MK_SHIFT_CONST(9)
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_PWRREQ_OE_SHIFT)
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_RANGE                      9:9
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_WOFFSET                    0x0
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_ENABLE                     _MK_ENUM_CONST(1)

// Inverts system clock enable polarity 
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_SHIFT                        _MK_SHIFT_CONST(10)
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_SHIFT)
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_RANGE                        10:10
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_WOFFSET                      0x0
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_NORMAL                       _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_INVERT                       _MK_ENUM_CONST(1)

// Enables output of system enable clock - works only if SYS_CLK field in DPD_PADS_ORIDE is set to 1. resets to tristate
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_SHIFT                      _MK_SHIFT_CONST(11)
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_SYSCLK_OE_SHIFT)
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_RANGE                      11:11
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_WOFFSET                    0x0
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_ENABLE                     _MK_ENUM_CONST(1)

// Disable  power gating - global override, will override function of PWRGATE_TOGGLE register. all partitions will stay enabled. 
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_SHIFT                    _MK_SHIFT_CONST(12)
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_PWRGATE_DIS_SHIFT)
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_RANGE                    12:12
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_WOFFSET                  0x0
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_DISABLE                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_ENABLE                   _MK_ENUM_CONST(1)

// AO intitlized  purely sftw diagnostic and interpretation
#define APBDEV_PMC_CNTRL_0_AOINIT_SHIFT                 _MK_SHIFT_CONST(13)
#define APBDEV_PMC_CNTRL_0_AOINIT_FIELD                 (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_AOINIT_SHIFT)
#define APBDEV_PMC_CNTRL_0_AOINIT_RANGE                 13:13
#define APBDEV_PMC_CNTRL_0_AOINIT_WOFFSET                       0x0
#define APBDEV_PMC_CNTRL_0_AOINIT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_AOINIT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_AOINIT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_AOINIT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_AOINIT_NOTDONE                       _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_AOINIT_DONE                  _MK_ENUM_CONST(1)

// when set causes side effect of entering lp0 after powering down cpu
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_SHIFT                        _MK_SHIFT_CONST(14)
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_SHIFT)
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_RANGE                        14:14
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_WOFFSET                      0x0
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_ENABLE                       _MK_ENUM_CONST(1)


// Register APBDEV_PMC_SEC_DISABLE_0  
#define APBDEV_PMC_SEC_DISABLE_0                        _MK_ADDR_CONST(0x4)
#define APBDEV_PMC_SEC_DISABLE_0_WORD_COUNT                     0x1
#define APBDEV_PMC_SEC_DISABLE_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_RESET_MASK                     _MK_MASK_CONST(0x3)
#define APBDEV_PMC_SEC_DISABLE_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_READ_MASK                      _MK_MASK_CONST(0x3)
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_MASK                     _MK_MASK_CONST(0x3)
// disable write to secure registers
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_SEC_DISABLE_0_WRITE_SHIFT)
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_RANGE                    0:0
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_WOFFSET                  0x0
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_OFF                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_ON                       _MK_ENUM_CONST(1)

// disable read  from  secure registers
#define APBDEV_PMC_SEC_DISABLE_0_READ_SHIFT                     _MK_SHIFT_CONST(1)
#define APBDEV_PMC_SEC_DISABLE_0_READ_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_SEC_DISABLE_0_READ_SHIFT)
#define APBDEV_PMC_SEC_DISABLE_0_READ_RANGE                     1:1
#define APBDEV_PMC_SEC_DISABLE_0_READ_WOFFSET                   0x0
#define APBDEV_PMC_SEC_DISABLE_0_READ_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_READ_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SEC_DISABLE_0_READ_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_READ_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_READ_OFF                       _MK_ENUM_CONST(0)
#define APBDEV_PMC_SEC_DISABLE_0_READ_ON                        _MK_ENUM_CONST(1)


// Register APBDEV_PMC_PMC_SWRST_0  
#define APBDEV_PMC_PMC_SWRST_0                  _MK_ADDR_CONST(0x8)
#define APBDEV_PMC_PMC_SWRST_0_WORD_COUNT                       0x1
#define APBDEV_PMC_PMC_SWRST_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PMC_SWRST_0_RESET_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PMC_SWRST_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PMC_SWRST_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PMC_SWRST_0_READ_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PMC_SWRST_0_WRITE_MASK                       _MK_MASK_CONST(0x1)
//software reset to pmc only
#define APBDEV_PMC_PMC_SWRST_0_RST_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PMC_SWRST_0_RST_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_PMC_SWRST_0_RST_SHIFT)
#define APBDEV_PMC_PMC_SWRST_0_RST_RANGE                        0:0
#define APBDEV_PMC_PMC_SWRST_0_RST_WOFFSET                      0x0
#define APBDEV_PMC_PMC_SWRST_0_RST_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PMC_SWRST_0_RST_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PMC_SWRST_0_RST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PMC_SWRST_0_RST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PMC_SWRST_0_RST_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_PMC_SWRST_0_RST_ENABLE                       _MK_ENUM_CONST(1)


// Register APBDEV_PMC_WAKE_MASK_0  
#define APBDEV_PMC_WAKE_MASK_0                  _MK_ADDR_CONST(0xc)
#define APBDEV_PMC_WAKE_MASK_0_WORD_COUNT                       0x1
#define APBDEV_PMC_WAKE_MASK_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_RESET_MASK                       _MK_MASK_CONST(0xfffff)
#define APBDEV_PMC_WAKE_MASK_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_READ_MASK                        _MK_MASK_CONST(0xfffff)
#define APBDEV_PMC_WAKE_MASK_0_WRITE_MASK                       _MK_MASK_CONST(0xfffff)
// pin  0-15  wake enable      
#define APBDEV_PMC_WAKE_MASK_0_EVENT_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_FIELD                      (_MK_MASK_CONST(0xffff) << APBDEV_PMC_WAKE_MASK_0_EVENT_SHIFT)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_RANGE                      15:0
#define APBDEV_PMC_WAKE_MASK_0_EVENT_WOFFSET                    0x0
#define APBDEV_PMC_WAKE_MASK_0_EVENT_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_DEFAULT_MASK                       _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_ENABLE                     _MK_ENUM_CONST(1)

// RTC  wake enable                
#define APBDEV_PMC_WAKE_MASK_0_RTC_SHIFT                        _MK_SHIFT_CONST(16)
#define APBDEV_PMC_WAKE_MASK_0_RTC_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_MASK_0_RTC_SHIFT)
#define APBDEV_PMC_WAKE_MASK_0_RTC_RANGE                        16:16
#define APBDEV_PMC_WAKE_MASK_0_RTC_WOFFSET                      0x0
#define APBDEV_PMC_WAKE_MASK_0_RTC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_RTC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_MASK_0_RTC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_RTC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_RTC_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_MASK_0_RTC_ENABLE                       _MK_ENUM_CONST(1)

// KBC  wake  enable                
#define APBDEV_PMC_WAKE_MASK_0_KBC_SHIFT                        _MK_SHIFT_CONST(17)
#define APBDEV_PMC_WAKE_MASK_0_KBC_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_MASK_0_KBC_SHIFT)
#define APBDEV_PMC_WAKE_MASK_0_KBC_RANGE                        17:17
#define APBDEV_PMC_WAKE_MASK_0_KBC_WOFFSET                      0x0
#define APBDEV_PMC_WAKE_MASK_0_KBC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_KBC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_MASK_0_KBC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_KBC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_KBC_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_MASK_0_KBC_ENABLE                       _MK_ENUM_CONST(1)

// PWR_INT wake enable               
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_SHIFT                    _MK_SHIFT_CONST(18)
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_MASK_0_PWR_INT_SHIFT)
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_RANGE                    18:18
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_WOFFSET                  0x0
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_DISABLE                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_ENABLE                   _MK_ENUM_CONST(1)

// external reset  wake  enable                
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_SHIFT                    _MK_SHIFT_CONST(19)
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_MASK_0_RESET_N_SHIFT)
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_RANGE                    19:19
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_WOFFSET                  0x0
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_DISABLE                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_ENABLE                   _MK_ENUM_CONST(1)


// Register APBDEV_PMC_WAKE_LVL_0  
#define APBDEV_PMC_WAKE_LVL_0                   _MK_ADDR_CONST(0x10)
#define APBDEV_PMC_WAKE_LVL_0_WORD_COUNT                        0x1
#define APBDEV_PMC_WAKE_LVL_0_RESET_VAL                         _MK_MASK_CONST(0x7ffff)
#define APBDEV_PMC_WAKE_LVL_0_RESET_MASK                        _MK_MASK_CONST(0xfffff)
#define APBDEV_PMC_WAKE_LVL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_READ_MASK                         _MK_MASK_CONST(0xfffff)
#define APBDEV_PMC_WAKE_LVL_0_WRITE_MASK                        _MK_MASK_CONST(0xfffff)
// pin 0-15 wake  level       
#define APBDEV_PMC_WAKE_LVL_0_EVENT_SHIFT                       _MK_SHIFT_CONST(0)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_FIELD                       (_MK_MASK_CONST(0xffff) << APBDEV_PMC_WAKE_LVL_0_EVENT_SHIFT)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_RANGE                       15:0
#define APBDEV_PMC_WAKE_LVL_0_EVENT_WOFFSET                     0x0
#define APBDEV_PMC_WAKE_LVL_0_EVENT_DEFAULT                     _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_DEFAULT_MASK                        _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_ACTIVE_LOW                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_ACTIVE_HIGH                 _MK_ENUM_CONST(1)

// RTC  wake  level               
#define APBDEV_PMC_WAKE_LVL_0_RTC_SHIFT                 _MK_SHIFT_CONST(16)
#define APBDEV_PMC_WAKE_LVL_0_RTC_FIELD                 (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_LVL_0_RTC_SHIFT)
#define APBDEV_PMC_WAKE_LVL_0_RTC_RANGE                 16:16
#define APBDEV_PMC_WAKE_LVL_0_RTC_WOFFSET                       0x0
#define APBDEV_PMC_WAKE_LVL_0_RTC_DEFAULT                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_LVL_0_RTC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_LVL_0_RTC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_RTC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_RTC_ACTIVE_LOW                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_LVL_0_RTC_ACTIVE_HIGH                   _MK_ENUM_CONST(1)

// KBC  wake level                
#define APBDEV_PMC_WAKE_LVL_0_KBC_SHIFT                 _MK_SHIFT_CONST(17)
#define APBDEV_PMC_WAKE_LVL_0_KBC_FIELD                 (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_LVL_0_KBC_SHIFT)
#define APBDEV_PMC_WAKE_LVL_0_KBC_RANGE                 17:17
#define APBDEV_PMC_WAKE_LVL_0_KBC_WOFFSET                       0x0
#define APBDEV_PMC_WAKE_LVL_0_KBC_DEFAULT                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_LVL_0_KBC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_LVL_0_KBC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_KBC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_KBC_ACTIVE_LOW                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_LVL_0_KBC_ACTIVE_HIGH                   _MK_ENUM_CONST(1)

// power interrupt - now pernamently tied to  bit 18            
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_SHIFT                     _MK_SHIFT_CONST(18)
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_LVL_0_PWR_INT_SHIFT)
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_RANGE                     18:18
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_WOFFSET                   0x0
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_ACTIVE_LOW                        _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_ACTIVE_HIGH                       _MK_ENUM_CONST(1)

// external reset wake level (low active!)              
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_SHIFT                     _MK_SHIFT_CONST(19)
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_LVL_0_RESET_N_SHIFT)
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_RANGE                     19:19
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_WOFFSET                   0x0
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_ACTIVE_LOW                        _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_ACTIVE_HIGH                       _MK_ENUM_CONST(1)


// Register APBDEV_PMC_WAKE_STATUS_0  
#define APBDEV_PMC_WAKE_STATUS_0                        _MK_ADDR_CONST(0x14)
#define APBDEV_PMC_WAKE_STATUS_0_WORD_COUNT                     0x1
#define APBDEV_PMC_WAKE_STATUS_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_RESET_MASK                     _MK_MASK_CONST(0xfffff)
#define APBDEV_PMC_WAKE_STATUS_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_READ_MASK                      _MK_MASK_CONST(0xfffff)
#define APBDEV_PMC_WAKE_STATUS_0_WRITE_MASK                     _MK_MASK_CONST(0xfffff)
// pin 0-15 wake    
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_FIELD                    (_MK_MASK_CONST(0xffff) << APBDEV_PMC_WAKE_STATUS_0_EVENT_SHIFT)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_RANGE                    15:0
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_WOFFSET                  0x0
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_DEFAULT_MASK                     _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_NOT_SET                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_SET                      _MK_ENUM_CONST(1)

// RTC wake                
#define APBDEV_PMC_WAKE_STATUS_0_RTC_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDEV_PMC_WAKE_STATUS_0_RTC_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_STATUS_0_RTC_SHIFT)
#define APBDEV_PMC_WAKE_STATUS_0_RTC_RANGE                      16:16
#define APBDEV_PMC_WAKE_STATUS_0_RTC_WOFFSET                    0x0
#define APBDEV_PMC_WAKE_STATUS_0_RTC_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_RTC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_STATUS_0_RTC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_RTC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_RTC_NOT_SET                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_STATUS_0_RTC_SET                        _MK_ENUM_CONST(1)

// KBC wake              
#define APBDEV_PMC_WAKE_STATUS_0_KBC_SHIFT                      _MK_SHIFT_CONST(17)
#define APBDEV_PMC_WAKE_STATUS_0_KBC_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_STATUS_0_KBC_SHIFT)
#define APBDEV_PMC_WAKE_STATUS_0_KBC_RANGE                      17:17
#define APBDEV_PMC_WAKE_STATUS_0_KBC_WOFFSET                    0x0
#define APBDEV_PMC_WAKE_STATUS_0_KBC_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_KBC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_STATUS_0_KBC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_KBC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_KBC_NOT_SET                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_STATUS_0_KBC_SET                        _MK_ENUM_CONST(1)

// power interrupt            
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_SHIFT                  _MK_SHIFT_CONST(18)
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_STATUS_0_PWR_INT_SHIFT)
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_RANGE                  18:18
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_WOFFSET                        0x0
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_NOT_SET                        _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_SET                    _MK_ENUM_CONST(1)

// external reset            
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_SHIFT                  _MK_SHIFT_CONST(19)
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_STATUS_0_RESET_N_SHIFT)
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_RANGE                  19:19
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_WOFFSET                        0x0
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_NOT_SET                        _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_SET                    _MK_ENUM_CONST(1)


// Register APBDEV_PMC_SW_WAKE_STATUS_0  
#define APBDEV_PMC_SW_WAKE_STATUS_0                     _MK_ADDR_CONST(0x18)
#define APBDEV_PMC_SW_WAKE_STATUS_0_WORD_COUNT                  0x1
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_MASK                  _MK_MASK_CONST(0xfffff)
#define APBDEV_PMC_SW_WAKE_STATUS_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_READ_MASK                   _MK_MASK_CONST(0xfffff)
#define APBDEV_PMC_SW_WAKE_STATUS_0_WRITE_MASK                  _MK_MASK_CONST(0xfffff)
// pin 0-15 wake    
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_SHIFT                 _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_FIELD                 (_MK_MASK_CONST(0xffff) << APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_SHIFT)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_RANGE                 15:0
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_WOFFSET                       0x0
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_DISABLE                       _MK_ENUM_CONST(0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_ENABLE                        _MK_ENUM_CONST(1)

// RTC wake                
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_SHIFT                   _MK_SHIFT_CONST(16)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_SW_WAKE_STATUS_0_RTC_SHIFT)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_RANGE                   16:16
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_WOFFSET                 0x0
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_DISABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_ENABLE                  _MK_ENUM_CONST(1)

// KBC wake              
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_SHIFT                   _MK_SHIFT_CONST(17)
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_SW_WAKE_STATUS_0_KBC_SHIFT)
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_RANGE                   17:17
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_WOFFSET                 0x0
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_DISABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_ENABLE                  _MK_ENUM_CONST(1)

// power interrupt            
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_SHIFT                       _MK_SHIFT_CONST(18)
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_SHIFT)
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_RANGE                       18:18
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_WOFFSET                     0x0
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_NOT_SET                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_SET                 _MK_ENUM_CONST(1)

// external reset            
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_SHIFT                       _MK_SHIFT_CONST(19)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_SHIFT)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_RANGE                       19:19
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_WOFFSET                     0x0
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_NOT_SET                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_SET                 _MK_ENUM_CONST(1)


// Register APBDEV_PMC_DPD_PADS_ORIDE_0  
#define APBDEV_PMC_DPD_PADS_ORIDE_0                     _MK_ADDR_CONST(0x1c)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_WORD_COUNT                  0x1
#define APBDEV_PMC_DPD_PADS_ORIDE_0_RESET_VAL                   _MK_MASK_CONST(0x200000)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_RESET_MASK                  _MK_MASK_CONST(0x3fffff)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_READ_MASK                   _MK_MASK_CONST(0x3fffff)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_WRITE_MASK                  _MK_MASK_CONST(0x3fffff)
//override dpd idle state with column 0 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_RANGE                      0:0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 1 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_SHIFT                      _MK_SHIFT_CONST(1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_RANGE                      1:1
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 2 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_SHIFT                      _MK_SHIFT_CONST(2)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_RANGE                      2:2
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 3 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_SHIFT                      _MK_SHIFT_CONST(3)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_RANGE                      3:3
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 4 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_SHIFT                      _MK_SHIFT_CONST(4)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_RANGE                      4:4
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 5 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_SHIFT                      _MK_SHIFT_CONST(5)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_RANGE                      5:5
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 6 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_SHIFT                      _MK_SHIFT_CONST(6)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_RANGE                      6:6
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 7 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_SHIFT                      _MK_SHIFT_CONST(7)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_RANGE                      7:7
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 8 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_SHIFT                      _MK_SHIFT_CONST(8)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_RANGE                      8:8
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 9 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_SHIFT                      _MK_SHIFT_CONST(9)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_RANGE                      9:9
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 10 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_SHIFT                     _MK_SHIFT_CONST(10)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_RANGE                     10:10
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_WOFFSET                   0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_DISABLE                   _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_ENABLE                    _MK_ENUM_CONST(1)

//override dpd idle state with column 11 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_SHIFT                     _MK_SHIFT_CONST(11)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_RANGE                     11:11
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_WOFFSET                   0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_DISABLE                   _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_ENABLE                    _MK_ENUM_CONST(1)

//override dpd idle state with column 12 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_SHIFT                     _MK_SHIFT_CONST(12)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_RANGE                     12:12
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_WOFFSET                   0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_DISABLE                   _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_ENABLE                    _MK_ENUM_CONST(1)

//override dpd idle state with row 0  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_SHIFT                      _MK_SHIFT_CONST(13)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_RANGE                      13:13
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with row 1  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_SHIFT                      _MK_SHIFT_CONST(14)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_RANGE                      14:14
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with row 2  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_SHIFT                      _MK_SHIFT_CONST(15)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_RANGE                      15:15
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with row 3  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_RANGE                      16:16
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with row 4  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_SHIFT                      _MK_SHIFT_CONST(17)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_RANGE                      17:17
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with row 5  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_SHIFT                      _MK_SHIFT_CONST(18)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_RANGE                      18:18
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with row 6  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_SHIFT                      _MK_SHIFT_CONST(19)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_RANGE                      19:19
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with blink ouptut
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_SHIFT                 _MK_SHIFT_CONST(20)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_FIELD                 (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_RANGE                 20:20
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_WOFFSET                       0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_DISABLE                       _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_ENABLE                        _MK_ENUM_CONST(1)

//override dpd idle state with column with sys_clk_request output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_SHIFT                       _MK_SHIFT_CONST(21)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_RANGE                       21:21
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_WOFFSET                     0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_DEFAULT                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_ENABLE                      _MK_ENUM_CONST(1)


// Register APBDEV_PMC_DPD_SAMPLE_0  
#define APBDEV_PMC_DPD_SAMPLE_0                 _MK_ADDR_CONST(0x20)
#define APBDEV_PMC_DPD_SAMPLE_0_WORD_COUNT                      0x1
#define APBDEV_PMC_DPD_SAMPLE_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_SAMPLE_0_RESET_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_SAMPLE_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_SAMPLE_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_SAMPLE_0_READ_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_SAMPLE_0_WRITE_MASK                      _MK_MASK_CONST(0x1)
// will set sampling of pads value
#define APBDEV_PMC_DPD_SAMPLE_0_ON_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_DPD_SAMPLE_0_ON_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_SAMPLE_0_ON_SHIFT)
#define APBDEV_PMC_DPD_SAMPLE_0_ON_RANGE                        0:0
#define APBDEV_PMC_DPD_SAMPLE_0_ON_WOFFSET                      0x0
#define APBDEV_PMC_DPD_SAMPLE_0_ON_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_SAMPLE_0_ON_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_SAMPLE_0_ON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_SAMPLE_0_ON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_SAMPLE_0_ON_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_SAMPLE_0_ON_ENABLE                       _MK_ENUM_CONST(1)


// Register APBDEV_PMC_DPD_ENABLE_0  
#define APBDEV_PMC_DPD_ENABLE_0                 _MK_ADDR_CONST(0x24)
#define APBDEV_PMC_DPD_ENABLE_0_WORD_COUNT                      0x1
#define APBDEV_PMC_DPD_ENABLE_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_ENABLE_0_RESET_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_ENABLE_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_ENABLE_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_ENABLE_0_READ_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_ENABLE_0_WRITE_MASK                      _MK_MASK_CONST(0x1)
// will set sampling of pads value
#define APBDEV_PMC_DPD_ENABLE_0_ON_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_DPD_ENABLE_0_ON_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_ENABLE_0_ON_SHIFT)
#define APBDEV_PMC_DPD_ENABLE_0_ON_RANGE                        0:0
#define APBDEV_PMC_DPD_ENABLE_0_ON_WOFFSET                      0x0
#define APBDEV_PMC_DPD_ENABLE_0_ON_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_ENABLE_0_ON_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_ENABLE_0_ON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_ENABLE_0_ON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_ENABLE_0_ON_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_ENABLE_0_ON_ENABLE                       _MK_ENUM_CONST(1)


// Register APBDEV_PMC_PWRGATE_TIMER_OFF_0  
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0                  _MK_ADDR_CONST(0x28)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_WORD_COUNT                       0x1
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RESET_VAL                        _MK_MASK_CONST(0xeca97531)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// timer value for rail 0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_RANGE                      3:0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_WOFFSET                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// timer value for rail 1
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_SHIFT                      _MK_SHIFT_CONST(4)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_RANGE                      7:4
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_WOFFSET                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_DEFAULT                    _MK_MASK_CONST(0x3)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// timer value for rail 2
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_SHIFT                      _MK_SHIFT_CONST(8)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_RANGE                      11:8
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_WOFFSET                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_DEFAULT                    _MK_MASK_CONST(0x5)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// timer value for rail 3
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_SHIFT                      _MK_SHIFT_CONST(12)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_RANGE                      15:12
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_WOFFSET                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_DEFAULT                    _MK_MASK_CONST(0x7)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// timer value for rail 4
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_RANGE                      19:16
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_WOFFSET                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_DEFAULT                    _MK_MASK_CONST(0x9)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// timer value for rail 5
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_SHIFT                      _MK_SHIFT_CONST(20)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_RANGE                      23:20
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_WOFFSET                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_DEFAULT                    _MK_MASK_CONST(0xa)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// timer value for rail 6
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_SHIFT                      _MK_SHIFT_CONST(24)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_RANGE                      27:24
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_WOFFSET                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_DEFAULT                    _MK_MASK_CONST(0xc)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// timer value for rail 7
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_RANGE                      31:28
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_WOFFSET                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_DEFAULT                    _MK_MASK_CONST(0xe)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_PWRGATE_TIMER_ON_0  
#define APBDEV_PMC_PWRGATE_TIMER_ON_0                   _MK_ADDR_CONST(0x2c)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_WORD_COUNT                        0x1
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RESET_VAL                         _MK_MASK_CONST(0xeca97531)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// timer value for rail 0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_SHIFT                       _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_FIELD                       (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_RANGE                       3:0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_WOFFSET                     0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_DEFAULT                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// timer value for rail 1
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_SHIFT                       _MK_SHIFT_CONST(4)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_FIELD                       (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_RANGE                       7:4
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_WOFFSET                     0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_DEFAULT                     _MK_MASK_CONST(0x3)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// timer value for rail 2
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_SHIFT                       _MK_SHIFT_CONST(8)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_FIELD                       (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_RANGE                       11:8
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_WOFFSET                     0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_DEFAULT                     _MK_MASK_CONST(0x5)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// timer value for rail 3
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_SHIFT                       _MK_SHIFT_CONST(12)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_FIELD                       (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_RANGE                       15:12
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_WOFFSET                     0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_DEFAULT                     _MK_MASK_CONST(0x7)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// timer value for rail 4
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_FIELD                       (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_RANGE                       19:16
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_WOFFSET                     0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_DEFAULT                     _MK_MASK_CONST(0x9)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// timer value for rail 5
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_SHIFT                       _MK_SHIFT_CONST(20)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_FIELD                       (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_RANGE                       23:20
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_WOFFSET                     0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_DEFAULT                     _MK_MASK_CONST(0xa)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// timer value for rail 6
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_SHIFT                       _MK_SHIFT_CONST(24)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_FIELD                       (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_RANGE                       27:24
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_WOFFSET                     0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_DEFAULT                     _MK_MASK_CONST(0xc)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// timer value for rail 7
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_SHIFT                       _MK_SHIFT_CONST(28)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_FIELD                       (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_RANGE                       31:28
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_WOFFSET                     0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_DEFAULT                     _MK_MASK_CONST(0xe)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_PWRGATE_TOGGLE_0  
#define APBDEV_PMC_PWRGATE_TOGGLE_0                     _MK_ADDR_CONST(0x30)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_WORD_COUNT                  0x1
#define APBDEV_PMC_PWRGATE_TOGGLE_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_RESET_MASK                  _MK_MASK_CONST(0x103)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_READ_MASK                   _MK_MASK_CONST(0x103)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_WRITE_MASK                  _MK_MASK_CONST(0x103)
//id of partition to be toggled 
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_FIELD                        (_MK_MASK_CONST(0x3) << APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_SHIFT)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_RANGE                        1:0
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_WOFFSET                      0x0
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_CP                   _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_TD                   _MK_ENUM_CONST(1)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_VE                   _MK_ENUM_CONST(2)

//start power down/up
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_SHIFT                 _MK_SHIFT_CONST(8)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_FIELD                 (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWRGATE_TOGGLE_0_START_SHIFT)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_RANGE                 8:8
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_WOFFSET                       0x0
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_DISABLE                       _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_ENABLE                        _MK_ENUM_CONST(1)


// Register APBDEV_PMC_REMOVE_CLAMPING_CMD_0  
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0                        _MK_ADDR_CONST(0x34)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_WORD_COUNT                     0x1
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_RESET_MASK                     _MK_MASK_CONST(0x7)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_READ_MASK                      _MK_MASK_CONST(0x7)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_WRITE_MASK                     _MK_MASK_CONST(0x7)
//remove clamping to CPU
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_SHIFT)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_RANGE                      0:0
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_WOFFSET                    0x0
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_ENABLE                     _MK_ENUM_CONST(1)

//remove clamping to TD
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_SHIFT                       _MK_SHIFT_CONST(1)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_SHIFT)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_RANGE                       1:1
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_WOFFSET                     0x0
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_ENABLE                      _MK_ENUM_CONST(1)

//remove clamping to VE
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_SHIFT                       _MK_SHIFT_CONST(2)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_SHIFT)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_RANGE                       2:2
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_WOFFSET                     0x0
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_ENABLE                      _MK_ENUM_CONST(1)


// Register APBDEV_PMC_PWRGATE_STATUS_0  
#define APBDEV_PMC_PWRGATE_STATUS_0                     _MK_ADDR_CONST(0x38)
#define APBDEV_PMC_PWRGATE_STATUS_0_WORD_COUNT                  0x1
#define APBDEV_PMC_PWRGATE_STATUS_0_RESET_VAL                   _MK_MASK_CONST(0x7)
#define APBDEV_PMC_PWRGATE_STATUS_0_RESET_MASK                  _MK_MASK_CONST(0x7)
#define APBDEV_PMC_PWRGATE_STATUS_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_READ_MASK                   _MK_MASK_CONST(0x7)
#define APBDEV_PMC_PWRGATE_STATUS_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
//status of CPU partition
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_SHIFT                   _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWRGATE_STATUS_0_CPU_SHIFT)
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_RANGE                   0:0
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_WOFFSET                 0x0
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_DEFAULT                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_OFF                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_ON                      _MK_ENUM_CONST(1)

//status of TD  Partition
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_SHIFT                    _MK_SHIFT_CONST(1)
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWRGATE_STATUS_0_TD_SHIFT)
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_RANGE                    1:1
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_WOFFSET                  0x0
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_DEFAULT                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_OFF                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_ON                       _MK_ENUM_CONST(1)

//status of VE  partition
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_SHIFT                    _MK_SHIFT_CONST(2)
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWRGATE_STATUS_0_VE_SHIFT)
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_RANGE                    2:2
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_WOFFSET                  0x0
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_DEFAULT                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_OFF                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_ON                       _MK_ENUM_CONST(1)


// Register APBDEV_PMC_PWRGOOD_TIMER_0  
#define APBDEV_PMC_PWRGOOD_TIMER_0                      _MK_ADDR_CONST(0x3c)
#define APBDEV_PMC_PWRGOOD_TIMER_0_WORD_COUNT                   0x1
#define APBDEV_PMC_PWRGOOD_TIMER_0_RESET_VAL                    _MK_MASK_CONST(0x7f)
#define APBDEV_PMC_PWRGOOD_TIMER_0_RESET_MASK                   _MK_MASK_CONST(0x7f)
#define APBDEV_PMC_PWRGOOD_TIMER_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGOOD_TIMER_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGOOD_TIMER_0_READ_MASK                    _MK_MASK_CONST(0x7f)
#define APBDEV_PMC_PWRGOOD_TIMER_0_WRITE_MASK                   _MK_MASK_CONST(0x7f)
// timer data
#define APBDEV_PMC_PWRGOOD_TIMER_0_DATA_SHIFT                   _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PWRGOOD_TIMER_0_DATA_FIELD                   (_MK_MASK_CONST(0x7f) << APBDEV_PMC_PWRGOOD_TIMER_0_DATA_SHIFT)
#define APBDEV_PMC_PWRGOOD_TIMER_0_DATA_RANGE                   6:0
#define APBDEV_PMC_PWRGOOD_TIMER_0_DATA_WOFFSET                 0x0
#define APBDEV_PMC_PWRGOOD_TIMER_0_DATA_DEFAULT                 _MK_MASK_CONST(0x7f)
#define APBDEV_PMC_PWRGOOD_TIMER_0_DATA_DEFAULT_MASK                    _MK_MASK_CONST(0x7f)
#define APBDEV_PMC_PWRGOOD_TIMER_0_DATA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGOOD_TIMER_0_DATA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_BLINK_TIMER_0  
#define APBDEV_PMC_BLINK_TIMER_0                        _MK_ADDR_CONST(0x40)
#define APBDEV_PMC_BLINK_TIMER_0_WORD_COUNT                     0x1
#define APBDEV_PMC_BLINK_TIMER_0_RESET_VAL                      _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_BLINK_TIMER_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_BLINK_TIMER_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BLINK_TIMER_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BLINK_TIMER_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_BLINK_TIMER_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
// time on 
#define APBDEV_PMC_BLINK_TIMER_0_DATA_ON_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_ON_FIELD                  (_MK_MASK_CONST(0x7fff) << APBDEV_PMC_BLINK_TIMER_0_DATA_ON_SHIFT)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_ON_RANGE                  14:0
#define APBDEV_PMC_BLINK_TIMER_0_DATA_ON_WOFFSET                        0x0
#define APBDEV_PMC_BLINK_TIMER_0_DATA_ON_DEFAULT                        _MK_MASK_CONST(0x7fff)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_ON_DEFAULT_MASK                   _MK_MASK_CONST(0x7fff)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_ON_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_ON_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// if 0 32khz clock 
#define APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_SHIFT                      _MK_SHIFT_CONST(15)
#define APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_SHIFT)
#define APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_RANGE                      15:15
#define APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_WOFFSET                    0x0
#define APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// time off         
#define APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_SHIFT                 _MK_SHIFT_CONST(16)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_FIELD                 (_MK_MASK_CONST(0xffff) << APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_SHIFT)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_RANGE                 31:16
#define APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_WOFFSET                       0x0
#define APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_DEFAULT                       _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_NO_IOPOWER_0  
#define APBDEV_PMC_NO_IOPOWER_0                 _MK_ADDR_CONST(0x44)
#define APBDEV_PMC_NO_IOPOWER_0_WORD_COUNT                      0x1
#define APBDEV_PMC_NO_IOPOWER_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_RESET_MASK                      _MK_MASK_CONST(0x3ff)
#define APBDEV_PMC_NO_IOPOWER_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_READ_MASK                       _MK_MASK_CONST(0x3ff)
#define APBDEV_PMC_NO_IOPOWER_0_WRITE_MASK                      _MK_MASK_CONST(0x3ff)
//rail ao IOs   
#define APBDEV_PMC_NO_IOPOWER_0_AO_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_AO_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_AO_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_AO_RANGE                        0:0
#define APBDEV_PMC_NO_IOPOWER_0_AO_WOFFSET                      0x0
#define APBDEV_PMC_NO_IOPOWER_0_AO_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_AO_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_AO_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_AO_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_AO_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_AO_ENABLE                       _MK_ENUM_CONST(1)

//rail at3 IOs 
#define APBDEV_PMC_NO_IOPOWER_0_AT3_SHIFT                       _MK_SHIFT_CONST(1)
#define APBDEV_PMC_NO_IOPOWER_0_AT3_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_AT3_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_AT3_RANGE                       1:1
#define APBDEV_PMC_NO_IOPOWER_0_AT3_WOFFSET                     0x0
#define APBDEV_PMC_NO_IOPOWER_0_AT3_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_AT3_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_AT3_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_AT3_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_AT3_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_AT3_ENABLE                      _MK_ENUM_CONST(1)

//rail dbg IOs   
#define APBDEV_PMC_NO_IOPOWER_0_DBG_SHIFT                       _MK_SHIFT_CONST(2)
#define APBDEV_PMC_NO_IOPOWER_0_DBG_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_DBG_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_DBG_RANGE                       2:2
#define APBDEV_PMC_NO_IOPOWER_0_DBG_WOFFSET                     0x0
#define APBDEV_PMC_NO_IOPOWER_0_DBG_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_DBG_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_DBG_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_DBG_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_DBG_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_DBG_ENABLE                      _MK_ENUM_CONST(1)

//rail dlcd IOs   
#define APBDEV_PMC_NO_IOPOWER_0_DLCD_SHIFT                      _MK_SHIFT_CONST(3)
#define APBDEV_PMC_NO_IOPOWER_0_DLCD_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_DLCD_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_DLCD_RANGE                      3:3
#define APBDEV_PMC_NO_IOPOWER_0_DLCD_WOFFSET                    0x0
#define APBDEV_PMC_NO_IOPOWER_0_DLCD_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_DLCD_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_DLCD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_DLCD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_DLCD_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_DLCD_ENABLE                     _MK_ENUM_CONST(1)

//rail dvi IOs   
#define APBDEV_PMC_NO_IOPOWER_0_DVI_SHIFT                       _MK_SHIFT_CONST(4)
#define APBDEV_PMC_NO_IOPOWER_0_DVI_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_DVI_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_DVI_RANGE                       4:4
#define APBDEV_PMC_NO_IOPOWER_0_DVI_WOFFSET                     0x0
#define APBDEV_PMC_NO_IOPOWER_0_DVI_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_DVI_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_DVI_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_DVI_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_DVI_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_DVI_ENABLE                      _MK_ENUM_CONST(1)

//rail i2s IOs   
#define APBDEV_PMC_NO_IOPOWER_0_I2S_SHIFT                       _MK_SHIFT_CONST(5)
#define APBDEV_PMC_NO_IOPOWER_0_I2S_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_I2S_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_I2S_RANGE                       5:5
#define APBDEV_PMC_NO_IOPOWER_0_I2S_WOFFSET                     0x0
#define APBDEV_PMC_NO_IOPOWER_0_I2S_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_I2S_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_I2S_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_I2S_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_I2S_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_I2S_ENABLE                      _MK_ENUM_CONST(1)

//rail lcd IOs   
#define APBDEV_PMC_NO_IOPOWER_0_LCD_SHIFT                       _MK_SHIFT_CONST(6)
#define APBDEV_PMC_NO_IOPOWER_0_LCD_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_LCD_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_LCD_RANGE                       6:6
#define APBDEV_PMC_NO_IOPOWER_0_LCD_WOFFSET                     0x0
#define APBDEV_PMC_NO_IOPOWER_0_LCD_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_LCD_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_LCD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_LCD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_LCD_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_LCD_ENABLE                      _MK_ENUM_CONST(1)

//rail mem IOs   
#define APBDEV_PMC_NO_IOPOWER_0_MEM_SHIFT                       _MK_SHIFT_CONST(7)
#define APBDEV_PMC_NO_IOPOWER_0_MEM_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_MEM_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_MEM_RANGE                       7:7
#define APBDEV_PMC_NO_IOPOWER_0_MEM_WOFFSET                     0x0
#define APBDEV_PMC_NO_IOPOWER_0_MEM_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_MEM_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_MEM_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_MEM_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_MEM_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_MEM_ENABLE                      _MK_ENUM_CONST(1)

//rail sd IOs   
#define APBDEV_PMC_NO_IOPOWER_0_SD_SHIFT                        _MK_SHIFT_CONST(8)
#define APBDEV_PMC_NO_IOPOWER_0_SD_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_SD_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_SD_RANGE                        8:8
#define APBDEV_PMC_NO_IOPOWER_0_SD_WOFFSET                      0x0
#define APBDEV_PMC_NO_IOPOWER_0_SD_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_SD_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_SD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_SD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_SD_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_SD_ENABLE                       _MK_ENUM_CONST(1)

//rail mipi IOs   
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_SHIFT                      _MK_SHIFT_CONST(9)
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_MIPI_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_RANGE                      9:9
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_WOFFSET                    0x0
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_ENABLE                     _MK_ENUM_CONST(1)


// Register APBDEV_PMC_PWR_DET_0  
#define APBDEV_PMC_PWR_DET_0                    _MK_ADDR_CONST(0x48)
#define APBDEV_PMC_PWR_DET_0_WORD_COUNT                         0x1
#define APBDEV_PMC_PWR_DET_0_RESET_VAL                  _MK_MASK_CONST(0x1ff)
#define APBDEV_PMC_PWR_DET_0_RESET_MASK                         _MK_MASK_CONST(0x1ff)
#define APBDEV_PMC_PWR_DET_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_READ_MASK                  _MK_MASK_CONST(0x1ff)
#define APBDEV_PMC_PWR_DET_0_WRITE_MASK                         _MK_MASK_CONST(0x1ff)
//rail ao IOs   
#define APBDEV_PMC_PWR_DET_0_AO_SHIFT                   _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PWR_DET_0_AO_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_AO_SHIFT)
#define APBDEV_PMC_PWR_DET_0_AO_RANGE                   0:0
#define APBDEV_PMC_PWR_DET_0_AO_WOFFSET                 0x0
#define APBDEV_PMC_PWR_DET_0_AO_DEFAULT                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_AO_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_AO_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_AO_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_AO_ENABLE                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_AO_DISABLE                 _MK_ENUM_CONST(1)

//rail at3 IOs 
#define APBDEV_PMC_PWR_DET_0_AT3_SHIFT                  _MK_SHIFT_CONST(1)
#define APBDEV_PMC_PWR_DET_0_AT3_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_AT3_SHIFT)
#define APBDEV_PMC_PWR_DET_0_AT3_RANGE                  1:1
#define APBDEV_PMC_PWR_DET_0_AT3_WOFFSET                        0x0
#define APBDEV_PMC_PWR_DET_0_AT3_DEFAULT                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_AT3_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_AT3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_AT3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_AT3_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_AT3_DISABLE                        _MK_ENUM_CONST(1)

//rail dbg IOs   
#define APBDEV_PMC_PWR_DET_0_DBG_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDEV_PMC_PWR_DET_0_DBG_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_DBG_SHIFT)
#define APBDEV_PMC_PWR_DET_0_DBG_RANGE                  2:2
#define APBDEV_PMC_PWR_DET_0_DBG_WOFFSET                        0x0
#define APBDEV_PMC_PWR_DET_0_DBG_DEFAULT                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_DBG_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_DBG_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_DBG_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_DBG_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_DBG_DISABLE                        _MK_ENUM_CONST(1)

//rail dlcd IOs   
#define APBDEV_PMC_PWR_DET_0_DLCD_SHIFT                 _MK_SHIFT_CONST(3)
#define APBDEV_PMC_PWR_DET_0_DLCD_FIELD                 (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_DLCD_SHIFT)
#define APBDEV_PMC_PWR_DET_0_DLCD_RANGE                 3:3
#define APBDEV_PMC_PWR_DET_0_DLCD_WOFFSET                       0x0
#define APBDEV_PMC_PWR_DET_0_DLCD_DEFAULT                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_DLCD_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_DLCD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_DLCD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_DLCD_ENABLE                        _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_DLCD_DISABLE                       _MK_ENUM_CONST(1)

//rail dvi IOs   
#define APBDEV_PMC_PWR_DET_0_DVI_SHIFT                  _MK_SHIFT_CONST(4)
#define APBDEV_PMC_PWR_DET_0_DVI_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_DVI_SHIFT)
#define APBDEV_PMC_PWR_DET_0_DVI_RANGE                  4:4
#define APBDEV_PMC_PWR_DET_0_DVI_WOFFSET                        0x0
#define APBDEV_PMC_PWR_DET_0_DVI_DEFAULT                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_DVI_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_DVI_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_DVI_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_DVI_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_DVI_DISABLE                        _MK_ENUM_CONST(1)

//rail i2s IOs   
#define APBDEV_PMC_PWR_DET_0_I2S_SHIFT                  _MK_SHIFT_CONST(5)
#define APBDEV_PMC_PWR_DET_0_I2S_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_I2S_SHIFT)
#define APBDEV_PMC_PWR_DET_0_I2S_RANGE                  5:5
#define APBDEV_PMC_PWR_DET_0_I2S_WOFFSET                        0x0
#define APBDEV_PMC_PWR_DET_0_I2S_DEFAULT                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_I2S_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_I2S_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_I2S_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_I2S_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_I2S_DISABLE                        _MK_ENUM_CONST(1)

//rail lcd IOs   
#define APBDEV_PMC_PWR_DET_0_LCD_SHIFT                  _MK_SHIFT_CONST(6)
#define APBDEV_PMC_PWR_DET_0_LCD_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_LCD_SHIFT)
#define APBDEV_PMC_PWR_DET_0_LCD_RANGE                  6:6
#define APBDEV_PMC_PWR_DET_0_LCD_WOFFSET                        0x0
#define APBDEV_PMC_PWR_DET_0_LCD_DEFAULT                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_LCD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_LCD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_LCD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_LCD_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_LCD_DISABLE                        _MK_ENUM_CONST(1)

//rail mem IOs   
#define APBDEV_PMC_PWR_DET_0_MEM_SHIFT                  _MK_SHIFT_CONST(7)
#define APBDEV_PMC_PWR_DET_0_MEM_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_MEM_SHIFT)
#define APBDEV_PMC_PWR_DET_0_MEM_RANGE                  7:7
#define APBDEV_PMC_PWR_DET_0_MEM_WOFFSET                        0x0
#define APBDEV_PMC_PWR_DET_0_MEM_DEFAULT                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_MEM_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_MEM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_MEM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_MEM_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_MEM_DISABLE                        _MK_ENUM_CONST(1)

//rail sd IOs   
#define APBDEV_PMC_PWR_DET_0_SD_SHIFT                   _MK_SHIFT_CONST(8)
#define APBDEV_PMC_PWR_DET_0_SD_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_SD_SHIFT)
#define APBDEV_PMC_PWR_DET_0_SD_RANGE                   8:8
#define APBDEV_PMC_PWR_DET_0_SD_WOFFSET                 0x0
#define APBDEV_PMC_PWR_DET_0_SD_DEFAULT                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_SD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_SD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_SD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_SD_ENABLE                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_SD_DISABLE                 _MK_ENUM_CONST(1)


// Register APBDEV_PMC_PWR_DET_LATCH_0  
#define APBDEV_PMC_PWR_DET_LATCH_0                      _MK_ADDR_CONST(0x4c)
#define APBDEV_PMC_PWR_DET_LATCH_0_WORD_COUNT                   0x1
#define APBDEV_PMC_PWR_DET_LATCH_0_RESET_VAL                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_LATCH_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_LATCH_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_LATCH_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_LATCH_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_LATCH_0_WRITE_MASK                   _MK_MASK_CONST(0x1)
//power detect latch, latches value as long set to 1  
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_LATCH_0_LATCH_SHIFT)
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_RANGE                  0:0
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_WOFFSET                        0x0
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_DEFAULT                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_DISABLE                        _MK_ENUM_CONST(1)


// Register APBDEV_PMC_SCRATCH0_0  // Scratch register 
#define APBDEV_PMC_SCRATCH0_0                   _MK_ADDR_CONST(0x50)
#define APBDEV_PMC_SCRATCH0_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH0_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH0_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH0_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH0_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH0_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage 
#define APBDEV_PMC_SCRATCH0_0_SCRATCH0_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH0_0_SCRATCH0_FIELD                    (_MK_MASK_CONST(0x7fffffff) << APBDEV_PMC_SCRATCH0_0_SCRATCH0_SHIFT)
#define APBDEV_PMC_SCRATCH0_0_SCRATCH0_RANGE                    30:0
#define APBDEV_PMC_SCRATCH0_0_SCRATCH0_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH0_0_SCRATCH0_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH0_0_SCRATCH0_DEFAULT_MASK                     _MK_MASK_CONST(0x7fffffff)
#define APBDEV_PMC_SCRATCH0_0_SCRATCH0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH0_0_SCRATCH0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// reset power detect latch to 3.3V
#define APBDEV_PMC_SCRATCH0_0_RST_PWR_DET_SHIFT                 _MK_SHIFT_CONST(31)
#define APBDEV_PMC_SCRATCH0_0_RST_PWR_DET_FIELD                 (_MK_MASK_CONST(0x1) << APBDEV_PMC_SCRATCH0_0_RST_PWR_DET_SHIFT)
#define APBDEV_PMC_SCRATCH0_0_RST_PWR_DET_RANGE                 31:31
#define APBDEV_PMC_SCRATCH0_0_RST_PWR_DET_WOFFSET                       0x0
#define APBDEV_PMC_SCRATCH0_0_RST_PWR_DET_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH0_0_RST_PWR_DET_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SCRATCH0_0_RST_PWR_DET_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH0_0_RST_PWR_DET_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH1_0  // Scratch register 
#define APBDEV_PMC_SCRATCH1_0                   _MK_ADDR_CONST(0x54)
#define APBDEV_PMC_SCRATCH1_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH1_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH1_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH1_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH1_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH1_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH1_0_SCRATCH1_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH1_0_SCRATCH1_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH1_0_SCRATCH1_SHIFT)
#define APBDEV_PMC_SCRATCH1_0_SCRATCH1_RANGE                    31:0
#define APBDEV_PMC_SCRATCH1_0_SCRATCH1_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH1_0_SCRATCH1_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH1_0_SCRATCH1_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH1_0_SCRATCH1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH1_0_SCRATCH1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH2_0  // Scratch register 
#define APBDEV_PMC_SCRATCH2_0                   _MK_ADDR_CONST(0x58)
#define APBDEV_PMC_SCRATCH2_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH2_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH2_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH2_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH2_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH2_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH2_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH2_0_SCRATCH2_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH2_0_SCRATCH2_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH2_0_SCRATCH2_SHIFT)
#define APBDEV_PMC_SCRATCH2_0_SCRATCH2_RANGE                    31:0
#define APBDEV_PMC_SCRATCH2_0_SCRATCH2_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH2_0_SCRATCH2_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH2_0_SCRATCH2_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH2_0_SCRATCH2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH2_0_SCRATCH2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH3_0  // Scratch register 
#define APBDEV_PMC_SCRATCH3_0                   _MK_ADDR_CONST(0x5c)
#define APBDEV_PMC_SCRATCH3_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH3_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH3_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH3_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH3_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH3_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH3_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH3_0_SCRATCH3_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH3_0_SCRATCH3_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH3_0_SCRATCH3_SHIFT)
#define APBDEV_PMC_SCRATCH3_0_SCRATCH3_RANGE                    31:0
#define APBDEV_PMC_SCRATCH3_0_SCRATCH3_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH3_0_SCRATCH3_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH3_0_SCRATCH3_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH3_0_SCRATCH3_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH3_0_SCRATCH3_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH4_0  // Scratch register 
#define APBDEV_PMC_SCRATCH4_0                   _MK_ADDR_CONST(0x60)
#define APBDEV_PMC_SCRATCH4_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH4_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH4_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH4_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH4_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH4_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH4_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH4_0_SCRATCH4_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH4_0_SCRATCH4_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH4_0_SCRATCH4_SHIFT)
#define APBDEV_PMC_SCRATCH4_0_SCRATCH4_RANGE                    31:0
#define APBDEV_PMC_SCRATCH4_0_SCRATCH4_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH4_0_SCRATCH4_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH4_0_SCRATCH4_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH4_0_SCRATCH4_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH4_0_SCRATCH4_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH5_0  // Scratch register 
#define APBDEV_PMC_SCRATCH5_0                   _MK_ADDR_CONST(0x64)
#define APBDEV_PMC_SCRATCH5_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH5_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH5_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH5_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH5_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH5_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH5_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH5_0_SCRATCH5_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH5_0_SCRATCH5_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH5_0_SCRATCH5_SHIFT)
#define APBDEV_PMC_SCRATCH5_0_SCRATCH5_RANGE                    31:0
#define APBDEV_PMC_SCRATCH5_0_SCRATCH5_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH5_0_SCRATCH5_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH5_0_SCRATCH5_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH5_0_SCRATCH5_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH5_0_SCRATCH5_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH6_0  // Scratch register 
#define APBDEV_PMC_SCRATCH6_0                   _MK_ADDR_CONST(0x68)
#define APBDEV_PMC_SCRATCH6_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH6_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH6_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH6_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH6_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH6_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH6_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH6_0_SCRATCH6_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH6_0_SCRATCH6_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH6_0_SCRATCH6_SHIFT)
#define APBDEV_PMC_SCRATCH6_0_SCRATCH6_RANGE                    31:0
#define APBDEV_PMC_SCRATCH6_0_SCRATCH6_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH6_0_SCRATCH6_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH6_0_SCRATCH6_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH6_0_SCRATCH6_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH6_0_SCRATCH6_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH7_0  // Scratch register 
#define APBDEV_PMC_SCRATCH7_0                   _MK_ADDR_CONST(0x6c)
#define APBDEV_PMC_SCRATCH7_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH7_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH7_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH7_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH7_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH7_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH7_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH7_0_SCRATCH7_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH7_0_SCRATCH7_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH7_0_SCRATCH7_SHIFT)
#define APBDEV_PMC_SCRATCH7_0_SCRATCH7_RANGE                    31:0
#define APBDEV_PMC_SCRATCH7_0_SCRATCH7_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH7_0_SCRATCH7_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH7_0_SCRATCH7_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH7_0_SCRATCH7_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH7_0_SCRATCH7_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH8_0  // Scratch register 
#define APBDEV_PMC_SCRATCH8_0                   _MK_ADDR_CONST(0x70)
#define APBDEV_PMC_SCRATCH8_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH8_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH8_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH8_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH8_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH8_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH8_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH8_0_SCRATCH8_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH8_0_SCRATCH8_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH8_0_SCRATCH8_SHIFT)
#define APBDEV_PMC_SCRATCH8_0_SCRATCH8_RANGE                    31:0
#define APBDEV_PMC_SCRATCH8_0_SCRATCH8_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH8_0_SCRATCH8_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH8_0_SCRATCH8_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH8_0_SCRATCH8_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH8_0_SCRATCH8_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH9_0  // Scratch register 
#define APBDEV_PMC_SCRATCH9_0                   _MK_ADDR_CONST(0x74)
#define APBDEV_PMC_SCRATCH9_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH9_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH9_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH9_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH9_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH9_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH9_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH9_0_SCRATCH9_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH9_0_SCRATCH9_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH9_0_SCRATCH9_SHIFT)
#define APBDEV_PMC_SCRATCH9_0_SCRATCH9_RANGE                    31:0
#define APBDEV_PMC_SCRATCH9_0_SCRATCH9_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH9_0_SCRATCH9_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH9_0_SCRATCH9_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH9_0_SCRATCH9_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH9_0_SCRATCH9_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH10_0  // Scratch register 
#define APBDEV_PMC_SCRATCH10_0                  _MK_ADDR_CONST(0x78)
#define APBDEV_PMC_SCRATCH10_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH10_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH10_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH10_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH10_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH10_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH10_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH10_0_SCRATCH10_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH10_0_SCRATCH10_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH10_0_SCRATCH10_SHIFT)
#define APBDEV_PMC_SCRATCH10_0_SCRATCH10_RANGE                  31:0
#define APBDEV_PMC_SCRATCH10_0_SCRATCH10_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH10_0_SCRATCH10_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH10_0_SCRATCH10_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH10_0_SCRATCH10_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH10_0_SCRATCH10_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH11_0  // Scratch register 
#define APBDEV_PMC_SCRATCH11_0                  _MK_ADDR_CONST(0x7c)
#define APBDEV_PMC_SCRATCH11_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH11_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH11_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH11_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH11_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH11_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH11_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH11_0_SCRATCH11_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH11_0_SCRATCH11_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH11_0_SCRATCH11_SHIFT)
#define APBDEV_PMC_SCRATCH11_0_SCRATCH11_RANGE                  31:0
#define APBDEV_PMC_SCRATCH11_0_SCRATCH11_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH11_0_SCRATCH11_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH11_0_SCRATCH11_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH11_0_SCRATCH11_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH11_0_SCRATCH11_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH12_0  // Scratch register 
#define APBDEV_PMC_SCRATCH12_0                  _MK_ADDR_CONST(0x80)
#define APBDEV_PMC_SCRATCH12_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH12_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH12_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH12_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH12_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH12_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH12_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH12_0_SCRATCH12_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH12_0_SCRATCH12_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH12_0_SCRATCH12_SHIFT)
#define APBDEV_PMC_SCRATCH12_0_SCRATCH12_RANGE                  31:0
#define APBDEV_PMC_SCRATCH12_0_SCRATCH12_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH12_0_SCRATCH12_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH12_0_SCRATCH12_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH12_0_SCRATCH12_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH12_0_SCRATCH12_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH13_0  // Scratch register 
#define APBDEV_PMC_SCRATCH13_0                  _MK_ADDR_CONST(0x84)
#define APBDEV_PMC_SCRATCH13_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH13_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH13_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH13_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH13_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH13_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH13_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH13_0_SCRATCH13_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH13_0_SCRATCH13_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH13_0_SCRATCH13_SHIFT)
#define APBDEV_PMC_SCRATCH13_0_SCRATCH13_RANGE                  31:0
#define APBDEV_PMC_SCRATCH13_0_SCRATCH13_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH13_0_SCRATCH13_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH13_0_SCRATCH13_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH13_0_SCRATCH13_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH13_0_SCRATCH13_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH14_0  // Scratch register 
#define APBDEV_PMC_SCRATCH14_0                  _MK_ADDR_CONST(0x88)
#define APBDEV_PMC_SCRATCH14_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH14_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH14_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH14_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH14_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH14_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH14_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH14_0_SCRATCH14_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH14_0_SCRATCH14_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH14_0_SCRATCH14_SHIFT)
#define APBDEV_PMC_SCRATCH14_0_SCRATCH14_RANGE                  31:0
#define APBDEV_PMC_SCRATCH14_0_SCRATCH14_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH14_0_SCRATCH14_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH14_0_SCRATCH14_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH14_0_SCRATCH14_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH14_0_SCRATCH14_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH15_0  // Scratch register 
#define APBDEV_PMC_SCRATCH15_0                  _MK_ADDR_CONST(0x8c)
#define APBDEV_PMC_SCRATCH15_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH15_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH15_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH15_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH15_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH15_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH15_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH15_0_SCRATCH15_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH15_0_SCRATCH15_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH15_0_SCRATCH15_SHIFT)
#define APBDEV_PMC_SCRATCH15_0_SCRATCH15_RANGE                  31:0
#define APBDEV_PMC_SCRATCH15_0_SCRATCH15_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH15_0_SCRATCH15_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH15_0_SCRATCH15_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH15_0_SCRATCH15_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH15_0_SCRATCH15_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH16_0  // Scratch register 
#define APBDEV_PMC_SCRATCH16_0                  _MK_ADDR_CONST(0x90)
#define APBDEV_PMC_SCRATCH16_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH16_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH16_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH16_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH16_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH16_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH16_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH16_0_SCRATCH16_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH16_0_SCRATCH16_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH16_0_SCRATCH16_SHIFT)
#define APBDEV_PMC_SCRATCH16_0_SCRATCH16_RANGE                  31:0
#define APBDEV_PMC_SCRATCH16_0_SCRATCH16_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH16_0_SCRATCH16_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH16_0_SCRATCH16_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH16_0_SCRATCH16_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH16_0_SCRATCH16_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH17_0  // Scratch register 
#define APBDEV_PMC_SCRATCH17_0                  _MK_ADDR_CONST(0x94)
#define APBDEV_PMC_SCRATCH17_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH17_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH17_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH17_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH17_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH17_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH17_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH17_0_SCRATCH17_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH17_0_SCRATCH17_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH17_0_SCRATCH17_SHIFT)
#define APBDEV_PMC_SCRATCH17_0_SCRATCH17_RANGE                  31:0
#define APBDEV_PMC_SCRATCH17_0_SCRATCH17_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH17_0_SCRATCH17_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH17_0_SCRATCH17_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH17_0_SCRATCH17_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH17_0_SCRATCH17_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH18_0  // Scratch register 
#define APBDEV_PMC_SCRATCH18_0                  _MK_ADDR_CONST(0x98)
#define APBDEV_PMC_SCRATCH18_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH18_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH18_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH18_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH18_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH18_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH18_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH18_0_SCRATCH18_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH18_0_SCRATCH18_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH18_0_SCRATCH18_SHIFT)
#define APBDEV_PMC_SCRATCH18_0_SCRATCH18_RANGE                  31:0
#define APBDEV_PMC_SCRATCH18_0_SCRATCH18_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH18_0_SCRATCH18_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH18_0_SCRATCH18_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH18_0_SCRATCH18_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH18_0_SCRATCH18_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH19_0  // Scratch register 
#define APBDEV_PMC_SCRATCH19_0                  _MK_ADDR_CONST(0x9c)
#define APBDEV_PMC_SCRATCH19_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH19_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH19_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH19_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH19_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH19_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH19_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH19_0_SCRATCH19_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH19_0_SCRATCH19_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH19_0_SCRATCH19_SHIFT)
#define APBDEV_PMC_SCRATCH19_0_SCRATCH19_RANGE                  31:0
#define APBDEV_PMC_SCRATCH19_0_SCRATCH19_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH19_0_SCRATCH19_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH19_0_SCRATCH19_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH19_0_SCRATCH19_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH19_0_SCRATCH19_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH20_0  // Scratch register 
#define APBDEV_PMC_SCRATCH20_0                  _MK_ADDR_CONST(0xa0)
#define APBDEV_PMC_SCRATCH20_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH20_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH20_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH20_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH20_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH20_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH20_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH20_0_SCRATCH20_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH20_0_SCRATCH20_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH20_0_SCRATCH20_SHIFT)
#define APBDEV_PMC_SCRATCH20_0_SCRATCH20_RANGE                  31:0
#define APBDEV_PMC_SCRATCH20_0_SCRATCH20_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH20_0_SCRATCH20_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH20_0_SCRATCH20_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH20_0_SCRATCH20_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH20_0_SCRATCH20_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH21_0  // Scratch register 
#define APBDEV_PMC_SCRATCH21_0                  _MK_ADDR_CONST(0xa4)
#define APBDEV_PMC_SCRATCH21_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH21_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH21_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH21_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH21_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH21_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH21_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH21_0_SCRATCH21_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH21_0_SCRATCH21_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH21_0_SCRATCH21_SHIFT)
#define APBDEV_PMC_SCRATCH21_0_SCRATCH21_RANGE                  31:0
#define APBDEV_PMC_SCRATCH21_0_SCRATCH21_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH21_0_SCRATCH21_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH21_0_SCRATCH21_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH21_0_SCRATCH21_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH21_0_SCRATCH21_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH22_0  // Scratch register 
#define APBDEV_PMC_SCRATCH22_0                  _MK_ADDR_CONST(0xa8)
#define APBDEV_PMC_SCRATCH22_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH22_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH22_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH22_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH22_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH22_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH22_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH22_0_SCRATCH22_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH22_0_SCRATCH22_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH22_0_SCRATCH22_SHIFT)
#define APBDEV_PMC_SCRATCH22_0_SCRATCH22_RANGE                  31:0
#define APBDEV_PMC_SCRATCH22_0_SCRATCH22_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH22_0_SCRATCH22_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH22_0_SCRATCH22_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH22_0_SCRATCH22_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH22_0_SCRATCH22_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH23_0  // Scratch register 
#define APBDEV_PMC_SCRATCH23_0                  _MK_ADDR_CONST(0xac)
#define APBDEV_PMC_SCRATCH23_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH23_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH23_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH23_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH23_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH23_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH23_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH23_0_SCRATCH23_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH23_0_SCRATCH23_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH23_0_SCRATCH23_SHIFT)
#define APBDEV_PMC_SCRATCH23_0_SCRATCH23_RANGE                  31:0
#define APBDEV_PMC_SCRATCH23_0_SCRATCH23_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH23_0_SCRATCH23_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH23_0_SCRATCH23_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH23_0_SCRATCH23_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH23_0_SCRATCH23_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SECURE_SCRATCH0_0  // Secure scratch register
#define APBDEV_PMC_SECURE_SCRATCH0_0                    _MK_ADDR_CONST(0xb0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_WORD_COUNT                         0x1
#define APBDEV_PMC_SECURE_SCRATCH0_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH0_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_FIELD                      (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_SHIFT)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_RANGE                      31:0
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_WOFFSET                    0x0
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SECURE_SCRATCH1_0  // Secure scratch register
#define APBDEV_PMC_SECURE_SCRATCH1_0                    _MK_ADDR_CONST(0xb4)
#define APBDEV_PMC_SECURE_SCRATCH1_0_WORD_COUNT                         0x1
#define APBDEV_PMC_SECURE_SCRATCH1_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH1_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH1_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH1_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_FIELD                      (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_SHIFT)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_RANGE                      31:0
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_WOFFSET                    0x0
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SECURE_SCRATCH2_0  // Secure scratch register
#define APBDEV_PMC_SECURE_SCRATCH2_0                    _MK_ADDR_CONST(0xb8)
#define APBDEV_PMC_SECURE_SCRATCH2_0_WORD_COUNT                         0x1
#define APBDEV_PMC_SECURE_SCRATCH2_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH2_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH2_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH2_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_FIELD                      (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_SHIFT)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_RANGE                      31:0
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_WOFFSET                    0x0
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SECURE_SCRATCH3_0  // Secure scratch register
#define APBDEV_PMC_SECURE_SCRATCH3_0                    _MK_ADDR_CONST(0xbc)
#define APBDEV_PMC_SECURE_SCRATCH3_0_WORD_COUNT                         0x1
#define APBDEV_PMC_SECURE_SCRATCH3_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH3_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH3_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH3_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_FIELD                      (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_SHIFT)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_RANGE                      31:0
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_WOFFSET                    0x0
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_ARAPBPM_REGS(_op_) \
_op_(APBDEV_PMC_CNTRL_0) \
_op_(APBDEV_PMC_SEC_DISABLE_0) \
_op_(APBDEV_PMC_PMC_SWRST_0) \
_op_(APBDEV_PMC_WAKE_MASK_0) \
_op_(APBDEV_PMC_WAKE_LVL_0) \
_op_(APBDEV_PMC_WAKE_STATUS_0) \
_op_(APBDEV_PMC_SW_WAKE_STATUS_0) \
_op_(APBDEV_PMC_DPD_PADS_ORIDE_0) \
_op_(APBDEV_PMC_DPD_SAMPLE_0) \
_op_(APBDEV_PMC_DPD_ENABLE_0) \
_op_(APBDEV_PMC_PWRGATE_TIMER_OFF_0) \
_op_(APBDEV_PMC_PWRGATE_TIMER_ON_0) \
_op_(APBDEV_PMC_PWRGATE_TOGGLE_0) \
_op_(APBDEV_PMC_REMOVE_CLAMPING_CMD_0) \
_op_(APBDEV_PMC_PWRGATE_STATUS_0) \
_op_(APBDEV_PMC_PWRGOOD_TIMER_0) \
_op_(APBDEV_PMC_BLINK_TIMER_0) \
_op_(APBDEV_PMC_NO_IOPOWER_0) \
_op_(APBDEV_PMC_PWR_DET_0) \
_op_(APBDEV_PMC_PWR_DET_LATCH_0) \
_op_(APBDEV_PMC_SCRATCH0_0) \
_op_(APBDEV_PMC_SCRATCH1_0) \
_op_(APBDEV_PMC_SCRATCH2_0) \
_op_(APBDEV_PMC_SCRATCH3_0) \
_op_(APBDEV_PMC_SCRATCH4_0) \
_op_(APBDEV_PMC_SCRATCH5_0) \
_op_(APBDEV_PMC_SCRATCH6_0) \
_op_(APBDEV_PMC_SCRATCH7_0) \
_op_(APBDEV_PMC_SCRATCH8_0) \
_op_(APBDEV_PMC_SCRATCH9_0) \
_op_(APBDEV_PMC_SCRATCH10_0) \
_op_(APBDEV_PMC_SCRATCH11_0) \
_op_(APBDEV_PMC_SCRATCH12_0) \
_op_(APBDEV_PMC_SCRATCH13_0) \
_op_(APBDEV_PMC_SCRATCH14_0) \
_op_(APBDEV_PMC_SCRATCH15_0) \
_op_(APBDEV_PMC_SCRATCH16_0) \
_op_(APBDEV_PMC_SCRATCH17_0) \
_op_(APBDEV_PMC_SCRATCH18_0) \
_op_(APBDEV_PMC_SCRATCH19_0) \
_op_(APBDEV_PMC_SCRATCH20_0) \
_op_(APBDEV_PMC_SCRATCH21_0) \
_op_(APBDEV_PMC_SCRATCH22_0) \
_op_(APBDEV_PMC_SCRATCH23_0) \
_op_(APBDEV_PMC_SECURE_SCRATCH0_0) \
_op_(APBDEV_PMC_SECURE_SCRATCH1_0) \
_op_(APBDEV_PMC_SECURE_SCRATCH2_0) \
_op_(APBDEV_PMC_SECURE_SCRATCH3_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_APBDEV_PMC 0x00000000

//
// ARAPBPM REGISTER BANKS
//

#define APBDEV_PMC0_FIRST_REG 0x0000 // APBDEV_PMC_CNTRL_0
#define APBDEV_PMC0_LAST_REG 0x00bc // APBDEV_PMC_SECURE_SCRATCH3_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARAPBPM_H_INC_
