/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARFLOW_CTLR_H_INC_
#define ___ARFLOW_CTLR_H_INC_

// Register FLOW_CTLR_HALT_CPU_EVENTS_0  
#define FLOW_CTLR_HALT_CPU_EVENTS_0                     _MK_ADDR_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_WORD_COUNT                  0x1
#define FLOW_CTLR_HALT_CPU_EVENTS_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// 7 = reserved 
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_SHIFT                  _MK_SHIFT_CONST(29)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_FIELD                  (_MK_MASK_CONST(0x7) << FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_RANGE                  31:29
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_WOFFSET                        0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_FLOW_MODE_NONE                 _MK_ENUM_CONST(0)    // // No flow control

#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_FLOW_MODE_RUN_AND_INT                  _MK_ENUM_CONST(1)    // // Keep running but generate interrupt when event conditions met

#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_FLOW_MODE_WAITEVENT                    _MK_ENUM_CONST(2)    // // Stop running until event conditions met

#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_FLOW_MODE_WAITEVENT_AND_INT                    _MK_ENUM_CONST(3)    // // Same as FLOW_MODE_STOP but generate an interrupt when resumed

#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_FLOW_MODE_STOP_UNTIL_IRQ                       _MK_ENUM_CONST(4)    // // Stop until an interrupt controller interrupt occurs

#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_FLOW_MODE_STOP_UNTIL_IRQ_AND_INT                       _MK_ENUM_CONST(5)    // // Same as FLOW_MODE_STOP_UNTIL_INT but generate another interrupt when resumed

#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_FLOW_MODE_STOP_UNTIL_EVENT_AND_IRQ                     _MK_ENUM_CONST(6)    // // Stop until event conditions met AND an interrupt controller interrupt occurs

#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_FLOW_MODE_STOP                 _MK_ENUM_CONST(2)    // // DO NOT USE. LEGACY NAME WILL BE REMOVED

#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_FLOW_MODE_STOP_AND_INT                 _MK_ENUM_CONST(3)    // // DO NOT USE. LEGACY NAME WILL BE REMOVED

#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_FLOW_MODE_STOP_UNTIL_INT                       _MK_ENUM_CONST(4)    // // DO NOT USE. LEGACY NAME WILL BE REMOVED

#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_FLOW_MODE_STOP_UNTIL_INT_AND_INT                       _MK_ENUM_CONST(5)    // // DO NOT USE. LEGACY NAME WILL BE REMOVED

#define FLOW_CTLR_HALT_CPU_EVENTS_0_MODE_FLOW_MODE_STOP_OR_INT                  _MK_ENUM_CONST(6)    // // DO NOT USE. LEGACY NAME WILL BE REMOVED


// Resume on JTAG activity
#define FLOW_CTLR_HALT_CPU_EVENTS_0_JTAG_SHIFT                  _MK_SHIFT_CONST(28)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_JTAG_FIELD                  (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_JTAG_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_JTAG_RANGE                  28:28
#define FLOW_CTLR_HALT_CPU_EVENTS_0_JTAG_WOFFSET                        0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_JTAG_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_JTAG_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_JTAG_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_JTAG_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Resume on Nth SYSCLK cycle ticks. Modified by SW
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SCLK_SHIFT                  _MK_SHIFT_CONST(27)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SCLK_FIELD                  (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_SCLK_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SCLK_RANGE                  27:27
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SCLK_WOFFSET                        0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SCLK_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SCLK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SCLK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SCLK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Resume on Nth X32K clock input ticks Modified by  SW
#define FLOW_CTLR_HALT_CPU_EVENTS_0_X32K_SHIFT                  _MK_SHIFT_CONST(26)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_X32K_FIELD                  (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_X32K_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_X32K_RANGE                  26:26
#define FLOW_CTLR_HALT_CPU_EVENTS_0_X32K_WOFFSET                        0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_X32K_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_X32K_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_X32K_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_X32K_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Resume on Nth SEC clock ticks Modified by SW
#define FLOW_CTLR_HALT_CPU_EVENTS_0_uSEC_SHIFT                  _MK_SHIFT_CONST(25)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_uSEC_FIELD                  (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_uSEC_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_uSEC_RANGE                  25:25
#define FLOW_CTLR_HALT_CPU_EVENTS_0_uSEC_WOFFSET                        0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_uSEC_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_uSEC_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_uSEC_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_uSEC_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Resume on Nth mSEC clock ticks Modified by SW
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MSEC_SHIFT                  _MK_SHIFT_CONST(24)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MSEC_FIELD                  (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_MSEC_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MSEC_RANGE                  24:24
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MSEC_WOFFSET                        0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MSEC_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MSEC_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MSEC_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_MSEC_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Resume on Nth second RTC clock ticks Modified by  SW
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SEC_SHIFT                   _MK_SHIFT_CONST(23)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SEC_FIELD                   (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_SEC_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SEC_RANGE                   23:23
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SEC_WOFFSET                 0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SEC_DEFAULT                 _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SEC_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SEC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SEC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Resume on Nth XIO.RDY Ext. IO Ready events Read-only,  status changed by HW
#define FLOW_CTLR_HALT_CPU_EVENTS_0_X_RDY_SHIFT                 _MK_SHIFT_CONST(22)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_X_RDY_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_X_RDY_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_X_RDY_RANGE                 22:22
#define FLOW_CTLR_HALT_CPU_EVENTS_0_X_RDY_WOFFSET                       0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_X_RDY_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_X_RDY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_X_RDY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_X_RDY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on Nth SMP.31 Semaphore set events 
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SMP31_SHIFT                 _MK_SHIFT_CONST(21)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SMP31_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_SMP31_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SMP31_RANGE                 21:21
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SMP31_WOFFSET                       0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SMP31_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SMP31_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SMP31_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SMP31_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on Nth SMP.30 Semaphore set events
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SMP30_SHIFT                 _MK_SHIFT_CONST(20)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SMP30_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_SMP30_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SMP30_RANGE                 20:20
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SMP30_WOFFSET                       0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SMP30_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SMP30_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SMP30_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_SMP30_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on Nth XRQ.D External Trigger events
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_D_SHIFT                 _MK_SHIFT_CONST(19)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_D_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_D_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_D_RANGE                 19:19
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_D_WOFFSET                       0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_D_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_D_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_D_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_D_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on Nth XRQ.C External Trigger events
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_C_SHIFT                 _MK_SHIFT_CONST(18)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_C_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_C_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_C_RANGE                 18:18
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_C_WOFFSET                       0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_C_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_C_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_C_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_C_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on Nth XRQ.B External Trigger events
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_B_SHIFT                 _MK_SHIFT_CONST(17)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_B_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_B_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_B_RANGE                 17:17
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_B_WOFFSET                       0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_B_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_B_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_B_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_B_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on Nth XRQ.A External Trigger events
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_A_SHIFT                 _MK_SHIFT_CONST(16)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_A_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_A_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_A_RANGE                 16:16
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_A_WOFFSET                       0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_A_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_A_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_A_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_XRQ_A_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on Nth OBE Outbox Empty Events
#define FLOW_CTLR_HALT_CPU_EVENTS_0_OBE_SHIFT                   _MK_SHIFT_CONST(15)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_OBE_FIELD                   (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_OBE_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_OBE_RANGE                   15:15
#define FLOW_CTLR_HALT_CPU_EVENTS_0_OBE_WOFFSET                 0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_OBE_DEFAULT                 _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_OBE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_OBE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_OBE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Resume on Nth OBF Outbox Full Events
#define FLOW_CTLR_HALT_CPU_EVENTS_0_OBF_SHIFT                   _MK_SHIFT_CONST(14)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_OBF_FIELD                   (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_OBF_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_OBF_RANGE                   14:14
#define FLOW_CTLR_HALT_CPU_EVENTS_0_OBF_WOFFSET                 0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_OBF_DEFAULT                 _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_OBF_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_OBF_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_OBF_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Resume on Nth IBE Inbox Empty Events
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IBE_SHIFT                   _MK_SHIFT_CONST(13)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IBE_FIELD                   (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_IBE_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IBE_RANGE                   13:13
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IBE_WOFFSET                 0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IBE_DEFAULT                 _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IBE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IBE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IBE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Resume on Nth IBE Inbox Empty Events
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IBF_SHIFT                   _MK_SHIFT_CONST(12)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IBF_FIELD                   (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_IBF_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IBF_RANGE                   12:12
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IBF_WOFFSET                 0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IBF_DEFAULT                 _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IBF_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IBF_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IBF_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Resume on IRQ.1 COP IRQ Valid
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_1_SHIFT                 _MK_SHIFT_CONST(11)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_1_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_1_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_1_RANGE                 11:11
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_1_WOFFSET                       0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_1_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_1_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on IRQ.0 CPU IRQ Valid
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_0_SHIFT                 _MK_SHIFT_CONST(10)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_0_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_0_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_0_RANGE                 10:10
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_0_WOFFSET                       0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_0_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_IRQ_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on FIQ.1 Valid COP FIQ
#define FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_1_SHIFT                 _MK_SHIFT_CONST(9)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_1_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_1_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_1_RANGE                 9:9
#define FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_1_WOFFSET                       0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_1_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_1_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on FIQ.0 Valid CPU FIQ
#define FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_0_SHIFT                 _MK_SHIFT_CONST(8)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_0_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_0_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_0_RANGE                 8:8
#define FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_0_WOFFSET                       0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_0_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_FIQ_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Note: If more than one event is enabled, the event counter
// will decrement based on an or condition of enabled events. 
#define FLOW_CTLR_HALT_CPU_EVENTS_0_ZERO_SHIFT                  _MK_SHIFT_CONST(0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_ZERO_FIELD                  (_MK_MASK_CONST(0xff) << FLOW_CTLR_HALT_CPU_EVENTS_0_ZERO_SHIFT)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_ZERO_RANGE                  7:0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_ZERO_WOFFSET                        0x0
#define FLOW_CTLR_HALT_CPU_EVENTS_0_ZERO_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_ZERO_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_ZERO_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_CPU_EVENTS_0_ZERO_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FLOW_CTLR_HALT_COP_EVENTS_0  
#define FLOW_CTLR_HALT_COP_EVENTS_0                     _MK_ADDR_CONST(0x4)
#define FLOW_CTLR_HALT_COP_EVENTS_0_WORD_COUNT                  0x1
#define FLOW_CTLR_HALT_COP_EVENTS_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define FLOW_CTLR_HALT_COP_EVENTS_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// 7 = reserved 
#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_SHIFT                  _MK_SHIFT_CONST(29)
#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_FIELD                  (_MK_MASK_CONST(0x7) << FLOW_CTLR_HALT_COP_EVENTS_0_MODE_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_RANGE                  31:29
#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_WOFFSET                        0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_FLOW_MODE_NONE                 _MK_ENUM_CONST(0)    // // No flow control

#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_FLOW_MODE_RUN_AND_INT                  _MK_ENUM_CONST(1)    // // Keep running but generate interrupt when event conditions met

#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_FLOW_MODE_WAITEVENT                    _MK_ENUM_CONST(2)    // // Stop running until event conditions met

#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_FLOW_MODE_WAITEVENT_AND_INT                    _MK_ENUM_CONST(3)    // // Same as FLOW_MODE_STOP but generate an interrupt when resumed

#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_FLOW_MODE_STOP_UNTIL_IRQ                       _MK_ENUM_CONST(4)    // // Stop until an interrupt controller interrupt occurs

#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_FLOW_MODE_STOP_UNTIL_IRQ_AND_INT                       _MK_ENUM_CONST(5)    // // Same as FLOW_MODE_STOP_UNTIL_INT but generate another interrupt when resumed

#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_FLOW_MODE_STOP_UNTIL_EVENT_AND_IRQ                     _MK_ENUM_CONST(6)    // // Stop until event conditions met AND an interrupt controller interrupt occurs

#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_FLOW_MODE_STOP                 _MK_ENUM_CONST(2)    // // DO NOT USE. LEGACY NAME WILL BE REMOVED

#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_FLOW_MODE_STOP_AND_INT                 _MK_ENUM_CONST(3)    // // DO NOT USE. LEGACY NAME WILL BE REMOVED

#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_FLOW_MODE_STOP_UNTIL_INT                       _MK_ENUM_CONST(4)    // // DO NOT USE. LEGACY NAME WILL BE REMOVED

#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_FLOW_MODE_STOP_UNTIL_INT_AND_INT                       _MK_ENUM_CONST(5)    // // DO NOT USE. LEGACY NAME WILL BE REMOVED

#define FLOW_CTLR_HALT_COP_EVENTS_0_MODE_FLOW_MODE_STOP_OR_INT                  _MK_ENUM_CONST(6)    // // DO NOT USE. LEGACY NAME WILL BE REMOVED


// Resume on JTAG activity
#define FLOW_CTLR_HALT_COP_EVENTS_0_JTAG_SHIFT                  _MK_SHIFT_CONST(28)
#define FLOW_CTLR_HALT_COP_EVENTS_0_JTAG_FIELD                  (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_JTAG_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_JTAG_RANGE                  28:28
#define FLOW_CTLR_HALT_COP_EVENTS_0_JTAG_WOFFSET                        0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_JTAG_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_JTAG_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_JTAG_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_JTAG_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Resume on Nth SYSCLK cycle ticks. Modified by SW
#define FLOW_CTLR_HALT_COP_EVENTS_0_SCLK_SHIFT                  _MK_SHIFT_CONST(27)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SCLK_FIELD                  (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_SCLK_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SCLK_RANGE                  27:27
#define FLOW_CTLR_HALT_COP_EVENTS_0_SCLK_WOFFSET                        0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_SCLK_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SCLK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SCLK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SCLK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Resume on Nth X32K clock input ticks Modified by  SW
#define FLOW_CTLR_HALT_COP_EVENTS_0_X32K_SHIFT                  _MK_SHIFT_CONST(26)
#define FLOW_CTLR_HALT_COP_EVENTS_0_X32K_FIELD                  (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_X32K_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_X32K_RANGE                  26:26
#define FLOW_CTLR_HALT_COP_EVENTS_0_X32K_WOFFSET                        0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_X32K_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_X32K_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_X32K_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_X32K_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Resume on Nth SEC clock ticks Modified by SW
#define FLOW_CTLR_HALT_COP_EVENTS_0_uSEC_SHIFT                  _MK_SHIFT_CONST(25)
#define FLOW_CTLR_HALT_COP_EVENTS_0_uSEC_FIELD                  (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_uSEC_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_uSEC_RANGE                  25:25
#define FLOW_CTLR_HALT_COP_EVENTS_0_uSEC_WOFFSET                        0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_uSEC_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_uSEC_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_uSEC_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_uSEC_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Resume on Nth mSEC clock ticks Modified by SW
#define FLOW_CTLR_HALT_COP_EVENTS_0_MSEC_SHIFT                  _MK_SHIFT_CONST(24)
#define FLOW_CTLR_HALT_COP_EVENTS_0_MSEC_FIELD                  (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_MSEC_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_MSEC_RANGE                  24:24
#define FLOW_CTLR_HALT_COP_EVENTS_0_MSEC_WOFFSET                        0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_MSEC_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_MSEC_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_MSEC_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_MSEC_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Resume on Nth second RTC clock ticks Modified by  SW
#define FLOW_CTLR_HALT_COP_EVENTS_0_SEC_SHIFT                   _MK_SHIFT_CONST(23)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SEC_FIELD                   (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_SEC_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SEC_RANGE                   23:23
#define FLOW_CTLR_HALT_COP_EVENTS_0_SEC_WOFFSET                 0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_SEC_DEFAULT                 _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SEC_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SEC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SEC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Resume on Nth XIO.RDY Ext. IO Ready events Read-only,  status changed by HW
#define FLOW_CTLR_HALT_COP_EVENTS_0_X_RDY_SHIFT                 _MK_SHIFT_CONST(22)
#define FLOW_CTLR_HALT_COP_EVENTS_0_X_RDY_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_X_RDY_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_X_RDY_RANGE                 22:22
#define FLOW_CTLR_HALT_COP_EVENTS_0_X_RDY_WOFFSET                       0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_X_RDY_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_X_RDY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_X_RDY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_X_RDY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on Nth SMP.31 Semaphore set events 
#define FLOW_CTLR_HALT_COP_EVENTS_0_SMP31_SHIFT                 _MK_SHIFT_CONST(21)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SMP31_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_SMP31_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SMP31_RANGE                 21:21
#define FLOW_CTLR_HALT_COP_EVENTS_0_SMP31_WOFFSET                       0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_SMP31_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SMP31_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SMP31_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SMP31_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on Nth SMP.30 Semaphore set events
#define FLOW_CTLR_HALT_COP_EVENTS_0_SMP30_SHIFT                 _MK_SHIFT_CONST(20)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SMP30_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_SMP30_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SMP30_RANGE                 20:20
#define FLOW_CTLR_HALT_COP_EVENTS_0_SMP30_WOFFSET                       0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_SMP30_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SMP30_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SMP30_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_SMP30_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on Nth XRQ.D External Trigger events
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_D_SHIFT                 _MK_SHIFT_CONST(19)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_D_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_D_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_D_RANGE                 19:19
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_D_WOFFSET                       0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_D_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_D_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_D_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_D_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on Nth XRQ.C External Trigger events
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_C_SHIFT                 _MK_SHIFT_CONST(18)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_C_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_C_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_C_RANGE                 18:18
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_C_WOFFSET                       0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_C_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_C_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_C_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_C_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on Nth XRQ.B External Trigger events
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_B_SHIFT                 _MK_SHIFT_CONST(17)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_B_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_B_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_B_RANGE                 17:17
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_B_WOFFSET                       0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_B_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_B_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_B_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_B_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on Nth XRQ.A External Trigger events
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_A_SHIFT                 _MK_SHIFT_CONST(16)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_A_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_A_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_A_RANGE                 16:16
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_A_WOFFSET                       0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_A_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_A_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_A_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_XRQ_A_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on Nth OBE Outbox Empty Events
#define FLOW_CTLR_HALT_COP_EVENTS_0_OBE_SHIFT                   _MK_SHIFT_CONST(15)
#define FLOW_CTLR_HALT_COP_EVENTS_0_OBE_FIELD                   (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_OBE_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_OBE_RANGE                   15:15
#define FLOW_CTLR_HALT_COP_EVENTS_0_OBE_WOFFSET                 0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_OBE_DEFAULT                 _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_OBE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_OBE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_OBE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Resume on Nth OBF Outbox Full Events
#define FLOW_CTLR_HALT_COP_EVENTS_0_OBF_SHIFT                   _MK_SHIFT_CONST(14)
#define FLOW_CTLR_HALT_COP_EVENTS_0_OBF_FIELD                   (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_OBF_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_OBF_RANGE                   14:14
#define FLOW_CTLR_HALT_COP_EVENTS_0_OBF_WOFFSET                 0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_OBF_DEFAULT                 _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_OBF_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_OBF_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_OBF_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Resume on Nth IBE Inbox Empty Events
#define FLOW_CTLR_HALT_COP_EVENTS_0_IBE_SHIFT                   _MK_SHIFT_CONST(13)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IBE_FIELD                   (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_IBE_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IBE_RANGE                   13:13
#define FLOW_CTLR_HALT_COP_EVENTS_0_IBE_WOFFSET                 0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_IBE_DEFAULT                 _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IBE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IBE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IBE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Resume on Nth IBE Inbox Empty Events
#define FLOW_CTLR_HALT_COP_EVENTS_0_IBF_SHIFT                   _MK_SHIFT_CONST(12)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IBF_FIELD                   (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_IBF_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IBF_RANGE                   12:12
#define FLOW_CTLR_HALT_COP_EVENTS_0_IBF_WOFFSET                 0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_IBF_DEFAULT                 _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IBF_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IBF_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IBF_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Resume on IRQ.1 COP IRQ Valid
#define FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_1_SHIFT                 _MK_SHIFT_CONST(11)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_1_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_1_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_1_RANGE                 11:11
#define FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_1_WOFFSET                       0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_1_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_1_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on IRQ.0 CPU IRQ Valid
#define FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_0_SHIFT                 _MK_SHIFT_CONST(10)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_0_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_0_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_0_RANGE                 10:10
#define FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_0_WOFFSET                       0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_0_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_IRQ_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on FIQ.1 Valid COP FIQ
#define FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_1_SHIFT                 _MK_SHIFT_CONST(9)
#define FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_1_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_1_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_1_RANGE                 9:9
#define FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_1_WOFFSET                       0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_1_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_1_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Resume on FIQ.0 Valid CPU FIQ
#define FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_0_SHIFT                 _MK_SHIFT_CONST(8)
#define FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_0_FIELD                 (_MK_MASK_CONST(0x1) << FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_0_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_0_RANGE                 8:8
#define FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_0_WOFFSET                       0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_0_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_FIQ_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Note: If more than one event is enabled, the event counter
// will decrement based on an or condition of enabled events. 
#define FLOW_CTLR_HALT_COP_EVENTS_0_ZERO_SHIFT                  _MK_SHIFT_CONST(0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_ZERO_FIELD                  (_MK_MASK_CONST(0xff) << FLOW_CTLR_HALT_COP_EVENTS_0_ZERO_SHIFT)
#define FLOW_CTLR_HALT_COP_EVENTS_0_ZERO_RANGE                  7:0
#define FLOW_CTLR_HALT_COP_EVENTS_0_ZERO_WOFFSET                        0x0
#define FLOW_CTLR_HALT_COP_EVENTS_0_ZERO_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_ZERO_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define FLOW_CTLR_HALT_COP_EVENTS_0_ZERO_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_HALT_COP_EVENTS_0_ZERO_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FLOW_CTLR_CPU_CSR_0  
#define FLOW_CTLR_CPU_CSR_0                     _MK_ADDR_CONST(0x8)
#define FLOW_CTLR_CPU_CSR_0_WORD_COUNT                  0x1
#define FLOW_CTLR_CPU_CSR_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FLOW_CTLR_CPU_CSR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define FLOW_CTLR_CPU_CSR_0_WRITE_MASK                  _MK_MASK_CONST(0x8001)
// Reserved 
#define FLOW_CTLR_CPU_CSR_0_RSVD_3128_SHIFT                     _MK_SHIFT_CONST(28)
#define FLOW_CTLR_CPU_CSR_0_RSVD_3128_FIELD                     (_MK_MASK_CONST(0xf) << FLOW_CTLR_CPU_CSR_0_RSVD_3128_SHIFT)
#define FLOW_CTLR_CPU_CSR_0_RSVD_3128_RANGE                     31:28
#define FLOW_CTLR_CPU_CSR_0_RSVD_3128_WOFFSET                   0x0
#define FLOW_CTLR_CPU_CSR_0_RSVD_3128_DEFAULT                   _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_RSVD_3128_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define FLOW_CTLR_CPU_CSR_0_RSVD_3128_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_RSVD_3128_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// PowerGate State Machine
#define FLOW_CTLR_CPU_CSR_0_PWR_STATE_SHIFT                     _MK_SHIFT_CONST(24)
#define FLOW_CTLR_CPU_CSR_0_PWR_STATE_FIELD                     (_MK_MASK_CONST(0xf) << FLOW_CTLR_CPU_CSR_0_PWR_STATE_SHIFT)
#define FLOW_CTLR_CPU_CSR_0_PWR_STATE_RANGE                     27:24
#define FLOW_CTLR_CPU_CSR_0_PWR_STATE_WOFFSET                   0x0
#define FLOW_CTLR_CPU_CSR_0_PWR_STATE_DEFAULT                   _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_PWR_STATE_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define FLOW_CTLR_CPU_CSR_0_PWR_STATE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_PWR_STATE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// CPU is waiting until event 
#define FLOW_CTLR_CPU_CSR_0_WAIT_EVENT_SHIFT                    _MK_SHIFT_CONST(23)
#define FLOW_CTLR_CPU_CSR_0_WAIT_EVENT_FIELD                    (_MK_MASK_CONST(0x1) << FLOW_CTLR_CPU_CSR_0_WAIT_EVENT_SHIFT)
#define FLOW_CTLR_CPU_CSR_0_WAIT_EVENT_RANGE                    23:23
#define FLOW_CTLR_CPU_CSR_0_WAIT_EVENT_WOFFSET                  0x0
#define FLOW_CTLR_CPU_CSR_0_WAIT_EVENT_DEFAULT                  _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_WAIT_EVENT_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FLOW_CTLR_CPU_CSR_0_WAIT_EVENT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_WAIT_EVENT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// CPU is halted 
#define FLOW_CTLR_CPU_CSR_0_HALT_SHIFT                  _MK_SHIFT_CONST(22)
#define FLOW_CTLR_CPU_CSR_0_HALT_FIELD                  (_MK_MASK_CONST(0x1) << FLOW_CTLR_CPU_CSR_0_HALT_SHIFT)
#define FLOW_CTLR_CPU_CSR_0_HALT_RANGE                  22:22
#define FLOW_CTLR_CPU_CSR_0_HALT_WOFFSET                        0x0
#define FLOW_CTLR_CPU_CSR_0_HALT_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_HALT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FLOW_CTLR_CPU_CSR_0_HALT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_HALT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// pmc2flow_ack
#define FLOW_CTLR_CPU_CSR_0_P2F_ACK_SHIFT                       _MK_SHIFT_CONST(21)
#define FLOW_CTLR_CPU_CSR_0_P2F_ACK_FIELD                       (_MK_MASK_CONST(0x1) << FLOW_CTLR_CPU_CSR_0_P2F_ACK_SHIFT)
#define FLOW_CTLR_CPU_CSR_0_P2F_ACK_RANGE                       21:21
#define FLOW_CTLR_CPU_CSR_0_P2F_ACK_WOFFSET                     0x0
#define FLOW_CTLR_CPU_CSR_0_P2F_ACK_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_P2F_ACK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FLOW_CTLR_CPU_CSR_0_P2F_ACK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_P2F_ACK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// flow2pmc_pwrup
#define FLOW_CTLR_CPU_CSR_0_F2P_PWRUP_SHIFT                     _MK_SHIFT_CONST(20)
#define FLOW_CTLR_CPU_CSR_0_F2P_PWRUP_FIELD                     (_MK_MASK_CONST(0x1) << FLOW_CTLR_CPU_CSR_0_F2P_PWRUP_SHIFT)
#define FLOW_CTLR_CPU_CSR_0_F2P_PWRUP_RANGE                     20:20
#define FLOW_CTLR_CPU_CSR_0_F2P_PWRUP_WOFFSET                   0x0
#define FLOW_CTLR_CPU_CSR_0_F2P_PWRUP_DEFAULT                   _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_F2P_PWRUP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FLOW_CTLR_CPU_CSR_0_F2P_PWRUP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_F2P_PWRUP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// flow2pmc_req valid
#define FLOW_CTLR_CPU_CSR_0_F2P_REQ_SHIFT                       _MK_SHIFT_CONST(19)
#define FLOW_CTLR_CPU_CSR_0_F2P_REQ_FIELD                       (_MK_MASK_CONST(0x1) << FLOW_CTLR_CPU_CSR_0_F2P_REQ_SHIFT)
#define FLOW_CTLR_CPU_CSR_0_F2P_REQ_RANGE                       19:19
#define FLOW_CTLR_CPU_CSR_0_F2P_REQ_WOFFSET                     0x0
#define FLOW_CTLR_CPU_CSR_0_F2P_REQ_DEFAULT                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_F2P_REQ_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FLOW_CTLR_CPU_CSR_0_F2P_REQ_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_F2P_REQ_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// TRUE when CPU transactions are flushed 
#define FLOW_CTLR_CPU_CSR_0_FLUSH_DONE_SHIFT                    _MK_SHIFT_CONST(18)
#define FLOW_CTLR_CPU_CSR_0_FLUSH_DONE_FIELD                    (_MK_MASK_CONST(0x1) << FLOW_CTLR_CPU_CSR_0_FLUSH_DONE_SHIFT)
#define FLOW_CTLR_CPU_CSR_0_FLUSH_DONE_RANGE                    18:18
#define FLOW_CTLR_CPU_CSR_0_FLUSH_DONE_WOFFSET                  0x0
#define FLOW_CTLR_CPU_CSR_0_FLUSH_DONE_DEFAULT                  _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_FLUSH_DONE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FLOW_CTLR_CPU_CSR_0_FLUSH_DONE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_FLUSH_DONE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// TRUE when Requesting Reset of MPCore 
#define FLOW_CTLR_CPU_CSR_0_F2C_MPCORE_RST_SHIFT                        _MK_SHIFT_CONST(17)
#define FLOW_CTLR_CPU_CSR_0_F2C_MPCORE_RST_FIELD                        (_MK_MASK_CONST(0x1) << FLOW_CTLR_CPU_CSR_0_F2C_MPCORE_RST_SHIFT)
#define FLOW_CTLR_CPU_CSR_0_F2C_MPCORE_RST_RANGE                        17:17
#define FLOW_CTLR_CPU_CSR_0_F2C_MPCORE_RST_WOFFSET                      0x0
#define FLOW_CTLR_CPU_CSR_0_F2C_MPCORE_RST_DEFAULT                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_F2C_MPCORE_RST_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FLOW_CTLR_CPU_CSR_0_F2C_MPCORE_RST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_F2C_MPCORE_RST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// TRUE when CPU PowerGated OFF by Flow Controller 
#define FLOW_CTLR_CPU_CSR_0_PWR_OFF_STS_SHIFT                   _MK_SHIFT_CONST(16)
#define FLOW_CTLR_CPU_CSR_0_PWR_OFF_STS_FIELD                   (_MK_MASK_CONST(0x1) << FLOW_CTLR_CPU_CSR_0_PWR_OFF_STS_SHIFT)
#define FLOW_CTLR_CPU_CSR_0_PWR_OFF_STS_RANGE                   16:16
#define FLOW_CTLR_CPU_CSR_0_PWR_OFF_STS_WOFFSET                 0x0
#define FLOW_CTLR_CPU_CSR_0_PWR_OFF_STS_DEFAULT                 _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_PWR_OFF_STS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FLOW_CTLR_CPU_CSR_0_PWR_OFF_STS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_PWR_OFF_STS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// TRUE when Interrupt is Active -- Write-1-to-Clear
#define FLOW_CTLR_CPU_CSR_0_INTR_FLAG_SHIFT                     _MK_SHIFT_CONST(15)
#define FLOW_CTLR_CPU_CSR_0_INTR_FLAG_FIELD                     (_MK_MASK_CONST(0x1) << FLOW_CTLR_CPU_CSR_0_INTR_FLAG_SHIFT)
#define FLOW_CTLR_CPU_CSR_0_INTR_FLAG_RANGE                     15:15
#define FLOW_CTLR_CPU_CSR_0_INTR_FLAG_WOFFSET                   0x0
#define FLOW_CTLR_CPU_CSR_0_INTR_FLAG_DEFAULT                   _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_INTR_FLAG_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FLOW_CTLR_CPU_CSR_0_INTR_FLAG_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_INTR_FLAG_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Reserved
#define FLOW_CTLR_CPU_CSR_0_RSVD_1401_SHIFT                     _MK_SHIFT_CONST(1)
#define FLOW_CTLR_CPU_CSR_0_RSVD_1401_FIELD                     (_MK_MASK_CONST(0x3fff) << FLOW_CTLR_CPU_CSR_0_RSVD_1401_SHIFT)
#define FLOW_CTLR_CPU_CSR_0_RSVD_1401_RANGE                     14:1
#define FLOW_CTLR_CPU_CSR_0_RSVD_1401_WOFFSET                   0x0
#define FLOW_CTLR_CPU_CSR_0_RSVD_1401_DEFAULT                   _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_RSVD_1401_DEFAULT_MASK                      _MK_MASK_CONST(0x3fff)
#define FLOW_CTLR_CPU_CSR_0_RSVD_1401_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_RSVD_1401_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// PowerGate Enable - Halt or Event-wait causes CPU PowerGating
#define FLOW_CTLR_CPU_CSR_0_ENABLE_SHIFT                        _MK_SHIFT_CONST(0)
#define FLOW_CTLR_CPU_CSR_0_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << FLOW_CTLR_CPU_CSR_0_ENABLE_SHIFT)
#define FLOW_CTLR_CPU_CSR_0_ENABLE_RANGE                        0:0
#define FLOW_CTLR_CPU_CSR_0_ENABLE_WOFFSET                      0x0
#define FLOW_CTLR_CPU_CSR_0_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FLOW_CTLR_CPU_CSR_0_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FLOW_CTLR_CPU_CSR_0_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FLOW_CTLR_COP_CSR_0  
#define FLOW_CTLR_COP_CSR_0                     _MK_ADDR_CONST(0xc)
#define FLOW_CTLR_COP_CSR_0_WORD_COUNT                  0x1
#define FLOW_CTLR_COP_CSR_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FLOW_CTLR_COP_CSR_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FLOW_CTLR_COP_CSR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FLOW_CTLR_COP_CSR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FLOW_CTLR_COP_CSR_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define FLOW_CTLR_COP_CSR_0_WRITE_MASK                  _MK_MASK_CONST(0x8000)
// Reserved 
#define FLOW_CTLR_COP_CSR_0_RSVD_3116_SHIFT                     _MK_SHIFT_CONST(16)
#define FLOW_CTLR_COP_CSR_0_RSVD_3116_FIELD                     (_MK_MASK_CONST(0xffff) << FLOW_CTLR_COP_CSR_0_RSVD_3116_SHIFT)
#define FLOW_CTLR_COP_CSR_0_RSVD_3116_RANGE                     31:16
#define FLOW_CTLR_COP_CSR_0_RSVD_3116_WOFFSET                   0x0
#define FLOW_CTLR_COP_CSR_0_RSVD_3116_DEFAULT                   _MK_MASK_CONST(0x0)
#define FLOW_CTLR_COP_CSR_0_RSVD_3116_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define FLOW_CTLR_COP_CSR_0_RSVD_3116_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_COP_CSR_0_RSVD_3116_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// TRUE when Interrupt is Active -- Write-1-to-Clear
#define FLOW_CTLR_COP_CSR_0_INTR_FLAG_SHIFT                     _MK_SHIFT_CONST(15)
#define FLOW_CTLR_COP_CSR_0_INTR_FLAG_FIELD                     (_MK_MASK_CONST(0x1) << FLOW_CTLR_COP_CSR_0_INTR_FLAG_SHIFT)
#define FLOW_CTLR_COP_CSR_0_INTR_FLAG_RANGE                     15:15
#define FLOW_CTLR_COP_CSR_0_INTR_FLAG_WOFFSET                   0x0
#define FLOW_CTLR_COP_CSR_0_INTR_FLAG_DEFAULT                   _MK_MASK_CONST(0x0)
#define FLOW_CTLR_COP_CSR_0_INTR_FLAG_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FLOW_CTLR_COP_CSR_0_INTR_FLAG_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_COP_CSR_0_INTR_FLAG_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Reserved
#define FLOW_CTLR_COP_CSR_0_RSVD_1400_SHIFT                     _MK_SHIFT_CONST(0)
#define FLOW_CTLR_COP_CSR_0_RSVD_1400_FIELD                     (_MK_MASK_CONST(0x7fff) << FLOW_CTLR_COP_CSR_0_RSVD_1400_SHIFT)
#define FLOW_CTLR_COP_CSR_0_RSVD_1400_RANGE                     14:0
#define FLOW_CTLR_COP_CSR_0_RSVD_1400_WOFFSET                   0x0
#define FLOW_CTLR_COP_CSR_0_RSVD_1400_DEFAULT                   _MK_MASK_CONST(0x0)
#define FLOW_CTLR_COP_CSR_0_RSVD_1400_DEFAULT_MASK                      _MK_MASK_CONST(0x7fff)
#define FLOW_CTLR_COP_CSR_0_RSVD_1400_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_COP_CSR_0_RSVD_1400_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FLOW_CTLR_XRQ_EVENTS_0  
#define FLOW_CTLR_XRQ_EVENTS_0                  _MK_ADDR_CONST(0x10)
#define FLOW_CTLR_XRQ_EVENTS_0_WORD_COUNT                       0x1
#define FLOW_CTLR_XRQ_EVENTS_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define FLOW_CTLR_XRQ_EVENTS_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define FLOW_CTLR_XRQ_EVENTS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define FLOW_CTLR_XRQ_EVENTS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define FLOW_CTLR_XRQ_EVENTS_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define FLOW_CTLR_XRQ_EVENTS_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// Setting a bit to 1 enables event triggering for  the corresponding bit in GPIO port D. The assertion level is determined by  GPIO_INT.LVL.D. If more than one XRQ.D bit is set, the events are ORed  together. The resultant event is enabled by setting the XRQ.D bit in the  HALT_CPU.EVENTS or HALT_COP.EVENTS registers.
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_D7_XRQ_D0_SHIFT                      _MK_SHIFT_CONST(24)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_D7_XRQ_D0_FIELD                      (_MK_MASK_CONST(0xff) << FLOW_CTLR_XRQ_EVENTS_0_XRQ_D7_XRQ_D0_SHIFT)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_D7_XRQ_D0_RANGE                      31:24
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_D7_XRQ_D0_WOFFSET                    0x0
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_D7_XRQ_D0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_D7_XRQ_D0_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_D7_XRQ_D0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_D7_XRQ_D0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Setting a bit to 1 enables event triggering for  the corresponding bit in GPIO port C. The assertion level is determined by  GPIO_INT.LVL.C. If more than one XRQ.C bit is set, the events are ORed  together. The resultant event is enabled by setting the XRQ.C bit in the  HALT_CPU.EVENTS or HALT_COP.EVENTS registers.
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_C7_XRQ_C0_SHIFT                      _MK_SHIFT_CONST(16)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_C7_XRQ_C0_FIELD                      (_MK_MASK_CONST(0xff) << FLOW_CTLR_XRQ_EVENTS_0_XRQ_C7_XRQ_C0_SHIFT)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_C7_XRQ_C0_RANGE                      23:16
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_C7_XRQ_C0_WOFFSET                    0x0
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_C7_XRQ_C0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_C7_XRQ_C0_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_C7_XRQ_C0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_C7_XRQ_C0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Setting a bit to 1 enables event triggering for  the corresponding bit in GPIO port B. The assertion level is determined by  GPIO_INT.LVL.B. If more than one XRQ.B bit is set, the events are ORed  together. The resultant event is enabled by setting the XRQ.B bit in the  HALT_CPU.EVENTS or HALT_COP.EVENTS registers.
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_B7_XRQ_B0_SHIFT                      _MK_SHIFT_CONST(8)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_B7_XRQ_B0_FIELD                      (_MK_MASK_CONST(0xff) << FLOW_CTLR_XRQ_EVENTS_0_XRQ_B7_XRQ_B0_SHIFT)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_B7_XRQ_B0_RANGE                      15:8
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_B7_XRQ_B0_WOFFSET                    0x0
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_B7_XRQ_B0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_B7_XRQ_B0_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_B7_XRQ_B0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_B7_XRQ_B0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Setting a bit to 1 enables event triggering for  the corresponding bit in GPIO port A. The assertion level is determined by  GPIO_INT.LVL.A. If more than one XRQ.A bit is set, the events are ORed  together. The resultant event is enabled by setting the XRQ.A bit in the  HALT_CPU.EVENTS or HALT_COP.EVENTS registers.
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_A7_XRQ_A0_SHIFT                      _MK_SHIFT_CONST(0)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_A7_XRQ_A0_FIELD                      (_MK_MASK_CONST(0xff) << FLOW_CTLR_XRQ_EVENTS_0_XRQ_A7_XRQ_A0_SHIFT)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_A7_XRQ_A0_RANGE                      7:0
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_A7_XRQ_A0_WOFFSET                    0x0
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_A7_XRQ_A0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_A7_XRQ_A0_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_A7_XRQ_A0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FLOW_CTLR_XRQ_EVENTS_0_XRQ_A7_XRQ_A0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_ARFLOW_CTLR_REGS(_op_) \
_op_(FLOW_CTLR_HALT_CPU_EVENTS_0) \
_op_(FLOW_CTLR_HALT_COP_EVENTS_0) \
_op_(FLOW_CTLR_CPU_CSR_0) \
_op_(FLOW_CTLR_COP_CSR_0) \
_op_(FLOW_CTLR_XRQ_EVENTS_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_FLOW_CTLR  0x00000000

//
// ARFLOW_CTLR REGISTER BANKS
//

#define FLOW_CTLR0_FIRST_REG 0x0000 // FLOW_CTLR_HALT_CPU_EVENTS_0
#define FLOW_CTLR0_LAST_REG 0x0010 // FLOW_CTLR_XRQ_EVENTS_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARFLOW_CTLR_H_INC_
