/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARI2C_H_INC_
#define ___ARI2C_H_INC_
////////////////////////////////////////////////////////////////////////////////////////
//
// NOTE: 
// ----- 
// The FREQUENCY DIVISOR register (CLK_SOURCE_I2C register) must be programmed as a
// function of the CLK_SOURCE Selected for I2C as follows:
// I2C_CLK =  CLK_SOURCE.I2C / ( 8 *  I2C FREQUENCY DIVISOR)
// The I2C bus specification defines the minimum low period for the I2C_CLK as 4.7 s in standard mode 
// and 1.3 s in fast mode. Because of this, the maximum I2C_CLK frequency in the 
// standard mode can be 100 KHz but in fast mode, it is limited to 348 KHz, assuming I2C_CLK as rise and
// fall delays of 300ns per the I2C specification.
// The clock enable (bit-12 of CLK_OUT_ENB.L register)
// must also be given to I2C controller, before any of the registers are written.
//
////////////////////////////////////////////////////////////////////////////////////////
//IC Controller Configuration Register  (Master)
//I2C_CNFG register is used to configure,
//The number of bytes to be transmitted or received,
//the slave device type either a 7-bit device or a 10-bit device,
//Enable mode to send Start-Byte or not,
//to select either a single slave transaction or two slave transaction,
//Enable mode to handle devices that do not generate  ACK.

// Register I2C_I2C_CNFG_0  
#define I2C_I2C_CNFG_0                  _MK_ADDR_CONST(0x0)
#define I2C_I2C_CNFG_0_WORD_COUNT                       0x1
#define I2C_I2C_CNFG_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_CNFG_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_CNFG_0_WRITE_MASK                       _MK_MASK_CONST(0x3ff)
// Reserved = 0
#define I2C_I2C_CNFG_0_N_A1_SHIFT                       _MK_SHIFT_CONST(10)
#define I2C_I2C_CNFG_0_N_A1_FIELD                       (_MK_MASK_CONST(0x3fffff) << I2C_I2C_CNFG_0_N_A1_SHIFT)
#define I2C_I2C_CNFG_0_N_A1_RANGE                       31:10
#define I2C_I2C_CNFG_0_N_A1_WOFFSET                     0x0
#define I2C_I2C_CNFG_0_N_A1_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_N_A1_DEFAULT_MASK                        _MK_MASK_CONST(0x3fffff)
#define I2C_I2C_CNFG_0_N_A1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_N_A1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Writing a 1 causes the master to initiate the
// transaction. Values of other  bits are not
// affected when this bit is 1,Cleared by 
// hardware.  Other bits of the register are
// masked for writes when this bit is programmed
// to one.hence,firware should first configure
// all other registrs and  bits [8:0] of 
// I2C_CNFG register before the bit I2C_CNFG[9] is programmed to one..
#define I2C_I2C_CNFG_0_SEND_SHIFT                       _MK_SHIFT_CONST(9)
#define I2C_I2C_CNFG_0_SEND_FIELD                       (_MK_MASK_CONST(0x1) << I2C_I2C_CNFG_0_SEND_SHIFT)
#define I2C_I2C_CNFG_0_SEND_RANGE                       9:9
#define I2C_I2C_CNFG_0_SEND_WOFFSET                     0x0
#define I2C_I2C_CNFG_0_SEND_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_SEND_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define I2C_I2C_CNFG_0_SEND_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_SEND_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_SEND_NOP                 _MK_ENUM_CONST(0)
#define I2C_I2C_CNFG_0_SEND_GO                  _MK_ENUM_CONST(1)

// Enable mode to handle devices that do not generate ACK. 
// 1 - dont look for an ack at the end of the transaction.
#define I2C_I2C_CNFG_0_NOACK_SHIFT                      _MK_SHIFT_CONST(8)
#define I2C_I2C_CNFG_0_NOACK_FIELD                      (_MK_MASK_CONST(0x1) << I2C_I2C_CNFG_0_NOACK_SHIFT)
#define I2C_I2C_CNFG_0_NOACK_RANGE                      8:8
#define I2C_I2C_CNFG_0_NOACK_WOFFSET                    0x0
#define I2C_I2C_CNFG_0_NOACK_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_NOACK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define I2C_I2C_CNFG_0_NOACK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_NOACK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_NOACK_DISABLE                    _MK_ENUM_CONST(0)
#define I2C_I2C_CNFG_0_NOACK_ENABLE                     _MK_ENUM_CONST(1)

// Read/Write Command for Slave 2:
// 1 -  Read Transaction;
// 0 -  write Transaction.
// For a 7-bit slave address,this bit must match
// with the LSB of address byte for slave 2.
// Valid only when  bit-4 (SLV2) of this register is 
// set
#define I2C_I2C_CNFG_0_CMD2_SHIFT                       _MK_SHIFT_CONST(7)
#define I2C_I2C_CNFG_0_CMD2_FIELD                       (_MK_MASK_CONST(0x1) << I2C_I2C_CNFG_0_CMD2_SHIFT)
#define I2C_I2C_CNFG_0_CMD2_RANGE                       7:7
#define I2C_I2C_CNFG_0_CMD2_WOFFSET                     0x0
#define I2C_I2C_CNFG_0_CMD2_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_CMD2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define I2C_I2C_CNFG_0_CMD2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_CMD2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_CMD2_DISABLE                     _MK_ENUM_CONST(0)
#define I2C_I2C_CNFG_0_CMD2_ENABLE                      _MK_ENUM_CONST(1)

// Read/Write Command for Slave 1: 
// 1 - Read Transaction;
// 0 -  write Transaction.
// Command for Slave 1: For a 7-bit slave address
// this bit must match with the LSB of address 
// byte for slave2.
#define I2C_I2C_CNFG_0_CMD1_SHIFT                       _MK_SHIFT_CONST(6)
#define I2C_I2C_CNFG_0_CMD1_FIELD                       (_MK_MASK_CONST(0x1) << I2C_I2C_CNFG_0_CMD1_SHIFT)
#define I2C_I2C_CNFG_0_CMD1_RANGE                       6:6
#define I2C_I2C_CNFG_0_CMD1_WOFFSET                     0x0
#define I2C_I2C_CNFG_0_CMD1_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_CMD1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define I2C_I2C_CNFG_0_CMD1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_CMD1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_CMD1_DISABLE                     _MK_ENUM_CONST(0)
#define I2C_I2C_CNFG_0_CMD1_ENABLE                      _MK_ENUM_CONST(1)

// 1 = Yes, a Start byte needs to be  sent.
#define I2C_I2C_CNFG_0_START_SHIFT                      _MK_SHIFT_CONST(5)
#define I2C_I2C_CNFG_0_START_FIELD                      (_MK_MASK_CONST(0x1) << I2C_I2C_CNFG_0_START_SHIFT)
#define I2C_I2C_CNFG_0_START_RANGE                      5:5
#define I2C_I2C_CNFG_0_START_WOFFSET                    0x0
#define I2C_I2C_CNFG_0_START_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_START_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define I2C_I2C_CNFG_0_START_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_START_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_START_DISABLE                    _MK_ENUM_CONST(0)
#define I2C_I2C_CNFG_0_START_ENABLE                     _MK_ENUM_CONST(1)

// 1 - Enables a two slave transaction;
// 0 = No command for Slave 2 present.
#define I2C_I2C_CNFG_0_SLV2_SHIFT                       _MK_SHIFT_CONST(4)
#define I2C_I2C_CNFG_0_SLV2_FIELD                       (_MK_MASK_CONST(0x1) << I2C_I2C_CNFG_0_SLV2_SHIFT)
#define I2C_I2C_CNFG_0_SLV2_RANGE                       4:4
#define I2C_I2C_CNFG_0_SLV2_WOFFSET                     0x0
#define I2C_I2C_CNFG_0_SLV2_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_SLV2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define I2C_I2C_CNFG_0_SLV2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_SLV2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_SLV2_DISABLE                     _MK_ENUM_CONST(0)
#define I2C_I2C_CNFG_0_SLV2_ENABLE                      _MK_ENUM_CONST(1)

// The Number of bytes to be transmitted per
// transaction 000= 1byte ... 111 = 8bytes;
// In a two slave transaction number of bytes
// should be programmed less than 011. 
#define I2C_I2C_CNFG_0_LENGTH_SHIFT                     _MK_SHIFT_CONST(1)
#define I2C_I2C_CNFG_0_LENGTH_FIELD                     (_MK_MASK_CONST(0x7) << I2C_I2C_CNFG_0_LENGTH_SHIFT)
#define I2C_I2C_CNFG_0_LENGTH_RANGE                     3:1
#define I2C_I2C_CNFG_0_LENGTH_WOFFSET                   0x0
#define I2C_I2C_CNFG_0_LENGTH_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_LENGTH_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define I2C_I2C_CNFG_0_LENGTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_LENGTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Address mode defines whether a 7-bit or a 
// 10-bit slave address is programmed.
// 1 = 10-bit device address 
// 0 = 7-bit device address
#define I2C_I2C_CNFG_0_A_MOD_SHIFT                      _MK_SHIFT_CONST(0)
#define I2C_I2C_CNFG_0_A_MOD_FIELD                      (_MK_MASK_CONST(0x1) << I2C_I2C_CNFG_0_A_MOD_SHIFT)
#define I2C_I2C_CNFG_0_A_MOD_RANGE                      0:0
#define I2C_I2C_CNFG_0_A_MOD_WOFFSET                    0x0
#define I2C_I2C_CNFG_0_A_MOD_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_A_MOD_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define I2C_I2C_CNFG_0_A_MOD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_A_MOD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_A_MOD_SEVEN_BIT_DEVICE_ADDRESS                   _MK_ENUM_CONST(0)
#define I2C_I2C_CNFG_0_A_MOD_TEN_BIT_DEVICE_ADDRESS                     _MK_ENUM_CONST(1)

//I2C Slave-1 Address 
//I2C_CMD_ADDR0 is programmed the 7 Bit or 10 Bit address of slave 1 with which the transaction is intended; 

// Register I2C_I2C_CMD_ADDR0_0  
#define I2C_I2C_CMD_ADDR0_0                     _MK_ADDR_CONST(0x4)
#define I2C_I2C_CMD_ADDR0_0_WORD_COUNT                  0x1
#define I2C_I2C_CMD_ADDR0_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR0_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_CMD_ADDR0_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR0_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR0_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_CMD_ADDR0_0_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
// Reserved = 0
#define I2C_I2C_CMD_ADDR0_0_N_A2_SHIFT                  _MK_SHIFT_CONST(10)
#define I2C_I2C_CMD_ADDR0_0_N_A2_FIELD                  (_MK_MASK_CONST(0x3fffff) << I2C_I2C_CMD_ADDR0_0_N_A2_SHIFT)
#define I2C_I2C_CMD_ADDR0_0_N_A2_RANGE                  31:10
#define I2C_I2C_CMD_ADDR0_0_N_A2_WOFFSET                        0x0
#define I2C_I2C_CMD_ADDR0_0_N_A2_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR0_0_N_A2_DEFAULT_MASK                   _MK_MASK_CONST(0x3fffff)
#define I2C_I2C_CMD_ADDR0_0_N_A2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR0_0_N_A2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// In case of 7-Bit mode address is written in the 
// I2C_CMD_ADDR0[7:1] and I2C_CMD_ADDR0[0] indicates the
// read/write transaction.I2C_CMD_ADDR0[0] bit must match 
// with the I2C_CNFG[6].   
// In case of 10-Bit mode addess is written in 
// I2C_CMD_ADDR0[9:0] and I2C_CNFG[6]  indicates the 
// read/write transaction.                                     
#define I2C_I2C_CMD_ADDR0_0_ADDR0_SHIFT                 _MK_SHIFT_CONST(0)
#define I2C_I2C_CMD_ADDR0_0_ADDR0_FIELD                 (_MK_MASK_CONST(0x3ff) << I2C_I2C_CMD_ADDR0_0_ADDR0_SHIFT)
#define I2C_I2C_CMD_ADDR0_0_ADDR0_RANGE                 9:0
#define I2C_I2C_CMD_ADDR0_0_ADDR0_WOFFSET                       0x0
#define I2C_I2C_CMD_ADDR0_0_ADDR0_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR0_0_ADDR0_DEFAULT_MASK                  _MK_MASK_CONST(0x3ff)
#define I2C_I2C_CMD_ADDR0_0_ADDR0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR0_0_ADDR0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//I2C Slave-2 Address
//I2C_CMD_ADDR1 is programmed the 7 Bit or 10 Bit address of slave 2 with which the transaction is intended;

// Register I2C_I2C_CMD_ADDR1_0  
#define I2C_I2C_CMD_ADDR1_0                     _MK_ADDR_CONST(0x8)
#define I2C_I2C_CMD_ADDR1_0_WORD_COUNT                  0x1
#define I2C_I2C_CMD_ADDR1_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR1_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_CMD_ADDR1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR1_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_CMD_ADDR1_0_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
// Reserved = 0
#define I2C_I2C_CMD_ADDR1_0_N_A3_SHIFT                  _MK_SHIFT_CONST(10)
#define I2C_I2C_CMD_ADDR1_0_N_A3_FIELD                  (_MK_MASK_CONST(0x3fffff) << I2C_I2C_CMD_ADDR1_0_N_A3_SHIFT)
#define I2C_I2C_CMD_ADDR1_0_N_A3_RANGE                  31:10
#define I2C_I2C_CMD_ADDR1_0_N_A3_WOFFSET                        0x0
#define I2C_I2C_CMD_ADDR1_0_N_A3_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR1_0_N_A3_DEFAULT_MASK                   _MK_MASK_CONST(0x3fffff)
#define I2C_I2C_CMD_ADDR1_0_N_A3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR1_0_N_A3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// In case of 7-Bit mode address is written in the 
// I2C_CMD_ADDR0[7:1] and I2C_CMD_ADDR0[0] indicates the 
// read/write transaction.I2C_CMD_ADDR0[0] bit must match 
// with the I2C_CNFG[7].
// In case of 10-Bit mode addess is written in 
// I2C_CMD_ADDR0[9:0] and I2C_CNFG[7] indicates the 
// read/write transaction.
#define I2C_I2C_CMD_ADDR1_0_ADDR1_SHIFT                 _MK_SHIFT_CONST(0)
#define I2C_I2C_CMD_ADDR1_0_ADDR1_FIELD                 (_MK_MASK_CONST(0x3ff) << I2C_I2C_CMD_ADDR1_0_ADDR1_SHIFT)
#define I2C_I2C_CMD_ADDR1_0_ADDR1_RANGE                 9:0
#define I2C_I2C_CMD_ADDR1_0_ADDR1_WOFFSET                       0x0
#define I2C_I2C_CMD_ADDR1_0_ADDR1_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR1_0_ADDR1_DEFAULT_MASK                  _MK_MASK_CONST(0x3ff)
#define I2C_I2C_CMD_ADDR1_0_ADDR1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR1_0_ADDR1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//IC Controller Data 1: Transmit/Receive
//The four Least Significant Bytes of Data to be Transamitted is loaded into the register when I2c Master 
//is in Write Mode;
//The four Least Significant Bytes of Data are Read through this register when I2c Master is in Read mode.               

// Register I2C_I2C_CMD_DATA1_0  
#define I2C_I2C_CMD_DATA1_0                     _MK_ADDR_CONST(0xc)
#define I2C_I2C_CMD_DATA1_0_WORD_COUNT                  0x1
#define I2C_I2C_CMD_DATA1_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_CMD_DATA1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_CMD_DATA1_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// Fourth data byte to be sent/received
#define I2C_I2C_CMD_DATA1_0_DATA4_SHIFT                 _MK_SHIFT_CONST(24)
#define I2C_I2C_CMD_DATA1_0_DATA4_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_CMD_DATA1_0_DATA4_SHIFT)
#define I2C_I2C_CMD_DATA1_0_DATA4_RANGE                 31:24
#define I2C_I2C_CMD_DATA1_0_DATA4_WOFFSET                       0x0
#define I2C_I2C_CMD_DATA1_0_DATA4_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_DATA4_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_CMD_DATA1_0_DATA4_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_DATA4_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Third data byte to be sent/received
#define I2C_I2C_CMD_DATA1_0_DATA3_SHIFT                 _MK_SHIFT_CONST(16)
#define I2C_I2C_CMD_DATA1_0_DATA3_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_CMD_DATA1_0_DATA3_SHIFT)
#define I2C_I2C_CMD_DATA1_0_DATA3_RANGE                 23:16
#define I2C_I2C_CMD_DATA1_0_DATA3_WOFFSET                       0x0
#define I2C_I2C_CMD_DATA1_0_DATA3_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_DATA3_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_CMD_DATA1_0_DATA3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_DATA3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Second data byte to be sent/received
#define I2C_I2C_CMD_DATA1_0_DATA2_SHIFT                 _MK_SHIFT_CONST(8)
#define I2C_I2C_CMD_DATA1_0_DATA2_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_CMD_DATA1_0_DATA2_SHIFT)
#define I2C_I2C_CMD_DATA1_0_DATA2_RANGE                 15:8
#define I2C_I2C_CMD_DATA1_0_DATA2_WOFFSET                       0x0
#define I2C_I2C_CMD_DATA1_0_DATA2_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_DATA2_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_CMD_DATA1_0_DATA2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_DATA2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This register contains the first data byte to be  sent/received.
#define I2C_I2C_CMD_DATA1_0_DATA1_SHIFT                 _MK_SHIFT_CONST(0)
#define I2C_I2C_CMD_DATA1_0_DATA1_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_CMD_DATA1_0_DATA1_SHIFT)
#define I2C_I2C_CMD_DATA1_0_DATA1_RANGE                 7:0
#define I2C_I2C_CMD_DATA1_0_DATA1_WOFFSET                       0x0
#define I2C_I2C_CMD_DATA1_0_DATA1_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_DATA1_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_CMD_DATA1_0_DATA1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_DATA1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//IC Controller Data 2: Transmit/Receive
//The four Most Significant Bytes of Data to be Transamitted is loaded into the register when I2c Master is in Write Mode;
//The four Most Significant Bytes of Data are Read through this register when I2c Master is in Read mode.

// Register I2C_I2C_CMD_DATA2_0  
#define I2C_I2C_CMD_DATA2_0                     _MK_ADDR_CONST(0x10)
#define I2C_I2C_CMD_DATA2_0_WORD_COUNT                  0x1
#define I2C_I2C_CMD_DATA2_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_CMD_DATA2_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_CMD_DATA2_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// Eighth data byte to be sent/received
#define I2C_I2C_CMD_DATA2_0_DATA8_SHIFT                 _MK_SHIFT_CONST(24)
#define I2C_I2C_CMD_DATA2_0_DATA8_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_CMD_DATA2_0_DATA8_SHIFT)
#define I2C_I2C_CMD_DATA2_0_DATA8_RANGE                 31:24
#define I2C_I2C_CMD_DATA2_0_DATA8_WOFFSET                       0x0
#define I2C_I2C_CMD_DATA2_0_DATA8_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_DATA8_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_CMD_DATA2_0_DATA8_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_DATA8_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Seventh data byte to be sent/received
#define I2C_I2C_CMD_DATA2_0_DATA7_SHIFT                 _MK_SHIFT_CONST(16)
#define I2C_I2C_CMD_DATA2_0_DATA7_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_CMD_DATA2_0_DATA7_SHIFT)
#define I2C_I2C_CMD_DATA2_0_DATA7_RANGE                 23:16
#define I2C_I2C_CMD_DATA2_0_DATA7_WOFFSET                       0x0
#define I2C_I2C_CMD_DATA2_0_DATA7_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_DATA7_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_CMD_DATA2_0_DATA7_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_DATA7_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Sixth data byte to be sent/received
#define I2C_I2C_CMD_DATA2_0_DATA6_SHIFT                 _MK_SHIFT_CONST(8)
#define I2C_I2C_CMD_DATA2_0_DATA6_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_CMD_DATA2_0_DATA6_SHIFT)
#define I2C_I2C_CMD_DATA2_0_DATA6_RANGE                 15:8
#define I2C_I2C_CMD_DATA2_0_DATA6_WOFFSET                       0x0
#define I2C_I2C_CMD_DATA2_0_DATA6_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_DATA6_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_CMD_DATA2_0_DATA6_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_DATA6_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This register contains the Fifth data byte to be  sent/received.
#define I2C_I2C_CMD_DATA2_0_DATA5_SHIFT                 _MK_SHIFT_CONST(0)
#define I2C_I2C_CMD_DATA2_0_DATA5_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_CMD_DATA2_0_DATA5_SHIFT)
#define I2C_I2C_CMD_DATA2_0_DATA5_RANGE                 7:0
#define I2C_I2C_CMD_DATA2_0_DATA5_WOFFSET                       0x0
#define I2C_I2C_CMD_DATA2_0_DATA5_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_DATA5_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_CMD_DATA2_0_DATA5_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_DATA5_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 20 [0x14] 

// Reserved address 24 [0x18] 
//IC Controller Status (Master)
//I2C_STATUS gives the status of I2c Master operation

// Register I2C_I2C_STATUS_0  
#define I2C_I2C_STATUS_0                        _MK_ADDR_CONST(0x1c)
#define I2C_I2C_STATUS_0_WORD_COUNT                     0x1
#define I2C_I2C_STATUS_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_STATUS_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_STATUS_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
// Reserved = 0
#define I2C_I2C_STATUS_0_N_A4_SHIFT                     _MK_SHIFT_CONST(9)
#define I2C_I2C_STATUS_0_N_A4_FIELD                     (_MK_MASK_CONST(0x7fffff) << I2C_I2C_STATUS_0_N_A4_SHIFT)
#define I2C_I2C_STATUS_0_N_A4_RANGE                     31:9
#define I2C_I2C_STATUS_0_N_A4_WOFFSET                   0x0
#define I2C_I2C_STATUS_0_N_A4_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_N_A4_DEFAULT_MASK                      _MK_MASK_CONST(0x7fffff)
#define I2C_I2C_STATUS_0_N_A4_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_N_A4_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//  1 = Bus Busy.
#define I2C_I2C_STATUS_0_BUSY_SHIFT                     _MK_SHIFT_CONST(8)
#define I2C_I2C_STATUS_0_BUSY_FIELD                     (_MK_MASK_CONST(0x1) << I2C_I2C_STATUS_0_BUSY_SHIFT)
#define I2C_I2C_STATUS_0_BUSY_RANGE                     8:8
#define I2C_I2C_STATUS_0_BUSY_WOFFSET                   0x0
#define I2C_I2C_STATUS_0_BUSY_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_BUSY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define I2C_I2C_STATUS_0_BUSY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_BUSY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_BUSY_NOT_BUSY                  _MK_ENUM_CONST(0)
#define I2C_I2C_STATUS_0_BUSY_BUSY                      _MK_ENUM_CONST(1)

// Transaction for Slave2 for x byte failed. x is 'h0 to 'ha.
// all others invalid
#define I2C_I2C_STATUS_0_CMD2_STAT_SHIFT                        _MK_SHIFT_CONST(4)
#define I2C_I2C_STATUS_0_CMD2_STAT_FIELD                        (_MK_MASK_CONST(0xf) << I2C_I2C_STATUS_0_CMD2_STAT_SHIFT)
#define I2C_I2C_STATUS_0_CMD2_STAT_RANGE                        7:4
#define I2C_I2C_STATUS_0_CMD2_STAT_WOFFSET                      0x0
#define I2C_I2C_STATUS_0_CMD2_STAT_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_CMD2_STAT_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define I2C_I2C_STATUS_0_CMD2_STAT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_CMD2_STAT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_XFER_SUCCESSFUL                  _MK_ENUM_CONST(0)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE1                  _MK_ENUM_CONST(1)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE2                  _MK_ENUM_CONST(2)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE3                  _MK_ENUM_CONST(3)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE4                  _MK_ENUM_CONST(4)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE5                  _MK_ENUM_CONST(5)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE6                  _MK_ENUM_CONST(6)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE7                  _MK_ENUM_CONST(7)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE8                  _MK_ENUM_CONST(8)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE9                  _MK_ENUM_CONST(9)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE10                 _MK_ENUM_CONST(10)

// Transaction for Slave1 for x byte failed. x is 'h0 to 'ha
// all others invalid
#define I2C_I2C_STATUS_0_CMD1_STAT_SHIFT                        _MK_SHIFT_CONST(0)
#define I2C_I2C_STATUS_0_CMD1_STAT_FIELD                        (_MK_MASK_CONST(0xf) << I2C_I2C_STATUS_0_CMD1_STAT_SHIFT)
#define I2C_I2C_STATUS_0_CMD1_STAT_RANGE                        3:0
#define I2C_I2C_STATUS_0_CMD1_STAT_WOFFSET                      0x0
#define I2C_I2C_STATUS_0_CMD1_STAT_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_CMD1_STAT_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define I2C_I2C_STATUS_0_CMD1_STAT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_CMD1_STAT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_XFER_SUCCESSFUL                  _MK_ENUM_CONST(0)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE1                  _MK_ENUM_CONST(1)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE2                  _MK_ENUM_CONST(2)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE3                  _MK_ENUM_CONST(3)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE4                  _MK_ENUM_CONST(4)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE5                  _MK_ENUM_CONST(5)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE6                  _MK_ENUM_CONST(6)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE7                  _MK_ENUM_CONST(7)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE8                  _MK_ENUM_CONST(8)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE9                  _MK_ENUM_CONST(9)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE10                 _MK_ENUM_CONST(10)

//IC Controller Configuration (Slave)
//I2C_SL_CNFG register is used to configure,
//Enable mode of slave Ack,
//Enable mode of slave response to general call address.
//The register should be programmed when I2c controller is configured as slave.  

// Register I2C_I2C_SL_CNFG_0  
#define I2C_I2C_SL_CNFG_0                       _MK_ADDR_CONST(0x20)
#define I2C_I2C_SL_CNFG_0_WORD_COUNT                    0x1
#define I2C_I2C_SL_CNFG_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_SL_CNFG_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_SL_CNFG_0_WRITE_MASK                    _MK_MASK_CONST(0x3)
// Reserved = 0
#define I2C_I2C_SL_CNFG_0_N_A5_SHIFT                    _MK_SHIFT_CONST(2)
#define I2C_I2C_SL_CNFG_0_N_A5_FIELD                    (_MK_MASK_CONST(0x3fffffff) << I2C_I2C_SL_CNFG_0_N_A5_SHIFT)
#define I2C_I2C_SL_CNFG_0_N_A5_RANGE                    31:2
#define I2C_I2C_SL_CNFG_0_N_A5_WOFFSET                  0x0
#define I2C_I2C_SL_CNFG_0_N_A5_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_N_A5_DEFAULT_MASK                     _MK_MASK_CONST(0x3fffffff)
#define I2C_I2C_SL_CNFG_0_N_A5_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_N_A5_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Disable Slave Ack. when bit set to 1 slave will not ack
// reception of address or data byte. 
#define I2C_I2C_SL_CNFG_0_NACK_SHIFT                    _MK_SHIFT_CONST(1)
#define I2C_I2C_SL_CNFG_0_NACK_FIELD                    (_MK_MASK_CONST(0x1) << I2C_I2C_SL_CNFG_0_NACK_SHIFT)
#define I2C_I2C_SL_CNFG_0_NACK_RANGE                    1:1
#define I2C_I2C_SL_CNFG_0_NACK_WOFFSET                  0x0
#define I2C_I2C_SL_CNFG_0_NACK_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_NACK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_CNFG_0_NACK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_NACK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_NACK_DISABLE                  _MK_ENUM_CONST(0)
#define I2C_I2C_SL_CNFG_0_NACK_ENABLE                   _MK_ENUM_CONST(1)

// Enable Slave response to general call address (zero 
// address) when bit is set to 1.
#define I2C_I2C_SL_CNFG_0_RESP_SHIFT                    _MK_SHIFT_CONST(0)
#define I2C_I2C_SL_CNFG_0_RESP_FIELD                    (_MK_MASK_CONST(0x1) << I2C_I2C_SL_CNFG_0_RESP_SHIFT)
#define I2C_I2C_SL_CNFG_0_RESP_RANGE                    0:0
#define I2C_I2C_SL_CNFG_0_RESP_WOFFSET                  0x0
#define I2C_I2C_SL_CNFG_0_RESP_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_RESP_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_CNFG_0_RESP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_RESP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_RESP_DISABLE                  _MK_ENUM_CONST(0)
#define I2C_I2C_SL_CNFG_0_RESP_ENABLE                   _MK_ENUM_CONST(1)

//IC Controller Slave Receive/Transmit Data (Slave)

// Register I2C_I2C_SL_RCVD_0  
#define I2C_I2C_SL_RCVD_0                       _MK_ADDR_CONST(0x24)
#define I2C_I2C_SL_RCVD_0_WORD_COUNT                    0x1
#define I2C_I2C_SL_RCVD_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_RCVD_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_SL_RCVD_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_RCVD_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_RCVD_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_SL_RCVD_0_WRITE_MASK                    _MK_MASK_CONST(0xff)
// Reserved = 0
#define I2C_I2C_SL_RCVD_0_N_A6_SHIFT                    _MK_SHIFT_CONST(8)
#define I2C_I2C_SL_RCVD_0_N_A6_FIELD                    (_MK_MASK_CONST(0xffffff) << I2C_I2C_SL_RCVD_0_N_A6_SHIFT)
#define I2C_I2C_SL_RCVD_0_N_A6_RANGE                    31:8
#define I2C_I2C_SL_RCVD_0_N_A6_WOFFSET                  0x0
#define I2C_I2C_SL_RCVD_0_N_A6_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_RCVD_0_N_A6_DEFAULT_MASK                     _MK_MASK_CONST(0xffffff)
#define I2C_I2C_SL_RCVD_0_N_A6_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_RCVD_0_N_A6_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//slave Received data 
#define I2C_I2C_SL_RCVD_0_SL_DATA_SHIFT                 _MK_SHIFT_CONST(0)
#define I2C_I2C_SL_RCVD_0_SL_DATA_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_SL_RCVD_0_SL_DATA_SHIFT)
#define I2C_I2C_SL_RCVD_0_SL_DATA_RANGE                 7:0
#define I2C_I2C_SL_RCVD_0_SL_DATA_WOFFSET                       0x0
#define I2C_I2C_SL_RCVD_0_SL_DATA_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_RCVD_0_SL_DATA_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_SL_RCVD_0_SL_DATA_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_RCVD_0_SL_DATA_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//IC Controller Slave Status (Slave)

// Register I2C_I2C_SL_STATUS_0  
#define I2C_I2C_SL_STATUS_0                     _MK_ADDR_CONST(0x28)
#define I2C_I2C_SL_STATUS_0_WORD_COUNT                  0x1
#define I2C_I2C_SL_STATUS_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_SL_STATUS_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_SL_STATUS_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Reserved = 0
#define I2C_I2C_SL_STATUS_0_N_A7_SHIFT                  _MK_SHIFT_CONST(4)
#define I2C_I2C_SL_STATUS_0_N_A7_FIELD                  (_MK_MASK_CONST(0xfffffff) << I2C_I2C_SL_STATUS_0_N_A7_SHIFT)
#define I2C_I2C_SL_STATUS_0_N_A7_RANGE                  31:4
#define I2C_I2C_SL_STATUS_0_N_A7_WOFFSET                        0x0
#define I2C_I2C_SL_STATUS_0_N_A7_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_N_A7_DEFAULT_MASK                   _MK_MASK_CONST(0xfffffff)
#define I2C_I2C_SL_STATUS_0_N_A7_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_N_A7_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// 1 = Interrupt has been generated by  slave 
// 0 = No interrupt generated  
#define I2C_I2C_SL_STATUS_0_SL_IRQ_SHIFT                        _MK_SHIFT_CONST(3)
#define I2C_I2C_SL_STATUS_0_SL_IRQ_FIELD                        (_MK_MASK_CONST(0x1) << I2C_I2C_SL_STATUS_0_SL_IRQ_SHIFT)
#define I2C_I2C_SL_STATUS_0_SL_IRQ_RANGE                        3:3
#define I2C_I2C_SL_STATUS_0_SL_IRQ_WOFFSET                      0x0
#define I2C_I2C_SL_STATUS_0_SL_IRQ_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_SL_IRQ_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_STATUS_0_SL_IRQ_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_SL_IRQ_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_SL_IRQ_UNSET                        _MK_ENUM_CONST(0)
#define I2C_I2C_SL_STATUS_0_SL_IRQ_SET                  _MK_ENUM_CONST(1)

// New Transaction Receieved status 
// 1 = Transaction occurred
// 0 = No transaction occurred 
#define I2C_I2C_SL_STATUS_0_RCVD_SHIFT                  _MK_SHIFT_CONST(2)
#define I2C_I2C_SL_STATUS_0_RCVD_FIELD                  (_MK_MASK_CONST(0x1) << I2C_I2C_SL_STATUS_0_RCVD_SHIFT)
#define I2C_I2C_SL_STATUS_0_RCVD_RANGE                  2:2
#define I2C_I2C_SL_STATUS_0_RCVD_WOFFSET                        0x0
#define I2C_I2C_SL_STATUS_0_RCVD_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_RCVD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_STATUS_0_RCVD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_RCVD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_RCVD_NO_TRANSACTION_OCCURED                 _MK_ENUM_CONST(0)
#define I2C_I2C_SL_STATUS_0_RCVD_TRANSACTION_OCCURED                    _MK_ENUM_CONST(1)

// Slave Transaction status 0 = Write 1=Read
#define I2C_I2C_SL_STATUS_0_RNW_SHIFT                   _MK_SHIFT_CONST(1)
#define I2C_I2C_SL_STATUS_0_RNW_FIELD                   (_MK_MASK_CONST(0x1) << I2C_I2C_SL_STATUS_0_RNW_SHIFT)
#define I2C_I2C_SL_STATUS_0_RNW_RANGE                   1:1
#define I2C_I2C_SL_STATUS_0_RNW_WOFFSET                 0x0
#define I2C_I2C_SL_STATUS_0_RNW_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_RNW_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_STATUS_0_RNW_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_RNW_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_RNW_WRITE                   _MK_ENUM_CONST(0)
#define I2C_I2C_SL_STATUS_0_RNW_READ                    _MK_ENUM_CONST(1)

// Zero Address Status 1 = Yes, slave responded  0  = No,
// slave did not respond
#define I2C_I2C_SL_STATUS_0_ZA_SHIFT                    _MK_SHIFT_CONST(0)
#define I2C_I2C_SL_STATUS_0_ZA_FIELD                    (_MK_MASK_CONST(0x1) << I2C_I2C_SL_STATUS_0_ZA_SHIFT)
#define I2C_I2C_SL_STATUS_0_ZA_RANGE                    0:0
#define I2C_I2C_SL_STATUS_0_ZA_WOFFSET                  0x0
#define I2C_I2C_SL_STATUS_0_ZA_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_ZA_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_STATUS_0_ZA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_ZA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_ZA_NO_SLAVE_RESPONSE                        _MK_ENUM_CONST(0)
#define I2C_I2C_SL_STATUS_0_ZA_SLAVE_RESPONSE                   _MK_ENUM_CONST(1)

//IC Controller Slave Address 1 Register (Slave)

// Register I2C_I2C_SL_ADDR1_0  
#define I2C_I2C_SL_ADDR1_0                      _MK_ADDR_CONST(0x2c)
#define I2C_I2C_SL_ADDR1_0_WORD_COUNT                   0x1
#define I2C_I2C_SL_ADDR1_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR1_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_SL_ADDR1_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR1_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR1_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_SL_ADDR1_0_WRITE_MASK                   _MK_MASK_CONST(0xff)
// Reserved = 0
#define I2C_I2C_SL_ADDR1_0_N_A8_SHIFT                   _MK_SHIFT_CONST(8)
#define I2C_I2C_SL_ADDR1_0_N_A8_FIELD                   (_MK_MASK_CONST(0xffffff) << I2C_I2C_SL_ADDR1_0_N_A8_SHIFT)
#define I2C_I2C_SL_ADDR1_0_N_A8_RANGE                   31:8
#define I2C_I2C_SL_ADDR1_0_N_A8_WOFFSET                 0x0
#define I2C_I2C_SL_ADDR1_0_N_A8_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR1_0_N_A8_DEFAULT_MASK                    _MK_MASK_CONST(0xffffff)
#define I2C_I2C_SL_ADDR1_0_N_A8_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR1_0_N_A8_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// For a 10-bit slave address, this field is the 
// least significant 8 bits. 
#define I2C_I2C_SL_ADDR1_0_SL_ADDR0_SHIFT                       _MK_SHIFT_CONST(0)
#define I2C_I2C_SL_ADDR1_0_SL_ADDR0_FIELD                       (_MK_MASK_CONST(0xff) << I2C_I2C_SL_ADDR1_0_SL_ADDR0_SHIFT)
#define I2C_I2C_SL_ADDR1_0_SL_ADDR0_RANGE                       7:0
#define I2C_I2C_SL_ADDR1_0_SL_ADDR0_WOFFSET                     0x0
#define I2C_I2C_SL_ADDR1_0_SL_ADDR0_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR1_0_SL_ADDR0_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define I2C_I2C_SL_ADDR1_0_SL_ADDR0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR1_0_SL_ADDR0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//IC Controller Slave Address 2 Register (Slave)

// Register I2C_I2C_SL_ADDR2_0  
#define I2C_I2C_SL_ADDR2_0                      _MK_ADDR_CONST(0x30)
#define I2C_I2C_SL_ADDR2_0_WORD_COUNT                   0x1
#define I2C_I2C_SL_ADDR2_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_SL_ADDR2_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_SL_ADDR2_0_WRITE_MASK                   _MK_MASK_CONST(0x7)
// Reserved = 0
#define I2C_I2C_SL_ADDR2_0_N_A9_SHIFT                   _MK_SHIFT_CONST(3)
#define I2C_I2C_SL_ADDR2_0_N_A9_FIELD                   (_MK_MASK_CONST(0x1fffffff) << I2C_I2C_SL_ADDR2_0_N_A9_SHIFT)
#define I2C_I2C_SL_ADDR2_0_N_A9_RANGE                   31:3
#define I2C_I2C_SL_ADDR2_0_N_A9_WOFFSET                 0x0
#define I2C_I2C_SL_ADDR2_0_N_A9_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_N_A9_DEFAULT_MASK                    _MK_MASK_CONST(0x1fffffff)
#define I2C_I2C_SL_ADDR2_0_N_A9_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_N_A9_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// In 7 bit address mode these bits are dont care;
// In 10 bit address mode they represent the 2 MSB of the
// address.
#define I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_SHIFT                     _MK_SHIFT_CONST(1)
#define I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_FIELD                     (_MK_MASK_CONST(0x3) << I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_SHIFT)
#define I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_RANGE                     2:1
#define I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_WOFFSET                   0x0
#define I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//0 = 7-bit addressing,                                                                                                 // 1 - 10 bit addressing
#define I2C_I2C_SL_ADDR2_0_VLD_SHIFT                    _MK_SHIFT_CONST(0)
#define I2C_I2C_SL_ADDR2_0_VLD_FIELD                    (_MK_MASK_CONST(0x1) << I2C_I2C_SL_ADDR2_0_VLD_SHIFT)
#define I2C_I2C_SL_ADDR2_0_VLD_RANGE                    0:0
#define I2C_I2C_SL_ADDR2_0_VLD_WOFFSET                  0x0
#define I2C_I2C_SL_ADDR2_0_VLD_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_VLD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_ADDR2_0_VLD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_VLD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_VLD_SEVEN_BIT_ADDR_MODE                      _MK_ENUM_CONST(0)
#define I2C_I2C_SL_ADDR2_0_VLD_TEN_BIT_ADDR_MODE                        _MK_ENUM_CONST(1)


// Reserved address 52 [0x34] 

// Reserved address 56 [0x38] 
//IC Slave Controller Delay Count

// Register I2C_I2C_SL_DELAY_COUNT_0  
#define I2C_I2C_SL_DELAY_COUNT_0                        _MK_ADDR_CONST(0x3c)
#define I2C_I2C_SL_DELAY_COUNT_0_WORD_COUNT                     0x1
#define I2C_I2C_SL_DELAY_COUNT_0_RESET_VAL                      _MK_MASK_CONST(0x1e)
#define I2C_I2C_SL_DELAY_COUNT_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_SL_DELAY_COUNT_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_DELAY_COUNT_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_DELAY_COUNT_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_SL_DELAY_COUNT_0_WRITE_MASK                     _MK_MASK_CONST(0xff)
// Reserved = 0
#define I2C_I2C_SL_DELAY_COUNT_0_N_A10_SHIFT                    _MK_SHIFT_CONST(8)
#define I2C_I2C_SL_DELAY_COUNT_0_N_A10_FIELD                    (_MK_MASK_CONST(0xffffff) << I2C_I2C_SL_DELAY_COUNT_0_N_A10_SHIFT)
#define I2C_I2C_SL_DELAY_COUNT_0_N_A10_RANGE                    31:8
#define I2C_I2C_SL_DELAY_COUNT_0_N_A10_WOFFSET                  0x0
#define I2C_I2C_SL_DELAY_COUNT_0_N_A10_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_DELAY_COUNT_0_N_A10_DEFAULT_MASK                     _MK_MASK_CONST(0xffffff)
#define I2C_I2C_SL_DELAY_COUNT_0_N_A10_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_DELAY_COUNT_0_N_A10_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// The value determines the timing  between an address 
// cycle and a subsequent data cycle or two consecutive 
// data  cycles on the bus.The I2C_SL_DELAY_COUNT is valid
// only when internal slave is accessed.
// I2C_SL_DELAY_COUNT has to be programmed such that 
// TIMING = T * DLY where T is period of clock source
// selected for I2c; and DLY is I2C_SL_DELAY_COUNT ;
// TIMING is the desired timing, A value of >= 1250 ns is
// advisable
#define I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_SHIFT                   _MK_SHIFT_CONST(0)
#define I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_FIELD                   (_MK_MASK_CONST(0xff) << I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_SHIFT)
#define I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_RANGE                   7:0
#define I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_WOFFSET                 0x0
#define I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_DEFAULT                 _MK_MASK_CONST(0x1e)
#define I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_ARI2C_REGS(_op_) \
_op_(I2C_I2C_CNFG_0) \
_op_(I2C_I2C_CMD_ADDR0_0) \
_op_(I2C_I2C_CMD_ADDR1_0) \
_op_(I2C_I2C_CMD_DATA1_0) \
_op_(I2C_I2C_CMD_DATA2_0) \
_op_(I2C_I2C_STATUS_0) \
_op_(I2C_I2C_SL_CNFG_0) \
_op_(I2C_I2C_SL_RCVD_0) \
_op_(I2C_I2C_SL_STATUS_0) \
_op_(I2C_I2C_SL_ADDR1_0) \
_op_(I2C_I2C_SL_ADDR2_0) \
_op_(I2C_I2C_SL_DELAY_COUNT_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_I2C        0x00000000

//
// ARI2C REGISTER BANKS
//

#define I2C0_FIRST_REG 0x0000 // I2C_I2C_CNFG_0
#define I2C0_LAST_REG 0x0010 // I2C_I2C_CMD_DATA2_0
#define I2C1_FIRST_REG 0x001c // I2C_I2C_STATUS_0
#define I2C1_LAST_REG 0x0030 // I2C_I2C_SL_ADDR2_0
#define I2C2_FIRST_REG 0x003c // I2C_I2C_SL_DELAY_COUNT_0
#define I2C2_LAST_REG 0x003c // I2C_I2C_SL_DELAY_COUNT_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARI2C_H_INC_
