/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARAPB_MISC_H_INC_
#define ___ARAPB_MISC_H_INC_

// Reserved address 0 [0x0] 

// Reserved address 4 [0x4] 

// Register APB_MISC_PP_STRAPPING_OPT_A_0  
#define APB_MISC_PP_STRAPPING_OPT_A_0                   _MK_ADDR_CONST(0x8)
#define APB_MISC_PP_STRAPPING_OPT_A_0_WORD_COUNT                        0x1
#define APB_MISC_PP_STRAPPING_OPT_A_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_RESET_MASK                        _MK_MASK_CONST(0x101)
#define APB_MISC_PP_STRAPPING_OPT_A_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_READ_MASK                         _MK_MASK_CONST(0x1c001f1)
#define APB_MISC_PP_STRAPPING_OPT_A_0_WRITE_MASK                        _MK_MASK_CONST(0x1c001f1)
// read at power-on reset time from hsmmc_wp strap pad
// note that BOOT_SRC is only valid in pre-production mode
#define APB_MISC_PP_STRAPPING_OPT_A_0_BOOT_SRC_USB_RECOVERY_MODE_SHIFT                  _MK_SHIFT_CONST(24)
#define APB_MISC_PP_STRAPPING_OPT_A_0_BOOT_SRC_USB_RECOVERY_MODE_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_PP_STRAPPING_OPT_A_0_BOOT_SRC_USB_RECOVERY_MODE_SHIFT)
#define APB_MISC_PP_STRAPPING_OPT_A_0_BOOT_SRC_USB_RECOVERY_MODE_RANGE                  24:24
#define APB_MISC_PP_STRAPPING_OPT_A_0_BOOT_SRC_USB_RECOVERY_MODE_WOFFSET                        0x0
#define APB_MISC_PP_STRAPPING_OPT_A_0_BOOT_SRC_USB_RECOVERY_MODE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_BOOT_SRC_USB_RECOVERY_MODE_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_BOOT_SRC_USB_RECOVERY_MODE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_BOOT_SRC_USB_RECOVERY_MODE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_BOOT_SRC_USB_RECOVERY_MODE_IROM                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_BOOT_SRC_USB_RECOVERY_MODE_NOR                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_STRAPPING_OPT_A_0_BOOT_SRC_USB_RECOVERY_MODE_DISABLE                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_BOOT_SRC_USB_RECOVERY_MODE_ENABLE                 _MK_ENUM_CONST(1)
#define APB_MISC_PP_STRAPPING_OPT_A_0_BOOT_SRC_USB_RECOVERY_MODE_DISABLED                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_BOOT_SRC_USB_RECOVERY_MODE_ENABLED                        _MK_ENUM_CONST(1)

// read at power-on reset time from {nand_cle,nand_ale} strap pads 00=Serial_JTAG, 01=CPU_only, 10=COP_only, 11=Serial_JTAG(same as 00 case)
#define APB_MISC_PP_STRAPPING_OPT_A_0_ARM_JTAG_SHIFT                    _MK_SHIFT_CONST(22)
#define APB_MISC_PP_STRAPPING_OPT_A_0_ARM_JTAG_FIELD                    (_MK_MASK_CONST(0x3) << APB_MISC_PP_STRAPPING_OPT_A_0_ARM_JTAG_SHIFT)
#define APB_MISC_PP_STRAPPING_OPT_A_0_ARM_JTAG_RANGE                    23:22
#define APB_MISC_PP_STRAPPING_OPT_A_0_ARM_JTAG_WOFFSET                  0x0
#define APB_MISC_PP_STRAPPING_OPT_A_0_ARM_JTAG_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_ARM_JTAG_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_ARM_JTAG_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_ARM_JTAG_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_ARM_JTAG_SERIAL                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_ARM_JTAG_CPU                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_STRAPPING_OPT_A_0_ARM_JTAG_COP                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_STRAPPING_OPT_A_0_ARM_JTAG_SERIAL_ALT                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_STRAPPING_OPT_A_0_MIO_WIDTH_SHIFT                   _MK_SHIFT_CONST(8)
#define APB_MISC_PP_STRAPPING_OPT_A_0_MIO_WIDTH_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_STRAPPING_OPT_A_0_MIO_WIDTH_SHIFT)
#define APB_MISC_PP_STRAPPING_OPT_A_0_MIO_WIDTH_RANGE                   8:8
#define APB_MISC_PP_STRAPPING_OPT_A_0_MIO_WIDTH_WOFFSET                 0x0
#define APB_MISC_PP_STRAPPING_OPT_A_0_MIO_WIDTH_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_MIO_WIDTH_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_STRAPPING_OPT_A_0_MIO_WIDTH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_MIO_WIDTH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_MIO_WIDTH_INIT_ENUM                       IS16BIT
#define APB_MISC_PP_STRAPPING_OPT_A_0_MIO_WIDTH_IS16BIT                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_MIO_WIDTH_IS32BIT                 _MK_ENUM_CONST(1)

// read at power-on reset time from nand_d[3:0] strap pads
#define APB_MISC_PP_STRAPPING_OPT_A_0_RAM_CODE_SHIFT                    _MK_SHIFT_CONST(4)
#define APB_MISC_PP_STRAPPING_OPT_A_0_RAM_CODE_FIELD                    (_MK_MASK_CONST(0xf) << APB_MISC_PP_STRAPPING_OPT_A_0_RAM_CODE_SHIFT)
#define APB_MISC_PP_STRAPPING_OPT_A_0_RAM_CODE_RANGE                    7:4
#define APB_MISC_PP_STRAPPING_OPT_A_0_RAM_CODE_WOFFSET                  0x0
#define APB_MISC_PP_STRAPPING_OPT_A_0_RAM_CODE_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_RAM_CODE_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_RAM_CODE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_RAM_CODE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_PP_STRAPPING_OPT_A_0_NOR_WIDTH_SHIFT                   _MK_SHIFT_CONST(0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_NOR_WIDTH_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_STRAPPING_OPT_A_0_NOR_WIDTH_SHIFT)
#define APB_MISC_PP_STRAPPING_OPT_A_0_NOR_WIDTH_RANGE                   0:0
#define APB_MISC_PP_STRAPPING_OPT_A_0_NOR_WIDTH_WOFFSET                 0x0
#define APB_MISC_PP_STRAPPING_OPT_A_0_NOR_WIDTH_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_NOR_WIDTH_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_STRAPPING_OPT_A_0_NOR_WIDTH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_NOR_WIDTH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_NOR_WIDTH_INIT_ENUM                       IS16BIT
#define APB_MISC_PP_STRAPPING_OPT_A_0_NOR_WIDTH_IS16BIT                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_STRAPPING_OPT_A_0_NOR_WIDTH_IS8BIT                  _MK_ENUM_CONST(1)


// Reserved address 12 [0xc] 

// Reserved address 16 [0x10] 

// Register APB_MISC_PP_TRISTATE_REG_A_0  
#define APB_MISC_PP_TRISTATE_REG_A_0                    _MK_ADDR_CONST(0x14)
#define APB_MISC_PP_TRISTATE_REG_A_0_WORD_COUNT                         0x1
#define APB_MISC_PP_TRISTATE_REG_A_0_RESET_VAL                  _MK_MASK_CONST(0x11bffff)
#define APB_MISC_PP_TRISTATE_REG_A_0_RESET_MASK                         _MK_MASK_CONST(0xfffffff)
#define APB_MISC_PP_TRISTATE_REG_A_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_READ_MASK                  _MK_MASK_CONST(0xfffffff)
#define APB_MISC_PP_TRISTATE_REG_A_0_WRITE_MASK                         _MK_MASK_CONST(0xfffffff)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCF_SHIFT                       _MK_SHIFT_CONST(27)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCF_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCF_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCF_RANGE                       27:27
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCF_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCF_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCF_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCF_INIT_ENUM                   NORMAL
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCF_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCF_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCE_SHIFT                       _MK_SHIFT_CONST(26)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCE_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCE_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCE_RANGE                       26:26
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCE_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCE_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCE_INIT_ENUM                   NORMAL
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCE_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCE_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_RM_SHIFT                 _MK_SHIFT_CONST(25)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_RM_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_RM_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_RM_RANGE                 25:25
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_RM_WOFFSET                       0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_RM_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_RM_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_RM_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_RM_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_RM_INIT_ENUM                     NORMAL
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_RM_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_RM_TRISTATE                      _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PTA_SHIFT                        _MK_SHIFT_CONST(24)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PTA_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_PTA_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PTA_RANGE                        24:24
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PTA_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PTA_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PTA_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PTA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PTA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PTA_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PTA_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PTA_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PMC_SHIFT                        _MK_SHIFT_CONST(23)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PMC_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_PMC_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PMC_RANGE                        23:23
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PMC_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PMC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PMC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PMC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PMC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PMC_INIT_ENUM                    NORMAL
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PMC_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_PMC_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCA_SHIFT                       _MK_SHIFT_CONST(22)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCA_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCA_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCA_RANGE                       22:22
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCA_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCA_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCA_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCA_INIT_ENUM                   NORMAL
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCA_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCA_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCB_SHIFT                       _MK_SHIFT_CONST(21)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCB_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCB_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCB_RANGE                       21:21
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCB_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCB_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCB_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCB_INIT_ENUM                   NORMAL
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCB_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_KBCB_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRRX_SHIFT                       _MK_SHIFT_CONST(20)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRRX_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_IRRX_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRRX_RANGE                       20:20
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRRX_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRRX_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRRX_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRRX_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRRX_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRRX_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRRX_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRRX_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRTX_SHIFT                       _MK_SHIFT_CONST(19)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRTX_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_IRTX_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRTX_RANGE                       19:19
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRTX_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRTX_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRTX_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRTX_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRTX_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRTX_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRTX_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_IRTX_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_I2CP_SHIFT                       _MK_SHIFT_CONST(18)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_I2CP_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_I2CP_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_I2CP_RANGE                       18:18
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_I2CP_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_I2CP_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_I2CP_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_I2CP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_I2CP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_I2CP_INIT_ENUM                   NORMAL
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_I2CP_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_I2CP_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPV_SHIFT                        _MK_SHIFT_CONST(17)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPV_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_GPV_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPV_RANGE                        17:17
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPV_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPV_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPV_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPV_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPV_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPV_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPV_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPV_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPU_SHIFT                        _MK_SHIFT_CONST(16)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPU_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_GPU_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPU_RANGE                        16:16
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPU_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPU_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPU_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPU_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPU_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPU_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPU_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_GPU_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTE_SHIFT                        _MK_SHIFT_CONST(15)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTE_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_DTE_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTE_RANGE                        15:15
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTE_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTE_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTE_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTE_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTE_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTD_SHIFT                        _MK_SHIFT_CONST(14)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTD_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_DTD_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTD_RANGE                        14:14
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTD_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTD_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTD_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTD_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTD_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTD_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTC_SHIFT                        _MK_SHIFT_CONST(13)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTC_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_DTC_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTC_RANGE                        13:13
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTC_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTC_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTC_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTC_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTC_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTB_SHIFT                        _MK_SHIFT_CONST(12)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTB_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_DTB_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTB_RANGE                        12:12
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTB_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTB_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTB_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTB_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTB_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTB_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTA_SHIFT                        _MK_SHIFT_CONST(11)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTA_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_DTA_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTA_RANGE                        11:11
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTA_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTA_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTA_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTA_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTA_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DTA_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP4_SHIFT                       _MK_SHIFT_CONST(10)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP4_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP4_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP4_RANGE                       10:10
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP4_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP4_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP4_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP4_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP4_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP4_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP4_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP4_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP3_SHIFT                       _MK_SHIFT_CONST(9)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP3_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP3_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP3_RANGE                       9:9
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP3_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP3_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP3_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP3_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP3_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP3_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP3_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP3_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP2_SHIFT                       _MK_SHIFT_CONST(8)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP2_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP2_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP2_RANGE                       8:8
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP2_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP2_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP2_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP2_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP2_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP1_SHIFT                       _MK_SHIFT_CONST(7)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP1_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP1_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP1_RANGE                       7:7
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP1_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP1_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP1_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP1_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_DAP1_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CSUS_SHIFT                       _MK_SHIFT_CONST(6)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CSUS_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_CSUS_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CSUS_RANGE                       6:6
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CSUS_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CSUS_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CSUS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CSUS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CSUS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CSUS_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CSUS_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CSUS_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV2_SHIFT                      _MK_SHIFT_CONST(5)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV2_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV2_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV2_RANGE                      5:5
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV2_WOFFSET                    0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV2_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV2_INIT_ENUM                  TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV2_NORMAL                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV2_TRISTATE                   _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV1_SHIFT                      _MK_SHIFT_CONST(4)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV1_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV1_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV1_RANGE                      4:4
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV1_WOFFSET                    0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV1_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV1_INIT_ENUM                  TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV1_NORMAL                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_CDEV1_TRISTATE                   _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATD_SHIFT                        _MK_SHIFT_CONST(3)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATD_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_ATD_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATD_RANGE                        3:3
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATD_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATD_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATD_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATD_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATD_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATD_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATC_SHIFT                        _MK_SHIFT_CONST(2)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATC_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_ATC_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATC_RANGE                        2:2
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATC_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATC_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATC_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATC_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATC_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATB_SHIFT                        _MK_SHIFT_CONST(1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATB_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_ATB_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATB_RANGE                        1:1
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATB_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATB_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATB_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATB_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATB_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATB_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATA_SHIFT                        _MK_SHIFT_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATA_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_A_0_Z_ATA_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATA_RANGE                        0:0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATA_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATA_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATA_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATA_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATA_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_A_0_Z_ATA_TRISTATE                     _MK_ENUM_CONST(1)


// Register APB_MISC_PP_TRISTATE_REG_B_0  
#define APB_MISC_PP_TRISTATE_REG_B_0                    _MK_ADDR_CONST(0x18)
#define APB_MISC_PP_TRISTATE_REG_B_0_WORD_COUNT                         0x1
#define APB_MISC_PP_TRISTATE_REG_B_0_RESET_VAL                  _MK_MASK_CONST(0x2ffffff)
#define APB_MISC_PP_TRISTATE_REG_B_0_RESET_MASK                         _MK_MASK_CONST(0x3effffff)
#define APB_MISC_PP_TRISTATE_REG_B_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_READ_MASK                  _MK_MASK_CONST(0x3effffff)
#define APB_MISC_PP_TRISTATE_REG_B_0_WRITE_MASK                         _MK_MASK_CONST(0x3effffff)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2S_SHIFT                       _MK_SHIFT_CONST(29)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2S_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2S_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2S_RANGE                       29:29
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2S_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2S_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2S_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2S_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2S_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2S_INIT_ENUM                   NORMAL
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2S_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2S_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2C_SHIFT                       _MK_SHIFT_CONST(28)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2C_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2C_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2C_RANGE                       28:28
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2C_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2C_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2C_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2C_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2C_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2C_INIT_ENUM                   NORMAL
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2C_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2C_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2A_SHIFT                       _MK_SHIFT_CONST(27)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2A_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2A_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2A_RANGE                       27:27
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2A_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2A_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2A_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2A_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2A_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2A_INIT_ENUM                   NORMAL
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2A_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_XM2A_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_KBCC_SHIFT                       _MK_SHIFT_CONST(26)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_KBCC_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_KBCC_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_KBCC_RANGE                       26:26
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_KBCC_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_KBCC_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_KBCC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_KBCC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_KBCC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_KBCC_INIT_ENUM                   NORMAL
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_KBCC_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_KBCC_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_ATE_SHIFT                        _MK_SHIFT_CONST(25)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_ATE_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_ATE_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_ATE_RANGE                        25:25
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_ATE_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_ATE_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_ATE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_ATE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_ATE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_ATE_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_ATE_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_ATE_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCB_SHIFT                        _MK_SHIFT_CONST(23)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCB_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_UCB_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCB_RANGE                        23:23
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCB_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCB_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCB_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCB_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCB_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCB_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCA_SHIFT                        _MK_SHIFT_CONST(22)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCA_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_UCA_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCA_RANGE                        22:22
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCA_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCA_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCA_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCA_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCA_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UCA_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAD_SHIFT                        _MK_SHIFT_CONST(21)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAD_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_UAD_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAD_RANGE                        21:21
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAD_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAD_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAD_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAD_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAD_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAD_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAC_SHIFT                        _MK_SHIFT_CONST(20)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAC_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_UAC_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAC_RANGE                        20:20
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAC_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAC_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAC_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAC_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAC_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAB_SHIFT                        _MK_SHIFT_CONST(19)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAB_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_UAB_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAB_RANGE                        19:19
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAB_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAB_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAB_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAB_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAB_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAB_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAA_SHIFT                        _MK_SHIFT_CONST(18)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAA_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_UAA_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAA_RANGE                        18:18
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAA_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAA_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAA_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAA_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAA_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_UAA_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIH_SHIFT                       _MK_SHIFT_CONST(17)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIH_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIH_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIH_RANGE                       17:17
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIH_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIH_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIH_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIH_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIH_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIH_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIG_SHIFT                       _MK_SHIFT_CONST(16)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIG_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIG_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIG_RANGE                       16:16
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIG_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIG_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIG_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIG_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIG_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIG_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIG_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIG_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIF_SHIFT                       _MK_SHIFT_CONST(15)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIF_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIF_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIF_RANGE                       15:15
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIF_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIF_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIF_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIF_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIF_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIF_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIE_SHIFT                       _MK_SHIFT_CONST(14)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIE_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIE_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIE_RANGE                       14:14
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIE_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIE_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIE_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIE_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIE_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPID_SHIFT                       _MK_SHIFT_CONST(13)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPID_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SPID_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPID_RANGE                       13:13
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPID_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPID_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPID_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPID_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPID_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPID_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPID_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPID_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIC_SHIFT                       _MK_SHIFT_CONST(12)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIC_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIC_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIC_RANGE                       12:12
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIC_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIC_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIC_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIC_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIC_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIB_SHIFT                       _MK_SHIFT_CONST(11)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIB_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIB_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIB_RANGE                       11:11
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIB_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIB_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIB_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIB_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIB_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIB_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIA_SHIFT                       _MK_SHIFT_CONST(10)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIA_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIA_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIA_RANGE                       10:10
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIA_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIA_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIA_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIA_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIA_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPIA_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDO_SHIFT                       _MK_SHIFT_CONST(9)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDO_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDO_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDO_RANGE                       9:9
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDO_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDO_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDO_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDO_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDO_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDO_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDO_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDO_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDI_SHIFT                       _MK_SHIFT_CONST(8)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDI_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDI_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDI_RANGE                       8:8
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDI_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDI_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDI_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDI_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDI_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDI_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDI_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SPDI_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXK_SHIFT                       _MK_SHIFT_CONST(7)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXK_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXK_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXK_RANGE                       7:7
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXK_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXK_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXK_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXK_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXK_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXD_SHIFT                       _MK_SHIFT_CONST(6)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXD_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXD_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXD_RANGE                       6:6
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXD_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXD_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXD_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXD_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXD_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXD_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXC_SHIFT                       _MK_SHIFT_CONST(5)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXC_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXC_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXC_RANGE                       5:5
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXC_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXC_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXC_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXC_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXC_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXB_SHIFT                       _MK_SHIFT_CONST(4)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXB_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXB_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXB_RANGE                       4:4
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXB_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXB_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXB_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXB_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXB_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXB_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXA_SHIFT                       _MK_SHIFT_CONST(3)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXA_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXA_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXA_RANGE                       3:3
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXA_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXA_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXA_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXA_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXA_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SLXA_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDD_SHIFT                        _MK_SHIFT_CONST(2)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDD_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SDD_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDD_RANGE                        2:2
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDD_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDD_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDD_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDD_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDD_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDD_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDC_SHIFT                        _MK_SHIFT_CONST(1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDC_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SDC_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDC_RANGE                        1:1
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDC_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDC_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDC_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDC_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDC_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDB_SHIFT                        _MK_SHIFT_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDB_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_B_0_Z_SDB_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDB_RANGE                        0:0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDB_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDB_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDB_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDB_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDB_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_B_0_Z_SDB_TRISTATE                     _MK_ENUM_CONST(1)


// Register APB_MISC_PP_TRISTATE_REG_C_0  
#define APB_MISC_PP_TRISTATE_REG_C_0                    _MK_ADDR_CONST(0x1c)
#define APB_MISC_PP_TRISTATE_REG_C_0_WORD_COUNT                         0x1
#define APB_MISC_PP_TRISTATE_REG_C_0_RESET_VAL                  _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_TRISTATE_REG_C_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_TRISTATE_REG_C_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_TRISTATE_REG_C_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LCSN_SHIFT                       _MK_SHIFT_CONST(31)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LCSN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LCSN_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LCSN_RANGE                       31:31
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LCSN_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LCSN_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LCSN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LCSN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LCSN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LCSN_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LCSN_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LCSN_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LDC_SHIFT                        _MK_SHIFT_CONST(30)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LDC_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LDC_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LDC_RANGE                        30:30
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LDC_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LDC_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LDC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LDC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LDC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LDC_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LDC_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LDC_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSCK_SHIFT                       _MK_SHIFT_CONST(29)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSCK_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LSCK_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSCK_RANGE                       29:29
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSCK_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSCK_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSCK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSCK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSCK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSCK_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSCK_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSCK_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC1_SHIFT                       _MK_SHIFT_CONST(28)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC1_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC1_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC1_RANGE                       28:28
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC1_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC1_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC1_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC1_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC1_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC0_SHIFT                       _MK_SHIFT_CONST(27)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC0_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC0_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC0_RANGE                       27:27
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC0_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC0_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC0_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC0_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LSC0_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVS_SHIFT                        _MK_SHIFT_CONST(26)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVS_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LVS_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVS_RANGE                        26:26
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVS_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVS_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVS_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVS_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVS_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM1_SHIFT                        _MK_SHIFT_CONST(25)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM1_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LM1_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM1_RANGE                        25:25
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM1_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM1_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM1_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM1_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM1_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM1_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM0_SHIFT                        _MK_SHIFT_CONST(24)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM0_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LM0_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM0_RANGE                        24:24
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM0_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM0_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM0_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM0_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM0_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LM0_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_HDINT_SHIFT                      _MK_SHIFT_CONST(23)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_HDINT_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_HDINT_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_HDINT_RANGE                      23:23
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_HDINT_WOFFSET                    0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_HDINT_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_HDINT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_HDINT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_HDINT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_HDINT_INIT_ENUM                  TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_HDINT_NORMAL                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_HDINT_TRISTATE                   _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP1_SHIFT                       _MK_SHIFT_CONST(22)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP1_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP1_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP1_RANGE                       22:22
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP1_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP1_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP1_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP1_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP1_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP0_SHIFT                       _MK_SHIFT_CONST(21)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP0_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP0_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP0_RANGE                       21:21
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP0_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP0_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP0_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP0_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LVP0_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP2_SHIFT                       _MK_SHIFT_CONST(20)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP2_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP2_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP2_RANGE                       20:20
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP2_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP2_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP2_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP2_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP2_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP1_SHIFT                       _MK_SHIFT_CONST(19)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP1_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP1_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP1_RANGE                       19:19
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP1_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP1_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP1_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP1_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP1_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP0_SHIFT                       _MK_SHIFT_CONST(18)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP0_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP0_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP0_RANGE                       18:18
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP0_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP0_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP0_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP0_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LHP0_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD17_SHIFT                       _MK_SHIFT_CONST(17)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD17_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD17_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD17_RANGE                       17:17
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD17_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD17_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD17_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD17_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD17_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD17_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD17_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD17_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD16_SHIFT                       _MK_SHIFT_CONST(16)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD16_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD16_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD16_RANGE                       16:16
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD16_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD16_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD16_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD16_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD16_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD16_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD16_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD16_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD15_SHIFT                       _MK_SHIFT_CONST(15)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD15_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD15_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD15_RANGE                       15:15
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD15_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD15_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD15_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD15_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD15_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD15_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD15_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD15_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD14_SHIFT                       _MK_SHIFT_CONST(14)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD14_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD14_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD14_RANGE                       14:14
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD14_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD14_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD14_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD14_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD14_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD14_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD14_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD14_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD13_SHIFT                       _MK_SHIFT_CONST(13)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD13_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD13_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD13_RANGE                       13:13
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD13_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD13_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD13_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD13_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD13_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD13_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD13_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD13_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD12_SHIFT                       _MK_SHIFT_CONST(12)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD12_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD12_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD12_RANGE                       12:12
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD12_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD12_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD12_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD12_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD12_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD12_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD12_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD12_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD11_SHIFT                       _MK_SHIFT_CONST(11)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD11_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD11_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD11_RANGE                       11:11
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD11_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD11_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD11_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD11_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD11_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD11_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD11_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD11_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD10_SHIFT                       _MK_SHIFT_CONST(10)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD10_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD10_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD10_RANGE                       10:10
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD10_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD10_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD10_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD10_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD10_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD10_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD10_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD10_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD9_SHIFT                        _MK_SHIFT_CONST(9)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD9_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD9_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD9_RANGE                        9:9
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD9_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD9_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD9_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD9_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD9_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD9_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD9_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD9_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD8_SHIFT                        _MK_SHIFT_CONST(8)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD8_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD8_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD8_RANGE                        8:8
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD8_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD8_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD8_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD8_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD8_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD8_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD8_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD8_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD7_SHIFT                        _MK_SHIFT_CONST(7)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD7_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD7_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD7_RANGE                        7:7
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD7_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD7_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD7_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD7_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD7_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD7_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD7_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD7_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD6_SHIFT                        _MK_SHIFT_CONST(6)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD6_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD6_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD6_RANGE                        6:6
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD6_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD6_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD6_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD6_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD6_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD6_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD6_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD6_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD5_SHIFT                        _MK_SHIFT_CONST(5)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD5_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD5_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD5_RANGE                        5:5
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD5_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD5_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD5_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD5_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD5_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD5_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD5_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD5_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD4_SHIFT                        _MK_SHIFT_CONST(4)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD4_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD4_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD4_RANGE                        4:4
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD4_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD4_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD4_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD4_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD4_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD4_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD4_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD4_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD3_SHIFT                        _MK_SHIFT_CONST(3)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD3_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD3_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD3_RANGE                        3:3
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD3_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD3_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD3_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD3_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD3_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD3_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD3_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD3_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD2_SHIFT                        _MK_SHIFT_CONST(2)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD2_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD2_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD2_RANGE                        2:2
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD2_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD2_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD2_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD2_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD2_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD2_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD1_SHIFT                        _MK_SHIFT_CONST(1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD1_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD1_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD1_RANGE                        1:1
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD1_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD1_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD1_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD1_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD1_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD1_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD0_SHIFT                        _MK_SHIFT_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD0_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_C_0_Z_LD0_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD0_RANGE                        0:0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD0_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD0_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD0_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD0_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD0_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_C_0_Z_LD0_TRISTATE                     _MK_ENUM_CONST(1)


// Register APB_MISC_PP_TRISTATE_REG_D_0  
#define APB_MISC_PP_TRISTATE_REG_D_0                    _MK_ADDR_CONST(0x20)
#define APB_MISC_PP_TRISTATE_REG_D_0_WORD_COUNT                         0x1
#define APB_MISC_PP_TRISTATE_REG_D_0_RESET_VAL                  _MK_MASK_CONST(0x11ff)
#define APB_MISC_PP_TRISTATE_REG_D_0_RESET_MASK                         _MK_MASK_CONST(0x1dff)
#define APB_MISC_PP_TRISTATE_REG_D_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_READ_MASK                  _MK_MASK_CONST(0x1dff)
#define APB_MISC_PP_TRISTATE_REG_D_0_WRITE_MASK                         _MK_MASK_CONST(0x1dff)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_DTF_SHIFT                        _MK_SHIFT_CONST(12)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_DTF_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_D_0_Z_DTF_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_DTF_RANGE                        12:12
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_DTF_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_DTF_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_DTF_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_DTF_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_DTF_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_DTF_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_DTF_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_DTF_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_D_0_Z_GPU7_SHIFT                       _MK_SHIFT_CONST(11)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_GPU7_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_D_0_Z_GPU7_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_GPU7_RANGE                       11:11
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_GPU7_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_GPU7_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_GPU7_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_GPU7_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_GPU7_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_GPU7_INIT_ENUM                   NORMAL
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_GPU7_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_GPU7_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_D_0_Z_KBCD_SHIFT                       _MK_SHIFT_CONST(10)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_KBCD_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_D_0_Z_KBCD_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_KBCD_RANGE                       10:10
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_KBCD_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_KBCD_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_KBCD_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_KBCD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_KBCD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_KBCD_INIT_ENUM                   NORMAL
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_KBCD_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_KBCD_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPP_SHIFT                        _MK_SHIFT_CONST(8)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPP_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_D_0_Z_LPP_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPP_RANGE                        8:8
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPP_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPP_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPP_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPP_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPP_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPP_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LHS_SHIFT                        _MK_SHIFT_CONST(7)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LHS_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_D_0_Z_LHS_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LHS_RANGE                        7:7
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LHS_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LHS_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LHS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LHS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LHS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LHS_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LHS_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LHS_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LDI_SHIFT                        _MK_SHIFT_CONST(6)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LDI_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_D_0_Z_LDI_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LDI_RANGE                        6:6
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LDI_WOFFSET                      0x0
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LDI_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LDI_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LDI_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LDI_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LDI_INIT_ENUM                    TRISTATE
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LDI_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LDI_TRISTATE                     _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW2_SHIFT                       _MK_SHIFT_CONST(5)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW2_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW2_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW2_RANGE                       5:5
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW2_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW2_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW2_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW2_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW2_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW1_SHIFT                       _MK_SHIFT_CONST(4)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW1_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW1_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW1_RANGE                       4:4
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW1_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW1_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW1_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW1_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW1_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW0_SHIFT                       _MK_SHIFT_CONST(3)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW0_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW0_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW0_RANGE                       3:3
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW0_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW0_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW0_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW0_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LPW0_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDI_SHIFT                       _MK_SHIFT_CONST(2)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDI_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDI_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDI_RANGE                       2:2
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDI_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDI_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDI_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDI_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDI_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDI_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDI_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDI_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDA_SHIFT                       _MK_SHIFT_CONST(1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDA_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDA_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDA_RANGE                       1:1
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDA_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDA_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDA_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDA_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDA_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSDA_TRISTATE                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSPI_SHIFT                       _MK_SHIFT_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSPI_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_TRISTATE_REG_D_0_Z_LSPI_SHIFT)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSPI_RANGE                       0:0
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSPI_WOFFSET                     0x0
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSPI_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSPI_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSPI_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSPI_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSPI_INIT_ENUM                   TRISTATE
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSPI_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_TRISTATE_REG_D_0_Z_LSPI_TRISTATE                    _MK_ENUM_CONST(1)


// Register APB_MISC_PP_CONFIG_CTL_0  
#define APB_MISC_PP_CONFIG_CTL_0                        _MK_ADDR_CONST(0x24)
#define APB_MISC_PP_CONFIG_CTL_0_WORD_COUNT                     0x1
#define APB_MISC_PP_CONFIG_CTL_0_RESET_VAL                      _MK_MASK_CONST(0x40)
#define APB_MISC_PP_CONFIG_CTL_0_RESET_MASK                     _MK_MASK_CONST(0xc0)
#define APB_MISC_PP_CONFIG_CTL_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APB_MISC_PP_CONFIG_CTL_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_CONFIG_CTL_0_READ_MASK                      _MK_MASK_CONST(0xc0)
#define APB_MISC_PP_CONFIG_CTL_0_WRITE_MASK                     _MK_MASK_CONST(0xc0)
//  0 = Disable ; 1 = Enable RTCK Daisychaining
#define APB_MISC_PP_CONFIG_CTL_0_TBE_SHIFT                      _MK_SHIFT_CONST(7)
#define APB_MISC_PP_CONFIG_CTL_0_TBE_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_CONFIG_CTL_0_TBE_SHIFT)
#define APB_MISC_PP_CONFIG_CTL_0_TBE_RANGE                      7:7
#define APB_MISC_PP_CONFIG_CTL_0_TBE_WOFFSET                    0x0
#define APB_MISC_PP_CONFIG_CTL_0_TBE_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_CONFIG_CTL_0_TBE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_CONFIG_CTL_0_TBE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_CONFIG_CTL_0_TBE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_CONFIG_CTL_0_TBE_INIT_ENUM                  DISABLE
#define APB_MISC_PP_CONFIG_CTL_0_TBE_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_CONFIG_CTL_0_TBE_ENABLE                     _MK_ENUM_CONST(1)

//  0 = Disable Debug ; 1 = Enable JTAG DBGEN
#define APB_MISC_PP_CONFIG_CTL_0_JTAG_SHIFT                     _MK_SHIFT_CONST(6)
#define APB_MISC_PP_CONFIG_CTL_0_JTAG_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_CONFIG_CTL_0_JTAG_SHIFT)
#define APB_MISC_PP_CONFIG_CTL_0_JTAG_RANGE                     6:6
#define APB_MISC_PP_CONFIG_CTL_0_JTAG_WOFFSET                   0x0
#define APB_MISC_PP_CONFIG_CTL_0_JTAG_DEFAULT                   _MK_MASK_CONST(0x1)
#define APB_MISC_PP_CONFIG_CTL_0_JTAG_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_CONFIG_CTL_0_JTAG_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_CONFIG_CTL_0_JTAG_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_CONFIG_CTL_0_JTAG_INIT_ENUM                 ENABLE
#define APB_MISC_PP_CONFIG_CTL_0_JTAG_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_CONFIG_CTL_0_JTAG_ENABLE                    _MK_ENUM_CONST(1)


// Register APB_MISC_PP_MISC_USB_OTG_0  
#define APB_MISC_PP_MISC_USB_OTG_0                      _MK_ADDR_CONST(0x28)
#define APB_MISC_PP_MISC_USB_OTG_0_WORD_COUNT                   0x1
#define APB_MISC_PP_MISC_USB_OTG_0_RESET_VAL                    _MK_MASK_CONST(0x1000)
#define APB_MISC_PP_MISC_USB_OTG_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_MISC_USB_OTG_0_WRITE_MASK                   _MK_MASK_CONST(0xfc7fff29)
// Wake on Disconnect Enable (device mode)
// When enabled (1), USB PHY will wakeup
// from suspend on a disconnect event.
// Software should only set this bit when
// the USB PHY is suspended (bit 2 -
// SUSPENDED = 1).
// Also, software should clear it after
// detecting a wakeup event.
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_DISCON_EN_SHIFT                      _MK_SHIFT_CONST(31)
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_DISCON_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_DISCON_EN_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_DISCON_EN_RANGE                      31:31
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_DISCON_EN_WOFFSET                    0x0
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_DISCON_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_DISCON_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_DISCON_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_DISCON_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_DISCON_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_DISCON_EN_ENABLE                     _MK_ENUM_CONST(1)

// Wake on Connect Enable (device mode)
// When enabled (1), USB PHY will wakeup
// from suspend on a connect event.
// Software should only set this bit when
// the USB PHY is suspended (bit 2 -
// SUSPENDED = 1).
// Also, software should clear it after
// detecting a wakeup event.
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_CNNT_EN_SHIFT                        _MK_SHIFT_CONST(30)
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_CNNT_EN_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_CNNT_EN_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_CNNT_EN_RANGE                        30:30
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_CNNT_EN_WOFFSET                      0x0
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_CNNT_EN_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_CNNT_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_CNNT_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_CNNT_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_CNNT_EN_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_WAKE_ON_CNNT_EN_ENABLE                       _MK_ENUM_CONST(1)

// Debug bus select for USB 
// Software should not change this.
#define APB_MISC_PP_MISC_USB_OTG_0_USB_DEBUG_SEL_SHIFT                  _MK_SHIFT_CONST(26)
#define APB_MISC_PP_MISC_USB_OTG_0_USB_DEBUG_SEL_FIELD                  (_MK_MASK_CONST(0xf) << APB_MISC_PP_MISC_USB_OTG_0_USB_DEBUG_SEL_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_USB_DEBUG_SEL_RANGE                  29:26
#define APB_MISC_PP_MISC_USB_OTG_0_USB_DEBUG_SEL_WOFFSET                        0x0
#define APB_MISC_PP_MISC_USB_OTG_0_USB_DEBUG_SEL_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_USB_DEBUG_SEL_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define APB_MISC_PP_MISC_USB_OTG_0_USB_DEBUG_SEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_USB_DEBUG_SEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// B_SESS_END status from USB PHY.
// This field is the same as the field
// B_SESS_END_STS in register USB_PHY_VBUS_SENSORS.
#define APB_MISC_PP_MISC_USB_OTG_0_B_SESS_END_STS2_SHIFT                        _MK_SHIFT_CONST(25)
#define APB_MISC_PP_MISC_USB_OTG_0_B_SESS_END_STS2_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_B_SESS_END_STS2_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_B_SESS_END_STS2_RANGE                        25:25
#define APB_MISC_PP_MISC_USB_OTG_0_B_SESS_END_STS2_WOFFSET                      0x0
#define APB_MISC_PP_MISC_USB_OTG_0_B_SESS_END_STS2_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_B_SESS_END_STS2_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_B_SESS_END_STS2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_B_SESS_END_STS2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_B_SESS_END_STS2_UNSET                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_B_SESS_END_STS2_SET                  _MK_ENUM_CONST(1)

// A_VBUS_VLD status from USB PHY.
// This field is the same as the field
// A_VBUS_VLD_STS in register USB_PHY_VBUS_SENSORS.
#define APB_MISC_PP_MISC_USB_OTG_0_A_VBUS_VLD_STS2_SHIFT                        _MK_SHIFT_CONST(24)
#define APB_MISC_PP_MISC_USB_OTG_0_A_VBUS_VLD_STS2_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_A_VBUS_VLD_STS2_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_A_VBUS_VLD_STS2_RANGE                        24:24
#define APB_MISC_PP_MISC_USB_OTG_0_A_VBUS_VLD_STS2_WOFFSET                      0x0
#define APB_MISC_PP_MISC_USB_OTG_0_A_VBUS_VLD_STS2_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_A_VBUS_VLD_STS2_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_A_VBUS_VLD_STS2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_A_VBUS_VLD_STS2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_A_VBUS_VLD_STS2_UNSET                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_A_VBUS_VLD_STS2_SET                  _MK_ENUM_CONST(1)

// A_SESS_VLD status from USB PHY.
// This field is the same as the field
// A_SESS_VLD_STS in register USB_PHY_VBUS_SENSORS.
#define APB_MISC_PP_MISC_USB_OTG_0_A_SESS_VLD_STS2_SHIFT                        _MK_SHIFT_CONST(23)
#define APB_MISC_PP_MISC_USB_OTG_0_A_SESS_VLD_STS2_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_A_SESS_VLD_STS2_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_A_SESS_VLD_STS2_RANGE                        23:23
#define APB_MISC_PP_MISC_USB_OTG_0_A_SESS_VLD_STS2_WOFFSET                      0x0
#define APB_MISC_PP_MISC_USB_OTG_0_A_SESS_VLD_STS2_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_A_SESS_VLD_STS2_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_A_SESS_VLD_STS2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_A_SESS_VLD_STS2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_A_SESS_VLD_STS2_UNSET                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_A_SESS_VLD_STS2_SET                  _MK_ENUM_CONST(1)

// Software_B_SESS_END status.
// Software should write the appropriate
// value (1/0) to set/unset the B_SESS_END status.
// This field is the same as the field
// B_SESS_END_SW_VALUE in register USB_PHY_VBUS_SENSORS.
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_SHIFT                  _MK_SHIFT_CONST(22)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_RANGE                  22:22
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_WOFFSET                        0x0
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_UNSET                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_SET                    _MK_ENUM_CONST(1)

// Enable Software Controlled B_SESS_END.
// Software sets this bit to drive the
// value in  SW_B_SESS_END to the USB
// controller.
// This field is the same as the field
// B_SESS_END_SW_EN in register USB_PHY_VBUS_SENSORS.
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_EN_SHIFT                       _MK_SHIFT_CONST(21)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_EN_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_EN_RANGE                       21:21
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_EN_WOFFSET                     0x0
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_B_SESS_END_EN_ENABLE                      _MK_ENUM_CONST(1)

// Software_A_VBUS_VLD status.
// Software should write the appropriate
// value (1/0) to set/unset the A_VBUS_VLD status.
// This field is the same as the field
// A_VBUS_VLD_SW_VALUE in register USB_PHY_VBUS_SENSORS.
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_SHIFT                  _MK_SHIFT_CONST(20)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_RANGE                  20:20
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_WOFFSET                        0x0
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_UNSET                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_SET                    _MK_ENUM_CONST(1)

// Enable Software Controlled A_VBUS_VLD.
// Software sets this bit to drive the
// value in SW_A_VBUS_VLD to the USB
// controller.
// This field is the same as the field
// A_VBUS_VLD_SW_EN in register USB_PHY_VBUS_SENSORS.
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_EN_SHIFT                       _MK_SHIFT_CONST(19)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_EN_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_EN_RANGE                       19:19
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_EN_WOFFSET                     0x0
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_VBUS_VLD_EN_ENABLE                      _MK_ENUM_CONST(1)

// Software_A_SESS_VLD status.
// Software should write the appropriate
// value (1/0) to set/unset the A_SESS_VLD status.
// This field is the same as the field
// A_SESS_VLD_SW_VALUE in register USB_PHY_VBUS_SENSORS.
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_SHIFT                  _MK_SHIFT_CONST(18)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_RANGE                  18:18
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_WOFFSET                        0x0
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_UNSET                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_SET                    _MK_ENUM_CONST(1)

// Enable Software Controlled A_SESS_VLD.
// Software sets this bit to drive the
// value in SW_A_SESS_VLD to the USB
// controller.
// This field is the same as the field
// A_SESS_VLD_SW_EN in register USB_PHY_VBUS_SENSORS.
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_EN_SHIFT                       _MK_SHIFT_CONST(17)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_EN_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_EN_RANGE                       17:17
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_EN_WOFFSET                     0x0
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_A_SESS_VLD_EN_ENABLE                      _MK_ENUM_CONST(1)

// Suspend Set
// Software must write a 1 to this bit to put the USB PHY in
// suspend mode. Software should do this only after making sure that
// the USB is indeed in suspend mode. Setting this bit will stop the
// PHY clock. Software should write a 0 to clear it.
// NOTE: It is required that software generate a positive pulse on this
// bit to guarantee proper operation.
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_SET_SHIFT                       _MK_SHIFT_CONST(16)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_SET_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_SUSP_SET_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_SET_RANGE                       16:16
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_SET_WOFFSET                     0x0
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_SET_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_SET_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_SET_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_SET_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_SET_UNSET                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_SET_SET                 _MK_ENUM_CONST(1)

// VBUS Change Interrupt Enable
// If set, an interrupt will be generated whenever
// A_SESS_VLD changes value. Software can read the
// value of A_SESS_VLD from A_SESS_VLD_STS2 bit.
// This field is the same as the field
// A_SESS_VLD_INT_EN in register USB_PHY_VBUS_SENSORS.
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_INT_EN_SHIFT                        _MK_SHIFT_CONST(15)
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_INT_EN_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_INT_EN_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_INT_EN_RANGE                        15:15
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_INT_EN_WOFFSET                      0x0
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_INT_EN_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_INT_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_INT_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_INT_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_INT_EN_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_INT_EN_ENABLE                       _MK_ENUM_CONST(1)

// Software controlled OTG_ID.
// If SW_OTG_ID_EN = 1, then software needs to monitor
// actual OTG_ID bit used  as a GPIO and based on the value of OTG_ID,
// it can set this bit.
// This field is the same as the field
// ID_SW_VALUE in register USB_PHY_VBUS_WAKEUP_ID.
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_SHIFT                      _MK_SHIFT_CONST(14)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_RANGE                      14:14
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_WOFFSET                    0x0
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_UNSET                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_SET                        _MK_ENUM_CONST(1)

// Reserved
#define APB_MISC_PP_MISC_USB_OTG_0_RSVD13_SHIFT                 _MK_SHIFT_CONST(13)
#define APB_MISC_PP_MISC_USB_OTG_0_RSVD13_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_RSVD13_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_RSVD13_RANGE                 13:13
#define APB_MISC_PP_MISC_USB_OTG_0_RSVD13_WOFFSET                       0x0
#define APB_MISC_PP_MISC_USB_OTG_0_RSVD13_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_RSVD13_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_RSVD13_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_RSVD13_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// ID pullup enable.
// This field controls the internal pull-up to
// OTG_ID pin. Software should set this to
// 1 if using internal OTG_ID. If software
// is using a GPIO for OTG_ID, then it
// can write this to 0.
#define APB_MISC_PP_MISC_USB_OTG_0_ID_PU_SHIFT                  _MK_SHIFT_CONST(12)
#define APB_MISC_PP_MISC_USB_OTG_0_ID_PU_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_ID_PU_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_ID_PU_RANGE                  12:12
#define APB_MISC_PP_MISC_USB_OTG_0_ID_PU_WOFFSET                        0x0
#define APB_MISC_PP_MISC_USB_OTG_0_ID_PU_DEFAULT                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_ID_PU_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_ID_PU_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_ID_PU_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_ID_PU_DISABLE                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_ID_PU_ENABLE                 _MK_ENUM_CONST(1)

//Suspend Clear
// Software must write a 1 to this bit to bring the PHY
// out of suspend mode. This is used when the software stops the PHY
// clock during suspend and then wants to initiate a resume. Software
// should also write 0 to clear it.
// NOTE: It is required that software generate a  positive pulse on this
// bit to guarantee proper operation.
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_CLR_SHIFT                       _MK_SHIFT_CONST(11)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_CLR_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_SUSP_CLR_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_CLR_RANGE                       11:11
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_CLR_WOFFSET                     0x0
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_CLR_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_CLR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_CLR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_CLR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_CLR_UNSET                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSP_CLR_SET                 _MK_ENUM_CONST(1)

// Wake/resume on VBUS change change detect
// If enabled, the USB PHY will wake up whenever a
// change in A_SESS_VLD is detected.
// This should be set only when USB PHY is already
// suspended.
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_VBUS_CHG_SHIFT                   _MK_SHIFT_CONST(10)
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_VBUS_CHG_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_RSM_VBUS_CHG_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_VBUS_CHG_RANGE                   10:10
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_VBUS_CHG_WOFFSET                 0x0
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_VBUS_CHG_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_VBUS_CHG_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_VBUS_CHG_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_VBUS_CHG_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_VBUS_CHG_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_VBUS_CHG_ENABLE                  _MK_ENUM_CONST(1)

// Resume/Clock valid interrupt enable
// If this bit is enabled, interrupt is generated
// whenever PHY clock becomes valid.
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_IE_SHIFT                 _MK_SHIFT_CONST(9)
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_IE_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_RSM_IE_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_IE_RANGE                 9:9
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_IE_WOFFSET                       0x0
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_IE_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_IE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_IE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_IE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_IE_DISABLE                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_RSM_IE_ENABLE                        _MK_ENUM_CONST(1)

// Wake on resume enable
// If this bit is enabled, USB PHY will wakeup from
// suspend whenever resume/reset signaling is
// detected on USB.
#define APB_MISC_PP_MISC_USB_OTG_0_WK_RSM_EN_SHIFT                      _MK_SHIFT_CONST(8)
#define APB_MISC_PP_MISC_USB_OTG_0_WK_RSM_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_WK_RSM_EN_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_WK_RSM_EN_RANGE                      8:8
#define APB_MISC_PP_MISC_USB_OTG_0_WK_RSM_EN_WOFFSET                    0x0
#define APB_MISC_PP_MISC_USB_OTG_0_WK_RSM_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_WK_RSM_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_WK_RSM_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_WK_RSM_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_WK_RSM_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_WK_RSM_EN_ENABLE                     _MK_ENUM_CONST(1)

// PHY clock valid status
// This bit is set whenever PHY clock becomes valid.
// It is cleared whenever PHY clock stops.
#define APB_MISC_PP_MISC_USB_OTG_0_PCLKVLD_SHIFT                        _MK_SHIFT_CONST(7)
#define APB_MISC_PP_MISC_USB_OTG_0_PCLKVLD_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_PCLKVLD_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_PCLKVLD_RANGE                        7:7
#define APB_MISC_PP_MISC_USB_OTG_0_PCLKVLD_WOFFSET                      0x0
#define APB_MISC_PP_MISC_USB_OTG_0_PCLKVLD_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_PCLKVLD_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_PCLKVLD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_PCLKVLD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_PCLKVLD_UNSET                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_PCLKVLD_SET                  _MK_ENUM_CONST(1)

// VBUS change detect
// This bit is set whenever a change in A_SESS_VLD
// is detected.
// Software can read the status of A_SESS_VLD from 
// A_SESS_VLD_STS2 bit.
// This field is the same as the field
// A_SESS_VLD_CHG_DET in register USB_PHY_VBUS_SENSORS.
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_DET_SHIFT                   _MK_SHIFT_CONST(6)
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_DET_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_DET_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_DET_RANGE                   6:6
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_DET_WOFFSET                 0x0
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_DET_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_DET_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_DET_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_DET_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_DET_UNSET                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_VBUS_CHG_DET_SET                     _MK_ENUM_CONST(1)

// Loopback enable
// Not for normal software use
#define APB_MISC_PP_MISC_USB_OTG_0_LPBK_EN_SHIFT                        _MK_SHIFT_CONST(5)
#define APB_MISC_PP_MISC_USB_OTG_0_LPBK_EN_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_LPBK_EN_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_LPBK_EN_RANGE                        5:5
#define APB_MISC_PP_MISC_USB_OTG_0_LPBK_EN_WOFFSET                      0x0
#define APB_MISC_PP_MISC_USB_OTG_0_LPBK_EN_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_LPBK_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_LPBK_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_LPBK_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_LPBK_EN_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_LPBK_EN_ENABLE                       _MK_ENUM_CONST(1)

// Real OTG_ID status from the USB PHY.
// This field is the same as the field
// ID_STS in register USB_PHY_VBUS_WAKEUP_ID.
#define APB_MISC_PP_MISC_USB_OTG_0_OTG_ID_SHIFT                 _MK_SHIFT_CONST(4)
#define APB_MISC_PP_MISC_USB_OTG_0_OTG_ID_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_OTG_ID_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_OTG_ID_RANGE                 4:4
#define APB_MISC_PP_MISC_USB_OTG_0_OTG_ID_WOFFSET                       0x0
#define APB_MISC_PP_MISC_USB_OTG_0_OTG_ID_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_OTG_ID_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_OTG_ID_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_OTG_ID_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_OTG_ID_UNSET                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_OTG_ID_SET                   _MK_ENUM_CONST(1)

// Enable Software Controlled OTG_ID
// If using a GPIO for OTG_ID signal, then
// software can set this to 1 and write
// the value from the GPIO to the
// SW_OTG_ID bit in this register.
// This field is the same as the field
// ID_SW_EN in register USB_PHY_VBUS_WAKEUP_ID.
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_EN_SHIFT                   _MK_SHIFT_CONST(3)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_EN_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_EN_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_EN_RANGE                   3:3
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_EN_WOFFSET                 0x0
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_EN_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_SW_OTG_ID_EN_ENABLE                  _MK_ENUM_CONST(1)

// USB PHY suspend status
// This bit is set to 1 whenver USB is suspended and the PHY clock isnt  available.
// NOTE: Software should not access any
// registers in USB controller when this
// bit is set.
#define APB_MISC_PP_MISC_USB_OTG_0_SUSPENDED_SHIFT                      _MK_SHIFT_CONST(2)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSPENDED_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_SUSPENDED_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSPENDED_RANGE                      2:2
#define APB_MISC_PP_MISC_USB_OTG_0_SUSPENDED_WOFFSET                    0x0
#define APB_MISC_PP_MISC_USB_OTG_0_SUSPENDED_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSPENDED_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSPENDED_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSPENDED_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSPENDED_UNSET                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUSPENDED_SET                        _MK_ENUM_CONST(1)

// Static General purpose input coming from ID pin
#define APB_MISC_PP_MISC_USB_OTG_0_StaticGpi_SHIFT                      _MK_SHIFT_CONST(1)
#define APB_MISC_PP_MISC_USB_OTG_0_StaticGpi_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_StaticGpi_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_StaticGpi_RANGE                      1:1
#define APB_MISC_PP_MISC_USB_OTG_0_StaticGpi_WOFFSET                    0x0
#define APB_MISC_PP_MISC_USB_OTG_0_StaticGpi_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_StaticGpi_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_StaticGpi_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_StaticGpi_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_StaticGpi_UNSET                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_StaticGpi_SET                        _MK_ENUM_CONST(1)

// Polarity of the suspend signal going to USB PHY
// Software should not change this.
#define APB_MISC_PP_MISC_USB_OTG_0_SUS_POL_SHIFT                        _MK_SHIFT_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUS_POL_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_OTG_0_SUS_POL_SHIFT)
#define APB_MISC_PP_MISC_USB_OTG_0_SUS_POL_RANGE                        0:0
#define APB_MISC_PP_MISC_USB_OTG_0_SUS_POL_WOFFSET                      0x0
#define APB_MISC_PP_MISC_USB_OTG_0_SUS_POL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUS_POL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_OTG_0_SUS_POL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUS_POL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUS_POL_ACTIVE_LOW                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_OTG_0_SUS_POL_ACTIVE_HIGH                  _MK_ENUM_CONST(1)


// Register APB_MISC_PP_XMB_CSR_0  
#define APB_MISC_PP_XMB_CSR_0                   _MK_ADDR_CONST(0x30)
#define APB_MISC_PP_XMB_CSR_0_WORD_COUNT                        0x1
#define APB_MISC_PP_XMB_CSR_0_RESET_VAL                         _MK_MASK_CONST(0x58007410)
#define APB_MISC_PP_XMB_CSR_0_RESET_MASK                        _MK_MASK_CONST(0xde04ffff)
#define APB_MISC_PP_XMB_CSR_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_READ_MASK                         _MK_MASK_CONST(0xde04ffff)
#define APB_MISC_PP_XMB_CSR_0_WRITE_MASK                        _MK_MASK_CONST(0x5004ffff)
// External ROM Busy indicator.
#define APB_MISC_PP_XMB_CSR_0_ROM_IORDY_IN_SHIFT                        _MK_SHIFT_CONST(31)
#define APB_MISC_PP_XMB_CSR_0_ROM_IORDY_IN_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_XMB_CSR_0_ROM_IORDY_IN_SHIFT)
#define APB_MISC_PP_XMB_CSR_0_ROM_IORDY_IN_RANGE                        31:31
#define APB_MISC_PP_XMB_CSR_0_ROM_IORDY_IN_WOFFSET                      0x0
#define APB_MISC_PP_XMB_CSR_0_ROM_IORDY_IN_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_ROM_IORDY_IN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_CSR_0_ROM_IORDY_IN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_ROM_IORDY_IN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// 0 = Write Protected (def)
#define APB_MISC_PP_XMB_CSR_0_ROM_WE_SHIFT                      _MK_SHIFT_CONST(30)
#define APB_MISC_PP_XMB_CSR_0_ROM_WE_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_XMB_CSR_0_ROM_WE_SHIFT)
#define APB_MISC_PP_XMB_CSR_0_ROM_WE_RANGE                      30:30
#define APB_MISC_PP_XMB_CSR_0_ROM_WE_WOFFSET                    0x0
#define APB_MISC_PP_XMB_CSR_0_ROM_WE_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_CSR_0_ROM_WE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_CSR_0_ROM_WE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_ROM_WE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// 0 = Strobe edge
#define APB_MISC_PP_XMB_CSR_0_DQM_MASK_MODE_SHIFT                       _MK_SHIFT_CONST(28)
#define APB_MISC_PP_XMB_CSR_0_DQM_MASK_MODE_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_XMB_CSR_0_DQM_MASK_MODE_SHIFT)
#define APB_MISC_PP_XMB_CSR_0_DQM_MASK_MODE_RANGE                       28:28
#define APB_MISC_PP_XMB_CSR_0_DQM_MASK_MODE_WOFFSET                     0x0
#define APB_MISC_PP_XMB_CSR_0_DQM_MASK_MODE_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_CSR_0_DQM_MASK_MODE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_CSR_0_DQM_MASK_MODE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_DQM_MASK_MODE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 0 = Buffer not empty 1 = Buffer empty (default) (RO  register)
#define APB_MISC_PP_XMB_CSR_0_AHB_BUF_MT_SHIFT                  _MK_SHIFT_CONST(27)
#define APB_MISC_PP_XMB_CSR_0_AHB_BUF_MT_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_PP_XMB_CSR_0_AHB_BUF_MT_SHIFT)
#define APB_MISC_PP_XMB_CSR_0_AHB_BUF_MT_RANGE                  27:27
#define APB_MISC_PP_XMB_CSR_0_AHB_BUF_MT_WOFFSET                        0x0
#define APB_MISC_PP_XMB_CSR_0_AHB_BUF_MT_DEFAULT                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_CSR_0_AHB_BUF_MT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_CSR_0_AHB_BUF_MT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_AHB_BUF_MT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// 0 = Buffer Not full (default) 1 = Buffer Full (RO  register)
#define APB_MISC_PP_XMB_CSR_0_AHB_BUF_FULL_SHIFT                        _MK_SHIFT_CONST(26)
#define APB_MISC_PP_XMB_CSR_0_AHB_BUF_FULL_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_XMB_CSR_0_AHB_BUF_FULL_SHIFT)
#define APB_MISC_PP_XMB_CSR_0_AHB_BUF_FULL_RANGE                        26:26
#define APB_MISC_PP_XMB_CSR_0_AHB_BUF_FULL_WOFFSET                      0x0
#define APB_MISC_PP_XMB_CSR_0_AHB_BUF_FULL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_AHB_BUF_FULL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_CSR_0_AHB_BUF_FULL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_AHB_BUF_FULL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// 0 = Buffer empty (default) 1 = Buffer full (RO  register)
#define APB_MISC_PP_XMB_CSR_0_DC_BUF_FULL_SHIFT                 _MK_SHIFT_CONST(25)
#define APB_MISC_PP_XMB_CSR_0_DC_BUF_FULL_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_PP_XMB_CSR_0_DC_BUF_FULL_SHIFT)
#define APB_MISC_PP_XMB_CSR_0_DC_BUF_FULL_RANGE                 25:25
#define APB_MISC_PP_XMB_CSR_0_DC_BUF_FULL_WOFFSET                       0x0
#define APB_MISC_PP_XMB_CSR_0_DC_BUF_FULL_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_DC_BUF_FULL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_CSR_0_DC_BUF_FULL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_DC_BUF_FULL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// 0 = don't mask mio_rdy 1 = mask mio_rdy
#define APB_MISC_PP_XMB_CSR_0_MASK_MIO_RDY_SHIFT                        _MK_SHIFT_CONST(18)
#define APB_MISC_PP_XMB_CSR_0_MASK_MIO_RDY_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_XMB_CSR_0_MASK_MIO_RDY_SHIFT)
#define APB_MISC_PP_XMB_CSR_0_MASK_MIO_RDY_RANGE                        18:18
#define APB_MISC_PP_XMB_CSR_0_MASK_MIO_RDY_WOFFSET                      0x0
#define APB_MISC_PP_XMB_CSR_0_MASK_MIO_RDY_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_MASK_MIO_RDY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_CSR_0_MASK_MIO_RDY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_MASK_MIO_RDY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//  1XXX = Reserved
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_D_SHIFT                   _MK_SHIFT_CONST(12)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_D_FIELD                   (_MK_MASK_CONST(0xf) << APB_MISC_PP_XMB_CSR_0_XMB_CSN_D_SHIFT)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_D_RANGE                   15:12
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_D_WOFFSET                 0x0
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_D_DEFAULT                 _MK_MASK_CONST(0x7)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_D_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_D_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_D_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_D_ROM0                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_D_ROM1                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_D_XMEM1                   _MK_ENUM_CONST(5)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_D_MIO0                    _MK_ENUM_CONST(6)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_D_MIO1                    _MK_ENUM_CONST(7)

//  1XXX = Reserved
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_C_SHIFT                   _MK_SHIFT_CONST(8)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_C_FIELD                   (_MK_MASK_CONST(0xf) << APB_MISC_PP_XMB_CSR_0_XMB_CSN_C_SHIFT)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_C_RANGE                   11:8
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_C_WOFFSET                 0x0
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_C_DEFAULT                 _MK_MASK_CONST(0x4)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_C_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_C_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_C_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_C_ROM0                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_C_ROM1                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_C_XMEM0                   _MK_ENUM_CONST(4)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_C_MIO0                    _MK_ENUM_CONST(6)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_C_MIO1                    _MK_ENUM_CONST(7)

//  1XXX = Reserved
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_B_SHIFT                   _MK_SHIFT_CONST(4)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_B_FIELD                   (_MK_MASK_CONST(0xf) << APB_MISC_PP_XMB_CSR_0_XMB_CSN_B_SHIFT)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_B_RANGE                   7:4
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_B_WOFFSET                 0x0
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_B_DEFAULT                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_B_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_B_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_B_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_B_ROM0                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_B_ROM1                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_B_MIO0                    _MK_ENUM_CONST(6)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_B_MIO1                    _MK_ENUM_CONST(7)

//  1XXX = Reserved
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_A_SHIFT                   _MK_SHIFT_CONST(0)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_A_FIELD                   (_MK_MASK_CONST(0xf) << APB_MISC_PP_XMB_CSR_0_XMB_CSN_A_SHIFT)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_A_RANGE                   3:0
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_A_WOFFSET                 0x0
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_A_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_A_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_A_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_A_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_A_ROM0                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_A_ROM1                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_A_MIO0                    _MK_ENUM_CONST(6)
#define APB_MISC_PP_XMB_CSR_0_XMB_CSN_A_MIO1                    _MK_ENUM_CONST(7)


// Register APB_MISC_PP_XMB_NOR_FLASH_CFG_0  
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0                 _MK_ADDR_CONST(0x34)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_WORD_COUNT                      0x1
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_RESET_VAL                       _MK_MASK_CONST(0x1f1f)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_RESET_MASK                      _MK_MASK_CONST(0xc3ff3f3f)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_READ_MASK                       _MK_MASK_CONST(0xc3ff3f3f)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_WRITE_MASK                      _MK_MASK_CONST(0xc3ff3f3f)
// writing 1 clears nor_muxerr interrupt
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_CLR_SHIFT                        _MK_SHIFT_CONST(31)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_CLR_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_CLR_SHIFT)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_CLR_RANGE                        31:31
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_CLR_WOFFSET                      0x0
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_CLR_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_CLR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_CLR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_CLR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// 0 = mask interrupt 1 = don't mask interrupt
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_MASK_SHIFT                       _MK_SHIFT_CONST(30)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_MASK_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_MASK_SHIFT)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_MASK_RANGE                       30:30
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_MASK_WOFFSET                     0x0
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_MASK_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_MASK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_MASK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MUXERR_INT_MASK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// NOR minimum transaction time
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MIN_TRANS_TIME_SHIFT                        _MK_SHIFT_CONST(16)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MIN_TRANS_TIME_FIELD                        (_MK_MASK_CONST(0x3ff) << APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MIN_TRANS_TIME_SHIFT)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MIN_TRANS_TIME_RANGE                        25:16
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MIN_TRANS_TIME_WOFFSET                      0x0
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MIN_TRANS_TIME_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MIN_TRANS_TIME_DEFAULT_MASK                 _MK_MASK_CONST(0x3ff)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MIN_TRANS_TIME_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_NOR_MIN_TRANS_TIME_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// ROM Wait cycles after Write. (in SCLK)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_DEAD_TIME_SHIFT                  _MK_SHIFT_CONST(12)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_DEAD_TIME_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_DEAD_TIME_SHIFT)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_DEAD_TIME_RANGE                  13:12
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_DEAD_TIME_WOFFSET                        0x0
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_DEAD_TIME_DEFAULT                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_DEAD_TIME_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_DEAD_TIME_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_DEAD_TIME_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// ROM Write time (in number of SCLK cycles)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_TIME_SHIFT                       _MK_SHIFT_CONST(8)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_TIME_FIELD                       (_MK_MASK_CONST(0xf) << APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_TIME_SHIFT)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_TIME_RANGE                       11:8
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_TIME_WOFFSET                     0x0
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_TIME_DEFAULT                     _MK_MASK_CONST(0xf)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_TIME_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_TIME_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_WR_TIME_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// ROM Wait cycles after Read (in SCLK)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_DEAD_TIME_SHIFT                  _MK_SHIFT_CONST(4)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_DEAD_TIME_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_DEAD_TIME_SHIFT)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_DEAD_TIME_RANGE                  5:4
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_DEAD_TIME_WOFFSET                        0x0
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_DEAD_TIME_DEFAULT                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_DEAD_TIME_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_DEAD_TIME_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_DEAD_TIME_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// ROM Read time (in number of SCLK cycles)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_TIME_SHIFT                       _MK_SHIFT_CONST(0)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_TIME_FIELD                       (_MK_MASK_CONST(0xf) << APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_TIME_SHIFT)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_TIME_RANGE                       3:0
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_TIME_WOFFSET                     0x0
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_TIME_DEFAULT                     _MK_MASK_CONST(0xf)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_TIME_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_TIME_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_NOR_FLASH_CFG_0_ROM_RD_TIME_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Reserved address 56 [0x38] 

// Register APB_MISC_PP_XMB_MIO_CFG_0  
#define APB_MISC_PP_XMB_MIO_CFG_0                       _MK_ADDR_CONST(0x40)
#define APB_MISC_PP_XMB_MIO_CFG_0_WORD_COUNT                    0x1
#define APB_MISC_PP_XMB_MIO_CFG_0_RESET_VAL                     _MK_MASK_CONST(0x1f1f1f1f)
#define APB_MISC_PP_XMB_MIO_CFG_0_RESET_MASK                    _MK_MASK_CONST(0x7f7f7f7f)
#define APB_MISC_PP_XMB_MIO_CFG_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_MIO_CFG_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_MIO_CFG_0_READ_MASK                     _MK_MASK_CONST(0x7f7f7f7f)
#define APB_MISC_PP_XMB_MIO_CFG_0_WRITE_MASK                    _MK_MASK_CONST(0x7f7f7f7f)
// end of a write access and goes low for the start  of another read or write access.
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_DEAD_TIME_SHIFT                      _MK_SHIFT_CONST(28)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_DEAD_TIME_FIELD                      (_MK_MASK_CONST(0x7) << APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_DEAD_TIME_SHIFT)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_DEAD_TIME_RANGE                      30:28
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_DEAD_TIME_WOFFSET                    0x0
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_DEAD_TIME_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_DEAD_TIME_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_DEAD_TIME_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_DEAD_TIME_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// signal is set low for MIO1. This period extends  beyond the programmed period as long as MIO_RDY signal remains low. MIO_RDY  is connected to a slave wait pin, both active low. As long as this signal is  low, PP5003 maintains all the MIO signals stable, as it waits for the slave  to complete the access. Request is removed after signal goes high.
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_TIME_SHIFT                   _MK_SHIFT_CONST(24)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_TIME_FIELD                   (_MK_MASK_CONST(0xf) << APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_TIME_SHIFT)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_TIME_RANGE                   27:24
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_TIME_WOFFSET                 0x0
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_TIME_DEFAULT                 _MK_MASK_CONST(0xf)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_TIME_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_TIME_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_WR_TIME_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// start of the following access for MIO1. (The chip  select goes high at the end of a read access and goes low at the start of a  read or write access.)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_DEAD_TIME_SHIFT                      _MK_SHIFT_CONST(20)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_DEAD_TIME_FIELD                      (_MK_MASK_CONST(0x7) << APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_DEAD_TIME_SHIFT)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_DEAD_TIME_RANGE                      22:20
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_DEAD_TIME_WOFFSET                    0x0
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_DEAD_TIME_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_DEAD_TIME_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_DEAD_TIME_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_DEAD_TIME_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// signal is set low for MIO1. This period extends  beyond the programmed period as long as MIO_RDY signal remains low. MIO_RDY  is connected to a slave wait pin, both active low. As long as this signal is  low, PP5003 maintains all the MIO signals
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_TIME_SHIFT                   _MK_SHIFT_CONST(16)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_TIME_FIELD                   (_MK_MASK_CONST(0xf) << APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_TIME_SHIFT)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_TIME_RANGE                   19:16
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_TIME_WOFFSET                 0x0
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_TIME_DEFAULT                 _MK_MASK_CONST(0xf)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_TIME_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_TIME_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_B_RD_TIME_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// the start of the following access (write or read)  for MIO0 . Chip select goes high at the end of a write access and goes low  for the start of another read or write access.
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_DEAD_TIME_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_DEAD_TIME_FIELD                      (_MK_MASK_CONST(0x7) << APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_DEAD_TIME_SHIFT)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_DEAD_TIME_RANGE                      14:12
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_DEAD_TIME_WOFFSET                    0x0
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_DEAD_TIME_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_DEAD_TIME_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_DEAD_TIME_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_DEAD_TIME_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// during a write access for MIO0. This period  extends as long as the MIO_RDY signal remains low.
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_TIME_SHIFT                   _MK_SHIFT_CONST(8)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_TIME_FIELD                   (_MK_MASK_CONST(0xf) << APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_TIME_SHIFT)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_TIME_RANGE                   11:8
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_TIME_WOFFSET                 0x0
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_TIME_DEFAULT                 _MK_MASK_CONST(0xf)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_TIME_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_TIME_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_WR_TIME_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// start of the following access for MIO0. (The chip  select goes high at the end of a read access and goes low at the start of a  read or write access.)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_DEAD_TIME_SHIFT                      _MK_SHIFT_CONST(4)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_DEAD_TIME_FIELD                      (_MK_MASK_CONST(0x7) << APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_DEAD_TIME_SHIFT)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_DEAD_TIME_RANGE                      6:4
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_DEAD_TIME_WOFFSET                    0x0
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_DEAD_TIME_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_DEAD_TIME_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_DEAD_TIME_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_DEAD_TIME_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// MIO RDY Indicator. This signal indicates if the  MIO is ready. This also implies that the MIO is not busy with the present  request. The firmware can poll for this to get device status.
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_TIME_SHIFT                   _MK_SHIFT_CONST(0)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_TIME_FIELD                   (_MK_MASK_CONST(0xf) << APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_TIME_SHIFT)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_TIME_RANGE                   3:0
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_TIME_WOFFSET                 0x0
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_TIME_DEFAULT                 _MK_MASK_CONST(0xf)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_TIME_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_TIME_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_XMB_MIO_CFG_0_MIO_A_RD_TIME_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Reserved address 68 [0x44] 

// Register APB_MISC_PP_USB_PHY_VCTL_REG_0  
#define APB_MISC_PP_USB_PHY_VCTL_REG_0                  _MK_ADDR_CONST(0x60)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_WORD_COUNT                       0x1
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_RESET_VAL                        _MK_MASK_CONST(0x100020)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_RESET_MASK                       _MK_MASK_CONST(0x10ff3f)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_READ_MASK                        _MK_MASK_CONST(0x10ff3f)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_WRITE_MASK                       _MK_MASK_CONST(0x10003f)
// Unused
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_CLK12_SEL_SHIFT                  _MK_SHIFT_CONST(20)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_CLK12_SEL_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VCTL_REG_0_CLK12_SEL_SHIFT)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_CLK12_SEL_RANGE                  20:20
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_CLK12_SEL_WOFFSET                        0x0
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_CLK12_SEL_DEFAULT                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_CLK12_SEL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_CLK12_SEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_CLK12_SEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_CLK12_SEL_MHZ_24                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_CLK12_SEL_MHZ_12                 _MK_ENUM_CONST(1)

// Vendor status from PHY. Read only
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VSTATUS_SHIFT                    _MK_SHIFT_CONST(8)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VSTATUS_FIELD                    (_MK_MASK_CONST(0xff) << APB_MISC_PP_USB_PHY_VCTL_REG_0_VSTATUS_SHIFT)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VSTATUS_RANGE                    15:8
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VSTATUS_WOFFSET                  0x0
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VSTATUS_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VSTATUS_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VSTATUS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VSTATUS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Default: 1
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VLOAD_SHIFT                      _MK_SHIFT_CONST(5)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VLOAD_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VCTL_REG_0_VLOAD_SHIFT)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VLOAD_RANGE                      5:5
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VLOAD_WOFFSET                    0x0
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VLOAD_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VLOAD_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VLOAD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VLOAD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VLOAD_UNSET                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VLOAD_SET                        _MK_ENUM_CONST(1)

// Default: 0
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VCONTROL_SHIFT                   _MK_SHIFT_CONST(0)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VCONTROL_FIELD                   (_MK_MASK_CONST(0x1f) << APB_MISC_PP_USB_PHY_VCTL_REG_0_VCONTROL_SHIFT)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VCONTROL_RANGE                   4:0
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VCONTROL_WOFFSET                 0x0
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VCONTROL_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VCONTROL_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VCONTROL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VCTL_REG_0_VCONTROL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APB_MISC_PP_USB_PHY_PARAM_0  
#define APB_MISC_PP_USB_PHY_PARAM_0                     _MK_ADDR_CONST(0x64)
#define APB_MISC_PP_USB_PHY_PARAM_0_WORD_COUNT                  0x1
#define APB_MISC_PP_USB_PHY_PARAM_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_RESET_MASK                  _MK_MASK_CONST(0x3ff9)
#define APB_MISC_PP_USB_PHY_PARAM_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_READ_MASK                   _MK_MASK_CONST(0x3ff9)
#define APB_MISC_PP_USB_PHY_PARAM_0_WRITE_MASK                  _MK_MASK_CONST(0x3ff9)
// Lower 32-bits select.
// Not intended for software use.
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_LOW32BITS_SEL_SHIFT                     _MK_SHIFT_CONST(13)
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_LOW32BITS_SEL_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_PARAM_0_BUF_LOW32BITS_SEL_SHIFT)
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_LOW32BITS_SEL_RANGE                     13:13
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_LOW32BITS_SEL_WOFFSET                   0x0
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_LOW32BITS_SEL_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_LOW32BITS_SEL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_LOW32BITS_SEL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_LOW32BITS_SEL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_LOW32BITS_SEL_UPPER_BITS                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_LOW32BITS_SEL_LOWER_BITS                        _MK_ENUM_CONST(1)

// Enable reception of test packets
// Not intended for software use.
#define APB_MISC_PP_USB_PHY_PARAM_0_RCV_TEST_PKT_SHIFT                  _MK_SHIFT_CONST(12)
#define APB_MISC_PP_USB_PHY_PARAM_0_RCV_TEST_PKT_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_PARAM_0_RCV_TEST_PKT_SHIFT)
#define APB_MISC_PP_USB_PHY_PARAM_0_RCV_TEST_PKT_RANGE                  12:12
#define APB_MISC_PP_USB_PHY_PARAM_0_RCV_TEST_PKT_WOFFSET                        0x0
#define APB_MISC_PP_USB_PHY_PARAM_0_RCV_TEST_PKT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_RCV_TEST_PKT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_PARAM_0_RCV_TEST_PKT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_RCV_TEST_PKT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_RCV_TEST_PKT_DISABLE                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_PARAM_0_RCV_TEST_PKT_ENABLE                 _MK_ENUM_CONST(1)

// Enable transmission of test packets
// Not intended for software use.
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_PKT_SHIFT                 _MK_SHIFT_CONST(11)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_PKT_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_PKT_SHIFT)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_PKT_RANGE                 11:11
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_PKT_WOFFSET                       0x0
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_PKT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_PKT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_PKT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_PKT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_PKT_DISABLE                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_PKT_ENABLE                        _MK_ENUM_CONST(1)

// Enable TEST_J transmission
// Not intended for software use.
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_K_SHIFT                   _MK_SHIFT_CONST(10)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_K_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_K_SHIFT)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_K_RANGE                   10:10
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_K_WOFFSET                 0x0
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_K_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_K_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_K_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_K_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_K_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_K_ENABLE                  _MK_ENUM_CONST(1)

// Enable TEST_K transmission
// Not intended for software use.
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_J_SHIFT                   _MK_SHIFT_CONST(9)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_J_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_J_SHIFT)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_J_RANGE                   9:9
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_J_WOFFSET                 0x0
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_J_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_J_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_J_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_J_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_J_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_PARAM_0_SEND_TEST_J_ENABLE                  _MK_ENUM_CONST(1)

// If enabled, send SOF with EOP of J, else
// send SOF with EOP of K
// Not intended for software use.
#define APB_MISC_PP_USB_PHY_PARAM_0_TEST_SOF_J_SHIFT                    _MK_SHIFT_CONST(8)
#define APB_MISC_PP_USB_PHY_PARAM_0_TEST_SOF_J_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_PARAM_0_TEST_SOF_J_SHIFT)
#define APB_MISC_PP_USB_PHY_PARAM_0_TEST_SOF_J_RANGE                    8:8
#define APB_MISC_PP_USB_PHY_PARAM_0_TEST_SOF_J_WOFFSET                  0x0
#define APB_MISC_PP_USB_PHY_PARAM_0_TEST_SOF_J_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_TEST_SOF_J_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_PARAM_0_TEST_SOF_J_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_TEST_SOF_J_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_TEST_SOF_J_DISABLE                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_PARAM_0_TEST_SOF_J_ENABLE                   _MK_ENUM_CONST(1)

// Unused
// Not intended for software use.
#define APB_MISC_PP_USB_PHY_PARAM_0_UTMI_DEBUG_SEL_SHIFT                        _MK_SHIFT_CONST(7)
#define APB_MISC_PP_USB_PHY_PARAM_0_UTMI_DEBUG_SEL_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_PARAM_0_UTMI_DEBUG_SEL_SHIFT)
#define APB_MISC_PP_USB_PHY_PARAM_0_UTMI_DEBUG_SEL_RANGE                        7:7
#define APB_MISC_PP_USB_PHY_PARAM_0_UTMI_DEBUG_SEL_WOFFSET                      0x0
#define APB_MISC_PP_USB_PHY_PARAM_0_UTMI_DEBUG_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_UTMI_DEBUG_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_PARAM_0_UTMI_DEBUG_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_UTMI_DEBUG_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_UTMI_DEBUG_SEL_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_PARAM_0_UTMI_DEBUG_SEL_ENABLE                       _MK_ENUM_CONST(1)

// Reserved
#define APB_MISC_PP_USB_PHY_PARAM_0_RSVD6_SHIFT                 _MK_SHIFT_CONST(6)
#define APB_MISC_PP_USB_PHY_PARAM_0_RSVD6_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_PARAM_0_RSVD6_SHIFT)
#define APB_MISC_PP_USB_PHY_PARAM_0_RSVD6_RANGE                 6:6
#define APB_MISC_PP_USB_PHY_PARAM_0_RSVD6_WOFFSET                       0x0
#define APB_MISC_PP_USB_PHY_PARAM_0_RSVD6_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_RSVD6_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_PARAM_0_RSVD6_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_RSVD6_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Route USB buffers to AHB interface for debug
// Not intended for software use.
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_AHB_IF_SEL_SHIFT                        _MK_SHIFT_CONST(5)
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_AHB_IF_SEL_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_PARAM_0_BUF_AHB_IF_SEL_SHIFT)
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_AHB_IF_SEL_RANGE                        5:5
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_AHB_IF_SEL_WOFFSET                      0x0
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_AHB_IF_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_AHB_IF_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_AHB_IF_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_AHB_IF_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_AHB_IF_SEL_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_PARAM_0_BUF_AHB_IF_SEL_ENABLE                       _MK_ENUM_CONST(1)

// Vbus_sense control
// Controls which VBUS sensor input is driven to the controller.
// 00: Use VBUS_WAKEUP.
// 01: Use A_SESS_VLD output from the PHY if the PHY clock is available.
// Otherwise, use VBUS_WAKEUP.
// 10: Use A_SESS_VLD output from the PHY
// 11: Use VBUS_WAKEUP.
#define APB_MISC_PP_USB_PHY_PARAM_0_VS_CTL_SHIFT                        _MK_SHIFT_CONST(3)
#define APB_MISC_PP_USB_PHY_PARAM_0_VS_CTL_FIELD                        (_MK_MASK_CONST(0x3) << APB_MISC_PP_USB_PHY_PARAM_0_VS_CTL_SHIFT)
#define APB_MISC_PP_USB_PHY_PARAM_0_VS_CTL_RANGE                        4:3
#define APB_MISC_PP_USB_PHY_PARAM_0_VS_CTL_WOFFSET                      0x0
#define APB_MISC_PP_USB_PHY_PARAM_0_VS_CTL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_VS_CTL_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APB_MISC_PP_USB_PHY_PARAM_0_VS_CTL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_VS_CTL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_VS_CTL_VBUS_WAKEUP                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_PARAM_0_VS_CTL_A_SESS_VLD_OR_VBUS_WAKEUP                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_USB_PHY_PARAM_0_VS_CTL_A_SESS_VLD                   _MK_ENUM_CONST(2)
#define APB_MISC_PP_USB_PHY_PARAM_0_VS_CTL_VBUS_WAKEUP_1                        _MK_ENUM_CONST(3)

// FS/LS serial interface enable
// If enabled, use FS/LS serial interface for USB transfers.
// This mode does not support HS transfers.
// If disabled, use UTMI interface for USB transfers.
// This mode supports all transfer speeds - HS/FS/LS.
#define APB_MISC_PP_USB_PHY_PARAM_0_FS_LS_SER_MODE_SHIFT                        _MK_SHIFT_CONST(0)
#define APB_MISC_PP_USB_PHY_PARAM_0_FS_LS_SER_MODE_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_PARAM_0_FS_LS_SER_MODE_SHIFT)
#define APB_MISC_PP_USB_PHY_PARAM_0_FS_LS_SER_MODE_RANGE                        0:0
#define APB_MISC_PP_USB_PHY_PARAM_0_FS_LS_SER_MODE_WOFFSET                      0x0
#define APB_MISC_PP_USB_PHY_PARAM_0_FS_LS_SER_MODE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_FS_LS_SER_MODE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_PARAM_0_FS_LS_SER_MODE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_FS_LS_SER_MODE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_PARAM_0_FS_LS_SER_MODE_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_PARAM_0_FS_LS_SER_MODE_ENABLE                       _MK_ENUM_CONST(1)


// Register APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0  
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0                   _MK_ADDR_CONST(0x68)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_WORD_COUNT                        0x1
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RESET_MASK                        _MK_MASK_CONST(0x33f3f)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_READ_MASK                         _MK_MASK_CONST(0x33f3f)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
// RX compare fail. Comparison on RX data failed.
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_SHIFT                       _MK_SHIFT_CONST(17)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_RANGE                       17:17
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_WOFFSET                     0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_UNSET                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_SET                 _MK_ENUM_CONST(1)

// Rx valid/Rx validh fail: Indicates that the  Rxvalid/Rxvalidh werent generated according to protocol
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_SHIFT                       _MK_SHIFT_CONST(16)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_RANGE                       16:16
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_WOFFSET                     0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_UNSET                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_SET                 _MK_ENUM_CONST(1)

// Failed packet no: Points to the failed packet no
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_SHIFT                 _MK_SHIFT_CONST(8)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_FIELD                 (_MK_MASK_CONST(0x3f) << APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_RANGE                 13:8
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_WOFFSET                       0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_DEFAULT_MASK                  _MK_MASK_CONST(0x3f)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Failed RX byte index: Points to the Rx byte no. in  the current packet which fails
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_SHIFT                        _MK_SHIFT_CONST(0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_FIELD                        (_MK_MASK_CONST(0x3f) << APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_RANGE                        5:0
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_WOFFSET                      0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_DEFAULT_MASK                 _MK_MASK_CONST(0x3f)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APB_MISC_PP_USB_PHY_SELF_TEST_0  
#define APB_MISC_PP_USB_PHY_SELF_TEST_0                 _MK_ADDR_CONST(0x6c)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_WORD_COUNT                      0x1
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_RESET_VAL                       _MK_MASK_CONST(0x10150888)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_RESET_MASK                      _MK_MASK_CONST(0x3f3ffbff)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_READ_MASK                       _MK_MASK_CONST(0x3f3ffbff)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_WRITE_MASK                      _MK_MASK_CONST(0x3f3f7bf3)
// Default: 0x10
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_SHIFT                      _MK_SHIFT_CONST(24)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_FIELD                      (_MK_MASK_CONST(0x3f) << APB_MISC_PP_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_RANGE                      29:24
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_WOFFSET                    0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_DEFAULT                    _MK_MASK_CONST(0x10)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// default: 0x15
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_IPKT_DLY_SHIFT                  _MK_SHIFT_CONST(16)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_IPKT_DLY_FIELD                  (_MK_MASK_CONST(0x3f) << APB_MISC_PP_USB_PHY_SELF_TEST_0_IPKT_DLY_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_IPKT_DLY_RANGE                  21:16
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_IPKT_DLY_WOFFSET                        0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_IPKT_DLY_DEFAULT                        _MK_MASK_CONST(0x15)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_IPKT_DLY_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_IPKT_DLY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_IPKT_DLY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Status of Disconnect signal from PHY
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DISCON_SHIFT                    _MK_SHIFT_CONST(15)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DISCON_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_SELF_TEST_0_DISCON_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DISCON_RANGE                    15:15
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DISCON_WOFFSET                  0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DISCON_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DISCON_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DISCON_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DISCON_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DISCON_UNSET                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DISCON_SET                      _MK_ENUM_CONST(1)

// Default: 0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SOF_EN_SHIFT                    _MK_SHIFT_CONST(14)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SOF_EN_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_SELF_TEST_0_SOF_EN_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SOF_EN_RANGE                    14:14
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SOF_EN_WOFFSET                  0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SOF_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SOF_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SOF_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SOF_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SOF_EN_DISABLE                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SOF_EN_ENABLE                   _MK_ENUM_CONST(1)

// Default: 0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DPPD_SHIFT                      _MK_SHIFT_CONST(13)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DPPD_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_SELF_TEST_0_DPPD_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DPPD_RANGE                      13:13
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DPPD_WOFFSET                    0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DPPD_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DPPD_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DPPD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DPPD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DPPD_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DPPD_ENABLE                     _MK_ENUM_CONST(1)

// Default: 0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DMPD_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DMPD_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_SELF_TEST_0_DMPD_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DMPD_RANGE                      12:12
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DMPD_WOFFSET                    0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DMPD_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DMPD_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DMPD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DMPD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DMPD_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DMPD_ENABLE                     _MK_ENUM_CONST(1)

// Unused
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DB16_8_SHIFT                    _MK_SHIFT_CONST(11)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DB16_8_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_SELF_TEST_0_DB16_8_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DB16_8_RANGE                    11:11
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DB16_8_WOFFSET                  0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DB16_8_DEFAULT                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DB16_8_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DB16_8_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_DB16_8_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Operational Mode
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_OPMODE_SHIFT                    _MK_SHIFT_CONST(8)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_OPMODE_FIELD                    (_MK_MASK_CONST(0x3) << APB_MISC_PP_USB_PHY_SELF_TEST_0_OPMODE_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_OPMODE_RANGE                    9:8
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_OPMODE_WOFFSET                  0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_OPMODE_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_OPMODE_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_OPMODE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_OPMODE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Suspend: Default: 1
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SUSP_SHIFT                      _MK_SHIFT_CONST(7)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SUSP_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_SELF_TEST_0_SUSP_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SUSP_RANGE                      7:7
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SUSP_WOFFSET                    0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SUSP_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SUSP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SUSP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_SUSP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Term_select
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TERM_SHIFT                      _MK_SHIFT_CONST(6)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TERM_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_SELF_TEST_0_TERM_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TERM_RANGE                      6:6
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TERM_WOFFSET                    0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TERM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TERM_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TERM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TERM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// XCVR_select:
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_XCVR_SHIFT                      _MK_SHIFT_CONST(4)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_XCVR_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_USB_PHY_SELF_TEST_0_XCVR_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_XCVR_RANGE                      5:4
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_XCVR_WOFFSET                    0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_XCVR_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_XCVR_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_XCVR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_XCVR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// When test is started, this status signal starts as  1 and is set to 0 if an error is detected. Can be sampled when TSTEND is  asserted.
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTPS_SHIFT                     _MK_SHIFT_CONST(3)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTPS_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTPS_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTPS_RANGE                     3:3
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTPS_WOFFSET                   0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTPS_DEFAULT                   _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTPS_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTPS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTPS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTPS_UNSET                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTPS_SET                       _MK_ENUM_CONST(1)

// Goes to 1 when the test finishes. At that time,  TSTPASS is valid and indicates the tests pass/fail status
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTEND_SHIFT                    _MK_SHIFT_CONST(2)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTEND_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTEND_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTEND_RANGE                    2:2
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTEND_WOFFSET                  0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTEND_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTEND_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTEND_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTEND_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTEND_UNSET                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTEND_SET                      _MK_ENUM_CONST(1)

// Sw writes a 1 to start the test. It writes a 0 to  end the test
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTON_SHIFT                     _MK_SHIFT_CONST(1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTON_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTON_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTON_RANGE                     1:1
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTON_WOFFSET                   0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTON_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTON_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTON_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTON_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTON_UNSET                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTON_SET                       _MK_ENUM_CONST(1)

// Default: 0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTENB_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTENB_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTENB_SHIFT)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTENB_RANGE                    0:0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTENB_WOFFSET                  0x0
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTENB_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTENB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTENB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTENB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTENB_DISABLE                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_SELF_TEST_0_TSTENB_ENABLE                   _MK_ENUM_CONST(1)


// Register APB_MISC_PP_USB_PHY_VBUS_SENSORS_0  
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0                      _MK_ADDR_CONST(0x70)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_WORD_COUNT                   0x1
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_RESET_MASK                   _MK_MASK_CONST(0x3f3f3f3f)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_READ_MASK                    _MK_MASK_CONST(0x3f3f3f3f)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_WRITE_MASK                   _MK_MASK_CONST(0x39393939)
// A_VBUS_VLD debounce A/B select.
// Selects between the two debounce values 
// UTMIP_BIAS_DEBOUNCE_A or
// UTMIP_BIAS_DEBOUNCE_B from the register
// UTMIP_DEBOUNCE_CFG0.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_SHIFT                   _MK_SHIFT_CONST(29)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_RANGE                   29:29
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_WOFFSET                 0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_SEL_A                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_SEL_B                   _MK_ENUM_CONST(1)

// A_VBUS_VLD software value.
// Software should write the appropriate
// value (1/0) to set/unset the A_VBUS_VLD status.
// This is only valid when A_VBUS_VLD_SW_EN is set.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_SHIFT                    _MK_SHIFT_CONST(28)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_RANGE                    28:28
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_WOFFSET                  0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_UNSET                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_SET                      _MK_ENUM_CONST(1)

// A_VBUS_VLD software enable.
// Enable Software Controlled A_VBUS_VLD.
// Software sets this bit to drive the
// value in A_VBUS_VLD_SW_VALUE to the USB
// controller.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_SHIFT                       _MK_SHIFT_CONST(27)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_RANGE                       27:27
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_WOFFSET                     0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_ENABLE                      _MK_ENUM_CONST(1)

// A_VBUS_VLD status.
// This is set to 1 whenever A_VBUS_VLD sensor
// output is 1.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_SHIFT                 _MK_SHIFT_CONST(26)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_RANGE                 26:26
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_WOFFSET                       0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_UNSET                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_SET                   _MK_ENUM_CONST(1)

// A_VBUS_VLD change detect.
// This field is set by hardware whenever a change
// is detected in the value of A_VBUS_VLD.
// software writes a 1 to clear it
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_SHIFT                     _MK_SHIFT_CONST(25)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_RANGE                     25:25
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_WOFFSET                   0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_UNSET                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_SET                       _MK_ENUM_CONST(1)

// A_VBUS_VLD interrupt enable.
// If this field is set to 1, an interrupt is
// generated whenever A_VBUS_VLD_CHG_DET is set to 1.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_SHIFT                      _MK_SHIFT_CONST(24)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_RANGE                      24:24
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_WOFFSET                    0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_ENABLE                     _MK_ENUM_CONST(1)

// A_SESS_VLD debounce A/B select.
// Selects between the two debounce values 
// UTMIP_BIAS_DEBOUNCE_A or
// UTMIP_BIAS_DEBOUNCE_B from the register
// UTMIP_DEBOUNCE_CFG0.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_SHIFT                   _MK_SHIFT_CONST(21)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_RANGE                   21:21
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_WOFFSET                 0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_SEL_A                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_SEL_B                   _MK_ENUM_CONST(1)

// A_SESS_VLD software value.
// Software should write the appropriate
// value (1/0) to set/unset the A_SESS_VLD status.
// This is only valid when A_SESS_VLD_SW_EN is set.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_SHIFT                    _MK_SHIFT_CONST(20)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_RANGE                    20:20
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_WOFFSET                  0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_UNSET                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_SET                      _MK_ENUM_CONST(1)

// A_SESS_VLD software enable.
// Enable Software Controlled A_SESS_VLD.
// Software sets this bit to drive the
// value in A_SESS_VLD_SW_VALUE to the USB
// controller.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_SHIFT                       _MK_SHIFT_CONST(19)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_RANGE                       19:19
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_WOFFSET                     0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_ENABLE                      _MK_ENUM_CONST(1)

// A_SESS_VLD status.
// This is set to 1 whenever A_SESS_VLD sensor
// output is 1.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_SHIFT                 _MK_SHIFT_CONST(18)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_RANGE                 18:18
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_WOFFSET                       0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_UNSET                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_SET                   _MK_ENUM_CONST(1)

// A_SESS_VLD change detect.
// This field is set by hardware whenever a change
// is detected in the value of A_SESS_VLD.
// software writes a 1 to clear it
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_SHIFT                     _MK_SHIFT_CONST(17)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_RANGE                     17:17
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_WOFFSET                   0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_UNSET                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_SET                       _MK_ENUM_CONST(1)

// A_SESS_VLD interrupt enable.
// If this field is set to 1, an interrupt is
// generated whenever A_SESS_VLD_CHG_DET is set to 1.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_SHIFT                      _MK_SHIFT_CONST(16)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_RANGE                      16:16
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_WOFFSET                    0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_ENABLE                     _MK_ENUM_CONST(1)

// B_SESS_VLD debounce A/B select.
// Selects between the two debounce values 
// UTMIP_BIAS_DEBOUNCE_A or
// UTMIP_BIAS_DEBOUNCE_B from the register
// UTMIP_DEBOUNCE_CFG0.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_SHIFT                   _MK_SHIFT_CONST(13)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_RANGE                   13:13
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_WOFFSET                 0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_SEL_A                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_SEL_B                   _MK_ENUM_CONST(1)

// B_SESS_VLD software value.
// Software should write the appropriate
// value (1/0) to set/unset the B_SESS_VLD status.
// This is only valid when B_SESS_VLD_SW_EN is set.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_SHIFT                    _MK_SHIFT_CONST(12)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_RANGE                    12:12
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_WOFFSET                  0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_UNSET                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_SET                      _MK_ENUM_CONST(1)

// B_SESS_VLD software enable.
// Enable Software Controlled B_SESS_VLD.
// Software sets this bit to drive the
// value in B_SESS_VLD_SW_VALUE to the USB
// controller.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_SHIFT                       _MK_SHIFT_CONST(11)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_RANGE                       11:11
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_WOFFSET                     0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_ENABLE                      _MK_ENUM_CONST(1)

// B_SESS_VLD status.
// This is set to 1 whenever B_SESS_VLD sensor
// output is 1.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_SHIFT                 _MK_SHIFT_CONST(10)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_RANGE                 10:10
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_WOFFSET                       0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_UNSET                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_SET                   _MK_ENUM_CONST(1)

// B_SESS_VLD change detect.
// This field is set by hardware whenever a change
// is detected in the value of B_SESS_VLD.
// software writes a 1 to clear it
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_SHIFT                     _MK_SHIFT_CONST(9)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_RANGE                     9:9
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_WOFFSET                   0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_UNSET                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_SET                       _MK_ENUM_CONST(1)

// B_SESS_VLD interrupt enable.
// If this field is set to 1, an interrupt is
// generated whenever B_SESS_VLD_CHG_DET is set to 1.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_SHIFT                      _MK_SHIFT_CONST(8)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_RANGE                      8:8
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_WOFFSET                    0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_ENABLE                     _MK_ENUM_CONST(1)

// B_SESS_END debounce A/B select
// Selects between the two debounce values 
// UTMIP_BIAS_DEBOUNCE_A or
// UTMIP_BIAS_DEBOUNCE_B from the register
// UTMIP_DEBOUNCE_CFG0.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_SHIFT                   _MK_SHIFT_CONST(5)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_RANGE                   5:5
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_WOFFSET                 0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_SEL_A                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_SEL_B                   _MK_ENUM_CONST(1)

// B_SESS_END software value
// Software should write the appropriate
// value (1/0) to set/unset the B_SESS_END status.
// This is only valid when B_SESS_END_SW_EN is set.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_SHIFT                    _MK_SHIFT_CONST(4)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_RANGE                    4:4
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_WOFFSET                  0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_UNSET                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_SET                      _MK_ENUM_CONST(1)

// B_SESS_END software enable.
// Enable Software Controlled B_SESS_END
// Software sets this bit to drive the
// value in B_SESS_END_SW_VALUE to the USB
// controller.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_SHIFT                       _MK_SHIFT_CONST(3)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_RANGE                       3:3
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_WOFFSET                     0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_ENABLE                      _MK_ENUM_CONST(1)

// B_SESS_END status.
// This is set to 1 whenever B_SESS_END sensor
// output is 1.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_SHIFT                 _MK_SHIFT_CONST(2)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_RANGE                 2:2
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_WOFFSET                       0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_UNSET                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_SET                   _MK_ENUM_CONST(1)

// B_SESS_END change detect.
// This field is set by hardware whenever a change
// is detected in the value of B_SESS_END.
// software writes a 1 to clear it
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_SHIFT                     _MK_SHIFT_CONST(1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_RANGE                     1:1
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_WOFFSET                   0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_UNSET                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_SET                       _MK_ENUM_CONST(1)

// B_SESS_END interrupt enable
// If this field is set to 1, an interrupt is
// generated whenever B_SESS_END_CHG_DET is set to 1.
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_SHIFT                      _MK_SHIFT_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_RANGE                      0:0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_WOFFSET                    0x0
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_ENABLE                     _MK_ENUM_CONST(1)


// Register APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0  
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0                    _MK_ADDR_CONST(0x74)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_WORD_COUNT                         0x1
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_RESET_VAL                  _MK_MASK_CONST(0x6000000)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_RESET_MASK                         _MK_MASK_CONST(0x3f3f3f3f)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_READ_MASK                  _MK_MASK_CONST(0x3f3f3f3f)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_WRITE_MASK                         _MK_MASK_CONST(0x3f393939)
// HS Tx to Tx inter-packet delay counter.
// Software should not change this.
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_IP_DELAY_TX2TX_HS_SHIFT                    _MK_SHIFT_CONST(24)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_IP_DELAY_TX2TX_HS_FIELD                    (_MK_MASK_CONST(0x3f) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_IP_DELAY_TX2TX_HS_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_IP_DELAY_TX2TX_HS_RANGE                    29:24
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_IP_DELAY_TX2TX_HS_WOFFSET                  0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_IP_DELAY_TX2TX_HS_DEFAULT                  _MK_MASK_CONST(0x6)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_IP_DELAY_TX2TX_HS_DEFAULT_MASK                     _MK_MASK_CONST(0x3f)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_IP_DELAY_TX2TX_HS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_IP_DELAY_TX2TX_HS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// VDAT_DET debounce A/B select.
// Selects between the two debounce values 
// UTMIP_BIAS_DEBOUNCE_A or
// UTMIP_BIAS_DEBOUNCE_B from the register
// UTMIP_DEBOUNCE_CFG0.
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_SHIFT                   _MK_SHIFT_CONST(21)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_RANGE                   21:21
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_WOFFSET                 0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_SEL_A                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_SEL_B                   _MK_ENUM_CONST(1)

// VDAT_DET software value.
// Software should write the appropriate
// value (1/0) to set/unset the VDAT_DET status.
// This is only valid when VDAT_DET_SW_EN is set.
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_SHIFT                    _MK_SHIFT_CONST(20)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_RANGE                    20:20
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_WOFFSET                  0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_UNSET                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_SET                      _MK_ENUM_CONST(1)

// VDAT_DET software enable.
// Enable Software Controlled VDAT_DET.
// Software sets this bit to drive the
// value in VDAT_DET_SW_VALUE to the USB
// controller
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_SHIFT                       _MK_SHIFT_CONST(19)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_RANGE                       19:19
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_WOFFSET                     0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_ENABLE                      _MK_ENUM_CONST(1)

// VDAT_DET status.
// This is set to 1 whenever VDAT_DET sensor
// output is 1.
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_SHIFT                 _MK_SHIFT_CONST(18)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_RANGE                 18:18
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_WOFFSET                       0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_UNSET                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_SET                   _MK_ENUM_CONST(1)

// VDAT_DET change detect.
// This field is set by hardware whenever a change
// is detected in the value of VDAT_DET.
// software writes a 1 to clear it
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_SHIFT                     _MK_SHIFT_CONST(17)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_RANGE                     17:17
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_WOFFSET                   0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_UNSET                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_SET                       _MK_ENUM_CONST(1)

// VDAT_DET interrupt enable.
// If this field is set to 1, an interrupt is
// generated whenever VDAT_DET_CHG_DET is set to 1.
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_SHIFT                      _MK_SHIFT_CONST(16)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_RANGE                      16:16
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_WOFFSET                    0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_ENABLE                     _MK_ENUM_CONST(1)

// VBUS_WAKEUP debounce A/B select.
// Selects between the two debounce values 
// UTMIP_BIAS_DEBOUNCE_A or
// UTMIP_BIAS_DEBOUNCE_B from the register
// UTMIP_DEBOUNCE_CFG0.
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_SHIFT                        _MK_SHIFT_CONST(13)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_RANGE                        13:13
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_WOFFSET                      0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_SEL_A                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_SEL_B                        _MK_ENUM_CONST(1)

// VBUS_WAKEUP software value.
// Software should write the appropriate
// value (1/0) to set/unset the VBUS_WAKEUP status.
// This is only valid when VBUS_WAKEUP_SW_EN is set.
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_SHIFT                 _MK_SHIFT_CONST(12)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_RANGE                 12:12
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_WOFFSET                       0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_UNSET                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_SET                   _MK_ENUM_CONST(1)

// VBUS_WAKEUP software enable.
// Enable Software Controlled VBUS_WAKEUP.
// Software sets this bit to drive the
// value in VBUS_WAKEUP_SW_VALUE to the USB
// controller.
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_SHIFT                    _MK_SHIFT_CONST(11)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_RANGE                    11:11
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_WOFFSET                  0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_DISABLE                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_ENABLE                   _MK_ENUM_CONST(1)

// VBUS_WAKEUP status.
// This is set to 1 whenever VBUS_WAKEUP sensor
// output is 1.
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_SHIFT                      _MK_SHIFT_CONST(10)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_RANGE                      10:10
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_WOFFSET                    0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_UNSET                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_SET                        _MK_ENUM_CONST(1)

// VBUS_WAKEUP change detect.
// This field is set by hardware whenever a change
// is detected in the value of VBUS_WAKEUP.
// software writes a 1 to clear it
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_SHIFT                  _MK_SHIFT_CONST(9)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_RANGE                  9:9
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_WOFFSET                        0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_UNSET                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_SET                    _MK_ENUM_CONST(1)

// VBUS_WAKEUP interrupt enable
// If this field is set to 1, an interrupt is
// generated whenever VBUS_WAKEUP_CHG_DET is set to 1.
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_SHIFT                   _MK_SHIFT_CONST(8)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_RANGE                   8:8
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_WOFFSET                 0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_ENABLE                  _MK_ENUM_CONST(1)

// ID debounce A/B select.
// Selects between the two debounce values 
// UTMIP_BIAS_DEBOUNCE_A or
// UTMIP_BIAS_DEBOUNCE_B from the register
// UTMIP_DEBOUNCE_CFG0.
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_SHIFT                 _MK_SHIFT_CONST(5)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_RANGE                 5:5
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_WOFFSET                       0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_SEL_A                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_SEL_B                 _MK_ENUM_CONST(1)

// ID software value.
// Software should write the appropriate
// value (1/0) to set/unset the ID status.
// This is only valid when ID_SW_EN is set.
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_SHIFT                  _MK_SHIFT_CONST(4)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_RANGE                  4:4
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_WOFFSET                        0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_UNSET                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_SET                    _MK_ENUM_CONST(1)

// ID software enable.
// Enable Software Controlled ID.
// Software sets this bit to drive the
// value in ID_SW_VALUE to the USB
// controller
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_SHIFT                     _MK_SHIFT_CONST(3)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_RANGE                     3:3
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_WOFFSET                   0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_ENABLE                    _MK_ENUM_CONST(1)

// ID status.
// This is set to 1 whenever ID sensor
// output is 1.
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_SHIFT                       _MK_SHIFT_CONST(2)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_RANGE                       2:2
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_WOFFSET                     0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_UNSET                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_SET                 _MK_ENUM_CONST(1)

// ID change detect.
// This field is set by hardware whenever a change
// is detected in the value of ID.
// software writes a 1 to clear it
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_SHIFT                   _MK_SHIFT_CONST(1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_RANGE                   1:1
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_WOFFSET                 0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_UNSET                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_SET                     _MK_ENUM_CONST(1)

// ID interrupt enable.
// If this field is set to 1, an interrupt is
// generated whenever ID_CHG_DET is set to 1.
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_SHIFT)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_RANGE                    0:0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_WOFFSET                  0x0
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_ENABLE                   _MK_ENUM_CONST(1)


// Register APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0  
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0                      _MK_ADDR_CONST(0x78)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_WORD_COUNT                   0x1
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_WRITE_MASK                   _MK_MASK_CONST(0xffffff80)
// Reserved
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_RSVD31_7_SHIFT                       _MK_SHIFT_CONST(7)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_RSVD31_7_FIELD                       (_MK_MASK_CONST(0x1ffffff) << APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_RSVD31_7_SHIFT)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_RSVD31_7_RANGE                       31:7
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_RSVD31_7_WOFFSET                     0x0
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_RSVD31_7_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_RSVD31_7_DEFAULT_MASK                        _MK_MASK_CONST(0x1ffffff)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_RSVD31_7_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_RSVD31_7_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_RSVD31_7_UNSET                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_RSVD31_7_SET                 _MK_ENUM_CONST(1)

// Avalid alternate status
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_AVALID_ALT_SHIFT                     _MK_SHIFT_CONST(6)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_AVALID_ALT_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_AVALID_ALT_SHIFT)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_AVALID_ALT_RANGE                     6:6
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_AVALID_ALT_WOFFSET                   0x0
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_AVALID_ALT_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_AVALID_ALT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_AVALID_ALT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_AVALID_ALT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_AVALID_ALT_UNSET                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_AVALID_ALT_SET                       _MK_ENUM_CONST(1)

// Bvalid alternate status
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_BVALID_ALT_SHIFT                     _MK_SHIFT_CONST(5)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_BVALID_ALT_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_BVALID_ALT_SHIFT)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_BVALID_ALT_RANGE                     5:5
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_BVALID_ALT_WOFFSET                   0x0
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_BVALID_ALT_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_BVALID_ALT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_BVALID_ALT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_BVALID_ALT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_BVALID_ALT_UNSET                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_BVALID_ALT_SET                       _MK_ENUM_CONST(1)

// ID alternate status
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_SHIFT                     _MK_SHIFT_CONST(4)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_SHIFT)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_RANGE                     4:4
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_WOFFSET                   0x0
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_UNSET                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_SET                       _MK_ENUM_CONST(1)

// Session end alternate status
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_SESS_END_ALT_SHIFT                   _MK_SHIFT_CONST(3)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_SESS_END_ALT_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_SESS_END_ALT_SHIFT)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_SESS_END_ALT_RANGE                   3:3
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_SESS_END_ALT_WOFFSET                 0x0
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_SESS_END_ALT_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_SESS_END_ALT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_SESS_END_ALT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_SESS_END_ALT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_SESS_END_ALT_UNSET                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_SESS_END_ALT_SET                     _MK_ENUM_CONST(1)

// Static GPI alternate status
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_SHIFT                 _MK_SHIFT_CONST(2)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_SHIFT)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_RANGE                 2:2
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_WOFFSET                       0x0
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_UNSET                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_SET                   _MK_ENUM_CONST(1)

// VBus valid alternate status
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_VALID_ALT_SHIFT                 _MK_SHIFT_CONST(1)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_VALID_ALT_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_VALID_ALT_SHIFT)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_VALID_ALT_RANGE                 1:1
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_VALID_ALT_WOFFSET                       0x0
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_VALID_ALT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_VALID_ALT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_VALID_ALT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_VALID_ALT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_VALID_ALT_UNSET                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_VALID_ALT_SET                   _MK_ENUM_CONST(1)

// Vbus wakeup alternate status
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_SHIFT                        _MK_SHIFT_CONST(0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_SHIFT)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_RANGE                        0:0
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_WOFFSET                      0x0
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_UNSET                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_SET                  _MK_ENUM_CONST(1)


// Register APB_MISC_PP_MISC_SAVE_THE_DAY_0  
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0                 _MK_ADDR_CONST(0x7c)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_WORD_COUNT                      0x1
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Reserved
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_A_SHIFT                    _MK_SHIFT_CONST(24)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_A_FIELD                    (_MK_MASK_CONST(0xff) << APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_A_SHIFT)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_A_RANGE                    31:24
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_A_WOFFSET                  0x0
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_A_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_A_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_A_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_A_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Reserved
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_B_SHIFT                    _MK_SHIFT_CONST(16)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_B_FIELD                    (_MK_MASK_CONST(0xff) << APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_B_SHIFT)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_B_RANGE                    23:16
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_B_WOFFSET                  0x0
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_B_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_B_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_B_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_B_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Reserved
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_C_SHIFT                    _MK_SHIFT_CONST(8)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_C_FIELD                    (_MK_MASK_CONST(0xff) << APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_C_SHIFT)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_C_RANGE                    15:8
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_C_WOFFSET                  0x0
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_C_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_C_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_C_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_C_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Reserved
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_D_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_D_FIELD                    (_MK_MASK_CONST(0xff) << APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_D_SHIFT)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_D_RANGE                    7:0
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_D_WOFFSET                  0x0
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_D_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_D_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_D_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_SAVE_THE_DAY_0_SAVE_THE_DAY_D_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APB_MISC_PP_PIN_MUX_CTL_A_0  
#define APB_MISC_PP_PIN_MUX_CTL_A_0                     _MK_ADDR_CONST(0x80)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_WORD_COUNT                  0x1
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_1_SHIFT                        _MK_SHIFT_CONST(30)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_1_FIELD                        (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_1_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_1_RANGE                        31:30
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_1_WOFFSET                      0x0
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_1_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_1_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCE_SEL_SHIFT                      _MK_SHIFT_CONST(28)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCE_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_A_0_KBCE_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCE_SEL_RANGE                      29:28
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCE_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCE_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCE_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCE_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCE_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCE_SEL_KBC                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCE_SEL_RSVD1                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCE_SEL_SDIO1                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCE_SEL_RSVD2                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCF_SEL_SHIFT                      _MK_SHIFT_CONST(26)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCF_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_A_0_KBCF_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCF_SEL_RANGE                      27:26
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCF_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCF_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCF_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCF_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCF_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCF_SEL_KBC                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCF_SEL_RSVD1                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCF_SEL_RSVD2                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_KBCF_SEL_MIO                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATA_SEL_SHIFT                       _MK_SHIFT_CONST(24)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATA_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_A_0_ATA_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATA_SEL_RANGE                       25:24
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATA_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATA_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATA_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATA_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATA_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATA_SEL_IDE                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATA_SEL_NAND                        _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATA_SEL_RSVD                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATA_SEL_NAND_ALT                    _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATC_SEL_SHIFT                       _MK_SHIFT_CONST(22)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATC_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_A_0_ATC_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATC_SEL_RANGE                       23:22
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATC_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATC_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATC_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATC_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATC_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATC_SEL_IDE                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATC_SEL_NAND                        _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATC_SEL_XIO                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATC_SEL_RSVD                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATD_SEL_SHIFT                       _MK_SHIFT_CONST(20)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATD_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_A_0_ATD_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATD_SEL_RANGE                       21:20
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATD_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATD_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATD_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATD_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATD_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATD_SEL_IDE                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATD_SEL_NAND                        _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATD_SEL_NAND_ALT                    _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATD_SEL_HSMMC                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_2_SHIFT                        _MK_SHIFT_CONST(18)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_2_FIELD                        (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_2_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_2_RANGE                        19:18
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_2_WOFFSET                      0x0
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_2_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_2_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATB_SEL_SHIFT                       _MK_SHIFT_CONST(16)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATB_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_A_0_ATB_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATB_SEL_RANGE                       17:16
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATB_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATB_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATB_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATB_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATB_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATB_SEL_IDE                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATB_SEL_NAND                        _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATB_SEL_NAND_ALT                    _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATB_SEL_HSMMC                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_A_0_RM_SEL_SHIFT                        _MK_SHIFT_CONST(14)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RM_SEL_FIELD                        (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_A_0_RM_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RM_SEL_RANGE                        15:14
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RM_SEL_WOFFSET                      0x0
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RM_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RM_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RM_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RM_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RM_SEL_I2C                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RM_SEL_RSVD1                        _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RM_SEL_RSVD2                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RM_SEL_RSVD3                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATE_SEL_SHIFT                       _MK_SHIFT_CONST(12)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATE_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_A_0_ATE_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATE_SEL_RANGE                       13:12
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATE_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATE_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATE_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATE_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATE_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATE_SEL_IDE                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATE_SEL_NAND                        _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATE_SEL_NAND_ALT                    _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_ATE_SEL_HSMMC                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_3_SHIFT                        _MK_SHIFT_CONST(8)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_3_FIELD                        (_MK_MASK_CONST(0xf) << APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_3_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_3_RANGE                        11:8
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_3_WOFFSET                      0x0
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_3_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_3_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_3_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_RSVD_3_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAD_SEL_SHIFT                       _MK_SHIFT_CONST(6)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAD_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_A_0_UAD_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAD_SEL_RANGE                       7:6
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAD_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAD_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAD_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAD_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAD_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAD_SEL_IRDA                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAD_SEL_SPDIF                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAD_SEL_UARTA                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAD_SEL_SFLASH                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAC_SEL_SHIFT                       _MK_SHIFT_CONST(4)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAC_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_A_0_UAC_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAC_SEL_RANGE                       5:4
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAC_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAC_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAC_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAC_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAC_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAC_SEL_RSVD1                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAC_SEL_RSVD2                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAC_SEL_RSVD3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAC_SEL_ULPI                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAB_SEL_SHIFT                       _MK_SHIFT_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAB_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_A_0_UAB_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAB_SEL_RANGE                       3:2
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAB_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAB_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAB_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAB_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAB_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAB_SEL_SPI2                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAB_SEL_MIPI_HS                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAB_SEL_UARTA                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAB_SEL_ULPI                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAA_SEL_SHIFT                       _MK_SHIFT_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAA_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_A_0_UAA_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAA_SEL_RANGE                       1:0
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAA_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAA_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAA_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAA_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAA_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAA_SEL_SPI3                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAA_SEL_MIPI_HS                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAA_SEL_UARTA                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_A_0_UAA_SEL_ULPI                        _MK_ENUM_CONST(3)


// Register APB_MISC_PP_PIN_MUX_CTL_B_0  
#define APB_MISC_PP_PIN_MUX_CTL_B_0                     _MK_ADDR_CONST(0x84)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_WORD_COUNT                  0x1
#define APB_MISC_PP_PIN_MUX_CTL_B_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_RESET_MASK                  _MK_MASK_CONST(0xfcffffff)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_READ_MASK                   _MK_MASK_CONST(0xfcffffff)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_WRITE_MASK                  _MK_MASK_CONST(0xfcffffff)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTE_SEL_SHIFT                       _MK_SHIFT_CONST(30)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTE_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_B_0_DTE_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTE_SEL_RANGE                       31:30
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTE_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTE_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTE_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTE_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTE_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTE_SEL_RSVD1                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTE_SEL_RSVD2                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTE_SEL_VI                  _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTE_SEL_SPI1                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTD_SEL_SHIFT                       _MK_SHIFT_CONST(28)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTD_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_B_0_DTD_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTD_SEL_RANGE                       29:28
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTD_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTD_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTD_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTD_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTD_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTD_SEL_RSVD1                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTD_SEL_SDIO1                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTD_SEL_VI                  _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTD_SEL_RSVD4                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTC_SEL_SHIFT                       _MK_SHIFT_CONST(26)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTC_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_B_0_DTC_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTC_SEL_RANGE                       27:26
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTC_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTC_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTC_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTC_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTC_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTC_SEL_RSVD1                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTC_SEL_RSVD2                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTC_SEL_VI                  _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTC_SEL_RSVD4                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTB_SEL_SHIFT                       _MK_SHIFT_CONST(22)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTB_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_B_0_DTB_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTB_SEL_RANGE                       23:22
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTB_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTB_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTB_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTB_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTB_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTB_SEL_RSVD1                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTB_SEL_RSVD2                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTB_SEL_VI                  _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTB_SEL_SPI1                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTA_SEL_SHIFT                       _MK_SHIFT_CONST(20)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTA_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_B_0_DTA_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTA_SEL_RANGE                       21:20
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTA_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTA_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTA_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTA_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTA_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTA_SEL_RSVD1                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTA_SEL_SDIO1                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTA_SEL_VI                  _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_DTA_SEL_RSVD4                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCB_SEL_SHIFT                       _MK_SHIFT_CONST(18)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCB_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_B_0_UCB_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCB_SEL_RANGE                       19:18
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCB_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCB_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCB_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCB_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCB_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCB_SEL_PWM0                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCB_SEL_RSVD2                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCB_SEL_RSVD3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCB_SEL_UARTC                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCA_SEL_SHIFT                       _MK_SHIFT_CONST(16)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCA_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_B_0_UCA_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCA_SEL_RANGE                       17:16
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCA_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCA_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCA_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCA_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCA_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCA_SEL_UARTC                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCA_SEL_RSVD1                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCA_SEL_RSVD2                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_UCA_SEL_RSVD3                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXK_SEL_SHIFT                      _MK_SHIFT_CONST(14)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXK_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_B_0_SLXK_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXK_SEL_RANGE                      15:14
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXK_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXK_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXK_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXK_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXK_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXK_SEL_SDIO1                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXK_SEL_SLINK4B                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXK_SEL_SDIO2                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXK_SEL_SPI2                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXD_SEL_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXD_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_B_0_SLXD_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXD_SEL_RANGE                      13:12
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXD_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXD_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXD_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXD_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXD_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXD_SEL_SDIO1                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXD_SEL_SLINK4B                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXD_SEL_SPDIF                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXD_SEL_SPI2                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXC_SEL_SHIFT                      _MK_SHIFT_CONST(10)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXC_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_B_0_SLXC_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXC_SEL_RANGE                      11:10
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXC_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXC_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXC_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXC_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXC_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXC_SEL_SDIO1                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXC_SEL_SLINK4B                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXC_SEL_SPDIF                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXC_SEL_SPI2                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXB_SEL_SHIFT                      _MK_SHIFT_CONST(8)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXB_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_B_0_SLXB_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXB_SEL_RANGE                      9:8
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXB_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXB_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXB_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXB_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXB_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXB_SEL_SDIO1                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXB_SEL_SLINK4B                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXB_SEL_SDIO2                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXB_SEL_SPI2                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXA_SEL_SHIFT                      _MK_SHIFT_CONST(6)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXA_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_B_0_SLXA_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXA_SEL_RANGE                      7:6
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXA_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXA_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXA_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXA_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXA_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXA_SEL_SDIO1                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXA_SEL_SLINK4B                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXA_SEL_SDIO2                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_SLXA_SEL_SPI2                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_B_0_HDINT_SEL_SHIFT                     _MK_SHIFT_CONST(4)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_HDINT_SEL_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_B_0_HDINT_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_HDINT_SEL_RANGE                     5:4
#define APB_MISC_PP_PIN_MUX_CTL_B_0_HDINT_SEL_WOFFSET                   0x0
#define APB_MISC_PP_PIN_MUX_CTL_B_0_HDINT_SEL_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_HDINT_SEL_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_HDINT_SEL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_HDINT_SEL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_HDINT_SEL_RSVD1                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_HDINT_SEL_DISPLAYA_HSYNC                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_HDINT_SEL_DISPLAYB_HSYNC                    _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_HDINT_SEL_RSVD2                     _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_B_0_RSVD_4_SHIFT                        _MK_SHIFT_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_RSVD_4_FIELD                        (_MK_MASK_CONST(0xf) << APB_MISC_PP_PIN_MUX_CTL_B_0_RSVD_4_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_RSVD_4_RANGE                        3:0
#define APB_MISC_PP_PIN_MUX_CTL_B_0_RSVD_4_WOFFSET                      0x0
#define APB_MISC_PP_PIN_MUX_CTL_B_0_RSVD_4_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_RSVD_4_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_RSVD_4_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_B_0_RSVD_4_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APB_MISC_PP_PIN_MUX_CTL_C_0  
#define APB_MISC_PP_PIN_MUX_CTL_C_0                     _MK_ADDR_CONST(0x88)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_WORD_COUNT                  0x1
#define APB_MISC_PP_PIN_MUX_CTL_C_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2S_SEL_SHIFT                      _MK_SHIFT_CONST(30)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2S_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_C_0_XM2S_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2S_SEL_RANGE                      31:30
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2S_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2S_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2S_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2S_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2S_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2S_SEL_DRAM                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2S_SEL_RSVD2                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2S_SEL_SPI                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2S_SEL_SPROM                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2A_SEL_SHIFT                      _MK_SHIFT_CONST(28)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2A_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_C_0_XM2A_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2A_SEL_RANGE                      29:28
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2A_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2A_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2A_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2A_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2A_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2A_SEL_DRAM                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2A_SEL_SPI3                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2A_SEL_SPI                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_XM2A_SEL_SPROM                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP4_SEL_SHIFT                      _MK_SHIFT_CONST(26)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP4_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_C_0_DAP4_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP4_SEL_RANGE                      27:26
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP4_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP4_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP4_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP4_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP4_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP4_SEL_DAP4                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP4_SEL_RSVD2                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP4_SEL_RSVD3                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP4_SEL_RSVD4                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP3_SEL_SHIFT                      _MK_SHIFT_CONST(24)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP3_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_C_0_DAP3_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP3_SEL_RANGE                      25:24
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP3_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP3_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP3_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP3_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP3_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP3_SEL_DAP3                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP3_SEL_RSVD2                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP3_SEL_RSVD3                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP3_SEL_RSVD4                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP2_SEL_SHIFT                      _MK_SHIFT_CONST(22)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP2_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_C_0_DAP2_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP2_SEL_RANGE                      23:22
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP2_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP2_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP2_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP2_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP2_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP2_SEL_DAP2                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP2_SEL_TWC                        _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP2_SEL_RSVD3                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP2_SEL_RSVD4                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP1_SEL_SHIFT                      _MK_SHIFT_CONST(20)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP1_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_C_0_DAP1_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP1_SEL_RANGE                      21:20
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP1_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP1_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP1_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP1_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP1_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP1_SEL_DAP1                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP1_SEL_RSVD2                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP1_SEL_RSVD3                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_DAP1_SEL_SDIO1                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRRX_SEL_SHIFT                      _MK_SHIFT_CONST(18)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRRX_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_C_0_IRRX_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRRX_SEL_RANGE                      19:18
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRRX_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRRX_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRRX_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRRX_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRRX_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRRX_SEL_UARTA                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRRX_SEL_RSVD2                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRRX_SEL_RSVD3                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRRX_SEL_UARTB                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRTX_SEL_SHIFT                      _MK_SHIFT_CONST(16)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRTX_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_C_0_IRTX_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRTX_SEL_RANGE                      17:16
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRTX_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRTX_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRTX_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRTX_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRTX_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRTX_SEL_UARTA                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRTX_SEL_RSVD2                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRTX_SEL_RSVD3                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_IRTX_SEL_UARTB                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCC_SEL_SHIFT                      _MK_SHIFT_CONST(14)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCC_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_C_0_KBCC_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCC_SEL_RANGE                      15:14
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCC_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCC_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCC_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCC_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCC_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCC_SEL_KBC                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCC_SEL_RSVD2                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCC_SEL_RSVD3                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCC_SEL_RSVD4                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCB_SEL_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCB_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_C_0_KBCB_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCB_SEL_RANGE                      13:12
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCB_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCB_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCB_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCB_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCB_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCB_SEL_KBC                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCB_SEL_RSVD2                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCB_SEL_SDIO1                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCB_SEL_MIO                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCA_SEL_SHIFT                      _MK_SHIFT_CONST(10)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCA_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_C_0_KBCA_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCA_SEL_RANGE                      11:10
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCA_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCA_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCA_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCA_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCA_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCA_SEL_KBC                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCA_SEL_RSVD2                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCA_SEL_RSVD3                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_KBCA_SEL_RSVD4                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_C_0_I2CP_SEL_SHIFT                      _MK_SHIFT_CONST(8)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_I2CP_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_C_0_I2CP_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_I2CP_SEL_RANGE                      9:8
#define APB_MISC_PP_PIN_MUX_CTL_C_0_I2CP_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_I2CP_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_I2CP_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_I2CP_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_I2CP_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_I2CP_SEL_I2C                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_I2CP_SEL_RSVD2                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_I2CP_SEL_RSVD3                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_I2CP_SEL_RSVD4                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSUS_SEL_SHIFT                      _MK_SHIFT_CONST(6)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSUS_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_C_0_CSUS_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSUS_SEL_RANGE                      7:6
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSUS_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSUS_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSUS_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSUS_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSUS_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSUS_SEL_PLLC_OUT1                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSUS_SEL_PLLP_OUT2                  _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSUS_SEL_PLLP_OUT3                  _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSUS_SEL_VI_SENSOR_CLK                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV2_SEL_SHIFT                     _MK_SHIFT_CONST(4)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV2_SEL_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV2_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV2_SEL_RANGE                     5:4
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV2_SEL_WOFFSET                   0x0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV2_SEL_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV2_SEL_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV2_SEL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV2_SEL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV2_SEL_OSC                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV2_SEL_AHB_CLK                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV2_SEL_APB_CLK                   _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV2_SEL_PLLP_OUT4                 _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV1_SEL_SHIFT                     _MK_SHIFT_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV1_SEL_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV1_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV1_SEL_RANGE                     3:2
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV1_SEL_WOFFSET                   0x0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV1_SEL_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV1_SEL_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV1_SEL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV1_SEL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV1_SEL_OSC                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV1_SEL_PLLA_OUT                  _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV1_SEL_PLLM_OUT1                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CDEV1_SEL_AUDIO_SYNC                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSYS_SEL_SHIFT                      _MK_SHIFT_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSYS_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_C_0_CSYS_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSYS_SEL_RANGE                      1:0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSYS_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSYS_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSYS_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSYS_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSYS_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSYS_SEL_RSVD1                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSYS_SEL_RSVD2                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSYS_SEL_RSVD3                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_C_0_CSYS_SEL_RSVD4                      _MK_ENUM_CONST(3)


// Register APB_MISC_PP_PIN_MUX_CTL_D_0  
#define APB_MISC_PP_PIN_MUX_CTL_D_0                     _MK_ADDR_CONST(0x8c)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_WORD_COUNT                  0x1
#define APB_MISC_PP_PIN_MUX_CTL_D_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIA_SEL_SHIFT                      _MK_SHIFT_CONST(30)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIA_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_D_0_SPIA_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIA_SEL_RANGE                      31:30
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIA_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIA_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIA_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIA_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIA_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIA_SEL_SPI1                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIA_SEL_SPI2                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIA_SEL_SPI3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIA_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIB_SEL_SHIFT                      _MK_SHIFT_CONST(28)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIB_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_D_0_SPIB_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIB_SEL_RANGE                      29:28
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIB_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIB_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIB_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIB_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIB_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIB_SEL_SPI1                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIB_SEL_SPI2                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIB_SEL_SPI3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIB_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIC_SEL_SHIFT                      _MK_SHIFT_CONST(26)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIC_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_D_0_SPIC_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIC_SEL_RANGE                      27:26
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIC_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIC_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIC_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIC_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIC_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIC_SEL_SPI1                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIC_SEL_SPI2                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIC_SEL_SPI3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIC_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPID_SEL_SHIFT                      _MK_SHIFT_CONST(24)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPID_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_D_0_SPID_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPID_SEL_RANGE                      25:24
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPID_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPID_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPID_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPID_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPID_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPID_SEL_SPI2                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPID_SEL_SPI1                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPID_SEL_SPI2_ALT                   _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPID_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIE_SEL_SHIFT                      _MK_SHIFT_CONST(22)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIE_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_D_0_SPIE_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIE_SEL_RANGE                      23:22
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIE_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIE_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIE_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIE_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIE_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIE_SEL_SPI2                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIE_SEL_SPI1                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIE_SEL_SPI2_ALT                   _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIE_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIF_SEL_SHIFT                      _MK_SHIFT_CONST(20)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIF_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_D_0_SPIF_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIF_SEL_RANGE                      21:20
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIF_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIF_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIF_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIF_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIF_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIF_SEL_SPI3                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIF_SEL_SPI1                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIF_SEL_SPI2                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIF_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIG_SEL_SHIFT                      _MK_SHIFT_CONST(18)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIG_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_D_0_SPIG_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIG_SEL_RANGE                      19:18
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIG_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIG_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIG_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIG_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIG_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIG_SEL_SPI3                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIG_SEL_SPI2                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIG_SEL_SPI2_ALT                   _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIG_SEL_I2C                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIH_SEL_SHIFT                      _MK_SHIFT_CONST(16)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIH_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_D_0_SPIH_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIH_SEL_RANGE                      17:16
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIH_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIH_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIH_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIH_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIH_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIH_SEL_SPI3                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIH_SEL_SPI2                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIH_SEL_SPI2_ALT                   _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPIH_SEL_I2C                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDD_SEL_SHIFT                       _MK_SHIFT_CONST(14)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDD_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_D_0_SDD_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDD_SEL_RANGE                       15:14
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDD_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDD_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDD_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDD_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDD_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDD_SEL_UARTA                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDD_SEL_PWM                 _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDD_SEL_SDIO2                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDD_SEL_SPI3                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDC_SEL_SHIFT                       _MK_SHIFT_CONST(12)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDC_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_D_0_SDC_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDC_SEL_RANGE                       13:12
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDC_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDC_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDC_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDC_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDC_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDC_SEL_PWM                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDC_SEL_TWC                 _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDC_SEL_SDIO2                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDC_SEL_SPI3                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDB_SEL_SHIFT                       _MK_SHIFT_CONST(10)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDB_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_D_0_SDB_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDB_SEL_RANGE                       11:10
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDB_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDB_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDB_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDB_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDB_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDB_SEL_SDIO2                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDB_SEL_RSVD                        _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDB_SEL_SDIO2_ALT                   _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SDB_SEL_RSVD4                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDI_SEL_SHIFT                      _MK_SHIFT_CONST(8)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDI_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_D_0_SPDI_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDI_SEL_RANGE                      9:8
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDI_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDI_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDI_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDI_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDI_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDI_SEL_SPDIF                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDI_SEL_RSVD                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDI_SEL_I2C                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDI_SEL_SDIO1                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDO_SEL_SHIFT                      _MK_SHIFT_CONST(6)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDO_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_D_0_SPDO_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDO_SEL_RANGE                      7:6
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDO_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDO_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDO_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDO_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDO_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDO_SEL_SPDIF                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDO_SEL_RSVD                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDO_SEL_I2C                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_SPDO_SEL_SDIO1                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPU_SEL_SHIFT                       _MK_SHIFT_CONST(4)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPU_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_D_0_GPU_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPU_SEL_RANGE                       5:4
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPU_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPU_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPU_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPU_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPU_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPU_SEL_RSVD                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPU_SEL_UARTA                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPU_SEL_RSVD3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPU_SEL_RSVD4                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPV_SEL_SHIFT                       _MK_SHIFT_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPV_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_D_0_GPV_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPV_SEL_RANGE                       3:2
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPV_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPV_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPV_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPV_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPV_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPV_SEL_GPIO_PORT_V                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPV_SEL_RSVD2                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPV_SEL_RSVD3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_GPV_SEL_RSVD4                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_D_0_DBG_SEL_SHIFT                       _MK_SHIFT_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_DBG_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_D_0_DBG_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_DBG_SEL_RANGE                       1:0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_DBG_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_D_0_DBG_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_DBG_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_DBG_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_DBG_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_DBG_SEL_JTAG                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_DBG_SEL_RSVD2                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_DBG_SEL_RSVD3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_D_0_DBG_SEL_RSVD4                       _MK_ENUM_CONST(3)


// Register APB_MISC_PP_PIN_MUX_CTL_E_0  
#define APB_MISC_PP_PIN_MUX_CTL_E_0                     _MK_ADDR_CONST(0x90)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_WORD_COUNT                  0x1
#define APB_MISC_PP_PIN_MUX_CTL_E_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVP0_SEL_SHIFT                      _MK_SHIFT_CONST(30)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVP0_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_E_0_LVP0_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVP0_SEL_RANGE                      31:30
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVP0_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVP0_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVP0_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVP0_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVP0_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVP0_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVP0_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVP0_SEL_I2C2                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVP0_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM1_SEL_SHIFT                       _MK_SHIFT_CONST(28)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM1_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_E_0_LM1_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM1_SEL_RANGE                       29:28
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM1_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM1_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM1_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM1_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM1_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM1_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM1_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM1_SEL_I2C2                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM1_SEL_CRT                 _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM0_SEL_SHIFT                       _MK_SHIFT_CONST(26)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM0_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_E_0_LM0_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM0_SEL_RANGE                       27:26
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM0_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM0_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM0_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM0_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM0_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM0_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM0_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM0_SEL_SPI3                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LM0_SEL_RSVD                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVS_SEL_SHIFT                       _MK_SHIFT_CONST(24)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVS_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_E_0_LVS_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVS_SEL_RANGE                       25:24
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVS_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVS_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVS_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVS_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVS_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVS_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVS_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVS_SEL_XIO                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LVS_SEL_CRT                 _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_E_0_LHS_SEL_SHIFT                       _MK_SHIFT_CONST(22)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LHS_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_E_0_LHS_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LHS_SEL_RANGE                       23:22
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LHS_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LHS_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LHS_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LHS_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LHS_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LHS_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LHS_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LHS_SEL_XIO                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LHS_SEL_CRT                 _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC1_SEL_SHIFT                      _MK_SHIFT_CONST(20)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC1_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_E_0_LSC1_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC1_SEL_RANGE                      21:20
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC1_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC1_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC1_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC1_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC1_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC1_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC1_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC1_SEL_SPI3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC1_SEL_HDMI                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC0_SEL_SHIFT                      _MK_SHIFT_CONST(18)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC0_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_E_0_LSC0_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC0_SEL_RANGE                      19:18
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC0_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC0_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC0_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC0_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC0_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC0_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC0_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC0_SEL_XIO                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSC0_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSCK_SEL_SHIFT                      _MK_SHIFT_CONST(16)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSCK_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_E_0_LSCK_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSCK_SEL_RANGE                      17:16
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSCK_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSCK_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSCK_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSCK_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSCK_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSCK_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSCK_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSCK_SEL_SPI3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSCK_SEL_HDMI                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_E_0_LDC_SEL_SHIFT                       _MK_SHIFT_CONST(14)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LDC_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_E_0_LDC_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LDC_SEL_RANGE                       15:14
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LDC_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LDC_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LDC_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LDC_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LDC_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LDC_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LDC_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LDC_SEL_RSVD                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LDC_SEL_RSVD4                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_E_0_LCSN_SEL_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LCSN_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_E_0_LCSN_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LCSN_SEL_RANGE                      13:12
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LCSN_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LCSN_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LCSN_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LCSN_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LCSN_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LCSN_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LCSN_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LCSN_SEL_SPI3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LCSN_SEL_CRT                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSPI_SEL_SHIFT                      _MK_SHIFT_CONST(10)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSPI_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_E_0_LSPI_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSPI_SEL_RANGE                      11:10
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSPI_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSPI_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSPI_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSPI_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSPI_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSPI_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSPI_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSPI_SEL_XIO                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSPI_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDA_SEL_SHIFT                      _MK_SHIFT_CONST(8)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDA_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_E_0_LSDA_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDA_SEL_RANGE                      9:8
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDA_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDA_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDA_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDA_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDA_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDA_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDA_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDA_SEL_SPI3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDA_SEL_HDMI                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDI_SEL_SHIFT                      _MK_SHIFT_CONST(6)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDI_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_E_0_LSDI_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDI_SEL_RANGE                      7:6
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDI_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDI_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDI_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDI_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDI_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDI_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDI_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDI_SEL_SPI3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LSDI_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW2_SEL_SHIFT                      _MK_SHIFT_CONST(4)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW2_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_E_0_LPW2_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW2_SEL_RANGE                      5:4
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW2_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW2_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW2_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW2_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW2_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW2_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW2_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW2_SEL_SPI3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW2_SEL_HDMI                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW1_SEL_SHIFT                      _MK_SHIFT_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW1_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_E_0_LPW1_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW1_SEL_RANGE                      3:2
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW1_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW1_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW1_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW1_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW1_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW1_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW1_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW1_SEL_RSVD                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW1_SEL_CRT                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW0_SEL_SHIFT                      _MK_SHIFT_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW0_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_E_0_LPW0_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW0_SEL_RANGE                      1:0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW0_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW0_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW0_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW0_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW0_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW0_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW0_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW0_SEL_SPI3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_E_0_LPW0_SEL_HDMI                       _MK_ENUM_CONST(3)


// Register APB_MISC_PP_PIN_MUX_CTL_F_0  
#define APB_MISC_PP_PIN_MUX_CTL_F_0                     _MK_ADDR_CONST(0x94)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_WORD_COUNT                  0x1
#define APB_MISC_PP_PIN_MUX_CTL_F_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD15_SEL_SHIFT                      _MK_SHIFT_CONST(30)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD15_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_F_0_LD15_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD15_SEL_RANGE                      31:30
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD15_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD15_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD15_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD15_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD15_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD15_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD15_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD15_SEL_XIO                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD15_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD14_SEL_SHIFT                      _MK_SHIFT_CONST(28)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD14_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_F_0_LD14_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD14_SEL_RANGE                      29:28
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD14_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD14_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD14_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD14_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD14_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD14_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD14_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD14_SEL_XIO                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD14_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD13_SEL_SHIFT                      _MK_SHIFT_CONST(26)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD13_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_F_0_LD13_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD13_SEL_RANGE                      27:26
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD13_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD13_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD13_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD13_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD13_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD13_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD13_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD13_SEL_XIO                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD13_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD12_SEL_SHIFT                      _MK_SHIFT_CONST(24)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD12_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_F_0_LD12_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD12_SEL_RANGE                      25:24
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD12_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD12_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD12_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD12_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD12_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD12_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD12_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD12_SEL_XIO                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD12_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD11_SEL_SHIFT                      _MK_SHIFT_CONST(22)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD11_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_F_0_LD11_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD11_SEL_RANGE                      23:22
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD11_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD11_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD11_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD11_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD11_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD11_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD11_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD11_SEL_XIO                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD11_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD10_SEL_SHIFT                      _MK_SHIFT_CONST(20)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD10_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_F_0_LD10_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD10_SEL_RANGE                      21:20
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD10_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD10_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD10_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD10_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD10_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD10_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD10_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD10_SEL_XIO                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD10_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD9_SEL_SHIFT                       _MK_SHIFT_CONST(18)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD9_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_F_0_LD9_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD9_SEL_RANGE                       19:18
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD9_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD9_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD9_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD9_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD9_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD9_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD9_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD9_SEL_XIO                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD9_SEL_RSVD                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD8_SEL_SHIFT                       _MK_SHIFT_CONST(16)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD8_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_F_0_LD8_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD8_SEL_RANGE                       17:16
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD8_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD8_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD8_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD8_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD8_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD8_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD8_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD8_SEL_XIO                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD8_SEL_RSVD                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD7_SEL_SHIFT                       _MK_SHIFT_CONST(14)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD7_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_F_0_LD7_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD7_SEL_RANGE                       15:14
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD7_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD7_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD7_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD7_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD7_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD7_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD7_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD7_SEL_XIO                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD7_SEL_RSVD                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD6_SEL_SHIFT                       _MK_SHIFT_CONST(12)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD6_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_F_0_LD6_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD6_SEL_RANGE                       13:12
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD6_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD6_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD6_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD6_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD6_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD6_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD6_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD6_SEL_XIO                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD6_SEL_RSVD                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD5_SEL_SHIFT                       _MK_SHIFT_CONST(10)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD5_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_F_0_LD5_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD5_SEL_RANGE                       11:10
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD5_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD5_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD5_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD5_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD5_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD5_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD5_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD5_SEL_XIO                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD5_SEL_RSVD                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD4_SEL_SHIFT                       _MK_SHIFT_CONST(8)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD4_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_F_0_LD4_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD4_SEL_RANGE                       9:8
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD4_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD4_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD4_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD4_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD4_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD4_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD4_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD4_SEL_XIO                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD4_SEL_RSVD                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD3_SEL_SHIFT                       _MK_SHIFT_CONST(6)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD3_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_F_0_LD3_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD3_SEL_RANGE                       7:6
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD3_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD3_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD3_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD3_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD3_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD3_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD3_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD3_SEL_XIO                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD3_SEL_RSVD                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD2_SEL_SHIFT                       _MK_SHIFT_CONST(4)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD2_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_F_0_LD2_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD2_SEL_RANGE                       5:4
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD2_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD2_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD2_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD2_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD2_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD2_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD2_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD2_SEL_XIO                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD2_SEL_RSVD                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD1_SEL_SHIFT                       _MK_SHIFT_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD1_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_F_0_LD1_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD1_SEL_RANGE                       3:2
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD1_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD1_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD1_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD1_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD1_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD1_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD1_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD1_SEL_XIO                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD1_SEL_RSVD                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD0_SEL_SHIFT                       _MK_SHIFT_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD0_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_F_0_LD0_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD0_SEL_RANGE                       1:0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD0_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD0_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD0_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD0_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD0_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD0_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD0_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD0_SEL_XIO                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_F_0_LD0_SEL_RSVD                        _MK_ENUM_CONST(3)


// Register APB_MISC_PP_PIN_MUX_CTL_G_0  
#define APB_MISC_PP_PIN_MUX_CTL_G_0                     _MK_ADDR_CONST(0x98)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_WORD_COUNT                  0x1
#define APB_MISC_PP_PIN_MUX_CTL_G_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_RESET_MASK                  _MK_MASK_CONST(0xfcffcfff)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_READ_MASK                   _MK_MASK_CONST(0xfcffcfff)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_WRITE_MASK                  _MK_MASK_CONST(0xfcffcfff)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_DTF_SEL_SHIFT                       _MK_SHIFT_CONST(30)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_DTF_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_G_0_DTF_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_DTF_SEL_RANGE                       31:30
#define APB_MISC_PP_PIN_MUX_CTL_G_0_DTF_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_G_0_DTF_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_DTF_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_DTF_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_DTF_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_DTF_SEL_RSVD1                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_DTF_SEL_RSVD2                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_DTF_SEL_VI                  _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_DTF_SEL_I2C2                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_G_0_GPU7_SEL_SHIFT                      _MK_SHIFT_CONST(28)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_GPU7_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_G_0_GPU7_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_GPU7_SEL_RANGE                      29:28
#define APB_MISC_PP_PIN_MUX_CTL_G_0_GPU7_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_G_0_GPU7_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_GPU7_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_GPU7_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_GPU7_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_GPU7_SEL_RTCK                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_GPU7_SEL_RSVD1                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_GPU7_SEL_RSVD2                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_GPU7_SEL_RSVD3                      _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_G_0_KBCD_SEL_SHIFT                      _MK_SHIFT_CONST(26)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_KBCD_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_G_0_KBCD_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_KBCD_SEL_RANGE                      27:26
#define APB_MISC_PP_PIN_MUX_CTL_G_0_KBCD_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_G_0_KBCD_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_KBCD_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_KBCD_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_KBCD_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_KBCD_SEL_KBC                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_KBCD_SEL_RSVD2                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_KBCD_SEL_SDIO1                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_KBCD_SEL_MIO                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_G_0_PTA_SEL_SHIFT                       _MK_SHIFT_CONST(22)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PTA_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_G_0_PTA_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PTA_SEL_RANGE                       23:22
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PTA_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PTA_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PTA_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PTA_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PTA_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PTA_SEL_I2C2                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PTA_SEL_HDMI                        _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PTA_SEL_RSVD1                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PTA_SEL_RSVD2                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_G_0_RSVD_5_SHIFT                        _MK_SHIFT_CONST(20)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_RSVD_5_FIELD                        (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_G_0_RSVD_5_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_RSVD_5_RANGE                        21:20
#define APB_MISC_PP_PIN_MUX_CTL_G_0_RSVD_5_WOFFSET                      0x0
#define APB_MISC_PP_PIN_MUX_CTL_G_0_RSVD_5_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_RSVD_5_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_RSVD_5_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_RSVD_5_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define APB_MISC_PP_PIN_MUX_CTL_G_0_PMC_SEL_SHIFT                       _MK_SHIFT_CONST(18)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PMC_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_G_0_PMC_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PMC_SEL_RANGE                       19:18
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PMC_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PMC_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PMC_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PMC_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PMC_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PMC_SEL_PWR_ON                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_PMC_SEL_PWR_INTR                    _MK_ENUM_CONST(1)

#define APB_MISC_PP_PIN_MUX_CTL_G_0_LDI_SEL_SHIFT                       _MK_SHIFT_CONST(16)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LDI_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_G_0_LDI_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LDI_SEL_RANGE                       17:16
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LDI_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LDI_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LDI_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LDI_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LDI_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LDI_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LDI_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LDI_SEL_SPI1                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LDI_SEL_RSVD                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_G_0_LPP_SEL_SHIFT                       _MK_SHIFT_CONST(14)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LPP_SEL_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_G_0_LPP_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LPP_SEL_RANGE                       15:14
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LPP_SEL_WOFFSET                     0x0
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LPP_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LPP_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LPP_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LPP_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LPP_SEL_DISPLAYA                    _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LPP_SEL_DISPLAYB                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LPP_SEL_SPI1                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LPP_SEL_RSVD                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP0_SEL_SHIFT                      _MK_SHIFT_CONST(10)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP0_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_G_0_LHP0_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP0_SEL_RANGE                      11:10
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP0_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP0_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP0_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP0_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP0_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP0_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP0_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP0_SEL_SPI1                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP0_SEL_I2C2                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_G_0_LVP1_SEL_SHIFT                      _MK_SHIFT_CONST(8)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LVP1_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_G_0_LVP1_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LVP1_SEL_RANGE                      9:8
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LVP1_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LVP1_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LVP1_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LVP1_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LVP1_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LVP1_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LVP1_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LVP1_SEL_SPI1                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LVP1_SEL_I2C2                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP2_SEL_SHIFT                      _MK_SHIFT_CONST(6)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP2_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_G_0_LHP2_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP2_SEL_RANGE                      7:6
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP2_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP2_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP2_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP2_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP2_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP2_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP2_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP2_SEL_SPI1                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP2_SEL_CRT                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP1_SEL_SHIFT                      _MK_SHIFT_CONST(4)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP1_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_G_0_LHP1_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP1_SEL_RANGE                      5:4
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP1_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP1_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP1_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP1_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP1_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP1_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP1_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP1_SEL_SPI1                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LHP1_SEL_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD17_SEL_SHIFT                      _MK_SHIFT_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD17_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_G_0_LD17_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD17_SEL_RANGE                      3:2
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD17_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD17_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD17_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD17_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD17_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD17_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD17_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD17_SEL_RSVD                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD17_SEL_RSVD_ALT                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD16_SEL_SHIFT                      _MK_SHIFT_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD16_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_G_0_LD16_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD16_SEL_RANGE                      1:0
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD16_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD16_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD16_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD16_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD16_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD16_SEL_DISPLAYA                   _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD16_SEL_DISPLAYB                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD16_SEL_XIO                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_G_0_LD16_SEL_RSVD                       _MK_ENUM_CONST(3)


// Register APB_MISC_PP_PIN_MUX_CTL_H_0  
#define APB_MISC_PP_PIN_MUX_CTL_H_0                     _MK_ADDR_CONST(0x9c)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_WORD_COUNT                  0x1
#define APB_MISC_PP_PIN_MUX_CTL_H_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_RSVD_6_SHIFT                        _MK_SHIFT_CONST(22)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_RSVD_6_FIELD                        (_MK_MASK_CONST(0x3ff) << APB_MISC_PP_PIN_MUX_CTL_H_0_RSVD_6_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_RSVD_6_RANGE                        31:22
#define APB_MISC_PP_PIN_MUX_CTL_H_0_RSVD_6_WOFFSET                      0x0
#define APB_MISC_PP_PIN_MUX_CTL_H_0_RSVD_6_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_RSVD_6_DEFAULT_MASK                 _MK_MASK_CONST(0x3ff)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_RSVD_6_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_RSVD_6_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4M_SEL_SHIFT                     _MK_SHIFT_CONST(21)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4M_SEL_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4M_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4M_SEL_RANGE                     21:21
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4M_SEL_WOFFSET                   0x0
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4M_SEL_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4M_SEL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4M_SEL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4M_SEL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4M_SEL_DAP4_SLAVE                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4M_SEL_DAP4_MASTER                       _MK_ENUM_CONST(1)

#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3M_SEL_SHIFT                     _MK_SHIFT_CONST(20)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3M_SEL_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3M_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3M_SEL_RANGE                     20:20
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3M_SEL_WOFFSET                   0x0
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3M_SEL_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3M_SEL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3M_SEL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3M_SEL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3M_SEL_DAP3_SLAVE                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3M_SEL_DAP3_MASTER                       _MK_ENUM_CONST(1)

#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2M_SEL_SHIFT                     _MK_SHIFT_CONST(19)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2M_SEL_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2M_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2M_SEL_RANGE                     19:19
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2M_SEL_WOFFSET                   0x0
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2M_SEL_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2M_SEL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2M_SEL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2M_SEL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2M_SEL_DAP2_SLAVE                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2M_SEL_DAP2_MASTER                       _MK_ENUM_CONST(1)

#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1M_SEL_SHIFT                     _MK_SHIFT_CONST(18)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1M_SEL_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1M_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1M_SEL_RANGE                     18:18
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1M_SEL_WOFFSET                   0x0
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1M_SEL_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1M_SEL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1M_SEL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1M_SEL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1M_SEL_DAP1_SLAVE                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1M_SEL_DAP1_MASTER                       _MK_ENUM_CONST(1)

#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC3_SEL_SHIFT                      _MK_SHIFT_CONST(16)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC3_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_H_0_DAC3_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC3_SEL_RANGE                      17:16
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC3_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC3_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC3_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC3_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC3_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC3_SEL_DAP1                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC3_SEL_DAP2                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC3_SEL_DAP3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC3_SEL_DAP4                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC2_SEL_SHIFT                      _MK_SHIFT_CONST(14)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC2_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_H_0_DAC2_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC2_SEL_RANGE                      15:14
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC2_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC2_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC2_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC2_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC2_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC2_SEL_DAP1                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC2_SEL_DAP2                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC2_SEL_DAP3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC2_SEL_DAP4                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC1_SEL_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC1_SEL_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PIN_MUX_CTL_H_0_DAC1_SEL_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC1_SEL_RANGE                      13:12
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC1_SEL_WOFFSET                    0x0
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC1_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC1_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC1_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC1_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC1_SEL_DAP1                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC1_SEL_DAP2                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC1_SEL_DAP3                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAC1_SEL_DAP4                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_SHIFT                 _MK_SHIFT_CONST(9)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_FIELD                 (_MK_MASK_CONST(0x7) << APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_RANGE                 11:9
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_WOFFSET                       0x0
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_DAC1                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_DAC2                  _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_DAC3                  _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_RSVD                  _MK_ENUM_CONST(3)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_DAP1                  _MK_ENUM_CONST(4)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_DAP2                  _MK_ENUM_CONST(5)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_DAP3                  _MK_ENUM_CONST(6)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP4_CNTRL_MUX_SELECT_RSVD2                 _MK_ENUM_CONST(7)

#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_SHIFT                 _MK_SHIFT_CONST(6)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_FIELD                 (_MK_MASK_CONST(0x7) << APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_RANGE                 8:6
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_WOFFSET                       0x0
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_DAC1                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_DAC2                  _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_DAC3                  _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_RSVD1                 _MK_ENUM_CONST(3)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_DAP1                  _MK_ENUM_CONST(4)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_DAP2                  _MK_ENUM_CONST(5)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_RSVD2                 _MK_ENUM_CONST(6)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP3_CNTRL_MUX_SELECT_DAP4                  _MK_ENUM_CONST(7)

#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_SHIFT                 _MK_SHIFT_CONST(3)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_FIELD                 (_MK_MASK_CONST(0x7) << APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_RANGE                 5:3
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_WOFFSET                       0x0
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_DAC1                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_DAC2                  _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_DAC3                  _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_RSVD1                 _MK_ENUM_CONST(3)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_DAP1                  _MK_ENUM_CONST(4)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_RSVD2                 _MK_ENUM_CONST(5)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_DAP3                  _MK_ENUM_CONST(6)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP2_CNTRL_MUX_SELECT_DAP4                  _MK_ENUM_CONST(7)

#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_SHIFT                 _MK_SHIFT_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_FIELD                 (_MK_MASK_CONST(0x7) << APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_SHIFT)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_RANGE                 2:0
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_WOFFSET                       0x0
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_DAC1                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_DAC2                  _MK_ENUM_CONST(1)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_DAC3                  _MK_ENUM_CONST(2)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_RSVD1                 _MK_ENUM_CONST(3)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_RSVD2                 _MK_ENUM_CONST(4)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_DAP2                  _MK_ENUM_CONST(5)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_DAP3                  _MK_ENUM_CONST(6)
#define APB_MISC_PP_PIN_MUX_CTL_H_0_DAP1_CNTRL_MUX_SELECT_DAP4                  _MK_ENUM_CONST(7)


// Register APB_MISC_PP_PULLUPDOWN_REG_A_0  
#define APB_MISC_PP_PULLUPDOWN_REG_A_0                  _MK_ADDR_CONST(0xa0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_WORD_COUNT                       0x1
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_RESET_VAL                        _MK_MASK_CONST(0x215556aa)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_GPV_PU_PD_SHIFT                  _MK_SHIFT_CONST(30)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_GPV_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_A_0_GPV_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_GPV_PU_PD_RANGE                  31:30
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_GPV_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_GPV_PU_PD_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_GPV_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_GPV_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_GPV_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_GPV_PU_PD_INIT_ENUM                      NORMAL
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_GPV_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_GPV_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_GPV_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_GPV_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTF_PU_PD_SHIFT                  _MK_SHIFT_CONST(28)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTF_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_A_0_DTF_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTF_PU_PD_RANGE                  29:28
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTF_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTF_PU_PD_DEFAULT                        _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTF_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTF_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTF_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTF_PU_PD_INIT_ENUM                      PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTF_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTF_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTF_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTF_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTE_PU_PD_SHIFT                  _MK_SHIFT_CONST(26)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTE_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_A_0_DTE_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTE_PU_PD_RANGE                  27:26
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTE_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTE_PU_PD_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTE_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTE_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTE_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTE_PU_PD_INIT_ENUM                      NORMAL
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTE_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTE_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTE_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTE_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTD_PU_PD_SHIFT                  _MK_SHIFT_CONST(24)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTD_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_A_0_DTD_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTD_PU_PD_RANGE                  25:24
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTD_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTD_PU_PD_DEFAULT                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTD_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTD_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTD_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTD_PU_PD_INIT_ENUM                      PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTD_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTD_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTD_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTD_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTC_PU_PD_SHIFT                  _MK_SHIFT_CONST(22)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTC_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_A_0_DTC_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTC_PU_PD_RANGE                  23:22
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTC_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTC_PU_PD_DEFAULT                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTC_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTC_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTC_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTC_PU_PD_INIT_ENUM                      PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTC_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTC_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTC_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTC_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTB_PU_PD_SHIFT                  _MK_SHIFT_CONST(20)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTB_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_A_0_DTB_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTB_PU_PD_RANGE                  21:20
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTB_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTB_PU_PD_DEFAULT                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTB_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTB_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTB_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTB_PU_PD_INIT_ENUM                      PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTB_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTB_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTB_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTB_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTA_PU_PD_SHIFT                  _MK_SHIFT_CONST(18)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTA_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_A_0_DTA_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTA_PU_PD_RANGE                  19:18
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTA_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTA_PU_PD_DEFAULT                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTA_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTA_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTA_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTA_PU_PD_INIT_ENUM                      PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTA_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTA_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTA_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DTA_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP4_PU_PD_SHIFT                 _MK_SHIFT_CONST(16)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP4_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP4_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP4_PU_PD_RANGE                 17:16
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP4_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP4_PU_PD_DEFAULT                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP4_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP4_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP4_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP4_PU_PD_INIT_ENUM                     PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP4_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP4_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP4_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP4_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP3_PU_PD_SHIFT                 _MK_SHIFT_CONST(14)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP3_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP3_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP3_PU_PD_RANGE                 15:14
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP3_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP3_PU_PD_DEFAULT                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP3_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP3_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP3_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP3_PU_PD_INIT_ENUM                     PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP3_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP3_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP3_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP3_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP2_PU_PD_SHIFT                 _MK_SHIFT_CONST(12)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP2_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP2_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP2_PU_PD_RANGE                 13:12
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP2_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP2_PU_PD_DEFAULT                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP2_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP2_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP2_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP2_PU_PD_INIT_ENUM                     PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP2_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP2_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP2_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP2_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP1_PU_PD_SHIFT                 _MK_SHIFT_CONST(10)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP1_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP1_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP1_PU_PD_RANGE                 11:10
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP1_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP1_PU_PD_DEFAULT                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP1_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP1_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP1_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP1_PU_PD_INIT_ENUM                     PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP1_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP1_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP1_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_DAP1_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATE_PU_PD_SHIFT                  _MK_SHIFT_CONST(8)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATE_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_A_0_ATE_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATE_PU_PD_RANGE                  9:8
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATE_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATE_PU_PD_DEFAULT                        _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATE_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATE_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATE_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATE_PU_PD_INIT_ENUM                      PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATE_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATE_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATE_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATE_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATD_PU_PD_SHIFT                  _MK_SHIFT_CONST(6)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATD_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_A_0_ATD_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATD_PU_PD_RANGE                  7:6
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATD_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATD_PU_PD_DEFAULT                        _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATD_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATD_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATD_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATD_PU_PD_INIT_ENUM                      PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATD_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATD_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATD_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATD_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATC_PU_PD_SHIFT                  _MK_SHIFT_CONST(4)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATC_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_A_0_ATC_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATC_PU_PD_RANGE                  5:4
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATC_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATC_PU_PD_DEFAULT                        _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATC_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATC_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATC_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATC_PU_PD_INIT_ENUM                      PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATC_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATC_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATC_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATC_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATB_PU_PD_SHIFT                  _MK_SHIFT_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATB_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_A_0_ATB_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATB_PU_PD_RANGE                  3:2
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATB_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATB_PU_PD_DEFAULT                        _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATB_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATB_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATB_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATB_PU_PD_INIT_ENUM                      PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATB_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATB_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATB_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATB_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATA_PU_PD_SHIFT                  _MK_SHIFT_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATA_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_A_0_ATA_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATA_PU_PD_RANGE                  1:0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATA_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATA_PU_PD_DEFAULT                        _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATA_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATA_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATA_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATA_PU_PD_INIT_ENUM                      PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATA_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATA_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATA_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_A_0_ATA_PU_PD_RSVD                   _MK_ENUM_CONST(3)


// Register APB_MISC_PP_PULLUPDOWN_REG_B_0  
#define APB_MISC_PP_PULLUPDOWN_REG_B_0                  _MK_ADDR_CONST(0xa4)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_WORD_COUNT                       0x1
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_RESET_VAL                        _MK_MASK_CONST(0x6a8aaaaa)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXK_PU_PD_SHIFT                 _MK_SHIFT_CONST(30)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXK_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXK_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXK_PU_PD_RANGE                 31:30
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXK_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXK_PU_PD_DEFAULT                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXK_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXK_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXK_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXK_PU_PD_INIT_ENUM                     PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXK_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXK_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXK_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXK_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXD_PU_PD_SHIFT                 _MK_SHIFT_CONST(28)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXD_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXD_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXD_PU_PD_RANGE                 29:28
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXD_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXD_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXD_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXD_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXD_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXD_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXD_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXD_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXD_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXD_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXC_PU_PD_SHIFT                 _MK_SHIFT_CONST(26)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXC_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXC_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXC_PU_PD_RANGE                 27:26
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXC_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXC_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXC_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXC_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXC_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXC_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXC_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXC_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXC_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXC_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXB_PU_PD_SHIFT                 _MK_SHIFT_CONST(24)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXB_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXB_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXB_PU_PD_RANGE                 25:24
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXB_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXB_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXB_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXB_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXB_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXB_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXB_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXB_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXB_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXB_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXA_PU_PD_SHIFT                 _MK_SHIFT_CONST(22)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXA_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXA_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXA_PU_PD_RANGE                 23:22
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXA_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXA_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXA_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXA_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXA_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXA_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXA_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXA_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXA_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SLXA_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU_PU_PD_SHIFT                  _MK_SHIFT_CONST(20)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU_PU_PD_RANGE                  21:20
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU_PU_PD_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU_PU_PD_INIT_ENUM                      NORMAL
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDO_PU_PD_SHIFT                 _MK_SHIFT_CONST(18)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDO_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDO_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDO_PU_PD_RANGE                 19:18
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDO_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDO_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDO_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDO_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDO_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDO_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDO_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDO_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDO_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDO_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDI_PU_PD_SHIFT                 _MK_SHIFT_CONST(16)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDI_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDI_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDI_PU_PD_RANGE                 17:16
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDI_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDI_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDI_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDI_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDI_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDI_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDI_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDI_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDI_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_SPDI_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCD_PU_PD_SHIFT                 _MK_SHIFT_CONST(14)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCD_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCD_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCD_PU_PD_RANGE                 15:14
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCD_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCD_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCD_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCD_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCD_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCD_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCD_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCD_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCD_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCD_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCC_PU_PD_SHIFT                 _MK_SHIFT_CONST(12)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCC_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCC_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCC_PU_PD_RANGE                 13:12
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCC_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCC_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCC_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCC_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCC_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCC_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCC_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCC_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCC_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCC_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCB_PU_PD_SHIFT                 _MK_SHIFT_CONST(10)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCB_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCB_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCB_PU_PD_RANGE                 11:10
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCB_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCB_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCB_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCB_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCB_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCB_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCB_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCB_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCB_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCB_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCA_PU_PD_SHIFT                 _MK_SHIFT_CONST(8)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCA_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCA_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCA_PU_PD_RANGE                 9:8
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCA_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCA_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCA_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCA_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCA_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCA_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCA_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCA_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCA_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_KBCA_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU7_PU_PD_SHIFT                 _MK_SHIFT_CONST(6)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU7_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU7_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU7_PU_PD_RANGE                 7:6
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU7_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU7_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU7_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU7_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU7_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU7_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU7_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU7_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU7_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_GPU7_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_B_0_PTA_PU_PD_SHIFT                  _MK_SHIFT_CONST(4)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_PTA_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_B_0_PTA_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_PTA_PU_PD_RANGE                  5:4
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_PTA_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_PTA_PU_PD_DEFAULT                        _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_PTA_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_PTA_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_PTA_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_PTA_PU_PD_INIT_ENUM                      PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_PTA_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_PTA_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_PTA_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_PTA_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_B_0_I2CP_PU_PD_SHIFT                 _MK_SHIFT_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_I2CP_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_B_0_I2CP_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_I2CP_PU_PD_RANGE                 3:2
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_I2CP_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_I2CP_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_I2CP_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_I2CP_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_I2CP_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_I2CP_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_I2CP_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_I2CP_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_I2CP_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_I2CP_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_B_0_RM_PU_PD_SHIFT                   _MK_SHIFT_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_RM_PU_PD_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_B_0_RM_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_RM_PU_PD_RANGE                   1:0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_RM_PU_PD_WOFFSET                 0x0
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_RM_PU_PD_DEFAULT                 _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_RM_PU_PD_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_RM_PU_PD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_RM_PU_PD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_RM_PU_PD_INIT_ENUM                       PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_RM_PU_PD_NORMAL                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_RM_PU_PD_PULL_DOWN                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_RM_PU_PD_PULL_UP                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_B_0_RM_PU_PD_RSVD                    _MK_ENUM_CONST(3)


// Register APB_MISC_PP_PULLUPDOWN_REG_C_0  
#define APB_MISC_PP_PULLUPDOWN_REG_C_0                  _MK_ADDR_CONST(0xa8)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_WORD_COUNT                       0x1
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_RESET_VAL                        _MK_MASK_CONST(0xaa6655)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2S_PU_PD_SHIFT                 _MK_SHIFT_CONST(30)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2S_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2S_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2S_PU_PD_RANGE                 31:30
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2S_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2S_PU_PD_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2S_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2S_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2S_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2S_PU_PD_INIT_ENUM                     NORMAL
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2S_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2S_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2S_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2S_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2D_PU_PD_SHIFT                 _MK_SHIFT_CONST(28)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2D_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2D_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2D_PU_PD_RANGE                 29:28
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2D_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2D_PU_PD_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2D_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2D_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2D_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2D_PU_PD_INIT_ENUM                     NORMAL
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2D_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2D_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2D_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2D_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2C_PU_PD_SHIFT                 _MK_SHIFT_CONST(26)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2C_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2C_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2C_PU_PD_RANGE                 27:26
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2C_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2C_PU_PD_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2C_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2C_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2C_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2C_PU_PD_INIT_ENUM                     NORMAL
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2C_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2C_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2C_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2C_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2A_PU_PD_SHIFT                 _MK_SHIFT_CONST(24)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2A_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2A_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2A_PU_PD_RANGE                 25:24
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2A_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2A_PU_PD_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2A_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2A_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2A_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2A_PU_PD_INIT_ENUM                     NORMAL
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2A_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2A_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2A_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_XM2A_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRRX_PU_PD_SHIFT                 _MK_SHIFT_CONST(22)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRRX_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_C_0_IRRX_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRRX_PU_PD_RANGE                 23:22
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRRX_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRRX_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRRX_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRRX_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRRX_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRRX_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRRX_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRRX_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRRX_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRRX_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRTX_PU_PD_SHIFT                 _MK_SHIFT_CONST(20)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRTX_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_C_0_IRTX_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRTX_PU_PD_RANGE                 21:20
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRTX_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRTX_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRTX_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRTX_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRTX_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRTX_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRTX_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRTX_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRTX_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_IRTX_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIH_PU_PD_SHIFT                 _MK_SHIFT_CONST(18)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIH_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIH_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIH_PU_PD_RANGE                 19:18
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIH_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIH_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIH_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIH_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIH_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIH_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIH_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIH_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIH_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIH_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIG_PU_PD_SHIFT                 _MK_SHIFT_CONST(16)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIG_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIG_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIG_PU_PD_RANGE                 17:16
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIG_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIG_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIG_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIG_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIG_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIG_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIG_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIG_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIG_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIG_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIF_PU_PD_SHIFT                 _MK_SHIFT_CONST(14)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIF_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIF_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIF_PU_PD_RANGE                 15:14
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIF_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIF_PU_PD_DEFAULT                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIF_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIF_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIF_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIF_PU_PD_INIT_ENUM                     PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIF_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIF_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIF_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIF_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIE_PU_PD_SHIFT                 _MK_SHIFT_CONST(12)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIE_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIE_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIE_PU_PD_RANGE                 13:12
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIE_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIE_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIE_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIE_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIE_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIE_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIE_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIE_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIE_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIE_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPID_PU_PD_SHIFT                 _MK_SHIFT_CONST(10)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPID_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_C_0_SPID_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPID_PU_PD_RANGE                 11:10
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPID_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPID_PU_PD_DEFAULT                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPID_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPID_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPID_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPID_PU_PD_INIT_ENUM                     PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPID_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPID_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPID_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPID_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIC_PU_PD_SHIFT                 _MK_SHIFT_CONST(8)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIC_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIC_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIC_PU_PD_RANGE                 9:8
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIC_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIC_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIC_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIC_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIC_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIC_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIC_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIC_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIC_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIC_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIB_PU_PD_SHIFT                 _MK_SHIFT_CONST(6)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIB_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIB_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIB_PU_PD_RANGE                 7:6
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIB_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIB_PU_PD_DEFAULT                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIB_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIB_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIB_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIB_PU_PD_INIT_ENUM                     PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIB_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIB_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIB_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIB_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIA_PU_PD_SHIFT                 _MK_SHIFT_CONST(4)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIA_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIA_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIA_PU_PD_RANGE                 5:4
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIA_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIA_PU_PD_DEFAULT                       _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIA_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIA_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIA_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIA_PU_PD_INIT_ENUM                     PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIA_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIA_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIA_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_SPIA_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV2_PU_PD_SHIFT                        _MK_SHIFT_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV2_PU_PD_FIELD                        (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV2_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV2_PU_PD_RANGE                        3:2
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV2_PU_PD_WOFFSET                      0x0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV2_PU_PD_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV2_PU_PD_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV2_PU_PD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV2_PU_PD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV2_PU_PD_INIT_ENUM                    PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV2_PU_PD_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV2_PU_PD_PULL_DOWN                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV2_PU_PD_PULL_UP                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV2_PU_PD_RSVD                 _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV1_PU_PD_SHIFT                        _MK_SHIFT_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV1_PU_PD_FIELD                        (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV1_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV1_PU_PD_RANGE                        1:0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV1_PU_PD_WOFFSET                      0x0
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV1_PU_PD_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV1_PU_PD_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV1_PU_PD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV1_PU_PD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV1_PU_PD_INIT_ENUM                    PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV1_PU_PD_NORMAL                       _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV1_PU_PD_PULL_DOWN                    _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV1_PU_PD_PULL_UP                      _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_CDEV1_PU_PD_RSVD                 _MK_ENUM_CONST(3)


// Register APB_MISC_PP_PULLUPDOWN_REG_D_0  
#define APB_MISC_PP_PULLUPDOWN_REG_D_0                  _MK_ADDR_CONST(0xac)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_WORD_COUNT                       0x1
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_RESET_VAL                        _MK_MASK_CONST(0xa8a55a8a)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDD_PU_PD_SHIFT                  _MK_SHIFT_CONST(30)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDD_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_D_0_SDD_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDD_PU_PD_RANGE                  31:30
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDD_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDD_PU_PD_DEFAULT                        _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDD_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDD_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDD_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDD_PU_PD_INIT_ENUM                      PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDD_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDD_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDD_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDD_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDC_PU_PD_SHIFT                  _MK_SHIFT_CONST(28)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDC_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_D_0_SDC_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDC_PU_PD_RANGE                  29:28
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDC_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDC_PU_PD_DEFAULT                        _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDC_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDC_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDC_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDC_PU_PD_INIT_ENUM                      PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDC_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDC_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDC_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDC_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDB_PU_PD_SHIFT                  _MK_SHIFT_CONST(26)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDB_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_D_0_SDB_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDB_PU_PD_RANGE                  27:26
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDB_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDB_PU_PD_DEFAULT                        _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDB_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDB_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDB_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDB_PU_PD_INIT_ENUM                      PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDB_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDB_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDB_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_SDB_PU_PD_RSVD                   _MK_ENUM_CONST(3)

// LC_P? for : lcd_pclk, lcd_de, lcd_hsycn, lcd_vsync, lcd_m0, lcd_m1, lcd_vp0, hdmi_int
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_CSUS_PU_PD_SHIFT                 _MK_SHIFT_CONST(24)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_CSUS_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_D_0_CSUS_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_CSUS_PU_PD_RANGE                 25:24
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_CSUS_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_CSUS_PU_PD_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_CSUS_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_CSUS_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_CSUS_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_CSUS_PU_PD_INIT_ENUM                     NORMAL
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_CSUS_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_CSUS_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_CSUS_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_CSUS_PU_PD_RSVD                  _MK_ENUM_CONST(3)

// LS_P? for : lcd_sdin, lcd_sdout, lcd_wr_, lcd_cs0, lcd_dc0, lcd_sck, lcd_pwr0, lcd_pwr1, lcd_pwr2
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LC_PU_PD_SHIFT                   _MK_SHIFT_CONST(22)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LC_PU_PD_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_D_0_LC_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LC_PU_PD_RANGE                   23:22
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LC_PU_PD_WOFFSET                 0x0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LC_PU_PD_DEFAULT                 _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LC_PU_PD_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LC_PU_PD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LC_PU_PD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LC_PU_PD_INIT_ENUM                       PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LC_PU_PD_NORMAL                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LC_PU_PD_PULL_DOWN                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LC_PU_PD_PULL_UP                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LC_PU_PD_RSVD                    _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LS_PU_PD_SHIFT                   _MK_SHIFT_CONST(20)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LS_PU_PD_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_D_0_LS_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LS_PU_PD_RANGE                   21:20
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LS_PU_PD_WOFFSET                 0x0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LS_PU_PD_DEFAULT                 _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LS_PU_PD_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LS_PU_PD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LS_PU_PD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LS_PU_PD_INIT_ENUM                       PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LS_PU_PD_NORMAL                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LS_PU_PD_PULL_DOWN                       _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LS_PU_PD_PULL_UP                 _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LS_PU_PD_RSVD                    _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD23_22_PU_PD_SHIFT                      _MK_SHIFT_CONST(18)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD23_22_PU_PD_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_D_0_LD23_22_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD23_22_PU_PD_RANGE                      19:18
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD23_22_PU_PD_WOFFSET                    0x0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD23_22_PU_PD_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD23_22_PU_PD_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD23_22_PU_PD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD23_22_PU_PD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD23_22_PU_PD_INIT_ENUM                  PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD23_22_PU_PD_NORMAL                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD23_22_PU_PD_PULL_DOWN                  _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD23_22_PU_PD_PULL_UP                    _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD23_22_PU_PD_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD21_20_PU_PD_SHIFT                      _MK_SHIFT_CONST(16)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD21_20_PU_PD_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_D_0_LD21_20_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD21_20_PU_PD_RANGE                      17:16
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD21_20_PU_PD_WOFFSET                    0x0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD21_20_PU_PD_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD21_20_PU_PD_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD21_20_PU_PD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD21_20_PU_PD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD21_20_PU_PD_INIT_ENUM                  PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD21_20_PU_PD_NORMAL                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD21_20_PU_PD_PULL_DOWN                  _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD21_20_PU_PD_PULL_UP                    _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD21_20_PU_PD_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD19_18_PU_PD_SHIFT                      _MK_SHIFT_CONST(14)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD19_18_PU_PD_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_D_0_LD19_18_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD19_18_PU_PD_RANGE                      15:14
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD19_18_PU_PD_WOFFSET                    0x0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD19_18_PU_PD_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD19_18_PU_PD_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD19_18_PU_PD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD19_18_PU_PD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD19_18_PU_PD_INIT_ENUM                  PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD19_18_PU_PD_NORMAL                     _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD19_18_PU_PD_PULL_DOWN                  _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD19_18_PU_PD_PULL_UP                    _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD19_18_PU_PD_RSVD                       _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD17_0_PU_PD_SHIFT                       _MK_SHIFT_CONST(12)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD17_0_PU_PD_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_D_0_LD17_0_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD17_0_PU_PD_RANGE                       13:12
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD17_0_PU_PD_WOFFSET                     0x0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD17_0_PU_PD_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD17_0_PU_PD_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD17_0_PU_PD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD17_0_PU_PD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD17_0_PU_PD_INIT_ENUM                   PULL_DOWN
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD17_0_PU_PD_NORMAL                      _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD17_0_PU_PD_PULL_DOWN                   _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD17_0_PU_PD_PULL_UP                     _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_LD17_0_PU_PD_RSVD                        _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCB_PU_PD_SHIFT                  _MK_SHIFT_CONST(10)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCB_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_D_0_UCB_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCB_PU_PD_RANGE                  11:10
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCB_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCB_PU_PD_DEFAULT                        _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCB_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCB_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCB_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCB_PU_PD_INIT_ENUM                      PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCB_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCB_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCB_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCB_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCA_PU_PD_SHIFT                  _MK_SHIFT_CONST(8)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCA_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_D_0_UCA_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCA_PU_PD_RANGE                  9:8
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCA_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCA_PU_PD_DEFAULT                        _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCA_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCA_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCA_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCA_PU_PD_INIT_ENUM                      PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCA_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCA_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCA_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UCA_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAD_PU_PD_SHIFT                  _MK_SHIFT_CONST(6)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAD_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_D_0_UAD_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAD_PU_PD_RANGE                  7:6
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAD_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAD_PU_PD_DEFAULT                        _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAD_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAD_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAD_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAD_PU_PD_INIT_ENUM                      PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAD_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAD_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAD_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAD_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAC_PU_PD_SHIFT                  _MK_SHIFT_CONST(4)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAC_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_D_0_UAC_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAC_PU_PD_RANGE                  5:4
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAC_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAC_PU_PD_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAC_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAC_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAC_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAC_PU_PD_INIT_ENUM                      NORMAL
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAC_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAC_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAC_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAC_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAB_PU_PD_SHIFT                  _MK_SHIFT_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAB_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_D_0_UAB_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAB_PU_PD_RANGE                  3:2
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAB_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAB_PU_PD_DEFAULT                        _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAB_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAB_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAB_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAB_PU_PD_INIT_ENUM                      PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAB_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAB_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAB_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAB_PU_PD_RSVD                   _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAA_PU_PD_SHIFT                  _MK_SHIFT_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAA_PU_PD_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_D_0_UAA_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAA_PU_PD_RANGE                  1:0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAA_PU_PD_WOFFSET                        0x0
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAA_PU_PD_DEFAULT                        _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAA_PU_PD_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAA_PU_PD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAA_PU_PD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAA_PU_PD_INIT_ENUM                      PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAA_PU_PD_NORMAL                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAA_PU_PD_PULL_DOWN                      _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAA_PU_PD_PULL_UP                        _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_D_0_UAA_PU_PD_RSVD                   _MK_ENUM_CONST(3)


// Register APB_MISC_PP_PULLUPDOWN_REG_E_0  
#define APB_MISC_PP_PULLUPDOWN_REG_E_0                  _MK_ADDR_CONST(0xb0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_WORD_COUNT                       0x1
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_RESET_VAL                        _MK_MASK_CONST(0xa)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_RSVD_7_SHIFT                     _MK_SHIFT_CONST(8)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_RSVD_7_FIELD                     (_MK_MASK_CONST(0xffffff) << APB_MISC_PP_PULLUPDOWN_REG_E_0_RSVD_7_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_RSVD_7_RANGE                     31:8
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_RSVD_7_WOFFSET                   0x0
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_RSVD_7_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_RSVD_7_DEFAULT_MASK                      _MK_MASK_CONST(0xffffff)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_RSVD_7_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_RSVD_7_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCB_PU_PD_SHIFT                 _MK_SHIFT_CONST(6)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCB_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCB_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCB_PU_PD_RANGE                 7:6
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCB_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCB_PU_PD_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCB_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCB_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCB_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCB_PU_PD_INIT_ENUM                     NORMAL
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCB_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCB_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCB_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCB_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCA_PU_PD_SHIFT                 _MK_SHIFT_CONST(4)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCA_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCA_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCA_PU_PD_RANGE                 5:4
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCA_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCA_PU_PD_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCA_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCA_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCA_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCA_PU_PD_INIT_ENUM                     NORMAL
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCA_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCA_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCA_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_PMCA_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCE_PU_PD_SHIFT                 _MK_SHIFT_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCE_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCE_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCE_PU_PD_RANGE                 3:2
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCE_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCE_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCE_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCE_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCE_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCE_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCE_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCE_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCE_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCE_PU_PD_RSVD                  _MK_ENUM_CONST(3)

#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCF_PU_PD_SHIFT                 _MK_SHIFT_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCF_PU_PD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCF_PU_PD_SHIFT)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCF_PU_PD_RANGE                 1:0
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCF_PU_PD_WOFFSET                       0x0
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCF_PU_PD_DEFAULT                       _MK_MASK_CONST(0x2)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCF_PU_PD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCF_PU_PD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCF_PU_PD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCF_PU_PD_INIT_ENUM                     PULL_UP
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCF_PU_PD_NORMAL                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCF_PU_PD_PULL_DOWN                     _MK_ENUM_CONST(1)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCF_PU_PD_PULL_UP                       _MK_ENUM_CONST(2)
#define APB_MISC_PP_PULLUPDOWN_REG_E_0_KBCF_PU_PD_RSVD                  _MK_ENUM_CONST(3)


// Register APB_MISC_PP_MISC_USB_CLK_RST_CTL_0  
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0                      _MK_ADDR_CONST(0xb4)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_WORD_COUNT                   0x1
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_RESET_VAL                    _MK_MASK_CONST(0x201)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_RESET_MASK                   _MK_MASK_CONST(0x307)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_READ_MASK                    _MK_MASK_CONST(0x307)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_WRITE_MASK                   _MK_MASK_CONST(0x307)
// Reset (active high) for USB2 controller
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_RST_SHIFT                  _MK_SHIFT_CONST(9)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_RST_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_RST_SHIFT)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_RST_RANGE                  9:9
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_RST_WOFFSET                        0x0
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_RST_INIT_ENUM                      ENABLE
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_RST_DISABLE                        _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_RST_ENABLE                 _MK_ENUM_CONST(1)

// Reset (active high) for USB controller
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_RST_SHIFT                   _MK_SHIFT_CONST(8)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_RST_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_RST_SHIFT)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_RST_RANGE                   8:8
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_RST_WOFFSET                 0x0
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_RST_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_RST_INIT_ENUM                       DISABLE
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_RST_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_RST_ENABLE                  _MK_ENUM_CONST(1)

// Clock override for USB2 controller
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CLK_OVR_ON_SHIFT                   _MK_SHIFT_CONST(2)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CLK_OVR_ON_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CLK_OVR_ON_SHIFT)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CLK_OVR_ON_RANGE                   2:2
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CLK_OVR_ON_WOFFSET                 0x0
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CLK_OVR_ON_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CLK_OVR_ON_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CLK_OVR_ON_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CLK_OVR_ON_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CLK_OVR_ON_INIT_ENUM                       DISABLE
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CLK_OVR_ON_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CLK_OVR_ON_ENABLE                  _MK_ENUM_CONST(1)

// enable clocks to USB2 controller
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CE_SHIFT                   _MK_SHIFT_CONST(1)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CE_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CE_SHIFT)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CE_RANGE                   1:1
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CE_WOFFSET                 0x0
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CE_INIT_ENUM                       DISABLE
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CE_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB2_CE_ENABLE                  _MK_ENUM_CONST(1)

// enable clocks to USB controller
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_CE_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_CE_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_CE_SHIFT)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_CE_RANGE                    0:0
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_CE_WOFFSET                  0x0
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_CE_DEFAULT                  _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_CE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_CE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_CE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_CE_INIT_ENUM                        ENABLE
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_CE_DISABLE                  _MK_ENUM_CONST(0)
#define APB_MISC_PP_MISC_USB_CLK_RST_CTL_0_MISC_USB_CE_ENABLE                   _MK_ENUM_CONST(1)


// Register APB_MISC_ASYNC_COREPWRCONFIG_0  
#define APB_MISC_ASYNC_COREPWRCONFIG_0                  _MK_ADDR_CONST(0x400)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_WORD_COUNT                       0x1
#define APB_MISC_ASYNC_COREPWRCONFIG_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_RESET_MASK                       _MK_MASK_CONST(0x7)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_READ_MASK                        _MK_MASK_CONST(0x7)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_WRITE_MASK                       _MK_MASK_CONST(0x7)
// Power is on in TDA/TDB partitions
#define APB_MISC_ASYNC_COREPWRCONFIG_0_TD_COREPWR_EN_SHIFT                      _MK_SHIFT_CONST(0)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_TD_COREPWR_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_COREPWRCONFIG_0_TD_COREPWR_EN_SHIFT)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_TD_COREPWR_EN_RANGE                      0:0
#define APB_MISC_ASYNC_COREPWRCONFIG_0_TD_COREPWR_EN_WOFFSET                    0x0
#define APB_MISC_ASYNC_COREPWRCONFIG_0_TD_COREPWR_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_TD_COREPWR_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_TD_COREPWR_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_TD_COREPWR_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_TD_COREPWR_EN_INIT_ENUM                  DISABLE
#define APB_MISC_ASYNC_COREPWRCONFIG_0_TD_COREPWR_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_TD_COREPWR_EN_ENABLE                     _MK_ENUM_CONST(1)

// Power is on in VE/MPE partitions
#define APB_MISC_ASYNC_COREPWRCONFIG_0_VE_COREPWR_EN_SHIFT                      _MK_SHIFT_CONST(1)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_VE_COREPWR_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_COREPWRCONFIG_0_VE_COREPWR_EN_SHIFT)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_VE_COREPWR_EN_RANGE                      1:1
#define APB_MISC_ASYNC_COREPWRCONFIG_0_VE_COREPWR_EN_WOFFSET                    0x0
#define APB_MISC_ASYNC_COREPWRCONFIG_0_VE_COREPWR_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_VE_COREPWR_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_VE_COREPWR_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_VE_COREPWR_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_VE_COREPWR_EN_INIT_ENUM                  DISABLE
#define APB_MISC_ASYNC_COREPWRCONFIG_0_VE_COREPWR_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_VE_COREPWR_EN_ENABLE                     _MK_ENUM_CONST(1)

// Power is on in CPU partition
#define APB_MISC_ASYNC_COREPWRCONFIG_0_CPU_COREPWR_EN_SHIFT                     _MK_SHIFT_CONST(2)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_CPU_COREPWR_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_COREPWRCONFIG_0_CPU_COREPWR_EN_SHIFT)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_CPU_COREPWR_EN_RANGE                     2:2
#define APB_MISC_ASYNC_COREPWRCONFIG_0_CPU_COREPWR_EN_WOFFSET                   0x0
#define APB_MISC_ASYNC_COREPWRCONFIG_0_CPU_COREPWR_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_CPU_COREPWR_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_CPU_COREPWR_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_CPU_COREPWR_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_CPU_COREPWR_EN_INIT_ENUM                 DISABLE
#define APB_MISC_ASYNC_COREPWRCONFIG_0_CPU_COREPWR_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_COREPWRCONFIG_0_CPU_COREPWR_EN_ENABLE                    _MK_ENUM_CONST(1)


// Reserved address 1028 [0x404] 

// Register APB_MISC_ASYNC_DLYCTRL_0  
#define APB_MISC_ASYNC_DLYCTRL_0                        _MK_ADDR_CONST(0x408)
#define APB_MISC_ASYNC_DLYCTRL_0_WORD_COUNT                     0x1
#define APB_MISC_ASYNC_DLYCTRL_0_RESET_VAL                      _MK_MASK_CONST(0x8)
#define APB_MISC_ASYNC_DLYCTRL_0_RESET_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_ASYNC_DLYCTRL_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_DLYCTRL_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_DLYCTRL_0_READ_MASK                      _MK_MASK_CONST(0x1f)
#define APB_MISC_ASYNC_DLYCTRL_0_WRITE_MASK                     _MK_MASK_CONST(0x1f)
// Delay on RDY output.  
#define APB_MISC_ASYNC_DLYCTRL_0_RDY_DLY_SHIFT                  _MK_SHIFT_CONST(0)
#define APB_MISC_ASYNC_DLYCTRL_0_RDY_DLY_FIELD                  (_MK_MASK_CONST(0x1f) << APB_MISC_ASYNC_DLYCTRL_0_RDY_DLY_SHIFT)
#define APB_MISC_ASYNC_DLYCTRL_0_RDY_DLY_RANGE                  4:0
#define APB_MISC_ASYNC_DLYCTRL_0_RDY_DLY_WOFFSET                        0x0
#define APB_MISC_ASYNC_DLYCTRL_0_RDY_DLY_DEFAULT                        _MK_MASK_CONST(0x8)
#define APB_MISC_ASYNC_DLYCTRL_0_RDY_DLY_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define APB_MISC_ASYNC_DLYCTRL_0_RDY_DLY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_DLYCTRL_0_RDY_DLY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APB_MISC_ASYNC_CLKMNTREN_0  
#define APB_MISC_ASYNC_CLKMNTREN_0                      _MK_ADDR_CONST(0x40c)
#define APB_MISC_ASYNC_CLKMNTREN_0_WORD_COUNT                   0x1
#define APB_MISC_ASYNC_CLKMNTREN_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_CLKMNTREN_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_CLKMNTREN_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_CLKMNTREN_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_CLKMNTREN_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_CLKMNTREN_0_WRITE_MASK                   _MK_MASK_CONST(0x1)
// clock monitor enable
#define APB_MISC_ASYNC_CLKMNTREN_0_CLK_MONITOR_EN_SHIFT                 _MK_SHIFT_CONST(0)
#define APB_MISC_ASYNC_CLKMNTREN_0_CLK_MONITOR_EN_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_CLKMNTREN_0_CLK_MONITOR_EN_SHIFT)
#define APB_MISC_ASYNC_CLKMNTREN_0_CLK_MONITOR_EN_RANGE                 0:0
#define APB_MISC_ASYNC_CLKMNTREN_0_CLK_MONITOR_EN_WOFFSET                       0x0
#define APB_MISC_ASYNC_CLKMNTREN_0_CLK_MONITOR_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_CLKMNTREN_0_CLK_MONITOR_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_CLKMNTREN_0_CLK_MONITOR_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_CLKMNTREN_0_CLK_MONITOR_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_CLKMNTREN_0_CLK_MONITOR_EN_DISABLE                       _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_CLKMNTREN_0_CLK_MONITOR_EN_ENABLE                        _MK_ENUM_CONST(1)


// Register APB_MISC_ASYNC_EMCPADEN_0  
#define APB_MISC_ASYNC_EMCPADEN_0                       _MK_ADDR_CONST(0x410)
#define APB_MISC_ASYNC_EMCPADEN_0_WORD_COUNT                    0x1
#define APB_MISC_ASYNC_EMCPADEN_0_RESET_VAL                     _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_EMCPADEN_0_RESET_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_EMCPADEN_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADEN_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADEN_0_READ_MASK                     _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_EMCPADEN_0_WRITE_MASK                    _MK_MASK_CONST(0x3)
// outputs enable for EMC pads
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_OUTPUT_EN_SHIFT                       _MK_SHIFT_CONST(0)
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_OUTPUT_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_OUTPUT_EN_SHIFT)
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_OUTPUT_EN_RANGE                       0:0
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_OUTPUT_EN_WOFFSET                     0x0
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_OUTPUT_EN_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_OUTPUT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_OUTPUT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_OUTPUT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_OUTPUT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_OUTPUT_EN_ENABLE                      _MK_ENUM_CONST(1)

// inputs enable for EMC pads
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_INPUT_EN_SHIFT                        _MK_SHIFT_CONST(1)
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_INPUT_EN_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_INPUT_EN_SHIFT)
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_INPUT_EN_RANGE                        1:1
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_INPUT_EN_WOFFSET                      0x0
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_INPUT_EN_DEFAULT                      _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_INPUT_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_INPUT_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_INPUT_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_INPUT_EN_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_EMCPADEN_0_EMC_PAD_INPUT_EN_ENABLE                       _MK_ENUM_CONST(1)


// Register APB_MISC_ASYNC_EMCPADCTRL_0  
#define APB_MISC_ASYNC_EMCPADCTRL_0                     _MK_ADDR_CONST(0x414)
#define APB_MISC_ASYNC_EMCPADCTRL_0_WORD_COUNT                  0x1
#define APB_MISC_ASYNC_EMCPADCTRL_0_RESET_VAL                   _MK_MASK_CONST(0xff0f1)
#define APB_MISC_ASYNC_EMCPADCTRL_0_RESET_MASK                  _MK_MASK_CONST(0x1ff3f3)
#define APB_MISC_ASYNC_EMCPADCTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_READ_MASK                   _MK_MASK_CONST(0x1ff3f3)
#define APB_MISC_ASYNC_EMCPADCTRL_0_WRITE_MASK                  _MK_MASK_CONST(0x1ff3f3)
// EMC 3.3V mode enable
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_33V_EN_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_33V_EN_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_EMCPADCTRL_0_MEM_33V_EN_SHIFT)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_33V_EN_RANGE                    0:0
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_33V_EN_WOFFSET                  0x0
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_33V_EN_DEFAULT                  _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_33V_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_33V_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_33V_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_33V_EN_DISABLE                  _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_33V_EN_ENABLE                   _MK_ENUM_CONST(1)

// EMC vref enable
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_VREF_EN_SHIFT                   _MK_SHIFT_CONST(1)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_VREF_EN_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_EMCPADCTRL_0_MEM_VREF_EN_SHIFT)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_VREF_EN_RANGE                   1:1
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_VREF_EN_WOFFSET                 0x0
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_VREF_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_VREF_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_VREF_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_VREF_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_VREF_EN_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_VREF_EN_ENABLE                  _MK_ENUM_CONST(1)

// EMC data pins high speed mode enable
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_HSM_EN_SHIFT                       _MK_SHIFT_CONST(4)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_HSM_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_HSM_EN_SHIFT)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_HSM_EN_RANGE                       4:4
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_HSM_EN_WOFFSET                     0x0
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_HSM_EN_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_HSM_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_HSM_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_HSM_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_HSM_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_HSM_EN_ENABLE                      _MK_ENUM_CONST(1)

// EMC data pins high speed mode enable
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_HSM_EN_SHIFT                       _MK_SHIFT_CONST(5)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_HSM_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_HSM_EN_SHIFT)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_HSM_EN_RANGE                       5:5
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_HSM_EN_WOFFSET                     0x0
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_HSM_EN_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_HSM_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_HSM_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_HSM_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_HSM_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_HSM_EN_ENABLE                      _MK_ENUM_CONST(1)

// EMC control pins high speed mode enable
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_HSM_EN_SHIFT                      _MK_SHIFT_CONST(6)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_HSM_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_HSM_EN_SHIFT)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_HSM_EN_RANGE                      6:6
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_HSM_EN_WOFFSET                    0x0
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_HSM_EN_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_HSM_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_HSM_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_HSM_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_HSM_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_HSM_EN_ENABLE                     _MK_ENUM_CONST(1)

// EMC control pins high speed mode enable
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_HSM_EN_SHIFT                      _MK_SHIFT_CONST(7)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_HSM_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_HSM_EN_SHIFT)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_HSM_EN_RANGE                      7:7
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_HSM_EN_WOFFSET                    0x0
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_HSM_EN_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_HSM_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_HSM_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_HSM_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_HSM_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_HSM_EN_ENABLE                     _MK_ENUM_CONST(1)

// EMC data pins schmidt enable
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_SCHMT_EN_SHIFT                     _MK_SHIFT_CONST(8)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_SCHMT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_SCHMT_EN_SHIFT)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_SCHMT_EN_RANGE                     8:8
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_SCHMT_EN_WOFFSET                   0x0
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_SCHMT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_SCHMT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_SCHMT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_SCHMT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_SCHMT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_SCHMT_EN_ENABLE                    _MK_ENUM_CONST(1)

// EMC data pins schmidt enable
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_SCHMT_EN_SHIFT                     _MK_SHIFT_CONST(9)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_SCHMT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_SCHMT_EN_SHIFT)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_SCHMT_EN_RANGE                     9:9
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_SCHMT_EN_WOFFSET                   0x0
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_SCHMT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_SCHMT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_SCHMT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_SCHMT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_SCHMT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_SCHMT_EN_ENABLE                    _MK_ENUM_CONST(1)

// EMC data pins low power mode select
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_LPMD_SHIFT                 _MK_SHIFT_CONST(12)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_LPMD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_LPMD_SHIFT)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_LPMD_RANGE                 13:12
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_LPMD_WOFFSET                       0x0
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_LPMD_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_LPMD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_LPMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_DAT_LPMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// EMC data pins low power mode select
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_LPMD_SHIFT                 _MK_SHIFT_CONST(14)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_LPMD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_LPMD_SHIFT)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_LPMD_RANGE                 15:14
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_LPMD_WOFFSET                       0x0
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_LPMD_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_LPMD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_LPMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_DAT_LPMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// EMC control pins low power mode select
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_LPMD_SHIFT                        _MK_SHIFT_CONST(16)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_LPMD_FIELD                        (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_LPMD_SHIFT)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_LPMD_RANGE                        17:16
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_LPMD_WOFFSET                      0x0
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_LPMD_DEFAULT                      _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_LPMD_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_LPMD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM0_CTRL_LPMD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// EMC control pins low power mode select
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_LPMD_SHIFT                        _MK_SHIFT_CONST(18)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_LPMD_FIELD                        (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_LPMD_SHIFT)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_LPMD_RANGE                        19:18
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_LPMD_WOFFSET                      0x0
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_LPMD_DEFAULT                      _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_LPMD_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_LPMD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM1_CTRL_LPMD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// EMC pull-down enable
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_PULLD_SHIFT                     _MK_SHIFT_CONST(20)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_PULLD_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_EMCPADCTRL_0_MEM_PULLD_SHIFT)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_PULLD_RANGE                     20:20
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_PULLD_WOFFSET                   0x0
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_PULLD_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_PULLD_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_PULLD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_PULLD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_PULLD_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_EMCPADCTRL_0_MEM_PULLD_ENABLE                    _MK_ENUM_CONST(1)


// Register APB_MISC_ASYNC_MEMPADCAL1_0  
#define APB_MISC_ASYNC_MEMPADCAL1_0                     _MK_ADDR_CONST(0x418)
#define APB_MISC_ASYNC_MEMPADCAL1_0_WORD_COUNT                  0x1
#define APB_MISC_ASYNC_MEMPADCAL1_0_RESET_VAL                   _MK_MASK_CONST(0x7f7f)
#define APB_MISC_ASYNC_MEMPADCAL1_0_RESET_MASK                  _MK_MASK_CONST(0x7f7f)
#define APB_MISC_ASYNC_MEMPADCAL1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_MEMPADCAL1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_MEMPADCAL1_0_READ_MASK                   _MK_MASK_CONST(0x7f7f)
#define APB_MISC_ASYNC_MEMPADCAL1_0_WRITE_MASK                  _MK_MASK_CONST(0x7f7f)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_SHIFT                 _MK_SHIFT_CONST(0)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_FIELD                 (_MK_MASK_CONST(0x1f) << APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_SHIFT)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_RANGE                 4:0
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_WOFFSET                       0x0
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_DEFAULT                       _MK_MASK_CONST(0x1f)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_SLWR_SHIFT                    _MK_SHIFT_CONST(5)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_SLWR_FIELD                    (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_SLWR_RANGE                    6:5
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_SLWR_WOFFSET                  0x0
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_SLWR_DEFAULT                  _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_SLWR_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_SLWR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_SHIFT                 _MK_SHIFT_CONST(8)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_FIELD                 (_MK_MASK_CONST(0x1f) << APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_SHIFT)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_RANGE                 12:8
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_WOFFSET                       0x0
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_DEFAULT                       _MK_MASK_CONST(0x1f)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_SLWF_SHIFT                    _MK_SHIFT_CONST(13)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_SLWF_FIELD                    (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_SLWF_RANGE                    14:13
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_SLWF_WOFFSET                  0x0
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_SLWF_DEFAULT                  _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_SLWF_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_SLWF_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_MEMPADCAL1_0_MEM_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APB_MISC_ASYNC_LCDPADCTRL_0  
#define APB_MISC_ASYNC_LCDPADCTRL_0                     _MK_ADDR_CONST(0x41c)
#define APB_MISC_ASYNC_LCDPADCTRL_0_WORD_COUNT                  0x1
#define APB_MISC_ASYNC_LCDPADCTRL_0_RESET_VAL                   _MK_MASK_CONST(0xff0f1)
#define APB_MISC_ASYNC_LCDPADCTRL_0_RESET_MASK                  _MK_MASK_CONST(0xff5f1)
#define APB_MISC_ASYNC_LCDPADCTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_READ_MASK                   _MK_MASK_CONST(0xff5f1)
#define APB_MISC_ASYNC_LCDPADCTRL_0_WRITE_MASK                  _MK_MASK_CONST(0xff5f1)
// LCD 3.3V mode enable
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_33V_EN_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_33V_EN_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_LCDPADCTRL_0_LCD_33V_EN_SHIFT)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_33V_EN_RANGE                    0:0
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_33V_EN_WOFFSET                  0x0
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_33V_EN_DEFAULT                  _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_33V_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_33V_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_33V_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_33V_EN_DISABLE                  _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_33V_EN_ENABLE                   _MK_ENUM_CONST(1)

// LCD data pins high speed mode enable
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_HSM_EN_SHIFT                       _MK_SHIFT_CONST(4)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_HSM_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_HSM_EN_SHIFT)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_HSM_EN_RANGE                       4:4
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_HSM_EN_WOFFSET                     0x0
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_HSM_EN_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_HSM_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_HSM_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_HSM_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_HSM_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_HSM_EN_ENABLE                      _MK_ENUM_CONST(1)

// LCD data pins high speed mode enable
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_HSM_EN_SHIFT                       _MK_SHIFT_CONST(5)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_HSM_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_HSM_EN_SHIFT)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_HSM_EN_RANGE                       5:5
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_HSM_EN_WOFFSET                     0x0
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_HSM_EN_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_HSM_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_HSM_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_HSM_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_HSM_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_HSM_EN_ENABLE                      _MK_ENUM_CONST(1)

// LCD control pins high speed mode enable
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_HSM_EN_SHIFT                      _MK_SHIFT_CONST(6)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_HSM_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_HSM_EN_SHIFT)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_HSM_EN_RANGE                      6:6
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_HSM_EN_WOFFSET                    0x0
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_HSM_EN_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_HSM_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_HSM_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_HSM_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_HSM_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_HSM_EN_ENABLE                     _MK_ENUM_CONST(1)

// LCD control pins high speed mode enable
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_HSM_EN_SHIFT                      _MK_SHIFT_CONST(7)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_HSM_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_HSM_EN_SHIFT)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_HSM_EN_RANGE                      7:7
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_HSM_EN_WOFFSET                    0x0
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_HSM_EN_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_HSM_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_HSM_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_HSM_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_HSM_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_HSM_EN_ENABLE                     _MK_ENUM_CONST(1)

// LCD data pins schmidt enable
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_DAT_SCHMT_EN_SHIFT                      _MK_SHIFT_CONST(8)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_DAT_SCHMT_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_LCDPADCTRL_0_LCD_DAT_SCHMT_EN_SHIFT)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_DAT_SCHMT_EN_RANGE                      8:8
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_DAT_SCHMT_EN_WOFFSET                    0x0
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_DAT_SCHMT_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_DAT_SCHMT_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_DAT_SCHMT_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_DAT_SCHMT_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_DAT_SCHMT_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_DAT_SCHMT_EN_ENABLE                     _MK_ENUM_CONST(1)

// LCD control pins schmidt enable
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_CTRL_SCHMT_EN_SHIFT                     _MK_SHIFT_CONST(10)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_CTRL_SCHMT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_LCDPADCTRL_0_LCD_CTRL_SCHMT_EN_SHIFT)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_CTRL_SCHMT_EN_RANGE                     10:10
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_CTRL_SCHMT_EN_WOFFSET                   0x0
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_CTRL_SCHMT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_CTRL_SCHMT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_CTRL_SCHMT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_CTRL_SCHMT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_CTRL_SCHMT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD_CTRL_SCHMT_EN_ENABLE                    _MK_ENUM_CONST(1)

// LCD data pins low power mode select
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_LPMD_SHIFT                 _MK_SHIFT_CONST(12)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_LPMD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_LPMD_SHIFT)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_LPMD_RANGE                 13:12
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_LPMD_WOFFSET                       0x0
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_LPMD_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_LPMD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_LPMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_DAT_LPMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// LCD data pins low power mode select
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_LPMD_SHIFT                 _MK_SHIFT_CONST(14)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_LPMD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_LPMD_SHIFT)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_LPMD_RANGE                 15:14
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_LPMD_WOFFSET                       0x0
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_LPMD_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_LPMD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_LPMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_DAT_LPMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// LCD control pins low power mode select
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_LPMD_SHIFT                        _MK_SHIFT_CONST(16)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_LPMD_FIELD                        (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_LPMD_SHIFT)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_LPMD_RANGE                        17:16
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_LPMD_WOFFSET                      0x0
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_LPMD_DEFAULT                      _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_LPMD_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_LPMD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD0_CTRL_LPMD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// LCD control pins low power mode select
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_LPMD_SHIFT                        _MK_SHIFT_CONST(18)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_LPMD_FIELD                        (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_LPMD_SHIFT)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_LPMD_RANGE                        19:18
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_LPMD_WOFFSET                      0x0
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_LPMD_DEFAULT                      _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_LPMD_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_LPMD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCTRL_0_LCD1_CTRL_LPMD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APB_MISC_ASYNC_LCDPADCAL1_0  
#define APB_MISC_ASYNC_LCDPADCAL1_0                     _MK_ADDR_CONST(0x420)
#define APB_MISC_ASYNC_LCDPADCAL1_0_WORD_COUNT                  0x1
#define APB_MISC_ASYNC_LCDPADCAL1_0_RESET_VAL                   _MK_MASK_CONST(0x7f7f)
#define APB_MISC_ASYNC_LCDPADCAL1_0_RESET_MASK                  _MK_MASK_CONST(0x7f7f)
#define APB_MISC_ASYNC_LCDPADCAL1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCAL1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCAL1_0_READ_MASK                   _MK_MASK_CONST(0x7f7f)
#define APB_MISC_ASYNC_LCDPADCAL1_0_WRITE_MASK                  _MK_MASK_CONST(0x7f7f)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_SHIFT                 _MK_SHIFT_CONST(0)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_FIELD                 (_MK_MASK_CONST(0x1f) << APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_SHIFT)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_RANGE                 4:0
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_WOFFSET                       0x0
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_DEFAULT                       _MK_MASK_CONST(0x1f)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_SLWR_SHIFT                    _MK_SHIFT_CONST(5)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_SLWR_FIELD                    (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_SLWR_RANGE                    6:5
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_SLWR_WOFFSET                  0x0
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_SLWR_DEFAULT                  _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_SLWR_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_SLWR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_SHIFT                 _MK_SHIFT_CONST(8)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_FIELD                 (_MK_MASK_CONST(0x1f) << APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_SHIFT)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_RANGE                 12:8
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_WOFFSET                       0x0
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_DEFAULT                       _MK_MASK_CONST(0x1f)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_SLWF_SHIFT                    _MK_SHIFT_CONST(13)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_SLWF_FIELD                    (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_SLWF_RANGE                    14:13
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_SLWF_WOFFSET                  0x0
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_SLWF_DEFAULT                  _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_SLWF_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_SLWF_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_LCDPADCAL1_0_LCD_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APB_MISC_ASYNC_VIPADCTRL_0  
#define APB_MISC_ASYNC_VIPADCTRL_0                      _MK_ADDR_CONST(0x424)
#define APB_MISC_ASYNC_VIPADCTRL_0_WORD_COUNT                   0x1
#define APB_MISC_ASYNC_VIPADCTRL_0_RESET_VAL                    _MK_MASK_CONST(0x33051)
#define APB_MISC_ASYNC_VIPADCTRL_0_RESET_MASK                   _MK_MASK_CONST(0x33551)
#define APB_MISC_ASYNC_VIPADCTRL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCTRL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCTRL_0_READ_MASK                    _MK_MASK_CONST(0x33551)
#define APB_MISC_ASYNC_VIPADCTRL_0_WRITE_MASK                   _MK_MASK_CONST(0x33551)
// VI 3.3V mode enable
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_33V_EN_SHIFT                      _MK_SHIFT_CONST(0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_33V_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_VIPADCTRL_0_VI_33V_EN_SHIFT)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_33V_EN_RANGE                      0:0
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_33V_EN_WOFFSET                    0x0
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_33V_EN_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_33V_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_33V_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_33V_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_33V_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_33V_EN_ENABLE                     _MK_ENUM_CONST(1)

// VI data pins high speed mode enable
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_HSM_EN_SHIFT                  _MK_SHIFT_CONST(4)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_HSM_EN_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_HSM_EN_SHIFT)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_HSM_EN_RANGE                  4:4
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_HSM_EN_WOFFSET                        0x0
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_HSM_EN_DEFAULT                        _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_HSM_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_HSM_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_HSM_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_HSM_EN_DISABLE                        _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_HSM_EN_ENABLE                 _MK_ENUM_CONST(1)

// VI control pins high speed mode enable
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_HSM_EN_SHIFT                 _MK_SHIFT_CONST(6)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_HSM_EN_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_HSM_EN_SHIFT)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_HSM_EN_RANGE                 6:6
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_HSM_EN_WOFFSET                       0x0
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_HSM_EN_DEFAULT                       _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_HSM_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_HSM_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_HSM_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_HSM_EN_DISABLE                       _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_HSM_EN_ENABLE                        _MK_ENUM_CONST(1)

// VI data pins schmidt enable
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_SCHMT_EN_SHIFT                        _MK_SHIFT_CONST(8)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_SCHMT_EN_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_SCHMT_EN_SHIFT)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_SCHMT_EN_RANGE                        8:8
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_SCHMT_EN_WOFFSET                      0x0
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_SCHMT_EN_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_SCHMT_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_SCHMT_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_SCHMT_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_SCHMT_EN_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_SCHMT_EN_ENABLE                       _MK_ENUM_CONST(1)

// VI control pins schmidt enable
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_SCHMT_EN_SHIFT                       _MK_SHIFT_CONST(10)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_SCHMT_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_SCHMT_EN_SHIFT)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_SCHMT_EN_RANGE                       10:10
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_SCHMT_EN_WOFFSET                     0x0
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_SCHMT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_SCHMT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_SCHMT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_SCHMT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_SCHMT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_SCHMT_EN_ENABLE                      _MK_ENUM_CONST(1)

// VI data pins low power mode select
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_LPMD_SHIFT                    _MK_SHIFT_CONST(12)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_LPMD_FIELD                    (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_LPMD_SHIFT)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_LPMD_RANGE                    13:12
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_LPMD_WOFFSET                  0x0
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_LPMD_DEFAULT                  _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_LPMD_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_LPMD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_DAT_LPMD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// VI control pins low power mode select
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_LPMD_SHIFT                   _MK_SHIFT_CONST(16)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_LPMD_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_LPMD_SHIFT)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_LPMD_RANGE                   17:16
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_LPMD_WOFFSET                 0x0
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_LPMD_DEFAULT                 _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_LPMD_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_LPMD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCTRL_0_VI_CTRL_LPMD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APB_MISC_ASYNC_VIPADCAL1_0  
#define APB_MISC_ASYNC_VIPADCAL1_0                      _MK_ADDR_CONST(0x428)
#define APB_MISC_ASYNC_VIPADCAL1_0_WORD_COUNT                   0x1
#define APB_MISC_ASYNC_VIPADCAL1_0_RESET_VAL                    _MK_MASK_CONST(0x7f7f)
#define APB_MISC_ASYNC_VIPADCAL1_0_RESET_MASK                   _MK_MASK_CONST(0x7f7f)
#define APB_MISC_ASYNC_VIPADCAL1_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCAL1_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCAL1_0_READ_MASK                    _MK_MASK_CONST(0x7f7f)
#define APB_MISC_ASYNC_VIPADCAL1_0_WRITE_MASK                   _MK_MASK_CONST(0x7f7f)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_SHIFT                   _MK_SHIFT_CONST(0)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_FIELD                   (_MK_MASK_CONST(0x1f) << APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_SHIFT)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_RANGE                   4:0
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_WOFFSET                 0x0
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_DEFAULT                 _MK_MASK_CONST(0x1f)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_SLWR_SHIFT                      _MK_SHIFT_CONST(5)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_SLWR_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_SLWR_RANGE                      6:5
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_SLWR_WOFFSET                    0x0
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_SLWR_DEFAULT                    _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_SLWR_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_SLWR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_SHIFT                   _MK_SHIFT_CONST(8)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_FIELD                   (_MK_MASK_CONST(0x1f) << APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_SHIFT)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_RANGE                   12:8
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_WOFFSET                 0x0
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_DEFAULT                 _MK_MASK_CONST(0x1f)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_SLWF_SHIFT                      _MK_SHIFT_CONST(13)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_SLWF_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_SLWF_RANGE                      14:13
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_SLWF_WOFFSET                    0x0
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_SLWF_DEFAULT                    _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_SLWF_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_SLWF_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VIPADCAL1_0_VI_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APB_MISC_ASYNC_VCLKCTRL_0  
#define APB_MISC_ASYNC_VCLKCTRL_0                       _MK_ADDR_CONST(0x42c)
#define APB_MISC_ASYNC_VCLKCTRL_0_WORD_COUNT                    0x1
#define APB_MISC_ASYNC_VCLKCTRL_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VCLKCTRL_0_RESET_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_VCLKCTRL_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VCLKCTRL_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VCLKCTRL_0_READ_MASK                     _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_VCLKCTRL_0_WRITE_MASK                    _MK_MASK_CONST(0x3)
// VCLK input enable
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_IE_SHIFT                     _MK_SHIFT_CONST(0)
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_IE_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_IE_SHIFT)
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_IE_RANGE                     0:0
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_IE_WOFFSET                   0x0
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_IE_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_IE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_IE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_IE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_IE_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_IE_ENABLE                    _MK_ENUM_CONST(1)

// VCLK invert enable
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_INVERSION_SHIFT                      _MK_SHIFT_CONST(1)
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_INVERSION_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_INVERSION_SHIFT)
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_INVERSION_RANGE                      1:1
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_INVERSION_WOFFSET                    0x0
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_INVERSION_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_INVERSION_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_INVERSION_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_INVERSION_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_INVERSION_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_VCLKCTRL_0_VCLK_PAD_INVERSION_ENABLE                     _MK_ENUM_CONST(1)


// Reserved address 1072 [0x430] 

// Reserved address 1076 [0x434] 

// Register APB_MISC_ASYNC_TVDACVHSYNCCTRL_0  
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0                        _MK_ADDR_CONST(0x438)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_WORD_COUNT                     0x1
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_RESET_MASK                     _MK_MASK_CONST(0xf)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_READ_MASK                      _MK_MASK_CONST(0xf)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_WRITE_MASK                     _MK_MASK_CONST(0xf)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_HSYNCDLY_SHIFT                   _MK_SHIFT_CONST(0)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_HSYNCDLY_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_HSYNCDLY_SHIFT)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_HSYNCDLY_RANGE                   1:0
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_HSYNCDLY_WOFFSET                 0x0
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_HSYNCDLY_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_HSYNCDLY_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_HSYNCDLY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_HSYNCDLY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_VSYNCDLY_SHIFT                   _MK_SHIFT_CONST(2)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_VSYNCDLY_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_VSYNCDLY_SHIFT)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_VSYNCDLY_RANGE                   3:2
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_VSYNCDLY_WOFFSET                 0x0
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_VSYNCDLY_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_VSYNCDLY_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_VSYNCDLY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACVHSYNCCTRL_0_TVDAC_VSYNCDLY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APB_MISC_ASYNC_TVDACCNTL_0  
#define APB_MISC_ASYNC_TVDACCNTL_0                      _MK_ADDR_CONST(0x43c)
#define APB_MISC_ASYNC_TVDACCNTL_0_WORD_COUNT                   0x1
#define APB_MISC_ASYNC_TVDACCNTL_0_RESET_VAL                    _MK_MASK_CONST(0x83b)
#define APB_MISC_ASYNC_TVDACCNTL_0_RESET_MASK                   _MK_MASK_CONST(0x1effffff)
#define APB_MISC_ASYNC_TVDACCNTL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_READ_MASK                    _MK_MASK_CONST(0x1effffff)
#define APB_MISC_ASYNC_TVDACCNTL_0_WRITE_MASK                   _MK_MASK_CONST(0x1effffff)
// Power down everything including the band-gap
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_IDDQ_SHIFT                       _MK_SHIFT_CONST(0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_IDDQ_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_TVDACCNTL_0_DAC_IDDQ_SHIFT)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_IDDQ_RANGE                       0:0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_IDDQ_WOFFSET                     0x0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_IDDQ_DEFAULT                     _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_IDDQ_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_IDDQ_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_IDDQ_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_IDDQ_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_IDDQ_ENABLE                      _MK_ENUM_CONST(1)

// Power down everything except the band-gap
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_POWERDOWN_SHIFT                  _MK_SHIFT_CONST(1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_POWERDOWN_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_TVDACCNTL_0_DAC_POWERDOWN_SHIFT)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_POWERDOWN_RANGE                  1:1
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_POWERDOWN_WOFFSET                        0x0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_POWERDOWN_DEFAULT                        _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_POWERDOWN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_POWERDOWN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_POWERDOWN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_POWERDOWN_DISABLE                        _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_POWERDOWN_ENABLE                 _MK_ENUM_CONST(1)

// Power down everything including the band-gap
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_DETECT_EN_SHIFT                  _MK_SHIFT_CONST(2)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_DETECT_EN_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_TVDACCNTL_0_DAC_DETECT_EN_SHIFT)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_DETECT_EN_RANGE                  2:2
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_DETECT_EN_WOFFSET                        0x0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_DETECT_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_DETECT_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_DETECT_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_DETECT_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_DETECT_EN_DISABLE                        _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_DETECT_EN_ENABLE                 _MK_ENUM_CONST(1)

// Low power (sleep) mode. SHut down OUTR output
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPR_SHIFT                     _MK_SHIFT_CONST(3)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPR_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPR_SHIFT)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPR_RANGE                     3:3
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPR_WOFFSET                   0x0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPR_DEFAULT                   _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPR_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPR_ENABLE                    _MK_ENUM_CONST(1)

// Low power (sleep) mode. SHut down OUTG output
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPG_SHIFT                     _MK_SHIFT_CONST(4)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPG_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPG_SHIFT)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPG_RANGE                     4:4
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPG_WOFFSET                   0x0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPG_DEFAULT                   _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPG_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPG_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPG_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPG_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPG_ENABLE                    _MK_ENUM_CONST(1)

// Low power (sleep) mode. SHut down OUTB output
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPB_SHIFT                     _MK_SHIFT_CONST(5)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPB_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPB_SHIFT)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPB_RANGE                     5:5
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPB_WOFFSET                   0x0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPB_DEFAULT                   _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPB_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPB_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPB_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPB_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_SLEEPB_ENABLE                    _MK_ENUM_CONST(1)

// Adjust threshold voltage of comparator inside DAC
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMP_TH_SHIFT                    _MK_SHIFT_CONST(6)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMP_TH_FIELD                    (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMP_TH_SHIFT)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMP_TH_RANGE                    7:6
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMP_TH_WOFFSET                  0x0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMP_TH_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMP_TH_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMP_TH_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMP_TH_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Turn bandgap averaging on/off
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_AVG_ON_SHIFT                        _MK_SHIFT_CONST(8)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_AVG_ON_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_AVG_ON_SHIFT)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_AVG_ON_RANGE                        8:8
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_AVG_ON_WOFFSET                      0x0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_AVG_ON_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_AVG_ON_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_AVG_ON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_AVG_ON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_AVG_ON_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_AVG_ON_ENABLE                       _MK_ENUM_CONST(1)

// To adjust temp coeff
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CURVE_SHIFT                 _MK_SHIFT_CONST(9)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CURVE_FIELD                 (_MK_MASK_CONST(0x7) << APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CURVE_SHIFT)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CURVE_RANGE                 11:9
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CURVE_WOFFSET                       0x0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CURVE_DEFAULT                       _MK_MASK_CONST(0x4)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CURVE_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CURVE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CURVE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Control bits for bandgap
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CNTL_SHIFT                  _MK_SHIFT_CONST(12)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CNTL_FIELD                  (_MK_MASK_CONST(0xf) << APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CNTL_SHIFT)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CNTL_RANGE                  15:12
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CNTL_WOFFSET                        0x0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CNTL_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CNTL_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CNTL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_BGAP_CNTL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// For debugging. Selects internal analog output to be sent out of VREF pin
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_ATEST_SHIFT                      _MK_SHIFT_CONST(16)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_ATEST_FIELD                      (_MK_MASK_CONST(0x7) << APB_MISC_ASYNC_TVDACCNTL_0_DAC_ATEST_SHIFT)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_ATEST_RANGE                      18:16
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_ATEST_WOFFSET                    0x0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_ATEST_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_ATEST_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_ATEST_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_ATEST_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Reserved for additional control
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_CNTL_SHIFT                       _MK_SHIFT_CONST(19)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_CNTL_FIELD                       (_MK_MASK_CONST(0x1f) << APB_MISC_ASYNC_TVDACCNTL_0_DAC_CNTL_SHIFT)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_CNTL_RANGE                       23:19
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_CNTL_WOFFSET                     0x0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_CNTL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_CNTL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_CNTL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_CNTL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Enable COMPOUTR output
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPR_EN_SHIFT                   _MK_SHIFT_CONST(25)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPR_EN_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPR_EN_SHIFT)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPR_EN_RANGE                   25:25
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPR_EN_WOFFSET                 0x0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPR_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPR_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPR_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPR_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPR_EN_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPR_EN_ENABLE                  _MK_ENUM_CONST(1)

// Enable COMPOUTG output
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPG_EN_SHIFT                   _MK_SHIFT_CONST(26)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPG_EN_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPG_EN_SHIFT)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPG_EN_RANGE                   26:26
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPG_EN_WOFFSET                 0x0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPG_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPG_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPG_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPG_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPG_EN_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPG_EN_ENABLE                  _MK_ENUM_CONST(1)

// Enable COMPOUTB output
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPB_EN_SHIFT                   _MK_SHIFT_CONST(27)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPB_EN_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPB_EN_SHIFT)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPB_EN_RANGE                   27:27
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPB_EN_WOFFSET                 0x0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPB_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPB_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPB_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPB_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPB_EN_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_COMPB_EN_ENABLE                  _MK_ENUM_CONST(1)

// Indicate load status
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_PLUG_OK_SHIFT                    _MK_SHIFT_CONST(28)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_PLUG_OK_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_TVDACCNTL_0_DAC_PLUG_OK_SHIFT)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_PLUG_OK_RANGE                    28:28
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_PLUG_OK_WOFFSET                  0x0
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_PLUG_OK_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_PLUG_OK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_PLUG_OK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_PLUG_OK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_PLUG_OK_UNLOADED                 _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_TVDACCNTL_0_DAC_PLUG_OK_LOADED                   _MK_ENUM_CONST(1)


// Register APB_MISC_ASYNC_TVDACSTATUS_0  
#define APB_MISC_ASYNC_TVDACSTATUS_0                    _MK_ADDR_CONST(0x440)
#define APB_MISC_ASYNC_TVDACSTATUS_0_WORD_COUNT                         0x1
#define APB_MISC_ASYNC_TVDACSTATUS_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACSTATUS_0_RESET_MASK                         _MK_MASK_CONST(0x7)
#define APB_MISC_ASYNC_TVDACSTATUS_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACSTATUS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACSTATUS_0_READ_MASK                  _MK_MASK_CONST(0x7)
#define APB_MISC_ASYNC_TVDACSTATUS_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
// Channel R comparator output for auto-detect
// 0 = COMPINR > threshold
// 1 = COMPINR < threshold, or when POWERDOWN==1
// comparison threshold = 0.325V
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTR_SHIFT                 _MK_SHIFT_CONST(0)
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTR_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTR_SHIFT)
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTR_RANGE                 0:0
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTR_WOFFSET                       0x0
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTR_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Channel G comparator output for auto-detect
// 0 = COMPING > threshold
// 1 = COMPING < threshold, or when POWERDOWN==1
// comparison threshold = 0.325V
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTG_SHIFT                 _MK_SHIFT_CONST(1)
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTG_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTG_SHIFT)
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTG_RANGE                 1:1
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTG_WOFFSET                       0x0
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTG_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTG_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTG_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTG_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Channel B comparator output for auto-detect
// 0 = COMPINB > threshold
// 1 = COMPINB < threshold, or when POWERDOWN==1
// comparison threshold = 0.325V
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTB_SHIFT                 _MK_SHIFT_CONST(2)
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTB_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTB_SHIFT)
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTB_RANGE                 2:2
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTB_WOFFSET                       0x0
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTB_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTB_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTB_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACSTATUS_0_DAC_COMPOUTB_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APB_MISC_ASYNC_TVDACDINCONFIG_0  
#define APB_MISC_ASYNC_TVDACDINCONFIG_0                 _MK_ADDR_CONST(0x444)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_WORD_COUNT                      0x1
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_RESET_VAL                       _MK_MASK_CONST(0x2)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_RESET_MASK                      _MK_MASK_CONST(0xffffd37)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_READ_MASK                       _MK_MASK_CONST(0xffffd37)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_WRITE_MASK                      _MK_MASK_CONST(0xffffd37)
// Data Input FIFO threshold
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_FIFO_TH_SHIFT                       _MK_SHIFT_CONST(0)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_FIFO_TH_FIELD                       (_MK_MASK_CONST(0x7) << APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_FIFO_TH_SHIFT)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_FIFO_TH_RANGE                       2:0
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_FIFO_TH_WOFFSET                     0x0
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_FIFO_TH_DEFAULT                     _MK_MASK_CONST(0x2)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_FIFO_TH_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_FIFO_TH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_FIFO_TH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// INPUT source for TVDAC
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_SOURCE_SHIFT                        _MK_SHIFT_CONST(4)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_SOURCE_FIELD                        (_MK_MASK_CONST(0x3) << APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_SOURCE_SHIFT)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_SOURCE_RANGE                        5:4
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_SOURCE_WOFFSET                      0x0
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_SOURCE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_SOURCE_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_SOURCE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_SOURCE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_SOURCE_TVDAC_OFF                    _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_SOURCE_TVO                  _MK_ENUM_CONST(1)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_SOURCE_DISPLAY                      _MK_ENUM_CONST(2)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_SOURCE_DISPLAYB                     _MK_ENUM_CONST(3)

// Override DAC DIN inputs
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_EN_SHIFT                  _MK_SHIFT_CONST(8)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_EN_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_EN_SHIFT)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_EN_RANGE                  8:8
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_EN_WOFFSET                        0x0
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_EN_DISABLE                        _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_EN_ENABLE                 _MK_ENUM_CONST(1)

// DIN override
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_SHIFT                     _MK_SHIFT_CONST(10)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_FIELD                     (_MK_MASK_CONST(0x3ff) << APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_SHIFT)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_RANGE                     19:10
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_WOFFSET                   0x0
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_DEFAULT_MASK                      _MK_MASK_CONST(0x3ff)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_DIN_ORIDE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// AMPIN
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_AMPIN_SHIFT                 _MK_SHIFT_CONST(20)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_AMPIN_FIELD                 (_MK_MASK_CONST(0xff) << APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_AMPIN_SHIFT)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_AMPIN_RANGE                 27:20
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_AMPIN_WOFFSET                       0x0
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_AMPIN_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_AMPIN_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_AMPIN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_TVDACDINCONFIG_0_DAC_AMPIN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APB_MISC_ASYNC_INT_STATUS_0  // Interrupt Status
//  This reflects status of all pending
//  interrupts which is valid as long as
//  the interrupt is not cleared even if the
//  interrupt is masked. A pending interrupt
//  can be cleared by writing a '1' to this
//  the corresponding interrupt status bit
//  in this register.
//        0       rt  HGP0_INT_STATUS          // HGP0 Interrupt Status
//                                             //  (this is cleared on write)
//                                             //   0= interrupt not pending
//                                             //   1= interrupt pending
//        1       rt  HGP1_INT_STATUS          // HGP1 Interrupt Status
//                                             //  (this is cleared on write)
//                                             //   0= interrupt not pending
//                                            //   1= interrupt pending
//      2       rt  HGP2_INT_STATUS          // HGP2 Interrupt Status
//                                          //  (this is cleared on write)
//                                           //   0= interrupt not pending
//                                           //   1= interrupt pending
//      4       rt  HGP4_INT_STATUS          // HGP4 Interrupt Status
//                                           //  (this is cleared on write)
//                                           //   0= interrupt not pending
//                                           //   1= interrupt pending
//      5       rt  HGP5_INT_STATUS          // HGP5 Interrupt Status
//                                           //  (this is cleared on write)
//                                           //   0= interrupt not pending
//                                           //   1= interrupt pending
//      6       rt  HGP6_INT_STATUS          // HGP6 Interrupt Status
//                                           //  (this is cleared on write)
//                                           //   0= interrupt not pending
//                                           //   1= interrupt pending
#define APB_MISC_ASYNC_INT_STATUS_0                     _MK_ADDR_CONST(0x448)
#define APB_MISC_ASYNC_INT_STATUS_0_WORD_COUNT                  0x1
#define APB_MISC_ASYNC_INT_STATUS_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_READ_MASK                   _MK_MASK_CONST(0x1f80)
#define APB_MISC_ASYNC_INT_STATUS_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// HGP7 Interrupt Status
//  (this is cleared on write)
//   0= interrupt not pending
//   1= interrupt pending
#define APB_MISC_ASYNC_INT_STATUS_0_HGP7_INT_STATUS_SHIFT                       _MK_SHIFT_CONST(7)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP7_INT_STATUS_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_STATUS_0_HGP7_INT_STATUS_SHIFT)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP7_INT_STATUS_RANGE                       7:7
#define APB_MISC_ASYNC_INT_STATUS_0_HGP7_INT_STATUS_WOFFSET                     0x0
#define APB_MISC_ASYNC_INT_STATUS_0_HGP7_INT_STATUS_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP7_INT_STATUS_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP7_INT_STATUS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP7_INT_STATUS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// HGP8 Interrupt Status
//  (this is cleared on write)
//   0= interrupt not pending
//   1= interrupt pending
#define APB_MISC_ASYNC_INT_STATUS_0_HGP8_INT_STATUS_SHIFT                       _MK_SHIFT_CONST(8)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP8_INT_STATUS_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_STATUS_0_HGP8_INT_STATUS_SHIFT)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP8_INT_STATUS_RANGE                       8:8
#define APB_MISC_ASYNC_INT_STATUS_0_HGP8_INT_STATUS_WOFFSET                     0x0
#define APB_MISC_ASYNC_INT_STATUS_0_HGP8_INT_STATUS_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP8_INT_STATUS_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP8_INT_STATUS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP8_INT_STATUS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// HGP9 Interrupt Status
//  (this is cleared on write)
//   0= interrupt not pending
//   1= interrupt pending
#define APB_MISC_ASYNC_INT_STATUS_0_HGP9_INT_STATUS_SHIFT                       _MK_SHIFT_CONST(9)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP9_INT_STATUS_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_STATUS_0_HGP9_INT_STATUS_SHIFT)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP9_INT_STATUS_RANGE                       9:9
#define APB_MISC_ASYNC_INT_STATUS_0_HGP9_INT_STATUS_WOFFSET                     0x0
#define APB_MISC_ASYNC_INT_STATUS_0_HGP9_INT_STATUS_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP9_INT_STATUS_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP9_INT_STATUS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP9_INT_STATUS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// HGP10 Interrupt Status
//  (this is cleared on write)
//   0= interrupt not pending
//   1= interrupt pending
#define APB_MISC_ASYNC_INT_STATUS_0_HGP10_INT_STATUS_SHIFT                      _MK_SHIFT_CONST(10)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP10_INT_STATUS_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_STATUS_0_HGP10_INT_STATUS_SHIFT)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP10_INT_STATUS_RANGE                      10:10
#define APB_MISC_ASYNC_INT_STATUS_0_HGP10_INT_STATUS_WOFFSET                    0x0
#define APB_MISC_ASYNC_INT_STATUS_0_HGP10_INT_STATUS_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP10_INT_STATUS_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP10_INT_STATUS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP10_INT_STATUS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// HGP11 Interrupt Status
//  (this is cleared on write)
//   0= interrupt not pending
//   1= interrupt pending
#define APB_MISC_ASYNC_INT_STATUS_0_HGP11_INT_STATUS_SHIFT                      _MK_SHIFT_CONST(11)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP11_INT_STATUS_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_STATUS_0_HGP11_INT_STATUS_SHIFT)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP11_INT_STATUS_RANGE                      11:11
#define APB_MISC_ASYNC_INT_STATUS_0_HGP11_INT_STATUS_WOFFSET                    0x0
#define APB_MISC_ASYNC_INT_STATUS_0_HGP11_INT_STATUS_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP11_INT_STATUS_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP11_INT_STATUS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP11_INT_STATUS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// HGP12 Interrupt Status
//  (this is cleared on write)
//   0= interrupt not pending
//   1= interrupt pending
#define APB_MISC_ASYNC_INT_STATUS_0_HGP12_INT_STATUS_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP12_INT_STATUS_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_STATUS_0_HGP12_INT_STATUS_SHIFT)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP12_INT_STATUS_RANGE                      12:12
#define APB_MISC_ASYNC_INT_STATUS_0_HGP12_INT_STATUS_WOFFSET                    0x0
#define APB_MISC_ASYNC_INT_STATUS_0_HGP12_INT_STATUS_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP12_INT_STATUS_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP12_INT_STATUS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_STATUS_0_HGP12_INT_STATUS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APB_MISC_ASYNC_INT_MASK_0  // Interrupt Mask
// Setting bits in this register masked the
//  corresponding interrupt but does not
//  clear a pending interrupt and does not
//  prevent a pending interrupt to be generated.
//  Masking an interrupt also does not clear
//  a pending interrupt status and does not
//  a pending interrupt status to be generated.
//      0       rw  HGP0_INT_MASK  i=0x0     // HGP0 Interrupt Mask
//          enum ( MASKED, NOTMASKED )       //   0= interrupt masked
//                                           //   1= interrupt not masked
//      1       rw  HGP1_INT_MASK  i=0x0     // HGP1 Interrupt Mask
//          enum ( MASKED, NOTMASKED )       //   0= interrupt masked
//                                           //   1= interrupt not masked
//      2       rw  HGP2_INT_MASK  i=0x0     // HGP2 Interrupt Mask
//          enum ( MASKED, NOTMASKED )       //   0= interrupt masked
//                                           //   1= interrupt not masked
//      4       rw  HGP4_INT_MASK  i=0x0     // HGP4 Interrupt Mask
//          enum ( MASKED, NOTMASKED )       //   0= interrupt masked
//                                           //   1= interrupt not masked
//      5       rw  HGP5_INT_MASK  i=0x0     // HGP5 Interrupt Mask
//          enum ( MASKED, NOTMASKED )       //   0= interrupt masked
//                                           //   1= interrupt not masked
//      6       rw  HGP6_INT_MASK  i=0x0     // HGP6 Interrupt Mask
//          enum ( MASKED, NOTMASKED )       //   0= interrupt masked
//                                           //   1= interrupt not masked
#define APB_MISC_ASYNC_INT_MASK_0                       _MK_ADDR_CONST(0x44c)
#define APB_MISC_ASYNC_INT_MASK_0_WORD_COUNT                    0x1
#define APB_MISC_ASYNC_INT_MASK_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_RESET_MASK                    _MK_MASK_CONST(0x1f80)
#define APB_MISC_ASYNC_INT_MASK_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_READ_MASK                     _MK_MASK_CONST(0x1f80)
#define APB_MISC_ASYNC_INT_MASK_0_WRITE_MASK                    _MK_MASK_CONST(0x1f80)
// HGP7 Interrupt Mask   0= interrupt masked
//   1= interrupt not masked
#define APB_MISC_ASYNC_INT_MASK_0_HGP7_INT_MASK_SHIFT                   _MK_SHIFT_CONST(7)
#define APB_MISC_ASYNC_INT_MASK_0_HGP7_INT_MASK_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_MASK_0_HGP7_INT_MASK_SHIFT)
#define APB_MISC_ASYNC_INT_MASK_0_HGP7_INT_MASK_RANGE                   7:7
#define APB_MISC_ASYNC_INT_MASK_0_HGP7_INT_MASK_WOFFSET                 0x0
#define APB_MISC_ASYNC_INT_MASK_0_HGP7_INT_MASK_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP7_INT_MASK_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_MASK_0_HGP7_INT_MASK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP7_INT_MASK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP7_INT_MASK_MASKED                  _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP7_INT_MASK_NOTMASKED                       _MK_ENUM_CONST(1)

// HGP8 Interrupt Mask   0= interrupt masked
//   1= interrupt not masked
#define APB_MISC_ASYNC_INT_MASK_0_HGP8_INT_MASK_SHIFT                   _MK_SHIFT_CONST(8)
#define APB_MISC_ASYNC_INT_MASK_0_HGP8_INT_MASK_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_MASK_0_HGP8_INT_MASK_SHIFT)
#define APB_MISC_ASYNC_INT_MASK_0_HGP8_INT_MASK_RANGE                   8:8
#define APB_MISC_ASYNC_INT_MASK_0_HGP8_INT_MASK_WOFFSET                 0x0
#define APB_MISC_ASYNC_INT_MASK_0_HGP8_INT_MASK_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP8_INT_MASK_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_MASK_0_HGP8_INT_MASK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP8_INT_MASK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP8_INT_MASK_MASKED                  _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP8_INT_MASK_NOTMASKED                       _MK_ENUM_CONST(1)

// HGP9 Interrupt Mask   0= interrupt masked
//   1= interrupt not masked
#define APB_MISC_ASYNC_INT_MASK_0_HGP9_INT_MASK_SHIFT                   _MK_SHIFT_CONST(9)
#define APB_MISC_ASYNC_INT_MASK_0_HGP9_INT_MASK_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_MASK_0_HGP9_INT_MASK_SHIFT)
#define APB_MISC_ASYNC_INT_MASK_0_HGP9_INT_MASK_RANGE                   9:9
#define APB_MISC_ASYNC_INT_MASK_0_HGP9_INT_MASK_WOFFSET                 0x0
#define APB_MISC_ASYNC_INT_MASK_0_HGP9_INT_MASK_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP9_INT_MASK_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_MASK_0_HGP9_INT_MASK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP9_INT_MASK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP9_INT_MASK_MASKED                  _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP9_INT_MASK_NOTMASKED                       _MK_ENUM_CONST(1)

// HGP10 Interrupt Mask   0= interrupt masked
//   1= interrupt not masked
#define APB_MISC_ASYNC_INT_MASK_0_HGP10_INT_MASK_SHIFT                  _MK_SHIFT_CONST(10)
#define APB_MISC_ASYNC_INT_MASK_0_HGP10_INT_MASK_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_MASK_0_HGP10_INT_MASK_SHIFT)
#define APB_MISC_ASYNC_INT_MASK_0_HGP10_INT_MASK_RANGE                  10:10
#define APB_MISC_ASYNC_INT_MASK_0_HGP10_INT_MASK_WOFFSET                        0x0
#define APB_MISC_ASYNC_INT_MASK_0_HGP10_INT_MASK_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP10_INT_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_MASK_0_HGP10_INT_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP10_INT_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP10_INT_MASK_MASKED                 _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP10_INT_MASK_NOTMASKED                      _MK_ENUM_CONST(1)

// HGP11 Interrupt Mask   0= interrupt masked
//   1= interrupt not masked
#define APB_MISC_ASYNC_INT_MASK_0_HGP11_INT_MASK_SHIFT                  _MK_SHIFT_CONST(11)
#define APB_MISC_ASYNC_INT_MASK_0_HGP11_INT_MASK_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_MASK_0_HGP11_INT_MASK_SHIFT)
#define APB_MISC_ASYNC_INT_MASK_0_HGP11_INT_MASK_RANGE                  11:11
#define APB_MISC_ASYNC_INT_MASK_0_HGP11_INT_MASK_WOFFSET                        0x0
#define APB_MISC_ASYNC_INT_MASK_0_HGP11_INT_MASK_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP11_INT_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_MASK_0_HGP11_INT_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP11_INT_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP11_INT_MASK_MASKED                 _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP11_INT_MASK_NOTMASKED                      _MK_ENUM_CONST(1)

// HGP12 Interrupt Mask   0= interrupt masked
//   1= interrupt not masked
#define APB_MISC_ASYNC_INT_MASK_0_HGP12_INT_MASK_SHIFT                  _MK_SHIFT_CONST(12)
#define APB_MISC_ASYNC_INT_MASK_0_HGP12_INT_MASK_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_MASK_0_HGP12_INT_MASK_SHIFT)
#define APB_MISC_ASYNC_INT_MASK_0_HGP12_INT_MASK_RANGE                  12:12
#define APB_MISC_ASYNC_INT_MASK_0_HGP12_INT_MASK_WOFFSET                        0x0
#define APB_MISC_ASYNC_INT_MASK_0_HGP12_INT_MASK_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP12_INT_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_MASK_0_HGP12_INT_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP12_INT_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP12_INT_MASK_MASKED                 _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_MASK_0_HGP12_INT_MASK_NOTMASKED                      _MK_ENUM_CONST(1)


// Register APB_MISC_ASYNC_INT_POLARITY_0  // Interrupt Polarity
//  These bits specify whether a pending interrupt 
//  is generated on falling edge or on rising edge 
//  of the corresponding input signal/event.
//        0       rw  HGP0_INT_POLARITY  i=0x0  // HGP0 Interrupt Polarity
//      enum ( LOW, HIGH )                    //   0= falling edge interrupt
//                                            //   1= rising edge interrupt
//      1       rw  HGP1_INT_POLARITY  i=0x0  // HGP1 Interrupt Polarity
//      enum ( LOW, HIGH )                    //   0= falling edge interrupt
//                                            //   1= rising edge interrupt
//      2       rw  HGP2_INT_POLARITY  i=0x0  // HGP2 Interrupt Polarity
//      enum ( LOW, HIGH )                    //   0= falling edge interrupt
//                                            //   1= rising edge interrupt
//      4       rw  HGP4_INT_POLARITY  i=0x0  // HGP4 Interrupt Polarity
//      enum ( LOW, HIGH )                    //   0= falling edge interrupt
//                                            //   1= rising edge interrupt
//      5       rw  HGP5_INT_POLARITY  i=0x0  // HGP5 Interrupt Polarity
//      enum ( LOW, HIGH )                    //   0= falling edge interrupt
//                                            //   1= rising edge interrupt
//      6       rw  HGP6_INT_POLARITY  i=0x0  // HGP6 Interrupt Polarity
//      enum ( LOW, HIGH )                    //   0= falling edge interrupt
//                                            //   1= rising edge interrupt
#define APB_MISC_ASYNC_INT_POLARITY_0                   _MK_ADDR_CONST(0x450)
#define APB_MISC_ASYNC_INT_POLARITY_0_WORD_COUNT                        0x1
#define APB_MISC_ASYNC_INT_POLARITY_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_RESET_MASK                        _MK_MASK_CONST(0x1f80)
#define APB_MISC_ASYNC_INT_POLARITY_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_READ_MASK                         _MK_MASK_CONST(0x1f80)
#define APB_MISC_ASYNC_INT_POLARITY_0_WRITE_MASK                        _MK_MASK_CONST(0x1f80)
// HGP7 Interrupt Polarity   0= falling edge interrupt
//   1= rising edge interrupt
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP7_INT_POLARITY_SHIFT                   _MK_SHIFT_CONST(7)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP7_INT_POLARITY_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_POLARITY_0_HGP7_INT_POLARITY_SHIFT)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP7_INT_POLARITY_RANGE                   7:7
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP7_INT_POLARITY_WOFFSET                 0x0
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP7_INT_POLARITY_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP7_INT_POLARITY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP7_INT_POLARITY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP7_INT_POLARITY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP7_INT_POLARITY_LOW                     _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP7_INT_POLARITY_HIGH                    _MK_ENUM_CONST(1)

// HGP8 Interrupt Polarity   0= falling edge interrupt
//   1= rising edge interrupt
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP8_INT_POLARITY_SHIFT                   _MK_SHIFT_CONST(8)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP8_INT_POLARITY_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_POLARITY_0_HGP8_INT_POLARITY_SHIFT)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP8_INT_POLARITY_RANGE                   8:8
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP8_INT_POLARITY_WOFFSET                 0x0
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP8_INT_POLARITY_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP8_INT_POLARITY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP8_INT_POLARITY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP8_INT_POLARITY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP8_INT_POLARITY_LOW                     _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP8_INT_POLARITY_HIGH                    _MK_ENUM_CONST(1)

// HGP9 Interrupt Polarity   0= falling edge interrupt
//   1= rising edge interrupt
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP9_INT_POLARITY_SHIFT                   _MK_SHIFT_CONST(9)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP9_INT_POLARITY_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_POLARITY_0_HGP9_INT_POLARITY_SHIFT)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP9_INT_POLARITY_RANGE                   9:9
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP9_INT_POLARITY_WOFFSET                 0x0
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP9_INT_POLARITY_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP9_INT_POLARITY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP9_INT_POLARITY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP9_INT_POLARITY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP9_INT_POLARITY_LOW                     _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP9_INT_POLARITY_HIGH                    _MK_ENUM_CONST(1)

// HGP10 Interrupt Polarity   0= falling edge interrupt
//   1= rising edge interrupt
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP10_INT_POLARITY_SHIFT                  _MK_SHIFT_CONST(10)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP10_INT_POLARITY_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_POLARITY_0_HGP10_INT_POLARITY_SHIFT)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP10_INT_POLARITY_RANGE                  10:10
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP10_INT_POLARITY_WOFFSET                        0x0
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP10_INT_POLARITY_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP10_INT_POLARITY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP10_INT_POLARITY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP10_INT_POLARITY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP10_INT_POLARITY_LOW                    _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP10_INT_POLARITY_HIGH                   _MK_ENUM_CONST(1)

// HGP11 Interrupt Polarity   0= falling edge interrupt
//   1= rising edge interrupt
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP11_INT_POLARITY_SHIFT                  _MK_SHIFT_CONST(11)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP11_INT_POLARITY_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_POLARITY_0_HGP11_INT_POLARITY_SHIFT)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP11_INT_POLARITY_RANGE                  11:11
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP11_INT_POLARITY_WOFFSET                        0x0
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP11_INT_POLARITY_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP11_INT_POLARITY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP11_INT_POLARITY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP11_INT_POLARITY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP11_INT_POLARITY_LOW                    _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP11_INT_POLARITY_HIGH                   _MK_ENUM_CONST(1)

// HGP12 Interrupt Polarity   0= falling edge interrupt
//   1= rising edge interrupt
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP12_INT_POLARITY_SHIFT                  _MK_SHIFT_CONST(12)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP12_INT_POLARITY_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_POLARITY_0_HGP12_INT_POLARITY_SHIFT)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP12_INT_POLARITY_RANGE                  12:12
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP12_INT_POLARITY_WOFFSET                        0x0
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP12_INT_POLARITY_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP12_INT_POLARITY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP12_INT_POLARITY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP12_INT_POLARITY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP12_INT_POLARITY_LOW                    _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_POLARITY_0_HGP12_INT_POLARITY_HIGH                   _MK_ENUM_CONST(1)


// Register APB_MISC_ASYNC_INT_TYPE_SELECT_0  // Interrupt Type
//  These bits specify whether an interrupt 
//  is generated on an edge of a level type.
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0                        _MK_ADDR_CONST(0x454)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_WORD_COUNT                     0x1
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_RESET_MASK                     _MK_MASK_CONST(0x1f80)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_READ_MASK                      _MK_MASK_CONST(0x1f80)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_WRITE_MASK                     _MK_MASK_CONST(0x1f80)
// HGP7 Interrupt Type   0= Edge type
//   1= Level type
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP7_INT_TYPE_SHIFT                    _MK_SHIFT_CONST(7)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP7_INT_TYPE_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP7_INT_TYPE_SHIFT)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP7_INT_TYPE_RANGE                    7:7
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP7_INT_TYPE_WOFFSET                  0x0
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP7_INT_TYPE_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP7_INT_TYPE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP7_INT_TYPE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP7_INT_TYPE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP7_INT_TYPE_EDGE                     _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP7_INT_TYPE_LEVEL                    _MK_ENUM_CONST(1)

// HGP8 Interrupt Polarity   0= Edge type
//   1= Level type
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP8_INT_TYPE_SHIFT                    _MK_SHIFT_CONST(8)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP8_INT_TYPE_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP8_INT_TYPE_SHIFT)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP8_INT_TYPE_RANGE                    8:8
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP8_INT_TYPE_WOFFSET                  0x0
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP8_INT_TYPE_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP8_INT_TYPE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP8_INT_TYPE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP8_INT_TYPE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP8_INT_TYPE_EDGE                     _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP8_INT_TYPE_LEVEL                    _MK_ENUM_CONST(1)

// HGP9 Interrupt Polarity   0= Edge type
//   1= Level type
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP9_INT_TYPE_SHIFT                    _MK_SHIFT_CONST(9)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP9_INT_TYPE_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP9_INT_TYPE_SHIFT)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP9_INT_TYPE_RANGE                    9:9
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP9_INT_TYPE_WOFFSET                  0x0
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP9_INT_TYPE_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP9_INT_TYPE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP9_INT_TYPE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP9_INT_TYPE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP9_INT_TYPE_EDGE                     _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP9_INT_TYPE_LEVEL                    _MK_ENUM_CONST(1)

// HGP10 Interrupt Polarity   0= Edge type
//   1= Level type
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP10_INT_TYPE_SHIFT                   _MK_SHIFT_CONST(10)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP10_INT_TYPE_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP10_INT_TYPE_SHIFT)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP10_INT_TYPE_RANGE                   10:10
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP10_INT_TYPE_WOFFSET                 0x0
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP10_INT_TYPE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP10_INT_TYPE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP10_INT_TYPE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP10_INT_TYPE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP10_INT_TYPE_EDGE                    _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP10_INT_TYPE_LEVEL                   _MK_ENUM_CONST(1)

// HGP11 Interrupt Polarity   0= Edge type
//   1= Level type
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP11_INT_TYPE_SHIFT                   _MK_SHIFT_CONST(11)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP11_INT_TYPE_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP11_INT_TYPE_SHIFT)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP11_INT_TYPE_RANGE                   11:11
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP11_INT_TYPE_WOFFSET                 0x0
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP11_INT_TYPE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP11_INT_TYPE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP11_INT_TYPE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP11_INT_TYPE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP11_INT_TYPE_EDGE                    _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP11_INT_TYPE_LEVEL                   _MK_ENUM_CONST(1)

// HGP12 Interrupt Polarity   0= Edge type
//   1= Level type
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP12_INT_TYPE_SHIFT                   _MK_SHIFT_CONST(12)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP12_INT_TYPE_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP12_INT_TYPE_SHIFT)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP12_INT_TYPE_RANGE                   12:12
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP12_INT_TYPE_WOFFSET                 0x0
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP12_INT_TYPE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP12_INT_TYPE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP12_INT_TYPE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP12_INT_TYPE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP12_INT_TYPE_EDGE                    _MK_ENUM_CONST(0)
#define APB_MISC_ASYNC_INT_TYPE_SELECT_0_HGP12_INT_TYPE_LEVEL                   _MK_ENUM_CONST(1)


// Register APB_MISC_GP_MODEREG_0  
#define APB_MISC_GP_MODEREG_0                   _MK_ADDR_CONST(0x800)
#define APB_MISC_GP_MODEREG_0_WORD_COUNT                        0x1
#define APB_MISC_GP_MODEREG_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MODEREG_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MODEREG_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MODEREG_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MODEREG_0_READ_MASK                         _MK_MASK_CONST(0x301)
#define APB_MISC_GP_MODEREG_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
// Standby pad input 1 = STANDBYN is    asserted (low  voltage),                   0 = STANDBYN is desasserted (high voltage)
#define APB_MISC_GP_MODEREG_0_STANDBY_IE_SHIFT                  _MK_SHIFT_CONST(0)
#define APB_MISC_GP_MODEREG_0_STANDBY_IE_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_GP_MODEREG_0_STANDBY_IE_SHIFT)
#define APB_MISC_GP_MODEREG_0_STANDBY_IE_RANGE                  0:0
#define APB_MISC_GP_MODEREG_0_STANDBY_IE_WOFFSET                        0x0
#define APB_MISC_GP_MODEREG_0_STANDBY_IE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MODEREG_0_STANDBY_IE_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MODEREG_0_STANDBY_IE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MODEREG_0_STANDBY_IE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MODEREG_0_STANDBY_IE_DEASSERTED                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_MODEREG_0_STANDBY_IE_ASSERTED                       _MK_ENUM_CONST(1)

// LP-DDR Strap option bit 0.
#define APB_MISC_GP_MODEREG_0_LPDDR_STRAP0_SHIFT                        _MK_SHIFT_CONST(8)
#define APB_MISC_GP_MODEREG_0_LPDDR_STRAP0_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_GP_MODEREG_0_LPDDR_STRAP0_SHIFT)
#define APB_MISC_GP_MODEREG_0_LPDDR_STRAP0_RANGE                        8:8
#define APB_MISC_GP_MODEREG_0_LPDDR_STRAP0_WOFFSET                      0x0
#define APB_MISC_GP_MODEREG_0_LPDDR_STRAP0_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MODEREG_0_LPDDR_STRAP0_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MODEREG_0_LPDDR_STRAP0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MODEREG_0_LPDDR_STRAP0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// LP-DDR Strap option bit 1.
#define APB_MISC_GP_MODEREG_0_LPDDR_STRAP1_SHIFT                        _MK_SHIFT_CONST(9)
#define APB_MISC_GP_MODEREG_0_LPDDR_STRAP1_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_GP_MODEREG_0_LPDDR_STRAP1_SHIFT)
#define APB_MISC_GP_MODEREG_0_LPDDR_STRAP1_RANGE                        9:9
#define APB_MISC_GP_MODEREG_0_LPDDR_STRAP1_WOFFSET                      0x0
#define APB_MISC_GP_MODEREG_0_LPDDR_STRAP1_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MODEREG_0_LPDDR_STRAP1_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MODEREG_0_LPDDR_STRAP1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MODEREG_0_LPDDR_STRAP1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_HIDREV_0  
#define APB_MISC_GP_HIDREV_0                    _MK_ADDR_CONST(0x804)
#define APB_MISC_GP_HIDREV_0_WORD_COUNT                         0x1
#define APB_MISC_GP_HIDREV_0_RESET_VAL                  _MK_MASK_CONST(0x31617)
#define APB_MISC_GP_HIDREV_0_RESET_MASK                         _MK_MASK_CONST(0xfffff)
#define APB_MISC_GP_HIDREV_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_HIDREV_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_HIDREV_0_READ_MASK                  _MK_MASK_CONST(0xfffff)
#define APB_MISC_GP_HIDREV_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
// Chip ID family register. There maybe a new HIDFAM code
// added for MG20 products, this is still being descided.
#define APB_MISC_GP_HIDREV_0_HIDFAM_SHIFT                       _MK_SHIFT_CONST(0)
#define APB_MISC_GP_HIDREV_0_HIDFAM_FIELD                       (_MK_MASK_CONST(0xf) << APB_MISC_GP_HIDREV_0_HIDFAM_SHIFT)
#define APB_MISC_GP_HIDREV_0_HIDFAM_RANGE                       3:0
#define APB_MISC_GP_HIDREV_0_HIDFAM_WOFFSET                     0x0
#define APB_MISC_GP_HIDREV_0_HIDFAM_DEFAULT                     _MK_MASK_CONST(0x7)
#define APB_MISC_GP_HIDREV_0_HIDFAM_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APB_MISC_GP_HIDREV_0_HIDFAM_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_HIDREV_0_HIDFAM_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_HIDREV_0_HIDFAM_GPU                 _MK_ENUM_CONST(0)
#define APB_MISC_GP_HIDREV_0_HIDFAM_HANDHELD                    _MK_ENUM_CONST(1)
#define APB_MISC_GP_HIDREV_0_HIDFAM_BR_CHIPS                    _MK_ENUM_CONST(2)
#define APB_MISC_GP_HIDREV_0_HIDFAM_CRUSH                       _MK_ENUM_CONST(3)
#define APB_MISC_GP_HIDREV_0_HIDFAM_MCP                 _MK_ENUM_CONST(4)
#define APB_MISC_GP_HIDREV_0_HIDFAM_CK                  _MK_ENUM_CONST(5)
#define APB_MISC_GP_HIDREV_0_HIDFAM_VAIO                        _MK_ENUM_CONST(6)
#define APB_MISC_GP_HIDREV_0_HIDFAM_HANDHELD_SOC                        _MK_ENUM_CONST(7)

// Chip ID major revision (0: Emulation, 1-15: Silicon)
#define APB_MISC_GP_HIDREV_0_MAJORREV_SHIFT                     _MK_SHIFT_CONST(4)
#define APB_MISC_GP_HIDREV_0_MAJORREV_FIELD                     (_MK_MASK_CONST(0xf) << APB_MISC_GP_HIDREV_0_MAJORREV_SHIFT)
#define APB_MISC_GP_HIDREV_0_MAJORREV_RANGE                     7:4
#define APB_MISC_GP_HIDREV_0_MAJORREV_WOFFSET                   0x0
#define APB_MISC_GP_HIDREV_0_MAJORREV_DEFAULT                   _MK_MASK_CONST(0x1)
#define APB_MISC_GP_HIDREV_0_MAJORREV_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APB_MISC_GP_HIDREV_0_MAJORREV_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_HIDREV_0_MAJORREV_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_HIDREV_0_MAJORREV_EMULATION                 _MK_ENUM_CONST(0)
#define APB_MISC_GP_HIDREV_0_MAJORREV_A01                       _MK_ENUM_CONST(1)

// Chip ID
#define APB_MISC_GP_HIDREV_0_CHIPID_SHIFT                       _MK_SHIFT_CONST(8)
#define APB_MISC_GP_HIDREV_0_CHIPID_FIELD                       (_MK_MASK_CONST(0xff) << APB_MISC_GP_HIDREV_0_CHIPID_SHIFT)
#define APB_MISC_GP_HIDREV_0_CHIPID_RANGE                       15:8
#define APB_MISC_GP_HIDREV_0_CHIPID_WOFFSET                     0x0
#define APB_MISC_GP_HIDREV_0_CHIPID_DEFAULT                     _MK_MASK_CONST(0x16)
#define APB_MISC_GP_HIDREV_0_CHIPID_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define APB_MISC_GP_HIDREV_0_CHIPID_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_HIDREV_0_CHIPID_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Chip ID minor revision (IF MAJORREV==0(Emulation) THEN  0: QT, 1:E388 FPGA)
#define APB_MISC_GP_HIDREV_0_MINORREV_SHIFT                     _MK_SHIFT_CONST(16)
#define APB_MISC_GP_HIDREV_0_MINORREV_FIELD                     (_MK_MASK_CONST(0xf) << APB_MISC_GP_HIDREV_0_MINORREV_SHIFT)
#define APB_MISC_GP_HIDREV_0_MINORREV_RANGE                     19:16
#define APB_MISC_GP_HIDREV_0_MINORREV_WOFFSET                   0x0
#define APB_MISC_GP_HIDREV_0_MINORREV_DEFAULT                   _MK_MASK_CONST(0x3)
#define APB_MISC_GP_HIDREV_0_MINORREV_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APB_MISC_GP_HIDREV_0_MINORREV_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_HIDREV_0_MINORREV_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Reserved address 2056 [0x808] 

// Reserved address 2060 [0x80c] 

// Register APB_MISC_GP_ASDBGREG_0  
#define APB_MISC_GP_ASDBGREG_0                  _MK_ADDR_CONST(0x810)
#define APB_MISC_GP_ASDBGREG_0_WORD_COUNT                       0x1
#define APB_MISC_GP_ASDBGREG_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_RESET_MASK                       _MK_MASK_CONST(0x3ff0ffdf)
#define APB_MISC_GP_ASDBGREG_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_READ_MASK                        _MK_MASK_CONST(0x3ff0ffdf)
#define APB_MISC_GP_ASDBGREG_0_WRITE_MASK                       _MK_MASK_CONST(0x3ff0ffdf)
// Enables iddq (WARNING: Will functionally kill chip)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_IDDQ_EN_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_IDDQ_EN_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_IDDQ_EN_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_IDDQ_EN_RANGE                    0:0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_IDDQ_EN_WOFFSET                  0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_IDDQ_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_IDDQ_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_IDDQ_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_IDDQ_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_IDDQ_EN_DISABLE                  _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_IDDQ_EN_ENABLE                   _MK_ENUM_CONST(1)

// Enables pullup
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLUP_EN_SHIFT                  _MK_SHIFT_CONST(1)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLUP_EN_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLUP_EN_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLUP_EN_RANGE                  1:1
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLUP_EN_WOFFSET                        0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLUP_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLUP_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLUP_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLUP_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLUP_EN_DISABLE                        _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLUP_EN_ENABLE                 _MK_ENUM_CONST(1)

// Enables pulldown
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLDOWN_EN_SHIFT                        _MK_SHIFT_CONST(2)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLDOWN_EN_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLDOWN_EN_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLDOWN_EN_RANGE                        2:2
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLDOWN_EN_WOFFSET                      0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLDOWN_EN_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLDOWN_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLDOWN_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLDOWN_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLDOWN_EN_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PULLDOWN_EN_ENABLE                       _MK_ENUM_CONST(1)

// Enables debug mode
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_DEBUG_ENABLE_SHIFT                       _MK_SHIFT_CONST(3)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_DEBUG_ENABLE_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_DEBUG_ENABLE_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_DEBUG_ENABLE_RANGE                       3:3
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_DEBUG_ENABLE_WOFFSET                     0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_DEBUG_ENABLE_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_DEBUG_ENABLE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_DEBUG_ENABLE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_DEBUG_ENABLE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_DEBUG_ENABLE_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_DEBUG_ENABLE_ENABLE                      _MK_ENUM_CONST(1)

// Enables performance monitor mode
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PM_ENABLE_SHIFT                  _MK_SHIFT_CONST(4)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PM_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_PM_ENABLE_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PM_ENABLE_RANGE                  4:4
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PM_ENABLE_WOFFSET                        0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PM_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PM_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PM_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PM_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PM_ENABLE_DISABLE                        _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_PM_ENABLE_ENABLE                 _MK_ENUM_CONST(1)

#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_CLKBYP_FUNC_SHIFT                        _MK_SHIFT_CONST(6)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_CLKBYP_FUNC_FIELD                        (_MK_MASK_CONST(0x3) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_CLKBYP_FUNC_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_CLKBYP_FUNC_RANGE                        7:6
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_CLKBYP_FUNC_WOFFSET                      0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_CLKBYP_FUNC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_CLKBYP_FUNC_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_CLKBYP_FUNC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_CLKBYP_FUNC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_CLKBYP_FUNC_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_CLKBYP_FUNC_ENABLE                       _MK_ENUM_CONST(1)

#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T1CLK_SHIFT                        _MK_SHIFT_CONST(8)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T1CLK_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T1CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T1CLK_RANGE                        8:8
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T1CLK_WOFFSET                      0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T1CLK_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T1CLK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T1CLK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T1CLK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T1CLK_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T1CLK_ENABLE                       _MK_ENUM_CONST(1)

#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T2CLK_SHIFT                        _MK_SHIFT_CONST(9)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T2CLK_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T2CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T2CLK_RANGE                        9:9
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T2CLK_WOFFSET                      0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T2CLK_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T2CLK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T2CLK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T2CLK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T2CLK_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T2CLK_ENABLE                       _MK_ENUM_CONST(1)

#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T3CLK_SHIFT                        _MK_SHIFT_CONST(10)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T3CLK_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T3CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T3CLK_RANGE                        10:10
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T3CLK_WOFFSET                      0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T3CLK_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T3CLK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T3CLK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T3CLK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T3CLK_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T3CLK_ENABLE                       _MK_ENUM_CONST(1)

#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T4CLK_SHIFT                        _MK_SHIFT_CONST(11)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T4CLK_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T4CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T4CLK_RANGE                        11:11
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T4CLK_WOFFSET                      0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T4CLK_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T4CLK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T4CLK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T4CLK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T4CLK_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T4CLK_ENABLE                       _MK_ENUM_CONST(1)

#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T5CLK_SHIFT                        _MK_SHIFT_CONST(12)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T5CLK_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T5CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T5CLK_RANGE                        12:12
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T5CLK_WOFFSET                      0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T5CLK_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T5CLK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T5CLK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T5CLK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T5CLK_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T5CLK_ENABLE                       _MK_ENUM_CONST(1)

#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T6CLK_SHIFT                        _MK_SHIFT_CONST(13)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T6CLK_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T6CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T6CLK_RANGE                        13:13
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T6CLK_WOFFSET                      0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T6CLK_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T6CLK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T6CLK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T6CLK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T6CLK_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T6CLK_ENABLE                       _MK_ENUM_CONST(1)

#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T7CLK_SHIFT                        _MK_SHIFT_CONST(14)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T7CLK_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T7CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T7CLK_RANGE                        14:14
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T7CLK_WOFFSET                      0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T7CLK_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T7CLK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T7CLK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T7CLK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T7CLK_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_T7CLK_ENABLE                       _MK_ENUM_CONST(1)

//  Obsolete previously used with host_pad_macros (jmoskal)
//16      rw  CFG2TMC_SW_BP_WRNCLK      i=0x0
//    enum ( DISABLE, ENABLE )
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_CLK_DIV_SHIFT                      _MK_SHIFT_CONST(15)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_CLK_DIV_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_CLK_DIV_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_CLK_DIV_RANGE                      15:15
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_CLK_DIV_WOFFSET                    0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_CLK_DIV_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_CLK_DIV_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_CLK_DIV_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_CLK_DIV_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_CLK_DIV_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_SW_BP_CLK_DIV_ENABLE                     _MK_ENUM_CONST(1)

// control timing characteristics for the compiled rams
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_EMAA_SHIFT                   _MK_SHIFT_CONST(20)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_EMAA_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_EMAA_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_EMAA_RANGE                   21:20
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_EMAA_WOFFSET                 0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_EMAA_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_EMAA_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_EMAA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_EMAA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_EMAA_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_EMAA_ENABLE                  _MK_ENUM_CONST(1)

// control write timing characteristics for the compiled RAMDP
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_DP_SHIFT                        _MK_SHIFT_CONST(22)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_DP_FIELD                        (_MK_MASK_CONST(0x3) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_DP_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_DP_RANGE                        23:22
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_DP_WOFFSET                      0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_DP_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_DP_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_DP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_DP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// control write timing characteristics for the compiled RAMPDP
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_PDP_SHIFT                       _MK_SHIFT_CONST(24)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_PDP_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_PDP_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_PDP_RANGE                       25:24
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_PDP_WOFFSET                     0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_PDP_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_PDP_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_PDP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_PDP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// control write timing characteristics for the compiled RAMREG
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_REG_SHIFT                       _MK_SHIFT_CONST(26)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_REG_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_REG_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_REG_RANGE                       27:26
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_REG_WOFFSET                     0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_REG_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_REG_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_REG_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_REG_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// control write timing characteristics for the compiled RAMSP
// ECO 385781, add reset to RAM_SVOP_SP
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_SP_SHIFT                        _MK_SHIFT_CONST(28)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_SP_FIELD                        (_MK_MASK_CONST(0x3) << APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_SP_SHIFT)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_SP_RANGE                        29:28
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_SP_WOFFSET                      0x0
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_SP_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_SP_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_SP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG_0_CFG2TMC_RAM_SVOP_SP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_RESERVEREG_0  
#define APB_MISC_GP_RESERVEREG_0                        _MK_ADDR_CONST(0x814)
#define APB_MISC_GP_RESERVEREG_0_WORD_COUNT                     0x1
#define APB_MISC_GP_RESERVEREG_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define APB_MISC_GP_RESERVEREG_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define APB_MISC_GP_RESERVEREG_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE0_SHIFT                     _MK_SHIFT_CONST(0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE0_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_RESERVEREG_0_ECO_RESERVE0_SHIFT)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE0_RANGE                     0:0
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE0_WOFFSET                   0x0
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE0_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE1_SHIFT                     _MK_SHIFT_CONST(1)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE1_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_RESERVEREG_0_ECO_RESERVE1_SHIFT)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE1_RANGE                     1:1
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE1_WOFFSET                   0x0
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE1_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE2_SHIFT                     _MK_SHIFT_CONST(2)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE2_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_RESERVEREG_0_ECO_RESERVE2_SHIFT)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE2_RANGE                     2:2
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE2_WOFFSET                   0x0
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE2_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE3_SHIFT                     _MK_SHIFT_CONST(3)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE3_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_RESERVEREG_0_ECO_RESERVE3_SHIFT)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE3_RANGE                     3:3
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE3_WOFFSET                   0x0
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE3_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE3_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE4_SHIFT                     _MK_SHIFT_CONST(4)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE4_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_RESERVEREG_0_ECO_RESERVE4_SHIFT)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE4_RANGE                     4:4
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE4_WOFFSET                   0x0
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE4_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE4_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE4_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE4_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE5_SHIFT                     _MK_SHIFT_CONST(5)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE5_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_RESERVEREG_0_ECO_RESERVE5_SHIFT)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE5_RANGE                     5:5
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE5_WOFFSET                   0x0
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE5_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE5_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE5_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE5_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE6_SHIFT                     _MK_SHIFT_CONST(6)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE6_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_RESERVEREG_0_ECO_RESERVE6_SHIFT)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE6_RANGE                     6:6
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE6_WOFFSET                   0x0
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE6_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE6_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE6_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE6_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE7_SHIFT                     _MK_SHIFT_CONST(7)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE7_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_RESERVEREG_0_ECO_RESERVE7_SHIFT)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE7_RANGE                     7:7
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE7_WOFFSET                   0x0
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE7_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE7_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE7_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE7_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B1_SHIFT                   _MK_SHIFT_CONST(8)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B1_FIELD                   (_MK_MASK_CONST(0xff) << APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B1_SHIFT)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B1_RANGE                   15:8
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B1_WOFFSET                 0x0
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B1_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B1_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B2_SHIFT                   _MK_SHIFT_CONST(16)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B2_FIELD                   (_MK_MASK_CONST(0xff) << APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B2_SHIFT)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B2_RANGE                   23:16
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B2_WOFFSET                 0x0
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B2_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B2_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B3_SHIFT                   _MK_SHIFT_CONST(24)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B3_FIELD                   (_MK_MASK_CONST(0xff) << APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B3_SHIFT)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B3_RANGE                   31:24
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B3_WOFFSET                 0x0
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B3_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B3_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B3_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_RESERVEREG_0_ECO_RESERVE_B3_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_OBSCTRL_0  
#define APB_MISC_GP_OBSCTRL_0                   _MK_ADDR_CONST(0x818)
#define APB_MISC_GP_OBSCTRL_0_WORD_COUNT                        0x1
#define APB_MISC_GP_OBSCTRL_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSCTRL_0_RESET_MASK                        _MK_MASK_CONST(0x80ffffff)
#define APB_MISC_GP_OBSCTRL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSCTRL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSCTRL_0_READ_MASK                         _MK_MASK_CONST(0x80ffffff)
#define APB_MISC_GP_OBSCTRL_0_WRITE_MASK                        _MK_MASK_CONST(0x80ffffff)
// Module-level mux select for determining which debug signals to send out
#define APB_MISC_GP_OBSCTRL_0_OBS_SIG_SEL_SHIFT                 _MK_SHIFT_CONST(0)
#define APB_MISC_GP_OBSCTRL_0_OBS_SIG_SEL_FIELD                 (_MK_MASK_CONST(0xffff) << APB_MISC_GP_OBSCTRL_0_OBS_SIG_SEL_SHIFT)
#define APB_MISC_GP_OBSCTRL_0_OBS_SIG_SEL_RANGE                 15:0
#define APB_MISC_GP_OBSCTRL_0_OBS_SIG_SEL_WOFFSET                       0x0
#define APB_MISC_GP_OBSCTRL_0_OBS_SIG_SEL_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSCTRL_0_OBS_SIG_SEL_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define APB_MISC_GP_OBSCTRL_0_OBS_SIG_SEL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSCTRL_0_OBS_SIG_SEL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Observation module select
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_SHIFT                 _MK_SHIFT_CONST(16)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_FIELD                 (_MK_MASK_CONST(0xf) << APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_SHIFT)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_RANGE                 19:16
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_WOFFSET                       0x0
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_PMC                   _MK_ENUM_CONST(0)    // // AO partition

#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_MSELECT                       _MK_ENUM_CONST(0)    // // CPU partition

#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_CSI                   _MK_ENUM_CONST(0)    // // DIS partition

#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_CSICIL                        _MK_ENUM_CONST(1)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_DISPLAY                       _MK_ENUM_CONST(2)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_DISPLAYB                      _MK_ENUM_CONST(3)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_DSI                   _MK_ENUM_CONST(4)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_HDMI                  _MK_ENUM_CONST(5)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_TVO                   _MK_ENUM_CONST(6)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_CAR                   _MK_ENUM_CONST(0)    // // GR partition

#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_CMC                   _MK_ENUM_CONST(1)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_EMC                   _MK_ENUM_CONST(2)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_FUSE                  _MK_ENUM_CONST(3)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_GR2D                  _MK_ENUM_CONST(4)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_HOST1X                        _MK_ENUM_CONST(5)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_MC                    _MK_ENUM_CONST(6)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_MPEA                  _MK_ENUM_CONST(0)    // // MPE partition

#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_MPEB                  _MK_ENUM_CONST(1)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_MPEC                  _MK_ENUM_CONST(2)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_STRAT12                       _MK_ENUM_CONST(0)    // // STRAT12 partition

#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_CLIP                  _MK_ENUM_CONST(0)    // // TDA partition

#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_IDX                   _MK_ENUM_CONST(1)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_SETUP                 _MK_ENUM_CONST(2)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_VPE                   _MK_ENUM_CONST(3)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_ALU                   _MK_ENUM_CONST(0)    // // TDB partition

#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_ATRAST                        _MK_ENUM_CONST(1)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_DWR                   _MK_ENUM_CONST(2)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_FDC                   _MK_ENUM_CONST(3)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_PSEQ                  _MK_ENUM_CONST(4)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_QRAST                 _MK_ENUM_CONST(5)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_TEX                   _MK_ENUM_CONST(6)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_UVDE                  _MK_ENUM_CONST(0)    // // VDE partition

#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_EPP                   _MK_ENUM_CONST(0)    // // VE partition

#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_ISP                   _MK_ENUM_CONST(1)
#define APB_MISC_GP_OBSCTRL_0_OBS_MOD_SEL_VI                    _MK_ENUM_CONST(2)

// Observation partition select
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_SHIFT                        _MK_SHIFT_CONST(20)
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_FIELD                        (_MK_MASK_CONST(0xf) << APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_SHIFT)
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_RANGE                        23:20
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_WOFFSET                      0x0
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_AO                   _MK_ENUM_CONST(0)
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_CPU                  _MK_ENUM_CONST(1)
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_DIS                  _MK_ENUM_CONST(2)
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_GR                   _MK_ENUM_CONST(3)
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_MPE                  _MK_ENUM_CONST(4)
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_ST                   _MK_ENUM_CONST(5)
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_TDA                  _MK_ENUM_CONST(6)
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_TDB                  _MK_ENUM_CONST(7)
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_VDE                  _MK_ENUM_CONST(8)
#define APB_MISC_GP_OBSCTRL_0_OBS_PART_SEL_VE                   _MK_ENUM_CONST(9)

// Observation bus enable
#define APB_MISC_GP_OBSCTRL_0_OBS_EN_SHIFT                      _MK_SHIFT_CONST(31)
#define APB_MISC_GP_OBSCTRL_0_OBS_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_OBSCTRL_0_OBS_EN_SHIFT)
#define APB_MISC_GP_OBSCTRL_0_OBS_EN_RANGE                      31:31
#define APB_MISC_GP_OBSCTRL_0_OBS_EN_WOFFSET                    0x0
#define APB_MISC_GP_OBSCTRL_0_OBS_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSCTRL_0_OBS_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_OBSCTRL_0_OBS_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSCTRL_0_OBS_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSCTRL_0_OBS_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_GP_OBSCTRL_0_OBS_EN_ENABLE                     _MK_ENUM_CONST(1)


// Register APB_MISC_GP_OBSDATA_0  
#define APB_MISC_GP_OBSDATA_0                   _MK_ADDR_CONST(0x81c)
#define APB_MISC_GP_OBSDATA_0_WORD_COUNT                        0x1
#define APB_MISC_GP_OBSDATA_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSDATA_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSDATA_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSDATA_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSDATA_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APB_MISC_GP_OBSDATA_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
// Observation port data.  This should be the same data that is going out on the observation bus.
#define APB_MISC_GP_OBSDATA_0_OBS_DATA_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_MISC_GP_OBSDATA_0_OBS_DATA_FIELD                    (_MK_MASK_CONST(0xffffffff) << APB_MISC_GP_OBSDATA_0_OBS_DATA_SHIFT)
#define APB_MISC_GP_OBSDATA_0_OBS_DATA_RANGE                    31:0
#define APB_MISC_GP_OBSDATA_0_OBS_DATA_WOFFSET                  0x0
#define APB_MISC_GP_OBSDATA_0_OBS_DATA_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSDATA_0_OBS_DATA_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSDATA_0_OBS_DATA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_OBSDATA_0_OBS_DATA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_EFUSEREQ_0  
#define APB_MISC_GP_EFUSEREQ_0                  _MK_ADDR_CONST(0x820)
#define APB_MISC_GP_EFUSEREQ_0_WORD_COUNT                       0x1
#define APB_MISC_GP_EFUSEREQ_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEREQ_0_RESET_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEREQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEREQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEREQ_0_READ_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEREQ_0_WRITE_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEREQ_0_EF_RESERVED0_SHIFT                       _MK_SHIFT_CONST(0)
#define APB_MISC_GP_EFUSEREQ_0_EF_RESERVED0_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_EFUSEREQ_0_EF_RESERVED0_SHIFT)
#define APB_MISC_GP_EFUSEREQ_0_EF_RESERVED0_RANGE                       0:0
#define APB_MISC_GP_EFUSEREQ_0_EF_RESERVED0_WOFFSET                     0x0
#define APB_MISC_GP_EFUSEREQ_0_EF_RESERVED0_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEREQ_0_EF_RESERVED0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEREQ_0_EF_RESERVED0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEREQ_0_EF_RESERVED0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_EFUSEOFF_0  
#define APB_MISC_GP_EFUSEOFF_0                  _MK_ADDR_CONST(0x824)
#define APB_MISC_GP_EFUSEOFF_0_WORD_COUNT                       0x1
#define APB_MISC_GP_EFUSEOFF_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEOFF_0_RESET_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEOFF_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEOFF_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEOFF_0_READ_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEOFF_0_WRITE_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEOFF_0_EF_RESERVED1_SHIFT                       _MK_SHIFT_CONST(0)
#define APB_MISC_GP_EFUSEOFF_0_EF_RESERVED1_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_EFUSEOFF_0_EF_RESERVED1_SHIFT)
#define APB_MISC_GP_EFUSEOFF_0_EF_RESERVED1_RANGE                       0:0
#define APB_MISC_GP_EFUSEOFF_0_EF_RESERVED1_WOFFSET                     0x0
#define APB_MISC_GP_EFUSEOFF_0_EF_RESERVED1_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEOFF_0_EF_RESERVED1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEOFF_0_EF_RESERVED1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEOFF_0_EF_RESERVED1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_EFUSEWRDAT_0  
#define APB_MISC_GP_EFUSEWRDAT_0                        _MK_ADDR_CONST(0x828)
#define APB_MISC_GP_EFUSEWRDAT_0_WORD_COUNT                     0x1
#define APB_MISC_GP_EFUSEWRDAT_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEWRDAT_0_RESET_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEWRDAT_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEWRDAT_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEWRDAT_0_READ_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEWRDAT_0_WRITE_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEWRDAT_0_EF_RESERVED2_SHIFT                     _MK_SHIFT_CONST(0)
#define APB_MISC_GP_EFUSEWRDAT_0_EF_RESERVED2_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_EFUSEWRDAT_0_EF_RESERVED2_SHIFT)
#define APB_MISC_GP_EFUSEWRDAT_0_EF_RESERVED2_RANGE                     0:0
#define APB_MISC_GP_EFUSEWRDAT_0_EF_RESERVED2_WOFFSET                   0x0
#define APB_MISC_GP_EFUSEWRDAT_0_EF_RESERVED2_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEWRDAT_0_EF_RESERVED2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEWRDAT_0_EF_RESERVED2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEWRDAT_0_EF_RESERVED2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_EFUSERDDAT_0  
#define APB_MISC_GP_EFUSERDDAT_0                        _MK_ADDR_CONST(0x82c)
#define APB_MISC_GP_EFUSERDDAT_0_WORD_COUNT                     0x1
#define APB_MISC_GP_EFUSERDDAT_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSERDDAT_0_RESET_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSERDDAT_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSERDDAT_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSERDDAT_0_READ_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSERDDAT_0_WRITE_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSERDDAT_0_EF_RESERVED3_SHIFT                     _MK_SHIFT_CONST(0)
#define APB_MISC_GP_EFUSERDDAT_0_EF_RESERVED3_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_EFUSERDDAT_0_EF_RESERVED3_SHIFT)
#define APB_MISC_GP_EFUSERDDAT_0_EF_RESERVED3_RANGE                     0:0
#define APB_MISC_GP_EFUSERDDAT_0_EF_RESERVED3_WOFFSET                   0x0
#define APB_MISC_GP_EFUSERDDAT_0_EF_RESERVED3_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSERDDAT_0_EF_RESERVED3_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSERDDAT_0_EF_RESERVED3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSERDDAT_0_EF_RESERVED3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_EFUSEVAL1_0  
#define APB_MISC_GP_EFUSEVAL1_0                 _MK_ADDR_CONST(0x830)
#define APB_MISC_GP_EFUSEVAL1_0_WORD_COUNT                      0x1
#define APB_MISC_GP_EFUSEVAL1_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEVAL1_0_RESET_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEVAL1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEVAL1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEVAL1_0_READ_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEVAL1_0_WRITE_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEVAL1_0_EF_RESERVED4_SHIFT                      _MK_SHIFT_CONST(0)
#define APB_MISC_GP_EFUSEVAL1_0_EF_RESERVED4_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_EFUSEVAL1_0_EF_RESERVED4_SHIFT)
#define APB_MISC_GP_EFUSEVAL1_0_EF_RESERVED4_RANGE                      0:0
#define APB_MISC_GP_EFUSEVAL1_0_EF_RESERVED4_WOFFSET                    0x0
#define APB_MISC_GP_EFUSEVAL1_0_EF_RESERVED4_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEVAL1_0_EF_RESERVED4_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEVAL1_0_EF_RESERVED4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEVAL1_0_EF_RESERVED4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_EFUSEVAL2_0  
#define APB_MISC_GP_EFUSEVAL2_0                 _MK_ADDR_CONST(0x834)
#define APB_MISC_GP_EFUSEVAL2_0_WORD_COUNT                      0x1
#define APB_MISC_GP_EFUSEVAL2_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEVAL2_0_RESET_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEVAL2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEVAL2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEVAL2_0_READ_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEVAL2_0_WRITE_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEVAL2_0_EF_RESERVED5_SHIFT                      _MK_SHIFT_CONST(0)
#define APB_MISC_GP_EFUSEVAL2_0_EF_RESERVED5_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_EFUSEVAL2_0_EF_RESERVED5_SHIFT)
#define APB_MISC_GP_EFUSEVAL2_0_EF_RESERVED5_RANGE                      0:0
#define APB_MISC_GP_EFUSEVAL2_0_EF_RESERVED5_WOFFSET                    0x0
#define APB_MISC_GP_EFUSEVAL2_0_EF_RESERVED5_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEVAL2_0_EF_RESERVED5_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEVAL2_0_EF_RESERVED5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEVAL2_0_EF_RESERVED5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_EFUSEBYPASSID_0  
#define APB_MISC_GP_EFUSEBYPASSID_0                     _MK_ADDR_CONST(0x838)
#define APB_MISC_GP_EFUSEBYPASSID_0_WORD_COUNT                  0x1
#define APB_MISC_GP_EFUSEBYPASSID_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEBYPASSID_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEBYPASSID_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEBYPASSID_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEBYPASSID_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEBYPASSID_0_WRITE_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEBYPASSID_0_EF_RESERVED6_SHIFT                  _MK_SHIFT_CONST(0)
#define APB_MISC_GP_EFUSEBYPASSID_0_EF_RESERVED6_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_GP_EFUSEBYPASSID_0_EF_RESERVED6_SHIFT)
#define APB_MISC_GP_EFUSEBYPASSID_0_EF_RESERVED6_RANGE                  0:0
#define APB_MISC_GP_EFUSEBYPASSID_0_EF_RESERVED6_WOFFSET                        0x0
#define APB_MISC_GP_EFUSEBYPASSID_0_EF_RESERVED6_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEBYPASSID_0_EF_RESERVED6_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_GP_EFUSEBYPASSID_0_EF_RESERVED6_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EFUSEBYPASSID_0_EF_RESERVED6_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_BRDCLK_TRIM_0  
#define APB_MISC_GP_BRDCLK_TRIM_0                       _MK_ADDR_CONST(0x83c)
#define APB_MISC_GP_BRDCLK_TRIM_0_WORD_COUNT                    0x1
#define APB_MISC_GP_BRDCLK_TRIM_0_RESET_VAL                     _MK_MASK_CONST(0x4)
#define APB_MISC_GP_BRDCLK_TRIM_0_RESET_MASK                    _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_BRDCLK_TRIM_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_BRDCLK_TRIM_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_BRDCLK_TRIM_0_READ_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_BRDCLK_TRIM_0_WRITE_MASK                    _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_BRDCLK_TRIM_0_BRDCLKTRIM_SHIFT                      _MK_SHIFT_CONST(0)
#define APB_MISC_GP_BRDCLK_TRIM_0_BRDCLKTRIM_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_BRDCLK_TRIM_0_BRDCLKTRIM_SHIFT)
#define APB_MISC_GP_BRDCLK_TRIM_0_BRDCLKTRIM_RANGE                      4:0
#define APB_MISC_GP_BRDCLK_TRIM_0_BRDCLKTRIM_WOFFSET                    0x0
#define APB_MISC_GP_BRDCLK_TRIM_0_BRDCLKTRIM_DEFAULT                    _MK_MASK_CONST(0x4)
#define APB_MISC_GP_BRDCLK_TRIM_0_BRDCLKTRIM_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_BRDCLK_TRIM_0_BRDCLKTRIM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_BRDCLK_TRIM_0_BRDCLKTRIM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Reserved address 2112 [0x840] 

// Reserved address 2116 [0x844] 

// Reserved address 2120 [0x848] 

// Reserved address 2124 [0x84c] 

// Reserved address 2128 [0x850] 

// Reserved address 2132 [0x854] 

// Register APB_MISC_GP_ASDBGREG2_0  
#define APB_MISC_GP_ASDBGREG2_0                 _MK_ADDR_CONST(0x858)
#define APB_MISC_GP_ASDBGREG2_0_WORD_COUNT                      0x1
#define APB_MISC_GP_ASDBGREG2_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_RESET_MASK                      _MK_MASK_CONST(0x7ff80)
#define APB_MISC_GP_ASDBGREG2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_READ_MASK                       _MK_MASK_CONST(0x7ff80)
#define APB_MISC_GP_ASDBGREG2_0_WRITE_MASK                      _MK_MASK_CONST(0x7ff80)
//Enable bypass of functional clock with test clock 8
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T8CLK_SHIFT                       _MK_SHIFT_CONST(7)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T8CLK_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T8CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T8CLK_RANGE                       7:7
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T8CLK_WOFFSET                     0x0
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T8CLK_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T8CLK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T8CLK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T8CLK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T8CLK_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T8CLK_ENABLE                      _MK_ENUM_CONST(1)

//Enable bypass of functional clock with test clock 9
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T9CLK_SHIFT                       _MK_SHIFT_CONST(8)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T9CLK_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T9CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T9CLK_RANGE                       8:8
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T9CLK_WOFFSET                     0x0
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T9CLK_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T9CLK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T9CLK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T9CLK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T9CLK_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T9CLK_ENABLE                      _MK_ENUM_CONST(1)

//Enable bypass of functional clock with test clock 10
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T10CLK_SHIFT                      _MK_SHIFT_CONST(9)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T10CLK_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T10CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T10CLK_RANGE                      9:9
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T10CLK_WOFFSET                    0x0
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T10CLK_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T10CLK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T10CLK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T10CLK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T10CLK_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T10CLK_ENABLE                     _MK_ENUM_CONST(1)

//Enable bypass of functional clock with test clock 11
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T11CLK_SHIFT                      _MK_SHIFT_CONST(10)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T11CLK_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T11CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T11CLK_RANGE                      10:10
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T11CLK_WOFFSET                    0x0
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T11CLK_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T11CLK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T11CLK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T11CLK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T11CLK_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T11CLK_ENABLE                     _MK_ENUM_CONST(1)

//Enable bypass of functional clock with test clock 12
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T12CLK_SHIFT                      _MK_SHIFT_CONST(11)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T12CLK_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T12CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T12CLK_RANGE                      11:11
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T12CLK_WOFFSET                    0x0
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T12CLK_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T12CLK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T12CLK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T12CLK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T12CLK_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T12CLK_ENABLE                     _MK_ENUM_CONST(1)

//Enable bypass of functional clock with test clock 13
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T13CLK_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T13CLK_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T13CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T13CLK_RANGE                      12:12
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T13CLK_WOFFSET                    0x0
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T13CLK_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T13CLK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T13CLK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T13CLK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T13CLK_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T13CLK_ENABLE                     _MK_ENUM_CONST(1)

//Enable bypass of functional clock with test clock 14
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T14CLK_SHIFT                      _MK_SHIFT_CONST(13)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T14CLK_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T14CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T14CLK_RANGE                      13:13
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T14CLK_WOFFSET                    0x0
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T14CLK_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T14CLK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T14CLK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T14CLK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T14CLK_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T14CLK_ENABLE                     _MK_ENUM_CONST(1)

//Enable bypass of functional clock with test clock 15
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T15CLK_SHIFT                      _MK_SHIFT_CONST(14)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T15CLK_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T15CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T15CLK_RANGE                      14:14
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T15CLK_WOFFSET                    0x0
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T15CLK_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T15CLK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T15CLK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T15CLK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T15CLK_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T15CLK_ENABLE                     _MK_ENUM_CONST(1)

//Enable bypass of functional clock with test clock 16
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T16CLK_SHIFT                      _MK_SHIFT_CONST(15)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T16CLK_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T16CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T16CLK_RANGE                      15:15
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T16CLK_WOFFSET                    0x0
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T16CLK_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T16CLK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T16CLK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T16CLK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T16CLK_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T16CLK_ENABLE                     _MK_ENUM_CONST(1)

//Enable bypass of functional clock with test clock 17
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T17CLK_SHIFT                      _MK_SHIFT_CONST(16)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T17CLK_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T17CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T17CLK_RANGE                      16:16
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T17CLK_WOFFSET                    0x0
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T17CLK_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T17CLK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T17CLK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T17CLK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T17CLK_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T17CLK_ENABLE                     _MK_ENUM_CONST(1)

//Enable bypass of functional clock with test clock 18
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T18CLK_SHIFT                      _MK_SHIFT_CONST(17)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T18CLK_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T18CLK_SHIFT)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T18CLK_RANGE                      17:17
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T18CLK_WOFFSET                    0x0
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T18CLK_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T18CLK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T18CLK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T18CLK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T18CLK_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_T18CLK_ENABLE                     _MK_ENUM_CONST(1)

//Enable bypass of sync Already in NV_car
//  18       rw  CFG2TMC_OSCFI_BYPASS     i=0x0  //Enable bypass of oscfi
//            enum ( DISABLE, ENABLE )
//  19       rw  CFG2TMC_OSCFI_EN         i=0x0  //Enable oscfi refclk
//      enum ( DISABLE, ENABLE )
//      enum ( DISABLE, ENABLE )
//  25:21   rw  CFG2TMC_OSCFI_D           i=0x0  //
//  31:26   rw  CFG2TMC_OSCFI_S           i=0x0  //
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_SYNC_SHIFT                        _MK_SHIFT_CONST(18)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_SYNC_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_SYNC_SHIFT)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_SYNC_RANGE                        18:18
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_SYNC_WOFFSET                      0x0
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_SYNC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_SYNC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_SYNC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_SYNC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_SYNC_DISABLE                      _MK_ENUM_CONST(0)
#define APB_MISC_GP_ASDBGREG2_0_CFG2TMC_SW_BP_SYNC_ENABLE                       _MK_ENUM_CONST(1)


// Register APB_MISC_GP_EMU_REVID_0  
#define APB_MISC_GP_EMU_REVID_0                 _MK_ADDR_CONST(0x860)
#define APB_MISC_GP_EMU_REVID_0_WORD_COUNT                      0x1
#define APB_MISC_GP_EMU_REVID_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EMU_REVID_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define APB_MISC_GP_EMU_REVID_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EMU_REVID_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EMU_REVID_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define APB_MISC_GP_EMU_REVID_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
// USED by emulators to indicate netlist #, 0 for silicon.
#define APB_MISC_GP_EMU_REVID_0_NETLIST_SHIFT                   _MK_SHIFT_CONST(0)
#define APB_MISC_GP_EMU_REVID_0_NETLIST_FIELD                   (_MK_MASK_CONST(0xffff) << APB_MISC_GP_EMU_REVID_0_NETLIST_SHIFT)
#define APB_MISC_GP_EMU_REVID_0_NETLIST_RANGE                   15:0
#define APB_MISC_GP_EMU_REVID_0_NETLIST_WOFFSET                 0x0
#define APB_MISC_GP_EMU_REVID_0_NETLIST_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EMU_REVID_0_NETLIST_DEFAULT_MASK                    _MK_MASK_CONST(0xffff)
#define APB_MISC_GP_EMU_REVID_0_NETLIST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EMU_REVID_0_NETLIST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EMU_REVID_0_NETLIST_INIT_ENUM                       NV_EMUL_NETLIST

// USED by emulators to indicate patch #, 0 for silicon.
#define APB_MISC_GP_EMU_REVID_0_PATCH_SHIFT                     _MK_SHIFT_CONST(16)
#define APB_MISC_GP_EMU_REVID_0_PATCH_FIELD                     (_MK_MASK_CONST(0xffff) << APB_MISC_GP_EMU_REVID_0_PATCH_SHIFT)
#define APB_MISC_GP_EMU_REVID_0_PATCH_RANGE                     31:16
#define APB_MISC_GP_EMU_REVID_0_PATCH_WOFFSET                   0x0
#define APB_MISC_GP_EMU_REVID_0_PATCH_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EMU_REVID_0_PATCH_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define APB_MISC_GP_EMU_REVID_0_PATCH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EMU_REVID_0_PATCH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_EMU_REVID_0_PATCH_INIT_ENUM                 NV_EMUL_PATCH


// Register APB_MISC_GP_TRANSACTOR_SCRATCH_0  
#define APB_MISC_GP_TRANSACTOR_SCRATCH_0                        _MK_ADDR_CONST(0x864)
#define APB_MISC_GP_TRANSACTOR_SCRATCH_0_WORD_COUNT                     0x1
#define APB_MISC_GP_TRANSACTOR_SCRATCH_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_TRANSACTOR_SCRATCH_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define APB_MISC_GP_TRANSACTOR_SCRATCH_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APB_MISC_GP_TRANSACTOR_SCRATCH_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_TRANSACTOR_SCRATCH_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define APB_MISC_GP_TRANSACTOR_SCRATCH_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
// used for emulation to determine test results.
#define APB_MISC_GP_TRANSACTOR_SCRATCH_0_TRANSACTOR_SCRATCH_SHIFT                       _MK_SHIFT_CONST(0)
#define APB_MISC_GP_TRANSACTOR_SCRATCH_0_TRANSACTOR_SCRATCH_FIELD                       (_MK_MASK_CONST(0xffffffff) << APB_MISC_GP_TRANSACTOR_SCRATCH_0_TRANSACTOR_SCRATCH_SHIFT)
#define APB_MISC_GP_TRANSACTOR_SCRATCH_0_TRANSACTOR_SCRATCH_RANGE                       31:0
#define APB_MISC_GP_TRANSACTOR_SCRATCH_0_TRANSACTOR_SCRATCH_WOFFSET                     0x0
#define APB_MISC_GP_TRANSACTOR_SCRATCH_0_TRANSACTOR_SCRATCH_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_TRANSACTOR_SCRATCH_0_TRANSACTOR_SCRATCH_DEFAULT_MASK                        _MK_MASK_CONST(0xffffffff)
#define APB_MISC_GP_TRANSACTOR_SCRATCH_0_TRANSACTOR_SCRATCH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_TRANSACTOR_SCRATCH_0_TRANSACTOR_SCRATCH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_AOCFG1PADCTRL_0  //        0       rw  CFG2TMC_AOCFG1_PULLD_EN i=0x0   // AOCFG1 pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_AOCFG1_PULLU_EN i=0x0   // AOCFG1 pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_AOCFG1PADCTRL_0                     _MK_ADDR_CONST(0x868)
#define APB_MISC_GP_AOCFG1PADCTRL_0_WORD_COUNT                  0x1
#define APB_MISC_GP_AOCFG1PADCTRL_0_RESET_VAL                   _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_AOCFG1PADCTRL_0_RESET_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_AOCFG1PADCTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG1PADCTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG1PADCTRL_0_READ_MASK                   _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_AOCFG1PADCTRL_0_WRITE_MASK                  _MK_MASK_CONST(0xf1f1f03c)
// AOCFG1 data pins high speed mode enable
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_HSM_EN_SHIFT                 _MK_SHIFT_CONST(2)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_HSM_EN_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_HSM_EN_SHIFT)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_HSM_EN_RANGE                 2:2
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_HSM_EN_WOFFSET                       0x0
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_HSM_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_HSM_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_HSM_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_HSM_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_HSM_EN_DISABLE                       _MK_ENUM_CONST(0)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_HSM_EN_ENABLE                        _MK_ENUM_CONST(1)

// AOCFG1 data pins schmidt enable
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_SCHMT_EN_SHIFT                       _MK_SHIFT_CONST(3)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_SCHMT_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_SCHMT_EN_SHIFT)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_SCHMT_EN_RANGE                       3:3
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_SCHMT_EN_WOFFSET                     0x0
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_SCHMT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_SCHMT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_SCHMT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_SCHMT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_SCHMT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_SCHMT_EN_ENABLE                      _MK_ENUM_CONST(1)

// AOCFG1 data pins low power mode select
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_LPMD_SHIFT                   _MK_SHIFT_CONST(4)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_LPMD_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_LPMD_SHIFT)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_LPMD_RANGE                   5:4
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_LPMD_WOFFSET                 0x0
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_LPMD_DEFAULT                 _MK_MASK_CONST(0x3)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_LPMD_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_LPMD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_LPMD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_RANGE                      16:12
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_WOFFSET                    0x0
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_DEFAULT                    _MK_MASK_CONST(0x12)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_SHIFT                      _MK_SHIFT_CONST(20)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_RANGE                      24:20
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_WOFFSET                    0x0
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_DEFAULT                    _MK_MASK_CONST(0x16)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_SLWR_SHIFT                 _MK_SHIFT_CONST(28)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_SLWR_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_SLWR_RANGE                 29:28
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_SLWR_WOFFSET                       0x0
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_SLWR_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_SLWR_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_SLWR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_SLWF_SHIFT                 _MK_SHIFT_CONST(30)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_SLWF_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_SLWF_RANGE                 31:30
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_SLWF_WOFFSET                       0x0
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_SLWF_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_SLWF_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_SLWF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG1PADCTRL_0_CFG2TMC_AOCFG1_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_AOCFG2PADCTRL_0  //        0       rw  CFG2TMC_AOCFG2_PULLD_EN i=0x0   // AOCFG2 pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_AOCFG2_PULLU_EN i=0x0   // AOCFG2 pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_AOCFG2PADCTRL_0                     _MK_ADDR_CONST(0x86c)
#define APB_MISC_GP_AOCFG2PADCTRL_0_WORD_COUNT                  0x1
#define APB_MISC_GP_AOCFG2PADCTRL_0_RESET_VAL                   _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_AOCFG2PADCTRL_0_RESET_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_AOCFG2PADCTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG2PADCTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG2PADCTRL_0_READ_MASK                   _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_AOCFG2PADCTRL_0_WRITE_MASK                  _MK_MASK_CONST(0xf1f1f03c)
// AOCFG2 data pins high speed mode enable
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_HSM_EN_SHIFT                 _MK_SHIFT_CONST(2)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_HSM_EN_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_HSM_EN_SHIFT)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_HSM_EN_RANGE                 2:2
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_HSM_EN_WOFFSET                       0x0
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_HSM_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_HSM_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_HSM_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_HSM_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_HSM_EN_DISABLE                       _MK_ENUM_CONST(0)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_HSM_EN_ENABLE                        _MK_ENUM_CONST(1)

// AOCFG2 data pins schmidt enable
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_SCHMT_EN_SHIFT                       _MK_SHIFT_CONST(3)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_SCHMT_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_SCHMT_EN_SHIFT)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_SCHMT_EN_RANGE                       3:3
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_SCHMT_EN_WOFFSET                     0x0
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_SCHMT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_SCHMT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_SCHMT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_SCHMT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_SCHMT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_SCHMT_EN_ENABLE                      _MK_ENUM_CONST(1)

// AOCFG2 data pins low power mode select
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_LPMD_SHIFT                   _MK_SHIFT_CONST(4)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_LPMD_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_LPMD_SHIFT)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_LPMD_RANGE                   5:4
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_LPMD_WOFFSET                 0x0
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_LPMD_DEFAULT                 _MK_MASK_CONST(0x3)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_LPMD_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_LPMD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_LPMD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_RANGE                      16:12
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_WOFFSET                    0x0
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_DEFAULT                    _MK_MASK_CONST(0x12)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_SHIFT                      _MK_SHIFT_CONST(20)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_RANGE                      24:20
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_WOFFSET                    0x0
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_DEFAULT                    _MK_MASK_CONST(0x16)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_SLWR_SHIFT                 _MK_SHIFT_CONST(28)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_SLWR_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_SLWR_RANGE                 29:28
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_SLWR_WOFFSET                       0x0
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_SLWR_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_SLWR_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_SLWR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_SLWF_SHIFT                 _MK_SHIFT_CONST(30)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_SLWF_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_SLWF_RANGE                 31:30
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_SLWF_WOFFSET                       0x0
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_SLWF_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_SLWF_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_SLWF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_AOCFG2PADCTRL_0_CFG2TMC_AOCFG2_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_ATCFG1PADCTRL_0  //        0       rw  CFG2TMC_ATCFG1_PULLD_EN   i=0x0   // ATCFG1 pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_ATCFG1_PULLU_EN   i=0x0   // ATCFG1 pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_ATCFG1PADCTRL_0                     _MK_ADDR_CONST(0x870)
#define APB_MISC_GP_ATCFG1PADCTRL_0_WORD_COUNT                  0x1
#define APB_MISC_GP_ATCFG1PADCTRL_0_RESET_VAL                   _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_ATCFG1PADCTRL_0_RESET_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_ATCFG1PADCTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG1PADCTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG1PADCTRL_0_READ_MASK                   _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_ATCFG1PADCTRL_0_WRITE_MASK                  _MK_MASK_CONST(0xf1f1f03c)
// ATCFG1 data pins high speed mode enable
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_HSM_EN_SHIFT                 _MK_SHIFT_CONST(2)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_HSM_EN_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_HSM_EN_SHIFT)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_HSM_EN_RANGE                 2:2
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_HSM_EN_WOFFSET                       0x0
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_HSM_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_HSM_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_HSM_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_HSM_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_HSM_EN_DISABLE                       _MK_ENUM_CONST(0)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_HSM_EN_ENABLE                        _MK_ENUM_CONST(1)

// ATCFG1 data pins schmidt enable
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_SCHMT_EN_SHIFT                       _MK_SHIFT_CONST(3)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_SCHMT_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_SCHMT_EN_SHIFT)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_SCHMT_EN_RANGE                       3:3
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_SCHMT_EN_WOFFSET                     0x0
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_SCHMT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_SCHMT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_SCHMT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_SCHMT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_SCHMT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_SCHMT_EN_ENABLE                      _MK_ENUM_CONST(1)

// ATCFG1 data pins low power mode select
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_LPMD_SHIFT                   _MK_SHIFT_CONST(4)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_LPMD_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_LPMD_SHIFT)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_LPMD_RANGE                   5:4
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_LPMD_WOFFSET                 0x0
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_LPMD_DEFAULT                 _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_LPMD_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_LPMD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_LPMD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_RANGE                      16:12
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_WOFFSET                    0x0
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_DEFAULT                    _MK_MASK_CONST(0x12)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_SHIFT                      _MK_SHIFT_CONST(20)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_RANGE                      24:20
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_WOFFSET                    0x0
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_DEFAULT                    _MK_MASK_CONST(0x16)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_SLWR_SHIFT                 _MK_SHIFT_CONST(28)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_SLWR_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_SLWR_RANGE                 29:28
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_SLWR_WOFFSET                       0x0
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_SLWR_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_SLWR_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_SLWR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_SLWF_SHIFT                 _MK_SHIFT_CONST(30)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_SLWF_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_SLWF_RANGE                 31:30
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_SLWF_WOFFSET                       0x0
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_SLWF_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_SLWF_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_SLWF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG1PADCTRL_0_CFG2TMC_ATCFG1_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_ATCFG2PADCTRL_0  //        0       rw  CFG2TMC_ATCFG2_PULLD_EN   i=0x0   // ATCFG2 pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_ATCFG2_PULLU_EN   i=0x0   // ATCFG2 pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_ATCFG2PADCTRL_0                     _MK_ADDR_CONST(0x874)
#define APB_MISC_GP_ATCFG2PADCTRL_0_WORD_COUNT                  0x1
#define APB_MISC_GP_ATCFG2PADCTRL_0_RESET_VAL                   _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_ATCFG2PADCTRL_0_RESET_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_ATCFG2PADCTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG2PADCTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG2PADCTRL_0_READ_MASK                   _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_ATCFG2PADCTRL_0_WRITE_MASK                  _MK_MASK_CONST(0xf1f1f03c)
// ATCFG2 data pins high speed mode enable
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_HSM_EN_SHIFT                 _MK_SHIFT_CONST(2)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_HSM_EN_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_HSM_EN_SHIFT)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_HSM_EN_RANGE                 2:2
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_HSM_EN_WOFFSET                       0x0
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_HSM_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_HSM_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_HSM_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_HSM_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_HSM_EN_DISABLE                       _MK_ENUM_CONST(0)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_HSM_EN_ENABLE                        _MK_ENUM_CONST(1)

// ATCFG2 data pins schmidt enable
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_SCHMT_EN_SHIFT                       _MK_SHIFT_CONST(3)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_SCHMT_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_SCHMT_EN_SHIFT)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_SCHMT_EN_RANGE                       3:3
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_SCHMT_EN_WOFFSET                     0x0
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_SCHMT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_SCHMT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_SCHMT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_SCHMT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_SCHMT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_SCHMT_EN_ENABLE                      _MK_ENUM_CONST(1)

// ATCFG2 data pins low power mode select
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_LPMD_SHIFT                   _MK_SHIFT_CONST(4)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_LPMD_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_LPMD_SHIFT)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_LPMD_RANGE                   5:4
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_LPMD_WOFFSET                 0x0
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_LPMD_DEFAULT                 _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_LPMD_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_LPMD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_LPMD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_RANGE                      16:12
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_WOFFSET                    0x0
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_DEFAULT                    _MK_MASK_CONST(0x12)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_SHIFT                      _MK_SHIFT_CONST(20)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_RANGE                      24:20
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_WOFFSET                    0x0
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_DEFAULT                    _MK_MASK_CONST(0x16)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_SLWR_SHIFT                 _MK_SHIFT_CONST(28)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_SLWR_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_SLWR_RANGE                 29:28
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_SLWR_WOFFSET                       0x0
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_SLWR_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_SLWR_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_SLWR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_SLWF_SHIFT                 _MK_SHIFT_CONST(30)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_SLWF_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_SLWF_RANGE                 31:30
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_SLWF_WOFFSET                       0x0
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_SLWF_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_SLWF_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_SLWF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_ATCFG2PADCTRL_0_CFG2TMC_ATCFG2_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_CDEV1CFGPADCTRL_0  //        0       rw  CFG2TMC_CDEV1CFG_PULLD_EN   i=0x0   // CDEV1CFG pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_CDEV1CFG_PULLU_EN   i=0x0   // CDEV1CFG pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_CDEV1CFGPADCTRL_0                   _MK_ADDR_CONST(0x878)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_WORD_COUNT                        0x1
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_RESET_VAL                         _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_RESET_MASK                        _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_READ_MASK                         _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_WRITE_MASK                        _MK_MASK_CONST(0xf1f1f03c)
// CDEV1CFG data pins high speed mode enable
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_HSM_EN_SHIFT                     _MK_SHIFT_CONST(2)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_HSM_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_HSM_EN_SHIFT)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_HSM_EN_RANGE                     2:2
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_HSM_EN_WOFFSET                   0x0
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_HSM_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_HSM_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_HSM_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_HSM_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_HSM_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_HSM_EN_ENABLE                    _MK_ENUM_CONST(1)

// CDEV1CFG data pins schmidt enable
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_SCHMT_EN_SHIFT                   _MK_SHIFT_CONST(3)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_SCHMT_EN_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_SCHMT_EN_SHIFT)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_SCHMT_EN_RANGE                   3:3
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_SCHMT_EN_WOFFSET                 0x0
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_SCHMT_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_SCHMT_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_SCHMT_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_SCHMT_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_SCHMT_EN_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_SCHMT_EN_ENABLE                  _MK_ENUM_CONST(1)

// CDEV1CFG data pins low power mode select
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_LPMD_SHIFT                       _MK_SHIFT_CONST(4)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_LPMD_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_LPMD_SHIFT)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_LPMD_RANGE                       5:4
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_LPMD_WOFFSET                     0x0
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_LPMD_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_LPMD_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_LPMD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_LPMD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_SHIFT                  _MK_SHIFT_CONST(12)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_FIELD                  (_MK_MASK_CONST(0x1f) << APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_RANGE                  16:12
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_WOFFSET                        0x0
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_DEFAULT                        _MK_MASK_CONST(0x12)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_SHIFT                  _MK_SHIFT_CONST(20)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_FIELD                  (_MK_MASK_CONST(0x1f) << APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_RANGE                  24:20
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_WOFFSET                        0x0
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_DEFAULT                        _MK_MASK_CONST(0x16)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_SLWR_SHIFT                     _MK_SHIFT_CONST(28)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_SLWR_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_SLWR_RANGE                     29:28
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_SLWR_WOFFSET                   0x0
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_SLWR_DEFAULT                   _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_SLWR_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_SLWR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_SLWF_SHIFT                     _MK_SHIFT_CONST(30)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_SLWF_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_SLWF_RANGE                     31:30
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_SLWF_WOFFSET                   0x0
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_SLWF_DEFAULT                   _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_SLWF_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_SLWF_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_CFG2TMC_CDEV1CFG_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_CDEV2CFGPADCTRL_0  //        0       rw  CFG2TMC_CDEV2CFG_PULLD_EN   i=0x0   // CDEV2CFG pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_CDEV2CFG_PULLU_EN   i=0x0   // CDEV2CFG pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_CDEV2CFGPADCTRL_0                   _MK_ADDR_CONST(0x87c)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_WORD_COUNT                        0x1
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_RESET_VAL                         _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_RESET_MASK                        _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_READ_MASK                         _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_WRITE_MASK                        _MK_MASK_CONST(0xf1f1f03c)
// CDEV2CFG data pins high speed mode enable
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_HSM_EN_SHIFT                     _MK_SHIFT_CONST(2)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_HSM_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_HSM_EN_SHIFT)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_HSM_EN_RANGE                     2:2
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_HSM_EN_WOFFSET                   0x0
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_HSM_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_HSM_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_HSM_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_HSM_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_HSM_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_HSM_EN_ENABLE                    _MK_ENUM_CONST(1)

// CDEV2CFG data pins schmidt enable
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_SCHMT_EN_SHIFT                   _MK_SHIFT_CONST(3)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_SCHMT_EN_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_SCHMT_EN_SHIFT)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_SCHMT_EN_RANGE                   3:3
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_SCHMT_EN_WOFFSET                 0x0
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_SCHMT_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_SCHMT_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_SCHMT_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_SCHMT_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_SCHMT_EN_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_SCHMT_EN_ENABLE                  _MK_ENUM_CONST(1)

// CDEV2CFG data pins low power mode select
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_LPMD_SHIFT                       _MK_SHIFT_CONST(4)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_LPMD_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_LPMD_SHIFT)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_LPMD_RANGE                       5:4
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_LPMD_WOFFSET                     0x0
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_LPMD_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_LPMD_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_LPMD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_LPMD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_SHIFT                  _MK_SHIFT_CONST(12)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_FIELD                  (_MK_MASK_CONST(0x1f) << APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_RANGE                  16:12
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_WOFFSET                        0x0
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_DEFAULT                        _MK_MASK_CONST(0x12)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_SHIFT                  _MK_SHIFT_CONST(20)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_FIELD                  (_MK_MASK_CONST(0x1f) << APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_RANGE                  24:20
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_WOFFSET                        0x0
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_DEFAULT                        _MK_MASK_CONST(0x16)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_SLWR_SHIFT                     _MK_SHIFT_CONST(28)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_SLWR_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_SLWR_RANGE                     29:28
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_SLWR_WOFFSET                   0x0
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_SLWR_DEFAULT                   _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_SLWR_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_SLWR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_SLWF_SHIFT                     _MK_SHIFT_CONST(30)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_SLWF_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_SLWF_RANGE                     31:30
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_SLWF_WOFFSET                   0x0
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_SLWF_DEFAULT                   _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_SLWF_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_SLWF_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_CFG2TMC_CDEV2CFG_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_CSUSCFGPADCTRL_0  //        0       rw  CFG2TMC_CSUSCFG_PULLD_EN   i=0x0   // CSUSCFG pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_CSUSCFG_PULLU_EN   i=0x0   // CSUSCFG pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_CSUSCFGPADCTRL_0                    _MK_ADDR_CONST(0x880)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_WORD_COUNT                         0x1
#define APB_MISC_GP_CSUSCFGPADCTRL_0_RESET_VAL                  _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_RESET_MASK                         _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_READ_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_WRITE_MASK                         _MK_MASK_CONST(0xf1f1f03c)
// CSUSCFG data pins high speed mode enable
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_HSM_EN_SHIFT                       _MK_SHIFT_CONST(2)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_HSM_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_HSM_EN_SHIFT)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_HSM_EN_RANGE                       2:2
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_HSM_EN_WOFFSET                     0x0
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_HSM_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_HSM_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_HSM_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_HSM_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_HSM_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_HSM_EN_ENABLE                      _MK_ENUM_CONST(1)

// CSUSCFG data pins schmidt enable
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_SCHMT_EN_SHIFT                     _MK_SHIFT_CONST(3)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_SCHMT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_SCHMT_EN_SHIFT)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_SCHMT_EN_RANGE                     3:3
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_SCHMT_EN_WOFFSET                   0x0
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_SCHMT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_SCHMT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_SCHMT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_SCHMT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_SCHMT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_SCHMT_EN_ENABLE                    _MK_ENUM_CONST(1)

// CSUSCFG data pins low power mode select
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_LPMD_SHIFT                 _MK_SHIFT_CONST(4)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_LPMD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_LPMD_SHIFT)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_LPMD_RANGE                 5:4
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_LPMD_WOFFSET                       0x0
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_LPMD_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_LPMD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_LPMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_LPMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_SHIFT                    _MK_SHIFT_CONST(12)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_RANGE                    16:12
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_WOFFSET                  0x0
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_DEFAULT                  _MK_MASK_CONST(0x12)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_SHIFT                    _MK_SHIFT_CONST(20)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_RANGE                    24:20
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_WOFFSET                  0x0
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_DEFAULT                  _MK_MASK_CONST(0x16)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_SLWR_SHIFT                       _MK_SHIFT_CONST(28)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_SLWR_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_SLWR_RANGE                       29:28
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_SLWR_WOFFSET                     0x0
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_SLWR_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_SLWR_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_SLWR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_SLWF_SHIFT                       _MK_SHIFT_CONST(30)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_SLWF_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_SLWF_RANGE                       31:30
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_SLWF_WOFFSET                     0x0
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_SLWF_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_SLWF_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_SLWF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_CSUSCFGPADCTRL_0_CFG2TMC_CSUSCFG_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_DAP1CFGPADCTRL_0  //        0       rw  CFG2TMC_DAP1CFG_PULLD_EN   i=0x0   // DAP1CFG pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_DAP1CFG_PULLU_EN   i=0x0   // DAP1CFG pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_DAP1CFGPADCTRL_0                    _MK_ADDR_CONST(0x884)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_WORD_COUNT                         0x1
#define APB_MISC_GP_DAP1CFGPADCTRL_0_RESET_VAL                  _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_RESET_MASK                         _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_READ_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_WRITE_MASK                         _MK_MASK_CONST(0xf1f1f03c)
// DAP1CFG data pins high speed mode enable
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_HSM_EN_SHIFT                       _MK_SHIFT_CONST(2)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_HSM_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_HSM_EN_SHIFT)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_HSM_EN_RANGE                       2:2
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_HSM_EN_WOFFSET                     0x0
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_HSM_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_HSM_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_HSM_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_HSM_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_HSM_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_HSM_EN_ENABLE                      _MK_ENUM_CONST(1)

// DAP1CFG data pins schmidt enable
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_SCHMT_EN_SHIFT                     _MK_SHIFT_CONST(3)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_SCHMT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_SCHMT_EN_SHIFT)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_SCHMT_EN_RANGE                     3:3
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_SCHMT_EN_WOFFSET                   0x0
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_SCHMT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_SCHMT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_SCHMT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_SCHMT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_SCHMT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_SCHMT_EN_ENABLE                    _MK_ENUM_CONST(1)

// DAP1CFG data pins low power mode select
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_LPMD_SHIFT                 _MK_SHIFT_CONST(4)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_LPMD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_LPMD_SHIFT)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_LPMD_RANGE                 5:4
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_LPMD_WOFFSET                       0x0
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_LPMD_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_LPMD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_LPMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_LPMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_SHIFT                    _MK_SHIFT_CONST(12)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_RANGE                    16:12
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_WOFFSET                  0x0
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_DEFAULT                  _MK_MASK_CONST(0x12)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_SHIFT                    _MK_SHIFT_CONST(20)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_RANGE                    24:20
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_WOFFSET                  0x0
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_DEFAULT                  _MK_MASK_CONST(0x16)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_SLWR_SHIFT                       _MK_SHIFT_CONST(28)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_SLWR_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_SLWR_RANGE                       29:28
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_SLWR_WOFFSET                     0x0
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_SLWR_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_SLWR_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_SLWR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_SLWF_SHIFT                       _MK_SHIFT_CONST(30)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_SLWF_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_SLWF_RANGE                       31:30
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_SLWF_WOFFSET                     0x0
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_SLWF_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_SLWF_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_SLWF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP1CFGPADCTRL_0_CFG2TMC_DAP1CFG_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_DAP2CFGPADCTRL_0  //        0       rw  CFG2TMC_DAP2CFG_PULLD_EN   i=0x0   // DAP2CFG pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_DAP2CFG_PULLU_EN   i=0x0   // DAP2CFG pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_DAP2CFGPADCTRL_0                    _MK_ADDR_CONST(0x888)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_WORD_COUNT                         0x1
#define APB_MISC_GP_DAP2CFGPADCTRL_0_RESET_VAL                  _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_RESET_MASK                         _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_READ_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_WRITE_MASK                         _MK_MASK_CONST(0xf1f1f03c)
// DAP2CFG data pins high speed mode enable
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_HSM_EN_SHIFT                       _MK_SHIFT_CONST(2)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_HSM_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_HSM_EN_SHIFT)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_HSM_EN_RANGE                       2:2
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_HSM_EN_WOFFSET                     0x0
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_HSM_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_HSM_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_HSM_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_HSM_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_HSM_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_HSM_EN_ENABLE                      _MK_ENUM_CONST(1)

// DAP2CFG data pins schmidt enable
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_SCHMT_EN_SHIFT                     _MK_SHIFT_CONST(3)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_SCHMT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_SCHMT_EN_SHIFT)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_SCHMT_EN_RANGE                     3:3
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_SCHMT_EN_WOFFSET                   0x0
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_SCHMT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_SCHMT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_SCHMT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_SCHMT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_SCHMT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_SCHMT_EN_ENABLE                    _MK_ENUM_CONST(1)

// DAP2CFG data pins low power mode select
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_LPMD_SHIFT                 _MK_SHIFT_CONST(4)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_LPMD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_LPMD_SHIFT)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_LPMD_RANGE                 5:4
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_LPMD_WOFFSET                       0x0
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_LPMD_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_LPMD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_LPMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_LPMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_SHIFT                    _MK_SHIFT_CONST(12)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_RANGE                    16:12
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_WOFFSET                  0x0
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_DEFAULT                  _MK_MASK_CONST(0x12)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_SHIFT                    _MK_SHIFT_CONST(20)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_RANGE                    24:20
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_WOFFSET                  0x0
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_DEFAULT                  _MK_MASK_CONST(0x16)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_SLWR_SHIFT                       _MK_SHIFT_CONST(28)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_SLWR_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_SLWR_RANGE                       29:28
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_SLWR_WOFFSET                     0x0
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_SLWR_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_SLWR_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_SLWR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_SLWF_SHIFT                       _MK_SHIFT_CONST(30)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_SLWF_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_SLWF_RANGE                       31:30
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_SLWF_WOFFSET                     0x0
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_SLWF_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_SLWF_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_SLWF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP2CFGPADCTRL_0_CFG2TMC_DAP2CFG_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_DAP3CFGPADCTRL_0  //        0       rw  CFG2TMC_DAP3CFG_PULLD_EN   i=0x0   // DAP3CFG pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_DAP3CFG_PULLU_EN   i=0x0   // DAP3CFG pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_DAP3CFGPADCTRL_0                    _MK_ADDR_CONST(0x88c)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_WORD_COUNT                         0x1
#define APB_MISC_GP_DAP3CFGPADCTRL_0_RESET_VAL                  _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_RESET_MASK                         _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_READ_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_WRITE_MASK                         _MK_MASK_CONST(0xf1f1f03c)
// DAP3CFG data pins high speed mode enable
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_HSM_EN_SHIFT                       _MK_SHIFT_CONST(2)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_HSM_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_HSM_EN_SHIFT)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_HSM_EN_RANGE                       2:2
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_HSM_EN_WOFFSET                     0x0
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_HSM_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_HSM_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_HSM_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_HSM_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_HSM_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_HSM_EN_ENABLE                      _MK_ENUM_CONST(1)

// DAP3CFG data pins schmidt enable
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_SCHMT_EN_SHIFT                     _MK_SHIFT_CONST(3)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_SCHMT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_SCHMT_EN_SHIFT)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_SCHMT_EN_RANGE                     3:3
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_SCHMT_EN_WOFFSET                   0x0
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_SCHMT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_SCHMT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_SCHMT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_SCHMT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_SCHMT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_SCHMT_EN_ENABLE                    _MK_ENUM_CONST(1)

// DAP3CFG data pins low power mode select
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_LPMD_SHIFT                 _MK_SHIFT_CONST(4)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_LPMD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_LPMD_SHIFT)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_LPMD_RANGE                 5:4
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_LPMD_WOFFSET                       0x0
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_LPMD_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_LPMD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_LPMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_LPMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_SHIFT                    _MK_SHIFT_CONST(12)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_RANGE                    16:12
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_WOFFSET                  0x0
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_DEFAULT                  _MK_MASK_CONST(0x12)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_SHIFT                    _MK_SHIFT_CONST(20)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_RANGE                    24:20
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_WOFFSET                  0x0
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_DEFAULT                  _MK_MASK_CONST(0x16)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_SLWR_SHIFT                       _MK_SHIFT_CONST(28)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_SLWR_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_SLWR_RANGE                       29:28
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_SLWR_WOFFSET                     0x0
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_SLWR_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_SLWR_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_SLWR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_SLWF_SHIFT                       _MK_SHIFT_CONST(30)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_SLWF_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_SLWF_RANGE                       31:30
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_SLWF_WOFFSET                     0x0
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_SLWF_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_SLWF_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_SLWF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP3CFGPADCTRL_0_CFG2TMC_DAP3CFG_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_DAP4CFGPADCTRL_0  //        0       rw  CFG2TMC_DAP4CFG_PULLD_EN   i=0x0   // DAP4CFG pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_DAP4CFG_PULLU_EN   i=0x0   // DAP4CFG pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_DAP4CFGPADCTRL_0                    _MK_ADDR_CONST(0x890)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_WORD_COUNT                         0x1
#define APB_MISC_GP_DAP4CFGPADCTRL_0_RESET_VAL                  _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_RESET_MASK                         _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_READ_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_WRITE_MASK                         _MK_MASK_CONST(0xf1f1f03c)
// DAP4CFG data pins high speed mode enable
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_HSM_EN_SHIFT                       _MK_SHIFT_CONST(2)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_HSM_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_HSM_EN_SHIFT)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_HSM_EN_RANGE                       2:2
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_HSM_EN_WOFFSET                     0x0
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_HSM_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_HSM_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_HSM_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_HSM_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_HSM_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_HSM_EN_ENABLE                      _MK_ENUM_CONST(1)

// DAP4CFG data pins schmidt enable
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_SCHMT_EN_SHIFT                     _MK_SHIFT_CONST(3)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_SCHMT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_SCHMT_EN_SHIFT)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_SCHMT_EN_RANGE                     3:3
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_SCHMT_EN_WOFFSET                   0x0
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_SCHMT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_SCHMT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_SCHMT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_SCHMT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_SCHMT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_SCHMT_EN_ENABLE                    _MK_ENUM_CONST(1)

// DAP4CFG data pins low power mode select
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_LPMD_SHIFT                 _MK_SHIFT_CONST(4)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_LPMD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_LPMD_SHIFT)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_LPMD_RANGE                 5:4
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_LPMD_WOFFSET                       0x0
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_LPMD_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_LPMD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_LPMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_LPMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_SHIFT                    _MK_SHIFT_CONST(12)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_RANGE                    16:12
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_WOFFSET                  0x0
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_DEFAULT                  _MK_MASK_CONST(0x12)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_SHIFT                    _MK_SHIFT_CONST(20)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_RANGE                    24:20
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_WOFFSET                  0x0
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_DEFAULT                  _MK_MASK_CONST(0x16)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_SLWR_SHIFT                       _MK_SHIFT_CONST(28)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_SLWR_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_SLWR_RANGE                       29:28
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_SLWR_WOFFSET                     0x0
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_SLWR_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_SLWR_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_SLWR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_SLWF_SHIFT                       _MK_SHIFT_CONST(30)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_SLWF_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_SLWF_RANGE                       31:30
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_SLWF_WOFFSET                     0x0
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_SLWF_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_SLWF_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_SLWF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DAP4CFGPADCTRL_0_CFG2TMC_DAP4CFG_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_DBGCFGPADCTRL_0  //        0       rw  CFG2TMC_DBGCFG_PULLD_EN   i=0x0   // DBGCFG pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_DBGCFG_PULLU_EN   i=0x0   // DBGCFG pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_DBGCFGPADCTRL_0                     _MK_ADDR_CONST(0x894)
#define APB_MISC_GP_DBGCFGPADCTRL_0_WORD_COUNT                  0x1
#define APB_MISC_GP_DBGCFGPADCTRL_0_RESET_VAL                   _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_DBGCFGPADCTRL_0_RESET_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_DBGCFGPADCTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DBGCFGPADCTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DBGCFGPADCTRL_0_READ_MASK                   _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_DBGCFGPADCTRL_0_WRITE_MASK                  _MK_MASK_CONST(0xf1f1f03c)
// DBGCFG data pins high speed mode enable
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_HSM_EN_SHIFT                 _MK_SHIFT_CONST(2)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_HSM_EN_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_HSM_EN_SHIFT)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_HSM_EN_RANGE                 2:2
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_HSM_EN_WOFFSET                       0x0
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_HSM_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_HSM_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_HSM_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_HSM_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_HSM_EN_DISABLE                       _MK_ENUM_CONST(0)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_HSM_EN_ENABLE                        _MK_ENUM_CONST(1)

// DBGCFG data pins schmidt enable
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_SCHMT_EN_SHIFT                       _MK_SHIFT_CONST(3)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_SCHMT_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_SCHMT_EN_SHIFT)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_SCHMT_EN_RANGE                       3:3
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_SCHMT_EN_WOFFSET                     0x0
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_SCHMT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_SCHMT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_SCHMT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_SCHMT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_SCHMT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_SCHMT_EN_ENABLE                      _MK_ENUM_CONST(1)

// DBGCFG data pins low power mode select
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_LPMD_SHIFT                   _MK_SHIFT_CONST(4)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_LPMD_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_LPMD_SHIFT)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_LPMD_RANGE                   5:4
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_LPMD_WOFFSET                 0x0
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_LPMD_DEFAULT                 _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_LPMD_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_LPMD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_LPMD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_RANGE                      16:12
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_WOFFSET                    0x0
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_DEFAULT                    _MK_MASK_CONST(0x12)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_SHIFT                      _MK_SHIFT_CONST(20)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_RANGE                      24:20
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_WOFFSET                    0x0
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_DEFAULT                    _MK_MASK_CONST(0x16)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_SLWR_SHIFT                 _MK_SHIFT_CONST(28)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_SLWR_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_SLWR_RANGE                 29:28
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_SLWR_WOFFSET                       0x0
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_SLWR_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_SLWR_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_SLWR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_SLWF_SHIFT                 _MK_SHIFT_CONST(30)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_SLWF_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_SLWF_RANGE                 31:30
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_SLWF_WOFFSET                       0x0
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_SLWF_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_SLWF_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_SLWF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_DBGCFGPADCTRL_0_CFG2TMC_DBGCFG_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_LCDCFG1PADCTRL_0  //        0       rw  CFG2TMC_LCDCFG1_PULLD_EN   i=0x0   // LCDCFG1 pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_LCDCFG1_PULLU_EN   i=0x0   // LCDCFG1 pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_LCDCFG1PADCTRL_0                    _MK_ADDR_CONST(0x898)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_WORD_COUNT                         0x1
#define APB_MISC_GP_LCDCFG1PADCTRL_0_RESET_VAL                  _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_RESET_MASK                         _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_READ_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_WRITE_MASK                         _MK_MASK_CONST(0xf1f1f03c)
// LCDCFG1 data pins high speed mode enable
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_HSM_EN_SHIFT                       _MK_SHIFT_CONST(2)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_HSM_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_HSM_EN_SHIFT)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_HSM_EN_RANGE                       2:2
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_HSM_EN_WOFFSET                     0x0
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_HSM_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_HSM_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_HSM_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_HSM_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_HSM_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_HSM_EN_ENABLE                      _MK_ENUM_CONST(1)

// LCDCFG1 data pins schmidt enable
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_SCHMT_EN_SHIFT                     _MK_SHIFT_CONST(3)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_SCHMT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_SCHMT_EN_SHIFT)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_SCHMT_EN_RANGE                     3:3
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_SCHMT_EN_WOFFSET                   0x0
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_SCHMT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_SCHMT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_SCHMT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_SCHMT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_SCHMT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_SCHMT_EN_ENABLE                    _MK_ENUM_CONST(1)

// LCDCFG1 data pins low power mode select
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_LPMD_SHIFT                 _MK_SHIFT_CONST(4)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_LPMD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_LPMD_SHIFT)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_LPMD_RANGE                 5:4
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_LPMD_WOFFSET                       0x0
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_LPMD_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_LPMD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_LPMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_LPMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_SHIFT                    _MK_SHIFT_CONST(12)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_RANGE                    16:12
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_WOFFSET                  0x0
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_DEFAULT                  _MK_MASK_CONST(0x12)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_SHIFT                    _MK_SHIFT_CONST(20)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_RANGE                    24:20
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_WOFFSET                  0x0
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_DEFAULT                  _MK_MASK_CONST(0x16)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_SLWR_SHIFT                       _MK_SHIFT_CONST(28)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_SLWR_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_SLWR_RANGE                       29:28
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_SLWR_WOFFSET                     0x0
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_SLWR_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_SLWR_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_SLWR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_SLWF_SHIFT                       _MK_SHIFT_CONST(30)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_SLWF_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_SLWF_RANGE                       31:30
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_SLWF_WOFFSET                     0x0
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_SLWF_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_SLWF_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_SLWF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG1PADCTRL_0_CFG2TMC_LCDCFG1_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_LCDCFG2PADCTRL_0  //        0       rw  CFG2TMC_LCDCFG2_PULLD_EN   i=0x0   // LCDCFG2 pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_LCDCFG2_PULLU_EN   i=0x0   // LCDCFG2 pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_LCDCFG2PADCTRL_0                    _MK_ADDR_CONST(0x89c)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_WORD_COUNT                         0x1
#define APB_MISC_GP_LCDCFG2PADCTRL_0_RESET_VAL                  _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_RESET_MASK                         _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_READ_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_WRITE_MASK                         _MK_MASK_CONST(0xf1f1f03c)
// LCDCFG2 data pins high speed mode enable
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_HSM_EN_SHIFT                       _MK_SHIFT_CONST(2)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_HSM_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_HSM_EN_SHIFT)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_HSM_EN_RANGE                       2:2
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_HSM_EN_WOFFSET                     0x0
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_HSM_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_HSM_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_HSM_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_HSM_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_HSM_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_HSM_EN_ENABLE                      _MK_ENUM_CONST(1)

// LCDCFG2 data pins schmidt enable
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_SCHMT_EN_SHIFT                     _MK_SHIFT_CONST(3)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_SCHMT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_SCHMT_EN_SHIFT)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_SCHMT_EN_RANGE                     3:3
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_SCHMT_EN_WOFFSET                   0x0
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_SCHMT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_SCHMT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_SCHMT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_SCHMT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_SCHMT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_SCHMT_EN_ENABLE                    _MK_ENUM_CONST(1)

// LCDCFG2 data pins low power mode select
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_LPMD_SHIFT                 _MK_SHIFT_CONST(4)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_LPMD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_LPMD_SHIFT)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_LPMD_RANGE                 5:4
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_LPMD_WOFFSET                       0x0
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_LPMD_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_LPMD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_LPMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_LPMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_SHIFT                    _MK_SHIFT_CONST(12)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_RANGE                    16:12
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_WOFFSET                  0x0
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_DEFAULT                  _MK_MASK_CONST(0x12)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_SHIFT                    _MK_SHIFT_CONST(20)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_RANGE                    24:20
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_WOFFSET                  0x0
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_DEFAULT                  _MK_MASK_CONST(0x16)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_SLWR_SHIFT                       _MK_SHIFT_CONST(28)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_SLWR_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_SLWR_RANGE                       29:28
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_SLWR_WOFFSET                     0x0
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_SLWR_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_SLWR_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_SLWR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_SLWF_SHIFT                       _MK_SHIFT_CONST(30)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_SLWF_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_SLWF_RANGE                       31:30
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_SLWF_WOFFSET                     0x0
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_SLWF_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_SLWF_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_SLWF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_LCDCFG2PADCTRL_0_CFG2TMC_LCDCFG2_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_SDIO2CFGPADCTRL_0  //        0       rw  CFG2TMC_SDIO2CFG_PULLD_EN   i=0x0   // SDIO2CFG pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_SDIO2CFG_PULLU_EN   i=0x0   // SDIO2CFG pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_SDIO2CFGPADCTRL_0                   _MK_ADDR_CONST(0x8a0)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_WORD_COUNT                        0x1
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_RESET_VAL                         _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_RESET_MASK                        _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_READ_MASK                         _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_WRITE_MASK                        _MK_MASK_CONST(0xf1f1f03c)
// SDIO2CFG data pins high speed mode enable
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_HSM_EN_SHIFT                     _MK_SHIFT_CONST(2)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_HSM_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_HSM_EN_SHIFT)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_HSM_EN_RANGE                     2:2
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_HSM_EN_WOFFSET                   0x0
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_HSM_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_HSM_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_HSM_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_HSM_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_HSM_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_HSM_EN_ENABLE                    _MK_ENUM_CONST(1)

// SDIO2CFG data pins schmidt enable
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_SCHMT_EN_SHIFT                   _MK_SHIFT_CONST(3)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_SCHMT_EN_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_SCHMT_EN_SHIFT)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_SCHMT_EN_RANGE                   3:3
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_SCHMT_EN_WOFFSET                 0x0
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_SCHMT_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_SCHMT_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_SCHMT_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_SCHMT_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_SCHMT_EN_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_SCHMT_EN_ENABLE                  _MK_ENUM_CONST(1)

// SDIO2CFG data pins low power mode select
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_LPMD_SHIFT                       _MK_SHIFT_CONST(4)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_LPMD_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_LPMD_SHIFT)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_LPMD_RANGE                       5:4
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_LPMD_WOFFSET                     0x0
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_LPMD_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_LPMD_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_LPMD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_LPMD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_SHIFT                  _MK_SHIFT_CONST(12)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_FIELD                  (_MK_MASK_CONST(0x1f) << APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_RANGE                  16:12
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_WOFFSET                        0x0
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_DEFAULT                        _MK_MASK_CONST(0x12)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_SHIFT                  _MK_SHIFT_CONST(20)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_FIELD                  (_MK_MASK_CONST(0x1f) << APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_RANGE                  24:20
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_WOFFSET                        0x0
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_DEFAULT                        _MK_MASK_CONST(0x16)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_SLWR_SHIFT                     _MK_SHIFT_CONST(28)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_SLWR_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_SLWR_RANGE                     29:28
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_SLWR_WOFFSET                   0x0
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_SLWR_DEFAULT                   _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_SLWR_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_SLWR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_SLWF_SHIFT                     _MK_SHIFT_CONST(30)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_SLWF_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_SLWF_RANGE                     31:30
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_SLWF_WOFFSET                   0x0
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_SLWF_DEFAULT                   _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_SLWF_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_SLWF_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO2CFGPADCTRL_0_CFG2TMC_SDIO2CFG_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_SDIO3CFGPADCTRL_0  //        0       rw  CFG2TMC_SDIO3CFG_PULLD_EN   i=0x0   // SDIO3CFG pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_SDIO3CFG_PULLU_EN   i=0x0   // SDIO3CFG pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_SDIO3CFGPADCTRL_0                   _MK_ADDR_CONST(0x8a4)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_WORD_COUNT                        0x1
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_RESET_VAL                         _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_RESET_MASK                        _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_READ_MASK                         _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_WRITE_MASK                        _MK_MASK_CONST(0xf1f1f03c)
// SDIO3CFG data pins high speed mode enable
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_HSM_EN_SHIFT                     _MK_SHIFT_CONST(2)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_HSM_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_HSM_EN_SHIFT)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_HSM_EN_RANGE                     2:2
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_HSM_EN_WOFFSET                   0x0
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_HSM_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_HSM_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_HSM_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_HSM_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_HSM_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_HSM_EN_ENABLE                    _MK_ENUM_CONST(1)

// SDIO3CFG data pins schmidt enable
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_SCHMT_EN_SHIFT                   _MK_SHIFT_CONST(3)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_SCHMT_EN_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_SCHMT_EN_SHIFT)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_SCHMT_EN_RANGE                   3:3
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_SCHMT_EN_WOFFSET                 0x0
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_SCHMT_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_SCHMT_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_SCHMT_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_SCHMT_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_SCHMT_EN_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_SCHMT_EN_ENABLE                  _MK_ENUM_CONST(1)

// SDIO3CFG data pins low power mode select
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_LPMD_SHIFT                       _MK_SHIFT_CONST(4)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_LPMD_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_LPMD_SHIFT)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_LPMD_RANGE                       5:4
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_LPMD_WOFFSET                     0x0
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_LPMD_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_LPMD_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_LPMD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_LPMD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_SHIFT                  _MK_SHIFT_CONST(12)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_FIELD                  (_MK_MASK_CONST(0x1f) << APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_RANGE                  16:12
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_WOFFSET                        0x0
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_DEFAULT                        _MK_MASK_CONST(0x12)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_SHIFT                  _MK_SHIFT_CONST(20)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_FIELD                  (_MK_MASK_CONST(0x1f) << APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_RANGE                  24:20
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_WOFFSET                        0x0
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_DEFAULT                        _MK_MASK_CONST(0x16)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_SLWR_SHIFT                     _MK_SHIFT_CONST(28)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_SLWR_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_SLWR_RANGE                     29:28
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_SLWR_WOFFSET                   0x0
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_SLWR_DEFAULT                   _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_SLWR_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_SLWR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_SLWF_SHIFT                     _MK_SHIFT_CONST(30)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_SLWF_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_SLWF_RANGE                     31:30
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_SLWF_WOFFSET                   0x0
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_SLWF_DEFAULT                   _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_SLWF_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_SLWF_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_CFG2TMC_SDIO3CFG_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_SPICFGPADCTRL_0  //        0       rw  CFG2TMC_SPICFG_PULLD_EN   i=0x0   // SPICFG pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_SPICFG_PULLU_EN   i=0x0   // SPICFG pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_SPICFGPADCTRL_0                     _MK_ADDR_CONST(0x8a8)
#define APB_MISC_GP_SPICFGPADCTRL_0_WORD_COUNT                  0x1
#define APB_MISC_GP_SPICFGPADCTRL_0_RESET_VAL                   _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_SPICFGPADCTRL_0_RESET_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_SPICFGPADCTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SPICFGPADCTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SPICFGPADCTRL_0_READ_MASK                   _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_SPICFGPADCTRL_0_WRITE_MASK                  _MK_MASK_CONST(0xf1f1f03c)
// SPICFG data pins high speed mode enable
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_HSM_EN_SHIFT                 _MK_SHIFT_CONST(2)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_HSM_EN_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_HSM_EN_SHIFT)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_HSM_EN_RANGE                 2:2
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_HSM_EN_WOFFSET                       0x0
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_HSM_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_HSM_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_HSM_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_HSM_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_HSM_EN_DISABLE                       _MK_ENUM_CONST(0)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_HSM_EN_ENABLE                        _MK_ENUM_CONST(1)

// SPICFG data pins schmidt enable
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_SCHMT_EN_SHIFT                       _MK_SHIFT_CONST(3)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_SCHMT_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_SCHMT_EN_SHIFT)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_SCHMT_EN_RANGE                       3:3
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_SCHMT_EN_WOFFSET                     0x0
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_SCHMT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_SCHMT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_SCHMT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_SCHMT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_SCHMT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_SCHMT_EN_ENABLE                      _MK_ENUM_CONST(1)

// SPICFG data pins low power mode select
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_LPMD_SHIFT                   _MK_SHIFT_CONST(4)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_LPMD_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_LPMD_SHIFT)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_LPMD_RANGE                   5:4
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_LPMD_WOFFSET                 0x0
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_LPMD_DEFAULT                 _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_LPMD_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_LPMD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_LPMD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_RANGE                      16:12
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_WOFFSET                    0x0
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_DEFAULT                    _MK_MASK_CONST(0x12)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_SHIFT                      _MK_SHIFT_CONST(20)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_RANGE                      24:20
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_WOFFSET                    0x0
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_DEFAULT                    _MK_MASK_CONST(0x16)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_SLWR_SHIFT                 _MK_SHIFT_CONST(28)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_SLWR_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_SLWR_RANGE                 29:28
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_SLWR_WOFFSET                       0x0
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_SLWR_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_SLWR_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_SLWR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_SLWF_SHIFT                 _MK_SHIFT_CONST(30)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_SLWF_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_SLWF_RANGE                 31:30
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_SLWF_WOFFSET                       0x0
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_SLWF_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_SLWF_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_SLWF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_SPICFGPADCTRL_0_CFG2TMC_SPICFG_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_UAACFGPADCTRL_0  //        0       rw  CFG2TMC_UAACFG_PULLD_EN   i=0x0   // UAACFG pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_UAACFG_PULLU_EN   i=0x0   // UAACFG pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_UAACFGPADCTRL_0                     _MK_ADDR_CONST(0x8ac)
#define APB_MISC_GP_UAACFGPADCTRL_0_WORD_COUNT                  0x1
#define APB_MISC_GP_UAACFGPADCTRL_0_RESET_VAL                   _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_UAACFGPADCTRL_0_RESET_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_UAACFGPADCTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UAACFGPADCTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UAACFGPADCTRL_0_READ_MASK                   _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_UAACFGPADCTRL_0_WRITE_MASK                  _MK_MASK_CONST(0xf1f1f03c)
// UAACFG data pins high speed mode enable
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_HSM_EN_SHIFT                 _MK_SHIFT_CONST(2)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_HSM_EN_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_HSM_EN_SHIFT)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_HSM_EN_RANGE                 2:2
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_HSM_EN_WOFFSET                       0x0
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_HSM_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_HSM_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_HSM_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_HSM_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_HSM_EN_DISABLE                       _MK_ENUM_CONST(0)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_HSM_EN_ENABLE                        _MK_ENUM_CONST(1)

// UAACFG data pins schmidt enable
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_SCHMT_EN_SHIFT                       _MK_SHIFT_CONST(3)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_SCHMT_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_SCHMT_EN_SHIFT)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_SCHMT_EN_RANGE                       3:3
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_SCHMT_EN_WOFFSET                     0x0
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_SCHMT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_SCHMT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_SCHMT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_SCHMT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_SCHMT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_SCHMT_EN_ENABLE                      _MK_ENUM_CONST(1)

// UAACFG data pins low power mode select
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_LPMD_SHIFT                   _MK_SHIFT_CONST(4)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_LPMD_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_LPMD_SHIFT)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_LPMD_RANGE                   5:4
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_LPMD_WOFFSET                 0x0
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_LPMD_DEFAULT                 _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_LPMD_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_LPMD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_LPMD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_RANGE                      16:12
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_WOFFSET                    0x0
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_DEFAULT                    _MK_MASK_CONST(0x12)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_SHIFT                      _MK_SHIFT_CONST(20)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_RANGE                      24:20
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_WOFFSET                    0x0
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_DEFAULT                    _MK_MASK_CONST(0x16)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_SLWR_SHIFT                 _MK_SHIFT_CONST(28)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_SLWR_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_SLWR_RANGE                 29:28
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_SLWR_WOFFSET                       0x0
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_SLWR_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_SLWR_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_SLWR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_SLWF_SHIFT                 _MK_SHIFT_CONST(30)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_SLWF_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_SLWF_RANGE                 31:30
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_SLWF_WOFFSET                       0x0
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_SLWF_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_SLWF_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_SLWF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UAACFGPADCTRL_0_CFG2TMC_UAACFG_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_UABCFGPADCTRL_0  //        0       rw  CFG2TMC_UABCFG_PULLD_EN   i=0x0   // UABCFG pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_UABCFG_PULLU_EN   i=0x0   // UABCFG pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_UABCFGPADCTRL_0                     _MK_ADDR_CONST(0x8b0)
#define APB_MISC_GP_UABCFGPADCTRL_0_WORD_COUNT                  0x1
#define APB_MISC_GP_UABCFGPADCTRL_0_RESET_VAL                   _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_UABCFGPADCTRL_0_RESET_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_UABCFGPADCTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UABCFGPADCTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UABCFGPADCTRL_0_READ_MASK                   _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_UABCFGPADCTRL_0_WRITE_MASK                  _MK_MASK_CONST(0xf1f1f03c)
// UABCFG data pins high speed mode enable
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_HSM_EN_SHIFT                 _MK_SHIFT_CONST(2)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_HSM_EN_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_HSM_EN_SHIFT)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_HSM_EN_RANGE                 2:2
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_HSM_EN_WOFFSET                       0x0
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_HSM_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_HSM_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_HSM_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_HSM_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_HSM_EN_DISABLE                       _MK_ENUM_CONST(0)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_HSM_EN_ENABLE                        _MK_ENUM_CONST(1)

// UABCFG data pins schmidt enable
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_SCHMT_EN_SHIFT                       _MK_SHIFT_CONST(3)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_SCHMT_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_SCHMT_EN_SHIFT)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_SCHMT_EN_RANGE                       3:3
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_SCHMT_EN_WOFFSET                     0x0
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_SCHMT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_SCHMT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_SCHMT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_SCHMT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_SCHMT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_SCHMT_EN_ENABLE                      _MK_ENUM_CONST(1)

// UABCFG data pins low power mode select
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_LPMD_SHIFT                   _MK_SHIFT_CONST(4)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_LPMD_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_LPMD_SHIFT)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_LPMD_RANGE                   5:4
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_LPMD_WOFFSET                 0x0
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_LPMD_DEFAULT                 _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_LPMD_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_LPMD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_LPMD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_RANGE                      16:12
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_WOFFSET                    0x0
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_DEFAULT                    _MK_MASK_CONST(0x12)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_SHIFT                      _MK_SHIFT_CONST(20)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_RANGE                      24:20
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_WOFFSET                    0x0
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_DEFAULT                    _MK_MASK_CONST(0x16)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_SLWR_SHIFT                 _MK_SHIFT_CONST(28)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_SLWR_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_SLWR_RANGE                 29:28
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_SLWR_WOFFSET                       0x0
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_SLWR_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_SLWR_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_SLWR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_SLWF_SHIFT                 _MK_SHIFT_CONST(30)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_SLWF_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_SLWF_RANGE                 31:30
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_SLWF_WOFFSET                       0x0
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_SLWF_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_SLWF_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_SLWF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UABCFGPADCTRL_0_CFG2TMC_UABCFG_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_UART2CFGPADCTRL_0  //        0       rw  CFG2TMC_UART2CFG_PULLD_EN   i=0x0   // UART2CFG pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_UART2CFG_PULLU_EN   i=0x0   // UART2CFG pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_UART2CFGPADCTRL_0                   _MK_ADDR_CONST(0x8b4)
#define APB_MISC_GP_UART2CFGPADCTRL_0_WORD_COUNT                        0x1
#define APB_MISC_GP_UART2CFGPADCTRL_0_RESET_VAL                         _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_UART2CFGPADCTRL_0_RESET_MASK                        _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_UART2CFGPADCTRL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART2CFGPADCTRL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART2CFGPADCTRL_0_READ_MASK                         _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_UART2CFGPADCTRL_0_WRITE_MASK                        _MK_MASK_CONST(0xf1f1f03c)
// UART2CFG data pins high speed mode enable
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_HSM_EN_SHIFT                     _MK_SHIFT_CONST(2)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_HSM_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_HSM_EN_SHIFT)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_HSM_EN_RANGE                     2:2
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_HSM_EN_WOFFSET                   0x0
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_HSM_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_HSM_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_HSM_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_HSM_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_HSM_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_HSM_EN_ENABLE                    _MK_ENUM_CONST(1)

// UART2CFG data pins schmidt enable
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_SCHMT_EN_SHIFT                   _MK_SHIFT_CONST(3)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_SCHMT_EN_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_SCHMT_EN_SHIFT)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_SCHMT_EN_RANGE                   3:3
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_SCHMT_EN_WOFFSET                 0x0
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_SCHMT_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_SCHMT_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_SCHMT_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_SCHMT_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_SCHMT_EN_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_SCHMT_EN_ENABLE                  _MK_ENUM_CONST(1)

// UART2CFG data pins low power mode select
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_LPMD_SHIFT                       _MK_SHIFT_CONST(4)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_LPMD_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_LPMD_SHIFT)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_LPMD_RANGE                       5:4
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_LPMD_WOFFSET                     0x0
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_LPMD_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_LPMD_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_LPMD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_LPMD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_SHIFT                  _MK_SHIFT_CONST(12)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_FIELD                  (_MK_MASK_CONST(0x1f) << APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_RANGE                  16:12
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_WOFFSET                        0x0
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_DEFAULT                        _MK_MASK_CONST(0x12)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_SHIFT                  _MK_SHIFT_CONST(20)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_FIELD                  (_MK_MASK_CONST(0x1f) << APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_RANGE                  24:20
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_WOFFSET                        0x0
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_DEFAULT                        _MK_MASK_CONST(0x16)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_SLWR_SHIFT                     _MK_SHIFT_CONST(28)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_SLWR_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_SLWR_RANGE                     29:28
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_SLWR_WOFFSET                   0x0
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_SLWR_DEFAULT                   _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_SLWR_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_SLWR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_SLWF_SHIFT                     _MK_SHIFT_CONST(30)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_SLWF_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_SLWF_RANGE                     31:30
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_SLWF_WOFFSET                   0x0
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_SLWF_DEFAULT                   _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_SLWF_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_SLWF_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART2CFGPADCTRL_0_CFG2TMC_UART2CFG_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_UART3CFGPADCTRL_0  //        0       rw  CFG2TMC_UART3CFG_PULLD_EN   i=0x0   // UART3CFG pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_UART3CFG_PULLU_EN   i=0x0   // UART3CFG pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_UART3CFGPADCTRL_0                   _MK_ADDR_CONST(0x8b8)
#define APB_MISC_GP_UART3CFGPADCTRL_0_WORD_COUNT                        0x1
#define APB_MISC_GP_UART3CFGPADCTRL_0_RESET_VAL                         _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_UART3CFGPADCTRL_0_RESET_MASK                        _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_UART3CFGPADCTRL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART3CFGPADCTRL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART3CFGPADCTRL_0_READ_MASK                         _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_UART3CFGPADCTRL_0_WRITE_MASK                        _MK_MASK_CONST(0xf1f1f03c)
// UART3CFG data pins high speed mode enable
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_HSM_EN_SHIFT                     _MK_SHIFT_CONST(2)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_HSM_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_HSM_EN_SHIFT)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_HSM_EN_RANGE                     2:2
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_HSM_EN_WOFFSET                   0x0
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_HSM_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_HSM_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_HSM_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_HSM_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_HSM_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_HSM_EN_ENABLE                    _MK_ENUM_CONST(1)

// UART3CFG data pins schmidt enable
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_SCHMT_EN_SHIFT                   _MK_SHIFT_CONST(3)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_SCHMT_EN_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_SCHMT_EN_SHIFT)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_SCHMT_EN_RANGE                   3:3
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_SCHMT_EN_WOFFSET                 0x0
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_SCHMT_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_SCHMT_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_SCHMT_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_SCHMT_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_SCHMT_EN_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_SCHMT_EN_ENABLE                  _MK_ENUM_CONST(1)

// UART3CFG data pins low power mode select
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_LPMD_SHIFT                       _MK_SHIFT_CONST(4)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_LPMD_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_LPMD_SHIFT)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_LPMD_RANGE                       5:4
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_LPMD_WOFFSET                     0x0
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_LPMD_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_LPMD_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_LPMD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_LPMD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_SHIFT                  _MK_SHIFT_CONST(12)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_FIELD                  (_MK_MASK_CONST(0x1f) << APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_RANGE                  16:12
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_WOFFSET                        0x0
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_DEFAULT                        _MK_MASK_CONST(0x12)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_SHIFT                  _MK_SHIFT_CONST(20)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_FIELD                  (_MK_MASK_CONST(0x1f) << APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_RANGE                  24:20
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_WOFFSET                        0x0
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_DEFAULT                        _MK_MASK_CONST(0x16)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_SLWR_SHIFT                     _MK_SHIFT_CONST(28)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_SLWR_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_SLWR_RANGE                     29:28
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_SLWR_WOFFSET                   0x0
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_SLWR_DEFAULT                   _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_SLWR_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_SLWR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_SLWF_SHIFT                     _MK_SHIFT_CONST(30)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_SLWF_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_SLWF_RANGE                     31:30
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_SLWF_WOFFSET                   0x0
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_SLWF_DEFAULT                   _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_SLWF_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_SLWF_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_UART3CFGPADCTRL_0_CFG2TMC_UART3CFG_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_VICFG1PADCTRL_0  //        0       rw  CFG2TMC_VICFG1_PULLD_EN   i=0x0   // VICFG1 pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_VICFG1_PULLU_EN   i=0x0   // VICFG1 pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_VICFG1PADCTRL_0                     _MK_ADDR_CONST(0x8bc)
#define APB_MISC_GP_VICFG1PADCTRL_0_WORD_COUNT                  0x1
#define APB_MISC_GP_VICFG1PADCTRL_0_RESET_VAL                   _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_VICFG1PADCTRL_0_RESET_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_VICFG1PADCTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG1PADCTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG1PADCTRL_0_READ_MASK                   _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_VICFG1PADCTRL_0_WRITE_MASK                  _MK_MASK_CONST(0xf1f1f03c)
// VICFG1 data pins high speed mode enable
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_HSM_EN_SHIFT                 _MK_SHIFT_CONST(2)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_HSM_EN_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_HSM_EN_SHIFT)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_HSM_EN_RANGE                 2:2
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_HSM_EN_WOFFSET                       0x0
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_HSM_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_HSM_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_HSM_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_HSM_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_HSM_EN_DISABLE                       _MK_ENUM_CONST(0)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_HSM_EN_ENABLE                        _MK_ENUM_CONST(1)

// VICFG1 data pins schmidt enable
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_SCHMT_EN_SHIFT                       _MK_SHIFT_CONST(3)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_SCHMT_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_SCHMT_EN_SHIFT)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_SCHMT_EN_RANGE                       3:3
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_SCHMT_EN_WOFFSET                     0x0
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_SCHMT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_SCHMT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_SCHMT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_SCHMT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_SCHMT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_SCHMT_EN_ENABLE                      _MK_ENUM_CONST(1)

// VICFG1 data pins low power mode select
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_LPMD_SHIFT                   _MK_SHIFT_CONST(4)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_LPMD_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_LPMD_SHIFT)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_LPMD_RANGE                   5:4
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_LPMD_WOFFSET                 0x0
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_LPMD_DEFAULT                 _MK_MASK_CONST(0x3)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_LPMD_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_LPMD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_LPMD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_RANGE                      16:12
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_WOFFSET                    0x0
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_DEFAULT                    _MK_MASK_CONST(0x12)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_SHIFT                      _MK_SHIFT_CONST(20)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_RANGE                      24:20
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_WOFFSET                    0x0
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_DEFAULT                    _MK_MASK_CONST(0x16)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_SLWR_SHIFT                 _MK_SHIFT_CONST(28)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_SLWR_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_SLWR_RANGE                 29:28
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_SLWR_WOFFSET                       0x0
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_SLWR_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_SLWR_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_SLWR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_SLWF_SHIFT                 _MK_SHIFT_CONST(30)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_SLWF_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_SLWF_RANGE                 31:30
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_SLWF_WOFFSET                       0x0
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_SLWF_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_SLWF_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_SLWF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG1PADCTRL_0_CFG2TMC_VICFG1_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_VICFG2PADCTRL_0  //        0       rw  CFG2TMC_VICFG2_PULLD_EN   i=0x0   // VICFG2 pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_VICFG2_PULLU_EN   i=0x0   // VICFG2 pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_VICFG2PADCTRL_0                     _MK_ADDR_CONST(0x8c0)
#define APB_MISC_GP_VICFG2PADCTRL_0_WORD_COUNT                  0x1
#define APB_MISC_GP_VICFG2PADCTRL_0_RESET_VAL                   _MK_MASK_CONST(0xf1612030)
#define APB_MISC_GP_VICFG2PADCTRL_0_RESET_MASK                  _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_VICFG2PADCTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG2PADCTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG2PADCTRL_0_READ_MASK                   _MK_MASK_CONST(0xf1f1f03c)
#define APB_MISC_GP_VICFG2PADCTRL_0_WRITE_MASK                  _MK_MASK_CONST(0xf1f1f03c)
// VICFG2 data pins high speed mode enable
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_HSM_EN_SHIFT                 _MK_SHIFT_CONST(2)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_HSM_EN_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_HSM_EN_SHIFT)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_HSM_EN_RANGE                 2:2
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_HSM_EN_WOFFSET                       0x0
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_HSM_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_HSM_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_HSM_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_HSM_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_HSM_EN_DISABLE                       _MK_ENUM_CONST(0)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_HSM_EN_ENABLE                        _MK_ENUM_CONST(1)

// VICFG2 data pins schmidt enable
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_SCHMT_EN_SHIFT                       _MK_SHIFT_CONST(3)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_SCHMT_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_SCHMT_EN_SHIFT)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_SCHMT_EN_RANGE                       3:3
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_SCHMT_EN_WOFFSET                     0x0
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_SCHMT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_SCHMT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_SCHMT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_SCHMT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_SCHMT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_SCHMT_EN_ENABLE                      _MK_ENUM_CONST(1)

// VICFG2 data pins low power mode select
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_LPMD_SHIFT                   _MK_SHIFT_CONST(4)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_LPMD_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_LPMD_SHIFT)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_LPMD_RANGE                   5:4
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_LPMD_WOFFSET                 0x0
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_LPMD_DEFAULT                 _MK_MASK_CONST(0x3)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_LPMD_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_LPMD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_LPMD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_SHIFT                      _MK_SHIFT_CONST(12)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_RANGE                      16:12
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_WOFFSET                    0x0
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_DEFAULT                    _MK_MASK_CONST(0x12)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_SHIFT                      _MK_SHIFT_CONST(20)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_FIELD                      (_MK_MASK_CONST(0x1f) << APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_RANGE                      24:20
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_WOFFSET                    0x0
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_DEFAULT                    _MK_MASK_CONST(0x16)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_SLWR_SHIFT                 _MK_SHIFT_CONST(28)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_SLWR_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_SLWR_RANGE                 29:28
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_SLWR_WOFFSET                       0x0
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_SLWR_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_SLWR_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_SLWR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_SLWF_SHIFT                 _MK_SHIFT_CONST(30)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_SLWF_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_SLWF_RANGE                 31:30
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_SLWF_WOFFSET                       0x0
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_SLWF_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_SLWF_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_SLWF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_VICFG2PADCTRL_0_CFG2TMC_VICFG2_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_XM2CFGAPADCTRL_0  //        0       rw  CFG2TMC_XM2CFGA_PULLD_EN   i=0x0 // XM2CFGA pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_XM2CFGA_PULLU_EN i=0x0   // XM2CFGA pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_XM2CFGAPADCTRL_0                    _MK_ADDR_CONST(0x8c4)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_WORD_COUNT                         0x1
#define APB_MISC_GP_XM2CFGAPADCTRL_0_RESET_VAL                  _MK_MASK_CONST(0xf1f1f030)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_RESET_MASK                         _MK_MASK_CONST(0xf1f1f074)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_READ_MASK                  _MK_MASK_CONST(0xf1f1f074)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_WRITE_MASK                         _MK_MASK_CONST(0xf1f1f074)
// XM2CFGA data pins high speed mode enable        3       rw  CFG2TMC_XM2CFGA_SCHMT_EN i=0x0   // XM2CFGA data pins schmidt enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_HSM_EN_SHIFT                       _MK_SHIFT_CONST(2)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_HSM_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_HSM_EN_SHIFT)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_HSM_EN_RANGE                       2:2
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_HSM_EN_WOFFSET                     0x0
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_HSM_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_HSM_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_HSM_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_HSM_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_HSM_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_HSM_EN_ENABLE                      _MK_ENUM_CONST(1)

// XM2CFGA data pins low power mode select
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_LPMD_SHIFT                 _MK_SHIFT_CONST(4)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_LPMD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_LPMD_SHIFT)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_LPMD_RANGE                 5:4
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_LPMD_WOFFSET                       0x0
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_LPMD_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_LPMD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_LPMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_LPMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// XM2CFGA data pins vref enable
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_VREF_EN_SHIFT                      _MK_SHIFT_CONST(6)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_VREF_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_VREF_EN_SHIFT)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_VREF_EN_RANGE                      6:6
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_VREF_EN_WOFFSET                    0x0
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_VREF_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_VREF_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_VREF_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_VREF_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_VREF_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_VREF_EN_ENABLE                     _MK_ENUM_CONST(1)

#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_SHIFT                    _MK_SHIFT_CONST(12)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_RANGE                    16:12
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_WOFFSET                  0x0
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_DEFAULT                  _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_SHIFT                    _MK_SHIFT_CONST(20)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_RANGE                    24:20
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_WOFFSET                  0x0
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_DEFAULT                  _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_SLWR_SHIFT                       _MK_SHIFT_CONST(28)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_SLWR_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_SLWR_RANGE                       29:28
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_SLWR_WOFFSET                     0x0
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_SLWR_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_SLWR_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_SLWR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_SLWF_SHIFT                       _MK_SHIFT_CONST(30)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_SLWF_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_SLWF_RANGE                       31:30
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_SLWF_WOFFSET                     0x0
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_SLWF_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_SLWF_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_SLWF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_XM2CFGCPADCTRL_0  //        0       rw  CFG2TMC_XM2CFGC_PULLD_EN   i=0x0   // XM2CFGC pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_XM2CFGC_PULLU_EN   i=0x0   // XM2CFGC pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_XM2CFGCPADCTRL_0                    _MK_ADDR_CONST(0x8c8)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_WORD_COUNT                         0x1
#define APB_MISC_GP_XM2CFGCPADCTRL_0_RESET_VAL                  _MK_MASK_CONST(0xf1f1f030)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_RESET_MASK                         _MK_MASK_CONST(0xf1f1f07c)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_READ_MASK                  _MK_MASK_CONST(0xf1f1f07c)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_WRITE_MASK                         _MK_MASK_CONST(0xf1f1f07c)
// XM2CFGC data pins high speed mode enable
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_HSM_EN_SHIFT                       _MK_SHIFT_CONST(2)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_HSM_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_HSM_EN_SHIFT)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_HSM_EN_RANGE                       2:2
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_HSM_EN_WOFFSET                     0x0
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_HSM_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_HSM_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_HSM_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_HSM_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_HSM_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_HSM_EN_ENABLE                      _MK_ENUM_CONST(1)

// XM2CFGC data pins schmidt enable
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_SCHMT_EN_SHIFT                     _MK_SHIFT_CONST(3)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_SCHMT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_SCHMT_EN_SHIFT)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_SCHMT_EN_RANGE                     3:3
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_SCHMT_EN_WOFFSET                   0x0
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_SCHMT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_SCHMT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_SCHMT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_SCHMT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_SCHMT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_SCHMT_EN_ENABLE                    _MK_ENUM_CONST(1)

// XM2CFGC data pins low power mode select
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_LPMD_SHIFT                 _MK_SHIFT_CONST(4)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_LPMD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_LPMD_SHIFT)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_LPMD_RANGE                 5:4
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_LPMD_WOFFSET                       0x0
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_LPMD_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_LPMD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_LPMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_LPMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// XM2CFGC data pins vref enable
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_VREF_EN_SHIFT                      _MK_SHIFT_CONST(6)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_VREF_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_VREF_EN_SHIFT)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_VREF_EN_RANGE                      6:6
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_VREF_EN_WOFFSET                    0x0
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_VREF_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_VREF_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_VREF_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_VREF_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_VREF_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_VREF_EN_ENABLE                     _MK_ENUM_CONST(1)

#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_SHIFT                    _MK_SHIFT_CONST(12)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_RANGE                    16:12
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_WOFFSET                  0x0
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_DEFAULT                  _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_SHIFT                    _MK_SHIFT_CONST(20)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_RANGE                    24:20
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_WOFFSET                  0x0
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_DEFAULT                  _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_SLWR_SHIFT                       _MK_SHIFT_CONST(28)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_SLWR_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_SLWR_RANGE                       29:28
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_SLWR_WOFFSET                     0x0
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_SLWR_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_SLWR_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_SLWR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_SLWF_SHIFT                       _MK_SHIFT_CONST(30)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_SLWF_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_SLWF_RANGE                       31:30
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_SLWF_WOFFSET                     0x0
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_SLWF_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_SLWF_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_SLWF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_XM2CFGDPADCTRL_0  //        0       rw  CFG2TMC_XM2CFGD_PULLD_EN   i=0x0   // XM2CFGD pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_XM2CFGD_PULLU_EN   i=0x0   // XM2CFGD pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_XM2CFGDPADCTRL_0                    _MK_ADDR_CONST(0x8cc)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_WORD_COUNT                         0x1
#define APB_MISC_GP_XM2CFGDPADCTRL_0_RESET_VAL                  _MK_MASK_CONST(0xf1f1f030)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_RESET_MASK                         _MK_MASK_CONST(0xf1f1f07c)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_READ_MASK                  _MK_MASK_CONST(0xf1f1f07c)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_WRITE_MASK                         _MK_MASK_CONST(0xf1f1f07c)
// XM2CFGD data pins high speed mode enable
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_HSM_EN_SHIFT                       _MK_SHIFT_CONST(2)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_HSM_EN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_HSM_EN_SHIFT)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_HSM_EN_RANGE                       2:2
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_HSM_EN_WOFFSET                     0x0
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_HSM_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_HSM_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_HSM_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_HSM_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_HSM_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_HSM_EN_ENABLE                      _MK_ENUM_CONST(1)

// XM2CFGD data pins schmidt enable
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_SCHMT_EN_SHIFT                     _MK_SHIFT_CONST(3)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_SCHMT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_SCHMT_EN_SHIFT)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_SCHMT_EN_RANGE                     3:3
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_SCHMT_EN_WOFFSET                   0x0
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_SCHMT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_SCHMT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_SCHMT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_SCHMT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_SCHMT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_SCHMT_EN_ENABLE                    _MK_ENUM_CONST(1)

// XM2CFGD data pins low power mode select
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_LPMD_SHIFT                 _MK_SHIFT_CONST(4)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_LPMD_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_LPMD_SHIFT)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_LPMD_RANGE                 5:4
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_LPMD_WOFFSET                       0x0
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_LPMD_DEFAULT                       _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_LPMD_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_LPMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_LPMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// XM2CFGD data pins vref enable
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_VREF_EN_SHIFT                      _MK_SHIFT_CONST(6)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_VREF_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_VREF_EN_SHIFT)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_VREF_EN_RANGE                      6:6
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_VREF_EN_WOFFSET                    0x0
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_VREF_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_VREF_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_VREF_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_VREF_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_VREF_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_VREF_EN_ENABLE                     _MK_ENUM_CONST(1)

#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_SHIFT                    _MK_SHIFT_CONST(12)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_RANGE                    16:12
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_WOFFSET                  0x0
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_DEFAULT                  _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_SHIFT                    _MK_SHIFT_CONST(20)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_RANGE                    24:20
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_WOFFSET                  0x0
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_DEFAULT                  _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_SLWR_SHIFT                       _MK_SHIFT_CONST(28)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_SLWR_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_SLWR_RANGE                       29:28
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_SLWR_WOFFSET                     0x0
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_SLWR_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_SLWR_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_SLWR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_SLWF_SHIFT                       _MK_SHIFT_CONST(30)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_SLWF_FIELD                       (_MK_MASK_CONST(0x3) << APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_SLWF_RANGE                       31:30
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_SLWF_WOFFSET                     0x0
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_SLWF_DEFAULT                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_SLWF_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_SLWF_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_XM2CLKCFGPADCTRL_0  //        0       rw  CFG2TMC_XM2CLKCFG_PULLD_EN   i=0x0   // XM2CLKCFG pulldown mode enable
//            enum ( DISABLE, ENABLE )
//        1       rw  CFG2TMC_XM2CLKCFG_PULLU_EN   i=0x0   // XM2CLKCFG pullup mode enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0                  _MK_ADDR_CONST(0x8d0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_WORD_COUNT                       0x1
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_RESET_VAL                        _MK_MASK_CONST(0xf1f1f030)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_RESET_MASK                       _MK_MASK_CONST(0xf1f1f07c)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_READ_MASK                        _MK_MASK_CONST(0xf1f1f07c)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_WRITE_MASK                       _MK_MASK_CONST(0xf1f1f07c)
// XM2CLKCFG data pins high speed mode enable
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_HSM_EN_SHIFT                   _MK_SHIFT_CONST(2)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_HSM_EN_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_HSM_EN_SHIFT)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_HSM_EN_RANGE                   2:2
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_HSM_EN_WOFFSET                 0x0
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_HSM_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_HSM_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_HSM_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_HSM_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_HSM_EN_DISABLE                 _MK_ENUM_CONST(0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_HSM_EN_ENABLE                  _MK_ENUM_CONST(1)

// XM2CLKCFG data pins schmidt enable
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_SCHMT_EN_SHIFT                 _MK_SHIFT_CONST(3)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_SCHMT_EN_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_SCHMT_EN_SHIFT)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_SCHMT_EN_RANGE                 3:3
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_SCHMT_EN_WOFFSET                       0x0
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_SCHMT_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_SCHMT_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_SCHMT_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_SCHMT_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_SCHMT_EN_DISABLE                       _MK_ENUM_CONST(0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_SCHMT_EN_ENABLE                        _MK_ENUM_CONST(1)

// XM2CLKCFG data pins low power mode select
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_LPMD_SHIFT                     _MK_SHIFT_CONST(4)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_LPMD_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_LPMD_SHIFT)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_LPMD_RANGE                     5:4
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_LPMD_WOFFSET                   0x0
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_LPMD_DEFAULT                   _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_LPMD_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_LPMD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_LPMD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// XM2CLKCFG data pins vref enable
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_VREF_EN_SHIFT                  _MK_SHIFT_CONST(6)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_VREF_EN_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_VREF_EN_SHIFT)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_VREF_EN_RANGE                  6:6
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_VREF_EN_WOFFSET                        0x0
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_VREF_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_VREF_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_VREF_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_VREF_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_VREF_EN_DISABLE                        _MK_ENUM_CONST(0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_VREF_EN_ENABLE                 _MK_ENUM_CONST(1)

#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_SHIFT                        _MK_SHIFT_CONST(12)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_FIELD                        (_MK_MASK_CONST(0x1f) << APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_SHIFT)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_RANGE                        16:12
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_WOFFSET                      0x0
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_DEFAULT                      _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_SHIFT                        _MK_SHIFT_CONST(20)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_FIELD                        (_MK_MASK_CONST(0x1f) << APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_SHIFT)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_RANGE                        24:20
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_WOFFSET                      0x0
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_DEFAULT                      _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_SLWR_SHIFT                   _MK_SHIFT_CONST(28)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_SLWR_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_SLWR_SHIFT)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_SLWR_RANGE                   29:28
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_SLWR_WOFFSET                 0x0
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_SLWR_DEFAULT                 _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_SLWR_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_SLWR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVDN_SLWR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_SLWF_SHIFT                   _MK_SHIFT_CONST(30)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_SLWF_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_SLWF_SHIFT)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_SLWF_RANGE                   31:30
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_SLWF_WOFFSET                 0x0
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_SLWF_DEFAULT                 _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_SLWF_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_SLWF_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_CAL_DRVUP_SLWF_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_MEMCOMPPADCTRL_0  //        0       rw  CFG2TMC_MEM_COMP_EN_COMP    i=0x0   // compensation enable
//            enum ( DISABLE, ENABLE )
#define APB_MISC_GP_MEMCOMPPADCTRL_0                    _MK_ADDR_CONST(0x8d4)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_WORD_COUNT                         0x1
#define APB_MISC_GP_MEMCOMPPADCTRL_0_RESET_VAL                  _MK_MASK_CONST(0x1f1f000)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_RESET_MASK                         _MK_MASK_CONST(0x1f1f004)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_READ_MASK                  _MK_MASK_CONST(0x1f1f004)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_WRITE_MASK                         _MK_MASK_CONST(0x1f1f004)
// high speed mode enable
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM_E_HSM_SHIFT                    _MK_SHIFT_CONST(2)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM_E_HSM_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_GP_MEMCOMPPADCTRL_0_MEM_E_HSM_SHIFT)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM_E_HSM_RANGE                    2:2
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM_E_HSM_WOFFSET                  0x0
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM_E_HSM_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM_E_HSM_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM_E_HSM_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM_E_HSM_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM_E_HSM_DISABLE                  _MK_ENUM_CONST(0)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM_E_HSM_ENABLE                   _MK_ENUM_CONST(1)

#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVDN_SHIFT                    _MK_SHIFT_CONST(12)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVDN_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVDN_SHIFT)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVDN_RANGE                    16:12
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVDN_WOFFSET                  0x0
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVDN_DEFAULT                  _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVDN_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVDN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVDN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVUP_SHIFT                    _MK_SHIFT_CONST(20)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVUP_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVUP_SHIFT)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVUP_RANGE                    24:20
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVUP_WOFFSET                  0x0
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVUP_DEFAULT                  _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVUP_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVUP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_GP_MEMCOMPPADCTRL_0_MEM2COMPPAD_DRVUP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APB_MISC_GP_PADCTL_DFT_0  
#define APB_MISC_GP_PADCTL_DFT_0                        _MK_ADDR_CONST(0x8d8)
#define APB_MISC_GP_PADCTL_DFT_0_WORD_COUNT                     0x1
#define APB_MISC_GP_PADCTL_DFT_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APB_MISC_GP_PADCTL_DFT_0_RESET_MASK                     _MK_MASK_CONST(0x3)
#define APB_MISC_GP_PADCTL_DFT_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APB_MISC_GP_PADCTL_DFT_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_PADCTL_DFT_0_READ_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_GP_PADCTL_DFT_0_WRITE_MASK                     _MK_MASK_CONST(0x3)
// Enable pin-shorting for tester mode pin-shorting
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_EN_SHIFT                      _MK_SHIFT_CONST(0)
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_EN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_GP_PADCTL_DFT_0_PINSHORT_EN_SHIFT)
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_EN_RANGE                      0:0
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_EN_WOFFSET                    0x0
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_EN_DISABLE                    _MK_ENUM_CONST(0)
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_EN_ENABLE                     _MK_ENUM_CONST(1)

// Select which pins are used for test-mode observe
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_SEL_SHIFT                     _MK_SHIFT_CONST(1)
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_SEL_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_GP_PADCTL_DFT_0_PINSHORT_SEL_SHIFT)
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_SEL_RANGE                     1:1
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_SEL_WOFFSET                   0x0
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_SEL_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_SEL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_SEL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_GP_PADCTL_DFT_0_PINSHORT_SEL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APB_MISC_UTMIP_PLL_CFG0_0  // USB_PHY PLL Configuration Register 0
//
// The data sampling frequency relies on a 960MHz clock, so the goal of the PLL is to have:
// In_Frequency*(PLL_VCOMULTBY2+1)*(PLL_NDIV/PLL_MDIV) = 960MHz
//
// With a 12MHz input from PLL_U, the default setting of 
// PLL_VCOMULTBY2=1, PLL_NDIV=40 and PLL_MDIV=1 results in a correct output.
#define APB_MISC_UTMIP_PLL_CFG0_0                       _MK_ADDR_CONST(0xa00)
#define APB_MISC_UTMIP_PLL_CFG0_0_WORD_COUNT                    0x1
#define APB_MISC_UTMIP_PLL_CFG0_0_RESET_VAL                     _MK_MASK_CONST(0x280180)
#define APB_MISC_UTMIP_PLL_CFG0_0_RESET_MASK                    _MK_MASK_CONST(0x7fffffff)
#define APB_MISC_UTMIP_PLL_CFG0_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG0_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG0_0_READ_MASK                     _MK_MASK_CONST(0x7fffffff)
#define APB_MISC_UTMIP_PLL_CFG0_0_WRITE_MASK                    _MK_MASK_CONST(0x7fffffff)
// LOCK_ENABLE input of USB_PHY PLL.
// Normally only used during test. See cell specification.
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_RANGE                    0:0
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_WOFFSET                  0x0
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// LOCKSEL[5:0] input of USB_PHY PLL.
// Used in test modes only. See cell specification.
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_SHIFT                       _MK_SHIFT_CONST(1)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_FIELD                       (_MK_MASK_CONST(0x3f) << APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_RANGE                       6:1
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_WOFFSET                     0x0
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3f)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// VCOMULTBY2 control of the UTMIP PHY PLL.
// Recommended setting is on. Additional divide by 2 on the 
// VCO feedback. Which is setting the bit to 1. See cell spec.
//
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_SHIFT                    _MK_SHIFT_CONST(7)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_RANGE                    7:7
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_WOFFSET                  0x0
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_DEFAULT                  _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// MDIV[7:0] input of the USB_PHY PLL. This is the predivide on the PLL. 
// 0x0 is not allowed. See cell specification.
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_SHIFT                  _MK_SHIFT_CONST(8)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_FIELD                  (_MK_MASK_CONST(0xff) << APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_RANGE                  15:8
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_WOFFSET                        0x0
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_DEFAULT                        _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// NDIV[7:0] input of USB_PHY PLL. 
// This is the feedback divider on the VCO feedback. 
// 0x0 is not allowed. See cell specification.
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_SHIFT                  _MK_SHIFT_CONST(16)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_FIELD                  (_MK_MASK_CONST(0xff) << APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_RANGE                  23:16
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_WOFFSET                        0x0
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_DEFAULT                        _MK_MASK_CONST(0x28)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// PDIV[2:0] input of the USB_PHY PLL.
// Reserved. Keep at 0x0. Currently there is no post divider on this PLL. 
// See cell specification.
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_SHIFT                  _MK_SHIFT_CONST(24)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_FIELD                  (_MK_MASK_CONST(0x7) << APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_RANGE                  26:24
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_WOFFSET                        0x0
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// PDIVRST of the UTMIP PHY PLL.
// Reserved. Keep at 0x0. Currently there is no post divider on this PLL. 
// See cell specification.
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_SHIFT                       _MK_SHIFT_CONST(27)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_RANGE                       27:27
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_WOFFSET                     0x0
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Selects which of the eight 60MHz clock phases to produce at the output 
// of the USB PHY PLL. This is for a test mode. See cell specification.
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_SHIFT                        _MK_SHIFT_CONST(28)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_FIELD                        (_MK_MASK_CONST(0x7) << APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_RANGE                        30:28
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_WOFFSET                      0x0
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_DEFAULT_MASK                 _MK_MASK_CONST(0x7)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APB_MISC_UTMIP_PLL_CFG1_0  // UTMIP PLL and PLLU configuration register 1
#define APB_MISC_UTMIP_PLL_CFG1_0                       _MK_ADDR_CONST(0xa04)
#define APB_MISC_UTMIP_PLL_CFG1_0_WORD_COUNT                    0x1
#define APB_MISC_UTMIP_PLL_CFG1_0_RESET_VAL                     _MK_MASK_CONST(0x182000c0)
#define APB_MISC_UTMIP_PLL_CFG1_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define APB_MISC_UTMIP_PLL_CFG1_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define APB_MISC_UTMIP_PLL_CFG1_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
// Determines the time to wait until the output of USB_PHY PLL is considered stable. 
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_SHIFT                   _MK_SHIFT_CONST(0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_FIELD                   (_MK_MASK_CONST(0xfff) << APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_RANGE                   11:0
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_WOFFSET                 0x0
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_DEFAULT                 _MK_MASK_CONST(0xc0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_DEFAULT_MASK                    _MK_MASK_CONST(0xfff)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Force USB_PHY PLL pll_active input off. (Overrides FORCE_PLL_ACTIVE_POWERUP.)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_SHIFT                        _MK_SHIFT_CONST(12)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_RANGE                        12:12
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_WOFFSET                      0x0
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Force USB_PHY PLL pll_active input on. 
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_SHIFT                  _MK_SHIFT_CONST(13)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_RANGE                  13:13
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_WOFFSET                        0x0
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Force USB_PHY PLL pll_enable input off. (Overrides FORCE_PLL_ENABLE_POWERUP.)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_SHIFT                        _MK_SHIFT_CONST(14)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_RANGE                        14:14
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_WOFFSET                      0x0
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Force USB_PHY PLL pll_enable input on. 
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_SHIFT                  _MK_SHIFT_CONST(15)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_RANGE                  15:15
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_WOFFSET                        0x0
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Force PLL_U into power down. (Overrides FORCE_PLLU_POWERUP.)  
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_SHIFT                      _MK_SHIFT_CONST(16)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_RANGE                      16:16
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_WOFFSET                    0x0
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Force PLL_U into power up.
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_SHIFT                        _MK_SHIFT_CONST(17)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_RANGE                        17:17
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_WOFFSET                      0x0
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// SETUP[8:0] input of USB_PHY PLL.
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_SHIFT                 _MK_SHIFT_CONST(18)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_FIELD                 (_MK_MASK_CONST(0x1ff) << APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_RANGE                 26:18
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_WOFFSET                       0x0
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_DEFAULT                       _MK_MASK_CONST(0x8)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_DEFAULT_MASK                  _MK_MASK_CONST(0x1ff)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Controls the wait time to enable PLL_U when coming out of suspend or reset.
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_SHIFT                     _MK_SHIFT_CONST(27)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_FIELD                     (_MK_MASK_CONST(0x1f) << APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_SHIFT)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_RANGE                     31:27
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_WOFFSET                   0x0
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_DEFAULT                   _MK_MASK_CONST(0x3)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_DEFAULT_MASK                      _MK_MASK_CONST(0x1f)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APB_MISC_UTMIP_XCVR_CFG0_0  // UTMIP transceiver cell configuration register 0
#define APB_MISC_UTMIP_XCVR_CFG0_0                      _MK_ADDR_CONST(0xa08)
#define APB_MISC_UTMIP_XCVR_CFG0_0_WORD_COUNT                   0x1
#define APB_MISC_UTMIP_XCVR_CFG0_0_RESET_VAL                    _MK_MASK_CONST(0x250a)
#define APB_MISC_UTMIP_XCVR_CFG0_0_RESET_MASK                   _MK_MASK_CONST(0xfffff)
#define APB_MISC_UTMIP_XCVR_CFG0_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_READ_MASK                    _MK_MASK_CONST(0xfffff)
#define APB_MISC_UTMIP_XCVR_CFG0_0_WRITE_MASK                   _MK_MASK_CONST(0xfffff)
// SETUP[3:0] input of XCVR cell. HS driver output control.
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_SHIFT                       _MK_SHIFT_CONST(0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_FIELD                       (_MK_MASK_CONST(0xf) << APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_SHIFT)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_RANGE                       3:0
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_WOFFSET                     0x0
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_DEFAULT                     _MK_MASK_CONST(0xa)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// HS slew rate control.
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_SHIFT                      _MK_SHIFT_CONST(4)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_SHIFT)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_RANGE                      5:4
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_WOFFSET                    0x0
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// FS slew rate control.
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_SHIFT                      _MK_SHIFT_CONST(6)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_FIELD                      (_MK_MASK_CONST(0x3) << APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_SHIFT)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_RANGE                      7:6
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_WOFFSET                    0x0
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// LS rising slew rate control.
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_SHIFT                     _MK_SHIFT_CONST(8)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_SHIFT)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_RANGE                     9:8
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_WOFFSET                   0x0
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_DEFAULT                   _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// LS falling slew rate control.
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_SHIFT                     _MK_SHIFT_CONST(10)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_SHIFT)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_RANGE                     11:10
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_WOFFSET                   0x0
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_DEFAULT                   _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Internal loopback inside XCVR cell. Used for IOBIST.
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_SHIFT                  _MK_SHIFT_CONST(12)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_SHIFT)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_RANGE                  12:12
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_WOFFSET                        0x0
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Enable HS termination.
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_SHIFT                      _MK_SHIFT_CONST(13)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_SHIFT)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_RANGE                      13:13
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_WOFFSET                    0x0
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_DEFAULT                    _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Force PD input into power down. (Overrides FORCE_PD_POWERUP.)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_SHIFT                       _MK_SHIFT_CONST(14)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_SHIFT)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_RANGE                       14:14
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_WOFFSET                     0x0
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Force PD input into power up. 
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_SHIFT                 _MK_SHIFT_CONST(15)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_SHIFT)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_RANGE                 15:15
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_WOFFSET                       0x0
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Force PD2 input into power down. (Overrides FORCE_PD2_POWERUP.)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_SHIFT                      _MK_SHIFT_CONST(16)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_FIELD                      (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_SHIFT)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_RANGE                      16:16
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_WOFFSET                    0x0
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Force PD2 input into power up.
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_SHIFT                        _MK_SHIFT_CONST(17)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_SHIFT)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_RANGE                        17:17
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_WOFFSET                      0x0
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Force PDZI input into power down. (Overrides FORCE_PDZI_POWERUP.)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_SHIFT                     _MK_SHIFT_CONST(18)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_FIELD                     (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_SHIFT)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_RANGE                     18:18
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_WOFFSET                   0x0
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Force PDZI input into power up.
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_SHIFT                       _MK_SHIFT_CONST(19)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_SHIFT)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_RANGE                       19:19
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_WOFFSET                     0x0
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APB_MISC_UTMIP_BIAS_CFG0_0  // UTMIP Bias cell configuration register 0
#define APB_MISC_UTMIP_BIAS_CFG0_0                      _MK_ADDR_CONST(0xa0c)
#define APB_MISC_UTMIP_BIAS_CFG0_0_WORD_COUNT                   0x1
#define APB_MISC_UTMIP_BIAS_CFG0_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_RESET_MASK                   _MK_MASK_CONST(0xffffff)
#define APB_MISC_UTMIP_BIAS_CFG0_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_READ_MASK                    _MK_MASK_CONST(0xffffff)
#define APB_MISC_UTMIP_BIAS_CFG0_0_WRITE_MASK                   _MK_MASK_CONST(0xffffff)
// HS squelch detector level.
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_SHIFT                  _MK_SHIFT_CONST(0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_FIELD                  (_MK_MASK_CONST(0x3) << APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_SHIFT)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_RANGE                  1:0
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_WOFFSET                        0x0
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// HS disconnect detector level.
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_SHIFT                   _MK_SHIFT_CONST(2)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_SHIFT)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_RANGE                   3:2
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_WOFFSET                 0x0
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// HS chirp detector level.
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_SHIFT                    _MK_SHIFT_CONST(4)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_FIELD                    (_MK_MASK_CONST(0x3) << APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_SHIFT)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_RANGE                    5:4
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_WOFFSET                  0x0
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// SessionEnd detector level.
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_SHIFT                 _MK_SHIFT_CONST(6)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_SHIFT)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_RANGE                 7:6
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_WOFFSET                       0x0
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Vbus detector level.
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_SHIFT                 _MK_SHIFT_CONST(8)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_FIELD                 (_MK_MASK_CONST(0x3) << APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_SHIFT)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_RANGE                 9:8
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_WOFFSET                       0x0
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Power down bias circuit.
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_SHIFT                   _MK_SHIFT_CONST(10)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_SHIFT)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_RANGE                   10:10
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_WOFFSET                 0x0
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Power down OTG circuit.
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_SHIFT                    _MK_SHIFT_CONST(11)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_SHIFT)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_RANGE                    11:11
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_WOFFSET                  0x0
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Active 1.5K pullup control offset.
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_SHIFT                     _MK_SHIFT_CONST(12)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_FIELD                     (_MK_MASK_CONST(0x7) << APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_SHIFT)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_RANGE                     14:12
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_WOFFSET                   0x0
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Active termination control offset.
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_SHIFT                       _MK_SHIFT_CONST(15)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_FIELD                       (_MK_MASK_CONST(0x7) << APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_SHIFT)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_RANGE                       17:15
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_WOFFSET                     0x0
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 0: StaticGpi = IdDig. 1: StaticGpi = GPI_VAL.
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_SHIFT                  _MK_SHIFT_CONST(18)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_SHIFT)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_RANGE                  18:18
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_WOFFSET                        0x0
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// See GPI_SEL.
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_SHIFT                  _MK_SHIFT_CONST(19)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_SHIFT)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_RANGE                  19:19
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_WOFFSET                        0x0
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// 0: IdDig = IdDig. 1: IdDig = IDDIG_VAL.
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_SHIFT                        _MK_SHIFT_CONST(20)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_SHIFT)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_RANGE                        20:20
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_WOFFSET                      0x0
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// See IDDIG_SEL.
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_SHIFT                        _MK_SHIFT_CONST(21)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_FIELD                        (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_SHIFT)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_RANGE                        21:21
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_WOFFSET                      0x0
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// 0: IDPD = ~IdPullup. 1: IDPD = IDPD_VAL.
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_SHIFT                 _MK_SHIFT_CONST(22)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_SHIFT)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_RANGE                 22:22
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_WOFFSET                       0x0
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// See IDPD_SEL.
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_SHIFT                 _MK_SHIFT_CONST(23)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_SHIFT)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_RANGE                 23:23
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_WOFFSET                       0x0
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APB_MISC_UTMIP_HSRX_CFG0_0  // UTMIP High speed receive config 0 
#define APB_MISC_UTMIP_HSRX_CFG0_0                      _MK_ADDR_CONST(0xa10)
#define APB_MISC_UTMIP_HSRX_CFG0_0_WORD_COUNT                   0x1
#define APB_MISC_UTMIP_HSRX_CFG0_0_RESET_VAL                    _MK_MASK_CONST(0x91653400)
#define APB_MISC_UTMIP_HSRX_CFG0_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define APB_MISC_UTMIP_HSRX_CFG0_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define APB_MISC_UTMIP_HSRX_CFG0_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
// Require 4 sync pattern transitions (01) instead of 3
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_SHIFT)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_RANGE                    0:0
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_WOFFSET                  0x0
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Sync pattern detection needs 3 consecutive samples instead of 4
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_SHIFT                   _MK_SHIFT_CONST(1)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_FIELD                   (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_SHIFT)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_RANGE                   1:1
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_WOFFSET                 0x0
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Based on incoming edges and current sampling position, adjust phase
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_SHIFT                     _MK_SHIFT_CONST(2)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_FIELD                     (_MK_MASK_CONST(0x3) << APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_SHIFT)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_RANGE                     3:2
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_WOFFSET                   0x0
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Retime the path. 
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_SHIFT                   _MK_SHIFT_CONST(4)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_FIELD                   (_MK_MASK_CONST(0x3) << APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_SHIFT)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_RANGE                   5:4
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_WOFFSET                 0x0
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Pass through the feedback, do not block it.
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_SHIFT                    _MK_SHIFT_CONST(6)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_FIELD                    (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_SHIFT)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_RANGE                    6:6
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_WOFFSET                  0x0
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// When in Chirp Mode, allow chirp rx data through
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_SHIFT                       _MK_SHIFT_CONST(7)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_FIELD                       (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_SHIFT)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_RANGE                       7:7
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_WOFFSET                     0x0
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Do not declare underrun errors
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_SHIFT                 _MK_SHIFT_CONST(8)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_FIELD                 (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_SHIFT)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_RANGE                 8:8
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_WOFFSET                       0x0
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Do not declare overrun errors until overflow of FIFO
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_SHIFT                  _MK_SHIFT_CONST(9)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_FIELD                  (_MK_MASK_CONST(0x1) << APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_SHIFT)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_RANGE                  9:9
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_WOFFSET                        0x0
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Depth of elastic input store
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_LIMIT_SHIFT                    _MK_SHIFT_CONST(10)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_LIMIT_FIELD                    (_MK_MASK_CONST(0x1f) << APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_LIMIT_SHIFT)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_LIMIT_RANGE                    14:10
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_LIMIT_WOFFSET                  0x0
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_LIMIT_DEFAULT                  _MK_MASK_CONST(0xd)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_LIMIT_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define APB_MISC_UTMIP_HSRX_CFG0_0_UTMIP_