/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARAFI_H_INC_
#define ___ARAFI_H_INC_

// Register AFI_AXI_BAR0_SZ_0  
#define AFI_AXI_BAR0_SZ_0                       _MK_ADDR_CONST(0x0)
#define AFI_AXI_BAR0_SZ_0_SECURE                        0x0
#define AFI_AXI_BAR0_SZ_0_WORD_COUNT                    0x1
#define AFI_AXI_BAR0_SZ_0_RESET_VAL                     _MK_MASK_CONST(0x40000)
#define AFI_AXI_BAR0_SZ_0_RESET_MASK                    _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR0_SZ_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR0_SZ_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR0_SZ_0_READ_MASK                     _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR0_SZ_0_WRITE_MASK                    _MK_MASK_CONST(0xfffff)
//The size of the address range associated with BARi is in 4K increments.  
//Value of 0 signifies BARi is not used.
#define AFI_AXI_BAR0_SZ_0_AXI_BAR0_SIZE_SHIFT                   _MK_SHIFT_CONST(0)
#define AFI_AXI_BAR0_SZ_0_AXI_BAR0_SIZE_FIELD                   (_MK_MASK_CONST(0xfffff) << AFI_AXI_BAR0_SZ_0_AXI_BAR0_SIZE_SHIFT)
#define AFI_AXI_BAR0_SZ_0_AXI_BAR0_SIZE_RANGE                   19:0
#define AFI_AXI_BAR0_SZ_0_AXI_BAR0_SIZE_WOFFSET                 0x0
#define AFI_AXI_BAR0_SZ_0_AXI_BAR0_SIZE_DEFAULT                 _MK_MASK_CONST(0x40000)
#define AFI_AXI_BAR0_SZ_0_AXI_BAR0_SIZE_DEFAULT_MASK                    _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR0_SZ_0_AXI_BAR0_SIZE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR0_SZ_0_AXI_BAR0_SIZE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register AFI_AXI_BAR1_SZ_0  
#define AFI_AXI_BAR1_SZ_0                       _MK_ADDR_CONST(0x4)
#define AFI_AXI_BAR1_SZ_0_SECURE                        0x0
#define AFI_AXI_BAR1_SZ_0_WORD_COUNT                    0x1
#define AFI_AXI_BAR1_SZ_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR1_SZ_0_RESET_MASK                    _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR1_SZ_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR1_SZ_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR1_SZ_0_READ_MASK                     _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR1_SZ_0_WRITE_MASK                    _MK_MASK_CONST(0xfffff)
//The size of the address range associated with BARi is in 4K increments.
//Value of 0 signifies BARi is not used.
#define AFI_AXI_BAR1_SZ_0_AXI_BAR1_SIZE_SHIFT                   _MK_SHIFT_CONST(0)
#define AFI_AXI_BAR1_SZ_0_AXI_BAR1_SIZE_FIELD                   (_MK_MASK_CONST(0xfffff) << AFI_AXI_BAR1_SZ_0_AXI_BAR1_SIZE_SHIFT)
#define AFI_AXI_BAR1_SZ_0_AXI_BAR1_SIZE_RANGE                   19:0
#define AFI_AXI_BAR1_SZ_0_AXI_BAR1_SIZE_WOFFSET                 0x0
#define AFI_AXI_BAR1_SZ_0_AXI_BAR1_SIZE_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR1_SZ_0_AXI_BAR1_SIZE_DEFAULT_MASK                    _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR1_SZ_0_AXI_BAR1_SIZE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR1_SZ_0_AXI_BAR1_SIZE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register AFI_AXI_BAR2_SZ_0  
#define AFI_AXI_BAR2_SZ_0                       _MK_ADDR_CONST(0x8)
#define AFI_AXI_BAR2_SZ_0_SECURE                        0x0
#define AFI_AXI_BAR2_SZ_0_WORD_COUNT                    0x1
#define AFI_AXI_BAR2_SZ_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR2_SZ_0_RESET_MASK                    _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR2_SZ_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR2_SZ_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR2_SZ_0_READ_MASK                     _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR2_SZ_0_WRITE_MASK                    _MK_MASK_CONST(0xfffff)
//The size of the address range associated with BARi is in 4K increments. 
//Value of 0 signifies BARi is not used.
#define AFI_AXI_BAR2_SZ_0_AXI_BAR2_SIZE_SHIFT                   _MK_SHIFT_CONST(0)
#define AFI_AXI_BAR2_SZ_0_AXI_BAR2_SIZE_FIELD                   (_MK_MASK_CONST(0xfffff) << AFI_AXI_BAR2_SZ_0_AXI_BAR2_SIZE_SHIFT)
#define AFI_AXI_BAR2_SZ_0_AXI_BAR2_SIZE_RANGE                   19:0
#define AFI_AXI_BAR2_SZ_0_AXI_BAR2_SIZE_WOFFSET                 0x0
#define AFI_AXI_BAR2_SZ_0_AXI_BAR2_SIZE_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR2_SZ_0_AXI_BAR2_SIZE_DEFAULT_MASK                    _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR2_SZ_0_AXI_BAR2_SIZE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR2_SZ_0_AXI_BAR2_SIZE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register AFI_AXI_BAR3_SZ_0  
#define AFI_AXI_BAR3_SZ_0                       _MK_ADDR_CONST(0xc)
#define AFI_AXI_BAR3_SZ_0_SECURE                        0x0
#define AFI_AXI_BAR3_SZ_0_WORD_COUNT                    0x1
#define AFI_AXI_BAR3_SZ_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR3_SZ_0_RESET_MASK                    _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR3_SZ_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR3_SZ_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR3_SZ_0_READ_MASK                     _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR3_SZ_0_WRITE_MASK                    _MK_MASK_CONST(0xfffff)
//The size of the address range associated with BARi is in 4K increments.
//Value of 0 signifies BARi is not used.
#define AFI_AXI_BAR3_SZ_0_AXI_BAR3_SIZE_SHIFT                   _MK_SHIFT_CONST(0)
#define AFI_AXI_BAR3_SZ_0_AXI_BAR3_SIZE_FIELD                   (_MK_MASK_CONST(0xfffff) << AFI_AXI_BAR3_SZ_0_AXI_BAR3_SIZE_SHIFT)
#define AFI_AXI_BAR3_SZ_0_AXI_BAR3_SIZE_RANGE                   19:0
#define AFI_AXI_BAR3_SZ_0_AXI_BAR3_SIZE_WOFFSET                 0x0
#define AFI_AXI_BAR3_SZ_0_AXI_BAR3_SIZE_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR3_SZ_0_AXI_BAR3_SIZE_DEFAULT_MASK                    _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR3_SZ_0_AXI_BAR3_SIZE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR3_SZ_0_AXI_BAR3_SIZE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register AFI_AXI_BAR4_SZ_0  
#define AFI_AXI_BAR4_SZ_0                       _MK_ADDR_CONST(0x10)
#define AFI_AXI_BAR4_SZ_0_SECURE                        0x0
#define AFI_AXI_BAR4_SZ_0_WORD_COUNT                    0x1
#define AFI_AXI_BAR4_SZ_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR4_SZ_0_RESET_MASK                    _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR4_SZ_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR4_SZ_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR4_SZ_0_READ_MASK                     _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR4_SZ_0_WRITE_MASK                    _MK_MASK_CONST(0xfffff)
//The size of the address range associated with BARi is in 4K increments.
//Value of 0 signifies BARi is not used.
#define AFI_AXI_BAR4_SZ_0_AXI_BAR4_SIZE_SHIFT                   _MK_SHIFT_CONST(0)
#define AFI_AXI_BAR4_SZ_0_AXI_BAR4_SIZE_FIELD                   (_MK_MASK_CONST(0xfffff) << AFI_AXI_BAR4_SZ_0_AXI_BAR4_SIZE_SHIFT)
#define AFI_AXI_BAR4_SZ_0_AXI_BAR4_SIZE_RANGE                   19:0
#define AFI_AXI_BAR4_SZ_0_AXI_BAR4_SIZE_WOFFSET                 0x0
#define AFI_AXI_BAR4_SZ_0_AXI_BAR4_SIZE_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR4_SZ_0_AXI_BAR4_SIZE_DEFAULT_MASK                    _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR4_SZ_0_AXI_BAR4_SIZE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR4_SZ_0_AXI_BAR4_SIZE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register AFI_AXI_BAR5_SZ_0  
#define AFI_AXI_BAR5_SZ_0                       _MK_ADDR_CONST(0x14)
#define AFI_AXI_BAR5_SZ_0_SECURE                        0x0
#define AFI_AXI_BAR5_SZ_0_WORD_COUNT                    0x1
#define AFI_AXI_BAR5_SZ_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR5_SZ_0_RESET_MASK                    _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR5_SZ_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR5_SZ_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR5_SZ_0_READ_MASK                     _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR5_SZ_0_WRITE_MASK                    _MK_MASK_CONST(0xfffff)
//The size of the address range associated with BARi is in 4K increments.
//Value of 0 signifies BARi is not used.
#define AFI_AXI_BAR5_SZ_0_AXI_BAR5_SIZE_SHIFT                   _MK_SHIFT_CONST(0)
#define AFI_AXI_BAR5_SZ_0_AXI_BAR5_SIZE_FIELD                   (_MK_MASK_CONST(0xfffff) << AFI_AXI_BAR5_SZ_0_AXI_BAR5_SIZE_SHIFT)
#define AFI_AXI_BAR5_SZ_0_AXI_BAR5_SIZE_RANGE                   19:0
#define AFI_AXI_BAR5_SZ_0_AXI_BAR5_SIZE_WOFFSET                 0x0
#define AFI_AXI_BAR5_SZ_0_AXI_BAR5_SIZE_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR5_SZ_0_AXI_BAR5_SIZE_DEFAULT_MASK                    _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR5_SZ_0_AXI_BAR5_SIZE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR5_SZ_0_AXI_BAR5_SIZE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register AFI_AXI_BAR0_START_0  
#define AFI_AXI_BAR0_START_0                    _MK_ADDR_CONST(0x18)
#define AFI_AXI_BAR0_START_0_SECURE                     0x0
#define AFI_AXI_BAR0_START_0_WORD_COUNT                         0x1
#define AFI_AXI_BAR0_START_0_RESET_VAL                  _MK_MASK_CONST(0x80000000)
#define AFI_AXI_BAR0_START_0_RESET_MASK                         _MK_MASK_CONST(0xfffff000)
#define AFI_AXI_BAR0_START_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR0_START_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR0_START_0_READ_MASK                  _MK_MASK_CONST(0xfffff000)
#define AFI_AXI_BAR0_START_0_WRITE_MASK                         _MK_MASK_CONST(0xfffff000)
//The start of AXI address space for BARi.  
//The AXI target address is compared to start/size for each BAR 
//to determine if the access is to that BAR.
#define AFI_AXI_BAR0_START_0_AXI_BAR0_START_SHIFT                       _MK_SHIFT_CONST(12)
#define AFI_AXI_BAR0_START_0_AXI_BAR0_START_FIELD                       (_MK_MASK_CONST(0xfffff) << AFI_AXI_BAR0_START_0_AXI_BAR0_START_SHIFT)
#define AFI_AXI_BAR0_START_0_AXI_BAR0_START_RANGE                       31:12
#define AFI_AXI_BAR0_START_0_AXI_BAR0_START_WOFFSET                     0x0
#define AFI_AXI_BAR0_START_0_AXI_BAR0_START_DEFAULT                     _MK_MASK_CONST(0x80000)
#define AFI_AXI_BAR0_START_0_AXI_BAR0_START_DEFAULT_MASK                        _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR0_START_0_AXI_BAR0_START_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR0_START_0_AXI_BAR0_START_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register AFI_AXI_BAR1_START_0  
#define AFI_AXI_BAR1_START_0                    _MK_ADDR_CONST(0x1c)
#define AFI_AXI_BAR1_START_0_SECURE                     0x0
#define AFI_AXI_BAR1_START_0_WORD_COUNT                         0x1
#define AFI_AXI_BAR1_START_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR1_START_0_RESET_MASK                         _MK_MASK_CONST(0xfffff000)
#define AFI_AXI_BAR1_START_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR1_START_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR1_START_0_READ_MASK                  _MK_MASK_CONST(0xfffff000)
#define AFI_AXI_BAR1_START_0_WRITE_MASK                         _MK_MASK_CONST(0xfffff000)
//The start of AXI address space for BARi.  
//The AXI target address is compared to start/size for each BAR 
//to determine if the access is to that BAR.
#define AFI_AXI_BAR1_START_0_AXI_BAR1_START_SHIFT                       _MK_SHIFT_CONST(12)
#define AFI_AXI_BAR1_START_0_AXI_BAR1_START_FIELD                       (_MK_MASK_CONST(0xfffff) << AFI_AXI_BAR1_START_0_AXI_BAR1_START_SHIFT)
#define AFI_AXI_BAR1_START_0_AXI_BAR1_START_RANGE                       31:12
#define AFI_AXI_BAR1_START_0_AXI_BAR1_START_WOFFSET                     0x0
#define AFI_AXI_BAR1_START_0_AXI_BAR1_START_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR1_START_0_AXI_BAR1_START_DEFAULT_MASK                        _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR1_START_0_AXI_BAR1_START_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR1_START_0_AXI_BAR1_START_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register AFI_AXI_BAR2_START_0  
#define AFI_AXI_BAR2_START_0                    _MK_ADDR_CONST(0x20)
#define AFI_AXI_BAR2_START_0_SECURE                     0x0
#define AFI_AXI_BAR2_START_0_WORD_COUNT                         0x1
#define AFI_AXI_BAR2_START_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR2_START_0_RESET_MASK                         _MK_MASK_CONST(0xfffff000)
#define AFI_AXI_BAR2_START_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR2_START_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR2_START_0_READ_MASK                  _MK_MASK_CONST(0xfffff000)
#define AFI_AXI_BAR2_START_0_WRITE_MASK                         _MK_MASK_CONST(0xfffff000)
//The start of AXI address space for BARi.  
//The AXI target address is compared to start/size for each BAR 
//to determine if the access is to that BAR.
#define AFI_AXI_BAR2_START_0_AXI_BAR2_START_SHIFT                       _MK_SHIFT_CONST(12)
#define AFI_AXI_BAR2_START_0_AXI_BAR2_START_FIELD                       (_MK_MASK_CONST(0xfffff) << AFI_AXI_BAR2_START_0_AXI_BAR2_START_SHIFT)
#define AFI_AXI_BAR2_START_0_AXI_BAR2_START_RANGE                       31:12
#define AFI_AXI_BAR2_START_0_AXI_BAR2_START_WOFFSET                     0x0
#define AFI_AXI_BAR2_START_0_AXI_BAR2_START_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR2_START_0_AXI_BAR2_START_DEFAULT_MASK                        _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR2_START_0_AXI_BAR2_START_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR2_START_0_AXI_BAR2_START_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register AFI_AXI_BAR3_START_0  
#define AFI_AXI_BAR3_START_0                    _MK_ADDR_CONST(0x24)
#define AFI_AXI_BAR3_START_0_SECURE                     0x0
#define AFI_AXI_BAR3_START_0_WORD_COUNT                         0x1
#define AFI_AXI_BAR3_START_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR3_START_0_RESET_MASK                         _MK_MASK_CONST(0xfffff000)
#define AFI_AXI_BAR3_START_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR3_START_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR3_START_0_READ_MASK                  _MK_MASK_CONST(0xfffff000)
#define AFI_AXI_BAR3_START_0_WRITE_MASK                         _MK_MASK_CONST(0xfffff000)
//The start of AXI address space for BARi.  
//The AXI target address is compared to start/size for each BAR 
//to determine if the access is to that BAR.
#define AFI_AXI_BAR3_START_0_AXI_BAR3_START_SHIFT                       _MK_SHIFT_CONST(12)
#define AFI_AXI_BAR3_START_0_AXI_BAR3_START_FIELD                       (_MK_MASK_CONST(0xfffff) << AFI_AXI_BAR3_START_0_AXI_BAR3_START_SHIFT)
#define AFI_AXI_BAR3_START_0_AXI_BAR3_START_RANGE                       31:12
#define AFI_AXI_BAR3_START_0_AXI_BAR3_START_WOFFSET                     0x0
#define AFI_AXI_BAR3_START_0_AXI_BAR3_START_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR3_START_0_AXI_BAR3_START_DEFAULT_MASK                        _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR3_START_0_AXI_BAR3_START_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR3_START_0_AXI_BAR3_START_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register AFI_AXI_BAR4_START_0  
#define AFI_AXI_BAR4_START_0                    _MK_ADDR_CONST(0x28)
#define AFI_AXI_BAR4_START_0_SECURE                     0x0
#define AFI_AXI_BAR4_START_0_WORD_COUNT                         0x1
#define AFI_AXI_BAR4_START_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR4_START_0_RESET_MASK                         _MK_MASK_CONST(0xfffff000)
#define AFI_AXI_BAR4_START_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR4_START_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR4_START_0_READ_MASK                  _MK_MASK_CONST(0xfffff000)
#define AFI_AXI_BAR4_START_0_WRITE_MASK                         _MK_MASK_CONST(0xfffff000)
//The start of AXI address space for BARi.  
//The AXI target address is compared to start/size for each BAR 
//to determine if the access is to that BAR.
#define AFI_AXI_BAR4_START_0_AXI_BAR4_START_SHIFT                       _MK_SHIFT_CONST(12)
#define AFI_AXI_BAR4_START_0_AXI_BAR4_START_FIELD                       (_MK_MASK_CONST(0xfffff) << AFI_AXI_BAR4_START_0_AXI_BAR4_START_SHIFT)
#define AFI_AXI_BAR4_START_0_AXI_BAR4_START_RANGE                       31:12
#define AFI_AXI_BAR4_START_0_AXI_BAR4_START_WOFFSET                     0x0
#define AFI_AXI_BAR4_START_0_AXI_BAR4_START_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR4_START_0_AXI_BAR4_START_DEFAULT_MASK                        _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR4_START_0_AXI_BAR4_START_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR4_START_0_AXI_BAR4_START_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register AFI_AXI_BAR5_START_0  
#define AFI_AXI_BAR5_START_0                    _MK_ADDR_CONST(0x2c)
#define AFI_AXI_BAR5_START_0_SECURE                     0x0
#define AFI_AXI_BAR5_START_0_WORD_COUNT                         0x1
#define AFI_AXI_BAR5_START_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR5_START_0_RESET_MASK                         _MK_MASK_CONST(0xfffff000)
#define AFI_AXI_BAR5_START_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR5_START_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR5_START_0_READ_MASK                  _MK_MASK_CONST(0xfffff000)
#define AFI_AXI_BAR5_START_0_WRITE_MASK                         _MK_MASK_CONST(0xfffff000)
//The start of AXI address space for BARi.  
//The AXI target address is compared to start/size for each BAR 
//to determine if the access is to that BAR.
#define AFI_AXI_BAR5_START_0_AXI_BAR5_START_SHIFT                       _MK_SHIFT_CONST(12)
#define AFI_AXI_BAR5_START_0_AXI_BAR5_START_FIELD                       (_MK_MASK_CONST(0xfffff) << AFI_AXI_BAR5_START_0_AXI_BAR5_START_SHIFT)
#define AFI_AXI_BAR5_START_0_AXI_BAR5_START_RANGE                       31:12
#define AFI_AXI_BAR5_START_0_AXI_BAR5_START_WOFFSET                     0x0
#define AFI_AXI_BAR5_START_0_AXI_BAR5_START_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR5_START_0_AXI_BAR5_START_DEFAULT_MASK                        _MK_MASK_CONST(0xfffff)
#define AFI_AXI_BAR5_START_0_AXI_BAR5_START_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_AXI_BAR5_START_0_AXI_BAR5_START_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register AFI_FPCI_BAR0_0  
#define AFI_FPCI_BAR0_0                 _MK_ADDR_CONST(0x30)
#define AFI_FPCI_BAR0_0_SECURE                  0x0
#define AFI_FPCI_BAR0_0_WORD_COUNT                      0x1
#define AFI_FPCI_BAR0_0_RESET_VAL                       _MK_MASK_CONST(0x800001)
#define AFI_FPCI_BAR0_0_RESET_MASK                      _MK_MASK_CONST(0xfffffff1)
#define AFI_FPCI_BAR0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR0_0_READ_MASK                       _MK_MASK_CONST(0xfffffff1)
#define AFI_FPCI_BAR0_0_WRITE_MASK                      _MK_MASK_CONST(0xfffffff1)
//The start of FPCI address space mapped into the BARi 
//range of PCI memory space.  The 40-bit FPCI address is determined
//by a a shift left 8 of the value of this register.
#define AFI_FPCI_BAR0_0_FPCI_BAR0_START_SHIFT                   _MK_SHIFT_CONST(4)
#define AFI_FPCI_BAR0_0_FPCI_BAR0_START_FIELD                   (_MK_MASK_CONST(0xfffffff) << AFI_FPCI_BAR0_0_FPCI_BAR0_START_SHIFT)
#define AFI_FPCI_BAR0_0_FPCI_BAR0_START_RANGE                   31:4
#define AFI_FPCI_BAR0_0_FPCI_BAR0_START_WOFFSET                 0x0
#define AFI_FPCI_BAR0_0_FPCI_BAR0_START_DEFAULT                 _MK_MASK_CONST(0x80000)
#define AFI_FPCI_BAR0_0_FPCI_BAR0_START_DEFAULT_MASK                    _MK_MASK_CONST(0xfffffff)
#define AFI_FPCI_BAR0_0_FPCI_BAR0_START_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR0_0_FPCI_BAR0_START_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Indicates if the address region is memory
//mapped versus configuration or IO space.
//1=memory mapped access (PW only)
//0=IO/config access (NWP only)
#define AFI_FPCI_BAR0_0_FPCI_BAR0_ACCESS_TYPE_SHIFT                     _MK_SHIFT_CONST(0)
#define AFI_FPCI_BAR0_0_FPCI_BAR0_ACCESS_TYPE_FIELD                     (_MK_MASK_CONST(0x1) << AFI_FPCI_BAR0_0_FPCI_BAR0_ACCESS_TYPE_SHIFT)
#define AFI_FPCI_BAR0_0_FPCI_BAR0_ACCESS_TYPE_RANGE                     0:0
#define AFI_FPCI_BAR0_0_FPCI_BAR0_ACCESS_TYPE_WOFFSET                   0x0
#define AFI_FPCI_BAR0_0_FPCI_BAR0_ACCESS_TYPE_DEFAULT                   _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR0_0_FPCI_BAR0_ACCESS_TYPE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR0_0_FPCI_BAR0_ACCESS_TYPE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR0_0_FPCI_BAR0_ACCESS_TYPE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register AFI_FPCI_BAR1_0  
#define AFI_FPCI_BAR1_0                 _MK_ADDR_CONST(0x34)
#define AFI_FPCI_BAR1_0_SECURE                  0x0
#define AFI_FPCI_BAR1_0_WORD_COUNT                      0x1
#define AFI_FPCI_BAR1_0_RESET_VAL                       _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR1_0_RESET_MASK                      _MK_MASK_CONST(0xfffffff1)
#define AFI_FPCI_BAR1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR1_0_READ_MASK                       _MK_MASK_CONST(0xfffffff1)
#define AFI_FPCI_BAR1_0_WRITE_MASK                      _MK_MASK_CONST(0xfffffff1)
//The start of FPCI address space mapped into the BARi 
//range of PCI memory space.  The 40-bit FPCI address is determined
//by a a shift left 8 of the value of this register.
#define AFI_FPCI_BAR1_0_FPCI_BAR1_START_SHIFT                   _MK_SHIFT_CONST(4)
#define AFI_FPCI_BAR1_0_FPCI_BAR1_START_FIELD                   (_MK_MASK_CONST(0xfffffff) << AFI_FPCI_BAR1_0_FPCI_BAR1_START_SHIFT)
#define AFI_FPCI_BAR1_0_FPCI_BAR1_START_RANGE                   31:4
#define AFI_FPCI_BAR1_0_FPCI_BAR1_START_WOFFSET                 0x0
#define AFI_FPCI_BAR1_0_FPCI_BAR1_START_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR1_0_FPCI_BAR1_START_DEFAULT_MASK                    _MK_MASK_CONST(0xfffffff)
#define AFI_FPCI_BAR1_0_FPCI_BAR1_START_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR1_0_FPCI_BAR1_START_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Indicates if the address region is memory
//mapped versus configuration or IO space.
//1=memory mapped access (PW only)
//0=IO/config access (NWP only)
#define AFI_FPCI_BAR1_0_FPCI_BAR1_ACCESS_TYPE_SHIFT                     _MK_SHIFT_CONST(0)
#define AFI_FPCI_BAR1_0_FPCI_BAR1_ACCESS_TYPE_FIELD                     (_MK_MASK_CONST(0x1) << AFI_FPCI_BAR1_0_FPCI_BAR1_ACCESS_TYPE_SHIFT)
#define AFI_FPCI_BAR1_0_FPCI_BAR1_ACCESS_TYPE_RANGE                     0:0
#define AFI_FPCI_BAR1_0_FPCI_BAR1_ACCESS_TYPE_WOFFSET                   0x0
#define AFI_FPCI_BAR1_0_FPCI_BAR1_ACCESS_TYPE_DEFAULT                   _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR1_0_FPCI_BAR1_ACCESS_TYPE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR1_0_FPCI_BAR1_ACCESS_TYPE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR1_0_FPCI_BAR1_ACCESS_TYPE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register AFI_FPCI_BAR2_0  
#define AFI_FPCI_BAR2_0                 _MK_ADDR_CONST(0x38)
#define AFI_FPCI_BAR2_0_SECURE                  0x0
#define AFI_FPCI_BAR2_0_WORD_COUNT                      0x1
#define AFI_FPCI_BAR2_0_RESET_VAL                       _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR2_0_RESET_MASK                      _MK_MASK_CONST(0xfffffff1)
#define AFI_FPCI_BAR2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR2_0_READ_MASK                       _MK_MASK_CONST(0xfffffff1)
#define AFI_FPCI_BAR2_0_WRITE_MASK                      _MK_MASK_CONST(0xfffffff1)
//The start of FPCI address space mapped into the BARi 
//range of PCI memory space.  The 40-bit FPCI address is determined
//by a a shift left 8 of the value of this register.
#define AFI_FPCI_BAR2_0_FPCI_BAR2_START_SHIFT                   _MK_SHIFT_CONST(4)
#define AFI_FPCI_BAR2_0_FPCI_BAR2_START_FIELD                   (_MK_MASK_CONST(0xfffffff) << AFI_FPCI_BAR2_0_FPCI_BAR2_START_SHIFT)
#define AFI_FPCI_BAR2_0_FPCI_BAR2_START_RANGE                   31:4
#define AFI_FPCI_BAR2_0_FPCI_BAR2_START_WOFFSET                 0x0
#define AFI_FPCI_BAR2_0_FPCI_BAR2_START_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR2_0_FPCI_BAR2_START_DEFAULT_MASK                    _MK_MASK_CONST(0xfffffff)
#define AFI_FPCI_BAR2_0_FPCI_BAR2_START_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR2_0_FPCI_BAR2_START_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Indicates if the address region is memory
//mapped versus configuration or IO space.
//1=memory mapped access (PW only)
//0=IO/config access (NWP only)
#define AFI_FPCI_BAR2_0_FPCI_BAR2_ACCESS_TYPE_SHIFT                     _MK_SHIFT_CONST(0)
#define AFI_FPCI_BAR2_0_FPCI_BAR2_ACCESS_TYPE_FIELD                     (_MK_MASK_CONST(0x1) << AFI_FPCI_BAR2_0_FPCI_BAR2_ACCESS_TYPE_SHIFT)
#define AFI_FPCI_BAR2_0_FPCI_BAR2_ACCESS_TYPE_RANGE                     0:0
#define AFI_FPCI_BAR2_0_FPCI_BAR2_ACCESS_TYPE_WOFFSET                   0x0
#define AFI_FPCI_BAR2_0_FPCI_BAR2_ACCESS_TYPE_DEFAULT                   _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR2_0_FPCI_BAR2_ACCESS_TYPE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR2_0_FPCI_BAR2_ACCESS_TYPE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR2_0_FPCI_BAR2_ACCESS_TYPE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register AFI_FPCI_BAR3_0  
#define AFI_FPCI_BAR3_0                 _MK_ADDR_CONST(0x3c)
#define AFI_FPCI_BAR3_0_SECURE                  0x0
#define AFI_FPCI_BAR3_0_WORD_COUNT                      0x1
#define AFI_FPCI_BAR3_0_RESET_VAL                       _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR3_0_RESET_MASK                      _MK_MASK_CONST(0xfffffff1)
#define AFI_FPCI_BAR3_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR3_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR3_0_READ_MASK                       _MK_MASK_CONST(0xfffffff1)
#define AFI_FPCI_BAR3_0_WRITE_MASK                      _MK_MASK_CONST(0xfffffff1)
//The start of FPCI address space mapped into the BARi 
//range of PCI memory space.  The 40-bit FPCI address is determined
//by a a shift left 8 of the value of this register.
#define AFI_FPCI_BAR3_0_FPCI_BAR3_START_SHIFT                   _MK_SHIFT_CONST(4)
#define AFI_FPCI_BAR3_0_FPCI_BAR3_START_FIELD                   (_MK_MASK_CONST(0xfffffff) << AFI_FPCI_BAR3_0_FPCI_BAR3_START_SHIFT)
#define AFI_FPCI_BAR3_0_FPCI_BAR3_START_RANGE                   31:4
#define AFI_FPCI_BAR3_0_FPCI_BAR3_START_WOFFSET                 0x0
#define AFI_FPCI_BAR3_0_FPCI_BAR3_START_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR3_0_FPCI_BAR3_START_DEFAULT_MASK                    _MK_MASK_CONST(0xfffffff)
#define AFI_FPCI_BAR3_0_FPCI_BAR3_START_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR3_0_FPCI_BAR3_START_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Indicates if the address region is memory
//mapped versus configuration or IO space.
//1=memory mapped access (PW only)
//0=IO/config access (NWP only)
#define AFI_FPCI_BAR3_0_FPCI_BAR3_ACCESS_TYPE_SHIFT                     _MK_SHIFT_CONST(0)
#define AFI_FPCI_BAR3_0_FPCI_BAR3_ACCESS_TYPE_FIELD                     (_MK_MASK_CONST(0x1) << AFI_FPCI_BAR3_0_FPCI_BAR3_ACCESS_TYPE_SHIFT)
#define AFI_FPCI_BAR3_0_FPCI_BAR3_ACCESS_TYPE_RANGE                     0:0
#define AFI_FPCI_BAR3_0_FPCI_BAR3_ACCESS_TYPE_WOFFSET                   0x0
#define AFI_FPCI_BAR3_0_FPCI_BAR3_ACCESS_TYPE_DEFAULT                   _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR3_0_FPCI_BAR3_ACCESS_TYPE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR3_0_FPCI_BAR3_ACCESS_TYPE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR3_0_FPCI_BAR3_ACCESS_TYPE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register AFI_FPCI_BAR4_0  
#define AFI_FPCI_BAR4_0                 _MK_ADDR_CONST(0x40)
#define AFI_FPCI_BAR4_0_SECURE                  0x0
#define AFI_FPCI_BAR4_0_WORD_COUNT                      0x1
#define AFI_FPCI_BAR4_0_RESET_VAL                       _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR4_0_RESET_MASK                      _MK_MASK_CONST(0xfffffff1)
#define AFI_FPCI_BAR4_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR4_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR4_0_READ_MASK                       _MK_MASK_CONST(0xfffffff1)
#define AFI_FPCI_BAR4_0_WRITE_MASK                      _MK_MASK_CONST(0xfffffff1)
//The start of FPCI address space mapped into the BARi 
//range of PCI memory space.  The 40-bit FPCI address is determined
//by a a shift left 8 of the value of this register.
#define AFI_FPCI_BAR4_0_FPCI_BAR4_START_SHIFT                   _MK_SHIFT_CONST(4)
#define AFI_FPCI_BAR4_0_FPCI_BAR4_START_FIELD                   (_MK_MASK_CONST(0xfffffff) << AFI_FPCI_BAR4_0_FPCI_BAR4_START_SHIFT)
#define AFI_FPCI_BAR4_0_FPCI_BAR4_START_RANGE                   31:4
#define AFI_FPCI_BAR4_0_FPCI_BAR4_START_WOFFSET                 0x0
#define AFI_FPCI_BAR4_0_FPCI_BAR4_START_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR4_0_FPCI_BAR4_START_DEFAULT_MASK                    _MK_MASK_CONST(0xfffffff)
#define AFI_FPCI_BAR4_0_FPCI_BAR4_START_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR4_0_FPCI_BAR4_START_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Indicates if the address region is memory
//mapped versus configuration or IO space.
//1=memory mapped access (PW only)
//0=IO/config access (NWP only)
#define AFI_FPCI_BAR4_0_FPCI_BAR4_ACCESS_TYPE_SHIFT                     _MK_SHIFT_CONST(0)
#define AFI_FPCI_BAR4_0_FPCI_BAR4_ACCESS_TYPE_FIELD                     (_MK_MASK_CONST(0x1) << AFI_FPCI_BAR4_0_FPCI_BAR4_ACCESS_TYPE_SHIFT)
#define AFI_FPCI_BAR4_0_FPCI_BAR4_ACCESS_TYPE_RANGE                     0:0
#define AFI_FPCI_BAR4_0_FPCI_BAR4_ACCESS_TYPE_WOFFSET                   0x0
#define AFI_FPCI_BAR4_0_FPCI_BAR4_ACCESS_TYPE_DEFAULT                   _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR4_0_FPCI_BAR4_ACCESS_TYPE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR4_0_FPCI_BAR4_ACCESS_TYPE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR4_0_FPCI_BAR4_ACCESS_TYPE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register AFI_FPCI_BAR5_0  
#define AFI_FPCI_BAR5_0                 _MK_ADDR_CONST(0x44)
#define AFI_FPCI_BAR5_0_SECURE                  0x0
#define AFI_FPCI_BAR5_0_WORD_COUNT                      0x1
#define AFI_FPCI_BAR5_0_RESET_VAL                       _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR5_0_RESET_MASK                      _MK_MASK_CONST(0xfffffff1)
#define AFI_FPCI_BAR5_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR5_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR5_0_READ_MASK                       _MK_MASK_CONST(0xfffffff1)
#define AFI_FPCI_BAR5_0_WRITE_MASK                      _MK_MASK_CONST(0xfffffff1)
//The start of FPCI address space mapped into the BARi 
//range of PCI memory space.  The 40-bit FPCI address is determined
//by a a shift left 8 of the value of this register.
#define AFI_FPCI_BAR5_0_FPCI_BAR5_START_SHIFT                   _MK_SHIFT_CONST(4)
#define AFI_FPCI_BAR5_0_FPCI_BAR5_START_FIELD                   (_MK_MASK_CONST(0xfffffff) << AFI_FPCI_BAR5_0_FPCI_BAR5_START_SHIFT)
#define AFI_FPCI_BAR5_0_FPCI_BAR5_START_RANGE                   31:4
#define AFI_FPCI_BAR5_0_FPCI_BAR5_START_WOFFSET                 0x0
#define AFI_FPCI_BAR5_0_FPCI_BAR5_START_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR5_0_FPCI_BAR5_START_DEFAULT_MASK                    _MK_MASK_CONST(0xfffffff)
#define AFI_FPCI_BAR5_0_FPCI_BAR5_START_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR5_0_FPCI_BAR5_START_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Indicates if the address region is memory
//mapped versus configuration or IO space.
//1=memory mapped access (PW only)
//0=IO/config access (NWP only)
#define AFI_FPCI_BAR5_0_FPCI_BAR5_ACCESS_TYPE_SHIFT                     _MK_SHIFT_CONST(0)
#define AFI_FPCI_BAR5_0_FPCI_BAR5_ACCESS_TYPE_FIELD                     (_MK_MASK_CONST(0x1) << AFI_FPCI_BAR5_0_FPCI_BAR5_ACCESS_TYPE_SHIFT)
#define AFI_FPCI_BAR5_0_FPCI_BAR5_ACCESS_TYPE_RANGE                     0:0
#define AFI_FPCI_BAR5_0_FPCI_BAR5_ACCESS_TYPE_WOFFSET                   0x0
#define AFI_FPCI_BAR5_0_FPCI_BAR5_ACCESS_TYPE_DEFAULT                   _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR5_0_FPCI_BAR5_ACCESS_TYPE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AFI_FPCI_BAR5_0_FPCI_BAR5_ACCESS_TYPE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_FPCI_BAR5_0_FPCI_BAR5_ACCESS_TYPE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register AFI_CACHE_BAR0_SZ_0  
#define AFI_CACHE_BAR0_SZ_0                     _MK_ADDR_CONST(0x48)
#define AFI_CACHE_BAR0_SZ_0_SECURE                      0x0
#define AFI_CACHE_BAR0_SZ_0_WORD_COUNT                  0x1
#define AFI_CACHE_BAR0_SZ_0_RESET_VAL                   _MK_MASK_CONST(0x40000)
#define AFI_CACHE_BAR0_SZ_0_RESET_MASK                  _MK_MASK_CONST(0xfffff)
#define AFI_CACHE_BAR0_SZ_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define AFI_CACHE_BAR0_SZ_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AFI_CACHE_BAR0_SZ_0_READ_MASK                   _MK_MASK_CONST(0xfffff)
#define AFI_CACHE_BAR0_SZ_0_WRITE_MASK                  _MK_MASK_CONST(0xfffff)
//The size of the address range associated with cache BAR is in 
//4K increments.  Value of 0 signifies BAR is not used.
#define AFI_CACHE_BAR0_SZ_0_CACHE_BAR0_SIZE_SHIFT                       _MK_SHIFT_CONST(0)
#define AFI_CACHE_BAR0_SZ_0_CACHE_BAR0_SIZE_FIELD                       (_MK_MASK_CONST(0xfffff) << AFI_CACHE_BAR0_SZ_0_CACHE_BAR0_SIZE_SHIFT)
#define AFI_CACHE_BAR0_SZ_0_CACHE_BAR0_SIZE_RANGE                       19:0
#define AFI_CACHE_BAR0_SZ_0_CACHE_BAR0_SIZE_WOFFSET                     0x0
#define AFI_CACHE_BAR0_SZ_0_CACHE_BAR0_SIZE_DEFAULT                     _MK_MASK_CONST(0x40000)
#define AFI_CACHE_BAR0_SZ_0_CACHE_BAR0_SIZE_DEFAULT_MASK                        _MK_MASK_CONST(0xfffff)
#define AFI_CACHE_BAR0_SZ_0_CACHE_BAR0_SIZE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_CACHE_BAR0_SZ_0_CACHE_BAR0_SIZE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register AFI_CACHE_BAR0_ST_0  
#define AFI_CACHE_BAR0_ST_0                     _MK_ADDR_CONST(0x4c)
#define AFI_CACHE_BAR0_ST_0_SECURE                      0x0
#define AFI_CACHE_BAR0_ST_0_WORD_COUNT                  0x1
#define AFI_CACHE_BAR0_ST_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define AFI_CACHE_BAR0_ST_0_RESET_MASK                  _MK_MASK_CONST(0xfffff000)
#define AFI_CACHE_BAR0_ST_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define AFI_CACHE_BAR0_ST_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AFI_CACHE_BAR0_ST_0_READ_MASK                   _MK_MASK_CONST(0xfffff000)
#define AFI_CACHE_BAR0_ST_0_WRITE_MASK                  _MK_MASK_CONST(0xfffff000)
//The start of AXI address space for CACHE BAR.  
//The AXI initiator address is compared to start/size 
//for CACHE BAR to determine if the access is to the BAR.
#define AFI_CACHE_BAR0_ST_0_CACHE_BAR0_START_SHIFT                      _MK_SHIFT_CONST(12)
#define AFI_CACHE_BAR0_ST_0_CACHE_BAR0_START_FIELD                      (_MK_MASK_CONST(0xfffff) << AFI_CACHE_BAR0_ST_0_CACHE_BAR0_START_SHIFT)
#define AFI_CACHE_BAR0_ST_0_CACHE_BAR0_START_RANGE                      31:12
#define AFI_CACHE_BAR0_ST_0_CACHE_BAR0_START_WOFFSET                    0x0
#define AFI_CACHE_BAR0_ST_0_CACHE_BAR0_START_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_CACHE_BAR0_ST_0_CACHE_BAR0_START_DEFAULT_MASK                       _MK_MASK_CONST(0xfffff)
#define AFI_CACHE_BAR0_ST_0_CACHE_BAR0_START_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_CACHE_BAR0_ST_0_CACHE_BAR0_START_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register AFI_CACHE_BAR1_SZ_0  
#define AFI_CACHE_BAR1_SZ_0                     _MK_ADDR_CONST(0x50)
#define AFI_CACHE_BAR1_SZ_0_SECURE                      0x0
#define AFI_CACHE_BAR1_SZ_0_WORD_COUNT                  0x1
#define AFI_CACHE_BAR1_SZ_0_RESET_VAL                   _MK_MASK_CONST(0x40000)
#define AFI_CACHE_BAR1_SZ_0_RESET_MASK                  _MK_MASK_CONST(0xfffff)
#define AFI_CACHE_BAR1_SZ_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define AFI_CACHE_BAR1_SZ_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AFI_CACHE_BAR1_SZ_0_READ_MASK                   _MK_MASK_CONST(0xfffff)
#define AFI_CACHE_BAR1_SZ_0_WRITE_MASK                  _MK_MASK_CONST(0xfffff)
//The size of the address range associated with cache BAR is in 
//4K increments.  Value of 0 signifies BAR is not used.
#define AFI_CACHE_BAR1_SZ_0_CACHE_BAR1_SIZE_SHIFT                       _MK_SHIFT_CONST(0)
#define AFI_CACHE_BAR1_SZ_0_CACHE_BAR1_SIZE_FIELD                       (_MK_MASK_CONST(0xfffff) << AFI_CACHE_BAR1_SZ_0_CACHE_BAR1_SIZE_SHIFT)
#define AFI_CACHE_BAR1_SZ_0_CACHE_BAR1_SIZE_RANGE                       19:0
#define AFI_CACHE_BAR1_SZ_0_CACHE_BAR1_SIZE_WOFFSET                     0x0
#define AFI_CACHE_BAR1_SZ_0_CACHE_BAR1_SIZE_DEFAULT                     _MK_MASK_CONST(0x40000)
#define AFI_CACHE_BAR1_SZ_0_CACHE_BAR1_SIZE_DEFAULT_MASK                        _MK_MASK_CONST(0xfffff)
#define AFI_CACHE_BAR1_SZ_0_CACHE_BAR1_SIZE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_CACHE_BAR1_SZ_0_CACHE_BAR1_SIZE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register AFI_CACHE_BAR1_ST_0  
#define AFI_CACHE_BAR1_ST_0                     _MK_ADDR_CONST(0x54)
#define AFI_CACHE_BAR1_ST_0_SECURE                      0x0
#define AFI_CACHE_BAR1_ST_0_WORD_COUNT                  0x1
#define AFI_CACHE_BAR1_ST_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define AFI_CACHE_BAR1_ST_0_RESET_MASK                  _MK_MASK_CONST(0xfffff000)
#define AFI_CACHE_BAR1_ST_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define AFI_CACHE_BAR1_ST_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AFI_CACHE_BAR1_ST_0_READ_MASK                   _MK_MASK_CONST(0xfffff000)
#define AFI_CACHE_BAR1_ST_0_WRITE_MASK                  _MK_MASK_CONST(0xfffff000)
//The start of AXI address space for CACHE BAR.  
//The AXI initiator address is compared to start/size 
//for CACHE BAR to determine if the access is to the BAR.
#define AFI_CACHE_BAR1_ST_0_CACHE_BAR1_START_SHIFT                      _MK_SHIFT_CONST(12)
#define AFI_CACHE_BAR1_ST_0_CACHE_BAR1_START_FIELD                      (_MK_MASK_CONST(0xfffff) << AFI_CACHE_BAR1_ST_0_CACHE_BAR1_START_SHIFT)
#define AFI_CACHE_BAR1_ST_0_CACHE_BAR1_START_RANGE                      31:12
#define AFI_CACHE_BAR1_ST_0_CACHE_BAR1_START_WOFFSET                    0x0
#define AFI_CACHE_BAR1_ST_0_CACHE_BAR1_START_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_CACHE_BAR1_ST_0_CACHE_BAR1_START_DEFAULT_MASK                       _MK_MASK_CONST(0xfffff)
#define AFI_CACHE_BAR1_ST_0_CACHE_BAR1_START_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_CACHE_BAR1_ST_0_CACHE_BAR1_START_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register AFI_IO_BAR_SZ_0  
#define AFI_IO_BAR_SZ_0                 _MK_ADDR_CONST(0x58)
#define AFI_IO_BAR_SZ_0_SECURE                  0x0
#define AFI_IO_BAR_SZ_0_WORD_COUNT                      0x1
#define AFI_IO_BAR_SZ_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define AFI_IO_BAR_SZ_0_RESET_MASK                      _MK_MASK_CONST(0xfffff)
#define AFI_IO_BAR_SZ_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AFI_IO_BAR_SZ_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AFI_IO_BAR_SZ_0_READ_MASK                       _MK_MASK_CONST(0xfffff)
#define AFI_IO_BAR_SZ_0_WRITE_MASK                      _MK_MASK_CONST(0xfffff)
//The size of the address range associated with IO BAR is in 
//4K increments.  Value of 0 signifies BAR is not used.
#define AFI_IO_BAR_SZ_0_IO_BAR_SIZE_SHIFT                       _MK_SHIFT_CONST(0)
#define AFI_IO_BAR_SZ_0_IO_BAR_SIZE_FIELD                       (_MK_MASK_CONST(0xfffff) << AFI_IO_BAR_SZ_0_IO_BAR_SIZE_SHIFT)
#define AFI_IO_BAR_SZ_0_IO_BAR_SIZE_RANGE                       19:0
#define AFI_IO_BAR_SZ_0_IO_BAR_SIZE_WOFFSET                     0x0
#define AFI_IO_BAR_SZ_0_IO_BAR_SIZE_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_IO_BAR_SZ_0_IO_BAR_SIZE_DEFAULT_MASK                        _MK_MASK_CONST(0xfffff)
#define AFI_IO_BAR_SZ_0_IO_BAR_SIZE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_IO_BAR_SZ_0_IO_BAR_SIZE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register AFI_IO_BAR_ST_0  
#define AFI_IO_BAR_ST_0                 _MK_ADDR_CONST(0x5c)
#define AFI_IO_BAR_ST_0_SECURE                  0x0
#define AFI_IO_BAR_ST_0_WORD_COUNT                      0x1
#define AFI_IO_BAR_ST_0_RESET_VAL                       _MK_MASK_CONST(0xfc000000)
#define AFI_IO_BAR_ST_0_RESET_MASK                      _MK_MASK_CONST(0xfffff000)
#define AFI_IO_BAR_ST_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AFI_IO_BAR_ST_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AFI_IO_BAR_ST_0_READ_MASK                       _MK_MASK_CONST(0xfffff000)
#define AFI_IO_BAR_ST_0_WRITE_MASK                      _MK_MASK_CONST(0xfffff000)
//The start of AXI address space for IO BAR.  
//The upstream FPCI address starting at 0xFD_FC00_0000 up to
//the range indicated in IO_BAR_SIZE are mapped to start/offset 
//for IO BAR.
#define AFI_IO_BAR_ST_0_IO_BAR_START_SHIFT                      _MK_SHIFT_CONST(12)
#define AFI_IO_BAR_ST_0_IO_BAR_START_FIELD                      (_MK_MASK_CONST(0xfffff) << AFI_IO_BAR_ST_0_IO_BAR_START_SHIFT)
#define AFI_IO_BAR_ST_0_IO_BAR_START_RANGE                      31:12
#define AFI_IO_BAR_ST_0_IO_BAR_START_WOFFSET                    0x0
#define AFI_IO_BAR_ST_0_IO_BAR_START_DEFAULT                    _MK_MASK_CONST(0xfc000)
#define AFI_IO_BAR_ST_0_IO_BAR_START_DEFAULT_MASK                       _MK_MASK_CONST(0xfffff)
#define AFI_IO_BAR_ST_0_IO_BAR_START_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_IO_BAR_ST_0_IO_BAR_START_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register AFI_MSI_BAR_SZ_0  
#define AFI_MSI_BAR_SZ_0                        _MK_ADDR_CONST(0x60)
#define AFI_MSI_BAR_SZ_0_SECURE                         0x0
#define AFI_MSI_BAR_SZ_0_WORD_COUNT                     0x1
#define AFI_MSI_BAR_SZ_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define AFI_MSI_BAR_SZ_0_RESET_MASK                     _MK_MASK_CONST(0xfffff)
#define AFI_MSI_BAR_SZ_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define AFI_MSI_BAR_SZ_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AFI_MSI_BAR_SZ_0_READ_MASK                      _MK_MASK_CONST(0xfffff)
#define AFI_MSI_BAR_SZ_0_WRITE_MASK                     _MK_MASK_CONST(0xfffff)
//The size of the address range associated with MSI BAR is
//in 4K increments.  Value of 0 signifies BAR is not used.
#define AFI_MSI_BAR_SZ_0_MSI_BAR_SIZE_SHIFT                     _MK_SHIFT_CONST(0)
#define AFI_MSI_BAR_SZ_0_MSI_BAR_SIZE_FIELD                     (_MK_MASK_CONST(0xfffff) << AFI_MSI_BAR_SZ_0_MSI_BAR_SIZE_SHIFT)
#define AFI_MSI_BAR_SZ_0_MSI_BAR_SIZE_RANGE                     19:0
#define AFI_MSI_BAR_SZ_0_MSI_BAR_SIZE_WOFFSET                   0x0
#define AFI_MSI_BAR_SZ_0_MSI_BAR_SIZE_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_MSI_BAR_SZ_0_MSI_BAR_SIZE_DEFAULT_MASK                      _MK_MASK_CONST(0xfffff)
#define AFI_MSI_BAR_SZ_0_MSI_BAR_SIZE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_MSI_BAR_SZ_0_MSI_BAR_SIZE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register AFI_MSI_FPCI_BAR_ST_0  
#define AFI_MSI_FPCI_BAR_ST_0                   _MK_ADDR_CONST(0x64)
#define AFI_MSI_FPCI_BAR_ST_0_SECURE                    0x0
#define AFI_MSI_FPCI_BAR_ST_0_WORD_COUNT                        0x1
#define AFI_MSI_FPCI_BAR_ST_0_RESET_VAL                         _MK_MASK_CONST(0x58540000)
#define AFI_MSI_FPCI_BAR_ST_0_RESET_MASK                        _MK_MASK_CONST(0xfffffff0)
#define AFI_MSI_FPCI_BAR_ST_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define AFI_MSI_FPCI_BAR_ST_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AFI_MSI_FPCI_BAR_ST_0_READ_MASK                         _MK_MASK_CONST(0xfffffff0)
#define AFI_MSI_FPCI_BAR_ST_0_WRITE_MASK                        _MK_MASK_CONST(0xfffffff0)
//The start of upstream FPCI address space for MSI BAR.  
//The upstream FPCI address is compared to start/1KB range
//for MSI BAR to determine if the access is MSI. Bits 31:4
//of MSI BAR start correspond to UFPCI address bits 39:12.
#define AFI_MSI_FPCI_BAR_ST_0_MSI_FPCI_BAR_START_SHIFT                  _MK_SHIFT_CONST(4)
#define AFI_MSI_FPCI_BAR_ST_0_MSI_FPCI_BAR_START_FIELD                  (_MK_MASK_CONST(0xfffffff) << AFI_MSI_FPCI_BAR_ST_0_MSI_FPCI_BAR_START_SHIFT)
#define AFI_MSI_FPCI_BAR_ST_0_MSI_FPCI_BAR_START_RANGE                  31:4
#define AFI_MSI_FPCI_BAR_ST_0_MSI_FPCI_BAR_START_WOFFSET                        0x0
#define AFI_MSI_FPCI_BAR_ST_0_MSI_FPCI_BAR_START_DEFAULT                        _MK_MASK_CONST(0x5854000)
#define AFI_MSI_FPCI_BAR_ST_0_MSI_FPCI_BAR_START_DEFAULT_MASK                   _MK_MASK_CONST(0xfffffff)
#define AFI_MSI_FPCI_BAR_ST_0_MSI_FPCI_BAR_START_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_MSI_FPCI_BAR_ST_0_MSI_FPCI_BAR_START_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register AFI_MSI_AXI_BAR_ST_0  
#define AFI_MSI_AXI_BAR_ST_0                    _MK_ADDR_CONST(0x68)
#define AFI_MSI_AXI_BAR_ST_0_SECURE                     0x0
#define AFI_MSI_AXI_BAR_ST_0_WORD_COUNT                         0x1
#define AFI_MSI_AXI_BAR_ST_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define AFI_MSI_AXI_BAR_ST_0_RESET_MASK                         _MK_MASK_CONST(0xfffff000)
#define AFI_MSI_AXI_BAR_ST_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define AFI_MSI_AXI_BAR_ST_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AFI_MSI_AXI_BAR_ST_0_READ_MASK                  _MK_MASK_CONST(0xfffff000)
#define AFI_MSI_AXI_BAR_ST_0_WRITE_MASK                         _MK_MASK_CONST(0xfffff000)
//The start of upstream AXI address space for MSI BAR.
//The upstream FPCI address is compared to start/1KB range
//for MSI BAR to determine if the access is MSI. Bits 31:12
//of MSI BAR start correspond to AXI address bits 31:12.
#define AFI_MSI_AXI_BAR_ST_0_MSI_AXI_BAR_START_SHIFT                    _MK_SHIFT_CONST(12)
#define AFI_MSI_AXI_BAR_ST_0_MSI_AXI_BAR_START_FIELD                    (_MK_MASK_CONST(0xfffff) << AFI_MSI_AXI_BAR_ST_0_MSI_AXI_BAR_START_SHIFT)
#define AFI_MSI_AXI_BAR_ST_0_MSI_AXI_BAR_START_RANGE                    31:12
#define AFI_MSI_AXI_BAR_ST_0_MSI_AXI_BAR_START_WOFFSET                  0x0
#define AFI_MSI_AXI_BAR_ST_0_MSI_AXI_BAR_START_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_MSI_AXI_BAR_ST_0_MSI_AXI_BAR_START_DEFAULT_MASK                     _MK_MASK_CONST(0xfffff)
#define AFI_MSI_AXI_BAR_ST_0_MSI_AXI_BAR_START_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_MSI_AXI_BAR_ST_0_MSI_AXI_BAR_START_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register AFI_MSI_VEC0_0  
#define AFI_MSI_VEC0_0                  _MK_ADDR_CONST(0x6c)
#define AFI_MSI_VEC0_0_SECURE                   0x0
#define AFI_MSI_VEC0_0_WORD_COUNT                       0x1
#define AFI_MSI_VEC0_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC0_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC0_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC0_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC0_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC0_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
//Each vector register corresponds to 32 of the possible 256 MSI vectors.
//VECTOR0 corresponds to MSI vectors 31-0.
//Vector7 corresponds to MSI vectors 255-223.
//When an upstream MSI is sent, the bit corresponding to the MSI vector
//is set to 1 by hardware if the corresponding enable bit is 1.
//The bit is set to 0 if a 1 is written to its location.
#define AFI_MSI_VEC0_0_MSI_VECTOR0_SHIFT                        _MK_SHIFT_CONST(0)
#define AFI_MSI_VEC0_0_MSI_VECTOR0_FIELD                        (_MK_MASK_CONST(0xffffffff) << AFI_MSI_VEC0_0_MSI_VECTOR0_SHIFT)
#define AFI_MSI_VEC0_0_MSI_VECTOR0_RANGE                        31:0
#define AFI_MSI_VEC0_0_MSI_VECTOR0_WOFFSET                      0x0
#define AFI_MSI_VEC0_0_MSI_VECTOR0_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC0_0_MSI_VECTOR0_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC0_0_MSI_VECTOR0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC0_0_MSI_VECTOR0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register AFI_MSI_VEC1_0  
#define AFI_MSI_VEC1_0                  _MK_ADDR_CONST(0x70)
#define AFI_MSI_VEC1_0_SECURE                   0x0
#define AFI_MSI_VEC1_0_WORD_COUNT                       0x1
#define AFI_MSI_VEC1_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC1_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC1_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC1_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC1_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC1_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
//Each vector register corresponds to 32 of the possible 256 MSI vectors.
//VECTOR0 corresponds to MSI vectors 31-0.
//Vector7 corresponds to MSI vectors 255-223.
//When an upstream MSI is sent, the bit corresponding to the MSI vector
//is set to 1 by hardware if the corresponding enable bit is 1.
//The bit is set to 0 if a 1 is written to its location.
#define AFI_MSI_VEC1_0_MSI_VECTOR1_SHIFT                        _MK_SHIFT_CONST(0)
#define AFI_MSI_VEC1_0_MSI_VECTOR1_FIELD                        (_MK_MASK_CONST(0xffffffff) << AFI_MSI_VEC1_0_MSI_VECTOR1_SHIFT)
#define AFI_MSI_VEC1_0_MSI_VECTOR1_RANGE                        31:0
#define AFI_MSI_VEC1_0_MSI_VECTOR1_WOFFSET                      0x0
#define AFI_MSI_VEC1_0_MSI_VECTOR1_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC1_0_MSI_VECTOR1_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC1_0_MSI_VECTOR1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC1_0_MSI_VECTOR1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register AFI_MSI_VEC2_0  
#define AFI_MSI_VEC2_0                  _MK_ADDR_CONST(0x74)
#define AFI_MSI_VEC2_0_SECURE                   0x0
#define AFI_MSI_VEC2_0_WORD_COUNT                       0x1
#define AFI_MSI_VEC2_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC2_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC2_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC2_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC2_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC2_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
//Each vector register corresponds to 32 of the possible 256 MSI vectors.
//VECTOR0 corresponds to MSI vectors 31-0.
//Vector7 corresponds to MSI vectors 255-223.
//When an upstream MSI is sent, the bit corresponding to the MSI vector
//is set to 1 by hardware if the corresponding enable bit is 1.
//The bit is set to 0 if a 1 is written to its location.
#define AFI_MSI_VEC2_0_MSI_VECTOR2_SHIFT                        _MK_SHIFT_CONST(0)
#define AFI_MSI_VEC2_0_MSI_VECTOR2_FIELD                        (_MK_MASK_CONST(0xffffffff) << AFI_MSI_VEC2_0_MSI_VECTOR2_SHIFT)
#define AFI_MSI_VEC2_0_MSI_VECTOR2_RANGE                        31:0
#define AFI_MSI_VEC2_0_MSI_VECTOR2_WOFFSET                      0x0
#define AFI_MSI_VEC2_0_MSI_VECTOR2_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC2_0_MSI_VECTOR2_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC2_0_MSI_VECTOR2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC2_0_MSI_VECTOR2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register AFI_MSI_VEC3_0  
#define AFI_MSI_VEC3_0                  _MK_ADDR_CONST(0x78)
#define AFI_MSI_VEC3_0_SECURE                   0x0
#define AFI_MSI_VEC3_0_WORD_COUNT                       0x1
#define AFI_MSI_VEC3_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC3_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC3_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC3_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC3_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC3_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
//Each vector register corresponds to 32 of the possible 256 MSI vectors.
//VECTOR0 corresponds to MSI vectors 31-0.
//Vector7 corresponds to MSI vectors 255-223.
//When an upstream MSI is sent, the bit corresponding to the MSI vector
//is set to 1 by hardware if the corresponding enable bit is 1.
//The bit is set to 0 if a 1 is written to its location.
#define AFI_MSI_VEC3_0_MSI_VECTOR3_SHIFT                        _MK_SHIFT_CONST(0)
#define AFI_MSI_VEC3_0_MSI_VECTOR3_FIELD                        (_MK_MASK_CONST(0xffffffff) << AFI_MSI_VEC3_0_MSI_VECTOR3_SHIFT)
#define AFI_MSI_VEC3_0_MSI_VECTOR3_RANGE                        31:0
#define AFI_MSI_VEC3_0_MSI_VECTOR3_WOFFSET                      0x0
#define AFI_MSI_VEC3_0_MSI_VECTOR3_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC3_0_MSI_VECTOR3_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC3_0_MSI_VECTOR3_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC3_0_MSI_VECTOR3_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register AFI_MSI_VEC4_0  
#define AFI_MSI_VEC4_0                  _MK_ADDR_CONST(0x7c)
#define AFI_MSI_VEC4_0_SECURE                   0x0
#define AFI_MSI_VEC4_0_WORD_COUNT                       0x1
#define AFI_MSI_VEC4_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC4_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC4_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC4_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC4_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC4_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
//Each vector register corresponds to 32 of the possible 256 MSI vectors.
//VECTOR0 corresponds to MSI vectors 31-0.
//Vector7 corresponds to MSI vectors 255-223.
//When an upstream MSI is sent, the bit corresponding to the MSI vector
//is set to 1 by hardware if the corresponding enable bit is 1.
//The bit is set to 0 if a 1 is written to its location.
#define AFI_MSI_VEC4_0_MSI_VECTOR4_SHIFT                        _MK_SHIFT_CONST(0)
#define AFI_MSI_VEC4_0_MSI_VECTOR4_FIELD                        (_MK_MASK_CONST(0xffffffff) << AFI_MSI_VEC4_0_MSI_VECTOR4_SHIFT)
#define AFI_MSI_VEC4_0_MSI_VECTOR4_RANGE                        31:0
#define AFI_MSI_VEC4_0_MSI_VECTOR4_WOFFSET                      0x0
#define AFI_MSI_VEC4_0_MSI_VECTOR4_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC4_0_MSI_VECTOR4_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC4_0_MSI_VECTOR4_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC4_0_MSI_VECTOR4_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register AFI_MSI_VEC5_0  
#define AFI_MSI_VEC5_0                  _MK_ADDR_CONST(0x80)
#define AFI_MSI_VEC5_0_SECURE                   0x0
#define AFI_MSI_VEC5_0_WORD_COUNT                       0x1
#define AFI_MSI_VEC5_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC5_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC5_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC5_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC5_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC5_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
//Each vector register corresponds to 32 of the possible 256 MSI vectors.
//VECTOR0 corresponds to MSI vectors 31-0.
//Vector7 corresponds to MSI vectors 255-223.
//When an upstream MSI is sent, the bit corresponding to the MSI vector
//is set to 1 by hardware if the corresponding enable bit is 1.
//The bit is set to 0 if a 1 is written to its location.
#define AFI_MSI_VEC5_0_MSI_VECTOR5_SHIFT                        _MK_SHIFT_CONST(0)
#define AFI_MSI_VEC5_0_MSI_VECTOR5_FIELD                        (_MK_MASK_CONST(0xffffffff) << AFI_MSI_VEC5_0_MSI_VECTOR5_SHIFT)
#define AFI_MSI_VEC5_0_MSI_VECTOR5_RANGE                        31:0
#define AFI_MSI_VEC5_0_MSI_VECTOR5_WOFFSET                      0x0
#define AFI_MSI_VEC5_0_MSI_VECTOR5_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC5_0_MSI_VECTOR5_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC5_0_MSI_VECTOR5_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC5_0_MSI_VECTOR5_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register AFI_MSI_VEC6_0  
#define AFI_MSI_VEC6_0                  _MK_ADDR_CONST(0x84)
#define AFI_MSI_VEC6_0_SECURE                   0x0
#define AFI_MSI_VEC6_0_WORD_COUNT                       0x1
#define AFI_MSI_VEC6_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC6_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC6_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC6_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC6_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC6_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
//Each vector register corresponds to 32 of the possible 256 MSI vectors.
//VECTOR0 corresponds to MSI vectors 31-0.
//Vector7 corresponds to MSI vectors 255-223.
//When an upstream MSI is sent, the bit corresponding to the MSI vector
//is set to 1 by hardware if the corresponding enable bit is 1.
//The bit is set to 0 if a 1 is written to its location.
#define AFI_MSI_VEC6_0_MSI_VECTOR6_SHIFT                        _MK_SHIFT_CONST(0)
#define AFI_MSI_VEC6_0_MSI_VECTOR6_FIELD                        (_MK_MASK_CONST(0xffffffff) << AFI_MSI_VEC6_0_MSI_VECTOR6_SHIFT)
#define AFI_MSI_VEC6_0_MSI_VECTOR6_RANGE                        31:0
#define AFI_MSI_VEC6_0_MSI_VECTOR6_WOFFSET                      0x0
#define AFI_MSI_VEC6_0_MSI_VECTOR6_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC6_0_MSI_VECTOR6_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC6_0_MSI_VECTOR6_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC6_0_MSI_VECTOR6_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register AFI_MSI_VEC7_0  
#define AFI_MSI_VEC7_0                  _MK_ADDR_CONST(0x88)
#define AFI_MSI_VEC7_0_SECURE                   0x0
#define AFI_MSI_VEC7_0_WORD_COUNT                       0x1
#define AFI_MSI_VEC7_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC7_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC7_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC7_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC7_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC7_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
//Each vector register corresponds to 32 of the possible 256 MSI vectors.
//VECTOR0 corresponds to MSI vectors 31-0.
//Vector7 corresponds to MSI vectors 255-223.
//When an upstream MSI is sent, the bit corresponding to the MSI vector
//is set to 1 by hardware if the corresponding enable bit is 1.
//The bit is set to 0 if a 1 is written to its location.
#define AFI_MSI_VEC7_0_MSI_VECTOR7_SHIFT                        _MK_SHIFT_CONST(0)
#define AFI_MSI_VEC7_0_MSI_VECTOR7_FIELD                        (_MK_MASK_CONST(0xffffffff) << AFI_MSI_VEC7_0_MSI_VECTOR7_SHIFT)
#define AFI_MSI_VEC7_0_MSI_VECTOR7_RANGE                        31:0
#define AFI_MSI_VEC7_0_MSI_VECTOR7_WOFFSET                      0x0
#define AFI_MSI_VEC7_0_MSI_VECTOR7_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC7_0_MSI_VECTOR7_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_VEC7_0_MSI_VECTOR7_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_MSI_VEC7_0_MSI_VECTOR7_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register AFI_MSI_EN_VEC0_0  
#define AFI_MSI_EN_VEC0_0                       _MK_ADDR_CONST(0x8c)
#define AFI_MSI_EN_VEC0_0_SECURE                        0x0
#define AFI_MSI_EN_VEC0_0_WORD_COUNT                    0x1
#define AFI_MSI_EN_VEC0_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC0_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC0_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC0_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC0_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC0_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
//Each vector register corresponds to the enable bit for 32
//of the possible 256 MSI vectors. ENABLE VECTOR0 corresponds
//to enable bits for MSI vectors 31-0.  Vector7 corresponds 
//to enable bits for MSI vectors 255-223.
//When an upstream MSI is sent, the bit corresponding to the
//MSI vector is set to 1 by hardware if the corresponding
//enable bit is 1.
#define AFI_MSI_EN_VEC0_0_MSI_ENABLE_VECTOR0_SHIFT                      _MK_SHIFT_CONST(0)
#define AFI_MSI_EN_VEC0_0_MSI_ENABLE_VECTOR0_FIELD                      (_MK_MASK_CONST(0xffffffff) << AFI_MSI_EN_VEC0_0_MSI_ENABLE_VECTOR0_SHIFT)
#define AFI_MSI_EN_VEC0_0_MSI_ENABLE_VECTOR0_RANGE                      31:0
#define AFI_MSI_EN_VEC0_0_MSI_ENABLE_VECTOR0_WOFFSET                    0x0
#define AFI_MSI_EN_VEC0_0_MSI_ENABLE_VECTOR0_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC0_0_MSI_ENABLE_VECTOR0_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC0_0_MSI_ENABLE_VECTOR0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC0_0_MSI_ENABLE_VECTOR0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register AFI_MSI_EN_VEC1_0  
#define AFI_MSI_EN_VEC1_0                       _MK_ADDR_CONST(0x90)
#define AFI_MSI_EN_VEC1_0_SECURE                        0x0
#define AFI_MSI_EN_VEC1_0_WORD_COUNT                    0x1
#define AFI_MSI_EN_VEC1_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC1_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC1_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC1_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC1_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC1_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
//Each vector register corresponds to the enable bit for 32
//of the possible 256 MSI vectors. ENABLE VECTOR0 corresponds
//to enable bits for MSI vectors 31-0.  Vector7 corresponds 
//to enable bits for MSI vectors 255-223.
//When an upstream MSI is sent, the bit corresponding to the
//MSI vector is set to 1 by hardware if the corresponding
//enable bit is 1.
#define AFI_MSI_EN_VEC1_0_MSI_ENABLE_VECTOR1_SHIFT                      _MK_SHIFT_CONST(0)
#define AFI_MSI_EN_VEC1_0_MSI_ENABLE_VECTOR1_FIELD                      (_MK_MASK_CONST(0xffffffff) << AFI_MSI_EN_VEC1_0_MSI_ENABLE_VECTOR1_SHIFT)
#define AFI_MSI_EN_VEC1_0_MSI_ENABLE_VECTOR1_RANGE                      31:0
#define AFI_MSI_EN_VEC1_0_MSI_ENABLE_VECTOR1_WOFFSET                    0x0
#define AFI_MSI_EN_VEC1_0_MSI_ENABLE_VECTOR1_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC1_0_MSI_ENABLE_VECTOR1_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC1_0_MSI_ENABLE_VECTOR1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC1_0_MSI_ENABLE_VECTOR1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register AFI_MSI_EN_VEC2_0  
#define AFI_MSI_EN_VEC2_0                       _MK_ADDR_CONST(0x94)
#define AFI_MSI_EN_VEC2_0_SECURE                        0x0
#define AFI_MSI_EN_VEC2_0_WORD_COUNT                    0x1
#define AFI_MSI_EN_VEC2_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC2_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC2_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC2_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC2_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC2_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
//Each vector register corresponds to the enable bit for 32
//of the possible 256 MSI vectors. ENABLE VECTOR0 corresponds
//to enable bits for MSI vectors 31-0.  Vector7 corresponds 
//to enable bits for MSI vectors 255-223.
//When an upstream MSI is sent, the bit corresponding to the
//MSI vector is set to 1 by hardware if the corresponding
//enable bit is 1.
#define AFI_MSI_EN_VEC2_0_MSI_ENABLE_VECTOR2_SHIFT                      _MK_SHIFT_CONST(0)
#define AFI_MSI_EN_VEC2_0_MSI_ENABLE_VECTOR2_FIELD                      (_MK_MASK_CONST(0xffffffff) << AFI_MSI_EN_VEC2_0_MSI_ENABLE_VECTOR2_SHIFT)
#define AFI_MSI_EN_VEC2_0_MSI_ENABLE_VECTOR2_RANGE                      31:0
#define AFI_MSI_EN_VEC2_0_MSI_ENABLE_VECTOR2_WOFFSET                    0x0
#define AFI_MSI_EN_VEC2_0_MSI_ENABLE_VECTOR2_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC2_0_MSI_ENABLE_VECTOR2_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC2_0_MSI_ENABLE_VECTOR2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC2_0_MSI_ENABLE_VECTOR2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register AFI_MSI_EN_VEC3_0  
#define AFI_MSI_EN_VEC3_0                       _MK_ADDR_CONST(0x98)
#define AFI_MSI_EN_VEC3_0_SECURE                        0x0
#define AFI_MSI_EN_VEC3_0_WORD_COUNT                    0x1
#define AFI_MSI_EN_VEC3_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC3_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC3_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC3_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC3_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC3_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
//Each vector register corresponds to the enable bit for 32
//of the possible 256 MSI vectors. ENABLE VECTOR0 corresponds
//to enable bits for MSI vectors 31-0.  Vector7 corresponds 
//to enable bits for MSI vectors 255-223.
//When an upstream MSI is sent, the bit corresponding to the
//MSI vector is set to 1 by hardware if the corresponding
//enable bit is 1.
#define AFI_MSI_EN_VEC3_0_MSI_ENABLE_VECTOR3_SHIFT                      _MK_SHIFT_CONST(0)
#define AFI_MSI_EN_VEC3_0_MSI_ENABLE_VECTOR3_FIELD                      (_MK_MASK_CONST(0xffffffff) << AFI_MSI_EN_VEC3_0_MSI_ENABLE_VECTOR3_SHIFT)
#define AFI_MSI_EN_VEC3_0_MSI_ENABLE_VECTOR3_RANGE                      31:0
#define AFI_MSI_EN_VEC3_0_MSI_ENABLE_VECTOR3_WOFFSET                    0x0
#define AFI_MSI_EN_VEC3_0_MSI_ENABLE_VECTOR3_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC3_0_MSI_ENABLE_VECTOR3_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC3_0_MSI_ENABLE_VECTOR3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC3_0_MSI_ENABLE_VECTOR3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register AFI_MSI_EN_VEC4_0  
#define AFI_MSI_EN_VEC4_0                       _MK_ADDR_CONST(0x9c)
#define AFI_MSI_EN_VEC4_0_SECURE                        0x0
#define AFI_MSI_EN_VEC4_0_WORD_COUNT                    0x1
#define AFI_MSI_EN_VEC4_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC4_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC4_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC4_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC4_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC4_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
//Each vector register corresponds to the enable bit for 32
//of the possible 256 MSI vectors. ENABLE VECTOR0 corresponds
//to enable bits for MSI vectors 31-0.  Vector7 corresponds 
//to enable bits for MSI vectors 255-223.
//When an upstream MSI is sent, the bit corresponding to the
//MSI vector is set to 1 by hardware if the corresponding
//enable bit is 1.
#define AFI_MSI_EN_VEC4_0_MSI_ENABLE_VECTOR4_SHIFT                      _MK_SHIFT_CONST(0)
#define AFI_MSI_EN_VEC4_0_MSI_ENABLE_VECTOR4_FIELD                      (_MK_MASK_CONST(0xffffffff) << AFI_MSI_EN_VEC4_0_MSI_ENABLE_VECTOR4_SHIFT)
#define AFI_MSI_EN_VEC4_0_MSI_ENABLE_VECTOR4_RANGE                      31:0
#define AFI_MSI_EN_VEC4_0_MSI_ENABLE_VECTOR4_WOFFSET                    0x0
#define AFI_MSI_EN_VEC4_0_MSI_ENABLE_VECTOR4_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC4_0_MSI_ENABLE_VECTOR4_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC4_0_MSI_ENABLE_VECTOR4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC4_0_MSI_ENABLE_VECTOR4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register AFI_MSI_EN_VEC5_0  
#define AFI_MSI_EN_VEC5_0                       _MK_ADDR_CONST(0xa0)
#define AFI_MSI_EN_VEC5_0_SECURE                        0x0
#define AFI_MSI_EN_VEC5_0_WORD_COUNT                    0x1
#define AFI_MSI_EN_VEC5_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC5_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC5_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC5_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC5_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC5_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
//Each vector register corresponds to the enable bit for 32
//of the possible 256 MSI vectors. ENABLE VECTOR0 corresponds
//to enable bits for MSI vectors 31-0.  Vector7 corresponds 
//to enable bits for MSI vectors 255-223.
//When an upstream MSI is sent, the bit corresponding to the
//MSI vector is set to 1 by hardware if the corresponding
//enable bit is 1.
#define AFI_MSI_EN_VEC5_0_MSI_ENABLE_VECTOR5_SHIFT                      _MK_SHIFT_CONST(0)
#define AFI_MSI_EN_VEC5_0_MSI_ENABLE_VECTOR5_FIELD                      (_MK_MASK_CONST(0xffffffff) << AFI_MSI_EN_VEC5_0_MSI_ENABLE_VECTOR5_SHIFT)
#define AFI_MSI_EN_VEC5_0_MSI_ENABLE_VECTOR5_RANGE                      31:0
#define AFI_MSI_EN_VEC5_0_MSI_ENABLE_VECTOR5_WOFFSET                    0x0
#define AFI_MSI_EN_VEC5_0_MSI_ENABLE_VECTOR5_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC5_0_MSI_ENABLE_VECTOR5_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC5_0_MSI_ENABLE_VECTOR5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC5_0_MSI_ENABLE_VECTOR5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register AFI_MSI_EN_VEC6_0  
#define AFI_MSI_EN_VEC6_0                       _MK_ADDR_CONST(0xa4)
#define AFI_MSI_EN_VEC6_0_SECURE                        0x0
#define AFI_MSI_EN_VEC6_0_WORD_COUNT                    0x1
#define AFI_MSI_EN_VEC6_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC6_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC6_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC6_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC6_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC6_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
//Each vector register corresponds to the enable bit for 32
//of the possible 256 MSI vectors. ENABLE VECTOR0 corresponds
//to enable bits for MSI vectors 31-0.  Vector7 corresponds 
//to enable bits for MSI vectors 255-223.
//When an upstream MSI is sent, the bit corresponding to the
//MSI vector is set to 1 by hardware if the corresponding
//enable bit is 1.
#define AFI_MSI_EN_VEC6_0_MSI_ENABLE_VECTOR6_SHIFT                      _MK_SHIFT_CONST(0)
#define AFI_MSI_EN_VEC6_0_MSI_ENABLE_VECTOR6_FIELD                      (_MK_MASK_CONST(0xffffffff) << AFI_MSI_EN_VEC6_0_MSI_ENABLE_VECTOR6_SHIFT)
#define AFI_MSI_EN_VEC6_0_MSI_ENABLE_VECTOR6_RANGE                      31:0
#define AFI_MSI_EN_VEC6_0_MSI_ENABLE_VECTOR6_WOFFSET                    0x0
#define AFI_MSI_EN_VEC6_0_MSI_ENABLE_VECTOR6_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC6_0_MSI_ENABLE_VECTOR6_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC6_0_MSI_ENABLE_VECTOR6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC6_0_MSI_ENABLE_VECTOR6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register AFI_MSI_EN_VEC7_0  
#define AFI_MSI_EN_VEC7_0                       _MK_ADDR_CONST(0xa8)
#define AFI_MSI_EN_VEC7_0_SECURE                        0x0
#define AFI_MSI_EN_VEC7_0_WORD_COUNT                    0x1
#define AFI_MSI_EN_VEC7_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC7_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC7_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC7_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC7_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC7_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
//Each vector register corresponds to the enable bit for 32
//of the possible 256 MSI vectors. ENABLE VECTOR0 corresponds
//to enable bits for MSI vectors 31-0.  Vector7 corresponds 
//to enable bits for MSI vectors 255-223.
//When an upstream MSI is sent, the bit corresponding to the
//MSI vector is set to 1 by hardware if the corresponding
//enable bit is 1.
#define AFI_MSI_EN_VEC7_0_MSI_ENABLE_VECTOR7_SHIFT                      _MK_SHIFT_CONST(0)
#define AFI_MSI_EN_VEC7_0_MSI_ENABLE_VECTOR7_FIELD                      (_MK_MASK_CONST(0xffffffff) << AFI_MSI_EN_VEC7_0_MSI_ENABLE_VECTOR7_SHIFT)
#define AFI_MSI_EN_VEC7_0_MSI_ENABLE_VECTOR7_RANGE                      31:0
#define AFI_MSI_EN_VEC7_0_MSI_ENABLE_VECTOR7_WOFFSET                    0x0
#define AFI_MSI_EN_VEC7_0_MSI_ENABLE_VECTOR7_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC7_0_MSI_ENABLE_VECTOR7_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define AFI_MSI_EN_VEC7_0_MSI_ENABLE_VECTOR7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_MSI_EN_VEC7_0_MSI_ENABLE_VECTOR7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register AFI_CONFIGURATION_0  
#define AFI_CONFIGURATION_0                     _MK_ADDR_CONST(0xac)
#define AFI_CONFIGURATION_0_SECURE                      0x0
#define AFI_CONFIGURATION_0_WORD_COUNT                  0x1
#define AFI_CONFIGURATION_0_RESET_VAL                   _MK_MASK_CONST(0x8e04)
#define AFI_CONFIGURATION_0_RESET_MASK                  _MK_MASK_CONST(0xff3f)
#define AFI_CONFIGURATION_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_READ_MASK                   _MK_MASK_CONST(0xff3f)
#define AFI_CONFIGURATION_0_WRITE_MASK                  _MK_MASK_CONST(0xc03f)
//When the PCI device block is disabled, it is completely invisible
//on the PCI bus, i.e. it doesn't even process PCI configuration accesses.
#define AFI_CONFIGURATION_0_EN_FPCI_SHIFT                       _MK_SHIFT_CONST(0)
#define AFI_CONFIGURATION_0_EN_FPCI_FIELD                       (_MK_MASK_CONST(0x1) << AFI_CONFIGURATION_0_EN_FPCI_SHIFT)
#define AFI_CONFIGURATION_0_EN_FPCI_RANGE                       0:0
#define AFI_CONFIGURATION_0_EN_FPCI_WOFFSET                     0x0
#define AFI_CONFIGURATION_0_EN_FPCI_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_EN_FPCI_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_EN_FPCI_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_EN_FPCI_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//CYA - input to downstream FPCI.
//Allow downstream FPCI reads to pass writes.
#define AFI_CONFIGURATION_0_DFPCI_PASSPW_SHIFT                  _MK_SHIFT_CONST(1)
#define AFI_CONFIGURATION_0_DFPCI_PASSPW_FIELD                  (_MK_MASK_CONST(0x1) << AFI_CONFIGURATION_0_DFPCI_PASSPW_SHIFT)
#define AFI_CONFIGURATION_0_DFPCI_PASSPW_RANGE                  1:1
#define AFI_CONFIGURATION_0_DFPCI_PASSPW_WOFFSET                        0x0
#define AFI_CONFIGURATION_0_DFPCI_PASSPW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_DFPCI_PASSPW_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_DFPCI_PASSPW_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_DFPCI_PASSPW_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//CYA - input to downstream FPCI.
//Allow downstream FPCI responses to pass writes
#define AFI_CONFIGURATION_0_DFPCI_RSPPASSPW_SHIFT                       _MK_SHIFT_CONST(2)
#define AFI_CONFIGURATION_0_DFPCI_RSPPASSPW_FIELD                       (_MK_MASK_CONST(0x1) << AFI_CONFIGURATION_0_DFPCI_RSPPASSPW_SHIFT)
#define AFI_CONFIGURATION_0_DFPCI_RSPPASSPW_RANGE                       2:2
#define AFI_CONFIGURATION_0_DFPCI_RSPPASSPW_WOFFSET                     0x0
#define AFI_CONFIGURATION_0_DFPCI_RSPPASSPW_DEFAULT                     _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_DFPCI_RSPPASSPW_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_DFPCI_RSPPASSPW_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_DFPCI_RSPPASSPW_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//CYA - used for downstream FPCI.
//Allow downstream FPCI PWs to pass NPWs.
#define AFI_CONFIGURATION_0_DFPCI_PWPASSNPW_SHIFT                       _MK_SHIFT_CONST(3)
#define AFI_CONFIGURATION_0_DFPCI_PWPASSNPW_FIELD                       (_MK_MASK_CONST(0x1) << AFI_CONFIGURATION_0_DFPCI_PWPASSNPW_SHIFT)
#define AFI_CONFIGURATION_0_DFPCI_PWPASSNPW_RANGE                       3:3
#define AFI_CONFIGURATION_0_DFPCI_PWPASSNPW_WOFFSET                     0x0
#define AFI_CONFIGURATION_0_DFPCI_PWPASSNPW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_DFPCI_PWPASSNPW_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_DFPCI_PWPASSNPW_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_DFPCI_PWPASSNPW_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//CYA - used for upstream FPCI.
//Allow upstream FPCI PWs to pass NPWs.
#define AFI_CONFIGURATION_0_UFPCI_PWPASSNPW_SHIFT                       _MK_SHIFT_CONST(4)
#define AFI_CONFIGURATION_0_UFPCI_PWPASSNPW_FIELD                       (_MK_MASK_CONST(0x1) << AFI_CONFIGURATION_0_UFPCI_PWPASSNPW_SHIFT)
#define AFI_CONFIGURATION_0_UFPCI_PWPASSNPW_RANGE                       4:4
#define AFI_CONFIGURATION_0_UFPCI_PWPASSNPW_WOFFSET                     0x0
#define AFI_CONFIGURATION_0_UFPCI_PWPASSNPW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_UFPCI_PWPASSNPW_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_UFPCI_PWPASSNPW_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_UFPCI_PWPASSNPW_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//CYA - input to upstream FPCI.
//Allow upstream FPCI reads to pass writes.
#define AFI_CONFIGURATION_0_UFPCI_PASSPW_SHIFT                  _MK_SHIFT_CONST(5)
#define AFI_CONFIGURATION_0_UFPCI_PASSPW_FIELD                  (_MK_MASK_CONST(0x1) << AFI_CONFIGURATION_0_UFPCI_PASSPW_SHIFT)
#define AFI_CONFIGURATION_0_UFPCI_PASSPW_RANGE                  5:5
#define AFI_CONFIGURATION_0_UFPCI_PASSPW_WOFFSET                        0x0
#define AFI_CONFIGURATION_0_UFPCI_PASSPW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_UFPCI_PASSPW_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_UFPCI_PASSPW_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_UFPCI_PASSPW_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//This read-only bit provides status on whether PCIe is strapped
//as a root port or endpoint.  The value of this bit is 1b (endpoint)
//if production mode is 0b (disabled) and memory strap_ram_code[0] is 1b.
#define AFI_CONFIGURATION_0_ENDPT_MODE_SHIFT                    _MK_SHIFT_CONST(8)
#define AFI_CONFIGURATION_0_ENDPT_MODE_FIELD                    (_MK_MASK_CONST(0x1) << AFI_CONFIGURATION_0_ENDPT_MODE_SHIFT)
#define AFI_CONFIGURATION_0_ENDPT_MODE_RANGE                    8:8
#define AFI_CONFIGURATION_0_ENDPT_MODE_WOFFSET                  0x0
#define AFI_CONFIGURATION_0_ENDPT_MODE_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_ENDPT_MODE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_ENDPT_MODE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_ENDPT_MODE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//This read-only bit provides status on whether MSI Vector registers
//have any active bits valid or not
#define AFI_CONFIGURATION_0_MSI_VEC_EMPTY_SHIFT                 _MK_SHIFT_CONST(9)
#define AFI_CONFIGURATION_0_MSI_VEC_EMPTY_FIELD                 (_MK_MASK_CONST(0x1) << AFI_CONFIGURATION_0_MSI_VEC_EMPTY_SHIFT)
#define AFI_CONFIGURATION_0_MSI_VEC_EMPTY_RANGE                 9:9
#define AFI_CONFIGURATION_0_MSI_VEC_EMPTY_WOFFSET                       0x0
#define AFI_CONFIGURATION_0_MSI_VEC_EMPTY_DEFAULT                       _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_MSI_VEC_EMPTY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_MSI_VEC_EMPTY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_MSI_VEC_EMPTY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//This read-only bit provides status writes to AFI target.
//A value of 1b indicates there are no outstanding writes to downstream FPCI.
#define AFI_CONFIGURATION_0_TARGET_WRITE_IDLE_SHIFT                     _MK_SHIFT_CONST(10)
#define AFI_CONFIGURATION_0_TARGET_WRITE_IDLE_FIELD                     (_MK_MASK_CONST(0x1) << AFI_CONFIGURATION_0_TARGET_WRITE_IDLE_SHIFT)
#define AFI_CONFIGURATION_0_TARGET_WRITE_IDLE_RANGE                     10:10
#define AFI_CONFIGURATION_0_TARGET_WRITE_IDLE_WOFFSET                   0x0
#define AFI_CONFIGURATION_0_TARGET_WRITE_IDLE_DEFAULT                   _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_TARGET_WRITE_IDLE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_TARGET_WRITE_IDLE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_TARGET_WRITE_IDLE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//This read-only bit provides status reads to AFI target.
//A value of 1b indicates there are no outstanding reads to downstream FPCI.
#define AFI_CONFIGURATION_0_TARGET_READ_IDLE_SHIFT                      _MK_SHIFT_CONST(11)
#define AFI_CONFIGURATION_0_TARGET_READ_IDLE_FIELD                      (_MK_MASK_CONST(0x1) << AFI_CONFIGURATION_0_TARGET_READ_IDLE_SHIFT)
#define AFI_CONFIGURATION_0_TARGET_READ_IDLE_RANGE                      11:11
#define AFI_CONFIGURATION_0_TARGET_READ_IDLE_WOFFSET                    0x0
#define AFI_CONFIGURATION_0_TARGET_READ_IDLE_DEFAULT                    _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_TARGET_READ_IDLE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_TARGET_READ_IDLE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_TARGET_READ_IDLE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//This read-only bit is 0 when a card is present in PCIE slot 0
#define AFI_CONFIGURATION_0_PE0_PRSNT_L_IN_SHIFT                        _MK_SHIFT_CONST(12)
#define AFI_CONFIGURATION_0_PE0_PRSNT_L_IN_FIELD                        (_MK_MASK_CONST(0x1) << AFI_CONFIGURATION_0_PE0_PRSNT_L_IN_SHIFT)
#define AFI_CONFIGURATION_0_PE0_PRSNT_L_IN_RANGE                        12:12
#define AFI_CONFIGURATION_0_PE0_PRSNT_L_IN_WOFFSET                      0x0
#define AFI_CONFIGURATION_0_PE0_PRSNT_L_IN_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_PE0_PRSNT_L_IN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_PE0_PRSNT_L_IN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_PE0_PRSNT_L_IN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//This read-only bit is 0 when a card is present in PCIE slot 1
#define AFI_CONFIGURATION_0_PE1_PRSNT_L_IN_SHIFT                        _MK_SHIFT_CONST(13)
#define AFI_CONFIGURATION_0_PE1_PRSNT_L_IN_FIELD                        (_MK_MASK_CONST(0x1) << AFI_CONFIGURATION_0_PE1_PRSNT_L_IN_SHIFT)
#define AFI_CONFIGURATION_0_PE1_PRSNT_L_IN_RANGE                        13:13
#define AFI_CONFIGURATION_0_PE1_PRSNT_L_IN_WOFFSET                      0x0
#define AFI_CONFIGURATION_0_PE1_PRSNT_L_IN_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_PE1_PRSNT_L_IN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_PE1_PRSNT_L_IN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_PE1_PRSNT_L_IN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//CYA - used to en(dis)able the handling of interleaved write requests on mselect
#define AFI_CONFIGURATION_0_WR_INTRLV_CYA_SHIFT                 _MK_SHIFT_CONST(14)
#define AFI_CONFIGURATION_0_WR_INTRLV_CYA_FIELD                 (_MK_MASK_CONST(0x1) << AFI_CONFIGURATION_0_WR_INTRLV_CYA_SHIFT)
#define AFI_CONFIGURATION_0_WR_INTRLV_CYA_RANGE                 14:14
#define AFI_CONFIGURATION_0_WR_INTRLV_CYA_WOFFSET                       0x0
#define AFI_CONFIGURATION_0_WR_INTRLV_CYA_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_WR_INTRLV_CYA_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_WR_INTRLV_CYA_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_WR_INTRLV_CYA_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//CYA - used to en(dis)able the handling of write data ahead of requests on mselect
#define AFI_CONFIGURATION_0_WDATA_LEAD_CYA_SHIFT                        _MK_SHIFT_CONST(15)
#define AFI_CONFIGURATION_0_WDATA_LEAD_CYA_FIELD                        (_MK_MASK_CONST(0x1) << AFI_CONFIGURATION_0_WDATA_LEAD_CYA_SHIFT)
#define AFI_CONFIGURATION_0_WDATA_LEAD_CYA_RANGE                        15:15
#define AFI_CONFIGURATION_0_WDATA_LEAD_CYA_WOFFSET                      0x0
#define AFI_CONFIGURATION_0_WDATA_LEAD_CYA_DEFAULT                      _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_WDATA_LEAD_CYA_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AFI_CONFIGURATION_0_WDATA_LEAD_CYA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_CONFIGURATION_0_WDATA_LEAD_CYA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register AFI_FPCI_ERROR_MASKS_0  
#define AFI_FPCI_ERROR_MASKS_0                  _MK_ADDR_CONST(0xb0)
#define AFI_FPCI_ERROR_MASKS_0_SECURE                   0x0
#define AFI_FPCI_ERROR_MASKS_0_WORD_COUNT                       0x1
#define AFI_FPCI_ERROR_MASKS_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define AFI_FPCI_ERROR_MASKS_0_RESET_MASK                       _MK_MASK_CONST(0x7)
#define AFI_FPCI_ERROR_MASKS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define AFI_FPCI_ERROR_MASKS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AFI_FPCI_ERROR_MASKS_0_READ_MASK                        _MK_MASK_CONST(0x7)
#define AFI_FPCI_ERROR_MASKS_0_WRITE_MASK                       _MK_MASK_CONST(0x7)
//This bit allows FPCI error to be forwarded to AXI response when FPCI error response
//indicates Target Abort. 1 = forward error, 0 = return AXI OKAY response (2'b0)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_TARGET_ABORT_SHIFT                     _MK_SHIFT_CONST(0)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_TARGET_ABORT_FIELD                     (_MK_MASK_CONST(0x1) << AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_TARGET_ABORT_SHIFT)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_TARGET_ABORT_RANGE                     0:0
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_TARGET_ABORT_WOFFSET                   0x0
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_TARGET_ABORT_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_TARGET_ABORT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_TARGET_ABORT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_TARGET_ABORT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//This bit allows FPCI error to be forwarded to AXI response when FPCI error response
//indicates Data Error. 1 = forward error, 0 = return AXI OKAY response (2'b0)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_DATA_ERROR_SHIFT                       _MK_SHIFT_CONST(1)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_DATA_ERROR_FIELD                       (_MK_MASK_CONST(0x1) << AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_DATA_ERROR_SHIFT)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_DATA_ERROR_RANGE                       1:1
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_DATA_ERROR_WOFFSET                     0x0
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_DATA_ERROR_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_DATA_ERROR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_DATA_ERROR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_DATA_ERROR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//This bit allows FPCI error to be forwarded to AXI response when FPCI error response
//indicates Master Abort. 1 = forward error, 0 = return AXI OKAY response (2'b0)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_MASTER_ABORT_SHIFT                     _MK_SHIFT_CONST(2)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_MASTER_ABORT_FIELD                     (_MK_MASK_CONST(0x1) << AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_MASTER_ABORT_SHIFT)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_MASTER_ABORT_RANGE                     2:2
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_MASTER_ABORT_WOFFSET                   0x0
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_MASTER_ABORT_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_MASTER_ABORT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_MASTER_ABORT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_FPCI_ERROR_MASKS_0_MASK_FPCI_MASTER_ABORT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register AFI_INTR_MASK_0  
#define AFI_INTR_MASK_0                 _MK_ADDR_CONST(0xb4)
#define AFI_INTR_MASK_0_SECURE                  0x0
#define AFI_INTR_MASK_0_WORD_COUNT                      0x1
#define AFI_INTR_MASK_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define AFI_INTR_MASK_0_RESET_MASK                      _MK_MASK_CONST(0x101)
#define AFI_INTR_MASK_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AFI_INTR_MASK_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AFI_INTR_MASK_0_READ_MASK                       _MK_MASK_CONST(0x101)
#define AFI_INTR_MASK_0_WRITE_MASK                      _MK_MASK_CONST(0x101)
//Interrupt to MPCORE gated by mask.
#define AFI_INTR_MASK_0_INT_MASK_SHIFT                  _MK_SHIFT_CONST(0)
#define AFI_INTR_MASK_0_INT_MASK_FIELD                  (_MK_MASK_CONST(0x1) << AFI_INTR_MASK_0_INT_MASK_SHIFT)
#define AFI_INTR_MASK_0_INT_MASK_RANGE                  0:0
#define AFI_INTR_MASK_0_INT_MASK_WOFFSET                        0x0
#define AFI_INTR_MASK_0_INT_MASK_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_INTR_MASK_0_INT_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AFI_INTR_MASK_0_INT_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_INTR_MASK_0_INT_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//MSI to MPCORE gated by mask.
#define AFI_INTR_MASK_0_MSI_MASK_SHIFT                  _MK_SHIFT_CONST(8)
#define AFI_INTR_MASK_0_MSI_MASK_FIELD                  (_MK_MASK_CONST(0x1) << AFI_INTR_MASK_0_MSI_MASK_SHIFT)
#define AFI_INTR_MASK_0_MSI_MASK_RANGE                  8:8
#define AFI_INTR_MASK_0_MSI_MASK_WOFFSET                        0x0
#define AFI_INTR_MASK_0_MSI_MASK_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_INTR_MASK_0_MSI_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AFI_INTR_MASK_0_MSI_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_INTR_MASK_0_MSI_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register AFI_INTR_CODE_0  
#define AFI_INTR_CODE_0                 _MK_ADDR_CONST(0xb8)
#define AFI_INTR_CODE_0_SECURE                  0x0
#define AFI_INTR_CODE_0_WORD_COUNT                      0x1
#define AFI_INTR_CODE_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define AFI_INTR_CODE_0_RESET_MASK                      _MK_MASK_CONST(0xf)
#define AFI_INTR_CODE_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AFI_INTR_CODE_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AFI_INTR_CODE_0_READ_MASK                       _MK_MASK_CONST(0xf)
#define AFI_INTR_CODE_0_WRITE_MASK                      _MK_MASK_CONST(0xf)
//Eight interrupt codes
//If the code is 0, logging of the next interrupt is enabled
#define AFI_INTR_CODE_0_INT_CODE_SHIFT                  _MK_SHIFT_CONST(0)
#define AFI_INTR_CODE_0_INT_CODE_FIELD                  (_MK_MASK_CONST(0xf) << AFI_INTR_CODE_0_INT_CODE_SHIFT)
#define AFI_INTR_CODE_0_INT_CODE_RANGE                  3:0
#define AFI_INTR_CODE_0_INT_CODE_WOFFSET                        0x0
#define AFI_INTR_CODE_0_INT_CODE_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_INTR_CODE_0_INT_CODE_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define AFI_INTR_CODE_0_INT_CODE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_INTR_CODE_0_INT_CODE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AFI_INTR_CODE_0_INT_CODE_INT_CODE_CLEAR                 _MK_ENUM_CONST(0)    // //Clear interrupt code

#define AFI_INTR_CODE_0_INT_CODE_INT_CODE_INI_SLVERR                    _MK_ENUM_CONST(1)    // //Interrupt code for MPCORE AXI SLVERR response to AFI

#define AFI_INTR_CODE_0_INT_CODE_INT_CODE_INI_DECERR                    _MK_ENUM_CONST(2)    // //Interrupt code for MPCORE AXI DECERR response to AFI

#define AFI_INTR_CODE_0_INT_CODE_INT_CODE_TGT_SLVERR                    _MK_ENUM_CONST(3)    // //Interrupt code for PCIE endpoint FPCI target abort or data error 
//response to AFI

#define AFI_INTR_CODE_0_INT_CODE_INT_CODE_TGT_DECERR                    _MK_ENUM_CONST(4)    // //Interrupt code for PCIE2 FPCI master abort response to AFI

#define AFI_INTR_CODE_0_INT_CODE_INT_CODE_TGT_WRERR                     _MK_ENUM_CONST(5)    // //Interrupt code for bufferable write to non-posted write address region

#define AFI_INTR_CODE_0_INT_CODE_INT_CODE_SM_MSG                        _MK_ENUM_CONST(6)    // //Interrupt code for PCIE2 system management message

#define AFI_INTR_CODE_0_INT_CODE_INT_CODE_DFPCI_DECERR                  _MK_ENUM_CONST(7)    // //Interrupt code for PCIE2 response to downstream request when
//downstream FPCI addresss does not fall in a claimable downstream region

#define AFI_INTR_CODE_0_INT_CODE_INT_CODE_AXI_DECERR                    _MK_ENUM_CONST(8)    // //Interrupt code for AFI response to downstream request when
//mselect AXI addresss does not fall in any of AFI downstream BARs

#define AFI_INTR_CODE_0_INT_CODE_INT_CODE_FPCI_TIMEOUT                  _MK_ENUM_CONST(9)    // //Interrupt code for FPCI Timeout



// Register AFI_INTR_SIGNATURE_0  
#define AFI_INTR_SIGNATURE_0                    _MK_ADDR_CONST(0xbc)
#define AFI_INTR_SIGNATURE_0_SECURE                     0x0
#define AFI_INTR_SIGNATURE_0_WORD_COUNT                         0x1
#define AFI_INTR_SIGNATURE_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define AFI_INTR_SIGNATURE_0_RESET_MASK                         _MK_MASK_CONST(0xfffffffd)
#define AFI_INTR_SIGNATURE_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define AFI_INTR_SIGNATURE_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AFI_INTR_SIGNATURE_0_READ_MASK                  _MK_MASK_CONST(0xfffffffd)
#define AFI_INTR_SIGNATURE_0_WRITE_MASK                         _MK_MASK_CONST(0xfffffffd)
//Indicates direction of the AXI/FPCI transaction. 1=rd/0=wr
//If signature type is 6 (sideband message), this field is 1.
#define AFI_INTR_SIGNATURE_0_DIR_SHIFT                  _MK_SHIFT_CONST(0)
#define AFI_INTR_SIGNATURE_0_DIR_FIELD                  (_MK_MASK_CONST(0x1) << AFI_INTR_SIGNATURE_0_DIR_SHIFT)
#define AFI_INTR_SIGNATURE_0_DIR_RANGE                  0:0
#define AFI_INTR_SIGNATURE_0_DIR_WOFFSET                        0x0
#define AFI_INTR_SIGNATURE_0_DIR_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_INTR_SIGNATURE_0_DIR_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AFI_INTR_SIGNATURE_0_DIR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_INTR_SIGNATURE_0_DIR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AFI_INTR_SIGNATURE_0_DIR_WRITE                  _MK_ENUM_CONST(0)    // //Interrupt due to a write transaction

#define AFI_INTR_SIGNATURE_0_DIR_READ                   _MK_ENUM_CONST(1)    // //Interrupt due to a read transaction


//For interrupt codes 1-5/7-8, it contains address bits [31:2], 
//either in FPCI memory space or AXI space. If interrupt code is 6,
//the information field INT_INFO[12:0] contain sideband information 
//{sideband unitid, 3'b0, tms02sm_msg[4:0]}.
//For FPCI generated errors, the info contains FPCI address.
//For AXI/AFI generated errors, the info contains AXI address.
#define AFI_INTR_SIGNATURE_0_INT_INFO_SHIFT                     _MK_SHIFT_CONST(2)
#define AFI_INTR_SIGNATURE_0_INT_INFO_FIELD                     (_MK_MASK_CONST(0x3fffffff) << AFI_INTR_SIGNATURE_0_INT_INFO_SHIFT)
#define AFI_INTR_SIGNATURE_0_INT_INFO_RANGE                     31:2
#define AFI_INTR_SIGNATURE_0_INT_INFO_WOFFSET                   0x0
#define AFI_INTR_SIGNATURE_0_INT_INFO_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_INTR_SIGNATURE_0_INT_INFO_DEFAULT_MASK                      _MK_MASK_CONST(0x3fffffff)
#define AFI_INTR_SIGNATURE_0_INT_INFO_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_INTR_SIGNATURE_0_INT_INFO_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register AFI_UPPER_FPCI_ADDR_0  
#define AFI_UPPER_FPCI_ADDR_0                   _MK_ADDR_CONST(0xc0)
#define AFI_UPPER_FPCI_ADDR_0_SECURE                    0x0
#define AFI_UPPER_FPCI_ADDR_0_WORD_COUNT                        0x1
#define AFI_UPPER_FPCI_ADDR_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define AFI_UPPER_FPCI_ADDR_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define AFI_UPPER_FPCI_ADDR_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define AFI_UPPER_FPCI_ADDR_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AFI_UPPER_FPCI_ADDR_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define AFI_UPPER_FPCI_ADDR_0_WRITE_MASK                        _MK_MASK_CONST(0xff)
//These 8 bits are the upper byte of captured FPCI address (bits[39:32])
//when interrupt code is 3, 4 or 7.  These bits determine the region
//in the Hypertransport Address Map that was accessed.  This map
//is described in section 3.2.4 of the AFI IAS.
#define AFI_UPPER_FPCI_ADDR_0_INT_INFO_UPPER_SHIFT                      _MK_SHIFT_CONST(0)
#define AFI_UPPER_FPCI_ADDR_0_INT_INFO_UPPER_FIELD                      (_MK_MASK_CONST(0xff) << AFI_UPPER_FPCI_ADDR_0_INT_INFO_UPPER_SHIFT)
#define AFI_UPPER_FPCI_ADDR_0_INT_INFO_UPPER_RANGE                      7:0
#define AFI_UPPER_FPCI_ADDR_0_INT_INFO_UPPER_WOFFSET                    0x0
#define AFI_UPPER_FPCI_ADDR_0_INT_INFO_UPPER_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_UPPER_FPCI_ADDR_0_INT_INFO_UPPER_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define AFI_UPPER_FPCI_ADDR_0_INT_INFO_UPPER_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_UPPER_FPCI_ADDR_0_INT_INFO_UPPER_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register AFI_SM_INTR_ENABLE_0  
#define AFI_SM_INTR_ENABLE_0                    _MK_ADDR_CONST(0xc4)
#define AFI_SM_INTR_ENABLE_0_SECURE                     0x0
#define AFI_SM_INTR_ENABLE_0_WORD_COUNT                         0x1
#define AFI_SM_INTR_ENABLE_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define AFI_SM_INTR_ENABLE_0_RESET_MASK                         _MK_MASK_CONST(0x7fff)
#define AFI_SM_INTR_ENABLE_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define AFI_SM_INTR_ENABLE_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AFI_SM_INTR_ENABLE_0_READ_MASK                  _MK_MASK_CONST(0x7fff)
#define AFI_SM_INTR_ENABLE_0_WRITE_MASK                         _MK_MASK_CONST(0x7fff)
//Each of the bits in this register correspond to enabling the
//associated message shown in the system message table in 3.2.10
//Enable bits for interrupt code 6 of table in section 8.1.3
#define AFI_SM_INTR_ENABLE_0_ENABLE_MESSAGE_SHIFT                       _MK_SHIFT_CONST(0)
#define AFI_SM_INTR_ENABLE_0_ENABLE_MESSAGE_FIELD                       (_MK_MASK_CONST(0x7fff) << AFI_SM_INTR_ENABLE_0_ENABLE_MESSAGE_SHIFT)
#define AFI_SM_INTR_ENABLE_0_ENABLE_MESSAGE_RANGE                       14:0
#define AFI_SM_INTR_ENABLE_0_ENABLE_MESSAGE_WOFFSET                     0x0
#define AFI_SM_INTR_ENABLE_0_ENABLE_MESSAGE_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_SM_INTR_ENABLE_0_ENABLE_MESSAGE_DEFAULT_MASK                        _MK_MASK_CONST(0x7fff)
#define AFI_SM_INTR_ENABLE_0_ENABLE_MESSAGE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_SM_INTR_ENABLE_0_ENABLE_MESSAGE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register AFI_AFI_INTR_ENABLE_0  
#define AFI_AFI_INTR_ENABLE_0                   _MK_ADDR_CONST(0xc8)
#define AFI_AFI_INTR_ENABLE_0_SECURE                    0x0
#define AFI_AFI_INTR_ENABLE_0_WORD_COUNT                        0x1
#define AFI_AFI_INTR_ENABLE_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define AFI_AFI_INTR_ENABLE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define AFI_AFI_INTR_ENABLE_0_WRITE_MASK                        _MK_MASK_CONST(0xff)
//Enable bit for interrupt code 1 
#define AFI_AFI_INTR_ENABLE_0_EN_INI_SLVERR_SHIFT                       _MK_SHIFT_CONST(0)
#define AFI_AFI_INTR_ENABLE_0_EN_INI_SLVERR_FIELD                       (_MK_MASK_CONST(0x1) << AFI_AFI_INTR_ENABLE_0_EN_INI_SLVERR_SHIFT)
#define AFI_AFI_INTR_ENABLE_0_EN_INI_SLVERR_RANGE                       0:0
#define AFI_AFI_INTR_ENABLE_0_EN_INI_SLVERR_WOFFSET                     0x0
#define AFI_AFI_INTR_ENABLE_0_EN_INI_SLVERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_EN_INI_SLVERR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_AFI_INTR_ENABLE_0_EN_INI_SLVERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_EN_INI_SLVERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//Enable bit for interrupt code 2 
#define AFI_AFI_INTR_ENABLE_0_EN_INI_DECERR_SHIFT                       _MK_SHIFT_CONST(1)
#define AFI_AFI_INTR_ENABLE_0_EN_INI_DECERR_FIELD                       (_MK_MASK_CONST(0x1) << AFI_AFI_INTR_ENABLE_0_EN_INI_DECERR_SHIFT)
#define AFI_AFI_INTR_ENABLE_0_EN_INI_DECERR_RANGE                       1:1
#define AFI_AFI_INTR_ENABLE_0_EN_INI_DECERR_WOFFSET                     0x0
#define AFI_AFI_INTR_ENABLE_0_EN_INI_DECERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_EN_INI_DECERR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_AFI_INTR_ENABLE_0_EN_INI_DECERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_EN_INI_DECERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//Enable bit for interrupt code 3 
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_SLVERR_SHIFT                       _MK_SHIFT_CONST(2)
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_SLVERR_FIELD                       (_MK_MASK_CONST(0x1) << AFI_AFI_INTR_ENABLE_0_EN_TGT_SLVERR_SHIFT)
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_SLVERR_RANGE                       2:2
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_SLVERR_WOFFSET                     0x0
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_SLVERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_SLVERR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_SLVERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_SLVERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//Enable bit for interrupt code 4 
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_DECERR_SHIFT                       _MK_SHIFT_CONST(3)
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_DECERR_FIELD                       (_MK_MASK_CONST(0x1) << AFI_AFI_INTR_ENABLE_0_EN_TGT_DECERR_SHIFT)
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_DECERR_RANGE                       3:3
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_DECERR_WOFFSET                     0x0
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_DECERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_DECERR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_DECERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_DECERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//Enable bit for interrupt code 5 
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_WRERR_SHIFT                        _MK_SHIFT_CONST(4)
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_WRERR_FIELD                        (_MK_MASK_CONST(0x1) << AFI_AFI_INTR_ENABLE_0_EN_TGT_WRERR_SHIFT)
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_WRERR_RANGE                        4:4
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_WRERR_WOFFSET                      0x0
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_WRERR_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_WRERR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_WRERR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_EN_TGT_WRERR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//Enable bit for interrupt code 7 
#define AFI_AFI_INTR_ENABLE_0_EN_DFPCI_DECERR_SHIFT                     _MK_SHIFT_CONST(5)
#define AFI_AFI_INTR_ENABLE_0_EN_DFPCI_DECERR_FIELD                     (_MK_MASK_CONST(0x1) << AFI_AFI_INTR_ENABLE_0_EN_DFPCI_DECERR_SHIFT)
#define AFI_AFI_INTR_ENABLE_0_EN_DFPCI_DECERR_RANGE                     5:5
#define AFI_AFI_INTR_ENABLE_0_EN_DFPCI_DECERR_WOFFSET                   0x0
#define AFI_AFI_INTR_ENABLE_0_EN_DFPCI_DECERR_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_EN_DFPCI_DECERR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AFI_AFI_INTR_ENABLE_0_EN_DFPCI_DECERR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_EN_DFPCI_DECERR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//Enable bit for interrupt code 8 
#define AFI_AFI_INTR_ENABLE_0_EN_AXI_DECERR_SHIFT                       _MK_SHIFT_CONST(6)
#define AFI_AFI_INTR_ENABLE_0_EN_AXI_DECERR_FIELD                       (_MK_MASK_CONST(0x1) << AFI_AFI_INTR_ENABLE_0_EN_AXI_DECERR_SHIFT)
#define AFI_AFI_INTR_ENABLE_0_EN_AXI_DECERR_RANGE                       6:6
#define AFI_AFI_INTR_ENABLE_0_EN_AXI_DECERR_WOFFSET                     0x0
#define AFI_AFI_INTR_ENABLE_0_EN_AXI_DECERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_EN_AXI_DECERR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_AFI_INTR_ENABLE_0_EN_AXI_DECERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_EN_AXI_DECERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//Enable bit for interrupt code 9 
#define AFI_AFI_INTR_ENABLE_0_EN_FPCI_TIMEOUT_SHIFT                     _MK_SHIFT_CONST(7)
#define AFI_AFI_INTR_ENABLE_0_EN_FPCI_TIMEOUT_FIELD                     (_MK_MASK_CONST(0x1) << AFI_AFI_INTR_ENABLE_0_EN_FPCI_TIMEOUT_SHIFT)
#define AFI_AFI_INTR_ENABLE_0_EN_FPCI_TIMEOUT_RANGE                     7:7
#define AFI_AFI_INTR_ENABLE_0_EN_FPCI_TIMEOUT_WOFFSET                   0x0
#define AFI_AFI_INTR_ENABLE_0_EN_FPCI_TIMEOUT_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_EN_FPCI_TIMEOUT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AFI_AFI_INTR_ENABLE_0_EN_FPCI_TIMEOUT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_AFI_INTR_ENABLE_0_EN_FPCI_TIMEOUT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register AFI_AUSER_OVERRIDE_0  
#define AFI_AUSER_OVERRIDE_0                    _MK_ADDR_CONST(0xcc)
#define AFI_AUSER_OVERRIDE_0_SECURE                     0x0
#define AFI_AUSER_OVERRIDE_0_WORD_COUNT                         0x1
#define AFI_AUSER_OVERRIDE_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define AFI_AUSER_OVERRIDE_0_RESET_MASK                         _MK_MASK_CONST(0x8000001f)
#define AFI_AUSER_OVERRIDE_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define AFI_AUSER_OVERRIDE_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AFI_AUSER_OVERRIDE_0_READ_MASK                  _MK_MASK_CONST(0x8000001f)
#define AFI_AUSER_OVERRIDE_0_WRITE_MASK                         _MK_MASK_CONST(0x8000001f)
//Programmable value to drive on to AXI initiator AUSER fields
#define AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_VAL_SHIFT                   _MK_SHIFT_CONST(0)
#define AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_VAL_FIELD                   (_MK_MASK_CONST(0x1f) << AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_VAL_SHIFT)
#define AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_VAL_RANGE                   4:0
#define AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_VAL_WOFFSET                 0x0
#define AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_VAL_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_VAL_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_VAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_VAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Enables value in override register to be driven on AXI initiator 
//AUSER when in preproduction mode. 
//1=drive AUSER override value (preproduction mode only)
//0=drive AUSER normally
#define AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_EN_SHIFT                    _MK_SHIFT_CONST(31)
#define AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_EN_FIELD                    (_MK_MASK_CONST(0x1) << AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_EN_SHIFT)
#define AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_EN_RANGE                    31:31
#define AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_EN_WOFFSET                  0x0
#define AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_AUSER_OVERRIDE_0_AUSER_OVERRIDE_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register AFI_ACACHE_OVERRIDE_0  
#define AFI_ACACHE_OVERRIDE_0                   _MK_ADDR_CONST(0xd0)
#define AFI_ACACHE_OVERRIDE_0_SECURE                    0x0
#define AFI_ACACHE_OVERRIDE_0_WORD_COUNT                        0x1
#define AFI_ACACHE_OVERRIDE_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define AFI_ACACHE_OVERRIDE_0_RESET_MASK                        _MK_MASK_CONST(0x8000000f)
#define AFI_ACACHE_OVERRIDE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define AFI_ACACHE_OVERRIDE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AFI_ACACHE_OVERRIDE_0_READ_MASK                         _MK_MASK_CONST(0x8000000f)
#define AFI_ACACHE_OVERRIDE_0_WRITE_MASK                        _MK_MASK_CONST(0x8000000f)
//Programmable value to drive on to AXI initiator ACACHE fields
#define AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_VAL_SHIFT                 _MK_SHIFT_CONST(0)
#define AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_VAL_FIELD                 (_MK_MASK_CONST(0xf) << AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_VAL_SHIFT)
#define AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_VAL_RANGE                 3:0
#define AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_VAL_WOFFSET                       0x0
#define AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_VAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_VAL_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_VAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_VAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//Enables value in override register to be driven on AXI initiator 
//ACACHE when in preproduction mode. 
//1=drive ACACHE override value (preproduction mode only)
//0=drive ACACHE normally
#define AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_EN_SHIFT                  _MK_SHIFT_CONST(31)
#define AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_EN_FIELD                  (_MK_MASK_CONST(0x1) << AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_EN_SHIFT)
#define AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_EN_RANGE                  31:31
#define AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_EN_WOFFSET                        0x0
#define AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_ACACHE_OVERRIDE_0_ACACHE_OVERRIDE_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register AFI_APROT_OVERRIDE_0  
#define AFI_APROT_OVERRIDE_0                    _MK_ADDR_CONST(0xd4)
#define AFI_APROT_OVERRIDE_0_SECURE                     0x0
#define AFI_APROT_OVERRIDE_0_WORD_COUNT                         0x1
#define AFI_APROT_OVERRIDE_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define AFI_APROT_OVERRIDE_0_RESET_MASK                         _MK_MASK_CONST(0x80000007)
#define AFI_APROT_OVERRIDE_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define AFI_APROT_OVERRIDE_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AFI_APROT_OVERRIDE_0_READ_MASK                  _MK_MASK_CONST(0x80000007)
#define AFI_APROT_OVERRIDE_0_WRITE_MASK                         _MK_MASK_CONST(0x80000007)
//Programmable value to drive on to AXI initiator APROT fields
#define AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_VAL_SHIFT                   _MK_SHIFT_CONST(0)
#define AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_VAL_FIELD                   (_MK_MASK_CONST(0x7) << AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_VAL_SHIFT)
#define AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_VAL_RANGE                   2:0
#define AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_VAL_WOFFSET                 0x0
#define AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_VAL_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_VAL_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_VAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_VAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Enables value in override register to be driven on AXI initiator 
//APROT when in preproduction mode. 
//1=drive APROT override value (preproduction mode only)
//0=drive APROT normally
#define AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_EN_SHIFT                    _MK_SHIFT_CONST(31)
#define AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_EN_FIELD                    (_MK_MASK_CONST(0x1) << AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_EN_SHIFT)
#define AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_EN_RANGE                    31:31
#define AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_EN_WOFFSET                  0x0
#define AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_APROT_OVERRIDE_0_APROT_OVERRIDE_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register AFI_FPCI_TIMEOUT_0  
#define AFI_FPCI_TIMEOUT_0                      _MK_ADDR_CONST(0xd8)
#define AFI_FPCI_TIMEOUT_0_SECURE                       0x0
#define AFI_FPCI_TIMEOUT_0_WORD_COUNT                   0x1
#define AFI_FPCI_TIMEOUT_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define AFI_FPCI_TIMEOUT_0_RESET_MASK                   _MK_MASK_CONST(0x800fffff)
#define AFI_FPCI_TIMEOUT_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define AFI_FPCI_TIMEOUT_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define AFI_FPCI_TIMEOUT_0_READ_MASK                    _MK_MASK_CONST(0x800fffff)
#define AFI_FPCI_TIMEOUT_0_WRITE_MASK                   _MK_MASK_CONST(0x800fffff)
//SM (system management) threshold specifying how long to wait 
//for response from FPCI before declaring it timeout
#define AFI_FPCI_TIMEOUT_0_SM2ALL_FPCI_TIMEOUT_THRESH_SHIFT                     _MK_SHIFT_CONST(0)
#define AFI_FPCI_TIMEOUT_0_SM2ALL_FPCI_TIMEOUT_THRESH_FIELD                     (_MK_MASK_CONST(0xfffff) << AFI_FPCI_TIMEOUT_0_SM2ALL_FPCI_TIMEOUT_THRESH_SHIFT)
#define AFI_FPCI_TIMEOUT_0_SM2ALL_FPCI_TIMEOUT_THRESH_RANGE                     19:0
#define AFI_FPCI_TIMEOUT_0_SM2ALL_FPCI_TIMEOUT_THRESH_WOFFSET                   0x0
#define AFI_FPCI_TIMEOUT_0_SM2ALL_FPCI_TIMEOUT_THRESH_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_FPCI_TIMEOUT_0_SM2ALL_FPCI_TIMEOUT_THRESH_DEFAULT_MASK                      _MK_MASK_CONST(0xfffff)
#define AFI_FPCI_TIMEOUT_0_SM2ALL_FPCI_TIMEOUT_THRESH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_FPCI_TIMEOUT_0_SM2ALL_FPCI_TIMEOUT_THRESH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//SM (system management) timeout enable
#define AFI_FPCI_TIMEOUT_0_SM2TMS0_FPCI_TIMEOUT_EN_SHIFT                        _MK_SHIFT_CONST(31)
#define AFI_FPCI_TIMEOUT_0_SM2TMS0_FPCI_TIMEOUT_EN_FIELD                        (_MK_MASK_CONST(0x1) << AFI_FPCI_TIMEOUT_0_SM2TMS0_FPCI_TIMEOUT_EN_SHIFT)
#define AFI_FPCI_TIMEOUT_0_SM2TMS0_FPCI_TIMEOUT_EN_RANGE                        31:31
#define AFI_FPCI_TIMEOUT_0_SM2TMS0_FPCI_TIMEOUT_EN_WOFFSET                      0x0
#define AFI_FPCI_TIMEOUT_0_SM2TMS0_FPCI_TIMEOUT_EN_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_FPCI_TIMEOUT_0_SM2TMS0_FPCI_TIMEOUT_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AFI_FPCI_TIMEOUT_0_SM2TMS0_FPCI_TIMEOUT_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_FPCI_TIMEOUT_0_SM2TMS0_FPCI_TIMEOUT_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register AFI_IDDQ_MODE_0  
#define AFI_IDDQ_MODE_0                 _MK_ADDR_CONST(0xdc)
#define AFI_IDDQ_MODE_0_SECURE                  0x0
#define AFI_IDDQ_MODE_0_WORD_COUNT                      0x1
#define AFI_IDDQ_MODE_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define AFI_IDDQ_MODE_0_RESET_MASK                      _MK_MASK_CONST(0x3)
#define AFI_IDDQ_MODE_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AFI_IDDQ_MODE_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AFI_IDDQ_MODE_0_READ_MASK                       _MK_MASK_CONST(0x3)
#define AFI_IDDQ_MODE_0_WRITE_MASK                      _MK_MASK_CONST(0x3)
//SM (system management) to PCIE PLL assert IDDQ Mode
#define AFI_IDDQ_MODE_0_SM2PCIE_ASSERT_PEX0_PLL_IDDQ_MODE_SHIFT                 _MK_SHIFT_CONST(0)
#define AFI_IDDQ_MODE_0_SM2PCIE_ASSERT_PEX0_PLL_IDDQ_MODE_FIELD                 (_MK_MASK_CONST(0x1) << AFI_IDDQ_MODE_0_SM2PCIE_ASSERT_PEX0_PLL_IDDQ_MODE_SHIFT)
#define AFI_IDDQ_MODE_0_SM2PCIE_ASSERT_PEX0_PLL_IDDQ_MODE_RANGE                 0:0
#define AFI_IDDQ_MODE_0_SM2PCIE_ASSERT_PEX0_PLL_IDDQ_MODE_WOFFSET                       0x0
#define AFI_IDDQ_MODE_0_SM2PCIE_ASSERT_PEX0_PLL_IDDQ_MODE_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_IDDQ_MODE_0_SM2PCIE_ASSERT_PEX0_PLL_IDDQ_MODE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AFI_IDDQ_MODE_0_SM2PCIE_ASSERT_PEX0_PLL_IDDQ_MODE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_IDDQ_MODE_0_SM2PCIE_ASSERT_PEX0_PLL_IDDQ_MODE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//SM (system management) to PCIE PLL deassert IDDQ Mode
#define AFI_IDDQ_MODE_0_SM2PCIE_DEASSERT_PEX0_PLL_IDDQ_MODE_SHIFT                       _MK_SHIFT_CONST(1)
#define AFI_IDDQ_MODE_0_SM2PCIE_DEASSERT_PEX0_PLL_IDDQ_MODE_FIELD                       (_MK_MASK_CONST(0x1) << AFI_IDDQ_MODE_0_SM2PCIE_DEASSERT_PEX0_PLL_IDDQ_MODE_SHIFT)
#define AFI_IDDQ_MODE_0_SM2PCIE_DEASSERT_PEX0_PLL_IDDQ_MODE_RANGE                       1:1
#define AFI_IDDQ_MODE_0_SM2PCIE_DEASSERT_PEX0_PLL_IDDQ_MODE_WOFFSET                     0x0
#define AFI_IDDQ_MODE_0_SM2PCIE_DEASSERT_PEX0_PLL_IDDQ_MODE_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_IDDQ_MODE_0_SM2PCIE_DEASSERT_PEX0_PLL_IDDQ_MODE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_IDDQ_MODE_0_SM2PCIE_DEASSERT_PEX0_PLL_IDDQ_MODE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_IDDQ_MODE_0_SM2PCIE_DEASSERT_PEX0_PLL_IDDQ_MODE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register AFI_PLL_RESET_0  
#define AFI_PLL_RESET_0                 _MK_ADDR_CONST(0xe0)
#define AFI_PLL_RESET_0_SECURE                  0x0
#define AFI_PLL_RESET_0_WORD_COUNT                      0x1
#define AFI_PLL_RESET_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define AFI_PLL_RESET_0_RESET_MASK                      _MK_MASK_CONST(0x3)
#define AFI_PLL_RESET_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AFI_PLL_RESET_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AFI_PLL_RESET_0_READ_MASK                       _MK_MASK_CONST(0x3)
#define AFI_PLL_RESET_0_WRITE_MASK                      _MK_MASK_CONST(0x3)
//SM (system management) to PCIE PLL assert Reset
#define AFI_PLL_RESET_0_SM2PCIE_ASSERT_PEX0_PLL_RST_SHIFT                       _MK_SHIFT_CONST(0)
#define AFI_PLL_RESET_0_SM2PCIE_ASSERT_PEX0_PLL_RST_FIELD                       (_MK_MASK_CONST(0x1) << AFI_PLL_RESET_0_SM2PCIE_ASSERT_PEX0_PLL_RST_SHIFT)
#define AFI_PLL_RESET_0_SM2PCIE_ASSERT_PEX0_PLL_RST_RANGE                       0:0
#define AFI_PLL_RESET_0_SM2PCIE_ASSERT_PEX0_PLL_RST_WOFFSET                     0x0
#define AFI_PLL_RESET_0_SM2PCIE_ASSERT_PEX0_PLL_RST_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_PLL_RESET_0_SM2PCIE_ASSERT_PEX0_PLL_RST_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_PLL_RESET_0_SM2PCIE_ASSERT_PEX0_PLL_RST_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_PLL_RESET_0_SM2PCIE_ASSERT_PEX0_PLL_RST_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//SM (system management) to PCIE PLL deassert Reset
#define AFI_PLL_RESET_0_SM2PCIE_DEASSERT_PEX0_PLL_RST_SHIFT                     _MK_SHIFT_CONST(1)
#define AFI_PLL_RESET_0_SM2PCIE_DEASSERT_PEX0_PLL_RST_FIELD                     (_MK_MASK_CONST(0x1) << AFI_PLL_RESET_0_SM2PCIE_DEASSERT_PEX0_PLL_RST_SHIFT)
#define AFI_PLL_RESET_0_SM2PCIE_DEASSERT_PEX0_PLL_RST_RANGE                     1:1
#define AFI_PLL_RESET_0_SM2PCIE_DEASSERT_PEX0_PLL_RST_WOFFSET                   0x0
#define AFI_PLL_RESET_0_SM2PCIE_DEASSERT_PEX0_PLL_RST_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_PLL_RESET_0_SM2PCIE_DEASSERT_PEX0_PLL_RST_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AFI_PLL_RESET_0_SM2PCIE_DEASSERT_PEX0_PLL_RST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_PLL_RESET_0_SM2PCIE_DEASSERT_PEX0_PLL_RST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register AFI_IDDQ_MODE_ACK_0  
#define AFI_IDDQ_MODE_ACK_0                     _MK_ADDR_CONST(0xe4)
#define AFI_IDDQ_MODE_ACK_0_SECURE                      0x0
#define AFI_IDDQ_MODE_ACK_0_WORD_COUNT                  0x1
#define AFI_IDDQ_MODE_ACK_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define AFI_IDDQ_MODE_ACK_0_RESET_MASK                  _MK_MASK_CONST(0x3)
#define AFI_IDDQ_MODE_ACK_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define AFI_IDDQ_MODE_ACK_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AFI_IDDQ_MODE_ACK_0_READ_MASK                   _MK_MASK_CONST(0x3)
#define AFI_IDDQ_MODE_ACK_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
//SM (system management) to PCIE PLL assert IDDQ Mode Ack
#define AFI_IDDQ_MODE_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_IDDQ_MODE_ACK_SHIFT                 _MK_SHIFT_CONST(0)
#define AFI_IDDQ_MODE_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_IDDQ_MODE_ACK_FIELD                 (_MK_MASK_CONST(0x1) << AFI_IDDQ_MODE_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_IDDQ_MODE_ACK_SHIFT)
#define AFI_IDDQ_MODE_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_IDDQ_MODE_ACK_RANGE                 0:0
#define AFI_IDDQ_MODE_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_IDDQ_MODE_ACK_WOFFSET                       0x0
#define AFI_IDDQ_MODE_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_IDDQ_MODE_ACK_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_IDDQ_MODE_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_IDDQ_MODE_ACK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AFI_IDDQ_MODE_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_IDDQ_MODE_ACK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_IDDQ_MODE_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_IDDQ_MODE_ACK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//SM (system management) to PCIE PLL deassert IDDQ Mode Ack
#define AFI_IDDQ_MODE_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_IDDQ_MODE_ACK_SHIFT                       _MK_SHIFT_CONST(1)
#define AFI_IDDQ_MODE_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_IDDQ_MODE_ACK_FIELD                       (_MK_MASK_CONST(0x1) << AFI_IDDQ_MODE_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_IDDQ_MODE_ACK_SHIFT)
#define AFI_IDDQ_MODE_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_IDDQ_MODE_ACK_RANGE                       1:1
#define AFI_IDDQ_MODE_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_IDDQ_MODE_ACK_WOFFSET                     0x0
#define AFI_IDDQ_MODE_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_IDDQ_MODE_ACK_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_IDDQ_MODE_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_IDDQ_MODE_ACK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_IDDQ_MODE_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_IDDQ_MODE_ACK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_IDDQ_MODE_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_IDDQ_MODE_ACK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register AFI_PLL_RESET_ACK_0  
#define AFI_PLL_RESET_ACK_0                     _MK_ADDR_CONST(0xe8)
#define AFI_PLL_RESET_ACK_0_SECURE                      0x0
#define AFI_PLL_RESET_ACK_0_WORD_COUNT                  0x1
#define AFI_PLL_RESET_ACK_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define AFI_PLL_RESET_ACK_0_RESET_MASK                  _MK_MASK_CONST(0x3)
#define AFI_PLL_RESET_ACK_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define AFI_PLL_RESET_ACK_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AFI_PLL_RESET_ACK_0_READ_MASK                   _MK_MASK_CONST(0x3)
#define AFI_PLL_RESET_ACK_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
//SM (system management) to PCIE PLL assert Reset Ack
#define AFI_PLL_RESET_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_RST_ACK_SHIFT                       _MK_SHIFT_CONST(0)
#define AFI_PLL_RESET_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_RST_ACK_FIELD                       (_MK_MASK_CONST(0x1) << AFI_PLL_RESET_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_RST_ACK_SHIFT)
#define AFI_PLL_RESET_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_RST_ACK_RANGE                       0:0
#define AFI_PLL_RESET_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_RST_ACK_WOFFSET                     0x0
#define AFI_PLL_RESET_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_RST_ACK_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_PLL_RESET_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_RST_ACK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_PLL_RESET_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_RST_ACK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_PLL_RESET_ACK_0_PCIE2SM_ASSERT_PEX0_PLL_RST_ACK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//SM (system management) to PCIE PLL deassert Reset Ack
#define AFI_PLL_RESET_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_RST_ACK_SHIFT                     _MK_SHIFT_CONST(1)
#define AFI_PLL_RESET_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_RST_ACK_FIELD                     (_MK_MASK_CONST(0x1) << AFI_PLL_RESET_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_RST_ACK_SHIFT)
#define AFI_PLL_RESET_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_RST_ACK_RANGE                     1:1
#define AFI_PLL_RESET_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_RST_ACK_WOFFSET                   0x0
#define AFI_PLL_RESET_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_RST_ACK_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_PLL_RESET_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_RST_ACK_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AFI_PLL_RESET_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_RST_ACK_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_PLL_RESET_ACK_0_PCIE2SM_DEASSERT_PEX0_PLL_RST_ACK_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register AFI_PCIE_THROTTLE_0  
#define AFI_PCIE_THROTTLE_0                     _MK_ADDR_CONST(0xec)
#define AFI_PCIE_THROTTLE_0_SECURE                      0x0
#define AFI_PCIE_THROTTLE_0_WORD_COUNT                  0x1
#define AFI_PCIE_THROTTLE_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define AFI_PCIE_THROTTLE_0_RESET_MASK                  _MK_MASK_CONST(0x8000fff7)
#define AFI_PCIE_THROTTLE_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define AFI_PCIE_THROTTLE_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AFI_PCIE_THROTTLE_0_READ_MASK                   _MK_MASK_CONST(0x8000fff7)
#define AFI_PCIE_THROTTLE_0_WRITE_MASK                  _MK_MASK_CONST(0x8000fff7)
//Override THERM MGMT duty cycle
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_DUTY_CYCLE_SHIFT                      _MK_SHIFT_CONST(0)
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_DUTY_CYCLE_FIELD                      (_MK_MASK_CONST(0x7) << AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_DUTY_CYCLE_SHIFT)
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_DUTY_CYCLE_RANGE                      2:0
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_DUTY_CYCLE_WOFFSET                    0x0
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_DUTY_CYCLE_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_DUTY_CYCLE_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_DUTY_CYCLE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_DUTY_CYCLE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//Override THERM MGMT period
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_PERIOD_SHIFT                  _MK_SHIFT_CONST(4)
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_PERIOD_FIELD                  (_MK_MASK_CONST(0xfff) << AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_PERIOD_SHIFT)
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_PERIOD_RANGE                  15:4
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_PERIOD_WOFFSET                        0x0
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_PERIOD_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_PERIOD_DEFAULT_MASK                   _MK_MASK_CONST(0xfff)
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_PERIOD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_PERIOD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//Override THERM MGMT 
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_EN_SHIFT                      _MK_SHIFT_CONST(31)
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_EN_FIELD                      (_MK_MASK_CONST(0x1) << AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_EN_SHIFT)
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_EN_RANGE                      31:31
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_EN_WOFFSET                    0x0
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_PCIE_THROTTLE_0_SM2PCIE_THROT_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register AFI_PME_0  
#define AFI_PME_0                       _MK_ADDR_CONST(0xf0)
#define AFI_PME_0_SECURE                        0x0
#define AFI_PME_0_WORD_COUNT                    0x1
#define AFI_PME_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_PME_0_RESET_MASK                    _MK_MASK_CONST(0x1ff1)
#define AFI_PME_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_PME_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_PME_0_READ_MASK                     _MK_MASK_CONST(0x1ff1)
#define AFI_PME_0_WRITE_MASK                    _MK_MASK_CONST(0x101)
//SM (system management) to PCIE PME Turn Off
#define AFI_PME_0_SM2TMS0C0_PME_TO_SHIFT                        _MK_SHIFT_CONST(0)
#define AFI_PME_0_SM2TMS0C0_PME_TO_FIELD                        (_MK_MASK_CONST(0x1) << AFI_PME_0_SM2TMS0C0_PME_TO_SHIFT)
#define AFI_PME_0_SM2TMS0C0_PME_TO_RANGE                        0:0
#define AFI_PME_0_SM2TMS0C0_PME_TO_WOFFSET                      0x0
#define AFI_PME_0_SM2TMS0C0_PME_TO_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_PME_0_SM2TMS0C0_PME_TO_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AFI_PME_0_SM2TMS0C0_PME_TO_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_PME_0_SM2TMS0C0_PME_TO_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//PCIE Endpoint PME message
#define AFI_PME_0_TMS0C02SM_PME_SHIFT                   _MK_SHIFT_CONST(4)
#define AFI_PME_0_TMS0C02SM_PME_FIELD                   (_MK_MASK_CONST(0x1) << AFI_PME_0_TMS0C02SM_PME_SHIFT)
#define AFI_PME_0_TMS0C02SM_PME_RANGE                   4:4
#define AFI_PME_0_TMS0C02SM_PME_WOFFSET                 0x0
#define AFI_PME_0_TMS0C02SM_PME_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_PME_0_TMS0C02SM_PME_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AFI_PME_0_TMS0C02SM_PME_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_PME_0_TMS0C02SM_PME_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//PCIE Endpoint PME Ack
#define AFI_PME_0_TMS0C02SM_PME_ACK_SHIFT                       _MK_SHIFT_CONST(5)
#define AFI_PME_0_TMS0C02SM_PME_ACK_FIELD                       (_MK_MASK_CONST(0x1) << AFI_PME_0_TMS0C02SM_PME_ACK_SHIFT)
#define AFI_PME_0_TMS0C02SM_PME_ACK_RANGE                       5:5
#define AFI_PME_0_TMS0C02SM_PME_ACK_WOFFSET                     0x0
#define AFI_PME_0_TMS0C02SM_PME_ACK_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_PME_0_TMS0C02SM_PME_ACK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_PME_0_TMS0C02SM_PME_ACK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_PME_0_TMS0C02SM_PME_ACK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//PCIE Link Presence State
#define AFI_PME_0_TMS0C02SM_PRESENCE_STATE_SHIFT                        _MK_SHIFT_CONST(6)
#define AFI_PME_0_TMS0C02SM_PRESENCE_STATE_FIELD                        (_MK_MASK_CONST(0x1) << AFI_PME_0_TMS0C02SM_PRESENCE_STATE_SHIFT)
#define AFI_PME_0_TMS0C02SM_PRESENCE_STATE_RANGE                        6:6
#define AFI_PME_0_TMS0C02SM_PRESENCE_STATE_WOFFSET                      0x0
#define AFI_PME_0_TMS0C02SM_PRESENCE_STATE_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_PME_0_TMS0C02SM_PRESENCE_STATE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AFI_PME_0_TMS0C02SM_PRESENCE_STATE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_PME_0_TMS0C02SM_PRESENCE_STATE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//LTSSM ready for Power Down
#define AFI_PME_0_TMS0C02SM_LTSSM_READY_FOR_PD_SHIFT                    _MK_SHIFT_CONST(7)
#define AFI_PME_0_TMS0C02SM_LTSSM_READY_FOR_PD_FIELD                    (_MK_MASK_CONST(0x1) << AFI_PME_0_TMS0C02SM_LTSSM_READY_FOR_PD_SHIFT)
#define AFI_PME_0_TMS0C02SM_LTSSM_READY_FOR_PD_RANGE                    7:7
#define AFI_PME_0_TMS0C02SM_LTSSM_READY_FOR_PD_WOFFSET                  0x0
#define AFI_PME_0_TMS0C02SM_LTSSM_READY_FOR_PD_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_PME_0_TMS0C02SM_LTSSM_READY_FOR_PD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AFI_PME_0_TMS0C02SM_LTSSM_READY_FOR_PD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_PME_0_TMS0C02SM_LTSSM_READY_FOR_PD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//SM (system management) to PCIE PME Turn Off
#define AFI_PME_0_SM2TMS0C1_PME_TO_SHIFT                        _MK_SHIFT_CONST(8)
#define AFI_PME_0_SM2TMS0C1_PME_TO_FIELD                        (_MK_MASK_CONST(0x1) << AFI_PME_0_SM2TMS0C1_PME_TO_SHIFT)
#define AFI_PME_0_SM2TMS0C1_PME_TO_RANGE                        8:8
#define AFI_PME_0_SM2TMS0C1_PME_TO_WOFFSET                      0x0
#define AFI_PME_0_SM2TMS0C1_PME_TO_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_PME_0_SM2TMS0C1_PME_TO_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AFI_PME_0_SM2TMS0C1_PME_TO_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_PME_0_SM2TMS0C1_PME_TO_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//PCIE Endpoint PME message
#define AFI_PME_0_TMS0C12SM_PME_SHIFT                   _MK_SHIFT_CONST(9)
#define AFI_PME_0_TMS0C12SM_PME_FIELD                   (_MK_MASK_CONST(0x1) << AFI_PME_0_TMS0C12SM_PME_SHIFT)
#define AFI_PME_0_TMS0C12SM_PME_RANGE                   9:9
#define AFI_PME_0_TMS0C12SM_PME_WOFFSET                 0x0
#define AFI_PME_0_TMS0C12SM_PME_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_PME_0_TMS0C12SM_PME_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AFI_PME_0_TMS0C12SM_PME_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_PME_0_TMS0C12SM_PME_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//PCIE Endpoint PME Ack
#define AFI_PME_0_TMS0C12SM_PME_ACK_SHIFT                       _MK_SHIFT_CONST(10)
#define AFI_PME_0_TMS0C12SM_PME_ACK_FIELD                       (_MK_MASK_CONST(0x1) << AFI_PME_0_TMS0C12SM_PME_ACK_SHIFT)
#define AFI_PME_0_TMS0C12SM_PME_ACK_RANGE                       10:10
#define AFI_PME_0_TMS0C12SM_PME_ACK_WOFFSET                     0x0
#define AFI_PME_0_TMS0C12SM_PME_ACK_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_PME_0_TMS0C12SM_PME_ACK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_PME_0_TMS0C12SM_PME_ACK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_PME_0_TMS0C12SM_PME_ACK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//PCIE Link Presence State
#define AFI_PME_0_TMS0C12SM_PRESENCE_STATE_SHIFT                        _MK_SHIFT_CONST(11)
#define AFI_PME_0_TMS0C12SM_PRESENCE_STATE_FIELD                        (_MK_MASK_CONST(0x1) << AFI_PME_0_TMS0C12SM_PRESENCE_STATE_SHIFT)
#define AFI_PME_0_TMS0C12SM_PRESENCE_STATE_RANGE                        11:11
#define AFI_PME_0_TMS0C12SM_PRESENCE_STATE_WOFFSET                      0x0
#define AFI_PME_0_TMS0C12SM_PRESENCE_STATE_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_PME_0_TMS0C12SM_PRESENCE_STATE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AFI_PME_0_TMS0C12SM_PRESENCE_STATE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_PME_0_TMS0C12SM_PRESENCE_STATE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//LTSSM ready for Power Down
#define AFI_PME_0_TMS0C12SM_LTSSM_READY_FOR_PD_SHIFT                    _MK_SHIFT_CONST(12)
#define AFI_PME_0_TMS0C12SM_LTSSM_READY_FOR_PD_FIELD                    (_MK_MASK_CONST(0x1) << AFI_PME_0_TMS0C12SM_LTSSM_READY_FOR_PD_SHIFT)
#define AFI_PME_0_TMS0C12SM_LTSSM_READY_FOR_PD_RANGE                    12:12
#define AFI_PME_0_TMS0C12SM_LTSSM_READY_FOR_PD_WOFFSET                  0x0
#define AFI_PME_0_TMS0C12SM_LTSSM_READY_FOR_PD_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_PME_0_TMS0C12SM_LTSSM_READY_FOR_PD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AFI_PME_0_TMS0C12SM_LTSSM_READY_FOR_PD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_PME_0_TMS0C12SM_LTSSM_READY_FOR_PD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register AFI_REQ_PENDING_0  
#define AFI_REQ_PENDING_0                       _MK_ADDR_CONST(0xf4)
#define AFI_REQ_PENDING_0_SECURE                        0x0
#define AFI_REQ_PENDING_0_WORD_COUNT                    0x1
#define AFI_REQ_PENDING_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_RESET_MASK                    _MK_MASK_CONST(0xff)
#define AFI_REQ_PENDING_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define AFI_REQ_PENDING_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
//SM (system management) status that coherent request pending 
//from PCIE to FPCI
#define AFI_REQ_PENDING_0_TMS0C02SM_COH_REQUEST_PEND_SHIFT                      _MK_SHIFT_CONST(0)
#define AFI_REQ_PENDING_0_TMS0C02SM_COH_REQUEST_PEND_FIELD                      (_MK_MASK_CONST(0x1) << AFI_REQ_PENDING_0_TMS0C02SM_COH_REQUEST_PEND_SHIFT)
#define AFI_REQ_PENDING_0_TMS0C02SM_COH_REQUEST_PEND_RANGE                      0:0
#define AFI_REQ_PENDING_0_TMS0C02SM_COH_REQUEST_PEND_WOFFSET                    0x0
#define AFI_REQ_PENDING_0_TMS0C02SM_COH_REQUEST_PEND_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_TMS0C02SM_COH_REQUEST_PEND_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AFI_REQ_PENDING_0_TMS0C02SM_COH_REQUEST_PEND_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_TMS0C02SM_COH_REQUEST_PEND_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//SM (system management) status that Non-coherent request pending 
//from PCIE to FPCI
#define AFI_REQ_PENDING_0_TMS0C02SM_NONCOH_REQUEST_PEND_SHIFT                   _MK_SHIFT_CONST(1)
#define AFI_REQ_PENDING_0_TMS0C02SM_NONCOH_REQUEST_PEND_FIELD                   (_MK_MASK_CONST(0x1) << AFI_REQ_PENDING_0_TMS0C02SM_NONCOH_REQUEST_PEND_SHIFT)
#define AFI_REQ_PENDING_0_TMS0C02SM_NONCOH_REQUEST_PEND_RANGE                   1:1
#define AFI_REQ_PENDING_0_TMS0C02SM_NONCOH_REQUEST_PEND_WOFFSET                 0x0
#define AFI_REQ_PENDING_0_TMS0C02SM_NONCOH_REQUEST_PEND_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_TMS0C02SM_NONCOH_REQUEST_PEND_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AFI_REQ_PENDING_0_TMS0C02SM_NONCOH_REQUEST_PEND_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_TMS0C02SM_NONCOH_REQUEST_PEND_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//SM (system management) status that ISO request pending 
//from PCIE to FPCI
#define AFI_REQ_PENDING_0_TMS0C02SM_ISO_PENDING_SHIFT                   _MK_SHIFT_CONST(2)
#define AFI_REQ_PENDING_0_TMS0C02SM_ISO_PENDING_FIELD                   (_MK_MASK_CONST(0x1) << AFI_REQ_PENDING_0_TMS0C02SM_ISO_PENDING_SHIFT)
#define AFI_REQ_PENDING_0_TMS0C02SM_ISO_PENDING_RANGE                   2:2
#define AFI_REQ_PENDING_0_TMS0C02SM_ISO_PENDING_WOFFSET                 0x0
#define AFI_REQ_PENDING_0_TMS0C02SM_ISO_PENDING_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_TMS0C02SM_ISO_PENDING_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AFI_REQ_PENDING_0_TMS0C02SM_ISO_PENDING_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_TMS0C02SM_ISO_PENDING_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//SM (system management) status that Non-ISO request pending 
//from PCIE to FPCI
#define AFI_REQ_PENDING_0_TMS0C02SM_NONISO_PENDING_SHIFT                        _MK_SHIFT_CONST(3)
#define AFI_REQ_PENDING_0_TMS0C02SM_NONISO_PENDING_FIELD                        (_MK_MASK_CONST(0x1) << AFI_REQ_PENDING_0_TMS0C02SM_NONISO_PENDING_SHIFT)
#define AFI_REQ_PENDING_0_TMS0C02SM_NONISO_PENDING_RANGE                        3:3
#define AFI_REQ_PENDING_0_TMS0C02SM_NONISO_PENDING_WOFFSET                      0x0
#define AFI_REQ_PENDING_0_TMS0C02SM_NONISO_PENDING_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_TMS0C02SM_NONISO_PENDING_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AFI_REQ_PENDING_0_TMS0C02SM_NONISO_PENDING_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_TMS0C02SM_NONISO_PENDING_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//SM (system management) status that coherent request pending 
//from PCIE to FPCI
#define AFI_REQ_PENDING_0_TMS0C12SM_COH_REQUEST_PEND_SHIFT                      _MK_SHIFT_CONST(4)
#define AFI_REQ_PENDING_0_TMS0C12SM_COH_REQUEST_PEND_FIELD                      (_MK_MASK_CONST(0x1) << AFI_REQ_PENDING_0_TMS0C12SM_COH_REQUEST_PEND_SHIFT)
#define AFI_REQ_PENDING_0_TMS0C12SM_COH_REQUEST_PEND_RANGE                      4:4
#define AFI_REQ_PENDING_0_TMS0C12SM_COH_REQUEST_PEND_WOFFSET                    0x0
#define AFI_REQ_PENDING_0_TMS0C12SM_COH_REQUEST_PEND_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_TMS0C12SM_COH_REQUEST_PEND_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AFI_REQ_PENDING_0_TMS0C12SM_COH_REQUEST_PEND_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_TMS0C12SM_COH_REQUEST_PEND_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//SM (system management) status that Non-coherent request pending 
//from PCIE to FPCI
#define AFI_REQ_PENDING_0_TMS0C12SM_NONCOH_REQUEST_PEND_SHIFT                   _MK_SHIFT_CONST(5)
#define AFI_REQ_PENDING_0_TMS0C12SM_NONCOH_REQUEST_PEND_FIELD                   (_MK_MASK_CONST(0x1) << AFI_REQ_PENDING_0_TMS0C12SM_NONCOH_REQUEST_PEND_SHIFT)
#define AFI_REQ_PENDING_0_TMS0C12SM_NONCOH_REQUEST_PEND_RANGE                   5:5
#define AFI_REQ_PENDING_0_TMS0C12SM_NONCOH_REQUEST_PEND_WOFFSET                 0x0
#define AFI_REQ_PENDING_0_TMS0C12SM_NONCOH_REQUEST_PEND_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_TMS0C12SM_NONCOH_REQUEST_PEND_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AFI_REQ_PENDING_0_TMS0C12SM_NONCOH_REQUEST_PEND_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_TMS0C12SM_NONCOH_REQUEST_PEND_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//SM (system management) status that ISO request pending 
//from PCIE to FPCI
#define AFI_REQ_PENDING_0_TMS0C12SM_ISO_PENDING_SHIFT                   _MK_SHIFT_CONST(6)
#define AFI_REQ_PENDING_0_TMS0C12SM_ISO_PENDING_FIELD                   (_MK_MASK_CONST(0x1) << AFI_REQ_PENDING_0_TMS0C12SM_ISO_PENDING_SHIFT)
#define AFI_REQ_PENDING_0_TMS0C12SM_ISO_PENDING_RANGE                   6:6
#define AFI_REQ_PENDING_0_TMS0C12SM_ISO_PENDING_WOFFSET                 0x0
#define AFI_REQ_PENDING_0_TMS0C12SM_ISO_PENDING_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_TMS0C12SM_ISO_PENDING_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AFI_REQ_PENDING_0_TMS0C12SM_ISO_PENDING_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_TMS0C12SM_ISO_PENDING_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//SM (system management) status that Non-ISO request pending 
//from PCIE to FPCI
#define AFI_REQ_PENDING_0_TMS0C12SM_NONISO_PENDING_SHIFT                        _MK_SHIFT_CONST(7)
#define AFI_REQ_PENDING_0_TMS0C12SM_NONISO_PENDING_FIELD                        (_MK_MASK_CONST(0x1) << AFI_REQ_PENDING_0_TMS0C12SM_NONISO_PENDING_SHIFT)
#define AFI_REQ_PENDING_0_TMS0C12SM_NONISO_PENDING_RANGE                        7:7
#define AFI_REQ_PENDING_0_TMS0C12SM_NONISO_PENDING_WOFFSET                      0x0
#define AFI_REQ_PENDING_0_TMS0C12SM_NONISO_PENDING_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_TMS0C12SM_NONISO_PENDING_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AFI_REQ_PENDING_0_TMS0C12SM_NONISO_PENDING_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_REQ_PENDING_0_TMS0C12SM_NONISO_PENDING_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register AFI_PCIE_CONFIG_0  
#define AFI_PCIE_CONFIG_0                       _MK_ADDR_CONST(0xf8)
#define AFI_PCIE_CONFIG_0_SECURE                        0x0
#define AFI_PCIE_CONFIG_0_WORD_COUNT                    0x1
#define AFI_PCIE_CONFIG_0_RESET_VAL                     _MK_MASK_CONST(0x3024)
#define AFI_PCIE_CONFIG_0_RESET_MASK                    _MK_MASK_CONST(0xf1f1f7)
#define AFI_PCIE_CONFIG_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_PCIE_CONFIG_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_PCIE_CONFIG_0_READ_MASK                     _MK_MASK_CONST(0xf1f1f7)
#define AFI_PCIE_CONFIG_0_WRITE_MASK                    _MK_MASK_CONST(0xf1f1f7)
//CYA to indicate PCIE slot empty.  Overrides PCIE slot present input.
#define AFI_PCIE_CONFIG_0_SM2TGIO_SLOT_EMPTY_PD_CYA_SHIFT                       _MK_SHIFT_CONST(0)
#define AFI_PCIE_CONFIG_0_SM2TGIO_SLOT_EMPTY_PD_CYA_FIELD                       (_MK_MASK_CONST(0x1) << AFI_PCIE_CONFIG_0_SM2TGIO_SLOT_EMPTY_PD_CYA_SHIFT)
#define AFI_PCIE_CONFIG_0_SM2TGIO_SLOT_EMPTY_PD_CYA_RANGE                       0:0
#define AFI_PCIE_CONFIG_0_SM2TGIO_SLOT_EMPTY_PD_CYA_WOFFSET                     0x0
#define AFI_PCIE_CONFIG_0_SM2TGIO_SLOT_EMPTY_PD_CYA_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_PCIE_CONFIG_0_SM2TGIO_SLOT_EMPTY_PD_CYA_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_PCIE_CONFIG_0_SM2TGIO_SLOT_EMPTY_PD_CYA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_PCIE_CONFIG_0_SM2TGIO_SLOT_EMPTY_PD_CYA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//Disable PCIE Controller 0 (default off)
#define AFI_PCIE_CONFIG_0_PCIEC0_DISABLE_DEVICE_SHIFT                   _MK_SHIFT_CONST(1)
#define AFI_PCIE_CONFIG_0_PCIEC0_DISABLE_DEVICE_FIELD                   (_MK_MASK_CONST(0x1) << AFI_PCIE_CONFIG_0_PCIEC0_DISABLE_DEVICE_SHIFT)
#define AFI_PCIE_CONFIG_0_PCIEC0_DISABLE_DEVICE_RANGE                   1:1
#define AFI_PCIE_CONFIG_0_PCIEC0_DISABLE_DEVICE_WOFFSET                 0x0
#define AFI_PCIE_CONFIG_0_PCIEC0_DISABLE_DEVICE_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_PCIE_CONFIG_0_PCIEC0_DISABLE_DEVICE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AFI_PCIE_CONFIG_0_PCIEC0_DISABLE_DEVICE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_PCIE_CONFIG_0_PCIEC0_DISABLE_DEVICE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Disable PCIE Controller 1 (default on)
#define AFI_PCIE_CONFIG_0_PCIEC1_DISABLE_DEVICE_SHIFT                   _MK_SHIFT_CONST(2)
#define AFI_PCIE_CONFIG_0_PCIEC1_DISABLE_DEVICE_FIELD                   (_MK_MASK_CONST(0x1) << AFI_PCIE_CONFIG_0_PCIEC1_DISABLE_DEVICE_SHIFT)
#define AFI_PCIE_CONFIG_0_PCIEC1_DISABLE_DEVICE_RANGE                   2:2
#define AFI_PCIE_CONFIG_0_PCIEC1_DISABLE_DEVICE_WOFFSET                 0x0
#define AFI_PCIE_CONFIG_0_PCIEC1_DISABLE_DEVICE_DEFAULT                 _MK_MASK_CONST(0x1)
#define AFI_PCIE_CONFIG_0_PCIEC1_DISABLE_DEVICE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AFI_PCIE_CONFIG_0_PCIEC1_DISABLE_DEVICE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_PCIE_CONFIG_0_PCIEC1_DISABLE_DEVICE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//T0C0 Upstream FPCI Unit ID.  HyperTransport, upstream FPCI request
#define AFI_PCIE_CONFIG_0_UNITID_T0C0_SHIFT                     _MK_SHIFT_CONST(4)
#define AFI_PCIE_CONFIG_0_UNITID_T0C0_FIELD                     (_MK_MASK_CONST(0x1f) << AFI_PCIE_CONFIG_0_UNITID_T0C0_SHIFT)
#define AFI_PCIE_CONFIG_0_UNITID_T0C0_RANGE                     8:4
#define AFI_PCIE_CONFIG_0_UNITID_T0C0_WOFFSET                   0x0
#define AFI_PCIE_CONFIG_0_UNITID_T0C0_DEFAULT                   _MK_MASK_CONST(0x2)
#define AFI_PCIE_CONFIG_0_UNITID_T0C0_DEFAULT_MASK                      _MK_MASK_CONST(0x1f)
#define AFI_PCIE_CONFIG_0_UNITID_T0C0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_PCIE_CONFIG_0_UNITID_T0C0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//T0C1 Upstream FPCI Unit ID.  HyperTransport, upstream FPCI request
//Downstream FPCI unit ID should remain 0.
#define AFI_PCIE_CONFIG_0_UNITID_T0C1_SHIFT                     _MK_SHIFT_CONST(12)
#define AFI_PCIE_CONFIG_0_UNITID_T0C1_FIELD                     (_MK_MASK_CONST(0x1f) << AFI_PCIE_CONFIG_0_UNITID_T0C1_SHIFT)
#define AFI_PCIE_CONFIG_0_UNITID_T0C1_RANGE                     16:12
#define AFI_PCIE_CONFIG_0_UNITID_T0C1_WOFFSET                   0x0
#define AFI_PCIE_CONFIG_0_UNITID_T0C1_DEFAULT                   _MK_MASK_CONST(0x3)
#define AFI_PCIE_CONFIG_0_UNITID_T0C1_DEFAULT_MASK                      _MK_MASK_CONST(0x1f)
#define AFI_PCIE_CONFIG_0_UNITID_T0C1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_PCIE_CONFIG_0_UNITID_T0C1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//SM (system management) configuration of PCIE crossbar.  
//There are 2 possible configurations for PCIE crossbar:
//  0  :  Single controller - T0C0 4 lanes
//  1  :  Dual controller - T0C0 2 lanes/T0C1 2 lanes
#define AFI_PCIE_CONFIG_0_SM2TMS0_XBAR_CONFIG_SHIFT                     _MK_SHIFT_CONST(20)
#define AFI_PCIE_CONFIG_0_SM2TMS0_XBAR_CONFIG_FIELD                     (_MK_MASK_CONST(0xf) << AFI_PCIE_CONFIG_0_SM2TMS0_XBAR_CONFIG_SHIFT)
#define AFI_PCIE_CONFIG_0_SM2TMS0_XBAR_CONFIG_RANGE                     23:20
#define AFI_PCIE_CONFIG_0_SM2TMS0_XBAR_CONFIG_WOFFSET                   0x0
#define AFI_PCIE_CONFIG_0_SM2TMS0_XBAR_CONFIG_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_PCIE_CONFIG_0_SM2TMS0_XBAR_CONFIG_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define AFI_PCIE_CONFIG_0_SM2TMS0_XBAR_CONFIG_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_PCIE_CONFIG_0_SM2TMS0_XBAR_CONFIG_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register AFI_REV_ID_0  
#define AFI_REV_ID_0                    _MK_ADDR_CONST(0xfc)
#define AFI_REV_ID_0_SECURE                     0x0
#define AFI_REV_ID_0_WORD_COUNT                         0x1
#define AFI_REV_ID_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define AFI_REV_ID_0_RESET_MASK                         _MK_MASK_CONST(0x3)
#define AFI_REV_ID_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define AFI_REV_ID_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AFI_REV_ID_0_READ_MASK                  _MK_MASK_CONST(0x3)
#define AFI_REV_ID_0_WRITE_MASK                         _MK_MASK_CONST(0x3)
//Override for PCI config revision id read-only register.  
//This allows backdoor changes to rev ID for metal spins.
#define AFI_REV_ID_0_CFG_REVID_OVERRIDE_SHIFT                   _MK_SHIFT_CONST(0)
#define AFI_REV_ID_0_CFG_REVID_OVERRIDE_FIELD                   (_MK_MASK_CONST(0x1) << AFI_REV_ID_0_CFG_REVID_OVERRIDE_SHIFT)
#define AFI_REV_ID_0_CFG_REVID_OVERRIDE_RANGE                   0:0
#define AFI_REV_ID_0_CFG_REVID_OVERRIDE_WOFFSET                 0x0
#define AFI_REV_ID_0_CFG_REVID_OVERRIDE_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_REV_ID_0_CFG_REVID_OVERRIDE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AFI_REV_ID_0_CFG_REVID_OVERRIDE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_REV_ID_0_CFG_REVID_OVERRIDE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Write Enable for PCI backdoor rev ID override value.
#define AFI_REV_ID_0_CFG_REVID_WRITE_ENABLE_SHIFT                       _MK_SHIFT_CONST(1)
#define AFI_REV_ID_0_CFG_REVID_WRITE_ENABLE_FIELD                       (_MK_MASK_CONST(0x1) << AFI_REV_ID_0_CFG_REVID_WRITE_ENABLE_SHIFT)
#define AFI_REV_ID_0_CFG_REVID_WRITE_ENABLE_RANGE                       1:1
#define AFI_REV_ID_0_CFG_REVID_WRITE_ENABLE_WOFFSET                     0x0
#define AFI_REV_ID_0_CFG_REVID_WRITE_ENABLE_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_REV_ID_0_CFG_REVID_WRITE_ENABLE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_REV_ID_0_CFG_REVID_WRITE_ENABLE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_REV_ID_0_CFG_REVID_WRITE_ENABLE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register AFI_TOM_0  
#define AFI_TOM_0                       _MK_ADDR_CONST(0x100)
#define AFI_TOM_0_SECURE                        0x0
#define AFI_TOM_0_WORD_COUNT                    0x1
#define AFI_TOM_0_RESET_VAL                     _MK_MASK_CONST(0x3f3f003f)
#define AFI_TOM_0_RESET_MASK                    _MK_MASK_CONST(0x3fff003f)
#define AFI_TOM_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_TOM_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_TOM_0_READ_MASK                     _MK_MASK_CONST(0x3fff003f)
#define AFI_TOM_0_WRITE_MASK                    _MK_MASK_CONST(0x3fff003f)
//Top of Memory Limit 1.  Determines peer-to-peer range as:
//{TOM1 :: 26'b0} to 0xFFFF_FFFF (except MSI region)
#define AFI_TOM_0_DLDT2ALL_TOM1_SHIFT                   _MK_SHIFT_CONST(0)
#define AFI_TOM_0_DLDT2ALL_TOM1_FIELD                   (_MK_MASK_CONST(0x3f) << AFI_TOM_0_DLDT2ALL_TOM1_SHIFT)
#define AFI_TOM_0_DLDT2ALL_TOM1_RANGE                   5:0
#define AFI_TOM_0_DLDT2ALL_TOM1_WOFFSET                 0x0
#define AFI_TOM_0_DLDT2ALL_TOM1_DEFAULT                 _MK_MASK_CONST(0x3f)
#define AFI_TOM_0_DLDT2ALL_TOM1_DEFAULT_MASK                    _MK_MASK_CONST(0x3f)
#define AFI_TOM_0_DLDT2ALL_TOM1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_TOM_0_DLDT2ALL_TOM1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Top of Memory Limit 2.  Determines peer-to-peer range as:
//{TOM2 :: 26'b0} to 0xFC_FFFF_FFFF
#define AFI_TOM_0_DLDT2ALL_TOM2_SHIFT                   _MK_SHIFT_CONST(16)
#define AFI_TOM_0_DLDT2ALL_TOM2_FIELD                   (_MK_MASK_CONST(0x3fff) << AFI_TOM_0_DLDT2ALL_TOM2_SHIFT)
#define AFI_TOM_0_DLDT2ALL_TOM2_RANGE                   29:16
#define AFI_TOM_0_DLDT2ALL_TOM2_WOFFSET                 0x0
#define AFI_TOM_0_DLDT2ALL_TOM2_DEFAULT                 _MK_MASK_CONST(0x3f3f)
#define AFI_TOM_0_DLDT2ALL_TOM2_DEFAULT_MASK                    _MK_MASK_CONST(0x3fff)
#define AFI_TOM_0_DLDT2ALL_TOM2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_TOM_0_DLDT2ALL_TOM2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register AFI_FUSE_0  
#define AFI_FUSE_0                      _MK_ADDR_CONST(0x104)
#define AFI_FUSE_0_SECURE                       0x0
#define AFI_FUSE_0_WORD_COUNT                   0x1
#define AFI_FUSE_0_RESET_VAL                    _MK_MASK_CONST(0x336)
#define AFI_FUSE_0_RESET_MASK                   _MK_MASK_CONST(0x777)
#define AFI_FUSE_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define AFI_FUSE_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define AFI_FUSE_0_READ_MASK                    _MK_MASK_CONST(0x777)
#define AFI_FUSE_0_WRITE_MASK                   _MK_MASK_CONST(0x777)
//Enable advanced error reporting capability of PCIE.  
//This should remain off for AP20.
#define AFI_FUSE_0_FUSE_PCIE_AER_EN_SHIFT                       _MK_SHIFT_CONST(0)
#define AFI_FUSE_0_FUSE_PCIE_AER_EN_FIELD                       (_MK_MASK_CONST(0x1) << AFI_FUSE_0_FUSE_PCIE_AER_EN_SHIFT)
#define AFI_FUSE_0_FUSE_PCIE_AER_EN_RANGE                       0:0
#define AFI_FUSE_0_FUSE_PCIE_AER_EN_WOFFSET                     0x0
#define AFI_FUSE_0_FUSE_PCIE_AER_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_FUSE_0_FUSE_PCIE_AER_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AFI_FUSE_0_FUSE_PCIE_AER_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_FUSE_0_FUSE_PCIE_AER_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//Disable SLI capability for GPU.  This should remain on for AP20.
#define AFI_FUSE_0_FUSE_PCIE_SLI_DIS_SHIFT                      _MK_SHIFT_CONST(1)
#define AFI_FUSE_0_FUSE_PCIE_SLI_DIS_FIELD                      (_MK_MASK_CONST(0x1) << AFI_FUSE_0_FUSE_PCIE_SLI_DIS_SHIFT)
#define AFI_FUSE_0_FUSE_PCIE_SLI_DIS_RANGE                      1:1
#define AFI_FUSE_0_FUSE_PCIE_SLI_DIS_WOFFSET                    0x0
#define AFI_FUSE_0_FUSE_PCIE_SLI_DIS_DEFAULT                    _MK_MASK_CONST(0x1)
#define AFI_FUSE_0_FUSE_PCIE_SLI_DIS_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AFI_FUSE_0_FUSE_PCIE_SLI_DIS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_FUSE_0_FUSE_PCIE_SLI_DIS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//Disable Gen 2 capability of PCIE.  This should remain on for AP20.
#define AFI_FUSE_0_FUSE_PCIE_T0_GEN2_DIS_SHIFT                  _MK_SHIFT_CONST(2)
#define AFI_FUSE_0_FUSE_PCIE_T0_GEN2_DIS_FIELD                  (_MK_MASK_CONST(0x1) << AFI_FUSE_0_FUSE_PCIE_T0_GEN2_DIS_SHIFT)
#define AFI_FUSE_0_FUSE_PCIE_T0_GEN2_DIS_RANGE                  2:2
#define AFI_FUSE_0_FUSE_PCIE_T0_GEN2_DIS_WOFFSET                        0x0
#define AFI_FUSE_0_FUSE_PCIE_T0_GEN2_DIS_DEFAULT                        _MK_MASK_CONST(0x1)
#define AFI_FUSE_0_FUSE_PCIE_T0_GEN2_DIS_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AFI_FUSE_0_FUSE_PCIE_T0_GEN2_DIS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_FUSE_0_FUSE_PCIE_T0_GEN2_DIS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//Configure PCIE as x1, x2, x4, x8, or x16.  
//This should remain 3'b011 for AP20
#define AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C0_SHIFT                   _MK_SHIFT_CONST(4)
#define AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C0_FIELD                   (_MK_MASK_CONST(0x7) << AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C0_SHIFT)
#define AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C0_RANGE                   6:4
#define AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C0_WOFFSET                 0x0
#define AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C0_DEFAULT                 _MK_MASK_CONST(0x3)
#define AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C0_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Configure PCIE as x1, x2, x4, x8, or x16.  
//This should remain 3'b011 for AP20
#define AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C1_SHIFT                   _MK_SHIFT_CONST(8)
#define AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C1_FIELD                   (_MK_MASK_CONST(0x7) << AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C1_SHIFT)
#define AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C1_RANGE                   10:8
#define AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C1_WOFFSET                 0x0
#define AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C1_DEFAULT                 _MK_MASK_CONST(0x3)
#define AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C1_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_FUSE_0_FUSE_PCIE_WIDTH_T0C1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register AFI_PMU_0  
#define AFI_PMU_0                       _MK_ADDR_CONST(0x108)
#define AFI_PMU_0_SECURE                        0x0
#define AFI_PMU_0_WORD_COUNT                    0x1
#define AFI_PMU_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_PMU_0_RESET_MASK                    _MK_MASK_CONST(0x1f1fff1)
#define AFI_PMU_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_PMU_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_PMU_0_READ_MASK                     _MK_MASK_CONST(0x1f1fff1)
#define AFI_PMU_0_WRITE_MASK                    _MK_MASK_CONST(0xff1)
//PMU Load Indicator Enable.  
//This is used for wall-plug applications and should remain off for AP20.
#define AFI_PMU_0_PMU2ALL_LI_UPDATE_FAST_TOG_SHIFT                      _MK_SHIFT_CONST(0)
#define AFI_PMU_0_PMU2ALL_LI_UPDATE_FAST_TOG_FIELD                      (_MK_MASK_CONST(0x1) << AFI_PMU_0_PMU2ALL_LI_UPDATE_FAST_TOG_SHIFT)
#define AFI_PMU_0_PMU2ALL_LI_UPDATE_FAST_TOG_RANGE                      0:0
#define AFI_PMU_0_PMU2ALL_LI_UPDATE_FAST_TOG_WOFFSET                    0x0
#define AFI_PMU_0_PMU2ALL_LI_UPDATE_FAST_TOG_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_PMU_0_PMU2ALL_LI_UPDATE_FAST_TOG_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AFI_PMU_0_PMU2ALL_LI_UPDATE_FAST_TOG_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_PMU_0_PMU2ALL_LI_UPDATE_FAST_TOG_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//PMU Load Indicator Scale for T0C0
#define AFI_PMU_0_PMU2CTLR_T0_C0_LOAD_INDICATOR_SCALE_SHIFT                     _MK_SHIFT_CONST(4)
#define AFI_PMU_0_PMU2CTLR_T0_C0_LOAD_INDICATOR_SCALE_FIELD                     (_MK_MASK_CONST(0xf) << AFI_PMU_0_PMU2CTLR_T0_C0_LOAD_INDICATOR_SCALE_SHIFT)
#define AFI_PMU_0_PMU2CTLR_T0_C0_LOAD_INDICATOR_SCALE_RANGE                     7:4
#define AFI_PMU_0_PMU2CTLR_T0_C0_LOAD_INDICATOR_SCALE_WOFFSET                   0x0
#define AFI_PMU_0_PMU2CTLR_T0_C0_LOAD_INDICATOR_SCALE_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_PMU_0_PMU2CTLR_T0_C0_LOAD_INDICATOR_SCALE_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define AFI_PMU_0_PMU2CTLR_T0_C0_LOAD_INDICATOR_SCALE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_PMU_0_PMU2CTLR_T0_C0_LOAD_INDICATOR_SCALE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//PMU Load Indicator Scale for T0C1
#define AFI_PMU_0_PMU2CTLR_T0_C1_LOAD_INDICATOR_SCALE_SHIFT                     _MK_SHIFT_CONST(8)
#define AFI_PMU_0_PMU2CTLR_T0_C1_LOAD_INDICATOR_SCALE_FIELD                     (_MK_MASK_CONST(0xf) << AFI_PMU_0_PMU2CTLR_T0_C1_LOAD_INDICATOR_SCALE_SHIFT)
#define AFI_PMU_0_PMU2CTLR_T0_C1_LOAD_INDICATOR_SCALE_RANGE                     11:8
#define AFI_PMU_0_PMU2CTLR_T0_C1_LOAD_INDICATOR_SCALE_WOFFSET                   0x0
#define AFI_PMU_0_PMU2CTLR_T0_C1_LOAD_INDICATOR_SCALE_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_PMU_0_PMU2CTLR_T0_C1_LOAD_INDICATOR_SCALE_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define AFI_PMU_0_PMU2CTLR_T0_C1_LOAD_INDICATOR_SCALE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_PMU_0_PMU2CTLR_T0_C1_LOAD_INDICATOR_SCALE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//PMU Status
#define AFI_PMU_0_CTLR_T0_C0_2PMU_STATUS_SHIFT                  _MK_SHIFT_CONST(12)
#define AFI_PMU_0_CTLR_T0_C0_2PMU_STATUS_FIELD                  (_MK_MASK_CONST(0xf) << AFI_PMU_0_CTLR_T0_C0_2PMU_STATUS_SHIFT)
#define AFI_PMU_0_CTLR_T0_C0_2PMU_STATUS_RANGE                  15:12
#define AFI_PMU_0_CTLR_T0_C0_2PMU_STATUS_WOFFSET                        0x0
#define AFI_PMU_0_CTLR_T0_C0_2PMU_STATUS_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_PMU_0_CTLR_T0_C0_2PMU_STATUS_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define AFI_PMU_0_CTLR_T0_C0_2PMU_STATUS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_PMU_0_CTLR_T0_C0_2PMU_STATUS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//PMU toggle response from PCIE
#define AFI_PMU_0_CTLR_T0_C0_2PMU_TOG_SHIFT                     _MK_SHIFT_CONST(16)
#define AFI_PMU_0_CTLR_T0_C0_2PMU_TOG_FIELD                     (_MK_MASK_CONST(0x1) << AFI_PMU_0_CTLR_T0_C0_2PMU_TOG_SHIFT)
#define AFI_PMU_0_CTLR_T0_C0_2PMU_TOG_RANGE                     16:16
#define AFI_PMU_0_CTLR_T0_C0_2PMU_TOG_WOFFSET                   0x0
#define AFI_PMU_0_CTLR_T0_C0_2PMU_TOG_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_PMU_0_CTLR_T0_C0_2PMU_TOG_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AFI_PMU_0_CTLR_T0_C0_2PMU_TOG_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_PMU_0_CTLR_T0_C0_2PMU_TOG_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//PMU Status
#define AFI_PMU_0_CTLR_T0_C1_2PMU_STATUS_SHIFT                  _MK_SHIFT_CONST(20)
#define AFI_PMU_0_CTLR_T0_C1_2PMU_STATUS_FIELD                  (_MK_MASK_CONST(0xf) << AFI_PMU_0_CTLR_T0_C1_2PMU_STATUS_SHIFT)
#define AFI_PMU_0_CTLR_T0_C1_2PMU_STATUS_RANGE                  23:20
#define AFI_PMU_0_CTLR_T0_C1_2PMU_STATUS_WOFFSET                        0x0
#define AFI_PMU_0_CTLR_T0_C1_2PMU_STATUS_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_PMU_0_CTLR_T0_C1_2PMU_STATUS_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define AFI_PMU_0_CTLR_T0_C1_2PMU_STATUS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_PMU_0_CTLR_T0_C1_2PMU_STATUS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//PMU toggle response from PCIE
#define AFI_PMU_0_CTLR_T0_C1_2PMU_TOG_SHIFT                     _MK_SHIFT_CONST(24)
#define AFI_PMU_0_CTLR_T0_C1_2PMU_TOG_FIELD                     (_MK_MASK_CONST(0x1) << AFI_PMU_0_CTLR_T0_C1_2PMU_TOG_SHIFT)
#define AFI_PMU_0_CTLR_T0_C1_2PMU_TOG_RANGE                     24:24
#define AFI_PMU_0_CTLR_T0_C1_2PMU_TOG_WOFFSET                   0x0
#define AFI_PMU_0_CTLR_T0_C1_2PMU_TOG_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_PMU_0_CTLR_T0_C1_2PMU_TOG_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AFI_PMU_0_CTLR_T0_C1_2PMU_TOG_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_PMU_0_CTLR_T0_C1_2PMU_TOG_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register AFI_PCIE_CLK_CONFIG_STATUS_0  
#define AFI_PCIE_CLK_CONFIG_STATUS_0                    _MK_ADDR_CONST(0x10c)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_SECURE                     0x0
#define AFI_PCIE_CLK_CONFIG_STATUS_0_WORD_COUNT                         0x1
#define AFI_PCIE_CLK_CONFIG_STATUS_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_RESET_MASK                         _MK_MASK_CONST(0xff3f1f)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_READ_MASK                  _MK_MASK_CONST(0xff3f1f)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_WRITE_MASK                         _MK_MASK_CONST(0x1f)
//Acknowledge to Select XCLK Gen2 request.  
//This should remain low for AP20.
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0_RDY_XCLK_GEN2_SHIFT                  _MK_SHIFT_CONST(0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0_RDY_XCLK_GEN2_FIELD                  (_MK_MASK_CONST(0x1) << AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0_RDY_XCLK_GEN2_SHIFT)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0_RDY_XCLK_GEN2_RANGE                  0:0
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0_RDY_XCLK_GEN2_WOFFSET                        0x0
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0_RDY_XCLK_GEN2_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0_RDY_XCLK_GEN2_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0_RDY_XCLK_GEN2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0_RDY_XCLK_GEN2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//Acknowledge to Select T0C0 XTXCLK1X Gen2 request.  
//This should remain low for AP20.
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_RDY_XTXCLK1X_GEN2_SHIFT                    _MK_SHIFT_CONST(1)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_RDY_XTXCLK1X_GEN2_FIELD                    (_MK_MASK_CONST(0x1) << AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_RDY_XTXCLK1X_GEN2_SHIFT)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_RDY_XTXCLK1X_GEN2_RANGE                    1:1
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_RDY_XTXCLK1X_GEN2_WOFFSET                  0x0
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_RDY_XTXCLK1X_GEN2_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_RDY_XTXCLK1X_GEN2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_RDY_XTXCLK1X_GEN2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_RDY_XTXCLK1X_GEN2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//Acknowledge to Disable T0C0 XTXCLK1X request.  Used for clock gating.
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_OFF_XTXCLK1X_SHIFT                 _MK_SHIFT_CONST(2)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_OFF_XTXCLK1X_FIELD                 (_MK_MASK_CONST(0x1) << AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_OFF_XTXCLK1X_SHIFT)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_OFF_XTXCLK1X_RANGE                 2:2
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_OFF_XTXCLK1X_WOFFSET                       0x0
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_OFF_XTXCLK1X_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_OFF_XTXCLK1X_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_OFF_XTXCLK1X_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C0_OFF_XTXCLK1X_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//Acknowledge to Select T0C0 XTXCLK1X Gen2 request.  
//This should remain low for AP20.
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_RDY_XTXCLK1X_GEN2_SHIFT                    _MK_SHIFT_CONST(3)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_RDY_XTXCLK1X_GEN2_FIELD                    (_MK_MASK_CONST(0x1) << AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_RDY_XTXCLK1X_GEN2_SHIFT)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_RDY_XTXCLK1X_GEN2_RANGE                    3:3
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_RDY_XTXCLK1X_GEN2_WOFFSET                  0x0
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_RDY_XTXCLK1X_GEN2_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_RDY_XTXCLK1X_GEN2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_RDY_XTXCLK1X_GEN2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_RDY_XTXCLK1X_GEN2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//Acknowledge to Disable T0C0 XTXCLK1X request.  Used for clock gating.
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_OFF_XTXCLK1X_SHIFT                 _MK_SHIFT_CONST(4)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_OFF_XTXCLK1X_FIELD                 (_MK_MASK_CONST(0x1) << AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_OFF_XTXCLK1X_SHIFT)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_OFF_XTXCLK1X_RANGE                 4:4
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_OFF_XTXCLK1X_WOFFSET                       0x0
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_OFF_XTXCLK1X_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_OFF_XTXCLK1X_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_OFF_XTXCLK1X_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_CLK2PCIE_TMS0C1_OFF_XTXCLK1X_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//Request to select Gen2 speed clock (500 MHz) for XCLK.  
//This is generated when register settings for PCIE2 specify 
//Gen2 speed clocks. This should remain low for AP20.
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_SEL_XCLK_GEN2_SHIFT                  _MK_SHIFT_CONST(8)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_SEL_XCLK_GEN2_FIELD                  (_MK_MASK_CONST(0x1) << AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_SEL_XCLK_GEN2_SHIFT)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_SEL_XCLK_GEN2_RANGE                  8:8
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_SEL_XCLK_GEN2_WOFFSET                        0x0
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_SEL_XCLK_GEN2_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_SEL_XCLK_GEN2_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_SEL_XCLK_GEN2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_SEL_XCLK_GEN2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//Request to select Gen2 speed clock (500 MHz) for T0C0 XTXCLK1X.  
//This is generated when register settings for PCIE2 specify 
//Gen2 speed clocks. This should remain low for AP20.
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_SEL_XTXCLK1X_GEN2_SHIFT                    _MK_SHIFT_CONST(9)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_SEL_XTXCLK1X_GEN2_FIELD                    (_MK_MASK_CONST(0x1) << AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_SEL_XTXCLK1X_GEN2_SHIFT)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_SEL_XTXCLK1X_GEN2_RANGE                    9:9
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_SEL_XTXCLK1X_GEN2_WOFFSET                  0x0
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_SEL_XTXCLK1X_GEN2_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_SEL_XTXCLK1X_GEN2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_SEL_XTXCLK1X_GEN2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_SEL_XTXCLK1X_GEN2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//Request to select Gen2 speed clock (500 MHz) for T0C1 XTXCLK1X.  
//This is generated when register settings for PCIE2 specify 
//Gen2 speed clocks. This should remain low for AP20.
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_SEL_XTXCLK1X_GEN2_SHIFT                    _MK_SHIFT_CONST(10)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_SEL_XTXCLK1X_GEN2_FIELD                    (_MK_MASK_CONST(0x1) << AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_SEL_XTXCLK1X_GEN2_SHIFT)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_SEL_XTXCLK1X_GEN2_RANGE                    10:10
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_SEL_XTXCLK1X_GEN2_WOFFSET                  0x0
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_SEL_XTXCLK1X_GEN2_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_SEL_XTXCLK1X_GEN2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_SEL_XTXCLK1X_GEN2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_SEL_XTXCLK1X_GEN2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//Request to gate TMS/FPCI clocks when in low power mode.
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_CLAMP_CLK_L1_SHIFT                   _MK_SHIFT_CONST(11)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_CLAMP_CLK_L1_FIELD                   (_MK_MASK_CONST(0x1) << AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_CLAMP_CLK_L1_SHIFT)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_CLAMP_CLK_L1_RANGE                   11:11
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_CLAMP_CLK_L1_WOFFSET                 0x0
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_CLAMP_CLK_L1_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_CLAMP_CLK_L1_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_CLAMP_CLK_L1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0_CLAMP_CLK_L1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Request to gate T0C0 XTXCLK1X when in low power mode.
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_DIS_XTXCLK1X_SHIFT                 _MK_SHIFT_CONST(12)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_DIS_XTXCLK1X_FIELD                 (_MK_MASK_CONST(0x1) << AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_DIS_XTXCLK1X_SHIFT)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_DIS_XTXCLK1X_RANGE                 12:12
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_DIS_XTXCLK1X_WOFFSET                       0x0
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_DIS_XTXCLK1X_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_DIS_XTXCLK1X_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_DIS_XTXCLK1X_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C0_DIS_XTXCLK1X_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//Request to gate T0C1 XTXCLK1X when in low power mode.
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_DIS_XTXCLK1X_SHIFT                 _MK_SHIFT_CONST(13)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_DIS_XTXCLK1X_FIELD                 (_MK_MASK_CONST(0x1) << AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_DIS_XTXCLK1X_SHIFT)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_DIS_XTXCLK1X_RANGE                 13:13
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_DIS_XTXCLK1X_WOFFSET                       0x0
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_DIS_XTXCLK1X_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_DIS_XTXCLK1X_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_DIS_XTXCLK1X_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0C1_DIS_XTXCLK1X_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//Clock select to pad macro.  For AP20, this should remain 0.
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP0_PAD_MACRO_CLK_SEL_SHIFT                  _MK_SHIFT_CONST(16)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP0_PAD_MACRO_CLK_SEL_FIELD                  (_MK_MASK_CONST(0xf) << AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP0_PAD_MACRO_CLK_SEL_SHIFT)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP0_PAD_MACRO_CLK_SEL_RANGE                  19:16
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP0_PAD_MACRO_CLK_SEL_WOFFSET                        0x0
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP0_PAD_MACRO_CLK_SEL_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP0_PAD_MACRO_CLK_SEL_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP0_PAD_MACRO_CLK_SEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP0_PAD_MACRO_CLK_SEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//Clock select to pad macro.  For AP20, this should remain 0.
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP1_PAD_MACRO_CLK_SEL_SHIFT                  _MK_SHIFT_CONST(20)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP1_PAD_MACRO_CLK_SEL_FIELD                  (_MK_MASK_CONST(0xf) << AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP1_PAD_MACRO_CLK_SEL_SHIFT)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP1_PAD_MACRO_CLK_SEL_RANGE                  23:20
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP1_PAD_MACRO_CLK_SEL_WOFFSET                        0x0
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP1_PAD_MACRO_CLK_SEL_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP1_PAD_MACRO_CLK_SEL_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP1_PAD_MACRO_CLK_SEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AFI_PCIE_CLK_CONFIG_STATUS_0_PCIE2CLK_TMS0GRP1_PAD_MACRO_CLK_SEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register AFI_PEX0_CTRL_0  
#define AFI_PEX0_CTRL_0                 _MK_ADDR_CONST(0x110)
#define AFI_PEX0_CTRL_0_SECURE                  0x0
#define AFI_PEX0_CTRL_0_WORD_COUNT                      0x1
#define AFI_PEX0_CTRL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define AFI_PEX0_CTRL_0_RESET_MASK                      _MK_MASK_CONST(0x89)
#define AFI_PEX0_CTRL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AFI_PEX0_CTRL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AFI_PEX0_CTRL_0_READ_MASK                       _MK_MASK_CONST(0x89)
#define AFI_PEX0_CTRL_0_WRITE_MASK                      _MK_MASK_CONST(0x89)
//PEX0 external pe0_rst_l register
#define AFI_PEX0_CTRL_0_PEX0_RST_L_SHIFT                        _MK_SHIFT_CONST(0)
#define AFI_PEX0_CTRL_0_PEX0_RST_L_FIELD                        (_MK_MASK_CONST(0x1) << AFI_PEX0_CTRL_0_PEX0_RST_L_SHIFT)
#define AFI_PEX0_CTRL_0_PEX0_RST_L_RANGE                        0:0
#define AFI_PEX0_CTRL_0_PEX0_RST_L_WOFFSET                      0x0
#define AFI_PEX0_CTRL_0_PEX0_RST_L_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_PEX0_CTRL_0_PEX0_RST_L_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AFI_PEX0_CTRL_0_PEX0_RST_L_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_PEX0_CTRL_0_PEX0_RST_L_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//PEX0 enable to clkout pad
#define AFI_PEX0_CTRL_0_PEX0_REFCLK_EN_SHIFT                    _MK_SHIFT_CONST(3)
#define AFI_PEX0_CTRL_0_PEX0_REFCLK_EN_FIELD                    (_MK_MASK_CONST(0x1) << AFI_PEX0_CTRL_0_PEX0_REFCLK_EN_SHIFT)
#define AFI_PEX0_CTRL_0_PEX0_REFCLK_EN_RANGE                    3:3
#define AFI_PEX0_CTRL_0_PEX0_REFCLK_EN_WOFFSET                  0x0
#define AFI_PEX0_CTRL_0_PEX0_REFCLK_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_PEX0_CTRL_0_PEX0_REFCLK_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AFI_PEX0_CTRL_0_PEX0_REFCLK_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_PEX0_CTRL_0_PEX0_REFCLK_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//PEX0 refclk select 0=PLLE, 1=PHY REFCLK
#define AFI_PEX0_CTRL_0_PEX0_REFCLK_SEL_SHIFT                   _MK_SHIFT_CONST(7)
#define AFI_PEX0_CTRL_0_PEX0_REFCLK_SEL_FIELD                   (_MK_MASK_CONST(0x1) << AFI_PEX0_CTRL_0_PEX0_REFCLK_SEL_SHIFT)
#define AFI_PEX0_CTRL_0_PEX0_REFCLK_SEL_RANGE                   7:7
#define AFI_PEX0_CTRL_0_PEX0_REFCLK_SEL_WOFFSET                 0x0
#define AFI_PEX0_CTRL_0_PEX0_REFCLK_SEL_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_PEX0_CTRL_0_PEX0_REFCLK_SEL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AFI_PEX0_CTRL_0_PEX0_REFCLK_SEL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_PEX0_CTRL_0_PEX0_REFCLK_SEL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register AFI_PEX0_STATUS_0  
#define AFI_PEX0_STATUS_0                       _MK_ADDR_CONST(0x114)
#define AFI_PEX0_STATUS_0_SECURE                        0x0
#define AFI_PEX0_STATUS_0_WORD_COUNT                    0x1
#define AFI_PEX0_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_PEX0_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0x1)
#define AFI_PEX0_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_PEX0_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_PEX0_STATUS_0_READ_MASK                     _MK_MASK_CONST(0x1)
#define AFI_PEX0_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
//status PEX0 pe0_clkreq_l input
#define AFI_PEX0_STATUS_0_PEX0_CLKREQ_L_SHIFT                   _MK_SHIFT_CONST(0)
#define AFI_PEX0_STATUS_0_PEX0_CLKREQ_L_FIELD                   (_MK_MASK_CONST(0x1) << AFI_PEX0_STATUS_0_PEX0_CLKREQ_L_SHIFT)
#define AFI_PEX0_STATUS_0_PEX0_CLKREQ_L_RANGE                   0:0
#define AFI_PEX0_STATUS_0_PEX0_CLKREQ_L_WOFFSET                 0x0
#define AFI_PEX0_STATUS_0_PEX0_CLKREQ_L_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_PEX0_STATUS_0_PEX0_CLKREQ_L_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AFI_PEX0_STATUS_0_PEX0_CLKREQ_L_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_PEX0_STATUS_0_PEX0_CLKREQ_L_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register AFI_PEX1_CTRL_0  
#define AFI_PEX1_CTRL_0                 _MK_ADDR_CONST(0x118)
#define AFI_PEX1_CTRL_0_SECURE                  0x0
#define AFI_PEX1_CTRL_0_WORD_COUNT                      0x1
#define AFI_PEX1_CTRL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define AFI_PEX1_CTRL_0_RESET_MASK                      _MK_MASK_CONST(0x89)
#define AFI_PEX1_CTRL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AFI_PEX1_CTRL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AFI_PEX1_CTRL_0_READ_MASK                       _MK_MASK_CONST(0x89)
#define AFI_PEX1_CTRL_0_WRITE_MASK                      _MK_MASK_CONST(0x89)
//PEX1 external pe1_rst_l register
#define AFI_PEX1_CTRL_0_PEX1_RST_L_SHIFT                        _MK_SHIFT_CONST(0)
#define AFI_PEX1_CTRL_0_PEX1_RST_L_FIELD                        (_MK_MASK_CONST(0x1) << AFI_PEX1_CTRL_0_PEX1_RST_L_SHIFT)
#define AFI_PEX1_CTRL_0_PEX1_RST_L_RANGE                        0:0
#define AFI_PEX1_CTRL_0_PEX1_RST_L_WOFFSET                      0x0
#define AFI_PEX1_CTRL_0_PEX1_RST_L_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_PEX1_CTRL_0_PEX1_RST_L_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AFI_PEX1_CTRL_0_PEX1_RST_L_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AFI_PEX1_CTRL_0_PEX1_RST_L_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//PEX1 enable to clkout pad
#define AFI_PEX1_CTRL_0_PEX1_REFCLK_EN_SHIFT                    _MK_SHIFT_CONST(3)
#define AFI_PEX1_CTRL_0_PEX1_REFCLK_EN_FIELD                    (_MK_MASK_CONST(0x1) << AFI_PEX1_CTRL_0_PEX1_REFCLK_EN_SHIFT)
#define AFI_PEX1_CTRL_0_PEX1_REFCLK_EN_RANGE                    3:3
#define AFI_PEX1_CTRL_0_PEX1_REFCLK_EN_WOFFSET                  0x0
#define AFI_PEX1_CTRL_0_PEX1_REFCLK_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define AFI_PEX1_CTRL_0_PEX1_REFCLK_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AFI_PEX1_CTRL_0_PEX1_REFCLK_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AFI_PEX1_CTRL_0_PEX1_REFCLK_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//PEX1 refclk select 0=PLLE, 1=PHY REFCLK
#define AFI_PEX1_CTRL_0_PEX1_REFCLK_SEL_SHIFT                   _MK_SHIFT_CONST(7)
#define AFI_PEX1_CTRL_0_PEX1_REFCLK_SEL_FIELD                   (_MK_MASK_CONST(0x1) << AFI_PEX1_CTRL_0_PEX1_REFCLK_SEL_SHIFT)
#define AFI_PEX1_CTRL_0_PEX1_REFCLK_SEL_RANGE                   7:7
#define AFI_PEX1_CTRL_0_PEX1_REFCLK_SEL_WOFFSET                 0x0
#define AFI_PEX1_CTRL_0_PEX1_REFCLK_SEL_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_PEX1_CTRL_0_PEX1_REFCLK_SEL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AFI_PEX1_CTRL_0_PEX1_REFCLK_SEL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_PEX1_CTRL_0_PEX1_REFCLK_SEL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register AFI_PEX1_STATUS_0  
#define AFI_PEX1_STATUS_0                       _MK_ADDR_CONST(0x11c)
#define AFI_PEX1_STATUS_0_SECURE                        0x0
#define AFI_PEX1_STATUS_0_WORD_COUNT                    0x1
#define AFI_PEX1_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AFI_PEX1_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0x1)
#define AFI_PEX1_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AFI_PEX1_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AFI_PEX1_STATUS_0_READ_MASK                     _MK_MASK_CONST(0x1)
#define AFI_PEX1_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
//status PEX1 pe1_clkreq_l input
#define AFI_PEX1_STATUS_0_PEX1_CLKREQ_L_SHIFT                   _MK_SHIFT_CONST(0)
#define AFI_PEX1_STATUS_0_PEX1_CLKREQ_L_FIELD                   (_MK_MASK_CONST(0x1) << AFI_PEX1_STATUS_0_PEX1_CLKREQ_L_SHIFT)
#define AFI_PEX1_STATUS_0_PEX1_CLKREQ_L_RANGE                   0:0
#define AFI_PEX1_STATUS_0_PEX1_CLKREQ_L_WOFFSET                 0x0
#define AFI_PEX1_STATUS_0_PEX1_CLKREQ_L_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_PEX1_STATUS_0_PEX1_CLKREQ_L_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AFI_PEX1_STATUS_0_PEX1_CLKREQ_L_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_PEX1_STATUS_0_PEX1_CLKREQ_L_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register AFI_WR_SCRATCH_0  
#define AFI_WR_SCRATCH_0                        _MK_ADDR_CONST(0x120)
#define AFI_WR_SCRATCH_0_SECURE                         0x0
#define AFI_WR_SCRATCH_0_WORD_COUNT                     0x1
#define AFI_WR_SCRATCH_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define AFI_WR_SCRATCH_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define AFI_WR_SCRATCH_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define AFI_WR_SCRATCH_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AFI_WR_SCRATCH_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define AFI_WR_SCRATCH_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
//Scratch registers to write
#define AFI_WR_SCRATCH_0_AFI_WR_SCRATCH_SHIFT                   _MK_SHIFT_CONST(0)
#define AFI_WR_SCRATCH_0_AFI_WR_SCRATCH_FIELD                   (_MK_MASK_CONST(0xffffffff) << AFI_WR_SCRATCH_0_AFI_WR_SCRATCH_SHIFT)
#define AFI_WR_SCRATCH_0_AFI_WR_SCRATCH_RANGE                   31:0
#define AFI_WR_SCRATCH_0_AFI_WR_SCRATCH_WOFFSET                 0x0
#define AFI_WR_SCRATCH_0_AFI_WR_SCRATCH_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_WR_SCRATCH_0_AFI_WR_SCRATCH_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define AFI_WR_SCRATCH_0_AFI_WR_SCRATCH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_WR_SCRATCH_0_AFI_WR_SCRATCH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register AFI_RD_SCRATCH_0  
#define AFI_RD_SCRATCH_0                        _MK_ADDR_CONST(0x124)
#define AFI_RD_SCRATCH_0_SECURE                         0x0
#define AFI_RD_SCRATCH_0_WORD_COUNT                     0x1
#define AFI_RD_SCRATCH_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define AFI_RD_SCRATCH_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define AFI_RD_SCRATCH_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define AFI_RD_SCRATCH_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AFI_RD_SCRATCH_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define AFI_RD_SCRATCH_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
//Scratch registers to read 
#define AFI_RD_SCRATCH_0_AFI_RD_SCRATCH_SHIFT                   _MK_SHIFT_CONST(0)
#define AFI_RD_SCRATCH_0_AFI_RD_SCRATCH_FIELD                   (_MK_MASK_CONST(0xffffffff) << AFI_RD_SCRATCH_0_AFI_RD_SCRATCH_SHIFT)
#define AFI_RD_SCRATCH_0_AFI_RD_SCRATCH_RANGE                   31:0
#define AFI_RD_SCRATCH_0_AFI_RD_SCRATCH_WOFFSET                 0x0
#define AFI_RD_SCRATCH_0_AFI_RD_SCRATCH_DEFAULT                 _MK_MASK_CONST(0x0)
#define AFI_RD_SCRATCH_0_AFI_RD_SCRATCH_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define AFI_RD_SCRATCH_0_AFI_RD_SCRATCH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AFI_RD_SCRATCH_0_AFI_RD_SCRATCH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register AFI_DUMMY_REG_0  
#define AFI_DUMMY_REG_0                 _MK_ADDR_CONST(0x128)
#define AFI_DUMMY_REG_0_SECURE                  0x0
#define AFI_DUMMY_REG_0_WORD_COUNT                      0x1
#define AFI_DUMMY_REG_0_RESET_VAL                       _MK_MASK_CONST(0x1)
#define AFI_DUMMY_REG_0_RESET_MASK                      _MK_MASK_CONST(0x1)
#define AFI_DUMMY_REG_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AFI_DUMMY_REG_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AFI_DUMMY_REG_0_READ_MASK                       _MK_MASK_CONST(0x1)
#define AFI_DUMMY_REG_0_WRITE_MASK                      _MK_MASK_CONST(0x1)
//Dummy register
#define AFI_DUMMY_REG_0_DUMMY_SHIFT                     _MK_SHIFT_CONST(0)
#define AFI_DUMMY_REG_0_DUMMY_FIELD                     (_MK_MASK_CONST(0x1) << AFI_DUMMY_REG_0_DUMMY_SHIFT)
#define AFI_DUMMY_REG_0_DUMMY_RANGE                     0:0
#define AFI_DUMMY_REG_0_DUMMY_WOFFSET                   0x0
#define AFI_DUMMY_REG_0_DUMMY_DEFAULT                   _MK_MASK_CONST(0x1)
#define AFI_DUMMY_REG_0_DUMMY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AFI_DUMMY_REG_0_DUMMY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AFI_DUMMY_REG_0_DUMMY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Packet PCIE_INTINFO_ADDR
#define PCIE_INTINFO_ADDR_SIZE 30

//When interrupt code is not equal to 6, the INT_INFO field of the
//interrupt signature register contains either the AXI or FPCI address
//bits[31:2] of the read or write transaction causing the interrupt
#define PCIE_INTINFO_ADDR_INTERRUPT_ADDRESS_SHIFT                       _MK_SHIFT_CONST(2)
#define PCIE_INTINFO_ADDR_INTERRUPT_ADDRESS_FIELD                       (_MK_MASK_CONST(0x3fffffff) << PCIE_INTINFO_ADDR_INTERRUPT_ADDRESS_SHIFT)
#define PCIE_INTINFO_ADDR_INTERRUPT_ADDRESS_RANGE                       _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(2)
#define PCIE_INTINFO_ADDR_INTERRUPT_ADDRESS_ROW                 0


// Packet PCIE_INTINFO_SM
#define PCIE_INTINFO_SM_SIZE 13

//Unit ID of the PCIE2 controller generating the system management message.
//This will correspond to UNITID_T0C0 or UNITID_T0C1 of PCIE_CONFIG register.
#define PCIE_INTINFO_SM_SM_UNIT_ID_SHIFT                        _MK_SHIFT_CONST(10)
#define PCIE_INTINFO_SM_SM_UNIT_ID_FIELD                        (_MK_MASK_CONST(0x1f) << PCIE_INTINFO_SM_SM_UNIT_ID_SHIFT)
#define PCIE_INTINFO_SM_SM_UNIT_ID_RANGE                        _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(10)
#define PCIE_INTINFO_SM_SM_UNIT_ID_ROW                  0

//System management message
#define PCIE_INTINFO_SM_SM_MESSAGE_SHIFT                        _MK_SHIFT_CONST(2)
#define PCIE_INTINFO_SM_SM_MESSAGE_FIELD                        (_MK_MASK_CONST(0x1f) << PCIE_INTINFO_SM_SM_MESSAGE_SHIFT)
#define PCIE_INTINFO_SM_SM_MESSAGE_RANGE                        _MK_SHIFT_CONST(6):_MK_SHIFT_CONST(2)
#define PCIE_INTINFO_SM_SM_MESSAGE_ROW                  0
#define PCIE_INTINFO_SM_SM_MESSAGE_INTA_ASSERT                  _MK_ENUM_CONST(16)    // //Interrupt A Assertion

#define PCIE_INTINFO_SM_SM_MESSAGE_INTB_ASSERT                  _MK_ENUM_CONST(20)    // //Interrupt B Assertion

#define PCIE_INTINFO_SM_SM_MESSAGE_INTC_ASSERT                  _MK_ENUM_CONST(24)    // //Interrupt C Assertion

#define PCIE_INTINFO_SM_SM_MESSAGE_INTD_ASSERT                  _MK_ENUM_CONST(28)    // //Interrupt D Assertion

#define PCIE_INTINFO_SM_SM_MESSAGE_INTA_DEASSERT                        _MK_ENUM_CONST(0)    // //Interrupt A Deassertion

#define PCIE_INTINFO_SM_SM_MESSAGE_INTB_DEASSERT                        _MK_ENUM_CONST(4)    // //Interrupt B Deassertion

#define PCIE_INTINFO_SM_SM_MESSAGE_INTC_DEASSERT                        _MK_ENUM_CONST(8)    // //Interrupt C Deassertion

#define PCIE_INTINFO_SM_SM_MESSAGE_INTD_DEASSERT                        _MK_ENUM_CONST(12)    // //Interrupt D Deassertion

#define PCIE_INTINFO_SM_SM_MESSAGE_ERR_CORRECTABLE                      _MK_ENUM_CONST(1)    // //Correctable Error

#define PCIE_INTINFO_SM_SM_MESSAGE_ERR_UNCORRECTABLE_NONFATAL                   _MK_ENUM_CONST(5)    // //Un-Correctable Non-Fatal Error

#define PCIE_INTINFO_SM_SM_MESSAGE_ERR_UNCORRECTABLE_FATAL                      _MK_ENUM_CONST(9)    // //Un-Correctable Fatal Error

#define PCIE_INTINFO_SM_SM_MESSAGE_PME_ASSERT                   _MK_ENUM_CONST(2)    // //PME Assertion

#define PCIE_INTINFO_SM_SM_MESSAGE_HOTPLUG_ASSERT                       _MK_ENUM_CONST(6)    // //Hotplug Assertion

#define PCIE_INTINFO_SM_SM_MESSAGE_RP_ASSERT                    _MK_ENUM_CONST(19)    // //Root Port Assertion

#define PCIE_INTINFO_SM_SM_MESSAGE_RP_DEASSERT                  _MK_ENUM_CONST(3)    // //Root Port Deassertion



//
// REGISTER LIST
//
#define LIST_ARAFI_REGS(_op_) \
_op_(AFI_AXI_BAR0_SZ_0) \
_op_(AFI_AXI_BAR1_SZ_0) \
_op_(AFI_AXI_BAR2_SZ_0) \
_op_(AFI_AXI_BAR3_SZ_0) \
_op_(AFI_AXI_BAR4_SZ_0) \
_op_(AFI_AXI_BAR5_SZ_0) \
_op_(AFI_AXI_BAR0_START_0) \
_op_(AFI_AXI_BAR1_START_0) \
_op_(AFI_AXI_BAR2_START_0) \
_op_(AFI_AXI_BAR3_START_0) \
_op_(AFI_AXI_BAR4_START_0) \
_op_(AFI_AXI_BAR5_START_0) \
_op_(AFI_FPCI_BAR0_0) \
_op_(AFI_FPCI_BAR1_0) \
_op_(AFI_FPCI_BAR2_0) \
_op_(AFI_FPCI_BAR3_0) \
_op_(AFI_FPCI_BAR4_0) \
_op_(AFI_FPCI_BAR5_0) \
_op_(AFI_CACHE_BAR0_SZ_0) \
_op_(AFI_CACHE_BAR0_ST_0) \
_op_(AFI_CACHE_BAR1_SZ_0) \
_op_(AFI_CACHE_BAR1_ST_0) \
_op_(AFI_IO_BAR_SZ_0) \
_op_(AFI_IO_BAR_ST_0) \
_op_(AFI_MSI_BAR_SZ_0) \
_op_(AFI_MSI_FPCI_BAR_ST_0) \
_op_(AFI_MSI_AXI_BAR_ST_0) \
_op_(AFI_MSI_VEC0_0) \
_op_(AFI_MSI_VEC1_0) \
_op_(AFI_MSI_VEC2_0) \
_op_(AFI_MSI_VEC3_0) \
_op_(AFI_MSI_VEC4_0) \
_op_(AFI_MSI_VEC5_0) \
_op_(AFI_MSI_VEC6_0) \
_op_(AFI_MSI_VEC7_0) \
_op_(AFI_MSI_EN_VEC0_0) \
_op_(AFI_MSI_EN_VEC1_0) \
_op_(AFI_MSI_EN_VEC2_0) \
_op_(AFI_MSI_EN_VEC3_0) \
_op_(AFI_MSI_EN_VEC4_0) \
_op_(AFI_MSI_EN_VEC5_0) \
_op_(AFI_MSI_EN_VEC6_0) \
_op_(AFI_MSI_EN_VEC7_0) \
_op_(AFI_CONFIGURATION_0) \
_op_(AFI_FPCI_ERROR_MASKS_0) \
_op_(AFI_INTR_MASK_0) \
_op_(AFI_INTR_CODE_0) \
_op_(AFI_INTR_SIGNATURE_0) \
_op_(AFI_UPPER_FPCI_ADDR_0) \
_op_(AFI_SM_INTR_ENABLE_0) \
_op_(AFI_AFI_INTR_ENABLE_0) \
_op_(AFI_AUSER_OVERRIDE_0) \
_op_(AFI_ACACHE_OVERRIDE_0) \
_op_(AFI_APROT_OVERRIDE_0) \
_op_(AFI_FPCI_TIMEOUT_0) \
_op_(AFI_IDDQ_MODE_0) \
_op_(AFI_PLL_RESET_0) \
_op_(AFI_IDDQ_MODE_ACK_0) \
_op_(AFI_PLL_RESET_ACK_0) \
_op_(AFI_PCIE_THROTTLE_0) \
_op_(AFI_PME_0) \
_op_(AFI_REQ_PENDING_0) \
_op_(AFI_PCIE_CONFIG_0) \
_op_(AFI_REV_ID_0) \
_op_(AFI_TOM_0) \
_op_(AFI_FUSE_0) \
_op_(AFI_PMU_0) \
_op_(AFI_PCIE_CLK_CONFIG_STATUS_0) \
_op_(AFI_PEX0_CTRL_0) \
_op_(AFI_PEX0_STATUS_0) \
_op_(AFI_PEX1_CTRL_0) \
_op_(AFI_PEX1_STATUS_0) \
_op_(AFI_WR_SCRATCH_0) \
_op_(AFI_RD_SCRATCH_0) \
_op_(AFI_DUMMY_REG_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_AFI        0x00000000

//
// ARAFI REGISTER BANKS
//

#define AFI0_FIRST_REG 0x0000 // AFI_AXI_BAR0_SZ_0
#define AFI0_LAST_REG 0x0128 // AFI_DUMMY_REG_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARAFI_H_INC_
