/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARAPBDEV_KBC_H_INC_
#define ___ARAPBDEV_KBC_H_INC_
#define APBDEV_KBC_NUM_ROWS     16
#define APBDEV_KBC_NUM_COLS     8
#define APBDEV_KBC_MAX_ENT      8
#define APBDEV_KBC_REG_WIDTH_BYTES      4
#define APBDEV_KBC_FIFO_DEPTH   10

// Register APBDEV_KBC_CONTROL_0  
#define APBDEV_KBC_CONTROL_0                    _MK_ADDR_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_SECURE                     0x0
#define APBDEV_KBC_CONTROL_0_WORD_COUNT                         0x1
#define APBDEV_KBC_CONTROL_0_RESET_VAL                  _MK_MASK_CONST(0x10000)
#define APBDEV_KBC_CONTROL_0_RESET_MASK                         _MK_MASK_CONST(0x7ffff)
#define APBDEV_KBC_CONTROL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_READ_MASK                  _MK_MASK_CONST(0x7ffff)
#define APBDEV_KBC_CONTROL_0_WRITE_MASK                         _MK_MASK_CONST(0x7ffff)
// Keyboard controller enable. Setting this bit will override the 
// pins settings done in GPIO
#define APBDEV_KBC_CONTROL_0_EN_SHIFT                   _MK_SHIFT_CONST(0)
#define APBDEV_KBC_CONTROL_0_EN_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_KBC_CONTROL_0_EN_SHIFT)
#define APBDEV_KBC_CONTROL_0_EN_RANGE                   0:0
#define APBDEV_KBC_CONTROL_0_EN_WOFFSET                 0x0
#define APBDEV_KBC_CONTROL_0_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_KBC_CONTROL_0_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_EN_DISABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_CONTROL_0_EN_ENABLE                  _MK_ENUM_CONST(1)

// Key-press interrupt enable. Setting this bit will enable interrupt
// on any key-press
#define APBDEV_KBC_CONTROL_0_KP_INT_EN_SHIFT                    _MK_SHIFT_CONST(1)
#define APBDEV_KBC_CONTROL_0_KP_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_KBC_CONTROL_0_KP_INT_EN_SHIFT)
#define APBDEV_KBC_CONTROL_0_KP_INT_EN_RANGE                    1:1
#define APBDEV_KBC_CONTROL_0_KP_INT_EN_WOFFSET                  0x0
#define APBDEV_KBC_CONTROL_0_KP_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_KP_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_KBC_CONTROL_0_KP_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_KP_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_KP_INT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_CONTROL_0_KP_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

// FIFO overflow interrupt enable. Setting this bit will enable interrupt
// on FIFO overflow
#define APBDEV_KBC_CONTROL_0_FIFO_OVF_INT_EN_SHIFT                      _MK_SHIFT_CONST(2)
#define APBDEV_KBC_CONTROL_0_FIFO_OVF_INT_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_CONTROL_0_FIFO_OVF_INT_EN_SHIFT)
#define APBDEV_KBC_CONTROL_0_FIFO_OVF_INT_EN_RANGE                      2:2
#define APBDEV_KBC_CONTROL_0_FIFO_OVF_INT_EN_WOFFSET                    0x0
#define APBDEV_KBC_CONTROL_0_FIFO_OVF_INT_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_FIFO_OVF_INT_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_CONTROL_0_FIFO_OVF_INT_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_FIFO_OVF_INT_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// FIFO threshold count interrupt enable. Setting this bit will enable interrupt
// when FIFO occupancy reaches/crosses the value specified in FIFO_TH_CNT
// 0 Disable FIFO overflow interrupt
// 1 Enable FIFO overflow interrupt
#define APBDEV_KBC_CONTROL_0_FIFO_CNT_INT_EN_SHIFT                      _MK_SHIFT_CONST(3)
#define APBDEV_KBC_CONTROL_0_FIFO_CNT_INT_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_CONTROL_0_FIFO_CNT_INT_EN_SHIFT)
#define APBDEV_KBC_CONTROL_0_FIFO_CNT_INT_EN_RANGE                      3:3
#define APBDEV_KBC_CONTROL_0_FIFO_CNT_INT_EN_WOFFSET                    0x0
#define APBDEV_KBC_CONTROL_0_FIFO_CNT_INT_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_FIFO_CNT_INT_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_CONTROL_0_FIFO_CNT_INT_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_FIFO_CNT_INT_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Debounce count. This value sets the debounce FSM associated with each KBC 
// input pin evaluate the input transitions
// 0 = No debounce
// N = N KBC clocks
#define APBDEV_KBC_CONTROL_0_DBC_CNT_SHIFT                      _MK_SHIFT_CONST(4)
#define APBDEV_KBC_CONTROL_0_DBC_CNT_FIELD                      (_MK_MASK_CONST(0x3ff) << APBDEV_KBC_CONTROL_0_DBC_CNT_SHIFT)
#define APBDEV_KBC_CONTROL_0_DBC_CNT_RANGE                      13:4
#define APBDEV_KBC_CONTROL_0_DBC_CNT_WOFFSET                    0x0
#define APBDEV_KBC_CONTROL_0_DBC_CNT_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_DBC_CNT_DEFAULT_MASK                       _MK_MASK_CONST(0x3ff)
#define APBDEV_KBC_CONTROL_0_DBC_CNT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_DBC_CNT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// FIFO threshold count. Keeps the threshold FIFO ocuupancy count. If FIFO 
// reaches/crosses that count an optional interrupt will be raised. Should
// not be programmed as 0
// N = Threshold occupancy count is N
#define APBDEV_KBC_CONTROL_0_FIFO_TH_CNT_SHIFT                  _MK_SHIFT_CONST(14)
#define APBDEV_KBC_CONTROL_0_FIFO_TH_CNT_FIELD                  (_MK_MASK_CONST(0xf) << APBDEV_KBC_CONTROL_0_FIFO_TH_CNT_SHIFT)
#define APBDEV_KBC_CONTROL_0_FIFO_TH_CNT_RANGE                  17:14
#define APBDEV_KBC_CONTROL_0_FIFO_TH_CNT_WOFFSET                        0x0
#define APBDEV_KBC_CONTROL_0_FIFO_TH_CNT_DEFAULT                        _MK_MASK_CONST(0x4)
#define APBDEV_KBC_CONTROL_0_FIFO_TH_CNT_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define APBDEV_KBC_CONTROL_0_FIFO_TH_CNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_FIFO_TH_CNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Selects the bahavior in case of FIFO overflow 
// 0 = Drop the new detected key-presses
// 1 = Overwrite the new detected key-presses
#define APBDEV_KBC_CONTROL_0_FIFO_MODE_SHIFT                    _MK_SHIFT_CONST(18)
#define APBDEV_KBC_CONTROL_0_FIFO_MODE_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_KBC_CONTROL_0_FIFO_MODE_SHIFT)
#define APBDEV_KBC_CONTROL_0_FIFO_MODE_RANGE                    18:18
#define APBDEV_KBC_CONTROL_0_FIFO_MODE_WOFFSET                  0x0
#define APBDEV_KBC_CONTROL_0_FIFO_MODE_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_FIFO_MODE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_KBC_CONTROL_0_FIFO_MODE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_KBC_CONTROL_0_FIFO_MODE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_KBC_INT_0  
#define APBDEV_KBC_INT_0                        _MK_ADDR_CONST(0x4)
#define APBDEV_KBC_INT_0_SECURE                         0x0
#define APBDEV_KBC_INT_0_WORD_COUNT                     0x1
#define APBDEV_KBC_INT_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_INT_0_RESET_MASK                     _MK_MASK_CONST(0xff)
#define APBDEV_KBC_INT_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_KBC_INT_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_INT_0_READ_MASK                      _MK_MASK_CONST(0xff)
#define APBDEV_KBC_INT_0_WRITE_MASK                     _MK_MASK_CONST(0x7)
// Key-press intrrupt status. Writing '1' to this bit will clear the 
// interrupt
// 0 Key-press interrupt de-asserted
// 1 Key-press interrupt asserted (read)
// 1 Clear key-press interrupt (write)
#define APBDEV_KBC_INT_0_KP_INT_STATUS_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_KBC_INT_0_KP_INT_STATUS_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_KBC_INT_0_KP_INT_STATUS_SHIFT)
#define APBDEV_KBC_INT_0_KP_INT_STATUS_RANGE                    0:0
#define APBDEV_KBC_INT_0_KP_INT_STATUS_WOFFSET                  0x0
#define APBDEV_KBC_INT_0_KP_INT_STATUS_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_INT_0_KP_INT_STATUS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_KBC_INT_0_KP_INT_STATUS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_KBC_INT_0_KP_INT_STATUS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// FIFO overflow intrrupt status. Writing '1' to this bit will clear the 
// interrupt
// 0 FIFO overflow intrrupt de-asserted
// 1 FIFO overflow intrrupt asserted (read)
// 1 Clear FIFO overflow intrrupt (write)
#define APBDEV_KBC_INT_0_FIFO_OVF_INT_STATUS_SHIFT                      _MK_SHIFT_CONST(1)
#define APBDEV_KBC_INT_0_FIFO_OVF_INT_STATUS_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_INT_0_FIFO_OVF_INT_STATUS_SHIFT)
#define APBDEV_KBC_INT_0_FIFO_OVF_INT_STATUS_RANGE                      1:1
#define APBDEV_KBC_INT_0_FIFO_OVF_INT_STATUS_WOFFSET                    0x0
#define APBDEV_KBC_INT_0_FIFO_OVF_INT_STATUS_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_INT_0_FIFO_OVF_INT_STATUS_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_INT_0_FIFO_OVF_INT_STATUS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_INT_0_FIFO_OVF_INT_STATUS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// FIFO thershold count intrrupt status. Writing '1' to this bit will clear the 
// interrupt
// 0 FIFO thershold count intrrupt de-asserted
// 1 FIFO thershold count intrrupt asserted (read)
// 1 Clear FIFO overflow intrrupt (write)
#define APBDEV_KBC_INT_0_FIFO_CNT_INT_STATUS_SHIFT                      _MK_SHIFT_CONST(2)
#define APBDEV_KBC_INT_0_FIFO_CNT_INT_STATUS_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_INT_0_FIFO_CNT_INT_STATUS_SHIFT)
#define APBDEV_KBC_INT_0_FIFO_CNT_INT_STATUS_RANGE                      2:2
#define APBDEV_KBC_INT_0_FIFO_CNT_INT_STATUS_WOFFSET                    0x0
#define APBDEV_KBC_INT_0_FIFO_CNT_INT_STATUS_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_INT_0_FIFO_CNT_INT_STATUS_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_INT_0_FIFO_CNT_INT_STATUS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_INT_0_FIFO_CNT_INT_STATUS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// KBC status. Read only. 
// 0 = WuKP (Wake-up on key-press) interrupt mode
// 1 = CP (Continuous polling) mode
#define APBDEV_KBC_INT_0_KBC_ST_STATUS_SHIFT                    _MK_SHIFT_CONST(3)
#define APBDEV_KBC_INT_0_KBC_ST_STATUS_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_KBC_INT_0_KBC_ST_STATUS_SHIFT)
#define APBDEV_KBC_INT_0_KBC_ST_STATUS_RANGE                    3:3
#define APBDEV_KBC_INT_0_KBC_ST_STATUS_WOFFSET                  0x0
#define APBDEV_KBC_INT_0_KBC_ST_STATUS_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_INT_0_KBC_ST_STATUS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_KBC_INT_0_KBC_ST_STATUS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_KBC_INT_0_KBC_ST_STATUS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// FIFO occupancy count. Shows the number of unread registers. Read only.
#define APBDEV_KBC_INT_0_AV_FIFO_CNT_SHIFT                      _MK_SHIFT_CONST(4)
#define APBDEV_KBC_INT_0_AV_FIFO_CNT_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_INT_0_AV_FIFO_CNT_SHIFT)
#define APBDEV_KBC_INT_0_AV_FIFO_CNT_RANGE                      7:4
#define APBDEV_KBC_INT_0_AV_FIFO_CNT_WOFFSET                    0x0
#define APBDEV_KBC_INT_0_AV_FIFO_CNT_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_INT_0_AV_FIFO_CNT_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_INT_0_AV_FIFO_CNT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_INT_0_AV_FIFO_CNT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_KBC_ROW_CFG0_0  
#define APBDEV_KBC_ROW_CFG0_0                   _MK_ADDR_CONST(0x8)
#define APBDEV_KBC_ROW_CFG0_0_SECURE                    0x0
#define APBDEV_KBC_ROW_CFG0_0_WORD_COUNT                        0x1
#define APBDEV_KBC_ROW_CFG0_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_RESET_MASK                        _MK_MASK_CONST(0x3fffffff)
#define APBDEV_KBC_ROW_CFG0_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_READ_MASK                         _MK_MASK_CONST(0x3fffffff)
#define APBDEV_KBC_ROW_CFG0_0_WRITE_MASK                        _MK_MASK_CONST(0x3fffffff)
// Indicates whether GPIO pin# 0 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 0 in column configuration
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_EN_SHIFT                       _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_EN_RANGE                       0:0
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_EN_WOFFSET                     0x0
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 0 to row number. Valid only if GPIO_0_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_NUM_SHIFT                      _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_NUM_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_NUM_RANGE                      4:1
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_NUM_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_0_ROW_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 1 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 1 in column configuration
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_EN_SHIFT                       _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_EN_RANGE                       5:5
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_EN_WOFFSET                     0x0
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 1 to row number. Valid only if GPIO_1_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_NUM_SHIFT                      _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_NUM_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_NUM_RANGE                      9:6
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_NUM_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_1_ROW_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 2 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 2 in column configuration
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_EN_SHIFT                       _MK_SHIFT_CONST(10)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_EN_RANGE                       10:10
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_EN_WOFFSET                     0x0
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 2 to row number. Valid only if GPIO_2_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_NUM_SHIFT                      _MK_SHIFT_CONST(11)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_NUM_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_NUM_RANGE                      14:11
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_NUM_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_2_ROW_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 3 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 3 in column configuration
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_EN_SHIFT                       _MK_SHIFT_CONST(15)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_EN_RANGE                       15:15
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_EN_WOFFSET                     0x0
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 3 to row number. Valid only if GPIO_3_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_NUM_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_NUM_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_NUM_RANGE                      19:16
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_NUM_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_3_ROW_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 4 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 4 in column configuration
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_EN_SHIFT                       _MK_SHIFT_CONST(20)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_EN_RANGE                       20:20
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_EN_WOFFSET                     0x0
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 4 to row number. Valid only if GPIO_4_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_NUM_SHIFT                      _MK_SHIFT_CONST(21)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_NUM_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_NUM_RANGE                      24:21
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_NUM_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_4_ROW_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 5 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 5 in column configuration
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_EN_SHIFT                       _MK_SHIFT_CONST(25)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_EN_RANGE                       25:25
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_EN_WOFFSET                     0x0
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 5 to row number. Valid only if GPIO_5_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_NUM_SHIFT                      _MK_SHIFT_CONST(26)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_NUM_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_NUM_RANGE                      29:26
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_NUM_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG0_0_GPIO_5_ROW_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_KBC_ROW_CFG1_0  
#define APBDEV_KBC_ROW_CFG1_0                   _MK_ADDR_CONST(0xc)
#define APBDEV_KBC_ROW_CFG1_0_SECURE                    0x0
#define APBDEV_KBC_ROW_CFG1_0_WORD_COUNT                        0x1
#define APBDEV_KBC_ROW_CFG1_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_RESET_MASK                        _MK_MASK_CONST(0x3fffffff)
#define APBDEV_KBC_ROW_CFG1_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_READ_MASK                         _MK_MASK_CONST(0x3fffffff)
#define APBDEV_KBC_ROW_CFG1_0_WRITE_MASK                        _MK_MASK_CONST(0x3fffffff)
// Indicates whether GPIO pin# 6 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 6 in column configuration
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_EN_SHIFT                       _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_EN_RANGE                       0:0
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_EN_WOFFSET                     0x0
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 6 to row number. Valid only if GPIO_6_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_NUM_SHIFT                      _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_NUM_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_NUM_RANGE                      4:1
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_NUM_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_6_ROW_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 7 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 7 in column configuration
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_EN_SHIFT                       _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_EN_RANGE                       5:5
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_EN_WOFFSET                     0x0
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 7 to row number. Valid only if GPIO_7_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_NUM_SHIFT                      _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_NUM_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_NUM_RANGE                      9:6
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_NUM_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_7_ROW_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 8 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 8 in column configuration
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_EN_SHIFT                       _MK_SHIFT_CONST(10)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_EN_RANGE                       10:10
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_EN_WOFFSET                     0x0
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 8 to row number. Valid only if GPIO_8_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_NUM_SHIFT                      _MK_SHIFT_CONST(11)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_NUM_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_NUM_RANGE                      14:11
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_NUM_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_8_ROW_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 9 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 9 in column configuration
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_EN_SHIFT                       _MK_SHIFT_CONST(15)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_EN_RANGE                       15:15
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_EN_WOFFSET                     0x0
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 9 to row number. Valid only if GPIO_9_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_NUM_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_NUM_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_NUM_RANGE                      19:16
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_NUM_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_9_ROW_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 10 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 10 in column configuration
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_EN_SHIFT                      _MK_SHIFT_CONST(20)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_EN_RANGE                      20:20
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_EN_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 10 to row number. Valid only if GPIO_10_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_NUM_SHIFT                     _MK_SHIFT_CONST(21)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_NUM_FIELD                     (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_NUM_RANGE                     24:21
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_NUM_WOFFSET                   0x0
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_10_ROW_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 11 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 11 in column configuration
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_EN_SHIFT                      _MK_SHIFT_CONST(25)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_EN_RANGE                      25:25
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_EN_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 11 to row number. Valid only if GPIO_11_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_NUM_SHIFT                     _MK_SHIFT_CONST(26)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_NUM_FIELD                     (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_NUM_RANGE                     29:26
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_NUM_WOFFSET                   0x0
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG1_0_GPIO_11_ROW_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APBDEV_KBC_ROW_CFG2_0  
#define APBDEV_KBC_ROW_CFG2_0                   _MK_ADDR_CONST(0x10)
#define APBDEV_KBC_ROW_CFG2_0_SECURE                    0x0
#define APBDEV_KBC_ROW_CFG2_0_WORD_COUNT                        0x1
#define APBDEV_KBC_ROW_CFG2_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_RESET_MASK                        _MK_MASK_CONST(0x3fffffff)
#define APBDEV_KBC_ROW_CFG2_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_READ_MASK                         _MK_MASK_CONST(0x3fffffff)
#define APBDEV_KBC_ROW_CFG2_0_WRITE_MASK                        _MK_MASK_CONST(0x3fffffff)
// Indicates whether GPIO pin# 12 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 12 in column configuration
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_EN_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_EN_RANGE                      0:0
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_EN_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 12 to row number. Valid only if GPIO_12_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_NUM_SHIFT                     _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_NUM_FIELD                     (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_NUM_RANGE                     4:1
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_NUM_WOFFSET                   0x0
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_12_ROW_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 13 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 13 in column configuration
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_EN_SHIFT                      _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_EN_RANGE                      5:5
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_EN_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 13 to row number. Valid only if GPIO_13_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_NUM_SHIFT                     _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_NUM_FIELD                     (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_NUM_RANGE                     9:6
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_NUM_WOFFSET                   0x0
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_13_ROW_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 14 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 14 in column configuration
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_EN_SHIFT                      _MK_SHIFT_CONST(10)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_EN_RANGE                      10:10
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_EN_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 14 to row number. Valid only if GPIO_14_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_NUM_SHIFT                     _MK_SHIFT_CONST(11)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_NUM_FIELD                     (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_NUM_RANGE                     14:11
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_NUM_WOFFSET                   0x0
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_14_ROW_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 15 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 15 in column configuration
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_EN_SHIFT                      _MK_SHIFT_CONST(15)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_EN_RANGE                      15:15
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_EN_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 15 to row number. Valid only if GPIO_15_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_NUM_SHIFT                     _MK_SHIFT_CONST(16)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_NUM_FIELD                     (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_NUM_RANGE                     19:16
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_NUM_WOFFSET                   0x0
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_15_ROW_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 16 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 16 in column configuration
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_EN_SHIFT                      _MK_SHIFT_CONST(20)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_EN_RANGE                      20:20
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_EN_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 16 to row number. Valid only if GPIO_16_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_NUM_SHIFT                     _MK_SHIFT_CONST(21)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_NUM_FIELD                     (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_NUM_RANGE                     24:21
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_NUM_WOFFSET                   0x0
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_16_ROW_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 17 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 17 in column configuration
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_EN_SHIFT                      _MK_SHIFT_CONST(25)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_EN_RANGE                      25:25
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_EN_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 17 to row number. Valid only if GPIO_17_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_NUM_SHIFT                     _MK_SHIFT_CONST(26)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_NUM_FIELD                     (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_NUM_RANGE                     29:26
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_NUM_WOFFSET                   0x0
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG2_0_GPIO_17_ROW_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APBDEV_KBC_ROW_CFG3_0  
#define APBDEV_KBC_ROW_CFG3_0                   _MK_ADDR_CONST(0x14)
#define APBDEV_KBC_ROW_CFG3_0_SECURE                    0x0
#define APBDEV_KBC_ROW_CFG3_0_WORD_COUNT                        0x1
#define APBDEV_KBC_ROW_CFG3_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_RESET_MASK                        _MK_MASK_CONST(0x3fffffff)
#define APBDEV_KBC_ROW_CFG3_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_READ_MASK                         _MK_MASK_CONST(0x3fffffff)
#define APBDEV_KBC_ROW_CFG3_0_WRITE_MASK                        _MK_MASK_CONST(0x3fffffff)
// Indicates whether GPIO pin# 18 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 18 in column configuration
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_EN_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_EN_RANGE                      0:0
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_EN_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 18 to row number. Valid only if GPIO_18_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_NUM_SHIFT                     _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_NUM_FIELD                     (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_NUM_RANGE                     4:1
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_NUM_WOFFSET                   0x0
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_18_ROW_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 19 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 19 in column configuration
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_EN_SHIFT                      _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_EN_RANGE                      5:5
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_EN_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 19 to row number. Valid only if GPIO_19_ROW_EN is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_NUM_SHIFT                     _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_NUM_FIELD                     (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_NUM_RANGE                     9:6
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_NUM_WOFFSET                   0x0
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_19_ROW_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 20 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 20 in column configuration
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_EN_SHIFT                      _MK_SHIFT_CONST(10)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_EN_RANGE                      10:10
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_EN_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 20 to row number. Valid only if GPIO_20 is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_NUM_SHIFT                     _MK_SHIFT_CONST(11)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_NUM_FIELD                     (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_NUM_RANGE                     14:11
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_NUM_WOFFSET                   0x0
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_20_ROW_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 21 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 21 in column configuration
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_EN_SHIFT                      _MK_SHIFT_CONST(15)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_EN_RANGE                      15:15
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_EN_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 21 to row number. Valid only if GPIO_21 is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_NUM_SHIFT                     _MK_SHIFT_CONST(16)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_NUM_FIELD                     (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_NUM_RANGE                     19:16
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_NUM_WOFFSET                   0x0
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_21_ROW_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 22 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 22 in column configuration
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_EN_SHIFT                      _MK_SHIFT_CONST(20)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_EN_RANGE                      20:20
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_EN_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 22 to row number. Valid only if GPIO_21 is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_NUM_SHIFT                     _MK_SHIFT_CONST(21)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_NUM_FIELD                     (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_NUM_RANGE                     24:21
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_NUM_WOFFSET                   0x0
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_22_ROW_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 23 is mapped to any row of keypad matrix. This bit 
// overrides any setting done for pin# 23 in column configuration
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_EN_SHIFT                      _MK_SHIFT_CONST(25)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_EN_SHIFT)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_EN_RANGE                      25:25
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_EN_WOFFSET                    0x0
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 23 to row number. Valid only if GPIO_21 is set. 
// Indicates row number
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_NUM_SHIFT                     _MK_SHIFT_CONST(26)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_NUM_FIELD                     (_MK_MASK_CONST(0xf) << APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_NUM_SHIFT)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_NUM_RANGE                     29:26
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_NUM_WOFFSET                   0x0
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW_CFG3_0_GPIO_23_ROW_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APBDEV_KBC_COL_CFG0_0  
#define APBDEV_KBC_COL_CFG0_0                   _MK_ADDR_CONST(0x18)
#define APBDEV_KBC_COL_CFG0_0_SECURE                    0x0
#define APBDEV_KBC_COL_CFG0_0_WORD_COUNT                        0x1
#define APBDEV_KBC_COL_CFG0_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_KBC_COL_CFG0_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_KBC_COL_CFG0_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// Indicates whether GPIO pin# 0 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_0_ROW_EN in ROW_CFG0 is set to 0.
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_EN_SHIFT                       _MK_SHIFT_CONST(0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_EN_RANGE                       0:0
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_EN_WOFFSET                     0x0
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 0 to column number. Valid only if GPIO_0_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_NUM_SHIFT                      _MK_SHIFT_CONST(1)
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_NUM_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_NUM_RANGE                      3:1
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_NUM_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_0_COL_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 1 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_1_ROW_EN in ROW_CFG0 is set to 0.
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_EN_SHIFT                       _MK_SHIFT_CONST(4)
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_EN_RANGE                       4:4
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_EN_WOFFSET                     0x0
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 1 to column number. Valid only if GPIO_1_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_NUM_SHIFT                      _MK_SHIFT_CONST(5)
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_NUM_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_NUM_RANGE                      7:5
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_NUM_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_1_COL_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 2 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_2_ROW_EN in ROW_CFG0 is set to 0.
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_EN_SHIFT                       _MK_SHIFT_CONST(8)
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_EN_RANGE                       8:8
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_EN_WOFFSET                     0x0
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 2 to column number. Valid only if GPIO_2_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_NUM_SHIFT                      _MK_SHIFT_CONST(9)
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_NUM_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_NUM_RANGE                      11:9
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_NUM_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_2_COL_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 3 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_3_ROW_EN in ROW_CFG0 is set to 0.
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_EN_SHIFT                       _MK_SHIFT_CONST(12)
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_EN_RANGE                       12:12
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_EN_WOFFSET                     0x0
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 3 to column number. Valid only if GPIO_3_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_NUM_SHIFT                      _MK_SHIFT_CONST(13)
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_NUM_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_NUM_RANGE                      15:13
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_NUM_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_3_COL_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 4 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_4_ROW_EN in ROW_CFG0 is set to 0.
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_EN_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_EN_RANGE                       16:16
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_EN_WOFFSET                     0x0
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 4 to column number. Valid only if GPIO_4_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_NUM_SHIFT                      _MK_SHIFT_CONST(17)
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_NUM_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_NUM_RANGE                      19:17
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_NUM_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_4_COL_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 5 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_5_ROW_EN in ROW_CFG0 is set to 0.
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_EN_SHIFT                       _MK_SHIFT_CONST(20)
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_EN_RANGE                       20:20
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_EN_WOFFSET                     0x0
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 5 to column number. Valid only if GPIO_5_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_NUM_SHIFT                      _MK_SHIFT_CONST(21)
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_NUM_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_NUM_RANGE                      23:21
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_NUM_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_5_COL_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 6 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_6_ROW_EN in ROW_CFG1 is set to 0.
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_EN_SHIFT                       _MK_SHIFT_CONST(24)
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_EN_RANGE                       24:24
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_EN_WOFFSET                     0x0
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 6 to column number. Valid only if GPIO_6_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_NUM_SHIFT                      _MK_SHIFT_CONST(25)
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_NUM_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_NUM_RANGE                      27:25
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_NUM_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_6_COL_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 7 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_7_ROW_EN in ROW_CFG1 is set to 0.
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_EN_SHIFT                       _MK_SHIFT_CONST(28)
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_EN_RANGE                       28:28
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_EN_WOFFSET                     0x0
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 7 to column number. Valid only if GPIO_7_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_NUM_SHIFT                      _MK_SHIFT_CONST(29)
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_NUM_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_NUM_RANGE                      31:29
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_NUM_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG0_0_GPIO_7_COL_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_KBC_COL_CFG1_0  
#define APBDEV_KBC_COL_CFG1_0                   _MK_ADDR_CONST(0x1c)
#define APBDEV_KBC_COL_CFG1_0_SECURE                    0x0
#define APBDEV_KBC_COL_CFG1_0_WORD_COUNT                        0x1
#define APBDEV_KBC_COL_CFG1_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_KBC_COL_CFG1_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_KBC_COL_CFG1_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// Indicates whether GPIO pin# 8 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_8_ROW_EN in ROW_CFG1 is set to 0.
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_EN_SHIFT                       _MK_SHIFT_CONST(0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_EN_RANGE                       0:0
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_EN_WOFFSET                     0x0
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 8 to column number. Valid only if GPIO_8_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_NUM_SHIFT                      _MK_SHIFT_CONST(1)
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_NUM_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_NUM_RANGE                      3:1
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_NUM_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_8_COL_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 9 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_9_ROW_EN in ROW_CFG1 is set to 0.
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_EN_SHIFT                       _MK_SHIFT_CONST(4)
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_EN_RANGE                       4:4
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_EN_WOFFSET                     0x0
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_EN_NOT_MAPPED                  _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_EN_MAPPED                      _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 9 to column number. Valid only if GPIO_9_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_NUM_SHIFT                      _MK_SHIFT_CONST(5)
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_NUM_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_NUM_RANGE                      7:5
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_NUM_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_NUM_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_NUM_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_NUM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_9_COL_NUM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 10 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_10_ROW_EN in ROW_CFG1 is set to 0.
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_EN_SHIFT                      _MK_SHIFT_CONST(8)
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_EN_RANGE                      8:8
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_EN_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 10 to column number. Valid only if GPIO_10_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_NUM_SHIFT                     _MK_SHIFT_CONST(9)
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_NUM_FIELD                     (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_NUM_RANGE                     11:9
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_NUM_WOFFSET                   0x0
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_10_COL_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 11 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_11_ROW_EN in ROW_CFG1 is set to 0.
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_EN_SHIFT                      _MK_SHIFT_CONST(12)
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_EN_RANGE                      12:12
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_EN_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 11 to column number. Valid only if GPIO_11_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_NUM_SHIFT                     _MK_SHIFT_CONST(13)
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_NUM_FIELD                     (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_NUM_RANGE                     15:13
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_NUM_WOFFSET                   0x0
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_11_COL_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 12 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_12_ROW_EN in ROW_CFG2 is set to 0.
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_EN_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_EN_RANGE                      16:16
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_EN_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 12 to column number. Valid only if GPIO_12_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_NUM_SHIFT                     _MK_SHIFT_CONST(17)
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_NUM_FIELD                     (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_NUM_RANGE                     19:17
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_NUM_WOFFSET                   0x0
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_12_COL_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 13 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_13_ROW_EN in ROW_CFG2 is set to 0.
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_EN_SHIFT                      _MK_SHIFT_CONST(20)
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_EN_RANGE                      20:20
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_EN_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 13 to column number. Valid only if GPIO_13_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_NUM_SHIFT                     _MK_SHIFT_CONST(21)
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_NUM_FIELD                     (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_NUM_RANGE                     23:21
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_NUM_WOFFSET                   0x0
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_13_COL_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 14 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_14_ROW_EN in ROW_CFG2 is set to 0.
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_EN_SHIFT                      _MK_SHIFT_CONST(24)
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_EN_RANGE                      24:24
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_EN_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 14 to column number. Valid only if GPIO_14_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_NUM_SHIFT                     _MK_SHIFT_CONST(25)
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_NUM_FIELD                     (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_NUM_RANGE                     27:25
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_NUM_WOFFSET                   0x0
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_14_COL_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 15 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_15_ROW_EN in ROW_CFG2 is set to 0.
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_EN_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_EN_RANGE                      28:28
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_EN_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 15 to column number. Valid only if GPIO_15_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_NUM_SHIFT                     _MK_SHIFT_CONST(29)
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_NUM_FIELD                     (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_NUM_RANGE                     31:29
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_NUM_WOFFSET                   0x0
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG1_0_GPIO_15_COL_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APBDEV_KBC_COL_CFG2_0  
#define APBDEV_KBC_COL_CFG2_0                   _MK_ADDR_CONST(0x20)
#define APBDEV_KBC_COL_CFG2_0_SECURE                    0x0
#define APBDEV_KBC_COL_CFG2_0_WORD_COUNT                        0x1
#define APBDEV_KBC_COL_CFG2_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_KBC_COL_CFG2_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_KBC_COL_CFG2_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// Indicates whether GPIO pin# 16 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_16_ROW_EN in ROW_CFG2 is set to 0.
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_EN_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_EN_RANGE                      0:0
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_EN_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 16 to column number. Valid only if GPIO_16_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_NUM_SHIFT                     _MK_SHIFT_CONST(1)
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_NUM_FIELD                     (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_NUM_RANGE                     3:1
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_NUM_WOFFSET                   0x0
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_16_COL_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 17 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_17_ROW_EN in ROW_CFG2 is set to 0.
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_EN_SHIFT                      _MK_SHIFT_CONST(4)
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_EN_RANGE                      4:4
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_EN_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 17 to column number. Valid only if GPIO_17_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_NUM_SHIFT                     _MK_SHIFT_CONST(5)
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_NUM_FIELD                     (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_NUM_RANGE                     7:5
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_NUM_WOFFSET                   0x0
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_17_COL_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 18 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_18_ROW_EN in ROW_CFG3 is set to 0.
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_EN_SHIFT                      _MK_SHIFT_CONST(8)
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_EN_RANGE                      8:8
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_EN_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 18 to column number. Valid only if GPIO_18_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_NUM_SHIFT                     _MK_SHIFT_CONST(9)
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_NUM_FIELD                     (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_NUM_RANGE                     11:9
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_NUM_WOFFSET                   0x0
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_18_COL_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 19 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_19_ROW_EN in ROW_CFG3 is set to 0.
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_EN_SHIFT                      _MK_SHIFT_CONST(12)
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_EN_RANGE                      12:12
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_EN_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 19 to column number. Valid only if GPIO_19_COL_EN is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_NUM_SHIFT                     _MK_SHIFT_CONST(13)
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_NUM_FIELD                     (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_NUM_RANGE                     15:13
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_NUM_WOFFSET                   0x0
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_19_COL_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 20 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_20 in ROW_CFG3 is set to 0.
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_EN_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_EN_RANGE                      16:16
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_EN_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 20 to column number. Valid only if GPIO_20 is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_NUM_SHIFT                     _MK_SHIFT_CONST(17)
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_NUM_FIELD                     (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_NUM_RANGE                     19:17
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_NUM_WOFFSET                   0x0
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_20_COL_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 21 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_21 in ROW_CFG3 is set to 0.
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_EN_SHIFT                      _MK_SHIFT_CONST(20)
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_EN_RANGE                      20:20
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_EN_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 21 to column number. Valid only if GPIO_21 is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_NUM_SHIFT                     _MK_SHIFT_CONST(21)
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_NUM_FIELD                     (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_NUM_RANGE                     23:21
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_NUM_WOFFSET                   0x0
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_21_COL_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 22 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_22 in ROW_CFG3 is set to 0.
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_EN_SHIFT                      _MK_SHIFT_CONST(24)
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_EN_RANGE                      24:24
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_EN_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 22 to column number. Valid only if GPIO_22 is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_NUM_SHIFT                     _MK_SHIFT_CONST(25)
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_NUM_FIELD                     (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_NUM_RANGE                     27:25
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_NUM_WOFFSET                   0x0
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_22_COL_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates whether GPIO pin# 23 is mapped to any column of keypad matrix. This bit 
// should be set to '1' only when GPIO_22 in ROW_CFG3 is set to 0.
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_EN_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_EN_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_EN_SHIFT)
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_EN_RANGE                      28:28
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_EN_WOFFSET                    0x0
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_EN_NOT_MAPPED                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_EN_MAPPED                     _MK_ENUM_CONST(1)

// Mapping of GPIO pin# 23 to column number. Valid only if GPIO_23 is set. 
// Indicates row number
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_NUM_SHIFT                     _MK_SHIFT_CONST(29)
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_NUM_FIELD                     (_MK_MASK_CONST(0x7) << APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_NUM_SHIFT)
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_NUM_RANGE                     31:29
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_NUM_WOFFSET                   0x0
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_NUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_NUM_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_NUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_COL_CFG2_0_GPIO_23_COL_NUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APBDEV_KBC_TO_CNT_0  
#define APBDEV_KBC_TO_CNT_0                     _MK_ADDR_CONST(0x24)
#define APBDEV_KBC_TO_CNT_0_SECURE                      0x0
#define APBDEV_KBC_TO_CNT_0_WORD_COUNT                  0x1
#define APBDEV_KBC_TO_CNT_0_RESET_VAL                   _MK_MASK_CONST(0x27100)
#define APBDEV_KBC_TO_CNT_0_RESET_MASK                  _MK_MASK_CONST(0xfffff)
#define APBDEV_KBC_TO_CNT_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_TO_CNT_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_TO_CNT_0_READ_MASK                   _MK_MASK_CONST(0xfffff)
#define APBDEV_KBC_TO_CNT_0_WRITE_MASK                  _MK_MASK_CONST(0xfffff)
// Time-out count value. The default value is 5 seconds. The value should be  
// calculated for a 32 KHz clock.
#define APBDEV_KBC_TO_CNT_0_TO_CNT_VAL_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_KBC_TO_CNT_0_TO_CNT_VAL_FIELD                    (_MK_MASK_CONST(0xfffff) << APBDEV_KBC_TO_CNT_0_TO_CNT_VAL_SHIFT)
#define APBDEV_KBC_TO_CNT_0_TO_CNT_VAL_RANGE                    19:0
#define APBDEV_KBC_TO_CNT_0_TO_CNT_VAL_WOFFSET                  0x0
#define APBDEV_KBC_TO_CNT_0_TO_CNT_VAL_DEFAULT                  _MK_MASK_CONST(0x27100)
#define APBDEV_KBC_TO_CNT_0_TO_CNT_VAL_DEFAULT_MASK                     _MK_MASK_CONST(0xfffff)
#define APBDEV_KBC_TO_CNT_0_TO_CNT_VAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_KBC_TO_CNT_0_TO_CNT_VAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_KBC_INIT_DLY_0  
#define APBDEV_KBC_INIT_DLY_0                   _MK_ADDR_CONST(0x28)
#define APBDEV_KBC_INIT_DLY_0_SECURE                    0x0
#define APBDEV_KBC_INIT_DLY_0_WORD_COUNT                        0x1
#define APBDEV_KBC_INIT_DLY_0_RESET_VAL                         _MK_MASK_CONST(0x400)
#define APBDEV_KBC_INIT_DLY_0_RESET_MASK                        _MK_MASK_CONST(0xfffff)
#define APBDEV_KBC_INIT_DLY_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_INIT_DLY_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_INIT_DLY_0_READ_MASK                         _MK_MASK_CONST(0xfffff)
#define APBDEV_KBC_INIT_DLY_0_WRITE_MASK                        _MK_MASK_CONST(0xfffff)
// Initial delay value. The default value is 32.25 milliseconds. The value should be  
// calculated for a 32 KHz clock.
#define APBDEV_KBC_INIT_DLY_0_INIT_DLY_VAL_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_KBC_INIT_DLY_0_INIT_DLY_VAL_FIELD                        (_MK_MASK_CONST(0xfffff) << APBDEV_KBC_INIT_DLY_0_INIT_DLY_VAL_SHIFT)
#define APBDEV_KBC_INIT_DLY_0_INIT_DLY_VAL_RANGE                        19:0
#define APBDEV_KBC_INIT_DLY_0_INIT_DLY_VAL_WOFFSET                      0x0
#define APBDEV_KBC_INIT_DLY_0_INIT_DLY_VAL_DEFAULT                      _MK_MASK_CONST(0x400)
#define APBDEV_KBC_INIT_DLY_0_INIT_DLY_VAL_DEFAULT_MASK                 _MK_MASK_CONST(0xfffff)
#define APBDEV_KBC_INIT_DLY_0_INIT_DLY_VAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_INIT_DLY_0_INIT_DLY_VAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APBDEV_KBC_RPT_DLY_0  
#define APBDEV_KBC_RPT_DLY_0                    _MK_ADDR_CONST(0x2c)
#define APBDEV_KBC_RPT_DLY_0_SECURE                     0x0
#define APBDEV_KBC_RPT_DLY_0_WORD_COUNT                         0x1
#define APBDEV_KBC_RPT_DLY_0_RESET_VAL                  _MK_MASK_CONST(0x400)
#define APBDEV_KBC_RPT_DLY_0_RESET_MASK                         _MK_MASK_CONST(0xfffff)
#define APBDEV_KBC_RPT_DLY_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_RPT_DLY_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_RPT_DLY_0_READ_MASK                  _MK_MASK_CONST(0xfffff)
#define APBDEV_KBC_RPT_DLY_0_WRITE_MASK                         _MK_MASK_CONST(0xfffff)
//  delay value. The default value is 32.25 milliseconds. The value should be  
// calculated for a 32 KHz clock.
#define APBDEV_KBC_RPT_DLY_0_RPT_DLY_VAL_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_KBC_RPT_DLY_0_RPT_DLY_VAL_FIELD                  (_MK_MASK_CONST(0xfffff) << APBDEV_KBC_RPT_DLY_0_RPT_DLY_VAL_SHIFT)
#define APBDEV_KBC_RPT_DLY_0_RPT_DLY_VAL_RANGE                  19:0
#define APBDEV_KBC_RPT_DLY_0_RPT_DLY_VAL_WOFFSET                        0x0
#define APBDEV_KBC_RPT_DLY_0_RPT_DLY_VAL_DEFAULT                        _MK_MASK_CONST(0x400)
#define APBDEV_KBC_RPT_DLY_0_RPT_DLY_VAL_DEFAULT_MASK                   _MK_MASK_CONST(0xfffff)
#define APBDEV_KBC_RPT_DLY_0_RPT_DLY_VAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_RPT_DLY_0_RPT_DLY_VAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_KBC_KP_ENT0_0  
#define APBDEV_KBC_KP_ENT0_0                    _MK_ADDR_CONST(0x30)
#define APBDEV_KBC_KP_ENT0_0_SECURE                     0x0
#define APBDEV_KBC_KP_ENT0_0_WORD_COUNT                         0x1
#define APBDEV_KBC_KP_ENT0_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_KBC_KP_ENT0_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_KBC_KP_ENT0_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
// Column number for first key.  
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT0_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT0_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT0_SHIFT)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT0_RANGE                      2:0
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT0_WOFFSET                    0x0
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT0_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT0_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Row number for first key.  
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT0_SHIFT                      _MK_SHIFT_CONST(3)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT0_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT0_SHIFT)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT0_RANGE                      6:3
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT0_WOFFSET                    0x0
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT0_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT0_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether first entry is valid or not
// 0x0 Entry not valid  
// 0x1 Valid entry  
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT0_SHIFT                  _MK_SHIFT_CONST(7)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT0_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT0_SHIFT)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT0_RANGE                  7:7
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT0_WOFFSET                        0x0
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT0_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Column number for second key.  
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT1_SHIFT                      _MK_SHIFT_CONST(8)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT1_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT1_SHIFT)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT1_RANGE                      10:8
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT1_WOFFSET                    0x0
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT1_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT1_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Row number for second key.  
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT1_SHIFT                      _MK_SHIFT_CONST(11)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT1_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT1_SHIFT)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT1_RANGE                      14:11
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT1_WOFFSET                    0x0
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT1_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT1_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether second entry is valid or not
// 0x0 Entry not valid  
// 0x1 Valid entry  
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT1_SHIFT                  _MK_SHIFT_CONST(15)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT1_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT1_SHIFT)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT1_RANGE                  15:15
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT1_WOFFSET                        0x0
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT1_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT1_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Column number for third key.  
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT2_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT2_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT2_SHIFT)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT2_RANGE                      18:16
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT2_WOFFSET                    0x0
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT2_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT2_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Row number for third key.  
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT2_SHIFT                      _MK_SHIFT_CONST(19)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT2_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT2_SHIFT)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT2_RANGE                      22:19
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT2_WOFFSET                    0x0
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT2_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT2_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether third entry is valid or not
// 0x0 Entry not valid  
// 0x1 Valid entry  
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT2_SHIFT                  _MK_SHIFT_CONST(23)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT2_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT2_SHIFT)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT2_RANGE                  23:23
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT2_WOFFSET                        0x0
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT2_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT2_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Column number for fourth key.  
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT3_SHIFT                      _MK_SHIFT_CONST(24)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT3_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT3_SHIFT)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT3_RANGE                      26:24
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT3_WOFFSET                    0x0
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT3_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT3_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_COL_NUM_ENT3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Row number for fourth key.  
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT3_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT3_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT3_SHIFT)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT3_RANGE                      30:27
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT3_WOFFSET                    0x0
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT3_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT3_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_ROW_NUM_ENT3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether fourth entry is valid or not
// 0x0 Entry not valid  
// 0x1 Valid entry  
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT3_SHIFT                  _MK_SHIFT_CONST(31)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT3_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT3_SHIFT)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT3_RANGE                  31:31
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT3_WOFFSET                        0x0
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT3_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT3_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT0_0_KP_NEW_ENT3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_KBC_KP_ENT1_0  
#define APBDEV_KBC_KP_ENT1_0                    _MK_ADDR_CONST(0x34)
#define APBDEV_KBC_KP_ENT1_0_SECURE                     0x0
#define APBDEV_KBC_KP_ENT1_0_WORD_COUNT                         0x1
#define APBDEV_KBC_KP_ENT1_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_KBC_KP_ENT1_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_KBC_KP_ENT1_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
// Column number for fifth key.  
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT4_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT4_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT4_SHIFT)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT4_RANGE                      2:0
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT4_WOFFSET                    0x0
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT4_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT4_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Row number for fifth key.  
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT4_SHIFT                      _MK_SHIFT_CONST(3)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT4_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT4_SHIFT)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT4_RANGE                      6:3
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT4_WOFFSET                    0x0
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT4_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT4_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether fifth entry is valid or not
// 0x0 Entry not valid  
// 0x1 Valid entry  
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT4_SHIFT                  _MK_SHIFT_CONST(7)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT4_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT4_SHIFT)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT4_RANGE                  7:7
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT4_WOFFSET                        0x0
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT4_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT4_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT4_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT4_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Column number for sixth key.  
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT5_SHIFT                      _MK_SHIFT_CONST(8)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT5_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT5_SHIFT)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT5_RANGE                      10:8
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT5_WOFFSET                    0x0
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT5_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT5_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Row number for sixth key.  
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT5_SHIFT                      _MK_SHIFT_CONST(11)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT5_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT5_SHIFT)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT5_RANGE                      14:11
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT5_WOFFSET                    0x0
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT5_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT5_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether sixth entry is valid or not
// 0x0 Entry not valid  
// 0x1 Valid entry  
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT5_SHIFT                  _MK_SHIFT_CONST(15)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT5_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT5_SHIFT)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT5_RANGE                  15:15
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT5_WOFFSET                        0x0
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT5_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT5_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT5_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT5_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Column number for seventh key.  
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT6_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT6_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT6_SHIFT)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT6_RANGE                      18:16
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT6_WOFFSET                    0x0
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT6_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT6_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Row number for seventh key.  
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT6_SHIFT                      _MK_SHIFT_CONST(19)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT6_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT6_SHIFT)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT6_RANGE                      22:19
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT6_WOFFSET                    0x0
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT6_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT6_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether seventh entry is valid or not
// 0x0 Entry not valid  
// 0x1 Valid entry
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT6_SHIFT                  _MK_SHIFT_CONST(23)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT6_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT6_SHIFT)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT6_RANGE                  23:23
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT6_WOFFSET                        0x0
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT6_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT6_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT6_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT6_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Column number for eight key.  
// 0x0 = Column number 0
// 0x7 = Column number 7
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT7_SHIFT                      _MK_SHIFT_CONST(24)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT7_FIELD                      (_MK_MASK_CONST(0x7) << APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT7_SHIFT)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT7_RANGE                      26:24
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT7_WOFFSET                    0x0
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT7_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT7_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_COL_NUM_ENT7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Row number for eight key.  
// 0x0 = Row number 0
// 0xF = Row number 15
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT7_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT7_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT7_SHIFT)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT7_RANGE                      30:27
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT7_WOFFSET                    0x0
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT7_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT7_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_ROW_NUM_ENT7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicates whether eight entry is valid or not
// 0x0 Entry not valid  
// 0x1 Valid entry            
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT7_SHIFT                  _MK_SHIFT_CONST(31)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT7_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT7_SHIFT)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT7_RANGE                  31:31
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT7_WOFFSET                        0x0
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT7_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT7_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT7_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_KP_ENT1_0_KP_NEW_ENT7_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_KBC_ROW0_MASK_0  
#define APBDEV_KBC_ROW0_MASK_0                  _MK_ADDR_CONST(0x38)
#define APBDEV_KBC_ROW0_MASK_0_SECURE                   0x0
#define APBDEV_KBC_ROW0_MASK_0_WORD_COUNT                       0x1
#define APBDEV_KBC_ROW0_MASK_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW0_MASK_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW0_MASK_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
// Disable row0 col0 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL0_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL0_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL0_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL0_MASK_ENABLE_RANGE                  0:0
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL0_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL0_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL0_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL0_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL0_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL0_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL0_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row0 col1 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL1_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL1_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL1_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL1_MASK_ENABLE_RANGE                  1:1
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL1_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL1_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL1_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL1_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL1_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL1_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL1_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row0 col2 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL2_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL2_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL2_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL2_MASK_ENABLE_RANGE                  2:2
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL2_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL2_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL2_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL2_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL2_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL2_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL2_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row0 col3 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL3_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(3)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL3_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL3_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL3_MASK_ENABLE_RANGE                  3:3
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL3_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL3_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL3_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL3_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL3_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL3_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL3_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row0 col4 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL4_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(4)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL4_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL4_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL4_MASK_ENABLE_RANGE                  4:4
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL4_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL4_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL4_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL4_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL4_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL4_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL4_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row0 col5 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL5_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL5_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL5_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL5_MASK_ENABLE_RANGE                  5:5
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL5_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL5_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL5_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL5_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL5_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL5_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL5_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row0 col6 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL6_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL6_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL6_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL6_MASK_ENABLE_RANGE                  6:6
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL6_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL6_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL6_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL6_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL6_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL6_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL6_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row0 col7 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL7_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(7)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL7_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL7_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL7_MASK_ENABLE_RANGE                  7:7
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL7_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL7_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL7_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL7_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL7_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL7_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW0_MASK_0_KBC_ROW0_COL7_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)


// Register APBDEV_KBC_ROW1_MASK_0  
#define APBDEV_KBC_ROW1_MASK_0                  _MK_ADDR_CONST(0x3c)
#define APBDEV_KBC_ROW1_MASK_0_SECURE                   0x0
#define APBDEV_KBC_ROW1_MASK_0_WORD_COUNT                       0x1
#define APBDEV_KBC_ROW1_MASK_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW1_MASK_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW1_MASK_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
// Disable row1 col0 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL0_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL0_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL0_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL0_MASK_ENABLE_RANGE                  0:0
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL0_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL0_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL0_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL0_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL0_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL0_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL0_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row1 col1 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL1_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL1_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL1_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL1_MASK_ENABLE_RANGE                  1:1
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL1_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL1_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL1_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL1_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL1_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL1_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL1_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row1 col2 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL2_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL2_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL2_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL2_MASK_ENABLE_RANGE                  2:2
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL2_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL2_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL2_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL2_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL2_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL2_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL2_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row1 col3 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL3_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(3)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL3_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL3_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL3_MASK_ENABLE_RANGE                  3:3
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL3_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL3_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL3_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL3_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL3_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL3_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL3_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row1 col4 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL4_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(4)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL4_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL4_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL4_MASK_ENABLE_RANGE                  4:4
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL4_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL4_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL4_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL4_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL4_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL4_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL4_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row1 col5 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL5_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL5_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL5_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL5_MASK_ENABLE_RANGE                  5:5
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL5_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL5_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL5_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL5_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL5_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL5_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL5_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row1 col6 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL6_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL6_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL6_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL6_MASK_ENABLE_RANGE                  6:6
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL6_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL6_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL6_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL6_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL6_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL6_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL6_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row1 col7 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL7_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(7)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL7_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL7_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL7_MASK_ENABLE_RANGE                  7:7
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL7_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL7_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL7_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL7_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL7_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL7_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW1_MASK_0_KBC_ROW1_COL7_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)


// Register APBDEV_KBC_ROW2_MASK_0  
#define APBDEV_KBC_ROW2_MASK_0                  _MK_ADDR_CONST(0x40)
#define APBDEV_KBC_ROW2_MASK_0_SECURE                   0x0
#define APBDEV_KBC_ROW2_MASK_0_WORD_COUNT                       0x1
#define APBDEV_KBC_ROW2_MASK_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW2_MASK_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW2_MASK_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
// Disable row2 col0 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL0_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL0_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL0_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL0_MASK_ENABLE_RANGE                  0:0
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL0_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL0_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL0_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL0_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL0_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL0_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL0_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row2 col1 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL1_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL1_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL1_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL1_MASK_ENABLE_RANGE                  1:1
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL1_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL1_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL1_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL1_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL1_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL1_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL1_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row2 col2 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL2_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL2_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL2_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL2_MASK_ENABLE_RANGE                  2:2
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL2_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL2_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL2_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL2_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL2_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL2_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL2_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row2 col3 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL3_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(3)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL3_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL3_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL3_MASK_ENABLE_RANGE                  3:3
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL3_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL3_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL3_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL3_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL3_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL3_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL3_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row2 col4 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL4_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(4)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL4_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL4_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL4_MASK_ENABLE_RANGE                  4:4
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL4_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL4_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL4_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL4_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL4_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL4_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL4_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row2 col5 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL5_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL5_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL5_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL5_MASK_ENABLE_RANGE                  5:5
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL5_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL5_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL5_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL5_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL5_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL5_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL5_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row2 col6 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL6_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL6_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL6_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL6_MASK_ENABLE_RANGE                  6:6
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL6_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL6_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL6_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL6_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL6_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL6_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL6_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row2 col7 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL7_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(7)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL7_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL7_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL7_MASK_ENABLE_RANGE                  7:7
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL7_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL7_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL7_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL7_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL7_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL7_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW2_MASK_0_KBC_ROW2_COL7_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)


// Register APBDEV_KBC_ROW3_MASK_0  
#define APBDEV_KBC_ROW3_MASK_0                  _MK_ADDR_CONST(0x44)
#define APBDEV_KBC_ROW3_MASK_0_SECURE                   0x0
#define APBDEV_KBC_ROW3_MASK_0_WORD_COUNT                       0x1
#define APBDEV_KBC_ROW3_MASK_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW3_MASK_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW3_MASK_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
// Disable row3 col0 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL0_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL0_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL0_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL0_MASK_ENABLE_RANGE                  0:0
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL0_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL0_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL0_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL0_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL0_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL0_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL0_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row3 col1 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL1_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL1_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL1_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL1_MASK_ENABLE_RANGE                  1:1
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL1_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL1_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL1_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL1_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL1_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL1_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL1_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row3 col2 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL2_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL2_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL2_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL2_MASK_ENABLE_RANGE                  2:2
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL2_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL2_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL2_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL2_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL2_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL2_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL2_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row3 col3 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL3_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(3)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL3_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL3_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL3_MASK_ENABLE_RANGE                  3:3
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL3_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL3_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL3_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL3_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL3_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL3_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL3_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row3 col4 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL4_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(4)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL4_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL4_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL4_MASK_ENABLE_RANGE                  4:4
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL4_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL4_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL4_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL4_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL4_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL4_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL4_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row3 col5 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL5_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL5_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL5_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL5_MASK_ENABLE_RANGE                  5:5
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL5_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL5_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL5_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL5_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL5_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL5_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL5_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row3 col6 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL6_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL6_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL6_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL6_MASK_ENABLE_RANGE                  6:6
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL6_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL6_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL6_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL6_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL6_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL6_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL6_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row3 col7 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL7_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(7)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL7_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL7_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL7_MASK_ENABLE_RANGE                  7:7
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL7_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL7_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL7_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL7_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL7_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL7_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW3_MASK_0_KBC_ROW3_COL7_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)


// Register APBDEV_KBC_ROW4_MASK_0  
#define APBDEV_KBC_ROW4_MASK_0                  _MK_ADDR_CONST(0x48)
#define APBDEV_KBC_ROW4_MASK_0_SECURE                   0x0
#define APBDEV_KBC_ROW4_MASK_0_WORD_COUNT                       0x1
#define APBDEV_KBC_ROW4_MASK_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW4_MASK_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW4_MASK_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
// Disable row4 col0 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL0_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL0_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL0_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL0_MASK_ENABLE_RANGE                  0:0
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL0_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL0_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL0_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL0_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL0_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL0_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL0_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row4 col1 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL1_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL1_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL1_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL1_MASK_ENABLE_RANGE                  1:1
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL1_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL1_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL1_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL1_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL1_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL1_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL1_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row4 col2 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL2_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL2_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL2_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL2_MASK_ENABLE_RANGE                  2:2
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL2_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL2_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL2_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL2_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL2_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL2_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL2_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row4 col3 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL3_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(3)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL3_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL3_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL3_MASK_ENABLE_RANGE                  3:3
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL3_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL3_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL3_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL3_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL3_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL3_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL3_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row4 col4 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL4_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(4)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL4_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL4_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL4_MASK_ENABLE_RANGE                  4:4
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL4_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL4_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL4_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL4_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL4_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL4_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL4_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row4 col5 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL5_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL5_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL5_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL5_MASK_ENABLE_RANGE                  5:5
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL5_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL5_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL5_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL5_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL5_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL5_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL5_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row4 col6 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL6_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL6_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL6_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL6_MASK_ENABLE_RANGE                  6:6
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL6_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL6_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL6_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL6_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL6_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL6_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL6_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row4 col7 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL7_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(7)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL7_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL7_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL7_MASK_ENABLE_RANGE                  7:7
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL7_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL7_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL7_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL7_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL7_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL7_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW4_MASK_0_KBC_ROW4_COL7_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)


// Register APBDEV_KBC_ROW5_MASK_0  
#define APBDEV_KBC_ROW5_MASK_0                  _MK_ADDR_CONST(0x4c)
#define APBDEV_KBC_ROW5_MASK_0_SECURE                   0x0
#define APBDEV_KBC_ROW5_MASK_0_WORD_COUNT                       0x1
#define APBDEV_KBC_ROW5_MASK_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW5_MASK_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW5_MASK_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
// Disable row5 col0 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL0_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL0_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL0_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL0_MASK_ENABLE_RANGE                  0:0
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL0_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL0_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL0_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL0_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL0_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL0_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL0_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row5 col1 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL1_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL1_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL1_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL1_MASK_ENABLE_RANGE                  1:1
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL1_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL1_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL1_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL1_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL1_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL1_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL1_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row5 col2 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL2_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL2_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL2_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL2_MASK_ENABLE_RANGE                  2:2
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL2_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL2_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL2_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL2_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL2_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL2_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL2_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row5 col3 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL3_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(3)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL3_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL3_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL3_MASK_ENABLE_RANGE                  3:3
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL3_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL3_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL3_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL3_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL3_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL3_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL3_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row5 col4 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL4_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(4)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL4_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL4_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL4_MASK_ENABLE_RANGE                  4:4
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL4_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL4_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL4_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL4_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL4_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL4_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL4_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row5 col5 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL5_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL5_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL5_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL5_MASK_ENABLE_RANGE                  5:5
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL5_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL5_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL5_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL5_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL5_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL5_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL5_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row5 col6 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL6_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL6_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL6_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL6_MASK_ENABLE_RANGE                  6:6
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL6_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL6_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL6_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL6_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL6_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL6_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL6_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row5 col7 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL7_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(7)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL7_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL7_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL7_MASK_ENABLE_RANGE                  7:7
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL7_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL7_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL7_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL7_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL7_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL7_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW5_MASK_0_KBC_ROW5_COL7_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)


// Register APBDEV_KBC_ROW6_MASK_0  
#define APBDEV_KBC_ROW6_MASK_0                  _MK_ADDR_CONST(0x50)
#define APBDEV_KBC_ROW6_MASK_0_SECURE                   0x0
#define APBDEV_KBC_ROW6_MASK_0_WORD_COUNT                       0x1
#define APBDEV_KBC_ROW6_MASK_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW6_MASK_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW6_MASK_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
// Disable row6 col0 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL0_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL0_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL0_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL0_MASK_ENABLE_RANGE                  0:0
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL0_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL0_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL0_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL0_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL0_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL0_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL0_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row6 col1 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL1_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL1_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL1_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL1_MASK_ENABLE_RANGE                  1:1
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL1_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL1_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL1_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL1_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL1_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL1_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL1_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row6 col2 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL2_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL2_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL2_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL2_MASK_ENABLE_RANGE                  2:2
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL2_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL2_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL2_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL2_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL2_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL2_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL2_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row6 col3 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL3_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(3)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL3_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL3_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL3_MASK_ENABLE_RANGE                  3:3
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL3_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL3_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL3_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL3_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL3_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL3_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL3_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row6 col4 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL4_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(4)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL4_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL4_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL4_MASK_ENABLE_RANGE                  4:4
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL4_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL4_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL4_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL4_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL4_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL4_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL4_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row6 col5 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL5_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL5_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL5_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL5_MASK_ENABLE_RANGE                  5:5
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL5_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL5_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL5_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL5_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL5_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL5_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL5_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row6 col6 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL6_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL6_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL6_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL6_MASK_ENABLE_RANGE                  6:6
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL6_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL6_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL6_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL6_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL6_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL6_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL6_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row6 col7 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL7_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(7)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL7_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL7_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL7_MASK_ENABLE_RANGE                  7:7
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL7_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL7_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL7_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL7_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL7_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL7_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW6_MASK_0_KBC_ROW6_COL7_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)


// Register APBDEV_KBC_ROW7_MASK_0  
#define APBDEV_KBC_ROW7_MASK_0                  _MK_ADDR_CONST(0x54)
#define APBDEV_KBC_ROW7_MASK_0_SECURE                   0x0
#define APBDEV_KBC_ROW7_MASK_0_WORD_COUNT                       0x1
#define APBDEV_KBC_ROW7_MASK_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW7_MASK_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW7_MASK_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
// Disable row7 col0 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL0_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL0_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL0_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL0_MASK_ENABLE_RANGE                  0:0
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL0_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL0_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL0_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL0_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL0_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL0_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL0_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row7 col1 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL1_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL1_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL1_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL1_MASK_ENABLE_RANGE                  1:1
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL1_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL1_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL1_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL1_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL1_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL1_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL1_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row7 col2 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL2_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL2_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL2_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL2_MASK_ENABLE_RANGE                  2:2
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL2_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL2_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL2_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL2_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL2_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL2_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL2_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row7 col3 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL3_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(3)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL3_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL3_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL3_MASK_ENABLE_RANGE                  3:3
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL3_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL3_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL3_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL3_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL3_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL3_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL3_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row7 col4 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL4_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(4)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL4_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL4_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL4_MASK_ENABLE_RANGE                  4:4
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL4_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL4_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL4_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL4_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL4_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL4_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL4_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row7 col5 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL5_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL5_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL5_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL5_MASK_ENABLE_RANGE                  5:5
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL5_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL5_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL5_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL5_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL5_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL5_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL5_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row7 col6 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL6_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL6_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL6_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL6_MASK_ENABLE_RANGE                  6:6
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL6_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL6_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL6_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL6_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL6_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL6_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL6_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row7 col7 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL7_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(7)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL7_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL7_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL7_MASK_ENABLE_RANGE                  7:7
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL7_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL7_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL7_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL7_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL7_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL7_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW7_MASK_0_KBC_ROW7_COL7_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)


// Register APBDEV_KBC_ROW8_MASK_0  
#define APBDEV_KBC_ROW8_MASK_0                  _MK_ADDR_CONST(0x58)
#define APBDEV_KBC_ROW8_MASK_0_SECURE                   0x0
#define APBDEV_KBC_ROW8_MASK_0_WORD_COUNT                       0x1
#define APBDEV_KBC_ROW8_MASK_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW8_MASK_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW8_MASK_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
// Disable row8 col0 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL0_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL0_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL0_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL0_MASK_ENABLE_RANGE                  0:0
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL0_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL0_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL0_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL0_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL0_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL0_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL0_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row8 col1 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL1_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL1_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL1_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL1_MASK_ENABLE_RANGE                  1:1
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL1_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL1_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL1_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL1_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL1_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL1_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL1_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row8 col2 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL2_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL2_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL2_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL2_MASK_ENABLE_RANGE                  2:2
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL2_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL2_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL2_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL2_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL2_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL2_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL2_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row8 col3 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL3_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(3)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL3_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL3_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL3_MASK_ENABLE_RANGE                  3:3
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL3_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL3_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL3_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL3_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL3_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL3_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL3_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row8 col4 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL4_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(4)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL4_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL4_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL4_MASK_ENABLE_RANGE                  4:4
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL4_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL4_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL4_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL4_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL4_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL4_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL4_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row8 col5 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL5_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL5_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL5_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL5_MASK_ENABLE_RANGE                  5:5
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL5_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL5_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL5_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL5_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL5_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL5_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL5_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row8 col6 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL6_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL6_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL6_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL6_MASK_ENABLE_RANGE                  6:6
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL6_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL6_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL6_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL6_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL6_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL6_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL6_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row8 col7 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL7_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(7)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL7_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL7_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL7_MASK_ENABLE_RANGE                  7:7
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL7_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL7_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL7_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL7_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL7_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL7_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW8_MASK_0_KBC_ROW8_COL7_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)


// Register APBDEV_KBC_ROW9_MASK_0  
#define APBDEV_KBC_ROW9_MASK_0                  _MK_ADDR_CONST(0x5c)
#define APBDEV_KBC_ROW9_MASK_0_SECURE                   0x0
#define APBDEV_KBC_ROW9_MASK_0_WORD_COUNT                       0x1
#define APBDEV_KBC_ROW9_MASK_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW9_MASK_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW9_MASK_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
// Disable row9 col0 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL0_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL0_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL0_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL0_MASK_ENABLE_RANGE                  0:0
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL0_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL0_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL0_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL0_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL0_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL0_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL0_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row9 col1 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL1_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL1_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL1_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL1_MASK_ENABLE_RANGE                  1:1
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL1_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL1_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL1_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL1_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL1_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL1_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL1_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row9 col2 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL2_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL2_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL2_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL2_MASK_ENABLE_RANGE                  2:2
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL2_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL2_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL2_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL2_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL2_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL2_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL2_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row9 col3 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL3_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(3)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL3_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL3_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL3_MASK_ENABLE_RANGE                  3:3
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL3_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL3_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL3_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL3_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL3_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL3_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL3_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row9 col4 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL4_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(4)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL4_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL4_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL4_MASK_ENABLE_RANGE                  4:4
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL4_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL4_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL4_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL4_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL4_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL4_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL4_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row9 col5 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL5_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL5_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL5_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL5_MASK_ENABLE_RANGE                  5:5
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL5_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL5_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL5_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL5_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL5_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL5_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL5_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row9 col6 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL6_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL6_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL6_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL6_MASK_ENABLE_RANGE                  6:6
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL6_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL6_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL6_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL6_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL6_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL6_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL6_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)

// Disable row9 col7 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL7_MASK_ENABLE_SHIFT                  _MK_SHIFT_CONST(7)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL7_MASK_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL7_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL7_MASK_ENABLE_RANGE                  7:7
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL7_MASK_ENABLE_WOFFSET                        0x0
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL7_MASK_ENABLE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL7_MASK_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL7_MASK_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL7_MASK_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL7_MASK_ENABLE_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW9_MASK_0_KBC_ROW9_COL7_MASK_ENABLE_DISABLE                        _MK_ENUM_CONST(1)


// Register APBDEV_KBC_ROW10_MASK_0  
#define APBDEV_KBC_ROW10_MASK_0                 _MK_ADDR_CONST(0x60)
#define APBDEV_KBC_ROW10_MASK_0_SECURE                  0x0
#define APBDEV_KBC_ROW10_MASK_0_WORD_COUNT                      0x1
#define APBDEV_KBC_ROW10_MASK_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_RESET_MASK                      _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW10_MASK_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW10_MASK_0_WRITE_MASK                      _MK_MASK_CONST(0xff)
// Disable row10 col0 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL0_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL0_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL0_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL0_MASK_ENABLE_RANGE                        0:0
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL0_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL0_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL0_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL0_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL0_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL0_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL0_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row10 col1 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL1_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL1_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL1_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL1_MASK_ENABLE_RANGE                        1:1
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL1_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL1_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL1_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL1_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL1_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL1_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL1_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row10 col2 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL2_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(2)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL2_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL2_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL2_MASK_ENABLE_RANGE                        2:2
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL2_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL2_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL2_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL2_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL2_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL2_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL2_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row10 col3 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL3_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(3)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL3_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL3_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL3_MASK_ENABLE_RANGE                        3:3
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL3_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL3_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL3_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL3_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL3_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL3_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL3_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row10 col4 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL4_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(4)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL4_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL4_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL4_MASK_ENABLE_RANGE                        4:4
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL4_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL4_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL4_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL4_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL4_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL4_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL4_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row10 col5 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL5_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL5_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL5_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL5_MASK_ENABLE_RANGE                        5:5
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL5_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL5_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL5_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL5_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL5_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL5_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL5_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row10 col6 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL6_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL6_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL6_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL6_MASK_ENABLE_RANGE                        6:6
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL6_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL6_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL6_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL6_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL6_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL6_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL6_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row10 col7 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL7_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(7)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL7_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL7_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL7_MASK_ENABLE_RANGE                        7:7
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL7_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL7_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL7_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL7_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL7_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL7_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW10_MASK_0_KBC_ROW10_COL7_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)


// Register APBDEV_KBC_ROW11_MASK_0  
#define APBDEV_KBC_ROW11_MASK_0                 _MK_ADDR_CONST(0x64)
#define APBDEV_KBC_ROW11_MASK_0_SECURE                  0x0
#define APBDEV_KBC_ROW11_MASK_0_WORD_COUNT                      0x1
#define APBDEV_KBC_ROW11_MASK_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_RESET_MASK                      _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW11_MASK_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW11_MASK_0_WRITE_MASK                      _MK_MASK_CONST(0xff)
// Disable row11 col0 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL0_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL0_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL0_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL0_MASK_ENABLE_RANGE                        0:0
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL0_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL0_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL0_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL0_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL0_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL0_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL0_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row11 col1 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL1_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL1_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL1_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL1_MASK_ENABLE_RANGE                        1:1
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL1_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL1_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL1_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL1_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL1_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL1_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL1_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row11 col2 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL2_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(2)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL2_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL2_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL2_MASK_ENABLE_RANGE                        2:2
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL2_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL2_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL2_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL2_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL2_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL2_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL2_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row11 col3 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL3_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(3)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL3_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL3_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL3_MASK_ENABLE_RANGE                        3:3
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL3_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL3_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL3_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL3_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL3_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL3_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL3_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row11 col4 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL4_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(4)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL4_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL4_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL4_MASK_ENABLE_RANGE                        4:4
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL4_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL4_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL4_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL4_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL4_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL4_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL4_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row11 col5 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL5_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL5_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL5_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL5_MASK_ENABLE_RANGE                        5:5
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL5_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL5_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL5_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL5_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL5_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL5_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL5_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row11 col6 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL6_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL6_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL6_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL6_MASK_ENABLE_RANGE                        6:6
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL6_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL6_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL6_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL6_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL6_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL6_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL6_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row11 col7 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL7_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(7)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL7_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL7_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL7_MASK_ENABLE_RANGE                        7:7
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL7_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL7_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL7_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL7_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL7_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL7_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW11_MASK_0_KBC_ROW11_COL7_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)


// Register APBDEV_KBC_ROW12_MASK_0  
#define APBDEV_KBC_ROW12_MASK_0                 _MK_ADDR_CONST(0x68)
#define APBDEV_KBC_ROW12_MASK_0_SECURE                  0x0
#define APBDEV_KBC_ROW12_MASK_0_WORD_COUNT                      0x1
#define APBDEV_KBC_ROW12_MASK_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_RESET_MASK                      _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW12_MASK_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW12_MASK_0_WRITE_MASK                      _MK_MASK_CONST(0xff)
// Disable row12 col0 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL0_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL0_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL0_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL0_MASK_ENABLE_RANGE                        0:0
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL0_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL0_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL0_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL0_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL0_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL0_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL0_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row12 col1 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL1_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL1_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL1_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL1_MASK_ENABLE_RANGE                        1:1
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL1_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL1_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL1_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL1_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL1_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL1_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL1_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row12 col2 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL2_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(2)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL2_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL2_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL2_MASK_ENABLE_RANGE                        2:2
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL2_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL2_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL2_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL2_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL2_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL2_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL2_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row12 col3 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL3_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(3)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL3_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL3_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL3_MASK_ENABLE_RANGE                        3:3
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL3_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL3_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL3_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL3_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL3_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL3_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL3_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row12 col4 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL4_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(4)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL4_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL4_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL4_MASK_ENABLE_RANGE                        4:4
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL4_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL4_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL4_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL4_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL4_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL4_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL4_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row12 col5 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL5_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL5_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL5_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL5_MASK_ENABLE_RANGE                        5:5
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL5_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL5_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL5_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL5_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL5_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL5_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL5_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row12 col6 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL6_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL6_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL6_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL6_MASK_ENABLE_RANGE                        6:6
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL6_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL6_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL6_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL6_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL6_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL6_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL6_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row12 col7 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL7_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(7)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL7_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL7_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL7_MASK_ENABLE_RANGE                        7:7
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL7_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL7_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL7_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL7_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL7_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL7_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW12_MASK_0_KBC_ROW12_COL7_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)


// Register APBDEV_KBC_ROW13_MASK_0  
#define APBDEV_KBC_ROW13_MASK_0                 _MK_ADDR_CONST(0x6c)
#define APBDEV_KBC_ROW13_MASK_0_SECURE                  0x0
#define APBDEV_KBC_ROW13_MASK_0_WORD_COUNT                      0x1
#define APBDEV_KBC_ROW13_MASK_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_RESET_MASK                      _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW13_MASK_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW13_MASK_0_WRITE_MASK                      _MK_MASK_CONST(0xff)
// Disable row13 col0 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL0_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL0_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL0_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL0_MASK_ENABLE_RANGE                        0:0
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL0_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL0_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL0_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL0_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL0_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL0_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL0_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row13 col1 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL1_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL1_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL1_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL1_MASK_ENABLE_RANGE                        1:1
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL1_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL1_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL1_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL1_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL1_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL1_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL1_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row13 col2 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL2_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(2)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL2_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL2_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL2_MASK_ENABLE_RANGE                        2:2
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL2_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL2_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL2_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL2_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL2_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL2_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL2_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row13 col3 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL3_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(3)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL3_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL3_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL3_MASK_ENABLE_RANGE                        3:3
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL3_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL3_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL3_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL3_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL3_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL3_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL3_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row13 col4 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL4_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(4)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL4_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL4_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL4_MASK_ENABLE_RANGE                        4:4
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL4_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL4_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL4_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL4_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL4_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL4_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL4_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row13 col5 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL5_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL5_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL5_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL5_MASK_ENABLE_RANGE                        5:5
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL5_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL5_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL5_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL5_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL5_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL5_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL5_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row13 col6 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL6_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL6_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL6_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL6_MASK_ENABLE_RANGE                        6:6
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL6_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL6_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL6_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL6_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL6_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL6_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL6_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row13 col7 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL7_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(7)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL7_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL7_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL7_MASK_ENABLE_RANGE                        7:7
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL7_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL7_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL7_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL7_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL7_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL7_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW13_MASK_0_KBC_ROW13_COL7_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)


// Register APBDEV_KBC_ROW14_MASK_0  
#define APBDEV_KBC_ROW14_MASK_0                 _MK_ADDR_CONST(0x70)
#define APBDEV_KBC_ROW14_MASK_0_SECURE                  0x0
#define APBDEV_KBC_ROW14_MASK_0_WORD_COUNT                      0x1
#define APBDEV_KBC_ROW14_MASK_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_RESET_MASK                      _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW14_MASK_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW14_MASK_0_WRITE_MASK                      _MK_MASK_CONST(0xff)
// Disable row14 col0 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL0_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL0_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL0_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL0_MASK_ENABLE_RANGE                        0:0
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL0_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL0_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL0_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL0_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL0_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL0_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL0_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row14 col1 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL1_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL1_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL1_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL1_MASK_ENABLE_RANGE                        1:1
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL1_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL1_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL1_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL1_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL1_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL1_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL1_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row14 col2 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL2_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(2)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL2_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL2_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL2_MASK_ENABLE_RANGE                        2:2
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL2_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL2_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL2_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL2_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL2_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL2_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL2_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row14 col3 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL3_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(3)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL3_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL3_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL3_MASK_ENABLE_RANGE                        3:3
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL3_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL3_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL3_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL3_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL3_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL3_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL3_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row14 col4 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL4_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(4)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL4_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL4_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL4_MASK_ENABLE_RANGE                        4:4
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL4_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL4_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL4_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL4_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL4_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL4_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL4_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row14 col5 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL5_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL5_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL5_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL5_MASK_ENABLE_RANGE                        5:5
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL5_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL5_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL5_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL5_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL5_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL5_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL5_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row14 col6 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL6_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL6_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL6_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL6_MASK_ENABLE_RANGE                        6:6
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL6_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL6_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL6_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL6_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL6_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL6_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL6_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row14 col7 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL7_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(7)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL7_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL7_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL7_MASK_ENABLE_RANGE                        7:7
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL7_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL7_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL7_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL7_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL7_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL7_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW14_MASK_0_KBC_ROW14_COL7_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)


// Register APBDEV_KBC_ROW15_MASK_0  
#define APBDEV_KBC_ROW15_MASK_0                 _MK_ADDR_CONST(0x74)
#define APBDEV_KBC_ROW15_MASK_0_SECURE                  0x0
#define APBDEV_KBC_ROW15_MASK_0_WORD_COUNT                      0x1
#define APBDEV_KBC_ROW15_MASK_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_RESET_MASK                      _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW15_MASK_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define APBDEV_KBC_ROW15_MASK_0_WRITE_MASK                      _MK_MASK_CONST(0xff)
// Disable row15 col0 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL0_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL0_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL0_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL0_MASK_ENABLE_RANGE                        0:0
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL0_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL0_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL0_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL0_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL0_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL0_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL0_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row15 col1 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL1_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(1)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL1_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL1_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL1_MASK_ENABLE_RANGE                        1:1
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL1_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL1_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL1_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL1_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL1_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL1_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL1_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row15 col2 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL2_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(2)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL2_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL2_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL2_MASK_ENABLE_RANGE                        2:2
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL2_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL2_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL2_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL2_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL2_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL2_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL2_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row15 col3 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL3_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(3)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL3_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL3_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL3_MASK_ENABLE_RANGE                        3:3
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL3_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL3_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL3_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL3_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL3_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL3_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL3_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row15 col4 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL4_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(4)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL4_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL4_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL4_MASK_ENABLE_RANGE                        4:4
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL4_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL4_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL4_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL4_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL4_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL4_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL4_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row15 col5 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL5_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(5)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL5_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL5_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL5_MASK_ENABLE_RANGE                        5:5
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL5_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL5_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL5_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL5_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL5_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL5_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL5_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row15 col6 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL6_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(6)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL6_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL6_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL6_MASK_ENABLE_RANGE                        6:6
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL6_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL6_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL6_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL6_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL6_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL6_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL6_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)

// Disable row15 col7 when system is in suspend/deep sleep mode
// 1 Disable row/col pair
// 0 Enable row/col pair
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL7_MASK_ENABLE_SHIFT                        _MK_SHIFT_CONST(7)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL7_MASK_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL7_MASK_ENABLE_SHIFT)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL7_MASK_ENABLE_RANGE                        7:7
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL7_MASK_ENABLE_WOFFSET                      0x0
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL7_MASK_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL7_MASK_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL7_MASK_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL7_MASK_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL7_MASK_ENABLE_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_KBC_ROW15_MASK_0_KBC_ROW15_COL7_MASK_ENABLE_DISABLE                      _MK_ENUM_CONST(1)


//
// REGISTER LIST
//
#define LIST_ARAPBDEV_KBC_REGS(_op_) \
_op_(APBDEV_KBC_CONTROL_0) \
_op_(APBDEV_KBC_INT_0) \
_op_(APBDEV_KBC_ROW_CFG0_0) \
_op_(APBDEV_KBC_ROW_CFG1_0) \
_op_(APBDEV_KBC_ROW_CFG2_0) \
_op_(APBDEV_KBC_ROW_CFG3_0) \
_op_(APBDEV_KBC_COL_CFG0_0) \
_op_(APBDEV_KBC_COL_CFG1_0) \
_op_(APBDEV_KBC_COL_CFG2_0) \
_op_(APBDEV_KBC_TO_CNT_0) \
_op_(APBDEV_KBC_INIT_DLY_0) \
_op_(APBDEV_KBC_RPT_DLY_0) \
_op_(APBDEV_KBC_KP_ENT0_0) \
_op_(APBDEV_KBC_KP_ENT1_0) \
_op_(APBDEV_KBC_ROW0_MASK_0) \
_op_(APBDEV_KBC_ROW1_MASK_0) \
_op_(APBDEV_KBC_ROW2_MASK_0) \
_op_(APBDEV_KBC_ROW3_MASK_0) \
_op_(APBDEV_KBC_ROW4_MASK_0) \
_op_(APBDEV_KBC_ROW5_MASK_0) \
_op_(APBDEV_KBC_ROW6_MASK_0) \
_op_(APBDEV_KBC_ROW7_MASK_0) \
_op_(APBDEV_KBC_ROW8_MASK_0) \
_op_(APBDEV_KBC_ROW9_MASK_0) \
_op_(APBDEV_KBC_ROW10_MASK_0) \
_op_(APBDEV_KBC_ROW11_MASK_0) \
_op_(APBDEV_KBC_ROW12_MASK_0) \
_op_(APBDEV_KBC_ROW13_MASK_0) \
_op_(APBDEV_KBC_ROW14_MASK_0) \
_op_(APBDEV_KBC_ROW15_MASK_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_APBDEV_KBC 0x00000000

//
// ARAPBDEV_KBC REGISTER BANKS
//

#define APBDEV_KBC0_FIRST_REG 0x0000 // APBDEV_KBC_CONTROL_0
#define APBDEV_KBC0_LAST_REG 0x0074 // APBDEV_KBC_ROW15_MASK_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARAPBDEV_KBC_H_INC_
