/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARAPBDMACHAN_H_INC_
#define ___ARAPBDMACHAN_H_INC_

// Register APBDMACHAN_CHANNEL_0_CSR_0  
#define APBDMACHAN_CHANNEL_0_CSR_0                      _MK_ADDR_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_0_CSR_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_0_CSR_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_RESET_MASK                   _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_0_CSR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_READ_MASK                    _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_0_CSR_0_WRITE_MASK                   _MK_MASK_CONST(0xfffffffc)
// Enables DMA channel transfer 
#define APBDMACHAN_CHANNEL_0_CSR_0_ENB_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_0_CSR_0_ENB_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_0_CSR_0_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_0_CSR_0_ENB_RANGE                    31:31
#define APBDMACHAN_CHANNEL_0_CSR_0_ENB_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_0_CSR_0_ENB_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_ENB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_0_CSR_0_ENB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_ENB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_ENB_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_CSR_0_ENB_ENABLE                   _MK_ENUM_CONST(1)

// Interrupts when DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_0_CSR_0_IE_EOC_SHIFT                 _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_0_CSR_0_IE_EOC_FIELD                 (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_0_CSR_0_IE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_0_CSR_0_IE_EOC_RANGE                 30:30
#define APBDMACHAN_CHANNEL_0_CSR_0_IE_EOC_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_0_CSR_0_IE_EOC_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_IE_EOC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_0_CSR_0_IE_EOC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_IE_EOC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_IE_EOC_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_CSR_0_IE_EOC_ENABLE                        _MK_ENUM_CONST(1)

// Holds this Processor until DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_0_CSR_0_HOLD_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_0_CSR_0_HOLD_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_0_CSR_0_HOLD_SHIFT)
#define APBDMACHAN_CHANNEL_0_CSR_0_HOLD_RANGE                   29:29
#define APBDMACHAN_CHANNEL_0_CSR_0_HOLD_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_0_CSR_0_HOLD_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_HOLD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_0_CSR_0_HOLD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_HOLD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_HOLD_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_CSR_0_HOLD_ENABLE                  _MK_ENUM_CONST(1)

//DMA Transfer Direction 1 = AHB read to APB write 0 = APB read to AHB write
#define APBDMACHAN_CHANNEL_0_CSR_0_DIR_SHIFT                    _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_0_CSR_0_DIR_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_0_CSR_0_DIR_SHIFT)
#define APBDMACHAN_CHANNEL_0_CSR_0_DIR_RANGE                    28:28
#define APBDMACHAN_CHANNEL_0_CSR_0_DIR_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_0_CSR_0_DIR_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_DIR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_0_CSR_0_DIR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_DIR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_DIR_AHB_WRITE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_CSR_0_DIR_AHB_READ                 _MK_ENUM_CONST(1)

// Run Once or Run Multiple Mode (Allow Retriggering of this Channel) 1 = Run for One Block Transfer 0 = Run for Multiple Block Transfer
#define APBDMACHAN_CHANNEL_0_CSR_0_ONCE_SHIFT                   _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_0_CSR_0_ONCE_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_0_CSR_0_ONCE_SHIFT)
#define APBDMACHAN_CHANNEL_0_CSR_0_ONCE_RANGE                   27:27
#define APBDMACHAN_CHANNEL_0_CSR_0_ONCE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_0_CSR_0_ONCE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_ONCE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_0_CSR_0_ONCE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_ONCE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_ONCE_MULTIPLE_BLOCK                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_CSR_0_ONCE_SINGLE_BLOCK                    _MK_ENUM_CONST(1)

// Enable on Non-Zero Value
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_SHIFT                       _MK_SHIFT_CONST(22)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_FIELD                       (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_RANGE                       26:22
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_NA1                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_SMP24                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_SMP25                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_SMP26                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_SMP27                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_XRQ_A                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_XRQ_B                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_TMR1                        _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_TMR2                        _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_APB_0                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_APB_1                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_APB_2                       _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_APB_3                       _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_APB_4                       _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_APB_5                       _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_APB_6                       _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_APB_7                       _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_APB_8                       _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_APB_9                       _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_APB_10                      _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_APB_11                      _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_APB_12                      _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_APB_13                      _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_APB_14                      _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_0_CSR_0_TRIG_SEL_APB_15                      _MK_ENUM_CONST(24)

// Flow Control Enable (Synchronize Burst Transfers) 1 = Link to DRQ source 0 = Independent of DRQ request
#define APBDMACHAN_CHANNEL_0_CSR_0_FLOW_SHIFT                   _MK_SHIFT_CONST(21)
#define APBDMACHAN_CHANNEL_0_CSR_0_FLOW_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_0_CSR_0_FLOW_SHIFT)
#define APBDMACHAN_CHANNEL_0_CSR_0_FLOW_RANGE                   21:21
#define APBDMACHAN_CHANNEL_0_CSR_0_FLOW_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_0_CSR_0_FLOW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_FLOW_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_0_CSR_0_FLOW_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_FLOW_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_FLOW_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_CSR_0_FLOW_ENABLE                  _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_SHIFT                        _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_FIELD                        (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_RANGE                        20:16
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_CNTR_REQ                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_I2S_2                        _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_I2S_1                        _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_SPD_I                        _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_UI_I                 _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_MIPI                 _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_I2S2_2                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_I2S2_1                       _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_UART_A                       _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_UART_B                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_UART_C                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_SPI                  _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_AC97                 _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_ACModem                      _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_SL4B                 _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_SL2B1                        _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_SL2B2                        _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_SL2B3                        _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_SL2B4                        _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_UART_D                       _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_UART_E                       _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_I2C                  _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_I2C2                 _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_I2C3                 _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_DVC_I2C                      _MK_ENUM_CONST(24)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_OWR                  _MK_ENUM_CONST(25)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_NA26                 _MK_ENUM_CONST(26)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_NA27                 _MK_ENUM_CONST(27)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_NA28                 _MK_ENUM_CONST(28)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_NA29                 _MK_ENUM_CONST(29)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_NA30                 _MK_ENUM_CONST(30)
#define APBDMACHAN_CHANNEL_0_CSR_0_REQ_SEL_NA31                 _MK_ENUM_CONST(31)

// Number of 32bit word cycles
#define APBDMACHAN_CHANNEL_0_CSR_0_WCOUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_0_CSR_0_WCOUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_0_CSR_0_WCOUNT_SHIFT)
#define APBDMACHAN_CHANNEL_0_CSR_0_WCOUNT_RANGE                 15:2
#define APBDMACHAN_CHANNEL_0_CSR_0_WCOUNT_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_0_CSR_0_WCOUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_WCOUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_0_CSR_0_WCOUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_CSR_0_WCOUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_0_STA_0  
#define APBDMACHAN_CHANNEL_0_STA_0                      _MK_ADDR_CONST(0x4)
#define APBDMACHAN_CHANNEL_0_STA_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_0_STA_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_0_STA_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_RESET_MASK                   _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_0_STA_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_READ_MASK                    _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_0_STA_0_WRITE_MASK                   _MK_MASK_CONST(0x40000000)
// indicates whether DMA Channel Status active or not
#define APBDMACHAN_CHANNEL_0_STA_0_BSY_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_0_STA_0_BSY_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_0_STA_0_BSY_SHIFT)
#define APBDMACHAN_CHANNEL_0_STA_0_BSY_RANGE                    31:31
#define APBDMACHAN_CHANNEL_0_STA_0_BSY_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_0_STA_0_BSY_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_BSY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_0_STA_0_BSY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_BSY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_BSY_WAIT                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_STA_0_BSY_ACTIVE                   _MK_ENUM_CONST(1)

//  Write '1' to clear the flag                                    
#define APBDMACHAN_CHANNEL_0_STA_0_ISE_EOC_SHIFT                        _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_0_STA_0_ISE_EOC_FIELD                        (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_0_STA_0_ISE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_0_STA_0_ISE_EOC_RANGE                        30:30
#define APBDMACHAN_CHANNEL_0_STA_0_ISE_EOC_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_0_STA_0_ISE_EOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_ISE_EOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_0_STA_0_ISE_EOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_ISE_EOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_ISE_EOC_NO_INTR                      _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_STA_0_ISE_EOC_INTR                 _MK_ENUM_CONST(1)

// Holding Status of Processor
#define APBDMACHAN_CHANNEL_0_STA_0_HALT_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_0_STA_0_HALT_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_0_STA_0_HALT_SHIFT)
#define APBDMACHAN_CHANNEL_0_STA_0_HALT_RANGE                   29:29
#define APBDMACHAN_CHANNEL_0_STA_0_HALT_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_0_STA_0_HALT_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_HALT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_0_STA_0_HALT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_HALT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_HALT_NO_HALT                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_STA_0_HALT_HALT                    _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_0_STA_0_PING_PONG_STA_SHIFT                  _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_0_STA_0_PING_PONG_STA_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_0_STA_0_PING_PONG_STA_SHIFT)
#define APBDMACHAN_CHANNEL_0_STA_0_PING_PONG_STA_RANGE                  28:28
#define APBDMACHAN_CHANNEL_0_STA_0_PING_PONG_STA_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_0_STA_0_PING_PONG_STA_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_PING_PONG_STA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_0_STA_0_PING_PONG_STA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_PING_PONG_STA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_PING_PONG_STA_PING_INTR_STA                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_STA_0_PING_PONG_STA_PONG_INTR_STA                  _MK_ENUM_CONST(1)

// Current 32bit word cycles Flags set /cleared by HW
#define APBDMACHAN_CHANNEL_0_STA_0_COUNT_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_0_STA_0_COUNT_FIELD                  (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_0_STA_0_COUNT_SHIFT)
#define APBDMACHAN_CHANNEL_0_STA_0_COUNT_RANGE                  15:2
#define APBDMACHAN_CHANNEL_0_STA_0_COUNT_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_0_STA_0_COUNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_COUNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_0_STA_0_COUNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_STA_0_COUNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 8 [0x8] 

// Reserved address 12 [0xc] 

// Register APBDMACHAN_CHANNEL_0_AHB_PTR_0  
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0                  _MK_ADDR_CONST(0x10)
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffffffc)
// APB-DMA Starting Address for AHB Bus: SW writes to  modify
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0_AHB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0_AHB_BASE_FIELD                   (_MK_MASK_CONST(0x3fffffff) << APBDMACHAN_CHANNEL_0_AHB_PTR_0_AHB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0_AHB_BASE_RANGE                   31:2
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0_AHB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0_AHB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0_AHB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fffffff)
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0_AHB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_PTR_0_AHB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_0_AHB_SEQ_0  
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0                  _MK_ADDR_CONST(0x14)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20000000)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0xff0f0000)
// 0 = send interrupt to COP
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_INTR_ENB_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_INTR_ENB_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_0_AHB_SEQ_0_INTR_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_INTR_ENB_RANGE                   31:31
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_INTR_ENB_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_INTR_ENB_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_INTR_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_INTR_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_INTR_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_INTR_ENB_CPU                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_INTR_ENB_COP                     _MK_ENUM_CONST(0)

// AHB Bus Width 0 = 8 bit Bus (RSVD) 1 = 16 bit Bus (RSVD) 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD)4 = 128 bit Bus (RSVD)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

// when enabled the data going  to AHB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }.
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

// AHB Burst Size DMA Burst Length (encoded) 4 = 1 Word (1x32bits) 5 = 4 Words (4x32bits)else = 8 Words (8x32bits) default
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BURST_SHIFT                  _MK_SHIFT_CONST(24)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BURST_FIELD                  (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BURST_SHIFT)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BURST_RANGE                  26:24
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BURST_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BURST_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BURST_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BURST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BURST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BURST_DMA_BURST_1WORDS                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BURST_DMA_BURST_4WORDS                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_AHB_BURST_DMA_BURST_8WORDS                       _MK_ENUM_CONST(6)

// 2X Double Buffering Mode (For Run-Multiple Mode with No Wrap Operations) 1 = Reload Base Address for 2X blocks (reload every other time) 0 = Reload Base Address for 1X blocks  (def) (reload each time)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_DBL_BUF_SHIFT                    _MK_SHIFT_CONST(19)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_DBL_BUF_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_0_AHB_SEQ_0_DBL_BUF_SHIFT)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_DBL_BUF_RANGE                    19:19
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_DBL_BUF_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_DBL_BUF_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_DBL_BUF_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_DBL_BUF_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_DBL_BUF_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_1X_BLOCKS                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_2X_BLOCKS                     _MK_ENUM_CONST(1)

// AHB Address Wrap: AHB Address wrap-around window 0=No Wrap (default) 5=Wrap on 512 word window 1=Wrap on 32 word window 6=Wrap on 1024 word window 2=Wrap on 64 word window 7=Wrap on 2048 word window 3=Wrap on 128 word window 4=Wrap on 256 word window
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_FIELD                       (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_RANGE                       18:16
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_NO_WRAP                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_WRAP_0N_32WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_WRAP_ON_64WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_WRAP_ON_128WORDS                    _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_WRAP_ON_256WORDS                    _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_WRAP_ON_512WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_WRAP_ON_1024WORDS                   _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_0_AHB_SEQ_0_WRAP_WRAP_ON_2048WORDS                   _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_0_APB_PTR_0  
#define APBDMACHAN_CHANNEL_0_APB_PTR_0                  _MK_ADDR_CONST(0x18)
#define APBDMACHAN_CHANNEL_0_APB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_0_APB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_0_APB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_APB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_0_APB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_APB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_APB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_0_APB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffc)
// APB-DMA Starting address for APB Bus:APB Base address:Upper 16 bits are fixed at 0x7000:XXXX
#define APBDMACHAN_CHANNEL_0_APB_PTR_0_APB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_0_APB_PTR_0_APB_BASE_FIELD                   (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_0_APB_PTR_0_APB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_0_APB_PTR_0_APB_BASE_RANGE                   15:2
#define APBDMACHAN_CHANNEL_0_APB_PTR_0_APB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_0_APB_PTR_0_APB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_APB_PTR_0_APB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_0_APB_PTR_0_APB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_APB_PTR_0_APB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_0_APB_SEQ_0  
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0                  _MK_ADDR_CONST(0x1c)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20010000)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0x78070000)
// 0 = 8 bit Bus 1 = 16 bit Bus 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD) 4 = 128 bit BUS (RSVD)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

//When enabled the data going  to APB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }.
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

//APB Address Wrap-around Window 0 = No Wrap 1 = Wrap on 1 Word Window (def) 2 = Wrap on 2 Word Window 3 = Wrap on 4 Word Window 4 = Wrap on 8 Word Window 5 = Wrap on 16 Word Window 6 = Wrap on 32 Word Window 7 = Wrap on 64 Word Window (rsvd)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_RANGE                      18:16
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_NO_WRAP                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_WRAP_0N_1WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_2WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_4WORDS                     _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_8WORDS                     _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_16WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_32WORDS                    _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_0_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_64WORDS                    _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_1_CSR_0  
#define APBDMACHAN_CHANNEL_1_CSR_0                      _MK_ADDR_CONST(0x20)
#define APBDMACHAN_CHANNEL_1_CSR_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_1_CSR_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_1_CSR_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_RESET_MASK                   _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_1_CSR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_READ_MASK                    _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_1_CSR_0_WRITE_MASK                   _MK_MASK_CONST(0xfffffffc)
// Enables DMA channel transfer 
#define APBDMACHAN_CHANNEL_1_CSR_0_ENB_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_1_CSR_0_ENB_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_1_CSR_0_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_1_CSR_0_ENB_RANGE                    31:31
#define APBDMACHAN_CHANNEL_1_CSR_0_ENB_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_1_CSR_0_ENB_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_ENB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_1_CSR_0_ENB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_ENB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_ENB_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_CSR_0_ENB_ENABLE                   _MK_ENUM_CONST(1)

// Interrupts when DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_1_CSR_0_IE_EOC_SHIFT                 _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_1_CSR_0_IE_EOC_FIELD                 (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_1_CSR_0_IE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_1_CSR_0_IE_EOC_RANGE                 30:30
#define APBDMACHAN_CHANNEL_1_CSR_0_IE_EOC_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_1_CSR_0_IE_EOC_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_IE_EOC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_1_CSR_0_IE_EOC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_IE_EOC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_IE_EOC_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_CSR_0_IE_EOC_ENABLE                        _MK_ENUM_CONST(1)

// Holds this Processor until DMA Block Transfer Completes
#define APBDMACHAN_CHANNEL_1_CSR_0_HOLD_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_1_CSR_0_HOLD_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_1_CSR_0_HOLD_SHIFT)
#define APBDMACHAN_CHANNEL_1_CSR_0_HOLD_RANGE                   29:29
#define APBDMACHAN_CHANNEL_1_CSR_0_HOLD_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_1_CSR_0_HOLD_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_HOLD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_1_CSR_0_HOLD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_HOLD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_HOLD_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_CSR_0_HOLD_ENABLE                  _MK_ENUM_CONST(1)

// DMA Transfer Direction 1 = AHB read to APB write 0 = APB read to AHB write
#define APBDMACHAN_CHANNEL_1_CSR_0_DIR_SHIFT                    _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_1_CSR_0_DIR_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_1_CSR_0_DIR_SHIFT)
#define APBDMACHAN_CHANNEL_1_CSR_0_DIR_RANGE                    28:28
#define APBDMACHAN_CHANNEL_1_CSR_0_DIR_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_1_CSR_0_DIR_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_DIR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_1_CSR_0_DIR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_DIR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_DIR_AHB_WRITE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_CSR_0_DIR_AHB_READ                 _MK_ENUM_CONST(1)

// Run Once or Run Multiple Mode (Allow Retriggering of this Channel) 1 = Run for One Block Transfer 0 = Run for Multiple Block Transfer
#define APBDMACHAN_CHANNEL_1_CSR_0_ONCE_SHIFT                   _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_1_CSR_0_ONCE_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_1_CSR_0_ONCE_SHIFT)
#define APBDMACHAN_CHANNEL_1_CSR_0_ONCE_RANGE                   27:27
#define APBDMACHAN_CHANNEL_1_CSR_0_ONCE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_1_CSR_0_ONCE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_ONCE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_1_CSR_0_ONCE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_ONCE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_ONCE_MULTIPLE_BLOCK                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_CSR_0_ONCE_SINGLE_BLOCK                    _MK_ENUM_CONST(1)

// Enable on Non-Zero Value
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_SHIFT                       _MK_SHIFT_CONST(22)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_FIELD                       (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_RANGE                       26:22
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_NA1                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_SMP24                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_SMP25                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_SMP26                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_SMP27                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_XRQ_A                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_XRQ_B                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_TMR1                        _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_TMR2                        _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_APB_0                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_APB_1                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_APB_2                       _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_APB_3                       _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_APB_4                       _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_APB_5                       _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_APB_6                       _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_APB_7                       _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_APB_8                       _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_APB_9                       _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_APB_10                      _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_APB_11                      _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_APB_12                      _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_APB_13                      _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_APB_14                      _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_1_CSR_0_TRIG_SEL_APB_15                      _MK_ENUM_CONST(24)

// Flow Control Enable (Synchronize Burst Transfers) 1 = Link to DRQ source 0 = Independent of DRQ request
#define APBDMACHAN_CHANNEL_1_CSR_0_FLOW_SHIFT                   _MK_SHIFT_CONST(21)
#define APBDMACHAN_CHANNEL_1_CSR_0_FLOW_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_1_CSR_0_FLOW_SHIFT)
#define APBDMACHAN_CHANNEL_1_CSR_0_FLOW_RANGE                   21:21
#define APBDMACHAN_CHANNEL_1_CSR_0_FLOW_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_1_CSR_0_FLOW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_FLOW_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_1_CSR_0_FLOW_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_FLOW_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_FLOW_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_CSR_0_FLOW_ENABLE                  _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_SHIFT                        _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_FIELD                        (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_RANGE                        20:16
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_CNTR_REQ                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_I2S_2                        _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_I2S_1                        _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_SPD_I                        _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_UI_I                 _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_MIPI                 _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_I2S2_2                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_I2S2_1                       _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_UART_A                       _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_UART_B                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_UART_C                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_SPI                  _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_AC97                 _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_ACModem                      _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_SL4B                 _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_SL2B1                        _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_SL2B2                        _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_SL2B3                        _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_SL2B4                        _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_UART_D                       _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_UART_E                       _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_I2C                  _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_I2C2                 _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_I2C3                 _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_DVC_I2C                      _MK_ENUM_CONST(24)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_OWR                  _MK_ENUM_CONST(25)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_NA26                 _MK_ENUM_CONST(26)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_NA27                 _MK_ENUM_CONST(27)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_NA28                 _MK_ENUM_CONST(28)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_NA29                 _MK_ENUM_CONST(29)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_NA30                 _MK_ENUM_CONST(30)
#define APBDMACHAN_CHANNEL_1_CSR_0_REQ_SEL_NA31                 _MK_ENUM_CONST(31)

// Number of 32bit word cycles
#define APBDMACHAN_CHANNEL_1_CSR_0_WCOUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_1_CSR_0_WCOUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_1_CSR_0_WCOUNT_SHIFT)
#define APBDMACHAN_CHANNEL_1_CSR_0_WCOUNT_RANGE                 15:2
#define APBDMACHAN_CHANNEL_1_CSR_0_WCOUNT_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_1_CSR_0_WCOUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_WCOUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_1_CSR_0_WCOUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_CSR_0_WCOUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_1_STA_0  
#define APBDMACHAN_CHANNEL_1_STA_0                      _MK_ADDR_CONST(0x24)
#define APBDMACHAN_CHANNEL_1_STA_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_1_STA_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_1_STA_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_RESET_MASK                   _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_1_STA_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_READ_MASK                    _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_1_STA_0_WRITE_MASK                   _MK_MASK_CONST(0x40000000)
// indicates whether DMA Channel Status active or not
#define APBDMACHAN_CHANNEL_1_STA_0_BSY_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_1_STA_0_BSY_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_1_STA_0_BSY_SHIFT)
#define APBDMACHAN_CHANNEL_1_STA_0_BSY_RANGE                    31:31
#define APBDMACHAN_CHANNEL_1_STA_0_BSY_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_1_STA_0_BSY_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_BSY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_1_STA_0_BSY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_BSY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_BSY_WAIT                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_STA_0_BSY_ACTIVE                   _MK_ENUM_CONST(1)

//  Write '1' to clear the flag
#define APBDMACHAN_CHANNEL_1_STA_0_ISE_EOC_SHIFT                        _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_1_STA_0_ISE_EOC_FIELD                        (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_1_STA_0_ISE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_1_STA_0_ISE_EOC_RANGE                        30:30
#define APBDMACHAN_CHANNEL_1_STA_0_ISE_EOC_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_1_STA_0_ISE_EOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_ISE_EOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_1_STA_0_ISE_EOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_ISE_EOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_ISE_EOC_NO_INTR                      _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_STA_0_ISE_EOC_INTR                 _MK_ENUM_CONST(1)

// Holding Status of Processor
#define APBDMACHAN_CHANNEL_1_STA_0_HALT_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_1_STA_0_HALT_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_1_STA_0_HALT_SHIFT)
#define APBDMACHAN_CHANNEL_1_STA_0_HALT_RANGE                   29:29
#define APBDMACHAN_CHANNEL_1_STA_0_HALT_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_1_STA_0_HALT_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_HALT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_1_STA_0_HALT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_HALT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_HALT_NO_HALT                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_STA_0_HALT_HALT                    _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_1_STA_0_PING_PONG_STA_SHIFT                  _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_1_STA_0_PING_PONG_STA_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_1_STA_0_PING_PONG_STA_SHIFT)
#define APBDMACHAN_CHANNEL_1_STA_0_PING_PONG_STA_RANGE                  28:28
#define APBDMACHAN_CHANNEL_1_STA_0_PING_PONG_STA_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_1_STA_0_PING_PONG_STA_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_PING_PONG_STA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_1_STA_0_PING_PONG_STA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_PING_PONG_STA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_PING_PONG_STA_PING_INTR_STA                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_STA_0_PING_PONG_STA_PONG_INTR_STA                  _MK_ENUM_CONST(1)

// Current 32bit word cycles Flags set /cleared by HW
#define APBDMACHAN_CHANNEL_1_STA_0_COUNT_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_1_STA_0_COUNT_FIELD                  (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_1_STA_0_COUNT_SHIFT)
#define APBDMACHAN_CHANNEL_1_STA_0_COUNT_RANGE                  15:2
#define APBDMACHAN_CHANNEL_1_STA_0_COUNT_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_1_STA_0_COUNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_COUNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_1_STA_0_COUNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_STA_0_COUNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 40 [0x28] 

// Reserved address 44 [0x2c] 

// Register APBDMACHAN_CHANNEL_1_AHB_PTR_0  
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0                  _MK_ADDR_CONST(0x30)
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffffffc)
// APB-DMA Starting Address for AHB Bus: SW writes to  modify
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0_AHB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0_AHB_BASE_FIELD                   (_MK_MASK_CONST(0x3fffffff) << APBDMACHAN_CHANNEL_1_AHB_PTR_0_AHB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0_AHB_BASE_RANGE                   31:2
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0_AHB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0_AHB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0_AHB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fffffff)
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0_AHB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_PTR_0_AHB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_1_AHB_SEQ_0  
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0                  _MK_ADDR_CONST(0x34)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20000000)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0xff0f0000)
// 0 = send interrupt to COP
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_INTR_ENB_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_INTR_ENB_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_1_AHB_SEQ_0_INTR_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_INTR_ENB_RANGE                   31:31
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_INTR_ENB_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_INTR_ENB_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_INTR_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_INTR_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_INTR_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_INTR_ENB_CPU                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_INTR_ENB_COP                     _MK_ENUM_CONST(0)

// AHB Bus Width 0 = 8 bit Bus (RSVD) 1 = 16 bit Bus (RSVD) 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD)4 = 128 bit Bus (RSVD)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

//when enabled the data going  to AHB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

// AHB Burst Size DMA Burst Length (encoded) 4 = 1 Word (1x32bits) 5 = 4 Words (4x32bits)else = 8 Words (8x32bits) default
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BURST_SHIFT                  _MK_SHIFT_CONST(24)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BURST_FIELD                  (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BURST_SHIFT)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BURST_RANGE                  26:24
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BURST_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BURST_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BURST_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BURST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BURST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BURST_DMA_BURST_1WORDS                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BURST_DMA_BURST_4WORDS                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_AHB_BURST_DMA_BURST_8WORDS                       _MK_ENUM_CONST(6)

// 2X Double Buffering Mode (For Run-Multiple Mode with No Wrap Operations) 1 = Reload Base Address for 2X blocks (reload every other time) 0 = Reload Base Address for 1X blocks  (def) (reload each time)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_DBL_BUF_SHIFT                    _MK_SHIFT_CONST(19)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_DBL_BUF_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_1_AHB_SEQ_0_DBL_BUF_SHIFT)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_DBL_BUF_RANGE                    19:19
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_DBL_BUF_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_DBL_BUF_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_DBL_BUF_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_DBL_BUF_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_DBL_BUF_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_1X_BLOCKS                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_2X_BLOCKS                     _MK_ENUM_CONST(1)

// AHB Address Wrap: AHB Address wrap-around window 0=No Wrap (default) 5=Wrap on 512 word window 1=Wrap on 32 word window 6=Wrap on 1024 word window 2=Wrap on 64 word window 7=Wrap on 2048 word window 3=Wrap on 128 word window 4=Wrap on 256 word window
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_FIELD                       (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_RANGE                       18:16
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_NO_WRAP                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_WRAP_0N_32WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_WRAP_ON_64WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_WRAP_ON_128WORDS                    _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_WRAP_ON_256WORDS                    _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_WRAP_ON_512WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_WRAP_ON_1024WORDS                   _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_1_AHB_SEQ_0_WRAP_WRAP_ON_2048WORDS                   _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_1_APB_PTR_0  
#define APBDMACHAN_CHANNEL_1_APB_PTR_0                  _MK_ADDR_CONST(0x38)
#define APBDMACHAN_CHANNEL_1_APB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_1_APB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_1_APB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_APB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_1_APB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_APB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_APB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_1_APB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffc)
// APB-DMA Starting address for APB Bus: APB Base address: Upper 16 bits are fixed at 0x7000:XXXX
#define APBDMACHAN_CHANNEL_1_APB_PTR_0_APB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_1_APB_PTR_0_APB_BASE_FIELD                   (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_1_APB_PTR_0_APB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_1_APB_PTR_0_APB_BASE_RANGE                   15:2
#define APBDMACHAN_CHANNEL_1_APB_PTR_0_APB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_1_APB_PTR_0_APB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_APB_PTR_0_APB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_1_APB_PTR_0_APB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_APB_PTR_0_APB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_1_APB_SEQ_0  
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0                  _MK_ADDR_CONST(0x3c)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20010000)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0x78070000)
// 0 = 8 bit Bus 1 = 16 bit Bus 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD) 4 = 128 bit BUS (RSVD)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

//when enabled the data going  to APB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

//APB Address Wrap-around Window 0 = No Wrap 1 = Wrap on 1 Word Window (def) 2 = Wrap on 2 Word Window 3 = Wrap on 4 Word Window 4 = Wrap on 8 Word Window 5 = Wrap on 16 Word Window 6 = Wrap on 32 Word Window 7 = Wrap on 64 Word Window (rsvd)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_RANGE                      18:16
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_NO_WRAP                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_WRAP_0N_1WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_2WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_4WORDS                     _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_8WORDS                     _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_16WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_32WORDS                    _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_1_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_64WORDS                    _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_2_CSR_0  
#define APBDMACHAN_CHANNEL_2_CSR_0                      _MK_ADDR_CONST(0x40)
#define APBDMACHAN_CHANNEL_2_CSR_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_2_CSR_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_2_CSR_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_RESET_MASK                   _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_2_CSR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_READ_MASK                    _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_2_CSR_0_WRITE_MASK                   _MK_MASK_CONST(0xfffffffc)
// Enables DMA channel transfer 
#define APBDMACHAN_CHANNEL_2_CSR_0_ENB_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_2_CSR_0_ENB_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_2_CSR_0_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_2_CSR_0_ENB_RANGE                    31:31
#define APBDMACHAN_CHANNEL_2_CSR_0_ENB_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_2_CSR_0_ENB_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_ENB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_2_CSR_0_ENB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_ENB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_ENB_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_CSR_0_ENB_ENABLE                   _MK_ENUM_CONST(1)

// Interrupts when DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_2_CSR_0_IE_EOC_SHIFT                 _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_2_CSR_0_IE_EOC_FIELD                 (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_2_CSR_0_IE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_2_CSR_0_IE_EOC_RANGE                 30:30
#define APBDMACHAN_CHANNEL_2_CSR_0_IE_EOC_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_2_CSR_0_IE_EOC_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_IE_EOC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_2_CSR_0_IE_EOC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_IE_EOC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_IE_EOC_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_CSR_0_IE_EOC_ENABLE                        _MK_ENUM_CONST(1)

// Holds this Processor until DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_2_CSR_0_HOLD_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_2_CSR_0_HOLD_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_2_CSR_0_HOLD_SHIFT)
#define APBDMACHAN_CHANNEL_2_CSR_0_HOLD_RANGE                   29:29
#define APBDMACHAN_CHANNEL_2_CSR_0_HOLD_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_2_CSR_0_HOLD_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_HOLD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_2_CSR_0_HOLD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_HOLD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_HOLD_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_CSR_0_HOLD_ENABLE                  _MK_ENUM_CONST(1)

// DMA Transfer Direction 1 = AHB read to APB write 0 = APB read to AHB write
#define APBDMACHAN_CHANNEL_2_CSR_0_DIR_SHIFT                    _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_2_CSR_0_DIR_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_2_CSR_0_DIR_SHIFT)
#define APBDMACHAN_CHANNEL_2_CSR_0_DIR_RANGE                    28:28
#define APBDMACHAN_CHANNEL_2_CSR_0_DIR_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_2_CSR_0_DIR_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_DIR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_2_CSR_0_DIR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_DIR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_DIR_AHB_WRITE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_CSR_0_DIR_AHB_READ                 _MK_ENUM_CONST(1)

// Run Once or Run Multiple Mode (Allow Retriggering of this Channel) 1 = Run for One Block Transfer 0 = Run for Multiple Block Transfer
#define APBDMACHAN_CHANNEL_2_CSR_0_ONCE_SHIFT                   _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_2_CSR_0_ONCE_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_2_CSR_0_ONCE_SHIFT)
#define APBDMACHAN_CHANNEL_2_CSR_0_ONCE_RANGE                   27:27
#define APBDMACHAN_CHANNEL_2_CSR_0_ONCE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_2_CSR_0_ONCE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_ONCE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_2_CSR_0_ONCE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_ONCE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_ONCE_MULTIPLE_BLOCK                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_CSR_0_ONCE_SINGLE_BLOCK                    _MK_ENUM_CONST(1)

// Enable on Non-Zero Value
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_SHIFT                       _MK_SHIFT_CONST(22)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_FIELD                       (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_RANGE                       26:22
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_NA1                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_SMP24                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_SMP25                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_SMP26                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_SMP27                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_XRQ_A                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_XRQ_B                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_TMR1                        _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_TMR2                        _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_APB_0                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_APB_1                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_APB_2                       _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_APB_3                       _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_APB_4                       _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_APB_5                       _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_APB_6                       _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_APB_7                       _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_APB_8                       _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_APB_9                       _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_APB_10                      _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_APB_11                      _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_APB_12                      _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_APB_13                      _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_APB_14                      _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_2_CSR_0_TRIG_SEL_APB_15                      _MK_ENUM_CONST(24)

// Flow Control Enable (Synchronize Burst Transfers) 1 = Link to DRQ source 0 = Independent of DRQ request
#define APBDMACHAN_CHANNEL_2_CSR_0_FLOW_SHIFT                   _MK_SHIFT_CONST(21)
#define APBDMACHAN_CHANNEL_2_CSR_0_FLOW_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_2_CSR_0_FLOW_SHIFT)
#define APBDMACHAN_CHANNEL_2_CSR_0_FLOW_RANGE                   21:21
#define APBDMACHAN_CHANNEL_2_CSR_0_FLOW_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_2_CSR_0_FLOW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_FLOW_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_2_CSR_0_FLOW_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_FLOW_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_FLOW_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_CSR_0_FLOW_ENABLE                  _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_SHIFT                        _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_FIELD                        (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_RANGE                        20:16
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_CNTR_REQ                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_I2S_2                        _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_I2S_1                        _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_SPD_I                        _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_UI_I                 _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_MIPI                 _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_I2S2_2                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_I2S2_1                       _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_UART_A                       _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_UART_B                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_UART_C                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_SPI                  _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_AC97                 _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_ACModem                      _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_SL4B                 _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_SL2B1                        _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_SL2B2                        _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_SL2B3                        _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_SL2B4                        _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_UART_D                       _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_UART_E                       _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_I2C                  _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_I2C2                 _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_I2C3                 _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_DVC_I2C                      _MK_ENUM_CONST(24)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_OWR                  _MK_ENUM_CONST(25)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_NA26                 _MK_ENUM_CONST(26)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_NA27                 _MK_ENUM_CONST(27)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_NA28                 _MK_ENUM_CONST(28)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_NA29                 _MK_ENUM_CONST(29)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_NA30                 _MK_ENUM_CONST(30)
#define APBDMACHAN_CHANNEL_2_CSR_0_REQ_SEL_NA31                 _MK_ENUM_CONST(31)

// Number of 32bit word cycles
#define APBDMACHAN_CHANNEL_2_CSR_0_WCOUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_2_CSR_0_WCOUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_2_CSR_0_WCOUNT_SHIFT)
#define APBDMACHAN_CHANNEL_2_CSR_0_WCOUNT_RANGE                 15:2
#define APBDMACHAN_CHANNEL_2_CSR_0_WCOUNT_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_2_CSR_0_WCOUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_WCOUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_2_CSR_0_WCOUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_CSR_0_WCOUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_2_STA_0  
#define APBDMACHAN_CHANNEL_2_STA_0                      _MK_ADDR_CONST(0x44)
#define APBDMACHAN_CHANNEL_2_STA_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_2_STA_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_2_STA_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_RESET_MASK                   _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_2_STA_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_READ_MASK                    _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_2_STA_0_WRITE_MASK                   _MK_MASK_CONST(0x40000000)
// indicates whether DMA Channel Status active or not
#define APBDMACHAN_CHANNEL_2_STA_0_BSY_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_2_STA_0_BSY_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_2_STA_0_BSY_SHIFT)
#define APBDMACHAN_CHANNEL_2_STA_0_BSY_RANGE                    31:31
#define APBDMACHAN_CHANNEL_2_STA_0_BSY_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_2_STA_0_BSY_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_BSY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_2_STA_0_BSY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_BSY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_BSY_WAIT                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_STA_0_BSY_ACTIVE                   _MK_ENUM_CONST(1)

//  Write '1' to clear the flag
#define APBDMACHAN_CHANNEL_2_STA_0_ISE_EOC_SHIFT                        _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_2_STA_0_ISE_EOC_FIELD                        (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_2_STA_0_ISE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_2_STA_0_ISE_EOC_RANGE                        30:30
#define APBDMACHAN_CHANNEL_2_STA_0_ISE_EOC_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_2_STA_0_ISE_EOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_ISE_EOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_2_STA_0_ISE_EOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_ISE_EOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_ISE_EOC_NO_INTR                      _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_STA_0_ISE_EOC_INTR                 _MK_ENUM_CONST(1)

// Holding Status of Processor 
#define APBDMACHAN_CHANNEL_2_STA_0_HALT_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_2_STA_0_HALT_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_2_STA_0_HALT_SHIFT)
#define APBDMACHAN_CHANNEL_2_STA_0_HALT_RANGE                   29:29
#define APBDMACHAN_CHANNEL_2_STA_0_HALT_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_2_STA_0_HALT_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_HALT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_2_STA_0_HALT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_HALT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_HALT_NO_HALT                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_STA_0_HALT_HALT                    _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_2_STA_0_PING_PONG_STA_SHIFT                  _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_2_STA_0_PING_PONG_STA_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_2_STA_0_PING_PONG_STA_SHIFT)
#define APBDMACHAN_CHANNEL_2_STA_0_PING_PONG_STA_RANGE                  28:28
#define APBDMACHAN_CHANNEL_2_STA_0_PING_PONG_STA_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_2_STA_0_PING_PONG_STA_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_PING_PONG_STA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_2_STA_0_PING_PONG_STA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_PING_PONG_STA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_PING_PONG_STA_PING_INTR_STA                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_STA_0_PING_PONG_STA_PONG_INTR_STA                  _MK_ENUM_CONST(1)

// Current 32bit word cycles Flags set /cleared by HW
#define APBDMACHAN_CHANNEL_2_STA_0_COUNT_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_2_STA_0_COUNT_FIELD                  (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_2_STA_0_COUNT_SHIFT)
#define APBDMACHAN_CHANNEL_2_STA_0_COUNT_RANGE                  15:2
#define APBDMACHAN_CHANNEL_2_STA_0_COUNT_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_2_STA_0_COUNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_COUNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_2_STA_0_COUNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_STA_0_COUNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 72 [0x48] 

// Reserved address 76 [0x4c] 

// Register APBDMACHAN_CHANNEL_2_AHB_PTR_0  
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0                  _MK_ADDR_CONST(0x50)
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffffffc)
// APB-DMA Starting Address for AHB Bus: SW writes to  modify
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0_AHB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0_AHB_BASE_FIELD                   (_MK_MASK_CONST(0x3fffffff) << APBDMACHAN_CHANNEL_2_AHB_PTR_0_AHB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0_AHB_BASE_RANGE                   31:2
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0_AHB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0_AHB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0_AHB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fffffff)
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0_AHB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_PTR_0_AHB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_2_AHB_SEQ_0  
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0                  _MK_ADDR_CONST(0x54)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20000000)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0xff0f0000)
// 0 = send interrupt to COP
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_INTR_ENB_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_INTR_ENB_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_2_AHB_SEQ_0_INTR_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_INTR_ENB_RANGE                   31:31
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_INTR_ENB_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_INTR_ENB_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_INTR_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_INTR_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_INTR_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_INTR_ENB_CPU                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_INTR_ENB_COP                     _MK_ENUM_CONST(0)

// AHB Bus Width 0 = 8 bit Bus (RSVD) 1 = 16 bit Bus (RSVD) 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD)4 = 128 bit Bus (RSVD)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

// when enabled the data going  to AHB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

// AHB Burst Size DMA Burst Length (encoded) 4 = 1 Word (1x32bits) 5 = 4 Words (4x32bits)else = 8 Words (8x32bits) default
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BURST_SHIFT                  _MK_SHIFT_CONST(24)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BURST_FIELD                  (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BURST_SHIFT)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BURST_RANGE                  26:24
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BURST_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BURST_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BURST_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BURST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BURST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BURST_DMA_BURST_1WORDS                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BURST_DMA_BURST_4WORDS                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_AHB_BURST_DMA_BURST_8WORDS                       _MK_ENUM_CONST(6)

// 2X Double Buffering Mode (For Run-Multiple Mode with No Wrap Operations) 1 = Reload Base Address for 2X blocks (reload every other time) 0 = Reload Base Address for 1X blocks  (def) (reload each time)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_DBL_BUF_SHIFT                    _MK_SHIFT_CONST(19)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_DBL_BUF_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_2_AHB_SEQ_0_DBL_BUF_SHIFT)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_DBL_BUF_RANGE                    19:19
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_DBL_BUF_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_DBL_BUF_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_DBL_BUF_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_DBL_BUF_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_DBL_BUF_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_1X_BLOCKS                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_2X_BLOCKS                     _MK_ENUM_CONST(1)

// AHB Address Wrap: AHB Address wrap-around window 0=No Wrap (default) 5=Wrap on 512 word window 1=Wrap on 32 word window 6=Wrap on 1024 word window 2=Wrap on 64 word window 7=Wrap on 2048 word window 3=Wrap on 128 word window 4=Wrap on 256 word window
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_FIELD                       (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_RANGE                       18:16
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_NO_WRAP                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_WRAP_0N_32WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_WRAP_ON_64WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_WRAP_ON_128WORDS                    _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_WRAP_ON_256WORDS                    _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_WRAP_ON_512WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_WRAP_ON_1024WORDS                   _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_2_AHB_SEQ_0_WRAP_WRAP_ON_2048WORDS                   _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_2_APB_PTR_0  
#define APBDMACHAN_CHANNEL_2_APB_PTR_0                  _MK_ADDR_CONST(0x58)
#define APBDMACHAN_CHANNEL_2_APB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_2_APB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_2_APB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_APB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_2_APB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_APB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_APB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_2_APB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffc)
// APB-DMA Starting address for APB Bus: APB Base  address: Upper 16 bits are fixed at 0x7000:XXXX
#define APBDMACHAN_CHANNEL_2_APB_PTR_0_APB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_2_APB_PTR_0_APB_BASE_FIELD                   (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_2_APB_PTR_0_APB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_2_APB_PTR_0_APB_BASE_RANGE                   15:2
#define APBDMACHAN_CHANNEL_2_APB_PTR_0_APB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_2_APB_PTR_0_APB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_APB_PTR_0_APB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_2_APB_PTR_0_APB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_APB_PTR_0_APB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_2_APB_SEQ_0  
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0                  _MK_ADDR_CONST(0x5c)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20010000)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0x78070000)
// 0 = 8 bit Bus 1 = 16 bit Bus 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD) 4 = 128 bit BUS (RSVD)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

// when enabled the data going  to APB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

//APB Address Wrap-around Window 0 = No Wrap 1 = Wrap on 1 Word Window (def) 2 = Wrap on 2 Word Window 3 = Wrap on 4 Word Window 4 = Wrap on 8 Word Window 5 = Wrap on 16 Word Window 6 = Wrap on 32 Word Window 7 = Wrap on 64 Word Window (rsvd)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_RANGE                      18:16
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_NO_WRAP                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_WRAP_0N_1WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_2WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_4WORDS                     _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_8WORDS                     _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_16WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_32WORDS                    _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_2_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_64WORDS                    _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_3_CSR_0  
#define APBDMACHAN_CHANNEL_3_CSR_0                      _MK_ADDR_CONST(0x60)
#define APBDMACHAN_CHANNEL_3_CSR_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_3_CSR_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_3_CSR_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_RESET_MASK                   _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_3_CSR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_READ_MASK                    _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_3_CSR_0_WRITE_MASK                   _MK_MASK_CONST(0xfffffffc)
// Enables DMA channel transfer 
#define APBDMACHAN_CHANNEL_3_CSR_0_ENB_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_3_CSR_0_ENB_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_3_CSR_0_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_3_CSR_0_ENB_RANGE                    31:31
#define APBDMACHAN_CHANNEL_3_CSR_0_ENB_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_3_CSR_0_ENB_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_ENB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_3_CSR_0_ENB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_ENB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_ENB_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_CSR_0_ENB_ENABLE                   _MK_ENUM_CONST(1)

// Interrupts when DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_3_CSR_0_IE_EOC_SHIFT                 _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_3_CSR_0_IE_EOC_FIELD                 (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_3_CSR_0_IE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_3_CSR_0_IE_EOC_RANGE                 30:30
#define APBDMACHAN_CHANNEL_3_CSR_0_IE_EOC_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_3_CSR_0_IE_EOC_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_IE_EOC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_3_CSR_0_IE_EOC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_IE_EOC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_IE_EOC_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_CSR_0_IE_EOC_ENABLE                        _MK_ENUM_CONST(1)

// Holds this Processor until DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_3_CSR_0_HOLD_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_3_CSR_0_HOLD_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_3_CSR_0_HOLD_SHIFT)
#define APBDMACHAN_CHANNEL_3_CSR_0_HOLD_RANGE                   29:29
#define APBDMACHAN_CHANNEL_3_CSR_0_HOLD_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_3_CSR_0_HOLD_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_HOLD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_3_CSR_0_HOLD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_HOLD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_HOLD_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_CSR_0_HOLD_ENABLE                  _MK_ENUM_CONST(1)

// DMA Transfer Direction 1 = AHB read to APB write 0 = APB read to AHB write
#define APBDMACHAN_CHANNEL_3_CSR_0_DIR_SHIFT                    _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_3_CSR_0_DIR_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_3_CSR_0_DIR_SHIFT)
#define APBDMACHAN_CHANNEL_3_CSR_0_DIR_RANGE                    28:28
#define APBDMACHAN_CHANNEL_3_CSR_0_DIR_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_3_CSR_0_DIR_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_DIR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_3_CSR_0_DIR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_DIR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_DIR_AHB_WRITE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_CSR_0_DIR_AHB_READ                 _MK_ENUM_CONST(1)

// Run Once or Run Multiple Mode (Allow Retriggering of this Channel) 1 = Run for One Block Transfer 0 = Run for Multiple Block Transfer
#define APBDMACHAN_CHANNEL_3_CSR_0_ONCE_SHIFT                   _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_3_CSR_0_ONCE_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_3_CSR_0_ONCE_SHIFT)
#define APBDMACHAN_CHANNEL_3_CSR_0_ONCE_RANGE                   27:27
#define APBDMACHAN_CHANNEL_3_CSR_0_ONCE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_3_CSR_0_ONCE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_ONCE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_3_CSR_0_ONCE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_ONCE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_ONCE_MULTIPLE_BLOCK                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_CSR_0_ONCE_SINGLE_BLOCK                    _MK_ENUM_CONST(1)

// Enable on Non-Zero Value
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_SHIFT                       _MK_SHIFT_CONST(22)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_FIELD                       (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_RANGE                       26:22
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_NA1                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_SMP24                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_SMP25                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_SMP26                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_SMP27                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_XRQ_A                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_XRQ_B                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_TMR1                        _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_TMR2                        _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_APB_0                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_APB_1                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_APB_2                       _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_APB_3                       _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_APB_4                       _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_APB_5                       _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_APB_6                       _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_APB_7                       _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_APB_8                       _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_APB_9                       _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_APB_10                      _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_APB_11                      _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_APB_12                      _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_APB_13                      _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_APB_14                      _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_3_CSR_0_TRIG_SEL_APB_15                      _MK_ENUM_CONST(24)

// Flow Control Enable (Synchronize Burst Transfers) 1 = Link to DRQ source 0 = Independent of DRQ request
#define APBDMACHAN_CHANNEL_3_CSR_0_FLOW_SHIFT                   _MK_SHIFT_CONST(21)
#define APBDMACHAN_CHANNEL_3_CSR_0_FLOW_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_3_CSR_0_FLOW_SHIFT)
#define APBDMACHAN_CHANNEL_3_CSR_0_FLOW_RANGE                   21:21
#define APBDMACHAN_CHANNEL_3_CSR_0_FLOW_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_3_CSR_0_FLOW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_FLOW_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_3_CSR_0_FLOW_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_FLOW_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_FLOW_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_CSR_0_FLOW_ENABLE                  _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_SHIFT                        _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_FIELD                        (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_RANGE                        20:16
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_CNTR_REQ                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_I2S_2                        _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_I2S_1                        _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_SPD_I                        _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_UI_I                 _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_MIPI                 _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_I2S2_2                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_I2S2_1                       _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_UART_A                       _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_UART_B                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_UART_C                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_SPI                  _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_AC97                 _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_ACModem                      _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_SL4B                 _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_SL2B1                        _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_SL2B2                        _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_SL2B3                        _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_SL2B4                        _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_UART_D                       _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_UART_E                       _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_I2C                  _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_I2C2                 _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_I2C3                 _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_DVC_I2C                      _MK_ENUM_CONST(24)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_OWR                  _MK_ENUM_CONST(25)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_NA26                 _MK_ENUM_CONST(26)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_NA27                 _MK_ENUM_CONST(27)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_NA28                 _MK_ENUM_CONST(28)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_NA29                 _MK_ENUM_CONST(29)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_NA30                 _MK_ENUM_CONST(30)
#define APBDMACHAN_CHANNEL_3_CSR_0_REQ_SEL_NA31                 _MK_ENUM_CONST(31)

// Number of 32bit word cycles
#define APBDMACHAN_CHANNEL_3_CSR_0_WCOUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_3_CSR_0_WCOUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_3_CSR_0_WCOUNT_SHIFT)
#define APBDMACHAN_CHANNEL_3_CSR_0_WCOUNT_RANGE                 15:2
#define APBDMACHAN_CHANNEL_3_CSR_0_WCOUNT_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_3_CSR_0_WCOUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_WCOUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_3_CSR_0_WCOUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_CSR_0_WCOUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_3_STA_0  
#define APBDMACHAN_CHANNEL_3_STA_0                      _MK_ADDR_CONST(0x64)
#define APBDMACHAN_CHANNEL_3_STA_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_3_STA_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_3_STA_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_RESET_MASK                   _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_3_STA_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_READ_MASK                    _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_3_STA_0_WRITE_MASK                   _MK_MASK_CONST(0x40000000)
// indicates whether DMA Channel Status active
#define APBDMACHAN_CHANNEL_3_STA_0_BSY_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_3_STA_0_BSY_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_3_STA_0_BSY_SHIFT)
#define APBDMACHAN_CHANNEL_3_STA_0_BSY_RANGE                    31:31
#define APBDMACHAN_CHANNEL_3_STA_0_BSY_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_3_STA_0_BSY_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_BSY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_3_STA_0_BSY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_BSY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_BSY_WAIT                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_STA_0_BSY_ACTIVE                   _MK_ENUM_CONST(1)

//  Write '1' to clear the flag
#define APBDMACHAN_CHANNEL_3_STA_0_ISE_EOC_SHIFT                        _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_3_STA_0_ISE_EOC_FIELD                        (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_3_STA_0_ISE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_3_STA_0_ISE_EOC_RANGE                        30:30
#define APBDMACHAN_CHANNEL_3_STA_0_ISE_EOC_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_3_STA_0_ISE_EOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_ISE_EOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_3_STA_0_ISE_EOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_ISE_EOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_ISE_EOC_NO_INTR                      _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_STA_0_ISE_EOC_INTR                 _MK_ENUM_CONST(1)

// Holding Status of Processor 
#define APBDMACHAN_CHANNEL_3_STA_0_HALT_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_3_STA_0_HALT_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_3_STA_0_HALT_SHIFT)
#define APBDMACHAN_CHANNEL_3_STA_0_HALT_RANGE                   29:29
#define APBDMACHAN_CHANNEL_3_STA_0_HALT_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_3_STA_0_HALT_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_HALT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_3_STA_0_HALT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_HALT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_HALT_NO_HALT                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_STA_0_HALT_HALT                    _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_3_STA_0_PING_PONG_STA_SHIFT                  _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_3_STA_0_PING_PONG_STA_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_3_STA_0_PING_PONG_STA_SHIFT)
#define APBDMACHAN_CHANNEL_3_STA_0_PING_PONG_STA_RANGE                  28:28
#define APBDMACHAN_CHANNEL_3_STA_0_PING_PONG_STA_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_3_STA_0_PING_PONG_STA_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_PING_PONG_STA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_3_STA_0_PING_PONG_STA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_PING_PONG_STA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_PING_PONG_STA_PING_INTR_STA                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_STA_0_PING_PONG_STA_PONG_INTR_STA                  _MK_ENUM_CONST(1)

// Current 32bit word cycles Flags set /cleared by HW
#define APBDMACHAN_CHANNEL_3_STA_0_COUNT_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_3_STA_0_COUNT_FIELD                  (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_3_STA_0_COUNT_SHIFT)
#define APBDMACHAN_CHANNEL_3_STA_0_COUNT_RANGE                  15:2
#define APBDMACHAN_CHANNEL_3_STA_0_COUNT_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_3_STA_0_COUNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_COUNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_3_STA_0_COUNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_STA_0_COUNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 104 [0x68] 

// Reserved address 108 [0x6c] 

// Register APBDMACHAN_CHANNEL_3_AHB_PTR_0  
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0                  _MK_ADDR_CONST(0x70)
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffffffc)
// APB-DMA Starting Address for AHB Bus: SW writes to  modify
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0_AHB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0_AHB_BASE_FIELD                   (_MK_MASK_CONST(0x3fffffff) << APBDMACHAN_CHANNEL_3_AHB_PTR_0_AHB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0_AHB_BASE_RANGE                   31:2
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0_AHB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0_AHB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0_AHB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fffffff)
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0_AHB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_PTR_0_AHB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_3_AHB_SEQ_0  
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0                  _MK_ADDR_CONST(0x74)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20000000)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0xff070000)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0xff070000)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0xff070000)
//  0 = send interrupt to COP                                            
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_INTR_ENB_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_INTR_ENB_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_3_AHB_SEQ_0_INTR_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_INTR_ENB_RANGE                   31:31
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_INTR_ENB_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_INTR_ENB_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_INTR_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_INTR_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_INTR_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_INTR_ENB_CPU                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_INTR_ENB_COP                     _MK_ENUM_CONST(0)

// AHB Bus Width 0 = 8 bit Bus (RSVD) 1 = 16 bit Bus (RSVD) 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD)4 = 128 bit Bus (RSVD)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

// When enabled the data going  to AHB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

// AHB Burst Size DMA Burst Length (encoded) 4 = 1 Word (1x32bits) 5 = 4 Words (4x32bits)else = 8 Words (8x32bits) default
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BURST_SHIFT                  _MK_SHIFT_CONST(24)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BURST_FIELD                  (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BURST_SHIFT)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BURST_RANGE                  26:24
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BURST_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BURST_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BURST_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BURST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BURST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BURST_DMA_BURST_1WORDS                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BURST_DMA_BURST_4WORDS                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_AHB_BURST_DMA_BURST_8WORDS                       _MK_ENUM_CONST(6)

// AHB Address Wrap: AHB Address wrap-around window 0=No Wrap (default) 5=Wrap on 512 word window 1=Wrap on 32 word window 6=Wrap on 1024 word window 2=Wrap on 64 word window 7=Wrap on 2048 word window 3=Wrap on 128 word window 4=Wrap on 256 word window
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_FIELD                       (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_RANGE                       18:16
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_NO_WRAP                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_WRAP_0N_32WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_WRAP_ON_64WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_WRAP_ON_128WORDS                    _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_WRAP_ON_256WORDS                    _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_WRAP_ON_512WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_WRAP_ON_1024WORDS                   _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_3_AHB_SEQ_0_WRAP_WRAP_ON_2048WORDS                   _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_3_APB_PTR_0  
#define APBDMACHAN_CHANNEL_3_APB_PTR_0                  _MK_ADDR_CONST(0x78)
#define APBDMACHAN_CHANNEL_3_APB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_3_APB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_3_APB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_APB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_3_APB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_APB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_APB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_3_APB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffc)
// APB-DMA Starting address for APB Bus: APB Base  address: Upper 16 bits are fixed at 0x7000:XXXX
#define APBDMACHAN_CHANNEL_3_APB_PTR_0_APB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_3_APB_PTR_0_APB_BASE_FIELD                   (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_3_APB_PTR_0_APB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_3_APB_PTR_0_APB_BASE_RANGE                   15:2
#define APBDMACHAN_CHANNEL_3_APB_PTR_0_APB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_3_APB_PTR_0_APB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_APB_PTR_0_APB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_3_APB_PTR_0_APB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_APB_PTR_0_APB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_3_APB_SEQ_0  
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0                  _MK_ADDR_CONST(0x7c)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20010000)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0x78070000)
// 0 = 8 bit Bus 1 = 16 bit Bus 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD) 4 = 128 bit BUS (RSVD)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

// when enabled the data going  to APB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

//APB Address Wrap-around Window 0 = No Wrap 1 = Wrap on 1 Word Window (def) 2 = Wrap on 2 Word Window 3 = Wrap on 4 Word Window 4 = Wrap on 8 Word Window 5 = Wrap on 16 Word Window 6 = Wrap on 32 Word Window 7 = Wrap on 64 Word Window (rsvd)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_RANGE                      18:16
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_NO_WRAP                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_WRAP_0N_1WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_2WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_4WORDS                     _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_8WORDS                     _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_16WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_32WORDS                    _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_3_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_64WORDS                    _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_4_CSR_0  
#define APBDMACHAN_CHANNEL_4_CSR_0                      _MK_ADDR_CONST(0x80)
#define APBDMACHAN_CHANNEL_4_CSR_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_4_CSR_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_4_CSR_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_RESET_MASK                   _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_4_CSR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_READ_MASK                    _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_4_CSR_0_WRITE_MASK                   _MK_MASK_CONST(0xfffffffc)
// Enables DMA channel transfer 
#define APBDMACHAN_CHANNEL_4_CSR_0_ENB_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_4_CSR_0_ENB_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_4_CSR_0_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_4_CSR_0_ENB_RANGE                    31:31
#define APBDMACHAN_CHANNEL_4_CSR_0_ENB_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_4_CSR_0_ENB_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_ENB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_4_CSR_0_ENB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_ENB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_ENB_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_CSR_0_ENB_ENABLE                   _MK_ENUM_CONST(1)

// Interrupts when DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_4_CSR_0_IE_EOC_SHIFT                 _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_4_CSR_0_IE_EOC_FIELD                 (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_4_CSR_0_IE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_4_CSR_0_IE_EOC_RANGE                 30:30
#define APBDMACHAN_CHANNEL_4_CSR_0_IE_EOC_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_4_CSR_0_IE_EOC_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_IE_EOC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_4_CSR_0_IE_EOC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_IE_EOC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_IE_EOC_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_CSR_0_IE_EOC_ENABLE                        _MK_ENUM_CONST(1)

// Holds this Processor until DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_4_CSR_0_HOLD_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_4_CSR_0_HOLD_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_4_CSR_0_HOLD_SHIFT)
#define APBDMACHAN_CHANNEL_4_CSR_0_HOLD_RANGE                   29:29
#define APBDMACHAN_CHANNEL_4_CSR_0_HOLD_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_4_CSR_0_HOLD_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_HOLD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_4_CSR_0_HOLD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_HOLD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_HOLD_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_CSR_0_HOLD_ENABLE                  _MK_ENUM_CONST(1)

// DMA Transfer Direction 1 = AHB read to APB write 0 = APB read to AHB write
#define APBDMACHAN_CHANNEL_4_CSR_0_DIR_SHIFT                    _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_4_CSR_0_DIR_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_4_CSR_0_DIR_SHIFT)
#define APBDMACHAN_CHANNEL_4_CSR_0_DIR_RANGE                    28:28
#define APBDMACHAN_CHANNEL_4_CSR_0_DIR_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_4_CSR_0_DIR_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_DIR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_4_CSR_0_DIR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_DIR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_DIR_AHB_WRITE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_CSR_0_DIR_AHB_READ                 _MK_ENUM_CONST(1)

// Run Once or Run Multiple Mode (Allow Retriggering of this Channel) 1 = Run for One Block Transfer 0 = Run for Multiple Block Transfer
#define APBDMACHAN_CHANNEL_4_CSR_0_ONCE_SHIFT                   _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_4_CSR_0_ONCE_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_4_CSR_0_ONCE_SHIFT)
#define APBDMACHAN_CHANNEL_4_CSR_0_ONCE_RANGE                   27:27
#define APBDMACHAN_CHANNEL_4_CSR_0_ONCE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_4_CSR_0_ONCE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_ONCE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_4_CSR_0_ONCE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_ONCE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_ONCE_MULTIPLE_BLOCK                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_CSR_0_ONCE_SINGLE_BLOCK                    _MK_ENUM_CONST(1)

// Enable on Non-Zero Value
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_SHIFT                       _MK_SHIFT_CONST(22)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_FIELD                       (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_RANGE                       26:22
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_NA1                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_SMP24                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_SMP25                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_SMP26                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_SMP27                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_XRQ_A                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_XRQ_B                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_TMR1                        _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_TMR2                        _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_APB_0                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_APB_1                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_APB_2                       _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_APB_3                       _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_APB_4                       _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_APB_5                       _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_APB_6                       _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_APB_7                       _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_APB_8                       _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_APB_9                       _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_APB_10                      _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_APB_11                      _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_APB_12                      _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_APB_13                      _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_APB_14                      _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_4_CSR_0_TRIG_SEL_APB_15                      _MK_ENUM_CONST(24)

// Flow Control Enable (Synchronize Burst Transfers) 1 = Link to DRQ source 0 = Independent of DRQ request
#define APBDMACHAN_CHANNEL_4_CSR_0_FLOW_SHIFT                   _MK_SHIFT_CONST(21)
#define APBDMACHAN_CHANNEL_4_CSR_0_FLOW_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_4_CSR_0_FLOW_SHIFT)
#define APBDMACHAN_CHANNEL_4_CSR_0_FLOW_RANGE                   21:21
#define APBDMACHAN_CHANNEL_4_CSR_0_FLOW_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_4_CSR_0_FLOW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_FLOW_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_4_CSR_0_FLOW_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_FLOW_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_FLOW_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_CSR_0_FLOW_ENABLE                  _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_SHIFT                        _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_FIELD                        (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_RANGE                        20:16
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_CNTR_REQ                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_I2S_2                        _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_I2S_1                        _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_SPD_I                        _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_UI_I                 _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_MIPI                 _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_I2S2_2                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_I2S2_1                       _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_UART_A                       _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_UART_B                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_UART_C                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_SPI                  _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_AC97                 _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_ACModem                      _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_SL4B                 _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_SL2B1                        _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_SL2B2                        _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_SL2B3                        _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_SL2B4                        _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_UART_D                       _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_UART_E                       _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_I2C                  _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_I2C2                 _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_I2C3                 _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_DVC_I2C                      _MK_ENUM_CONST(24)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_OWR                  _MK_ENUM_CONST(25)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_NA26                 _MK_ENUM_CONST(26)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_NA27                 _MK_ENUM_CONST(27)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_NA28                 _MK_ENUM_CONST(28)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_NA29                 _MK_ENUM_CONST(29)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_NA30                 _MK_ENUM_CONST(30)
#define APBDMACHAN_CHANNEL_4_CSR_0_REQ_SEL_NA31                 _MK_ENUM_CONST(31)

// Number of 32bit word cycles
#define APBDMACHAN_CHANNEL_4_CSR_0_WCOUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_4_CSR_0_WCOUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_4_CSR_0_WCOUNT_SHIFT)
#define APBDMACHAN_CHANNEL_4_CSR_0_WCOUNT_RANGE                 15:2
#define APBDMACHAN_CHANNEL_4_CSR_0_WCOUNT_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_4_CSR_0_WCOUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_WCOUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_4_CSR_0_WCOUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_CSR_0_WCOUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_4_STA_0  
#define APBDMACHAN_CHANNEL_4_STA_0                      _MK_ADDR_CONST(0x84)
#define APBDMACHAN_CHANNEL_4_STA_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_4_STA_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_4_STA_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_RESET_MASK                   _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_4_STA_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_READ_MASK                    _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_4_STA_0_WRITE_MASK                   _MK_MASK_CONST(0x40000000)
// indicates whether DMA Channel Status active or not
#define APBDMACHAN_CHANNEL_4_STA_0_BSY_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_4_STA_0_BSY_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_4_STA_0_BSY_SHIFT)
#define APBDMACHAN_CHANNEL_4_STA_0_BSY_RANGE                    31:31
#define APBDMACHAN_CHANNEL_4_STA_0_BSY_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_4_STA_0_BSY_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_BSY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_4_STA_0_BSY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_BSY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_BSY_WAIT                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_STA_0_BSY_ACTIVE                   _MK_ENUM_CONST(1)

//  Write '1' to clear the flag
#define APBDMACHAN_CHANNEL_4_STA_0_ISE_EOC_SHIFT                        _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_4_STA_0_ISE_EOC_FIELD                        (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_4_STA_0_ISE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_4_STA_0_ISE_EOC_RANGE                        30:30
#define APBDMACHAN_CHANNEL_4_STA_0_ISE_EOC_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_4_STA_0_ISE_EOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_ISE_EOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_4_STA_0_ISE_EOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_ISE_EOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_ISE_EOC_NO_INTR                      _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_STA_0_ISE_EOC_INTR                 _MK_ENUM_CONST(1)

// Holding Status of Processor 
#define APBDMACHAN_CHANNEL_4_STA_0_HALT_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_4_STA_0_HALT_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_4_STA_0_HALT_SHIFT)
#define APBDMACHAN_CHANNEL_4_STA_0_HALT_RANGE                   29:29
#define APBDMACHAN_CHANNEL_4_STA_0_HALT_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_4_STA_0_HALT_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_HALT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_4_STA_0_HALT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_HALT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_HALT_NO_HALT                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_STA_0_HALT_HALT                    _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_4_STA_0_PING_PONG_STA_SHIFT                  _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_4_STA_0_PING_PONG_STA_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_4_STA_0_PING_PONG_STA_SHIFT)
#define APBDMACHAN_CHANNEL_4_STA_0_PING_PONG_STA_RANGE                  28:28
#define APBDMACHAN_CHANNEL_4_STA_0_PING_PONG_STA_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_4_STA_0_PING_PONG_STA_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_PING_PONG_STA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_4_STA_0_PING_PONG_STA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_PING_PONG_STA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_PING_PONG_STA_PING_INTR_STA                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_STA_0_PING_PONG_STA_PONG_INTR_STA                  _MK_ENUM_CONST(1)

// Current 32bit word cycles Flags set /cleared by HW
#define APBDMACHAN_CHANNEL_4_STA_0_COUNT_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_4_STA_0_COUNT_FIELD                  (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_4_STA_0_COUNT_SHIFT)
#define APBDMACHAN_CHANNEL_4_STA_0_COUNT_RANGE                  15:2
#define APBDMACHAN_CHANNEL_4_STA_0_COUNT_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_4_STA_0_COUNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_COUNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_4_STA_0_COUNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_STA_0_COUNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 136 [0x88] 

// Reserved address 140 [0x8c] 

// Register APBDMACHAN_CHANNEL_4_AHB_PTR_0  
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0                  _MK_ADDR_CONST(0x90)
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffffffc)
// APB-DMA Starting Address for AHB Bus: SW writes to  modify
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0_AHB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0_AHB_BASE_FIELD                   (_MK_MASK_CONST(0x3fffffff) << APBDMACHAN_CHANNEL_4_AHB_PTR_0_AHB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0_AHB_BASE_RANGE                   31:2
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0_AHB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0_AHB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0_AHB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fffffff)
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0_AHB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_PTR_0_AHB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_4_AHB_SEQ_0  
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0                  _MK_ADDR_CONST(0x94)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20000000)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0xff0f0000)
//  0 = send interrupt to COP
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_INTR_ENB_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_INTR_ENB_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_4_AHB_SEQ_0_INTR_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_INTR_ENB_RANGE                   31:31
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_INTR_ENB_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_INTR_ENB_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_INTR_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_INTR_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_INTR_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_INTR_ENB_CPU                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_INTR_ENB_COP                     _MK_ENUM_CONST(0)

// AHB Bus Width 0 = 8 bit Bus (RSVD) 1 = 16 bit Bus (RSVD) 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD)4 = 128 bit Bus (RSVD)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

// when enabled the data going  to AHB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

// AHB Burst Size DMA Burst Length (encoded) 4 = 1 Word (1x32bits) 5 = 4 Words (4x32bits)else = 8 Words (8x32bits) default
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BURST_SHIFT                  _MK_SHIFT_CONST(24)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BURST_FIELD                  (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BURST_SHIFT)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BURST_RANGE                  26:24
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BURST_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BURST_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BURST_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BURST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BURST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BURST_DMA_BURST_1WORDS                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BURST_DMA_BURST_4WORDS                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_AHB_BURST_DMA_BURST_8WORDS                       _MK_ENUM_CONST(6)

// 2X Double Buffering Mode (For Run-Multiple Mode with No Wrap Operations) 1 = Reload Base Address for 2X blocks (reload every other time) 0 = Reload Base Address for 1X blocks  (def) (reload each time)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_DBL_BUF_SHIFT                    _MK_SHIFT_CONST(19)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_DBL_BUF_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_4_AHB_SEQ_0_DBL_BUF_SHIFT)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_DBL_BUF_RANGE                    19:19
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_DBL_BUF_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_DBL_BUF_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_DBL_BUF_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_DBL_BUF_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_DBL_BUF_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_1X_BLOCKS                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_2X_BLOCKS                     _MK_ENUM_CONST(1)

// AHB Address Wrap: AHB Address wrap-around window 0=No Wrap (default) 5=Wrap on 512 word window 1=Wrap on 32 word window 6=Wrap on 1024 word window 2=Wrap on 64 word window 7=Wrap on 2048 word window 3=Wrap on 128 word window 4=Wrap on 256 word window
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_FIELD                       (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_RANGE                       18:16
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_NO_WRAP                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_WRAP_0N_32WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_WRAP_ON_64WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_WRAP_ON_128WORDS                    _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_WRAP_ON_256WORDS                    _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_WRAP_ON_512WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_WRAP_ON_1024WORDS                   _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_4_AHB_SEQ_0_WRAP_WRAP_ON_2048WORDS                   _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_4_APB_PTR_0  
#define APBDMACHAN_CHANNEL_4_APB_PTR_0                  _MK_ADDR_CONST(0x98)
#define APBDMACHAN_CHANNEL_4_APB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_4_APB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_4_APB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_APB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_4_APB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_APB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_APB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_4_APB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffc)
// APB-DMA Starting address for APB Bus: APB Base address:Upper 16 bits are fixed at 0x7000:XXXX
#define APBDMACHAN_CHANNEL_4_APB_PTR_0_APB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_4_APB_PTR_0_APB_BASE_FIELD                   (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_4_APB_PTR_0_APB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_4_APB_PTR_0_APB_BASE_RANGE                   15:2
#define APBDMACHAN_CHANNEL_4_APB_PTR_0_APB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_4_APB_PTR_0_APB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_APB_PTR_0_APB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_4_APB_PTR_0_APB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_APB_PTR_0_APB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_4_APB_SEQ_0  
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0                  _MK_ADDR_CONST(0x9c)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20010000)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0x78070000)
// 0 = 8 bit Bus 1 = 16 bit Bus 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD) 4 = 128 bit BUS (RSVD)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

// when enabled the data going  to APB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

//APB Address Wrap-around Window 0 = No Wrap 1 = Wrap on 1 Word Window (def) 2 = Wrap on 2 Word Window 3 = Wrap on 4 Word Window 4 = Wrap on 8 Word Window 5 = Wrap on 16 Word Window 6 = Wrap on 32 Word Window 7 = Wrap on 64 Word Window (rsvd)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_RANGE                      18:16
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_NO_WRAP                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_WRAP_0N_1WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_2WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_4WORDS                     _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_8WORDS                     _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_16WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_32WORDS                    _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_4_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_64WORDS                    _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_5_CSR_0  
#define APBDMACHAN_CHANNEL_5_CSR_0                      _MK_ADDR_CONST(0xa0)
#define APBDMACHAN_CHANNEL_5_CSR_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_5_CSR_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_5_CSR_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_RESET_MASK                   _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_5_CSR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_READ_MASK                    _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_5_CSR_0_WRITE_MASK                   _MK_MASK_CONST(0xfffffffc)
// Enables DMA channel transfer
#define APBDMACHAN_CHANNEL_5_CSR_0_ENB_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_5_CSR_0_ENB_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_5_CSR_0_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_5_CSR_0_ENB_RANGE                    31:31
#define APBDMACHAN_CHANNEL_5_CSR_0_ENB_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_5_CSR_0_ENB_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_ENB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_5_CSR_0_ENB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_ENB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_ENB_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_CSR_0_ENB_ENABLE                   _MK_ENUM_CONST(1)

// Interrupts when DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_5_CSR_0_IE_EOC_SHIFT                 _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_5_CSR_0_IE_EOC_FIELD                 (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_5_CSR_0_IE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_5_CSR_0_IE_EOC_RANGE                 30:30
#define APBDMACHAN_CHANNEL_5_CSR_0_IE_EOC_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_5_CSR_0_IE_EOC_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_IE_EOC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_5_CSR_0_IE_EOC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_IE_EOC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_IE_EOC_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_CSR_0_IE_EOC_ENABLE                        _MK_ENUM_CONST(1)

// Holds this Processor until DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_5_CSR_0_HOLD_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_5_CSR_0_HOLD_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_5_CSR_0_HOLD_SHIFT)
#define APBDMACHAN_CHANNEL_5_CSR_0_HOLD_RANGE                   29:29
#define APBDMACHAN_CHANNEL_5_CSR_0_HOLD_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_5_CSR_0_HOLD_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_HOLD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_5_CSR_0_HOLD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_HOLD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_HOLD_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_CSR_0_HOLD_ENABLE                  _MK_ENUM_CONST(1)

// DMA Transfer Direction 1 = AHB read to APB write 0 = APB read to AHB write
#define APBDMACHAN_CHANNEL_5_CSR_0_DIR_SHIFT                    _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_5_CSR_0_DIR_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_5_CSR_0_DIR_SHIFT)
#define APBDMACHAN_CHANNEL_5_CSR_0_DIR_RANGE                    28:28
#define APBDMACHAN_CHANNEL_5_CSR_0_DIR_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_5_CSR_0_DIR_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_DIR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_5_CSR_0_DIR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_DIR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_DIR_AHB_WRITE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_CSR_0_DIR_AHB_READ                 _MK_ENUM_CONST(1)

// Run Once or Run Multiple Mode (Allow Retriggering of this Channel) 1 = Run for One Block Transfer 0 = Run for Multiple Block Transfer
#define APBDMACHAN_CHANNEL_5_CSR_0_ONCE_SHIFT                   _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_5_CSR_0_ONCE_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_5_CSR_0_ONCE_SHIFT)
#define APBDMACHAN_CHANNEL_5_CSR_0_ONCE_RANGE                   27:27
#define APBDMACHAN_CHANNEL_5_CSR_0_ONCE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_5_CSR_0_ONCE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_ONCE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_5_CSR_0_ONCE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_ONCE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_ONCE_MULTIPLE_BLOCK                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_CSR_0_ONCE_SINGLE_BLOCK                    _MK_ENUM_CONST(1)

// Enable on Non-Zero Value
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_SHIFT                       _MK_SHIFT_CONST(22)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_FIELD                       (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_RANGE                       26:22
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_NA1                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_SMP24                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_SMP25                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_SMP26                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_SMP27                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_XRQ_A                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_XRQ_B                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_TMR1                        _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_TMR2                        _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_APB_0                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_APB_1                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_APB_2                       _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_APB_3                       _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_APB_4                       _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_APB_5                       _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_APB_6                       _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_APB_7                       _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_APB_8                       _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_APB_9                       _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_APB_10                      _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_APB_11                      _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_APB_12                      _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_APB_13                      _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_APB_14                      _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_5_CSR_0_TRIG_SEL_APB_15                      _MK_ENUM_CONST(24)

// Flow Control Enable (Synchronize Burst Transfers) 1 = Link to DRQ source 0 = Independent of DRQ request
#define APBDMACHAN_CHANNEL_5_CSR_0_FLOW_SHIFT                   _MK_SHIFT_CONST(21)
#define APBDMACHAN_CHANNEL_5_CSR_0_FLOW_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_5_CSR_0_FLOW_SHIFT)
#define APBDMACHAN_CHANNEL_5_CSR_0_FLOW_RANGE                   21:21
#define APBDMACHAN_CHANNEL_5_CSR_0_FLOW_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_5_CSR_0_FLOW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_FLOW_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_5_CSR_0_FLOW_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_FLOW_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_FLOW_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_CSR_0_FLOW_ENABLE                  _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_SHIFT                        _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_FIELD                        (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_RANGE                        20:16
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_CNTR_REQ                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_I2S_2                        _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_I2S_1                        _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_SPD_I                        _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_UI_I                 _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_MIPI                 _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_I2S2_2                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_I2S2_1                       _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_UART_A                       _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_UART_B                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_UART_C                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_SPI                  _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_AC97                 _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_ACModem                      _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_SL4B                 _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_SL2B1                        _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_SL2B2                        _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_SL2B3                        _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_SL2B4                        _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_UART_D                       _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_UART_E                       _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_I2C                  _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_I2C2                 _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_I2C3                 _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_DVC_I2C                      _MK_ENUM_CONST(24)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_OWR                  _MK_ENUM_CONST(25)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_NA26                 _MK_ENUM_CONST(26)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_NA27                 _MK_ENUM_CONST(27)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_NA28                 _MK_ENUM_CONST(28)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_NA29                 _MK_ENUM_CONST(29)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_NA30                 _MK_ENUM_CONST(30)
#define APBDMACHAN_CHANNEL_5_CSR_0_REQ_SEL_NA31                 _MK_ENUM_CONST(31)

// Number of 32bit word cycles
#define APBDMACHAN_CHANNEL_5_CSR_0_WCOUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_5_CSR_0_WCOUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_5_CSR_0_WCOUNT_SHIFT)
#define APBDMACHAN_CHANNEL_5_CSR_0_WCOUNT_RANGE                 15:2
#define APBDMACHAN_CHANNEL_5_CSR_0_WCOUNT_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_5_CSR_0_WCOUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_WCOUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_5_CSR_0_WCOUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_CSR_0_WCOUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_5_STA_0  
#define APBDMACHAN_CHANNEL_5_STA_0                      _MK_ADDR_CONST(0xa4)
#define APBDMACHAN_CHANNEL_5_STA_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_5_STA_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_5_STA_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_RESET_MASK                   _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_5_STA_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_READ_MASK                    _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_5_STA_0_WRITE_MASK                   _MK_MASK_CONST(0x40000000)
// indicate whether DMA Channel Status active or not
#define APBDMACHAN_CHANNEL_5_STA_0_BSY_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_5_STA_0_BSY_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_5_STA_0_BSY_SHIFT)
#define APBDMACHAN_CHANNEL_5_STA_0_BSY_RANGE                    31:31
#define APBDMACHAN_CHANNEL_5_STA_0_BSY_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_5_STA_0_BSY_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_BSY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_5_STA_0_BSY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_BSY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_BSY_WAIT                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_STA_0_BSY_ACTIVE                   _MK_ENUM_CONST(1)

//  Write '1' to clear the flag
#define APBDMACHAN_CHANNEL_5_STA_0_ISE_EOC_SHIFT                        _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_5_STA_0_ISE_EOC_FIELD                        (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_5_STA_0_ISE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_5_STA_0_ISE_EOC_RANGE                        30:30
#define APBDMACHAN_CHANNEL_5_STA_0_ISE_EOC_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_5_STA_0_ISE_EOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_ISE_EOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_5_STA_0_ISE_EOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_ISE_EOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_ISE_EOC_NO_INTR                      _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_STA_0_ISE_EOC_INTR                 _MK_ENUM_CONST(1)

// Holding Status of Processor
#define APBDMACHAN_CHANNEL_5_STA_0_HALT_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_5_STA_0_HALT_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_5_STA_0_HALT_SHIFT)
#define APBDMACHAN_CHANNEL_5_STA_0_HALT_RANGE                   29:29
#define APBDMACHAN_CHANNEL_5_STA_0_HALT_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_5_STA_0_HALT_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_HALT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_5_STA_0_HALT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_HALT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_HALT_NO_HALT                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_STA_0_HALT_HALT                    _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_5_STA_0_PING_PONG_STA_SHIFT                  _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_5_STA_0_PING_PONG_STA_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_5_STA_0_PING_PONG_STA_SHIFT)
#define APBDMACHAN_CHANNEL_5_STA_0_PING_PONG_STA_RANGE                  28:28
#define APBDMACHAN_CHANNEL_5_STA_0_PING_PONG_STA_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_5_STA_0_PING_PONG_STA_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_PING_PONG_STA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_5_STA_0_PING_PONG_STA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_PING_PONG_STA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_PING_PONG_STA_PING_INTR_STA                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_STA_0_PING_PONG_STA_PONG_INTR_STA                  _MK_ENUM_CONST(1)

// Current 32bit word cycles Flags set /cleared by HW
#define APBDMACHAN_CHANNEL_5_STA_0_COUNT_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_5_STA_0_COUNT_FIELD                  (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_5_STA_0_COUNT_SHIFT)
#define APBDMACHAN_CHANNEL_5_STA_0_COUNT_RANGE                  15:2
#define APBDMACHAN_CHANNEL_5_STA_0_COUNT_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_5_STA_0_COUNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_COUNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_5_STA_0_COUNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_STA_0_COUNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 168 [0xa8] 

// Reserved address 172 [0xac] 

// Register APBDMACHAN_CHANNEL_5_AHB_PTR_0  
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0                  _MK_ADDR_CONST(0xb0)
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffffffc)
// APB-DMA Starting Address for AHB Bus: SW writes to  modify
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0_AHB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0_AHB_BASE_FIELD                   (_MK_MASK_CONST(0x3fffffff) << APBDMACHAN_CHANNEL_5_AHB_PTR_0_AHB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0_AHB_BASE_RANGE                   31:2
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0_AHB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0_AHB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0_AHB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fffffff)
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0_AHB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_PTR_0_AHB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_5_AHB_SEQ_0  
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0                  _MK_ADDR_CONST(0xb4)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20000000)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0xff0f0000)
//  0 = send interrupt to COP
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_INTR_ENB_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_INTR_ENB_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_5_AHB_SEQ_0_INTR_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_INTR_ENB_RANGE                   31:31
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_INTR_ENB_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_INTR_ENB_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_INTR_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_INTR_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_INTR_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_INTR_ENB_CPU                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_INTR_ENB_COP                     _MK_ENUM_CONST(0)

// AHB Bus Width 0 = 8 bit Bus (RSVD) 1 = 16 bit Bus (RSVD) 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD)4 = 128 bit Bus (RSVD)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

// when enabled the data going  to AHB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

// AHB Burst Size DMA Burst Length (encoded) 4 = 1 Word (1x32bits) 5 = 4 Words (4x32bits)else = 8 Words (8x32bits) default
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BURST_SHIFT                  _MK_SHIFT_CONST(24)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BURST_FIELD                  (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BURST_SHIFT)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BURST_RANGE                  26:24
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BURST_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BURST_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BURST_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BURST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BURST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BURST_DMA_BURST_1WORDS                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BURST_DMA_BURST_4WORDS                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_AHB_BURST_DMA_BURST_8WORDS                       _MK_ENUM_CONST(6)

// 2X Double Buffering Mode (For Run-Multiple Mode with No Wrap Operations) 1 = Reload Base Address for 2X blocks (reload every other time) 0 = Reload Base Address for 1X blocks  (def) (reload each time)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_DBL_BUF_SHIFT                    _MK_SHIFT_CONST(19)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_DBL_BUF_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_5_AHB_SEQ_0_DBL_BUF_SHIFT)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_DBL_BUF_RANGE                    19:19
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_DBL_BUF_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_DBL_BUF_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_DBL_BUF_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_DBL_BUF_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_DBL_BUF_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_1X_BLOCKS                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_2X_BLOCKS                     _MK_ENUM_CONST(1)

// AHB Address Wrap: AHB Address wrap-around window 0=No Wrap (default) 5=Wrap on 512 word window 1=Wrap on 32 word window 6=Wrap on 1024 word window 2=Wrap on 64 word window 7=Wrap on 2048 word window 3=Wrap on 128 word window 4=Wrap on 256 word window
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_FIELD                       (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_RANGE                       18:16
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_NO_WRAP                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_WRAP_0N_32WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_WRAP_ON_64WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_WRAP_ON_128WORDS                    _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_WRAP_ON_256WORDS                    _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_WRAP_ON_512WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_WRAP_ON_1024WORDS                   _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_5_AHB_SEQ_0_WRAP_WRAP_ON_2048WORDS                   _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_5_APB_PTR_0  
#define APBDMACHAN_CHANNEL_5_APB_PTR_0                  _MK_ADDR_CONST(0xb8)
#define APBDMACHAN_CHANNEL_5_APB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_5_APB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_5_APB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_APB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_5_APB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_APB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_APB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_5_APB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffc)
// APB-DMA Starting address for APB Bus: APB Base address:Upper 16 bits are fixed at 0x7000:XXXX
#define APBDMACHAN_CHANNEL_5_APB_PTR_0_APB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_5_APB_PTR_0_APB_BASE_FIELD                   (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_5_APB_PTR_0_APB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_5_APB_PTR_0_APB_BASE_RANGE                   15:2
#define APBDMACHAN_CHANNEL_5_APB_PTR_0_APB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_5_APB_PTR_0_APB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_APB_PTR_0_APB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_5_APB_PTR_0_APB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_APB_PTR_0_APB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_5_APB_SEQ_0  
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0                  _MK_ADDR_CONST(0xbc)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20010000)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0x78070000)
// 0 = 8 bit Bus 1 = 16 bit Bus 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD) 4 = 128 bit BUS (RSVD)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

// when enabled the data going  to APB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

//APB Address Wrap-around Window 0 = No Wrap 1 = Wrap on 1 Word Window (def) 2 = Wrap on 2 Word Window 3 = Wrap on 4 Word Window 4 = Wrap on 8 Word Window 5 = Wrap on 16 Word Window 6 = Wrap on 32 Word Window 7 = Wrap on 64 Word Window (rsvd)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_RANGE                      18:16
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_NO_WRAP                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_WRAP_0N_1WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_2WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_4WORDS                     _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_8WORDS                     _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_16WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_32WORDS                    _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_5_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_64WORDS                    _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_6_CSR_0  
#define APBDMACHAN_CHANNEL_6_CSR_0                      _MK_ADDR_CONST(0xc0)
#define APBDMACHAN_CHANNEL_6_CSR_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_6_CSR_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_6_CSR_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_RESET_MASK                   _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_6_CSR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_READ_MASK                    _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_6_CSR_0_WRITE_MASK                   _MK_MASK_CONST(0xfffffffc)
// Enables DMA channel transfer 
#define APBDMACHAN_CHANNEL_6_CSR_0_ENB_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_6_CSR_0_ENB_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_6_CSR_0_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_6_CSR_0_ENB_RANGE                    31:31
#define APBDMACHAN_CHANNEL_6_CSR_0_ENB_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_6_CSR_0_ENB_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_ENB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_6_CSR_0_ENB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_ENB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_ENB_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_CSR_0_ENB_ENABLE                   _MK_ENUM_CONST(1)

// Interrupts when DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_6_CSR_0_IE_EOC_SHIFT                 _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_6_CSR_0_IE_EOC_FIELD                 (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_6_CSR_0_IE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_6_CSR_0_IE_EOC_RANGE                 30:30
#define APBDMACHAN_CHANNEL_6_CSR_0_IE_EOC_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_6_CSR_0_IE_EOC_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_IE_EOC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_6_CSR_0_IE_EOC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_IE_EOC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_IE_EOC_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_CSR_0_IE_EOC_ENABLE                        _MK_ENUM_CONST(1)

// Holds this Processor until DMA Block Transfer Completes
#define APBDMACHAN_CHANNEL_6_CSR_0_HOLD_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_6_CSR_0_HOLD_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_6_CSR_0_HOLD_SHIFT)
#define APBDMACHAN_CHANNEL_6_CSR_0_HOLD_RANGE                   29:29
#define APBDMACHAN_CHANNEL_6_CSR_0_HOLD_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_6_CSR_0_HOLD_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_HOLD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_6_CSR_0_HOLD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_HOLD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_HOLD_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_CSR_0_HOLD_ENABLE                  _MK_ENUM_CONST(1)

// DMA Transfer Direction 1 = AHB read to APB write 0 = APB read to AHB write
#define APBDMACHAN_CHANNEL_6_CSR_0_DIR_SHIFT                    _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_6_CSR_0_DIR_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_6_CSR_0_DIR_SHIFT)
#define APBDMACHAN_CHANNEL_6_CSR_0_DIR_RANGE                    28:28
#define APBDMACHAN_CHANNEL_6_CSR_0_DIR_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_6_CSR_0_DIR_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_DIR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_6_CSR_0_DIR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_DIR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_DIR_AHB_WRITE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_CSR_0_DIR_AHB_READ                 _MK_ENUM_CONST(1)

// Run Once or Run Multiple Mode (Allow Retriggering of this Channel) 1 = Run for One Block Transfer 0 = Run for Multiple Block Transfer
#define APBDMACHAN_CHANNEL_6_CSR_0_ONCE_SHIFT                   _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_6_CSR_0_ONCE_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_6_CSR_0_ONCE_SHIFT)
#define APBDMACHAN_CHANNEL_6_CSR_0_ONCE_RANGE                   27:27
#define APBDMACHAN_CHANNEL_6_CSR_0_ONCE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_6_CSR_0_ONCE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_ONCE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_6_CSR_0_ONCE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_ONCE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_ONCE_MULTIPLE_BLOCK                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_CSR_0_ONCE_SINGLE_BLOCK                    _MK_ENUM_CONST(1)

// Enable on Non-Zero Value
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_SHIFT                       _MK_SHIFT_CONST(22)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_FIELD                       (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_RANGE                       26:22
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_NA1                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_SMP24                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_SMP25                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_SMP26                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_SMP27                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_XRQ_A                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_XRQ_B                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_TMR1                        _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_TMR2                        _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_APB_0                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_APB_1                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_APB_2                       _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_APB_3                       _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_APB_4                       _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_APB_5                       _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_APB_6                       _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_APB_7                       _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_APB_8                       _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_APB_9                       _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_APB_10                      _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_APB_11                      _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_APB_12                      _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_APB_13                      _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_APB_14                      _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_6_CSR_0_TRIG_SEL_APB_15                      _MK_ENUM_CONST(24)

// Flow Control Enable (Synchronize Burst Transfers) 1 = Link to DRQ source 0 = Independent of DRQ request
#define APBDMACHAN_CHANNEL_6_CSR_0_FLOW_SHIFT                   _MK_SHIFT_CONST(21)
#define APBDMACHAN_CHANNEL_6_CSR_0_FLOW_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_6_CSR_0_FLOW_SHIFT)
#define APBDMACHAN_CHANNEL_6_CSR_0_FLOW_RANGE                   21:21
#define APBDMACHAN_CHANNEL_6_CSR_0_FLOW_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_6_CSR_0_FLOW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_FLOW_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_6_CSR_0_FLOW_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_FLOW_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_FLOW_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_CSR_0_FLOW_ENABLE                  _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_SHIFT                        _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_FIELD                        (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_RANGE                        20:16
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_CNTR_REQ                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_I2S_2                        _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_I2S_1                        _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_SPD_I                        _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_UI_I                 _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_MIPI                 _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_I2S2_2                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_I2S2_1                       _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_UART_A                       _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_UART_B                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_UART_C                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_SPI                  _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_AC97                 _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_ACModem                      _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_SL4B                 _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_SL2B1                        _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_SL2B2                        _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_SL2B3                        _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_SL2B4                        _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_UART_D                       _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_UART_E                       _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_I2C                  _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_I2C2                 _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_I2C3                 _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_DVC_I2C                      _MK_ENUM_CONST(24)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_OWR                  _MK_ENUM_CONST(25)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_NA26                 _MK_ENUM_CONST(26)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_NA27                 _MK_ENUM_CONST(27)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_NA28                 _MK_ENUM_CONST(28)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_NA29                 _MK_ENUM_CONST(29)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_NA30                 _MK_ENUM_CONST(30)
#define APBDMACHAN_CHANNEL_6_CSR_0_REQ_SEL_NA31                 _MK_ENUM_CONST(31)

// Number of 32bit word cycles
#define APBDMACHAN_CHANNEL_6_CSR_0_WCOUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_6_CSR_0_WCOUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_6_CSR_0_WCOUNT_SHIFT)
#define APBDMACHAN_CHANNEL_6_CSR_0_WCOUNT_RANGE                 15:2
#define APBDMACHAN_CHANNEL_6_CSR_0_WCOUNT_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_6_CSR_0_WCOUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_WCOUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_6_CSR_0_WCOUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_CSR_0_WCOUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_6_STA_0  
#define APBDMACHAN_CHANNEL_6_STA_0                      _MK_ADDR_CONST(0xc4)
#define APBDMACHAN_CHANNEL_6_STA_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_6_STA_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_6_STA_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_RESET_MASK                   _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_6_STA_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_READ_MASK                    _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_6_STA_0_WRITE_MASK                   _MK_MASK_CONST(0x40000000)
// indicate whether DMA Channel Status active or not
#define APBDMACHAN_CHANNEL_6_STA_0_BSY_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_6_STA_0_BSY_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_6_STA_0_BSY_SHIFT)
#define APBDMACHAN_CHANNEL_6_STA_0_BSY_RANGE                    31:31
#define APBDMACHAN_CHANNEL_6_STA_0_BSY_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_6_STA_0_BSY_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_BSY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_6_STA_0_BSY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_BSY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_BSY_WAIT                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_STA_0_BSY_ACTIVE                   _MK_ENUM_CONST(1)

//  Write '1' to clear the flag
#define APBDMACHAN_CHANNEL_6_STA_0_ISE_EOC_SHIFT                        _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_6_STA_0_ISE_EOC_FIELD                        (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_6_STA_0_ISE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_6_STA_0_ISE_EOC_RANGE                        30:30
#define APBDMACHAN_CHANNEL_6_STA_0_ISE_EOC_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_6_STA_0_ISE_EOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_ISE_EOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_6_STA_0_ISE_EOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_ISE_EOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_ISE_EOC_NO_INTR                      _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_STA_0_ISE_EOC_INTR                 _MK_ENUM_CONST(1)

// Holding Status of Processor 
#define APBDMACHAN_CHANNEL_6_STA_0_HALT_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_6_STA_0_HALT_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_6_STA_0_HALT_SHIFT)
#define APBDMACHAN_CHANNEL_6_STA_0_HALT_RANGE                   29:29
#define APBDMACHAN_CHANNEL_6_STA_0_HALT_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_6_STA_0_HALT_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_HALT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_6_STA_0_HALT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_HALT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_HALT_NO_HALT                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_STA_0_HALT_HALT                    _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_6_STA_0_PING_PONG_STA_SHIFT                  _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_6_STA_0_PING_PONG_STA_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_6_STA_0_PING_PONG_STA_SHIFT)
#define APBDMACHAN_CHANNEL_6_STA_0_PING_PONG_STA_RANGE                  28:28
#define APBDMACHAN_CHANNEL_6_STA_0_PING_PONG_STA_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_6_STA_0_PING_PONG_STA_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_PING_PONG_STA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_6_STA_0_PING_PONG_STA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_PING_PONG_STA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_PING_PONG_STA_PING_INTR_STA                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_STA_0_PING_PONG_STA_PONG_INTR_STA                  _MK_ENUM_CONST(1)

// Current 32bit word cycles Flags set /cleared by HW
#define APBDMACHAN_CHANNEL_6_STA_0_COUNT_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_6_STA_0_COUNT_FIELD                  (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_6_STA_0_COUNT_SHIFT)
#define APBDMACHAN_CHANNEL_6_STA_0_COUNT_RANGE                  15:2
#define APBDMACHAN_CHANNEL_6_STA_0_COUNT_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_6_STA_0_COUNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_COUNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_6_STA_0_COUNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_STA_0_COUNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 200 [0xc8] 

// Reserved address 204 [0xcc] 

// Register APBDMACHAN_CHANNEL_6_AHB_PTR_0  
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0                  _MK_ADDR_CONST(0xd0)
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffffffc)
// APB-DMA Starting Address for AHB Bus: SW writes to  modify
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0_AHB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0_AHB_BASE_FIELD                   (_MK_MASK_CONST(0x3fffffff) << APBDMACHAN_CHANNEL_6_AHB_PTR_0_AHB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0_AHB_BASE_RANGE                   31:2
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0_AHB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0_AHB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0_AHB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fffffff)
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0_AHB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_PTR_0_AHB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_6_AHB_SEQ_0  
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0                  _MK_ADDR_CONST(0xd4)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20000000)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0xff0f0000)
//  0 = send interrupt to COP
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_INTR_ENB_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_INTR_ENB_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_6_AHB_SEQ_0_INTR_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_INTR_ENB_RANGE                   31:31
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_INTR_ENB_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_INTR_ENB_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_INTR_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_INTR_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_INTR_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_INTR_ENB_CPU                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_INTR_ENB_COP                     _MK_ENUM_CONST(0)

// AHB Bus Width 0 = 8 bit Bus (RSVD) 1 = 16 bit Bus (RSVD) 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD)4 = 128 bit Bus (RSVD)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

// when enabled the data going  to AHB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

// AHB Burst Size DMA Burst Length (encoded) 4 = 1 Word (1x32bits) 5 = 4 Words (4x32bits)else = 8 Words (8x32bits) default
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BURST_SHIFT                  _MK_SHIFT_CONST(24)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BURST_FIELD                  (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BURST_SHIFT)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BURST_RANGE                  26:24
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BURST_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BURST_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BURST_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BURST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BURST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BURST_DMA_BURST_1WORDS                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BURST_DMA_BURST_4WORDS                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_AHB_BURST_DMA_BURST_8WORDS                       _MK_ENUM_CONST(6)

// 2X Double Buffering Mode (For Run-Multiple Mode with No Wrap Operations) 1 = Reload Base Address for 2X blocks (reload every other time) 0 = Reload Base Address for 1X blocks  (def) (reload each time)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_DBL_BUF_SHIFT                    _MK_SHIFT_CONST(19)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_DBL_BUF_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_6_AHB_SEQ_0_DBL_BUF_SHIFT)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_DBL_BUF_RANGE                    19:19
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_DBL_BUF_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_DBL_BUF_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_DBL_BUF_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_DBL_BUF_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_DBL_BUF_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_1X_BLOCKS                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_2X_BLOCKS                     _MK_ENUM_CONST(1)

// AHB Address Wrap: AHB Address wrap-around window 0=No Wrap (default) 5=Wrap on 512 word window 1=Wrap on 32 word window 6=Wrap on 1024 word window 2=Wrap on 64 word window 7=Wrap on 2048 word window 3=Wrap on 128 word window 4=Wrap on 256 word window
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_FIELD                       (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_RANGE                       18:16
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_NO_WRAP                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_WRAP_0N_32WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_WRAP_ON_64WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_WRAP_ON_128WORDS                    _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_WRAP_ON_256WORDS                    _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_WRAP_ON_512WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_WRAP_ON_1024WORDS                   _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_6_AHB_SEQ_0_WRAP_WRAP_ON_2048WORDS                   _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_6_APB_PTR_0  
#define APBDMACHAN_CHANNEL_6_APB_PTR_0                  _MK_ADDR_CONST(0xd8)
#define APBDMACHAN_CHANNEL_6_APB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_6_APB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_6_APB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_APB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_6_APB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_APB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_APB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_6_APB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffc)
// APB-DMA Starting address for APB Bus: APB Base address:Upper 16 bits are fixed at 0x7000:XXXX
#define APBDMACHAN_CHANNEL_6_APB_PTR_0_APB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_6_APB_PTR_0_APB_BASE_FIELD                   (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_6_APB_PTR_0_APB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_6_APB_PTR_0_APB_BASE_RANGE                   15:2
#define APBDMACHAN_CHANNEL_6_APB_PTR_0_APB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_6_APB_PTR_0_APB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_APB_PTR_0_APB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_6_APB_PTR_0_APB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_APB_PTR_0_APB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_6_APB_SEQ_0  
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0                  _MK_ADDR_CONST(0xdc)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20010000)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0x78070000)
// 0 = 8 bit Bus 1 = 16 bit Bus 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD) 4 = 128 bit BUS (RSVD)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

// when enabled the data going  to APB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

//APB Address Wrap-around Window 0 = No Wrap 1 = Wrap on 1 Word Window (def) 2 = Wrap on 2 Word Window 3 = Wrap on 4 Word Window 4 = Wrap on 8 Word Window 5 = Wrap on 16 Word Window 6 = Wrap on 32 Word Window 7 = Wrap on 64 Word Window (rsvd)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_RANGE                      18:16
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_NO_WRAP                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_WRAP_0N_1WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_2WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_4WORDS                     _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_8WORDS                     _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_16WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_32WORDS                    _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_6_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_64WORDS                    _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_7_CSR_0  
#define APBDMACHAN_CHANNEL_7_CSR_0                      _MK_ADDR_CONST(0xe0)
#define APBDMACHAN_CHANNEL_7_CSR_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_7_CSR_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_7_CSR_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_RESET_MASK                   _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_7_CSR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_READ_MASK                    _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_7_CSR_0_WRITE_MASK                   _MK_MASK_CONST(0xfffffffc)
// Enables DMA channel transfer 
#define APBDMACHAN_CHANNEL_7_CSR_0_ENB_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_7_CSR_0_ENB_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_7_CSR_0_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_7_CSR_0_ENB_RANGE                    31:31
#define APBDMACHAN_CHANNEL_7_CSR_0_ENB_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_7_CSR_0_ENB_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_ENB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_7_CSR_0_ENB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_ENB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_ENB_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_CSR_0_ENB_ENABLE                   _MK_ENUM_CONST(1)

// Interrupts when DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_7_CSR_0_IE_EOC_SHIFT                 _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_7_CSR_0_IE_EOC_FIELD                 (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_7_CSR_0_IE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_7_CSR_0_IE_EOC_RANGE                 30:30
#define APBDMACHAN_CHANNEL_7_CSR_0_IE_EOC_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_7_CSR_0_IE_EOC_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_IE_EOC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_7_CSR_0_IE_EOC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_IE_EOC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_IE_EOC_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_CSR_0_IE_EOC_ENABLE                        _MK_ENUM_CONST(1)

// Holds this Processor until DMA Block Transfer Completes
#define APBDMACHAN_CHANNEL_7_CSR_0_HOLD_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_7_CSR_0_HOLD_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_7_CSR_0_HOLD_SHIFT)
#define APBDMACHAN_CHANNEL_7_CSR_0_HOLD_RANGE                   29:29
#define APBDMACHAN_CHANNEL_7_CSR_0_HOLD_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_7_CSR_0_HOLD_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_HOLD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_7_CSR_0_HOLD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_HOLD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_HOLD_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_CSR_0_HOLD_ENABLE                  _MK_ENUM_CONST(1)

// DMA Transfer Direction 1 = AHB read to APB write 0 = APB read to AHB write
#define APBDMACHAN_CHANNEL_7_CSR_0_DIR_SHIFT                    _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_7_CSR_0_DIR_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_7_CSR_0_DIR_SHIFT)
#define APBDMACHAN_CHANNEL_7_CSR_0_DIR_RANGE                    28:28
#define APBDMACHAN_CHANNEL_7_CSR_0_DIR_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_7_CSR_0_DIR_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_DIR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_7_CSR_0_DIR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_DIR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_DIR_AHB_WRITE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_CSR_0_DIR_AHB_READ                 _MK_ENUM_CONST(1)

// Run Once or Run Multiple Mode (Allow Retriggering of this Channel) 1 = Run for One Block Transfer 0 = Run for Multiple Block Transfer
#define APBDMACHAN_CHANNEL_7_CSR_0_ONCE_SHIFT                   _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_7_CSR_0_ONCE_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_7_CSR_0_ONCE_SHIFT)
#define APBDMACHAN_CHANNEL_7_CSR_0_ONCE_RANGE                   27:27
#define APBDMACHAN_CHANNEL_7_CSR_0_ONCE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_7_CSR_0_ONCE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_ONCE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_7_CSR_0_ONCE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_ONCE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_ONCE_MULTIPLE_BLOCK                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_CSR_0_ONCE_SINGLE_BLOCK                    _MK_ENUM_CONST(1)

// Enable on Non-Zero Value
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_SHIFT                       _MK_SHIFT_CONST(22)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_FIELD                       (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_RANGE                       26:22
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_NA1                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_SMP24                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_SMP25                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_SMP26                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_SMP27                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_XRQ_A                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_XRQ_B                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_TMR1                        _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_TMR2                        _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_APB_0                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_APB_1                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_APB_2                       _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_APB_3                       _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_APB_4                       _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_APB_5                       _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_APB_6                       _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_APB_7                       _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_APB_8                       _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_APB_9                       _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_APB_10                      _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_APB_11                      _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_APB_12                      _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_APB_13                      _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_APB_14                      _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_7_CSR_0_TRIG_SEL_APB_15                      _MK_ENUM_CONST(24)

// Flow Control Enable (Synchronize Burst Transfers) 1 = Link to DRQ source 0 = Independent of DRQ request
#define APBDMACHAN_CHANNEL_7_CSR_0_FLOW_SHIFT                   _MK_SHIFT_CONST(21)
#define APBDMACHAN_CHANNEL_7_CSR_0_FLOW_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_7_CSR_0_FLOW_SHIFT)
#define APBDMACHAN_CHANNEL_7_CSR_0_FLOW_RANGE                   21:21
#define APBDMACHAN_CHANNEL_7_CSR_0_FLOW_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_7_CSR_0_FLOW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_FLOW_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_7_CSR_0_FLOW_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_FLOW_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_FLOW_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_CSR_0_FLOW_ENABLE                  _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_SHIFT                        _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_FIELD                        (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_RANGE                        20:16
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_CNTR_REQ                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_I2S_2                        _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_I2S_1                        _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_SPD_I                        _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_UI_I                 _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_MIPI                 _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_I2S2_2                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_I2S2_1                       _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_UART_A                       _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_UART_B                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_UART_C                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_SPI                  _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_AC97                 _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_ACModem                      _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_SL4B                 _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_SL2B1                        _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_SL2B2                        _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_SL2B3                        _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_SL2B4                        _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_UART_D                       _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_UART_E                       _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_I2C                  _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_I2C2                 _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_I2C3                 _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_DVC_I2C                      _MK_ENUM_CONST(24)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_OWR                  _MK_ENUM_CONST(25)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_NA26                 _MK_ENUM_CONST(26)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_NA27                 _MK_ENUM_CONST(27)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_NA28                 _MK_ENUM_CONST(28)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_NA29                 _MK_ENUM_CONST(29)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_NA30                 _MK_ENUM_CONST(30)
#define APBDMACHAN_CHANNEL_7_CSR_0_REQ_SEL_NA31                 _MK_ENUM_CONST(31)

// Number of 32bit word cycles
#define APBDMACHAN_CHANNEL_7_CSR_0_WCOUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_7_CSR_0_WCOUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_7_CSR_0_WCOUNT_SHIFT)
#define APBDMACHAN_CHANNEL_7_CSR_0_WCOUNT_RANGE                 15:2
#define APBDMACHAN_CHANNEL_7_CSR_0_WCOUNT_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_7_CSR_0_WCOUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_WCOUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_7_CSR_0_WCOUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_CSR_0_WCOUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_7_STA_0  
#define APBDMACHAN_CHANNEL_7_STA_0                      _MK_ADDR_CONST(0xe4)
#define APBDMACHAN_CHANNEL_7_STA_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_7_STA_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_7_STA_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_RESET_MASK                   _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_7_STA_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_READ_MASK                    _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_7_STA_0_WRITE_MASK                   _MK_MASK_CONST(0x40000000)
// indicate whether DMA Channel Status Active or not 
#define APBDMACHAN_CHANNEL_7_STA_0_BSY_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_7_STA_0_BSY_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_7_STA_0_BSY_SHIFT)
#define APBDMACHAN_CHANNEL_7_STA_0_BSY_RANGE                    31:31
#define APBDMACHAN_CHANNEL_7_STA_0_BSY_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_7_STA_0_BSY_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_BSY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_7_STA_0_BSY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_BSY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_BSY_WAIT                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_STA_0_BSY_ACTIVE                   _MK_ENUM_CONST(1)

//  Write '1' to clear the flag
#define APBDMACHAN_CHANNEL_7_STA_0_ISE_EOC_SHIFT                        _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_7_STA_0_ISE_EOC_FIELD                        (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_7_STA_0_ISE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_7_STA_0_ISE_EOC_RANGE                        30:30
#define APBDMACHAN_CHANNEL_7_STA_0_ISE_EOC_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_7_STA_0_ISE_EOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_ISE_EOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_7_STA_0_ISE_EOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_ISE_EOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_ISE_EOC_NO_INTR                      _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_STA_0_ISE_EOC_INTR                 _MK_ENUM_CONST(1)

// Holding Status of Processor 
#define APBDMACHAN_CHANNEL_7_STA_0_HALT_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_7_STA_0_HALT_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_7_STA_0_HALT_SHIFT)
#define APBDMACHAN_CHANNEL_7_STA_0_HALT_RANGE                   29:29
#define APBDMACHAN_CHANNEL_7_STA_0_HALT_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_7_STA_0_HALT_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_HALT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_7_STA_0_HALT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_HALT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_HALT_NO_HALT                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_STA_0_HALT_HALT                    _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_7_STA_0_PING_PONG_STA_SHIFT                  _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_7_STA_0_PING_PONG_STA_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_7_STA_0_PING_PONG_STA_SHIFT)
#define APBDMACHAN_CHANNEL_7_STA_0_PING_PONG_STA_RANGE                  28:28
#define APBDMACHAN_CHANNEL_7_STA_0_PING_PONG_STA_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_7_STA_0_PING_PONG_STA_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_PING_PONG_STA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_7_STA_0_PING_PONG_STA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_PING_PONG_STA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_PING_PONG_STA_PING_INTR_STA                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_STA_0_PING_PONG_STA_PONG_INTR_STA                  _MK_ENUM_CONST(1)

// Current 32bit word cycles Flags set /cleared by HW
#define APBDMACHAN_CHANNEL_7_STA_0_COUNT_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_7_STA_0_COUNT_FIELD                  (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_7_STA_0_COUNT_SHIFT)
#define APBDMACHAN_CHANNEL_7_STA_0_COUNT_RANGE                  15:2
#define APBDMACHAN_CHANNEL_7_STA_0_COUNT_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_7_STA_0_COUNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_COUNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_7_STA_0_COUNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_STA_0_COUNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 232 [0xe8] 

// Reserved address 236 [0xec] 

// Register APBDMACHAN_CHANNEL_7_AHB_PTR_0  
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0                  _MK_ADDR_CONST(0xf0)
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffffffc)
// APB-DMA Starting Address for AHB Bus: SW writes to  modify
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0_AHB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0_AHB_BASE_FIELD                   (_MK_MASK_CONST(0x3fffffff) << APBDMACHAN_CHANNEL_7_AHB_PTR_0_AHB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0_AHB_BASE_RANGE                   31:2
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0_AHB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0_AHB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0_AHB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fffffff)
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0_AHB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_PTR_0_AHB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_7_AHB_SEQ_0  
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0                  _MK_ADDR_CONST(0xf4)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20000000)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0xff0f0000)
//  0 = send interrupt to COP
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_INTR_ENB_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_INTR_ENB_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_7_AHB_SEQ_0_INTR_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_INTR_ENB_RANGE                   31:31
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_INTR_ENB_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_INTR_ENB_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_INTR_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_INTR_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_INTR_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_INTR_ENB_CPU                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_INTR_ENB_COP                     _MK_ENUM_CONST(0)

// AHB Bus Width 0 = 8 bit Bus (RSVD) 1 = 16 bit Bus (RSVD) 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD)4 = 128 bit Bus (RSVD)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

// when enabled the data going  to AHB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

// AHB Burst Size DMA Burst Length (encoded) 4 = 1 Word (1x32bits) 5 = 4 Words (4x32bits)else = 8 Words (8x32bits) default
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BURST_SHIFT                  _MK_SHIFT_CONST(24)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BURST_FIELD                  (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BURST_SHIFT)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BURST_RANGE                  26:24
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BURST_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BURST_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BURST_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BURST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BURST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BURST_DMA_BURST_1WORDS                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BURST_DMA_BURST_4WORDS                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_AHB_BURST_DMA_BURST_8WORDS                       _MK_ENUM_CONST(6)

// 2X Double Buffering Mode (For Run-Multiple Mode with No Wrap Operations) 1 = Reload Base Address for 2X blocks (reload every other time) 0 = Reload Base Address for 1X blocks  (def) (reload each time)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_DBL_BUF_SHIFT                    _MK_SHIFT_CONST(19)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_DBL_BUF_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_7_AHB_SEQ_0_DBL_BUF_SHIFT)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_DBL_BUF_RANGE                    19:19
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_DBL_BUF_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_DBL_BUF_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_DBL_BUF_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_DBL_BUF_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_DBL_BUF_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_1X_BLOCKS                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_2X_BLOCKS                     _MK_ENUM_CONST(1)

// AHB Address Wrap: AHB Address wrap-around window 0=No Wrap (default) 5=Wrap on 512 word window 1=Wrap on 32 word window 6=Wrap on 1024 word window 2=Wrap on 64 word window 7=Wrap on 2048 word window 3=Wrap on 128 word window 4=Wrap on 256 word window
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_FIELD                       (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_RANGE                       18:16
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_NO_WRAP                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_WRAP_0N_32WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_WRAP_ON_64WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_WRAP_ON_128WORDS                    _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_WRAP_ON_256WORDS                    _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_WRAP_ON_512WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_WRAP_ON_1024WORDS                   _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_7_AHB_SEQ_0_WRAP_WRAP_ON_2048WORDS                   _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_7_APB_PTR_0  
#define APBDMACHAN_CHANNEL_7_APB_PTR_0                  _MK_ADDR_CONST(0xf8)
#define APBDMACHAN_CHANNEL_7_APB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_7_APB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_7_APB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_APB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_7_APB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_APB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_APB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_7_APB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffc)
// APB-DMA Starting address for APB Bus: APB Base address:Upper 16 bits are fixed at 0x7000:XXXX
#define APBDMACHAN_CHANNEL_7_APB_PTR_0_APB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_7_APB_PTR_0_APB_BASE_FIELD                   (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_7_APB_PTR_0_APB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_7_APB_PTR_0_APB_BASE_RANGE                   15:2
#define APBDMACHAN_CHANNEL_7_APB_PTR_0_APB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_7_APB_PTR_0_APB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_APB_PTR_0_APB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_7_APB_PTR_0_APB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_APB_PTR_0_APB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_7_APB_SEQ_0  
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0                  _MK_ADDR_CONST(0xfc)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20010000)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0x78070000)
// 0 = 8 bit Bus 1 = 16 bit Bus 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD) 4 = 128 bit BUS (RSVD)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

// when enabled the data going  to APB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }.
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

//APB Address Wrap-around Window 0 = No Wrap 1 = Wrap on 1 Word Window (def) 2 = Wrap on 2 Word Window 3 = Wrap on 4 Word Window 4 = Wrap on 8 Word Window 5 = Wrap on 16 Word Window 6 = Wrap on 32 Word Window 7 = Wrap on 64 Word Window (rsvd)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_RANGE                      18:16
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_NO_WRAP                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_WRAP_0N_1WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_2WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_4WORDS                     _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_8WORDS                     _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_16WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_32WORDS                    _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_7_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_64WORDS                    _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_8_CSR_0  
#define APBDMACHAN_CHANNEL_8_CSR_0                      _MK_ADDR_CONST(0x100)
#define APBDMACHAN_CHANNEL_8_CSR_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_8_CSR_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_8_CSR_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_RESET_MASK                   _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_8_CSR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_READ_MASK                    _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_8_CSR_0_WRITE_MASK                   _MK_MASK_CONST(0xfffffffc)
// Enables DMA channel transfer 
#define APBDMACHAN_CHANNEL_8_CSR_0_ENB_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_8_CSR_0_ENB_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_8_CSR_0_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_8_CSR_0_ENB_RANGE                    31:31
#define APBDMACHAN_CHANNEL_8_CSR_0_ENB_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_8_CSR_0_ENB_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_ENB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_8_CSR_0_ENB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_ENB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_ENB_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_CSR_0_ENB_ENABLE                   _MK_ENUM_CONST(1)

// Interrupts when DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_8_CSR_0_IE_EOC_SHIFT                 _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_8_CSR_0_IE_EOC_FIELD                 (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_8_CSR_0_IE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_8_CSR_0_IE_EOC_RANGE                 30:30
#define APBDMACHAN_CHANNEL_8_CSR_0_IE_EOC_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_8_CSR_0_IE_EOC_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_IE_EOC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_8_CSR_0_IE_EOC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_IE_EOC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_IE_EOC_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_CSR_0_IE_EOC_ENABLE                        _MK_ENUM_CONST(1)

// Holds this Processor until DMA Block Transfer Completes
#define APBDMACHAN_CHANNEL_8_CSR_0_HOLD_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_8_CSR_0_HOLD_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_8_CSR_0_HOLD_SHIFT)
#define APBDMACHAN_CHANNEL_8_CSR_0_HOLD_RANGE                   29:29
#define APBDMACHAN_CHANNEL_8_CSR_0_HOLD_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_8_CSR_0_HOLD_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_HOLD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_8_CSR_0_HOLD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_HOLD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_HOLD_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_CSR_0_HOLD_ENABLE                  _MK_ENUM_CONST(1)

// DMA Transfer Direction 1 = AHB read to APB write 0 = APB read to AHB write
#define APBDMACHAN_CHANNEL_8_CSR_0_DIR_SHIFT                    _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_8_CSR_0_DIR_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_8_CSR_0_DIR_SHIFT)
#define APBDMACHAN_CHANNEL_8_CSR_0_DIR_RANGE                    28:28
#define APBDMACHAN_CHANNEL_8_CSR_0_DIR_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_8_CSR_0_DIR_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_DIR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_8_CSR_0_DIR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_DIR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_DIR_AHB_WRITE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_CSR_0_DIR_AHB_READ                 _MK_ENUM_CONST(1)

// Run Once or Run Multiple Mode (Allow Retriggering of this Channel) 1 = Run for One Block Transfer 0 = Run for Multiple Block Transfer
#define APBDMACHAN_CHANNEL_8_CSR_0_ONCE_SHIFT                   _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_8_CSR_0_ONCE_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_8_CSR_0_ONCE_SHIFT)
#define APBDMACHAN_CHANNEL_8_CSR_0_ONCE_RANGE                   27:27
#define APBDMACHAN_CHANNEL_8_CSR_0_ONCE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_8_CSR_0_ONCE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_ONCE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_8_CSR_0_ONCE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_ONCE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_ONCE_MULTIPLE_BLOCK                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_CSR_0_ONCE_SINGLE_BLOCK                    _MK_ENUM_CONST(1)

// Enable on Non-Zero Value
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_SHIFT                       _MK_SHIFT_CONST(22)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_FIELD                       (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_RANGE                       26:22
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_NA1                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_SMP24                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_SMP25                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_SMP26                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_SMP27                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_XRQ_A                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_XRQ_B                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_TMR1                        _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_TMR2                        _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_APB_0                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_APB_1                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_APB_2                       _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_APB_3                       _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_APB_4                       _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_APB_5                       _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_APB_6                       _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_APB_7                       _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_APB_8                       _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_APB_9                       _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_APB_10                      _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_APB_11                      _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_APB_12                      _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_APB_13                      _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_APB_14                      _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_8_CSR_0_TRIG_SEL_APB_15                      _MK_ENUM_CONST(24)

// Flow Control Enable (Synchronize Burst Transfers) 1 = Link to DRQ source 0 = Independent of DRQ request
#define APBDMACHAN_CHANNEL_8_CSR_0_FLOW_SHIFT                   _MK_SHIFT_CONST(21)
#define APBDMACHAN_CHANNEL_8_CSR_0_FLOW_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_8_CSR_0_FLOW_SHIFT)
#define APBDMACHAN_CHANNEL_8_CSR_0_FLOW_RANGE                   21:21
#define APBDMACHAN_CHANNEL_8_CSR_0_FLOW_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_8_CSR_0_FLOW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_FLOW_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_8_CSR_0_FLOW_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_FLOW_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_FLOW_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_CSR_0_FLOW_ENABLE                  _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_SHIFT                        _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_FIELD                        (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_RANGE                        20:16
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_CNTR_REQ                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_I2S_2                        _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_I2S_1                        _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_SPD_I                        _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_UI_I                 _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_MIPI                 _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_I2S2_2                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_I2S2_1                       _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_UART_A                       _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_UART_B                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_UART_C                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_SPI                  _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_AC97                 _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_ACModem                      _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_SL4B                 _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_SL2B1                        _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_SL2B2                        _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_SL2B3                        _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_SL2B4                        _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_UART_D                       _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_UART_E                       _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_I2C                  _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_I2C2                 _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_I2C3                 _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_DVC_I2C                      _MK_ENUM_CONST(24)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_OWR                  _MK_ENUM_CONST(25)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_NA26                 _MK_ENUM_CONST(26)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_NA27                 _MK_ENUM_CONST(27)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_NA28                 _MK_ENUM_CONST(28)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_NA29                 _MK_ENUM_CONST(29)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_NA30                 _MK_ENUM_CONST(30)
#define APBDMACHAN_CHANNEL_8_CSR_0_REQ_SEL_NA31                 _MK_ENUM_CONST(31)

// Number of 32bit word cycles
#define APBDMACHAN_CHANNEL_8_CSR_0_WCOUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_8_CSR_0_WCOUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_8_CSR_0_WCOUNT_SHIFT)
#define APBDMACHAN_CHANNEL_8_CSR_0_WCOUNT_RANGE                 15:2
#define APBDMACHAN_CHANNEL_8_CSR_0_WCOUNT_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_8_CSR_0_WCOUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_WCOUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_8_CSR_0_WCOUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_CSR_0_WCOUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_8_STA_0  
#define APBDMACHAN_CHANNEL_8_STA_0                      _MK_ADDR_CONST(0x104)
#define APBDMACHAN_CHANNEL_8_STA_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_8_STA_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_8_STA_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_RESET_MASK                   _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_8_STA_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_READ_MASK                    _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_8_STA_0_WRITE_MASK                   _MK_MASK_CONST(0x40000000)
// indicate DMA Channel Status activate or not
#define APBDMACHAN_CHANNEL_8_STA_0_BSY_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_8_STA_0_BSY_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_8_STA_0_BSY_SHIFT)
#define APBDMACHAN_CHANNEL_8_STA_0_BSY_RANGE                    31:31
#define APBDMACHAN_CHANNEL_8_STA_0_BSY_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_8_STA_0_BSY_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_BSY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_8_STA_0_BSY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_BSY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_BSY_WAIT                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_STA_0_BSY_ACTIVE                   _MK_ENUM_CONST(1)

//  Write '1' to clear the flag
#define APBDMACHAN_CHANNEL_8_STA_0_ISE_EOC_SHIFT                        _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_8_STA_0_ISE_EOC_FIELD                        (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_8_STA_0_ISE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_8_STA_0_ISE_EOC_RANGE                        30:30
#define APBDMACHAN_CHANNEL_8_STA_0_ISE_EOC_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_8_STA_0_ISE_EOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_ISE_EOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_8_STA_0_ISE_EOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_ISE_EOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_ISE_EOC_NO_INTR                      _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_STA_0_ISE_EOC_INTR                 _MK_ENUM_CONST(1)

// Holding Status of Processor 
#define APBDMACHAN_CHANNEL_8_STA_0_HALT_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_8_STA_0_HALT_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_8_STA_0_HALT_SHIFT)
#define APBDMACHAN_CHANNEL_8_STA_0_HALT_RANGE                   29:29
#define APBDMACHAN_CHANNEL_8_STA_0_HALT_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_8_STA_0_HALT_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_HALT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_8_STA_0_HALT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_HALT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_HALT_NO_HALT                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_STA_0_HALT_HALT                    _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_8_STA_0_PING_PONG_STA_SHIFT                  _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_8_STA_0_PING_PONG_STA_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_8_STA_0_PING_PONG_STA_SHIFT)
#define APBDMACHAN_CHANNEL_8_STA_0_PING_PONG_STA_RANGE                  28:28
#define APBDMACHAN_CHANNEL_8_STA_0_PING_PONG_STA_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_8_STA_0_PING_PONG_STA_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_PING_PONG_STA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_8_STA_0_PING_PONG_STA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_PING_PONG_STA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_PING_PONG_STA_PING_INTR_STA                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_STA_0_PING_PONG_STA_PONG_INTR_STA                  _MK_ENUM_CONST(1)

// Current 32bit word cycles Flags set /cleared by HW
#define APBDMACHAN_CHANNEL_8_STA_0_COUNT_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_8_STA_0_COUNT_FIELD                  (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_8_STA_0_COUNT_SHIFT)
#define APBDMACHAN_CHANNEL_8_STA_0_COUNT_RANGE                  15:2
#define APBDMACHAN_CHANNEL_8_STA_0_COUNT_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_8_STA_0_COUNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_COUNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_8_STA_0_COUNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_STA_0_COUNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 264 [0x108] 

// Reserved address 268 [0x10c] 

// Register APBDMACHAN_CHANNEL_8_AHB_PTR_0  
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0                  _MK_ADDR_CONST(0x110)
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffffffc)
// APB-DMA Starting Address for AHB Bus: SW writes to  modify
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0_AHB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0_AHB_BASE_FIELD                   (_MK_MASK_CONST(0x3fffffff) << APBDMACHAN_CHANNEL_8_AHB_PTR_0_AHB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0_AHB_BASE_RANGE                   31:2
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0_AHB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0_AHB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0_AHB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fffffff)
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0_AHB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_PTR_0_AHB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_8_AHB_SEQ_0  
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0                  _MK_ADDR_CONST(0x114)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20000000)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0xff0f0000)
//  0 = send interrupt to COP
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_INTR_ENB_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_INTR_ENB_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_8_AHB_SEQ_0_INTR_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_INTR_ENB_RANGE                   31:31
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_INTR_ENB_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_INTR_ENB_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_INTR_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_INTR_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_INTR_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_INTR_ENB_CPU                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_INTR_ENB_COP                     _MK_ENUM_CONST(0)

// AHB Bus Width 0 = 8 bit Bus (RSVD) 1 = 16 bit Bus (RSVD) 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD)4 = 128 bit Bus (RSVD)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

// When enabled the data going  to AHB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }.
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

// AHB Burst Size DMA Burst Length (encoded) 4 = 1 Word (1x32bits) 5 = 4 Words (4x32bits)else = 8 Words (8x32bits) default
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BURST_SHIFT                  _MK_SHIFT_CONST(24)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BURST_FIELD                  (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BURST_SHIFT)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BURST_RANGE                  26:24
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BURST_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BURST_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BURST_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BURST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BURST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BURST_DMA_BURST_1WORDS                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BURST_DMA_BURST_4WORDS                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_AHB_BURST_DMA_BURST_8WORDS                       _MK_ENUM_CONST(6)

// 2X Double Buffering Mode (For Run-Multiple Mode with No Wrap Operations) 1 = Reload Base Address for 2X blocks (reload every other time) 0 = Reload Base Address for 1X blocks  (def) (reload each time)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_DBL_BUF_SHIFT                    _MK_SHIFT_CONST(19)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_DBL_BUF_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_8_AHB_SEQ_0_DBL_BUF_SHIFT)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_DBL_BUF_RANGE                    19:19
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_DBL_BUF_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_DBL_BUF_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_DBL_BUF_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_DBL_BUF_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_DBL_BUF_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_1X_BLOCKS                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_2X_BLOCKS                     _MK_ENUM_CONST(1)

// AHB Address Wrap: AHB Address wrap-around window 0=No Wrap (default) 5=Wrap on 512 word window 1=Wrap on 32 word window 6=Wrap on 1024 word window 2=Wrap on 64 word window 7=Wrap on 2048 word window 3=Wrap on 128 word window 4=Wrap on 256 word window
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_FIELD                       (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_RANGE                       18:16
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_NO_WRAP                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_WRAP_0N_32WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_WRAP_ON_64WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_WRAP_ON_128WORDS                    _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_WRAP_ON_256WORDS                    _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_WRAP_ON_512WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_WRAP_ON_1024WORDS                   _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_8_AHB_SEQ_0_WRAP_WRAP_ON_2048WORDS                   _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_8_APB_PTR_0  
#define APBDMACHAN_CHANNEL_8_APB_PTR_0                  _MK_ADDR_CONST(0x118)
#define APBDMACHAN_CHANNEL_8_APB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_8_APB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_8_APB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_APB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_8_APB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_APB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_APB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_8_APB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffc)
// APB-DMA Starting address for APB Bus: APB Base address:Upper 16 bits are fixed at 0x7000:XXXX
#define APBDMACHAN_CHANNEL_8_APB_PTR_0_APB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_8_APB_PTR_0_APB_BASE_FIELD                   (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_8_APB_PTR_0_APB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_8_APB_PTR_0_APB_BASE_RANGE                   15:2
#define APBDMACHAN_CHANNEL_8_APB_PTR_0_APB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_8_APB_PTR_0_APB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_APB_PTR_0_APB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_8_APB_PTR_0_APB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_APB_PTR_0_APB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_8_APB_SEQ_0  
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0                  _MK_ADDR_CONST(0x11c)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20010000)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0x78070000)
// 0 = 8 bit Bus 1 = 16 bit Bus 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD) 4 = 128 bit BUS (RSVD)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

// when enabled the data going  to APB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }.
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

//APB Address Wrap-around Window 0 = No Wrap 1 = Wrap on 1 Word Window (def) 2 = Wrap on 2 Word Window 3 = Wrap on 4 Word Window 4 = Wrap on 8 Word Window 5 = Wrap on 16 Word Window 6 = Wrap on 32 Word Window 7 = Wrap on 64 Word Window (rsvd)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_RANGE                      18:16
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_NO_WRAP                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_WRAP_0N_1WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_2WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_4WORDS                     _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_8WORDS                     _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_16WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_32WORDS                    _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_8_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_64WORDS                    _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_9_CSR_0  
#define APBDMACHAN_CHANNEL_9_CSR_0                      _MK_ADDR_CONST(0x120)
#define APBDMACHAN_CHANNEL_9_CSR_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_9_CSR_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_9_CSR_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_RESET_MASK                   _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_9_CSR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_READ_MASK                    _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_9_CSR_0_WRITE_MASK                   _MK_MASK_CONST(0xfffffffc)
// Enables DMA channel transfer 
#define APBDMACHAN_CHANNEL_9_CSR_0_ENB_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_9_CSR_0_ENB_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_9_CSR_0_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_9_CSR_0_ENB_RANGE                    31:31
#define APBDMACHAN_CHANNEL_9_CSR_0_ENB_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_9_CSR_0_ENB_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_ENB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_9_CSR_0_ENB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_ENB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_ENB_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_CSR_0_ENB_ENABLE                   _MK_ENUM_CONST(1)

// Interrupts when DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_9_CSR_0_IE_EOC_SHIFT                 _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_9_CSR_0_IE_EOC_FIELD                 (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_9_CSR_0_IE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_9_CSR_0_IE_EOC_RANGE                 30:30
#define APBDMACHAN_CHANNEL_9_CSR_0_IE_EOC_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_9_CSR_0_IE_EOC_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_IE_EOC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_9_CSR_0_IE_EOC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_IE_EOC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_IE_EOC_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_CSR_0_IE_EOC_ENABLE                        _MK_ENUM_CONST(1)

// Holds this Processor until DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_9_CSR_0_HOLD_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_9_CSR_0_HOLD_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_9_CSR_0_HOLD_SHIFT)
#define APBDMACHAN_CHANNEL_9_CSR_0_HOLD_RANGE                   29:29
#define APBDMACHAN_CHANNEL_9_CSR_0_HOLD_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_9_CSR_0_HOLD_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_HOLD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_9_CSR_0_HOLD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_HOLD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_HOLD_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_CSR_0_HOLD_ENABLE                  _MK_ENUM_CONST(1)

// DMA Transfer Direction 1 = AHB read to APB write 0 = APB read to AHB write
#define APBDMACHAN_CHANNEL_9_CSR_0_DIR_SHIFT                    _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_9_CSR_0_DIR_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_9_CSR_0_DIR_SHIFT)
#define APBDMACHAN_CHANNEL_9_CSR_0_DIR_RANGE                    28:28
#define APBDMACHAN_CHANNEL_9_CSR_0_DIR_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_9_CSR_0_DIR_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_DIR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_9_CSR_0_DIR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_DIR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_DIR_AHB_WRITE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_CSR_0_DIR_AHB_READ                 _MK_ENUM_CONST(1)

// Run Once or Run Multiple Mode (Allow Retriggering of this Channel) 1 = Run for One Block Transfer 0 = Run for Multiple Block Transfer
#define APBDMACHAN_CHANNEL_9_CSR_0_ONCE_SHIFT                   _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_9_CSR_0_ONCE_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_9_CSR_0_ONCE_SHIFT)
#define APBDMACHAN_CHANNEL_9_CSR_0_ONCE_RANGE                   27:27
#define APBDMACHAN_CHANNEL_9_CSR_0_ONCE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_9_CSR_0_ONCE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_ONCE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_9_CSR_0_ONCE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_ONCE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_ONCE_MULTIPLE_BLOCK                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_CSR_0_ONCE_SINGLE_BLOCK                    _MK_ENUM_CONST(1)

// Enable on Non-Zero Value
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_SHIFT                       _MK_SHIFT_CONST(22)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_FIELD                       (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_RANGE                       26:22
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_NA1                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_SMP24                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_SMP25                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_SMP26                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_SMP27                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_XRQ_A                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_XRQ_B                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_TMR1                        _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_TMR2                        _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_APB_0                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_APB_1                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_APB_2                       _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_APB_3                       _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_APB_4                       _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_APB_5                       _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_APB_6                       _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_APB_7                       _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_APB_8                       _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_APB_9                       _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_APB_10                      _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_APB_11                      _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_APB_12                      _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_APB_13                      _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_APB_14                      _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_9_CSR_0_TRIG_SEL_APB_15                      _MK_ENUM_CONST(24)

// Flow Control Enable (Synchronize Burst Transfers) 1 = Link to DRQ source 0 = Independent of DRQ request
#define APBDMACHAN_CHANNEL_9_CSR_0_FLOW_SHIFT                   _MK_SHIFT_CONST(21)
#define APBDMACHAN_CHANNEL_9_CSR_0_FLOW_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_9_CSR_0_FLOW_SHIFT)
#define APBDMACHAN_CHANNEL_9_CSR_0_FLOW_RANGE                   21:21
#define APBDMACHAN_CHANNEL_9_CSR_0_FLOW_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_9_CSR_0_FLOW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_FLOW_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_9_CSR_0_FLOW_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_FLOW_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_FLOW_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_CSR_0_FLOW_ENABLE                  _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_SHIFT                        _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_FIELD                        (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_RANGE                        20:16
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_CNTR_REQ                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_I2S_2                        _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_I2S_1                        _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_SPD_I                        _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_UI_I                 _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_MIPI                 _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_I2S2_2                       _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_I2S2_1                       _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_UART_A                       _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_UART_B                       _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_UART_C                       _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_SPI                  _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_AC97                 _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_ACModem                      _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_SL4B                 _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_SL2B1                        _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_SL2B2                        _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_SL2B3                        _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_SL2B4                        _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_UART_D                       _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_UART_E                       _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_I2C                  _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_I2C2                 _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_I2C3                 _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_DVC_I2C                      _MK_ENUM_CONST(24)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_OWR                  _MK_ENUM_CONST(25)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_NA26                 _MK_ENUM_CONST(26)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_NA27                 _MK_ENUM_CONST(27)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_NA28                 _MK_ENUM_CONST(28)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_NA29                 _MK_ENUM_CONST(29)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_NA30                 _MK_ENUM_CONST(30)
#define APBDMACHAN_CHANNEL_9_CSR_0_REQ_SEL_NA31                 _MK_ENUM_CONST(31)

// Number of 32bit word cycles
#define APBDMACHAN_CHANNEL_9_CSR_0_WCOUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_9_CSR_0_WCOUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_9_CSR_0_WCOUNT_SHIFT)
#define APBDMACHAN_CHANNEL_9_CSR_0_WCOUNT_RANGE                 15:2
#define APBDMACHAN_CHANNEL_9_CSR_0_WCOUNT_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_9_CSR_0_WCOUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_WCOUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_9_CSR_0_WCOUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_CSR_0_WCOUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_9_STA_0  
#define APBDMACHAN_CHANNEL_9_STA_0                      _MK_ADDR_CONST(0x124)
#define APBDMACHAN_CHANNEL_9_STA_0_SECURE                       0x0
#define APBDMACHAN_CHANNEL_9_STA_0_WORD_COUNT                   0x1
#define APBDMACHAN_CHANNEL_9_STA_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_RESET_MASK                   _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_9_STA_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_READ_MASK                    _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_9_STA_0_WRITE_MASK                   _MK_MASK_CONST(0x40000000)
// indicate DMA Channel Status activate or not
#define APBDMACHAN_CHANNEL_9_STA_0_BSY_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_9_STA_0_BSY_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_9_STA_0_BSY_SHIFT)
#define APBDMACHAN_CHANNEL_9_STA_0_BSY_RANGE                    31:31
#define APBDMACHAN_CHANNEL_9_STA_0_BSY_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_9_STA_0_BSY_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_BSY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_9_STA_0_BSY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_BSY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_BSY_WAIT                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_STA_0_BSY_ACTIVE                   _MK_ENUM_CONST(1)

//  Write '1' to clear the flag
#define APBDMACHAN_CHANNEL_9_STA_0_ISE_EOC_SHIFT                        _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_9_STA_0_ISE_EOC_FIELD                        (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_9_STA_0_ISE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_9_STA_0_ISE_EOC_RANGE                        30:30
#define APBDMACHAN_CHANNEL_9_STA_0_ISE_EOC_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_9_STA_0_ISE_EOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_ISE_EOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_9_STA_0_ISE_EOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_ISE_EOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_ISE_EOC_NO_INTR                      _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_STA_0_ISE_EOC_INTR                 _MK_ENUM_CONST(1)

// Holding Status of Processor 
#define APBDMACHAN_CHANNEL_9_STA_0_HALT_SHIFT                   _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_9_STA_0_HALT_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_9_STA_0_HALT_SHIFT)
#define APBDMACHAN_CHANNEL_9_STA_0_HALT_RANGE                   29:29
#define APBDMACHAN_CHANNEL_9_STA_0_HALT_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_9_STA_0_HALT_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_HALT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_9_STA_0_HALT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_HALT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_HALT_NO_HALT                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_STA_0_HALT_HALT                    _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_9_STA_0_PING_PONG_STA_SHIFT                  _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_9_STA_0_PING_PONG_STA_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_9_STA_0_PING_PONG_STA_SHIFT)
#define APBDMACHAN_CHANNEL_9_STA_0_PING_PONG_STA_RANGE                  28:28
#define APBDMACHAN_CHANNEL_9_STA_0_PING_PONG_STA_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_9_STA_0_PING_PONG_STA_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_PING_PONG_STA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_9_STA_0_PING_PONG_STA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_PING_PONG_STA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_PING_PONG_STA_PING_INTR_STA                  _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_STA_0_PING_PONG_STA_PONG_INTR_STA                  _MK_ENUM_CONST(1)

// Current 32bit word cycles Flags set /cleared by HW
#define APBDMACHAN_CHANNEL_9_STA_0_COUNT_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_9_STA_0_COUNT_FIELD                  (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_9_STA_0_COUNT_SHIFT)
#define APBDMACHAN_CHANNEL_9_STA_0_COUNT_RANGE                  15:2
#define APBDMACHAN_CHANNEL_9_STA_0_COUNT_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_9_STA_0_COUNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_COUNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_9_STA_0_COUNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_STA_0_COUNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 296 [0x128] 

// Reserved address 300 [0x12c] 

// Register APBDMACHAN_CHANNEL_9_AHB_PTR_0  
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0                  _MK_ADDR_CONST(0x130)
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffffffc)
// APB-DMA Starting Address for AHB Bus: SW writes to  modify
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0_AHB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0_AHB_BASE_FIELD                   (_MK_MASK_CONST(0x3fffffff) << APBDMACHAN_CHANNEL_9_AHB_PTR_0_AHB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0_AHB_BASE_RANGE                   31:2
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0_AHB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0_AHB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0_AHB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fffffff)
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0_AHB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_PTR_0_AHB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_9_AHB_SEQ_0  
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0                  _MK_ADDR_CONST(0x134)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20000000)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0xff0f0000)
//  0 = send interrupt to COP
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_INTR_ENB_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_INTR_ENB_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_9_AHB_SEQ_0_INTR_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_INTR_ENB_RANGE                   31:31
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_INTR_ENB_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_INTR_ENB_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_INTR_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_INTR_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_INTR_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_INTR_ENB_CPU                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_INTR_ENB_COP                     _MK_ENUM_CONST(0)

// AHB Bus Width 0 = 8 bit Bus (RSVD) 1 = 16 bit Bus (RSVD) 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD)4 = 128 bit Bus (RSVD)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

//When enabled the data going to AHB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_DATA_SWAP_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

// AHB Burst Size DMA Burst Length (encoded) 4 = 1 Word (1x32bits) 5 = 4 Words (4x32bits)else = 8 Words (8x32bits) default
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BURST_SHIFT                  _MK_SHIFT_CONST(24)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BURST_FIELD                  (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BURST_SHIFT)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BURST_RANGE                  26:24
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BURST_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BURST_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BURST_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BURST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BURST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BURST_DMA_BURST_1WORDS                       _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BURST_DMA_BURST_4WORDS                       _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_AHB_BURST_DMA_BURST_8WORDS                       _MK_ENUM_CONST(6)

// 2X Double Buffering Mode (For Run-Multiple Mode with No Wrap Operations) 1 = Reload Base Address for 2X blocks (reload every other time) 0 = Reload Base Address for 1X blocks  (def) (reload each time)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_DBL_BUF_SHIFT                    _MK_SHIFT_CONST(19)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_DBL_BUF_FIELD                    (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_9_AHB_SEQ_0_DBL_BUF_SHIFT)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_DBL_BUF_RANGE                    19:19
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_DBL_BUF_WOFFSET                  0x0
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_DBL_BUF_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_DBL_BUF_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_DBL_BUF_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_DBL_BUF_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_1X_BLOCKS                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_2X_BLOCKS                     _MK_ENUM_CONST(1)

// AHB Address Wrap: AHB Address wrap-around window 0=No Wrap (default) 5=Wrap on 512 word window 1=Wrap on 32 word window 6=Wrap on 1024 word window 2=Wrap on 64 word window 7=Wrap on 2048 word window 3=Wrap on 128 word window 4=Wrap on 256 word window
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_FIELD                       (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_RANGE                       18:16
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_NO_WRAP                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_WRAP_0N_32WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_WRAP_ON_64WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_WRAP_ON_128WORDS                    _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_WRAP_ON_256WORDS                    _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_WRAP_ON_512WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_WRAP_ON_1024WORDS                   _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_9_AHB_SEQ_0_WRAP_WRAP_ON_2048WORDS                   _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_9_APB_PTR_0  
#define APBDMACHAN_CHANNEL_9_APB_PTR_0                  _MK_ADDR_CONST(0x138)
#define APBDMACHAN_CHANNEL_9_APB_PTR_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_9_APB_PTR_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_9_APB_PTR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_APB_PTR_0_RESET_MASK                       _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_9_APB_PTR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_APB_PTR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_APB_PTR_0_READ_MASK                        _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_9_APB_PTR_0_WRITE_MASK                       _MK_MASK_CONST(0xfffc)
//APB-DMA Starting address for APB Bus: APB Base address: Upper 16 bits are fixed at 0x7000:XXXX
#define APBDMACHAN_CHANNEL_9_APB_PTR_0_APB_BASE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_9_APB_PTR_0_APB_BASE_FIELD                   (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_9_APB_PTR_0_APB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_9_APB_PTR_0_APB_BASE_RANGE                   15:2
#define APBDMACHAN_CHANNEL_9_APB_PTR_0_APB_BASE_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_9_APB_PTR_0_APB_BASE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_APB_PTR_0_APB_BASE_DEFAULT_MASK                    _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_9_APB_PTR_0_APB_BASE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_APB_PTR_0_APB_BASE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_9_APB_SEQ_0  
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0                  _MK_ADDR_CONST(0x13c)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_SECURE                   0x0
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_WORD_COUNT                       0x1
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_RESET_VAL                        _MK_MASK_CONST(0x20010000)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_RESET_MASK                       _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_READ_MASK                        _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_WRITE_MASK                       _MK_MASK_CONST(0x78070000)
// 0 = 8 bit Bus 1 = 16 bit Bus 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD) 4 = 128 bit BUS (RSVD)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_BUS_WIDTH_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_BUS_WIDTH_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_BUS_WIDTH_RANGE                      30:28
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_BUS_WIDTH_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_8                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_16                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_32                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_64                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_128                      _MK_ENUM_CONST(4)

// When enabled the data going  to APB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_DATA_SWAP_SHIFT                      _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_DATA_SWAP_FIELD                      (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_DATA_SWAP_RANGE                      27:27
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_DATA_SWAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_DATA_SWAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_DATA_SWAP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_DATA_SWAP_DISBALE                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_DATA_SWAP_ENABLE                     _MK_ENUM_CONST(1)

//APB Address Wrap-around Window 0 = No Wrap 1 = Wrap on 1 Word Window (def) 2 = Wrap on 2 Word Window 3 = Wrap on 4 Word Window 4 = Wrap on 8 Word Window 5 = Wrap on 16 Word Window 6 = Wrap on 32 Word Window 7 = Wrap on 64 Word Window (rsvd)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_RANGE                      18:16
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_NO_WRAP                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_WRAP_0N_1WORDS                     _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_2WORDS                     _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_4WORDS                     _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_8WORDS                     _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_16WORDS                    _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_32WORDS                    _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_9_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_64WORDS                    _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_10_CSR_0  
#define APBDMACHAN_CHANNEL_10_CSR_0                     _MK_ADDR_CONST(0x140)
#define APBDMACHAN_CHANNEL_10_CSR_0_SECURE                      0x0
#define APBDMACHAN_CHANNEL_10_CSR_0_WORD_COUNT                  0x1
#define APBDMACHAN_CHANNEL_10_CSR_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_RESET_MASK                  _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_10_CSR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_READ_MASK                   _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_10_CSR_0_WRITE_MASK                  _MK_MASK_CONST(0xfffffffc)
// Enables DMA channel transfer 
#define APBDMACHAN_CHANNEL_10_CSR_0_ENB_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_10_CSR_0_ENB_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_10_CSR_0_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_10_CSR_0_ENB_RANGE                   31:31
#define APBDMACHAN_CHANNEL_10_CSR_0_ENB_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_10_CSR_0_ENB_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_10_CSR_0_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_ENB_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_CSR_0_ENB_ENABLE                  _MK_ENUM_CONST(1)

// Interrupts when DMA Block Transfer Completes
#define APBDMACHAN_CHANNEL_10_CSR_0_IE_EOC_SHIFT                        _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_10_CSR_0_IE_EOC_FIELD                        (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_10_CSR_0_IE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_10_CSR_0_IE_EOC_RANGE                        30:30
#define APBDMACHAN_CHANNEL_10_CSR_0_IE_EOC_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_10_CSR_0_IE_EOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_IE_EOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_10_CSR_0_IE_EOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_IE_EOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_IE_EOC_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_CSR_0_IE_EOC_ENABLE                       _MK_ENUM_CONST(1)

// Holds this Processor until DMA Block Transfer Completes
#define APBDMACHAN_CHANNEL_10_CSR_0_HOLD_SHIFT                  _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_10_CSR_0_HOLD_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_10_CSR_0_HOLD_SHIFT)
#define APBDMACHAN_CHANNEL_10_CSR_0_HOLD_RANGE                  29:29
#define APBDMACHAN_CHANNEL_10_CSR_0_HOLD_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_10_CSR_0_HOLD_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_HOLD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_10_CSR_0_HOLD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_HOLD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_HOLD_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_CSR_0_HOLD_ENABLE                 _MK_ENUM_CONST(1)

// DMA Transfer Direction 1 = AHB read to APB write 0 = APB read to AHB write
#define APBDMACHAN_CHANNEL_10_CSR_0_DIR_SHIFT                   _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_10_CSR_0_DIR_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_10_CSR_0_DIR_SHIFT)
#define APBDMACHAN_CHANNEL_10_CSR_0_DIR_RANGE                   28:28
#define APBDMACHAN_CHANNEL_10_CSR_0_DIR_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_10_CSR_0_DIR_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_DIR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_10_CSR_0_DIR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_DIR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_DIR_AHB_WRITE                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_CSR_0_DIR_AHB_READ                        _MK_ENUM_CONST(1)

// Run Once or Run Multiple Mode (Allow Retriggering of this Channel) 1 = Run for One Block Transfer 0 = Run for Multiple Block Transfer
#define APBDMACHAN_CHANNEL_10_CSR_0_ONCE_SHIFT                  _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_10_CSR_0_ONCE_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_10_CSR_0_ONCE_SHIFT)
#define APBDMACHAN_CHANNEL_10_CSR_0_ONCE_RANGE                  27:27
#define APBDMACHAN_CHANNEL_10_CSR_0_ONCE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_10_CSR_0_ONCE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_ONCE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_10_CSR_0_ONCE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_ONCE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_ONCE_MULTIPLE_BLOCK                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_CSR_0_ONCE_SINGLE_BLOCK                   _MK_ENUM_CONST(1)

// Enable on Non-Zero Value
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_SHIFT                      _MK_SHIFT_CONST(22)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_FIELD                      (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_RANGE                      26:22
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_NA1                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_SMP24                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_SMP25                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_SMP26                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_SMP27                      _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_XRQ_A                      _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_XRQ_B                      _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_TMR1                       _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_TMR2                       _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_APB_0                      _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_APB_1                      _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_APB_2                      _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_APB_3                      _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_APB_4                      _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_APB_5                      _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_APB_6                      _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_APB_7                      _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_APB_8                      _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_APB_9                      _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_APB_10                     _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_APB_11                     _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_APB_12                     _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_APB_13                     _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_APB_14                     _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_10_CSR_0_TRIG_SEL_APB_15                     _MK_ENUM_CONST(24)

// Flow Control Enable (Synchronize Burst Transfers) 1 = Link to DRQ source 0 = Independent of DRQ request
#define APBDMACHAN_CHANNEL_10_CSR_0_FLOW_SHIFT                  _MK_SHIFT_CONST(21)
#define APBDMACHAN_CHANNEL_10_CSR_0_FLOW_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_10_CSR_0_FLOW_SHIFT)
#define APBDMACHAN_CHANNEL_10_CSR_0_FLOW_RANGE                  21:21
#define APBDMACHAN_CHANNEL_10_CSR_0_FLOW_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_10_CSR_0_FLOW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_FLOW_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_10_CSR_0_FLOW_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_FLOW_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_FLOW_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_CSR_0_FLOW_ENABLE                 _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_FIELD                       (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_RANGE                       20:16
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_CNTR_REQ                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_I2S_2                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_I2S_1                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_SPD_I                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_UI_I                        _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_MIPI                        _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_I2S2_2                      _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_I2S2_1                      _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_UART_A                      _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_UART_B                      _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_UART_C                      _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_SPI                 _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_AC97                        _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_ACModem                     _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_SL4B                        _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_SL2B1                       _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_SL2B2                       _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_SL2B3                       _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_SL2B4                       _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_UART_D                      _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_UART_E                      _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_I2C                 _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_I2C2                        _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_I2C3                        _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_DVC_I2C                     _MK_ENUM_CONST(24)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_OWR                 _MK_ENUM_CONST(25)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_NA26                        _MK_ENUM_CONST(26)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_NA27                        _MK_ENUM_CONST(27)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_NA28                        _MK_ENUM_CONST(28)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_NA29                        _MK_ENUM_CONST(29)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_NA30                        _MK_ENUM_CONST(30)
#define APBDMACHAN_CHANNEL_10_CSR_0_REQ_SEL_NA31                        _MK_ENUM_CONST(31)

// Number of 32bit word cycles
#define APBDMACHAN_CHANNEL_10_CSR_0_WCOUNT_SHIFT                        _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_10_CSR_0_WCOUNT_FIELD                        (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_10_CSR_0_WCOUNT_SHIFT)
#define APBDMACHAN_CHANNEL_10_CSR_0_WCOUNT_RANGE                        15:2
#define APBDMACHAN_CHANNEL_10_CSR_0_WCOUNT_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_10_CSR_0_WCOUNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_WCOUNT_DEFAULT_MASK                 _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_10_CSR_0_WCOUNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_CSR_0_WCOUNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_10_STA_0  
#define APBDMACHAN_CHANNEL_10_STA_0                     _MK_ADDR_CONST(0x144)
#define APBDMACHAN_CHANNEL_10_STA_0_SECURE                      0x0
#define APBDMACHAN_CHANNEL_10_STA_0_WORD_COUNT                  0x1
#define APBDMACHAN_CHANNEL_10_STA_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_RESET_MASK                  _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_10_STA_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_READ_MASK                   _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_10_STA_0_WRITE_MASK                  _MK_MASK_CONST(0x40000000)
// indicate DMA Channel Status activated or not 
#define APBDMACHAN_CHANNEL_10_STA_0_BSY_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_10_STA_0_BSY_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_10_STA_0_BSY_SHIFT)
#define APBDMACHAN_CHANNEL_10_STA_0_BSY_RANGE                   31:31
#define APBDMACHAN_CHANNEL_10_STA_0_BSY_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_10_STA_0_BSY_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_BSY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_10_STA_0_BSY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_BSY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_BSY_WAIT                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_STA_0_BSY_ACTIVE                  _MK_ENUM_CONST(1)

// Write '1' to clear the flag
#define APBDMACHAN_CHANNEL_10_STA_0_ISE_EOC_SHIFT                       _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_10_STA_0_ISE_EOC_FIELD                       (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_10_STA_0_ISE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_10_STA_0_ISE_EOC_RANGE                       30:30
#define APBDMACHAN_CHANNEL_10_STA_0_ISE_EOC_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_10_STA_0_ISE_EOC_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_ISE_EOC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_10_STA_0_ISE_EOC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_ISE_EOC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_ISE_EOC_NO_INTR                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_STA_0_ISE_EOC_INTR                        _MK_ENUM_CONST(1)

// Holding Status of Processor 
#define APBDMACHAN_CHANNEL_10_STA_0_HALT_SHIFT                  _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_10_STA_0_HALT_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_10_STA_0_HALT_SHIFT)
#define APBDMACHAN_CHANNEL_10_STA_0_HALT_RANGE                  29:29
#define APBDMACHAN_CHANNEL_10_STA_0_HALT_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_10_STA_0_HALT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_HALT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_10_STA_0_HALT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_HALT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_HALT_NO_HALT                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_STA_0_HALT_HALT                   _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_10_STA_0_PING_PONG_STA_SHIFT                 _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_10_STA_0_PING_PONG_STA_FIELD                 (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_10_STA_0_PING_PONG_STA_SHIFT)
#define APBDMACHAN_CHANNEL_10_STA_0_PING_PONG_STA_RANGE                 28:28
#define APBDMACHAN_CHANNEL_10_STA_0_PING_PONG_STA_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_10_STA_0_PING_PONG_STA_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_PING_PONG_STA_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_10_STA_0_PING_PONG_STA_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_PING_PONG_STA_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_PING_PONG_STA_PING_INTR_STA                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_STA_0_PING_PONG_STA_PONG_INTR_STA                 _MK_ENUM_CONST(1)

// Current 32bit word cycles Flags set /cleared by HW
#define APBDMACHAN_CHANNEL_10_STA_0_COUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_10_STA_0_COUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_10_STA_0_COUNT_SHIFT)
#define APBDMACHAN_CHANNEL_10_STA_0_COUNT_RANGE                 15:2
#define APBDMACHAN_CHANNEL_10_STA_0_COUNT_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_10_STA_0_COUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_COUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_10_STA_0_COUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_STA_0_COUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 328 [0x148] 

// Reserved address 332 [0x14c] 

// Register APBDMACHAN_CHANNEL_10_AHB_PTR_0  
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0                 _MK_ADDR_CONST(0x150)
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0_RESET_MASK                      _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0_READ_MASK                       _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0_WRITE_MASK                      _MK_MASK_CONST(0xfffffffc)
// APB-DMA Starting Address for AHB Bus: SW writes to  modify
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0_AHB_BASE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0_AHB_BASE_FIELD                  (_MK_MASK_CONST(0x3fffffff) << APBDMACHAN_CHANNEL_10_AHB_PTR_0_AHB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0_AHB_BASE_RANGE                  31:2
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0_AHB_BASE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0_AHB_BASE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0_AHB_BASE_DEFAULT_MASK                   _MK_MASK_CONST(0x3fffffff)
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0_AHB_BASE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_PTR_0_AHB_BASE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_10_AHB_SEQ_0  
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0                 _MK_ADDR_CONST(0x154)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_RESET_VAL                       _MK_MASK_CONST(0x20000000)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_RESET_MASK                      _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_READ_MASK                       _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRITE_MASK                      _MK_MASK_CONST(0xff0f0000)
//  0 = send interrupt to COP
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_INTR_ENB_SHIFT                  _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_INTR_ENB_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_10_AHB_SEQ_0_INTR_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_INTR_ENB_RANGE                  31:31
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_INTR_ENB_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_INTR_ENB_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_INTR_ENB_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_INTR_ENB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_INTR_ENB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_INTR_ENB_CPU                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_INTR_ENB_COP                    _MK_ENUM_CONST(0)

// AHB Bus Width 0 = 8 bit Bus (RSVD) 1 = 16 bit Bus (RSVD) 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD)4 = 128 bit Bus (RSVD)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT                     _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BUS_WIDTH_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BUS_WIDTH_RANGE                     30:28
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BUS_WIDTH_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT                   _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_8                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_16                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_32                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_64                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_128                     _MK_ENUM_CONST(4)

// when enabled the data going  to AHB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT                     _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_DATA_SWAP_FIELD                     (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_DATA_SWAP_RANGE                     27:27
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_DATA_SWAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_DATA_SWAP_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_DATA_SWAP_ENABLE                    _MK_ENUM_CONST(1)

// AHB Burst Size DMA Burst Length (encoded) 4 = 1 Word (1x32bits) 5 = 4 Words (4x32bits)else = 8 Words (8x32bits) default
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BURST_SHIFT                 _MK_SHIFT_CONST(24)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BURST_FIELD                 (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BURST_SHIFT)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BURST_RANGE                 26:24
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BURST_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BURST_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BURST_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BURST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BURST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BURST_DMA_BURST_1WORDS                      _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BURST_DMA_BURST_4WORDS                      _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_AHB_BURST_DMA_BURST_8WORDS                      _MK_ENUM_CONST(6)

// 2X Double Buffering Mode (For Run-Multiple Mode with No Wrap Operations) 1 = Reload Base Address for 2X blocks (reload every other time) 0 = Reload Base Address for 1X blocks  (def) (reload each time)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_DBL_BUF_SHIFT                   _MK_SHIFT_CONST(19)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_DBL_BUF_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_10_AHB_SEQ_0_DBL_BUF_SHIFT)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_DBL_BUF_RANGE                   19:19
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_DBL_BUF_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_DBL_BUF_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_DBL_BUF_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_DBL_BUF_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_DBL_BUF_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_1X_BLOCKS                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_2X_BLOCKS                    _MK_ENUM_CONST(1)

// AHB Address Wrap: AHB Address wrap-around window 0=No Wrap (default) 5=Wrap on 512 word window 1=Wrap on 32 word window 6=Wrap on 1024 word window 2=Wrap on 64 word window 7=Wrap on 2048 word window 3=Wrap on 128 word window 4=Wrap on 256 word window
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_RANGE                      18:16
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_NO_WRAP                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_WRAP_0N_32WORDS                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_WRAP_ON_64WORDS                    _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_WRAP_ON_128WORDS                   _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_WRAP_ON_256WORDS                   _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_WRAP_ON_512WORDS                   _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_WRAP_ON_1024WORDS                  _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_10_AHB_SEQ_0_WRAP_WRAP_ON_2048WORDS                  _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_10_APB_PTR_0  
#define APBDMACHAN_CHANNEL_10_APB_PTR_0                 _MK_ADDR_CONST(0x158)
#define APBDMACHAN_CHANNEL_10_APB_PTR_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_10_APB_PTR_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_10_APB_PTR_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_APB_PTR_0_RESET_MASK                      _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_10_APB_PTR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_APB_PTR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_APB_PTR_0_READ_MASK                       _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_10_APB_PTR_0_WRITE_MASK                      _MK_MASK_CONST(0xfffc)
// APB-DMA Starting address for APB Bus: APB Base  address: Upper 16 bits are fixed at 0x7000:XXXX
#define APBDMACHAN_CHANNEL_10_APB_PTR_0_APB_BASE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_10_APB_PTR_0_APB_BASE_FIELD                  (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_10_APB_PTR_0_APB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_10_APB_PTR_0_APB_BASE_RANGE                  15:2
#define APBDMACHAN_CHANNEL_10_APB_PTR_0_APB_BASE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_10_APB_PTR_0_APB_BASE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_APB_PTR_0_APB_BASE_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_10_APB_PTR_0_APB_BASE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_APB_PTR_0_APB_BASE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_10_APB_SEQ_0  
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0                 _MK_ADDR_CONST(0x15c)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_RESET_VAL                       _MK_MASK_CONST(0x20010000)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_RESET_MASK                      _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_READ_MASK                       _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_WRITE_MASK                      _MK_MASK_CONST(0x78070000)
// 0 = 8 bit Bus 1 = 16 bit Bus 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD) 4 = 128 bit BUS (RSVD)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_BUS_WIDTH_SHIFT                     _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_BUS_WIDTH_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_BUS_WIDTH_RANGE                     30:28
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_BUS_WIDTH_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT                   _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_8                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_16                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_32                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_64                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_128                     _MK_ENUM_CONST(4)

// when enabled the data going  to APB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_DATA_SWAP_SHIFT                     _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_DATA_SWAP_FIELD                     (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_DATA_SWAP_RANGE                     27:27
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_DATA_SWAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_DATA_SWAP_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_DATA_SWAP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_DATA_SWAP_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_DATA_SWAP_ENABLE                    _MK_ENUM_CONST(1)

//APB Address Wrap-around Window 0 = No Wrap 1 = Wrap on 1 Word Window (def) 2 = Wrap on 2 Word Window 3 = Wrap on 4 Word Window 4 = Wrap on 8 Word Window 5 = Wrap on 16 Word Window 6 = Wrap on 32 Word Window 7 = Wrap on 64 Word Window (rsvd)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_SHIFT                     _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_RANGE                     18:16
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_NO_WRAP                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_WRAP_0N_1WORDS                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_2WORDS                    _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_4WORDS                    _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_8WORDS                    _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_16WORDS                   _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_32WORDS                   _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_10_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_64WORDS                   _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_11_CSR_0  
#define APBDMACHAN_CHANNEL_11_CSR_0                     _MK_ADDR_CONST(0x160)
#define APBDMACHAN_CHANNEL_11_CSR_0_SECURE                      0x0
#define APBDMACHAN_CHANNEL_11_CSR_0_WORD_COUNT                  0x1
#define APBDMACHAN_CHANNEL_11_CSR_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_RESET_MASK                  _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_11_CSR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_READ_MASK                   _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_11_CSR_0_WRITE_MASK                  _MK_MASK_CONST(0xfffffffc)
// Enables DMA channel transfer 
#define APBDMACHAN_CHANNEL_11_CSR_0_ENB_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_11_CSR_0_ENB_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_11_CSR_0_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_11_CSR_0_ENB_RANGE                   31:31
#define APBDMACHAN_CHANNEL_11_CSR_0_ENB_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_11_CSR_0_ENB_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_11_CSR_0_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_ENB_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_CSR_0_ENB_ENABLE                  _MK_ENUM_CONST(1)

// Interrupts when DMA Block Transfer Completes
#define APBDMACHAN_CHANNEL_11_CSR_0_IE_EOC_SHIFT                        _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_11_CSR_0_IE_EOC_FIELD                        (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_11_CSR_0_IE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_11_CSR_0_IE_EOC_RANGE                        30:30
#define APBDMACHAN_CHANNEL_11_CSR_0_IE_EOC_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_11_CSR_0_IE_EOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_IE_EOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_11_CSR_0_IE_EOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_IE_EOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_IE_EOC_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_CSR_0_IE_EOC_ENABLE                       _MK_ENUM_CONST(1)

// Holds this Processor until DMA Block Transfer Completes
#define APBDMACHAN_CHANNEL_11_CSR_0_HOLD_SHIFT                  _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_11_CSR_0_HOLD_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_11_CSR_0_HOLD_SHIFT)
#define APBDMACHAN_CHANNEL_11_CSR_0_HOLD_RANGE                  29:29
#define APBDMACHAN_CHANNEL_11_CSR_0_HOLD_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_11_CSR_0_HOLD_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_HOLD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_11_CSR_0_HOLD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_HOLD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_HOLD_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_CSR_0_HOLD_ENABLE                 _MK_ENUM_CONST(1)

// DMA Transfer Direction 1 = AHB read to APB write 0 = APB read to AHB write
#define APBDMACHAN_CHANNEL_11_CSR_0_DIR_SHIFT                   _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_11_CSR_0_DIR_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_11_CSR_0_DIR_SHIFT)
#define APBDMACHAN_CHANNEL_11_CSR_0_DIR_RANGE                   28:28
#define APBDMACHAN_CHANNEL_11_CSR_0_DIR_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_11_CSR_0_DIR_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_DIR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_11_CSR_0_DIR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_DIR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_DIR_AHB_WRITE                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_CSR_0_DIR_AHB_READ                        _MK_ENUM_CONST(1)

// Run Once or Run Multiple Mode (Allow Retriggering of this Channel) 1 = Run for One Block Transfer 0 = Run for Multiple Block Transfer
#define APBDMACHAN_CHANNEL_11_CSR_0_ONCE_SHIFT                  _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_11_CSR_0_ONCE_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_11_CSR_0_ONCE_SHIFT)
#define APBDMACHAN_CHANNEL_11_CSR_0_ONCE_RANGE                  27:27
#define APBDMACHAN_CHANNEL_11_CSR_0_ONCE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_11_CSR_0_ONCE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_ONCE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_11_CSR_0_ONCE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_ONCE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_ONCE_MULTIPLE_BLOCK                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_CSR_0_ONCE_SINGLE_BLOCK                   _MK_ENUM_CONST(1)

// Enable on Non-Zero Value
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_SHIFT                      _MK_SHIFT_CONST(22)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_FIELD                      (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_RANGE                      26:22
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_NA1                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_SMP24                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_SMP25                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_SMP26                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_SMP27                      _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_XRQ_A                      _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_XRQ_B                      _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_TMR1                       _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_TMR2                       _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_APB_0                      _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_APB_1                      _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_APB_2                      _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_APB_3                      _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_APB_4                      _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_APB_5                      _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_APB_6                      _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_APB_7                      _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_APB_8                      _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_APB_9                      _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_APB_10                     _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_APB_11                     _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_APB_12                     _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_APB_13                     _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_APB_14                     _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_11_CSR_0_TRIG_SEL_APB_15                     _MK_ENUM_CONST(24)

// Flow Control Enable (Synchronize Burst Transfers) 1 = Link to DRQ source 0 = Independent of DRQ request
#define APBDMACHAN_CHANNEL_11_CSR_0_FLOW_SHIFT                  _MK_SHIFT_CONST(21)
#define APBDMACHAN_CHANNEL_11_CSR_0_FLOW_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_11_CSR_0_FLOW_SHIFT)
#define APBDMACHAN_CHANNEL_11_CSR_0_FLOW_RANGE                  21:21
#define APBDMACHAN_CHANNEL_11_CSR_0_FLOW_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_11_CSR_0_FLOW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_FLOW_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_11_CSR_0_FLOW_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_FLOW_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_FLOW_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_CSR_0_FLOW_ENABLE                 _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_FIELD                       (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_RANGE                       20:16
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_CNTR_REQ                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_I2S_2                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_I2S_1                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_SPD_I                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_UI_I                        _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_MIPI                        _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_I2S2_2                      _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_I2S2_1                      _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_UART_A                      _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_UART_B                      _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_UART_C                      _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_SPI                 _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_AC97                        _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_ACModem                     _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_SL4B                        _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_SL2B1                       _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_SL2B2                       _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_SL2B3                       _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_SL2B4                       _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_UART_D                      _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_UART_E                      _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_I2C                 _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_I2C2                        _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_I2C3                        _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_DVC_I2C                     _MK_ENUM_CONST(24)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_OWR                 _MK_ENUM_CONST(25)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_NA26                        _MK_ENUM_CONST(26)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_NA27                        _MK_ENUM_CONST(27)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_NA28                        _MK_ENUM_CONST(28)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_NA29                        _MK_ENUM_CONST(29)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_NA30                        _MK_ENUM_CONST(30)
#define APBDMACHAN_CHANNEL_11_CSR_0_REQ_SEL_NA31                        _MK_ENUM_CONST(31)

// Number of 32bit word cycles
#define APBDMACHAN_CHANNEL_11_CSR_0_WCOUNT_SHIFT                        _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_11_CSR_0_WCOUNT_FIELD                        (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_11_CSR_0_WCOUNT_SHIFT)
#define APBDMACHAN_CHANNEL_11_CSR_0_WCOUNT_RANGE                        15:2
#define APBDMACHAN_CHANNEL_11_CSR_0_WCOUNT_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_11_CSR_0_WCOUNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_WCOUNT_DEFAULT_MASK                 _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_11_CSR_0_WCOUNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_CSR_0_WCOUNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_11_STA_0  
#define APBDMACHAN_CHANNEL_11_STA_0                     _MK_ADDR_CONST(0x164)
#define APBDMACHAN_CHANNEL_11_STA_0_SECURE                      0x0
#define APBDMACHAN_CHANNEL_11_STA_0_WORD_COUNT                  0x1
#define APBDMACHAN_CHANNEL_11_STA_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_RESET_MASK                  _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_11_STA_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_READ_MASK                   _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_11_STA_0_WRITE_MASK                  _MK_MASK_CONST(0x40000000)
// indicate DMA Channel Status activated or waiting
#define APBDMACHAN_CHANNEL_11_STA_0_BSY_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_11_STA_0_BSY_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_11_STA_0_BSY_SHIFT)
#define APBDMACHAN_CHANNEL_11_STA_0_BSY_RANGE                   31:31
#define APBDMACHAN_CHANNEL_11_STA_0_BSY_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_11_STA_0_BSY_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_BSY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_11_STA_0_BSY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_BSY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_BSY_WAIT                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_STA_0_BSY_ACTIVE                  _MK_ENUM_CONST(1)

//  Write '1' to clear the flag
#define APBDMACHAN_CHANNEL_11_STA_0_ISE_EOC_SHIFT                       _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_11_STA_0_ISE_EOC_FIELD                       (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_11_STA_0_ISE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_11_STA_0_ISE_EOC_RANGE                       30:30
#define APBDMACHAN_CHANNEL_11_STA_0_ISE_EOC_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_11_STA_0_ISE_EOC_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_ISE_EOC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_11_STA_0_ISE_EOC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_ISE_EOC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_ISE_EOC_NO_INTR                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_STA_0_ISE_EOC_INTR                        _MK_ENUM_CONST(1)

// Holding Status of Processor 
#define APBDMACHAN_CHANNEL_11_STA_0_HALT_SHIFT                  _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_11_STA_0_HALT_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_11_STA_0_HALT_SHIFT)
#define APBDMACHAN_CHANNEL_11_STA_0_HALT_RANGE                  29:29
#define APBDMACHAN_CHANNEL_11_STA_0_HALT_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_11_STA_0_HALT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_HALT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_11_STA_0_HALT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_HALT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_HALT_NO_HALT                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_STA_0_HALT_HALT                   _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_11_STA_0_PING_PONG_STA_SHIFT                 _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_11_STA_0_PING_PONG_STA_FIELD                 (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_11_STA_0_PING_PONG_STA_SHIFT)
#define APBDMACHAN_CHANNEL_11_STA_0_PING_PONG_STA_RANGE                 28:28
#define APBDMACHAN_CHANNEL_11_STA_0_PING_PONG_STA_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_11_STA_0_PING_PONG_STA_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_PING_PONG_STA_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_11_STA_0_PING_PONG_STA_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_PING_PONG_STA_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_PING_PONG_STA_PING_INTR_STA                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_STA_0_PING_PONG_STA_PONG_INTR_STA                 _MK_ENUM_CONST(1)

// Current 32bit word cycles Flags set /cleared by HW
#define APBDMACHAN_CHANNEL_11_STA_0_COUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_11_STA_0_COUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_11_STA_0_COUNT_SHIFT)
#define APBDMACHAN_CHANNEL_11_STA_0_COUNT_RANGE                 15:2
#define APBDMACHAN_CHANNEL_11_STA_0_COUNT_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_11_STA_0_COUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_COUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_11_STA_0_COUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_STA_0_COUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 360 [0x168] 

// Reserved address 364 [0x16c] 

// Register APBDMACHAN_CHANNEL_11_AHB_PTR_0  
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0                 _MK_ADDR_CONST(0x170)
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0_RESET_MASK                      _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0_READ_MASK                       _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0_WRITE_MASK                      _MK_MASK_CONST(0xfffffffc)
// APB-DMA Starting Address for AHB Bus: SW writes to  modify
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0_AHB_BASE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0_AHB_BASE_FIELD                  (_MK_MASK_CONST(0x3fffffff) << APBDMACHAN_CHANNEL_11_AHB_PTR_0_AHB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0_AHB_BASE_RANGE                  31:2
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0_AHB_BASE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0_AHB_BASE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0_AHB_BASE_DEFAULT_MASK                   _MK_MASK_CONST(0x3fffffff)
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0_AHB_BASE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_PTR_0_AHB_BASE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_11_AHB_SEQ_0  
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0                 _MK_ADDR_CONST(0x174)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_RESET_VAL                       _MK_MASK_CONST(0x20000000)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_RESET_MASK                      _MK_MASK_CONST(0xff070000)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_READ_MASK                       _MK_MASK_CONST(0xff070000)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRITE_MASK                      _MK_MASK_CONST(0xff070000)
//  0 = send interrupt to COP
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_INTR_ENB_SHIFT                  _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_INTR_ENB_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_11_AHB_SEQ_0_INTR_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_INTR_ENB_RANGE                  31:31
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_INTR_ENB_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_INTR_ENB_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_INTR_ENB_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_INTR_ENB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_INTR_ENB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_INTR_ENB_CPU                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_INTR_ENB_COP                    _MK_ENUM_CONST(0)

// AHB Bus Width 0 = 8 bit Bus (RSVD) 1 = 16 bit Bus (RSVD) 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD)4 = 128 bit Bus (RSVD)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT                     _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BUS_WIDTH_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BUS_WIDTH_RANGE                     30:28
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BUS_WIDTH_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT                   _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_8                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_16                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_32                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_64                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_128                     _MK_ENUM_CONST(4)

// when enabled the data going  to AHB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT                     _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_DATA_SWAP_FIELD                     (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_DATA_SWAP_RANGE                     27:27
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_DATA_SWAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_DATA_SWAP_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_DATA_SWAP_ENABLE                    _MK_ENUM_CONST(1)

// AHB Burst Size DMA Burst Length (encoded) 4 = 1 Word (1x32bits) 5 = 4 Words (4x32bits)else = 8 Words (8x32bits) default
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BURST_SHIFT                 _MK_SHIFT_CONST(24)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BURST_FIELD                 (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BURST_SHIFT)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BURST_RANGE                 26:24
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BURST_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BURST_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BURST_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BURST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BURST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BURST_DMA_BURST_1WORDS                      _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BURST_DMA_BURST_4WORDS                      _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_AHB_BURST_DMA_BURST_8WORDS                      _MK_ENUM_CONST(6)

// AHB Address Wrap: AHB Address wrap-around window 0=No Wrap (default) 5=Wrap on 512 word window 1=Wrap on 32 word window 6=Wrap on 1024 word window 2=Wrap on 64 word window 7=Wrap on 2048 word window 3=Wrap on 128 word window 4=Wrap on 256 word window
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_RANGE                      18:16
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_NO_WRAP                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_WRAP_0N_32WORDS                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_WRAP_ON_64WORDS                    _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_WRAP_ON_128WORDS                   _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_WRAP_ON_256WORDS                   _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_WRAP_ON_512WORDS                   _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_WRAP_ON_1024WORDS                  _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_11_AHB_SEQ_0_WRAP_WRAP_ON_2048WORDS                  _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_11_APB_PTR_0  
#define APBDMACHAN_CHANNEL_11_APB_PTR_0                 _MK_ADDR_CONST(0x178)
#define APBDMACHAN_CHANNEL_11_APB_PTR_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_11_APB_PTR_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_11_APB_PTR_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_APB_PTR_0_RESET_MASK                      _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_11_APB_PTR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_APB_PTR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_APB_PTR_0_READ_MASK                       _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_11_APB_PTR_0_WRITE_MASK                      _MK_MASK_CONST(0xfffc)
// APB-DMA Starting address for APB Bus: APB Base  address: Upper 16 bits are fixed at 0x7000:XXXX
#define APBDMACHAN_CHANNEL_11_APB_PTR_0_APB_BASE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_11_APB_PTR_0_APB_BASE_FIELD                  (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_11_APB_PTR_0_APB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_11_APB_PTR_0_APB_BASE_RANGE                  15:2
#define APBDMACHAN_CHANNEL_11_APB_PTR_0_APB_BASE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_11_APB_PTR_0_APB_BASE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_APB_PTR_0_APB_BASE_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_11_APB_PTR_0_APB_BASE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_APB_PTR_0_APB_BASE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_11_APB_SEQ_0  
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0                 _MK_ADDR_CONST(0x17c)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_RESET_VAL                       _MK_MASK_CONST(0x20010000)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_RESET_MASK                      _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_READ_MASK                       _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_WRITE_MASK                      _MK_MASK_CONST(0x78070000)
// 0 = 8 bit Bus 1 = 16 bit Bus 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD) 4 = 128 bit BUS (RSVD)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_BUS_WIDTH_SHIFT                     _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_BUS_WIDTH_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_BUS_WIDTH_RANGE                     30:28
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_BUS_WIDTH_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT                   _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_8                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_16                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_32                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_64                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_128                     _MK_ENUM_CONST(4)

// When enabled the data going  to APB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_DATA_SWAP_SHIFT                     _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_DATA_SWAP_FIELD                     (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_DATA_SWAP_RANGE                     27:27
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_DATA_SWAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_DATA_SWAP_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_DATA_SWAP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_DATA_SWAP_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_DATA_SWAP_ENABLE                    _MK_ENUM_CONST(1)

//APB Address Wrap-around Window 0 = No Wrap 1 = Wrap on 1 Word Window (def) 2 = Wrap on 2 Word Window 3 = Wrap on 4 Word Window 4 = Wrap on 8 Word Window 5 = Wrap on 16 Word Window 6 = Wrap on 32 Word Window 7 = Wrap on 64 Word Window (rsvd)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_SHIFT                     _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_RANGE                     18:16
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_NO_WRAP                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_WRAP_0N_1WORDS                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_2WORDS                    _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_4WORDS                    _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_8WORDS                    _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_16WORDS                   _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_32WORDS                   _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_11_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_64WORDS                   _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_12_CSR_0  
#define APBDMACHAN_CHANNEL_12_CSR_0                     _MK_ADDR_CONST(0x180)
#define APBDMACHAN_CHANNEL_12_CSR_0_SECURE                      0x0
#define APBDMACHAN_CHANNEL_12_CSR_0_WORD_COUNT                  0x1
#define APBDMACHAN_CHANNEL_12_CSR_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_RESET_MASK                  _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_12_CSR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_READ_MASK                   _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_12_CSR_0_WRITE_MASK                  _MK_MASK_CONST(0xfffffffc)
// Enables DMA channel transfer 
#define APBDMACHAN_CHANNEL_12_CSR_0_ENB_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_12_CSR_0_ENB_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_12_CSR_0_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_12_CSR_0_ENB_RANGE                   31:31
#define APBDMACHAN_CHANNEL_12_CSR_0_ENB_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_12_CSR_0_ENB_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_12_CSR_0_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_ENB_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_CSR_0_ENB_ENABLE                  _MK_ENUM_CONST(1)

// Interrupts when DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_12_CSR_0_IE_EOC_SHIFT                        _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_12_CSR_0_IE_EOC_FIELD                        (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_12_CSR_0_IE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_12_CSR_0_IE_EOC_RANGE                        30:30
#define APBDMACHAN_CHANNEL_12_CSR_0_IE_EOC_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_12_CSR_0_IE_EOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_IE_EOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_12_CSR_0_IE_EOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_IE_EOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_IE_EOC_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_CSR_0_IE_EOC_ENABLE                       _MK_ENUM_CONST(1)

// Holds this Processor until DMA Block Transfer Completes
#define APBDMACHAN_CHANNEL_12_CSR_0_HOLD_SHIFT                  _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_12_CSR_0_HOLD_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_12_CSR_0_HOLD_SHIFT)
#define APBDMACHAN_CHANNEL_12_CSR_0_HOLD_RANGE                  29:29
#define APBDMACHAN_CHANNEL_12_CSR_0_HOLD_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_12_CSR_0_HOLD_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_HOLD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_12_CSR_0_HOLD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_HOLD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_HOLD_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_CSR_0_HOLD_ENABLE                 _MK_ENUM_CONST(1)

// DMA Transfer Direction 1 = AHB read to APB write 0 = APB read to AHB write
#define APBDMACHAN_CHANNEL_12_CSR_0_DIR_SHIFT                   _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_12_CSR_0_DIR_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_12_CSR_0_DIR_SHIFT)
#define APBDMACHAN_CHANNEL_12_CSR_0_DIR_RANGE                   28:28
#define APBDMACHAN_CHANNEL_12_CSR_0_DIR_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_12_CSR_0_DIR_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_DIR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_12_CSR_0_DIR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_DIR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_DIR_AHB_WRITE                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_CSR_0_DIR_AHB_READ                        _MK_ENUM_CONST(1)

// Run Once or Run Multiple Mode (Allow Retriggering of this Channel) 1 = Run for One Block Transfer 0 = Run for Multiple Block Transfer
#define APBDMACHAN_CHANNEL_12_CSR_0_ONCE_SHIFT                  _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_12_CSR_0_ONCE_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_12_CSR_0_ONCE_SHIFT)
#define APBDMACHAN_CHANNEL_12_CSR_0_ONCE_RANGE                  27:27
#define APBDMACHAN_CHANNEL_12_CSR_0_ONCE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_12_CSR_0_ONCE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_ONCE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_12_CSR_0_ONCE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_ONCE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_ONCE_MULTIPLE_BLOCK                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_CSR_0_ONCE_SINGLE_BLOCK                   _MK_ENUM_CONST(1)

// Enable on Non-Zero Value
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_SHIFT                      _MK_SHIFT_CONST(22)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_FIELD                      (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_RANGE                      26:22
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_NA1                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_SMP24                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_SMP25                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_SMP26                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_SMP27                      _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_XRQ_A                      _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_XRQ_B                      _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_TMR1                       _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_TMR2                       _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_APB_0                      _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_APB_1                      _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_APB_2                      _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_APB_3                      _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_APB_4                      _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_APB_5                      _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_APB_6                      _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_APB_7                      _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_APB_8                      _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_APB_9                      _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_APB_10                     _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_APB_11                     _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_APB_12                     _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_APB_13                     _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_APB_14                     _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_12_CSR_0_TRIG_SEL_APB_15                     _MK_ENUM_CONST(24)

// Flow Control Enable (Synchronize Burst Transfers) 1 = Link to DRQ source 0 = Independent of DRQ request
#define APBDMACHAN_CHANNEL_12_CSR_0_FLOW_SHIFT                  _MK_SHIFT_CONST(21)
#define APBDMACHAN_CHANNEL_12_CSR_0_FLOW_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_12_CSR_0_FLOW_SHIFT)
#define APBDMACHAN_CHANNEL_12_CSR_0_FLOW_RANGE                  21:21
#define APBDMACHAN_CHANNEL_12_CSR_0_FLOW_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_12_CSR_0_FLOW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_FLOW_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_12_CSR_0_FLOW_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_FLOW_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_FLOW_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_CSR_0_FLOW_ENABLE                 _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_FIELD                       (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_RANGE                       20:16
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_CNTR_REQ                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_I2S_2                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_I2S_1                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_SPD_I                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_UI_I                        _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_MIPI                        _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_I2S2_2                      _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_I2S2_1                      _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_UART_A                      _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_UART_B                      _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_UART_C                      _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_SPI                 _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_AC97                        _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_ACModem                     _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_SL4B                        _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_SL2B1                       _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_SL2B2                       _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_SL2B3                       _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_SL2B4                       _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_UART_D                      _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_UART_E                      _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_I2C                 _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_I2C2                        _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_I2C3                        _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_DVC_I2C                     _MK_ENUM_CONST(24)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_OWR                 _MK_ENUM_CONST(25)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_NA26                        _MK_ENUM_CONST(26)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_NA27                        _MK_ENUM_CONST(27)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_NA28                        _MK_ENUM_CONST(28)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_NA29                        _MK_ENUM_CONST(29)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_NA30                        _MK_ENUM_CONST(30)
#define APBDMACHAN_CHANNEL_12_CSR_0_REQ_SEL_NA31                        _MK_ENUM_CONST(31)

// Number of 32bit word cycles
#define APBDMACHAN_CHANNEL_12_CSR_0_WCOUNT_SHIFT                        _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_12_CSR_0_WCOUNT_FIELD                        (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_12_CSR_0_WCOUNT_SHIFT)
#define APBDMACHAN_CHANNEL_12_CSR_0_WCOUNT_RANGE                        15:2
#define APBDMACHAN_CHANNEL_12_CSR_0_WCOUNT_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_12_CSR_0_WCOUNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_WCOUNT_DEFAULT_MASK                 _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_12_CSR_0_WCOUNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_CSR_0_WCOUNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_12_STA_0  
#define APBDMACHAN_CHANNEL_12_STA_0                     _MK_ADDR_CONST(0x184)
#define APBDMACHAN_CHANNEL_12_STA_0_SECURE                      0x0
#define APBDMACHAN_CHANNEL_12_STA_0_WORD_COUNT                  0x1
#define APBDMACHAN_CHANNEL_12_STA_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_RESET_MASK                  _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_12_STA_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_READ_MASK                   _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_12_STA_0_WRITE_MASK                  _MK_MASK_CONST(0x40000000)
// indicate DMA Channel Status activated or not
#define APBDMACHAN_CHANNEL_12_STA_0_BSY_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_12_STA_0_BSY_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_12_STA_0_BSY_SHIFT)
#define APBDMACHAN_CHANNEL_12_STA_0_BSY_RANGE                   31:31
#define APBDMACHAN_CHANNEL_12_STA_0_BSY_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_12_STA_0_BSY_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_BSY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_12_STA_0_BSY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_BSY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_BSY_WAIT                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_STA_0_BSY_ACTIVE                  _MK_ENUM_CONST(1)

//  Write '1' to clear the flag
#define APBDMACHAN_CHANNEL_12_STA_0_ISE_EOC_SHIFT                       _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_12_STA_0_ISE_EOC_FIELD                       (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_12_STA_0_ISE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_12_STA_0_ISE_EOC_RANGE                       30:30
#define APBDMACHAN_CHANNEL_12_STA_0_ISE_EOC_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_12_STA_0_ISE_EOC_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_ISE_EOC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_12_STA_0_ISE_EOC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_ISE_EOC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_ISE_EOC_NO_INTR                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_STA_0_ISE_EOC_INTR                        _MK_ENUM_CONST(1)

// Holding Status of Processor
#define APBDMACHAN_CHANNEL_12_STA_0_HALT_SHIFT                  _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_12_STA_0_HALT_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_12_STA_0_HALT_SHIFT)
#define APBDMACHAN_CHANNEL_12_STA_0_HALT_RANGE                  29:29
#define APBDMACHAN_CHANNEL_12_STA_0_HALT_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_12_STA_0_HALT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_HALT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_12_STA_0_HALT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_HALT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_HALT_NO_HALT                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_STA_0_HALT_HALT                   _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_12_STA_0_PING_PONG_STA_SHIFT                 _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_12_STA_0_PING_PONG_STA_FIELD                 (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_12_STA_0_PING_PONG_STA_SHIFT)
#define APBDMACHAN_CHANNEL_12_STA_0_PING_PONG_STA_RANGE                 28:28
#define APBDMACHAN_CHANNEL_12_STA_0_PING_PONG_STA_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_12_STA_0_PING_PONG_STA_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_PING_PONG_STA_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_12_STA_0_PING_PONG_STA_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_PING_PONG_STA_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_PING_PONG_STA_PING_INTR_STA                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_STA_0_PING_PONG_STA_PONG_INTR_STA                 _MK_ENUM_CONST(1)

// Current 32bit word cycles Flags set /cleared by HW
#define APBDMACHAN_CHANNEL_12_STA_0_COUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_12_STA_0_COUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_12_STA_0_COUNT_SHIFT)
#define APBDMACHAN_CHANNEL_12_STA_0_COUNT_RANGE                 15:2
#define APBDMACHAN_CHANNEL_12_STA_0_COUNT_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_12_STA_0_COUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_COUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_12_STA_0_COUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_STA_0_COUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 392 [0x188] 

// Reserved address 396 [0x18c] 

// Register APBDMACHAN_CHANNEL_12_AHB_PTR_0  
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0                 _MK_ADDR_CONST(0x190)
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0_RESET_MASK                      _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0_READ_MASK                       _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0_WRITE_MASK                      _MK_MASK_CONST(0xfffffffc)
// APB-DMA Starting Address for AHB Bus: SW writes to  modify
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0_AHB_BASE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0_AHB_BASE_FIELD                  (_MK_MASK_CONST(0x3fffffff) << APBDMACHAN_CHANNEL_12_AHB_PTR_0_AHB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0_AHB_BASE_RANGE                  31:2
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0_AHB_BASE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0_AHB_BASE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0_AHB_BASE_DEFAULT_MASK                   _MK_MASK_CONST(0x3fffffff)
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0_AHB_BASE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_PTR_0_AHB_BASE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_12_AHB_SEQ_0  
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0                 _MK_ADDR_CONST(0x194)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_RESET_VAL                       _MK_MASK_CONST(0x20000000)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_RESET_MASK                      _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_READ_MASK                       _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRITE_MASK                      _MK_MASK_CONST(0xff0f0000)
//  0 = send interrupt to COP
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_INTR_ENB_SHIFT                  _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_INTR_ENB_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_12_AHB_SEQ_0_INTR_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_INTR_ENB_RANGE                  31:31
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_INTR_ENB_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_INTR_ENB_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_INTR_ENB_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_INTR_ENB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_INTR_ENB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_INTR_ENB_CPU                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_INTR_ENB_COP                    _MK_ENUM_CONST(0)

// AHB Bus Width 0 = 8 bit Bus (RSVD) 1 = 16 bit Bus (RSVD) 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD)4 = 128 bit Bus (RSVD)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT                     _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BUS_WIDTH_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BUS_WIDTH_RANGE                     30:28
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BUS_WIDTH_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT                   _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_8                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_16                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_32                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_64                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_128                     _MK_ENUM_CONST(4)

// When enabled the data going  to AHB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT                     _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_DATA_SWAP_FIELD                     (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_DATA_SWAP_RANGE                     27:27
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_DATA_SWAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_DATA_SWAP_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_DATA_SWAP_ENABLE                    _MK_ENUM_CONST(1)

// AHB Burst Size DMA Burst Length (encoded) 4 = 1 Word (1x32bits) 5 = 4 Words (4x32bits)else = 8 Words (8x32bits) default
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BURST_SHIFT                 _MK_SHIFT_CONST(24)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BURST_FIELD                 (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BURST_SHIFT)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BURST_RANGE                 26:24
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BURST_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BURST_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BURST_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BURST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BURST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BURST_DMA_BURST_1WORDS                      _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BURST_DMA_BURST_4WORDS                      _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_AHB_BURST_DMA_BURST_8WORDS                      _MK_ENUM_CONST(6)

// 2X Double Buffering Mode (For Run-Multiple Mode with No Wrap Operations) 1 = Reload Base Address for 2X blocks (reload every other time) 0 = Reload Base Address for 1X blocks  (def) (reload each time)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_DBL_BUF_SHIFT                   _MK_SHIFT_CONST(19)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_DBL_BUF_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_12_AHB_SEQ_0_DBL_BUF_SHIFT)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_DBL_BUF_RANGE                   19:19
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_DBL_BUF_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_DBL_BUF_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_DBL_BUF_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_DBL_BUF_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_DBL_BUF_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_1X_BLOCKS                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_2X_BLOCKS                    _MK_ENUM_CONST(1)

// AHB Address Wrap: AHB Address wrap-around window 0=No Wrap (default) 5=Wrap on 512 word window 1=Wrap on 32 word window 6=Wrap on 1024 word window 2=Wrap on 64 word window 7=Wrap on 2048 word window 3=Wrap on 128 word window 4=Wrap on 256 word window
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_RANGE                      18:16
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_NO_WRAP                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_WRAP_0N_32WORDS                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_WRAP_ON_64WORDS                    _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_WRAP_ON_128WORDS                   _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_WRAP_ON_256WORDS                   _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_WRAP_ON_512WORDS                   _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_WRAP_ON_1024WORDS                  _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_12_AHB_SEQ_0_WRAP_WRAP_ON_2048WORDS                  _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_12_APB_PTR_0  
#define APBDMACHAN_CHANNEL_12_APB_PTR_0                 _MK_ADDR_CONST(0x198)
#define APBDMACHAN_CHANNEL_12_APB_PTR_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_12_APB_PTR_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_12_APB_PTR_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_APB_PTR_0_RESET_MASK                      _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_12_APB_PTR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_APB_PTR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_APB_PTR_0_READ_MASK                       _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_12_APB_PTR_0_WRITE_MASK                      _MK_MASK_CONST(0xfffc)
// APB-DMA Starting address for APB Bus: APB Base address:Upper 16 bits are fixed at 0x7000:XXXX
#define APBDMACHAN_CHANNEL_12_APB_PTR_0_APB_BASE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_12_APB_PTR_0_APB_BASE_FIELD                  (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_12_APB_PTR_0_APB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_12_APB_PTR_0_APB_BASE_RANGE                  15:2
#define APBDMACHAN_CHANNEL_12_APB_PTR_0_APB_BASE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_12_APB_PTR_0_APB_BASE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_APB_PTR_0_APB_BASE_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_12_APB_PTR_0_APB_BASE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_APB_PTR_0_APB_BASE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_12_APB_SEQ_0  
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0                 _MK_ADDR_CONST(0x19c)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_RESET_VAL                       _MK_MASK_CONST(0x20010000)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_RESET_MASK                      _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_READ_MASK                       _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_WRITE_MASK                      _MK_MASK_CONST(0x78070000)
// 0 = 8 bit Bus 1 = 16 bit Bus 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD) 4 = 128 bit BUS (RSVD)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_BUS_WIDTH_SHIFT                     _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_BUS_WIDTH_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_BUS_WIDTH_RANGE                     30:28
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_BUS_WIDTH_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT                   _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_8                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_16                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_32                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_64                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_128                     _MK_ENUM_CONST(4)

// When enabled the data going  to APB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_DATA_SWAP_SHIFT                     _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_DATA_SWAP_FIELD                     (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_DATA_SWAP_RANGE                     27:27
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_DATA_SWAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_DATA_SWAP_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_DATA_SWAP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_DATA_SWAP_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_DATA_SWAP_ENABLE                    _MK_ENUM_CONST(1)

//APB Address Wrap-around Window 0 = No Wrap 1 = Wrap on 1 Word Window (def) 2 = Wrap on 2 Word Window 3 = Wrap on 4 Word Window 4 = Wrap on 8 Word Window 5 = Wrap on 16 Word Window 6 = Wrap on 32 Word Window 7 = Wrap on 64 Word Window (rsvd)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_SHIFT                     _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_RANGE                     18:16
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_NO_WRAP                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_WRAP_0N_1WORDS                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_2WORDS                    _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_4WORDS                    _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_8WORDS                    _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_16WORDS                   _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_32WORDS                   _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_12_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_64WORDS                   _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_13_CSR_0  
#define APBDMACHAN_CHANNEL_13_CSR_0                     _MK_ADDR_CONST(0x1a0)
#define APBDMACHAN_CHANNEL_13_CSR_0_SECURE                      0x0
#define APBDMACHAN_CHANNEL_13_CSR_0_WORD_COUNT                  0x1
#define APBDMACHAN_CHANNEL_13_CSR_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_RESET_MASK                  _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_13_CSR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_READ_MASK                   _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_13_CSR_0_WRITE_MASK                  _MK_MASK_CONST(0xfffffffc)
// Enables DMA channel transfer 
#define APBDMACHAN_CHANNEL_13_CSR_0_ENB_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_13_CSR_0_ENB_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_13_CSR_0_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_13_CSR_0_ENB_RANGE                   31:31
#define APBDMACHAN_CHANNEL_13_CSR_0_ENB_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_13_CSR_0_ENB_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_13_CSR_0_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_ENB_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_CSR_0_ENB_ENABLE                  _MK_ENUM_CONST(1)

// Interrupts when DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_13_CSR_0_IE_EOC_SHIFT                        _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_13_CSR_0_IE_EOC_FIELD                        (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_13_CSR_0_IE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_13_CSR_0_IE_EOC_RANGE                        30:30
#define APBDMACHAN_CHANNEL_13_CSR_0_IE_EOC_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_13_CSR_0_IE_EOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_IE_EOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_13_CSR_0_IE_EOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_IE_EOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_IE_EOC_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_CSR_0_IE_EOC_ENABLE                       _MK_ENUM_CONST(1)

// Holds this Processor until DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_13_CSR_0_HOLD_SHIFT                  _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_13_CSR_0_HOLD_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_13_CSR_0_HOLD_SHIFT)
#define APBDMACHAN_CHANNEL_13_CSR_0_HOLD_RANGE                  29:29
#define APBDMACHAN_CHANNEL_13_CSR_0_HOLD_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_13_CSR_0_HOLD_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_HOLD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_13_CSR_0_HOLD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_HOLD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_HOLD_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_CSR_0_HOLD_ENABLE                 _MK_ENUM_CONST(1)

// DMA Transfer Direction 1 = AHB read to APB write 0 = APB read to AHB write
#define APBDMACHAN_CHANNEL_13_CSR_0_DIR_SHIFT                   _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_13_CSR_0_DIR_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_13_CSR_0_DIR_SHIFT)
#define APBDMACHAN_CHANNEL_13_CSR_0_DIR_RANGE                   28:28
#define APBDMACHAN_CHANNEL_13_CSR_0_DIR_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_13_CSR_0_DIR_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_DIR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_13_CSR_0_DIR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_DIR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_DIR_AHB_WRITE                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_CSR_0_DIR_AHB_READ                        _MK_ENUM_CONST(1)

// Run Once or Run Multiple Mode (Allow Retriggering of this Channel) 1 = Run for One Block Transfer 0 = Run for Multiple Block Transfer
#define APBDMACHAN_CHANNEL_13_CSR_0_ONCE_SHIFT                  _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_13_CSR_0_ONCE_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_13_CSR_0_ONCE_SHIFT)
#define APBDMACHAN_CHANNEL_13_CSR_0_ONCE_RANGE                  27:27
#define APBDMACHAN_CHANNEL_13_CSR_0_ONCE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_13_CSR_0_ONCE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_ONCE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_13_CSR_0_ONCE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_ONCE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_ONCE_MULTIPLE_BLOCK                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_CSR_0_ONCE_SINGLE_BLOCK                   _MK_ENUM_CONST(1)

// Enable on Non-Zero Value
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_SHIFT                      _MK_SHIFT_CONST(22)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_FIELD                      (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_RANGE                      26:22
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_NA1                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_SMP24                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_SMP25                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_SMP26                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_SMP27                      _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_XRQ_A                      _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_XRQ_B                      _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_TMR1                       _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_TMR2                       _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_APB_0                      _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_APB_1                      _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_APB_2                      _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_APB_3                      _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_APB_4                      _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_APB_5                      _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_APB_6                      _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_APB_7                      _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_APB_8                      _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_APB_9                      _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_APB_10                     _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_APB_11                     _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_APB_12                     _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_APB_13                     _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_APB_14                     _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_13_CSR_0_TRIG_SEL_APB_15                     _MK_ENUM_CONST(24)

// Flow Control Enable (Synchronize Burst Transfers) 1 = Link to DRQ source 0 = Independent of DRQ request
#define APBDMACHAN_CHANNEL_13_CSR_0_FLOW_SHIFT                  _MK_SHIFT_CONST(21)
#define APBDMACHAN_CHANNEL_13_CSR_0_FLOW_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_13_CSR_0_FLOW_SHIFT)
#define APBDMACHAN_CHANNEL_13_CSR_0_FLOW_RANGE                  21:21
#define APBDMACHAN_CHANNEL_13_CSR_0_FLOW_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_13_CSR_0_FLOW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_FLOW_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_13_CSR_0_FLOW_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_FLOW_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_FLOW_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_CSR_0_FLOW_ENABLE                 _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_FIELD                       (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_RANGE                       20:16
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_CNTR_REQ                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_I2S_2                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_I2S_1                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_SPD_I                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_UI_I                        _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_MIPI                        _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_I2S2_2                      _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_I2S2_1                      _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_UART_A                      _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_UART_B                      _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_UART_C                      _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_SPI                 _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_AC97                        _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_ACModem                     _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_SL4B                        _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_SL2B1                       _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_SL2B2                       _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_SL2B3                       _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_SL2B4                       _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_UART_D                      _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_UART_E                      _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_I2C                 _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_I2C2                        _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_I2C3                        _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_DVC_I2C                     _MK_ENUM_CONST(24)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_OWR                 _MK_ENUM_CONST(25)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_NA26                        _MK_ENUM_CONST(26)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_NA27                        _MK_ENUM_CONST(27)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_NA28                        _MK_ENUM_CONST(28)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_NA29                        _MK_ENUM_CONST(29)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_NA30                        _MK_ENUM_CONST(30)
#define APBDMACHAN_CHANNEL_13_CSR_0_REQ_SEL_NA31                        _MK_ENUM_CONST(31)

// Number of 32bit word cycles
#define APBDMACHAN_CHANNEL_13_CSR_0_WCOUNT_SHIFT                        _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_13_CSR_0_WCOUNT_FIELD                        (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_13_CSR_0_WCOUNT_SHIFT)
#define APBDMACHAN_CHANNEL_13_CSR_0_WCOUNT_RANGE                        15:2
#define APBDMACHAN_CHANNEL_13_CSR_0_WCOUNT_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_13_CSR_0_WCOUNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_WCOUNT_DEFAULT_MASK                 _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_13_CSR_0_WCOUNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_CSR_0_WCOUNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_13_STA_0  
#define APBDMACHAN_CHANNEL_13_STA_0                     _MK_ADDR_CONST(0x1a4)
#define APBDMACHAN_CHANNEL_13_STA_0_SECURE                      0x0
#define APBDMACHAN_CHANNEL_13_STA_0_WORD_COUNT                  0x1
#define APBDMACHAN_CHANNEL_13_STA_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_RESET_MASK                  _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_13_STA_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_READ_MASK                   _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_13_STA_0_WRITE_MASK                  _MK_MASK_CONST(0x40000000)
// indicate DMA Channel Status activated or not 
#define APBDMACHAN_CHANNEL_13_STA_0_BSY_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_13_STA_0_BSY_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_13_STA_0_BSY_SHIFT)
#define APBDMACHAN_CHANNEL_13_STA_0_BSY_RANGE                   31:31
#define APBDMACHAN_CHANNEL_13_STA_0_BSY_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_13_STA_0_BSY_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_BSY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_13_STA_0_BSY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_BSY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_BSY_WAIT                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_STA_0_BSY_ACTIVE                  _MK_ENUM_CONST(1)

//  Write '1' to clear the flag
#define APBDMACHAN_CHANNEL_13_STA_0_ISE_EOC_SHIFT                       _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_13_STA_0_ISE_EOC_FIELD                       (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_13_STA_0_ISE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_13_STA_0_ISE_EOC_RANGE                       30:30
#define APBDMACHAN_CHANNEL_13_STA_0_ISE_EOC_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_13_STA_0_ISE_EOC_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_ISE_EOC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_13_STA_0_ISE_EOC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_ISE_EOC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_ISE_EOC_NO_INTR                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_STA_0_ISE_EOC_INTR                        _MK_ENUM_CONST(1)

// Holding Status of Processor
#define APBDMACHAN_CHANNEL_13_STA_0_HALT_SHIFT                  _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_13_STA_0_HALT_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_13_STA_0_HALT_SHIFT)
#define APBDMACHAN_CHANNEL_13_STA_0_HALT_RANGE                  29:29
#define APBDMACHAN_CHANNEL_13_STA_0_HALT_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_13_STA_0_HALT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_HALT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_13_STA_0_HALT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_HALT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_HALT_NO_HALT                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_STA_0_HALT_HALT                   _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_13_STA_0_PING_PONG_STA_SHIFT                 _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_13_STA_0_PING_PONG_STA_FIELD                 (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_13_STA_0_PING_PONG_STA_SHIFT)
#define APBDMACHAN_CHANNEL_13_STA_0_PING_PONG_STA_RANGE                 28:28
#define APBDMACHAN_CHANNEL_13_STA_0_PING_PONG_STA_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_13_STA_0_PING_PONG_STA_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_PING_PONG_STA_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_13_STA_0_PING_PONG_STA_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_PING_PONG_STA_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_PING_PONG_STA_PING_INTR_STA                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_STA_0_PING_PONG_STA_PONG_INTR_STA                 _MK_ENUM_CONST(1)

// Current 32bit word cycles Flags set /cleared by HW
#define APBDMACHAN_CHANNEL_13_STA_0_COUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_13_STA_0_COUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_13_STA_0_COUNT_SHIFT)
#define APBDMACHAN_CHANNEL_13_STA_0_COUNT_RANGE                 15:2
#define APBDMACHAN_CHANNEL_13_STA_0_COUNT_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_13_STA_0_COUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_COUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_13_STA_0_COUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_STA_0_COUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 424 [0x1a8] 

// Reserved address 428 [0x1ac] 

// Register APBDMACHAN_CHANNEL_13_AHB_PTR_0  
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0                 _MK_ADDR_CONST(0x1b0)
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0_RESET_MASK                      _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0_READ_MASK                       _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0_WRITE_MASK                      _MK_MASK_CONST(0xfffffffc)
// APB-DMA Starting Address for AHB Bus: SW writes to  modify
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0_AHB_BASE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0_AHB_BASE_FIELD                  (_MK_MASK_CONST(0x3fffffff) << APBDMACHAN_CHANNEL_13_AHB_PTR_0_AHB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0_AHB_BASE_RANGE                  31:2
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0_AHB_BASE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0_AHB_BASE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0_AHB_BASE_DEFAULT_MASK                   _MK_MASK_CONST(0x3fffffff)
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0_AHB_BASE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_PTR_0_AHB_BASE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_13_AHB_SEQ_0  
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0                 _MK_ADDR_CONST(0x1b4)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_RESET_VAL                       _MK_MASK_CONST(0x20000000)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_RESET_MASK                      _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_READ_MASK                       _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRITE_MASK                      _MK_MASK_CONST(0xff0f0000)
//  0 = send interrupt to COP
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_INTR_ENB_SHIFT                  _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_INTR_ENB_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_13_AHB_SEQ_0_INTR_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_INTR_ENB_RANGE                  31:31
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_INTR_ENB_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_INTR_ENB_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_INTR_ENB_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_INTR_ENB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_INTR_ENB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_INTR_ENB_CPU                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_INTR_ENB_COP                    _MK_ENUM_CONST(0)

// AHB Bus Width 0 = 8 bit Bus (RSVD) 1 = 16 bit Bus (RSVD) 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD)4 = 128 bit Bus (RSVD)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT                     _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BUS_WIDTH_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BUS_WIDTH_RANGE                     30:28
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BUS_WIDTH_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT                   _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_8                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_16                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_32                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_64                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_128                     _MK_ENUM_CONST(4)

// When enabled the data going  to AHB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT                     _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_DATA_SWAP_FIELD                     (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_DATA_SWAP_RANGE                     27:27
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_DATA_SWAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_DATA_SWAP_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_DATA_SWAP_ENABLE                    _MK_ENUM_CONST(1)

// AHB Burst Size DMA Burst Length (encoded) 4 = 1 Word (1x32bits) 5 = 4 Words (4x32bits)else = 8 Words (8x32bits) default
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BURST_SHIFT                 _MK_SHIFT_CONST(24)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BURST_FIELD                 (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BURST_SHIFT)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BURST_RANGE                 26:24
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BURST_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BURST_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BURST_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BURST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BURST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BURST_DMA_BURST_1WORDS                      _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BURST_DMA_BURST_4WORDS                      _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_AHB_BURST_DMA_BURST_8WORDS                      _MK_ENUM_CONST(6)

// 2X Double Buffering Mode (For Run-Multiple Mode with No Wrap Operations) 1 = Reload Base Address for 2X blocks (reload every other time) 0 = Reload Base Address for 1X blocks  (def) (reload each time)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_DBL_BUF_SHIFT                   _MK_SHIFT_CONST(19)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_DBL_BUF_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_13_AHB_SEQ_0_DBL_BUF_SHIFT)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_DBL_BUF_RANGE                   19:19
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_DBL_BUF_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_DBL_BUF_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_DBL_BUF_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_DBL_BUF_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_DBL_BUF_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_1X_BLOCKS                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_2X_BLOCKS                    _MK_ENUM_CONST(1)

// AHB Address Wrap: AHB Address wrap-around window 0=No Wrap (default) 5=Wrap on 512 word window 1=Wrap on 32 word window 6=Wrap on 1024 word window 2=Wrap on 64 word window 7=Wrap on 2048 word window 3=Wrap on 128 word window 4=Wrap on 256 word window
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_RANGE                      18:16
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_NO_WRAP                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_WRAP_0N_32WORDS                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_WRAP_ON_64WORDS                    _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_WRAP_ON_128WORDS                   _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_WRAP_ON_256WORDS                   _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_WRAP_ON_512WORDS                   _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_WRAP_ON_1024WORDS                  _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_13_AHB_SEQ_0_WRAP_WRAP_ON_2048WORDS                  _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_13_APB_PTR_0  
#define APBDMACHAN_CHANNEL_13_APB_PTR_0                 _MK_ADDR_CONST(0x1b8)
#define APBDMACHAN_CHANNEL_13_APB_PTR_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_13_APB_PTR_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_13_APB_PTR_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_APB_PTR_0_RESET_MASK                      _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_13_APB_PTR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_APB_PTR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_APB_PTR_0_READ_MASK                       _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_13_APB_PTR_0_WRITE_MASK                      _MK_MASK_CONST(0xfffc)
// APB-DMA Starting address for APB Bus: APB Base address:Upper 16 bits are fixed at 0x7000:XXXX
#define APBDMACHAN_CHANNEL_13_APB_PTR_0_APB_BASE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_13_APB_PTR_0_APB_BASE_FIELD                  (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_13_APB_PTR_0_APB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_13_APB_PTR_0_APB_BASE_RANGE                  15:2
#define APBDMACHAN_CHANNEL_13_APB_PTR_0_APB_BASE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_13_APB_PTR_0_APB_BASE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_APB_PTR_0_APB_BASE_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_13_APB_PTR_0_APB_BASE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_APB_PTR_0_APB_BASE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_13_APB_SEQ_0  
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0                 _MK_ADDR_CONST(0x1bc)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_RESET_VAL                       _MK_MASK_CONST(0x20010000)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_RESET_MASK                      _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_READ_MASK                       _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_WRITE_MASK                      _MK_MASK_CONST(0x78070000)
// 0 = 8 bit Bus 1 = 16 bit Bus 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD) 4 = 128 bit BUS (RSVD)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_BUS_WIDTH_SHIFT                     _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_BUS_WIDTH_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_BUS_WIDTH_RANGE                     30:28
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_BUS_WIDTH_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT                   _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_8                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_16                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_32                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_64                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_128                     _MK_ENUM_CONST(4)

// When enabled the data going  to APB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_DATA_SWAP_SHIFT                     _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_DATA_SWAP_FIELD                     (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_DATA_SWAP_RANGE                     27:27
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_DATA_SWAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_DATA_SWAP_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_DATA_SWAP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_DATA_SWAP_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_DATA_SWAP_ENABLE                    _MK_ENUM_CONST(1)

//APB Address Wrap-around Window 0 = No Wrap 1 = Wrap on 1 Word Window (def) 2 = Wrap on 2 Word Window 3 = Wrap on 4 Word Window 4 = Wrap on 8 Word Window 5 = Wrap on 16 Word Window 6 = Wrap on 32 Word Window 7 = Wrap on 64 Word Window (rsvd)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_SHIFT                     _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_RANGE                     18:16
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_NO_WRAP                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_WRAP_0N_1WORDS                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_2WORDS                    _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_4WORDS                    _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_8WORDS                    _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_16WORDS                   _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_32WORDS                   _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_13_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_64WORDS                   _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_14_CSR_0  
#define APBDMACHAN_CHANNEL_14_CSR_0                     _MK_ADDR_CONST(0x1c0)
#define APBDMACHAN_CHANNEL_14_CSR_0_SECURE                      0x0
#define APBDMACHAN_CHANNEL_14_CSR_0_WORD_COUNT                  0x1
#define APBDMACHAN_CHANNEL_14_CSR_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_RESET_MASK                  _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_14_CSR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_READ_MASK                   _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_14_CSR_0_WRITE_MASK                  _MK_MASK_CONST(0xfffffffc)
// Enables DMA channel transfer 
#define APBDMACHAN_CHANNEL_14_CSR_0_ENB_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_14_CSR_0_ENB_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_14_CSR_0_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_14_CSR_0_ENB_RANGE                   31:31
#define APBDMACHAN_CHANNEL_14_CSR_0_ENB_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_14_CSR_0_ENB_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_14_CSR_0_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_ENB_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_CSR_0_ENB_ENABLE                  _MK_ENUM_CONST(1)

// Interrupts when DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_14_CSR_0_IE_EOC_SHIFT                        _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_14_CSR_0_IE_EOC_FIELD                        (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_14_CSR_0_IE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_14_CSR_0_IE_EOC_RANGE                        30:30
#define APBDMACHAN_CHANNEL_14_CSR_0_IE_EOC_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_14_CSR_0_IE_EOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_IE_EOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_14_CSR_0_IE_EOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_IE_EOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_IE_EOC_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_CSR_0_IE_EOC_ENABLE                       _MK_ENUM_CONST(1)

// Holds this Processor until DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_14_CSR_0_HOLD_SHIFT                  _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_14_CSR_0_HOLD_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_14_CSR_0_HOLD_SHIFT)
#define APBDMACHAN_CHANNEL_14_CSR_0_HOLD_RANGE                  29:29
#define APBDMACHAN_CHANNEL_14_CSR_0_HOLD_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_14_CSR_0_HOLD_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_HOLD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_14_CSR_0_HOLD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_HOLD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_HOLD_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_CSR_0_HOLD_ENABLE                 _MK_ENUM_CONST(1)

// DMA Transfer Direction 1 = AHB read to APB write 0 = APB read to AHB write
#define APBDMACHAN_CHANNEL_14_CSR_0_DIR_SHIFT                   _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_14_CSR_0_DIR_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_14_CSR_0_DIR_SHIFT)
#define APBDMACHAN_CHANNEL_14_CSR_0_DIR_RANGE                   28:28
#define APBDMACHAN_CHANNEL_14_CSR_0_DIR_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_14_CSR_0_DIR_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_DIR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_14_CSR_0_DIR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_DIR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_DIR_AHB_WRITE                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_CSR_0_DIR_AHB_READ                        _MK_ENUM_CONST(1)

// Run Once or Run Multiple Mode (Allow Retriggering of this Channel) 1 = Run for One Block Transfer 0 = Run for Multiple Block Transfer
#define APBDMACHAN_CHANNEL_14_CSR_0_ONCE_SHIFT                  _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_14_CSR_0_ONCE_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_14_CSR_0_ONCE_SHIFT)
#define APBDMACHAN_CHANNEL_14_CSR_0_ONCE_RANGE                  27:27
#define APBDMACHAN_CHANNEL_14_CSR_0_ONCE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_14_CSR_0_ONCE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_ONCE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_14_CSR_0_ONCE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_ONCE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_ONCE_MULTIPLE_BLOCK                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_CSR_0_ONCE_SINGLE_BLOCK                   _MK_ENUM_CONST(1)

// Enable on Non-Zero Value
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_SHIFT                      _MK_SHIFT_CONST(22)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_FIELD                      (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_RANGE                      26:22
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_NA1                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_SMP24                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_SMP25                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_SMP26                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_SMP27                      _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_XRQ_A                      _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_XRQ_B                      _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_TMR1                       _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_TMR2                       _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_APB_0                      _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_APB_1                      _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_APB_2                      _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_APB_3                      _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_APB_4                      _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_APB_5                      _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_APB_6                      _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_APB_7                      _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_APB_8                      _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_APB_9                      _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_APB_10                     _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_APB_11                     _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_APB_12                     _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_APB_13                     _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_APB_14                     _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_14_CSR_0_TRIG_SEL_APB_15                     _MK_ENUM_CONST(24)

// Flow Control Enable (Synchronize Burst Transfers) 1 = Link to DRQ source 0 = Independent of DRQ request
#define APBDMACHAN_CHANNEL_14_CSR_0_FLOW_SHIFT                  _MK_SHIFT_CONST(21)
#define APBDMACHAN_CHANNEL_14_CSR_0_FLOW_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_14_CSR_0_FLOW_SHIFT)
#define APBDMACHAN_CHANNEL_14_CSR_0_FLOW_RANGE                  21:21
#define APBDMACHAN_CHANNEL_14_CSR_0_FLOW_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_14_CSR_0_FLOW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_FLOW_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_14_CSR_0_FLOW_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_FLOW_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_FLOW_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_CSR_0_FLOW_ENABLE                 _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_FIELD                       (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_RANGE                       20:16
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_CNTR_REQ                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_I2S_2                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_I2S_1                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_SPD_I                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_UI_I                        _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_MIPI                        _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_I2S2_2                      _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_I2S2_1                      _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_UART_A                      _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_UART_B                      _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_UART_C                      _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_SPI                 _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_AC97                        _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_ACModem                     _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_SL4B                        _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_SL2B1                       _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_SL2B2                       _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_SL2B3                       _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_SL2B4                       _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_UART_D                      _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_UART_E                      _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_I2C                 _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_I2C2                        _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_I2C3                        _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_DVC_I2C                     _MK_ENUM_CONST(24)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_OWR                 _MK_ENUM_CONST(25)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_NA26                        _MK_ENUM_CONST(26)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_NA27                        _MK_ENUM_CONST(27)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_NA28                        _MK_ENUM_CONST(28)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_NA29                        _MK_ENUM_CONST(29)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_NA30                        _MK_ENUM_CONST(30)
#define APBDMACHAN_CHANNEL_14_CSR_0_REQ_SEL_NA31                        _MK_ENUM_CONST(31)

// Number of 32bit word cycles
#define APBDMACHAN_CHANNEL_14_CSR_0_WCOUNT_SHIFT                        _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_14_CSR_0_WCOUNT_FIELD                        (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_14_CSR_0_WCOUNT_SHIFT)
#define APBDMACHAN_CHANNEL_14_CSR_0_WCOUNT_RANGE                        15:2
#define APBDMACHAN_CHANNEL_14_CSR_0_WCOUNT_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_14_CSR_0_WCOUNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_WCOUNT_DEFAULT_MASK                 _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_14_CSR_0_WCOUNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_CSR_0_WCOUNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_14_STA_0  
#define APBDMACHAN_CHANNEL_14_STA_0                     _MK_ADDR_CONST(0x1c4)
#define APBDMACHAN_CHANNEL_14_STA_0_SECURE                      0x0
#define APBDMACHAN_CHANNEL_14_STA_0_WORD_COUNT                  0x1
#define APBDMACHAN_CHANNEL_14_STA_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_RESET_MASK                  _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_14_STA_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_READ_MASK                   _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_14_STA_0_WRITE_MASK                  _MK_MASK_CONST(0x40000000)
// indicate DMA Channel Status activated or not 
#define APBDMACHAN_CHANNEL_14_STA_0_BSY_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_14_STA_0_BSY_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_14_STA_0_BSY_SHIFT)
#define APBDMACHAN_CHANNEL_14_STA_0_BSY_RANGE                   31:31
#define APBDMACHAN_CHANNEL_14_STA_0_BSY_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_14_STA_0_BSY_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_BSY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_14_STA_0_BSY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_BSY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_BSY_WAIT                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_STA_0_BSY_ACTIVE                  _MK_ENUM_CONST(1)

//  Write '1' to clear the flag
#define APBDMACHAN_CHANNEL_14_STA_0_ISE_EOC_SHIFT                       _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_14_STA_0_ISE_EOC_FIELD                       (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_14_STA_0_ISE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_14_STA_0_ISE_EOC_RANGE                       30:30
#define APBDMACHAN_CHANNEL_14_STA_0_ISE_EOC_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_14_STA_0_ISE_EOC_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_ISE_EOC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_14_STA_0_ISE_EOC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_ISE_EOC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_ISE_EOC_NO_INTR                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_STA_0_ISE_EOC_INTR                        _MK_ENUM_CONST(1)

// Holding Status of Processor 
#define APBDMACHAN_CHANNEL_14_STA_0_HALT_SHIFT                  _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_14_STA_0_HALT_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_14_STA_0_HALT_SHIFT)
#define APBDMACHAN_CHANNEL_14_STA_0_HALT_RANGE                  29:29
#define APBDMACHAN_CHANNEL_14_STA_0_HALT_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_14_STA_0_HALT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_HALT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_14_STA_0_HALT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_HALT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_HALT_NO_HALT                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_STA_0_HALT_HALT                   _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_14_STA_0_PING_PONG_STA_SHIFT                 _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_14_STA_0_PING_PONG_STA_FIELD                 (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_14_STA_0_PING_PONG_STA_SHIFT)
#define APBDMACHAN_CHANNEL_14_STA_0_PING_PONG_STA_RANGE                 28:28
#define APBDMACHAN_CHANNEL_14_STA_0_PING_PONG_STA_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_14_STA_0_PING_PONG_STA_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_PING_PONG_STA_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_14_STA_0_PING_PONG_STA_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_PING_PONG_STA_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_PING_PONG_STA_PING_INTR_STA                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_STA_0_PING_PONG_STA_PONG_INTR_STA                 _MK_ENUM_CONST(1)

// Current 32bit word cycles Flags set /cleared by HW
#define APBDMACHAN_CHANNEL_14_STA_0_COUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_14_STA_0_COUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_14_STA_0_COUNT_SHIFT)
#define APBDMACHAN_CHANNEL_14_STA_0_COUNT_RANGE                 15:2
#define APBDMACHAN_CHANNEL_14_STA_0_COUNT_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_14_STA_0_COUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_COUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_14_STA_0_COUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_STA_0_COUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 456 [0x1c8] 

// Reserved address 460 [0x1cc] 

// Register APBDMACHAN_CHANNEL_14_AHB_PTR_0  
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0                 _MK_ADDR_CONST(0x1d0)
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0_RESET_MASK                      _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0_READ_MASK                       _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0_WRITE_MASK                      _MK_MASK_CONST(0xfffffffc)
// APB-DMA Starting Address for AHB Bus: SW writes to  modify
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0_AHB_BASE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0_AHB_BASE_FIELD                  (_MK_MASK_CONST(0x3fffffff) << APBDMACHAN_CHANNEL_14_AHB_PTR_0_AHB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0_AHB_BASE_RANGE                  31:2
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0_AHB_BASE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0_AHB_BASE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0_AHB_BASE_DEFAULT_MASK                   _MK_MASK_CONST(0x3fffffff)
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0_AHB_BASE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_PTR_0_AHB_BASE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_14_AHB_SEQ_0  
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0                 _MK_ADDR_CONST(0x1d4)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_RESET_VAL                       _MK_MASK_CONST(0x20000000)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_RESET_MASK                      _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_READ_MASK                       _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRITE_MASK                      _MK_MASK_CONST(0xff0f0000)
//  0 = send interrupt to COP
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_INTR_ENB_SHIFT                  _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_INTR_ENB_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_14_AHB_SEQ_0_INTR_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_INTR_ENB_RANGE                  31:31
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_INTR_ENB_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_INTR_ENB_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_INTR_ENB_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_INTR_ENB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_INTR_ENB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_INTR_ENB_CPU                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_INTR_ENB_COP                    _MK_ENUM_CONST(0)

// AHB Bus Width 0 = 8 bit Bus (RSVD) 1 = 16 bit Bus (RSVD) 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD)4 = 128 bit Bus (RSVD)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT                     _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BUS_WIDTH_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BUS_WIDTH_RANGE                     30:28
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BUS_WIDTH_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT                   _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_8                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_16                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_32                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_64                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_128                     _MK_ENUM_CONST(4)

// When enabled the data going  to AHB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT                     _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_DATA_SWAP_FIELD                     (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_DATA_SWAP_RANGE                     27:27
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_DATA_SWAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_DATA_SWAP_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_DATA_SWAP_ENABLE                    _MK_ENUM_CONST(1)

// AHB Burst Size DMA Burst Length (encoded) 4 = 1 Word (1x32bits) 5 = 4 Words (4x32bits)else = 8 Words (8x32bits) default
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BURST_SHIFT                 _MK_SHIFT_CONST(24)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BURST_FIELD                 (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BURST_SHIFT)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BURST_RANGE                 26:24
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BURST_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BURST_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BURST_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BURST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BURST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BURST_DMA_BURST_1WORDS                      _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BURST_DMA_BURST_4WORDS                      _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_AHB_BURST_DMA_BURST_8WORDS                      _MK_ENUM_CONST(6)

// 2X Double Buffering Mode (For Run-Multiple Mode with No Wrap Operations) 1 = Reload Base Address for 2X blocks (reload every other time) 0 = Reload Base Address for 1X blocks  (def) (reload each time)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_DBL_BUF_SHIFT                   _MK_SHIFT_CONST(19)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_DBL_BUF_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_14_AHB_SEQ_0_DBL_BUF_SHIFT)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_DBL_BUF_RANGE                   19:19
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_DBL_BUF_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_DBL_BUF_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_DBL_BUF_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_DBL_BUF_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_DBL_BUF_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_1X_BLOCKS                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_2X_BLOCKS                    _MK_ENUM_CONST(1)

// AHB Address Wrap: AHB Address wrap-around window 0=No Wrap (default) 5=Wrap on 512 word window 1=Wrap on 32 word window 6=Wrap on 1024 word window 2=Wrap on 64 word window 7=Wrap on 2048 word window 3=Wrap on 128 word window 4=Wrap on 256 word window
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_RANGE                      18:16
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_NO_WRAP                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_WRAP_0N_32WORDS                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_WRAP_ON_64WORDS                    _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_WRAP_ON_128WORDS                   _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_WRAP_ON_256WORDS                   _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_WRAP_ON_512WORDS                   _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_WRAP_ON_1024WORDS                  _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_14_AHB_SEQ_0_WRAP_WRAP_ON_2048WORDS                  _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_14_APB_PTR_0  
#define APBDMACHAN_CHANNEL_14_APB_PTR_0                 _MK_ADDR_CONST(0x1d8)
#define APBDMACHAN_CHANNEL_14_APB_PTR_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_14_APB_PTR_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_14_APB_PTR_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_APB_PTR_0_RESET_MASK                      _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_14_APB_PTR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_APB_PTR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_APB_PTR_0_READ_MASK                       _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_14_APB_PTR_0_WRITE_MASK                      _MK_MASK_CONST(0xfffc)
// APB-DMA Starting address for APB Bus: APB Base address:Upper 16 bits are fixed at 0x7000:XXXX
#define APBDMACHAN_CHANNEL_14_APB_PTR_0_APB_BASE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_14_APB_PTR_0_APB_BASE_FIELD                  (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_14_APB_PTR_0_APB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_14_APB_PTR_0_APB_BASE_RANGE                  15:2
#define APBDMACHAN_CHANNEL_14_APB_PTR_0_APB_BASE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_14_APB_PTR_0_APB_BASE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_APB_PTR_0_APB_BASE_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_14_APB_PTR_0_APB_BASE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_APB_PTR_0_APB_BASE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_14_APB_SEQ_0  
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0                 _MK_ADDR_CONST(0x1dc)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_RESET_VAL                       _MK_MASK_CONST(0x20010000)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_RESET_MASK                      _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_READ_MASK                       _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_WRITE_MASK                      _MK_MASK_CONST(0x78070000)
// 0 = 8 bit Bus 1 = 16 bit Bus 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD) 4 = 128 bit BUS (RSVD)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_BUS_WIDTH_SHIFT                     _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_BUS_WIDTH_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_BUS_WIDTH_RANGE                     30:28
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_BUS_WIDTH_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT                   _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_8                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_16                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_32                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_64                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_128                     _MK_ENUM_CONST(4)

// When enabled the data going  to APB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_DATA_SWAP_SHIFT                     _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_DATA_SWAP_FIELD                     (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_DATA_SWAP_RANGE                     27:27
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_DATA_SWAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_DATA_SWAP_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_DATA_SWAP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_DATA_SWAP_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_DATA_SWAP_ENABLE                    _MK_ENUM_CONST(1)

//APB Address Wrap-around Window 0 = No Wrap 1 = Wrap on 1 Word Window (def) 2 = Wrap on 2 Word Window 3 = Wrap on 4 Word Window 4 = Wrap on 8 Word Window 5 = Wrap on 16 Word Window 6 = Wrap on 32 Word Window 7 = Wrap on 64 Word Window (rsvd)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_SHIFT                     _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_RANGE                     18:16
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_NO_WRAP                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_WRAP_0N_1WORDS                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_2WORDS                    _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_4WORDS                    _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_8WORDS                    _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_16WORDS                   _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_32WORDS                   _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_14_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_64WORDS                   _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_15_CSR_0  
#define APBDMACHAN_CHANNEL_15_CSR_0                     _MK_ADDR_CONST(0x1e0)
#define APBDMACHAN_CHANNEL_15_CSR_0_SECURE                      0x0
#define APBDMACHAN_CHANNEL_15_CSR_0_WORD_COUNT                  0x1
#define APBDMACHAN_CHANNEL_15_CSR_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_RESET_MASK                  _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_15_CSR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_READ_MASK                   _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_15_CSR_0_WRITE_MASK                  _MK_MASK_CONST(0xfffffffc)
// Enables DMA channel transfer 
#define APBDMACHAN_CHANNEL_15_CSR_0_ENB_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_15_CSR_0_ENB_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_15_CSR_0_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_15_CSR_0_ENB_RANGE                   31:31
#define APBDMACHAN_CHANNEL_15_CSR_0_ENB_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_15_CSR_0_ENB_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_15_CSR_0_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_ENB_DISABLE                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_CSR_0_ENB_ENABLE                  _MK_ENUM_CONST(1)

// Interrupts when DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_15_CSR_0_IE_EOC_SHIFT                        _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_15_CSR_0_IE_EOC_FIELD                        (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_15_CSR_0_IE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_15_CSR_0_IE_EOC_RANGE                        30:30
#define APBDMACHAN_CHANNEL_15_CSR_0_IE_EOC_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_15_CSR_0_IE_EOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_IE_EOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_15_CSR_0_IE_EOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_IE_EOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_IE_EOC_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_CSR_0_IE_EOC_ENABLE                       _MK_ENUM_CONST(1)

// Holds this Processor until DMA Block Transfer Completes 
#define APBDMACHAN_CHANNEL_15_CSR_0_HOLD_SHIFT                  _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_15_CSR_0_HOLD_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_15_CSR_0_HOLD_SHIFT)
#define APBDMACHAN_CHANNEL_15_CSR_0_HOLD_RANGE                  29:29
#define APBDMACHAN_CHANNEL_15_CSR_0_HOLD_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_15_CSR_0_HOLD_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_HOLD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_15_CSR_0_HOLD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_HOLD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_HOLD_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_CSR_0_HOLD_ENABLE                 _MK_ENUM_CONST(1)

// DMA Transfer Direction 1 = AHB read to APB write 0 = APB read to AHB write
#define APBDMACHAN_CHANNEL_15_CSR_0_DIR_SHIFT                   _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_15_CSR_0_DIR_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_15_CSR_0_DIR_SHIFT)
#define APBDMACHAN_CHANNEL_15_CSR_0_DIR_RANGE                   28:28
#define APBDMACHAN_CHANNEL_15_CSR_0_DIR_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_15_CSR_0_DIR_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_DIR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_15_CSR_0_DIR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_DIR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_DIR_AHB_WRITE                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_CSR_0_DIR_AHB_READ                        _MK_ENUM_CONST(1)

// Run Once or Run Multiple Mode (Allow Retriggering of this Channel) 1 = Run for One Block Transfer 0 = Run for Multiple Block Transfer
#define APBDMACHAN_CHANNEL_15_CSR_0_ONCE_SHIFT                  _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_15_CSR_0_ONCE_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_15_CSR_0_ONCE_SHIFT)
#define APBDMACHAN_CHANNEL_15_CSR_0_ONCE_RANGE                  27:27
#define APBDMACHAN_CHANNEL_15_CSR_0_ONCE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_15_CSR_0_ONCE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_ONCE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_15_CSR_0_ONCE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_ONCE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_ONCE_MULTIPLE_BLOCK                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_CSR_0_ONCE_SINGLE_BLOCK                   _MK_ENUM_CONST(1)

// Enable on Non-Zero Value
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_SHIFT                      _MK_SHIFT_CONST(22)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_FIELD                      (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_RANGE                      26:22
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_NA1                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_SMP24                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_SMP25                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_SMP26                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_SMP27                      _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_XRQ_A                      _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_XRQ_B                      _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_TMR1                       _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_TMR2                       _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_APB_0                      _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_APB_1                      _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_APB_2                      _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_APB_3                      _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_APB_4                      _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_APB_5                      _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_APB_6                      _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_APB_7                      _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_APB_8                      _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_APB_9                      _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_APB_10                     _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_APB_11                     _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_APB_12                     _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_APB_13                     _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_APB_14                     _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_15_CSR_0_TRIG_SEL_APB_15                     _MK_ENUM_CONST(24)

// Flow Control Enable (Synchronize Burst Transfers) 1 = Link to DRQ source 0 = Independent of DRQ request
#define APBDMACHAN_CHANNEL_15_CSR_0_FLOW_SHIFT                  _MK_SHIFT_CONST(21)
#define APBDMACHAN_CHANNEL_15_CSR_0_FLOW_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_15_CSR_0_FLOW_SHIFT)
#define APBDMACHAN_CHANNEL_15_CSR_0_FLOW_RANGE                  21:21
#define APBDMACHAN_CHANNEL_15_CSR_0_FLOW_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_15_CSR_0_FLOW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_FLOW_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_15_CSR_0_FLOW_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_FLOW_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_FLOW_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_CSR_0_FLOW_ENABLE                 _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_FIELD                       (_MK_MASK_CONST(0x1f) << APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_SHIFT)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_RANGE                       20:16
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_CNTR_REQ                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_I2S_2                       _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_I2S_1                       _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_SPD_I                       _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_UI_I                        _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_MIPI                        _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_I2S2_2                      _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_I2S2_1                      _MK_ENUM_CONST(7)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_UART_A                      _MK_ENUM_CONST(8)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_UART_B                      _MK_ENUM_CONST(9)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_UART_C                      _MK_ENUM_CONST(10)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_SPI                 _MK_ENUM_CONST(11)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_AC97                        _MK_ENUM_CONST(12)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_ACModem                     _MK_ENUM_CONST(13)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_SL4B                        _MK_ENUM_CONST(14)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_SL2B1                       _MK_ENUM_CONST(15)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_SL2B2                       _MK_ENUM_CONST(16)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_SL2B3                       _MK_ENUM_CONST(17)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_SL2B4                       _MK_ENUM_CONST(18)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_UART_D                      _MK_ENUM_CONST(19)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_UART_E                      _MK_ENUM_CONST(20)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_I2C                 _MK_ENUM_CONST(21)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_I2C2                        _MK_ENUM_CONST(22)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_I2C3                        _MK_ENUM_CONST(23)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_DVC_I2C                     _MK_ENUM_CONST(24)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_OWR                 _MK_ENUM_CONST(25)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_NA26                        _MK_ENUM_CONST(26)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_NA27                        _MK_ENUM_CONST(27)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_NA28                        _MK_ENUM_CONST(28)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_NA29                        _MK_ENUM_CONST(29)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_NA30                        _MK_ENUM_CONST(30)
#define APBDMACHAN_CHANNEL_15_CSR_0_REQ_SEL_NA31                        _MK_ENUM_CONST(31)

// Number of 32bit word cycles
#define APBDMACHAN_CHANNEL_15_CSR_0_WCOUNT_SHIFT                        _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_15_CSR_0_WCOUNT_FIELD                        (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_15_CSR_0_WCOUNT_SHIFT)
#define APBDMACHAN_CHANNEL_15_CSR_0_WCOUNT_RANGE                        15:2
#define APBDMACHAN_CHANNEL_15_CSR_0_WCOUNT_WOFFSET                      0x0
#define APBDMACHAN_CHANNEL_15_CSR_0_WCOUNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_WCOUNT_DEFAULT_MASK                 _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_15_CSR_0_WCOUNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_CSR_0_WCOUNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_15_STA_0  
#define APBDMACHAN_CHANNEL_15_STA_0                     _MK_ADDR_CONST(0x1e4)
#define APBDMACHAN_CHANNEL_15_STA_0_SECURE                      0x0
#define APBDMACHAN_CHANNEL_15_STA_0_WORD_COUNT                  0x1
#define APBDMACHAN_CHANNEL_15_STA_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_RESET_MASK                  _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_15_STA_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_READ_MASK                   _MK_MASK_CONST(0xf000fffc)
#define APBDMACHAN_CHANNEL_15_STA_0_WRITE_MASK                  _MK_MASK_CONST(0x40000000)
// indicate DMA Channel Status activated or not 
#define APBDMACHAN_CHANNEL_15_STA_0_BSY_SHIFT                   _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_15_STA_0_BSY_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_15_STA_0_BSY_SHIFT)
#define APBDMACHAN_CHANNEL_15_STA_0_BSY_RANGE                   31:31
#define APBDMACHAN_CHANNEL_15_STA_0_BSY_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_15_STA_0_BSY_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_BSY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_15_STA_0_BSY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_BSY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_BSY_WAIT                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_STA_0_BSY_ACTIVE                  _MK_ENUM_CONST(1)

//  Write '1' to clear the flag
#define APBDMACHAN_CHANNEL_15_STA_0_ISE_EOC_SHIFT                       _MK_SHIFT_CONST(30)
#define APBDMACHAN_CHANNEL_15_STA_0_ISE_EOC_FIELD                       (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_15_STA_0_ISE_EOC_SHIFT)
#define APBDMACHAN_CHANNEL_15_STA_0_ISE_EOC_RANGE                       30:30
#define APBDMACHAN_CHANNEL_15_STA_0_ISE_EOC_WOFFSET                     0x0
#define APBDMACHAN_CHANNEL_15_STA_0_ISE_EOC_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_ISE_EOC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_15_STA_0_ISE_EOC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_ISE_EOC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_ISE_EOC_NO_INTR                     _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_STA_0_ISE_EOC_INTR                        _MK_ENUM_CONST(1)

// Holding Status of Processor 
#define APBDMACHAN_CHANNEL_15_STA_0_HALT_SHIFT                  _MK_SHIFT_CONST(29)
#define APBDMACHAN_CHANNEL_15_STA_0_HALT_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_15_STA_0_HALT_SHIFT)
#define APBDMACHAN_CHANNEL_15_STA_0_HALT_RANGE                  29:29
#define APBDMACHAN_CHANNEL_15_STA_0_HALT_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_15_STA_0_HALT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_HALT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_15_STA_0_HALT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_HALT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_HALT_NO_HALT                        _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_STA_0_HALT_HALT                   _MK_ENUM_CONST(1)

#define APBDMACHAN_CHANNEL_15_STA_0_PING_PONG_STA_SHIFT                 _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_15_STA_0_PING_PONG_STA_FIELD                 (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_15_STA_0_PING_PONG_STA_SHIFT)
#define APBDMACHAN_CHANNEL_15_STA_0_PING_PONG_STA_RANGE                 28:28
#define APBDMACHAN_CHANNEL_15_STA_0_PING_PONG_STA_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_15_STA_0_PING_PONG_STA_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_PING_PONG_STA_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_15_STA_0_PING_PONG_STA_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_PING_PONG_STA_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_PING_PONG_STA_PING_INTR_STA                 _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_STA_0_PING_PONG_STA_PONG_INTR_STA                 _MK_ENUM_CONST(1)

// Current 32bit word cycles Flags set /cleared by HW
#define APBDMACHAN_CHANNEL_15_STA_0_COUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_15_STA_0_COUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_15_STA_0_COUNT_SHIFT)
#define APBDMACHAN_CHANNEL_15_STA_0_COUNT_RANGE                 15:2
#define APBDMACHAN_CHANNEL_15_STA_0_COUNT_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_15_STA_0_COUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_COUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_15_STA_0_COUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_STA_0_COUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 488 [0x1e8] 

// Reserved address 492 [0x1ec] 

// Register APBDMACHAN_CHANNEL_15_AHB_PTR_0  
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0                 _MK_ADDR_CONST(0x1f0)
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0_RESET_MASK                      _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0_READ_MASK                       _MK_MASK_CONST(0xfffffffc)
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0_WRITE_MASK                      _MK_MASK_CONST(0xfffffffc)
// APB-DMA Starting Address for AHB Bus: SW writes to  modify
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0_AHB_BASE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0_AHB_BASE_FIELD                  (_MK_MASK_CONST(0x3fffffff) << APBDMACHAN_CHANNEL_15_AHB_PTR_0_AHB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0_AHB_BASE_RANGE                  31:2
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0_AHB_BASE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0_AHB_BASE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0_AHB_BASE_DEFAULT_MASK                   _MK_MASK_CONST(0x3fffffff)
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0_AHB_BASE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_PTR_0_AHB_BASE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_15_AHB_SEQ_0  
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0                 _MK_ADDR_CONST(0x1f4)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_RESET_VAL                       _MK_MASK_CONST(0x20000000)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_RESET_MASK                      _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_READ_MASK                       _MK_MASK_CONST(0xff0f0000)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRITE_MASK                      _MK_MASK_CONST(0xff0f0000)
//  0 = send interrupt to COP
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_INTR_ENB_SHIFT                  _MK_SHIFT_CONST(31)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_INTR_ENB_FIELD                  (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_15_AHB_SEQ_0_INTR_ENB_SHIFT)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_INTR_ENB_RANGE                  31:31
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_INTR_ENB_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_INTR_ENB_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_INTR_ENB_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_INTR_ENB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_INTR_ENB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_INTR_ENB_CPU                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_INTR_ENB_COP                    _MK_ENUM_CONST(0)

// AHB Bus Width 0 = 8 bit Bus (RSVD) 1 = 16 bit Bus (RSVD) 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD)4 = 128 bit Bus (RSVD)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT                     _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BUS_WIDTH_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BUS_WIDTH_RANGE                     30:28
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BUS_WIDTH_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT                   _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BUS_WIDTH_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BUS_WIDTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_8                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_16                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_32                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_64                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BUS_WIDTH_BUS_WIDTH_128                     _MK_ENUM_CONST(4)

// When enabled the data going  to AHB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT                     _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_DATA_SWAP_FIELD                     (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_DATA_SWAP_RANGE                     27:27
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_DATA_SWAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_DATA_SWAP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_DATA_SWAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_DATA_SWAP_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_DATA_SWAP_ENABLE                    _MK_ENUM_CONST(1)

// AHB Burst Size DMA Burst Length (encoded) 4 = 1 Word (1x32bits) 5 = 4 Words (4x32bits)else = 8 Words (8x32bits) default
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BURST_SHIFT                 _MK_SHIFT_CONST(24)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BURST_FIELD                 (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BURST_SHIFT)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BURST_RANGE                 26:24
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BURST_WOFFSET                       0x0
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BURST_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BURST_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BURST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BURST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BURST_DMA_BURST_1WORDS                      _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BURST_DMA_BURST_4WORDS                      _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_AHB_BURST_DMA_BURST_8WORDS                      _MK_ENUM_CONST(6)

// 2X Double Buffering Mode (For Run-Multiple Mode with No Wrap Operations) 1 = Reload Base Address for 2X blocks (reload every other time) 0 = Reload Base Address for 1X blocks  (def) (reload each time)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_DBL_BUF_SHIFT                   _MK_SHIFT_CONST(19)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_DBL_BUF_FIELD                   (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_15_AHB_SEQ_0_DBL_BUF_SHIFT)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_DBL_BUF_RANGE                   19:19
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_DBL_BUF_WOFFSET                 0x0
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_DBL_BUF_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_DBL_BUF_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_DBL_BUF_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_DBL_BUF_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_1X_BLOCKS                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_DBL_BUF_RELOAD_FOR_2X_BLOCKS                    _MK_ENUM_CONST(1)

// AHB Address Wrap: AHB Address wrap-around window 0=No Wrap (default) 5=Wrap on 512 word window 1=Wrap on 32 word window 6=Wrap on 1024 word window 2=Wrap on 64 word window 7=Wrap on 2048 word window 3=Wrap on 128 word window 4=Wrap on 256 word window
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_FIELD                      (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_RANGE                      18:16
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_WOFFSET                    0x0
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_NO_WRAP                    _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_WRAP_0N_32WORDS                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_WRAP_ON_64WORDS                    _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_WRAP_ON_128WORDS                   _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_WRAP_ON_256WORDS                   _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_WRAP_ON_512WORDS                   _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_WRAP_ON_1024WORDS                  _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_15_AHB_SEQ_0_WRAP_WRAP_ON_2048WORDS                  _MK_ENUM_CONST(7)


// Register APBDMACHAN_CHANNEL_15_APB_PTR_0  
#define APBDMACHAN_CHANNEL_15_APB_PTR_0                 _MK_ADDR_CONST(0x1f8)
#define APBDMACHAN_CHANNEL_15_APB_PTR_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_15_APB_PTR_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_15_APB_PTR_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_APB_PTR_0_RESET_MASK                      _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_15_APB_PTR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_APB_PTR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_APB_PTR_0_READ_MASK                       _MK_MASK_CONST(0xfffc)
#define APBDMACHAN_CHANNEL_15_APB_PTR_0_WRITE_MASK                      _MK_MASK_CONST(0xfffc)
// APB-DMA Starting address for APB Bus: APB Base address:Upper 16 bits are fixed at 0x7000:XXXX
#define APBDMACHAN_CHANNEL_15_APB_PTR_0_APB_BASE_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMACHAN_CHANNEL_15_APB_PTR_0_APB_BASE_FIELD                  (_MK_MASK_CONST(0x3fff) << APBDMACHAN_CHANNEL_15_APB_PTR_0_APB_BASE_SHIFT)
#define APBDMACHAN_CHANNEL_15_APB_PTR_0_APB_BASE_RANGE                  15:2
#define APBDMACHAN_CHANNEL_15_APB_PTR_0_APB_BASE_WOFFSET                        0x0
#define APBDMACHAN_CHANNEL_15_APB_PTR_0_APB_BASE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_APB_PTR_0_APB_BASE_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define APBDMACHAN_CHANNEL_15_APB_PTR_0_APB_BASE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_APB_PTR_0_APB_BASE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDMACHAN_CHANNEL_15_APB_SEQ_0  
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0                 _MK_ADDR_CONST(0x1fc)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_SECURE                  0x0
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_WORD_COUNT                      0x1
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_RESET_VAL                       _MK_MASK_CONST(0x20010000)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_RESET_MASK                      _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_READ_MASK                       _MK_MASK_CONST(0x78070000)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_WRITE_MASK                      _MK_MASK_CONST(0x78070000)
// 0 = 8 bit Bus 1 = 16 bit Bus 2 = 32 bit Bus (Def) 3 = 64 bit Bus (RSVD) 4 = 128 bit BUS (RSVD)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_BUS_WIDTH_SHIFT                     _MK_SHIFT_CONST(28)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_BUS_WIDTH_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_BUS_WIDTH_SHIFT)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_BUS_WIDTH_RANGE                     30:28
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_BUS_WIDTH_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT                   _MK_MASK_CONST(0x2)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_BUS_WIDTH_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_BUS_WIDTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_8                       _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_16                      _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_32                      _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_64                      _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_BUS_WIDTH_BUS_WIDTH_128                     _MK_ENUM_CONST(4)

// When enabled the data going  to APB gets swapped as [31:0] --> {[7:0], [15:8], [23:16], [31:24] }.
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_DATA_SWAP_SHIFT                     _MK_SHIFT_CONST(27)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_DATA_SWAP_FIELD                     (_MK_MASK_CONST(0x1) << APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_DATA_SWAP_SHIFT)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_DATA_SWAP_RANGE                     27:27
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_DATA_SWAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_DATA_SWAP_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_DATA_SWAP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_DATA_SWAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_DATA_SWAP_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_DATA_SWAP_ENABLE                    _MK_ENUM_CONST(1)

//APB Address Wrap-around Window 0 = No Wrap 1 = Wrap on 1 Word Window (def) 2 = Wrap on 2 Word Window 3 = Wrap on 4 Word Window 4 = Wrap on 8 Word Window 5 = Wrap on 16 Word Window 6 = Wrap on 32 Word Window 7 = Wrap on 64 Word Window (rsvd)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_SHIFT                     _MK_SHIFT_CONST(16)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_FIELD                     (_MK_MASK_CONST(0x7) << APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_SHIFT)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_RANGE                     18:16
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_WOFFSET                   0x0
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_NO_WRAP                   _MK_ENUM_CONST(0)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_WRAP_0N_1WORDS                    _MK_ENUM_CONST(1)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_2WORDS                    _MK_ENUM_CONST(2)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_4WORDS                    _MK_ENUM_CONST(3)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_8WORDS                    _MK_ENUM_CONST(4)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_16WORDS                   _MK_ENUM_CONST(5)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_32WORDS                   _MK_ENUM_CONST(6)
#define APBDMACHAN_CHANNEL_15_APB_SEQ_0_APB_ADDR_WRAP_WRAP_ON_64WORDS                   _MK_ENUM_CONST(7)


//
// REGISTER LIST
//
#define LIST_ARAPBDMACHAN_REGS(_op_) \
_op_(APBDMACHAN_CHANNEL_0_CSR_0) \
_op_(APBDMACHAN_CHANNEL_0_STA_0) \
_op_(APBDMACHAN_CHANNEL_0_AHB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_0_AHB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_0_APB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_0_APB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_1_CSR_0) \
_op_(APBDMACHAN_CHANNEL_1_STA_0) \
_op_(APBDMACHAN_CHANNEL_1_AHB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_1_AHB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_1_APB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_1_APB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_2_CSR_0) \
_op_(APBDMACHAN_CHANNEL_2_STA_0) \
_op_(APBDMACHAN_CHANNEL_2_AHB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_2_AHB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_2_APB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_2_APB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_3_CSR_0) \
_op_(APBDMACHAN_CHANNEL_3_STA_0) \
_op_(APBDMACHAN_CHANNEL_3_AHB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_3_AHB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_3_APB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_3_APB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_4_CSR_0) \
_op_(APBDMACHAN_CHANNEL_4_STA_0) \
_op_(APBDMACHAN_CHANNEL_4_AHB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_4_AHB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_4_APB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_4_APB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_5_CSR_0) \
_op_(APBDMACHAN_CHANNEL_5_STA_0) \
_op_(APBDMACHAN_CHANNEL_5_AHB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_5_AHB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_5_APB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_5_APB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_6_CSR_0) \
_op_(APBDMACHAN_CHANNEL_6_STA_0) \
_op_(APBDMACHAN_CHANNEL_6_AHB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_6_AHB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_6_APB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_6_APB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_7_CSR_0) \
_op_(APBDMACHAN_CHANNEL_7_STA_0) \
_op_(APBDMACHAN_CHANNEL_7_AHB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_7_AHB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_7_APB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_7_APB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_8_CSR_0) \
_op_(APBDMACHAN_CHANNEL_8_STA_0) \
_op_(APBDMACHAN_CHANNEL_8_AHB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_8_AHB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_8_APB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_8_APB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_9_CSR_0) \
_op_(APBDMACHAN_CHANNEL_9_STA_0) \
_op_(APBDMACHAN_CHANNEL_9_AHB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_9_AHB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_9_APB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_9_APB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_10_CSR_0) \
_op_(APBDMACHAN_CHANNEL_10_STA_0) \
_op_(APBDMACHAN_CHANNEL_10_AHB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_10_AHB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_10_APB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_10_APB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_11_CSR_0) \
_op_(APBDMACHAN_CHANNEL_11_STA_0) \
_op_(APBDMACHAN_CHANNEL_11_AHB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_11_AHB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_11_APB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_11_APB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_12_CSR_0) \
_op_(APBDMACHAN_CHANNEL_12_STA_0) \
_op_(APBDMACHAN_CHANNEL_12_AHB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_12_AHB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_12_APB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_12_APB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_13_CSR_0) \
_op_(APBDMACHAN_CHANNEL_13_STA_0) \
_op_(APBDMACHAN_CHANNEL_13_AHB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_13_AHB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_13_APB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_13_APB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_14_CSR_0) \
_op_(APBDMACHAN_CHANNEL_14_STA_0) \
_op_(APBDMACHAN_CHANNEL_14_AHB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_14_AHB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_14_APB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_14_APB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_15_CSR_0) \
_op_(APBDMACHAN_CHANNEL_15_STA_0) \
_op_(APBDMACHAN_CHANNEL_15_AHB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_15_AHB_SEQ_0) \
_op_(APBDMACHAN_CHANNEL_15_APB_PTR_0) \
_op_(APBDMACHAN_CHANNEL_15_APB_SEQ_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_APBDMACHAN 0x00000000

//
// ARAPBDMACHAN REGISTER BANKS
//

#define APBDMACHAN0_FIRST_REG 0x0000 // APBDMACHAN_CHANNEL_0_CSR_0
#define APBDMACHAN0_LAST_REG 0x0004 // APBDMACHAN_CHANNEL_0_STA_0
#define APBDMACHAN1_FIRST_REG 0x0010 // APBDMACHAN_CHANNEL_0_AHB_PTR_0
#define APBDMACHAN1_LAST_REG 0x0024 // APBDMACHAN_CHANNEL_1_STA_0
#define APBDMACHAN2_FIRST_REG 0x0030 // APBDMACHAN_CHANNEL_1_AHB_PTR_0
#define APBDMACHAN2_LAST_REG 0x0044 // APBDMACHAN_CHANNEL_2_STA_0
#define APBDMACHAN3_FIRST_REG 0x0050 // APBDMACHAN_CHANNEL_2_AHB_PTR_0
#define APBDMACHAN3_LAST_REG 0x0064 // APBDMACHAN_CHANNEL_3_STA_0
#define APBDMACHAN4_FIRST_REG 0x0070 // APBDMACHAN_CHANNEL_3_AHB_PTR_0
#define APBDMACHAN4_LAST_REG 0x0084 // APBDMACHAN_CHANNEL_4_STA_0
#define APBDMACHAN5_FIRST_REG 0x0090 // APBDMACHAN_CHANNEL_4_AHB_PTR_0
#define APBDMACHAN5_LAST_REG 0x00a4 // APBDMACHAN_CHANNEL_5_STA_0
#define APBDMACHAN6_FIRST_REG 0x00b0 // APBDMACHAN_CHANNEL_5_AHB_PTR_0
#define APBDMACHAN6_LAST_REG 0x00c4 // APBDMACHAN_CHANNEL_6_STA_0
#define APBDMACHAN7_FIRST_REG 0x00d0 // APBDMACHAN_CHANNEL_6_AHB_PTR_0
#define APBDMACHAN7_LAST_REG 0x00e4 // APBDMACHAN_CHANNEL_7_STA_0
#define APBDMACHAN8_FIRST_REG 0x00f0 // APBDMACHAN_CHANNEL_7_AHB_PTR_0
#define APBDMACHAN8_LAST_REG 0x0104 // APBDMACHAN_CHANNEL_8_STA_0
#define APBDMACHAN9_FIRST_REG 0x0110 // APBDMACHAN_CHANNEL_8_AHB_PTR_0
#define APBDMACHAN9_LAST_REG 0x0124 // APBDMACHAN_CHANNEL_9_STA_0
#define APBDMACHAN10_FIRST_REG 0x0130 // APBDMACHAN_CHANNEL_9_AHB_PTR_0
#define APBDMACHAN10_LAST_REG 0x0144 // APBDMACHAN_CHANNEL_10_STA_0
#define APBDMACHAN11_FIRST_REG 0x0150 // APBDMACHAN_CHANNEL_10_AHB_PTR_0
#define APBDMACHAN11_LAST_REG 0x0164 // APBDMACHAN_CHANNEL_11_STA_0
#define APBDMACHAN12_FIRST_REG 0x0170 // APBDMACHAN_CHANNEL_11_AHB_PTR_0
#define APBDMACHAN12_LAST_REG 0x0184 // APBDMACHAN_CHANNEL_12_STA_0
#define APBDMACHAN13_FIRST_REG 0x0190 // APBDMACHAN_CHANNEL_12_AHB_PTR_0
#define APBDMACHAN13_LAST_REG 0x01a4 // APBDMACHAN_CHANNEL_13_STA_0
#define APBDMACHAN14_FIRST_REG 0x01b0 // APBDMACHAN_CHANNEL_13_AHB_PTR_0
#define APBDMACHAN14_LAST_REG 0x01c4 // APBDMACHAN_CHANNEL_14_STA_0
#define APBDMACHAN15_FIRST_REG 0x01d0 // APBDMACHAN_CHANNEL_14_AHB_PTR_0
#define APBDMACHAN15_LAST_REG 0x01e4 // APBDMACHAN_CHANNEL_15_STA_0
#define APBDMACHAN16_FIRST_REG 0x01f0 // APBDMACHAN_CHANNEL_15_AHB_PTR_0
#define APBDMACHAN16_LAST_REG 0x01fc // APBDMACHAN_CHANNEL_15_APB_SEQ_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARAPBDMACHAN_H_INC_
