/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___AREVP_H_INC_
#define ___AREVP_H_INC_

// Register EVP_RESET_VECTOR_0  
#define EVP_RESET_VECTOR_0                      _MK_ADDR_CONST(0x0)
#define EVP_RESET_VECTOR_0_SECURE                       0x0
#define EVP_RESET_VECTOR_0_WORD_COUNT                   0x1
#define EVP_RESET_VECTOR_0_RESET_VAL                    _MK_MASK_CONST(0xfff00000)
#define EVP_RESET_VECTOR_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_RESET_VECTOR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EVP_RESET_VECTOR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EVP_RESET_VECTOR_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define EVP_RESET_VECTOR_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
// RESET Exception Vector Pointer 
#define EVP_RESET_VECTOR_0_RESET_VECTOR_SHIFT                   _MK_SHIFT_CONST(0)
#define EVP_RESET_VECTOR_0_RESET_VECTOR_FIELD                   (_MK_MASK_CONST(0xffffffff) << EVP_RESET_VECTOR_0_RESET_VECTOR_SHIFT)
#define EVP_RESET_VECTOR_0_RESET_VECTOR_RANGE                   31:0
#define EVP_RESET_VECTOR_0_RESET_VECTOR_WOFFSET                 0x0
#define EVP_RESET_VECTOR_0_RESET_VECTOR_DEFAULT                 _MK_MASK_CONST(0xfff00000)
#define EVP_RESET_VECTOR_0_RESET_VECTOR_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define EVP_RESET_VECTOR_0_RESET_VECTOR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EVP_RESET_VECTOR_0_RESET_VECTOR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EVP_RESET_VECTOR_0_RESET_VECTOR_INIT_ENUM                       -1048576


// Register EVP_UNDEF_VECTOR_0  
#define EVP_UNDEF_VECTOR_0                      _MK_ADDR_CONST(0x4)
#define EVP_UNDEF_VECTOR_0_SECURE                       0x0
#define EVP_UNDEF_VECTOR_0_WORD_COUNT                   0x1
#define EVP_UNDEF_VECTOR_0_RESET_VAL                    _MK_MASK_CONST(0xfff00004)
#define EVP_UNDEF_VECTOR_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_UNDEF_VECTOR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EVP_UNDEF_VECTOR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EVP_UNDEF_VECTOR_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define EVP_UNDEF_VECTOR_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
// Undefined Exception Vector Pointer
#define EVP_UNDEF_VECTOR_0_UNDEF_VECTOR_SHIFT                   _MK_SHIFT_CONST(0)
#define EVP_UNDEF_VECTOR_0_UNDEF_VECTOR_FIELD                   (_MK_MASK_CONST(0xffffffff) << EVP_UNDEF_VECTOR_0_UNDEF_VECTOR_SHIFT)
#define EVP_UNDEF_VECTOR_0_UNDEF_VECTOR_RANGE                   31:0
#define EVP_UNDEF_VECTOR_0_UNDEF_VECTOR_WOFFSET                 0x0
#define EVP_UNDEF_VECTOR_0_UNDEF_VECTOR_DEFAULT                 _MK_MASK_CONST(0xfff00004)
#define EVP_UNDEF_VECTOR_0_UNDEF_VECTOR_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define EVP_UNDEF_VECTOR_0_UNDEF_VECTOR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EVP_UNDEF_VECTOR_0_UNDEF_VECTOR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EVP_UNDEF_VECTOR_0_UNDEF_VECTOR_INIT_ENUM                       -1048572


// Register EVP_SWI_VECTOR_0  
#define EVP_SWI_VECTOR_0                        _MK_ADDR_CONST(0x8)
#define EVP_SWI_VECTOR_0_SECURE                         0x0
#define EVP_SWI_VECTOR_0_WORD_COUNT                     0x1
#define EVP_SWI_VECTOR_0_RESET_VAL                      _MK_MASK_CONST(0xfff00008)
#define EVP_SWI_VECTOR_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define EVP_SWI_VECTOR_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EVP_SWI_VECTOR_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EVP_SWI_VECTOR_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_SWI_VECTOR_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
// Software Interrupt Vector Pointer
#define EVP_SWI_VECTOR_0_SWI_VECTOR_SHIFT                       _MK_SHIFT_CONST(0)
#define EVP_SWI_VECTOR_0_SWI_VECTOR_FIELD                       (_MK_MASK_CONST(0xffffffff) << EVP_SWI_VECTOR_0_SWI_VECTOR_SHIFT)
#define EVP_SWI_VECTOR_0_SWI_VECTOR_RANGE                       31:0
#define EVP_SWI_VECTOR_0_SWI_VECTOR_WOFFSET                     0x0
#define EVP_SWI_VECTOR_0_SWI_VECTOR_DEFAULT                     _MK_MASK_CONST(0xfff00008)
#define EVP_SWI_VECTOR_0_SWI_VECTOR_DEFAULT_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_SWI_VECTOR_0_SWI_VECTOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EVP_SWI_VECTOR_0_SWI_VECTOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_SWI_VECTOR_0_SWI_VECTOR_INIT_ENUM                   -1048568


// Register EVP_PREFETCH_ABORT_VECTOR_0  
#define EVP_PREFETCH_ABORT_VECTOR_0                     _MK_ADDR_CONST(0xc)
#define EVP_PREFETCH_ABORT_VECTOR_0_SECURE                      0x0
#define EVP_PREFETCH_ABORT_VECTOR_0_WORD_COUNT                  0x1
#define EVP_PREFETCH_ABORT_VECTOR_0_RESET_VAL                   _MK_MASK_CONST(0xfff0000c)
#define EVP_PREFETCH_ABORT_VECTOR_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PREFETCH_ABORT_VECTOR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PREFETCH_ABORT_VECTOR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PREFETCH_ABORT_VECTOR_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PREFETCH_ABORT_VECTOR_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Code Prefetch ABORT Vector Pointer 
#define EVP_PREFETCH_ABORT_VECTOR_0_PRE_ABORT_VECTOR_SHIFT                      _MK_SHIFT_CONST(0)
#define EVP_PREFETCH_ABORT_VECTOR_0_PRE_ABORT_VECTOR_FIELD                      (_MK_MASK_CONST(0xffffffff) << EVP_PREFETCH_ABORT_VECTOR_0_PRE_ABORT_VECTOR_SHIFT)
#define EVP_PREFETCH_ABORT_VECTOR_0_PRE_ABORT_VECTOR_RANGE                      31:0
#define EVP_PREFETCH_ABORT_VECTOR_0_PRE_ABORT_VECTOR_WOFFSET                    0x0
#define EVP_PREFETCH_ABORT_VECTOR_0_PRE_ABORT_VECTOR_DEFAULT                    _MK_MASK_CONST(0xfff0000c)
#define EVP_PREFETCH_ABORT_VECTOR_0_PRE_ABORT_VECTOR_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_PREFETCH_ABORT_VECTOR_0_PRE_ABORT_VECTOR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EVP_PREFETCH_ABORT_VECTOR_0_PRE_ABORT_VECTOR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EVP_PREFETCH_ABORT_VECTOR_0_PRE_ABORT_VECTOR_INIT_ENUM                  -1048564


// Register EVP_DATA_ABORT_VECTOR_0  
#define EVP_DATA_ABORT_VECTOR_0                 _MK_ADDR_CONST(0x10)
#define EVP_DATA_ABORT_VECTOR_0_SECURE                  0x0
#define EVP_DATA_ABORT_VECTOR_0_WORD_COUNT                      0x1
#define EVP_DATA_ABORT_VECTOR_0_RESET_VAL                       _MK_MASK_CONST(0xfff00010)
#define EVP_DATA_ABORT_VECTOR_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_DATA_ABORT_VECTOR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_DATA_ABORT_VECTOR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_DATA_ABORT_VECTOR_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_DATA_ABORT_VECTOR_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
// Data ABORT Vector Pointer
#define EVP_DATA_ABORT_VECTOR_0_DATA_ABORT_VECTOR_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_DATA_ABORT_VECTOR_0_DATA_ABORT_VECTOR_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_DATA_ABORT_VECTOR_0_DATA_ABORT_VECTOR_SHIFT)
#define EVP_DATA_ABORT_VECTOR_0_DATA_ABORT_VECTOR_RANGE                 31:0
#define EVP_DATA_ABORT_VECTOR_0_DATA_ABORT_VECTOR_WOFFSET                       0x0
#define EVP_DATA_ABORT_VECTOR_0_DATA_ABORT_VECTOR_DEFAULT                       _MK_MASK_CONST(0xfff00010)
#define EVP_DATA_ABORT_VECTOR_0_DATA_ABORT_VECTOR_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_DATA_ABORT_VECTOR_0_DATA_ABORT_VECTOR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_DATA_ABORT_VECTOR_0_DATA_ABORT_VECTOR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EVP_DATA_ABORT_VECTOR_0_DATA_ABORT_VECTOR_INIT_ENUM                     -1048560


// Register EVP_RSVD_VECTOR_0  
#define EVP_RSVD_VECTOR_0                       _MK_ADDR_CONST(0x14)
#define EVP_RSVD_VECTOR_0_SECURE                        0x0
#define EVP_RSVD_VECTOR_0_WORD_COUNT                    0x1
#define EVP_RSVD_VECTOR_0_RESET_VAL                     _MK_MASK_CONST(0xfff00014)
#define EVP_RSVD_VECTOR_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define EVP_RSVD_VECTOR_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EVP_RSVD_VECTOR_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EVP_RSVD_VECTOR_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define EVP_RSVD_VECTOR_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Reserved Exception Vector Pointer
#define EVP_RSVD_VECTOR_0_RSVD_VECTOR_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_RSVD_VECTOR_0_RSVD_VECTOR_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_RSVD_VECTOR_0_RSVD_VECTOR_SHIFT)
#define EVP_RSVD_VECTOR_0_RSVD_VECTOR_RANGE                     31:0
#define EVP_RSVD_VECTOR_0_RSVD_VECTOR_WOFFSET                   0x0
#define EVP_RSVD_VECTOR_0_RSVD_VECTOR_DEFAULT                   _MK_MASK_CONST(0xfff00014)
#define EVP_RSVD_VECTOR_0_RSVD_VECTOR_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_RSVD_VECTOR_0_RSVD_VECTOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_RSVD_VECTOR_0_RSVD_VECTOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EVP_RSVD_VECTOR_0_RSVD_VECTOR_INIT_ENUM                 -1048556


// Register EVP_IRQ_VECTOR_0  
#define EVP_IRQ_VECTOR_0                        _MK_ADDR_CONST(0x18)
#define EVP_IRQ_VECTOR_0_SECURE                         0x0
#define EVP_IRQ_VECTOR_0_WORD_COUNT                     0x1
#define EVP_IRQ_VECTOR_0_RESET_VAL                      _MK_MASK_CONST(0xfff00018)
#define EVP_IRQ_VECTOR_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define EVP_IRQ_VECTOR_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EVP_IRQ_VECTOR_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EVP_IRQ_VECTOR_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_IRQ_VECTOR_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
// IRQ Vector Pointer 
#define EVP_IRQ_VECTOR_0_IRQ_VECTOR_SHIFT                       _MK_SHIFT_CONST(0)
#define EVP_IRQ_VECTOR_0_IRQ_VECTOR_FIELD                       (_MK_MASK_CONST(0xffffffff) << EVP_IRQ_VECTOR_0_IRQ_VECTOR_SHIFT)
#define EVP_IRQ_VECTOR_0_IRQ_VECTOR_RANGE                       31:0
#define EVP_IRQ_VECTOR_0_IRQ_VECTOR_WOFFSET                     0x0
#define EVP_IRQ_VECTOR_0_IRQ_VECTOR_DEFAULT                     _MK_MASK_CONST(0xfff00018)
#define EVP_IRQ_VECTOR_0_IRQ_VECTOR_DEFAULT_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_IRQ_VECTOR_0_IRQ_VECTOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EVP_IRQ_VECTOR_0_IRQ_VECTOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_IRQ_VECTOR_0_IRQ_VECTOR_INIT_ENUM                   -1048552


// Register EVP_FIQ_VECTOR_0  
#define EVP_FIQ_VECTOR_0                        _MK_ADDR_CONST(0x1c)
#define EVP_FIQ_VECTOR_0_SECURE                         0x0
#define EVP_FIQ_VECTOR_0_WORD_COUNT                     0x1
#define EVP_FIQ_VECTOR_0_RESET_VAL                      _MK_MASK_CONST(0xfff00000)
#define EVP_FIQ_VECTOR_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define EVP_FIQ_VECTOR_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EVP_FIQ_VECTOR_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EVP_FIQ_VECTOR_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_FIQ_VECTOR_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
// FIQ Vector Pointer 
#define EVP_FIQ_VECTOR_0_FIQ_VECTOR_SHIFT                       _MK_SHIFT_CONST(0)
#define EVP_FIQ_VECTOR_0_FIQ_VECTOR_FIELD                       (_MK_MASK_CONST(0xffffffff) << EVP_FIQ_VECTOR_0_FIQ_VECTOR_SHIFT)
#define EVP_FIQ_VECTOR_0_FIQ_VECTOR_RANGE                       31:0
#define EVP_FIQ_VECTOR_0_FIQ_VECTOR_WOFFSET                     0x0
#define EVP_FIQ_VECTOR_0_FIQ_VECTOR_DEFAULT                     _MK_MASK_CONST(0xfff00000)
#define EVP_FIQ_VECTOR_0_FIQ_VECTOR_DEFAULT_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_FIQ_VECTOR_0_FIQ_VECTOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EVP_FIQ_VECTOR_0_FIQ_VECTOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_FIQ_VECTOR_0_FIQ_VECTOR_INIT_ENUM                   -1048576


// Register EVP_IRQ_STS_0  
#define EVP_IRQ_STS_0                   _MK_ADDR_CONST(0x20)
#define EVP_IRQ_STS_0_SECURE                    0x0
#define EVP_IRQ_STS_0_WORD_COUNT                        0x1
#define EVP_IRQ_STS_0_RESET_VAL                         _MK_MASK_CONST(0x80)
#define EVP_IRQ_STS_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_IRQ_STS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EVP_IRQ_STS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EVP_IRQ_STS_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define EVP_IRQ_STS_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
// FFS (from lsb) IRQ index  (0x80 indicates no active IRQ)
#define EVP_IRQ_STS_0_IRQ_STS_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_IRQ_STS_0_IRQ_STS_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_IRQ_STS_0_IRQ_STS_SHIFT)
#define EVP_IRQ_STS_0_IRQ_STS_RANGE                     31:0
#define EVP_IRQ_STS_0_IRQ_STS_WOFFSET                   0x0
#define EVP_IRQ_STS_0_IRQ_STS_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_IRQ_STS_0_IRQ_STS_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_IRQ_STS_0_IRQ_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_IRQ_STS_0_IRQ_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_STS_0  
#define EVP_PRI_IRQ_STS_0                       _MK_ADDR_CONST(0x24)
#define EVP_PRI_IRQ_STS_0_SECURE                        0x0
#define EVP_PRI_IRQ_STS_0_WORD_COUNT                    0x1
#define EVP_PRI_IRQ_STS_0_RESET_VAL                     _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_STS_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_STS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_STS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_STS_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_STS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Current highest priority active IRQ (0x80 indicates no active priority IRQ)
#define EVP_PRI_IRQ_STS_0_PRI_IRQ_STS_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_STS_0_PRI_IRQ_STS_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_STS_0_PRI_IRQ_STS_SHIFT)
#define EVP_PRI_IRQ_STS_0_PRI_IRQ_STS_RANGE                     31:0
#define EVP_PRI_IRQ_STS_0_PRI_IRQ_STS_WOFFSET                   0x0
#define EVP_PRI_IRQ_STS_0_PRI_IRQ_STS_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_STS_0_PRI_IRQ_STS_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_STS_0_PRI_IRQ_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_STS_0_PRI_IRQ_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_FIQ_STS_0  
#define EVP_FIQ_STS_0                   _MK_ADDR_CONST(0x28)
#define EVP_FIQ_STS_0_SECURE                    0x0
#define EVP_FIQ_STS_0_WORD_COUNT                        0x1
#define EVP_FIQ_STS_0_RESET_VAL                         _MK_MASK_CONST(0x80)
#define EVP_FIQ_STS_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_FIQ_STS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EVP_FIQ_STS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EVP_FIQ_STS_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define EVP_FIQ_STS_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
// FFS (from lsb) FIQ index (0x80 indicates no active FIQ)
#define EVP_FIQ_STS_0_FIQ_STS_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_FIQ_STS_0_FIQ_STS_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_FIQ_STS_0_FIQ_STS_SHIFT)
#define EVP_FIQ_STS_0_FIQ_STS_RANGE                     31:0
#define EVP_FIQ_STS_0_FIQ_STS_WOFFSET                   0x0
#define EVP_FIQ_STS_0_FIQ_STS_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_FIQ_STS_0_FIQ_STS_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_FIQ_STS_0_FIQ_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_FIQ_STS_0_FIQ_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_PRI_FIQ_STS_0  
#define EVP_PRI_FIQ_STS_0                       _MK_ADDR_CONST(0x2c)
#define EVP_PRI_FIQ_STS_0_SECURE                        0x0
#define EVP_PRI_FIQ_STS_0_WORD_COUNT                    0x1
#define EVP_PRI_FIQ_STS_0_RESET_VAL                     _MK_MASK_CONST(0x80)
#define EVP_PRI_FIQ_STS_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_STS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_STS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_STS_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_STS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Current highest priority active FIQ (0x80 indicates no active priority FIQ)
#define EVP_PRI_FIQ_STS_0_PRI_FIQ_STS_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_PRI_FIQ_STS_0_PRI_FIQ_STS_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_PRI_FIQ_STS_0_PRI_FIQ_STS_SHIFT)
#define EVP_PRI_FIQ_STS_0_PRI_FIQ_STS_RANGE                     31:0
#define EVP_PRI_FIQ_STS_0_PRI_FIQ_STS_WOFFSET                   0x0
#define EVP_PRI_FIQ_STS_0_PRI_FIQ_STS_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_PRI_FIQ_STS_0_PRI_FIQ_STS_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_STS_0_PRI_FIQ_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_STS_0_PRI_FIQ_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_NUM_0_0  
#define EVP_PRI_IRQ_NUM_0_0                     _MK_ADDR_CONST(0x40)
#define EVP_PRI_IRQ_NUM_0_0_SECURE                      0x0
#define EVP_PRI_IRQ_NUM_0_0_WORD_COUNT                  0x1
#define EVP_PRI_IRQ_NUM_0_0_RESET_VAL                   _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_NUM_0_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_0_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_0_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_0_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_0_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Number for the Interrupt associated with this entry
#define EVP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_SHIFT)
#define EVP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_RANGE                 31:0
#define EVP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_WOFFSET                       0x0
#define EVP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_DEFAULT                       _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_VEC_0_0  
#define EVP_PRI_IRQ_VEC_0_0                     _MK_ADDR_CONST(0x44)
#define EVP_PRI_IRQ_VEC_0_0_SECURE                      0x0
#define EVP_PRI_IRQ_VEC_0_0_WORD_COUNT                  0x1
#define EVP_PRI_IRQ_VEC_0_0_RESET_VAL                   _MK_MASK_CONST(0x40000018)
#define EVP_PRI_IRQ_VEC_0_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_0_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_0_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_0_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_0_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_SHIFT)
#define EVP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_RANGE                 31:0
#define EVP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_WOFFSET                       0x0
#define EVP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_DEFAULT                       _MK_MASK_CONST(0x40000018)
#define EVP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_NUM_1_0  
#define EVP_PRI_IRQ_NUM_1_0                     _MK_ADDR_CONST(0x48)
#define EVP_PRI_IRQ_NUM_1_0_SECURE                      0x0
#define EVP_PRI_IRQ_NUM_1_0_WORD_COUNT                  0x1
#define EVP_PRI_IRQ_NUM_1_0_RESET_VAL                   _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_NUM_1_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_1_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_1_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Number for the Interrupt associated with this entry
#define EVP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_SHIFT)
#define EVP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_RANGE                 31:0
#define EVP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_WOFFSET                       0x0
#define EVP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_DEFAULT                       _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_VEC_1_0  
#define EVP_PRI_IRQ_VEC_1_0                     _MK_ADDR_CONST(0x4c)
#define EVP_PRI_IRQ_VEC_1_0_SECURE                      0x0
#define EVP_PRI_IRQ_VEC_1_0_WORD_COUNT                  0x1
#define EVP_PRI_IRQ_VEC_1_0_RESET_VAL                   _MK_MASK_CONST(0x40000018)
#define EVP_PRI_IRQ_VEC_1_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_1_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_1_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_SHIFT)
#define EVP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_RANGE                 31:0
#define EVP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_WOFFSET                       0x0
#define EVP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_DEFAULT                       _MK_MASK_CONST(0x40000018)
#define EVP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_NUM_2_0  
#define EVP_PRI_IRQ_NUM_2_0                     _MK_ADDR_CONST(0x50)
#define EVP_PRI_IRQ_NUM_2_0_SECURE                      0x0
#define EVP_PRI_IRQ_NUM_2_0_WORD_COUNT                  0x1
#define EVP_PRI_IRQ_NUM_2_0_RESET_VAL                   _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_NUM_2_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_2_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_2_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_2_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_2_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Number for the Interrupt associated with this entry
#define EVP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_SHIFT)
#define EVP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_RANGE                 31:0
#define EVP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_WOFFSET                       0x0
#define EVP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_DEFAULT                       _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_VEC_2_0  
#define EVP_PRI_IRQ_VEC_2_0                     _MK_ADDR_CONST(0x54)
#define EVP_PRI_IRQ_VEC_2_0_SECURE                      0x0
#define EVP_PRI_IRQ_VEC_2_0_WORD_COUNT                  0x1
#define EVP_PRI_IRQ_VEC_2_0_RESET_VAL                   _MK_MASK_CONST(0x40000018)
#define EVP_PRI_IRQ_VEC_2_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_2_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_2_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_2_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_2_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_SHIFT)
#define EVP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_RANGE                 31:0
#define EVP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_WOFFSET                       0x0
#define EVP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_DEFAULT                       _MK_MASK_CONST(0x40000018)
#define EVP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_NUM_3_0  
#define EVP_PRI_IRQ_NUM_3_0                     _MK_ADDR_CONST(0x58)
#define EVP_PRI_IRQ_NUM_3_0_SECURE                      0x0
#define EVP_PRI_IRQ_NUM_3_0_WORD_COUNT                  0x1
#define EVP_PRI_IRQ_NUM_3_0_RESET_VAL                   _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_NUM_3_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_3_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_3_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_3_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_3_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Number for the Interrupt associated with this entry
#define EVP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_SHIFT)
#define EVP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_RANGE                 31:0
#define EVP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_WOFFSET                       0x0
#define EVP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_DEFAULT                       _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_VEC_3_0  
#define EVP_PRI_IRQ_VEC_3_0                     _MK_ADDR_CONST(0x5c)
#define EVP_PRI_IRQ_VEC_3_0_SECURE                      0x0
#define EVP_PRI_IRQ_VEC_3_0_WORD_COUNT                  0x1
#define EVP_PRI_IRQ_VEC_3_0_RESET_VAL                   _MK_MASK_CONST(0x40000018)
#define EVP_PRI_IRQ_VEC_3_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_3_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_3_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_3_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_3_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_SHIFT)
#define EVP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_RANGE                 31:0
#define EVP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_WOFFSET                       0x0
#define EVP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_DEFAULT                       _MK_MASK_CONST(0x40000018)
#define EVP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_NUM_4_0  
#define EVP_PRI_IRQ_NUM_4_0                     _MK_ADDR_CONST(0x60)
#define EVP_PRI_IRQ_NUM_4_0_SECURE                      0x0
#define EVP_PRI_IRQ_NUM_4_0_WORD_COUNT                  0x1
#define EVP_PRI_IRQ_NUM_4_0_RESET_VAL                   _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_NUM_4_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_4_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_4_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_4_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_4_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Number for the Interrupt associated with this entry
#define EVP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_SHIFT)
#define EVP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_RANGE                 31:0
#define EVP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_WOFFSET                       0x0
#define EVP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_DEFAULT                       _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_VEC_4_0  
#define EVP_PRI_IRQ_VEC_4_0                     _MK_ADDR_CONST(0x64)
#define EVP_PRI_IRQ_VEC_4_0_SECURE                      0x0
#define EVP_PRI_IRQ_VEC_4_0_WORD_COUNT                  0x1
#define EVP_PRI_IRQ_VEC_4_0_RESET_VAL                   _MK_MASK_CONST(0x40000018)
#define EVP_PRI_IRQ_VEC_4_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_4_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_4_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_4_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_4_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_SHIFT)
#define EVP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_RANGE                 31:0
#define EVP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_WOFFSET                       0x0
#define EVP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_DEFAULT                       _MK_MASK_CONST(0x40000018)
#define EVP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_NUM_5_0  
#define EVP_PRI_IRQ_NUM_5_0                     _MK_ADDR_CONST(0x68)
#define EVP_PRI_IRQ_NUM_5_0_SECURE                      0x0
#define EVP_PRI_IRQ_NUM_5_0_WORD_COUNT                  0x1
#define EVP_PRI_IRQ_NUM_5_0_RESET_VAL                   _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_NUM_5_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_5_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_5_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_5_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_5_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Number for the Interrupt associated with this entry
#define EVP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_SHIFT)
#define EVP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_RANGE                 31:0
#define EVP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_WOFFSET                       0x0
#define EVP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_DEFAULT                       _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_VEC_5_0  
#define EVP_PRI_IRQ_VEC_5_0                     _MK_ADDR_CONST(0x6c)
#define EVP_PRI_IRQ_VEC_5_0_SECURE                      0x0
#define EVP_PRI_IRQ_VEC_5_0_WORD_COUNT                  0x1
#define EVP_PRI_IRQ_VEC_5_0_RESET_VAL                   _MK_MASK_CONST(0x40000018)
#define EVP_PRI_IRQ_VEC_5_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_5_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_5_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_5_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_5_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_SHIFT)
#define EVP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_RANGE                 31:0
#define EVP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_WOFFSET                       0x0
#define EVP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_DEFAULT                       _MK_MASK_CONST(0x40000018)
#define EVP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_NUM_6_0  
#define EVP_PRI_IRQ_NUM_6_0                     _MK_ADDR_CONST(0x70)
#define EVP_PRI_IRQ_NUM_6_0_SECURE                      0x0
#define EVP_PRI_IRQ_NUM_6_0_WORD_COUNT                  0x1
#define EVP_PRI_IRQ_NUM_6_0_RESET_VAL                   _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_NUM_6_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_6_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_6_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_6_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_6_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Number for the Interrupt associated with this entry
#define EVP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_SHIFT)
#define EVP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_RANGE                 31:0
#define EVP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_WOFFSET                       0x0
#define EVP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_DEFAULT                       _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_VEC_6_0  
#define EVP_PRI_IRQ_VEC_6_0                     _MK_ADDR_CONST(0x74)
#define EVP_PRI_IRQ_VEC_6_0_SECURE                      0x0
#define EVP_PRI_IRQ_VEC_6_0_WORD_COUNT                  0x1
#define EVP_PRI_IRQ_VEC_6_0_RESET_VAL                   _MK_MASK_CONST(0x40000018)
#define EVP_PRI_IRQ_VEC_6_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_6_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_6_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_6_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_6_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_SHIFT)
#define EVP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_RANGE                 31:0
#define EVP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_WOFFSET                       0x0
#define EVP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_DEFAULT                       _MK_MASK_CONST(0x40000018)
#define EVP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_NUM_7_0  
#define EVP_PRI_IRQ_NUM_7_0                     _MK_ADDR_CONST(0x78)
#define EVP_PRI_IRQ_NUM_7_0_SECURE                      0x0
#define EVP_PRI_IRQ_NUM_7_0_WORD_COUNT                  0x1
#define EVP_PRI_IRQ_NUM_7_0_RESET_VAL                   _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_NUM_7_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_7_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_7_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_7_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_7_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Number for the Interrupt associated with this entry
#define EVP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_SHIFT)
#define EVP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_RANGE                 31:0
#define EVP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_WOFFSET                       0x0
#define EVP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_DEFAULT                       _MK_MASK_CONST(0x80)
#define EVP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_IRQ_VEC_7_0  
#define EVP_PRI_IRQ_VEC_7_0                     _MK_ADDR_CONST(0x7c)
#define EVP_PRI_IRQ_VEC_7_0_SECURE                      0x0
#define EVP_PRI_IRQ_VEC_7_0_WORD_COUNT                  0x1
#define EVP_PRI_IRQ_VEC_7_0_RESET_VAL                   _MK_MASK_CONST(0x40000018)
#define EVP_PRI_IRQ_VEC_7_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_7_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_7_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_7_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_7_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_SHIFT)
#define EVP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_RANGE                 31:0
#define EVP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_WOFFSET                       0x0
#define EVP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_DEFAULT                       _MK_MASK_CONST(0x40000018)
#define EVP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_FIQ_NUM_0_0  
#define EVP_PRI_FIQ_NUM_0_0                     _MK_ADDR_CONST(0x80)
#define EVP_PRI_FIQ_NUM_0_0_SECURE                      0x0
#define EVP_PRI_FIQ_NUM_0_0_WORD_COUNT                  0x1
#define EVP_PRI_FIQ_NUM_0_0_RESET_VAL                   _MK_MASK_CONST(0x80)
#define EVP_PRI_FIQ_NUM_0_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_NUM_0_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_NUM_0_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_NUM_0_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_NUM_0_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Number for the Interrupt associated with this entry
#define EVP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_SHIFT)
#define EVP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_RANGE                 31:0
#define EVP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_WOFFSET                       0x0
#define EVP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_DEFAULT                       _MK_MASK_CONST(0x80)
#define EVP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_FIQ_VEC_0_0  
#define EVP_PRI_FIQ_VEC_0_0                     _MK_ADDR_CONST(0x84)
#define EVP_PRI_FIQ_VEC_0_0_SECURE                      0x0
#define EVP_PRI_FIQ_VEC_0_0_WORD_COUNT                  0x1
#define EVP_PRI_FIQ_VEC_0_0_RESET_VAL                   _MK_MASK_CONST(0x4000001c)
#define EVP_PRI_FIQ_VEC_0_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_VEC_0_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_VEC_0_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_VEC_0_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_VEC_0_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_SHIFT)
#define EVP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_RANGE                 31:0
#define EVP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_WOFFSET                       0x0
#define EVP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_DEFAULT                       _MK_MASK_CONST(0x4000001c)
#define EVP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_FIQ_NUM_1_0  
#define EVP_PRI_FIQ_NUM_1_0                     _MK_ADDR_CONST(0x88)
#define EVP_PRI_FIQ_NUM_1_0_SECURE                      0x0
#define EVP_PRI_FIQ_NUM_1_0_WORD_COUNT                  0x1
#define EVP_PRI_FIQ_NUM_1_0_RESET_VAL                   _MK_MASK_CONST(0x80)
#define EVP_PRI_FIQ_NUM_1_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_NUM_1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_NUM_1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_NUM_1_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_NUM_1_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Number for the Interrupt associated with this entry
#define EVP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_SHIFT)
#define EVP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_RANGE                 31:0
#define EVP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_WOFFSET                       0x0
#define EVP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_DEFAULT                       _MK_MASK_CONST(0x80)
#define EVP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_FIQ_VEC_1_0  
#define EVP_PRI_FIQ_VEC_1_0                     _MK_ADDR_CONST(0x8c)
#define EVP_PRI_FIQ_VEC_1_0_SECURE                      0x0
#define EVP_PRI_FIQ_VEC_1_0_WORD_COUNT                  0x1
#define EVP_PRI_FIQ_VEC_1_0_RESET_VAL                   _MK_MASK_CONST(0x4000001c)
#define EVP_PRI_FIQ_VEC_1_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_VEC_1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_VEC_1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_VEC_1_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_VEC_1_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_SHIFT)
#define EVP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_RANGE                 31:0
#define EVP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_WOFFSET                       0x0
#define EVP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_DEFAULT                       _MK_MASK_CONST(0x4000001c)
#define EVP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_FIQ_NUM_2_0  
#define EVP_PRI_FIQ_NUM_2_0                     _MK_ADDR_CONST(0x90)
#define EVP_PRI_FIQ_NUM_2_0_SECURE                      0x0
#define EVP_PRI_FIQ_NUM_2_0_WORD_COUNT                  0x1
#define EVP_PRI_FIQ_NUM_2_0_RESET_VAL                   _MK_MASK_CONST(0x80)
#define EVP_PRI_FIQ_NUM_2_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_NUM_2_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_NUM_2_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_NUM_2_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_NUM_2_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Number for the Interrupt associated with this entry
#define EVP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_SHIFT)
#define EVP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_RANGE                 31:0
#define EVP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_WOFFSET                       0x0
#define EVP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_DEFAULT                       _MK_MASK_CONST(0x80)
#define EVP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_FIQ_VEC_2_0  
#define EVP_PRI_FIQ_VEC_2_0                     _MK_ADDR_CONST(0x94)
#define EVP_PRI_FIQ_VEC_2_0_SECURE                      0x0
#define EVP_PRI_FIQ_VEC_2_0_WORD_COUNT                  0x1
#define EVP_PRI_FIQ_VEC_2_0_RESET_VAL                   _MK_MASK_CONST(0x4000001c)
#define EVP_PRI_FIQ_VEC_2_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_VEC_2_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_VEC_2_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_VEC_2_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_VEC_2_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_SHIFT)
#define EVP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_RANGE                 31:0
#define EVP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_WOFFSET                       0x0
#define EVP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_DEFAULT                       _MK_MASK_CONST(0x4000001c)
#define EVP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_FIQ_NUM_3_0  
#define EVP_PRI_FIQ_NUM_3_0                     _MK_ADDR_CONST(0x98)
#define EVP_PRI_FIQ_NUM_3_0_SECURE                      0x0
#define EVP_PRI_FIQ_NUM_3_0_WORD_COUNT                  0x1
#define EVP_PRI_FIQ_NUM_3_0_RESET_VAL                   _MK_MASK_CONST(0x80)
#define EVP_PRI_FIQ_NUM_3_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_NUM_3_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_NUM_3_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_NUM_3_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_NUM_3_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Number for the Interrupt associated with this entry
#define EVP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_SHIFT)
#define EVP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_RANGE                 31:0
#define EVP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_WOFFSET                       0x0
#define EVP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_DEFAULT                       _MK_MASK_CONST(0x80)
#define EVP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_PRI_FIQ_VEC_3_0  
#define EVP_PRI_FIQ_VEC_3_0                     _MK_ADDR_CONST(0x9c)
#define EVP_PRI_FIQ_VEC_3_0_SECURE                      0x0
#define EVP_PRI_FIQ_VEC_3_0_WORD_COUNT                  0x1
#define EVP_PRI_FIQ_VEC_3_0_RESET_VAL                   _MK_MASK_CONST(0x4000001c)
#define EVP_PRI_FIQ_VEC_3_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_VEC_3_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_VEC_3_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_VEC_3_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_VEC_3_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_SHIFT)
#define EVP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_RANGE                 31:0
#define EVP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_WOFFSET                       0x0
#define EVP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_DEFAULT                       _MK_MASK_CONST(0x4000001c)
#define EVP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EVP_CPU_RESET_VECTOR_0  
#define EVP_CPU_RESET_VECTOR_0                  _MK_ADDR_CONST(0x100)
#define EVP_CPU_RESET_VECTOR_0_SECURE                   0x0
#define EVP_CPU_RESET_VECTOR_0_WORD_COUNT                       0x1
#define EVP_CPU_RESET_VECTOR_0_RESET_VAL                        _MK_MASK_CONST(0xfff00000)
#define EVP_CPU_RESET_VECTOR_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_RESET_VECTOR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EVP_CPU_RESET_VECTOR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EVP_CPU_RESET_VECTOR_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_RESET_VECTOR_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// RESET Exception Vector Pointer 
#define EVP_CPU_RESET_VECTOR_0_CPU_RESET_VECTOR_SHIFT                   _MK_SHIFT_CONST(0)
#define EVP_CPU_RESET_VECTOR_0_CPU_RESET_VECTOR_FIELD                   (_MK_MASK_CONST(0xffffffff) << EVP_CPU_RESET_VECTOR_0_CPU_RESET_VECTOR_SHIFT)
#define EVP_CPU_RESET_VECTOR_0_CPU_RESET_VECTOR_RANGE                   31:0
#define EVP_CPU_RESET_VECTOR_0_CPU_RESET_VECTOR_WOFFSET                 0x0
#define EVP_CPU_RESET_VECTOR_0_CPU_RESET_VECTOR_DEFAULT                 _MK_MASK_CONST(0xfff00000)
#define EVP_CPU_RESET_VECTOR_0_CPU_RESET_VECTOR_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_RESET_VECTOR_0_CPU_RESET_VECTOR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EVP_CPU_RESET_VECTOR_0_CPU_RESET_VECTOR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EVP_CPU_RESET_VECTOR_0_CPU_RESET_VECTOR_INIT_ENUM                       -1048576


// Register EVP_CPU_UNDEF_VECTOR_0  
#define EVP_CPU_UNDEF_VECTOR_0                  _MK_ADDR_CONST(0x104)
#define EVP_CPU_UNDEF_VECTOR_0_SECURE                   0x0
#define EVP_CPU_UNDEF_VECTOR_0_WORD_COUNT                       0x1
#define EVP_CPU_UNDEF_VECTOR_0_RESET_VAL                        _MK_MASK_CONST(0xfff00004)
#define EVP_CPU_UNDEF_VECTOR_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_UNDEF_VECTOR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EVP_CPU_UNDEF_VECTOR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EVP_CPU_UNDEF_VECTOR_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_UNDEF_VECTOR_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// Undefined Exception Vector Pointer
#define EVP_CPU_UNDEF_VECTOR_0_CPU_UNDEF_VECTOR_SHIFT                   _MK_SHIFT_CONST(0)
#define EVP_CPU_UNDEF_VECTOR_0_CPU_UNDEF_VECTOR_FIELD                   (_MK_MASK_CONST(0xffffffff) << EVP_CPU_UNDEF_VECTOR_0_CPU_UNDEF_VECTOR_SHIFT)
#define EVP_CPU_UNDEF_VECTOR_0_CPU_UNDEF_VECTOR_RANGE                   31:0
#define EVP_CPU_UNDEF_VECTOR_0_CPU_UNDEF_VECTOR_WOFFSET                 0x0
#define EVP_CPU_UNDEF_VECTOR_0_CPU_UNDEF_VECTOR_DEFAULT                 _MK_MASK_CONST(0xfff00004)
#define EVP_CPU_UNDEF_VECTOR_0_CPU_UNDEF_VECTOR_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_UNDEF_VECTOR_0_CPU_UNDEF_VECTOR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EVP_CPU_UNDEF_VECTOR_0_CPU_UNDEF_VECTOR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EVP_CPU_UNDEF_VECTOR_0_CPU_UNDEF_VECTOR_INIT_ENUM                       -1048572


// Register EVP_CPU_SWI_VECTOR_0  
#define EVP_CPU_SWI_VECTOR_0                    _MK_ADDR_CONST(0x108)
#define EVP_CPU_SWI_VECTOR_0_SECURE                     0x0
#define EVP_CPU_SWI_VECTOR_0_WORD_COUNT                         0x1
#define EVP_CPU_SWI_VECTOR_0_RESET_VAL                  _MK_MASK_CONST(0xfff00008)
#define EVP_CPU_SWI_VECTOR_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_SWI_VECTOR_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EVP_CPU_SWI_VECTOR_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EVP_CPU_SWI_VECTOR_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_SWI_VECTOR_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
// Software Interrupt Vector Pointer
#define EVP_CPU_SWI_VECTOR_0_CPU_SWI_VECTOR_SHIFT                       _MK_SHIFT_CONST(0)
#define EVP_CPU_SWI_VECTOR_0_CPU_SWI_VECTOR_FIELD                       (_MK_MASK_CONST(0xffffffff) << EVP_CPU_SWI_VECTOR_0_CPU_SWI_VECTOR_SHIFT)
#define EVP_CPU_SWI_VECTOR_0_CPU_SWI_VECTOR_RANGE                       31:0
#define EVP_CPU_SWI_VECTOR_0_CPU_SWI_VECTOR_WOFFSET                     0x0
#define EVP_CPU_SWI_VECTOR_0_CPU_SWI_VECTOR_DEFAULT                     _MK_MASK_CONST(0xfff00008)
#define EVP_CPU_SWI_VECTOR_0_CPU_SWI_VECTOR_DEFAULT_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_SWI_VECTOR_0_CPU_SWI_VECTOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EVP_CPU_SWI_VECTOR_0_CPU_SWI_VECTOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_CPU_SWI_VECTOR_0_CPU_SWI_VECTOR_INIT_ENUM                   -1048568


// Register EVP_CPU_PREFETCH_ABORT_VECTOR_0  
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0                 _MK_ADDR_CONST(0x10c)
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_SECURE                  0x0
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_WORD_COUNT                      0x1
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_RESET_VAL                       _MK_MASK_CONST(0xfff0000c)
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Code Prefetch ABORT Vector Pointer 
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_CPU_PRE_ABORT_VECTOR_SHIFT                      _MK_SHIFT_CONST(0)
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_CPU_PRE_ABORT_VECTOR_FIELD                      (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PREFETCH_ABORT_VECTOR_0_CPU_PRE_ABORT_VECTOR_SHIFT)
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_CPU_PRE_ABORT_VECTOR_RANGE                      31:0
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_CPU_PRE_ABORT_VECTOR_WOFFSET                    0x0
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_CPU_PRE_ABORT_VECTOR_DEFAULT                    _MK_MASK_CONST(0xfff0000c)
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_CPU_PRE_ABORT_VECTOR_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_CPU_PRE_ABORT_VECTOR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_CPU_PRE_ABORT_VECTOR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EVP_CPU_PREFETCH_ABORT_VECTOR_0_CPU_PRE_ABORT_VECTOR_INIT_ENUM                  -1048564


// Register EVP_CPU_DATA_ABORT_VECTOR_0  
#define EVP_CPU_DATA_ABORT_VECTOR_0                     _MK_ADDR_CONST(0x110)
#define EVP_CPU_DATA_ABORT_VECTOR_0_SECURE                      0x0
#define EVP_CPU_DATA_ABORT_VECTOR_0_WORD_COUNT                  0x1
#define EVP_CPU_DATA_ABORT_VECTOR_0_RESET_VAL                   _MK_MASK_CONST(0xfff00010)
#define EVP_CPU_DATA_ABORT_VECTOR_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_DATA_ABORT_VECTOR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_CPU_DATA_ABORT_VECTOR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_CPU_DATA_ABORT_VECTOR_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_DATA_ABORT_VECTOR_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// Data ABORT Vector Pointer
#define EVP_CPU_DATA_ABORT_VECTOR_0_CPU_DATA_ABORT_VECTOR_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_CPU_DATA_ABORT_VECTOR_0_CPU_DATA_ABORT_VECTOR_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_CPU_DATA_ABORT_VECTOR_0_CPU_DATA_ABORT_VECTOR_SHIFT)
#define EVP_CPU_DATA_ABORT_VECTOR_0_CPU_DATA_ABORT_VECTOR_RANGE                 31:0
#define EVP_CPU_DATA_ABORT_VECTOR_0_CPU_DATA_ABORT_VECTOR_WOFFSET                       0x0
#define EVP_CPU_DATA_ABORT_VECTOR_0_CPU_DATA_ABORT_VECTOR_DEFAULT                       _MK_MASK_CONST(0xfff00010)
#define EVP_CPU_DATA_ABORT_VECTOR_0_CPU_DATA_ABORT_VECTOR_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_DATA_ABORT_VECTOR_0_CPU_DATA_ABORT_VECTOR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_CPU_DATA_ABORT_VECTOR_0_CPU_DATA_ABORT_VECTOR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EVP_CPU_DATA_ABORT_VECTOR_0_CPU_DATA_ABORT_VECTOR_INIT_ENUM                     -1048560


// Register EVP_CPU_RSVD_VECTOR_0  
#define EVP_CPU_RSVD_VECTOR_0                   _MK_ADDR_CONST(0x114)
#define EVP_CPU_RSVD_VECTOR_0_SECURE                    0x0
#define EVP_CPU_RSVD_VECTOR_0_WORD_COUNT                        0x1
#define EVP_CPU_RSVD_VECTOR_0_RESET_VAL                         _MK_MASK_CONST(0xfff00014)
#define EVP_CPU_RSVD_VECTOR_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_RSVD_VECTOR_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EVP_CPU_RSVD_VECTOR_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EVP_CPU_RSVD_VECTOR_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_RSVD_VECTOR_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// Reserved Exception Vector Pointer
#define EVP_CPU_RSVD_VECTOR_0_CPU_RSVD_VECTOR_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_RSVD_VECTOR_0_CPU_RSVD_VECTOR_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_RSVD_VECTOR_0_CPU_RSVD_VECTOR_SHIFT)
#define EVP_CPU_RSVD_VECTOR_0_CPU_RSVD_VECTOR_RANGE                     31:0
#define EVP_CPU_RSVD_VECTOR_0_CPU_RSVD_VECTOR_WOFFSET                   0x0
#define EVP_CPU_RSVD_VECTOR_0_CPU_RSVD_VECTOR_DEFAULT                   _MK_MASK_CONST(0xfff00014)
#define EVP_CPU_RSVD_VECTOR_0_CPU_RSVD_VECTOR_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_RSVD_VECTOR_0_CPU_RSVD_VECTOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_RSVD_VECTOR_0_CPU_RSVD_VECTOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EVP_CPU_RSVD_VECTOR_0_CPU_RSVD_VECTOR_INIT_ENUM                 -1048556


// Register EVP_CPU_IRQ_VECTOR_0  
#define EVP_CPU_IRQ_VECTOR_0                    _MK_ADDR_CONST(0x118)
#define EVP_CPU_IRQ_VECTOR_0_SECURE                     0x0
#define EVP_CPU_IRQ_VECTOR_0_WORD_COUNT                         0x1
#define EVP_CPU_IRQ_VECTOR_0_RESET_VAL                  _MK_MASK_CONST(0xfff00018)
#define EVP_CPU_IRQ_VECTOR_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_IRQ_VECTOR_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EVP_CPU_IRQ_VECTOR_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EVP_CPU_IRQ_VECTOR_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_IRQ_VECTOR_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
// IRQ Vector Pointer 
#define EVP_CPU_IRQ_VECTOR_0_CPU_IRQ_VECTOR_SHIFT                       _MK_SHIFT_CONST(0)
#define EVP_CPU_IRQ_VECTOR_0_CPU_IRQ_VECTOR_FIELD                       (_MK_MASK_CONST(0xffffffff) << EVP_CPU_IRQ_VECTOR_0_CPU_IRQ_VECTOR_SHIFT)
#define EVP_CPU_IRQ_VECTOR_0_CPU_IRQ_VECTOR_RANGE                       31:0
#define EVP_CPU_IRQ_VECTOR_0_CPU_IRQ_VECTOR_WOFFSET                     0x0
#define EVP_CPU_IRQ_VECTOR_0_CPU_IRQ_VECTOR_DEFAULT                     _MK_MASK_CONST(0xfff00018)
#define EVP_CPU_IRQ_VECTOR_0_CPU_IRQ_VECTOR_DEFAULT_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_IRQ_VECTOR_0_CPU_IRQ_VECTOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EVP_CPU_IRQ_VECTOR_0_CPU_IRQ_VECTOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_CPU_IRQ_VECTOR_0_CPU_IRQ_VECTOR_INIT_ENUM                   -1048552


// Register EVP_CPU_FIQ_VECTOR_0  
#define EVP_CPU_FIQ_VECTOR_0                    _MK_ADDR_CONST(0x11c)
#define EVP_CPU_FIQ_VECTOR_0_SECURE                     0x0
#define EVP_CPU_FIQ_VECTOR_0_WORD_COUNT                         0x1
#define EVP_CPU_FIQ_VECTOR_0_RESET_VAL                  _MK_MASK_CONST(0xfff0001c)
#define EVP_CPU_FIQ_VECTOR_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_FIQ_VECTOR_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EVP_CPU_FIQ_VECTOR_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EVP_CPU_FIQ_VECTOR_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_FIQ_VECTOR_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
// FIQ Vector Pointer 
#define EVP_CPU_FIQ_VECTOR_0_CPU_FIQ_VECTOR_SHIFT                       _MK_SHIFT_CONST(0)
#define EVP_CPU_FIQ_VECTOR_0_CPU_FIQ_VECTOR_FIELD                       (_MK_MASK_CONST(0xffffffff) << EVP_CPU_FIQ_VECTOR_0_CPU_FIQ_VECTOR_SHIFT)
#define EVP_CPU_FIQ_VECTOR_0_CPU_FIQ_VECTOR_RANGE                       31:0
#define EVP_CPU_FIQ_VECTOR_0_CPU_FIQ_VECTOR_WOFFSET                     0x0
#define EVP_CPU_FIQ_VECTOR_0_CPU_FIQ_VECTOR_DEFAULT                     _MK_MASK_CONST(0xfff0001c)
#define EVP_CPU_FIQ_VECTOR_0_CPU_FIQ_VECTOR_DEFAULT_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_FIQ_VECTOR_0_CPU_FIQ_VECTOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EVP_CPU_FIQ_VECTOR_0_CPU_FIQ_VECTOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_CPU_FIQ_VECTOR_0_CPU_FIQ_VECTOR_INIT_ENUM                   -1048548


// Register EVP_CPU_IRQ_STS_0  
#define EVP_CPU_IRQ_STS_0                       _MK_ADDR_CONST(0x120)
#define EVP_CPU_IRQ_STS_0_SECURE                        0x0
#define EVP_CPU_IRQ_STS_0_WORD_COUNT                    0x1
#define EVP_CPU_IRQ_STS_0_RESET_VAL                     _MK_MASK_CONST(0x80)
#define EVP_CPU_IRQ_STS_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_IRQ_STS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EVP_CPU_IRQ_STS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EVP_CPU_IRQ_STS_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_IRQ_STS_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
// FFS (from lsb) IRQ index  (0x80 indicates no active IRQ)
#define EVP_CPU_IRQ_STS_0_CPU_IRQ_STS_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_IRQ_STS_0_CPU_IRQ_STS_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_IRQ_STS_0_CPU_IRQ_STS_SHIFT)
#define EVP_CPU_IRQ_STS_0_CPU_IRQ_STS_RANGE                     31:0
#define EVP_CPU_IRQ_STS_0_CPU_IRQ_STS_WOFFSET                   0x0
#define EVP_CPU_IRQ_STS_0_CPU_IRQ_STS_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_CPU_IRQ_STS_0_CPU_IRQ_STS_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_IRQ_STS_0_CPU_IRQ_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_IRQ_STS_0_CPU_IRQ_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_STS_0  
#define EVP_CPU_PRI_IRQ_STS_0                   _MK_ADDR_CONST(0x124)
#define EVP_CPU_PRI_IRQ_STS_0_SECURE                    0x0
#define EVP_CPU_PRI_IRQ_STS_0_WORD_COUNT                        0x1
#define EVP_CPU_PRI_IRQ_STS_0_RESET_VAL                         _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_STS_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_STS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_STS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_STS_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_STS_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// Current highest priority active IRQ (0x80 indicates no active priority IRQ)
#define EVP_CPU_PRI_IRQ_STS_0_CPU_PRI_IRQ_STS_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_STS_0_CPU_PRI_IRQ_STS_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_STS_0_CPU_PRI_IRQ_STS_SHIFT)
#define EVP_CPU_PRI_IRQ_STS_0_CPU_PRI_IRQ_STS_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_STS_0_CPU_PRI_IRQ_STS_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_STS_0_CPU_PRI_IRQ_STS_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_STS_0_CPU_PRI_IRQ_STS_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_STS_0_CPU_PRI_IRQ_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_STS_0_CPU_PRI_IRQ_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_FIQ_STS_0  
#define EVP_CPU_FIQ_STS_0                       _MK_ADDR_CONST(0x128)
#define EVP_CPU_FIQ_STS_0_SECURE                        0x0
#define EVP_CPU_FIQ_STS_0_WORD_COUNT                    0x1
#define EVP_CPU_FIQ_STS_0_RESET_VAL                     _MK_MASK_CONST(0x80)
#define EVP_CPU_FIQ_STS_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_FIQ_STS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EVP_CPU_FIQ_STS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EVP_CPU_FIQ_STS_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_FIQ_STS_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
// FFS (from lsb) FIQ index (0x80 indicates no active FIQ)
#define EVP_CPU_FIQ_STS_0_CPU_FIQ_STS_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_FIQ_STS_0_CPU_FIQ_STS_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_FIQ_STS_0_CPU_FIQ_STS_SHIFT)
#define EVP_CPU_FIQ_STS_0_CPU_FIQ_STS_RANGE                     31:0
#define EVP_CPU_FIQ_STS_0_CPU_FIQ_STS_WOFFSET                   0x0
#define EVP_CPU_FIQ_STS_0_CPU_FIQ_STS_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_CPU_FIQ_STS_0_CPU_FIQ_STS_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_FIQ_STS_0_CPU_FIQ_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_FIQ_STS_0_CPU_FIQ_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_FIQ_STS_0  
#define EVP_CPU_PRI_FIQ_STS_0                   _MK_ADDR_CONST(0x12c)
#define EVP_CPU_PRI_FIQ_STS_0_SECURE                    0x0
#define EVP_CPU_PRI_FIQ_STS_0_WORD_COUNT                        0x1
#define EVP_CPU_PRI_FIQ_STS_0_RESET_VAL                         _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_FIQ_STS_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_STS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_STS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_STS_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_STS_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// Current highest priority active FIQ (0x80 indicates no active priority FIQ)
#define EVP_CPU_PRI_FIQ_STS_0_CPU_PRI_FIQ_STS_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_FIQ_STS_0_CPU_PRI_FIQ_STS_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_FIQ_STS_0_CPU_PRI_FIQ_STS_SHIFT)
#define EVP_CPU_PRI_FIQ_STS_0_CPU_PRI_FIQ_STS_RANGE                     31:0
#define EVP_CPU_PRI_FIQ_STS_0_CPU_PRI_FIQ_STS_WOFFSET                   0x0
#define EVP_CPU_PRI_FIQ_STS_0_CPU_PRI_FIQ_STS_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_FIQ_STS_0_CPU_PRI_FIQ_STS_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_STS_0_CPU_PRI_FIQ_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_STS_0_CPU_PRI_FIQ_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_NUM_0_0  
#define EVP_CPU_PRI_IRQ_NUM_0_0                 _MK_ADDR_CONST(0x140)
#define EVP_CPU_PRI_IRQ_NUM_0_0_SECURE                  0x0
#define EVP_CPU_PRI_IRQ_NUM_0_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_IRQ_NUM_0_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_NUM_0_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_0_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_0_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_CPU_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_SHIFT)
#define EVP_CPU_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_VEC_0_0  
#define EVP_CPU_PRI_IRQ_VEC_0_0                 _MK_ADDR_CONST(0x144)
#define EVP_CPU_PRI_IRQ_VEC_0_0_SECURE                  0x0
#define EVP_CPU_PRI_IRQ_VEC_0_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_IRQ_VEC_0_0_RESET_VAL                       _MK_MASK_CONST(0x40000018)
#define EVP_CPU_PRI_IRQ_VEC_0_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_0_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_0_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_CPU_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_SHIFT)
#define EVP_CPU_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_DEFAULT                   _MK_MASK_CONST(0x40000018)
#define EVP_CPU_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_NUM_1_0  
#define EVP_CPU_PRI_IRQ_NUM_1_0                 _MK_ADDR_CONST(0x148)
#define EVP_CPU_PRI_IRQ_NUM_1_0_SECURE                  0x0
#define EVP_CPU_PRI_IRQ_NUM_1_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_IRQ_NUM_1_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_NUM_1_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_1_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_1_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_CPU_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_SHIFT)
#define EVP_CPU_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_VEC_1_0  
#define EVP_CPU_PRI_IRQ_VEC_1_0                 _MK_ADDR_CONST(0x14c)
#define EVP_CPU_PRI_IRQ_VEC_1_0_SECURE                  0x0
#define EVP_CPU_PRI_IRQ_VEC_1_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_IRQ_VEC_1_0_RESET_VAL                       _MK_MASK_CONST(0x40000018)
#define EVP_CPU_PRI_IRQ_VEC_1_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_1_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_1_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_CPU_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_SHIFT)
#define EVP_CPU_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_DEFAULT                   _MK_MASK_CONST(0x40000018)
#define EVP_CPU_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_NUM_2_0  
#define EVP_CPU_PRI_IRQ_NUM_2_0                 _MK_ADDR_CONST(0x150)
#define EVP_CPU_PRI_IRQ_NUM_2_0_SECURE                  0x0
#define EVP_CPU_PRI_IRQ_NUM_2_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_IRQ_NUM_2_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_NUM_2_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_2_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_2_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_CPU_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_SHIFT)
#define EVP_CPU_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_VEC_2_0  
#define EVP_CPU_PRI_IRQ_VEC_2_0                 _MK_ADDR_CONST(0x154)
#define EVP_CPU_PRI_IRQ_VEC_2_0_SECURE                  0x0
#define EVP_CPU_PRI_IRQ_VEC_2_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_IRQ_VEC_2_0_RESET_VAL                       _MK_MASK_CONST(0x40000018)
#define EVP_CPU_PRI_IRQ_VEC_2_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_2_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_2_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_CPU_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_SHIFT)
#define EVP_CPU_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_DEFAULT                   _MK_MASK_CONST(0x40000018)
#define EVP_CPU_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_NUM_3_0  
#define EVP_CPU_PRI_IRQ_NUM_3_0                 _MK_ADDR_CONST(0x158)
#define EVP_CPU_PRI_IRQ_NUM_3_0_SECURE                  0x0
#define EVP_CPU_PRI_IRQ_NUM_3_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_IRQ_NUM_3_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_NUM_3_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_3_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_3_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_3_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_3_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_CPU_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_SHIFT)
#define EVP_CPU_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_VEC_3_0  
#define EVP_CPU_PRI_IRQ_VEC_3_0                 _MK_ADDR_CONST(0x15c)
#define EVP_CPU_PRI_IRQ_VEC_3_0_SECURE                  0x0
#define EVP_CPU_PRI_IRQ_VEC_3_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_IRQ_VEC_3_0_RESET_VAL                       _MK_MASK_CONST(0x40000018)
#define EVP_CPU_PRI_IRQ_VEC_3_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_3_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_3_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_3_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_3_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_CPU_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_SHIFT)
#define EVP_CPU_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_DEFAULT                   _MK_MASK_CONST(0x40000018)
#define EVP_CPU_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_NUM_4_0  
#define EVP_CPU_PRI_IRQ_NUM_4_0                 _MK_ADDR_CONST(0x160)
#define EVP_CPU_PRI_IRQ_NUM_4_0_SECURE                  0x0
#define EVP_CPU_PRI_IRQ_NUM_4_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_IRQ_NUM_4_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_NUM_4_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_4_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_4_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_4_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_4_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_CPU_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_SHIFT)
#define EVP_CPU_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_VEC_4_0  
#define EVP_CPU_PRI_IRQ_VEC_4_0                 _MK_ADDR_CONST(0x164)
#define EVP_CPU_PRI_IRQ_VEC_4_0_SECURE                  0x0
#define EVP_CPU_PRI_IRQ_VEC_4_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_IRQ_VEC_4_0_RESET_VAL                       _MK_MASK_CONST(0x40000018)
#define EVP_CPU_PRI_IRQ_VEC_4_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_4_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_4_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_4_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_4_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_CPU_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_SHIFT)
#define EVP_CPU_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_DEFAULT                   _MK_MASK_CONST(0x40000018)
#define EVP_CPU_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_NUM_5_0  
#define EVP_CPU_PRI_IRQ_NUM_5_0                 _MK_ADDR_CONST(0x168)
#define EVP_CPU_PRI_IRQ_NUM_5_0_SECURE                  0x0
#define EVP_CPU_PRI_IRQ_NUM_5_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_IRQ_NUM_5_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_NUM_5_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_5_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_5_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_5_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_5_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_CPU_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_SHIFT)
#define EVP_CPU_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_VEC_5_0  
#define EVP_CPU_PRI_IRQ_VEC_5_0                 _MK_ADDR_CONST(0x16c)
#define EVP_CPU_PRI_IRQ_VEC_5_0_SECURE                  0x0
#define EVP_CPU_PRI_IRQ_VEC_5_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_IRQ_VEC_5_0_RESET_VAL                       _MK_MASK_CONST(0x40000018)
#define EVP_CPU_PRI_IRQ_VEC_5_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_5_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_5_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_5_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_5_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_CPU_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_SHIFT)
#define EVP_CPU_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_DEFAULT                   _MK_MASK_CONST(0x40000018)
#define EVP_CPU_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_NUM_6_0  
#define EVP_CPU_PRI_IRQ_NUM_6_0                 _MK_ADDR_CONST(0x170)
#define EVP_CPU_PRI_IRQ_NUM_6_0_SECURE                  0x0
#define EVP_CPU_PRI_IRQ_NUM_6_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_IRQ_NUM_6_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_NUM_6_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_6_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_6_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_6_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_6_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_CPU_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_SHIFT)
#define EVP_CPU_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_VEC_6_0  
#define EVP_CPU_PRI_IRQ_VEC_6_0                 _MK_ADDR_CONST(0x174)
#define EVP_CPU_PRI_IRQ_VEC_6_0_SECURE                  0x0
#define EVP_CPU_PRI_IRQ_VEC_6_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_IRQ_VEC_6_0_RESET_VAL                       _MK_MASK_CONST(0x40000018)
#define EVP_CPU_PRI_IRQ_VEC_6_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_6_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_6_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_6_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_6_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_CPU_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_SHIFT)
#define EVP_CPU_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_DEFAULT                   _MK_MASK_CONST(0x40000018)
#define EVP_CPU_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_NUM_7_0  
#define EVP_CPU_PRI_IRQ_NUM_7_0                 _MK_ADDR_CONST(0x178)
#define EVP_CPU_PRI_IRQ_NUM_7_0_SECURE                  0x0
#define EVP_CPU_PRI_IRQ_NUM_7_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_IRQ_NUM_7_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_NUM_7_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_7_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_7_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_7_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_7_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_CPU_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_SHIFT)
#define EVP_CPU_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_IRQ_VEC_7_0  
#define EVP_CPU_PRI_IRQ_VEC_7_0                 _MK_ADDR_CONST(0x17c)
#define EVP_CPU_PRI_IRQ_VEC_7_0_SECURE                  0x0
#define EVP_CPU_PRI_IRQ_VEC_7_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_IRQ_VEC_7_0_RESET_VAL                       _MK_MASK_CONST(0x40000018)
#define EVP_CPU_PRI_IRQ_VEC_7_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_7_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_7_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_7_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_7_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_CPU_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_SHIFT)
#define EVP_CPU_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_RANGE                     31:0
#define EVP_CPU_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_WOFFSET                   0x0
#define EVP_CPU_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_DEFAULT                   _MK_MASK_CONST(0x40000018)
#define EVP_CPU_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_FIQ_NUM_0_0  
#define EVP_CPU_PRI_FIQ_NUM_0_0                 _MK_ADDR_CONST(0x180)
#define EVP_CPU_PRI_FIQ_NUM_0_0_SECURE                  0x0
#define EVP_CPU_PRI_FIQ_NUM_0_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_FIQ_NUM_0_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_FIQ_NUM_0_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_NUM_0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_NUM_0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_NUM_0_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_NUM_0_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_CPU_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_SHIFT)
#define EVP_CPU_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_RANGE                     31:0
#define EVP_CPU_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_WOFFSET                   0x0
#define EVP_CPU_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_FIQ_VEC_0_0  
#define EVP_CPU_PRI_FIQ_VEC_0_0                 _MK_ADDR_CONST(0x184)
#define EVP_CPU_PRI_FIQ_VEC_0_0_SECURE                  0x0
#define EVP_CPU_PRI_FIQ_VEC_0_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_FIQ_VEC_0_0_RESET_VAL                       _MK_MASK_CONST(0x4000001c)
#define EVP_CPU_PRI_FIQ_VEC_0_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_VEC_0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_VEC_0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_VEC_0_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_VEC_0_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_CPU_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_SHIFT)
#define EVP_CPU_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_RANGE                     31:0
#define EVP_CPU_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_WOFFSET                   0x0
#define EVP_CPU_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_DEFAULT                   _MK_MASK_CONST(0x4000001c)
#define EVP_CPU_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_FIQ_NUM_1_0  
#define EVP_CPU_PRI_FIQ_NUM_1_0                 _MK_ADDR_CONST(0x188)
#define EVP_CPU_PRI_FIQ_NUM_1_0_SECURE                  0x0
#define EVP_CPU_PRI_FIQ_NUM_1_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_FIQ_NUM_1_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_FIQ_NUM_1_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_NUM_1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_NUM_1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_NUM_1_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_NUM_1_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_CPU_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_SHIFT)
#define EVP_CPU_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_RANGE                     31:0
#define EVP_CPU_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_WOFFSET                   0x0
#define EVP_CPU_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_FIQ_VEC_1_0  
#define EVP_CPU_PRI_FIQ_VEC_1_0                 _MK_ADDR_CONST(0x18c)
#define EVP_CPU_PRI_FIQ_VEC_1_0_SECURE                  0x0
#define EVP_CPU_PRI_FIQ_VEC_1_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_FIQ_VEC_1_0_RESET_VAL                       _MK_MASK_CONST(0x4000001c)
#define EVP_CPU_PRI_FIQ_VEC_1_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_VEC_1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_VEC_1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_VEC_1_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_VEC_1_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_CPU_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_SHIFT)
#define EVP_CPU_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_RANGE                     31:0
#define EVP_CPU_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_WOFFSET                   0x0
#define EVP_CPU_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_DEFAULT                   _MK_MASK_CONST(0x4000001c)
#define EVP_CPU_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_FIQ_NUM_2_0  
#define EVP_CPU_PRI_FIQ_NUM_2_0                 _MK_ADDR_CONST(0x190)
#define EVP_CPU_PRI_FIQ_NUM_2_0_SECURE                  0x0
#define EVP_CPU_PRI_FIQ_NUM_2_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_FIQ_NUM_2_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_FIQ_NUM_2_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_NUM_2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_NUM_2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_NUM_2_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_NUM_2_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_CPU_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_SHIFT)
#define EVP_CPU_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_RANGE                     31:0
#define EVP_CPU_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_WOFFSET                   0x0
#define EVP_CPU_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_FIQ_VEC_2_0  
#define EVP_CPU_PRI_FIQ_VEC_2_0                 _MK_ADDR_CONST(0x194)
#define EVP_CPU_PRI_FIQ_VEC_2_0_SECURE                  0x0
#define EVP_CPU_PRI_FIQ_VEC_2_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_FIQ_VEC_2_0_RESET_VAL                       _MK_MASK_CONST(0x4000001c)
#define EVP_CPU_PRI_FIQ_VEC_2_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_VEC_2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_VEC_2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_VEC_2_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_VEC_2_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_CPU_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_SHIFT)
#define EVP_CPU_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_RANGE                     31:0
#define EVP_CPU_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_WOFFSET                   0x0
#define EVP_CPU_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_DEFAULT                   _MK_MASK_CONST(0x4000001c)
#define EVP_CPU_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_FIQ_NUM_3_0  
#define EVP_CPU_PRI_FIQ_NUM_3_0                 _MK_ADDR_CONST(0x198)
#define EVP_CPU_PRI_FIQ_NUM_3_0_SECURE                  0x0
#define EVP_CPU_PRI_FIQ_NUM_3_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_FIQ_NUM_3_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_FIQ_NUM_3_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_NUM_3_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_NUM_3_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_NUM_3_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_NUM_3_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_CPU_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_SHIFT)
#define EVP_CPU_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_RANGE                     31:0
#define EVP_CPU_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_WOFFSET                   0x0
#define EVP_CPU_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_CPU_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_CPU_PRI_FIQ_VEC_3_0  
#define EVP_CPU_PRI_FIQ_VEC_3_0                 _MK_ADDR_CONST(0x19c)
#define EVP_CPU_PRI_FIQ_VEC_3_0_SECURE                  0x0
#define EVP_CPU_PRI_FIQ_VEC_3_0_WORD_COUNT                      0x1
#define EVP_CPU_PRI_FIQ_VEC_3_0_RESET_VAL                       _MK_MASK_CONST(0x4000001c)
#define EVP_CPU_PRI_FIQ_VEC_3_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_VEC_3_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_VEC_3_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_VEC_3_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_VEC_3_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_CPU_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_CPU_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_CPU_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_SHIFT)
#define EVP_CPU_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_RANGE                     31:0
#define EVP_CPU_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_WOFFSET                   0x0
#define EVP_CPU_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_DEFAULT                   _MK_MASK_CONST(0x4000001c)
#define EVP_CPU_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_CPU_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_CPU_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_RESET_VECTOR_0  
#define EVP_COP_RESET_VECTOR_0                  _MK_ADDR_CONST(0x200)
#define EVP_COP_RESET_VECTOR_0_SECURE                   0x0
#define EVP_COP_RESET_VECTOR_0_WORD_COUNT                       0x1
#define EVP_COP_RESET_VECTOR_0_RESET_VAL                        _MK_MASK_CONST(0xfff00000)
#define EVP_COP_RESET_VECTOR_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_RESET_VECTOR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EVP_COP_RESET_VECTOR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EVP_COP_RESET_VECTOR_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_COP_RESET_VECTOR_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// RESET Exception Vector Pointer 
#define EVP_COP_RESET_VECTOR_0_COP_RESET_VECTOR_SHIFT                   _MK_SHIFT_CONST(0)
#define EVP_COP_RESET_VECTOR_0_COP_RESET_VECTOR_FIELD                   (_MK_MASK_CONST(0xffffffff) << EVP_COP_RESET_VECTOR_0_COP_RESET_VECTOR_SHIFT)
#define EVP_COP_RESET_VECTOR_0_COP_RESET_VECTOR_RANGE                   31:0
#define EVP_COP_RESET_VECTOR_0_COP_RESET_VECTOR_WOFFSET                 0x0
#define EVP_COP_RESET_VECTOR_0_COP_RESET_VECTOR_DEFAULT                 _MK_MASK_CONST(0xfff00000)
#define EVP_COP_RESET_VECTOR_0_COP_RESET_VECTOR_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define EVP_COP_RESET_VECTOR_0_COP_RESET_VECTOR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EVP_COP_RESET_VECTOR_0_COP_RESET_VECTOR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EVP_COP_RESET_VECTOR_0_COP_RESET_VECTOR_INIT_ENUM                       -1048576


// Register EVP_COP_UNDEF_VECTOR_0  
#define EVP_COP_UNDEF_VECTOR_0                  _MK_ADDR_CONST(0x204)
#define EVP_COP_UNDEF_VECTOR_0_SECURE                   0x0
#define EVP_COP_UNDEF_VECTOR_0_WORD_COUNT                       0x1
#define EVP_COP_UNDEF_VECTOR_0_RESET_VAL                        _MK_MASK_CONST(0xfff00004)
#define EVP_COP_UNDEF_VECTOR_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_UNDEF_VECTOR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EVP_COP_UNDEF_VECTOR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EVP_COP_UNDEF_VECTOR_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_COP_UNDEF_VECTOR_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// Undefined Exception Vector Pointer
#define EVP_COP_UNDEF_VECTOR_0_COP_UNDEF_VECTOR_SHIFT                   _MK_SHIFT_CONST(0)
#define EVP_COP_UNDEF_VECTOR_0_COP_UNDEF_VECTOR_FIELD                   (_MK_MASK_CONST(0xffffffff) << EVP_COP_UNDEF_VECTOR_0_COP_UNDEF_VECTOR_SHIFT)
#define EVP_COP_UNDEF_VECTOR_0_COP_UNDEF_VECTOR_RANGE                   31:0
#define EVP_COP_UNDEF_VECTOR_0_COP_UNDEF_VECTOR_WOFFSET                 0x0
#define EVP_COP_UNDEF_VECTOR_0_COP_UNDEF_VECTOR_DEFAULT                 _MK_MASK_CONST(0xfff00004)
#define EVP_COP_UNDEF_VECTOR_0_COP_UNDEF_VECTOR_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define EVP_COP_UNDEF_VECTOR_0_COP_UNDEF_VECTOR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EVP_COP_UNDEF_VECTOR_0_COP_UNDEF_VECTOR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EVP_COP_UNDEF_VECTOR_0_COP_UNDEF_VECTOR_INIT_ENUM                       -1048572


// Register EVP_COP_SWI_VECTOR_0  
#define EVP_COP_SWI_VECTOR_0                    _MK_ADDR_CONST(0x208)
#define EVP_COP_SWI_VECTOR_0_SECURE                     0x0
#define EVP_COP_SWI_VECTOR_0_WORD_COUNT                         0x1
#define EVP_COP_SWI_VECTOR_0_RESET_VAL                  _MK_MASK_CONST(0xfff00008)
#define EVP_COP_SWI_VECTOR_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define EVP_COP_SWI_VECTOR_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EVP_COP_SWI_VECTOR_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EVP_COP_SWI_VECTOR_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_COP_SWI_VECTOR_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
// Software Interrupt Vector Pointer
#define EVP_COP_SWI_VECTOR_0_COP_SWI_VECTOR_SHIFT                       _MK_SHIFT_CONST(0)
#define EVP_COP_SWI_VECTOR_0_COP_SWI_VECTOR_FIELD                       (_MK_MASK_CONST(0xffffffff) << EVP_COP_SWI_VECTOR_0_COP_SWI_VECTOR_SHIFT)
#define EVP_COP_SWI_VECTOR_0_COP_SWI_VECTOR_RANGE                       31:0
#define EVP_COP_SWI_VECTOR_0_COP_SWI_VECTOR_WOFFSET                     0x0
#define EVP_COP_SWI_VECTOR_0_COP_SWI_VECTOR_DEFAULT                     _MK_MASK_CONST(0xfff00008)
#define EVP_COP_SWI_VECTOR_0_COP_SWI_VECTOR_DEFAULT_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_COP_SWI_VECTOR_0_COP_SWI_VECTOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EVP_COP_SWI_VECTOR_0_COP_SWI_VECTOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_COP_SWI_VECTOR_0_COP_SWI_VECTOR_INIT_ENUM                   -1048568


// Register EVP_COP_PREFETCH_ABORT_VECTOR_0  
#define EVP_COP_PREFETCH_ABORT_VECTOR_0                 _MK_ADDR_CONST(0x20c)
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_SECURE                  0x0
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_WORD_COUNT                      0x1
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_RESET_VAL                       _MK_MASK_CONST(0xfff0000c)
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Code Prefetch ABORT Vector Pointer 
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_COP_PRE_ABORT_VECTOR_SHIFT                      _MK_SHIFT_CONST(0)
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_COP_PRE_ABORT_VECTOR_FIELD                      (_MK_MASK_CONST(0xffffffff) << EVP_COP_PREFETCH_ABORT_VECTOR_0_COP_PRE_ABORT_VECTOR_SHIFT)
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_COP_PRE_ABORT_VECTOR_RANGE                      31:0
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_COP_PRE_ABORT_VECTOR_WOFFSET                    0x0
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_COP_PRE_ABORT_VECTOR_DEFAULT                    _MK_MASK_CONST(0xfff0000c)
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_COP_PRE_ABORT_VECTOR_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_COP_PRE_ABORT_VECTOR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_COP_PRE_ABORT_VECTOR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EVP_COP_PREFETCH_ABORT_VECTOR_0_COP_PRE_ABORT_VECTOR_INIT_ENUM                  -1048564


// Register EVP_COP_DATA_ABORT_VECTOR_0  
#define EVP_COP_DATA_ABORT_VECTOR_0                     _MK_ADDR_CONST(0x210)
#define EVP_COP_DATA_ABORT_VECTOR_0_SECURE                      0x0
#define EVP_COP_DATA_ABORT_VECTOR_0_WORD_COUNT                  0x1
#define EVP_COP_DATA_ABORT_VECTOR_0_RESET_VAL                   _MK_MASK_CONST(0xfff00010)
#define EVP_COP_DATA_ABORT_VECTOR_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_COP_DATA_ABORT_VECTOR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EVP_COP_DATA_ABORT_VECTOR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_COP_DATA_ABORT_VECTOR_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EVP_COP_DATA_ABORT_VECTOR_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// Data ABORT Vector Pointer
#define EVP_COP_DATA_ABORT_VECTOR_0_COP_DATA_ABORT_VECTOR_SHIFT                 _MK_SHIFT_CONST(0)
#define EVP_COP_DATA_ABORT_VECTOR_0_COP_DATA_ABORT_VECTOR_FIELD                 (_MK_MASK_CONST(0xffffffff) << EVP_COP_DATA_ABORT_VECTOR_0_COP_DATA_ABORT_VECTOR_SHIFT)
#define EVP_COP_DATA_ABORT_VECTOR_0_COP_DATA_ABORT_VECTOR_RANGE                 31:0
#define EVP_COP_DATA_ABORT_VECTOR_0_COP_DATA_ABORT_VECTOR_WOFFSET                       0x0
#define EVP_COP_DATA_ABORT_VECTOR_0_COP_DATA_ABORT_VECTOR_DEFAULT                       _MK_MASK_CONST(0xfff00010)
#define EVP_COP_DATA_ABORT_VECTOR_0_COP_DATA_ABORT_VECTOR_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_COP_DATA_ABORT_VECTOR_0_COP_DATA_ABORT_VECTOR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EVP_COP_DATA_ABORT_VECTOR_0_COP_DATA_ABORT_VECTOR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EVP_COP_DATA_ABORT_VECTOR_0_COP_DATA_ABORT_VECTOR_INIT_ENUM                     -1048560


// Register EVP_COP_RSVD_VECTOR_0  
#define EVP_COP_RSVD_VECTOR_0                   _MK_ADDR_CONST(0x214)
#define EVP_COP_RSVD_VECTOR_0_SECURE                    0x0
#define EVP_COP_RSVD_VECTOR_0_WORD_COUNT                        0x1
#define EVP_COP_RSVD_VECTOR_0_RESET_VAL                         _MK_MASK_CONST(0xfff00014)
#define EVP_COP_RSVD_VECTOR_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_COP_RSVD_VECTOR_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EVP_COP_RSVD_VECTOR_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EVP_COP_RSVD_VECTOR_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define EVP_COP_RSVD_VECTOR_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// Reserved Exception Vector Pointer
#define EVP_COP_RSVD_VECTOR_0_COP_RSVD_VECTOR_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_RSVD_VECTOR_0_COP_RSVD_VECTOR_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_RSVD_VECTOR_0_COP_RSVD_VECTOR_SHIFT)
#define EVP_COP_RSVD_VECTOR_0_COP_RSVD_VECTOR_RANGE                     31:0
#define EVP_COP_RSVD_VECTOR_0_COP_RSVD_VECTOR_WOFFSET                   0x0
#define EVP_COP_RSVD_VECTOR_0_COP_RSVD_VECTOR_DEFAULT                   _MK_MASK_CONST(0xfff00014)
#define EVP_COP_RSVD_VECTOR_0_COP_RSVD_VECTOR_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_RSVD_VECTOR_0_COP_RSVD_VECTOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_RSVD_VECTOR_0_COP_RSVD_VECTOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EVP_COP_RSVD_VECTOR_0_COP_RSVD_VECTOR_INIT_ENUM                 -1048556


// Register EVP_COP_IRQ_VECTOR_0  
#define EVP_COP_IRQ_VECTOR_0                    _MK_ADDR_CONST(0x218)
#define EVP_COP_IRQ_VECTOR_0_SECURE                     0x0
#define EVP_COP_IRQ_VECTOR_0_WORD_COUNT                         0x1
#define EVP_COP_IRQ_VECTOR_0_RESET_VAL                  _MK_MASK_CONST(0xfff00018)
#define EVP_COP_IRQ_VECTOR_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define EVP_COP_IRQ_VECTOR_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EVP_COP_IRQ_VECTOR_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EVP_COP_IRQ_VECTOR_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_COP_IRQ_VECTOR_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
// IRQ Vector Pointer 
#define EVP_COP_IRQ_VECTOR_0_COP_IRQ_VECTOR_SHIFT                       _MK_SHIFT_CONST(0)
#define EVP_COP_IRQ_VECTOR_0_COP_IRQ_VECTOR_FIELD                       (_MK_MASK_CONST(0xffffffff) << EVP_COP_IRQ_VECTOR_0_COP_IRQ_VECTOR_SHIFT)
#define EVP_COP_IRQ_VECTOR_0_COP_IRQ_VECTOR_RANGE                       31:0
#define EVP_COP_IRQ_VECTOR_0_COP_IRQ_VECTOR_WOFFSET                     0x0
#define EVP_COP_IRQ_VECTOR_0_COP_IRQ_VECTOR_DEFAULT                     _MK_MASK_CONST(0xfff00018)
#define EVP_COP_IRQ_VECTOR_0_COP_IRQ_VECTOR_DEFAULT_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_COP_IRQ_VECTOR_0_COP_IRQ_VECTOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EVP_COP_IRQ_VECTOR_0_COP_IRQ_VECTOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_COP_IRQ_VECTOR_0_COP_IRQ_VECTOR_INIT_ENUM                   -1048552


// Register EVP_COP_FIQ_VECTOR_0  
#define EVP_COP_FIQ_VECTOR_0                    _MK_ADDR_CONST(0x21c)
#define EVP_COP_FIQ_VECTOR_0_SECURE                     0x0
#define EVP_COP_FIQ_VECTOR_0_WORD_COUNT                         0x1
#define EVP_COP_FIQ_VECTOR_0_RESET_VAL                  _MK_MASK_CONST(0xfff0001c)
#define EVP_COP_FIQ_VECTOR_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define EVP_COP_FIQ_VECTOR_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EVP_COP_FIQ_VECTOR_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EVP_COP_FIQ_VECTOR_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EVP_COP_FIQ_VECTOR_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
// FIQ Vector Pointer 
#define EVP_COP_FIQ_VECTOR_0_COP_FIQ_VECTOR_SHIFT                       _MK_SHIFT_CONST(0)
#define EVP_COP_FIQ_VECTOR_0_COP_FIQ_VECTOR_FIELD                       (_MK_MASK_CONST(0xffffffff) << EVP_COP_FIQ_VECTOR_0_COP_FIQ_VECTOR_SHIFT)
#define EVP_COP_FIQ_VECTOR_0_COP_FIQ_VECTOR_RANGE                       31:0
#define EVP_COP_FIQ_VECTOR_0_COP_FIQ_VECTOR_WOFFSET                     0x0
#define EVP_COP_FIQ_VECTOR_0_COP_FIQ_VECTOR_DEFAULT                     _MK_MASK_CONST(0xfff0001c)
#define EVP_COP_FIQ_VECTOR_0_COP_FIQ_VECTOR_DEFAULT_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_COP_FIQ_VECTOR_0_COP_FIQ_VECTOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EVP_COP_FIQ_VECTOR_0_COP_FIQ_VECTOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EVP_COP_FIQ_VECTOR_0_COP_FIQ_VECTOR_INIT_ENUM                   -1048548


// Register EVP_COP_IRQ_STS_0  
#define EVP_COP_IRQ_STS_0                       _MK_ADDR_CONST(0x220)
#define EVP_COP_IRQ_STS_0_SECURE                        0x0
#define EVP_COP_IRQ_STS_0_WORD_COUNT                    0x1
#define EVP_COP_IRQ_STS_0_RESET_VAL                     _MK_MASK_CONST(0x80)
#define EVP_COP_IRQ_STS_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define EVP_COP_IRQ_STS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EVP_COP_IRQ_STS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EVP_COP_IRQ_STS_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define EVP_COP_IRQ_STS_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
// FFS (from lsb) IRQ index  (0x80 indicates no active IRQ)
#define EVP_COP_IRQ_STS_0_COP_IRQ_STS_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_IRQ_STS_0_COP_IRQ_STS_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_IRQ_STS_0_COP_IRQ_STS_SHIFT)
#define EVP_COP_IRQ_STS_0_COP_IRQ_STS_RANGE                     31:0
#define EVP_COP_IRQ_STS_0_COP_IRQ_STS_WOFFSET                   0x0
#define EVP_COP_IRQ_STS_0_COP_IRQ_STS_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_COP_IRQ_STS_0_COP_IRQ_STS_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_IRQ_STS_0_COP_IRQ_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_IRQ_STS_0_COP_IRQ_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_STS_0  
#define EVP_COP_PRI_IRQ_STS_0                   _MK_ADDR_CONST(0x224)
#define EVP_COP_PRI_IRQ_STS_0_SECURE                    0x0
#define EVP_COP_PRI_IRQ_STS_0_WORD_COUNT                        0x1
#define EVP_COP_PRI_IRQ_STS_0_RESET_VAL                         _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_STS_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_STS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_STS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_STS_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_STS_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// Current highest priority active IRQ (0x80 indicates no active priority IRQ)
#define EVP_COP_PRI_IRQ_STS_0_COP_PRI_IRQ_STS_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_STS_0_COP_PRI_IRQ_STS_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_STS_0_COP_PRI_IRQ_STS_SHIFT)
#define EVP_COP_PRI_IRQ_STS_0_COP_PRI_IRQ_STS_RANGE                     31:0
#define EVP_COP_PRI_IRQ_STS_0_COP_PRI_IRQ_STS_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_STS_0_COP_PRI_IRQ_STS_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_STS_0_COP_PRI_IRQ_STS_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_STS_0_COP_PRI_IRQ_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_STS_0_COP_PRI_IRQ_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_FIQ_STS_0  
#define EVP_COP_FIQ_STS_0                       _MK_ADDR_CONST(0x228)
#define EVP_COP_FIQ_STS_0_SECURE                        0x0
#define EVP_COP_FIQ_STS_0_WORD_COUNT                    0x1
#define EVP_COP_FIQ_STS_0_RESET_VAL                     _MK_MASK_CONST(0x80)
#define EVP_COP_FIQ_STS_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define EVP_COP_FIQ_STS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EVP_COP_FIQ_STS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EVP_COP_FIQ_STS_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define EVP_COP_FIQ_STS_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
// FFS (from lsb) FIQ index (0x80 indicates no active FIQ)
#define EVP_COP_FIQ_STS_0_COP_FIQ_STS_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_FIQ_STS_0_COP_FIQ_STS_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_FIQ_STS_0_COP_FIQ_STS_SHIFT)
#define EVP_COP_FIQ_STS_0_COP_FIQ_STS_RANGE                     31:0
#define EVP_COP_FIQ_STS_0_COP_FIQ_STS_WOFFSET                   0x0
#define EVP_COP_FIQ_STS_0_COP_FIQ_STS_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_COP_FIQ_STS_0_COP_FIQ_STS_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_FIQ_STS_0_COP_FIQ_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_FIQ_STS_0_COP_FIQ_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_FIQ_STS_0  
#define EVP_COP_PRI_FIQ_STS_0                   _MK_ADDR_CONST(0x22c)
#define EVP_COP_PRI_FIQ_STS_0_SECURE                    0x0
#define EVP_COP_PRI_FIQ_STS_0_WORD_COUNT                        0x1
#define EVP_COP_PRI_FIQ_STS_0_RESET_VAL                         _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_FIQ_STS_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_STS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_STS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_STS_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_STS_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// Current highest priority active FIQ (0x80 indicates no active priority FIQ)
#define EVP_COP_PRI_FIQ_STS_0_COP_PRI_FIQ_STS_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_FIQ_STS_0_COP_PRI_FIQ_STS_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_FIQ_STS_0_COP_PRI_FIQ_STS_SHIFT)
#define EVP_COP_PRI_FIQ_STS_0_COP_PRI_FIQ_STS_RANGE                     31:0
#define EVP_COP_PRI_FIQ_STS_0_COP_PRI_FIQ_STS_WOFFSET                   0x0
#define EVP_COP_PRI_FIQ_STS_0_COP_PRI_FIQ_STS_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_FIQ_STS_0_COP_PRI_FIQ_STS_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_STS_0_COP_PRI_FIQ_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_STS_0_COP_PRI_FIQ_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_NUM_0_0  
#define EVP_COP_PRI_IRQ_NUM_0_0                 _MK_ADDR_CONST(0x240)
#define EVP_COP_PRI_IRQ_NUM_0_0_SECURE                  0x0
#define EVP_COP_PRI_IRQ_NUM_0_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_IRQ_NUM_0_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_NUM_0_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_0_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_0_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_COP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_SHIFT)
#define EVP_COP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_RANGE                     31:0
#define EVP_COP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_0_0_PRI_IRQ_NUM_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_VEC_0_0  
#define EVP_COP_PRI_IRQ_VEC_0_0                 _MK_ADDR_CONST(0x244)
#define EVP_COP_PRI_IRQ_VEC_0_0_SECURE                  0x0
#define EVP_COP_PRI_IRQ_VEC_0_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_IRQ_VEC_0_0_RESET_VAL                       _MK_MASK_CONST(0x40000018)
#define EVP_COP_PRI_IRQ_VEC_0_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_0_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_0_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_COP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_SHIFT)
#define EVP_COP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_RANGE                     31:0
#define EVP_COP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_DEFAULT                   _MK_MASK_CONST(0x40000018)
#define EVP_COP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_0_0_PRI_IRQ_VEC_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_NUM_1_0  
#define EVP_COP_PRI_IRQ_NUM_1_0                 _MK_ADDR_CONST(0x248)
#define EVP_COP_PRI_IRQ_NUM_1_0_SECURE                  0x0
#define EVP_COP_PRI_IRQ_NUM_1_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_IRQ_NUM_1_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_NUM_1_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_1_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_1_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_COP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_SHIFT)
#define EVP_COP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_RANGE                     31:0
#define EVP_COP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_1_0_PRI_IRQ_NUM_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_VEC_1_0  
#define EVP_COP_PRI_IRQ_VEC_1_0                 _MK_ADDR_CONST(0x24c)
#define EVP_COP_PRI_IRQ_VEC_1_0_SECURE                  0x0
#define EVP_COP_PRI_IRQ_VEC_1_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_IRQ_VEC_1_0_RESET_VAL                       _MK_MASK_CONST(0x40000018)
#define EVP_COP_PRI_IRQ_VEC_1_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_1_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_1_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_COP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_SHIFT)
#define EVP_COP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_RANGE                     31:0
#define EVP_COP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_DEFAULT                   _MK_MASK_CONST(0x40000018)
#define EVP_COP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_1_0_PRI_IRQ_VEC_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_NUM_2_0  
#define EVP_COP_PRI_IRQ_NUM_2_0                 _MK_ADDR_CONST(0x250)
#define EVP_COP_PRI_IRQ_NUM_2_0_SECURE                  0x0
#define EVP_COP_PRI_IRQ_NUM_2_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_IRQ_NUM_2_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_NUM_2_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_2_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_2_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_COP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_SHIFT)
#define EVP_COP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_RANGE                     31:0
#define EVP_COP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_2_0_PRI_IRQ_NUM_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_VEC_2_0  
#define EVP_COP_PRI_IRQ_VEC_2_0                 _MK_ADDR_CONST(0x254)
#define EVP_COP_PRI_IRQ_VEC_2_0_SECURE                  0x0
#define EVP_COP_PRI_IRQ_VEC_2_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_IRQ_VEC_2_0_RESET_VAL                       _MK_MASK_CONST(0x40000018)
#define EVP_COP_PRI_IRQ_VEC_2_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_2_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_2_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_COP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_SHIFT)
#define EVP_COP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_RANGE                     31:0
#define EVP_COP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_DEFAULT                   _MK_MASK_CONST(0x40000018)
#define EVP_COP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_2_0_PRI_IRQ_VEC_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_NUM_3_0  
#define EVP_COP_PRI_IRQ_NUM_3_0                 _MK_ADDR_CONST(0x258)
#define EVP_COP_PRI_IRQ_NUM_3_0_SECURE                  0x0
#define EVP_COP_PRI_IRQ_NUM_3_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_IRQ_NUM_3_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_NUM_3_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_3_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_3_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_3_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_3_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_COP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_SHIFT)
#define EVP_COP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_RANGE                     31:0
#define EVP_COP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_3_0_PRI_IRQ_NUM_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_VEC_3_0  
#define EVP_COP_PRI_IRQ_VEC_3_0                 _MK_ADDR_CONST(0x25c)
#define EVP_COP_PRI_IRQ_VEC_3_0_SECURE                  0x0
#define EVP_COP_PRI_IRQ_VEC_3_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_IRQ_VEC_3_0_RESET_VAL                       _MK_MASK_CONST(0x40000018)
#define EVP_COP_PRI_IRQ_VEC_3_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_3_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_3_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_3_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_3_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_COP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_SHIFT)
#define EVP_COP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_RANGE                     31:0
#define EVP_COP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_DEFAULT                   _MK_MASK_CONST(0x40000018)
#define EVP_COP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_3_0_PRI_IRQ_VEC_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_NUM_4_0  
#define EVP_COP_PRI_IRQ_NUM_4_0                 _MK_ADDR_CONST(0x260)
#define EVP_COP_PRI_IRQ_NUM_4_0_SECURE                  0x0
#define EVP_COP_PRI_IRQ_NUM_4_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_IRQ_NUM_4_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_NUM_4_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_4_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_4_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_4_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_4_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_COP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_SHIFT)
#define EVP_COP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_RANGE                     31:0
#define EVP_COP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_4_0_PRI_IRQ_NUM_4_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_VEC_4_0  
#define EVP_COP_PRI_IRQ_VEC_4_0                 _MK_ADDR_CONST(0x264)
#define EVP_COP_PRI_IRQ_VEC_4_0_SECURE                  0x0
#define EVP_COP_PRI_IRQ_VEC_4_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_IRQ_VEC_4_0_RESET_VAL                       _MK_MASK_CONST(0x40000018)
#define EVP_COP_PRI_IRQ_VEC_4_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_4_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_4_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_4_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_4_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_COP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_SHIFT)
#define EVP_COP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_RANGE                     31:0
#define EVP_COP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_DEFAULT                   _MK_MASK_CONST(0x40000018)
#define EVP_COP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_4_0_PRI_IRQ_VEC_4_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_NUM_5_0  
#define EVP_COP_PRI_IRQ_NUM_5_0                 _MK_ADDR_CONST(0x268)
#define EVP_COP_PRI_IRQ_NUM_5_0_SECURE                  0x0
#define EVP_COP_PRI_IRQ_NUM_5_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_IRQ_NUM_5_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_NUM_5_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_5_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_5_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_5_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_5_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_COP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_SHIFT)
#define EVP_COP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_RANGE                     31:0
#define EVP_COP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_5_0_PRI_IRQ_NUM_5_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_VEC_5_0  
#define EVP_COP_PRI_IRQ_VEC_5_0                 _MK_ADDR_CONST(0x26c)
#define EVP_COP_PRI_IRQ_VEC_5_0_SECURE                  0x0
#define EVP_COP_PRI_IRQ_VEC_5_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_IRQ_VEC_5_0_RESET_VAL                       _MK_MASK_CONST(0x40000018)
#define EVP_COP_PRI_IRQ_VEC_5_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_5_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_5_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_5_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_5_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_COP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_SHIFT)
#define EVP_COP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_RANGE                     31:0
#define EVP_COP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_DEFAULT                   _MK_MASK_CONST(0x40000018)
#define EVP_COP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_5_0_PRI_IRQ_VEC_5_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_NUM_6_0  
#define EVP_COP_PRI_IRQ_NUM_6_0                 _MK_ADDR_CONST(0x270)
#define EVP_COP_PRI_IRQ_NUM_6_0_SECURE                  0x0
#define EVP_COP_PRI_IRQ_NUM_6_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_IRQ_NUM_6_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_NUM_6_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_6_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_6_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_6_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_6_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_COP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_SHIFT)
#define EVP_COP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_RANGE                     31:0
#define EVP_COP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_6_0_PRI_IRQ_NUM_6_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_VEC_6_0  
#define EVP_COP_PRI_IRQ_VEC_6_0                 _MK_ADDR_CONST(0x274)
#define EVP_COP_PRI_IRQ_VEC_6_0_SECURE                  0x0
#define EVP_COP_PRI_IRQ_VEC_6_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_IRQ_VEC_6_0_RESET_VAL                       _MK_MASK_CONST(0x40000018)
#define EVP_COP_PRI_IRQ_VEC_6_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_6_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_6_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_6_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_6_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_COP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_SHIFT)
#define EVP_COP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_RANGE                     31:0
#define EVP_COP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_DEFAULT                   _MK_MASK_CONST(0x40000018)
#define EVP_COP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_6_0_PRI_IRQ_VEC_6_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_NUM_7_0  
#define EVP_COP_PRI_IRQ_NUM_7_0                 _MK_ADDR_CONST(0x278)
#define EVP_COP_PRI_IRQ_NUM_7_0_SECURE                  0x0
#define EVP_COP_PRI_IRQ_NUM_7_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_IRQ_NUM_7_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_NUM_7_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_7_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_7_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_7_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_7_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_COP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_SHIFT)
#define EVP_COP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_RANGE                     31:0
#define EVP_COP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_NUM_7_0_PRI_IRQ_NUM_7_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_IRQ_VEC_7_0  
#define EVP_COP_PRI_IRQ_VEC_7_0                 _MK_ADDR_CONST(0x27c)
#define EVP_COP_PRI_IRQ_VEC_7_0_SECURE                  0x0
#define EVP_COP_PRI_IRQ_VEC_7_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_IRQ_VEC_7_0_RESET_VAL                       _MK_MASK_CONST(0x40000018)
#define EVP_COP_PRI_IRQ_VEC_7_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_7_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_7_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_7_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_7_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_COP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_SHIFT)
#define EVP_COP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_RANGE                     31:0
#define EVP_COP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_WOFFSET                   0x0
#define EVP_COP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_DEFAULT                   _MK_MASK_CONST(0x40000018)
#define EVP_COP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_IRQ_VEC_7_0_PRI_IRQ_VEC_7_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_FIQ_NUM_0_0  
#define EVP_COP_PRI_FIQ_NUM_0_0                 _MK_ADDR_CONST(0x280)
#define EVP_COP_PRI_FIQ_NUM_0_0_SECURE                  0x0
#define EVP_COP_PRI_FIQ_NUM_0_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_FIQ_NUM_0_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_FIQ_NUM_0_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_NUM_0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_NUM_0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_NUM_0_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_NUM_0_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_COP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_SHIFT)
#define EVP_COP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_RANGE                     31:0
#define EVP_COP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_WOFFSET                   0x0
#define EVP_COP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_NUM_0_0_PRI_FIQ_NUM_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_FIQ_VEC_0_0  
#define EVP_COP_PRI_FIQ_VEC_0_0                 _MK_ADDR_CONST(0x284)
#define EVP_COP_PRI_FIQ_VEC_0_0_SECURE                  0x0
#define EVP_COP_PRI_FIQ_VEC_0_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_FIQ_VEC_0_0_RESET_VAL                       _MK_MASK_CONST(0x4000001c)
#define EVP_COP_PRI_FIQ_VEC_0_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_VEC_0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_VEC_0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_VEC_0_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_VEC_0_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_COP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_SHIFT)
#define EVP_COP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_RANGE                     31:0
#define EVP_COP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_WOFFSET                   0x0
#define EVP_COP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_DEFAULT                   _MK_MASK_CONST(0x4000001c)
#define EVP_COP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_VEC_0_0_PRI_FIQ_VEC_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_FIQ_NUM_1_0  
#define EVP_COP_PRI_FIQ_NUM_1_0                 _MK_ADDR_CONST(0x288)
#define EVP_COP_PRI_FIQ_NUM_1_0_SECURE                  0x0
#define EVP_COP_PRI_FIQ_NUM_1_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_FIQ_NUM_1_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_FIQ_NUM_1_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_NUM_1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_NUM_1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_NUM_1_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_NUM_1_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_COP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_SHIFT)
#define EVP_COP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_RANGE                     31:0
#define EVP_COP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_WOFFSET                   0x0
#define EVP_COP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_NUM_1_0_PRI_FIQ_NUM_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_FIQ_VEC_1_0  
#define EVP_COP_PRI_FIQ_VEC_1_0                 _MK_ADDR_CONST(0x28c)
#define EVP_COP_PRI_FIQ_VEC_1_0_SECURE                  0x0
#define EVP_COP_PRI_FIQ_VEC_1_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_FIQ_VEC_1_0_RESET_VAL                       _MK_MASK_CONST(0x4000001c)
#define EVP_COP_PRI_FIQ_VEC_1_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_VEC_1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_VEC_1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_VEC_1_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_VEC_1_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_COP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_SHIFT)
#define EVP_COP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_RANGE                     31:0
#define EVP_COP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_WOFFSET                   0x0
#define EVP_COP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_DEFAULT                   _MK_MASK_CONST(0x4000001c)
#define EVP_COP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_VEC_1_0_PRI_FIQ_VEC_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_FIQ_NUM_2_0  
#define EVP_COP_PRI_FIQ_NUM_2_0                 _MK_ADDR_CONST(0x290)
#define EVP_COP_PRI_FIQ_NUM_2_0_SECURE                  0x0
#define EVP_COP_PRI_FIQ_NUM_2_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_FIQ_NUM_2_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_FIQ_NUM_2_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_NUM_2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_NUM_2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_NUM_2_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_NUM_2_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_COP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_SHIFT)
#define EVP_COP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_RANGE                     31:0
#define EVP_COP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_WOFFSET                   0x0
#define EVP_COP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_NUM_2_0_PRI_FIQ_NUM_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_FIQ_VEC_2_0  
#define EVP_COP_PRI_FIQ_VEC_2_0                 _MK_ADDR_CONST(0x294)
#define EVP_COP_PRI_FIQ_VEC_2_0_SECURE                  0x0
#define EVP_COP_PRI_FIQ_VEC_2_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_FIQ_VEC_2_0_RESET_VAL                       _MK_MASK_CONST(0x4000001c)
#define EVP_COP_PRI_FIQ_VEC_2_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_VEC_2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_VEC_2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_VEC_2_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_VEC_2_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_COP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_SHIFT)
#define EVP_COP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_RANGE                     31:0
#define EVP_COP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_WOFFSET                   0x0
#define EVP_COP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_DEFAULT                   _MK_MASK_CONST(0x4000001c)
#define EVP_COP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_VEC_2_0_PRI_FIQ_VEC_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_FIQ_NUM_3_0  
#define EVP_COP_PRI_FIQ_NUM_3_0                 _MK_ADDR_CONST(0x298)
#define EVP_COP_PRI_FIQ_NUM_3_0_SECURE                  0x0
#define EVP_COP_PRI_FIQ_NUM_3_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_FIQ_NUM_3_0_RESET_VAL                       _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_FIQ_NUM_3_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_NUM_3_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_NUM_3_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_NUM_3_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_NUM_3_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Number for the Interrupt associated with this entry
#define EVP_COP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_SHIFT)
#define EVP_COP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_RANGE                     31:0
#define EVP_COP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_WOFFSET                   0x0
#define EVP_COP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_DEFAULT                   _MK_MASK_CONST(0x80)
#define EVP_COP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_NUM_3_0_PRI_FIQ_NUM_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EVP_COP_PRI_FIQ_VEC_3_0  
#define EVP_COP_PRI_FIQ_VEC_3_0                 _MK_ADDR_CONST(0x29c)
#define EVP_COP_PRI_FIQ_VEC_3_0_SECURE                  0x0
#define EVP_COP_PRI_FIQ_VEC_3_0_WORD_COUNT                      0x1
#define EVP_COP_PRI_FIQ_VEC_3_0_RESET_VAL                       _MK_MASK_CONST(0x4000001c)
#define EVP_COP_PRI_FIQ_VEC_3_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_VEC_3_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_VEC_3_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_VEC_3_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_VEC_3_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Pointer to the interrupt handler for the above interrupt 
#define EVP_COP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_SHIFT                     _MK_SHIFT_CONST(0)
#define EVP_COP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_FIELD                     (_MK_MASK_CONST(0xffffffff) << EVP_COP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_SHIFT)
#define EVP_COP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_RANGE                     31:0
#define EVP_COP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_WOFFSET                   0x0
#define EVP_COP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_DEFAULT                   _MK_MASK_CONST(0x4000001c)
#define EVP_COP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define EVP_COP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EVP_COP_PRI_FIQ_VEC_3_0_PRI_FIQ_VEC_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_AREVP_REGS(_op_) \
_op_(EVP_RESET_VECTOR_0) \
_op_(EVP_UNDEF_VECTOR_0) \
_op_(EVP_SWI_VECTOR_0) \
_op_(EVP_PREFETCH_ABORT_VECTOR_0) \
_op_(EVP_DATA_ABORT_VECTOR_0) \
_op_(EVP_RSVD_VECTOR_0) \
_op_(EVP_IRQ_VECTOR_0) \
_op_(EVP_FIQ_VECTOR_0) \
_op_(EVP_IRQ_STS_0) \
_op_(EVP_PRI_IRQ_STS_0) \
_op_(EVP_FIQ_STS_0) \
_op_(EVP_PRI_FIQ_STS_0) \
_op_(EVP_PRI_IRQ_NUM_0_0) \
_op_(EVP_PRI_IRQ_VEC_0_0) \
_op_(EVP_PRI_IRQ_NUM_1_0) \
_op_(EVP_PRI_IRQ_VEC_1_0) \
_op_(EVP_PRI_IRQ_NUM_2_0) \
_op_(EVP_PRI_IRQ_VEC_2_0) \
_op_(EVP_PRI_IRQ_NUM_3_0) \
_op_(EVP_PRI_IRQ_VEC_3_0) \
_op_(EVP_PRI_IRQ_NUM_4_0) \
_op_(EVP_PRI_IRQ_VEC_4_0) \
_op_(EVP_PRI_IRQ_NUM_5_0) \
_op_(EVP_PRI_IRQ_VEC_5_0) \
_op_(EVP_PRI_IRQ_NUM_6_0) \
_op_(EVP_PRI_IRQ_VEC_6_0) \
_op_(EVP_PRI_IRQ_NUM_7_0) \
_op_(EVP_PRI_IRQ_VEC_7_0) \
_op_(EVP_PRI_FIQ_NUM_0_0) \
_op_(EVP_PRI_FIQ_VEC_0_0) \
_op_(EVP_PRI_FIQ_NUM_1_0) \
_op_(EVP_PRI_FIQ_VEC_1_0) \
_op_(EVP_PRI_FIQ_NUM_2_0) \
_op_(EVP_PRI_FIQ_VEC_2_0) \
_op_(EVP_PRI_FIQ_NUM_3_0) \
_op_(EVP_PRI_FIQ_VEC_3_0) \
_op_(EVP_CPU_RESET_VECTOR_0) \
_op_(EVP_CPU_UNDEF_VECTOR_0) \
_op_(EVP_CPU_SWI_VECTOR_0) \
_op_(EVP_CPU_PREFETCH_ABORT_VECTOR_0) \
_op_(EVP_CPU_DATA_ABORT_VECTOR_0) \
_op_(EVP_CPU_RSVD_VECTOR_0) \
_op_(EVP_CPU_IRQ_VECTOR_0) \
_op_(EVP_CPU_FIQ_VECTOR_0) \
_op_(EVP_CPU_IRQ_STS_0) \
_op_(EVP_CPU_PRI_IRQ_STS_0) \
_op_(EVP_CPU_FIQ_STS_0) \
_op_(EVP_CPU_PRI_FIQ_STS_0) \
_op_(EVP_CPU_PRI_IRQ_NUM_0_0) \
_op_(EVP_CPU_PRI_IRQ_VEC_0_0) \
_op_(EVP_CPU_PRI_IRQ_NUM_1_0) \
_op_(EVP_CPU_PRI_IRQ_VEC_1_0) \
_op_(EVP_CPU_PRI_IRQ_NUM_2_0) \
_op_(EVP_CPU_PRI_IRQ_VEC_2_0) \
_op_(EVP_CPU_PRI_IRQ_NUM_3_0) \
_op_(EVP_CPU_PRI_IRQ_VEC_3_0) \
_op_(EVP_CPU_PRI_IRQ_NUM_4_0) \
_op_(EVP_CPU_PRI_IRQ_VEC_4_0) \
_op_(EVP_CPU_PRI_IRQ_NUM_5_0) \
_op_(EVP_CPU_PRI_IRQ_VEC_5_0) \
_op_(EVP_CPU_PRI_IRQ_NUM_6_0) \
_op_(EVP_CPU_PRI_IRQ_VEC_6_0) \
_op_(EVP_CPU_PRI_IRQ_NUM_7_0) \
_op_(EVP_CPU_PRI_IRQ_VEC_7_0) \
_op_(EVP_CPU_PRI_FIQ_NUM_0_0) \
_op_(EVP_CPU_PRI_FIQ_VEC_0_0) \
_op_(EVP_CPU_PRI_FIQ_NUM_1_0) \
_op_(EVP_CPU_PRI_FIQ_VEC_1_0) \
_op_(EVP_CPU_PRI_FIQ_NUM_2_0) \
_op_(EVP_CPU_PRI_FIQ_VEC_2_0) \
_op_(EVP_CPU_PRI_FIQ_NUM_3_0) \
_op_(EVP_CPU_PRI_FIQ_VEC_3_0) \
_op_(EVP_COP_RESET_VECTOR_0) \
_op_(EVP_COP_UNDEF_VECTOR_0) \
_op_(EVP_COP_SWI_VECTOR_0) \
_op_(EVP_COP_PREFETCH_ABORT_VECTOR_0) \
_op_(EVP_COP_DATA_ABORT_VECTOR_0) \
_op_(EVP_COP_RSVD_VECTOR_0) \
_op_(EVP_COP_IRQ_VECTOR_0) \
_op_(EVP_COP_FIQ_VECTOR_0) \
_op_(EVP_COP_IRQ_STS_0) \
_op_(EVP_COP_PRI_IRQ_STS_0) \
_op_(EVP_COP_FIQ_STS_0) \
_op_(EVP_COP_PRI_FIQ_STS_0) \
_op_(EVP_COP_PRI_IRQ_NUM_0_0) \
_op_(EVP_COP_PRI_IRQ_VEC_0_0) \
_op_(EVP_COP_PRI_IRQ_NUM_1_0) \
_op_(EVP_COP_PRI_IRQ_VEC_1_0) \
_op_(EVP_COP_PRI_IRQ_NUM_2_0) \
_op_(EVP_COP_PRI_IRQ_VEC_2_0) \
_op_(EVP_COP_PRI_IRQ_NUM_3_0) \
_op_(EVP_COP_PRI_IRQ_VEC_3_0) \
_op_(EVP_COP_PRI_IRQ_NUM_4_0) \
_op_(EVP_COP_PRI_IRQ_VEC_4_0) \
_op_(EVP_COP_PRI_IRQ_NUM_5_0) \
_op_(EVP_COP_PRI_IRQ_VEC_5_0) \
_op_(EVP_COP_PRI_IRQ_NUM_6_0) \
_op_(EVP_COP_PRI_IRQ_VEC_6_0) \
_op_(EVP_COP_PRI_IRQ_NUM_7_0) \
_op_(EVP_COP_PRI_IRQ_VEC_7_0) \
_op_(EVP_COP_PRI_FIQ_NUM_0_0) \
_op_(EVP_COP_PRI_FIQ_VEC_0_0) \
_op_(EVP_COP_PRI_FIQ_NUM_1_0) \
_op_(EVP_COP_PRI_FIQ_VEC_1_0) \
_op_(EVP_COP_PRI_FIQ_NUM_2_0) \
_op_(EVP_COP_PRI_FIQ_VEC_2_0) \
_op_(EVP_COP_PRI_FIQ_NUM_3_0) \
_op_(EVP_COP_PRI_FIQ_VEC_3_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_EVP        0x00000000

//
// AREVP REGISTER BANKS
//

#define EVP0_FIRST_REG 0x0000 // EVP_RESET_VECTOR_0
#define EVP0_LAST_REG 0x002c // EVP_PRI_FIQ_STS_0
#define EVP1_FIRST_REG 0x0040 // EVP_PRI_IRQ_NUM_0_0
#define EVP1_LAST_REG 0x009c // EVP_PRI_FIQ_VEC_3_0
#define EVP2_FIRST_REG 0x0100 // EVP_CPU_RESET_VECTOR_0
#define EVP2_LAST_REG 0x012c // EVP_CPU_PRI_FIQ_STS_0
#define EVP3_FIRST_REG 0x0140 // EVP_CPU_PRI_IRQ_NUM_0_0
#define EVP3_LAST_REG 0x019c // EVP_CPU_PRI_FIQ_VEC_3_0
#define EVP4_FIRST_REG 0x0200 // EVP_COP_RESET_VECTOR_0
#define EVP4_LAST_REG 0x022c // EVP_COP_PRI_FIQ_STS_0
#define EVP5_FIRST_REG 0x0240 // EVP_COP_PRI_IRQ_NUM_0_0
#define EVP5_LAST_REG 0x029c // EVP_COP_PRI_FIQ_VEC_3_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___AREVP_H_INC_
