/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARFUSE_H_INC_
#define ___ARFUSE_H_INC_

// Register FUSE_FUSECTRL_0  
#define FUSE_FUSECTRL_0                 _MK_ADDR_CONST(0x0)
#define FUSE_FUSECTRL_0_SECURE                  0x0
#define FUSE_FUSECTRL_0_WORD_COUNT                      0x1
#define FUSE_FUSECTRL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_RESET_MASK                      _MK_MASK_CONST(0x3)
#define FUSE_FUSECTRL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_READ_MASK                       _MK_MASK_CONST(0xc00f0000)
#define FUSE_FUSECTRL_0_WRITE_MASK                      _MK_MASK_CONST(0x3)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_FIELD                      (_MK_MASK_CONST(0x3) << FUSE_FUSECTRL_0_FUSECTRL_CMD_SHIFT)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_RANGE                      1:0
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_WOFFSET                    0x0
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_INIT_ENUM                  IDLE
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_IDLE                       _MK_ENUM_CONST(0)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_READ                       _MK_ENUM_CONST(1)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_WRITE                      _MK_ENUM_CONST(2)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_SENSE_CTRL                 _MK_ENUM_CONST(3)

#define FUSE_FUSECTRL_0_FUSECTRL_STATE_SHIFT                    _MK_SHIFT_CONST(16)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_FIELD                    (_MK_MASK_CONST(0xf) << FUSE_FUSECTRL_0_FUSECTRL_STATE_SHIFT)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_RANGE                    19:16
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_WOFFSET                  0x0
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_STATE_RESET                      _MK_ENUM_CONST(0)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_STATE_POST_RESET                 _MK_ENUM_CONST(1)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_STATE_LOAD_ROW0                  _MK_ENUM_CONST(2)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_STATE_LOAD_ROW1                  _MK_ENUM_CONST(3)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_STATE_IDLE                       _MK_ENUM_CONST(4)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_STATE_READ_SETUP                 _MK_ENUM_CONST(5)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_STATE_READ_STROBE                        _MK_ENUM_CONST(6)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_STATE_SAMPLE_FUSES                       _MK_ENUM_CONST(7)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_STATE_READ_HOLD                  _MK_ENUM_CONST(8)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_STATE_WRITE_SETUP                        _MK_ENUM_CONST(9)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_STATE_WRITE_ADDR_SETUP                   _MK_ENUM_CONST(10)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_STATE_WRITE_PROGRAM                      _MK_ENUM_CONST(11)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_STATE_WRITE_ADDR_HOLD                    _MK_ENUM_CONST(12)

#define FUSE_FUSECTRL_0_FUSECTRL_FUSE_SENSE_DONE_SHIFT                  _MK_SHIFT_CONST(30)
#define FUSE_FUSECTRL_0_FUSECTRL_FUSE_SENSE_DONE_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_FUSECTRL_0_FUSECTRL_FUSE_SENSE_DONE_SHIFT)
#define FUSE_FUSECTRL_0_FUSECTRL_FUSE_SENSE_DONE_RANGE                  30:30
#define FUSE_FUSECTRL_0_FUSECTRL_FUSE_SENSE_DONE_WOFFSET                        0x0
#define FUSE_FUSECTRL_0_FUSECTRL_FUSE_SENSE_DONE_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_FUSE_SENSE_DONE_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_FUSE_SENSE_DONE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_FUSE_SENSE_DONE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSECTRL_0_FUSECTRL_RAMREPAIR_SHIFT_DONE_SHIFT                     _MK_SHIFT_CONST(31)
#define FUSE_FUSECTRL_0_FUSECTRL_RAMREPAIR_SHIFT_DONE_FIELD                     (_MK_MASK_CONST(0x1) << FUSE_FUSECTRL_0_FUSECTRL_RAMREPAIR_SHIFT_DONE_SHIFT)
#define FUSE_FUSECTRL_0_FUSECTRL_RAMREPAIR_SHIFT_DONE_RANGE                     31:31
#define FUSE_FUSECTRL_0_FUSECTRL_RAMREPAIR_SHIFT_DONE_WOFFSET                   0x0
#define FUSE_FUSECTRL_0_FUSECTRL_RAMREPAIR_SHIFT_DONE_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_RAMREPAIR_SHIFT_DONE_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_RAMREPAIR_SHIFT_DONE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_RAMREPAIR_SHIFT_DONE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FUSE_FUSEADDR_0  
#define FUSE_FUSEADDR_0                 _MK_ADDR_CONST(0x4)
#define FUSE_FUSEADDR_0_SECURE                  0x0
#define FUSE_FUSEADDR_0_WORD_COUNT                      0x1
#define FUSE_FUSEADDR_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEADDR_0_RESET_MASK                      _MK_MASK_CONST(0xff)
#define FUSE_FUSEADDR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEADDR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_FUSEADDR_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define FUSE_FUSEADDR_0_WRITE_MASK                      _MK_MASK_CONST(0xff)
#define FUSE_FUSEADDR_0_FUSEADDR_VLDFLD_SHIFT                   _MK_SHIFT_CONST(0)
#define FUSE_FUSEADDR_0_FUSEADDR_VLDFLD_FIELD                   (_MK_MASK_CONST(0xff) << FUSE_FUSEADDR_0_FUSEADDR_VLDFLD_SHIFT)
#define FUSE_FUSEADDR_0_FUSEADDR_VLDFLD_RANGE                   7:0
#define FUSE_FUSEADDR_0_FUSEADDR_VLDFLD_WOFFSET                 0x0
#define FUSE_FUSEADDR_0_FUSEADDR_VLDFLD_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEADDR_0_FUSEADDR_VLDFLD_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define FUSE_FUSEADDR_0_FUSEADDR_VLDFLD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEADDR_0_FUSEADDR_VLDFLD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FUSE_FUSERDATA_0  
#define FUSE_FUSERDATA_0                        _MK_ADDR_CONST(0x8)
#define FUSE_FUSERDATA_0_SECURE                         0x0
#define FUSE_FUSERDATA_0_WORD_COUNT                     0x1
#define FUSE_FUSERDATA_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSERDATA_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSERDATA_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_FUSERDATA_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_FUSERDATA_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSERDATA_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSERDATA_0_FUSERDATA_DATA_SHIFT                   _MK_SHIFT_CONST(0)
#define FUSE_FUSERDATA_0_FUSERDATA_DATA_FIELD                   (_MK_MASK_CONST(0xffffffff) << FUSE_FUSERDATA_0_FUSERDATA_DATA_SHIFT)
#define FUSE_FUSERDATA_0_FUSERDATA_DATA_RANGE                   31:0
#define FUSE_FUSERDATA_0_FUSERDATA_DATA_WOFFSET                 0x0
#define FUSE_FUSERDATA_0_FUSERDATA_DATA_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSERDATA_0_FUSERDATA_DATA_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSERDATA_0_FUSERDATA_DATA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSERDATA_0_FUSERDATA_DATA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWDATA_0  
#define FUSE_FUSEWDATA_0                        _MK_ADDR_CONST(0xc)
#define FUSE_FUSEWDATA_0_SECURE                         0x0
#define FUSE_FUSEWDATA_0_WORD_COUNT                     0x1
#define FUSE_FUSEWDATA_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWDATA_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWDATA_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_FUSEWDATA_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWDATA_0_READ_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWDATA_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWDATA_0_FUSEWDATA_DATA_SHIFT                   _MK_SHIFT_CONST(0)
#define FUSE_FUSEWDATA_0_FUSEWDATA_DATA_FIELD                   (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWDATA_0_FUSEWDATA_DATA_SHIFT)
#define FUSE_FUSEWDATA_0_FUSEWDATA_DATA_RANGE                   31:0
#define FUSE_FUSEWDATA_0_FUSEWDATA_DATA_WOFFSET                 0x0
#define FUSE_FUSEWDATA_0_FUSEWDATA_DATA_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWDATA_0_FUSEWDATA_DATA_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWDATA_0_FUSEWDATA_DATA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWDATA_0_FUSEWDATA_DATA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FUSE_FUSETIME_RD1_0  
#define FUSE_FUSETIME_RD1_0                     _MK_ADDR_CONST(0x10)
#define FUSE_FUSETIME_RD1_0_SECURE                      0x0
#define FUSE_FUSETIME_RD1_0_WORD_COUNT                  0x1
#define FUSE_FUSETIME_RD1_0_RESET_VAL                   _MK_MASK_CONST(0x10201)
#define FUSE_FUSETIME_RD1_0_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define FUSE_FUSETIME_RD1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME_RD1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME_RD1_0_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define FUSE_FUSETIME_RD1_0_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_MAX_SHIFT                 _MK_SHIFT_CONST(0)
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_MAX_FIELD                 (_MK_MASK_CONST(0xff) << FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_MAX_SHIFT)
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_MAX_RANGE                 7:0
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_MAX_WOFFSET                       0x0
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_MAX_DEFAULT                       _MK_MASK_CONST(0x1)
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_MAX_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_MAX_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_MAX_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_FUSEOUT_SHIFT                     _MK_SHIFT_CONST(8)
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_FUSEOUT_FIELD                     (_MK_MASK_CONST(0xff) << FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_FUSEOUT_SHIFT)
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_FUSEOUT_RANGE                     15:8
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_FUSEOUT_WOFFSET                   0x0
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_FUSEOUT_DEFAULT                   _MK_MASK_CONST(0x2)
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_FUSEOUT_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_FUSEOUT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_TSUR_FUSEOUT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_THR_MAX_SHIFT                  _MK_SHIFT_CONST(16)
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_THR_MAX_FIELD                  (_MK_MASK_CONST(0xff) << FUSE_FUSETIME_RD1_0_FUSETIME_RD1_THR_MAX_SHIFT)
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_THR_MAX_RANGE                  23:16
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_THR_MAX_WOFFSET                        0x0
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_THR_MAX_DEFAULT                        _MK_MASK_CONST(0x1)
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_THR_MAX_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_THR_MAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME_RD1_0_FUSETIME_RD1_THR_MAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_FUSETIME_RD2_0  
#define FUSE_FUSETIME_RD2_0                     _MK_ADDR_CONST(0x14)
#define FUSE_FUSETIME_RD2_0_SECURE                      0x0
#define FUSE_FUSETIME_RD2_0_WORD_COUNT                  0x1
#define FUSE_FUSETIME_RD2_0_RESET_VAL                   _MK_MASK_CONST(0x3)
#define FUSE_FUSETIME_RD2_0_RESET_MASK                  _MK_MASK_CONST(0xffff)
#define FUSE_FUSETIME_RD2_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME_RD2_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME_RD2_0_READ_MASK                   _MK_MASK_CONST(0xffff)
#define FUSE_FUSETIME_RD2_0_WRITE_MASK                  _MK_MASK_CONST(0xffff)
#define FUSE_FUSETIME_RD2_0_FUSETIME_RD2_TWIDTH_RD_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_FUSETIME_RD2_0_FUSETIME_RD2_TWIDTH_RD_FIELD                        (_MK_MASK_CONST(0xffff) << FUSE_FUSETIME_RD2_0_FUSETIME_RD2_TWIDTH_RD_SHIFT)
#define FUSE_FUSETIME_RD2_0_FUSETIME_RD2_TWIDTH_RD_RANGE                        15:0
#define FUSE_FUSETIME_RD2_0_FUSETIME_RD2_TWIDTH_RD_WOFFSET                      0x0
#define FUSE_FUSETIME_RD2_0_FUSETIME_RD2_TWIDTH_RD_DEFAULT                      _MK_MASK_CONST(0x3)
#define FUSE_FUSETIME_RD2_0_FUSETIME_RD2_TWIDTH_RD_DEFAULT_MASK                 _MK_MASK_CONST(0xffff)
#define FUSE_FUSETIME_RD2_0_FUSETIME_RD2_TWIDTH_RD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME_RD2_0_FUSETIME_RD2_TWIDTH_RD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_FUSETIME_PGM1_0  
#define FUSE_FUSETIME_PGM1_0                    _MK_ADDR_CONST(0x18)
#define FUSE_FUSETIME_PGM1_0_SECURE                     0x0
#define FUSE_FUSETIME_PGM1_0_WORD_COUNT                         0x1
#define FUSE_FUSETIME_PGM1_0_RESET_VAL                  _MK_MASK_CONST(0x101a0)
#define FUSE_FUSETIME_PGM1_0_RESET_MASK                         _MK_MASK_CONST(0xffffff)
#define FUSE_FUSETIME_PGM1_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME_PGM1_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME_PGM1_0_READ_MASK                  _MK_MASK_CONST(0xffffff)
#define FUSE_FUSETIME_PGM1_0_WRITE_MASK                         _MK_MASK_CONST(0xffffff)
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_MAX_SHIFT                       _MK_SHIFT_CONST(0)
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_MAX_FIELD                       (_MK_MASK_CONST(0xff) << FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_MAX_SHIFT)
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_MAX_RANGE                       7:0
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_MAX_WOFFSET                     0x0
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_MAX_DEFAULT                     _MK_MASK_CONST(0xa0)
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_MAX_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_MAX_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_MAX_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_ADDR_SHIFT                      _MK_SHIFT_CONST(8)
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_ADDR_FIELD                      (_MK_MASK_CONST(0xff) << FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_ADDR_SHIFT)
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_ADDR_RANGE                      15:8
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_ADDR_WOFFSET                    0x0
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_ADDR_DEFAULT                    _MK_MASK_CONST(0x1)
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_ADDR_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_ADDR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_TSUP_ADDR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_THP_ADDR_SHIFT                       _MK_SHIFT_CONST(16)
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_THP_ADDR_FIELD                       (_MK_MASK_CONST(0xff) << FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_THP_ADDR_SHIFT)
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_THP_ADDR_RANGE                       23:16
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_THP_ADDR_WOFFSET                     0x0
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_THP_ADDR_DEFAULT                     _MK_MASK_CONST(0x1)
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_THP_ADDR_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_THP_ADDR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME_PGM1_0_FUSETIME_PGM1_THP_ADDR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FUSE_FUSETIME_PGM2_0  
#define FUSE_FUSETIME_PGM2_0                    _MK_ADDR_CONST(0x1c)
#define FUSE_FUSETIME_PGM2_0_SECURE                     0x0
#define FUSE_FUSETIME_PGM2_0_WORD_COUNT                         0x1
#define FUSE_FUSETIME_PGM2_0_RESET_VAL                  _MK_MASK_CONST(0x104)
#define FUSE_FUSETIME_PGM2_0_RESET_MASK                         _MK_MASK_CONST(0xffff)
#define FUSE_FUSETIME_PGM2_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME_PGM2_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME_PGM2_0_READ_MASK                  _MK_MASK_CONST(0xffff)
#define FUSE_FUSETIME_PGM2_0_WRITE_MASK                         _MK_MASK_CONST(0xffff)
#define FUSE_FUSETIME_PGM2_0_FUSETIME_PGM2_TWIDTH_PGM_SHIFT                     _MK_SHIFT_CONST(0)
#define FUSE_FUSETIME_PGM2_0_FUSETIME_PGM2_TWIDTH_PGM_FIELD                     (_MK_MASK_CONST(0xffff) << FUSE_FUSETIME_PGM2_0_FUSETIME_PGM2_TWIDTH_PGM_SHIFT)
#define FUSE_FUSETIME_PGM2_0_FUSETIME_PGM2_TWIDTH_PGM_RANGE                     15:0
#define FUSE_FUSETIME_PGM2_0_FUSETIME_PGM2_TWIDTH_PGM_WOFFSET                   0x0
#define FUSE_FUSETIME_PGM2_0_FUSETIME_PGM2_TWIDTH_PGM_DEFAULT                   _MK_MASK_CONST(0x104)
#define FUSE_FUSETIME_PGM2_0_FUSETIME_PGM2_TWIDTH_PGM_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define FUSE_FUSETIME_PGM2_0_FUSETIME_PGM2_TWIDTH_PGM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME_PGM2_0_FUSETIME_PGM2_TWIDTH_PGM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FUSE_PRIV2INTFC_START_0  
#define FUSE_PRIV2INTFC_START_0                 _MK_ADDR_CONST(0x20)
#define FUSE_PRIV2INTFC_START_0_SECURE                  0x0
#define FUSE_PRIV2INTFC_START_0_WORD_COUNT                      0x1
#define FUSE_PRIV2INTFC_START_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_PRIV2INTFC_START_0_RESET_MASK                      _MK_MASK_CONST(0x3)
#define FUSE_PRIV2INTFC_START_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_PRIV2INTFC_START_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_PRIV2INTFC_START_0_READ_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_PRIV2INTFC_START_0_WRITE_MASK                      _MK_MASK_CONST(0x3)
#define FUSE_PRIV2INTFC_START_0_PRIV2INTFC_START_DATA_SHIFT                     _MK_SHIFT_CONST(0)
#define FUSE_PRIV2INTFC_START_0_PRIV2INTFC_START_DATA_FIELD                     (_MK_MASK_CONST(0x1) << FUSE_PRIV2INTFC_START_0_PRIV2INTFC_START_DATA_SHIFT)
#define FUSE_PRIV2INTFC_START_0_PRIV2INTFC_START_DATA_RANGE                     0:0
#define FUSE_PRIV2INTFC_START_0_PRIV2INTFC_START_DATA_WOFFSET                   0x0
#define FUSE_PRIV2INTFC_START_0_PRIV2INTFC_START_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_PRIV2INTFC_START_0_PRIV2INTFC_START_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FUSE_PRIV2INTFC_START_0_PRIV2INTFC_START_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PRIV2INTFC_START_0_PRIV2INTFC_START_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_PRIV2INTFC_START_0_PRIV2INTFC_SKIP_RAMREPAIR_SHIFT                 _MK_SHIFT_CONST(1)
#define FUSE_PRIV2INTFC_START_0_PRIV2INTFC_SKIP_RAMREPAIR_FIELD                 (_MK_MASK_CONST(0x1) << FUSE_PRIV2INTFC_START_0_PRIV2INTFC_SKIP_RAMREPAIR_SHIFT)
#define FUSE_PRIV2INTFC_START_0_PRIV2INTFC_SKIP_RAMREPAIR_RANGE                 1:1
#define FUSE_PRIV2INTFC_START_0_PRIV2INTFC_SKIP_RAMREPAIR_WOFFSET                       0x0
#define FUSE_PRIV2INTFC_START_0_PRIV2INTFC_SKIP_RAMREPAIR_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_PRIV2INTFC_START_0_PRIV2INTFC_SKIP_RAMREPAIR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_PRIV2INTFC_START_0_PRIV2INTFC_SKIP_RAMREPAIR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_PRIV2INTFC_START_0_PRIV2INTFC_SKIP_RAMREPAIR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register FUSE_FUSEBYPASS_0  
#define FUSE_FUSEBYPASS_0                       _MK_ADDR_CONST(0x24)
#define FUSE_FUSEBYPASS_0_SECURE                        0x0
#define FUSE_FUSEBYPASS_0_WORD_COUNT                    0x1
#define FUSE_FUSEBYPASS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEBYPASS_0_RESET_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FUSEBYPASS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEBYPASS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEBYPASS_0_READ_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_FUSEBYPASS_0_WRITE_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_SHIFT)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_RANGE                  0:0
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_WOFFSET                        0x0
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_INIT_ENUM                      DISABLED
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_DISABLED                       _MK_ENUM_CONST(0)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_ENABLED                        _MK_ENUM_CONST(1)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_DISABLE                        _MK_ENUM_CONST(0)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_ENABLE                 _MK_ENUM_CONST(1)


// Register FUSE_PRIVATEKEYDISABLE_0  
#define FUSE_PRIVATEKEYDISABLE_0                        _MK_ADDR_CONST(0x28)
#define FUSE_PRIVATEKEYDISABLE_0_SECURE                         0x0
#define FUSE_PRIVATEKEYDISABLE_0_WORD_COUNT                     0x1
#define FUSE_PRIVATEKEYDISABLE_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATEKEYDISABLE_0_RESET_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_PRIVATEKEYDISABLE_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_PRIVATEKEYDISABLE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATEKEYDISABLE_0_READ_MASK                      _MK_MASK_CONST(0x1)
#define FUSE_PRIVATEKEYDISABLE_0_WRITE_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_SHIFT)
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_RANGE                    0:0
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_WOFFSET                  0x0
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_INIT_ENUM                        KEY_VISIBLE
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_KEY_VISIBLE                      _MK_ENUM_CONST(0)
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_KEY_INVISIBLE                    _MK_ENUM_CONST(1)


// Register FUSE_DISABLEREGPROGRAM_0  
#define FUSE_DISABLEREGPROGRAM_0                        _MK_ADDR_CONST(0x2c)
#define FUSE_DISABLEREGPROGRAM_0_SECURE                         0x0
#define FUSE_DISABLEREGPROGRAM_0_WORD_COUNT                     0x1
#define FUSE_DISABLEREGPROGRAM_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_DISABLEREGPROGRAM_0_RESET_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_DISABLEREGPROGRAM_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_DISABLEREGPROGRAM_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_DISABLEREGPROGRAM_0_READ_MASK                      _MK_MASK_CONST(0x1)
#define FUSE_DISABLEREGPROGRAM_0_WRITE_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_DISABLEREGPROGRAM_0_DISABLEREGPROGRAM_VAL_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_DISABLEREGPROGRAM_0_DISABLEREGPROGRAM_VAL_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_DISABLEREGPROGRAM_0_DISABLEREGPROGRAM_VAL_SHIFT)
#define FUSE_DISABLEREGPROGRAM_0_DISABLEREGPROGRAM_VAL_RANGE                    0:0
#define FUSE_DISABLEREGPROGRAM_0_DISABLEREGPROGRAM_VAL_WOFFSET                  0x0
#define FUSE_DISABLEREGPROGRAM_0_DISABLEREGPROGRAM_VAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_DISABLEREGPROGRAM_0_DISABLEREGPROGRAM_VAL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_DISABLEREGPROGRAM_0_DISABLEREGPROGRAM_VAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_DISABLEREGPROGRAM_0_DISABLEREGPROGRAM_VAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_DISABLEREGPROGRAM_0_DISABLEREGPROGRAM_VAL_INIT_ENUM                        DISABLED
#define FUSE_DISABLEREGPROGRAM_0_DISABLEREGPROGRAM_VAL_DISABLED                 _MK_ENUM_CONST(0)
#define FUSE_DISABLEREGPROGRAM_0_DISABLEREGPROGRAM_VAL_ENABLED                  _MK_ENUM_CONST(1)
#define FUSE_DISABLEREGPROGRAM_0_DISABLEREGPROGRAM_VAL_DISABLE                  _MK_ENUM_CONST(0)
#define FUSE_DISABLEREGPROGRAM_0_DISABLEREGPROGRAM_VAL_ENABLE                   _MK_ENUM_CONST(1)


// Register FUSE_WRITE_ACCESS_SW_0  
#define FUSE_WRITE_ACCESS_SW_0                  _MK_ADDR_CONST(0x30)
#define FUSE_WRITE_ACCESS_SW_0_SECURE                   0x0
#define FUSE_WRITE_ACCESS_SW_0_WORD_COUNT                       0x1
#define FUSE_WRITE_ACCESS_SW_0_RESET_VAL                        _MK_MASK_CONST(0x1)
#define FUSE_WRITE_ACCESS_SW_0_RESET_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_WRITE_ACCESS_SW_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_WRITE_ACCESS_SW_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_WRITE_ACCESS_SW_0_READ_MASK                        _MK_MASK_CONST(0x10001)
#define FUSE_WRITE_ACCESS_SW_0_WRITE_MASK                       _MK_MASK_CONST(0x10001)
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_CTRL_SHIFT                       _MK_SHIFT_CONST(0)
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_CTRL_FIELD                       (_MK_MASK_CONST(0x1) << FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_CTRL_SHIFT)
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_CTRL_RANGE                       0:0
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_CTRL_WOFFSET                     0x0
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_CTRL_DEFAULT                     _MK_MASK_CONST(0x1)
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_CTRL_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_CTRL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_CTRL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_CTRL_INIT_ENUM                   READONLY
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_CTRL_READWRITE                   _MK_ENUM_CONST(0)
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_CTRL_READONLY                    _MK_ENUM_CONST(1)

#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_STATUS_SHIFT                     _MK_SHIFT_CONST(16)
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_STATUS_FIELD                     (_MK_MASK_CONST(0x1) << FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_STATUS_SHIFT)
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_STATUS_RANGE                     16:16
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_STATUS_WOFFSET                   0x0
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_STATUS_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_STATUS_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_STATUS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_STATUS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_STATUS_NOWRITE                   _MK_ENUM_CONST(0)
#define FUSE_WRITE_ACCESS_SW_0_WRITE_ACCESS_SW_STATUS_WRITE                     _MK_ENUM_CONST(1)


// Register FUSE_PWR_GOOD_SW_0  
#define FUSE_PWR_GOOD_SW_0                      _MK_ADDR_CONST(0x34)
#define FUSE_PWR_GOOD_SW_0_SECURE                       0x0
#define FUSE_PWR_GOOD_SW_0_WORD_COUNT                   0x1
#define FUSE_PWR_GOOD_SW_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_PWR_GOOD_SW_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_PWR_GOOD_SW_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_PWR_GOOD_SW_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_PWR_GOOD_SW_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_PWR_GOOD_SW_0_WRITE_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_PWR_GOOD_SW_0_PWR_GOOD_SW_VAL_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_PWR_GOOD_SW_0_PWR_GOOD_SW_VAL_FIELD                        (_MK_MASK_CONST(0x1) << FUSE_PWR_GOOD_SW_0_PWR_GOOD_SW_VAL_SHIFT)
#define FUSE_PWR_GOOD_SW_0_PWR_GOOD_SW_VAL_RANGE                        0:0
#define FUSE_PWR_GOOD_SW_0_PWR_GOOD_SW_VAL_WOFFSET                      0x0
#define FUSE_PWR_GOOD_SW_0_PWR_GOOD_SW_VAL_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_PWR_GOOD_SW_0_PWR_GOOD_SW_VAL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FUSE_PWR_GOOD_SW_0_PWR_GOOD_SW_VAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_PWR_GOOD_SW_0_PWR_GOOD_SW_VAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_PWR_GOOD_SW_0_PWR_GOOD_SW_VAL_INIT_ENUM                    PWR_GOOD_NOT_OK
#define FUSE_PWR_GOOD_SW_0_PWR_GOOD_SW_VAL_PWR_GOOD_NOT_OK                      _MK_ENUM_CONST(0)
#define FUSE_PWR_GOOD_SW_0_PWR_GOOD_SW_VAL_PWR_GOOD_OK                  _MK_ENUM_CONST(1)


// Reserved address 56 [0x38] 

// Reserved address 60 [0x3c] 

// Reserved address 64 [0x40] 

// Reserved address 68 [0x44] 

// Register FUSE_REG_REF_CTRL_0  
#define FUSE_REG_REF_CTRL_0                     _MK_ADDR_CONST(0x48)
#define FUSE_REG_REF_CTRL_0_SECURE                      0x0
#define FUSE_REG_REF_CTRL_0_WORD_COUNT                  0x1
#define FUSE_REG_REF_CTRL_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_REG_REF_CTRL_0_RESET_MASK                  _MK_MASK_CONST(0x3)
#define FUSE_REG_REF_CTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_REG_REF_CTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_REG_REF_CTRL_0_READ_MASK                   _MK_MASK_CONST(0x3)
#define FUSE_REG_REF_CTRL_0_WRITE_MASK                  _MK_MASK_CONST(0x3)
#define FUSE_REG_REF_CTRL_0_REG_REF_CTRL_DATA_SHIFT                     _MK_SHIFT_CONST(0)
#define FUSE_REG_REF_CTRL_0_REG_REF_CTRL_DATA_FIELD                     (_MK_MASK_CONST(0x3) << FUSE_REG_REF_CTRL_0_REG_REF_CTRL_DATA_SHIFT)
#define FUSE_REG_REF_CTRL_0_REG_REF_CTRL_DATA_RANGE                     1:0
#define FUSE_REG_REF_CTRL_0_REG_REF_CTRL_DATA_WOFFSET                   0x0
#define FUSE_REG_REF_CTRL_0_REG_REF_CTRL_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_REG_REF_CTRL_0_REG_REF_CTRL_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define FUSE_REG_REF_CTRL_0_REG_REF_CTRL_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_REG_REF_CTRL_0_REG_REF_CTRL_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FUSE_REG_BIAS_CTRL_0  
#define FUSE_REG_BIAS_CTRL_0                    _MK_ADDR_CONST(0x4c)
#define FUSE_REG_BIAS_CTRL_0_SECURE                     0x0
#define FUSE_REG_BIAS_CTRL_0_WORD_COUNT                         0x1
#define FUSE_REG_BIAS_CTRL_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_REG_BIAS_CTRL_0_RESET_MASK                         _MK_MASK_CONST(0x3)
#define FUSE_REG_BIAS_CTRL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_REG_BIAS_CTRL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_REG_BIAS_CTRL_0_READ_MASK                  _MK_MASK_CONST(0x3)
#define FUSE_REG_BIAS_CTRL_0_WRITE_MASK                         _MK_MASK_CONST(0x3)
#define FUSE_REG_BIAS_CTRL_0_REG_BIAS_CTRL_DATA_SHIFT                   _MK_SHIFT_CONST(0)
#define FUSE_REG_BIAS_CTRL_0_REG_BIAS_CTRL_DATA_FIELD                   (_MK_MASK_CONST(0x3) << FUSE_REG_BIAS_CTRL_0_REG_BIAS_CTRL_DATA_SHIFT)
#define FUSE_REG_BIAS_CTRL_0_REG_BIAS_CTRL_DATA_RANGE                   1:0
#define FUSE_REG_BIAS_CTRL_0_REG_BIAS_CTRL_DATA_WOFFSET                 0x0
#define FUSE_REG_BIAS_CTRL_0_REG_BIAS_CTRL_DATA_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_REG_BIAS_CTRL_0_REG_BIAS_CTRL_DATA_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define FUSE_REG_BIAS_CTRL_0_REG_BIAS_CTRL_DATA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_REG_BIAS_CTRL_0_REG_BIAS_CTRL_DATA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FUSE_PRIVATE_KEY0_NONZERO_0  
#define FUSE_PRIVATE_KEY0_NONZERO_0                     _MK_ADDR_CONST(0x50)
#define FUSE_PRIVATE_KEY0_NONZERO_0_SECURE                      0x0
#define FUSE_PRIVATE_KEY0_NONZERO_0_WORD_COUNT                  0x1
#define FUSE_PRIVATE_KEY0_NONZERO_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_NONZERO_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_NONZERO_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_NONZERO_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_NONZERO_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_PRIVATE_KEY0_NONZERO_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_NONZERO_0_PRIVATE_KEY0_NONZERO_DATA_SHIFT                     _MK_SHIFT_CONST(0)
#define FUSE_PRIVATE_KEY0_NONZERO_0_PRIVATE_KEY0_NONZERO_DATA_FIELD                     (_MK_MASK_CONST(0x1) << FUSE_PRIVATE_KEY0_NONZERO_0_PRIVATE_KEY0_NONZERO_DATA_SHIFT)
#define FUSE_PRIVATE_KEY0_NONZERO_0_PRIVATE_KEY0_NONZERO_DATA_RANGE                     0:0
#define FUSE_PRIVATE_KEY0_NONZERO_0_PRIVATE_KEY0_NONZERO_DATA_WOFFSET                   0x0
#define FUSE_PRIVATE_KEY0_NONZERO_0_PRIVATE_KEY0_NONZERO_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_NONZERO_0_PRIVATE_KEY0_NONZERO_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_NONZERO_0_PRIVATE_KEY0_NONZERO_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_NONZERO_0_PRIVATE_KEY0_NONZERO_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FUSE_PRIVATE_KEY1_NONZERO_0  
#define FUSE_PRIVATE_KEY1_NONZERO_0                     _MK_ADDR_CONST(0x54)
#define FUSE_PRIVATE_KEY1_NONZERO_0_SECURE                      0x0
#define FUSE_PRIVATE_KEY1_NONZERO_0_WORD_COUNT                  0x1
#define FUSE_PRIVATE_KEY1_NONZERO_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_NONZERO_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_NONZERO_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_NONZERO_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_NONZERO_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_PRIVATE_KEY1_NONZERO_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_NONZERO_0_PRIVATE_KEY1_NONZERO_DATA_SHIFT                     _MK_SHIFT_CONST(0)
#define FUSE_PRIVATE_KEY1_NONZERO_0_PRIVATE_KEY1_NONZERO_DATA_FIELD                     (_MK_MASK_CONST(0x1) << FUSE_PRIVATE_KEY1_NONZERO_0_PRIVATE_KEY1_NONZERO_DATA_SHIFT)
#define FUSE_PRIVATE_KEY1_NONZERO_0_PRIVATE_KEY1_NONZERO_DATA_RANGE                     0:0
#define FUSE_PRIVATE_KEY1_NONZERO_0_PRIVATE_KEY1_NONZERO_DATA_WOFFSET                   0x0
#define FUSE_PRIVATE_KEY1_NONZERO_0_PRIVATE_KEY1_NONZERO_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_NONZERO_0_PRIVATE_KEY1_NONZERO_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_NONZERO_0_PRIVATE_KEY1_NONZERO_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_NONZERO_0_PRIVATE_KEY1_NONZERO_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FUSE_PRIVATE_KEY2_NONZERO_0  
#define FUSE_PRIVATE_KEY2_NONZERO_0                     _MK_ADDR_CONST(0x58)
#define FUSE_PRIVATE_KEY2_NONZERO_0_SECURE                      0x0
#define FUSE_PRIVATE_KEY2_NONZERO_0_WORD_COUNT                  0x1
#define FUSE_PRIVATE_KEY2_NONZERO_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_NONZERO_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_NONZERO_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_NONZERO_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_NONZERO_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_PRIVATE_KEY2_NONZERO_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_NONZERO_0_PRIVATE_KEY2_NONZERO_DATA_SHIFT                     _MK_SHIFT_CONST(0)
#define FUSE_PRIVATE_KEY2_NONZERO_0_PRIVATE_KEY2_NONZERO_DATA_FIELD                     (_MK_MASK_CONST(0x1) << FUSE_PRIVATE_KEY2_NONZERO_0_PRIVATE_KEY2_NONZERO_DATA_SHIFT)
#define FUSE_PRIVATE_KEY2_NONZERO_0_PRIVATE_KEY2_NONZERO_DATA_RANGE                     0:0
#define FUSE_PRIVATE_KEY2_NONZERO_0_PRIVATE_KEY2_NONZERO_DATA_WOFFSET                   0x0
#define FUSE_PRIVATE_KEY2_NONZERO_0_PRIVATE_KEY2_NONZERO_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_NONZERO_0_PRIVATE_KEY2_NONZERO_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_NONZERO_0_PRIVATE_KEY2_NONZERO_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_NONZERO_0_PRIVATE_KEY2_NONZERO_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FUSE_PRIVATE_KEY3_NONZERO_0  
#define FUSE_PRIVATE_KEY3_NONZERO_0                     _MK_ADDR_CONST(0x5c)
#define FUSE_PRIVATE_KEY3_NONZERO_0_SECURE                      0x0
#define FUSE_PRIVATE_KEY3_NONZERO_0_WORD_COUNT                  0x1
#define FUSE_PRIVATE_KEY3_NONZERO_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_NONZERO_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_NONZERO_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_NONZERO_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_NONZERO_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_PRIVATE_KEY3_NONZERO_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_NONZERO_0_PRIVATE_KEY3_NONZERO_DATA_SHIFT                     _MK_SHIFT_CONST(0)
#define FUSE_PRIVATE_KEY3_NONZERO_0_PRIVATE_KEY3_NONZERO_DATA_FIELD                     (_MK_MASK_CONST(0x1) << FUSE_PRIVATE_KEY3_NONZERO_0_PRIVATE_KEY3_NONZERO_DATA_SHIFT)
#define FUSE_PRIVATE_KEY3_NONZERO_0_PRIVATE_KEY3_NONZERO_DATA_RANGE                     0:0
#define FUSE_PRIVATE_KEY3_NONZERO_0_PRIVATE_KEY3_NONZERO_DATA_WOFFSET                   0x0
#define FUSE_PRIVATE_KEY3_NONZERO_0_PRIVATE_KEY3_NONZERO_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_NONZERO_0_PRIVATE_KEY3_NONZERO_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_NONZERO_0_PRIVATE_KEY3_NONZERO_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_NONZERO_0_PRIVATE_KEY3_NONZERO_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FUSE_PRIVATE_KEY4_NONZERO_0  
#define FUSE_PRIVATE_KEY4_NONZERO_0                     _MK_ADDR_CONST(0x60)
#define FUSE_PRIVATE_KEY4_NONZERO_0_SECURE                      0x0
#define FUSE_PRIVATE_KEY4_NONZERO_0_WORD_COUNT                  0x1
#define FUSE_PRIVATE_KEY4_NONZERO_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_NONZERO_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_NONZERO_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_NONZERO_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_NONZERO_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_PRIVATE_KEY4_NONZERO_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_NONZERO_0_PRIVATE_KEY4_NONZERO_DATA_SHIFT                     _MK_SHIFT_CONST(0)
#define FUSE_PRIVATE_KEY4_NONZERO_0_PRIVATE_KEY4_NONZERO_DATA_FIELD                     (_MK_MASK_CONST(0x1) << FUSE_PRIVATE_KEY4_NONZERO_0_PRIVATE_KEY4_NONZERO_DATA_SHIFT)
#define FUSE_PRIVATE_KEY4_NONZERO_0_PRIVATE_KEY4_NONZERO_DATA_RANGE                     0:0
#define FUSE_PRIVATE_KEY4_NONZERO_0_PRIVATE_KEY4_NONZERO_DATA_WOFFSET                   0x0
#define FUSE_PRIVATE_KEY4_NONZERO_0_PRIVATE_KEY4_NONZERO_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_NONZERO_0_PRIVATE_KEY4_NONZERO_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_NONZERO_0_PRIVATE_KEY4_NONZERO_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_NONZERO_0_PRIVATE_KEY4_NONZERO_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Reserved address 100 [0x64] 

// Reserved address 104 [0x68] 

// Reserved address 108 [0x6c] 

// Reserved address 112 [0x70] 

// Reserved address 116 [0x74] 

// Reserved address 120 [0x78] 

// Reserved address 124 [0x7c] 

// Reserved address 128 [0x80] 

// Reserved address 132 [0x84] 

// Reserved address 136 [0x88] 

// Reserved address 140 [0x8c] 

// Reserved address 144 [0x90] 

// Reserved address 148 [0x94] 

// Reserved address 152 [0x98] 

// Reserved address 156 [0x9c] 

// Reserved address 160 [0xa0] 

// Reserved address 164 [0xa4] 

// Reserved address 168 [0xa8] 

// Reserved address 172 [0xac] 

// Reserved address 176 [0xb0] 

// Reserved address 180 [0xb4] 

// Reserved address 184 [0xb8] 

// Reserved address 188 [0xbc] 

// Reserved address 192 [0xc0] 

// Reserved address 196 [0xc4] 

// Reserved address 200 [0xc8] 

// Reserved address 204 [0xcc] 

// Reserved address 208 [0xd0] 

// Reserved address 212 [0xd4] 

// Reserved address 216 [0xd8] 

// Reserved address 220 [0xdc] 

// Reserved address 224 [0xe0] 

// Reserved address 228 [0xe4] 

// Reserved address 232 [0xe8] 

// Reserved address 236 [0xec] 

// Reserved address 240 [0xf0] 

// Reserved address 244 [0xf4] 

// Reserved address 248 [0xf8] 

// Reserved address 252 [0xfc] 

// Register FUSE_PRODUCTION_MODE_0  
#define FUSE_PRODUCTION_MODE_0                  _MK_ADDR_CONST(0x100)
#define FUSE_PRODUCTION_MODE_0_SECURE                   0x0
#define FUSE_PRODUCTION_MODE_0_WORD_COUNT                       0x1
#define FUSE_PRODUCTION_MODE_0_RESET_VAL                        _MK_MASK_CONST(0x1)
#define FUSE_PRODUCTION_MODE_0_RESET_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_PRODUCTION_MODE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRODUCTION_MODE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRODUCTION_MODE_0_READ_MASK                        _MK_MASK_CONST(0x1)
#define FUSE_PRODUCTION_MODE_0_WRITE_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_SHIFT)
#define FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_RANGE                    0:0
#define FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_WOFFSET                  0x0
#define FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_DEFAULT                  _MK_MASK_CONST(0x1)
#define FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_JTAG_SECUREID_VALID_0  
#define FUSE_JTAG_SECUREID_VALID_0                      _MK_ADDR_CONST(0x104)
#define FUSE_JTAG_SECUREID_VALID_0_SECURE                       0x0
#define FUSE_JTAG_SECUREID_VALID_0_WORD_COUNT                   0x1
#define FUSE_JTAG_SECUREID_VALID_0_RESET_VAL                    _MK_MASK_CONST(0x1)
#define FUSE_JTAG_SECUREID_VALID_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_JTAG_SECUREID_VALID_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_VALID_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_VALID_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_JTAG_SECUREID_VALID_0_WRITE_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_SHIFT)
#define FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_RANGE                    0:0
#define FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_WOFFSET                  0x0
#define FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_DEFAULT                  _MK_MASK_CONST(0x1)
#define FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_JTAG_SECUREID_0_0  
#define FUSE_JTAG_SECUREID_0_0                  _MK_ADDR_CONST(0x108)
#define FUSE_JTAG_SECUREID_0_0_SECURE                   0x0
#define FUSE_JTAG_SECUREID_0_0_WORD_COUNT                       0x1
#define FUSE_JTAG_SECUREID_0_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_0_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_JTAG_SECUREID_0_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_0_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_0_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define FUSE_JTAG_SECUREID_0_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_FIELD                    (_MK_MASK_CONST(0xffffffff) << FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_SHIFT)
#define FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_RANGE                    31:0
#define FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_WOFFSET                  0x0
#define FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_JTAG_SECUREID_1_0  
#define FUSE_JTAG_SECUREID_1_0                  _MK_ADDR_CONST(0x10c)
#define FUSE_JTAG_SECUREID_1_0_SECURE                   0x0
#define FUSE_JTAG_SECUREID_1_0_WORD_COUNT                       0x1
#define FUSE_JTAG_SECUREID_1_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_1_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_JTAG_SECUREID_1_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_1_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_1_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define FUSE_JTAG_SECUREID_1_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_FIELD                    (_MK_MASK_CONST(0xffffffff) << FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_SHIFT)
#define FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_RANGE                    31:0
#define FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_WOFFSET                  0x0
#define FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SKU_INFO_0  
#define FUSE_SKU_INFO_0                 _MK_ADDR_CONST(0x110)
#define FUSE_SKU_INFO_0_SECURE                  0x0
#define FUSE_SKU_INFO_0_WORD_COUNT                      0x1
#define FUSE_SKU_INFO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SKU_INFO_0_RESET_MASK                      _MK_MASK_CONST(0xff)
#define FUSE_SKU_INFO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_SKU_INFO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_SKU_INFO_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define FUSE_SKU_INFO_0_WRITE_MASK                      _MK_MASK_CONST(0xff)
#define FUSE_SKU_INFO_0_SKU_INFO_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SKU_INFO_0_SKU_INFO_FIELD                  (_MK_MASK_CONST(0xff) << FUSE_SKU_INFO_0_SKU_INFO_SHIFT)
#define FUSE_SKU_INFO_0_SKU_INFO_RANGE                  7:0
#define FUSE_SKU_INFO_0_SKU_INFO_WOFFSET                        0x0
#define FUSE_SKU_INFO_0_SKU_INFO_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SKU_INFO_0_SKU_INFO_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define FUSE_SKU_INFO_0_SKU_INFO_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SKU_INFO_0_SKU_INFO_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_PROCESS_CALIB_0  
#define FUSE_PROCESS_CALIB_0                    _MK_ADDR_CONST(0x114)
#define FUSE_PROCESS_CALIB_0_SECURE                     0x0
#define FUSE_PROCESS_CALIB_0_WORD_COUNT                         0x1
#define FUSE_PROCESS_CALIB_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_PROCESS_CALIB_0_RESET_MASK                         _MK_MASK_CONST(0x3)
#define FUSE_PROCESS_CALIB_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_PROCESS_CALIB_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_PROCESS_CALIB_0_READ_MASK                  _MK_MASK_CONST(0x3)
#define FUSE_PROCESS_CALIB_0_WRITE_MASK                         _MK_MASK_CONST(0x3)
#define FUSE_PROCESS_CALIB_0_PROCESS_CALIB_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_PROCESS_CALIB_0_PROCESS_CALIB_FIELD                        (_MK_MASK_CONST(0x3) << FUSE_PROCESS_CALIB_0_PROCESS_CALIB_SHIFT)
#define FUSE_PROCESS_CALIB_0_PROCESS_CALIB_RANGE                        1:0
#define FUSE_PROCESS_CALIB_0_PROCESS_CALIB_WOFFSET                      0x0
#define FUSE_PROCESS_CALIB_0_PROCESS_CALIB_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_PROCESS_CALIB_0_PROCESS_CALIB_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define FUSE_PROCESS_CALIB_0_PROCESS_CALIB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_PROCESS_CALIB_0_PROCESS_CALIB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_IO_CALIB_0  
#define FUSE_IO_CALIB_0                 _MK_ADDR_CONST(0x118)
#define FUSE_IO_CALIB_0_SECURE                  0x0
#define FUSE_IO_CALIB_0_WORD_COUNT                      0x1
#define FUSE_IO_CALIB_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_IO_CALIB_0_RESET_MASK                      _MK_MASK_CONST(0x3ff)
#define FUSE_IO_CALIB_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_IO_CALIB_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_IO_CALIB_0_READ_MASK                       _MK_MASK_CONST(0x3ff)
#define FUSE_IO_CALIB_0_WRITE_MASK                      _MK_MASK_CONST(0x3ff)
#define FUSE_IO_CALIB_0_IO_CALIB_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_IO_CALIB_0_IO_CALIB_FIELD                  (_MK_MASK_CONST(0x3ff) << FUSE_IO_CALIB_0_IO_CALIB_SHIFT)
#define FUSE_IO_CALIB_0_IO_CALIB_RANGE                  9:0
#define FUSE_IO_CALIB_0_IO_CALIB_WOFFSET                        0x0
#define FUSE_IO_CALIB_0_IO_CALIB_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_IO_CALIB_0_IO_CALIB_DEFAULT_MASK                   _MK_MASK_CONST(0x3ff)
#define FUSE_IO_CALIB_0_IO_CALIB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_IO_CALIB_0_IO_CALIB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_DAC_CRT_CALIB_0  
#define FUSE_DAC_CRT_CALIB_0                    _MK_ADDR_CONST(0x11c)
#define FUSE_DAC_CRT_CALIB_0_SECURE                     0x0
#define FUSE_DAC_CRT_CALIB_0_WORD_COUNT                         0x1
#define FUSE_DAC_CRT_CALIB_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_DAC_CRT_CALIB_0_RESET_MASK                         _MK_MASK_CONST(0xff)
#define FUSE_DAC_CRT_CALIB_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_DAC_CRT_CALIB_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_DAC_CRT_CALIB_0_READ_MASK                  _MK_MASK_CONST(0xff)
#define FUSE_DAC_CRT_CALIB_0_WRITE_MASK                         _MK_MASK_CONST(0xff)
#define FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_FIELD                        (_MK_MASK_CONST(0xff) << FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_SHIFT)
#define FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_RANGE                        7:0
#define FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_WOFFSET                      0x0
#define FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_DAC_HDTV_CALIB_0  
#define FUSE_DAC_HDTV_CALIB_0                   _MK_ADDR_CONST(0x120)
#define FUSE_DAC_HDTV_CALIB_0_SECURE                    0x0
#define FUSE_DAC_HDTV_CALIB_0_WORD_COUNT                        0x1
#define FUSE_DAC_HDTV_CALIB_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_DAC_HDTV_CALIB_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define FUSE_DAC_HDTV_CALIB_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_DAC_HDTV_CALIB_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_DAC_HDTV_CALIB_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define FUSE_DAC_HDTV_CALIB_0_WRITE_MASK                        _MK_MASK_CONST(0xff)
#define FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_FIELD                      (_MK_MASK_CONST(0xff) << FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_SHIFT)
#define FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_RANGE                      7:0
#define FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_WOFFSET                    0x0
#define FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_DAC_SDTV_CALIB_0  
#define FUSE_DAC_SDTV_CALIB_0                   _MK_ADDR_CONST(0x124)
#define FUSE_DAC_SDTV_CALIB_0_SECURE                    0x0
#define FUSE_DAC_SDTV_CALIB_0_WORD_COUNT                        0x1
#define FUSE_DAC_SDTV_CALIB_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_DAC_SDTV_CALIB_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define FUSE_DAC_SDTV_CALIB_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_DAC_SDTV_CALIB_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_DAC_SDTV_CALIB_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define FUSE_DAC_SDTV_CALIB_0_WRITE_MASK                        _MK_MASK_CONST(0xff)
#define FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_FIELD                      (_MK_MASK_CONST(0xff) << FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_SHIFT)
#define FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_RANGE                      7:0
#define FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_WOFFSET                    0x0
#define FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Reserved address 296 [0x128] 

// Reserved address 300 [0x12c] 

// Reserved address 304 [0x130] 

// Reserved address 308 [0x134] 

// Reserved address 312 [0x138] 

// Reserved address 316 [0x13c] 

// Reserved address 320 [0x140] 

// Reserved address 324 [0x144] 

// Register FUSE_FA_0  
#define FUSE_FA_0                       _MK_ADDR_CONST(0x148)
#define FUSE_FA_0_SECURE                        0x0
#define FUSE_FA_0_WORD_COUNT                    0x1
#define FUSE_FA_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FA_0_RESET_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FA_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_FA_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_FA_0_READ_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_FA_0_WRITE_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FA_0_FA_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FA_0_FA_FIELD                      (_MK_MASK_CONST(0x1) << FUSE_FA_0_FA_SHIFT)
#define FUSE_FA_0_FA_RANGE                      0:0
#define FUSE_FA_0_FA_WOFFSET                    0x0
#define FUSE_FA_0_FA_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FA_0_FA_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_FA_0_FA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FA_0_FA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_RESERVED_PRODUCTION_0  
#define FUSE_RESERVED_PRODUCTION_0                      _MK_ADDR_CONST(0x14c)
#define FUSE_RESERVED_PRODUCTION_0_SECURE                       0x0
#define FUSE_RESERVED_PRODUCTION_0_WORD_COUNT                   0x1
#define FUSE_RESERVED_PRODUCTION_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_PRODUCTION_0_RESET_MASK                   _MK_MASK_CONST(0xf)
#define FUSE_RESERVED_PRODUCTION_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_PRODUCTION_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_PRODUCTION_0_READ_MASK                    _MK_MASK_CONST(0xf)
#define FUSE_RESERVED_PRODUCTION_0_WRITE_MASK                   _MK_MASK_CONST(0xf)
#define FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_FIELD                    (_MK_MASK_CONST(0xf) << FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_SHIFT)
#define FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_RANGE                    3:0
#define FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_WOFFSET                  0x0
#define FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_HDMI_LANE0_CALIB_0  
#define FUSE_HDMI_LANE0_CALIB_0                 _MK_ADDR_CONST(0x150)
#define FUSE_HDMI_LANE0_CALIB_0_SECURE                  0x0
#define FUSE_HDMI_LANE0_CALIB_0_WORD_COUNT                      0x1
#define FUSE_HDMI_LANE0_CALIB_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE0_CALIB_0_RESET_MASK                      _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE0_CALIB_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE0_CALIB_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE0_CALIB_0_READ_MASK                       _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE0_CALIB_0_WRITE_MASK                      _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_FIELD                  (_MK_MASK_CONST(0x3f) << FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_SHIFT)
#define FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_RANGE                  5:0
#define FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_WOFFSET                        0x0
#define FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_HDMI_LANE1_CALIB_0  
#define FUSE_HDMI_LANE1_CALIB_0                 _MK_ADDR_CONST(0x154)
#define FUSE_HDMI_LANE1_CALIB_0_SECURE                  0x0
#define FUSE_HDMI_LANE1_CALIB_0_WORD_COUNT                      0x1
#define FUSE_HDMI_LANE1_CALIB_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE1_CALIB_0_RESET_MASK                      _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE1_CALIB_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE1_CALIB_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE1_CALIB_0_READ_MASK                       _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE1_CALIB_0_WRITE_MASK                      _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_FIELD                  (_MK_MASK_CONST(0x3f) << FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_SHIFT)
#define FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_RANGE                  5:0
#define FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_WOFFSET                        0x0
#define FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_HDMI_LANE2_CALIB_0  
#define FUSE_HDMI_LANE2_CALIB_0                 _MK_ADDR_CONST(0x158)
#define FUSE_HDMI_LANE2_CALIB_0_SECURE                  0x0
#define FUSE_HDMI_LANE2_CALIB_0_WORD_COUNT                      0x1
#define FUSE_HDMI_LANE2_CALIB_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE2_CALIB_0_RESET_MASK                      _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE2_CALIB_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE2_CALIB_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE2_CALIB_0_READ_MASK                       _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE2_CALIB_0_WRITE_MASK                      _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_FIELD                  (_MK_MASK_CONST(0x3f) << FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_SHIFT)
#define FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_RANGE                  5:0
#define FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_WOFFSET                        0x0
#define FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_HDMI_LANE3_CALIB_0  
#define FUSE_HDMI_LANE3_CALIB_0                 _MK_ADDR_CONST(0x15c)
#define FUSE_HDMI_LANE3_CALIB_0_SECURE                  0x0
#define FUSE_HDMI_LANE3_CALIB_0_WORD_COUNT                      0x1
#define FUSE_HDMI_LANE3_CALIB_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE3_CALIB_0_RESET_MASK                      _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE3_CALIB_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE3_CALIB_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE3_CALIB_0_READ_MASK                       _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE3_CALIB_0_WRITE_MASK                      _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_FIELD                  (_MK_MASK_CONST(0x3f) << FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_SHIFT)
#define FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_RANGE                  5:0
#define FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_WOFFSET                        0x0
#define FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 352 [0x160] 

// Reserved address 356 [0x164] 

// Reserved address 360 [0x168] 

// Reserved address 364 [0x16c] 

// Reserved address 368 [0x170] 

// Reserved address 372 [0x174] 

// Reserved address 376 [0x178] 

// Reserved address 380 [0x17c] 

// Reserved address 384 [0x180] 

// Reserved address 388 [0x184] 

// Reserved address 392 [0x188] 

// Reserved address 396 [0x18c] 

// Reserved address 400 [0x190] 

// Reserved address 404 [0x194] 

// Reserved address 408 [0x198] 

// Reserved address 412 [0x19c] 

// Register FUSE_SECURITY_MODE_0  
#define FUSE_SECURITY_MODE_0                    _MK_ADDR_CONST(0x1a0)
#define FUSE_SECURITY_MODE_0_SECURE                     0x0
#define FUSE_SECURITY_MODE_0_WORD_COUNT                         0x1
#define FUSE_SECURITY_MODE_0_RESET_VAL                  _MK_MASK_CONST(0x1)
#define FUSE_SECURITY_MODE_0_RESET_MASK                         _MK_MASK_CONST(0x1)
#define FUSE_SECURITY_MODE_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_SECURITY_MODE_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_SECURITY_MODE_0_READ_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SECURITY_MODE_0_WRITE_MASK                         _MK_MASK_CONST(0x1)
#define FUSE_SECURITY_MODE_0_SECURITY_MODE_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_SECURITY_MODE_0_SECURITY_MODE_FIELD                        (_MK_MASK_CONST(0x1) << FUSE_SECURITY_MODE_0_SECURITY_MODE_SHIFT)
#define FUSE_SECURITY_MODE_0_SECURITY_MODE_RANGE                        0:0
#define FUSE_SECURITY_MODE_0_SECURITY_MODE_WOFFSET                      0x0
#define FUSE_SECURITY_MODE_0_SECURITY_MODE_DEFAULT                      _MK_MASK_CONST(0x1)
#define FUSE_SECURITY_MODE_0_SECURITY_MODE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FUSE_SECURITY_MODE_0_SECURITY_MODE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_SECURITY_MODE_0_SECURITY_MODE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_PRIVATE_KEY0_0  
#define FUSE_PRIVATE_KEY0_0                     _MK_ADDR_CONST(0x1a4)
#define FUSE_PRIVATE_KEY0_0_SECURE                      0x0
#define FUSE_PRIVATE_KEY0_0_WORD_COUNT                  0x1
#define FUSE_PRIVATE_KEY0_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY0_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY0_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_SHIFT)
#define FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_RANGE                  31:0
#define FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_WOFFSET                        0x0
#define FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_PRIVATE_KEY1_0  
#define FUSE_PRIVATE_KEY1_0                     _MK_ADDR_CONST(0x1a8)
#define FUSE_PRIVATE_KEY1_0_SECURE                      0x0
#define FUSE_PRIVATE_KEY1_0_WORD_COUNT                  0x1
#define FUSE_PRIVATE_KEY1_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY1_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_SHIFT)
#define FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_RANGE                  31:0
#define FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_WOFFSET                        0x0
#define FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_PRIVATE_KEY2_0  
#define FUSE_PRIVATE_KEY2_0                     _MK_ADDR_CONST(0x1ac)
#define FUSE_PRIVATE_KEY2_0_SECURE                      0x0
#define FUSE_PRIVATE_KEY2_0_WORD_COUNT                  0x1
#define FUSE_PRIVATE_KEY2_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY2_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY2_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_SHIFT)
#define FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_RANGE                  31:0
#define FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_WOFFSET                        0x0
#define FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_PRIVATE_KEY3_0  
#define FUSE_PRIVATE_KEY3_0                     _MK_ADDR_CONST(0x1b0)
#define FUSE_PRIVATE_KEY3_0_SECURE                      0x0
#define FUSE_PRIVATE_KEY3_0_WORD_COUNT                  0x1
#define FUSE_PRIVATE_KEY3_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY3_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY3_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_SHIFT)
#define FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_RANGE                  31:0
#define FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_WOFFSET                        0x0
#define FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_PRIVATE_KEY4_0  
#define FUSE_PRIVATE_KEY4_0                     _MK_ADDR_CONST(0x1b4)
#define FUSE_PRIVATE_KEY4_0_SECURE                      0x0
#define FUSE_PRIVATE_KEY4_0_WORD_COUNT                  0x1
#define FUSE_PRIVATE_KEY4_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY4_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY4_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_SHIFT)
#define FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_RANGE                  31:0
#define FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_WOFFSET                        0x0
#define FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_ARM_DEBUG_DIS_0  
#define FUSE_ARM_DEBUG_DIS_0                    _MK_ADDR_CONST(0x1b8)
#define FUSE_ARM_DEBUG_DIS_0_SECURE                     0x0
#define FUSE_ARM_DEBUG_DIS_0_WORD_COUNT                         0x1
#define FUSE_ARM_DEBUG_DIS_0_RESET_VAL                  _MK_MASK_CONST(0x1)
#define FUSE_ARM_DEBUG_DIS_0_RESET_MASK                         _MK_MASK_CONST(0x1)
#define FUSE_ARM_DEBUG_DIS_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_ARM_DEBUG_DIS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_ARM_DEBUG_DIS_0_READ_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_ARM_DEBUG_DIS_0_WRITE_MASK                         _MK_MASK_CONST(0x1)
#define FUSE_ARM_DEBUG_DIS_0_ARM_DEBUG_DIS_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_ARM_DEBUG_DIS_0_ARM_DEBUG_DIS_FIELD                        (_MK_MASK_CONST(0x1) << FUSE_ARM_DEBUG_DIS_0_ARM_DEBUG_DIS_SHIFT)
#define FUSE_ARM_DEBUG_DIS_0_ARM_DEBUG_DIS_RANGE                        0:0
#define FUSE_ARM_DEBUG_DIS_0_ARM_DEBUG_DIS_WOFFSET                      0x0
#define FUSE_ARM_DEBUG_DIS_0_ARM_DEBUG_DIS_DEFAULT                      _MK_MASK_CONST(0x1)
#define FUSE_ARM_DEBUG_DIS_0_ARM_DEBUG_DIS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FUSE_ARM_DEBUG_DIS_0_ARM_DEBUG_DIS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_ARM_DEBUG_DIS_0_ARM_DEBUG_DIS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_BOOT_DEVICE_INFO_0  
#define FUSE_BOOT_DEVICE_INFO_0                 _MK_ADDR_CONST(0x1bc)
#define FUSE_BOOT_DEVICE_INFO_0_SECURE                  0x0
#define FUSE_BOOT_DEVICE_INFO_0_WORD_COUNT                      0x1
#define FUSE_BOOT_DEVICE_INFO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_BOOT_DEVICE_INFO_0_RESET_MASK                      _MK_MASK_CONST(0xffff)
#define FUSE_BOOT_DEVICE_INFO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_BOOT_DEVICE_INFO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_BOOT_DEVICE_INFO_0_READ_MASK                       _MK_MASK_CONST(0xffff)
#define FUSE_BOOT_DEVICE_INFO_0_WRITE_MASK                      _MK_MASK_CONST(0xffff)
#define FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_FIELD                  (_MK_MASK_CONST(0xffff) << FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_SHIFT)
#define FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_RANGE                  15:0
#define FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_WOFFSET                        0x0
#define FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_DEFAULT_MASK                   _MK_MASK_CONST(0xffff)
#define FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_RESERVED_SW_0  
#define FUSE_RESERVED_SW_0                      _MK_ADDR_CONST(0x1c0)
#define FUSE_RESERVED_SW_0_SECURE                       0x0
#define FUSE_RESERVED_SW_0_WORD_COUNT                   0x1
#define FUSE_RESERVED_SW_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_SW_0_RESET_MASK                   _MK_MASK_CONST(0xff)
#define FUSE_RESERVED_SW_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_SW_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_SW_0_READ_MASK                    _MK_MASK_CONST(0xff)
#define FUSE_RESERVED_SW_0_WRITE_MASK                   _MK_MASK_CONST(0xff)
#define FUSE_RESERVED_SW_0_RESERVED_SW_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_RESERVED_SW_0_RESERVED_SW_FIELD                    (_MK_MASK_CONST(0xff) << FUSE_RESERVED_SW_0_RESERVED_SW_SHIFT)
#define FUSE_RESERVED_SW_0_RESERVED_SW_RANGE                    7:0
#define FUSE_RESERVED_SW_0_RESERVED_SW_WOFFSET                  0x0
#define FUSE_RESERVED_SW_0_RESERVED_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_SW_0_RESERVED_SW_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define FUSE_RESERVED_SW_0_RESERVED_SW_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_SW_0_RESERVED_SW_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_ARM_DEBUG_CONTROL_0  
#define FUSE_ARM_DEBUG_CONTROL_0                        _MK_ADDR_CONST(0x1c4)
#define FUSE_ARM_DEBUG_CONTROL_0_SECURE                         0x0
#define FUSE_ARM_DEBUG_CONTROL_0_WORD_COUNT                     0x1
#define FUSE_ARM_DEBUG_CONTROL_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_ARM_DEBUG_CONTROL_0_RESET_MASK                     _MK_MASK_CONST(0xf)
#define FUSE_ARM_DEBUG_CONTROL_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_ARM_DEBUG_CONTROL_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_ARM_DEBUG_CONTROL_0_READ_MASK                      _MK_MASK_CONST(0xf)
#define FUSE_ARM_DEBUG_CONTROL_0_WRITE_MASK                     _MK_MASK_CONST(0xf)
#define FUSE_ARM_DEBUG_CONTROL_0_ARM_DEBUG_CONTROL_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_ARM_DEBUG_CONTROL_0_ARM_DEBUG_CONTROL_FIELD                        (_MK_MASK_CONST(0xf) << FUSE_ARM_DEBUG_CONTROL_0_ARM_DEBUG_CONTROL_SHIFT)
#define FUSE_ARM_DEBUG_CONTROL_0_ARM_DEBUG_CONTROL_RANGE                        3:0
#define FUSE_ARM_DEBUG_CONTROL_0_ARM_DEBUG_CONTROL_WOFFSET                      0x0
#define FUSE_ARM_DEBUG_CONTROL_0_ARM_DEBUG_CONTROL_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_ARM_DEBUG_CONTROL_0_ARM_DEBUG_CONTROL_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define FUSE_ARM_DEBUG_CONTROL_0_ARM_DEBUG_CONTROL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_ARM_DEBUG_CONTROL_0_ARM_DEBUG_CONTROL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_RESERVED_ODM0_0  
#define FUSE_RESERVED_ODM0_0                    _MK_ADDR_CONST(0x1c8)
#define FUSE_RESERVED_ODM0_0_SECURE                     0x0
#define FUSE_RESERVED_ODM0_0_WORD_COUNT                         0x1
#define FUSE_RESERVED_ODM0_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM0_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM0_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM0_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM0_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM0_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM0_0_RESERVED_ODM0_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_RESERVED_ODM0_0_RESERVED_ODM0_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_RESERVED_ODM0_0_RESERVED_ODM0_SHIFT)
#define FUSE_RESERVED_ODM0_0_RESERVED_ODM0_RANGE                        31:0
#define FUSE_RESERVED_ODM0_0_RESERVED_ODM0_WOFFSET                      0x0
#define FUSE_RESERVED_ODM0_0_RESERVED_ODM0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM0_0_RESERVED_ODM0_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM0_0_RESERVED_ODM0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM0_0_RESERVED_ODM0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_RESERVED_ODM1_0  
#define FUSE_RESERVED_ODM1_0                    _MK_ADDR_CONST(0x1cc)
#define FUSE_RESERVED_ODM1_0_SECURE                     0x0
#define FUSE_RESERVED_ODM1_0_WORD_COUNT                         0x1
#define FUSE_RESERVED_ODM1_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM1_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM1_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM1_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM1_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM1_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM1_0_RESERVED_ODM1_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_RESERVED_ODM1_0_RESERVED_ODM1_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_RESERVED_ODM1_0_RESERVED_ODM1_SHIFT)
#define FUSE_RESERVED_ODM1_0_RESERVED_ODM1_RANGE                        31:0
#define FUSE_RESERVED_ODM1_0_RESERVED_ODM1_WOFFSET                      0x0
#define FUSE_RESERVED_ODM1_0_RESERVED_ODM1_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM1_0_RESERVED_ODM1_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM1_0_RESERVED_ODM1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM1_0_RESERVED_ODM1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_RESERVED_ODM2_0  
#define FUSE_RESERVED_ODM2_0                    _MK_ADDR_CONST(0x1d0)
#define FUSE_RESERVED_ODM2_0_SECURE                     0x0
#define FUSE_RESERVED_ODM2_0_WORD_COUNT                         0x1
#define FUSE_RESERVED_ODM2_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM2_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM2_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM2_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM2_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM2_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM2_0_RESERVED_ODM2_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_RESERVED_ODM2_0_RESERVED_ODM2_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_RESERVED_ODM2_0_RESERVED_ODM2_SHIFT)
#define FUSE_RESERVED_ODM2_0_RESERVED_ODM2_RANGE                        31:0
#define FUSE_RESERVED_ODM2_0_RESERVED_ODM2_WOFFSET                      0x0
#define FUSE_RESERVED_ODM2_0_RESERVED_ODM2_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM2_0_RESERVED_ODM2_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM2_0_RESERVED_ODM2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM2_0_RESERVED_ODM2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_RESERVED_ODM3_0  
#define FUSE_RESERVED_ODM3_0                    _MK_ADDR_CONST(0x1d4)
#define FUSE_RESERVED_ODM3_0_SECURE                     0x0
#define FUSE_RESERVED_ODM3_0_WORD_COUNT                         0x1
#define FUSE_RESERVED_ODM3_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM3_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM3_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM3_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM3_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM3_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM3_0_RESERVED_ODM3_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_RESERVED_ODM3_0_RESERVED_ODM3_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_RESERVED_ODM3_0_RESERVED_ODM3_SHIFT)
#define FUSE_RESERVED_ODM3_0_RESERVED_ODM3_RANGE                        31:0
#define FUSE_RESERVED_ODM3_0_RESERVED_ODM3_WOFFSET                      0x0
#define FUSE_RESERVED_ODM3_0_RESERVED_ODM3_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM3_0_RESERVED_ODM3_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM3_0_RESERVED_ODM3_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM3_0_RESERVED_ODM3_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_RESERVED_ODM4_0  
#define FUSE_RESERVED_ODM4_0                    _MK_ADDR_CONST(0x1d8)
#define FUSE_RESERVED_ODM4_0_SECURE                     0x0
#define FUSE_RESERVED_ODM4_0_WORD_COUNT                         0x1
#define FUSE_RESERVED_ODM4_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM4_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM4_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM4_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM4_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM4_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM4_0_RESERVED_ODM4_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_RESERVED_ODM4_0_RESERVED_ODM4_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_RESERVED_ODM4_0_RESERVED_ODM4_SHIFT)
#define FUSE_RESERVED_ODM4_0_RESERVED_ODM4_RANGE                        31:0
#define FUSE_RESERVED_ODM4_0_RESERVED_ODM4_WOFFSET                      0x0
#define FUSE_RESERVED_ODM4_0_RESERVED_ODM4_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM4_0_RESERVED_ODM4_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM4_0_RESERVED_ODM4_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM4_0_RESERVED_ODM4_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_RESERVED_ODM5_0  
#define FUSE_RESERVED_ODM5_0                    _MK_ADDR_CONST(0x1dc)
#define FUSE_RESERVED_ODM5_0_SECURE                     0x0
#define FUSE_RESERVED_ODM5_0_WORD_COUNT                         0x1
#define FUSE_RESERVED_ODM5_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM5_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM5_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM5_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM5_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM5_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM5_0_RESERVED_ODM5_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_RESERVED_ODM5_0_RESERVED_ODM5_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_RESERVED_ODM5_0_RESERVED_ODM5_SHIFT)
#define FUSE_RESERVED_ODM5_0_RESERVED_ODM5_RANGE                        31:0
#define FUSE_RESERVED_ODM5_0_RESERVED_ODM5_WOFFSET                      0x0
#define FUSE_RESERVED_ODM5_0_RESERVED_ODM5_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM5_0_RESERVED_ODM5_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM5_0_RESERVED_ODM5_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM5_0_RESERVED_ODM5_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_RESERVED_ODM6_0  
#define FUSE_RESERVED_ODM6_0                    _MK_ADDR_CONST(0x1e0)
#define FUSE_RESERVED_ODM6_0_SECURE                     0x0
#define FUSE_RESERVED_ODM6_0_WORD_COUNT                         0x1
#define FUSE_RESERVED_ODM6_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM6_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM6_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM6_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM6_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM6_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM6_0_RESERVED_ODM6_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_RESERVED_ODM6_0_RESERVED_ODM6_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_RESERVED_ODM6_0_RESERVED_ODM6_SHIFT)
#define FUSE_RESERVED_ODM6_0_RESERVED_ODM6_RANGE                        31:0
#define FUSE_RESERVED_ODM6_0_RESERVED_ODM6_WOFFSET                      0x0
#define FUSE_RESERVED_ODM6_0_RESERVED_ODM6_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM6_0_RESERVED_ODM6_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM6_0_RESERVED_ODM6_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM6_0_RESERVED_ODM6_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_RESERVED_ODM7_0  
#define FUSE_RESERVED_ODM7_0                    _MK_ADDR_CONST(0x1e4)
#define FUSE_RESERVED_ODM7_0_SECURE                     0x0
#define FUSE_RESERVED_ODM7_0_WORD_COUNT                         0x1
#define FUSE_RESERVED_ODM7_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM7_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM7_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM7_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM7_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM7_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM7_0_RESERVED_ODM7_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_RESERVED_ODM7_0_RESERVED_ODM7_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_RESERVED_ODM7_0_RESERVED_ODM7_SHIFT)
#define FUSE_RESERVED_ODM7_0_RESERVED_ODM7_RANGE                        31:0
#define FUSE_RESERVED_ODM7_0_RESERVED_ODM7_WOFFSET                      0x0
#define FUSE_RESERVED_ODM7_0_RESERVED_ODM7_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM7_0_RESERVED_ODM7_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_RESERVED_ODM7_0_RESERVED_ODM7_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_ODM7_0_RESERVED_ODM7_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_OBS_DIS_0  
#define FUSE_OBS_DIS_0                  _MK_ADDR_CONST(0x1e8)
#define FUSE_OBS_DIS_0_SECURE                   0x0
#define FUSE_OBS_DIS_0_WORD_COUNT                       0x1
#define FUSE_OBS_DIS_0_RESET_VAL                        _MK_MASK_CONST(0x1)
#define FUSE_OBS_DIS_0_RESET_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_OBS_DIS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_OBS_DIS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_OBS_DIS_0_READ_MASK                        _MK_MASK_CONST(0x1)
#define FUSE_OBS_DIS_0_WRITE_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_OBS_DIS_0_OBS_DIS_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_OBS_DIS_0_OBS_DIS_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_OBS_DIS_0_OBS_DIS_SHIFT)
#define FUSE_OBS_DIS_0_OBS_DIS_RANGE                    0:0
#define FUSE_OBS_DIS_0_OBS_DIS_WOFFSET                  0x0
#define FUSE_OBS_DIS_0_OBS_DIS_DEFAULT                  _MK_MASK_CONST(0x1)
#define FUSE_OBS_DIS_0_OBS_DIS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_OBS_DIS_0_OBS_DIS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_OBS_DIS_0_OBS_DIS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_NOR_INFO_0  
#define FUSE_NOR_INFO_0                 _MK_ADDR_CONST(0x1ec)
#define FUSE_NOR_INFO_0_SECURE                  0x0
#define FUSE_NOR_INFO_0_WORD_COUNT                      0x1
#define FUSE_NOR_INFO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_NOR_INFO_0_RESET_MASK                      _MK_MASK_CONST(0x3)
#define FUSE_NOR_INFO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_NOR_INFO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_NOR_INFO_0_READ_MASK                       _MK_MASK_CONST(0x3)
#define FUSE_NOR_INFO_0_WRITE_MASK                      _MK_MASK_CONST(0x3)
#define FUSE_NOR_INFO_0_NOR_INFO_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_NOR_INFO_0_NOR_INFO_FIELD                  (_MK_MASK_CONST(0x3) << FUSE_NOR_INFO_0_NOR_INFO_SHIFT)
#define FUSE_NOR_INFO_0_NOR_INFO_RANGE                  1:0
#define FUSE_NOR_INFO_0_NOR_INFO_WOFFSET                        0x0
#define FUSE_NOR_INFO_0_NOR_INFO_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_NOR_INFO_0_NOR_INFO_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define FUSE_NOR_INFO_0_NOR_INFO_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_NOR_INFO_0_NOR_INFO_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_USB_CALIB_0  
#define FUSE_USB_CALIB_0                        _MK_ADDR_CONST(0x1f0)
#define FUSE_USB_CALIB_0_SECURE                         0x0
#define FUSE_USB_CALIB_0_WORD_COUNT                     0x1
#define FUSE_USB_CALIB_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_USB_CALIB_0_RESET_MASK                     _MK_MASK_CONST(0x7f)
#define FUSE_USB_CALIB_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_USB_CALIB_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_USB_CALIB_0_READ_MASK                      _MK_MASK_CONST(0x7f)
#define FUSE_USB_CALIB_0_WRITE_MASK                     _MK_MASK_CONST(0x7f)
#define FUSE_USB_CALIB_0_USB_CALIB_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_USB_CALIB_0_USB_CALIB_FIELD                        (_MK_MASK_CONST(0x7f) << FUSE_USB_CALIB_0_USB_CALIB_SHIFT)
#define FUSE_USB_CALIB_0_USB_CALIB_RANGE                        6:0
#define FUSE_USB_CALIB_0_USB_CALIB_WOFFSET                      0x0
#define FUSE_USB_CALIB_0_USB_CALIB_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_USB_CALIB_0_USB_CALIB_DEFAULT_MASK                 _MK_MASK_CONST(0x7f)
#define FUSE_USB_CALIB_0_USB_CALIB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_USB_CALIB_0_USB_CALIB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Reserved address 500 [0x1f4] 

// Register FUSE_KFUSE_PRIVKEY_CTRL_0  
#define FUSE_KFUSE_PRIVKEY_CTRL_0                       _MK_ADDR_CONST(0x1f8)
#define FUSE_KFUSE_PRIVKEY_CTRL_0_SECURE                        0x0
#define FUSE_KFUSE_PRIVKEY_CTRL_0_WORD_COUNT                    0x1
#define FUSE_KFUSE_PRIVKEY_CTRL_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_KFUSE_PRIVKEY_CTRL_0_RESET_MASK                    _MK_MASK_CONST(0x3)
#define FUSE_KFUSE_PRIVKEY_CTRL_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_KFUSE_PRIVKEY_CTRL_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_KFUSE_PRIVKEY_CTRL_0_READ_MASK                     _MK_MASK_CONST(0x3)
#define FUSE_KFUSE_PRIVKEY_CTRL_0_WRITE_MASK                    _MK_MASK_CONST(0x3)
#define FUSE_KFUSE_PRIVKEY_CTRL_0_KFUSE_PRIVKEY_CTRL_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_KFUSE_PRIVKEY_CTRL_0_KFUSE_PRIVKEY_CTRL_FIELD                      (_MK_MASK_CONST(0x3) << FUSE_KFUSE_PRIVKEY_CTRL_0_KFUSE_PRIVKEY_CTRL_SHIFT)
#define FUSE_KFUSE_PRIVKEY_CTRL_0_KFUSE_PRIVKEY_CTRL_RANGE                      1:0
#define FUSE_KFUSE_PRIVKEY_CTRL_0_KFUSE_PRIVKEY_CTRL_WOFFSET                    0x0
#define FUSE_KFUSE_PRIVKEY_CTRL_0_KFUSE_PRIVKEY_CTRL_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_KFUSE_PRIVKEY_CTRL_0_KFUSE_PRIVKEY_CTRL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define FUSE_KFUSE_PRIVKEY_CTRL_0_KFUSE_PRIVKEY_CTRL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_KFUSE_PRIVKEY_CTRL_0_KFUSE_PRIVKEY_CTRL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_PACKAGE_INFO_0  
#define FUSE_PACKAGE_INFO_0                     _MK_ADDR_CONST(0x1fc)
#define FUSE_PACKAGE_INFO_0_SECURE                      0x0
#define FUSE_PACKAGE_INFO_0_WORD_COUNT                  0x1
#define FUSE_PACKAGE_INFO_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PACKAGE_INFO_0_RESET_MASK                  _MK_MASK_CONST(0x3)
#define FUSE_PACKAGE_INFO_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PACKAGE_INFO_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_PACKAGE_INFO_0_READ_MASK                   _MK_MASK_CONST(0x3)
#define FUSE_PACKAGE_INFO_0_WRITE_MASK                  _MK_MASK_CONST(0x3)
#define FUSE_PACKAGE_INFO_0_PACKAGE_INFO_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_PACKAGE_INFO_0_PACKAGE_INFO_FIELD                  (_MK_MASK_CONST(0x3) << FUSE_PACKAGE_INFO_0_PACKAGE_INFO_SHIFT)
#define FUSE_PACKAGE_INFO_0_PACKAGE_INFO_RANGE                  1:0
#define FUSE_PACKAGE_INFO_0_PACKAGE_INFO_WOFFSET                        0x0
#define FUSE_PACKAGE_INFO_0_PACKAGE_INFO_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PACKAGE_INFO_0_PACKAGE_INFO_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define FUSE_PACKAGE_INFO_0_PACKAGE_INFO_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_PACKAGE_INFO_0_PACKAGE_INFO_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_0_0  
#define FUSE_SPARE_BIT_0_0                      _MK_ADDR_CONST(0x200)
#define FUSE_SPARE_BIT_0_0_SECURE                       0x0
#define FUSE_SPARE_BIT_0_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_0_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_0_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_0_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_0_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_0_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_0_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_0_0_SPARE_BIT_0_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_0_0_SPARE_BIT_0_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_0_0_SPARE_BIT_0_SHIFT)
#define FUSE_SPARE_BIT_0_0_SPARE_BIT_0_RANGE                    0:0
#define FUSE_SPARE_BIT_0_0_SPARE_BIT_0_WOFFSET                  0x0
#define FUSE_SPARE_BIT_0_0_SPARE_BIT_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_0_0_SPARE_BIT_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_0_0_SPARE_BIT_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_0_0_SPARE_BIT_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_1_0  
#define FUSE_SPARE_BIT_1_0                      _MK_ADDR_CONST(0x204)
#define FUSE_SPARE_BIT_1_0_SECURE                       0x0
#define FUSE_SPARE_BIT_1_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_1_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_1_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_1_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_1_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_1_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_1_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_1_0_SPARE_BIT_1_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_1_0_SPARE_BIT_1_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_1_0_SPARE_BIT_1_SHIFT)
#define FUSE_SPARE_BIT_1_0_SPARE_BIT_1_RANGE                    0:0
#define FUSE_SPARE_BIT_1_0_SPARE_BIT_1_WOFFSET                  0x0
#define FUSE_SPARE_BIT_1_0_SPARE_BIT_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_1_0_SPARE_BIT_1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_1_0_SPARE_BIT_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_1_0_SPARE_BIT_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_2_0  
#define FUSE_SPARE_BIT_2_0                      _MK_ADDR_CONST(0x208)
#define FUSE_SPARE_BIT_2_0_SECURE                       0x0
#define FUSE_SPARE_BIT_2_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_2_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_2_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_2_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_2_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_2_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_2_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_2_0_SPARE_BIT_2_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_2_0_SPARE_BIT_2_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_2_0_SPARE_BIT_2_SHIFT)
#define FUSE_SPARE_BIT_2_0_SPARE_BIT_2_RANGE                    0:0
#define FUSE_SPARE_BIT_2_0_SPARE_BIT_2_WOFFSET                  0x0
#define FUSE_SPARE_BIT_2_0_SPARE_BIT_2_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_2_0_SPARE_BIT_2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_2_0_SPARE_BIT_2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_2_0_SPARE_BIT_2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_3_0  
#define FUSE_SPARE_BIT_3_0                      _MK_ADDR_CONST(0x20c)
#define FUSE_SPARE_BIT_3_0_SECURE                       0x0
#define FUSE_SPARE_BIT_3_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_3_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_3_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_3_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_3_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_3_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_3_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_3_0_SPARE_BIT_3_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_3_0_SPARE_BIT_3_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_3_0_SPARE_BIT_3_SHIFT)
#define FUSE_SPARE_BIT_3_0_SPARE_BIT_3_RANGE                    0:0
#define FUSE_SPARE_BIT_3_0_SPARE_BIT_3_WOFFSET                  0x0
#define FUSE_SPARE_BIT_3_0_SPARE_BIT_3_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_3_0_SPARE_BIT_3_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_3_0_SPARE_BIT_3_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_3_0_SPARE_BIT_3_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_4_0  
#define FUSE_SPARE_BIT_4_0                      _MK_ADDR_CONST(0x210)
#define FUSE_SPARE_BIT_4_0_SECURE                       0x0
#define FUSE_SPARE_BIT_4_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_4_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_4_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_4_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_4_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_4_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_4_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_4_0_SPARE_BIT_4_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_4_0_SPARE_BIT_4_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_4_0_SPARE_BIT_4_SHIFT)
#define FUSE_SPARE_BIT_4_0_SPARE_BIT_4_RANGE                    0:0
#define FUSE_SPARE_BIT_4_0_SPARE_BIT_4_WOFFSET                  0x0
#define FUSE_SPARE_BIT_4_0_SPARE_BIT_4_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_4_0_SPARE_BIT_4_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_4_0_SPARE_BIT_4_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_4_0_SPARE_BIT_4_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_5_0  
#define FUSE_SPARE_BIT_5_0                      _MK_ADDR_CONST(0x214)
#define FUSE_SPARE_BIT_5_0_SECURE                       0x0
#define FUSE_SPARE_BIT_5_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_5_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_5_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_5_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_5_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_5_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_5_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_5_0_SPARE_BIT_5_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_5_0_SPARE_BIT_5_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_5_0_SPARE_BIT_5_SHIFT)
#define FUSE_SPARE_BIT_5_0_SPARE_BIT_5_RANGE                    0:0
#define FUSE_SPARE_BIT_5_0_SPARE_BIT_5_WOFFSET                  0x0
#define FUSE_SPARE_BIT_5_0_SPARE_BIT_5_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_5_0_SPARE_BIT_5_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_5_0_SPARE_BIT_5_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_5_0_SPARE_BIT_5_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_6_0  
#define FUSE_SPARE_BIT_6_0                      _MK_ADDR_CONST(0x218)
#define FUSE_SPARE_BIT_6_0_SECURE                       0x0
#define FUSE_SPARE_BIT_6_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_6_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_6_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_6_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_6_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_6_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_6_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_6_0_SPARE_BIT_6_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_6_0_SPARE_BIT_6_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_6_0_SPARE_BIT_6_SHIFT)
#define FUSE_SPARE_BIT_6_0_SPARE_BIT_6_RANGE                    0:0
#define FUSE_SPARE_BIT_6_0_SPARE_BIT_6_WOFFSET                  0x0
#define FUSE_SPARE_BIT_6_0_SPARE_BIT_6_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_6_0_SPARE_BIT_6_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_6_0_SPARE_BIT_6_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_6_0_SPARE_BIT_6_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_7_0  
#define FUSE_SPARE_BIT_7_0                      _MK_ADDR_CONST(0x21c)
#define FUSE_SPARE_BIT_7_0_SECURE                       0x0
#define FUSE_SPARE_BIT_7_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_7_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_7_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_7_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_7_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_7_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_7_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_7_0_SPARE_BIT_7_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_7_0_SPARE_BIT_7_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_7_0_SPARE_BIT_7_SHIFT)
#define FUSE_SPARE_BIT_7_0_SPARE_BIT_7_RANGE                    0:0
#define FUSE_SPARE_BIT_7_0_SPARE_BIT_7_WOFFSET                  0x0
#define FUSE_SPARE_BIT_7_0_SPARE_BIT_7_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_7_0_SPARE_BIT_7_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_7_0_SPARE_BIT_7_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_7_0_SPARE_BIT_7_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_8_0  
#define FUSE_SPARE_BIT_8_0                      _MK_ADDR_CONST(0x220)
#define FUSE_SPARE_BIT_8_0_SECURE                       0x0
#define FUSE_SPARE_BIT_8_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_8_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_8_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_8_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_8_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_8_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_8_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_8_0_SPARE_BIT_8_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_8_0_SPARE_BIT_8_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_8_0_SPARE_BIT_8_SHIFT)
#define FUSE_SPARE_BIT_8_0_SPARE_BIT_8_RANGE                    0:0
#define FUSE_SPARE_BIT_8_0_SPARE_BIT_8_WOFFSET                  0x0
#define FUSE_SPARE_BIT_8_0_SPARE_BIT_8_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_8_0_SPARE_BIT_8_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_8_0_SPARE_BIT_8_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_8_0_SPARE_BIT_8_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_9_0  
#define FUSE_SPARE_BIT_9_0                      _MK_ADDR_CONST(0x224)
#define FUSE_SPARE_BIT_9_0_SECURE                       0x0
#define FUSE_SPARE_BIT_9_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_9_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_9_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_9_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_9_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_9_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_9_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_9_0_SPARE_BIT_9_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_9_0_SPARE_BIT_9_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_9_0_SPARE_BIT_9_SHIFT)
#define FUSE_SPARE_BIT_9_0_SPARE_BIT_9_RANGE                    0:0
#define FUSE_SPARE_BIT_9_0_SPARE_BIT_9_WOFFSET                  0x0
#define FUSE_SPARE_BIT_9_0_SPARE_BIT_9_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_9_0_SPARE_BIT_9_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_9_0_SPARE_BIT_9_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_9_0_SPARE_BIT_9_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_10_0  
#define FUSE_SPARE_BIT_10_0                     _MK_ADDR_CONST(0x228)
#define FUSE_SPARE_BIT_10_0_SECURE                      0x0
#define FUSE_SPARE_BIT_10_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_10_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_10_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_10_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_10_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_10_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_10_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_10_0_SPARE_BIT_10_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_10_0_SPARE_BIT_10_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_10_0_SPARE_BIT_10_SHIFT)
#define FUSE_SPARE_BIT_10_0_SPARE_BIT_10_RANGE                  0:0
#define FUSE_SPARE_BIT_10_0_SPARE_BIT_10_WOFFSET                        0x0
#define FUSE_SPARE_BIT_10_0_SPARE_BIT_10_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_10_0_SPARE_BIT_10_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_10_0_SPARE_BIT_10_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_10_0_SPARE_BIT_10_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_11_0  
#define FUSE_SPARE_BIT_11_0                     _MK_ADDR_CONST(0x22c)
#define FUSE_SPARE_BIT_11_0_SECURE                      0x0
#define FUSE_SPARE_BIT_11_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_11_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_11_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_11_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_11_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_11_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_11_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_11_0_SPARE_BIT_11_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_11_0_SPARE_BIT_11_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_11_0_SPARE_BIT_11_SHIFT)
#define FUSE_SPARE_BIT_11_0_SPARE_BIT_11_RANGE                  0:0
#define FUSE_SPARE_BIT_11_0_SPARE_BIT_11_WOFFSET                        0x0
#define FUSE_SPARE_BIT_11_0_SPARE_BIT_11_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_11_0_SPARE_BIT_11_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_11_0_SPARE_BIT_11_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_11_0_SPARE_BIT_11_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_12_0  
#define FUSE_SPARE_BIT_12_0                     _MK_ADDR_CONST(0x230)
#define FUSE_SPARE_BIT_12_0_SECURE                      0x0
#define FUSE_SPARE_BIT_12_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_12_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_12_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_12_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_12_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_12_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_12_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_12_0_SPARE_BIT_12_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_12_0_SPARE_BIT_12_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_12_0_SPARE_BIT_12_SHIFT)
#define FUSE_SPARE_BIT_12_0_SPARE_BIT_12_RANGE                  0:0
#define FUSE_SPARE_BIT_12_0_SPARE_BIT_12_WOFFSET                        0x0
#define FUSE_SPARE_BIT_12_0_SPARE_BIT_12_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_12_0_SPARE_BIT_12_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_12_0_SPARE_BIT_12_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_12_0_SPARE_BIT_12_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_13_0  
#define FUSE_SPARE_BIT_13_0                     _MK_ADDR_CONST(0x234)
#define FUSE_SPARE_BIT_13_0_SECURE                      0x0
#define FUSE_SPARE_BIT_13_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_13_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_13_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_13_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_13_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_13_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_13_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_13_0_SPARE_BIT_13_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_13_0_SPARE_BIT_13_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_13_0_SPARE_BIT_13_SHIFT)
#define FUSE_SPARE_BIT_13_0_SPARE_BIT_13_RANGE                  0:0
#define FUSE_SPARE_BIT_13_0_SPARE_BIT_13_WOFFSET                        0x0
#define FUSE_SPARE_BIT_13_0_SPARE_BIT_13_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_13_0_SPARE_BIT_13_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_13_0_SPARE_BIT_13_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_13_0_SPARE_BIT_13_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_14_0  
#define FUSE_SPARE_BIT_14_0                     _MK_ADDR_CONST(0x238)
#define FUSE_SPARE_BIT_14_0_SECURE                      0x0
#define FUSE_SPARE_BIT_14_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_14_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_14_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_14_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_14_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_14_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_14_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_14_0_SPARE_BIT_14_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_14_0_SPARE_BIT_14_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_14_0_SPARE_BIT_14_SHIFT)
#define FUSE_SPARE_BIT_14_0_SPARE_BIT_14_RANGE                  0:0
#define FUSE_SPARE_BIT_14_0_SPARE_BIT_14_WOFFSET                        0x0
#define FUSE_SPARE_BIT_14_0_SPARE_BIT_14_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_14_0_SPARE_BIT_14_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_14_0_SPARE_BIT_14_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_14_0_SPARE_BIT_14_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_15_0  
#define FUSE_SPARE_BIT_15_0                     _MK_ADDR_CONST(0x23c)
#define FUSE_SPARE_BIT_15_0_SECURE                      0x0
#define FUSE_SPARE_BIT_15_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_15_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_15_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_15_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_15_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_15_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_15_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_15_0_SPARE_BIT_15_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_15_0_SPARE_BIT_15_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_15_0_SPARE_BIT_15_SHIFT)
#define FUSE_SPARE_BIT_15_0_SPARE_BIT_15_RANGE                  0:0
#define FUSE_SPARE_BIT_15_0_SPARE_BIT_15_WOFFSET                        0x0
#define FUSE_SPARE_BIT_15_0_SPARE_BIT_15_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_15_0_SPARE_BIT_15_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_15_0_SPARE_BIT_15_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_15_0_SPARE_BIT_15_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_16_0  
#define FUSE_SPARE_BIT_16_0                     _MK_ADDR_CONST(0x240)
#define FUSE_SPARE_BIT_16_0_SECURE                      0x0
#define FUSE_SPARE_BIT_16_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_16_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_16_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_16_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_16_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_16_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_16_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_16_0_SPARE_BIT_16_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_16_0_SPARE_BIT_16_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_16_0_SPARE_BIT_16_SHIFT)
#define FUSE_SPARE_BIT_16_0_SPARE_BIT_16_RANGE                  0:0
#define FUSE_SPARE_BIT_16_0_SPARE_BIT_16_WOFFSET                        0x0
#define FUSE_SPARE_BIT_16_0_SPARE_BIT_16_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_16_0_SPARE_BIT_16_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_16_0_SPARE_BIT_16_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_16_0_SPARE_BIT_16_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_17_0  
#define FUSE_SPARE_BIT_17_0                     _MK_ADDR_CONST(0x244)
#define FUSE_SPARE_BIT_17_0_SECURE                      0x0
#define FUSE_SPARE_BIT_17_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_17_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_17_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_17_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_17_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_17_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_17_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_17_0_SPARE_BIT_17_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_17_0_SPARE_BIT_17_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_17_0_SPARE_BIT_17_SHIFT)
#define FUSE_SPARE_BIT_17_0_SPARE_BIT_17_RANGE                  0:0
#define FUSE_SPARE_BIT_17_0_SPARE_BIT_17_WOFFSET                        0x0
#define FUSE_SPARE_BIT_17_0_SPARE_BIT_17_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_17_0_SPARE_BIT_17_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_17_0_SPARE_BIT_17_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_17_0_SPARE_BIT_17_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_18_0  
#define FUSE_SPARE_BIT_18_0                     _MK_ADDR_CONST(0x248)
#define FUSE_SPARE_BIT_18_0_SECURE                      0x0
#define FUSE_SPARE_BIT_18_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_18_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_18_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_18_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_18_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_18_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_18_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_18_0_SPARE_BIT_18_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_18_0_SPARE_BIT_18_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_18_0_SPARE_BIT_18_SHIFT)
#define FUSE_SPARE_BIT_18_0_SPARE_BIT_18_RANGE                  0:0
#define FUSE_SPARE_BIT_18_0_SPARE_BIT_18_WOFFSET                        0x0
#define FUSE_SPARE_BIT_18_0_SPARE_BIT_18_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_18_0_SPARE_BIT_18_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_18_0_SPARE_BIT_18_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_18_0_SPARE_BIT_18_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_19_0  
#define FUSE_SPARE_BIT_19_0                     _MK_ADDR_CONST(0x24c)
#define FUSE_SPARE_BIT_19_0_SECURE                      0x0
#define FUSE_SPARE_BIT_19_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_19_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_19_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_19_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_19_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_19_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_19_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_19_0_SPARE_BIT_19_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_19_0_SPARE_BIT_19_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_19_0_SPARE_BIT_19_SHIFT)
#define FUSE_SPARE_BIT_19_0_SPARE_BIT_19_RANGE                  0:0
#define FUSE_SPARE_BIT_19_0_SPARE_BIT_19_WOFFSET                        0x0
#define FUSE_SPARE_BIT_19_0_SPARE_BIT_19_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_19_0_SPARE_BIT_19_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_19_0_SPARE_BIT_19_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_19_0_SPARE_BIT_19_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_20_0  
#define FUSE_SPARE_BIT_20_0                     _MK_ADDR_CONST(0x250)
#define FUSE_SPARE_BIT_20_0_SECURE                      0x0
#define FUSE_SPARE_BIT_20_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_20_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_20_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_20_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_20_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_20_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_20_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_20_0_SPARE_BIT_20_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_20_0_SPARE_BIT_20_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_20_0_SPARE_BIT_20_SHIFT)
#define FUSE_SPARE_BIT_20_0_SPARE_BIT_20_RANGE                  0:0
#define FUSE_SPARE_BIT_20_0_SPARE_BIT_20_WOFFSET                        0x0
#define FUSE_SPARE_BIT_20_0_SPARE_BIT_20_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_20_0_SPARE_BIT_20_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_20_0_SPARE_BIT_20_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_20_0_SPARE_BIT_20_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_21_0  
#define FUSE_SPARE_BIT_21_0                     _MK_ADDR_CONST(0x254)
#define FUSE_SPARE_BIT_21_0_SECURE                      0x0
#define FUSE_SPARE_BIT_21_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_21_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_21_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_21_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_21_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_21_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_21_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_21_0_SPARE_BIT_21_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_21_0_SPARE_BIT_21_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_21_0_SPARE_BIT_21_SHIFT)
#define FUSE_SPARE_BIT_21_0_SPARE_BIT_21_RANGE                  0:0
#define FUSE_SPARE_BIT_21_0_SPARE_BIT_21_WOFFSET                        0x0
#define FUSE_SPARE_BIT_21_0_SPARE_BIT_21_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_21_0_SPARE_BIT_21_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_21_0_SPARE_BIT_21_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_21_0_SPARE_BIT_21_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_22_0  
#define FUSE_SPARE_BIT_22_0                     _MK_ADDR_CONST(0x258)
#define FUSE_SPARE_BIT_22_0_SECURE                      0x0
#define FUSE_SPARE_BIT_22_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_22_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_22_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_22_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_22_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_22_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_22_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_22_0_SPARE_BIT_22_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_22_0_SPARE_BIT_22_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_22_0_SPARE_BIT_22_SHIFT)
#define FUSE_SPARE_BIT_22_0_SPARE_BIT_22_RANGE                  0:0
#define FUSE_SPARE_BIT_22_0_SPARE_BIT_22_WOFFSET                        0x0
#define FUSE_SPARE_BIT_22_0_SPARE_BIT_22_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_22_0_SPARE_BIT_22_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_22_0_SPARE_BIT_22_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_22_0_SPARE_BIT_22_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_23_0  
#define FUSE_SPARE_BIT_23_0                     _MK_ADDR_CONST(0x25c)
#define FUSE_SPARE_BIT_23_0_SECURE                      0x0
#define FUSE_SPARE_BIT_23_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_23_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_23_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_23_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_23_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_23_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_23_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_23_0_SPARE_BIT_23_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_23_0_SPARE_BIT_23_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_23_0_SPARE_BIT_23_SHIFT)
#define FUSE_SPARE_BIT_23_0_SPARE_BIT_23_RANGE                  0:0
#define FUSE_SPARE_BIT_23_0_SPARE_BIT_23_WOFFSET                        0x0
#define FUSE_SPARE_BIT_23_0_SPARE_BIT_23_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_23_0_SPARE_BIT_23_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_23_0_SPARE_BIT_23_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_23_0_SPARE_BIT_23_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_24_0  
#define FUSE_SPARE_BIT_24_0                     _MK_ADDR_CONST(0x260)
#define FUSE_SPARE_BIT_24_0_SECURE                      0x0
#define FUSE_SPARE_BIT_24_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_24_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_24_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_24_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_24_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_24_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_24_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_24_0_SPARE_BIT_24_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_24_0_SPARE_BIT_24_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_24_0_SPARE_BIT_24_SHIFT)
#define FUSE_SPARE_BIT_24_0_SPARE_BIT_24_RANGE                  0:0
#define FUSE_SPARE_BIT_24_0_SPARE_BIT_24_WOFFSET                        0x0
#define FUSE_SPARE_BIT_24_0_SPARE_BIT_24_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_24_0_SPARE_BIT_24_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_24_0_SPARE_BIT_24_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_24_0_SPARE_BIT_24_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_25_0  
#define FUSE_SPARE_BIT_25_0                     _MK_ADDR_CONST(0x264)
#define FUSE_SPARE_BIT_25_0_SECURE                      0x0
#define FUSE_SPARE_BIT_25_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_25_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_25_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_25_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_25_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_25_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_25_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_25_0_SPARE_BIT_25_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_25_0_SPARE_BIT_25_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_25_0_SPARE_BIT_25_SHIFT)
#define FUSE_SPARE_BIT_25_0_SPARE_BIT_25_RANGE                  0:0
#define FUSE_SPARE_BIT_25_0_SPARE_BIT_25_WOFFSET                        0x0
#define FUSE_SPARE_BIT_25_0_SPARE_BIT_25_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_25_0_SPARE_BIT_25_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_25_0_SPARE_BIT_25_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_25_0_SPARE_BIT_25_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_26_0  
#define FUSE_SPARE_BIT_26_0                     _MK_ADDR_CONST(0x268)
#define FUSE_SPARE_BIT_26_0_SECURE                      0x0
#define FUSE_SPARE_BIT_26_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_26_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_26_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_26_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_26_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_26_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_26_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_26_0_SPARE_BIT_26_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_26_0_SPARE_BIT_26_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_26_0_SPARE_BIT_26_SHIFT)
#define FUSE_SPARE_BIT_26_0_SPARE_BIT_26_RANGE                  0:0
#define FUSE_SPARE_BIT_26_0_SPARE_BIT_26_WOFFSET                        0x0
#define FUSE_SPARE_BIT_26_0_SPARE_BIT_26_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_26_0_SPARE_BIT_26_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_26_0_SPARE_BIT_26_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_26_0_SPARE_BIT_26_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_27_0  
#define FUSE_SPARE_BIT_27_0                     _MK_ADDR_CONST(0x26c)
#define FUSE_SPARE_BIT_27_0_SECURE                      0x0
#define FUSE_SPARE_BIT_27_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_27_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_27_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_27_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_27_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_27_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_27_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_27_0_SPARE_BIT_27_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_27_0_SPARE_BIT_27_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_27_0_SPARE_BIT_27_SHIFT)
#define FUSE_SPARE_BIT_27_0_SPARE_BIT_27_RANGE                  0:0
#define FUSE_SPARE_BIT_27_0_SPARE_BIT_27_WOFFSET                        0x0
#define FUSE_SPARE_BIT_27_0_SPARE_BIT_27_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_27_0_SPARE_BIT_27_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_27_0_SPARE_BIT_27_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_27_0_SPARE_BIT_27_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_28_0  
#define FUSE_SPARE_BIT_28_0                     _MK_ADDR_CONST(0x270)
#define FUSE_SPARE_BIT_28_0_SECURE                      0x0
#define FUSE_SPARE_BIT_28_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_28_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_28_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_28_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_28_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_28_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_28_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_28_0_SPARE_BIT_28_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_28_0_SPARE_BIT_28_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_28_0_SPARE_BIT_28_SHIFT)
#define FUSE_SPARE_BIT_28_0_SPARE_BIT_28_RANGE                  0:0
#define FUSE_SPARE_BIT_28_0_SPARE_BIT_28_WOFFSET                        0x0
#define FUSE_SPARE_BIT_28_0_SPARE_BIT_28_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_28_0_SPARE_BIT_28_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_28_0_SPARE_BIT_28_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_28_0_SPARE_BIT_28_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_29_0  
#define FUSE_SPARE_BIT_29_0                     _MK_ADDR_CONST(0x274)
#define FUSE_SPARE_BIT_29_0_SECURE                      0x0
#define FUSE_SPARE_BIT_29_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_29_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_29_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_29_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_29_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_29_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_29_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_29_0_SPARE_BIT_29_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_29_0_SPARE_BIT_29_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_29_0_SPARE_BIT_29_SHIFT)
#define FUSE_SPARE_BIT_29_0_SPARE_BIT_29_RANGE                  0:0
#define FUSE_SPARE_BIT_29_0_SPARE_BIT_29_WOFFSET                        0x0
#define FUSE_SPARE_BIT_29_0_SPARE_BIT_29_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_29_0_SPARE_BIT_29_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_29_0_SPARE_BIT_29_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_29_0_SPARE_BIT_29_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_30_0  
#define FUSE_SPARE_BIT_30_0                     _MK_ADDR_CONST(0x278)
#define FUSE_SPARE_BIT_30_0_SECURE                      0x0
#define FUSE_SPARE_BIT_30_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_30_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_30_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_30_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_30_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_30_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_30_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_30_0_SPARE_BIT_30_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_30_0_SPARE_BIT_30_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_30_0_SPARE_BIT_30_SHIFT)
#define FUSE_SPARE_BIT_30_0_SPARE_BIT_30_RANGE                  0:0
#define FUSE_SPARE_BIT_30_0_SPARE_BIT_30_WOFFSET                        0x0
#define FUSE_SPARE_BIT_30_0_SPARE_BIT_30_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_30_0_SPARE_BIT_30_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_30_0_SPARE_BIT_30_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_30_0_SPARE_BIT_30_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_31_0  
#define FUSE_SPARE_BIT_31_0                     _MK_ADDR_CONST(0x27c)
#define FUSE_SPARE_BIT_31_0_SECURE                      0x0
#define FUSE_SPARE_BIT_31_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_31_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_31_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_31_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_31_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_31_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_31_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_31_0_SPARE_BIT_31_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_31_0_SPARE_BIT_31_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_31_0_SPARE_BIT_31_SHIFT)
#define FUSE_SPARE_BIT_31_0_SPARE_BIT_31_RANGE                  0:0
#define FUSE_SPARE_BIT_31_0_SPARE_BIT_31_WOFFSET                        0x0
#define FUSE_SPARE_BIT_31_0_SPARE_BIT_31_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_31_0_SPARE_BIT_31_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_31_0_SPARE_BIT_31_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_31_0_SPARE_BIT_31_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_32_0  
#define FUSE_SPARE_BIT_32_0                     _MK_ADDR_CONST(0x280)
#define FUSE_SPARE_BIT_32_0_SECURE                      0x0
#define FUSE_SPARE_BIT_32_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_32_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_32_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_32_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_32_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_32_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_32_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_32_0_SPARE_BIT_32_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_32_0_SPARE_BIT_32_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_32_0_SPARE_BIT_32_SHIFT)
#define FUSE_SPARE_BIT_32_0_SPARE_BIT_32_RANGE                  0:0
#define FUSE_SPARE_BIT_32_0_SPARE_BIT_32_WOFFSET                        0x0
#define FUSE_SPARE_BIT_32_0_SPARE_BIT_32_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_32_0_SPARE_BIT_32_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_32_0_SPARE_BIT_32_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_32_0_SPARE_BIT_32_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_33_0  
#define FUSE_SPARE_BIT_33_0                     _MK_ADDR_CONST(0x284)
#define FUSE_SPARE_BIT_33_0_SECURE                      0x0
#define FUSE_SPARE_BIT_33_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_33_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_33_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_33_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_33_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_33_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_33_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_33_0_SPARE_BIT_33_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_33_0_SPARE_BIT_33_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_33_0_SPARE_BIT_33_SHIFT)
#define FUSE_SPARE_BIT_33_0_SPARE_BIT_33_RANGE                  0:0
#define FUSE_SPARE_BIT_33_0_SPARE_BIT_33_WOFFSET                        0x0
#define FUSE_SPARE_BIT_33_0_SPARE_BIT_33_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_33_0_SPARE_BIT_33_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_33_0_SPARE_BIT_33_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_33_0_SPARE_BIT_33_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_34_0  
#define FUSE_SPARE_BIT_34_0                     _MK_ADDR_CONST(0x288)
#define FUSE_SPARE_BIT_34_0_SECURE                      0x0
#define FUSE_SPARE_BIT_34_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_34_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_34_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_34_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_34_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_34_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_34_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_34_0_SPARE_BIT_34_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_34_0_SPARE_BIT_34_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_34_0_SPARE_BIT_34_SHIFT)
#define FUSE_SPARE_BIT_34_0_SPARE_BIT_34_RANGE                  0:0
#define FUSE_SPARE_BIT_34_0_SPARE_BIT_34_WOFFSET                        0x0
#define FUSE_SPARE_BIT_34_0_SPARE_BIT_34_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_34_0_SPARE_BIT_34_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_34_0_SPARE_BIT_34_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_34_0_SPARE_BIT_34_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_35_0  
#define FUSE_SPARE_BIT_35_0                     _MK_ADDR_CONST(0x28c)
#define FUSE_SPARE_BIT_35_0_SECURE                      0x0
#define FUSE_SPARE_BIT_35_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_35_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_35_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_35_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_35_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_35_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_35_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_35_0_SPARE_BIT_35_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_35_0_SPARE_BIT_35_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_35_0_SPARE_BIT_35_SHIFT)
#define FUSE_SPARE_BIT_35_0_SPARE_BIT_35_RANGE                  0:0
#define FUSE_SPARE_BIT_35_0_SPARE_BIT_35_WOFFSET                        0x0
#define FUSE_SPARE_BIT_35_0_SPARE_BIT_35_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_35_0_SPARE_BIT_35_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_35_0_SPARE_BIT_35_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_35_0_SPARE_BIT_35_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_36_0  
#define FUSE_SPARE_BIT_36_0                     _MK_ADDR_CONST(0x290)
#define FUSE_SPARE_BIT_36_0_SECURE                      0x0
#define FUSE_SPARE_BIT_36_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_36_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_36_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_36_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_36_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_36_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_36_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_36_0_SPARE_BIT_36_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_36_0_SPARE_BIT_36_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_36_0_SPARE_BIT_36_SHIFT)
#define FUSE_SPARE_BIT_36_0_SPARE_BIT_36_RANGE                  0:0
#define FUSE_SPARE_BIT_36_0_SPARE_BIT_36_WOFFSET                        0x0
#define FUSE_SPARE_BIT_36_0_SPARE_BIT_36_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_36_0_SPARE_BIT_36_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_36_0_SPARE_BIT_36_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_36_0_SPARE_BIT_36_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_37_0  
#define FUSE_SPARE_BIT_37_0                     _MK_ADDR_CONST(0x294)
#define FUSE_SPARE_BIT_37_0_SECURE                      0x0
#define FUSE_SPARE_BIT_37_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_37_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_37_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_37_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_37_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_37_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_37_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_37_0_SPARE_BIT_37_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_37_0_SPARE_BIT_37_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_37_0_SPARE_BIT_37_SHIFT)
#define FUSE_SPARE_BIT_37_0_SPARE_BIT_37_RANGE                  0:0
#define FUSE_SPARE_BIT_37_0_SPARE_BIT_37_WOFFSET                        0x0
#define FUSE_SPARE_BIT_37_0_SPARE_BIT_37_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_37_0_SPARE_BIT_37_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_37_0_SPARE_BIT_37_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_37_0_SPARE_BIT_37_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_38_0  
#define FUSE_SPARE_BIT_38_0                     _MK_ADDR_CONST(0x298)
#define FUSE_SPARE_BIT_38_0_SECURE                      0x0
#define FUSE_SPARE_BIT_38_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_38_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_38_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_38_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_38_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_38_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_38_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_38_0_SPARE_BIT_38_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_38_0_SPARE_BIT_38_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_38_0_SPARE_BIT_38_SHIFT)
#define FUSE_SPARE_BIT_38_0_SPARE_BIT_38_RANGE                  0:0
#define FUSE_SPARE_BIT_38_0_SPARE_BIT_38_WOFFSET                        0x0
#define FUSE_SPARE_BIT_38_0_SPARE_BIT_38_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_38_0_SPARE_BIT_38_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_38_0_SPARE_BIT_38_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_38_0_SPARE_BIT_38_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_39_0  
#define FUSE_SPARE_BIT_39_0                     _MK_ADDR_CONST(0x29c)
#define FUSE_SPARE_BIT_39_0_SECURE                      0x0
#define FUSE_SPARE_BIT_39_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_39_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_39_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_39_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_39_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_39_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_39_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_39_0_SPARE_BIT_39_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_39_0_SPARE_BIT_39_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_39_0_SPARE_BIT_39_SHIFT)
#define FUSE_SPARE_BIT_39_0_SPARE_BIT_39_RANGE                  0:0
#define FUSE_SPARE_BIT_39_0_SPARE_BIT_39_WOFFSET                        0x0
#define FUSE_SPARE_BIT_39_0_SPARE_BIT_39_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_39_0_SPARE_BIT_39_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_39_0_SPARE_BIT_39_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_39_0_SPARE_BIT_39_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_40_0  
#define FUSE_SPARE_BIT_40_0                     _MK_ADDR_CONST(0x2a0)
#define FUSE_SPARE_BIT_40_0_SECURE                      0x0
#define FUSE_SPARE_BIT_40_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_40_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_40_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_40_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_40_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_40_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_40_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_40_0_SPARE_BIT_40_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_40_0_SPARE_BIT_40_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_40_0_SPARE_BIT_40_SHIFT)
#define FUSE_SPARE_BIT_40_0_SPARE_BIT_40_RANGE                  0:0
#define FUSE_SPARE_BIT_40_0_SPARE_BIT_40_WOFFSET                        0x0
#define FUSE_SPARE_BIT_40_0_SPARE_BIT_40_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_40_0_SPARE_BIT_40_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_40_0_SPARE_BIT_40_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_40_0_SPARE_BIT_40_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_41_0  
#define FUSE_SPARE_BIT_41_0                     _MK_ADDR_CONST(0x2a4)
#define FUSE_SPARE_BIT_41_0_SECURE                      0x0
#define FUSE_SPARE_BIT_41_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_41_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_41_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_41_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_41_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_41_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_41_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_41_0_SPARE_BIT_41_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_41_0_SPARE_BIT_41_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_41_0_SPARE_BIT_41_SHIFT)
#define FUSE_SPARE_BIT_41_0_SPARE_BIT_41_RANGE                  0:0
#define FUSE_SPARE_BIT_41_0_SPARE_BIT_41_WOFFSET                        0x0
#define FUSE_SPARE_BIT_41_0_SPARE_BIT_41_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_41_0_SPARE_BIT_41_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_41_0_SPARE_BIT_41_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_41_0_SPARE_BIT_41_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_42_0  
#define FUSE_SPARE_BIT_42_0                     _MK_ADDR_CONST(0x2a8)
#define FUSE_SPARE_BIT_42_0_SECURE                      0x0
#define FUSE_SPARE_BIT_42_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_42_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_42_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_42_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_42_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_42_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_42_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_42_0_SPARE_BIT_42_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_42_0_SPARE_BIT_42_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_42_0_SPARE_BIT_42_SHIFT)
#define FUSE_SPARE_BIT_42_0_SPARE_BIT_42_RANGE                  0:0
#define FUSE_SPARE_BIT_42_0_SPARE_BIT_42_WOFFSET                        0x0
#define FUSE_SPARE_BIT_42_0_SPARE_BIT_42_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_42_0_SPARE_BIT_42_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_42_0_SPARE_BIT_42_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_42_0_SPARE_BIT_42_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_43_0  
#define FUSE_SPARE_BIT_43_0                     _MK_ADDR_CONST(0x2ac)
#define FUSE_SPARE_BIT_43_0_SECURE                      0x0
#define FUSE_SPARE_BIT_43_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_43_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_43_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_43_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_43_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_43_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_43_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_43_0_SPARE_BIT_43_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_43_0_SPARE_BIT_43_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_43_0_SPARE_BIT_43_SHIFT)
#define FUSE_SPARE_BIT_43_0_SPARE_BIT_43_RANGE                  0:0
#define FUSE_SPARE_BIT_43_0_SPARE_BIT_43_WOFFSET                        0x0
#define FUSE_SPARE_BIT_43_0_SPARE_BIT_43_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_43_0_SPARE_BIT_43_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_43_0_SPARE_BIT_43_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_43_0_SPARE_BIT_43_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_44_0  
#define FUSE_SPARE_BIT_44_0                     _MK_ADDR_CONST(0x2b0)
#define FUSE_SPARE_BIT_44_0_SECURE                      0x0
#define FUSE_SPARE_BIT_44_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_44_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_44_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_44_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_44_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_44_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_44_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_44_0_SPARE_BIT_44_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_44_0_SPARE_BIT_44_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_44_0_SPARE_BIT_44_SHIFT)
#define FUSE_SPARE_BIT_44_0_SPARE_BIT_44_RANGE                  0:0
#define FUSE_SPARE_BIT_44_0_SPARE_BIT_44_WOFFSET                        0x0
#define FUSE_SPARE_BIT_44_0_SPARE_BIT_44_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_44_0_SPARE_BIT_44_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_44_0_SPARE_BIT_44_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_44_0_SPARE_BIT_44_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_45_0  
#define FUSE_SPARE_BIT_45_0                     _MK_ADDR_CONST(0x2b4)
#define FUSE_SPARE_BIT_45_0_SECURE                      0x0
#define FUSE_SPARE_BIT_45_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_45_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_45_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_45_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_45_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_45_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_45_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_45_0_SPARE_BIT_45_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_45_0_SPARE_BIT_45_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_45_0_SPARE_BIT_45_SHIFT)
#define FUSE_SPARE_BIT_45_0_SPARE_BIT_45_RANGE                  0:0
#define FUSE_SPARE_BIT_45_0_SPARE_BIT_45_WOFFSET                        0x0
#define FUSE_SPARE_BIT_45_0_SPARE_BIT_45_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_45_0_SPARE_BIT_45_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_45_0_SPARE_BIT_45_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_45_0_SPARE_BIT_45_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_46_0  
#define FUSE_SPARE_BIT_46_0                     _MK_ADDR_CONST(0x2b8)
#define FUSE_SPARE_BIT_46_0_SECURE                      0x0
#define FUSE_SPARE_BIT_46_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_46_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_46_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_46_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_46_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_46_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_46_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_46_0_SPARE_BIT_46_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_46_0_SPARE_BIT_46_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_46_0_SPARE_BIT_46_SHIFT)
#define FUSE_SPARE_BIT_46_0_SPARE_BIT_46_RANGE                  0:0
#define FUSE_SPARE_BIT_46_0_SPARE_BIT_46_WOFFSET                        0x0
#define FUSE_SPARE_BIT_46_0_SPARE_BIT_46_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_46_0_SPARE_BIT_46_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_46_0_SPARE_BIT_46_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_46_0_SPARE_BIT_46_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_47_0  
#define FUSE_SPARE_BIT_47_0                     _MK_ADDR_CONST(0x2bc)
#define FUSE_SPARE_BIT_47_0_SECURE                      0x0
#define FUSE_SPARE_BIT_47_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_47_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_47_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_47_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_47_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_47_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_47_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_47_0_SPARE_BIT_47_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_47_0_SPARE_BIT_47_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_47_0_SPARE_BIT_47_SHIFT)
#define FUSE_SPARE_BIT_47_0_SPARE_BIT_47_RANGE                  0:0
#define FUSE_SPARE_BIT_47_0_SPARE_BIT_47_WOFFSET                        0x0
#define FUSE_SPARE_BIT_47_0_SPARE_BIT_47_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_47_0_SPARE_BIT_47_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_47_0_SPARE_BIT_47_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_47_0_SPARE_BIT_47_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_48_0  
#define FUSE_SPARE_BIT_48_0                     _MK_ADDR_CONST(0x2c0)
#define FUSE_SPARE_BIT_48_0_SECURE                      0x0
#define FUSE_SPARE_BIT_48_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_48_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_48_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_48_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_48_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_48_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_48_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_48_0_SPARE_BIT_48_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_48_0_SPARE_BIT_48_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_48_0_SPARE_BIT_48_SHIFT)
#define FUSE_SPARE_BIT_48_0_SPARE_BIT_48_RANGE                  0:0
#define FUSE_SPARE_BIT_48_0_SPARE_BIT_48_WOFFSET                        0x0
#define FUSE_SPARE_BIT_48_0_SPARE_BIT_48_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_48_0_SPARE_BIT_48_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_48_0_SPARE_BIT_48_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_48_0_SPARE_BIT_48_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_49_0  
#define FUSE_SPARE_BIT_49_0                     _MK_ADDR_CONST(0x2c4)
#define FUSE_SPARE_BIT_49_0_SECURE                      0x0
#define FUSE_SPARE_BIT_49_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_49_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_49_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_49_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_49_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_49_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_49_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_49_0_SPARE_BIT_49_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_49_0_SPARE_BIT_49_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_49_0_SPARE_BIT_49_SHIFT)
#define FUSE_SPARE_BIT_49_0_SPARE_BIT_49_RANGE                  0:0
#define FUSE_SPARE_BIT_49_0_SPARE_BIT_49_WOFFSET                        0x0
#define FUSE_SPARE_BIT_49_0_SPARE_BIT_49_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_49_0_SPARE_BIT_49_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_49_0_SPARE_BIT_49_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_49_0_SPARE_BIT_49_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_50_0  
#define FUSE_SPARE_BIT_50_0                     _MK_ADDR_CONST(0x2c8)
#define FUSE_SPARE_BIT_50_0_SECURE                      0x0
#define FUSE_SPARE_BIT_50_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_50_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_50_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_50_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_50_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_50_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_50_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_50_0_SPARE_BIT_50_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_50_0_SPARE_BIT_50_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_50_0_SPARE_BIT_50_SHIFT)
#define FUSE_SPARE_BIT_50_0_SPARE_BIT_50_RANGE                  0:0
#define FUSE_SPARE_BIT_50_0_SPARE_BIT_50_WOFFSET                        0x0
#define FUSE_SPARE_BIT_50_0_SPARE_BIT_50_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_50_0_SPARE_BIT_50_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_50_0_SPARE_BIT_50_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_50_0_SPARE_BIT_50_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_51_0  
#define FUSE_SPARE_BIT_51_0                     _MK_ADDR_CONST(0x2cc)
#define FUSE_SPARE_BIT_51_0_SECURE                      0x0
#define FUSE_SPARE_BIT_51_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_51_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_51_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_51_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_51_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_51_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_51_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_51_0_SPARE_BIT_51_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_51_0_SPARE_BIT_51_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_51_0_SPARE_BIT_51_SHIFT)
#define FUSE_SPARE_BIT_51_0_SPARE_BIT_51_RANGE                  0:0
#define FUSE_SPARE_BIT_51_0_SPARE_BIT_51_WOFFSET                        0x0
#define FUSE_SPARE_BIT_51_0_SPARE_BIT_51_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_51_0_SPARE_BIT_51_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_51_0_SPARE_BIT_51_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_51_0_SPARE_BIT_51_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_52_0  
#define FUSE_SPARE_BIT_52_0                     _MK_ADDR_CONST(0x2d0)
#define FUSE_SPARE_BIT_52_0_SECURE                      0x0
#define FUSE_SPARE_BIT_52_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_52_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_52_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_52_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_52_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_52_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_52_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_52_0_SPARE_BIT_52_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_52_0_SPARE_BIT_52_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_52_0_SPARE_BIT_52_SHIFT)
#define FUSE_SPARE_BIT_52_0_SPARE_BIT_52_RANGE                  0:0
#define FUSE_SPARE_BIT_52_0_SPARE_BIT_52_WOFFSET                        0x0
#define FUSE_SPARE_BIT_52_0_SPARE_BIT_52_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_52_0_SPARE_BIT_52_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_52_0_SPARE_BIT_52_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_52_0_SPARE_BIT_52_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_53_0  
#define FUSE_SPARE_BIT_53_0                     _MK_ADDR_CONST(0x2d4)
#define FUSE_SPARE_BIT_53_0_SECURE                      0x0
#define FUSE_SPARE_BIT_53_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_53_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_53_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_53_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_53_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_53_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_53_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_53_0_SPARE_BIT_53_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_53_0_SPARE_BIT_53_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_53_0_SPARE_BIT_53_SHIFT)
#define FUSE_SPARE_BIT_53_0_SPARE_BIT_53_RANGE                  0:0
#define FUSE_SPARE_BIT_53_0_SPARE_BIT_53_WOFFSET                        0x0
#define FUSE_SPARE_BIT_53_0_SPARE_BIT_53_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_53_0_SPARE_BIT_53_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_53_0_SPARE_BIT_53_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_53_0_SPARE_BIT_53_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_54_0  
#define FUSE_SPARE_BIT_54_0                     _MK_ADDR_CONST(0x2d8)
#define FUSE_SPARE_BIT_54_0_SECURE                      0x0
#define FUSE_SPARE_BIT_54_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_54_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_54_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_54_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_54_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_54_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_54_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_54_0_SPARE_BIT_54_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_54_0_SPARE_BIT_54_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_54_0_SPARE_BIT_54_SHIFT)
#define FUSE_SPARE_BIT_54_0_SPARE_BIT_54_RANGE                  0:0
#define FUSE_SPARE_BIT_54_0_SPARE_BIT_54_WOFFSET                        0x0
#define FUSE_SPARE_BIT_54_0_SPARE_BIT_54_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_54_0_SPARE_BIT_54_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_54_0_SPARE_BIT_54_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_54_0_SPARE_BIT_54_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_55_0  
#define FUSE_SPARE_BIT_55_0                     _MK_ADDR_CONST(0x2dc)
#define FUSE_SPARE_BIT_55_0_SECURE                      0x0
#define FUSE_SPARE_BIT_55_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_55_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_55_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_55_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_55_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_55_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_55_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_55_0_SPARE_BIT_55_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_55_0_SPARE_BIT_55_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_55_0_SPARE_BIT_55_SHIFT)
#define FUSE_SPARE_BIT_55_0_SPARE_BIT_55_RANGE                  0:0
#define FUSE_SPARE_BIT_55_0_SPARE_BIT_55_WOFFSET                        0x0
#define FUSE_SPARE_BIT_55_0_SPARE_BIT_55_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_55_0_SPARE_BIT_55_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_55_0_SPARE_BIT_55_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_55_0_SPARE_BIT_55_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_56_0  
#define FUSE_SPARE_BIT_56_0                     _MK_ADDR_CONST(0x2e0)
#define FUSE_SPARE_BIT_56_0_SECURE                      0x0
#define FUSE_SPARE_BIT_56_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_56_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_56_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_56_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_56_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_56_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_56_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_56_0_SPARE_BIT_56_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_56_0_SPARE_BIT_56_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_56_0_SPARE_BIT_56_SHIFT)
#define FUSE_SPARE_BIT_56_0_SPARE_BIT_56_RANGE                  0:0
#define FUSE_SPARE_BIT_56_0_SPARE_BIT_56_WOFFSET                        0x0
#define FUSE_SPARE_BIT_56_0_SPARE_BIT_56_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_56_0_SPARE_BIT_56_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_56_0_SPARE_BIT_56_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_56_0_SPARE_BIT_56_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_57_0  
#define FUSE_SPARE_BIT_57_0                     _MK_ADDR_CONST(0x2e4)
#define FUSE_SPARE_BIT_57_0_SECURE                      0x0
#define FUSE_SPARE_BIT_57_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_57_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_57_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_57_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_57_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_57_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_57_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_57_0_SPARE_BIT_57_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_57_0_SPARE_BIT_57_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_57_0_SPARE_BIT_57_SHIFT)
#define FUSE_SPARE_BIT_57_0_SPARE_BIT_57_RANGE                  0:0
#define FUSE_SPARE_BIT_57_0_SPARE_BIT_57_WOFFSET                        0x0
#define FUSE_SPARE_BIT_57_0_SPARE_BIT_57_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_57_0_SPARE_BIT_57_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_57_0_SPARE_BIT_57_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_57_0_SPARE_BIT_57_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_58_0  
#define FUSE_SPARE_BIT_58_0                     _MK_ADDR_CONST(0x2e8)
#define FUSE_SPARE_BIT_58_0_SECURE                      0x0
#define FUSE_SPARE_BIT_58_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_58_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_58_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_58_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_58_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_58_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_58_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_58_0_SPARE_BIT_58_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_58_0_SPARE_BIT_58_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_58_0_SPARE_BIT_58_SHIFT)
#define FUSE_SPARE_BIT_58_0_SPARE_BIT_58_RANGE                  0:0
#define FUSE_SPARE_BIT_58_0_SPARE_BIT_58_WOFFSET                        0x0
#define FUSE_SPARE_BIT_58_0_SPARE_BIT_58_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_58_0_SPARE_BIT_58_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_58_0_SPARE_BIT_58_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_58_0_SPARE_BIT_58_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_59_0  
#define FUSE_SPARE_BIT_59_0                     _MK_ADDR_CONST(0x2ec)
#define FUSE_SPARE_BIT_59_0_SECURE                      0x0
#define FUSE_SPARE_BIT_59_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_59_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_59_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_59_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_59_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_59_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_59_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_59_0_SPARE_BIT_59_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_59_0_SPARE_BIT_59_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_59_0_SPARE_BIT_59_SHIFT)
#define FUSE_SPARE_BIT_59_0_SPARE_BIT_59_RANGE                  0:0
#define FUSE_SPARE_BIT_59_0_SPARE_BIT_59_WOFFSET                        0x0
#define FUSE_SPARE_BIT_59_0_SPARE_BIT_59_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_59_0_SPARE_BIT_59_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_59_0_SPARE_BIT_59_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_59_0_SPARE_BIT_59_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_60_0  
#define FUSE_SPARE_BIT_60_0                     _MK_ADDR_CONST(0x2f0)
#define FUSE_SPARE_BIT_60_0_SECURE                      0x0
#define FUSE_SPARE_BIT_60_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_60_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_60_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_60_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_60_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_60_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_60_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_60_0_SPARE_BIT_60_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_60_0_SPARE_BIT_60_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_60_0_SPARE_BIT_60_SHIFT)
#define FUSE_SPARE_BIT_60_0_SPARE_BIT_60_RANGE                  0:0
#define FUSE_SPARE_BIT_60_0_SPARE_BIT_60_WOFFSET                        0x0
#define FUSE_SPARE_BIT_60_0_SPARE_BIT_60_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_60_0_SPARE_BIT_60_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_60_0_SPARE_BIT_60_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_60_0_SPARE_BIT_60_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_61_0  
#define FUSE_SPARE_BIT_61_0                     _MK_ADDR_CONST(0x2f4)
#define FUSE_SPARE_BIT_61_0_SECURE                      0x0
#define FUSE_SPARE_BIT_61_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_61_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_61_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_61_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_61_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_61_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_61_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_61_0_SPARE_BIT_61_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_61_0_SPARE_BIT_61_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_61_0_SPARE_BIT_61_SHIFT)
#define FUSE_SPARE_BIT_61_0_SPARE_BIT_61_RANGE                  0:0
#define FUSE_SPARE_BIT_61_0_SPARE_BIT_61_WOFFSET                        0x0
#define FUSE_SPARE_BIT_61_0_SPARE_BIT_61_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_61_0_SPARE_BIT_61_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_61_0_SPARE_BIT_61_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_61_0_SPARE_BIT_61_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_ARFUSE_REGS(_op_) \
_op_(FUSE_FUSECTRL_0) \
_op_(FUSE_FUSEADDR_0) \
_op_(FUSE_FUSERDATA_0) \
_op_(FUSE_FUSEWDATA_0) \
_op_(FUSE_FUSETIME_RD1_0) \
_op_(FUSE_FUSETIME_RD2_0) \
_op_(FUSE_FUSETIME_PGM1_0) \
_op_(FUSE_FUSETIME_PGM2_0) \
_op_(FUSE_PRIV2INTFC_START_0) \
_op_(FUSE_FUSEBYPASS_0) \
_op_(FUSE_PRIVATEKEYDISABLE_0) \
_op_(FUSE_DISABLEREGPROGRAM_0) \
_op_(FUSE_WRITE_ACCESS_SW_0) \
_op_(FUSE_PWR_GOOD_SW_0) \
_op_(FUSE_REG_REF_CTRL_0) \
_op_(FUSE_REG_BIAS_CTRL_0) \
_op_(FUSE_PRIVATE_KEY0_NONZERO_0) \
_op_(FUSE_PRIVATE_KEY1_NONZERO_0) \
_op_(FUSE_PRIVATE_KEY2_NONZERO_0) \
_op_(FUSE_PRIVATE_KEY3_NONZERO_0) \
_op_(FUSE_PRIVATE_KEY4_NONZERO_0) \
_op_(FUSE_PRODUCTION_MODE_0) \
_op_(FUSE_JTAG_SECUREID_VALID_0) \
_op_(FUSE_JTAG_SECUREID_0_0) \
_op_(FUSE_JTAG_SECUREID_1_0) \
_op_(FUSE_SKU_INFO_0) \
_op_(FUSE_PROCESS_CALIB_0) \
_op_(FUSE_IO_CALIB_0) \
_op_(FUSE_DAC_CRT_CALIB_0) \
_op_(FUSE_DAC_HDTV_CALIB_0) \
_op_(FUSE_DAC_SDTV_CALIB_0) \
_op_(FUSE_FA_0) \
_op_(FUSE_RESERVED_PRODUCTION_0) \
_op_(FUSE_HDMI_LANE0_CALIB_0) \
_op_(FUSE_HDMI_LANE1_CALIB_0) \
_op_(FUSE_HDMI_LANE2_CALIB_0) \
_op_(FUSE_HDMI_LANE3_CALIB_0) \
_op_(FUSE_SECURITY_MODE_0) \
_op_(FUSE_PRIVATE_KEY0_0) \
_op_(FUSE_PRIVATE_KEY1_0) \
_op_(FUSE_PRIVATE_KEY2_0) \
_op_(FUSE_PRIVATE_KEY3_0) \
_op_(FUSE_PRIVATE_KEY4_0) \
_op_(FUSE_ARM_DEBUG_DIS_0) \
_op_(FUSE_BOOT_DEVICE_INFO_0) \
_op_(FUSE_RESERVED_SW_0) \
_op_(FUSE_ARM_DEBUG_CONTROL_0) \
_op_(FUSE_RESERVED_ODM0_0) \
_op_(FUSE_RESERVED_ODM1_0) \
_op_(FUSE_RESERVED_ODM2_0) \
_op_(FUSE_RESERVED_ODM3_0) \
_op_(FUSE_RESERVED_ODM4_0) \
_op_(FUSE_RESERVED_ODM5_0) \
_op_(FUSE_RESERVED_ODM6_0) \
_op_(FUSE_RESERVED_ODM7_0) \
_op_(FUSE_OBS_DIS_0) \
_op_(FUSE_NOR_INFO_0) \
_op_(FUSE_USB_CALIB_0) \
_op_(FUSE_KFUSE_PRIVKEY_CTRL_0) \
_op_(FUSE_PACKAGE_INFO_0) \
_op_(FUSE_SPARE_BIT_0_0) \
_op_(FUSE_SPARE_BIT_1_0) \
_op_(FUSE_SPARE_BIT_2_0) \
_op_(FUSE_SPARE_BIT_3_0) \
_op_(FUSE_SPARE_BIT_4_0) \
_op_(FUSE_SPARE_BIT_5_0) \
_op_(FUSE_SPARE_BIT_6_0) \
_op_(FUSE_SPARE_BIT_7_0) \
_op_(FUSE_SPARE_BIT_8_0) \
_op_(FUSE_SPARE_BIT_9_0) \
_op_(FUSE_SPARE_BIT_10_0) \
_op_(FUSE_SPARE_BIT_11_0) \
_op_(FUSE_SPARE_BIT_12_0) \
_op_(FUSE_SPARE_BIT_13_0) \
_op_(FUSE_SPARE_BIT_14_0) \
_op_(FUSE_SPARE_BIT_15_0) \
_op_(FUSE_SPARE_BIT_16_0) \
_op_(FUSE_SPARE_BIT_17_0) \
_op_(FUSE_SPARE_BIT_18_0) \
_op_(FUSE_SPARE_BIT_19_0) \
_op_(FUSE_SPARE_BIT_20_0) \
_op_(FUSE_SPARE_BIT_21_0) \
_op_(FUSE_SPARE_BIT_22_0) \
_op_(FUSE_SPARE_BIT_23_0) \
_op_(FUSE_SPARE_BIT_24_0) \
_op_(FUSE_SPARE_BIT_25_0) \
_op_(FUSE_SPARE_BIT_26_0) \
_op_(FUSE_SPARE_BIT_27_0) \
_op_(FUSE_SPARE_BIT_28_0) \
_op_(FUSE_SPARE_BIT_29_0) \
_op_(FUSE_SPARE_BIT_30_0) \
_op_(FUSE_SPARE_BIT_31_0) \
_op_(FUSE_SPARE_BIT_32_0) \
_op_(FUSE_SPARE_BIT_33_0) \
_op_(FUSE_SPARE_BIT_34_0) \
_op_(FUSE_SPARE_BIT_35_0) \
_op_(FUSE_SPARE_BIT_36_0) \
_op_(FUSE_SPARE_BIT_37_0) \
_op_(FUSE_SPARE_BIT_38_0) \
_op_(FUSE_SPARE_BIT_39_0) \
_op_(FUSE_SPARE_BIT_40_0) \
_op_(FUSE_SPARE_BIT_41_0) \
_op_(FUSE_SPARE_BIT_42_0) \
_op_(FUSE_SPARE_BIT_43_0) \
_op_(FUSE_SPARE_BIT_44_0) \
_op_(FUSE_SPARE_BIT_45_0) \
_op_(FUSE_SPARE_BIT_46_0) \
_op_(FUSE_SPARE_BIT_47_0) \
_op_(FUSE_SPARE_BIT_48_0) \
_op_(FUSE_SPARE_BIT_49_0) \
_op_(FUSE_SPARE_BIT_50_0) \
_op_(FUSE_SPARE_BIT_51_0) \
_op_(FUSE_SPARE_BIT_52_0) \
_op_(FUSE_SPARE_BIT_53_0) \
_op_(FUSE_SPARE_BIT_54_0) \
_op_(FUSE_SPARE_BIT_55_0) \
_op_(FUSE_SPARE_BIT_56_0) \
_op_(FUSE_SPARE_BIT_57_0) \
_op_(FUSE_SPARE_BIT_58_0) \
_op_(FUSE_SPARE_BIT_59_0) \
_op_(FUSE_SPARE_BIT_60_0) \
_op_(FUSE_SPARE_BIT_61_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_FUSE       0x00000000

//
// ARFUSE REGISTER BANKS
//

#define FUSE0_FIRST_REG 0x0000 // FUSE_FUSECTRL_0
#define FUSE0_LAST_REG 0x0034 // FUSE_PWR_GOOD_SW_0
#define FUSE1_FIRST_REG 0x0048 // FUSE_REG_REF_CTRL_0
#define FUSE1_LAST_REG 0x0060 // FUSE_PRIVATE_KEY4_NONZERO_0
#define FUSE2_FIRST_REG 0x0100 // FUSE_PRODUCTION_MODE_0
#define FUSE2_LAST_REG 0x0124 // FUSE_DAC_SDTV_CALIB_0
#define FUSE3_FIRST_REG 0x0148 // FUSE_FA_0
#define FUSE3_LAST_REG 0x015c // FUSE_HDMI_LANE3_CALIB_0
#define FUSE4_FIRST_REG 0x01a0 // FUSE_SECURITY_MODE_0
#define FUSE4_LAST_REG 0x01f0 // FUSE_USB_CALIB_0
#define FUSE5_FIRST_REG 0x01f8 // FUSE_KFUSE_PRIVKEY_CTRL_0
#define FUSE5_LAST_REG 0x02f4 // FUSE_SPARE_BIT_61_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARFUSE_H_INC_
