/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARI2C_H_INC_
#define ___ARI2C_H_INC_

// Register I2C_I2C_CNFG_0  
#define I2C_I2C_CNFG_0                  _MK_ADDR_CONST(0x0)
#define I2C_I2C_CNFG_0_SECURE                   0x0
#define I2C_I2C_CNFG_0_WORD_COUNT                       0x1
#define I2C_I2C_CNFG_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_RESET_MASK                       _MK_MASK_CONST(0x7fff)
#define I2C_I2C_CNFG_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_READ_MASK                        _MK_MASK_CONST(0x7fff)
#define I2C_I2C_CNFG_0_WRITE_MASK                       _MK_MASK_CONST(0x7fff)
// Debounce period for sda and scl lines
// 0 = No debounce
// 1 = 2T
// 2  = 4T
// 3 =  6T etc
// where T is the period of the fix PLL 
//clk source coming to i2c.
//Maximum debounce period programmable is 
//14T.A debounce period of >50ns is desirable
#define I2C_I2C_CNFG_0_DEBOUNCE_CNT_SHIFT                       _MK_SHIFT_CONST(12)
#define I2C_I2C_CNFG_0_DEBOUNCE_CNT_FIELD                       (_MK_MASK_CONST(0x7) << I2C_I2C_CNFG_0_DEBOUNCE_CNT_SHIFT)
#define I2C_I2C_CNFG_0_DEBOUNCE_CNT_RANGE                       14:12
#define I2C_I2C_CNFG_0_DEBOUNCE_CNT_WOFFSET                     0x0
#define I2C_I2C_CNFG_0_DEBOUNCE_CNT_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_DEBOUNCE_CNT_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define I2C_I2C_CNFG_0_DEBOUNCE_CNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_DEBOUNCE_CNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Write 1 to enable new master fsm
// 0 = old fsm
#define I2C_I2C_CNFG_0_NEW_MASTER_FSM_SHIFT                     _MK_SHIFT_CONST(11)
#define I2C_I2C_CNFG_0_NEW_MASTER_FSM_FIELD                     (_MK_MASK_CONST(0x1) << I2C_I2C_CNFG_0_NEW_MASTER_FSM_SHIFT)
#define I2C_I2C_CNFG_0_NEW_MASTER_FSM_RANGE                     11:11
#define I2C_I2C_CNFG_0_NEW_MASTER_FSM_WOFFSET                   0x0
#define I2C_I2C_CNFG_0_NEW_MASTER_FSM_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_NEW_MASTER_FSM_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define I2C_I2C_CNFG_0_NEW_MASTER_FSM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_NEW_MASTER_FSM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_NEW_MASTER_FSM_DISABLE                   _MK_ENUM_CONST(0)
#define I2C_I2C_CNFG_0_NEW_MASTER_FSM_ENABLE                    _MK_ENUM_CONST(1)

// Write 1 to initiate transfer in packet mode.
#define I2C_I2C_CNFG_0_PACKET_MODE_EN_SHIFT                     _MK_SHIFT_CONST(10)
#define I2C_I2C_CNFG_0_PACKET_MODE_EN_FIELD                     (_MK_MASK_CONST(0x1) << I2C_I2C_CNFG_0_PACKET_MODE_EN_SHIFT)
#define I2C_I2C_CNFG_0_PACKET_MODE_EN_RANGE                     10:10
#define I2C_I2C_CNFG_0_PACKET_MODE_EN_WOFFSET                   0x0
#define I2C_I2C_CNFG_0_PACKET_MODE_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_PACKET_MODE_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define I2C_I2C_CNFG_0_PACKET_MODE_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_PACKET_MODE_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_PACKET_MODE_EN_NOP                       _MK_ENUM_CONST(0)
#define I2C_I2C_CNFG_0_PACKET_MODE_EN_GO                        _MK_ENUM_CONST(1)

// Writing a 1 causes the master to initiate the
// transaction in normal mode. Values of other  bits are not
// affected when this bit is 1,Cleared by 
// hardware.  Other bits of the register are
// masked for writes when this bit is programmed
// to one.hence,firware should first configure
// all other registrs and  bits [8:0] of 
// I2C_CNFG register before the bit
// I2C_CNFG[9] is programmed to Zero.
#define I2C_I2C_CNFG_0_SEND_SHIFT                       _MK_SHIFT_CONST(9)
#define I2C_I2C_CNFG_0_SEND_FIELD                       (_MK_MASK_CONST(0x1) << I2C_I2C_CNFG_0_SEND_SHIFT)
#define I2C_I2C_CNFG_0_SEND_RANGE                       9:9
#define I2C_I2C_CNFG_0_SEND_WOFFSET                     0x0
#define I2C_I2C_CNFG_0_SEND_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_SEND_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define I2C_I2C_CNFG_0_SEND_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_SEND_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_SEND_NOP                 _MK_ENUM_CONST(0)
#define I2C_I2C_CNFG_0_SEND_GO                  _MK_ENUM_CONST(1)

// Enable mode to handle devices that do not generate ACK. 
// 1 - dont look for an ack at the end of the Enable
#define I2C_I2C_CNFG_0_NOACK_SHIFT                      _MK_SHIFT_CONST(8)
#define I2C_I2C_CNFG_0_NOACK_FIELD                      (_MK_MASK_CONST(0x1) << I2C_I2C_CNFG_0_NOACK_SHIFT)
#define I2C_I2C_CNFG_0_NOACK_RANGE                      8:8
#define I2C_I2C_CNFG_0_NOACK_WOFFSET                    0x0
#define I2C_I2C_CNFG_0_NOACK_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_NOACK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define I2C_I2C_CNFG_0_NOACK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_NOACK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_NOACK_DISABLE                    _MK_ENUM_CONST(0)
#define I2C_I2C_CNFG_0_NOACK_ENABLE                     _MK_ENUM_CONST(1)

// Read/Write Command for Slave 2:
// 1 -  Read Transaction; 0 -  write Transaction.
// For a 7-bit slave address,this bit must match
// with the LSB of address byte for slave 2.
// Valid only when  bit-4 of this register is 
// set
#define I2C_I2C_CNFG_0_CMD2_SHIFT                       _MK_SHIFT_CONST(7)
#define I2C_I2C_CNFG_0_CMD2_FIELD                       (_MK_MASK_CONST(0x1) << I2C_I2C_CNFG_0_CMD2_SHIFT)
#define I2C_I2C_CNFG_0_CMD2_RANGE                       7:7
#define I2C_I2C_CNFG_0_CMD2_WOFFSET                     0x0
#define I2C_I2C_CNFG_0_CMD2_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_CMD2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define I2C_I2C_CNFG_0_CMD2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_CMD2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_CMD2_DISABLE                     _MK_ENUM_CONST(0)
#define I2C_I2C_CNFG_0_CMD2_ENABLE                      _MK_ENUM_CONST(1)

// Read/Write Command for Slave 1: 
// 1 - Read Transaction; 0 -  write Transaction.
// Command for Slave 1: For a 7-bit slave address
// this bit must match with the LSB of address 
// byte for slave1.
#define I2C_I2C_CNFG_0_CMD1_SHIFT                       _MK_SHIFT_CONST(6)
#define I2C_I2C_CNFG_0_CMD1_FIELD                       (_MK_MASK_CONST(0x1) << I2C_I2C_CNFG_0_CMD1_SHIFT)
#define I2C_I2C_CNFG_0_CMD1_RANGE                       6:6
#define I2C_I2C_CNFG_0_CMD1_WOFFSET                     0x0
#define I2C_I2C_CNFG_0_CMD1_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_CMD1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define I2C_I2C_CNFG_0_CMD1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_CMD1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_CMD1_DISABLE                     _MK_ENUM_CONST(0)
#define I2C_I2C_CNFG_0_CMD1_ENABLE                      _MK_ENUM_CONST(1)

//  1 = Yes, a Start byte needs to be  sent.
#define I2C_I2C_CNFG_0_START_SHIFT                      _MK_SHIFT_CONST(5)
#define I2C_I2C_CNFG_0_START_FIELD                      (_MK_MASK_CONST(0x1) << I2C_I2C_CNFG_0_START_SHIFT)
#define I2C_I2C_CNFG_0_START_RANGE                      5:5
#define I2C_I2C_CNFG_0_START_WOFFSET                    0x0
#define I2C_I2C_CNFG_0_START_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_START_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define I2C_I2C_CNFG_0_START_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_START_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_START_DISABLE                    _MK_ENUM_CONST(0)
#define I2C_I2C_CNFG_0_START_ENABLE                     _MK_ENUM_CONST(1)

//  1 - Enables a two slave transaction ;
//  0 = No command for Slave 2 present.
#define I2C_I2C_CNFG_0_SLV2_SHIFT                       _MK_SHIFT_CONST(4)
#define I2C_I2C_CNFG_0_SLV2_FIELD                       (_MK_MASK_CONST(0x1) << I2C_I2C_CNFG_0_SLV2_SHIFT)
#define I2C_I2C_CNFG_0_SLV2_RANGE                       4:4
#define I2C_I2C_CNFG_0_SLV2_WOFFSET                     0x0
#define I2C_I2C_CNFG_0_SLV2_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_SLV2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define I2C_I2C_CNFG_0_SLV2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_SLV2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_SLV2_DISABLE                     _MK_ENUM_CONST(0)
#define I2C_I2C_CNFG_0_SLV2_ENABLE                      _MK_ENUM_CONST(1)

// The Number of bytes to be transmitted per
// transaction 000= 1byte ... 111 = 8bytes;
// In a two slave transaction number of bytes
// should be programmed less than 011.
#define I2C_I2C_CNFG_0_LENGTH_SHIFT                     _MK_SHIFT_CONST(1)
#define I2C_I2C_CNFG_0_LENGTH_FIELD                     (_MK_MASK_CONST(0x7) << I2C_I2C_CNFG_0_LENGTH_SHIFT)
#define I2C_I2C_CNFG_0_LENGTH_RANGE                     3:1
#define I2C_I2C_CNFG_0_LENGTH_WOFFSET                   0x0
#define I2C_I2C_CNFG_0_LENGTH_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_LENGTH_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define I2C_I2C_CNFG_0_LENGTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_LENGTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Address mode defines whether a 7-bit or a 
// 10-bit slave address is programmed. 1 = 10-bit
// device address 0  = 7-bit device address  
#define I2C_I2C_CNFG_0_A_MOD_SHIFT                      _MK_SHIFT_CONST(0)
#define I2C_I2C_CNFG_0_A_MOD_FIELD                      (_MK_MASK_CONST(0x1) << I2C_I2C_CNFG_0_A_MOD_SHIFT)
#define I2C_I2C_CNFG_0_A_MOD_RANGE                      0:0
#define I2C_I2C_CNFG_0_A_MOD_WOFFSET                    0x0
#define I2C_I2C_CNFG_0_A_MOD_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_A_MOD_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define I2C_I2C_CNFG_0_A_MOD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_A_MOD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CNFG_0_A_MOD_SEVEN_BIT_DEVICE_ADDRESS                   _MK_ENUM_CONST(0)
#define I2C_I2C_CNFG_0_A_MOD_TEN_BIT_DEVICE_ADDRESS                     _MK_ENUM_CONST(1)


// Register I2C_I2C_CMD_ADDR0_0  
#define I2C_I2C_CMD_ADDR0_0                     _MK_ADDR_CONST(0x4)
#define I2C_I2C_CMD_ADDR0_0_SECURE                      0x0
#define I2C_I2C_CMD_ADDR0_0_WORD_COUNT                  0x1
#define I2C_I2C_CMD_ADDR0_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR0_0_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define I2C_I2C_CMD_ADDR0_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR0_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR0_0_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define I2C_I2C_CMD_ADDR0_0_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
// In case of 7-Bit mode address is written in the 
// I2C_CMD_ADDR0[7:1] and I2C_CMD_ADDR0[0] indicates the
// read/write transaction.I2C_CMD_ADDR0[0] bit must match 
// with the I2C_CNFG[6].
// In case of 10-Bit mode addess is written in 
// I2C_CMD_ADDR0[9:0] and I2C_CNFG[6]  indicates the 
// read/write transaction. 
#define I2C_I2C_CMD_ADDR0_0_ADDR0_SHIFT                 _MK_SHIFT_CONST(0)
#define I2C_I2C_CMD_ADDR0_0_ADDR0_FIELD                 (_MK_MASK_CONST(0x3ff) << I2C_I2C_CMD_ADDR0_0_ADDR0_SHIFT)
#define I2C_I2C_CMD_ADDR0_0_ADDR0_RANGE                 9:0
#define I2C_I2C_CMD_ADDR0_0_ADDR0_WOFFSET                       0x0
#define I2C_I2C_CMD_ADDR0_0_ADDR0_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR0_0_ADDR0_DEFAULT_MASK                  _MK_MASK_CONST(0x3ff)
#define I2C_I2C_CMD_ADDR0_0_ADDR0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR0_0_ADDR0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register I2C_I2C_CMD_ADDR1_0  
#define I2C_I2C_CMD_ADDR1_0                     _MK_ADDR_CONST(0x8)
#define I2C_I2C_CMD_ADDR1_0_SECURE                      0x0
#define I2C_I2C_CMD_ADDR1_0_WORD_COUNT                  0x1
#define I2C_I2C_CMD_ADDR1_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR1_0_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define I2C_I2C_CMD_ADDR1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR1_0_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define I2C_I2C_CMD_ADDR1_0_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
// In case of 7-Bit mode address is written in the 
// I2C_CMD_ADDR0[7:1] and I2C_CMD_ADDR0[0] indicates the 
// read/write transaction.I2C_CMD_ADDR0[0] bit must match
// with the I2C_CNFG[7].        
// In case of 10-Bit mode addess is written in 
// I2C_CMD_ADDR0[9:0] and I2C_CNFG[7] indicates the 
// read/write transaction. 
#define I2C_I2C_CMD_ADDR1_0_ADDR1_SHIFT                 _MK_SHIFT_CONST(0)
#define I2C_I2C_CMD_ADDR1_0_ADDR1_FIELD                 (_MK_MASK_CONST(0x3ff) << I2C_I2C_CMD_ADDR1_0_ADDR1_SHIFT)
#define I2C_I2C_CMD_ADDR1_0_ADDR1_RANGE                 9:0
#define I2C_I2C_CMD_ADDR1_0_ADDR1_WOFFSET                       0x0
#define I2C_I2C_CMD_ADDR1_0_ADDR1_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR1_0_ADDR1_DEFAULT_MASK                  _MK_MASK_CONST(0x3ff)
#define I2C_I2C_CMD_ADDR1_0_ADDR1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_ADDR1_0_ADDR1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register I2C_I2C_CMD_DATA1_0  
#define I2C_I2C_CMD_DATA1_0                     _MK_ADDR_CONST(0xc)
#define I2C_I2C_CMD_DATA1_0_SECURE                      0x0
#define I2C_I2C_CMD_DATA1_0_WORD_COUNT                  0x1
#define I2C_I2C_CMD_DATA1_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_CMD_DATA1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_CMD_DATA1_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// Fourth data byte to be sent/received
#define I2C_I2C_CMD_DATA1_0_DATA4_SHIFT                 _MK_SHIFT_CONST(24)
#define I2C_I2C_CMD_DATA1_0_DATA4_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_CMD_DATA1_0_DATA4_SHIFT)
#define I2C_I2C_CMD_DATA1_0_DATA4_RANGE                 31:24
#define I2C_I2C_CMD_DATA1_0_DATA4_WOFFSET                       0x0
#define I2C_I2C_CMD_DATA1_0_DATA4_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_DATA4_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_CMD_DATA1_0_DATA4_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_DATA4_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Third data byte to be sent/received
#define I2C_I2C_CMD_DATA1_0_DATA3_SHIFT                 _MK_SHIFT_CONST(16)
#define I2C_I2C_CMD_DATA1_0_DATA3_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_CMD_DATA1_0_DATA3_SHIFT)
#define I2C_I2C_CMD_DATA1_0_DATA3_RANGE                 23:16
#define I2C_I2C_CMD_DATA1_0_DATA3_WOFFSET                       0x0
#define I2C_I2C_CMD_DATA1_0_DATA3_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_DATA3_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_CMD_DATA1_0_DATA3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_DATA3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Second data byte to be sent/received
#define I2C_I2C_CMD_DATA1_0_DATA2_SHIFT                 _MK_SHIFT_CONST(8)
#define I2C_I2C_CMD_DATA1_0_DATA2_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_CMD_DATA1_0_DATA2_SHIFT)
#define I2C_I2C_CMD_DATA1_0_DATA2_RANGE                 15:8
#define I2C_I2C_CMD_DATA1_0_DATA2_WOFFSET                       0x0
#define I2C_I2C_CMD_DATA1_0_DATA2_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_DATA2_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_CMD_DATA1_0_DATA2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_DATA2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This register contains the first data byte to be  sent/received.
#define I2C_I2C_CMD_DATA1_0_DATA1_SHIFT                 _MK_SHIFT_CONST(0)
#define I2C_I2C_CMD_DATA1_0_DATA1_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_CMD_DATA1_0_DATA1_SHIFT)
#define I2C_I2C_CMD_DATA1_0_DATA1_RANGE                 7:0
#define I2C_I2C_CMD_DATA1_0_DATA1_WOFFSET                       0x0
#define I2C_I2C_CMD_DATA1_0_DATA1_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_DATA1_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_CMD_DATA1_0_DATA1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA1_0_DATA1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register I2C_I2C_CMD_DATA2_0  
#define I2C_I2C_CMD_DATA2_0                     _MK_ADDR_CONST(0x10)
#define I2C_I2C_CMD_DATA2_0_SECURE                      0x0
#define I2C_I2C_CMD_DATA2_0_WORD_COUNT                  0x1
#define I2C_I2C_CMD_DATA2_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_CMD_DATA2_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_CMD_DATA2_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// Eighth data byte to be sent/received
#define I2C_I2C_CMD_DATA2_0_DATA8_SHIFT                 _MK_SHIFT_CONST(24)
#define I2C_I2C_CMD_DATA2_0_DATA8_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_CMD_DATA2_0_DATA8_SHIFT)
#define I2C_I2C_CMD_DATA2_0_DATA8_RANGE                 31:24
#define I2C_I2C_CMD_DATA2_0_DATA8_WOFFSET                       0x0
#define I2C_I2C_CMD_DATA2_0_DATA8_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_DATA8_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_CMD_DATA2_0_DATA8_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_DATA8_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Seventh data byte to be sent/received
#define I2C_I2C_CMD_DATA2_0_DATA7_SHIFT                 _MK_SHIFT_CONST(16)
#define I2C_I2C_CMD_DATA2_0_DATA7_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_CMD_DATA2_0_DATA7_SHIFT)
#define I2C_I2C_CMD_DATA2_0_DATA7_RANGE                 23:16
#define I2C_I2C_CMD_DATA2_0_DATA7_WOFFSET                       0x0
#define I2C_I2C_CMD_DATA2_0_DATA7_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_DATA7_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_CMD_DATA2_0_DATA7_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_DATA7_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Sixth data byte to be sent/received
#define I2C_I2C_CMD_DATA2_0_DATA6_SHIFT                 _MK_SHIFT_CONST(8)
#define I2C_I2C_CMD_DATA2_0_DATA6_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_CMD_DATA2_0_DATA6_SHIFT)
#define I2C_I2C_CMD_DATA2_0_DATA6_RANGE                 15:8
#define I2C_I2C_CMD_DATA2_0_DATA6_WOFFSET                       0x0
#define I2C_I2C_CMD_DATA2_0_DATA6_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_DATA6_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_CMD_DATA2_0_DATA6_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_DATA6_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This register contains the Fifth data byte to be  sent/received.
#define I2C_I2C_CMD_DATA2_0_DATA5_SHIFT                 _MK_SHIFT_CONST(0)
#define I2C_I2C_CMD_DATA2_0_DATA5_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_CMD_DATA2_0_DATA5_SHIFT)
#define I2C_I2C_CMD_DATA2_0_DATA5_RANGE                 7:0
#define I2C_I2C_CMD_DATA2_0_DATA5_WOFFSET                       0x0
#define I2C_I2C_CMD_DATA2_0_DATA5_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_DATA5_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_CMD_DATA2_0_DATA5_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_CMD_DATA2_0_DATA5_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 20 [0x14] 

// Reserved address 24 [0x18] 

// Register I2C_I2C_STATUS_0  
#define I2C_I2C_STATUS_0                        _MK_ADDR_CONST(0x1c)
#define I2C_I2C_STATUS_0_SECURE                         0x0
#define I2C_I2C_STATUS_0_WORD_COUNT                     0x1
#define I2C_I2C_STATUS_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_RESET_MASK                     _MK_MASK_CONST(0x1ff)
#define I2C_I2C_STATUS_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_READ_MASK                      _MK_MASK_CONST(0x1ff)
#define I2C_I2C_STATUS_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
//  1 = Busy.
#define I2C_I2C_STATUS_0_BUSY_SHIFT                     _MK_SHIFT_CONST(8)
#define I2C_I2C_STATUS_0_BUSY_FIELD                     (_MK_MASK_CONST(0x1) << I2C_I2C_STATUS_0_BUSY_SHIFT)
#define I2C_I2C_STATUS_0_BUSY_RANGE                     8:8
#define I2C_I2C_STATUS_0_BUSY_WOFFSET                   0x0
#define I2C_I2C_STATUS_0_BUSY_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_BUSY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define I2C_I2C_STATUS_0_BUSY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_BUSY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_BUSY_NOT_BUSY                  _MK_ENUM_CONST(0)
#define I2C_I2C_STATUS_0_BUSY_BUSY                      _MK_ENUM_CONST(1)

// Transaction for Slave2 for x byte failed. x is 'h0 to 'ha.
// all others invalid 
#define I2C_I2C_STATUS_0_CMD2_STAT_SHIFT                        _MK_SHIFT_CONST(4)
#define I2C_I2C_STATUS_0_CMD2_STAT_FIELD                        (_MK_MASK_CONST(0xf) << I2C_I2C_STATUS_0_CMD2_STAT_SHIFT)
#define I2C_I2C_STATUS_0_CMD2_STAT_RANGE                        7:4
#define I2C_I2C_STATUS_0_CMD2_STAT_WOFFSET                      0x0
#define I2C_I2C_STATUS_0_CMD2_STAT_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_CMD2_STAT_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define I2C_I2C_STATUS_0_CMD2_STAT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_CMD2_STAT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_XFER_SUCCESSFUL                  _MK_ENUM_CONST(0)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE1                  _MK_ENUM_CONST(1)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE2                  _MK_ENUM_CONST(2)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE3                  _MK_ENUM_CONST(3)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE4                  _MK_ENUM_CONST(4)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE5                  _MK_ENUM_CONST(5)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE6                  _MK_ENUM_CONST(6)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE7                  _MK_ENUM_CONST(7)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE8                  _MK_ENUM_CONST(8)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE9                  _MK_ENUM_CONST(9)
#define I2C_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE10                 _MK_ENUM_CONST(10)

// Transaction for Slave1 for x byte failed. x is 'h0 to 'ha.
// all others invalid
#define I2C_I2C_STATUS_0_CMD1_STAT_SHIFT                        _MK_SHIFT_CONST(0)
#define I2C_I2C_STATUS_0_CMD1_STAT_FIELD                        (_MK_MASK_CONST(0xf) << I2C_I2C_STATUS_0_CMD1_STAT_SHIFT)
#define I2C_I2C_STATUS_0_CMD1_STAT_RANGE                        3:0
#define I2C_I2C_STATUS_0_CMD1_STAT_WOFFSET                      0x0
#define I2C_I2C_STATUS_0_CMD1_STAT_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_CMD1_STAT_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define I2C_I2C_STATUS_0_CMD1_STAT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_CMD1_STAT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_XFER_SUCCESSFUL                  _MK_ENUM_CONST(0)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE1                  _MK_ENUM_CONST(1)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE2                  _MK_ENUM_CONST(2)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE3                  _MK_ENUM_CONST(3)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE4                  _MK_ENUM_CONST(4)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE5                  _MK_ENUM_CONST(5)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE6                  _MK_ENUM_CONST(6)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE7                  _MK_ENUM_CONST(7)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE8                  _MK_ENUM_CONST(8)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE9                  _MK_ENUM_CONST(9)
#define I2C_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE10                 _MK_ENUM_CONST(10)


// Register I2C_I2C_SL_CNFG_0  
#define I2C_I2C_SL_CNFG_0                       _MK_ADDR_CONST(0x20)
#define I2C_I2C_SL_CNFG_0_SECURE                        0x0
#define I2C_I2C_SL_CNFG_0_WORD_COUNT                    0x1
#define I2C_I2C_SL_CNFG_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_RESET_MASK                    _MK_MASK_CONST(0x7)
#define I2C_I2C_SL_CNFG_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_READ_MASK                     _MK_MASK_CONST(0x7)
#define I2C_I2C_SL_CNFG_0_WRITE_MASK                    _MK_MASK_CONST(0x7)
// New Slave
// 1 - use new slave
#define I2C_I2C_SL_CNFG_0_NEWSL_SHIFT                   _MK_SHIFT_CONST(2)
#define I2C_I2C_SL_CNFG_0_NEWSL_FIELD                   (_MK_MASK_CONST(0x1) << I2C_I2C_SL_CNFG_0_NEWSL_SHIFT)
#define I2C_I2C_SL_CNFG_0_NEWSL_RANGE                   2:2
#define I2C_I2C_SL_CNFG_0_NEWSL_WOFFSET                 0x0
#define I2C_I2C_SL_CNFG_0_NEWSL_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_NEWSL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_CNFG_0_NEWSL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_NEWSL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_NEWSL_DISABLE                 _MK_ENUM_CONST(0)
#define I2C_I2C_SL_CNFG_0_NEWSL_ENABLE                  _MK_ENUM_CONST(1)

// Disable Slave Ack. 
// 1 - slave will not ack reception of address or data byte. 
#define I2C_I2C_SL_CNFG_0_NACK_SHIFT                    _MK_SHIFT_CONST(1)
#define I2C_I2C_SL_CNFG_0_NACK_FIELD                    (_MK_MASK_CONST(0x1) << I2C_I2C_SL_CNFG_0_NACK_SHIFT)
#define I2C_I2C_SL_CNFG_0_NACK_RANGE                    1:1
#define I2C_I2C_SL_CNFG_0_NACK_WOFFSET                  0x0
#define I2C_I2C_SL_CNFG_0_NACK_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_NACK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_CNFG_0_NACK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_NACK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_NACK_DISABLE                  _MK_ENUM_CONST(0)
#define I2C_I2C_SL_CNFG_0_NACK_ENABLE                   _MK_ENUM_CONST(1)

// Slave response to general call address (zero address) 
// 1 - Enable.
#define I2C_I2C_SL_CNFG_0_RESP_SHIFT                    _MK_SHIFT_CONST(0)
#define I2C_I2C_SL_CNFG_0_RESP_FIELD                    (_MK_MASK_CONST(0x1) << I2C_I2C_SL_CNFG_0_RESP_SHIFT)
#define I2C_I2C_SL_CNFG_0_RESP_RANGE                    0:0
#define I2C_I2C_SL_CNFG_0_RESP_WOFFSET                  0x0
#define I2C_I2C_SL_CNFG_0_RESP_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_RESP_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_CNFG_0_RESP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_RESP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_CNFG_0_RESP_DISABLE                  _MK_ENUM_CONST(0)
#define I2C_I2C_SL_CNFG_0_RESP_ENABLE                   _MK_ENUM_CONST(1)


// Register I2C_I2C_SL_RCVD_0  
#define I2C_I2C_SL_RCVD_0                       _MK_ADDR_CONST(0x24)
#define I2C_I2C_SL_RCVD_0_SECURE                        0x0
#define I2C_I2C_SL_RCVD_0_WORD_COUNT                    0x1
#define I2C_I2C_SL_RCVD_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_RCVD_0_RESET_MASK                    _MK_MASK_CONST(0xff)
#define I2C_I2C_SL_RCVD_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_RCVD_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_RCVD_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define I2C_I2C_SL_RCVD_0_WRITE_MASK                    _MK_MASK_CONST(0xff)
//slave Received data 
#define I2C_I2C_SL_RCVD_0_SL_DATA_SHIFT                 _MK_SHIFT_CONST(0)
#define I2C_I2C_SL_RCVD_0_SL_DATA_FIELD                 (_MK_MASK_CONST(0xff) << I2C_I2C_SL_RCVD_0_SL_DATA_SHIFT)
#define I2C_I2C_SL_RCVD_0_SL_DATA_RANGE                 7:0
#define I2C_I2C_SL_RCVD_0_SL_DATA_WOFFSET                       0x0
#define I2C_I2C_SL_RCVD_0_SL_DATA_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_RCVD_0_SL_DATA_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define I2C_I2C_SL_RCVD_0_SL_DATA_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_RCVD_0_SL_DATA_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register I2C_I2C_SL_STATUS_0  
#define I2C_I2C_SL_STATUS_0                     _MK_ADDR_CONST(0x28)
#define I2C_I2C_SL_STATUS_0_SECURE                      0x0
#define I2C_I2C_SL_STATUS_0_WORD_COUNT                  0x1
#define I2C_I2C_SL_STATUS_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_RESET_MASK                  _MK_MASK_CONST(0x7fff)
#define I2C_I2C_SL_STATUS_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_READ_MASK                   _MK_MASK_CONST(0x7fff)
#define I2C_I2C_SL_STATUS_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
//  HW master addr received via general call addressing.
//  This field is meaningful only if HW_MSTR_INT is set.
#define I2C_I2C_SL_STATUS_0_HW_MSTR_ADR_SHIFT                   _MK_SHIFT_CONST(8)
#define I2C_I2C_SL_STATUS_0_HW_MSTR_ADR_FIELD                   (_MK_MASK_CONST(0x7f) << I2C_I2C_SL_STATUS_0_HW_MSTR_ADR_SHIFT)
#define I2C_I2C_SL_STATUS_0_HW_MSTR_ADR_RANGE                   14:8
#define I2C_I2C_SL_STATUS_0_HW_MSTR_ADR_WOFFSET                 0x0
#define I2C_I2C_SL_STATUS_0_HW_MSTR_ADR_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_HW_MSTR_ADR_DEFAULT_MASK                    _MK_MASK_CONST(0x7f)
#define I2C_I2C_SL_STATUS_0_HW_MSTR_ADR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_HW_MSTR_ADR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//  1 = Interrupt has been generated by  slave  
//  Hardware Master Address is received after
//  General Call Address.
//  1 = Received HW Master Address
//  0 = No event.
#define I2C_I2C_SL_STATUS_0_HW_MSTR_INT_SHIFT                   _MK_SHIFT_CONST(7)
#define I2C_I2C_SL_STATUS_0_HW_MSTR_INT_FIELD                   (_MK_MASK_CONST(0x1) << I2C_I2C_SL_STATUS_0_HW_MSTR_INT_SHIFT)
#define I2C_I2C_SL_STATUS_0_HW_MSTR_INT_RANGE                   7:7
#define I2C_I2C_SL_STATUS_0_HW_MSTR_INT_WOFFSET                 0x0
#define I2C_I2C_SL_STATUS_0_HW_MSTR_INT_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_HW_MSTR_INT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_STATUS_0_HW_MSTR_INT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_HW_MSTR_INT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//  1 = Interrupt has been generated by  slave  
//  By after General Call Address is 0x04.
//  1 = Reprogram slave address.
//  0 = No action.
#define I2C_I2C_SL_STATUS_0_REPROG_SL_SHIFT                     _MK_SHIFT_CONST(6)
#define I2C_I2C_SL_STATUS_0_REPROG_SL_FIELD                     (_MK_MASK_CONST(0x1) << I2C_I2C_SL_STATUS_0_REPROG_SL_SHIFT)
#define I2C_I2C_SL_STATUS_0_REPROG_SL_RANGE                     6:6
#define I2C_I2C_SL_STATUS_0_REPROG_SL_WOFFSET                   0x0
#define I2C_I2C_SL_STATUS_0_REPROG_SL_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_REPROG_SL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_STATUS_0_REPROG_SL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_REPROG_SL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//  1 = Interrupt has been generated by  slave  
//  By after General Call Address is 0x06.
//  1 = Reset and reprogram slave address.
//  0 = No action.
#define I2C_I2C_SL_STATUS_0_RST_SL_SHIFT                        _MK_SHIFT_CONST(5)
#define I2C_I2C_SL_STATUS_0_RST_SL_FIELD                        (_MK_MASK_CONST(0x1) << I2C_I2C_SL_STATUS_0_RST_SL_SHIFT)
#define I2C_I2C_SL_STATUS_0_RST_SL_RANGE                        5:5
#define I2C_I2C_SL_STATUS_0_RST_SL_WOFFSET                      0x0
#define I2C_I2C_SL_STATUS_0_RST_SL_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_RST_SL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_STATUS_0_RST_SL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_RST_SL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//  1 = Interrupt has been generated by  slave  
//  Transaction completed as indicated by stop/repeat start condition.
//  1 = Transaction completed.
//  0 = No transaction occurred  or transaction in progress.
#define I2C_I2C_SL_STATUS_0_END_TRANS_SHIFT                     _MK_SHIFT_CONST(4)
#define I2C_I2C_SL_STATUS_0_END_TRANS_FIELD                     (_MK_MASK_CONST(0x1) << I2C_I2C_SL_STATUS_0_END_TRANS_SHIFT)
#define I2C_I2C_SL_STATUS_0_END_TRANS_RANGE                     4:4
#define I2C_I2C_SL_STATUS_0_END_TRANS_WOFFSET                   0x0
#define I2C_I2C_SL_STATUS_0_END_TRANS_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_END_TRANS_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_STATUS_0_END_TRANS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_END_TRANS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//  1 = Interrupt has been generated by  slave  
//  0 = No interrupt generated  
#define I2C_I2C_SL_STATUS_0_SL_IRQ_SHIFT                        _MK_SHIFT_CONST(3)
#define I2C_I2C_SL_STATUS_0_SL_IRQ_FIELD                        (_MK_MASK_CONST(0x1) << I2C_I2C_SL_STATUS_0_SL_IRQ_SHIFT)
#define I2C_I2C_SL_STATUS_0_SL_IRQ_RANGE                        3:3
#define I2C_I2C_SL_STATUS_0_SL_IRQ_WOFFSET                      0x0
#define I2C_I2C_SL_STATUS_0_SL_IRQ_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_SL_IRQ_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_STATUS_0_SL_IRQ_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_SL_IRQ_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_SL_IRQ_UNSET                        _MK_ENUM_CONST(0)
#define I2C_I2C_SL_STATUS_0_SL_IRQ_SET                  _MK_ENUM_CONST(1)

//  New Transaction Receieved status
//  1 = Transaction occurred. 
//  0  = No transaction occurred 
#define I2C_I2C_SL_STATUS_0_RCVD_SHIFT                  _MK_SHIFT_CONST(2)
#define I2C_I2C_SL_STATUS_0_RCVD_FIELD                  (_MK_MASK_CONST(0x1) << I2C_I2C_SL_STATUS_0_RCVD_SHIFT)
#define I2C_I2C_SL_STATUS_0_RCVD_RANGE                  2:2
#define I2C_I2C_SL_STATUS_0_RCVD_WOFFSET                        0x0
#define I2C_I2C_SL_STATUS_0_RCVD_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_RCVD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_STATUS_0_RCVD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_RCVD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_RCVD_NO_TRANSACTION_OCCURED                 _MK_ENUM_CONST(0)
#define I2C_I2C_SL_STATUS_0_RCVD_TRANSACTION_OCCURED                    _MK_ENUM_CONST(1)

//  Slave Transaction status 
//  0 = Write
//  1=Read
#define I2C_I2C_SL_STATUS_0_RNW_SHIFT                   _MK_SHIFT_CONST(1)
#define I2C_I2C_SL_STATUS_0_RNW_FIELD                   (_MK_MASK_CONST(0x1) << I2C_I2C_SL_STATUS_0_RNW_SHIFT)
#define I2C_I2C_SL_STATUS_0_RNW_RANGE                   1:1
#define I2C_I2C_SL_STATUS_0_RNW_WOFFSET                 0x0
#define I2C_I2C_SL_STATUS_0_RNW_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_RNW_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_STATUS_0_RNW_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_RNW_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_RNW_WRITE                   _MK_ENUM_CONST(0)
#define I2C_I2C_SL_STATUS_0_RNW_READ                    _MK_ENUM_CONST(1)

//  Zero Address Status
//  1 = Yes, slave responded  
//  0  = No, slave did not respond
#define I2C_I2C_SL_STATUS_0_ZA_SHIFT                    _MK_SHIFT_CONST(0)
#define I2C_I2C_SL_STATUS_0_ZA_FIELD                    (_MK_MASK_CONST(0x1) << I2C_I2C_SL_STATUS_0_ZA_SHIFT)
#define I2C_I2C_SL_STATUS_0_ZA_RANGE                    0:0
#define I2C_I2C_SL_STATUS_0_ZA_WOFFSET                  0x0
#define I2C_I2C_SL_STATUS_0_ZA_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_ZA_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_STATUS_0_ZA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_ZA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_STATUS_0_ZA_NO_SLAVE_RESPONSE                        _MK_ENUM_CONST(0)
#define I2C_I2C_SL_STATUS_0_ZA_SLAVE_RESPONSE                   _MK_ENUM_CONST(1)


// Register I2C_I2C_SL_ADDR1_0  
#define I2C_I2C_SL_ADDR1_0                      _MK_ADDR_CONST(0x2c)
#define I2C_I2C_SL_ADDR1_0_SECURE                       0x0
#define I2C_I2C_SL_ADDR1_0_WORD_COUNT                   0x1
#define I2C_I2C_SL_ADDR1_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR1_0_RESET_MASK                   _MK_MASK_CONST(0xff)
#define I2C_I2C_SL_ADDR1_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR1_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR1_0_READ_MASK                    _MK_MASK_CONST(0xff)
#define I2C_I2C_SL_ADDR1_0_WRITE_MASK                   _MK_MASK_CONST(0xff)
//   For a 10-bit slave address, this field is the least significant 8 bits. 
#define I2C_I2C_SL_ADDR1_0_SL_ADDR0_SHIFT                       _MK_SHIFT_CONST(0)
#define I2C_I2C_SL_ADDR1_0_SL_ADDR0_FIELD                       (_MK_MASK_CONST(0xff) << I2C_I2C_SL_ADDR1_0_SL_ADDR0_SHIFT)
#define I2C_I2C_SL_ADDR1_0_SL_ADDR0_RANGE                       7:0
#define I2C_I2C_SL_ADDR1_0_SL_ADDR0_WOFFSET                     0x0
#define I2C_I2C_SL_ADDR1_0_SL_ADDR0_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR1_0_SL_ADDR0_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define I2C_I2C_SL_ADDR1_0_SL_ADDR0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR1_0_SL_ADDR0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register I2C_I2C_SL_ADDR2_0  
#define I2C_I2C_SL_ADDR2_0                      _MK_ADDR_CONST(0x30)
#define I2C_I2C_SL_ADDR2_0_SECURE                       0x0
#define I2C_I2C_SL_ADDR2_0_WORD_COUNT                   0x1
#define I2C_I2C_SL_ADDR2_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_RESET_MASK                   _MK_MASK_CONST(0x7)
#define I2C_I2C_SL_ADDR2_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_READ_MASK                    _MK_MASK_CONST(0x7)
#define I2C_I2C_SL_ADDR2_0_WRITE_MASK                   _MK_MASK_CONST(0x7)
// In 7 bit address mode these bits are dont care;
// In 10 bit address mode they represent the 2 MSB of the address.
#define I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_SHIFT                     _MK_SHIFT_CONST(1)
#define I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_FIELD                     (_MK_MASK_CONST(0x3) << I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_SHIFT)
#define I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_RANGE                     2:1
#define I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_WOFFSET                   0x0
#define I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_SL_ADDR_HI_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// 0 = 7-bit addressing.
// 1 - 10 bit addressing.  
#define I2C_I2C_SL_ADDR2_0_VLD_SHIFT                    _MK_SHIFT_CONST(0)
#define I2C_I2C_SL_ADDR2_0_VLD_FIELD                    (_MK_MASK_CONST(0x1) << I2C_I2C_SL_ADDR2_0_VLD_SHIFT)
#define I2C_I2C_SL_ADDR2_0_VLD_RANGE                    0:0
#define I2C_I2C_SL_ADDR2_0_VLD_WOFFSET                  0x0
#define I2C_I2C_SL_ADDR2_0_VLD_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_VLD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define I2C_I2C_SL_ADDR2_0_VLD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_VLD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_ADDR2_0_VLD_SEVEN_BIT_ADDR_MODE                      _MK_ENUM_CONST(0)
#define I2C_I2C_SL_ADDR2_0_VLD_TEN_BIT_ADDR_MODE                        _MK_ENUM_CONST(1)


// Reserved address 52 [0x34] 

// Reserved address 56 [0x38] 

// Register I2C_I2C_SL_DELAY_COUNT_0  
#define I2C_I2C_SL_DELAY_COUNT_0                        _MK_ADDR_CONST(0x3c)
#define I2C_I2C_SL_DELAY_COUNT_0_SECURE                         0x0
#define I2C_I2C_SL_DELAY_COUNT_0_WORD_COUNT                     0x1
#define I2C_I2C_SL_DELAY_COUNT_0_RESET_VAL                      _MK_MASK_CONST(0x1e)
#define I2C_I2C_SL_DELAY_COUNT_0_RESET_MASK                     _MK_MASK_CONST(0xffff)
#define I2C_I2C_SL_DELAY_COUNT_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_DELAY_COUNT_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_DELAY_COUNT_0_READ_MASK                      _MK_MASK_CONST(0xffff)
#define I2C_I2C_SL_DELAY_COUNT_0_WRITE_MASK                     _MK_MASK_CONST(0xffff)
// The value determines the timing  between an address 
// cycle and a subsequent data cycle or two consecutive 
// data  cycles on the bus.The I2C_SL_DELAY_COUNT is valid
// only when internal slave is accessed.
// I2C_SL_DELAY_COUNT has to be programmed such that 
// TIMING = T * DLY where T is period of clock source
// selected for I2c; and DLY is I2C_SL_DELAY_COUNT ;
// TIMING is the desired timing, A value of >= 1250 ns is
// advisable.
#define I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_SHIFT                   _MK_SHIFT_CONST(0)
#define I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_FIELD                   (_MK_MASK_CONST(0xffff) << I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_SHIFT)
#define I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_RANGE                   15:0
#define I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_WOFFSET                 0x0
#define I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_DEFAULT                 _MK_MASK_CONST(0x1e)
#define I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_DEFAULT_MASK                    _MK_MASK_CONST(0xffff)
#define I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_SL_DELAY_COUNT_0_SL_DELAY_COUNT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Reserved address 64 [0x40] 

// Reserved address 68 [0x44] 

// Reserved address 72 [0x48] 

// Reserved address 76 [0x4c] 

// Packet I2C_IO_PACKET_HEADER_0
#define I2C_IO_PACKET_HEADER_0_SIZE 32

#define I2C_IO_PACKET_HEADER_0_RESERVED0_3_SHIFT                        _MK_SHIFT_CONST(30)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_3_FIELD                        (_MK_MASK_CONST(0x3) << I2C_IO_PACKET_HEADER_0_RESERVED0_3_SHIFT)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_3_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(30)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_3_ROW                  0

#define I2C_IO_PACKET_HEADER_0_HDRSZ_SHIFT                      _MK_SHIFT_CONST(28)
#define I2C_IO_PACKET_HEADER_0_HDRSZ_FIELD                      (_MK_MASK_CONST(0x3) << I2C_IO_PACKET_HEADER_0_HDRSZ_SHIFT)
#define I2C_IO_PACKET_HEADER_0_HDRSZ_RANGE                      _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(28)
#define I2C_IO_PACKET_HEADER_0_HDRSZ_ROW                        0
#define I2C_IO_PACKET_HEADER_0_HDRSZ_ONE                        _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_HDRSZ_TWO                        _MK_ENUM_CONST(1)
#define I2C_IO_PACKET_HEADER_0_HDRSZ_THREE                      _MK_ENUM_CONST(2)
#define I2C_IO_PACKET_HEADER_0_HDRSZ_FOUR                       _MK_ENUM_CONST(3)

#define I2C_IO_PACKET_HEADER_0_RESERVED0_2_SHIFT                        _MK_SHIFT_CONST(24)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_2_FIELD                        (_MK_MASK_CONST(0xf) << I2C_IO_PACKET_HEADER_0_RESERVED0_2_SHIFT)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_2_RANGE                        _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(24)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_2_ROW                  0

#define I2C_IO_PACKET_HEADER_0_PKTID_SHIFT                      _MK_SHIFT_CONST(16)
#define I2C_IO_PACKET_HEADER_0_PKTID_FIELD                      (_MK_MASK_CONST(0xff) << I2C_IO_PACKET_HEADER_0_PKTID_SHIFT)
#define I2C_IO_PACKET_HEADER_0_PKTID_RANGE                      _MK_SHIFT_CONST(23):_MK_SHIFT_CONST(16)
#define I2C_IO_PACKET_HEADER_0_PKTID_ROW                        0

#define I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_SHIFT                      _MK_SHIFT_CONST(12)
#define I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_FIELD                      (_MK_MASK_CONST(0xf) << I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_SHIFT)
#define I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_RANGE                      _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(12)
#define I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_ROW                        0
#define I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_I2C1                       _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_I2C2                       _MK_ENUM_CONST(1)
#define I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_I2C3                       _MK_ENUM_CONST(2)
#define I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_DVC_I2C                    _MK_ENUM_CONST(3)

#define I2C_IO_PACKET_HEADER_0_RESERVED0_1_SHIFT                        _MK_SHIFT_CONST(8)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_1_FIELD                        (_MK_MASK_CONST(0xf) << I2C_IO_PACKET_HEADER_0_RESERVED0_1_SHIFT)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_1_RANGE                        _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(8)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_1_ROW                  0

#define I2C_IO_PACKET_HEADER_0_PROTOCOL_SHIFT                   _MK_SHIFT_CONST(4)
#define I2C_IO_PACKET_HEADER_0_PROTOCOL_FIELD                   (_MK_MASK_CONST(0xf) << I2C_IO_PACKET_HEADER_0_PROTOCOL_SHIFT)
#define I2C_IO_PACKET_HEADER_0_PROTOCOL_RANGE                   _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(4)
#define I2C_IO_PACKET_HEADER_0_PROTOCOL_ROW                     0
#define I2C_IO_PACKET_HEADER_0_PROTOCOL_RESERVED                        _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_PROTOCOL_I2C                     _MK_ENUM_CONST(1)

#define I2C_IO_PACKET_HEADER_0_RESERVED0_0_SHIFT                        _MK_SHIFT_CONST(3)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_0_FIELD                        (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_RESERVED0_0_SHIFT)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_0_RANGE                        _MK_SHIFT_CONST(3):_MK_SHIFT_CONST(3)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_0_ROW                  0

#define I2C_IO_PACKET_HEADER_0_PKTTYPE_SHIFT                    _MK_SHIFT_CONST(0)
#define I2C_IO_PACKET_HEADER_0_PKTTYPE_FIELD                    (_MK_MASK_CONST(0x7) << I2C_IO_PACKET_HEADER_0_PKTTYPE_SHIFT)
#define I2C_IO_PACKET_HEADER_0_PKTTYPE_RANGE                    _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(0)
#define I2C_IO_PACKET_HEADER_0_PKTTYPE_ROW                      0

#define I2C_IO_PACKET_HEADER_0_RESERVED1_0_SHIFT                        _MK_SHIFT_CONST(12)
#define I2C_IO_PACKET_HEADER_0_RESERVED1_0_FIELD                        (_MK_MASK_CONST(0xfffff) << I2C_IO_PACKET_HEADER_0_RESERVED1_0_SHIFT)
#define I2C_IO_PACKET_HEADER_0_RESERVED1_0_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define I2C_IO_PACKET_HEADER_0_RESERVED1_0_ROW                  1

#define I2C_IO_PACKET_HEADER_0_PAYLOADSIZE_SHIFT                        _MK_SHIFT_CONST(0)
#define I2C_IO_PACKET_HEADER_0_PAYLOADSIZE_FIELD                        (_MK_MASK_CONST(0xfff) << I2C_IO_PACKET_HEADER_0_PAYLOADSIZE_SHIFT)
#define I2C_IO_PACKET_HEADER_0_PAYLOADSIZE_RANGE                        _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define I2C_IO_PACKET_HEADER_0_PAYLOADSIZE_ROW                  1

#define I2C_IO_PACKET_HEADER_0_RESERVED2_0_SHIFT                        _MK_SHIFT_CONST(23)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_0_FIELD                        (_MK_MASK_CONST(0x1ff) << I2C_IO_PACKET_HEADER_0_RESERVED2_0_SHIFT)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_0_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(23)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_0_ROW                  2

#define I2C_IO_PACKET_HEADER_0_HS_MODE_SHIFT                    _MK_SHIFT_CONST(22)
#define I2C_IO_PACKET_HEADER_0_HS_MODE_FIELD                    (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_HS_MODE_SHIFT)
#define I2C_IO_PACKET_HEADER_0_HS_MODE_RANGE                    _MK_SHIFT_CONST(22):_MK_SHIFT_CONST(22)
#define I2C_IO_PACKET_HEADER_0_HS_MODE_ROW                      2
#define I2C_IO_PACKET_HEADER_0_HS_MODE_DISABLE                  _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_HS_MODE_ENABLE                   _MK_ENUM_CONST(1)

#define I2C_IO_PACKET_HEADER_0_CONTUNE_ON_NACK_SHIFT                    _MK_SHIFT_CONST(21)
#define I2C_IO_PACKET_HEADER_0_CONTUNE_ON_NACK_FIELD                    (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_CONTUNE_ON_NACK_SHIFT)
#define I2C_IO_PACKET_HEADER_0_CONTUNE_ON_NACK_RANGE                    _MK_SHIFT_CONST(21):_MK_SHIFT_CONST(21)
#define I2C_IO_PACKET_HEADER_0_CONTUNE_ON_NACK_ROW                      2
#define I2C_IO_PACKET_HEADER_0_CONTUNE_ON_NACK_DISABLE                  _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_CONTUNE_ON_NACK_ENABLE                   _MK_ENUM_CONST(1)

#define I2C_IO_PACKET_HEADER_0_SEND_START_BYTE_SHIFT                    _MK_SHIFT_CONST(20)
#define I2C_IO_PACKET_HEADER_0_SEND_START_BYTE_FIELD                    (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_SEND_START_BYTE_SHIFT)
#define I2C_IO_PACKET_HEADER_0_SEND_START_BYTE_RANGE                    _MK_SHIFT_CONST(20):_MK_SHIFT_CONST(20)
#define I2C_IO_PACKET_HEADER_0_SEND_START_BYTE_ROW                      2
#define I2C_IO_PACKET_HEADER_0_SEND_START_BYTE_DISABLE                  _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_SEND_START_BYTE_ENABLE                   _MK_ENUM_CONST(1)

#define I2C_IO_PACKET_HEADER_0_READ_SHIFT                       _MK_SHIFT_CONST(19)
#define I2C_IO_PACKET_HEADER_0_READ_FIELD                       (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_READ_SHIFT)
#define I2C_IO_PACKET_HEADER_0_READ_RANGE                       _MK_SHIFT_CONST(19):_MK_SHIFT_CONST(19)
#define I2C_IO_PACKET_HEADER_0_READ_ROW                 2
#define I2C_IO_PACKET_HEADER_0_READ_WRITE                       _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_READ_READ                        _MK_ENUM_CONST(1)

#define I2C_IO_PACKET_HEADER_0_ADDR_MODE_SHIFT                  _MK_SHIFT_CONST(18)
#define I2C_IO_PACKET_HEADER_0_ADDR_MODE_FIELD                  (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_ADDR_MODE_SHIFT)
#define I2C_IO_PACKET_HEADER_0_ADDR_MODE_RANGE                  _MK_SHIFT_CONST(18):_MK_SHIFT_CONST(18)
#define I2C_IO_PACKET_HEADER_0_ADDR_MODE_ROW                    2
#define I2C_IO_PACKET_HEADER_0_ADDR_MODE_SEVEN_BIT                      _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_ADDR_MODE_TEN_BIT                        _MK_ENUM_CONST(1)

#define I2C_IO_PACKET_HEADER_0_IE_SHIFT                 _MK_SHIFT_CONST(17)
#define I2C_IO_PACKET_HEADER_0_IE_FIELD                 (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_IE_SHIFT)
#define I2C_IO_PACKET_HEADER_0_IE_RANGE                 _MK_SHIFT_CONST(17):_MK_SHIFT_CONST(17)
#define I2C_IO_PACKET_HEADER_0_IE_ROW                   2
#define I2C_IO_PACKET_HEADER_0_IE_DISABLE                       _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_IE_ENABLE                        _MK_ENUM_CONST(1)

#define I2C_IO_PACKET_HEADER_0_REPEAT_START_SHIFT                       _MK_SHIFT_CONST(16)
#define I2C_IO_PACKET_HEADER_0_REPEAT_START_FIELD                       (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_REPEAT_START_SHIFT)
#define I2C_IO_PACKET_HEADER_0_REPEAT_START_RANGE                       _MK_SHIFT_CONST(16):_MK_SHIFT_CONST(16)
#define I2C_IO_PACKET_HEADER_0_REPEAT_START_ROW                 2
#define I2C_IO_PACKET_HEADER_0_REPEAT_START_STOP                        _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_REPEAT_START_REPEAT_START                        _MK_ENUM_CONST(1)

#define I2C_IO_PACKET_HEADER_0_RESERVED2_1_SHIFT                        _MK_SHIFT_CONST(15)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_1_FIELD                        (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_RESERVED2_1_SHIFT)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_1_RANGE                        _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(15)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_1_ROW                  2

#define I2C_IO_PACKET_HEADER_0_HS_MASTER_ADDR_SHIFT                     _MK_SHIFT_CONST(12)
#define I2C_IO_PACKET_HEADER_0_HS_MASTER_ADDR_FIELD                     (_MK_MASK_CONST(0x7) << I2C_IO_PACKET_HEADER_0_HS_MASTER_ADDR_SHIFT)
#define I2C_IO_PACKET_HEADER_0_HS_MASTER_ADDR_RANGE                     _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(12)
#define I2C_IO_PACKET_HEADER_0_HS_MASTER_ADDR_ROW                       2

#define I2C_IO_PACKET_HEADER_0_RESERVED2_2_SHIFT                        _MK_SHIFT_CONST(10)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_2_FIELD                        (_MK_MASK_CONST(0x3) << I2C_IO_PACKET_HEADER_0_RESERVED2_2_SHIFT)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_2_RANGE                        _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(10)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_2_ROW                  2

#define I2C_IO_PACKET_HEADER_0_SLAVE_ADDR_SHIFT                 _MK_SHIFT_CONST(0)
#define I2C_IO_PACKET_HEADER_0_SLAVE_ADDR_FIELD                 (_MK_MASK_CONST(0x3ff) << I2C_IO_PACKET_HEADER_0_SLAVE_ADDR_SHIFT)
#define I2C_IO_PACKET_HEADER_0_SLAVE_ADDR_RANGE                 _MK_SHIFT_CONST(9):_MK_SHIFT_CONST(0)
#define I2C_IO_PACKET_HEADER_0_SLAVE_ADDR_ROW                   2


// Register I2C_I2C_TX_PACKET_FIFO_0  
#define I2C_I2C_TX_PACKET_FIFO_0                        _MK_ADDR_CONST(0x50)
#define I2C_I2C_TX_PACKET_FIFO_0_SECURE                         0x0
#define I2C_I2C_TX_PACKET_FIFO_0_WORD_COUNT                     0x1
#define I2C_I2C_TX_PACKET_FIFO_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define I2C_I2C_TX_PACKET_FIFO_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_TX_PACKET_FIFO_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define I2C_I2C_TX_PACKET_FIFO_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define I2C_I2C_TX_PACKET_FIFO_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_TX_PACKET_FIFO_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
//SW writes packets into this register  
//A packet may contain generic
#define I2C_I2C_TX_PACKET_FIFO_0_TX_PACKET_SHIFT                        _MK_SHIFT_CONST(0)
#define I2C_I2C_TX_PACKET_FIFO_0_TX_PACKET_FIELD                        (_MK_MASK_CONST(0xffffffff) << I2C_I2C_TX_PACKET_FIFO_0_TX_PACKET_SHIFT)
#define I2C_I2C_TX_PACKET_FIFO_0_TX_PACKET_RANGE                        31:0
#define I2C_I2C_TX_PACKET_FIFO_0_TX_PACKET_WOFFSET                      0x0
#define I2C_I2C_TX_PACKET_FIFO_0_TX_PACKET_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_I2C_TX_PACKET_FIFO_0_TX_PACKET_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_TX_PACKET_FIFO_0_TX_PACKET_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_TX_PACKET_FIFO_0_TX_PACKET_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register I2C_I2C_RX_FIFO_0  
#define I2C_I2C_RX_FIFO_0                       _MK_ADDR_CONST(0x54)
#define I2C_I2C_RX_FIFO_0_SECURE                        0x0
#define I2C_I2C_RX_FIFO_0_WORD_COUNT                    0x1
#define I2C_I2C_RX_FIFO_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define I2C_I2C_RX_FIFO_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_RX_FIFO_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define I2C_I2C_RX_FIFO_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define I2C_I2C_RX_FIFO_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_RX_FIFO_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
//SW Reads data from this register,causes pop  
#define I2C_I2C_RX_FIFO_0_RD_DATA_SHIFT                 _MK_SHIFT_CONST(0)
#define I2C_I2C_RX_FIFO_0_RD_DATA_FIELD                 (_MK_MASK_CONST(0xffffffff) << I2C_I2C_RX_FIFO_0_RD_DATA_SHIFT)
#define I2C_I2C_RX_FIFO_0_RD_DATA_RANGE                 31:0
#define I2C_I2C_RX_FIFO_0_RD_DATA_WOFFSET                       0x0
#define I2C_I2C_RX_FIFO_0_RD_DATA_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_I2C_RX_FIFO_0_RD_DATA_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define I2C_I2C_RX_FIFO_0_RD_DATA_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_I2C_RX_FIFO_0_RD_DATA_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register I2C_PACKET_TRANSFER_STATUS_0  
#define I2C_PACKET_TRANSFER_STATUS_0                    _MK_ADDR_CONST(0x58)
#define I2C_PACKET_TRANSFER_STATUS_0_SECURE                     0x0
#define I2C_PACKET_TRANSFER_STATUS_0_WORD_COUNT                         0x1
#define I2C_PACKET_TRANSFER_STATUS_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_RESET_MASK                         _MK_MASK_CONST(0x1ffffff)
#define I2C_PACKET_TRANSFER_STATUS_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_READ_MASK                  _MK_MASK_CONST(0x1ffffff)
#define I2C_PACKET_TRANSFER_STATUS_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
//The packet transfer for which last packet is set has been
//completed       
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_SHIFT                    _MK_SHIFT_CONST(24)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_FIELD                    (_MK_MASK_CONST(0x1) << I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_SHIFT)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_RANGE                    24:24
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_WOFFSET                  0x0
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_UNSET                    _MK_ENUM_CONST(0)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_SET                      _MK_ENUM_CONST(1)

//The current packet id for which the transaction is 
//happening on the bus
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_SHIFT                      _MK_SHIFT_CONST(16)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_FIELD                      (_MK_MASK_CONST(0xff) << I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_SHIFT)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_RANGE                      23:16
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_WOFFSET                    0x0
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//The number of bytes transferred in the current packet 
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_SHIFT                     _MK_SHIFT_CONST(4)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_FIELD                     (_MK_MASK_CONST(0xfff) << I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_SHIFT)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_RANGE                     15:4
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_WOFFSET                   0x0
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_DEFAULT_MASK                      _MK_MASK_CONST(0xfff)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//No ack recieved for the addr byte
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_SHIFT                       _MK_SHIFT_CONST(3)
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_FIELD                       (_MK_MASK_CONST(0x1) << I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_SHIFT)
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_RANGE                       3:3
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_WOFFSET                     0x0
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_UNSET                       _MK_ENUM_CONST(0)
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_SET                 _MK_ENUM_CONST(1)

//No ack recieved for the data byte
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_SHIFT                       _MK_SHIFT_CONST(2)
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_FIELD                       (_MK_MASK_CONST(0x1) << I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_SHIFT)
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_RANGE                       2:2
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_WOFFSET                     0x0
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_UNSET                       _MK_ENUM_CONST(0)
#define I2C_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_SET                 _MK_ENUM_CONST(1)

//Arbitration lost for the current byte
#define I2C_PACKET_TRANSFER_STATUS_0_ARB_LOST_SHIFT                     _MK_SHIFT_CONST(1)
#define I2C_PACKET_TRANSFER_STATUS_0_ARB_LOST_FIELD                     (_MK_MASK_CONST(0x1) << I2C_PACKET_TRANSFER_STATUS_0_ARB_LOST_SHIFT)
#define I2C_PACKET_TRANSFER_STATUS_0_ARB_LOST_RANGE                     1:1
#define I2C_PACKET_TRANSFER_STATUS_0_ARB_LOST_WOFFSET                   0x0
#define I2C_PACKET_TRANSFER_STATUS_0_ARB_LOST_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_ARB_LOST_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define I2C_PACKET_TRANSFER_STATUS_0_ARB_LOST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_ARB_LOST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_ARB_LOST_UNSET                     _MK_ENUM_CONST(0)
#define I2C_PACKET_TRANSFER_STATUS_0_ARB_LOST_SET                       _MK_ENUM_CONST(1)

//1 = Controller is busy
#define I2C_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_SHIFT                      _MK_SHIFT_CONST(0)
#define I2C_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_FIELD                      (_MK_MASK_CONST(0x1) << I2C_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_SHIFT)
#define I2C_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_RANGE                      0:0
#define I2C_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_WOFFSET                    0x0
#define I2C_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define I2C_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define I2C_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_UNSET                      _MK_ENUM_CONST(0)
#define I2C_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_SET                        _MK_ENUM_CONST(1)


// Register I2C_FIFO_CONTROL_0  
#define I2C_FIFO_CONTROL_0                      _MK_ADDR_CONST(0x5c)
#define I2C_FIFO_CONTROL_0_SECURE                       0x0
#define I2C_FIFO_CONTROL_0_WORD_COUNT                   0x1
#define I2C_FIFO_CONTROL_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define I2C_FIFO_CONTROL_0_RESET_MASK                   _MK_MASK_CONST(0xff)
#define I2C_FIFO_CONTROL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define I2C_FIFO_CONTROL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define I2C_FIFO_CONTROL_0_READ_MASK                    _MK_MASK_CONST(0xff)
#define I2C_FIFO_CONTROL_0_WRITE_MASK                   _MK_MASK_CONST(0xff)
//Transmit fifo trigger level 
//000 = 1 word,  Dma trigger is asserted when 
//at least one word empty in the fifo 
//010 = 2 word,  Dma trigger is asserted when 
//at least 2 words empty in the fifo 
#define I2C_FIFO_CONTROL_0_TX_FIFO_TRIG_SHIFT                   _MK_SHIFT_CONST(5)
#define I2C_FIFO_CONTROL_0_TX_FIFO_TRIG_FIELD                   (_MK_MASK_CONST(0x7) << I2C_FIFO_CONTROL_0_TX_FIFO_TRIG_SHIFT)
#define I2C_FIFO_CONTROL_0_TX_FIFO_TRIG_RANGE                   7:5
#define I2C_FIFO_CONTROL_0_TX_FIFO_TRIG_WOFFSET                 0x0
#define I2C_FIFO_CONTROL_0_TX_FIFO_TRIG_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_FIFO_CONTROL_0_TX_FIFO_TRIG_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define I2C_FIFO_CONTROL_0_TX_FIFO_TRIG_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_FIFO_CONTROL_0_TX_FIFO_TRIG_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Receive fifo trigger level 
//000 = 1 word  Dma trigger is asserted when 
//at least one word full in the fifo 
//010 = 2 word  Dma trigger is asserted when 
//at least 2 word full in the fifo 
#define I2C_FIFO_CONTROL_0_RX_FIFO_TRIG_SHIFT                   _MK_SHIFT_CONST(2)
#define I2C_FIFO_CONTROL_0_RX_FIFO_TRIG_FIELD                   (_MK_MASK_CONST(0x7) << I2C_FIFO_CONTROL_0_RX_FIFO_TRIG_SHIFT)
#define I2C_FIFO_CONTROL_0_RX_FIFO_TRIG_RANGE                   4:2
#define I2C_FIFO_CONTROL_0_RX_FIFO_TRIG_WOFFSET                 0x0
#define I2C_FIFO_CONTROL_0_RX_FIFO_TRIG_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_FIFO_CONTROL_0_RX_FIFO_TRIG_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define I2C_FIFO_CONTROL_0_RX_FIFO_TRIG_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_FIFO_CONTROL_0_RX_FIFO_TRIG_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//1= flush the tx fifo,cleared after fifo is flushed
#define I2C_FIFO_CONTROL_0_TX_FIFO_FLUSH_SHIFT                  _MK_SHIFT_CONST(1)
#define I2C_FIFO_CONTROL_0_TX_FIFO_FLUSH_FIELD                  (_MK_MASK_CONST(0x1) << I2C_FIFO_CONTROL_0_TX_FIFO_FLUSH_SHIFT)
#define I2C_FIFO_CONTROL_0_TX_FIFO_FLUSH_RANGE                  1:1
#define I2C_FIFO_CONTROL_0_TX_FIFO_FLUSH_WOFFSET                        0x0
#define I2C_FIFO_CONTROL_0_TX_FIFO_FLUSH_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_FIFO_CONTROL_0_TX_FIFO_FLUSH_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define I2C_FIFO_CONTROL_0_TX_FIFO_FLUSH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_FIFO_CONTROL_0_TX_FIFO_FLUSH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define I2C_FIFO_CONTROL_0_TX_FIFO_FLUSH_UNSET                  _MK_ENUM_CONST(0)
#define I2C_FIFO_CONTROL_0_TX_FIFO_FLUSH_SET                    _MK_ENUM_CONST(1)

//1= flush the rx fifo,cleared after fifo is flushed 
#define I2C_FIFO_CONTROL_0_RX_FIFO_FLUSH_SHIFT                  _MK_SHIFT_CONST(0)
#define I2C_FIFO_CONTROL_0_RX_FIFO_FLUSH_FIELD                  (_MK_MASK_CONST(0x1) << I2C_FIFO_CONTROL_0_RX_FIFO_FLUSH_SHIFT)
#define I2C_FIFO_CONTROL_0_RX_FIFO_FLUSH_RANGE                  0:0
#define I2C_FIFO_CONTROL_0_RX_FIFO_FLUSH_WOFFSET                        0x0
#define I2C_FIFO_CONTROL_0_RX_FIFO_FLUSH_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_FIFO_CONTROL_0_RX_FIFO_FLUSH_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define I2C_FIFO_CONTROL_0_RX_FIFO_FLUSH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_FIFO_CONTROL_0_RX_FIFO_FLUSH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define I2C_FIFO_CONTROL_0_RX_FIFO_FLUSH_UNSET                  _MK_ENUM_CONST(0)
#define I2C_FIFO_CONTROL_0_RX_FIFO_FLUSH_SET                    _MK_ENUM_CONST(1)


// Register I2C_FIFO_STATUS_0  
#define I2C_FIFO_STATUS_0                       _MK_ADDR_CONST(0x60)
#define I2C_FIFO_STATUS_0_SECURE                        0x0
#define I2C_FIFO_STATUS_0_WORD_COUNT                    0x1
#define I2C_FIFO_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define I2C_FIFO_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0xff)
#define I2C_FIFO_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define I2C_FIFO_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define I2C_FIFO_STATUS_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define I2C_FIFO_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
//The number of slots that can be written to the tx fifo
//0000 = tx_fifo full
//0001 = 1 slot empty 
//0010 = 2 slots empty 
#define I2C_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_SHIFT                       _MK_SHIFT_CONST(4)
#define I2C_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_FIELD                       (_MK_MASK_CONST(0xf) << I2C_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_SHIFT)
#define I2C_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_RANGE                       7:4
#define I2C_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_WOFFSET                     0x0
#define I2C_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define I2C_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//The number of slots to be read from  the rx fifo
//0000 = rx_fifo empty
//0001 = 1 slot  full
//0010 = 2 slots  full
#define I2C_FIFO_STATUS_0_RX_FIFO_FULL_CNT_SHIFT                        _MK_SHIFT_CONST(0)
#define I2C_FIFO_STATUS_0_RX_FIFO_FULL_CNT_FIELD                        (_MK_MASK_CONST(0xf) << I2C_FIFO_STATUS_0_RX_FIFO_FULL_CNT_SHIFT)
#define I2C_FIFO_STATUS_0_RX_FIFO_FULL_CNT_RANGE                        3:0
#define I2C_FIFO_STATUS_0_RX_FIFO_FULL_CNT_WOFFSET                      0x0
#define I2C_FIFO_STATUS_0_RX_FIFO_FULL_CNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_FIFO_STATUS_0_RX_FIFO_FULL_CNT_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define I2C_FIFO_STATUS_0_RX_FIFO_FULL_CNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_FIFO_STATUS_0_RX_FIFO_FULL_CNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register I2C_INTERRUPT_MASK_REGISTER_0  
#define I2C_INTERRUPT_MASK_REGISTER_0                   _MK_ADDR_CONST(0x64)
#define I2C_INTERRUPT_MASK_REGISTER_0_SECURE                    0x0
#define I2C_INTERRUPT_MASK_REGISTER_0_WORD_COUNT                        0x1
#define I2C_INTERRUPT_MASK_REGISTER_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_RESET_MASK                        _MK_MASK_CONST(0x7f)
#define I2C_INTERRUPT_MASK_REGISTER_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_READ_MASK                         _MK_MASK_CONST(0x7f)
#define I2C_INTERRUPT_MASK_REGISTER_0_WRITE_MASK                        _MK_MASK_CONST(0x7f)
#define I2C_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_SHIFT                    _MK_SHIFT_CONST(6)
#define I2C_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << I2C_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_SHIFT)
#define I2C_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_RANGE                    6:6
#define I2C_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_WOFFSET                  0x0
#define I2C_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define I2C_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define I2C_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_SHIFT                    _MK_SHIFT_CONST(5)
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_SHIFT)
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_RANGE                    5:5
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_WOFFSET                  0x0
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_SHIFT                    _MK_SHIFT_CONST(4)
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_SHIFT)
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_RANGE                    4:4
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_WOFFSET                  0x0
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

#define I2C_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_SHIFT                        _MK_SHIFT_CONST(3)
#define I2C_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_FIELD                        (_MK_MASK_CONST(0x1) << I2C_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_SHIFT)
#define I2C_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_RANGE                        3:3
#define I2C_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_WOFFSET                      0x0
#define I2C_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_DEFAULT                      _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define I2C_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_DISABLE                      _MK_ENUM_CONST(0)
#define I2C_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_ENABLE                       _MK_ENUM_CONST(1)

#define I2C_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_SHIFT                     _MK_SHIFT_CONST(2)
#define I2C_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_FIELD                     (_MK_MASK_CONST(0x1) << I2C_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_SHIFT)
#define I2C_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_RANGE                     2:2
#define I2C_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_WOFFSET                   0x0
#define I2C_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define I2C_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define I2C_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_ENABLE                    _MK_ENUM_CONST(1)

#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_SHIFT                       _MK_SHIFT_CONST(1)
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_FIELD                       (_MK_MASK_CONST(0x1) << I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_SHIFT)
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_RANGE                       1:1
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_WOFFSET                     0x0
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define I2C_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_ENABLE                      _MK_ENUM_CONST(1)

#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_SHIFT                       _MK_SHIFT_CONST(0)
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_FIELD                       (_MK_MASK_CONST(0x1) << I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_SHIFT)
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_RANGE                       0:0
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_WOFFSET                     0x0
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define I2C_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_ENABLE                      _MK_ENUM_CONST(1)


// Register I2C_INTERRUPT_STATUS_REGISTER_0  //This register indicates the status bit for which the interrupt is set.If set,Write 1 to clear it
//However TFIFO_DATA_REQ,RFIFO_DATA_REQ fields depend on the fifo trigger levels and cannot be cleared.
#define I2C_INTERRUPT_STATUS_REGISTER_0                 _MK_ADDR_CONST(0x68)
#define I2C_INTERRUPT_STATUS_REGISTER_0_SECURE                  0x0
#define I2C_INTERRUPT_STATUS_REGISTER_0_WORD_COUNT                      0x1
#define I2C_INTERRUPT_STATUS_REGISTER_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_RESET_MASK                      _MK_MASK_CONST(0xff)
#define I2C_INTERRUPT_STATUS_REGISTER_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define I2C_INTERRUPT_STATUS_REGISTER_0_WRITE_MASK                      _MK_MASK_CONST(0xff)
//A packet has been transferred succesfully.
//TRANSFER_PKT_ID filed can be used to know the 
//current byte under transfer.This bit can be
//masked by the IE field in the i2c specific header
#define I2C_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_SHIFT                      _MK_SHIFT_CONST(7)
#define I2C_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_FIELD                      (_MK_MASK_CONST(0x1) << I2C_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_SHIFT)
#define I2C_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_RANGE                      7:7
#define I2C_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_WOFFSET                    0x0
#define I2C_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define I2C_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_UNSET                      _MK_ENUM_CONST(0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_SET                        _MK_ENUM_CONST(1)

//All the packets transferred succesfully
#define I2C_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_SHIFT                 _MK_SHIFT_CONST(6)
#define I2C_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_FIELD                 (_MK_MASK_CONST(0x1) << I2C_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_SHIFT)
#define I2C_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_RANGE                 6:6
#define I2C_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_WOFFSET                       0x0
#define I2C_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define I2C_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_UNSET                 _MK_ENUM_CONST(0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_SET                   _MK_ENUM_CONST(1)

//Tx fifo overflow
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_SHIFT                 _MK_SHIFT_CONST(5)
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_FIELD                 (_MK_MASK_CONST(0x1) << I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_SHIFT)
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_RANGE                 5:5
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_WOFFSET                       0x0
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_UNSET                 _MK_ENUM_CONST(0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_SET                   _MK_ENUM_CONST(1)

//rx fifo underflow
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_SHIFT                 _MK_SHIFT_CONST(4)
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_FIELD                 (_MK_MASK_CONST(0x1) << I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_SHIFT)
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_RANGE                 4:4
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_WOFFSET                       0x0
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_UNSET                 _MK_ENUM_CONST(0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_SET                   _MK_ENUM_CONST(1)

//No ACK from slave
#define I2C_INTERRUPT_STATUS_REGISTER_0_NOACK_SHIFT                     _MK_SHIFT_CONST(3)
#define I2C_INTERRUPT_STATUS_REGISTER_0_NOACK_FIELD                     (_MK_MASK_CONST(0x1) << I2C_INTERRUPT_STATUS_REGISTER_0_NOACK_SHIFT)
#define I2C_INTERRUPT_STATUS_REGISTER_0_NOACK_RANGE                     3:3
#define I2C_INTERRUPT_STATUS_REGISTER_0_NOACK_WOFFSET                   0x0
#define I2C_INTERRUPT_STATUS_REGISTER_0_NOACK_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_NOACK_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define I2C_INTERRUPT_STATUS_REGISTER_0_NOACK_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_NOACK_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_NOACK_UNSET                     _MK_ENUM_CONST(0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_NOACK_SET                       _MK_ENUM_CONST(1)

//Arbitration lost
#define I2C_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_SHIFT                  _MK_SHIFT_CONST(2)
#define I2C_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_FIELD                  (_MK_MASK_CONST(0x1) << I2C_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_SHIFT)
#define I2C_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_RANGE                  2:2
#define I2C_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_WOFFSET                        0x0
#define I2C_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define I2C_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_UNSET                  _MK_ENUM_CONST(0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_SET                    _MK_ENUM_CONST(1)

//Tx fifo data req
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_SHIFT                    _MK_SHIFT_CONST(1)
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_FIELD                    (_MK_MASK_CONST(0x1) << I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_SHIFT)
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_RANGE                    1:1
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_WOFFSET                  0x0
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_UNSET                    _MK_ENUM_CONST(0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_SET                      _MK_ENUM_CONST(1)

//rx fifo data req
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_SHIFT                    _MK_SHIFT_CONST(0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_FIELD                    (_MK_MASK_CONST(0x1) << I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_SHIFT)
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_RANGE                    0:0
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_WOFFSET                  0x0
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_DEFAULT                  _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_UNSET                    _MK_ENUM_CONST(0)
#define I2C_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_SET                      _MK_ENUM_CONST(1)


// Register I2C_I2C_CLK_DIVISOR_REGISTER_0  
#define I2C_I2C_CLK_DIVISOR_REGISTER_0                  _MK_ADDR_CONST(0x6c)
#define I2C_I2C_CLK_DIVISOR_REGISTER_0_SECURE                   0x0
#define I2C_I2C_CLK_DIVISOR_REGISTER_0_WORD_COUNT                       0x1
#define I2C_I2C_CLK_DIVISOR_REGISTER_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define I2C_I2C_CLK_DIVISOR_REGISTER_0_RESET_MASK                       _MK_MASK_CONST(0xffff)
#define I2C_I2C_CLK_DIVISOR_REGISTER_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CLK_DIVISOR_REGISTER_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define I2C_I2C_CLK_DIVISOR_REGISTER_0_READ_MASK                        _MK_MASK_CONST(0xffff)
#define I2C_I2C_CLK_DIVISOR_REGISTER_0_WRITE_MASK                       _MK_MASK_CONST(0xffff)
//N= divide by n+1
#define I2C_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_SHIFT                     _MK_SHIFT_CONST(0)
#define I2C_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_FIELD                     (_MK_MASK_CONST(0xffff) << I2C_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_SHIFT)
#define I2C_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_RANGE                     15:0
#define I2C_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_WOFFSET                   0x0
#define I2C_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_DEFAULT                   _MK_MASK_CONST(0x0)
#define I2C_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define I2C_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define I2C_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_ARI2C_REGS(_op_) \
_op_(I2C_I2C_CNFG_0) \
_op_(I2C_I2C_CMD_ADDR0_0) \
_op_(I2C_I2C_CMD_ADDR1_0) \
_op_(I2C_I2C_CMD_DATA1_0) \
_op_(I2C_I2C_CMD_DATA2_0) \
_op_(I2C_I2C_STATUS_0) \
_op_(I2C_I2C_SL_CNFG_0) \
_op_(I2C_I2C_SL_RCVD_0) \
_op_(I2C_I2C_SL_STATUS_0) \
_op_(I2C_I2C_SL_ADDR1_0) \
_op_(I2C_I2C_SL_ADDR2_0) \
_op_(I2C_I2C_SL_DELAY_COUNT_0) \
_op_(I2C_I2C_TX_PACKET_FIFO_0) \
_op_(I2C_I2C_RX_FIFO_0) \
_op_(I2C_PACKET_TRANSFER_STATUS_0) \
_op_(I2C_FIFO_CONTROL_0) \
_op_(I2C_FIFO_STATUS_0) \
_op_(I2C_INTERRUPT_MASK_REGISTER_0) \
_op_(I2C_INTERRUPT_STATUS_REGISTER_0) \
_op_(I2C_I2C_CLK_DIVISOR_REGISTER_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_I2C        0x00000000

//
// ARI2C REGISTER BANKS
//

#define I2C0_FIRST_REG 0x0000 // I2C_I2C_CNFG_0
#define I2C0_LAST_REG 0x0010 // I2C_I2C_CMD_DATA2_0
#define I2C1_FIRST_REG 0x001c // I2C_I2C_STATUS_0
#define I2C1_LAST_REG 0x0030 // I2C_I2C_SL_ADDR2_0
#define I2C2_FIRST_REG 0x003c // I2C_I2C_SL_DELAY_COUNT_0
#define I2C2_LAST_REG 0x003c // I2C_I2C_SL_DELAY_COUNT_0
#define I2C3_FIRST_REG 0x0050 // I2C_I2C_TX_PACKET_FIFO_0
#define I2C3_LAST_REG 0x006c // I2C_I2C_CLK_DIVISOR_REGISTER_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARI2C_H_INC_
