/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARPL310_H_INC_
#define ___ARPL310_H_INC_

// Register PL310_CACHE_ID_0  
#define PL310_CACHE_ID_0                        _MK_ADDR_CONST(0x0)
#define PL310_CACHE_ID_0_SECURE                         0x0
#define PL310_CACHE_ID_0_WORD_COUNT                     0x1
#define PL310_CACHE_ID_0_RESET_VAL                      _MK_MASK_CONST(0x410000c4)
#define PL310_CACHE_ID_0_RESET_MASK                     _MK_MASK_CONST(0xff00ffff)
#define PL310_CACHE_ID_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define PL310_CACHE_ID_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define PL310_CACHE_ID_0_READ_MASK                      _MK_MASK_CONST(0xff00ffff)
#define PL310_CACHE_ID_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define PL310_CACHE_ID_0_RTL_RELEASE_SHIFT                      _MK_SHIFT_CONST(0)
#define PL310_CACHE_ID_0_RTL_RELEASE_FIELD                      (_MK_MASK_CONST(0x3f) << PL310_CACHE_ID_0_RTL_RELEASE_SHIFT)
#define PL310_CACHE_ID_0_RTL_RELEASE_RANGE                      5:0
#define PL310_CACHE_ID_0_RTL_RELEASE_WOFFSET                    0x0
#define PL310_CACHE_ID_0_RTL_RELEASE_DEFAULT                    _MK_MASK_CONST(0x4)
#define PL310_CACHE_ID_0_RTL_RELEASE_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define PL310_CACHE_ID_0_RTL_RELEASE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_CACHE_ID_0_RTL_RELEASE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define PL310_CACHE_ID_0_PART_NUMBER_SHIFT                      _MK_SHIFT_CONST(6)
#define PL310_CACHE_ID_0_PART_NUMBER_FIELD                      (_MK_MASK_CONST(0xf) << PL310_CACHE_ID_0_PART_NUMBER_SHIFT)
#define PL310_CACHE_ID_0_PART_NUMBER_RANGE                      9:6
#define PL310_CACHE_ID_0_PART_NUMBER_WOFFSET                    0x0
#define PL310_CACHE_ID_0_PART_NUMBER_DEFAULT                    _MK_MASK_CONST(0x3)
#define PL310_CACHE_ID_0_PART_NUMBER_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define PL310_CACHE_ID_0_PART_NUMBER_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_CACHE_ID_0_PART_NUMBER_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define PL310_CACHE_ID_0_CACHE_ID_SHIFT                 _MK_SHIFT_CONST(10)
#define PL310_CACHE_ID_0_CACHE_ID_FIELD                 (_MK_MASK_CONST(0x3f) << PL310_CACHE_ID_0_CACHE_ID_SHIFT)
#define PL310_CACHE_ID_0_CACHE_ID_RANGE                 15:10
#define PL310_CACHE_ID_0_CACHE_ID_WOFFSET                       0x0
#define PL310_CACHE_ID_0_CACHE_ID_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_CACHE_ID_0_CACHE_ID_DEFAULT_MASK                  _MK_MASK_CONST(0x3f)
#define PL310_CACHE_ID_0_CACHE_ID_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_CACHE_ID_0_CACHE_ID_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define PL310_CACHE_ID_0_IMPLEMENTER_SHIFT                      _MK_SHIFT_CONST(24)
#define PL310_CACHE_ID_0_IMPLEMENTER_FIELD                      (_MK_MASK_CONST(0xff) << PL310_CACHE_ID_0_IMPLEMENTER_SHIFT)
#define PL310_CACHE_ID_0_IMPLEMENTER_RANGE                      31:24
#define PL310_CACHE_ID_0_IMPLEMENTER_WOFFSET                    0x0
#define PL310_CACHE_ID_0_IMPLEMENTER_DEFAULT                    _MK_MASK_CONST(0x41)
#define PL310_CACHE_ID_0_IMPLEMENTER_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define PL310_CACHE_ID_0_IMPLEMENTER_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_CACHE_ID_0_IMPLEMENTER_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register PL310_CACHE_TYPE_0  
#define PL310_CACHE_TYPE_0                      _MK_ADDR_CONST(0x4)
#define PL310_CACHE_TYPE_0_SECURE                       0x0
#define PL310_CACHE_TYPE_0_WORD_COUNT                   0x1
#define PL310_CACHE_TYPE_0_RESET_VAL                    _MK_MASK_CONST(0x1c400400)
#define PL310_CACHE_TYPE_0_RESET_MASK                   _MK_MASK_CONST(0x1f743743)
#define PL310_CACHE_TYPE_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_READ_MASK                    _MK_MASK_CONST(0x1f743743)
#define PL310_CACHE_TYPE_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_I_LINE_SIZE_SHIFT                    _MK_SHIFT_CONST(0)
#define PL310_CACHE_TYPE_0_I_LINE_SIZE_FIELD                    (_MK_MASK_CONST(0x3) << PL310_CACHE_TYPE_0_I_LINE_SIZE_SHIFT)
#define PL310_CACHE_TYPE_0_I_LINE_SIZE_RANGE                    1:0
#define PL310_CACHE_TYPE_0_I_LINE_SIZE_WOFFSET                  0x0
#define PL310_CACHE_TYPE_0_I_LINE_SIZE_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_I_LINE_SIZE_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define PL310_CACHE_TYPE_0_I_LINE_SIZE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_I_LINE_SIZE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_I_LINE_SIZE_SIZE_32B                 _MK_ENUM_CONST(0)

#define PL310_CACHE_TYPE_0_I_ASSOCIATIVITY_SHIFT                        _MK_SHIFT_CONST(6)
#define PL310_CACHE_TYPE_0_I_ASSOCIATIVITY_FIELD                        (_MK_MASK_CONST(0x1) << PL310_CACHE_TYPE_0_I_ASSOCIATIVITY_SHIFT)
#define PL310_CACHE_TYPE_0_I_ASSOCIATIVITY_RANGE                        6:6
#define PL310_CACHE_TYPE_0_I_ASSOCIATIVITY_WOFFSET                      0x0
#define PL310_CACHE_TYPE_0_I_ASSOCIATIVITY_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_I_ASSOCIATIVITY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define PL310_CACHE_TYPE_0_I_ASSOCIATIVITY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_I_ASSOCIATIVITY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_I_ASSOCIATIVITY_ASSOC_8                      _MK_ENUM_CONST(0)
#define PL310_CACHE_TYPE_0_I_ASSOCIATIVITY_ASSOC_16                     _MK_ENUM_CONST(1)

#define PL310_CACHE_TYPE_0_I_WAY_SIZE_SHIFT                     _MK_SHIFT_CONST(8)
#define PL310_CACHE_TYPE_0_I_WAY_SIZE_FIELD                     (_MK_MASK_CONST(0x7) << PL310_CACHE_TYPE_0_I_WAY_SIZE_SHIFT)
#define PL310_CACHE_TYPE_0_I_WAY_SIZE_RANGE                     10:8
#define PL310_CACHE_TYPE_0_I_WAY_SIZE_WOFFSET                   0x0
#define PL310_CACHE_TYPE_0_I_WAY_SIZE_DEFAULT                   _MK_MASK_CONST(0x4)
#define PL310_CACHE_TYPE_0_I_WAY_SIZE_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define PL310_CACHE_TYPE_0_I_WAY_SIZE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_I_WAY_SIZE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_I_WAY_SIZE_WAY_RES16KB                       _MK_ENUM_CONST(0)
#define PL310_CACHE_TYPE_0_I_WAY_SIZE_WAY_16KB                  _MK_ENUM_CONST(1)
#define PL310_CACHE_TYPE_0_I_WAY_SIZE_WAY_32KB                  _MK_ENUM_CONST(2)
#define PL310_CACHE_TYPE_0_I_WAY_SIZE_WAY_64KB                  _MK_ENUM_CONST(3)
#define PL310_CACHE_TYPE_0_I_WAY_SIZE_WAY_128KB                 _MK_ENUM_CONST(4)
#define PL310_CACHE_TYPE_0_I_WAY_SIZE_WAY_256KB                 _MK_ENUM_CONST(5)
#define PL310_CACHE_TYPE_0_I_WAY_SIZE_WAY_512KB                 _MK_ENUM_CONST(6)
#define PL310_CACHE_TYPE_0_I_WAY_SIZE_WAY_RES512kB                      _MK_ENUM_CONST(7)

#define PL310_CACHE_TYPE_0_D_LINE_SIZE_SHIFT                    _MK_SHIFT_CONST(12)
#define PL310_CACHE_TYPE_0_D_LINE_SIZE_FIELD                    (_MK_MASK_CONST(0x3) << PL310_CACHE_TYPE_0_D_LINE_SIZE_SHIFT)
#define PL310_CACHE_TYPE_0_D_LINE_SIZE_RANGE                    13:12
#define PL310_CACHE_TYPE_0_D_LINE_SIZE_WOFFSET                  0x0
#define PL310_CACHE_TYPE_0_D_LINE_SIZE_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_D_LINE_SIZE_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define PL310_CACHE_TYPE_0_D_LINE_SIZE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_D_LINE_SIZE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_D_LINE_SIZE_SIZE_32B                 _MK_ENUM_CONST(0)

#define PL310_CACHE_TYPE_0_D_ASSOCIATIVITY_SHIFT                        _MK_SHIFT_CONST(18)
#define PL310_CACHE_TYPE_0_D_ASSOCIATIVITY_FIELD                        (_MK_MASK_CONST(0x1) << PL310_CACHE_TYPE_0_D_ASSOCIATIVITY_SHIFT)
#define PL310_CACHE_TYPE_0_D_ASSOCIATIVITY_RANGE                        18:18
#define PL310_CACHE_TYPE_0_D_ASSOCIATIVITY_WOFFSET                      0x0
#define PL310_CACHE_TYPE_0_D_ASSOCIATIVITY_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_D_ASSOCIATIVITY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define PL310_CACHE_TYPE_0_D_ASSOCIATIVITY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_D_ASSOCIATIVITY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_D_ASSOCIATIVITY_ASSOC_8                      _MK_ENUM_CONST(0)
#define PL310_CACHE_TYPE_0_D_ASSOCIATIVITY_ASSOC_16                     _MK_ENUM_CONST(1)

#define PL310_CACHE_TYPE_0_D_WAY_SIZE_SHIFT                     _MK_SHIFT_CONST(20)
#define PL310_CACHE_TYPE_0_D_WAY_SIZE_FIELD                     (_MK_MASK_CONST(0x7) << PL310_CACHE_TYPE_0_D_WAY_SIZE_SHIFT)
#define PL310_CACHE_TYPE_0_D_WAY_SIZE_RANGE                     22:20
#define PL310_CACHE_TYPE_0_D_WAY_SIZE_WOFFSET                   0x0
#define PL310_CACHE_TYPE_0_D_WAY_SIZE_DEFAULT                   _MK_MASK_CONST(0x4)
#define PL310_CACHE_TYPE_0_D_WAY_SIZE_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define PL310_CACHE_TYPE_0_D_WAY_SIZE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_D_WAY_SIZE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_D_WAY_SIZE_WAY_RES16KB                       _MK_ENUM_CONST(0)
#define PL310_CACHE_TYPE_0_D_WAY_SIZE_WAY_16KB                  _MK_ENUM_CONST(1)
#define PL310_CACHE_TYPE_0_D_WAY_SIZE_WAY_32KB                  _MK_ENUM_CONST(2)
#define PL310_CACHE_TYPE_0_D_WAY_SIZE_WAY_64KB                  _MK_ENUM_CONST(3)
#define PL310_CACHE_TYPE_0_D_WAY_SIZE_WAY_128KB                 _MK_ENUM_CONST(4)
#define PL310_CACHE_TYPE_0_D_WAY_SIZE_WAY_256KB                 _MK_ENUM_CONST(5)
#define PL310_CACHE_TYPE_0_D_WAY_SIZE_WAY_512KB                 _MK_ENUM_CONST(6)
#define PL310_CACHE_TYPE_0_D_WAY_SIZE_WAY_RES512kB                      _MK_ENUM_CONST(7)

#define PL310_CACHE_TYPE_0_ORGANIZATION_SHIFT                   _MK_SHIFT_CONST(24)
#define PL310_CACHE_TYPE_0_ORGANIZATION_FIELD                   (_MK_MASK_CONST(0x1) << PL310_CACHE_TYPE_0_ORGANIZATION_SHIFT)
#define PL310_CACHE_TYPE_0_ORGANIZATION_RANGE                   24:24
#define PL310_CACHE_TYPE_0_ORGANIZATION_WOFFSET                 0x0
#define PL310_CACHE_TYPE_0_ORGANIZATION_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_ORGANIZATION_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define PL310_CACHE_TYPE_0_ORGANIZATION_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_ORGANIZATION_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_ORGANIZATION_UNIFIED                 _MK_ENUM_CONST(0)
#define PL310_CACHE_TYPE_0_ORGANIZATION_HARVARD                 _MK_ENUM_CONST(1)

#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_LINE_SHIFT                       _MK_SHIFT_CONST(25)
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_LINE_FIELD                       (_MK_MASK_CONST(0x1) << PL310_CACHE_TYPE_0_LOCKDOWN_BY_LINE_SHIFT)
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_LINE_RANGE                       25:25
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_LINE_WOFFSET                     0x0
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_LINE_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_LINE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_LINE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_LINE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_LINE_NOT_IMPLEMENTED                     _MK_ENUM_CONST(0)
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_LINE_IMPLEMENTED                 _MK_ENUM_CONST(1)

#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_MASTER_SHIFT                     _MK_SHIFT_CONST(26)
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_MASTER_FIELD                     (_MK_MASK_CONST(0x1) << PL310_CACHE_TYPE_0_LOCKDOWN_BY_MASTER_SHIFT)
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_MASTER_RANGE                     26:26
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_MASTER_WOFFSET                   0x0
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_MASTER_DEFAULT                   _MK_MASK_CONST(0x1)
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_MASTER_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_MASTER_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_MASTER_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_MASTER_NOT_IMPLEMENTED                   _MK_ENUM_CONST(0)
#define PL310_CACHE_TYPE_0_LOCKDOWN_BY_MASTER_IMPLEMENTED                       _MK_ENUM_CONST(1)

#define PL310_CACHE_TYPE_0_CTYPE_SHIFT                  _MK_SHIFT_CONST(27)
#define PL310_CACHE_TYPE_0_CTYPE_FIELD                  (_MK_MASK_CONST(0x3) << PL310_CACHE_TYPE_0_CTYPE_SHIFT)
#define PL310_CACHE_TYPE_0_CTYPE_RANGE                  28:27
#define PL310_CACHE_TYPE_0_CTYPE_WOFFSET                        0x0
#define PL310_CACHE_TYPE_0_CTYPE_DEFAULT                        _MK_MASK_CONST(0x3)
#define PL310_CACHE_TYPE_0_CTYPE_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define PL310_CACHE_TYPE_0_CTYPE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_CTYPE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define PL310_CACHE_TYPE_0_CTYPE_PL310                  _MK_ENUM_CONST(3)


// Register PL310_CONTROL_0  
#define PL310_CONTROL_0                 _MK_ADDR_CONST(0x100)
#define PL310_CONTROL_0_SECURE                  0x0
#define PL310_CONTROL_0_WORD_COUNT                      0x1
#define PL310_CONTROL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define PL310_CONTROL_0_RESET_MASK                      _MK_MASK_CONST(0x1)
#define PL310_CONTROL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define PL310_CONTROL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define PL310_CONTROL_0_READ_MASK                       _MK_MASK_CONST(0x1)
#define PL310_CONTROL_0_WRITE_MASK                      _MK_MASK_CONST(0x1)
#define PL310_CONTROL_0_ENABLE_SHIFT                    _MK_SHIFT_CONST(0)
#define PL310_CONTROL_0_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << PL310_CONTROL_0_ENABLE_SHIFT)
#define PL310_CONTROL_0_ENABLE_RANGE                    0:0
#define PL310_CONTROL_0_ENABLE_WOFFSET                  0x0
#define PL310_CONTROL_0_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_CONTROL_0_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define PL310_CONTROL_0_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_CONTROL_0_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_CONTROL_0_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define PL310_CONTROL_0_ENABLE_ENABLED                  _MK_ENUM_CONST(1)


// Register PL310_AUXILIARY_CONTROL_0  
#define PL310_AUXILIARY_CONTROL_0                       _MK_ADDR_CONST(0x104)
#define PL310_AUXILIARY_CONTROL_0_SECURE                        0x0
#define PL310_AUXILIARY_CONTROL_0_WORD_COUNT                    0x1
#define PL310_AUXILIARY_CONTROL_0_RESET_VAL                     _MK_MASK_CONST(0x80000)
#define PL310_AUXILIARY_CONTROL_0_RESET_MASK                    _MK_MASK_CONST(0x7dff3401)
#define PL310_AUXILIARY_CONTROL_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_READ_MASK                     _MK_MASK_CONST(0x7dff3401)
#define PL310_AUXILIARY_CONTROL_0_WRITE_MASK                    _MK_MASK_CONST(0x7dff3401)
#define PL310_AUXILIARY_CONTROL_0_FULL_LINE_OF_ZERO_SHIFT                       _MK_SHIFT_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_FULL_LINE_OF_ZERO_FIELD                       (_MK_MASK_CONST(0x1) << PL310_AUXILIARY_CONTROL_0_FULL_LINE_OF_ZERO_SHIFT)
#define PL310_AUXILIARY_CONTROL_0_FULL_LINE_OF_ZERO_RANGE                       0:0
#define PL310_AUXILIARY_CONTROL_0_FULL_LINE_OF_ZERO_WOFFSET                     0x0
#define PL310_AUXILIARY_CONTROL_0_FULL_LINE_OF_ZERO_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_FULL_LINE_OF_ZERO_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define PL310_AUXILIARY_CONTROL_0_FULL_LINE_OF_ZERO_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_FULL_LINE_OF_ZERO_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_FULL_LINE_OF_ZERO_DISABLED                    _MK_ENUM_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_FULL_LINE_OF_ZERO_ENABLED                     _MK_ENUM_CONST(1)

#define PL310_AUXILIARY_CONTROL_0_SO_DEV_HIGH_PRIORITY_SHIFT                    _MK_SHIFT_CONST(10)
#define PL310_AUXILIARY_CONTROL_0_SO_DEV_HIGH_PRIORITY_FIELD                    (_MK_MASK_CONST(0x1) << PL310_AUXILIARY_CONTROL_0_SO_DEV_HIGH_PRIORITY_SHIFT)
#define PL310_AUXILIARY_CONTROL_0_SO_DEV_HIGH_PRIORITY_RANGE                    10:10
#define PL310_AUXILIARY_CONTROL_0_SO_DEV_HIGH_PRIORITY_WOFFSET                  0x0
#define PL310_AUXILIARY_CONTROL_0_SO_DEV_HIGH_PRIORITY_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_SO_DEV_HIGH_PRIORITY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define PL310_AUXILIARY_CONTROL_0_SO_DEV_HIGH_PRIORITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_SO_DEV_HIGH_PRIORITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_SO_DEV_HIGH_PRIORITY_DISABLED                 _MK_ENUM_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_SO_DEV_HIGH_PRIORITY_ENABLED                  _MK_ENUM_CONST(1)

#define PL310_AUXILIARY_CONTROL_0_EXCLUSIVE_SHIFT                       _MK_SHIFT_CONST(12)
#define PL310_AUXILIARY_CONTROL_0_EXCLUSIVE_FIELD                       (_MK_MASK_CONST(0x1) << PL310_AUXILIARY_CONTROL_0_EXCLUSIVE_SHIFT)
#define PL310_AUXILIARY_CONTROL_0_EXCLUSIVE_RANGE                       12:12
#define PL310_AUXILIARY_CONTROL_0_EXCLUSIVE_WOFFSET                     0x0
#define PL310_AUXILIARY_CONTROL_0_EXCLUSIVE_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_EXCLUSIVE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define PL310_AUXILIARY_CONTROL_0_EXCLUSIVE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_EXCLUSIVE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_EXCLUSIVE_DISABLED                    _MK_ENUM_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_EXCLUSIVE_ENABLED                     _MK_ENUM_CONST(1)

#define PL310_AUXILIARY_CONTROL_0_SHARED_INVALIDATE_SHIFT                       _MK_SHIFT_CONST(13)
#define PL310_AUXILIARY_CONTROL_0_SHARED_INVALIDATE_FIELD                       (_MK_MASK_CONST(0x1) << PL310_AUXILIARY_CONTROL_0_SHARED_INVALIDATE_SHIFT)
#define PL310_AUXILIARY_CONTROL_0_SHARED_INVALIDATE_RANGE                       13:13
#define PL310_AUXILIARY_CONTROL_0_SHARED_INVALIDATE_WOFFSET                     0x0
#define PL310_AUXILIARY_CONTROL_0_SHARED_INVALIDATE_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_SHARED_INVALIDATE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define PL310_AUXILIARY_CONTROL_0_SHARED_INVALIDATE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_SHARED_INVALIDATE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_SHARED_INVALIDATE_DISABLED                    _MK_ENUM_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_SHARED_INVALIDATE_ENABLED                     _MK_ENUM_CONST(1)

#define PL310_AUXILIARY_CONTROL_0_ASSOCIATIVITY_SHIFT                   _MK_SHIFT_CONST(16)
#define PL310_AUXILIARY_CONTROL_0_ASSOCIATIVITY_FIELD                   (_MK_MASK_CONST(0x1) << PL310_AUXILIARY_CONTROL_0_ASSOCIATIVITY_SHIFT)
#define PL310_AUXILIARY_CONTROL_0_ASSOCIATIVITY_RANGE                   16:16
#define PL310_AUXILIARY_CONTROL_0_ASSOCIATIVITY_WOFFSET                 0x0
#define PL310_AUXILIARY_CONTROL_0_ASSOCIATIVITY_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_ASSOCIATIVITY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define PL310_AUXILIARY_CONTROL_0_ASSOCIATIVITY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_ASSOCIATIVITY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_ASSOCIATIVITY_ASSOC_8                 _MK_ENUM_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_ASSOCIATIVITY_ASSOC_16                        _MK_ENUM_CONST(1)

#define PL310_AUXILIARY_CONTROL_0_WAY_SIZE_SHIFT                        _MK_SHIFT_CONST(17)
#define PL310_AUXILIARY_CONTROL_0_WAY_SIZE_FIELD                        (_MK_MASK_CONST(0x7) << PL310_AUXILIARY_CONTROL_0_WAY_SIZE_SHIFT)
#define PL310_AUXILIARY_CONTROL_0_WAY_SIZE_RANGE                        19:17
#define PL310_AUXILIARY_CONTROL_0_WAY_SIZE_WOFFSET                      0x0
#define PL310_AUXILIARY_CONTROL_0_WAY_SIZE_DEFAULT                      _MK_MASK_CONST(0x4)
#define PL310_AUXILIARY_CONTROL_0_WAY_SIZE_DEFAULT_MASK                 _MK_MASK_CONST(0x7)
#define PL310_AUXILIARY_CONTROL_0_WAY_SIZE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_WAY_SIZE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_WAY_SIZE_WAY_RES16KB                  _MK_ENUM_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_WAY_SIZE_WAY_16KB                     _MK_ENUM_CONST(1)
#define PL310_AUXILIARY_CONTROL_0_WAY_SIZE_WAY_32KB                     _MK_ENUM_CONST(2)
#define PL310_AUXILIARY_CONTROL_0_WAY_SIZE_WAY_64KB                     _MK_ENUM_CONST(3)
#define PL310_AUXILIARY_CONTROL_0_WAY_SIZE_WAY_128KB                    _MK_ENUM_CONST(4)
#define PL310_AUXILIARY_CONTROL_0_WAY_SIZE_WAY_256KB                    _MK_ENUM_CONST(5)
#define PL310_AUXILIARY_CONTROL_0_WAY_SIZE_WAY_512KB                    _MK_ENUM_CONST(6)
#define PL310_AUXILIARY_CONTROL_0_WAY_SIZE_WAY_RES512kB                 _MK_ENUM_CONST(7)

#define PL310_AUXILIARY_CONTROL_0_EVENT_MONITOR_BUS_SHIFT                       _MK_SHIFT_CONST(20)
#define PL310_AUXILIARY_CONTROL_0_EVENT_MONITOR_BUS_FIELD                       (_MK_MASK_CONST(0x1) << PL310_AUXILIARY_CONTROL_0_EVENT_MONITOR_BUS_SHIFT)
#define PL310_AUXILIARY_CONTROL_0_EVENT_MONITOR_BUS_RANGE                       20:20
#define PL310_AUXILIARY_CONTROL_0_EVENT_MONITOR_BUS_WOFFSET                     0x0
#define PL310_AUXILIARY_CONTROL_0_EVENT_MONITOR_BUS_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_EVENT_MONITOR_BUS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define PL310_AUXILIARY_CONTROL_0_EVENT_MONITOR_BUS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_EVENT_MONITOR_BUS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_EVENT_MONITOR_BUS_DISABLED                    _MK_ENUM_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_EVENT_MONITOR_BUS_ENABLED                     _MK_ENUM_CONST(1)

#define PL310_AUXILIARY_CONTROL_0_PARITY_SHIFT                  _MK_SHIFT_CONST(21)
#define PL310_AUXILIARY_CONTROL_0_PARITY_FIELD                  (_MK_MASK_CONST(0x1) << PL310_AUXILIARY_CONTROL_0_PARITY_SHIFT)
#define PL310_AUXILIARY_CONTROL_0_PARITY_RANGE                  21:21
#define PL310_AUXILIARY_CONTROL_0_PARITY_WOFFSET                        0x0
#define PL310_AUXILIARY_CONTROL_0_PARITY_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_PARITY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define PL310_AUXILIARY_CONTROL_0_PARITY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_PARITY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_PARITY_DISABLED                       _MK_ENUM_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_PARITY_ENABLED                        _MK_ENUM_CONST(1)

#define PL310_AUXILIARY_CONTROL_0_SHARED_ATTRIBUTE_OVERRIDE_SHIFT                       _MK_SHIFT_CONST(22)
#define PL310_AUXILIARY_CONTROL_0_SHARED_ATTRIBUTE_OVERRIDE_FIELD                       (_MK_MASK_CONST(0x1) << PL310_AUXILIARY_CONTROL_0_SHARED_ATTRIBUTE_OVERRIDE_SHIFT)
#define PL310_AUXILIARY_CONTROL_0_SHARED_ATTRIBUTE_OVERRIDE_RANGE                       22:22
#define PL310_AUXILIARY_CONTROL_0_SHARED_ATTRIBUTE_OVERRIDE_WOFFSET                     0x0
#define PL310_AUXILIARY_CONTROL_0_SHARED_ATTRIBUTE_OVERRIDE_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_SHARED_ATTRIBUTE_OVERRIDE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define PL310_AUXILIARY_CONTROL_0_SHARED_ATTRIBUTE_OVERRIDE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_SHARED_ATTRIBUTE_OVERRIDE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_SHARED_ATTRIBUTE_OVERRIDE_DISABLED                    _MK_ENUM_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_SHARED_ATTRIBUTE_OVERRIDE_ENABLED                     _MK_ENUM_CONST(1)

#define PL310_AUXILIARY_CONTROL_0_FORCE_WRITE_ALLOCATE_SHIFT                    _MK_SHIFT_CONST(23)
#define PL310_AUXILIARY_CONTROL_0_FORCE_WRITE_ALLOCATE_FIELD                    (_MK_MASK_CONST(0x3) << PL310_AUXILIARY_CONTROL_0_FORCE_WRITE_ALLOCATE_SHIFT)
#define PL310_AUXILIARY_CONTROL_0_FORCE_WRITE_ALLOCATE_RANGE                    24:23
#define PL310_AUXILIARY_CONTROL_0_FORCE_WRITE_ALLOCATE_WOFFSET                  0x0
#define PL310_AUXILIARY_CONTROL_0_FORCE_WRITE_ALLOCATE_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_FORCE_WRITE_ALLOCATE_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define PL310_AUXILIARY_CONTROL_0_FORCE_WRITE_ALLOCATE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_FORCE_WRITE_ALLOCATE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_FORCE_WRITE_ALLOCATE_DISABLED                 _MK_ENUM_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_FORCE_WRITE_ALLOCATE_USE_AWCACHE                      _MK_ENUM_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_FORCE_WRITE_ALLOCATE_FORCE_NO_WA                      _MK_ENUM_CONST(1)
#define PL310_AUXILIARY_CONTROL_0_FORCE_WRITE_ALLOCATE_OVERRIDE_AWCACHE_TO_NOWA                 _MK_ENUM_CONST(1)
#define PL310_AUXILIARY_CONTROL_0_FORCE_WRITE_ALLOCATE_FORCE_WA                 _MK_ENUM_CONST(2)
#define PL310_AUXILIARY_CONTROL_0_FORCE_WRITE_ALLOCATE_OVERRIDE_AWCACHE_TO_WA                   _MK_ENUM_CONST(2)
#define PL310_AUXILIARY_CONTROL_0_FORCE_WRITE_ALLOCATE_RES_MAPPED_TO_0                  _MK_ENUM_CONST(3)

#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_LOCKDOWN_WR_SHIFT                  _MK_SHIFT_CONST(26)
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_LOCKDOWN_WR_FIELD                  (_MK_MASK_CONST(0x1) << PL310_AUXILIARY_CONTROL_0_NON_SECURE_LOCKDOWN_WR_SHIFT)
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_LOCKDOWN_WR_RANGE                  26:26
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_LOCKDOWN_WR_WOFFSET                        0x0
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_LOCKDOWN_WR_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_LOCKDOWN_WR_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_LOCKDOWN_WR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_LOCKDOWN_WR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_LOCKDOWN_WR_DISABLED                       _MK_ENUM_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_LOCKDOWN_WR_ENABLED                        _MK_ENUM_CONST(1)

#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_INTERRUPT_ACCESS_SHIFT                     _MK_SHIFT_CONST(27)
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_INTERRUPT_ACCESS_FIELD                     (_MK_MASK_CONST(0x1) << PL310_AUXILIARY_CONTROL_0_NON_SECURE_INTERRUPT_ACCESS_SHIFT)
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_INTERRUPT_ACCESS_RANGE                     27:27
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_INTERRUPT_ACCESS_WOFFSET                   0x0
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_INTERRUPT_ACCESS_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_INTERRUPT_ACCESS_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_INTERRUPT_ACCESS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_INTERRUPT_ACCESS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_INTERRUPT_ACCESS_DISABLED                  _MK_ENUM_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_NON_SECURE_INTERRUPT_ACCESS_ENABLED                   _MK_ENUM_CONST(1)

#define PL310_AUXILIARY_CONTROL_0_DATA_PREFETCH_SHIFT                   _MK_SHIFT_CONST(28)
#define PL310_AUXILIARY_CONTROL_0_DATA_PREFETCH_FIELD                   (_MK_MASK_CONST(0x1) << PL310_AUXILIARY_CONTROL_0_DATA_PREFETCH_SHIFT)
#define PL310_AUXILIARY_CONTROL_0_DATA_PREFETCH_RANGE                   28:28
#define PL310_AUXILIARY_CONTROL_0_DATA_PREFETCH_WOFFSET                 0x0
#define PL310_AUXILIARY_CONTROL_0_DATA_PREFETCH_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_DATA_PREFETCH_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define PL310_AUXILIARY_CONTROL_0_DATA_PREFETCH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_DATA_PREFETCH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_DATA_PREFETCH_DISABLED                        _MK_ENUM_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_DATA_PREFETCH_ENABLED                 _MK_ENUM_CONST(1)

#define PL310_AUXILIARY_CONTROL_0_INSTRUCTION_PREFETCH_SHIFT                    _MK_SHIFT_CONST(29)
#define PL310_AUXILIARY_CONTROL_0_INSTRUCTION_PREFETCH_FIELD                    (_MK_MASK_CONST(0x1) << PL310_AUXILIARY_CONTROL_0_INSTRUCTION_PREFETCH_SHIFT)
#define PL310_AUXILIARY_CONTROL_0_INSTRUCTION_PREFETCH_RANGE                    29:29
#define PL310_AUXILIARY_CONTROL_0_INSTRUCTION_PREFETCH_WOFFSET                  0x0
#define PL310_AUXILIARY_CONTROL_0_INSTRUCTION_PREFETCH_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_INSTRUCTION_PREFETCH_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define PL310_AUXILIARY_CONTROL_0_INSTRUCTION_PREFETCH_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_INSTRUCTION_PREFETCH_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_INSTRUCTION_PREFETCH_DISABLED                 _MK_ENUM_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_INSTRUCTION_PREFETCH_ENABLED                  _MK_ENUM_CONST(1)

#define PL310_AUXILIARY_CONTROL_0_EARLY_BRESP_SHIFT                     _MK_SHIFT_CONST(30)
#define PL310_AUXILIARY_CONTROL_0_EARLY_BRESP_FIELD                     (_MK_MASK_CONST(0x1) << PL310_AUXILIARY_CONTROL_0_EARLY_BRESP_SHIFT)
#define PL310_AUXILIARY_CONTROL_0_EARLY_BRESP_RANGE                     30:30
#define PL310_AUXILIARY_CONTROL_0_EARLY_BRESP_WOFFSET                   0x0
#define PL310_AUXILIARY_CONTROL_0_EARLY_BRESP_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_EARLY_BRESP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_AUXILIARY_CONTROL_0_EARLY_BRESP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_EARLY_BRESP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_AUXILIARY_CONTROL_0_EARLY_BRESP_DISABLED                  _MK_ENUM_CONST(0)
#define PL310_AUXILIARY_CONTROL_0_EARLY_BRESP_ENABLED                   _MK_ENUM_CONST(1)


// Register PL310_TAG_RAM_LATENCY_0  
#define PL310_TAG_RAM_LATENCY_0                 _MK_ADDR_CONST(0x108)
#define PL310_TAG_RAM_LATENCY_0_SECURE                  0x0
#define PL310_TAG_RAM_LATENCY_0_WORD_COUNT                      0x1
#define PL310_TAG_RAM_LATENCY_0_RESET_VAL                       _MK_MASK_CONST(0x777)
#define PL310_TAG_RAM_LATENCY_0_RESET_MASK                      _MK_MASK_CONST(0x777)
#define PL310_TAG_RAM_LATENCY_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x331)
#define PL310_TAG_RAM_LATENCY_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x777)
#define PL310_TAG_RAM_LATENCY_0_READ_MASK                       _MK_MASK_CONST(0x777)
#define PL310_TAG_RAM_LATENCY_0_WRITE_MASK                      _MK_MASK_CONST(0x777)
#define PL310_TAG_RAM_LATENCY_0_SETUP_SHIFT                     _MK_SHIFT_CONST(0)
#define PL310_TAG_RAM_LATENCY_0_SETUP_FIELD                     (_MK_MASK_CONST(0x7) << PL310_TAG_RAM_LATENCY_0_SETUP_SHIFT)
#define PL310_TAG_RAM_LATENCY_0_SETUP_RANGE                     2:0
#define PL310_TAG_RAM_LATENCY_0_SETUP_WOFFSET                   0x0
#define PL310_TAG_RAM_LATENCY_0_SETUP_DEFAULT                   _MK_MASK_CONST(0x7)
#define PL310_TAG_RAM_LATENCY_0_SETUP_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define PL310_TAG_RAM_LATENCY_0_SETUP_SW_DEFAULT                        _MK_MASK_CONST(0x1)
#define PL310_TAG_RAM_LATENCY_0_SETUP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x7)

#define PL310_TAG_RAM_LATENCY_0_READ_SHIFT                      _MK_SHIFT_CONST(4)
#define PL310_TAG_RAM_LATENCY_0_READ_FIELD                      (_MK_MASK_CONST(0x7) << PL310_TAG_RAM_LATENCY_0_READ_SHIFT)
#define PL310_TAG_RAM_LATENCY_0_READ_RANGE                      6:4
#define PL310_TAG_RAM_LATENCY_0_READ_WOFFSET                    0x0
#define PL310_TAG_RAM_LATENCY_0_READ_DEFAULT                    _MK_MASK_CONST(0x7)
#define PL310_TAG_RAM_LATENCY_0_READ_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define PL310_TAG_RAM_LATENCY_0_READ_SW_DEFAULT                 _MK_MASK_CONST(0x3)
#define PL310_TAG_RAM_LATENCY_0_READ_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x7)

#define PL310_TAG_RAM_LATENCY_0_WRITE_SHIFT                     _MK_SHIFT_CONST(8)
#define PL310_TAG_RAM_LATENCY_0_WRITE_FIELD                     (_MK_MASK_CONST(0x7) << PL310_TAG_RAM_LATENCY_0_WRITE_SHIFT)
#define PL310_TAG_RAM_LATENCY_0_WRITE_RANGE                     10:8
#define PL310_TAG_RAM_LATENCY_0_WRITE_WOFFSET                   0x0
#define PL310_TAG_RAM_LATENCY_0_WRITE_DEFAULT                   _MK_MASK_CONST(0x7)
#define PL310_TAG_RAM_LATENCY_0_WRITE_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define PL310_TAG_RAM_LATENCY_0_WRITE_SW_DEFAULT                        _MK_MASK_CONST(0x3)
#define PL310_TAG_RAM_LATENCY_0_WRITE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x7)


// Register PL310_DATA_RAM_LATENCY_0  
#define PL310_DATA_RAM_LATENCY_0                        _MK_ADDR_CONST(0x10c)
#define PL310_DATA_RAM_LATENCY_0_SECURE                         0x0
#define PL310_DATA_RAM_LATENCY_0_WORD_COUNT                     0x1
#define PL310_DATA_RAM_LATENCY_0_RESET_VAL                      _MK_MASK_CONST(0x777)
#define PL310_DATA_RAM_LATENCY_0_RESET_MASK                     _MK_MASK_CONST(0x777)
#define PL310_DATA_RAM_LATENCY_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x441)
#define PL310_DATA_RAM_LATENCY_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x777)
#define PL310_DATA_RAM_LATENCY_0_READ_MASK                      _MK_MASK_CONST(0x777)
#define PL310_DATA_RAM_LATENCY_0_WRITE_MASK                     _MK_MASK_CONST(0x777)
#define PL310_DATA_RAM_LATENCY_0_SETUP_SHIFT                    _MK_SHIFT_CONST(0)
#define PL310_DATA_RAM_LATENCY_0_SETUP_FIELD                    (_MK_MASK_CONST(0x7) << PL310_DATA_RAM_LATENCY_0_SETUP_SHIFT)
#define PL310_DATA_RAM_LATENCY_0_SETUP_RANGE                    2:0
#define PL310_DATA_RAM_LATENCY_0_SETUP_WOFFSET                  0x0
#define PL310_DATA_RAM_LATENCY_0_SETUP_DEFAULT                  _MK_MASK_CONST(0x7)
#define PL310_DATA_RAM_LATENCY_0_SETUP_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define PL310_DATA_RAM_LATENCY_0_SETUP_SW_DEFAULT                       _MK_MASK_CONST(0x1)
#define PL310_DATA_RAM_LATENCY_0_SETUP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x7)

#define PL310_DATA_RAM_LATENCY_0_READ_SHIFT                     _MK_SHIFT_CONST(4)
#define PL310_DATA_RAM_LATENCY_0_READ_FIELD                     (_MK_MASK_CONST(0x7) << PL310_DATA_RAM_LATENCY_0_READ_SHIFT)
#define PL310_DATA_RAM_LATENCY_0_READ_RANGE                     6:4
#define PL310_DATA_RAM_LATENCY_0_READ_WOFFSET                   0x0
#define PL310_DATA_RAM_LATENCY_0_READ_DEFAULT                   _MK_MASK_CONST(0x7)
#define PL310_DATA_RAM_LATENCY_0_READ_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define PL310_DATA_RAM_LATENCY_0_READ_SW_DEFAULT                        _MK_MASK_CONST(0x4)
#define PL310_DATA_RAM_LATENCY_0_READ_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x7)

#define PL310_DATA_RAM_LATENCY_0_WRITE_SHIFT                    _MK_SHIFT_CONST(8)
#define PL310_DATA_RAM_LATENCY_0_WRITE_FIELD                    (_MK_MASK_CONST(0x7) << PL310_DATA_RAM_LATENCY_0_WRITE_SHIFT)
#define PL310_DATA_RAM_LATENCY_0_WRITE_RANGE                    10:8
#define PL310_DATA_RAM_LATENCY_0_WRITE_WOFFSET                  0x0
#define PL310_DATA_RAM_LATENCY_0_WRITE_DEFAULT                  _MK_MASK_CONST(0x7)
#define PL310_DATA_RAM_LATENCY_0_WRITE_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define PL310_DATA_RAM_LATENCY_0_WRITE_SW_DEFAULT                       _MK_MASK_CONST(0x4)
#define PL310_DATA_RAM_LATENCY_0_WRITE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x7)


// Register PL310_EVENT_COUNTER_CONTROL_0  
#define PL310_EVENT_COUNTER_CONTROL_0                   _MK_ADDR_CONST(0x200)
#define PL310_EVENT_COUNTER_CONTROL_0_SECURE                    0x0
#define PL310_EVENT_COUNTER_CONTROL_0_WORD_COUNT                        0x1
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_MASK                        _MK_MASK_CONST(0x7)
#define PL310_EVENT_COUNTER_CONTROL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER_CONTROL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER_CONTROL_0_READ_MASK                         _MK_MASK_CONST(0x7)
#define PL310_EVENT_COUNTER_CONTROL_0_WRITE_MASK                        _MK_MASK_CONST(0x7)
#define PL310_EVENT_COUNTER_CONTROL_0_EVENT_COUNTING_SHIFT                      _MK_SHIFT_CONST(0)
#define PL310_EVENT_COUNTER_CONTROL_0_EVENT_COUNTING_FIELD                      (_MK_MASK_CONST(0x1) << PL310_EVENT_COUNTER_CONTROL_0_EVENT_COUNTING_SHIFT)
#define PL310_EVENT_COUNTER_CONTROL_0_EVENT_COUNTING_RANGE                      0:0
#define PL310_EVENT_COUNTER_CONTROL_0_EVENT_COUNTING_WOFFSET                    0x0
#define PL310_EVENT_COUNTER_CONTROL_0_EVENT_COUNTING_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER_CONTROL_0_EVENT_COUNTING_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define PL310_EVENT_COUNTER_CONTROL_0_EVENT_COUNTING_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER_CONTROL_0_EVENT_COUNTING_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER_CONTROL_0_EVENT_COUNTING_DISABLED                   _MK_ENUM_CONST(0)
#define PL310_EVENT_COUNTER_CONTROL_0_EVENT_COUNTING_ENABLED                    _MK_ENUM_CONST(1)

#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_0_SHIFT                     _MK_SHIFT_CONST(1)
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_0_FIELD                     (_MK_MASK_CONST(0x1) << PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_0_SHIFT)
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_0_RANGE                     1:1
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_0_WOFFSET                   0x0
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_0_CLEAR_COUNTER                     _MK_ENUM_CONST(1)

#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_1_SHIFT                     _MK_SHIFT_CONST(2)
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_1_FIELD                     (_MK_MASK_CONST(0x1) << PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_1_SHIFT)
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_1_RANGE                     2:2
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_1_WOFFSET                   0x0
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_1_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER_CONTROL_0_RESET_COUNTER_1_CLEAR_COUNTER                     _MK_ENUM_CONST(1)


// Register PL310_EVENT_COUNTER1_CONFIGURATION_0  
#define PL310_EVENT_COUNTER1_CONFIGURATION_0                    _MK_ADDR_CONST(0x204)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_SECURE                     0x0
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_WORD_COUNT                         0x1
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_RESET_MASK                         _MK_MASK_CONST(0x3f)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_READ_MASK                  _MK_MASK_CONST(0x3f)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_WRITE_MASK                         _MK_MASK_CONST(0x3f)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_COUNTER_INTERRUPT_SHIFT                    _MK_SHIFT_CONST(0)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_COUNTER_INTERRUPT_FIELD                    (_MK_MASK_CONST(0x3) << PL310_EVENT_COUNTER1_CONFIGURATION_0_COUNTER_INTERRUPT_SHIFT)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_COUNTER_INTERRUPT_RANGE                    1:0
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_COUNTER_INTERRUPT_WOFFSET                  0x0
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_COUNTER_INTERRUPT_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_COUNTER_INTERRUPT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_COUNTER_INTERRUPT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_COUNTER_INTERRUPT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_COUNTER_INTERRUPT_DISABLED                 _MK_ENUM_CONST(0)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_COUNTER_INTERRUPT_ENABLED_INCREMENT                        _MK_ENUM_CONST(1)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_COUNTER_INTERRUPT_ENABLED_OVERFLOW                 _MK_ENUM_CONST(2)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_COUNTER_INTERRUPT_RES_DISABLED                     _MK_ENUM_CONST(3)

#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_SHIFT                 _MK_SHIFT_CONST(2)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_FIELD                 (_MK_MASK_CONST(0xf) << PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_SHIFT)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_RANGE                 5:2
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_WOFFSET                       0x0
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_DISABLED                      _MK_ENUM_CONST(0)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_CO                    _MK_ENUM_CONST(1)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_EVICT                 _MK_ENUM_CONST(1)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_DRHIT                 _MK_ENUM_CONST(2)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_DRREQ                 _MK_ENUM_CONST(3)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_DWHIT                 _MK_ENUM_CONST(4)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_DWREQ                 _MK_ENUM_CONST(5)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_DWTREQ                        _MK_ENUM_CONST(6)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_IRHIT                 _MK_ENUM_CONST(7)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_IRREQ                 _MK_ENUM_CONST(8)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_WA                    _MK_ENUM_CONST(9)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_PF                    _MK_ENUM_CONST(10)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_RES_DISABLED_B                        _MK_ENUM_CONST(11)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_RES_DISABLED_C                        _MK_ENUM_CONST(12)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_RES_DISABLED_D                        _MK_ENUM_CONST(13)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_RES_DISABLED_E                        _MK_ENUM_CONST(14)
#define PL310_EVENT_COUNTER1_CONFIGURATION_0_EVENT_SOURCE_RES_DISABLED_F                        _MK_ENUM_CONST(15)


// Register PL310_EVENT_COUNTER0_CONFIGURATION_0  
#define PL310_EVENT_COUNTER0_CONFIGURATION_0                    _MK_ADDR_CONST(0x208)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_SECURE                     0x0
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_WORD_COUNT                         0x1
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_RESET_MASK                         _MK_MASK_CONST(0x3f)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_READ_MASK                  _MK_MASK_CONST(0x3f)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_WRITE_MASK                         _MK_MASK_CONST(0x3f)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_COUNTER_INTERRUPT_SHIFT                    _MK_SHIFT_CONST(0)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_COUNTER_INTERRUPT_FIELD                    (_MK_MASK_CONST(0x3) << PL310_EVENT_COUNTER0_CONFIGURATION_0_COUNTER_INTERRUPT_SHIFT)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_COUNTER_INTERRUPT_RANGE                    1:0
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_COUNTER_INTERRUPT_WOFFSET                  0x0
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_COUNTER_INTERRUPT_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_COUNTER_INTERRUPT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_COUNTER_INTERRUPT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_COUNTER_INTERRUPT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_COUNTER_INTERRUPT_DISABLED                 _MK_ENUM_CONST(0)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_COUNTER_INTERRUPT_ENABLED_INCREMENT                        _MK_ENUM_CONST(1)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_COUNTER_INTERRUPT_ENABLED_OVERFLOW                 _MK_ENUM_CONST(2)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_COUNTER_INTERRUPT_RES_DISABLED                     _MK_ENUM_CONST(3)

#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_SHIFT                 _MK_SHIFT_CONST(2)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_FIELD                 (_MK_MASK_CONST(0xf) << PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_SHIFT)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_RANGE                 5:2
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_WOFFSET                       0x0
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_DISABLED                      _MK_ENUM_CONST(0)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_CO                    _MK_ENUM_CONST(1)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_EVICT                 _MK_ENUM_CONST(1)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_DRHIT                 _MK_ENUM_CONST(2)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_DRREQ                 _MK_ENUM_CONST(3)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_DWHIT                 _MK_ENUM_CONST(4)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_DWREQ                 _MK_ENUM_CONST(5)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_DWTREQ                        _MK_ENUM_CONST(6)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_IRHIT                 _MK_ENUM_CONST(7)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_IRREQ                 _MK_ENUM_CONST(8)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_WA                    _MK_ENUM_CONST(9)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_PF                    _MK_ENUM_CONST(10)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_RES_DISABLED_B                        _MK_ENUM_CONST(11)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_RES_DISABLED_C                        _MK_ENUM_CONST(12)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_RES_DISABLED_D                        _MK_ENUM_CONST(13)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_RES_DISABLED_E                        _MK_ENUM_CONST(14)
#define PL310_EVENT_COUNTER0_CONFIGURATION_0_EVENT_SOURCE_RES_DISABLED_F                        _MK_ENUM_CONST(15)


// Register PL310_EVENT_COUNTER1_0  
#define PL310_EVENT_COUNTER1_0                  _MK_ADDR_CONST(0x20c)
#define PL310_EVENT_COUNTER1_0_SECURE                   0x0
#define PL310_EVENT_COUNTER1_0_WORD_COUNT                       0x1
#define PL310_EVENT_COUNTER1_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER1_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define PL310_EVENT_COUNTER1_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER1_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER1_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define PL310_EVENT_COUNTER1_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
#define PL310_EVENT_COUNTER1_0_VALUE_SHIFT                      _MK_SHIFT_CONST(0)
#define PL310_EVENT_COUNTER1_0_VALUE_FIELD                      (_MK_MASK_CONST(0xffffffff) << PL310_EVENT_COUNTER1_0_VALUE_SHIFT)
#define PL310_EVENT_COUNTER1_0_VALUE_RANGE                      31:0
#define PL310_EVENT_COUNTER1_0_VALUE_WOFFSET                    0x0
#define PL310_EVENT_COUNTER1_0_VALUE_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER1_0_VALUE_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define PL310_EVENT_COUNTER1_0_VALUE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER1_0_VALUE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register PL310_EVENT_COUNTER0_0  
#define PL310_EVENT_COUNTER0_0                  _MK_ADDR_CONST(0x210)
#define PL310_EVENT_COUNTER0_0_SECURE                   0x0
#define PL310_EVENT_COUNTER0_0_WORD_COUNT                       0x1
#define PL310_EVENT_COUNTER0_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER0_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define PL310_EVENT_COUNTER0_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER0_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER0_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define PL310_EVENT_COUNTER0_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
#define PL310_EVENT_COUNTER0_0_VALUE_SHIFT                      _MK_SHIFT_CONST(0)
#define PL310_EVENT_COUNTER0_0_VALUE_FIELD                      (_MK_MASK_CONST(0xffffffff) << PL310_EVENT_COUNTER0_0_VALUE_SHIFT)
#define PL310_EVENT_COUNTER0_0_VALUE_RANGE                      31:0
#define PL310_EVENT_COUNTER0_0_VALUE_WOFFSET                    0x0
#define PL310_EVENT_COUNTER0_0_VALUE_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER0_0_VALUE_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define PL310_EVENT_COUNTER0_0_VALUE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_EVENT_COUNTER0_0_VALUE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register PL310_INTERRUPT_MASK_0  
#define PL310_INTERRUPT_MASK_0                  _MK_ADDR_CONST(0x214)
#define PL310_INTERRUPT_MASK_0_SECURE                   0x0
#define PL310_INTERRUPT_MASK_0_WORD_COUNT                       0x1
#define PL310_INTERRUPT_MASK_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_RESET_MASK                       _MK_MASK_CONST(0x1ff)
#define PL310_INTERRUPT_MASK_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_READ_MASK                        _MK_MASK_CONST(0x1ff)
#define PL310_INTERRUPT_MASK_0_WRITE_MASK                       _MK_MASK_CONST(0x1ff)
#define PL310_INTERRUPT_MASK_0_ECNTR_SHIFT                      _MK_SHIFT_CONST(0)
#define PL310_INTERRUPT_MASK_0_ECNTR_FIELD                      (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_MASK_0_ECNTR_SHIFT)
#define PL310_INTERRUPT_MASK_0_ECNTR_RANGE                      0:0
#define PL310_INTERRUPT_MASK_0_ECNTR_WOFFSET                    0x0
#define PL310_INTERRUPT_MASK_0_ECNTR_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_ECNTR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_MASK_0_ECNTR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_ECNTR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define PL310_INTERRUPT_MASK_0_PARRT_SHIFT                      _MK_SHIFT_CONST(1)
#define PL310_INTERRUPT_MASK_0_PARRT_FIELD                      (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_MASK_0_PARRT_SHIFT)
#define PL310_INTERRUPT_MASK_0_PARRT_RANGE                      1:1
#define PL310_INTERRUPT_MASK_0_PARRT_WOFFSET                    0x0
#define PL310_INTERRUPT_MASK_0_PARRT_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_PARRT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_MASK_0_PARRT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_PARRT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define PL310_INTERRUPT_MASK_0_PARRD_SHIFT                      _MK_SHIFT_CONST(2)
#define PL310_INTERRUPT_MASK_0_PARRD_FIELD                      (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_MASK_0_PARRD_SHIFT)
#define PL310_INTERRUPT_MASK_0_PARRD_RANGE                      2:2
#define PL310_INTERRUPT_MASK_0_PARRD_WOFFSET                    0x0
#define PL310_INTERRUPT_MASK_0_PARRD_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_PARRD_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_MASK_0_PARRD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_PARRD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define PL310_INTERRUPT_MASK_0_ERRWT_SHIFT                      _MK_SHIFT_CONST(3)
#define PL310_INTERRUPT_MASK_0_ERRWT_FIELD                      (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_MASK_0_ERRWT_SHIFT)
#define PL310_INTERRUPT_MASK_0_ERRWT_RANGE                      3:3
#define PL310_INTERRUPT_MASK_0_ERRWT_WOFFSET                    0x0
#define PL310_INTERRUPT_MASK_0_ERRWT_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_ERRWT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_MASK_0_ERRWT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_ERRWT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define PL310_INTERRUPT_MASK_0_ERRWD_SHIFT                      _MK_SHIFT_CONST(4)
#define PL310_INTERRUPT_MASK_0_ERRWD_FIELD                      (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_MASK_0_ERRWD_SHIFT)
#define PL310_INTERRUPT_MASK_0_ERRWD_RANGE                      4:4
#define PL310_INTERRUPT_MASK_0_ERRWD_WOFFSET                    0x0
#define PL310_INTERRUPT_MASK_0_ERRWD_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_ERRWD_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_MASK_0_ERRWD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_ERRWD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define PL310_INTERRUPT_MASK_0_ERRRT_SHIFT                      _MK_SHIFT_CONST(5)
#define PL310_INTERRUPT_MASK_0_ERRRT_FIELD                      (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_MASK_0_ERRRT_SHIFT)
#define PL310_INTERRUPT_MASK_0_ERRRT_RANGE                      5:5
#define PL310_INTERRUPT_MASK_0_ERRRT_WOFFSET                    0x0
#define PL310_INTERRUPT_MASK_0_ERRRT_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_ERRRT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_MASK_0_ERRRT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_ERRRT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define PL310_INTERRUPT_MASK_0_ERRRD_SHIFT                      _MK_SHIFT_CONST(6)
#define PL310_INTERRUPT_MASK_0_ERRRD_FIELD                      (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_MASK_0_ERRRD_SHIFT)
#define PL310_INTERRUPT_MASK_0_ERRRD_RANGE                      6:6
#define PL310_INTERRUPT_MASK_0_ERRRD_WOFFSET                    0x0
#define PL310_INTERRUPT_MASK_0_ERRRD_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_ERRRD_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_MASK_0_ERRRD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_ERRRD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define PL310_INTERRUPT_MASK_0_SLVERR_SHIFT                     _MK_SHIFT_CONST(7)
#define PL310_INTERRUPT_MASK_0_SLVERR_FIELD                     (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_MASK_0_SLVERR_SHIFT)
#define PL310_INTERRUPT_MASK_0_SLVERR_RANGE                     7:7
#define PL310_INTERRUPT_MASK_0_SLVERR_WOFFSET                   0x0
#define PL310_INTERRUPT_MASK_0_SLVERR_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_SLVERR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_MASK_0_SLVERR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_SLVERR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_INTERRUPT_MASK_0_DECERR_SHIFT                     _MK_SHIFT_CONST(8)
#define PL310_INTERRUPT_MASK_0_DECERR_FIELD                     (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_MASK_0_DECERR_SHIFT)
#define PL310_INTERRUPT_MASK_0_DECERR_RANGE                     8:8
#define PL310_INTERRUPT_MASK_0_DECERR_WOFFSET                   0x0
#define PL310_INTERRUPT_MASK_0_DECERR_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_DECERR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_MASK_0_DECERR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_MASK_0_DECERR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register PL310_MASKED_INTERRUPT_STATUS_0  
#define PL310_MASKED_INTERRUPT_STATUS_0                 _MK_ADDR_CONST(0x218)
#define PL310_MASKED_INTERRUPT_STATUS_0_SECURE                  0x0
#define PL310_MASKED_INTERRUPT_STATUS_0_WORD_COUNT                      0x1
#define PL310_MASKED_INTERRUPT_STATUS_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_RESET_MASK                      _MK_MASK_CONST(0x1ff)
#define PL310_MASKED_INTERRUPT_STATUS_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_READ_MASK                       _MK_MASK_CONST(0x1ff)
#define PL310_MASKED_INTERRUPT_STATUS_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_ECNTR_SHIFT                     _MK_SHIFT_CONST(0)
#define PL310_MASKED_INTERRUPT_STATUS_0_ECNTR_FIELD                     (_MK_MASK_CONST(0x1) << PL310_MASKED_INTERRUPT_STATUS_0_ECNTR_SHIFT)
#define PL310_MASKED_INTERRUPT_STATUS_0_ECNTR_RANGE                     0:0
#define PL310_MASKED_INTERRUPT_STATUS_0_ECNTR_WOFFSET                   0x0
#define PL310_MASKED_INTERRUPT_STATUS_0_ECNTR_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_ECNTR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_MASKED_INTERRUPT_STATUS_0_ECNTR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_ECNTR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_MASKED_INTERRUPT_STATUS_0_PARRT_SHIFT                     _MK_SHIFT_CONST(1)
#define PL310_MASKED_INTERRUPT_STATUS_0_PARRT_FIELD                     (_MK_MASK_CONST(0x1) << PL310_MASKED_INTERRUPT_STATUS_0_PARRT_SHIFT)
#define PL310_MASKED_INTERRUPT_STATUS_0_PARRT_RANGE                     1:1
#define PL310_MASKED_INTERRUPT_STATUS_0_PARRT_WOFFSET                   0x0
#define PL310_MASKED_INTERRUPT_STATUS_0_PARRT_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_PARRT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_MASKED_INTERRUPT_STATUS_0_PARRT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_PARRT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_MASKED_INTERRUPT_STATUS_0_PARRD_SHIFT                     _MK_SHIFT_CONST(2)
#define PL310_MASKED_INTERRUPT_STATUS_0_PARRD_FIELD                     (_MK_MASK_CONST(0x1) << PL310_MASKED_INTERRUPT_STATUS_0_PARRD_SHIFT)
#define PL310_MASKED_INTERRUPT_STATUS_0_PARRD_RANGE                     2:2
#define PL310_MASKED_INTERRUPT_STATUS_0_PARRD_WOFFSET                   0x0
#define PL310_MASKED_INTERRUPT_STATUS_0_PARRD_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_PARRD_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_MASKED_INTERRUPT_STATUS_0_PARRD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_PARRD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_MASKED_INTERRUPT_STATUS_0_ERRWT_SHIFT                     _MK_SHIFT_CONST(3)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRWT_FIELD                     (_MK_MASK_CONST(0x1) << PL310_MASKED_INTERRUPT_STATUS_0_ERRWT_SHIFT)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRWT_RANGE                     3:3
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRWT_WOFFSET                   0x0
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRWT_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRWT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRWT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRWT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_MASKED_INTERRUPT_STATUS_0_ERRWD_SHIFT                     _MK_SHIFT_CONST(4)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRWD_FIELD                     (_MK_MASK_CONST(0x1) << PL310_MASKED_INTERRUPT_STATUS_0_ERRWD_SHIFT)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRWD_RANGE                     4:4
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRWD_WOFFSET                   0x0
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRWD_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRWD_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRWD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRWD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_MASKED_INTERRUPT_STATUS_0_ERRRT_SHIFT                     _MK_SHIFT_CONST(5)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRRT_FIELD                     (_MK_MASK_CONST(0x1) << PL310_MASKED_INTERRUPT_STATUS_0_ERRRT_SHIFT)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRRT_RANGE                     5:5
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRRT_WOFFSET                   0x0
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRRT_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRRT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRRT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRRT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_MASKED_INTERRUPT_STATUS_0_ERRRD_SHIFT                     _MK_SHIFT_CONST(6)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRRD_FIELD                     (_MK_MASK_CONST(0x1) << PL310_MASKED_INTERRUPT_STATUS_0_ERRRD_SHIFT)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRRD_RANGE                     6:6
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRRD_WOFFSET                   0x0
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRRD_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRRD_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRRD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_ERRRD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_MASKED_INTERRUPT_STATUS_0_SLVERR_SHIFT                    _MK_SHIFT_CONST(7)
#define PL310_MASKED_INTERRUPT_STATUS_0_SLVERR_FIELD                    (_MK_MASK_CONST(0x1) << PL310_MASKED_INTERRUPT_STATUS_0_SLVERR_SHIFT)
#define PL310_MASKED_INTERRUPT_STATUS_0_SLVERR_RANGE                    7:7
#define PL310_MASKED_INTERRUPT_STATUS_0_SLVERR_WOFFSET                  0x0
#define PL310_MASKED_INTERRUPT_STATUS_0_SLVERR_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_SLVERR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define PL310_MASKED_INTERRUPT_STATUS_0_SLVERR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_SLVERR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define PL310_MASKED_INTERRUPT_STATUS_0_DECERR_SHIFT                    _MK_SHIFT_CONST(8)
#define PL310_MASKED_INTERRUPT_STATUS_0_DECERR_FIELD                    (_MK_MASK_CONST(0x1) << PL310_MASKED_INTERRUPT_STATUS_0_DECERR_SHIFT)
#define PL310_MASKED_INTERRUPT_STATUS_0_DECERR_RANGE                    8:8
#define PL310_MASKED_INTERRUPT_STATUS_0_DECERR_WOFFSET                  0x0
#define PL310_MASKED_INTERRUPT_STATUS_0_DECERR_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_DECERR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define PL310_MASKED_INTERRUPT_STATUS_0_DECERR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_MASKED_INTERRUPT_STATUS_0_DECERR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register PL310_RAW_INTERRUPT_STATUS_0  
#define PL310_RAW_INTERRUPT_STATUS_0                    _MK_ADDR_CONST(0x21c)
#define PL310_RAW_INTERRUPT_STATUS_0_SECURE                     0x0
#define PL310_RAW_INTERRUPT_STATUS_0_WORD_COUNT                         0x1
#define PL310_RAW_INTERRUPT_STATUS_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_RESET_MASK                         _MK_MASK_CONST(0x1ff)
#define PL310_RAW_INTERRUPT_STATUS_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_READ_MASK                  _MK_MASK_CONST(0x1ff)
#define PL310_RAW_INTERRUPT_STATUS_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_ECNTR_SHIFT                        _MK_SHIFT_CONST(0)
#define PL310_RAW_INTERRUPT_STATUS_0_ECNTR_FIELD                        (_MK_MASK_CONST(0x1) << PL310_RAW_INTERRUPT_STATUS_0_ECNTR_SHIFT)
#define PL310_RAW_INTERRUPT_STATUS_0_ECNTR_RANGE                        0:0
#define PL310_RAW_INTERRUPT_STATUS_0_ECNTR_WOFFSET                      0x0
#define PL310_RAW_INTERRUPT_STATUS_0_ECNTR_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_ECNTR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define PL310_RAW_INTERRUPT_STATUS_0_ECNTR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_ECNTR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define PL310_RAW_INTERRUPT_STATUS_0_PARRT_SHIFT                        _MK_SHIFT_CONST(1)
#define PL310_RAW_INTERRUPT_STATUS_0_PARRT_FIELD                        (_MK_MASK_CONST(0x1) << PL310_RAW_INTERRUPT_STATUS_0_PARRT_SHIFT)
#define PL310_RAW_INTERRUPT_STATUS_0_PARRT_RANGE                        1:1
#define PL310_RAW_INTERRUPT_STATUS_0_PARRT_WOFFSET                      0x0
#define PL310_RAW_INTERRUPT_STATUS_0_PARRT_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_PARRT_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define PL310_RAW_INTERRUPT_STATUS_0_PARRT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_PARRT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define PL310_RAW_INTERRUPT_STATUS_0_PARRD_SHIFT                        _MK_SHIFT_CONST(2)
#define PL310_RAW_INTERRUPT_STATUS_0_PARRD_FIELD                        (_MK_MASK_CONST(0x1) << PL310_RAW_INTERRUPT_STATUS_0_PARRD_SHIFT)
#define PL310_RAW_INTERRUPT_STATUS_0_PARRD_RANGE                        2:2
#define PL310_RAW_INTERRUPT_STATUS_0_PARRD_WOFFSET                      0x0
#define PL310_RAW_INTERRUPT_STATUS_0_PARRD_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_PARRD_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define PL310_RAW_INTERRUPT_STATUS_0_PARRD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_PARRD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define PL310_RAW_INTERRUPT_STATUS_0_ERRWT_SHIFT                        _MK_SHIFT_CONST(3)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRWT_FIELD                        (_MK_MASK_CONST(0x1) << PL310_RAW_INTERRUPT_STATUS_0_ERRWT_SHIFT)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRWT_RANGE                        3:3
#define PL310_RAW_INTERRUPT_STATUS_0_ERRWT_WOFFSET                      0x0
#define PL310_RAW_INTERRUPT_STATUS_0_ERRWT_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRWT_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRWT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRWT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define PL310_RAW_INTERRUPT_STATUS_0_ERRWD_SHIFT                        _MK_SHIFT_CONST(4)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRWD_FIELD                        (_MK_MASK_CONST(0x1) << PL310_RAW_INTERRUPT_STATUS_0_ERRWD_SHIFT)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRWD_RANGE                        4:4
#define PL310_RAW_INTERRUPT_STATUS_0_ERRWD_WOFFSET                      0x0
#define PL310_RAW_INTERRUPT_STATUS_0_ERRWD_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRWD_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRWD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRWD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define PL310_RAW_INTERRUPT_STATUS_0_ERRRT_SHIFT                        _MK_SHIFT_CONST(5)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRRT_FIELD                        (_MK_MASK_CONST(0x1) << PL310_RAW_INTERRUPT_STATUS_0_ERRRT_SHIFT)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRRT_RANGE                        5:5
#define PL310_RAW_INTERRUPT_STATUS_0_ERRRT_WOFFSET                      0x0
#define PL310_RAW_INTERRUPT_STATUS_0_ERRRT_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRRT_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRRT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRRT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define PL310_RAW_INTERRUPT_STATUS_0_ERRRD_SHIFT                        _MK_SHIFT_CONST(6)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRRD_FIELD                        (_MK_MASK_CONST(0x1) << PL310_RAW_INTERRUPT_STATUS_0_ERRRD_SHIFT)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRRD_RANGE                        6:6
#define PL310_RAW_INTERRUPT_STATUS_0_ERRRD_WOFFSET                      0x0
#define PL310_RAW_INTERRUPT_STATUS_0_ERRRD_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRRD_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRRD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_ERRRD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define PL310_RAW_INTERRUPT_STATUS_0_SLVERR_SHIFT                       _MK_SHIFT_CONST(7)
#define PL310_RAW_INTERRUPT_STATUS_0_SLVERR_FIELD                       (_MK_MASK_CONST(0x1) << PL310_RAW_INTERRUPT_STATUS_0_SLVERR_SHIFT)
#define PL310_RAW_INTERRUPT_STATUS_0_SLVERR_RANGE                       7:7
#define PL310_RAW_INTERRUPT_STATUS_0_SLVERR_WOFFSET                     0x0
#define PL310_RAW_INTERRUPT_STATUS_0_SLVERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_SLVERR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define PL310_RAW_INTERRUPT_STATUS_0_SLVERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_SLVERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define PL310_RAW_INTERRUPT_STATUS_0_DECERR_SHIFT                       _MK_SHIFT_CONST(8)
#define PL310_RAW_INTERRUPT_STATUS_0_DECERR_FIELD                       (_MK_MASK_CONST(0x1) << PL310_RAW_INTERRUPT_STATUS_0_DECERR_SHIFT)
#define PL310_RAW_INTERRUPT_STATUS_0_DECERR_RANGE                       8:8
#define PL310_RAW_INTERRUPT_STATUS_0_DECERR_WOFFSET                     0x0
#define PL310_RAW_INTERRUPT_STATUS_0_DECERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_DECERR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define PL310_RAW_INTERRUPT_STATUS_0_DECERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_RAW_INTERRUPT_STATUS_0_DECERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register PL310_INTERRUPT_CLEAR_0  
#define PL310_INTERRUPT_CLEAR_0                 _MK_ADDR_CONST(0x220)
#define PL310_INTERRUPT_CLEAR_0_SECURE                  0x0
#define PL310_INTERRUPT_CLEAR_0_WORD_COUNT                      0x1
#define PL310_INTERRUPT_CLEAR_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_RESET_MASK                      _MK_MASK_CONST(0x1ff)
#define PL310_INTERRUPT_CLEAR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_READ_MASK                       _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_WRITE_MASK                      _MK_MASK_CONST(0x1ff)
#define PL310_INTERRUPT_CLEAR_0_ECNTR_SHIFT                     _MK_SHIFT_CONST(0)
#define PL310_INTERRUPT_CLEAR_0_ECNTR_FIELD                     (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_CLEAR_0_ECNTR_SHIFT)
#define PL310_INTERRUPT_CLEAR_0_ECNTR_RANGE                     0:0
#define PL310_INTERRUPT_CLEAR_0_ECNTR_WOFFSET                   0x0
#define PL310_INTERRUPT_CLEAR_0_ECNTR_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_ECNTR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_CLEAR_0_ECNTR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_ECNTR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_INTERRUPT_CLEAR_0_PARRT_SHIFT                     _MK_SHIFT_CONST(1)
#define PL310_INTERRUPT_CLEAR_0_PARRT_FIELD                     (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_CLEAR_0_PARRT_SHIFT)
#define PL310_INTERRUPT_CLEAR_0_PARRT_RANGE                     1:1
#define PL310_INTERRUPT_CLEAR_0_PARRT_WOFFSET                   0x0
#define PL310_INTERRUPT_CLEAR_0_PARRT_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_PARRT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_CLEAR_0_PARRT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_PARRT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_INTERRUPT_CLEAR_0_PARRD_SHIFT                     _MK_SHIFT_CONST(2)
#define PL310_INTERRUPT_CLEAR_0_PARRD_FIELD                     (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_CLEAR_0_PARRD_SHIFT)
#define PL310_INTERRUPT_CLEAR_0_PARRD_RANGE                     2:2
#define PL310_INTERRUPT_CLEAR_0_PARRD_WOFFSET                   0x0
#define PL310_INTERRUPT_CLEAR_0_PARRD_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_PARRD_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_CLEAR_0_PARRD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_PARRD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_INTERRUPT_CLEAR_0_ERRWT_SHIFT                     _MK_SHIFT_CONST(3)
#define PL310_INTERRUPT_CLEAR_0_ERRWT_FIELD                     (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_CLEAR_0_ERRWT_SHIFT)
#define PL310_INTERRUPT_CLEAR_0_ERRWT_RANGE                     3:3
#define PL310_INTERRUPT_CLEAR_0_ERRWT_WOFFSET                   0x0
#define PL310_INTERRUPT_CLEAR_0_ERRWT_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_ERRWT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_CLEAR_0_ERRWT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_ERRWT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_INTERRUPT_CLEAR_0_ERRWD_SHIFT                     _MK_SHIFT_CONST(4)
#define PL310_INTERRUPT_CLEAR_0_ERRWD_FIELD                     (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_CLEAR_0_ERRWD_SHIFT)
#define PL310_INTERRUPT_CLEAR_0_ERRWD_RANGE                     4:4
#define PL310_INTERRUPT_CLEAR_0_ERRWD_WOFFSET                   0x0
#define PL310_INTERRUPT_CLEAR_0_ERRWD_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_ERRWD_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_CLEAR_0_ERRWD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_ERRWD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_INTERRUPT_CLEAR_0_ERRRT_SHIFT                     _MK_SHIFT_CONST(5)
#define PL310_INTERRUPT_CLEAR_0_ERRRT_FIELD                     (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_CLEAR_0_ERRRT_SHIFT)
#define PL310_INTERRUPT_CLEAR_0_ERRRT_RANGE                     5:5
#define PL310_INTERRUPT_CLEAR_0_ERRRT_WOFFSET                   0x0
#define PL310_INTERRUPT_CLEAR_0_ERRRT_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_ERRRT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_CLEAR_0_ERRRT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_ERRRT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_INTERRUPT_CLEAR_0_ERRRD_SHIFT                     _MK_SHIFT_CONST(6)
#define PL310_INTERRUPT_CLEAR_0_ERRRD_FIELD                     (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_CLEAR_0_ERRRD_SHIFT)
#define PL310_INTERRUPT_CLEAR_0_ERRRD_RANGE                     6:6
#define PL310_INTERRUPT_CLEAR_0_ERRRD_WOFFSET                   0x0
#define PL310_INTERRUPT_CLEAR_0_ERRRD_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_ERRRD_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_CLEAR_0_ERRRD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_ERRRD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_INTERRUPT_CLEAR_0_SLVERR_SHIFT                    _MK_SHIFT_CONST(7)
#define PL310_INTERRUPT_CLEAR_0_SLVERR_FIELD                    (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_CLEAR_0_SLVERR_SHIFT)
#define PL310_INTERRUPT_CLEAR_0_SLVERR_RANGE                    7:7
#define PL310_INTERRUPT_CLEAR_0_SLVERR_WOFFSET                  0x0
#define PL310_INTERRUPT_CLEAR_0_SLVERR_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_SLVERR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_CLEAR_0_SLVERR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_SLVERR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define PL310_INTERRUPT_CLEAR_0_DECERR_SHIFT                    _MK_SHIFT_CONST(8)
#define PL310_INTERRUPT_CLEAR_0_DECERR_FIELD                    (_MK_MASK_CONST(0x1) << PL310_INTERRUPT_CLEAR_0_DECERR_SHIFT)
#define PL310_INTERRUPT_CLEAR_0_DECERR_RANGE                    8:8
#define PL310_INTERRUPT_CLEAR_0_DECERR_WOFFSET                  0x0
#define PL310_INTERRUPT_CLEAR_0_DECERR_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_DECERR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define PL310_INTERRUPT_CLEAR_0_DECERR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_INTERRUPT_CLEAR_0_DECERR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Reserved address 768 [0x300] 

// Reserved address 1024 [0x400] 

// Reserved address 1280 [0x500] 

// Reserved address 1536 [0x600] 

// Reserved address 1792 [0x700] 

// Reserved address 1793 [0x701] 

// Reserved address 1794 [0x702] 

// Reserved address 1795 [0x703] 

// Reserved address 1796 [0x704] 

// Reserved address 1797 [0x705] 

// Reserved address 1798 [0x706] 

// Reserved address 1799 [0x707] 

// Reserved address 1800 [0x708] 

// Reserved address 1801 [0x709] 

// Reserved address 1802 [0x70a] 

// Reserved address 1803 [0x70b] 

// Reserved address 1804 [0x70c] 

// Reserved address 1805 [0x70d] 

// Reserved address 1806 [0x70e] 

// Reserved address 1807 [0x70f] 

// Reserved address 1808 [0x710] 

// Reserved address 1809 [0x711] 

// Reserved address 1810 [0x712] 

// Reserved address 1811 [0x713] 

// Reserved address 1812 [0x714] 

// Reserved address 1813 [0x715] 

// Reserved address 1814 [0x716] 

// Reserved address 1815 [0x717] 

// Reserved address 1816 [0x718] 

// Reserved address 1817 [0x719] 

// Reserved address 1818 [0x71a] 

// Reserved address 1819 [0x71b] 

// Reserved address 1820 [0x71c] 

// Reserved address 1821 [0x71d] 

// Reserved address 1822 [0x71e] 

// Reserved address 1823 [0x71f] 

// Reserved address 1824 [0x720] 

// Reserved address 1825 [0x721] 

// Reserved address 1826 [0x722] 

// Reserved address 1827 [0x723] 

// Reserved address 1828 [0x724] 

// Reserved address 1829 [0x725] 

// Reserved address 1830 [0x726] 

// Reserved address 1831 [0x727] 

// Reserved address 1832 [0x728] 

// Reserved address 1833 [0x729] 

// Reserved address 1834 [0x72a] 

// Reserved address 1835 [0x72b] 

// Reserved address 1836 [0x72c] 

// Reserved address 1837 [0x72d] 

// Reserved address 1838 [0x72e] 

// Reserved address 1839 [0x72f] 

// Register PL310_CACHE_SYNC_0  
#define PL310_CACHE_SYNC_0                      _MK_ADDR_CONST(0x730)
#define PL310_CACHE_SYNC_0_SECURE                       0x0
#define PL310_CACHE_SYNC_0_WORD_COUNT                   0x1
#define PL310_CACHE_SYNC_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define PL310_CACHE_SYNC_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define PL310_CACHE_SYNC_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define PL310_CACHE_SYNC_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define PL310_CACHE_SYNC_0_READ_MASK                    _MK_MASK_CONST(0x0)
#define PL310_CACHE_SYNC_0_WRITE_MASK                   _MK_MASK_CONST(0x1)
#define PL310_CACHE_SYNC_0_DUMMY_BIT_TO_KEEP_SIMSPEC_HAPPY_SHIFT                        _MK_SHIFT_CONST(0)
#define PL310_CACHE_SYNC_0_DUMMY_BIT_TO_KEEP_SIMSPEC_HAPPY_FIELD                        (_MK_MASK_CONST(0x1) << PL310_CACHE_SYNC_0_DUMMY_BIT_TO_KEEP_SIMSPEC_HAPPY_SHIFT)
#define PL310_CACHE_SYNC_0_DUMMY_BIT_TO_KEEP_SIMSPEC_HAPPY_RANGE                        0:0
#define PL310_CACHE_SYNC_0_DUMMY_BIT_TO_KEEP_SIMSPEC_HAPPY_WOFFSET                      0x0
#define PL310_CACHE_SYNC_0_DUMMY_BIT_TO_KEEP_SIMSPEC_HAPPY_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_CACHE_SYNC_0_DUMMY_BIT_TO_KEEP_SIMSPEC_HAPPY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define PL310_CACHE_SYNC_0_DUMMY_BIT_TO_KEEP_SIMSPEC_HAPPY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_CACHE_SYNC_0_DUMMY_BIT_TO_KEEP_SIMSPEC_HAPPY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Reserved address 1844 [0x734] 

// Reserved address 1845 [0x735] 

// Reserved address 1846 [0x736] 

// Reserved address 1847 [0x737] 

// Reserved address 1848 [0x738] 

// Reserved address 1849 [0x739] 

// Reserved address 1850 [0x73a] 

// Reserved address 1851 [0x73b] 

// Reserved address 1852 [0x73c] 

// Reserved address 1853 [0x73d] 

// Reserved address 1854 [0x73e] 

// Reserved address 1855 [0x73f] 

// Reserved address 1856 [0x740] 

// Reserved address 1857 [0x741] 

// Reserved address 1858 [0x742] 

// Reserved address 1859 [0x743] 

// Reserved address 1860 [0x744] 

// Reserved address 1861 [0x745] 

// Reserved address 1862 [0x746] 

// Reserved address 1863 [0x747] 

// Reserved address 1864 [0x748] 

// Reserved address 1865 [0x749] 

// Reserved address 1866 [0x74a] 

// Reserved address 1867 [0x74b] 

// Reserved address 1868 [0x74c] 

// Reserved address 1869 [0x74d] 

// Reserved address 1870 [0x74e] 

// Reserved address 1871 [0x74f] 

// Reserved address 1872 [0x750] 

// Reserved address 1873 [0x751] 

// Reserved address 1874 [0x752] 

// Reserved address 1875 [0x753] 

// Reserved address 1876 [0x754] 

// Reserved address 1877 [0x755] 

// Reserved address 1878 [0x756] 

// Reserved address 1879 [0x757] 

// Reserved address 1880 [0x758] 

// Reserved address 1881 [0x759] 

// Reserved address 1882 [0x75a] 

// Reserved address 1883 [0x75b] 

// Reserved address 1884 [0x75c] 

// Reserved address 1885 [0x75d] 

// Reserved address 1886 [0x75e] 

// Reserved address 1887 [0x75f] 

// Reserved address 1888 [0x760] 

// Reserved address 1889 [0x761] 

// Reserved address 1890 [0x762] 

// Reserved address 1891 [0x763] 

// Reserved address 1892 [0x764] 

// Reserved address 1893 [0x765] 

// Reserved address 1894 [0x766] 

// Reserved address 1895 [0x767] 

// Reserved address 1896 [0x768] 

// Reserved address 1897 [0x769] 

// Reserved address 1898 [0x76a] 

// Reserved address 1899 [0x76b] 

// Reserved address 1900 [0x76c] 

// Reserved address 1901 [0x76d] 

// Reserved address 1902 [0x76e] 

// Reserved address 1903 [0x76f] 

// Register PL310_INVALIDATE_LINE_BY_PA_0  
#define PL310_INVALIDATE_LINE_BY_PA_0                   _MK_ADDR_CONST(0x770)
#define PL310_INVALIDATE_LINE_BY_PA_0_SECURE                    0x0
#define PL310_INVALIDATE_LINE_BY_PA_0_WORD_COUNT                        0x1
#define PL310_INVALIDATE_LINE_BY_PA_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_LINE_BY_PA_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define PL310_INVALIDATE_LINE_BY_PA_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_LINE_BY_PA_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_LINE_BY_PA_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define PL310_INVALIDATE_LINE_BY_PA_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
#define PL310_INVALIDATE_LINE_BY_PA_0_C_SHIFT                   _MK_SHIFT_CONST(0)
#define PL310_INVALIDATE_LINE_BY_PA_0_C_FIELD                   (_MK_MASK_CONST(0x1) << PL310_INVALIDATE_LINE_BY_PA_0_C_SHIFT)
#define PL310_INVALIDATE_LINE_BY_PA_0_C_RANGE                   0:0
#define PL310_INVALIDATE_LINE_BY_PA_0_C_WOFFSET                 0x0
#define PL310_INVALIDATE_LINE_BY_PA_0_C_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_LINE_BY_PA_0_C_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define PL310_INVALIDATE_LINE_BY_PA_0_C_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_LINE_BY_PA_0_C_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define PL310_INVALIDATE_LINE_BY_PA_0_BUSY_SHIFT                        _MK_SHIFT_CONST(0)
#define PL310_INVALIDATE_LINE_BY_PA_0_BUSY_FIELD                        (_MK_MASK_CONST(0x1) << PL310_INVALIDATE_LINE_BY_PA_0_BUSY_SHIFT)
#define PL310_INVALIDATE_LINE_BY_PA_0_BUSY_RANGE                        0:0
#define PL310_INVALIDATE_LINE_BY_PA_0_BUSY_WOFFSET                      0x0
#define PL310_INVALIDATE_LINE_BY_PA_0_BUSY_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_LINE_BY_PA_0_BUSY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define PL310_INVALIDATE_LINE_BY_PA_0_BUSY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_LINE_BY_PA_0_BUSY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define PL310_INVALIDATE_LINE_BY_PA_0_SBZ_SHIFT                 _MK_SHIFT_CONST(1)
#define PL310_INVALIDATE_LINE_BY_PA_0_SBZ_FIELD                 (_MK_MASK_CONST(0xf) << PL310_INVALIDATE_LINE_BY_PA_0_SBZ_SHIFT)
#define PL310_INVALIDATE_LINE_BY_PA_0_SBZ_RANGE                 4:1
#define PL310_INVALIDATE_LINE_BY_PA_0_SBZ_WOFFSET                       0x0
#define PL310_INVALIDATE_LINE_BY_PA_0_SBZ_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_LINE_BY_PA_0_SBZ_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define PL310_INVALIDATE_LINE_BY_PA_0_SBZ_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_LINE_BY_PA_0_SBZ_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define PL310_INVALIDATE_LINE_BY_PA_0_PA_MSB_SHIFT                      _MK_SHIFT_CONST(5)
#define PL310_INVALIDATE_LINE_BY_PA_0_PA_MSB_FIELD                      (_MK_MASK_CONST(0x7ffffff) << PL310_INVALIDATE_LINE_BY_PA_0_PA_MSB_SHIFT)
#define PL310_INVALIDATE_LINE_BY_PA_0_PA_MSB_RANGE                      31:5
#define PL310_INVALIDATE_LINE_BY_PA_0_PA_MSB_WOFFSET                    0x0
#define PL310_INVALIDATE_LINE_BY_PA_0_PA_MSB_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_LINE_BY_PA_0_PA_MSB_DEFAULT_MASK                       _MK_MASK_CONST(0x7ffffff)
#define PL310_INVALIDATE_LINE_BY_PA_0_PA_MSB_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_LINE_BY_PA_0_PA_MSB_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Reserved address 1908 [0x774] 

// Reserved address 1912 [0x778] 

// Register PL310_INVALIDATE_BY_WAY_0  
#define PL310_INVALIDATE_BY_WAY_0                       _MK_ADDR_CONST(0x77c)
#define PL310_INVALIDATE_BY_WAY_0_SECURE                        0x0
#define PL310_INVALIDATE_BY_WAY_0_WORD_COUNT                    0x1
#define PL310_INVALIDATE_BY_WAY_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_BY_WAY_0_RESET_MASK                    _MK_MASK_CONST(0xff)
#define PL310_INVALIDATE_BY_WAY_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_BY_WAY_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_BY_WAY_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define PL310_INVALIDATE_BY_WAY_0_WRITE_MASK                    _MK_MASK_CONST(0xff)
#define PL310_INVALIDATE_BY_WAY_0_WAY_BITMAP_SHIFT                      _MK_SHIFT_CONST(0)
#define PL310_INVALIDATE_BY_WAY_0_WAY_BITMAP_FIELD                      (_MK_MASK_CONST(0xff) << PL310_INVALIDATE_BY_WAY_0_WAY_BITMAP_SHIFT)
#define PL310_INVALIDATE_BY_WAY_0_WAY_BITMAP_RANGE                      7:0
#define PL310_INVALIDATE_BY_WAY_0_WAY_BITMAP_WOFFSET                    0x0
#define PL310_INVALIDATE_BY_WAY_0_WAY_BITMAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_BY_WAY_0_WAY_BITMAP_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define PL310_INVALIDATE_BY_WAY_0_WAY_BITMAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_BY_WAY_0_WAY_BITMAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define PL310_INVALIDATE_BY_WAY_0_WAY_BITMAP_NO_WAYS                    _MK_ENUM_CONST(0)
#define PL310_INVALIDATE_BY_WAY_0_WAY_BITMAP_EMPTY                      _MK_ENUM_CONST(0)
#define PL310_INVALIDATE_BY_WAY_0_WAY_BITMAP_ALL_WAYS                   _MK_ENUM_CONST(255)


// Reserved address 1920 [0x780] 

// Reserved address 1921 [0x781] 

// Reserved address 1922 [0x782] 

// Reserved address 1923 [0x783] 

// Reserved address 1924 [0x784] 

// Reserved address 1925 [0x785] 

// Reserved address 1926 [0x786] 

// Reserved address 1927 [0x787] 

// Reserved address 1928 [0x788] 

// Reserved address 1929 [0x789] 

// Reserved address 1930 [0x78a] 

// Reserved address 1931 [0x78b] 

// Reserved address 1932 [0x78c] 

// Reserved address 1933 [0x78d] 

// Reserved address 1934 [0x78e] 

// Reserved address 1935 [0x78f] 

// Reserved address 1936 [0x790] 

// Reserved address 1937 [0x791] 

// Reserved address 1938 [0x792] 

// Reserved address 1939 [0x793] 

// Reserved address 1940 [0x794] 

// Reserved address 1941 [0x795] 

// Reserved address 1942 [0x796] 

// Reserved address 1943 [0x797] 

// Reserved address 1944 [0x798] 

// Reserved address 1945 [0x799] 

// Reserved address 1946 [0x79a] 

// Reserved address 1947 [0x79b] 

// Reserved address 1948 [0x79c] 

// Reserved address 1949 [0x79d] 

// Reserved address 1950 [0x79e] 

// Reserved address 1951 [0x79f] 

// Reserved address 1952 [0x7a0] 

// Reserved address 1953 [0x7a1] 

// Reserved address 1954 [0x7a2] 

// Reserved address 1955 [0x7a3] 

// Reserved address 1956 [0x7a4] 

// Reserved address 1957 [0x7a5] 

// Reserved address 1958 [0x7a6] 

// Reserved address 1959 [0x7a7] 

// Reserved address 1960 [0x7a8] 

// Reserved address 1961 [0x7a9] 

// Reserved address 1962 [0x7aa] 

// Reserved address 1963 [0x7ab] 

// Reserved address 1964 [0x7ac] 

// Reserved address 1965 [0x7ad] 

// Reserved address 1966 [0x7ae] 

// Reserved address 1967 [0x7af] 

// Register PL310_CLEAN_LINE_BY_PA_0  
#define PL310_CLEAN_LINE_BY_PA_0                        _MK_ADDR_CONST(0x7b0)
#define PL310_CLEAN_LINE_BY_PA_0_SECURE                         0x0
#define PL310_CLEAN_LINE_BY_PA_0_WORD_COUNT                     0x1
#define PL310_CLEAN_LINE_BY_PA_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_PA_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define PL310_CLEAN_LINE_BY_PA_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_PA_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_PA_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define PL310_CLEAN_LINE_BY_PA_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
#define PL310_CLEAN_LINE_BY_PA_0_C_SHIFT                        _MK_SHIFT_CONST(0)
#define PL310_CLEAN_LINE_BY_PA_0_C_FIELD                        (_MK_MASK_CONST(0x1) << PL310_CLEAN_LINE_BY_PA_0_C_SHIFT)
#define PL310_CLEAN_LINE_BY_PA_0_C_RANGE                        0:0
#define PL310_CLEAN_LINE_BY_PA_0_C_WOFFSET                      0x0
#define PL310_CLEAN_LINE_BY_PA_0_C_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_PA_0_C_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define PL310_CLEAN_LINE_BY_PA_0_C_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_PA_0_C_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define PL310_CLEAN_LINE_BY_PA_0_BUSY_SHIFT                     _MK_SHIFT_CONST(0)
#define PL310_CLEAN_LINE_BY_PA_0_BUSY_FIELD                     (_MK_MASK_CONST(0x1) << PL310_CLEAN_LINE_BY_PA_0_BUSY_SHIFT)
#define PL310_CLEAN_LINE_BY_PA_0_BUSY_RANGE                     0:0
#define PL310_CLEAN_LINE_BY_PA_0_BUSY_WOFFSET                   0x0
#define PL310_CLEAN_LINE_BY_PA_0_BUSY_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_PA_0_BUSY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_CLEAN_LINE_BY_PA_0_BUSY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_PA_0_BUSY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_CLEAN_LINE_BY_PA_0_SBZ_SHIFT                      _MK_SHIFT_CONST(1)
#define PL310_CLEAN_LINE_BY_PA_0_SBZ_FIELD                      (_MK_MASK_CONST(0xf) << PL310_CLEAN_LINE_BY_PA_0_SBZ_SHIFT)
#define PL310_CLEAN_LINE_BY_PA_0_SBZ_RANGE                      4:1
#define PL310_CLEAN_LINE_BY_PA_0_SBZ_WOFFSET                    0x0
#define PL310_CLEAN_LINE_BY_PA_0_SBZ_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_PA_0_SBZ_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define PL310_CLEAN_LINE_BY_PA_0_SBZ_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_PA_0_SBZ_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define PL310_CLEAN_LINE_BY_PA_0_PA_MSB_SHIFT                   _MK_SHIFT_CONST(5)
#define PL310_CLEAN_LINE_BY_PA_0_PA_MSB_FIELD                   (_MK_MASK_CONST(0x7ffffff) << PL310_CLEAN_LINE_BY_PA_0_PA_MSB_SHIFT)
#define PL310_CLEAN_LINE_BY_PA_0_PA_MSB_RANGE                   31:5
#define PL310_CLEAN_LINE_BY_PA_0_PA_MSB_WOFFSET                 0x0
#define PL310_CLEAN_LINE_BY_PA_0_PA_MSB_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_PA_0_PA_MSB_DEFAULT_MASK                    _MK_MASK_CONST(0x7ffffff)
#define PL310_CLEAN_LINE_BY_PA_0_PA_MSB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_PA_0_PA_MSB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Reserved address 1972 [0x7b4] 

// Register PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0  
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0                     _MK_ADDR_CONST(0x7b8)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_SECURE                      0x0
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_WORD_COUNT                  0x1
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_RESET_MASK                  _MK_MASK_CONST(0xf0000fff)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_READ_MASK                   _MK_MASK_CONST(0xf0000fff)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_WRITE_MASK                  _MK_MASK_CONST(0xf0000fff)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_BUSY_SHIFT                  _MK_SHIFT_CONST(0)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_BUSY_FIELD                  (_MK_MASK_CONST(0x1) << PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_BUSY_SHIFT)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_BUSY_RANGE                  0:0
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_BUSY_WOFFSET                        0x0
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_BUSY_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_BUSY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_BUSY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_BUSY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_C_SHIFT                     _MK_SHIFT_CONST(1)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_C_FIELD                     (_MK_MASK_CONST(0xf) << PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_C_SHIFT)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_C_RANGE                     4:1
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_C_WOFFSET                   0x0
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_C_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_C_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_C_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_C_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_INDEX_SHIFT                 _MK_SHIFT_CONST(5)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_INDEX_FIELD                 (_MK_MASK_CONST(0x7f) << PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_INDEX_SHIFT)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_INDEX_RANGE                 11:5
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_INDEX_WOFFSET                       0x0
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_INDEX_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_INDEX_DEFAULT_MASK                  _MK_MASK_CONST(0x7f)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_INDEX_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_INDEX_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_WAY_SHIFT                   _MK_SHIFT_CONST(28)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_WAY_FIELD                   (_MK_MASK_CONST(0x3f) << PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_WAY_SHIFT)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_WAY_RANGE                   33:28
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_WAY_WOFFSET                 0x0
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_WAY_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_WAY_DEFAULT_MASK                    _MK_MASK_CONST(0x3f)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_WAY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0_WAY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register PL310_CLEAN_BY_WAY_0  
#define PL310_CLEAN_BY_WAY_0                    _MK_ADDR_CONST(0x7bc)
#define PL310_CLEAN_BY_WAY_0_SECURE                     0x0
#define PL310_CLEAN_BY_WAY_0_WORD_COUNT                         0x1
#define PL310_CLEAN_BY_WAY_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define PL310_CLEAN_BY_WAY_0_RESET_MASK                         _MK_MASK_CONST(0xff)
#define PL310_CLEAN_BY_WAY_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define PL310_CLEAN_BY_WAY_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define PL310_CLEAN_BY_WAY_0_READ_MASK                  _MK_MASK_CONST(0xff)
#define PL310_CLEAN_BY_WAY_0_WRITE_MASK                         _MK_MASK_CONST(0xff)
#define PL310_CLEAN_BY_WAY_0_WAY_BITMAP_SHIFT                   _MK_SHIFT_CONST(0)
#define PL310_CLEAN_BY_WAY_0_WAY_BITMAP_FIELD                   (_MK_MASK_CONST(0xff) << PL310_CLEAN_BY_WAY_0_WAY_BITMAP_SHIFT)
#define PL310_CLEAN_BY_WAY_0_WAY_BITMAP_RANGE                   7:0
#define PL310_CLEAN_BY_WAY_0_WAY_BITMAP_WOFFSET                 0x0
#define PL310_CLEAN_BY_WAY_0_WAY_BITMAP_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_CLEAN_BY_WAY_0_WAY_BITMAP_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define PL310_CLEAN_BY_WAY_0_WAY_BITMAP_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_CLEAN_BY_WAY_0_WAY_BITMAP_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define PL310_CLEAN_BY_WAY_0_WAY_BITMAP_NO_WAYS                 _MK_ENUM_CONST(0)
#define PL310_CLEAN_BY_WAY_0_WAY_BITMAP_EMPTY                   _MK_ENUM_CONST(0)
#define PL310_CLEAN_BY_WAY_0_WAY_BITMAP_ALL_WAYS                        _MK_ENUM_CONST(255)


// Reserved address 1984 [0x7c0] 

// Reserved address 1985 [0x7c1] 

// Reserved address 1986 [0x7c2] 

// Reserved address 1987 [0x7c3] 

// Reserved address 1988 [0x7c4] 

// Reserved address 1989 [0x7c5] 

// Reserved address 1990 [0x7c6] 

// Reserved address 1991 [0x7c7] 

// Reserved address 1992 [0x7c8] 

// Reserved address 1993 [0x7c9] 

// Reserved address 1994 [0x7ca] 

// Reserved address 1995 [0x7cb] 

// Reserved address 1996 [0x7cc] 

// Reserved address 1997 [0x7cd] 

// Reserved address 1998 [0x7ce] 

// Reserved address 1999 [0x7cf] 

// Reserved address 2000 [0x7d0] 

// Reserved address 2001 [0x7d1] 

// Reserved address 2002 [0x7d2] 

// Reserved address 2003 [0x7d3] 

// Reserved address 2004 [0x7d4] 

// Reserved address 2005 [0x7d5] 

// Reserved address 2006 [0x7d6] 

// Reserved address 2007 [0x7d7] 

// Reserved address 2008 [0x7d8] 

// Reserved address 2009 [0x7d9] 

// Reserved address 2010 [0x7da] 

// Reserved address 2011 [0x7db] 

// Reserved address 2012 [0x7dc] 

// Reserved address 2013 [0x7dd] 

// Reserved address 2014 [0x7de] 

// Reserved address 2015 [0x7df] 

// Reserved address 2016 [0x7e0] 

// Reserved address 2017 [0x7e1] 

// Reserved address 2018 [0x7e2] 

// Reserved address 2019 [0x7e3] 

// Reserved address 2020 [0x7e4] 

// Reserved address 2021 [0x7e5] 

// Reserved address 2022 [0x7e6] 

// Reserved address 2023 [0x7e7] 

// Reserved address 2024 [0x7e8] 

// Reserved address 2025 [0x7e9] 

// Reserved address 2026 [0x7ea] 

// Reserved address 2027 [0x7eb] 

// Reserved address 2028 [0x7ec] 

// Reserved address 2029 [0x7ed] 

// Reserved address 2030 [0x7ee] 

// Reserved address 2031 [0x7ef] 

// Register PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0  
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0                 _MK_ADDR_CONST(0x7f0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_SECURE                  0x0
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_WORD_COUNT                      0x1
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_C_SHIFT                 _MK_SHIFT_CONST(0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_C_FIELD                 (_MK_MASK_CONST(0x1) << PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_C_SHIFT)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_C_RANGE                 0:0
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_C_WOFFSET                       0x0
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_C_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_C_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_C_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_C_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_BUSY_SHIFT                      _MK_SHIFT_CONST(0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_BUSY_FIELD                      (_MK_MASK_CONST(0x1) << PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_BUSY_SHIFT)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_BUSY_RANGE                      0:0
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_BUSY_WOFFSET                    0x0
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_BUSY_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_BUSY_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_BUSY_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_BUSY_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_SBZ_SHIFT                       _MK_SHIFT_CONST(1)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_SBZ_FIELD                       (_MK_MASK_CONST(0xf) << PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_SBZ_SHIFT)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_SBZ_RANGE                       4:1
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_SBZ_WOFFSET                     0x0
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_SBZ_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_SBZ_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_SBZ_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_SBZ_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_PA_MSB_SHIFT                    _MK_SHIFT_CONST(5)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_PA_MSB_FIELD                    (_MK_MASK_CONST(0x7ffffff) << PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_PA_MSB_SHIFT)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_PA_MSB_RANGE                    31:5
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_PA_MSB_WOFFSET                  0x0
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_PA_MSB_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_PA_MSB_DEFAULT_MASK                     _MK_MASK_CONST(0x7ffffff)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_PA_MSB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0_PA_MSB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Reserved address 2036 [0x7f4] 

// Register PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0  
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0                      _MK_ADDR_CONST(0x7f8)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_SECURE                       0x0
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_WORD_COUNT                   0x1
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_RESET_MASK                   _MK_MASK_CONST(0xf0000fff)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_READ_MASK                    _MK_MASK_CONST(0xf0000fff)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_WRITE_MASK                   _MK_MASK_CONST(0xf0000fff)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_BUSY_SHIFT                   _MK_SHIFT_CONST(0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_BUSY_FIELD                   (_MK_MASK_CONST(0x1) << PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_BUSY_SHIFT)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_BUSY_RANGE                   0:0
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_BUSY_WOFFSET                 0x0
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_BUSY_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_BUSY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_BUSY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_BUSY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_C_SHIFT                      _MK_SHIFT_CONST(1)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_C_FIELD                      (_MK_MASK_CONST(0xf) << PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_C_SHIFT)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_C_RANGE                      4:1
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_C_WOFFSET                    0x0
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_C_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_C_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_C_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_C_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_INDEX_SHIFT                  _MK_SHIFT_CONST(5)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_INDEX_FIELD                  (_MK_MASK_CONST(0x7f) << PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_INDEX_SHIFT)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_INDEX_RANGE                  11:5
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_INDEX_WOFFSET                        0x0
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_INDEX_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_INDEX_DEFAULT_MASK                   _MK_MASK_CONST(0x7f)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_INDEX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_INDEX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_WAY_SHIFT                    _MK_SHIFT_CONST(28)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_WAY_FIELD                    (_MK_MASK_CONST(0x3f) << PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_WAY_SHIFT)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_WAY_RANGE                    33:28
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_WAY_WOFFSET                  0x0
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_WAY_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_WAY_DEFAULT_MASK                     _MK_MASK_CONST(0x3f)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_WAY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0_WAY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register PL310_CLEAN_AND_INVALIDATE_BY_WAY_0  
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0                     _MK_ADDR_CONST(0x7fc)
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_SECURE                      0x0
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_WORD_COUNT                  0x1
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_RESET_MASK                  _MK_MASK_CONST(0xff)
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_READ_MASK                   _MK_MASK_CONST(0xff)
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_WRITE_MASK                  _MK_MASK_CONST(0xff)
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_WAY_BITMAP_SHIFT                    _MK_SHIFT_CONST(0)
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_WAY_BITMAP_FIELD                    (_MK_MASK_CONST(0xff) << PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_WAY_BITMAP_SHIFT)
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_WAY_BITMAP_RANGE                    7:0
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_WAY_BITMAP_WOFFSET                  0x0
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_WAY_BITMAP_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_WAY_BITMAP_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_WAY_BITMAP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_WAY_BITMAP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_WAY_BITMAP_NO_WAYS                  _MK_ENUM_CONST(0)
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_WAY_BITMAP_EMPTY                    _MK_ENUM_CONST(0)
#define PL310_CLEAN_AND_INVALIDATE_BY_WAY_0_WAY_BITMAP_ALL_WAYS                 _MK_ENUM_CONST(255)


// Reserved address 2048 [0x800] 

// Register PL310_DATA_LOCKDOWN0_0  
#define PL310_DATA_LOCKDOWN0_0                  _MK_ADDR_CONST(0x900)
#define PL310_DATA_LOCKDOWN0_0_SECURE                   0x0
#define PL310_DATA_LOCKDOWN0_0_WORD_COUNT                       0x1
#define PL310_DATA_LOCKDOWN0_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN0_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN0_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN0_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN0_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN0_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN0_0_WAY_BITMAP_SHIFT                 _MK_SHIFT_CONST(0)
#define PL310_DATA_LOCKDOWN0_0_WAY_BITMAP_FIELD                 (_MK_MASK_CONST(0xff) << PL310_DATA_LOCKDOWN0_0_WAY_BITMAP_SHIFT)
#define PL310_DATA_LOCKDOWN0_0_WAY_BITMAP_RANGE                 7:0
#define PL310_DATA_LOCKDOWN0_0_WAY_BITMAP_WOFFSET                       0x0
#define PL310_DATA_LOCKDOWN0_0_WAY_BITMAP_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN0_0_WAY_BITMAP_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN0_0_WAY_BITMAP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN0_0_WAY_BITMAP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN0_0_WAY_BITMAP_NO_WAYS                       _MK_ENUM_CONST(0)
#define PL310_DATA_LOCKDOWN0_0_WAY_BITMAP_EMPTY                 _MK_ENUM_CONST(0)
#define PL310_DATA_LOCKDOWN0_0_WAY_BITMAP_ALL_WAYS                      _MK_ENUM_CONST(255)


// Register PL310_INSTRUCTION_LOCKDOWN0_0  
#define PL310_INSTRUCTION_LOCKDOWN0_0                   _MK_ADDR_CONST(0x904)
#define PL310_INSTRUCTION_LOCKDOWN0_0_SECURE                    0x0
#define PL310_INSTRUCTION_LOCKDOWN0_0_WORD_COUNT                        0x1
#define PL310_INSTRUCTION_LOCKDOWN0_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN0_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN0_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN0_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN0_0_WRITE_MASK                        _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN0_0_WAY_BITMAP_SHIFT                  _MK_SHIFT_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN0_0_WAY_BITMAP_FIELD                  (_MK_MASK_CONST(0xff) << PL310_INSTRUCTION_LOCKDOWN0_0_WAY_BITMAP_SHIFT)
#define PL310_INSTRUCTION_LOCKDOWN0_0_WAY_BITMAP_RANGE                  7:0
#define PL310_INSTRUCTION_LOCKDOWN0_0_WAY_BITMAP_WOFFSET                        0x0
#define PL310_INSTRUCTION_LOCKDOWN0_0_WAY_BITMAP_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN0_0_WAY_BITMAP_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN0_0_WAY_BITMAP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN0_0_WAY_BITMAP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN0_0_WAY_BITMAP_NO_WAYS                        _MK_ENUM_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN0_0_WAY_BITMAP_EMPTY                  _MK_ENUM_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN0_0_WAY_BITMAP_ALL_WAYS                       _MK_ENUM_CONST(255)


// Register PL310_DATA_LOCKDOWN1_0  
#define PL310_DATA_LOCKDOWN1_0                  _MK_ADDR_CONST(0x908)
#define PL310_DATA_LOCKDOWN1_0_SECURE                   0x0
#define PL310_DATA_LOCKDOWN1_0_WORD_COUNT                       0x1
#define PL310_DATA_LOCKDOWN1_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN1_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN1_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN1_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN1_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN1_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN1_0_WAY_BITMAP_SHIFT                 _MK_SHIFT_CONST(0)
#define PL310_DATA_LOCKDOWN1_0_WAY_BITMAP_FIELD                 (_MK_MASK_CONST(0xff) << PL310_DATA_LOCKDOWN1_0_WAY_BITMAP_SHIFT)
#define PL310_DATA_LOCKDOWN1_0_WAY_BITMAP_RANGE                 7:0
#define PL310_DATA_LOCKDOWN1_0_WAY_BITMAP_WOFFSET                       0x0
#define PL310_DATA_LOCKDOWN1_0_WAY_BITMAP_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN1_0_WAY_BITMAP_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN1_0_WAY_BITMAP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN1_0_WAY_BITMAP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN1_0_WAY_BITMAP_NO_WAYS                       _MK_ENUM_CONST(0)
#define PL310_DATA_LOCKDOWN1_0_WAY_BITMAP_EMPTY                 _MK_ENUM_CONST(0)
#define PL310_DATA_LOCKDOWN1_0_WAY_BITMAP_ALL_WAYS                      _MK_ENUM_CONST(255)


// Register PL310_INSTRUCTION_LOCKDOWN1_0  
#define PL310_INSTRUCTION_LOCKDOWN1_0                   _MK_ADDR_CONST(0x90c)
#define PL310_INSTRUCTION_LOCKDOWN1_0_SECURE                    0x0
#define PL310_INSTRUCTION_LOCKDOWN1_0_WORD_COUNT                        0x1
#define PL310_INSTRUCTION_LOCKDOWN1_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN1_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN1_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN1_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN1_0_WRITE_MASK                        _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN1_0_WAY_BITMAP_SHIFT                  _MK_SHIFT_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN1_0_WAY_BITMAP_FIELD                  (_MK_MASK_CONST(0xff) << PL310_INSTRUCTION_LOCKDOWN1_0_WAY_BITMAP_SHIFT)
#define PL310_INSTRUCTION_LOCKDOWN1_0_WAY_BITMAP_RANGE                  7:0
#define PL310_INSTRUCTION_LOCKDOWN1_0_WAY_BITMAP_WOFFSET                        0x0
#define PL310_INSTRUCTION_LOCKDOWN1_0_WAY_BITMAP_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN1_0_WAY_BITMAP_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN1_0_WAY_BITMAP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN1_0_WAY_BITMAP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN1_0_WAY_BITMAP_NO_WAYS                        _MK_ENUM_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN1_0_WAY_BITMAP_EMPTY                  _MK_ENUM_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN1_0_WAY_BITMAP_ALL_WAYS                       _MK_ENUM_CONST(255)


// Register PL310_DATA_LOCKDOWN2_0  
#define PL310_DATA_LOCKDOWN2_0                  _MK_ADDR_CONST(0x910)
#define PL310_DATA_LOCKDOWN2_0_SECURE                   0x0
#define PL310_DATA_LOCKDOWN2_0_WORD_COUNT                       0x1
#define PL310_DATA_LOCKDOWN2_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN2_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN2_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN2_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN2_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN2_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN2_0_WAY_BITMAP_SHIFT                 _MK_SHIFT_CONST(0)
#define PL310_DATA_LOCKDOWN2_0_WAY_BITMAP_FIELD                 (_MK_MASK_CONST(0xff) << PL310_DATA_LOCKDOWN2_0_WAY_BITMAP_SHIFT)
#define PL310_DATA_LOCKDOWN2_0_WAY_BITMAP_RANGE                 7:0
#define PL310_DATA_LOCKDOWN2_0_WAY_BITMAP_WOFFSET                       0x0
#define PL310_DATA_LOCKDOWN2_0_WAY_BITMAP_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN2_0_WAY_BITMAP_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN2_0_WAY_BITMAP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN2_0_WAY_BITMAP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN2_0_WAY_BITMAP_NO_WAYS                       _MK_ENUM_CONST(0)
#define PL310_DATA_LOCKDOWN2_0_WAY_BITMAP_EMPTY                 _MK_ENUM_CONST(0)
#define PL310_DATA_LOCKDOWN2_0_WAY_BITMAP_ALL_WAYS                      _MK_ENUM_CONST(255)


// Register PL310_INSTRUCTION_LOCKDOWN2_0  
#define PL310_INSTRUCTION_LOCKDOWN2_0                   _MK_ADDR_CONST(0x914)
#define PL310_INSTRUCTION_LOCKDOWN2_0_SECURE                    0x0
#define PL310_INSTRUCTION_LOCKDOWN2_0_WORD_COUNT                        0x1
#define PL310_INSTRUCTION_LOCKDOWN2_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN2_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN2_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN2_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN2_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN2_0_WRITE_MASK                        _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN2_0_WAY_BITMAP_SHIFT                  _MK_SHIFT_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN2_0_WAY_BITMAP_FIELD                  (_MK_MASK_CONST(0xff) << PL310_INSTRUCTION_LOCKDOWN2_0_WAY_BITMAP_SHIFT)
#define PL310_INSTRUCTION_LOCKDOWN2_0_WAY_BITMAP_RANGE                  7:0
#define PL310_INSTRUCTION_LOCKDOWN2_0_WAY_BITMAP_WOFFSET                        0x0
#define PL310_INSTRUCTION_LOCKDOWN2_0_WAY_BITMAP_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN2_0_WAY_BITMAP_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN2_0_WAY_BITMAP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN2_0_WAY_BITMAP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN2_0_WAY_BITMAP_NO_WAYS                        _MK_ENUM_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN2_0_WAY_BITMAP_EMPTY                  _MK_ENUM_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN2_0_WAY_BITMAP_ALL_WAYS                       _MK_ENUM_CONST(255)


// Register PL310_DATA_LOCKDOWN3_0  
#define PL310_DATA_LOCKDOWN3_0                  _MK_ADDR_CONST(0x918)
#define PL310_DATA_LOCKDOWN3_0_SECURE                   0x0
#define PL310_DATA_LOCKDOWN3_0_WORD_COUNT                       0x1
#define PL310_DATA_LOCKDOWN3_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN3_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN3_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN3_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN3_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN3_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN3_0_WAY_BITMAP_SHIFT                 _MK_SHIFT_CONST(0)
#define PL310_DATA_LOCKDOWN3_0_WAY_BITMAP_FIELD                 (_MK_MASK_CONST(0xff) << PL310_DATA_LOCKDOWN3_0_WAY_BITMAP_SHIFT)
#define PL310_DATA_LOCKDOWN3_0_WAY_BITMAP_RANGE                 7:0
#define PL310_DATA_LOCKDOWN3_0_WAY_BITMAP_WOFFSET                       0x0
#define PL310_DATA_LOCKDOWN3_0_WAY_BITMAP_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN3_0_WAY_BITMAP_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN3_0_WAY_BITMAP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN3_0_WAY_BITMAP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN3_0_WAY_BITMAP_NO_WAYS                       _MK_ENUM_CONST(0)
#define PL310_DATA_LOCKDOWN3_0_WAY_BITMAP_EMPTY                 _MK_ENUM_CONST(0)
#define PL310_DATA_LOCKDOWN3_0_WAY_BITMAP_ALL_WAYS                      _MK_ENUM_CONST(255)


// Register PL310_INSTRUCTION_LOCKDOWN3_0  
#define PL310_INSTRUCTION_LOCKDOWN3_0                   _MK_ADDR_CONST(0x91c)
#define PL310_INSTRUCTION_LOCKDOWN3_0_SECURE                    0x0
#define PL310_INSTRUCTION_LOCKDOWN3_0_WORD_COUNT                        0x1
#define PL310_INSTRUCTION_LOCKDOWN3_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN3_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN3_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN3_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN3_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN3_0_WRITE_MASK                        _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN3_0_WAY_BITMAP_SHIFT                  _MK_SHIFT_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN3_0_WAY_BITMAP_FIELD                  (_MK_MASK_CONST(0xff) << PL310_INSTRUCTION_LOCKDOWN3_0_WAY_BITMAP_SHIFT)
#define PL310_INSTRUCTION_LOCKDOWN3_0_WAY_BITMAP_RANGE                  7:0
#define PL310_INSTRUCTION_LOCKDOWN3_0_WAY_BITMAP_WOFFSET                        0x0
#define PL310_INSTRUCTION_LOCKDOWN3_0_WAY_BITMAP_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN3_0_WAY_BITMAP_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN3_0_WAY_BITMAP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN3_0_WAY_BITMAP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN3_0_WAY_BITMAP_NO_WAYS                        _MK_ENUM_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN3_0_WAY_BITMAP_EMPTY                  _MK_ENUM_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN3_0_WAY_BITMAP_ALL_WAYS                       _MK_ENUM_CONST(255)


// Register PL310_DATA_LOCKDOWN4_0  
#define PL310_DATA_LOCKDOWN4_0                  _MK_ADDR_CONST(0x920)
#define PL310_DATA_LOCKDOWN4_0_SECURE                   0x0
#define PL310_DATA_LOCKDOWN4_0_WORD_COUNT                       0x1
#define PL310_DATA_LOCKDOWN4_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN4_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN4_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN4_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN4_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN4_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN4_0_WAY_BITMAP_SHIFT                 _MK_SHIFT_CONST(0)
#define PL310_DATA_LOCKDOWN4_0_WAY_BITMAP_FIELD                 (_MK_MASK_CONST(0xff) << PL310_DATA_LOCKDOWN4_0_WAY_BITMAP_SHIFT)
#define PL310_DATA_LOCKDOWN4_0_WAY_BITMAP_RANGE                 7:0
#define PL310_DATA_LOCKDOWN4_0_WAY_BITMAP_WOFFSET                       0x0
#define PL310_DATA_LOCKDOWN4_0_WAY_BITMAP_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN4_0_WAY_BITMAP_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN4_0_WAY_BITMAP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN4_0_WAY_BITMAP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN4_0_WAY_BITMAP_NO_WAYS                       _MK_ENUM_CONST(0)
#define PL310_DATA_LOCKDOWN4_0_WAY_BITMAP_EMPTY                 _MK_ENUM_CONST(0)
#define PL310_DATA_LOCKDOWN4_0_WAY_BITMAP_ALL_WAYS                      _MK_ENUM_CONST(255)


// Register PL310_INSTRUCTION_LOCKDOWN4_0  
#define PL310_INSTRUCTION_LOCKDOWN4_0                   _MK_ADDR_CONST(0x924)
#define PL310_INSTRUCTION_LOCKDOWN4_0_SECURE                    0x0
#define PL310_INSTRUCTION_LOCKDOWN4_0_WORD_COUNT                        0x1
#define PL310_INSTRUCTION_LOCKDOWN4_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN4_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN4_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN4_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN4_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN4_0_WRITE_MASK                        _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN4_0_WAY_BITMAP_SHIFT                  _MK_SHIFT_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN4_0_WAY_BITMAP_FIELD                  (_MK_MASK_CONST(0xff) << PL310_INSTRUCTION_LOCKDOWN4_0_WAY_BITMAP_SHIFT)
#define PL310_INSTRUCTION_LOCKDOWN4_0_WAY_BITMAP_RANGE                  7:0
#define PL310_INSTRUCTION_LOCKDOWN4_0_WAY_BITMAP_WOFFSET                        0x0
#define PL310_INSTRUCTION_LOCKDOWN4_0_WAY_BITMAP_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN4_0_WAY_BITMAP_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN4_0_WAY_BITMAP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN4_0_WAY_BITMAP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN4_0_WAY_BITMAP_NO_WAYS                        _MK_ENUM_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN4_0_WAY_BITMAP_EMPTY                  _MK_ENUM_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN4_0_WAY_BITMAP_ALL_WAYS                       _MK_ENUM_CONST(255)


// Register PL310_DATA_LOCKDOWN5_0  
#define PL310_DATA_LOCKDOWN5_0                  _MK_ADDR_CONST(0x928)
#define PL310_DATA_LOCKDOWN5_0_SECURE                   0x0
#define PL310_DATA_LOCKDOWN5_0_WORD_COUNT                       0x1
#define PL310_DATA_LOCKDOWN5_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN5_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN5_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN5_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN5_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN5_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN5_0_WAY_BITMAP_SHIFT                 _MK_SHIFT_CONST(0)
#define PL310_DATA_LOCKDOWN5_0_WAY_BITMAP_FIELD                 (_MK_MASK_CONST(0xff) << PL310_DATA_LOCKDOWN5_0_WAY_BITMAP_SHIFT)
#define PL310_DATA_LOCKDOWN5_0_WAY_BITMAP_RANGE                 7:0
#define PL310_DATA_LOCKDOWN5_0_WAY_BITMAP_WOFFSET                       0x0
#define PL310_DATA_LOCKDOWN5_0_WAY_BITMAP_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN5_0_WAY_BITMAP_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN5_0_WAY_BITMAP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN5_0_WAY_BITMAP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN5_0_WAY_BITMAP_NO_WAYS                       _MK_ENUM_CONST(0)
#define PL310_DATA_LOCKDOWN5_0_WAY_BITMAP_EMPTY                 _MK_ENUM_CONST(0)
#define PL310_DATA_LOCKDOWN5_0_WAY_BITMAP_ALL_WAYS                      _MK_ENUM_CONST(255)


// Register PL310_INSTRUCTION_LOCKDOWN5_0  
#define PL310_INSTRUCTION_LOCKDOWN5_0                   _MK_ADDR_CONST(0x92c)
#define PL310_INSTRUCTION_LOCKDOWN5_0_SECURE                    0x0
#define PL310_INSTRUCTION_LOCKDOWN5_0_WORD_COUNT                        0x1
#define PL310_INSTRUCTION_LOCKDOWN5_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN5_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN5_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN5_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN5_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN5_0_WRITE_MASK                        _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN5_0_WAY_BITMAP_SHIFT                  _MK_SHIFT_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN5_0_WAY_BITMAP_FIELD                  (_MK_MASK_CONST(0xff) << PL310_INSTRUCTION_LOCKDOWN5_0_WAY_BITMAP_SHIFT)
#define PL310_INSTRUCTION_LOCKDOWN5_0_WAY_BITMAP_RANGE                  7:0
#define PL310_INSTRUCTION_LOCKDOWN5_0_WAY_BITMAP_WOFFSET                        0x0
#define PL310_INSTRUCTION_LOCKDOWN5_0_WAY_BITMAP_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN5_0_WAY_BITMAP_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN5_0_WAY_BITMAP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN5_0_WAY_BITMAP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN5_0_WAY_BITMAP_NO_WAYS                        _MK_ENUM_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN5_0_WAY_BITMAP_EMPTY                  _MK_ENUM_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN5_0_WAY_BITMAP_ALL_WAYS                       _MK_ENUM_CONST(255)


// Register PL310_DATA_LOCKDOWN6_0  
#define PL310_DATA_LOCKDOWN6_0                  _MK_ADDR_CONST(0x930)
#define PL310_DATA_LOCKDOWN6_0_SECURE                   0x0
#define PL310_DATA_LOCKDOWN6_0_WORD_COUNT                       0x1
#define PL310_DATA_LOCKDOWN6_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN6_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN6_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN6_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN6_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN6_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN6_0_WAY_BITMAP_SHIFT                 _MK_SHIFT_CONST(0)
#define PL310_DATA_LOCKDOWN6_0_WAY_BITMAP_FIELD                 (_MK_MASK_CONST(0xff) << PL310_DATA_LOCKDOWN6_0_WAY_BITMAP_SHIFT)
#define PL310_DATA_LOCKDOWN6_0_WAY_BITMAP_RANGE                 7:0
#define PL310_DATA_LOCKDOWN6_0_WAY_BITMAP_WOFFSET                       0x0
#define PL310_DATA_LOCKDOWN6_0_WAY_BITMAP_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN6_0_WAY_BITMAP_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN6_0_WAY_BITMAP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN6_0_WAY_BITMAP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN6_0_WAY_BITMAP_NO_WAYS                       _MK_ENUM_CONST(0)
#define PL310_DATA_LOCKDOWN6_0_WAY_BITMAP_EMPTY                 _MK_ENUM_CONST(0)
#define PL310_DATA_LOCKDOWN6_0_WAY_BITMAP_ALL_WAYS                      _MK_ENUM_CONST(255)


// Register PL310_INSTRUCTION_LOCKDOWN6_0  
#define PL310_INSTRUCTION_LOCKDOWN6_0                   _MK_ADDR_CONST(0x934)
#define PL310_INSTRUCTION_LOCKDOWN6_0_SECURE                    0x0
#define PL310_INSTRUCTION_LOCKDOWN6_0_WORD_COUNT                        0x1
#define PL310_INSTRUCTION_LOCKDOWN6_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN6_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN6_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN6_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN6_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN6_0_WRITE_MASK                        _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN6_0_WAY_BITMAP_SHIFT                  _MK_SHIFT_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN6_0_WAY_BITMAP_FIELD                  (_MK_MASK_CONST(0xff) << PL310_INSTRUCTION_LOCKDOWN6_0_WAY_BITMAP_SHIFT)
#define PL310_INSTRUCTION_LOCKDOWN6_0_WAY_BITMAP_RANGE                  7:0
#define PL310_INSTRUCTION_LOCKDOWN6_0_WAY_BITMAP_WOFFSET                        0x0
#define PL310_INSTRUCTION_LOCKDOWN6_0_WAY_BITMAP_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN6_0_WAY_BITMAP_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN6_0_WAY_BITMAP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN6_0_WAY_BITMAP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN6_0_WAY_BITMAP_NO_WAYS                        _MK_ENUM_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN6_0_WAY_BITMAP_EMPTY                  _MK_ENUM_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN6_0_WAY_BITMAP_ALL_WAYS                       _MK_ENUM_CONST(255)


// Register PL310_DATA_LOCKDOWN7_0  
#define PL310_DATA_LOCKDOWN7_0                  _MK_ADDR_CONST(0x938)
#define PL310_DATA_LOCKDOWN7_0_SECURE                   0x0
#define PL310_DATA_LOCKDOWN7_0_WORD_COUNT                       0x1
#define PL310_DATA_LOCKDOWN7_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN7_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN7_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN7_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN7_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN7_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN7_0_WAY_BITMAP_SHIFT                 _MK_SHIFT_CONST(0)
#define PL310_DATA_LOCKDOWN7_0_WAY_BITMAP_FIELD                 (_MK_MASK_CONST(0xff) << PL310_DATA_LOCKDOWN7_0_WAY_BITMAP_SHIFT)
#define PL310_DATA_LOCKDOWN7_0_WAY_BITMAP_RANGE                 7:0
#define PL310_DATA_LOCKDOWN7_0_WAY_BITMAP_WOFFSET                       0x0
#define PL310_DATA_LOCKDOWN7_0_WAY_BITMAP_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN7_0_WAY_BITMAP_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define PL310_DATA_LOCKDOWN7_0_WAY_BITMAP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN7_0_WAY_BITMAP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define PL310_DATA_LOCKDOWN7_0_WAY_BITMAP_NO_WAYS                       _MK_ENUM_CONST(0)
#define PL310_DATA_LOCKDOWN7_0_WAY_BITMAP_EMPTY                 _MK_ENUM_CONST(0)
#define PL310_DATA_LOCKDOWN7_0_WAY_BITMAP_ALL_WAYS                      _MK_ENUM_CONST(255)


// Register PL310_INSTRUCTION_LOCKDOWN7_0  
#define PL310_INSTRUCTION_LOCKDOWN7_0                   _MK_ADDR_CONST(0x93c)
#define PL310_INSTRUCTION_LOCKDOWN7_0_SECURE                    0x0
#define PL310_INSTRUCTION_LOCKDOWN7_0_WORD_COUNT                        0x1
#define PL310_INSTRUCTION_LOCKDOWN7_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN7_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN7_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN7_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN7_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN7_0_WRITE_MASK                        _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN7_0_WAY_BITMAP_SHIFT                  _MK_SHIFT_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN7_0_WAY_BITMAP_FIELD                  (_MK_MASK_CONST(0xff) << PL310_INSTRUCTION_LOCKDOWN7_0_WAY_BITMAP_SHIFT)
#define PL310_INSTRUCTION_LOCKDOWN7_0_WAY_BITMAP_RANGE                  7:0
#define PL310_INSTRUCTION_LOCKDOWN7_0_WAY_BITMAP_WOFFSET                        0x0
#define PL310_INSTRUCTION_LOCKDOWN7_0_WAY_BITMAP_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN7_0_WAY_BITMAP_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define PL310_INSTRUCTION_LOCKDOWN7_0_WAY_BITMAP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN7_0_WAY_BITMAP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define PL310_INSTRUCTION_LOCKDOWN7_0_WAY_BITMAP_NO_WAYS                        _MK_ENUM_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN7_0_WAY_BITMAP_EMPTY                  _MK_ENUM_CONST(0)
#define PL310_INSTRUCTION_LOCKDOWN7_0_WAY_BITMAP_ALL_WAYS                       _MK_ENUM_CONST(255)


// Reserved address 2560 [0xa00] 

// Reserved address 2816 [0xb00] 

// Register PL310_ADDRESS_FILTERING_START_0  
#define PL310_ADDRESS_FILTERING_START_0                 _MK_ADDR_CONST(0xc00)
#define PL310_ADDRESS_FILTERING_START_0_SECURE                  0x0
#define PL310_ADDRESS_FILTERING_START_0_WORD_COUNT                      0x1
#define PL310_ADDRESS_FILTERING_START_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define PL310_ADDRESS_FILTERING_START_0_RESET_MASK                      _MK_MASK_CONST(0xfff00001)
#define PL310_ADDRESS_FILTERING_START_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define PL310_ADDRESS_FILTERING_START_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define PL310_ADDRESS_FILTERING_START_0_READ_MASK                       _MK_MASK_CONST(0xfff00001)
#define PL310_ADDRESS_FILTERING_START_0_WRITE_MASK                      _MK_MASK_CONST(0xfff00001)
#define PL310_ADDRESS_FILTERING_START_0_ENABLE_SHIFT                    _MK_SHIFT_CONST(0)
#define PL310_ADDRESS_FILTERING_START_0_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << PL310_ADDRESS_FILTERING_START_0_ENABLE_SHIFT)
#define PL310_ADDRESS_FILTERING_START_0_ENABLE_RANGE                    0:0
#define PL310_ADDRESS_FILTERING_START_0_ENABLE_WOFFSET                  0x0
#define PL310_ADDRESS_FILTERING_START_0_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_ADDRESS_FILTERING_START_0_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define PL310_ADDRESS_FILTERING_START_0_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_ADDRESS_FILTERING_START_0_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define PL310_ADDRESS_FILTERING_START_0_ADDRESS_MSB_SHIFT                       _MK_SHIFT_CONST(20)
#define PL310_ADDRESS_FILTERING_START_0_ADDRESS_MSB_FIELD                       (_MK_MASK_CONST(0xfff) << PL310_ADDRESS_FILTERING_START_0_ADDRESS_MSB_SHIFT)
#define PL310_ADDRESS_FILTERING_START_0_ADDRESS_MSB_RANGE                       31:20
#define PL310_ADDRESS_FILTERING_START_0_ADDRESS_MSB_WOFFSET                     0x0
#define PL310_ADDRESS_FILTERING_START_0_ADDRESS_MSB_DEFAULT                     _MK_MASK_CONST(0x0)
#define PL310_ADDRESS_FILTERING_START_0_ADDRESS_MSB_DEFAULT_MASK                        _MK_MASK_CONST(0xfff)
#define PL310_ADDRESS_FILTERING_START_0_ADDRESS_MSB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_ADDRESS_FILTERING_START_0_ADDRESS_MSB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register PL310_ADDRESS_FILTERING_END_0  
#define PL310_ADDRESS_FILTERING_END_0                   _MK_ADDR_CONST(0xc04)
#define PL310_ADDRESS_FILTERING_END_0_SECURE                    0x0
#define PL310_ADDRESS_FILTERING_END_0_WORD_COUNT                        0x1
#define PL310_ADDRESS_FILTERING_END_0_RESET_VAL                         _MK_MASK_CONST(0x40000000)
#define PL310_ADDRESS_FILTERING_END_0_RESET_MASK                        _MK_MASK_CONST(0xfff00000)
#define PL310_ADDRESS_FILTERING_END_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define PL310_ADDRESS_FILTERING_END_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_ADDRESS_FILTERING_END_0_READ_MASK                         _MK_MASK_CONST(0xfff00000)
#define PL310_ADDRESS_FILTERING_END_0_WRITE_MASK                        _MK_MASK_CONST(0xfff00000)
#define PL310_ADDRESS_FILTERING_END_0_ADDRESS_MSB_SHIFT                 _MK_SHIFT_CONST(20)
#define PL310_ADDRESS_FILTERING_END_0_ADDRESS_MSB_FIELD                 (_MK_MASK_CONST(0xfff) << PL310_ADDRESS_FILTERING_END_0_ADDRESS_MSB_SHIFT)
#define PL310_ADDRESS_FILTERING_END_0_ADDRESS_MSB_RANGE                 31:20
#define PL310_ADDRESS_FILTERING_END_0_ADDRESS_MSB_WOFFSET                       0x0
#define PL310_ADDRESS_FILTERING_END_0_ADDRESS_MSB_DEFAULT                       _MK_MASK_CONST(0x400)
#define PL310_ADDRESS_FILTERING_END_0_ADDRESS_MSB_DEFAULT_MASK                  _MK_MASK_CONST(0xfff)
#define PL310_ADDRESS_FILTERING_END_0_ADDRESS_MSB_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_ADDRESS_FILTERING_END_0_ADDRESS_MSB_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 3328 [0xd00] 

// Reserved address 3584 [0xe00] 

// Reserved address 3840 [0xf00] 

// Register PL310_DEBUG_CONTROL_0  
#define PL310_DEBUG_CONTROL_0                   _MK_ADDR_CONST(0xf40)
#define PL310_DEBUG_CONTROL_0_SECURE                    0x0
#define PL310_DEBUG_CONTROL_0_WORD_COUNT                        0x1
#define PL310_DEBUG_CONTROL_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define PL310_DEBUG_CONTROL_0_RESET_MASK                        _MK_MASK_CONST(0x7)
#define PL310_DEBUG_CONTROL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define PL310_DEBUG_CONTROL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define PL310_DEBUG_CONTROL_0_READ_MASK                         _MK_MASK_CONST(0x7)
#define PL310_DEBUG_CONTROL_0_WRITE_MASK                        _MK_MASK_CONST(0x3)
#define PL310_DEBUG_CONTROL_0_DISABLE_CACHE_LINEFILL_SHIFT                      _MK_SHIFT_CONST(0)
#define PL310_DEBUG_CONTROL_0_DISABLE_CACHE_LINEFILL_FIELD                      (_MK_MASK_CONST(0x1) << PL310_DEBUG_CONTROL_0_DISABLE_CACHE_LINEFILL_SHIFT)
#define PL310_DEBUG_CONTROL_0_DISABLE_CACHE_LINEFILL_RANGE                      0:0
#define PL310_DEBUG_CONTROL_0_DISABLE_CACHE_LINEFILL_WOFFSET                    0x0
#define PL310_DEBUG_CONTROL_0_DISABLE_CACHE_LINEFILL_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_DEBUG_CONTROL_0_DISABLE_CACHE_LINEFILL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define PL310_DEBUG_CONTROL_0_DISABLE_CACHE_LINEFILL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_DEBUG_CONTROL_0_DISABLE_CACHE_LINEFILL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define PL310_DEBUG_CONTROL_0_DCL_SHIFT                 _MK_SHIFT_CONST(0)
#define PL310_DEBUG_CONTROL_0_DCL_FIELD                 (_MK_MASK_CONST(0x1) << PL310_DEBUG_CONTROL_0_DCL_SHIFT)
#define PL310_DEBUG_CONTROL_0_DCL_RANGE                 0:0
#define PL310_DEBUG_CONTROL_0_DCL_WOFFSET                       0x0
#define PL310_DEBUG_CONTROL_0_DCL_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_DEBUG_CONTROL_0_DCL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define PL310_DEBUG_CONTROL_0_DCL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_DEBUG_CONTROL_0_DCL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define PL310_DEBUG_CONTROL_0_DISABLE_CACHE_WRITEBACK_SHIFT                     _MK_SHIFT_CONST(1)
#define PL310_DEBUG_CONTROL_0_DISABLE_CACHE_WRITEBACK_FIELD                     (_MK_MASK_CONST(0x1) << PL310_DEBUG_CONTROL_0_DISABLE_CACHE_WRITEBACK_SHIFT)
#define PL310_DEBUG_CONTROL_0_DISABLE_CACHE_WRITEBACK_RANGE                     1:1
#define PL310_DEBUG_CONTROL_0_DISABLE_CACHE_WRITEBACK_WOFFSET                   0x0
#define PL310_DEBUG_CONTROL_0_DISABLE_CACHE_WRITEBACK_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_DEBUG_CONTROL_0_DISABLE_CACHE_WRITEBACK_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_DEBUG_CONTROL_0_DISABLE_CACHE_WRITEBACK_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_DEBUG_CONTROL_0_DISABLE_CACHE_WRITEBACK_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define PL310_DEBUG_CONTROL_0_FORCE_WT_SHIFT                    _MK_SHIFT_CONST(1)
#define PL310_DEBUG_CONTROL_0_FORCE_WT_FIELD                    (_MK_MASK_CONST(0x1) << PL310_DEBUG_CONTROL_0_FORCE_WT_SHIFT)
#define PL310_DEBUG_CONTROL_0_FORCE_WT_RANGE                    1:1
#define PL310_DEBUG_CONTROL_0_FORCE_WT_WOFFSET                  0x0
#define PL310_DEBUG_CONTROL_0_FORCE_WT_DEFAULT                  _MK_MASK_CONST(0x0)
#define PL310_DEBUG_CONTROL_0_FORCE_WT_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define PL310_DEBUG_CONTROL_0_FORCE_WT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_DEBUG_CONTROL_0_FORCE_WT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define PL310_DEBUG_CONTROL_0_DWB_SHIFT                 _MK_SHIFT_CONST(1)
#define PL310_DEBUG_CONTROL_0_DWB_FIELD                 (_MK_MASK_CONST(0x1) << PL310_DEBUG_CONTROL_0_DWB_SHIFT)
#define PL310_DEBUG_CONTROL_0_DWB_RANGE                 1:1
#define PL310_DEBUG_CONTROL_0_DWB_WOFFSET                       0x0
#define PL310_DEBUG_CONTROL_0_DWB_DEFAULT                       _MK_MASK_CONST(0x0)
#define PL310_DEBUG_CONTROL_0_DWB_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define PL310_DEBUG_CONTROL_0_DWB_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define PL310_DEBUG_CONTROL_0_DWB_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define PL310_DEBUG_CONTROL_0_SPNIDEN_SHIFT                     _MK_SHIFT_CONST(2)
#define PL310_DEBUG_CONTROL_0_SPNIDEN_FIELD                     (_MK_MASK_CONST(0x1) << PL310_DEBUG_CONTROL_0_SPNIDEN_SHIFT)
#define PL310_DEBUG_CONTROL_0_SPNIDEN_RANGE                     2:2
#define PL310_DEBUG_CONTROL_0_SPNIDEN_WOFFSET                   0x0
#define PL310_DEBUG_CONTROL_0_SPNIDEN_DEFAULT                   _MK_MASK_CONST(0x0)
#define PL310_DEBUG_CONTROL_0_SPNIDEN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define PL310_DEBUG_CONTROL_0_SPNIDEN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define PL310_DEBUG_CONTROL_0_SPNIDEN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Reserved address 3908 [0xf44] 

// Reserved address 3909 [0xf45] 

// Reserved address 3910 [0xf46] 

// Reserved address 3911 [0xf47] 

// Reserved address 3912 [0xf48] 

// Reserved address 3913 [0xf49] 

// Reserved address 3914 [0xf4a] 

// Reserved address 3915 [0xf4b] 

// Reserved address 3916 [0xf4c] 

// Reserved address 3917 [0xf4d] 

// Reserved address 3918 [0xf4e] 

// Reserved address 3919 [0xf4f] 

// Reserved address 3920 [0xf50] 

// Reserved address 3921 [0xf51] 

// Reserved address 3922 [0xf52] 

// Reserved address 3923 [0xf53] 

// Reserved address 3924 [0xf54] 

// Reserved address 3925 [0xf55] 

// Reserved address 3926 [0xf56] 

// Reserved address 3927 [0xf57] 

// Reserved address 3928 [0xf58] 

// Reserved address 3929 [0xf59] 

// Reserved address 3930 [0xf5a] 

// Reserved address 3931 [0xf5b] 

// Reserved address 3932 [0xf5c] 

// Reserved address 3933 [0xf5d] 

// Reserved address 3934 [0xf5e] 

// Reserved address 3935 [0xf5f] 

// Register PL310_PREFETCH_OFFSET_0  
#define PL310_PREFETCH_OFFSET_0                 _MK_ADDR_CONST(0xf60)
#define PL310_PREFETCH_OFFSET_0_SECURE                  0x0
#define PL310_PREFETCH_OFFSET_0_WORD_COUNT                      0x1
#define PL310_PREFETCH_OFFSET_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define PL310_PREFETCH_OFFSET_0_RESET_MASK                      _MK_MASK_CONST(0x1f)
#define PL310_PREFETCH_OFFSET_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define PL310_PREFETCH_OFFSET_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define PL310_PREFETCH_OFFSET_0_READ_MASK                       _MK_MASK_CONST(0x1f)
#define PL310_PREFETCH_OFFSET_0_WRITE_MASK                      _MK_MASK_CONST(0x1f)
// prefetch 1 + delta cache lines ahead of the current address 
#define PL310_PREFETCH_OFFSET_0_CACHELINE_DELTA_SHIFT                   _MK_SHIFT_CONST(0)
#define PL310_PREFETCH_OFFSET_0_CACHELINE_DELTA_FIELD                   (_MK_MASK_CONST(0x1f) << PL310_PREFETCH_OFFSET_0_CACHELINE_DELTA_SHIFT)
#define PL310_PREFETCH_OFFSET_0_CACHELINE_DELTA_RANGE                   4:0
#define PL310_PREFETCH_OFFSET_0_CACHELINE_DELTA_WOFFSET                 0x0
#define PL310_PREFETCH_OFFSET_0_CACHELINE_DELTA_DEFAULT                 _MK_MASK_CONST(0x0)
#define PL310_PREFETCH_OFFSET_0_CACHELINE_DELTA_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define PL310_PREFETCH_OFFSET_0_CACHELINE_DELTA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define PL310_PREFETCH_OFFSET_0_CACHELINE_DELTA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_ARPL310_REGS(_op_) \
_op_(PL310_CACHE_ID_0) \
_op_(PL310_CACHE_TYPE_0) \
_op_(PL310_CONTROL_0) \
_op_(PL310_AUXILIARY_CONTROL_0) \
_op_(PL310_TAG_RAM_LATENCY_0) \
_op_(PL310_DATA_RAM_LATENCY_0) \
_op_(PL310_EVENT_COUNTER_CONTROL_0) \
_op_(PL310_EVENT_COUNTER1_CONFIGURATION_0) \
_op_(PL310_EVENT_COUNTER0_CONFIGURATION_0) \
_op_(PL310_EVENT_COUNTER1_0) \
_op_(PL310_EVENT_COUNTER0_0) \
_op_(PL310_INTERRUPT_MASK_0) \
_op_(PL310_MASKED_INTERRUPT_STATUS_0) \
_op_(PL310_RAW_INTERRUPT_STATUS_0) \
_op_(PL310_INTERRUPT_CLEAR_0) \
_op_(PL310_CACHE_SYNC_0) \
_op_(PL310_INVALIDATE_LINE_BY_PA_0) \
_op_(PL310_INVALIDATE_BY_WAY_0) \
_op_(PL310_CLEAN_LINE_BY_PA_0) \
_op_(PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0) \
_op_(PL310_CLEAN_BY_WAY_0) \
_op_(PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0) \
_op_(PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0) \
_op_(PL310_CLEAN_AND_INVALIDATE_BY_WAY_0) \
_op_(PL310_DATA_LOCKDOWN0_0) \
_op_(PL310_INSTRUCTION_LOCKDOWN0_0) \
_op_(PL310_DATA_LOCKDOWN1_0) \
_op_(PL310_INSTRUCTION_LOCKDOWN1_0) \
_op_(PL310_DATA_LOCKDOWN2_0) \
_op_(PL310_INSTRUCTION_LOCKDOWN2_0) \
_op_(PL310_DATA_LOCKDOWN3_0) \
_op_(PL310_INSTRUCTION_LOCKDOWN3_0) \
_op_(PL310_DATA_LOCKDOWN4_0) \
_op_(PL310_INSTRUCTION_LOCKDOWN4_0) \
_op_(PL310_DATA_LOCKDOWN5_0) \
_op_(PL310_INSTRUCTION_LOCKDOWN5_0) \
_op_(PL310_DATA_LOCKDOWN6_0) \
_op_(PL310_INSTRUCTION_LOCKDOWN6_0) \
_op_(PL310_DATA_LOCKDOWN7_0) \
_op_(PL310_INSTRUCTION_LOCKDOWN7_0) \
_op_(PL310_ADDRESS_FILTERING_START_0) \
_op_(PL310_ADDRESS_FILTERING_END_0) \
_op_(PL310_DEBUG_CONTROL_0) \
_op_(PL310_PREFETCH_OFFSET_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_PL310      0x00000000

//
// ARPL310 REGISTER BANKS
//

#define PL3100_FIRST_REG 0x0000 // PL310_CACHE_ID_0
#define PL3100_LAST_REG 0x0004 // PL310_CACHE_TYPE_0
#define PL3101_FIRST_REG 0x0100 // PL310_CONTROL_0
#define PL3101_LAST_REG 0x010c // PL310_DATA_RAM_LATENCY_0
#define PL3102_FIRST_REG 0x0200 // PL310_EVENT_COUNTER_CONTROL_0
#define PL3102_LAST_REG 0x0220 // PL310_INTERRUPT_CLEAR_0
#define PL3103_FIRST_REG 0x0730 // PL310_CACHE_SYNC_0
#define PL3103_LAST_REG 0x0730 // PL310_CACHE_SYNC_0
#define PL3104_FIRST_REG 0x0770 // PL310_INVALIDATE_LINE_BY_PA_0
#define PL3104_LAST_REG 0x0770 // PL310_INVALIDATE_LINE_BY_PA_0
#define PL3105_FIRST_REG 0x077c // PL310_INVALIDATE_BY_WAY_0
#define PL3105_LAST_REG 0x077c // PL310_INVALIDATE_BY_WAY_0
#define PL3106_FIRST_REG 0x07b0 // PL310_CLEAN_LINE_BY_PA_0
#define PL3106_LAST_REG 0x07b0 // PL310_CLEAN_LINE_BY_PA_0
#define PL3107_FIRST_REG 0x07b8 // PL310_CLEAN_LINE_BY_INDEX_AND_WAY_0
#define PL3107_LAST_REG 0x07bc // PL310_CLEAN_BY_WAY_0
#define PL3108_FIRST_REG 0x07f0 // PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0
#define PL3108_LAST_REG 0x07f0 // PL310_CLEAN_AND_INVALIDATE_LINE_BY_PA_0
#define PL3109_FIRST_REG 0x07f8 // PL310_CLEAN_AND_INVALIDATE_LINE_BY_INDEX_AND_WAY_0
#define PL3109_LAST_REG 0x07fc // PL310_CLEAN_AND_INVALIDATE_BY_WAY_0
#define PL31010_FIRST_REG 0x0900 // PL310_DATA_LOCKDOWN0_0
#define PL31010_LAST_REG 0x093c // PL310_INSTRUCTION_LOCKDOWN7_0
#define PL31011_FIRST_REG 0x0c00 // PL310_ADDRESS_FILTERING_START_0
#define PL31011_LAST_REG 0x0c04 // PL310_ADDRESS_FILTERING_END_0
#define PL31012_FIRST_REG 0x0f40 // PL310_DEBUG_CONTROL_0
#define PL31012_LAST_REG 0x0f40 // PL310_DEBUG_CONTROL_0
#define PL31013_FIRST_REG 0x0f60 // PL310_PREFETCH_OFFSET_0
#define PL31013_LAST_REG 0x0f60 // PL310_PREFETCH_OFFSET_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARPL310_H_INC_
