/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARSDMMC_H_INC_
#define ___ARSDMMC_H_INC_

// Register SDMMC_SYSTEM_ADDRESS_0  
#define SDMMC_SYSTEM_ADDRESS_0                  _MK_ADDR_CONST(0x0)
#define SDMMC_SYSTEM_ADDRESS_0_SECURE                   0x0
#define SDMMC_SYSTEM_ADDRESS_0_WORD_COUNT                       0x1
#define SDMMC_SYSTEM_ADDRESS_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define SDMMC_SYSTEM_ADDRESS_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define SDMMC_SYSTEM_ADDRESS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define SDMMC_SYSTEM_ADDRESS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_SYSTEM_ADDRESS_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define SDMMC_SYSTEM_ADDRESS_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
#define SDMMC_SYSTEM_ADDRESS_0_ADDRESS_SHIFT                    _MK_SHIFT_CONST(0)
#define SDMMC_SYSTEM_ADDRESS_0_ADDRESS_FIELD                    (_MK_MASK_CONST(0xffffffff) << SDMMC_SYSTEM_ADDRESS_0_ADDRESS_SHIFT)
#define SDMMC_SYSTEM_ADDRESS_0_ADDRESS_RANGE                    31:0
#define SDMMC_SYSTEM_ADDRESS_0_ADDRESS_WOFFSET                  0x0
#define SDMMC_SYSTEM_ADDRESS_0_ADDRESS_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_SYSTEM_ADDRESS_0_ADDRESS_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define SDMMC_SYSTEM_ADDRESS_0_ADDRESS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_SYSTEM_ADDRESS_0_ADDRESS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register SDMMC_BLOCK_SIZE_BLOCK_COUNT_0  
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0                  _MK_ADDR_CONST(0x4)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_SECURE                   0x0
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_WORD_COUNT                       0x1
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_BLOCKS_COUNT_SHIFT                       _MK_SHIFT_CONST(16)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_BLOCKS_COUNT_FIELD                       (_MK_MASK_CONST(0xffff) << SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_BLOCKS_COUNT_SHIFT)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_BLOCKS_COUNT_RANGE                       31:16
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_BLOCKS_COUNT_WOFFSET                     0x0
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_BLOCKS_COUNT_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_BLOCKS_COUNT_DEFAULT_MASK                        _MK_MASK_CONST(0xffff)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_BLOCKS_COUNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_BLOCKS_COUNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_12_SHIFT                 _MK_SHIFT_CONST(15)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_12_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_12_SHIFT)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_12_RANGE                 15:15
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_12_WOFFSET                       0x0
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_12_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_12_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_12_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_12_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_SHIFT                       _MK_SHIFT_CONST(12)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_FIELD                       (_MK_MASK_CONST(0x7) << SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_SHIFT)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_RANGE                       14:12
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_WOFFSET                     0x0
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_DMA4K                       _MK_ENUM_CONST(0)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_DMA8K                       _MK_ENUM_CONST(1)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_DMA16K                      _MK_ENUM_CONST(2)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_DMA32K                      _MK_ENUM_CONST(3)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_DMA64K                      _MK_ENUM_CONST(4)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_DMA128K                     _MK_ENUM_CONST(5)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_DMA256K                     _MK_ENUM_CONST(6)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_HOST_DMA_BUFFER_SIZE_DMA512K                     _MK_ENUM_CONST(7)

#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_11_0_SHIFT                       _MK_SHIFT_CONST(0)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_11_0_FIELD                       (_MK_MASK_CONST(0xfff) << SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_11_0_SHIFT)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_11_0_RANGE                       11:0
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_11_0_WOFFSET                     0x0
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_11_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_11_0_DEFAULT_MASK                        _MK_MASK_CONST(0xfff)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_11_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_BLOCK_SIZE_BLOCK_COUNT_0_XFER_BLOCK_SIZE_11_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register SDMMC_ARGUMENT_0  
#define SDMMC_ARGUMENT_0                        _MK_ADDR_CONST(0x8)
#define SDMMC_ARGUMENT_0_SECURE                         0x0
#define SDMMC_ARGUMENT_0_WORD_COUNT                     0x1
#define SDMMC_ARGUMENT_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define SDMMC_ARGUMENT_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define SDMMC_ARGUMENT_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define SDMMC_ARGUMENT_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_ARGUMENT_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define SDMMC_ARGUMENT_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
#define SDMMC_ARGUMENT_0_COMMAND_ARGUMENT_SHIFT                 _MK_SHIFT_CONST(0)
#define SDMMC_ARGUMENT_0_COMMAND_ARGUMENT_FIELD                 (_MK_MASK_CONST(0xffffffff) << SDMMC_ARGUMENT_0_COMMAND_ARGUMENT_SHIFT)
#define SDMMC_ARGUMENT_0_COMMAND_ARGUMENT_RANGE                 31:0
#define SDMMC_ARGUMENT_0_COMMAND_ARGUMENT_WOFFSET                       0x0
#define SDMMC_ARGUMENT_0_COMMAND_ARGUMENT_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_ARGUMENT_0_COMMAND_ARGUMENT_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define SDMMC_ARGUMENT_0_COMMAND_ARGUMENT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_ARGUMENT_0_COMMAND_ARGUMENT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register SDMMC_CMD_XFER_MODE_0  
#define SDMMC_CMD_XFER_MODE_0                   _MK_ADDR_CONST(0xc)
#define SDMMC_CMD_XFER_MODE_0_SECURE                    0x0
#define SDMMC_CMD_XFER_MODE_0_WORD_COUNT                        0x1
#define SDMMC_CMD_XFER_MODE_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_RESET_MASK                        _MK_MASK_CONST(0x3ffb00f7)
#define SDMMC_CMD_XFER_MODE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_READ_MASK                         _MK_MASK_CONST(0x3ffb00f7)
#define SDMMC_CMD_XFER_MODE_0_WRITE_MASK                        _MK_MASK_CONST(0x3ffb00f7)
#define SDMMC_CMD_XFER_MODE_0_COMMAND_INDEX_SHIFT                       _MK_SHIFT_CONST(24)
#define SDMMC_CMD_XFER_MODE_0_COMMAND_INDEX_FIELD                       (_MK_MASK_CONST(0x3f) << SDMMC_CMD_XFER_MODE_0_COMMAND_INDEX_SHIFT)
#define SDMMC_CMD_XFER_MODE_0_COMMAND_INDEX_RANGE                       29:24
#define SDMMC_CMD_XFER_MODE_0_COMMAND_INDEX_WOFFSET                     0x0
#define SDMMC_CMD_XFER_MODE_0_COMMAND_INDEX_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_COMMAND_INDEX_DEFAULT_MASK                        _MK_MASK_CONST(0x3f)
#define SDMMC_CMD_XFER_MODE_0_COMMAND_INDEX_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_COMMAND_INDEX_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define SDMMC_CMD_XFER_MODE_0_COMMAND_TYPE_SHIFT                        _MK_SHIFT_CONST(22)
#define SDMMC_CMD_XFER_MODE_0_COMMAND_TYPE_FIELD                        (_MK_MASK_CONST(0x3) << SDMMC_CMD_XFER_MODE_0_COMMAND_TYPE_SHIFT)
#define SDMMC_CMD_XFER_MODE_0_COMMAND_TYPE_RANGE                        23:22
#define SDMMC_CMD_XFER_MODE_0_COMMAND_TYPE_WOFFSET                      0x0
#define SDMMC_CMD_XFER_MODE_0_COMMAND_TYPE_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_COMMAND_TYPE_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define SDMMC_CMD_XFER_MODE_0_COMMAND_TYPE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_COMMAND_TYPE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_COMMAND_TYPE_NORMAL                       _MK_ENUM_CONST(0)
#define SDMMC_CMD_XFER_MODE_0_COMMAND_TYPE_SUSPEND                      _MK_ENUM_CONST(1)
#define SDMMC_CMD_XFER_MODE_0_COMMAND_TYPE_RESUME                       _MK_ENUM_CONST(2)
#define SDMMC_CMD_XFER_MODE_0_COMMAND_TYPE_ABORT                        _MK_ENUM_CONST(3)

#define SDMMC_CMD_XFER_MODE_0_DATA_PRESENT_SELECT_SHIFT                 _MK_SHIFT_CONST(21)
#define SDMMC_CMD_XFER_MODE_0_DATA_PRESENT_SELECT_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_CMD_XFER_MODE_0_DATA_PRESENT_SELECT_SHIFT)
#define SDMMC_CMD_XFER_MODE_0_DATA_PRESENT_SELECT_RANGE                 21:21
#define SDMMC_CMD_XFER_MODE_0_DATA_PRESENT_SELECT_WOFFSET                       0x0
#define SDMMC_CMD_XFER_MODE_0_DATA_PRESENT_SELECT_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_DATA_PRESENT_SELECT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_CMD_XFER_MODE_0_DATA_PRESENT_SELECT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_DATA_PRESENT_SELECT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_DATA_PRESENT_SELECT_NO_DATA_TRANSFER                      _MK_ENUM_CONST(0)
#define SDMMC_CMD_XFER_MODE_0_DATA_PRESENT_SELECT_DATA_TRANSFER                 _MK_ENUM_CONST(1)

#define SDMMC_CMD_XFER_MODE_0_CMD_INDEX_CHECK_EN_SHIFT                  _MK_SHIFT_CONST(20)
#define SDMMC_CMD_XFER_MODE_0_CMD_INDEX_CHECK_EN_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_CMD_XFER_MODE_0_CMD_INDEX_CHECK_EN_SHIFT)
#define SDMMC_CMD_XFER_MODE_0_CMD_INDEX_CHECK_EN_RANGE                  20:20
#define SDMMC_CMD_XFER_MODE_0_CMD_INDEX_CHECK_EN_WOFFSET                        0x0
#define SDMMC_CMD_XFER_MODE_0_CMD_INDEX_CHECK_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_CMD_INDEX_CHECK_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_CMD_XFER_MODE_0_CMD_INDEX_CHECK_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_CMD_INDEX_CHECK_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_CMD_INDEX_CHECK_EN_DISABLE                        _MK_ENUM_CONST(0)
#define SDMMC_CMD_XFER_MODE_0_CMD_INDEX_CHECK_EN_ENABLE                 _MK_ENUM_CONST(1)

#define SDMMC_CMD_XFER_MODE_0_CMD_CRC_CHECK_EN_SHIFT                    _MK_SHIFT_CONST(19)
#define SDMMC_CMD_XFER_MODE_0_CMD_CRC_CHECK_EN_FIELD                    (_MK_MASK_CONST(0x1) << SDMMC_CMD_XFER_MODE_0_CMD_CRC_CHECK_EN_SHIFT)
#define SDMMC_CMD_XFER_MODE_0_CMD_CRC_CHECK_EN_RANGE                    19:19
#define SDMMC_CMD_XFER_MODE_0_CMD_CRC_CHECK_EN_WOFFSET                  0x0
#define SDMMC_CMD_XFER_MODE_0_CMD_CRC_CHECK_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_CMD_CRC_CHECK_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_CMD_XFER_MODE_0_CMD_CRC_CHECK_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_CMD_CRC_CHECK_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_CMD_CRC_CHECK_EN_DISABLE                  _MK_ENUM_CONST(0)
#define SDMMC_CMD_XFER_MODE_0_CMD_CRC_CHECK_EN_ENABLE                   _MK_ENUM_CONST(1)

#define SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_SHIFT                    _MK_SHIFT_CONST(16)
#define SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_FIELD                    (_MK_MASK_CONST(0x3) << SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_SHIFT)
#define SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_RANGE                    17:16
#define SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_WOFFSET                  0x0
#define SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_NO_RESPONSE                      _MK_ENUM_CONST(0)
#define SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_RESP_LENGTH_136                  _MK_ENUM_CONST(1)
#define SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_RESP_LENGTH_48                   _MK_ENUM_CONST(2)
#define SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_RESP_LENGTH_48BUSY                       _MK_ENUM_CONST(3)
#define SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_SPI_R1_RESPONSE                  _MK_ENUM_CONST(0)
#define SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_SPI_R2_RESPONSE                  _MK_ENUM_CONST(1)
#define SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_SPI_R3_RESPONSE                  _MK_ENUM_CONST(2)
#define SDMMC_CMD_XFER_MODE_0_RESP_TYPE_SELECT_SPI_R1b_RESPONSE                 _MK_ENUM_CONST(3)

#define SDMMC_CMD_XFER_MODE_0_SPI_MODE_SHIFT                    _MK_SHIFT_CONST(7)
#define SDMMC_CMD_XFER_MODE_0_SPI_MODE_FIELD                    (_MK_MASK_CONST(0x1) << SDMMC_CMD_XFER_MODE_0_SPI_MODE_SHIFT)
#define SDMMC_CMD_XFER_MODE_0_SPI_MODE_RANGE                    7:7
#define SDMMC_CMD_XFER_MODE_0_SPI_MODE_WOFFSET                  0x0
#define SDMMC_CMD_XFER_MODE_0_SPI_MODE_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_SPI_MODE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_CMD_XFER_MODE_0_SPI_MODE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_SPI_MODE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_SPI_MODE_DISABLE                  _MK_ENUM_CONST(0)
#define SDMMC_CMD_XFER_MODE_0_SPI_MODE_ENABLE                   _MK_ENUM_CONST(1)

#define SDMMC_CMD_XFER_MODE_0_CMD_COMP_ATA_SHIFT                        _MK_SHIFT_CONST(6)
#define SDMMC_CMD_XFER_MODE_0_CMD_COMP_ATA_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_CMD_XFER_MODE_0_CMD_COMP_ATA_SHIFT)
#define SDMMC_CMD_XFER_MODE_0_CMD_COMP_ATA_RANGE                        6:6
#define SDMMC_CMD_XFER_MODE_0_CMD_COMP_ATA_WOFFSET                      0x0
#define SDMMC_CMD_XFER_MODE_0_CMD_COMP_ATA_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_CMD_COMP_ATA_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_CMD_XFER_MODE_0_CMD_COMP_ATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_CMD_COMP_ATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_CMD_COMP_ATA_DISABLE                      _MK_ENUM_CONST(0)
#define SDMMC_CMD_XFER_MODE_0_CMD_COMP_ATA_ENABLE                       _MK_ENUM_CONST(1)

#define SDMMC_CMD_XFER_MODE_0_MULTI_BLOCK_SELECT_SHIFT                  _MK_SHIFT_CONST(5)
#define SDMMC_CMD_XFER_MODE_0_MULTI_BLOCK_SELECT_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_CMD_XFER_MODE_0_MULTI_BLOCK_SELECT_SHIFT)
#define SDMMC_CMD_XFER_MODE_0_MULTI_BLOCK_SELECT_RANGE                  5:5
#define SDMMC_CMD_XFER_MODE_0_MULTI_BLOCK_SELECT_WOFFSET                        0x0
#define SDMMC_CMD_XFER_MODE_0_MULTI_BLOCK_SELECT_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_MULTI_BLOCK_SELECT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_CMD_XFER_MODE_0_MULTI_BLOCK_SELECT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_MULTI_BLOCK_SELECT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_MULTI_BLOCK_SELECT_DISABLE                        _MK_ENUM_CONST(0)
#define SDMMC_CMD_XFER_MODE_0_MULTI_BLOCK_SELECT_ENABLE                 _MK_ENUM_CONST(1)

#define SDMMC_CMD_XFER_MODE_0_DATA_XFER_DIR_SEL_SHIFT                   _MK_SHIFT_CONST(4)
#define SDMMC_CMD_XFER_MODE_0_DATA_XFER_DIR_SEL_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_CMD_XFER_MODE_0_DATA_XFER_DIR_SEL_SHIFT)
#define SDMMC_CMD_XFER_MODE_0_DATA_XFER_DIR_SEL_RANGE                   4:4
#define SDMMC_CMD_XFER_MODE_0_DATA_XFER_DIR_SEL_WOFFSET                 0x0
#define SDMMC_CMD_XFER_MODE_0_DATA_XFER_DIR_SEL_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_DATA_XFER_DIR_SEL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_CMD_XFER_MODE_0_DATA_XFER_DIR_SEL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_DATA_XFER_DIR_SEL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_DATA_XFER_DIR_SEL_WRITE                   _MK_ENUM_CONST(0)
#define SDMMC_CMD_XFER_MODE_0_DATA_XFER_DIR_SEL_READ                    _MK_ENUM_CONST(1)

#define SDMMC_CMD_XFER_MODE_0_AUTO_CMD12_EN_SHIFT                       _MK_SHIFT_CONST(2)
#define SDMMC_CMD_XFER_MODE_0_AUTO_CMD12_EN_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_CMD_XFER_MODE_0_AUTO_CMD12_EN_SHIFT)
#define SDMMC_CMD_XFER_MODE_0_AUTO_CMD12_EN_RANGE                       2:2
#define SDMMC_CMD_XFER_MODE_0_AUTO_CMD12_EN_WOFFSET                     0x0
#define SDMMC_CMD_XFER_MODE_0_AUTO_CMD12_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_AUTO_CMD12_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_CMD_XFER_MODE_0_AUTO_CMD12_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_AUTO_CMD12_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_AUTO_CMD12_EN_DISABLE                     _MK_ENUM_CONST(0)
#define SDMMC_CMD_XFER_MODE_0_AUTO_CMD12_EN_ENABLE                      _MK_ENUM_CONST(1)

#define SDMMC_CMD_XFER_MODE_0_BLOCK_COUNT_EN_SHIFT                      _MK_SHIFT_CONST(1)
#define SDMMC_CMD_XFER_MODE_0_BLOCK_COUNT_EN_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_CMD_XFER_MODE_0_BLOCK_COUNT_EN_SHIFT)
#define SDMMC_CMD_XFER_MODE_0_BLOCK_COUNT_EN_RANGE                      1:1
#define SDMMC_CMD_XFER_MODE_0_BLOCK_COUNT_EN_WOFFSET                    0x0
#define SDMMC_CMD_XFER_MODE_0_BLOCK_COUNT_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_BLOCK_COUNT_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_CMD_XFER_MODE_0_BLOCK_COUNT_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_BLOCK_COUNT_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_BLOCK_COUNT_EN_DISABLE                    _MK_ENUM_CONST(0)
#define SDMMC_CMD_XFER_MODE_0_BLOCK_COUNT_EN_ENABLE                     _MK_ENUM_CONST(1)

#define SDMMC_CMD_XFER_MODE_0_DMA_EN_SHIFT                      _MK_SHIFT_CONST(0)
#define SDMMC_CMD_XFER_MODE_0_DMA_EN_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_CMD_XFER_MODE_0_DMA_EN_SHIFT)
#define SDMMC_CMD_XFER_MODE_0_DMA_EN_RANGE                      0:0
#define SDMMC_CMD_XFER_MODE_0_DMA_EN_WOFFSET                    0x0
#define SDMMC_CMD_XFER_MODE_0_DMA_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_DMA_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_CMD_XFER_MODE_0_DMA_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_DMA_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_CMD_XFER_MODE_0_DMA_EN_DISABLE                    _MK_ENUM_CONST(0)
#define SDMMC_CMD_XFER_MODE_0_DMA_EN_ENABLE                     _MK_ENUM_CONST(1)


// Register SDMMC_RESPONSE_R0_R1_0  
#define SDMMC_RESPONSE_R0_R1_0                  _MK_ADDR_CONST(0x10)
#define SDMMC_RESPONSE_R0_R1_0_SECURE                   0x0
#define SDMMC_RESPONSE_R0_R1_0_WORD_COUNT                       0x1
#define SDMMC_RESPONSE_R0_R1_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R0_R1_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define SDMMC_RESPONSE_R0_R1_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R0_R1_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R0_R1_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define SDMMC_RESPONSE_R0_R1_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R0_R1_0_CMD_RESP_31_16_SHIFT                     _MK_SHIFT_CONST(16)
#define SDMMC_RESPONSE_R0_R1_0_CMD_RESP_31_16_FIELD                     (_MK_MASK_CONST(0xffff) << SDMMC_RESPONSE_R0_R1_0_CMD_RESP_31_16_SHIFT)
#define SDMMC_RESPONSE_R0_R1_0_CMD_RESP_31_16_RANGE                     31:16
#define SDMMC_RESPONSE_R0_R1_0_CMD_RESP_31_16_WOFFSET                   0x0
#define SDMMC_RESPONSE_R0_R1_0_CMD_RESP_31_16_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R0_R1_0_CMD_RESP_31_16_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define SDMMC_RESPONSE_R0_R1_0_CMD_RESP_31_16_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R0_R1_0_CMD_RESP_31_16_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define SDMMC_RESPONSE_R0_R1_0_CMD_RESP_15_0_SHIFT                      _MK_SHIFT_CONST(0)
#define SDMMC_RESPONSE_R0_R1_0_CMD_RESP_15_0_FIELD                      (_MK_MASK_CONST(0xffff) << SDMMC_RESPONSE_R0_R1_0_CMD_RESP_15_0_SHIFT)
#define SDMMC_RESPONSE_R0_R1_0_CMD_RESP_15_0_RANGE                      15:0
#define SDMMC_RESPONSE_R0_R1_0_CMD_RESP_15_0_WOFFSET                    0x0
#define SDMMC_RESPONSE_R0_R1_0_CMD_RESP_15_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R0_R1_0_CMD_RESP_15_0_DEFAULT_MASK                       _MK_MASK_CONST(0xffff)
#define SDMMC_RESPONSE_R0_R1_0_CMD_RESP_15_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R0_R1_0_CMD_RESP_15_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register SDMMC_RESPONSE_R2_R3_0  
#define SDMMC_RESPONSE_R2_R3_0                  _MK_ADDR_CONST(0x14)
#define SDMMC_RESPONSE_R2_R3_0_SECURE                   0x0
#define SDMMC_RESPONSE_R2_R3_0_WORD_COUNT                       0x1
#define SDMMC_RESPONSE_R2_R3_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R2_R3_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define SDMMC_RESPONSE_R2_R3_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R2_R3_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R2_R3_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define SDMMC_RESPONSE_R2_R3_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R2_R3_0_CMD_RESP_63_48_SHIFT                     _MK_SHIFT_CONST(16)
#define SDMMC_RESPONSE_R2_R3_0_CMD_RESP_63_48_FIELD                     (_MK_MASK_CONST(0xffff) << SDMMC_RESPONSE_R2_R3_0_CMD_RESP_63_48_SHIFT)
#define SDMMC_RESPONSE_R2_R3_0_CMD_RESP_63_48_RANGE                     31:16
#define SDMMC_RESPONSE_R2_R3_0_CMD_RESP_63_48_WOFFSET                   0x0
#define SDMMC_RESPONSE_R2_R3_0_CMD_RESP_63_48_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R2_R3_0_CMD_RESP_63_48_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define SDMMC_RESPONSE_R2_R3_0_CMD_RESP_63_48_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R2_R3_0_CMD_RESP_63_48_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define SDMMC_RESPONSE_R2_R3_0_CMD_RESP_47_32_SHIFT                     _MK_SHIFT_CONST(0)
#define SDMMC_RESPONSE_R2_R3_0_CMD_RESP_47_32_FIELD                     (_MK_MASK_CONST(0xffff) << SDMMC_RESPONSE_R2_R3_0_CMD_RESP_47_32_SHIFT)
#define SDMMC_RESPONSE_R2_R3_0_CMD_RESP_47_32_RANGE                     15:0
#define SDMMC_RESPONSE_R2_R3_0_CMD_RESP_47_32_WOFFSET                   0x0
#define SDMMC_RESPONSE_R2_R3_0_CMD_RESP_47_32_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R2_R3_0_CMD_RESP_47_32_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define SDMMC_RESPONSE_R2_R3_0_CMD_RESP_47_32_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R2_R3_0_CMD_RESP_47_32_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register SDMMC_RESPONSE_R4_R5_0  
#define SDMMC_RESPONSE_R4_R5_0                  _MK_ADDR_CONST(0x18)
#define SDMMC_RESPONSE_R4_R5_0_SECURE                   0x0
#define SDMMC_RESPONSE_R4_R5_0_WORD_COUNT                       0x1
#define SDMMC_RESPONSE_R4_R5_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R4_R5_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define SDMMC_RESPONSE_R4_R5_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R4_R5_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R4_R5_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define SDMMC_RESPONSE_R4_R5_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R4_R5_0_CMD_RESP_95_80_SHIFT                     _MK_SHIFT_CONST(16)
#define SDMMC_RESPONSE_R4_R5_0_CMD_RESP_95_80_FIELD                     (_MK_MASK_CONST(0xffff) << SDMMC_RESPONSE_R4_R5_0_CMD_RESP_95_80_SHIFT)
#define SDMMC_RESPONSE_R4_R5_0_CMD_RESP_95_80_RANGE                     31:16
#define SDMMC_RESPONSE_R4_R5_0_CMD_RESP_95_80_WOFFSET                   0x0
#define SDMMC_RESPONSE_R4_R5_0_CMD_RESP_95_80_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R4_R5_0_CMD_RESP_95_80_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define SDMMC_RESPONSE_R4_R5_0_CMD_RESP_95_80_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R4_R5_0_CMD_RESP_95_80_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define SDMMC_RESPONSE_R4_R5_0_CMD_RESP_79_64_SHIFT                     _MK_SHIFT_CONST(0)
#define SDMMC_RESPONSE_R4_R5_0_CMD_RESP_79_64_FIELD                     (_MK_MASK_CONST(0xffff) << SDMMC_RESPONSE_R4_R5_0_CMD_RESP_79_64_SHIFT)
#define SDMMC_RESPONSE_R4_R5_0_CMD_RESP_79_64_RANGE                     15:0
#define SDMMC_RESPONSE_R4_R5_0_CMD_RESP_79_64_WOFFSET                   0x0
#define SDMMC_RESPONSE_R4_R5_0_CMD_RESP_79_64_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R4_R5_0_CMD_RESP_79_64_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define SDMMC_RESPONSE_R4_R5_0_CMD_RESP_79_64_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R4_R5_0_CMD_RESP_79_64_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register SDMMC_RESPONSE_R6_R7_0  
#define SDMMC_RESPONSE_R6_R7_0                  _MK_ADDR_CONST(0x1c)
#define SDMMC_RESPONSE_R6_R7_0_SECURE                   0x0
#define SDMMC_RESPONSE_R6_R7_0_WORD_COUNT                       0x1
#define SDMMC_RESPONSE_R6_R7_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R6_R7_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define SDMMC_RESPONSE_R6_R7_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R6_R7_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R6_R7_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define SDMMC_RESPONSE_R6_R7_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R6_R7_0_CMD_RESP_127_112_SHIFT                   _MK_SHIFT_CONST(16)
#define SDMMC_RESPONSE_R6_R7_0_CMD_RESP_127_112_FIELD                   (_MK_MASK_CONST(0xffff) << SDMMC_RESPONSE_R6_R7_0_CMD_RESP_127_112_SHIFT)
#define SDMMC_RESPONSE_R6_R7_0_CMD_RESP_127_112_RANGE                   31:16
#define SDMMC_RESPONSE_R6_R7_0_CMD_RESP_127_112_WOFFSET                 0x0
#define SDMMC_RESPONSE_R6_R7_0_CMD_RESP_127_112_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R6_R7_0_CMD_RESP_127_112_DEFAULT_MASK                    _MK_MASK_CONST(0xffff)
#define SDMMC_RESPONSE_R6_R7_0_CMD_RESP_127_112_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R6_R7_0_CMD_RESP_127_112_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define SDMMC_RESPONSE_R6_R7_0_CMD_RESP_111_96_SHIFT                    _MK_SHIFT_CONST(0)
#define SDMMC_RESPONSE_R6_R7_0_CMD_RESP_111_96_FIELD                    (_MK_MASK_CONST(0xffff) << SDMMC_RESPONSE_R6_R7_0_CMD_RESP_111_96_SHIFT)
#define SDMMC_RESPONSE_R6_R7_0_CMD_RESP_111_96_RANGE                    15:0
#define SDMMC_RESPONSE_R6_R7_0_CMD_RESP_111_96_WOFFSET                  0x0
#define SDMMC_RESPONSE_R6_R7_0_CMD_RESP_111_96_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R6_R7_0_CMD_RESP_111_96_DEFAULT_MASK                     _MK_MASK_CONST(0xffff)
#define SDMMC_RESPONSE_R6_R7_0_CMD_RESP_111_96_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_RESPONSE_R6_R7_0_CMD_RESP_111_96_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register SDMMC_BUFFER_DATA_PORT_0  
#define SDMMC_BUFFER_DATA_PORT_0                        _MK_ADDR_CONST(0x20)
#define SDMMC_BUFFER_DATA_PORT_0_SECURE                         0x0
#define SDMMC_BUFFER_DATA_PORT_0_WORD_COUNT                     0x1
#define SDMMC_BUFFER_DATA_PORT_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define SDMMC_BUFFER_DATA_PORT_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define SDMMC_BUFFER_DATA_PORT_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define SDMMC_BUFFER_DATA_PORT_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_BUFFER_DATA_PORT_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define SDMMC_BUFFER_DATA_PORT_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
// 
#define SDMMC_BUFFER_DATA_PORT_0_BUFFER_DATA_SHIFT                      _MK_SHIFT_CONST(0)
#define SDMMC_BUFFER_DATA_PORT_0_BUFFER_DATA_FIELD                      (_MK_MASK_CONST(0xffffffff) << SDMMC_BUFFER_DATA_PORT_0_BUFFER_DATA_SHIFT)
#define SDMMC_BUFFER_DATA_PORT_0_BUFFER_DATA_RANGE                      31:0
#define SDMMC_BUFFER_DATA_PORT_0_BUFFER_DATA_WOFFSET                    0x0
#define SDMMC_BUFFER_DATA_PORT_0_BUFFER_DATA_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_BUFFER_DATA_PORT_0_BUFFER_DATA_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define SDMMC_BUFFER_DATA_PORT_0_BUFFER_DATA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_BUFFER_DATA_PORT_0_BUFFER_DATA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register SDMMC_PRESENT_STATE_0  
#define SDMMC_PRESENT_STATE_0                   _MK_ADDR_CONST(0x24)
#define SDMMC_PRESENT_STATE_0_SECURE                    0x0
#define SDMMC_PRESENT_STATE_0_WORD_COUNT                        0x1
#define SDMMC_PRESENT_STATE_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_RESET_MASK                        _MK_MASK_CONST(0x1fff0f07)
#define SDMMC_PRESENT_STATE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_READ_MASK                         _MK_MASK_CONST(0x1fff0f07)
#define SDMMC_PRESENT_STATE_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_DAT_7_4_LINE_LEVEL_SHIFT                  _MK_SHIFT_CONST(25)
#define SDMMC_PRESENT_STATE_0_DAT_7_4_LINE_LEVEL_FIELD                  (_MK_MASK_CONST(0xf) << SDMMC_PRESENT_STATE_0_DAT_7_4_LINE_LEVEL_SHIFT)
#define SDMMC_PRESENT_STATE_0_DAT_7_4_LINE_LEVEL_RANGE                  28:25
#define SDMMC_PRESENT_STATE_0_DAT_7_4_LINE_LEVEL_WOFFSET                        0x0
#define SDMMC_PRESENT_STATE_0_DAT_7_4_LINE_LEVEL_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_DAT_7_4_LINE_LEVEL_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define SDMMC_PRESENT_STATE_0_DAT_7_4_LINE_LEVEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_DAT_7_4_LINE_LEVEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define SDMMC_PRESENT_STATE_0_CMD_LINE_LEVEL_SHIFT                      _MK_SHIFT_CONST(24)
#define SDMMC_PRESENT_STATE_0_CMD_LINE_LEVEL_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_PRESENT_STATE_0_CMD_LINE_LEVEL_SHIFT)
#define SDMMC_PRESENT_STATE_0_CMD_LINE_LEVEL_RANGE                      24:24
#define SDMMC_PRESENT_STATE_0_CMD_LINE_LEVEL_WOFFSET                    0x0
#define SDMMC_PRESENT_STATE_0_CMD_LINE_LEVEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CMD_LINE_LEVEL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_PRESENT_STATE_0_CMD_LINE_LEVEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CMD_LINE_LEVEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CMD_LINE_LEVEL_LOW                        _MK_ENUM_CONST(0)
#define SDMMC_PRESENT_STATE_0_CMD_LINE_LEVEL_HIGH                       _MK_ENUM_CONST(1)

#define SDMMC_PRESENT_STATE_0_DAT_3_0_LINE_LEVEL_SHIFT                  _MK_SHIFT_CONST(20)
#define SDMMC_PRESENT_STATE_0_DAT_3_0_LINE_LEVEL_FIELD                  (_MK_MASK_CONST(0xf) << SDMMC_PRESENT_STATE_0_DAT_3_0_LINE_LEVEL_SHIFT)
#define SDMMC_PRESENT_STATE_0_DAT_3_0_LINE_LEVEL_RANGE                  23:20
#define SDMMC_PRESENT_STATE_0_DAT_3_0_LINE_LEVEL_WOFFSET                        0x0
#define SDMMC_PRESENT_STATE_0_DAT_3_0_LINE_LEVEL_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_DAT_3_0_LINE_LEVEL_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define SDMMC_PRESENT_STATE_0_DAT_3_0_LINE_LEVEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_DAT_3_0_LINE_LEVEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define SDMMC_PRESENT_STATE_0_WRITE_PROTECT_LEVEL_SHIFT                 _MK_SHIFT_CONST(19)
#define SDMMC_PRESENT_STATE_0_WRITE_PROTECT_LEVEL_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_PRESENT_STATE_0_WRITE_PROTECT_LEVEL_SHIFT)
#define SDMMC_PRESENT_STATE_0_WRITE_PROTECT_LEVEL_RANGE                 19:19
#define SDMMC_PRESENT_STATE_0_WRITE_PROTECT_LEVEL_WOFFSET                       0x0
#define SDMMC_PRESENT_STATE_0_WRITE_PROTECT_LEVEL_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_WRITE_PROTECT_LEVEL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_PRESENT_STATE_0_WRITE_PROTECT_LEVEL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_WRITE_PROTECT_LEVEL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_WRITE_PROTECT_LEVEL_PROTECTED                     _MK_ENUM_CONST(0)
#define SDMMC_PRESENT_STATE_0_WRITE_PROTECT_LEVEL_ENABLED                       _MK_ENUM_CONST(1)

#define SDMMC_PRESENT_STATE_0_CARD_DETECT_PIN_LEVEL_SHIFT                       _MK_SHIFT_CONST(18)
#define SDMMC_PRESENT_STATE_0_CARD_DETECT_PIN_LEVEL_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_PRESENT_STATE_0_CARD_DETECT_PIN_LEVEL_SHIFT)
#define SDMMC_PRESENT_STATE_0_CARD_DETECT_PIN_LEVEL_RANGE                       18:18
#define SDMMC_PRESENT_STATE_0_CARD_DETECT_PIN_LEVEL_WOFFSET                     0x0
#define SDMMC_PRESENT_STATE_0_CARD_DETECT_PIN_LEVEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CARD_DETECT_PIN_LEVEL_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_PRESENT_STATE_0_CARD_DETECT_PIN_LEVEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CARD_DETECT_PIN_LEVEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CARD_DETECT_PIN_LEVEL_NO_CARD                     _MK_ENUM_CONST(0)
#define SDMMC_PRESENT_STATE_0_CARD_DETECT_PIN_LEVEL_CARD                        _MK_ENUM_CONST(1)

#define SDMMC_PRESENT_STATE_0_CARD_STATE_STABLE_SHIFT                   _MK_SHIFT_CONST(17)
#define SDMMC_PRESENT_STATE_0_CARD_STATE_STABLE_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_PRESENT_STATE_0_CARD_STATE_STABLE_SHIFT)
#define SDMMC_PRESENT_STATE_0_CARD_STATE_STABLE_RANGE                   17:17
#define SDMMC_PRESENT_STATE_0_CARD_STATE_STABLE_WOFFSET                 0x0
#define SDMMC_PRESENT_STATE_0_CARD_STATE_STABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CARD_STATE_STABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_PRESENT_STATE_0_CARD_STATE_STABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CARD_STATE_STABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CARD_STATE_STABLE_DEBOUNCE                        _MK_ENUM_CONST(0)
#define SDMMC_PRESENT_STATE_0_CARD_STATE_STABLE_INSERTED                        _MK_ENUM_CONST(1)

#define SDMMC_PRESENT_STATE_0_CARD_INSERTED_SHIFT                       _MK_SHIFT_CONST(16)
#define SDMMC_PRESENT_STATE_0_CARD_INSERTED_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_PRESENT_STATE_0_CARD_INSERTED_SHIFT)
#define SDMMC_PRESENT_STATE_0_CARD_INSERTED_RANGE                       16:16
#define SDMMC_PRESENT_STATE_0_CARD_INSERTED_WOFFSET                     0x0
#define SDMMC_PRESENT_STATE_0_CARD_INSERTED_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CARD_INSERTED_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_PRESENT_STATE_0_CARD_INSERTED_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CARD_INSERTED_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CARD_INSERTED_DEBOUNCE                    _MK_ENUM_CONST(0)
#define SDMMC_PRESENT_STATE_0_CARD_INSERTED_INSERTED                    _MK_ENUM_CONST(1)

#define SDMMC_PRESENT_STATE_0_BUFFER_READ_EN_SHIFT                      _MK_SHIFT_CONST(11)
#define SDMMC_PRESENT_STATE_0_BUFFER_READ_EN_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_PRESENT_STATE_0_BUFFER_READ_EN_SHIFT)
#define SDMMC_PRESENT_STATE_0_BUFFER_READ_EN_RANGE                      11:11
#define SDMMC_PRESENT_STATE_0_BUFFER_READ_EN_WOFFSET                    0x0
#define SDMMC_PRESENT_STATE_0_BUFFER_READ_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_BUFFER_READ_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_PRESENT_STATE_0_BUFFER_READ_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_BUFFER_READ_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_BUFFER_READ_EN_DISABLE                    _MK_ENUM_CONST(0)
#define SDMMC_PRESENT_STATE_0_BUFFER_READ_EN_ENABLE                     _MK_ENUM_CONST(1)

#define SDMMC_PRESENT_STATE_0_BUFFER_WRITE_EN_SHIFT                     _MK_SHIFT_CONST(10)
#define SDMMC_PRESENT_STATE_0_BUFFER_WRITE_EN_FIELD                     (_MK_MASK_CONST(0x1) << SDMMC_PRESENT_STATE_0_BUFFER_WRITE_EN_SHIFT)
#define SDMMC_PRESENT_STATE_0_BUFFER_WRITE_EN_RANGE                     10:10
#define SDMMC_PRESENT_STATE_0_BUFFER_WRITE_EN_WOFFSET                   0x0
#define SDMMC_PRESENT_STATE_0_BUFFER_WRITE_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_BUFFER_WRITE_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_PRESENT_STATE_0_BUFFER_WRITE_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_BUFFER_WRITE_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_BUFFER_WRITE_EN_DISABLE                   _MK_ENUM_CONST(0)
#define SDMMC_PRESENT_STATE_0_BUFFER_WRITE_EN_ENABLE                    _MK_ENUM_CONST(1)

#define SDMMC_PRESENT_STATE_0_READ_XFER_ACTIVE_SHIFT                    _MK_SHIFT_CONST(9)
#define SDMMC_PRESENT_STATE_0_READ_XFER_ACTIVE_FIELD                    (_MK_MASK_CONST(0x1) << SDMMC_PRESENT_STATE_0_READ_XFER_ACTIVE_SHIFT)
#define SDMMC_PRESENT_STATE_0_READ_XFER_ACTIVE_RANGE                    9:9
#define SDMMC_PRESENT_STATE_0_READ_XFER_ACTIVE_WOFFSET                  0x0
#define SDMMC_PRESENT_STATE_0_READ_XFER_ACTIVE_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_READ_XFER_ACTIVE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_PRESENT_STATE_0_READ_XFER_ACTIVE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_READ_XFER_ACTIVE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_READ_XFER_ACTIVE_NO_DATA                  _MK_ENUM_CONST(0)
#define SDMMC_PRESENT_STATE_0_READ_XFER_ACTIVE_TRANSFERING                      _MK_ENUM_CONST(1)

#define SDMMC_PRESENT_STATE_0_WRITE_XFER_ACTIVE_SHIFT                   _MK_SHIFT_CONST(8)
#define SDMMC_PRESENT_STATE_0_WRITE_XFER_ACTIVE_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_PRESENT_STATE_0_WRITE_XFER_ACTIVE_SHIFT)
#define SDMMC_PRESENT_STATE_0_WRITE_XFER_ACTIVE_RANGE                   8:8
#define SDMMC_PRESENT_STATE_0_WRITE_XFER_ACTIVE_WOFFSET                 0x0
#define SDMMC_PRESENT_STATE_0_WRITE_XFER_ACTIVE_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_WRITE_XFER_ACTIVE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_PRESENT_STATE_0_WRITE_XFER_ACTIVE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_WRITE_XFER_ACTIVE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_WRITE_XFER_ACTIVE_NO_DATA                 _MK_ENUM_CONST(0)
#define SDMMC_PRESENT_STATE_0_WRITE_XFER_ACTIVE_TRANSFERING                     _MK_ENUM_CONST(1)

#define SDMMC_PRESENT_STATE_0_DAT_LINE_ACTIVE_SHIFT                     _MK_SHIFT_CONST(2)
#define SDMMC_PRESENT_STATE_0_DAT_LINE_ACTIVE_FIELD                     (_MK_MASK_CONST(0x1) << SDMMC_PRESENT_STATE_0_DAT_LINE_ACTIVE_SHIFT)
#define SDMMC_PRESENT_STATE_0_DAT_LINE_ACTIVE_RANGE                     2:2
#define SDMMC_PRESENT_STATE_0_DAT_LINE_ACTIVE_WOFFSET                   0x0
#define SDMMC_PRESENT_STATE_0_DAT_LINE_ACTIVE_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_DAT_LINE_ACTIVE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_PRESENT_STATE_0_DAT_LINE_ACTIVE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_DAT_LINE_ACTIVE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_DAT_LINE_ACTIVE_INACTIVE                  _MK_ENUM_CONST(0)
#define SDMMC_PRESENT_STATE_0_DAT_LINE_ACTIVE_ACTIVE                    _MK_ENUM_CONST(1)

#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_DAT_SHIFT                     _MK_SHIFT_CONST(1)
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_DAT_FIELD                     (_MK_MASK_CONST(0x1) << SDMMC_PRESENT_STATE_0_CMD_INHIBIT_DAT_SHIFT)
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_DAT_RANGE                     1:1
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_DAT_WOFFSET                   0x0
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_DAT_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_DAT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_DAT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_DAT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_DAT_INACTIVE                  _MK_ENUM_CONST(0)
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_DAT_ACTIVE                    _MK_ENUM_CONST(1)

#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_CMD_SHIFT                     _MK_SHIFT_CONST(0)
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_CMD_FIELD                     (_MK_MASK_CONST(0x1) << SDMMC_PRESENT_STATE_0_CMD_INHIBIT_CMD_SHIFT)
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_CMD_RANGE                     0:0
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_CMD_WOFFSET                   0x0
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_CMD_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_CMD_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_CMD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_CMD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_CMD_INACTIVE                  _MK_ENUM_CONST(0)
#define SDMMC_PRESENT_STATE_0_CMD_INHIBIT_CMD_ACTIVE                    _MK_ENUM_CONST(1)


// Register SDMMC_POWER_CONTROL_HOST_0  
#define SDMMC_POWER_CONTROL_HOST_0                      _MK_ADDR_CONST(0x28)
#define SDMMC_POWER_CONTROL_HOST_0_SECURE                       0x0
#define SDMMC_POWER_CONTROL_HOST_0_WORD_COUNT                   0x1
#define SDMMC_POWER_CONTROL_HOST_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_RESET_MASK                   _MK_MASK_CONST(0x70f0fff)
#define SDMMC_POWER_CONTROL_HOST_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_READ_MASK                    _MK_MASK_CONST(0x70f0fff)
#define SDMMC_POWER_CONTROL_HOST_0_WRITE_MASK                   _MK_MASK_CONST(0x70f0fff)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_REMOVAL_SHIFT                 _MK_SHIFT_CONST(26)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_REMOVAL_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_REMOVAL_SHIFT)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_REMOVAL_RANGE                 26:26
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_REMOVAL_WOFFSET                       0x0
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_REMOVAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_REMOVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_REMOVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_REMOVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_REMOVAL_DISABLE                       _MK_ENUM_CONST(0)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_REMOVAL_ENABLE                        _MK_ENUM_CONST(1)

#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INSERTION_SHIFT                       _MK_SHIFT_CONST(25)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INSERTION_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INSERTION_SHIFT)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INSERTION_RANGE                       25:25
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INSERTION_WOFFSET                     0x0
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INSERTION_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INSERTION_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INSERTION_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INSERTION_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INSERTION_DISABLE                     _MK_ENUM_CONST(0)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INSERTION_ENABLE                      _MK_ENUM_CONST(1)

#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INTERRUPT_SHIFT                       _MK_SHIFT_CONST(24)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INTERRUPT_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INTERRUPT_SHIFT)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INTERRUPT_RANGE                       24:24
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INTERRUPT_WOFFSET                     0x0
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INTERRUPT_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INTERRUPT_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INTERRUPT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INTERRUPT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INTERRUPT_DISABLE                     _MK_ENUM_CONST(0)
#define SDMMC_POWER_CONTROL_HOST_0_WAKEUP_ON_CARD_INTERRUPT_ENABLE                      _MK_ENUM_CONST(1)

#define SDMMC_POWER_CONTROL_HOST_0_INTERRUPT_AT_BLOCK_GAP_SHIFT                 _MK_SHIFT_CONST(19)
#define SDMMC_POWER_CONTROL_HOST_0_INTERRUPT_AT_BLOCK_GAP_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_POWER_CONTROL_HOST_0_INTERRUPT_AT_BLOCK_GAP_SHIFT)
#define SDMMC_POWER_CONTROL_HOST_0_INTERRUPT_AT_BLOCK_GAP_RANGE                 19:19
#define SDMMC_POWER_CONTROL_HOST_0_INTERRUPT_AT_BLOCK_GAP_WOFFSET                       0x0
#define SDMMC_POWER_CONTROL_HOST_0_INTERRUPT_AT_BLOCK_GAP_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_INTERRUPT_AT_BLOCK_GAP_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_POWER_CONTROL_HOST_0_INTERRUPT_AT_BLOCK_GAP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_INTERRUPT_AT_BLOCK_GAP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_INTERRUPT_AT_BLOCK_GAP_DISABLE                       _MK_ENUM_CONST(0)
#define SDMMC_POWER_CONTROL_HOST_0_INTERRUPT_AT_BLOCK_GAP_ENABLE                        _MK_ENUM_CONST(1)

#define SDMMC_POWER_CONTROL_HOST_0_READ_WAIT_CONTROL_SHIFT                      _MK_SHIFT_CONST(18)
#define SDMMC_POWER_CONTROL_HOST_0_READ_WAIT_CONTROL_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_POWER_CONTROL_HOST_0_READ_WAIT_CONTROL_SHIFT)
#define SDMMC_POWER_CONTROL_HOST_0_READ_WAIT_CONTROL_RANGE                      18:18
#define SDMMC_POWER_CONTROL_HOST_0_READ_WAIT_CONTROL_WOFFSET                    0x0
#define SDMMC_POWER_CONTROL_HOST_0_READ_WAIT_CONTROL_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_READ_WAIT_CONTROL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_POWER_CONTROL_HOST_0_READ_WAIT_CONTROL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_READ_WAIT_CONTROL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_READ_WAIT_CONTROL_DISABLE                    _MK_ENUM_CONST(0)
#define SDMMC_POWER_CONTROL_HOST_0_READ_WAIT_CONTROL_ENABLE                     _MK_ENUM_CONST(1)

#define SDMMC_POWER_CONTROL_HOST_0_CONTINUE_REQUEST_SHIFT                       _MK_SHIFT_CONST(17)
#define SDMMC_POWER_CONTROL_HOST_0_CONTINUE_REQUEST_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_POWER_CONTROL_HOST_0_CONTINUE_REQUEST_SHIFT)
#define SDMMC_POWER_CONTROL_HOST_0_CONTINUE_REQUEST_RANGE                       17:17
#define SDMMC_POWER_CONTROL_HOST_0_CONTINUE_REQUEST_WOFFSET                     0x0
#define SDMMC_POWER_CONTROL_HOST_0_CONTINUE_REQUEST_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_CONTINUE_REQUEST_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_POWER_CONTROL_HOST_0_CONTINUE_REQUEST_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_CONTINUE_REQUEST_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_CONTINUE_REQUEST_IGNORED                     _MK_ENUM_CONST(0)
#define SDMMC_POWER_CONTROL_HOST_0_CONTINUE_REQUEST_RESTART                     _MK_ENUM_CONST(1)

#define SDMMC_POWER_CONTROL_HOST_0_STOP_AT_BLOCK_GAP_REQUEST_SHIFT                      _MK_SHIFT_CONST(16)
#define SDMMC_POWER_CONTROL_HOST_0_STOP_AT_BLOCK_GAP_REQUEST_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_POWER_CONTROL_HOST_0_STOP_AT_BLOCK_GAP_REQUEST_SHIFT)
#define SDMMC_POWER_CONTROL_HOST_0_STOP_AT_BLOCK_GAP_REQUEST_RANGE                      16:16
#define SDMMC_POWER_CONTROL_HOST_0_STOP_AT_BLOCK_GAP_REQUEST_WOFFSET                    0x0
#define SDMMC_POWER_CONTROL_HOST_0_STOP_AT_BLOCK_GAP_REQUEST_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_STOP_AT_BLOCK_GAP_REQUEST_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_POWER_CONTROL_HOST_0_STOP_AT_BLOCK_GAP_REQUEST_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_STOP_AT_BLOCK_GAP_REQUEST_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_STOP_AT_BLOCK_GAP_REQUEST_STOP                       _MK_ENUM_CONST(0)
#define SDMMC_POWER_CONTROL_HOST_0_STOP_AT_BLOCK_GAP_REQUEST_TRANSFER                   _MK_ENUM_CONST(1)

#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_VOLTAGE_SELECT_SHIFT                  _MK_SHIFT_CONST(9)
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_VOLTAGE_SELECT_FIELD                  (_MK_MASK_CONST(0x7) << SDMMC_POWER_CONTROL_HOST_0_SD_BUS_VOLTAGE_SELECT_SHIFT)
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_VOLTAGE_SELECT_RANGE                  11:9
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_VOLTAGE_SELECT_WOFFSET                        0x0
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_VOLTAGE_SELECT_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_VOLTAGE_SELECT_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_VOLTAGE_SELECT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_VOLTAGE_SELECT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_VOLTAGE_SELECT_V1_8                   _MK_ENUM_CONST(5)
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_VOLTAGE_SELECT_V3_0                   _MK_ENUM_CONST(6)
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_VOLTAGE_SELECT_V3_3                   _MK_ENUM_CONST(7)

#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_POWER_SHIFT                   _MK_SHIFT_CONST(8)
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_POWER_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_POWER_CONTROL_HOST_0_SD_BUS_POWER_SHIFT)
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_POWER_RANGE                   8:8
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_POWER_WOFFSET                 0x0
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_POWER_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_POWER_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_POWER_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_POWER_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_POWER_POWER_OFF                       _MK_ENUM_CONST(0)
#define SDMMC_POWER_CONTROL_HOST_0_SD_BUS_POWER_POWER_ON                        _MK_ENUM_CONST(1)

#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_SIGNAL_DETECT_SHIFT                      _MK_SHIFT_CONST(7)
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_SIGNAL_DETECT_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_SIGNAL_DETECT_SHIFT)
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_SIGNAL_DETECT_RANGE                      7:7
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_SIGNAL_DETECT_WOFFSET                    0x0
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_SIGNAL_DETECT_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_SIGNAL_DETECT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_SIGNAL_DETECT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_SIGNAL_DETECT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_SIGNAL_DETECT_SDCD                       _MK_ENUM_CONST(0)
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_SIGNAL_DETECT_CARD_DTECT_TST_LVL                 _MK_ENUM_CONST(1)

#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_TEST_LVL_SHIFT                   _MK_SHIFT_CONST(6)
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_TEST_LVL_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_TEST_LVL_SHIFT)
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_TEST_LVL_RANGE                   6:6
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_TEST_LVL_WOFFSET                 0x0
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_TEST_LVL_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_TEST_LVL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_TEST_LVL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_TEST_LVL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_TEST_LVL_NO_CARD                 _MK_ENUM_CONST(0)
#define SDMMC_POWER_CONTROL_HOST_0_CARD_DETECT_TEST_LVL_CARD_INSERTED                   _MK_ENUM_CONST(1)

#define SDMMC_POWER_CONTROL_HOST_0_EXTENDED_DATA_TRANSFER_WIDTH_SHIFT                   _MK_SHIFT_CONST(5)
#define SDMMC_POWER_CONTROL_HOST_0_EXTENDED_DATA_TRANSFER_WIDTH_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_POWER_CONTROL_HOST_0_EXTENDED_DATA_TRANSFER_WIDTH_SHIFT)
#define SDMMC_POWER_CONTROL_HOST_0_EXTENDED_DATA_TRANSFER_WIDTH_RANGE                   5:5
#define SDMMC_POWER_CONTROL_HOST_0_EXTENDED_DATA_TRANSFER_WIDTH_WOFFSET                 0x0
#define SDMMC_POWER_CONTROL_HOST_0_EXTENDED_DATA_TRANSFER_WIDTH_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_EXTENDED_DATA_TRANSFER_WIDTH_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_POWER_CONTROL_HOST_0_EXTENDED_DATA_TRANSFER_WIDTH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_EXTENDED_DATA_TRANSFER_WIDTH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_EXTENDED_DATA_TRANSFER_WIDTH_NOBIT_8                 _MK_ENUM_CONST(0)
#define SDMMC_POWER_CONTROL_HOST_0_EXTENDED_DATA_TRANSFER_WIDTH_BIT_8                   _MK_ENUM_CONST(1)

#define SDMMC_POWER_CONTROL_HOST_0_DMA_SELECT_SHIFT                     _MK_SHIFT_CONST(3)
#define SDMMC_POWER_CONTROL_HOST_0_DMA_SELECT_FIELD                     (_MK_MASK_CONST(0x3) << SDMMC_POWER_CONTROL_HOST_0_DMA_SELECT_SHIFT)
#define SDMMC_POWER_CONTROL_HOST_0_DMA_SELECT_RANGE                     4:3
#define SDMMC_POWER_CONTROL_HOST_0_DMA_SELECT_WOFFSET                   0x0
#define SDMMC_POWER_CONTROL_HOST_0_DMA_SELECT_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_DMA_SELECT_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define SDMMC_POWER_CONTROL_HOST_0_DMA_SELECT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_DMA_SELECT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_DMA_SELECT_SDMA                      _MK_ENUM_CONST(0)
#define SDMMC_POWER_CONTROL_HOST_0_DMA_SELECT_ADMA1_32BIT                       _MK_ENUM_CONST(1)
#define SDMMC_POWER_CONTROL_HOST_0_DMA_SELECT_ADMA2_32BIT                       _MK_ENUM_CONST(2)
#define SDMMC_POWER_CONTROL_HOST_0_DMA_SELECT_ADMA2_64BIT                       _MK_ENUM_CONST(3)

#define SDMMC_POWER_CONTROL_HOST_0_HIGH_SPEED_EN_SHIFT                  _MK_SHIFT_CONST(2)
#define SDMMC_POWER_CONTROL_HOST_0_HIGH_SPEED_EN_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_POWER_CONTROL_HOST_0_HIGH_SPEED_EN_SHIFT)
#define SDMMC_POWER_CONTROL_HOST_0_HIGH_SPEED_EN_RANGE                  2:2
#define SDMMC_POWER_CONTROL_HOST_0_HIGH_SPEED_EN_WOFFSET                        0x0
#define SDMMC_POWER_CONTROL_HOST_0_HIGH_SPEED_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_HIGH_SPEED_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_POWER_CONTROL_HOST_0_HIGH_SPEED_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_HIGH_SPEED_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_HIGH_SPEED_EN_NORMAL_SPEED                   _MK_ENUM_CONST(0)
#define SDMMC_POWER_CONTROL_HOST_0_HIGH_SPEED_EN_HIGH_SPEED                     _MK_ENUM_CONST(1)

#define SDMMC_POWER_CONTROL_HOST_0_DATA_XFER_WIDTH_SHIFT                        _MK_SHIFT_CONST(1)
#define SDMMC_POWER_CONTROL_HOST_0_DATA_XFER_WIDTH_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_POWER_CONTROL_HOST_0_DATA_XFER_WIDTH_SHIFT)
#define SDMMC_POWER_CONTROL_HOST_0_DATA_XFER_WIDTH_RANGE                        1:1
#define SDMMC_POWER_CONTROL_HOST_0_DATA_XFER_WIDTH_WOFFSET                      0x0
#define SDMMC_POWER_CONTROL_HOST_0_DATA_XFER_WIDTH_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_DATA_XFER_WIDTH_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_POWER_CONTROL_HOST_0_DATA_XFER_WIDTH_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_DATA_XFER_WIDTH_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_DATA_XFER_WIDTH_BIT_1                        _MK_ENUM_CONST(0)
#define SDMMC_POWER_CONTROL_HOST_0_DATA_XFER_WIDTH_BIT_4                        _MK_ENUM_CONST(1)

#define SDMMC_POWER_CONTROL_HOST_0_LED_CONTROL_SHIFT                    _MK_SHIFT_CONST(0)
#define SDMMC_POWER_CONTROL_HOST_0_LED_CONTROL_FIELD                    (_MK_MASK_CONST(0x1) << SDMMC_POWER_CONTROL_HOST_0_LED_CONTROL_SHIFT)
#define SDMMC_POWER_CONTROL_HOST_0_LED_CONTROL_RANGE                    0:0
#define SDMMC_POWER_CONTROL_HOST_0_LED_CONTROL_WOFFSET                  0x0
#define SDMMC_POWER_CONTROL_HOST_0_LED_CONTROL_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_LED_CONTROL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_POWER_CONTROL_HOST_0_LED_CONTROL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_LED_CONTROL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_POWER_CONTROL_HOST_0_LED_CONTROL_OFF                      _MK_ENUM_CONST(0)
#define SDMMC_POWER_CONTROL_HOST_0_LED_CONTROL_ON                       _MK_ENUM_CONST(1)


// Register SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0  
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0                     _MK_ADDR_CONST(0x2c)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SECURE                      0x0
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_WORD_COUNT                  0x1
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_RESET_MASK                  _MK_MASK_CONST(0x70fff07)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_READ_MASK                   _MK_MASK_CONST(0x70fff07)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_WRITE_MASK                  _MK_MASK_CONST(0x70fff05)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_DAT_LINE_SHIFT                 _MK_SHIFT_CONST(26)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_DAT_LINE_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_DAT_LINE_SHIFT)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_DAT_LINE_RANGE                 26:26
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_DAT_LINE_WOFFSET                       0x0
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_DAT_LINE_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_DAT_LINE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_DAT_LINE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_DAT_LINE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_DAT_LINE_WORK                  _MK_ENUM_CONST(0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_DAT_LINE_RESETED                       _MK_ENUM_CONST(1)

#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_CMD_LINE_SHIFT                 _MK_SHIFT_CONST(25)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_CMD_LINE_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_CMD_LINE_SHIFT)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_CMD_LINE_RANGE                 25:25
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_CMD_LINE_WOFFSET                       0x0
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_CMD_LINE_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_CMD_LINE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_CMD_LINE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_CMD_LINE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_CMD_LINE_WORK                  _MK_ENUM_CONST(0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_CMD_LINE_RESETED                       _MK_ENUM_CONST(1)

#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_ALL_SHIFT                      _MK_SHIFT_CONST(24)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_ALL_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_ALL_SHIFT)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_ALL_RANGE                      24:24
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_ALL_WOFFSET                    0x0
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_ALL_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_ALL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_ALL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_ALL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_ALL_WORK                       _MK_ENUM_CONST(0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SW_RESET_FOR_ALL_RESETED                    _MK_ENUM_CONST(1)

#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_DATA_TIMEOUT_COUNTER_VALUE_SHIFT                    _MK_SHIFT_CONST(16)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_DATA_TIMEOUT_COUNTER_VALUE_FIELD                    (_MK_MASK_CONST(0xf) << SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_DATA_TIMEOUT_COUNTER_VALUE_SHIFT)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_DATA_TIMEOUT_COUNTER_VALUE_RANGE                    19:16
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_DATA_TIMEOUT_COUNTER_VALUE_WOFFSET                  0x0
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_DATA_TIMEOUT_COUNTER_VALUE_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_DATA_TIMEOUT_COUNTER_VALUE_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_DATA_TIMEOUT_COUNTER_VALUE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_DATA_TIMEOUT_COUNTER_VALUE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_SHIFT                 _MK_SHIFT_CONST(8)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_FIELD                 (_MK_MASK_CONST(0xff) << SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_SHIFT)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_RANGE                 15:8
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_WOFFSET                       0x0
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_DIV256                        _MK_ENUM_CONST(128)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_DIV128                        _MK_ENUM_CONST(64)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_DIV64                 _MK_ENUM_CONST(32)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_DIV32                 _MK_ENUM_CONST(16)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_DIV16                 _MK_ENUM_CONST(8)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_DIV8                  _MK_ENUM_CONST(4)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_DIV4                  _MK_ENUM_CONST(2)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_DIV2                  _MK_ENUM_CONST(1)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SDCLK_FREQUENCYSELECT_BASE                  _MK_ENUM_CONST(0)

#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SD_CLOCK_EN_SHIFT                   _MK_SHIFT_CONST(2)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SD_CLOCK_EN_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SD_CLOCK_EN_SHIFT)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SD_CLOCK_EN_RANGE                   2:2
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SD_CLOCK_EN_WOFFSET                 0x0
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SD_CLOCK_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SD_CLOCK_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SD_CLOCK_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SD_CLOCK_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SD_CLOCK_EN_DISABLE                 _MK_ENUM_CONST(0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_SD_CLOCK_EN_ENABLE                  _MK_ENUM_CONST(1)

#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_STABLE_SHIFT                 _MK_SHIFT_CONST(1)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_STABLE_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_STABLE_SHIFT)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_STABLE_RANGE                 1:1
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_STABLE_WOFFSET                       0x0
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_STABLE_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_STABLE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_STABLE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_STABLE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_STABLE_NOT_READY                     _MK_ENUM_CONST(0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_STABLE_READY                 _MK_ENUM_CONST(1)

#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_EN_SHIFT                     _MK_SHIFT_CONST(0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_EN_FIELD                     (_MK_MASK_CONST(0x1) << SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_EN_SHIFT)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_EN_RANGE                     0:0
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_EN_WOFFSET                   0x0
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_EN_STOP                      _MK_ENUM_CONST(0)
#define SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0_INTERNAL_CLOCK_EN_OSCILLATE                 _MK_ENUM_CONST(1)


// Register SDMMC_INTERRUPT_STATUS_0  
#define SDMMC_INTERRUPT_STATUS_0                        _MK_ADDR_CONST(0x30)
#define SDMMC_INTERRUPT_STATUS_0_SECURE                         0x0
#define SDMMC_INTERRUPT_STATUS_0_WORD_COUNT                     0x1
#define SDMMC_INTERRUPT_STATUS_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_RESET_MASK                     _MK_MASK_CONST(0xfbff81ff)
#define SDMMC_INTERRUPT_STATUS_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_READ_MASK                      _MK_MASK_CONST(0xfbff81ff)
#define SDMMC_INTERRUPT_STATUS_0_WRITE_MASK                     _MK_MASK_CONST(0xfbff00ff)
#define SDMMC_INTERRUPT_STATUS_0_VEND_SPEC_ERR_SHIFT                    _MK_SHIFT_CONST(30)
#define SDMMC_INTERRUPT_STATUS_0_VEND_SPEC_ERR_FIELD                    (_MK_MASK_CONST(0x3) << SDMMC_INTERRUPT_STATUS_0_VEND_SPEC_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_VEND_SPEC_ERR_RANGE                    31:30
#define SDMMC_INTERRUPT_STATUS_0_VEND_SPEC_ERR_WOFFSET                  0x0
#define SDMMC_INTERRUPT_STATUS_0_VEND_SPEC_ERR_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_VEND_SPEC_ERR_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define SDMMC_INTERRUPT_STATUS_0_VEND_SPEC_ERR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_VEND_SPEC_ERR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_VEND_SPEC_ERR_DISABLE                  _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_VEND_SPEC_ERR_ENABLE                   _MK_ENUM_CONST(3)

#define SDMMC_INTERRUPT_STATUS_0_CEATA_ERROR_SHIFT                      _MK_SHIFT_CONST(29)
#define SDMMC_INTERRUPT_STATUS_0_CEATA_ERROR_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_CEATA_ERROR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_CEATA_ERROR_RANGE                      29:29
#define SDMMC_INTERRUPT_STATUS_0_CEATA_ERROR_WOFFSET                    0x0
#define SDMMC_INTERRUPT_STATUS_0_CEATA_ERROR_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CEATA_ERROR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_CEATA_ERROR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CEATA_ERROR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CEATA_ERROR_NO_ERROR                   _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_CEATA_ERROR_ERROR                      _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_TARGET_RESP_ERROR_SHIFT                        _MK_SHIFT_CONST(28)
#define SDMMC_INTERRUPT_STATUS_0_TARGET_RESP_ERROR_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_TARGET_RESP_ERROR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_TARGET_RESP_ERROR_RANGE                        28:28
#define SDMMC_INTERRUPT_STATUS_0_TARGET_RESP_ERROR_WOFFSET                      0x0
#define SDMMC_INTERRUPT_STATUS_0_TARGET_RESP_ERROR_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_TARGET_RESP_ERROR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_TARGET_RESP_ERROR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_TARGET_RESP_ERROR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_TARGET_RESP_ERROR_NO_ERROR                     _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_TARGET_RESP_ERROR_ERROR                        _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_SPI_ERR_SHIFT                  _MK_SHIFT_CONST(27)
#define SDMMC_INTERRUPT_STATUS_0_SPI_ERR_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_SPI_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_SPI_ERR_RANGE                  27:27
#define SDMMC_INTERRUPT_STATUS_0_SPI_ERR_WOFFSET                        0x0
#define SDMMC_INTERRUPT_STATUS_0_SPI_ERR_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_SPI_ERR_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_SPI_ERR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_SPI_ERR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_SPI_ERR_NO_ERR                 _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_SPI_ERR_ERR                    _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_ADMA_ERR_SHIFT                 _MK_SHIFT_CONST(25)
#define SDMMC_INTERRUPT_STATUS_0_ADMA_ERR_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_ADMA_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_ADMA_ERR_RANGE                 25:25
#define SDMMC_INTERRUPT_STATUS_0_ADMA_ERR_WOFFSET                       0x0
#define SDMMC_INTERRUPT_STATUS_0_ADMA_ERR_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_ADMA_ERR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_ADMA_ERR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_ADMA_ERR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_ADMA_ERR_NO_ERR                        _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_ADMA_ERR_ERR                   _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_AUTO_CMD12_ERR_SHIFT                   _MK_SHIFT_CONST(24)
#define SDMMC_INTERRUPT_STATUS_0_AUTO_CMD12_ERR_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_AUTO_CMD12_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_AUTO_CMD12_ERR_RANGE                   24:24
#define SDMMC_INTERRUPT_STATUS_0_AUTO_CMD12_ERR_WOFFSET                 0x0
#define SDMMC_INTERRUPT_STATUS_0_AUTO_CMD12_ERR_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_AUTO_CMD12_ERR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_AUTO_CMD12_ERR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_AUTO_CMD12_ERR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_AUTO_CMD12_ERR_NO_ERR                  _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_AUTO_CMD12_ERR_ERR                     _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_CURRENT_LIMIT_ERR_SHIFT                        _MK_SHIFT_CONST(23)
#define SDMMC_INTERRUPT_STATUS_0_CURRENT_LIMIT_ERR_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_CURRENT_LIMIT_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_CURRENT_LIMIT_ERR_RANGE                        23:23
#define SDMMC_INTERRUPT_STATUS_0_CURRENT_LIMIT_ERR_WOFFSET                      0x0
#define SDMMC_INTERRUPT_STATUS_0_CURRENT_LIMIT_ERR_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CURRENT_LIMIT_ERR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_CURRENT_LIMIT_ERR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CURRENT_LIMIT_ERR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CURRENT_LIMIT_ERR_NO_ERR                       _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_CURRENT_LIMIT_ERR_POWER_FAIL                   _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_DATA_END_BIT_ERR_SHIFT                 _MK_SHIFT_CONST(22)
#define SDMMC_INTERRUPT_STATUS_0_DATA_END_BIT_ERR_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_DATA_END_BIT_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_DATA_END_BIT_ERR_RANGE                 22:22
#define SDMMC_INTERRUPT_STATUS_0_DATA_END_BIT_ERR_WOFFSET                       0x0
#define SDMMC_INTERRUPT_STATUS_0_DATA_END_BIT_ERR_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_DATA_END_BIT_ERR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_DATA_END_BIT_ERR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_DATA_END_BIT_ERR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_DATA_END_BIT_ERR_NO_ERR                        _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_DATA_END_BIT_ERR_ERR                   _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_DATA_CRC_ERR_SHIFT                     _MK_SHIFT_CONST(21)
#define SDMMC_INTERRUPT_STATUS_0_DATA_CRC_ERR_FIELD                     (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_DATA_CRC_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_DATA_CRC_ERR_RANGE                     21:21
#define SDMMC_INTERRUPT_STATUS_0_DATA_CRC_ERR_WOFFSET                   0x0
#define SDMMC_INTERRUPT_STATUS_0_DATA_CRC_ERR_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_DATA_CRC_ERR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_DATA_CRC_ERR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_DATA_CRC_ERR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_DATA_CRC_ERR_NO_ERR                    _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_DATA_CRC_ERR_ERR                       _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_DATA_TIMEOUT_ERR_SHIFT                 _MK_SHIFT_CONST(20)
#define SDMMC_INTERRUPT_STATUS_0_DATA_TIMEOUT_ERR_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_DATA_TIMEOUT_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_DATA_TIMEOUT_ERR_RANGE                 20:20
#define SDMMC_INTERRUPT_STATUS_0_DATA_TIMEOUT_ERR_WOFFSET                       0x0
#define SDMMC_INTERRUPT_STATUS_0_DATA_TIMEOUT_ERR_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_DATA_TIMEOUT_ERR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_DATA_TIMEOUT_ERR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_DATA_TIMEOUT_ERR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_DATA_TIMEOUT_ERR_NO_ERR                        _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_DATA_TIMEOUT_ERR_TIMEOUT                       _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_COMMAND_INDEX_ERR_SHIFT                        _MK_SHIFT_CONST(19)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_INDEX_ERR_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_COMMAND_INDEX_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_INDEX_ERR_RANGE                        19:19
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_INDEX_ERR_WOFFSET                      0x0
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_INDEX_ERR_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_INDEX_ERR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_INDEX_ERR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_INDEX_ERR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_INDEX_ERR_NO_ERR                       _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_INDEX_ERR_ERR                  _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_COMMAND_END_BIT_ERR_SHIFT                      _MK_SHIFT_CONST(18)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_END_BIT_ERR_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_COMMAND_END_BIT_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_END_BIT_ERR_RANGE                      18:18
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_END_BIT_ERR_WOFFSET                    0x0
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_END_BIT_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_END_BIT_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_END_BIT_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_END_BIT_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_END_BIT_ERR_NO_ERR                     _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_END_BIT_ERR_END_BIT_ERR_GENERATED                      _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_COMMAND_CRC_ERR_SHIFT                  _MK_SHIFT_CONST(17)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_CRC_ERR_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_COMMAND_CRC_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_CRC_ERR_RANGE                  17:17
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_CRC_ERR_WOFFSET                        0x0
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_CRC_ERR_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_CRC_ERR_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_CRC_ERR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_CRC_ERR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_CRC_ERR_NO_ERR                 _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_CRC_ERR_CRC_ERR_GENERATED                      _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_COMMAND_TIMEOUT_ERR_SHIFT                      _MK_SHIFT_CONST(16)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_TIMEOUT_ERR_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_COMMAND_TIMEOUT_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_TIMEOUT_ERR_RANGE                      16:16
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_TIMEOUT_ERR_WOFFSET                    0x0
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_TIMEOUT_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_TIMEOUT_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_TIMEOUT_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_TIMEOUT_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_TIMEOUT_ERR_NO_ERR                     _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_COMMAND_TIMEOUT_ERR_TIMEOUT                    _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_ERR_INTERRUPT_SHIFT                    _MK_SHIFT_CONST(15)
#define SDMMC_INTERRUPT_STATUS_0_ERR_INTERRUPT_FIELD                    (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_ERR_INTERRUPT_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_ERR_INTERRUPT_RANGE                    15:15
#define SDMMC_INTERRUPT_STATUS_0_ERR_INTERRUPT_WOFFSET                  0x0
#define SDMMC_INTERRUPT_STATUS_0_ERR_INTERRUPT_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_ERR_INTERRUPT_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_ERR_INTERRUPT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_ERR_INTERRUPT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_ERR_INTERRUPT_NO_ERR                   _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_ERR_INTERRUPT_ERR                      _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_CARD_INTERRUPT_SHIFT                   _MK_SHIFT_CONST(8)
#define SDMMC_INTERRUPT_STATUS_0_CARD_INTERRUPT_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_CARD_INTERRUPT_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_CARD_INTERRUPT_RANGE                   8:8
#define SDMMC_INTERRUPT_STATUS_0_CARD_INTERRUPT_WOFFSET                 0x0
#define SDMMC_INTERRUPT_STATUS_0_CARD_INTERRUPT_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CARD_INTERRUPT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_CARD_INTERRUPT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CARD_INTERRUPT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CARD_INTERRUPT_NO_INT                  _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_CARD_INTERRUPT_GEN_INT                 _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_CARD_REMOVAL_SHIFT                     _MK_SHIFT_CONST(7)
#define SDMMC_INTERRUPT_STATUS_0_CARD_REMOVAL_FIELD                     (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_CARD_REMOVAL_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_CARD_REMOVAL_RANGE                     7:7
#define SDMMC_INTERRUPT_STATUS_0_CARD_REMOVAL_WOFFSET                   0x0
#define SDMMC_INTERRUPT_STATUS_0_CARD_REMOVAL_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CARD_REMOVAL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_CARD_REMOVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CARD_REMOVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CARD_REMOVAL_NO_INT                    _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_CARD_REMOVAL_GEN_INT                   _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_CARD_INSERTION_SHIFT                   _MK_SHIFT_CONST(6)
#define SDMMC_INTERRUPT_STATUS_0_CARD_INSERTION_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_CARD_INSERTION_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_CARD_INSERTION_RANGE                   6:6
#define SDMMC_INTERRUPT_STATUS_0_CARD_INSERTION_WOFFSET                 0x0
#define SDMMC_INTERRUPT_STATUS_0_CARD_INSERTION_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CARD_INSERTION_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_CARD_INSERTION_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CARD_INSERTION_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CARD_INSERTION_NO_INT                  _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_CARD_INSERTION_GEN_INT                 _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_BUFFER_READ_READY_SHIFT                        _MK_SHIFT_CONST(5)
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_READ_READY_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_BUFFER_READ_READY_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_READ_READY_RANGE                        5:5
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_READ_READY_WOFFSET                      0x0
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_READ_READY_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_READ_READY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_READ_READY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_READ_READY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_READ_READY_NO_INT                       _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_READ_READY_GEN_INT                      _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_BUFFER_WRITE_READY_SHIFT                       _MK_SHIFT_CONST(4)
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_WRITE_READY_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_BUFFER_WRITE_READY_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_WRITE_READY_RANGE                       4:4
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_WRITE_READY_WOFFSET                     0x0
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_WRITE_READY_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_WRITE_READY_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_WRITE_READY_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_WRITE_READY_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_WRITE_READY_NO_INT                      _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_BUFFER_WRITE_READY_GEN_INT                     _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_DMA_INTERRUPT_SHIFT                    _MK_SHIFT_CONST(3)
#define SDMMC_INTERRUPT_STATUS_0_DMA_INTERRUPT_FIELD                    (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_DMA_INTERRUPT_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_DMA_INTERRUPT_RANGE                    3:3
#define SDMMC_INTERRUPT_STATUS_0_DMA_INTERRUPT_WOFFSET                  0x0
#define SDMMC_INTERRUPT_STATUS_0_DMA_INTERRUPT_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_DMA_INTERRUPT_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_DMA_INTERRUPT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_DMA_INTERRUPT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_DMA_INTERRUPT_NO_INT                   _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_DMA_INTERRUPT_GEN_INT                  _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_BLOCK_GAP_EVENT_SHIFT                  _MK_SHIFT_CONST(2)
#define SDMMC_INTERRUPT_STATUS_0_BLOCK_GAP_EVENT_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_BLOCK_GAP_EVENT_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_BLOCK_GAP_EVENT_RANGE                  2:2
#define SDMMC_INTERRUPT_STATUS_0_BLOCK_GAP_EVENT_WOFFSET                        0x0
#define SDMMC_INTERRUPT_STATUS_0_BLOCK_GAP_EVENT_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_BLOCK_GAP_EVENT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_BLOCK_GAP_EVENT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_BLOCK_GAP_EVENT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_BLOCK_GAP_EVENT_NO_INT                 _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_BLOCK_GAP_EVENT_GEN_INT                        _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_XFER_COMPLETE_SHIFT                    _MK_SHIFT_CONST(1)
#define SDMMC_INTERRUPT_STATUS_0_XFER_COMPLETE_FIELD                    (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_XFER_COMPLETE_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_XFER_COMPLETE_RANGE                    1:1
#define SDMMC_INTERRUPT_STATUS_0_XFER_COMPLETE_WOFFSET                  0x0
#define SDMMC_INTERRUPT_STATUS_0_XFER_COMPLETE_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_XFER_COMPLETE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_XFER_COMPLETE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_XFER_COMPLETE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_XFER_COMPLETE_NO_INT                   _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_XFER_COMPLETE_GEN_INT                  _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_0_CMD_COMPLETE_SHIFT                     _MK_SHIFT_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_CMD_COMPLETE_FIELD                     (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_0_CMD_COMPLETE_SHIFT)
#define SDMMC_INTERRUPT_STATUS_0_CMD_COMPLETE_RANGE                     0:0
#define SDMMC_INTERRUPT_STATUS_0_CMD_COMPLETE_WOFFSET                   0x0
#define SDMMC_INTERRUPT_STATUS_0_CMD_COMPLETE_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CMD_COMPLETE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_0_CMD_COMPLETE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CMD_COMPLETE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_0_CMD_COMPLETE_NO_INT                    _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_0_CMD_COMPLETE_GEN_INT                   _MK_ENUM_CONST(1)


// Register SDMMC_INTERRUPT_STATUS_ENABLE_0  
#define SDMMC_INTERRUPT_STATUS_ENABLE_0                 _MK_ADDR_CONST(0x34)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_SECURE                  0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_WORD_COUNT                      0x1
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_RESET_MASK                      _MK_MASK_CONST(0xfbff01ff)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_READ_MASK                       _MK_MASK_CONST(0xfbff01ff)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_WRITE_MASK                      _MK_MASK_CONST(0xfbff01ff)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_VENDOR_SPECIFIC_ERR_SHIFT                       _MK_SHIFT_CONST(30)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_VENDOR_SPECIFIC_ERR_FIELD                       (_MK_MASK_CONST(0x3) << SDMMC_INTERRUPT_STATUS_ENABLE_0_VENDOR_SPECIFIC_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_VENDOR_SPECIFIC_ERR_RANGE                       31:30
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_VENDOR_SPECIFIC_ERR_WOFFSET                     0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_VENDOR_SPECIFIC_ERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_VENDOR_SPECIFIC_ERR_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_VENDOR_SPECIFIC_ERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_VENDOR_SPECIFIC_ERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_VENDOR_SPECIFIC_ERR_DISABLE                     _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_VENDOR_SPECIFIC_ERR_ENABLE                      _MK_ENUM_CONST(3)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CEATA_ERROR_SHIFT                       _MK_SHIFT_CONST(29)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CEATA_ERROR_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_CEATA_ERROR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CEATA_ERROR_RANGE                       29:29
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CEATA_ERROR_WOFFSET                     0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CEATA_ERROR_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CEATA_ERROR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CEATA_ERROR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CEATA_ERROR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CEATA_ERROR_NO_ERROR                    _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CEATA_ERROR_ERROR                       _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TARGET_RESP_ERROR_SHIFT                 _MK_SHIFT_CONST(28)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TARGET_RESP_ERROR_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_TARGET_RESP_ERROR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TARGET_RESP_ERROR_RANGE                 28:28
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TARGET_RESP_ERROR_WOFFSET                       0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TARGET_RESP_ERROR_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TARGET_RESP_ERROR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TARGET_RESP_ERROR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TARGET_RESP_ERROR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TARGET_RESP_ERROR_NO_ERROR                      _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TARGET_RESP_ERROR_ERROR                 _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_SPI_ERR_SHIFT                   _MK_SHIFT_CONST(27)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_SPI_ERR_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_SPI_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_SPI_ERR_RANGE                   27:27
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_SPI_ERR_WOFFSET                 0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_SPI_ERR_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_SPI_ERR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_SPI_ERR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_SPI_ERR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_SPI_ERR_DISABLE                 _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_SPI_ERR_ENABLE                  _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_ADMA_ERR_SHIFT                  _MK_SHIFT_CONST(25)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_ADMA_ERR_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_ADMA_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_ADMA_ERR_RANGE                  25:25
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_ADMA_ERR_WOFFSET                        0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_ADMA_ERR_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_ADMA_ERR_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_ADMA_ERR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_ADMA_ERR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_ADMA_ERR_DISABLE                        _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_ADMA_ERR_ENABLE                 _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_AUTO_CMD12_ERR_SHIFT                    _MK_SHIFT_CONST(24)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_AUTO_CMD12_ERR_FIELD                    (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_AUTO_CMD12_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_AUTO_CMD12_ERR_RANGE                    24:24
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_AUTO_CMD12_ERR_WOFFSET                  0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_AUTO_CMD12_ERR_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_AUTO_CMD12_ERR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_AUTO_CMD12_ERR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_AUTO_CMD12_ERR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_AUTO_CMD12_ERR_DISABLE                  _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_AUTO_CMD12_ERR_ENABLE                   _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CURRENT_LIMIT_ERR_SHIFT                 _MK_SHIFT_CONST(23)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CURRENT_LIMIT_ERR_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_CURRENT_LIMIT_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CURRENT_LIMIT_ERR_RANGE                 23:23
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CURRENT_LIMIT_ERR_WOFFSET                       0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CURRENT_LIMIT_ERR_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CURRENT_LIMIT_ERR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CURRENT_LIMIT_ERR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CURRENT_LIMIT_ERR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CURRENT_LIMIT_ERR_DISABLE                       _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CURRENT_LIMIT_ERR_ENABLE                        _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_END_BIT_ERR_SHIFT                  _MK_SHIFT_CONST(22)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_END_BIT_ERR_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_END_BIT_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_END_BIT_ERR_RANGE                  22:22
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_END_BIT_ERR_WOFFSET                        0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_END_BIT_ERR_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_END_BIT_ERR_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_END_BIT_ERR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_END_BIT_ERR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_END_BIT_ERR_DISABLE                        _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_END_BIT_ERR_ENABLE                 _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_CRC_ERR_SHIFT                      _MK_SHIFT_CONST(21)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_CRC_ERR_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_CRC_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_CRC_ERR_RANGE                      21:21
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_CRC_ERR_WOFFSET                    0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_CRC_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_CRC_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_CRC_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_CRC_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_CRC_ERR_DISABLE                    _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_CRC_ERR_ENABLE                     _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_TIMEOUT_ERR_SHIFT                  _MK_SHIFT_CONST(20)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_TIMEOUT_ERR_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_TIMEOUT_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_TIMEOUT_ERR_RANGE                  20:20
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_TIMEOUT_ERR_WOFFSET                        0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_TIMEOUT_ERR_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_TIMEOUT_ERR_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_TIMEOUT_ERR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_TIMEOUT_ERR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_TIMEOUT_ERR_DISABLE                        _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DATA_TIMEOUT_ERR_ENABLE                 _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_INDEX_ERR_SHIFT                 _MK_SHIFT_CONST(19)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_INDEX_ERR_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_INDEX_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_INDEX_ERR_RANGE                 19:19
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_INDEX_ERR_WOFFSET                       0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_INDEX_ERR_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_INDEX_ERR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_INDEX_ERR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_INDEX_ERR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_INDEX_ERR_DISABLE                       _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_INDEX_ERR_ENABLE                        _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_END_BIT_ERR_SHIFT                       _MK_SHIFT_CONST(18)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_END_BIT_ERR_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_END_BIT_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_END_BIT_ERR_RANGE                       18:18
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_END_BIT_ERR_WOFFSET                     0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_END_BIT_ERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_END_BIT_ERR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_END_BIT_ERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_END_BIT_ERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_END_BIT_ERR_DISABLE                     _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_END_BIT_ERR_ENABLE                      _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_CRC_ERR_SHIFT                   _MK_SHIFT_CONST(17)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_CRC_ERR_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_CRC_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_CRC_ERR_RANGE                   17:17
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_CRC_ERR_WOFFSET                 0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_CRC_ERR_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_CRC_ERR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_CRC_ERR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_CRC_ERR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_CRC_ERR_DISABLE                 _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_CRC_ERR_ENABLE                  _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_TIMEOUT_ERR_SHIFT                       _MK_SHIFT_CONST(16)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_TIMEOUT_ERR_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_TIMEOUT_ERR_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_TIMEOUT_ERR_RANGE                       16:16
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_TIMEOUT_ERR_WOFFSET                     0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_TIMEOUT_ERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_TIMEOUT_ERR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_TIMEOUT_ERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_TIMEOUT_ERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_TIMEOUT_ERR_DISABLE                     _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_TIMEOUT_ERR_ENABLE                      _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INTERRUPT_SHIFT                    _MK_SHIFT_CONST(8)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INTERRUPT_FIELD                    (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INTERRUPT_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INTERRUPT_RANGE                    8:8
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INTERRUPT_WOFFSET                  0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INTERRUPT_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INTERRUPT_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INTERRUPT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INTERRUPT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INTERRUPT_DISABLE                  _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INTERRUPT_ENABLE                   _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_REMOVAL_SHIFT                      _MK_SHIFT_CONST(7)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_REMOVAL_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_REMOVAL_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_REMOVAL_RANGE                      7:7
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_REMOVAL_WOFFSET                    0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_REMOVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_REMOVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_REMOVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_REMOVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_REMOVAL_DISABLE                    _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_REMOVAL_ENABLE                     _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INSERTION_SHIFT                    _MK_SHIFT_CONST(6)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INSERTION_FIELD                    (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INSERTION_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INSERTION_RANGE                    6:6
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INSERTION_WOFFSET                  0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INSERTION_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INSERTION_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INSERTION_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INSERTION_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INSERTION_DISABLE                  _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_CARD_INSERTION_ENABLE                   _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_READ_READY_SHIFT                 _MK_SHIFT_CONST(5)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_READ_READY_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_READ_READY_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_READ_READY_RANGE                 5:5
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_READ_READY_WOFFSET                       0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_READ_READY_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_READ_READY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_READ_READY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_READ_READY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_READ_READY_DISABLE                       _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_READ_READY_ENABLE                        _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_WRITE_READY_SHIFT                        _MK_SHIFT_CONST(4)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_WRITE_READY_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_WRITE_READY_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_WRITE_READY_RANGE                        4:4
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_WRITE_READY_WOFFSET                      0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_WRITE_READY_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_WRITE_READY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_WRITE_READY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_WRITE_READY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_WRITE_READY_DISABLE                      _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BUFFER_WRITE_READY_ENABLE                       _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DMA_INTERRUPT_SHIFT                     _MK_SHIFT_CONST(3)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DMA_INTERRUPT_FIELD                     (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_DMA_INTERRUPT_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DMA_INTERRUPT_RANGE                     3:3
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DMA_INTERRUPT_WOFFSET                   0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DMA_INTERRUPT_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DMA_INTERRUPT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DMA_INTERRUPT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DMA_INTERRUPT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DMA_INTERRUPT_DISABLE                   _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_DMA_INTERRUPT_ENABLE                    _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BLOCK_GAP_EVENT_SHIFT                   _MK_SHIFT_CONST(2)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BLOCK_GAP_EVENT_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_BLOCK_GAP_EVENT_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BLOCK_GAP_EVENT_RANGE                   2:2
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BLOCK_GAP_EVENT_WOFFSET                 0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BLOCK_GAP_EVENT_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BLOCK_GAP_EVENT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BLOCK_GAP_EVENT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BLOCK_GAP_EVENT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BLOCK_GAP_EVENT_DISABLE                 _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_BLOCK_GAP_EVENT_ENABLE                  _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TRANSFER_COMPLETE_SHIFT                 _MK_SHIFT_CONST(1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TRANSFER_COMPLETE_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_TRANSFER_COMPLETE_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TRANSFER_COMPLETE_RANGE                 1:1
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TRANSFER_COMPLETE_WOFFSET                       0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TRANSFER_COMPLETE_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TRANSFER_COMPLETE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TRANSFER_COMPLETE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TRANSFER_COMPLETE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TRANSFER_COMPLETE_DISABLE                       _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_TRANSFER_COMPLETE_ENABLE                        _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_COMPLETE_SHIFT                  _MK_SHIFT_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_COMPLETE_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_COMPLETE_SHIFT)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_COMPLETE_RANGE                  0:0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_COMPLETE_WOFFSET                        0x0
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_COMPLETE_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_COMPLETE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_COMPLETE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_COMPLETE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_COMPLETE_DISABLE                        _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_STATUS_ENABLE_0_COMMAND_COMPLETE_ENABLE                 _MK_ENUM_CONST(1)


// Register SDMMC_INTERRUPT_SIGNAL_ENABLE_0  
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0                 _MK_ADDR_CONST(0x38)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_SECURE                  0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_WORD_COUNT                      0x1
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_RESET_MASK                      _MK_MASK_CONST(0xfbff01ff)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_READ_MASK                       _MK_MASK_CONST(0xfbff01ff)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_WRITE_MASK                      _MK_MASK_CONST(0xfbff01ff)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_VENDOR_SPECIFIC_ERR_SHIFT                       _MK_SHIFT_CONST(30)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_VENDOR_SPECIFIC_ERR_FIELD                       (_MK_MASK_CONST(0x3) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_VENDOR_SPECIFIC_ERR_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_VENDOR_SPECIFIC_ERR_RANGE                       31:30
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_VENDOR_SPECIFIC_ERR_WOFFSET                     0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_VENDOR_SPECIFIC_ERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_VENDOR_SPECIFIC_ERR_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_VENDOR_SPECIFIC_ERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_VENDOR_SPECIFIC_ERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_VENDOR_SPECIFIC_ERR_DISABLE                     _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_VENDOR_SPECIFIC_ERR_ENABLE                      _MK_ENUM_CONST(3)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CEATA_ERROR_SHIFT                       _MK_SHIFT_CONST(29)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CEATA_ERROR_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CEATA_ERROR_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CEATA_ERROR_RANGE                       29:29
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CEATA_ERROR_WOFFSET                     0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CEATA_ERROR_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CEATA_ERROR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CEATA_ERROR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CEATA_ERROR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CEATA_ERROR_NO_ERROR                    _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CEATA_ERROR_ERROR                       _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TARGET_RESP_ERROR_SHIFT                 _MK_SHIFT_CONST(28)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TARGET_RESP_ERROR_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TARGET_RESP_ERROR_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TARGET_RESP_ERROR_RANGE                 28:28
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TARGET_RESP_ERROR_WOFFSET                       0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TARGET_RESP_ERROR_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TARGET_RESP_ERROR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TARGET_RESP_ERROR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TARGET_RESP_ERROR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TARGET_RESP_ERROR_NO_ERROR                      _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TARGET_RESP_ERROR_ERROR                 _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_SPI_ERR_SHIFT                   _MK_SHIFT_CONST(27)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_SPI_ERR_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_SPI_ERR_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_SPI_ERR_RANGE                   27:27
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_SPI_ERR_WOFFSET                 0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_SPI_ERR_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_SPI_ERR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_SPI_ERR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_SPI_ERR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_SPI_ERR_DISABLE                 _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_SPI_ERR_ENABLE                  _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_ADMA_ERR_SHIFT                  _MK_SHIFT_CONST(25)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_ADMA_ERR_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_ADMA_ERR_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_ADMA_ERR_RANGE                  25:25
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_ADMA_ERR_WOFFSET                        0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_ADMA_ERR_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_ADMA_ERR_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_ADMA_ERR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_ADMA_ERR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_ADMA_ERR_DISABLE                        _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_ADMA_ERR_ENABLE                 _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_AUTO_CMD12_ERR_SHIFT                    _MK_SHIFT_CONST(24)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_AUTO_CMD12_ERR_FIELD                    (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_AUTO_CMD12_ERR_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_AUTO_CMD12_ERR_RANGE                    24:24
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_AUTO_CMD12_ERR_WOFFSET                  0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_AUTO_CMD12_ERR_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_AUTO_CMD12_ERR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_AUTO_CMD12_ERR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_AUTO_CMD12_ERR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_AUTO_CMD12_ERR_DISABLE                  _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_AUTO_CMD12_ERR_ENABLE                   _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CURRENT_LIMIT_ERR_SHIFT                 _MK_SHIFT_CONST(23)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CURRENT_LIMIT_ERR_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CURRENT_LIMIT_ERR_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CURRENT_LIMIT_ERR_RANGE                 23:23
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CURRENT_LIMIT_ERR_WOFFSET                       0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CURRENT_LIMIT_ERR_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CURRENT_LIMIT_ERR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CURRENT_LIMIT_ERR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CURRENT_LIMIT_ERR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CURRENT_LIMIT_ERR_DISABLE                       _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CURRENT_LIMIT_ERR_ENABLE                        _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_END_BIT_ERR_SHIFT                  _MK_SHIFT_CONST(22)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_END_BIT_ERR_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_END_BIT_ERR_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_END_BIT_ERR_RANGE                  22:22
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_END_BIT_ERR_WOFFSET                        0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_END_BIT_ERR_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_END_BIT_ERR_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_END_BIT_ERR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_END_BIT_ERR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_END_BIT_ERR_DISABLE                        _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_END_BIT_ERR_ENABLE                 _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_CRC_ERR_SHIFT                      _MK_SHIFT_CONST(21)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_CRC_ERR_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_CRC_ERR_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_CRC_ERR_RANGE                      21:21
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_CRC_ERR_WOFFSET                    0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_CRC_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_CRC_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_CRC_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_CRC_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_CRC_ERR_DISABLE                    _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_CRC_ERR_ENABLE                     _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_TIMEOUT_ERR_SHIFT                  _MK_SHIFT_CONST(20)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_TIMEOUT_ERR_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_TIMEOUT_ERR_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_TIMEOUT_ERR_RANGE                  20:20
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_TIMEOUT_ERR_WOFFSET                        0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_TIMEOUT_ERR_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_TIMEOUT_ERR_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_TIMEOUT_ERR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_TIMEOUT_ERR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_TIMEOUT_ERR_DISABLE                        _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DATA_TIMEOUT_ERR_ENABLE                 _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_INDEX_ERR_SHIFT                 _MK_SHIFT_CONST(19)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_INDEX_ERR_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_INDEX_ERR_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_INDEX_ERR_RANGE                 19:19
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_INDEX_ERR_WOFFSET                       0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_INDEX_ERR_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_INDEX_ERR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_INDEX_ERR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_INDEX_ERR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_INDEX_ERR_DISABLE                       _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_INDEX_ERR_ENABLE                        _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_END_BIT_ERR_SHIFT                       _MK_SHIFT_CONST(18)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_END_BIT_ERR_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_END_BIT_ERR_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_END_BIT_ERR_RANGE                       18:18
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_END_BIT_ERR_WOFFSET                     0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_END_BIT_ERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_END_BIT_ERR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_END_BIT_ERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_END_BIT_ERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_END_BIT_ERR_DISABLE                     _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_END_BIT_ERR_ENABLE                      _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_CRC_ERR_SHIFT                   _MK_SHIFT_CONST(17)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_CRC_ERR_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_CRC_ERR_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_CRC_ERR_RANGE                   17:17
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_CRC_ERR_WOFFSET                 0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_CRC_ERR_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_CRC_ERR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_CRC_ERR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_CRC_ERR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_CRC_ERR_DISABLE                 _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_CRC_ERR_ENABLE                  _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_TIMEOUT_ERR_SHIFT                       _MK_SHIFT_CONST(16)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_TIMEOUT_ERR_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_TIMEOUT_ERR_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_TIMEOUT_ERR_RANGE                       16:16
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_TIMEOUT_ERR_WOFFSET                     0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_TIMEOUT_ERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_TIMEOUT_ERR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_TIMEOUT_ERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_TIMEOUT_ERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_TIMEOUT_ERR_DISABLE                     _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_TIMEOUT_ERR_ENABLE                      _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INTERRUPT_SHIFT                    _MK_SHIFT_CONST(8)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INTERRUPT_FIELD                    (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INTERRUPT_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INTERRUPT_RANGE                    8:8
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INTERRUPT_WOFFSET                  0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INTERRUPT_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INTERRUPT_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INTERRUPT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INTERRUPT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INTERRUPT_DISABLE                  _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INTERRUPT_ENABLE                   _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_REMOVAL_SHIFT                      _MK_SHIFT_CONST(7)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_REMOVAL_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_REMOVAL_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_REMOVAL_RANGE                      7:7
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_REMOVAL_WOFFSET                    0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_REMOVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_REMOVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_REMOVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_REMOVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_REMOVAL_DISABLE                    _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_REMOVAL_ENABLE                     _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INSERTION_SHIFT                    _MK_SHIFT_CONST(6)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INSERTION_FIELD                    (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INSERTION_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INSERTION_RANGE                    6:6
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INSERTION_WOFFSET                  0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INSERTION_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INSERTION_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INSERTION_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INSERTION_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INSERTION_DISABLE                  _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_CARD_INSERTION_ENABLE                   _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_READ_READY_SHIFT                 _MK_SHIFT_CONST(5)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_READ_READY_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_READ_READY_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_READ_READY_RANGE                 5:5
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_READ_READY_WOFFSET                       0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_READ_READY_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_READ_READY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_READ_READY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_READ_READY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_READ_READY_DISABLE                       _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_READ_READY_ENABLE                        _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_WRITE_READY_SHIFT                        _MK_SHIFT_CONST(4)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_WRITE_READY_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_WRITE_READY_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_WRITE_READY_RANGE                        4:4
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_WRITE_READY_WOFFSET                      0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_WRITE_READY_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_WRITE_READY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_WRITE_READY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_WRITE_READY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_WRITE_READY_DISABLE                      _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BUFFER_WRITE_READY_ENABLE                       _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DMA_INTERRUPT_SHIFT                     _MK_SHIFT_CONST(3)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DMA_INTERRUPT_FIELD                     (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DMA_INTERRUPT_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DMA_INTERRUPT_RANGE                     3:3
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DMA_INTERRUPT_WOFFSET                   0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DMA_INTERRUPT_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DMA_INTERRUPT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DMA_INTERRUPT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DMA_INTERRUPT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DMA_INTERRUPT_DISABLE                   _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_DMA_INTERRUPT_ENABLE                    _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BLOCK_GAP_EVENT_SHIFT                   _MK_SHIFT_CONST(2)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BLOCK_GAP_EVENT_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BLOCK_GAP_EVENT_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BLOCK_GAP_EVENT_RANGE                   2:2
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BLOCK_GAP_EVENT_WOFFSET                 0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BLOCK_GAP_EVENT_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BLOCK_GAP_EVENT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BLOCK_GAP_EVENT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BLOCK_GAP_EVENT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BLOCK_GAP_EVENT_DISABLE                 _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_BLOCK_GAP_EVENT_ENABLE                  _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TRANSFER_COMPLETE_SHIFT                 _MK_SHIFT_CONST(1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TRANSFER_COMPLETE_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TRANSFER_COMPLETE_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TRANSFER_COMPLETE_RANGE                 1:1
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TRANSFER_COMPLETE_WOFFSET                       0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TRANSFER_COMPLETE_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TRANSFER_COMPLETE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TRANSFER_COMPLETE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TRANSFER_COMPLETE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TRANSFER_COMPLETE_DISABLE                       _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_TRANSFER_COMPLETE_ENABLE                        _MK_ENUM_CONST(1)

#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_COMPLETE_SHIFT                  _MK_SHIFT_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_COMPLETE_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_COMPLETE_SHIFT)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_COMPLETE_RANGE                  0:0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_COMPLETE_WOFFSET                        0x0
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_COMPLETE_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_COMPLETE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_COMPLETE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_COMPLETE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_COMPLETE_DISABLE                        _MK_ENUM_CONST(0)
#define SDMMC_INTERRUPT_SIGNAL_ENABLE_0_COMMAND_COMPLETE_ENABLE                 _MK_ENUM_CONST(1)


// Register SDMMC_AUTO_CMD12_ERR_STATUS_0  
#define SDMMC_AUTO_CMD12_ERR_STATUS_0                   _MK_ADDR_CONST(0x3c)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_SECURE                    0x0
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_WORD_COUNT                        0x1
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_RESET_MASK                        _MK_MASK_CONST(0x9f)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_READ_MASK                         _MK_MASK_CONST(0x9f)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_COMMAND_NOT_ISSUED_SHIFT                  _MK_SHIFT_CONST(7)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_COMMAND_NOT_ISSUED_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_AUTO_CMD12_ERR_STATUS_0_COMMAND_NOT_ISSUED_SHIFT)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_COMMAND_NOT_ISSUED_RANGE                  7:7
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_COMMAND_NOT_ISSUED_WOFFSET                        0x0
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_COMMAND_NOT_ISSUED_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_COMMAND_NOT_ISSUED_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_COMMAND_NOT_ISSUED_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_COMMAND_NOT_ISSUED_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_COMMAND_NOT_ISSUED_NO_ERR                 _MK_ENUM_CONST(0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_COMMAND_NOT_ISSUED_NOT_ISSUED                     _MK_ENUM_CONST(1)

#define SDMMC_AUTO_CMD12_ERR_STATUS_0_INDEX_ERR_SHIFT                   _MK_SHIFT_CONST(4)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_INDEX_ERR_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_AUTO_CMD12_ERR_STATUS_0_INDEX_ERR_SHIFT)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_INDEX_ERR_RANGE                   4:4
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_INDEX_ERR_WOFFSET                 0x0
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_INDEX_ERR_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_INDEX_ERR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_INDEX_ERR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_INDEX_ERR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_INDEX_ERR_NO_ERR                  _MK_ENUM_CONST(0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_INDEX_ERR_ERR                     _MK_ENUM_CONST(1)

#define SDMMC_AUTO_CMD12_ERR_STATUS_0_END_BIT_ERR_SHIFT                 _MK_SHIFT_CONST(3)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_END_BIT_ERR_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_AUTO_CMD12_ERR_STATUS_0_END_BIT_ERR_SHIFT)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_END_BIT_ERR_RANGE                 3:3
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_END_BIT_ERR_WOFFSET                       0x0
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_END_BIT_ERR_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_END_BIT_ERR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_END_BIT_ERR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_END_BIT_ERR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_END_BIT_ERR_NO_ERR                        _MK_ENUM_CONST(0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_END_BIT_ERR_END_BIT_ERR_GENERATED                 _MK_ENUM_CONST(1)

#define SDMMC_AUTO_CMD12_ERR_STATUS_0_CRC_ERR_SHIFT                     _MK_SHIFT_CONST(2)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_CRC_ERR_FIELD                     (_MK_MASK_CONST(0x1) << SDMMC_AUTO_CMD12_ERR_STATUS_0_CRC_ERR_SHIFT)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_CRC_ERR_RANGE                     2:2
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_CRC_ERR_WOFFSET                   0x0
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_CRC_ERR_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_CRC_ERR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_CRC_ERR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_CRC_ERR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_CRC_ERR_NO_ERR                    _MK_ENUM_CONST(0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_CRC_ERR_CRC_ERR_GENERATED                 _MK_ENUM_CONST(1)

#define SDMMC_AUTO_CMD12_ERR_STATUS_0_TIMEOUT_ERR_SHIFT                 _MK_SHIFT_CONST(1)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_TIMEOUT_ERR_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_AUTO_CMD12_ERR_STATUS_0_TIMEOUT_ERR_SHIFT)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_TIMEOUT_ERR_RANGE                 1:1
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_TIMEOUT_ERR_WOFFSET                       0x0
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_TIMEOUT_ERR_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_TIMEOUT_ERR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_TIMEOUT_ERR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_TIMEOUT_ERR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_TIMEOUT_ERR_NO_ERR                        _MK_ENUM_CONST(0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_TIMEOUT_ERR_TIMEOUT                       _MK_ENUM_CONST(1)

#define SDMMC_AUTO_CMD12_ERR_STATUS_0_NOT_EXECUTED_SHIFT                        _MK_SHIFT_CONST(0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_NOT_EXECUTED_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_AUTO_CMD12_ERR_STATUS_0_NOT_EXECUTED_SHIFT)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_NOT_EXECUTED_RANGE                        0:0
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_NOT_EXECUTED_WOFFSET                      0x0
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_NOT_EXECUTED_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_NOT_EXECUTED_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_NOT_EXECUTED_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_NOT_EXECUTED_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_NOT_EXECUTED_EXECUTED                     _MK_ENUM_CONST(0)
#define SDMMC_AUTO_CMD12_ERR_STATUS_0_NOT_EXECUTED_NOT_EXECUTED                 _MK_ENUM_CONST(1)


// Register SDMMC_CAPABILITIES_0  
#define SDMMC_CAPABILITIES_0                    _MK_ADDR_CONST(0x40)
#define SDMMC_CAPABILITIES_0_SECURE                     0x0
#define SDMMC_CAPABILITIES_0_WORD_COUNT                         0x1
#define SDMMC_CAPABILITIES_0_RESET_VAL                  _MK_MASK_CONST(0x61ff30b0)
#define SDMMC_CAPABILITIES_0_RESET_MASK                         _MK_MASK_CONST(0x7fff3fbf)
#define SDMMC_CAPABILITIES_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_READ_MASK                  _MK_MASK_CONST(0x7fff3fbf)
#define SDMMC_CAPABILITIES_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_SPI_BLOCK_MODE_SHIFT                       _MK_SHIFT_CONST(30)
#define SDMMC_CAPABILITIES_0_SPI_BLOCK_MODE_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_CAPABILITIES_0_SPI_BLOCK_MODE_SHIFT)
#define SDMMC_CAPABILITIES_0_SPI_BLOCK_MODE_RANGE                       30:30
#define SDMMC_CAPABILITIES_0_SPI_BLOCK_MODE_WOFFSET                     0x0
#define SDMMC_CAPABILITIES_0_SPI_BLOCK_MODE_DEFAULT                     _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_SPI_BLOCK_MODE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_SPI_BLOCK_MODE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_SPI_BLOCK_MODE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_SPI_BLOCK_MODE_NOT_SUPPORTED                       _MK_ENUM_CONST(0)
#define SDMMC_CAPABILITIES_0_SPI_BLOCK_MODE_SUPPORTED                   _MK_ENUM_CONST(1)

#define SDMMC_CAPABILITIES_0_SPI_MODE_SHIFT                     _MK_SHIFT_CONST(29)
#define SDMMC_CAPABILITIES_0_SPI_MODE_FIELD                     (_MK_MASK_CONST(0x1) << SDMMC_CAPABILITIES_0_SPI_MODE_SHIFT)
#define SDMMC_CAPABILITIES_0_SPI_MODE_RANGE                     29:29
#define SDMMC_CAPABILITIES_0_SPI_MODE_WOFFSET                   0x0
#define SDMMC_CAPABILITIES_0_SPI_MODE_DEFAULT                   _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_SPI_MODE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_SPI_MODE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_SPI_MODE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_SPI_MODE_NOT_SUPPORTED                     _MK_ENUM_CONST(0)
#define SDMMC_CAPABILITIES_0_SPI_MODE_SUPPORTED                 _MK_ENUM_CONST(1)

#define SDMMC_CAPABILITIES_0_SYSTEM_BUS_64BIT_SUPPORT_SHIFT                     _MK_SHIFT_CONST(28)
#define SDMMC_CAPABILITIES_0_SYSTEM_BUS_64BIT_SUPPORT_FIELD                     (_MK_MASK_CONST(0x1) << SDMMC_CAPABILITIES_0_SYSTEM_BUS_64BIT_SUPPORT_SHIFT)
#define SDMMC_CAPABILITIES_0_SYSTEM_BUS_64BIT_SUPPORT_RANGE                     28:28
#define SDMMC_CAPABILITIES_0_SYSTEM_BUS_64BIT_SUPPORT_WOFFSET                   0x0
#define SDMMC_CAPABILITIES_0_SYSTEM_BUS_64BIT_SUPPORT_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_SYSTEM_BUS_64BIT_SUPPORT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_SYSTEM_BUS_64BIT_SUPPORT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_SYSTEM_BUS_64BIT_SUPPORT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_SYSTEM_BUS_64BIT_SUPPORT_NOT_SUPPORTED                     _MK_ENUM_CONST(0)
#define SDMMC_CAPABILITIES_0_SYSTEM_BUS_64BIT_SUPPORT_SUPPORTED                 _MK_ENUM_CONST(1)

#define SDMMC_CAPABILITIES_0_INTERRUPT_MODE_SHIFT                       _MK_SHIFT_CONST(27)
#define SDMMC_CAPABILITIES_0_INTERRUPT_MODE_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_CAPABILITIES_0_INTERRUPT_MODE_SHIFT)
#define SDMMC_CAPABILITIES_0_INTERRUPT_MODE_RANGE                       27:27
#define SDMMC_CAPABILITIES_0_INTERRUPT_MODE_WOFFSET                     0x0
#define SDMMC_CAPABILITIES_0_INTERRUPT_MODE_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_INTERRUPT_MODE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_INTERRUPT_MODE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_INTERRUPT_MODE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_INTERRUPT_MODE_NOT_SUPPORTED                       _MK_ENUM_CONST(0)
#define SDMMC_CAPABILITIES_0_INTERRUPT_MODE_SUPPORTED                   _MK_ENUM_CONST(1)

#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_1_8_V_SHIFT                        _MK_SHIFT_CONST(26)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_1_8_V_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_1_8_V_SHIFT)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_1_8_V_RANGE                        26:26
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_1_8_V_WOFFSET                      0x0
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_1_8_V_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_1_8_V_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_1_8_V_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_1_8_V_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_1_8_V_NOT_SUPPORTED                        _MK_ENUM_CONST(0)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_1_8_V_SUPPORTED                    _MK_ENUM_CONST(1)

#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_0_V_SHIFT                        _MK_SHIFT_CONST(25)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_0_V_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_0_V_SHIFT)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_0_V_RANGE                        25:25
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_0_V_WOFFSET                      0x0
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_0_V_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_0_V_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_0_V_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_0_V_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_0_V_NOT_SUPPORTED                        _MK_ENUM_CONST(0)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_0_V_SUPPORTED                    _MK_ENUM_CONST(1)

#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_3_V_SHIFT                        _MK_SHIFT_CONST(24)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_3_V_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_3_V_SHIFT)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_3_V_RANGE                        24:24
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_3_V_WOFFSET                      0x0
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_3_V_DEFAULT                      _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_3_V_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_3_V_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_3_V_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_3_V_NOT_SUPPORTED                        _MK_ENUM_CONST(0)
#define SDMMC_CAPABILITIES_0_VOLTAGE_SUPPORT_3_3_V_SUPPORTED                    _MK_ENUM_CONST(1)

#define SDMMC_CAPABILITIES_0_SUSPEND_RESUME_SUPPORT_SHIFT                       _MK_SHIFT_CONST(23)
#define SDMMC_CAPABILITIES_0_SUSPEND_RESUME_SUPPORT_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_CAPABILITIES_0_SUSPEND_RESUME_SUPPORT_SHIFT)
#define SDMMC_CAPABILITIES_0_SUSPEND_RESUME_SUPPORT_RANGE                       23:23
#define SDMMC_CAPABILITIES_0_SUSPEND_RESUME_SUPPORT_WOFFSET                     0x0
#define SDMMC_CAPABILITIES_0_SUSPEND_RESUME_SUPPORT_DEFAULT                     _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_SUSPEND_RESUME_SUPPORT_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_SUSPEND_RESUME_SUPPORT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_SUSPEND_RESUME_SUPPORT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_SUSPEND_RESUME_SUPPORT_NOT_SUPPORTED                       _MK_ENUM_CONST(0)
#define SDMMC_CAPABILITIES_0_SUSPEND_RESUME_SUPPORT_SUPPORTED                   _MK_ENUM_CONST(1)

#define SDMMC_CAPABILITIES_0_DMA_SUPPORT_SHIFT                  _MK_SHIFT_CONST(22)
#define SDMMC_CAPABILITIES_0_DMA_SUPPORT_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_CAPABILITIES_0_DMA_SUPPORT_SHIFT)
#define SDMMC_CAPABILITIES_0_DMA_SUPPORT_RANGE                  22:22
#define SDMMC_CAPABILITIES_0_DMA_SUPPORT_WOFFSET                        0x0
#define SDMMC_CAPABILITIES_0_DMA_SUPPORT_DEFAULT                        _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_DMA_SUPPORT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_DMA_SUPPORT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_DMA_SUPPORT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_DMA_SUPPORT_NOT_SUPPORTED                  _MK_ENUM_CONST(0)
#define SDMMC_CAPABILITIES_0_DMA_SUPPORT_SUPPORTED                      _MK_ENUM_CONST(1)

#define SDMMC_CAPABILITIES_0_HIGH_SPEED_SUPPORT_SHIFT                   _MK_SHIFT_CONST(21)
#define SDMMC_CAPABILITIES_0_HIGH_SPEED_SUPPORT_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_CAPABILITIES_0_HIGH_SPEED_SUPPORT_SHIFT)
#define SDMMC_CAPABILITIES_0_HIGH_SPEED_SUPPORT_RANGE                   21:21
#define SDMMC_CAPABILITIES_0_HIGH_SPEED_SUPPORT_WOFFSET                 0x0
#define SDMMC_CAPABILITIES_0_HIGH_SPEED_SUPPORT_DEFAULT                 _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_HIGH_SPEED_SUPPORT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_HIGH_SPEED_SUPPORT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_HIGH_SPEED_SUPPORT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_HIGH_SPEED_SUPPORT_NOT_SUPPORTED                   _MK_ENUM_CONST(0)
#define SDMMC_CAPABILITIES_0_HIGH_SPEED_SUPPORT_SUPPORTED                       _MK_ENUM_CONST(1)

#define SDMMC_CAPABILITIES_0_ADMA1_SUPPORT_SHIFT                        _MK_SHIFT_CONST(20)
#define SDMMC_CAPABILITIES_0_ADMA1_SUPPORT_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_CAPABILITIES_0_ADMA1_SUPPORT_SHIFT)
#define SDMMC_CAPABILITIES_0_ADMA1_SUPPORT_RANGE                        20:20
#define SDMMC_CAPABILITIES_0_ADMA1_SUPPORT_WOFFSET                      0x0
#define SDMMC_CAPABILITIES_0_ADMA1_SUPPORT_DEFAULT                      _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_ADMA1_SUPPORT_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_ADMA1_SUPPORT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_ADMA1_SUPPORT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_ADMA1_SUPPORT_NOT_SUPPORTED                        _MK_ENUM_CONST(0)
#define SDMMC_CAPABILITIES_0_ADMA1_SUPPORT_SUPPORTED                    _MK_ENUM_CONST(1)

#define SDMMC_CAPABILITIES_0_ADMA2_SUPPORT_SHIFT                        _MK_SHIFT_CONST(19)
#define SDMMC_CAPABILITIES_0_ADMA2_SUPPORT_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_CAPABILITIES_0_ADMA2_SUPPORT_SHIFT)
#define SDMMC_CAPABILITIES_0_ADMA2_SUPPORT_RANGE                        19:19
#define SDMMC_CAPABILITIES_0_ADMA2_SUPPORT_WOFFSET                      0x0
#define SDMMC_CAPABILITIES_0_ADMA2_SUPPORT_DEFAULT                      _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_ADMA2_SUPPORT_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_ADMA2_SUPPORT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_ADMA2_SUPPORT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_ADMA2_SUPPORT_NOT_SUPPORTED                        _MK_ENUM_CONST(0)
#define SDMMC_CAPABILITIES_0_ADMA2_SUPPORT_SUPPORTED                    _MK_ENUM_CONST(1)

#define SDMMC_CAPABILITIES_0_EXTENDED_MEDIA_BUS_SUPPORT_SHIFT                   _MK_SHIFT_CONST(18)
#define SDMMC_CAPABILITIES_0_EXTENDED_MEDIA_BUS_SUPPORT_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_CAPABILITIES_0_EXTENDED_MEDIA_BUS_SUPPORT_SHIFT)
#define SDMMC_CAPABILITIES_0_EXTENDED_MEDIA_BUS_SUPPORT_RANGE                   18:18
#define SDMMC_CAPABILITIES_0_EXTENDED_MEDIA_BUS_SUPPORT_WOFFSET                 0x0
#define SDMMC_CAPABILITIES_0_EXTENDED_MEDIA_BUS_SUPPORT_DEFAULT                 _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_EXTENDED_MEDIA_BUS_SUPPORT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_EXTENDED_MEDIA_BUS_SUPPORT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_EXTENDED_MEDIA_BUS_SUPPORT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_EXTENDED_MEDIA_BUS_SUPPORT_NOT_SUPPORTED                   _MK_ENUM_CONST(0)
#define SDMMC_CAPABILITIES_0_EXTENDED_MEDIA_BUS_SUPPORT_SUPPORTED                       _MK_ENUM_CONST(1)

#define SDMMC_CAPABILITIES_0_MAX_BLOCK_LENGTH_SHIFT                     _MK_SHIFT_CONST(16)
#define SDMMC_CAPABILITIES_0_MAX_BLOCK_LENGTH_FIELD                     (_MK_MASK_CONST(0x3) << SDMMC_CAPABILITIES_0_MAX_BLOCK_LENGTH_SHIFT)
#define SDMMC_CAPABILITIES_0_MAX_BLOCK_LENGTH_RANGE                     17:16
#define SDMMC_CAPABILITIES_0_MAX_BLOCK_LENGTH_WOFFSET                   0x0
#define SDMMC_CAPABILITIES_0_MAX_BLOCK_LENGTH_DEFAULT                   _MK_MASK_CONST(0x3)
#define SDMMC_CAPABILITIES_0_MAX_BLOCK_LENGTH_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define SDMMC_CAPABILITIES_0_MAX_BLOCK_LENGTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_MAX_BLOCK_LENGTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_MAX_BLOCK_LENGTH_BYTE512                   _MK_ENUM_CONST(0)
#define SDMMC_CAPABILITIES_0_MAX_BLOCK_LENGTH_BYTE1024                  _MK_ENUM_CONST(1)
#define SDMMC_CAPABILITIES_0_MAX_BLOCK_LENGTH_BYTE2048                  _MK_ENUM_CONST(2)
#define SDMMC_CAPABILITIES_0_MAX_BLOCK_LENGTH_RESERVED                  _MK_ENUM_CONST(3)

#define SDMMC_CAPABILITIES_0_BASE_CLOCK_FREQUENCY_SHIFT                 _MK_SHIFT_CONST(8)
#define SDMMC_CAPABILITIES_0_BASE_CLOCK_FREQUENCY_FIELD                 (_MK_MASK_CONST(0x3f) << SDMMC_CAPABILITIES_0_BASE_CLOCK_FREQUENCY_SHIFT)
#define SDMMC_CAPABILITIES_0_BASE_CLOCK_FREQUENCY_RANGE                 13:8
#define SDMMC_CAPABILITIES_0_BASE_CLOCK_FREQUENCY_WOFFSET                       0x0
#define SDMMC_CAPABILITIES_0_BASE_CLOCK_FREQUENCY_DEFAULT                       _MK_MASK_CONST(0x30)
#define SDMMC_CAPABILITIES_0_BASE_CLOCK_FREQUENCY_DEFAULT_MASK                  _MK_MASK_CONST(0x3f)
#define SDMMC_CAPABILITIES_0_BASE_CLOCK_FREQUENCY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_BASE_CLOCK_FREQUENCY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_UNIT_SHIFT                   _MK_SHIFT_CONST(7)
#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_UNIT_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_UNIT_SHIFT)
#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_UNIT_RANGE                   7:7
#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_UNIT_WOFFSET                 0x0
#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_UNIT_DEFAULT                 _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_UNIT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_UNIT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_UNIT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_UNIT_KHZ                     _MK_ENUM_CONST(0)
#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_UNIT_MHZ                     _MK_ENUM_CONST(1)

#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_FREQUENCY_SHIFT                      _MK_SHIFT_CONST(0)
#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_FREQUENCY_FIELD                      (_MK_MASK_CONST(0x3f) << SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_FREQUENCY_SHIFT)
#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_FREQUENCY_RANGE                      5:0
#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_FREQUENCY_WOFFSET                    0x0
#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_FREQUENCY_DEFAULT                    _MK_MASK_CONST(0x30)
#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_FREQUENCY_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_FREQUENCY_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_CAPABILITIES_0_TIMEOUT_CLOCK_FREQUENCY_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Reserved address 68 [0x44] 

// Register SDMMC_MAXIMUM_CURRENT_0  
#define SDMMC_MAXIMUM_CURRENT_0                 _MK_ADDR_CONST(0x48)
#define SDMMC_MAXIMUM_CURRENT_0_SECURE                  0x0
#define SDMMC_MAXIMUM_CURRENT_0_WORD_COUNT                      0x1
#define SDMMC_MAXIMUM_CURRENT_0_RESET_VAL                       _MK_MASK_CONST(0x1)
#define SDMMC_MAXIMUM_CURRENT_0_RESET_MASK                      _MK_MASK_CONST(0xffffff)
#define SDMMC_MAXIMUM_CURRENT_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define SDMMC_MAXIMUM_CURRENT_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define SDMMC_MAXIMUM_CURRENT_0_READ_MASK                       _MK_MASK_CONST(0xffffff)
#define SDMMC_MAXIMUM_CURRENT_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
// Maximum Current for 1.8V
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_1_8V_SHIFT                  _MK_SHIFT_CONST(16)
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_1_8V_FIELD                  (_MK_MASK_CONST(0xff) << SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_1_8V_SHIFT)
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_1_8V_RANGE                  23:16
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_1_8V_WOFFSET                        0x0
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_1_8V_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_1_8V_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_1_8V_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_1_8V_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum Current for 3.0V
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_0V_SHIFT                  _MK_SHIFT_CONST(8)
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_0V_FIELD                  (_MK_MASK_CONST(0xff) << SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_0V_SHIFT)
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_0V_RANGE                  15:8
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_0V_WOFFSET                        0x0
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_0V_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_0V_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_0V_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_0V_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum Current for 3.3V
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_3V_SHIFT                  _MK_SHIFT_CONST(0)
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_3V_FIELD                  (_MK_MASK_CONST(0xff) << SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_3V_SHIFT)
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_3V_RANGE                  7:0
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_3V_WOFFSET                        0x0
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_3V_DEFAULT                        _MK_MASK_CONST(0x1)
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_3V_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_3V_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_MAXIMUM_CURRENT_0_MAXIMUM_CURRENT_FOR_3_3V_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 76 [0x4c] 

// Register SDMMC_FORCE_EVENT_0  
#define SDMMC_FORCE_EVENT_0                     _MK_ADDR_CONST(0x50)
#define SDMMC_FORCE_EVENT_0_SECURE                      0x0
#define SDMMC_FORCE_EVENT_0_WORD_COUNT                  0x1
#define SDMMC_FORCE_EVENT_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_RESET_MASK                  _MK_MASK_CONST(0xfbff009f)
#define SDMMC_FORCE_EVENT_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_READ_MASK                   _MK_MASK_CONST(0xfbff009f)
#define SDMMC_FORCE_EVENT_0_WRITE_MASK                  _MK_MASK_CONST(0xfbff009f)
#define SDMMC_FORCE_EVENT_0_VENDOR_SPECIFIC_ERR_STATUS_SHIFT                    _MK_SHIFT_CONST(30)
#define SDMMC_FORCE_EVENT_0_VENDOR_SPECIFIC_ERR_STATUS_FIELD                    (_MK_MASK_CONST(0x3) << SDMMC_FORCE_EVENT_0_VENDOR_SPECIFIC_ERR_STATUS_SHIFT)
#define SDMMC_FORCE_EVENT_0_VENDOR_SPECIFIC_ERR_STATUS_RANGE                    31:30
#define SDMMC_FORCE_EVENT_0_VENDOR_SPECIFIC_ERR_STATUS_WOFFSET                  0x0
#define SDMMC_FORCE_EVENT_0_VENDOR_SPECIFIC_ERR_STATUS_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_VENDOR_SPECIFIC_ERR_STATUS_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define SDMMC_FORCE_EVENT_0_VENDOR_SPECIFIC_ERR_STATUS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_VENDOR_SPECIFIC_ERR_STATUS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_VENDOR_SPECIFIC_ERR_STATUS_DISABLE                  _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_VENDOR_SPECIFIC_ERR_STATUS_ENABLE                   _MK_ENUM_CONST(3)

#define SDMMC_FORCE_EVENT_0_CEATA_ERROR_SHIFT                   _MK_SHIFT_CONST(29)
#define SDMMC_FORCE_EVENT_0_CEATA_ERROR_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_CEATA_ERROR_SHIFT)
#define SDMMC_FORCE_EVENT_0_CEATA_ERROR_RANGE                   29:29
#define SDMMC_FORCE_EVENT_0_CEATA_ERROR_WOFFSET                 0x0
#define SDMMC_FORCE_EVENT_0_CEATA_ERROR_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_CEATA_ERROR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_CEATA_ERROR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_CEATA_ERROR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_CEATA_ERROR_NO_ERROR                        _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_CEATA_ERROR_ERROR                   _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_TARGET_RESP_ERROR_SHIFT                     _MK_SHIFT_CONST(28)
#define SDMMC_FORCE_EVENT_0_TARGET_RESP_ERROR_FIELD                     (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_TARGET_RESP_ERROR_SHIFT)
#define SDMMC_FORCE_EVENT_0_TARGET_RESP_ERROR_RANGE                     28:28
#define SDMMC_FORCE_EVENT_0_TARGET_RESP_ERROR_WOFFSET                   0x0
#define SDMMC_FORCE_EVENT_0_TARGET_RESP_ERROR_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_TARGET_RESP_ERROR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_TARGET_RESP_ERROR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_TARGET_RESP_ERROR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_TARGET_RESP_ERROR_NO_ERROR                  _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_TARGET_RESP_ERROR_ERROR                     _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_SPI_ERR_SHIFT                       _MK_SHIFT_CONST(27)
#define SDMMC_FORCE_EVENT_0_SPI_ERR_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_SPI_ERR_SHIFT)
#define SDMMC_FORCE_EVENT_0_SPI_ERR_RANGE                       27:27
#define SDMMC_FORCE_EVENT_0_SPI_ERR_WOFFSET                     0x0
#define SDMMC_FORCE_EVENT_0_SPI_ERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_SPI_ERR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_SPI_ERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_SPI_ERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_SPI_ERR_DISABLE                     _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_SPI_ERR_ENABLE                      _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_ADMA_ERR_SHIFT                      _MK_SHIFT_CONST(25)
#define SDMMC_FORCE_EVENT_0_ADMA_ERR_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_ADMA_ERR_SHIFT)
#define SDMMC_FORCE_EVENT_0_ADMA_ERR_RANGE                      25:25
#define SDMMC_FORCE_EVENT_0_ADMA_ERR_WOFFSET                    0x0
#define SDMMC_FORCE_EVENT_0_ADMA_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_ADMA_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_ADMA_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_ADMA_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_ADMA_ERR_NO_INTERRUPT                       _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_ADMA_ERR_INTERRUPT                  _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_AUTOCMD12_ERR_SHIFT                 _MK_SHIFT_CONST(24)
#define SDMMC_FORCE_EVENT_0_AUTOCMD12_ERR_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_AUTOCMD12_ERR_SHIFT)
#define SDMMC_FORCE_EVENT_0_AUTOCMD12_ERR_RANGE                 24:24
#define SDMMC_FORCE_EVENT_0_AUTOCMD12_ERR_WOFFSET                       0x0
#define SDMMC_FORCE_EVENT_0_AUTOCMD12_ERR_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTOCMD12_ERR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_AUTOCMD12_ERR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTOCMD12_ERR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTOCMD12_ERR_NO_INTERRUPT                  _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_AUTOCMD12_ERR_INTERRUPT                     _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_CURRENTLIMIT_ERR_SHIFT                      _MK_SHIFT_CONST(23)
#define SDMMC_FORCE_EVENT_0_CURRENTLIMIT_ERR_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_CURRENTLIMIT_ERR_SHIFT)
#define SDMMC_FORCE_EVENT_0_CURRENTLIMIT_ERR_RANGE                      23:23
#define SDMMC_FORCE_EVENT_0_CURRENTLIMIT_ERR_WOFFSET                    0x0
#define SDMMC_FORCE_EVENT_0_CURRENTLIMIT_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_CURRENTLIMIT_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_CURRENTLIMIT_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_CURRENTLIMIT_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_CURRENTLIMIT_ERR_NO_INTERRUPT                       _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_CURRENTLIMIT_ERR_INTERRUPT                  _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_DATA_END_BIT_ERR_SHIFT                      _MK_SHIFT_CONST(22)
#define SDMMC_FORCE_EVENT_0_DATA_END_BIT_ERR_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_DATA_END_BIT_ERR_SHIFT)
#define SDMMC_FORCE_EVENT_0_DATA_END_BIT_ERR_RANGE                      22:22
#define SDMMC_FORCE_EVENT_0_DATA_END_BIT_ERR_WOFFSET                    0x0
#define SDMMC_FORCE_EVENT_0_DATA_END_BIT_ERR_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_DATA_END_BIT_ERR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_DATA_END_BIT_ERR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_DATA_END_BIT_ERR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_DATA_END_BIT_ERR_NO_INTERRUPT                       _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_DATA_END_BIT_ERR_INTERRUPT                  _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_DATACRC_ERR_SHIFT                   _MK_SHIFT_CONST(21)
#define SDMMC_FORCE_EVENT_0_DATACRC_ERR_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_DATACRC_ERR_SHIFT)
#define SDMMC_FORCE_EVENT_0_DATACRC_ERR_RANGE                   21:21
#define SDMMC_FORCE_EVENT_0_DATACRC_ERR_WOFFSET                 0x0
#define SDMMC_FORCE_EVENT_0_DATACRC_ERR_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_DATACRC_ERR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_DATACRC_ERR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_DATACRC_ERR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_DATACRC_ERR_NO_INTERRUPT                    _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_DATACRC_ERR_INTERRUPT                       _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_DATATIMEOUT_ERR_SHIFT                       _MK_SHIFT_CONST(20)
#define SDMMC_FORCE_EVENT_0_DATATIMEOUT_ERR_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_DATATIMEOUT_ERR_SHIFT)
#define SDMMC_FORCE_EVENT_0_DATATIMEOUT_ERR_RANGE                       20:20
#define SDMMC_FORCE_EVENT_0_DATATIMEOUT_ERR_WOFFSET                     0x0
#define SDMMC_FORCE_EVENT_0_DATATIMEOUT_ERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_DATATIMEOUT_ERR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_DATATIMEOUT_ERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_DATATIMEOUT_ERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_DATATIMEOUT_ERR_NO_INTERRUPT                        _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_DATATIMEOUT_ERR_INTERRUPT                   _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_COMMAND_INDEX_ERR_SHIFT                     _MK_SHIFT_CONST(19)
#define SDMMC_FORCE_EVENT_0_COMMAND_INDEX_ERR_FIELD                     (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_COMMAND_INDEX_ERR_SHIFT)
#define SDMMC_FORCE_EVENT_0_COMMAND_INDEX_ERR_RANGE                     19:19
#define SDMMC_FORCE_EVENT_0_COMMAND_INDEX_ERR_WOFFSET                   0x0
#define SDMMC_FORCE_EVENT_0_COMMAND_INDEX_ERR_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_COMMAND_INDEX_ERR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_COMMAND_INDEX_ERR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_COMMAND_INDEX_ERR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_COMMAND_INDEX_ERR_NO_INTERRUPT                      _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_COMMAND_INDEX_ERR_INTERRUPT                 _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_COMMAND_END_BIT_ERR_SHIFT                   _MK_SHIFT_CONST(18)
#define SDMMC_FORCE_EVENT_0_COMMAND_END_BIT_ERR_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_COMMAND_END_BIT_ERR_SHIFT)
#define SDMMC_FORCE_EVENT_0_COMMAND_END_BIT_ERR_RANGE                   18:18
#define SDMMC_FORCE_EVENT_0_COMMAND_END_BIT_ERR_WOFFSET                 0x0
#define SDMMC_FORCE_EVENT_0_COMMAND_END_BIT_ERR_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_COMMAND_END_BIT_ERR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_COMMAND_END_BIT_ERR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_COMMAND_END_BIT_ERR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_COMMAND_END_BIT_ERR_NO_INTERRUPT                    _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_COMMAND_END_BIT_ERR_INTERRUPT                       _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_COMMAND_CRC_ERR_SHIFT                       _MK_SHIFT_CONST(17)
#define SDMMC_FORCE_EVENT_0_COMMAND_CRC_ERR_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_COMMAND_CRC_ERR_SHIFT)
#define SDMMC_FORCE_EVENT_0_COMMAND_CRC_ERR_RANGE                       17:17
#define SDMMC_FORCE_EVENT_0_COMMAND_CRC_ERR_WOFFSET                     0x0
#define SDMMC_FORCE_EVENT_0_COMMAND_CRC_ERR_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_COMMAND_CRC_ERR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_COMMAND_CRC_ERR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_COMMAND_CRC_ERR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_COMMAND_CRC_ERR_NO_INTERRUPT                        _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_COMMAND_CRC_ERR_INTERRUPT                   _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_COMMAND_TIMEOUT_ERR_SHIFT                   _MK_SHIFT_CONST(16)
#define SDMMC_FORCE_EVENT_0_COMMAND_TIMEOUT_ERR_FIELD                   (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_COMMAND_TIMEOUT_ERR_SHIFT)
#define SDMMC_FORCE_EVENT_0_COMMAND_TIMEOUT_ERR_RANGE                   16:16
#define SDMMC_FORCE_EVENT_0_COMMAND_TIMEOUT_ERR_WOFFSET                 0x0
#define SDMMC_FORCE_EVENT_0_COMMAND_TIMEOUT_ERR_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_COMMAND_TIMEOUT_ERR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_COMMAND_TIMEOUT_ERR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_COMMAND_TIMEOUT_ERR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_COMMAND_TIMEOUT_ERR_NO_INTERRUPT                    _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_COMMAND_TIMEOUT_ERR_INTERRUPT                       _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_ISSUED_SHIFT                 _MK_SHIFT_CONST(7)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_ISSUED_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_ISSUED_SHIFT)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_ISSUED_RANGE                 7:7
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_ISSUED_WOFFSET                       0x0
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_ISSUED_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_ISSUED_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_ISSUED_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_ISSUED_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_ISSUED_NO_INTERRUPT                  _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_ISSUED_INTERRUPT                     _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_INDEX_ERR_SHIFT                  _MK_SHIFT_CONST(4)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_INDEX_ERR_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_AUTO_CMD12_INDEX_ERR_SHIFT)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_INDEX_ERR_RANGE                  4:4
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_INDEX_ERR_WOFFSET                        0x0
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_INDEX_ERR_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_INDEX_ERR_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_INDEX_ERR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_INDEX_ERR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_INDEX_ERR_NO_INTERRUPT                   _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_INDEX_ERR_INTERRUPT                      _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_END_BIT_ERR_SHIFT                        _MK_SHIFT_CONST(3)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_END_BIT_ERR_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_AUTO_CMD12_END_BIT_ERR_SHIFT)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_END_BIT_ERR_RANGE                        3:3
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_END_BIT_ERR_WOFFSET                      0x0
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_END_BIT_ERR_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_END_BIT_ERR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_END_BIT_ERR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_END_BIT_ERR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_END_BIT_ERR_NO_INTERRUPT                 _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_END_BIT_ERR_INTERRUPT                    _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_CRC_ERR_SHIFT                    _MK_SHIFT_CONST(2)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_CRC_ERR_FIELD                    (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_AUTO_CMD12_CRC_ERR_SHIFT)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_CRC_ERR_RANGE                    2:2
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_CRC_ERR_WOFFSET                  0x0
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_CRC_ERR_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_CRC_ERR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_CRC_ERR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_CRC_ERR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_CRC_ERR_NO_INTERRUPT                     _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_CRC_ERR_INTERRUPT                        _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_TIMEOUT_ERR_SHIFT                        _MK_SHIFT_CONST(1)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_TIMEOUT_ERR_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_AUTO_CMD12_TIMEOUT_ERR_SHIFT)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_TIMEOUT_ERR_RANGE                        1:1
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_TIMEOUT_ERR_WOFFSET                      0x0
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_TIMEOUT_ERR_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_TIMEOUT_ERR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_TIMEOUT_ERR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_TIMEOUT_ERR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_TIMEOUT_ERR_NO_INTERRUPT                 _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_TIMEOUT_ERR_INTERRUPT                    _MK_ENUM_CONST(1)

#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_EXECUTED_SHIFT                       _MK_SHIFT_CONST(0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_EXECUTED_FIELD                       (_MK_MASK_CONST(0x1) << SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_EXECUTED_SHIFT)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_EXECUTED_RANGE                       0:0
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_EXECUTED_WOFFSET                     0x0
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_EXECUTED_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_EXECUTED_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_EXECUTED_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_EXECUTED_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_EXECUTED_NO_INTERRUPT                        _MK_ENUM_CONST(0)
#define SDMMC_FORCE_EVENT_0_AUTO_CMD12_NOT_EXECUTED_INTERRUPT                   _MK_ENUM_CONST(1)


// Register SDMMC_ADMA_ERR_STATUS_0  
#define SDMMC_ADMA_ERR_STATUS_0                 _MK_ADDR_CONST(0x54)
#define SDMMC_ADMA_ERR_STATUS_0_SECURE                  0x0
#define SDMMC_ADMA_ERR_STATUS_0_WORD_COUNT                      0x1
#define SDMMC_ADMA_ERR_STATUS_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define SDMMC_ADMA_ERR_STATUS_0_RESET_MASK                      _MK_MASK_CONST(0x7)
#define SDMMC_ADMA_ERR_STATUS_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define SDMMC_ADMA_ERR_STATUS_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define SDMMC_ADMA_ERR_STATUS_0_READ_MASK                       _MK_MASK_CONST(0x7)
#define SDMMC_ADMA_ERR_STATUS_0_WRITE_MASK                      _MK_MASK_CONST(0x7)
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_LENGTH_MISMATCH_ERR_SHIFT                  _MK_SHIFT_CONST(2)
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_LENGTH_MISMATCH_ERR_FIELD                  (_MK_MASK_CONST(0x1) << SDMMC_ADMA_ERR_STATUS_0_ADMA_LENGTH_MISMATCH_ERR_SHIFT)
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_LENGTH_MISMATCH_ERR_RANGE                  2:2
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_LENGTH_MISMATCH_ERR_WOFFSET                        0x0
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_LENGTH_MISMATCH_ERR_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_LENGTH_MISMATCH_ERR_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_LENGTH_MISMATCH_ERR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_LENGTH_MISMATCH_ERR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_LENGTH_MISMATCH_ERR_NO_ERR                 _MK_ENUM_CONST(0)
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_LENGTH_MISMATCH_ERR_ERR                    _MK_ENUM_CONST(1)

#define SDMMC_ADMA_ERR_STATUS_0_ADMA_ERR_STATE_SHIFT                    _MK_SHIFT_CONST(0)
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_ERR_STATE_FIELD                    (_MK_MASK_CONST(0x3) << SDMMC_ADMA_ERR_STATUS_0_ADMA_ERR_STATE_SHIFT)
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_ERR_STATE_RANGE                    1:0
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_ERR_STATE_WOFFSET                  0x0
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_ERR_STATE_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_ERR_STATE_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_ERR_STATE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_ADMA_ERR_STATUS_0_ADMA_ERR_STATE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register SDMMC_ADMA_SYSTEM_ADDRESS_0  
#define SDMMC_ADMA_SYSTEM_ADDRESS_0                     _MK_ADDR_CONST(0x58)
#define SDMMC_ADMA_SYSTEM_ADDRESS_0_SECURE                      0x0
#define SDMMC_ADMA_SYSTEM_ADDRESS_0_WORD_COUNT                  0x1
#define SDMMC_ADMA_SYSTEM_ADDRESS_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define SDMMC_ADMA_SYSTEM_ADDRESS_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define SDMMC_ADMA_SYSTEM_ADDRESS_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define SDMMC_ADMA_SYSTEM_ADDRESS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_ADMA_SYSTEM_ADDRESS_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define SDMMC_ADMA_SYSTEM_ADDRESS_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define SDMMC_ADMA_SYSTEM_ADDRESS_0_ADMA_SYSTEM_ADDRESS_SHIFT                   _MK_SHIFT_CONST(0)
#define SDMMC_ADMA_SYSTEM_ADDRESS_0_ADMA_SYSTEM_ADDRESS_FIELD                   (_MK_MASK_CONST(0xffffffff) << SDMMC_ADMA_SYSTEM_ADDRESS_0_ADMA_SYSTEM_ADDRESS_SHIFT)
#define SDMMC_ADMA_SYSTEM_ADDRESS_0_ADMA_SYSTEM_ADDRESS_RANGE                   31:0
#define SDMMC_ADMA_SYSTEM_ADDRESS_0_ADMA_SYSTEM_ADDRESS_WOFFSET                 0x0
#define SDMMC_ADMA_SYSTEM_ADDRESS_0_ADMA_SYSTEM_ADDRESS_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_ADMA_SYSTEM_ADDRESS_0_ADMA_SYSTEM_ADDRESS_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define SDMMC_ADMA_SYSTEM_ADDRESS_0_ADMA_SYSTEM_ADDRESS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_ADMA_SYSTEM_ADDRESS_0_ADMA_SYSTEM_ADDRESS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Reserved address 92 [0x5c] 

// Register SDMMC_DEBUG_SELECTION_REGISTER_0  
#define SDMMC_DEBUG_SELECTION_REGISTER_0                        _MK_ADDR_CONST(0x60)
#define SDMMC_DEBUG_SELECTION_REGISTER_0_SECURE                         0x0
#define SDMMC_DEBUG_SELECTION_REGISTER_0_WORD_COUNT                     0x1
#define SDMMC_DEBUG_SELECTION_REGISTER_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define SDMMC_DEBUG_SELECTION_REGISTER_0_RESET_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_DEBUG_SELECTION_REGISTER_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define SDMMC_DEBUG_SELECTION_REGISTER_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_DEBUG_SELECTION_REGISTER_0_READ_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_DEBUG_SELECTION_REGISTER_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
// 1 = CMD REGISTER, INTERRUPT STATUS,AHB_IFACE_MODULE.
// 0 = RECEIVER MODULE and FIFO CONTROL
#define SDMMC_DEBUG_SELECTION_REGISTER_0_DEBUG_SEL_SHIFT                        _MK_SHIFT_CONST(0)
#define SDMMC_DEBUG_SELECTION_REGISTER_0_DEBUG_SEL_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_DEBUG_SELECTION_REGISTER_0_DEBUG_SEL_SHIFT)
#define SDMMC_DEBUG_SELECTION_REGISTER_0_DEBUG_SEL_RANGE                        0:0
#define SDMMC_DEBUG_SELECTION_REGISTER_0_DEBUG_SEL_WOFFSET                      0x0
#define SDMMC_DEBUG_SELECTION_REGISTER_0_DEBUG_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_DEBUG_SELECTION_REGISTER_0_DEBUG_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_DEBUG_SELECTION_REGISTER_0_DEBUG_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_DEBUG_SELECTION_REGISTER_0_DEBUG_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Reserved address 100 [0x64] 

// Reserved address 104 [0x68] 

// Reserved address 108 [0x6c] 

// Reserved address 112 [0x70] 

// Reserved address 116 [0x74] 

// Reserved address 120 [0x78] 

// Reserved address 124 [0x7c] 

// Reserved address 128 [0x80] 

// Reserved address 132 [0x84] 

// Reserved address 136 [0x88] 

// Reserved address 140 [0x8c] 

// Reserved address 144 [0x90] 

// Reserved address 148 [0x94] 

// Reserved address 152 [0x98] 

// Reserved address 156 [0x9c] 

// Reserved address 160 [0xa0] 

// Reserved address 164 [0xa4] 

// Reserved address 168 [0xa8] 

// Reserved address 172 [0xac] 

// Reserved address 176 [0xb0] 

// Reserved address 180 [0xb4] 

// Reserved address 184 [0xb8] 

// Reserved address 188 [0xbc] 

// Reserved address 192 [0xc0] 

// Reserved address 196 [0xc4] 

// Reserved address 200 [0xc8] 

// Reserved address 204 [0xcc] 

// Reserved address 208 [0xd0] 

// Reserved address 212 [0xd4] 

// Reserved address 216 [0xd8] 

// Reserved address 220 [0xdc] 

// Reserved address 224 [0xe0] 

// Reserved address 228 [0xe4] 

// Reserved address 232 [0xe8] 

// Reserved address 236 [0xec] 

// Register SDMMC_SPI_INTERRUPT_SUPPORT_0  
#define SDMMC_SPI_INTERRUPT_SUPPORT_0                   _MK_ADDR_CONST(0xf0)
#define SDMMC_SPI_INTERRUPT_SUPPORT_0_SECURE                    0x0
#define SDMMC_SPI_INTERRUPT_SUPPORT_0_WORD_COUNT                        0x1
#define SDMMC_SPI_INTERRUPT_SUPPORT_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define SDMMC_SPI_INTERRUPT_SUPPORT_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define SDMMC_SPI_INTERRUPT_SUPPORT_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define SDMMC_SPI_INTERRUPT_SUPPORT_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_SPI_INTERRUPT_SUPPORT_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define SDMMC_SPI_INTERRUPT_SUPPORT_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
//This bit is set to indicate the assertion of interrupts in SPI MODE at anytime
// Irrespective on the staus of card select. 
#define SDMMC_SPI_INTERRUPT_SUPPORT_0_SPI_INT_SUPPORT_SHIFT                     _MK_SHIFT_CONST(0)
#define SDMMC_SPI_INTERRUPT_SUPPORT_0_SPI_INT_SUPPORT_FIELD                     (_MK_MASK_CONST(0xff) << SDMMC_SPI_INTERRUPT_SUPPORT_0_SPI_INT_SUPPORT_SHIFT)
#define SDMMC_SPI_INTERRUPT_SUPPORT_0_SPI_INT_SUPPORT_RANGE                     7:0
#define SDMMC_SPI_INTERRUPT_SUPPORT_0_SPI_INT_SUPPORT_WOFFSET                   0x0
#define SDMMC_SPI_INTERRUPT_SUPPORT_0_SPI_INT_SUPPORT_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_SPI_INTERRUPT_SUPPORT_0_SPI_INT_SUPPORT_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define SDMMC_SPI_INTERRUPT_SUPPORT_0_SPI_INT_SUPPORT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_SPI_INTERRUPT_SUPPORT_0_SPI_INT_SUPPORT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Reserved address 244 [0xf4] 

// Reserved address 248 [0xf8] 

// Register SDMMC_SLOT_INTERRUPT_STATUS_0  
#define SDMMC_SLOT_INTERRUPT_STATUS_0                   _MK_ADDR_CONST(0xfc)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_SECURE                    0x0
#define SDMMC_SLOT_INTERRUPT_STATUS_0_WORD_COUNT                        0x1
#define SDMMC_SLOT_INTERRUPT_STATUS_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_RESET_MASK                        _MK_MASK_CONST(0xffff00ff)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_READ_MASK                         _MK_MASK_CONST(0xffff00ff)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_VENDOR_VERSION_NUMBER_SHIFT                       _MK_SHIFT_CONST(24)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_VENDOR_VERSION_NUMBER_FIELD                       (_MK_MASK_CONST(0xff) << SDMMC_SLOT_INTERRUPT_STATUS_0_VENDOR_VERSION_NUMBER_SHIFT)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_VENDOR_VERSION_NUMBER_RANGE                       31:24
#define SDMMC_SLOT_INTERRUPT_STATUS_0_VENDOR_VERSION_NUMBER_WOFFSET                     0x0
#define SDMMC_SLOT_INTERRUPT_STATUS_0_VENDOR_VERSION_NUMBER_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_VENDOR_VERSION_NUMBER_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_VENDOR_VERSION_NUMBER_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_VENDOR_VERSION_NUMBER_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define SDMMC_SLOT_INTERRUPT_STATUS_0_SPECIFICATION_VERSION_NUMBER_SHIFT                        _MK_SHIFT_CONST(16)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_SPECIFICATION_VERSION_NUMBER_FIELD                        (_MK_MASK_CONST(0xff) << SDMMC_SLOT_INTERRUPT_STATUS_0_SPECIFICATION_VERSION_NUMBER_SHIFT)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_SPECIFICATION_VERSION_NUMBER_RANGE                        23:16
#define SDMMC_SLOT_INTERRUPT_STATUS_0_SPECIFICATION_VERSION_NUMBER_WOFFSET                      0x0
#define SDMMC_SLOT_INTERRUPT_STATUS_0_SPECIFICATION_VERSION_NUMBER_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_SPECIFICATION_VERSION_NUMBER_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_SPECIFICATION_VERSION_NUMBER_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_SPECIFICATION_VERSION_NUMBER_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define SDMMC_SLOT_INTERRUPT_STATUS_0_INTERRUPT_SIGNAL_FOR_EACH_SLOT_SHIFT                      _MK_SHIFT_CONST(0)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_INTERRUPT_SIGNAL_FOR_EACH_SLOT_FIELD                      (_MK_MASK_CONST(0xff) << SDMMC_SLOT_INTERRUPT_STATUS_0_INTERRUPT_SIGNAL_FOR_EACH_SLOT_SHIFT)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_INTERRUPT_SIGNAL_FOR_EACH_SLOT_RANGE                      7:0
#define SDMMC_SLOT_INTERRUPT_STATUS_0_INTERRUPT_SIGNAL_FOR_EACH_SLOT_WOFFSET                    0x0
#define SDMMC_SLOT_INTERRUPT_STATUS_0_INTERRUPT_SIGNAL_FOR_EACH_SLOT_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_INTERRUPT_SIGNAL_FOR_EACH_SLOT_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_INTERRUPT_SIGNAL_FOR_EACH_SLOT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_SLOT_INTERRUPT_STATUS_0_INTERRUPT_SIGNAL_FOR_EACH_SLOT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register SDMMC_VENDOR_CLOCK_CNTRL_0  
#define SDMMC_VENDOR_CLOCK_CNTRL_0                      _MK_ADDR_CONST(0x100)
#define SDMMC_VENDOR_CLOCK_CNTRL_0_SECURE                       0x0
#define SDMMC_VENDOR_CLOCK_CNTRL_0_WORD_COUNT                   0x1
#define SDMMC_VENDOR_CLOCK_CNTRL_0_RESET_VAL                    _MK_MASK_CONST(0x1)
#define SDMMC_VENDOR_CLOCK_CNTRL_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_VENDOR_CLOCK_CNTRL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_CLOCK_CNTRL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_CLOCK_CNTRL_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_VENDOR_CLOCK_CNTRL_0_WRITE_MASK                   _MK_MASK_CONST(0x1)
//  This is set when sdmmc_clk is supplied by the CAR module.Prior to sdmmc_clk switch OFF.This bit should be written '0'.  Prior to sdmmc_clk switch OFF.This bit should be written '0'.
//  By writing zero,the asynchronous card interrupt is routed to the Interrupt controller.
#define SDMMC_VENDOR_CLOCK_CNTRL_0_SDMMC_CLK_SHIFT                      _MK_SHIFT_CONST(0)
#define SDMMC_VENDOR_CLOCK_CNTRL_0_SDMMC_CLK_FIELD                      (_MK_MASK_CONST(0x1) << SDMMC_VENDOR_CLOCK_CNTRL_0_SDMMC_CLK_SHIFT)
#define SDMMC_VENDOR_CLOCK_CNTRL_0_SDMMC_CLK_RANGE                      0:0
#define SDMMC_VENDOR_CLOCK_CNTRL_0_SDMMC_CLK_WOFFSET                    0x0
#define SDMMC_VENDOR_CLOCK_CNTRL_0_SDMMC_CLK_DEFAULT                    _MK_MASK_CONST(0x1)
#define SDMMC_VENDOR_CLOCK_CNTRL_0_SDMMC_CLK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SDMMC_VENDOR_CLOCK_CNTRL_0_SDMMC_CLK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_CLOCK_CNTRL_0_SDMMC_CLK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_CLOCK_CNTRL_0_SDMMC_CLK_DISABLE                    _MK_ENUM_CONST(0)
#define SDMMC_VENDOR_CLOCK_CNTRL_0_SDMMC_CLK_ENABLE                     _MK_ENUM_CONST(1)


// Register SDMMC_VENDOR_SPI_CNTRL_0  
#define SDMMC_VENDOR_SPI_CNTRL_0                        _MK_ADDR_CONST(0x104)
#define SDMMC_VENDOR_SPI_CNTRL_0_SECURE                         0x0
#define SDMMC_VENDOR_SPI_CNTRL_0_WORD_COUNT                     0x1
#define SDMMC_VENDOR_SPI_CNTRL_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_SPI_CNTRL_0_RESET_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_VENDOR_SPI_CNTRL_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_SPI_CNTRL_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_SPI_CNTRL_0_READ_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_VENDOR_SPI_CNTRL_0_WRITE_MASK                     _MK_MASK_CONST(0x1)
//  This is a mirror bit.The SPI mode is set if this bit is set or CMD_XFER_MODE[7] is set  Writing 1 will drive the CS Low and writing zero will de-assert the CS Signal
#define SDMMC_VENDOR_SPI_CNTRL_0_SPI_MODE_SHIFT                 _MK_SHIFT_CONST(0)
#define SDMMC_VENDOR_SPI_CNTRL_0_SPI_MODE_FIELD                 (_MK_MASK_CONST(0x1) << SDMMC_VENDOR_SPI_CNTRL_0_SPI_MODE_SHIFT)
#define SDMMC_VENDOR_SPI_CNTRL_0_SPI_MODE_RANGE                 0:0
#define SDMMC_VENDOR_SPI_CNTRL_0_SPI_MODE_WOFFSET                       0x0
#define SDMMC_VENDOR_SPI_CNTRL_0_SPI_MODE_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_SPI_CNTRL_0_SPI_MODE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SDMMC_VENDOR_SPI_CNTRL_0_SPI_MODE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_SPI_CNTRL_0_SPI_MODE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_SPI_CNTRL_0_SPI_MODE_DISABLE                       _MK_ENUM_CONST(0)
#define SDMMC_VENDOR_SPI_CNTRL_0_SPI_MODE_ENABLE                        _MK_ENUM_CONST(1)


// Register SDMMC_VENDOR_SPI_INTR_STATUS_0  
#define SDMMC_VENDOR_SPI_INTR_STATUS_0                  _MK_ADDR_CONST(0x108)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_SECURE                   0x0
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_WORD_COUNT                       0x1
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_RESET_MASK                       _MK_MASK_CONST(0x1ff)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_READ_MASK                        _MK_MASK_CONST(0x1ff)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
//  Data Error Token,while read from card. 
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_ERR_TOKEN_SHIFT                      _MK_SHIFT_CONST(5)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_ERR_TOKEN_FIELD                      (_MK_MASK_CONST(0xf) << SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_ERR_TOKEN_SHIFT)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_ERR_TOKEN_RANGE                      8:5
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_ERR_TOKEN_WOFFSET                    0x0
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_ERR_TOKEN_DEFAULT                    _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_ERR_TOKEN_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_ERR_TOKEN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_ERR_TOKEN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  Data Response while write to card  
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_RESPONSE_SHIFT                       _MK_SHIFT_CONST(0)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_RESPONSE_FIELD                       (_MK_MASK_CONST(0x1f) << SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_RESPONSE_SHIFT)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_RESPONSE_RANGE                       4:0
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_RESPONSE_WOFFSET                     0x0
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_RESPONSE_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_RESPONSE_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_RESPONSE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_RESPONSE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_RESPONSE_DATA_ACCEPTED                       _MK_ENUM_CONST(5)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_RESPONSE_CRC_ERR                     _MK_ENUM_CONST(11)
#define SDMMC_VENDOR_SPI_INTR_STATUS_0_DAT_RESPONSE_WRITE_ERR                   _MK_ENUM_CONST(13)


// Register SDMMC_VENDOR_CEATA_CNTRL_0  
#define SDMMC_VENDOR_CEATA_CNTRL_0                      _MK_ADDR_CONST(0x10c)
#define SDMMC_VENDOR_CEATA_CNTRL_0_SECURE                       0x0
#define SDMMC_VENDOR_CEATA_CNTRL_0_WORD_COUNT                   0x1
#define SDMMC_VENDOR_CEATA_CNTRL_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_CEATA_CNTRL_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define SDMMC_VENDOR_CEATA_CNTRL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_CEATA_CNTRL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_CEATA_CNTRL_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define SDMMC_VENDOR_CEATA_CNTRL_0_WRITE_MASK                   _MK_MASK_CONST(0x1)
//  If this bit is set to 1,the controller expects a Command completion signal from the card after the transfer.  If the CCS Signal doesnt come within Data Timeout Value the CEATA Error is flagged.
#define SDMMC_VENDOR_CEATA_CNTRL_0_CCS_SIGNAL_SHIFT                     _MK_SHIFT_CONST(0)
#define SDMMC_VENDOR_CEATA_CNTRL_0_CCS_SIGNAL_FIELD                     (_MK_MASK_CONST(0x1) << SDMMC_VENDOR_CEATA_CNTRL_0_CCS_SIGNAL_SHIFT)
#define SDMMC_VENDOR_CEATA_CNTRL_0_CCS_SIGNAL_RANGE                     0:0
#define SDMMC_VENDOR_CEATA_CNTRL_0_CCS_SIGNAL_WOFFSET                   0x0
#define SDMMC_VENDOR_CEATA_CNTRL_0_CCS_SIGNAL_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_CEATA_CNTRL_0_CCS_SIGNAL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SDMMC_VENDOR_CEATA_CNTRL_0_CCS_SIGNAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_CEATA_CNTRL_0_CCS_SIGNAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_CEATA_CNTRL_0_CCS_SIGNAL_DISABLE                   _MK_ENUM_CONST(0)
#define SDMMC_VENDOR_CEATA_CNTRL_0_CCS_SIGNAL_ENABLE                    _MK_ENUM_CONST(1)


// Register SDMMC_VENDOR_BOOT_CNTRL_0  
#define SDMMC_VENDOR_BOOT_CNTRL_0                       _MK_ADDR_CONST(0x110)
#define SDMMC_VENDOR_BOOT_CNTRL_0_SECURE                        0x0
#define SDMMC_VENDOR_BOOT_CNTRL_0_WORD_COUNT                    0x1
#define SDMMC_VENDOR_BOOT_CNTRL_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_CNTRL_0_RESET_MASK                    _MK_MASK_CONST(0x3)
#define SDMMC_VENDOR_BOOT_CNTRL_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_CNTRL_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_CNTRL_0_READ_MASK                     _MK_MASK_CONST(0x3)
#define SDMMC_VENDOR_BOOT_CNTRL_0_WRITE_MASK                    _MK_MASK_CONST(0x3)
//  This bit is used to support Boot Option in MMC 4.3 version cards.  If set Boot acknowledgment is given by card else not given by card  
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_ACK_SHIFT                        _MK_SHIFT_CONST(1)
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_ACK_FIELD                        (_MK_MASK_CONST(0x1) << SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_ACK_SHIFT)
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_ACK_RANGE                        1:1
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_ACK_WOFFSET                      0x0
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_ACK_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_ACK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_ACK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_ACK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_ACK_DISABLE                      _MK_ENUM_CONST(0)
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_ACK_ENABLE                       _MK_ENUM_CONST(1)

//  This bit enables/disable BootOption1.If set BootOption1 is enable,HW auto clears it when boot data is done.  Writing 0 terminates the BootOption1    
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_SHIFT                    _MK_SHIFT_CONST(0)
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_FIELD                    (_MK_MASK_CONST(0x1) << SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_SHIFT)
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_RANGE                    0:0
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_WOFFSET                  0x0
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_DISABLE                  _MK_ENUM_CONST(0)
#define SDMMC_VENDOR_BOOT_CNTRL_0_BOOT_ENABLE                   _MK_ENUM_CONST(1)


// Register SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0  
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0                 _MK_ADDR_CONST(0x114)
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_SECURE                  0x0
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_WORD_COUNT                      0x1
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_RESET_MASK                      _MK_MASK_CONST(0xfffff)
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_READ_MASK                       _MK_MASK_CONST(0xfffff)
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_WRITE_MASK                      _MK_MASK_CONST(0xfffff)
//  If Boot Acknowledgment is not recieved within the the programmed number of cycles. 
//  Boot Acknowledgement Timeout error occurs(VENDOR_SPECIFIC_ERR[0])
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_VALUE_SHIFT                     _MK_SHIFT_CONST(0)
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_VALUE_FIELD                     (_MK_MASK_CONST(0xfffff) << SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_VALUE_SHIFT)
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_VALUE_RANGE                     19:0
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_VALUE_WOFFSET                   0x0
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_VALUE_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_VALUE_DEFAULT_MASK                      _MK_MASK_CONST(0xfffff)
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_VALUE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0_VALUE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0  
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0                 _MK_ADDR_CONST(0x118)
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_SECURE                  0x0
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_WORD_COUNT                      0x1
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_RESET_MASK                      _MK_MASK_CONST(0x1ffffff)
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_READ_MASK                       _MK_MASK_CONST(0x1ffffff)
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_WRITE_MASK                      _MK_MASK_CONST(0x1ffffff)
//  If Boot Data is not recieved within the the programmed number of cycles. Then Data Timeout error occurs.
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_VALUE_SHIFT                     _MK_SHIFT_CONST(0)
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_VALUE_FIELD                     (_MK_MASK_CONST(0x1ffffff) << SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_VALUE_SHIFT)
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_VALUE_RANGE                     24:0
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_VALUE_WOFFSET                   0x0
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_VALUE_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_VALUE_DEFAULT_MASK                      _MK_MASK_CONST(0x1ffffff)
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_VALUE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0_VALUE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register SDMMC_VENDOR_DEBOUNCE_COUNT_0  
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0                   _MK_ADDR_CONST(0x11c)
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0_SECURE                    0x0
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0_WORD_COUNT                        0x1
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0_RESET_VAL                         _MK_MASK_CONST(0xc80)
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0_RESET_MASK                        _MK_MASK_CONST(0xffffff)
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0_READ_MASK                         _MK_MASK_CONST(0xffffff)
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0_WRITE_MASK                        _MK_MASK_CONST(0xffffff)
//  The number of 32KHz clock cycles is programed to meet Debounce period of the card slot.
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0_VALUE_SHIFT                       _MK_SHIFT_CONST(0)
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0_VALUE_FIELD                       (_MK_MASK_CONST(0xffffff) << SDMMC_VENDOR_DEBOUNCE_COUNT_0_VALUE_SHIFT)
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0_VALUE_RANGE                       23:0
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0_VALUE_WOFFSET                     0x0
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0_VALUE_DEFAULT                     _MK_MASK_CONST(0xc80)
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0_VALUE_DEFAULT_MASK                        _MK_MASK_CONST(0xffffff)
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0_VALUE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_DEBOUNCE_COUNT_0_VALUE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register SDMMC_VENDOR_OBS_BUS_0  
#define SDMMC_VENDOR_OBS_BUS_0                  _MK_ADDR_CONST(0x120)
#define SDMMC_VENDOR_OBS_BUS_0_SECURE                   0x0
#define SDMMC_VENDOR_OBS_BUS_0_WORD_COUNT                       0x1
#define SDMMC_VENDOR_OBS_BUS_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_OBS_BUS_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define SDMMC_VENDOR_OBS_BUS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_OBS_BUS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_OBS_BUS_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define SDMMC_VENDOR_OBS_BUS_0_WRITE_MASK                       _MK_MASK_CONST(0xf)
//  Debug Information.
#define SDMMC_VENDOR_OBS_BUS_0_DATA_SHIFT                       _MK_SHIFT_CONST(4)
#define SDMMC_VENDOR_OBS_BUS_0_DATA_FIELD                       (_MK_MASK_CONST(0xfffffff) << SDMMC_VENDOR_OBS_BUS_0_DATA_SHIFT)
#define SDMMC_VENDOR_OBS_BUS_0_DATA_RANGE                       31:4
#define SDMMC_VENDOR_OBS_BUS_0_DATA_WOFFSET                     0x0
#define SDMMC_VENDOR_OBS_BUS_0_DATA_DEFAULT                     _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_OBS_BUS_0_DATA_DEFAULT_MASK                        _MK_MASK_CONST(0xfffffff)
#define SDMMC_VENDOR_OBS_BUS_0_DATA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_OBS_BUS_0_DATA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  Debug Select.Values from 0 to 7 are valid. 
#define SDMMC_VENDOR_OBS_BUS_0_SEL_SHIFT                        _MK_SHIFT_CONST(0)
#define SDMMC_VENDOR_OBS_BUS_0_SEL_FIELD                        (_MK_MASK_CONST(0xf) << SDMMC_VENDOR_OBS_BUS_0_SEL_SHIFT)
#define SDMMC_VENDOR_OBS_BUS_0_SEL_RANGE                        3:0
#define SDMMC_VENDOR_OBS_BUS_0_SEL_WOFFSET                      0x0
#define SDMMC_VENDOR_OBS_BUS_0_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_OBS_BUS_0_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define SDMMC_VENDOR_OBS_BUS_0_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SDMMC_VENDOR_OBS_BUS_0_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_ARSDMMC_REGS(_op_) \
_op_(SDMMC_SYSTEM_ADDRESS_0) \
_op_(SDMMC_BLOCK_SIZE_BLOCK_COUNT_0) \
_op_(SDMMC_ARGUMENT_0) \
_op_(SDMMC_CMD_XFER_MODE_0) \
_op_(SDMMC_RESPONSE_R0_R1_0) \
_op_(SDMMC_RESPONSE_R2_R3_0) \
_op_(SDMMC_RESPONSE_R4_R5_0) \
_op_(SDMMC_RESPONSE_R6_R7_0) \
_op_(SDMMC_BUFFER_DATA_PORT_0) \
_op_(SDMMC_PRESENT_STATE_0) \
_op_(SDMMC_POWER_CONTROL_HOST_0) \
_op_(SDMMC_SW_RESET_TIMEOUT_CTRL_CLOCK_CONTROL_0) \
_op_(SDMMC_INTERRUPT_STATUS_0) \
_op_(SDMMC_INTERRUPT_STATUS_ENABLE_0) \
_op_(SDMMC_INTERRUPT_SIGNAL_ENABLE_0) \
_op_(SDMMC_AUTO_CMD12_ERR_STATUS_0) \
_op_(SDMMC_CAPABILITIES_0) \
_op_(SDMMC_MAXIMUM_CURRENT_0) \
_op_(SDMMC_FORCE_EVENT_0) \
_op_(SDMMC_ADMA_ERR_STATUS_0) \
_op_(SDMMC_ADMA_SYSTEM_ADDRESS_0) \
_op_(SDMMC_DEBUG_SELECTION_REGISTER_0) \
_op_(SDMMC_SPI_INTERRUPT_SUPPORT_0) \
_op_(SDMMC_SLOT_INTERRUPT_STATUS_0) \
_op_(SDMMC_VENDOR_CLOCK_CNTRL_0) \
_op_(SDMMC_VENDOR_SPI_CNTRL_0) \
_op_(SDMMC_VENDOR_SPI_INTR_STATUS_0) \
_op_(SDMMC_VENDOR_CEATA_CNTRL_0) \
_op_(SDMMC_VENDOR_BOOT_CNTRL_0) \
_op_(SDMMC_VENDOR_BOOT_ACK_TIMEOUT_0) \
_op_(SDMMC_VENDOR_BOOT_DAT_TIMEOUT_0) \
_op_(SDMMC_VENDOR_DEBOUNCE_COUNT_0) \
_op_(SDMMC_VENDOR_OBS_BUS_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_SDMMC      0x00000000

//
// ARSDMMC REGISTER BANKS
//

#define SDMMC0_FIRST_REG 0x0000 // SDMMC_SYSTEM_ADDRESS_0
#define SDMMC0_LAST_REG 0x0040 // SDMMC_CAPABILITIES_0
#define SDMMC1_FIRST_REG 0x0048 // SDMMC_MAXIMUM_CURRENT_0
#define SDMMC1_LAST_REG 0x0048 // SDMMC_MAXIMUM_CURRENT_0
#define SDMMC2_FIRST_REG 0x0050 // SDMMC_FORCE_EVENT_0
#define SDMMC2_LAST_REG 0x0058 // SDMMC_ADMA_SYSTEM_ADDRESS_0
#define SDMMC3_FIRST_REG 0x0060 // SDMMC_DEBUG_SELECTION_REGISTER_0
#define SDMMC3_LAST_REG 0x0060 // SDMMC_DEBUG_SELECTION_REGISTER_0
#define SDMMC4_FIRST_REG 0x00f0 // SDMMC_SPI_INTERRUPT_SUPPORT_0
#define SDMMC4_LAST_REG 0x00f0 // SDMMC_SPI_INTERRUPT_SUPPORT_0
#define SDMMC5_FIRST_REG 0x00fc // SDMMC_SLOT_INTERRUPT_STATUS_0
#define SDMMC5_LAST_REG 0x0120 // SDMMC_VENDOR_OBS_BUS_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARSDMMC_H_INC_
