/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARSNOR_H_INC_
#define ___ARSNOR_H_INC_

// Register SNOR_CONFIG_0  
#define SNOR_CONFIG_0                   _MK_ADDR_CONST(0x0)
#define SNOR_CONFIG_0_SECURE                    0x0
#define SNOR_CONFIG_0_WORD_COUNT                        0x1
#define SNOR_CONFIG_0_RESET_VAL                         _MK_MASK_CONST(0x10800000)
#define SNOR_CONFIG_0_RESET_MASK                        _MK_MASK_CONST(0xfdf887ff)
#define SNOR_CONFIG_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_READ_MASK                         _MK_MASK_CONST(0xfdf887ff)
#define SNOR_CONFIG_0_WRITE_MASK                        _MK_MASK_CONST(0xfdf887ff)
// When set a NOR operation commences. 
#define SNOR_CONFIG_0_GO_NOR_SHIFT                      _MK_SHIFT_CONST(31)
#define SNOR_CONFIG_0_GO_NOR_FIELD                      (_MK_MASK_CONST(0x1) << SNOR_CONFIG_0_GO_NOR_SHIFT)
#define SNOR_CONFIG_0_GO_NOR_RANGE                      31:31
#define SNOR_CONFIG_0_GO_NOR_WOFFSET                    0x0
#define SNOR_CONFIG_0_GO_NOR_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_GO_NOR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SNOR_CONFIG_0_GO_NOR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_GO_NOR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_GO_NOR_DISABLE                    _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_GO_NOR_ENABLE                     _MK_ENUM_CONST(1)

// NOR Device DataBus width Configuration Bit 0=16Bit, 1=32Bit. 
#define SNOR_CONFIG_0_WORDWIDE_GMI_SHIFT                        _MK_SHIFT_CONST(30)
#define SNOR_CONFIG_0_WORDWIDE_GMI_FIELD                        (_MK_MASK_CONST(0x1) << SNOR_CONFIG_0_WORDWIDE_GMI_SHIFT)
#define SNOR_CONFIG_0_WORDWIDE_GMI_RANGE                        30:30
#define SNOR_CONFIG_0_WORDWIDE_GMI_WOFFSET                      0x0
#define SNOR_CONFIG_0_WORDWIDE_GMI_DEFAULT                      _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_WORDWIDE_GMI_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SNOR_CONFIG_0_WORDWIDE_GMI_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_WORDWIDE_GMI_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_WORDWIDE_GMI_NOR16BIT                     _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_WORDWIDE_GMI_NOR32BIT                     _MK_ENUM_CONST(1)

// External NOR Memory Type 0=SNOR, 1=MUXONENAND(simulation purpoes). 
#define SNOR_CONFIG_0_NOR_DEVICE_TYPE_SHIFT                     _MK_SHIFT_CONST(29)
#define SNOR_CONFIG_0_NOR_DEVICE_TYPE_FIELD                     (_MK_MASK_CONST(0x1) << SNOR_CONFIG_0_NOR_DEVICE_TYPE_SHIFT)
#define SNOR_CONFIG_0_NOR_DEVICE_TYPE_RANGE                     29:29
#define SNOR_CONFIG_0_NOR_DEVICE_TYPE_WOFFSET                   0x0
#define SNOR_CONFIG_0_NOR_DEVICE_TYPE_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_NOR_DEVICE_TYPE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SNOR_CONFIG_0_NOR_DEVICE_TYPE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_NOR_DEVICE_TYPE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_NOR_DEVICE_TYPE_SNOR                      _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_NOR_DEVICE_TYPE_MUXONENAND                        _MK_ENUM_CONST(1)

// NOR Device Address-Data Configuration Bit 0=NON-MUX Mode, 1=MUX Mode. 
#define SNOR_CONFIG_0_MUXMODE_GMI_SHIFT                 _MK_SHIFT_CONST(28)
#define SNOR_CONFIG_0_MUXMODE_GMI_FIELD                 (_MK_MASK_CONST(0x1) << SNOR_CONFIG_0_MUXMODE_GMI_SHIFT)
#define SNOR_CONFIG_0_MUXMODE_GMI_RANGE                 28:28
#define SNOR_CONFIG_0_MUXMODE_GMI_WOFFSET                       0x0
#define SNOR_CONFIG_0_MUXMODE_GMI_DEFAULT                       _MK_MASK_CONST(0x1)
#define SNOR_CONFIG_0_MUXMODE_GMI_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SNOR_CONFIG_0_MUXMODE_GMI_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_MUXMODE_GMI_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_MUXMODE_GMI_AD_NONMUX                     _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_MUXMODE_GMI_AD_MUX                        _MK_ENUM_CONST(1)

// Burst Length Types 00=Continuous Burst, 01=8 Words, 10=16 Words, 11=32 Words. 
#define SNOR_CONFIG_0_BURST_LENGTH_SHIFT                        _MK_SHIFT_CONST(26)
#define SNOR_CONFIG_0_BURST_LENGTH_FIELD                        (_MK_MASK_CONST(0x3) << SNOR_CONFIG_0_BURST_LENGTH_SHIFT)
#define SNOR_CONFIG_0_BURST_LENGTH_RANGE                        27:26
#define SNOR_CONFIG_0_BURST_LENGTH_WOFFSET                      0x0
#define SNOR_CONFIG_0_BURST_LENGTH_DEFAULT                      _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_BURST_LENGTH_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define SNOR_CONFIG_0_BURST_LENGTH_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_BURST_LENGTH_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_BURST_LENGTH_CNTBRST                      _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_BURST_LENGTH_BL8WORD                      _MK_ENUM_CONST(1)
#define SNOR_CONFIG_0_BURST_LENGTH_BL16WORD                     _MK_ENUM_CONST(2)
#define SNOR_CONFIG_0_BURST_LENGTH_BL32WORD                     _MK_ENUM_CONST(3)

// Device RDY Active Status 0=With Data, 1=One Cycle Before Data. 
#define SNOR_CONFIG_0_RDY_ACTIVE_SHIFT                  _MK_SHIFT_CONST(24)
#define SNOR_CONFIG_0_RDY_ACTIVE_FIELD                  (_MK_MASK_CONST(0x1) << SNOR_CONFIG_0_RDY_ACTIVE_SHIFT)
#define SNOR_CONFIG_0_RDY_ACTIVE_RANGE                  24:24
#define SNOR_CONFIG_0_RDY_ACTIVE_WOFFSET                        0x0
#define SNOR_CONFIG_0_RDY_ACTIVE_DEFAULT                        _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_RDY_ACTIVE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SNOR_CONFIG_0_RDY_ACTIVE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_RDY_ACTIVE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_RDY_ACTIVE_WITHDATA                       _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_RDY_ACTIVE_BEFOREDATA                     _MK_ENUM_CONST(1)

// Ready signal polarity 0=Active low, 1=Active high. 
#define SNOR_CONFIG_0_RDY_POLARITY_SHIFT                        _MK_SHIFT_CONST(23)
#define SNOR_CONFIG_0_RDY_POLARITY_FIELD                        (_MK_MASK_CONST(0x1) << SNOR_CONFIG_0_RDY_POLARITY_SHIFT)
#define SNOR_CONFIG_0_RDY_POLARITY_RANGE                        23:23
#define SNOR_CONFIG_0_RDY_POLARITY_WOFFSET                      0x0
#define SNOR_CONFIG_0_RDY_POLARITY_DEFAULT                      _MK_MASK_CONST(0x1)
#define SNOR_CONFIG_0_RDY_POLARITY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SNOR_CONFIG_0_RDY_POLARITY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_RDY_POLARITY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_RDY_POLARITY_RESV                 _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_RDY_POLARITY_HIGH                 _MK_ENUM_CONST(1)

// ADV pulse polarity 0=Active low, 1=Active high. 
#define SNOR_CONFIG_0_ADV_POLARITY_SHIFT                        _MK_SHIFT_CONST(22)
#define SNOR_CONFIG_0_ADV_POLARITY_FIELD                        (_MK_MASK_CONST(0x1) << SNOR_CONFIG_0_ADV_POLARITY_SHIFT)
#define SNOR_CONFIG_0_ADV_POLARITY_RANGE                        22:22
#define SNOR_CONFIG_0_ADV_POLARITY_WOFFSET                      0x0
#define SNOR_CONFIG_0_ADV_POLARITY_DEFAULT                      _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_ADV_POLARITY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SNOR_CONFIG_0_ADV_POLARITY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_ADV_POLARITY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_ADV_POLARITY_LOW                  _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_ADV_POLARITY_RESV                 _MK_ENUM_CONST(1)

// OE/WE polarity 0=Active low, 1=Active high. 
#define SNOR_CONFIG_0_OE_WE_POLARITY_SHIFT                      _MK_SHIFT_CONST(21)
#define SNOR_CONFIG_0_OE_WE_POLARITY_FIELD                      (_MK_MASK_CONST(0x1) << SNOR_CONFIG_0_OE_WE_POLARITY_SHIFT)
#define SNOR_CONFIG_0_OE_WE_POLARITY_RANGE                      21:21
#define SNOR_CONFIG_0_OE_WE_POLARITY_WOFFSET                    0x0
#define SNOR_CONFIG_0_OE_WE_POLARITY_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_OE_WE_POLARITY_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SNOR_CONFIG_0_OE_WE_POLARITY_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_OE_WE_POLARITY_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_OE_WE_POLARITY_LOW                        _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_OE_WE_POLARITY_RESV                       _MK_ENUM_CONST(1)

// Chip Select polarity 0=Active low, 1=Active high. 
#define SNOR_CONFIG_0_CS_POLARITY_SHIFT                 _MK_SHIFT_CONST(20)
#define SNOR_CONFIG_0_CS_POLARITY_FIELD                 (_MK_MASK_CONST(0x1) << SNOR_CONFIG_0_CS_POLARITY_SHIFT)
#define SNOR_CONFIG_0_CS_POLARITY_RANGE                 20:20
#define SNOR_CONFIG_0_CS_POLARITY_WOFFSET                       0x0
#define SNOR_CONFIG_0_CS_POLARITY_DEFAULT                       _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_CS_POLARITY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SNOR_CONFIG_0_CS_POLARITY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_CS_POLARITY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_CS_POLARITY_LOW                   _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_CS_POLARITY_RESV                  _MK_ENUM_CONST(1)

// Indicates the Power Down Mode enable bit. 
#define SNOR_CONFIG_0_NOR_DPD_SHIFT                     _MK_SHIFT_CONST(19)
#define SNOR_CONFIG_0_NOR_DPD_FIELD                     (_MK_MASK_CONST(0x1) << SNOR_CONFIG_0_NOR_DPD_SHIFT)
#define SNOR_CONFIG_0_NOR_DPD_RANGE                     19:19
#define SNOR_CONFIG_0_NOR_DPD_WOFFSET                   0x0
#define SNOR_CONFIG_0_NOR_DPD_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_NOR_DPD_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SNOR_CONFIG_0_NOR_DPD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_NOR_DPD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_NOR_DPD_DISABLE                   _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_NOR_DPD_ENABLE                    _MK_ENUM_CONST(1)

// Sets the NOR Write protect enable bit. 
#define SNOR_CONFIG_0_NOR_WP_SHIFT                      _MK_SHIFT_CONST(15)
#define SNOR_CONFIG_0_NOR_WP_FIELD                      (_MK_MASK_CONST(0x1) << SNOR_CONFIG_0_NOR_WP_SHIFT)
#define SNOR_CONFIG_0_NOR_WP_RANGE                      15:15
#define SNOR_CONFIG_0_NOR_WP_WOFFSET                    0x0
#define SNOR_CONFIG_0_NOR_WP_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_NOR_WP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SNOR_CONFIG_0_NOR_WP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_NOR_WP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_NOR_WP_DISABLE                    _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_NOR_WP_ENABLE                     _MK_ENUM_CONST(1)

// Sets the number of words in a page if page mode is selected. 
#define SNOR_CONFIG_0_PAGE_SIZE_SHIFT                   _MK_SHIFT_CONST(8)
#define SNOR_CONFIG_0_PAGE_SIZE_FIELD                   (_MK_MASK_CONST(0x7) << SNOR_CONFIG_0_PAGE_SIZE_SHIFT)
#define SNOR_CONFIG_0_PAGE_SIZE_RANGE                   10:8
#define SNOR_CONFIG_0_PAGE_SIZE_WOFFSET                 0x0
#define SNOR_CONFIG_0_PAGE_SIZE_DEFAULT                 _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_PAGE_SIZE_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define SNOR_CONFIG_0_PAGE_SIZE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_PAGE_SIZE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_PAGE_SIZE_BRST                    _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_PAGE_SIZE_PG4WORD                 _MK_ENUM_CONST(1)
#define SNOR_CONFIG_0_PAGE_SIZE_PG8WORD                 _MK_ENUM_CONST(2)
#define SNOR_CONFIG_0_PAGE_SIZE_PG16WORD                        _MK_ENUM_CONST(3)
#define SNOR_CONFIG_0_PAGE_SIZE_RESV4                   _MK_ENUM_CONST(4)
#define SNOR_CONFIG_0_PAGE_SIZE_RESV5                   _MK_ENUM_CONST(5)
#define SNOR_CONFIG_0_PAGE_SIZE_RESV6                   _MK_ENUM_CONST(6)
#define SNOR_CONFIG_0_PAGE_SIZE_RESV7                   _MK_ENUM_CONST(7)

// Selection bit between Master DMA and Slave Interface. 
#define SNOR_CONFIG_0_MST_ENB_SHIFT                     _MK_SHIFT_CONST(7)
#define SNOR_CONFIG_0_MST_ENB_FIELD                     (_MK_MASK_CONST(0x1) << SNOR_CONFIG_0_MST_ENB_SHIFT)
#define SNOR_CONFIG_0_MST_ENB_RANGE                     7:7
#define SNOR_CONFIG_0_MST_ENB_WOFFSET                   0x0
#define SNOR_CONFIG_0_MST_ENB_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_MST_ENB_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SNOR_CONFIG_0_MST_ENB_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_MST_ENB_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_MST_ENB_DISABLE                   _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_MST_ENB_ENABLE                    _MK_ENUM_CONST(1)

// SNOR 8 chip selects combinations.
#define SNOR_CONFIG_0_SNOR_SEL_SHIFT                    _MK_SHIFT_CONST(4)
#define SNOR_CONFIG_0_SNOR_SEL_FIELD                    (_MK_MASK_CONST(0x7) << SNOR_CONFIG_0_SNOR_SEL_SHIFT)
#define SNOR_CONFIG_0_SNOR_SEL_RANGE                    6:4
#define SNOR_CONFIG_0_SNOR_SEL_WOFFSET                  0x0
#define SNOR_CONFIG_0_SNOR_SEL_DEFAULT                  _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_SNOR_SEL_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define SNOR_CONFIG_0_SNOR_SEL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_SNOR_SEL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_SNOR_SEL_CS0                      _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_SNOR_SEL_CS1                      _MK_ENUM_CONST(1)
#define SNOR_CONFIG_0_SNOR_SEL_CS2                      _MK_ENUM_CONST(2)
#define SNOR_CONFIG_0_SNOR_SEL_CS3                      _MK_ENUM_CONST(3)
#define SNOR_CONFIG_0_SNOR_SEL_CS4                      _MK_ENUM_CONST(4)
#define SNOR_CONFIG_0_SNOR_SEL_CS5                      _MK_ENUM_CONST(5)
#define SNOR_CONFIG_0_SNOR_SEL_CS6                      _MK_ENUM_CONST(6)
#define SNOR_CONFIG_0_SNOR_SEL_CS7                      _MK_ENUM_CONST(7)

// Indicates if the ADV gets asserted before CE. 
#define SNOR_CONFIG_0_CE_LAST_SHIFT                     _MK_SHIFT_CONST(3)
#define SNOR_CONFIG_0_CE_LAST_FIELD                     (_MK_MASK_CONST(0x1) << SNOR_CONFIG_0_CE_LAST_SHIFT)
#define SNOR_CONFIG_0_CE_LAST_RANGE                     3:3
#define SNOR_CONFIG_0_CE_LAST_WOFFSET                   0x0
#define SNOR_CONFIG_0_CE_LAST_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_CE_LAST_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SNOR_CONFIG_0_CE_LAST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_CE_LAST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_CE_LAST_DISABLE                   _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_CE_LAST_RESV                      _MK_ENUM_CONST(1)

// Indicates if the CE gets asserted before ADV.
#define SNOR_CONFIG_0_CE_FIRST_SHIFT                    _MK_SHIFT_CONST(2)
#define SNOR_CONFIG_0_CE_FIRST_FIELD                    (_MK_MASK_CONST(0x1) << SNOR_CONFIG_0_CE_FIRST_SHIFT)
#define SNOR_CONFIG_0_CE_FIRST_RANGE                    2:2
#define SNOR_CONFIG_0_CE_FIRST_WOFFSET                  0x0
#define SNOR_CONFIG_0_CE_FIRST_DEFAULT                  _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_CE_FIRST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SNOR_CONFIG_0_CE_FIRST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_CE_FIRST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_CE_FIRST_DISABLE                  _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_CE_FIRST_RESV                     _MK_ENUM_CONST(1)

// This field specifies the Mode of Operation for SYNC Memories.
#define SNOR_CONFIG_0_DEVICE_MODE_SHIFT                 _MK_SHIFT_CONST(0)
#define SNOR_CONFIG_0_DEVICE_MODE_FIELD                 (_MK_MASK_CONST(0x3) << SNOR_CONFIG_0_DEVICE_MODE_SHIFT)
#define SNOR_CONFIG_0_DEVICE_MODE_RANGE                 1:0
#define SNOR_CONFIG_0_DEVICE_MODE_WOFFSET                       0x0
#define SNOR_CONFIG_0_DEVICE_MODE_DEFAULT                       _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_DEVICE_MODE_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define SNOR_CONFIG_0_DEVICE_MODE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_DEVICE_MODE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SNOR_CONFIG_0_DEVICE_MODE_ASYNC                 _MK_ENUM_CONST(0)
#define SNOR_CONFIG_0_DEVICE_MODE_PAGE                  _MK_ENUM_CONST(1)
#define SNOR_CONFIG_0_DEVICE_MODE_BURST                 _MK_ENUM_CONST(2)
#define SNOR_CONFIG_0_DEVICE_MODE_RESV                  _MK_ENUM_CONST(3)


// Register SNOR_STA_0  
#define SNOR_STA_0                      _MK_ADDR_CONST(0x4)
#define SNOR_STA_0_SECURE                       0x0
#define SNOR_STA_0_WORD_COUNT                   0x1
#define SNOR_STA_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define SNOR_STA_0_RESET_MASK                   _MK_MASK_CONST(0x8ff0ffff)
#define SNOR_STA_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define SNOR_STA_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SNOR_STA_0_READ_MASK                    _MK_MASK_CONST(0x8ff0ffff)
#define SNOR_STA_0_WRITE_MASK                   _MK_MASK_CONST(0xf000000)
// Indicates that the device status. 
#define SNOR_STA_0_DEVICE_BSY_SHIFT                     _MK_SHIFT_CONST(31)
#define SNOR_STA_0_DEVICE_BSY_FIELD                     (_MK_MASK_CONST(0x1) << SNOR_STA_0_DEVICE_BSY_SHIFT)
#define SNOR_STA_0_DEVICE_BSY_RANGE                     31:31
#define SNOR_STA_0_DEVICE_BSY_WOFFSET                   0x0
#define SNOR_STA_0_DEVICE_BSY_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_STA_0_DEVICE_BSY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SNOR_STA_0_DEVICE_BSY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SNOR_STA_0_DEVICE_BSY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Device Interrupt-2 from MuxOneNand Memory. 
#define SNOR_STA_0_DEVICE_INTR_2_SHIFT                  _MK_SHIFT_CONST(27)
#define SNOR_STA_0_DEVICE_INTR_2_FIELD                  (_MK_MASK_CONST(0x1) << SNOR_STA_0_DEVICE_INTR_2_SHIFT)
#define SNOR_STA_0_DEVICE_INTR_2_RANGE                  27:27
#define SNOR_STA_0_DEVICE_INTR_2_WOFFSET                        0x0
#define SNOR_STA_0_DEVICE_INTR_2_DEFAULT                        _MK_MASK_CONST(0x0)
#define SNOR_STA_0_DEVICE_INTR_2_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SNOR_STA_0_DEVICE_INTR_2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SNOR_STA_0_DEVICE_INTR_2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Device Interrupt-1 from MuxOneNand Memory. 
#define SNOR_STA_0_DEVICE_INTR_1_SHIFT                  _MK_SHIFT_CONST(26)
#define SNOR_STA_0_DEVICE_INTR_1_FIELD                  (_MK_MASK_CONST(0x1) << SNOR_STA_0_DEVICE_INTR_1_SHIFT)
#define SNOR_STA_0_DEVICE_INTR_1_RANGE                  26:26
#define SNOR_STA_0_DEVICE_INTR_1_WOFFSET                        0x0
#define SNOR_STA_0_DEVICE_INTR_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define SNOR_STA_0_DEVICE_INTR_1_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SNOR_STA_0_DEVICE_INTR_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SNOR_STA_0_DEVICE_INTR_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Device Interrupt-2 Enable Bit. 
#define SNOR_STA_0_DEVICE_INTR_2_ENB_SHIFT                      _MK_SHIFT_CONST(25)
#define SNOR_STA_0_DEVICE_INTR_2_ENB_FIELD                      (_MK_MASK_CONST(0x1) << SNOR_STA_0_DEVICE_INTR_2_ENB_SHIFT)
#define SNOR_STA_0_DEVICE_INTR_2_ENB_RANGE                      25:25
#define SNOR_STA_0_DEVICE_INTR_2_ENB_WOFFSET                    0x0
#define SNOR_STA_0_DEVICE_INTR_2_ENB_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_STA_0_DEVICE_INTR_2_ENB_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SNOR_STA_0_DEVICE_INTR_2_ENB_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SNOR_STA_0_DEVICE_INTR_2_ENB_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Device Interrupt-1 Enable Bit. 
#define SNOR_STA_0_DEVICE_INTR_1_ENB_SHIFT                      _MK_SHIFT_CONST(24)
#define SNOR_STA_0_DEVICE_INTR_1_ENB_FIELD                      (_MK_MASK_CONST(0x1) << SNOR_STA_0_DEVICE_INTR_1_ENB_SHIFT)
#define SNOR_STA_0_DEVICE_INTR_1_ENB_RANGE                      24:24
#define SNOR_STA_0_DEVICE_INTR_1_ENB_WOFFSET                    0x0
#define SNOR_STA_0_DEVICE_INTR_1_ENB_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_STA_0_DEVICE_INTR_1_ENB_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SNOR_STA_0_DEVICE_INTR_1_ENB_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SNOR_STA_0_DEVICE_INTR_1_ENB_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// SLV FIFO full status. 
#define SNOR_STA_0_SLV_FIFO_FULL_SHIFT                  _MK_SHIFT_CONST(23)
#define SNOR_STA_0_SLV_FIFO_FULL_FIELD                  (_MK_MASK_CONST(0x1) << SNOR_STA_0_SLV_FIFO_FULL_SHIFT)
#define SNOR_STA_0_SLV_FIFO_FULL_RANGE                  23:23
#define SNOR_STA_0_SLV_FIFO_FULL_WOFFSET                        0x0
#define SNOR_STA_0_SLV_FIFO_FULL_DEFAULT                        _MK_MASK_CONST(0x0)
#define SNOR_STA_0_SLV_FIFO_FULL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SNOR_STA_0_SLV_FIFO_FULL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SNOR_STA_0_SLV_FIFO_FULL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// SLV FIFO empty status. 
#define SNOR_STA_0_SLV_FIFO_EMPTY_SHIFT                 _MK_SHIFT_CONST(22)
#define SNOR_STA_0_SLV_FIFO_EMPTY_FIELD                 (_MK_MASK_CONST(0x1) << SNOR_STA_0_SLV_FIFO_EMPTY_SHIFT)
#define SNOR_STA_0_SLV_FIFO_EMPTY_RANGE                 22:22
#define SNOR_STA_0_SLV_FIFO_EMPTY_WOFFSET                       0x0
#define SNOR_STA_0_SLV_FIFO_EMPTY_DEFAULT                       _MK_MASK_CONST(0x0)
#define SNOR_STA_0_SLV_FIFO_EMPTY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SNOR_STA_0_SLV_FIFO_EMPTY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_STA_0_SLV_FIFO_EMPTY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// MST FIFO full status. 
#define SNOR_STA_0_MST_FIFO_FULL_SHIFT                  _MK_SHIFT_CONST(21)
#define SNOR_STA_0_MST_FIFO_FULL_FIELD                  (_MK_MASK_CONST(0x1) << SNOR_STA_0_MST_FIFO_FULL_SHIFT)
#define SNOR_STA_0_MST_FIFO_FULL_RANGE                  21:21
#define SNOR_STA_0_MST_FIFO_FULL_WOFFSET                        0x0
#define SNOR_STA_0_MST_FIFO_FULL_DEFAULT                        _MK_MASK_CONST(0x0)
#define SNOR_STA_0_MST_FIFO_FULL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SNOR_STA_0_MST_FIFO_FULL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SNOR_STA_0_MST_FIFO_FULL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// MST FIFO empty status. 
#define SNOR_STA_0_MST_FIFO_EMPTY_SHIFT                 _MK_SHIFT_CONST(20)
#define SNOR_STA_0_MST_FIFO_EMPTY_FIELD                 (_MK_MASK_CONST(0x1) << SNOR_STA_0_MST_FIFO_EMPTY_SHIFT)
#define SNOR_STA_0_MST_FIFO_EMPTY_RANGE                 20:20
#define SNOR_STA_0_MST_FIFO_EMPTY_WOFFSET                       0x0
#define SNOR_STA_0_MST_FIFO_EMPTY_DEFAULT                       _MK_MASK_CONST(0x0)
#define SNOR_STA_0_MST_FIFO_EMPTY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SNOR_STA_0_MST_FIFO_EMPTY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_STA_0_MST_FIFO_EMPTY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Indicates the number of Data to be transfered; current dma_data_count.
#define SNOR_STA_0_DMA_DATA_CNT_SHIFT                   _MK_SHIFT_CONST(0)
#define SNOR_STA_0_DMA_DATA_CNT_FIELD                   (_MK_MASK_CONST(0xffff) << SNOR_STA_0_DMA_DATA_CNT_SHIFT)
#define SNOR_STA_0_DMA_DATA_CNT_RANGE                   15:0
#define SNOR_STA_0_DMA_DATA_CNT_WOFFSET                 0x0
#define SNOR_STA_0_DMA_DATA_CNT_DEFAULT                 _MK_MASK_CONST(0x0)
#define SNOR_STA_0_DMA_DATA_CNT_DEFAULT_MASK                    _MK_MASK_CONST(0xffff)
#define SNOR_STA_0_DMA_DATA_CNT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SNOR_STA_0_DMA_DATA_CNT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register SNOR_NOR_ADDR_PTR_0  
#define SNOR_NOR_ADDR_PTR_0                     _MK_ADDR_CONST(0x8)
#define SNOR_NOR_ADDR_PTR_0_SECURE                      0x0
#define SNOR_NOR_ADDR_PTR_0_WORD_COUNT                  0x1
#define SNOR_NOR_ADDR_PTR_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define SNOR_NOR_ADDR_PTR_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define SNOR_NOR_ADDR_PTR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define SNOR_NOR_ADDR_PTR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SNOR_NOR_ADDR_PTR_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define SNOR_NOR_ADDR_PTR_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// Indicates that the NOR controller Address.
#define SNOR_NOR_ADDR_PTR_0_SNOR_NOR_ADDR_PTR_SHIFT                     _MK_SHIFT_CONST(0)
#define SNOR_NOR_ADDR_PTR_0_SNOR_NOR_ADDR_PTR_FIELD                     (_MK_MASK_CONST(0xffffffff) << SNOR_NOR_ADDR_PTR_0_SNOR_NOR_ADDR_PTR_SHIFT)
#define SNOR_NOR_ADDR_PTR_0_SNOR_NOR_ADDR_PTR_RANGE                     31:0
#define SNOR_NOR_ADDR_PTR_0_SNOR_NOR_ADDR_PTR_WOFFSET                   0x0
#define SNOR_NOR_ADDR_PTR_0_SNOR_NOR_ADDR_PTR_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_NOR_ADDR_PTR_0_SNOR_NOR_ADDR_PTR_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define SNOR_NOR_ADDR_PTR_0_SNOR_NOR_ADDR_PTR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SNOR_NOR_ADDR_PTR_0_SNOR_NOR_ADDR_PTR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register SNOR_AHB_ADDR_PTR_0  
#define SNOR_AHB_ADDR_PTR_0                     _MK_ADDR_CONST(0xc)
#define SNOR_AHB_ADDR_PTR_0_SECURE                      0x0
#define SNOR_AHB_ADDR_PTR_0_WORD_COUNT                  0x1
#define SNOR_AHB_ADDR_PTR_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define SNOR_AHB_ADDR_PTR_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define SNOR_AHB_ADDR_PTR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define SNOR_AHB_ADDR_PTR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SNOR_AHB_ADDR_PTR_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define SNOR_AHB_ADDR_PTR_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// Indicates that the AHB side Address.
#define SNOR_AHB_ADDR_PTR_0_SNOR_AHB_ADDR_PTR_SHIFT                     _MK_SHIFT_CONST(0)
#define SNOR_AHB_ADDR_PTR_0_SNOR_AHB_ADDR_PTR_FIELD                     (_MK_MASK_CONST(0xffffffff) << SNOR_AHB_ADDR_PTR_0_SNOR_AHB_ADDR_PTR_SHIFT)
#define SNOR_AHB_ADDR_PTR_0_SNOR_AHB_ADDR_PTR_RANGE                     31:0
#define SNOR_AHB_ADDR_PTR_0_SNOR_AHB_ADDR_PTR_WOFFSET                   0x0
#define SNOR_AHB_ADDR_PTR_0_SNOR_AHB_ADDR_PTR_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_AHB_ADDR_PTR_0_SNOR_AHB_ADDR_PTR_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define SNOR_AHB_ADDR_PTR_0_SNOR_AHB_ADDR_PTR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SNOR_AHB_ADDR_PTR_0_SNOR_AHB_ADDR_PTR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register SNOR_TIMING0_0  
#define SNOR_TIMING0_0                  _MK_ADDR_CONST(0x10)
#define SNOR_TIMING0_0_SECURE                   0x0
#define SNOR_TIMING0_0_WORD_COUNT                       0x1
#define SNOR_TIMING0_0_RESET_VAL                        _MK_MASK_CONST(0x30101114)
#define SNOR_TIMING0_0_RESET_MASK                       _MK_MASK_CONST(0xf0f0ffff)
#define SNOR_TIMING0_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define SNOR_TIMING0_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SNOR_TIMING0_0_READ_MASK                        _MK_MASK_CONST(0xf0f0ffff)
#define SNOR_TIMING0_0_WRITE_MASK                       _MK_MASK_CONST(0xf0f0ffff)
// This represents the number of wait clock cycles from address to 1st data ready.
#define SNOR_TIMING0_0_PAGE_RDY_WIDTH_SHIFT                     _MK_SHIFT_CONST(28)
#define SNOR_TIMING0_0_PAGE_RDY_WIDTH_FIELD                     (_MK_MASK_CONST(0xf) << SNOR_TIMING0_0_PAGE_RDY_WIDTH_SHIFT)
#define SNOR_TIMING0_0_PAGE_RDY_WIDTH_RANGE                     31:28
#define SNOR_TIMING0_0_PAGE_RDY_WIDTH_WOFFSET                   0x0
#define SNOR_TIMING0_0_PAGE_RDY_WIDTH_DEFAULT                   _MK_MASK_CONST(0x3)
#define SNOR_TIMING0_0_PAGE_RDY_WIDTH_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define SNOR_TIMING0_0_PAGE_RDY_WIDTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SNOR_TIMING0_0_PAGE_RDY_WIDTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Page Sequential width indicates the delay cycle between the intra page Read access.
#define SNOR_TIMING0_0_PAGE_SEQ_WIDTH_SHIFT                     _MK_SHIFT_CONST(20)
#define SNOR_TIMING0_0_PAGE_SEQ_WIDTH_FIELD                     (_MK_MASK_CONST(0xf) << SNOR_TIMING0_0_PAGE_SEQ_WIDTH_SHIFT)
#define SNOR_TIMING0_0_PAGE_SEQ_WIDTH_RANGE                     23:20
#define SNOR_TIMING0_0_PAGE_SEQ_WIDTH_WOFFSET                   0x0
#define SNOR_TIMING0_0_PAGE_SEQ_WIDTH_DEFAULT                   _MK_MASK_CONST(0x1)
#define SNOR_TIMING0_0_PAGE_SEQ_WIDTH_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define SNOR_TIMING0_0_PAGE_SEQ_WIDTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SNOR_TIMING0_0_PAGE_SEQ_WIDTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates in number of cycles MUX address/data asserted on the bus.
#define SNOR_TIMING0_0_MUXED_WIDTH_SHIFT                        _MK_SHIFT_CONST(12)
#define SNOR_TIMING0_0_MUXED_WIDTH_FIELD                        (_MK_MASK_CONST(0xf) << SNOR_TIMING0_0_MUXED_WIDTH_SHIFT)
#define SNOR_TIMING0_0_MUXED_WIDTH_RANGE                        15:12
#define SNOR_TIMING0_0_MUXED_WIDTH_WOFFSET                      0x0
#define SNOR_TIMING0_0_MUXED_WIDTH_DEFAULT                      _MK_MASK_CONST(0x1)
#define SNOR_TIMING0_0_MUXED_WIDTH_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define SNOR_TIMING0_0_MUXED_WIDTH_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_TIMING0_0_MUXED_WIDTH_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Indicates in number of cycles CE stays asserted after the de-assertion of WE_(in case of SLAVE/MASTER Request) or OE_(in case of MASTER Request).
#define SNOR_TIMING0_0_HOLD_WIDTH_SHIFT                 _MK_SHIFT_CONST(8)
#define SNOR_TIMING0_0_HOLD_WIDTH_FIELD                 (_MK_MASK_CONST(0xf) << SNOR_TIMING0_0_HOLD_WIDTH_SHIFT)
#define SNOR_TIMING0_0_HOLD_WIDTH_RANGE                 11:8
#define SNOR_TIMING0_0_HOLD_WIDTH_WOFFSET                       0x0
#define SNOR_TIMING0_0_HOLD_WIDTH_DEFAULT                       _MK_MASK_CONST(0x1)
#define SNOR_TIMING0_0_HOLD_WIDTH_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define SNOR_TIMING0_0_HOLD_WIDTH_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_TIMING0_0_HOLD_WIDTH_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Indicates the number of cycles during which ADV stays asserted. 
#define SNOR_TIMING0_0_ADV_WIDTH_SHIFT                  _MK_SHIFT_CONST(4)
#define SNOR_TIMING0_0_ADV_WIDTH_FIELD                  (_MK_MASK_CONST(0xf) << SNOR_TIMING0_0_ADV_WIDTH_SHIFT)
#define SNOR_TIMING0_0_ADV_WIDTH_RANGE                  7:4
#define SNOR_TIMING0_0_ADV_WIDTH_WOFFSET                        0x0
#define SNOR_TIMING0_0_ADV_WIDTH_DEFAULT                        _MK_MASK_CONST(0x1)
#define SNOR_TIMING0_0_ADV_WIDTH_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define SNOR_TIMING0_0_ADV_WIDTH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SNOR_TIMING0_0_ADV_WIDTH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Indicates the number of cycles before CE is asserted. 
#define SNOR_TIMING0_0_CE_WIDTH_SHIFT                   _MK_SHIFT_CONST(0)
#define SNOR_TIMING0_0_CE_WIDTH_FIELD                   (_MK_MASK_CONST(0xf) << SNOR_TIMING0_0_CE_WIDTH_SHIFT)
#define SNOR_TIMING0_0_CE_WIDTH_RANGE                   3:0
#define SNOR_TIMING0_0_CE_WIDTH_WOFFSET                 0x0
#define SNOR_TIMING0_0_CE_WIDTH_DEFAULT                 _MK_MASK_CONST(0x4)
#define SNOR_TIMING0_0_CE_WIDTH_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define SNOR_TIMING0_0_CE_WIDTH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SNOR_TIMING0_0_CE_WIDTH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register SNOR_TIMING1_0  
#define SNOR_TIMING1_0                  _MK_ADDR_CONST(0x14)
#define SNOR_TIMING1_0_SECURE                   0x0
#define SNOR_TIMING1_0_WORD_COUNT                       0x1
#define SNOR_TIMING1_0_RESET_VAL                        _MK_MASK_CONST(0x10103)
#define SNOR_TIMING1_0_RESET_MASK                       _MK_MASK_CONST(0xffffff)
#define SNOR_TIMING1_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define SNOR_TIMING1_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SNOR_TIMING1_0_READ_MASK                        _MK_MASK_CONST(0xffffff)
#define SNOR_TIMING1_0_WRITE_MASK                       _MK_MASK_CONST(0xffffff)
// Write access time. 
#define SNOR_TIMING1_0_WE_WIDTH_SHIFT                   _MK_SHIFT_CONST(16)
#define SNOR_TIMING1_0_WE_WIDTH_FIELD                   (_MK_MASK_CONST(0xff) << SNOR_TIMING1_0_WE_WIDTH_SHIFT)
#define SNOR_TIMING1_0_WE_WIDTH_RANGE                   23:16
#define SNOR_TIMING1_0_WE_WIDTH_WOFFSET                 0x0
#define SNOR_TIMING1_0_WE_WIDTH_DEFAULT                 _MK_MASK_CONST(0x1)
#define SNOR_TIMING1_0_WE_WIDTH_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define SNOR_TIMING1_0_WE_WIDTH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SNOR_TIMING1_0_WE_WIDTH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Read access time.
#define SNOR_TIMING1_0_OE_WIDTH_SHIFT                   _MK_SHIFT_CONST(8)
#define SNOR_TIMING1_0_OE_WIDTH_FIELD                   (_MK_MASK_CONST(0xff) << SNOR_TIMING1_0_OE_WIDTH_SHIFT)
#define SNOR_TIMING1_0_OE_WIDTH_RANGE                   15:8
#define SNOR_TIMING1_0_OE_WIDTH_WOFFSET                 0x0
#define SNOR_TIMING1_0_OE_WIDTH_DEFAULT                 _MK_MASK_CONST(0x1)
#define SNOR_TIMING1_0_OE_WIDTH_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define SNOR_TIMING1_0_OE_WIDTH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SNOR_TIMING1_0_OE_WIDTH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Indicates in cycles the number of wait states before when READY is issued.
#define SNOR_TIMING1_0_WAIT_WIDTH_SHIFT                 _MK_SHIFT_CONST(0)
#define SNOR_TIMING1_0_WAIT_WIDTH_FIELD                 (_MK_MASK_CONST(0xff) << SNOR_TIMING1_0_WAIT_WIDTH_SHIFT)
#define SNOR_TIMING1_0_WAIT_WIDTH_RANGE                 7:0
#define SNOR_TIMING1_0_WAIT_WIDTH_WOFFSET                       0x0
#define SNOR_TIMING1_0_WAIT_WIDTH_DEFAULT                       _MK_MASK_CONST(0x3)
#define SNOR_TIMING1_0_WAIT_WIDTH_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define SNOR_TIMING1_0_WAIT_WIDTH_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_TIMING1_0_WAIT_WIDTH_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register SNOR_MIO_CFG_0  
#define SNOR_MIO_CFG_0                  _MK_ADDR_CONST(0x18)
#define SNOR_MIO_CFG_0_SECURE                   0x0
#define SNOR_MIO_CFG_0_WORD_COUNT                       0x1
#define SNOR_MIO_CFG_0_RESET_VAL                        _MK_MASK_CONST(0x10700000)
#define SNOR_MIO_CFG_0_RESET_MASK                       _MK_MASK_CONST(0x30700000)
#define SNOR_MIO_CFG_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define SNOR_MIO_CFG_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SNOR_MIO_CFG_0_READ_MASK                        _MK_MASK_CONST(0x30700000)
#define SNOR_MIO_CFG_0_WRITE_MASK                       _MK_MASK_CONST(0x30700000)
// Indicates the databus size of MIO Memory.
#define SNOR_MIO_CFG_0_MIO_WORDWIDE_SHIFT                       _MK_SHIFT_CONST(29)
#define SNOR_MIO_CFG_0_MIO_WORDWIDE_FIELD                       (_MK_MASK_CONST(0x1) << SNOR_MIO_CFG_0_MIO_WORDWIDE_SHIFT)
#define SNOR_MIO_CFG_0_MIO_WORDWIDE_RANGE                       29:29
#define SNOR_MIO_CFG_0_MIO_WORDWIDE_WOFFSET                     0x0
#define SNOR_MIO_CFG_0_MIO_WORDWIDE_DEFAULT                     _MK_MASK_CONST(0x0)
#define SNOR_MIO_CFG_0_MIO_WORDWIDE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SNOR_MIO_CFG_0_MIO_WORDWIDE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SNOR_MIO_CFG_0_MIO_WORDWIDE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define SNOR_MIO_CFG_0_MIO_WORDWIDE_MIO16BIT                    _MK_ENUM_CONST(0)
#define SNOR_MIO_CFG_0_MIO_WORDWIDE_MIO32BIT                    _MK_ENUM_CONST(1)

// Specifies the polarity of MIO RDY.
#define SNOR_MIO_CFG_0_MIO_RDY_POL_SHIFT                        _MK_SHIFT_CONST(28)
#define SNOR_MIO_CFG_0_MIO_RDY_POL_FIELD                        (_MK_MASK_CONST(0x1) << SNOR_MIO_CFG_0_MIO_RDY_POL_SHIFT)
#define SNOR_MIO_CFG_0_MIO_RDY_POL_RANGE                        28:28
#define SNOR_MIO_CFG_0_MIO_RDY_POL_WOFFSET                      0x0
#define SNOR_MIO_CFG_0_MIO_RDY_POL_DEFAULT                      _MK_MASK_CONST(0x1)
#define SNOR_MIO_CFG_0_MIO_RDY_POL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SNOR_MIO_CFG_0_MIO_RDY_POL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_MIO_CFG_0_MIO_RDY_POL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SNOR_MIO_CFG_0_MIO_RDY_POL_RESV                 _MK_ENUM_CONST(0)
#define SNOR_MIO_CFG_0_MIO_RDY_POL_HIGH                 _MK_ENUM_CONST(1)

// MIO 8 chip selects combinations.
#define SNOR_MIO_CFG_0_MIO_SEL_SHIFT                    _MK_SHIFT_CONST(20)
#define SNOR_MIO_CFG_0_MIO_SEL_FIELD                    (_MK_MASK_CONST(0x7) << SNOR_MIO_CFG_0_MIO_SEL_SHIFT)
#define SNOR_MIO_CFG_0_MIO_SEL_RANGE                    22:20
#define SNOR_MIO_CFG_0_MIO_SEL_WOFFSET                  0x0
#define SNOR_MIO_CFG_0_MIO_SEL_DEFAULT                  _MK_MASK_CONST(0x7)
#define SNOR_MIO_CFG_0_MIO_SEL_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define SNOR_MIO_CFG_0_MIO_SEL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SNOR_MIO_CFG_0_MIO_SEL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SNOR_MIO_CFG_0_MIO_SEL_MIO0                     _MK_ENUM_CONST(0)
#define SNOR_MIO_CFG_0_MIO_SEL_MIO1                     _MK_ENUM_CONST(1)
#define SNOR_MIO_CFG_0_MIO_SEL_MIO2                     _MK_ENUM_CONST(2)
#define SNOR_MIO_CFG_0_MIO_SEL_MIO3                     _MK_ENUM_CONST(3)
#define SNOR_MIO_CFG_0_MIO_SEL_MIO4                     _MK_ENUM_CONST(4)
#define SNOR_MIO_CFG_0_MIO_SEL_MIO5                     _MK_ENUM_CONST(5)
#define SNOR_MIO_CFG_0_MIO_SEL_MIO6                     _MK_ENUM_CONST(6)
#define SNOR_MIO_CFG_0_MIO_SEL_MIO7                     _MK_ENUM_CONST(7)


// Register SNOR_MIO_TIMING0_0  
#define SNOR_MIO_TIMING0_0                      _MK_ADDR_CONST(0x1c)
#define SNOR_MIO_TIMING0_0_SECURE                       0x0
#define SNOR_MIO_TIMING0_0_WORD_COUNT                   0x1
#define SNOR_MIO_TIMING0_0_RESET_VAL                    _MK_MASK_CONST(0x1020102)
#define SNOR_MIO_TIMING0_0_RESET_MASK                   _MK_MASK_CONST(0x3f3f3f3f)
#define SNOR_MIO_TIMING0_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define SNOR_MIO_TIMING0_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SNOR_MIO_TIMING0_0_READ_MASK                    _MK_MASK_CONST(0x3f3f3f3f)
#define SNOR_MIO_TIMING0_0_WRITE_MASK                   _MK_MASK_CONST(0x3f3f3f3f)
// Minimum number of MIO bus clock cycles between the end of a write access 
// and the start of the following access (write or read) for MIO.
#define SNOR_MIO_TIMING0_0_MIO_A_DED_WR_SHIFT                   _MK_SHIFT_CONST(24)
#define SNOR_MIO_TIMING0_0_MIO_A_DED_WR_FIELD                   (_MK_MASK_CONST(0x3f) << SNOR_MIO_TIMING0_0_MIO_A_DED_WR_SHIFT)
#define SNOR_MIO_TIMING0_0_MIO_A_DED_WR_RANGE                   29:24
#define SNOR_MIO_TIMING0_0_MIO_A_DED_WR_WOFFSET                 0x0
#define SNOR_MIO_TIMING0_0_MIO_A_DED_WR_DEFAULT                 _MK_MASK_CONST(0x1)
#define SNOR_MIO_TIMING0_0_MIO_A_DED_WR_DEFAULT_MASK                    _MK_MASK_CONST(0x3f)
#define SNOR_MIO_TIMING0_0_MIO_A_DED_WR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SNOR_MIO_TIMING0_0_MIO_A_DED_WR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Minimum number of MIO bus clock cycles during a write access that the MIO_RD
// signal is set low for MIO.
#define SNOR_MIO_TIMING0_0_MIO_A_WR_TIME_SHIFT                  _MK_SHIFT_CONST(16)
#define SNOR_MIO_TIMING0_0_MIO_A_WR_TIME_FIELD                  (_MK_MASK_CONST(0x3f) << SNOR_MIO_TIMING0_0_MIO_A_WR_TIME_SHIFT)
#define SNOR_MIO_TIMING0_0_MIO_A_WR_TIME_RANGE                  21:16
#define SNOR_MIO_TIMING0_0_MIO_A_WR_TIME_WOFFSET                        0x0
#define SNOR_MIO_TIMING0_0_MIO_A_WR_TIME_DEFAULT                        _MK_MASK_CONST(0x2)
#define SNOR_MIO_TIMING0_0_MIO_A_WR_TIME_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define SNOR_MIO_TIMING0_0_MIO_A_WR_TIME_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SNOR_MIO_TIMING0_0_MIO_A_WR_TIME_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Minimum number of MIO bus clock cycles between the end of a read access 
// and the start of the following access (write or read) for MIO.
#define SNOR_MIO_TIMING0_0_MIO_A_DED_RD_SHIFT                   _MK_SHIFT_CONST(8)
#define SNOR_MIO_TIMING0_0_MIO_A_DED_RD_FIELD                   (_MK_MASK_CONST(0x3f) << SNOR_MIO_TIMING0_0_MIO_A_DED_RD_SHIFT)
#define SNOR_MIO_TIMING0_0_MIO_A_DED_RD_RANGE                   13:8
#define SNOR_MIO_TIMING0_0_MIO_A_DED_RD_WOFFSET                 0x0
#define SNOR_MIO_TIMING0_0_MIO_A_DED_RD_DEFAULT                 _MK_MASK_CONST(0x1)
#define SNOR_MIO_TIMING0_0_MIO_A_DED_RD_DEFAULT_MASK                    _MK_MASK_CONST(0x3f)
#define SNOR_MIO_TIMING0_0_MIO_A_DED_RD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SNOR_MIO_TIMING0_0_MIO_A_DED_RD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Minimum number of MIO bus clock cycles during a read access that the MIO_RD
// signal is set low for MIO.
#define SNOR_MIO_TIMING0_0_MIO_A_RD_TIME_SHIFT                  _MK_SHIFT_CONST(0)
#define SNOR_MIO_TIMING0_0_MIO_A_RD_TIME_FIELD                  (_MK_MASK_CONST(0x3f) << SNOR_MIO_TIMING0_0_MIO_A_RD_TIME_SHIFT)
#define SNOR_MIO_TIMING0_0_MIO_A_RD_TIME_RANGE                  5:0
#define SNOR_MIO_TIMING0_0_MIO_A_RD_TIME_WOFFSET                        0x0
#define SNOR_MIO_TIMING0_0_MIO_A_RD_TIME_DEFAULT                        _MK_MASK_CONST(0x2)
#define SNOR_MIO_TIMING0_0_MIO_A_RD_TIME_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define SNOR_MIO_TIMING0_0_MIO_A_RD_TIME_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SNOR_MIO_TIMING0_0_MIO_A_RD_TIME_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register SNOR_DMA_CFG_0  
#define SNOR_DMA_CFG_0                  _MK_ADDR_CONST(0x20)
#define SNOR_DMA_CFG_0_SECURE                   0x0
#define SNOR_DMA_CFG_0_WORD_COUNT                       0x1
#define SNOR_DMA_CFG_0_RESET_VAL                        _MK_MASK_CONST(0x4000000)
#define SNOR_DMA_CFG_0_RESET_MASK                       _MK_MASK_CONST(0xff00fffc)
#define SNOR_DMA_CFG_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_READ_MASK                        _MK_MASK_CONST(0xff00fffc)
#define SNOR_DMA_CFG_0_WRITE_MASK                       _MK_MASK_CONST(0xff00fffc)
// This represents the number of DMA is enabled.
#define SNOR_DMA_CFG_0_DMA_GO_SHIFT                     _MK_SHIFT_CONST(31)
#define SNOR_DMA_CFG_0_DMA_GO_FIELD                     (_MK_MASK_CONST(0x1) << SNOR_DMA_CFG_0_DMA_GO_SHIFT)
#define SNOR_DMA_CFG_0_DMA_GO_RANGE                     31:31
#define SNOR_DMA_CFG_0_DMA_GO_WOFFSET                   0x0
#define SNOR_DMA_CFG_0_DMA_GO_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_DMA_GO_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SNOR_DMA_CFG_0_DMA_GO_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_DMA_GO_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_DMA_GO_DISABLE                   _MK_ENUM_CONST(0)
#define SNOR_DMA_CFG_0_DMA_GO_ENABLE                    _MK_ENUM_CONST(1)

// Indicates the status of DMA.
#define SNOR_DMA_CFG_0_BSY_SHIFT                        _MK_SHIFT_CONST(30)
#define SNOR_DMA_CFG_0_BSY_FIELD                        (_MK_MASK_CONST(0x1) << SNOR_DMA_CFG_0_BSY_SHIFT)
#define SNOR_DMA_CFG_0_BSY_RANGE                        30:30
#define SNOR_DMA_CFG_0_BSY_WOFFSET                      0x0
#define SNOR_DMA_CFG_0_BSY_DEFAULT                      _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_BSY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SNOR_DMA_CFG_0_BSY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_BSY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// This represents the  the direction of DMA data Transfer.
#define SNOR_DMA_CFG_0_DIR_SHIFT                        _MK_SHIFT_CONST(29)
#define SNOR_DMA_CFG_0_DIR_FIELD                        (_MK_MASK_CONST(0x1) << SNOR_DMA_CFG_0_DIR_SHIFT)
#define SNOR_DMA_CFG_0_DIR_RANGE                        29:29
#define SNOR_DMA_CFG_0_DIR_WOFFSET                      0x0
#define SNOR_DMA_CFG_0_DIR_DEFAULT                      _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_DIR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SNOR_DMA_CFG_0_DIR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_DIR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_DIR_NOR2AHB                      _MK_ENUM_CONST(0)
#define SNOR_DMA_CFG_0_DIR_AHB2NOR                      _MK_ENUM_CONST(1)

// Interrupt Enable on DMA transfer completion.
#define SNOR_DMA_CFG_0_IE_DMA_DONE_SHIFT                        _MK_SHIFT_CONST(28)
#define SNOR_DMA_CFG_0_IE_DMA_DONE_FIELD                        (_MK_MASK_CONST(0x1) << SNOR_DMA_CFG_0_IE_DMA_DONE_SHIFT)
#define SNOR_DMA_CFG_0_IE_DMA_DONE_RANGE                        28:28
#define SNOR_DMA_CFG_0_IE_DMA_DONE_WOFFSET                      0x0
#define SNOR_DMA_CFG_0_IE_DMA_DONE_DEFAULT                      _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_IE_DMA_DONE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SNOR_DMA_CFG_0_IE_DMA_DONE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_IE_DMA_DONE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_IE_DMA_DONE_DISABLE                      _MK_ENUM_CONST(0)
#define SNOR_DMA_CFG_0_IE_DMA_DONE_ENABLE                       _MK_ENUM_CONST(1)

// Interrupt Status (Write 1 to clear).
#define SNOR_DMA_CFG_0_IS_DMA_DONE_SHIFT                        _MK_SHIFT_CONST(27)
#define SNOR_DMA_CFG_0_IS_DMA_DONE_FIELD                        (_MK_MASK_CONST(0x1) << SNOR_DMA_CFG_0_IS_DMA_DONE_SHIFT)
#define SNOR_DMA_CFG_0_IS_DMA_DONE_RANGE                        27:27
#define SNOR_DMA_CFG_0_IS_DMA_DONE_WOFFSET                      0x0
#define SNOR_DMA_CFG_0_IS_DMA_DONE_DEFAULT                      _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_IS_DMA_DONE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SNOR_DMA_CFG_0_IS_DMA_DONE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_IS_DMA_DONE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_IS_DMA_DONE_DISABLE                      _MK_ENUM_CONST(0)
#define SNOR_DMA_CFG_0_IS_DMA_DONE_ENABLE                       _MK_ENUM_CONST(1)

// DMA burst size.
#define SNOR_DMA_CFG_0_BURST_SIZE_SHIFT                 _MK_SHIFT_CONST(24)
#define SNOR_DMA_CFG_0_BURST_SIZE_FIELD                 (_MK_MASK_CONST(0x7) << SNOR_DMA_CFG_0_BURST_SIZE_SHIFT)
#define SNOR_DMA_CFG_0_BURST_SIZE_RANGE                 26:24
#define SNOR_DMA_CFG_0_BURST_SIZE_WOFFSET                       0x0
#define SNOR_DMA_CFG_0_BURST_SIZE_DEFAULT                       _MK_MASK_CONST(0x4)
#define SNOR_DMA_CFG_0_BURST_SIZE_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define SNOR_DMA_CFG_0_BURST_SIZE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_BURST_SIZE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_BURST_SIZE_RESV0                 _MK_ENUM_CONST(0)
#define SNOR_DMA_CFG_0_BURST_SIZE_RESV1                 _MK_ENUM_CONST(1)
#define SNOR_DMA_CFG_0_BURST_SIZE_RESV2                 _MK_ENUM_CONST(2)
#define SNOR_DMA_CFG_0_BURST_SIZE_RESV3                 _MK_ENUM_CONST(3)
#define SNOR_DMA_CFG_0_BURST_SIZE_BS1WORD                       _MK_ENUM_CONST(4)
#define SNOR_DMA_CFG_0_BURST_SIZE_BS4WORD                       _MK_ENUM_CONST(5)
#define SNOR_DMA_CFG_0_BURST_SIZE_BS8WORD                       _MK_ENUM_CONST(6)
#define SNOR_DMA_CFG_0_BURST_SIZE_RESV7                 _MK_ENUM_CONST(7)

// Specifies the number of words that need to be transferred. 
#define SNOR_DMA_CFG_0_WORD_COUNT_SHIFT                 _MK_SHIFT_CONST(2)
#define SNOR_DMA_CFG_0_WORD_COUNT_FIELD                 (_MK_MASK_CONST(0x3fff) << SNOR_DMA_CFG_0_WORD_COUNT_SHIFT)
#define SNOR_DMA_CFG_0_WORD_COUNT_RANGE                 15:2
#define SNOR_DMA_CFG_0_WORD_COUNT_WOFFSET                       0x0
#define SNOR_DMA_CFG_0_WORD_COUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_WORD_COUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define SNOR_DMA_CFG_0_WORD_COUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_DMA_CFG_0_WORD_COUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register SNOR_CS_MUX_CFG_0  
#define SNOR_CS_MUX_CFG_0                       _MK_ADDR_CONST(0x24)
#define SNOR_CS_MUX_CFG_0_SECURE                        0x0
#define SNOR_CS_MUX_CFG_0_WORD_COUNT                    0x1
#define SNOR_CS_MUX_CFG_0_RESET_VAL                     _MK_MASK_CONST(0x76543210)
#define SNOR_CS_MUX_CFG_0_RESET_MASK                    _MK_MASK_CONST(0x77777777)
#define SNOR_CS_MUX_CFG_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define SNOR_CS_MUX_CFG_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SNOR_CS_MUX_CFG_0_READ_MASK                     _MK_MASK_CONST(0x77777777)
#define SNOR_CS_MUX_CFG_0_WRITE_MASK                    _MK_MASK_CONST(0x77777777)
// This represents the which chip selects goes to which memory. 
// Chip selection between SNOR and MIO Memories.
#define SNOR_CS_MUX_CFG_0_CS7_MUX_SHIFT                 _MK_SHIFT_CONST(28)
#define SNOR_CS_MUX_CFG_0_CS7_MUX_FIELD                 (_MK_MASK_CONST(0x7) << SNOR_CS_MUX_CFG_0_CS7_MUX_SHIFT)
#define SNOR_CS_MUX_CFG_0_CS7_MUX_RANGE                 30:28
#define SNOR_CS_MUX_CFG_0_CS7_MUX_WOFFSET                       0x0
#define SNOR_CS_MUX_CFG_0_CS7_MUX_DEFAULT                       _MK_MASK_CONST(0x7)
#define SNOR_CS_MUX_CFG_0_CS7_MUX_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define SNOR_CS_MUX_CFG_0_CS7_MUX_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_CS_MUX_CFG_0_CS7_MUX_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This represents the which chip selects goes to which memory. 
// Chip selection between SNOR and MIO Memories.
#define SNOR_CS_MUX_CFG_0_CS6_MUX_SHIFT                 _MK_SHIFT_CONST(24)
#define SNOR_CS_MUX_CFG_0_CS6_MUX_FIELD                 (_MK_MASK_CONST(0x7) << SNOR_CS_MUX_CFG_0_CS6_MUX_SHIFT)
#define SNOR_CS_MUX_CFG_0_CS6_MUX_RANGE                 26:24
#define SNOR_CS_MUX_CFG_0_CS6_MUX_WOFFSET                       0x0
#define SNOR_CS_MUX_CFG_0_CS6_MUX_DEFAULT                       _MK_MASK_CONST(0x6)
#define SNOR_CS_MUX_CFG_0_CS6_MUX_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define SNOR_CS_MUX_CFG_0_CS6_MUX_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_CS_MUX_CFG_0_CS6_MUX_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This represents the which chip selects goes to which memory. 
// Chip selection between SNOR and MIO Memories.
#define SNOR_CS_MUX_CFG_0_CS5_MUX_SHIFT                 _MK_SHIFT_CONST(20)
#define SNOR_CS_MUX_CFG_0_CS5_MUX_FIELD                 (_MK_MASK_CONST(0x7) << SNOR_CS_MUX_CFG_0_CS5_MUX_SHIFT)
#define SNOR_CS_MUX_CFG_0_CS5_MUX_RANGE                 22:20
#define SNOR_CS_MUX_CFG_0_CS5_MUX_WOFFSET                       0x0
#define SNOR_CS_MUX_CFG_0_CS5_MUX_DEFAULT                       _MK_MASK_CONST(0x5)
#define SNOR_CS_MUX_CFG_0_CS5_MUX_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define SNOR_CS_MUX_CFG_0_CS5_MUX_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_CS_MUX_CFG_0_CS5_MUX_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This represents the which chip selects goes to which memory. 
// Chip selection between SNOR and MIO Memories.
#define SNOR_CS_MUX_CFG_0_CS4_MUX_SHIFT                 _MK_SHIFT_CONST(16)
#define SNOR_CS_MUX_CFG_0_CS4_MUX_FIELD                 (_MK_MASK_CONST(0x7) << SNOR_CS_MUX_CFG_0_CS4_MUX_SHIFT)
#define SNOR_CS_MUX_CFG_0_CS4_MUX_RANGE                 18:16
#define SNOR_CS_MUX_CFG_0_CS4_MUX_WOFFSET                       0x0
#define SNOR_CS_MUX_CFG_0_CS4_MUX_DEFAULT                       _MK_MASK_CONST(0x4)
#define SNOR_CS_MUX_CFG_0_CS4_MUX_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define SNOR_CS_MUX_CFG_0_CS4_MUX_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_CS_MUX_CFG_0_CS4_MUX_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This represents the which chip selects goes to which memory. 
// Chip selection between SNOR and MIO Memories.
#define SNOR_CS_MUX_CFG_0_CS3_MUX_SHIFT                 _MK_SHIFT_CONST(12)
#define SNOR_CS_MUX_CFG_0_CS3_MUX_FIELD                 (_MK_MASK_CONST(0x7) << SNOR_CS_MUX_CFG_0_CS3_MUX_SHIFT)
#define SNOR_CS_MUX_CFG_0_CS3_MUX_RANGE                 14:12
#define SNOR_CS_MUX_CFG_0_CS3_MUX_WOFFSET                       0x0
#define SNOR_CS_MUX_CFG_0_CS3_MUX_DEFAULT                       _MK_MASK_CONST(0x3)
#define SNOR_CS_MUX_CFG_0_CS3_MUX_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define SNOR_CS_MUX_CFG_0_CS3_MUX_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_CS_MUX_CFG_0_CS3_MUX_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This represents the which chip selects goes to which memory. 
// Chip selection between SNOR and MIO Memories.
#define SNOR_CS_MUX_CFG_0_CS2_MUX_SHIFT                 _MK_SHIFT_CONST(8)
#define SNOR_CS_MUX_CFG_0_CS2_MUX_FIELD                 (_MK_MASK_CONST(0x7) << SNOR_CS_MUX_CFG_0_CS2_MUX_SHIFT)
#define SNOR_CS_MUX_CFG_0_CS2_MUX_RANGE                 10:8
#define SNOR_CS_MUX_CFG_0_CS2_MUX_WOFFSET                       0x0
#define SNOR_CS_MUX_CFG_0_CS2_MUX_DEFAULT                       _MK_MASK_CONST(0x2)
#define SNOR_CS_MUX_CFG_0_CS2_MUX_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define SNOR_CS_MUX_CFG_0_CS2_MUX_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_CS_MUX_CFG_0_CS2_MUX_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This represents the which chip selects goes to which memory. 
// Chip selection between SNOR and MIO Memories.
#define SNOR_CS_MUX_CFG_0_CS1_MUX_SHIFT                 _MK_SHIFT_CONST(4)
#define SNOR_CS_MUX_CFG_0_CS1_MUX_FIELD                 (_MK_MASK_CONST(0x7) << SNOR_CS_MUX_CFG_0_CS1_MUX_SHIFT)
#define SNOR_CS_MUX_CFG_0_CS1_MUX_RANGE                 6:4
#define SNOR_CS_MUX_CFG_0_CS1_MUX_WOFFSET                       0x0
#define SNOR_CS_MUX_CFG_0_CS1_MUX_DEFAULT                       _MK_MASK_CONST(0x1)
#define SNOR_CS_MUX_CFG_0_CS1_MUX_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define SNOR_CS_MUX_CFG_0_CS1_MUX_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_CS_MUX_CFG_0_CS1_MUX_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This represents the which chip selects goes to which memory. 
// Chip selection between SNOR and MIO Memories.
#define SNOR_CS_MUX_CFG_0_CS0_MUX_SHIFT                 _MK_SHIFT_CONST(0)
#define SNOR_CS_MUX_CFG_0_CS0_MUX_FIELD                 (_MK_MASK_CONST(0x7) << SNOR_CS_MUX_CFG_0_CS0_MUX_SHIFT)
#define SNOR_CS_MUX_CFG_0_CS0_MUX_RANGE                 2:0
#define SNOR_CS_MUX_CFG_0_CS0_MUX_WOFFSET                       0x0
#define SNOR_CS_MUX_CFG_0_CS0_MUX_DEFAULT                       _MK_MASK_CONST(0x0)
#define SNOR_CS_MUX_CFG_0_CS0_MUX_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define SNOR_CS_MUX_CFG_0_CS0_MUX_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SNOR_CS_MUX_CFG_0_CS0_MUX_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_ARSNOR_REGS(_op_) \
_op_(SNOR_CONFIG_0) \
_op_(SNOR_STA_0) \
_op_(SNOR_NOR_ADDR_PTR_0) \
_op_(SNOR_AHB_ADDR_PTR_0) \
_op_(SNOR_TIMING0_0) \
_op_(SNOR_TIMING1_0) \
_op_(SNOR_MIO_CFG_0) \
_op_(SNOR_MIO_TIMING0_0) \
_op_(SNOR_DMA_CFG_0) \
_op_(SNOR_CS_MUX_CFG_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_SNOR       0x00000000

//
// ARSNOR REGISTER BANKS
//

#define SNOR0_FIRST_REG 0x0000 // SNOR_CONFIG_0
#define SNOR0_LAST_REG 0x0024 // SNOR_CS_MUX_CFG_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARSNOR_H_INC_
