/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARUSB_H_INC_
#define ___ARUSB_H_INC_

// Register USB2_CONTROLLER_USB2D_ID_0  
#define USB2_CONTROLLER_USB2D_ID_0                      _MK_ADDR_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ID_0_SECURE                       0x0
#define USB2_CONTROLLER_USB2D_ID_0_WORD_COUNT                   0x1
#define USB2_CONTROLLER_USB2D_ID_0_RESET_VAL                    _MK_MASK_CONST(0x33fa05)
#define USB2_CONTROLLER_USB2D_ID_0_RESET_MASK                   _MK_MASK_CONST(0xffffff)
#define USB2_CONTROLLER_USB2D_ID_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ID_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ID_0_READ_MASK                    _MK_MASK_CONST(0xffffff)
#define USB2_CONTROLLER_USB2D_ID_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
// Revision number of the USB controller. This is set  to 0x33.
#define USB2_CONTROLLER_USB2D_ID_0_REVISION_SHIFT                       _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ID_0_REVISION_FIELD                       (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_ID_0_REVISION_SHIFT)
#define USB2_CONTROLLER_USB2D_ID_0_REVISION_RANGE                       23:16
#define USB2_CONTROLLER_USB2D_ID_0_REVISION_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ID_0_REVISION_DEFAULT                     _MK_MASK_CONST(0x33)
#define USB2_CONTROLLER_USB2D_ID_0_REVISION_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define USB2_CONTROLLER_USB2D_ID_0_REVISION_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ID_0_REVISION_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Ones complement version of ID. This field is set  to 0xFA.
#define USB2_CONTROLLER_USB2D_ID_0_NID_SHIFT                    _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_ID_0_NID_FIELD                    (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_ID_0_NID_SHIFT)
#define USB2_CONTROLLER_USB2D_ID_0_NID_RANGE                    15:8
#define USB2_CONTROLLER_USB2D_ID_0_NID_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ID_0_NID_DEFAULT                  _MK_MASK_CONST(0xfa)
#define USB2_CONTROLLER_USB2D_ID_0_NID_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define USB2_CONTROLLER_USB2D_ID_0_NID_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ID_0_NID_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Configuration number. This field is set to 0x05
#define USB2_CONTROLLER_USB2D_ID_0_ID_SHIFT                     _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ID_0_ID_FIELD                     (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_ID_0_ID_SHIFT)
#define USB2_CONTROLLER_USB2D_ID_0_ID_RANGE                     7:0
#define USB2_CONTROLLER_USB2D_ID_0_ID_WOFFSET                   0x0
#define USB2_CONTROLLER_USB2D_ID_0_ID_DEFAULT                   _MK_MASK_CONST(0x5)
#define USB2_CONTROLLER_USB2D_ID_0_ID_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define USB2_CONTROLLER_USB2D_ID_0_ID_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ID_0_ID_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register USB2_CONTROLLER_USB2D_HW_GENERAL_0  
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0                      _MK_ADDR_CONST(0x4)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_SECURE                       0x0
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_WORD_COUNT                   0x1
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_RESET_VAL                    _MK_MASK_CONST(0x35)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_RESET_MASK                   _MK_MASK_CONST(0x1f7)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_READ_MASK                    _MK_MASK_CONST(0x1f7)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
// VUSB_HS_PHY_MODE : set to 0 for UTMI PHY
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYM_SHIFT                   _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYM_FIELD                   (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYM_SHIFT)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYM_RANGE                   8:6
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYM_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYM_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYM_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYM_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYM_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// VUSB_HS_PHY16_8 : Width of the UTMI parallel  interface. Set to 3 : 16-bit UTMI parallel interface software programmable to  8-bit
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYW_SHIFT                   _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYW_FIELD                   (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYW_SHIFT)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYW_RANGE                   5:4
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYW_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYW_DEFAULT                 _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYW_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYW_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_PHYW_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// VUSB_HS_CLOCK_CONFIGURATION : Clock configuration  2 selected
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_CLKC_SHIFT                   _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_CLKC_FIELD                   (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HW_GENERAL_0_CLKC_SHIFT)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_CLKC_RANGE                   2:1
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_CLKC_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_CLKC_DEFAULT                 _MK_MASK_CONST(0x2)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_CLKC_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_CLKC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_CLKC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// VUSB_HS_RESET_TYPE : set to 1 = asynchronous reset
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_RT_SHIFT                     _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_RT_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HW_GENERAL_0_RT_SHIFT)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_RT_RANGE                     0:0
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_RT_WOFFSET                   0x0
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_RT_DEFAULT                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_RT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_RT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_GENERAL_0_RT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register USB2_CONTROLLER_USB2D_HW_HOST_0  
#define USB2_CONTROLLER_USB2D_HW_HOST_0                 _MK_ADDR_CONST(0x8)
#define USB2_CONTROLLER_USB2D_HW_HOST_0_SECURE                  0x0
#define USB2_CONTROLLER_USB2D_HW_HOST_0_WORD_COUNT                      0x1
#define USB2_CONTROLLER_USB2D_HW_HOST_0_RESET_VAL                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_HW_HOST_0_RESET_MASK                      _MK_MASK_CONST(0xf)
#define USB2_CONTROLLER_USB2D_HW_HOST_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_HOST_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_HOST_0_READ_MASK                       _MK_MASK_CONST(0xf)
#define USB2_CONTROLLER_USB2D_HW_HOST_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
// VUSB_HS_NUM_PORT-1: This host controller has only  1 port. So this field will always be 0.
#define USB2_CONTROLLER_USB2D_HW_HOST_0_NPORT_SHIFT                     _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HW_HOST_0_NPORT_FIELD                     (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_HW_HOST_0_NPORT_SHIFT)
#define USB2_CONTROLLER_USB2D_HW_HOST_0_NPORT_RANGE                     3:1
#define USB2_CONTROLLER_USB2D_HW_HOST_0_NPORT_WOFFSET                   0x0
#define USB2_CONTROLLER_USB2D_HW_HOST_0_NPORT_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_HOST_0_NPORT_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define USB2_CONTROLLER_USB2D_HW_HOST_0_NPORT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_HOST_0_NPORT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// VUSB_HS_HOST: Indicates support for host mode. Set  to 1.
#define USB2_CONTROLLER_USB2D_HW_HOST_0_HC_SHIFT                        _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HW_HOST_0_HC_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HW_HOST_0_HC_SHIFT)
#define USB2_CONTROLLER_USB2D_HW_HOST_0_HC_RANGE                        0:0
#define USB2_CONTROLLER_USB2D_HW_HOST_0_HC_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_HW_HOST_0_HC_DEFAULT                      _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_HW_HOST_0_HC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_HW_HOST_0_HC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_HOST_0_HC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register USB2_CONTROLLER_USB2D_HW_DEVICE_0  
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0                       _MK_ADDR_CONST(0xc)
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_SECURE                        0x0
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_WORD_COUNT                    0x1
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_RESET_VAL                     _MK_MASK_CONST(0x21)
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_RESET_MASK                    _MK_MASK_CONST(0x3f)
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_READ_MASK                     _MK_MASK_CONST(0x3f)
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// VUSB_HS_DV_EP: No. of endpoints supported by this device controller. Set to 16. This includes control endpoint 0.
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_DEVEP_SHIFT                   _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_DEVEP_FIELD                   (_MK_MASK_CONST(0x1f) << USB2_CONTROLLER_USB2D_HW_DEVICE_0_DEVEP_SHIFT)
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_DEVEP_RANGE                   5:1
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_DEVEP_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_DEVEP_DEFAULT                 _MK_MASK_CONST(0x10)
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_DEVEP_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_DEVEP_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_DEVEP_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Device capable: Set to 1 indicating support for device mode.
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_DC_SHIFT                      _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_DC_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HW_DEVICE_0_DC_SHIFT)
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_DC_RANGE                      0:0
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_DC_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_DC_DEFAULT                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_DC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_DC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_DEVICE_0_DC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register USB2_CONTROLLER_USB2D_HW_TXBUF_0  
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0                        _MK_ADDR_CONST(0x10)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_SECURE                         0x0
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_WORD_COUNT                     0x1
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_RESET_VAL                      _MK_MASK_CONST(0x70b08)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_RESET_MASK                     _MK_MASK_CONST(0xffffff)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_READ_MASK                      _MK_MASK_CONST(0xffffff)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
// VUSB_HS_TX_CHAN_ADD: Total no. of address bits for the transmit buffer of each transmit endpoint. Set to 7. Each transmit buffer is 128 words deep.
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXCHANADD_SHIFT                        _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXCHANADD_FIELD                        (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXCHANADD_SHIFT)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXCHANADD_RANGE                        23:16
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXCHANADD_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXCHANADD_DEFAULT                      _MK_MASK_CONST(0x7)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXCHANADD_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXCHANADD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXCHANADD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// VUSB_HS_TX_ADD: Total no. of address bits for the transmit buffer. Set to 11. The total depth of the transmit buffer is 2048 words.
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXADD_SHIFT                    _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXADD_FIELD                    (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXADD_SHIFT)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXADD_RANGE                    15:8
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXADD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXADD_DEFAULT                  _MK_MASK_CONST(0xb)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXADD_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXADD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TXADD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// VUSB_HS_TX_BURST: Maximum burst size supported by the transmit endpoints for data transfers. Set to 8.
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TCBURST_SHIFT                  _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TCBURST_FIELD                  (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_HW_TXBUF_0_TCBURST_SHIFT)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TCBURST_RANGE                  7:0
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TCBURST_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TCBURST_DEFAULT                        _MK_MASK_CONST(0x8)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TCBURST_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TCBURST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_TXBUF_0_TCBURST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register USB2_CONTROLLER_USB2D_HW_RXBUF_0  
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0                        _MK_ADDR_CONST(0x14)
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_SECURE                         0x0
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_WORD_COUNT                     0x1
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RESET_VAL                      _MK_MASK_CONST(0x708)
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RESET_MASK                     _MK_MASK_CONST(0xffff)
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_READ_MASK                      _MK_MASK_CONST(0xffff)
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
// VUSB_HS_RX_ADD: Total no. of address bits for the receive buffer. Set to 7. The total depth of the receive buffer is 128 words
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXADD_SHIFT                    _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXADD_FIELD                    (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXADD_SHIFT)
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXADD_RANGE                    15:8
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXADD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXADD_DEFAULT                  _MK_MASK_CONST(0x7)
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXADD_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXADD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXADD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// VUSB_HS_RX_BURST: Maximum burst size supported by the receive endpoints for data transfers. Set to 8.
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXBURST_SHIFT                  _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXBURST_FIELD                  (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXBURST_SHIFT)
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXBURST_RANGE                  7:0
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXBURST_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXBURST_DEFAULT                        _MK_MASK_CONST(0x8)
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXBURST_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXBURST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HW_RXBUF_0_RXBURST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register USB2_CONTROLLER_USB2D_CAPLENGTH_0  
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0                       _MK_ADDR_CONST(0x100)
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0_SECURE                        0x0
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0_WORD_COUNT                    0x1
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0_RESET_VAL                     _MK_MASK_CONST(0x40)
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0_RESET_MASK                    _MK_MASK_CONST(0xff)
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Indicates which offset to add to the register base address at the beginning of the Operational Register. Set to 0x40.
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0_CAPLENGTH_SHIFT                       _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0_CAPLENGTH_FIELD                       (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_CAPLENGTH_0_CAPLENGTH_SHIFT)
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0_CAPLENGTH_RANGE                       7:0
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0_CAPLENGTH_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0_CAPLENGTH_DEFAULT                     _MK_MASK_CONST(0x40)
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0_CAPLENGTH_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0_CAPLENGTH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_CAPLENGTH_0_CAPLENGTH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register USB2_CONTROLLER_USB2D_HCIVERSON_0  
#define USB2_CONTROLLER_USB2D_HCIVERSON_0                       _MK_ADDR_CONST(0x102)
#define USB2_CONTROLLER_USB2D_HCIVERSON_0_SECURE                        0x0
#define USB2_CONTROLLER_USB2D_HCIVERSON_0_WORD_COUNT                    0x1
#define USB2_CONTROLLER_USB2D_HCIVERSON_0_RESET_VAL                     _MK_MASK_CONST(0x100)
#define USB2_CONTROLLER_USB2D_HCIVERSON_0_RESET_MASK                    _MK_MASK_CONST(0xffff)
#define USB2_CONTROLLER_USB2D_HCIVERSON_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCIVERSON_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCIVERSON_0_READ_MASK                     _MK_MASK_CONST(0xffff)
#define USB2_CONTROLLER_USB2D_HCIVERSON_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Contains a BCD encoding of the EHCI revision number supported by this host controller. The most significant byte of this register represents a major revision and the least significant byte is the minor revision. This host controller supports EHCI revision 1.00.
#define USB2_CONTROLLER_USB2D_HCIVERSON_0_HCIVERSION_SHIFT                      _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HCIVERSON_0_HCIVERSION_FIELD                      (_MK_MASK_CONST(0xffff) << USB2_CONTROLLER_USB2D_HCIVERSON_0_HCIVERSION_SHIFT)
#define USB2_CONTROLLER_USB2D_HCIVERSON_0_HCIVERSION_RANGE                      15:0
#define USB2_CONTROLLER_USB2D_HCIVERSON_0_HCIVERSION_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_HCIVERSON_0_HCIVERSION_DEFAULT                    _MK_MASK_CONST(0x100)
#define USB2_CONTROLLER_USB2D_HCIVERSON_0_HCIVERSION_DEFAULT_MASK                       _MK_MASK_CONST(0xffff)
#define USB2_CONTROLLER_USB2D_HCIVERSON_0_HCIVERSION_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCIVERSON_0_HCIVERSION_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register USB2_CONTROLLER_USB2D_HCSPARAMS_0  
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0                       _MK_ADDR_CONST(0x104)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_SECURE                        0x0
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_WORD_COUNT                    0x1
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_RESET_VAL                     _MK_MASK_CONST(0x1100011)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_RESET_MASK                    _MK_MASK_CONST(0xff0ff1f)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_READ_MASK                     _MK_MASK_CONST(0xff0ff1f)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Number of Transaction Translators: indicates the number of embedded transaction translators associated with the USB2.0 host controller. This field is always set to 1 indicating only 1 embedded TT is implemented in this implementation. This is a non-EHCI field to support embedded TT.
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_TT_SHIFT                    _MK_SHIFT_CONST(24)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_TT_FIELD                    (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_TT_SHIFT)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_TT_RANGE                    27:24
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_TT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_TT_DEFAULT                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_TT_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_TT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_TT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Number of Ports per Transaction Translator: indicates the number of ports assigned to each transaction translator within the USB2.0 host controller. Field always equals N_PORTS. This is a non-EHCI field to support embedded TT.
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PTT_SHIFT                   _MK_SHIFT_CONST(20)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PTT_FIELD                   (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PTT_SHIFT)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PTT_RANGE                   23:20
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PTT_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PTT_DEFAULT                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PTT_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PTT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PTT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Number of Companion Controller: indicates the number of companion controllers. This field is set to 0.
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_CC_SHIFT                    _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_CC_FIELD                    (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_CC_SHIFT)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_CC_RANGE                    15:12
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_CC_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_CC_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_CC_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_CC_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_CC_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Number of Ports per Companion Controller: indicates the number of ports supported per internal companion controller. This field is set to 0.
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PCC_SHIFT                   _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PCC_FIELD                   (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PCC_SHIFT)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PCC_RANGE                   11:8
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PCC_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PCC_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PCC_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PCC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PCC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Port Power Control: indicates whether the host controller implementation includes port power control. 
// 1 = Ports have port power switches         0= Ports do not have port power switches.
// This field affects the functionality of the port Power field in each port status and control register. This field is set to 1.
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_PPC_SHIFT                     _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_PPC_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HCSPARAMS_0_PPC_SHIFT)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_PPC_RANGE                     4:4
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_PPC_WOFFSET                   0x0
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_PPC_DEFAULT                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_PPC_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_PPC_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_PPC_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Number of downstream ports. This field specifies the number of physical downstream ports implemented on this host controller. This field is fixed to 1, since this host controller only supports 1 port.
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PORTS_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PORTS_FIELD                 (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PORTS_SHIFT)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PORTS_RANGE                 3:0
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PORTS_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PORTS_DEFAULT                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PORTS_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PORTS_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCSPARAMS_0_N_PORTS_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register USB2_CONTROLLER_USB2D_HCCPARAMS_0  
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0                       _MK_ADDR_CONST(0x108)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_SECURE                        0x0
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_WORD_COUNT                    0x1
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_RESET_VAL                     _MK_MASK_CONST(0x6)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_RESET_MASK                    _MK_MASK_CONST(0xfff6)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_READ_MASK                     _MK_MASK_CONST(0xfff6)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// EHCI Extended Capabilities Pointer: indicates a capabilities list exists. A value of 00h indicates no extended capabilities are implemented. For this implementation this field is always "0". 
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_EECP_SHIFT                    _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_EECP_FIELD                    (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_HCCPARAMS_0_EECP_SHIFT)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_EECP_RANGE                    15:8
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_EECP_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_EECP_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_EECP_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_EECP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_EECP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Isochronous Scheduling Threshold. This field indicates, relative to the current position of the executing host controller, where software can reliably update the isochronous schedule. When bit [7] is zero, the value of the least significant 3 bits indicates the number of micro-frames a host controller can hold a set of isochronous data structures  (one or more) before flushing the state. When bit [7] is a one, then host software assumes the host controller may cache an isochronous data structure for an entire frame. This field will always be "0". 
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_IST_SHIFT                     _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_IST_FIELD                     (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HCCPARAMS_0_IST_SHIFT)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_IST_RANGE                     7:4
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_IST_WOFFSET                   0x0
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_IST_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_IST_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_IST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_IST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Asynchronous Schedule Park Capability. 
// 1 = (Default) the host controller supports the park feature for high-speed queue heads in the Asynchronous Schedule. The feature can be disabled or enabled and set to a specific level by using the Asynchronous Schedule Park Mode Enable and Asynchronous Schedule Park Mode Count fields in the USBCMD register. 
// This field is always 1.
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_ASP_SHIFT                     _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_ASP_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HCCPARAMS_0_ASP_SHIFT)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_ASP_RANGE                     2:2
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_ASP_WOFFSET                   0x0
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_ASP_DEFAULT                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_ASP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_ASP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_ASP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Programmable Frame List Flag. 
// 0 = System software must use a frame list length of 1024 elements with this host controller. The USBCMD register Frame List Size field is a read-only register and must be set to zero. 
// 1 = System software can specify and use a smaller frame list and configure the host controller via the USBCMD register Frame List Size field.  The frame list must always be aligned on a 4K-page boundary.  This requirement ensures that the frame list is always physically contiguous. 
// This field will always be "1". 
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_PFL_SHIFT                     _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_PFL_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HCCPARAMS_0_PFL_SHIFT)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_PFL_RANGE                     1:1
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_PFL_WOFFSET                   0x0
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_PFL_DEFAULT                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_PFL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_PFL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_HCCPARAMS_0_PFL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register USB2_CONTROLLER_USB2D_DCIVERSION_0  
#define USB2_CONTROLLER_USB2D_DCIVERSION_0                      _MK_ADDR_CONST(0x120)
#define USB2_CONTROLLER_USB2D_DCIVERSION_0_SECURE                       0x0
#define USB2_CONTROLLER_USB2D_DCIVERSION_0_WORD_COUNT                   0x1
#define USB2_CONTROLLER_USB2D_DCIVERSION_0_RESET_VAL                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_DCIVERSION_0_RESET_MASK                   _MK_MASK_CONST(0xffff)
#define USB2_CONTROLLER_USB2D_DCIVERSION_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_DCIVERSION_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_DCIVERSION_0_READ_MASK                    _MK_MASK_CONST(0xffff)
#define USB2_CONTROLLER_USB2D_DCIVERSION_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
// The device controller interface conforms to the two-byte BCD encoding of the interface version number contained in this  register. 
#define USB2_CONTROLLER_USB2D_DCIVERSION_0_DCIVERSION_SHIFT                     _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DCIVERSION_0_DCIVERSION_FIELD                     (_MK_MASK_CONST(0xffff) << USB2_CONTROLLER_USB2D_DCIVERSION_0_DCIVERSION_SHIFT)
#define USB2_CONTROLLER_USB2D_DCIVERSION_0_DCIVERSION_RANGE                     15:0
#define USB2_CONTROLLER_USB2D_DCIVERSION_0_DCIVERSION_WOFFSET                   0x0
#define USB2_CONTROLLER_USB2D_DCIVERSION_0_DCIVERSION_DEFAULT                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_DCIVERSION_0_DCIVERSION_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define USB2_CONTROLLER_USB2D_DCIVERSION_0_DCIVERSION_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_DCIVERSION_0_DCIVERSION_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register USB2_CONTROLLER_USB2D_DCCPARAMS_0  
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0                       _MK_ADDR_CONST(0x124)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_SECURE                        0x0
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_WORD_COUNT                    0x1
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_RESET_VAL                     _MK_MASK_CONST(0x190)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_RESET_MASK                    _MK_MASK_CONST(0x19f)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_READ_MASK                     _MK_MASK_CONST(0x19f)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Host Capable: 1 = This controller is capable of operating as an EHCI compatible USB 2 0 host controller operating as an EHCI  compatible USB 2.0 host controller. This field is set to 1.
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_HC_SHIFT                      _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_HC_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DCCPARAMS_0_HC_SHIFT)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_HC_RANGE                      8:8
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_HC_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_HC_DEFAULT                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_HC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_HC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_HC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Device Capable: 1 = Controller is capable of operating as USB 2.0 device. This field is set to 1.
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_DC_SHIFT                      _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_DC_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DCCPARAMS_0_DC_SHIFT)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_DC_RANGE                      7:7
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_DC_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_DC_DEFAULT                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_DC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_DC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_DC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Device Endpoint Number: Number of endpoints built into the device controller. This is set to 16.
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_DEN_SHIFT                     _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_DEN_FIELD                     (_MK_MASK_CONST(0x1f) << USB2_CONTROLLER_USB2D_DCCPARAMS_0_DEN_SHIFT)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_DEN_RANGE                     4:0
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_DEN_WOFFSET                   0x0
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_DEN_DEFAULT                   _MK_MASK_CONST(0x10)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_DEN_DEFAULT_MASK                      _MK_MASK_CONST(0x1f)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_DEN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_DCCPARAMS_0_DEN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register USB2_CONTROLLER_USB2D_USBCMD_0  
#define USB2_CONTROLLER_USB2D_USBCMD_0                  _MK_ADDR_CONST(0x140)
#define USB2_CONTROLLER_USB2D_USBCMD_0_SECURE                   0x0
#define USB2_CONTROLLER_USB2D_USBCMD_0_WORD_COUNT                       0x1
#define USB2_CONTROLLER_USB2D_USBCMD_0_RESET_VAL                        _MK_MASK_CONST(0x80b00)
#define USB2_CONTROLLER_USB2D_USBCMD_0_RESET_MASK                       _MK_MASK_CONST(0xffebff)
#define USB2_CONTROLLER_USB2D_USBCMD_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_READ_MASK                        _MK_MASK_CONST(0xffebff)
#define USB2_CONTROLLER_USB2D_USBCMD_0_WRITE_MASK                       _MK_MASK_CONST(0xffeb7f)
// Interrupt Threshold Control .Read/Write. Default 08h. The system software uses this field to set the maximum rate at which the host/device controller will issue interrupts. ITC contains the maximum interrupt interval measured in micro-frames. Valid values are shown below.  
// Value          Maximum Interrupt Interval 
// 00h              Immediate (no threshold) 
// 01h                1 micro-frame 
// 02h           2 micro-frames 
// 04h          4 micro-frames 
// 08h          8 micro-frames 
// 10h          16 micro-frames 
// 20h         32 micro-frames 
// 40h         64 micro-frames
#define USB2_CONTROLLER_USB2D_USBCMD_0_ITC_SHIFT                        _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ITC_FIELD                        (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_USBCMD_0_ITC_SHIFT)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ITC_RANGE                        23:16
#define USB2_CONTROLLER_USB2D_USBCMD_0_ITC_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBCMD_0_ITC_DEFAULT                      _MK_MASK_CONST(0x8)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ITC_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ITC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ITC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ITC_IMMEDIATE                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ITC_ONE_MF                       _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ITC_TWO_MF                       _MK_ENUM_CONST(4)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ITC_EIGHT_MF                     _MK_ENUM_CONST(8)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ITC_SIXTEEN_MF                   _MK_ENUM_CONST(16)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ITC_THIRTY_TWO_MF                        _MK_ENUM_CONST(32)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ITC_SIXTY_FOUR_MF                        _MK_ENUM_CONST(64)

// Bit 2 of Frame List Size.
#define USB2_CONTROLLER_USB2D_USBCMD_0_FS2_SHIFT                        _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_USBCMD_0_FS2_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBCMD_0_FS2_SHIFT)
#define USB2_CONTROLLER_USB2D_USBCMD_0_FS2_RANGE                        15:15
#define USB2_CONTROLLER_USB2D_USBCMD_0_FS2_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBCMD_0_FS2_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_FS2_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBCMD_0_FS2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_FS2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Frame List Size . (Read/Write).  000 = Default
// This field is Read/Write only if Programmable Frame List Flag in the HCCPARAMS registers is set to one.  Hence this field is Read/Write for this implementation. This field specifies the size of the frame list that controls which bits in the Frame Index Register should be used for the Frame List Current index. 
// Note that this field is made up from USBCMD bits 15, 3 and 2. 
// 000 = 1024 elements (4096 bytes) Default value 
// 001 = 512 elements (2048 bytes) 
// 010 = 256 elements (1024 bytes)  
// 011 = 128 elements (512 bytes) 
// 100 = 64 elements (256 bytes) 
// 101 = 32 elements (128 bytes) 
// 110 = 16 elements (64 bytes) 
// 111 = 8 elements (32 bytes)       
// Only the host controller uses this field. 
#define USB2_CONTROLLER_USB2D_USBCMD_0_FS1_FS0_SHIFT                    _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_USBCMD_0_FS1_FS0_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_USBCMD_0_FS1_FS0_SHIFT)
#define USB2_CONTROLLER_USB2D_USBCMD_0_FS1_FS0_RANGE                    3:2
#define USB2_CONTROLLER_USB2D_USBCMD_0_FS1_FS0_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_USBCMD_0_FS1_FS0_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_FS1_FS0_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_USBCMD_0_FS1_FS0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_FS1_FS0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Setup Tripwire. This bit is used as a semaphore when the 8 bytes  of setup data read extracted by the firmware. If the setup lockout mode is  off, then there exists a hazard when new setup data arrives and firmware is  copying setup data from the QH for a previous setup packet. This bit is set  and cleared by software and will be cleared by hardware when a hazard exists.
#define USB2_CONTROLLER_USB2D_USBCMD_0_SUTW_SHIFT                       _MK_SHIFT_CONST(13)
#define USB2_CONTROLLER_USB2D_USBCMD_0_SUTW_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBCMD_0_SUTW_SHIFT)
#define USB2_CONTROLLER_USB2D_USBCMD_0_SUTW_RANGE                       13:13
#define USB2_CONTROLLER_USB2D_USBCMD_0_SUTW_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_USBCMD_0_SUTW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_SUTW_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBCMD_0_SUTW_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_SUTW_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_SUTW_CLEAR                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_SUTW_SET                 _MK_ENUM_CONST(1)

// Add DTD Tripwire. This bit is used as a semaphore when a dTD is  added to an active (primed) endpoint. This bit is set and cleared by software  and will be cleared by hardware when a hazard exists such that adding a dTD  to a primed endpoint may go unnoticed.
#define USB2_CONTROLLER_USB2D_USBCMD_0_ATDTW_SHIFT                      _MK_SHIFT_CONST(14)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ATDTW_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBCMD_0_ATDTW_SHIFT)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ATDTW_RANGE                      14:14
#define USB2_CONTROLLER_USB2D_USBCMD_0_ATDTW_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_USBCMD_0_ATDTW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ATDTW_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ATDTW_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ATDTW_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ATDTW_CLEAR                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ATDTW_SET                        _MK_ENUM_CONST(1)

// Asynchronous Schedule Park mode Enable. Software uses this bit to enable or disable Park mode. When this bit is one, Park mode is enabled. When this bit is a zero, Park mode is disabled.  This field is set to "1" in this  implementation. 
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASPE_SHIFT                       _MK_SHIFT_CONST(11)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASPE_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBCMD_0_ASPE_SHIFT)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASPE_RANGE                       11:11
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASPE_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASPE_DEFAULT                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASPE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASPE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASPE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASPE_DISABLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASPE_ENABLE                      _MK_ENUM_CONST(1)

// Asynchronous Schedule Park Mode Count (OPTIONAL) Read/Write.  If the Asynchronous Park Capability bit in the HCCPARAMS register is a one,  then this field defaults to 3h and is R/W. Otherwise it defaults to zero and  is RO. It contains a count of the number of successive transactions the host  controller is allowed to execute from a high-speed queue head on the  Asynchronous schedule before continuing traversal of the Asynchronous  schedule. Valid values are 1h to 3h. Software must not write a zero to this  bit when Park Mode Enable is a one as this will result in undefined behavior.  This field is set to 3h in this implementation and is Read/Write capable. 
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASP1_ASP0_SHIFT                  _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASP1_ASP0_FIELD                  (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_USBCMD_0_ASP1_ASP0_SHIFT)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASP1_ASP0_RANGE                  9:8
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASP1_ASP0_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASP1_ASP0_DEFAULT                        _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASP1_ASP0_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASP1_ASP0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASP1_ASP0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Light Host/Device Controller Reset (OPTIONAL) .  Read Only. Not Implemented. This field will always be "0". 
#define USB2_CONTROLLER_USB2D_USBCMD_0_LR_SHIFT                 _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_USBCMD_0_LR_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBCMD_0_LR_SHIFT)
#define USB2_CONTROLLER_USB2D_USBCMD_0_LR_RANGE                 7:7
#define USB2_CONTROLLER_USB2D_USBCMD_0_LR_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_USBCMD_0_LR_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_LR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBCMD_0_LR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_LR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Interrupt on Async Advance Doorbell. When the host controller has evicted all  appropriate cached schedule states, it sets the Interrupt on Async Advance  status bit in the USBSTS register. If the Interrupt on Sync Advance Enable  bit in the USBINTR register is one, then the host controller will assert an  interrupt at the next interrupt threshold. The host controller sets this bit  to zero after it has set the Interrupt on Sync Advance status bit in the  USBSTS register to one. Software should not write a one to this bit when the  asynchronous schedule is inactive. Doing so will yield undefined results. This  bit is only used in host mode. Writing a one to this bit when device mode is  selected will have undefined results. 
#define USB2_CONTROLLER_USB2D_USBCMD_0_IAA_SHIFT                        _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_USBCMD_0_IAA_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBCMD_0_IAA_SHIFT)
#define USB2_CONTROLLER_USB2D_USBCMD_0_IAA_RANGE                        6:6
#define USB2_CONTROLLER_USB2D_USBCMD_0_IAA_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBCMD_0_IAA_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_IAA_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBCMD_0_IAA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_IAA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_IAA_CLEAR                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_IAA_SET                  _MK_ENUM_CONST(1)

// Asynchronous Schedule Enable. This bit controls whether the host controller skips processing the Asynchronous Schedule. 
// 0 = Do not process the Asynchronous Schedule. 
// 1 = Use the ASYNCLISTADDR register to access the  Asynchronous Schedule. 
// Only the host controller uses this bit. 
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASE_SHIFT                        _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASE_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBCMD_0_ASE_SHIFT)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASE_RANGE                        5:5
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASE_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASE_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASE_DISABLE                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_ASE_ENABLE                       _MK_ENUM_CONST(1)

// Periodic Schedule Enable.This bit controls whether the host controller skips processing the Periodic Schedule. 
// 0 = Do not process the Periodic Schedule 
// 1 = Use the PERIODICLISTBASE register to access the Periodic  Schedule. 
// Only the host controller uses this bit. 
#define USB2_CONTROLLER_USB2D_USBCMD_0_PSE_SHIFT                        _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_USBCMD_0_PSE_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBCMD_0_PSE_SHIFT)
#define USB2_CONTROLLER_USB2D_USBCMD_0_PSE_RANGE                        4:4
#define USB2_CONTROLLER_USB2D_USBCMD_0_PSE_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBCMD_0_PSE_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_PSE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBCMD_0_PSE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_PSE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_PSE_DISABLE                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_PSE_ENABLE                       _MK_ENUM_CONST(1)

// Controller Reset. Software uses this bit to reset the controller. This bit is set to zero by the Host/Device Controller when the reset process is complete. Software cannot terminate the reset process early by writing a zero to this register. 
// Host Controller: 
// When software writes a one to this bit, the Host Controller resets its internal pipelines, timers, counters, state machines etc. to their initial value. Any transaction currently in progress on USB is immediately terminated. A USB reset is not driven on downstream ports. Software should not set this bit to a one when the HCHalted bit in the USBSTS register is a zero.  Attempting to reset an actively running host controller results in undefined behavior.   
// Device Controller: 
// When software writes a one to this bit, the Device  Controller resets its internal pipelines, timers, counters, state machines  etc. to their initial value. Any transaction currently in progress on USB is  immediately terminated. Writing a one to this bit in device mode is not  recommended. 
#define USB2_CONTROLLER_USB2D_USBCMD_0_RST_SHIFT                        _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_USBCMD_0_RST_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBCMD_0_RST_SHIFT)
#define USB2_CONTROLLER_USB2D_USBCMD_0_RST_RANGE                        1:1
#define USB2_CONTROLLER_USB2D_USBCMD_0_RST_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBCMD_0_RST_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_RST_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBCMD_0_RST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_RST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_RST_CLEAR                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_RST_SET                  _MK_ENUM_CONST(1)

// Run/Stop: 
// Host Controller: 
// When set to a 1, the Host Controller proceeds with the execution of the schedule.  
// The Host Controller continues execution as long as this bit is set to a one.  When this bit is set to 0, the Host Controller completes the current transaction on the USB and then halts.  The HCHalted bit in the status register indicates when the Host Controller has finished the transaction and has entered the stopped state.  Software should not write a one to this field unless the host controller is in the Halted state (i.e. HCHalted in the USBSTS register is a one). 
// Device Controller: 
// Writing a one to this bit will cause the device  controller to enable a pull-up on D+ and initiate an attach event. This  control bit is not directly connected to the pull-up enable, as the pull-up  will become disabled upon transitioning into high-speed mode. Software should  use this bit to prevent an attach event before the device controller has been  properly initialized. Writing a 0 to this will cause a detach event. 
#define USB2_CONTROLLER_USB2D_USBCMD_0_RS_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_RS_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBCMD_0_RS_SHIFT)
#define USB2_CONTROLLER_USB2D_USBCMD_0_RS_RANGE                 0:0
#define USB2_CONTROLLER_USB2D_USBCMD_0_RS_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_USBCMD_0_RS_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_RS_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBCMD_0_RS_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_RS_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_RS_STOP                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBCMD_0_RS_RUN                   _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_USBSTS_0  
#define USB2_CONTROLLER_USB2D_USBSTS_0                  _MK_ADDR_CONST(0x144)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SECURE                   0x0
#define USB2_CONTROLLER_USB2D_USBSTS_0_WORD_COUNT                       0x1
#define USB2_CONTROLLER_USB2D_USBSTS_0_RESET_VAL                        _MK_MASK_CONST(0x1000)
#define USB2_CONTROLLER_USB2D_USBSTS_0_RESET_MASK                       _MK_MASK_CONST(0xf1ff)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_READ_MASK                        _MK_MASK_CONST(0xf1ff)
#define USB2_CONTROLLER_USB2D_USBSTS_0_WRITE_MASK                       _MK_MASK_CONST(0xd1ef)
// Asynchronous Schedule Status. This bit reports the current real status of the Asynchronous Schedule.  When set to zero the asynchronous schedule status is disabled and if set to one the status is enabled.  The Host Controller is not required to immediately disable or enable the Asynchronous Schedule when software transitions the Asynchronous Schedule Enable bit in the USBCMD register.  
// If AS = ASE: 
// 1= Enable Asynchronous Schedule    0= Disable Asynchronous Schedule
// Only used by the host controller. 
#define USB2_CONTROLLER_USB2D_USBSTS_0_AS_SHIFT                 _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_USBSTS_0_AS_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBSTS_0_AS_SHIFT)
#define USB2_CONTROLLER_USB2D_USBSTS_0_AS_RANGE                 15:15
#define USB2_CONTROLLER_USB2D_USBSTS_0_AS_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_USBSTS_0_AS_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_AS_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBSTS_0_AS_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_AS_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_AS_DISABLE                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_AS_ENABLE                        _MK_ENUM_CONST(1)

// Periodic Schedule Status. This bit reports the current real status of the Periodic Schedule.  When set to zero the periodic schedule is disabled, and if set to one the status is enabled.  
// The Host Controller is not required to immediately disable or enable the Periodic Schedule when software transitions the Periodic Schedule Enable bit in the USBCMD register.  
// If PS = PSE then:
// 1 = Periodic Schedule is enabled or 0 = Periodic Schedule is disabled
// Only used by the host controller. 
#define USB2_CONTROLLER_USB2D_USBSTS_0_PS_SHIFT                 _MK_SHIFT_CONST(14)
#define USB2_CONTROLLER_USB2D_USBSTS_0_PS_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBSTS_0_PS_SHIFT)
#define USB2_CONTROLLER_USB2D_USBSTS_0_PS_RANGE                 14:14
#define USB2_CONTROLLER_USB2D_USBSTS_0_PS_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_USBSTS_0_PS_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_PS_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBSTS_0_PS_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_PS_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_PS_DISABLE                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_PS_ENABLE                        _MK_ENUM_CONST(1)

// Reclamation. This is a read-only status bit used to detect an  empty asynchronous schedule. Only used by the host controller. 
#define USB2_CONTROLLER_USB2D_USBSTS_0_RCL_SHIFT                        _MK_SHIFT_CONST(13)
#define USB2_CONTROLLER_USB2D_USBSTS_0_RCL_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBSTS_0_RCL_SHIFT)
#define USB2_CONTROLLER_USB2D_USBSTS_0_RCL_RANGE                        13:13
#define USB2_CONTROLLER_USB2D_USBSTS_0_RCL_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBSTS_0_RCL_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_RCL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBSTS_0_RCL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_RCL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_RCL_DISABLE                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_RCL_ENABLE                       _MK_ENUM_CONST(1)

// HCHalted. 1 = Default. This bit is a zero  whenever the Run/Stop bit is a one. The Host Controller sets this bit to one  after it has stopped executing because of the Run/Stop bit being set to 0,  either by software or by the Host Controller hardware (e.g. internal error). Only  used by the host controller. 
#define USB2_CONTROLLER_USB2D_USBSTS_0_HCH_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_USBSTS_0_HCH_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBSTS_0_HCH_SHIFT)
#define USB2_CONTROLLER_USB2D_USBSTS_0_HCH_RANGE                        12:12
#define USB2_CONTROLLER_USB2D_USBSTS_0_HCH_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBSTS_0_HCH_DEFAULT                      _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBSTS_0_HCH_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBSTS_0_HCH_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_HCH_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_HCH_UNHALTED                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_HCH_HALTED                       _MK_ENUM_CONST(1)

// DCSuspend. When a device controller enters a suspend state  from an active state, this bit will be set to a 1. The device controller  clears the bit upon exiting from a suspend state. Only used by the device  controller. 
#define USB2_CONTROLLER_USB2D_USBSTS_0_SLI_SHIFT                        _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SLI_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBSTS_0_SLI_SHIFT)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SLI_RANGE                        8:8
#define USB2_CONTROLLER_USB2D_USBSTS_0_SLI_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBSTS_0_SLI_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SLI_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SLI_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SLI_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SLI_NOTSUSPEND                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SLI_SUSPENDED                    _MK_ENUM_CONST(1)

// SOF Received. When the device controller detects a Start Of (micro) Frame, this bit will be set to a one. When a SOF is extremely late, the device controller will automatically set this bit to indicate that an SOF was expected.  Therefore, this bit will be set roughly every 1ms in device FS mode and every 125us in HS mode and will be synchronized to the actual SOF that is received. Since device controller is initialized to FS before connect, this bit Will be set at an interval of 1ms during the prelude to the connect and chirp. In host mode, this bit will be set every 125us and can be used by host controller driver as a time base. 
// Software writes a 1 to this bit to clear it. This  is a non-EHCI status bit. 
#define USB2_CONTROLLER_USB2D_USBSTS_0_SRI_SHIFT                        _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SRI_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBSTS_0_SRI_SHIFT)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SRI_RANGE                        7:7
#define USB2_CONTROLLER_USB2D_USBSTS_0_SRI_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBSTS_0_SRI_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SRI_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SRI_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SRI_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SRI_SOF_NOT_RCVD                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SRI_SOF_RCVD                     _MK_ENUM_CONST(1)

// USB Reset Received. When the device controller detects a USB Reset and  enters the default state, this bit is set to a 1. Software can write a 1 to  this bit to clear the USB Reset Received status bit. Only used by the device  controller. 
#define USB2_CONTROLLER_USB2D_USBSTS_0_URI_SHIFT                        _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_USBSTS_0_URI_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBSTS_0_URI_SHIFT)
#define USB2_CONTROLLER_USB2D_USBSTS_0_URI_RANGE                        6:6
#define USB2_CONTROLLER_USB2D_USBSTS_0_URI_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBSTS_0_URI_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_URI_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBSTS_0_URI_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_URI_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_URI_NO_USB_RESET                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_URI_USB_RESET                    _MK_ENUM_CONST(1)

// Interrupt and Asynchronous Advance. System software can force the host controller to  issue an interrupt the next time the host controller advances the  asynchronous schedule by writing a one to the Interrupt on Async Advance  Doorbell bit in the USBCMD register. This status bit indicates the assertion  of that interrupt source. Only used by the host controller
#define USB2_CONTROLLER_USB2D_USBSTS_0_AAI_SHIFT                        _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_USBSTS_0_AAI_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBSTS_0_AAI_SHIFT)
#define USB2_CONTROLLER_USB2D_USBSTS_0_AAI_RANGE                        5:5
#define USB2_CONTROLLER_USB2D_USBSTS_0_AAI_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBSTS_0_AAI_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_AAI_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBSTS_0_AAI_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_AAI_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_AAI_NOT_ADVANCED                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_AAI_ADVANCED                     _MK_ENUM_CONST(1)

// System Error. This bit is not used in this  implementation and will always be set to "0". 
#define USB2_CONTROLLER_USB2D_USBSTS_0_SEI_SHIFT                        _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SEI_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBSTS_0_SEI_SHIFT)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SEI_RANGE                        4:4
#define USB2_CONTROLLER_USB2D_USBSTS_0_SEI_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBSTS_0_SEI_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SEI_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SEI_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SEI_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SEI_NO_ERROR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_SEI_ERROR                        _MK_ENUM_CONST(1)

// Frame List Rollover. The Host Controller sets this bit to a 1 when  the Frame List Index rolls over from its maximum value to 0. The exact  value at which the rollover occurs depends on the frame list size. For  example. If the frame list size (as programmed in the Frame List Size field  of the USBCMD register) is 1024, the Frame Index Register rolls over every  time FRINDEX [1 3] toggles. Similarly, if the size is 512, the Host  Controller sets this bit to a 1 every time FHINDEX [12] toggles. Only used  by the host controller. 
#define USB2_CONTROLLER_USB2D_USBSTS_0_FRI_SHIFT                        _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_USBSTS_0_FRI_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBSTS_0_FRI_SHIFT)
#define USB2_CONTROLLER_USB2D_USBSTS_0_FRI_RANGE                        3:3
#define USB2_CONTROLLER_USB2D_USBSTS_0_FRI_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBSTS_0_FRI_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_FRI_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBSTS_0_FRI_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_FRI_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_FRI_NO_ROLLOVER                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_FRI_ROLLOVER                     _MK_ENUM_CONST(1)

// Port Change Detect. The Host Controller sets this bit to a 1 when on  any port a Connect Status occurs, a Port Enable/Disable Change occurs, or the  Force Port Resume bit is set as the result of a J-K transition on the  suspended port. The Device Controller sets this bit to a one when the port  controller enters the full or high-speed operational state. When the port  controller exits the full or high-speed operational states due to Reset or  Suspend events, the notification mechanisms are the USB Reset Received bit  and the DCSuspend bits respectively. This bit is not EHCI compatible. 
#define USB2_CONTROLLER_USB2D_USBSTS_0_PCI_SHIFT                        _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_USBSTS_0_PCI_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBSTS_0_PCI_SHIFT)
#define USB2_CONTROLLER_USB2D_USBSTS_0_PCI_RANGE                        2:2
#define USB2_CONTROLLER_USB2D_USBSTS_0_PCI_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBSTS_0_PCI_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_PCI_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBSTS_0_PCI_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_PCI_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_PCI_NO_PORT_CHANGE                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_PCI_PORT_CHANGE                  _MK_ENUM_CONST(1)

// USB Error Interrupt. This bit gets set by the Host/Device controller  when completion of a USB transaction results in an error condition. This bit  is set along with the USBINT bit, if the TD on which the error interrupt  occurred also ad its interrupt on complete (IOC) bit set. 
#define USB2_CONTROLLER_USB2D_USBSTS_0_UEI_SHIFT                        _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_USBSTS_0_UEI_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBSTS_0_UEI_SHIFT)
#define USB2_CONTROLLER_USB2D_USBSTS_0_UEI_RANGE                        1:1
#define USB2_CONTROLLER_USB2D_USBSTS_0_UEI_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBSTS_0_UEI_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_UEI_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBSTS_0_UEI_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_UEI_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_UEI_NO_ERROR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_UEI_ERROR                        _MK_ENUM_CONST(1)

// USB Interrupt. This bit is set by the Host/Device Controller when  the cause of an interrupt is a completion of a USB transaction where the  Transfer Descriptor (TD) as an interrupt on complete (IOC) bit set. This bit  is also set by the Host/Device Controller when a short packet is detected. A  short packet is when the actual number of bytes received was less than the  expected number of bytes. 
#define USB2_CONTROLLER_USB2D_USBSTS_0_UI_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_UI_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBSTS_0_UI_SHIFT)
#define USB2_CONTROLLER_USB2D_USBSTS_0_UI_RANGE                 0:0
#define USB2_CONTROLLER_USB2D_USBSTS_0_UI_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_USBSTS_0_UI_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_UI_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBSTS_0_UI_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_UI_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_UI_NO_INT                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBSTS_0_UI_INT                   _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_USBINTR_0  
#define USB2_CONTROLLER_USB2D_USBINTR_0                 _MK_ADDR_CONST(0x148)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SECURE                  0x0
#define USB2_CONTROLLER_USB2D_USBINTR_0_WORD_COUNT                      0x1
#define USB2_CONTROLLER_USB2D_USBINTR_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_RESET_MASK                      _MK_MASK_CONST(0x1ff)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_READ_MASK                       _MK_MASK_CONST(0x1ff)
#define USB2_CONTROLLER_USB2D_USBINTR_0_WRITE_MASK                      _MK_MASK_CONST(0x1ff)
// Sleep Enable. 1 = Device controller issues an interrupt if  DCSuspend bit in USBSTS register transitions. 
// The interrupt is acknowledged by SW by writing a 1 to the DCSuspend bit. Only used by the device controller. 
#define USB2_CONTROLLER_USB2D_USBINTR_0_SLE_SHIFT                       _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SLE_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBINTR_0_SLE_SHIFT)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SLE_RANGE                       8:8
#define USB2_CONTROLLER_USB2D_USBINTR_0_SLE_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_USBINTR_0_SLE_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SLE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SLE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SLE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SLE_DISABLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SLE_ENABLE                      _MK_ENUM_CONST(1)

// SOF Received Enable. 1 = Device controller issues an interrupt if SOF Received bit in USBSTS register = 1.
// The interrupt is acknowledged by software clearing  the SOF Received bit. 
#define USB2_CONTROLLER_USB2D_USBINTR_0_SRE_SHIFT                       _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SRE_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBINTR_0_SRE_SHIFT)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SRE_RANGE                       7:7
#define USB2_CONTROLLER_USB2D_USBINTR_0_SRE_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_USBINTR_0_SRE_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SRE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SRE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SRE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SRE_DISABLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SRE_ENABLE                      _MK_ENUM_CONST(1)

// USB Reset Enable.1 = Device controller issues an interrupt if USB Reset Received bit in USBSTS register  = 1 
// The interrupt is acknowledged by software clearing  the USB Reset Received bit. Only used by the device controller. 
#define USB2_CONTROLLER_USB2D_USBINTR_0_URE_SHIFT                       _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_USBINTR_0_URE_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBINTR_0_URE_SHIFT)
#define USB2_CONTROLLER_USB2D_USBINTR_0_URE_RANGE                       6:6
#define USB2_CONTROLLER_USB2D_USBINTR_0_URE_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_USBINTR_0_URE_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_URE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBINTR_0_URE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_URE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_URE_DISABLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_URE_ENABLE                      _MK_ENUM_CONST(1)

// Interrupt on Asynchronous Advance Enable. 1 = the host controller issues an interrupt at the  next interrupt threshold if Interrupt on Async Advance bit in USBSTS register  = 1. 
// The interrupt is acknowledged by software clearing the Interrupt on  Async Advance bit. Only used by the host controller. 
#define USB2_CONTROLLER_USB2D_USBINTR_0_AAE_SHIFT                       _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_USBINTR_0_AAE_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBINTR_0_AAE_SHIFT)
#define USB2_CONTROLLER_USB2D_USBINTR_0_AAE_RANGE                       5:5
#define USB2_CONTROLLER_USB2D_USBINTR_0_AAE_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_USBINTR_0_AAE_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_AAE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBINTR_0_AAE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_AAE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_AAE_DISABLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_AAE_ENABLE                      _MK_ENUM_CONST(1)

// System Error Enable. 1 = Host/device controller issues an interrupt if  the System Error bit in USBSTS register = 1.
// The interrupt is acknowledged by  software clearing the System Error bit. 
#define USB2_CONTROLLER_USB2D_USBINTR_0_SEE_SHIFT                       _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SEE_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBINTR_0_SEE_SHIFT)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SEE_RANGE                       4:4
#define USB2_CONTROLLER_USB2D_USBINTR_0_SEE_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_USBINTR_0_SEE_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SEE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SEE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SEE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SEE_DISABLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_SEE_ENABLE                      _MK_ENUM_CONST(1)

// Frame List Rollover Enable. 1 = Host controller issues an interrupt if Frame  List Rollover bit in the USBSTS register = 1.
// The interrupt is acknowledged  by software clearing the Frame List Rollover bit. Only used by the host  controller. 
#define USB2_CONTROLLER_USB2D_USBINTR_0_FRE_SHIFT                       _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_USBINTR_0_FRE_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBINTR_0_FRE_SHIFT)
#define USB2_CONTROLLER_USB2D_USBINTR_0_FRE_RANGE                       3:3
#define USB2_CONTROLLER_USB2D_USBINTR_0_FRE_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_USBINTR_0_FRE_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_FRE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBINTR_0_FRE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_FRE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_FRE_DISABLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_FRE_ENABLE                      _MK_ENUM_CONST(1)

// Port Change Detect Enable. 1 = Host/device controller issues an interrupt if  Port Change Detect bit in USBSTS register = 1. 
// The interrupt is acknowledged  by software clearing the Port Change Detect bit.
#define USB2_CONTROLLER_USB2D_USBINTR_0_PCE_SHIFT                       _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_USBINTR_0_PCE_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBINTR_0_PCE_SHIFT)
#define USB2_CONTROLLER_USB2D_USBINTR_0_PCE_RANGE                       2:2
#define USB2_CONTROLLER_USB2D_USBINTR_0_PCE_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_USBINTR_0_PCE_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_PCE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBINTR_0_PCE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_PCE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_PCE_DISABLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_PCE_ENABLE                      _MK_ENUM_CONST(1)

// USB Error Interrupt Enable. 1 = Host controller issues an interrupt at the  next interrupt threshold if the USBERRINT bit in USBSTS = 1. 
// The interrupt is  acknowledged by software clearing the USBERRINT bit in the USBSTS register. 
#define USB2_CONTROLLER_USB2D_USBINTR_0_UEE_SHIFT                       _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_USBINTR_0_UEE_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBINTR_0_UEE_SHIFT)
#define USB2_CONTROLLER_USB2D_USBINTR_0_UEE_RANGE                       1:1
#define USB2_CONTROLLER_USB2D_USBINTR_0_UEE_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_USBINTR_0_UEE_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_UEE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBINTR_0_UEE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_UEE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_UEE_DISABLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_UEE_ENABLE                      _MK_ENUM_CONST(1)

// USB Interrupt Enable. 1 = Host/device issues an interrupt at the next  interrupt threshold if the USBINT bit in USBSTS = 1. 
// The interrupt is  acknowledged by software clearing the USBINT bit.
#define USB2_CONTROLLER_USB2D_USBINTR_0_UE_SHIFT                        _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_UE_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBINTR_0_UE_SHIFT)
#define USB2_CONTROLLER_USB2D_USBINTR_0_UE_RANGE                        0:0
#define USB2_CONTROLLER_USB2D_USBINTR_0_UE_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBINTR_0_UE_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_UE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBINTR_0_UE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_UE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_UE_DISABLE                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBINTR_0_UE_ENABLE                       _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_FRINDEX_0  
#define USB2_CONTROLLER_USB2D_FRINDEX_0                 _MK_ADDR_CONST(0x14c)
#define USB2_CONTROLLER_USB2D_FRINDEX_0_SECURE                  0x0
#define USB2_CONTROLLER_USB2D_FRINDEX_0_WORD_COUNT                      0x1
#define USB2_CONTROLLER_USB2D_FRINDEX_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_FRINDEX_0_RESET_MASK                      _MK_MASK_CONST(0x3fff)
#define USB2_CONTROLLER_USB2D_FRINDEX_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_FRINDEX_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_FRINDEX_0_READ_MASK                       _MK_MASK_CONST(0x3fff)
#define USB2_CONTROLLER_USB2D_FRINDEX_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
// Frame Index.  
// The value in this register increments at the end of each time frame (micro-frame). 
// Bits [N: 3] are used for the Frame List current index. Each location of the frame list is accessed 8 times (frames or micro-frames) before moving to the next index.  
// The following illustrates values of N based on the value of the Frame List Size field in the USBCMD register, when used in host mode. 
// USBCMD          [Frame List Size] Number        Elements N 
//   000b                   (1024)                  12 
//   001b                   (512)                   11 
//   010b                   (256)                   10 
//   011b                   (128)                   9 
//   100b            (64)                    8 
//   101b            (32)                    7 
//   110b            (16)                    6 
//   111b            (8)                     5 
// In device mode the value is the current frame  number of the last frame transmitted. It is not used as an index. In either  mode bits 2:0 indicate the current micro-frame. 
#define USB2_CONTROLLER_USB2D_FRINDEX_0_FRINDEX_SHIFT                   _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_FRINDEX_0_FRINDEX_FIELD                   (_MK_MASK_CONST(0x3fff) << USB2_CONTROLLER_USB2D_FRINDEX_0_FRINDEX_SHIFT)
#define USB2_CONTROLLER_USB2D_FRINDEX_0_FRINDEX_RANGE                   13:0
#define USB2_CONTROLLER_USB2D_FRINDEX_0_FRINDEX_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_FRINDEX_0_FRINDEX_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_FRINDEX_0_FRINDEX_DEFAULT_MASK                    _MK_MASK_CONST(0x3fff)
#define USB2_CONTROLLER_USB2D_FRINDEX_0_FRINDEX_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_FRINDEX_0_FRINDEX_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Reserved address 336 [0x150] 

// Register USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0  
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0                        _MK_ADDR_CONST(0x154)
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_SECURE                         0x0
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_WORD_COUNT                     0x1
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_RESET_MASK                     _MK_MASK_CONST(0xfffff000)
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_READ_MASK                      _MK_MASK_CONST(0xfffff000)
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_WRITE_MASK                     _MK_MASK_CONST(0xfffff000)
// Host mode: This 32-bit register contains the beginning address of the Periodic Frame List in the system memory.  HCD loads this register prior to starting the schedule execution by the Host Controller.  The memory structure referenced by this physical memory pointer is assumed to be 4-Kbyte aligned.  The contents of this register are combined with the Frame Index Register (FRINDEX) to enable the Host Controller to step through the Periodic Frame List in sequence. 
// Base Address (Low). These bits correspond to memory address signals [31:12], respectively. Only used by the host controller. 
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_BASEADR_SHIFT                  _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_BASEADR_FIELD                  (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_BASEADR_SHIFT)
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_BASEADR_RANGE                  31:12
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_BASEADR_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_BASEADR_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_BASEADR_DEFAULT_MASK                   _MK_MASK_CONST(0xfffff)
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_BASEADR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_BASEADR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Device mode. The upper seven bits of this register represent the device address. After any controller reset or a USB reset, the device address is set to the default address (0). The default address will match all incoming addresses. Software shall reprogram the address after receiving a SET_ADDRESS request. 
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_USBADR_SHIFT                   _MK_SHIFT_CONST(25)
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_USBADR_FIELD                   (_MK_MASK_CONST(0x7f) << USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_USBADR_SHIFT)
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_USBADR_RANGE                   31:25
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_USBADR_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_USBADR_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_USBADR_DEFAULT_MASK                    _MK_MASK_CONST(0x7f)
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_USBADR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PERIODICLISTBASE_0_USBADR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0  
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0                   _MK_ADDR_CONST(0x158)
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_SECURE                    0x0
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_WORD_COUNT                        0x1
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_RESET_MASK                        _MK_MASK_CONST(0xffffffe0)
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_READ_MASK                         _MK_MASK_CONST(0xffffffe0)
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffe0)
// Host mode. This 32-bit register contains the address of the next asynchronous queue head to be executed by the host.
// Link Pointer Low (LPL). These bits correspond to memory address signals [31:5], respectively. This field may only reference a Queue Head (OH). Only used by the host controller.
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_ASYBASE_SHIFT                     _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_ASYBASE_FIELD                     (_MK_MASK_CONST(0x7ffffff) << USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_ASYBASE_SHIFT)
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_ASYBASE_RANGE                     31:5
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_ASYBASE_WOFFSET                   0x0
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_ASYBASE_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_ASYBASE_DEFAULT_MASK                      _MK_MASK_CONST(0x7ffffff)
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_ASYBASE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_ASYBASE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Device mode. This register contains the address of the top of the endpoint list in system memory. These bits correspond to memory address signals [31:11], respectively. This field will reference a list of up to 32 Queue Heads (QH). Only used by the device controller.
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_EPBASE_SHIFT                      _MK_SHIFT_CONST(11)
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_EPBASE_FIELD                      (_MK_MASK_CONST(0x1fffff) << USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_EPBASE_SHIFT)
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_EPBASE_RANGE                      31:11
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_EPBASE_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_EPBASE_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_EPBASE_DEFAULT_MASK                       _MK_MASK_CONST(0x1fffff)
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_EPBASE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ASYNCLISTADDR_0_EPBASE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register USB2_CONTROLLER_USB2D_ASYNCTTSTS_0  
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0                      _MK_ADDR_CONST(0x15c)
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_SECURE                       0x0
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_WORD_COUNT                   0x1
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_RESET_MASK                   _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_READ_MASK                    _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_WRITE_MASK                   _MK_MASK_CONST(0x2)
// Embedded TT Async Buffers Clear. (Read/Write to  set) This field will clear all pending transactions in the embedded TT Async  Buffer(s). The clear will take as much time as necessary to clear buffer  without interfering with a transaction in progress. TTAC will return to zero  after being set by software only after the actual clear occurs. 
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAC_SHIFT                   _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAC_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAC_SHIFT)
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAC_RANGE                   1:1
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAC_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAC_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAC_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Embedded TT Async Buffers Status. (Read Only) This  read only bit will be 1 if one or more transactions are being held in the  embedded TT Async. Buffers. When this bit is a zero, then all outstanding  transactions in the embedded TT have been flushed. 
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAS_SHIFT                   _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAS_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAS_SHIFT)
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAS_RANGE                   0:0
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAS_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAS_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ASYNCTTSTS_0_TTAS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register USB2_CONTROLLER_USB2D_BURSTSIZE_0  
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0                       _MK_ADDR_CONST(0x160)
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_SECURE                        0x0
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_WORD_COUNT                    0x1
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_RESET_VAL                     _MK_MASK_CONST(0x808)
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_RESET_MASK                    _MK_MASK_CONST(0xffff)
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_READ_MASK                     _MK_MASK_CONST(0xffff)
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_WRITE_MASK                    _MK_MASK_CONST(0xffff)
// Programmable TX Burst Length.  (Read/Write) This register represents the maximum length of a burst in 32-bit words while moving data from system memory to the USB bus.
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_TXPBURST_SHIFT                        _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_TXPBURST_FIELD                        (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_BURSTSIZE_0_TXPBURST_SHIFT)
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_TXPBURST_RANGE                        15:8
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_TXPBURST_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_TXPBURST_DEFAULT                      _MK_MASK_CONST(0x8)
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_TXPBURST_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_TXPBURST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_TXPBURST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Programmable RX Burst Length.  (Read/Write) This register represents the maximum length of a burst in 32-bit words while moving data from the USB bus to system memory.
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_RXPBURST_SHIFT                        _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_RXPBURST_FIELD                        (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_BURSTSIZE_0_RXPBURST_SHIFT)
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_RXPBURST_RANGE                        7:0
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_RXPBURST_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_RXPBURST_DEFAULT                      _MK_MASK_CONST(0x8)
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_RXPBURST_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_RXPBURST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_BURSTSIZE_0_RXPBURST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register USB2_CONTROLLER_USB2D_TXFILLTUNING_0  
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0                    _MK_ADDR_CONST(0x164)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_SECURE                     0x0
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_WORD_COUNT                         0x1
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_RESET_VAL                  _MK_MASK_CONST(0x20000)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_RESET_MASK                         _MK_MASK_CONST(0x3f1fff)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_READ_MASK                  _MK_MASK_CONST(0x3f1fff)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_WRITE_MASK                         _MK_MASK_CONST(0x3f1fff)
// FIFO Burst Threshold.  (Read/Write) This register controls the number of data bursts that are posted to the TX latency FIFO in host mode before the packet begins on to the bus.  The minimum value is 2 and this value should be a low as possible to maximize USB performance.  A higher value can be used in systems with unpredicable latency and/or insufficient bandwidth where the FIFO may underrun because the data transferred from the latency FIFO to USB occurs before it can be replenished from system memory.  This value is ignored if the Stream Disable bit in USBMODE register is set.
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXFIFOTHRES_SHIFT                  _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXFIFOTHRES_FIELD                  (_MK_MASK_CONST(0x3f) << USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXFIFOTHRES_SHIFT)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXFIFOTHRES_RANGE                  21:16
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXFIFOTHRES_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXFIFOTHRES_DEFAULT                        _MK_MASK_CONST(0x2)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXFIFOTHRES_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXFIFOTHRES_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXFIFOTHRES_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Scheduler Health Counter.  (Read/Write To Clear)  [Default = 0] This register increments when the host controller fails to fill the TX latency FIFO to the level programmed by TXFIFOTHRES before running out of time to send the packet before the next Start-Of-Frame.
// This health counter measures the number of times this occurs to provide feedback to selecting a proper TXSCHOH.  Writing to this register will clear the counter and this counter will max. at 31.
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHHEALTH_SHIFT                  _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHHEALTH_FIELD                  (_MK_MASK_CONST(0x1f) << USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHHEALTH_SHIFT)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHHEALTH_RANGE                  12:8
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHHEALTH_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHHEALTH_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHHEALTH_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHHEALTH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHHEALTH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Scheduler Overhead.  (Read/Write)  [Default = 0] This register adds an additional fixed offset to the schedule time estimator described above as Tff.  As an approximation, the value chosen for this register should limit the number of back-off events captured in the TXSCHHEALTH to less than 10 per second in a highly utilized bus.  Choosing a value that is too high for this register is not desired as it can needlessly reduce USB utilization.
// The time unit represented in this register is 1.267us when a device is connected in High-Speed Mode.
// The time unit represented in this register is 6.333us when a device is connected in Low/Full Speed Mode
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHOH_SHIFT                      _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHOH_FIELD                      (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHOH_SHIFT)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHOH_RANGE                      7:0
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHOH_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHOH_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHOH_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHOH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_TXFILLTUNING_0_TXSCHOH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Reserved address 384 [0x180] 

// Register USB2_CONTROLLER_USB2D_PORTSC1_0  
#define USB2_CONTROLLER_USB2D_PORTSC1_0                 _MK_ADDR_CONST(0x184)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_SECURE                  0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WORD_COUNT                      0x1
#define USB2_CONTROLLER_USB2D_PORTSC1_0_RESET_VAL                       _MK_MASK_CONST(0x1004)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_RESET_MASK                      _MK_MASK_CONST(0xed7fffff)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_READ_MASK                       _MK_MASK_CONST(0xed7fffff)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WRITE_MASK                      _MK_MASK_CONST(0x17f114e)
// 0 = UTMI interface. This is the only value  supported. This bit is not defined in the EHCI specification. 
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTS_SHIFT                       _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTS_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_PTS_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTS_RANGE                       31:31
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTS_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTS_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTS_UTMI                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTS_RESERVED                    _MK_ENUM_CONST(1)

// 0 = Serial transceiver not selected. This is the  only value supported. This bit is not defined in the EHCI specification. 
#define USB2_CONTROLLER_USB2D_PORTSC1_0_STS_SHIFT                       _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_STS_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_STS_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_STS_RANGE                       30:30
#define USB2_CONTROLLER_USB2D_PORTSC1_0_STS_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_STS_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_STS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_STS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_STS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_STS_PARALLEL_IF                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_STS_SERIAL_IF                   _MK_ENUM_CONST(1)

// Parallel Transceiver Width. Fixed to 0. This bit is not defined in the EHCI specification.  
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTW_SHIFT                       _MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTW_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_PTW_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTW_RANGE                       29:29
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTW_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTW_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTW_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTW_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTW_EIGHT_BIT                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTW_RESERVED                    _MK_ENUM_CONST(1)

// This register field indicates the speed at which the port is operating. 
// 00 = Full Speed
// 01 = Low Speed
// 10 = High Speed 
// This bit is not defined in the EHCI specification.  
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PSPD_SHIFT                      _MK_SHIFT_CONST(26)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PSPD_FIELD                      (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_PORTSC1_0_PSPD_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PSPD_RANGE                      27:26
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PSPD_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PSPD_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PSPD_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PSPD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PSPD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PSPD_FULL_SPEED                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PSPD_LOW_SPEED                  _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PSPD_HIGH_SPEED                 _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PSPD_RESERVED                   _MK_ENUM_CONST(3)

// Port Force Full Speed Connect: Writing this bit to a 1b forces the port to connect at Full Speed only. It disables the chirp sequence that allows the port to identify itself as High Speed. This is useful for testing FS configurations with a HS host, hub or device. This bit is not defined in the EHCI specification.
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PFSC_SHIFT                      _MK_SHIFT_CONST(24)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PFSC_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_PFSC_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PFSC_RANGE                      24:24
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PFSC_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PFSC_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PFSC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PFSC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PFSC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PFSC_DONT_FORCE_FULL_SPEED                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PFSC_FORCE_FULL_SPEED                   _MK_ENUM_CONST(1)

// Default = 0b. Wake on Over-current Enable: Writing this bit to a one enables  the port to be sensitive to over-current conditions as wake-up events. This  field is zero if Port Power(PP) is zero. This bit should only be used when  operating in Host mode. Writing this bit to 1 while the controller is working  in device mode can result in undefined behavior.
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKOC_SHIFT                      _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKOC_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_WKOC_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKOC_RANGE                      22:22
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKOC_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKOC_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKOC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKOC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKOC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKOC_DISBLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKOC_ENABLE                     _MK_ENUM_CONST(1)

// Wake on Disconnect Enable: Writing this bit to a one enables the port to be sensitive to device disconnects as wake-up events. This field is zero if Port Power(PP) is zero or in device mode. 
// This bit should only be used when operating in Host mode. Writing this bit to 1 while the controller is working in device mode can result in undefined behaviour. 
// This bit should not be written to 1 if there is no  device connected. After the device disconnect is detected, this bit should be  cleared to 0.
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKDS_SHIFT                      _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKDS_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_WKDS_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKDS_RANGE                      21:21
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKDS_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKDS_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKDS_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKDS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKDS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKDS_DISBLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKDS_ENABLE                     _MK_ENUM_CONST(1)

// Wake on Connect Enable: Writing this bit to a one enables the port to be sensitive to device connects as wake-up events. This field is zero if Port Power(PP) is zero or in device mode. 
// This bit should only be used when operating in Host mode. Writing this bit to 1 while the controller is working in device mode can result in undefined behaviour. 
// This bit should not be written to 1 while the  device is connected. After the device connection is detected, this bit should  be cleared to 0.
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKCN_SHIFT                      _MK_SHIFT_CONST(20)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKCN_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_WKCN_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKCN_RANGE                      20:20
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKCN_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKCN_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKCN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKCN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKCN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKCN_DISBLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_WKCN_ENABLE                     _MK_ENUM_CONST(1)

// Port Test Control: Any other value than zero indicates that the port is operating in test mode. 
//   Value                  Specific Test 
//  0000b                Not enabled 
//  0001b                  J_ STATE 
//  0010b             K_STATE 
//  0011b              SEQ_NAK 
//  0100b              Packet 
//  0101b               FORCE_ENABLE 
//  0110b to 1111b         Reserved 
// Refer to Chapter 7 of the USB Specification  Revision 2.0 for details on each test mode. 
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTC_SHIFT                       _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTC_FIELD                       (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_PORTSC1_0_PTC_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTC_RANGE                       19:16
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTC_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTC_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTC_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTC_NORMAL_OP                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTC_TEST_J                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTC_TEST_K                      _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTC_TEST_SE0_NAK                        _MK_ENUM_CONST(3)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTC_TEST_PKT                    _MK_ENUM_CONST(4)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PTC_TEST_FORCE_ENABLE                   _MK_ENUM_CONST(5)

// Port Indicator Control: This field is not supported in the current  implementation. Please use a GPIO if you wish to use Port Indicators.
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PIC_SHIFT                       _MK_SHIFT_CONST(14)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PIC_FIELD                       (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_PORTSC1_0_PIC_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PIC_RANGE                       15:14
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PIC_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PIC_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PIC_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PIC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PIC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Port Owner. Port owner handoff is not implemented in this design, therefore this bit will  always be 0. 
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PO_SHIFT                        _MK_SHIFT_CONST(13)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PO_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_PO_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PO_RANGE                        13:13
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PO_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PO_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PO_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PO_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PO_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Port Power: The function of this bit depends on the value of the Port Power Switching (PPC) field in the HCSPARAMS register. The behavior is as follows: 
// PPC                       PP  Operation 
// 0b                           0b Read Only. A device controller with no OTG capability does not have port power control switches. 
// 1b                          1b/0b RW.  Host/OTG controller requires port power control switches. 
// This bit represents the current setting of the switch (0=off, 1=on).  When power is not available on a port (i.e. PP equals a 0), the port is non-functional and will not report attaches, detaches, etc. 
// When an over-current condition is detected on a  powered port and PPC is a one, the PP bit in each affected port may be  transitioned by the host controller driver from a one to a zero (removing  power from the port). 
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PP_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PP_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_PP_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PP_RANGE                        12:12
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PP_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PP_DEFAULT                      _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PP_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PP_NOT_POWERED                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PP_POWERED                      _MK_ENUM_CONST(1)

// Line state. These bits reflect the current logical levels of the D+ (bit 10) and D- (bit 11) signal lines. The encoding of the bits are:
// 00b = SE0 
// 01b = J-state 
// 10b = K-state 
// 11b = Undefined 
// The value of this field is undefined if Port  Power(PP) is zero in host mode. In host mode, the use  of line-state by the host controller driver is not necessary (unlike EHCI),  because the port controller state machine and the port routing manage the  connection of LS and FS. In device mode, the use of line-state by the device  controller driver is not necessary. 
#define USB2_CONTROLLER_USB2D_PORTSC1_0_LS_SHIFT                        _MK_SHIFT_CONST(10)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_LS_FIELD                        (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_PORTSC1_0_LS_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_LS_RANGE                        11:10
#define USB2_CONTROLLER_USB2D_PORTSC1_0_LS_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_LS_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_LS_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_LS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_LS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_LS_SE0                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_LS_J_STATE                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_LS_K_STATE                      _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_LS_UNDEFINED                    _MK_ENUM_CONST(3)

// When the bit is one, the host/device connected to the port is in high-speed mode and if set to zero, the host/device connected to the port is not in a high-speed mode. 
// Note: HSP is redundant with PSPD(27:26). 
// This bit is not defined in the EHCI specification.
#define USB2_CONTROLLER_USB2D_PORTSC1_0_HSP_SHIFT                       _MK_SHIFT_CONST(9)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_HSP_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_HSP_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_HSP_RANGE                       9:9
#define USB2_CONTROLLER_USB2D_PORTSC1_0_HSP_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_HSP_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_HSP_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_HSP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_HSP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_HSP_NOT_HIGH_SPEED                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_HSP_HIGH_SPEED                  _MK_ENUM_CONST(1)

// This field is zero if Port Power(PP) is zero. 
// In Host Mode: Read/Write. 1=Port is in Reset. 0=Port is not in Reset.
// When software writes a one to this bit the bus-reset sequence as defined in the USB Specification Revision 2.0 is started. This bit will automatically change to zero after the reset sequence is complete. This behavior is different from EHCI where the host controller driver is required to set this bit to a zero after the reset duration is timed in the driver.  
// In Device Mode: This bit is a read only status  bit. Device reset from the USB bus is also indicated in the USBSTS register. 
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PR_SHIFT                        _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PR_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_PR_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PR_RANGE                        8:8
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PR_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PR_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PR_NOT_USB_RESET                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PR_USB_RESET                    _MK_ENUM_CONST(1)

// Port suspend. 1=Port in suspend state. 0=Port not in suspend state. 
// In Host Mode: Read/Write. 
// Port Enabled Bit and Suspend bit of this register define the port states as follows: 
// Bits [Port Enabled, Suspend]    Port State 
//        0x                        Disable 
//   10                        Enable 
//    11                        Suspend 
// When in suspend state, downstream propagation of data is blocked on this port, except for port reset. The blocking occurs at the end of the current transaction if a transaction was in progress when this bit was written to 1. In the suspend state, the port is sensitive to resume detection. Note that the bit status does not change until the port is suspended and that there may be a delay in suspending a port if there is a transaction currently in progress on the USB. The host controller will unconditionally set this bit to zero when software sets the Force Port Resume bit to zero. A write of zero to this bit is ignored by the host controller. If host software sets this bit to a one when the port is not enabled (i.e. Port enabled bit is a zero) the results are undefined. This field is zero if Port Power(PP) is zero in host mode.
// In Device Mode: Read Only. This bit is a read only status bit. 
#define USB2_CONTROLLER_USB2D_PORTSC1_0_SUSP_SHIFT                      _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_SUSP_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_SUSP_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_SUSP_RANGE                      7:7
#define USB2_CONTROLLER_USB2D_PORTSC1_0_SUSP_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_SUSP_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_SUSP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_SUSP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_SUSP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_SUSP_NOT_SUSPEND                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_SUSP_SUSPEND                    _MK_ENUM_CONST(1)

// Force Port Resume. 1= Resume detected/driven on port. 0=No resume (K state) detected/driven on port. 
// In Host Mode: 
// Software sets this bit to one to drive resume signaling. The Host Controller sets this bit to one if a J-to-K transition is detected while the port is in the Suspend state. When this bit transitions to a one because a J-to-K transition is detected, the Port Change Detect bit in the USBSTS register is also set to one.  This bit will automatically change to zero after the resume sequence is complete. This behavior is different from EHCI where the host controller driver is required to set this bit to a zero after the resume duration is timed in the driver. 
// Note that when the Host controller owns the port, the resume sequence follows the defined sequence documented in the USB Specification Revision 2.0. The resume signaling (Full-speed 'K') is driven on the port as long as this bit remains a one.  This bit remains a one until the port has switched to the high-speed idle.  Writing a zero has no effect because the port controller will time the resume operation to clear the bit when the port control state switches to HS or FS idle. This field is zero if Port Power(PP) is zero in host mode. This bit is not-EHCI compatible. 
// In Device mode:  
// After the device has been in Suspend State for 5ms or more, software must set this bit to one to drive resume signaling before clearing. The Device Controller will set this bit to one if a J-to-K transition is detected while the port is in the Suspend state. The bit will be cleared when the device returns to normal operation. Also, when this bit transitions to a one because a J-to-K transition is detected, the Port Change Detect bit in the USBSTS register is also set to one. 
// Software should ensure that the PHY clock is operational before writing a 1 to this bit to start the resume sequence. This is true for both Device and Host modes.
#define USB2_CONTROLLER_USB2D_PORTSC1_0_FPR_SHIFT                       _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_FPR_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_FPR_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_FPR_RANGE                       6:6
#define USB2_CONTROLLER_USB2D_PORTSC1_0_FPR_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_FPR_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_FPR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_FPR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_FPR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_FPR_NO_RESUME                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_FPR_RESUME                      _MK_ENUM_CONST(1)

// Over-current Change: Not supported
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCC_SHIFT                       _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCC_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_OCC_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCC_RANGE                       5:5
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCC_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCC_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCC_NO_CHANGE                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCC_CHANGE                      _MK_ENUM_CONST(1)

// Over-current Active: Not supported
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCA_SHIFT                       _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCA_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_OCA_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCA_RANGE                       4:4
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCA_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCA_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCA_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCA_NO_OVER_CURRENT                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_OCA_OVER_CURRENT                        _MK_ENUM_CONST(1)

// Port Enable/Disable Change: 1=Port enabled/disabled status has changed. 0=No change.
// In Host Mode: 
// For the root hub, this bit gets set to a one only when a port is disabled due to disconnect on the port or due to the appropriate conditions existing at the EOF2 point (See Chapter 11 of the USB Specification). Software clears this by writing a one to it. This field is zero if Port Power(PP) is zero. 
// In Device mode:  
// The device port is always enabled. (This bit will  be zero) 
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PEC_SHIFT                       _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PEC_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_PEC_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PEC_RANGE                       3:3
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PEC_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PEC_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PEC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PEC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PEC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PEC_NO_CHANGE                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PEC_CHANGE                      _MK_ENUM_CONST(1)

// Port Enabled/Disabled: 1=Enable. 0=Disable (default)
// In Host Mode: 
// Ports can only be enabled by the host controller as a part of the reset and enable. Software cannot enable a port by writing a one to this field. Ports can be disabled by either a fault condition (disconnect event or other fault condition) or by the host software. Note that the bit status does not change until the port state actually changes. There may be a delay in disabling or enabling a port due to other host controller and bus events.  When the port is disabled, (0b) downstream propagation of data is blocked except for reset. This field is zero if Port Power(PP) is zero in host mode. 
// In Device Mode: 
// The device port is always enabled. (This bit will  be one) 
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PE_SHIFT                        _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PE_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_PE_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PE_RANGE                        2:2
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PE_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PE_DEFAULT                      _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PE_PORT_DISABLED                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_PE_PORT_ENABLED                 _MK_ENUM_CONST(1)

// Connect Status Change: 1 =Change in Current Connect Status. 0=No change (default) 
// In Host Mode: 
// Indicates a change has occurred in the port's Current Connect Status. The host/device controller sets this bit for all changes to the port device connect status, even if system software has not cleared an existing connect status change. For example, the insertion status changes twice before system software has cleared the changed condition, hub hardware will be 'setting' an already-set bit (i.e., the bit will remain set).  Software clears this bit by writing a one to it. This field is zero if Port Power(PP) is zero in host mode. 
// This bit is undefined in device controller mode. 
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CSC_SHIFT                       _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CSC_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_CSC_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CSC_RANGE                       1:1
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CSC_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CSC_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CSC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CSC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CSC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CSC_NO_CHANGE                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CSC_CHANGE                      _MK_ENUM_CONST(1)

// Current Connect Status: 
// In Host Mode: 1=Device is present on port.                0=No device is present (default) 
// This value reflects the current state of the port, and may not correspond directly to the event that caused the Connect Status Change bit (Bit 1) to be set. This field is zero if Port Power(PP) is zero in host mode. 
// In Device Mode: 1=Attached                    0=Not Attached (default) 
// A one indicates that the device successfully attached and is operating in either high speed or full speed as indicated by the High Speed Port bit in this register. A zero indicates that the device did not attach successfully or was forcibly disconnected by the software writing a zero to the Run bit in the USBCMD register. It does not state the device being disconnected or suspended. 
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CCS_SHIFT                       _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CCS_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_PORTSC1_0_CCS_SHIFT)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CCS_RANGE                       0:0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CCS_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CCS_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CCS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CCS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CCS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CCS_NOT_CONNECTED                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_PORTSC1_0_CCS_CONNECTED                   _MK_ENUM_CONST(1)


// Reserved address 416 [0x1a0] 

// Register USB2_CONTROLLER_USB2D_OTGSC_0  
#define USB2_CONTROLLER_USB2D_OTGSC_0                   _MK_ADDR_CONST(0x1a4)
#define USB2_CONTROLLER_USB2D_OTGSC_0_SECURE                    0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_WORD_COUNT                        0x1
#define USB2_CONTROLLER_USB2D_OTGSC_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_RESET_MASK                        _MK_MASK_CONST(0x7f7f7f1b)
#define USB2_CONTROLLER_USB2D_OTGSC_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_READ_MASK                         _MK_MASK_CONST(0x7f7f7f1b)
#define USB2_CONTROLLER_USB2D_OTGSC_0_WRITE_MASK                        _MK_MASK_CONST(0x7f7f001b)
// Data Pulse Interrupt Enable. Setting this bit enables the Data pulse interrupt.
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIE_SHIFT                        _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIE_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_DPIE_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIE_RANGE                        30:30
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIE_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIE_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIE_DISABLE                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIE_ENABLE                       _MK_ENUM_CONST(1)

// 1 millisecond timer Interrupt enable. Setting this bit enables the 1 millisecond timer  interrupt.
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSE_SHIFT                      _MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSE_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSE_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSE_RANGE                      29:29
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSE_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSE_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSE_DISABLE                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSE_ENABLE                     _MK_ENUM_CONST(1)

// B Session End Interrupt Enable. Setting this bit enables the B session end  interrupt
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIE_SHIFT                       _MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIE_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_BSEIE_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIE_RANGE                       28:28
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIE_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIE_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIE_DISABLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIE_ENABLE                      _MK_ENUM_CONST(1)

// B Session Valid Interrupt Enable. Setting this bit enables the B session valid  interrupt
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIE_SHIFT                       _MK_SHIFT_CONST(27)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIE_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_BSVIE_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIE_RANGE                       27:27
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIE_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIE_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIE_DISABLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIE_ENABLE                      _MK_ENUM_CONST(1)

// A Session Valid Interrupt Enable. Setting this bit enables the A session valid  interrupt
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIE_SHIFT                       _MK_SHIFT_CONST(26)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIE_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_ASVIE_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIE_RANGE                       26:26
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIE_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIE_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIE_DISABLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIE_ENABLE                      _MK_ENUM_CONST(1)

// A VBus Valid Interrupt Enable. Setting this bit enables the A VBus valid  interrupt
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIE_SHIFT                       _MK_SHIFT_CONST(25)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIE_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_AVVIE_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIE_RANGE                       25:25
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIE_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIE_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIE_DISABLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIE_ENABLE                      _MK_ENUM_CONST(1)

// USB ID Interrupt Enable. Setting this bit enables the USB ID interrupt
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIE_SHIFT                        _MK_SHIFT_CONST(24)
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIE_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_IDIE_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIE_RANGE                        24:24
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIE_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIE_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIE_DISABLE                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIE_ENABLE                       _MK_ENUM_CONST(1)

// Data Pulse Interrupt Status. This bit is set when data bus pulsing occurs on DP or DM.  Data bus pulsing is only detected when USBMODE.CM = Host (11) and PORTSC(0).PortPower = Off (0). Software writes a 1 to clear this bit.
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIS_SHIFT                        _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIS_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_DPIS_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIS_RANGE                        22:22
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIS_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIS_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIS_INT_CLEAR                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPIS_INT_SET                      _MK_ENUM_CONST(1)

// 1 millisecond timer Interrupt Status: This bit is set once every millisecond. Software  writes a 1 to clear it.
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSS_SHIFT                      _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSS_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSS_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSS_RANGE                      21:21
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSS_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSS_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSS_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSS_INT_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMSS_INT_SET                    _MK_ENUM_CONST(1)

// B Session End Interrupt Status. This bit is set when VBus has fallen below the B  session end threshold. Software writes a 1 to clear this bit .
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIS_SHIFT                       _MK_SHIFT_CONST(20)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIS_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_BSEIS_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIS_RANGE                       20:20
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIS_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIS_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIS_INT_CLEAR                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSEIS_INT_SET                     _MK_ENUM_CONST(1)

// B Session Valid Interrupt Status. This bit is set when VBus has either risen above  or fallen below the B session valid threshold (0.8 VDC). Software writes a 1  to clear this bit. 
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIS_SHIFT                       _MK_SHIFT_CONST(19)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIS_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_BSVIS_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIS_RANGE                       19:19
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIS_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIS_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIS_INT_CLEAR                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSVIS_INT_SET                     _MK_ENUM_CONST(1)

// A Session Valid Interrupt Status. This bit is set when VBus has either risen above  or fallen below the A session valid threshold (0.8 VDC). Software writes a  one to clear this bit. 
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIS_SHIFT                       _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIS_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_ASVIS_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIS_RANGE                       18:18
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIS_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIS_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIS_INT_CLEAR                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASVIS_INT_SET                     _MK_ENUM_CONST(1)

// A VBus Valid Interrupt Status. This bit is set when VBus has either risen above  or fallen below the VBus valid threshold (4.4 VDC) on an A device. Software  writes a 1 to clear this bit. 
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIS_SHIFT                       _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIS_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_AVVIS_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIS_RANGE                       17:17
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIS_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIS_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIS_INT_CLEAR                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVVIS_INT_SET                     _MK_ENUM_CONST(1)

// USB ID Interrupt Status. This bit is set when a change on the ID input has been detected. Software writes a 1 to clear this bit. 
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIS_SHIFT                        _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIS_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_IDIS_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIS_RANGE                        16:16
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIS_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIS_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIS_INT_CLEAR                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_IDIS_INT_SET                      _MK_ENUM_CONST(1)

// Data Bus Pulsing Status. A 1 indicates data bus pulsing is being detected  on the port. 
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPS_SHIFT                 _MK_SHIFT_CONST(14)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPS_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_DPS_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPS_RANGE                 14:14
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPS_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPS_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPS_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPS_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPS_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPS_STS_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DPS_STS_SET                       _MK_ENUM_CONST(1)

// 1 millisecond timer toggle. This bit toggles once per millisecond
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMST_SHIFT                      _MK_SHIFT_CONST(13)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMST_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_ONEMST_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMST_RANGE                      13:13
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMST_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMST_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMST_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMST_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMST_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMST_STS_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ONEMST_STS_SET                    _MK_ENUM_CONST(1)

// B session End. Indicates VBus is below the B session end  threshold
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSE_SHIFT                 _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSE_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_BSE_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSE_RANGE                 12:12
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSE_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSE_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSE_STS_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSE_STS_SET                       _MK_ENUM_CONST(1)

// B Session Valid. Indicates VBus is above the B session valid  threshold
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSV_SHIFT                 _MK_SHIFT_CONST(11)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSV_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_BSV_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSV_RANGE                 11:11
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSV_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSV_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSV_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSV_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSV_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSV_STS_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_BSV_STS_SET                       _MK_ENUM_CONST(1)

// A Session Valid. Indicates VBus is above the A session valid  threshold
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASV_SHIFT                 _MK_SHIFT_CONST(10)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASV_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_ASV_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASV_RANGE                 10:10
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASV_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASV_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASV_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASV_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASV_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASV_STS_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ASV_STS_SET                       _MK_ENUM_CONST(1)

// A VBus Valid. Indicates VBus is above the A VBus valid threshold
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVV_SHIFT                 _MK_SHIFT_CONST(9)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVV_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_AVV_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVV_RANGE                 9:9
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVV_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVV_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVV_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVV_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVV_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVV_STS_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_AVV_STS_SET                       _MK_ENUM_CONST(1)

// USB ID: 0 = A-device  1 = B-device
#define USB2_CONTROLLER_USB2D_OTGSC_0_ID_SHIFT                  _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ID_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_ID_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ID_RANGE                  8:8
#define USB2_CONTROLLER_USB2D_OTGSC_0_ID_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_ID_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ID_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ID_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ID_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ID_A_DEV                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_ID_B_DEV                  _MK_ENUM_CONST(1)

// Data Pulsing. Setting this bit causes the pull-up on DP to be  asserted for data pulsing during SRP. 
#define USB2_CONTROLLER_USB2D_OTGSC_0_DP_SHIFT                  _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DP_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_DP_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DP_RANGE                  4:4
#define USB2_CONTROLLER_USB2D_OTGSC_0_DP_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_DP_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DP_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DP_NO_DATA_PULSE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_DP_DATA_PULSE                     _MK_ENUM_CONST(1)

// OTG Termination. This bit must be set when the OTG device is in device mode, this controls the pulldown on DM. 
#define USB2_CONTROLLER_USB2D_OTGSC_0_OT_SHIFT                  _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_OTGSC_0_OT_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_OT_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_OT_RANGE                  3:3
#define USB2_CONTROLLER_USB2D_OTGSC_0_OT_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_OT_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_OT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_OT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_OT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_OT_NO_OTG_TERM                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_OT_OTG_TERM                       _MK_ENUM_CONST(1)

// VBUS Charge. Setting this bit causes the VBus line to be  charged. This is used for VBus pulsing during SRP. 
#define USB2_CONTROLLER_USB2D_OTGSC_0_VC_SHIFT                  _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_VC_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_VC_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_VC_RANGE                  1:1
#define USB2_CONTROLLER_USB2D_OTGSC_0_VC_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_VC_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_VC_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_VC_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_VC_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_VC_NO_VBUS_CHRG                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_VC_VBUS_CHRG                      _MK_ENUM_CONST(1)

// VBUS_Discharge. Read/write. Setting this bit  causes Vbus to discharge through a resistor. 
#define USB2_CONTROLLER_USB2D_OTGSC_0_VD_SHIFT                  _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_VD_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_OTGSC_0_VD_SHIFT)
#define USB2_CONTROLLER_USB2D_OTGSC_0_VD_RANGE                  0:0
#define USB2_CONTROLLER_USB2D_OTGSC_0_VD_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_OTGSC_0_VD_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_VD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_OTGSC_0_VD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_VD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_VD_NO_VBUS_DISCHRG                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_OTGSC_0_VD_VBUS_DISCHRG                   _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_USBMODE_0  
#define USB2_CONTROLLER_USB2D_USBMODE_0                 _MK_ADDR_CONST(0x1a8)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SECURE                  0x0
#define USB2_CONTROLLER_USB2D_USBMODE_0_WORD_COUNT                      0x1
#define USB2_CONTROLLER_USB2D_USBMODE_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_RESET_MASK                      _MK_MASK_CONST(0x1f)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_READ_MASK                       _MK_MASK_CONST(0x1f)
#define USB2_CONTROLLER_USB2D_USBMODE_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
// Stream disbable: 1 Streaming is disabled - helpful to avoid overrun/underruns when system load is too high.
#define USB2_CONTROLLER_USB2D_USBMODE_0_SDIS_SHIFT                      _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SDIS_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBMODE_0_SDIS_SHIFT)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SDIS_RANGE                      4:4
#define USB2_CONTROLLER_USB2D_USBMODE_0_SDIS_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_USBMODE_0_SDIS_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SDIS_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SDIS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SDIS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SDIS_STREAM_ENABLE                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SDIS_STREAM_DISABLE                     _MK_ENUM_CONST(1)

// Setup Lockout Mode:
// In device mode, this bit controls the behavior of the setup lockout mechanism.
// 0 - Setup lockout is ON (default)
// 1  Setup lockout is OFF. Firmware requires the  use of setup tripwire semaphore in USB2D_USBCMD register.
#define USB2_CONTROLLER_USB2D_USBMODE_0_SLOM_SHIFT                      _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SLOM_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBMODE_0_SLOM_SHIFT)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SLOM_RANGE                      3:3
#define USB2_CONTROLLER_USB2D_USBMODE_0_SLOM_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_USBMODE_0_SLOM_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SLOM_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SLOM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SLOM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SLOM_LOCKOUT_OFF                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_SLOM_LOCKOUT_ON                 _MK_ENUM_CONST(1)

// Endian Select: Note: For this implementation, this should be  always set to 0 (little endian).
#define USB2_CONTROLLER_USB2D_USBMODE_0_ES_SHIFT                        _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_USBMODE_0_ES_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_USBMODE_0_ES_SHIFT)
#define USB2_CONTROLLER_USB2D_USBMODE_0_ES_RANGE                        2:2
#define USB2_CONTROLLER_USB2D_USBMODE_0_ES_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBMODE_0_ES_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_ES_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_USBMODE_0_ES_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_ES_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_ES_LITTLE_ENDIAN                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_ES_RESERVED                     _MK_ENUM_CONST(1)

// Controller Mode: The controller mode will default to an idle state and will need to be initialized to the desired operating mode after reset. This register can only be written once after reset. If it is necessary to switch modes, software must reset the controller by writing to the RESET bit in the USBCMD register before reprogramming this register. 
// 00 = Idle [Default] 
// 01 = Reserved 
// 10 = Device Controller  
// 11 = Host Controller 
#define USB2_CONTROLLER_USB2D_USBMODE_0_CM_SHIFT                        _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_CM_FIELD                        (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_USBMODE_0_CM_SHIFT)
#define USB2_CONTROLLER_USB2D_USBMODE_0_CM_RANGE                        1:0
#define USB2_CONTROLLER_USB2D_USBMODE_0_CM_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_USBMODE_0_CM_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_CM_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_USBMODE_0_CM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_CM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_CM_IDLE                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_USBMODE_0_CM_RESERVED                     _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_USBMODE_0_CM_DEVICE_MODE                  _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_USBMODE_0_CM_HOST_MODE                    _MK_ENUM_CONST(3)


// Register USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0  
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0                  _MK_ADDR_CONST(0x1ac)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_SECURE                   0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_WORD_COUNT                       0x1
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_RESET_MASK                       _MK_MASK_CONST(0xffff)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_READ_MASK                        _MK_MASK_CONST(0xffff)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_WRITE_MASK                       _MK_MASK_CONST(0xffff)
// Endpoint 15 Setup Status:
// For every setup transaction that is received, this bit is set to 1. Software must clear or acknowledge the setup transfer by writing a 1 to it after it has read the setup data from Queue head. The response to a setup packet (as in the order of operations and total response time) is crucial to limit bus time-outs while the setup lock-out mechanism is engaged. 
//  This register is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT15_SHIFT                   _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT15_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT15_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT15_RANGE                   15:15
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT15_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT15_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT15_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT15_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT15_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT15_NOT_RCVD                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT15_SETUP_RCVD                      _MK_ENUM_CONST(1)

// Endpoint 14 Setup Status:
// For every setup transaction that is received, this bit is set to 1. Software must clear or acknowledge the setup transfer by writing a 1 to it after it has read the setup data from Queue head. The response to a setup packet (as in the order of operations and total response time) is crucial to limit bus time-outs while the setup lock-out mechanism is engaged. 
//  This register is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT14_SHIFT                   _MK_SHIFT_CONST(14)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT14_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT14_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT14_RANGE                   14:14
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT14_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT14_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT14_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT14_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT14_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT14_NOT_RCVD                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT14_SETUP_RCVD                      _MK_ENUM_CONST(1)

// Endpoint 13 Setup Status:
// For every setup transaction that is received, this bit is set to 1. Software must clear or acknowledge the setup transfer by writing a 1 to it after it has read the setup data from Queue head. The response to a setup packet (as in the order of operations and total response time) is crucial to limit bus time-outs while the setup lock-out mechanism is engaged. 
//  This register is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT13_SHIFT                   _MK_SHIFT_CONST(13)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT13_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT13_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT13_RANGE                   13:13
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT13_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT13_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT13_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT13_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT13_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT13_NOT_RCVD                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT13_SETUP_RCVD                      _MK_ENUM_CONST(1)

// Endpoint 12 Setup Status:
// For every setup transaction that is received, this bit is set to 1. Software must clear or acknowledge the setup transfer by writing a 1 to it after it has read the setup data from Queue head. The response to a setup packet (as in the order of operations and total response time) is crucial to limit bus time-outs while the setup lock-out mechanism is engaged. 
//  This register is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT12_SHIFT                   _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT12_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT12_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT12_RANGE                   12:12
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT12_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT12_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT12_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT12_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT12_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT12_NOT_RCVD                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT12_SETUP_RCVD                      _MK_ENUM_CONST(1)

// Endpoint 11 Setup Status:
// For every setup transaction that is received, this bit is set to 1. Software must clear or acknowledge the setup transfer by writing a 1 to it after it has read the setup data from Queue head. The response to a setup packet (as in the order of operations and total response time) is crucial to limit bus time-outs while the setup lock-out mechanism is engaged. 
//  This register is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT11_SHIFT                   _MK_SHIFT_CONST(11)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT11_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT11_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT11_RANGE                   11:11
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT11_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT11_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT11_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT11_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT11_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT11_NOT_RCVD                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT11_SETUP_RCVD                      _MK_ENUM_CONST(1)

// Endpoint 10 Setup Status:
// For every setup transaction that is received, this bit is set to 1. Software must clear or acknowledge the setup transfer by writing a 1 to it after it has read the setup data from Queue head. The response to a setup packet (as in the order of operations and total response time) is crucial to limit bus time-outs while the setup lock-out mechanism is engaged. 
//  This register is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT10_SHIFT                   _MK_SHIFT_CONST(10)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT10_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT10_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT10_RANGE                   10:10
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT10_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT10_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT10_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT10_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT10_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT10_NOT_RCVD                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT10_SETUP_RCVD                      _MK_ENUM_CONST(1)

// Endpoint 9 Setup Status:
// For every setup transaction that is received, this bit is set to 1. Software must clear or acknowledge the setup transfer by writing a 1 to it after it has read the setup data from Queue head. The response to a setup packet (as in the order of operations and total response time) is crucial to limit bus time-outs while the setup lock-out mechanism is engaged. 
//  This register is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT9_SHIFT                    _MK_SHIFT_CONST(9)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT9_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT9_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT9_RANGE                    9:9
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT9_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT9_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT9_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT9_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT9_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT9_NOT_RCVD                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT9_SETUP_RCVD                       _MK_ENUM_CONST(1)

// Endpoint 8 Setup Status:
// For every setup transaction that is received, this bit is set to 1. Software must clear or acknowledge the setup transfer by writing a 1 to it after it has read the setup data from Queue head. The response to a setup packet (as in the order of operations and total response time) is crucial to limit bus time-outs while the setup lock-out mechanism is engaged. 
//  This register is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT8_SHIFT                    _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT8_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT8_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT8_RANGE                    8:8
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT8_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT8_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT8_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT8_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT8_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT8_NOT_RCVD                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT8_SETUP_RCVD                       _MK_ENUM_CONST(1)

// Endpoint 7 Setup Status:
// For every setup transaction that is received, this bit is set to 1. Software must clear or acknowledge the setup transfer by writing a 1 to it after it has read the setup data from Queue head. The response to a setup packet (as in the order of operations and total response time) is crucial to limit bus time-outs while the setup lock-out mechanism is engaged. 
//  This register is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT7_SHIFT                    _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT7_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT7_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT7_RANGE                    7:7
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT7_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT7_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT7_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT7_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT7_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT7_NOT_RCVD                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT7_SETUP_RCVD                       _MK_ENUM_CONST(1)

// Endpoint 6 Setup Status:
// For every setup transaction that is received, this bit is set to 1. Software must clear or acknowledge the setup transfer by writing a 1 to it after it has read the setup data from Queue head. The response to a setup packet (as in the order of operations and total response time) is crucial to limit bus time-outs while the setup lock-out mechanism is engaged. 
//  This register is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT6_SHIFT                    _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT6_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT6_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT6_RANGE                    6:6
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT6_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT6_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT6_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT6_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT6_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT6_NOT_RCVD                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT6_SETUP_RCVD                       _MK_ENUM_CONST(1)

// Endpoint 5 Setup Status:
// For every setup transaction that is received, this bit is set to 1. Software must clear or acknowledge the setup transfer by writing a 1 to it after it has read the setup data from Queue head. The response to a setup packet (as in the order of operations and total response time) is crucial to limit bus time-outs while the setup lock-out mechanism is engaged. 
//  This register is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT5_SHIFT                    _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT5_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT5_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT5_RANGE                    5:5
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT5_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT5_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT5_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT5_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT5_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT5_NOT_RCVD                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT5_SETUP_RCVD                       _MK_ENUM_CONST(1)

// Endpoint 4 Setup Status:
// For every setup transaction that is received, this bit is set to 1. Software must clear or acknowledge the setup transfer by writing a 1 to it after it has read the setup data from Queue head. The response to a setup packet (as in the order of operations and total response time) is crucial to limit bus time-outs while the setup lock-out mechanism is engaged. 
//  This register is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT4_SHIFT                    _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT4_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT4_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT4_RANGE                    4:4
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT4_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT4_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT4_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT4_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT4_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT4_NOT_RCVD                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT4_SETUP_RCVD                       _MK_ENUM_CONST(1)

// Endpoint 3 Setup Status:
// For every setup transaction that is received, this bit is set to 1. Software must clear or acknowledge the setup transfer by writing a 1 to it after it has read the setup data from Queue head. The response to a setup packet (as in the order of operations and total response time) is crucial to limit bus time-outs while the setup lock-out mechanism is engaged. 
//  This register is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT3_SHIFT                    _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT3_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT3_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT3_RANGE                    3:3
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT3_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT3_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT3_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT3_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT3_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT3_NOT_RCVD                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT3_SETUP_RCVD                       _MK_ENUM_CONST(1)

// Endpoint 2 Setup Status:
// For every setup transaction that is received, this bit is set to 1. Software must clear or acknowledge the setup transfer by writing a 1 to it after it has read the setup data from Queue head. The response to a setup packet (as in the order of operations and total response time) is crucial to limit bus time-outs while the setup lock-out mechanism is engaged. 
//  This register is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT2_SHIFT                    _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT2_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT2_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT2_RANGE                    2:2
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT2_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT2_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT2_NOT_RCVD                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT2_SETUP_RCVD                       _MK_ENUM_CONST(1)

// Endpoint 1 Setup Status:
// For every setup transaction that is received, this bit is set to 1. Software must clear or acknowledge the setup transfer by writing a 1 to it after it has read the setup data from Queue head. The response to a setup packet (as in the order of operations and total response time) is crucial to limit bus time-outs while the setup lock-out mechanism is engaged. 
//  This register is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT1_SHIFT                    _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT1_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT1_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT1_RANGE                    1:1
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT1_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT1_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT1_NOT_RCVD                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT1_SETUP_RCVD                       _MK_ENUM_CONST(1)

// Endpoint 0 Setup Status:
// For every setup transaction that is received, this bit is set to 1. Software must clear or acknowledge the setup transfer by writing a 1 to it after it has read the setup data from Queue head. The response to a setup packet (as in the order of operations and total response time) is crucial to limit bus time-outs while the setup lock-out mechanism is engaged. 
//  This register is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT0_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT0_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT0_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT0_RANGE                    0:0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT0_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT0_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT0_NOT_RCVD                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSETUPSTAT_0_ENDPTSETUPSTAT0_SETUP_RCVD                       _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTPRIME_0  
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0                      _MK_ADDR_CONST(0x1b0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_SECURE                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_WORD_COUNT                   0x1
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
// Prime Endpoint Transmit Buffer:
// This bit is used to request that a buffer prepared for a transmit operation in order to respond to a USB IN/INTERRUPT transaction on this endpiont. Software should write a "1" to this bit when posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a transmit buffer. Hardware will clear this bit when this endpoint is successfully primed.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB15_SHIFT                 _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB15_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB15_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB15_RANGE                 31:31
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB15_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB15_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB15_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB15_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB15_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB15_DONT_PRIME                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB15_PRIME                 _MK_ENUM_CONST(1)

// Prime Endpoint Transmit Buffer:
// This bit is used to request that a buffer prepared for a transmit operation in order to respond to a USB IN/INTERRUPT transaction on this endpiont. Software should write a "1" to this bit when posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a transmit buffer. Hardware will clear this bit when this endpoint is successfully primed.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB14_SHIFT                 _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB14_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB14_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB14_RANGE                 30:30
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB14_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB14_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB14_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB14_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB14_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB14_DONT_PRIME                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB14_PRIME                 _MK_ENUM_CONST(1)

// Prime Endpoint Transmit Buffer:
// This bit is used to request that a buffer prepared for a transmit operation in order to respond to a USB IN/INTERRUPT transaction on this endpiont. Software should write a "1" to this bit when posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a transmit buffer. Hardware will clear this bit when this endpoint is successfully primed.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB13_SHIFT                 _MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB13_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB13_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB13_RANGE                 29:29
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB13_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB13_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB13_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB13_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB13_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB13_DONT_PRIME                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB13_PRIME                 _MK_ENUM_CONST(1)

// Prime Endpoint Transmit Buffer:
// This bit is used to request that a buffer prepared for a transmit operation in order to respond to a USB IN/INTERRUPT transaction on this endpiont. Software should write a "1" to this bit when posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a transmit buffer. Hardware will clear this bit when this endpoint is successfully primed.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB12_SHIFT                 _MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB12_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB12_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB12_RANGE                 28:28
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB12_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB12_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB12_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB12_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB12_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB12_DONT_PRIME                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB12_PRIME                 _MK_ENUM_CONST(1)

// Prime Endpoint Transmit Buffer:
// This bit is used to request that a buffer prepared for a transmit operation in order to respond to a USB IN/INTERRUPT transaction on this endpiont. Software should write a "1" to this bit when posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a transmit buffer. Hardware will clear this bit when this endpoint is successfully primed.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB11_SHIFT                 _MK_SHIFT_CONST(27)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB11_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB11_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB11_RANGE                 27:27
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB11_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB11_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB11_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB11_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB11_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB11_DONT_PRIME                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB11_PRIME                 _MK_ENUM_CONST(1)

// Prime Endpoint Transmit Buffer:
// This bit is used to request that a buffer prepared for a transmit operation in order to respond to a USB IN/INTERRUPT transaction on this endpiont. Software should write a "1" to this bit when posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a transmit buffer. Hardware will clear this bit when this endpoint is successfully primed.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB10_SHIFT                 _MK_SHIFT_CONST(26)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB10_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB10_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB10_RANGE                 26:26
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB10_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB10_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB10_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB10_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB10_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB10_DONT_PRIME                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB10_PRIME                 _MK_ENUM_CONST(1)

// Prime Endpoint Transmit Buffer:
// This bit is used to request that a buffer prepared for a transmit operation in order to respond to a USB IN/INTERRUPT transaction on this endpiont. Software should write a "1" to this bit when posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a transmit buffer. Hardware will clear this bit when this endpoint is successfully primed.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB9_SHIFT                  _MK_SHIFT_CONST(25)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB9_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB9_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB9_RANGE                  25:25
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB9_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB9_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB9_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB9_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB9_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB9_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB9_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Transmit Buffer:
// This bit is used to request that a buffer prepared for a transmit operation in order to respond to a USB IN/INTERRUPT transaction on this endpiont. Software should write a "1" to this bit when posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a transmit buffer. Hardware will clear this bit when this endpoint is successfully primed.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB8_SHIFT                  _MK_SHIFT_CONST(24)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB8_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB8_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB8_RANGE                  24:24
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB8_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB8_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB8_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB8_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB8_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB8_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB8_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Transmit Buffer:
// This bit is used to request that a buffer prepared for a transmit operation in order to respond to a USB IN/INTERRUPT transaction on this endpiont. Software should write a "1" to this bit when posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a transmit buffer. Hardware will clear this bit when this endpoint is successfully primed.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB7_SHIFT                  _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB7_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB7_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB7_RANGE                  23:23
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB7_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB7_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB7_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB7_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB7_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB7_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB7_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Transmit Buffer:
// This bit is used to request that a buffer prepared for a transmit operation in order to respond to a USB IN/INTERRUPT transaction on this endpiont. Software should write a "1" to this bit when posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a transmit buffer. Hardware will clear this bit when this endpoint is successfully primed.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB6_SHIFT                  _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB6_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB6_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB6_RANGE                  22:22
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB6_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB6_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB6_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB6_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB6_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB6_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB6_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Transmit Buffer:
// This bit is used to request that a buffer prepared for a transmit operation in order to respond to a USB IN/INTERRUPT transaction on this endpiont. Software should write a "1" to this bit when posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a transmit buffer. Hardware will clear this bit when this endpoint is successfully primed.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB5_SHIFT                  _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB5_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB5_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB5_RANGE                  21:21
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB5_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB5_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB5_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB5_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB5_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB5_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB5_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Transmit Buffer:
// This bit is used to request that a buffer prepared for a transmit operation in order to respond to a USB IN/INTERRUPT transaction on this endpiont. Software should write a "1" to this bit when posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a transmit buffer. Hardware will clear this bit when this endpoint is successfully primed.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB4_SHIFT                  _MK_SHIFT_CONST(20)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB4_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB4_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB4_RANGE                  20:20
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB4_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB4_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB4_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB4_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB4_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB4_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB4_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Transmit Buffer:
// This bit is used to request that a buffer prepared for a transmit operation in order to respond to a USB IN/INTERRUPT transaction on this endpiont. Software should write a "1" to this bit when posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a transmit buffer. Hardware will clear this bit when this endpoint is successfully primed.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB3_SHIFT                  _MK_SHIFT_CONST(19)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB3_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB3_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB3_RANGE                  19:19
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB3_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB3_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB3_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB3_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB3_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Transmit Buffer:
// This bit is used to request that a buffer prepared for a transmit operation in order to respond to a USB IN/INTERRUPT transaction on this endpiont. Software should write a "1" to this bit when posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a transmit buffer. Hardware will clear this bit when this endpoint is successfully primed.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB2_SHIFT                  _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB2_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB2_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB2_RANGE                  18:18
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB2_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB2_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB2_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB2_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB2_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Transmit Buffer:
// This bit is used to request that a buffer prepared for a transmit operation in order to respond to a USB IN/INTERRUPT transaction on this endpiont. Software should write a "1" to this bit when posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a transmit buffer. Hardware will clear this bit when this endpoint is successfully primed.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB1_SHIFT                  _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB1_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB1_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB1_RANGE                  17:17
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB1_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB1_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB1_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB1_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB1_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Transmit Buffer:
// This bit is used to request that a buffer prepared for a transmit operation in order to respond to a USB IN/INTERRUPT transaction on this endpiont. Software should write a "1" to this bit when posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a transmit buffer. Hardware will clear this bit when this endpoint is successfully primed.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB0_SHIFT                  _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB0_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB0_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB0_RANGE                  16:16
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB0_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB0_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB0_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PETB0_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Receive Buffer:
// This bit is used to request that a buffer prepared for a receive operation when a USB host initiates a USB OUT transaction to this endpoint. Software should write a one to this bit whenever posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a receive buffer. Hardware will clear this bit when this endpoint is successfully primed. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB15_SHIFT                 _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB15_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB15_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB15_RANGE                 15:15
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB15_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB15_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB15_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB15_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB15_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB15_DONT_PRIME                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB15_PRIME                 _MK_ENUM_CONST(1)

// Prime Endpoint Receive Buffer:
// This bit is used to request that a buffer prepared for a receive operation when a USB host initiates a USB OUT transaction to this endpoint. Software should write a one to this bit whenever posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a receive buffer. Hardware will clear this bit when this endpoint is successfully primed. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB14_SHIFT                 _MK_SHIFT_CONST(14)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB14_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB14_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB14_RANGE                 14:14
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB14_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB14_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB14_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB14_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB14_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB14_DONT_PRIME                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB14_PRIME                 _MK_ENUM_CONST(1)

// Prime Endpoint Receive Buffer:
// This bit is used to request that a buffer prepared for a receive operation when a USB host initiates a USB OUT transaction to this endpoint. Software should write a one to this bit whenever posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a receive buffer. Hardware will clear this bit when this endpoint is successfully primed. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB13_SHIFT                 _MK_SHIFT_CONST(13)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB13_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB13_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB13_RANGE                 13:13
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB13_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB13_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB13_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB13_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB13_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB13_DONT_PRIME                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB13_PRIME                 _MK_ENUM_CONST(1)

// Prime Endpoint Receive Buffer:
// This bit is used to request that a buffer prepared for a receive operation when a USB host initiates a USB OUT transaction to this endpoint. Software should write a one to this bit whenever posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a receive buffer. Hardware will clear this bit when this endpoint is successfully primed. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB12_SHIFT                 _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB12_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB12_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB12_RANGE                 12:12
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB12_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB12_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB12_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB12_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB12_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB12_DONT_PRIME                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB12_PRIME                 _MK_ENUM_CONST(1)

// Prime Endpoint Receive Buffer:
// This bit is used to request that a buffer prepared for a receive operation when a USB host initiates a USB OUT transaction to this endpoint. Software should write a one to this bit whenever posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a receive buffer. Hardware will clear this bit when this endpoint is successfully primed. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB11_SHIFT                 _MK_SHIFT_CONST(11)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB11_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB11_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB11_RANGE                 11:11
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB11_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB11_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB11_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB11_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB11_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB11_DONT_PRIME                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB11_PRIME                 _MK_ENUM_CONST(1)

// Prime Endpoint Receive Buffer:
// This bit is used to request that a buffer prepared for a receive operation when a USB host initiates a USB OUT transaction to this endpoint. Software should write a one to this bit whenever posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a receive buffer. Hardware will clear this bit when this endpoint is successfully primed. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB10_SHIFT                 _MK_SHIFT_CONST(10)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB10_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB10_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB10_RANGE                 10:10
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB10_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB10_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB10_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB10_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB10_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB10_DONT_PRIME                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB10_PRIME                 _MK_ENUM_CONST(1)

// Prime Endpoint Receive Buffer:
// This bit is used to request that a buffer prepared for a receive operation when a USB host initiates a USB OUT transaction to this endpoint. Software should write a one to this bit whenever posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a receive buffer. Hardware will clear this bit when this endpoint is successfully primed. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB9_SHIFT                  _MK_SHIFT_CONST(9)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB9_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB9_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB9_RANGE                  9:9
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB9_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB9_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB9_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB9_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB9_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB9_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB9_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Receive Buffer:
// This bit is used to request that a buffer prepared for a receive operation when a USB host initiates a USB OUT transaction to this endpoint. Software should write a one to this bit whenever posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a receive buffer. Hardware will clear this bit when this endpoint is successfully primed. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB8_SHIFT                  _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB8_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB8_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB8_RANGE                  8:8
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB8_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB8_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB8_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB8_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB8_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB8_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB8_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Receive Buffer:
// This bit is used to request that a buffer prepared for a receive operation when a USB host initiates a USB OUT transaction to this endpoint. Software should write a one to this bit whenever posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a receive buffer. Hardware will clear this bit when this endpoint is successfully primed. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB7_SHIFT                  _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB7_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB7_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB7_RANGE                  7:7
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB7_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB7_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB7_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB7_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB7_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB7_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB7_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Receive Buffer:
// This bit is used to request that a buffer prepared for a receive operation when a USB host initiates a USB OUT transaction to this endpoint. Software should write a one to this bit whenever posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a receive buffer. Hardware will clear this bit when this endpoint is successfully primed. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB6_SHIFT                  _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB6_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB6_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB6_RANGE                  6:6
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB6_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB6_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB6_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB6_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB6_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB6_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB6_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Receive Buffer:
// This bit is used to request that a buffer prepared for a receive operation when a USB host initiates a USB OUT transaction to this endpoint. Software should write a one to this bit whenever posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a receive buffer. Hardware will clear this bit when this endpoint is successfully primed. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB5_SHIFT                  _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB5_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB5_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB5_RANGE                  5:5
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB5_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB5_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB5_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB5_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB5_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB5_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB5_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Receive Buffer:
// This bit is used to request that a buffer prepared for a receive operation when a USB host initiates a USB OUT transaction to this endpoint. Software should write a one to this bit whenever posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a receive buffer. Hardware will clear this bit when this endpoint is successfully primed. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB4_SHIFT                  _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB4_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB4_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB4_RANGE                  4:4
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB4_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB4_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB4_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB4_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB4_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB4_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB4_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Receive Buffer:
// This bit is used to request that a buffer prepared for a receive operation when a USB host initiates a USB OUT transaction to this endpoint. Software should write a one to this bit whenever posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a receive buffer. Hardware will clear this bit when this endpoint is successfully primed. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB3_SHIFT                  _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB3_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB3_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB3_RANGE                  3:3
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB3_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB3_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB3_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB3_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB3_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Receive Buffer:
// This bit is used to request that a buffer prepared for a receive operation when a USB host initiates a USB OUT transaction to this endpoint. Software should write a one to this bit whenever posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a receive buffer. Hardware will clear this bit when this endpoint is successfully primed. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB2_SHIFT                  _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB2_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB2_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB2_RANGE                  2:2
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB2_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB2_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB2_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB2_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB2_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Receive Buffer:
// This bit is used to request that a buffer prepared for a receive operation when a USB host initiates a USB OUT transaction to this endpoint. Software should write a one to this bit whenever posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a receive buffer. Hardware will clear this bit when this endpoint is successfully primed. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB1_SHIFT                  _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB1_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB1_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB1_RANGE                  1:1
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB1_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB1_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB1_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB1_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB1_PRIME                  _MK_ENUM_CONST(1)

// Prime Endpoint Receive Buffer:
// This bit is used to request that a buffer prepared for a receive operation when a USB host initiates a USB OUT transaction to this endpoint. Software should write a one to this bit whenever posting a new transfer descriptor to this endpoint. Hardware will automatically use this bit to begin parsing for a new transfer descriptor from the queue head and prepare a receive buffer. Hardware will clear this bit when this endpoint is successfully primed. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB0_SHIFT                  _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB0_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB0_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB0_RANGE                  0:0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB0_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB0_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB0_DONT_PRIME                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTPRIME_0_PERB0_PRIME                  _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTFLUSH_0  
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0                      _MK_ADDR_CONST(0x1b4)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_SECURE                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_WORD_COUNT                   0x1
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
// Flush Endpoint Transmit Buffer: 
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB15_SHIFT                 _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB15_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB15_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB15_RANGE                 31:31
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB15_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB15_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB15_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB15_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB15_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB15_DONT_FLUSH                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB15_FLUSH                 _MK_ENUM_CONST(1)

// Flush Endpoint Transmit Buffer: 
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB14_SHIFT                 _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB14_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB14_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB14_RANGE                 30:30
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB14_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB14_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB14_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB14_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB14_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB14_DONT_FLUSH                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB14_FLUSH                 _MK_ENUM_CONST(1)

// Flush Endpoint Transmit Buffer: 
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB13_SHIFT                 _MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB13_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB13_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB13_RANGE                 29:29
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB13_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB13_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB13_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB13_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB13_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB13_DONT_FLUSH                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB13_FLUSH                 _MK_ENUM_CONST(1)

// Flush Endpoint Transmit Buffer: 
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB12_SHIFT                 _MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB12_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB12_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB12_RANGE                 28:28
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB12_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB12_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB12_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB12_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB12_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB12_DONT_FLUSH                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB12_FLUSH                 _MK_ENUM_CONST(1)

// Flush Endpoint Transmit Buffer: 
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB11_SHIFT                 _MK_SHIFT_CONST(27)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB11_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB11_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB11_RANGE                 27:27
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB11_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB11_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB11_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB11_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB11_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB11_DONT_FLUSH                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB11_FLUSH                 _MK_ENUM_CONST(1)

// Flush Endpoint Transmit Buffer: 
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB10_SHIFT                 _MK_SHIFT_CONST(26)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB10_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB10_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB10_RANGE                 26:26
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB10_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB10_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB10_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB10_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB10_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB10_DONT_FLUSH                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB10_FLUSH                 _MK_ENUM_CONST(1)

// Flush Endpoint Transmit Buffer: 
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB9_SHIFT                  _MK_SHIFT_CONST(25)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB9_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB9_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB9_RANGE                  25:25
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB9_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB9_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB9_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB9_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB9_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB9_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB9_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Transmit Buffer: 
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB8_SHIFT                  _MK_SHIFT_CONST(24)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB8_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB8_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB8_RANGE                  24:24
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB8_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB8_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB8_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB8_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB8_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB8_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB8_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Transmit Buffer: 
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB7_SHIFT                  _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB7_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB7_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB7_RANGE                  23:23
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB7_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB7_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB7_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB7_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB7_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB7_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB7_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Transmit Buffer: 
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB6_SHIFT                  _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB6_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB6_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB6_RANGE                  22:22
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB6_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB6_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB6_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB6_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB6_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB6_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB6_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Transmit Buffer: 
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB5_SHIFT                  _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB5_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB5_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB5_RANGE                  21:21
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB5_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB5_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB5_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB5_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB5_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB5_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB5_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Transmit Buffer: 
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB4_SHIFT                  _MK_SHIFT_CONST(20)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB4_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB4_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB4_RANGE                  20:20
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB4_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB4_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB4_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB4_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB4_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB4_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB4_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Transmit Buffer: 
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB3_SHIFT                  _MK_SHIFT_CONST(19)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB3_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB3_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB3_RANGE                  19:19
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB3_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB3_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB3_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB3_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB3_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Transmit Buffer: 
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB2_SHIFT                  _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB2_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB2_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB2_RANGE                  18:18
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB2_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB2_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB2_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB2_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB2_FLUSH                  _MK_ENUM_CONST(1)

// 
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB1_SHIFT                  _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB1_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB1_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB1_RANGE                  17:17
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB1_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB1_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB1_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB1_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB1_FLUSH                  _MK_ENUM_CONST(1)

//
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB0_SHIFT                  _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB0_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB0_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB0_RANGE                  16:16
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB0_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB0_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB0_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FETB0_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Receive Buffer:
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB15_SHIFT                 _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB15_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB15_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB15_RANGE                 15:15
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB15_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB15_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB15_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB15_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB15_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB15_DONT_FLUSH                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB15_FLUSH                 _MK_ENUM_CONST(1)

// Flush Endpoint Receive Buffer:
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB14_SHIFT                 _MK_SHIFT_CONST(14)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB14_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB14_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB14_RANGE                 14:14
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB14_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB14_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB14_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB14_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB14_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB14_DONT_FLUSH                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB14_FLUSH                 _MK_ENUM_CONST(1)

// Flush Endpoint Receive Buffer:
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB13_SHIFT                 _MK_SHIFT_CONST(13)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB13_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB13_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB13_RANGE                 13:13
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB13_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB13_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB13_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB13_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB13_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB13_DONT_FLUSH                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB13_FLUSH                 _MK_ENUM_CONST(1)

// Flush Endpoint Receive Buffer:
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB12_SHIFT                 _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB12_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB12_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB12_RANGE                 12:12
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB12_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB12_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB12_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB12_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB12_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB12_DONT_FLUSH                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB12_FLUSH                 _MK_ENUM_CONST(1)

// Flush Endpoint Receive Buffer:
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB11_SHIFT                 _MK_SHIFT_CONST(11)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB11_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB11_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB11_RANGE                 11:11
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB11_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB11_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB11_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB11_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB11_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB11_DONT_FLUSH                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB11_FLUSH                 _MK_ENUM_CONST(1)

// Flush Endpoint Receive Buffer:
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB10_SHIFT                 _MK_SHIFT_CONST(10)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB10_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB10_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB10_RANGE                 10:10
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB10_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB10_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB10_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB10_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB10_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB10_DONT_FLUSH                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB10_FLUSH                 _MK_ENUM_CONST(1)

// Flush Endpoint Receive Buffer:
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB9_SHIFT                  _MK_SHIFT_CONST(9)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB9_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB9_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB9_RANGE                  9:9
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB9_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB9_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB9_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB9_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB9_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB9_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB9_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Receive Buffer:
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB8_SHIFT                  _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB8_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB8_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB8_RANGE                  8:8
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB8_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB8_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB8_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB8_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB8_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB8_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB8_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Receive Buffer:
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB7_SHIFT                  _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB7_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB7_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB7_RANGE                  7:7
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB7_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB7_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB7_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB7_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB7_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB7_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB7_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Receive Buffer:
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB6_SHIFT                  _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB6_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB6_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB6_RANGE                  6:6
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB6_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB6_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB6_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB6_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB6_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB6_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB6_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Receive Buffer:
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB5_SHIFT                  _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB5_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB5_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB5_RANGE                  5:5
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB5_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB5_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB5_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB5_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB5_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB5_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB5_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Receive Buffer:
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB4_SHIFT                  _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB4_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB4_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB4_RANGE                  4:4
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB4_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB4_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB4_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB4_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB4_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB4_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB4_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Receive Buffer:
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB3_SHIFT                  _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB3_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB3_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB3_RANGE                  3:3
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB3_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB3_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB3_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB3_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB3_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Receive Buffer:
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB2_SHIFT                  _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB2_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB2_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB2_RANGE                  2:2
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB2_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB2_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB2_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB2_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB2_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Receive Buffer:
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB1_SHIFT                  _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB1_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB1_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB1_RANGE                  1:1
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB1_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB1_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB1_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB1_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB1_FLUSH                  _MK_ENUM_CONST(1)

// Flush Endpoint Receive Buffer:
// Writing a one to this bit causes the associated endpoint to clear any primed buffers. If a packet is in progress for the associated endpoint that transfer will continue until completion. Hardware clears this register after the endpoint flush operation is successful. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB0_SHIFT                  _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB0_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB0_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB0_RANGE                  0:0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB0_WOFFSET                        0x0
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB0_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB0_DONT_FLUSH                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTFLUSH_0_FERB0_FLUSH                  _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTSTATUS_0  
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0                     _MK_ADDR_CONST(0x1b8)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_SECURE                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_WORD_COUNT                  0x1
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// Endpoint Transmit Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR15_SHIFT                        _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR15_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR15_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR15_RANGE                        31:31
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR15_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR15_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR15_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR15_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR15_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR15_NOT_READY                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR15_READY                        _MK_ENUM_CONST(1)

// Endpoint Transmit Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR14_SHIFT                        _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR14_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR14_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR14_RANGE                        30:30
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR14_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR14_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR14_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR14_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR14_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR14_NOT_READY                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR14_READY                        _MK_ENUM_CONST(1)

// Endpoint Transmit Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR13_SHIFT                        _MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR13_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR13_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR13_RANGE                        29:29
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR13_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR13_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR13_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR13_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR13_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR13_NOT_READY                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR13_READY                        _MK_ENUM_CONST(1)

// Endpoint Transmit Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR12_SHIFT                        _MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR12_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR12_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR12_RANGE                        28:28
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR12_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR12_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR12_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR12_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR12_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR12_NOT_READY                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR12_READY                        _MK_ENUM_CONST(1)

// Endpoint Transmit Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR11_SHIFT                        _MK_SHIFT_CONST(27)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR11_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR11_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR11_RANGE                        27:27
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR11_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR11_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR11_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR11_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR11_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR11_NOT_READY                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR11_READY                        _MK_ENUM_CONST(1)

// Endpoint Transmit Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR10_SHIFT                        _MK_SHIFT_CONST(26)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR10_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR10_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR10_RANGE                        26:26
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR10_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR10_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR10_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR10_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR10_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR10_NOT_READY                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR10_READY                        _MK_ENUM_CONST(1)

// Endpoint Transmit Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR9_SHIFT                 _MK_SHIFT_CONST(25)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR9_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR9_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR9_RANGE                 25:25
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR9_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR9_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR9_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR9_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR9_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR9_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR9_READY                 _MK_ENUM_CONST(1)

// Endpoint Transmit Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR8_SHIFT                 _MK_SHIFT_CONST(24)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR8_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR8_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR8_RANGE                 24:24
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR8_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR8_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR8_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR8_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR8_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR8_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR8_READY                 _MK_ENUM_CONST(1)

// Endpoint Transmit Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR7_SHIFT                 _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR7_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR7_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR7_RANGE                 23:23
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR7_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR7_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR7_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR7_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR7_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR7_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR7_READY                 _MK_ENUM_CONST(1)

// Endpoint Transmit Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR6_SHIFT                 _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR6_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR6_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR6_RANGE                 22:22
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR6_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR6_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR6_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR6_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR6_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR6_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR6_READY                 _MK_ENUM_CONST(1)

// Endpoint Transmit Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR5_SHIFT                 _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR5_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR5_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR5_RANGE                 21:21
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR5_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR5_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR5_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR5_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR5_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR5_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR5_READY                 _MK_ENUM_CONST(1)

// Endpoint Transmit Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR4_SHIFT                 _MK_SHIFT_CONST(20)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR4_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR4_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR4_RANGE                 20:20
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR4_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR4_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR4_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR4_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR4_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR4_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR4_READY                 _MK_ENUM_CONST(1)

// Endpoint Transmit Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR3_SHIFT                 _MK_SHIFT_CONST(19)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR3_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR3_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR3_RANGE                 19:19
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR3_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR3_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR3_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR3_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR3_READY                 _MK_ENUM_CONST(1)

// Endpoint Transmit Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR2_SHIFT                 _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR2_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR2_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR2_RANGE                 18:18
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR2_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR2_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR2_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR2_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR2_READY                 _MK_ENUM_CONST(1)

// Endpoint Transmit Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR1_SHIFT                 _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR1_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR1_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR1_RANGE                 17:17
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR1_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR1_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR1_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR1_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR1_READY                 _MK_ENUM_CONST(1)

// Endpoint Transmit Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR0_SHIFT                 _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR0_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR0_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR0_RANGE                 16:16
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR0_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR0_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR0_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR0_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ETBR0_READY                 _MK_ENUM_CONST(1)

// Endpoint Receive Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR15_SHIFT                        _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR15_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR15_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR15_RANGE                        15:15
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR15_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR15_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR15_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR15_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR15_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR15_NOT_READY                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR15_READY                        _MK_ENUM_CONST(1)

// Endpoint Receive Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR14_SHIFT                        _MK_SHIFT_CONST(14)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR14_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR14_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR14_RANGE                        14:14
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR14_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR14_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR14_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR14_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR14_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR14_NOT_READY                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR14_READY                        _MK_ENUM_CONST(1)

// Endpoint Receive Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR13_SHIFT                        _MK_SHIFT_CONST(13)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR13_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR13_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR13_RANGE                        13:13
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR13_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR13_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR13_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR13_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR13_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR13_NOT_READY                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR13_READY                        _MK_ENUM_CONST(1)

// Endpoint Receive Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR12_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR12_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR12_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR12_RANGE                        12:12
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR12_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR12_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR12_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR12_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR12_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR12_NOT_READY                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR12_READY                        _MK_ENUM_CONST(1)

// Endpoint Receive Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR11_SHIFT                        _MK_SHIFT_CONST(11)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR11_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR11_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR11_RANGE                        11:11
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR11_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR11_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR11_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR11_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR11_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR11_NOT_READY                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR11_READY                        _MK_ENUM_CONST(1)

// Endpoint Receive Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR10_SHIFT                        _MK_SHIFT_CONST(10)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR10_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR10_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR10_RANGE                        10:10
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR10_WOFFSET                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR10_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR10_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR10_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR10_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR10_NOT_READY                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR10_READY                        _MK_ENUM_CONST(1)

// Endpoint Receive Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR9_SHIFT                 _MK_SHIFT_CONST(9)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR9_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR9_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR9_RANGE                 9:9
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR9_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR9_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR9_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR9_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR9_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR9_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR9_READY                 _MK_ENUM_CONST(1)

// Endpoint Receive Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR8_SHIFT                 _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR8_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR8_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR8_RANGE                 8:8
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR8_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR8_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR8_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR8_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR8_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR8_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR8_READY                 _MK_ENUM_CONST(1)

// Endpoint Receive Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR7_SHIFT                 _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR7_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR7_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR7_RANGE                 7:7
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR7_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR7_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR7_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR7_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR7_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR7_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR7_READY                 _MK_ENUM_CONST(1)

// Endpoint Receive Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR6_SHIFT                 _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR6_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR6_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR6_RANGE                 6:6
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR6_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR6_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR6_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR6_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR6_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR6_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR6_READY                 _MK_ENUM_CONST(1)

// Endpoint Receive Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR5_SHIFT                 _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR5_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR5_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR5_RANGE                 5:5
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR5_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR5_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR5_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR5_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR5_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR5_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR5_READY                 _MK_ENUM_CONST(1)

// Endpoint Receive Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR4_SHIFT                 _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR4_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR4_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR4_RANGE                 4:4
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR4_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR4_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR4_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR4_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR4_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR4_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR4_READY                 _MK_ENUM_CONST(1)

// Endpoint Receive Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR3_SHIFT                 _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR3_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR3_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR3_RANGE                 3:3
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR3_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR3_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR3_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR3_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR3_READY                 _MK_ENUM_CONST(1)

// Endpoint Receive Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR2_SHIFT                 _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR2_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR2_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR2_RANGE                 2:2
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR2_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR2_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR2_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR2_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR2_READY                 _MK_ENUM_CONST(1)

// Endpoint Receive Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR1_SHIFT                 _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR1_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR1_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR1_RANGE                 1:1
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR1_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR1_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR1_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR1_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR1_READY                 _MK_ENUM_CONST(1)

// Endpoint Receive Buffer Ready:
// One bit for each endpoint indicates status of the respective endpoint buffer. This bit is set to a one by the hardware as a response to receiving a command from a corresponding bit in the ENDPTPRIME register. There will always be a delay between setting a bit in the ENDPTPRIME register and endpoint indicating ready. This delay ime varies based upon the current USB traffic and the number of bits set in the ENDPTPRIME register. Buffer ready is cleared by USB reset, by the USB DMA system, or through the ENDPTFLUSH register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR0_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR0_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR0_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR0_RANGE                 0:0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR0_WOFFSET                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR0_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR0_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR0_NOT_READY                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTSTATUS_0_ERBR0_READY                 _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0  
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0                   _MK_ADDR_CONST(0x1bc)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_SECURE                    0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_WORD_COUNT                        0x1
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// Endpoint Transmit Complete Event:
// Each bit indicates a transmit event (IN/INTERRUPT) occurred and software should read the corresponding endpoint queue to determine the endpoint status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE15_SHIFT                      _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE15_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE15_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE15_RANGE                      31:31
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE15_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE15_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE15_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE15_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE15_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE15_NOT_COMPLETE                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE15_COMPLETE                   _MK_ENUM_CONST(1)

// Endpoint Transmit Complete Event:
// Each bit indicates a transmit event (IN/INTERRUPT) occurred and software should read the corresponding endpoint queue to determine the endpoint status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE14_SHIFT                      _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE14_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE14_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE14_RANGE                      30:30
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE14_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE14_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE14_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE14_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE14_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE14_NOT_COMPLETE                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE14_COMPLETE                   _MK_ENUM_CONST(1)

// Endpoint Transmit Complete Event:
// Each bit indicates a transmit event (IN/INTERRUPT) occurred and software should read the corresponding endpoint queue to determine the endpoint status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE13_SHIFT                      _MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE13_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE13_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE13_RANGE                      29:29
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE13_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE13_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE13_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE13_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE13_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE13_NOT_COMPLETE                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE13_COMPLETE                   _MK_ENUM_CONST(1)

// Endpoint Transmit Complete Event:
// Each bit indicates a transmit event (IN/INTERRUPT) occurred and software should read the corresponding endpoint queue to determine the endpoint status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE12_SHIFT                      _MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE12_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE12_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE12_RANGE                      28:28
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE12_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE12_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE12_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE12_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE12_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE12_NOT_COMPLETE                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE12_COMPLETE                   _MK_ENUM_CONST(1)

// Endpoint Transmit Complete Event:
// Each bit indicates a transmit event (IN/INTERRUPT) occurred and software should read the corresponding endpoint queue to determine the endpoint status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE11_SHIFT                      _MK_SHIFT_CONST(27)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE11_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE11_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE11_RANGE                      27:27
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE11_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE11_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE11_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE11_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE11_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE11_NOT_COMPLETE                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE11_COMPLETE                   _MK_ENUM_CONST(1)

// Endpoint Transmit Complete Event:
// Each bit indicates a transmit event (IN/INTERRUPT) occurred and software should read the corresponding endpoint queue to determine the endpoint status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE10_SHIFT                      _MK_SHIFT_CONST(26)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE10_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE10_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE10_RANGE                      26:26
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE10_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE10_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE10_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE10_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE10_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE10_NOT_COMPLETE                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE10_COMPLETE                   _MK_ENUM_CONST(1)

// Endpoint Transmit Complete Event:
// Each bit indicates a transmit event (IN/INTERRUPT) occurred and software should read the corresponding endpoint queue to determine the endpoint status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE9_SHIFT                       _MK_SHIFT_CONST(25)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE9_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE9_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE9_RANGE                       25:25
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE9_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE9_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE9_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE9_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE9_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE9_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE9_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Transmit Complete Event:
// Each bit indicates a transmit event (IN/INTERRUPT) occurred and software should read the corresponding endpoint queue to determine the endpoint status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE8_SHIFT                       _MK_SHIFT_CONST(24)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE8_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE8_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE8_RANGE                       24:24
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE8_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE8_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE8_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE8_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE8_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE8_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE8_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Transmit Complete Event:
// Each bit indicates a transmit event (IN/INTERRUPT) occurred and software should read the corresponding endpoint queue to determine the endpoint status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE7_SHIFT                       _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE7_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE7_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE7_RANGE                       23:23
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE7_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE7_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE7_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE7_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE7_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE7_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE7_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Transmit Complete Event:
// Each bit indicates a transmit event (IN/INTERRUPT) occurred and software should read the corresponding endpoint queue to determine the endpoint status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE6_SHIFT                       _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE6_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE6_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE6_RANGE                       22:22
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE6_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE6_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE6_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE6_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE6_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE6_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE6_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Transmit Complete Event:
// Each bit indicates a transmit event (IN/INTERRUPT) occurred and software should read the corresponding endpoint queue to determine the endpoint status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE5_SHIFT                       _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE5_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE5_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE5_RANGE                       21:21
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE5_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE5_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE5_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE5_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE5_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE5_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE5_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Transmit Complete Event:
// Each bit indicates a transmit event (IN/INTERRUPT) occurred and software should read the corresponding endpoint queue to determine the endpoint status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE4_SHIFT                       _MK_SHIFT_CONST(20)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE4_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE4_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE4_RANGE                       20:20
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE4_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE4_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE4_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE4_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE4_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE4_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE4_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Transmit Complete Event:
// Each bit indicates a transmit event (IN/INTERRUPT) occurred and software should read the corresponding endpoint queue to determine the endpoint status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE3_SHIFT                       _MK_SHIFT_CONST(19)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE3_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE3_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE3_RANGE                       19:19
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE3_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE3_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE3_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE3_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE3_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE3_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE3_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Transmit Complete Event:
// Each bit indicates a transmit event (IN/INTERRUPT) occurred and software should read the corresponding endpoint queue to determine the endpoint status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE2_SHIFT                       _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE2_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE2_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE2_RANGE                       18:18
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE2_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE2_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE2_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE2_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Transmit Complete Event:
// Each bit indicates a transmit event (IN/INTERRUPT) occurred and software should read the corresponding endpoint queue to determine the endpoint status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE1_SHIFT                       _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE1_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE1_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE1_RANGE                       17:17
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE1_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE1_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE1_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE1_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Transmit Complete Event:
// Each bit indicates a transmit event (IN/INTERRUPT) occurred and software should read the corresponding endpoint queue to determine the endpoint status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register. 
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE0_SHIFT                       _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE0_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE0_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE0_RANGE                       16:16
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE0_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE0_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE0_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ETCE0_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Receive Complete Event:
// Each bit indicates a received event (OUT/SETUP) occurred and software should read the corresponding endpoint queue to determine the transfer status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE15_SHIFT                      _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE15_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE15_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE15_RANGE                      15:15
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE15_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE15_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE15_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE15_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE15_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE15_NOT_COMPLETE                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE15_COMPLETE                   _MK_ENUM_CONST(1)

// Endpoint Receive Complete Event:
// Each bit indicates a received event (OUT/SETUP) occurred and software should read the corresponding endpoint queue to determine the transfer status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE14_SHIFT                      _MK_SHIFT_CONST(14)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE14_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE14_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE14_RANGE                      14:14
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE14_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE14_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE14_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE14_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE14_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE14_NOT_COMPLETE                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE14_COMPLETE                   _MK_ENUM_CONST(1)

// Endpoint Receive Complete Event:
// Each bit indicates a received event (OUT/SETUP) occurred and software should read the corresponding endpoint queue to determine the transfer status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE13_SHIFT                      _MK_SHIFT_CONST(13)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE13_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE13_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE13_RANGE                      13:13
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE13_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE13_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE13_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE13_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE13_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE13_NOT_COMPLETE                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE13_COMPLETE                   _MK_ENUM_CONST(1)

// Endpoint Receive Complete Event:
// Each bit indicates a received event (OUT/SETUP) occurred and software should read the corresponding endpoint queue to determine the transfer status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE12_SHIFT                      _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE12_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE12_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE12_RANGE                      12:12
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE12_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE12_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE12_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE12_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE12_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE12_NOT_COMPLETE                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE12_COMPLETE                   _MK_ENUM_CONST(1)

// Endpoint Receive Complete Event:
// Each bit indicates a received event (OUT/SETUP) occurred and software should read the corresponding endpoint queue to determine the transfer status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE11_SHIFT                      _MK_SHIFT_CONST(11)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE11_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE11_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE11_RANGE                      11:11
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE11_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE11_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE11_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE11_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE11_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE11_NOT_COMPLETE                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE11_COMPLETE                   _MK_ENUM_CONST(1)

// Endpoint Receive Complete Event:
// Each bit indicates a received event (OUT/SETUP) occurred and software should read the corresponding endpoint queue to determine the transfer status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE10_SHIFT                      _MK_SHIFT_CONST(10)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE10_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE10_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE10_RANGE                      10:10
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE10_WOFFSET                    0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE10_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE10_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE10_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE10_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE10_NOT_COMPLETE                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE10_COMPLETE                   _MK_ENUM_CONST(1)

// Endpoint Receive Complete Event:
// Each bit indicates a received event (OUT/SETUP) occurred and software should read the corresponding endpoint queue to determine the transfer status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE9_SHIFT                       _MK_SHIFT_CONST(9)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE9_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE9_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE9_RANGE                       9:9
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE9_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE9_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE9_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE9_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE9_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE9_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE9_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Receive Complete Event:
// Each bit indicates a received event (OUT/SETUP) occurred and software should read the corresponding endpoint queue to determine the transfer status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE8_SHIFT                       _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE8_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE8_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE8_RANGE                       8:8
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE8_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE8_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE8_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE8_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE8_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE8_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE8_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Receive Complete Event:
// Each bit indicates a received event (OUT/SETUP) occurred and software should read the corresponding endpoint queue to determine the transfer status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE7_SHIFT                       _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE7_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE7_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE7_RANGE                       7:7
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE7_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE7_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE7_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE7_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE7_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE7_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE7_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Receive Complete Event:
// Each bit indicates a received event (OUT/SETUP) occurred and software should read the corresponding endpoint queue to determine the transfer status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE6_SHIFT                       _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE6_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE6_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE6_RANGE                       6:6
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE6_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE6_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE6_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE6_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE6_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE6_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE6_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Receive Complete Event:
// Each bit indicates a received event (OUT/SETUP) occurred and software should read the corresponding endpoint queue to determine the transfer status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE5_SHIFT                       _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE5_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE5_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE5_RANGE                       5:5
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE5_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE5_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE5_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE5_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE5_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE5_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE5_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Receive Complete Event:
// Each bit indicates a received event (OUT/SETUP) occurred and software should read the corresponding endpoint queue to determine the transfer status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE4_SHIFT                       _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE4_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE4_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE4_RANGE                       4:4
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE4_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE4_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE4_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE4_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE4_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE4_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE4_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Receive Complete Event:
// Each bit indicates a received event (OUT/SETUP) occurred and software should read the corresponding endpoint queue to determine the transfer status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE3_SHIFT                       _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE3_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE3_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE3_RANGE                       3:3
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE3_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE3_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE3_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE3_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE3_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE3_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE3_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Receive Complete Event:
// Each bit indicates a received event (OUT/SETUP) occurred and software should read the corresponding endpoint queue to determine the transfer status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE2_SHIFT                       _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE2_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE2_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE2_RANGE                       2:2
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE2_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE2_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE2_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE2_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Receive Complete Event:
// Each bit indicates a received event (OUT/SETUP) occurred and software should read the corresponding endpoint queue to determine the transfer status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE1_SHIFT                       _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE1_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE1_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE1_RANGE                       1:1
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE1_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE1_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE1_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE1_COMPLETE                    _MK_ENUM_CONST(1)

// Endpoint Receive Complete Event:
// Each bit indicates a received event (OUT/SETUP) occurred and software should read the corresponding endpoint queue to determine the transfer status. If the corresponding IOC bit is set in the Transfer Descriptor, then this bit will be set simultaneously with the USBINT. Writing a one clears the corresponding bit in this register.
// This is only used in device mode.
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE0_SHIFT                       _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE0_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE0_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE0_RANGE                       0:0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE0_WOFFSET                     0x0
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE0_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE0_NOT_COMPLETE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCOMPLETE_0_ERCE0_COMPLETE                    _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCTRL0_0  
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0                      _MK_ADDR_CONST(0x1c0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_SECURE                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_WORD_COUNT                   0x1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RESET_VAL                    _MK_MASK_CONST(0x800080)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RESET_MASK                   _MK_MASK_CONST(0x8d008d)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_READ_MASK                    _MK_MASK_CONST(0x8d008d)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
// TX Endpoint Enable. Endpoint 0 is always  enabled. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXE_SHIFT                    _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXE_RANGE                    23:23
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXE_DEFAULT                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXE_ENABLE                   _MK_ENUM_CONST(1)

// TX Endpoint Type. Endpoint0 is fixed as a Control Endpoint. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXT_SHIFT                    _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXT_RANGE                    19:18
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXT_INTR                     _MK_ENUM_CONST(3)

// TX Endpoint Stall: Software can write a one to this bit to force the  endpoint to return a STALL handshake to the Host. It will continue returning  STALL until the bit is cleared by software or it will automatically be  cleared upon receipt of a new SETUP request. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXS_SHIFT                    _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXS_RANGE                    16:16
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_TXS_EP_STALL                 _MK_ENUM_CONST(1)

//  RX Endpoint Enable. Endpoint 0 is always  enabled. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXE_SHIFT                    _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXE_RANGE                    7:7
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXE_DEFAULT                  _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXE_ENABLE                   _MK_ENUM_CONST(1)

// RX Endpoint Type. Endpoint 0 is fixed as a Control Endpoint. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXT_SHIFT                    _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXT_RANGE                    3:2
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXT_INTR                     _MK_ENUM_CONST(3)

// RX Endpoint Stall: Software can write a one to this bit to force the  endpoint to return a STALL handshake to the Host. It will continue returning  STALL until the bit is cleared by software or it will automatically be  cleared upon receipt of a new SETUP request. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXS_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXS_RANGE                    0:0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL0_0_RXS_EP_STALL                 _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCTRL1_0  
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0                      _MK_ADDR_CONST(0x1c4)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_SECURE                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_WORD_COUNT                   0x1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RESET_MASK                   _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_READ_MASK                    _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_WRITE_MASK                   _MK_MASK_CONST(0xed00ed)
// TX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXE_SHIFT                    _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXE_RANGE                    23:23
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXE_ENABLE                   _MK_ENUM_CONST(1)

// TX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint software must write a one to this bit in order to synchronize  the data PIDs between the Host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXR_SHIFT                    _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXR_RANGE                    22:22
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// TX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always transmit DATA0 for a data packet. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXI_SHIFT                    _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXI_RANGE                    21:21
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// TX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXT_SHIFT                    _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXT_RANGE                    19:18
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXD_SHIFT                    _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXD_RANGE                    17:17
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// TX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt of a SETUP request if this  Endpoint is configured as a Control Endpoint. Software can write a one to  this bit to force the endpoint to return a STALL handshake to the Host. It  will continue to returning STALL until this bit is either cleared by software  or automatically cleared as above. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXS_SHIFT                    _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXS_RANGE                    16:16
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_TXS_EP_STALL                 _MK_ENUM_CONST(1)

// RX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXE_SHIFT                    _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXE_RANGE                    7:7
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXE_ENABLE                   _MK_ENUM_CONST(1)

// RX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint, software must write a one to this bit in order to synchronize  the data PIDs between the host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXR_SHIFT                    _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXR_RANGE                    6:6
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// RX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always accept data packet regardless of  their data PID. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXI_SHIFT                    _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXI_RANGE                    5:5
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// RX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXT_SHIFT                    _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXT_RANGE                    3:2
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXD_SHIFT                    _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXD_RANGE                    1:1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// RX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt a SETUP request if this Endpoint  is configured as a Control Endpoint, Software can write a one to this bit to  force the endpoint to return a STALL handshake to the Host. It will continue  to returning STALL until this bit is either cleared by software or  automatically cleared as above, 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXS_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXS_RANGE                    0:0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL1_0_RXS_EP_STALL                 _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCTRL2_0  
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0                      _MK_ADDR_CONST(0x1c8)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_SECURE                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_WORD_COUNT                   0x1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RESET_MASK                   _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_READ_MASK                    _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_WRITE_MASK                   _MK_MASK_CONST(0xed00ed)
// TX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXE_SHIFT                    _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXE_RANGE                    23:23
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXE_ENABLE                   _MK_ENUM_CONST(1)

// TX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint software must write a one to this bit in order to synchronize  the data PIDs between the Host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXR_SHIFT                    _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXR_RANGE                    22:22
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// TX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always transmit DATA0 for a data packet. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXI_SHIFT                    _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXI_RANGE                    21:21
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// TX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXT_SHIFT                    _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXT_RANGE                    19:18
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXD_SHIFT                    _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXD_RANGE                    17:17
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// TX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt of a SETUP request if this  Endpoint is configured as a Control Endpoint. Software can write a one to  this bit to force the endpoint to return a STALL handshake to the Host. It  will continue to returning STALL until this bit is either cleared by software  or automatically cleared as above. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXS_SHIFT                    _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXS_RANGE                    16:16
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_TXS_EP_STALL                 _MK_ENUM_CONST(1)

// RX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXE_SHIFT                    _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXE_RANGE                    7:7
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXE_ENABLE                   _MK_ENUM_CONST(1)

// RX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint, software must write a one to this bit in order to synchronize  the data PIDs between the host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXR_SHIFT                    _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXR_RANGE                    6:6
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// RX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always accept data packet regardless of  their data PID. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXI_SHIFT                    _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXI_RANGE                    5:5
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// RX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXT_SHIFT                    _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXT_RANGE                    3:2
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXD_SHIFT                    _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXD_RANGE                    1:1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// RX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt a SETUP request if this Endpoint  is configured as a Control Endpoint, Software can write a one to this bit to  force the endpoint to return a STALL handshake to the Host. It will continue  to returning STALL until this bit is either cleared by software or  automatically cleared as above.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXS_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXS_RANGE                    0:0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL2_0_RXS_EP_STALL                 _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCTRL3_0  
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0                      _MK_ADDR_CONST(0x1cc)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_SECURE                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_WORD_COUNT                   0x1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RESET_MASK                   _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_READ_MASK                    _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_WRITE_MASK                   _MK_MASK_CONST(0xed00ed)
// TX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXE_SHIFT                    _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXE_RANGE                    23:23
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXE_ENABLE                   _MK_ENUM_CONST(1)

// TX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint software must write a one to this bit in order to synchronize  the data PIDs between the Host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXR_SHIFT                    _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXR_RANGE                    22:22
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// TX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always transmit DATA0 for a data packet. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXI_SHIFT                    _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXI_RANGE                    21:21
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// TX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXT_SHIFT                    _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXT_RANGE                    19:18
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXD_SHIFT                    _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXD_RANGE                    17:17
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// TX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt of a SETUP request if this  Endpoint is configured as a Control Endpoint. Software can write a one to  this bit to force the endpoint to return a STALL handshake to the Host. It  will continue to returning STALL until this bit is either cleared by software  or automatically cleared as above. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXS_SHIFT                    _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXS_RANGE                    16:16
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_TXS_EP_STALL                 _MK_ENUM_CONST(1)

// RX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXE_SHIFT                    _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXE_RANGE                    7:7
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXE_ENABLE                   _MK_ENUM_CONST(1)

// RX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint, software must write a one to this bit in order to synchronize  the data PIDs between the host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXR_SHIFT                    _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXR_RANGE                    6:6
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// RX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always accept data packet regardless of  their data PID. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXI_SHIFT                    _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXI_RANGE                    5:5
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// RX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXT_SHIFT                    _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXT_RANGE                    3:2
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXD_SHIFT                    _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXD_RANGE                    1:1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// RX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt a SETUP request if this Endpoint  is configured as a Control Endpoint, Software can write a one to this bit to  force the endpoint to return a STALL handshake to the Host. It will continue  to returning STALL until this bit is either cleared by software or  automatically cleared as above.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXS_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXS_RANGE                    0:0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL3_0_RXS_EP_STALL                 _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCTRL4_0  
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0                      _MK_ADDR_CONST(0x1d0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_SECURE                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_WORD_COUNT                   0x1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RESET_MASK                   _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_READ_MASK                    _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_WRITE_MASK                   _MK_MASK_CONST(0xed00ed)
// TX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXE_SHIFT                    _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXE_RANGE                    23:23
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXE_ENABLE                   _MK_ENUM_CONST(1)

// TX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint software must write a one to this bit in order to synchronize  the data PIDs between the Host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXR_SHIFT                    _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXR_RANGE                    22:22
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// TX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always transmit DATA0 for a data packet. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXI_SHIFT                    _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXI_RANGE                    21:21
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// TX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXT_SHIFT                    _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXT_RANGE                    19:18
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXD_SHIFT                    _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXD_RANGE                    17:17
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// TX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt of a SETUP request if this  Endpoint is configured as a Control Endpoint. Software can write a one to  this bit to force the endpoint to return a STALL handshake to the Host. It  will continue to returning STALL until this bit is either cleared by software  or automatically cleared as above. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXS_SHIFT                    _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXS_RANGE                    16:16
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_TXS_EP_STALL                 _MK_ENUM_CONST(1)

// RX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXE_SHIFT                    _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXE_RANGE                    7:7
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXE_ENABLE                   _MK_ENUM_CONST(1)

// RX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint, software must write a one to this bit in order to synchronize  the data PIDs between the host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXR_SHIFT                    _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXR_RANGE                    6:6
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// RX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always accept data packet regardless of  their data PID. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXI_SHIFT                    _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXI_RANGE                    5:5
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// RX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXT_SHIFT                    _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXT_RANGE                    3:2
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXD_SHIFT                    _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXD_RANGE                    1:1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// RX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt a SETUP request if this Endpoint  is configured as a Control Endpoint, Software can write a one to this bit to  force the endpoint to return a STALL handshake to the Host. It will continue  to returning STALL until this bit is either cleared by software or  automatically cleared as above.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXS_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXS_RANGE                    0:0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL4_0_RXS_EP_STALL                 _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCTRL5_0  
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0                      _MK_ADDR_CONST(0x1d4)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_SECURE                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_WORD_COUNT                   0x1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RESET_MASK                   _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_READ_MASK                    _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_WRITE_MASK                   _MK_MASK_CONST(0xed00ed)
// TX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXE_SHIFT                    _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXE_RANGE                    23:23
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXE_ENABLE                   _MK_ENUM_CONST(1)

// TX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint software must write a one to this bit in order to synchronize  the data PIDs between the Host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXR_SHIFT                    _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXR_RANGE                    22:22
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// TX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always transmit DATA0 for a data packet. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXI_SHIFT                    _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXI_RANGE                    21:21
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// TX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXT_SHIFT                    _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXT_RANGE                    19:18
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXD_SHIFT                    _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXD_RANGE                    17:17
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// TX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt of a SETUP request if this  Endpoint is configured as a Control Endpoint. Software can write a one to  this bit to force the endpoint to return a STALL handshake to the Host. It  will continue to returning STALL until this bit is either cleared by software  or automatically cleared as above. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXS_SHIFT                    _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXS_RANGE                    16:16
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_TXS_EP_STALL                 _MK_ENUM_CONST(1)

// RX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXE_SHIFT                    _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXE_RANGE                    7:7
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXE_ENABLE                   _MK_ENUM_CONST(1)

// RX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint, software must write a one to this bit in order to synchronize  the data PIDs between the host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXR_SHIFT                    _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXR_RANGE                    6:6
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// RX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always accept data packet regardless of  their data PID. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXI_SHIFT                    _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXI_RANGE                    5:5
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// RX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXT_SHIFT                    _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXT_RANGE                    3:2
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXD_SHIFT                    _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXD_RANGE                    1:1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// RX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt a SETUP request if this Endpoint  is configured as a Control Endpoint, Software can write a one to this bit to  force the endpoint to return a STALL handshake to the Host. It will continue  to returning STALL until this bit is either cleared by software or  automatically cleared as above.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXS_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXS_RANGE                    0:0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL5_0_RXS_EP_STALL                 _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCTRL6_0  
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0                      _MK_ADDR_CONST(0x1d8)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_SECURE                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_WORD_COUNT                   0x1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RESET_MASK                   _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_READ_MASK                    _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_WRITE_MASK                   _MK_MASK_CONST(0xed00ed)
// TX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXE_SHIFT                    _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXE_RANGE                    23:23
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXE_ENABLE                   _MK_ENUM_CONST(1)

// TX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint software must write a one to this bit in order to synchronize  the data PIDs between the Host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXR_SHIFT                    _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXR_RANGE                    22:22
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// TX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always transmit DATA0 for a data packet. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXI_SHIFT                    _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXI_RANGE                    21:21
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// TX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXT_SHIFT                    _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXT_RANGE                    19:18
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXD_SHIFT                    _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXD_RANGE                    17:17
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// TX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt of a SETUP request if this  Endpoint is configured as a Control Endpoint. Software can write a one to  this bit to force the endpoint to return a STALL handshake to the Host. It  will continue to returning STALL until this bit is either cleared by software  or automatically cleared as above. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXS_SHIFT                    _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXS_RANGE                    16:16
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_TXS_EP_STALL                 _MK_ENUM_CONST(1)

// RX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXE_SHIFT                    _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXE_RANGE                    7:7
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXE_ENABLE                   _MK_ENUM_CONST(1)

// RX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint, software must write a one to this bit in order to synchronize  the data PIDs between the host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXR_SHIFT                    _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXR_RANGE                    6:6
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// RX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always accept data packet regardless of  their data PID. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXI_SHIFT                    _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXI_RANGE                    5:5
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// RX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXT_SHIFT                    _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXT_RANGE                    3:2
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXD_SHIFT                    _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXD_RANGE                    1:1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// RX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt a SETUP request if this Endpoint  is configured as a Control Endpoint, Software can write a one to this bit to  force the endpoint to return a STALL handshake to the Host. It will continue  to returning STALL until this bit is either cleared by software or  automatically cleared as above.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXS_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXS_RANGE                    0:0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL6_0_RXS_EP_STALL                 _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCTRL7_0  
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0                      _MK_ADDR_CONST(0x1dc)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_SECURE                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_WORD_COUNT                   0x1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RESET_MASK                   _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_READ_MASK                    _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_WRITE_MASK                   _MK_MASK_CONST(0xed00ed)
// TX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXE_SHIFT                    _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXE_RANGE                    23:23
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXE_ENABLE                   _MK_ENUM_CONST(1)

// TX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint software must write a one to this bit in order to synchronize  the data PIDs between the Host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXR_SHIFT                    _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXR_RANGE                    22:22
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// TX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always transmit DATA0 for a data packet. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXI_SHIFT                    _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXI_RANGE                    21:21
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// TX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXT_SHIFT                    _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXT_RANGE                    19:18
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXD_SHIFT                    _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXD_RANGE                    17:17
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// TX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt of a SETUP request if this  Endpoint is configured as a Control Endpoint. Software can write a one to  this bit to force the endpoint to return a STALL handshake to the Host. It  will continue to returning STALL until this bit is either cleared by software  or automatically cleared as above. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXS_SHIFT                    _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXS_RANGE                    16:16
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_TXS_EP_STALL                 _MK_ENUM_CONST(1)

// RX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXE_SHIFT                    _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXE_RANGE                    7:7
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXE_ENABLE                   _MK_ENUM_CONST(1)

// RX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint, software must write a one to this bit in order to synchronize  the data PIDs between the host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXR_SHIFT                    _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXR_RANGE                    6:6
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// RX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always accept data packet regardless of  their data PID. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXI_SHIFT                    _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXI_RANGE                    5:5
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// RX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXT_SHIFT                    _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXT_RANGE                    3:2
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXD_SHIFT                    _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXD_RANGE                    1:1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// RX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt a SETUP request if this Endpoint  is configured as a Control Endpoint, Software can write a one to this bit to  force the endpoint to return a STALL handshake to the Host. It will continue  to returning STALL until this bit is either cleared by software or  automatically cleared as above.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXS_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXS_RANGE                    0:0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL7_0_RXS_EP_STALL                 _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCTRL8_0  
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0                      _MK_ADDR_CONST(0x1e0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_SECURE                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_WORD_COUNT                   0x1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RESET_MASK                   _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_READ_MASK                    _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_WRITE_MASK                   _MK_MASK_CONST(0xed00ed)
// TX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXE_SHIFT                    _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXE_RANGE                    23:23
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXE_ENABLE                   _MK_ENUM_CONST(1)

// TX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint software must write a one to this bit in order to synchronize  the data PIDs between the Host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXR_SHIFT                    _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXR_RANGE                    22:22
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// TX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always transmit DATA0 for a data packet. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXI_SHIFT                    _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXI_RANGE                    21:21
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// TX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXT_SHIFT                    _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXT_RANGE                    19:18
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXD_SHIFT                    _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXD_RANGE                    17:17
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// TX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt of a SETUP request if this  Endpoint is configured as a Control Endpoint. Software can write a one to  this bit to force the endpoint to return a STALL handshake to the Host. It  will continue to returning STALL until this bit is either cleared by software  or automatically cleared as above. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXS_SHIFT                    _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXS_RANGE                    16:16
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_TXS_EP_STALL                 _MK_ENUM_CONST(1)

// RX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXE_SHIFT                    _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXE_RANGE                    7:7
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXE_ENABLE                   _MK_ENUM_CONST(1)

// RX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint, software must write a one to this bit in order to synchronize  the data PIDs between the host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXR_SHIFT                    _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXR_RANGE                    6:6
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// RX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always accept data packet regardless of  their data PID. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXI_SHIFT                    _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXI_RANGE                    5:5
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// RX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXT_SHIFT                    _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXT_RANGE                    3:2
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXD_SHIFT                    _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXD_RANGE                    1:1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// RX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt a SETUP request if this Endpoint  is configured as a Control Endpoint, Software can write a one to this bit to  force the endpoint to return a STALL handshake to the Host. It will continue  to returning STALL until this bit is either cleared by software or  automatically cleared as above.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXS_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXS_RANGE                    0:0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL8_0_RXS_EP_STALL                 _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCTRL9_0  
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0                      _MK_ADDR_CONST(0x1e4)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_SECURE                       0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_WORD_COUNT                   0x1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RESET_MASK                   _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_READ_MASK                    _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_WRITE_MASK                   _MK_MASK_CONST(0xed00ed)
// TX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXE_SHIFT                    _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXE_RANGE                    23:23
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXE_ENABLE                   _MK_ENUM_CONST(1)

// TX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint software must write a one to this bit in order to synchronize  the data PIDs between the Host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXR_SHIFT                    _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXR_RANGE                    22:22
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// TX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always transmit DATA0 for a data packet. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXI_SHIFT                    _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXI_RANGE                    21:21
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// TX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXT_SHIFT                    _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXT_RANGE                    19:18
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXD_SHIFT                    _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXD_RANGE                    17:17
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// TX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt of a SETUP request if this  Endpoint is configured as a Control Endpoint. Software can write a one to  this bit to force the endpoint to return a STALL handshake to the Host. It  will continue to returning STALL until this bit is either cleared by software  or automatically cleared as above. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXS_SHIFT                    _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXS_RANGE                    16:16
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_TXS_EP_STALL                 _MK_ENUM_CONST(1)

// RX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXE_SHIFT                    _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXE_RANGE                    7:7
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXE_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXE_ENABLE                   _MK_ENUM_CONST(1)

// RX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint, software must write a one to this bit in order to synchronize  the data PIDs between the host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXR_SHIFT                    _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXR_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXR_RANGE                    6:6
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXR_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXR_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXR_KEEP_GOING                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXR_RESET_PID_SEQ                    _MK_ENUM_CONST(1)

// RX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always accept data packet regardless of  their data PID. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXI_SHIFT                    _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXI_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXI_RANGE                    5:5
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXI_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXI_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXI_DIS_PID_SEQ                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXI_ENB_PID_SEQ                      _MK_ENUM_CONST(1)

// RX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXT_SHIFT                    _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXT_RANGE                    3:2
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXT_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXT_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXT_CTRL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXT_ISO                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXT_BULK                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXT_INTR                     _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXD_SHIFT                    _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXD_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXD_RANGE                    1:1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXD_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXD_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// RX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt a SETUP request if this Endpoint  is configured as a Control Endpoint, Software can write a one to this bit to  force the endpoint to return a STALL handshake to the Host. It will continue  to returning STALL until this bit is either cleared by software or  automatically cleared as above.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXS_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXS_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXS_RANGE                    0:0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXS_WOFFSET                  0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXS_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXS_EP_OK                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL9_0_RXS_EP_STALL                 _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCTRL10_0  
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0                     _MK_ADDR_CONST(0x1e8)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_SECURE                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_WORD_COUNT                  0x1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RESET_MASK                  _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_READ_MASK                   _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_WRITE_MASK                  _MK_MASK_CONST(0xed00ed)
// TX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXE_SHIFT                   _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXE_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXE_RANGE                   23:23
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXE_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXE_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXE_DISABLE                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXE_ENABLE                  _MK_ENUM_CONST(1)

// TX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint software must write a one to this bit in order to synchronize  the data PIDs between the Host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXR_SHIFT                   _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXR_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXR_RANGE                   22:22
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXR_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXR_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXR_KEEP_GOING                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXR_RESET_PID_SEQ                   _MK_ENUM_CONST(1)

// TX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always transmit DATA0 for a data packet. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXI_SHIFT                   _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXI_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXI_RANGE                   21:21
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXI_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXI_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXI_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXI_DIS_PID_SEQ                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXI_ENB_PID_SEQ                     _MK_ENUM_CONST(1)

// TX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXT_SHIFT                   _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXT_FIELD                   (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXT_RANGE                   19:18
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXT_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXT_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXT_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXT_CTRL                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXT_ISO                     _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXT_BULK                    _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXT_INTR                    _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXD_SHIFT                   _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXD_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXD_RANGE                   17:17
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXD_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXD_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// TX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt of a SETUP request if this  Endpoint is configured as a Control Endpoint. Software can write a one to  this bit to force the endpoint to return a STALL handshake to the Host. It  will continue to returning STALL until this bit is either cleared by software  or automatically cleared as above. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXS_SHIFT                   _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXS_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXS_RANGE                   16:16
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXS_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXS_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXS_EP_OK                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_TXS_EP_STALL                        _MK_ENUM_CONST(1)

// RX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXE_SHIFT                   _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXE_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXE_RANGE                   7:7
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXE_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXE_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXE_DISABLE                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXE_ENABLE                  _MK_ENUM_CONST(1)

// RX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint, software must write a one to this bit in order to synchronize  the data PIDs between the host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXR_SHIFT                   _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXR_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXR_RANGE                   6:6
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXR_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXR_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXR_KEEP_GOING                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXR_RESET_PID_SEQ                   _MK_ENUM_CONST(1)

// RX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always accept data packet regardless of  their data PID. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXI_SHIFT                   _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXI_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXI_RANGE                   5:5
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXI_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXI_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXI_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXI_DIS_PID_SEQ                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXI_ENB_PID_SEQ                     _MK_ENUM_CONST(1)

// RX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXT_SHIFT                   _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXT_FIELD                   (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXT_RANGE                   3:2
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXT_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXT_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXT_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXT_CTRL                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXT_ISO                     _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXT_BULK                    _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXT_INTR                    _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXD_SHIFT                   _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXD_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXD_RANGE                   1:1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXD_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXD_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// RX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt a SETUP request if this Endpoint  is configured as a Control Endpoint, Software can write a one to this bit to  force the endpoint to return a STALL handshake to the Host. It will continue  to returning STALL until this bit is either cleared by software or  automatically cleared as above.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXS_SHIFT                   _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXS_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXS_RANGE                   0:0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXS_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXS_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXS_EP_OK                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL10_0_RXS_EP_STALL                        _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCTRL11_0  
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0                     _MK_ADDR_CONST(0x1ec)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_SECURE                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_WORD_COUNT                  0x1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RESET_MASK                  _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_READ_MASK                   _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_WRITE_MASK                  _MK_MASK_CONST(0xed00ed)
// TX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXE_SHIFT                   _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXE_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXE_RANGE                   23:23
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXE_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXE_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXE_DISABLE                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXE_ENABLE                  _MK_ENUM_CONST(1)

// TX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint software must write a one to this bit in order to synchronize  the data PIDs between the Host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXR_SHIFT                   _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXR_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXR_RANGE                   22:22
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXR_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXR_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXR_KEEP_GOING                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXR_RESET_PID_SEQ                   _MK_ENUM_CONST(1)

// TX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always transmit DATA0 for a data packet. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXI_SHIFT                   _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXI_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXI_RANGE                   21:21
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXI_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXI_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXI_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXI_DIS_PID_SEQ                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXI_ENB_PID_SEQ                     _MK_ENUM_CONST(1)

// TX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXT_SHIFT                   _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXT_FIELD                   (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXT_RANGE                   19:18
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXT_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXT_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXT_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXT_CTRL                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXT_ISO                     _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXT_BULK                    _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXT_INTR                    _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXD_SHIFT                   _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXD_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXD_RANGE                   17:17
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXD_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXD_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// TX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt of a SETUP request if this  Endpoint is configured as a Control Endpoint. Software can write a one to  this bit to force the endpoint to return a STALL handshake to the Host. It  will continue to returning STALL until this bit is either cleared by software  or automatically cleared as above. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXS_SHIFT                   _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXS_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXS_RANGE                   16:16
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXS_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXS_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXS_EP_OK                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_TXS_EP_STALL                        _MK_ENUM_CONST(1)

// RX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXE_SHIFT                   _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXE_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXE_RANGE                   7:7
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXE_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXE_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXE_DISABLE                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXE_ENABLE                  _MK_ENUM_CONST(1)

// RX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint, software must write a one to this bit in order to synchronize  the data PIDs between the host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXR_SHIFT                   _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXR_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXR_RANGE                   6:6
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXR_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXR_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXR_KEEP_GOING                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXR_RESET_PID_SEQ                   _MK_ENUM_CONST(1)

// RX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always accept data packet regardless of  their data PID. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXI_SHIFT                   _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXI_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXI_RANGE                   5:5
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXI_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXI_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXI_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXI_DIS_PID_SEQ                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXI_ENB_PID_SEQ                     _MK_ENUM_CONST(1)

// RX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXT_SHIFT                   _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXT_FIELD                   (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXT_RANGE                   3:2
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXT_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXT_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXT_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXT_CTRL                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXT_ISO                     _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXT_BULK                    _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXT_INTR                    _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXD_SHIFT                   _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXD_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXD_RANGE                   1:1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXD_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXD_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// RX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt a SETUP request if this Endpoint  is configured as a Control Endpoint, Software can write a one to this bit to  force the endpoint to return a STALL handshake to the Host. It will continue  to returning STALL until this bit is either cleared by software or  automatically cleared as above.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXS_SHIFT                   _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXS_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXS_RANGE                   0:0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXS_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXS_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXS_EP_OK                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL11_0_RXS_EP_STALL                        _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCTRL12_0  
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0                     _MK_ADDR_CONST(0x1f0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_SECURE                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_WORD_COUNT                  0x1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RESET_MASK                  _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_READ_MASK                   _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_WRITE_MASK                  _MK_MASK_CONST(0xed00ed)
// TX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXE_SHIFT                   _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXE_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXE_RANGE                   23:23
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXE_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXE_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXE_DISABLE                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXE_ENABLE                  _MK_ENUM_CONST(1)

// TX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint software must write a one to this bit in order to synchronize  the data PIDs between the Host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXR_SHIFT                   _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXR_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXR_RANGE                   22:22
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXR_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXR_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXR_KEEP_GOING                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXR_RESET_PID_SEQ                   _MK_ENUM_CONST(1)

// TX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always transmit DATA0 for a data packet. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXI_SHIFT                   _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXI_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXI_RANGE                   21:21
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXI_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXI_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXI_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXI_DIS_PID_SEQ                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXI_ENB_PID_SEQ                     _MK_ENUM_CONST(1)

// TX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXT_SHIFT                   _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXT_FIELD                   (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXT_RANGE                   19:18
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXT_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXT_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXT_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXT_CTRL                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXT_ISO                     _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXT_BULK                    _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXT_INTR                    _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXD_SHIFT                   _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXD_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXD_RANGE                   17:17
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXD_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXD_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// TX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt of a SETUP request if this  Endpoint is configured as a Control Endpoint. Software can write a one to  this bit to force the endpoint to return a STALL handshake to the Host. It  will continue to returning STALL until this bit is either cleared by software  or automatically cleared as above. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXS_SHIFT                   _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXS_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXS_RANGE                   16:16
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXS_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXS_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXS_EP_OK                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_TXS_EP_STALL                        _MK_ENUM_CONST(1)

// RX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXE_SHIFT                   _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXE_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXE_RANGE                   7:7
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXE_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXE_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXE_DISABLE                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXE_ENABLE                  _MK_ENUM_CONST(1)

// RX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint, software must write a one to this bit in order to synchronize  the data PIDs between the host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXR_SHIFT                   _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXR_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXR_RANGE                   6:6
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXR_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXR_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXR_KEEP_GOING                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXR_RESET_PID_SEQ                   _MK_ENUM_CONST(1)

// RX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always accept data packet regardless of  their data PID. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXI_SHIFT                   _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXI_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXI_RANGE                   5:5
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXI_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXI_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXI_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXI_DIS_PID_SEQ                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXI_ENB_PID_SEQ                     _MK_ENUM_CONST(1)

// RX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXT_SHIFT                   _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXT_FIELD                   (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXT_RANGE                   3:2
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXT_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXT_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXT_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXT_CTRL                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXT_ISO                     _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXT_BULK                    _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXT_INTR                    _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXD_SHIFT                   _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXD_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXD_RANGE                   1:1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXD_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXD_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// RX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt a SETUP request if this Endpoint  is configured as a Control Endpoint, Software can write a one to this bit to  force the endpoint to return a STALL handshake to the Host. It will continue  to returning STALL until this bit is either cleared by software or  automatically cleared as above.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXS_SHIFT                   _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXS_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXS_RANGE                   0:0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXS_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXS_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXS_EP_OK                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL12_0_RXS_EP_STALL                        _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCTRL13_0  
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0                     _MK_ADDR_CONST(0x1f4)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_SECURE                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_WORD_COUNT                  0x1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RESET_MASK                  _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_READ_MASK                   _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_WRITE_MASK                  _MK_MASK_CONST(0xed00ed)
// TX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXE_SHIFT                   _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXE_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXE_RANGE                   23:23
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXE_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXE_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXE_DISABLE                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXE_ENABLE                  _MK_ENUM_CONST(1)

// TX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint software must write a one to this bit in order to synchronize  the data PIDs between the Host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXR_SHIFT                   _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXR_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXR_RANGE                   22:22
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXR_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXR_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXR_KEEP_GOING                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXR_RESET_PID_SEQ                   _MK_ENUM_CONST(1)

// TX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always transmit DATA0 for a data packet. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXI_SHIFT                   _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXI_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXI_RANGE                   21:21
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXI_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXI_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXI_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXI_DIS_PID_SEQ                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXI_ENB_PID_SEQ                     _MK_ENUM_CONST(1)

// TX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXT_SHIFT                   _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXT_FIELD                   (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXT_RANGE                   19:18
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXT_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXT_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXT_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXT_CTRL                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXT_ISO                     _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXT_BULK                    _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXT_INTR                    _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXD_SHIFT                   _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXD_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXD_RANGE                   17:17
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXD_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXD_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// TX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt of a SETUP request if this  Endpoint is configured as a Control Endpoint. Software can write a one to  this bit to force the endpoint to return a STALL handshake to the Host. It  will continue to returning STALL until this bit is either cleared by software  or automatically cleared as above. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXS_SHIFT                   _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXS_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXS_RANGE                   16:16
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXS_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXS_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXS_EP_OK                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_TXS_EP_STALL                        _MK_ENUM_CONST(1)

// RX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXE_SHIFT                   _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXE_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXE_RANGE                   7:7
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXE_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXE_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXE_DISABLE                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXE_ENABLE                  _MK_ENUM_CONST(1)

// RX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint, software must write a one to this bit in order to synchronize  the data PIDs between the host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXR_SHIFT                   _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXR_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXR_RANGE                   6:6
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXR_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXR_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXR_KEEP_GOING                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXR_RESET_PID_SEQ                   _MK_ENUM_CONST(1)

// RX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always accept data packet regardless of  their data PID. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXI_SHIFT                   _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXI_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXI_RANGE                   5:5
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXI_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXI_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXI_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXI_DIS_PID_SEQ                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXI_ENB_PID_SEQ                     _MK_ENUM_CONST(1)

// RX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXT_SHIFT                   _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXT_FIELD                   (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXT_RANGE                   3:2
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXT_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXT_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXT_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXT_CTRL                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXT_ISO                     _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXT_BULK                    _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXT_INTR                    _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXD_SHIFT                   _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXD_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXD_RANGE                   1:1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXD_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXD_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// RX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt a SETUP request if this Endpoint  is configured as a Control Endpoint, Software can write a one to this bit to  force the endpoint to return a STALL handshake to the Host. It will continue  to returning STALL until this bit is either cleared by software or  automatically cleared as above.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXS_SHIFT                   _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXS_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXS_RANGE                   0:0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXS_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXS_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXS_EP_OK                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL13_0_RXS_EP_STALL                        _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCTRL14_0  
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0                     _MK_ADDR_CONST(0x1f8)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_SECURE                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_WORD_COUNT                  0x1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RESET_MASK                  _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_READ_MASK                   _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_WRITE_MASK                  _MK_MASK_CONST(0xed00ed)
// TX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXE_SHIFT                   _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXE_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXE_RANGE                   23:23
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXE_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXE_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXE_DISABLE                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXE_ENABLE                  _MK_ENUM_CONST(1)

// TX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint software must write a one to this bit in order to synchronize  the data PIDs between the Host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXR_SHIFT                   _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXR_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXR_RANGE                   22:22
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXR_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXR_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXR_KEEP_GOING                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXR_RESET_PID_SEQ                   _MK_ENUM_CONST(1)

// TX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always transmit DATA0 for a data packet. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXI_SHIFT                   _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXI_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXI_RANGE                   21:21
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXI_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXI_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXI_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXI_DIS_PID_SEQ                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXI_ENB_PID_SEQ                     _MK_ENUM_CONST(1)

// TX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXT_SHIFT                   _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXT_FIELD                   (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXT_RANGE                   19:18
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXT_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXT_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXT_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXT_CTRL                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXT_ISO                     _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXT_BULK                    _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXT_INTR                    _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXD_SHIFT                   _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXD_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXD_RANGE                   17:17
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXD_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXD_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// TX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt of a SETUP request if this  Endpoint is configured as a Control Endpoint. Software can write a one to  this bit to force the endpoint to return a STALL handshake to the Host. It  will continue to returning STALL until this bit is either cleared by software  or automatically cleared as above. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXS_SHIFT                   _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXS_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXS_RANGE                   16:16
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXS_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXS_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXS_EP_OK                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_TXS_EP_STALL                        _MK_ENUM_CONST(1)

// RX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXE_SHIFT                   _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXE_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXE_RANGE                   7:7
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXE_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXE_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXE_DISABLE                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXE_ENABLE                  _MK_ENUM_CONST(1)

// RX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint, software must write a one to this bit in order to synchronize  the data PIDs between the host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXR_SHIFT                   _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXR_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXR_RANGE                   6:6
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXR_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXR_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXR_KEEP_GOING                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXR_RESET_PID_SEQ                   _MK_ENUM_CONST(1)

// RX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always accept data packet regardless of  their data PID. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXI_SHIFT                   _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXI_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXI_RANGE                   5:5
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXI_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXI_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXI_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXI_DIS_PID_SEQ                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXI_ENB_PID_SEQ                     _MK_ENUM_CONST(1)

// RX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXT_SHIFT                   _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXT_FIELD                   (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXT_RANGE                   3:2
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXT_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXT_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXT_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXT_CTRL                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXT_ISO                     _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXT_BULK                    _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXT_INTR                    _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXD_SHIFT                   _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXD_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXD_RANGE                   1:1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXD_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXD_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// RX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt a SETUP request if this Endpoint  is configured as a Control Endpoint, Software can write a one to this bit to  force the endpoint to return a STALL handshake to the Host. It will continue  to returning STALL until this bit is either cleared by software or  automatically cleared as above.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXS_SHIFT                   _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXS_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXS_RANGE                   0:0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXS_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXS_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXS_EP_OK                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL14_0_RXS_EP_STALL                        _MK_ENUM_CONST(1)


// Register USB2_CONTROLLER_USB2D_ENDPTCTRL15_0  
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0                     _MK_ADDR_CONST(0x1fc)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_SECURE                      0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_WORD_COUNT                  0x1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RESET_MASK                  _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_READ_MASK                   _MK_MASK_CONST(0xef00ef)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_WRITE_MASK                  _MK_MASK_CONST(0xed00ed)
// TX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXE_SHIFT                   _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXE_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXE_RANGE                   23:23
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXE_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXE_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXE_DISABLE                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXE_ENABLE                  _MK_ENUM_CONST(1)

// TX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint software must write a one to this bit in order to synchronize  the data PIDs between the Host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXR_SHIFT                   _MK_SHIFT_CONST(22)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXR_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXR_RANGE                   22:22
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXR_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXR_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXR_KEEP_GOING                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXR_RESET_PID_SEQ                   _MK_ENUM_CONST(1)

// TX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always transmit DATA0 for a data packet. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXI_SHIFT                   _MK_SHIFT_CONST(21)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXI_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXI_RANGE                   21:21
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXI_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXI_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXI_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXI_DIS_PID_SEQ                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXI_ENB_PID_SEQ                     _MK_ENUM_CONST(1)

// TX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXT_SHIFT                   _MK_SHIFT_CONST(18)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXT_FIELD                   (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXT_RANGE                   19:18
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXT_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXT_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXT_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXT_CTRL                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXT_ISO                     _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXT_BULK                    _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXT_INTR                    _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXD_SHIFT                   _MK_SHIFT_CONST(17)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXD_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXD_RANGE                   17:17
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXD_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXD_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// TX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt of a SETUP request if this  Endpoint is configured as a Control Endpoint. Software can write a one to  this bit to force the endpoint to return a STALL handshake to the Host. It  will continue to returning STALL until this bit is either cleared by software  or automatically cleared as above. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXS_SHIFT                   _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXS_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXS_RANGE                   16:16
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXS_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXS_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXS_EP_OK                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_TXS_EP_STALL                        _MK_ENUM_CONST(1)

// RX Endpoint Enable. An Endpoint should be enabled only after it has  been configured. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXE_SHIFT                   _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXE_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXE_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXE_RANGE                   7:7
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXE_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXE_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXE_DISABLE                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXE_ENABLE                  _MK_ENUM_CONST(1)

// RX Data Toggle Reset: Whenever a configuration event is received for  this Endpoint, software must write a one to this bit in order to synchronize  the data PIDs between the host and device. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXR_SHIFT                   _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXR_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXR_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXR_RANGE                   6:6
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXR_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXR_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXR_KEEP_GOING                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXR_RESET_PID_SEQ                   _MK_ENUM_CONST(1)

// RX Data Toggle Inhibit: This bit is only used for test and should always  be written as zero. Writing a one to this bit will cause this endpoint to  ignore the data toggle sequence and always accept data packet regardless of  their data PID. 
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXI_SHIFT                   _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXI_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXI_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXI_RANGE                   5:5
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXI_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXI_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXI_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXI_DIS_PID_SEQ                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXI_ENB_PID_SEQ                     _MK_ENUM_CONST(1)

// RX Endpoint Type:
// 00 = Control    01 = Isochronous                10 = Bulk               11 = Interrupt
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXT_SHIFT                   _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXT_FIELD                   (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXT_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXT_RANGE                   3:2
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXT_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXT_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXT_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXT_CTRL                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXT_ISO                     _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXT_BULK                    _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXT_INTR                    _MK_ENUM_CONST(3)

// This is fixed to 0.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXD_SHIFT                   _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXD_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXD_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXD_RANGE                   1:1
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXD_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXD_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// RX Endpoint Stall: This bit will be set automatically upon receipt of  a SETUP request if this Endpoint is not configured as a Control Endpoint. It  will be cleared automatically upon receipt a SETUP request if this Endpoint  is configured as a Control Endpoint, Software can write a one to this bit to  force the endpoint to return a STALL handshake to the Host. It will continue  to returning STALL until this bit is either cleared by software or  automatically cleared as above.
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXS_SHIFT                   _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXS_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXS_SHIFT)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXS_RANGE                   0:0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXS_WOFFSET                 0x0
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXS_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXS_EP_OK                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_ENDPTCTRL15_0_RXS_EP_STALL                        _MK_ENUM_CONST(1)


// Packet USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_SIZE 32

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MULT_SHIFT                    _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MULT_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MULT_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MULT_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MULT_ROW                      0
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MULT_NON_ISO_IS_0                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MULT_MULTI_1                  _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MULT_MULT_2                   _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MULT_MULTI_3                  _MK_ENUM_CONST(3)

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_ZLT_SHIFT                     _MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_ZLT_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_ZLT_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_ZLT_RANGE                     _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_ZLT_ROW                       0
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_ZLT_ZERO_LENGTH_TERM_ENABLED                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_ZLT_ZERO_LENGTH_TERM_DISABLED                 _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED0_0_SHIFT                     _MK_SHIFT_CONST(27)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED0_0_FIELD                     (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED0_0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED0_0_RANGE                     _MK_SHIFT_CONST(28):_MK_SHIFT_CONST(27)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED0_0_ROW                       0

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MAX_PACKET_LENGTH_SHIFT                       _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MAX_PACKET_LENGTH_FIELD                       (_MK_MASK_CONST(0x7ff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MAX_PACKET_LENGTH_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MAX_PACKET_LENGTH_RANGE                       _MK_SHIFT_CONST(26):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MAX_PACKET_LENGTH_ROW                 0

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_IOS_SHIFT                     _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_IOS_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_IOS_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_IOS_RANGE                     _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_IOS_ROW                       0
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_IOS_DISABLE                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_IOS_ENABLE                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED0_1_SHIFT                     _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED0_1_FIELD                     (_MK_MASK_CONST(0x7fff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED0_1_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED0_1_RANGE                     _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED0_1_ROW                       0

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_CURRENT_DTD_PTR_SHIFT                 _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_CURRENT_DTD_PTR_FIELD                 (_MK_MASK_CONST(0x7ffffff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_CURRENT_DTD_PTR_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_CURRENT_DTD_PTR_RANGE                 _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_CURRENT_DTD_PTR_ROW                   1

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED1_0_SHIFT                     _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED1_0_FIELD                     (_MK_MASK_CONST(0x1f) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED1_0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED1_0_RANGE                     _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED1_0_ROW                       1

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_NEXT_DTD_PTR_SHIFT                    _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_NEXT_DTD_PTR_FIELD                    (_MK_MASK_CONST(0x7ffffff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_NEXT_DTD_PTR_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_NEXT_DTD_PTR_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_NEXT_DTD_PTR_ROW                      2

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED2_0_SHIFT                     _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED2_0_FIELD                     (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED2_0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED2_0_RANGE                     _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED2_0_ROW                       2

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TERMINATE_SHIFT                       _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TERMINATE_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TERMINATE_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TERMINATE_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TERMINATE_ROW                 2
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TERMINATE_CLEAR                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TERMINATE_SET                 _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TOTAL_BYTES_SHIFT                     _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TOTAL_BYTES_FIELD                     (_MK_MASK_CONST(0xffff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TOTAL_BYTES_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TOTAL_BYTES_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TOTAL_BYTES_ROW                       3

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_IOC_SHIFT                     _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_IOC_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_IOC_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_IOC_RANGE                     _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_IOC_ROW                       3
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_IOC_DISABLE                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_IOC_ENABLE                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_0_SHIFT                     _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_0_FIELD                     (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_0_RANGE                     _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_0_ROW                       3

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MULTIPLIER_OVERRIDE_SHIFT                     _MK_SHIFT_CONST(10)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MULTIPLIER_OVERRIDE_FIELD                     (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MULTIPLIER_OVERRIDE_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MULTIPLIER_OVERRIDE_RANGE                     _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(10)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MULTIPLIER_OVERRIDE_ROW                       3
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MULTIPLIER_OVERRIDE_DISABLE                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_MULTIPLIER_OVERRIDE_ENABLE                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_1_SHIFT                     _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_1_FIELD                     (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_1_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_1_RANGE                     _MK_SHIFT_CONST(9):_MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_1_ROW                       3

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_ACTIVE_SHIFT                  _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_ACTIVE_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_ACTIVE_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_ACTIVE_RANGE                  _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_ACTIVE_ROW                    3
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_ACTIVE_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_ACTIVE_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_HALTED_SHIFT                  _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_HALTED_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_HALTED_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_HALTED_RANGE                  _MK_SHIFT_CONST(6):_MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_HALTED_ROW                    3
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_HALTED_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_HALTED_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_DATA_BUFFER_ERROR_SHIFT                       _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_DATA_BUFFER_ERROR_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_DATA_BUFFER_ERROR_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_DATA_BUFFER_ERROR_RANGE                       _MK_SHIFT_CONST(5):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_DATA_BUFFER_ERROR_ROW                 3
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_DATA_BUFFER_ERROR_CLEAR                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_DATA_BUFFER_ERROR_SET                 _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_2_SHIFT                     _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_2_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_2_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_2_RANGE                     _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_2_ROW                       3

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TRANSACTION_ERROR_SHIFT                       _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TRANSACTION_ERROR_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TRANSACTION_ERROR_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TRANSACTION_ERROR_RANGE                       _MK_SHIFT_CONST(3):_MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TRANSACTION_ERROR_ROW                 3
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TRANSACTION_ERROR_CLEAR                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_TRANSACTION_ERROR_SET                 _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_3_SHIFT                     _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_3_FIELD                     (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_3_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_3_RANGE                     _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED3_3_ROW                       3

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE0_SHIFT                   _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE0_FIELD                   (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE0_RANGE                   _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE0_ROW                     4

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_OFFSET_SHIFT                      _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_OFFSET_FIELD                      (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_OFFSET_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_OFFSET_RANGE                      _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_OFFSET_ROW                        4

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE1_SHIFT                   _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE1_FIELD                   (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE1_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE1_RANGE                   _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE1_ROW                     5

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED5_0_SHIFT                     _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED5_0_FIELD                     (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED5_0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED5_0_RANGE                     _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED5_0_ROW                       5

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE2_SHIFT                   _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE2_FIELD                   (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE2_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE2_RANGE                   _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE2_ROW                     6

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED6_0_SHIFT                     _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED6_0_FIELD                     (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED6_0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED6_0_RANGE                     _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED6_0_ROW                       6

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE3_SHIFT                   _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE3_FIELD                   (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE3_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE3_RANGE                   _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE3_ROW                     7

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED7_0_SHIFT                     _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED7_0_FIELD                     (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED7_0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED7_0_RANGE                     _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED7_0_ROW                       7

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE4_SHIFT                   _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE4_FIELD                   (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE4_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE4_RANGE                   _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_BUF_PTR_PAGE4_ROW                     8

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED8_0_SHIFT                     _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED8_0_FIELD                     (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED8_0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED8_0_RANGE                     _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED8_0_ROW                       8

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED9_0_SHIFT                     _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED9_0_FIELD                     (_MK_MASK_CONST(0xffffffff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED9_0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED9_0_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_RESERVED9_0_ROW                       9

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_SETUP_BUF_BYTES3_0_SHIFT                      _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_SETUP_BUF_BYTES3_0_FIELD                      (_MK_MASK_CONST(0xffffffff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_SETUP_BUF_BYTES3_0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_SETUP_BUF_BYTES3_0_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_SETUP_BUF_BYTES3_0_ROW                        10

#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_SETUP_BUF_BYTES7_4_SHIFT                      _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_SETUP_BUF_BYTES7_4_FIELD                      (_MK_MASK_CONST(0xffffffff) << USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_SETUP_BUF_BYTES7_4_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_SETUP_BUF_BYTES7_4_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_QUEUE_HEAD_0_SETUP_BUF_BYTES7_4_ROW                        11


// Packet USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_SIZE 32

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_NEXT_DTD_PTR_SHIFT                   _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_NEXT_DTD_PTR_FIELD                   (_MK_MASK_CONST(0x7ffffff) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_NEXT_DTD_PTR_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_NEXT_DTD_PTR_RANGE                   _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_NEXT_DTD_PTR_ROW                     0

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED2_0_SHIFT                    _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED2_0_FIELD                    (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED2_0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED2_0_RANGE                    _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED2_0_ROW                      0

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TERMINATE_SHIFT                      _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TERMINATE_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TERMINATE_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TERMINATE_RANGE                      _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TERMINATE_ROW                        0
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TERMINATE_CLEAR                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TERMINATE_SET                        _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TOTAL_BYTES_SHIFT                    _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TOTAL_BYTES_FIELD                    (_MK_MASK_CONST(0xffff) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TOTAL_BYTES_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TOTAL_BYTES_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TOTAL_BYTES_ROW                      1

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_IOC_SHIFT                    _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_IOC_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_IOC_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_IOC_RANGE                    _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_IOC_ROW                      1
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_IOC_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_IOC_ENABLE                   _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_0_SHIFT                    _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_0_FIELD                    (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_0_RANGE                    _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_0_ROW                      1

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_MULTIPLIER_OVERRIDE_SHIFT                    _MK_SHIFT_CONST(10)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_MULTIPLIER_OVERRIDE_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_MULTIPLIER_OVERRIDE_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_MULTIPLIER_OVERRIDE_RANGE                    _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(10)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_MULTIPLIER_OVERRIDE_ROW                      1
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_MULTIPLIER_OVERRIDE_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_MULTIPLIER_OVERRIDE_ENABLE                   _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_1_SHIFT                    _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_1_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_1_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_1_RANGE                    _MK_SHIFT_CONST(9):_MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_1_ROW                      1

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_ACTIVE_SHIFT                 _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_ACTIVE_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_ACTIVE_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_ACTIVE_RANGE                 _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_ACTIVE_ROW                   1
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_ACTIVE_CLEAR                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_ACTIVE_SET                   _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_HALTED_SHIFT                 _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_HALTED_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_HALTED_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_HALTED_RANGE                 _MK_SHIFT_CONST(6):_MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_HALTED_ROW                   1
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_HALTED_CLEAR                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_HALTED_SET                   _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_SHIFT                      _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_RANGE                      _MK_SHIFT_CONST(5):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_ROW                        1
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_CLEAR                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_SET                        _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_2_SHIFT                    _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_2_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_2_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_2_RANGE                    _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_2_ROW                      1

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_SHIFT                      _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_RANGE                      _MK_SHIFT_CONST(3):_MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_ROW                        1
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_CLEAR                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_SET                        _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_3_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_3_FIELD                    (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_3_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_3_RANGE                    _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED3_3_ROW                      1

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_SHIFT                  _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_FIELD                  (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_ROW                    2

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_OFFSET_SHIFT                     _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_OFFSET_FIELD                     (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_OFFSET_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_OFFSET_RANGE                     _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_OFFSET_ROW                       2

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_SHIFT                  _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_FIELD                  (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_ROW                    3

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED5_0_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED5_0_FIELD                    (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED5_0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED5_0_RANGE                    _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED5_0_ROW                      3

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE2_SHIFT                  _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE2_FIELD                  (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE2_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE2_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE2_ROW                    4

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED6_0_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED6_0_FIELD                    (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED6_0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED6_0_RANGE                    _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED6_0_ROW                      4

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE3_SHIFT                  _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE3_FIELD                  (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE3_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE3_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE3_ROW                    5

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED7_0_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED7_0_FIELD                    (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED7_0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED7_0_RANGE                    _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED7_0_ROW                      5

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE4_SHIFT                  _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE4_FIELD                  (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE4_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE4_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE4_ROW                    6

#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED8_0_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED8_0_FIELD                    (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED8_0_SHIFT)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED8_0_RANGE                    _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_DEVICE_TRANSFER_DESCRIPTOR_0_RESERVED8_0_ROW                      6


// Packet USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_SIZE 32

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QUEUE_HEAD_HORIZONTAL_LINK_PTR_SHIFT                    _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QUEUE_HEAD_HORIZONTAL_LINK_PTR_FIELD                    (_MK_MASK_CONST(0x7ffffff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QUEUE_HEAD_HORIZONTAL_LINK_PTR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QUEUE_HEAD_HORIZONTAL_LINK_PTR_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QUEUE_HEAD_HORIZONTAL_LINK_PTR_ROW                      0

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED0_0_SHIFT                       _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED0_0_FIELD                       (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED0_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED0_0_RANGE                       _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED0_0_ROW                 0

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QH_ITD_TYPE_SHIFT                       _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QH_ITD_TYPE_FIELD                       (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QH_ITD_TYPE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QH_ITD_TYPE_RANGE                       _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QH_ITD_TYPE_ROW                 0
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QH_ITD_TYPE_ITD                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QH_ITD_TYPE_QH                  _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QH_ITD_TYPE_SITD                        _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QH_ITD_TYPE_FSTN                        _MK_ENUM_CONST(3)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QH_TERMINATE_SHIFT                      _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QH_TERMINATE_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QH_TERMINATE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QH_TERMINATE_RANGE                      _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QH_TERMINATE_ROW                        0
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QH_TERMINATE_VALID_QH_PTR                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QH_TERMINATE_INVALID_QH_PTR                     _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_NAK_CNT_RL_SHIFT                        _MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_NAK_CNT_RL_FIELD                        (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_NAK_CNT_RL_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_NAK_CNT_RL_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_NAK_CNT_RL_ROW                  1

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CTRL_EP_FLAG_SHIFT                      _MK_SHIFT_CONST(27)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CTRL_EP_FLAG_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CTRL_EP_FLAG_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CTRL_EP_FLAG_RANGE                      _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(27)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CTRL_EP_FLAG_ROW                        1
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CTRL_EP_FLAG_NOT_CTRL_EP                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CTRL_EP_FLAG_CTRP_EP                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MAX_PKT_LENGTH_SHIFT                    _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MAX_PKT_LENGTH_FIELD                    (_MK_MASK_CONST(0x7ff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MAX_PKT_LENGTH_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MAX_PKT_LENGTH_RANGE                    _MK_SHIFT_CONST(26):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MAX_PKT_LENGTH_ROW                      1

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HEAD_RECLAMATION_LIST_SHIFT                     _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HEAD_RECLAMATION_LIST_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HEAD_RECLAMATION_LIST_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HEAD_RECLAMATION_LIST_RANGE                     _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HEAD_RECLAMATION_LIST_ROW                       1
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HEAD_RECLAMATION_LIST_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HEAD_RECLAMATION_LIST_SET                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_TOGGLE_CTRL_SHIFT                  _MK_SHIFT_CONST(14)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_TOGGLE_CTRL_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_TOGGLE_CTRL_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_TOGGLE_CTRL_RANGE                  _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(14)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_TOGGLE_CTRL_ROW                    1
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_TOGGLE_CTRL_QH_DT                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_TOGGLE_CTRL_QTD_DT                 _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ENDPT_SPEED_SHIFT                       _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ENDPT_SPEED_FIELD                       (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ENDPT_SPEED_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ENDPT_SPEED_RANGE                       _MK_SHIFT_CONST(13):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ENDPT_SPEED_ROW                 1
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ENDPT_SPEED_FULL_SPEED                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ENDPT_SPEED_LOW_SPEED                   _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ENDPT_SPEED_HIGH_SPEED                  _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ENDPT_SPEED_RESERVED                    _MK_ENUM_CONST(3)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ENPT_NUMBER_SHIFT                       _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ENPT_NUMBER_FIELD                       (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ENPT_NUMBER_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ENPT_NUMBER_RANGE                       _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ENPT_NUMBER_ROW                 1

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_INACTIVATE_SHIFT                        _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_INACTIVATE_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_INACTIVATE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_INACTIVATE_RANGE                        _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_INACTIVATE_ROW                  1
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_INACTIVATE_NO_INACTIVATE                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_INACTIVATE_INACTIVATE                   _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DEV_ADDRESS_SHIFT                       _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DEV_ADDRESS_FIELD                       (_MK_MASK_CONST(0x7f) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DEV_ADDRESS_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DEV_ADDRESS_RANGE                       _MK_SHIFT_CONST(6):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DEV_ADDRESS_ROW                 1

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MULT_SHIFT                      _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MULT_FIELD                      (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MULT_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MULT_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MULT_ROW                        2
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MULT_NON_ISO_IS_0                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MULT_MULTI_1                    _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MULT_MULT_2                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MULT_MULTI_3                    _MK_ENUM_CONST(3)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PORT_NUMBER_SHIFT                       _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PORT_NUMBER_FIELD                       (_MK_MASK_CONST(0x7f) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PORT_NUMBER_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PORT_NUMBER_RANGE                       _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PORT_NUMBER_ROW                 2

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HUB_ADDR_SHIFT                  _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HUB_ADDR_FIELD                  (_MK_MASK_CONST(0x7f) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HUB_ADDR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HUB_ADDR_RANGE                  _MK_SHIFT_CONST(22):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HUB_ADDR_ROW                    2

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_UFRAME_C_MASK_SHIFT                     _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_UFRAME_C_MASK_FIELD                     (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_UFRAME_C_MASK_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_UFRAME_C_MASK_RANGE                     _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_UFRAME_C_MASK_ROW                       2

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_UFRAME_S_MASK_SHIFT                     _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_UFRAME_S_MASK_FIELD                     (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_UFRAME_S_MASK_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_UFRAME_S_MASK_RANGE                     _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_UFRAME_S_MASK_ROW                       2

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CURRENT_QTD_PTR_SHIFT                   _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CURRENT_QTD_PTR_FIELD                   (_MK_MASK_CONST(0x7ffffff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CURRENT_QTD_PTR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CURRENT_QTD_PTR_RANGE                   _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CURRENT_QTD_PTR_ROW                     3

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED3_0_SHIFT                       _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED3_0_FIELD                       (_MK_MASK_CONST(0x1f) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED3_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED3_0_RANGE                       _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED3_0_ROW                 3

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_NEXT_QTD_PTR_SHIFT                      _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_NEXT_QTD_PTR_FIELD                      (_MK_MASK_CONST(0x7ffffff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_NEXT_QTD_PTR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_NEXT_QTD_PTR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_NEXT_QTD_PTR_ROW                        4

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED4_0_SHIFT                       _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED4_0_FIELD                       (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED4_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED4_0_RANGE                       _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED4_0_ROW                 4

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QTD_TERMINATE_SHIFT                     _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QTD_TERMINATE_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QTD_TERMINATE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QTD_TERMINATE_RANGE                     _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QTD_TERMINATE_ROW                       4
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QTD_TERMINATE_VALID_TD_PTR                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_QTD_TERMINATE_INVALID_TD_PTR                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ALT_NEXT_QTD_PTR_SHIFT                  _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ALT_NEXT_QTD_PTR_FIELD                  (_MK_MASK_CONST(0x7ffffff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ALT_NEXT_QTD_PTR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ALT_NEXT_QTD_PTR_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ALT_NEXT_QTD_PTR_ROW                    5

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED5_0_SHIFT                       _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED5_0_FIELD                       (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED5_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED5_0_RANGE                       _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED5_0_ROW                 5

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ALT_QTD_TERMINATE_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ALT_QTD_TERMINATE_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ALT_QTD_TERMINATE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ALT_QTD_TERMINATE_RANGE                 _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ALT_QTD_TERMINATE_ROW                   5
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ALT_QTD_TERMINATE_VALID_TD_PTR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ALT_QTD_TERMINATE_INVALID_TD_PTR                        _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_TOGGLE_SHIFT                       _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_TOGGLE_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_TOGGLE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_TOGGLE_RANGE                       _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_TOGGLE_ROW                 6
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_TOGGLE_DATA0                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_TOGGLE_DATA1                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_TOTAL_BYTES_SHIFT                       _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_TOTAL_BYTES_FIELD                       (_MK_MASK_CONST(0x7fff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_TOTAL_BYTES_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_TOTAL_BYTES_RANGE                       _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_TOTAL_BYTES_ROW                 6

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_IOC_SHIFT                       _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_IOC_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_IOC_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_IOC_RANGE                       _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_IOC_ROW                 6
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_IOC_DISABLE                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_IOC_ENABLE                      _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CURRENT_PAGE_SHIFT                      _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CURRENT_PAGE_FIELD                      (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CURRENT_PAGE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CURRENT_PAGE_RANGE                      _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_CURRENT_PAGE_ROW                        6

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ERR_COUNTER_SHIFT                       _MK_SHIFT_CONST(10)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ERR_COUNTER_FIELD                       (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ERR_COUNTER_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ERR_COUNTER_RANGE                       _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(10)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ERR_COUNTER_ROW                 6

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PID_CODE_SHIFT                  _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PID_CODE_FIELD                  (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PID_CODE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PID_CODE_RANGE                  _MK_SHIFT_CONST(9):_MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PID_CODE_ROW                    6
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PID_CODE_OUT                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PID_CODE_IN                     _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PID_CODE_SETUP                  _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PID_CODE_RESERVED                       _MK_ENUM_CONST(3)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ACTIVE_SHIFT                    _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ACTIVE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ACTIVE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ACTIVE_RANGE                    _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ACTIVE_ROW                      6
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ACTIVE_CLEAR                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_ACTIVE_SET                      _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HALTED_SHIFT                    _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HALTED_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HALTED_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HALTED_RANGE                    _MK_SHIFT_CONST(6):_MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HALTED_ROW                      6
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HALTED_CLEAR                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_HALTED_SET                      _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_BUFFER_ERROR_SHIFT                 _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_BUFFER_ERROR_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_BUFFER_ERROR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_BUFFER_ERROR_RANGE                 _MK_SHIFT_CONST(5):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_BUFFER_ERROR_ROW                   6
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_BUFFER_ERROR_CLEAR                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_DATA_BUFFER_ERROR_SET                   _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BABBLE_DETECTED_SHIFT                   _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BABBLE_DETECTED_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BABBLE_DETECTED_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BABBLE_DETECTED_RANGE                   _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BABBLE_DETECTED_ROW                     6
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BABBLE_DETECTED_CLEAR                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BABBLE_DETECTED_SET                     _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_TRANSACTION_ERROR_SHIFT                 _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_TRANSACTION_ERROR_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_TRANSACTION_ERROR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_TRANSACTION_ERROR_RANGE                 _MK_SHIFT_CONST(3):_MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_TRANSACTION_ERROR_ROW                   6
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_TRANSACTION_ERROR_CLEAR                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_TRANSACTION_ERROR_SET                   _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MISSED_MICRO_FRAME_SHIFT                        _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MISSED_MICRO_FRAME_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MISSED_MICRO_FRAME_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MISSED_MICRO_FRAME_RANGE                        _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MISSED_MICRO_FRAME_ROW                  6
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MISSED_MICRO_FRAME_CLEAR                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_MISSED_MICRO_FRAME_SET                  _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_SPLIT_TRANS_STATE_SHIFT                 _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_SPLIT_TRANS_STATE_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_SPLIT_TRANS_STATE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_SPLIT_TRANS_STATE_RANGE                 _MK_SHIFT_CONST(1):_MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_SPLIT_TRANS_STATE_ROW                   6
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_SPLIT_TRANS_STATE_DO_START_SPLIT                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_SPLIT_TRANS_STATE_DO_COMPLETE_SPLIT                     _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PING_STATE_SHIFT                        _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PING_STATE_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PING_STATE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PING_STATE_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PING_STATE_ROW                  6
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PING_STATE_DO_OUT                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_PING_STATE_DO_PING                      _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE0_SHIFT                     _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE0_FIELD                     (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE0_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE0_ROW                       7

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_OFFSET_SHIFT                        _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_OFFSET_FIELD                        (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_OFFSET_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_OFFSET_RANGE                        _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_OFFSET_ROW                  7

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE1_SHIFT                     _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE1_FIELD                     (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE1_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE1_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE1_ROW                       8

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED8_0_SHIFT                       _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED8_0_FIELD                       (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED8_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED8_0_RANGE                       _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED8_0_ROW                 8

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE2_SHIFT                     _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE2_FIELD                     (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE2_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE2_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE2_ROW                       9

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED9_0_SHIFT                       _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED9_0_FIELD                       (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED9_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED9_0_RANGE                       _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED9_0_ROW                 9

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE3_SHIFT                     _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE3_FIELD                     (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE3_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE3_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE3_ROW                       10

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED10_0_SHIFT                      _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED10_0_FIELD                      (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED10_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED10_0_RANGE                      _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED10_0_ROW                        10

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE4_SHIFT                     _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE4_FIELD                     (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE4_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE4_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_BUF_PTR_PAGE4_ROW                       11

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED11_0_SHIFT                      _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED11_0_FIELD                      (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED11_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED11_0_RANGE                      _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_HEAD_0_RESERVED11_0_ROW                        11


// Packet USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_SIZE 32

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_NEXT_QTD_PTR_SHIFT                       _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_NEXT_QTD_PTR_FIELD                       (_MK_MASK_CONST(0x7ffffff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_NEXT_QTD_PTR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_NEXT_QTD_PTR_RANGE                       _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_NEXT_QTD_PTR_ROW                 0

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED4_0_SHIFT                        _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED4_0_FIELD                        (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED4_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED4_0_RANGE                        _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED4_0_ROW                  0

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_QTD_TERMINATE_SHIFT                      _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_QTD_TERMINATE_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_QTD_TERMINATE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_QTD_TERMINATE_RANGE                      _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_QTD_TERMINATE_ROW                        0
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_QTD_TERMINATE_VALID_TD_PTR                       _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_QTD_TERMINATE_INVALID_TD_PTR                     _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ALT_NEXT_QTD_PTR_SHIFT                   _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ALT_NEXT_QTD_PTR_FIELD                   (_MK_MASK_CONST(0x7ffffff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ALT_NEXT_QTD_PTR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ALT_NEXT_QTD_PTR_RANGE                   _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ALT_NEXT_QTD_PTR_ROW                     1

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED5_0_SHIFT                        _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED5_0_FIELD                        (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED5_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED5_0_RANGE                        _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED5_0_ROW                  1

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ALT_QTD_TERMINATE_SHIFT                  _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ALT_QTD_TERMINATE_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ALT_QTD_TERMINATE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ALT_QTD_TERMINATE_RANGE                  _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ALT_QTD_TERMINATE_ROW                    1
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ALT_QTD_TERMINATE_VALID_TD_PTR                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ALT_QTD_TERMINATE_INVALID_TD_PTR                 _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_DATA_TOGGLE_SHIFT                        _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_DATA_TOGGLE_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_DATA_TOGGLE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_DATA_TOGGLE_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_DATA_TOGGLE_ROW                  2
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_DATA_TOGGLE_DATA0                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_DATA_TOGGLE_DATA1                        _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_TOTAL_BYTES_SHIFT                        _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_TOTAL_BYTES_FIELD                        (_MK_MASK_CONST(0x7fff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_TOTAL_BYTES_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_TOTAL_BYTES_RANGE                        _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_TOTAL_BYTES_ROW                  2

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_IOC_SHIFT                        _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_IOC_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_IOC_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_IOC_RANGE                        _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_IOC_ROW                  2
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_IOC_DISABLE                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_IOC_ENABLE                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_CURRENT_PAGE_SHIFT                       _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_CURRENT_PAGE_FIELD                       (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_CURRENT_PAGE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_CURRENT_PAGE_RANGE                       _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_CURRENT_PAGE_ROW                 2

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ERR_COUNTER_SHIFT                        _MK_SHIFT_CONST(10)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ERR_COUNTER_FIELD                        (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ERR_COUNTER_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ERR_COUNTER_RANGE                        _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(10)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ERR_COUNTER_ROW                  2

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_PID_CODE_SHIFT                   _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_PID_CODE_FIELD                   (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_PID_CODE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_PID_CODE_RANGE                   _MK_SHIFT_CONST(9):_MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_PID_CODE_ROW                     2
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_PID_CODE_OUT                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_PID_CODE_IN                      _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_PID_CODE_SETUP                   _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_PID_CODE_RESERVED                        _MK_ENUM_CONST(3)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ACTIVE_SHIFT                     _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ACTIVE_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ACTIVE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ACTIVE_RANGE                     _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ACTIVE_ROW                       2
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ACTIVE_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_ACTIVE_SET                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_HALTED_SHIFT                     _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_HALTED_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_HALTED_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_HALTED_RANGE                     _MK_SHIFT_CONST(6):_MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_HALTED_ROW                       2
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_HALTED_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_HALTED_SET                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_SHIFT                  _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_RANGE                  _MK_SHIFT_CONST(5):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_ROW                    2
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_SHIFT                    _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_RANGE                    _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_ROW                      2
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_CLEAR                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_SET                      _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_SHIFT                  _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_RANGE                  _MK_SHIFT_CONST(3):_MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_ROW                    2
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_MISSED_MICRO_FRAME_SHIFT                 _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_MISSED_MICRO_FRAME_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_MISSED_MICRO_FRAME_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_MISSED_MICRO_FRAME_RANGE                 _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_MISSED_MICRO_FRAME_ROW                   2
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_MISSED_MICRO_FRAME_CLEAR                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_MISSED_MICRO_FRAME_SET                   _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_SPLIT_TRANS_STATE_SHIFT                  _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_SPLIT_TRANS_STATE_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_SPLIT_TRANS_STATE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_SPLIT_TRANS_STATE_RANGE                  _MK_SHIFT_CONST(1):_MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_SPLIT_TRANS_STATE_ROW                    2
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_SPLIT_TRANS_STATE_DO_START_SPLIT                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_SPLIT_TRANS_STATE_DO_COMPLETE_SPLIT                      _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_PING_STATE_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_PING_STATE_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_PING_STATE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_PING_STATE_RANGE                 _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_PING_STATE_ROW                   2
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_PING_STATE_DO_OUT                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_PING_STATE_DO_PING                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_SHIFT                      _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_FIELD                      (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_ROW                        3

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_OFFSET_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_OFFSET_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_OFFSET_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_OFFSET_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_OFFSET_ROW                   3

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_SHIFT                      _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_FIELD                      (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_ROW                        4

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED8_0_SHIFT                        _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED8_0_FIELD                        (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED8_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED8_0_RANGE                        _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED8_0_ROW                  4

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE2_SHIFT                      _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE2_FIELD                      (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE2_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE2_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE2_ROW                        5

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED9_0_SHIFT                        _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED9_0_FIELD                        (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED9_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED9_0_RANGE                        _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED9_0_ROW                  5

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE3_SHIFT                      _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE3_FIELD                      (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE3_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE3_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE3_ROW                        6

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED10_0_SHIFT                       _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED10_0_FIELD                       (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED10_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED10_0_RANGE                       _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED10_0_ROW                 6

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE4_SHIFT                      _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE4_FIELD                      (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE4_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE4_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE4_ROW                        7

#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED11_0_SHIFT                       _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED11_0_FIELD                       (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED11_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED11_0_RANGE                       _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_QUEUE_TRANSFER_DESCRIPTOR_0_RESERVED11_0_ROW                 7


// Packet USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_SIZE 32

#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_FRAME_LIST_LINK_PTR_SHIFT                       _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_FRAME_LIST_LINK_PTR_FIELD                       (_MK_MASK_CONST(0x7ffffff) << USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_FRAME_LIST_LINK_PTR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_FRAME_LIST_LINK_PTR_RANGE                       _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_FRAME_LIST_LINK_PTR_ROW                 0

#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_RESERVED0_0_SHIFT                       _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_RESERVED0_0_FIELD                       (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_RESERVED0_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_RESERVED0_0_RANGE                       _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_RESERVED0_0_ROW                 0

#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_QH_ITD_TYPE_SHIFT                       _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_QH_ITD_TYPE_FIELD                       (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_QH_ITD_TYPE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_QH_ITD_TYPE_RANGE                       _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_QH_ITD_TYPE_ROW                 0
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_QH_ITD_TYPE_ITD                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_QH_ITD_TYPE_QH                  _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_QH_ITD_TYPE_SITD                        _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_QH_ITD_TYPE_FSTN                        _MK_ENUM_CONST(3)

#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_RESERVED1_0_SHIFT                       _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_RESERVED1_0_FIELD                       (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_RESERVED1_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_RESERVED1_0_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_FRAME_LIST_ELEMENT_0_RESERVED1_0_ROW                 0


// Packet USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_SIZE 32

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_NEXT_LINK_PTR_SHIFT                        _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_NEXT_LINK_PTR_FIELD                        (_MK_MASK_CONST(0x7ffffff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_NEXT_LINK_PTR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_NEXT_LINK_PTR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_NEXT_LINK_PTR_ROW                  0

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED0_0_SHIFT                  _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED0_0_FIELD                  (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED0_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED0_0_RANGE                  _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED0_0_ROW                    0

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_SHIFT                  _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_FIELD                  (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_RANGE                  _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_ROW                    0
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_ITD                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_QH                     _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_SITD                   _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_FSTN                   _MK_ENUM_CONST(3)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TERMINATE_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TERMINATE_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TERMINATE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TERMINATE_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TERMINATE_ROW                      0
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TERMINATE_VALID_LINK_PTR                   _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TERMINATE_INVALID_LINK_PTR                 _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_0_SHIFT                     _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_0_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_0_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_0_ROW                       1
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_0_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_0_SET                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_0_SHIFT                  _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_0_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_0_RANGE                  _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_0_ROW                    1
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_0_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_0_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_0_SHIFT                    _MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_0_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_0_RANGE                    _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_0_ROW                      1
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_0_CLEAR                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_0_SET                      _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_0_SHIFT                  _MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_0_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_0_RANGE                  _MK_SHIFT_CONST(28):_MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_0_ROW                    1
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_0_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_0_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_0_LENGTH_SHIFT                 _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_0_LENGTH_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_0_LENGTH_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_0_LENGTH_RANGE                 _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_0_LENGTH_ROW                   1

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_0_SHIFT                        _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_0_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_0_RANGE                        _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_0_ROW                  1
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_0_DISABLE                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_0_ENABLE                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_0_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_0_FIELD                        (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_0_RANGE                        _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_0_ROW                  1

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_0_OFFSET_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_0_OFFSET_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_0_OFFSET_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_0_OFFSET_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_0_OFFSET_ROW                   1

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_1_SHIFT                     _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_1_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_1_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_1_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_1_ROW                       2
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_1_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_1_SET                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_1_SHIFT                  _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_1_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_1_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_1_RANGE                  _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_1_ROW                    2
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_1_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_1_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_1_SHIFT                    _MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_1_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_1_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_1_RANGE                    _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_1_ROW                      2
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_1_CLEAR                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_1_SET                      _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_1_SHIFT                  _MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_1_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_1_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_1_RANGE                  _MK_SHIFT_CONST(28):_MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_1_ROW                    2
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_1_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_1_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_1_LENGTH_SHIFT                 _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_1_LENGTH_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_1_LENGTH_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_1_LENGTH_RANGE                 _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_1_LENGTH_ROW                   2

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_1_SHIFT                        _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_1_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_1_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_1_RANGE                        _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_1_ROW                  2
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_1_DISABLE                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_1_ENABLE                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_1_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_1_FIELD                        (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_1_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_1_RANGE                        _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_1_ROW                  2

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_1_OFFSET_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_1_OFFSET_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_1_OFFSET_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_1_OFFSET_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_1_OFFSET_ROW                   2

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_2_SHIFT                     _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_2_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_2_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_2_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_2_ROW                       3
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_2_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_2_SET                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_2_SHIFT                  _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_2_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_2_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_2_RANGE                  _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_2_ROW                    3
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_2_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_2_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_2_SHIFT                    _MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_2_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_2_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_2_RANGE                    _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_2_ROW                      3
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_2_CLEAR                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_2_SET                      _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_2_SHIFT                  _MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_2_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_2_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_2_RANGE                  _MK_SHIFT_CONST(28):_MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_2_ROW                    3
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_2_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_2_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_2_LENGTH_SHIFT                 _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_2_LENGTH_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_2_LENGTH_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_2_LENGTH_RANGE                 _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_2_LENGTH_ROW                   3

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_2_SHIFT                        _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_2_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_2_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_2_RANGE                        _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_2_ROW                  3
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_2_DISABLE                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_2_ENABLE                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_2_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_2_FIELD                        (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_2_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_2_RANGE                        _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_2_ROW                  3

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_2_OFFSET_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_2_OFFSET_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_2_OFFSET_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_2_OFFSET_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_2_OFFSET_ROW                   3

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_3_SHIFT                     _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_3_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_3_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_3_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_3_ROW                       4
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_3_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_3_SET                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_3_SHIFT                  _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_3_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_3_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_3_RANGE                  _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_3_ROW                    4
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_3_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_3_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_3_SHIFT                    _MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_3_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_3_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_3_RANGE                    _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_3_ROW                      4
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_3_CLEAR                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_3_SET                      _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_3_SHIFT                  _MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_3_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_3_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_3_RANGE                  _MK_SHIFT_CONST(28):_MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_3_ROW                    4
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_3_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_3_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_3_LENGTH_SHIFT                 _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_3_LENGTH_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_3_LENGTH_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_3_LENGTH_RANGE                 _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_3_LENGTH_ROW                   4

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_3_SHIFT                        _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_3_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_3_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_3_RANGE                        _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_3_ROW                  4
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_3_DISABLE                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_3_ENABLE                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_3_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_3_FIELD                        (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_3_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_3_RANGE                        _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_3_ROW                  4

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_3_OFFSET_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_3_OFFSET_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_3_OFFSET_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_3_OFFSET_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_3_OFFSET_ROW                   4

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_4_SHIFT                     _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_4_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_4_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_4_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_4_ROW                       5
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_4_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_4_SET                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_4_SHIFT                  _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_4_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_4_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_4_RANGE                  _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_4_ROW                    5
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_4_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_4_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_4_SHIFT                    _MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_4_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_4_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_4_RANGE                    _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_4_ROW                      5
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_4_CLEAR                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_4_SET                      _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_4_SHIFT                  _MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_4_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_4_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_4_RANGE                  _MK_SHIFT_CONST(28):_MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_4_ROW                    5
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_4_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_4_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_4_LENGTH_SHIFT                 _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_4_LENGTH_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_4_LENGTH_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_4_LENGTH_RANGE                 _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_4_LENGTH_ROW                   5

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_4_SHIFT                        _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_4_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_4_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_4_RANGE                        _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_4_ROW                  5
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_4_DISABLE                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_4_ENABLE                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_4_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_4_FIELD                        (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_4_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_4_RANGE                        _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_4_ROW                  5

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_4_OFFSET_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_4_OFFSET_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_4_OFFSET_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_4_OFFSET_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_4_OFFSET_ROW                   5

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_5_SHIFT                     _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_5_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_5_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_5_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_5_ROW                       6
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_5_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_5_SET                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_5_SHIFT                  _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_5_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_5_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_5_RANGE                  _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_5_ROW                    6
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_5_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_5_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_5_SHIFT                    _MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_5_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_5_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_5_RANGE                    _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_5_ROW                      6
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_5_CLEAR                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_5_SET                      _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_5_SHIFT                  _MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_5_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_5_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_5_RANGE                  _MK_SHIFT_CONST(28):_MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_5_ROW                    6
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_5_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_5_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_5_LENGTH_SHIFT                 _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_5_LENGTH_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_5_LENGTH_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_5_LENGTH_RANGE                 _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_5_LENGTH_ROW                   6

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_5_SHIFT                        _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_5_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_5_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_5_RANGE                        _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_5_ROW                  6
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_5_DISABLE                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_5_ENABLE                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_5_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_5_FIELD                        (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_5_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_5_RANGE                        _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_5_ROW                  6

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_5_OFFSET_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_5_OFFSET_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_5_OFFSET_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_5_OFFSET_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_5_OFFSET_ROW                   6

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_6_SHIFT                     _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_6_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_6_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_6_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_6_ROW                       7
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_6_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_6_SET                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_6_SHIFT                  _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_6_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_6_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_6_RANGE                  _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_6_ROW                    7
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_6_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_6_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_6_SHIFT                    _MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_6_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_6_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_6_RANGE                    _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_6_ROW                      7
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_6_CLEAR                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_6_SET                      _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_6_SHIFT                  _MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_6_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_6_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_6_RANGE                  _MK_SHIFT_CONST(28):_MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_6_ROW                    7
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_6_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_6_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_6_LENGTH_SHIFT                 _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_6_LENGTH_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_6_LENGTH_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_6_LENGTH_RANGE                 _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_6_LENGTH_ROW                   7

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_6_SHIFT                        _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_6_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_6_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_6_RANGE                        _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_6_ROW                  7
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_6_DISABLE                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_6_ENABLE                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_6_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_6_FIELD                        (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_6_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_6_RANGE                        _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_6_ROW                  7

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_6_OFFSET_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_6_OFFSET_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_6_OFFSET_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_6_OFFSET_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_6_OFFSET_ROW                   7

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_7_SHIFT                     _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_7_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_7_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_7_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_7_ROW                       8
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_7_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_7_SET                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_7_SHIFT                  _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_7_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_7_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_7_RANGE                  _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_7_ROW                    8
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_7_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_7_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_7_SHIFT                    _MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_7_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_7_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_7_RANGE                    _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(29)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_7_ROW                      8
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_7_CLEAR                    _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_7_SET                      _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_7_SHIFT                  _MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_7_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_7_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_7_RANGE                  _MK_SHIFT_CONST(28):_MK_SHIFT_CONST(28)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_7_ROW                    8
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_7_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_7_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_7_LENGTH_SHIFT                 _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_7_LENGTH_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_7_LENGTH_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_7_LENGTH_RANGE                 _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_7_LENGTH_ROW                   8

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_7_SHIFT                        _MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_7_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_7_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_7_RANGE                        _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(15)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_7_ROW                  8
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_7_DISABLE                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_IOC_7_ENABLE                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_7_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_7_FIELD                        (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_7_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_7_RANGE                        _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_7_ROW                  8

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_7_OFFSET_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_7_OFFSET_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_7_OFFSET_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_7_OFFSET_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_7_OFFSET_ROW                   8

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_FIELD                        (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_ROW                  9

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ENPT_NUMBER_SHIFT                  _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ENPT_NUMBER_FIELD                  (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ENPT_NUMBER_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ENPT_NUMBER_RANGE                  _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_ENPT_NUMBER_ROW                    9

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED9_0_SHIFT                  _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED9_0_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED9_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED9_0_RANGE                  _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED9_0_ROW                    9

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DEV_ADDRESS_SHIFT                  _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DEV_ADDRESS_FIELD                  (_MK_MASK_CONST(0x7f) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DEV_ADDRESS_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DEV_ADDRESS_RANGE                  _MK_SHIFT_CONST(6):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DEV_ADDRESS_ROW                    9

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_FIELD                        (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_ROW                  10

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DIRECTION_SHIFT                    _MK_SHIFT_CONST(11)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DIRECTION_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DIRECTION_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DIRECTION_RANGE                    _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(11)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DIRECTION_ROW                      10
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DIRECTION_OUT                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_DIRECTION_IN                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_MAX_PKT_SIZE_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_MAX_PKT_SIZE_FIELD                 (_MK_MASK_CONST(0x7ff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_MAX_PKT_SIZE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_MAX_PKT_SIZE_RANGE                 _MK_SHIFT_CONST(10):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_MAX_PKT_SIZE_ROW                   10

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE2_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE2_FIELD                        (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE2_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE2_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE2_ROW                  11

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED11_0_SHIFT                 _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED11_0_FIELD                 (_MK_MASK_CONST(0x3ff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED11_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED11_0_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED11_0_ROW                   11

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_MULT_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_MULT_FIELD                 (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_MULT_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_MULT_RANGE                 _MK_SHIFT_CONST(1):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_MULT_ROW                   11
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_MULT_RESERVED                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_MULT_MULTI_1                       _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_MULT_MULT_2                        _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_MULT_MULTI_3                       _MK_ENUM_CONST(3)

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE3_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE3_FIELD                        (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE3_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE3_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE3_ROW                  12

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED12_0_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED12_0_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED12_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED12_0_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED12_0_ROW                   12

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE4_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE4_FIELD                        (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE4_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE4_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE4_ROW                  13

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED13_0_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED13_0_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED13_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED13_0_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED13_0_ROW                   13

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE5_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE5_FIELD                        (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE5_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE5_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE5_ROW                  14

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED14_0_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED14_0_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED14_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED14_0_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED14_0_ROW                   14

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE6_SHIFT                        _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE6_FIELD                        (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE6_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE6_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE6_ROW                  15

#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED15_0_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED15_0_FIELD                 (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED15_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED15_0_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_ISO_TRANSFER_DESCRIPTOR_0_RESERVED15_0_ROW                   15


// Packet USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_SIZE 32

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_NEXT_LINK_PTR_SHIFT                  _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_NEXT_LINK_PTR_FIELD                  (_MK_MASK_CONST(0x7ffffff) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_NEXT_LINK_PTR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_NEXT_LINK_PTR_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_NEXT_LINK_PTR_ROW                    0

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED0_0_SHIFT                    _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED0_0_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED0_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED0_0_RANGE                    _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED0_0_ROW                      0

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_SHIFT                    _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_RANGE                    _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_ROW                      0
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_ITD                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_QH                       _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_SITD                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_QH_ITD_TYPE_FSTN                     _MK_ENUM_CONST(3)

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TERMINATE_SHIFT                      _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TERMINATE_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TERMINATE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TERMINATE_RANGE                      _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TERMINATE_ROW                        0
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TERMINATE_VALID_LINK_PTR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TERMINATE_INVALID_LINK_PTR                   _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DIRECTION_SHIFT                      _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DIRECTION_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DIRECTION_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DIRECTION_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DIRECTION_ROW                        1
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DIRECTION_OUT                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DIRECTION_IN                 _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_PORT_NUMBER_SHIFT                    _MK_SHIFT_CONST(24)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_PORT_NUMBER_FIELD                    (_MK_MASK_CONST(0x7f) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_PORT_NUMBER_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_PORT_NUMBER_RANGE                    _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(24)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_PORT_NUMBER_ROW                      1

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED1_0_SHIFT                    _MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED1_0_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED1_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED1_0_RANGE                    _MK_SHIFT_CONST(23):_MK_SHIFT_CONST(23)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED1_0_ROW                      1

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_HUB_ADDR_SHIFT                       _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_HUB_ADDR_FIELD                       (_MK_MASK_CONST(0x7f) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_HUB_ADDR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_HUB_ADDR_RANGE                       _MK_SHIFT_CONST(22):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_HUB_ADDR_ROW                 1

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED1_1_SHIFT                    _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED1_1_FIELD                    (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED1_1_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED1_1_RANGE                    _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED1_1_ROW                      1

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ENPT_NUMBER_SHIFT                    _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ENPT_NUMBER_FIELD                    (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ENPT_NUMBER_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ENPT_NUMBER_RANGE                    _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ENPT_NUMBER_ROW                      1

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED1_2_SHIFT                    _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED1_2_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED1_2_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED1_2_RANGE                    _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED1_2_ROW                      1

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DEV_ADDRESS_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DEV_ADDRESS_FIELD                    (_MK_MASK_CONST(0x7f) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DEV_ADDRESS_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DEV_ADDRESS_RANGE                    _MK_SHIFT_CONST(6):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DEV_ADDRESS_ROW                      1

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED2_0_SHIFT                    _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED2_0_FIELD                    (_MK_MASK_CONST(0xffff) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED2_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED2_0_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED2_0_ROW                      2

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_UFRAME_C_MASK_SHIFT                  _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_UFRAME_C_MASK_FIELD                  (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_UFRAME_C_MASK_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_UFRAME_C_MASK_RANGE                  _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_UFRAME_C_MASK_ROW                    2

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_UFRAME_S_MASK_SHIFT                  _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_UFRAME_S_MASK_FIELD                  (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_UFRAME_S_MASK_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_UFRAME_S_MASK_RANGE                  _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_UFRAME_S_MASK_ROW                    2

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_IOC_SHIFT                    _MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_IOC_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_IOC_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_IOC_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_IOC_ROW                      3
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_IOC_DISABLE                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_IOC_ENABLE                   _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_SHIFT                    _MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_RANGE                    _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(30)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_PAGE_SELECT_ROW                      3

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED3_0_SHIFT                    _MK_SHIFT_CONST(26)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED3_0_FIELD                    (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED3_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED3_0_RANGE                    _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(26)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED3_0_ROW                      3

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TOTAL_BYTES_SHIFT                    _MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TOTAL_BYTES_FIELD                    (_MK_MASK_CONST(0x3ff) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TOTAL_BYTES_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TOTAL_BYTES_RANGE                    _MK_SHIFT_CONST(25):_MK_SHIFT_CONST(16)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TOTAL_BYTES_ROW                      3

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_C_PROG_MASK_SHIFT                    _MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_C_PROG_MASK_FIELD                    (_MK_MASK_CONST(0xff) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_C_PROG_MASK_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_C_PROG_MASK_RANGE                    _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(8)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_C_PROG_MASK_ROW                      3

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_SHIFT                 _MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_RANGE                 _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(7)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_ROW                   3
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_CLEAR                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ACTIVE_SET                   _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ERROR_SHIFT                  _MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ERROR_FIELD                  (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ERROR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ERROR_RANGE                  _MK_SHIFT_CONST(6):_MK_SHIFT_CONST(6)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ERROR_ROW                    3
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ERROR_CLEAR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_ERROR_SET                    _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_SHIFT                      _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_RANGE                      _MK_SHIFT_CONST(5):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_ROW                        3
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_CLEAR                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_DATA_BUFFER_ERROR_SET                        _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_SHIFT                        _MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_FIELD                        (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_RANGE                        _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(4)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_ROW                  3
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_CLEAR                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BABBLE_DETECTED_SET                  _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_SHIFT                      _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_RANGE                      _MK_SHIFT_CONST(3):_MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_ROW                        3
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_CLEAR                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_ERROR_SET                        _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_MISSED_MICRO_FRAME_SHIFT                     _MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_MISSED_MICRO_FRAME_FIELD                     (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_MISSED_MICRO_FRAME_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_MISSED_MICRO_FRAME_RANGE                     _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_MISSED_MICRO_FRAME_ROW                       3
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_MISSED_MICRO_FRAME_CLEAR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_MISSED_MICRO_FRAME_SET                       _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_SPLIT_TRANS_STATE_SHIFT                      _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_SPLIT_TRANS_STATE_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_SPLIT_TRANS_STATE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_SPLIT_TRANS_STATE_RANGE                      _MK_SHIFT_CONST(1):_MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_SPLIT_TRANS_STATE_ROW                        3
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_SPLIT_TRANS_STATE_DO_START_SPLIT                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_SPLIT_TRANS_STATE_DO_COMPLETE_SPLIT                  _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED3_1_SHIFT                    _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED3_1_FIELD                    (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED3_1_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED3_1_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED3_1_ROW                      3

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_SHIFT                  _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_FIELD                  (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE0_ROW                    4

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BUF_OFFSET_SHIFT                     _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BUF_OFFSET_FIELD                     (_MK_MASK_CONST(0xfff) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BUF_OFFSET_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BUF_OFFSET_RANGE                     _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BUF_OFFSET_ROW                       4

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_SHIFT                  _MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_FIELD                  (_MK_MASK_CONST(0xfffff) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BUF_PTR_PAGE1_ROW                    5

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED5_0_SHIFT                    _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED5_0_FIELD                    (_MK_MASK_CONST(0x7f) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED5_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED5_0_RANGE                    _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED5_0_ROW                      5

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_POSITION_SHIFT                   _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_POSITION_FIELD                   (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_POSITION_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_POSITION_RANGE                   _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_POSITION_ROW                     5
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_POSITION_ALL                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_POSITION_BEGIN                   _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_POSITION_MID                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_POSITION_END                     _MK_ENUM_CONST(3)

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_COUNT_SHIFT                      _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_COUNT_FIELD                      (_MK_MASK_CONST(0x7) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_COUNT_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_COUNT_RANGE                      _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_TRANSACTION_COUNT_ROW                        5

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_SITD_BACK_PTR_SHIFT                  _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_SITD_BACK_PTR_FIELD                  (_MK_MASK_CONST(0x7ffffff) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_SITD_BACK_PTR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_SITD_BACK_PTR_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_SITD_BACK_PTR_ROW                    6

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED6_0_SHIFT                    _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED6_0_FIELD                    (_MK_MASK_CONST(0xf) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED6_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED6_0_RANGE                    _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_RESERVED6_0_ROW                      6

#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BP_TERMINATE_SHIFT                   _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BP_TERMINATE_FIELD                   (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BP_TERMINATE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BP_TERMINATE_RANGE                   _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BP_TERMINATE_ROW                     6
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BP_TERMINATE_VALID_BACK_PTR                  _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_SPLIT_ISO_TRANSFER_DESCRIPTOR_0_BP_TERMINATE_INVALID_BACK_PTR                        _MK_ENUM_CONST(1)


// Packet USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_SIZE 32

#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_NORMAL_PATH_LINK_PTR_SHIFT                      _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_NORMAL_PATH_LINK_PTR_FIELD                      (_MK_MASK_CONST(0x7ffffff) << USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_NORMAL_PATH_LINK_PTR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_NORMAL_PATH_LINK_PTR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_NORMAL_PATH_LINK_PTR_ROW                        0

#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_RESERVED0_0_SHIFT                       _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_RESERVED0_0_FIELD                       (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_RESERVED0_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_RESERVED0_0_RANGE                       _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_RESERVED0_0_ROW                 0

#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_QH_ITD_TYPE_SHIFT                       _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_QH_ITD_TYPE_FIELD                       (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_QH_ITD_TYPE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_QH_ITD_TYPE_RANGE                       _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_QH_ITD_TYPE_ROW                 0
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_QH_ITD_TYPE_ITD                 _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_QH_ITD_TYPE_QH                  _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_QH_ITD_TYPE_SITD                        _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_QH_ITD_TYPE_FSTN                        _MK_ENUM_CONST(3)

#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_TERMINATE_SHIFT                 _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_TERMINATE_FIELD                 (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_TERMINATE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_TERMINATE_RANGE                 _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_TERMINATE_ROW                   0
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_TERMINATE_VALID_LINK_PTR                        _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_TERMINATE_INVALID_LINK_PTR                      _MK_ENUM_CONST(1)

#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BACK_PATH_LINK_PTR_SHIFT                        _MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BACK_PATH_LINK_PTR_FIELD                        (_MK_MASK_CONST(0x7ffffff) << USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BACK_PATH_LINK_PTR_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BACK_PATH_LINK_PTR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(5)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BACK_PATH_LINK_PTR_ROW                  1

#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_RESERVED1_0_SHIFT                       _MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_RESERVED1_0_FIELD                       (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_RESERVED1_0_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_RESERVED1_0_RANGE                       _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(3)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_RESERVED1_0_ROW                 1

#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BP_QH_ITD_TYPE_SHIFT                    _MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BP_QH_ITD_TYPE_FIELD                    (_MK_MASK_CONST(0x3) << USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BP_QH_ITD_TYPE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BP_QH_ITD_TYPE_RANGE                    _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BP_QH_ITD_TYPE_ROW                      1
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BP_QH_ITD_TYPE_ITD                      _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BP_QH_ITD_TYPE_QH                       _MK_ENUM_CONST(1)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BP_QH_ITD_TYPE_SITD                     _MK_ENUM_CONST(2)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BP_QH_ITD_TYPE_FSTN                     _MK_ENUM_CONST(3)

#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BP_TERMINATE_SHIFT                      _MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BP_TERMINATE_FIELD                      (_MK_MASK_CONST(0x1) << USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BP_TERMINATE_SHIFT)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BP_TERMINATE_RANGE                      _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BP_TERMINATE_ROW                        1
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BP_TERMINATE_VALID_LINK_PTR                     _MK_ENUM_CONST(0)
#define USB2_CONTROLLER_USB2D_HOST_PERIODIC_FRAME_SPAN_TRAVERSAL_NODE_0_BP_TERMINATE_INVALID_LINK_PTR                   _MK_ENUM_CONST(1)


// Register USB1_IF_USB_SUSP_CTRL_0  
#define USB1_IF_USB_SUSP_CTRL_0                 _MK_ADDR_CONST(0x400)
#define USB1_IF_USB_SUSP_CTRL_0_SECURE                  0x0
#define USB1_IF_USB_SUSP_CTRL_0_WORD_COUNT                      0x1
#define USB1_IF_USB_SUSP_CTRL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_RESET_MASK                      _MK_MASK_CONST(0x74fff)
#define USB1_IF_USB_SUSP_CTRL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_READ_MASK                       _MK_MASK_CONST(0x74fff)
#define USB1_IF_USB_SUSP_CTRL_0_WRITE_MASK                      _MK_MASK_CONST(0x74e3e)
// USB PHY wakeup debounce counter
// USB will debounce any wakeup event by the number of clocks programmed 
// in this counter.
// A value of 0 results in no debounce.
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_DEBOUNCE_COUNT_SHIFT                 _MK_SHIFT_CONST(16)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_DEBOUNCE_COUNT_FIELD                 (_MK_MASK_CONST(0x7) << USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_DEBOUNCE_COUNT_SHIFT)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_DEBOUNCE_COUNT_RANGE                 18:16
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_DEBOUNCE_COUNT_WOFFSET                       0x0
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_DEBOUNCE_COUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_DEBOUNCE_COUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_DEBOUNCE_COUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_DEBOUNCE_COUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//Suspend Set
// Software must write a 1 to this bit to set the PHY
// into suspend mode. Software should also write 0 to clear it.
// NOTE: It is required that software generate a  positive pulse on this
// bit to guarantee proper operation.
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_SET_SHIFT                      _MK_SHIFT_CONST(14)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_SET_FIELD                      (_MK_MASK_CONST(0x1) << USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_SET_SHIFT)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_SET_RANGE                      14:14
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_SET_WOFFSET                    0x0
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_SET_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_SET_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_SET_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_SET_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_SET_UNSET                      _MK_ENUM_CONST(0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_SET_SET                        _MK_ENUM_CONST(1)

// Reset going to UTMIP PHY (active high).
// This should be set to 1 whenever programming the UTMIP config registers.
// It should be cleared to 0 after the programming of UTMIP config registers is done.
// UTMIP config registers should be programmed only once before doing any transactions on USB.
// The UTMIP PHY registers should be programmed while UTMIP is in reset.
#define USB1_IF_USB_SUSP_CTRL_0_UTMIP_RESET_SHIFT                       _MK_SHIFT_CONST(11)
#define USB1_IF_USB_SUSP_CTRL_0_UTMIP_RESET_FIELD                       (_MK_MASK_CONST(0x1) << USB1_IF_USB_SUSP_CTRL_0_UTMIP_RESET_SHIFT)
#define USB1_IF_USB_SUSP_CTRL_0_UTMIP_RESET_RANGE                       11:11
#define USB1_IF_USB_SUSP_CTRL_0_UTMIP_RESET_WOFFSET                     0x0
#define USB1_IF_USB_SUSP_CTRL_0_UTMIP_RESET_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_UTMIP_RESET_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB1_IF_USB_SUSP_CTRL_0_UTMIP_RESET_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_UTMIP_RESET_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_UTMIP_RESET_DISABLE                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_SUSP_CTRL_0_UTMIP_RESET_ENABLE                      _MK_ENUM_CONST(1)

// Polarity of the suspend signal going to USB PHY.
// 0 = Active low (default)
// 1 = Active high
// This should not be changed by software.
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_POL_SHIFT                      _MK_SHIFT_CONST(10)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_POL_FIELD                      (_MK_MASK_CONST(0x1) << USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_POL_SHIFT)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_POL_RANGE                      10:10
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_POL_WOFFSET                    0x0
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_POL_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_POL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_POL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_POL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_POL_ACTIVE_LOW                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_POL_ACTIVE_HIGH                        _MK_ENUM_CONST(1)

// USB PHY clock valid interrupt enable
// If this bit is enabled, interrupt is generated
// whenever USB clocks are resumed from a suspend.
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_ENB_SHIFT                 _MK_SHIFT_CONST(9)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_ENB_FIELD                 (_MK_MASK_CONST(0x1) << USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_ENB_SHIFT)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_ENB_RANGE                 9:9
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_ENB_WOFFSET                       0x0
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_ENB_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_ENB_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_ENB_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_ENB_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_ENB_DISABLE                       _MK_ENUM_CONST(0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_ENB_ENABLE                        _MK_ENUM_CONST(1)

// USB PHY clock valid interrupt status
// This bit is set whenever USB PHY clock is waked up from suspend.
// Software must write a 1 to clear this bit.
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_STS_SHIFT                 _MK_SHIFT_CONST(8)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_STS_FIELD                 (_MK_MASK_CONST(0x1) << USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_STS_SHIFT)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_STS_RANGE                 8:8
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_STS_WOFFSET                       0x0
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_STS_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_STS_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_STS_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_STS_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_STS_UNSET                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_INT_STS_SET                   _MK_ENUM_CONST(1)

// USB PHY clock valid status
// This bit indicates whether the USB PHY is generating a valid clock to 
// the USB controller.
// If USB PHY clock is running, this bit is set to 1, else it is set to 0.
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_SHIFT                 _MK_SHIFT_CONST(7)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_FIELD                 (_MK_MASK_CONST(0x1) << USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_SHIFT)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_RANGE                 7:7
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_WOFFSET                       0x0
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_UNSET                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_PHY_CLK_VALID_SET                   _MK_ENUM_CONST(1)

// USB AHB clock enable status.
// Indicates whether the AHB clock to the USB controller is enabled or not.
// If AHB clock to USB controller is enabled, this bit is set to 1, else it is set to 0.
// NOTE: even when this is set to 0, all essential blocks that are required
// to resume USB clocks from suspend will be active and their AHB clock will not
// be suspended.
#define USB1_IF_USB_SUSP_CTRL_0_USB_CLKEN_SHIFT                 _MK_SHIFT_CONST(6)
#define USB1_IF_USB_SUSP_CTRL_0_USB_CLKEN_FIELD                 (_MK_MASK_CONST(0x1) << USB1_IF_USB_SUSP_CTRL_0_USB_CLKEN_SHIFT)
#define USB1_IF_USB_SUSP_CTRL_0_USB_CLKEN_RANGE                 6:6
#define USB1_IF_USB_SUSP_CTRL_0_USB_CLKEN_WOFFSET                       0x0
#define USB1_IF_USB_SUSP_CTRL_0_USB_CLKEN_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_CLKEN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_SUSP_CTRL_0_USB_CLKEN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_CLKEN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_CLKEN_UNSET                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_CLKEN_SET                   _MK_ENUM_CONST(1)

//Suspend Clear
// Software must write a 1 to this bit to bring the PHY
// out of suspend mode. This is used when the software stops the PHY
// clock during suspend and then wants to initiate a resume. Software
// should also write 0 to clear it.
// NOTE: It is required that software generate a  positive pulse on this
// bit to guarantee proper operation.
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_CLR_SHIFT                      _MK_SHIFT_CONST(5)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_CLR_FIELD                      (_MK_MASK_CONST(0x1) << USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_CLR_SHIFT)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_CLR_RANGE                      5:5
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_CLR_WOFFSET                    0x0
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_CLR_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_CLR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_CLR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_CLR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_CLR_UNSET                      _MK_ENUM_CONST(0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_SUSP_CLR_SET                        _MK_ENUM_CONST(1)

// Wake on Disconnect Enable (device mode)
// When enabled (1), USB device will wakeup
// from suspend on a disconnect event.
// This is only valid when USB controller is in device mode, it is
// not applicable when USB controller is in host mode.
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_DISCON_EN_DEV_SHIFT                 _MK_SHIFT_CONST(4)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_DISCON_EN_DEV_FIELD                 (_MK_MASK_CONST(0x1) << USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_DISCON_EN_DEV_SHIFT)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_DISCON_EN_DEV_RANGE                 4:4
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_DISCON_EN_DEV_WOFFSET                       0x0
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_DISCON_EN_DEV_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_DISCON_EN_DEV_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_DISCON_EN_DEV_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_DISCON_EN_DEV_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_DISCON_EN_DEV_DISABLE                       _MK_ENUM_CONST(0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_DISCON_EN_DEV_ENABLE                        _MK_ENUM_CONST(1)

// Wake on Connect Enable (device mode)
// When enabled (1), USB device will wakeup
// from suspend on a connect event.
// This is only valid when USB controller is in device mode, it is
// not applicable when USB controller is in host mode.
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_CNNT_EN_DEV_SHIFT                   _MK_SHIFT_CONST(3)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_CNNT_EN_DEV_FIELD                   (_MK_MASK_CONST(0x1) << USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_CNNT_EN_DEV_SHIFT)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_CNNT_EN_DEV_RANGE                   3:3
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_CNNT_EN_DEV_WOFFSET                 0x0
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_CNNT_EN_DEV_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_CNNT_EN_DEV_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_CNNT_EN_DEV_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_CNNT_EN_DEV_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_CNNT_EN_DEV_DISABLE                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_CNNT_EN_DEV_ENABLE                  _MK_ENUM_CONST(1)

// Wake on resume enable
// If this bit is enabled, USB will wakeup from
// suspend whenever a resume event is detected on USB.
// This is valid for both USB device and USB host modes.
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_RESUME_EN_SHIFT                     _MK_SHIFT_CONST(2)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_RESUME_EN_FIELD                     (_MK_MASK_CONST(0x1) << USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_RESUME_EN_SHIFT)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_RESUME_EN_RANGE                     2:2
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_RESUME_EN_WOFFSET                   0x0
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_RESUME_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_RESUME_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_RESUME_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_RESUME_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_RESUME_EN_DISABLE                   _MK_ENUM_CONST(0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKE_ON_RESUME_EN_ENABLE                    _MK_ENUM_CONST(1)

// USB wakeup interrupt enable
// If this bit is enabled, interrupt is generated
// whenever USB wakeup event is generated.
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_ENB_SHIFT                        _MK_SHIFT_CONST(1)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_ENB_FIELD                        (_MK_MASK_CONST(0x1) << USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_ENB_SHIFT)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_ENB_RANGE                        1:1
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_ENB_WOFFSET                      0x0
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_ENB_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_ENB_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_ENB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_ENB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_ENB_DISABLE                      _MK_ENUM_CONST(0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_ENB_ENABLE                       _MK_ENUM_CONST(1)

// USB wakeup interrupt status
// This bit is set whenever USB wakes up from suspend (a wakeup event
// is generated).
// Software must write a 1 to clear this bit.
// Note that during the wakeup sequence, PHY clocks will be resumed from suspend.
// Software can check when the PHY clocks are resumed by reading the bit
// USB_PHY_CLK_VALID. There is also a separate interrupt generated
// when PHY clock is resumed if USB_PHY_CLK_VALID_INT_EN is set.
// During the wakeup sequence, first USB_WAKEUP_INT_STS will be set, and
// it will take some time for the PHY clock to resume, which can be detected
// by checking USB_PHY_CLK_VALID.
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_STS_SHIFT                        _MK_SHIFT_CONST(0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_STS_FIELD                        (_MK_MASK_CONST(0x1) << USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_STS_SHIFT)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_STS_RANGE                        0:0
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_STS_WOFFSET                      0x0
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_STS_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_STS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_STS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_STS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_STS_UNSET                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_SUSP_CTRL_0_USB_WAKEUP_INT_STS_SET                  _MK_ENUM_CONST(1)


// Register USB1_IF_USB_PHY_VBUS_SENSORS_0  
#define USB1_IF_USB_PHY_VBUS_SENSORS_0                  _MK_ADDR_CONST(0x404)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_SECURE                   0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_WORD_COUNT                       0x1
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_RESET_MASK                       _MK_MASK_CONST(0x7f7f7f7f)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_READ_MASK                        _MK_MASK_CONST(0x7f7f7f7f)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_WRITE_MASK                       _MK_MASK_CONST(0x79797979)
// A_VBUS_VLD wakeup enable
// If this bit is enabled, USB will wakeup from
// suspend whenever a change is detected on A_VBUS_VLD.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_WAKEUP_EN_SHIFT                       _MK_SHIFT_CONST(30)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_WAKEUP_EN_FIELD                       (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_WAKEUP_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_WAKEUP_EN_RANGE                       30:30
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_WAKEUP_EN_WOFFSET                     0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_WAKEUP_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_WAKEUP_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_WAKEUP_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_WAKEUP_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_WAKEUP_EN_DISABLE                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_WAKEUP_EN_ENABLE                      _MK_ENUM_CONST(1)

// A_VBUS_VLD debounce A/B select
// Selects between the two debounce values 
// UTMIP_BIAS_DEBOUNCE_A or
// UTMIP_BIAS_DEBOUNCE_B from the register
// UTMIP_DEBOUNCE_CFG0.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_SHIFT                       _MK_SHIFT_CONST(29)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_FIELD                       (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_RANGE                       29:29
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_WOFFSET                     0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_SEL_A                       _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_DEB_SEL_B_SEL_B                       _MK_ENUM_CONST(1)

// A_VBUS_VLD software value
// Software should write the appropriate
// value (1/0) to set/unset the A_VBUS_VLD status.
// This is only valid when A_VBUS_VLD_SW_EN is set.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_SHIFT                        _MK_SHIFT_CONST(28)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_FIELD                        (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_RANGE                        28:28
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_WOFFSET                      0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_UNSET                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_VALUE_SET                  _MK_ENUM_CONST(1)

// A_VBUS_VLD software enable
// Enable Software Controlled A_VBUS_VLD.
// Software sets this bit to drive the
// value in A_VBUS_VLD_SW_VALUE to the USB
// controller.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_SHIFT                   _MK_SHIFT_CONST(27)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_FIELD                   (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_RANGE                   27:27
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_WOFFSET                 0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_DISABLE                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_SW_EN_ENABLE                  _MK_ENUM_CONST(1)

// A_VBUS_VLD status
// This is set to 1 whenever A_VBUS_VLD sensor
// output is 1.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_SHIFT                     _MK_SHIFT_CONST(26)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_FIELD                     (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_RANGE                     26:26
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_WOFFSET                   0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_UNSET                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_STS_SET                       _MK_ENUM_CONST(1)

// A_VBUS_VLD change detect.
// This field is set by hardware whenever a change
// is detected in the value of A_VBUS_VLD.
// software writes a 1 to clear it
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_SHIFT                 _MK_SHIFT_CONST(25)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_FIELD                 (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_RANGE                 25:25
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_WOFFSET                       0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_UNSET                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_CHG_DET_SET                   _MK_ENUM_CONST(1)

// A_VBUS_VLD interrupt enable
// If this field is set to 1, an interrupt is
// generated whenever A_VBUS_VLD_CHG_DET is set to 1.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_SHIFT                  _MK_SHIFT_CONST(24)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_FIELD                  (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_RANGE                  24:24
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_WOFFSET                        0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_DISABLE                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_VBUS_VLD_INT_EN_ENABLE                 _MK_ENUM_CONST(1)

// A_SESS_VLD wakeup enable
// If this bit is enabled, USB will wakeup from
// suspend whenever a change is detected on A_SESS_VLD.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_WAKEUP_EN_SHIFT                       _MK_SHIFT_CONST(22)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_WAKEUP_EN_FIELD                       (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_WAKEUP_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_WAKEUP_EN_RANGE                       22:22
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_WAKEUP_EN_WOFFSET                     0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_WAKEUP_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_WAKEUP_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_WAKEUP_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_WAKEUP_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_WAKEUP_EN_DISABLE                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_WAKEUP_EN_ENABLE                      _MK_ENUM_CONST(1)

// A_SESS_VLD debounce A/B select
// Selects between the two debounce values 
// UTMIP_BIAS_DEBOUNCE_A or
// UTMIP_BIAS_DEBOUNCE_B from the register
// UTMIP_DEBOUNCE_CFG0.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_SHIFT                       _MK_SHIFT_CONST(21)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_FIELD                       (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_RANGE                       21:21
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_WOFFSET                     0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_SEL_A                       _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_DEB_SEL_B_SEL_B                       _MK_ENUM_CONST(1)

// A_SESS_VLD software value
// Software should write the appropriate
// value (1/0) to set/unset the A_SESS_VLD status.
// This is only valid when A_SESS_VLD_SW_EN is set.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_SHIFT                        _MK_SHIFT_CONST(20)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_FIELD                        (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_RANGE                        20:20
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_WOFFSET                      0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_UNSET                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_VALUE_SET                  _MK_ENUM_CONST(1)

// A_SESS_VLD software enable
// Enable Software Controlled A_SESS_VLD.
// Software sets this bit to drive the
// value in A_SESS_VLD_SW_VALUE to the USB
// controller.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_SHIFT                   _MK_SHIFT_CONST(19)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_FIELD                   (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_RANGE                   19:19
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_WOFFSET                 0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_DISABLE                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_SW_EN_ENABLE                  _MK_ENUM_CONST(1)

// A_SESS_VLD status
// This is set to 1 whenever A_SESS_VLD sensor
// output is 1.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_SHIFT                     _MK_SHIFT_CONST(18)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_FIELD                     (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_RANGE                     18:18
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_WOFFSET                   0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_UNSET                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_STS_SET                       _MK_ENUM_CONST(1)

// A_SESS_VLD change detect.
// This field is set by hardware whenever a change
// is detected in the value of A_SESS_VLD.
// software writes a 1 to clear it
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_SHIFT                 _MK_SHIFT_CONST(17)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_FIELD                 (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_RANGE                 17:17
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_WOFFSET                       0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_UNSET                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_CHG_DET_SET                   _MK_ENUM_CONST(1)

// A_SESS_VLD interrupt enable
// If this field is set to 1, an interrupt is
// generated whenever A_SESS_VLD_CHG_DET is set to 1.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_SHIFT                  _MK_SHIFT_CONST(16)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_FIELD                  (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_RANGE                  16:16
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_WOFFSET                        0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_DISABLE                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_A_SESS_VLD_INT_EN_ENABLE                 _MK_ENUM_CONST(1)

// B_SESS_VLD wakeup enable
// If this bit is enabled, USB will wakeup from
// suspend whenever a change is detected on B_SESS_VLD.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_WAKEUP_EN_SHIFT                       _MK_SHIFT_CONST(14)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_WAKEUP_EN_FIELD                       (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_WAKEUP_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_WAKEUP_EN_RANGE                       14:14
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_WAKEUP_EN_WOFFSET                     0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_WAKEUP_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_WAKEUP_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_WAKEUP_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_WAKEUP_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_WAKEUP_EN_DISABLE                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_WAKEUP_EN_ENABLE                      _MK_ENUM_CONST(1)

// B_SESS_VLD debounce A/B select
// Selects between the two debounce values 
// UTMIP_BIAS_DEBOUNCE_A or
// UTMIP_BIAS_DEBOUNCE_B from the register
// UTMIP_DEBOUNCE_CFG0.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_SHIFT                       _MK_SHIFT_CONST(13)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_FIELD                       (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_RANGE                       13:13
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_WOFFSET                     0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_SEL_A                       _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_DEB_SEL_B_SEL_B                       _MK_ENUM_CONST(1)

// B_SESS_VLD software value
// Software should write the appropriate
// value (1/0) to set/unset the B_SESS_VLD status.
// This is only valid when B_SESS_VLD_SW_EN is set.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_SHIFT                        _MK_SHIFT_CONST(12)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_FIELD                        (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_RANGE                        12:12
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_WOFFSET                      0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_UNSET                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_VALUE_SET                  _MK_ENUM_CONST(1)

// B_SESS_VLD software enable
// Enable Software Controlled B_SESS_VLD.
// Software sets this bit to drive the
// value in B_SESS_VLD_SW_VALUE to the USB
// controller.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_SHIFT                   _MK_SHIFT_CONST(11)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_FIELD                   (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_RANGE                   11:11
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_WOFFSET                 0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_DISABLE                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_SW_EN_ENABLE                  _MK_ENUM_CONST(1)

// B_SESS_VLD status
// This is set to 1 whenever B_SESS_VLD sensor
// output is 1.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_SHIFT                     _MK_SHIFT_CONST(10)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_FIELD                     (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_RANGE                     10:10
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_WOFFSET                   0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_UNSET                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_STS_SET                       _MK_ENUM_CONST(1)

// B_SESS_VLD change detect.
// This field is set by hardware whenever a change
// is detected in the value of B_SESS_VLD.
// software writes a 1 to clear it
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_SHIFT                 _MK_SHIFT_CONST(9)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_FIELD                 (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_RANGE                 9:9
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_WOFFSET                       0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_UNSET                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_CHG_DET_SET                   _MK_ENUM_CONST(1)

// B_SESS_VLD interrupt enable
// If this field is set to 1, an interrupt is
// generated whenever B_SESS_VLD_CHG_DET is set to 1.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_SHIFT                  _MK_SHIFT_CONST(8)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_FIELD                  (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_RANGE                  8:8
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_WOFFSET                        0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_DISABLE                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_VLD_INT_EN_ENABLE                 _MK_ENUM_CONST(1)

// B_SESS_END wakeup enable
// If this bit is enabled, USB will wakeup from
// suspend whenever a change is detected on B_SESS_END.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_WAKEUP_EN_SHIFT                       _MK_SHIFT_CONST(6)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_WAKEUP_EN_FIELD                       (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_WAKEUP_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_WAKEUP_EN_RANGE                       6:6
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_WAKEUP_EN_WOFFSET                     0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_WAKEUP_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_WAKEUP_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_WAKEUP_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_WAKEUP_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_WAKEUP_EN_DISABLE                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_WAKEUP_EN_ENABLE                      _MK_ENUM_CONST(1)

// B_SESS_END debounce A/B select
// Selects between the two debounce values 
// UTMIP_BIAS_DEBOUNCE_A or
// UTMIP_BIAS_DEBOUNCE_B from the register
// UTMIP_DEBOUNCE_CFG0.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_SHIFT                       _MK_SHIFT_CONST(5)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_FIELD                       (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_RANGE                       5:5
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_WOFFSET                     0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_SEL_A                       _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_DEB_SEL_B_SEL_B                       _MK_ENUM_CONST(1)

// B_SESS_END software value
// Software should write the appropriate
// value (1/0) to set/unset the B_SESS_END status.
// This is only valid when B_SESS_END_SW_EN is set.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_SHIFT                        _MK_SHIFT_CONST(4)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_FIELD                        (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_RANGE                        4:4
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_WOFFSET                      0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_UNSET                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_VALUE_SET                  _MK_ENUM_CONST(1)

// B_SESS_END software enable
// Enable Software Controlled B_SESS_END
// Software sets this bit to drive the
// value in B_SESS_END_SW_VALUE to the USB
// controller.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_SHIFT                   _MK_SHIFT_CONST(3)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_FIELD                   (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_RANGE                   3:3
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_WOFFSET                 0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_DISABLE                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_SW_EN_ENABLE                  _MK_ENUM_CONST(1)

// B_SESS_END status
// This is set to 1 whenever B_SESS_END sensor
// output is 1.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_SHIFT                     _MK_SHIFT_CONST(2)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_FIELD                     (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_RANGE                     2:2
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_WOFFSET                   0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_UNSET                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_STS_SET                       _MK_ENUM_CONST(1)

// B_SESS_END change detect.
// This field is set by hardware whenever a change
// is detected in the value of B_SESS_END.
// software writes a 1 to clear it
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_SHIFT                 _MK_SHIFT_CONST(1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_FIELD                 (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_RANGE                 1:1
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_WOFFSET                       0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_UNSET                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_CHG_DET_SET                   _MK_ENUM_CONST(1)

// B_SESS_END interrupt enable
// If this field is set to 1, an interrupt is
// generated whenever B_SESS_END_CHG_DET is set to 1.
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_SHIFT                  _MK_SHIFT_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_FIELD                  (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_RANGE                  0:0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_WOFFSET                        0x0
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_DISABLE                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_SENSORS_0_B_SESS_END_INT_EN_ENABLE                 _MK_ENUM_CONST(1)


// Register USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0  
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0                        _MK_ADDR_CONST(0x408)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_SECURE                         0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_WORD_COUNT                     0x1
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_RESET_VAL                      _MK_MASK_CONST(0x40)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_RESET_MASK                     _MK_MASK_CONST(0x403f3f7f)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_READ_MASK                      _MK_MASK_CONST(0x403f3f7f)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_WRITE_MASK                     _MK_MASK_CONST(0x40393979)
// VDAT_DET debounce A/B select
// Selects between the two debounce values 
// UTMIP_BIAS_DEBOUNCE_A or
// UTMIP_BIAS_DEBOUNCE_B from the register
// UTMIP_DEBOUNCE_CFG0.
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_SHIFT                       _MK_SHIFT_CONST(21)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_FIELD                       (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_RANGE                       21:21
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_WOFFSET                     0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_SEL_A                       _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_DEB_SEL_B_SEL_B                       _MK_ENUM_CONST(1)

// VDAT_DET software value
// Software should write the appropriate
// value (1/0) to set/unset the VDAT_DET status.
// This is only valid when VDAT_DET_SW_EN is set.
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_SHIFT                        _MK_SHIFT_CONST(20)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_FIELD                        (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_RANGE                        20:20
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_WOFFSET                      0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_UNSET                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_VALUE_SET                  _MK_ENUM_CONST(1)

// VDAT_DET software enable
// Enable Software Controlled VDAT_DET.
// Software sets this bit to drive the
// value in VDAT_DET_SW_VALUE to the USB
// controller
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_SHIFT                   _MK_SHIFT_CONST(19)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_FIELD                   (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_RANGE                   19:19
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_WOFFSET                 0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_DISABLE                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_SW_EN_ENABLE                  _MK_ENUM_CONST(1)

// VDAT_DET status
// This is set to 1 whenever VDAT_DET sensor
// output is 1.
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_SHIFT                     _MK_SHIFT_CONST(18)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_FIELD                     (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_RANGE                     18:18
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_WOFFSET                   0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_UNSET                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_STS_SET                       _MK_ENUM_CONST(1)

// VDAT_DET change detect.
// This field is set by hardware whenever a change
// is detected in the value of VDAT_DET.
// software writes a 1 to clear it
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_SHIFT                 _MK_SHIFT_CONST(17)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_FIELD                 (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_RANGE                 17:17
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_WOFFSET                       0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_UNSET                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_CHG_DET_SET                   _MK_ENUM_CONST(1)

// VDAT_DET interrupt enable
// If this field is set to 1, an interrupt is
// generated whenever VDAT_DET_CHG_DET is set to 1.
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_SHIFT                  _MK_SHIFT_CONST(16)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_FIELD                  (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_RANGE                  16:16
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_WOFFSET                        0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_DISABLE                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VDAT_DET_INT_EN_ENABLE                 _MK_ENUM_CONST(1)

// VBUS_WAKEUP wakeup enable
// If this bit is enabled, USB will wakeup from
// suspend whenever a change is detected on VBUS_WAKEUP.
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_WAKEUP_EN_SHIFT                    _MK_SHIFT_CONST(30)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_WAKEUP_EN_FIELD                    (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_WAKEUP_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_WAKEUP_EN_RANGE                    30:30
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_WAKEUP_EN_WOFFSET                  0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_WAKEUP_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_WAKEUP_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_WAKEUP_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_WAKEUP_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_WAKEUP_EN_DISABLE                  _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_WAKEUP_EN_ENABLE                   _MK_ENUM_CONST(1)

// VBUS_WAKEUP debounce A/B select
// Selects between the two debounce values 
// UTMIP_BIAS_DEBOUNCE_A or
// UTMIP_BIAS_DEBOUNCE_B from the register
// UTMIP_DEBOUNCE_CFG0.
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_SHIFT                    _MK_SHIFT_CONST(13)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_FIELD                    (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_RANGE                    13:13
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_WOFFSET                  0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_SEL_A                    _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_DEB_SEL_B_SEL_B                    _MK_ENUM_CONST(1)

// VBUS wakeup software value
// Software should write the appropriate
// value (1/0) to set/unset the VBUS_WAKEUP status.
// This is only valid when VBUS_WAKEUP_SW_EN is set.
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_SHIFT                     _MK_SHIFT_CONST(12)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_FIELD                     (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_RANGE                     12:12
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_WOFFSET                   0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_UNSET                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_VALUE_SET                       _MK_ENUM_CONST(1)

// VBUS wakeup software enable
// Enable Software Controlled VBUS_WAKEUP.
// Software sets this bit to drive the
// value in VBUS_WAKEUP_SW_VALUE to the USB
// controller.
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_SHIFT                        _MK_SHIFT_CONST(11)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_FIELD                        (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_RANGE                        11:11
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_WOFFSET                      0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_DISABLE                      _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_SW_EN_ENABLE                       _MK_ENUM_CONST(1)

// VBUS wakeup status
// This is set to 1 whenever VBUS_WAKEUP sensor
// output is 1.
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_SHIFT                  _MK_SHIFT_CONST(10)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_FIELD                  (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_RANGE                  10:10
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_WOFFSET                        0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_UNSET                  _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_STS_SET                    _MK_ENUM_CONST(1)

// VBUS wakeup change detect.
// This field is set by hardware whenever a change
// is detected in the value of VBUS_WAKEUP.
// software writes a 1 to clear it
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_SHIFT                      _MK_SHIFT_CONST(9)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_FIELD                      (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_RANGE                      9:9
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_WOFFSET                    0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_UNSET                      _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_CHG_DET_SET                        _MK_ENUM_CONST(1)

// VBUS wakeup interrupt enable
// If this field is set to 1, an interrupt is
// generated whenever VBUS_WAKEUP_CHG_DET is set to 1.
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_SHIFT                       _MK_SHIFT_CONST(8)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_FIELD                       (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_RANGE                       8:8
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_WOFFSET                     0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_VBUS_WAKEUP_INT_EN_ENABLE                      _MK_ENUM_CONST(1)

// ID pullup enable. Set to 1.
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_PU_SHIFT                    _MK_SHIFT_CONST(6)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_PU_FIELD                    (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_PU_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_PU_RANGE                    6:6
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_PU_WOFFSET                  0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_PU_DEFAULT                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_PU_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_PU_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_PU_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_PU_DISABLE                  _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_PU_ENABLE                   _MK_ENUM_CONST(1)

// ID debounce A/B select
// Selects between the two debounce values 
// UTMIP_BIAS_DEBOUNCE_A or
// UTMIP_BIAS_DEBOUNCE_B from the register
// UTMIP_DEBOUNCE_CFG0.
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_SHIFT                     _MK_SHIFT_CONST(5)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_FIELD                     (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_RANGE                     5:5
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_WOFFSET                   0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_SEL_A                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_DEB_SEL_B_SEL_B                     _MK_ENUM_CONST(1)

// ID software value
// Software should write the appropriate
// value (1/0) to set/unset the ID status.
// This is only valid when ID_SW_EN is set.
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_SHIFT                      _MK_SHIFT_CONST(4)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_FIELD                      (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_RANGE                      4:4
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_WOFFSET                    0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_UNSET                      _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_VALUE_SET                        _MK_ENUM_CONST(1)

// ID software enable
// Enable Software Controlled ID.
// Software sets this bit to drive the
// value in ID_SW_VALUE to the USB
// controller
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_SHIFT                 _MK_SHIFT_CONST(3)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_FIELD                 (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_RANGE                 3:3
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_WOFFSET                       0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_DISABLE                       _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_SW_EN_ENABLE                        _MK_ENUM_CONST(1)

// ID status
// This is set to 1 whenever ID sensor
// output is 1.
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_SHIFT                   _MK_SHIFT_CONST(2)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_FIELD                   (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_RANGE                   2:2
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_WOFFSET                 0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_UNSET                   _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_STS_SET                     _MK_ENUM_CONST(1)

// ID change detect.
// This field is set by hardware whenever a change
// is detected in the value of ID.
// software writes a 1 to clear it
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_SHIFT                       _MK_SHIFT_CONST(1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_FIELD                       (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_RANGE                       1:1
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_WOFFSET                     0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_UNSET                       _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_CHG_DET_SET                 _MK_ENUM_CONST(1)

// ID interrupt enable
// If this field is set to 1, an interrupt is
// generated whenever ID_CHG_DET is set to 1.
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_SHIFT                        _MK_SHIFT_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_FIELD                        (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_SHIFT)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_RANGE                        0:0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_WOFFSET                      0x0
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_DISABLE                      _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_VBUS_WAKEUP_ID_0_ID_INT_EN_ENABLE                       _MK_ENUM_CONST(1)


// Register USB1_IF_USB_PHY_ALT_VBUS_STS_0  
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0                  _MK_ADDR_CONST(0x40c)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_SECURE                   0x0
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_WORD_COUNT                       0x1
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_RESET_MASK                       _MK_MASK_CONST(0x7f)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_READ_MASK                        _MK_MASK_CONST(0x7f)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
// A_SESS_VLD alternate status
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_SESS_VLD_ALT_SHIFT                     _MK_SHIFT_CONST(6)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_SESS_VLD_ALT_FIELD                     (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_SESS_VLD_ALT_SHIFT)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_SESS_VLD_ALT_RANGE                     6:6
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_SESS_VLD_ALT_WOFFSET                   0x0
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_SESS_VLD_ALT_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_SESS_VLD_ALT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_SESS_VLD_ALT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_SESS_VLD_ALT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_SESS_VLD_ALT_UNSET                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_SESS_VLD_ALT_SET                       _MK_ENUM_CONST(1)

// B_SESS_VLD alternate status
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_VLD_ALT_SHIFT                     _MK_SHIFT_CONST(5)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_VLD_ALT_FIELD                     (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_VLD_ALT_SHIFT)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_VLD_ALT_RANGE                     5:5
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_VLD_ALT_WOFFSET                   0x0
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_VLD_ALT_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_VLD_ALT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_VLD_ALT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_VLD_ALT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_VLD_ALT_UNSET                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_VLD_ALT_SET                       _MK_ENUM_CONST(1)

// ID alternate status
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_SHIFT                 _MK_SHIFT_CONST(4)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_FIELD                 (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_SHIFT)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_RANGE                 4:4
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_WOFFSET                       0x0
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_UNSET                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_ID_DIG_ALT_SET                   _MK_ENUM_CONST(1)

// B_SESS_END alternate status
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_END_ALT_SHIFT                     _MK_SHIFT_CONST(3)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_END_ALT_FIELD                     (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_END_ALT_SHIFT)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_END_ALT_RANGE                     3:3
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_END_ALT_WOFFSET                   0x0
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_END_ALT_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_END_ALT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_END_ALT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_END_ALT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_END_ALT_UNSET                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_B_SESS_END_ALT_SET                       _MK_ENUM_CONST(1)

// Static GPI alternate status
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_SHIFT                     _MK_SHIFT_CONST(2)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_FIELD                     (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_SHIFT)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_RANGE                     2:2
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_WOFFSET                   0x0
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_UNSET                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_STATIC_GPI_ALT_SET                       _MK_ENUM_CONST(1)

// A_VBUS_VLD alternate status
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_VBUS_VLD_ALT_SHIFT                     _MK_SHIFT_CONST(1)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_VBUS_VLD_ALT_FIELD                     (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_VBUS_VLD_ALT_SHIFT)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_VBUS_VLD_ALT_RANGE                     1:1
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_VBUS_VLD_ALT_WOFFSET                   0x0
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_VBUS_VLD_ALT_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_VBUS_VLD_ALT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_VBUS_VLD_ALT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_VBUS_VLD_ALT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_VBUS_VLD_ALT_UNSET                     _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_A_VBUS_VLD_ALT_SET                       _MK_ENUM_CONST(1)

// Vbus wakeup alternate status
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_SHIFT                    _MK_SHIFT_CONST(0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_FIELD                    (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_SHIFT)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_RANGE                    0:0
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_WOFFSET                  0x0
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_UNSET                    _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_ALT_VBUS_STS_0_VBUS_WAKEUP_ALT_SET                      _MK_ENUM_CONST(1)


// Register USB1_IF_USB1_LEGACY_CTRL_0  
#define USB1_IF_USB1_LEGACY_CTRL_0                      _MK_ADDR_CONST(0x410)
#define USB1_IF_USB1_LEGACY_CTRL_0_SECURE                       0x0
#define USB1_IF_USB1_LEGACY_CTRL_0_WORD_COUNT                   0x1
#define USB1_IF_USB1_LEGACY_CTRL_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB1_LEGACY_CTRL_0_RESET_MASK                   _MK_MASK_CONST(0x7)
#define USB1_IF_USB1_LEGACY_CTRL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB1_LEGACY_CTRL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB1_LEGACY_CTRL_0_READ_MASK                    _MK_MASK_CONST(0x7)
#define USB1_IF_USB1_LEGACY_CTRL_0_WRITE_MASK                   _MK_MASK_CONST(0x7)
// Vbus_sense control
// Controls which VBUS sensor input is driven to the controller.
// 00: Use VBUS_WAKEUP.
// 01: Use (A_SESS_VLD || B_SESS_VLD) output from the PHY if the PHY clock is available.
// Otherwise, use VBUS_WAKEUP.
// 10: Use (A_SESS_VLD || B_SESS_VLD) output from the PHY
// 11: Use A_SESS_VLD output from the PHY
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_VBUS_SENSE_CTL_SHIFT                    _MK_SHIFT_CONST(1)
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_VBUS_SENSE_CTL_FIELD                    (_MK_MASK_CONST(0x3) << USB1_IF_USB1_LEGACY_CTRL_0_USB1_VBUS_SENSE_CTL_SHIFT)
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_VBUS_SENSE_CTL_RANGE                    2:1
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_VBUS_SENSE_CTL_WOFFSET                  0x0
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_VBUS_SENSE_CTL_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_VBUS_SENSE_CTL_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_VBUS_SENSE_CTL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_VBUS_SENSE_CTL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_VBUS_SENSE_CTL_VBUS_WAKEUP                      _MK_ENUM_CONST(0)
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_VBUS_SENSE_CTL_AB_SESS_VLD_OR_VBUS_WAKEUP                       _MK_ENUM_CONST(1)
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_VBUS_SENSE_CTL_AB_SESS_VLD                      _MK_ENUM_CONST(2)
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_VBUS_SENSE_CTL_A_SESS_VLD                       _MK_ENUM_CONST(3)

// Legacy registers select
// The default is to select legacy mode registers in 
// APB_MISC for USB1. Selects new registers if this is set to 1.
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_NO_LEGACY_MODE_SHIFT                    _MK_SHIFT_CONST(0)
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_NO_LEGACY_MODE_FIELD                    (_MK_MASK_CONST(0x1) << USB1_IF_USB1_LEGACY_CTRL_0_USB1_NO_LEGACY_MODE_SHIFT)
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_NO_LEGACY_MODE_RANGE                    0:0
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_NO_LEGACY_MODE_WOFFSET                  0x0
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_NO_LEGACY_MODE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_NO_LEGACY_MODE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_NO_LEGACY_MODE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_NO_LEGACY_MODE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_NO_LEGACY_MODE_LEGACY                   _MK_ENUM_CONST(0)
#define USB1_IF_USB1_LEGACY_CTRL_0_USB1_NO_LEGACY_MODE_NEW                      _MK_ENUM_CONST(1)


// Reserved address 1044 [0x414] 

// Reserved address 1048 [0x418] 

// Reserved address 1052 [0x41c] 

// Register USB1_IF_USB_INTER_PKT_DELAY_CTRL_0  
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0                      _MK_ADDR_CONST(0x420)
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_SECURE                       0x0
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_WORD_COUNT                   0x1
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_RESET_VAL                    _MK_MASK_CONST(0x6)
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_RESET_MASK                   _MK_MASK_CONST(0x3f)
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_READ_MASK                    _MK_MASK_CONST(0x3f)
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_WRITE_MASK                   _MK_MASK_CONST(0x3f)
// HS Tx to Tx inter-packet delay.
// Software should not change this.
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_IP_DELAY_TX2TX_HS_SHIFT                      _MK_SHIFT_CONST(0)
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_IP_DELAY_TX2TX_HS_FIELD                      (_MK_MASK_CONST(0x3f) << USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_IP_DELAY_TX2TX_HS_SHIFT)
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_IP_DELAY_TX2TX_HS_RANGE                      5:0
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_IP_DELAY_TX2TX_HS_WOFFSET                    0x0
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_IP_DELAY_TX2TX_HS_DEFAULT                    _MK_MASK_CONST(0x6)
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_IP_DELAY_TX2TX_HS_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_IP_DELAY_TX2TX_HS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_INTER_PKT_DELAY_CTRL_0_IP_DELAY_TX2TX_HS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Reserved address 1060 [0x424] 

// Reserved address 1064 [0x428] 

// Register USB1_IF_USB_DEBUG_0  
#define USB1_IF_USB_DEBUG_0                     _MK_ADDR_CONST(0x480)
#define USB1_IF_USB_DEBUG_0_SECURE                      0x0
#define USB1_IF_USB_DEBUG_0_WORD_COUNT                  0x1
#define USB1_IF_USB_DEBUG_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_DEBUG_0_RESET_MASK                  _MK_MASK_CONST(0x60)
#define USB1_IF_USB_DEBUG_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_DEBUG_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_DEBUG_0_READ_MASK                   _MK_MASK_CONST(0x60)
#define USB1_IF_USB_DEBUG_0_WRITE_MASK                  _MK_MASK_CONST(0x60)
// Lower 32-bits select.
// Only valid for Tx and Rx memories that
// have 36-bit interface. When 0, selects
// upper 4-bits. When 1, selects lower
// 32-bits.
#define USB1_IF_USB_DEBUG_0_USB_BUF_LOW32BITS_SEL_SHIFT                 _MK_SHIFT_CONST(6)
#define USB1_IF_USB_DEBUG_0_USB_BUF_LOW32BITS_SEL_FIELD                 (_MK_MASK_CONST(0x1) << USB1_IF_USB_DEBUG_0_USB_BUF_LOW32BITS_SEL_SHIFT)
#define USB1_IF_USB_DEBUG_0_USB_BUF_LOW32BITS_SEL_RANGE                 6:6
#define USB1_IF_USB_DEBUG_0_USB_BUF_LOW32BITS_SEL_WOFFSET                       0x0
#define USB1_IF_USB_DEBUG_0_USB_BUF_LOW32BITS_SEL_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_DEBUG_0_USB_BUF_LOW32BITS_SEL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_DEBUG_0_USB_BUF_LOW32BITS_SEL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_DEBUG_0_USB_BUF_LOW32BITS_SEL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_DEBUG_0_USB_BUF_LOW32BITS_SEL_UPPER_BITS                    _MK_ENUM_CONST(0)
#define USB1_IF_USB_DEBUG_0_USB_BUF_LOW32BITS_SEL_LOWER_BITS                    _MK_ENUM_CONST(1)

// Route USB buffers to AHB interface for debug.
// When this is set to 1, normal USB
// operations cannot be done.
#define USB1_IF_USB_DEBUG_0_USB_BUF_AHB_IF_SEL_SHIFT                    _MK_SHIFT_CONST(5)
#define USB1_IF_USB_DEBUG_0_USB_BUF_AHB_IF_SEL_FIELD                    (_MK_MASK_CONST(0x1) << USB1_IF_USB_DEBUG_0_USB_BUF_AHB_IF_SEL_SHIFT)
#define USB1_IF_USB_DEBUG_0_USB_BUF_AHB_IF_SEL_RANGE                    5:5
#define USB1_IF_USB_DEBUG_0_USB_BUF_AHB_IF_SEL_WOFFSET                  0x0
#define USB1_IF_USB_DEBUG_0_USB_BUF_AHB_IF_SEL_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_DEBUG_0_USB_BUF_AHB_IF_SEL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB1_IF_USB_DEBUG_0_USB_BUF_AHB_IF_SEL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_DEBUG_0_USB_BUF_AHB_IF_SEL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_DEBUG_0_USB_BUF_AHB_IF_SEL_DISABLE                  _MK_ENUM_CONST(0)
#define USB1_IF_USB_DEBUG_0_USB_BUF_AHB_IF_SEL_ENABLE                   _MK_ENUM_CONST(1)


// Register USB1_IF_USB_PHY_SELF_TEST_0  
#define USB1_IF_USB_PHY_SELF_TEST_0                     _MK_ADDR_CONST(0x484)
#define USB1_IF_USB_PHY_SELF_TEST_0_SECURE                      0x0
#define USB1_IF_USB_PHY_SELF_TEST_0_WORD_COUNT                  0x1
#define USB1_IF_USB_PHY_SELF_TEST_0_RESET_VAL                   _MK_MASK_CONST(0x10150008)
#define USB1_IF_USB_PHY_SELF_TEST_0_RESET_MASK                  _MK_MASK_CONST(0xfffff37f)
#define USB1_IF_USB_PHY_SELF_TEST_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_READ_MASK                   _MK_MASK_CONST(0xfffff37f)
#define USB1_IF_USB_PHY_SELF_TEST_0_WRITE_MASK                  _MK_MASK_CONST(0xffff7373)
// No of test packets to be sent. 0 = infinite, continue sending
// packets until test mode is disabled.
#define USB1_IF_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_SHIFT                  _MK_SHIFT_CONST(24)
#define USB1_IF_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_FIELD                  (_MK_MASK_CONST(0xff) << USB1_IF_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_RANGE                  31:24
#define USB1_IF_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_WOFFSET                        0x0
#define USB1_IF_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_DEFAULT                        _MK_MASK_CONST(0x10)
#define USB1_IF_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define USB1_IF_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TEST_PKT_CNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Interpacket delay between two consecutive packets in no of 60 Mhz cycles
#define USB1_IF_USB_PHY_SELF_TEST_0_IPKT_DLY_SHIFT                      _MK_SHIFT_CONST(16)
#define USB1_IF_USB_PHY_SELF_TEST_0_IPKT_DLY_FIELD                      (_MK_MASK_CONST(0xff) << USB1_IF_USB_PHY_SELF_TEST_0_IPKT_DLY_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_0_IPKT_DLY_RANGE                      23:16
#define USB1_IF_USB_PHY_SELF_TEST_0_IPKT_DLY_WOFFSET                    0x0
#define USB1_IF_USB_PHY_SELF_TEST_0_IPKT_DLY_DEFAULT                    _MK_MASK_CONST(0x15)
#define USB1_IF_USB_PHY_SELF_TEST_0_IPKT_DLY_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define USB1_IF_USB_PHY_SELF_TEST_0_IPKT_DLY_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_IPKT_DLY_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Status of Disconnect signal from PHY
#define USB1_IF_USB_PHY_SELF_TEST_0_DISCON_SHIFT                        _MK_SHIFT_CONST(15)
#define USB1_IF_USB_PHY_SELF_TEST_0_DISCON_FIELD                        (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_SELF_TEST_0_DISCON_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_0_DISCON_RANGE                        15:15
#define USB1_IF_USB_PHY_SELF_TEST_0_DISCON_WOFFSET                      0x0
#define USB1_IF_USB_PHY_SELF_TEST_0_DISCON_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_DISCON_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST_0_DISCON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_DISCON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_DISCON_UNSET                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST_0_DISCON_SET                  _MK_ENUM_CONST(1)

// Enable transmission of SOF
#define USB1_IF_USB_PHY_SELF_TEST_0_SOF_EN_SHIFT                        _MK_SHIFT_CONST(14)
#define USB1_IF_USB_PHY_SELF_TEST_0_SOF_EN_FIELD                        (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_SELF_TEST_0_SOF_EN_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_0_SOF_EN_RANGE                        14:14
#define USB1_IF_USB_PHY_SELF_TEST_0_SOF_EN_WOFFSET                      0x0
#define USB1_IF_USB_PHY_SELF_TEST_0_SOF_EN_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_SOF_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST_0_SOF_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_SOF_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_SOF_EN_DISABLE                      _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST_0_SOF_EN_ENABLE                       _MK_ENUM_CONST(1)

// Enable pulldown on DP
#define USB1_IF_USB_PHY_SELF_TEST_0_DPPD_SHIFT                  _MK_SHIFT_CONST(13)
#define USB1_IF_USB_PHY_SELF_TEST_0_DPPD_FIELD                  (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_SELF_TEST_0_DPPD_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_0_DPPD_RANGE                  13:13
#define USB1_IF_USB_PHY_SELF_TEST_0_DPPD_WOFFSET                        0x0
#define USB1_IF_USB_PHY_SELF_TEST_0_DPPD_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_DPPD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST_0_DPPD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_DPPD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_DPPD_DISABLE                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST_0_DPPD_ENABLE                 _MK_ENUM_CONST(1)

// Enable pulldown on DM
#define USB1_IF_USB_PHY_SELF_TEST_0_DMPD_SHIFT                  _MK_SHIFT_CONST(12)
#define USB1_IF_USB_PHY_SELF_TEST_0_DMPD_FIELD                  (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_SELF_TEST_0_DMPD_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_0_DMPD_RANGE                  12:12
#define USB1_IF_USB_PHY_SELF_TEST_0_DMPD_WOFFSET                        0x0
#define USB1_IF_USB_PHY_SELF_TEST_0_DMPD_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_DMPD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST_0_DMPD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_DMPD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_DMPD_DISABLE                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST_0_DMPD_ENABLE                 _MK_ENUM_CONST(1)

// Operational Mode
#define USB1_IF_USB_PHY_SELF_TEST_0_OPMODE_SHIFT                        _MK_SHIFT_CONST(8)
#define USB1_IF_USB_PHY_SELF_TEST_0_OPMODE_FIELD                        (_MK_MASK_CONST(0x3) << USB1_IF_USB_PHY_SELF_TEST_0_OPMODE_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_0_OPMODE_RANGE                        9:8
#define USB1_IF_USB_PHY_SELF_TEST_0_OPMODE_WOFFSET                      0x0
#define USB1_IF_USB_PHY_SELF_TEST_0_OPMODE_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_OPMODE_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define USB1_IF_USB_PHY_SELF_TEST_0_OPMODE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_OPMODE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Term_select
#define USB1_IF_USB_PHY_SELF_TEST_0_TERM_SHIFT                  _MK_SHIFT_CONST(6)
#define USB1_IF_USB_PHY_SELF_TEST_0_TERM_FIELD                  (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_SELF_TEST_0_TERM_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_0_TERM_RANGE                  6:6
#define USB1_IF_USB_PHY_SELF_TEST_0_TERM_WOFFSET                        0x0
#define USB1_IF_USB_PHY_SELF_TEST_0_TERM_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TERM_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST_0_TERM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TERM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// XCVR_select:
#define USB1_IF_USB_PHY_SELF_TEST_0_XCVR_SHIFT                  _MK_SHIFT_CONST(4)
#define USB1_IF_USB_PHY_SELF_TEST_0_XCVR_FIELD                  (_MK_MASK_CONST(0x3) << USB1_IF_USB_PHY_SELF_TEST_0_XCVR_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_0_XCVR_RANGE                  5:4
#define USB1_IF_USB_PHY_SELF_TEST_0_XCVR_WOFFSET                        0x0
#define USB1_IF_USB_PHY_SELF_TEST_0_XCVR_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_XCVR_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define USB1_IF_USB_PHY_SELF_TEST_0_XCVR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_XCVR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// When test is started, this status signal starts as  1 and is set to 0 if an error is detected. Can be sampled when TSTEND is  asserted.
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTPS_SHIFT                 _MK_SHIFT_CONST(3)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTPS_FIELD                 (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_SELF_TEST_0_TSTPS_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTPS_RANGE                 3:3
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTPS_WOFFSET                       0x0
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTPS_DEFAULT                       _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTPS_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTPS_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTPS_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTPS_UNSET                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTPS_SET                   _MK_ENUM_CONST(1)

// Goes to 1 when the test finishes. At that time,  TSTPASS is valid and indicates the tests pass/fail status
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTEND_SHIFT                        _MK_SHIFT_CONST(2)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTEND_FIELD                        (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_SELF_TEST_0_TSTEND_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTEND_RANGE                        2:2
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTEND_WOFFSET                      0x0
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTEND_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTEND_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTEND_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTEND_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTEND_UNSET                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTEND_SET                  _MK_ENUM_CONST(1)

// Sw writes a 1 to start the test. It writes a 0 to  end the test
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTON_SHIFT                 _MK_SHIFT_CONST(1)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTON_FIELD                 (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_SELF_TEST_0_TSTON_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTON_RANGE                 1:1
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTON_WOFFSET                       0x0
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTON_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTON_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTON_UNSET                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTON_SET                   _MK_ENUM_CONST(1)

// Place UTMIP in test mode. This does not start the test.
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTENB_SHIFT                        _MK_SHIFT_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTENB_FIELD                        (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_SELF_TEST_0_TSTENB_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTENB_RANGE                        0:0
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTENB_WOFFSET                      0x0
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTENB_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTENB_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTENB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTENB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTENB_DISABLE                      _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST_0_TSTENB_ENABLE                       _MK_ENUM_CONST(1)


// Register USB1_IF_USB_PHY_SELF_TEST2_0  
#define USB1_IF_USB_PHY_SELF_TEST2_0                    _MK_ADDR_CONST(0x488)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SECURE                     0x0
#define USB1_IF_USB_PHY_SELF_TEST2_0_WORD_COUNT                         0x1
#define USB1_IF_USB_PHY_SELF_TEST2_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_RESET_MASK                         _MK_MASK_CONST(0x1f)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_READ_MASK                  _MK_MASK_CONST(0x1f)
#define USB1_IF_USB_PHY_SELF_TEST2_0_WRITE_MASK                         _MK_MASK_CONST(0x1f)
// Enable reception of test packets
#define USB1_IF_USB_PHY_SELF_TEST2_0_RCV_TEST_PKT_SHIFT                 _MK_SHIFT_CONST(4)
#define USB1_IF_USB_PHY_SELF_TEST2_0_RCV_TEST_PKT_FIELD                 (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_SELF_TEST2_0_RCV_TEST_PKT_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST2_0_RCV_TEST_PKT_RANGE                 4:4
#define USB1_IF_USB_PHY_SELF_TEST2_0_RCV_TEST_PKT_WOFFSET                       0x0
#define USB1_IF_USB_PHY_SELF_TEST2_0_RCV_TEST_PKT_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_RCV_TEST_PKT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST2_0_RCV_TEST_PKT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_RCV_TEST_PKT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_RCV_TEST_PKT_DISABLE                       _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_RCV_TEST_PKT_ENABLE                        _MK_ENUM_CONST(1)

// Enable transmission of test packets
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_PKT_SHIFT                        _MK_SHIFT_CONST(3)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_PKT_FIELD                        (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_PKT_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_PKT_RANGE                        3:3
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_PKT_WOFFSET                      0x0
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_PKT_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_PKT_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_PKT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_PKT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_PKT_DISABLE                      _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_PKT_ENABLE                       _MK_ENUM_CONST(1)

// Enable TEST_J transmission
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_K_SHIFT                  _MK_SHIFT_CONST(2)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_K_FIELD                  (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_K_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_K_RANGE                  2:2
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_K_WOFFSET                        0x0
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_K_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_K_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_K_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_K_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_K_DISABLE                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_K_ENABLE                 _MK_ENUM_CONST(1)

// Enable TEST_K transmission
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_J_SHIFT                  _MK_SHIFT_CONST(1)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_J_FIELD                  (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_J_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_J_RANGE                  1:1
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_J_WOFFSET                        0x0
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_J_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_J_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_J_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_J_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_J_DISABLE                        _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_SEND_TEST_J_ENABLE                 _MK_ENUM_CONST(1)

// If enabled, send SOF with EOP of J, else
// send SOF with EOP of K
#define USB1_IF_USB_PHY_SELF_TEST2_0_TEST_SOF_J_SHIFT                   _MK_SHIFT_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_TEST_SOF_J_FIELD                   (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_SELF_TEST2_0_TEST_SOF_J_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST2_0_TEST_SOF_J_RANGE                   0:0
#define USB1_IF_USB_PHY_SELF_TEST2_0_TEST_SOF_J_WOFFSET                 0x0
#define USB1_IF_USB_PHY_SELF_TEST2_0_TEST_SOF_J_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_TEST_SOF_J_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST2_0_TEST_SOF_J_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_TEST_SOF_J_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_TEST_SOF_J_DISABLE                 _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST2_0_TEST_SOF_J_ENABLE                  _MK_ENUM_CONST(1)


// Register USB1_IF_USB_PHY_SELF_TEST_DEBUG_0  
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0                       _MK_ADDR_CONST(0x48c)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_SECURE                        0x0
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_WORD_COUNT                    0x1
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RESET_MASK                    _MK_MASK_CONST(0x3ff3f)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_READ_MASK                     _MK_MASK_CONST(0x3ff3f)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// RX compare fail. Comparison on RX data failed.
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_SHIFT                   _MK_SHIFT_CONST(17)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_FIELD                   (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_RANGE                   17:17
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_WOFFSET                 0x0
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_UNSET                   _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXCMF_SET                     _MK_ENUM_CONST(1)

// Rx valid/Rx validh fail: Indicates that the  Rxvalid/Rxvalidh werent generated according to protocol
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_SHIFT                   _MK_SHIFT_CONST(16)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_FIELD                   (_MK_MASK_CONST(0x1) << USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_RANGE                   16:16
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_WOFFSET                 0x0
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_UNSET                   _MK_ENUM_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_RXVHF_SET                     _MK_ENUM_CONST(1)

// Failed packet no: Points to the failed packet no
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_SHIFT                     _MK_SHIFT_CONST(8)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_FIELD                     (_MK_MASK_CONST(0xff) << USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_RANGE                     15:8
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_WOFFSET                   0x0
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_PKT_NO_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Failed RX byte index: Points to the Rx byte no. in  the current packet which fails
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_SHIFT                    _MK_SHIFT_CONST(0)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_FIELD                    (_MK_MASK_CONST(0x3f) << USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_SHIFT)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_RANGE                    5:0
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_WOFFSET                  0x0
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_DEFAULT_MASK                     _MK_MASK_CONST(0x3f)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_IF_USB_PHY_SELF_TEST_DEBUG_0_FAIL_RX_BYTE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register USB1_UTMIP_PLL_CFG0_0  // USB_PHY PLL Configuration Register 0
//
// The data sampling frequency relies on a 960MHz clock, so the goal of the PLL is to have:
// In_Frequency*(PLL_VCOMULTBY2+1)*(PLL_NDIV/PLL_MDIV) = 960MHz
//
// With a 12MHz input from PLL_U, the default setting of 
// PLL_VCOMULTBY2=1, PLL_NDIV=40 and PLL_MDIV=1 results in a correct output.
#define USB1_UTMIP_PLL_CFG0_0                   _MK_ADDR_CONST(0x800)
#define USB1_UTMIP_PLL_CFG0_0_SECURE                    0x0
#define USB1_UTMIP_PLL_CFG0_0_WORD_COUNT                        0x1
#define USB1_UTMIP_PLL_CFG0_0_RESET_VAL                         _MK_MASK_CONST(0x280180)
#define USB1_UTMIP_PLL_CFG0_0_RESET_MASK                        _MK_MASK_CONST(0x7fffffff)
#define USB1_UTMIP_PLL_CFG0_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG0_0_READ_MASK                         _MK_MASK_CONST(0x7fffffff)
#define USB1_UTMIP_PLL_CFG0_0_WRITE_MASK                        _MK_MASK_CONST(0x7fffffff)
// LOCK_ENABLE input of USB_PHY PLL.
// Normally only used during test. See cell specification.
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_SHIFT                        _MK_SHIFT_CONST(0)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_FIELD                        (_MK_MASK_CONST(0x1) << USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_SHIFT)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_RANGE                        0:0
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_WOFFSET                      0x0
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// LOCKSEL[5:0] input of USB_PHY PLL.
// Used in test modes only. See cell specification.
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_SHIFT                   _MK_SHIFT_CONST(1)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_FIELD                   (_MK_MASK_CONST(0x3f) << USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_SHIFT)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_RANGE                   6:1
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_WOFFSET                 0x0
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_DEFAULT_MASK                    _MK_MASK_CONST(0x3f)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_LOCKSEL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// VCOMULTBY2 control of the UTMIP PHY PLL.
// Recommended setting is on. Additional divide by 2 on the 
// VCO feedback. Which is setting the bit to 1. See cell spec.
//
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_SHIFT                        _MK_SHIFT_CONST(7)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_FIELD                        (_MK_MASK_CONST(0x1) << USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_SHIFT)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_RANGE                        7:7
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_WOFFSET                      0x0
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_DEFAULT                      _MK_MASK_CONST(0x1)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_VCOMULTBY2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// MDIV[7:0] input of the USB_PHY PLL. This is the predivide on the PLL. 
// 0x0 is not allowed. See cell specification.
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_SHIFT                      _MK_SHIFT_CONST(8)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_FIELD                      (_MK_MASK_CONST(0xff) << USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_SHIFT)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_RANGE                      15:8
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_WOFFSET                    0x0
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_DEFAULT                    _MK_MASK_CONST(0x1)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_MDIV_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// NDIV[7:0] input of USB_PHY PLL. 
// This is the feedback divider on the VCO feedback. 
// 0x0 is not allowed. See cell specification.
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_SHIFT                      _MK_SHIFT_CONST(16)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_FIELD                      (_MK_MASK_CONST(0xff) << USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_SHIFT)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_RANGE                      23:16
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_WOFFSET                    0x0
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_DEFAULT                    _MK_MASK_CONST(0x28)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_NDIV_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// PDIV[2:0] input of the USB_PHY PLL.
// Reserved. Keep at 0x0. Currently there is no post divider on this PLL. 
// See cell specification.
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_SHIFT                      _MK_SHIFT_CONST(24)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_FIELD                      (_MK_MASK_CONST(0x7) << USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_SHIFT)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_RANGE                      26:24
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_WOFFSET                    0x0
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIV_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// PDIVRST of the UTMIP PHY PLL.
// Reserved. Keep at 0x0. Currently there is no post divider on this PLL. 
// See cell specification.
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_SHIFT                   _MK_SHIFT_CONST(27)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_FIELD                   (_MK_MASK_CONST(0x1) << USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_SHIFT)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_RANGE                   27:27
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_WOFFSET                 0x0
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_PDIVRST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Selects which of the eight 60MHz clock phases to produce at the output 
// of the USB PHY PLL. This is for a test mode. See cell specification.
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_SHIFT                    _MK_SHIFT_CONST(28)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_FIELD                    (_MK_MASK_CONST(0x7) << USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_SHIFT)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_RANGE                    30:28
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_WOFFSET                  0x0
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG0_0_UTMIP_PLL_SELECT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register USB1_UTMIP_PLL_CFG1_0  // UTMIP PLL and PLLU configuration register 1
#define USB1_UTMIP_PLL_CFG1_0                   _MK_ADDR_CONST(0x804)
#define USB1_UTMIP_PLL_CFG1_0_SECURE                    0x0
#define USB1_UTMIP_PLL_CFG1_0_WORD_COUNT                        0x1
#define USB1_UTMIP_PLL_CFG1_0_RESET_VAL                         _MK_MASK_CONST(0x182000c0)
#define USB1_UTMIP_PLL_CFG1_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define USB1_UTMIP_PLL_CFG1_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define USB1_UTMIP_PLL_CFG1_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// Determines the time to wait until the output of USB_PHY PLL is considered stable. 
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_SHIFT                       _MK_SHIFT_CONST(0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_FIELD                       (_MK_MASK_CONST(0xfff) << USB1_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_SHIFT)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_RANGE                       11:0
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_WOFFSET                     0x0
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_DEFAULT                     _MK_MASK_CONST(0xc0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_DEFAULT_MASK                        _MK_MASK_CONST(0xfff)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_XTAL_FREQ_COUNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Force USB_PHY PLL pll_active input off. (Overrides FORCE_PLL_ACTIVE_POWERUP.)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_SHIFT                    _MK_SHIFT_CONST(12)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_FIELD                    (_MK_MASK_CONST(0x1) << USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_SHIFT)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_RANGE                    12:12
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_WOFFSET                  0x0
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERDOWN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Force USB_PHY PLL pll_active input on. 
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_SHIFT                      _MK_SHIFT_CONST(13)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_FIELD                      (_MK_MASK_CONST(0x1) << USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_SHIFT)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_RANGE                      13:13
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_WOFFSET                    0x0
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ACTIVE_POWERUP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Force USB_PHY PLL pll_enable input off. (Overrides FORCE_PLL_ENABLE_POWERUP.)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_SHIFT                    _MK_SHIFT_CONST(14)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_FIELD                    (_MK_MASK_CONST(0x1) << USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_SHIFT)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_RANGE                    14:14
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_WOFFSET                  0x0
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERDOWN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Force USB_PHY PLL pll_enable input on. 
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_SHIFT                      _MK_SHIFT_CONST(15)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_FIELD                      (_MK_MASK_CONST(0x1) << USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_SHIFT)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_RANGE                      15:15
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_WOFFSET                    0x0
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLL_ENABLE_POWERUP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Force PLL_U into power down. (Overrides FORCE_PLLU_POWERUP.)  
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_SHIFT                  _MK_SHIFT_CONST(16)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_FIELD                  (_MK_MASK_CONST(0x1) << USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_SHIFT)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_RANGE                  16:16
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_WOFFSET                        0x0
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERDOWN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Force PLL_U into power up.
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_SHIFT                    _MK_SHIFT_CONST(17)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_FIELD                    (_MK_MASK_CONST(0x1) << USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_SHIFT)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_RANGE                    17:17
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_WOFFSET                  0x0
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_FORCE_PLLU_POWERUP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// SETUP[8:0] input of USB_PHY PLL.
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_SHIFT                     _MK_SHIFT_CONST(18)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_FIELD                     (_MK_MASK_CONST(0x1ff) << USB1_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_SHIFT)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_RANGE                     26:18
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_WOFFSET                   0x0
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_DEFAULT                   _MK_MASK_CONST(0x8)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_DEFAULT_MASK                      _MK_MASK_CONST(0x1ff)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_PLL_SETUP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Controls the wait time to enable PLL_U when coming out of suspend or reset.
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_SHIFT                 _MK_SHIFT_CONST(27)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_FIELD                 (_MK_MASK_CONST(0x1f) << USB1_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_SHIFT)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_RANGE                 31:27
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_WOFFSET                       0x0
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_DEFAULT                       _MK_MASK_CONST(0x3)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_PLL_CFG1_0_UTMIP_PLLU_ENABLE_DLY_COUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register USB1_UTMIP_XCVR_CFG0_0  // UTMIP transceiver cell configuration register 0
#define USB1_UTMIP_XCVR_CFG0_0                  _MK_ADDR_CONST(0x808)
#define USB1_UTMIP_XCVR_CFG0_0_SECURE                   0x0
#define USB1_UTMIP_XCVR_CFG0_0_WORD_COUNT                       0x1
#define USB1_UTMIP_XCVR_CFG0_0_RESET_VAL                        _MK_MASK_CONST(0x20202500)
#define USB1_UTMIP_XCVR_CFG0_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define USB1_UTMIP_XCVR_CFG0_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define USB1_UTMIP_XCVR_CFG0_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// SETUP[3:0] input of XCVR cell. HS driver output control. 4 LSBs.
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_SHIFT                   _MK_SHIFT_CONST(0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_FIELD                   (_MK_MASK_CONST(0xf) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_RANGE                   3:0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_WOFFSET                 0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// HS slew rate control. The two LSBs.
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_SHIFT                  _MK_SHIFT_CONST(4)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_FIELD                  (_MK_MASK_CONST(0x3) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_RANGE                  5:4
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_WOFFSET                        0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// FS slew rate control.
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_SHIFT                  _MK_SHIFT_CONST(6)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_FIELD                  (_MK_MASK_CONST(0x3) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_RANGE                  7:6
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_WOFFSET                        0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_FSSLEW_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// LS rising slew rate control.
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_SHIFT                 _MK_SHIFT_CONST(8)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_FIELD                 (_MK_MASK_CONST(0x3) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_RANGE                 9:8
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_WOFFSET                       0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_DEFAULT                       _MK_MASK_CONST(0x1)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSRSLEW_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// LS falling slew rate control.
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_SHIFT                 _MK_SHIFT_CONST(10)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_FIELD                 (_MK_MASK_CONST(0x3) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_RANGE                 11:10
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_WOFFSET                       0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_DEFAULT                       _MK_MASK_CONST(0x1)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSFSLEW_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Internal loopback inside XCVR cell. Used for IOBIST.
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_SHIFT                      _MK_SHIFT_CONST(12)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_FIELD                      (_MK_MASK_CONST(0x1) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_RANGE                      12:12
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_WOFFSET                    0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSLOOPBACK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Enable HS termination.
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_SHIFT                  _MK_SHIFT_CONST(13)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_FIELD                  (_MK_MASK_CONST(0x1) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_RANGE                  13:13
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_WOFFSET                        0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_DEFAULT                        _MK_MASK_CONST(0x1)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_TERMEN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Force PD input into power down. (Overrides FORCE_PD_POWERUP.)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_SHIFT                   _MK_SHIFT_CONST(14)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_FIELD                   (_MK_MASK_CONST(0x1) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_RANGE                   14:14
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_WOFFSET                 0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERDOWN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Force PD input into power up. 
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_SHIFT                     _MK_SHIFT_CONST(15)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_FIELD                     (_MK_MASK_CONST(0x1) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_RANGE                     15:15
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_WOFFSET                   0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD_POWERUP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Force PD2 input into power down. (Overrides FORCE_PD2_POWERUP.)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_SHIFT                  _MK_SHIFT_CONST(16)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_FIELD                  (_MK_MASK_CONST(0x1) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_RANGE                  16:16
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_WOFFSET                        0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERDOWN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Force PD2 input into power up.
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_SHIFT                    _MK_SHIFT_CONST(17)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_FIELD                    (_MK_MASK_CONST(0x1) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_RANGE                    17:17
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_WOFFSET                  0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PD2_POWERUP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Force PDZI input into power down. (Overrides FORCE_PDZI_POWERUP.)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_SHIFT                 _MK_SHIFT_CONST(18)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_FIELD                 (_MK_MASK_CONST(0x1) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_RANGE                 18:18
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_WOFFSET                       0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERDOWN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Force PDZI input into power up.
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_SHIFT                   _MK_SHIFT_CONST(19)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_FIELD                   (_MK_MASK_CONST(0x1) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_RANGE                   19:19
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_WOFFSET                 0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_FORCE_PDZI_POWERUP_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Disconnect method on the usb transceiver pad
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_DISCON_METHOD_SHIFT                   _MK_SHIFT_CONST(20)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_DISCON_METHOD_FIELD                   (_MK_MASK_CONST(0x1) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_DISCON_METHOD_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_DISCON_METHOD_RANGE                   20:20
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_DISCON_METHOD_WOFFSET                 0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_DISCON_METHOD_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_DISCON_METHOD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_DISCON_METHOD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_DISCON_METHOD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Low speed bias selection method for usb transceiver pad
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSBIAS_SEL_SHIFT                      _MK_SHIFT_CONST(21)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSBIAS_SEL_FIELD                      (_MK_MASK_CONST(0x1) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSBIAS_SEL_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSBIAS_SEL_RANGE                      21:21
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSBIAS_SEL_WOFFSET                    0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSBIAS_SEL_DEFAULT                    _MK_MASK_CONST(0x1)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSBIAS_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSBIAS_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_LSBIAS_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Most significant bits of SETUP.
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_MSB_SHIFT                       _MK_SHIFT_CONST(22)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_MSB_FIELD                       (_MK_MASK_CONST(0x7) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_MSB_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_MSB_RANGE                       24:22
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_MSB_WOFFSET                     0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_MSB_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_MSB_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_MSB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_SETUP_MSB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Most significant bits of HS_SLEW.
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_MSB_SHIFT                      _MK_SHIFT_CONST(25)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_MSB_FIELD                      (_MK_MASK_CONST(0x7f) << USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_MSB_SHIFT)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_MSB_RANGE                      31:25
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_MSB_WOFFSET                    0x0
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_MSB_DEFAULT                    _MK_MASK_CONST(0x10)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_MSB_DEFAULT_MASK                       _MK_MASK_CONST(0x7f)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_MSB_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_XCVR_CFG0_0_UTMIP_XCVR_HSSLEW_MSB_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register USB1_UTMIP_BIAS_CFG0_0  // UTMIP Bias cell configuration register 0
#define USB1_UTMIP_BIAS_CFG0_0                  _MK_ADDR_CONST(0x80c)
#define USB1_UTMIP_BIAS_CFG0_0_SECURE                   0x0
#define USB1_UTMIP_BIAS_CFG0_0_WORD_COUNT                       0x1
#define USB1_UTMIP_BIAS_CFG0_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_RESET_MASK                       _MK_MASK_CONST(0x1ffffff)
#define USB1_UTMIP_BIAS_CFG0_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_READ_MASK                        _MK_MASK_CONST(0x1ffffff)
#define USB1_UTMIP_BIAS_CFG0_0_WRITE_MASK                       _MK_MASK_CONST(0x1ffffff)
// HS squelch detector level.
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_SHIFT                      _MK_SHIFT_CONST(0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_FIELD                      (_MK_MASK_CONST(0x3) << USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_SHIFT)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_RANGE                      1:0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_WOFFSET                    0x0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSSQUELCH_LEVEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// HS disconnect detector level.
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_SHIFT                       _MK_SHIFT_CONST(2)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_FIELD                       (_MK_MASK_CONST(0x3) << USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_SHIFT)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_RANGE                       3:2
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_WOFFSET                     0x0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// HS chirp detector level.
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_SHIFT                        _MK_SHIFT_CONST(4)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_FIELD                        (_MK_MASK_CONST(0x3) << USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_SHIFT)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_RANGE                        5:4
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_WOFFSET                      0x0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSCHIRP_LEVEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// SessionEnd detector level.
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_SHIFT                     _MK_SHIFT_CONST(6)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_FIELD                     (_MK_MASK_CONST(0x3) << USB1_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_SHIFT)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_RANGE                     7:6
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_WOFFSET                   0x0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_SESS_LEVEL_LEVEL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Vbus detector level.
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_SHIFT                     _MK_SHIFT_CONST(8)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_FIELD                     (_MK_MASK_CONST(0x3) << USB1_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_SHIFT)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_RANGE                     9:8
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_WOFFSET                   0x0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_VBUS_LEVEL_LEVEL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Power down bias circuit.
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_SHIFT                       _MK_SHIFT_CONST(10)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_FIELD                       (_MK_MASK_CONST(0x1) << USB1_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_SHIFT)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_RANGE                       10:10
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_WOFFSET                     0x0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_BIASPD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Power down OTG circuit.
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_SHIFT                        _MK_SHIFT_CONST(11)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_FIELD                        (_MK_MASK_CONST(0x1) << USB1_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_SHIFT)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_RANGE                        11:11
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_WOFFSET                      0x0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_OTGPD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Active 1.5K pullup control offset.
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_SHIFT                 _MK_SHIFT_CONST(12)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_FIELD                 (_MK_MASK_CONST(0x7) << USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_SHIFT)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_RANGE                 14:12
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_WOFFSET                       0x0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_PULLUP_OFFSET_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Active termination control offset.
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_SHIFT                   _MK_SHIFT_CONST(15)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_FIELD                   (_MK_MASK_CONST(0x7) << USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_SHIFT)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_RANGE                   17:15
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_WOFFSET                 0x0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_ACTIVE_TERM_OFFSET_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// 0: StaticGpi = IdDig. 1: StaticGpi = GPI_VAL.
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_SHIFT                      _MK_SHIFT_CONST(18)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_FIELD                      (_MK_MASK_CONST(0x1) << USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_SHIFT)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_RANGE                      18:18
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_WOFFSET                    0x0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// See GPI_SEL.
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_SHIFT                      _MK_SHIFT_CONST(19)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_FIELD                      (_MK_MASK_CONST(0x1) << USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_SHIFT)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_RANGE                      19:19
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_WOFFSET                    0x0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_GPI_VAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// 0: IdDig = IdDig. 1: IdDig = IDDIG_VAL.
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_SHIFT                    _MK_SHIFT_CONST(20)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_FIELD                    (_MK_MASK_CONST(0x1) << USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_SHIFT)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_RANGE                    20:20
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_WOFFSET                  0x0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_SEL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// See IDDIG_SEL.
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_SHIFT                    _MK_SHIFT_CONST(21)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_FIELD                    (_MK_MASK_CONST(0x1) << USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_SHIFT)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_RANGE                    21:21
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_WOFFSET                  0x0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDDIG_VAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// 0: IDPD = ~IdPullup. 1: IDPD = IDPD_VAL.
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_SHIFT                     _MK_SHIFT_CONST(22)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_FIELD                     (_MK_MASK_CONST(0x1) << USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_SHIFT)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_RANGE                     22:22
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_WOFFSET                   0x0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_SEL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// See IDPD_SEL.
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_SHIFT                     _MK_SHIFT_CONST(23)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_FIELD                     (_MK_MASK_CONST(0x1) << USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_SHIFT)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_RANGE                     23:23
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_WOFFSET                   0x0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_IDPD_VAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Most significant bit of UTMIP_HSDISCON_LEVEL, bit 2
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_MSB_SHIFT                   _MK_SHIFT_CONST(24)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_MSB_FIELD                   (_MK_MASK_CONST(0x1) << USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_MSB_SHIFT)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_MSB_RANGE                   24:24
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_MSB_WOFFSET                 0x0
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_MSB_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_MSB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_MSB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_UTMIP_BIAS_CFG0_0_UTMIP_HSDISCON_LEVEL_MSB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register USB1_UTMIP_HSRX_CFG0_0  // UTMIP High speed receive config 0 
#define USB1_UTMIP_HSRX_CFG0_0                  _MK_ADDR_CONST(0x810)
#define USB1_UTMIP_HSRX_CFG0_0_SECURE                   0x0
#define USB1_UTMIP_HSRX_CFG0_0_WORD_COUNT                       0x1
#define USB1_UTMIP_HSRX_CFG0_0_RESET_VAL                        _MK_MASK_CONST(0x91653400)
#define USB1_UTMIP_HSRX_CFG0_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define USB1_UTMIP_HSRX_CFG0_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define USB1_UTMIP_HSRX_CFG0_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// Require 4 sync pattern transitions (01) instead of 3
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_SHIFT                        _MK_SHIFT_CONST(0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_FIELD                        (_MK_MASK_CONST(0x1) << USB1_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_SHIFT)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_RANGE                        0:0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_WOFFSET                      0x0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_USE4SYNC_TRAN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Sync pattern detection needs 3 consecutive samples instead of 4
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_SHIFT                       _MK_SHIFT_CONST(1)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_FIELD                       (_MK_MASK_CONST(0x1) << USB1_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_SHIFT)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_RANGE                       1:1
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_WOFFSET                     0x0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_THREE_SYNCBITS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Based on incoming edges and current sampling position, adjust phase
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_SHIFT                 _MK_SHIFT_CONST(2)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_FIELD                 (_MK_MASK_CONST(0x3) << USB1_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_SHIFT)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_RANGE                 3:2
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_WOFFSET                       0x0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PHASE_ADJUST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Retime the path. 
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_SHIFT                       _MK_SHIFT_CONST(4)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_FIELD                       (_MK_MASK_CONST(0x3) << USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_SHIFT)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_RANGE                       5:4
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_WOFFSET                     0x0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_INERTIA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Pass through the feedback, do not block it.
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_SHIFT                        _MK_SHIFT_CONST(6)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_FIELD                        (_MK_MASK_CONST(0x1) << USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_SHIFT)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_RANGE                        6:6
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_WOFFSET                      0x0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_FEEDBACK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// When in Chirp Mode, allow chirp rx data through
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_SHIFT                   _MK_SHIFT_CONST(7)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_FIELD                   (_MK_MASK_CONST(0x1) << USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_SHIFT)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_RANGE                   7:7
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_WOFFSET                 0x0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PASS_CHIRP_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Do not declare underrun errors
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_SHIFT                     _MK_SHIFT_CONST(8)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_FIELD                     (_MK_MASK_CONST(0x1) << USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_SHIFT)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_RANGE                     8:8
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_WOFFSET                   0x0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_UNDERRUN_DISABLE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Do not declare overrun errors until overflow of FIFO
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_SHIFT                      _MK_SHIFT_CONST(9)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_FIELD                      (_MK_MASK_CONST(0x1) << USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_SHIFT)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_RANGE                      9:9
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_WOFFSET                    0x0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_OVERRUN_DISABLE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Depth of elastic input store
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_LIMIT_SHIFT                        _MK_SHIFT_CONST(10)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_LIMIT_FIELD                        (_MK_MASK_CONST(0x1f) << USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_LIMIT_SHIFT)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_LIMIT_RANGE                        14:10
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_LIMIT_WOFFSET                      0x0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_LIMIT_DEFAULT                      _MK_MASK_CONST(0xd)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_LIMIT_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_LIMIT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ELASTIC_LIMIT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Number of cycles of idle to declare IDLE. 
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_IDLE_WAIT_SHIFT                    _MK_SHIFT_CONST(15)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_IDLE_WAIT_FIELD                    (_MK_MASK_CONST(0x1f) << USB1_UTMIP_HSRX_CFG0_0_UTMIP_IDLE_WAIT_SHIFT)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_IDLE_WAIT_RANGE                    19:15
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_IDLE_WAIT_WOFFSET                  0x0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_IDLE_WAIT_DEFAULT                  _MK_MASK_CONST(0xa)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_IDLE_WAIT_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_IDLE_WAIT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_IDLE_WAIT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Do not strip incoming data
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_NO_STRIPPING_SHIFT                 _MK_SHIFT_CONST(20)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_NO_STRIPPING_FIELD                 (_MK_MASK_CONST(0x1) << USB1_UTMIP_HSRX_CFG0_0_UTMIP_NO_STRIPPING_SHIFT)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_NO_STRIPPING_RANGE                 20:20
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_NO_STRIPPING_WOFFSET                       0x0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_NO_STRIPPING_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_NO_STRIPPING_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_NO_STRIPPING_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_NO_STRIPPING_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Limit the delay of the squelch at EOP time
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_SQUELCH_EOP_DLY_SHIFT                      _MK_SHIFT_CONST(21)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_SQUELCH_EOP_DLY_FIELD                      (_MK_MASK_CONST(0x7) << USB1_UTMIP_HSRX_CFG0_0_UTMIP_SQUELCH_EOP_DLY_SHIFT)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_SQUELCH_EOP_DLY_RANGE                      23:21
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_SQUELCH_EOP_DLY_WOFFSET                    0x0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_SQUELCH_EOP_DLY_DEFAULT                    _MK_MASK_CONST(0x3)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_SQUELCH_EOP_DLY_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_SQUELCH_EOP_DLY_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_SQUELCH_EOP_DLY_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// The number of (edges-1) needed to move the sampling point
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_UPDN_DIV_SHIFT                      _MK_SHIFT_CONST(24)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_UPDN_DIV_FIELD                      (_MK_MASK_CONST(0xf) << USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_UPDN_DIV_SHIFT)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_UPDN_DIV_RANGE                      27:24
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_UPDN_DIV_WOFFSET                    0x0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_UPDN_DIV_DEFAULT                    _MK_MASK_CONST(0x1)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_UPDN_DIV_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_UPDN_DIV_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_PCOUNT_UPDN_DIV_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Realign the inertia counters on a new packet
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_REALIGN_ON_NEW_PKT_SHIFT                   _MK_SHIFT_CONST(28)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_REALIGN_ON_NEW_PKT_FIELD                   (_MK_MASK_CONST(0x1) << USB1_UTMIP_HSRX_CFG0_0_UTMIP_REALIGN_ON_NEW_PKT_SHIFT)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_REALIGN_ON_NEW_PKT_RANGE                   28:28
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_REALIGN_ON_NEW_PKT_WOFFSET                 0x0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_REALIGN_ON_NEW_PKT_DEFAULT                 _MK_MASK_CONST(0x1)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_REALIGN_ON_NEW_PKT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_REALIGN_ON_NEW_PKT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_REALIGN_ON_NEW_PKT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Allow consecutive ups and downs on the bits, debug only, set to 0.
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ALLOW_CONSEC_UPDN_SHIFT                    _MK_SHIFT_CONST(29)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ALLOW_CONSEC_UPDN_FIELD                    (_MK_MASK_CONST(0x1) << USB1_UTMIP_HSRX_CFG0_0_UTMIP_ALLOW_CONSEC_UPDN_SHIFT)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ALLOW_CONSEC_UPDN_RANGE                    29:29
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ALLOW_CONSEC_UPDN_WOFFSET                  0x0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ALLOW_CONSEC_UPDN_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ALLOW_CONSEC_UPDN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ALLOW_CONSEC_UPDN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_ALLOW_CONSEC_UPDN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Keep the stay alive pattern on active
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_KEEP_PATT_ON_ACTIVE_SHIFT                  _MK_SHIFT_CONST(30)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_KEEP_PATT_ON_ACTIVE_FIELD                  (_MK_MASK_CONST(0x3) << USB1_UTMIP_HSRX_CFG0_0_UTMIP_KEEP_PATT_ON_ACTIVE_SHIFT)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_KEEP_PATT_ON_ACTIVE_RANGE                  31:30
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_KEEP_PATT_ON_ACTIVE_WOFFSET                        0x0
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_KEEP_PATT_ON_ACTIVE_DEFAULT                        _MK_MASK_CONST(0x2)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_KEEP_PATT_ON_ACTIVE_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_KEEP_PATT_ON_ACTIVE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG0_0_UTMIP_KEEP_PATT_ON_ACTIVE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register USB1_UTMIP_HSRX_CFG1_0  // UTMIP High speed receive config 1
#define USB1_UTMIP_HSRX_CFG1_0                  _MK_ADDR_CONST(0x814)
#define USB1_UTMIP_HSRX_CFG1_0_SECURE                   0x0
#define USB1_UTMIP_HSRX_CFG1_0_WORD_COUNT                       0x1
#define USB1_UTMIP_HSRX_CFG1_0_RESET_VAL                        _MK_MASK_CONST(0x13)
#define USB1_UTMIP_HSRX_CFG1_0_RESET_MASK                       _MK_MASK_CONST(0x3f)
#define USB1_UTMIP_HSRX_CFG1_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG1_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG1_0_READ_MASK                        _MK_MASK_CONST(0x3f)
#define USB1_UTMIP_HSRX_CFG1_0_WRITE_MASK                       _MK_MASK_CONST(0x3f)
// Allow Keep Alive packets 
#define USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_ALLOW_KEEP_ALIVE_SHIFT                  _MK_SHIFT_CONST(0)
#define USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_ALLOW_KEEP_ALIVE_FIELD                  (_MK_MASK_CONST(0x1) << USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_ALLOW_KEEP_ALIVE_SHIFT)
#define USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_ALLOW_KEEP_ALIVE_RANGE                  0:0
#define USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_ALLOW_KEEP_ALIVE_WOFFSET                        0x0
#define USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_ALLOW_KEEP_ALIVE_DEFAULT                        _MK_MASK_CONST(0x1)
#define USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_ALLOW_KEEP_ALIVE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_ALLOW_KEEP_ALIVE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_ALLOW_KEEP_ALIVE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// How long to wait before start of sync launches RxActive
#define USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_SYNC_START_DLY_SHIFT                    _MK_SHIFT_CONST(1)
#define USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_SYNC_START_DLY_FIELD                    (_MK_MASK_CONST(0x1f) << USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_SYNC_START_DLY_SHIFT)
#define USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_SYNC_START_DLY_RANGE                    5:1
#define USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_SYNC_START_DLY_WOFFSET                  0x0
#define USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_SYNC_START_DLY_DEFAULT                  _MK_MASK_CONST(0x9)
#define USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_SYNC_START_DLY_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_SYNC_START_DLY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_UTMIP_HSRX_CFG1_0_UTMIP_HS_SYNC_START_DLY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register USB1_UTMIP_FSLSRX_CFG0_0  // UTMIP full and Low speed receive config 0
#define USB1_UTMIP_FSLSRX_CFG0_0                        _MK_ADDR_CONST(0x818)
#define USB1_UTMIP_FSLSRX_CFG0_0_SECURE                         0x0
#define USB1_UTMIP_FSLSRX_CFG0_0_WORD_COUNT                     0x1
#define USB1_UTMIP_FSLSRX_CFG0_0_RESET_VAL                      _MK_MASK_CONST(0xfd548429)
#define USB1_UTMIP_FSLSRX_CFG0_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define USB1_UTMIP_FSLSRX_CFG0_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define USB1_UTMIP_FSLSRX_CFG0_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define USB1_UTMIP_FSLSRX_CFG0_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define USB1_UTMIP_FSLSRX_CFG0_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
// Give up on packet if a long sequence of J 
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_LIMIT_SHIFT                      _MK_SHIFT_CONST(0)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_LIMIT_FIELD                      (_MK_MASK_CONST(0x1) << USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_LIMIT_SHIFT)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_LIMIT_RANGE                      0:0
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_LIMIT_WOFFSET                    0x0
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_LIMIT_DEFAULT                    _MK_MASK_CONST(0x1)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_LIMIT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_LIMIT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_LIMIT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// 20 bits of idle should end the packet if FsLsIdleCountLimitCfg=1.
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_MAX_SHIFT                        _MK_SHIFT_CONST(1)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_MAX_FIELD                        (_MK_MASK_CONST(0x3f) << USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_MAX_SHIFT)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_MAX_RANGE                        6:1
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_MAX_WOFFSET                      0x0
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_MAX_DEFAULT                      _MK_MASK_CONST(0x14)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_MAX_DEFAULT_MASK                 _MK_MASK_CONST(0x3f)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_MAX_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_COUNT_MAX_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Enable the reset of the state machine on extended SE0
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_LIMIT_SHIFT                       _MK_SHIFT_CONST(7)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_LIMIT_FIELD                       (_MK_MASK_CONST(0x1) << USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_LIMIT_SHIFT)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_LIMIT_RANGE                       7:7
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_LIMIT_WOFFSET                     0x0
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_LIMIT_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_LIMIT_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_LIMIT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_LIMIT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 4 bits of of SEO should exceed the time limit
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_MAX_SHIFT                 _MK_SHIFT_CONST(8)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_MAX_FIELD                 (_MK_MASK_CONST(0x3f) << USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_MAX_SHIFT)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_MAX_RANGE                 13:8
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_MAX_WOFFSET                       0x0
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_MAX_DEFAULT                       _MK_MASK_CONST(0x4)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_MAX_DEFAULT_MASK                  _MK_MASK_CONST(0x3f)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_MAX_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_IDLE_WAIT_MAX_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Require a full sync pattern to declare the data received
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_ACTIVE_ON_FULL_SYNC_SHIFT                   _MK_SHIFT_CONST(14)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_ACTIVE_ON_FULL_SYNC_FIELD                   (_MK_MASK_CONST(0x1) << USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_ACTIVE_ON_FULL_SYNC_SHIFT)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_ACTIVE_ON_FULL_SYNC_RANGE                   14:14
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_ACTIVE_ON_FULL_SYNC_WOFFSET                 0x0
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_ACTIVE_ON_FULL_SYNC_DEFAULT                 _MK_MASK_CONST(0x0)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_ACTIVE_ON_FULL_SYNC_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_ACTIVE_ON_FULL_SYNC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_ACTIVE_ON_FULL_SYNC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Limit the number of bit times a K can last
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_LIMIT_SHIFT                  _MK_SHIFT_CONST(15)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_LIMIT_FIELD                  (_MK_MASK_CONST(0x1) << USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_LIMIT_SHIFT)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_LIMIT_RANGE                  15:15
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_LIMIT_WOFFSET                        0x0
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_LIMIT_DEFAULT                        _MK_MASK_CONST(0x1)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_LIMIT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_LIMIT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_LIMIT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Number of K bits in question
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_MAX_SHIFT                    _MK_SHIFT_CONST(16)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_MAX_FIELD                    (_MK_MASK_CONST(0x3f) << USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_MAX_SHIFT)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_MAX_RANGE                    21:16
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_MAX_WOFFSET                  0x0
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_MAX_DEFAULT                  _MK_MASK_CONST(0x14)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_MAX_DEFAULT_MASK                     _MK_MASK_CONST(0x3f)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_MAX_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_KCOUNT_MAX_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Only look for transitioning out of EOP
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_EOP_ENDS_AT_SE0_SHIFT                       _MK_SHIFT_CONST(22)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_EOP_ENDS_AT_SE0_FIELD                       (_MK_MASK_CONST(0x1) << USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_EOP_ENDS_AT_SE0_SHIFT)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_EOP_ENDS_AT_SE0_RANGE                       22:22
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_EOP_ENDS_AT_SE0_WOFFSET                     0x0
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_EOP_ENDS_AT_SE0_DEFAULT                     _MK_MASK_CONST(0x1)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_EOP_ENDS_AT_SE0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_EOP_ENDS_AT_SE0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_EOP_ENDS_AT_SE0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Do not allow >= dribble bits 
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_LWR_DRIBBLE_SIZE_SHIFT                      _MK_SHIFT_CONST(23)
#define USB1_UTMIP_FSLSRX_CFG0_0_UTMIP_FSLS_LWR_DRIBBLE_SIZE_FIELD                      (_MK_MASK_CONST(0x7