/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifndef ___DEV_AP_PCIE2_PADS_H_INC_
#define ___DEV_AP_PCIE2_PADS_H_INC_

#define NV_PROJ__PCIE2_PADS                            0x000000BC:0x00000098 /* RW--D */
#define NV_PROJ__PCIE2_PADS_CTL_SEL_0                         0x00000098 /* RW-4R */
#define NV_PROJ__PCIE2_PADS_CTL_SEL_0_LANE_SELECT                   31:0 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_SEL_0_LANE_SELECT_DEFAULT     0xFFFFFFFF /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_SEL_0_LANE_SELECT_NO_LANES    0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_SEL_0_LANE_SELECT_LANES_31_0  0xFFFFFFFF /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_SEL_0_LANE_SELECT_MASK        0x0000001C /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_SEL_1                         0x0000009C /* RW-4R */
#define NV_PROJ__PCIE2_PADS_CTL_SEL_1_LANE_SELECT                   31:0 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_SEL_1_LANE_SELECT_DEFAULT     0xFFFFFFFF /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_SEL_1_LANE_SELECT_NO_LANES    0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_SEL_1_LANE_SELECT_LANES_63_32 0xFFFFFFFF /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1                             0x000000A0 /* RW-4R */
#define NV_PROJ__PCIE2_PADS_CTL_1_IDDQ_1L                            0:0 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_IDDQ_1L_DEFAULT             0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_CKBUFPD_1P                         1:1 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_CKBUFPD_1P_DEFAULT          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_CKBUFPD_1P_PD               0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_CKBUFPD_1P_NOT_PD           0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_CKBUFPD_OVRD_1P                    3:3 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_CKBUFPD_OVRD_1P_DEFAULT     0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_CKBUFPD_OVRD_1P_ENABLE      0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_CKBUFPD_OVRD_1P_DISABLE     0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_SLEEP_1L                        5:4 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_SLEEP_1L_DEFAULT         0x00000003 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_SLEEP_1L_ACTIVE          0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_SLEEP_1L_PARTIAL         0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_SLEEP_1L_SLUMBER         0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_SLEEP_1L_DISABLED        0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_DATA_EN_1L                      6:6 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_DATA_EN_1L_DEFAULT       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_DATA_EN_1L_ENABLE        0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_DATA_EN_1L_DISABLE       0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_PWR_OVRD_1L                     7:7 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_PWR_OVRD_1L_DEFAULT      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_PWR_OVRD_1L_ENABLE       0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_PWR_OVRD_1L_DISABLE      0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_SLEEP_1L                        9:8 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_SLEEP_1L_DEFAULT         0x00000003 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_SLEEP_1L_ACTIVE          0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_SLEEP_1L_PARTIAL         0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_SLEEP_1L_SLUMBER         0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_SLEEP_1L_DISABLED        0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_DATA_EN_1L                    10:10 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_DATA_EN_1L_DEFAULT       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_DATA_EN_1L_ENABLE        0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_DATA_EN_1L_DISABLE       0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_PWR_OVRD_1L                   11:11 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_PWR_OVRD_1L_DEFAULT      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_PWR_OVRD_1L_ENABLE       0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_PWR_OVRD_1L_DISABLE      0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_RATE_1L                       13:12 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_RATE_1L_DEFAULT          0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_RATE_1L_PLL_05X          0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_RATE_1L_PLL_1X           0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_RATE_1L_PLL_2X           0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_RATE_1L                       15:14 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_RATE_1L_DEFAULT          0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_RATE_1L_PLL_05X          0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_RATE_1L_PLL_1X           0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_RATE_1L_PLL_2X           0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_STAT_IDLE_1L                  16:16 /* R--VF */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_STAT_IDLE_1L_IDLE        0x00000001 /* R---V */
#define NV_PROJ__PCIE2_PADS_CTL_1_RX_STAT_IDLE_1L_SIG_PRESENT 0x00000000 /* R---V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_STAT_PRESENT_1L               17:17 /* R--VF */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_STAT_PRESENT_1L_RX_PRSNT 0x00000001 /* R---V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_STAT_PRESENT_1L_RX_ABSNT 0x00000000 /* R---V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_RDET_GS                       19:19 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_RDET_GS_DEFAULT          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_RDET_GS_ENABLE           0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_RDET_GS_DISABLE          0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_NED_MODE_1P                      21:20 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_NED_MODE_1P_DEFAULT         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_NED_MODE_1P_RD2REGOUT       0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_NED_MODE_1P_WR2REGOUT       0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_NED_MODE_1P_RD2RXOUT        0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_NED_MODE_1P_WR2RXOUT        0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_NED_LOOP_GS                      22:22 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_NED_LOOP_GS_DEFAULT         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_NED_LOOP_GS_ENABLE          0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_NED_LOOP_GS_DISABLE         0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_NEA_LOOP_GS                      23:23 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_NEA_LOOP_GS_DEFAULT         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_NEA_LOOP_GS_ENABLE          0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_NEA_LOOP_GS_DISABLE         0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_FEA_MODE_1P                      26:24 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_FEA_MODE_1P_DEFAULT         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_FEA_MODE_1P_CDR_CLK         0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_FEA_MODE_1P_CDR_DATA        0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_FEA_MODE_1P_IDLE_DET        0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_FEA_MODE_1P_RX_AMP          0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_FEA_LOOP_GS                      27:27 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_FEA_LOOP_GS_DEFAULT         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_FEA_LOOP_GS_ENABLE          0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_FEA_LOOP_GS_DISABLE         0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_DATA_MODE_GS                     30:28 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_DATA_MODE_GS_DEFAULT        0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_DATA_MODE_GS_INVERITNG_17C  0x00000005 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_DATA_MODE_GS_STATIC_01F     0x00000004 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_DATA_MODE_GS_INVERITNG_333  0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_DATA_MODE_GS_STATIC_155     0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_DATA_MODE_GS_PRBS_27_1      0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_TX_DATA_MODE_GS_NORMAL         0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_FED_LOOP_GS                      31:31 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_1_FED_LOOP_GS_DEFAULT         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_1_FED_LOOP_GS_ENABLE          0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_1_FED_LOOP_GS_DISABLE         0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_2                             0x000000A4 /* RW-4R */
#define NV_PROJ__PCIE2_PADS_CTL_2_CDR_CNTL_1P                        7:0 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_2_CDR_CNTL_1P_DEFAULT         0x00000010 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_2_MISC_CNTL_1P                      11:8 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_2_MISC_CNTL_1P_DEFAULT        0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_2_TX_RDET_T_1P                     13:12 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_2_TX_RDET_T_1P_DEFAULT        0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_2_RX_IDLE_T_1P                     15:14 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_2_RX_IDLE_T_1P_DEFAULT        0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_2_RX_IDLE_T_1P_70_MVPPD       0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_2_RX_IDLE_T_1P_120_MVPPD      0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_2_RX_IDLE_T_1P_100_MVPPD      0x00000000 /* RW--V */
#define  NV_PROJ__PCIE2_PADS_CTL_2_TX_DIV_1L                       17:16 /* RWIVF */
#define  NV_PROJ__PCIE2_PADS_CTL_2_TX_DIV_1L_DEFAULT          0x00000000 /* RWI-V */
#define  NV_PROJ__PCIE2_PADS_CTL_2_TX_DIV_1L_NORMAL           0x00000000 /* RW--V */
#define  NV_PROJ__PCIE2_PADS_CTL_2_RX_DIV_1L                       19:18 /* RWIVF */
#define  NV_PROJ__PCIE2_PADS_CTL_2_RX_DIV_1L_DEFAULT          0x00000000 /* RWI-V */
#define  NV_PROJ__PCIE2_PADS_CTL_2_RX_DIV_1L_NORMAL           0x00000000 /* RW--V */
#define  NV_PROJ__PCIE2_PADS_CTL_2_TX_BYP_OUT_1L                   20:20 /* RWIVF */
#define  NV_PROJ__PCIE2_PADS_CTL_2_TX_BYP_OUT_1L_DEFAULT      0x00000000 /* RWI-V */
#define  NV_PROJ__PCIE2_PADS_CTL_2_TX_BYP_IN_1L                    21:21 /* R--VF */
#define  NV_PROJ__PCIE2_PADS_CTL_2_TX_BYP_DIR_1L                   22:22 /* RWIVF */
#define  NV_PROJ__PCIE2_PADS_CTL_2_TX_BYP_DIR_1L_DEFAULT      0x00000000 /* RWI-V */
#define  NV_PROJ__PCIE2_PADS_CTL_2_TX_BYP_EN_1L                    23:23 /* RWIVF */
#define  NV_PROJ__PCIE2_PADS_CTL_2_TX_BYP_EN_1L_DEFAULT       0x00000000 /* RWI-V */
#define  NV_PROJ__PCIE2_PADS_CTL_2_RX_BYP_OUT_1L                   24:24 /* RWIVF */
#define  NV_PROJ__PCIE2_PADS_CTL_2_RX_BYP_OUT_1L_DEFAULT      0x00000000 /* RWI-V */
#define  NV_PROJ__PCIE2_PADS_CTL_2_RX_BYP_IN_1L                    25:25 /* R--VF */
#define  NV_PROJ__PCIE2_PADS_CTL_2_RX_BYP_DIR_1L                   26:26 /* RWIVF */
#define  NV_PROJ__PCIE2_PADS_CTL_2_RX_BYP_DIR_1L_DEFAULT      0x00000000 /* RWI-V */
#define  NV_PROJ__PCIE2_PADS_CTL_2_RX_BYP_EN_1L                    27:27 /* RWIVF */
#define  NV_PROJ__PCIE2_PADS_CTL_2_RX_BYP_EN_1L_DEFAULT       0x00000000 /* RWI-V */
#define  NV_PROJ__PCIE2_PADS_CTL_2_RX_BYP_MODE_1L                  28:28 /* RWIVF */
#define  NV_PROJ__PCIE2_PADS_CTL_2_RX_BYP_MODE_1L_DEFAULT     0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_4                             0x000000A8 /* RW-4R */
#define NV_PROJ__PCIE2_PADS_CTL_4_RX_IDLE_BYP_GS                     0:0 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_4_RX_IDLE_BYP_GS_DEFAULT      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_4_RX_IDLE_BYP_GS_BYPASS       0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_4_RX_IDLE_BYP_GS_NORMAL       0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_4_TX_RDET_BYP_GS                     1:1 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_4_TX_RDET_BYP_GS_DEFAULT      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_4_TX_RDET_BYP_GS_BYPASS       0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_4_TX_RDET_BYP_GS_NORMAL       0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_4_TX_SEL_LOAD_1P                     6:4 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_4_TX_SEL_LOAD_1P_DEFAULT      0x00000002 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_4_TX_SEL_LOAD_1P_MIN          0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_4_TX_SEL_LOAD_1P_CENTERED     0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_4_TX_SEL_LOAD_1P_MAX          0x00000004 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_4_TX_SYNC_GS                         7:7 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_4_TX_SYNC_GS_DEFAULT          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_4_TX_SYNC_GS_ENABLE           0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_4_TX_SYNC_GS_DISABLE          0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_4_RX_CDR_RESET_GS                    8:8 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_4_RX_CDR_RESET_GS_DEFAULT     0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_4_RX_CDR_RESET_GS_ENABLE      0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_4_RX_CDR_RESET_GS_DISABLE     0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_4_PRBS_CHK_EN_GS                   12:12 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_4_PRBS_CHK_EN_GS_DEFAULT      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_4_PRBS_CHK_EN_GS_ENABLE       0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_4_PRBS_CHK_EN_GS_DISABLE      0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_4_PRBS_ERROR_1L                    13:13 /* R--VF */
#define NV_PROJ__PCIE2_PADS_CTL_4_PRBS_ERROR_1L_ERROR         0x00000001 /* R---V */
#define NV_PROJ__PCIE2_PADS_CTL_4_PRBS_ERROR_1L_NO_ERROR      0x00000000 /* R---V */
#define NV_PROJ__PCIE2_PADS_CTL_4_CDR_TEST_GS                      19:16 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_4_CDR_TEST_GS_DEFAULT         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_4_CDR_TEST_GS_ENABLE          0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_4_CDR_TEST_GS_DISABLE         0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_4_CDR_MODE_1P                      23:20 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_4_CDR_MODE_1P_DEFAULT         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_4_TX_TERM_1P                       24:24 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_4_TX_TERM_1P_DEFAULT          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_4_RX_TERM_1P                       25:25 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_4_RX_TERM_1P_DEFAULT          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_4_SPARE_IN_GS                      29:28 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_4_SPARE_IN_GS_DEFAULT         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_4_SPARE_OUT_1L                     31:30 /* R--VF */
#define NV_PROJ__PCIE2_PADS_CTL_5                             0x000000AC /* RW-4R */
#define NV_PROJ__PCIE2_PADS_CTL_5_TX_AMP_R1_1C                       5:0 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_5_TX_AMP_R1_1C_DEFAULT        0x00000020 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_5_TX_AMP_R1_1C_1150_MVPPD     0x00000026 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_5_TX_AMP_R1_1C_1000_MVPPD     0x00000020 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_5_TX_AMP_R1_1C__500_MVPPD     0x0000000C /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_5_TX_AMP_R1_1C__200_MVPPD     0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_5_TX_CMADJ_R1_1C                    11:8 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_5_TX_CMADJ_R1_1C_DEFAULT      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_5_TX_PEAK_R1_1C                    16:12 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_5_TX_PEAK_R1_1C_DEFAULT       0x0000000E /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_5_TX_PEAK_R1_1C_DISABLE       0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_5_TX_PEAK_R1_1C_37DB          0x0000000E /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_5_TX_PEAK_R1_1C_60DB          0x00000014 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_5_TX_PEAK_PRE_R1_1C                19:17 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_5_TX_PEAK_PRE_R1_1C_DEFAULT   0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_5_RX_EQ_R1_1C                      30:28 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_5_RX_EQ_R1_1C_DEFAULT         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_5_RX_EQ_R1_1C_NO_EQ           0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_5_RX_EQ_R1_1C_MAX_EQ          0x00000007 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_6                             0x000000B0 /* RW-4R */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_AMP_R2_1C                       5:0 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_AMP_R2_1C_DEFAULT        0x00000020 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_AMP_R2_1C_1150_MVPPD     0x00000026 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_AMP_R2_1C_1000_MVPPD     0x00000020 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_AMP_R2_1C__500_MVPPD     0x0000000C /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_AMP_R2_1C__200_MVPPD     0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_CMADJ_R2_1C                    11:8 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_CMADJ_R2_1C_DEFAULT      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_PEAK_R2_SEL1_1C               16:12 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_PEAK_R2_SEL1_1C_DEFAULT  0x0000000E /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_PEAK_R2_SEL1_1C_DISABLE  0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_PEAK_R2_SEL1_1C_37DB     0x0000000E /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_PEAK_R2_SEL1_1C_60DB     0x00000014 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_PEAK_PRE_R2_SEL1_1C              19:17 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_PEAK_PRE_R2_SEL1_1C_DEFAULT 0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_PEAK_R2_SEL0_1C               24:20 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_PEAK_R2_SEL0_1C_DEFAULT  0x00000014 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_PEAK_R2_SEL0_1C_DISABLE  0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_PEAK_R2_SEL0_1C_37DB     0x0000000E /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_PEAK_R2_SEL0_1C_60DB     0x00000014 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_PEAK_PRE_R2_SEL0_1C              27:25 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_6_TX_PEAK_PRE_R2_SEL0_1C_DEFAULT 0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_6_RX_EQ_R2_1C                      30:28 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_CTL_6_RX_EQ_R2_1C_DEFAULT         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_CTL_6_RX_EQ_R2_1C_NO_EQ           0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_CTL_6_RX_EQ_R2_1C_MAX_EQ          0x00000007 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_SEL                           0x000000B4 /* RW-4R */
#define NV_PROJ__PCIE2_PADS_PLL_SEL_PLL_SELECT                      31:0 /* RWIVF */
#define NV_PROJ__PCIE2_PADS_PLL_SEL_PLL_SELECT_DEFAULT        0xFFFFFFFF /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_SEL_PLL_SELECT_NO_PLLS        0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_SEL_PLL_SELECT_PLLS_31_0      0xFFFFFFFF /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1                             0x000000B8 /* RW-4R */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_IDDQ_MODE_B4SM                 0:0 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_IDDQ_MODE_B4SM_DEFAULT  0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_IDDQ_MODE_B4SM_ENABLED  0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_IDDQ_MODE_B4SM_DISABLED 0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_RST_B4SM                       1:1 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_RST_B4SM_DEFAULT        0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_RST_B4SM_ASSERT         0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_RST_B4SM_DEASSERT       0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_EMU_RST                        2:2 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_EMU_RST_DEFAULT         0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_EMU_RST_HOLD            0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_EMU_RST_RELEASE         0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_CKBUFPD_R                      4:4 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_CKBUFPD_R_DEFAULT       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_CKBUFPD_R_DISABLED      0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_CKBUFPD_R_ENABLED       0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_CKBUFPD_L                      5:5 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_CKBUFPD_L_DEFAULT       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_CKBUFPD_L_DISABLED      0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_CKBUFPD_L_ENABLED       0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_CKBUFPD_M                      6:6 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_CKBUFPD_M_DEFAULT       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_CKBUFPD_M_INDEPENDENT   0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_CKBUFPD_M_SHARED        0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_CKBUFPD_OVRD                   7:7 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_CKBUFPD_OVRD_DEFAULT    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_CKBUFPD_OVRD_DISABLED   0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_CKBUFPD_OVRD_ENABLED    0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_LOCKDET                        8:8 /* R--VF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_LOCKDET_NOT_LOCKED      0x00000000 /* R---V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_LOCKDET_LOCKED          0x00000001 /* R---V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XDIGCLK_SEL                  14:12 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XDIGCLK_SEL_DEFAULT     0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XDIGCLK_SEL_DIV10       0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XDIGCLK_SEL_DIV9        0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XDIGCLK_SEL_DIV8        0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XDIGCLK_SEL_DIV7        0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XDIGCLK_SEL_DIV3        0x00000007 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XDIGCLK_EN                   15:15 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XDIGCLK_EN_DEFAULT      0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XDIGCLK_EN_DISABLED     0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XDIGCLK_EN_ENABLED      0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_REFCLK_SEL                   17:16 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_REFCLK_SEL_DEFAULT       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_REFCLK_SEL_INTERNAL_CML  0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_REFCLK_SEL_INTERNAL_CMOS 0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_REFCLK_SEL_EXTERNAL      0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_REFCLK_DIV                   19:18 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_REFCLK_DIV_DEFAULT      0x00000002 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_REFCLK_DIV_10X          0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_REFCLK_DIV_20X          0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_REFCLK_DIV_25X          0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_REFCLK_DIV_30X          0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TXCLKREF_SEL                 20:20 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TXCLKREF_SEL_DEFAULT    0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TXCLKREF_SEL_DIV10      0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TXCLKREF_SEL_DIV5       0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TXCLKREF_EN                  21:21 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TXCLKREF_EN_DEFAULT     0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TXCLKREF_EN_DISABLED    0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TXCLKREF_EN_ENABLED     0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_REFCLKBUF_EN                 22:22 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_REFCLKBUF_EN_DEFAULT    0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_REFCLKBUF_EN_DISABLED   0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_REFCLKBUF_EN_ENABLED    0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XDIGCLK4P5_EN                23:23 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XDIGCLK4P5_EN_DEFAULT   0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XDIGCLK4P5_EN_DISABLED  0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XDIGCLK4P5_EN_ENABLED   0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TCLKOUT_SEL                  26:24 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TCLKOUT_SEL_DEFAULT     0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TCLKOUT_SEL_DIV10       0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TCLKOUT_SEL_DIV5        0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TCLKOUT_SEL_XDIGCLK     0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TCLKOUT_SEL_REFCLK      0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TCLKOUT_SEL_LFBCLK      0x00000007 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TCLKOUT_EN                   27:27 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TCLKOUT_EN_DEFAULT      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TCLKOUT_EN_DISABLED     0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_TCLKOUT_EN_ENABLED      0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XREF_TERM100                 28:28 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XREF_TERM100_DEFAULT    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XREF_TERM100_DISABLED   0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_XREF_TERM100_ENABLED    0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_EMU_ON                       29:29 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_EMU_ON_DEFAULT          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_EMU_ON_DISABLED         0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_EMU_ON_ENABLED          0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_BYPASS_EN                    31:31 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_BYPASS_EN_DEFAULT       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_BYPASS_EN_DISABLED      0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL1_PLL_BYPASS_EN_ENABLED       0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2                             0x000000BC /* RW-4R */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_CODE                      4:0 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_CODE_DEFAULT       0x0000000E /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_CODE_MAX_R         0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_CODE_NOMINAL_R     0x0000000E /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_CODE_MIN_R         0x0000001F /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_BYPASS                    7:7 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_BYPASS_DEFAULT     0x00000001 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_BYPASS_DISABLED    0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_BYPASS_ENABLED     0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_VAL                      12:8 /* R--VF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_VAL_MAX_R          0x00000000 /* R---V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_VAL_MIN_R          0x0000001F /* R---V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_RESET                   14:14 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_RESET_DEFAULT      0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_RESET_DISABLED     0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_RESET_ENABLED      0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_DONE                    15:15 /* R--VF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_DONE_FALSE         0x00000000 /* R---V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_RCAL_DONE_TRUE          0x00000001 /* R---V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_BGAP_CNTL                    17:16 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_BGAP_CNTL_DEFAULT       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_BGAP_CNTL_NORMAL        0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_BGAP_CNTL_POS_COEFF     0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_BGAP_CNTL_NEG_COEFF     0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_BGAP_CNTL_NORMAL_PLUS   0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_CP_CNTL                      22:20 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_CP_CNTL_DEFAULT         0x00000004 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_CP_CNTL_15UA            0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_CP_CNTL_17P5UA          0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_CP_CNTL_20UA            0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_CP_CNTL_22P5UA          0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_CP_CNTL_25UA            0x00000005 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_CP_CNTL_27P5UA          0x00000006 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_CP_CNTL_30UA            0x00000007 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_MISC_CNTL                    27:24 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL2_PLL_MISC_CNTL_DEFAULT       0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3                             0x000000C0 /* RW-4R */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_IDDQ                         0:0 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_IDDQ_DEFAULT          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_IDDQ_DISABLED         0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_IDDQ_ENABLED          0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_RST                          1:1 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_RST_DEFAULT           0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_RST_ASSERT            0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_RST_DEASSERT          0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_MODE                         4:4 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_MODE_DEFAULT          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_MODE_PCIE             0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_MODE_DISPLAY          0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_LOCKDET                      8:8 /* R--VF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_LOCKDET_NOT_LOCKED    0x00000000 /* R---V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_LOCKDET_LOCKED        0x00000001 /* R---V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_TCLKOUT_SEL                26:24 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_TCLKOUT_SEL_DEFAULT   0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_TCLKOUT_SEL_DIV5      0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_TCLKOUT_SEL_DIV10     0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_TCLKOUT_SEL_REFCLK    0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_TCLKOUT_SEL_LFBCLK    0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_TCLKOUT_SEL_TXCLKREF  0x00000006 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_TCLKOUT_SEL_TKOUT_IN  0x00000007 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_TCLKOUT_EN                 27:27 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_TCLKOUT_EN_DEFAULT    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_TCLKOUT_EN_DISABLED   0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_TCLKOUT_EN_ENABLED    0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_BYPASS_EN                  31:31 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_BYPASS_EN_DEFAULT     0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_BYPASS_EN_DISABLED    0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL3_DPLL0_BYPASS_EN_ENABLED     0x00000001 /* RW--V */ 
#define NV_PROJ__PCIE2_PADS_PLL_CTL4                             0x000000C4 /* RW-4R */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_IDDQ                         0:0 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_IDDQ_DEFAULT          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_IDDQ_DISABLED         0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_IDDQ_ENABLED          0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_RST                          1:1 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_RST_DEFAULT           0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_RST_ASSERT            0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_RST_DEASSERT          0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_MODE                         4:4 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_MODE_DEFAULT          0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_MODE_PCIE             0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_MODE_DISPLAY          0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_LOCKDET                      8:8 /* R--VF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_LOCKDET_NOT_LOCKED    0x00000000 /* R---V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_LOCKDET_LOCKED        0x00000001 /* R---V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_TCLKOUT_SEL                26:24 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_TCLKOUT_SEL_DEFAULT   0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_TCLKOUT_SEL_DIV5      0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_TCLKOUT_SEL_DIV10     0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_TCLKOUT_SEL_REFCLK    0x00000002 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_TCLKOUT_SEL_LFBCLK    0x00000003 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_TCLKOUT_SEL_TXCLKREF  0x00000006 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_TCLKOUT_SEL_TKOUT_IN  0x00000007 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_TCLKOUT_EN                 27:27 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_TCLKOUT_EN_DEFAULT    0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_TCLKOUT_EN_DISABLED   0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_TCLKOUT_EN_ENABLED    0x00000001 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_BYPASS_EN                  31:31 /* RWIUF */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_BYPASS_EN_DEFAULT     0x00000000 /* RWI-V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_BYPASS_EN_DISABLED    0x00000000 /* RW--V */
#define NV_PROJ__PCIE2_PADS_PLL_CTL4_DPLL1_BYPASS_EN_ENABLED     0x00000001 /* RW--V */

#endif // ifndef ___DEV_AP_PCIE2_PADS_H_INC_

