/*
 * Copyright (c) 2010 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 * Defines fields in the PMC scratch registers used by the Boot ROM code.
 */

#ifndef INCLUDED_NVBOOT_PMC_SCRATCH_MAP_H
#define INCLUDED_NVBOOT_PMC_SCRATCH_MAP_H

// Special definition for the subset of EMC_FBIO_SPARE restored in WB0.
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_WB0_RANGE        31:24
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_WB0_SHIFT        _MK_SHIFT_CONST(24)
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_WB0_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)

#define APBDEV_PMC_SCRATCH0_0_WARM_BOOT0_FLAG_RANGE        0:0
#define APBDEV_PMC_SCRATCH0_0_WARM_BOOT0_FLAG_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH0_0_WARM_BOOT0_FLAG_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

/**
 * MEMORY_TYPE:
 *   Source: SDRAM[n].MemoryType
 *   Desc:   An enumerated constant that identifies the type of SDRAM
 *     (DDR, DDR2, LPDDR, LPDDR2), as the initialization sequence is different
 *     for each of them. DDR is only valid for FPGA emulation, but the
 *     Boot ROM code does not make this distinction.
 */
#define APBDEV_PMC_SCRATCH2_0_CLK_RST_PLLM_BASE_PLLM_DIVM_RANGE        4:0
#define APBDEV_PMC_SCRATCH2_0_CLK_RST_PLLM_BASE_PLLM_DIVM_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH2_0_CLK_RST_PLLM_BASE_PLLM_DIVM_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH2_0_CLK_RST_PLLM_BASE_PLLM_DIVN_RANGE        14:5
#define APBDEV_PMC_SCRATCH2_0_CLK_RST_PLLM_BASE_PLLM_DIVN_SHIFT        _MK_SHIFT_CONST(5)
#define APBDEV_PMC_SCRATCH2_0_CLK_RST_PLLM_BASE_PLLM_DIVN_DEFAULT_MASK _MK_MASK_CONST(0x000003FF)

#define APBDEV_PMC_SCRATCH2_0_CLK_RST_PLLM_BASE_PLLM_DIVP_RANGE        17:15
#define APBDEV_PMC_SCRATCH2_0_CLK_RST_PLLM_BASE_PLLM_DIVP_SHIFT        _MK_SHIFT_CONST(15)
#define APBDEV_PMC_SCRATCH2_0_CLK_RST_PLLM_BASE_PLLM_DIVP_DEFAULT_MASK _MK_MASK_CONST(0x00000007)

#define APBDEV_PMC_SCRATCH2_0_CLK_RST_PLLM_MISC_LFCON_RANGE        21:18
#define APBDEV_PMC_SCRATCH2_0_CLK_RST_PLLM_MISC_LFCON_SHIFT        _MK_SHIFT_CONST(18)
#define APBDEV_PMC_SCRATCH2_0_CLK_RST_PLLM_MISC_LFCON_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH2_0_CLK_RST_PLLM_MISC_CPCON_RANGE        25:22
#define APBDEV_PMC_SCRATCH2_0_CLK_RST_PLLM_MISC_CPCON_SHIFT        _MK_SHIFT_CONST(22)
#define APBDEV_PMC_SCRATCH2_0_CLK_RST_PLLM_MISC_CPCON_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH2_0_APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_PREEMP_EN_RANGE        26:26
#define APBDEV_PMC_SCRATCH2_0_APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_PREEMP_EN_SHIFT        _MK_SHIFT_CONST(26)
#define APBDEV_PMC_SCRATCH2_0_APB_MISC_GP_XM2CFGAPADCTRL_0_CFG2TMC_XM2CFGA_PREEMP_EN_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH2_0_APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_SCHMT_EN_RANGE        27:27
#define APBDEV_PMC_SCRATCH2_0_APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_SCHMT_EN_SHIFT        _MK_SHIFT_CONST(27)
#define APBDEV_PMC_SCRATCH2_0_APB_MISC_GP_XM2CFGDPADCTRL_0_CFG2TMC_XM2CFGD_SCHMT_EN_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH2_0_CLK_RST_OSC_CTRL_XOBP_RANGE        28:28
#define APBDEV_PMC_SCRATCH2_0_CLK_RST_OSC_CTRL_XOBP_SHIFT        _MK_SHIFT_CONST(28)
#define APBDEV_PMC_SCRATCH2_0_CLK_RST_OSC_CTRL_XOBP_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH2_0_MEMORY_TYPE_RANGE        31:29
#define APBDEV_PMC_SCRATCH2_0_MEMORY_TYPE_SHIFT        _MK_SHIFT_CONST(29)
#define APBDEV_PMC_SCRATCH2_0_MEMORY_TYPE_DEFAULT_MASK _MK_MASK_CONST(0x00000007)


#define APBDEV_PMC_SCRATCH3_0_CLK_RST_PLLX_BASE_PLLX_DIVM_RANGE        4:0
#define APBDEV_PMC_SCRATCH3_0_CLK_RST_PLLX_BASE_PLLX_DIVM_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH3_0_CLK_RST_PLLX_BASE_PLLX_DIVM_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH3_0_CLK_RST_PLLX_BASE_PLLX_DIVN_RANGE        14:5
#define APBDEV_PMC_SCRATCH3_0_CLK_RST_PLLX_BASE_PLLX_DIVN_SHIFT        _MK_SHIFT_CONST(5)
#define APBDEV_PMC_SCRATCH3_0_CLK_RST_PLLX_BASE_PLLX_DIVN_DEFAULT_MASK _MK_MASK_CONST(0x000003FF)

#define APBDEV_PMC_SCRATCH3_0_CLK_RST_PLLX_BASE_PLLX_DIVP_RANGE        17:15
#define APBDEV_PMC_SCRATCH3_0_CLK_RST_PLLX_BASE_PLLX_DIVP_SHIFT        _MK_SHIFT_CONST(15)
#define APBDEV_PMC_SCRATCH3_0_CLK_RST_PLLX_BASE_PLLX_DIVP_DEFAULT_MASK _MK_MASK_CONST(0x00000007)

#define APBDEV_PMC_SCRATCH3_0_CLK_RST_PLLX_MISC_LFCON_RANGE        21:18
#define APBDEV_PMC_SCRATCH3_0_CLK_RST_PLLX_MISC_LFCON_SHIFT        _MK_SHIFT_CONST(18)
#define APBDEV_PMC_SCRATCH3_0_CLK_RST_PLLX_MISC_LFCON_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH3_0_CLK_RST_PLLX_MISC_CPCON_RANGE        25:22
#define APBDEV_PMC_SCRATCH3_0_CLK_RST_PLLX_MISC_CPCON_SHIFT        _MK_SHIFT_CONST(22)
#define APBDEV_PMC_SCRATCH3_0_CLK_RST_PLLX_MISC_CPCON_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH3_0_APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_SCHMT_EN_RANGE        26:26
#define APBDEV_PMC_SCRATCH3_0_APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_SCHMT_EN_SHIFT        _MK_SHIFT_CONST(26)
#define APBDEV_PMC_SCRATCH3_0_APB_MISC_GP_XM2CFGCPADCTRL_0_CFG2TMC_XM2CFGC_SCHMT_EN_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH3_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_VREF_DQ_RANGE        30:27
#define APBDEV_PMC_SCRATCH3_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_VREF_DQ_SHIFT        _MK_SHIFT_CONST(27)
#define APBDEV_PMC_SCRATCH3_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_VREF_DQ_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH3_0_APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_PREEMP_EN_RANGE        31:31
#define APBDEV_PMC_SCRATCH3_0_APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_PREEMP_EN_SHIFT        _MK_SHIFT_CONST(31)
#define APBDEV_PMC_SCRATCH3_0_APB_MISC_GP_XM2CLKCFGPADCTRL_0_CFG2TMC_XM2CLKCFG_PREEMP_EN_DEFAULT_MASK _MK_MASK_CONST(0x00000001)


/**
 * PLLM_STABLE_TIME:
 *   Source: SDRAM[n].PllMStableTime
 *   Dest: SDRAM initialization code
 *   Desc: Time to wait for PLLM to become stable, in microseconds.  Overrides
 *     internal stabilization time values.
 * PLLX_STABLE_TIME:
 *   Source: SDRAM[n].PllXStableTime
 *   Dest: PLLX initialization code for WB0
 *   Desc: Time to wait for PLLM to become stable, in microseconds.  Overrides
 *     internal stabilization time values.
 * EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_WB0:
 *   Source: SDRAM[n].EmcFbioSpare (upper 8 bits)
 *   Dest: Upper 8 bits of EMC_FBIO_SPARE
 *   Desc: To avoid wasting all 32-bits of PMC scratch for spare bits for
 *     some future use, only the upper 8 bits are preserved.
 */
#define APBDEV_PMC_SCRATCH4_0_EMC_CLOCK_DIVIDER_RANGE        7:0
#define APBDEV_PMC_SCRATCH4_0_EMC_CLOCK_DIVIDER_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH4_0_EMC_CLOCK_DIVIDER_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)

#define APBDEV_PMC_SCRATCH4_0_PLLM_STABLE_TIME_RANGE        15:8
#define APBDEV_PMC_SCRATCH4_0_PLLM_STABLE_TIME_SHIFT        _MK_SHIFT_CONST(8)
#define APBDEV_PMC_SCRATCH4_0_PLLM_STABLE_TIME_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)

#define APBDEV_PMC_SCRATCH4_0_PLLX_STABLE_TIME_RANGE        23:16
#define APBDEV_PMC_SCRATCH4_0_PLLX_STABLE_TIME_SHIFT        _MK_SHIFT_CONST(16)
#define APBDEV_PMC_SCRATCH4_0_PLLX_STABLE_TIME_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)

#define APBDEV_PMC_SCRATCH4_0_EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_WB0_RANGE        31:24
#define APBDEV_PMC_SCRATCH4_0_EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_WB0_SHIFT        _MK_SHIFT_CONST(24)
#define APBDEV_PMC_SCRATCH4_0_EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_WB0_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)


#define APBDEV_PMC_SCRATCH5_0_EMC_RC_0_RC_RANGE        5:0
#define APBDEV_PMC_SCRATCH5_0_EMC_RC_0_RC_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH5_0_EMC_RC_0_RC_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH5_0_EMC_RFC_0_RFC_RANGE        14:6
#define APBDEV_PMC_SCRATCH5_0_EMC_RFC_0_RFC_SHIFT        _MK_SHIFT_CONST(6)
#define APBDEV_PMC_SCRATCH5_0_EMC_RFC_0_RFC_DEFAULT_MASK _MK_MASK_CONST(0x000001FF)

#define APBDEV_PMC_SCRATCH5_0_EMC_RAS_0_RAS_RANGE        20:15
#define APBDEV_PMC_SCRATCH5_0_EMC_RAS_0_RAS_SHIFT        _MK_SHIFT_CONST(15)
#define APBDEV_PMC_SCRATCH5_0_EMC_RAS_0_RAS_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH5_0_EMC_RP_0_RP_RANGE        26:21
#define APBDEV_PMC_SCRATCH5_0_EMC_RP_0_RP_SHIFT        _MK_SHIFT_CONST(21)
#define APBDEV_PMC_SCRATCH5_0_EMC_RP_0_RP_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH5_0_EMC_R2W_0_R2W_RANGE        31:27
#define APBDEV_PMC_SCRATCH5_0_EMC_R2W_0_R2W_SHIFT        _MK_SHIFT_CONST(27)
#define APBDEV_PMC_SCRATCH5_0_EMC_R2W_0_R2W_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)


#define APBDEV_PMC_SCRATCH6_0_EMC_W2R_0_W2R_RANGE        4:0
#define APBDEV_PMC_SCRATCH6_0_EMC_W2R_0_W2R_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH6_0_EMC_W2R_0_W2R_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH6_0_EMC_R2P_0_R2P_RANGE        9:5
#define APBDEV_PMC_SCRATCH6_0_EMC_R2P_0_R2P_SHIFT        _MK_SHIFT_CONST(5)
#define APBDEV_PMC_SCRATCH6_0_EMC_R2P_0_R2P_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH6_0_EMC_W2P_0_W2P_RANGE        14:10
#define APBDEV_PMC_SCRATCH6_0_EMC_W2P_0_W2P_SHIFT        _MK_SHIFT_CONST(10)
#define APBDEV_PMC_SCRATCH6_0_EMC_W2P_0_W2P_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH6_0_EMC_RD_RCD_0_RD_RCD_RANGE        20:15
#define APBDEV_PMC_SCRATCH6_0_EMC_RD_RCD_0_RD_RCD_SHIFT        _MK_SHIFT_CONST(15)
#define APBDEV_PMC_SCRATCH6_0_EMC_RD_RCD_0_RD_RCD_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH6_0_EMC_WR_RCD_0_WR_RCD_RANGE        26:21
#define APBDEV_PMC_SCRATCH6_0_EMC_WR_RCD_0_WR_RCD_SHIFT        _MK_SHIFT_CONST(21)
#define APBDEV_PMC_SCRATCH6_0_EMC_WR_RCD_0_WR_RCD_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH6_0_EMC_RRD_0_RRD_RANGE        30:27
#define APBDEV_PMC_SCRATCH6_0_EMC_RRD_0_RRD_SHIFT        _MK_SHIFT_CONST(27)
#define APBDEV_PMC_SCRATCH6_0_EMC_RRD_0_RRD_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)


#define APBDEV_PMC_SCRATCH7_0_EMC_REXT_0_REXT_RANGE        3:0
#define APBDEV_PMC_SCRATCH7_0_EMC_REXT_0_REXT_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH7_0_EMC_REXT_0_REXT_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH7_0_EMC_WDV_0_WDV_RANGE        7:4
#define APBDEV_PMC_SCRATCH7_0_EMC_WDV_0_WDV_SHIFT        _MK_SHIFT_CONST(4)
#define APBDEV_PMC_SCRATCH7_0_EMC_WDV_0_WDV_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH7_0_EMC_QUSE_0_QUSE_RANGE        11:8
#define APBDEV_PMC_SCRATCH7_0_EMC_QUSE_0_QUSE_SHIFT        _MK_SHIFT_CONST(8)
#define APBDEV_PMC_SCRATCH7_0_EMC_QUSE_0_QUSE_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH7_0_EMC_QRST_0_QRST_RANGE        15:12
#define APBDEV_PMC_SCRATCH7_0_EMC_QRST_0_QRST_SHIFT        _MK_SHIFT_CONST(12)
#define APBDEV_PMC_SCRATCH7_0_EMC_QRST_0_QRST_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH7_0_EMC_QSAFE_0_QSAFE_RANGE        19:16
#define APBDEV_PMC_SCRATCH7_0_EMC_QSAFE_0_QSAFE_SHIFT        _MK_SHIFT_CONST(16)
#define APBDEV_PMC_SCRATCH7_0_EMC_QSAFE_0_QSAFE_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH7_0_EMC_RDV_0_RDV_RANGE        24:20
#define APBDEV_PMC_SCRATCH7_0_EMC_RDV_0_RDV_SHIFT        _MK_SHIFT_CONST(20)
#define APBDEV_PMC_SCRATCH7_0_EMC_RDV_0_RDV_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH7_0_EMC_PCHG2PDEN_0_PCHG2PDEN_RANGE        29:25
#define APBDEV_PMC_SCRATCH7_0_EMC_PCHG2PDEN_0_PCHG2PDEN_SHIFT        _MK_SHIFT_CONST(25)
#define APBDEV_PMC_SCRATCH7_0_EMC_PCHG2PDEN_0_PCHG2PDEN_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH7_0_EMC_CFG_2_0_USE_ADDR_CLK_RANGE        30:30
#define APBDEV_PMC_SCRATCH7_0_EMC_CFG_2_0_USE_ADDR_CLK_SHIFT        _MK_SHIFT_CONST(30)
#define APBDEV_PMC_SCRATCH7_0_EMC_CFG_2_0_USE_ADDR_CLK_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH7_0_EMC_CFG_2_0_CLKCHANGE_SR_ENABLE_RANGE        31:31
#define APBDEV_PMC_SCRATCH7_0_EMC_CFG_2_0_CLKCHANGE_SR_ENABLE_SHIFT        _MK_SHIFT_CONST(31)
#define APBDEV_PMC_SCRATCH7_0_EMC_CFG_2_0_CLKCHANGE_SR_ENABLE_DEFAULT_MASK _MK_MASK_CONST(0x00000001)


#define APBDEV_PMC_SCRATCH8_0_EMC_REFRESH_0_REFRESH_LO_RANGE        4:0
#define APBDEV_PMC_SCRATCH8_0_EMC_REFRESH_0_REFRESH_LO_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH8_0_EMC_REFRESH_0_REFRESH_LO_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH8_0_EMC_REFRESH_0_REFRESH_RANGE        15:5
#define APBDEV_PMC_SCRATCH8_0_EMC_REFRESH_0_REFRESH_SHIFT        _MK_SHIFT_CONST(5)
#define APBDEV_PMC_SCRATCH8_0_EMC_REFRESH_0_REFRESH_DEFAULT_MASK _MK_MASK_CONST(0x000007FF)

#define APBDEV_PMC_SCRATCH8_0_EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_RANGE        19:16
#define APBDEV_PMC_SCRATCH8_0_EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_SHIFT        _MK_SHIFT_CONST(16)
#define APBDEV_PMC_SCRATCH8_0_EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH8_0_EMC_PDEX2WR_0_PDEX2WR_RANGE        23:20
#define APBDEV_PMC_SCRATCH8_0_EMC_PDEX2WR_0_PDEX2WR_SHIFT        _MK_SHIFT_CONST(20)
#define APBDEV_PMC_SCRATCH8_0_EMC_PDEX2WR_0_PDEX2WR_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH8_0_EMC_PDEX2RD_0_PDEX2RD_RANGE        27:24
#define APBDEV_PMC_SCRATCH8_0_EMC_PDEX2RD_0_PDEX2RD_SHIFT        _MK_SHIFT_CONST(24)
#define APBDEV_PMC_SCRATCH8_0_EMC_PDEX2RD_0_PDEX2RD_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH8_0_EMC_TCLKSTABLE_0_TCLKSTABLE_RANGE        31:28
#define APBDEV_PMC_SCRATCH8_0_EMC_TCLKSTABLE_0_TCLKSTABLE_SHIFT        _MK_SHIFT_CONST(28)
#define APBDEV_PMC_SCRATCH8_0_EMC_TCLKSTABLE_0_TCLKSTABLE_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)


#define APBDEV_PMC_SCRATCH9_0_EMC_ACT2PDEN_0_ACT2PDEN_RANGE        4:0
#define APBDEV_PMC_SCRATCH9_0_EMC_ACT2PDEN_0_ACT2PDEN_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH9_0_EMC_ACT2PDEN_0_ACT2PDEN_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH9_0_EMC_AR2PDEN_0_AR2PDEN_RANGE        9:5
#define APBDEV_PMC_SCRATCH9_0_EMC_AR2PDEN_0_AR2PDEN_SHIFT        _MK_SHIFT_CONST(5)
#define APBDEV_PMC_SCRATCH9_0_EMC_AR2PDEN_0_AR2PDEN_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH9_0_EMC_RW2PDEN_0_RW2PDEN_RANGE        15:10
#define APBDEV_PMC_SCRATCH9_0_EMC_RW2PDEN_0_RW2PDEN_SHIFT        _MK_SHIFT_CONST(10)
#define APBDEV_PMC_SCRATCH9_0_EMC_RW2PDEN_0_RW2PDEN_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH9_0_EMC_TXSR_0_TXSR_RANGE        27:16
#define APBDEV_PMC_SCRATCH9_0_EMC_TXSR_0_TXSR_SHIFT        _MK_SHIFT_CONST(16)
#define APBDEV_PMC_SCRATCH9_0_EMC_TXSR_0_TXSR_DEFAULT_MASK _MK_MASK_CONST(0x00000FFF)

#define APBDEV_PMC_SCRATCH9_0_EMC_TCKE_0_TCKE_RANGE        31:28
#define APBDEV_PMC_SCRATCH9_0_EMC_TCKE_0_TCKE_SHIFT        _MK_SHIFT_CONST(28)
#define APBDEV_PMC_SCRATCH9_0_EMC_TCKE_0_TCKE_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)


#define APBDEV_PMC_SCRATCH10_0_EMC_TRPAB_0_TRPAB_RANGE        5:0
#define APBDEV_PMC_SCRATCH10_0_EMC_TRPAB_0_TRPAB_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH10_0_EMC_TRPAB_0_TRPAB_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH10_0_EMC_TCLKSTOP_0_TCLKSTOP_RANGE        9:6
#define APBDEV_PMC_SCRATCH10_0_EMC_TCLKSTOP_0_TCLKSTOP_SHIFT        _MK_SHIFT_CONST(6)
#define APBDEV_PMC_SCRATCH10_0_EMC_TCLKSTOP_0_TCLKSTOP_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH10_0_EMC_TREFBW_0_TREFBW_RANGE        23:10
#define APBDEV_PMC_SCRATCH10_0_EMC_TREFBW_0_TREFBW_SHIFT        _MK_SHIFT_CONST(10)
#define APBDEV_PMC_SCRATCH10_0_EMC_TREFBW_0_TREFBW_DEFAULT_MASK _MK_MASK_CONST(0x00003FFF)

#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_READ_MUX_RANGE        24:24
#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_READ_MUX_SHIFT        _MK_SHIFT_CONST(24)
#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_READ_MUX_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_WRITE_MUX_RANGE        25:25
#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_WRITE_MUX_SHIFT        _MK_SHIFT_CONST(25)
#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_WRITE_MUX_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_FORCE_UPDATE_RANGE        26:26
#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_FORCE_UPDATE_SHIFT        _MK_SHIFT_CONST(26)
#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_FORCE_UPDATE_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_MRS_WAIT_RANGE        27:27
#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_MRS_WAIT_SHIFT        _MK_SHIFT_CONST(27)
#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_MRS_WAIT_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_PERIODIC_QRST_RANGE        28:28
#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_PERIODIC_QRST_SHIFT        _MK_SHIFT_CONST(28)
#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_PERIODIC_QRST_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_READ_DQM_CTRL_RANGE        29:29
#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_READ_DQM_CTRL_SHIFT        _MK_SHIFT_CONST(29)
#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_READ_DQM_CTRL_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_AP_REQ_BUSY_CTRL_RANGE        30:30
#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_AP_REQ_BUSY_CTRL_SHIFT        _MK_SHIFT_CONST(30)
#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_AP_REQ_BUSY_CTRL_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_CFG_PRIORITY_RANGE        31:31
#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_CFG_PRIORITY_SHIFT        _MK_SHIFT_CONST(31)
#define APBDEV_PMC_SCRATCH10_0_EMC_DBG_0_CFG_PRIORITY_DEFAULT_MASK _MK_MASK_CONST(0x00000001)


// Note: 1 bit is reserved.
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_0_RANGE        1:0
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_0_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_0_DEFAULT_MASK _MK_MASK_CONST(0x00000003)

#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_1_RANGE        3:2
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_1_SHIFT        _MK_SHIFT_CONST(2)
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_1_DEFAULT_MASK _MK_MASK_CONST(0x00000003)

#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_2_RANGE        5:4
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_2_SHIFT        _MK_SHIFT_CONST(4)
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_2_DEFAULT_MASK _MK_MASK_CONST(0x00000003)

#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_3_RANGE        7:6
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_3_SHIFT        _MK_SHIFT_CONST(6)
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_3_DEFAULT_MASK _MK_MASK_CONST(0x00000003)

#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_0_RANGE        9:8
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_0_SHIFT        _MK_SHIFT_CONST(8)
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_0_DEFAULT_MASK _MK_MASK_CONST(0x00000003)

#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_1_RANGE        11:10
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_1_SHIFT        _MK_SHIFT_CONST(10)
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_1_DEFAULT_MASK _MK_MASK_CONST(0x00000003)

#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_2_RANGE        13:12
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_2_SHIFT        _MK_SHIFT_CONST(12)
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_2_DEFAULT_MASK _MK_MASK_CONST(0x00000003)

#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_3_RANGE        15:14
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_3_SHIFT        _MK_SHIFT_CONST(14)
#define APBDEV_PMC_SCRATCH11_0_EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_3_DEFAULT_MASK _MK_MASK_CONST(0x00000003)

#define APBDEV_PMC_SCRATCH11_0_EMC_TFAW_0_TFAW_RANGE        21:16
#define APBDEV_PMC_SCRATCH11_0_EMC_TFAW_0_TFAW_SHIFT        _MK_SHIFT_CONST(16)
#define APBDEV_PMC_SCRATCH11_0_EMC_TFAW_0_TFAW_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH11_0_EMC_QUSE_EXTRA_0_QUSE_EXTRA_RANGE        25:22
#define APBDEV_PMC_SCRATCH11_0_EMC_QUSE_EXTRA_0_QUSE_EXTRA_SHIFT        _MK_SHIFT_CONST(22)
#define APBDEV_PMC_SCRATCH11_0_EMC_QUSE_EXTRA_0_QUSE_EXTRA_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH11_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_VREF_DQS_RANGE        29:26
#define APBDEV_PMC_SCRATCH11_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_VREF_DQS_SHIFT        _MK_SHIFT_CONST(26)
#define APBDEV_PMC_SCRATCH11_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_VREF_DQS_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH11_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_VREF_DQ_EN_RANGE        30:30
#define APBDEV_PMC_SCRATCH11_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_VREF_DQ_EN_SHIFT        _MK_SHIFT_CONST(30)
#define APBDEV_PMC_SCRATCH11_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_VREF_DQ_EN_DEFAULT_MASK _MK_MASK_CONST(0x00000001)


#define APBDEV_PMC_SCRATCH12_0_EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_RANGE        7:0
#define APBDEV_PMC_SCRATCH12_0_EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH12_0_EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)

#define APBDEV_PMC_SCRATCH12_0_EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_RANGE        15:8
#define APBDEV_PMC_SCRATCH12_0_EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_SHIFT        _MK_SHIFT_CONST(8)
#define APBDEV_PMC_SCRATCH12_0_EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)

#define APBDEV_PMC_SCRATCH12_0_EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_RANGE        23:16
#define APBDEV_PMC_SCRATCH12_0_EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_SHIFT        _MK_SHIFT_CONST(16)
#define APBDEV_PMC_SCRATCH12_0_EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)

#define APBDEV_PMC_SCRATCH12_0_EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_RANGE        31:24
#define APBDEV_PMC_SCRATCH12_0_EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_SHIFT        _MK_SHIFT_CONST(24)
#define APBDEV_PMC_SCRATCH12_0_EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)


#define APBDEV_PMC_SCRATCH13_0_EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_RANGE        7:0
#define APBDEV_PMC_SCRATCH13_0_EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH13_0_EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)

#define APBDEV_PMC_SCRATCH13_0_EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_RANGE        15:8
#define APBDEV_PMC_SCRATCH13_0_EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_SHIFT        _MK_SHIFT_CONST(8)
#define APBDEV_PMC_SCRATCH13_0_EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)

#define APBDEV_PMC_SCRATCH13_0_EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_RANGE        23:16
#define APBDEV_PMC_SCRATCH13_0_EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_SHIFT        _MK_SHIFT_CONST(16)
#define APBDEV_PMC_SCRATCH13_0_EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)

#define APBDEV_PMC_SCRATCH13_0_EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_RANGE        31:24
#define APBDEV_PMC_SCRATCH13_0_EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_SHIFT        _MK_SHIFT_CONST(24)
#define APBDEV_PMC_SCRATCH13_0_EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)


// Note: 2 bits are reserved.
#define APBDEV_PMC_SCRATCH14_0_EMC_CFG_CLKTRIM_0_0_CFG_DATA0_CLKTRIM_RANGE        5:0
#define APBDEV_PMC_SCRATCH14_0_EMC_CFG_CLKTRIM_0_0_CFG_DATA0_CLKTRIM_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH14_0_EMC_CFG_CLKTRIM_0_0_CFG_DATA0_CLKTRIM_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH14_0_EMC_CFG_CLKTRIM_0_0_CFG_DATA1_CLKTRIM_RANGE        11:6
#define APBDEV_PMC_SCRATCH14_0_EMC_CFG_CLKTRIM_0_0_CFG_DATA1_CLKTRIM_SHIFT        _MK_SHIFT_CONST(6)
#define APBDEV_PMC_SCRATCH14_0_EMC_CFG_CLKTRIM_0_0_CFG_DATA1_CLKTRIM_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH14_0_EMC_CFG_CLKTRIM_0_0_CFG_DATA2_CLKTRIM_RANGE        17:12
#define APBDEV_PMC_SCRATCH14_0_EMC_CFG_CLKTRIM_0_0_CFG_DATA2_CLKTRIM_SHIFT        _MK_SHIFT_CONST(12)
#define APBDEV_PMC_SCRATCH14_0_EMC_CFG_CLKTRIM_0_0_CFG_DATA2_CLKTRIM_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH14_0_EMC_CFG_CLKTRIM_0_0_CFG_DATA3_CLKTRIM_RANGE        23:18
#define APBDEV_PMC_SCRATCH14_0_EMC_CFG_CLKTRIM_0_0_CFG_DATA3_CLKTRIM_SHIFT        _MK_SHIFT_CONST(18)
#define APBDEV_PMC_SCRATCH14_0_EMC_CFG_CLKTRIM_0_0_CFG_DATA3_CLKTRIM_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH14_0_EMC_CFG_CLKTRIM_0_0_CFG_MCLK_ADDR_CLKTRIM_RANGE        29:24
#define APBDEV_PMC_SCRATCH14_0_EMC_CFG_CLKTRIM_0_0_CFG_MCLK_ADDR_CLKTRIM_SHIFT        _MK_SHIFT_CONST(24)
#define APBDEV_PMC_SCRATCH14_0_EMC_CFG_CLKTRIM_0_0_CFG_MCLK_ADDR_CLKTRIM_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)


#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG1_0_CFG_DEN_EARLY_RANGE        0:0
#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG1_0_CFG_DEN_EARLY_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG1_0_CFG_DEN_EARLY_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG6_0_CFG_QUSE_LATE_RANGE        3:1
#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG6_0_CFG_QUSE_LATE_SHIFT        _MK_SHIFT_CONST(1)
#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG6_0_CFG_QUSE_LATE_DEFAULT_MASK _MK_MASK_CONST(0x00000007)

#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG5_0_DRAM_TYPE_RANGE        5:4
#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG5_0_DRAM_TYPE_SHIFT        _MK_SHIFT_CONST(4)
#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG5_0_DRAM_TYPE_DEFAULT_MASK _MK_MASK_CONST(0x00000003)

#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG5_0_DRAM_WIDTH_RANGE        6:6
#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG5_0_DRAM_WIDTH_SHIFT        _MK_SHIFT_CONST(6)
#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG5_0_DRAM_WIDTH_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG5_0_DIFFERENTIAL_DQS_RANGE        7:7
#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG5_0_DIFFERENTIAL_DQS_SHIFT        _MK_SHIFT_CONST(7)
#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG5_0_DIFFERENTIAL_DQS_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG5_0_CTT_TERMINATION_RANGE        8:8
#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG5_0_CTT_TERMINATION_SHIFT        _MK_SHIFT_CONST(8)
#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG5_0_CTT_TERMINATION_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH15_0_EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_RANGE        13:9
#define APBDEV_PMC_SCRATCH15_0_EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_SHIFT        _MK_SHIFT_CONST(9)
#define APBDEV_PMC_SCRATCH15_0_EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH15_0_EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_RANGE        18:14
#define APBDEV_PMC_SCRATCH15_0_EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_SHIFT        _MK_SHIFT_CONST(14)
#define APBDEV_PMC_SCRATCH15_0_EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH15_0_EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_RANGE        28:19
#define APBDEV_PMC_SCRATCH15_0_EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_SHIFT        _MK_SHIFT_CONST(19)
#define APBDEV_PMC_SCRATCH15_0_EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_DEFAULT_MASK _MK_MASK_CONST(0x000003FF)

#define APBDEV_PMC_SCRATCH15_0_EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_ENABLE_RANGE        29:29
#define APBDEV_PMC_SCRATCH15_0_EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_ENABLE_SHIFT        _MK_SHIFT_CONST(29)
#define APBDEV_PMC_SCRATCH15_0_EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_ENABLE_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH15_0_EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_RANGE        30:30
#define APBDEV_PMC_SCRATCH15_0_EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_SHIFT        _MK_SHIFT_CONST(30)
#define APBDEV_PMC_SCRATCH15_0_EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG5_0_DQS_PULLD_RANGE        31:31
#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG5_0_DQS_PULLD_SHIFT        _MK_SHIFT_CONST(31)
#define APBDEV_PMC_SCRATCH15_0_EMC_FBIO_CFG5_0_DQS_PULLD_DEFAULT_MASK _MK_MASK_CONST(0x00000001)


#define APBDEV_PMC_SCRATCH16_0_EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_RANGE        27:0
#define APBDEV_PMC_SCRATCH16_0_EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH16_0_EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_DEFAULT_MASK _MK_MASK_CONST(0x0FFFFFFF)

#define APBDEV_PMC_SCRATCH16_0_EMC_CFG_2_0_CLKCHANGE_REQ_ENABLE_RANGE        28:28
#define APBDEV_PMC_SCRATCH16_0_EMC_CFG_2_0_CLKCHANGE_REQ_ENABLE_SHIFT        _MK_SHIFT_CONST(28)
#define APBDEV_PMC_SCRATCH16_0_EMC_CFG_2_0_CLKCHANGE_REQ_ENABLE_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH16_0_EMC_CFG_2_0_CLKCHANGE_PD_ENABLE_RANGE        29:29
#define APBDEV_PMC_SCRATCH16_0_EMC_CFG_2_0_CLKCHANGE_PD_ENABLE_SHIFT        _MK_SHIFT_CONST(29)
#define APBDEV_PMC_SCRATCH16_0_EMC_CFG_2_0_CLKCHANGE_PD_ENABLE_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH16_0_EMC_CFG_2_0_PIN_CONFIG_RANGE        31:30
#define APBDEV_PMC_SCRATCH16_0_EMC_CFG_2_0_PIN_CONFIG_SHIFT        _MK_SHIFT_CONST(30)
#define APBDEV_PMC_SCRATCH16_0_EMC_CFG_2_0_PIN_CONFIG_DEFAULT_MASK _MK_MASK_CONST(0x00000003)


#define APBDEV_PMC_SCRATCH17_0_EMC_ADR_CFG_0_EMEM_COLWIDTH_RANGE        2:0
#define APBDEV_PMC_SCRATCH17_0_EMC_ADR_CFG_0_EMEM_COLWIDTH_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH17_0_EMC_ADR_CFG_0_EMEM_COLWIDTH_DEFAULT_MASK _MK_MASK_CONST(0x00000007)

#define APBDEV_PMC_SCRATCH17_0_EMC_ADR_CFG_0_EMEM_BANKWIDTH_RANGE        4:3
#define APBDEV_PMC_SCRATCH17_0_EMC_ADR_CFG_0_EMEM_BANKWIDTH_SHIFT        _MK_SHIFT_CONST(3)
#define APBDEV_PMC_SCRATCH17_0_EMC_ADR_CFG_0_EMEM_BANKWIDTH_DEFAULT_MASK _MK_MASK_CONST(0x00000003)

#define APBDEV_PMC_SCRATCH17_0_EMC_ADR_CFG_0_EMEM_DEVSIZE_RANGE        8:5
#define APBDEV_PMC_SCRATCH17_0_EMC_ADR_CFG_0_EMEM_DEVSIZE_SHIFT        _MK_SHIFT_CONST(5)
#define APBDEV_PMC_SCRATCH17_0_EMC_ADR_CFG_0_EMEM_DEVSIZE_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH17_0_EMC_ADR_CFG_0_EMEM_NUMDEV_RANGE        10:9
#define APBDEV_PMC_SCRATCH17_0_EMC_ADR_CFG_0_EMEM_NUMDEV_SHIFT        _MK_SHIFT_CONST(9)
#define APBDEV_PMC_SCRATCH17_0_EMC_ADR_CFG_0_EMEM_NUMDEV_DEFAULT_MASK _MK_MASK_CONST(0x00000003)

#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_PRE_IDLE_EN_RANGE        11:11
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_PRE_IDLE_EN_SHIFT        _MK_SHIFT_CONST(11)
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_PRE_IDLE_EN_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_PRE_IDLE_CYCLES_RANGE        19:12
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_PRE_IDLE_CYCLES_SHIFT        _MK_SHIFT_CONST(12)
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_PRE_IDLE_CYCLES_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)

#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_CLEAR_AP_PREV_SPREQ_RANGE        20:20
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_CLEAR_AP_PREV_SPREQ_SHIFT        _MK_SHIFT_CONST(20)
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_CLEAR_AP_PREV_SPREQ_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_AUTO_PRE_RD_RANGE        21:21
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_AUTO_PRE_RD_SHIFT        _MK_SHIFT_CONST(21)
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_AUTO_PRE_RD_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_AUTO_PRE_WR_RANGE        22:22
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_AUTO_PRE_WR_SHIFT        _MK_SHIFT_CONST(22)
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_AUTO_PRE_WR_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_DRAM_ACPD_RANGE        23:23
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_DRAM_ACPD_SHIFT        _MK_SHIFT_CONST(23)
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_DRAM_ACPD_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_DRAM_CLKSTOP_PDSR_ONLY_RANGE        24:24
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_DRAM_CLKSTOP_PDSR_ONLY_SHIFT        _MK_SHIFT_CONST(24)
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_DRAM_CLKSTOP_PDSR_ONLY_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_DRAM_CLKSTOP_RANGE        25:25
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_DRAM_CLKSTOP_SHIFT        _MK_SHIFT_CONST(25)
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_0_DRAM_CLKSTOP_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH17_0_MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_RANGE        26:26
#define APBDEV_PMC_SCRATCH17_0_MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_SHIFT        _MK_SHIFT_CONST(26)
#define APBDEV_PMC_SCRATCH17_0_MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH17_0_MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_RANGE        27:27
#define APBDEV_PMC_SCRATCH17_0_MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_SHIFT        _MK_SHIFT_CONST(27)
#define APBDEV_PMC_SCRATCH17_0_MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_DIG_DLL_0_CFG_DLL_LOCK_LIMIT_RANGE        29:28
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_DIG_DLL_0_CFG_DLL_LOCK_LIMIT_SHIFT        _MK_SHIFT_CONST(28)
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_DIG_DLL_0_CFG_DLL_LOCK_LIMIT_DEFAULT_MASK _MK_MASK_CONST(0x00000003)

#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_RANGE        31:30
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_SHIFT        _MK_SHIFT_CONST(30)
#define APBDEV_PMC_SCRATCH17_0_EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_DEFAULT_MASK _MK_MASK_CONST(0x00000003)


#define APBDEV_PMC_SCRATCH18_0_EMC_CTT_TERM_CTRL_0_TERM_DRVUP_RANGE        4:0
#define APBDEV_PMC_SCRATCH18_0_EMC_CTT_TERM_CTRL_0_TERM_DRVUP_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH18_0_EMC_CTT_TERM_CTRL_0_TERM_DRVUP_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH18_0_EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_RANGE        7:5
#define APBDEV_PMC_SCRATCH18_0_EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_SHIFT        _MK_SHIFT_CONST(5)
#define APBDEV_PMC_SCRATCH18_0_EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_DEFAULT_MASK _MK_MASK_CONST(0x00000007)

#define APBDEV_PMC_SCRATCH18_0_EMC_ADR_CFG_1_0_EMEM1_BANKWIDTH_RANGE        9:8
#define APBDEV_PMC_SCRATCH18_0_EMC_ADR_CFG_1_0_EMEM1_BANKWIDTH_SHIFT        _MK_SHIFT_CONST(8)
#define APBDEV_PMC_SCRATCH18_0_EMC_ADR_CFG_1_0_EMEM1_BANKWIDTH_DEFAULT_MASK _MK_MASK_CONST(0x00000003)

#define APBDEV_PMC_SCRATCH18_0_EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_RANGE        13:10
#define APBDEV_PMC_SCRATCH18_0_EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_SHIFT        _MK_SHIFT_CONST(10)
#define APBDEV_PMC_SCRATCH18_0_EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2COMPPADCTRL_0_CFG2TMC_XM2COMP_VREF_SEL_RANGE        17:14
#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2COMPPADCTRL_0_CFG2TMC_XM2COMP_VREF_SEL_SHIFT        _MK_SHIFT_CONST(14)
#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2COMPPADCTRL_0_CFG2TMC_XM2COMP_VREF_SEL_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)

#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_CAL_DRVUP_RANGE        20:18
#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_CAL_DRVUP_SHIFT        _MK_SHIFT_CONST(18)
#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_CAL_DRVUP_DEFAULT_MASK _MK_MASK_CONST(0x00000007)

#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_CAL_DRVDN_RANGE        23:21
#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_CAL_DRVDN_SHIFT        _MK_SHIFT_CONST(21)
#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_CAL_DRVDN_DEFAULT_MASK _MK_MASK_CONST(0x00000007)

#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_VAUXP_LEVEL_RANGE        26:24
#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_VAUXP_LEVEL_SHIFT        _MK_SHIFT_CONST(24)
#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_VAUXP_LEVEL_DEFAULT_MASK _MK_MASK_CONST(0x00000007)

#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_VCLAMP_LEVEL_RANGE        29:27
#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_VCLAMP_LEVEL_SHIFT        _MK_SHIFT_CONST(27)
#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_VCLAMP_LEVEL_DEFAULT_MASK _MK_MASK_CONST(0x00000007)

#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_SHORT_PWRGND_RANGE        30:30
#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_SHORT_PWRGND_SHIFT        _MK_SHIFT_CONST(30)
#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_SHORT_PWRGND_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_SHORT_RANGE        31:31
#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_SHORT_SHIFT        _MK_SHIFT_CONST(31)
#define APBDEV_PMC_SCRATCH18_0_APB_MISC_GP_XM2VTTGENPADCTRL_0_CFG2TMC_XM2VTTGEN_SHORT_DEFAULT_MASK _MK_MASK_CONST(0x00000001)


#define APBDEV_PMC_SCRATCH19_0_MC_EMEM_CFG_0_EMEM_SIZE_KB_RANGE        21:0
#define APBDEV_PMC_SCRATCH19_0_MC_EMEM_CFG_0_EMEM_SIZE_KB_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH19_0_MC_EMEM_CFG_0_EMEM_SIZE_KB_DEFAULT_MASK _MK_MASK_CONST(0x003FFFFF)

#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_DLL_EN_RANGE        22:22
#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_DLL_EN_SHIFT        _MK_SHIFT_CONST(22)
#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_DLL_EN_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_DLI_TRIMMER_EN_RANGE        23:23
#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_DLI_TRIMMER_EN_SHIFT        _MK_SHIFT_CONST(23)
#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_DLI_TRIMMER_EN_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_EN_RANGE        24:24
#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_EN_SHIFT        _MK_SHIFT_CONST(24)
#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_EN_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_USE_SINGLE_DLL_RANGE        25:25
#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_USE_SINGLE_DLL_SHIFT        _MK_SHIFT_CONST(25)
#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_USE_SINGLE_DLL_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_PERBYTE_TRIMMER_OVERRIDE_RANGE        26:26
#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_PERBYTE_TRIMMER_OVERRIDE_SHIFT        _MK_SHIFT_CONST(26)
#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_PERBYTE_TRIMMER_OVERRIDE_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_DLL_LOWSPEED_RANGE        27:27
#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_DLL_LOWSPEED_SHIFT        _MK_SHIFT_CONST(27)
#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_DLL_LOWSPEED_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_DLL_UDSET_RANGE        31:28
#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_DLL_UDSET_SHIFT        _MK_SHIFT_CONST(28)
#define APBDEV_PMC_SCRATCH19_0_EMC_CFG_DIG_DLL_0_CFG_DLL_UDSET_DEFAULT_MASK _MK_MASK_CONST(0x0000000F)


#define APBDEV_PMC_SCRATCH20_0_EMC_CFG_CLKTRIM_1_0_CFG_DQS0_CLKTRIM_RANGE        5:0
#define APBDEV_PMC_SCRATCH20_0_EMC_CFG_CLKTRIM_1_0_CFG_DQS0_CLKTRIM_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH20_0_EMC_CFG_CLKTRIM_1_0_CFG_DQS0_CLKTRIM_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH20_0_EMC_CFG_CLKTRIM_1_0_CFG_DQS1_CLKTRIM_RANGE        11:6
#define APBDEV_PMC_SCRATCH20_0_EMC_CFG_CLKTRIM_1_0_CFG_DQS1_CLKTRIM_SHIFT        _MK_SHIFT_CONST(6)
#define APBDEV_PMC_SCRATCH20_0_EMC_CFG_CLKTRIM_1_0_CFG_DQS1_CLKTRIM_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH20_0_EMC_CFG_CLKTRIM_1_0_CFG_DQS2_CLKTRIM_RANGE        17:12
#define APBDEV_PMC_SCRATCH20_0_EMC_CFG_CLKTRIM_1_0_CFG_DQS2_CLKTRIM_SHIFT        _MK_SHIFT_CONST(12)
#define APBDEV_PMC_SCRATCH20_0_EMC_CFG_CLKTRIM_1_0_CFG_DQS2_CLKTRIM_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH20_0_EMC_CFG_CLKTRIM_1_0_CFG_DQS3_CLKTRIM_RANGE        23:18
#define APBDEV_PMC_SCRATCH20_0_EMC_CFG_CLKTRIM_1_0_CFG_DQS3_CLKTRIM_SHIFT        _MK_SHIFT_CONST(18)
#define APBDEV_PMC_SCRATCH20_0_EMC_CFG_CLKTRIM_1_0_CFG_DQS3_CLKTRIM_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH20_0_EMC_CFG_CLKTRIM_1_0_CFG_MCLK_CLKTRIM_RANGE        29:24
#define APBDEV_PMC_SCRATCH20_0_EMC_CFG_CLKTRIM_1_0_CFG_MCLK_CLKTRIM_SHIFT        _MK_SHIFT_CONST(24)
#define APBDEV_PMC_SCRATCH20_0_EMC_CFG_CLKTRIM_1_0_CFG_MCLK_CLKTRIM_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH20_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_VREF_DQS_EN_RANGE        30:30
#define APBDEV_PMC_SCRATCH20_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_VREF_DQS_EN_SHIFT        _MK_SHIFT_CONST(30)
#define APBDEV_PMC_SCRATCH20_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_VREF_DQS_EN_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH20_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_CTT_HIZ_EN_RANGE        31:31
#define APBDEV_PMC_SCRATCH20_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_CTT_HIZ_EN_SHIFT        _MK_SHIFT_CONST(31)
#define APBDEV_PMC_SCRATCH20_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_CTT_HIZ_EN_DEFAULT_MASK _MK_MASK_CONST(0x00000001)


#define APBDEV_PMC_SCRATCH21_0_EMC_CFG_CLKTRIM_2_0_CFG_DQ0_CLKTRIM_RANGE        5:0
#define APBDEV_PMC_SCRATCH21_0_EMC_CFG_CLKTRIM_2_0_CFG_DQ0_CLKTRIM_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH21_0_EMC_CFG_CLKTRIM_2_0_CFG_DQ0_CLKTRIM_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH21_0_EMC_CFG_CLKTRIM_2_0_CFG_DQ1_CLKTRIM_RANGE        11:6
#define APBDEV_PMC_SCRATCH21_0_EMC_CFG_CLKTRIM_2_0_CFG_DQ1_CLKTRIM_SHIFT        _MK_SHIFT_CONST(6)
#define APBDEV_PMC_SCRATCH21_0_EMC_CFG_CLKTRIM_2_0_CFG_DQ1_CLKTRIM_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH21_0_EMC_CFG_CLKTRIM_2_0_CFG_DQ2_CLKTRIM_RANGE        17:12
#define APBDEV_PMC_SCRATCH21_0_EMC_CFG_CLKTRIM_2_0_CFG_DQ2_CLKTRIM_SHIFT        _MK_SHIFT_CONST(12)
#define APBDEV_PMC_SCRATCH21_0_EMC_CFG_CLKTRIM_2_0_CFG_DQ2_CLKTRIM_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH21_0_EMC_CFG_CLKTRIM_2_0_CFG_DQ3_CLKTRIM_RANGE        23:18
#define APBDEV_PMC_SCRATCH21_0_EMC_CFG_CLKTRIM_2_0_CFG_DQ3_CLKTRIM_SHIFT        _MK_SHIFT_CONST(18)
#define APBDEV_PMC_SCRATCH21_0_EMC_CFG_CLKTRIM_2_0_CFG_DQ3_CLKTRIM_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH21_0_EMC_CFG_CLKTRIM_2_0_CFG_CMD_CLKTRIM_RANGE        29:24
#define APBDEV_PMC_SCRATCH21_0_EMC_CFG_CLKTRIM_2_0_CFG_CMD_CLKTRIM_SHIFT        _MK_SHIFT_CONST(24)
#define APBDEV_PMC_SCRATCH21_0_EMC_CFG_CLKTRIM_2_0_CFG_CMD_CLKTRIM_DEFAULT_MASK _MK_MASK_CONST(0x0000003F)

#define APBDEV_PMC_SCRATCH21_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_PREEMP_EN_RANGE        30:30
#define APBDEV_PMC_SCRATCH21_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_PREEMP_EN_SHIFT        _MK_SHIFT_CONST(30)
#define APBDEV_PMC_SCRATCH21_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_PREEMP_EN_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH21_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_RX_FT_REC_EN_RANGE        31:31
#define APBDEV_PMC_SCRATCH21_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_RX_FT_REC_EN_SHIFT        _MK_SHIFT_CONST(31)
#define APBDEV_PMC_SCRATCH21_0_APB_MISC_GP_XM2CFGCPADCTRL2_0_CFG2TMC_XM2CFGC_RX_FT_REC_EN_DEFAULT_MASK _MK_MASK_CONST(0x00000001)


// Note: 1 bit reserved
#define APBDEV_PMC_SCRATCH22_0_EMC_DLL_XFORM_DQS_0_XFORM_DQS_MULT_RANGE        4:0
#define APBDEV_PMC_SCRATCH22_0_EMC_DLL_XFORM_DQS_0_XFORM_DQS_MULT_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH22_0_EMC_DLL_XFORM_DQS_0_XFORM_DQS_MULT_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH22_0_EMC_DLL_XFORM_DQS_0_XFORM_DQS_OFFS_RANGE        19:5
#define APBDEV_PMC_SCRATCH22_0_EMC_DLL_XFORM_DQS_0_XFORM_DQS_OFFS_SHIFT        _MK_SHIFT_CONST(5)
#define APBDEV_PMC_SCRATCH22_0_EMC_DLL_XFORM_DQS_0_XFORM_DQS_OFFS_DEFAULT_MASK _MK_MASK_CONST(0x00007FFF)

#define APBDEV_PMC_SCRATCH22_0_EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_VAL_RANGE        29:20
#define APBDEV_PMC_SCRATCH22_0_EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_VAL_SHIFT        _MK_SHIFT_CONST(20)
#define APBDEV_PMC_SCRATCH22_0_EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_VAL_DEFAULT_MASK _MK_MASK_CONST(0x000003FF)

#define APBDEV_PMC_SCRATCH22_0_MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_RANGE        30:30
#define APBDEV_PMC_SCRATCH22_0_MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_SHIFT        _MK_SHIFT_CONST(30)
#define APBDEV_PMC_SCRATCH22_0_MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_DEFAULT_MASK _MK_MASK_CONST(0x00000001)


// Note: 2 bits reserved
#define APBDEV_PMC_SCRATCH23_0_EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_MULT_RANGE        4:0
#define APBDEV_PMC_SCRATCH23_0_EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_MULT_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH23_0_EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_MULT_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH23_0_EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_OFFS_RANGE        19:5
#define APBDEV_PMC_SCRATCH23_0_EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_OFFS_SHIFT        _MK_SHIFT_CONST(5)
#define APBDEV_PMC_SCRATCH23_0_EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_OFFS_DEFAULT_MASK _MK_MASK_CONST(0x00007FFF)

#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_WRITE_0_ODT_WR_DELAY_RANGE        22:20
#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_WRITE_0_ODT_WR_DELAY_SHIFT        _MK_SHIFT_CONST(20)
#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_WRITE_0_ODT_WR_DELAY_DEFAULT_MASK _MK_MASK_CONST(0x00000007)

#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_WRITE_0_ODT_B4_WRITE_RANGE        23:23
#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_WRITE_0_ODT_B4_WRITE_SHIFT        _MK_SHIFT_CONST(23)
#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_WRITE_0_ODT_B4_WRITE_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_WRITE_0_ENABLE_ODT_DURING_WRITE_RANGE        24:24
#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_WRITE_0_ENABLE_ODT_DURING_WRITE_SHIFT        _MK_SHIFT_CONST(24)
#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_WRITE_0_ENABLE_ODT_DURING_WRITE_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_READ_0_ODT_RD_DELAY_RANGE        27:25
#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_READ_0_ODT_RD_DELAY_SHIFT        _MK_SHIFT_CONST(25)
#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_READ_0_ODT_RD_DELAY_DEFAULT_MASK _MK_MASK_CONST(0x00000007)

#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_READ_0_ODT_B4_READ_RANGE        28:28
#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_READ_0_ODT_B4_READ_SHIFT        _MK_SHIFT_CONST(28)
#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_READ_0_ODT_B4_READ_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_READ_0_DISABLE_ODT_DURING_READ_RANGE        29:29
#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_READ_0_DISABLE_ODT_DURING_READ_SHIFT        _MK_SHIFT_CONST(29)
#define APBDEV_PMC_SCRATCH23_0_EMC_ODT_READ_0_DISABLE_ODT_DURING_READ_DEFAULT_MASK _MK_MASK_CONST(0x00000001)


/**
 * AHB_ARBITRATION_XBAR_CTRL:
 *  Source: SDRAM[n].AhbArbitrationXbarCtrl
 *  Dest: AHB_ARBITRATION_XBAR_CTRL
 *  Desc: Note: Only bits 0, 1, and 16 are actually used in this scratch
 *    register. However, the Boot ROM copies the entire 32 bits to
 *    AHB_ARBITRATION_XBAR_CTRL.  The 3 single-bit definitions are provided
 *    for convenience/reference.
 */
#define APBDEV_PMC_SCRATCH25_0_AHB_ARBITRATION_XBAR_CTRL_0_POST_DIS_RANGE        0:0
#define APBDEV_PMC_SCRATCH25_0_AHB_ARBITRATION_XBAR_CTRL_0_POST_DIS_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH25_0_AHB_ARBITRATION_XBAR_CTRL_0_POST_DIS_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH25_0_AHB_ARBITRATION_XBAR_CTRL_0_HOLD_DIS_RANGE        1:1
#define APBDEV_PMC_SCRATCH25_0_AHB_ARBITRATION_XBAR_CTRL_0_HOLD_DIS_SHIFT        _MK_SHIFT_CONST(1)
#define APBDEV_PMC_SCRATCH25_0_AHB_ARBITRATION_XBAR_CTRL_0_HOLD_DIS_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH25_0_AHB_ARBITRATION_XBAR_CTRL_0_MEM_INIT_DONE_RANGE        16:16
#define APBDEV_PMC_SCRATCH25_0_AHB_ARBITRATION_XBAR_CTRL_0_MEM_INIT_DONE_SHIFT        _MK_SHIFT_CONST(16)
#define APBDEV_PMC_SCRATCH25_0_AHB_ARBITRATION_XBAR_CTRL_0_MEM_INIT_DONE_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH25_0_AHB_ARBITRATION_XBAR_CTRL_RANGE        31:0
#define APBDEV_PMC_SCRATCH25_0_AHB_ARBITRATION_XBAR_CTRL_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH25_0_AHB_ARBITRATION_XBAR_CTRL_DEFAULT_MASK _MK_MASK_CONST(0xFFFFFFFF)

#define APBDEV_PMC_SCRATCH35_0_EMC_ZCAL_REF_CNT_0_ZCAL_REF_INTERVAL_RANGE        23:0
#define APBDEV_PMC_SCRATCH35_0_EMC_ZCAL_REF_CNT_0_ZCAL_REF_INTERVAL_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH35_0_EMC_ZCAL_REF_CNT_0_ZCAL_REF_INTERVAL_DEFAULT_MASK _MK_MASK_CONST(0x00FFFFFF)

#define APBDEV_PMC_SCRATCH35_0_EMC_ZCAL_WAIT_CNT_0_ZCAL_WAIT_CNT_RANGE        31:24
#define APBDEV_PMC_SCRATCH35_0_EMC_ZCAL_WAIT_CNT_0_ZCAL_WAIT_CNT_SHIFT        _MK_SHIFT_CONST(24)
#define APBDEV_PMC_SCRATCH35_0_EMC_ZCAL_WAIT_CNT_0_ZCAL_WAIT_CNT_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)


// Note: 2 bits are reserved.
#define APBDEV_PMC_SCRATCH36_0_EMC_ZCAL_MRW_CMD_0_ZQ_MRW_OP_RANGE        7:0
#define APBDEV_PMC_SCRATCH36_0_EMC_ZCAL_MRW_CMD_0_ZQ_MRW_OP_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH36_0_EMC_ZCAL_MRW_CMD_0_ZQ_MRW_OP_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)

#define APBDEV_PMC_SCRATCH36_0_EMC_ZCAL_MRW_CMD_0_ZQ_MRW_MA_RANGE        15:8
#define APBDEV_PMC_SCRATCH36_0_EMC_ZCAL_MRW_CMD_0_ZQ_MRW_MA_SHIFT        _MK_SHIFT_CONST(8)
#define APBDEV_PMC_SCRATCH36_0_EMC_ZCAL_MRW_CMD_0_ZQ_MRW_MA_DEFAULT_MASK _MK_MASK_CONST(0x000000FF)

// bits [17:16] reserved
#define APBDEV_PMC_SCRATCH36_0_EMC_CTT_TERM_CTRL_0_TERM_SLOPE_RANGE        20:18
#define APBDEV_PMC_SCRATCH36_0_EMC_CTT_TERM_CTRL_0_TERM_SLOPE_SHIFT        _MK_SHIFT_CONST(18)
#define APBDEV_PMC_SCRATCH36_0_EMC_CTT_TERM_CTRL_0_TERM_SLOPE_DEFAULT_MASK _MK_MASK_CONST(0x00000007)

#define APBDEV_PMC_SCRATCH36_0_EMC_CTT_TERM_CTRL_0_TERM_OFFSET_RANGE        25:21
#define APBDEV_PMC_SCRATCH36_0_EMC_CTT_TERM_CTRL_0_TERM_OFFSET_SHIFT        _MK_SHIFT_CONST(21)
#define APBDEV_PMC_SCRATCH36_0_EMC_CTT_TERM_CTRL_0_TERM_OFFSET_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH36_0_EMC_CTT_TERM_CTRL_0_TERM_DRVDN_RANGE        30:26
#define APBDEV_PMC_SCRATCH36_0_EMC_CTT_TERM_CTRL_0_TERM_DRVDN_SHIFT        _MK_SHIFT_CONST(26)
#define APBDEV_PMC_SCRATCH36_0_EMC_CTT_TERM_CTRL_0_TERM_DRVDN_DEFAULT_MASK _MK_MASK_CONST(0x0000001F)

#define APBDEV_PMC_SCRATCH36_0_EMC_CTT_TERM_CTRL_0_TERM_OVERRIDE_RANGE        31:31
#define APBDEV_PMC_SCRATCH36_0_EMC_CTT_TERM_CTRL_0_TERM_OVERRIDE_SHIFT        _MK_SHIFT_CONST(31)
#define APBDEV_PMC_SCRATCH36_0_EMC_CTT_TERM_CTRL_0_TERM_OVERRIDE_DEFAULT_MASK _MK_MASK_CONST(0x00000001)


// Scratch registers 37, 38, and 39 are reserved for SW.

// The last three scratch registers are reseved for HW ECO's.
#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD3_DLYIN_TRM_RANGE        2:0
#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD3_DLYIN_TRM_SHIFT        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD3_DLYIN_TRM_DEFAULT_MASK _MK_MASK_CONST(0x00000007)

#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD2_DLYIN_TRM_RANGE        5:3
#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD2_DLYIN_TRM_SHIFT        _MK_SHIFT_CONST(3)
#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD2_DLYIN_TRM_DEFAULT_MASK _MK_MASK_CONST(0x00000007)

#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD1_DLYIN_TRM_RANGE        8:6
#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD1_DLYIN_TRM_SHIFT        _MK_SHIFT_CONST(6)
#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD1_DLYIN_TRM_DEFAULT_MASK _MK_MASK_CONST(0x00000007)

#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD0_DLYIN_TRM_RANGE        11:9
#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD0_DLYIN_TRM_SHIFT        _MK_SHIFT_CONST(9)
#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD0_DLYIN_TRM_DEFAULT_MASK _MK_MASK_CONST(0x00000007)

#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD_CTT_HIZ_EN_RANGE        12:12
#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD_CTT_HIZ_EN_SHIFT        _MK_SHIFT_CONST(12)
#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD_CTT_HIZ_EN_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD_PREEMP_EN_RANGE        13:13
#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD_PREEMP_EN_SHIFT        _MK_SHIFT_CONST(13)
#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD_PREEMP_EN_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD_RX_FT_REC_EN_RANGE        14:14
#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD_RX_FT_REC_EN_SHIFT        _MK_SHIFT_CONST(14)
#define APBDEV_PMC_SCRATCH40_0_APB_MISC_GP_XM2CFGDPADCTRL2_0_CFG2TMC_XM2CFGD_RX_FT_REC_EN_DEFAULT_MASK _MK_MASK_CONST(0x00000001)

#endif // INCLUDED_NVBOOT_APBDEV_PMC_SCRATCH_MAP_H
