########################################
# arm-specific definitions

#
# If you change any of these configuration options then you must
# 'make clean' before rebuilding.
#

CFLAGS-$(CONFIG_EABI_SUPPORT)		+= -mabi=aapcs-linux -mno-thumb-interwork

CFLAGS-$(CONFIG_CPU_ISA_V4)		+= -march=armv4
CFLAGS-$(CONFIG_CPU_ISA_V4T)		+= -march=armv4t
CFLAGS-$(CONFIG_CPU_ISA_V5)		+= $(call cc-option,$(CC),-march=armv5te,-march=armv4t)
CFLAGS-$(CONFIG_CPU_ISA_V6)		+= $(call cc-option,$(CC),-march=armv6,-march=armv5t -Wa$(commma)-march=armv6)
CFLAGS-$(CONFIG_CPU_ISA_V6K)		+= $(call cc-option,$(CC),-march=armv6k,-march=armv5t -Wa$(commma)-march=armv6k)
CFLAGS-$(CONFIG_CPU_ISA_V7)		+= $(call cc-option,$(CC),-march=armv7-a,-march=armv5t -Wa$(comma)-march=armv7-a)

CFLAGS-$(CONFIG_CPU_CORE_ARM920T)	+= -mtune=arm9tdmi
CFLAGS-$(CONFIG_CPU_CORE_ARM926T)	+= -mtune=arm9tdmi
CFLAGS-$(CONFIG_CPU_CORE_ARM1136)	+= $(call cc-option,$(CC),-mtune=arm1136j-s,-mtune=strongarm)
CFLAGS-$(CONFIG_CPU_CORE_ARM11MP)	+= $(call cc-option,$(CC),-mtune=arm1136j-s,-mtune=strongarm)
CFLAGS-$(CONFIG_CPU_CORE_XSCALE3)	+= $(call cc-option,$(CC),-mtune=xscale,-mtune=strongarm110) -Wa,-mcpu=iwmmxt

CFLAGS  += -nostdinc -fno-builtin -fno-common -fno-strict-aliasing -mno-thumb-interwork
CFLAGS  += -iwithprefix include -Wno-pointer-arith -pipe
CFLAGS  += -I$(BASEDIR)/include -I$(BASEDIR)/include/security -I$(BASEDIR)/include/security/crypto
CFLAGS	+= $(CFLAGS-y)

processor-$(CONFIG_PROCESSOR_IMX21)	:= imx21
processor-$(CONFIG_PROCESSOR_PXA310)	:= xscale
processor-$(CONFIG_PROCESSOR_OMAP5912)	:= omap
processor-$(CONFIG_PROCESSOR_REALVIEW)	:= realview
processor-$(CONFIG_PROCESSOR_AP20)	:= ap20
processor-$(CONFIG_PROCESSOR_TEGRA)	:= tegra

TARGET_PROCESSOR := $(processor-y)

# Test for at least GCC v3.2.x.
gcc-ver = $(shell $(CC) -dumpversion | sed -e 's/^\(.\)\.\(.\)\.\(.\)/\$(1)/')

ifeq ($(call gcc-ver,1),1)
$(error gcc-1.x.x unsupported - upgrade to at least gcc-3.2.x)
endif
ifeq ($(call gcc-ver,1),2)
$(error gcc-2.x.x unsupported - upgrade to at least gcc-3.2.x)
endif
ifeq ($(call gcc-ver,1),3)
ifeq ($(call gcc-ver,2),0)
$(error gcc-3.0.x unsupported - upgrade to at least gcc-3.2.x)
endif
ifeq ($(call gcc-ver,2),1)
$(error gcc-3.1.x unsupported - upgrade to at least gcc-3.2.x)
endif
endif


