/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARAHB_ARBC_H_INC_
#define ___ARAHB_ARBC_H_INC_

// Register AHB_ARBITRATION_DISABLE_0  
#define AHB_ARBITRATION_DISABLE_0                       _MK_ADDR_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_WORD_COUNT                    0x1
#define AHB_ARBITRATION_DISABLE_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_RESET_MASK                    _MK_MASK_CONST(0x800937f7)
#define AHB_ARBITRATION_DISABLE_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_READ_MASK                     _MK_MASK_CONST(0x800937f7)
#define AHB_ARBITRATION_DISABLE_0_WRITE_MASK                    _MK_MASK_CONST(0x800937f7)
//  1 = disable bus parking.
#define AHB_ARBITRATION_DISABLE_0_DIS_BUS_PARK_SHIFT                    _MK_SHIFT_CONST(31)
#define AHB_ARBITRATION_DISABLE_0_DIS_BUS_PARK_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_DISABLE_0_DIS_BUS_PARK_SHIFT)
#define AHB_ARBITRATION_DISABLE_0_DIS_BUS_PARK_RANGE                    31:31
#define AHB_ARBITRATION_DISABLE_0_DIS_BUS_PARK_WOFFSET                  0x0
#define AHB_ARBITRATION_DISABLE_0_DIS_BUS_PARK_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_DIS_BUS_PARK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_DISABLE_0_DIS_BUS_PARK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_DIS_BUS_PARK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_DIS_BUS_PARK_ENABLE                   _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_DISABLE_0_DIS_BUS_PARK_DISABLE                  _MK_ENUM_CONST(1)

//  1 = disable SDIO2 from arbitration.
#define AHB_ARBITRATION_DISABLE_0_SDIO2_SHIFT                   _MK_SHIFT_CONST(19)
#define AHB_ARBITRATION_DISABLE_0_SDIO2_FIELD                   (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_DISABLE_0_SDIO2_SHIFT)
#define AHB_ARBITRATION_DISABLE_0_SDIO2_RANGE                   19:19
#define AHB_ARBITRATION_DISABLE_0_SDIO2_WOFFSET                 0x0
#define AHB_ARBITRATION_DISABLE_0_SDIO2_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_SDIO2_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_DISABLE_0_SDIO2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_SDIO2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_SDIO2_ENABLE                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_DISABLE_0_SDIO2_DISABLE                 _MK_ENUM_CONST(1)

//  1 = disable BSEA from arbitration.
#define AHB_ARBITRATION_DISABLE_0_BSEA_SHIFT                    _MK_SHIFT_CONST(16)
#define AHB_ARBITRATION_DISABLE_0_BSEA_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_DISABLE_0_BSEA_SHIFT)
#define AHB_ARBITRATION_DISABLE_0_BSEA_RANGE                    16:16
#define AHB_ARBITRATION_DISABLE_0_BSEA_WOFFSET                  0x0
#define AHB_ARBITRATION_DISABLE_0_BSEA_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_BSEA_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_DISABLE_0_BSEA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_BSEA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_BSEA_ENABLE                   _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_DISABLE_0_BSEA_DISABLE                  _MK_ENUM_CONST(1)

//  1 = disable BSEV from arbitration.
#define AHB_ARBITRATION_DISABLE_0_BSEV_SHIFT                    _MK_SHIFT_CONST(13)
#define AHB_ARBITRATION_DISABLE_0_BSEV_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_DISABLE_0_BSEV_SHIFT)
#define AHB_ARBITRATION_DISABLE_0_BSEV_RANGE                    13:13
#define AHB_ARBITRATION_DISABLE_0_BSEV_WOFFSET                  0x0
#define AHB_ARBITRATION_DISABLE_0_BSEV_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_BSEV_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_DISABLE_0_BSEV_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_BSEV_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_BSEV_ENABLE                   _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_DISABLE_0_BSEV_DISABLE                  _MK_ENUM_CONST(1)

//  1 = disable HSMMC1 from arbitration.
#define AHB_ARBITRATION_DISABLE_0_HSMMC1_SHIFT                  _MK_SHIFT_CONST(12)
#define AHB_ARBITRATION_DISABLE_0_HSMMC1_FIELD                  (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_DISABLE_0_HSMMC1_SHIFT)
#define AHB_ARBITRATION_DISABLE_0_HSMMC1_RANGE                  12:12
#define AHB_ARBITRATION_DISABLE_0_HSMMC1_WOFFSET                        0x0
#define AHB_ARBITRATION_DISABLE_0_HSMMC1_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_HSMMC1_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_DISABLE_0_HSMMC1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_HSMMC1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_HSMMC1_ENABLE                 _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_DISABLE_0_HSMMC1_DISABLE                        _MK_ENUM_CONST(1)

//  1 = disable NAND from arbitration.
#define AHB_ARBITRATION_DISABLE_0_NAND_SHIFT                    _MK_SHIFT_CONST(10)
#define AHB_ARBITRATION_DISABLE_0_NAND_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_DISABLE_0_NAND_SHIFT)
#define AHB_ARBITRATION_DISABLE_0_NAND_RANGE                    10:10
#define AHB_ARBITRATION_DISABLE_0_NAND_WOFFSET                  0x0
#define AHB_ARBITRATION_DISABLE_0_NAND_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_NAND_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_DISABLE_0_NAND_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_NAND_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_NAND_ENABLE                   _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_DISABLE_0_NAND_DISABLE                  _MK_ENUM_CONST(1)

//  1 = disable SDIO1 from arbitration.
#define AHB_ARBITRATION_DISABLE_0_SDIO1_SHIFT                   _MK_SHIFT_CONST(9)
#define AHB_ARBITRATION_DISABLE_0_SDIO1_FIELD                   (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_DISABLE_0_SDIO1_SHIFT)
#define AHB_ARBITRATION_DISABLE_0_SDIO1_RANGE                   9:9
#define AHB_ARBITRATION_DISABLE_0_SDIO1_WOFFSET                 0x0
#define AHB_ARBITRATION_DISABLE_0_SDIO1_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_SDIO1_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_DISABLE_0_SDIO1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_SDIO1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_SDIO1_ENABLE                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_DISABLE_0_SDIO1_DISABLE                 _MK_ENUM_CONST(1)

//  1 = disable XIO from arbitration.
#define AHB_ARBITRATION_DISABLE_0_XIO_SHIFT                     _MK_SHIFT_CONST(8)
#define AHB_ARBITRATION_DISABLE_0_XIO_FIELD                     (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_DISABLE_0_XIO_SHIFT)
#define AHB_ARBITRATION_DISABLE_0_XIO_RANGE                     8:8
#define AHB_ARBITRATION_DISABLE_0_XIO_WOFFSET                   0x0
#define AHB_ARBITRATION_DISABLE_0_XIO_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_XIO_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_DISABLE_0_XIO_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_XIO_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_XIO_ENABLE                    _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_DISABLE_0_XIO_DISABLE                   _MK_ENUM_CONST(1)

//  1 = disable APB-DMA from arbitration.
#define AHB_ARBITRATION_DISABLE_0_APBDMA_SHIFT                  _MK_SHIFT_CONST(7)
#define AHB_ARBITRATION_DISABLE_0_APBDMA_FIELD                  (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_DISABLE_0_APBDMA_SHIFT)
#define AHB_ARBITRATION_DISABLE_0_APBDMA_RANGE                  7:7
#define AHB_ARBITRATION_DISABLE_0_APBDMA_WOFFSET                        0x0
#define AHB_ARBITRATION_DISABLE_0_APBDMA_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_APBDMA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_DISABLE_0_APBDMA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_APBDMA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_APBDMA_ENABLE                 _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_DISABLE_0_APBDMA_DISABLE                        _MK_ENUM_CONST(1)

//  1 = disable USB from arbitration.
#define AHB_ARBITRATION_DISABLE_0_USB_SHIFT                     _MK_SHIFT_CONST(6)
#define AHB_ARBITRATION_DISABLE_0_USB_FIELD                     (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_DISABLE_0_USB_SHIFT)
#define AHB_ARBITRATION_DISABLE_0_USB_RANGE                     6:6
#define AHB_ARBITRATION_DISABLE_0_USB_WOFFSET                   0x0
#define AHB_ARBITRATION_DISABLE_0_USB_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_USB_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_DISABLE_0_USB_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_USB_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_USB_ENABLE                    _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_DISABLE_0_USB_DISABLE                   _MK_ENUM_CONST(1)

//  1 = disable AHB-DMA from arbitration.
#define AHB_ARBITRATION_DISABLE_0_AHBDMA_SHIFT                  _MK_SHIFT_CONST(5)
#define AHB_ARBITRATION_DISABLE_0_AHBDMA_FIELD                  (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_DISABLE_0_AHBDMA_SHIFT)
#define AHB_ARBITRATION_DISABLE_0_AHBDMA_RANGE                  5:5
#define AHB_ARBITRATION_DISABLE_0_AHBDMA_WOFFSET                        0x0
#define AHB_ARBITRATION_DISABLE_0_AHBDMA_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_AHBDMA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_DISABLE_0_AHBDMA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_AHBDMA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_AHBDMA_ENABLE                 _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_DISABLE_0_AHBDMA_DISABLE                        _MK_ENUM_CONST(1)

//  1 = disable EIDE from arbitration.
#define AHB_ARBITRATION_DISABLE_0_EIDE_SHIFT                    _MK_SHIFT_CONST(4)
#define AHB_ARBITRATION_DISABLE_0_EIDE_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_DISABLE_0_EIDE_SHIFT)
#define AHB_ARBITRATION_DISABLE_0_EIDE_RANGE                    4:4
#define AHB_ARBITRATION_DISABLE_0_EIDE_WOFFSET                  0x0
#define AHB_ARBITRATION_DISABLE_0_EIDE_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_EIDE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_DISABLE_0_EIDE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_EIDE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_EIDE_ENABLE                   _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_DISABLE_0_EIDE_DISABLE                  _MK_ENUM_CONST(1)

//  1 = disable VCP from arbitration.
#define AHB_ARBITRATION_DISABLE_0_VCP_SHIFT                     _MK_SHIFT_CONST(2)
#define AHB_ARBITRATION_DISABLE_0_VCP_FIELD                     (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_DISABLE_0_VCP_SHIFT)
#define AHB_ARBITRATION_DISABLE_0_VCP_RANGE                     2:2
#define AHB_ARBITRATION_DISABLE_0_VCP_WOFFSET                   0x0
#define AHB_ARBITRATION_DISABLE_0_VCP_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_VCP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_DISABLE_0_VCP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_VCP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_VCP_ENABLE                    _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_DISABLE_0_VCP_DISABLE                   _MK_ENUM_CONST(1)

//  1 = disable COP from arbitration.
#define AHB_ARBITRATION_DISABLE_0_COP_SHIFT                     _MK_SHIFT_CONST(1)
#define AHB_ARBITRATION_DISABLE_0_COP_FIELD                     (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_DISABLE_0_COP_SHIFT)
#define AHB_ARBITRATION_DISABLE_0_COP_RANGE                     1:1
#define AHB_ARBITRATION_DISABLE_0_COP_WOFFSET                   0x0
#define AHB_ARBITRATION_DISABLE_0_COP_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_COP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_DISABLE_0_COP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_COP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_COP_ENABLE                    _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_DISABLE_0_COP_DISABLE                   _MK_ENUM_CONST(1)

//  1 = disable CPU from arbitration.
#define AHB_ARBITRATION_DISABLE_0_CPU_SHIFT                     _MK_SHIFT_CONST(0)
#define AHB_ARBITRATION_DISABLE_0_CPU_FIELD                     (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_DISABLE_0_CPU_SHIFT)
#define AHB_ARBITRATION_DISABLE_0_CPU_RANGE                     0:0
#define AHB_ARBITRATION_DISABLE_0_CPU_WOFFSET                   0x0
#define AHB_ARBITRATION_DISABLE_0_CPU_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_CPU_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_DISABLE_0_CPU_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_CPU_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_DISABLE_0_CPU_ENABLE                    _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_DISABLE_0_CPU_DISABLE                   _MK_ENUM_CONST(1)


// Register AHB_ARBITRATION_PRIORITY_CTRL_0  ///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//  The AHB arbiter implements a 2-level priority scheme.  In the 1st level, arbitration is determined between
//  the high and low priority group according to the priority weight; the higher the weight, the higher the
//  winning rate of the high priority group.  In the 2nd level, within each of the high/low priority group, 
//  arbitration is determined in a round-robin fashion.
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define AHB_ARBITRATION_PRIORITY_CTRL_0                 _MK_ADDR_CONST(0x4)
#define AHB_ARBITRATION_PRIORITY_CTRL_0_WORD_COUNT                      0x1
#define AHB_ARBITRATION_PRIORITY_CTRL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_PRIORITY_CTRL_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define AHB_ARBITRATION_PRIORITY_CTRL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_PRIORITY_CTRL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_PRIORITY_CTRL_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define AHB_ARBITRATION_PRIORITY_CTRL_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// AHB priority weight count. This 3-bit field is  use to control 
// the amount of attention (weight) giving to the high priority 
// group before switching to the low priority group.
#define AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_WEIGHT_SHIFT                       _MK_SHIFT_CONST(29)
#define AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_WEIGHT_FIELD                       (_MK_MASK_CONST(0x7) << AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_WEIGHT_SHIFT)
#define AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_WEIGHT_RANGE                       31:29
#define AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_WEIGHT_WOFFSET                     0x0
#define AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_WEIGHT_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_WEIGHT_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_WEIGHT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_WEIGHT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  0 = low priority
#define AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_SELECT_SHIFT                       _MK_SHIFT_CONST(0)
#define AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_SELECT_FIELD                       (_MK_MASK_CONST(0x1fffffff) << AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_SELECT_SHIFT)
#define AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_SELECT_RANGE                       28:0
#define AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_SELECT_WOFFSET                     0x0
#define AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_SELECT_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_SELECT_DEFAULT_MASK                        _MK_MASK_CONST(0x1fffffff)
#define AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_SELECT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_PRIORITY_CTRL_0_AHB_PRIORITY_SELECT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register AHB_ARBITRATION_USR_PROTECT_0  
#define AHB_ARBITRATION_USR_PROTECT_0                   _MK_ADDR_CONST(0x8)
#define AHB_ARBITRATION_USR_PROTECT_0_WORD_COUNT                        0x1
#define AHB_ARBITRATION_USR_PROTECT_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_RESET_MASK                        _MK_MASK_CONST(0x1ff)
#define AHB_ARBITRATION_USR_PROTECT_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_READ_MASK                         _MK_MASK_CONST(0x1ff)
#define AHB_ARBITRATION_USR_PROTECT_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
// Abort on USR mode access to Cache memory space
#define AHB_ARBITRATION_USR_PROTECT_0_CACHE_SHIFT                       _MK_SHIFT_CONST(8)
#define AHB_ARBITRATION_USR_PROTECT_0_CACHE_FIELD                       (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_USR_PROTECT_0_CACHE_SHIFT)
#define AHB_ARBITRATION_USR_PROTECT_0_CACHE_RANGE                       8:8
#define AHB_ARBITRATION_USR_PROTECT_0_CACHE_WOFFSET                     0x0
#define AHB_ARBITRATION_USR_PROTECT_0_CACHE_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_CACHE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_USR_PROTECT_0_CACHE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_CACHE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_CACHE_ABT_DIS                     _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_USR_PROTECT_0_CACHE_ABT_EN                      _MK_ENUM_CONST(1)

// Abort on USR mode access to internal ROM memory  space
#define AHB_ARBITRATION_USR_PROTECT_0_ROM_SHIFT                 _MK_SHIFT_CONST(7)
#define AHB_ARBITRATION_USR_PROTECT_0_ROM_FIELD                 (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_USR_PROTECT_0_ROM_SHIFT)
#define AHB_ARBITRATION_USR_PROTECT_0_ROM_RANGE                 7:7
#define AHB_ARBITRATION_USR_PROTECT_0_ROM_WOFFSET                       0x0
#define AHB_ARBITRATION_USR_PROTECT_0_ROM_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_ROM_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_USR_PROTECT_0_ROM_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_ROM_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_ROM_ABT_DIS                       _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_USR_PROTECT_0_ROM_ABT_EN                        _MK_ENUM_CONST(1)

// Abort on USR mode access to APB memory space
#define AHB_ARBITRATION_USR_PROTECT_0_APB_SHIFT                 _MK_SHIFT_CONST(6)
#define AHB_ARBITRATION_USR_PROTECT_0_APB_FIELD                 (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_USR_PROTECT_0_APB_SHIFT)
#define AHB_ARBITRATION_USR_PROTECT_0_APB_RANGE                 6:6
#define AHB_ARBITRATION_USR_PROTECT_0_APB_WOFFSET                       0x0
#define AHB_ARBITRATION_USR_PROTECT_0_APB_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_APB_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_USR_PROTECT_0_APB_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_APB_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_APB_ABT_DIS                       _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_USR_PROTECT_0_APB_ABT_EN                        _MK_ENUM_CONST(1)

// Abort on USR mode access to AHB memory space
#define AHB_ARBITRATION_USR_PROTECT_0_AHB_SHIFT                 _MK_SHIFT_CONST(5)
#define AHB_ARBITRATION_USR_PROTECT_0_AHB_FIELD                 (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_USR_PROTECT_0_AHB_SHIFT)
#define AHB_ARBITRATION_USR_PROTECT_0_AHB_RANGE                 5:5
#define AHB_ARBITRATION_USR_PROTECT_0_AHB_WOFFSET                       0x0
#define AHB_ARBITRATION_USR_PROTECT_0_AHB_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_AHB_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_USR_PROTECT_0_AHB_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_AHB_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_AHB_ABT_DIS                       _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_USR_PROTECT_0_AHB_ABT_EN                        _MK_ENUM_CONST(1)

// Abort on USR mode access to PPSB memory space
#define AHB_ARBITRATION_USR_PROTECT_0_PPSB_SHIFT                        _MK_SHIFT_CONST(4)
#define AHB_ARBITRATION_USR_PROTECT_0_PPSB_FIELD                        (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_USR_PROTECT_0_PPSB_SHIFT)
#define AHB_ARBITRATION_USR_PROTECT_0_PPSB_RANGE                        4:4
#define AHB_ARBITRATION_USR_PROTECT_0_PPSB_WOFFSET                      0x0
#define AHB_ARBITRATION_USR_PROTECT_0_PPSB_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_PPSB_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_USR_PROTECT_0_PPSB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_PPSB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_PPSB_ABT_DIS                      _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_USR_PROTECT_0_PPSB_ABT_EN                       _MK_ENUM_CONST(1)

// Abort on USR mode access to iRAMd memory space
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMD_SHIFT                       _MK_SHIFT_CONST(3)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMD_FIELD                       (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_USR_PROTECT_0_IRAMD_SHIFT)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMD_RANGE                       3:3
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMD_WOFFSET                     0x0
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMD_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMD_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMD_ABT_DIS                     _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMD_ABT_EN                      _MK_ENUM_CONST(1)

// Abort on USR mode access to iRAMc memory space
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMC_SHIFT                       _MK_SHIFT_CONST(2)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMC_FIELD                       (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_USR_PROTECT_0_IRAMC_SHIFT)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMC_RANGE                       2:2
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMC_WOFFSET                     0x0
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMC_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMC_ABT_DIS                     _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMC_ABT_EN                      _MK_ENUM_CONST(1)

// Abort on USR mode access to iRAMb memory space
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMB_SHIFT                       _MK_SHIFT_CONST(1)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMB_FIELD                       (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_USR_PROTECT_0_IRAMB_SHIFT)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMB_RANGE                       1:1
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMB_WOFFSET                     0x0
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMB_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMB_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMB_ABT_DIS                     _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMB_ABT_EN                      _MK_ENUM_CONST(1)

// Abort on USR mode access to iRAMa memory space
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMA_SHIFT                       _MK_SHIFT_CONST(0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMA_FIELD                       (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_USR_PROTECT_0_IRAMA_SHIFT)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMA_RANGE                       0:0
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMA_WOFFSET                     0x0
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMA_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMA_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMA_ABT_DIS                     _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_USR_PROTECT_0_IRAMA_ABT_EN                      _MK_ENUM_CONST(1)


// Register AHB_GIZMO_AHB_MEM_0  
#define AHB_GIZMO_AHB_MEM_0                     _MK_ADDR_CONST(0xc)
#define AHB_GIZMO_AHB_MEM_0_WORD_COUNT                  0x1
#define AHB_GIZMO_AHB_MEM_0_RESET_VAL                   _MK_MASK_CONST(0x200c1)
#define AHB_GIZMO_AHB_MEM_0_RESET_MASK                  _MK_MASK_CONST(0xff0700c7)
#define AHB_GIZMO_AHB_MEM_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_READ_MASK                   _MK_MASK_CONST(0xff0700c7)
#define AHB_GIZMO_AHB_MEM_0_WRITE_MASK                  _MK_MASK_CONST(0xff0700c7)
// AHB master request negate count. This is an 8-bit counter use to indicate 
// the minimum number of clk count between requests from  this AHB master.
#define AHB_GIZMO_AHB_MEM_0_REQ_NEG_CNT_SHIFT                   _MK_SHIFT_CONST(24)
#define AHB_GIZMO_AHB_MEM_0_REQ_NEG_CNT_FIELD                   (_MK_MASK_CONST(0xff) << AHB_GIZMO_AHB_MEM_0_REQ_NEG_CNT_SHIFT)
#define AHB_GIZMO_AHB_MEM_0_REQ_NEG_CNT_RANGE                   31:24
#define AHB_GIZMO_AHB_MEM_0_REQ_NEG_CNT_WOFFSET                 0x0
#define AHB_GIZMO_AHB_MEM_0_REQ_NEG_CNT_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_REQ_NEG_CNT_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define AHB_GIZMO_AHB_MEM_0_REQ_NEG_CNT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_REQ_NEG_CNT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// AHB master gizmo (AHB-DMA) - Start AHB write request immediately 
// 1 = start the AHB write request immediately as soon as the device 
// has put one write data in hte AHB gizmos queue. 0 = start the AHB 
// write request only when all the  write data has transferred from 
// the device to the AHB gizmos queue.
#define AHB_GIZMO_AHB_MEM_0_IMMEDIATE_SHIFT                     _MK_SHIFT_CONST(18)
#define AHB_GIZMO_AHB_MEM_0_IMMEDIATE_FIELD                     (_MK_MASK_CONST(0x1) << AHB_GIZMO_AHB_MEM_0_IMMEDIATE_SHIFT)
#define AHB_GIZMO_AHB_MEM_0_IMMEDIATE_RANGE                     18:18
#define AHB_GIZMO_AHB_MEM_0_IMMEDIATE_WOFFSET                   0x0
#define AHB_GIZMO_AHB_MEM_0_IMMEDIATE_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_IMMEDIATE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_MEM_0_IMMEDIATE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_IMMEDIATE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_IMMEDIATE_DISABLE                   _MK_ENUM_CONST(0)
#define AHB_GIZMO_AHB_MEM_0_IMMEDIATE_ENABLE                    _MK_ENUM_CONST(1)

// AHB master gizmo (AHB-DMA) - Maximum 
// allowed AHB burst size. 
// 00 = single transfer. 
// 01 = burst-of-4. 
// 10 = burst-of-8 
// 11 = burst-of-16.
#define AHB_GIZMO_AHB_MEM_0_MAX_AHB_BURSTSIZE_SHIFT                     _MK_SHIFT_CONST(16)
#define AHB_GIZMO_AHB_MEM_0_MAX_AHB_BURSTSIZE_FIELD                     (_MK_MASK_CONST(0x3) << AHB_GIZMO_AHB_MEM_0_MAX_AHB_BURSTSIZE_SHIFT)
#define AHB_GIZMO_AHB_MEM_0_MAX_AHB_BURSTSIZE_RANGE                     17:16
#define AHB_GIZMO_AHB_MEM_0_MAX_AHB_BURSTSIZE_WOFFSET                   0x0
#define AHB_GIZMO_AHB_MEM_0_MAX_AHB_BURSTSIZE_DEFAULT                   _MK_MASK_CONST(0x2)
#define AHB_GIZMO_AHB_MEM_0_MAX_AHB_BURSTSIZE_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define AHB_GIZMO_AHB_MEM_0_MAX_AHB_BURSTSIZE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_MAX_AHB_BURSTSIZE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_MAX_AHB_BURSTSIZE_DMA_BURST_1WORDS                  _MK_ENUM_CONST(0)
#define AHB_GIZMO_AHB_MEM_0_MAX_AHB_BURSTSIZE_DMA_BURST_4WORDS                  _MK_ENUM_CONST(1)
#define AHB_GIZMO_AHB_MEM_0_MAX_AHB_BURSTSIZE_DMA_BURST_8WORDS                  _MK_ENUM_CONST(2)
#define AHB_GIZMO_AHB_MEM_0_MAX_AHB_BURSTSIZE_DMA_BURST_16WORDS                 _MK_ENUM_CONST(3)

// AHB slave gizmo (memory controller)-Dont split AHB write transaction 1 = dont 
// split AHB write transaction  ever. 0 (and enable_split=1) = allow AHB write 
// transaction to be split.
#define AHB_GIZMO_AHB_MEM_0_DONT_SPLIT_AHB_WR_SHIFT                     _MK_SHIFT_CONST(7)
#define AHB_GIZMO_AHB_MEM_0_DONT_SPLIT_AHB_WR_FIELD                     (_MK_MASK_CONST(0x1) << AHB_GIZMO_AHB_MEM_0_DONT_SPLIT_AHB_WR_SHIFT)
#define AHB_GIZMO_AHB_MEM_0_DONT_SPLIT_AHB_WR_RANGE                     7:7
#define AHB_GIZMO_AHB_MEM_0_DONT_SPLIT_AHB_WR_WOFFSET                   0x0
#define AHB_GIZMO_AHB_MEM_0_DONT_SPLIT_AHB_WR_DEFAULT                   _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_MEM_0_DONT_SPLIT_AHB_WR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_MEM_0_DONT_SPLIT_AHB_WR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_DONT_SPLIT_AHB_WR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_DONT_SPLIT_AHB_WR_ENABLE                    _MK_ENUM_CONST(0)
#define AHB_GIZMO_AHB_MEM_0_DONT_SPLIT_AHB_WR_DISABLE                   _MK_ENUM_CONST(1)

// AHB slave gizmo (memory controller ) - Accept AHB write request 
// always. 1= always accept AHB write request without checking 
// whether there is room in the queue to store the write data.Bypass 
// Memory Controller AHB slave gizmo write queue. 0 = accept AHB 
// write request only when theres  enough room in the queue to store 
// all the write data. Memory controller AHB  slave gizmos write queue 
// is used in this case.
#define AHB_GIZMO_AHB_MEM_0_ACCEPT_AHB_WR_ALWAYS_SHIFT                  _MK_SHIFT_CONST(6)
#define AHB_GIZMO_AHB_MEM_0_ACCEPT_AHB_WR_ALWAYS_FIELD                  (_MK_MASK_CONST(0x1) << AHB_GIZMO_AHB_MEM_0_ACCEPT_AHB_WR_ALWAYS_SHIFT)
#define AHB_GIZMO_AHB_MEM_0_ACCEPT_AHB_WR_ALWAYS_RANGE                  6:6
#define AHB_GIZMO_AHB_MEM_0_ACCEPT_AHB_WR_ALWAYS_WOFFSET                        0x0
#define AHB_GIZMO_AHB_MEM_0_ACCEPT_AHB_WR_ALWAYS_DEFAULT                        _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_MEM_0_ACCEPT_AHB_WR_ALWAYS_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_MEM_0_ACCEPT_AHB_WR_ALWAYS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_ACCEPT_AHB_WR_ALWAYS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_ACCEPT_AHB_WR_ALWAYS_ACCEPT_ON_CHECK                        _MK_ENUM_CONST(0)
#define AHB_GIZMO_AHB_MEM_0_ACCEPT_AHB_WR_ALWAYS_ACCEPT_ON_NOCHECK                      _MK_ENUM_CONST(1)

// AHB slave gizmo - Enable fast re-arbitration. 1 = allow AHB master re-arbitration as 
// soon as the device returns one read data into the gizmos queue. 0 = allow AHB master 
// re-arbitration only when the  device returns all read data into the gizmos queue.
#define AHB_GIZMO_AHB_MEM_0_ENB_FAST_REARBITRATE_SHIFT                  _MK_SHIFT_CONST(2)
#define AHB_GIZMO_AHB_MEM_0_ENB_FAST_REARBITRATE_FIELD                  (_MK_MASK_CONST(0x1) << AHB_GIZMO_AHB_MEM_0_ENB_FAST_REARBITRATE_SHIFT)
#define AHB_GIZMO_AHB_MEM_0_ENB_FAST_REARBITRATE_RANGE                  2:2
#define AHB_GIZMO_AHB_MEM_0_ENB_FAST_REARBITRATE_WOFFSET                        0x0
#define AHB_GIZMO_AHB_MEM_0_ENB_FAST_REARBITRATE_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_ENB_FAST_REARBITRATE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_MEM_0_ENB_FAST_REARBITRATE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_ENB_FAST_REARBITRATE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_ENB_FAST_REARBITRATE_DISABLE                        _MK_ENUM_CONST(0)
#define AHB_GIZMO_AHB_MEM_0_ENB_FAST_REARBITRATE_ENABLE                 _MK_ENUM_CONST(1)

// AHB slave gizmo (memory controller ) - Foce all AHB transaction to single 
// data request transaction 1 = force to single data transaction always.  
// 0 = dont force to single data transaction.
#define AHB_GIZMO_AHB_MEM_0_FORCE_TO_AHB_SINGLE_SHIFT                   _MK_SHIFT_CONST(1)
#define AHB_GIZMO_AHB_MEM_0_FORCE_TO_AHB_SINGLE_FIELD                   (_MK_MASK_CONST(0x1) << AHB_GIZMO_AHB_MEM_0_FORCE_TO_AHB_SINGLE_SHIFT)
#define AHB_GIZMO_AHB_MEM_0_FORCE_TO_AHB_SINGLE_RANGE                   1:1
#define AHB_GIZMO_AHB_MEM_0_FORCE_TO_AHB_SINGLE_WOFFSET                 0x0
#define AHB_GIZMO_AHB_MEM_0_FORCE_TO_AHB_SINGLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_FORCE_TO_AHB_SINGLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_MEM_0_FORCE_TO_AHB_SINGLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_FORCE_TO_AHB_SINGLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_FORCE_TO_AHB_SINGLE_NOT_SINGLE_DATA                 _MK_ENUM_CONST(0)
#define AHB_GIZMO_AHB_MEM_0_FORCE_TO_AHB_SINGLE_SINGLE_DATA                     _MK_ENUM_CONST(1)

// AHB slave gizmo (memory controller ) - Enable splitting AHB transaction. 
// 1 = enable 0 = disable.
#define AHB_GIZMO_AHB_MEM_0_ENABLE_SPLIT_SHIFT                  _MK_SHIFT_CONST(0)
#define AHB_GIZMO_AHB_MEM_0_ENABLE_SPLIT_FIELD                  (_MK_MASK_CONST(0x1) << AHB_GIZMO_AHB_MEM_0_ENABLE_SPLIT_SHIFT)
#define AHB_GIZMO_AHB_MEM_0_ENABLE_SPLIT_RANGE                  0:0
#define AHB_GIZMO_AHB_MEM_0_ENABLE_SPLIT_WOFFSET                        0x0
#define AHB_GIZMO_AHB_MEM_0_ENABLE_SPLIT_DEFAULT                        _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_MEM_0_ENABLE_SPLIT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_MEM_0_ENABLE_SPLIT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_ENABLE_SPLIT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_MEM_0_ENABLE_SPLIT_DISABLE                        _MK_ENUM_CONST(0)
#define AHB_GIZMO_AHB_MEM_0_ENABLE_SPLIT_ENABLE                 _MK_ENUM_CONST(1)


// Register AHB_GIZMO_APB_DMA_0  
#define AHB_GIZMO_APB_DMA_0                     _MK_ADDR_CONST(0x10)
#define AHB_GIZMO_APB_DMA_0_WORD_COUNT                  0x1
#define AHB_GIZMO_APB_DMA_0_RESET_VAL                   _MK_MASK_CONST(0xa0000)
#define AHB_GIZMO_APB_DMA_0_RESET_MASK                  _MK_MASK_CONST(0xff0f0000)
#define AHB_GIZMO_APB_DMA_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_APB_DMA_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_APB_DMA_0_READ_MASK                   _MK_MASK_CONST(0xff0f0000)
#define AHB_GIZMO_APB_DMA_0_WRITE_MASK                  _MK_MASK_CONST(0xff0f0000)
// AHB master request negate count. This is an 8-bit  counter use to indicate 
// the minimum number of clk count between requests from  this AHB master.
#define AHB_GIZMO_APB_DMA_0_REQ_NEG_CNT_SHIFT                   _MK_SHIFT_CONST(24)
#define AHB_GIZMO_APB_DMA_0_REQ_NEG_CNT_FIELD                   (_MK_MASK_CONST(0xff) << AHB_GIZMO_APB_DMA_0_REQ_NEG_CNT_SHIFT)
#define AHB_GIZMO_APB_DMA_0_REQ_NEG_CNT_RANGE                   31:24
#define AHB_GIZMO_APB_DMA_0_REQ_NEG_CNT_WOFFSET                 0x0
#define AHB_GIZMO_APB_DMA_0_REQ_NEG_CNT_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_APB_DMA_0_REQ_NEG_CNT_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define AHB_GIZMO_APB_DMA_0_REQ_NEG_CNT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_APB_DMA_0_REQ_NEG_CNT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// AHB master gizmo - Pack all AHB read data.  1 = wait for all 
// requested read data to be in the AHB gizmos queue before returning 
// the data back to the IP. 0 = transfer each read data from the AHB 
// to the IP  immediately.
#define AHB_GIZMO_APB_DMA_0_RD_DATA_SHIFT                       _MK_SHIFT_CONST(19)
#define AHB_GIZMO_APB_DMA_0_RD_DATA_FIELD                       (_MK_MASK_CONST(0x1) << AHB_GIZMO_APB_DMA_0_RD_DATA_SHIFT)
#define AHB_GIZMO_APB_DMA_0_RD_DATA_RANGE                       19:19
#define AHB_GIZMO_APB_DMA_0_RD_DATA_WOFFSET                     0x0
#define AHB_GIZMO_APB_DMA_0_RD_DATA_DEFAULT                     _MK_MASK_CONST(0x1)
#define AHB_GIZMO_APB_DMA_0_RD_DATA_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AHB_GIZMO_APB_DMA_0_RD_DATA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_GIZMO_APB_DMA_0_RD_DATA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_APB_DMA_0_RD_DATA_NO_WAIT                     _MK_ENUM_CONST(0)
#define AHB_GIZMO_APB_DMA_0_RD_DATA_WAIT                        _MK_ENUM_CONST(1)

// AHB master gizmo (AHB-DMA) - Start AHB write request immediately.  
// 1 = start the AHB write request immediately as soon as the device has 
// put one write data in the AHB gizmos queue. 0 = start the AHB write 
// request only when all the  write data has transferred from the device 
// to the AHB gizmos queue.
#define AHB_GIZMO_APB_DMA_0_IMMEDIATE_SHIFT                     _MK_SHIFT_CONST(18)
#define AHB_GIZMO_APB_DMA_0_IMMEDIATE_FIELD                     (_MK_MASK_CONST(0x1) << AHB_GIZMO_APB_DMA_0_IMMEDIATE_SHIFT)
#define AHB_GIZMO_APB_DMA_0_IMMEDIATE_RANGE                     18:18
#define AHB_GIZMO_APB_DMA_0_IMMEDIATE_WOFFSET                   0x0
#define AHB_GIZMO_APB_DMA_0_IMMEDIATE_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_APB_DMA_0_IMMEDIATE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AHB_GIZMO_APB_DMA_0_IMMEDIATE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_APB_DMA_0_IMMEDIATE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_APB_DMA_0_IMMEDIATE_DISABLE                   _MK_ENUM_CONST(0)
#define AHB_GIZMO_APB_DMA_0_IMMEDIATE_ENABLE                    _MK_ENUM_CONST(1)

// AHB master gizmo - Maximum allowed 
// AHB burst size.  
// 00 = single transfer.  
// 01 = burst-of-4.  
// 10 = burst-of-8. 
// 11 = burst-of-16.
#define AHB_GIZMO_APB_DMA_0_MAX_AHB_BURSTSIZE_SHIFT                     _MK_SHIFT_CONST(16)
#define AHB_GIZMO_APB_DMA_0_MAX_AHB_BURSTSIZE_FIELD                     (_MK_MASK_CONST(0x3) << AHB_GIZMO_APB_DMA_0_MAX_AHB_BURSTSIZE_SHIFT)
#define AHB_GIZMO_APB_DMA_0_MAX_AHB_BURSTSIZE_RANGE                     17:16
#define AHB_GIZMO_APB_DMA_0_MAX_AHB_BURSTSIZE_WOFFSET                   0x0
#define AHB_GIZMO_APB_DMA_0_MAX_AHB_BURSTSIZE_DEFAULT                   _MK_MASK_CONST(0x2)
#define AHB_GIZMO_APB_DMA_0_MAX_AHB_BURSTSIZE_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define AHB_GIZMO_APB_DMA_0_MAX_AHB_BURSTSIZE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_APB_DMA_0_MAX_AHB_BURSTSIZE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_APB_DMA_0_MAX_AHB_BURSTSIZE_DMA_BURST_1WORDS                  _MK_ENUM_CONST(0)
#define AHB_GIZMO_APB_DMA_0_MAX_AHB_BURSTSIZE_DMA_BURST_4WORDS                  _MK_ENUM_CONST(1)
#define AHB_GIZMO_APB_DMA_0_MAX_AHB_BURSTSIZE_DMA_BURST_8WORDS                  _MK_ENUM_CONST(2)
#define AHB_GIZMO_APB_DMA_0_MAX_AHB_BURSTSIZE_DMA_BURST_16WORDS                 _MK_ENUM_CONST(3)


// Reserved address 20 [0x14] 

// Register AHB_GIZMO_IDE_0  
#define AHB_GIZMO_IDE_0                 _MK_ADDR_CONST(0x18)
#define AHB_GIZMO_IDE_0_WORD_COUNT                      0x1
#define AHB_GIZMO_IDE_0_RESET_VAL                       _MK_MASK_CONST(0x200bf)
#define AHB_GIZMO_IDE_0_RESET_MASK                      _MK_MASK_CONST(0xff0f00ff)
#define AHB_GIZMO_IDE_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_READ_MASK                       _MK_MASK_CONST(0xff0f00ff)
#define AHB_GIZMO_IDE_0_WRITE_MASK                      _MK_MASK_CONST(0xff0f00ff)
// AHB master request negate count. This is an 8-bit  counter use to indicate the minimum number of clk 
// count between requests from  this AHB master.
#define AHB_GIZMO_IDE_0_REQ_NEG_CNT_SHIFT                       _MK_SHIFT_CONST(24)
#define AHB_GIZMO_IDE_0_REQ_NEG_CNT_FIELD                       (_MK_MASK_CONST(0xff) << AHB_GIZMO_IDE_0_REQ_NEG_CNT_SHIFT)
#define AHB_GIZMO_IDE_0_REQ_NEG_CNT_RANGE                       31:24
#define AHB_GIZMO_IDE_0_REQ_NEG_CNT_WOFFSET                     0x0
#define AHB_GIZMO_IDE_0_REQ_NEG_CNT_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_REQ_NEG_CNT_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define AHB_GIZMO_IDE_0_REQ_NEG_CNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_REQ_NEG_CNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// AHB master gizmo - Pack all AHB read data.  1 = wait for all requested read data 
// to be in the AHB gizmos queue before returning the data back to the IP. 0 = transfer 
// each read data from the AHB to the IP  immediately.
#define AHB_GIZMO_IDE_0_RD_DATA_SHIFT                   _MK_SHIFT_CONST(19)
#define AHB_GIZMO_IDE_0_RD_DATA_FIELD                   (_MK_MASK_CONST(0x1) << AHB_GIZMO_IDE_0_RD_DATA_SHIFT)
#define AHB_GIZMO_IDE_0_RD_DATA_RANGE                   19:19
#define AHB_GIZMO_IDE_0_RD_DATA_WOFFSET                 0x0
#define AHB_GIZMO_IDE_0_RD_DATA_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_RD_DATA_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AHB_GIZMO_IDE_0_RD_DATA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_RD_DATA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_RD_DATA_NO_WAIT                 _MK_ENUM_CONST(0)
#define AHB_GIZMO_IDE_0_RD_DATA_WAIT                    _MK_ENUM_CONST(1)

// AHB master gizmo (AHB-DMA) - Start AHB write request immediately.  1 = start the 
// AHB write request immediately as soon as the device has put one write data in the 
// AHB gizmos queue. 0 = start the AHB write request only when all the  write data 
// has transferred from the device to the AHB gizmos queue.
#define AHB_GIZMO_IDE_0_IMMEDIATE_SHIFT                 _MK_SHIFT_CONST(18)
#define AHB_GIZMO_IDE_0_IMMEDIATE_FIELD                 (_MK_MASK_CONST(0x1) << AHB_GIZMO_IDE_0_IMMEDIATE_SHIFT)
#define AHB_GIZMO_IDE_0_IMMEDIATE_RANGE                 18:18
#define AHB_GIZMO_IDE_0_IMMEDIATE_WOFFSET                       0x0
#define AHB_GIZMO_IDE_0_IMMEDIATE_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_IMMEDIATE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AHB_GIZMO_IDE_0_IMMEDIATE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_IMMEDIATE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_IMMEDIATE_DISABLE                       _MK_ENUM_CONST(0)
#define AHB_GIZMO_IDE_0_IMMEDIATE_ENABLE                        _MK_ENUM_CONST(1)

// AHB master gizmo - Maximum 
// allowed AHB burst size.  
// 00 = single transfer.  
// 01 = burst-of-4.  
// 10 = burst-of-8. 
// 11 = burst-of-16.
#define AHB_GIZMO_IDE_0_MAX_AHB_BURSTSIZE_SHIFT                 _MK_SHIFT_CONST(16)
#define AHB_GIZMO_IDE_0_MAX_AHB_BURSTSIZE_FIELD                 (_MK_MASK_CONST(0x3) << AHB_GIZMO_IDE_0_MAX_AHB_BURSTSIZE_SHIFT)
#define AHB_GIZMO_IDE_0_MAX_AHB_BURSTSIZE_RANGE                 17:16
#define AHB_GIZMO_IDE_0_MAX_AHB_BURSTSIZE_WOFFSET                       0x0
#define AHB_GIZMO_IDE_0_MAX_AHB_BURSTSIZE_DEFAULT                       _MK_MASK_CONST(0x2)
#define AHB_GIZMO_IDE_0_MAX_AHB_BURSTSIZE_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define AHB_GIZMO_IDE_0_MAX_AHB_BURSTSIZE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_MAX_AHB_BURSTSIZE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_MAX_AHB_BURSTSIZE_DMA_BURST_1WORDS                      _MK_ENUM_CONST(0)
#define AHB_GIZMO_IDE_0_MAX_AHB_BURSTSIZE_DMA_BURST_4WORDS                      _MK_ENUM_CONST(1)
#define AHB_GIZMO_IDE_0_MAX_AHB_BURSTSIZE_DMA_BURST_8WORDS                      _MK_ENUM_CONST(2)
#define AHB_GIZMO_IDE_0_MAX_AHB_BURSTSIZE_DMA_BURST_16WORDS                     _MK_ENUM_CONST(3)

// AHB slave gizmo - Dont split AHB write transaction.  1 = dont split AHB write transaction 
// ever. 0 (and enable_split=1) = allow AHB write  transaction to be split.
#define AHB_GIZMO_IDE_0_DONT_SPLIT_AHB_WR_SHIFT                 _MK_SHIFT_CONST(7)
#define AHB_GIZMO_IDE_0_DONT_SPLIT_AHB_WR_FIELD                 (_MK_MASK_CONST(0x1) << AHB_GIZMO_IDE_0_DONT_SPLIT_AHB_WR_SHIFT)
#define AHB_GIZMO_IDE_0_DONT_SPLIT_AHB_WR_RANGE                 7:7
#define AHB_GIZMO_IDE_0_DONT_SPLIT_AHB_WR_WOFFSET                       0x0
#define AHB_GIZMO_IDE_0_DONT_SPLIT_AHB_WR_DEFAULT                       _MK_MASK_CONST(0x1)
#define AHB_GIZMO_IDE_0_DONT_SPLIT_AHB_WR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AHB_GIZMO_IDE_0_DONT_SPLIT_AHB_WR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_DONT_SPLIT_AHB_WR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_DONT_SPLIT_AHB_WR_ENABLE                        _MK_ENUM_CONST(0)
#define AHB_GIZMO_IDE_0_DONT_SPLIT_AHB_WR_DISABLE                       _MK_ENUM_CONST(1)

// AHB slave gizmo - Accept AHB write request always.  1 = always accept 
// AHB write request without checking whether there is room in the queue 
// to store the write data. 0 = accept AHB write request only when theres  
// enough room in the queue to store all the write data.
#define AHB_GIZMO_IDE_0_ACCEPT_AHB_WR_ALWAYS_SHIFT                      _MK_SHIFT_CONST(6)
#define AHB_GIZMO_IDE_0_ACCEPT_AHB_WR_ALWAYS_FIELD                      (_MK_MASK_CONST(0x1) << AHB_GIZMO_IDE_0_ACCEPT_AHB_WR_ALWAYS_SHIFT)
#define AHB_GIZMO_IDE_0_ACCEPT_AHB_WR_ALWAYS_RANGE                      6:6
#define AHB_GIZMO_IDE_0_ACCEPT_AHB_WR_ALWAYS_WOFFSET                    0x0
#define AHB_GIZMO_IDE_0_ACCEPT_AHB_WR_ALWAYS_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_ACCEPT_AHB_WR_ALWAYS_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_GIZMO_IDE_0_ACCEPT_AHB_WR_ALWAYS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_ACCEPT_AHB_WR_ALWAYS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_ACCEPT_AHB_WR_ALWAYS_ACCEPT_ON_CHECK                    _MK_ENUM_CONST(0)
#define AHB_GIZMO_IDE_0_ACCEPT_AHB_WR_ALWAYS_ACCEPT_ON_NOCHECK                  _MK_ENUM_CONST(1)

// AHB slave gizmo  Maximum allowed IP 
// burst size.  
// 00 = single transfer.  
// 01 = burst-of-4.  
// 10 = burst-of-8.
// 11 = burst-of-16.
#define AHB_GIZMO_IDE_0_MAX_IP_BURSTSIZE_SHIFT                  _MK_SHIFT_CONST(4)
#define AHB_GIZMO_IDE_0_MAX_IP_BURSTSIZE_FIELD                  (_MK_MASK_CONST(0x3) << AHB_GIZMO_IDE_0_MAX_IP_BURSTSIZE_SHIFT)
#define AHB_GIZMO_IDE_0_MAX_IP_BURSTSIZE_RANGE                  5:4
#define AHB_GIZMO_IDE_0_MAX_IP_BURSTSIZE_WOFFSET                        0x0
#define AHB_GIZMO_IDE_0_MAX_IP_BURSTSIZE_DEFAULT                        _MK_MASK_CONST(0x3)
#define AHB_GIZMO_IDE_0_MAX_IP_BURSTSIZE_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define AHB_GIZMO_IDE_0_MAX_IP_BURSTSIZE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_MAX_IP_BURSTSIZE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_MAX_IP_BURSTSIZE_DMA_BURST_1WORDS                       _MK_ENUM_CONST(0)
#define AHB_GIZMO_IDE_0_MAX_IP_BURSTSIZE_DMA_BURST_4WORDS                       _MK_ENUM_CONST(1)
#define AHB_GIZMO_IDE_0_MAX_IP_BURSTSIZE_DMA_BURST_8WORDS                       _MK_ENUM_CONST(2)
#define AHB_GIZMO_IDE_0_MAX_IP_BURSTSIZE_DMA_BURST_16WORDS                      _MK_ENUM_CONST(3)

// AHB slave gizmo  Start write request to device immediately.  1 = start write request on the device side as soon 
// as the AHB master puts data into the gizmos queue. 0 = start the device write request only when the  AHB master 
// has placed all write data into the gizmos queue.
#define AHB_GIZMO_IDE_0_IP_WR_REQ_IMMEDIATE_SHIFT                       _MK_SHIFT_CONST(3)
#define AHB_GIZMO_IDE_0_IP_WR_REQ_IMMEDIATE_FIELD                       (_MK_MASK_CONST(0x1) << AHB_GIZMO_IDE_0_IP_WR_REQ_IMMEDIATE_SHIFT)
#define AHB_GIZMO_IDE_0_IP_WR_REQ_IMMEDIATE_RANGE                       3:3
#define AHB_GIZMO_IDE_0_IP_WR_REQ_IMMEDIATE_WOFFSET                     0x0
#define AHB_GIZMO_IDE_0_IP_WR_REQ_IMMEDIATE_DEFAULT                     _MK_MASK_CONST(0x1)
#define AHB_GIZMO_IDE_0_IP_WR_REQ_IMMEDIATE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AHB_GIZMO_IDE_0_IP_WR_REQ_IMMEDIATE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_IP_WR_REQ_IMMEDIATE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// AHB slave gizmo - Enable fast re-arbitration.  1 = allow AHB master re-arbitration as soon 
// as the device returns one read data into the gizmos queue.0 = allow AHB master re-arbitration 
// only when the  device returns all read data into the gizmos queue.
#define AHB_GIZMO_IDE_0_ENB_FAST_REARBITRATE_SHIFT                      _MK_SHIFT_CONST(2)
#define AHB_GIZMO_IDE_0_ENB_FAST_REARBITRATE_FIELD                      (_MK_MASK_CONST(0x1) << AHB_GIZMO_IDE_0_ENB_FAST_REARBITRATE_SHIFT)
#define AHB_GIZMO_IDE_0_ENB_FAST_REARBITRATE_RANGE                      2:2
#define AHB_GIZMO_IDE_0_ENB_FAST_REARBITRATE_WOFFSET                    0x0
#define AHB_GIZMO_IDE_0_ENB_FAST_REARBITRATE_DEFAULT                    _MK_MASK_CONST(0x1)
#define AHB_GIZMO_IDE_0_ENB_FAST_REARBITRATE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_GIZMO_IDE_0_ENB_FAST_REARBITRATE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_ENB_FAST_REARBITRATE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_ENB_FAST_REARBITRATE_DISABLE                    _MK_ENUM_CONST(0)
#define AHB_GIZMO_IDE_0_ENB_FAST_REARBITRATE_ENABLE                     _MK_ENUM_CONST(1)

// AHB slave gizmo - Force all AHB transaction to single data request transaction.  
// 1 = force to single data transaction always. 
// 0 = dont force to single data  transaction.
#define AHB_GIZMO_IDE_0_FORCE_TO_AHB_SINGLE_SHIFT                       _MK_SHIFT_CONST(1)
#define AHB_GIZMO_IDE_0_FORCE_TO_AHB_SINGLE_FIELD                       (_MK_MASK_CONST(0x1) << AHB_GIZMO_IDE_0_FORCE_TO_AHB_SINGLE_SHIFT)
#define AHB_GIZMO_IDE_0_FORCE_TO_AHB_SINGLE_RANGE                       1:1
#define AHB_GIZMO_IDE_0_FORCE_TO_AHB_SINGLE_WOFFSET                     0x0
#define AHB_GIZMO_IDE_0_FORCE_TO_AHB_SINGLE_DEFAULT                     _MK_MASK_CONST(0x1)
#define AHB_GIZMO_IDE_0_FORCE_TO_AHB_SINGLE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AHB_GIZMO_IDE_0_FORCE_TO_AHB_SINGLE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_FORCE_TO_AHB_SINGLE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_FORCE_TO_AHB_SINGLE_NOT_SINGLE_DATA                     _MK_ENUM_CONST(0)
#define AHB_GIZMO_IDE_0_FORCE_TO_AHB_SINGLE_SINGLE_DATA                 _MK_ENUM_CONST(1)

// AHB slave gizmo - Enable splitting AHB transactions.  1 = enable, 0 = disable.
#define AHB_GIZMO_IDE_0_ENABLE_SPLIT_SHIFT                      _MK_SHIFT_CONST(0)
#define AHB_GIZMO_IDE_0_ENABLE_SPLIT_FIELD                      (_MK_MASK_CONST(0x1) << AHB_GIZMO_IDE_0_ENABLE_SPLIT_SHIFT)
#define AHB_GIZMO_IDE_0_ENABLE_SPLIT_RANGE                      0:0
#define AHB_GIZMO_IDE_0_ENABLE_SPLIT_WOFFSET                    0x0
#define AHB_GIZMO_IDE_0_ENABLE_SPLIT_DEFAULT                    _MK_MASK_CONST(0x1)
#define AHB_GIZMO_IDE_0_ENABLE_SPLIT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_GIZMO_IDE_0_ENABLE_SPLIT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_ENABLE_SPLIT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_IDE_0_ENABLE_SPLIT_DISABLE                    _MK_ENUM_CONST(0)
#define AHB_GIZMO_IDE_0_ENABLE_SPLIT_ENABLE                     _MK_ENUM_CONST(1)


// Register AHB_GIZMO_USB_0  
#define AHB_GIZMO_USB_0                 _MK_ADDR_CONST(0x1c)
#define AHB_GIZMO_USB_0_WORD_COUNT                      0x1
#define AHB_GIZMO_USB_0_RESET_VAL                       _MK_MASK_CONST(0x20083)
#define AHB_GIZMO_USB_0_RESET_MASK                      _MK_MASK_CONST(0xff0f00cf)
#define AHB_GIZMO_USB_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_READ_MASK                       _MK_MASK_CONST(0xff0f00cf)
#define AHB_GIZMO_USB_0_WRITE_MASK                      _MK_MASK_CONST(0xff0f00cf)
// AHB master request negate count. This is an 8-bit  counter use to indicate the minimum number of clk count 
// between requests from  this AHB master.
#define AHB_GIZMO_USB_0_REQ_NEG_CNT_SHIFT                       _MK_SHIFT_CONST(24)
#define AHB_GIZMO_USB_0_REQ_NEG_CNT_FIELD                       (_MK_MASK_CONST(0xff) << AHB_GIZMO_USB_0_REQ_NEG_CNT_SHIFT)
#define AHB_GIZMO_USB_0_REQ_NEG_CNT_RANGE                       31:24
#define AHB_GIZMO_USB_0_REQ_NEG_CNT_WOFFSET                     0x0
#define AHB_GIZMO_USB_0_REQ_NEG_CNT_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_REQ_NEG_CNT_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define AHB_GIZMO_USB_0_REQ_NEG_CNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_REQ_NEG_CNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// AHB master gizmo - Pack all AHB read data.  1 = wait for all requested read data to be in 
// the AHB gizmos queue before returning the data back to the IP. 0 = transfer each read data 
// from the AHB to the IP  immediately.
#define AHB_GIZMO_USB_0_RD_DATA_SHIFT                   _MK_SHIFT_CONST(19)
#define AHB_GIZMO_USB_0_RD_DATA_FIELD                   (_MK_MASK_CONST(0x1) << AHB_GIZMO_USB_0_RD_DATA_SHIFT)
#define AHB_GIZMO_USB_0_RD_DATA_RANGE                   19:19
#define AHB_GIZMO_USB_0_RD_DATA_WOFFSET                 0x0
#define AHB_GIZMO_USB_0_RD_DATA_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_RD_DATA_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AHB_GIZMO_USB_0_RD_DATA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_RD_DATA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_RD_DATA_NO_WAIT                 _MK_ENUM_CONST(0)
#define AHB_GIZMO_USB_0_RD_DATA_WAIT                    _MK_ENUM_CONST(1)

// AHB master gizmo (AHB-DMA) - Start AHB write request immediately.  1 = start the AHB 
// write request immediately as soon as the device has put one write data in the AHB gizmos 
// queue. 0 = start the AHB write request only when all the  write data has transferred 
// from the device to the AHB gizmos queue.
#define AHB_GIZMO_USB_0_IMMEDIATE_SHIFT                 _MK_SHIFT_CONST(18)
#define AHB_GIZMO_USB_0_IMMEDIATE_FIELD                 (_MK_MASK_CONST(0x1) << AHB_GIZMO_USB_0_IMMEDIATE_SHIFT)
#define AHB_GIZMO_USB_0_IMMEDIATE_RANGE                 18:18
#define AHB_GIZMO_USB_0_IMMEDIATE_WOFFSET                       0x0
#define AHB_GIZMO_USB_0_IMMEDIATE_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_IMMEDIATE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AHB_GIZMO_USB_0_IMMEDIATE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_IMMEDIATE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_IMMEDIATE_DISABLE                       _MK_ENUM_CONST(0)
#define AHB_GIZMO_USB_0_IMMEDIATE_ENABLE                        _MK_ENUM_CONST(1)

// AHB master gizmo - Maximum allowed 
// AHB burst size.  
// 00 = single transfer.  
// 01 = burst-of-4.  
// 10 = burst-of-8. 
// 11 = burst-of-16.
#define AHB_GIZMO_USB_0_MAX_AHB_BURSTSIZE_SHIFT                 _MK_SHIFT_CONST(16)
#define AHB_GIZMO_USB_0_MAX_AHB_BURSTSIZE_FIELD                 (_MK_MASK_CONST(0x3) << AHB_GIZMO_USB_0_MAX_AHB_BURSTSIZE_SHIFT)
#define AHB_GIZMO_USB_0_MAX_AHB_BURSTSIZE_RANGE                 17:16
#define AHB_GIZMO_USB_0_MAX_AHB_BURSTSIZE_WOFFSET                       0x0
#define AHB_GIZMO_USB_0_MAX_AHB_BURSTSIZE_DEFAULT                       _MK_MASK_CONST(0x2)
#define AHB_GIZMO_USB_0_MAX_AHB_BURSTSIZE_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define AHB_GIZMO_USB_0_MAX_AHB_BURSTSIZE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_MAX_AHB_BURSTSIZE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_MAX_AHB_BURSTSIZE_DMA_BURST_1WORDS                      _MK_ENUM_CONST(0)
#define AHB_GIZMO_USB_0_MAX_AHB_BURSTSIZE_DMA_BURST_4WORDS                      _MK_ENUM_CONST(1)
#define AHB_GIZMO_USB_0_MAX_AHB_BURSTSIZE_DMA_BURST_8WORDS                      _MK_ENUM_CONST(2)
#define AHB_GIZMO_USB_0_MAX_AHB_BURSTSIZE_DMA_BURST_16WORDS                     _MK_ENUM_CONST(3)

// AHB slave gizmo - Dont split AHB write transaction.  1 = dont split AHB write transaction 
// ever. 0 (and enable_split=1) = allow AHB write  transaction to be split.
#define AHB_GIZMO_USB_0_DONT_SPLIT_AHB_WR_SHIFT                 _MK_SHIFT_CONST(7)
#define AHB_GIZMO_USB_0_DONT_SPLIT_AHB_WR_FIELD                 (_MK_MASK_CONST(0x1) << AHB_GIZMO_USB_0_DONT_SPLIT_AHB_WR_SHIFT)
#define AHB_GIZMO_USB_0_DONT_SPLIT_AHB_WR_RANGE                 7:7
#define AHB_GIZMO_USB_0_DONT_SPLIT_AHB_WR_WOFFSET                       0x0
#define AHB_GIZMO_USB_0_DONT_SPLIT_AHB_WR_DEFAULT                       _MK_MASK_CONST(0x1)
#define AHB_GIZMO_USB_0_DONT_SPLIT_AHB_WR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AHB_GIZMO_USB_0_DONT_SPLIT_AHB_WR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_DONT_SPLIT_AHB_WR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_DONT_SPLIT_AHB_WR_ENABLE                        _MK_ENUM_CONST(0)
#define AHB_GIZMO_USB_0_DONT_SPLIT_AHB_WR_DISABLE                       _MK_ENUM_CONST(1)

// AHB slave gizmo - Accept AHB write request always.  1 = always accept 
// AHB write request without checking whether there is room in the queue 
// to store the write data. 0 = accept AHB write request only when theres  
// enough room in the queue to store all the write data.
#define AHB_GIZMO_USB_0_ACCEPT_AHB_WR_ALWAYS_SHIFT                      _MK_SHIFT_CONST(6)
#define AHB_GIZMO_USB_0_ACCEPT_AHB_WR_ALWAYS_FIELD                      (_MK_MASK_CONST(0x1) << AHB_GIZMO_USB_0_ACCEPT_AHB_WR_ALWAYS_SHIFT)
#define AHB_GIZMO_USB_0_ACCEPT_AHB_WR_ALWAYS_RANGE                      6:6
#define AHB_GIZMO_USB_0_ACCEPT_AHB_WR_ALWAYS_WOFFSET                    0x0
#define AHB_GIZMO_USB_0_ACCEPT_AHB_WR_ALWAYS_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_ACCEPT_AHB_WR_ALWAYS_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_GIZMO_USB_0_ACCEPT_AHB_WR_ALWAYS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_ACCEPT_AHB_WR_ALWAYS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_ACCEPT_AHB_WR_ALWAYS_ACCEPT_ON_CHECK                    _MK_ENUM_CONST(0)
#define AHB_GIZMO_USB_0_ACCEPT_AHB_WR_ALWAYS_ACCEPT_ON_NOCHECK                  _MK_ENUM_CONST(1)

// AHB slave gizmo  Start write request to device immediately.  1 = start write request on 
// the device side as soon as the AHB master puts data into the gizmos queue. 0 = start the 
// device write request only when the  AHB master has placed all write data into the gizmos 
// queue.
#define AHB_GIZMO_USB_0_IP_WR_REQ_IMMEDIATE_SHIFT                       _MK_SHIFT_CONST(3)
#define AHB_GIZMO_USB_0_IP_WR_REQ_IMMEDIATE_FIELD                       (_MK_MASK_CONST(0x1) << AHB_GIZMO_USB_0_IP_WR_REQ_IMMEDIATE_SHIFT)
#define AHB_GIZMO_USB_0_IP_WR_REQ_IMMEDIATE_RANGE                       3:3
#define AHB_GIZMO_USB_0_IP_WR_REQ_IMMEDIATE_WOFFSET                     0x0
#define AHB_GIZMO_USB_0_IP_WR_REQ_IMMEDIATE_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_IP_WR_REQ_IMMEDIATE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AHB_GIZMO_USB_0_IP_WR_REQ_IMMEDIATE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_IP_WR_REQ_IMMEDIATE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_IP_WR_REQ_IMMEDIATE_DISABLE                     _MK_ENUM_CONST(0)
#define AHB_GIZMO_USB_0_IP_WR_REQ_IMMEDIATE_ENABLE                      _MK_ENUM_CONST(1)

// AHB slave gizmo - Enable fast re-arbitration.  1 = allow AHB master re-arbitration as soon 
// as the device returns one read data into the gizmos queue. 0 = allow AHB master 
// re-arbitration only when the  device returns all read data into the gizmos queue.
#define AHB_GIZMO_USB_0_ENB_FAST_REARBITRATE_SHIFT                      _MK_SHIFT_CONST(2)
#define AHB_GIZMO_USB_0_ENB_FAST_REARBITRATE_FIELD                      (_MK_MASK_CONST(0x1) << AHB_GIZMO_USB_0_ENB_FAST_REARBITRATE_SHIFT)
#define AHB_GIZMO_USB_0_ENB_FAST_REARBITRATE_RANGE                      2:2
#define AHB_GIZMO_USB_0_ENB_FAST_REARBITRATE_WOFFSET                    0x0
#define AHB_GIZMO_USB_0_ENB_FAST_REARBITRATE_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_ENB_FAST_REARBITRATE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_GIZMO_USB_0_ENB_FAST_REARBITRATE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_ENB_FAST_REARBITRATE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_ENB_FAST_REARBITRATE_DISABLE                    _MK_ENUM_CONST(0)
#define AHB_GIZMO_USB_0_ENB_FAST_REARBITRATE_ENABLE                     _MK_ENUM_CONST(1)

// AHB slave gizmo - Force all AHB transaction to single data request transaction.  
// 1 = force to single data transaction always. 
// 0 = dont force to single data transaction.
#define AHB_GIZMO_USB_0_FORCE_TO_AHB_SINGLE_SHIFT                       _MK_SHIFT_CONST(1)
#define AHB_GIZMO_USB_0_FORCE_TO_AHB_SINGLE_FIELD                       (_MK_MASK_CONST(0x1) << AHB_GIZMO_USB_0_FORCE_TO_AHB_SINGLE_SHIFT)
#define AHB_GIZMO_USB_0_FORCE_TO_AHB_SINGLE_RANGE                       1:1
#define AHB_GIZMO_USB_0_FORCE_TO_AHB_SINGLE_WOFFSET                     0x0
#define AHB_GIZMO_USB_0_FORCE_TO_AHB_SINGLE_DEFAULT                     _MK_MASK_CONST(0x1)
#define AHB_GIZMO_USB_0_FORCE_TO_AHB_SINGLE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AHB_GIZMO_USB_0_FORCE_TO_AHB_SINGLE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_FORCE_TO_AHB_SINGLE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_FORCE_TO_AHB_SINGLE_NOT_SINGLE_DATA                     _MK_ENUM_CONST(0)
#define AHB_GIZMO_USB_0_FORCE_TO_AHB_SINGLE_SINGLE_DATA                 _MK_ENUM_CONST(1)

//AHB slave gizmo - Enable splitting AHB transactions.  1 = enable  0 = disable
#define AHB_GIZMO_USB_0_ENABLE_SPLIT_SHIFT                      _MK_SHIFT_CONST(0)
#define AHB_GIZMO_USB_0_ENABLE_SPLIT_FIELD                      (_MK_MASK_CONST(0x1) << AHB_GIZMO_USB_0_ENABLE_SPLIT_SHIFT)
#define AHB_GIZMO_USB_0_ENABLE_SPLIT_RANGE                      0:0
#define AHB_GIZMO_USB_0_ENABLE_SPLIT_WOFFSET                    0x0
#define AHB_GIZMO_USB_0_ENABLE_SPLIT_DEFAULT                    _MK_MASK_CONST(0x1)
#define AHB_GIZMO_USB_0_ENABLE_SPLIT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_GIZMO_USB_0_ENABLE_SPLIT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_ENABLE_SPLIT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_USB_0_ENABLE_SPLIT_DISABLE                    _MK_ENUM_CONST(0)
#define AHB_GIZMO_USB_0_ENABLE_SPLIT_ENABLE                     _MK_ENUM_CONST(1)


// Register AHB_GIZMO_AHB_XBAR_BRIDGE_0  
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0                     _MK_ADDR_CONST(0x20)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_WORD_COUNT                  0x1
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_RESET_VAL                   _MK_MASK_CONST(0x8d)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_RESET_MASK                  _MK_MASK_CONST(0xff)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_READ_MASK                   _MK_MASK_CONST(0xff)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_WRITE_MASK                  _MK_MASK_CONST(0xff)
// AHB slave gizmo - Dont split AHB write transaction.  1 = dont split AHB write transaction ever. 
// 0 (and enable_split=1) = allow AHB write  transaction to be split.
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_DONT_SPLIT_AHB_WR_SHIFT                     _MK_SHIFT_CONST(7)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_DONT_SPLIT_AHB_WR_FIELD                     (_MK_MASK_CONST(0x1) << AHB_GIZMO_AHB_XBAR_BRIDGE_0_DONT_SPLIT_AHB_WR_SHIFT)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_DONT_SPLIT_AHB_WR_RANGE                     7:7
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_DONT_SPLIT_AHB_WR_WOFFSET                   0x0
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_DONT_SPLIT_AHB_WR_DEFAULT                   _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_DONT_SPLIT_AHB_WR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_DONT_SPLIT_AHB_WR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_DONT_SPLIT_AHB_WR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_DONT_SPLIT_AHB_WR_ENABLE                    _MK_ENUM_CONST(0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_DONT_SPLIT_AHB_WR_DISABLE                   _MK_ENUM_CONST(1)

// AHB slave gizmo - Accept AHB write request always.  1 = always accept AHB write 
// request without checking whether there is room in the queue to store the write 
// data. 0 = accept AHB write request only when theres  enough room in the queue 
// to store all the write data.
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ACCEPT_AHB_WR_ALWAYS_SHIFT                  _MK_SHIFT_CONST(6)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ACCEPT_AHB_WR_ALWAYS_FIELD                  (_MK_MASK_CONST(0x1) << AHB_GIZMO_AHB_XBAR_BRIDGE_0_ACCEPT_AHB_WR_ALWAYS_SHIFT)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ACCEPT_AHB_WR_ALWAYS_RANGE                  6:6
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ACCEPT_AHB_WR_ALWAYS_WOFFSET                        0x0
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ACCEPT_AHB_WR_ALWAYS_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ACCEPT_AHB_WR_ALWAYS_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ACCEPT_AHB_WR_ALWAYS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ACCEPT_AHB_WR_ALWAYS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ACCEPT_AHB_WR_ALWAYS_ACCEPT_ON_CHECK                        _MK_ENUM_CONST(0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ACCEPT_AHB_WR_ALWAYS_ACCEPT_ON_NOCHECK                      _MK_ENUM_CONST(1)

// AHB slave gizmo - Maximum allowed IP burst 
// size.  
// 00 = single transfer.  
// 01 = burst-of-4.  
// 10 = burst-of-8.  
// 11 = burst-of-16.
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_MAX_IP_BURSTSIZE_SHIFT                      _MK_SHIFT_CONST(4)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_MAX_IP_BURSTSIZE_FIELD                      (_MK_MASK_CONST(0x3) << AHB_GIZMO_AHB_XBAR_BRIDGE_0_MAX_IP_BURSTSIZE_SHIFT)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_MAX_IP_BURSTSIZE_RANGE                      5:4
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_MAX_IP_BURSTSIZE_WOFFSET                    0x0
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_MAX_IP_BURSTSIZE_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_MAX_IP_BURSTSIZE_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_MAX_IP_BURSTSIZE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_MAX_IP_BURSTSIZE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_MAX_IP_BURSTSIZE_DMA_BURST_1WORDS                   _MK_ENUM_CONST(0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_MAX_IP_BURSTSIZE_DMA_BURST_4WORDS                   _MK_ENUM_CONST(1)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_MAX_IP_BURSTSIZE_DMA_BURST_8WORDS                   _MK_ENUM_CONST(2)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_MAX_IP_BURSTSIZE_DMA_BURST_16WORDS                  _MK_ENUM_CONST(3)

// AHB slave gizmo - Start write request to device immediately.  1 = start write request on the 
// device side as soon as the AHB master puts data into the gizmos queue.  0 = start the device 
// write request only when the  AHB master has placed all write data into the gizmos queue.
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_IMMEDIATE_SHIFT                     _MK_SHIFT_CONST(3)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_IMMEDIATE_FIELD                     (_MK_MASK_CONST(0x1) << AHB_GIZMO_AHB_XBAR_BRIDGE_0_IMMEDIATE_SHIFT)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_IMMEDIATE_RANGE                     3:3
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_IMMEDIATE_WOFFSET                   0x0
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_IMMEDIATE_DEFAULT                   _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_IMMEDIATE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_IMMEDIATE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_IMMEDIATE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_IMMEDIATE_DISABLE                   _MK_ENUM_CONST(0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_IMMEDIATE_ENABLE                    _MK_ENUM_CONST(1)

// AHB slave gizmo - Enable fast re-arbitration.  1 = allow AHB master re-arbitration as soon as 
// the device returns one read data into the gizmos queue.  0 = allow AHB master re-arbitration 
// only when the  device returns all read data into the gizmos queue.
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENB_FAST_REARBITRATE_SHIFT                  _MK_SHIFT_CONST(2)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENB_FAST_REARBITRATE_FIELD                  (_MK_MASK_CONST(0x1) << AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENB_FAST_REARBITRATE_SHIFT)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENB_FAST_REARBITRATE_RANGE                  2:2
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENB_FAST_REARBITRATE_WOFFSET                        0x0
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENB_FAST_REARBITRATE_DEFAULT                        _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENB_FAST_REARBITRATE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENB_FAST_REARBITRATE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENB_FAST_REARBITRATE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENB_FAST_REARBITRATE_DISABLE                        _MK_ENUM_CONST(0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENB_FAST_REARBITRATE_ENABLE                 _MK_ENUM_CONST(1)

// AHB slave gizmo - Force all AHB transaction to single data request transaction.  
// 1 = force to single data transaction always.  
// 0 = dont force to single data  transaction.
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_FORCE_TO_AHB_SINGLE_SHIFT                   _MK_SHIFT_CONST(1)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_FORCE_TO_AHB_SINGLE_FIELD                   (_MK_MASK_CONST(0x1) << AHB_GIZMO_AHB_XBAR_BRIDGE_0_FORCE_TO_AHB_SINGLE_SHIFT)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_FORCE_TO_AHB_SINGLE_RANGE                   1:1
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_FORCE_TO_AHB_SINGLE_WOFFSET                 0x0
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_FORCE_TO_AHB_SINGLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_FORCE_TO_AHB_SINGLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_FORCE_TO_AHB_SINGLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_FORCE_TO_AHB_SINGLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_FORCE_TO_AHB_SINGLE_NOT_SINGLE_DATA                 _MK_ENUM_CONST(0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_FORCE_TO_AHB_SINGLE_SINGLE_DATA                     _MK_ENUM_CONST(1)

// AHB slave gizmo - Enable splitting AHB transactions.  1 = enable 0 = disable
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENABLE_SPLIT_SHIFT                  _MK_SHIFT_CONST(0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENABLE_SPLIT_FIELD                  (_MK_MASK_CONST(0x1) << AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENABLE_SPLIT_SHIFT)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENABLE_SPLIT_RANGE                  0:0
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENABLE_SPLIT_WOFFSET                        0x0
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENABLE_SPLIT_DEFAULT                        _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENABLE_SPLIT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENABLE_SPLIT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENABLE_SPLIT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENABLE_SPLIT_DISABLE                        _MK_ENUM_CONST(0)
#define AHB_GIZMO_AHB_XBAR_BRIDGE_0_ENABLE_SPLIT_ENABLE                 _MK_ENUM_CONST(1)


// Register AHB_GIZMO_CPU_AHB_BRIDGE_0  
#define AHB_GIZMO_CPU_AHB_BRIDGE_0                      _MK_ADDR_CONST(0x24)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_WORD_COUNT                   0x1
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_RESET_VAL                    _MK_MASK_CONST(0x60000)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_RESET_MASK                   _MK_MASK_CONST(0xf0000)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_READ_MASK                    _MK_MASK_CONST(0xf0000)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_WRITE_MASK                   _MK_MASK_CONST(0xf0000)
// AHB master gizmo - Pack all AHB read data.  1 = wait for all requested read data to be in the 
// AHB gizmos queue before returning the data back to the IP.  0 = transfer each read data from 
// the AHB to the IP  immediately.
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_RD_DATA_SHIFT                        _MK_SHIFT_CONST(19)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_RD_DATA_FIELD                        (_MK_MASK_CONST(0x1) << AHB_GIZMO_CPU_AHB_BRIDGE_0_RD_DATA_SHIFT)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_RD_DATA_RANGE                        19:19
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_RD_DATA_WOFFSET                      0x0
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_RD_DATA_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_RD_DATA_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_RD_DATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_RD_DATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_RD_DATA_NO_WAIT                      _MK_ENUM_CONST(0)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_RD_DATA_WAIT                 _MK_ENUM_CONST(1)

// AHB master gizmo (AHB-DMA) - Start AHB write request immediately.  1 = start the AHB write 
// request immediately as soon as the device  has put one write data in the AHB gizmos queue.  
// 0 = start the AHB write request only when all the  write data has transferred from the 
// device to the AHB gizmos queue.
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_IMMEDIATE_SHIFT                      _MK_SHIFT_CONST(18)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_IMMEDIATE_FIELD                      (_MK_MASK_CONST(0x1) << AHB_GIZMO_CPU_AHB_BRIDGE_0_IMMEDIATE_SHIFT)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_IMMEDIATE_RANGE                      18:18
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_IMMEDIATE_WOFFSET                    0x0
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_IMMEDIATE_DEFAULT                    _MK_MASK_CONST(0x1)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_IMMEDIATE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_IMMEDIATE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_IMMEDIATE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_IMMEDIATE_DISABLE                    _MK_ENUM_CONST(0)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_IMMEDIATE_ENABLE                     _MK_ENUM_CONST(1)

// AHB master gizmo - Maximum allowed AHB 
// burst size.  
// 00 = single transfer.  
// 01 = burst-of-4.  
// 10 = burst-of-8.  
// 11 = burst-of-16.
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_SHIFT                      _MK_SHIFT_CONST(16)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_FIELD                      (_MK_MASK_CONST(0x3) << AHB_GIZMO_CPU_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_SHIFT)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_RANGE                      17:16
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_WOFFSET                    0x0
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_DEFAULT                    _MK_MASK_CONST(0x2)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_DMA_BURST_1WORDS                   _MK_ENUM_CONST(0)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_DMA_BURST_4WORDS                   _MK_ENUM_CONST(1)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_DMA_BURST_8WORDS                   _MK_ENUM_CONST(2)
#define AHB_GIZMO_CPU_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_DMA_BURST_16WORDS                  _MK_ENUM_CONST(3)


// Register AHB_GIZMO_COP_AHB_BRIDGE_0  
#define AHB_GIZMO_COP_AHB_BRIDGE_0                      _MK_ADDR_CONST(0x28)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_WORD_COUNT                   0x1
#define AHB_GIZMO_COP_AHB_BRIDGE_0_RESET_VAL                    _MK_MASK_CONST(0x60000)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_RESET_MASK                   _MK_MASK_CONST(0xf0000)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_READ_MASK                    _MK_MASK_CONST(0xf0000)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_WRITE_MASK                   _MK_MASK_CONST(0xf0000)
// AHB master gizmo - Pack all AHB read data.  1 = wait for all requested read data to be in the 
// AHB gizmos queue before returning the data back to the IP.  0 = transfer each read data from 
// the AHB to the IP  immediately.
#define AHB_GIZMO_COP_AHB_BRIDGE_0_RD_DATA_SHIFT                        _MK_SHIFT_CONST(19)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_RD_DATA_FIELD                        (_MK_MASK_CONST(0x1) << AHB_GIZMO_COP_AHB_BRIDGE_0_RD_DATA_SHIFT)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_RD_DATA_RANGE                        19:19
#define AHB_GIZMO_COP_AHB_BRIDGE_0_RD_DATA_WOFFSET                      0x0
#define AHB_GIZMO_COP_AHB_BRIDGE_0_RD_DATA_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_RD_DATA_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_RD_DATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_RD_DATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_RD_DATA_NO_WAIT                      _MK_ENUM_CONST(0)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_RD_DATA_WAIT                 _MK_ENUM_CONST(1)

// AHB master gizmo (AHB-DMA) - Start AHB write request immediately.  1 = start the AHB write 
// request immediately as soon as the device  has put one write data in the AHB gizmos queue.  
// 0 = start the AHB write request only when all the  write data has transferred from the 
// device to the AHB gizmos queue.
#define AHB_GIZMO_COP_AHB_BRIDGE_0_IMMEDIATE_SHIFT                      _MK_SHIFT_CONST(18)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_IMMEDIATE_FIELD                      (_MK_MASK_CONST(0x1) << AHB_GIZMO_COP_AHB_BRIDGE_0_IMMEDIATE_SHIFT)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_IMMEDIATE_RANGE                      18:18
#define AHB_GIZMO_COP_AHB_BRIDGE_0_IMMEDIATE_WOFFSET                    0x0
#define AHB_GIZMO_COP_AHB_BRIDGE_0_IMMEDIATE_DEFAULT                    _MK_MASK_CONST(0x1)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_IMMEDIATE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_IMMEDIATE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_IMMEDIATE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_IMMEDIATE_DISABLE                    _MK_ENUM_CONST(0)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_IMMEDIATE_ENABLE                     _MK_ENUM_CONST(1)

// AHB master gizmo - Maximum allowed AHB 
// burst size.  
// 00 = single transfer.  
// 01 = burst-of-4.  
// 10 = burst-of-8.  
// 11 = burst-of-16.
#define AHB_GIZMO_COP_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_SHIFT                      _MK_SHIFT_CONST(16)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_FIELD                      (_MK_MASK_CONST(0x3) << AHB_GIZMO_COP_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_SHIFT)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_RANGE                      17:16
#define AHB_GIZMO_COP_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_WOFFSET                    0x0
#define AHB_GIZMO_COP_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_DEFAULT                    _MK_MASK_CONST(0x2)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_DMA_BURST_1WORDS                   _MK_ENUM_CONST(0)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_DMA_BURST_4WORDS                   _MK_ENUM_CONST(1)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_DMA_BURST_8WORDS                   _MK_ENUM_CONST(2)
#define AHB_GIZMO_COP_AHB_BRIDGE_0_MAX_AHB_BURSTSIZE_DMA_BURST_16WORDS                  _MK_ENUM_CONST(3)


// Register AHB_GIZMO_XBAR_APB_CTLR_0  
#define AHB_GIZMO_XBAR_APB_CTLR_0                       _MK_ADDR_CONST(0x2c)
#define AHB_GIZMO_XBAR_APB_CTLR_0_WORD_COUNT                    0x1
#define AHB_GIZMO_XBAR_APB_CTLR_0_RESET_VAL                     _MK_MASK_CONST(0x8)
#define AHB_GIZMO_XBAR_APB_CTLR_0_RESET_MASK                    _MK_MASK_CONST(0x38)
#define AHB_GIZMO_XBAR_APB_CTLR_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XBAR_APB_CTLR_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XBAR_APB_CTLR_0_READ_MASK                     _MK_MASK_CONST(0x38)
#define AHB_GIZMO_XBAR_APB_CTLR_0_WRITE_MASK                    _MK_MASK_CONST(0x38)
// AHB slave gizmo - Maximum allowed IP 
// burst size.  
// 00 = single transfer.  
// 01 = burst-of-4.  
// 10 = burst-of-8.  
// 11 = burst-of-16.
#define AHB_GIZMO_XBAR_APB_CTLR_0_MAX_IP_BURSTSIZE_SHIFT                        _MK_SHIFT_CONST(4)
#define AHB_GIZMO_XBAR_APB_CTLR_0_MAX_IP_BURSTSIZE_FIELD                        (_MK_MASK_CONST(0x3) << AHB_GIZMO_XBAR_APB_CTLR_0_MAX_IP_BURSTSIZE_SHIFT)
#define AHB_GIZMO_XBAR_APB_CTLR_0_MAX_IP_BURSTSIZE_RANGE                        5:4
#define AHB_GIZMO_XBAR_APB_CTLR_0_MAX_IP_BURSTSIZE_WOFFSET                      0x0
#define AHB_GIZMO_XBAR_APB_CTLR_0_MAX_IP_BURSTSIZE_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XBAR_APB_CTLR_0_MAX_IP_BURSTSIZE_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define AHB_GIZMO_XBAR_APB_CTLR_0_MAX_IP_BURSTSIZE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XBAR_APB_CTLR_0_MAX_IP_BURSTSIZE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XBAR_APB_CTLR_0_MAX_IP_BURSTSIZE_DMA_BURST_1WORDS                     _MK_ENUM_CONST(0)
#define AHB_GIZMO_XBAR_APB_CTLR_0_MAX_IP_BURSTSIZE_DMA_BURST_4WORDS                     _MK_ENUM_CONST(1)
#define AHB_GIZMO_XBAR_APB_CTLR_0_MAX_IP_BURSTSIZE_DMA_BURST_8WORDS                     _MK_ENUM_CONST(2)
#define AHB_GIZMO_XBAR_APB_CTLR_0_MAX_IP_BURSTSIZE_DMA_BURST_16WORDS                    _MK_ENUM_CONST(3)

// AHB slave gizmo - Start write request to device immediately.  1 = start write request on 
// the device side as soon as the AHB master puts data into the gizmos queue.  0 = start 
// the device write request only when the  AHB master has placed all write data into the 
// gizmos queue.
#define AHB_GIZMO_XBAR_APB_CTLR_0_IMMEDIATE_SHIFT                       _MK_SHIFT_CONST(3)
#define AHB_GIZMO_XBAR_APB_CTLR_0_IMMEDIATE_FIELD                       (_MK_MASK_CONST(0x1) << AHB_GIZMO_XBAR_APB_CTLR_0_IMMEDIATE_SHIFT)
#define AHB_GIZMO_XBAR_APB_CTLR_0_IMMEDIATE_RANGE                       3:3
#define AHB_GIZMO_XBAR_APB_CTLR_0_IMMEDIATE_WOFFSET                     0x0
#define AHB_GIZMO_XBAR_APB_CTLR_0_IMMEDIATE_DEFAULT                     _MK_MASK_CONST(0x1)
#define AHB_GIZMO_XBAR_APB_CTLR_0_IMMEDIATE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AHB_GIZMO_XBAR_APB_CTLR_0_IMMEDIATE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XBAR_APB_CTLR_0_IMMEDIATE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XBAR_APB_CTLR_0_IMMEDIATE_DISABLE                     _MK_ENUM_CONST(0)
#define AHB_GIZMO_XBAR_APB_CTLR_0_IMMEDIATE_ENABLE                      _MK_ENUM_CONST(1)


// Reserved address 48 [0x30] 

// Reserved address 52 [0x34] 

// Reserved address 56 [0x38] 

// Register AHB_GIZMO_NAND_0  
#define AHB_GIZMO_NAND_0                        _MK_ADDR_CONST(0x3c)
#define AHB_GIZMO_NAND_0_WORD_COUNT                     0x1
#define AHB_GIZMO_NAND_0_RESET_VAL                      _MK_MASK_CONST(0xa0000)
#define AHB_GIZMO_NAND_0_RESET_MASK                     _MK_MASK_CONST(0xff0f0000)
#define AHB_GIZMO_NAND_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NAND_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NAND_0_READ_MASK                      _MK_MASK_CONST(0xff0f0000)
#define AHB_GIZMO_NAND_0_WRITE_MASK                     _MK_MASK_CONST(0xff0f0000)
// AHB master request negate count. This is an 8-bit  counter use to indicate the minimum number of clk count 
// between requests from  this AHB master.
#define AHB_GIZMO_NAND_0_REQ_NEG_CNT_SHIFT                      _MK_SHIFT_CONST(24)
#define AHB_GIZMO_NAND_0_REQ_NEG_CNT_FIELD                      (_MK_MASK_CONST(0xff) << AHB_GIZMO_NAND_0_REQ_NEG_CNT_SHIFT)
#define AHB_GIZMO_NAND_0_REQ_NEG_CNT_RANGE                      31:24
#define AHB_GIZMO_NAND_0_REQ_NEG_CNT_WOFFSET                    0x0
#define AHB_GIZMO_NAND_0_REQ_NEG_CNT_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NAND_0_REQ_NEG_CNT_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define AHB_GIZMO_NAND_0_REQ_NEG_CNT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NAND_0_REQ_NEG_CNT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// AHB master gizmo - Pack all AHB read data.  1 = wait for all requested read data to be 
// in the AHB gizmos queue before returning the data back to the IP.  0 = transfer each read 
// data from the AHB to the IP  immediately.
#define AHB_GIZMO_NAND_0_RD_DATA_SHIFT                  _MK_SHIFT_CONST(19)
#define AHB_GIZMO_NAND_0_RD_DATA_FIELD                  (_MK_MASK_CONST(0x1) << AHB_GIZMO_NAND_0_RD_DATA_SHIFT)
#define AHB_GIZMO_NAND_0_RD_DATA_RANGE                  19:19
#define AHB_GIZMO_NAND_0_RD_DATA_WOFFSET                        0x0
#define AHB_GIZMO_NAND_0_RD_DATA_DEFAULT                        _MK_MASK_CONST(0x1)
#define AHB_GIZMO_NAND_0_RD_DATA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AHB_GIZMO_NAND_0_RD_DATA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NAND_0_RD_DATA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NAND_0_RD_DATA_NO_WAIT                        _MK_ENUM_CONST(0)
#define AHB_GIZMO_NAND_0_RD_DATA_WAIT                   _MK_ENUM_CONST(1)

// AHB master gizmo (AHB-DMA) - Start AHB write request immediately.  1 = start the AHB 
// write request immediately as soon as the device  has put one write data in the AHB 
// gizmos queue.  0 = start the AHB write request only when all the  write data has 
// transferred from the device to the AHB gizmos queue.
#define AHB_GIZMO_NAND_0_IMMEDIATE_SHIFT                        _MK_SHIFT_CONST(18)
#define AHB_GIZMO_NAND_0_IMMEDIATE_FIELD                        (_MK_MASK_CONST(0x1) << AHB_GIZMO_NAND_0_IMMEDIATE_SHIFT)
#define AHB_GIZMO_NAND_0_IMMEDIATE_RANGE                        18:18
#define AHB_GIZMO_NAND_0_IMMEDIATE_WOFFSET                      0x0
#define AHB_GIZMO_NAND_0_IMMEDIATE_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NAND_0_IMMEDIATE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AHB_GIZMO_NAND_0_IMMEDIATE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NAND_0_IMMEDIATE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NAND_0_IMMEDIATE_DISABLE                      _MK_ENUM_CONST(0)
#define AHB_GIZMO_NAND_0_IMMEDIATE_ENABLE                       _MK_ENUM_CONST(1)

// AHB master gizmo - Maximum allowed 
// AHB burst size.  
// 00 = single transfer.  
// 01 = burst-of-4.  
// 10 = burst-of-8.  
// 11 = burst-of-16.
#define AHB_GIZMO_NAND_0_MAX_AHB_BURSTSIZE_SHIFT                        _MK_SHIFT_CONST(16)
#define AHB_GIZMO_NAND_0_MAX_AHB_BURSTSIZE_FIELD                        (_MK_MASK_CONST(0x3) << AHB_GIZMO_NAND_0_MAX_AHB_BURSTSIZE_SHIFT)
#define AHB_GIZMO_NAND_0_MAX_AHB_BURSTSIZE_RANGE                        17:16
#define AHB_GIZMO_NAND_0_MAX_AHB_BURSTSIZE_WOFFSET                      0x0
#define AHB_GIZMO_NAND_0_MAX_AHB_BURSTSIZE_DEFAULT                      _MK_MASK_CONST(0x2)
#define AHB_GIZMO_NAND_0_MAX_AHB_BURSTSIZE_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define AHB_GIZMO_NAND_0_MAX_AHB_BURSTSIZE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NAND_0_MAX_AHB_BURSTSIZE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NAND_0_MAX_AHB_BURSTSIZE_DMA_BURST_1WORDS                     _MK_ENUM_CONST(0)
#define AHB_GIZMO_NAND_0_MAX_AHB_BURSTSIZE_DMA_BURST_4WORDS                     _MK_ENUM_CONST(1)
#define AHB_GIZMO_NAND_0_MAX_AHB_BURSTSIZE_DMA_BURST_8WORDS                     _MK_ENUM_CONST(2)
#define AHB_GIZMO_NAND_0_MAX_AHB_BURSTSIZE_DMA_BURST_16WORDS                    _MK_ENUM_CONST(3)


// Reserved address 64 [0x40] 

// Register AHB_GIZMO_HSMMC1_0  
#define AHB_GIZMO_HSMMC1_0                      _MK_ADDR_CONST(0x44)
#define AHB_GIZMO_HSMMC1_0_WORD_COUNT                   0x1
#define AHB_GIZMO_HSMMC1_0_RESET_VAL                    _MK_MASK_CONST(0x40000)
#define AHB_GIZMO_HSMMC1_0_RESET_MASK                   _MK_MASK_CONST(0xff040000)
#define AHB_GIZMO_HSMMC1_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_HSMMC1_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_HSMMC1_0_READ_MASK                    _MK_MASK_CONST(0xff040000)
#define AHB_GIZMO_HSMMC1_0_WRITE_MASK                   _MK_MASK_CONST(0xff040000)
// AHB master request negate count. This is an 8-bit  counter use to indicate the minimum number of clk count 
// between requests from  this AHB master.
#define AHB_GIZMO_HSMMC1_0_REQ_NEG_CNT_SHIFT                    _MK_SHIFT_CONST(24)
#define AHB_GIZMO_HSMMC1_0_REQ_NEG_CNT_FIELD                    (_MK_MASK_CONST(0xff) << AHB_GIZMO_HSMMC1_0_REQ_NEG_CNT_SHIFT)
#define AHB_GIZMO_HSMMC1_0_REQ_NEG_CNT_RANGE                    31:24
#define AHB_GIZMO_HSMMC1_0_REQ_NEG_CNT_WOFFSET                  0x0
#define AHB_GIZMO_HSMMC1_0_REQ_NEG_CNT_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_GIZMO_HSMMC1_0_REQ_NEG_CNT_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define AHB_GIZMO_HSMMC1_0_REQ_NEG_CNT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_HSMMC1_0_REQ_NEG_CNT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// AHB master gizmo (AHB-DMA) - Start AHB write request immediately.  1 = start the AHB 
// write request immediately as soon as the device  has put one write data in the AHB 
// gizmos queue.  0 = start the AHB write request only when all the  write data has 
// transferred from the device to the AHB gizmos queue.
#define AHB_GIZMO_HSMMC1_0_IMMEDIATE_SHIFT                      _MK_SHIFT_CONST(18)
#define AHB_GIZMO_HSMMC1_0_IMMEDIATE_FIELD                      (_MK_MASK_CONST(0x1) << AHB_GIZMO_HSMMC1_0_IMMEDIATE_SHIFT)
#define AHB_GIZMO_HSMMC1_0_IMMEDIATE_RANGE                      18:18
#define AHB_GIZMO_HSMMC1_0_IMMEDIATE_WOFFSET                    0x0
#define AHB_GIZMO_HSMMC1_0_IMMEDIATE_DEFAULT                    _MK_MASK_CONST(0x1)
#define AHB_GIZMO_HSMMC1_0_IMMEDIATE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_GIZMO_HSMMC1_0_IMMEDIATE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_HSMMC1_0_IMMEDIATE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_HSMMC1_0_IMMEDIATE_DISABLE                    _MK_ENUM_CONST(0)
#define AHB_GIZMO_HSMMC1_0_IMMEDIATE_ENABLE                     _MK_ENUM_CONST(1)


// Register AHB_GIZMO_XIO_0  
#define AHB_GIZMO_XIO_0                 _MK_ADDR_CONST(0x48)
#define AHB_GIZMO_XIO_0_WORD_COUNT                      0x1
#define AHB_GIZMO_XIO_0_RESET_VAL                       _MK_MASK_CONST(0x40000)
#define AHB_GIZMO_XIO_0_RESET_MASK                      _MK_MASK_CONST(0xff0f0000)
#define AHB_GIZMO_XIO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XIO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XIO_0_READ_MASK                       _MK_MASK_CONST(0xff0f0000)
#define AHB_GIZMO_XIO_0_WRITE_MASK                      _MK_MASK_CONST(0xff0f0000)
// AHB master request negate count. This is an 8-bit  counter use to indicate the minimum number of clk count 
// between requests from  this AHB master.
#define AHB_GIZMO_XIO_0_REQ_NEG_CNT_SHIFT                       _MK_SHIFT_CONST(24)
#define AHB_GIZMO_XIO_0_REQ_NEG_CNT_FIELD                       (_MK_MASK_CONST(0xff) << AHB_GIZMO_XIO_0_REQ_NEG_CNT_SHIFT)
#define AHB_GIZMO_XIO_0_REQ_NEG_CNT_RANGE                       31:24
#define AHB_GIZMO_XIO_0_REQ_NEG_CNT_WOFFSET                     0x0
#define AHB_GIZMO_XIO_0_REQ_NEG_CNT_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XIO_0_REQ_NEG_CNT_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define AHB_GIZMO_XIO_0_REQ_NEG_CNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XIO_0_REQ_NEG_CNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// AHB master gizmo - Pack all AHB read data.  1 = wait for all requested read data to be 
// in the AHB gizmos queue before returning the data back to the IP.  0 = transfer each read 
// data from the AHB to the IP  immediately.
#define AHB_GIZMO_XIO_0_RD_DATA_SHIFT                   _MK_SHIFT_CONST(19)
#define AHB_GIZMO_XIO_0_RD_DATA_FIELD                   (_MK_MASK_CONST(0x1) << AHB_GIZMO_XIO_0_RD_DATA_SHIFT)
#define AHB_GIZMO_XIO_0_RD_DATA_RANGE                   19:19
#define AHB_GIZMO_XIO_0_RD_DATA_WOFFSET                 0x0
#define AHB_GIZMO_XIO_0_RD_DATA_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XIO_0_RD_DATA_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define AHB_GIZMO_XIO_0_RD_DATA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XIO_0_RD_DATA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XIO_0_RD_DATA_NO_WAIT                 _MK_ENUM_CONST(0)
#define AHB_GIZMO_XIO_0_RD_DATA_WAIT                    _MK_ENUM_CONST(1)

// AHB master gizmo (AHB-DMA) - Start AHB write request immediately.  1 = start the AHB 
// write request immediately as soon as the device  has put one write data in the AHB 
// gizmos queue.  0 = start the AHB write request only when all the  write data has 
// transferred from the device to the AHB gizmos queue.
#define AHB_GIZMO_XIO_0_IMMEDIATE_SHIFT                 _MK_SHIFT_CONST(18)
#define AHB_GIZMO_XIO_0_IMMEDIATE_FIELD                 (_MK_MASK_CONST(0x1) << AHB_GIZMO_XIO_0_IMMEDIATE_SHIFT)
#define AHB_GIZMO_XIO_0_IMMEDIATE_RANGE                 18:18
#define AHB_GIZMO_XIO_0_IMMEDIATE_WOFFSET                       0x0
#define AHB_GIZMO_XIO_0_IMMEDIATE_DEFAULT                       _MK_MASK_CONST(0x1)
#define AHB_GIZMO_XIO_0_IMMEDIATE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AHB_GIZMO_XIO_0_IMMEDIATE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XIO_0_IMMEDIATE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XIO_0_IMMEDIATE_DISABLE                       _MK_ENUM_CONST(0)
#define AHB_GIZMO_XIO_0_IMMEDIATE_ENABLE                        _MK_ENUM_CONST(1)

// AHB master gizmo - Maximum allowed 
// AHB burst size.  
// 00 = single transfer.  
// 01 = burst-of-4.  
// 10 = burst-of-8.  
// 11 = burst-of-16.
#define AHB_GIZMO_XIO_0_MAX_AHB_BURSTSIZE_SHIFT                 _MK_SHIFT_CONST(16)
#define AHB_GIZMO_XIO_0_MAX_AHB_BURSTSIZE_FIELD                 (_MK_MASK_CONST(0x3) << AHB_GIZMO_XIO_0_MAX_AHB_BURSTSIZE_SHIFT)
#define AHB_GIZMO_XIO_0_MAX_AHB_BURSTSIZE_RANGE                 17:16
#define AHB_GIZMO_XIO_0_MAX_AHB_BURSTSIZE_WOFFSET                       0x0
#define AHB_GIZMO_XIO_0_MAX_AHB_BURSTSIZE_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XIO_0_MAX_AHB_BURSTSIZE_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define AHB_GIZMO_XIO_0_MAX_AHB_BURSTSIZE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XIO_0_MAX_AHB_BURSTSIZE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_XIO_0_MAX_AHB_BURSTSIZE_DMA_BURST_1WORDS                      _MK_ENUM_CONST(0)
#define AHB_GIZMO_XIO_0_MAX_AHB_BURSTSIZE_DMA_BURST_4WORDS                      _MK_ENUM_CONST(1)
#define AHB_GIZMO_XIO_0_MAX_AHB_BURSTSIZE_DMA_BURST_8WORDS                      _MK_ENUM_CONST(2)
#define AHB_GIZMO_XIO_0_MAX_AHB_BURSTSIZE_DMA_BURST_16WORDS                     _MK_ENUM_CONST(3)


// Reserved address 76 [0x4c] 

// Reserved address 80 [0x50] 

// Reserved address 84 [0x54] 

// Reserved address 88 [0x58] 

// Reserved address 92 [0x5c] 

// Register AHB_GIZMO_BSEV_0  
#define AHB_GIZMO_BSEV_0                        _MK_ADDR_CONST(0x60)
#define AHB_GIZMO_BSEV_0_WORD_COUNT                     0x1
#define AHB_GIZMO_BSEV_0_RESET_VAL                      _MK_MASK_CONST(0x20000)
#define AHB_GIZMO_BSEV_0_RESET_MASK                     _MK_MASK_CONST(0xff0f0000)
#define AHB_GIZMO_BSEV_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEV_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEV_0_READ_MASK                      _MK_MASK_CONST(0xff0f0000)
#define AHB_GIZMO_BSEV_0_WRITE_MASK                     _MK_MASK_CONST(0xff0f0000)
// AHB master request negate count. This is an 8-bit  counter use to indicate the minimum number of clk count 
// between requests from  this AHB master.
#define AHB_GIZMO_BSEV_0_REQ_NEG_CNT_SHIFT                      _MK_SHIFT_CONST(24)
#define AHB_GIZMO_BSEV_0_REQ_NEG_CNT_FIELD                      (_MK_MASK_CONST(0xff) << AHB_GIZMO_BSEV_0_REQ_NEG_CNT_SHIFT)
#define AHB_GIZMO_BSEV_0_REQ_NEG_CNT_RANGE                      31:24
#define AHB_GIZMO_BSEV_0_REQ_NEG_CNT_WOFFSET                    0x0
#define AHB_GIZMO_BSEV_0_REQ_NEG_CNT_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEV_0_REQ_NEG_CNT_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define AHB_GIZMO_BSEV_0_REQ_NEG_CNT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEV_0_REQ_NEG_CNT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// AHB master gizmo - Pack all AHB read data.  1 = wait for all requested read data to be 
// in the AHB gizmos queue before returning the data back to the IP.  0 = transfer each read 
// data from the AHB to the IP  immediately.
#define AHB_GIZMO_BSEV_0_RD_DATA_SHIFT                  _MK_SHIFT_CONST(19)
#define AHB_GIZMO_BSEV_0_RD_DATA_FIELD                  (_MK_MASK_CONST(0x1) << AHB_GIZMO_BSEV_0_RD_DATA_SHIFT)
#define AHB_GIZMO_BSEV_0_RD_DATA_RANGE                  19:19
#define AHB_GIZMO_BSEV_0_RD_DATA_WOFFSET                        0x0
#define AHB_GIZMO_BSEV_0_RD_DATA_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEV_0_RD_DATA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AHB_GIZMO_BSEV_0_RD_DATA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEV_0_RD_DATA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEV_0_RD_DATA_NO_WAIT                        _MK_ENUM_CONST(0)
#define AHB_GIZMO_BSEV_0_RD_DATA_WAIT                   _MK_ENUM_CONST(1)

// AHB master gizmo (AHB-DMA) - Start AHB write request immediately.  1 = start the AHB 
// write request immediately as soon as the device  has put one write data in the AHB 
// gizmos queue.  0 = start the AHB write request only when all the  write data has 
// transferred from the device to the AHB gizmos queue. !!THIS SHOULD NEVER BE SET TO 
// ENABLE!! (BSEV requires this bit to be 0) 
#define AHB_GIZMO_BSEV_0_IMMEDIATE_SHIFT                        _MK_SHIFT_CONST(18)
#define AHB_GIZMO_BSEV_0_IMMEDIATE_FIELD                        (_MK_MASK_CONST(0x1) << AHB_GIZMO_BSEV_0_IMMEDIATE_SHIFT)
#define AHB_GIZMO_BSEV_0_IMMEDIATE_RANGE                        18:18
#define AHB_GIZMO_BSEV_0_IMMEDIATE_WOFFSET                      0x0
#define AHB_GIZMO_BSEV_0_IMMEDIATE_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEV_0_IMMEDIATE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AHB_GIZMO_BSEV_0_IMMEDIATE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEV_0_IMMEDIATE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEV_0_IMMEDIATE_DISABLE                      _MK_ENUM_CONST(0)
#define AHB_GIZMO_BSEV_0_IMMEDIATE_ENABLE                       _MK_ENUM_CONST(1)

// AHB master gizmo - Maximum 
// allowed AHB burst size.  
// 00 = single transfer.  
// 01 = burst-of-4.  
// 10 = burst-of-8.
// 11 = burst-of-16.
#define AHB_GIZMO_BSEV_0_MAX_AHB_BURSTSIZE_SHIFT                        _MK_SHIFT_CONST(16)
#define AHB_GIZMO_BSEV_0_MAX_AHB_BURSTSIZE_FIELD                        (_MK_MASK_CONST(0x3) << AHB_GIZMO_BSEV_0_MAX_AHB_BURSTSIZE_SHIFT)
#define AHB_GIZMO_BSEV_0_MAX_AHB_BURSTSIZE_RANGE                        17:16
#define AHB_GIZMO_BSEV_0_MAX_AHB_BURSTSIZE_WOFFSET                      0x0
#define AHB_GIZMO_BSEV_0_MAX_AHB_BURSTSIZE_DEFAULT                      _MK_MASK_CONST(0x2)
#define AHB_GIZMO_BSEV_0_MAX_AHB_BURSTSIZE_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define AHB_GIZMO_BSEV_0_MAX_AHB_BURSTSIZE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEV_0_MAX_AHB_BURSTSIZE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEV_0_MAX_AHB_BURSTSIZE_DMA_BURST_1WORDS                     _MK_ENUM_CONST(0)
#define AHB_GIZMO_BSEV_0_MAX_AHB_BURSTSIZE_DMA_BURST_4WORDS                     _MK_ENUM_CONST(1)
#define AHB_GIZMO_BSEV_0_MAX_AHB_BURSTSIZE_DMA_BURST_8WORDS                     _MK_ENUM_CONST(2)
#define AHB_GIZMO_BSEV_0_MAX_AHB_BURSTSIZE_DMA_BURST_16WORDS                    _MK_ENUM_CONST(3)


// Reserved address 100 [0x64] 

// Reserved address 104 [0x68] 

// Reserved address 108 [0x6c] 

// Register AHB_GIZMO_BSEA_0  
#define AHB_GIZMO_BSEA_0                        _MK_ADDR_CONST(0x70)
#define AHB_GIZMO_BSEA_0_WORD_COUNT                     0x1
#define AHB_GIZMO_BSEA_0_RESET_VAL                      _MK_MASK_CONST(0x20000)
#define AHB_GIZMO_BSEA_0_RESET_MASK                     _MK_MASK_CONST(0xff070000)
#define AHB_GIZMO_BSEA_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEA_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEA_0_READ_MASK                      _MK_MASK_CONST(0xff070000)
#define AHB_GIZMO_BSEA_0_WRITE_MASK                     _MK_MASK_CONST(0xff070000)
// AHB master request negate count. This is an 8-bit  counter use to indicate the minimum number of clk count 
// between requests from  this AHB master.
#define AHB_GIZMO_BSEA_0_REQ_NEG_CNT_SHIFT                      _MK_SHIFT_CONST(24)
#define AHB_GIZMO_BSEA_0_REQ_NEG_CNT_FIELD                      (_MK_MASK_CONST(0xff) << AHB_GIZMO_BSEA_0_REQ_NEG_CNT_SHIFT)
#define AHB_GIZMO_BSEA_0_REQ_NEG_CNT_RANGE                      31:24
#define AHB_GIZMO_BSEA_0_REQ_NEG_CNT_WOFFSET                    0x0
#define AHB_GIZMO_BSEA_0_REQ_NEG_CNT_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEA_0_REQ_NEG_CNT_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define AHB_GIZMO_BSEA_0_REQ_NEG_CNT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEA_0_REQ_NEG_CNT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// AHB master gizmo - Start AHB write request immediately.  1 = start the AHB 
// write request immediately as soon as the device puts data in the AHB gizmos 
// queue.  0 = start the AHB write request only when all the  write data has 
// transferred from the device to the AHB gizmos queue.  !!THIS SHOULD NEVER BE 
// SET TO ENABLE!! (BSEV requires this bit to be 0) 
#define AHB_GIZMO_BSEA_0_IMMEDIATE_SHIFT                        _MK_SHIFT_CONST(18)
#define AHB_GIZMO_BSEA_0_IMMEDIATE_FIELD                        (_MK_MASK_CONST(0x1) << AHB_GIZMO_BSEA_0_IMMEDIATE_SHIFT)
#define AHB_GIZMO_BSEA_0_IMMEDIATE_RANGE                        18:18
#define AHB_GIZMO_BSEA_0_IMMEDIATE_WOFFSET                      0x0
#define AHB_GIZMO_BSEA_0_IMMEDIATE_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEA_0_IMMEDIATE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AHB_GIZMO_BSEA_0_IMMEDIATE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEA_0_IMMEDIATE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEA_0_IMMEDIATE_DISABLE                      _MK_ENUM_CONST(0)
#define AHB_GIZMO_BSEA_0_IMMEDIATE_ENABLE                       _MK_ENUM_CONST(1)

// AHB master gizmo - Maximum 
// allowed AHB burst size.  
// 00 = single transfer.  
// 01 = burst-of-4.  
// 10 = burst-of-8.  
// 11 = burst-of-16.
#define AHB_GIZMO_BSEA_0_MAX_AHB_BURSTSIZE_SHIFT                        _MK_SHIFT_CONST(16)
#define AHB_GIZMO_BSEA_0_MAX_AHB_BURSTSIZE_FIELD                        (_MK_MASK_CONST(0x3) << AHB_GIZMO_BSEA_0_MAX_AHB_BURSTSIZE_SHIFT)
#define AHB_GIZMO_BSEA_0_MAX_AHB_BURSTSIZE_RANGE                        17:16
#define AHB_GIZMO_BSEA_0_MAX_AHB_BURSTSIZE_WOFFSET                      0x0
#define AHB_GIZMO_BSEA_0_MAX_AHB_BURSTSIZE_DEFAULT                      _MK_MASK_CONST(0x2)
#define AHB_GIZMO_BSEA_0_MAX_AHB_BURSTSIZE_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define AHB_GIZMO_BSEA_0_MAX_AHB_BURSTSIZE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEA_0_MAX_AHB_BURSTSIZE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define AHB_GIZMO_BSEA_0_MAX_AHB_BURSTSIZE_DMA_BURST_1WORDS                     _MK_ENUM_CONST(0)
#define AHB_GIZMO_BSEA_0_MAX_AHB_BURSTSIZE_DMA_BURST_4WORDS                     _MK_ENUM_CONST(1)
#define AHB_GIZMO_BSEA_0_MAX_AHB_BURSTSIZE_DMA_BURST_8WORDS                     _MK_ENUM_CONST(2)
#define AHB_GIZMO_BSEA_0_MAX_AHB_BURSTSIZE_DMA_BURST_16WORDS                    _MK_ENUM_CONST(3)


// Register AHB_GIZMO_NOR_0  
#define AHB_GIZMO_NOR_0                 _MK_ADDR_CONST(0x74)
#define AHB_GIZMO_NOR_0_WORD_COUNT                      0x1
#define AHB_GIZMO_NOR_0_RESET_VAL                       _MK_MASK_CONST(0x85)
#define AHB_GIZMO_NOR_0_RESET_MASK                      _MK_MASK_CONST(0xc7)
#define AHB_GIZMO_NOR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NOR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NOR_0_READ_MASK                       _MK_MASK_CONST(0xc7)
#define AHB_GIZMO_NOR_0_WRITE_MASK                      _MK_MASK_CONST(0xc7)
// AHB slave gizmo - Dont split AHB write transaction.  1 = dont split AHB 
// write transaction ever. 0 (and enable_split=1) = allow AHB write  
// transaction to be split.
#define AHB_GIZMO_NOR_0_DONT_SPLIT_AHB_WR_SHIFT                 _MK_SHIFT_CONST(7)
#define AHB_GIZMO_NOR_0_DONT_SPLIT_AHB_WR_FIELD                 (_MK_MASK_CONST(0x1) << AHB_GIZMO_NOR_0_DONT_SPLIT_AHB_WR_SHIFT)
#define AHB_GIZMO_NOR_0_DONT_SPLIT_AHB_WR_RANGE                 7:7
#define AHB_GIZMO_NOR_0_DONT_SPLIT_AHB_WR_WOFFSET                       0x0
#define AHB_GIZMO_NOR_0_DONT_SPLIT_AHB_WR_DEFAULT                       _MK_MASK_CONST(0x1)
#define AHB_GIZMO_NOR_0_DONT_SPLIT_AHB_WR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AHB_GIZMO_NOR_0_DONT_SPLIT_AHB_WR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NOR_0_DONT_SPLIT_AHB_WR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NOR_0_DONT_SPLIT_AHB_WR_ENABLE                        _MK_ENUM_CONST(0)
#define AHB_GIZMO_NOR_0_DONT_SPLIT_AHB_WR_DISABLE                       _MK_ENUM_CONST(1)

// AHB slave gizmo - Accept AHB write request always.  
// 1 = always accept AHB write request without checking whether 
// there is room in the queue to store the write data. 0 = accept 
// AHB write request only when theres  enough room in the queue 
// to store all the write data.
#define AHB_GIZMO_NOR_0_ACCEPT_AHB_WR_ALWAYS_SHIFT                      _MK_SHIFT_CONST(6)
#define AHB_GIZMO_NOR_0_ACCEPT_AHB_WR_ALWAYS_FIELD                      (_MK_MASK_CONST(0x1) << AHB_GIZMO_NOR_0_ACCEPT_AHB_WR_ALWAYS_SHIFT)
#define AHB_GIZMO_NOR_0_ACCEPT_AHB_WR_ALWAYS_RANGE                      6:6
#define AHB_GIZMO_NOR_0_ACCEPT_AHB_WR_ALWAYS_WOFFSET                    0x0
#define AHB_GIZMO_NOR_0_ACCEPT_AHB_WR_ALWAYS_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NOR_0_ACCEPT_AHB_WR_ALWAYS_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_GIZMO_NOR_0_ACCEPT_AHB_WR_ALWAYS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NOR_0_ACCEPT_AHB_WR_ALWAYS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NOR_0_ACCEPT_AHB_WR_ALWAYS_ACCEPT_ON_CHECK                    _MK_ENUM_CONST(0)
#define AHB_GIZMO_NOR_0_ACCEPT_AHB_WR_ALWAYS_ACCEPT_ON_NOCHECK                  _MK_ENUM_CONST(1)

// AHB slave gizmo - Enable fast re-arbitration.  1 = allow AHB master 
// re-arbitration as soon as the device returns one read data into the gizmos 
// queue.  0 = allow AHB master re-arbitration only when the  device returns all 
// read data into the gizmos queue.
#define AHB_GIZMO_NOR_0_ENB_FAST_REARBITRATE_SHIFT                      _MK_SHIFT_CONST(2)
#define AHB_GIZMO_NOR_0_ENB_FAST_REARBITRATE_FIELD                      (_MK_MASK_CONST(0x1) << AHB_GIZMO_NOR_0_ENB_FAST_REARBITRATE_SHIFT)
#define AHB_GIZMO_NOR_0_ENB_FAST_REARBITRATE_RANGE                      2:2
#define AHB_GIZMO_NOR_0_ENB_FAST_REARBITRATE_WOFFSET                    0x0
#define AHB_GIZMO_NOR_0_ENB_FAST_REARBITRATE_DEFAULT                    _MK_MASK_CONST(0x1)
#define AHB_GIZMO_NOR_0_ENB_FAST_REARBITRATE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_GIZMO_NOR_0_ENB_FAST_REARBITRATE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NOR_0_ENB_FAST_REARBITRATE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NOR_0_ENB_FAST_REARBITRATE_DISABLE                    _MK_ENUM_CONST(0)
#define AHB_GIZMO_NOR_0_ENB_FAST_REARBITRATE_ENABLE                     _MK_ENUM_CONST(1)

// AHB slave gizmo - Force all AHB transaction to single data request 
// transaction.  1 = force to single data transaction always.  
// 0 = dont force to single data  transaction.
#define AHB_GIZMO_NOR_0_FORCE_TO_AHB_SINGLE_SHIFT                       _MK_SHIFT_CONST(1)
#define AHB_GIZMO_NOR_0_FORCE_TO_AHB_SINGLE_FIELD                       (_MK_MASK_CONST(0x1) << AHB_GIZMO_NOR_0_FORCE_TO_AHB_SINGLE_SHIFT)
#define AHB_GIZMO_NOR_0_FORCE_TO_AHB_SINGLE_RANGE                       1:1
#define AHB_GIZMO_NOR_0_FORCE_TO_AHB_SINGLE_WOFFSET                     0x0
#define AHB_GIZMO_NOR_0_FORCE_TO_AHB_SINGLE_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NOR_0_FORCE_TO_AHB_SINGLE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AHB_GIZMO_NOR_0_FORCE_TO_AHB_SINGLE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NOR_0_FORCE_TO_AHB_SINGLE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NOR_0_FORCE_TO_AHB_SINGLE_NOT_SINGLE_DATA                     _MK_ENUM_CONST(0)
#define AHB_GIZMO_NOR_0_FORCE_TO_AHB_SINGLE_SINGLE_DATA                 _MK_ENUM_CONST(1)

// AHB slave gizmo - Enable splitting AHB transactions.  1 = enable 0 = disable
#define AHB_GIZMO_NOR_0_ENABLE_SPLIT_SHIFT                      _MK_SHIFT_CONST(0)
#define AHB_GIZMO_NOR_0_ENABLE_SPLIT_FIELD                      (_MK_MASK_CONST(0x1) << AHB_GIZMO_NOR_0_ENABLE_SPLIT_SHIFT)
#define AHB_GIZMO_NOR_0_ENABLE_SPLIT_RANGE                      0:0
#define AHB_GIZMO_NOR_0_ENABLE_SPLIT_WOFFSET                    0x0
#define AHB_GIZMO_NOR_0_ENABLE_SPLIT_DEFAULT                    _MK_MASK_CONST(0x1)
#define AHB_GIZMO_NOR_0_ENABLE_SPLIT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_GIZMO_NOR_0_ENABLE_SPLIT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NOR_0_ENABLE_SPLIT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_GIZMO_NOR_0_ENABLE_SPLIT_DISABLE                    _MK_ENUM_CONST(0)
#define AHB_GIZMO_NOR_0_ENABLE_SPLIT_ENABLE                     _MK_ENUM_CONST(1)


// Reserved address 120 [0x78] 

// Reserved address 124 [0x7c] 

// Reserved address 128 [0x80] 

// Reserved address 132 [0x84] 

// Reserved address 136 [0x88] 

// Reserved address 140 [0x8c] 

// Reserved address 144 [0x90] 

// Reserved address 148 [0x94] 

// Reserved address 152 [0x98] 

// Reserved address 156 [0x9c] 

// Reserved address 160 [0xa0] 

// Reserved address 164 [0xa4] 

// Reserved address 168 [0xa8] 

// Reserved address 172 [0xac] 

// Reserved address 176 [0xb0] 

// Reserved address 180 [0xb4] 

// Reserved address 184 [0xb8] 

// Reserved address 188 [0xbc] 

// Reserved address 192 [0xc0] 

// Reserved address 196 [0xc4] 

// Reserved address 200 [0xc8] 

// Reserved address 204 [0xcc] 

// Reserved address 208 [0xd0] 

// Reserved address 212 [0xd4] 

// Reserved address 216 [0xd8] 

// Register AHB_ARBITRATION_XBAR_CTRL_0  
#define AHB_ARBITRATION_XBAR_CTRL_0                     _MK_ADDR_CONST(0xdc)
#define AHB_ARBITRATION_XBAR_CTRL_0_WORD_COUNT                  0x1
#define AHB_ARBITRATION_XBAR_CTRL_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_XBAR_CTRL_0_RESET_MASK                  _MK_MASK_CONST(0x10003)
#define AHB_ARBITRATION_XBAR_CTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_XBAR_CTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_XBAR_CTRL_0_READ_MASK                   _MK_MASK_CONST(0x10003)
#define AHB_ARBITRATION_XBAR_CTRL_0_WRITE_MASK                  _MK_MASK_CONST(0x10003)
// SW should set this bit when memory has been initialized
#define AHB_ARBITRATION_XBAR_CTRL_0_MEM_INIT_DONE_SHIFT                 _MK_SHIFT_CONST(16)
#define AHB_ARBITRATION_XBAR_CTRL_0_MEM_INIT_DONE_FIELD                 (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_XBAR_CTRL_0_MEM_INIT_DONE_SHIFT)
#define AHB_ARBITRATION_XBAR_CTRL_0_MEM_INIT_DONE_RANGE                 16:16
#define AHB_ARBITRATION_XBAR_CTRL_0_MEM_INIT_DONE_WOFFSET                       0x0
#define AHB_ARBITRATION_XBAR_CTRL_0_MEM_INIT_DONE_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_XBAR_CTRL_0_MEM_INIT_DONE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_XBAR_CTRL_0_MEM_INIT_DONE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_XBAR_CTRL_0_MEM_INIT_DONE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_XBAR_CTRL_0_MEM_INIT_DONE_NOT_DONE                      _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_XBAR_CTRL_0_MEM_INIT_DONE_DONE                  _MK_ENUM_CONST(1)

// By default CPU accesses to IRAMs will be held if  there are any pending requests from the AHB to the 
// IRAMs. This is done to  avoid data coherency issues. If SW handles coherency then this can be turned  
// off to improve performance.SW writes to modify
#define AHB_ARBITRATION_XBAR_CTRL_0_HOLD_DIS_SHIFT                      _MK_SHIFT_CONST(1)
#define AHB_ARBITRATION_XBAR_CTRL_0_HOLD_DIS_FIELD                      (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_XBAR_CTRL_0_HOLD_DIS_SHIFT)
#define AHB_ARBITRATION_XBAR_CTRL_0_HOLD_DIS_RANGE                      1:1
#define AHB_ARBITRATION_XBAR_CTRL_0_HOLD_DIS_WOFFSET                    0x0
#define AHB_ARBITRATION_XBAR_CTRL_0_HOLD_DIS_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_XBAR_CTRL_0_HOLD_DIS_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_XBAR_CTRL_0_HOLD_DIS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_XBAR_CTRL_0_HOLD_DIS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_XBAR_CTRL_0_HOLD_DIS_ENABLE                     _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_XBAR_CTRL_0_HOLD_DIS_DISABLE                    _MK_ENUM_CONST(1)

// SW writes to modify
#define AHB_ARBITRATION_XBAR_CTRL_0_POST_DIS_SHIFT                      _MK_SHIFT_CONST(0)
#define AHB_ARBITRATION_XBAR_CTRL_0_POST_DIS_FIELD                      (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_XBAR_CTRL_0_POST_DIS_SHIFT)
#define AHB_ARBITRATION_XBAR_CTRL_0_POST_DIS_RANGE                      0:0
#define AHB_ARBITRATION_XBAR_CTRL_0_POST_DIS_WOFFSET                    0x0
#define AHB_ARBITRATION_XBAR_CTRL_0_POST_DIS_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_XBAR_CTRL_0_POST_DIS_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_XBAR_CTRL_0_POST_DIS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_XBAR_CTRL_0_POST_DIS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_XBAR_CTRL_0_POST_DIS_ENABLE                     _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_XBAR_CTRL_0_POST_DIS_DISABLE                    _MK_ENUM_CONST(1)


// Reserved address 224 [0xe0] 

// Reserved address 228 [0xe4] 

// Register AHB_AVP_PPCS_RD_COH_STATUS_0  
#define AHB_AVP_PPCS_RD_COH_STATUS_0                    _MK_ADDR_CONST(0xe8)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_WORD_COUNT                         0x1
#define AHB_AVP_PPCS_RD_COH_STATUS_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_READ_MASK                  _MK_MASK_CONST(0x10001)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_RDS_OUTSTANDING_SHIFT                      _MK_SHIFT_CONST(16)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_RDS_OUTSTANDING_FIELD                      (_MK_MASK_CONST(0x1) << AHB_AVP_PPCS_RD_COH_STATUS_0_RDS_OUTSTANDING_SHIFT)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_RDS_OUTSTANDING_RANGE                      16:16
#define AHB_AVP_PPCS_RD_COH_STATUS_0_RDS_OUTSTANDING_WOFFSET                    0x0
#define AHB_AVP_PPCS_RD_COH_STATUS_0_RDS_OUTSTANDING_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_RDS_OUTSTANDING_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_RDS_OUTSTANDING_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_RDS_OUTSTANDING_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define AHB_AVP_PPCS_RD_COH_STATUS_0_WRS_OUTSTANDING_SHIFT                      _MK_SHIFT_CONST(0)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_WRS_OUTSTANDING_FIELD                      (_MK_MASK_CONST(0x1) << AHB_AVP_PPCS_RD_COH_STATUS_0_WRS_OUTSTANDING_SHIFT)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_WRS_OUTSTANDING_RANGE                      0:0
#define AHB_AVP_PPCS_RD_COH_STATUS_0_WRS_OUTSTANDING_WOFFSET                    0x0
#define AHB_AVP_PPCS_RD_COH_STATUS_0_WRS_OUTSTANDING_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_WRS_OUTSTANDING_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_WRS_OUTSTANDING_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_AVP_PPCS_RD_COH_STATUS_0_WRS_OUTSTANDING_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register AHB_AHB_MEM_PREFETCH_CFG1_0  
#define AHB_AHB_MEM_PREFETCH_CFG1_0                     _MK_ADDR_CONST(0xec)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_WORD_COUNT                  0x1
#define AHB_AHB_MEM_PREFETCH_CFG1_0_RESET_VAL                   _MK_MASK_CONST(0x14830800)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// 1=enable 0=disable
#define AHB_AHB_MEM_PREFETCH_CFG1_0_ENABLE_SHIFT                        _MK_SHIFT_CONST(31)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << AHB_AHB_MEM_PREFETCH_CFG1_0_ENABLE_SHIFT)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_ENABLE_RANGE                        31:31
#define AHB_AHB_MEM_PREFETCH_CFG1_0_ENABLE_WOFFSET                      0x0
#define AHB_AHB_MEM_PREFETCH_CFG1_0_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// AHBDMA master
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_SHIFT                    _MK_SHIFT_CONST(26)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_FIELD                    (_MK_MASK_CONST(0x1f) << AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_SHIFT)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_RANGE                    30:26
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_WOFFSET                  0x0
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_DEFAULT                  _MK_MASK_CONST(0x5)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_CPU                      _MK_ENUM_CONST(0)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_COP                      _MK_ENUM_CONST(1)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_VCP                      _MK_ENUM_CONST(2)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_03                        _MK_ENUM_CONST(3)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_IDE                      _MK_ENUM_CONST(4)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_AHBDMA                   _MK_ENUM_CONST(5)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_USB                      _MK_ENUM_CONST(6)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_APBDMA                   _MK_ENUM_CONST(7)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_XIO                      _MK_ENUM_CONST(8)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_SDIO1                    _MK_ENUM_CONST(9)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_NAND_FLASH                       _MK_ENUM_CONST(10)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_0B                        _MK_ENUM_CONST(11)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_HSMMC                    _MK_ENUM_CONST(12)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_BSEV                     _MK_ENUM_CONST(13)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_0E                        _MK_ENUM_CONST(14)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_0F                        _MK_ENUM_CONST(15)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_BSEA                     _MK_ENUM_CONST(16)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_11                        _MK_ENUM_CONST(17)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_12                        _MK_ENUM_CONST(18)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_SDIO2                    _MK_ENUM_CONST(19)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_14                        _MK_ENUM_CONST(20)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_15                        _MK_ENUM_CONST(20)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_16                        _MK_ENUM_CONST(22)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_17                        _MK_ENUM_CONST(23)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_18                        _MK_ENUM_CONST(24)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_19                        _MK_ENUM_CONST(25)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_1A                        _MK_ENUM_CONST(26)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_1B                        _MK_ENUM_CONST(27)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_1C                        _MK_ENUM_CONST(28)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_1D                        _MK_ENUM_CONST(29)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_1E                        _MK_ENUM_CONST(30)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_AHB_MST_ID_UNUSED_1F                        _MK_ENUM_CONST(31)

// 2^(n+4) byte boundary. any value >16 will use n=16
#define AHB_AHB_MEM_PREFETCH_CFG1_0_ADDR_BNDRY_SHIFT                    _MK_SHIFT_CONST(21)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_ADDR_BNDRY_FIELD                    (_MK_MASK_CONST(0x1f) << AHB_AHB_MEM_PREFETCH_CFG1_0_ADDR_BNDRY_SHIFT)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_ADDR_BNDRY_RANGE                    25:21
#define AHB_AHB_MEM_PREFETCH_CFG1_0_ADDR_BNDRY_WOFFSET                  0x0
#define AHB_AHB_MEM_PREFETCH_CFG1_0_ADDR_BNDRY_DEFAULT                  _MK_MASK_CONST(0x4)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_ADDR_BNDRY_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_ADDR_BNDRY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_ADDR_BNDRY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// 0=0, else 2^(n-1). any value >16 will n=16
#define AHB_AHB_MEM_PREFETCH_CFG1_0_SPEC_THROTTLE_SHIFT                 _MK_SHIFT_CONST(16)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_SPEC_THROTTLE_FIELD                 (_MK_MASK_CONST(0x1f) << AHB_AHB_MEM_PREFETCH_CFG1_0_SPEC_THROTTLE_SHIFT)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_SPEC_THROTTLE_RANGE                 20:16
#define AHB_AHB_MEM_PREFETCH_CFG1_0_SPEC_THROTTLE_WOFFSET                       0x0
#define AHB_AHB_MEM_PREFETCH_CFG1_0_SPEC_THROTTLE_DEFAULT                       _MK_MASK_CONST(0x3)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_SPEC_THROTTLE_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_SPEC_THROTTLE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_SPEC_THROTTLE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// 2048 cycles
#define AHB_AHB_MEM_PREFETCH_CFG1_0_INACTIVITY_TIMEOUT_SHIFT                    _MK_SHIFT_CONST(0)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_INACTIVITY_TIMEOUT_FIELD                    (_MK_MASK_CONST(0xffff) << AHB_AHB_MEM_PREFETCH_CFG1_0_INACTIVITY_TIMEOUT_SHIFT)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_INACTIVITY_TIMEOUT_RANGE                    15:0
#define AHB_AHB_MEM_PREFETCH_CFG1_0_INACTIVITY_TIMEOUT_WOFFSET                  0x0
#define AHB_AHB_MEM_PREFETCH_CFG1_0_INACTIVITY_TIMEOUT_DEFAULT                  _MK_MASK_CONST(0x800)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_INACTIVITY_TIMEOUT_DEFAULT_MASK                     _MK_MASK_CONST(0xffff)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_INACTIVITY_TIMEOUT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG1_0_INACTIVITY_TIMEOUT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register AHB_AHB_MEM_PREFETCH_CFG2_0  
#define AHB_AHB_MEM_PREFETCH_CFG2_0                     _MK_ADDR_CONST(0xf0)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_WORD_COUNT                  0x1
#define AHB_AHB_MEM_PREFETCH_CFG2_0_RESET_VAL                   _MK_MASK_CONST(0x18830800)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// 1=enable 0=disable
#define AHB_AHB_MEM_PREFETCH_CFG2_0_ENABLE_SHIFT                        _MK_SHIFT_CONST(31)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << AHB_AHB_MEM_PREFETCH_CFG2_0_ENABLE_SHIFT)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_ENABLE_RANGE                        31:31
#define AHB_AHB_MEM_PREFETCH_CFG2_0_ENABLE_WOFFSET                      0x0
#define AHB_AHB_MEM_PREFETCH_CFG2_0_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// USB
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_SHIFT                    _MK_SHIFT_CONST(26)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_FIELD                    (_MK_MASK_CONST(0x1f) << AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_SHIFT)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_RANGE                    30:26
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_WOFFSET                  0x0
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_DEFAULT                  _MK_MASK_CONST(0x6)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_CPU                      _MK_ENUM_CONST(0)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_COP                      _MK_ENUM_CONST(1)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_VCP                      _MK_ENUM_CONST(2)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_03                        _MK_ENUM_CONST(3)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_IDE                      _MK_ENUM_CONST(4)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_AHBDMA                   _MK_ENUM_CONST(5)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_USB                      _MK_ENUM_CONST(6)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_APBDMA                   _MK_ENUM_CONST(7)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_XIO                      _MK_ENUM_CONST(8)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_SDIO1                    _MK_ENUM_CONST(9)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_NAND_FLASH                       _MK_ENUM_CONST(10)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_0B                        _MK_ENUM_CONST(11)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_HSMMC                    _MK_ENUM_CONST(12)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_BSEV                     _MK_ENUM_CONST(13)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_0E                        _MK_ENUM_CONST(14)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_0F                        _MK_ENUM_CONST(15)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_BSEA                     _MK_ENUM_CONST(16)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_11                        _MK_ENUM_CONST(17)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_12                        _MK_ENUM_CONST(18)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_SDIO2                    _MK_ENUM_CONST(19)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_14                        _MK_ENUM_CONST(20)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_15                        _MK_ENUM_CONST(20)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_16                        _MK_ENUM_CONST(22)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_17                        _MK_ENUM_CONST(23)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_18                        _MK_ENUM_CONST(24)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_19                        _MK_ENUM_CONST(25)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_1A                        _MK_ENUM_CONST(26)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_1B                        _MK_ENUM_CONST(27)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_1C                        _MK_ENUM_CONST(28)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_1D                        _MK_ENUM_CONST(29)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_1E                        _MK_ENUM_CONST(30)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_AHB_MST_ID_UNUSED_1F                        _MK_ENUM_CONST(31)

// 2^(n+4) byte boundary. any value >16 will use n=16
#define AHB_AHB_MEM_PREFETCH_CFG2_0_ADDR_BNDRY_SHIFT                    _MK_SHIFT_CONST(21)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_ADDR_BNDRY_FIELD                    (_MK_MASK_CONST(0x1f) << AHB_AHB_MEM_PREFETCH_CFG2_0_ADDR_BNDRY_SHIFT)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_ADDR_BNDRY_RANGE                    25:21
#define AHB_AHB_MEM_PREFETCH_CFG2_0_ADDR_BNDRY_WOFFSET                  0x0
#define AHB_AHB_MEM_PREFETCH_CFG2_0_ADDR_BNDRY_DEFAULT                  _MK_MASK_CONST(0x4)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_ADDR_BNDRY_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_ADDR_BNDRY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_ADDR_BNDRY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// 0=0, else 2^(n-1). any value >16 will n=16
#define AHB_AHB_MEM_PREFETCH_CFG2_0_SPEC_THROTTLE_SHIFT                 _MK_SHIFT_CONST(16)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_SPEC_THROTTLE_FIELD                 (_MK_MASK_CONST(0x1f) << AHB_AHB_MEM_PREFETCH_CFG2_0_SPEC_THROTTLE_SHIFT)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_SPEC_THROTTLE_RANGE                 20:16
#define AHB_AHB_MEM_PREFETCH_CFG2_0_SPEC_THROTTLE_WOFFSET                       0x0
#define AHB_AHB_MEM_PREFETCH_CFG2_0_SPEC_THROTTLE_DEFAULT                       _MK_MASK_CONST(0x3)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_SPEC_THROTTLE_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_SPEC_THROTTLE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_SPEC_THROTTLE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// 
#define AHB_AHB_MEM_PREFETCH_CFG2_0_INACTIVITY_TIMEOUT_SHIFT                    _MK_SHIFT_CONST(0)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_INACTIVITY_TIMEOUT_FIELD                    (_MK_MASK_CONST(0xffff) << AHB_AHB_MEM_PREFETCH_CFG2_0_INACTIVITY_TIMEOUT_SHIFT)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_INACTIVITY_TIMEOUT_RANGE                    15:0
#define AHB_AHB_MEM_PREFETCH_CFG2_0_INACTIVITY_TIMEOUT_WOFFSET                  0x0
#define AHB_AHB_MEM_PREFETCH_CFG2_0_INACTIVITY_TIMEOUT_DEFAULT                  _MK_MASK_CONST(0x800)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_INACTIVITY_TIMEOUT_DEFAULT_MASK                     _MK_MASK_CONST(0xffff)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_INACTIVITY_TIMEOUT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_AHB_MEM_PREFETCH_CFG2_0_INACTIVITY_TIMEOUT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register AHB_AHBSLVMEM_STATUS_0  
#define AHB_AHBSLVMEM_STATUS_0                  _MK_ADDR_CONST(0xf4)
#define AHB_AHBSLVMEM_STATUS_0_WORD_COUNT                       0x1
#define AHB_AHBSLVMEM_STATUS_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define AHB_AHBSLVMEM_STATUS_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define AHB_AHBSLVMEM_STATUS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define AHB_AHBSLVMEM_STATUS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_AHBSLVMEM_STATUS_0_READ_MASK                        _MK_MASK_CONST(0x3)
#define AHB_AHBSLVMEM_STATUS_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define AHB_AHBSLVMEM_STATUS_0_PPCS_RDS_OUTSTANDING_SHIFT                       _MK_SHIFT_CONST(1)
#define AHB_AHBSLVMEM_STATUS_0_PPCS_RDS_OUTSTANDING_FIELD                       (_MK_MASK_CONST(0x1) << AHB_AHBSLVMEM_STATUS_0_PPCS_RDS_OUTSTANDING_SHIFT)
#define AHB_AHBSLVMEM_STATUS_0_PPCS_RDS_OUTSTANDING_RANGE                       1:1
#define AHB_AHBSLVMEM_STATUS_0_PPCS_RDS_OUTSTANDING_WOFFSET                     0x0
#define AHB_AHBSLVMEM_STATUS_0_PPCS_RDS_OUTSTANDING_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_AHBSLVMEM_STATUS_0_PPCS_RDS_OUTSTANDING_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_AHBSLVMEM_STATUS_0_PPCS_RDS_OUTSTANDING_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_AHBSLVMEM_STATUS_0_PPCS_RDS_OUTSTANDING_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define AHB_AHBSLVMEM_STATUS_0_GIZMO_IP_RDQUE_EMPTY_SHIFT                       _MK_SHIFT_CONST(0)
#define AHB_AHBSLVMEM_STATUS_0_GIZMO_IP_RDQUE_EMPTY_FIELD                       (_MK_MASK_CONST(0x1) << AHB_AHBSLVMEM_STATUS_0_GIZMO_IP_RDQUE_EMPTY_SHIFT)
#define AHB_AHBSLVMEM_STATUS_0_GIZMO_IP_RDQUE_EMPTY_RANGE                       0:0
#define AHB_AHBSLVMEM_STATUS_0_GIZMO_IP_RDQUE_EMPTY_WOFFSET                     0x0
#define AHB_AHBSLVMEM_STATUS_0_GIZMO_IP_RDQUE_EMPTY_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_AHBSLVMEM_STATUS_0_GIZMO_IP_RDQUE_EMPTY_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_AHBSLVMEM_STATUS_0_GIZMO_IP_RDQUE_EMPTY_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_AHBSLVMEM_STATUS_0_GIZMO_IP_RDQUE_EMPTY_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0  
#define AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0                  _MK_ADDR_CONST(0xf8)
#define AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0_WORD_COUNT                       0x1
#define AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0_RESET_MASK                       _MK_MASK_CONST(0x7fffffff)
#define AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0_READ_MASK                        _MK_MASK_CONST(0x7fffffff)
#define AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0_WRITE_MASK                       _MK_MASK_CONST(0x7fffffff)
// 0 = there is no write data in the write queue from  that AHB master.
#define AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0_AHB_MASTER_ID_SHIFT                      _MK_SHIFT_CONST(0)
#define AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0_AHB_MASTER_ID_FIELD                      (_MK_MASK_CONST(0x7fffffff) << AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0_AHB_MASTER_ID_SHIFT)
#define AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0_AHB_MASTER_ID_RANGE                      30:0
#define AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0_AHB_MASTER_ID_WOFFSET                    0x0
#define AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0_AHB_MASTER_ID_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0_AHB_MASTER_ID_DEFAULT_MASK                       _MK_MASK_CONST(0x7fffffff)
#define AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0_AHB_MASTER_ID_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0_AHB_MASTER_ID_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register AHB_ARBITRATION_CPU_ABORT_INFO_0  
#define AHB_ARBITRATION_CPU_ABORT_INFO_0                        _MK_ADDR_CONST(0xfc)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_WORD_COUNT                     0x1
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_RESET_MASK                     _MK_MASK_CONST(0xffff)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_READ_MASK                      _MK_MASK_CONST(0xffff)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
// Abort occurred due to an iRAMa protection  violation
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMA_SHIFT                    _MK_SHIFT_CONST(15)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMA_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMA_SHIFT)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMA_RANGE                    15:15
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMA_WOFFSET                  0x0
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMA_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMA_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMA_ABT_DIS                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMA_ABT_EN                   _MK_ENUM_CONST(1)

// Abort occurred due to an iRAMb protection  violation
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMB_SHIFT                    _MK_SHIFT_CONST(14)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMB_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMB_SHIFT)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMB_RANGE                    14:14
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMB_WOFFSET                  0x0
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMB_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMB_ABT_DIS                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMB_ABT_EN                   _MK_ENUM_CONST(1)

// Abort occurred due to an iRAMc protection  violation
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMC_SHIFT                    _MK_SHIFT_CONST(13)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMC_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMC_SHIFT)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMC_RANGE                    13:13
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMC_WOFFSET                  0x0
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMC_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMC_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMC_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMC_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMC_ABT_DIS                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMC_ABT_EN                   _MK_ENUM_CONST(1)

// Abort occurred due to an iRAMd protection  violation
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMD_SHIFT                    _MK_SHIFT_CONST(12)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMD_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMD_SHIFT)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMD_RANGE                    12:12
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMD_WOFFSET                  0x0
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMD_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMD_ABT_DIS                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_IRAMD_ABT_EN                   _MK_ENUM_CONST(1)

// Abort occurred due to an access to invalid iRAM  address space
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_INV_IRAM_SHIFT                 _MK_SHIFT_CONST(11)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_INV_IRAM_FIELD                 (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_CPU_ABORT_INFO_0_INV_IRAM_SHIFT)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_INV_IRAM_RANGE                 11:11
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_INV_IRAM_WOFFSET                       0x0
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_INV_IRAM_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_INV_IRAM_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_INV_IRAM_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_INV_IRAM_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_INV_IRAM_ABT_DIS                       _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_INV_IRAM_ABT_EN                        _MK_ENUM_CONST(1)

// Abort occurred due to a PPSB protection violation
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PPSB_SHIFT                     _MK_SHIFT_CONST(10)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PPSB_FIELD                     (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_CPU_ABORT_INFO_0_PPSB_SHIFT)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PPSB_RANGE                     10:10
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PPSB_WOFFSET                   0x0
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PPSB_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PPSB_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PPSB_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PPSB_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PPSB_ABT_DIS                   _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PPSB_ABT_EN                    _MK_ENUM_CONST(1)

// Abort occurred due to an APB protection violation
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_APB_SHIFT                      _MK_SHIFT_CONST(9)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_APB_FIELD                      (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_CPU_ABORT_INFO_0_APB_SHIFT)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_APB_RANGE                      9:9
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_APB_WOFFSET                    0x0
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_APB_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_APB_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_APB_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_APB_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_APB_ABT_DIS                    _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_APB_ABT_EN                     _MK_ENUM_CONST(1)

// Abort occurred due to an AHB protection violation
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_AHB_SHIFT                      _MK_SHIFT_CONST(8)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_AHB_FIELD                      (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_CPU_ABORT_INFO_0_AHB_SHIFT)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_AHB_RANGE                      8:8
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_AHB_WOFFSET                    0x0
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_AHB_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_AHB_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_AHB_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_AHB_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_AHB_ABT_DIS                    _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_AHB_ABT_EN                     _MK_ENUM_CONST(1)

// Abort occurred due to a Cache protection violation
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_CACHE_SHIFT                    _MK_SHIFT_CONST(7)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_CACHE_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_CPU_ABORT_INFO_0_CACHE_SHIFT)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_CACHE_RANGE                    7:7
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_CACHE_WOFFSET                  0x0
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_CACHE_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_CACHE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_CACHE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_CACHE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_CACHE_ABT_DIS                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_CACHE_ABT_EN                   _MK_ENUM_CONST(1)

// TRUE for any protection violation
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PROTECTION_SHIFT                       _MK_SHIFT_CONST(6)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PROTECTION_FIELD                       (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_CPU_ABORT_INFO_0_PROTECTION_SHIFT)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PROTECTION_RANGE                       6:6
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PROTECTION_WOFFSET                     0x0
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PROTECTION_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PROTECTION_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PROTECTION_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PROTECTION_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PROTECTION_ABT_DIS                     _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_PROTECTION_ABT_EN                      _MK_ENUM_CONST(1)

// TRUE for abort caused by Misalignment (i.e. word  access at odd byte address)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_ALIGN_SHIFT                    _MK_SHIFT_CONST(5)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_ALIGN_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_CPU_ABORT_INFO_0_ALIGN_SHIFT)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_ALIGN_RANGE                    5:5
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_ALIGN_WOFFSET                  0x0
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_ALIGN_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_ALIGN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_ALIGN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_ALIGN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_ALIGN_ABT_DIS                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_ALIGN_ABT_EN                   _MK_ENUM_CONST(1)

// TRUE for abort caused by Bad Size (i.e. word  access at odd byte address)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_BADSIZE_SHIFT                  _MK_SHIFT_CONST(4)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_BADSIZE_FIELD                  (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_CPU_ABORT_INFO_0_BADSIZE_SHIFT)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_BADSIZE_RANGE                  4:4
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_BADSIZE_WOFFSET                        0x0
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_BADSIZE_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_BADSIZE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_BADSIZE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_BADSIZE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_BADSIZE_ABT_DIS                        _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_BADSIZE_ABT_EN                 _MK_ENUM_CONST(1)

// Aborted transaction was a Write
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_WRITE_SHIFT                    _MK_SHIFT_CONST(3)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_WRITE_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_CPU_ABORT_INFO_0_WRITE_SHIFT)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_WRITE_RANGE                    3:3
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_WRITE_WOFFSET                  0x0
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_WRITE_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_WRITE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_WRITE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_WRITE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_WRITE_ABT_DIS                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_WRITE_ABT_EN                   _MK_ENUM_CONST(1)

// Aborted transaction was a Data access
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_DATA_SHIFT                     _MK_SHIFT_CONST(2)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_DATA_FIELD                     (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_CPU_ABORT_INFO_0_DATA_SHIFT)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_DATA_RANGE                     2:2
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_DATA_WOFFSET                   0x0
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_DATA_ABT_DIS                   _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_DATA_ABT_EN                    _MK_ENUM_CONST(1)

// Aborted transaction Request Size 00=byte,  01=hword, 10=word
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_SIZE_SHIFT                     _MK_SHIFT_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_SIZE_FIELD                     (_MK_MASK_CONST(0x3) << AHB_ARBITRATION_CPU_ABORT_INFO_0_SIZE_SHIFT)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_SIZE_RANGE                     1:0
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_SIZE_WOFFSET                   0x0
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_SIZE_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_SIZE_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_SIZE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_SIZE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_SIZE_BYTE_ABT                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_SIZE_HWORD_ABT                 _MK_ENUM_CONST(1)
#define AHB_ARBITRATION_CPU_ABORT_INFO_0_SIZE_WORD_ABT                  _MK_ENUM_CONST(2)


// Register AHB_ARBITRATION_CPU_ABORT_ADDR_0  
#define AHB_ARBITRATION_CPU_ABORT_ADDR_0                        _MK_ADDR_CONST(0x100)
#define AHB_ARBITRATION_CPU_ABORT_ADDR_0_WORD_COUNT                     0x1
#define AHB_ARBITRATION_CPU_ABORT_ADDR_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_ADDR_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define AHB_ARBITRATION_CPU_ABORT_ADDR_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_ADDR_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_ADDR_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define AHB_ARBITRATION_CPU_ABORT_ADDR_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
// Instruction Address which caused the abort
#define AHB_ARBITRATION_CPU_ABORT_ADDR_0_ADDR_SHIFT                     _MK_SHIFT_CONST(0)
#define AHB_ARBITRATION_CPU_ABORT_ADDR_0_ADDR_FIELD                     (_MK_MASK_CONST(0xffffffff) << AHB_ARBITRATION_CPU_ABORT_ADDR_0_ADDR_SHIFT)
#define AHB_ARBITRATION_CPU_ABORT_ADDR_0_ADDR_RANGE                     31:0
#define AHB_ARBITRATION_CPU_ABORT_ADDR_0_ADDR_WOFFSET                   0x0
#define AHB_ARBITRATION_CPU_ABORT_ADDR_0_ADDR_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_ADDR_0_ADDR_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define AHB_ARBITRATION_CPU_ABORT_ADDR_0_ADDR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_CPU_ABORT_ADDR_0_ADDR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register AHB_ARBITRATION_COP_ABORT_INFO_0  
#define AHB_ARBITRATION_COP_ABORT_INFO_0                        _MK_ADDR_CONST(0x104)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_WORD_COUNT                     0x1
#define AHB_ARBITRATION_COP_ABORT_INFO_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_RESET_MASK                     _MK_MASK_CONST(0xe7ff)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_READ_MASK                      _MK_MASK_CONST(0xe7ff)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
// Abort occurred due to an iRAMa protection  violation
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMA_SHIFT                    _MK_SHIFT_CONST(15)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMA_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMA_SHIFT)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMA_RANGE                    15:15
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMA_WOFFSET                  0x0
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMA_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMA_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMA_ABT_DIS                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMA_ABT_EN                   _MK_ENUM_CONST(1)

// Abort occurred due to an iRAMb protection  violation
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMB_SHIFT                    _MK_SHIFT_CONST(14)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMB_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMB_SHIFT)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMB_RANGE                    14:14
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMB_WOFFSET                  0x0
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMB_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMB_ABT_DIS                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMB_ABT_EN                   _MK_ENUM_CONST(1)

// Abort occurred due to an iRAMc protection  violation
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMC_SHIFT                    _MK_SHIFT_CONST(13)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMC_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMC_SHIFT)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMC_RANGE                    13:13
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMC_WOFFSET                  0x0
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMC_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMC_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMC_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMC_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMC_ABT_DIS                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_IRAMC_ABT_EN                   _MK_ENUM_CONST(1)

// Abort occurred due to a PPSB protection violation
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PPSB_SHIFT                     _MK_SHIFT_CONST(10)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PPSB_FIELD                     (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_COP_ABORT_INFO_0_PPSB_SHIFT)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PPSB_RANGE                     10:10
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PPSB_WOFFSET                   0x0
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PPSB_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PPSB_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PPSB_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PPSB_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PPSB_ABT_DIS                   _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PPSB_ABT_EN                    _MK_ENUM_CONST(1)

// Abort occurred due to an APB protection violation
#define AHB_ARBITRATION_COP_ABORT_INFO_0_APB_SHIFT                      _MK_SHIFT_CONST(9)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_APB_FIELD                      (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_COP_ABORT_INFO_0_APB_SHIFT)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_APB_RANGE                      9:9
#define AHB_ARBITRATION_COP_ABORT_INFO_0_APB_WOFFSET                    0x0
#define AHB_ARBITRATION_COP_ABORT_INFO_0_APB_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_APB_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_APB_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_APB_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_APB_ABT_DIS                    _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_APB_ABT_EN                     _MK_ENUM_CONST(1)

// Abort occurred due to an AHB protection violation
#define AHB_ARBITRATION_COP_ABORT_INFO_0_AHB_SHIFT                      _MK_SHIFT_CONST(8)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_AHB_FIELD                      (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_COP_ABORT_INFO_0_AHB_SHIFT)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_AHB_RANGE                      8:8
#define AHB_ARBITRATION_COP_ABORT_INFO_0_AHB_WOFFSET                    0x0
#define AHB_ARBITRATION_COP_ABORT_INFO_0_AHB_DEFAULT                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_AHB_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_AHB_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_AHB_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_AHB_ABT_DIS                    _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_AHB_ABT_EN                     _MK_ENUM_CONST(1)

// Abort occurred due to a Cache protection violation
#define AHB_ARBITRATION_COP_ABORT_INFO_0_CACHE_SHIFT                    _MK_SHIFT_CONST(7)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_CACHE_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_COP_ABORT_INFO_0_CACHE_SHIFT)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_CACHE_RANGE                    7:7
#define AHB_ARBITRATION_COP_ABORT_INFO_0_CACHE_WOFFSET                  0x0
#define AHB_ARBITRATION_COP_ABORT_INFO_0_CACHE_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_CACHE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_CACHE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_CACHE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_CACHE_ABT_DIS                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_CACHE_ABT_EN                   _MK_ENUM_CONST(1)

// TRUE for any protection violation
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PROTECTION_SHIFT                       _MK_SHIFT_CONST(6)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PROTECTION_FIELD                       (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_COP_ABORT_INFO_0_PROTECTION_SHIFT)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PROTECTION_RANGE                       6:6
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PROTECTION_WOFFSET                     0x0
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PROTECTION_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PROTECTION_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PROTECTION_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PROTECTION_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PROTECTION_ABT_DIS                     _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_PROTECTION_ABT_EN                      _MK_ENUM_CONST(1)

// TRUE for abort caused by Misalignment (i.e. word  access at odd byte address)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_ALIGN_SHIFT                    _MK_SHIFT_CONST(5)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_ALIGN_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_COP_ABORT_INFO_0_ALIGN_SHIFT)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_ALIGN_RANGE                    5:5
#define AHB_ARBITRATION_COP_ABORT_INFO_0_ALIGN_WOFFSET                  0x0
#define AHB_ARBITRATION_COP_ABORT_INFO_0_ALIGN_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_ALIGN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_ALIGN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_ALIGN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_ALIGN_ABT_DIS                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_ALIGN_ABT_EN                   _MK_ENUM_CONST(1)

// TRUE for abort caused by Bad Size (i.e. word  access at odd byte address)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_BADSIZE_SHIFT                  _MK_SHIFT_CONST(4)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_BADSIZE_FIELD                  (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_COP_ABORT_INFO_0_BADSIZE_SHIFT)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_BADSIZE_RANGE                  4:4
#define AHB_ARBITRATION_COP_ABORT_INFO_0_BADSIZE_WOFFSET                        0x0
#define AHB_ARBITRATION_COP_ABORT_INFO_0_BADSIZE_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_BADSIZE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_BADSIZE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_BADSIZE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_BADSIZE_ABT_DIS                        _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_BADSIZE_ABT_EN                 _MK_ENUM_CONST(1)

// Aborted transaction was a Write
#define AHB_ARBITRATION_COP_ABORT_INFO_0_WRITE_SHIFT                    _MK_SHIFT_CONST(3)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_WRITE_FIELD                    (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_COP_ABORT_INFO_0_WRITE_SHIFT)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_WRITE_RANGE                    3:3
#define AHB_ARBITRATION_COP_ABORT_INFO_0_WRITE_WOFFSET                  0x0
#define AHB_ARBITRATION_COP_ABORT_INFO_0_WRITE_DEFAULT                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_WRITE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_WRITE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_WRITE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_WRITE_ABT_DIS                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_WRITE_ABT_EN                   _MK_ENUM_CONST(1)

// Aborted transaction was a Data access
#define AHB_ARBITRATION_COP_ABORT_INFO_0_DATA_SHIFT                     _MK_SHIFT_CONST(2)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_DATA_FIELD                     (_MK_MASK_CONST(0x1) << AHB_ARBITRATION_COP_ABORT_INFO_0_DATA_SHIFT)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_DATA_RANGE                     2:2
#define AHB_ARBITRATION_COP_ABORT_INFO_0_DATA_WOFFSET                   0x0
#define AHB_ARBITRATION_COP_ABORT_INFO_0_DATA_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_DATA_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_DATA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_DATA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_DATA_ABT_DIS                   _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_DATA_ABT_EN                    _MK_ENUM_CONST(1)

// Aborted transaction Request Size 00=byte,  01=hword, 10=word
#define AHB_ARBITRATION_COP_ABORT_INFO_0_SIZE_SHIFT                     _MK_SHIFT_CONST(0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_SIZE_FIELD                     (_MK_MASK_CONST(0x3) << AHB_ARBITRATION_COP_ABORT_INFO_0_SIZE_SHIFT)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_SIZE_RANGE                     1:0
#define AHB_ARBITRATION_COP_ABORT_INFO_0_SIZE_WOFFSET                   0x0
#define AHB_ARBITRATION_COP_ABORT_INFO_0_SIZE_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_SIZE_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_SIZE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_SIZE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_SIZE_BYTE_ABT                  _MK_ENUM_CONST(0)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_SIZE_HWORD_ABT                 _MK_ENUM_CONST(1)
#define AHB_ARBITRATION_COP_ABORT_INFO_0_SIZE_WORD_ABT                  _MK_ENUM_CONST(2)


// Register AHB_ARBITRATION_COP_ABORT_ADDR_0  
#define AHB_ARBITRATION_COP_ABORT_ADDR_0                        _MK_ADDR_CONST(0x108)
#define AHB_ARBITRATION_COP_ABORT_ADDR_0_WORD_COUNT                     0x1
#define AHB_ARBITRATION_COP_ABORT_ADDR_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_ADDR_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define AHB_ARBITRATION_COP_ABORT_ADDR_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_ADDR_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_ADDR_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define AHB_ARBITRATION_COP_ABORT_ADDR_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
// Instruction Address which caused the abort
#define AHB_ARBITRATION_COP_ABORT_ADDR_0_ADDR_SHIFT                     _MK_SHIFT_CONST(0)
#define AHB_ARBITRATION_COP_ABORT_ADDR_0_ADDR_FIELD                     (_MK_MASK_CONST(0xffffffff) << AHB_ARBITRATION_COP_ABORT_ADDR_0_ADDR_SHIFT)
#define AHB_ARBITRATION_COP_ABORT_ADDR_0_ADDR_RANGE                     31:0
#define AHB_ARBITRATION_COP_ABORT_ADDR_0_ADDR_WOFFSET                   0x0
#define AHB_ARBITRATION_COP_ABORT_ADDR_0_ADDR_DEFAULT                   _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_ADDR_0_ADDR_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define AHB_ARBITRATION_COP_ABORT_ADDR_0_ADDR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define AHB_ARBITRATION_COP_ABORT_ADDR_0_ADDR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_ARAHB_ARBC_REGS(_op_) \
_op_(AHB_ARBITRATION_DISABLE_0) \
_op_(AHB_ARBITRATION_PRIORITY_CTRL_0) \
_op_(AHB_ARBITRATION_USR_PROTECT_0) \
_op_(AHB_GIZMO_AHB_MEM_0) \
_op_(AHB_GIZMO_APB_DMA_0) \
_op_(AHB_GIZMO_IDE_0) \
_op_(AHB_GIZMO_USB_0) \
_op_(AHB_GIZMO_AHB_XBAR_BRIDGE_0) \
_op_(AHB_GIZMO_CPU_AHB_BRIDGE_0) \
_op_(AHB_GIZMO_COP_AHB_BRIDGE_0) \
_op_(AHB_GIZMO_XBAR_APB_CTLR_0) \
_op_(AHB_GIZMO_NAND_0) \
_op_(AHB_GIZMO_HSMMC1_0) \
_op_(AHB_GIZMO_XIO_0) \
_op_(AHB_GIZMO_BSEV_0) \
_op_(AHB_GIZMO_BSEA_0) \
_op_(AHB_GIZMO_NOR_0) \
_op_(AHB_ARBITRATION_XBAR_CTRL_0) \
_op_(AHB_AVP_PPCS_RD_COH_STATUS_0) \
_op_(AHB_AHB_MEM_PREFETCH_CFG1_0) \
_op_(AHB_AHB_MEM_PREFETCH_CFG2_0) \
_op_(AHB_AHBSLVMEM_STATUS_0) \
_op_(AHB_ARBITRATION_AHB_MEM_WRQUE_MST_ID_0) \
_op_(AHB_ARBITRATION_CPU_ABORT_INFO_0) \
_op_(AHB_ARBITRATION_CPU_ABORT_ADDR_0) \
_op_(AHB_ARBITRATION_COP_ABORT_INFO_0) \
_op_(AHB_ARBITRATION_COP_ABORT_ADDR_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_AHB        0x00000000

//
// ARAHB_ARBC REGISTER BANKS
//

#define AHB0_FIRST_REG 0x0000 // AHB_ARBITRATION_DISABLE_0
#define AHB0_LAST_REG 0x0010 // AHB_GIZMO_APB_DMA_0
#define AHB1_FIRST_REG 0x0018 // AHB_GIZMO_IDE_0
#define AHB1_LAST_REG 0x002c // AHB_GIZMO_XBAR_APB_CTLR_0
#define AHB2_FIRST_REG 0x003c // AHB_GIZMO_NAND_0
#define AHB2_LAST_REG 0x003c // AHB_GIZMO_NAND_0
#define AHB3_FIRST_REG 0x0044 // AHB_GIZMO_HSMMC1_0
#define AHB3_LAST_REG 0x0048 // AHB_GIZMO_XIO_0
#define AHB4_FIRST_REG 0x0060 // AHB_GIZMO_BSEV_0
#define AHB4_LAST_REG 0x0060 // AHB_GIZMO_BSEV_0
#define AHB5_FIRST_REG 0x0070 // AHB_GIZMO_BSEA_0
#define AHB5_LAST_REG 0x0074 // AHB_GIZMO_NOR_0
#define AHB6_FIRST_REG 0x00dc // AHB_ARBITRATION_XBAR_CTRL_0
#define AHB6_LAST_REG 0x00dc // AHB_ARBITRATION_XBAR_CTRL_0
#define AHB7_FIRST_REG 0x00e8 // AHB_AVP_PPCS_RD_COH_STATUS_0
#define AHB7_LAST_REG 0x0108 // AHB_ARBITRATION_COP_ABORT_ADDR_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARAHB_ARBC_H_INC_
