/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARAPB_CMC_H_INC_
#define ___ARAPB_CMC_H_INC_
// --------------------------------------------------------------------------
//
// Copyright (c) 2006, NVIDIA Corp.
// All Rights Reserved.
//
// This is UNPUBLISHED PROPRIETARY SOURCE CODE of NVIDIA Corp.;
// the contents of this file may not be disclosed to third parties, copied or
// duplicated in any form, in whole or in part, without the prior written
// permission of NVIDIA Corp.
//
// RESTRICTED RIGHTS LEGEND:
// Use, duplication or disclosure by the Government is subject to restrictions
// as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
// and Computer Software clause at DFARS 252.227-7013, and/or in similar or
// successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
// rights reserved under the Copyright Laws of the United States.
//
// --------------------------------------------------------------------------
//

// Register APB_CMC_CONFIG_0  
#define APB_CMC_CONFIG_0                        _MK_ADDR_CONST(0x0)
#define APB_CMC_CONFIG_0_WORD_COUNT                     0x1
#define APB_CMC_CONFIG_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_RESET_MASK                     _MK_MASK_CONST(0xff)
#define APB_CMC_CONFIG_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_READ_MASK                      _MK_MASK_CONST(0xff)
#define APB_CMC_CONFIG_0_WRITE_MASK                     _MK_MASK_CONST(0xff)
#define APB_CMC_CONFIG_0_ENABLE_CACHE_SHIFT                     _MK_SHIFT_CONST(0)
#define APB_CMC_CONFIG_0_ENABLE_CACHE_FIELD                     (_MK_MASK_CONST(0x1) << APB_CMC_CONFIG_0_ENABLE_CACHE_SHIFT)
#define APB_CMC_CONFIG_0_ENABLE_CACHE_RANGE                     0:0
#define APB_CMC_CONFIG_0_ENABLE_CACHE_WOFFSET                   0x0
#define APB_CMC_CONFIG_0_ENABLE_CACHE_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_ENABLE_CACHE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_CMC_CONFIG_0_ENABLE_CACHE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_ENABLE_CACHE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_CMC_CONFIG_0_ENABLE_SKEW_ASSOC_SHIFT                        _MK_SHIFT_CONST(1)
#define APB_CMC_CONFIG_0_ENABLE_SKEW_ASSOC_FIELD                        (_MK_MASK_CONST(0x1) << APB_CMC_CONFIG_0_ENABLE_SKEW_ASSOC_SHIFT)
#define APB_CMC_CONFIG_0_ENABLE_SKEW_ASSOC_RANGE                        1:1
#define APB_CMC_CONFIG_0_ENABLE_SKEW_ASSOC_WOFFSET                      0x0
#define APB_CMC_CONFIG_0_ENABLE_SKEW_ASSOC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_ENABLE_SKEW_ASSOC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_CMC_CONFIG_0_ENABLE_SKEW_ASSOC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_ENABLE_SKEW_ASSOC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define APB_CMC_CONFIG_0_DISABLE_RANDOM_ALLOC_SHIFT                     _MK_SHIFT_CONST(2)
#define APB_CMC_CONFIG_0_DISABLE_RANDOM_ALLOC_FIELD                     (_MK_MASK_CONST(0x1) << APB_CMC_CONFIG_0_DISABLE_RANDOM_ALLOC_SHIFT)
#define APB_CMC_CONFIG_0_DISABLE_RANDOM_ALLOC_RANGE                     2:2
#define APB_CMC_CONFIG_0_DISABLE_RANDOM_ALLOC_WOFFSET                   0x0
#define APB_CMC_CONFIG_0_DISABLE_RANDOM_ALLOC_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_DISABLE_RANDOM_ALLOC_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_CMC_CONFIG_0_DISABLE_RANDOM_ALLOC_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_DISABLE_RANDOM_ALLOC_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_CMC_CONFIG_0_FORCE_WRITE_THROUGH_SHIFT                      _MK_SHIFT_CONST(3)
#define APB_CMC_CONFIG_0_FORCE_WRITE_THROUGH_FIELD                      (_MK_MASK_CONST(0x1) << APB_CMC_CONFIG_0_FORCE_WRITE_THROUGH_SHIFT)
#define APB_CMC_CONFIG_0_FORCE_WRITE_THROUGH_RANGE                      3:3
#define APB_CMC_CONFIG_0_FORCE_WRITE_THROUGH_WOFFSET                    0x0
#define APB_CMC_CONFIG_0_FORCE_WRITE_THROUGH_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_FORCE_WRITE_THROUGH_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_CMC_CONFIG_0_FORCE_WRITE_THROUGH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_FORCE_WRITE_THROUGH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APB_CMC_CONFIG_0_ENABLE_STEERING_SHIFT                  _MK_SHIFT_CONST(4)
#define APB_CMC_CONFIG_0_ENABLE_STEERING_FIELD                  (_MK_MASK_CONST(0x1) << APB_CMC_CONFIG_0_ENABLE_STEERING_SHIFT)
#define APB_CMC_CONFIG_0_ENABLE_STEERING_RANGE                  4:4
#define APB_CMC_CONFIG_0_ENABLE_STEERING_WOFFSET                        0x0
#define APB_CMC_CONFIG_0_ENABLE_STEERING_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_ENABLE_STEERING_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_CMC_CONFIG_0_ENABLE_STEERING_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_ENABLE_STEERING_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define APB_CMC_CONFIG_0_ENABLE_EXCLUSIVE_SHIFT                 _MK_SHIFT_CONST(5)
#define APB_CMC_CONFIG_0_ENABLE_EXCLUSIVE_FIELD                 (_MK_MASK_CONST(0x1) << APB_CMC_CONFIG_0_ENABLE_EXCLUSIVE_SHIFT)
#define APB_CMC_CONFIG_0_ENABLE_EXCLUSIVE_RANGE                 5:5
#define APB_CMC_CONFIG_0_ENABLE_EXCLUSIVE_WOFFSET                       0x0
#define APB_CMC_CONFIG_0_ENABLE_EXCLUSIVE_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_ENABLE_EXCLUSIVE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_CMC_CONFIG_0_ENABLE_EXCLUSIVE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_ENABLE_EXCLUSIVE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define APB_CMC_CONFIG_0_NEVER_ALLOCATE_SHIFT                   _MK_SHIFT_CONST(6)
#define APB_CMC_CONFIG_0_NEVER_ALLOCATE_FIELD                   (_MK_MASK_CONST(0x1) << APB_CMC_CONFIG_0_NEVER_ALLOCATE_SHIFT)
#define APB_CMC_CONFIG_0_NEVER_ALLOCATE_RANGE                   6:6
#define APB_CMC_CONFIG_0_NEVER_ALLOCATE_WOFFSET                 0x0
#define APB_CMC_CONFIG_0_NEVER_ALLOCATE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_NEVER_ALLOCATE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APB_CMC_CONFIG_0_NEVER_ALLOCATE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_NEVER_ALLOCATE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define APB_CMC_CONFIG_0_ENABLE_INTERRUPT_SHIFT                 _MK_SHIFT_CONST(7)
#define APB_CMC_CONFIG_0_ENABLE_INTERRUPT_FIELD                 (_MK_MASK_CONST(0x1) << APB_CMC_CONFIG_0_ENABLE_INTERRUPT_SHIFT)
#define APB_CMC_CONFIG_0_ENABLE_INTERRUPT_RANGE                 7:7
#define APB_CMC_CONFIG_0_ENABLE_INTERRUPT_WOFFSET                       0x0
#define APB_CMC_CONFIG_0_ENABLE_INTERRUPT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_ENABLE_INTERRUPT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_CMC_CONFIG_0_ENABLE_INTERRUPT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_CMC_CONFIG_0_ENABLE_INTERRUPT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APB_CMC_LOCK_0  
#define APB_CMC_LOCK_0                  _MK_ADDR_CONST(0x4)
#define APB_CMC_LOCK_0_WORD_COUNT                       0x1
#define APB_CMC_LOCK_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APB_CMC_LOCK_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define APB_CMC_LOCK_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APB_CMC_LOCK_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_CMC_LOCK_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define APB_CMC_LOCK_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
#define APB_CMC_LOCK_0_LOCK_BITMAP_SHIFT                        _MK_SHIFT_CONST(0)
#define APB_CMC_LOCK_0_LOCK_BITMAP_FIELD                        (_MK_MASK_CONST(0xff) << APB_CMC_LOCK_0_LOCK_BITMAP_SHIFT)
#define APB_CMC_LOCK_0_LOCK_BITMAP_RANGE                        7:0
#define APB_CMC_LOCK_0_LOCK_BITMAP_WOFFSET                      0x0
#define APB_CMC_LOCK_0_LOCK_BITMAP_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_CMC_LOCK_0_LOCK_BITMAP_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define APB_CMC_LOCK_0_LOCK_BITMAP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_CMC_LOCK_0_LOCK_BITMAP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//////////////////////////////////////////////////////////////////////
//
//     MAX_WAY_INDEX: how many ways in cache
//
//                    0 : 1 way
//                    1 : 2 way
//                    ...
//                    7 : 8 way
//
/////////////////////////////////////////////////////////////////////

// Register APB_CMC_SIZE_0  
#define APB_CMC_SIZE_0                  _MK_ADDR_CONST(0x8)
#define APB_CMC_SIZE_0_WORD_COUNT                       0x1
#define APB_CMC_SIZE_0_RESET_VAL                        _MK_MASK_CONST(0x7)
#define APB_CMC_SIZE_0_RESET_MASK                       _MK_MASK_CONST(0x7)
#define APB_CMC_SIZE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APB_CMC_SIZE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_CMC_SIZE_0_READ_MASK                        _MK_MASK_CONST(0x7)
#define APB_CMC_SIZE_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define APB_CMC_SIZE_0_MAX_WAY_INDEX_SHIFT                      _MK_SHIFT_CONST(0)
#define APB_CMC_SIZE_0_MAX_WAY_INDEX_FIELD                      (_MK_MASK_CONST(0x7) << APB_CMC_SIZE_0_MAX_WAY_INDEX_SHIFT)
#define APB_CMC_SIZE_0_MAX_WAY_INDEX_RANGE                      2:0
#define APB_CMC_SIZE_0_MAX_WAY_INDEX_WOFFSET                    0x0
#define APB_CMC_SIZE_0_MAX_WAY_INDEX_DEFAULT                    _MK_MASK_CONST(0x7)
#define APB_CMC_SIZE_0_MAX_WAY_INDEX_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define APB_CMC_SIZE_0_MAX_WAY_INDEX_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_CMC_SIZE_0_MAX_WAY_INDEX_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APB_CMC_MAINT_0_0  
#define APB_CMC_MAINT_0_0                       _MK_ADDR_CONST(0xc)
#define APB_CMC_MAINT_0_0_WORD_COUNT                    0x1
#define APB_CMC_MAINT_0_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_0_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_0_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_0_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_0_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_0_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_0_0_ADDR_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_CMC_MAINT_0_0_ADDR_FIELD                    (_MK_MASK_CONST(0xffffffff) << APB_CMC_MAINT_0_0_ADDR_SHIFT)
#define APB_CMC_MAINT_0_0_ADDR_RANGE                    31:0
#define APB_CMC_MAINT_0_0_ADDR_WOFFSET                  0x0
#define APB_CMC_MAINT_0_0_ADDR_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_0_0_ADDR_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_0_0_ADDR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_0_0_ADDR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APB_CMC_MAINT_1_0  
#define APB_CMC_MAINT_1_0                       _MK_ADDR_CONST(0x10)
#define APB_CMC_MAINT_1_0_WORD_COUNT                    0x1
#define APB_CMC_MAINT_1_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_0_DATA_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_CMC_MAINT_1_0_DATA_FIELD                    (_MK_MASK_CONST(0xffffffff) << APB_CMC_MAINT_1_0_DATA_SHIFT)
#define APB_CMC_MAINT_1_0_DATA_RANGE                    31:0
#define APB_CMC_MAINT_1_0_DATA_WOFFSET                  0x0
#define APB_CMC_MAINT_1_0_DATA_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_0_DATA_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_0_DATA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_0_DATA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APB_CMC_MAINT_1  
#define APB_CMC_MAINT_1                 _MK_ADDR_CONST(0x10)
#define APB_CMC_MAINT_1_WORD_COUNT                      0x1
#define APB_CMC_MAINT_1_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_RESET_MASK                      _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_DATA_SHIFT                      _MK_SHIFT_CONST(0)
#define APB_CMC_MAINT_1_DATA_FIELD                      (_MK_MASK_CONST(0xffffffff) << APB_CMC_MAINT_1_DATA_SHIFT)
#define APB_CMC_MAINT_1_DATA_RANGE                      31:0
#define APB_CMC_MAINT_1_DATA_WOFFSET                    0x0
#define APB_CMC_MAINT_1_DATA_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_DATA_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_DATA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_DATA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APB_CMC_MAINT_1_1  
#define APB_CMC_MAINT_1_1                       _MK_ADDR_CONST(0x14)
#define APB_CMC_MAINT_1_1_WORD_COUNT                    0x1
#define APB_CMC_MAINT_1_1_RESET_VAL                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_1_RESET_MASK                    _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_1_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_1_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_1_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_1_DATA_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_CMC_MAINT_1_1_DATA_FIELD                    (_MK_MASK_CONST(0xffffffff) << APB_CMC_MAINT_1_1_DATA_SHIFT)
#define APB_CMC_MAINT_1_1_DATA_RANGE                    31:0
#define APB_CMC_MAINT_1_1_DATA_WOFFSET                  0x0
#define APB_CMC_MAINT_1_1_DATA_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_1_DATA_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_1_DATA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_1_DATA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APB_CMC_MAINT_1_2  
#define APB_CMC_MAINT_1_2                       _MK_ADDR_CONST(0x18)
#define APB_CMC_MAINT_1_2_WORD_COUNT                    0x1
#define APB_CMC_MAINT_1_2_RESET_VAL                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_2_RESET_MASK                    _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_2_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_2_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_2_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_2_DATA_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_CMC_MAINT_1_2_DATA_FIELD                    (_MK_MASK_CONST(0xffffffff) << APB_CMC_MAINT_1_2_DATA_SHIFT)
#define APB_CMC_MAINT_1_2_DATA_RANGE                    31:0
#define APB_CMC_MAINT_1_2_DATA_WOFFSET                  0x0
#define APB_CMC_MAINT_1_2_DATA_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_2_DATA_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_2_DATA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_2_DATA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APB_CMC_MAINT_1_3  
#define APB_CMC_MAINT_1_3                       _MK_ADDR_CONST(0x1c)
#define APB_CMC_MAINT_1_3_WORD_COUNT                    0x1
#define APB_CMC_MAINT_1_3_RESET_VAL                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_3_RESET_MASK                    _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_3_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_3_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_3_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_3_DATA_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_CMC_MAINT_1_3_DATA_FIELD                    (_MK_MASK_CONST(0xffffffff) << APB_CMC_MAINT_1_3_DATA_SHIFT)
#define APB_CMC_MAINT_1_3_DATA_RANGE                    31:0
#define APB_CMC_MAINT_1_3_DATA_WOFFSET                  0x0
#define APB_CMC_MAINT_1_3_DATA_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_3_DATA_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_3_DATA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_3_DATA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APB_CMC_MAINT_1_4  
#define APB_CMC_MAINT_1_4                       _MK_ADDR_CONST(0x20)
#define APB_CMC_MAINT_1_4_WORD_COUNT                    0x1
#define APB_CMC_MAINT_1_4_RESET_VAL                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_4_RESET_MASK                    _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_4_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_4_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_4_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_4_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_4_DATA_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_CMC_MAINT_1_4_DATA_FIELD                    (_MK_MASK_CONST(0xffffffff) << APB_CMC_MAINT_1_4_DATA_SHIFT)
#define APB_CMC_MAINT_1_4_DATA_RANGE                    31:0
#define APB_CMC_MAINT_1_4_DATA_WOFFSET                  0x0
#define APB_CMC_MAINT_1_4_DATA_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_4_DATA_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_4_DATA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_4_DATA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APB_CMC_MAINT_1_5  
#define APB_CMC_MAINT_1_5                       _MK_ADDR_CONST(0x24)
#define APB_CMC_MAINT_1_5_WORD_COUNT                    0x1
#define APB_CMC_MAINT_1_5_RESET_VAL                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_5_RESET_MASK                    _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_5_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_5_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_5_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_5_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_5_DATA_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_CMC_MAINT_1_5_DATA_FIELD                    (_MK_MASK_CONST(0xffffffff) << APB_CMC_MAINT_1_5_DATA_SHIFT)
#define APB_CMC_MAINT_1_5_DATA_RANGE                    31:0
#define APB_CMC_MAINT_1_5_DATA_WOFFSET                  0x0
#define APB_CMC_MAINT_1_5_DATA_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_5_DATA_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_5_DATA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_5_DATA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APB_CMC_MAINT_1_6  
#define APB_CMC_MAINT_1_6                       _MK_ADDR_CONST(0x28)
#define APB_CMC_MAINT_1_6_WORD_COUNT                    0x1
#define APB_CMC_MAINT_1_6_RESET_VAL                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_6_RESET_MASK                    _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_6_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_6_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_6_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_6_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_6_DATA_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_CMC_MAINT_1_6_DATA_FIELD                    (_MK_MASK_CONST(0xffffffff) << APB_CMC_MAINT_1_6_DATA_SHIFT)
#define APB_CMC_MAINT_1_6_DATA_RANGE                    31:0
#define APB_CMC_MAINT_1_6_DATA_WOFFSET                  0x0
#define APB_CMC_MAINT_1_6_DATA_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_6_DATA_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_6_DATA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_6_DATA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APB_CMC_MAINT_1_7  
#define APB_CMC_MAINT_1_7                       _MK_ADDR_CONST(0x2c)
#define APB_CMC_MAINT_1_7_WORD_COUNT                    0x1
#define APB_CMC_MAINT_1_7_RESET_VAL                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_7_RESET_MASK                    _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_7_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_7_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_7_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_7_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
#define APB_CMC_MAINT_1_7_DATA_SHIFT                    _MK_SHIFT_CONST(0)
#define APB_CMC_MAINT_1_7_DATA_FIELD                    (_MK_MASK_CONST(0xffffffff) << APB_CMC_MAINT_1_7_DATA_SHIFT)
#define APB_CMC_MAINT_1_7_DATA_RANGE                    31:0
#define APB_CMC_MAINT_1_7_DATA_WOFFSET                  0x0
#define APB_CMC_MAINT_1_7_DATA_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_7_DATA_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_7_DATA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_1_7_DATA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APB_CMC_MAINT_2_0  
#define APB_CMC_MAINT_2_0                       _MK_ADDR_CONST(0x30)
#define APB_CMC_MAINT_2_0_WORD_COUNT                    0x1
#define APB_CMC_MAINT_2_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_2_0_RESET_MASK                    _MK_MASK_CONST(0xffff)
#define APB_CMC_MAINT_2_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_2_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_2_0_READ_MASK                     _MK_MASK_CONST(0xffff)
#define APB_CMC_MAINT_2_0_WRITE_MASK                    _MK_MASK_CONST(0xffff)
#define APB_CMC_MAINT_2_0_OPCODE_SHIFT                  _MK_SHIFT_CONST(0)
#define APB_CMC_MAINT_2_0_OPCODE_FIELD                  (_MK_MASK_CONST(0xff) << APB_CMC_MAINT_2_0_OPCODE_SHIFT)
#define APB_CMC_MAINT_2_0_OPCODE_RANGE                  7:0
#define APB_CMC_MAINT_2_0_OPCODE_WOFFSET                        0x0
#define APB_CMC_MAINT_2_0_OPCODE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_2_0_OPCODE_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define APB_CMC_MAINT_2_0_OPCODE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_2_0_OPCODE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_2_0_OPCODE_NOP                    _MK_ENUM_CONST(0)    // // no operation. after any op is executed, the field should be reset to NOP

#define APB_CMC_MAINT_2_0_OPCODE_CLEAN_PHY                      _MK_ENUM_CONST(1)    // // clean by physical address

#define APB_CMC_MAINT_2_0_OPCODE_INVALID_PHY                    _MK_ENUM_CONST(2)    // // invalidate by physical address

#define APB_CMC_MAINT_2_0_OPCODE_CLEAN_INVALID_PHY                      _MK_ENUM_CONST(3)    // // clean AND invalidate by physical address

#define APB_CMC_MAINT_2_0_OPCODE_CLEAN_WAY                      _MK_ENUM_CONST(17)    // // clean by way

#define APB_CMC_MAINT_2_0_OPCODE_INVALID_WAY                    _MK_ENUM_CONST(18)    // // invalidate by way

#define APB_CMC_MAINT_2_0_OPCODE_CLEAN_INVALID_WAY                      _MK_ENUM_CONST(19)    // // clean AND invalidate by way

#define APB_CMC_MAINT_2_0_OPCODE_RSVD                   _MK_ENUM_CONST(20)    // // reserved

#define APB_CMC_MAINT_2_0_OPCODE_READ_DATA                      _MK_ENUM_CONST(32)    // // read data ram by tag address

#define APB_CMC_MAINT_2_0_OPCODE_WRITE_DATA                     _MK_ENUM_CONST(33)    // // write data ram by tag address

#define APB_CMC_MAINT_2_0_OPCODE_READ_DIRTY                     _MK_ENUM_CONST(34)    // // read dirty bit by tag address

#define APB_CMC_MAINT_2_0_OPCODE_WRITE_DIRTY                    _MK_ENUM_CONST(35)    // // write dirty bit by tag address

#define APB_CMC_MAINT_2_0_OPCODE_READ_TAG                       _MK_ENUM_CONST(36)    // // read tag ram by tag address

#define APB_CMC_MAINT_2_0_OPCODE_WRITE_TAG                      _MK_ENUM_CONST(37)    // // write tag ram by tag address


#define APB_CMC_MAINT_2_0_WAY_BITMAP_SHIFT                      _MK_SHIFT_CONST(8)
#define APB_CMC_MAINT_2_0_WAY_BITMAP_FIELD                      (_MK_MASK_CONST(0xff) << APB_CMC_MAINT_2_0_WAY_BITMAP_SHIFT)
#define APB_CMC_MAINT_2_0_WAY_BITMAP_RANGE                      15:8
#define APB_CMC_MAINT_2_0_WAY_BITMAP_WOFFSET                    0x0
#define APB_CMC_MAINT_2_0_WAY_BITMAP_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_2_0_WAY_BITMAP_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define APB_CMC_MAINT_2_0_WAY_BITMAP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_CMC_MAINT_2_0_WAY_BITMAP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APB_CMC_LFSR_0  
#define APB_CMC_LFSR_0                  _MK_ADDR_CONST(0x34)
#define APB_CMC_LFSR_0_WORD_COUNT                       0x1
#define APB_CMC_LFSR_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APB_CMC_LFSR_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define APB_CMC_LFSR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APB_CMC_LFSR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_CMC_LFSR_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define APB_CMC_LFSR_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define APB_CMC_LFSR_0_STATUS_SHIFT                     _MK_SHIFT_CONST(0)
#define APB_CMC_LFSR_0_STATUS_FIELD                     (_MK_MASK_CONST(0xff) << APB_CMC_LFSR_0_STATUS_SHIFT)
#define APB_CMC_LFSR_0_STATUS_RANGE                     7:0
#define APB_CMC_LFSR_0_STATUS_WOFFSET                   0x0
#define APB_CMC_LFSR_0_STATUS_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_CMC_LFSR_0_STATUS_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define APB_CMC_LFSR_0_STATUS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_CMC_LFSR_0_STATUS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

/////////////////////////////////////////////////////////////////////
//
// STATIC REGS
//
////////////////////////////////////////////////////////////////////

// Register APB_CMC_STAT_CONTROL_0  
#define APB_CMC_STAT_CONTROL_0                  _MK_ADDR_CONST(0x38)
#define APB_CMC_STAT_CONTROL_0_WORD_COUNT                       0x1
#define APB_CMC_STAT_CONTROL_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_CONTROL_0_RESET_MASK                       _MK_MASK_CONST(0x1)
#define APB_CMC_STAT_CONTROL_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_CONTROL_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_CONTROL_0_READ_MASK                        _MK_MASK_CONST(0x3)
#define APB_CMC_STAT_CONTROL_0_WRITE_MASK                       _MK_MASK_CONST(0x1)
#define APB_CMC_STAT_CONTROL_0_ENABLE_SHIFT                     _MK_SHIFT_CONST(0)
#define APB_CMC_STAT_CONTROL_0_ENABLE_FIELD                     (_MK_MASK_CONST(0x1) << APB_CMC_STAT_CONTROL_0_ENABLE_SHIFT)
#define APB_CMC_STAT_CONTROL_0_ENABLE_RANGE                     0:0
#define APB_CMC_STAT_CONTROL_0_ENABLE_WOFFSET                   0x0
#define APB_CMC_STAT_CONTROL_0_ENABLE_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_CONTROL_0_ENABLE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_CMC_STAT_CONTROL_0_ENABLE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_CONTROL_0_ENABLE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define APB_CMC_STAT_CONTROL_0_STATUS_DONE_SHIFT                        _MK_SHIFT_CONST(1)
#define APB_CMC_STAT_CONTROL_0_STATUS_DONE_FIELD                        (_MK_MASK_CONST(0x1) << APB_CMC_STAT_CONTROL_0_STATUS_DONE_SHIFT)
#define APB_CMC_STAT_CONTROL_0_STATUS_DONE_RANGE                        1:1
#define APB_CMC_STAT_CONTROL_0_STATUS_DONE_WOFFSET                      0x0
#define APB_CMC_STAT_CONTROL_0_STATUS_DONE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_CONTROL_0_STATUS_DONE_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_CONTROL_0_STATUS_DONE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_CONTROL_0_STATUS_DONE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APB_CMC_STAT_STATE_0  
#define APB_CMC_STAT_STATE_0                    _MK_ADDR_CONST(0x3c)
#define APB_CMC_STAT_STATE_0_WORD_COUNT                         0x1
#define APB_CMC_STAT_STATE_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_STATE_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_STATE_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_STATE_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_STATE_0_READ_MASK                  _MK_MASK_CONST(0x1)
#define APB_CMC_STAT_STATE_0_WRITE_MASK                         _MK_MASK_CONST(0x1)
#define APB_CMC_STAT_STATE_0_CLEAR_SHIFT                        _MK_SHIFT_CONST(0)
#define APB_CMC_STAT_STATE_0_CLEAR_FIELD                        (_MK_MASK_CONST(0x1) << APB_CMC_STAT_STATE_0_CLEAR_SHIFT)
#define APB_CMC_STAT_STATE_0_CLEAR_RANGE                        0:0
#define APB_CMC_STAT_STATE_0_CLEAR_WOFFSET                      0x0
#define APB_CMC_STAT_STATE_0_CLEAR_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_STATE_0_CLEAR_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_STATE_0_CLEAR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_STATE_0_CLEAR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APB_CMC_STAT_FILTER_0  
#define APB_CMC_STAT_FILTER_0                   _MK_ADDR_CONST(0x40)
#define APB_CMC_STAT_FILTER_0_WORD_COUNT                        0x1
#define APB_CMC_STAT_FILTER_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_FILTER_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_FILTER_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_FILTER_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_FILTER_0_READ_MASK                         _MK_MASK_CONST(0x7)
#define APB_CMC_STAT_FILTER_0_WRITE_MASK                        _MK_MASK_CONST(0x7)
#define APB_CMC_STAT_FILTER_0_EVENT_SHIFT                       _MK_SHIFT_CONST(0)
#define APB_CMC_STAT_FILTER_0_EVENT_FIELD                       (_MK_MASK_CONST(0x7) << APB_CMC_STAT_FILTER_0_EVENT_SHIFT)
#define APB_CMC_STAT_FILTER_0_EVENT_RANGE                       2:0
#define APB_CMC_STAT_FILTER_0_EVENT_WOFFSET                     0x0
#define APB_CMC_STAT_FILTER_0_EVENT_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_FILTER_0_EVENT_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_FILTER_0_EVENT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_FILTER_0_EVENT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_FILTER_0_EVENT_ALL_TRANS                   _MK_ENUM_CONST(0)
#define APB_CMC_STAT_FILTER_0_EVENT_INSTRUCTION_READ                    _MK_ENUM_CONST(1)
#define APB_CMC_STAT_FILTER_0_EVENT_DATA_READ                   _MK_ENUM_CONST(2)
#define APB_CMC_STAT_FILTER_0_EVENT_WRITE_BACK_ALLOC                    _MK_ENUM_CONST(3)
#define APB_CMC_STAT_FILTER_0_EVENT_WRITE_BACK_NO_ALLOC                 _MK_ENUM_CONST(4)
#define APB_CMC_STAT_FILTER_0_EVENT_WRITE_THROUGH                       _MK_ENUM_CONST(5)


// Register APB_CMC_STAT_CLOCK_0  
#define APB_CMC_STAT_CLOCK_0                    _MK_ADDR_CONST(0x44)
#define APB_CMC_STAT_CLOCK_0_WORD_COUNT                         0x1
#define APB_CMC_STAT_CLOCK_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_CLOCK_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_CLOCK_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_CLOCK_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_CLOCK_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APB_CMC_STAT_CLOCK_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
// Maximum number of cycles that data may be
// collected before STATUS_LIMIT bit is set
#define APB_CMC_STAT_CLOCK_0_COUNT_SHIFT                        _MK_SHIFT_CONST(0)
#define APB_CMC_STAT_CLOCK_0_COUNT_FIELD                        (_MK_MASK_CONST(0xffffffff) << APB_CMC_STAT_CLOCK_0_COUNT_SHIFT)
#define APB_CMC_STAT_CLOCK_0_COUNT_RANGE                        31:0
#define APB_CMC_STAT_CLOCK_0_COUNT_WOFFSET                      0x0
#define APB_CMC_STAT_CLOCK_0_COUNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_CLOCK_0_COUNT_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_CLOCK_0_COUNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_CLOCK_0_COUNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APB_CMC_STAT_HIT_0  
#define APB_CMC_STAT_HIT_0                      _MK_ADDR_CONST(0x48)
#define APB_CMC_STAT_HIT_0_WORD_COUNT                   0x1
#define APB_CMC_STAT_HIT_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_HIT_0_RESET_MASK                   _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_HIT_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_HIT_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_HIT_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define APB_CMC_STAT_HIT_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
// Number of Cache Hit
#define APB_CMC_STAT_HIT_0_COUNT_SHIFT                  _MK_SHIFT_CONST(0)
#define APB_CMC_STAT_HIT_0_COUNT_FIELD                  (_MK_MASK_CONST(0xffffffff) << APB_CMC_STAT_HIT_0_COUNT_SHIFT)
#define APB_CMC_STAT_HIT_0_COUNT_RANGE                  31:0
#define APB_CMC_STAT_HIT_0_COUNT_WOFFSET                        0x0
#define APB_CMC_STAT_HIT_0_COUNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_HIT_0_COUNT_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_HIT_0_COUNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_HIT_0_COUNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APB_CMC_STAT_MISS_ALLOC_0  
#define APB_CMC_STAT_MISS_ALLOC_0                       _MK_ADDR_CONST(0x4c)
#define APB_CMC_STAT_MISS_ALLOC_0_WORD_COUNT                    0x1
#define APB_CMC_STAT_MISS_ALLOC_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_ALLOC_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_ALLOC_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_ALLOC_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_ALLOC_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define APB_CMC_STAT_MISS_ALLOC_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Number of cache miss, which cause allocation in cache.
// This includes fresh allocation from cache entry with tag valid == 0 and
// eviction allocation from cache entry with dirty bit == 0.
// The second case doesn't require memory write because the data is not dirty.
#define APB_CMC_STAT_MISS_ALLOC_0_COUNT_SHIFT                   _MK_SHIFT_CONST(0)
#define APB_CMC_STAT_MISS_ALLOC_0_COUNT_FIELD                   (_MK_MASK_CONST(0xffffffff) << APB_CMC_STAT_MISS_ALLOC_0_COUNT_SHIFT)
#define APB_CMC_STAT_MISS_ALLOC_0_COUNT_RANGE                   31:0
#define APB_CMC_STAT_MISS_ALLOC_0_COUNT_WOFFSET                 0x0
#define APB_CMC_STAT_MISS_ALLOC_0_COUNT_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_ALLOC_0_COUNT_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_ALLOC_0_COUNT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_ALLOC_0_COUNT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APB_CMC_STAT_MISS_NO_ALLOC_0  
#define APB_CMC_STAT_MISS_NO_ALLOC_0                    _MK_ADDR_CONST(0x50)
#define APB_CMC_STAT_MISS_NO_ALLOC_0_WORD_COUNT                         0x1
#define APB_CMC_STAT_MISS_NO_ALLOC_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_NO_ALLOC_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_NO_ALLOC_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_NO_ALLOC_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_NO_ALLOC_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APB_CMC_STAT_MISS_NO_ALLOC_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
// Number of cache miss, which are directly sent
// to memory without any cache allocation/eviction
#define APB_CMC_STAT_MISS_NO_ALLOC_0_COUNT_SHIFT                        _MK_SHIFT_CONST(0)
#define APB_CMC_STAT_MISS_NO_ALLOC_0_COUNT_FIELD                        (_MK_MASK_CONST(0xffffffff) << APB_CMC_STAT_MISS_NO_ALLOC_0_COUNT_SHIFT)
#define APB_CMC_STAT_MISS_NO_ALLOC_0_COUNT_RANGE                        31:0
#define APB_CMC_STAT_MISS_NO_ALLOC_0_COUNT_WOFFSET                      0x0
#define APB_CMC_STAT_MISS_NO_ALLOC_0_COUNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_NO_ALLOC_0_COUNT_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_NO_ALLOC_0_COUNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_NO_ALLOC_0_COUNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APB_CMC_STAT_MISS_EVICT_0  
#define APB_CMC_STAT_MISS_EVICT_0                       _MK_ADDR_CONST(0x54)
#define APB_CMC_STAT_MISS_EVICT_0_WORD_COUNT                    0x1
#define APB_CMC_STAT_MISS_EVICT_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_EVICT_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_EVICT_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_EVICT_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_EVICT_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define APB_CMC_STAT_MISS_EVICT_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Number of cache miss, which cause cache eviction
// Anything covered in STAT_MISS_ALLOC should NOT be counted here!!!
// Only the dirty data will be counted.
#define APB_CMC_STAT_MISS_EVICT_0_COUNT_SHIFT                   _MK_SHIFT_CONST(0)
#define APB_CMC_STAT_MISS_EVICT_0_COUNT_FIELD                   (_MK_MASK_CONST(0xffffffff) << APB_CMC_STAT_MISS_EVICT_0_COUNT_SHIFT)
#define APB_CMC_STAT_MISS_EVICT_0_COUNT_RANGE                   31:0
#define APB_CMC_STAT_MISS_EVICT_0_COUNT_WOFFSET                 0x0
#define APB_CMC_STAT_MISS_EVICT_0_COUNT_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_EVICT_0_COUNT_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_EVICT_0_COUNT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_MISS_EVICT_0_COUNT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APB_CMC_STAT_ADDR_HAZARD_0  
#define APB_CMC_STAT_ADDR_HAZARD_0                      _MK_ADDR_CONST(0x58)
#define APB_CMC_STAT_ADDR_HAZARD_0_WORD_COUNT                   0x1
#define APB_CMC_STAT_ADDR_HAZARD_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_ADDR_HAZARD_0_RESET_MASK                   _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_ADDR_HAZARD_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_ADDR_HAZARD_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_ADDR_HAZARD_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define APB_CMC_STAT_ADDR_HAZARD_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
// Number of address conflict
#define APB_CMC_STAT_ADDR_HAZARD_0_COUNT_SHIFT                  _MK_SHIFT_CONST(0)
#define APB_CMC_STAT_ADDR_HAZARD_0_COUNT_FIELD                  (_MK_MASK_CONST(0xffffffff) << APB_CMC_STAT_ADDR_HAZARD_0_COUNT_SHIFT)
#define APB_CMC_STAT_ADDR_HAZARD_0_COUNT_RANGE                  31:0
#define APB_CMC_STAT_ADDR_HAZARD_0_COUNT_WOFFSET                        0x0
#define APB_CMC_STAT_ADDR_HAZARD_0_COUNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_ADDR_HAZARD_0_COUNT_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_ADDR_HAZARD_0_COUNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_CMC_STAT_ADDR_HAZARD_0_COUNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APB_CMC_INT_MASK_0  
#define APB_CMC_INT_MASK_0                      _MK_ADDR_CONST(0x5c)
#define APB_CMC_INT_MASK_0_WORD_COUNT                   0x1
#define APB_CMC_INT_MASK_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APB_CMC_INT_MASK_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define APB_CMC_INT_MASK_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APB_CMC_INT_MASK_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APB_CMC_INT_MASK_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define APB_CMC_INT_MASK_0_WRITE_MASK                   _MK_MASK_CONST(0x1)
// Enable interrupt for MAINTENANCE_DONE
#define APB_CMC_INT_MASK_0_MAINTENANCE_DONE_SHIFT                       _MK_SHIFT_CONST(0)
#define APB_CMC_INT_MASK_0_MAINTENANCE_DONE_FIELD                       (_MK_MASK_CONST(0x1) << APB_CMC_INT_MASK_0_MAINTENANCE_DONE_SHIFT)
#define APB_CMC_INT_MASK_0_MAINTENANCE_DONE_RANGE                       0:0
#define APB_CMC_INT_MASK_0_MAINTENANCE_DONE_WOFFSET                     0x0
#define APB_CMC_INT_MASK_0_MAINTENANCE_DONE_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_CMC_INT_MASK_0_MAINTENANCE_DONE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_CMC_INT_MASK_0_MAINTENANCE_DONE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_CMC_INT_MASK_0_MAINTENANCE_DONE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APB_CMC_INT_CLEAR_0  
#define APB_CMC_INT_CLEAR_0                     _MK_ADDR_CONST(0x60)
#define APB_CMC_INT_CLEAR_0_WORD_COUNT                  0x1
#define APB_CMC_INT_CLEAR_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APB_CMC_INT_CLEAR_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define APB_CMC_INT_CLEAR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APB_CMC_INT_CLEAR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APB_CMC_INT_CLEAR_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define APB_CMC_INT_CLEAR_0_WRITE_MASK                  _MK_MASK_CONST(0x1)
// Clear both RAW_EVEVNT and INT_STATUS
#define APB_CMC_INT_CLEAR_0_MAINTENANCE_DONE_SHIFT                      _MK_SHIFT_CONST(0)
#define APB_CMC_INT_CLEAR_0_MAINTENANCE_DONE_FIELD                      (_MK_MASK_CONST(0x1) << APB_CMC_INT_CLEAR_0_MAINTENANCE_DONE_SHIFT)
#define APB_CMC_INT_CLEAR_0_MAINTENANCE_DONE_RANGE                      0:0
#define APB_CMC_INT_CLEAR_0_MAINTENANCE_DONE_WOFFSET                    0x0
#define APB_CMC_INT_CLEAR_0_MAINTENANCE_DONE_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_CMC_INT_CLEAR_0_MAINTENANCE_DONE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_CMC_INT_CLEAR_0_MAINTENANCE_DONE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APB_CMC_INT_CLEAR_0_MAINTENANCE_DONE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APB_CMC_INT_RAW_EVENT_0  
#define APB_CMC_INT_RAW_EVENT_0                 _MK_ADDR_CONST(0x64)
#define APB_CMC_INT_RAW_EVENT_0_WORD_COUNT                      0x1
#define APB_CMC_INT_RAW_EVENT_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APB_CMC_INT_RAW_EVENT_0_RESET_MASK                      _MK_MASK_CONST(0x1)
#define APB_CMC_INT_RAW_EVENT_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APB_CMC_INT_RAW_EVENT_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APB_CMC_INT_RAW_EVENT_0_READ_MASK                       _MK_MASK_CONST(0x1)
#define APB_CMC_INT_RAW_EVENT_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
// Raw event for MAINTENANCE_DONE
#define APB_CMC_INT_RAW_EVENT_0_MAINTENANCE_DONE_SHIFT                  _MK_SHIFT_CONST(0)
#define APB_CMC_INT_RAW_EVENT_0_MAINTENANCE_DONE_FIELD                  (_MK_MASK_CONST(0x1) << APB_CMC_INT_RAW_EVENT_0_MAINTENANCE_DONE_SHIFT)
#define APB_CMC_INT_RAW_EVENT_0_MAINTENANCE_DONE_RANGE                  0:0
#define APB_CMC_INT_RAW_EVENT_0_MAINTENANCE_DONE_WOFFSET                        0x0
#define APB_CMC_INT_RAW_EVENT_0_MAINTENANCE_DONE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_CMC_INT_RAW_EVENT_0_MAINTENANCE_DONE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APB_CMC_INT_RAW_EVENT_0_MAINTENANCE_DONE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_CMC_INT_RAW_EVENT_0_MAINTENANCE_DONE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APB_CMC_INT_STATUS_0  
#define APB_CMC_INT_STATUS_0                    _MK_ADDR_CONST(0x68)
#define APB_CMC_INT_STATUS_0_WORD_COUNT                         0x1
#define APB_CMC_INT_STATUS_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APB_CMC_INT_STATUS_0_RESET_MASK                         _MK_MASK_CONST(0x1)
#define APB_CMC_INT_STATUS_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APB_CMC_INT_STATUS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APB_CMC_INT_STATUS_0_READ_MASK                  _MK_MASK_CONST(0x1)
#define APB_CMC_INT_STATUS_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
// Interrupt status(masked) for MAINTENANCE_DONE
#define APB_CMC_INT_STATUS_0_MAINTENANCE_DONE_SHIFT                     _MK_SHIFT_CONST(0)
#define APB_CMC_INT_STATUS_0_MAINTENANCE_DONE_FIELD                     (_MK_MASK_CONST(0x1) << APB_CMC_INT_STATUS_0_MAINTENANCE_DONE_SHIFT)
#define APB_CMC_INT_STATUS_0_MAINTENANCE_DONE_RANGE                     0:0
#define APB_CMC_INT_STATUS_0_MAINTENANCE_DONE_WOFFSET                   0x0
#define APB_CMC_INT_STATUS_0_MAINTENANCE_DONE_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_CMC_INT_STATUS_0_MAINTENANCE_DONE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_CMC_INT_STATUS_0_MAINTENANCE_DONE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APB_CMC_INT_STATUS_0_MAINTENANCE_DONE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APB_CMC_CLKEN_OVERRIDE_0  
#define APB_CMC_CLKEN_OVERRIDE_0                        _MK_ADDR_CONST(0x6c)
#define APB_CMC_CLKEN_OVERRIDE_0_WORD_COUNT                     0x1
#define APB_CMC_CLKEN_OVERRIDE_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APB_CMC_CLKEN_OVERRIDE_0_RESET_MASK                     _MK_MASK_CONST(0x1f)
#define APB_CMC_CLKEN_OVERRIDE_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APB_CMC_CLKEN_OVERRIDE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define APB_CMC_CLKEN_OVERRIDE_0_READ_MASK                      _MK_MASK_CONST(0x1f)
#define APB_CMC_CLKEN_OVERRIDE_0_WRITE_MASK                     _MK_MASK_CONST(0x1f)
// Fine Grain
#define APB_CMC_CLKEN_OVERRIDE_0_CMCCLK_CLKEN_OVR_SHIFT                 _MK_SHIFT_CONST(0)
#define APB_CMC_CLKEN_OVERRIDE_0_CMCCLK_CLKEN_OVR_FIELD                 (_MK_MASK_CONST(0x1) << APB_CMC_CLKEN_OVERRIDE_0_CMCCLK_CLKEN_OVR_SHIFT)
#define APB_CMC_CLKEN_OVERRIDE_0_CMCCLK_CLKEN_OVR_RANGE                 0:0
#define APB_CMC_CLKEN_OVERRIDE_0_CMCCLK_CLKEN_OVR_WOFFSET                       0x0
#define APB_CMC_CLKEN_OVERRIDE_0_CMCCLK_CLKEN_OVR_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_CMC_CLKEN_OVERRIDE_0_CMCCLK_CLKEN_OVR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_CMC_CLKEN_OVERRIDE_0_CMCCLK_CLKEN_OVR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_CMC_CLKEN_OVERRIDE_0_CMCCLK_CLKEN_OVR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_CMC_CLKEN_OVERRIDE_0_CMCCLK_CLKEN_OVR_INIT_ENUM                     CLK_GATED
#define APB_CMC_CLKEN_OVERRIDE_0_CMCCLK_CLKEN_OVR_CLK_GATED                     _MK_ENUM_CONST(0)
#define APB_CMC_CLKEN_OVERRIDE_0_CMCCLK_CLKEN_OVR_CLK_ALWAYS_ON                 _MK_ENUM_CONST(1)

// Fine Grain override
#define APB_CMC_CLKEN_OVERRIDE_0_MSLIFCLK_CLKEN_OVR_SHIFT                       _MK_SHIFT_CONST(1)
#define APB_CMC_CLKEN_OVERRIDE_0_MSLIFCLK_CLKEN_OVR_FIELD                       (_MK_MASK_CONST(0x1) << APB_CMC_CLKEN_OVERRIDE_0_MSLIFCLK_CLKEN_OVR_SHIFT)
#define APB_CMC_CLKEN_OVERRIDE_0_MSLIFCLK_CLKEN_OVR_RANGE                       1:1
#define APB_CMC_CLKEN_OVERRIDE_0_MSLIFCLK_CLKEN_OVR_WOFFSET                     0x0
#define APB_CMC_CLKEN_OVERRIDE_0_MSLIFCLK_CLKEN_OVR_DEFAULT                     _MK_MASK_CONST(0x0)
#define APB_CMC_CLKEN_OVERRIDE_0_MSLIFCLK_CLKEN_OVR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APB_CMC_CLKEN_OVERRIDE_0_MSLIFCLK_CLKEN_OVR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APB_CMC_CLKEN_OVERRIDE_0_MSLIFCLK_CLKEN_OVR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APB_CMC_CLKEN_OVERRIDE_0_MSLIFCLK_CLKEN_OVR_INIT_ENUM                   CLK_GATED
#define APB_CMC_CLKEN_OVERRIDE_0_MSLIFCLK_CLKEN_OVR_CLK_GATED                   _MK_ENUM_CONST(0)
#define APB_CMC_CLKEN_OVERRIDE_0_MSLIFCLK_CLKEN_OVR_CLK_ALWAYS_ON                       _MK_ENUM_CONST(1)

// Fine Grain override
#define APB_CMC_CLKEN_OVERRIDE_0_DATACLK_CLKEN_OVR_SHIFT                        _MK_SHIFT_CONST(2)
#define APB_CMC_CLKEN_OVERRIDE_0_DATACLK_CLKEN_OVR_FIELD                        (_MK_MASK_CONST(0x1) << APB_CMC_CLKEN_OVERRIDE_0_DATACLK_CLKEN_OVR_SHIFT)
#define APB_CMC_CLKEN_OVERRIDE_0_DATACLK_CLKEN_OVR_RANGE                        2:2
#define APB_CMC_CLKEN_OVERRIDE_0_DATACLK_CLKEN_OVR_WOFFSET                      0x0
#define APB_CMC_CLKEN_OVERRIDE_0_DATACLK_CLKEN_OVR_DEFAULT                      _MK_MASK_CONST(0x0)
#define APB_CMC_CLKEN_OVERRIDE_0_DATACLK_CLKEN_OVR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APB_CMC_CLKEN_OVERRIDE_0_DATACLK_CLKEN_OVR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APB_CMC_CLKEN_OVERRIDE_0_DATACLK_CLKEN_OVR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APB_CMC_CLKEN_OVERRIDE_0_DATACLK_CLKEN_OVR_INIT_ENUM                    CLK_GATED
#define APB_CMC_CLKEN_OVERRIDE_0_DATACLK_CLKEN_OVR_CLK_GATED                    _MK_ENUM_CONST(0)
#define APB_CMC_CLKEN_OVERRIDE_0_DATACLK_CLKEN_OVR_CLK_ALWAYS_ON                        _MK_ENUM_CONST(1)

// Fine Grain override
#define APB_CMC_CLKEN_OVERRIDE_0_TAGCLK_CLKEN_OVR_SHIFT                 _MK_SHIFT_CONST(3)
#define APB_CMC_CLKEN_OVERRIDE_0_TAGCLK_CLKEN_OVR_FIELD                 (_MK_MASK_CONST(0x1) << APB_CMC_CLKEN_OVERRIDE_0_TAGCLK_CLKEN_OVR_SHIFT)
#define APB_CMC_CLKEN_OVERRIDE_0_TAGCLK_CLKEN_OVR_RANGE                 3:3
#define APB_CMC_CLKEN_OVERRIDE_0_TAGCLK_CLKEN_OVR_WOFFSET                       0x0
#define APB_CMC_CLKEN_OVERRIDE_0_TAGCLK_CLKEN_OVR_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_CMC_CLKEN_OVERRIDE_0_TAGCLK_CLKEN_OVR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_CMC_CLKEN_OVERRIDE_0_TAGCLK_CLKEN_OVR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_CMC_CLKEN_OVERRIDE_0_TAGCLK_CLKEN_OVR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_CMC_CLKEN_OVERRIDE_0_TAGCLK_CLKEN_OVR_INIT_ENUM                     CLK_GATED
#define APB_CMC_CLKEN_OVERRIDE_0_TAGCLK_CLKEN_OVR_CLK_GATED                     _MK_ENUM_CONST(0)
#define APB_CMC_CLKEN_OVERRIDE_0_TAGCLK_CLKEN_OVR_CLK_ALWAYS_ON                 _MK_ENUM_CONST(1)

// Fine Grain override
#define APB_CMC_CLKEN_OVERRIDE_0_APBCLK_CLKEN_OVR_SHIFT                 _MK_SHIFT_CONST(4)
#define APB_CMC_CLKEN_OVERRIDE_0_APBCLK_CLKEN_OVR_FIELD                 (_MK_MASK_CONST(0x1) << APB_CMC_CLKEN_OVERRIDE_0_APBCLK_CLKEN_OVR_SHIFT)
#define APB_CMC_CLKEN_OVERRIDE_0_APBCLK_CLKEN_OVR_RANGE                 4:4
#define APB_CMC_CLKEN_OVERRIDE_0_APBCLK_CLKEN_OVR_WOFFSET                       0x0
#define APB_CMC_CLKEN_OVERRIDE_0_APBCLK_CLKEN_OVR_DEFAULT                       _MK_MASK_CONST(0x0)
#define APB_CMC_CLKEN_OVERRIDE_0_APBCLK_CLKEN_OVR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APB_CMC_CLKEN_OVERRIDE_0_APBCLK_CLKEN_OVR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APB_CMC_CLKEN_OVERRIDE_0_APBCLK_CLKEN_OVR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APB_CMC_CLKEN_OVERRIDE_0_APBCLK_CLKEN_OVR_INIT_ENUM                     CLK_GATED
#define APB_CMC_CLKEN_OVERRIDE_0_APBCLK_CLKEN_OVR_CLK_GATED                     _MK_ENUM_CONST(0)
#define APB_CMC_CLKEN_OVERRIDE_0_APBCLK_CLKEN_OVR_CLK_ALWAYS_ON                 _MK_ENUM_CONST(1)


//
// REGISTER LIST
//
#define LIST_ARAPB_CMC_REGS(_op_) \
_op_(APB_CMC_CONFIG_0) \
_op_(APB_CMC_LOCK_0) \
_op_(APB_CMC_SIZE_0) \
_op_(APB_CMC_MAINT_0_0) \
_op_(APB_CMC_MAINT_1_0) \
_op_(APB_CMC_MAINT_1) \
_op_(APB_CMC_MAINT_1_1) \
_op_(APB_CMC_MAINT_1_2) \
_op_(APB_CMC_MAINT_1_3) \
_op_(APB_CMC_MAINT_1_4) \
_op_(APB_CMC_MAINT_1_5) \
_op_(APB_CMC_MAINT_1_6) \
_op_(APB_CMC_MAINT_1_7) \
_op_(APB_CMC_MAINT_2_0) \
_op_(APB_CMC_LFSR_0) \
_op_(APB_CMC_STAT_CONTROL_0) \
_op_(APB_CMC_STAT_STATE_0) \
_op_(APB_CMC_STAT_FILTER_0) \
_op_(APB_CMC_STAT_CLOCK_0) \
_op_(APB_CMC_STAT_HIT_0) \
_op_(APB_CMC_STAT_MISS_ALLOC_0) \
_op_(APB_CMC_STAT_MISS_NO_ALLOC_0) \
_op_(APB_CMC_STAT_MISS_EVICT_0) \
_op_(APB_CMC_STAT_ADDR_HAZARD_0) \
_op_(APB_CMC_INT_MASK_0) \
_op_(APB_CMC_INT_CLEAR_0) \
_op_(APB_CMC_INT_RAW_EVENT_0) \
_op_(APB_CMC_INT_STATUS_0) \
_op_(APB_CMC_CLKEN_OVERRIDE_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_APB_CMC    0x00000000

//
// ARAPB_CMC REGISTER BANKS
//

#define APB_CMC0_FIRST_REG 0x0000 // APB_CMC_CONFIG_0
#define APB_CMC0_LAST_REG 0x006c // APB_CMC_CLKEN_OVERRIDE_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARAPB_CMC_H_INC_
