/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARAPBDMA_H_INC_
#define ___ARAPBDMA_H_INC_

// Register APBDMA_COMMAND_0  
#define APBDMA_COMMAND_0                        _MK_ADDR_CONST(0x0)
#define APBDMA_COMMAND_0_WORD_COUNT                     0x1
#define APBDMA_COMMAND_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APBDMA_COMMAND_0_RESET_MASK                     _MK_MASK_CONST(0x80000000)
#define APBDMA_COMMAND_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APBDMA_COMMAND_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_COMMAND_0_READ_MASK                      _MK_MASK_CONST(0x80000000)
#define APBDMA_COMMAND_0_WRITE_MASK                     _MK_MASK_CONST(0x80000000)
// Enables Global APB-DMA  
#define APBDMA_COMMAND_0_GEN_SHIFT                      _MK_SHIFT_CONST(31)
#define APBDMA_COMMAND_0_GEN_FIELD                      (_MK_MASK_CONST(0x1) << APBDMA_COMMAND_0_GEN_SHIFT)
#define APBDMA_COMMAND_0_GEN_RANGE                      31:31
#define APBDMA_COMMAND_0_GEN_WOFFSET                    0x0
#define APBDMA_COMMAND_0_GEN_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_COMMAND_0_GEN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMA_COMMAND_0_GEN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_COMMAND_0_GEN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMA_COMMAND_0_GEN_DISABLE                    _MK_ENUM_CONST(0)
#define APBDMA_COMMAND_0_GEN_ENABLE                     _MK_ENUM_CONST(1)


// Register APBDMA_STATUS_0  
#define APBDMA_STATUS_0                 _MK_ADDR_CONST(0x4)
#define APBDMA_STATUS_0_WORD_COUNT                      0x1
#define APBDMA_STATUS_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define APBDMA_STATUS_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define APBDMA_STATUS_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
// DMA channel15  status 
#define APBDMA_STATUS_0_BSY_15_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMA_STATUS_0_BSY_15_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_BSY_15_SHIFT)
#define APBDMA_STATUS_0_BSY_15_RANGE                    31:31
#define APBDMA_STATUS_0_BSY_15_WOFFSET                  0x0
#define APBDMA_STATUS_0_BSY_15_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_15_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_BSY_15_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_15_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_15_NOT_BUSY                 _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_BSY_15_BUSY                     _MK_ENUM_CONST(1)

// DMA channel14  status
#define APBDMA_STATUS_0_BSY_14_SHIFT                    _MK_SHIFT_CONST(30)
#define APBDMA_STATUS_0_BSY_14_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_BSY_14_SHIFT)
#define APBDMA_STATUS_0_BSY_14_RANGE                    30:30
#define APBDMA_STATUS_0_BSY_14_WOFFSET                  0x0
#define APBDMA_STATUS_0_BSY_14_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_14_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_BSY_14_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_14_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_14_NOT_BUSY                 _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_BSY_14_BUSY                     _MK_ENUM_CONST(1)

// DMA channel13  status 
#define APBDMA_STATUS_0_BSY_13_SHIFT                    _MK_SHIFT_CONST(29)
#define APBDMA_STATUS_0_BSY_13_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_BSY_13_SHIFT)
#define APBDMA_STATUS_0_BSY_13_RANGE                    29:29
#define APBDMA_STATUS_0_BSY_13_WOFFSET                  0x0
#define APBDMA_STATUS_0_BSY_13_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_13_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_BSY_13_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_13_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_13_NOT_BUSY                 _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_BSY_13_BUSY                     _MK_ENUM_CONST(1)

// DMA channel12  status 
#define APBDMA_STATUS_0_BSY_12_SHIFT                    _MK_SHIFT_CONST(28)
#define APBDMA_STATUS_0_BSY_12_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_BSY_12_SHIFT)
#define APBDMA_STATUS_0_BSY_12_RANGE                    28:28
#define APBDMA_STATUS_0_BSY_12_WOFFSET                  0x0
#define APBDMA_STATUS_0_BSY_12_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_12_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_BSY_12_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_12_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_12_NOT_BUSY                 _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_BSY_12_BUSY                     _MK_ENUM_CONST(1)

// DMA channel11  status 
#define APBDMA_STATUS_0_BSY_11_SHIFT                    _MK_SHIFT_CONST(27)
#define APBDMA_STATUS_0_BSY_11_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_BSY_11_SHIFT)
#define APBDMA_STATUS_0_BSY_11_RANGE                    27:27
#define APBDMA_STATUS_0_BSY_11_WOFFSET                  0x0
#define APBDMA_STATUS_0_BSY_11_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_11_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_BSY_11_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_11_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_11_NOT_BUSY                 _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_BSY_11_BUSY                     _MK_ENUM_CONST(1)

// DMA channel10  status
#define APBDMA_STATUS_0_BSY_10_SHIFT                    _MK_SHIFT_CONST(26)
#define APBDMA_STATUS_0_BSY_10_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_BSY_10_SHIFT)
#define APBDMA_STATUS_0_BSY_10_RANGE                    26:26
#define APBDMA_STATUS_0_BSY_10_WOFFSET                  0x0
#define APBDMA_STATUS_0_BSY_10_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_10_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_BSY_10_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_10_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_10_NOT_BUSY                 _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_BSY_10_BUSY                     _MK_ENUM_CONST(1)

// DMA channel9  status 
#define APBDMA_STATUS_0_BSY_9_SHIFT                     _MK_SHIFT_CONST(25)
#define APBDMA_STATUS_0_BSY_9_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_BSY_9_SHIFT)
#define APBDMA_STATUS_0_BSY_9_RANGE                     25:25
#define APBDMA_STATUS_0_BSY_9_WOFFSET                   0x0
#define APBDMA_STATUS_0_BSY_9_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_9_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_BSY_9_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_9_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_9_NOT_BUSY                  _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_BSY_9_BUSY                      _MK_ENUM_CONST(1)

// DMA channel8  status 
#define APBDMA_STATUS_0_BSY_8_SHIFT                     _MK_SHIFT_CONST(24)
#define APBDMA_STATUS_0_BSY_8_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_BSY_8_SHIFT)
#define APBDMA_STATUS_0_BSY_8_RANGE                     24:24
#define APBDMA_STATUS_0_BSY_8_WOFFSET                   0x0
#define APBDMA_STATUS_0_BSY_8_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_8_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_BSY_8_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_8_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_8_NOT_BUSY                  _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_BSY_8_BUSY                      _MK_ENUM_CONST(1)

// DMA channel7  status 
#define APBDMA_STATUS_0_BSY_7_SHIFT                     _MK_SHIFT_CONST(23)
#define APBDMA_STATUS_0_BSY_7_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_BSY_7_SHIFT)
#define APBDMA_STATUS_0_BSY_7_RANGE                     23:23
#define APBDMA_STATUS_0_BSY_7_WOFFSET                   0x0
#define APBDMA_STATUS_0_BSY_7_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_7_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_BSY_7_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_7_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_7_NOT_BUSY                  _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_BSY_7_BUSY                      _MK_ENUM_CONST(1)

// DMA channel6  status 
#define APBDMA_STATUS_0_BSY_6_SHIFT                     _MK_SHIFT_CONST(22)
#define APBDMA_STATUS_0_BSY_6_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_BSY_6_SHIFT)
#define APBDMA_STATUS_0_BSY_6_RANGE                     22:22
#define APBDMA_STATUS_0_BSY_6_WOFFSET                   0x0
#define APBDMA_STATUS_0_BSY_6_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_6_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_BSY_6_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_6_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_6_NOT_BUSY                  _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_BSY_6_BUSY                      _MK_ENUM_CONST(1)

// DMA channel5  status 
#define APBDMA_STATUS_0_BSY_5_SHIFT                     _MK_SHIFT_CONST(21)
#define APBDMA_STATUS_0_BSY_5_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_BSY_5_SHIFT)
#define APBDMA_STATUS_0_BSY_5_RANGE                     21:21
#define APBDMA_STATUS_0_BSY_5_WOFFSET                   0x0
#define APBDMA_STATUS_0_BSY_5_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_5_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_BSY_5_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_5_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_5_NOT_BUSY                  _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_BSY_5_BUSY                      _MK_ENUM_CONST(1)

// DMA channel4  status 
#define APBDMA_STATUS_0_BSY_4_SHIFT                     _MK_SHIFT_CONST(20)
#define APBDMA_STATUS_0_BSY_4_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_BSY_4_SHIFT)
#define APBDMA_STATUS_0_BSY_4_RANGE                     20:20
#define APBDMA_STATUS_0_BSY_4_WOFFSET                   0x0
#define APBDMA_STATUS_0_BSY_4_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_4_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_BSY_4_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_4_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_4_NOT_BUSY                  _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_BSY_4_BUSY                      _MK_ENUM_CONST(1)

// DMA channel3  status 
#define APBDMA_STATUS_0_BSY_3_SHIFT                     _MK_SHIFT_CONST(19)
#define APBDMA_STATUS_0_BSY_3_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_BSY_3_SHIFT)
#define APBDMA_STATUS_0_BSY_3_RANGE                     19:19
#define APBDMA_STATUS_0_BSY_3_WOFFSET                   0x0
#define APBDMA_STATUS_0_BSY_3_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_3_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_BSY_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_3_NOT_BUSY                  _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_BSY_3_BUSY                      _MK_ENUM_CONST(1)

// DMA channel2  status 
#define APBDMA_STATUS_0_BSY_2_SHIFT                     _MK_SHIFT_CONST(18)
#define APBDMA_STATUS_0_BSY_2_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_BSY_2_SHIFT)
#define APBDMA_STATUS_0_BSY_2_RANGE                     18:18
#define APBDMA_STATUS_0_BSY_2_WOFFSET                   0x0
#define APBDMA_STATUS_0_BSY_2_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_BSY_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_2_NOT_BUSY                  _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_BSY_2_BUSY                      _MK_ENUM_CONST(1)

// DMA channel1  status 
#define APBDMA_STATUS_0_BSY_1_SHIFT                     _MK_SHIFT_CONST(17)
#define APBDMA_STATUS_0_BSY_1_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_BSY_1_SHIFT)
#define APBDMA_STATUS_0_BSY_1_RANGE                     17:17
#define APBDMA_STATUS_0_BSY_1_WOFFSET                   0x0
#define APBDMA_STATUS_0_BSY_1_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_BSY_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_1_NOT_BUSY                  _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_BSY_1_BUSY                      _MK_ENUM_CONST(1)

// DMA channel0  status 
#define APBDMA_STATUS_0_BSY_0_SHIFT                     _MK_SHIFT_CONST(16)
#define APBDMA_STATUS_0_BSY_0_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_BSY_0_SHIFT)
#define APBDMA_STATUS_0_BSY_0_RANGE                     16:16
#define APBDMA_STATUS_0_BSY_0_WOFFSET                   0x0
#define APBDMA_STATUS_0_BSY_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_BSY_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_BSY_0_NOT_BUSY                  _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_BSY_0_BUSY                      _MK_ENUM_CONST(1)

// DMA channel15 Interrupt Status
#define APBDMA_STATUS_0_ISE_EOC_15_SHIFT                        _MK_SHIFT_CONST(15)
#define APBDMA_STATUS_0_ISE_EOC_15_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_ISE_EOC_15_SHIFT)
#define APBDMA_STATUS_0_ISE_EOC_15_RANGE                        15:15
#define APBDMA_STATUS_0_ISE_EOC_15_WOFFSET                      0x0
#define APBDMA_STATUS_0_ISE_EOC_15_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_15_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_ISE_EOC_15_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_15_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_15_NOT_ACTIVE                   _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_15_ACTIVE                       _MK_ENUM_CONST(1)

// DMA channel14 Interrupt Status 
#define APBDMA_STATUS_0_ISE_EOC_14_SHIFT                        _MK_SHIFT_CONST(14)
#define APBDMA_STATUS_0_ISE_EOC_14_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_ISE_EOC_14_SHIFT)
#define APBDMA_STATUS_0_ISE_EOC_14_RANGE                        14:14
#define APBDMA_STATUS_0_ISE_EOC_14_WOFFSET                      0x0
#define APBDMA_STATUS_0_ISE_EOC_14_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_14_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_ISE_EOC_14_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_14_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_14_NOT_ACTIVE                   _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_14_ACTIVE                       _MK_ENUM_CONST(1)

// DMA channel13 Interrupt Status 
#define APBDMA_STATUS_0_ISE_EOC_13_SHIFT                        _MK_SHIFT_CONST(13)
#define APBDMA_STATUS_0_ISE_EOC_13_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_ISE_EOC_13_SHIFT)
#define APBDMA_STATUS_0_ISE_EOC_13_RANGE                        13:13
#define APBDMA_STATUS_0_ISE_EOC_13_WOFFSET                      0x0
#define APBDMA_STATUS_0_ISE_EOC_13_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_13_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_ISE_EOC_13_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_13_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_13_NOT_ACTIVE                   _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_13_ACTIVE                       _MK_ENUM_CONST(1)

// DMA channel12 Interrupt Status 
#define APBDMA_STATUS_0_ISE_EOC_12_SHIFT                        _MK_SHIFT_CONST(12)
#define APBDMA_STATUS_0_ISE_EOC_12_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_ISE_EOC_12_SHIFT)
#define APBDMA_STATUS_0_ISE_EOC_12_RANGE                        12:12
#define APBDMA_STATUS_0_ISE_EOC_12_WOFFSET                      0x0
#define APBDMA_STATUS_0_ISE_EOC_12_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_12_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_ISE_EOC_12_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_12_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_12_NOT_ACTIVE                   _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_12_ACTIVE                       _MK_ENUM_CONST(1)

// DMA channel11 Interrupt Status 
#define APBDMA_STATUS_0_ISE_EOC_11_SHIFT                        _MK_SHIFT_CONST(11)
#define APBDMA_STATUS_0_ISE_EOC_11_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_ISE_EOC_11_SHIFT)
#define APBDMA_STATUS_0_ISE_EOC_11_RANGE                        11:11
#define APBDMA_STATUS_0_ISE_EOC_11_WOFFSET                      0x0
#define APBDMA_STATUS_0_ISE_EOC_11_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_11_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_ISE_EOC_11_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_11_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_11_NOT_ACTIVE                   _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_11_ACTIVE                       _MK_ENUM_CONST(1)

// DMA channel10 Interrupt Status
#define APBDMA_STATUS_0_ISE_EOC_10_SHIFT                        _MK_SHIFT_CONST(10)
#define APBDMA_STATUS_0_ISE_EOC_10_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_ISE_EOC_10_SHIFT)
#define APBDMA_STATUS_0_ISE_EOC_10_RANGE                        10:10
#define APBDMA_STATUS_0_ISE_EOC_10_WOFFSET                      0x0
#define APBDMA_STATUS_0_ISE_EOC_10_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_10_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_ISE_EOC_10_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_10_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_10_NOT_ACTIVE                   _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_10_ACTIVE                       _MK_ENUM_CONST(1)

// DMA channel9  Interrupt Status 
#define APBDMA_STATUS_0_ISE_EOC_9_SHIFT                 _MK_SHIFT_CONST(9)
#define APBDMA_STATUS_0_ISE_EOC_9_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_ISE_EOC_9_SHIFT)
#define APBDMA_STATUS_0_ISE_EOC_9_RANGE                 9:9
#define APBDMA_STATUS_0_ISE_EOC_9_WOFFSET                       0x0
#define APBDMA_STATUS_0_ISE_EOC_9_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_9_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_ISE_EOC_9_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_9_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_9_NOT_ACTIVE                    _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_9_ACTIVE                        _MK_ENUM_CONST(1)

// DMA channel8  Interrupt Status 
#define APBDMA_STATUS_0_ISE_EOC_8_SHIFT                 _MK_SHIFT_CONST(8)
#define APBDMA_STATUS_0_ISE_EOC_8_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_ISE_EOC_8_SHIFT)
#define APBDMA_STATUS_0_ISE_EOC_8_RANGE                 8:8
#define APBDMA_STATUS_0_ISE_EOC_8_WOFFSET                       0x0
#define APBDMA_STATUS_0_ISE_EOC_8_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_8_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_ISE_EOC_8_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_8_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_8_NOT_ACTIVE                    _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_8_ACTIVE                        _MK_ENUM_CONST(1)

// DMA channel7  Interrupt Status 
#define APBDMA_STATUS_0_ISE_EOC_7_SHIFT                 _MK_SHIFT_CONST(7)
#define APBDMA_STATUS_0_ISE_EOC_7_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_ISE_EOC_7_SHIFT)
#define APBDMA_STATUS_0_ISE_EOC_7_RANGE                 7:7
#define APBDMA_STATUS_0_ISE_EOC_7_WOFFSET                       0x0
#define APBDMA_STATUS_0_ISE_EOC_7_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_7_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_ISE_EOC_7_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_7_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_7_NOT_ACTIVE                    _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_7_ACTIVE                        _MK_ENUM_CONST(1)

// DMA channel6  Interrupt Status 
#define APBDMA_STATUS_0_ISE_EOC_6_SHIFT                 _MK_SHIFT_CONST(6)
#define APBDMA_STATUS_0_ISE_EOC_6_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_ISE_EOC_6_SHIFT)
#define APBDMA_STATUS_0_ISE_EOC_6_RANGE                 6:6
#define APBDMA_STATUS_0_ISE_EOC_6_WOFFSET                       0x0
#define APBDMA_STATUS_0_ISE_EOC_6_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_6_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_ISE_EOC_6_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_6_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_6_NOT_ACTIVE                    _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_6_ACTIVE                        _MK_ENUM_CONST(1)

// DMA channel5  Interrupt Status 
#define APBDMA_STATUS_0_ISE_EOC_5_SHIFT                 _MK_SHIFT_CONST(5)
#define APBDMA_STATUS_0_ISE_EOC_5_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_ISE_EOC_5_SHIFT)
#define APBDMA_STATUS_0_ISE_EOC_5_RANGE                 5:5
#define APBDMA_STATUS_0_ISE_EOC_5_WOFFSET                       0x0
#define APBDMA_STATUS_0_ISE_EOC_5_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_5_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_ISE_EOC_5_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_5_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_5_NOT_ACTIVE                    _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_5_ACTIVE                        _MK_ENUM_CONST(1)

// DMA channel4  Interrupt Status 
#define APBDMA_STATUS_0_ISE_EOC_4_SHIFT                 _MK_SHIFT_CONST(4)
#define APBDMA_STATUS_0_ISE_EOC_4_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_ISE_EOC_4_SHIFT)
#define APBDMA_STATUS_0_ISE_EOC_4_RANGE                 4:4
#define APBDMA_STATUS_0_ISE_EOC_4_WOFFSET                       0x0
#define APBDMA_STATUS_0_ISE_EOC_4_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_4_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_ISE_EOC_4_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_4_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_4_NOT_ACTIVE                    _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_4_ACTIVE                        _MK_ENUM_CONST(1)

// DMA channel3  Interrupt Status 
#define APBDMA_STATUS_0_ISE_EOC_3_SHIFT                 _MK_SHIFT_CONST(3)
#define APBDMA_STATUS_0_ISE_EOC_3_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_ISE_EOC_3_SHIFT)
#define APBDMA_STATUS_0_ISE_EOC_3_RANGE                 3:3
#define APBDMA_STATUS_0_ISE_EOC_3_WOFFSET                       0x0
#define APBDMA_STATUS_0_ISE_EOC_3_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_3_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_ISE_EOC_3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_3_NOT_ACTIVE                    _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_3_ACTIVE                        _MK_ENUM_CONST(1)

// DMA channel2  Interrupt Status 
#define APBDMA_STATUS_0_ISE_EOC_2_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMA_STATUS_0_ISE_EOC_2_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_ISE_EOC_2_SHIFT)
#define APBDMA_STATUS_0_ISE_EOC_2_RANGE                 2:2
#define APBDMA_STATUS_0_ISE_EOC_2_WOFFSET                       0x0
#define APBDMA_STATUS_0_ISE_EOC_2_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_2_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_ISE_EOC_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_2_NOT_ACTIVE                    _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_2_ACTIVE                        _MK_ENUM_CONST(1)

// DMA channel1  Interrupt Status 
#define APBDMA_STATUS_0_ISE_EOC_1_SHIFT                 _MK_SHIFT_CONST(1)
#define APBDMA_STATUS_0_ISE_EOC_1_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_ISE_EOC_1_SHIFT)
#define APBDMA_STATUS_0_ISE_EOC_1_RANGE                 1:1
#define APBDMA_STATUS_0_ISE_EOC_1_WOFFSET                       0x0
#define APBDMA_STATUS_0_ISE_EOC_1_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_1_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_ISE_EOC_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_1_NOT_ACTIVE                    _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_1_ACTIVE                        _MK_ENUM_CONST(1)

// DMA channel0  Interrupt Status 
#define APBDMA_STATUS_0_ISE_EOC_0_SHIFT                 _MK_SHIFT_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_0_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_STATUS_0_ISE_EOC_0_SHIFT)
#define APBDMA_STATUS_0_ISE_EOC_0_RANGE                 0:0
#define APBDMA_STATUS_0_ISE_EOC_0_WOFFSET                       0x0
#define APBDMA_STATUS_0_ISE_EOC_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_0_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_STATUS_0_ISE_EOC_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_STATUS_0_ISE_EOC_0_NOT_ACTIVE                    _MK_ENUM_CONST(0)
#define APBDMA_STATUS_0_ISE_EOC_0_ACTIVE                        _MK_ENUM_CONST(1)


// Register APBDMA_REQUESTORS_TX_0  
#define APBDMA_REQUESTORS_TX_0                  _MK_ADDR_CONST(0x8)
#define APBDMA_REQUESTORS_TX_0_WORD_COUNT                       0x1
#define APBDMA_REQUESTORS_TX_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_RESET_MASK                       _MK_MASK_CONST(0x3ffff)
#define APBDMA_REQUESTORS_TX_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_READ_MASK                        _MK_MASK_CONST(0x3ffff)
#define APBDMA_REQUESTORS_TX_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
// SLINK 2B-3
#define APBDMA_REQUESTORS_TX_0_SL2B3_SHIFT                      _MK_SHIFT_CONST(17)
#define APBDMA_REQUESTORS_TX_0_SL2B3_FIELD                      (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_SL2B3_SHIFT)
#define APBDMA_REQUESTORS_TX_0_SL2B3_RANGE                      17:17
#define APBDMA_REQUESTORS_TX_0_SL2B3_WOFFSET                    0x0
#define APBDMA_REQUESTORS_TX_0_SL2B3_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SL2B3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_SL2B3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SL2B3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SL2B3_NOT_ACTIVE                 _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_SL2B3_ACTIVE                     _MK_ENUM_CONST(1)

// SLINK 2B-2
#define APBDMA_REQUESTORS_TX_0_SL2B2_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMA_REQUESTORS_TX_0_SL2B2_FIELD                      (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_SL2B2_SHIFT)
#define APBDMA_REQUESTORS_TX_0_SL2B2_RANGE                      16:16
#define APBDMA_REQUESTORS_TX_0_SL2B2_WOFFSET                    0x0
#define APBDMA_REQUESTORS_TX_0_SL2B2_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SL2B2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_SL2B2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SL2B2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SL2B2_NOT_ACTIVE                 _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_SL2B2_ACTIVE                     _MK_ENUM_CONST(1)

// SLINK 2B-1
#define APBDMA_REQUESTORS_TX_0_SL2B1_SHIFT                      _MK_SHIFT_CONST(15)
#define APBDMA_REQUESTORS_TX_0_SL2B1_FIELD                      (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_SL2B1_SHIFT)
#define APBDMA_REQUESTORS_TX_0_SL2B1_RANGE                      15:15
#define APBDMA_REQUESTORS_TX_0_SL2B1_WOFFSET                    0x0
#define APBDMA_REQUESTORS_TX_0_SL2B1_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SL2B1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_SL2B1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SL2B1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SL2B1_NOT_ACTIVE                 _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_SL2B1_ACTIVE                     _MK_ENUM_CONST(1)

// SLINK 4B
#define APBDMA_REQUESTORS_TX_0_SL4B_SHIFT                       _MK_SHIFT_CONST(14)
#define APBDMA_REQUESTORS_TX_0_SL4B_FIELD                       (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_SL4B_SHIFT)
#define APBDMA_REQUESTORS_TX_0_SL4B_RANGE                       14:14
#define APBDMA_REQUESTORS_TX_0_SL4B_WOFFSET                     0x0
#define APBDMA_REQUESTORS_TX_0_SL4B_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SL4B_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_SL4B_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SL4B_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SL4B_NOT_ACTIVE                  _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_SL4B_ACTIVE                      _MK_ENUM_CONST(1)

// ACModem
#define APBDMA_REQUESTORS_TX_0_ACModem_SHIFT                    _MK_SHIFT_CONST(13)
#define APBDMA_REQUESTORS_TX_0_ACModem_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_ACModem_SHIFT)
#define APBDMA_REQUESTORS_TX_0_ACModem_RANGE                    13:13
#define APBDMA_REQUESTORS_TX_0_ACModem_WOFFSET                  0x0
#define APBDMA_REQUESTORS_TX_0_ACModem_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_ACModem_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_ACModem_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_ACModem_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_ACModem_NOT_ACTIVE                       _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_ACModem_ACTIVE                   _MK_ENUM_CONST(1)

// AC97
#define APBDMA_REQUESTORS_TX_0_AC97_SHIFT                       _MK_SHIFT_CONST(12)
#define APBDMA_REQUESTORS_TX_0_AC97_FIELD                       (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_AC97_SHIFT)
#define APBDMA_REQUESTORS_TX_0_AC97_RANGE                       12:12
#define APBDMA_REQUESTORS_TX_0_AC97_WOFFSET                     0x0
#define APBDMA_REQUESTORS_TX_0_AC97_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_AC97_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_AC97_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_AC97_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_AC97_NOT_ACTIVE                  _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_AC97_ACTIVE                      _MK_ENUM_CONST(1)

// SPI Controller
#define APBDMA_REQUESTORS_TX_0_SPI_SHIFT                        _MK_SHIFT_CONST(11)
#define APBDMA_REQUESTORS_TX_0_SPI_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_SPI_SHIFT)
#define APBDMA_REQUESTORS_TX_0_SPI_RANGE                        11:11
#define APBDMA_REQUESTORS_TX_0_SPI_WOFFSET                      0x0
#define APBDMA_REQUESTORS_TX_0_SPI_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SPI_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_SPI_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SPI_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SPI_NOT_ACTIVE                   _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_SPI_ACTIVE                       _MK_ENUM_CONST(1)

// UART C
#define APBDMA_REQUESTORS_TX_0_UART_C_SHIFT                     _MK_SHIFT_CONST(10)
#define APBDMA_REQUESTORS_TX_0_UART_C_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_UART_C_SHIFT)
#define APBDMA_REQUESTORS_TX_0_UART_C_RANGE                     10:10
#define APBDMA_REQUESTORS_TX_0_UART_C_WOFFSET                   0x0
#define APBDMA_REQUESTORS_TX_0_UART_C_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_UART_C_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_UART_C_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_UART_C_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_UART_C_NOT_ACTIVE                        _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_UART_C_ACTIVE                    _MK_ENUM_CONST(1)

// UART B (VFIR)
#define APBDMA_REQUESTORS_TX_0_UART_B_SHIFT                     _MK_SHIFT_CONST(9)
#define APBDMA_REQUESTORS_TX_0_UART_B_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_UART_B_SHIFT)
#define APBDMA_REQUESTORS_TX_0_UART_B_RANGE                     9:9
#define APBDMA_REQUESTORS_TX_0_UART_B_WOFFSET                   0x0
#define APBDMA_REQUESTORS_TX_0_UART_B_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_UART_B_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_UART_B_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_UART_B_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_UART_B_NOT_ACTIVE                        _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_UART_B_ACTIVE                    _MK_ENUM_CONST(1)

// UART A
#define APBDMA_REQUESTORS_TX_0_UART_A_SHIFT                     _MK_SHIFT_CONST(8)
#define APBDMA_REQUESTORS_TX_0_UART_A_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_UART_A_SHIFT)
#define APBDMA_REQUESTORS_TX_0_UART_A_RANGE                     8:8
#define APBDMA_REQUESTORS_TX_0_UART_A_WOFFSET                   0x0
#define APBDMA_REQUESTORS_TX_0_UART_A_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_UART_A_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_UART_A_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_UART_A_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_UART_A_NOT_ACTIVE                        _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_UART_A_ACTIVE                    _MK_ENUM_CONST(1)

// I2S2 Tx Output FIFO1 (Play) (Peripheral initiated DMA request) 1 = Activate DMA transfer 0 = NOP
#define APBDMA_REQUESTORS_TX_0_I2S2_1_SHIFT                     _MK_SHIFT_CONST(7)
#define APBDMA_REQUESTORS_TX_0_I2S2_1_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_I2S2_1_SHIFT)
#define APBDMA_REQUESTORS_TX_0_I2S2_1_RANGE                     7:7
#define APBDMA_REQUESTORS_TX_0_I2S2_1_WOFFSET                   0x0
#define APBDMA_REQUESTORS_TX_0_I2S2_1_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_I2S2_1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_I2S2_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_I2S2_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_I2S2_1_NOT_ACTIVE                        _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_I2S2_1_ACTIVE                    _MK_ENUM_CONST(1)

// I2S2 Tx Output FIFO2 (Play) (Peripheral initiated DMA request) 1 = Activate DMA transfer 0 = NOP
#define APBDMA_REQUESTORS_TX_0_I2S2_2_SHIFT                     _MK_SHIFT_CONST(6)
#define APBDMA_REQUESTORS_TX_0_I2S2_2_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_I2S2_2_SHIFT)
#define APBDMA_REQUESTORS_TX_0_I2S2_2_RANGE                     6:6
#define APBDMA_REQUESTORS_TX_0_I2S2_2_WOFFSET                   0x0
#define APBDMA_REQUESTORS_TX_0_I2S2_2_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_I2S2_2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_I2S2_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_I2S2_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_I2S2_2_NOT_ACTIVE                        _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_I2S2_2_ACTIVE                    _MK_ENUM_CONST(1)

// MIPI Rx Input FIFO.
#define APBDMA_REQUESTORS_TX_0_MIPI_SHIFT                       _MK_SHIFT_CONST(5)
#define APBDMA_REQUESTORS_TX_0_MIPI_FIELD                       (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_MIPI_SHIFT)
#define APBDMA_REQUESTORS_TX_0_MIPI_RANGE                       5:5
#define APBDMA_REQUESTORS_TX_0_MIPI_WOFFSET                     0x0
#define APBDMA_REQUESTORS_TX_0_MIPI_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_MIPI_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_MIPI_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_MIPI_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// EBU USR Output (Peripheral initiated DMA request) 1 = Activate DMA transfer 0 = NOP
#define APBDMA_REQUESTORS_TX_0_UI_I_SHIFT                       _MK_SHIFT_CONST(4)
#define APBDMA_REQUESTORS_TX_0_UI_I_FIELD                       (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_UI_I_SHIFT)
#define APBDMA_REQUESTORS_TX_0_UI_I_RANGE                       4:4
#define APBDMA_REQUESTORS_TX_0_UI_I_WOFFSET                     0x0
#define APBDMA_REQUESTORS_TX_0_UI_I_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_UI_I_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_UI_I_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_UI_I_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_UI_I_NOT_ACTIVE                  _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_UI_I_ACTIVE                      _MK_ENUM_CONST(1)

// SPDIF Output FIFO (Rx) (Peripheral initiated DMA request) 1 = Activate DMA transfer 0 = NOP
#define APBDMA_REQUESTORS_TX_0_SPD_I_SHIFT                      _MK_SHIFT_CONST(3)
#define APBDMA_REQUESTORS_TX_0_SPD_I_FIELD                      (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_SPD_I_SHIFT)
#define APBDMA_REQUESTORS_TX_0_SPD_I_RANGE                      3:3
#define APBDMA_REQUESTORS_TX_0_SPD_I_WOFFSET                    0x0
#define APBDMA_REQUESTORS_TX_0_SPD_I_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SPD_I_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_SPD_I_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SPD_I_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_SPD_I_NOT_ACTIVE                 _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_SPD_I_ACTIVE                     _MK_ENUM_CONST(1)

// I2S Tx Output FIFO1 (Record) (Peripheral initiated DMA request) 1 = Activate DMA transfer0 = NOP
#define APBDMA_REQUESTORS_TX_0_I2S_1_SHIFT                      _MK_SHIFT_CONST(2)
#define APBDMA_REQUESTORS_TX_0_I2S_1_FIELD                      (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_I2S_1_SHIFT)
#define APBDMA_REQUESTORS_TX_0_I2S_1_RANGE                      2:2
#define APBDMA_REQUESTORS_TX_0_I2S_1_WOFFSET                    0x0
#define APBDMA_REQUESTORS_TX_0_I2S_1_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_I2S_1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_I2S_1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_I2S_1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_I2S_1_NOT_ACTIVE                 _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_I2S_1_ACTIVE                     _MK_ENUM_CONST(1)

// I2S Tx Output FIFO2 (Play) (Peripheral initiated DMA request) 1 = Activate DMA transfer0 = NOP
#define APBDMA_REQUESTORS_TX_0_I2S_2_SHIFT                      _MK_SHIFT_CONST(1)
#define APBDMA_REQUESTORS_TX_0_I2S_2_FIELD                      (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_I2S_2_SHIFT)
#define APBDMA_REQUESTORS_TX_0_I2S_2_RANGE                      1:1
#define APBDMA_REQUESTORS_TX_0_I2S_2_WOFFSET                    0x0
#define APBDMA_REQUESTORS_TX_0_I2S_2_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_I2S_2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_I2S_2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_I2S_2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_I2S_2_NOT_ACTIVE                 _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_I2S_2_ACTIVE                     _MK_ENUM_CONST(1)

// Enables counter request.
#define APBDMA_REQUESTORS_TX_0_CNTR_REQ_SHIFT                   _MK_SHIFT_CONST(0)
#define APBDMA_REQUESTORS_TX_0_CNTR_REQ_FIELD                   (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_TX_0_CNTR_REQ_SHIFT)
#define APBDMA_REQUESTORS_TX_0_CNTR_REQ_RANGE                   0:0
#define APBDMA_REQUESTORS_TX_0_CNTR_REQ_WOFFSET                 0x0
#define APBDMA_REQUESTORS_TX_0_CNTR_REQ_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_CNTR_REQ_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_TX_0_CNTR_REQ_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_CNTR_REQ_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_TX_0_CNTR_REQ_NOT_ACTIVE                      _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_TX_0_CNTR_REQ_ACTIVE                  _MK_ENUM_CONST(1)


// Register APBDMA_REQUESTORS_RX_0  
#define APBDMA_REQUESTORS_RX_0                  _MK_ADDR_CONST(0xc)
#define APBDMA_REQUESTORS_RX_0_WORD_COUNT                       0x1
#define APBDMA_REQUESTORS_RX_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_RESET_MASK                       _MK_MASK_CONST(0x3ffff)
#define APBDMA_REQUESTORS_RX_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_READ_MASK                        _MK_MASK_CONST(0x3ffff)
#define APBDMA_REQUESTORS_RX_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
// SLINK 2B-3
#define APBDMA_REQUESTORS_RX_0_SL2B3_SHIFT                      _MK_SHIFT_CONST(17)
#define APBDMA_REQUESTORS_RX_0_SL2B3_FIELD                      (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_SL2B3_SHIFT)
#define APBDMA_REQUESTORS_RX_0_SL2B3_RANGE                      17:17
#define APBDMA_REQUESTORS_RX_0_SL2B3_WOFFSET                    0x0
#define APBDMA_REQUESTORS_RX_0_SL2B3_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SL2B3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_SL2B3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SL2B3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SL2B3_NOT_ACTIVE                 _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_SL2B3_ACTIVE                     _MK_ENUM_CONST(1)

// SLINK 2B-2
#define APBDMA_REQUESTORS_RX_0_SL2B2_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDMA_REQUESTORS_RX_0_SL2B2_FIELD                      (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_SL2B2_SHIFT)
#define APBDMA_REQUESTORS_RX_0_SL2B2_RANGE                      16:16
#define APBDMA_REQUESTORS_RX_0_SL2B2_WOFFSET                    0x0
#define APBDMA_REQUESTORS_RX_0_SL2B2_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SL2B2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_SL2B2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SL2B2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SL2B2_NOT_ACTIVE                 _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_SL2B2_ACTIVE                     _MK_ENUM_CONST(1)

// SLINK 2B-1
#define APBDMA_REQUESTORS_RX_0_SL2B1_SHIFT                      _MK_SHIFT_CONST(15)
#define APBDMA_REQUESTORS_RX_0_SL2B1_FIELD                      (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_SL2B1_SHIFT)
#define APBDMA_REQUESTORS_RX_0_SL2B1_RANGE                      15:15
#define APBDMA_REQUESTORS_RX_0_SL2B1_WOFFSET                    0x0
#define APBDMA_REQUESTORS_RX_0_SL2B1_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SL2B1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_SL2B1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SL2B1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SL2B1_NOT_ACTIVE                 _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_SL2B1_ACTIVE                     _MK_ENUM_CONST(1)

// SLINK 4B
#define APBDMA_REQUESTORS_RX_0_SL4B_SHIFT                       _MK_SHIFT_CONST(14)
#define APBDMA_REQUESTORS_RX_0_SL4B_FIELD                       (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_SL4B_SHIFT)
#define APBDMA_REQUESTORS_RX_0_SL4B_RANGE                       14:14
#define APBDMA_REQUESTORS_RX_0_SL4B_WOFFSET                     0x0
#define APBDMA_REQUESTORS_RX_0_SL4B_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SL4B_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_SL4B_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SL4B_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SL4B_NOT_ACTIVE                  _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_SL4B_ACTIVE                      _MK_ENUM_CONST(1)

// ACModem
#define APBDMA_REQUESTORS_RX_0_ACModem_SHIFT                    _MK_SHIFT_CONST(13)
#define APBDMA_REQUESTORS_RX_0_ACModem_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_ACModem_SHIFT)
#define APBDMA_REQUESTORS_RX_0_ACModem_RANGE                    13:13
#define APBDMA_REQUESTORS_RX_0_ACModem_WOFFSET                  0x0
#define APBDMA_REQUESTORS_RX_0_ACModem_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_ACModem_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_ACModem_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_ACModem_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_ACModem_NOT_ACTIVE                       _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_ACModem_ACTIVE                   _MK_ENUM_CONST(1)

// AC97
#define APBDMA_REQUESTORS_RX_0_AC97_SHIFT                       _MK_SHIFT_CONST(12)
#define APBDMA_REQUESTORS_RX_0_AC97_FIELD                       (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_AC97_SHIFT)
#define APBDMA_REQUESTORS_RX_0_AC97_RANGE                       12:12
#define APBDMA_REQUESTORS_RX_0_AC97_WOFFSET                     0x0
#define APBDMA_REQUESTORS_RX_0_AC97_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_AC97_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_AC97_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_AC97_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_AC97_NOT_ACTIVE                  _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_AC97_ACTIVE                      _MK_ENUM_CONST(1)

// SPI Controller
#define APBDMA_REQUESTORS_RX_0_SPI_SHIFT                        _MK_SHIFT_CONST(11)
#define APBDMA_REQUESTORS_RX_0_SPI_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_SPI_SHIFT)
#define APBDMA_REQUESTORS_RX_0_SPI_RANGE                        11:11
#define APBDMA_REQUESTORS_RX_0_SPI_WOFFSET                      0x0
#define APBDMA_REQUESTORS_RX_0_SPI_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SPI_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_SPI_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SPI_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SPI_NOT_ACTIVE                   _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_SPI_ACTIVE                       _MK_ENUM_CONST(1)

// UART C
#define APBDMA_REQUESTORS_RX_0_UART_C_SHIFT                     _MK_SHIFT_CONST(10)
#define APBDMA_REQUESTORS_RX_0_UART_C_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_UART_C_SHIFT)
#define APBDMA_REQUESTORS_RX_0_UART_C_RANGE                     10:10
#define APBDMA_REQUESTORS_RX_0_UART_C_WOFFSET                   0x0
#define APBDMA_REQUESTORS_RX_0_UART_C_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_UART_C_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_UART_C_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_UART_C_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_UART_C_NOT_ACTIVE                        _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_UART_C_ACTIVE                    _MK_ENUM_CONST(1)

// UART B (VFIR)
#define APBDMA_REQUESTORS_RX_0_UART_B_SHIFT                     _MK_SHIFT_CONST(9)
#define APBDMA_REQUESTORS_RX_0_UART_B_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_UART_B_SHIFT)
#define APBDMA_REQUESTORS_RX_0_UART_B_RANGE                     9:9
#define APBDMA_REQUESTORS_RX_0_UART_B_WOFFSET                   0x0
#define APBDMA_REQUESTORS_RX_0_UART_B_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_UART_B_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_UART_B_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_UART_B_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_UART_B_NOT_ACTIVE                        _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_UART_B_ACTIVE                    _MK_ENUM_CONST(1)

// UART A
#define APBDMA_REQUESTORS_RX_0_UART_A_SHIFT                     _MK_SHIFT_CONST(8)
#define APBDMA_REQUESTORS_RX_0_UART_A_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_UART_A_SHIFT)
#define APBDMA_REQUESTORS_RX_0_UART_A_RANGE                     8:8
#define APBDMA_REQUESTORS_RX_0_UART_A_WOFFSET                   0x0
#define APBDMA_REQUESTORS_RX_0_UART_A_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_UART_A_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_UART_A_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_UART_A_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_UART_A_NOT_ACTIVE                        _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_UART_A_ACTIVE                    _MK_ENUM_CONST(1)

// I2S2 Rx Input FIFO2 (Peripheral initiated DMA request) 1 = Activate DMA transfer 0 = NOP
#define APBDMA_REQUESTORS_RX_0_I2S2_2_SHIFT                     _MK_SHIFT_CONST(7)
#define APBDMA_REQUESTORS_RX_0_I2S2_2_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_I2S2_2_SHIFT)
#define APBDMA_REQUESTORS_RX_0_I2S2_2_RANGE                     7:7
#define APBDMA_REQUESTORS_RX_0_I2S2_2_WOFFSET                   0x0
#define APBDMA_REQUESTORS_RX_0_I2S2_2_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_I2S2_2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_I2S2_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_I2S2_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_I2S2_2_NOT_ACTIVE                        _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_I2S2_2_ACTIVE                    _MK_ENUM_CONST(1)

// I2S2 Rx Input FIFO1 (Peripheral initiated DMA request) 1 = Activate DMA transfer 0 = NOP
#define APBDMA_REQUESTORS_RX_0_I2S2_1_SHIFT                     _MK_SHIFT_CONST(6)
#define APBDMA_REQUESTORS_RX_0_I2S2_1_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_I2S2_1_SHIFT)
#define APBDMA_REQUESTORS_RX_0_I2S2_1_RANGE                     6:6
#define APBDMA_REQUESTORS_RX_0_I2S2_1_WOFFSET                   0x0
#define APBDMA_REQUESTORS_RX_0_I2S2_1_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_I2S2_1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_I2S2_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_I2S2_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_I2S2_1_NOT_ACTIVE                        _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_I2S2_1_ACTIVE                    _MK_ENUM_CONST(1)

// MIPI Rx Input FIFO.
#define APBDMA_REQUESTORS_RX_0_MIPI_SHIFT                       _MK_SHIFT_CONST(5)
#define APBDMA_REQUESTORS_RX_0_MIPI_FIELD                       (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_MIPI_SHIFT)
#define APBDMA_REQUESTORS_RX_0_MIPI_RANGE                       5:5
#define APBDMA_REQUESTORS_RX_0_MIPI_WOFFSET                     0x0
#define APBDMA_REQUESTORS_RX_0_MIPI_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_MIPI_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_MIPI_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_MIPI_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// EBU+SPDIF USR Input (Peripheral initiated DMA request) 1 = Activate DMA transfer 0 = NOP
#define APBDMA_REQUESTORS_RX_0_UI_I_SHIFT                       _MK_SHIFT_CONST(4)
#define APBDMA_REQUESTORS_RX_0_UI_I_FIELD                       (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_UI_I_SHIFT)
#define APBDMA_REQUESTORS_RX_0_UI_I_RANGE                       4:4
#define APBDMA_REQUESTORS_RX_0_UI_I_WOFFSET                     0x0
#define APBDMA_REQUESTORS_RX_0_UI_I_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_UI_I_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_UI_I_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_UI_I_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_UI_I_NOT_ACTIVE                  _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_UI_I_ACTIVE                      _MK_ENUM_CONST(1)

// SPDIF Input FIFO (Rx) (Peripheral initiated DMA request) 1 = Activate DMA transfer 0 = NOP
#define APBDMA_REQUESTORS_RX_0_SPD_I_SHIFT                      _MK_SHIFT_CONST(3)
#define APBDMA_REQUESTORS_RX_0_SPD_I_FIELD                      (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_SPD_I_SHIFT)
#define APBDMA_REQUESTORS_RX_0_SPD_I_RANGE                      3:3
#define APBDMA_REQUESTORS_RX_0_SPD_I_WOFFSET                    0x0
#define APBDMA_REQUESTORS_RX_0_SPD_I_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SPD_I_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_SPD_I_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SPD_I_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_SPD_I_NOT_ACTIVE                 _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_SPD_I_ACTIVE                     _MK_ENUM_CONST(1)

//  I2S Rx Input FIFO2 (Peripheral initiated DMA request) 1 = Activate DMA transfer0 = NOP
#define APBDMA_REQUESTORS_RX_0_I2S_2_SHIFT                      _MK_SHIFT_CONST(2)
#define APBDMA_REQUESTORS_RX_0_I2S_2_FIELD                      (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_I2S_2_SHIFT)
#define APBDMA_REQUESTORS_RX_0_I2S_2_RANGE                      2:2
#define APBDMA_REQUESTORS_RX_0_I2S_2_WOFFSET                    0x0
#define APBDMA_REQUESTORS_RX_0_I2S_2_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_I2S_2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_I2S_2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_I2S_2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_I2S_2_NOT_ACTIVE                 _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_I2S_2_ACTIVE                     _MK_ENUM_CONST(1)

//  I2S Rx Input FIFO1 (Peripheral initiated DMA request) 1 = Activate DMA transfer0 = NOP
#define APBDMA_REQUESTORS_RX_0_I2S_1_SHIFT                      _MK_SHIFT_CONST(1)
#define APBDMA_REQUESTORS_RX_0_I2S_1_FIELD                      (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_I2S_1_SHIFT)
#define APBDMA_REQUESTORS_RX_0_I2S_1_RANGE                      1:1
#define APBDMA_REQUESTORS_RX_0_I2S_1_WOFFSET                    0x0
#define APBDMA_REQUESTORS_RX_0_I2S_1_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_I2S_1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_I2S_1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_I2S_1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_I2S_1_NOT_ACTIVE                 _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_I2S_1_ACTIVE                     _MK_ENUM_CONST(1)

//  indicates Enabled counter request or not 
#define APBDMA_REQUESTORS_RX_0_CNTR_REQ_SHIFT                   _MK_SHIFT_CONST(0)
#define APBDMA_REQUESTORS_RX_0_CNTR_REQ_FIELD                   (_MK_MASK_CONST(0x1) << APBDMA_REQUESTORS_RX_0_CNTR_REQ_SHIFT)
#define APBDMA_REQUESTORS_RX_0_CNTR_REQ_RANGE                   0:0
#define APBDMA_REQUESTORS_RX_0_CNTR_REQ_WOFFSET                 0x0
#define APBDMA_REQUESTORS_RX_0_CNTR_REQ_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_CNTR_REQ_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMA_REQUESTORS_RX_0_CNTR_REQ_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_CNTR_REQ_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMA_REQUESTORS_RX_0_CNTR_REQ_NOT_ACTIVE                      _MK_ENUM_CONST(0)
#define APBDMA_REQUESTORS_RX_0_CNTR_REQ_ACTIVE                  _MK_ENUM_CONST(1)


// Register APBDMA_CNTRL_REG_0  
#define APBDMA_CNTRL_REG_0                      _MK_ADDR_CONST(0x10)
#define APBDMA_CNTRL_REG_0_WORD_COUNT                   0x1
#define APBDMA_CNTRL_REG_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define APBDMA_CNTRL_REG_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define APBDMA_CNTRL_REG_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
// Enable the channel15 count
#define APBDMA_CNTRL_REG_0_CH15_CNT_EN_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDMA_CNTRL_REG_0_CH15_CNT_EN_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_CNTRL_REG_0_CH15_CNT_EN_SHIFT)
#define APBDMA_CNTRL_REG_0_CH15_CNT_EN_RANGE                    31:31
#define APBDMA_CNTRL_REG_0_CH15_CNT_EN_WOFFSET                  0x0
#define APBDMA_CNTRL_REG_0_CH15_CNT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH15_CNT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_CNTRL_REG_0_CH15_CNT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH15_CNT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH15_CNT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMA_CNTRL_REG_0_CH15_CNT_EN_ENABLE                   _MK_ENUM_CONST(1)

// Enable the channel14 count
#define APBDMA_CNTRL_REG_0_CH14_CNT_EN_SHIFT                    _MK_SHIFT_CONST(30)
#define APBDMA_CNTRL_REG_0_CH14_CNT_EN_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_CNTRL_REG_0_CH14_CNT_EN_SHIFT)
#define APBDMA_CNTRL_REG_0_CH14_CNT_EN_RANGE                    30:30
#define APBDMA_CNTRL_REG_0_CH14_CNT_EN_WOFFSET                  0x0
#define APBDMA_CNTRL_REG_0_CH14_CNT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH14_CNT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_CNTRL_REG_0_CH14_CNT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH14_CNT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH14_CNT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMA_CNTRL_REG_0_CH14_CNT_EN_ENABLE                   _MK_ENUM_CONST(1)

// Enable the channel13 count
#define APBDMA_CNTRL_REG_0_CH13_CNT_EN_SHIFT                    _MK_SHIFT_CONST(29)
#define APBDMA_CNTRL_REG_0_CH13_CNT_EN_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_CNTRL_REG_0_CH13_CNT_EN_SHIFT)
#define APBDMA_CNTRL_REG_0_CH13_CNT_EN_RANGE                    29:29
#define APBDMA_CNTRL_REG_0_CH13_CNT_EN_WOFFSET                  0x0
#define APBDMA_CNTRL_REG_0_CH13_CNT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH13_CNT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_CNTRL_REG_0_CH13_CNT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH13_CNT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH13_CNT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMA_CNTRL_REG_0_CH13_CNT_EN_ENABLE                   _MK_ENUM_CONST(1)

// Enable the channel12 count
#define APBDMA_CNTRL_REG_0_CH12_CNT_EN_SHIFT                    _MK_SHIFT_CONST(28)
#define APBDMA_CNTRL_REG_0_CH12_CNT_EN_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_CNTRL_REG_0_CH12_CNT_EN_SHIFT)
#define APBDMA_CNTRL_REG_0_CH12_CNT_EN_RANGE                    28:28
#define APBDMA_CNTRL_REG_0_CH12_CNT_EN_WOFFSET                  0x0
#define APBDMA_CNTRL_REG_0_CH12_CNT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH12_CNT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_CNTRL_REG_0_CH12_CNT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH12_CNT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH12_CNT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMA_CNTRL_REG_0_CH12_CNT_EN_ENABLE                   _MK_ENUM_CONST(1)

// Enable the channel11 count
#define APBDMA_CNTRL_REG_0_CH11_CNT_EN_SHIFT                    _MK_SHIFT_CONST(27)
#define APBDMA_CNTRL_REG_0_CH11_CNT_EN_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_CNTRL_REG_0_CH11_CNT_EN_SHIFT)
#define APBDMA_CNTRL_REG_0_CH11_CNT_EN_RANGE                    27:27
#define APBDMA_CNTRL_REG_0_CH11_CNT_EN_WOFFSET                  0x0
#define APBDMA_CNTRL_REG_0_CH11_CNT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH11_CNT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_CNTRL_REG_0_CH11_CNT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH11_CNT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH11_CNT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMA_CNTRL_REG_0_CH11_CNT_EN_ENABLE                   _MK_ENUM_CONST(1)

// Enable the channel10 count
#define APBDMA_CNTRL_REG_0_CH10_CNT_EN_SHIFT                    _MK_SHIFT_CONST(26)
#define APBDMA_CNTRL_REG_0_CH10_CNT_EN_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_CNTRL_REG_0_CH10_CNT_EN_SHIFT)
#define APBDMA_CNTRL_REG_0_CH10_CNT_EN_RANGE                    26:26
#define APBDMA_CNTRL_REG_0_CH10_CNT_EN_WOFFSET                  0x0
#define APBDMA_CNTRL_REG_0_CH10_CNT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH10_CNT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_CNTRL_REG_0_CH10_CNT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH10_CNT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH10_CNT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMA_CNTRL_REG_0_CH10_CNT_EN_ENABLE                   _MK_ENUM_CONST(1)

// Enable the channel9 count
#define APBDMA_CNTRL_REG_0_CH9_CNT_EN_SHIFT                     _MK_SHIFT_CONST(25)
#define APBDMA_CNTRL_REG_0_CH9_CNT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_CNTRL_REG_0_CH9_CNT_EN_SHIFT)
#define APBDMA_CNTRL_REG_0_CH9_CNT_EN_RANGE                     25:25
#define APBDMA_CNTRL_REG_0_CH9_CNT_EN_WOFFSET                   0x0
#define APBDMA_CNTRL_REG_0_CH9_CNT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH9_CNT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_CNTRL_REG_0_CH9_CNT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH9_CNT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH9_CNT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_CNTRL_REG_0_CH9_CNT_EN_ENABLE                    _MK_ENUM_CONST(1)

// Enable the channel8 count
#define APBDMA_CNTRL_REG_0_CH8_CNT_EN_SHIFT                     _MK_SHIFT_CONST(24)
#define APBDMA_CNTRL_REG_0_CH8_CNT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_CNTRL_REG_0_CH8_CNT_EN_SHIFT)
#define APBDMA_CNTRL_REG_0_CH8_CNT_EN_RANGE                     24:24
#define APBDMA_CNTRL_REG_0_CH8_CNT_EN_WOFFSET                   0x0
#define APBDMA_CNTRL_REG_0_CH8_CNT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH8_CNT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_CNTRL_REG_0_CH8_CNT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH8_CNT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH8_CNT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_CNTRL_REG_0_CH8_CNT_EN_ENABLE                    _MK_ENUM_CONST(1)

// Enable the channel7 count
#define APBDMA_CNTRL_REG_0_CH7_CNT_EN_SHIFT                     _MK_SHIFT_CONST(23)
#define APBDMA_CNTRL_REG_0_CH7_CNT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_CNTRL_REG_0_CH7_CNT_EN_SHIFT)
#define APBDMA_CNTRL_REG_0_CH7_CNT_EN_RANGE                     23:23
#define APBDMA_CNTRL_REG_0_CH7_CNT_EN_WOFFSET                   0x0
#define APBDMA_CNTRL_REG_0_CH7_CNT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH7_CNT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_CNTRL_REG_0_CH7_CNT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH7_CNT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH7_CNT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_CNTRL_REG_0_CH7_CNT_EN_ENABLE                    _MK_ENUM_CONST(1)

// Enable the channel6 count
#define APBDMA_CNTRL_REG_0_CH6_CNT_EN_SHIFT                     _MK_SHIFT_CONST(22)
#define APBDMA_CNTRL_REG_0_CH6_CNT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_CNTRL_REG_0_CH6_CNT_EN_SHIFT)
#define APBDMA_CNTRL_REG_0_CH6_CNT_EN_RANGE                     22:22
#define APBDMA_CNTRL_REG_0_CH6_CNT_EN_WOFFSET                   0x0
#define APBDMA_CNTRL_REG_0_CH6_CNT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH6_CNT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_CNTRL_REG_0_CH6_CNT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH6_CNT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH6_CNT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_CNTRL_REG_0_CH6_CNT_EN_ENABLE                    _MK_ENUM_CONST(1)

// Enable the channel5 count
#define APBDMA_CNTRL_REG_0_CH5_CNT_EN_SHIFT                     _MK_SHIFT_CONST(21)
#define APBDMA_CNTRL_REG_0_CH5_CNT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_CNTRL_REG_0_CH5_CNT_EN_SHIFT)
#define APBDMA_CNTRL_REG_0_CH5_CNT_EN_RANGE                     21:21
#define APBDMA_CNTRL_REG_0_CH5_CNT_EN_WOFFSET                   0x0
#define APBDMA_CNTRL_REG_0_CH5_CNT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH5_CNT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_CNTRL_REG_0_CH5_CNT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH5_CNT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH5_CNT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_CNTRL_REG_0_CH5_CNT_EN_ENABLE                    _MK_ENUM_CONST(1)

// Enable the channel4 count
#define APBDMA_CNTRL_REG_0_CH4_CNT_EN_SHIFT                     _MK_SHIFT_CONST(20)
#define APBDMA_CNTRL_REG_0_CH4_CNT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_CNTRL_REG_0_CH4_CNT_EN_SHIFT)
#define APBDMA_CNTRL_REG_0_CH4_CNT_EN_RANGE                     20:20
#define APBDMA_CNTRL_REG_0_CH4_CNT_EN_WOFFSET                   0x0
#define APBDMA_CNTRL_REG_0_CH4_CNT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH4_CNT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_CNTRL_REG_0_CH4_CNT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH4_CNT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH4_CNT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_CNTRL_REG_0_CH4_CNT_EN_ENABLE                    _MK_ENUM_CONST(1)

// Enable the channel3 count
#define APBDMA_CNTRL_REG_0_CH3_CNT_EN_SHIFT                     _MK_SHIFT_CONST(19)
#define APBDMA_CNTRL_REG_0_CH3_CNT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_CNTRL_REG_0_CH3_CNT_EN_SHIFT)
#define APBDMA_CNTRL_REG_0_CH3_CNT_EN_RANGE                     19:19
#define APBDMA_CNTRL_REG_0_CH3_CNT_EN_WOFFSET                   0x0
#define APBDMA_CNTRL_REG_0_CH3_CNT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH3_CNT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_CNTRL_REG_0_CH3_CNT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH3_CNT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH3_CNT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_CNTRL_REG_0_CH3_CNT_EN_ENABLE                    _MK_ENUM_CONST(1)

// Enable the channel2 count
#define APBDMA_CNTRL_REG_0_CH2_CNT_EN_SHIFT                     _MK_SHIFT_CONST(18)
#define APBDMA_CNTRL_REG_0_CH2_CNT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_CNTRL_REG_0_CH2_CNT_EN_SHIFT)
#define APBDMA_CNTRL_REG_0_CH2_CNT_EN_RANGE                     18:18
#define APBDMA_CNTRL_REG_0_CH2_CNT_EN_WOFFSET                   0x0
#define APBDMA_CNTRL_REG_0_CH2_CNT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH2_CNT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_CNTRL_REG_0_CH2_CNT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH2_CNT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH2_CNT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_CNTRL_REG_0_CH2_CNT_EN_ENABLE                    _MK_ENUM_CONST(1)

// Enable the channel1 count
#define APBDMA_CNTRL_REG_0_CH1_CNT_EN_SHIFT                     _MK_SHIFT_CONST(17)
#define APBDMA_CNTRL_REG_0_CH1_CNT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_CNTRL_REG_0_CH1_CNT_EN_SHIFT)
#define APBDMA_CNTRL_REG_0_CH1_CNT_EN_RANGE                     17:17
#define APBDMA_CNTRL_REG_0_CH1_CNT_EN_WOFFSET                   0x0
#define APBDMA_CNTRL_REG_0_CH1_CNT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH1_CNT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_CNTRL_REG_0_CH1_CNT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH1_CNT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH1_CNT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_CNTRL_REG_0_CH1_CNT_EN_ENABLE                    _MK_ENUM_CONST(1)

// Enable the channel0 count
#define APBDMA_CNTRL_REG_0_CH0_CNT_EN_SHIFT                     _MK_SHIFT_CONST(16)
#define APBDMA_CNTRL_REG_0_CH0_CNT_EN_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_CNTRL_REG_0_CH0_CNT_EN_SHIFT)
#define APBDMA_CNTRL_REG_0_CH0_CNT_EN_RANGE                     16:16
#define APBDMA_CNTRL_REG_0_CH0_CNT_EN_WOFFSET                   0x0
#define APBDMA_CNTRL_REG_0_CH0_CNT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH0_CNT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_CNTRL_REG_0_CH0_CNT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH0_CNT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_CH0_CNT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_CNTRL_REG_0_CH0_CNT_EN_ENABLE                    _MK_ENUM_CONST(1)

// DMA COUNT Value.
#define APBDMA_CNTRL_REG_0_COUNT_VALUE_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDMA_CNTRL_REG_0_COUNT_VALUE_FIELD                    (_MK_MASK_CONST(0xffff) << APBDMA_CNTRL_REG_0_COUNT_VALUE_SHIFT)
#define APBDMA_CNTRL_REG_0_COUNT_VALUE_RANGE                    15:0
#define APBDMA_CNTRL_REG_0_COUNT_VALUE_WOFFSET                  0x0
#define APBDMA_CNTRL_REG_0_COUNT_VALUE_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_COUNT_VALUE_DEFAULT_MASK                     _MK_MASK_CONST(0xffff)
#define APBDMA_CNTRL_REG_0_COUNT_VALUE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_CNTRL_REG_0_COUNT_VALUE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDMA_IRQ_STA_CPU_0  
#define APBDMA_IRQ_STA_CPU_0                    _MK_ADDR_CONST(0x14)
#define APBDMA_IRQ_STA_CPU_0_WORD_COUNT                         0x1
#define APBDMA_IRQ_STA_CPU_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_RESET_MASK                         _MK_MASK_CONST(0xffff)
#define APBDMA_IRQ_STA_CPU_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_READ_MASK                  _MK_MASK_CONST(0xffff)
#define APBDMA_IRQ_STA_CPU_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
// Gathers all the after-masking CPU directed IRQ status bits from channel15 
#define APBDMA_IRQ_STA_CPU_0_CH15_SHIFT                 _MK_SHIFT_CONST(15)
#define APBDMA_IRQ_STA_CPU_0_CH15_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_CPU_0_CH15_SHIFT)
#define APBDMA_IRQ_STA_CPU_0_CH15_RANGE                 15:15
#define APBDMA_IRQ_STA_CPU_0_CH15_WOFFSET                       0x0
#define APBDMA_IRQ_STA_CPU_0_CH15_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH15_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_CPU_0_CH15_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH15_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH15_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH15_ENABLE                        _MK_ENUM_CONST(1)

// Gathers all the after-masking CPU directed IRQ status bits from channel14 
#define APBDMA_IRQ_STA_CPU_0_CH14_SHIFT                 _MK_SHIFT_CONST(14)
#define APBDMA_IRQ_STA_CPU_0_CH14_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_CPU_0_CH14_SHIFT)
#define APBDMA_IRQ_STA_CPU_0_CH14_RANGE                 14:14
#define APBDMA_IRQ_STA_CPU_0_CH14_WOFFSET                       0x0
#define APBDMA_IRQ_STA_CPU_0_CH14_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH14_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_CPU_0_CH14_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH14_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH14_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH14_ENABLE                        _MK_ENUM_CONST(1)

// Gathers all the after-masking CPU directed IRQ status bits from channel13 
#define APBDMA_IRQ_STA_CPU_0_CH13_SHIFT                 _MK_SHIFT_CONST(13)
#define APBDMA_IRQ_STA_CPU_0_CH13_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_CPU_0_CH13_SHIFT)
#define APBDMA_IRQ_STA_CPU_0_CH13_RANGE                 13:13
#define APBDMA_IRQ_STA_CPU_0_CH13_WOFFSET                       0x0
#define APBDMA_IRQ_STA_CPU_0_CH13_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH13_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_CPU_0_CH13_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH13_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH13_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH13_ENABLE                        _MK_ENUM_CONST(1)

// Gathers all the after-masking CPU directed IRQ status bits from channel12 
#define APBDMA_IRQ_STA_CPU_0_CH12_SHIFT                 _MK_SHIFT_CONST(12)
#define APBDMA_IRQ_STA_CPU_0_CH12_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_CPU_0_CH12_SHIFT)
#define APBDMA_IRQ_STA_CPU_0_CH12_RANGE                 12:12
#define APBDMA_IRQ_STA_CPU_0_CH12_WOFFSET                       0x0
#define APBDMA_IRQ_STA_CPU_0_CH12_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH12_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_CPU_0_CH12_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH12_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH12_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH12_ENABLE                        _MK_ENUM_CONST(1)

// Gathers all the after-masking CPU directed IRQ status bits from channel11 
#define APBDMA_IRQ_STA_CPU_0_CH11_SHIFT                 _MK_SHIFT_CONST(11)
#define APBDMA_IRQ_STA_CPU_0_CH11_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_CPU_0_CH11_SHIFT)
#define APBDMA_IRQ_STA_CPU_0_CH11_RANGE                 11:11
#define APBDMA_IRQ_STA_CPU_0_CH11_WOFFSET                       0x0
#define APBDMA_IRQ_STA_CPU_0_CH11_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH11_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_CPU_0_CH11_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH11_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH11_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH11_ENABLE                        _MK_ENUM_CONST(1)

// Gathers all the after-masking CPU directed IRQ status bits from channel10 
#define APBDMA_IRQ_STA_CPU_0_CH10_SHIFT                 _MK_SHIFT_CONST(10)
#define APBDMA_IRQ_STA_CPU_0_CH10_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_CPU_0_CH10_SHIFT)
#define APBDMA_IRQ_STA_CPU_0_CH10_RANGE                 10:10
#define APBDMA_IRQ_STA_CPU_0_CH10_WOFFSET                       0x0
#define APBDMA_IRQ_STA_CPU_0_CH10_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH10_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_CPU_0_CH10_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH10_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH10_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH10_ENABLE                        _MK_ENUM_CONST(1)

// Gathers all the after-masking CPU directed IRQ status bits from channel9 
#define APBDMA_IRQ_STA_CPU_0_CH9_SHIFT                  _MK_SHIFT_CONST(9)
#define APBDMA_IRQ_STA_CPU_0_CH9_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_CPU_0_CH9_SHIFT)
#define APBDMA_IRQ_STA_CPU_0_CH9_RANGE                  9:9
#define APBDMA_IRQ_STA_CPU_0_CH9_WOFFSET                        0x0
#define APBDMA_IRQ_STA_CPU_0_CH9_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH9_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_CPU_0_CH9_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH9_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH9_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH9_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking CPU directed IRQ status bits from channel8 
#define APBDMA_IRQ_STA_CPU_0_CH8_SHIFT                  _MK_SHIFT_CONST(8)
#define APBDMA_IRQ_STA_CPU_0_CH8_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_CPU_0_CH8_SHIFT)
#define APBDMA_IRQ_STA_CPU_0_CH8_RANGE                  8:8
#define APBDMA_IRQ_STA_CPU_0_CH8_WOFFSET                        0x0
#define APBDMA_IRQ_STA_CPU_0_CH8_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH8_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_CPU_0_CH8_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH8_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH8_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH8_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking CPU directed IRQ status bits from channel7 
#define APBDMA_IRQ_STA_CPU_0_CH7_SHIFT                  _MK_SHIFT_CONST(7)
#define APBDMA_IRQ_STA_CPU_0_CH7_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_CPU_0_CH7_SHIFT)
#define APBDMA_IRQ_STA_CPU_0_CH7_RANGE                  7:7
#define APBDMA_IRQ_STA_CPU_0_CH7_WOFFSET                        0x0
#define APBDMA_IRQ_STA_CPU_0_CH7_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH7_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_CPU_0_CH7_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH7_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH7_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH7_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking CPU directed IRQ status bits from channel6 
#define APBDMA_IRQ_STA_CPU_0_CH6_SHIFT                  _MK_SHIFT_CONST(6)
#define APBDMA_IRQ_STA_CPU_0_CH6_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_CPU_0_CH6_SHIFT)
#define APBDMA_IRQ_STA_CPU_0_CH6_RANGE                  6:6
#define APBDMA_IRQ_STA_CPU_0_CH6_WOFFSET                        0x0
#define APBDMA_IRQ_STA_CPU_0_CH6_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH6_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_CPU_0_CH6_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH6_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH6_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH6_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking CPU directed IRQ status bits from channel5 
#define APBDMA_IRQ_STA_CPU_0_CH5_SHIFT                  _MK_SHIFT_CONST(5)
#define APBDMA_IRQ_STA_CPU_0_CH5_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_CPU_0_CH5_SHIFT)
#define APBDMA_IRQ_STA_CPU_0_CH5_RANGE                  5:5
#define APBDMA_IRQ_STA_CPU_0_CH5_WOFFSET                        0x0
#define APBDMA_IRQ_STA_CPU_0_CH5_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH5_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_CPU_0_CH5_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH5_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH5_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH5_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking CPU directed IRQ status bits from channel4 
#define APBDMA_IRQ_STA_CPU_0_CH4_SHIFT                  _MK_SHIFT_CONST(4)
#define APBDMA_IRQ_STA_CPU_0_CH4_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_CPU_0_CH4_SHIFT)
#define APBDMA_IRQ_STA_CPU_0_CH4_RANGE                  4:4
#define APBDMA_IRQ_STA_CPU_0_CH4_WOFFSET                        0x0
#define APBDMA_IRQ_STA_CPU_0_CH4_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH4_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_CPU_0_CH4_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH4_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH4_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH4_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking CPU directed IRQ status bits from channel3 
#define APBDMA_IRQ_STA_CPU_0_CH3_SHIFT                  _MK_SHIFT_CONST(3)
#define APBDMA_IRQ_STA_CPU_0_CH3_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_CPU_0_CH3_SHIFT)
#define APBDMA_IRQ_STA_CPU_0_CH3_RANGE                  3:3
#define APBDMA_IRQ_STA_CPU_0_CH3_WOFFSET                        0x0
#define APBDMA_IRQ_STA_CPU_0_CH3_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH3_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_CPU_0_CH3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH3_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH3_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking CPU directed IRQ status bits from channel2 
#define APBDMA_IRQ_STA_CPU_0_CH2_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMA_IRQ_STA_CPU_0_CH2_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_CPU_0_CH2_SHIFT)
#define APBDMA_IRQ_STA_CPU_0_CH2_RANGE                  2:2
#define APBDMA_IRQ_STA_CPU_0_CH2_WOFFSET                        0x0
#define APBDMA_IRQ_STA_CPU_0_CH2_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH2_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_CPU_0_CH2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH2_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH2_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking CPU directed IRQ status bits from channel1 
#define APBDMA_IRQ_STA_CPU_0_CH1_SHIFT                  _MK_SHIFT_CONST(1)
#define APBDMA_IRQ_STA_CPU_0_CH1_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_CPU_0_CH1_SHIFT)
#define APBDMA_IRQ_STA_CPU_0_CH1_RANGE                  1:1
#define APBDMA_IRQ_STA_CPU_0_CH1_WOFFSET                        0x0
#define APBDMA_IRQ_STA_CPU_0_CH1_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH1_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_CPU_0_CH1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH1_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH1_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking CPU directed IRQ status bits from channel0 
#define APBDMA_IRQ_STA_CPU_0_CH0_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH0_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_CPU_0_CH0_SHIFT)
#define APBDMA_IRQ_STA_CPU_0_CH0_RANGE                  0:0
#define APBDMA_IRQ_STA_CPU_0_CH0_WOFFSET                        0x0
#define APBDMA_IRQ_STA_CPU_0_CH0_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_CPU_0_CH0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_CPU_0_CH0_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_CPU_0_CH0_ENABLE                 _MK_ENUM_CONST(1)


// Register APBDMA_IRQ_STA_COP_0  
#define APBDMA_IRQ_STA_COP_0                    _MK_ADDR_CONST(0x18)
#define APBDMA_IRQ_STA_COP_0_WORD_COUNT                         0x1
#define APBDMA_IRQ_STA_COP_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_RESET_MASK                         _MK_MASK_CONST(0xffff)
#define APBDMA_IRQ_STA_COP_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_READ_MASK                  _MK_MASK_CONST(0xffff)
#define APBDMA_IRQ_STA_COP_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
// Gathers all the after-masking COP directed IRQ status bits from channel15 
#define APBDMA_IRQ_STA_COP_0_CH15_SHIFT                 _MK_SHIFT_CONST(15)
#define APBDMA_IRQ_STA_COP_0_CH15_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_COP_0_CH15_SHIFT)
#define APBDMA_IRQ_STA_COP_0_CH15_RANGE                 15:15
#define APBDMA_IRQ_STA_COP_0_CH15_WOFFSET                       0x0
#define APBDMA_IRQ_STA_COP_0_CH15_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH15_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_COP_0_CH15_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH15_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH15_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH15_ENABLE                        _MK_ENUM_CONST(1)

// Gathers all the after-masking COP directed IRQ status bits from channel14 
#define APBDMA_IRQ_STA_COP_0_CH14_SHIFT                 _MK_SHIFT_CONST(14)
#define APBDMA_IRQ_STA_COP_0_CH14_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_COP_0_CH14_SHIFT)
#define APBDMA_IRQ_STA_COP_0_CH14_RANGE                 14:14
#define APBDMA_IRQ_STA_COP_0_CH14_WOFFSET                       0x0
#define APBDMA_IRQ_STA_COP_0_CH14_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH14_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_COP_0_CH14_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH14_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH14_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH14_ENABLE                        _MK_ENUM_CONST(1)

// Gathers all the after-masking COP directed IRQ status bits from channel13 
#define APBDMA_IRQ_STA_COP_0_CH13_SHIFT                 _MK_SHIFT_CONST(13)
#define APBDMA_IRQ_STA_COP_0_CH13_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_COP_0_CH13_SHIFT)
#define APBDMA_IRQ_STA_COP_0_CH13_RANGE                 13:13
#define APBDMA_IRQ_STA_COP_0_CH13_WOFFSET                       0x0
#define APBDMA_IRQ_STA_COP_0_CH13_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH13_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_COP_0_CH13_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH13_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH13_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH13_ENABLE                        _MK_ENUM_CONST(1)

// Gathers all the after-masking COP directed IRQ status bits from channel12 
#define APBDMA_IRQ_STA_COP_0_CH12_SHIFT                 _MK_SHIFT_CONST(12)
#define APBDMA_IRQ_STA_COP_0_CH12_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_COP_0_CH12_SHIFT)
#define APBDMA_IRQ_STA_COP_0_CH12_RANGE                 12:12
#define APBDMA_IRQ_STA_COP_0_CH12_WOFFSET                       0x0
#define APBDMA_IRQ_STA_COP_0_CH12_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH12_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_COP_0_CH12_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH12_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH12_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH12_ENABLE                        _MK_ENUM_CONST(1)

// Gathers all the after-masking COP directed IRQ status bits from channel11 
#define APBDMA_IRQ_STA_COP_0_CH11_SHIFT                 _MK_SHIFT_CONST(11)
#define APBDMA_IRQ_STA_COP_0_CH11_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_COP_0_CH11_SHIFT)
#define APBDMA_IRQ_STA_COP_0_CH11_RANGE                 11:11
#define APBDMA_IRQ_STA_COP_0_CH11_WOFFSET                       0x0
#define APBDMA_IRQ_STA_COP_0_CH11_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH11_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_COP_0_CH11_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH11_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH11_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH11_ENABLE                        _MK_ENUM_CONST(1)

// Gathers all the after-masking COP directed IRQ status bits from channel10 
#define APBDMA_IRQ_STA_COP_0_CH10_SHIFT                 _MK_SHIFT_CONST(10)
#define APBDMA_IRQ_STA_COP_0_CH10_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_COP_0_CH10_SHIFT)
#define APBDMA_IRQ_STA_COP_0_CH10_RANGE                 10:10
#define APBDMA_IRQ_STA_COP_0_CH10_WOFFSET                       0x0
#define APBDMA_IRQ_STA_COP_0_CH10_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH10_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_COP_0_CH10_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH10_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH10_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH10_ENABLE                        _MK_ENUM_CONST(1)

// Gathers all the after-masking COP directed IRQ status bits from channel9 
#define APBDMA_IRQ_STA_COP_0_CH9_SHIFT                  _MK_SHIFT_CONST(9)
#define APBDMA_IRQ_STA_COP_0_CH9_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_COP_0_CH9_SHIFT)
#define APBDMA_IRQ_STA_COP_0_CH9_RANGE                  9:9
#define APBDMA_IRQ_STA_COP_0_CH9_WOFFSET                        0x0
#define APBDMA_IRQ_STA_COP_0_CH9_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH9_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_COP_0_CH9_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH9_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH9_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH9_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking COP directed IRQ status bits from channel8 
#define APBDMA_IRQ_STA_COP_0_CH8_SHIFT                  _MK_SHIFT_CONST(8)
#define APBDMA_IRQ_STA_COP_0_CH8_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_COP_0_CH8_SHIFT)
#define APBDMA_IRQ_STA_COP_0_CH8_RANGE                  8:8
#define APBDMA_IRQ_STA_COP_0_CH8_WOFFSET                        0x0
#define APBDMA_IRQ_STA_COP_0_CH8_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH8_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_COP_0_CH8_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH8_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH8_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH8_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking COP directed IRQ status bits from channel7 
#define APBDMA_IRQ_STA_COP_0_CH7_SHIFT                  _MK_SHIFT_CONST(7)
#define APBDMA_IRQ_STA_COP_0_CH7_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_COP_0_CH7_SHIFT)
#define APBDMA_IRQ_STA_COP_0_CH7_RANGE                  7:7
#define APBDMA_IRQ_STA_COP_0_CH7_WOFFSET                        0x0
#define APBDMA_IRQ_STA_COP_0_CH7_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH7_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_COP_0_CH7_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH7_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH7_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH7_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking COP directed IRQ status bits from channel6 
#define APBDMA_IRQ_STA_COP_0_CH6_SHIFT                  _MK_SHIFT_CONST(6)
#define APBDMA_IRQ_STA_COP_0_CH6_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_COP_0_CH6_SHIFT)
#define APBDMA_IRQ_STA_COP_0_CH6_RANGE                  6:6
#define APBDMA_IRQ_STA_COP_0_CH6_WOFFSET                        0x0
#define APBDMA_IRQ_STA_COP_0_CH6_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH6_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_COP_0_CH6_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH6_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH6_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH6_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking COP directed IRQ status bits from channel5 
#define APBDMA_IRQ_STA_COP_0_CH5_SHIFT                  _MK_SHIFT_CONST(5)
#define APBDMA_IRQ_STA_COP_0_CH5_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_COP_0_CH5_SHIFT)
#define APBDMA_IRQ_STA_COP_0_CH5_RANGE                  5:5
#define APBDMA_IRQ_STA_COP_0_CH5_WOFFSET                        0x0
#define APBDMA_IRQ_STA_COP_0_CH5_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH5_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_COP_0_CH5_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH5_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH5_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH5_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking COP directed IRQ status bits from channel4 
#define APBDMA_IRQ_STA_COP_0_CH4_SHIFT                  _MK_SHIFT_CONST(4)
#define APBDMA_IRQ_STA_COP_0_CH4_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_COP_0_CH4_SHIFT)
#define APBDMA_IRQ_STA_COP_0_CH4_RANGE                  4:4
#define APBDMA_IRQ_STA_COP_0_CH4_WOFFSET                        0x0
#define APBDMA_IRQ_STA_COP_0_CH4_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH4_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_COP_0_CH4_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH4_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH4_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH4_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking COP directed IRQ status bits from channel3 
#define APBDMA_IRQ_STA_COP_0_CH3_SHIFT                  _MK_SHIFT_CONST(3)
#define APBDMA_IRQ_STA_COP_0_CH3_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_COP_0_CH3_SHIFT)
#define APBDMA_IRQ_STA_COP_0_CH3_RANGE                  3:3
#define APBDMA_IRQ_STA_COP_0_CH3_WOFFSET                        0x0
#define APBDMA_IRQ_STA_COP_0_CH3_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH3_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_COP_0_CH3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH3_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH3_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking COP directed IRQ status bits from channel2 
#define APBDMA_IRQ_STA_COP_0_CH2_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMA_IRQ_STA_COP_0_CH2_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_COP_0_CH2_SHIFT)
#define APBDMA_IRQ_STA_COP_0_CH2_RANGE                  2:2
#define APBDMA_IRQ_STA_COP_0_CH2_WOFFSET                        0x0
#define APBDMA_IRQ_STA_COP_0_CH2_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH2_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_COP_0_CH2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH2_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH2_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking COP directed IRQ status bits from channel1 
#define APBDMA_IRQ_STA_COP_0_CH1_SHIFT                  _MK_SHIFT_CONST(1)
#define APBDMA_IRQ_STA_COP_0_CH1_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_COP_0_CH1_SHIFT)
#define APBDMA_IRQ_STA_COP_0_CH1_RANGE                  1:1
#define APBDMA_IRQ_STA_COP_0_CH1_WOFFSET                        0x0
#define APBDMA_IRQ_STA_COP_0_CH1_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH1_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_COP_0_CH1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH1_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH1_ENABLE                 _MK_ENUM_CONST(1)

// Gathers all the after-masking COP directed IRQ status bits from channel0 
#define APBDMA_IRQ_STA_COP_0_CH0_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH0_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_IRQ_STA_COP_0_CH0_SHIFT)
#define APBDMA_IRQ_STA_COP_0_CH0_RANGE                  0:0
#define APBDMA_IRQ_STA_COP_0_CH0_WOFFSET                        0x0
#define APBDMA_IRQ_STA_COP_0_CH0_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_STA_COP_0_CH0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_STA_COP_0_CH0_DISABLE                        _MK_ENUM_CONST(0)
#define APBDMA_IRQ_STA_COP_0_CH0_ENABLE                 _MK_ENUM_CONST(1)


// Register APBDMA_IRQ_MASK_0  
#define APBDMA_IRQ_MASK_0                       _MK_ADDR_CONST(0x1c)
#define APBDMA_IRQ_MASK_0_WORD_COUNT                    0x1
#define APBDMA_IRQ_MASK_0_RESET_VAL                     _MK_MASK_CONST(0xffff)
#define APBDMA_IRQ_MASK_0_RESET_MASK                    _MK_MASK_CONST(0xffff)
#define APBDMA_IRQ_MASK_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_READ_MASK                     _MK_MASK_CONST(0xffff)
#define APBDMA_IRQ_MASK_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Each bit allows the associated channel15 IRQ to propagate when '1' 
#define APBDMA_IRQ_MASK_0_CH15_SHIFT                    _MK_SHIFT_CONST(15)
#define APBDMA_IRQ_MASK_0_CH15_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_0_CH15_SHIFT)
#define APBDMA_IRQ_MASK_0_CH15_RANGE                    15:15
#define APBDMA_IRQ_MASK_0_CH15_WOFFSET                  0x0
#define APBDMA_IRQ_MASK_0_CH15_DEFAULT                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH15_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH15_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH15_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH15_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_0_CH15_ENABLE                   _MK_ENUM_CONST(1)

// Each bit allows the associated channel14 IRQ to propagate when '1' 
#define APBDMA_IRQ_MASK_0_CH14_SHIFT                    _MK_SHIFT_CONST(14)
#define APBDMA_IRQ_MASK_0_CH14_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_0_CH14_SHIFT)
#define APBDMA_IRQ_MASK_0_CH14_RANGE                    14:14
#define APBDMA_IRQ_MASK_0_CH14_WOFFSET                  0x0
#define APBDMA_IRQ_MASK_0_CH14_DEFAULT                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH14_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH14_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH14_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH14_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_0_CH14_ENABLE                   _MK_ENUM_CONST(1)

// Each bit allows the associated channel13 IRQ to propagate when '1' 
#define APBDMA_IRQ_MASK_0_CH13_SHIFT                    _MK_SHIFT_CONST(13)
#define APBDMA_IRQ_MASK_0_CH13_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_0_CH13_SHIFT)
#define APBDMA_IRQ_MASK_0_CH13_RANGE                    13:13
#define APBDMA_IRQ_MASK_0_CH13_WOFFSET                  0x0
#define APBDMA_IRQ_MASK_0_CH13_DEFAULT                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH13_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH13_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH13_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH13_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_0_CH13_ENABLE                   _MK_ENUM_CONST(1)

// Each bit allows the associated channel12 IRQ to propagate when '1' 
#define APBDMA_IRQ_MASK_0_CH12_SHIFT                    _MK_SHIFT_CONST(12)
#define APBDMA_IRQ_MASK_0_CH12_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_0_CH12_SHIFT)
#define APBDMA_IRQ_MASK_0_CH12_RANGE                    12:12
#define APBDMA_IRQ_MASK_0_CH12_WOFFSET                  0x0
#define APBDMA_IRQ_MASK_0_CH12_DEFAULT                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH12_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH12_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH12_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH12_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_0_CH12_ENABLE                   _MK_ENUM_CONST(1)

// Each bit allows the associated channel11 IRQ to propagate when '1' 
#define APBDMA_IRQ_MASK_0_CH11_SHIFT                    _MK_SHIFT_CONST(11)
#define APBDMA_IRQ_MASK_0_CH11_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_0_CH11_SHIFT)
#define APBDMA_IRQ_MASK_0_CH11_RANGE                    11:11
#define APBDMA_IRQ_MASK_0_CH11_WOFFSET                  0x0
#define APBDMA_IRQ_MASK_0_CH11_DEFAULT                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH11_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH11_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH11_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH11_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_0_CH11_ENABLE                   _MK_ENUM_CONST(1)

// Each bit allows the associated channel10 IRQ to propagate when '1' 
#define APBDMA_IRQ_MASK_0_CH10_SHIFT                    _MK_SHIFT_CONST(10)
#define APBDMA_IRQ_MASK_0_CH10_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_0_CH10_SHIFT)
#define APBDMA_IRQ_MASK_0_CH10_RANGE                    10:10
#define APBDMA_IRQ_MASK_0_CH10_WOFFSET                  0x0
#define APBDMA_IRQ_MASK_0_CH10_DEFAULT                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH10_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH10_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH10_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH10_DISABLE                  _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_0_CH10_ENABLE                   _MK_ENUM_CONST(1)

// Each bit allows the associated channel9 IRQ to propagate when '1' 
#define APBDMA_IRQ_MASK_0_CH9_SHIFT                     _MK_SHIFT_CONST(9)
#define APBDMA_IRQ_MASK_0_CH9_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_0_CH9_SHIFT)
#define APBDMA_IRQ_MASK_0_CH9_RANGE                     9:9
#define APBDMA_IRQ_MASK_0_CH9_WOFFSET                   0x0
#define APBDMA_IRQ_MASK_0_CH9_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH9_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH9_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH9_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH9_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_0_CH9_ENABLE                    _MK_ENUM_CONST(1)

// Each bit allows the associated channel8 IRQ to propagate when '1' 
#define APBDMA_IRQ_MASK_0_CH8_SHIFT                     _MK_SHIFT_CONST(8)
#define APBDMA_IRQ_MASK_0_CH8_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_0_CH8_SHIFT)
#define APBDMA_IRQ_MASK_0_CH8_RANGE                     8:8
#define APBDMA_IRQ_MASK_0_CH8_WOFFSET                   0x0
#define APBDMA_IRQ_MASK_0_CH8_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH8_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH8_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH8_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH8_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_0_CH8_ENABLE                    _MK_ENUM_CONST(1)

// Each bit allows the associated channel7 IRQ to propagate when '1' 
#define APBDMA_IRQ_MASK_0_CH7_SHIFT                     _MK_SHIFT_CONST(7)
#define APBDMA_IRQ_MASK_0_CH7_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_0_CH7_SHIFT)
#define APBDMA_IRQ_MASK_0_CH7_RANGE                     7:7
#define APBDMA_IRQ_MASK_0_CH7_WOFFSET                   0x0
#define APBDMA_IRQ_MASK_0_CH7_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH7_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH7_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH7_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH7_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_0_CH7_ENABLE                    _MK_ENUM_CONST(1)

// Each bit allows the associated channel6 IRQ to propagate when '1' 
#define APBDMA_IRQ_MASK_0_CH6_SHIFT                     _MK_SHIFT_CONST(6)
#define APBDMA_IRQ_MASK_0_CH6_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_0_CH6_SHIFT)
#define APBDMA_IRQ_MASK_0_CH6_RANGE                     6:6
#define APBDMA_IRQ_MASK_0_CH6_WOFFSET                   0x0
#define APBDMA_IRQ_MASK_0_CH6_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH6_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH6_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH6_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH6_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_0_CH6_ENABLE                    _MK_ENUM_CONST(1)

// Each bit allows the associated channel5 IRQ to propagate when '1' 
#define APBDMA_IRQ_MASK_0_CH5_SHIFT                     _MK_SHIFT_CONST(5)
#define APBDMA_IRQ_MASK_0_CH5_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_0_CH5_SHIFT)
#define APBDMA_IRQ_MASK_0_CH5_RANGE                     5:5
#define APBDMA_IRQ_MASK_0_CH5_WOFFSET                   0x0
#define APBDMA_IRQ_MASK_0_CH5_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH5_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH5_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH5_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH5_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_0_CH5_ENABLE                    _MK_ENUM_CONST(1)

// Each bit allows the associated channel4 IRQ to propagate when '1' 
#define APBDMA_IRQ_MASK_0_CH4_SHIFT                     _MK_SHIFT_CONST(4)
#define APBDMA_IRQ_MASK_0_CH4_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_0_CH4_SHIFT)
#define APBDMA_IRQ_MASK_0_CH4_RANGE                     4:4
#define APBDMA_IRQ_MASK_0_CH4_WOFFSET                   0x0
#define APBDMA_IRQ_MASK_0_CH4_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH4_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH4_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH4_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH4_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_0_CH4_ENABLE                    _MK_ENUM_CONST(1)

// Each bit allows the associated channel3 IRQ to propagate when '1' 
#define APBDMA_IRQ_MASK_0_CH3_SHIFT                     _MK_SHIFT_CONST(3)
#define APBDMA_IRQ_MASK_0_CH3_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_0_CH3_SHIFT)
#define APBDMA_IRQ_MASK_0_CH3_RANGE                     3:3
#define APBDMA_IRQ_MASK_0_CH3_WOFFSET                   0x0
#define APBDMA_IRQ_MASK_0_CH3_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH3_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH3_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_0_CH3_ENABLE                    _MK_ENUM_CONST(1)

// Each bit allows the associated channel2 IRQ to propagate when '1' 
#define APBDMA_IRQ_MASK_0_CH2_SHIFT                     _MK_SHIFT_CONST(2)
#define APBDMA_IRQ_MASK_0_CH2_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_0_CH2_SHIFT)
#define APBDMA_IRQ_MASK_0_CH2_RANGE                     2:2
#define APBDMA_IRQ_MASK_0_CH2_WOFFSET                   0x0
#define APBDMA_IRQ_MASK_0_CH2_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH2_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_0_CH2_ENABLE                    _MK_ENUM_CONST(1)

// Each bit allows the associated channel1 IRQ to propagate when '1' 
#define APBDMA_IRQ_MASK_0_CH1_SHIFT                     _MK_SHIFT_CONST(1)
#define APBDMA_IRQ_MASK_0_CH1_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_0_CH1_SHIFT)
#define APBDMA_IRQ_MASK_0_CH1_RANGE                     1:1
#define APBDMA_IRQ_MASK_0_CH1_WOFFSET                   0x0
#define APBDMA_IRQ_MASK_0_CH1_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH1_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_0_CH1_ENABLE                    _MK_ENUM_CONST(1)

// Each bit allows the associated channel0 IRQ to propagate when '1' 
#define APBDMA_IRQ_MASK_0_CH0_SHIFT                     _MK_SHIFT_CONST(0)
#define APBDMA_IRQ_MASK_0_CH0_FIELD                     (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_0_CH0_SHIFT)
#define APBDMA_IRQ_MASK_0_CH0_RANGE                     0:0
#define APBDMA_IRQ_MASK_0_CH0_WOFFSET                   0x0
#define APBDMA_IRQ_MASK_0_CH0_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_0_CH0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_0_CH0_DISABLE                   _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_0_CH0_ENABLE                    _MK_ENUM_CONST(1)


// Register APBDMA_IRQ_MASK_SET_0  
#define APBDMA_IRQ_MASK_SET_0                   _MK_ADDR_CONST(0x20)
#define APBDMA_IRQ_MASK_SET_0_WORD_COUNT                        0x1
#define APBDMA_IRQ_MASK_SET_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_RESET_MASK                        _MK_MASK_CONST(0xffff)
#define APBDMA_IRQ_MASK_SET_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_READ_MASK                         _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_WRITE_MASK                        _MK_MASK_CONST(0xffff)
// Sets the Mask Register
#define APBDMA_IRQ_MASK_SET_0_CH15_SHIFT                        _MK_SHIFT_CONST(15)
#define APBDMA_IRQ_MASK_SET_0_CH15_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_SET_0_CH15_SHIFT)
#define APBDMA_IRQ_MASK_SET_0_CH15_RANGE                        15:15
#define APBDMA_IRQ_MASK_SET_0_CH15_WOFFSET                      0x0
#define APBDMA_IRQ_MASK_SET_0_CH15_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH15_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_SET_0_CH15_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH15_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH15_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH15_ENABLE                       _MK_ENUM_CONST(1)

// Sets the Mask Register
#define APBDMA_IRQ_MASK_SET_0_CH14_SHIFT                        _MK_SHIFT_CONST(14)
#define APBDMA_IRQ_MASK_SET_0_CH14_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_SET_0_CH14_SHIFT)
#define APBDMA_IRQ_MASK_SET_0_CH14_RANGE                        14:14
#define APBDMA_IRQ_MASK_SET_0_CH14_WOFFSET                      0x0
#define APBDMA_IRQ_MASK_SET_0_CH14_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH14_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_SET_0_CH14_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH14_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH14_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH14_ENABLE                       _MK_ENUM_CONST(1)

// Sets the Mask Register
#define APBDMA_IRQ_MASK_SET_0_CH13_SHIFT                        _MK_SHIFT_CONST(13)
#define APBDMA_IRQ_MASK_SET_0_CH13_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_SET_0_CH13_SHIFT)
#define APBDMA_IRQ_MASK_SET_0_CH13_RANGE                        13:13
#define APBDMA_IRQ_MASK_SET_0_CH13_WOFFSET                      0x0
#define APBDMA_IRQ_MASK_SET_0_CH13_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH13_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_SET_0_CH13_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH13_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH13_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH13_ENABLE                       _MK_ENUM_CONST(1)

// Sets the Mask Register
#define APBDMA_IRQ_MASK_SET_0_CH12_SHIFT                        _MK_SHIFT_CONST(12)
#define APBDMA_IRQ_MASK_SET_0_CH12_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_SET_0_CH12_SHIFT)
#define APBDMA_IRQ_MASK_SET_0_CH12_RANGE                        12:12
#define APBDMA_IRQ_MASK_SET_0_CH12_WOFFSET                      0x0
#define APBDMA_IRQ_MASK_SET_0_CH12_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH12_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_SET_0_CH12_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH12_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH12_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH12_ENABLE                       _MK_ENUM_CONST(1)

// Sets the Mask Register
#define APBDMA_IRQ_MASK_SET_0_CH11_SHIFT                        _MK_SHIFT_CONST(11)
#define APBDMA_IRQ_MASK_SET_0_CH11_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_SET_0_CH11_SHIFT)
#define APBDMA_IRQ_MASK_SET_0_CH11_RANGE                        11:11
#define APBDMA_IRQ_MASK_SET_0_CH11_WOFFSET                      0x0
#define APBDMA_IRQ_MASK_SET_0_CH11_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH11_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_SET_0_CH11_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH11_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH11_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH11_ENABLE                       _MK_ENUM_CONST(1)

// Sets the Mask Register
#define APBDMA_IRQ_MASK_SET_0_CH10_SHIFT                        _MK_SHIFT_CONST(10)
#define APBDMA_IRQ_MASK_SET_0_CH10_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_SET_0_CH10_SHIFT)
#define APBDMA_IRQ_MASK_SET_0_CH10_RANGE                        10:10
#define APBDMA_IRQ_MASK_SET_0_CH10_WOFFSET                      0x0
#define APBDMA_IRQ_MASK_SET_0_CH10_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH10_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_SET_0_CH10_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH10_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH10_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH10_ENABLE                       _MK_ENUM_CONST(1)

// Sets the Mask Register
#define APBDMA_IRQ_MASK_SET_0_CH9_SHIFT                 _MK_SHIFT_CONST(9)
#define APBDMA_IRQ_MASK_SET_0_CH9_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_SET_0_CH9_SHIFT)
#define APBDMA_IRQ_MASK_SET_0_CH9_RANGE                 9:9
#define APBDMA_IRQ_MASK_SET_0_CH9_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_SET_0_CH9_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH9_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_SET_0_CH9_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH9_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH9_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH9_ENABLE                        _MK_ENUM_CONST(1)

// Sets the Mask Register
#define APBDMA_IRQ_MASK_SET_0_CH8_SHIFT                 _MK_SHIFT_CONST(8)
#define APBDMA_IRQ_MASK_SET_0_CH8_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_SET_0_CH8_SHIFT)
#define APBDMA_IRQ_MASK_SET_0_CH8_RANGE                 8:8
#define APBDMA_IRQ_MASK_SET_0_CH8_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_SET_0_CH8_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH8_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_SET_0_CH8_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH8_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH8_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH8_ENABLE                        _MK_ENUM_CONST(1)

// Sets the Mask Register
#define APBDMA_IRQ_MASK_SET_0_CH7_SHIFT                 _MK_SHIFT_CONST(7)
#define APBDMA_IRQ_MASK_SET_0_CH7_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_SET_0_CH7_SHIFT)
#define APBDMA_IRQ_MASK_SET_0_CH7_RANGE                 7:7
#define APBDMA_IRQ_MASK_SET_0_CH7_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_SET_0_CH7_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH7_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_SET_0_CH7_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH7_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH7_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH7_ENABLE                        _MK_ENUM_CONST(1)

// Sets the Mask Register
#define APBDMA_IRQ_MASK_SET_0_CH6_SHIFT                 _MK_SHIFT_CONST(6)
#define APBDMA_IRQ_MASK_SET_0_CH6_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_SET_0_CH6_SHIFT)
#define APBDMA_IRQ_MASK_SET_0_CH6_RANGE                 6:6
#define APBDMA_IRQ_MASK_SET_0_CH6_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_SET_0_CH6_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH6_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_SET_0_CH6_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH6_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH6_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH6_ENABLE                        _MK_ENUM_CONST(1)

// Sets the Mask Register
#define APBDMA_IRQ_MASK_SET_0_CH5_SHIFT                 _MK_SHIFT_CONST(5)
#define APBDMA_IRQ_MASK_SET_0_CH5_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_SET_0_CH5_SHIFT)
#define APBDMA_IRQ_MASK_SET_0_CH5_RANGE                 5:5
#define APBDMA_IRQ_MASK_SET_0_CH5_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_SET_0_CH5_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH5_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_SET_0_CH5_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH5_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH5_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH5_ENABLE                        _MK_ENUM_CONST(1)

// Sets the Mask Register
#define APBDMA_IRQ_MASK_SET_0_CH4_SHIFT                 _MK_SHIFT_CONST(4)
#define APBDMA_IRQ_MASK_SET_0_CH4_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_SET_0_CH4_SHIFT)
#define APBDMA_IRQ_MASK_SET_0_CH4_RANGE                 4:4
#define APBDMA_IRQ_MASK_SET_0_CH4_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_SET_0_CH4_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH4_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_SET_0_CH4_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH4_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH4_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH4_ENABLE                        _MK_ENUM_CONST(1)

// Sets the Mask Register
#define APBDMA_IRQ_MASK_SET_0_CH3_SHIFT                 _MK_SHIFT_CONST(3)
#define APBDMA_IRQ_MASK_SET_0_CH3_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_SET_0_CH3_SHIFT)
#define APBDMA_IRQ_MASK_SET_0_CH3_RANGE                 3:3
#define APBDMA_IRQ_MASK_SET_0_CH3_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_SET_0_CH3_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH3_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_SET_0_CH3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH3_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH3_ENABLE                        _MK_ENUM_CONST(1)

// Sets the Mask Register
#define APBDMA_IRQ_MASK_SET_0_CH2_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMA_IRQ_MASK_SET_0_CH2_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_SET_0_CH2_SHIFT)
#define APBDMA_IRQ_MASK_SET_0_CH2_RANGE                 2:2
#define APBDMA_IRQ_MASK_SET_0_CH2_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_SET_0_CH2_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH2_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_SET_0_CH2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH2_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH2_ENABLE                        _MK_ENUM_CONST(1)

// Sets the Mask Register
#define APBDMA_IRQ_MASK_SET_0_CH1_SHIFT                 _MK_SHIFT_CONST(1)
#define APBDMA_IRQ_MASK_SET_0_CH1_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_SET_0_CH1_SHIFT)
#define APBDMA_IRQ_MASK_SET_0_CH1_RANGE                 1:1
#define APBDMA_IRQ_MASK_SET_0_CH1_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_SET_0_CH1_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH1_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_SET_0_CH1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH1_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH1_ENABLE                        _MK_ENUM_CONST(1)

// Sets the Mask Register
#define APBDMA_IRQ_MASK_SET_0_CH0_SHIFT                 _MK_SHIFT_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH0_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_SET_0_CH0_SHIFT)
#define APBDMA_IRQ_MASK_SET_0_CH0_RANGE                 0:0
#define APBDMA_IRQ_MASK_SET_0_CH0_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_SET_0_CH0_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH0_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_SET_0_CH0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_SET_0_CH0_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_SET_0_CH0_ENABLE                        _MK_ENUM_CONST(1)


// Register APBDMA_IRQ_MASK_CLR_0  
#define APBDMA_IRQ_MASK_CLR_0                   _MK_ADDR_CONST(0x24)
#define APBDMA_IRQ_MASK_CLR_0_WORD_COUNT                        0x1
#define APBDMA_IRQ_MASK_CLR_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_RESET_MASK                        _MK_MASK_CONST(0xffff)
#define APBDMA_IRQ_MASK_CLR_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_READ_MASK                         _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_WRITE_MASK                        _MK_MASK_CONST(0xffff)
// Clears the Mask Register
#define APBDMA_IRQ_MASK_CLR_0_CH15_SHIFT                        _MK_SHIFT_CONST(15)
#define APBDMA_IRQ_MASK_CLR_0_CH15_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_CLR_0_CH15_SHIFT)
#define APBDMA_IRQ_MASK_CLR_0_CH15_RANGE                        15:15
#define APBDMA_IRQ_MASK_CLR_0_CH15_WOFFSET                      0x0
#define APBDMA_IRQ_MASK_CLR_0_CH15_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH15_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_CLR_0_CH15_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH15_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH15_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH15_ENABLE                       _MK_ENUM_CONST(1)

// Clears the Mask Register
#define APBDMA_IRQ_MASK_CLR_0_CH14_SHIFT                        _MK_SHIFT_CONST(14)
#define APBDMA_IRQ_MASK_CLR_0_CH14_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_CLR_0_CH14_SHIFT)
#define APBDMA_IRQ_MASK_CLR_0_CH14_RANGE                        14:14
#define APBDMA_IRQ_MASK_CLR_0_CH14_WOFFSET                      0x0
#define APBDMA_IRQ_MASK_CLR_0_CH14_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH14_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_CLR_0_CH14_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH14_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH14_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH14_ENABLE                       _MK_ENUM_CONST(1)

// Clears the Mask Register
#define APBDMA_IRQ_MASK_CLR_0_CH13_SHIFT                        _MK_SHIFT_CONST(13)
#define APBDMA_IRQ_MASK_CLR_0_CH13_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_CLR_0_CH13_SHIFT)
#define APBDMA_IRQ_MASK_CLR_0_CH13_RANGE                        13:13
#define APBDMA_IRQ_MASK_CLR_0_CH13_WOFFSET                      0x0
#define APBDMA_IRQ_MASK_CLR_0_CH13_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH13_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_CLR_0_CH13_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH13_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH13_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH13_ENABLE                       _MK_ENUM_CONST(1)

// Clears the Mask Register
#define APBDMA_IRQ_MASK_CLR_0_CH12_SHIFT                        _MK_SHIFT_CONST(12)
#define APBDMA_IRQ_MASK_CLR_0_CH12_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_CLR_0_CH12_SHIFT)
#define APBDMA_IRQ_MASK_CLR_0_CH12_RANGE                        12:12
#define APBDMA_IRQ_MASK_CLR_0_CH12_WOFFSET                      0x0
#define APBDMA_IRQ_MASK_CLR_0_CH12_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH12_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_CLR_0_CH12_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH12_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH12_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH12_ENABLE                       _MK_ENUM_CONST(1)

// Clears the Mask Register
#define APBDMA_IRQ_MASK_CLR_0_CH11_SHIFT                        _MK_SHIFT_CONST(11)
#define APBDMA_IRQ_MASK_CLR_0_CH11_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_CLR_0_CH11_SHIFT)
#define APBDMA_IRQ_MASK_CLR_0_CH11_RANGE                        11:11
#define APBDMA_IRQ_MASK_CLR_0_CH11_WOFFSET                      0x0
#define APBDMA_IRQ_MASK_CLR_0_CH11_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH11_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_CLR_0_CH11_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH11_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH11_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH11_ENABLE                       _MK_ENUM_CONST(1)

// Clears the Mask Register
#define APBDMA_IRQ_MASK_CLR_0_CH10_SHIFT                        _MK_SHIFT_CONST(10)
#define APBDMA_IRQ_MASK_CLR_0_CH10_FIELD                        (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_CLR_0_CH10_SHIFT)
#define APBDMA_IRQ_MASK_CLR_0_CH10_RANGE                        10:10
#define APBDMA_IRQ_MASK_CLR_0_CH10_WOFFSET                      0x0
#define APBDMA_IRQ_MASK_CLR_0_CH10_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH10_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_CLR_0_CH10_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH10_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH10_DISABLE                      _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH10_ENABLE                       _MK_ENUM_CONST(1)

// Clears the Mask Register
#define APBDMA_IRQ_MASK_CLR_0_CH9_SHIFT                 _MK_SHIFT_CONST(9)
#define APBDMA_IRQ_MASK_CLR_0_CH9_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_CLR_0_CH9_SHIFT)
#define APBDMA_IRQ_MASK_CLR_0_CH9_RANGE                 9:9
#define APBDMA_IRQ_MASK_CLR_0_CH9_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_CLR_0_CH9_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH9_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_CLR_0_CH9_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH9_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH9_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH9_ENABLE                        _MK_ENUM_CONST(1)

// Clears the Mask Register
#define APBDMA_IRQ_MASK_CLR_0_CH8_SHIFT                 _MK_SHIFT_CONST(8)
#define APBDMA_IRQ_MASK_CLR_0_CH8_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_CLR_0_CH8_SHIFT)
#define APBDMA_IRQ_MASK_CLR_0_CH8_RANGE                 8:8
#define APBDMA_IRQ_MASK_CLR_0_CH8_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_CLR_0_CH8_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH8_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_CLR_0_CH8_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH8_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH8_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH8_ENABLE                        _MK_ENUM_CONST(1)

// Clears the Mask Register
#define APBDMA_IRQ_MASK_CLR_0_CH7_SHIFT                 _MK_SHIFT_CONST(7)
#define APBDMA_IRQ_MASK_CLR_0_CH7_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_CLR_0_CH7_SHIFT)
#define APBDMA_IRQ_MASK_CLR_0_CH7_RANGE                 7:7
#define APBDMA_IRQ_MASK_CLR_0_CH7_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_CLR_0_CH7_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH7_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_CLR_0_CH7_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH7_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH7_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH7_ENABLE                        _MK_ENUM_CONST(1)

// Clears the Mask Register
#define APBDMA_IRQ_MASK_CLR_0_CH6_SHIFT                 _MK_SHIFT_CONST(6)
#define APBDMA_IRQ_MASK_CLR_0_CH6_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_CLR_0_CH6_SHIFT)
#define APBDMA_IRQ_MASK_CLR_0_CH6_RANGE                 6:6
#define APBDMA_IRQ_MASK_CLR_0_CH6_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_CLR_0_CH6_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH6_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_CLR_0_CH6_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH6_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH6_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH6_ENABLE                        _MK_ENUM_CONST(1)

// Clears the Mask Register
#define APBDMA_IRQ_MASK_CLR_0_CH5_SHIFT                 _MK_SHIFT_CONST(5)
#define APBDMA_IRQ_MASK_CLR_0_CH5_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_CLR_0_CH5_SHIFT)
#define APBDMA_IRQ_MASK_CLR_0_CH5_RANGE                 5:5
#define APBDMA_IRQ_MASK_CLR_0_CH5_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_CLR_0_CH5_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH5_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_CLR_0_CH5_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH5_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH5_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH5_ENABLE                        _MK_ENUM_CONST(1)

// Clears the Mask Register
#define APBDMA_IRQ_MASK_CLR_0_CH4_SHIFT                 _MK_SHIFT_CONST(4)
#define APBDMA_IRQ_MASK_CLR_0_CH4_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_CLR_0_CH4_SHIFT)
#define APBDMA_IRQ_MASK_CLR_0_CH4_RANGE                 4:4
#define APBDMA_IRQ_MASK_CLR_0_CH4_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_CLR_0_CH4_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH4_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_CLR_0_CH4_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH4_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH4_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH4_ENABLE                        _MK_ENUM_CONST(1)

// Clears the Mask Register
#define APBDMA_IRQ_MASK_CLR_0_CH3_SHIFT                 _MK_SHIFT_CONST(3)
#define APBDMA_IRQ_MASK_CLR_0_CH3_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_CLR_0_CH3_SHIFT)
#define APBDMA_IRQ_MASK_CLR_0_CH3_RANGE                 3:3
#define APBDMA_IRQ_MASK_CLR_0_CH3_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_CLR_0_CH3_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH3_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_CLR_0_CH3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH3_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH3_ENABLE                        _MK_ENUM_CONST(1)

// Clears the Mask Register
#define APBDMA_IRQ_MASK_CLR_0_CH2_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDMA_IRQ_MASK_CLR_0_CH2_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_CLR_0_CH2_SHIFT)
#define APBDMA_IRQ_MASK_CLR_0_CH2_RANGE                 2:2
#define APBDMA_IRQ_MASK_CLR_0_CH2_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_CLR_0_CH2_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH2_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_CLR_0_CH2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH2_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH2_ENABLE                        _MK_ENUM_CONST(1)

// Clears the Mask Register
#define APBDMA_IRQ_MASK_CLR_0_CH1_SHIFT                 _MK_SHIFT_CONST(1)
#define APBDMA_IRQ_MASK_CLR_0_CH1_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_CLR_0_CH1_SHIFT)
#define APBDMA_IRQ_MASK_CLR_0_CH1_RANGE                 1:1
#define APBDMA_IRQ_MASK_CLR_0_CH1_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_CLR_0_CH1_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH1_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_CLR_0_CH1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH1_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH1_ENABLE                        _MK_ENUM_CONST(1)

// Clears the Mask Register
#define APBDMA_IRQ_MASK_CLR_0_CH0_SHIFT                 _MK_SHIFT_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH0_FIELD                 (_MK_MASK_CONST(0x1) << APBDMA_IRQ_MASK_CLR_0_CH0_SHIFT)
#define APBDMA_IRQ_MASK_CLR_0_CH0_RANGE                 0:0
#define APBDMA_IRQ_MASK_CLR_0_CH0_WOFFSET                       0x0
#define APBDMA_IRQ_MASK_CLR_0_CH0_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH0_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDMA_IRQ_MASK_CLR_0_CH0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_IRQ_MASK_CLR_0_CH0_DISABLE                       _MK_ENUM_CONST(0)
#define APBDMA_IRQ_MASK_CLR_0_CH0_ENABLE                        _MK_ENUM_CONST(1)


// Register APBDMA_TRIG_REG_0  
#define APBDMA_TRIG_REG_0                       _MK_ADDR_CONST(0x28)
#define APBDMA_TRIG_REG_0_WORD_COUNT                    0x1
#define APBDMA_TRIG_REG_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_RESET_MASK                    _MK_MASK_CONST(0x1fffffe)
#define APBDMA_TRIG_REG_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_READ_MASK                     _MK_MASK_CONST(0x1fffffe)
#define APBDMA_TRIG_REG_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// EOC-15 Initiated DMA Request after transfer completion 
#define APBDMA_TRIG_REG_0_APB_15_SHIFT                  _MK_SHIFT_CONST(24)
#define APBDMA_TRIG_REG_0_APB_15_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_APB_15_SHIFT)
#define APBDMA_TRIG_REG_0_APB_15_RANGE                  24:24
#define APBDMA_TRIG_REG_0_APB_15_WOFFSET                        0x0
#define APBDMA_TRIG_REG_0_APB_15_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_15_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_APB_15_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_15_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_15_NOT_ACTIVE                     _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_APB_15_ACTIVE                 _MK_ENUM_CONST(1)

// EOC-14 Initiated DMA Request after transfer completion
#define APBDMA_TRIG_REG_0_APB_14_SHIFT                  _MK_SHIFT_CONST(23)
#define APBDMA_TRIG_REG_0_APB_14_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_APB_14_SHIFT)
#define APBDMA_TRIG_REG_0_APB_14_RANGE                  23:23
#define APBDMA_TRIG_REG_0_APB_14_WOFFSET                        0x0
#define APBDMA_TRIG_REG_0_APB_14_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_14_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_APB_14_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_14_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_14_NOT_ACTIVE                     _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_APB_14_ACTIVE                 _MK_ENUM_CONST(1)

// EOC-13 Initiated DMA Request after transfer completion
#define APBDMA_TRIG_REG_0_APB_13_SHIFT                  _MK_SHIFT_CONST(22)
#define APBDMA_TRIG_REG_0_APB_13_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_APB_13_SHIFT)
#define APBDMA_TRIG_REG_0_APB_13_RANGE                  22:22
#define APBDMA_TRIG_REG_0_APB_13_WOFFSET                        0x0
#define APBDMA_TRIG_REG_0_APB_13_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_13_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_APB_13_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_13_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_13_NOT_ACTIVE                     _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_APB_13_ACTIVE                 _MK_ENUM_CONST(1)

// EOC-12 Initiated DMA Request after transfer completion
#define APBDMA_TRIG_REG_0_APB_12_SHIFT                  _MK_SHIFT_CONST(21)
#define APBDMA_TRIG_REG_0_APB_12_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_APB_12_SHIFT)
#define APBDMA_TRIG_REG_0_APB_12_RANGE                  21:21
#define APBDMA_TRIG_REG_0_APB_12_WOFFSET                        0x0
#define APBDMA_TRIG_REG_0_APB_12_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_12_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_APB_12_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_12_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_12_NOT_ACTIVE                     _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_APB_12_ACTIVE                 _MK_ENUM_CONST(1)

// EOC-11 Initiated DMA Request after transfer completion
#define APBDMA_TRIG_REG_0_APB_11_SHIFT                  _MK_SHIFT_CONST(20)
#define APBDMA_TRIG_REG_0_APB_11_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_APB_11_SHIFT)
#define APBDMA_TRIG_REG_0_APB_11_RANGE                  20:20
#define APBDMA_TRIG_REG_0_APB_11_WOFFSET                        0x0
#define APBDMA_TRIG_REG_0_APB_11_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_11_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_APB_11_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_11_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_11_NOT_ACTIVE                     _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_APB_11_ACTIVE                 _MK_ENUM_CONST(1)

// EOC-10 Initiated DMA Request after transfer completion
#define APBDMA_TRIG_REG_0_APB_10_SHIFT                  _MK_SHIFT_CONST(19)
#define APBDMA_TRIG_REG_0_APB_10_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_APB_10_SHIFT)
#define APBDMA_TRIG_REG_0_APB_10_RANGE                  19:19
#define APBDMA_TRIG_REG_0_APB_10_WOFFSET                        0x0
#define APBDMA_TRIG_REG_0_APB_10_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_10_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_APB_10_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_10_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_10_NOT_ACTIVE                     _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_APB_10_ACTIVE                 _MK_ENUM_CONST(1)

// EOC-9 Initiated DMA Request after transfer completion
#define APBDMA_TRIG_REG_0_APB_9_SHIFT                   _MK_SHIFT_CONST(18)
#define APBDMA_TRIG_REG_0_APB_9_FIELD                   (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_APB_9_SHIFT)
#define APBDMA_TRIG_REG_0_APB_9_RANGE                   18:18
#define APBDMA_TRIG_REG_0_APB_9_WOFFSET                 0x0
#define APBDMA_TRIG_REG_0_APB_9_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_9_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_APB_9_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_9_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_9_NOT_ACTIVE                      _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_APB_9_ACTIVE                  _MK_ENUM_CONST(1)

// EOC-8 Initiated DMA Request after transfer completion
#define APBDMA_TRIG_REG_0_APB_8_SHIFT                   _MK_SHIFT_CONST(17)
#define APBDMA_TRIG_REG_0_APB_8_FIELD                   (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_APB_8_SHIFT)
#define APBDMA_TRIG_REG_0_APB_8_RANGE                   17:17
#define APBDMA_TRIG_REG_0_APB_8_WOFFSET                 0x0
#define APBDMA_TRIG_REG_0_APB_8_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_8_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_APB_8_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_8_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_8_NOT_ACTIVE                      _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_APB_8_ACTIVE                  _MK_ENUM_CONST(1)

// EOC-7 Initiated DMA Request after transfer completion
#define APBDMA_TRIG_REG_0_APB_7_SHIFT                   _MK_SHIFT_CONST(16)
#define APBDMA_TRIG_REG_0_APB_7_FIELD                   (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_APB_7_SHIFT)
#define APBDMA_TRIG_REG_0_APB_7_RANGE                   16:16
#define APBDMA_TRIG_REG_0_APB_7_WOFFSET                 0x0
#define APBDMA_TRIG_REG_0_APB_7_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_7_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_APB_7_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_7_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_7_NOT_ACTIVE                      _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_APB_7_ACTIVE                  _MK_ENUM_CONST(1)

// EOC-6 Initiated DMA Request after transfer completion
#define APBDMA_TRIG_REG_0_APB_6_SHIFT                   _MK_SHIFT_CONST(15)
#define APBDMA_TRIG_REG_0_APB_6_FIELD                   (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_APB_6_SHIFT)
#define APBDMA_TRIG_REG_0_APB_6_RANGE                   15:15
#define APBDMA_TRIG_REG_0_APB_6_WOFFSET                 0x0
#define APBDMA_TRIG_REG_0_APB_6_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_6_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_APB_6_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_6_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_6_NOT_ACTIVE                      _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_APB_6_ACTIVE                  _MK_ENUM_CONST(1)

// EOC-5 Initiated DMA Request after transfer completion
#define APBDMA_TRIG_REG_0_APB_5_SHIFT                   _MK_SHIFT_CONST(14)
#define APBDMA_TRIG_REG_0_APB_5_FIELD                   (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_APB_5_SHIFT)
#define APBDMA_TRIG_REG_0_APB_5_RANGE                   14:14
#define APBDMA_TRIG_REG_0_APB_5_WOFFSET                 0x0
#define APBDMA_TRIG_REG_0_APB_5_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_5_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_APB_5_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_5_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_5_NOT_ACTIVE                      _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_APB_5_ACTIVE                  _MK_ENUM_CONST(1)

// EOC-4 Initiated DMA Request after transfer completion
#define APBDMA_TRIG_REG_0_APB_4_SHIFT                   _MK_SHIFT_CONST(13)
#define APBDMA_TRIG_REG_0_APB_4_FIELD                   (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_APB_4_SHIFT)
#define APBDMA_TRIG_REG_0_APB_4_RANGE                   13:13
#define APBDMA_TRIG_REG_0_APB_4_WOFFSET                 0x0
#define APBDMA_TRIG_REG_0_APB_4_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_4_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_APB_4_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_4_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_4_NOT_ACTIVE                      _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_APB_4_ACTIVE                  _MK_ENUM_CONST(1)

// EOC-3 Initiated DMA Request after transfer completion
#define APBDMA_TRIG_REG_0_APB_3_SHIFT                   _MK_SHIFT_CONST(12)
#define APBDMA_TRIG_REG_0_APB_3_FIELD                   (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_APB_3_SHIFT)
#define APBDMA_TRIG_REG_0_APB_3_RANGE                   12:12
#define APBDMA_TRIG_REG_0_APB_3_WOFFSET                 0x0
#define APBDMA_TRIG_REG_0_APB_3_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_3_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_APB_3_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_3_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_3_NOT_ACTIVE                      _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_APB_3_ACTIVE                  _MK_ENUM_CONST(1)

// EOC-2 Initiated DMA Request after transfer completion
#define APBDMA_TRIG_REG_0_APB_2_SHIFT                   _MK_SHIFT_CONST(11)
#define APBDMA_TRIG_REG_0_APB_2_FIELD                   (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_APB_2_SHIFT)
#define APBDMA_TRIG_REG_0_APB_2_RANGE                   11:11
#define APBDMA_TRIG_REG_0_APB_2_WOFFSET                 0x0
#define APBDMA_TRIG_REG_0_APB_2_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_2_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_APB_2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_2_NOT_ACTIVE                      _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_APB_2_ACTIVE                  _MK_ENUM_CONST(1)

// EOC-1 Initiated DMA Request after transfer completion
#define APBDMA_TRIG_REG_0_APB_1_SHIFT                   _MK_SHIFT_CONST(10)
#define APBDMA_TRIG_REG_0_APB_1_FIELD                   (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_APB_1_SHIFT)
#define APBDMA_TRIG_REG_0_APB_1_RANGE                   10:10
#define APBDMA_TRIG_REG_0_APB_1_WOFFSET                 0x0
#define APBDMA_TRIG_REG_0_APB_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_1_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_APB_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_1_NOT_ACTIVE                      _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_APB_1_ACTIVE                  _MK_ENUM_CONST(1)

// EOC-0 Initiated DMA Request after transfer completion
#define APBDMA_TRIG_REG_0_APB_0_SHIFT                   _MK_SHIFT_CONST(9)
#define APBDMA_TRIG_REG_0_APB_0_FIELD                   (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_APB_0_SHIFT)
#define APBDMA_TRIG_REG_0_APB_0_RANGE                   9:9
#define APBDMA_TRIG_REG_0_APB_0_WOFFSET                 0x0
#define APBDMA_TRIG_REG_0_APB_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_0_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_APB_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_APB_0_NOT_ACTIVE                      _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_APB_0_ACTIVE                  _MK_ENUM_CONST(1)

// Trigger select from Timer (Hardware initiated DMA request) 
#define APBDMA_TRIG_REG_0_TMR2_SHIFT                    _MK_SHIFT_CONST(8)
#define APBDMA_TRIG_REG_0_TMR2_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_TMR2_SHIFT)
#define APBDMA_TRIG_REG_0_TMR2_RANGE                    8:8
#define APBDMA_TRIG_REG_0_TMR2_WOFFSET                  0x0
#define APBDMA_TRIG_REG_0_TMR2_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_TMR2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_TMR2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_TMR2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_TMR2_NOT_ACTIVE                       _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_TMR2_ACTIVE                   _MK_ENUM_CONST(1)

// Trigger select from Timer (Hardware initiated DMA request) 
#define APBDMA_TRIG_REG_0_TMR1_SHIFT                    _MK_SHIFT_CONST(7)
#define APBDMA_TRIG_REG_0_TMR1_FIELD                    (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_TMR1_SHIFT)
#define APBDMA_TRIG_REG_0_TMR1_RANGE                    7:7
#define APBDMA_TRIG_REG_0_TMR1_WOFFSET                  0x0
#define APBDMA_TRIG_REG_0_TMR1_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_TMR1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_TMR1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_TMR1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_TMR1_NOT_ACTIVE                       _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_TMR1_ACTIVE                   _MK_ENUM_CONST(1)

// XRQ.B (GPIOB) (Hardware initiated DMA request) 
#define APBDMA_TRIG_REG_0_XRQ_B_SHIFT                   _MK_SHIFT_CONST(6)
#define APBDMA_TRIG_REG_0_XRQ_B_FIELD                   (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_XRQ_B_SHIFT)
#define APBDMA_TRIG_REG_0_XRQ_B_RANGE                   6:6
#define APBDMA_TRIG_REG_0_XRQ_B_WOFFSET                 0x0
#define APBDMA_TRIG_REG_0_XRQ_B_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_XRQ_B_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_XRQ_B_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_XRQ_B_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_XRQ_B_NOT_ACTIVE                      _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_XRQ_B_ACTIVE                  _MK_ENUM_CONST(1)

// XRQ.A (GPIOA) (Hardware initiated DMA request) 
#define APBDMA_TRIG_REG_0_XRQ_A_SHIFT                   _MK_SHIFT_CONST(5)
#define APBDMA_TRIG_REG_0_XRQ_A_FIELD                   (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_XRQ_A_SHIFT)
#define APBDMA_TRIG_REG_0_XRQ_A_RANGE                   5:5
#define APBDMA_TRIG_REG_0_XRQ_A_WOFFSET                 0x0
#define APBDMA_TRIG_REG_0_XRQ_A_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_XRQ_A_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_XRQ_A_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_XRQ_A_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_XRQ_A_NOT_ACTIVE                      _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_XRQ_A_ACTIVE                  _MK_ENUM_CONST(1)

// Semaphore requests SW initiated DMA request
#define APBDMA_TRIG_REG_0_SMP_27_SHIFT                  _MK_SHIFT_CONST(4)
#define APBDMA_TRIG_REG_0_SMP_27_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_SMP_27_SHIFT)
#define APBDMA_TRIG_REG_0_SMP_27_RANGE                  4:4
#define APBDMA_TRIG_REG_0_SMP_27_WOFFSET                        0x0
#define APBDMA_TRIG_REG_0_SMP_27_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_SMP_27_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_SMP_27_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_SMP_27_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_SMP_27_NOT_ACTIVE                     _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_SMP_27_ACTIVE                 _MK_ENUM_CONST(1)

// Semaphore requests SW initiated DMA request 
#define APBDMA_TRIG_REG_0_SMP_26_SHIFT                  _MK_SHIFT_CONST(3)
#define APBDMA_TRIG_REG_0_SMP_26_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_SMP_26_SHIFT)
#define APBDMA_TRIG_REG_0_SMP_26_RANGE                  3:3
#define APBDMA_TRIG_REG_0_SMP_26_WOFFSET                        0x0
#define APBDMA_TRIG_REG_0_SMP_26_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_SMP_26_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_SMP_26_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_SMP_26_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_SMP_26_NOT_ACTIVE                     _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_SMP_26_ACTIVE                 _MK_ENUM_CONST(1)

// Semaphore requests SW initiated DMA request 
#define APBDMA_TRIG_REG_0_SMP_25_SHIFT                  _MK_SHIFT_CONST(2)
#define APBDMA_TRIG_REG_0_SMP_25_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_SMP_25_SHIFT)
#define APBDMA_TRIG_REG_0_SMP_25_RANGE                  2:2
#define APBDMA_TRIG_REG_0_SMP_25_WOFFSET                        0x0
#define APBDMA_TRIG_REG_0_SMP_25_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_SMP_25_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_SMP_25_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_SMP_25_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_SMP_25_NOT_ACTIVE                     _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_SMP_25_ACTIVE                 _MK_ENUM_CONST(1)

// Semaphore requests SW initiated DMA request 
#define APBDMA_TRIG_REG_0_SMP_24_SHIFT                  _MK_SHIFT_CONST(1)
#define APBDMA_TRIG_REG_0_SMP_24_FIELD                  (_MK_MASK_CONST(0x1) << APBDMA_TRIG_REG_0_SMP_24_SHIFT)
#define APBDMA_TRIG_REG_0_SMP_24_RANGE                  1:1
#define APBDMA_TRIG_REG_0_SMP_24_WOFFSET                        0x0
#define APBDMA_TRIG_REG_0_SMP_24_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_SMP_24_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDMA_TRIG_REG_0_SMP_24_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_SMP_24_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDMA_TRIG_REG_0_SMP_24_NOT_ACTIVE                     _MK_ENUM_CONST(0)
#define APBDMA_TRIG_REG_0_SMP_24_ACTIVE                 _MK_ENUM_CONST(1)


//
// REGISTER LIST
//
#define LIST_ARAPBDMA_REGS(_op_) \
_op_(APBDMA_COMMAND_0) \
_op_(APBDMA_STATUS_0) \
_op_(APBDMA_REQUESTORS_TX_0) \
_op_(APBDMA_REQUESTORS_RX_0) \
_op_(APBDMA_CNTRL_REG_0) \
_op_(APBDMA_IRQ_STA_CPU_0) \
_op_(APBDMA_IRQ_STA_COP_0) \
_op_(APBDMA_IRQ_MASK_0) \
_op_(APBDMA_IRQ_MASK_SET_0) \
_op_(APBDMA_IRQ_MASK_CLR_0) \
_op_(APBDMA_TRIG_REG_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_APBDMA     0x00000000

//
// ARAPBDMA REGISTER BANKS
//

#define APBDMA0_FIRST_REG 0x0000 // APBDMA_COMMAND_0
#define APBDMA0_LAST_REG 0x0028 // APBDMA_TRIG_REG_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARAPBDMA_H_INC_
