/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___AREMC_H_INC_
#define ___AREMC_H_INC_
#define EMC_FBIO_DATA_MAX       31
#define EMC_FBIO_DATA_WIDTH     32
#define EMC_FBIO_DOE_MAX        3
#define EMC_FBIO_DOE_WIDTH      4

// Register EMC_INTSTATUS_0  
#define EMC_INTSTATUS_0                 _MK_ADDR_CONST(0x0)
#define EMC_INTSTATUS_0_WORD_COUNT                      0x1
#define EMC_INTSTATUS_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_RESET_MASK                      _MK_MASK_CONST(0x4)
#define EMC_INTSTATUS_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_READ_MASK                       _MK_MASK_CONST(0x4)
#define EMC_INTSTATUS_0_WRITE_MASK                      _MK_MASK_CONST(0x4)
// NOR/MIO mux request timeout
#define EMC_INTSTATUS_0_NOR_TIMEOUT_INT_SHIFT                   _MK_SHIFT_CONST(2)
#define EMC_INTSTATUS_0_NOR_TIMEOUT_INT_FIELD                   (_MK_MASK_CONST(0x1) << EMC_INTSTATUS_0_NOR_TIMEOUT_INT_SHIFT)
#define EMC_INTSTATUS_0_NOR_TIMEOUT_INT_RANGE                   2:2
#define EMC_INTSTATUS_0_NOR_TIMEOUT_INT_WOFFSET                 0x0
#define EMC_INTSTATUS_0_NOR_TIMEOUT_INT_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_NOR_TIMEOUT_INT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define EMC_INTSTATUS_0_NOR_TIMEOUT_INT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_NOR_TIMEOUT_INT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_NOR_TIMEOUT_INT_INIT_ENUM                       CLEAR
#define EMC_INTSTATUS_0_NOR_TIMEOUT_INT_CLEAR                   _MK_ENUM_CONST(0)
#define EMC_INTSTATUS_0_NOR_TIMEOUT_INT_SET                     _MK_ENUM_CONST(1)


// Register EMC_INTMASK_0  
#define EMC_INTMASK_0                   _MK_ADDR_CONST(0x4)
#define EMC_INTMASK_0_WORD_COUNT                        0x1
#define EMC_INTMASK_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_RESET_MASK                        _MK_MASK_CONST(0x4)
#define EMC_INTMASK_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_READ_MASK                         _MK_MASK_CONST(0x4)
#define EMC_INTMASK_0_WRITE_MASK                        _MK_MASK_CONST(0x4)
// NOR/MIO mux request timeout
#define EMC_INTMASK_0_NOR_TIMEOUT_INTMASK_SHIFT                 _MK_SHIFT_CONST(2)
#define EMC_INTMASK_0_NOR_TIMEOUT_INTMASK_FIELD                 (_MK_MASK_CONST(0x1) << EMC_INTMASK_0_NOR_TIMEOUT_INTMASK_SHIFT)
#define EMC_INTMASK_0_NOR_TIMEOUT_INTMASK_RANGE                 2:2
#define EMC_INTMASK_0_NOR_TIMEOUT_INTMASK_WOFFSET                       0x0
#define EMC_INTMASK_0_NOR_TIMEOUT_INTMASK_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_NOR_TIMEOUT_INTMASK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_INTMASK_0_NOR_TIMEOUT_INTMASK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_NOR_TIMEOUT_INTMASK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_NOR_TIMEOUT_INTMASK_INIT_ENUM                     MASKED
#define EMC_INTMASK_0_NOR_TIMEOUT_INTMASK_MASKED                        _MK_ENUM_CONST(0)
#define EMC_INTMASK_0_NOR_TIMEOUT_INTMASK_UNMASKED                      _MK_ENUM_CONST(1)


// Register EMC_DBG_0  // Debug Register
#define EMC_DBG_0                       _MK_ADDR_CONST(0x8)
#define EMC_DBG_0_WORD_COUNT                    0x1
#define EMC_DBG_0_RESET_VAL                     _MK_MASK_CONST(0x1000400)
#define EMC_DBG_0_RESET_MASK                    _MK_MASK_CONST(0x1000637)
#define EMC_DBG_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_DBG_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_DBG_0_READ_MASK                     _MK_MASK_CONST(0x1000637)
#define EMC_DBG_0_WRITE_MASK                    _MK_MASK_CONST(0x1000637)
#define EMC_DBG_0_READ_MUX_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_DBG_0_READ_MUX_FIELD                        (_MK_MASK_CONST(0x1) << EMC_DBG_0_READ_MUX_SHIFT)
#define EMC_DBG_0_READ_MUX_RANGE                        0:0
#define EMC_DBG_0_READ_MUX_WOFFSET                      0x0
#define EMC_DBG_0_READ_MUX_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DBG_0_READ_MUX_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define EMC_DBG_0_READ_MUX_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_DBG_0_READ_MUX_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_DBG_0_READ_MUX_INIT_ENUM                    ACTIVE
#define EMC_DBG_0_READ_MUX_ACTIVE                       _MK_ENUM_CONST(0)
#define EMC_DBG_0_READ_MUX_ASSEMBLY                     _MK_ENUM_CONST(1)

#define EMC_DBG_0_WRITE_MUX_SHIFT                       _MK_SHIFT_CONST(1)
#define EMC_DBG_0_WRITE_MUX_FIELD                       (_MK_MASK_CONST(0x1) << EMC_DBG_0_WRITE_MUX_SHIFT)
#define EMC_DBG_0_WRITE_MUX_RANGE                       1:1
#define EMC_DBG_0_WRITE_MUX_WOFFSET                     0x0
#define EMC_DBG_0_WRITE_MUX_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_DBG_0_WRITE_MUX_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define EMC_DBG_0_WRITE_MUX_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_DBG_0_WRITE_MUX_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_DBG_0_WRITE_MUX_INIT_ENUM                   ASSEMBLY
#define EMC_DBG_0_WRITE_MUX_ASSEMBLY                    _MK_ENUM_CONST(0)
#define EMC_DBG_0_WRITE_MUX_ACTIVE                      _MK_ENUM_CONST(1)

#define EMC_DBG_0_FORCE_UPDATE_SHIFT                    _MK_SHIFT_CONST(2)
#define EMC_DBG_0_FORCE_UPDATE_FIELD                    (_MK_MASK_CONST(0x1) << EMC_DBG_0_FORCE_UPDATE_SHIFT)
#define EMC_DBG_0_FORCE_UPDATE_RANGE                    2:2
#define EMC_DBG_0_FORCE_UPDATE_WOFFSET                  0x0
#define EMC_DBG_0_FORCE_UPDATE_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_DBG_0_FORCE_UPDATE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_DBG_0_FORCE_UPDATE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DBG_0_FORCE_UPDATE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DBG_0_FORCE_UPDATE_INIT_ENUM                        DISABLED
#define EMC_DBG_0_FORCE_UPDATE_DISABLED                 _MK_ENUM_CONST(0)
#define EMC_DBG_0_FORCE_UPDATE_ENABLED                  _MK_ENUM_CONST(1)

#define EMC_DBG_0_MRS_WAIT_SHIFT                        _MK_SHIFT_CONST(4)
#define EMC_DBG_0_MRS_WAIT_FIELD                        (_MK_MASK_CONST(0x1) << EMC_DBG_0_MRS_WAIT_SHIFT)
#define EMC_DBG_0_MRS_WAIT_RANGE                        4:4
#define EMC_DBG_0_MRS_WAIT_WOFFSET                      0x0
#define EMC_DBG_0_MRS_WAIT_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DBG_0_MRS_WAIT_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define EMC_DBG_0_MRS_WAIT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_DBG_0_MRS_WAIT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_DBG_0_MRS_WAIT_INIT_ENUM                    MRS_2
#define EMC_DBG_0_MRS_WAIT_MRS_2                        _MK_ENUM_CONST(0)
#define EMC_DBG_0_MRS_WAIT_MRS_256                      _MK_ENUM_CONST(1)

#define EMC_DBG_0_PERIODIC_QRST_SHIFT                   _MK_SHIFT_CONST(5)
#define EMC_DBG_0_PERIODIC_QRST_FIELD                   (_MK_MASK_CONST(0x1) << EMC_DBG_0_PERIODIC_QRST_SHIFT)
#define EMC_DBG_0_PERIODIC_QRST_RANGE                   5:5
#define EMC_DBG_0_PERIODIC_QRST_WOFFSET                 0x0
#define EMC_DBG_0_PERIODIC_QRST_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_DBG_0_PERIODIC_QRST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define EMC_DBG_0_PERIODIC_QRST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DBG_0_PERIODIC_QRST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_DBG_0_PERIODIC_QRST_INIT_ENUM                       DISABLED
#define EMC_DBG_0_PERIODIC_QRST_DISABLED                        _MK_ENUM_CONST(0)
#define EMC_DBG_0_PERIODIC_QRST_ENABLED                 _MK_ENUM_CONST(1)

#define EMC_DBG_0_READ_DQM_CTRL_SHIFT                   _MK_SHIFT_CONST(9)
#define EMC_DBG_0_READ_DQM_CTRL_FIELD                   (_MK_MASK_CONST(0x1) << EMC_DBG_0_READ_DQM_CTRL_SHIFT)
#define EMC_DBG_0_READ_DQM_CTRL_RANGE                   9:9
#define EMC_DBG_0_READ_DQM_CTRL_WOFFSET                 0x0
#define EMC_DBG_0_READ_DQM_CTRL_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_DBG_0_READ_DQM_CTRL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define EMC_DBG_0_READ_DQM_CTRL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DBG_0_READ_DQM_CTRL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_DBG_0_READ_DQM_CTRL_INIT_ENUM                       MANAGED
#define EMC_DBG_0_READ_DQM_CTRL_MANAGED                 _MK_ENUM_CONST(0)
#define EMC_DBG_0_READ_DQM_CTRL_ALWAYS_ON                       _MK_ENUM_CONST(1)

#define EMC_DBG_0_AP_REQ_BUSY_CTRL_SHIFT                        _MK_SHIFT_CONST(10)
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_FIELD                        (_MK_MASK_CONST(0x1) << EMC_DBG_0_AP_REQ_BUSY_CTRL_SHIFT)
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_RANGE                        10:10
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_WOFFSET                      0x0
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_DEFAULT                      _MK_MASK_CONST(0x1)
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_INIT_ENUM                    ENABLED
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_DISABLED                     _MK_ENUM_CONST(0)
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_ENABLED                      _MK_ENUM_CONST(1)

#define EMC_DBG_0_CFG_PRIORITY_SHIFT                    _MK_SHIFT_CONST(24)
#define EMC_DBG_0_CFG_PRIORITY_FIELD                    (_MK_MASK_CONST(0x1) << EMC_DBG_0_CFG_PRIORITY_SHIFT)
#define EMC_DBG_0_CFG_PRIORITY_RANGE                    24:24
#define EMC_DBG_0_CFG_PRIORITY_WOFFSET                  0x0
#define EMC_DBG_0_CFG_PRIORITY_DEFAULT                  _MK_MASK_CONST(0x1)
#define EMC_DBG_0_CFG_PRIORITY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_DBG_0_CFG_PRIORITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DBG_0_CFG_PRIORITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DBG_0_CFG_PRIORITY_INIT_ENUM                        ENABLED
#define EMC_DBG_0_CFG_PRIORITY_DISABLED                 _MK_ENUM_CONST(0)
#define EMC_DBG_0_CFG_PRIORITY_ENABLED                  _MK_ENUM_CONST(1)


// Register EMC_CFG_0  // Configuration Register
#define EMC_CFG_0                       _MK_ADDR_CONST(0xc)
#define EMC_CFG_0_WORD_COUNT                    0x1
#define EMC_CFG_0_RESET_VAL                     _MK_MASK_CONST(0x300ff00)
#define EMC_CFG_0_RESET_MASK                    _MK_MASK_CONST(0xa301ff01)
#define EMC_CFG_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_CFG_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_CFG_0_READ_MASK                     _MK_MASK_CONST(0xa301ff01)
#define EMC_CFG_0_WRITE_MASK                    _MK_MASK_CONST(0xa301ff01)
#define EMC_CFG_0_PRE_IDLE_EN_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_CFG_0_PRE_IDLE_EN_FIELD                     (_MK_MASK_CONST(0x1) << EMC_CFG_0_PRE_IDLE_EN_SHIFT)
#define EMC_CFG_0_PRE_IDLE_EN_RANGE                     0:0
#define EMC_CFG_0_PRE_IDLE_EN_WOFFSET                   0x0
#define EMC_CFG_0_PRE_IDLE_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_CFG_0_PRE_IDLE_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define EMC_CFG_0_PRE_IDLE_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_CFG_0_PRE_IDLE_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_CFG_0_PRE_IDLE_EN_INIT_ENUM                 DISABLED
#define EMC_CFG_0_PRE_IDLE_EN_DISABLED                  _MK_ENUM_CONST(0)
#define EMC_CFG_0_PRE_IDLE_EN_ENABLED                   _MK_ENUM_CONST(1)

#define EMC_CFG_0_PRE_IDLE_CYCLES_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_CFG_0_PRE_IDLE_CYCLES_FIELD                 (_MK_MASK_CONST(0xff) << EMC_CFG_0_PRE_IDLE_CYCLES_SHIFT)
#define EMC_CFG_0_PRE_IDLE_CYCLES_RANGE                 15:8
#define EMC_CFG_0_PRE_IDLE_CYCLES_WOFFSET                       0x0
#define EMC_CFG_0_PRE_IDLE_CYCLES_DEFAULT                       _MK_MASK_CONST(0xff)
#define EMC_CFG_0_PRE_IDLE_CYCLES_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_CFG_0_PRE_IDLE_CYCLES_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CFG_0_PRE_IDLE_CYCLES_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_SHIFT                     _MK_SHIFT_CONST(16)
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_FIELD                     (_MK_MASK_CONST(0x1) << EMC_CFG_0_CLEAR_AP_PREV_SPREQ_SHIFT)
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_RANGE                     16:16
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_WOFFSET                   0x0
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_INIT_ENUM                 DISABLED
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_DISABLED                  _MK_ENUM_CONST(0)
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_ENABLED                   _MK_ENUM_CONST(1)

#define EMC_CFG_0_AUTO_PRE_RD_SHIFT                     _MK_SHIFT_CONST(24)
#define EMC_CFG_0_AUTO_PRE_RD_FIELD                     (_MK_MASK_CONST(0x1) << EMC_CFG_0_AUTO_PRE_RD_SHIFT)
#define EMC_CFG_0_AUTO_PRE_RD_RANGE                     24:24
#define EMC_CFG_0_AUTO_PRE_RD_WOFFSET                   0x0
#define EMC_CFG_0_AUTO_PRE_RD_DEFAULT                   _MK_MASK_CONST(0x1)
#define EMC_CFG_0_AUTO_PRE_RD_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define EMC_CFG_0_AUTO_PRE_RD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_CFG_0_AUTO_PRE_RD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_CFG_0_AUTO_PRE_RD_INIT_ENUM                 ENABLED
#define EMC_CFG_0_AUTO_PRE_RD_DISABLED                  _MK_ENUM_CONST(0)
#define EMC_CFG_0_AUTO_PRE_RD_ENABLED                   _MK_ENUM_CONST(1)

#define EMC_CFG_0_AUTO_PRE_WR_SHIFT                     _MK_SHIFT_CONST(25)
#define EMC_CFG_0_AUTO_PRE_WR_FIELD                     (_MK_MASK_CONST(0x1) << EMC_CFG_0_AUTO_PRE_WR_SHIFT)
#define EMC_CFG_0_AUTO_PRE_WR_RANGE                     25:25
#define EMC_CFG_0_AUTO_PRE_WR_WOFFSET                   0x0
#define EMC_CFG_0_AUTO_PRE_WR_DEFAULT                   _MK_MASK_CONST(0x1)
#define EMC_CFG_0_AUTO_PRE_WR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define EMC_CFG_0_AUTO_PRE_WR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_CFG_0_AUTO_PRE_WR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_CFG_0_AUTO_PRE_WR_INIT_ENUM                 ENABLED
#define EMC_CFG_0_AUTO_PRE_WR_DISABLED                  _MK_ENUM_CONST(0)
#define EMC_CFG_0_AUTO_PRE_WR_ENABLED                   _MK_ENUM_CONST(1)

#define EMC_CFG_0_DRAM_ACPD_SHIFT                       _MK_SHIFT_CONST(29)
#define EMC_CFG_0_DRAM_ACPD_FIELD                       (_MK_MASK_CONST(0x1) << EMC_CFG_0_DRAM_ACPD_SHIFT)
#define EMC_CFG_0_DRAM_ACPD_RANGE                       29:29
#define EMC_CFG_0_DRAM_ACPD_WOFFSET                     0x0
#define EMC_CFG_0_DRAM_ACPD_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_CFG_0_DRAM_ACPD_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define EMC_CFG_0_DRAM_ACPD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CFG_0_DRAM_ACPD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_CFG_0_DRAM_ACPD_INIT_ENUM                   NO_POWERDOWN
#define EMC_CFG_0_DRAM_ACPD_NO_POWERDOWN                        _MK_ENUM_CONST(0)
#define EMC_CFG_0_DRAM_ACPD_ACTIVE_POWERDOWN                    _MK_ENUM_CONST(1)

#define EMC_CFG_0_DRAM_CLKSTOP_SHIFT                    _MK_SHIFT_CONST(31)
#define EMC_CFG_0_DRAM_CLKSTOP_FIELD                    (_MK_MASK_CONST(0x1) << EMC_CFG_0_DRAM_CLKSTOP_SHIFT)
#define EMC_CFG_0_DRAM_CLKSTOP_RANGE                    31:31
#define EMC_CFG_0_DRAM_CLKSTOP_WOFFSET                  0x0
#define EMC_CFG_0_DRAM_CLKSTOP_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CFG_0_DRAM_CLKSTOP_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_CFG_0_DRAM_CLKSTOP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CFG_0_DRAM_CLKSTOP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_CFG_0_DRAM_CLKSTOP_INIT_ENUM                        DISABLED
#define EMC_CFG_0_DRAM_CLKSTOP_DISABLED                 _MK_ENUM_CONST(0)
#define EMC_CFG_0_DRAM_CLKSTOP_ENABLED                  _MK_ENUM_CONST(1)


// Register EMC_ADR_CFG_0  
#define EMC_ADR_CFG_0                   _MK_ADDR_CONST(0x10)
#define EMC_ADR_CFG_0_WORD_COUNT                        0x1
#define EMC_ADR_CFG_0_RESET_VAL                         _MK_MASK_CONST(0x40202)
#define EMC_ADR_CFG_0_RESET_MASK                        _MK_MASK_CONST(0x3070307)
#define EMC_ADR_CFG_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_READ_MASK                         _MK_MASK_CONST(0x3070307)
#define EMC_ADR_CFG_0_WRITE_MASK                        _MK_MASK_CONST(0x3070307)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_FIELD                       (_MK_MASK_CONST(0x7) << EMC_ADR_CFG_0_EMEM_COLWIDTH_SHIFT)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_RANGE                       2:0
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_WOFFSET                     0x0
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_DEFAULT                     _MK_MASK_CONST(0x2)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_INIT_ENUM                   W9
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_W7                  _MK_ENUM_CONST(0)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_W8                  _MK_ENUM_CONST(1)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_W9                  _MK_ENUM_CONST(2)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_W10                 _MK_ENUM_CONST(3)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_W11                 _MK_ENUM_CONST(4)

#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_SHIFT                      _MK_SHIFT_CONST(8)
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_FIELD                      (_MK_MASK_CONST(0x3) << EMC_ADR_CFG_0_EMEM_BANKWIDTH_SHIFT)
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_RANGE                      9:8
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_WOFFSET                    0x0
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_INIT_ENUM                  W2
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_W1                 _MK_ENUM_CONST(1)
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_W2                 _MK_ENUM_CONST(2)
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_W3                 _MK_ENUM_CONST(3)

#define EMC_ADR_CFG_0_EMEM_DEVSIZE_SHIFT                        _MK_SHIFT_CONST(16)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_FIELD                        (_MK_MASK_CONST(0x7) << EMC_ADR_CFG_0_EMEM_DEVSIZE_SHIFT)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_RANGE                        18:16
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_WOFFSET                      0x0
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_DEFAULT                      _MK_MASK_CONST(0x4)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_DEFAULT_MASK                 _MK_MASK_CONST(0x7)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_INIT_ENUM                    D64MB
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D4MB                 _MK_ENUM_CONST(0)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D8MB                 _MK_ENUM_CONST(1)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D16MB                        _MK_ENUM_CONST(2)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D32MB                        _MK_ENUM_CONST(3)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D64MB                        _MK_ENUM_CONST(4)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D128MB                       _MK_ENUM_CONST(5)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D256MB                       _MK_ENUM_CONST(6)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D512MB                       _MK_ENUM_CONST(7)

#define EMC_ADR_CFG_0_EMEM_NUMDEV_SHIFT                 _MK_SHIFT_CONST(24)
#define EMC_ADR_CFG_0_EMEM_NUMDEV_FIELD                 (_MK_MASK_CONST(0x3) << EMC_ADR_CFG_0_EMEM_NUMDEV_SHIFT)
#define EMC_ADR_CFG_0_EMEM_NUMDEV_RANGE                 25:24
#define EMC_ADR_CFG_0_EMEM_NUMDEV_WOFFSET                       0x0
#define EMC_ADR_CFG_0_EMEM_NUMDEV_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_NUMDEV_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define EMC_ADR_CFG_0_EMEM_NUMDEV_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_NUMDEV_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_NUMDEV_INIT_ENUM                     N1
#define EMC_ADR_CFG_0_EMEM_NUMDEV_N1                    _MK_ENUM_CONST(0)
#define EMC_ADR_CFG_0_EMEM_NUMDEV_N2                    _MK_ENUM_CONST(1)


// Register EMC_REFCTRL_0  // Refresh Control Register
#define EMC_REFCTRL_0                   _MK_ADDR_CONST(0x14)
#define EMC_REFCTRL_0_WORD_COUNT                        0x1
#define EMC_REFCTRL_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_REFCTRL_0_RESET_MASK                        _MK_MASK_CONST(0x80000000)
#define EMC_REFCTRL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_REFCTRL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_REFCTRL_0_READ_MASK                         _MK_MASK_CONST(0x80000000)
#define EMC_REFCTRL_0_WRITE_MASK                        _MK_MASK_CONST(0x80000000)
#define EMC_REFCTRL_0_REF_VALID_SHIFT                   _MK_SHIFT_CONST(31)
#define EMC_REFCTRL_0_REF_VALID_FIELD                   (_MK_MASK_CONST(0x1) << EMC_REFCTRL_0_REF_VALID_SHIFT)
#define EMC_REFCTRL_0_REF_VALID_RANGE                   31:31
#define EMC_REFCTRL_0_REF_VALID_WOFFSET                 0x0
#define EMC_REFCTRL_0_REF_VALID_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_REFCTRL_0_REF_VALID_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define EMC_REFCTRL_0_REF_VALID_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_REFCTRL_0_REF_VALID_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_REFCTRL_0_REF_VALID_INIT_ENUM                       DISABLED
#define EMC_REFCTRL_0_REF_VALID_DISABLED                        _MK_ENUM_CONST(0)
#define EMC_REFCTRL_0_REF_VALID_ENABLED                 _MK_ENUM_CONST(1)


// Register EMC_PIN_0  // Controls state of selected DRAM pins
#define EMC_PIN_0                       _MK_ADDR_CONST(0x18)
#define EMC_PIN_0_WORD_COUNT                    0x1
#define EMC_PIN_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_PIN_0_RESET_MASK                    _MK_MASK_CONST(0x11)
#define EMC_PIN_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_PIN_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_PIN_0_READ_MASK                     _MK_MASK_CONST(0x11)
#define EMC_PIN_0_WRITE_MASK                    _MK_MASK_CONST(0x11)
#define EMC_PIN_0_PIN_CKE_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_PIN_0_PIN_CKE_FIELD                 (_MK_MASK_CONST(0x1) << EMC_PIN_0_PIN_CKE_SHIFT)
#define EMC_PIN_0_PIN_CKE_RANGE                 0:0
#define EMC_PIN_0_PIN_CKE_WOFFSET                       0x0
#define EMC_PIN_0_PIN_CKE_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_PIN_0_PIN_CKE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_PIN_0_PIN_CKE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_PIN_0_PIN_CKE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_PIN_0_PIN_CKE_INIT_ENUM                     POWERDOWN
#define EMC_PIN_0_PIN_CKE_POWERDOWN                     _MK_ENUM_CONST(0)
#define EMC_PIN_0_PIN_CKE_NORMAL                        _MK_ENUM_CONST(1)

#define EMC_PIN_0_PIN_DQM_SHIFT                 _MK_SHIFT_CONST(4)
#define EMC_PIN_0_PIN_DQM_FIELD                 (_MK_MASK_CONST(0x1) << EMC_PIN_0_PIN_DQM_SHIFT)
#define EMC_PIN_0_PIN_DQM_RANGE                 4:4
#define EMC_PIN_0_PIN_DQM_WOFFSET                       0x0
#define EMC_PIN_0_PIN_DQM_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_PIN_0_PIN_DQM_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_PIN_0_PIN_DQM_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_PIN_0_PIN_DQM_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_PIN_0_PIN_DQM_INIT_ENUM                     NORMAL
#define EMC_PIN_0_PIN_DQM_NORMAL                        _MK_ENUM_CONST(0)
#define EMC_PIN_0_PIN_DQM_INACTIVE                      _MK_ENUM_CONST(1)


// Register EMC_TIMING_CONTROL_0  
#define EMC_TIMING_CONTROL_0                    _MK_ADDR_CONST(0x1c)
#define EMC_TIMING_CONTROL_0_WORD_COUNT                         0x1
#define EMC_TIMING_CONTROL_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_TIMING_CONTROL_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define EMC_TIMING_CONTROL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_TIMING_CONTROL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_TIMING_CONTROL_0_READ_MASK                  _MK_MASK_CONST(0x1)
#define EMC_TIMING_CONTROL_0_WRITE_MASK                         _MK_MASK_CONST(0x1)
#define EMC_TIMING_CONTROL_0_TIMING_UPDATE_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_TIMING_CONTROL_0_TIMING_UPDATE_FIELD                        (_MK_MASK_CONST(0x1) << EMC_TIMING_CONTROL_0_TIMING_UPDATE_SHIFT)
#define EMC_TIMING_CONTROL_0_TIMING_UPDATE_RANGE                        0:0
#define EMC_TIMING_CONTROL_0_TIMING_UPDATE_WOFFSET                      0x0
#define EMC_TIMING_CONTROL_0_TIMING_UPDATE_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_TIMING_CONTROL_0_TIMING_UPDATE_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_TIMING_CONTROL_0_TIMING_UPDATE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_TIMING_CONTROL_0_TIMING_UPDATE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register EMC_TIMING0_0  // Timing Control Register 0
#define EMC_TIMING0_0                   _MK_ADDR_CONST(0x20)
#define EMC_TIMING0_0_WORD_COUNT                        0x1
#define EMC_TIMING0_0_RESET_VAL                         _MK_MASK_CONST(0x3f3f3f3f)
#define EMC_TIMING0_0_RESET_MASK                        _MK_MASK_CONST(0x3f3f3f3f)
#define EMC_TIMING0_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_TIMING0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_TIMING0_0_READ_MASK                         _MK_MASK_CONST(0x3f3f3f3f)
#define EMC_TIMING0_0_WRITE_MASK                        _MK_MASK_CONST(0x3f3f3f3f)
#define EMC_TIMING0_0_RC_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_TIMING0_0_RC_FIELD                  (_MK_MASK_CONST(0x3f) << EMC_TIMING0_0_RC_SHIFT)
#define EMC_TIMING0_0_RC_RANGE                  5:0
#define EMC_TIMING0_0_RC_WOFFSET                        0x0
#define EMC_TIMING0_0_RC_DEFAULT                        _MK_MASK_CONST(0x3f)
#define EMC_TIMING0_0_RC_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define EMC_TIMING0_0_RC_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_TIMING0_0_RC_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define EMC_TIMING0_0_RFC_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_TIMING0_0_RFC_FIELD                 (_MK_MASK_CONST(0x3f) << EMC_TIMING0_0_RFC_SHIFT)
#define EMC_TIMING0_0_RFC_RANGE                 13:8
#define EMC_TIMING0_0_RFC_WOFFSET                       0x0
#define EMC_TIMING0_0_RFC_DEFAULT                       _MK_MASK_CONST(0x3f)
#define EMC_TIMING0_0_RFC_DEFAULT_MASK                  _MK_MASK_CONST(0x3f)
#define EMC_TIMING0_0_RFC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_TIMING0_0_RFC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_TIMING0_0_RAS_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_TIMING0_0_RAS_FIELD                 (_MK_MASK_CONST(0x3f) << EMC_TIMING0_0_RAS_SHIFT)
#define EMC_TIMING0_0_RAS_RANGE                 21:16
#define EMC_TIMING0_0_RAS_WOFFSET                       0x0
#define EMC_TIMING0_0_RAS_DEFAULT                       _MK_MASK_CONST(0x3f)
#define EMC_TIMING0_0_RAS_DEFAULT_MASK                  _MK_MASK_CONST(0x3f)
#define EMC_TIMING0_0_RAS_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_TIMING0_0_RAS_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_TIMING0_0_RP_SHIFT                  _MK_SHIFT_CONST(24)
#define EMC_TIMING0_0_RP_FIELD                  (_MK_MASK_CONST(0x3f) << EMC_TIMING0_0_RP_SHIFT)
#define EMC_TIMING0_0_RP_RANGE                  29:24
#define EMC_TIMING0_0_RP_WOFFSET                        0x0
#define EMC_TIMING0_0_RP_DEFAULT                        _MK_MASK_CONST(0x3f)
#define EMC_TIMING0_0_RP_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define EMC_TIMING0_0_RP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_TIMING0_0_RP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register EMC_TIMING1_0  // Timing Control Register 1
#define EMC_TIMING1_0                   _MK_ADDR_CONST(0x24)
#define EMC_TIMING1_0_WORD_COUNT                        0x1
#define EMC_TIMING1_0_RESET_VAL                         _MK_MASK_CONST(0x1f1f1f1f)
#define EMC_TIMING1_0_RESET_MASK                        _MK_MASK_CONST(0x1f1f1f1f)
#define EMC_TIMING1_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_TIMING1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_TIMING1_0_READ_MASK                         _MK_MASK_CONST(0x1f1f1f1f)
#define EMC_TIMING1_0_WRITE_MASK                        _MK_MASK_CONST(0x1f1f1f1f)
#define EMC_TIMING1_0_R2W_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_TIMING1_0_R2W_FIELD                 (_MK_MASK_CONST(0x1f) << EMC_TIMING1_0_R2W_SHIFT)
#define EMC_TIMING1_0_R2W_RANGE                 4:0
#define EMC_TIMING1_0_R2W_WOFFSET                       0x0
#define EMC_TIMING1_0_R2W_DEFAULT                       _MK_MASK_CONST(0x1f)
#define EMC_TIMING1_0_R2W_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define EMC_TIMING1_0_R2W_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_TIMING1_0_R2W_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_TIMING1_0_W2R_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_TIMING1_0_W2R_FIELD                 (_MK_MASK_CONST(0x1f) << EMC_TIMING1_0_W2R_SHIFT)
#define EMC_TIMING1_0_W2R_RANGE                 12:8
#define EMC_TIMING1_0_W2R_WOFFSET                       0x0
#define EMC_TIMING1_0_W2R_DEFAULT                       _MK_MASK_CONST(0x1f)
#define EMC_TIMING1_0_W2R_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define EMC_TIMING1_0_W2R_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_TIMING1_0_W2R_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_TIMING1_0_R2P_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_TIMING1_0_R2P_FIELD                 (_MK_MASK_CONST(0x1f) << EMC_TIMING1_0_R2P_SHIFT)
#define EMC_TIMING1_0_R2P_RANGE                 20:16
#define EMC_TIMING1_0_R2P_WOFFSET                       0x0
#define EMC_TIMING1_0_R2P_DEFAULT                       _MK_MASK_CONST(0x1f)
#define EMC_TIMING1_0_R2P_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define EMC_TIMING1_0_R2P_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_TIMING1_0_R2P_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_TIMING1_0_W2P_SHIFT                 _MK_SHIFT_CONST(24)
#define EMC_TIMING1_0_W2P_FIELD                 (_MK_MASK_CONST(0x1f) << EMC_TIMING1_0_W2P_SHIFT)
#define EMC_TIMING1_0_W2P_RANGE                 28:24
#define EMC_TIMING1_0_W2P_WOFFSET                       0x0
#define EMC_TIMING1_0_W2P_DEFAULT                       _MK_MASK_CONST(0x1f)
#define EMC_TIMING1_0_W2P_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define EMC_TIMING1_0_W2P_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_TIMING1_0_W2P_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_TIMING2_0  // Timing Control Register 2
#define EMC_TIMING2_0                   _MK_ADDR_CONST(0x28)
#define EMC_TIMING2_0_WORD_COUNT                        0x1
#define EMC_TIMING2_0_RESET_VAL                         _MK_MASK_CONST(0x1f1f1f)
#define EMC_TIMING2_0_RESET_MASK                        _MK_MASK_CONST(0xfff1f1f)
#define EMC_TIMING2_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_TIMING2_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_TIMING2_0_READ_MASK                         _MK_MASK_CONST(0xfff1f1f)
#define EMC_TIMING2_0_WRITE_MASK                        _MK_MASK_CONST(0xfff1f1f)
#define EMC_TIMING2_0_RD_RCD_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC_TIMING2_0_RD_RCD_FIELD                      (_MK_MASK_CONST(0x1f) << EMC_TIMING2_0_RD_RCD_SHIFT)
#define EMC_TIMING2_0_RD_RCD_RANGE                      4:0
#define EMC_TIMING2_0_RD_RCD_WOFFSET                    0x0
#define EMC_TIMING2_0_RD_RCD_DEFAULT                    _MK_MASK_CONST(0x1f)
#define EMC_TIMING2_0_RD_RCD_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define EMC_TIMING2_0_RD_RCD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_TIMING2_0_RD_RCD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define EMC_TIMING2_0_WR_RCD_SHIFT                      _MK_SHIFT_CONST(8)
#define EMC_TIMING2_0_WR_RCD_FIELD                      (_MK_MASK_CONST(0x1f) << EMC_TIMING2_0_WR_RCD_SHIFT)
#define EMC_TIMING2_0_WR_RCD_RANGE                      12:8
#define EMC_TIMING2_0_WR_RCD_WOFFSET                    0x0
#define EMC_TIMING2_0_WR_RCD_DEFAULT                    _MK_MASK_CONST(0x1f)
#define EMC_TIMING2_0_WR_RCD_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define EMC_TIMING2_0_WR_RCD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_TIMING2_0_WR_RCD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define EMC_TIMING2_0_RRD_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_TIMING2_0_RRD_FIELD                 (_MK_MASK_CONST(0xf) << EMC_TIMING2_0_RRD_SHIFT)
#define EMC_TIMING2_0_RRD_RANGE                 19:16
#define EMC_TIMING2_0_RRD_WOFFSET                       0x0
#define EMC_TIMING2_0_RRD_DEFAULT                       _MK_MASK_CONST(0xf)
#define EMC_TIMING2_0_RRD_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define EMC_TIMING2_0_RRD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_TIMING2_0_RRD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_TIMING2_0_REXT_SHIFT                        _MK_SHIFT_CONST(20)
#define EMC_TIMING2_0_REXT_FIELD                        (_MK_MASK_CONST(0xf) << EMC_TIMING2_0_REXT_SHIFT)
#define EMC_TIMING2_0_REXT_RANGE                        23:20
#define EMC_TIMING2_0_REXT_WOFFSET                      0x0
#define EMC_TIMING2_0_REXT_DEFAULT                      _MK_MASK_CONST(0x1)
#define EMC_TIMING2_0_REXT_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define EMC_TIMING2_0_REXT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_TIMING2_0_REXT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define EMC_TIMING2_0_WDV_SHIFT                 _MK_SHIFT_CONST(24)
#define EMC_TIMING2_0_WDV_FIELD                 (_MK_MASK_CONST(0xf) << EMC_TIMING2_0_WDV_SHIFT)
#define EMC_TIMING2_0_WDV_RANGE                 27:24
#define EMC_TIMING2_0_WDV_WOFFSET                       0x0
#define EMC_TIMING2_0_WDV_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_TIMING2_0_WDV_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define EMC_TIMING2_0_WDV_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_TIMING2_0_WDV_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_TIMING3_0  // Timing Control Register 3
#define EMC_TIMING3_0                   _MK_ADDR_CONST(0x2c)
#define EMC_TIMING3_0_WORD_COUNT                        0x1
#define EMC_TIMING3_0_RESET_VAL                         _MK_MASK_CONST(0x87102)
#define EMC_TIMING3_0_RESET_MASK                        _MK_MASK_CONST(0x1fff0f)
#define EMC_TIMING3_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_TIMING3_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_TIMING3_0_READ_MASK                         _MK_MASK_CONST(0x1fff0f)
#define EMC_TIMING3_0_WRITE_MASK                        _MK_MASK_CONST(0x1fff0f)
#define EMC_TIMING3_0_QUSE_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_TIMING3_0_QUSE_FIELD                        (_MK_MASK_CONST(0xf) << EMC_TIMING3_0_QUSE_SHIFT)
#define EMC_TIMING3_0_QUSE_RANGE                        3:0
#define EMC_TIMING3_0_QUSE_WOFFSET                      0x0
#define EMC_TIMING3_0_QUSE_DEFAULT                      _MK_MASK_CONST(0x2)
#define EMC_TIMING3_0_QUSE_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define EMC_TIMING3_0_QUSE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_TIMING3_0_QUSE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define EMC_TIMING3_0_QRST_SHIFT                        _MK_SHIFT_CONST(8)
#define EMC_TIMING3_0_QRST_FIELD                        (_MK_MASK_CONST(0xf) << EMC_TIMING3_0_QRST_SHIFT)
#define EMC_TIMING3_0_QRST_RANGE                        11:8
#define EMC_TIMING3_0_QRST_WOFFSET                      0x0
#define EMC_TIMING3_0_QRST_DEFAULT                      _MK_MASK_CONST(0x1)
#define EMC_TIMING3_0_QRST_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define EMC_TIMING3_0_QRST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_TIMING3_0_QRST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define EMC_TIMING3_0_QSAFE_SHIFT                       _MK_SHIFT_CONST(12)
#define EMC_TIMING3_0_QSAFE_FIELD                       (_MK_MASK_CONST(0xf) << EMC_TIMING3_0_QSAFE_SHIFT)
#define EMC_TIMING3_0_QSAFE_RANGE                       15:12
#define EMC_TIMING3_0_QSAFE_WOFFSET                     0x0
#define EMC_TIMING3_0_QSAFE_DEFAULT                     _MK_MASK_CONST(0x7)
#define EMC_TIMING3_0_QSAFE_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define EMC_TIMING3_0_QSAFE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_TIMING3_0_QSAFE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define EMC_TIMING3_0_RDV_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_TIMING3_0_RDV_FIELD                 (_MK_MASK_CONST(0x1f) << EMC_TIMING3_0_RDV_SHIFT)
#define EMC_TIMING3_0_RDV_RANGE                 20:16
#define EMC_TIMING3_0_RDV_WOFFSET                       0x0
#define EMC_TIMING3_0_RDV_DEFAULT                       _MK_MASK_CONST(0x8)
#define EMC_TIMING3_0_RDV_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define EMC_TIMING3_0_RDV_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_TIMING3_0_RDV_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_TIMING3_0_RDV_MAX                   _MK_ENUM_CONST(11)


// Register EMC_TIMING4_0  // Timing Control Register 4
#define EMC_TIMING4_0                   _MK_ADDR_CONST(0x30)
#define EMC_TIMING4_0_WORD_COUNT                        0x1
#define EMC_TIMING4_0_RESET_VAL                         _MK_MASK_CONST(0x1f)
#define EMC_TIMING4_0_RESET_MASK                        _MK_MASK_CONST(0x7001f)
#define EMC_TIMING4_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_TIMING4_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_TIMING4_0_READ_MASK                         _MK_MASK_CONST(0x7ffff)
#define EMC_TIMING4_0_WRITE_MASK                        _MK_MASK_CONST(0x7ffff)
#define EMC_TIMING4_0_REFRESH_LO_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_TIMING4_0_REFRESH_LO_FIELD                  (_MK_MASK_CONST(0x1f) << EMC_TIMING4_0_REFRESH_LO_SHIFT)
#define EMC_TIMING4_0_REFRESH_LO_RANGE                  4:0
#define EMC_TIMING4_0_REFRESH_LO_WOFFSET                        0x0
#define EMC_TIMING4_0_REFRESH_LO_DEFAULT                        _MK_MASK_CONST(0x1f)
#define EMC_TIMING4_0_REFRESH_LO_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define EMC_TIMING4_0_REFRESH_LO_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_TIMING4_0_REFRESH_LO_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_TIMING4_0_REFRESH_LO_INIT_ENUM                      MAX
#define EMC_TIMING4_0_REFRESH_LO_MAX                    _MK_ENUM_CONST(31)

#define EMC_TIMING4_0_REFRESH_SHIFT                     _MK_SHIFT_CONST(5)
#define EMC_TIMING4_0_REFRESH_FIELD                     (_MK_MASK_CONST(0x7ff) << EMC_TIMING4_0_REFRESH_SHIFT)
#define EMC_TIMING4_0_REFRESH_RANGE                     15:5
#define EMC_TIMING4_0_REFRESH_WOFFSET                   0x0
#define EMC_TIMING4_0_REFRESH_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_TIMING4_0_REFRESH_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_TIMING4_0_REFRESH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_TIMING4_0_REFRESH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_TIMING4_0_BURST_REFRESH_NUM_SHIFT                   _MK_SHIFT_CONST(16)
#define EMC_TIMING4_0_BURST_REFRESH_NUM_FIELD                   (_MK_MASK_CONST(0x7) << EMC_TIMING4_0_BURST_REFRESH_NUM_SHIFT)
#define EMC_TIMING4_0_BURST_REFRESH_NUM_RANGE                   18:16
#define EMC_TIMING4_0_BURST_REFRESH_NUM_WOFFSET                 0x0
#define EMC_TIMING4_0_BURST_REFRESH_NUM_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_TIMING4_0_BURST_REFRESH_NUM_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define EMC_TIMING4_0_BURST_REFRESH_NUM_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_TIMING4_0_BURST_REFRESH_NUM_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_TIMING4_0_BURST_REFRESH_NUM_INIT_ENUM                       BR1
#define EMC_TIMING4_0_BURST_REFRESH_NUM_BR1                     _MK_ENUM_CONST(0)
#define EMC_TIMING4_0_BURST_REFRESH_NUM_BR2                     _MK_ENUM_CONST(1)
#define EMC_TIMING4_0_BURST_REFRESH_NUM_BR3                     _MK_ENUM_CONST(2)
#define EMC_TIMING4_0_BURST_REFRESH_NUM_BR4                     _MK_ENUM_CONST(3)
#define EMC_TIMING4_0_BURST_REFRESH_NUM_BR5                     _MK_ENUM_CONST(4)
#define EMC_TIMING4_0_BURST_REFRESH_NUM_BR6                     _MK_ENUM_CONST(5)
#define EMC_TIMING4_0_BURST_REFRESH_NUM_BR7                     _MK_ENUM_CONST(6)
#define EMC_TIMING4_0_BURST_REFRESH_NUM_BR8                     _MK_ENUM_CONST(7)


// Register EMC_TIMING5_0  // Timing Control Register 5
#define EMC_TIMING5_0                   _MK_ADDR_CONST(0x34)
#define EMC_TIMING5_0_WORD_COUNT                        0x1
#define EMC_TIMING5_0_RESET_VAL                         _MK_MASK_CONST(0x1ffffff)
#define EMC_TIMING5_0_RESET_MASK                        _MK_MASK_CONST(0x1ffffff)
#define EMC_TIMING5_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_TIMING5_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_TIMING5_0_READ_MASK                         _MK_MASK_CONST(0x1ffffff)
#define EMC_TIMING5_0_WRITE_MASK                        _MK_MASK_CONST(0x1ffffff)
#define EMC_TIMING5_0_PDEX2WR_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_TIMING5_0_PDEX2WR_FIELD                     (_MK_MASK_CONST(0xf) << EMC_TIMING5_0_PDEX2WR_SHIFT)
#define EMC_TIMING5_0_PDEX2WR_RANGE                     3:0
#define EMC_TIMING5_0_PDEX2WR_WOFFSET                   0x0
#define EMC_TIMING5_0_PDEX2WR_DEFAULT                   _MK_MASK_CONST(0xf)
#define EMC_TIMING5_0_PDEX2WR_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define EMC_TIMING5_0_PDEX2WR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_TIMING5_0_PDEX2WR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_TIMING5_0_PDEX2RD_SHIFT                     _MK_SHIFT_CONST(4)
#define EMC_TIMING5_0_PDEX2RD_FIELD                     (_MK_MASK_CONST(0xf) << EMC_TIMING5_0_PDEX2RD_SHIFT)
#define EMC_TIMING5_0_PDEX2RD_RANGE                     7:4
#define EMC_TIMING5_0_PDEX2RD_WOFFSET                   0x0
#define EMC_TIMING5_0_PDEX2RD_DEFAULT                   _MK_MASK_CONST(0xf)
#define EMC_TIMING5_0_PDEX2RD_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define EMC_TIMING5_0_PDEX2RD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_TIMING5_0_PDEX2RD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_TIMING5_0_PCHG2PDEN_SHIFT                   _MK_SHIFT_CONST(8)
#define EMC_TIMING5_0_PCHG2PDEN_FIELD                   (_MK_MASK_CONST(0xf) << EMC_TIMING5_0_PCHG2PDEN_SHIFT)
#define EMC_TIMING5_0_PCHG2PDEN_RANGE                   11:8
#define EMC_TIMING5_0_PCHG2PDEN_WOFFSET                 0x0
#define EMC_TIMING5_0_PCHG2PDEN_DEFAULT                 _MK_MASK_CONST(0xf)
#define EMC_TIMING5_0_PCHG2PDEN_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define EMC_TIMING5_0_PCHG2PDEN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_TIMING5_0_PCHG2PDEN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_TIMING5_0_RW2PDEN_SHIFT                     _MK_SHIFT_CONST(12)
#define EMC_TIMING5_0_RW2PDEN_FIELD                     (_MK_MASK_CONST(0xf) << EMC_TIMING5_0_RW2PDEN_SHIFT)
#define EMC_TIMING5_0_RW2PDEN_RANGE                     15:12
#define EMC_TIMING5_0_RW2PDEN_WOFFSET                   0x0
#define EMC_TIMING5_0_RW2PDEN_DEFAULT                   _MK_MASK_CONST(0xf)
#define EMC_TIMING5_0_RW2PDEN_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define EMC_TIMING5_0_RW2PDEN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_TIMING5_0_RW2PDEN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_TIMING5_0_ACT2PDEN_SHIFT                    _MK_SHIFT_CONST(16)
#define EMC_TIMING5_0_ACT2PDEN_FIELD                    (_MK_MASK_CONST(0xf) << EMC_TIMING5_0_ACT2PDEN_SHIFT)
#define EMC_TIMING5_0_ACT2PDEN_RANGE                    19:16
#define EMC_TIMING5_0_ACT2PDEN_WOFFSET                  0x0
#define EMC_TIMING5_0_ACT2PDEN_DEFAULT                  _MK_MASK_CONST(0xf)
#define EMC_TIMING5_0_ACT2PDEN_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define EMC_TIMING5_0_ACT2PDEN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_TIMING5_0_ACT2PDEN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define EMC_TIMING5_0_AR2PDEN_SHIFT                     _MK_SHIFT_CONST(20)
#define EMC_TIMING5_0_AR2PDEN_FIELD                     (_MK_MASK_CONST(0x1f) << EMC_TIMING5_0_AR2PDEN_SHIFT)
#define EMC_TIMING5_0_AR2PDEN_RANGE                     24:20
#define EMC_TIMING5_0_AR2PDEN_WOFFSET                   0x0
#define EMC_TIMING5_0_AR2PDEN_DEFAULT                   _MK_MASK_CONST(0x1f)
#define EMC_TIMING5_0_AR2PDEN_DEFAULT_MASK                      _MK_MASK_CONST(0x1f)
#define EMC_TIMING5_0_AR2PDEN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_TIMING5_0_AR2PDEN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_MRS_0  // MRS value
#define EMC_MRS_0                       _MK_ADDR_CONST(0x38)
#define EMC_MRS_0_WORD_COUNT                    0x1
#define EMC_MRS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_MRS_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_MRS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_MRS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_MRS_0_READ_MASK                     _MK_MASK_CONST(0x303fff)
#define EMC_MRS_0_WRITE_MASK                    _MK_MASK_CONST(0x303fff)
#define EMC_MRS_0_MRS_ADR_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_MRS_0_MRS_ADR_FIELD                 (_MK_MASK_CONST(0x3fff) << EMC_MRS_0_MRS_ADR_SHIFT)
#define EMC_MRS_0_MRS_ADR_RANGE                 13:0
#define EMC_MRS_0_MRS_ADR_WOFFSET                       0x0
#define EMC_MRS_0_MRS_ADR_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_MRS_0_MRS_ADR_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_MRS_0_MRS_ADR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_MRS_0_MRS_ADR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_MRS_0_MRS_BA_SHIFT                  _MK_SHIFT_CONST(20)
#define EMC_MRS_0_MRS_BA_FIELD                  (_MK_MASK_CONST(0x3) << EMC_MRS_0_MRS_BA_SHIFT)
#define EMC_MRS_0_MRS_BA_RANGE                  21:20
#define EMC_MRS_0_MRS_BA_WOFFSET                        0x0
#define EMC_MRS_0_MRS_BA_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_MRS_0_MRS_BA_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_MRS_0_MRS_BA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_MRS_0_MRS_BA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register EMC_EMRS_0  // EMRS value
#define EMC_EMRS_0                      _MK_ADDR_CONST(0x3c)
#define EMC_EMRS_0_WORD_COUNT                   0x1
#define EMC_EMRS_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_RESET_MASK                   _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_READ_MASK                    _MK_MASK_CONST(0x303fff)
#define EMC_EMRS_0_WRITE_MASK                   _MK_MASK_CONST(0x303fff)
#define EMC_EMRS_0_EMRS_ADR_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_EMRS_0_EMRS_ADR_FIELD                       (_MK_MASK_CONST(0x3fff) << EMC_EMRS_0_EMRS_ADR_SHIFT)
#define EMC_EMRS_0_EMRS_ADR_RANGE                       13:0
#define EMC_EMRS_0_EMRS_ADR_WOFFSET                     0x0
#define EMC_EMRS_0_EMRS_ADR_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_EMRS_ADR_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_EMRS_ADR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_EMRS_ADR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define EMC_EMRS_0_EMRS_BA_SHIFT                        _MK_SHIFT_CONST(20)
#define EMC_EMRS_0_EMRS_BA_FIELD                        (_MK_MASK_CONST(0x3) << EMC_EMRS_0_EMRS_BA_SHIFT)
#define EMC_EMRS_0_EMRS_BA_RANGE                        21:20
#define EMC_EMRS_0_EMRS_BA_WOFFSET                      0x0
#define EMC_EMRS_0_EMRS_BA_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_EMRS_BA_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_EMRS_BA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_EMRS_BA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register EMC_REF_0  // Refresh command register
#define EMC_REF_0                       _MK_ADDR_CONST(0x40)
#define EMC_REF_0_WORD_COUNT                    0x1
#define EMC_REF_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_REF_0_RESET_MASK                    _MK_MASK_CONST(0xff01)
#define EMC_REF_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_REF_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_REF_0_READ_MASK                     _MK_MASK_CONST(0xff01)
#define EMC_REF_0_WRITE_MASK                    _MK_MASK_CONST(0xff01)
#define EMC_REF_0_REF_CMD_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_REF_0_REF_CMD_FIELD                 (_MK_MASK_CONST(0x1) << EMC_REF_0_REF_CMD_SHIFT)
#define EMC_REF_0_REF_CMD_RANGE                 0:0
#define EMC_REF_0_REF_CMD_WOFFSET                       0x0
#define EMC_REF_0_REF_CMD_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_REF_0_REF_CMD_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_REF_0_REF_CMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_REF_0_REF_CMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_REF_0_REF_NUM_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_REF_0_REF_NUM_FIELD                 (_MK_MASK_CONST(0xff) << EMC_REF_0_REF_NUM_SHIFT)
#define EMC_REF_0_REF_NUM_RANGE                 15:8
#define EMC_REF_0_REF_NUM_WOFFSET                       0x0
#define EMC_REF_0_REF_NUM_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_REF_0_REF_NUM_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_REF_0_REF_NUM_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_REF_0_REF_NUM_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_PRE_0  // Precharge command register
#define EMC_PRE_0                       _MK_ADDR_CONST(0x44)
#define EMC_PRE_0_WORD_COUNT                    0x1
#define EMC_PRE_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_PRE_0_RESET_MASK                    _MK_MASK_CONST(0x1)
#define EMC_PRE_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_PRE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_PRE_0_READ_MASK                     _MK_MASK_CONST(0x1)
#define EMC_PRE_0_WRITE_MASK                    _MK_MASK_CONST(0x1)
#define EMC_PRE_0_PRE_CMD_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_PRE_0_PRE_CMD_FIELD                 (_MK_MASK_CONST(0x1) << EMC_PRE_0_PRE_CMD_SHIFT)
#define EMC_PRE_0_PRE_CMD_RANGE                 0:0
#define EMC_PRE_0_PRE_CMD_WOFFSET                       0x0
#define EMC_PRE_0_PRE_CMD_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_PRE_0_PRE_CMD_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_PRE_0_PRE_CMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_PRE_0_PRE_CMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_NOP_0  // NOP command register
#define EMC_NOP_0                       _MK_ADDR_CONST(0x48)
#define EMC_NOP_0_WORD_COUNT                    0x1
#define EMC_NOP_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_NOP_0_RESET_MASK                    _MK_MASK_CONST(0x1)
#define EMC_NOP_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_NOP_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_NOP_0_READ_MASK                     _MK_MASK_CONST(0x1)
#define EMC_NOP_0_WRITE_MASK                    _MK_MASK_CONST(0x1)
#define EMC_NOP_0_NOP_CMD_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_NOP_0_NOP_CMD_FIELD                 (_MK_MASK_CONST(0x1) << EMC_NOP_0_NOP_CMD_SHIFT)
#define EMC_NOP_0_NOP_CMD_RANGE                 0:0
#define EMC_NOP_0_NOP_CMD_WOFFSET                       0x0
#define EMC_NOP_0_NOP_CMD_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_NOP_0_NOP_CMD_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_NOP_0_NOP_CMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_NOP_0_NOP_CMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_SELF_REF_0  // SELF REFRESH command register
#define EMC_SELF_REF_0                  _MK_ADDR_CONST(0x4c)
#define EMC_SELF_REF_0_WORD_COUNT                       0x1
#define EMC_SELF_REF_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define EMC_SELF_REF_0_RESET_MASK                       _MK_MASK_CONST(0x1)
#define EMC_SELF_REF_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_SELF_REF_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_SELF_REF_0_READ_MASK                        _MK_MASK_CONST(0x1)
#define EMC_SELF_REF_0_WRITE_MASK                       _MK_MASK_CONST(0x1)
#define EMC_SELF_REF_0_SELF_REF_CMD_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_SELF_REF_0_SELF_REF_CMD_FIELD                       (_MK_MASK_CONST(0x1) << EMC_SELF_REF_0_SELF_REF_CMD_SHIFT)
#define EMC_SELF_REF_0_SELF_REF_CMD_RANGE                       0:0
#define EMC_SELF_REF_0_SELF_REF_CMD_WOFFSET                     0x0
#define EMC_SELF_REF_0_SELF_REF_CMD_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_SELF_REF_0_SELF_REF_CMD_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define EMC_SELF_REF_0_SELF_REF_CMD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_SELF_REF_0_SELF_REF_CMD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_SELF_REF_0_SELF_REF_CMD_INIT_ENUM                   DISABLED
#define EMC_SELF_REF_0_SELF_REF_CMD_DISABLED                    _MK_ENUM_CONST(0)
#define EMC_SELF_REF_0_SELF_REF_CMD_ENABLED                     _MK_ENUM_CONST(1)


// Register EMC_DPD_0  // Deep Power Down command register
#define EMC_DPD_0                       _MK_ADDR_CONST(0x50)
#define EMC_DPD_0_WORD_COUNT                    0x1
#define EMC_DPD_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_DPD_0_RESET_MASK                    _MK_MASK_CONST(0x1)
#define EMC_DPD_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_DPD_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_DPD_0_READ_MASK                     _MK_MASK_CONST(0x1)
#define EMC_DPD_0_WRITE_MASK                    _MK_MASK_CONST(0x1)
#define EMC_DPD_0_DPD_CMD_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_DPD_0_DPD_CMD_FIELD                 (_MK_MASK_CONST(0x1) << EMC_DPD_0_DPD_CMD_SHIFT)
#define EMC_DPD_0_DPD_CMD_RANGE                 0:0
#define EMC_DPD_0_DPD_CMD_WOFFSET                       0x0
#define EMC_DPD_0_DPD_CMD_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DPD_0_DPD_CMD_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_DPD_0_DPD_CMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DPD_0_DPD_CMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_DPD_0_DPD_CMD_INIT_ENUM                     DISABLED
#define EMC_DPD_0_DPD_CMD_DISABLED                      _MK_ENUM_CONST(0)
#define EMC_DPD_0_DPD_CMD_ENABLED                       _MK_ENUM_CONST(1)


// Register EMC_CMDQ_0  // Command Queue Depth register
#define EMC_CMDQ_0                      _MK_ADDR_CONST(0x54)
#define EMC_CMDQ_0_WORD_COUNT                   0x1
#define EMC_CMDQ_0_RESET_VAL                    _MK_MASK_CONST(0x1304)
#define EMC_CMDQ_0_RESET_MASK                   _MK_MASK_CONST(0x770f)
#define EMC_CMDQ_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_CMDQ_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_CMDQ_0_READ_MASK                    _MK_MASK_CONST(0x770f)
#define EMC_CMDQ_0_WRITE_MASK                   _MK_MASK_CONST(0x770f)
#define EMC_CMDQ_0_RW_DEPTH_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_CMDQ_0_RW_DEPTH_FIELD                       (_MK_MASK_CONST(0xf) << EMC_CMDQ_0_RW_DEPTH_SHIFT)
#define EMC_CMDQ_0_RW_DEPTH_RANGE                       3:0
#define EMC_CMDQ_0_RW_DEPTH_WOFFSET                     0x0
#define EMC_CMDQ_0_RW_DEPTH_DEFAULT                     _MK_MASK_CONST(0x4)
#define EMC_CMDQ_0_RW_DEPTH_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define EMC_CMDQ_0_RW_DEPTH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CMDQ_0_RW_DEPTH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define EMC_CMDQ_0_ACT_DEPTH_SHIFT                      _MK_SHIFT_CONST(8)
#define EMC_CMDQ_0_ACT_DEPTH_FIELD                      (_MK_MASK_CONST(0x7) << EMC_CMDQ_0_ACT_DEPTH_SHIFT)
#define EMC_CMDQ_0_ACT_DEPTH_RANGE                      10:8
#define EMC_CMDQ_0_ACT_DEPTH_WOFFSET                    0x0
#define EMC_CMDQ_0_ACT_DEPTH_DEFAULT                    _MK_MASK_CONST(0x3)
#define EMC_CMDQ_0_ACT_DEPTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define EMC_CMDQ_0_ACT_DEPTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CMDQ_0_ACT_DEPTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define EMC_CMDQ_0_PRE_DEPTH_SHIFT                      _MK_SHIFT_CONST(12)
#define EMC_CMDQ_0_PRE_DEPTH_FIELD                      (_MK_MASK_CONST(0x7) << EMC_CMDQ_0_PRE_DEPTH_SHIFT)
#define EMC_CMDQ_0_PRE_DEPTH_RANGE                      14:12
#define EMC_CMDQ_0_PRE_DEPTH_WOFFSET                    0x0
#define EMC_CMDQ_0_PRE_DEPTH_DEFAULT                    _MK_MASK_CONST(0x1)
#define EMC_CMDQ_0_PRE_DEPTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define EMC_CMDQ_0_PRE_DEPTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CMDQ_0_PRE_DEPTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register EMC_FBIO_CFG1_0  // FBIO configuration register
#define EMC_FBIO_CFG1_0                 _MK_ADDR_CONST(0x58)
#define EMC_FBIO_CFG1_0_WORD_COUNT                      0x1
#define EMC_FBIO_CFG1_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG1_0_RESET_MASK                      _MK_MASK_CONST(0x10000)
#define EMC_FBIO_CFG1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG1_0_READ_MASK                       _MK_MASK_CONST(0x10000)
#define EMC_FBIO_CFG1_0_WRITE_MASK                      _MK_MASK_CONST(0x10000)
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_SHIFT                     _MK_SHIFT_CONST(16)
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_FIELD                     (_MK_MASK_CONST(0x1) << EMC_FBIO_CFG1_0_CFG_DEN_EARLY_SHIFT)
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_RANGE                     16:16
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_WOFFSET                   0x0
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_INIT_ENUM                 DISABLE
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_DISABLE                   _MK_ENUM_CONST(0)
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_ENABLE                    _MK_ENUM_CONST(1)


// Register EMC_FBIO_DQSIB_DLY_0  // FBIO configuration register
#define EMC_FBIO_DQSIB_DLY_0                    _MK_ADDR_CONST(0x5c)
#define EMC_FBIO_DQSIB_DLY_0_WORD_COUNT                         0x1
#define EMC_FBIO_DQSIB_DLY_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_FBIO_DQSIB_DLY_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_FIELD                 (_MK_MASK_CONST(0xff) << EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_SHIFT)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_RANGE                 7:0
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_WOFFSET                       0x0
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_MAX                   _MK_ENUM_CONST(47)

#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_FIELD                 (_MK_MASK_CONST(0xff) << EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_SHIFT)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_RANGE                 15:8
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_WOFFSET                       0x0
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_MAX                   _MK_ENUM_CONST(47)

#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_FIELD                 (_MK_MASK_CONST(0xff) << EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_SHIFT)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_RANGE                 23:16
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_WOFFSET                       0x0
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_MAX                   _MK_ENUM_CONST(47)

#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_SHIFT                 _MK_SHIFT_CONST(24)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_FIELD                 (_MK_MASK_CONST(0xff) << EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_SHIFT)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_RANGE                 31:24
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_WOFFSET                       0x0
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_MAX                   _MK_ENUM_CONST(47)


// Register EMC_FBIO_SPARE_0  // FBIO spare register
#define EMC_FBIO_SPARE_0                        _MK_ADDR_CONST(0x60)
#define EMC_FBIO_SPARE_0_WORD_COUNT                     0x1
#define EMC_FBIO_SPARE_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_SPARE_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_FBIO_SPARE_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_FBIO_SPARE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_FBIO_SPARE_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define EMC_FBIO_SPARE_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_FIELD                   (_MK_MASK_CONST(0xffffffff) << EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_SHIFT)
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_RANGE                   31:0
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_WOFFSET                 0x0
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_FBIO_CFG5_0  // FBIO configuration Register 
#define EMC_FBIO_CFG5_0                 _MK_ADDR_CONST(0x64)
#define EMC_FBIO_CFG5_0_WORD_COUNT                      0x1
#define EMC_FBIO_CFG5_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_RESET_MASK                      _MK_MASK_CONST(0x11)
#define EMC_FBIO_CFG5_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_READ_MASK                       _MK_MASK_CONST(0x11)
#define EMC_FBIO_CFG5_0_WRITE_MASK                      _MK_MASK_CONST(0x11)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_FIELD                 (_MK_MASK_CONST(0x1) << EMC_FBIO_CFG5_0_DRAM_TYPE_SHIFT)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_RANGE                 0:0
#define EMC_FBIO_CFG5_0_DRAM_TYPE_WOFFSET                       0x0
#define EMC_FBIO_CFG5_0_DRAM_TYPE_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_INIT_ENUM                     SDR
#define EMC_FBIO_CFG5_0_DRAM_TYPE_SDR                   _MK_ENUM_CONST(0)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_DDR1                  _MK_ENUM_CONST(1)

#define EMC_FBIO_CFG5_0_DRAM_WIDTH_SHIFT                        _MK_SHIFT_CONST(4)
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_FIELD                        (_MK_MASK_CONST(0x1) << EMC_FBIO_CFG5_0_DRAM_WIDTH_SHIFT)
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_RANGE                        4:4
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_WOFFSET                      0x0
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_INIT_ENUM                    X32
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_X32                  _MK_ENUM_CONST(0)
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_X16                  _MK_ENUM_CONST(1)


// Register EMC_FBIO_WRPTR_EQ_2_0  // FBIO wrptr register
#define EMC_FBIO_WRPTR_EQ_2_0                   _MK_ADDR_CONST(0x68)
#define EMC_FBIO_WRPTR_EQ_2_0_WORD_COUNT                        0x1
#define EMC_FBIO_WRPTR_EQ_2_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_FBIO_WRPTR_EQ_2_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define EMC_FBIO_WRPTR_EQ_2_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_WRPTR_EQ_2_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_FBIO_WRPTR_EQ_2_0_READ_MASK                         _MK_MASK_CONST(0xf)
#define EMC_FBIO_WRPTR_EQ_2_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_FIELD                       (_MK_MASK_CONST(0xf) << EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_SHIFT)
#define EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_RANGE                       3:0
#define EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_WOFFSET                     0x0
#define EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_FBIO_QUSE_DLY_0  // QUSE delay register   
#define EMC_FBIO_QUSE_DLY_0                     _MK_ADDR_CONST(0x6c)
#define EMC_FBIO_QUSE_DLY_0_WORD_COUNT                  0x1
#define EMC_FBIO_QUSE_DLY_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EMC_FBIO_QUSE_DLY_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_FIELD                   (_MK_MASK_CONST(0xff) << EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_SHIFT)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_RANGE                   7:0
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_WOFFSET                 0x0
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_MAX                     _MK_ENUM_CONST(47)

#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_SHIFT                   _MK_SHIFT_CONST(8)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_FIELD                   (_MK_MASK_CONST(0xff) << EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_SHIFT)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_RANGE                   15:8
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_WOFFSET                 0x0
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_MAX                     _MK_ENUM_CONST(47)

#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_SHIFT                   _MK_SHIFT_CONST(16)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_FIELD                   (_MK_MASK_CONST(0xff) << EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_SHIFT)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_RANGE                   23:16
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_WOFFSET                 0x0
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_MAX                     _MK_ENUM_CONST(47)

#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_SHIFT                   _MK_SHIFT_CONST(24)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_FIELD                   (_MK_MASK_CONST(0xff) << EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_SHIFT)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_RANGE                   31:24
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_WOFFSET                 0x0
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_MAX                     _MK_ENUM_CONST(47)


// Register EMC_FBIO_CFG6_0  // FBIO configuration register   
#define EMC_FBIO_CFG6_0                 _MK_ADDR_CONST(0x70)
#define EMC_FBIO_CFG6_0_WORD_COUNT                      0x1
#define EMC_FBIO_CFG6_0_RESET_VAL                       _MK_MASK_CONST(0x2)
#define EMC_FBIO_CFG6_0_RESET_MASK                      _MK_MASK_CONST(0x7)
#define EMC_FBIO_CFG6_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG6_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG6_0_READ_MASK                       _MK_MASK_CONST(0x7)
#define EMC_FBIO_CFG6_0_WRITE_MASK                      _MK_MASK_CONST(0x7)
#define EMC_FBIO_CFG6_0_CFG_QUSE_LATE_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_FBIO_CFG6_0_CFG_QUSE_LATE_FIELD                     (_MK_MASK_CONST(0x7) << EMC_FBIO_CFG6_0_CFG_QUSE_LATE_SHIFT)
#define EMC_FBIO_CFG6_0_CFG_QUSE_LATE_RANGE                     2:0
#define EMC_FBIO_CFG6_0_CFG_QUSE_LATE_WOFFSET                   0x0
#define EMC_FBIO_CFG6_0_CFG_QUSE_LATE_DEFAULT                   _MK_MASK_CONST(0x2)
#define EMC_FBIO_CFG6_0_CFG_QUSE_LATE_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define EMC_FBIO_CFG6_0_CFG_QUSE_LATE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG6_0_CFG_QUSE_LATE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_BUSARB_0  // Bus Arbitration Timeout register
#define EMC_BUSARB_0                    _MK_ADDR_CONST(0x74)
#define EMC_BUSARB_0_WORD_COUNT                         0x1
#define EMC_BUSARB_0_RESET_VAL                  _MK_MASK_CONST(0x13ff02f)
#define EMC_BUSARB_0_RESET_MASK                         _MK_MASK_CONST(0x1ffff3ff)
#define EMC_BUSARB_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_BUSARB_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_BUSARB_0_READ_MASK                  _MK_MASK_CONST(0x1ffff3ff)
#define EMC_BUSARB_0_WRITE_MASK                         _MK_MASK_CONST(0x1ffff3ff)
#define EMC_BUSARB_0_EMC_MIN_TRANS_TIME_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_BUSARB_0_EMC_MIN_TRANS_TIME_FIELD                   (_MK_MASK_CONST(0x3ff) << EMC_BUSARB_0_EMC_MIN_TRANS_TIME_SHIFT)
#define EMC_BUSARB_0_EMC_MIN_TRANS_TIME_RANGE                   9:0
#define EMC_BUSARB_0_EMC_MIN_TRANS_TIME_WOFFSET                 0x0
#define EMC_BUSARB_0_EMC_MIN_TRANS_TIME_DEFAULT                 _MK_MASK_CONST(0x2f)
#define EMC_BUSARB_0_EMC_MIN_TRANS_TIME_DEFAULT_MASK                    _MK_MASK_CONST(0x3ff)
#define EMC_BUSARB_0_EMC_MIN_TRANS_TIME_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_BUSARB_0_EMC_MIN_TRANS_TIME_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_BUSARB_0_NOR_MAX_TRANS_TIME_SHIFT                   _MK_SHIFT_CONST(12)
#define EMC_BUSARB_0_NOR_MAX_TRANS_TIME_FIELD                   (_MK_MASK_CONST(0xfff) << EMC_BUSARB_0_NOR_MAX_TRANS_TIME_SHIFT)
#define EMC_BUSARB_0_NOR_MAX_TRANS_TIME_RANGE                   23:12
#define EMC_BUSARB_0_NOR_MAX_TRANS_TIME_WOFFSET                 0x0
#define EMC_BUSARB_0_NOR_MAX_TRANS_TIME_DEFAULT                 _MK_MASK_CONST(0x3ff)
#define EMC_BUSARB_0_NOR_MAX_TRANS_TIME_DEFAULT_MASK                    _MK_MASK_CONST(0xfff)
#define EMC_BUSARB_0_NOR_MAX_TRANS_TIME_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_BUSARB_0_NOR_MAX_TRANS_TIME_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_BUSARB_0_BUS_TURNAROUND_SHIFT                       _MK_SHIFT_CONST(24)
#define EMC_BUSARB_0_BUS_TURNAROUND_FIELD                       (_MK_MASK_CONST(0x1f) << EMC_BUSARB_0_BUS_TURNAROUND_SHIFT)
#define EMC_BUSARB_0_BUS_TURNAROUND_RANGE                       28:24
#define EMC_BUSARB_0_BUS_TURNAROUND_WOFFSET                     0x0
#define EMC_BUSARB_0_BUS_TURNAROUND_DEFAULT                     _MK_MASK_CONST(0x1)
#define EMC_BUSARB_0_BUS_TURNAROUND_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define EMC_BUSARB_0_BUS_TURNAROUND_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_BUSARB_0_BUS_TURNAROUND_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_DYN_DQS_0  
#define EMC_DYN_DQS_0                   _MK_ADDR_CONST(0x78)
#define EMC_DYN_DQS_0_WORD_COUNT                        0x1
#define EMC_DYN_DQS_0_RESET_VAL                         _MK_MASK_CONST(0x8000010)
#define EMC_DYN_DQS_0_RESET_MASK                        _MK_MASK_CONST(0x9f07ff1f)
#define EMC_DYN_DQS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_DYN_DQS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DYN_DQS_0_READ_MASK                         _MK_MASK_CONST(0x9f07ff1f)
#define EMC_DYN_DQS_0_WRITE_MASK                        _MK_MASK_CONST(0x9f07ff1f)
#define EMC_DYN_DQS_0_DYN_DQS_MULT_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_DYN_DQS_0_DYN_DQS_MULT_FIELD                        (_MK_MASK_CONST(0x1f) << EMC_DYN_DQS_0_DYN_DQS_MULT_SHIFT)
#define EMC_DYN_DQS_0_DYN_DQS_MULT_RANGE                        4:0
#define EMC_DYN_DQS_0_DYN_DQS_MULT_WOFFSET                      0x0
#define EMC_DYN_DQS_0_DYN_DQS_MULT_DEFAULT                      _MK_MASK_CONST(0x10)
#define EMC_DYN_DQS_0_DYN_DQS_MULT_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define EMC_DYN_DQS_0_DYN_DQS_MULT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_DYN_DQS_0_DYN_DQS_MULT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define EMC_DYN_DQS_0_DYN_DQS_OFFS_SHIFT                        _MK_SHIFT_CONST(8)
#define EMC_DYN_DQS_0_DYN_DQS_OFFS_FIELD                        (_MK_MASK_CONST(0x7ff) << EMC_DYN_DQS_0_DYN_DQS_OFFS_SHIFT)
#define EMC_DYN_DQS_0_DYN_DQS_OFFS_RANGE                        18:8
#define EMC_DYN_DQS_0_DYN_DQS_OFFS_WOFFSET                      0x0
#define EMC_DYN_DQS_0_DYN_DQS_OFFS_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DYN_DQS_0_DYN_DQS_OFFS_DEFAULT_MASK                 _MK_MASK_CONST(0x7ff)
#define EMC_DYN_DQS_0_DYN_DQS_OFFS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_DYN_DQS_0_DYN_DQS_OFFS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define EMC_DYN_DQS_0_DYN_DQS_MAX_VAL_SHIFT                     _MK_SHIFT_CONST(24)
#define EMC_DYN_DQS_0_DYN_DQS_MAX_VAL_FIELD                     (_MK_MASK_CONST(0xf) << EMC_DYN_DQS_0_DYN_DQS_MAX_VAL_SHIFT)
#define EMC_DYN_DQS_0_DYN_DQS_MAX_VAL_RANGE                     27:24
#define EMC_DYN_DQS_0_DYN_DQS_MAX_VAL_WOFFSET                   0x0
#define EMC_DYN_DQS_0_DYN_DQS_MAX_VAL_DEFAULT                   _MK_MASK_CONST(0x8)
#define EMC_DYN_DQS_0_DYN_DQS_MAX_VAL_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define EMC_DYN_DQS_0_DYN_DQS_MAX_VAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_DYN_DQS_0_DYN_DQS_MAX_VAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_DYN_DQS_0_DYN_DQS_FREEZE_SHIFT                      _MK_SHIFT_CONST(28)
#define EMC_DYN_DQS_0_DYN_DQS_FREEZE_FIELD                      (_MK_MASK_CONST(0x1) << EMC_DYN_DQS_0_DYN_DQS_FREEZE_SHIFT)
#define EMC_DYN_DQS_0_DYN_DQS_FREEZE_RANGE                      28:28
#define EMC_DYN_DQS_0_DYN_DQS_FREEZE_WOFFSET                    0x0
#define EMC_DYN_DQS_0_DYN_DQS_FREEZE_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DYN_DQS_0_DYN_DQS_FREEZE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_DYN_DQS_0_DYN_DQS_FREEZE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_DYN_DQS_0_DYN_DQS_FREEZE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define EMC_DYN_DQS_0_DYN_DQS_ENABLE_SHIFT                      _MK_SHIFT_CONST(31)
#define EMC_DYN_DQS_0_DYN_DQS_ENABLE_FIELD                      (_MK_MASK_CONST(0x1) << EMC_DYN_DQS_0_DYN_DQS_ENABLE_SHIFT)
#define EMC_DYN_DQS_0_DYN_DQS_ENABLE_RANGE                      31:31
#define EMC_DYN_DQS_0_DYN_DQS_ENABLE_WOFFSET                    0x0
#define EMC_DYN_DQS_0_DYN_DQS_ENABLE_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DYN_DQS_0_DYN_DQS_ENABLE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_DYN_DQS_0_DYN_DQS_ENABLE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_DYN_DQS_0_DYN_DQS_ENABLE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_DYN_DQS_0_DYN_DQS_ENABLE_INIT_ENUM                  DISABLED
#define EMC_DYN_DQS_0_DYN_DQS_ENABLE_DISABLED                   _MK_ENUM_CONST(0)
#define EMC_DYN_DQS_0_DYN_DQS_ENABLE_ENABLED                    _MK_ENUM_CONST(1)


// Register EMC_DYN_QUSE_0  
#define EMC_DYN_QUSE_0                  _MK_ADDR_CONST(0x7c)
#define EMC_DYN_QUSE_0_WORD_COUNT                       0x1
#define EMC_DYN_QUSE_0_RESET_VAL                        _MK_MASK_CONST(0x9000008)
#define EMC_DYN_QUSE_0_RESET_MASK                       _MK_MASK_CONST(0x9f07ff1f)
#define EMC_DYN_QUSE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_DYN_QUSE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DYN_QUSE_0_READ_MASK                        _MK_MASK_CONST(0x9f07ff1f)
#define EMC_DYN_QUSE_0_WRITE_MASK                       _MK_MASK_CONST(0x9f07ff1f)
#define EMC_DYN_QUSE_0_DYN_QUSE_MULT_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC_DYN_QUSE_0_DYN_QUSE_MULT_FIELD                      (_MK_MASK_CONST(0x1f) << EMC_DYN_QUSE_0_DYN_QUSE_MULT_SHIFT)
#define EMC_DYN_QUSE_0_DYN_QUSE_MULT_RANGE                      4:0
#define EMC_DYN_QUSE_0_DYN_QUSE_MULT_WOFFSET                    0x0
#define EMC_DYN_QUSE_0_DYN_QUSE_MULT_DEFAULT                    _MK_MASK_CONST(0x8)
#define EMC_DYN_QUSE_0_DYN_QUSE_MULT_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define EMC_DYN_QUSE_0_DYN_QUSE_MULT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_DYN_QUSE_0_DYN_QUSE_MULT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define EMC_DYN_QUSE_0_DYN_QUSE_OFFS_SHIFT                      _MK_SHIFT_CONST(8)
#define EMC_DYN_QUSE_0_DYN_QUSE_OFFS_FIELD                      (_MK_MASK_CONST(0x7ff) << EMC_DYN_QUSE_0_DYN_QUSE_OFFS_SHIFT)
#define EMC_DYN_QUSE_0_DYN_QUSE_OFFS_RANGE                      18:8
#define EMC_DYN_QUSE_0_DYN_QUSE_OFFS_WOFFSET                    0x0
#define EMC_DYN_QUSE_0_DYN_QUSE_OFFS_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DYN_QUSE_0_DYN_QUSE_OFFS_DEFAULT_MASK                       _MK_MASK_CONST(0x7ff)
#define EMC_DYN_QUSE_0_DYN_QUSE_OFFS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_DYN_QUSE_0_DYN_QUSE_OFFS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define EMC_DYN_QUSE_0_DYN_QUSE_MAX_VAL_SHIFT                   _MK_SHIFT_CONST(24)
#define EMC_DYN_QUSE_0_DYN_QUSE_MAX_VAL_FIELD                   (_MK_MASK_CONST(0xf) << EMC_DYN_QUSE_0_DYN_QUSE_MAX_VAL_SHIFT)
#define EMC_DYN_QUSE_0_DYN_QUSE_MAX_VAL_RANGE                   27:24
#define EMC_DYN_QUSE_0_DYN_QUSE_MAX_VAL_WOFFSET                 0x0
#define EMC_DYN_QUSE_0_DYN_QUSE_MAX_VAL_DEFAULT                 _MK_MASK_CONST(0x9)
#define EMC_DYN_QUSE_0_DYN_QUSE_MAX_VAL_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define EMC_DYN_QUSE_0_DYN_QUSE_MAX_VAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DYN_QUSE_0_DYN_QUSE_MAX_VAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_DYN_QUSE_0_DYN_QUSE_FREEZE_SHIFT                    _MK_SHIFT_CONST(28)
#define EMC_DYN_QUSE_0_DYN_QUSE_FREEZE_FIELD                    (_MK_MASK_CONST(0x1) << EMC_DYN_QUSE_0_DYN_QUSE_FREEZE_SHIFT)
#define EMC_DYN_QUSE_0_DYN_QUSE_FREEZE_RANGE                    28:28
#define EMC_DYN_QUSE_0_DYN_QUSE_FREEZE_WOFFSET                  0x0
#define EMC_DYN_QUSE_0_DYN_QUSE_FREEZE_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_DYN_QUSE_0_DYN_QUSE_FREEZE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_DYN_QUSE_0_DYN_QUSE_FREEZE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DYN_QUSE_0_DYN_QUSE_FREEZE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define EMC_DYN_QUSE_0_DYN_QUSE_ENABLE_SHIFT                    _MK_SHIFT_CONST(31)
#define EMC_DYN_QUSE_0_DYN_QUSE_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << EMC_DYN_QUSE_0_DYN_QUSE_ENABLE_SHIFT)
#define EMC_DYN_QUSE_0_DYN_QUSE_ENABLE_RANGE                    31:31
#define EMC_DYN_QUSE_0_DYN_QUSE_ENABLE_WOFFSET                  0x0
#define EMC_DYN_QUSE_0_DYN_QUSE_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_DYN_QUSE_0_DYN_QUSE_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_DYN_QUSE_0_DYN_QUSE_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DYN_QUSE_0_DYN_QUSE_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DYN_QUSE_0_DYN_QUSE_ENABLE_INIT_ENUM                        DISABLED
#define EMC_DYN_QUSE_0_DYN_QUSE_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define EMC_DYN_QUSE_0_DYN_QUSE_ENABLE_ENABLED                  _MK_ENUM_CONST(1)


// Register EMC_DQS_TRIMMER_RD0_0  
#define EMC_DQS_TRIMMER_RD0_0                   _MK_ADDR_CONST(0x80)
#define EMC_DQS_TRIMMER_RD0_0_WORD_COUNT                        0x1
#define EMC_DQS_TRIMMER_RD0_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_READ_MASK                         _MK_MASK_CONST(0xe000ffff)
#define EMC_DQS_TRIMMER_RD0_0_WRITE_MASK                        _MK_MASK_CONST(0xe0000000)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_TRIM_VAL_BYTE_0_SHIFT                    _MK_SHIFT_CONST(0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_TRIM_VAL_BYTE_0_FIELD                    (_MK_MASK_CONST(0xff) << EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_TRIM_VAL_BYTE_0_SHIFT)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_TRIM_VAL_BYTE_0_RANGE                    7:0
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_TRIM_VAL_BYTE_0_WOFFSET                  0x0
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_TRIM_VAL_BYTE_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_TRIM_VAL_BYTE_0_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_TRIM_VAL_BYTE_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_TRIM_VAL_BYTE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_FIELD                 (_MK_MASK_CONST(0xff) << EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_SHIFT)
#define EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_RANGE                 15:8
#define EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_WOFFSET                       0x0
#define EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_NEQ_CURRENT_BYTE_0_SHIFT                 _MK_SHIFT_CONST(29)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_NEQ_CURRENT_BYTE_0_FIELD                 (_MK_MASK_CONST(0x1) << EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_NEQ_CURRENT_BYTE_0_SHIFT)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_NEQ_CURRENT_BYTE_0_RANGE                 29:29
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_NEQ_CURRENT_BYTE_0_WOFFSET                       0x0
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_NEQ_CURRENT_BYTE_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_NEQ_CURRENT_BYTE_0_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_NEQ_CURRENT_BYTE_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_NEQ_CURRENT_BYTE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_EQ_CURRENT_BYTE_0_SHIFT                  _MK_SHIFT_CONST(30)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_EQ_CURRENT_BYTE_0_FIELD                  (_MK_MASK_CONST(0x1) << EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_EQ_CURRENT_BYTE_0_SHIFT)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_EQ_CURRENT_BYTE_0_RANGE                  30:30
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_EQ_CURRENT_BYTE_0_WOFFSET                        0x0
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_EQ_CURRENT_BYTE_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_EQ_CURRENT_BYTE_0_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_EQ_CURRENT_BYTE_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEXT_EQ_CURRENT_BYTE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD0_0_DQS_NEW_CURRENT_VAL_BYTE_0_SHIFT                  _MK_SHIFT_CONST(31)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEW_CURRENT_VAL_BYTE_0_FIELD                  (_MK_MASK_CONST(0x1) << EMC_DQS_TRIMMER_RD0_0_DQS_NEW_CURRENT_VAL_BYTE_0_SHIFT)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEW_CURRENT_VAL_BYTE_0_RANGE                  31:31
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEW_CURRENT_VAL_BYTE_0_WOFFSET                        0x0
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEW_CURRENT_VAL_BYTE_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEW_CURRENT_VAL_BYTE_0_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEW_CURRENT_VAL_BYTE_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_NEW_CURRENT_VAL_BYTE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register EMC_DQS_TRIMMER_RD1_0  
#define EMC_DQS_TRIMMER_RD1_0                   _MK_ADDR_CONST(0x84)
#define EMC_DQS_TRIMMER_RD1_0_WORD_COUNT                        0x1
#define EMC_DQS_TRIMMER_RD1_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_READ_MASK                         _MK_MASK_CONST(0xe000ffff)
#define EMC_DQS_TRIMMER_RD1_0_WRITE_MASK                        _MK_MASK_CONST(0xe0000000)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_TRIM_VAL_BYTE_1_SHIFT                    _MK_SHIFT_CONST(0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_TRIM_VAL_BYTE_1_FIELD                    (_MK_MASK_CONST(0xff) << EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_TRIM_VAL_BYTE_1_SHIFT)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_TRIM_VAL_BYTE_1_RANGE                    7:0
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_TRIM_VAL_BYTE_1_WOFFSET                  0x0
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_TRIM_VAL_BYTE_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_TRIM_VAL_BYTE_1_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_TRIM_VAL_BYTE_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_TRIM_VAL_BYTE_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_FIELD                 (_MK_MASK_CONST(0xff) << EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_SHIFT)
#define EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_RANGE                 15:8
#define EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_WOFFSET                       0x0
#define EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_NEQ_CURRENT_BYTE_1_SHIFT                 _MK_SHIFT_CONST(29)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_NEQ_CURRENT_BYTE_1_FIELD                 (_MK_MASK_CONST(0x1) << EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_NEQ_CURRENT_BYTE_1_SHIFT)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_NEQ_CURRENT_BYTE_1_RANGE                 29:29
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_NEQ_CURRENT_BYTE_1_WOFFSET                       0x0
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_NEQ_CURRENT_BYTE_1_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_NEQ_CURRENT_BYTE_1_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_NEQ_CURRENT_BYTE_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_NEQ_CURRENT_BYTE_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_EQ_CURRENT_BYTE_1_SHIFT                  _MK_SHIFT_CONST(30)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_EQ_CURRENT_BYTE_1_FIELD                  (_MK_MASK_CONST(0x1) << EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_EQ_CURRENT_BYTE_1_SHIFT)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_EQ_CURRENT_BYTE_1_RANGE                  30:30
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_EQ_CURRENT_BYTE_1_WOFFSET                        0x0
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_EQ_CURRENT_BYTE_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_EQ_CURRENT_BYTE_1_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_EQ_CURRENT_BYTE_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEXT_EQ_CURRENT_BYTE_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD1_0_DQS_NEW_CURRENT_VAL_BYTE_1_SHIFT                  _MK_SHIFT_CONST(31)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEW_CURRENT_VAL_BYTE_1_FIELD                  (_MK_MASK_CONST(0x1) << EMC_DQS_TRIMMER_RD1_0_DQS_NEW_CURRENT_VAL_BYTE_1_SHIFT)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEW_CURRENT_VAL_BYTE_1_RANGE                  31:31
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEW_CURRENT_VAL_BYTE_1_WOFFSET                        0x0
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEW_CURRENT_VAL_BYTE_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEW_CURRENT_VAL_BYTE_1_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEW_CURRENT_VAL_BYTE_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_NEW_CURRENT_VAL_BYTE_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register EMC_DQS_TRIMMER_RD2_0  
#define EMC_DQS_TRIMMER_RD2_0                   _MK_ADDR_CONST(0x88)
#define EMC_DQS_TRIMMER_RD2_0_WORD_COUNT                        0x1
#define EMC_DQS_TRIMMER_RD2_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_READ_MASK                         _MK_MASK_CONST(0xe000ffff)
#define EMC_DQS_TRIMMER_RD2_0_WRITE_MASK                        _MK_MASK_CONST(0xe0000000)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_TRIM_VAL_BYTE_2_SHIFT                    _MK_SHIFT_CONST(0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_TRIM_VAL_BYTE_2_FIELD                    (_MK_MASK_CONST(0xff) << EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_TRIM_VAL_BYTE_2_SHIFT)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_TRIM_VAL_BYTE_2_RANGE                    7:0
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_TRIM_VAL_BYTE_2_WOFFSET                  0x0
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_TRIM_VAL_BYTE_2_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_TRIM_VAL_BYTE_2_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_TRIM_VAL_BYTE_2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_TRIM_VAL_BYTE_2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_FIELD                 (_MK_MASK_CONST(0xff) << EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_SHIFT)
#define EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_RANGE                 15:8
#define EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_WOFFSET                       0x0
#define EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_NEQ_CURRENT_BYTE_2_SHIFT                 _MK_SHIFT_CONST(29)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_NEQ_CURRENT_BYTE_2_FIELD                 (_MK_MASK_CONST(0x1) << EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_NEQ_CURRENT_BYTE_2_SHIFT)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_NEQ_CURRENT_BYTE_2_RANGE                 29:29
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_NEQ_CURRENT_BYTE_2_WOFFSET                       0x0
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_NEQ_CURRENT_BYTE_2_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_NEQ_CURRENT_BYTE_2_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_NEQ_CURRENT_BYTE_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_NEQ_CURRENT_BYTE_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_EQ_CURRENT_BYTE_2_SHIFT                  _MK_SHIFT_CONST(30)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_EQ_CURRENT_BYTE_2_FIELD                  (_MK_MASK_CONST(0x1) << EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_EQ_CURRENT_BYTE_2_SHIFT)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_EQ_CURRENT_BYTE_2_RANGE                  30:30
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_EQ_CURRENT_BYTE_2_WOFFSET                        0x0
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_EQ_CURRENT_BYTE_2_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_EQ_CURRENT_BYTE_2_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_EQ_CURRENT_BYTE_2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEXT_EQ_CURRENT_BYTE_2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD2_0_DQS_NEW_CURRENT_VAL_BYTE_2_SHIFT                  _MK_SHIFT_CONST(31)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEW_CURRENT_VAL_BYTE_2_FIELD                  (_MK_MASK_CONST(0x1) << EMC_DQS_TRIMMER_RD2_0_DQS_NEW_CURRENT_VAL_BYTE_2_SHIFT)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEW_CURRENT_VAL_BYTE_2_RANGE                  31:31
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEW_CURRENT_VAL_BYTE_2_WOFFSET                        0x0
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEW_CURRENT_VAL_BYTE_2_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEW_CURRENT_VAL_BYTE_2_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEW_CURRENT_VAL_BYTE_2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_NEW_CURRENT_VAL_BYTE_2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register EMC_DQS_TRIMMER_RD3_0  
#define EMC_DQS_TRIMMER_RD3_0                   _MK_ADDR_CONST(0x8c)
#define EMC_DQS_TRIMMER_RD3_0_WORD_COUNT                        0x1
#define EMC_DQS_TRIMMER_RD3_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_READ_MASK                         _MK_MASK_CONST(0xe000ffff)
#define EMC_DQS_TRIMMER_RD3_0_WRITE_MASK                        _MK_MASK_CONST(0xe0000000)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_TRIM_VAL_BYTE_3_SHIFT                    _MK_SHIFT_CONST(0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_TRIM_VAL_BYTE_3_FIELD                    (_MK_MASK_CONST(0xff) << EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_TRIM_VAL_BYTE_3_SHIFT)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_TRIM_VAL_BYTE_3_RANGE                    7:0
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_TRIM_VAL_BYTE_3_WOFFSET                  0x0
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_TRIM_VAL_BYTE_3_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_TRIM_VAL_BYTE_3_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_TRIM_VAL_BYTE_3_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_TRIM_VAL_BYTE_3_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_FIELD                 (_MK_MASK_CONST(0xff) << EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_SHIFT)
#define EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_RANGE                 15:8
#define EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_WOFFSET                       0x0
#define EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_NEQ_CURRENT_BYTE_3_SHIFT                 _MK_SHIFT_CONST(29)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_NEQ_CURRENT_BYTE_3_FIELD                 (_MK_MASK_CONST(0x1) << EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_NEQ_CURRENT_BYTE_3_SHIFT)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_NEQ_CURRENT_BYTE_3_RANGE                 29:29
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_NEQ_CURRENT_BYTE_3_WOFFSET                       0x0
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_NEQ_CURRENT_BYTE_3_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_NEQ_CURRENT_BYTE_3_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_NEQ_CURRENT_BYTE_3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_NEQ_CURRENT_BYTE_3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_EQ_CURRENT_BYTE_3_SHIFT                  _MK_SHIFT_CONST(30)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_EQ_CURRENT_BYTE_3_FIELD                  (_MK_MASK_CONST(0x1) << EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_EQ_CURRENT_BYTE_3_SHIFT)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_EQ_CURRENT_BYTE_3_RANGE                  30:30
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_EQ_CURRENT_BYTE_3_WOFFSET                        0x0
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_EQ_CURRENT_BYTE_3_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_EQ_CURRENT_BYTE_3_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_EQ_CURRENT_BYTE_3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEXT_EQ_CURRENT_BYTE_3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD3_0_DQS_NEW_CURRENT_VAL_BYTE_3_SHIFT                  _MK_SHIFT_CONST(31)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEW_CURRENT_VAL_BYTE_3_FIELD                  (_MK_MASK_CONST(0x1) << EMC_DQS_TRIMMER_RD3_0_DQS_NEW_CURRENT_VAL_BYTE_3_SHIFT)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEW_CURRENT_VAL_BYTE_3_RANGE                  31:31
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEW_CURRENT_VAL_BYTE_3_WOFFSET                        0x0
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEW_CURRENT_VAL_BYTE_3_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEW_CURRENT_VAL_BYTE_3_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEW_CURRENT_VAL_BYTE_3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_NEW_CURRENT_VAL_BYTE_3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register EMC_QUSE_TRIMMER_RD0_0  
#define EMC_QUSE_TRIMMER_RD0_0                  _MK_ADDR_CONST(0x90)
#define EMC_QUSE_TRIMMER_RD0_0_WORD_COUNT                       0x1
#define EMC_QUSE_TRIMMER_RD0_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_READ_MASK                        _MK_MASK_CONST(0xe000ffff)
#define EMC_QUSE_TRIMMER_RD0_0_WRITE_MASK                       _MK_MASK_CONST(0xe0000000)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_TRIM_VAL_BYTE_0_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_TRIM_VAL_BYTE_0_FIELD                  (_MK_MASK_CONST(0xff) << EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_TRIM_VAL_BYTE_0_SHIFT)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_TRIM_VAL_BYTE_0_RANGE                  7:0
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_TRIM_VAL_BYTE_0_WOFFSET                        0x0
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_TRIM_VAL_BYTE_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_TRIM_VAL_BYTE_0_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_TRIM_VAL_BYTE_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_TRIM_VAL_BYTE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define EMC_QUSE_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_SHIFT                       _MK_SHIFT_CONST(8)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_FIELD                       (_MK_MASK_CONST(0xff) << EMC_QUSE_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_SHIFT)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_RANGE                       15:8
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_WOFFSET                     0x0
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_NEQ_CURRENT_BYTE_0_SHIFT                       _MK_SHIFT_CONST(29)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_NEQ_CURRENT_BYTE_0_FIELD                       (_MK_MASK_CONST(0x1) << EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_NEQ_CURRENT_BYTE_0_SHIFT)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_NEQ_CURRENT_BYTE_0_RANGE                       29:29
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_NEQ_CURRENT_BYTE_0_WOFFSET                     0x0
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_NEQ_CURRENT_BYTE_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_NEQ_CURRENT_BYTE_0_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_NEQ_CURRENT_BYTE_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_NEQ_CURRENT_BYTE_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_EQ_CURRENT_BYTE_0_SHIFT                        _MK_SHIFT_CONST(30)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_EQ_CURRENT_BYTE_0_FIELD                        (_MK_MASK_CONST(0x1) << EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_EQ_CURRENT_BYTE_0_SHIFT)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_EQ_CURRENT_BYTE_0_RANGE                        30:30
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_EQ_CURRENT_BYTE_0_WOFFSET                      0x0
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_EQ_CURRENT_BYTE_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_EQ_CURRENT_BYTE_0_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_EQ_CURRENT_BYTE_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEXT_EQ_CURRENT_BYTE_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEW_CURRENT_VAL_BYTE_0_SHIFT                        _MK_SHIFT_CONST(31)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEW_CURRENT_VAL_BYTE_0_FIELD                        (_MK_MASK_CONST(0x1) << EMC_QUSE_TRIMMER_RD0_0_QUSE_NEW_CURRENT_VAL_BYTE_0_SHIFT)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEW_CURRENT_VAL_BYTE_0_RANGE                        31:31
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEW_CURRENT_VAL_BYTE_0_WOFFSET                      0x0
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEW_CURRENT_VAL_BYTE_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEW_CURRENT_VAL_BYTE_0_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEW_CURRENT_VAL_BYTE_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD0_0_QUSE_NEW_CURRENT_VAL_BYTE_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register EMC_QUSE_TRIMMER_RD1_0  
#define EMC_QUSE_TRIMMER_RD1_0                  _MK_ADDR_CONST(0x94)
#define EMC_QUSE_TRIMMER_RD1_0_WORD_COUNT                       0x1
#define EMC_QUSE_TRIMMER_RD1_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_READ_MASK                        _MK_MASK_CONST(0xe000ffff)
#define EMC_QUSE_TRIMMER_RD1_0_WRITE_MASK                       _MK_MASK_CONST(0xe0000000)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_TRIM_VAL_BYTE_1_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_TRIM_VAL_BYTE_1_FIELD                  (_MK_MASK_CONST(0xff) << EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_TRIM_VAL_BYTE_1_SHIFT)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_TRIM_VAL_BYTE_1_RANGE                  7:0
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_TRIM_VAL_BYTE_1_WOFFSET                        0x0
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_TRIM_VAL_BYTE_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_TRIM_VAL_BYTE_1_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_TRIM_VAL_BYTE_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_TRIM_VAL_BYTE_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define EMC_QUSE_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_SHIFT                       _MK_SHIFT_CONST(8)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_FIELD                       (_MK_MASK_CONST(0xff) << EMC_QUSE_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_SHIFT)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_RANGE                       15:8
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_WOFFSET                     0x0
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_NEQ_CURRENT_BYTE_1_SHIFT                       _MK_SHIFT_CONST(29)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_NEQ_CURRENT_BYTE_1_FIELD                       (_MK_MASK_CONST(0x1) << EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_NEQ_CURRENT_BYTE_1_SHIFT)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_NEQ_CURRENT_BYTE_1_RANGE                       29:29
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_NEQ_CURRENT_BYTE_1_WOFFSET                     0x0
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_NEQ_CURRENT_BYTE_1_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_NEQ_CURRENT_BYTE_1_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_NEQ_CURRENT_BYTE_1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_NEQ_CURRENT_BYTE_1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_EQ_CURRENT_BYTE_1_SHIFT                        _MK_SHIFT_CONST(30)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_EQ_CURRENT_BYTE_1_FIELD                        (_MK_MASK_CONST(0x1) << EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_EQ_CURRENT_BYTE_1_SHIFT)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_EQ_CURRENT_BYTE_1_RANGE                        30:30
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_EQ_CURRENT_BYTE_1_WOFFSET                      0x0
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_EQ_CURRENT_BYTE_1_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_EQ_CURRENT_BYTE_1_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_EQ_CURRENT_BYTE_1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEXT_EQ_CURRENT_BYTE_1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEW_CURRENT_VAL_BYTE_1_SHIFT                        _MK_SHIFT_CONST(31)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEW_CURRENT_VAL_BYTE_1_FIELD                        (_MK_MASK_CONST(0x1) << EMC_QUSE_TRIMMER_RD1_0_QUSE_NEW_CURRENT_VAL_BYTE_1_SHIFT)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEW_CURRENT_VAL_BYTE_1_RANGE                        31:31
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEW_CURRENT_VAL_BYTE_1_WOFFSET                      0x0
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEW_CURRENT_VAL_BYTE_1_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEW_CURRENT_VAL_BYTE_1_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEW_CURRENT_VAL_BYTE_1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD1_0_QUSE_NEW_CURRENT_VAL_BYTE_1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register EMC_QUSE_TRIMMER_RD2_0  
#define EMC_QUSE_TRIMMER_RD2_0                  _MK_ADDR_CONST(0x98)
#define EMC_QUSE_TRIMMER_RD2_0_WORD_COUNT                       0x1
#define EMC_QUSE_TRIMMER_RD2_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_READ_MASK                        _MK_MASK_CONST(0xe000ffff)
#define EMC_QUSE_TRIMMER_RD2_0_WRITE_MASK                       _MK_MASK_CONST(0xe0000000)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_TRIM_VAL_BYTE_2_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_TRIM_VAL_BYTE_2_FIELD                  (_MK_MASK_CONST(0xff) << EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_TRIM_VAL_BYTE_2_SHIFT)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_TRIM_VAL_BYTE_2_RANGE                  7:0
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_TRIM_VAL_BYTE_2_WOFFSET                        0x0
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_TRIM_VAL_BYTE_2_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_TRIM_VAL_BYTE_2_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_TRIM_VAL_BYTE_2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_TRIM_VAL_BYTE_2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define EMC_QUSE_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_SHIFT                       _MK_SHIFT_CONST(8)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_FIELD                       (_MK_MASK_CONST(0xff) << EMC_QUSE_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_SHIFT)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_RANGE                       15:8
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_WOFFSET                     0x0
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_NEQ_CURRENT_BYTE_2_SHIFT                       _MK_SHIFT_CONST(29)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_NEQ_CURRENT_BYTE_2_FIELD                       (_MK_MASK_CONST(0x1) << EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_NEQ_CURRENT_BYTE_2_SHIFT)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_NEQ_CURRENT_BYTE_2_RANGE                       29:29
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_NEQ_CURRENT_BYTE_2_WOFFSET                     0x0
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_NEQ_CURRENT_BYTE_2_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_NEQ_CURRENT_BYTE_2_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_NEQ_CURRENT_BYTE_2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_NEQ_CURRENT_BYTE_2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_EQ_CURRENT_BYTE_2_SHIFT                        _MK_SHIFT_CONST(30)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_EQ_CURRENT_BYTE_2_FIELD                        (_MK_MASK_CONST(0x1) << EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_EQ_CURRENT_BYTE_2_SHIFT)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_EQ_CURRENT_BYTE_2_RANGE                        30:30
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_EQ_CURRENT_BYTE_2_WOFFSET                      0x0
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_EQ_CURRENT_BYTE_2_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_EQ_CURRENT_BYTE_2_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_EQ_CURRENT_BYTE_2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEXT_EQ_CURRENT_BYTE_2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEW_CURRENT_VAL_BYTE_2_SHIFT                        _MK_SHIFT_CONST(31)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEW_CURRENT_VAL_BYTE_2_FIELD                        (_MK_MASK_CONST(0x1) << EMC_QUSE_TRIMMER_RD2_0_QUSE_NEW_CURRENT_VAL_BYTE_2_SHIFT)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEW_CURRENT_VAL_BYTE_2_RANGE                        31:31
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEW_CURRENT_VAL_BYTE_2_WOFFSET                      0x0
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEW_CURRENT_VAL_BYTE_2_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEW_CURRENT_VAL_BYTE_2_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEW_CURRENT_VAL_BYTE_2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD2_0_QUSE_NEW_CURRENT_VAL_BYTE_2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register EMC_QUSE_TRIMMER_RD3_0  
#define EMC_QUSE_TRIMMER_RD3_0                  _MK_ADDR_CONST(0x9c)
#define EMC_QUSE_TRIMMER_RD3_0_WORD_COUNT                       0x1
#define EMC_QUSE_TRIMMER_RD3_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_READ_MASK                        _MK_MASK_CONST(0xe000ffff)
#define EMC_QUSE_TRIMMER_RD3_0_WRITE_MASK                       _MK_MASK_CONST(0xe0000000)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_TRIM_VAL_BYTE_3_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_TRIM_VAL_BYTE_3_FIELD                  (_MK_MASK_CONST(0xff) << EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_TRIM_VAL_BYTE_3_SHIFT)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_TRIM_VAL_BYTE_3_RANGE                  7:0
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_TRIM_VAL_BYTE_3_WOFFSET                        0x0
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_TRIM_VAL_BYTE_3_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_TRIM_VAL_BYTE_3_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_TRIM_VAL_BYTE_3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_TRIM_VAL_BYTE_3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define EMC_QUSE_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_SHIFT                       _MK_SHIFT_CONST(8)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_FIELD                       (_MK_MASK_CONST(0xff) << EMC_QUSE_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_SHIFT)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_RANGE                       15:8
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_WOFFSET                     0x0
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_NEQ_CURRENT_BYTE_3_SHIFT                       _MK_SHIFT_CONST(29)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_NEQ_CURRENT_BYTE_3_FIELD                       (_MK_MASK_CONST(0x1) << EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_NEQ_CURRENT_BYTE_3_SHIFT)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_NEQ_CURRENT_BYTE_3_RANGE                       29:29
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_NEQ_CURRENT_BYTE_3_WOFFSET                     0x0
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_NEQ_CURRENT_BYTE_3_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_NEQ_CURRENT_BYTE_3_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_NEQ_CURRENT_BYTE_3_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_NEQ_CURRENT_BYTE_3_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_EQ_CURRENT_BYTE_3_SHIFT                        _MK_SHIFT_CONST(30)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_EQ_CURRENT_BYTE_3_FIELD                        (_MK_MASK_CONST(0x1) << EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_EQ_CURRENT_BYTE_3_SHIFT)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_EQ_CURRENT_BYTE_3_RANGE                        30:30
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_EQ_CURRENT_BYTE_3_WOFFSET                      0x0
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_EQ_CURRENT_BYTE_3_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_EQ_CURRENT_BYTE_3_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_EQ_CURRENT_BYTE_3_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEXT_EQ_CURRENT_BYTE_3_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEW_CURRENT_VAL_BYTE_3_SHIFT                        _MK_SHIFT_CONST(31)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEW_CURRENT_VAL_BYTE_3_FIELD                        (_MK_MASK_CONST(0x1) << EMC_QUSE_TRIMMER_RD3_0_QUSE_NEW_CURRENT_VAL_BYTE_3_SHIFT)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEW_CURRENT_VAL_BYTE_3_RANGE                        31:31
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEW_CURRENT_VAL_BYTE_3_WOFFSET                      0x0
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEW_CURRENT_VAL_BYTE_3_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEW_CURRENT_VAL_BYTE_3_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEW_CURRENT_VAL_BYTE_3_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_QUSE_TRIMMER_RD3_0_QUSE_NEW_CURRENT_VAL_BYTE_3_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register EMC_CLKEN_OVERRIDE_0  
#define EMC_CLKEN_OVERRIDE_0                    _MK_ADDR_CONST(0xa0)
#define EMC_CLKEN_OVERRIDE_0_WORD_COUNT                         0x1
#define EMC_CLKEN_OVERRIDE_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_RESET_MASK                         _MK_MASK_CONST(0x3f)
#define EMC_CLKEN_OVERRIDE_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_READ_MASK                  _MK_MASK_CONST(0x3f)
#define EMC_CLKEN_OVERRIDE_0_WRITE_MASK                         _MK_MASK_CONST(0x3f)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_FIELD                        (_MK_MASK_CONST(0x1) << EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_SHIFT)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_RANGE                        0:0
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_WOFFSET                      0x0
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_INIT_ENUM                    CLK_GATED
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_CLK_GATED                    _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_CLK_ALWAYS_ON                        _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_DISABLE                      _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_ENABLE                       _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_DISABLED                     _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_ENABLED                      _MK_ENUM_CONST(1)

#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_SHIFT                       _MK_SHIFT_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_FIELD                       (_MK_MASK_CONST(0x1) << EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_SHIFT)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_RANGE                       1:1
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_WOFFSET                     0x0
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_INIT_ENUM                   CLK_GATED
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_CLK_GATED                   _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_CLK_ALWAYS_ON                       _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_DISABLE                     _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_ENABLE                      _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_DISABLED                    _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_ENABLED                     _MK_ENUM_CONST(1)

#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_SHIFT                      _MK_SHIFT_CONST(2)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_FIELD                      (_MK_MASK_CONST(0x1) << EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_SHIFT)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_RANGE                      2:2
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_WOFFSET                    0x0
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_INIT_ENUM                  CLK_GATED
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_CLK_GATED                  _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_CLK_ALWAYS_ON                      _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_DISABLE                    _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_ENABLE                     _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_DISABLED                   _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_ENABLED                    _MK_ENUM_CONST(1)

#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_SHIFT                 _MK_SHIFT_CONST(3)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_FIELD                 (_MK_MASK_CONST(0x1) << EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_SHIFT)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_RANGE                 3:3
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_WOFFSET                       0x0
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_INIT_ENUM                     CLK_GATED
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_CLK_GATED                     _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_CLK_ALWAYS_ON                 _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_DISABLE                       _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_ENABLE                        _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_DISABLED                      _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_ENABLED                       _MK_ENUM_CONST(1)

#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_SHIFT                 _MK_SHIFT_CONST(4)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_FIELD                 (_MK_MASK_CONST(0x1) << EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_SHIFT)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_RANGE                 4:4
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_WOFFSET                       0x0
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_INIT_ENUM                     CLK_GATED
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_CLK_GATED                     _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_CLK_ALWAYS_ON                 _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_DISABLE                       _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_ENABLE                        _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_DISABLED                      _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_ENABLED                       _MK_ENUM_CONST(1)

#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_SHIFT                      _MK_SHIFT_CONST(5)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_FIELD                      (_MK_MASK_CONST(0x1) << EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_SHIFT)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_RANGE                      5:5
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_WOFFSET                    0x0
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_INIT_ENUM                  CLK_GATED
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_CLK_GATED                  _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_CLK_ALWAYS_ON                      _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_DISABLE                    _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_ENABLE                     _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_DISABLED                   _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_ENABLED                    _MK_ENUM_CONST(1)

#define NV_MC_EMEM_DFIFO_DEPTH  3
#define NV_MC_IMEM_DFIFO_DEPTH  5
#define NV_MC_EMEM_APFIFO_DEPTH 4
#define NV_MC_ARB_EMEM_REGLEVEL 3
#define NV_MC_EMEM_REQ_ID_WIDEREQ       9
#define NV_MC_EMEM_RDI_ID_WIDERDI       9
#define NV_MC_EMEM_REQ_ID_ILLEGALACC    8
#define NV_MC_EMEM_RDI_ID_ILLEGALACC    8
#define NV_MC_EMEM_REQ_ID_LLRAWDECR     7
#define NV_MC_EMEM_RDI_ID_LLRAWDECR     7
#define NV_MC_EMEM_REQ_ID_APCIGNORE     6
#define NV_MC_EMEM_RDI_ID_APCIGNORE     6

// Packet MC2EMC
#define MC2EMC_SIZE 190

#define MC2EMC_WDO_SHIFT                        _MK_SHIFT_CONST(0)
#define MC2EMC_WDO_FIELD                        (_MK_MASK_CONST(0xffffffff) << MC2EMC_WDO_SHIFT)
#define MC2EMC_WDO_RANGE                        _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(0)
#define MC2EMC_WDO_ROW                  0

#define MC2EMC_WDO_0_SHIFT                      _MK_SHIFT_CONST(0)
#define MC2EMC_WDO_0_FIELD                      (_MK_MASK_CONST(0xffffffff) << MC2EMC_WDO_0_SHIFT)
#define MC2EMC_WDO_0_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define MC2EMC_WDO_0_ROW                        0

#define MC2EMC_WDO_1_SHIFT                      _MK_SHIFT_CONST(32)
#define MC2EMC_WDO_1_FIELD                      (_MK_MASK_CONST(0xffffffff) << MC2EMC_WDO_1_SHIFT)
#define MC2EMC_WDO_1_RANGE                      _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define MC2EMC_WDO_1_ROW                        0

#define MC2EMC_WDO_2_SHIFT                      _MK_SHIFT_CONST(64)
#define MC2EMC_WDO_2_FIELD                      (_MK_MASK_CONST(0xffffffff) << MC2EMC_WDO_2_SHIFT)
#define MC2EMC_WDO_2_RANGE                      _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define MC2EMC_WDO_2_ROW                        0

#define MC2EMC_WDO_3_SHIFT                      _MK_SHIFT_CONST(96)
#define MC2EMC_WDO_3_FIELD                      (_MK_MASK_CONST(0xffffffff) << MC2EMC_WDO_3_SHIFT)
#define MC2EMC_WDO_3_RANGE                      _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(96)
#define MC2EMC_WDO_3_ROW                        0

#define MC2EMC_BE_SHIFT                 _MK_SHIFT_CONST(128)
#define MC2EMC_BE_FIELD                 (_MK_MASK_CONST(0xffff) << MC2EMC_BE_SHIFT)
#define MC2EMC_BE_RANGE                 _MK_SHIFT_CONST(143):_MK_SHIFT_CONST(128)
#define MC2EMC_BE_ROW                   0

#define MC2EMC_DEV_SHIFT                        _MK_SHIFT_CONST(144)
#define MC2EMC_DEV_FIELD                        (_MK_MASK_CONST(0x3) << MC2EMC_DEV_SHIFT)
#define MC2EMC_DEV_RANGE                        _MK_SHIFT_CONST(145):_MK_SHIFT_CONST(144)
#define MC2EMC_DEV_ROW                  0

#define MC2EMC_BANK_SHIFT                       _MK_SHIFT_CONST(146)
#define MC2EMC_BANK_FIELD                       (_MK_MASK_CONST(0x3) << MC2EMC_BANK_SHIFT)
#define MC2EMC_BANK_RANGE                       _MK_SHIFT_CONST(147):_MK_SHIFT_CONST(146)
#define MC2EMC_BANK_ROW                 0

#define MC2EMC_ROW_SHIFT                        _MK_SHIFT_CONST(148)
#define MC2EMC_ROW_FIELD                        (_MK_MASK_CONST(0x3fff) << MC2EMC_ROW_SHIFT)
#define MC2EMC_ROW_RANGE                        _MK_SHIFT_CONST(161):_MK_SHIFT_CONST(148)
#define MC2EMC_ROW_ROW                  0

#define MC2EMC_COL_SHIFT                        _MK_SHIFT_CONST(162)
#define MC2EMC_COL_FIELD                        (_MK_MASK_CONST(0x7ff) << MC2EMC_COL_SHIFT)
#define MC2EMC_COL_RANGE                        _MK_SHIFT_CONST(172):_MK_SHIFT_CONST(162)
#define MC2EMC_COL_ROW                  0

#define MC2EMC_REQ_ID_SHIFT                     _MK_SHIFT_CONST(173)
#define MC2EMC_REQ_ID_FIELD                     (_MK_MASK_CONST(0x3ff) << MC2EMC_REQ_ID_SHIFT)
#define MC2EMC_REQ_ID_RANGE                     _MK_SHIFT_CONST(182):_MK_SHIFT_CONST(173)
#define MC2EMC_REQ_ID_ROW                       0

#define MC2EMC_AP_SHIFT                 _MK_SHIFT_CONST(183)
#define MC2EMC_AP_FIELD                 (_MK_MASK_CONST(0x1) << MC2EMC_AP_SHIFT)
#define MC2EMC_AP_RANGE                 _MK_SHIFT_CONST(183):_MK_SHIFT_CONST(183)
#define MC2EMC_AP_ROW                   0

#define MC2EMC_WE_SHIFT                 _MK_SHIFT_CONST(184)
#define MC2EMC_WE_FIELD                 (_MK_MASK_CONST(0x1) << MC2EMC_WE_SHIFT)
#define MC2EMC_WE_RANGE                 _MK_SHIFT_CONST(184):_MK_SHIFT_CONST(184)
#define MC2EMC_WE_ROW                   0

#define MC2EMC_TAG_SHIFT                        _MK_SHIFT_CONST(185)
#define MC2EMC_TAG_FIELD                        (_MK_MASK_CONST(0x1f) << MC2EMC_TAG_SHIFT)
#define MC2EMC_TAG_RANGE                        _MK_SHIFT_CONST(189):_MK_SHIFT_CONST(185)
#define MC2EMC_TAG_ROW                  0


// Packet MC2EMC_APC
#define MC2EMC_APC_SIZE 3

#define MC2EMC_APC_CLR_SHIFT                    _MK_SHIFT_CONST(0)
#define MC2EMC_APC_CLR_FIELD                    (_MK_MASK_CONST(0x1) << MC2EMC_APC_CLR_SHIFT)
#define MC2EMC_APC_CLR_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define MC2EMC_APC_CLR_ROW                      0

#define MC2EMC_APC_BANK_SHIFT                   _MK_SHIFT_CONST(1)
#define MC2EMC_APC_BANK_FIELD                   (_MK_MASK_CONST(0x3) << MC2EMC_APC_BANK_SHIFT)
#define MC2EMC_APC_BANK_RANGE                   _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(1)
#define MC2EMC_APC_BANK_ROW                     0


// Packet EMC2MC
#define EMC2MC_SIZE 138

#define EMC2MC_RDI_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC2MC_RDI_FIELD                        (_MK_MASK_CONST(0xffffffff) << EMC2MC_RDI_SHIFT)
#define EMC2MC_RDI_RANGE                        _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(0)
#define EMC2MC_RDI_ROW                  0

#define EMC2MC_RDI_0_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC2MC_RDI_0_FIELD                      (_MK_MASK_CONST(0xffffffff) << EMC2MC_RDI_0_SHIFT)
#define EMC2MC_RDI_0_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define EMC2MC_RDI_0_ROW                        0

#define EMC2MC_RDI_1_SHIFT                      _MK_SHIFT_CONST(32)
#define EMC2MC_RDI_1_FIELD                      (_MK_MASK_CONST(0xffffffff) << EMC2MC_RDI_1_SHIFT)
#define EMC2MC_RDI_1_RANGE                      _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define EMC2MC_RDI_1_ROW                        0

#define EMC2MC_RDI_2_SHIFT                      _MK_SHIFT_CONST(64)
#define EMC2MC_RDI_2_FIELD                      (_MK_MASK_CONST(0xffffffff) << EMC2MC_RDI_2_SHIFT)
#define EMC2MC_RDI_2_RANGE                      _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define EMC2MC_RDI_2_ROW                        0

#define EMC2MC_RDI_3_SHIFT                      _MK_SHIFT_CONST(96)
#define EMC2MC_RDI_3_FIELD                      (_MK_MASK_CONST(0xffffffff) << EMC2MC_RDI_3_SHIFT)
#define EMC2MC_RDI_3_RANGE                      _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(96)
#define EMC2MC_RDI_3_ROW                        0

#define EMC2MC_RDI_ID_SHIFT                     _MK_SHIFT_CONST(128)
#define EMC2MC_RDI_ID_FIELD                     (_MK_MASK_CONST(0x3ff) << EMC2MC_RDI_ID_SHIFT)
#define EMC2MC_RDI_ID_RANGE                     _MK_SHIFT_CONST(137):_MK_SHIFT_CONST(128)
#define EMC2MC_RDI_ID_ROW                       0


// Packet MC2EMC_LL
#define MC2EMC_LL_SIZE 35

#define MC2EMC_LL_DEV_SHIFT                     _MK_SHIFT_CONST(0)
#define MC2EMC_LL_DEV_FIELD                     (_MK_MASK_CONST(0x3) << MC2EMC_LL_DEV_SHIFT)
#define MC2EMC_LL_DEV_RANGE                     _MK_SHIFT_CONST(1):_MK_SHIFT_CONST(0)
#define MC2EMC_LL_DEV_ROW                       0

#define MC2EMC_LL_BANK_SHIFT                    _MK_SHIFT_CONST(2)
#define MC2EMC_LL_BANK_FIELD                    (_MK_MASK_CONST(0x3) << MC2EMC_LL_BANK_SHIFT)
#define MC2EMC_LL_BANK_RANGE                    _MK_SHIFT_CONST(3):_MK_SHIFT_CONST(2)
#define MC2EMC_LL_BANK_ROW                      0

#define MC2EMC_LL_ROW_SHIFT                     _MK_SHIFT_CONST(4)
#define MC2EMC_LL_ROW_FIELD                     (_MK_MASK_CONST(0x3fff) << MC2EMC_LL_ROW_SHIFT)
#define MC2EMC_LL_ROW_RANGE                     _MK_SHIFT_CONST(17):_MK_SHIFT_CONST(4)
#define MC2EMC_LL_ROW_ROW                       0

#define MC2EMC_LL_COL_SHIFT                     _MK_SHIFT_CONST(18)
#define MC2EMC_LL_COL_FIELD                     (_MK_MASK_CONST(0x7ff) << MC2EMC_LL_COL_SHIFT)
#define MC2EMC_LL_COL_RANGE                     _MK_SHIFT_CONST(28):_MK_SHIFT_CONST(18)
#define MC2EMC_LL_COL_ROW                       0

#define MC2EMC_LL_TAG_SHIFT                     _MK_SHIFT_CONST(29)
#define MC2EMC_LL_TAG_FIELD                     (_MK_MASK_CONST(0x1f) << MC2EMC_LL_TAG_SHIFT)
#define MC2EMC_LL_TAG_RANGE                     _MK_SHIFT_CONST(33):_MK_SHIFT_CONST(29)
#define MC2EMC_LL_TAG_ROW                       0

#define MC2EMC_LL_DOUBLEREQ_SHIFT                       _MK_SHIFT_CONST(34)
#define MC2EMC_LL_DOUBLEREQ_FIELD                       (_MK_MASK_CONST(0x1) << MC2EMC_LL_DOUBLEREQ_SHIFT)
#define MC2EMC_LL_DOUBLEREQ_RANGE                       _MK_SHIFT_CONST(34):_MK_SHIFT_CONST(34)
#define MC2EMC_LL_DOUBLEREQ_ROW                 0


// Packet EMC2MC_LL
#define EMC2MC_LL_SIZE 64

#define EMC2MC_LL_RDI_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC2MC_LL_RDI_FIELD                     (_MK_MASK_CONST(0xffffffff) << EMC2MC_LL_RDI_SHIFT)
#define EMC2MC_LL_RDI_RANGE                     _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define EMC2MC_LL_RDI_ROW                       0


// Packet MC2EMC_LL_CRITINFO
#define MC2EMC_LL_CRITINFO_SIZE 11

#define MC2EMC_LL_CRITINFO_HP_SHIFT                     _MK_SHIFT_CONST(0)
#define MC2EMC_LL_CRITINFO_HP_FIELD                     (_MK_MASK_CONST(0x1f) << MC2EMC_LL_CRITINFO_HP_SHIFT)
#define MC2EMC_LL_CRITINFO_HP_RANGE                     _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(0)
#define MC2EMC_LL_CRITINFO_HP_ROW                       0

#define MC2EMC_LL_CRITINFO_TIMEOUT_SHIFT                        _MK_SHIFT_CONST(5)
#define MC2EMC_LL_CRITINFO_TIMEOUT_FIELD                        (_MK_MASK_CONST(0x3f) << MC2EMC_LL_CRITINFO_TIMEOUT_SHIFT)
#define MC2EMC_LL_CRITINFO_TIMEOUT_RANGE                        _MK_SHIFT_CONST(10):_MK_SHIFT_CONST(5)
#define MC2EMC_LL_CRITINFO_TIMEOUT_ROW                  0


// Packet MC2EMC_LL_ARBINFO
#define MC2EMC_LL_ARBINFO_SIZE 2

#define MC2EMC_LL_ARBINFO_BANK_SHIFT                    _MK_SHIFT_CONST(0)
#define MC2EMC_LL_ARBINFO_BANK_FIELD                    (_MK_MASK_CONST(0x3) << MC2EMC_LL_ARBINFO_BANK_SHIFT)
#define MC2EMC_LL_ARBINFO_BANK_RANGE                    _MK_SHIFT_CONST(1):_MK_SHIFT_CONST(0)
#define MC2EMC_LL_ARBINFO_BANK_ROW                      0


// Packet CMC2MC_AXI_A
#define CMC2MC_AXI_A_SIZE 58

#define CMC2MC_AXI_A_AADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define CMC2MC_AXI_A_AADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << CMC2MC_AXI_A_AADDR_SHIFT)
#define CMC2MC_AXI_A_AADDR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CMC2MC_AXI_A_AADDR_ROW                  0

#define CMC2MC_AXI_A_AID_SHIFT                  _MK_SHIFT_CONST(32)
#define CMC2MC_AXI_A_AID_FIELD                  (_MK_MASK_CONST(0xff) << CMC2MC_AXI_A_AID_SHIFT)
#define CMC2MC_AXI_A_AID_RANGE                  _MK_SHIFT_CONST(39):_MK_SHIFT_CONST(32)
#define CMC2MC_AXI_A_AID_ROW                    0

#define CMC2MC_AXI_A_ALEN_SHIFT                 _MK_SHIFT_CONST(40)
#define CMC2MC_AXI_A_ALEN_FIELD                 (_MK_MASK_CONST(0xf) << CMC2MC_AXI_A_ALEN_SHIFT)
#define CMC2MC_AXI_A_ALEN_RANGE                 _MK_SHIFT_CONST(43):_MK_SHIFT_CONST(40)
#define CMC2MC_AXI_A_ALEN_ROW                   0
#define CMC2MC_AXI_A_ALEN_ONEDATA                       _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_ALEN_TWODATA                       _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_ALEN_THREEDATA                     _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_ALEN_FOURDATA                      _MK_ENUM_CONST(3)
#define CMC2MC_AXI_A_ALEN_FIVEDATA                      _MK_ENUM_CONST(4)
#define CMC2MC_AXI_A_ALEN_SIXDATA                       _MK_ENUM_CONST(5)
#define CMC2MC_AXI_A_ALEN_SEVENDATA                     _MK_ENUM_CONST(6)
#define CMC2MC_AXI_A_ALEN_EIGHTDATA                     _MK_ENUM_CONST(7)
#define CMC2MC_AXI_A_ALEN_NINEDATA                      _MK_ENUM_CONST(8)
#define CMC2MC_AXI_A_ALEN_TENDATA                       _MK_ENUM_CONST(9)
#define CMC2MC_AXI_A_ALEN_ELEVENDATA                    _MK_ENUM_CONST(10)
#define CMC2MC_AXI_A_ALEN_TWELVEDATA                    _MK_ENUM_CONST(11)
#define CMC2MC_AXI_A_ALEN_THIRTEENDATA                  _MK_ENUM_CONST(12)
#define CMC2MC_AXI_A_ALEN_FOURTEENDATA                  _MK_ENUM_CONST(13)
#define CMC2MC_AXI_A_ALEN_FIFTHTEENDATA                 _MK_ENUM_CONST(14)
#define CMC2MC_AXI_A_ALEN_SIXTEENDATA                   _MK_ENUM_CONST(15)

#define CMC2MC_AXI_A_ASIZE_SHIFT                        _MK_SHIFT_CONST(44)
#define CMC2MC_AXI_A_ASIZE_FIELD                        (_MK_MASK_CONST(0x7) << CMC2MC_AXI_A_ASIZE_SHIFT)
#define CMC2MC_AXI_A_ASIZE_RANGE                        _MK_SHIFT_CONST(46):_MK_SHIFT_CONST(44)
#define CMC2MC_AXI_A_ASIZE_ROW                  0
#define CMC2MC_AXI_A_ASIZE_ONEBYTE                      _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_ASIZE_TWOBYTES                     _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_ASIZE_FOURBYTES                    _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_ASIZE_EIGHTBYTES                   _MK_ENUM_CONST(3)
#define CMC2MC_AXI_A_ASIZE_SIXTEENBYTES                 _MK_ENUM_CONST(4)
#define CMC2MC_AXI_A_ASIZE_THIRTYTWOBYTES                       _MK_ENUM_CONST(5)
#define CMC2MC_AXI_A_ASIZE_SIXTYFOURBYTES                       _MK_ENUM_CONST(6)
#define CMC2MC_AXI_A_ASIZE_ONEHUNDREDTWENTYEIGHTBYTES                   _MK_ENUM_CONST(7)

#define CMC2MC_AXI_A_ABURST_SHIFT                       _MK_SHIFT_CONST(47)
#define CMC2MC_AXI_A_ABURST_FIELD                       (_MK_MASK_CONST(0x3) << CMC2MC_AXI_A_ABURST_SHIFT)
#define CMC2MC_AXI_A_ABURST_RANGE                       _MK_SHIFT_CONST(48):_MK_SHIFT_CONST(47)
#define CMC2MC_AXI_A_ABURST_ROW                 0
#define CMC2MC_AXI_A_ABURST_FIXED                       _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_ABURST_INCR                        _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_ABURST_WRAP                        _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_ABURST_RSVD                        _MK_ENUM_CONST(3)

#define CMC2MC_AXI_A_ALOCK_SHIFT                        _MK_SHIFT_CONST(49)
#define CMC2MC_AXI_A_ALOCK_FIELD                        (_MK_MASK_CONST(0x3) << CMC2MC_AXI_A_ALOCK_SHIFT)
#define CMC2MC_AXI_A_ALOCK_RANGE                        _MK_SHIFT_CONST(50):_MK_SHIFT_CONST(49)
#define CMC2MC_AXI_A_ALOCK_ROW                  0
#define CMC2MC_AXI_A_ALOCK_NORMAL                       _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_ALOCK_EXCLUSIVE                    _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_ALOCK_LOCKED                       _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_ALOCK_RSVD                 _MK_ENUM_CONST(3)

#define CMC2MC_AXI_A_ACACHE_SHIFT                       _MK_SHIFT_CONST(51)
#define CMC2MC_AXI_A_ACACHE_FIELD                       (_MK_MASK_CONST(0xf) << CMC2MC_AXI_A_ACACHE_SHIFT)
#define CMC2MC_AXI_A_ACACHE_RANGE                       _MK_SHIFT_CONST(54):_MK_SHIFT_CONST(51)
#define CMC2MC_AXI_A_ACACHE_ROW                 0
#define CMC2MC_AXI_A_ACACHE_NONCACHEABLE_NONBUFFERABLE                  _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_ACACHE_BUFFERABLE                  _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_ACACHE_CACHEABLE_DONOTALLOCATE                     _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_ACACHE_CACHEABLE_BUFFERABLE_DONOTALLOCATE                  _MK_ENUM_CONST(3)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREAD                        _MK_ENUM_CONST(6)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREAD                   _MK_ENUM_CONST(7)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONWRITE                       _MK_ENUM_CONST(10)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONWRITE                  _MK_ENUM_CONST(11)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREADWRITE                   _MK_ENUM_CONST(14)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREADWRITE                      _MK_ENUM_CONST(15)

#define CMC2MC_AXI_A_APROT_SHIFT                        _MK_SHIFT_CONST(55)
#define CMC2MC_AXI_A_APROT_FIELD                        (_MK_MASK_CONST(0x7) << CMC2MC_AXI_A_APROT_SHIFT)
#define CMC2MC_AXI_A_APROT_RANGE                        _MK_SHIFT_CONST(57):_MK_SHIFT_CONST(55)
#define CMC2MC_AXI_A_APROT_ROW                  0
#define CMC2MC_AXI_A_APROT_DATA_SECURE_NORMAL                   _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_APROT_DATA_SECURE_PRIVILEGED                       _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_APROT_DATA_NONSECURE_NORMAL                        _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_APROT_DATA_NONSECURE_PRIVILEGED                    _MK_ENUM_CONST(3)
#define CMC2MC_AXI_A_APROT_INST_SECURE_NORMAL                   _MK_ENUM_CONST(4)
#define CMC2MC_AXI_A_APROT_INST_SECURE_PRIVILEGED                       _MK_ENUM_CONST(5)
#define CMC2MC_AXI_A_APROT_INST_NONSECURE_NORMAL                        _MK_ENUM_CONST(6)
#define CMC2MC_AXI_A_APROT_INST_NONSECURE_PRIVILEGED                    _MK_ENUM_CONST(7)


// Packet CMC2MC_AXI_W
#define CMC2MC_AXI_W_SIZE 81

#define CMC2MC_AXI_W_WDATA_SHIFT                        _MK_SHIFT_CONST(0)
#define CMC2MC_AXI_W_WDATA_FIELD                        (_MK_MASK_CONST(0xffffffff) << CMC2MC_AXI_W_WDATA_SHIFT)
#define CMC2MC_AXI_W_WDATA_RANGE                        _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define CMC2MC_AXI_W_WDATA_ROW                  0

#define CMC2MC_AXI_W_WID_SHIFT                  _MK_SHIFT_CONST(64)
#define CMC2MC_AXI_W_WID_FIELD                  (_MK_MASK_CONST(0xff) << CMC2MC_AXI_W_WID_SHIFT)
#define CMC2MC_AXI_W_WID_RANGE                  _MK_SHIFT_CONST(71):_MK_SHIFT_CONST(64)
#define CMC2MC_AXI_W_WID_ROW                    0

#define CMC2MC_AXI_W_WSTRB_SHIFT                        _MK_SHIFT_CONST(72)
#define CMC2MC_AXI_W_WSTRB_FIELD                        (_MK_MASK_CONST(0xff) << CMC2MC_AXI_W_WSTRB_SHIFT)
#define CMC2MC_AXI_W_WSTRB_RANGE                        _MK_SHIFT_CONST(79):_MK_SHIFT_CONST(72)
#define CMC2MC_AXI_W_WSTRB_ROW                  0

#define CMC2MC_AXI_W_WLAST_SHIFT                        _MK_SHIFT_CONST(80)
#define CMC2MC_AXI_W_WLAST_FIELD                        (_MK_MASK_CONST(0x1) << CMC2MC_AXI_W_WLAST_SHIFT)
#define CMC2MC_AXI_W_WLAST_RANGE                        _MK_SHIFT_CONST(80):_MK_SHIFT_CONST(80)
#define CMC2MC_AXI_W_WLAST_ROW                  0
#define CMC2MC_AXI_W_WLAST_DISABLED                     _MK_ENUM_CONST(0)
#define CMC2MC_AXI_W_WLAST_ENABLED                      _MK_ENUM_CONST(1)


// Packet CMC2MC_AXI_B
#define CMC2MC_AXI_B_SIZE 10

#define CMC2MC_AXI_B_BID_SHIFT                  _MK_SHIFT_CONST(0)
#define CMC2MC_AXI_B_BID_FIELD                  (_MK_MASK_CONST(0xff) << CMC2MC_AXI_B_BID_SHIFT)
#define CMC2MC_AXI_B_BID_RANGE                  _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(0)
#define CMC2MC_AXI_B_BID_ROW                    0

#define CMC2MC_AXI_B_BRESP_SHIFT                        _MK_SHIFT_CONST(8)
#define CMC2MC_AXI_B_BRESP_FIELD                        (_MK_MASK_CONST(0x3) << CMC2MC_AXI_B_BRESP_SHIFT)
#define CMC2MC_AXI_B_BRESP_RANGE                        _MK_SHIFT_CONST(9):_MK_SHIFT_CONST(8)
#define CMC2MC_AXI_B_BRESP_ROW                  0
#define CMC2MC_AXI_B_BRESP_OKAY                 _MK_ENUM_CONST(0)
#define CMC2MC_AXI_B_BRESP_EXOKAY                       _MK_ENUM_CONST(1)
#define CMC2MC_AXI_B_BRESP_SLVERR                       _MK_ENUM_CONST(2)
#define CMC2MC_AXI_B_BRESP_DECERR                       _MK_ENUM_CONST(3)


// Packet CMC2MC_AXI_R
#define CMC2MC_AXI_R_SIZE 75

#define CMC2MC_AXI_R_RDATA_SHIFT                        _MK_SHIFT_CONST(0)
#define CMC2MC_AXI_R_RDATA_FIELD                        (_MK_MASK_CONST(0xffffffff) << CMC2MC_AXI_R_RDATA_SHIFT)
#define CMC2MC_AXI_R_RDATA_RANGE                        _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define CMC2MC_AXI_R_RDATA_ROW                  0

#define CMC2MC_AXI_R_RID_SHIFT                  _MK_SHIFT_CONST(64)
#define CMC2MC_AXI_R_RID_FIELD                  (_MK_MASK_CONST(0xff) << CMC2MC_AXI_R_RID_SHIFT)
#define CMC2MC_AXI_R_RID_RANGE                  _MK_SHIFT_CONST(71):_MK_SHIFT_CONST(64)
#define CMC2MC_AXI_R_RID_ROW                    0

#define CMC2MC_AXI_R_RRESP_SHIFT                        _MK_SHIFT_CONST(72)
#define CMC2MC_AXI_R_RRESP_FIELD                        (_MK_MASK_CONST(0x3) << CMC2MC_AXI_R_RRESP_SHIFT)
#define CMC2MC_AXI_R_RRESP_RANGE                        _MK_SHIFT_CONST(73):_MK_SHIFT_CONST(72)
#define CMC2MC_AXI_R_RRESP_ROW                  0
#define CMC2MC_AXI_R_RRESP_OKAY                 _MK_ENUM_CONST(0)
#define CMC2MC_AXI_R_RRESP_EXOKAY                       _MK_ENUM_CONST(1)
#define CMC2MC_AXI_R_RRESP_SLVERR                       _MK_ENUM_CONST(2)
#define CMC2MC_AXI_R_RRESP_DECERR                       _MK_ENUM_CONST(3)

#define CMC2MC_AXI_R_RLAST_SHIFT                        _MK_SHIFT_CONST(74)
#define CMC2MC_AXI_R_RLAST_FIELD                        (_MK_MASK_CONST(0x1) << CMC2MC_AXI_R_RLAST_SHIFT)
#define CMC2MC_AXI_R_RLAST_RANGE                        _MK_SHIFT_CONST(74):_MK_SHIFT_CONST(74)
#define CMC2MC_AXI_R_RLAST_ROW                  0
#define CMC2MC_AXI_R_RLAST_DISABLED                     _MK_ENUM_CONST(0)
#define CMC2MC_AXI_R_RLAST_ENABLED                      _MK_ENUM_CONST(1)


// Packet MSELECT2MC_AXI_A
#define MSELECT2MC_AXI_A_SIZE 58

#define MSELECT2MC_AXI_A_AADDR_SHIFT                    _MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_A_AADDR_FIELD                    (_MK_MASK_CONST(0xffffffff) << MSELECT2MC_AXI_A_AADDR_SHIFT)
#define MSELECT2MC_AXI_A_AADDR_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_A_AADDR_ROW                      0

#define MSELECT2MC_AXI_A_AID_SHIFT                      _MK_SHIFT_CONST(32)
#define MSELECT2MC_AXI_A_AID_FIELD                      (_MK_MASK_CONST(0xff) << MSELECT2MC_AXI_A_AID_SHIFT)
#define MSELECT2MC_AXI_A_AID_RANGE                      _MK_SHIFT_CONST(39):_MK_SHIFT_CONST(32)
#define MSELECT2MC_AXI_A_AID_ROW                        0

#define MSELECT2MC_AXI_A_ALEN_SHIFT                     _MK_SHIFT_CONST(40)
#define MSELECT2MC_AXI_A_ALEN_FIELD                     (_MK_MASK_CONST(0xf) << MSELECT2MC_AXI_A_ALEN_SHIFT)
#define MSELECT2MC_AXI_A_ALEN_RANGE                     _MK_SHIFT_CONST(43):_MK_SHIFT_CONST(40)
#define MSELECT2MC_AXI_A_ALEN_ROW                       0
#define MSELECT2MC_AXI_A_ALEN_ONEDATA                   _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_ALEN_TWODATA                   _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_ALEN_THREEDATA                 _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_ALEN_FOURDATA                  _MK_ENUM_CONST(3)
#define MSELECT2MC_AXI_A_ALEN_FIVEDATA                  _MK_ENUM_CONST(4)
#define MSELECT2MC_AXI_A_ALEN_SIXDATA                   _MK_ENUM_CONST(5)
#define MSELECT2MC_AXI_A_ALEN_SEVENDATA                 _MK_ENUM_CONST(6)
#define MSELECT2MC_AXI_A_ALEN_EIGHTDATA                 _MK_ENUM_CONST(7)
#define MSELECT2MC_AXI_A_ALEN_NINEDATA                  _MK_ENUM_CONST(8)
#define MSELECT2MC_AXI_A_ALEN_TENDATA                   _MK_ENUM_CONST(9)
#define MSELECT2MC_AXI_A_ALEN_ELEVENDATA                        _MK_ENUM_CONST(10)
#define MSELECT2MC_AXI_A_ALEN_TWELVEDATA                        _MK_ENUM_CONST(11)
#define MSELECT2MC_AXI_A_ALEN_THIRTEENDATA                      _MK_ENUM_CONST(12)
#define MSELECT2MC_AXI_A_ALEN_FOURTEENDATA                      _MK_ENUM_CONST(13)
#define MSELECT2MC_AXI_A_ALEN_FIFTHTEENDATA                     _MK_ENUM_CONST(14)
#define MSELECT2MC_AXI_A_ALEN_SIXTEENDATA                       _MK_ENUM_CONST(15)

#define MSELECT2MC_AXI_A_ASIZE_SHIFT                    _MK_SHIFT_CONST(44)
#define MSELECT2MC_AXI_A_ASIZE_FIELD                    (_MK_MASK_CONST(0x7) << MSELECT2MC_AXI_A_ASIZE_SHIFT)
#define MSELECT2MC_AXI_A_ASIZE_RANGE                    _MK_SHIFT_CONST(46):_MK_SHIFT_CONST(44)
#define MSELECT2MC_AXI_A_ASIZE_ROW                      0
#define MSELECT2MC_AXI_A_ASIZE_ONEBYTE                  _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_ASIZE_TWOBYTES                 _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_ASIZE_FOURBYTES                        _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_ASIZE_EIGHTBYTES                       _MK_ENUM_CONST(3)
#define MSELECT2MC_AXI_A_ASIZE_SIXTEENBYTES                     _MK_ENUM_CONST(4)
#define MSELECT2MC_AXI_A_ASIZE_THIRTYTWOBYTES                   _MK_ENUM_CONST(5)
#define MSELECT2MC_AXI_A_ASIZE_SIXTYFOURBYTES                   _MK_ENUM_CONST(6)
#define MSELECT2MC_AXI_A_ASIZE_ONEHUNDREDTWENTYEIGHTBYTES                       _MK_ENUM_CONST(7)

#define MSELECT2MC_AXI_A_ABURST_SHIFT                   _MK_SHIFT_CONST(47)
#define MSELECT2MC_AXI_A_ABURST_FIELD                   (_MK_MASK_CONST(0x3) << MSELECT2MC_AXI_A_ABURST_SHIFT)
#define MSELECT2MC_AXI_A_ABURST_RANGE                   _MK_SHIFT_CONST(48):_MK_SHIFT_CONST(47)
#define MSELECT2MC_AXI_A_ABURST_ROW                     0
#define MSELECT2MC_AXI_A_ABURST_FIXED                   _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_ABURST_INCR                    _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_ABURST_WRAP                    _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_ABURST_RSVD                    _MK_ENUM_CONST(3)

#define MSELECT2MC_AXI_A_ALOCK_SHIFT                    _MK_SHIFT_CONST(49)
#define MSELECT2MC_AXI_A_ALOCK_FIELD                    (_MK_MASK_CONST(0x3) << MSELECT2MC_AXI_A_ALOCK_SHIFT)
#define MSELECT2MC_AXI_A_ALOCK_RANGE                    _MK_SHIFT_CONST(50):_MK_SHIFT_CONST(49)
#define MSELECT2MC_AXI_A_ALOCK_ROW                      0
#define MSELECT2MC_AXI_A_ALOCK_NORMAL                   _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_ALOCK_EXCLUSIVE                        _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_ALOCK_LOCKED                   _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_ALOCK_RSVD                     _MK_ENUM_CONST(3)

#define MSELECT2MC_AXI_A_ACACHE_SHIFT                   _MK_SHIFT_CONST(51)
#define MSELECT2MC_AXI_A_ACACHE_FIELD                   (_MK_MASK_CONST(0xf) << MSELECT2MC_AXI_A_ACACHE_SHIFT)
#define MSELECT2MC_AXI_A_ACACHE_RANGE                   _MK_SHIFT_CONST(54):_MK_SHIFT_CONST(51)
#define MSELECT2MC_AXI_A_ACACHE_ROW                     0
#define MSELECT2MC_AXI_A_ACACHE_NONCACHEABLE_NONBUFFERABLE                      _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_ACACHE_BUFFERABLE                      _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLE_DONOTALLOCATE                 _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLE_BUFFERABLE_DONOTALLOCATE                      _MK_ENUM_CONST(3)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREAD                    _MK_ENUM_CONST(6)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREAD                       _MK_ENUM_CONST(7)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONWRITE                   _MK_ENUM_CONST(10)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONWRITE                      _MK_ENUM_CONST(11)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREADWRITE                       _MK_ENUM_CONST(14)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREADWRITE                  _MK_ENUM_CONST(15)

#define MSELECT2MC_AXI_A_APROT_SHIFT                    _MK_SHIFT_CONST(55)
#define MSELECT2MC_AXI_A_APROT_FIELD                    (_MK_MASK_CONST(0x7) << MSELECT2MC_AXI_A_APROT_SHIFT)
#define MSELECT2MC_AXI_A_APROT_RANGE                    _MK_SHIFT_CONST(57):_MK_SHIFT_CONST(55)
#define MSELECT2MC_AXI_A_APROT_ROW                      0
#define MSELECT2MC_AXI_A_APROT_DATA_SECURE_NORMAL                       _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_APROT_DATA_SECURE_PRIVILEGED                   _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_APROT_DATA_NONSECURE_NORMAL                    _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_APROT_DATA_NONSECURE_PRIVILEGED                        _MK_ENUM_CONST(3)
#define MSELECT2MC_AXI_A_APROT_INST_SECURE_NORMAL                       _MK_ENUM_CONST(4)
#define MSELECT2MC_AXI_A_APROT_INST_SECURE_PRIVILEGED                   _MK_ENUM_CONST(5)
#define MSELECT2MC_AXI_A_APROT_INST_NONSECURE_NORMAL                    _MK_ENUM_CONST(6)
#define MSELECT2MC_AXI_A_APROT_INST_NONSECURE_PRIVILEGED                        _MK_ENUM_CONST(7)


// Packet MSELECT2MC_AXI_W
#define MSELECT2MC_AXI_W_SIZE 81

#define MSELECT2MC_AXI_W_WDATA_SHIFT                    _MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_W_WDATA_FIELD                    (_MK_MASK_CONST(0xffffffff) << MSELECT2MC_AXI_W_WDATA_SHIFT)
#define MSELECT2MC_AXI_W_WDATA_RANGE                    _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_W_WDATA_ROW                      0

#define MSELECT2MC_AXI_W_WID_SHIFT                      _MK_SHIFT_CONST(64)
#define MSELECT2MC_AXI_W_WID_FIELD                      (_MK_MASK_CONST(0xff) << MSELECT2MC_AXI_W_WID_SHIFT)
#define MSELECT2MC_AXI_W_WID_RANGE                      _MK_SHIFT_CONST(71):_MK_SHIFT_CONST(64)
#define MSELECT2MC_AXI_W_WID_ROW                        0

#define MSELECT2MC_AXI_W_WSTRB_SHIFT                    _MK_SHIFT_CONST(72)
#define MSELECT2MC_AXI_W_WSTRB_FIELD                    (_MK_MASK_CONST(0xff) << MSELECT2MC_AXI_W_WSTRB_SHIFT)
#define MSELECT2MC_AXI_W_WSTRB_RANGE                    _MK_SHIFT_CONST(79):_MK_SHIFT_CONST(72)
#define MSELECT2MC_AXI_W_WSTRB_ROW                      0

#define MSELECT2MC_AXI_W_WLAST_SHIFT                    _MK_SHIFT_CONST(80)
#define MSELECT2MC_AXI_W_WLAST_FIELD                    (_MK_MASK_CONST(0x1) << MSELECT2MC_AXI_W_WLAST_SHIFT)
#define MSELECT2MC_AXI_W_WLAST_RANGE                    _MK_SHIFT_CONST(80):_MK_SHIFT_CONST(80)
#define MSELECT2MC_AXI_W_WLAST_ROW                      0
#define MSELECT2MC_AXI_W_WLAST_DISABLED                 _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_W_WLAST_ENABLED                  _MK_ENUM_CONST(1)


// Packet MSELECT2MC_AXI_B
#define MSELECT2MC_AXI_B_SIZE 10

#define MSELECT2MC_AXI_B_BID_SHIFT                      _MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_B_BID_FIELD                      (_MK_MASK_CONST(0xff) << MSELECT2MC_AXI_B_BID_SHIFT)
#define MSELECT2MC_AXI_B_BID_RANGE                      _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_B_BID_ROW                        0

#define MSELECT2MC_AXI_B_BRESP_SHIFT                    _MK_SHIFT_CONST(8)
#define MSELECT2MC_AXI_B_BRESP_FIELD                    (_MK_MASK_CONST(0x3) << MSELECT2MC_AXI_B_BRESP_SHIFT)
#define MSELECT2MC_AXI_B_BRESP_RANGE                    _MK_SHIFT_CONST(9):_MK_SHIFT_CONST(8)
#define MSELECT2MC_AXI_B_BRESP_ROW                      0
#define MSELECT2MC_AXI_B_BRESP_OKAY                     _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_B_BRESP_EXOKAY                   _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_B_BRESP_SLVERR                   _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_B_BRESP_DECERR                   _MK_ENUM_CONST(3)


// Packet MSELECT2MC_AXI_R
#define MSELECT2MC_AXI_R_SIZE 75

#define MSELECT2MC_AXI_R_RDATA_SHIFT                    _MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_R_RDATA_FIELD                    (_MK_MASK_CONST(0xffffffff) << MSELECT2MC_AXI_R_RDATA_SHIFT)
#define MSELECT2MC_AXI_R_RDATA_RANGE                    _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_R_RDATA_ROW                      0

#define MSELECT2MC_AXI_R_RID_SHIFT                      _MK_SHIFT_CONST(64)
#define MSELECT2MC_AXI_R_RID_FIELD                      (_MK_MASK_CONST(0xff) << MSELECT2MC_AXI_R_RID_SHIFT)
#define MSELECT2MC_AXI_R_RID_RANGE                      _MK_SHIFT_CONST(71):_MK_SHIFT_CONST(64)
#define MSELECT2MC_AXI_R_RID_ROW                        0

#define MSELECT2MC_AXI_R_RRESP_SHIFT                    _MK_SHIFT_CONST(72)
#define MSELECT2MC_AXI_R_RRESP_FIELD                    (_MK_MASK_CONST(0x3) << MSELECT2MC_AXI_R_RRESP_SHIFT)
#define MSELECT2MC_AXI_R_RRESP_RANGE                    _MK_SHIFT_CONST(73):_MK_SHIFT_CONST(72)
#define MSELECT2MC_AXI_R_RRESP_ROW                      0
#define MSELECT2MC_AXI_R_RRESP_OKAY                     _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_R_RRESP_EXOKAY                   _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_R_RRESP_SLVERR                   _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_R_RRESP_DECERR                   _MK_ENUM_CONST(3)

#define MSELECT2MC_AXI_R_RLAST_SHIFT                    _MK_SHIFT_CONST(74)
#define MSELECT2MC_AXI_R_RLAST_FIELD                    (_MK_MASK_CONST(0x1) << MSELECT2MC_AXI_R_RLAST_SHIFT)
#define MSELECT2MC_AXI_R_RLAST_RANGE                    _MK_SHIFT_CONST(74):_MK_SHIFT_CONST(74)
#define MSELECT2MC_AXI_R_RLAST_ROW                      0
#define MSELECT2MC_AXI_R_RLAST_DISABLED                 _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_R_RLAST_ENABLED                  _MK_ENUM_CONST(1)


// Packet AXI2MC_AXI_A
#define AXI2MC_AXI_A_SIZE 58

#define AXI2MC_AXI_A_AADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define AXI2MC_AXI_A_AADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << AXI2MC_AXI_A_AADDR_SHIFT)
#define AXI2MC_AXI_A_AADDR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define AXI2MC_AXI_A_AADDR_ROW                  0

#define AXI2MC_AXI_A_AID_SHIFT                  _MK_SHIFT_CONST(32)
#define AXI2MC_AXI_A_AID_FIELD                  (_MK_MASK_CONST(0xff) << AXI2MC_AXI_A_AID_SHIFT)
#define AXI2MC_AXI_A_AID_RANGE                  _MK_SHIFT_CONST(39):_MK_SHIFT_CONST(32)
#define AXI2MC_AXI_A_AID_ROW                    0

#define AXI2MC_AXI_A_ALEN_SHIFT                 _MK_SHIFT_CONST(40)
#define AXI2MC_AXI_A_ALEN_FIELD                 (_MK_MASK_CONST(0xf) << AXI2MC_AXI_A_ALEN_SHIFT)
#define AXI2MC_AXI_A_ALEN_RANGE                 _MK_SHIFT_CONST(43):_MK_SHIFT_CONST(40)
#define AXI2MC_AXI_A_ALEN_ROW                   0
#define AXI2MC_AXI_A_ALEN_ONEDATA                       _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_ALEN_TWODATA                       _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_ALEN_THREEDATA                     _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_ALEN_FOURDATA                      _MK_ENUM_CONST(3)
#define AXI2MC_AXI_A_ALEN_FIVEDATA                      _MK_ENUM_CONST(4)
#define AXI2MC_AXI_A_ALEN_SIXDATA                       _MK_ENUM_CONST(5)
#define AXI2MC_AXI_A_ALEN_SEVENDATA                     _MK_ENUM_CONST(6)
#define AXI2MC_AXI_A_ALEN_EIGHTDATA                     _MK_ENUM_CONST(7)
#define AXI2MC_AXI_A_ALEN_NINEDATA                      _MK_ENUM_CONST(8)
#define AXI2MC_AXI_A_ALEN_TENDATA                       _MK_ENUM_CONST(9)
#define AXI2MC_AXI_A_ALEN_ELEVENDATA                    _MK_ENUM_CONST(10)
#define AXI2MC_AXI_A_ALEN_TWELVEDATA                    _MK_ENUM_CONST(11)
#define AXI2MC_AXI_A_ALEN_THIRTEENDATA                  _MK_ENUM_CONST(12)
#define AXI2MC_AXI_A_ALEN_FOURTEENDATA                  _MK_ENUM_CONST(13)
#define AXI2MC_AXI_A_ALEN_FIFTHTEENDATA                 _MK_ENUM_CONST(14)
#define AXI2MC_AXI_A_ALEN_SIXTEENDATA                   _MK_ENUM_CONST(15)

#define AXI2MC_AXI_A_ASIZE_SHIFT                        _MK_SHIFT_CONST(44)
#define AXI2MC_AXI_A_ASIZE_FIELD                        (_MK_MASK_CONST(0x7) << AXI2MC_AXI_A_ASIZE_SHIFT)
#define AXI2MC_AXI_A_ASIZE_RANGE                        _MK_SHIFT_CONST(46):_MK_SHIFT_CONST(44)
#define AXI2MC_AXI_A_ASIZE_ROW                  0
#define AXI2MC_AXI_A_ASIZE_ONEBYTE                      _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_ASIZE_TWOBYTES                     _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_ASIZE_FOURBYTES                    _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_ASIZE_EIGHTBYTES                   _MK_ENUM_CONST(3)
#define AXI2MC_AXI_A_ASIZE_SIXTEENBYTES                 _MK_ENUM_CONST(4)
#define AXI2MC_AXI_A_ASIZE_THIRTYTWOBYTES                       _MK_ENUM_CONST(5)
#define AXI2MC_AXI_A_ASIZE_SIXTYFOURBYTES                       _MK_ENUM_CONST(6)
#define AXI2MC_AXI_A_ASIZE_ONEHUNDREDTWENTYEIGHTBYTES                   _MK_ENUM_CONST(7)

#define AXI2MC_AXI_A_ABURST_SHIFT                       _MK_SHIFT_CONST(47)
#define AXI2MC_AXI_A_ABURST_FIELD                       (_MK_MASK_CONST(0x3) << AXI2MC_AXI_A_ABURST_SHIFT)
#define AXI2MC_AXI_A_ABURST_RANGE                       _MK_SHIFT_CONST(48):_MK_SHIFT_CONST(47)
#define AXI2MC_AXI_A_ABURST_ROW                 0
#define AXI2MC_AXI_A_ABURST_FIXED                       _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_ABURST_INCR                        _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_ABURST_WRAP                        _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_ABURST_RSVD                        _MK_ENUM_CONST(3)

#define AXI2MC_AXI_A_ALOCK_SHIFT                        _MK_SHIFT_CONST(49)
#define AXI2MC_AXI_A_ALOCK_FIELD                        (_MK_MASK_CONST(0x3) << AXI2MC_AXI_A_ALOCK_SHIFT)
#define AXI2MC_AXI_A_ALOCK_RANGE                        _MK_SHIFT_CONST(50):_MK_SHIFT_CONST(49)
#define AXI2MC_AXI_A_ALOCK_ROW                  0
#define AXI2MC_AXI_A_ALOCK_NORMAL                       _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_ALOCK_EXCLUSIVE                    _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_ALOCK_LOCKED                       _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_ALOCK_RSVD                 _MK_ENUM_CONST(3)

#define AXI2MC_AXI_A_ACACHE_SHIFT                       _MK_SHIFT_CONST(51)
#define AXI2MC_AXI_A_ACACHE_FIELD                       (_MK_MASK_CONST(0xf) << AXI2MC_AXI_A_ACACHE_SHIFT)
#define AXI2MC_AXI_A_ACACHE_RANGE                       _MK_SHIFT_CONST(54):_MK_SHIFT_CONST(51)
#define AXI2MC_AXI_A_ACACHE_ROW                 0
#define AXI2MC_AXI_A_ACACHE_NONCACHEABLE_NONBUFFERABLE                  _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_ACACHE_BUFFERABLE                  _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_ACACHE_CACHEABLE_DONOTALLOCATE                     _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_ACACHE_CACHEABLE_BUFFERABLE_DONOTALLOCATE                  _MK_ENUM_CONST(3)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREAD                        _MK_ENUM_CONST(6)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREAD                   _MK_ENUM_CONST(7)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONWRITE                       _MK_ENUM_CONST(10)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONWRITE                  _MK_ENUM_CONST(11)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREADWRITE                   _MK_ENUM_CONST(14)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREADWRITE                      _MK_ENUM_CONST(15)

#define AXI2MC_AXI_A_APROT_SHIFT                        _MK_SHIFT_CONST(55)
#define AXI2MC_AXI_A_APROT_FIELD                        (_MK_MASK_CONST(0x7) << AXI2MC_AXI_A_APROT_SHIFT)
#define AXI2MC_AXI_A_APROT_RANGE                        _MK_SHIFT_CONST(57):_MK_SHIFT_CONST(55)
#define AXI2MC_AXI_A_APROT_ROW                  0
#define AXI2MC_AXI_A_APROT_DATA_SECURE_NORMAL                   _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_APROT_DATA_SECURE_PRIVILEGED                       _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_APROT_DATA_NONSECURE_NORMAL                        _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_APROT_DATA_NONSECURE_PRIVILEGED                    _MK_ENUM_CONST(3)
#define AXI2MC_AXI_A_APROT_INST_SECURE_NORMAL                   _MK_ENUM_CONST(4)
#define AXI2MC_AXI_A_APROT_INST_SECURE_PRIVILEGED                       _MK_ENUM_CONST(5)
#define AXI2MC_AXI_A_APROT_INST_NONSECURE_NORMAL                        _MK_ENUM_CONST(6)
#define AXI2MC_AXI_A_APROT_INST_NONSECURE_PRIVILEGED                    _MK_ENUM_CONST(7)


// Packet AXI2MC_AXI_W
#define AXI2MC_AXI_W_SIZE 297

#define AXI2MC_AXI_W_WDATA_SHIFT                        _MK_SHIFT_CONST(0)
#define AXI2MC_AXI_W_WDATA_FIELD                        (_MK_MASK_CONST(0xffffffff) << AXI2MC_AXI_W_WDATA_SHIFT)
#define AXI2MC_AXI_W_WDATA_RANGE                        _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(0)
#define AXI2MC_AXI_W_WDATA_ROW                  0

#define AXI2MC_AXI_W_WID_SHIFT                  _MK_SHIFT_CONST(256)
#define AXI2MC_AXI_W_WID_FIELD                  (_MK_MASK_CONST(0xff) << AXI2MC_AXI_W_WID_SHIFT)
#define AXI2MC_AXI_W_WID_RANGE                  _MK_SHIFT_CONST(263):_MK_SHIFT_CONST(256)
#define AXI2MC_AXI_W_WID_ROW                    0

#define AXI2MC_AXI_W_WSTRB_SHIFT                        _MK_SHIFT_CONST(264)
#define AXI2MC_AXI_W_WSTRB_FIELD                        (_MK_MASK_CONST(0xffffffff) << AXI2MC_AXI_W_WSTRB_SHIFT)
#define AXI2MC_AXI_W_WSTRB_RANGE                        _MK_SHIFT_CONST(295):_MK_SHIFT_CONST(264)
#define AXI2MC_AXI_W_WSTRB_ROW                  0

#define AXI2MC_AXI_W_WLAST_SHIFT                        _MK_SHIFT_CONST(296)
#define AXI2MC_AXI_W_WLAST_FIELD                        (_MK_MASK_CONST(0x1) << AXI2MC_AXI_W_WLAST_SHIFT)
#define AXI2MC_AXI_W_WLAST_RANGE                        _MK_SHIFT_CONST(296):_MK_SHIFT_CONST(296)
#define AXI2MC_AXI_W_WLAST_ROW                  0
#define AXI2MC_AXI_W_WLAST_DISABLED                     _MK_ENUM_CONST(0)
#define AXI2MC_AXI_W_WLAST_ENABLED                      _MK_ENUM_CONST(1)


// Packet AXI2MC_AXI_B
#define AXI2MC_AXI_B_SIZE 10

#define AXI2MC_AXI_B_BID_SHIFT                  _MK_SHIFT_CONST(0)
#define AXI2MC_AXI_B_BID_FIELD                  (_MK_MASK_CONST(0xff) << AXI2MC_AXI_B_BID_SHIFT)
#define AXI2MC_AXI_B_BID_RANGE                  _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(0)
#define AXI2MC_AXI_B_BID_ROW                    0

#define AXI2MC_AXI_B_BRESP_SHIFT                        _MK_SHIFT_CONST(8)
#define AXI2MC_AXI_B_BRESP_FIELD                        (_MK_MASK_CONST(0x3) << AXI2MC_AXI_B_BRESP_SHIFT)
#define AXI2MC_AXI_B_BRESP_RANGE                        _MK_SHIFT_CONST(9):_MK_SHIFT_CONST(8)
#define AXI2MC_AXI_B_BRESP_ROW                  0
#define AXI2MC_AXI_B_BRESP_OKAY                 _MK_ENUM_CONST(0)
#define AXI2MC_AXI_B_BRESP_EXOKAY                       _MK_ENUM_CONST(1)
#define AXI2MC_AXI_B_BRESP_SLVERR                       _MK_ENUM_CONST(2)
#define AXI2MC_AXI_B_BRESP_DECERR                       _MK_ENUM_CONST(3)


// Packet AXI2MC_AXI_R
#define AXI2MC_AXI_R_SIZE 267

#define AXI2MC_AXI_R_RDATA_SHIFT                        _MK_SHIFT_CONST(0)
#define AXI2MC_AXI_R_RDATA_FIELD                        (_MK_MASK_CONST(0xffffffff) << AXI2MC_AXI_R_RDATA_SHIFT)
#define AXI2MC_AXI_R_RDATA_RANGE                        _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(0)
#define AXI2MC_AXI_R_RDATA_ROW                  0

#define AXI2MC_AXI_R_RID_SHIFT                  _MK_SHIFT_CONST(256)
#define AXI2MC_AXI_R_RID_FIELD                  (_MK_MASK_CONST(0xff) << AXI2MC_AXI_R_RID_SHIFT)
#define AXI2MC_AXI_R_RID_RANGE                  _MK_SHIFT_CONST(263):_MK_SHIFT_CONST(256)
#define AXI2MC_AXI_R_RID_ROW                    0

#define AXI2MC_AXI_R_RRESP_SHIFT                        _MK_SHIFT_CONST(264)
#define AXI2MC_AXI_R_RRESP_FIELD                        (_MK_MASK_CONST(0x3) << AXI2MC_AXI_R_RRESP_SHIFT)
#define AXI2MC_AXI_R_RRESP_RANGE                        _MK_SHIFT_CONST(265):_MK_SHIFT_CONST(264)
#define AXI2MC_AXI_R_RRESP_ROW                  0
#define AXI2MC_AXI_R_RRESP_OKAY                 _MK_ENUM_CONST(0)
#define AXI2MC_AXI_R_RRESP_EXOKAY                       _MK_ENUM_CONST(1)
#define AXI2MC_AXI_R_RRESP_SLVERR                       _MK_ENUM_CONST(2)
#define AXI2MC_AXI_R_RRESP_DECERR                       _MK_ENUM_CONST(3)

#define AXI2MC_AXI_R_RLAST_SHIFT                        _MK_SHIFT_CONST(266)
#define AXI2MC_AXI_R_RLAST_FIELD                        (_MK_MASK_CONST(0x1) << AXI2MC_AXI_R_RLAST_SHIFT)
#define AXI2MC_AXI_R_RLAST_RANGE                        _MK_SHIFT_CONST(266):_MK_SHIFT_CONST(266)
#define AXI2MC_AXI_R_RLAST_ROW                  0
#define AXI2MC_AXI_R_RLAST_DISABLED                     _MK_ENUM_CONST(0)
#define AXI2MC_AXI_R_RLAST_ENABLED                      _MK_ENUM_CONST(1)


// Packet MC_AXI_RWREQ
#define MC_AXI_RWREQ_SIZE 107

#define MC_AXI_RWREQ_AADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define MC_AXI_RWREQ_AADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << MC_AXI_RWREQ_AADDR_SHIFT)
#define MC_AXI_RWREQ_AADDR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define MC_AXI_RWREQ_AADDR_ROW                  0

#define MC_AXI_RWREQ_AID_SHIFT                  _MK_SHIFT_CONST(32)
#define MC_AXI_RWREQ_AID_FIELD                  (_MK_MASK_CONST(0xff) << MC_AXI_RWREQ_AID_SHIFT)
#define MC_AXI_RWREQ_AID_RANGE                  _MK_SHIFT_CONST(39):_MK_SHIFT_CONST(32)
#define MC_AXI_RWREQ_AID_ROW                    0

#define MC_AXI_RWREQ_ALEN_SHIFT                 _MK_SHIFT_CONST(40)
#define MC_AXI_RWREQ_ALEN_FIELD                 (_MK_MASK_CONST(0xf) << MC_AXI_RWREQ_ALEN_SHIFT)
#define MC_AXI_RWREQ_ALEN_RANGE                 _MK_SHIFT_CONST(43):_MK_SHIFT_CONST(40)
#define MC_AXI_RWREQ_ALEN_ROW                   0

#define MC_AXI_RWREQ_ASIZE_SHIFT                        _MK_SHIFT_CONST(44)
#define MC_AXI_RWREQ_ASIZE_FIELD                        (_MK_MASK_CONST(0x7) << MC_AXI_RWREQ_ASIZE_SHIFT)
#define MC_AXI_RWREQ_ASIZE_RANGE                        _MK_SHIFT_CONST(46):_MK_SHIFT_CONST(44)
#define MC_AXI_RWREQ_ASIZE_ROW                  2

#define MC_AXI_RWREQ_ABURST_SHIFT                       _MK_SHIFT_CONST(47)
#define MC_AXI_RWREQ_ABURST_FIELD                       (_MK_MASK_CONST(0x3) << MC_AXI_RWREQ_ABURST_SHIFT)
#define MC_AXI_RWREQ_ABURST_RANGE                       _MK_SHIFT_CONST(48):_MK_SHIFT_CONST(47)
#define MC_AXI_RWREQ_ABURST_ROW                 0
#define MC_AXI_RWREQ_ABURST_FIXED                       _MK_ENUM_CONST(0)
#define MC_AXI_RWREQ_ABURST_INCR                        _MK_ENUM_CONST(1)
#define MC_AXI_RWREQ_ABURST_WRAP                        _MK_ENUM_CONST(2)
#define MC_AXI_RWREQ_ABURST_RSVD                        _MK_ENUM_CONST(3)

#define MC_AXI_RWREQ_ALOCK_SHIFT                        _MK_SHIFT_CONST(49)
#define MC_AXI_RWREQ_ALOCK_FIELD                        (_MK_MASK_CONST(0x3) << MC_AXI_RWREQ_ALOCK_SHIFT)
#define MC_AXI_RWREQ_ALOCK_RANGE                        _MK_SHIFT_CONST(50):_MK_SHIFT_CONST(49)
#define MC_AXI_RWREQ_ALOCK_ROW                  0

#define MC_AXI_RWREQ_ACACHE_SHIFT                       _MK_SHIFT_CONST(51)
#define MC_AXI_RWREQ_ACACHE_FIELD                       (_MK_MASK_CONST(0xf) << MC_AXI_RWREQ_ACACHE_SHIFT)
#define MC_AXI_RWREQ_ACACHE_RANGE                       _MK_SHIFT_CONST(54):_MK_SHIFT_CONST(51)
#define MC_AXI_RWREQ_ACACHE_ROW                 0

#define MC_AXI_RWREQ_APROT_SHIFT                        _MK_SHIFT_CONST(55)
#define MC_AXI_RWREQ_APROT_FIELD                        (_MK_MASK_CONST(0x7) << MC_AXI_RWREQ_APROT_SHIFT)
#define MC_AXI_RWREQ_APROT_RANGE                        _MK_SHIFT_CONST(57):_MK_SHIFT_CONST(55)
#define MC_AXI_RWREQ_APROT_ROW                  0

#define MC_AXI_RWREQ_ASB_SHIFT                  _MK_SHIFT_CONST(58)
#define MC_AXI_RWREQ_ASB_FIELD                  (_MK_MASK_CONST(0x3) << MC_AXI_RWREQ_ASB_SHIFT)
#define MC_AXI_RWREQ_ASB_RANGE                  _MK_SHIFT_CONST(59):_MK_SHIFT_CONST(58)
#define MC_AXI_RWREQ_ASB_ROW                    0

#define MC_AXI_RWREQ_ARW_SHIFT                  _MK_SHIFT_CONST(60)
#define MC_AXI_RWREQ_ARW_FIELD                  (_MK_MASK_CONST(0x1) << MC_AXI_RWREQ_ARW_SHIFT)
#define MC_AXI_RWREQ_ARW_RANGE                  _MK_SHIFT_CONST(60):_MK_SHIFT_CONST(60)
#define MC_AXI_RWREQ_ARW_ROW                    0

#define MC_AXI_RWREQ_ACT_AADDR_SHIFT                    _MK_SHIFT_CONST(61)
#define MC_AXI_RWREQ_ACT_AADDR_FIELD                    (_MK_MASK_CONST(0xffffffff) << MC_AXI_RWREQ_ACT_AADDR_SHIFT)
#define MC_AXI_RWREQ_ACT_AADDR_RANGE                    _MK_SHIFT_CONST(92):_MK_SHIFT_CONST(61)
#define MC_AXI_RWREQ_ACT_AADDR_ROW                      0

#define MC_AXI_RWREQ_ACT_ALEN_SHIFT                     _MK_SHIFT_CONST(93)
#define MC_AXI_RWREQ_ACT_ALEN_FIELD                     (_MK_MASK_CONST(0xf) << MC_AXI_RWREQ_ACT_ALEN_SHIFT)
#define MC_AXI_RWREQ_ACT_ALEN_RANGE                     _MK_SHIFT_CONST(96):_MK_SHIFT_CONST(93)
#define MC_AXI_RWREQ_ACT_ALEN_ROW                       0

#define MC_AXI_RWREQ_ACT_ASIZE_SHIFT                    _MK_SHIFT_CONST(97)
#define MC_AXI_RWREQ_ACT_ASIZE_FIELD                    (_MK_MASK_CONST(0x7) << MC_AXI_RWREQ_ACT_ASIZE_SHIFT)
#define MC_AXI_RWREQ_ACT_ASIZE_RANGE                    _MK_SHIFT_CONST(99):_MK_SHIFT_CONST(97)
#define MC_AXI_RWREQ_ACT_ASIZE_ROW                      0

#define MC_AXI_RWREQ_DOUBLEREQ_SHIFT                    _MK_SHIFT_CONST(100)
#define MC_AXI_RWREQ_DOUBLEREQ_FIELD                    (_MK_MASK_CONST(0x1) << MC_AXI_RWREQ_DOUBLEREQ_SHIFT)
#define MC_AXI_RWREQ_DOUBLEREQ_RANGE                    _MK_SHIFT_CONST(100):_MK_SHIFT_CONST(100)
#define MC_AXI_RWREQ_DOUBLEREQ_ROW                      0

#define MC_AXI_RWREQ_ILLEGALACC_SHIFT                   _MK_SHIFT_CONST(101)
#define MC_AXI_RWREQ_ILLEGALACC_FIELD                   (_MK_MASK_CONST(0x1) << MC_AXI_RWREQ_ILLEGALACC_SHIFT)
#define MC_AXI_RWREQ_ILLEGALACC_RANGE                   _MK_SHIFT_CONST(101):_MK_SHIFT_CONST(101)
#define MC_AXI_RWREQ_ILLEGALACC_ROW                     0

#define MC_AXI_RWREQ_TAG_SHIFT                  _MK_SHIFT_CONST(102)
#define MC_AXI_RWREQ_TAG_FIELD                  (_MK_MASK_CONST(0x1f) << MC_AXI_RWREQ_TAG_SHIFT)
#define MC_AXI_RWREQ_TAG_RANGE                  _MK_SHIFT_CONST(106):_MK_SHIFT_CONST(102)
#define MC_AXI_RWREQ_TAG_ROW                    0


// Packet CSR_C2MC_RESET
#define CSR_C2MC_RESET_SIZE 1

#define CSR_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CSR_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CSR_C2MC_RESET_RSTN_SHIFT)
#define CSR_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CSR_C2MC_RESET_RSTN_ROW                 0


// Packet CSR_C2MC_REQ
#define CSR_C2MC_REQ_SIZE 32

#define CSR_C2MC_REQ_ADR_SHIFT                  _MK_SHIFT_CONST(0)
#define CSR_C2MC_REQ_ADR_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSR_C2MC_REQ_ADR_SHIFT)
#define CSR_C2MC_REQ_ADR_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSR_C2MC_REQ_ADR_ROW                    0


// Packet CSR_C2MC_BP_REQ
#define CSR_C2MC_BP_REQ_SIZE 48

#define CSR_C2MC_BP_REQ_BASEADR_SHIFT                   _MK_SHIFT_CONST(0)
#define CSR_C2MC_BP_REQ_BASEADR_FIELD                   (_MK_MASK_CONST(0xffffffff) << CSR_C2MC_BP_REQ_BASEADR_SHIFT)
#define CSR_C2MC_BP_REQ_BASEADR_RANGE                   _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSR_C2MC_BP_REQ_BASEADR_ROW                     0

#define CSR_C2MC_BP_REQ_PITCH_SHIFT                     _MK_SHIFT_CONST(32)
#define CSR_C2MC_BP_REQ_PITCH_FIELD                     (_MK_MASK_CONST(0xffff) << CSR_C2MC_BP_REQ_PITCH_SHIFT)
#define CSR_C2MC_BP_REQ_PITCH_RANGE                     _MK_SHIFT_CONST(47):_MK_SHIFT_CONST(32)
#define CSR_C2MC_BP_REQ_PITCH_ROW                       0


// Packet CSR_C2MC_ADRXY
#define CSR_C2MC_ADRXY_SIZE 30

#define CSR_C2MC_ADRXY_OFFX_SHIFT                       _MK_SHIFT_CONST(0)
#define CSR_C2MC_ADRXY_OFFX_FIELD                       (_MK_MASK_CONST(0xffff) << CSR_C2MC_ADRXY_OFFX_SHIFT)
#define CSR_C2MC_ADRXY_OFFX_RANGE                       _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define CSR_C2MC_ADRXY_OFFX_ROW                 0

#define CSR_C2MC_ADRXY_OFFY_SHIFT                       _MK_SHIFT_CONST(16)
#define CSR_C2MC_ADRXY_OFFY_FIELD                       (_MK_MASK_CONST(0x3fff) << CSR_C2MC_ADRXY_OFFY_SHIFT)
#define CSR_C2MC_ADRXY_OFFY_RANGE                       _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(16)
#define CSR_C2MC_ADRXY_OFFY_ROW                 0


// Packet CSR_C2MC_TILE
#define CSR_C2MC_TILE_SIZE 33

#define CSR_C2MC_TILE_LINADR_SHIFT                      _MK_SHIFT_CONST(0)
#define CSR_C2MC_TILE_LINADR_FIELD                      (_MK_MASK_CONST(0xffffffff) << CSR_C2MC_TILE_LINADR_SHIFT)
#define CSR_C2MC_TILE_LINADR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSR_C2MC_TILE_LINADR_ROW                        0

#define CSR_C2MC_TILE_TMODE_SHIFT                       _MK_SHIFT_CONST(32)
#define CSR_C2MC_TILE_TMODE_FIELD                       (_MK_MASK_CONST(0x1) << CSR_C2MC_TILE_TMODE_SHIFT)
#define CSR_C2MC_TILE_TMODE_RANGE                       _MK_SHIFT_CONST(32):_MK_SHIFT_CONST(32)
#define CSR_C2MC_TILE_TMODE_ROW                 0
#define CSR_C2MC_TILE_TMODE_LINEAR                      _MK_ENUM_CONST(0)
#define CSR_C2MC_TILE_TMODE_TILED                       _MK_ENUM_CONST(1)


// Packet CSR_C2MC_RDI
#define CSR_C2MC_RDI_SIZE 256

#define CSR_C2MC_RDI_RDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CSR_C2MC_RDI_RDI_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSR_C2MC_RDI_RDI_SHIFT)
#define CSR_C2MC_RDI_RDI_RANGE                  _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(0)
#define CSR_C2MC_RDI_RDI_ROW                    0


// Packet CSR_C2MC_HP
#define CSR_C2MC_HP_SIZE 38

// high-priority threshold
#define CSR_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CSR_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSR_C2MC_HP_HPTH_SHIFT)
#define CSR_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSR_C2MC_HP_HPTH_ROW                    0

// high-priority timer
#define CSR_C2MC_HP_HPTM_SHIFT                  _MK_SHIFT_CONST(32)
#define CSR_C2MC_HP_HPTM_FIELD                  (_MK_MASK_CONST(0x3f) << CSR_C2MC_HP_HPTM_SHIFT)
#define CSR_C2MC_HP_HPTM_RANGE                  _MK_SHIFT_CONST(37):_MK_SHIFT_CONST(32)
#define CSR_C2MC_HP_HPTM_ROW                    0


// Packet CSW_C2MC_RESET
#define CSW_C2MC_RESET_SIZE 1

#define CSW_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CSW_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CSW_C2MC_RESET_RSTN_SHIFT)
#define CSW_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CSW_C2MC_RESET_RSTN_ROW                 0


// Packet CSW_C2MC_REQ
#define CSW_C2MC_REQ_SIZE 321

#define CSW_C2MC_REQ_ADR_SHIFT                  _MK_SHIFT_CONST(0)
#define CSW_C2MC_REQ_ADR_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_REQ_ADR_SHIFT)
#define CSW_C2MC_REQ_ADR_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_REQ_ADR_ROW                    0

#define CSW_C2MC_REQ_BE_SHIFT                   _MK_SHIFT_CONST(32)
#define CSW_C2MC_REQ_BE_FIELD                   (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_REQ_BE_SHIFT)
#define CSW_C2MC_REQ_BE_RANGE                   _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CSW_C2MC_REQ_BE_ROW                     0

#define CSW_C2MC_REQ_WDO_SHIFT                  _MK_SHIFT_CONST(64)
#define CSW_C2MC_REQ_WDO_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_REQ_WDO_SHIFT)
#define CSW_C2MC_REQ_WDO_RANGE                  _MK_SHIFT_CONST(319):_MK_SHIFT_CONST(64)
#define CSW_C2MC_REQ_WDO_ROW                    0

#define CSW_C2MC_REQ_TAG_SHIFT                  _MK_SHIFT_CONST(320)
#define CSW_C2MC_REQ_TAG_FIELD                  (_MK_MASK_CONST(0x1) << CSW_C2MC_REQ_TAG_SHIFT)
#define CSW_C2MC_REQ_TAG_RANGE                  _MK_SHIFT_CONST(320):_MK_SHIFT_CONST(320)
#define CSW_C2MC_REQ_TAG_ROW                    0


// Packet CSW_C2MC_BP_REQ
#define CSW_C2MC_BP_REQ_SIZE 337

#define CSW_C2MC_BP_REQ_BASEADR_SHIFT                   _MK_SHIFT_CONST(0)
#define CSW_C2MC_BP_REQ_BASEADR_FIELD                   (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_BP_REQ_BASEADR_SHIFT)
#define CSW_C2MC_BP_REQ_BASEADR_RANGE                   _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_BP_REQ_BASEADR_ROW                     0

#define CSW_C2MC_BP_REQ_PITCH_SHIFT                     _MK_SHIFT_CONST(32)
#define CSW_C2MC_BP_REQ_PITCH_FIELD                     (_MK_MASK_CONST(0xffff) << CSW_C2MC_BP_REQ_PITCH_SHIFT)
#define CSW_C2MC_BP_REQ_PITCH_RANGE                     _MK_SHIFT_CONST(47):_MK_SHIFT_CONST(32)
#define CSW_C2MC_BP_REQ_PITCH_ROW                       0

#define CSW_C2MC_BP_REQ_BE_SHIFT                        _MK_SHIFT_CONST(48)
#define CSW_C2MC_BP_REQ_BE_FIELD                        (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_BP_REQ_BE_SHIFT)
#define CSW_C2MC_BP_REQ_BE_RANGE                        _MK_SHIFT_CONST(79):_MK_SHIFT_CONST(48)
#define CSW_C2MC_BP_REQ_BE_ROW                  0

#define CSW_C2MC_BP_REQ_WDO_SHIFT                       _MK_SHIFT_CONST(80)
#define CSW_C2MC_BP_REQ_WDO_FIELD                       (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_BP_REQ_WDO_SHIFT)
#define CSW_C2MC_BP_REQ_WDO_RANGE                       _MK_SHIFT_CONST(335):_MK_SHIFT_CONST(80)
#define CSW_C2MC_BP_REQ_WDO_ROW                 0

#define CSW_C2MC_BP_REQ_TAG_SHIFT                       _MK_SHIFT_CONST(336)
#define CSW_C2MC_BP_REQ_TAG_FIELD                       (_MK_MASK_CONST(0x1) << CSW_C2MC_BP_REQ_TAG_SHIFT)
#define CSW_C2MC_BP_REQ_TAG_RANGE                       _MK_SHIFT_CONST(336):_MK_SHIFT_CONST(336)
#define CSW_C2MC_BP_REQ_TAG_ROW                 0


// Packet CSW_C2MC_ADRXY
#define CSW_C2MC_ADRXY_SIZE 30

#define CSW_C2MC_ADRXY_OFFX_SHIFT                       _MK_SHIFT_CONST(0)
#define CSW_C2MC_ADRXY_OFFX_FIELD                       (_MK_MASK_CONST(0xffff) << CSW_C2MC_ADRXY_OFFX_SHIFT)
#define CSW_C2MC_ADRXY_OFFX_RANGE                       _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define CSW_C2MC_ADRXY_OFFX_ROW                 0

#define CSW_C2MC_ADRXY_OFFY_SHIFT                       _MK_SHIFT_CONST(16)
#define CSW_C2MC_ADRXY_OFFY_FIELD                       (_MK_MASK_CONST(0x3fff) << CSW_C2MC_ADRXY_OFFY_SHIFT)
#define CSW_C2MC_ADRXY_OFFY_RANGE                       _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(16)
#define CSW_C2MC_ADRXY_OFFY_ROW                 0


// Packet CSW_C2MC_TILE
#define CSW_C2MC_TILE_SIZE 33

#define CSW_C2MC_TILE_LINADR_SHIFT                      _MK_SHIFT_CONST(0)
#define CSW_C2MC_TILE_LINADR_FIELD                      (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_TILE_LINADR_SHIFT)
#define CSW_C2MC_TILE_LINADR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_TILE_LINADR_ROW                        0

#define CSW_C2MC_TILE_TMODE_SHIFT                       _MK_SHIFT_CONST(32)
#define CSW_C2MC_TILE_TMODE_FIELD                       (_MK_MASK_CONST(0x1) << CSW_C2MC_TILE_TMODE_SHIFT)
#define CSW_C2MC_TILE_TMODE_RANGE                       _MK_SHIFT_CONST(32):_MK_SHIFT_CONST(32)
#define CSW_C2MC_TILE_TMODE_ROW                 0
#define CSW_C2MC_TILE_TMODE_LINEAR                      _MK_ENUM_CONST(0)
#define CSW_C2MC_TILE_TMODE_TILED                       _MK_ENUM_CONST(1)


// Packet CSW_C2MC_XDI
#define CSW_C2MC_XDI_SIZE 1

// fake data
#define CSW_C2MC_XDI_XDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CSW_C2MC_XDI_XDI_FIELD                  (_MK_MASK_CONST(0x1) << CSW_C2MC_XDI_XDI_SHIFT)
#define CSW_C2MC_XDI_XDI_RANGE                  _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CSW_C2MC_XDI_XDI_ROW                    0


// Packet CSW_C2MC_HP
#define CSW_C2MC_HP_SIZE 32

// high-priority threshold
#define CSW_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CSW_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_HP_HPTH_SHIFT)
#define CSW_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_HP_HPTH_ROW                    0


// Packet CSW_C2MC_WCOAL
#define CSW_C2MC_WCOAL_SIZE 32

// write-coalescing time-out
#define CSW_C2MC_WCOAL_WCOALTM_SHIFT                    _MK_SHIFT_CONST(0)
#define CSW_C2MC_WCOAL_WCOALTM_FIELD                    (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_WCOAL_WCOALTM_SHIFT)
#define CSW_C2MC_WCOAL_WCOALTM_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_WCOAL_WCOALTM_ROW                      0


// Packet CBR_C2MC_RESET
#define CBR_C2MC_RESET_SIZE 1

#define CBR_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CBR_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CBR_C2MC_RESET_RSTN_SHIFT)
#define CBR_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBR_C2MC_RESET_RSTN_ROW                 0


// Packet CBR_C2MC_REQP
#define CBR_C2MC_REQP_SIZE 263

#define CBR_C2MC_REQP_ADR_SHIFT                 _MK_SHIFT_CONST(0)
#define CBR_C2MC_REQP_ADR_FIELD                 (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_ADR_SHIFT)
#define CBR_C2MC_REQP_ADR_RANGE                 _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBR_C2MC_REQP_ADR_ROW                   0

#define CBR_C2MC_REQP_ADRU_SHIFT                        _MK_SHIFT_CONST(32)
#define CBR_C2MC_REQP_ADRU_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_ADRU_SHIFT)
#define CBR_C2MC_REQP_ADRU_RANGE                        _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CBR_C2MC_REQP_ADRU_ROW                  0

#define CBR_C2MC_REQP_ADRV_SHIFT                        _MK_SHIFT_CONST(64)
#define CBR_C2MC_REQP_ADRV_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_ADRV_SHIFT)
#define CBR_C2MC_REQP_ADRV_RANGE                        _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define CBR_C2MC_REQP_ADRV_ROW                  0

#define CBR_C2MC_REQP_LS_SHIFT                  _MK_SHIFT_CONST(96)
#define CBR_C2MC_REQP_LS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_LS_SHIFT)
#define CBR_C2MC_REQP_LS_RANGE                  _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(96)
#define CBR_C2MC_REQP_LS_ROW                    0

#define CBR_C2MC_REQP_LSUV_SHIFT                        _MK_SHIFT_CONST(128)
#define CBR_C2MC_REQP_LSUV_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_LSUV_SHIFT)
#define CBR_C2MC_REQP_LSUV_RANGE                        _MK_SHIFT_CONST(159):_MK_SHIFT_CONST(128)
#define CBR_C2MC_REQP_LSUV_ROW                  0

#define CBR_C2MC_REQP_HS_SHIFT                  _MK_SHIFT_CONST(160)
#define CBR_C2MC_REQP_HS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_HS_SHIFT)
#define CBR_C2MC_REQP_HS_RANGE                  _MK_SHIFT_CONST(191):_MK_SHIFT_CONST(160)
#define CBR_C2MC_REQP_HS_ROW                    0

#define CBR_C2MC_REQP_VS_SHIFT                  _MK_SHIFT_CONST(192)
#define CBR_C2MC_REQP_VS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_VS_SHIFT)
#define CBR_C2MC_REQP_VS_RANGE                  _MK_SHIFT_CONST(223):_MK_SHIFT_CONST(192)
#define CBR_C2MC_REQP_VS_ROW                    0

#define CBR_C2MC_REQP_DL_SHIFT                  _MK_SHIFT_CONST(224)
#define CBR_C2MC_REQP_DL_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_DL_SHIFT)
#define CBR_C2MC_REQP_DL_RANGE                  _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(224)
#define CBR_C2MC_REQP_DL_ROW                    0

#define CBR_C2MC_REQP_HD_SHIFT                  _MK_SHIFT_CONST(256)
#define CBR_C2MC_REQP_HD_FIELD                  (_MK_MASK_CONST(0x1) << CBR_C2MC_REQP_HD_SHIFT)
#define CBR_C2MC_REQP_HD_RANGE                  _MK_SHIFT_CONST(256):_MK_SHIFT_CONST(256)
#define CBR_C2MC_REQP_HD_ROW                    0

#define CBR_C2MC_REQP_VD_SHIFT                  _MK_SHIFT_CONST(257)
#define CBR_C2MC_REQP_VD_FIELD                  (_MK_MASK_CONST(0x1) << CBR_C2MC_REQP_VD_SHIFT)
#define CBR_C2MC_REQP_VD_RANGE                  _MK_SHIFT_CONST(257):_MK_SHIFT_CONST(257)
#define CBR_C2MC_REQP_VD_ROW                    0

#define CBR_C2MC_REQP_VX2_SHIFT                 _MK_SHIFT_CONST(258)
#define CBR_C2MC_REQP_VX2_FIELD                 (_MK_MASK_CONST(0x1) << CBR_C2MC_REQP_VX2_SHIFT)
#define CBR_C2MC_REQP_VX2_RANGE                 _MK_SHIFT_CONST(258):_MK_SHIFT_CONST(258)
#define CBR_C2MC_REQP_VX2_ROW                   0

#define CBR_C2MC_REQP_LP_SHIFT                  _MK_SHIFT_CONST(259)
#define CBR_C2MC_REQP_LP_FIELD                  (_MK_MASK_CONST(0x1) << CBR_C2MC_REQP_LP_SHIFT)
#define CBR_C2MC_REQP_LP_RANGE                  _MK_SHIFT_CONST(259):_MK_SHIFT_CONST(259)
#define CBR_C2MC_REQP_LP_ROW                    0

#define CBR_C2MC_REQP_YUV_SHIFT                 _MK_SHIFT_CONST(260)
#define CBR_C2MC_REQP_YUV_FIELD                 (_MK_MASK_CONST(0x7) << CBR_C2MC_REQP_YUV_SHIFT)
#define CBR_C2MC_REQP_YUV_RANGE                 _MK_SHIFT_CONST(262):_MK_SHIFT_CONST(260)
#define CBR_C2MC_REQP_YUV_ROW                   0


// Packet CBR_C2MC_ADRXY
#define CBR_C2MC_ADRXY_SIZE 44

#define CBR_C2MC_ADRXY_OFFX_SHIFT                       _MK_SHIFT_CONST(0)
#define CBR_C2MC_ADRXY_OFFX_FIELD                       (_MK_MASK_CONST(0xffff) << CBR_C2MC_ADRXY_OFFX_SHIFT)
#define CBR_C2MC_ADRXY_OFFX_RANGE                       _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define CBR_C2MC_ADRXY_OFFX_ROW                 0

#define CBR_C2MC_ADRXY_OFFY_SHIFT                       _MK_SHIFT_CONST(16)
#define CBR_C2MC_ADRXY_OFFY_FIELD                       (_MK_MASK_CONST(0x3fff) << CBR_C2MC_ADRXY_OFFY_SHIFT)
#define CBR_C2MC_ADRXY_OFFY_RANGE                       _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(16)
#define CBR_C2MC_ADRXY_OFFY_ROW                 0

#define CBR_C2MC_ADRXY_OFFYUV_SHIFT                     _MK_SHIFT_CONST(30)
#define CBR_C2MC_ADRXY_OFFYUV_FIELD                     (_MK_MASK_CONST(0x3fff) << CBR_C2MC_ADRXY_OFFYUV_SHIFT)
#define CBR_C2MC_ADRXY_OFFYUV_RANGE                     _MK_SHIFT_CONST(43):_MK_SHIFT_CONST(30)
#define CBR_C2MC_ADRXY_OFFYUV_ROW                       0


// Packet CBR_C2MC_TILE
#define CBR_C2MC_TILE_SIZE 98

#define CBR_C2MC_TILE_LINADR_SHIFT                      _MK_SHIFT_CONST(0)
#define CBR_C2MC_TILE_LINADR_FIELD                      (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_TILE_LINADR_SHIFT)
#define CBR_C2MC_TILE_LINADR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBR_C2MC_TILE_LINADR_ROW                        0

#define CBR_C2MC_TILE_LINADRU_SHIFT                     _MK_SHIFT_CONST(32)
#define CBR_C2MC_TILE_LINADRU_FIELD                     (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_TILE_LINADRU_SHIFT)
#define CBR_C2MC_TILE_LINADRU_RANGE                     _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CBR_C2MC_TILE_LINADRU_ROW                       0

#define CBR_C2MC_TILE_LINADRV_SHIFT                     _MK_SHIFT_CONST(64)
#define CBR_C2MC_TILE_LINADRV_FIELD                     (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_TILE_LINADRV_SHIFT)
#define CBR_C2MC_TILE_LINADRV_RANGE                     _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define CBR_C2MC_TILE_LINADRV_ROW                       0

#define CBR_C2MC_TILE_TMODE_SHIFT                       _MK_SHIFT_CONST(96)
#define CBR_C2MC_TILE_TMODE_FIELD                       (_MK_MASK_CONST(0x1) << CBR_C2MC_TILE_TMODE_SHIFT)
#define CBR_C2MC_TILE_TMODE_RANGE                       _MK_SHIFT_CONST(96):_MK_SHIFT_CONST(96)
#define CBR_C2MC_TILE_TMODE_ROW                 0
#define CBR_C2MC_TILE_TMODE_LINEAR                      _MK_ENUM_CONST(0)
#define CBR_C2MC_TILE_TMODE_TILED                       _MK_ENUM_CONST(1)

#define CBR_C2MC_TILE_TMODEUV_SHIFT                     _MK_SHIFT_CONST(97)
#define CBR_C2MC_TILE_TMODEUV_FIELD                     (_MK_MASK_CONST(0x1) << CBR_C2MC_TILE_TMODEUV_SHIFT)
#define CBR_C2MC_TILE_TMODEUV_RANGE                     _MK_SHIFT_CONST(97):_MK_SHIFT_CONST(97)
#define CBR_C2MC_TILE_TMODEUV_ROW                       0
#define CBR_C2MC_TILE_TMODEUV_LINEAR                    _MK_ENUM_CONST(0)
#define CBR_C2MC_TILE_TMODEUV_TILED                     _MK_ENUM_CONST(1)


// Packet CBR_C2MC_RDYP
#define CBR_C2MC_RDYP_SIZE 1

// fake data
#define CBR_C2MC_RDYP_RDYP_SHIFT                        _MK_SHIFT_CONST(0)
#define CBR_C2MC_RDYP_RDYP_FIELD                        (_MK_MASK_CONST(0x1) << CBR_C2MC_RDYP_RDYP_SHIFT)
#define CBR_C2MC_RDYP_RDYP_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBR_C2MC_RDYP_RDYP_ROW                  0


// Packet CBR_C2MC_OUTSTD
#define CBR_C2MC_OUTSTD_SIZE 1

#define CBR_C2MC_OUTSTD_OUTSTD_SHIFT                    _MK_SHIFT_CONST(0)
#define CBR_C2MC_OUTSTD_OUTSTD_FIELD                    (_MK_MASK_CONST(0x1) << CBR_C2MC_OUTSTD_OUTSTD_SHIFT)
#define CBR_C2MC_OUTSTD_OUTSTD_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBR_C2MC_OUTSTD_OUTSTD_ROW                      0


// Packet CBR_C2MC_STOP
#define CBR_C2MC_STOP_SIZE 1

#define CBR_C2MC_STOP_STOP_SHIFT                        _MK_SHIFT_CONST(0)
#define CBR_C2MC_STOP_STOP_FIELD                        (_MK_MASK_CONST(0x1) << CBR_C2MC_STOP_STOP_SHIFT)
#define CBR_C2MC_STOP_STOP_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBR_C2MC_STOP_STOP_ROW                  0


// Packet CBR_C2MC_RDI
#define CBR_C2MC_RDI_SIZE 262

#define CBR_C2MC_RDI_RDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CBR_C2MC_RDI_RDI_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_RDI_RDI_SHIFT)
#define CBR_C2MC_RDI_RDI_RANGE                  _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(0)
#define CBR_C2MC_RDI_RDI_ROW                    0

#define CBR_C2MC_RDI_RDILST_SHIFT                       _MK_SHIFT_CONST(256)
#define CBR_C2MC_RDI_RDILST_FIELD                       (_MK_MASK_CONST(0x1) << CBR_C2MC_RDI_RDILST_SHIFT)
#define CBR_C2MC_RDI_RDILST_RANGE                       _MK_SHIFT_CONST(256):_MK_SHIFT_CONST(256)
#define CBR_C2MC_RDI_RDILST_ROW                 0

#define CBR_C2MC_RDI_RDINB_SHIFT                        _MK_SHIFT_CONST(257)
#define CBR_C2MC_RDI_RDINB_FIELD                        (_MK_MASK_CONST(0x1f) << CBR_C2MC_RDI_RDINB_SHIFT)
#define CBR_C2MC_RDI_RDINB_RANGE                        _MK_SHIFT_CONST(261):_MK_SHIFT_CONST(257)
#define CBR_C2MC_RDI_RDINB_ROW                  0


// Packet CBR_C2MC_DOREQ
#define CBR_C2MC_DOREQ_SIZE 64

#define CBR_C2MC_DOREQ_ADR_SHIFT                        _MK_SHIFT_CONST(0)
#define CBR_C2MC_DOREQ_ADR_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_DOREQ_ADR_SHIFT)
#define CBR_C2MC_DOREQ_ADR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBR_C2MC_DOREQ_ADR_ROW                  0

#define CBR_C2MC_DOREQ_LS_SHIFT                 _MK_SHIFT_CONST(32)
#define CBR_C2MC_DOREQ_LS_FIELD                 (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_DOREQ_LS_SHIFT)
#define CBR_C2MC_DOREQ_LS_RANGE                 _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CBR_C2MC_DOREQ_LS_ROW                   0


// Packet CBR_C2MC_HP
#define CBR_C2MC_HP_SIZE 38

// high-priority threshold
#define CBR_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CBR_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_HP_HPTH_SHIFT)
#define CBR_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBR_C2MC_HP_HPTH_ROW                    0

// high-priority timer
#define CBR_C2MC_HP_HPTM_SHIFT                  _MK_SHIFT_CONST(32)
#define CBR_C2MC_HP_HPTM_FIELD                  (_MK_MASK_CONST(0x3f) << CBR_C2MC_HP_HPTM_SHIFT)
#define CBR_C2MC_HP_HPTM_RANGE                  _MK_SHIFT_CONST(37):_MK_SHIFT_CONST(32)
#define CBR_C2MC_HP_HPTM_ROW                    0


// Packet CBW_C2MC_RESET
#define CBW_C2MC_RESET_SIZE 1

#define CBW_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CBW_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CBW_C2MC_RESET_RSTN_SHIFT)
#define CBW_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBW_C2MC_RESET_RSTN_ROW                 0


// Packet CBW_C2MC_REQP
#define CBW_C2MC_REQP_SIZE 134

#define CBW_C2MC_REQP_ADR_SHIFT                 _MK_SHIFT_CONST(0)
#define CBW_C2MC_REQP_ADR_FIELD                 (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_REQP_ADR_SHIFT)
#define CBW_C2MC_REQP_ADR_RANGE                 _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBW_C2MC_REQP_ADR_ROW                   0

#define CBW_C2MC_REQP_LS_SHIFT                  _MK_SHIFT_CONST(32)
#define CBW_C2MC_REQP_LS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_REQP_LS_SHIFT)
#define CBW_C2MC_REQP_LS_RANGE                  _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CBW_C2MC_REQP_LS_ROW                    0

#define CBW_C2MC_REQP_HS_SHIFT                  _MK_SHIFT_CONST(64)
#define CBW_C2MC_REQP_HS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_REQP_HS_SHIFT)
#define CBW_C2MC_REQP_HS_RANGE                  _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define CBW_C2MC_REQP_HS_ROW                    0

#define CBW_C2MC_REQP_VS_SHIFT                  _MK_SHIFT_CONST(96)
#define CBW_C2MC_REQP_VS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_REQP_VS_SHIFT)
#define CBW_C2MC_REQP_VS_RANGE                  _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(96)
#define CBW_C2MC_REQP_VS_ROW                    0

#define CBW_C2MC_REQP_HD_SHIFT                  _MK_SHIFT_CONST(128)
#define CBW_C2MC_REQP_HD_FIELD                  (_MK_MASK_CONST(0x1) << CBW_C2MC_REQP_HD_SHIFT)
#define CBW_C2MC_REQP_HD_RANGE                  _MK_SHIFT_CONST(128):_MK_SHIFT_CONST(128)
#define CBW_C2MC_REQP_HD_ROW                    0

#define CBW_C2MC_REQP_VD_SHIFT                  _MK_SHIFT_CONST(129)
#define CBW_C2MC_REQP_VD_FIELD                  (_MK_MASK_CONST(0x1) << CBW_C2MC_REQP_VD_SHIFT)
#define CBW_C2MC_REQP_VD_RANGE                  _MK_SHIFT_CONST(129):_MK_SHIFT_CONST(129)
#define CBW_C2MC_REQP_VD_ROW                    0

#define CBW_C2MC_REQP_BPP_SHIFT                 _MK_SHIFT_CONST(130)
#define CBW_C2MC_REQP_BPP_FIELD                 (_MK_MASK_CONST(0x3) << CBW_C2MC_REQP_BPP_SHIFT)
#define CBW_C2MC_REQP_BPP_RANGE                 _MK_SHIFT_CONST(131):_MK_SHIFT_CONST(130)
#define CBW_C2MC_REQP_BPP_ROW                   0

#define CBW_C2MC_REQP_XY_SHIFT                  _MK_SHIFT_CONST(132)
#define CBW_C2MC_REQP_XY_FIELD                  (_MK_MASK_CONST(0x1) << CBW_C2MC_REQP_XY_SHIFT)
#define CBW_C2MC_REQP_XY_RANGE                  _MK_SHIFT_CONST(132):_MK_SHIFT_CONST(132)
#define CBW_C2MC_REQP_XY_ROW                    0

#define CBW_C2MC_REQP_PK_SHIFT                  _MK_SHIFT_CONST(133)
#define CBW_C2MC_REQP_PK_FIELD                  (_MK_MASK_CONST(0x1) << CBW_C2MC_REQP_PK_SHIFT)
#define CBW_C2MC_REQP_PK_RANGE                  _MK_SHIFT_CONST(133):_MK_SHIFT_CONST(133)
#define CBW_C2MC_REQP_PK_ROW                    0


// Packet CBW_C2MC_ADRXY
#define CBW_C2MC_ADRXY_SIZE 30

#define CBW_C2MC_ADRXY_OFFX_SHIFT                       _MK_SHIFT_CONST(0)
#define CBW_C2MC_ADRXY_OFFX_FIELD                       (_MK_MASK_CONST(0xffff) << CBW_C2MC_ADRXY_OFFX_SHIFT)
#define CBW_C2MC_ADRXY_OFFX_RANGE                       _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define CBW_C2MC_ADRXY_OFFX_ROW                 0

#define CBW_C2MC_ADRXY_OFFY_SHIFT                       _MK_SHIFT_CONST(16)
#define CBW_C2MC_ADRXY_OFFY_FIELD                       (_MK_MASK_CONST(0x3fff) << CBW_C2MC_ADRXY_OFFY_SHIFT)
#define CBW_C2MC_ADRXY_OFFY_RANGE                       _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(16)
#define CBW_C2MC_ADRXY_OFFY_ROW                 0


// Packet CBW_C2MC_TILE
#define CBW_C2MC_TILE_SIZE 33

#define CBW_C2MC_TILE_LINADR_SHIFT                      _MK_SHIFT_CONST(0)
#define CBW_C2MC_TILE_LINADR_FIELD                      (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_TILE_LINADR_SHIFT)
#define CBW_C2MC_TILE_LINADR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBW_C2MC_TILE_LINADR_ROW                        0

#define CBW_C2MC_TILE_TMODE_SHIFT                       _MK_SHIFT_CONST(32)
#define CBW_C2MC_TILE_TMODE_FIELD                       (_MK_MASK_CONST(0x1) << CBW_C2MC_TILE_TMODE_SHIFT)
#define CBW_C2MC_TILE_TMODE_RANGE                       _MK_SHIFT_CONST(32):_MK_SHIFT_CONST(32)
#define CBW_C2MC_TILE_TMODE_ROW                 0
#define CBW_C2MC_TILE_TMODE_LINEAR                      _MK_ENUM_CONST(0)
#define CBW_C2MC_TILE_TMODE_TILED                       _MK_ENUM_CONST(1)


// Packet CBW_C2MC_RDYP
#define CBW_C2MC_RDYP_SIZE 1

// fake data
#define CBW_C2MC_RDYP_RDYP_SHIFT                        _MK_SHIFT_CONST(0)
#define CBW_C2MC_RDYP_RDYP_FIELD                        (_MK_MASK_CONST(0x1) << CBW_C2MC_RDYP_RDYP_SHIFT)
#define CBW_C2MC_RDYP_RDYP_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBW_C2MC_RDYP_RDYP_ROW                  0


// Packet CBW_C2MC_STOP
#define CBW_C2MC_STOP_SIZE 1

#define CBW_C2MC_STOP_STOP_SHIFT                        _MK_SHIFT_CONST(0)
#define CBW_C2MC_STOP_STOP_FIELD                        (_MK_MASK_CONST(0x1) << CBW_C2MC_STOP_STOP_SHIFT)
#define CBW_C2MC_STOP_STOP_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBW_C2MC_STOP_STOP_ROW                  0


// Packet CBW_C2MC_XDI
#define CBW_C2MC_XDI_SIZE 1

// fake data
#define CBW_C2MC_XDI_XDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CBW_C2MC_XDI_XDI_FIELD                  (_MK_MASK_CONST(0x1) << CBW_C2MC_XDI_XDI_SHIFT)
#define CBW_C2MC_XDI_XDI_RANGE                  _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBW_C2MC_XDI_XDI_ROW                    0


// Packet CBW_C2MC_DOREQ
#define CBW_C2MC_DOREQ_SIZE 321

#define CBW_C2MC_DOREQ_ADR_SHIFT                        _MK_SHIFT_CONST(0)
#define CBW_C2MC_DOREQ_ADR_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_DOREQ_ADR_SHIFT)
#define CBW_C2MC_DOREQ_ADR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBW_C2MC_DOREQ_ADR_ROW                  0

#define CBW_C2MC_DOREQ_BE_SHIFT                 _MK_SHIFT_CONST(32)
#define CBW_C2MC_DOREQ_BE_FIELD                 (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_DOREQ_BE_SHIFT)
#define CBW_C2MC_DOREQ_BE_RANGE                 _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CBW_C2MC_DOREQ_BE_ROW                   0

#define CBW_C2MC_DOREQ_WDO_SHIFT                        _MK_SHIFT_CONST(64)
#define CBW_C2MC_DOREQ_WDO_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_DOREQ_WDO_SHIFT)
#define CBW_C2MC_DOREQ_WDO_RANGE                        _MK_SHIFT_CONST(319):_MK_SHIFT_CONST(64)
#define CBW_C2MC_DOREQ_WDO_ROW                  0

#define CBW_C2MC_DOREQ_TAG_SHIFT                        _MK_SHIFT_CONST(320)
#define CBW_C2MC_DOREQ_TAG_FIELD                        (_MK_MASK_CONST(0x1) << CBW_C2MC_DOREQ_TAG_SHIFT)
#define CBW_C2MC_DOREQ_TAG_RANGE                        _MK_SHIFT_CONST(320):_MK_SHIFT_CONST(320)
#define CBW_C2MC_DOREQ_TAG_ROW                  0


// Packet CBW_C2MC_HP
#define CBW_C2MC_HP_SIZE 32

// high-priority threshold
#define CBW_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CBW_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_HP_HPTH_SHIFT)
#define CBW_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBW_C2MC_HP_HPTH_ROW                    0


// Packet CBW_C2MC_WCOAL
#define CBW_C2MC_WCOAL_SIZE 32

// write-coalescing time-out
#define CBW_C2MC_WCOAL_WCOALTM_SHIFT                    _MK_SHIFT_CONST(0)
#define CBW_C2MC_WCOAL_WCOALTM_FIELD                    (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_WCOAL_WCOALTM_SHIFT)
#define CBW_C2MC_WCOAL_WCOALTM_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBW_C2MC_WCOAL_WCOALTM_ROW                      0


// Packet CCR_C2MC_RESET
#define CCR_C2MC_RESET_SIZE 1

#define CCR_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CCR_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CCR_C2MC_RESET_RSTN_SHIFT)
#define CCR_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CCR_C2MC_RESET_RSTN_ROW                 0


// Packet CCR_C2MC_REQ
#define CCR_C2MC_REQ_SIZE 101

#define CCR_C2MC_REQ_ADR_SHIFT                  _MK_SHIFT_CONST(0)
#define CCR_C2MC_REQ_ADR_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_REQ_ADR_SHIFT)
#define CCR_C2MC_REQ_ADR_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCR_C2MC_REQ_ADR_ROW                    0

#define CCR_C2MC_REQ_LS_SHIFT                   _MK_SHIFT_CONST(32)
#define CCR_C2MC_REQ_LS_FIELD                   (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_REQ_LS_SHIFT)
#define CCR_C2MC_REQ_LS_RANGE                   _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CCR_C2MC_REQ_LS_ROW                     0

// HI is apparently a reserved keyword
#define CCR_C2MC_REQ_HINC_SHIFT                 _MK_SHIFT_CONST(64)
#define CCR_C2MC_REQ_HINC_FIELD                 (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_REQ_HINC_SHIFT)
#define CCR_C2MC_REQ_HINC_RANGE                 _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define CCR_C2MC_REQ_HINC_ROW                   0

#define CCR_C2MC_REQ_ACMD_SHIFT                 _MK_SHIFT_CONST(96)
#define CCR_C2MC_REQ_ACMD_FIELD                 (_MK_MASK_CONST(0x3) << CCR_C2MC_REQ_ACMD_SHIFT)
#define CCR_C2MC_REQ_ACMD_RANGE                 _MK_SHIFT_CONST(97):_MK_SHIFT_CONST(96)
#define CCR_C2MC_REQ_ACMD_ROW                   0

#define CCR_C2MC_REQ_LN_SHIFT                   _MK_SHIFT_CONST(98)
#define CCR_C2MC_REQ_LN_FIELD                   (_MK_MASK_CONST(0x1) << CCR_C2MC_REQ_LN_SHIFT)
#define CCR_C2MC_REQ_LN_RANGE                   _MK_SHIFT_CONST(98):_MK_SHIFT_CONST(98)
#define CCR_C2MC_REQ_LN_ROW                     0

#define CCR_C2MC_REQ_HD_SHIFT                   _MK_SHIFT_CONST(99)
#define CCR_C2MC_REQ_HD_FIELD                   (_MK_MASK_CONST(0x1) << CCR_C2MC_REQ_HD_SHIFT)
#define CCR_C2MC_REQ_HD_RANGE                   _MK_SHIFT_CONST(99):_MK_SHIFT_CONST(99)
#define CCR_C2MC_REQ_HD_ROW                     0

#define CCR_C2MC_REQ_VD_SHIFT                   _MK_SHIFT_CONST(100)
#define CCR_C2MC_REQ_VD_FIELD                   (_MK_MASK_CONST(0x1) << CCR_C2MC_REQ_VD_SHIFT)
#define CCR_C2MC_REQ_VD_RANGE                   _MK_SHIFT_CONST(100):_MK_SHIFT_CONST(100)
#define CCR_C2MC_REQ_VD_ROW                     0


// Packet CCR_C2MC_RDI
#define CCR_C2MC_RDI_SIZE 256

#define CCR_C2MC_RDI_RDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CCR_C2MC_RDI_RDI_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_RDI_RDI_SHIFT)
#define CCR_C2MC_RDI_RDI_RANGE                  _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(0)
#define CCR_C2MC_RDI_RDI_ROW                    0


// Packet CCR_C2MC_HP
#define CCR_C2MC_HP_SIZE 38

// high-priority threshold
#define CCR_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CCR_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_HP_HPTH_SHIFT)
#define CCR_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCR_C2MC_HP_HPTH_ROW                    0

// high-priority timer
#define CCR_C2MC_HP_HPTM_SHIFT                  _MK_SHIFT_CONST(32)
#define CCR_C2MC_HP_HPTM_FIELD                  (_MK_MASK_CONST(0x3f) << CCR_C2MC_HP_HPTM_SHIFT)
#define CCR_C2MC_HP_HPTM_RANGE                  _MK_SHIFT_CONST(37):_MK_SHIFT_CONST(32)
#define CCR_C2MC_HP_HPTM_ROW                    0


// Packet CCW_C2MC_RESET
#define CCW_C2MC_RESET_SIZE 1

#define CCW_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CCW_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CCW_C2MC_RESET_RSTN_SHIFT)
#define CCW_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CCW_C2MC_RESET_RSTN_ROW                 0


// Packet CCW_C2MC_REQ
#define CCW_C2MC_REQ_SIZE 417

#define CCW_C2MC_REQ_ADR_SHIFT                  _MK_SHIFT_CONST(0)
#define CCW_C2MC_REQ_ADR_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_REQ_ADR_SHIFT)
#define CCW_C2MC_REQ_ADR_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCW_C2MC_REQ_ADR_ROW                    0

#define CCW_C2MC_REQ_LS_SHIFT                   _MK_SHIFT_CONST(32)
#define CCW_C2MC_REQ_LS_FIELD                   (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_REQ_LS_SHIFT)
#define CCW_C2MC_REQ_LS_RANGE                   _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CCW_C2MC_REQ_LS_ROW                     0

// HI is apparently a reserved keyword
#define CCW_C2MC_REQ_HINC_SHIFT                 _MK_SHIFT_CONST(64)
#define CCW_C2MC_REQ_HINC_FIELD                 (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_REQ_HINC_SHIFT)
#define CCW_C2MC_REQ_HINC_RANGE                 _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define CCW_C2MC_REQ_HINC_ROW                   0

#define CCW_C2MC_REQ_ACMD_SHIFT                 _MK_SHIFT_CONST(96)
#define CCW_C2MC_REQ_ACMD_FIELD                 (_MK_MASK_CONST(0x3) << CCW_C2MC_REQ_ACMD_SHIFT)
#define CCW_C2MC_REQ_ACMD_RANGE                 _MK_SHIFT_CONST(97):_MK_SHIFT_CONST(96)
#define CCW_C2MC_REQ_ACMD_ROW                   0

#define CCW_C2MC_REQ_LN_SHIFT                   _MK_SHIFT_CONST(98)
#define CCW_C2MC_REQ_LN_FIELD                   (_MK_MASK_CONST(0x1) << CCW_C2MC_REQ_LN_SHIFT)
#define CCW_C2MC_REQ_LN_RANGE                   _MK_SHIFT_CONST(98):_MK_SHIFT_CONST(98)
#define CCW_C2MC_REQ_LN_ROW                     0

#define CCW_C2MC_REQ_HD_SHIFT                   _MK_SHIFT_CONST(99)
#define CCW_C2MC_REQ_HD_FIELD                   (_MK_MASK_CONST(0x1) << CCW_C2MC_REQ_HD_SHIFT)
#define CCW_C2MC_REQ_HD_RANGE                   _MK_SHIFT_CONST(99):_MK_SHIFT_CONST(99)
#define CCW_C2MC_REQ_HD_ROW                     0

#define CCW_C2MC_REQ_VD_SHIFT                   _MK_SHIFT_CONST(100)
#define CCW_C2MC_REQ_VD_FIELD                   (_MK_MASK_CONST(0x1) << CCW_C2MC_REQ_VD_SHIFT)
#define CCW_C2MC_REQ_VD_RANGE                   _MK_SHIFT_CONST(100):_MK_SHIFT_CONST(100)
#define CCW_C2MC_REQ_VD_ROW                     0

#define CCW_C2MC_REQ_BPP_SHIFT                  _MK_SHIFT_CONST(101)
#define CCW_C2MC_REQ_BPP_FIELD                  (_MK_MASK_CONST(0x3) << CCW_C2MC_REQ_BPP_SHIFT)
#define CCW_C2MC_REQ_BPP_RANGE                  _MK_SHIFT_CONST(102):_MK_SHIFT_CONST(101)
#define CCW_C2MC_REQ_BPP_ROW                    0

#define CCW_C2MC_REQ_XY_SHIFT                   _MK_SHIFT_CONST(103)
#define CCW_C2MC_REQ_XY_FIELD                   (_MK_MASK_CONST(0x1) << CCW_C2MC_REQ_XY_SHIFT)
#define CCW_C2MC_REQ_XY_RANGE                   _MK_SHIFT_CONST(103):_MK_SHIFT_CONST(103)
#define CCW_C2MC_REQ_XY_ROW                     0

#define CCW_C2MC_REQ_BE_SHIFT                   _MK_SHIFT_CONST(128)
#define CCW_C2MC_REQ_BE_FIELD                   (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_REQ_BE_SHIFT)
#define CCW_C2MC_REQ_BE_RANGE                   _MK_SHIFT_CONST(159):_MK_SHIFT_CONST(128)
#define CCW_C2MC_REQ_BE_ROW                     0

#define CCW_C2MC_REQ_WDO_SHIFT                  _MK_SHIFT_CONST(160)
#define CCW_C2MC_REQ_WDO_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_REQ_WDO_SHIFT)
#define CCW_C2MC_REQ_WDO_RANGE                  _MK_SHIFT_CONST(415):_MK_SHIFT_CONST(160)
#define CCW_C2MC_REQ_WDO_ROW                    0

#define CCW_C2MC_REQ_TAG_SHIFT                  _MK_SHIFT_CONST(416)
#define CCW_C2MC_REQ_TAG_FIELD                  (_MK_MASK_CONST(0x1) << CCW_C2MC_REQ_TAG_SHIFT)
#define CCW_C2MC_REQ_TAG_RANGE                  _MK_SHIFT_CONST(416):_MK_SHIFT_CONST(416)
#define CCW_C2MC_REQ_TAG_ROW                    0


// Packet CCW_C2MC_ADRXY
#define CCW_C2MC_ADRXY_SIZE 30

#define CCW_C2MC_ADRXY_OFFX_SHIFT                       _MK_SHIFT_CONST(0)
#define CCW_C2MC_ADRXY_OFFX_FIELD                       (_MK_MASK_CONST(0xffff) << CCW_C2MC_ADRXY_OFFX_SHIFT)
#define CCW_C2MC_ADRXY_OFFX_RANGE                       _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define CCW_C2MC_ADRXY_OFFX_ROW                 0

#define CCW_C2MC_ADRXY_OFFY_SHIFT                       _MK_SHIFT_CONST(16)
#define CCW_C2MC_ADRXY_OFFY_FIELD                       (_MK_MASK_CONST(0x3fff) << CCW_C2MC_ADRXY_OFFY_SHIFT)
#define CCW_C2MC_ADRXY_OFFY_RANGE                       _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(16)
#define CCW_C2MC_ADRXY_OFFY_ROW                 0


// Packet CCW_C2MC_TILE
#define CCW_C2MC_TILE_SIZE 33

#define CCW_C2MC_TILE_LINADR_SHIFT                      _MK_SHIFT_CONST(0)
#define CCW_C2MC_TILE_LINADR_FIELD                      (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_TILE_LINADR_SHIFT)
#define CCW_C2MC_TILE_LINADR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCW_C2MC_TILE_LINADR_ROW                        0

#define CCW_C2MC_TILE_TMODE_SHIFT                       _MK_SHIFT_CONST(32)
#define CCW_C2MC_TILE_TMODE_FIELD                       (_MK_MASK_CONST(0x1) << CCW_C2MC_TILE_TMODE_SHIFT)
#define CCW_C2MC_TILE_TMODE_RANGE                       _MK_SHIFT_CONST(32):_MK_SHIFT_CONST(32)
#define CCW_C2MC_TILE_TMODE_ROW                 0
#define CCW_C2MC_TILE_TMODE_LINEAR                      _MK_ENUM_CONST(0)
#define CCW_C2MC_TILE_TMODE_TILED                       _MK_ENUM_CONST(1)


// Packet CCW_C2MC_XDI
#define CCW_C2MC_XDI_SIZE 1

// fake data
#define CCW_C2MC_XDI_XDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CCW_C2MC_XDI_XDI_FIELD                  (_MK_MASK_CONST(0x1) << CCW_C2MC_XDI_XDI_SHIFT)
#define CCW_C2MC_XDI_XDI_RANGE                  _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CCW_C2MC_XDI_XDI_ROW                    0


// Packet CCW_C2MC_HP
#define CCW_C2MC_HP_SIZE 32

// high-priority threshold
#define CCW_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CCW_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_HP_HPTH_SHIFT)
#define CCW_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCW_C2MC_HP_HPTH_ROW                    0


// Packet CCW_C2MC_WCOAL
#define CCW_C2MC_WCOAL_SIZE 32

// write-coalescing time-out
#define CCW_C2MC_WCOAL_WCOALTM_SHIFT                    _MK_SHIFT_CONST(0)
#define CCW_C2MC_WCOAL_WCOALTM_FIELD                    (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_WCOAL_WCOALTM_SHIFT)
#define CCW_C2MC_WCOAL_WCOALTM_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCW_C2MC_WCOAL_WCOALTM_ROW                      0


// Packet SC_MCCIF_ASYNC
#define SC_MCCIF_ASYNC_SIZE 4

#define SC_MCCIF_ASYNC_RDCL_RDFAST_SHIFT                        _MK_SHIFT_CONST(0)
#define SC_MCCIF_ASYNC_RDCL_RDFAST_FIELD                        (_MK_MASK_CONST(0x1) << SC_MCCIF_ASYNC_RDCL_RDFAST_SHIFT)
#define SC_MCCIF_ASYNC_RDCL_RDFAST_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define SC_MCCIF_ASYNC_RDCL_RDFAST_ROW                  0

#define SC_MCCIF_ASYNC_RDMC_RDFAST_SHIFT                        _MK_SHIFT_CONST(1)
#define SC_MCCIF_ASYNC_RDMC_RDFAST_FIELD                        (_MK_MASK_CONST(0x1) << SC_MCCIF_ASYNC_RDMC_RDFAST_SHIFT)
#define SC_MCCIF_ASYNC_RDMC_RDFAST_RANGE                        _MK_SHIFT_CONST(1):_MK_SHIFT_CONST(1)
#define SC_MCCIF_ASYNC_RDMC_RDFAST_ROW                  0

#define SC_MCCIF_ASYNC_WRCL_MCLE2X_SHIFT                        _MK_SHIFT_CONST(2)
#define SC_MCCIF_ASYNC_WRCL_MCLE2X_FIELD                        (_MK_MASK_CONST(0x1) << SC_MCCIF_ASYNC_WRCL_MCLE2X_SHIFT)
#define SC_MCCIF_ASYNC_WRCL_MCLE2X_RANGE                        _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(2)
#define SC_MCCIF_ASYNC_WRCL_MCLE2X_ROW                  0

#define SC_MCCIF_ASYNC_WRMC_CLLE2X_SHIFT                        _MK_SHIFT_CONST(3)
#define SC_MCCIF_ASYNC_WRMC_CLLE2X_FIELD                        (_MK_MASK_CONST(0x1) << SC_MCCIF_ASYNC_WRMC_CLLE2X_SHIFT)
#define SC_MCCIF_ASYNC_WRMC_CLLE2X_RANGE                        _MK_SHIFT_CONST(3):_MK_SHIFT_CONST(3)
#define SC_MCCIF_ASYNC_WRMC_CLLE2X_ROW                  0


// Register EMC_LL_ARB_CONFIG_0  // LOW-LATENCY arbiter configuration
#define EMC_LL_ARB_CONFIG_0                     _MK_ADDR_CONST(0xa4)
#define EMC_LL_ARB_CONFIG_0_WORD_COUNT                  0x1
#define EMC_LL_ARB_CONFIG_0_RESET_VAL                   _MK_MASK_CONST(0x2003)
#define EMC_LL_ARB_CONFIG_0_RESET_MASK                  _MK_MASK_CONST(0x8000f10f)
#define EMC_LL_ARB_CONFIG_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_READ_MASK                   _MK_MASK_CONST(0x8000f10f)
#define EMC_LL_ARB_CONFIG_0_WRITE_MASK                  _MK_MASK_CONST(0x8000f10f)
#define EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_FIELD                   (_MK_MASK_CONST(0xf) << EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_SHIFT)
#define EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_RANGE                   3:0
#define EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_WOFFSET                 0x0
#define EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_DEFAULT                 _MK_MASK_CONST(0x3)
#define EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_SHIFT                     _MK_SHIFT_CONST(8)
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_FIELD                     (_MK_MASK_CONST(0x1) << EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_SHIFT)
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_RANGE                     8:8
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_WOFFSET                   0x0
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_INIT_ENUM                 DISABLED
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_DISABLED                  _MK_ENUM_CONST(0)
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_ENABLED                   _MK_ENUM_CONST(1)

#define EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_SHIFT                  _MK_SHIFT_CONST(12)
#define EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_FIELD                  (_MK_MASK_CONST(0xf) << EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_SHIFT)
#define EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_RANGE                  15:12
#define EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_WOFFSET                        0x0
#define EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_DEFAULT                        _MK_MASK_CONST(0x2)
#define EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define EMC_LL_ARB_CONFIG_0_LL_RETRSV_ENABLE_SHIFT                      _MK_SHIFT_CONST(31)
#define EMC_LL_ARB_CONFIG_0_LL_RETRSV_ENABLE_FIELD                      (_MK_MASK_CONST(0x1) << EMC_LL_ARB_CONFIG_0_LL_RETRSV_ENABLE_SHIFT)
#define EMC_LL_ARB_CONFIG_0_LL_RETRSV_ENABLE_RANGE                      31:31
#define EMC_LL_ARB_CONFIG_0_LL_RETRSV_ENABLE_WOFFSET                    0x0
#define EMC_LL_ARB_CONFIG_0_LL_RETRSV_ENABLE_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_LL_RETRSV_ENABLE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_LL_ARB_CONFIG_0_LL_RETRSV_ENABLE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_LL_RETRSV_ENABLE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_LL_RETRSV_ENABLE_INIT_ENUM                  DISABLED
#define EMC_LL_ARB_CONFIG_0_LL_RETRSV_ENABLE_DISABLED                   _MK_ENUM_CONST(0)
#define EMC_LL_ARB_CONFIG_0_LL_RETRSV_ENABLE_ENABLED                    _MK_ENUM_CONST(1)


// Register EMC_T_MIN_CRITICAL_HP_0  
#define EMC_T_MIN_CRITICAL_HP_0                 _MK_ADDR_CONST(0xa8)
#define EMC_T_MIN_CRITICAL_HP_0_WORD_COUNT                      0x1
#define EMC_T_MIN_CRITICAL_HP_0_RESET_VAL                       _MK_MASK_CONST(0xa080600)
#define EMC_T_MIN_CRITICAL_HP_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_CRITICAL_HP_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_HP_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_HP_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_CRITICAL_HP_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_FIELD                   (_MK_MASK_CONST(0xff) << EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_SHIFT)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_RANGE                   7:0
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_WOFFSET                 0x0
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_SHIFT                   _MK_SHIFT_CONST(8)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_FIELD                   (_MK_MASK_CONST(0xff) << EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_SHIFT)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_RANGE                   15:8
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_WOFFSET                 0x0
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_DEFAULT                 _MK_MASK_CONST(0x6)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_SHIFT                   _MK_SHIFT_CONST(16)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_FIELD                   (_MK_MASK_CONST(0xff) << EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_SHIFT)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_RANGE                   23:16
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_WOFFSET                 0x0
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_DEFAULT                 _MK_MASK_CONST(0x8)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_SHIFT                   _MK_SHIFT_CONST(24)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_FIELD                   (_MK_MASK_CONST(0xff) << EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_SHIFT)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_RANGE                   31:24
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_WOFFSET                 0x0
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_DEFAULT                 _MK_MASK_CONST(0xa)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_T_MIN_CRITICAL_TIMEOUT_0  
#define EMC_T_MIN_CRITICAL_TIMEOUT_0                    _MK_ADDR_CONST(0xac)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_WORD_COUNT                         0x1
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_RESET_VAL                  _MK_MASK_CONST(0xa080600)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_FIELD                 (_MK_MASK_CONST(0xff) << EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_SHIFT)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_RANGE                 7:0
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_WOFFSET                       0x0
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_FIELD                 (_MK_MASK_CONST(0xff) << EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_SHIFT)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_RANGE                 15:8
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_WOFFSET                       0x0
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_DEFAULT                       _MK_MASK_CONST(0x6)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_FIELD                 (_MK_MASK_CONST(0xff) << EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_SHIFT)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_RANGE                 23:16
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_WOFFSET                       0x0
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_DEFAULT                       _MK_MASK_CONST(0x8)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_SHIFT                 _MK_SHIFT_CONST(24)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_FIELD                 (_MK_MASK_CONST(0xff) << EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_SHIFT)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_RANGE                 31:24
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_WOFFSET                       0x0
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_DEFAULT                       _MK_MASK_CONST(0xa)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_T_MIN_LOAD_0  
#define EMC_T_MIN_LOAD_0                        _MK_ADDR_CONST(0xb0)
#define EMC_T_MIN_LOAD_0_WORD_COUNT                     0x1
#define EMC_T_MIN_LOAD_0_RESET_VAL                      _MK_MASK_CONST(0x8040200)
#define EMC_T_MIN_LOAD_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_LOAD_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_T_MIN_LOAD_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_T_MIN_LOAD_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_LOAD_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_FIELD                     (_MK_MASK_CONST(0xff) << EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_SHIFT)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_RANGE                     7:0
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_WOFFSET                   0x0
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_SHIFT                     _MK_SHIFT_CONST(8)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_FIELD                     (_MK_MASK_CONST(0xff) << EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_SHIFT)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_RANGE                     15:8
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_WOFFSET                   0x0
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_DEFAULT                   _MK_MASK_CONST(0x2)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_SHIFT                     _MK_SHIFT_CONST(16)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_FIELD                     (_MK_MASK_CONST(0xff) << EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_SHIFT)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_RANGE                     23:16
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_WOFFSET                   0x0
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_DEFAULT                   _MK_MASK_CONST(0x4)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_SHIFT                     _MK_SHIFT_CONST(24)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_FIELD                     (_MK_MASK_CONST(0xff) << EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_SHIFT)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_RANGE                     31:24
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_WOFFSET                   0x0
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_DEFAULT                   _MK_MASK_CONST(0x8)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_T_MAX_CRITICAL_HP_0  
#define EMC_T_MAX_CRITICAL_HP_0                 _MK_ADDR_CONST(0xb4)
#define EMC_T_MAX_CRITICAL_HP_0_WORD_COUNT                      0x1
#define EMC_T_MAX_CRITICAL_HP_0_RESET_VAL                       _MK_MASK_CONST(0xb0a0901)
#define EMC_T_MAX_CRITICAL_HP_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_CRITICAL_HP_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_HP_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_HP_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_CRITICAL_HP_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_FIELD                   (_MK_MASK_CONST(0xff) << EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_SHIFT)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_RANGE                   7:0
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_WOFFSET                 0x0
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_DEFAULT                 _MK_MASK_CONST(0x1)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_SHIFT                   _MK_SHIFT_CONST(8)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_FIELD                   (_MK_MASK_CONST(0xff) << EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_SHIFT)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_RANGE                   15:8
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_WOFFSET                 0x0
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_DEFAULT                 _MK_MASK_CONST(0x9)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_SHIFT                   _MK_SHIFT_CONST(16)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_FIELD                   (_MK_MASK_CONST(0xff) << EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_SHIFT)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_RANGE                   23:16
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_WOFFSET                 0x0
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_DEFAULT                 _MK_MASK_CONST(0xa)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_SHIFT                   _MK_SHIFT_CONST(24)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_FIELD                   (_MK_MASK_CONST(0xff) << EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_SHIFT)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_RANGE                   31:24
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_WOFFSET                 0x0
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_DEFAULT                 _MK_MASK_CONST(0xb)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_T_MAX_CRITICAL_TIMEOUT_0  
#define EMC_T_MAX_CRITICAL_TIMEOUT_0                    _MK_ADDR_CONST(0xb8)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_WORD_COUNT                         0x1
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_RESET_VAL                  _MK_MASK_CONST(0xb0a0901)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_FIELD                 (_MK_MASK_CONST(0xff) << EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_SHIFT)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_RANGE                 7:0
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_WOFFSET                       0x0
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_DEFAULT                       _MK_MASK_CONST(0x1)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_FIELD                 (_MK_MASK_CONST(0xff) << EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_SHIFT)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_RANGE                 15:8
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_WOFFSET                       0x0
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_DEFAULT                       _MK_MASK_CONST(0x9)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_FIELD                 (_MK_MASK_CONST(0xff) << EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_SHIFT)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_RANGE                 23:16
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_WOFFSET                       0x0
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_DEFAULT                       _MK_MASK_CONST(0xa)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_SHIFT                 _MK_SHIFT_CONST(24)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_FIELD                 (_MK_MASK_CONST(0xff) << EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_SHIFT)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_RANGE                 31:24
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_WOFFSET                       0x0
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_DEFAULT                       _MK_MASK_CONST(0xb)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_T_MAX_LOAD_0  
#define EMC_T_MAX_LOAD_0                        _MK_ADDR_CONST(0xbc)
#define EMC_T_MAX_LOAD_0_WORD_COUNT                     0x1
#define EMC_T_MAX_LOAD_0_RESET_VAL                      _MK_MASK_CONST(0xf080402)
#define EMC_T_MAX_LOAD_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_LOAD_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_T_MAX_LOAD_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_T_MAX_LOAD_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_LOAD_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_FIELD                     (_MK_MASK_CONST(0xff) << EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_SHIFT)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_RANGE                     7:0
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_WOFFSET                   0x0
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_DEFAULT                   _MK_MASK_CONST(0x2)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_SHIFT                     _MK_SHIFT_CONST(8)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_FIELD                     (_MK_MASK_CONST(0xff) << EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_SHIFT)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_RANGE                     15:8
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_WOFFSET                   0x0
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_DEFAULT                   _MK_MASK_CONST(0x4)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_SHIFT                     _MK_SHIFT_CONST(16)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_FIELD                     (_MK_MASK_CONST(0xff) << EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_SHIFT)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_RANGE                     23:16
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_WOFFSET                   0x0
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_DEFAULT                   _MK_MASK_CONST(0x8)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_SHIFT                     _MK_SHIFT_CONST(24)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_FIELD                     (_MK_MASK_CONST(0xff) << EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_SHIFT)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_RANGE                     31:24
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_WOFFSET                   0x0
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_DEFAULT                   _MK_MASK_CONST(0xf)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_STAT_CONTROL_0  
#define EMC_STAT_CONTROL_0                      _MK_ADDR_CONST(0xc0)
#define EMC_STAT_CONTROL_0_WORD_COUNT                   0x1
#define EMC_STAT_CONTROL_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_RESET_MASK                   _MK_MASK_CONST(0x307)
#define EMC_STAT_CONTROL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_READ_MASK                    _MK_MASK_CONST(0x307)
#define EMC_STAT_CONTROL_0_WRITE_MASK                   _MK_MASK_CONST(0x307)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_SHIFT                    _MK_SHIFT_CONST(0)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_FIELD                    (_MK_MASK_CONST(0x7) << EMC_STAT_CONTROL_0_LLMC_GATHER_SHIFT)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_RANGE                    2:0
#define EMC_STAT_CONTROL_0_LLMC_GATHER_WOFFSET                  0x0
#define EMC_STAT_CONTROL_0_LLMC_GATHER_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_INIT_ENUM                        RST
#define EMC_STAT_CONTROL_0_LLMC_GATHER_RST                      _MK_ENUM_CONST(0)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_CLEAR                    _MK_ENUM_CONST(1)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_DISABLE                  _MK_ENUM_CONST(2)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_ENABLE                   _MK_ENUM_CONST(3)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_SLAVE_TO_MC                      _MK_ENUM_CONST(4)

#define EMC_STAT_CONTROL_0_PWR_GATHER_SHIFT                     _MK_SHIFT_CONST(8)
#define EMC_STAT_CONTROL_0_PWR_GATHER_FIELD                     (_MK_MASK_CONST(0x3) << EMC_STAT_CONTROL_0_PWR_GATHER_SHIFT)
#define EMC_STAT_CONTROL_0_PWR_GATHER_RANGE                     9:8
#define EMC_STAT_CONTROL_0_PWR_GATHER_WOFFSET                   0x0
#define EMC_STAT_CONTROL_0_PWR_GATHER_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_PWR_GATHER_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define EMC_STAT_CONTROL_0_PWR_GATHER_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_PWR_GATHER_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_PWR_GATHER_INIT_ENUM                 RST
#define EMC_STAT_CONTROL_0_PWR_GATHER_RST                       _MK_ENUM_CONST(0)
#define EMC_STAT_CONTROL_0_PWR_GATHER_CLEAR                     _MK_ENUM_CONST(1)
#define EMC_STAT_CONTROL_0_PWR_GATHER_DISABLE                   _MK_ENUM_CONST(2)
#define EMC_STAT_CONTROL_0_PWR_GATHER_ENABLE                    _MK_ENUM_CONST(3)


// Register EMC_STAT_STATUS_0  
#define EMC_STAT_STATUS_0                       _MK_ADDR_CONST(0xc4)
#define EMC_STAT_STATUS_0_WORD_COUNT                    0x1
#define EMC_STAT_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_READ_MASK                     _MK_MASK_CONST(0x101)
#define EMC_STAT_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_LLMC_LIMIT_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC_STAT_STATUS_0_LLMC_LIMIT_FIELD                      (_MK_MASK_CONST(0x1) << EMC_STAT_STATUS_0_LLMC_LIMIT_SHIFT)
#define EMC_STAT_STATUS_0_LLMC_LIMIT_RANGE                      0:0
#define EMC_STAT_STATUS_0_LLMC_LIMIT_WOFFSET                    0x0
#define EMC_STAT_STATUS_0_LLMC_LIMIT_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_LLMC_LIMIT_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_LLMC_LIMIT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_LLMC_LIMIT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define EMC_STAT_STATUS_0_PWR_LIMIT_SHIFT                       _MK_SHIFT_CONST(8)
#define EMC_STAT_STATUS_0_PWR_LIMIT_FIELD                       (_MK_MASK_CONST(0x1) << EMC_STAT_STATUS_0_PWR_LIMIT_SHIFT)
#define EMC_STAT_STATUS_0_PWR_LIMIT_RANGE                       8:8
#define EMC_STAT_STATUS_0_PWR_LIMIT_WOFFSET                     0x0
#define EMC_STAT_STATUS_0_PWR_LIMIT_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_PWR_LIMIT_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_PWR_LIMIT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_PWR_LIMIT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_STAT_LLMC_ADDR_LOW_0  
#define EMC_STAT_LLMC_ADDR_LOW_0                        _MK_ADDR_CONST(0xc8)
#define EMC_STAT_LLMC_ADDR_LOW_0_WORD_COUNT                     0x1
#define EMC_STAT_LLMC_ADDR_LOW_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_LOW_0_RESET_MASK                     _MK_MASK_CONST(0x3ffffff0)
#define EMC_STAT_LLMC_ADDR_LOW_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_LOW_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_LOW_0_READ_MASK                      _MK_MASK_CONST(0x3ffffff0)
#define EMC_STAT_LLMC_ADDR_LOW_0_WRITE_MASK                     _MK_MASK_CONST(0x3ffffff0)
#define EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_SHIFT                    _MK_SHIFT_CONST(4)
#define EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_FIELD                    (_MK_MASK_CONST(0x3ffffff) << EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_SHIFT)
#define EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_RANGE                    29:4
#define EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_WOFFSET                  0x0
#define EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_DEFAULT_MASK                     _MK_MASK_CONST(0x3ffffff)
#define EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register EMC_STAT_LLMC_ADDR_HIGH_0  
#define EMC_STAT_LLMC_ADDR_HIGH_0                       _MK_ADDR_CONST(0xcc)
#define EMC_STAT_LLMC_ADDR_HIGH_0_WORD_COUNT                    0x1
#define EMC_STAT_LLMC_ADDR_HIGH_0_RESET_VAL                     _MK_MASK_CONST(0x3ffffff0)
#define EMC_STAT_LLMC_ADDR_HIGH_0_RESET_MASK                    _MK_MASK_CONST(0x3ffffff0)
#define EMC_STAT_LLMC_ADDR_HIGH_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_HIGH_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_HIGH_0_READ_MASK                     _MK_MASK_CONST(0x3ffffff0)
#define EMC_STAT_LLMC_ADDR_HIGH_0_WRITE_MASK                    _MK_MASK_CONST(0x3ffffff0)
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_SHIFT                  _MK_SHIFT_CONST(4)
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_FIELD                  (_MK_MASK_CONST(0x3ffffff) << EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_SHIFT)
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_RANGE                  29:4
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_WOFFSET                        0x0
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_DEFAULT                        _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_DEFAULT_MASK                   _MK_MASK_CONST(0x3ffffff)
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_INIT_ENUM                      -1


// Register EMC_STAT_LLMC_CLOCK_LIMIT_0  
#define EMC_STAT_LLMC_CLOCK_LIMIT_0                     _MK_ADDR_CONST(0xd0)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_WORD_COUNT                  0x1
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_RESET_VAL                   _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_FIELD                      (_MK_MASK_CONST(0xffffffff) << EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_SHIFT)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_RANGE                      31:0
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_WOFFSET                    0x0
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_DEFAULT                    _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_INIT_ENUM                  -1


// Register EMC_STAT_LLMC_CLOCKS_0  
#define EMC_STAT_LLMC_CLOCKS_0                  _MK_ADDR_CONST(0xd4)
#define EMC_STAT_LLMC_CLOCKS_0_WORD_COUNT                       0x1
#define EMC_STAT_LLMC_CLOCKS_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCKS_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCKS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCKS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCKS_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CLOCKS_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_FIELD                        (_MK_MASK_CONST(0xffffffff) << EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_SHIFT)
#define EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_RANGE                        31:0
#define EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_WOFFSET                      0x0
#define EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Packet AREMC_STAT_CONTROL
#define AREMC_STAT_CONTROL_SIZE 28

#define AREMC_STAT_CONTROL_MODE_SHIFT                   _MK_SHIFT_CONST(0)
#define AREMC_STAT_CONTROL_MODE_FIELD                   (_MK_MASK_CONST(0x3) << AREMC_STAT_CONTROL_MODE_SHIFT)
#define AREMC_STAT_CONTROL_MODE_RANGE                   _MK_SHIFT_CONST(1):_MK_SHIFT_CONST(0)
#define AREMC_STAT_CONTROL_MODE_ROW                     0
#define AREMC_STAT_CONTROL_MODE_BANDWIDTH                       _MK_ENUM_CONST(0)
#define AREMC_STAT_CONTROL_MODE_LATENCY_AVG                     _MK_ENUM_CONST(1)
#define AREMC_STAT_CONTROL_MODE_LATENCY_HISTO                   _MK_ENUM_CONST(2)

#define AREMC_STAT_CONTROL_SKIP_SHIFT                   _MK_SHIFT_CONST(4)
#define AREMC_STAT_CONTROL_SKIP_FIELD                   (_MK_MASK_CONST(0x7) << AREMC_STAT_CONTROL_SKIP_SHIFT)
#define AREMC_STAT_CONTROL_SKIP_RANGE                   _MK_SHIFT_CONST(6):_MK_SHIFT_CONST(4)
#define AREMC_STAT_CONTROL_SKIP_ROW                     0

#define AREMC_STAT_CONTROL_CLIENT_TYPE_SHIFT                    _MK_SHIFT_CONST(8)
#define AREMC_STAT_CONTROL_CLIENT_TYPE_FIELD                    (_MK_MASK_CONST(0x1) << AREMC_STAT_CONTROL_CLIENT_TYPE_SHIFT)
#define AREMC_STAT_CONTROL_CLIENT_TYPE_RANGE                    _MK_SHIFT_CONST(8):_MK_SHIFT_CONST(8)
#define AREMC_STAT_CONTROL_CLIENT_TYPE_ROW                      0
#define AREMC_STAT_CONTROL_CLIENT_TYPE_CMCR                     _MK_ENUM_CONST(0)
#define AREMC_STAT_CONTROL_CLIENT_TYPE_MPCORER                  _MK_ENUM_CONST(1)

#define AREMC_STAT_CONTROL_EVENT_SHIFT                  _MK_SHIFT_CONST(16)
#define AREMC_STAT_CONTROL_EVENT_FIELD                  (_MK_MASK_CONST(0x1) << AREMC_STAT_CONTROL_EVENT_SHIFT)
#define AREMC_STAT_CONTROL_EVENT_RANGE                  _MK_SHIFT_CONST(16):_MK_SHIFT_CONST(16)
#define AREMC_STAT_CONTROL_EVENT_ROW                    0
#define AREMC_STAT_CONTROL_EVENT_QUALIFIED                      _MK_ENUM_CONST(0)
#define AREMC_STAT_CONTROL_EVENT_RD_WR_CHANGE                   _MK_ENUM_CONST(1)

#define AREMC_STAT_CONTROL_FILTER_CLIENT_SHIFT                  _MK_SHIFT_CONST(26)
#define AREMC_STAT_CONTROL_FILTER_CLIENT_FIELD                  (_MK_MASK_CONST(0x1) << AREMC_STAT_CONTROL_FILTER_CLIENT_SHIFT)
#define AREMC_STAT_CONTROL_FILTER_CLIENT_RANGE                  _MK_SHIFT_CONST(26):_MK_SHIFT_CONST(26)
#define AREMC_STAT_CONTROL_FILTER_CLIENT_ROW                    0
#define AREMC_STAT_CONTROL_FILTER_CLIENT_DISABLE                        _MK_ENUM_CONST(0)
#define AREMC_STAT_CONTROL_FILTER_CLIENT_ENABLE                 _MK_ENUM_CONST(1)

#define AREMC_STAT_CONTROL_FILTER_ADDR_SHIFT                    _MK_SHIFT_CONST(27)
#define AREMC_STAT_CONTROL_FILTER_ADDR_FIELD                    (_MK_MASK_CONST(0x1) << AREMC_STAT_CONTROL_FILTER_ADDR_SHIFT)
#define AREMC_STAT_CONTROL_FILTER_ADDR_RANGE                    _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(27)
#define AREMC_STAT_CONTROL_FILTER_ADDR_ROW                      0
#define AREMC_STAT_CONTROL_FILTER_ADDR_DISABLE                  _MK_ENUM_CONST(0)
#define AREMC_STAT_CONTROL_FILTER_ADDR_ENABLE                   _MK_ENUM_CONST(1)


// Register EMC_STAT_LLMC_CONTROL_0_0  
#define EMC_STAT_LLMC_CONTROL_0_0                       _MK_ADDR_CONST(0xd8)
#define EMC_STAT_LLMC_CONTROL_0_0_WORD_COUNT                    0x1
#define EMC_STAT_LLMC_CONTROL_0_0_RESET_VAL                     _MK_MASK_CONST(0xffff0000)
#define EMC_STAT_LLMC_CONTROL_0_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CONTROL_0_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CONTROL_0_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CONTROL_0_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CONTROL_0_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_FIELD                  (_MK_MASK_CONST(0xffffffff) << EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_SHIFT)
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_RANGE                  31:0
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_WOFFSET                        0x0
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_DEFAULT                        _MK_MASK_CONST(0xffff0000)
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_INIT_ENUM                      -65536


// Reserved address 220 [0xdc] 

// Packet AREMC_STAT_HIST_LIMIT
#define AREMC_STAT_HIST_LIMIT_SIZE 32

#define AREMC_STAT_HIST_LIMIT_LOW_SHIFT                 _MK_SHIFT_CONST(0)
#define AREMC_STAT_HIST_LIMIT_LOW_FIELD                 (_MK_MASK_CONST(0xffff) << AREMC_STAT_HIST_LIMIT_LOW_SHIFT)
#define AREMC_STAT_HIST_LIMIT_LOW_RANGE                 _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define AREMC_STAT_HIST_LIMIT_LOW_ROW                   0

#define AREMC_STAT_HIST_LIMIT_HIGH_SHIFT                        _MK_SHIFT_CONST(16)
#define AREMC_STAT_HIST_LIMIT_HIGH_FIELD                        (_MK_MASK_CONST(0xffff) << AREMC_STAT_HIST_LIMIT_HIGH_SHIFT)
#define AREMC_STAT_HIST_LIMIT_HIGH_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(16)
#define AREMC_STAT_HIST_LIMIT_HIGH_ROW                  0


// Register EMC_STAT_LLMC_HIST_LIMIT_0_0  
#define EMC_STAT_LLMC_HIST_LIMIT_0_0                    _MK_ADDR_CONST(0xe0)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_WORD_COUNT                         0x1
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_RESET_VAL                  _MK_MASK_CONST(0xffff0000)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_SHIFT                    _MK_SHIFT_CONST(0)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_FIELD                    (_MK_MASK_CONST(0xffffffff) << EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_SHIFT)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_RANGE                    31:0
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_WOFFSET                  0x0
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_DEFAULT                  _MK_MASK_CONST(0xffff0000)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_INIT_ENUM                        -65536


// Reserved address 228 [0xe4] 

// Register EMC_STAT_LLMC_COUNT_0_0  
#define EMC_STAT_LLMC_COUNT_0_0                 _MK_ADDR_CONST(0xe8)
#define EMC_STAT_LLMC_COUNT_0_0_WORD_COUNT                      0x1
#define EMC_STAT_LLMC_COUNT_0_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_COUNT_0_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_COUNT_0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_COUNT_0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_COUNT_0_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_COUNT_0_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_FIELD                      (_MK_MASK_CONST(0xffffffff) << EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_SHIFT)
#define EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_RANGE                      31:0
#define EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_WOFFSET                    0x0
#define EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Reserved address 236 [0xec] 

// Register EMC_STAT_LLMC_HIST_0_0  
#define EMC_STAT_LLMC_HIST_0_0                  _MK_ADDR_CONST(0xf0)
#define EMC_STAT_LLMC_HIST_0_0_WORD_COUNT                       0x1
#define EMC_STAT_LLMC_HIST_0_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_0_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_0_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_0_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_0_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_HIST_0_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_FIELD                        (_MK_MASK_CONST(0xffffffff) << EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_SHIFT)
#define EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_RANGE                        31:0
#define EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_WOFFSET                      0x0
#define EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Reserved address 244 [0xf4] 

// Register EMC_STAT_PWR_CLOCK_LIMIT_0  
#define EMC_STAT_PWR_CLOCK_LIMIT_0                      _MK_ADDR_CONST(0xf8)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_WORD_COUNT                   0x1
#define EMC_STAT_PWR_CLOCK_LIMIT_0_RESET_VAL                    _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_FIELD                        (_MK_MASK_CONST(0xffffffff) << EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_SHIFT)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_RANGE                        31:0
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_WOFFSET                      0x0
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_DEFAULT                      _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_INIT_ENUM                    -1


// Register EMC_STAT_PWR_CLOCKS_0  
#define EMC_STAT_PWR_CLOCKS_0                   _MK_ADDR_CONST(0xfc)
#define EMC_STAT_PWR_CLOCKS_0_WORD_COUNT                        0x1
#define EMC_STAT_PWR_CLOCKS_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCKS_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCKS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCKS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCKS_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_PWR_CLOCKS_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_FIELD                  (_MK_MASK_CONST(0xffffffff) << EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_SHIFT)
#define EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_RANGE                  31:0
#define EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_WOFFSET                        0x0
#define EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register EMC_STAT_PWR_COUNT_0  
#define EMC_STAT_PWR_COUNT_0                    _MK_ADDR_CONST(0x100)
#define EMC_STAT_PWR_COUNT_0_WORD_COUNT                         0x1
#define EMC_STAT_PWR_COUNT_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_COUNT_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_COUNT_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_COUNT_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_COUNT_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_PWR_COUNT_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_COUNT_0_PWR_COUNT_SHIFT                    _MK_SHIFT_CONST(0)
#define EMC_STAT_PWR_COUNT_0_PWR_COUNT_FIELD                    (_MK_MASK_CONST(0xffffffff) << EMC_STAT_PWR_COUNT_0_PWR_COUNT_SHIFT)
#define EMC_STAT_PWR_COUNT_0_PWR_COUNT_RANGE                    31:0
#define EMC_STAT_PWR_COUNT_0_PWR_COUNT_WOFFSET                  0x0
#define EMC_STAT_PWR_COUNT_0_PWR_COUNT_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_COUNT_0_PWR_COUNT_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_COUNT_0_PWR_COUNT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_COUNT_0_PWR_COUNT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register EMC_AUTO_CAL_CONFIG_0  
#define EMC_AUTO_CAL_CONFIG_0                   _MK_ADDR_CONST(0x104)
#define EMC_AUTO_CAL_CONFIG_0_WORD_COUNT                        0x1
#define EMC_AUTO_CAL_CONFIG_0_RESET_VAL                         _MK_MASK_CONST(0xa60000)
#define EMC_AUTO_CAL_CONFIG_0_RESET_MASK                        _MK_MASK_CONST(0xc3ff1f1f)
#define EMC_AUTO_CAL_CONFIG_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_READ_MASK                         _MK_MASK_CONST(0xc3ff1f1f)
#define EMC_AUTO_CAL_CONFIG_0_WRITE_MASK                        _MK_MASK_CONST(0x43ff1f1f)
// 2's complement offset for pull-up value
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_FIELD                  (_MK_MASK_CONST(0x1f) << EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_SHIFT)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_RANGE                  4:0
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_WOFFSET                        0x0
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// 2's complement offset for pull-down value
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_SHIFT                  _MK_SHIFT_CONST(8)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_FIELD                  (_MK_MASK_CONST(0x1f) << EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_SHIFT)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_RANGE                  12:8
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_WOFFSET                        0x0
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Auto Cal calibration step interval (in emc clocks)
// - the default is set for 1.0us calibration step at 166MHz
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_SHIFT                       _MK_SHIFT_CONST(16)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_FIELD                       (_MK_MASK_CONST(0x3ff) << EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_SHIFT)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_RANGE                       25:16
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_WOFFSET                     0x0
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_DEFAULT                     _MK_MASK_CONST(0xa6)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_DEFAULT_MASK                        _MK_MASK_CONST(0x3ff)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 0 (normal operation): use AUTO_CAL_PU/PD_OFFSET as an offset 
//                       to the calibration tate machine setting
// 1 (override)        : use AUTO_CAL_PU/PD_OFFSET register 
//                       values directly
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_SHIFT                   _MK_SHIFT_CONST(30)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_FIELD                   (_MK_MASK_CONST(0x1) << EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_SHIFT)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_RANGE                   30:30
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_WOFFSET                 0x0
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Writing a one to this bit starts the calibration state
// machine.  This bit must be set even if the override is
// set in order to latch in the override value.
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_SHIFT                      _MK_SHIFT_CONST(31)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_FIELD                      (_MK_MASK_CONST(0x1) << EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_SHIFT)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_RANGE                      31:31
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_WOFFSET                    0x0
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register EMC_AUTO_CAL_INTERVAL_0  
#define EMC_AUTO_CAL_INTERVAL_0                 _MK_ADDR_CONST(0x108)
#define EMC_AUTO_CAL_INTERVAL_0_WORD_COUNT                      0x1
#define EMC_AUTO_CAL_INTERVAL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_INTERVAL_0_RESET_MASK                      _MK_MASK_CONST(0xfffffff)
#define EMC_AUTO_CAL_INTERVAL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_INTERVAL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_INTERVAL_0_READ_MASK                       _MK_MASK_CONST(0xfffffff)
#define EMC_AUTO_CAL_INTERVAL_0_WRITE_MASK                      _MK_MASK_CONST(0xfffffff)
// 0: do calibration once
// Otherwise, auto-calibration occurs at intervals equivalent
// to the programmed number of cycles.
#define EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_FIELD                 (_MK_MASK_CONST(0xfffffff) << EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_SHIFT)
#define EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_RANGE                 27:0
#define EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_WOFFSET                       0x0
#define EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_DEFAULT_MASK                  _MK_MASK_CONST(0xfffffff)
#define EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_AUTO_CAL_STATUS_0  
#define EMC_AUTO_CAL_STATUS_0                   _MK_ADDR_CONST(0x10c)
#define EMC_AUTO_CAL_STATUS_0_WORD_COUNT                        0x1
#define EMC_AUTO_CAL_STATUS_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_READ_MASK                         _MK_MASK_CONST(0x9f1f1f1f)
#define EMC_AUTO_CAL_STATUS_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
// Pullup code generated by auto-calibration
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_FIELD                     (_MK_MASK_CONST(0x1f) << EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_SHIFT)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_RANGE                     4:0
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_WOFFSET                   0x0
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Pulldown code generated by auto-calibration
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_SHIFT                   _MK_SHIFT_CONST(8)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_FIELD                   (_MK_MASK_CONST(0x1f) << EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_SHIFT)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_RANGE                   12:8
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_WOFFSET                 0x0
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Pullup code sent to pads
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_FIELD                 (_MK_MASK_CONST(0x1f) << EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_SHIFT)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_RANGE                 20:16
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_WOFFSET                       0x0
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Pulldown code sent to pads
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_SHIFT                       _MK_SHIFT_CONST(24)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_FIELD                       (_MK_MASK_CONST(0x1f) << EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_SHIFT)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_RANGE                       28:24
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_WOFFSET                     0x0
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// One when auto calibrate is active
// - valid only after auto calibrate sequence has 
// completed (EMC_CAL_ACTIVE == 0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_SHIFT                     _MK_SHIFT_CONST(31)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_FIELD                     (_MK_MASK_CONST(0x1) << EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_SHIFT)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_RANGE                     31:31
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_WOFFSET                   0x0
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_AREMC_REGS(_op_) \
_op_(EMC_INTSTATUS_0) \
_op_(EMC_INTMASK_0) \
_op_(EMC_DBG_0) \
_op_(EMC_CFG_0) \
_op_(EMC_ADR_CFG_0) \
_op_(EMC_REFCTRL_0) \
_op_(EMC_PIN_0) \
_op_(EMC_TIMING_CONTROL_0) \
_op_(EMC_TIMING0_0) \
_op_(EMC_TIMING1_0) \
_op_(EMC_TIMING2_0) \
_op_(EMC_TIMING3_0) \
_op_(EMC_TIMING4_0) \
_op_(EMC_TIMING5_0) \
_op_(EMC_MRS_0) \
_op_(EMC_EMRS_0) \
_op_(EMC_REF_0) \
_op_(EMC_PRE_0) \
_op_(EMC_NOP_0) \
_op_(EMC_SELF_REF_0) \
_op_(EMC_DPD_0) \
_op_(EMC_CMDQ_0) \
_op_(EMC_FBIO_CFG1_0) \
_op_(EMC_FBIO_DQSIB_DLY_0) \
_op_(EMC_FBIO_SPARE_0) \
_op_(EMC_FBIO_CFG5_0) \
_op_(EMC_FBIO_WRPTR_EQ_2_0) \
_op_(EMC_FBIO_QUSE_DLY_0) \
_op_(EMC_FBIO_CFG6_0) \
_op_(EMC_BUSARB_0) \
_op_(EMC_DYN_DQS_0) \
_op_(EMC_DYN_QUSE_0) \
_op_(EMC_DQS_TRIMMER_RD0_0) \
_op_(EMC_DQS_TRIMMER_RD1_0) \
_op_(EMC_DQS_TRIMMER_RD2_0) \
_op_(EMC_DQS_TRIMMER_RD3_0) \
_op_(EMC_QUSE_TRIMMER_RD0_0) \
_op_(EMC_QUSE_TRIMMER_RD1_0) \
_op_(EMC_QUSE_TRIMMER_RD2_0) \
_op_(EMC_QUSE_TRIMMER_RD3_0) \
_op_(EMC_CLKEN_OVERRIDE_0) \
_op_(EMC_LL_ARB_CONFIG_0) \
_op_(EMC_T_MIN_CRITICAL_HP_0) \
_op_(EMC_T_MIN_CRITICAL_TIMEOUT_0) \
_op_(EMC_T_MIN_LOAD_0) \
_op_(EMC_T_MAX_CRITICAL_HP_0) \
_op_(EMC_T_MAX_CRITICAL_TIMEOUT_0) \
_op_(EMC_T_MAX_LOAD_0) \
_op_(EMC_STAT_CONTROL_0) \
_op_(EMC_STAT_STATUS_0) \
_op_(EMC_STAT_LLMC_ADDR_LOW_0) \
_op_(EMC_STAT_LLMC_ADDR_HIGH_0) \
_op_(EMC_STAT_LLMC_CLOCK_LIMIT_0) \
_op_(EMC_STAT_LLMC_CLOCKS_0) \
_op_(EMC_STAT_LLMC_CONTROL_0_0) \
_op_(EMC_STAT_LLMC_HIST_LIMIT_0_0) \
_op_(EMC_STAT_LLMC_COUNT_0_0) \
_op_(EMC_STAT_LLMC_HIST_0_0) \
_op_(EMC_STAT_PWR_CLOCK_LIMIT_0) \
_op_(EMC_STAT_PWR_CLOCKS_0) \
_op_(EMC_STAT_PWR_COUNT_0) \
_op_(EMC_AUTO_CAL_CONFIG_0) \
_op_(EMC_AUTO_CAL_INTERVAL_0) \
_op_(EMC_AUTO_CAL_STATUS_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_EMC        0x00000000

//
// AREMC REGISTER BANKS
//

#define EMC0_FIRST_REG 0x0000 // EMC_INTSTATUS_0
#define EMC0_LAST_REG 0x00d8 // EMC_STAT_LLMC_CONTROL_0_0
#define EMC1_FIRST_REG 0x00e0 // EMC_STAT_LLMC_HIST_LIMIT_0_0
#define EMC1_LAST_REG 0x00e0 // EMC_STAT_LLMC_HIST_LIMIT_0_0
#define EMC2_FIRST_REG 0x00e8 // EMC_STAT_LLMC_COUNT_0_0
#define EMC2_LAST_REG 0x00e8 // EMC_STAT_LLMC_COUNT_0_0
#define EMC3_FIRST_REG 0x00f0 // EMC_STAT_LLMC_HIST_0_0
#define EMC3_LAST_REG 0x00f0 // EMC_STAT_LLMC_HIST_0_0
#define EMC4_FIRST_REG 0x00f8 // EMC_STAT_PWR_CLOCK_LIMIT_0
#define EMC4_LAST_REG 0x010c // EMC_AUTO_CAL_STATUS_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___AREMC_H_INC_
