/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARFUSE_H_INC_
#define ___ARFUSE_H_INC_

// Register FUSE_FUSECTRL_0  
#define FUSE_FUSECTRL_0                 _MK_ADDR_CONST(0x0)
#define FUSE_FUSECTRL_0_WORD_COUNT                      0x1
#define FUSE_FUSECTRL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_RESET_MASK                      _MK_MASK_CONST(0x3)
#define FUSE_FUSECTRL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_READ_MASK                       _MK_MASK_CONST(0x10f0003)
#define FUSE_FUSECTRL_0_WRITE_MASK                      _MK_MASK_CONST(0x3)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_FIELD                      (_MK_MASK_CONST(0x3) << FUSE_FUSECTRL_0_FUSECTRL_CMD_SHIFT)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_RANGE                      1:0
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_WOFFSET                    0x0
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_INIT_ENUM                  IDLE
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_IDLE                       _MK_ENUM_CONST(0)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_READ                       _MK_ENUM_CONST(1)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_WRITE                      _MK_ENUM_CONST(2)
#define FUSE_FUSECTRL_0_FUSECTRL_CMD_VERIFY                     _MK_ENUM_CONST(3)

#define FUSE_FUSECTRL_0_FUSECTRL_STATE_SHIFT                    _MK_SHIFT_CONST(16)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_FIELD                    (_MK_MASK_CONST(0xf) << FUSE_FUSECTRL_0_FUSECTRL_STATE_SHIFT)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_RANGE                    19:16
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_WOFFSET                  0x0
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_STATE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSECTRL_0_FUSECTRL_VERIFY_SHIFT                   _MK_SHIFT_CONST(24)
#define FUSE_FUSECTRL_0_FUSECTRL_VERIFY_FIELD                   (_MK_MASK_CONST(0x1) << FUSE_FUSECTRL_0_FUSECTRL_VERIFY_SHIFT)
#define FUSE_FUSECTRL_0_FUSECTRL_VERIFY_RANGE                   24:24
#define FUSE_FUSECTRL_0_FUSECTRL_VERIFY_WOFFSET                 0x0
#define FUSE_FUSECTRL_0_FUSECTRL_VERIFY_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_VERIFY_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_VERIFY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSECTRL_0_FUSECTRL_VERIFY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FUSE_FUSETIME1_0  
#define FUSE_FUSETIME1_0                        _MK_ADDR_CONST(0x4)
#define FUSE_FUSETIME1_0_WORD_COUNT                     0x1
#define FUSE_FUSETIME1_0_RESET_VAL                      _MK_MASK_CONST(0x11100000)
#define FUSE_FUSETIME1_0_RESET_MASK                     _MK_MASK_CONST(0xfff00000)
#define FUSE_FUSETIME1_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME1_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME1_0_READ_MASK                      _MK_MASK_CONST(0xfff00000)
#define FUSE_FUSETIME1_0_WRITE_MASK                     _MK_MASK_CONST(0xfff00000)
#define FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEL_SHIFT                      _MK_SHIFT_CONST(20)
#define FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEL_FIELD                      (_MK_MASK_CONST(0xf) << FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEL_SHIFT)
#define FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEL_RANGE                      23:20
#define FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEL_WOFFSET                    0x0
#define FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEL_DEFAULT                    _MK_MASK_CONST(0x1)
#define FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEL_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEOUT_SHIFT                    _MK_SHIFT_CONST(24)
#define FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEOUT_FIELD                    (_MK_MASK_CONST(0xf) << FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEOUT_SHIFT)
#define FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEOUT_RANGE                    27:24
#define FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEOUT_WOFFSET                  0x0
#define FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEOUT_DEFAULT                  _MK_MASK_CONST(0x1)
#define FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEOUT_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEOUT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME1_0_FUSETIME1_TSU_FUSEOUT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSETIME1_0_FUSETIME1_THOLD_FUSEL_SHIFT                    _MK_SHIFT_CONST(28)
#define FUSE_FUSETIME1_0_FUSETIME1_THOLD_FUSEL_FIELD                    (_MK_MASK_CONST(0xf) << FUSE_FUSETIME1_0_FUSETIME1_THOLD_FUSEL_SHIFT)
#define FUSE_FUSETIME1_0_FUSETIME1_THOLD_FUSEL_RANGE                    31:28
#define FUSE_FUSETIME1_0_FUSETIME1_THOLD_FUSEL_WOFFSET                  0x0
#define FUSE_FUSETIME1_0_FUSETIME1_THOLD_FUSEL_DEFAULT                  _MK_MASK_CONST(0x1)
#define FUSE_FUSETIME1_0_FUSETIME1_THOLD_FUSEL_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define FUSE_FUSETIME1_0_FUSETIME1_THOLD_FUSEL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME1_0_FUSETIME1_THOLD_FUSEL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_FUSETIME2_0  
#define FUSE_FUSETIME2_0                        _MK_ADDR_CONST(0x8)
#define FUSE_FUSETIME2_0_WORD_COUNT                     0x1
#define FUSE_FUSETIME2_0_RESET_VAL                      _MK_MASK_CONST(0x300001a)
#define FUSE_FUSETIME2_0_RESET_MASK                     _MK_MASK_CONST(0xff0fffff)
#define FUSE_FUSETIME2_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME2_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME2_0_READ_MASK                      _MK_MASK_CONST(0xff0fffff)
#define FUSE_FUSETIME2_0_WRITE_MASK                     _MK_MASK_CONST(0xff0fffff)
// Calculation based on 1us program time and 38.4615 ns fuse_clk period.
// Unfortunately the 1us program time is wrong, the real value is 5us.
// So the init value is wrong and must be multiplied by 5 to obtain the correct value:
//    init=0x00000082
#define FUSE_FUSETIME2_0_FUSETIME2_TPROGRAM_SHIFT                       _MK_SHIFT_CONST(0)
#define FUSE_FUSETIME2_0_FUSETIME2_TPROGRAM_FIELD                       (_MK_MASK_CONST(0xfffff) << FUSE_FUSETIME2_0_FUSETIME2_TPROGRAM_SHIFT)
#define FUSE_FUSETIME2_0_FUSETIME2_TPROGRAM_RANGE                       19:0
#define FUSE_FUSETIME2_0_FUSETIME2_TPROGRAM_WOFFSET                     0x0
#define FUSE_FUSETIME2_0_FUSETIME2_TPROGRAM_DEFAULT                     _MK_MASK_CONST(0x1a)
#define FUSE_FUSETIME2_0_FUSETIME2_TPROGRAM_DEFAULT_MASK                        _MK_MASK_CONST(0xfffff)
#define FUSE_FUSETIME2_0_FUSETIME2_TPROGRAM_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME2_0_FUSETIME2_TPROGRAM_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSETIME2_0_FUSETIME2_TSENSE_SHIFT                 _MK_SHIFT_CONST(24)
#define FUSE_FUSETIME2_0_FUSETIME2_TSENSE_FIELD                 (_MK_MASK_CONST(0xff) << FUSE_FUSETIME2_0_FUSETIME2_TSENSE_SHIFT)
#define FUSE_FUSETIME2_0_FUSETIME2_TSENSE_RANGE                 31:24
#define FUSE_FUSETIME2_0_FUSETIME2_TSENSE_WOFFSET                       0x0
#define FUSE_FUSETIME2_0_FUSETIME2_TSENSE_DEFAULT                       _MK_MASK_CONST(0x3)
#define FUSE_FUSETIME2_0_FUSETIME2_TSENSE_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define FUSE_FUSETIME2_0_FUSETIME2_TSENSE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSETIME2_0_FUSETIME2_TSENSE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA0_0  
#define FUSE_FUSEDATA0_0                        _MK_ADDR_CONST(0xc)
#define FUSE_FUSEDATA0_0_WORD_COUNT                     0x1
#define FUSE_FUSEDATA0_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA0_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA0_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA0_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA0_0_FUSEDATA0_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA0_0_FUSEDATA0_SHIFT)
#define FUSE_FUSEDATA0_0_FUSEDATA0_RANGE                        31:0
#define FUSE_FUSEDATA0_0_FUSEDATA0_WOFFSET                      0x0
#define FUSE_FUSEDATA0_0_FUSEDATA0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA0_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA0_0_FUSEDATA0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA0_0_FUSEDATA_MASTER_ENABLE__PRI_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA0_0_FUSEDATA_MASTER_ENABLE__PRI_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA0_0_FUSEDATA_MASTER_ENABLE__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA0_0_FUSEDATA_MASTER_ENABLE__PRI_ALIAS_0_RANGE                      0:0
#define FUSE_FUSEDATA0_0_FUSEDATA_MASTER_ENABLE__PRI_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA0_0_FUSEDATA_MASTER_ENABLE__PRI_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_MASTER_ENABLE__PRI_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA0_0_FUSEDATA_MASTER_ENABLE__PRI_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_MASTER_ENABLE__PRI_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA0_0_FUSEDATA_MASTER_DISABLE__PRI_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(1)
#define FUSE_FUSEDATA0_0_FUSEDATA_MASTER_DISABLE__PRI_ALIAS_0_FIELD                     (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA0_0_FUSEDATA_MASTER_DISABLE__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA0_0_FUSEDATA_MASTER_DISABLE__PRI_ALIAS_0_RANGE                     1:1
#define FUSE_FUSEDATA0_0_FUSEDATA_MASTER_DISABLE__PRI_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA0_0_FUSEDATA_MASTER_DISABLE__PRI_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_MASTER_DISABLE__PRI_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA0_0_FUSEDATA_MASTER_DISABLE__PRI_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_MASTER_DISABLE__PRI_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA0_0_FUSEDATA_BYPASS__PRI_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(2)
#define FUSE_FUSEDATA0_0_FUSEDATA_BYPASS__PRI_ALIAS_0_FIELD                     (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA0_0_FUSEDATA_BYPASS__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA0_0_FUSEDATA_BYPASS__PRI_ALIAS_0_RANGE                     2:2
#define FUSE_FUSEDATA0_0_FUSEDATA_BYPASS__PRI_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA0_0_FUSEDATA_BYPASS__PRI_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_BYPASS__PRI_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA0_0_FUSEDATA_BYPASS__PRI_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_BYPASS__PRI_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA0_0_FUSEDATA_RESERVE_BIT__PRI_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(3)
#define FUSE_FUSEDATA0_0_FUSEDATA_RESERVE_BIT__PRI_ALIAS_0_FIELD                        (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA0_0_FUSEDATA_RESERVE_BIT__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA0_0_FUSEDATA_RESERVE_BIT__PRI_ALIAS_0_RANGE                        3:3
#define FUSE_FUSEDATA0_0_FUSEDATA_RESERVE_BIT__PRI_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEDATA0_0_FUSEDATA_RESERVE_BIT__PRI_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_RESERVE_BIT__PRI_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA0_0_FUSEDATA_RESERVE_BIT__PRI_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_RESERVE_BIT__PRI_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA0_0_FUSEDATA_PRODUCTION_MODE__PRI_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(4)
#define FUSE_FUSEDATA0_0_FUSEDATA_PRODUCTION_MODE__PRI_ALIAS_0_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA0_0_FUSEDATA_PRODUCTION_MODE__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA0_0_FUSEDATA_PRODUCTION_MODE__PRI_ALIAS_0_RANGE                    4:4
#define FUSE_FUSEDATA0_0_FUSEDATA_PRODUCTION_MODE__PRI_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEDATA0_0_FUSEDATA_PRODUCTION_MODE__PRI_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_PRODUCTION_MODE__PRI_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA0_0_FUSEDATA_PRODUCTION_MODE__PRI_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_PRODUCTION_MODE__PRI_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA0_0_FUSEDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(5)
#define FUSE_FUSEDATA0_0_FUSEDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_FIELD                        (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA0_0_FUSEDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA0_0_FUSEDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_RANGE                        5:5
#define FUSE_FUSEDATA0_0_FUSEDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEDATA0_0_FUSEDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA0_0_FUSEDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA0_0_FUSEDATA_SKU_INFO__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(6)
#define FUSE_FUSEDATA0_0_FUSEDATA_SKU_INFO__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0xff) << FUSE_FUSEDATA0_0_FUSEDATA_SKU_INFO__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA0_0_FUSEDATA_SKU_INFO__PRI_ALIAS_0_RANGE                   13:6
#define FUSE_FUSEDATA0_0_FUSEDATA_SKU_INFO__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEDATA0_0_FUSEDATA_SKU_INFO__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_SKU_INFO__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define FUSE_FUSEDATA0_0_FUSEDATA_SKU_INFO__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_SKU_INFO__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA0_0_FUSEDATA_PROCESS_CALIB__PRI_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(14)
#define FUSE_FUSEDATA0_0_FUSEDATA_PROCESS_CALIB__PRI_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x3) << FUSE_FUSEDATA0_0_FUSEDATA_PROCESS_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA0_0_FUSEDATA_PROCESS_CALIB__PRI_ALIAS_0_RANGE                      15:14
#define FUSE_FUSEDATA0_0_FUSEDATA_PROCESS_CALIB__PRI_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA0_0_FUSEDATA_PROCESS_CALIB__PRI_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_PROCESS_CALIB__PRI_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define FUSE_FUSEDATA0_0_FUSEDATA_PROCESS_CALIB__PRI_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_PROCESS_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA0_0_FUSEDATA_IO_CALIB__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(16)
#define FUSE_FUSEDATA0_0_FUSEDATA_IO_CALIB__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x3ff) << FUSE_FUSEDATA0_0_FUSEDATA_IO_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA0_0_FUSEDATA_IO_CALIB__PRI_ALIAS_0_RANGE                   25:16
#define FUSE_FUSEDATA0_0_FUSEDATA_IO_CALIB__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEDATA0_0_FUSEDATA_IO_CALIB__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_IO_CALIB__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x3ff)
#define FUSE_FUSEDATA0_0_FUSEDATA_IO_CALIB__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_IO_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA0_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(26)
#define FUSE_FUSEDATA0_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x3f) << FUSE_FUSEDATA0_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA0_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_0_RANGE                      31:26
#define FUSE_FUSEDATA0_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA0_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define FUSE_FUSEDATA0_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA0_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA1_0  
#define FUSE_FUSEDATA1_0                        _MK_ADDR_CONST(0x10)
#define FUSE_FUSEDATA1_0_WORD_COUNT                     0x1
#define FUSE_FUSEDATA1_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA1_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA1_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA1_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA1_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA1_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA1_0_FUSEDATA1_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA1_0_FUSEDATA1_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA1_0_FUSEDATA1_SHIFT)
#define FUSE_FUSEDATA1_0_FUSEDATA1_RANGE                        31:0
#define FUSE_FUSEDATA1_0_FUSEDATA1_WOFFSET                      0x0
#define FUSE_FUSEDATA1_0_FUSEDATA1_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA1_0_FUSEDATA1_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA1_0_FUSEDATA1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA1_0_FUSEDATA1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_1_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_1_FIELD                      (_MK_MASK_CONST(0x3) << FUSE_FUSEDATA1_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_1_RANGE                      1:0
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_1_WOFFSET                    0x0
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_1_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_1_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_CRT_CALIB__PRI_ALIAS_1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(2)
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_FIELD                     (_MK_MASK_CONST(0xff) << FUSE_FUSEDATA1_0_FUSEDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_RANGE                     9:2
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(10)
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_FIELD                     (_MK_MASK_CONST(0xff) << FUSE_FUSEDATA1_0_FUSEDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_RANGE                     17:10
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA1_0_FUSEDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_0__PRI_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(18)
#define FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_0__PRI_ALIAS_0_FIELD                     (_MK_MASK_CONST(0x7f) << FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_0__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_0__PRI_ALIAS_0_RANGE                     24:18
#define FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_0__PRI_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_0__PRI_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_0__PRI_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0x7f)
#define FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_0__PRI_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_0__PRI_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_1__PRI_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(25)
#define FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_1__PRI_ALIAS_0_FIELD                     (_MK_MASK_CONST(0x7f) << FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_1__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_1__PRI_ALIAS_0_RANGE                     31:25
#define FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_1__PRI_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_1__PRI_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_1__PRI_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0x7f)
#define FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_1__PRI_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA1_0_FUSEDATA_CMC_DATARAM0_1__PRI_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA2_0  
#define FUSE_FUSEDATA2_0                        _MK_ADDR_CONST(0x14)
#define FUSE_FUSEDATA2_0_WORD_COUNT                     0x1
#define FUSE_FUSEDATA2_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA2_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA2_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA2_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA2_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA2_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA2_0_FUSEDATA2_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA2_0_FUSEDATA2_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA2_0_FUSEDATA2_SHIFT)
#define FUSE_FUSEDATA2_0_FUSEDATA2_RANGE                        31:0
#define FUSE_FUSEDATA2_0_FUSEDATA2_WOFFSET                      0x0
#define FUSE_FUSEDATA2_0_FUSEDATA2_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA2_0_FUSEDATA2_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA2_0_FUSEDATA2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA2_0_FUSEDATA2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_2__PRI_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_2__PRI_ALIAS_0_FIELD                     (_MK_MASK_CONST(0x7f) << FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_2__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_2__PRI_ALIAS_0_RANGE                     6:0
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_2__PRI_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_2__PRI_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_2__PRI_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0x7f)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_2__PRI_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_2__PRI_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_3__PRI_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(7)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_3__PRI_ALIAS_0_FIELD                     (_MK_MASK_CONST(0x7f) << FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_3__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_3__PRI_ALIAS_0_RANGE                     13:7
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_3__PRI_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_3__PRI_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_3__PRI_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0x7f)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_3__PRI_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM0_3__PRI_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_0__PRI_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(14)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_0__PRI_ALIAS_0_FIELD                     (_MK_MASK_CONST(0x7f) << FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_0__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_0__PRI_ALIAS_0_RANGE                     20:14
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_0__PRI_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_0__PRI_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_0__PRI_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0x7f)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_0__PRI_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_0__PRI_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_1__PRI_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(21)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_1__PRI_ALIAS_0_FIELD                     (_MK_MASK_CONST(0x7f) << FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_1__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_1__PRI_ALIAS_0_RANGE                     27:21
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_1__PRI_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_1__PRI_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_1__PRI_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0x7f)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_1__PRI_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_1__PRI_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(28)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_0_FIELD                     (_MK_MASK_CONST(0xf) << FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_0_RANGE                     31:28
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA2_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA3_0  
#define FUSE_FUSEDATA3_0                        _MK_ADDR_CONST(0x18)
#define FUSE_FUSEDATA3_0_WORD_COUNT                     0x1
#define FUSE_FUSEDATA3_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA3_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA3_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA3_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA3_0_FUSEDATA3_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA3_0_FUSEDATA3_SHIFT)
#define FUSE_FUSEDATA3_0_FUSEDATA3_RANGE                        31:0
#define FUSE_FUSEDATA3_0_FUSEDATA3_WOFFSET                      0x0
#define FUSE_FUSEDATA3_0_FUSEDATA3_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA3_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA3_0_FUSEDATA3_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA3_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_1_SHIFT                     _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_1_FIELD                     (_MK_MASK_CONST(0x7) << FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_1_RANGE                     2:0
#define FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_1_WOFFSET                   0x0
#define FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_1_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_2__PRI_ALIAS_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_3__PRI_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(3)
#define FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_3__PRI_ALIAS_0_FIELD                     (_MK_MASK_CONST(0x7f) << FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_3__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_3__PRI_ALIAS_0_RANGE                     9:3
#define FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_3__PRI_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_3__PRI_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_3__PRI_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0x7f)
#define FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_3__PRI_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA_CMC_DATARAM1_3__PRI_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA3_0_FUSEDATA_FA__PRI_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(10)
#define FUSE_FUSEDATA3_0_FUSEDATA_FA__PRI_ALIAS_0_FIELD                 (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA3_0_FUSEDATA_FA__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA3_0_FUSEDATA_FA__PRI_ALIAS_0_RANGE                 10:10
#define FUSE_FUSEDATA3_0_FUSEDATA_FA__PRI_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEDATA3_0_FUSEDATA_FA__PRI_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA_FA__PRI_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA3_0_FUSEDATA_FA__PRI_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA_FA__PRI_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA3_0_FUSEDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(11)
#define FUSE_FUSEDATA3_0_FUSEDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_FIELD                        (_MK_MASK_CONST(0xf) << FUSE_FUSEDATA3_0_FUSEDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA3_0_FUSEDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_RANGE                        14:11
#define FUSE_FUSEDATA3_0_FUSEDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEDATA3_0_FUSEDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define FUSE_FUSEDATA3_0_FUSEDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(15)
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x3f) << FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_RANGE                   20:15
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x3f)
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(21)
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x3f) << FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_RANGE                   26:21
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x3f)
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(27)
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x1f) << FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_RANGE                   31:27
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA3_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA4_0  
#define FUSE_FUSEDATA4_0                        _MK_ADDR_CONST(0x1c)
#define FUSE_FUSEDATA4_0_WORD_COUNT                     0x1
#define FUSE_FUSEDATA4_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA4_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA4_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA4_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA4_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA4_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA4_0_FUSEDATA4_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA4_0_FUSEDATA4_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA4_0_FUSEDATA4_SHIFT)
#define FUSE_FUSEDATA4_0_FUSEDATA4_RANGE                        31:0
#define FUSE_FUSEDATA4_0_FUSEDATA4_WOFFSET                      0x0
#define FUSE_FUSEDATA4_0_FUSEDATA4_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA4_0_FUSEDATA4_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA4_0_FUSEDATA4_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA4_0_FUSEDATA4_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_SHIFT                   _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_FIELD                   (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_RANGE                   0:0
#define FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_WOFFSET                 0x0
#define FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(1)
#define FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x3f) << FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_RANGE                   6:1
#define FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x3f)
#define FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA4_0_FUSEDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA4_0_FUSEDATA_SECURITY_MODE__PRI_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(7)
#define FUSE_FUSEDATA4_0_FUSEDATA_SECURITY_MODE__PRI_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA4_0_FUSEDATA_SECURITY_MODE__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA4_0_FUSEDATA_SECURITY_MODE__PRI_ALIAS_0_RANGE                      7:7
#define FUSE_FUSEDATA4_0_FUSEDATA_SECURITY_MODE__PRI_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA4_0_FUSEDATA_SECURITY_MODE__PRI_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA4_0_FUSEDATA_SECURITY_MODE__PRI_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA4_0_FUSEDATA_SECURITY_MODE__PRI_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA4_0_FUSEDATA_SECURITY_MODE__PRI_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA4_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(8)
#define FUSE_FUSEDATA4_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0xffffff) << FUSE_FUSEDATA4_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA4_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_0_RANGE                       31:8
#define FUSE_FUSEDATA4_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA4_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA4_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0xffffff)
#define FUSE_FUSEDATA4_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA4_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA5_0  
#define FUSE_FUSEDATA5_0                        _MK_ADDR_CONST(0x20)
#define FUSE_FUSEDATA5_0_WORD_COUNT                     0x1
#define FUSE_FUSEDATA5_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA5_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA5_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA5_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA5_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA5_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA5_0_FUSEDATA5_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA5_0_FUSEDATA5_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA5_0_FUSEDATA5_SHIFT)
#define FUSE_FUSEDATA5_0_FUSEDATA5_RANGE                        31:0
#define FUSE_FUSEDATA5_0_FUSEDATA5_WOFFSET                      0x0
#define FUSE_FUSEDATA5_0_FUSEDATA5_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA5_0_FUSEDATA5_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA5_0_FUSEDATA5_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA5_0_FUSEDATA5_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_1_SHIFT                       _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_1_FIELD                       (_MK_MASK_CONST(0xff) << FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_1_RANGE                       7:0
#define FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_1_WOFFSET                     0x0
#define FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_1_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_1_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY0__PRI_ALIAS_1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(8)
#define FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0xffffff) << FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_0_RANGE                       31:8
#define FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0xffffff)
#define FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA5_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA6_0  
#define FUSE_FUSEDATA6_0                        _MK_ADDR_CONST(0x24)
#define FUSE_FUSEDATA6_0_WORD_COUNT                     0x1
#define FUSE_FUSEDATA6_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA6_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA6_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA6_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA6_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA6_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA6_0_FUSEDATA6_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA6_0_FUSEDATA6_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA6_0_FUSEDATA6_SHIFT)
#define FUSE_FUSEDATA6_0_FUSEDATA6_RANGE                        31:0
#define FUSE_FUSEDATA6_0_FUSEDATA6_WOFFSET                      0x0
#define FUSE_FUSEDATA6_0_FUSEDATA6_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA6_0_FUSEDATA6_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA6_0_FUSEDATA6_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA6_0_FUSEDATA6_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_1_SHIFT                       _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_1_FIELD                       (_MK_MASK_CONST(0xff) << FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_1_RANGE                       7:0
#define FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_1_WOFFSET                     0x0
#define FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_1_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_1_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY1__PRI_ALIAS_1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(8)
#define FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0xffffff) << FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_0_RANGE                       31:8
#define FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0xffffff)
#define FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA6_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA7_0  
#define FUSE_FUSEDATA7_0                        _MK_ADDR_CONST(0x28)
#define FUSE_FUSEDATA7_0_WORD_COUNT                     0x1
#define FUSE_FUSEDATA7_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA7_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA7_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA7_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA7_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA7_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA7_0_FUSEDATA7_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA7_0_FUSEDATA7_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA7_0_FUSEDATA7_SHIFT)
#define FUSE_FUSEDATA7_0_FUSEDATA7_RANGE                        31:0
#define FUSE_FUSEDATA7_0_FUSEDATA7_WOFFSET                      0x0
#define FUSE_FUSEDATA7_0_FUSEDATA7_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA7_0_FUSEDATA7_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA7_0_FUSEDATA7_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA7_0_FUSEDATA7_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_1_SHIFT                       _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_1_FIELD                       (_MK_MASK_CONST(0xff) << FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_1_RANGE                       7:0
#define FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_1_WOFFSET                     0x0
#define FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_1_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_1_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY2__PRI_ALIAS_1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(8)
#define FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0xffffff) << FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_0_RANGE                       31:8
#define FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0xffffff)
#define FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA7_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA8_0  
#define FUSE_FUSEDATA8_0                        _MK_ADDR_CONST(0x2c)
#define FUSE_FUSEDATA8_0_WORD_COUNT                     0x1
#define FUSE_FUSEDATA8_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA8_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA8_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA8_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA8_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA8_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA8_0_FUSEDATA8_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA8_0_FUSEDATA8_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA8_0_FUSEDATA8_SHIFT)
#define FUSE_FUSEDATA8_0_FUSEDATA8_RANGE                        31:0
#define FUSE_FUSEDATA8_0_FUSEDATA8_WOFFSET                      0x0
#define FUSE_FUSEDATA8_0_FUSEDATA8_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA8_0_FUSEDATA8_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA8_0_FUSEDATA8_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA8_0_FUSEDATA8_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_1_SHIFT                       _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_1_FIELD                       (_MK_MASK_CONST(0xff) << FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_1_RANGE                       7:0
#define FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_1_WOFFSET                     0x0
#define FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_1_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_1_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY3__PRI_ALIAS_1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(8)
#define FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0xffffff) << FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_0_RANGE                       31:8
#define FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0xffffff)
#define FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA8_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA9_0  
#define FUSE_FUSEDATA9_0                        _MK_ADDR_CONST(0x30)
#define FUSE_FUSEDATA9_0_WORD_COUNT                     0x1
#define FUSE_FUSEDATA9_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA9_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA9_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA9_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA9_0_FUSEDATA9_FIELD                        (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA9_0_FUSEDATA9_SHIFT)
#define FUSE_FUSEDATA9_0_FUSEDATA9_RANGE                        31:0
#define FUSE_FUSEDATA9_0_FUSEDATA9_WOFFSET                      0x0
#define FUSE_FUSEDATA9_0_FUSEDATA9_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA9_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA9_0_FUSEDATA9_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA9_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA9_0_FUSEDATA_MASTER_ENABLE__RED_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(24)
#define FUSE_FUSEDATA9_0_FUSEDATA_MASTER_ENABLE__RED_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA9_0_FUSEDATA_MASTER_ENABLE__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA9_0_FUSEDATA_MASTER_ENABLE__RED_ALIAS_0_RANGE                      24:24
#define FUSE_FUSEDATA9_0_FUSEDATA_MASTER_ENABLE__RED_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA9_0_FUSEDATA_MASTER_ENABLE__RED_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_MASTER_ENABLE__RED_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA9_0_FUSEDATA_MASTER_ENABLE__RED_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_MASTER_ENABLE__RED_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA9_0_FUSEDATA_MASTER_DISABLE__RED_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(25)
#define FUSE_FUSEDATA9_0_FUSEDATA_MASTER_DISABLE__RED_ALIAS_0_FIELD                     (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA9_0_FUSEDATA_MASTER_DISABLE__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA9_0_FUSEDATA_MASTER_DISABLE__RED_ALIAS_0_RANGE                     25:25
#define FUSE_FUSEDATA9_0_FUSEDATA_MASTER_DISABLE__RED_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA9_0_FUSEDATA_MASTER_DISABLE__RED_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_MASTER_DISABLE__RED_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA9_0_FUSEDATA_MASTER_DISABLE__RED_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_MASTER_DISABLE__RED_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA9_0_FUSEDATA_BYPASS__RED_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(26)
#define FUSE_FUSEDATA9_0_FUSEDATA_BYPASS__RED_ALIAS_0_FIELD                     (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA9_0_FUSEDATA_BYPASS__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA9_0_FUSEDATA_BYPASS__RED_ALIAS_0_RANGE                     26:26
#define FUSE_FUSEDATA9_0_FUSEDATA_BYPASS__RED_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA9_0_FUSEDATA_BYPASS__RED_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_BYPASS__RED_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA9_0_FUSEDATA_BYPASS__RED_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_BYPASS__RED_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA9_0_FUSEDATA_RESERVE_BIT__RED_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(27)
#define FUSE_FUSEDATA9_0_FUSEDATA_RESERVE_BIT__RED_ALIAS_0_FIELD                        (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA9_0_FUSEDATA_RESERVE_BIT__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA9_0_FUSEDATA_RESERVE_BIT__RED_ALIAS_0_RANGE                        27:27
#define FUSE_FUSEDATA9_0_FUSEDATA_RESERVE_BIT__RED_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEDATA9_0_FUSEDATA_RESERVE_BIT__RED_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_RESERVE_BIT__RED_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA9_0_FUSEDATA_RESERVE_BIT__RED_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_RESERVE_BIT__RED_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA9_0_FUSEDATA_PRODUCTION_MODE__RED_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(28)
#define FUSE_FUSEDATA9_0_FUSEDATA_PRODUCTION_MODE__RED_ALIAS_0_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA9_0_FUSEDATA_PRODUCTION_MODE__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA9_0_FUSEDATA_PRODUCTION_MODE__RED_ALIAS_0_RANGE                    28:28
#define FUSE_FUSEDATA9_0_FUSEDATA_PRODUCTION_MODE__RED_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEDATA9_0_FUSEDATA_PRODUCTION_MODE__RED_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_PRODUCTION_MODE__RED_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA9_0_FUSEDATA_PRODUCTION_MODE__RED_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_PRODUCTION_MODE__RED_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA9_0_FUSEDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(29)
#define FUSE_FUSEDATA9_0_FUSEDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_FIELD                        (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA9_0_FUSEDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA9_0_FUSEDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_RANGE                        29:29
#define FUSE_FUSEDATA9_0_FUSEDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEDATA9_0_FUSEDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA9_0_FUSEDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA9_0_FUSEDATA_SKU_INFO__RED_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(30)
#define FUSE_FUSEDATA9_0_FUSEDATA_SKU_INFO__RED_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x3) << FUSE_FUSEDATA9_0_FUSEDATA_SKU_INFO__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA9_0_FUSEDATA_SKU_INFO__RED_ALIAS_0_RANGE                   31:30
#define FUSE_FUSEDATA9_0_FUSEDATA_SKU_INFO__RED_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEDATA9_0_FUSEDATA_SKU_INFO__RED_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_SKU_INFO__RED_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define FUSE_FUSEDATA9_0_FUSEDATA_SKU_INFO__RED_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_SKU_INFO__RED_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA9_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_1_SHIFT                       _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA9_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_1_FIELD                       (_MK_MASK_CONST(0xff) << FUSE_FUSEDATA9_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEDATA9_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_1_RANGE                       7:0
#define FUSE_FUSEDATA9_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_1_WOFFSET                     0x0
#define FUSE_FUSEDATA9_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_1_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_1_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define FUSE_FUSEDATA9_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_PRIVATE_KEY4__PRI_ALIAS_1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA9_0_FUSEDATA_ARM_JTAG_DIS__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(8)
#define FUSE_FUSEDATA9_0_FUSEDATA_ARM_JTAG_DIS__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA9_0_FUSEDATA_ARM_JTAG_DIS__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA9_0_FUSEDATA_ARM_JTAG_DIS__PRI_ALIAS_0_RANGE                       8:8
#define FUSE_FUSEDATA9_0_FUSEDATA_ARM_JTAG_DIS__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA9_0_FUSEDATA_ARM_JTAG_DIS__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_ARM_JTAG_DIS__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA9_0_FUSEDATA_ARM_JTAG_DIS__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_ARM_JTAG_DIS__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA9_0_FUSEDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(9)
#define FUSE_FUSEDATA9_0_FUSEDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x7f) << FUSE_FUSEDATA9_0_FUSEDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA9_0_FUSEDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_RANGE                   15:9
#define FUSE_FUSEDATA9_0_FUSEDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEDATA9_0_FUSEDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x7f)
#define FUSE_FUSEDATA9_0_FUSEDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA9_0_FUSEDATA_RESERVED_SW__PRI_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(16)
#define FUSE_FUSEDATA9_0_FUSEDATA_RESERVED_SW__PRI_ALIAS_0_FIELD                        (_MK_MASK_CONST(0xff) << FUSE_FUSEDATA9_0_FUSEDATA_RESERVED_SW__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA9_0_FUSEDATA_RESERVED_SW__PRI_ALIAS_0_RANGE                        23:16
#define FUSE_FUSEDATA9_0_FUSEDATA_RESERVED_SW__PRI_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEDATA9_0_FUSEDATA_RESERVED_SW__PRI_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_RESERVED_SW__PRI_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define FUSE_FUSEDATA9_0_FUSEDATA_RESERVED_SW__PRI_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA9_0_FUSEDATA_RESERVED_SW__PRI_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA10_0  
#define FUSE_FUSEDATA10_0                       _MK_ADDR_CONST(0x34)
#define FUSE_FUSEDATA10_0_WORD_COUNT                    0x1
#define FUSE_FUSEDATA10_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA10_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA10_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA10_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA10_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA10_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA10_0_FUSEDATA10_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA10_0_FUSEDATA10_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA10_0_FUSEDATA10_SHIFT)
#define FUSE_FUSEDATA10_0_FUSEDATA10_RANGE                      31:0
#define FUSE_FUSEDATA10_0_FUSEDATA10_WOFFSET                    0x0
#define FUSE_FUSEDATA10_0_FUSEDATA10_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA10_0_FUSEDATA10_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA10_0_FUSEDATA10_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA10_0_FUSEDATA10_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA10_0_FUSEDATA_SKU_INFO__RED_ALIAS_1_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA10_0_FUSEDATA_SKU_INFO__RED_ALIAS_1_FIELD                  (_MK_MASK_CONST(0x3f) << FUSE_FUSEDATA10_0_FUSEDATA_SKU_INFO__RED_ALIAS_1_SHIFT)
#define FUSE_FUSEDATA10_0_FUSEDATA_SKU_INFO__RED_ALIAS_1_RANGE                  5:0
#define FUSE_FUSEDATA10_0_FUSEDATA_SKU_INFO__RED_ALIAS_1_WOFFSET                        0x0
#define FUSE_FUSEDATA10_0_FUSEDATA_SKU_INFO__RED_ALIAS_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA10_0_FUSEDATA_SKU_INFO__RED_ALIAS_1_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define FUSE_FUSEDATA10_0_FUSEDATA_SKU_INFO__RED_ALIAS_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA10_0_FUSEDATA_SKU_INFO__RED_ALIAS_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA10_0_FUSEDATA_PROCESS_CALIB__RED_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(6)
#define FUSE_FUSEDATA10_0_FUSEDATA_PROCESS_CALIB__RED_ALIAS_0_FIELD                     (_MK_MASK_CONST(0x3) << FUSE_FUSEDATA10_0_FUSEDATA_PROCESS_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA10_0_FUSEDATA_PROCESS_CALIB__RED_ALIAS_0_RANGE                     7:6
#define FUSE_FUSEDATA10_0_FUSEDATA_PROCESS_CALIB__RED_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA10_0_FUSEDATA_PROCESS_CALIB__RED_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA10_0_FUSEDATA_PROCESS_CALIB__RED_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define FUSE_FUSEDATA10_0_FUSEDATA_PROCESS_CALIB__RED_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA10_0_FUSEDATA_PROCESS_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA10_0_FUSEDATA_IO_CALIB__RED_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(8)
#define FUSE_FUSEDATA10_0_FUSEDATA_IO_CALIB__RED_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x3ff) << FUSE_FUSEDATA10_0_FUSEDATA_IO_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA10_0_FUSEDATA_IO_CALIB__RED_ALIAS_0_RANGE                  17:8
#define FUSE_FUSEDATA10_0_FUSEDATA_IO_CALIB__RED_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEDATA10_0_FUSEDATA_IO_CALIB__RED_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA10_0_FUSEDATA_IO_CALIB__RED_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x3ff)
#define FUSE_FUSEDATA10_0_FUSEDATA_IO_CALIB__RED_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA10_0_FUSEDATA_IO_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA10_0_FUSEDATA_DAC_CRT_CALIB__RED_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(18)
#define FUSE_FUSEDATA10_0_FUSEDATA_DAC_CRT_CALIB__RED_ALIAS_0_FIELD                     (_MK_MASK_CONST(0xff) << FUSE_FUSEDATA10_0_FUSEDATA_DAC_CRT_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA10_0_FUSEDATA_DAC_CRT_CALIB__RED_ALIAS_0_RANGE                     25:18
#define FUSE_FUSEDATA10_0_FUSEDATA_DAC_CRT_CALIB__RED_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA10_0_FUSEDATA_DAC_CRT_CALIB__RED_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA10_0_FUSEDATA_DAC_CRT_CALIB__RED_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define FUSE_FUSEDATA10_0_FUSEDATA_DAC_CRT_CALIB__RED_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA10_0_FUSEDATA_DAC_CRT_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA10_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(26)
#define FUSE_FUSEDATA10_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_0_FIELD                    (_MK_MASK_CONST(0x3f) << FUSE_FUSEDATA10_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA10_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_0_RANGE                    31:26
#define FUSE_FUSEDATA10_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEDATA10_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA10_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0x3f)
#define FUSE_FUSEDATA10_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA10_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA11_0  
#define FUSE_FUSEDATA11_0                       _MK_ADDR_CONST(0x38)
#define FUSE_FUSEDATA11_0_WORD_COUNT                    0x1
#define FUSE_FUSEDATA11_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA11_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA11_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_FUSEDATA11_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA11_0_FUSEDATA11_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA11_0_FUSEDATA11_SHIFT)
#define FUSE_FUSEDATA11_0_FUSEDATA11_RANGE                      31:0
#define FUSE_FUSEDATA11_0_FUSEDATA11_WOFFSET                    0x0
#define FUSE_FUSEDATA11_0_FUSEDATA11_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_FUSEDATA11_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA11_0_FUSEDATA11_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_FUSEDATA11_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA11_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_1_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA11_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_1_FIELD                    (_MK_MASK_CONST(0x3) << FUSE_FUSEDATA11_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_1_SHIFT)
#define FUSE_FUSEDATA11_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_1_RANGE                    1:0
#define FUSE_FUSEDATA11_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_1_WOFFSET                  0x0
#define FUSE_FUSEDATA11_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_1_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define FUSE_FUSEDATA11_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_FUSEDATA_DAC_HDTV_CALIB__RED_ALIAS_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA11_0_FUSEDATA_DAC_SDTV_CALIB__RED_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(2)
#define FUSE_FUSEDATA11_0_FUSEDATA_DAC_SDTV_CALIB__RED_ALIAS_0_FIELD                    (_MK_MASK_CONST(0xff) << FUSE_FUSEDATA11_0_FUSEDATA_DAC_SDTV_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA11_0_FUSEDATA_DAC_SDTV_CALIB__RED_ALIAS_0_RANGE                    9:2
#define FUSE_FUSEDATA11_0_FUSEDATA_DAC_SDTV_CALIB__RED_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEDATA11_0_FUSEDATA_DAC_SDTV_CALIB__RED_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_FUSEDATA_DAC_SDTV_CALIB__RED_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define FUSE_FUSEDATA11_0_FUSEDATA_DAC_SDTV_CALIB__RED_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_FUSEDATA_DAC_SDTV_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_0__RED_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(10)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_0__RED_ALIAS_0_FIELD                    (_MK_MASK_CONST(0x7f) << FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_0__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_0__RED_ALIAS_0_RANGE                    16:10
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_0__RED_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_0__RED_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_0__RED_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0x7f)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_0__RED_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_0__RED_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_1__RED_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(17)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_1__RED_ALIAS_0_FIELD                    (_MK_MASK_CONST(0x7f) << FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_1__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_1__RED_ALIAS_0_RANGE                    23:17
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_1__RED_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_1__RED_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_1__RED_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0x7f)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_1__RED_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_1__RED_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_2__RED_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(24)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_2__RED_ALIAS_0_FIELD                    (_MK_MASK_CONST(0x7f) << FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_2__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_2__RED_ALIAS_0_RANGE                    30:24
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_2__RED_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_2__RED_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_2__RED_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0x7f)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_2__RED_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_2__RED_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(31)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_0_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_0_RANGE                    31:31
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA11_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA12_0  
#define FUSE_FUSEDATA12_0                       _MK_ADDR_CONST(0x3c)
#define FUSE_FUSEDATA12_0_WORD_COUNT                    0x1
#define FUSE_FUSEDATA12_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA12_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA12_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA12_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA12_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA12_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA12_0_FUSEDATA12_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA12_0_FUSEDATA12_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA12_0_FUSEDATA12_SHIFT)
#define FUSE_FUSEDATA12_0_FUSEDATA12_RANGE                      31:0
#define FUSE_FUSEDATA12_0_FUSEDATA12_WOFFSET                    0x0
#define FUSE_FUSEDATA12_0_FUSEDATA12_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA12_0_FUSEDATA12_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA12_0_FUSEDATA12_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA12_0_FUSEDATA12_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_1_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_1_FIELD                    (_MK_MASK_CONST(0x3f) << FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_1_SHIFT)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_1_RANGE                    5:0
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_1_WOFFSET                  0x0
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_1_DEFAULT_MASK                     _MK_MASK_CONST(0x3f)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM0_3__RED_ALIAS_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_0__RED_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(6)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_0__RED_ALIAS_0_FIELD                    (_MK_MASK_CONST(0x7f) << FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_0__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_0__RED_ALIAS_0_RANGE                    12:6
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_0__RED_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_0__RED_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_0__RED_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0x7f)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_0__RED_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_0__RED_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_1__RED_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(13)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_1__RED_ALIAS_0_FIELD                    (_MK_MASK_CONST(0x7f) << FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_1__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_1__RED_ALIAS_0_RANGE                    19:13
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_1__RED_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_1__RED_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_1__RED_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0x7f)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_1__RED_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_1__RED_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_2__RED_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(20)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_2__RED_ALIAS_0_FIELD                    (_MK_MASK_CONST(0x7f) << FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_2__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_2__RED_ALIAS_0_RANGE                    26:20
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_2__RED_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_2__RED_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_2__RED_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0x7f)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_2__RED_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_2__RED_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(27)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_0_FIELD                    (_MK_MASK_CONST(0x1f) << FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_0_RANGE                    31:27
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA12_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA13_0  
#define FUSE_FUSEDATA13_0                       _MK_ADDR_CONST(0x40)
#define FUSE_FUSEDATA13_0_WORD_COUNT                    0x1
#define FUSE_FUSEDATA13_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA13_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA13_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA13_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA13_0_FUSEDATA13_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA13_0_FUSEDATA13_SHIFT)
#define FUSE_FUSEDATA13_0_FUSEDATA13_RANGE                      31:0
#define FUSE_FUSEDATA13_0_FUSEDATA13_WOFFSET                    0x0
#define FUSE_FUSEDATA13_0_FUSEDATA13_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA13_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA13_0_FUSEDATA13_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA13_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA13_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_1_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA13_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_1_FIELD                    (_MK_MASK_CONST(0x3) << FUSE_FUSEDATA13_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_1_SHIFT)
#define FUSE_FUSEDATA13_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_1_RANGE                    1:0
#define FUSE_FUSEDATA13_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_1_WOFFSET                  0x0
#define FUSE_FUSEDATA13_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_1_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define FUSE_FUSEDATA13_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA_CMC_DATARAM1_3__RED_ALIAS_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA13_0_FUSEDATA_FA__RED_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(2)
#define FUSE_FUSEDATA13_0_FUSEDATA_FA__RED_ALIAS_0_FIELD                        (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA13_0_FUSEDATA_FA__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA13_0_FUSEDATA_FA__RED_ALIAS_0_RANGE                        2:2
#define FUSE_FUSEDATA13_0_FUSEDATA_FA__RED_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEDATA13_0_FUSEDATA_FA__RED_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA_FA__RED_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA13_0_FUSEDATA_FA__RED_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA_FA__RED_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA13_0_FUSEDATA_RESERVED_PRODUCTION__RED_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(3)
#define FUSE_FUSEDATA13_0_FUSEDATA_RESERVED_PRODUCTION__RED_ALIAS_0_FIELD                       (_MK_MASK_CONST(0xf) << FUSE_FUSEDATA13_0_FUSEDATA_RESERVED_PRODUCTION__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA13_0_FUSEDATA_RESERVED_PRODUCTION__RED_ALIAS_0_RANGE                       6:3
#define FUSE_FUSEDATA13_0_FUSEDATA_RESERVED_PRODUCTION__RED_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA13_0_FUSEDATA_RESERVED_PRODUCTION__RED_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA_RESERVED_PRODUCTION__RED_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define FUSE_FUSEDATA13_0_FUSEDATA_RESERVED_PRODUCTION__RED_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA_RESERVED_PRODUCTION__RED_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(7)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x3f) << FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_RANGE                  12:7
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(13)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x3f) << FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_RANGE                  18:13
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(19)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x3f) << FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_RANGE                  24:19
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(25)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x3f) << FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_RANGE                  30:25
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA13_0_FUSEDATA_SECURITY_MODE__RED_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(31)
#define FUSE_FUSEDATA13_0_FUSEDATA_SECURITY_MODE__RED_ALIAS_0_FIELD                     (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA13_0_FUSEDATA_SECURITY_MODE__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA13_0_FUSEDATA_SECURITY_MODE__RED_ALIAS_0_RANGE                     31:31
#define FUSE_FUSEDATA13_0_FUSEDATA_SECURITY_MODE__RED_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEDATA13_0_FUSEDATA_SECURITY_MODE__RED_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA_SECURITY_MODE__RED_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA13_0_FUSEDATA_SECURITY_MODE__RED_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA13_0_FUSEDATA_SECURITY_MODE__RED_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA14_0  
#define FUSE_FUSEDATA14_0                       _MK_ADDR_CONST(0x44)
#define FUSE_FUSEDATA14_0_WORD_COUNT                    0x1
#define FUSE_FUSEDATA14_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA14_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA14_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA14_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA14_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA14_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA14_0_FUSEDATA14_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA14_0_FUSEDATA14_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA14_0_FUSEDATA14_SHIFT)
#define FUSE_FUSEDATA14_0_FUSEDATA14_RANGE                      31:0
#define FUSE_FUSEDATA14_0_FUSEDATA14_WOFFSET                    0x0
#define FUSE_FUSEDATA14_0_FUSEDATA14_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA14_0_FUSEDATA14_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA14_0_FUSEDATA14_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA14_0_FUSEDATA14_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA14_0_FUSEDATA_PRIVATE_KEY0__RED_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA14_0_FUSEDATA_PRIVATE_KEY0__RED_ALIAS_0_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA14_0_FUSEDATA_PRIVATE_KEY0__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA14_0_FUSEDATA_PRIVATE_KEY0__RED_ALIAS_0_RANGE                      31:0
#define FUSE_FUSEDATA14_0_FUSEDATA_PRIVATE_KEY0__RED_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA14_0_FUSEDATA_PRIVATE_KEY0__RED_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA14_0_FUSEDATA_PRIVATE_KEY0__RED_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA14_0_FUSEDATA_PRIVATE_KEY0__RED_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA14_0_FUSEDATA_PRIVATE_KEY0__RED_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA15_0  
#define FUSE_FUSEDATA15_0                       _MK_ADDR_CONST(0x48)
#define FUSE_FUSEDATA15_0_WORD_COUNT                    0x1
#define FUSE_FUSEDATA15_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA15_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA15_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA15_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA15_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA15_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA15_0_FUSEDATA15_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA15_0_FUSEDATA15_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA15_0_FUSEDATA15_SHIFT)
#define FUSE_FUSEDATA15_0_FUSEDATA15_RANGE                      31:0
#define FUSE_FUSEDATA15_0_FUSEDATA15_WOFFSET                    0x0
#define FUSE_FUSEDATA15_0_FUSEDATA15_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA15_0_FUSEDATA15_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA15_0_FUSEDATA15_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA15_0_FUSEDATA15_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA15_0_FUSEDATA_PRIVATE_KEY1__RED_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA15_0_FUSEDATA_PRIVATE_KEY1__RED_ALIAS_0_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA15_0_FUSEDATA_PRIVATE_KEY1__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA15_0_FUSEDATA_PRIVATE_KEY1__RED_ALIAS_0_RANGE                      31:0
#define FUSE_FUSEDATA15_0_FUSEDATA_PRIVATE_KEY1__RED_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA15_0_FUSEDATA_PRIVATE_KEY1__RED_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA15_0_FUSEDATA_PRIVATE_KEY1__RED_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA15_0_FUSEDATA_PRIVATE_KEY1__RED_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA15_0_FUSEDATA_PRIVATE_KEY1__RED_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA16_0  
#define FUSE_FUSEDATA16_0                       _MK_ADDR_CONST(0x4c)
#define FUSE_FUSEDATA16_0_WORD_COUNT                    0x1
#define FUSE_FUSEDATA16_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA16_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA16_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA16_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA16_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA16_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA16_0_FUSEDATA16_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA16_0_FUSEDATA16_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA16_0_FUSEDATA16_SHIFT)
#define FUSE_FUSEDATA16_0_FUSEDATA16_RANGE                      31:0
#define FUSE_FUSEDATA16_0_FUSEDATA16_WOFFSET                    0x0
#define FUSE_FUSEDATA16_0_FUSEDATA16_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA16_0_FUSEDATA16_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA16_0_FUSEDATA16_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA16_0_FUSEDATA16_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA16_0_FUSEDATA_PRIVATE_KEY2__RED_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA16_0_FUSEDATA_PRIVATE_KEY2__RED_ALIAS_0_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA16_0_FUSEDATA_PRIVATE_KEY2__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA16_0_FUSEDATA_PRIVATE_KEY2__RED_ALIAS_0_RANGE                      31:0
#define FUSE_FUSEDATA16_0_FUSEDATA_PRIVATE_KEY2__RED_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA16_0_FUSEDATA_PRIVATE_KEY2__RED_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA16_0_FUSEDATA_PRIVATE_KEY2__RED_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA16_0_FUSEDATA_PRIVATE_KEY2__RED_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA16_0_FUSEDATA_PRIVATE_KEY2__RED_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA17_0  
#define FUSE_FUSEDATA17_0                       _MK_ADDR_CONST(0x50)
#define FUSE_FUSEDATA17_0_WORD_COUNT                    0x1
#define FUSE_FUSEDATA17_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA17_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA17_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA17_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA17_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA17_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA17_0_FUSEDATA17_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA17_0_FUSEDATA17_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA17_0_FUSEDATA17_SHIFT)
#define FUSE_FUSEDATA17_0_FUSEDATA17_RANGE                      31:0
#define FUSE_FUSEDATA17_0_FUSEDATA17_WOFFSET                    0x0
#define FUSE_FUSEDATA17_0_FUSEDATA17_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA17_0_FUSEDATA17_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA17_0_FUSEDATA17_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA17_0_FUSEDATA17_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA17_0_FUSEDATA_PRIVATE_KEY3__RED_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA17_0_FUSEDATA_PRIVATE_KEY3__RED_ALIAS_0_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA17_0_FUSEDATA_PRIVATE_KEY3__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA17_0_FUSEDATA_PRIVATE_KEY3__RED_ALIAS_0_RANGE                      31:0
#define FUSE_FUSEDATA17_0_FUSEDATA_PRIVATE_KEY3__RED_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA17_0_FUSEDATA_PRIVATE_KEY3__RED_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA17_0_FUSEDATA_PRIVATE_KEY3__RED_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA17_0_FUSEDATA_PRIVATE_KEY3__RED_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA17_0_FUSEDATA_PRIVATE_KEY3__RED_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA18_0  
#define FUSE_FUSEDATA18_0                       _MK_ADDR_CONST(0x54)
#define FUSE_FUSEDATA18_0_WORD_COUNT                    0x1
#define FUSE_FUSEDATA18_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA18_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA18_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA18_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA18_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA18_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA18_0_FUSEDATA18_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA18_0_FUSEDATA18_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA18_0_FUSEDATA18_SHIFT)
#define FUSE_FUSEDATA18_0_FUSEDATA18_RANGE                      31:0
#define FUSE_FUSEDATA18_0_FUSEDATA18_WOFFSET                    0x0
#define FUSE_FUSEDATA18_0_FUSEDATA18_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA18_0_FUSEDATA18_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA18_0_FUSEDATA18_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA18_0_FUSEDATA18_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA18_0_FUSEDATA_PRIVATE_KEY4__RED_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA18_0_FUSEDATA_PRIVATE_KEY4__RED_ALIAS_0_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA18_0_FUSEDATA_PRIVATE_KEY4__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA18_0_FUSEDATA_PRIVATE_KEY4__RED_ALIAS_0_RANGE                      31:0
#define FUSE_FUSEDATA18_0_FUSEDATA_PRIVATE_KEY4__RED_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA18_0_FUSEDATA_PRIVATE_KEY4__RED_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA18_0_FUSEDATA_PRIVATE_KEY4__RED_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA18_0_FUSEDATA_PRIVATE_KEY4__RED_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA18_0_FUSEDATA_PRIVATE_KEY4__RED_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA19_0  
#define FUSE_FUSEDATA19_0                       _MK_ADDR_CONST(0x58)
#define FUSE_FUSEDATA19_0_WORD_COUNT                    0x1
#define FUSE_FUSEDATA19_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA19_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA19_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA19_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA19_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA19_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA19_0_FUSEDATA19_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA19_0_FUSEDATA19_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA19_0_FUSEDATA19_SHIFT)
#define FUSE_FUSEDATA19_0_FUSEDATA19_RANGE                      31:0
#define FUSE_FUSEDATA19_0_FUSEDATA19_WOFFSET                    0x0
#define FUSE_FUSEDATA19_0_FUSEDATA19_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA19_0_FUSEDATA19_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA19_0_FUSEDATA19_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA19_0_FUSEDATA19_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA19_0_FUSEDATA_ARM_JTAG_DIS__RED_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA19_0_FUSEDATA_ARM_JTAG_DIS__RED_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA19_0_FUSEDATA_ARM_JTAG_DIS__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA19_0_FUSEDATA_ARM_JTAG_DIS__RED_ALIAS_0_RANGE                      0:0
#define FUSE_FUSEDATA19_0_FUSEDATA_ARM_JTAG_DIS__RED_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA19_0_FUSEDATA_ARM_JTAG_DIS__RED_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA19_0_FUSEDATA_ARM_JTAG_DIS__RED_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA19_0_FUSEDATA_ARM_JTAG_DIS__RED_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA19_0_FUSEDATA_ARM_JTAG_DIS__RED_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA19_0_FUSEDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(1)
#define FUSE_FUSEDATA19_0_FUSEDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x7f) << FUSE_FUSEDATA19_0_FUSEDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA19_0_FUSEDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_RANGE                  7:1
#define FUSE_FUSEDATA19_0_FUSEDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEDATA19_0_FUSEDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA19_0_FUSEDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x7f)
#define FUSE_FUSEDATA19_0_FUSEDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA19_0_FUSEDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA19_0_FUSEDATA_RESERVED_SW__RED_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(8)
#define FUSE_FUSEDATA19_0_FUSEDATA_RESERVED_SW__RED_ALIAS_0_FIELD                       (_MK_MASK_CONST(0xff) << FUSE_FUSEDATA19_0_FUSEDATA_RESERVED_SW__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA19_0_FUSEDATA_RESERVED_SW__RED_ALIAS_0_RANGE                       15:8
#define FUSE_FUSEDATA19_0_FUSEDATA_RESERVED_SW__RED_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA19_0_FUSEDATA_RESERVED_SW__RED_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA19_0_FUSEDATA_RESERVED_SW__RED_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define FUSE_FUSEDATA19_0_FUSEDATA_RESERVED_SW__RED_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA19_0_FUSEDATA_RESERVED_SW__RED_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA19_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(16)
#define FUSE_FUSEDATA19_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0xffff) << FUSE_FUSEDATA19_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA19_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_0_RANGE                   31:16
#define FUSE_FUSEDATA19_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEDATA19_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA19_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0xffff)
#define FUSE_FUSEDATA19_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA19_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA20_0  
#define FUSE_FUSEDATA20_0                       _MK_ADDR_CONST(0x5c)
#define FUSE_FUSEDATA20_0_WORD_COUNT                    0x1
#define FUSE_FUSEDATA20_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA20_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA20_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA20_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA20_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA20_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA20_0_FUSEDATA20_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA20_0_FUSEDATA20_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA20_0_FUSEDATA20_SHIFT)
#define FUSE_FUSEDATA20_0_FUSEDATA20_RANGE                      31:0
#define FUSE_FUSEDATA20_0_FUSEDATA20_WOFFSET                    0x0
#define FUSE_FUSEDATA20_0_FUSEDATA20_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA20_0_FUSEDATA20_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA20_0_FUSEDATA20_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA20_0_FUSEDATA20_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_1_SHIFT                   _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_1_FIELD                   (_MK_MASK_CONST(0xffff) << FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_1_RANGE                   15:0
#define FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_1_WOFFSET                 0x0
#define FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_1_DEFAULT_MASK                    _MK_MASK_CONST(0xffff)
#define FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_0__PRI_ALIAS_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(16)
#define FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0xffff) << FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_0_RANGE                   31:16
#define FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0xffff)
#define FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA20_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FUSE_FUSEDATA21_0  
#define FUSE_FUSEDATA21_0                       _MK_ADDR_CONST(0x60)
#define FUSE_FUSEDATA21_0_WORD_COUNT                    0x1
#define FUSE_FUSEDATA21_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA21_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA21_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA21_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA21_0_FUSEDATA21_FIELD                      (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEDATA21_0_FUSEDATA21_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA21_RANGE                      31:0
#define FUSE_FUSEDATA21_0_FUSEDATA21_WOFFSET                    0x0
#define FUSE_FUSEDATA21_0_FUSEDATA21_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA21_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEDATA21_0_FUSEDATA21_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA21_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_1_SHIFT                   _MK_SHIFT_CONST(0)
#define FUSE_FUSEDATA21_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_1_FIELD                   (_MK_MASK_CONST(0xffff) << FUSE_FUSEDATA21_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_1_RANGE                   15:0
#define FUSE_FUSEDATA21_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_1_WOFFSET                 0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_1_DEFAULT_MASK                    _MK_MASK_CONST(0xffff)
#define FUSE_FUSEDATA21_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_JTAG_SECUREID_1__PRI_ALIAS_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_0__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(16)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_0__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_0__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_0__PRI_ALIAS_0_RANGE                       16:16
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_0__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_0__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_0__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_0__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_0__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_1__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(17)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_1__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_1__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_1__PRI_ALIAS_0_RANGE                       17:17
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_1__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_1__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_1__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_1__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_1__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_2__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(18)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_2__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_2__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_2__PRI_ALIAS_0_RANGE                       18:18
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_2__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_2__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_2__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_2__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_2__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_3__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(19)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_3__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_3__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_3__PRI_ALIAS_0_RANGE                       19:19
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_3__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_3__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_3__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_3__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_3__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_4__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(20)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_4__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_4__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_4__PRI_ALIAS_0_RANGE                       20:20
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_4__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_4__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_4__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_4__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_4__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_5__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(21)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_5__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_5__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_5__PRI_ALIAS_0_RANGE                       21:21
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_5__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_5__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_5__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_5__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_5__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_6__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(22)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_6__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_6__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_6__PRI_ALIAS_0_RANGE                       22:22
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_6__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_6__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_6__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_6__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_6__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_7__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(23)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_7__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_7__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_7__PRI_ALIAS_0_RANGE                       23:23
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_7__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_7__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_7__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_7__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_7__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_8__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(24)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_8__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_8__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_8__PRI_ALIAS_0_RANGE                       24:24
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_8__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_8__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_8__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_8__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_8__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_9__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(25)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_9__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_9__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_9__PRI_ALIAS_0_RANGE                       25:25
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_9__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_9__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_9__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_9__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_9__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_10__PRI_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(26)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_10__PRI_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_10__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_10__PRI_ALIAS_0_RANGE                      26:26
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_10__PRI_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_10__PRI_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_10__PRI_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_10__PRI_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_10__PRI_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_11__PRI_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(27)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_11__PRI_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_11__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_11__PRI_ALIAS_0_RANGE                      27:27
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_11__PRI_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_11__PRI_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_11__PRI_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_11__PRI_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_11__PRI_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_12__PRI_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(28)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_12__PRI_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_12__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_12__PRI_ALIAS_0_RANGE                      28:28
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_12__PRI_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_12__PRI_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_12__PRI_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_12__PRI_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_12__PRI_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_13__PRI_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(29)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_13__PRI_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_13__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_13__PRI_ALIAS_0_RANGE                      29:29
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_13__PRI_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_13__PRI_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_13__PRI_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_13__PRI_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_13__PRI_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_14__PRI_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(30)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_14__PRI_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_14__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_14__PRI_ALIAS_0_RANGE                      30:30
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_14__PRI_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_14__PRI_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_14__PRI_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_14__PRI_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_14__PRI_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_15__PRI_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(31)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_15__PRI_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x1) << FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_15__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_15__PRI_ALIAS_0_RANGE                      31:31
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_15__PRI_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_15__PRI_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_15__PRI_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_15__PRI_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEDATA21_0_FUSEDATA_SPARE_BIT_15__PRI_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA0_0  
#define FUSE_FUSEWRDATA0_0                      _MK_ADDR_CONST(0x64)
#define FUSE_FUSEWRDATA0_0_WORD_COUNT                   0x1
#define FUSE_FUSEWRDATA0_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA0_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_READ_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA0_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA0_FIELD                    (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA0_0_FUSEWRDATA0_SHIFT)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA0_RANGE                    31:0
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA0_WOFFSET                  0x0
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA0_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_ENABLE__PRI_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_ENABLE__PRI_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_ENABLE__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_ENABLE__PRI_ALIAS_0_RANGE                  0:0
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_ENABLE__PRI_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_ENABLE__PRI_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_ENABLE__PRI_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_ENABLE__PRI_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_ENABLE__PRI_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_DISABLE__PRI_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(1)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_DISABLE__PRI_ALIAS_0_FIELD                 (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_DISABLE__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_DISABLE__PRI_ALIAS_0_RANGE                 1:1
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_DISABLE__PRI_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_DISABLE__PRI_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_DISABLE__PRI_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_DISABLE__PRI_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_MASTER_DISABLE__PRI_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_BYPASS__PRI_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(2)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_BYPASS__PRI_ALIAS_0_FIELD                 (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA0_0_FUSEWRDATA_BYPASS__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_BYPASS__PRI_ALIAS_0_RANGE                 2:2
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_BYPASS__PRI_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_BYPASS__PRI_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_BYPASS__PRI_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_BYPASS__PRI_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_BYPASS__PRI_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_RESERVE_BIT__PRI_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(3)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_RESERVE_BIT__PRI_ALIAS_0_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA0_0_FUSEWRDATA_RESERVE_BIT__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_RESERVE_BIT__PRI_ALIAS_0_RANGE                    3:3
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_RESERVE_BIT__PRI_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_RESERVE_BIT__PRI_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_RESERVE_BIT__PRI_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_RESERVE_BIT__PRI_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_RESERVE_BIT__PRI_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_PRODUCTION_MODE__PRI_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(4)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_PRODUCTION_MODE__PRI_ALIAS_0_FIELD                        (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA0_0_FUSEWRDATA_PRODUCTION_MODE__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_PRODUCTION_MODE__PRI_ALIAS_0_RANGE                        4:4
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_PRODUCTION_MODE__PRI_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_PRODUCTION_MODE__PRI_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_PRODUCTION_MODE__PRI_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_PRODUCTION_MODE__PRI_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_PRODUCTION_MODE__PRI_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(5)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA0_0_FUSEWRDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_RANGE                    5:5
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_JTAG_SECUREID_VALID__PRI_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_SKU_INFO__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(6)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_SKU_INFO__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0xff) << FUSE_FUSEWRDATA0_0_FUSEWRDATA_SKU_INFO__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_SKU_INFO__PRI_ALIAS_0_RANGE                       13:6
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_SKU_INFO__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_SKU_INFO__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_SKU_INFO__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_SKU_INFO__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_SKU_INFO__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_PROCESS_CALIB__PRI_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(14)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_PROCESS_CALIB__PRI_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x3) << FUSE_FUSEWRDATA0_0_FUSEWRDATA_PROCESS_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_PROCESS_CALIB__PRI_ALIAS_0_RANGE                  15:14
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_PROCESS_CALIB__PRI_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_PROCESS_CALIB__PRI_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_PROCESS_CALIB__PRI_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_PROCESS_CALIB__PRI_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_PROCESS_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_IO_CALIB__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(16)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_IO_CALIB__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x3ff) << FUSE_FUSEWRDATA0_0_FUSEWRDATA_IO_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_IO_CALIB__PRI_ALIAS_0_RANGE                       25:16
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_IO_CALIB__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_IO_CALIB__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_IO_CALIB__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x3ff)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_IO_CALIB__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_IO_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(26)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x3f) << FUSE_FUSEWRDATA0_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_0_RANGE                  31:26
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA0_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA1_0  
#define FUSE_FUSEWRDATA1_0                      _MK_ADDR_CONST(0x68)
#define FUSE_FUSEWRDATA1_0_WORD_COUNT                   0x1
#define FUSE_FUSEWRDATA1_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA1_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA1_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA1_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA1_0_READ_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA1_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA1_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA1_FIELD                    (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA1_0_FUSEWRDATA1_SHIFT)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA1_RANGE                    31:0
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA1_WOFFSET                  0x0
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA1_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_1_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_1_FIELD                  (_MK_MASK_CONST(0x3) << FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_1_RANGE                  1:0
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_1_WOFFSET                        0x0
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_1_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_CRT_CALIB__PRI_ALIAS_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(2)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_FIELD                 (_MK_MASK_CONST(0xff) << FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_RANGE                 9:2
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_HDTV_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(10)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_FIELD                 (_MK_MASK_CONST(0xff) << FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_RANGE                 17:10
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_DAC_SDTV_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_0__PRI_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(18)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_0__PRI_ALIAS_0_FIELD                 (_MK_MASK_CONST(0x7f) << FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_0__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_0__PRI_ALIAS_0_RANGE                 24:18
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_0__PRI_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_0__PRI_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_0__PRI_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0x7f)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_0__PRI_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_0__PRI_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_1__PRI_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(25)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_1__PRI_ALIAS_0_FIELD                 (_MK_MASK_CONST(0x7f) << FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_1__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_1__PRI_ALIAS_0_RANGE                 31:25
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_1__PRI_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_1__PRI_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_1__PRI_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0x7f)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_1__PRI_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA1_0_FUSEWRDATA_CMC_DATARAM0_1__PRI_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA2_0  
#define FUSE_FUSEWRDATA2_0                      _MK_ADDR_CONST(0x6c)
#define FUSE_FUSEWRDATA2_0_WORD_COUNT                   0x1
#define FUSE_FUSEWRDATA2_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA2_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA2_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA2_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA2_0_READ_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA2_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA2_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA2_FIELD                    (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA2_0_FUSEWRDATA2_SHIFT)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA2_RANGE                    31:0
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA2_WOFFSET                  0x0
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA2_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA2_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_2__PRI_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_2__PRI_ALIAS_0_FIELD                 (_MK_MASK_CONST(0x7f) << FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_2__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_2__PRI_ALIAS_0_RANGE                 6:0
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_2__PRI_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_2__PRI_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_2__PRI_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0x7f)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_2__PRI_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_2__PRI_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_3__PRI_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(7)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_3__PRI_ALIAS_0_FIELD                 (_MK_MASK_CONST(0x7f) << FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_3__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_3__PRI_ALIAS_0_RANGE                 13:7
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_3__PRI_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_3__PRI_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_3__PRI_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0x7f)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_3__PRI_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM0_3__PRI_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_0__PRI_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(14)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_0__PRI_ALIAS_0_FIELD                 (_MK_MASK_CONST(0x7f) << FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_0__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_0__PRI_ALIAS_0_RANGE                 20:14
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_0__PRI_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_0__PRI_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_0__PRI_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0x7f)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_0__PRI_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_0__PRI_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_1__PRI_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(21)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_1__PRI_ALIAS_0_FIELD                 (_MK_MASK_CONST(0x7f) << FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_1__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_1__PRI_ALIAS_0_RANGE                 27:21
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_1__PRI_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_1__PRI_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_1__PRI_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0x7f)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_1__PRI_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_1__PRI_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(28)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_0_FIELD                 (_MK_MASK_CONST(0xf) << FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_0_RANGE                 31:28
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA2_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA3_0  
#define FUSE_FUSEWRDATA3_0                      _MK_ADDR_CONST(0x70)
#define FUSE_FUSEWRDATA3_0_WORD_COUNT                   0x1
#define FUSE_FUSEWRDATA3_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA3_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_READ_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA3_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA3_FIELD                    (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA3_0_FUSEWRDATA3_SHIFT)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA3_RANGE                    31:0
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA3_WOFFSET                  0x0
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA3_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA3_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA3_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA3_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_1_SHIFT                 _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_1_FIELD                 (_MK_MASK_CONST(0x7) << FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_1_RANGE                 2:0
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_1_WOFFSET                       0x0
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_1_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_1_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_2__PRI_ALIAS_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_3__PRI_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(3)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_3__PRI_ALIAS_0_FIELD                 (_MK_MASK_CONST(0x7f) << FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_3__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_3__PRI_ALIAS_0_RANGE                 9:3
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_3__PRI_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_3__PRI_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_3__PRI_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0x7f)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_3__PRI_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_CMC_DATARAM1_3__PRI_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_FA__PRI_ALIAS_0_SHIFT                     _MK_SHIFT_CONST(10)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_FA__PRI_ALIAS_0_FIELD                     (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA3_0_FUSEWRDATA_FA__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_FA__PRI_ALIAS_0_RANGE                     10:10
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_FA__PRI_ALIAS_0_WOFFSET                   0x0
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_FA__PRI_ALIAS_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_FA__PRI_ALIAS_0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_FA__PRI_ALIAS_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_FA__PRI_ALIAS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(11)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_FIELD                    (_MK_MASK_CONST(0xf) << FUSE_FUSEWRDATA3_0_FUSEWRDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_RANGE                    14:11
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_RESERVED_PRODUCTION__PRI_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(15)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x3f) << FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_RANGE                       20:15
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x3f)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE0_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(21)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x3f) << FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_RANGE                       26:21
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x3f)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE1_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(27)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x1f) << FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_RANGE                       31:27
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA3_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA4_0  
#define FUSE_FUSEWRDATA4_0                      _MK_ADDR_CONST(0x74)
#define FUSE_FUSEWRDATA4_0_WORD_COUNT                   0x1
#define FUSE_FUSEWRDATA4_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA4_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA4_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA4_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA4_0_READ_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA4_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA4_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA4_FIELD                    (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA4_0_FUSEWRDATA4_SHIFT)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA4_RANGE                    31:0
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA4_WOFFSET                  0x0
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA4_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA4_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA4_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA4_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_SHIFT                       _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_FIELD                       (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_RANGE                       0:0
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_WOFFSET                     0x0
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE2_CALIB__PRI_ALIAS_1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(1)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x3f) << FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_RANGE                       6:1
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x3f)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_HDMI_LANE3_CALIB__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_SECURITY_MODE__PRI_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(7)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_SECURITY_MODE__PRI_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA4_0_FUSEWRDATA_SECURITY_MODE__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_SECURITY_MODE__PRI_ALIAS_0_RANGE                  7:7
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_SECURITY_MODE__PRI_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_SECURITY_MODE__PRI_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_SECURITY_MODE__PRI_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_SECURITY_MODE__PRI_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_SECURITY_MODE__PRI_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(8)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0xffffff) << FUSE_FUSEWRDATA4_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_0_RANGE                   31:8
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0xffffff)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA4_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA5_0  
#define FUSE_FUSEWRDATA5_0                      _MK_ADDR_CONST(0x78)
#define FUSE_FUSEWRDATA5_0_WORD_COUNT                   0x1
#define FUSE_FUSEWRDATA5_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA5_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA5_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA5_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA5_0_READ_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA5_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA5_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA5_FIELD                    (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA5_0_FUSEWRDATA5_SHIFT)
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA5_RANGE                    31:0
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA5_WOFFSET                  0x0
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA5_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA5_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA5_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA5_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_1_SHIFT                   _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_1_FIELD                   (_MK_MASK_CONST(0xff) << FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_1_RANGE                   7:0
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_1_WOFFSET                 0x0
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_1_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY0__PRI_ALIAS_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(8)
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0xffffff) << FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_0_RANGE                   31:8
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0xffffff)
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA5_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA6_0  
#define FUSE_FUSEWRDATA6_0                      _MK_ADDR_CONST(0x7c)
#define FUSE_FUSEWRDATA6_0_WORD_COUNT                   0x1
#define FUSE_FUSEWRDATA6_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA6_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA6_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA6_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA6_0_READ_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA6_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA6_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA6_FIELD                    (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA6_0_FUSEWRDATA6_SHIFT)
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA6_RANGE                    31:0
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA6_WOFFSET                  0x0
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA6_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA6_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA6_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA6_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_1_SHIFT                   _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_1_FIELD                   (_MK_MASK_CONST(0xff) << FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_1_RANGE                   7:0
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_1_WOFFSET                 0x0
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_1_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY1__PRI_ALIAS_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(8)
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0xffffff) << FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_0_RANGE                   31:8
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0xffffff)
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA6_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA7_0  
#define FUSE_FUSEWRDATA7_0                      _MK_ADDR_CONST(0x80)
#define FUSE_FUSEWRDATA7_0_WORD_COUNT                   0x1
#define FUSE_FUSEWRDATA7_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA7_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA7_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA7_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA7_0_READ_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA7_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA7_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA7_FIELD                    (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA7_0_FUSEWRDATA7_SHIFT)
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA7_RANGE                    31:0
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA7_WOFFSET                  0x0
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA7_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA7_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA7_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA7_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_1_SHIFT                   _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_1_FIELD                   (_MK_MASK_CONST(0xff) << FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_1_RANGE                   7:0
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_1_WOFFSET                 0x0
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_1_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY2__PRI_ALIAS_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(8)
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0xffffff) << FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_0_RANGE                   31:8
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0xffffff)
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA7_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA8_0  
#define FUSE_FUSEWRDATA8_0                      _MK_ADDR_CONST(0x84)
#define FUSE_FUSEWRDATA8_0_WORD_COUNT                   0x1
#define FUSE_FUSEWRDATA8_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA8_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA8_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA8_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA8_0_READ_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA8_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA8_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA8_FIELD                    (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA8_0_FUSEWRDATA8_SHIFT)
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA8_RANGE                    31:0
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA8_WOFFSET                  0x0
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA8_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA8_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA8_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA8_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_1_SHIFT                   _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_1_FIELD                   (_MK_MASK_CONST(0xff) << FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_1_RANGE                   7:0
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_1_WOFFSET                 0x0
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_1_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY3__PRI_ALIAS_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(8)
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0xffffff) << FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_0_RANGE                   31:8
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0xffffff)
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA8_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA9_0  
#define FUSE_FUSEWRDATA9_0                      _MK_ADDR_CONST(0x88)
#define FUSE_FUSEWRDATA9_0_WORD_COUNT                   0x1
#define FUSE_FUSEWRDATA9_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA9_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_READ_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA9_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA9_FIELD                    (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA9_0_FUSEWRDATA9_SHIFT)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA9_RANGE                    31:0
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA9_WOFFSET                  0x0
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA9_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA9_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA9_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA9_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_ENABLE__RED_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(24)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_ENABLE__RED_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_ENABLE__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_ENABLE__RED_ALIAS_0_RANGE                  24:24
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_ENABLE__RED_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_ENABLE__RED_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_ENABLE__RED_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_ENABLE__RED_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_ENABLE__RED_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_DISABLE__RED_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(25)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_DISABLE__RED_ALIAS_0_FIELD                 (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_DISABLE__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_DISABLE__RED_ALIAS_0_RANGE                 25:25
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_DISABLE__RED_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_DISABLE__RED_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_DISABLE__RED_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_DISABLE__RED_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_MASTER_DISABLE__RED_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_BYPASS__RED_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(26)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_BYPASS__RED_ALIAS_0_FIELD                 (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA9_0_FUSEWRDATA_BYPASS__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_BYPASS__RED_ALIAS_0_RANGE                 26:26
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_BYPASS__RED_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_BYPASS__RED_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_BYPASS__RED_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_BYPASS__RED_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_BYPASS__RED_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVE_BIT__RED_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(27)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVE_BIT__RED_ALIAS_0_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVE_BIT__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVE_BIT__RED_ALIAS_0_RANGE                    27:27
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVE_BIT__RED_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVE_BIT__RED_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVE_BIT__RED_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVE_BIT__RED_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVE_BIT__RED_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRODUCTION_MODE__RED_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(28)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRODUCTION_MODE__RED_ALIAS_0_FIELD                        (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRODUCTION_MODE__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRODUCTION_MODE__RED_ALIAS_0_RANGE                        28:28
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRODUCTION_MODE__RED_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRODUCTION_MODE__RED_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRODUCTION_MODE__RED_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRODUCTION_MODE__RED_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRODUCTION_MODE__RED_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(29)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA9_0_FUSEWRDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_RANGE                    29:29
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_JTAG_SECUREID_VALID__RED_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(30)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x3) << FUSE_FUSEWRDATA9_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_0_RANGE                       31:30
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_1_SHIFT                   _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_1_FIELD                   (_MK_MASK_CONST(0xff) << FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_1_RANGE                   7:0
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_1_WOFFSET                 0x0
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_1_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_PRIVATE_KEY4__PRI_ALIAS_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_ARM_JTAG_DIS__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(8)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_ARM_JTAG_DIS__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA9_0_FUSEWRDATA_ARM_JTAG_DIS__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_ARM_JTAG_DIS__PRI_ALIAS_0_RANGE                   8:8
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_ARM_JTAG_DIS__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_ARM_JTAG_DIS__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_ARM_JTAG_DIS__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_ARM_JTAG_DIS__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_ARM_JTAG_DIS__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(9)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0x7f) << FUSE_FUSEWRDATA9_0_FUSEWRDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_RANGE                       15:9
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0x7f)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_BOOT_DEVICE_INFO__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVED_SW__PRI_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(16)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVED_SW__PRI_ALIAS_0_FIELD                    (_MK_MASK_CONST(0xff) << FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVED_SW__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVED_SW__PRI_ALIAS_0_RANGE                    23:16
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVED_SW__PRI_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVED_SW__PRI_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVED_SW__PRI_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVED_SW__PRI_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA9_0_FUSEWRDATA_RESERVED_SW__PRI_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA10_0  
#define FUSE_FUSEWRDATA10_0                     _MK_ADDR_CONST(0x8c)
#define FUSE_FUSEWRDATA10_0_WORD_COUNT                  0x1
#define FUSE_FUSEWRDATA10_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA10_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA10_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA10_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA10_0_READ_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA10_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA10_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA10_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA10_0_FUSEWRDATA10_SHIFT)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA10_RANGE                  31:0
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA10_WOFFSET                        0x0
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA10_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA10_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA10_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA10_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_1_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_1_FIELD                      (_MK_MASK_CONST(0x3f) << FUSE_FUSEWRDATA10_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_1_SHIFT)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_1_RANGE                      5:0
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_1_WOFFSET                    0x0
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_1_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_1_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_SKU_INFO__RED_ALIAS_1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_PROCESS_CALIB__RED_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(6)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_PROCESS_CALIB__RED_ALIAS_0_FIELD                 (_MK_MASK_CONST(0x3) << FUSE_FUSEWRDATA10_0_FUSEWRDATA_PROCESS_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_PROCESS_CALIB__RED_ALIAS_0_RANGE                 7:6
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_PROCESS_CALIB__RED_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_PROCESS_CALIB__RED_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_PROCESS_CALIB__RED_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_PROCESS_CALIB__RED_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_PROCESS_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_IO_CALIB__RED_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(8)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_IO_CALIB__RED_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x3ff) << FUSE_FUSEWRDATA10_0_FUSEWRDATA_IO_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_IO_CALIB__RED_ALIAS_0_RANGE                      17:8
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_IO_CALIB__RED_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_IO_CALIB__RED_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_IO_CALIB__RED_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x3ff)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_IO_CALIB__RED_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_IO_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_CRT_CALIB__RED_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(18)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_CRT_CALIB__RED_ALIAS_0_FIELD                 (_MK_MASK_CONST(0xff) << FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_CRT_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_CRT_CALIB__RED_ALIAS_0_RANGE                 25:18
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_CRT_CALIB__RED_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_CRT_CALIB__RED_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_CRT_CALIB__RED_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_CRT_CALIB__RED_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_CRT_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(26)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_0_FIELD                        (_MK_MASK_CONST(0x3f) << FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_0_RANGE                        31:26
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0x3f)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA10_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA11_0  
#define FUSE_FUSEWRDATA11_0                     _MK_ADDR_CONST(0x90)
#define FUSE_FUSEWRDATA11_0_WORD_COUNT                  0x1
#define FUSE_FUSEWRDATA11_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA11_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_READ_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA11_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA11_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA11_0_FUSEWRDATA11_SHIFT)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA11_RANGE                  31:0
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA11_WOFFSET                        0x0
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA11_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA11_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA11_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA11_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_1_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_1_FIELD                        (_MK_MASK_CONST(0x3) << FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_1_SHIFT)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_1_RANGE                        1:0
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_1_WOFFSET                      0x0
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_1_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_1_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_HDTV_CALIB__RED_ALIAS_1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_SDTV_CALIB__RED_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(2)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_SDTV_CALIB__RED_ALIAS_0_FIELD                        (_MK_MASK_CONST(0xff) << FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_SDTV_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_SDTV_CALIB__RED_ALIAS_0_RANGE                        9:2
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_SDTV_CALIB__RED_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_SDTV_CALIB__RED_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_SDTV_CALIB__RED_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_SDTV_CALIB__RED_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_DAC_SDTV_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_0__RED_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(10)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_0__RED_ALIAS_0_FIELD                        (_MK_MASK_CONST(0x7f) << FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_0__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_0__RED_ALIAS_0_RANGE                        16:10
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_0__RED_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_0__RED_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_0__RED_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0x7f)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_0__RED_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_0__RED_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_1__RED_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(17)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_1__RED_ALIAS_0_FIELD                        (_MK_MASK_CONST(0x7f) << FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_1__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_1__RED_ALIAS_0_RANGE                        23:17
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_1__RED_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_1__RED_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_1__RED_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0x7f)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_1__RED_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_1__RED_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_2__RED_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(24)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_2__RED_ALIAS_0_FIELD                        (_MK_MASK_CONST(0x7f) << FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_2__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_2__RED_ALIAS_0_RANGE                        30:24
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_2__RED_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_2__RED_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_2__RED_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0x7f)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_2__RED_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_2__RED_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(31)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_0_FIELD                        (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_0_RANGE                        31:31
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA11_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA12_0  
#define FUSE_FUSEWRDATA12_0                     _MK_ADDR_CONST(0x94)
#define FUSE_FUSEWRDATA12_0_WORD_COUNT                  0x1
#define FUSE_FUSEWRDATA12_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA12_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA12_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA12_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA12_0_READ_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA12_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA12_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA12_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA12_0_FUSEWRDATA12_SHIFT)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA12_RANGE                  31:0
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA12_WOFFSET                        0x0
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA12_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA12_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA12_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA12_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_1_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_1_FIELD                        (_MK_MASK_CONST(0x3f) << FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_1_SHIFT)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_1_RANGE                        5:0
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_1_WOFFSET                      0x0
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_1_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_1_DEFAULT_MASK                 _MK_MASK_CONST(0x3f)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM0_3__RED_ALIAS_1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_0__RED_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(6)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_0__RED_ALIAS_0_FIELD                        (_MK_MASK_CONST(0x7f) << FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_0__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_0__RED_ALIAS_0_RANGE                        12:6
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_0__RED_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_0__RED_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_0__RED_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0x7f)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_0__RED_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_0__RED_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_1__RED_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(13)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_1__RED_ALIAS_0_FIELD                        (_MK_MASK_CONST(0x7f) << FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_1__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_1__RED_ALIAS_0_RANGE                        19:13
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_1__RED_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_1__RED_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_1__RED_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0x7f)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_1__RED_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_1__RED_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_2__RED_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(20)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_2__RED_ALIAS_0_FIELD                        (_MK_MASK_CONST(0x7f) << FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_2__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_2__RED_ALIAS_0_RANGE                        26:20
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_2__RED_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_2__RED_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_2__RED_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0x7f)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_2__RED_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_2__RED_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_0_SHIFT                        _MK_SHIFT_CONST(27)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_0_FIELD                        (_MK_MASK_CONST(0x1f) << FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_0_RANGE                        31:27
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_0_WOFFSET                      0x0
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_0_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA12_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA13_0  
#define FUSE_FUSEWRDATA13_0                     _MK_ADDR_CONST(0x98)
#define FUSE_FUSEWRDATA13_0_WORD_COUNT                  0x1
#define FUSE_FUSEWRDATA13_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA13_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_READ_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA13_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA13_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA13_0_FUSEWRDATA13_SHIFT)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA13_RANGE                  31:0
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA13_WOFFSET                        0x0
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA13_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA13_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA13_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA13_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_1_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_1_FIELD                        (_MK_MASK_CONST(0x3) << FUSE_FUSEWRDATA13_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_1_SHIFT)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_1_RANGE                        1:0
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_1_WOFFSET                      0x0
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_1_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_1_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_CMC_DATARAM1_3__RED_ALIAS_1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_FA__RED_ALIAS_0_SHIFT                    _MK_SHIFT_CONST(2)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_FA__RED_ALIAS_0_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA13_0_FUSEWRDATA_FA__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_FA__RED_ALIAS_0_RANGE                    2:2
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_FA__RED_ALIAS_0_WOFFSET                  0x0
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_FA__RED_ALIAS_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_FA__RED_ALIAS_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_FA__RED_ALIAS_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_FA__RED_ALIAS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_RESERVED_PRODUCTION__RED_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(3)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_RESERVED_PRODUCTION__RED_ALIAS_0_FIELD                   (_MK_MASK_CONST(0xf) << FUSE_FUSEWRDATA13_0_FUSEWRDATA_RESERVED_PRODUCTION__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_RESERVED_PRODUCTION__RED_ALIAS_0_RANGE                   6:3
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_RESERVED_PRODUCTION__RED_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_RESERVED_PRODUCTION__RED_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_RESERVED_PRODUCTION__RED_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_RESERVED_PRODUCTION__RED_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_RESERVED_PRODUCTION__RED_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(7)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x3f) << FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_RANGE                      12:7
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE0_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(13)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x3f) << FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_RANGE                      18:13
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE1_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(19)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x3f) << FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_RANGE                      24:19
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE2_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(25)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x3f) << FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_RANGE                      30:25
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_HDMI_LANE3_CALIB__RED_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_SECURITY_MODE__RED_ALIAS_0_SHIFT                 _MK_SHIFT_CONST(31)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_SECURITY_MODE__RED_ALIAS_0_FIELD                 (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA13_0_FUSEWRDATA_SECURITY_MODE__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_SECURITY_MODE__RED_ALIAS_0_RANGE                 31:31
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_SECURITY_MODE__RED_ALIAS_0_WOFFSET                       0x0
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_SECURITY_MODE__RED_ALIAS_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_SECURITY_MODE__RED_ALIAS_0_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_SECURITY_MODE__RED_ALIAS_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA13_0_FUSEWRDATA_SECURITY_MODE__RED_ALIAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA14_0  
#define FUSE_FUSEWRDATA14_0                     _MK_ADDR_CONST(0x9c)
#define FUSE_FUSEWRDATA14_0_WORD_COUNT                  0x1
#define FUSE_FUSEWRDATA14_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA14_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA14_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA14_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA14_0_READ_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA14_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA14_0_FUSEWRDATA14_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA14_0_FUSEWRDATA14_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA14_0_FUSEWRDATA14_SHIFT)
#define FUSE_FUSEWRDATA14_0_FUSEWRDATA14_RANGE                  31:0
#define FUSE_FUSEWRDATA14_0_FUSEWRDATA14_WOFFSET                        0x0
#define FUSE_FUSEWRDATA14_0_FUSEWRDATA14_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA14_0_FUSEWRDATA14_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA14_0_FUSEWRDATA14_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA14_0_FUSEWRDATA14_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA14_0_FUSEWRDATA_PRIVATE_KEY0__RED_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA14_0_FUSEWRDATA_PRIVATE_KEY0__RED_ALIAS_0_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA14_0_FUSEWRDATA_PRIVATE_KEY0__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA14_0_FUSEWRDATA_PRIVATE_KEY0__RED_ALIAS_0_RANGE                  31:0
#define FUSE_FUSEWRDATA14_0_FUSEWRDATA_PRIVATE_KEY0__RED_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA14_0_FUSEWRDATA_PRIVATE_KEY0__RED_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA14_0_FUSEWRDATA_PRIVATE_KEY0__RED_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA14_0_FUSEWRDATA_PRIVATE_KEY0__RED_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA14_0_FUSEWRDATA_PRIVATE_KEY0__RED_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA15_0  
#define FUSE_FUSEWRDATA15_0                     _MK_ADDR_CONST(0xa0)
#define FUSE_FUSEWRDATA15_0_WORD_COUNT                  0x1
#define FUSE_FUSEWRDATA15_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA15_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA15_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA15_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA15_0_READ_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA15_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA15_0_FUSEWRDATA15_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA15_0_FUSEWRDATA15_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA15_0_FUSEWRDATA15_SHIFT)
#define FUSE_FUSEWRDATA15_0_FUSEWRDATA15_RANGE                  31:0
#define FUSE_FUSEWRDATA15_0_FUSEWRDATA15_WOFFSET                        0x0
#define FUSE_FUSEWRDATA15_0_FUSEWRDATA15_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA15_0_FUSEWRDATA15_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA15_0_FUSEWRDATA15_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA15_0_FUSEWRDATA15_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA15_0_FUSEWRDATA_PRIVATE_KEY1__RED_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA15_0_FUSEWRDATA_PRIVATE_KEY1__RED_ALIAS_0_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA15_0_FUSEWRDATA_PRIVATE_KEY1__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA15_0_FUSEWRDATA_PRIVATE_KEY1__RED_ALIAS_0_RANGE                  31:0
#define FUSE_FUSEWRDATA15_0_FUSEWRDATA_PRIVATE_KEY1__RED_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA15_0_FUSEWRDATA_PRIVATE_KEY1__RED_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA15_0_FUSEWRDATA_PRIVATE_KEY1__RED_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA15_0_FUSEWRDATA_PRIVATE_KEY1__RED_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA15_0_FUSEWRDATA_PRIVATE_KEY1__RED_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA16_0  
#define FUSE_FUSEWRDATA16_0                     _MK_ADDR_CONST(0xa4)
#define FUSE_FUSEWRDATA16_0_WORD_COUNT                  0x1
#define FUSE_FUSEWRDATA16_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA16_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA16_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA16_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA16_0_READ_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA16_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA16_0_FUSEWRDATA16_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA16_0_FUSEWRDATA16_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA16_0_FUSEWRDATA16_SHIFT)
#define FUSE_FUSEWRDATA16_0_FUSEWRDATA16_RANGE                  31:0
#define FUSE_FUSEWRDATA16_0_FUSEWRDATA16_WOFFSET                        0x0
#define FUSE_FUSEWRDATA16_0_FUSEWRDATA16_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA16_0_FUSEWRDATA16_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA16_0_FUSEWRDATA16_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA16_0_FUSEWRDATA16_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA16_0_FUSEWRDATA_PRIVATE_KEY2__RED_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA16_0_FUSEWRDATA_PRIVATE_KEY2__RED_ALIAS_0_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA16_0_FUSEWRDATA_PRIVATE_KEY2__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA16_0_FUSEWRDATA_PRIVATE_KEY2__RED_ALIAS_0_RANGE                  31:0
#define FUSE_FUSEWRDATA16_0_FUSEWRDATA_PRIVATE_KEY2__RED_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA16_0_FUSEWRDATA_PRIVATE_KEY2__RED_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA16_0_FUSEWRDATA_PRIVATE_KEY2__RED_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA16_0_FUSEWRDATA_PRIVATE_KEY2__RED_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA16_0_FUSEWRDATA_PRIVATE_KEY2__RED_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA17_0  
#define FUSE_FUSEWRDATA17_0                     _MK_ADDR_CONST(0xa8)
#define FUSE_FUSEWRDATA17_0_WORD_COUNT                  0x1
#define FUSE_FUSEWRDATA17_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA17_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA17_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA17_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA17_0_READ_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA17_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA17_0_FUSEWRDATA17_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA17_0_FUSEWRDATA17_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA17_0_FUSEWRDATA17_SHIFT)
#define FUSE_FUSEWRDATA17_0_FUSEWRDATA17_RANGE                  31:0
#define FUSE_FUSEWRDATA17_0_FUSEWRDATA17_WOFFSET                        0x0
#define FUSE_FUSEWRDATA17_0_FUSEWRDATA17_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA17_0_FUSEWRDATA17_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA17_0_FUSEWRDATA17_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA17_0_FUSEWRDATA17_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA17_0_FUSEWRDATA_PRIVATE_KEY3__RED_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA17_0_FUSEWRDATA_PRIVATE_KEY3__RED_ALIAS_0_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA17_0_FUSEWRDATA_PRIVATE_KEY3__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA17_0_FUSEWRDATA_PRIVATE_KEY3__RED_ALIAS_0_RANGE                  31:0
#define FUSE_FUSEWRDATA17_0_FUSEWRDATA_PRIVATE_KEY3__RED_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA17_0_FUSEWRDATA_PRIVATE_KEY3__RED_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA17_0_FUSEWRDATA_PRIVATE_KEY3__RED_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA17_0_FUSEWRDATA_PRIVATE_KEY3__RED_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA17_0_FUSEWRDATA_PRIVATE_KEY3__RED_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA18_0  
#define FUSE_FUSEWRDATA18_0                     _MK_ADDR_CONST(0xac)
#define FUSE_FUSEWRDATA18_0_WORD_COUNT                  0x1
#define FUSE_FUSEWRDATA18_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA18_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA18_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA18_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA18_0_READ_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA18_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA18_0_FUSEWRDATA18_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA18_0_FUSEWRDATA18_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA18_0_FUSEWRDATA18_SHIFT)
#define FUSE_FUSEWRDATA18_0_FUSEWRDATA18_RANGE                  31:0
#define FUSE_FUSEWRDATA18_0_FUSEWRDATA18_WOFFSET                        0x0
#define FUSE_FUSEWRDATA18_0_FUSEWRDATA18_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA18_0_FUSEWRDATA18_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA18_0_FUSEWRDATA18_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA18_0_FUSEWRDATA18_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA18_0_FUSEWRDATA_PRIVATE_KEY4__RED_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA18_0_FUSEWRDATA_PRIVATE_KEY4__RED_ALIAS_0_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA18_0_FUSEWRDATA_PRIVATE_KEY4__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA18_0_FUSEWRDATA_PRIVATE_KEY4__RED_ALIAS_0_RANGE                  31:0
#define FUSE_FUSEWRDATA18_0_FUSEWRDATA_PRIVATE_KEY4__RED_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA18_0_FUSEWRDATA_PRIVATE_KEY4__RED_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA18_0_FUSEWRDATA_PRIVATE_KEY4__RED_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA18_0_FUSEWRDATA_PRIVATE_KEY4__RED_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA18_0_FUSEWRDATA_PRIVATE_KEY4__RED_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA19_0  
#define FUSE_FUSEWRDATA19_0                     _MK_ADDR_CONST(0xb0)
#define FUSE_FUSEWRDATA19_0_WORD_COUNT                  0x1
#define FUSE_FUSEWRDATA19_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA19_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA19_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA19_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA19_0_READ_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA19_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA19_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA19_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA19_0_FUSEWRDATA19_SHIFT)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA19_RANGE                  31:0
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA19_WOFFSET                        0x0
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA19_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA19_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA19_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA19_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_ARM_JTAG_DIS__RED_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_ARM_JTAG_DIS__RED_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA19_0_FUSEWRDATA_ARM_JTAG_DIS__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_ARM_JTAG_DIS__RED_ALIAS_0_RANGE                  0:0
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_ARM_JTAG_DIS__RED_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_ARM_JTAG_DIS__RED_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_ARM_JTAG_DIS__RED_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_ARM_JTAG_DIS__RED_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_ARM_JTAG_DIS__RED_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_SHIFT                      _MK_SHIFT_CONST(1)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_FIELD                      (_MK_MASK_CONST(0x7f) << FUSE_FUSEWRDATA19_0_FUSEWRDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_RANGE                      7:1
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_WOFFSET                    0x0
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_DEFAULT_MASK                       _MK_MASK_CONST(0x7f)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_BOOT_DEVICE_INFO__RED_ALIAS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_RESERVED_SW__RED_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(8)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_RESERVED_SW__RED_ALIAS_0_FIELD                   (_MK_MASK_CONST(0xff) << FUSE_FUSEWRDATA19_0_FUSEWRDATA_RESERVED_SW__RED_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_RESERVED_SW__RED_ALIAS_0_RANGE                   15:8
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_RESERVED_SW__RED_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_RESERVED_SW__RED_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_RESERVED_SW__RED_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_RESERVED_SW__RED_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_RESERVED_SW__RED_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(16)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0xffff) << FUSE_FUSEWRDATA19_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_0_RANGE                       31:16
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0xffff)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA19_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA20_0  
#define FUSE_FUSEWRDATA20_0                     _MK_ADDR_CONST(0xb4)
#define FUSE_FUSEWRDATA20_0_WORD_COUNT                  0x1
#define FUSE_FUSEWRDATA20_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA20_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA20_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA20_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA20_0_READ_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA20_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA20_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA20_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA20_0_FUSEWRDATA20_SHIFT)
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA20_RANGE                  31:0
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA20_WOFFSET                        0x0
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA20_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA20_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA20_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA20_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_1_SHIFT                       _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_1_FIELD                       (_MK_MASK_CONST(0xffff) << FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_1_RANGE                       15:0
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_1_WOFFSET                     0x0
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_1_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_1_DEFAULT_MASK                        _MK_MASK_CONST(0xffff)
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_0__PRI_ALIAS_1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_0_SHIFT                       _MK_SHIFT_CONST(16)
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_0_FIELD                       (_MK_MASK_CONST(0xffff) << FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_0_RANGE                       31:16
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_0_WOFFSET                     0x0
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_0_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_0_DEFAULT_MASK                        _MK_MASK_CONST(0xffff)
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA20_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FUSE_FUSEWRDATA21_0  
#define FUSE_FUSEWRDATA21_0                     _MK_ADDR_CONST(0xb8)
#define FUSE_FUSEWRDATA21_0_WORD_COUNT                  0x1
#define FUSE_FUSEWRDATA21_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA21_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_READ_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA21_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA21_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_FUSEWRDATA21_0_FUSEWRDATA21_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA21_RANGE                  31:0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA21_WOFFSET                        0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA21_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA21_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA21_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA21_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_1_SHIFT                       _MK_SHIFT_CONST(0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_1_FIELD                       (_MK_MASK_CONST(0xffff) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_1_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_1_RANGE                       15:0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_1_WOFFSET                     0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_1_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_1_DEFAULT_MASK                        _MK_MASK_CONST(0xffff)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_JTAG_SECUREID_1__PRI_ALIAS_1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_0__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(16)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_0__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_0__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_0__PRI_ALIAS_0_RANGE                   16:16
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_0__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_0__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_0__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_0__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_0__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_1__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(17)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_1__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_1__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_1__PRI_ALIAS_0_RANGE                   17:17
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_1__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_1__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_1__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_1__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_1__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_2__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(18)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_2__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_2__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_2__PRI_ALIAS_0_RANGE                   18:18
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_2__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_2__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_2__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_2__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_2__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_3__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(19)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_3__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_3__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_3__PRI_ALIAS_0_RANGE                   19:19
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_3__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_3__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_3__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_3__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_3__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_4__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(20)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_4__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_4__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_4__PRI_ALIAS_0_RANGE                   20:20
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_4__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_4__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_4__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_4__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_4__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_5__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(21)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_5__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_5__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_5__PRI_ALIAS_0_RANGE                   21:21
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_5__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_5__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_5__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_5__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_5__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_6__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(22)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_6__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_6__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_6__PRI_ALIAS_0_RANGE                   22:22
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_6__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_6__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_6__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_6__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_6__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_7__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(23)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_7__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_7__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_7__PRI_ALIAS_0_RANGE                   23:23
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_7__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_7__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_7__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_7__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_7__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_8__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(24)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_8__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_8__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_8__PRI_ALIAS_0_RANGE                   24:24
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_8__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_8__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_8__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_8__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_8__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_9__PRI_ALIAS_0_SHIFT                   _MK_SHIFT_CONST(25)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_9__PRI_ALIAS_0_FIELD                   (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_9__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_9__PRI_ALIAS_0_RANGE                   25:25
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_9__PRI_ALIAS_0_WOFFSET                 0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_9__PRI_ALIAS_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_9__PRI_ALIAS_0_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_9__PRI_ALIAS_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_9__PRI_ALIAS_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_10__PRI_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(26)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_10__PRI_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_10__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_10__PRI_ALIAS_0_RANGE                  26:26
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_10__PRI_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_10__PRI_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_10__PRI_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_10__PRI_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_10__PRI_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_11__PRI_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(27)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_11__PRI_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_11__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_11__PRI_ALIAS_0_RANGE                  27:27
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_11__PRI_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_11__PRI_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_11__PRI_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_11__PRI_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_11__PRI_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_12__PRI_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(28)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_12__PRI_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_12__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_12__PRI_ALIAS_0_RANGE                  28:28
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_12__PRI_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_12__PRI_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_12__PRI_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_12__PRI_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_12__PRI_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_13__PRI_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(29)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_13__PRI_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_13__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_13__PRI_ALIAS_0_RANGE                  29:29
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_13__PRI_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_13__PRI_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_13__PRI_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_13__PRI_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_13__PRI_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_14__PRI_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(30)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_14__PRI_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_14__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_14__PRI_ALIAS_0_RANGE                  30:30
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_14__PRI_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_14__PRI_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_14__PRI_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_14__PRI_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_14__PRI_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_15__PRI_ALIAS_0_SHIFT                  _MK_SHIFT_CONST(31)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_15__PRI_ALIAS_0_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_15__PRI_ALIAS_0_SHIFT)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_15__PRI_ALIAS_0_RANGE                  31:31
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_15__PRI_ALIAS_0_WOFFSET                        0x0
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_15__PRI_ALIAS_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_15__PRI_ALIAS_0_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_15__PRI_ALIAS_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEWRDATA21_0_FUSEWRDATA_SPARE_BIT_15__PRI_ALIAS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 188 [0xbc] 

// Reserved address 192 [0xc0] 

// Reserved address 196 [0xc4] 

// Reserved address 200 [0xc8] 

// Reserved address 204 [0xcc] 

// Reserved address 208 [0xd0] 

// Reserved address 212 [0xd4] 

// Reserved address 216 [0xd8] 

// Reserved address 220 [0xdc] 

// Register FUSE_FUSEBYPASS_0  
#define FUSE_FUSEBYPASS_0                       _MK_ADDR_CONST(0xe0)
#define FUSE_FUSEBYPASS_0_WORD_COUNT                    0x1
#define FUSE_FUSEBYPASS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEBYPASS_0_RESET_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FUSEBYPASS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEBYPASS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_FUSEBYPASS_0_READ_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_FUSEBYPASS_0_WRITE_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_SHIFT)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_RANGE                  0:0
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_WOFFSET                        0x0
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_INIT_ENUM                      DISABLED
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_DISABLED                       _MK_ENUM_CONST(0)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_ENABLED                        _MK_ENUM_CONST(1)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_DISABLE                        _MK_ENUM_CONST(0)
#define FUSE_FUSEBYPASS_0_FUSEBYPASS_VAL_ENABLE                 _MK_ENUM_CONST(1)


// Register FUSE_PRIVATEKEYDISABLE_0  
#define FUSE_PRIVATEKEYDISABLE_0                        _MK_ADDR_CONST(0xe4)
#define FUSE_PRIVATEKEYDISABLE_0_WORD_COUNT                     0x1
#define FUSE_PRIVATEKEYDISABLE_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATEKEYDISABLE_0_RESET_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_PRIVATEKEYDISABLE_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_PRIVATEKEYDISABLE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATEKEYDISABLE_0_READ_MASK                      _MK_MASK_CONST(0x1)
#define FUSE_PRIVATEKEYDISABLE_0_WRITE_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_SHIFT)
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_RANGE                    0:0
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_WOFFSET                  0x0
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_INIT_ENUM                        KEY_VISIBLE
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_KEY_VISIBLE                      _MK_ENUM_CONST(0)
#define FUSE_PRIVATEKEYDISABLE_0_PRIVATEKEYDISABLE_VAL_KEY_INVISIBLE                    _MK_ENUM_CONST(1)


// Reserved address 232 [0xe8] 

// Reserved address 236 [0xec] 

// Reserved address 240 [0xf0] 

// Reserved address 244 [0xf4] 

// Reserved address 248 [0xf8] 

// Reserved address 252 [0xfc] 

// Register FUSE_PRODUCTION_MODE_0  
#define FUSE_PRODUCTION_MODE_0                  _MK_ADDR_CONST(0x100)
#define FUSE_PRODUCTION_MODE_0_WORD_COUNT                       0x1
#define FUSE_PRODUCTION_MODE_0_RESET_VAL                        _MK_MASK_CONST(0x1)
#define FUSE_PRODUCTION_MODE_0_RESET_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_PRODUCTION_MODE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRODUCTION_MODE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRODUCTION_MODE_0_READ_MASK                        _MK_MASK_CONST(0x1)
#define FUSE_PRODUCTION_MODE_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_SHIFT)
#define FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_RANGE                    0:0
#define FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_WOFFSET                  0x0
#define FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_DEFAULT                  _MK_MASK_CONST(0x1)
#define FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_PRODUCTION_MODE_0_PRODUCTION_MODE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_JTAG_SECUREID_VALID_0  
#define FUSE_JTAG_SECUREID_VALID_0                      _MK_ADDR_CONST(0x104)
#define FUSE_JTAG_SECUREID_VALID_0_WORD_COUNT                   0x1
#define FUSE_JTAG_SECUREID_VALID_0_RESET_VAL                    _MK_MASK_CONST(0x1)
#define FUSE_JTAG_SECUREID_VALID_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_JTAG_SECUREID_VALID_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_VALID_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_VALID_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_JTAG_SECUREID_VALID_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_SHIFT)
#define FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_RANGE                    0:0
#define FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_WOFFSET                  0x0
#define FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_DEFAULT                  _MK_MASK_CONST(0x1)
#define FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_VALID_0_JTAG_SECUREID_VALID_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_JTAG_SECUREID_0_0  
#define FUSE_JTAG_SECUREID_0_0                  _MK_ADDR_CONST(0x108)
#define FUSE_JTAG_SECUREID_0_0_WORD_COUNT                       0x1
#define FUSE_JTAG_SECUREID_0_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_0_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_JTAG_SECUREID_0_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_0_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_0_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define FUSE_JTAG_SECUREID_0_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_FIELD                    (_MK_MASK_CONST(0xffffffff) << FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_SHIFT)
#define FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_RANGE                    31:0
#define FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_WOFFSET                  0x0
#define FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_0_0_JTAG_SECUREID_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_JTAG_SECUREID_1_0  
#define FUSE_JTAG_SECUREID_1_0                  _MK_ADDR_CONST(0x10c)
#define FUSE_JTAG_SECUREID_1_0_WORD_COUNT                       0x1
#define FUSE_JTAG_SECUREID_1_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_1_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define FUSE_JTAG_SECUREID_1_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_1_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_1_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define FUSE_JTAG_SECUREID_1_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_FIELD                    (_MK_MASK_CONST(0xffffffff) << FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_SHIFT)
#define FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_RANGE                    31:0
#define FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_WOFFSET                  0x0
#define FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_JTAG_SECUREID_1_0_JTAG_SECUREID_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SKU_INFO_0  
#define FUSE_SKU_INFO_0                 _MK_ADDR_CONST(0x110)
#define FUSE_SKU_INFO_0_WORD_COUNT                      0x1
#define FUSE_SKU_INFO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SKU_INFO_0_RESET_MASK                      _MK_MASK_CONST(0xff)
#define FUSE_SKU_INFO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_SKU_INFO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_SKU_INFO_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define FUSE_SKU_INFO_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SKU_INFO_0_SKU_INFO_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SKU_INFO_0_SKU_INFO_FIELD                  (_MK_MASK_CONST(0xff) << FUSE_SKU_INFO_0_SKU_INFO_SHIFT)
#define FUSE_SKU_INFO_0_SKU_INFO_RANGE                  7:0
#define FUSE_SKU_INFO_0_SKU_INFO_WOFFSET                        0x0
#define FUSE_SKU_INFO_0_SKU_INFO_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SKU_INFO_0_SKU_INFO_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define FUSE_SKU_INFO_0_SKU_INFO_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SKU_INFO_0_SKU_INFO_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_PROCESS_CALIB_0  
#define FUSE_PROCESS_CALIB_0                    _MK_ADDR_CONST(0x114)
#define FUSE_PROCESS_CALIB_0_WORD_COUNT                         0x1
#define FUSE_PROCESS_CALIB_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_PROCESS_CALIB_0_RESET_MASK                         _MK_MASK_CONST(0x3)
#define FUSE_PROCESS_CALIB_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_PROCESS_CALIB_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_PROCESS_CALIB_0_READ_MASK                  _MK_MASK_CONST(0x3)
#define FUSE_PROCESS_CALIB_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_PROCESS_CALIB_0_PROCESS_CALIB_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_PROCESS_CALIB_0_PROCESS_CALIB_FIELD                        (_MK_MASK_CONST(0x3) << FUSE_PROCESS_CALIB_0_PROCESS_CALIB_SHIFT)
#define FUSE_PROCESS_CALIB_0_PROCESS_CALIB_RANGE                        1:0
#define FUSE_PROCESS_CALIB_0_PROCESS_CALIB_WOFFSET                      0x0
#define FUSE_PROCESS_CALIB_0_PROCESS_CALIB_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_PROCESS_CALIB_0_PROCESS_CALIB_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define FUSE_PROCESS_CALIB_0_PROCESS_CALIB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_PROCESS_CALIB_0_PROCESS_CALIB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_IO_CALIB_0  
#define FUSE_IO_CALIB_0                 _MK_ADDR_CONST(0x118)
#define FUSE_IO_CALIB_0_WORD_COUNT                      0x1
#define FUSE_IO_CALIB_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_IO_CALIB_0_RESET_MASK                      _MK_MASK_CONST(0x3ff)
#define FUSE_IO_CALIB_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_IO_CALIB_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_IO_CALIB_0_READ_MASK                       _MK_MASK_CONST(0x3ff)
#define FUSE_IO_CALIB_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_IO_CALIB_0_IO_CALIB_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_IO_CALIB_0_IO_CALIB_FIELD                  (_MK_MASK_CONST(0x3ff) << FUSE_IO_CALIB_0_IO_CALIB_SHIFT)
#define FUSE_IO_CALIB_0_IO_CALIB_RANGE                  9:0
#define FUSE_IO_CALIB_0_IO_CALIB_WOFFSET                        0x0
#define FUSE_IO_CALIB_0_IO_CALIB_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_IO_CALIB_0_IO_CALIB_DEFAULT_MASK                   _MK_MASK_CONST(0x3ff)
#define FUSE_IO_CALIB_0_IO_CALIB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_IO_CALIB_0_IO_CALIB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_DAC_CRT_CALIB_0  
#define FUSE_DAC_CRT_CALIB_0                    _MK_ADDR_CONST(0x11c)
#define FUSE_DAC_CRT_CALIB_0_WORD_COUNT                         0x1
#define FUSE_DAC_CRT_CALIB_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_DAC_CRT_CALIB_0_RESET_MASK                         _MK_MASK_CONST(0xff)
#define FUSE_DAC_CRT_CALIB_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_DAC_CRT_CALIB_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_DAC_CRT_CALIB_0_READ_MASK                  _MK_MASK_CONST(0xff)
#define FUSE_DAC_CRT_CALIB_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_FIELD                        (_MK_MASK_CONST(0xff) << FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_SHIFT)
#define FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_RANGE                        7:0
#define FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_WOFFSET                      0x0
#define FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_DEFAULT                      _MK_MASK_CONST(0x0)
#define FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_DAC_CRT_CALIB_0_DAC_CRT_CALIB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_DAC_HDTV_CALIB_0  
#define FUSE_DAC_HDTV_CALIB_0                   _MK_ADDR_CONST(0x120)
#define FUSE_DAC_HDTV_CALIB_0_WORD_COUNT                        0x1
#define FUSE_DAC_HDTV_CALIB_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_DAC_HDTV_CALIB_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define FUSE_DAC_HDTV_CALIB_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_DAC_HDTV_CALIB_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_DAC_HDTV_CALIB_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define FUSE_DAC_HDTV_CALIB_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_FIELD                      (_MK_MASK_CONST(0xff) << FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_SHIFT)
#define FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_RANGE                      7:0
#define FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_WOFFSET                    0x0
#define FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_DAC_HDTV_CALIB_0_DAC_HDTV_CALIB_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_DAC_SDTV_CALIB_0  
#define FUSE_DAC_SDTV_CALIB_0                   _MK_ADDR_CONST(0x124)
#define FUSE_DAC_SDTV_CALIB_0_WORD_COUNT                        0x1
#define FUSE_DAC_SDTV_CALIB_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_DAC_SDTV_CALIB_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define FUSE_DAC_SDTV_CALIB_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_DAC_SDTV_CALIB_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_DAC_SDTV_CALIB_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define FUSE_DAC_SDTV_CALIB_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_FIELD                      (_MK_MASK_CONST(0xff) << FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_SHIFT)
#define FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_RANGE                      7:0
#define FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_WOFFSET                    0x0
#define FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_DAC_SDTV_CALIB_0_DAC_SDTV_CALIB_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_CMC_DATARAM0_0_0  
#define FUSE_CMC_DATARAM0_0_0                   _MK_ADDR_CONST(0x128)
#define FUSE_CMC_DATARAM0_0_0_WORD_COUNT                        0x1
#define FUSE_CMC_DATARAM0_0_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_0_0_RESET_MASK                        _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM0_0_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_0_0_READ_MASK                         _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM0_0_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_0_0_CMC_DATARAM0_0_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_CMC_DATARAM0_0_0_CMC_DATARAM0_0_FIELD                      (_MK_MASK_CONST(0x7f) << FUSE_CMC_DATARAM0_0_0_CMC_DATARAM0_0_SHIFT)
#define FUSE_CMC_DATARAM0_0_0_CMC_DATARAM0_0_RANGE                      6:0
#define FUSE_CMC_DATARAM0_0_0_CMC_DATARAM0_0_WOFFSET                    0x0
#define FUSE_CMC_DATARAM0_0_0_CMC_DATARAM0_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_0_0_CMC_DATARAM0_0_DEFAULT_MASK                       _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM0_0_0_CMC_DATARAM0_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_0_0_CMC_DATARAM0_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_CMC_DATARAM0_1_0  
#define FUSE_CMC_DATARAM0_1_0                   _MK_ADDR_CONST(0x12c)
#define FUSE_CMC_DATARAM0_1_0_WORD_COUNT                        0x1
#define FUSE_CMC_DATARAM0_1_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_1_0_RESET_MASK                        _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM0_1_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_1_0_READ_MASK                         _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM0_1_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_1_0_CMC_DATARAM0_1_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_CMC_DATARAM0_1_0_CMC_DATARAM0_1_FIELD                      (_MK_MASK_CONST(0x7f) << FUSE_CMC_DATARAM0_1_0_CMC_DATARAM0_1_SHIFT)
#define FUSE_CMC_DATARAM0_1_0_CMC_DATARAM0_1_RANGE                      6:0
#define FUSE_CMC_DATARAM0_1_0_CMC_DATARAM0_1_WOFFSET                    0x0
#define FUSE_CMC_DATARAM0_1_0_CMC_DATARAM0_1_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_1_0_CMC_DATARAM0_1_DEFAULT_MASK                       _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM0_1_0_CMC_DATARAM0_1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_1_0_CMC_DATARAM0_1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_CMC_DATARAM0_2_0  
#define FUSE_CMC_DATARAM0_2_0                   _MK_ADDR_CONST(0x130)
#define FUSE_CMC_DATARAM0_2_0_WORD_COUNT                        0x1
#define FUSE_CMC_DATARAM0_2_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_2_0_RESET_MASK                        _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM0_2_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_2_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_2_0_READ_MASK                         _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM0_2_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_2_0_CMC_DATARAM0_2_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_CMC_DATARAM0_2_0_CMC_DATARAM0_2_FIELD                      (_MK_MASK_CONST(0x7f) << FUSE_CMC_DATARAM0_2_0_CMC_DATARAM0_2_SHIFT)
#define FUSE_CMC_DATARAM0_2_0_CMC_DATARAM0_2_RANGE                      6:0
#define FUSE_CMC_DATARAM0_2_0_CMC_DATARAM0_2_WOFFSET                    0x0
#define FUSE_CMC_DATARAM0_2_0_CMC_DATARAM0_2_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_2_0_CMC_DATARAM0_2_DEFAULT_MASK                       _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM0_2_0_CMC_DATARAM0_2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_2_0_CMC_DATARAM0_2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_CMC_DATARAM0_3_0  
#define FUSE_CMC_DATARAM0_3_0                   _MK_ADDR_CONST(0x134)
#define FUSE_CMC_DATARAM0_3_0_WORD_COUNT                        0x1
#define FUSE_CMC_DATARAM0_3_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_3_0_RESET_MASK                        _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM0_3_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_3_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_3_0_READ_MASK                         _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM0_3_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_3_0_CMC_DATARAM0_3_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_CMC_DATARAM0_3_0_CMC_DATARAM0_3_FIELD                      (_MK_MASK_CONST(0x7f) << FUSE_CMC_DATARAM0_3_0_CMC_DATARAM0_3_SHIFT)
#define FUSE_CMC_DATARAM0_3_0_CMC_DATARAM0_3_RANGE                      6:0
#define FUSE_CMC_DATARAM0_3_0_CMC_DATARAM0_3_WOFFSET                    0x0
#define FUSE_CMC_DATARAM0_3_0_CMC_DATARAM0_3_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_3_0_CMC_DATARAM0_3_DEFAULT_MASK                       _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM0_3_0_CMC_DATARAM0_3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM0_3_0_CMC_DATARAM0_3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_CMC_DATARAM1_0_0  
#define FUSE_CMC_DATARAM1_0_0                   _MK_ADDR_CONST(0x138)
#define FUSE_CMC_DATARAM1_0_0_WORD_COUNT                        0x1
#define FUSE_CMC_DATARAM1_0_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_0_0_RESET_MASK                        _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM1_0_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_0_0_READ_MASK                         _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM1_0_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_0_0_CMC_DATARAM1_0_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_CMC_DATARAM1_0_0_CMC_DATARAM1_0_FIELD                      (_MK_MASK_CONST(0x7f) << FUSE_CMC_DATARAM1_0_0_CMC_DATARAM1_0_SHIFT)
#define FUSE_CMC_DATARAM1_0_0_CMC_DATARAM1_0_RANGE                      6:0
#define FUSE_CMC_DATARAM1_0_0_CMC_DATARAM1_0_WOFFSET                    0x0
#define FUSE_CMC_DATARAM1_0_0_CMC_DATARAM1_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_0_0_CMC_DATARAM1_0_DEFAULT_MASK                       _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM1_0_0_CMC_DATARAM1_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_0_0_CMC_DATARAM1_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_CMC_DATARAM1_1_0  
#define FUSE_CMC_DATARAM1_1_0                   _MK_ADDR_CONST(0x13c)
#define FUSE_CMC_DATARAM1_1_0_WORD_COUNT                        0x1
#define FUSE_CMC_DATARAM1_1_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_1_0_RESET_MASK                        _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM1_1_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_1_0_READ_MASK                         _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM1_1_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_1_0_CMC_DATARAM1_1_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_CMC_DATARAM1_1_0_CMC_DATARAM1_1_FIELD                      (_MK_MASK_CONST(0x7f) << FUSE_CMC_DATARAM1_1_0_CMC_DATARAM1_1_SHIFT)
#define FUSE_CMC_DATARAM1_1_0_CMC_DATARAM1_1_RANGE                      6:0
#define FUSE_CMC_DATARAM1_1_0_CMC_DATARAM1_1_WOFFSET                    0x0
#define FUSE_CMC_DATARAM1_1_0_CMC_DATARAM1_1_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_1_0_CMC_DATARAM1_1_DEFAULT_MASK                       _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM1_1_0_CMC_DATARAM1_1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_1_0_CMC_DATARAM1_1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_CMC_DATARAM1_2_0  
#define FUSE_CMC_DATARAM1_2_0                   _MK_ADDR_CONST(0x140)
#define FUSE_CMC_DATARAM1_2_0_WORD_COUNT                        0x1
#define FUSE_CMC_DATARAM1_2_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_2_0_RESET_MASK                        _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM1_2_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_2_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_2_0_READ_MASK                         _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM1_2_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_2_0_CMC_DATARAM1_2_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_CMC_DATARAM1_2_0_CMC_DATARAM1_2_FIELD                      (_MK_MASK_CONST(0x7f) << FUSE_CMC_DATARAM1_2_0_CMC_DATARAM1_2_SHIFT)
#define FUSE_CMC_DATARAM1_2_0_CMC_DATARAM1_2_RANGE                      6:0
#define FUSE_CMC_DATARAM1_2_0_CMC_DATARAM1_2_WOFFSET                    0x0
#define FUSE_CMC_DATARAM1_2_0_CMC_DATARAM1_2_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_2_0_CMC_DATARAM1_2_DEFAULT_MASK                       _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM1_2_0_CMC_DATARAM1_2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_2_0_CMC_DATARAM1_2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_CMC_DATARAM1_3_0  
#define FUSE_CMC_DATARAM1_3_0                   _MK_ADDR_CONST(0x144)
#define FUSE_CMC_DATARAM1_3_0_WORD_COUNT                        0x1
#define FUSE_CMC_DATARAM1_3_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_3_0_RESET_MASK                        _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM1_3_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_3_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_3_0_READ_MASK                         _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM1_3_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_3_0_CMC_DATARAM1_3_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_CMC_DATARAM1_3_0_CMC_DATARAM1_3_FIELD                      (_MK_MASK_CONST(0x7f) << FUSE_CMC_DATARAM1_3_0_CMC_DATARAM1_3_SHIFT)
#define FUSE_CMC_DATARAM1_3_0_CMC_DATARAM1_3_RANGE                      6:0
#define FUSE_CMC_DATARAM1_3_0_CMC_DATARAM1_3_WOFFSET                    0x0
#define FUSE_CMC_DATARAM1_3_0_CMC_DATARAM1_3_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_3_0_CMC_DATARAM1_3_DEFAULT_MASK                       _MK_MASK_CONST(0x7f)
#define FUSE_CMC_DATARAM1_3_0_CMC_DATARAM1_3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_CMC_DATARAM1_3_0_CMC_DATARAM1_3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_FA_0  
#define FUSE_FA_0                       _MK_ADDR_CONST(0x148)
#define FUSE_FA_0_WORD_COUNT                    0x1
#define FUSE_FA_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_FA_0_RESET_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_FA_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FUSE_FA_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FUSE_FA_0_READ_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_FA_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_FA_0_FA_SHIFT                      _MK_SHIFT_CONST(0)
#define FUSE_FA_0_FA_FIELD                      (_MK_MASK_CONST(0x1) << FUSE_FA_0_FA_SHIFT)
#define FUSE_FA_0_FA_RANGE                      0:0
#define FUSE_FA_0_FA_WOFFSET                    0x0
#define FUSE_FA_0_FA_DEFAULT                    _MK_MASK_CONST(0x0)
#define FUSE_FA_0_FA_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FUSE_FA_0_FA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FUSE_FA_0_FA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FUSE_RESERVED_PRODUCTION_0  
#define FUSE_RESERVED_PRODUCTION_0                      _MK_ADDR_CONST(0x14c)
#define FUSE_RESERVED_PRODUCTION_0_WORD_COUNT                   0x1
#define FUSE_RESERVED_PRODUCTION_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_PRODUCTION_0_RESET_MASK                   _MK_MASK_CONST(0xf)
#define FUSE_RESERVED_PRODUCTION_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_PRODUCTION_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_PRODUCTION_0_READ_MASK                    _MK_MASK_CONST(0xf)
#define FUSE_RESERVED_PRODUCTION_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_FIELD                    (_MK_MASK_CONST(0xf) << FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_SHIFT)
#define FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_RANGE                    3:0
#define FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_WOFFSET                  0x0
#define FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_PRODUCTION_0_RESERVED_PRODUCTION_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_HDMI_LANE0_CALIB_0  
#define FUSE_HDMI_LANE0_CALIB_0                 _MK_ADDR_CONST(0x150)
#define FUSE_HDMI_LANE0_CALIB_0_WORD_COUNT                      0x1
#define FUSE_HDMI_LANE0_CALIB_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE0_CALIB_0_RESET_MASK                      _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE0_CALIB_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE0_CALIB_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE0_CALIB_0_READ_MASK                       _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE0_CALIB_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_FIELD                  (_MK_MASK_CONST(0x3f) << FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_SHIFT)
#define FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_RANGE                  5:0
#define FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_WOFFSET                        0x0
#define FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE0_CALIB_0_HDMI_LANE0_CALIB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_HDMI_LANE1_CALIB_0  
#define FUSE_HDMI_LANE1_CALIB_0                 _MK_ADDR_CONST(0x154)
#define FUSE_HDMI_LANE1_CALIB_0_WORD_COUNT                      0x1
#define FUSE_HDMI_LANE1_CALIB_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE1_CALIB_0_RESET_MASK                      _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE1_CALIB_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE1_CALIB_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE1_CALIB_0_READ_MASK                       _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE1_CALIB_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_FIELD                  (_MK_MASK_CONST(0x3f) << FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_SHIFT)
#define FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_RANGE                  5:0
#define FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_WOFFSET                        0x0
#define FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE1_CALIB_0_HDMI_LANE1_CALIB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_HDMI_LANE2_CALIB_0  
#define FUSE_HDMI_LANE2_CALIB_0                 _MK_ADDR_CONST(0x158)
#define FUSE_HDMI_LANE2_CALIB_0_WORD_COUNT                      0x1
#define FUSE_HDMI_LANE2_CALIB_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE2_CALIB_0_RESET_MASK                      _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE2_CALIB_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE2_CALIB_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE2_CALIB_0_READ_MASK                       _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE2_CALIB_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_FIELD                  (_MK_MASK_CONST(0x3f) << FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_SHIFT)
#define FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_RANGE                  5:0
#define FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_WOFFSET                        0x0
#define FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE2_CALIB_0_HDMI_LANE2_CALIB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_HDMI_LANE3_CALIB_0  
#define FUSE_HDMI_LANE3_CALIB_0                 _MK_ADDR_CONST(0x15c)
#define FUSE_HDMI_LANE3_CALIB_0_WORD_COUNT                      0x1
#define FUSE_HDMI_LANE3_CALIB_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE3_CALIB_0_RESET_MASK                      _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE3_CALIB_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE3_CALIB_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE3_CALIB_0_READ_MASK                       _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE3_CALIB_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_FIELD                  (_MK_MASK_CONST(0x3f) << FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_SHIFT)
#define FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_RANGE                  5:0
#define FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_WOFFSET                        0x0
#define FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_DEFAULT_MASK                   _MK_MASK_CONST(0x3f)
#define FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_HDMI_LANE3_CALIB_0_HDMI_LANE3_CALIB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 352 [0x160] 

// Reserved address 356 [0x164] 

// Reserved address 360 [0x168] 

// Reserved address 364 [0x16c] 

// Reserved address 368 [0x170] 

// Reserved address 372 [0x174] 

// Reserved address 376 [0x178] 

// Reserved address 380 [0x17c] 

// Reserved address 384 [0x180] 

// Reserved address 388 [0x184] 

// Reserved address 392 [0x188] 

// Reserved address 396 [0x18c] 

// Reserved address 400 [0x190] 

// Reserved address 404 [0x194] 

// Reserved address 408 [0x198] 

// Reserved address 412 [0x19c] 

// Register FUSE_SECURITY_MODE_0  
#define FUSE_SECURITY_MODE_0                    _MK_ADDR_CONST(0x1a0)
#define FUSE_SECURITY_MODE_0_WORD_COUNT                         0x1
#define FUSE_SECURITY_MODE_0_RESET_VAL                  _MK_MASK_CONST(0x1)
#define FUSE_SECURITY_MODE_0_RESET_MASK                         _MK_MASK_CONST(0x1)
#define FUSE_SECURITY_MODE_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FUSE_SECURITY_MODE_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FUSE_SECURITY_MODE_0_READ_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SECURITY_MODE_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_SECURITY_MODE_0_SECURITY_MODE_SHIFT                        _MK_SHIFT_CONST(0)
#define FUSE_SECURITY_MODE_0_SECURITY_MODE_FIELD                        (_MK_MASK_CONST(0x1) << FUSE_SECURITY_MODE_0_SECURITY_MODE_SHIFT)
#define FUSE_SECURITY_MODE_0_SECURITY_MODE_RANGE                        0:0
#define FUSE_SECURITY_MODE_0_SECURITY_MODE_WOFFSET                      0x0
#define FUSE_SECURITY_MODE_0_SECURITY_MODE_DEFAULT                      _MK_MASK_CONST(0x1)
#define FUSE_SECURITY_MODE_0_SECURITY_MODE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FUSE_SECURITY_MODE_0_SECURITY_MODE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FUSE_SECURITY_MODE_0_SECURITY_MODE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FUSE_PRIVATE_KEY0_0  
#define FUSE_PRIVATE_KEY0_0                     _MK_ADDR_CONST(0x1a4)
#define FUSE_PRIVATE_KEY0_0_WORD_COUNT                  0x1
#define FUSE_PRIVATE_KEY0_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY0_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY0_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_SHIFT)
#define FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_RANGE                  31:0
#define FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_WOFFSET                        0x0
#define FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY0_0_PRIVATE_KEY0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_PRIVATE_KEY1_0  
#define FUSE_PRIVATE_KEY1_0                     _MK_ADDR_CONST(0x1a8)
#define FUSE_PRIVATE_KEY1_0_WORD_COUNT                  0x1
#define FUSE_PRIVATE_KEY1_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY1_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_SHIFT)
#define FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_RANGE                  31:0
#define FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_WOFFSET                        0x0
#define FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY1_0_PRIVATE_KEY1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_PRIVATE_KEY2_0  
#define FUSE_PRIVATE_KEY2_0                     _MK_ADDR_CONST(0x1ac)
#define FUSE_PRIVATE_KEY2_0_WORD_COUNT                  0x1
#define FUSE_PRIVATE_KEY2_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY2_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY2_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_SHIFT)
#define FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_RANGE                  31:0
#define FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_WOFFSET                        0x0
#define FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY2_0_PRIVATE_KEY2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_PRIVATE_KEY3_0  
#define FUSE_PRIVATE_KEY3_0                     _MK_ADDR_CONST(0x1b0)
#define FUSE_PRIVATE_KEY3_0_WORD_COUNT                  0x1
#define FUSE_PRIVATE_KEY3_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY3_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY3_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_SHIFT)
#define FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_RANGE                  31:0
#define FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_WOFFSET                        0x0
#define FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY3_0_PRIVATE_KEY3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_PRIVATE_KEY4_0  
#define FUSE_PRIVATE_KEY4_0                     _MK_ADDR_CONST(0x1b4)
#define FUSE_PRIVATE_KEY4_0_WORD_COUNT                  0x1
#define FUSE_PRIVATE_KEY4_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY4_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY4_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_FIELD                  (_MK_MASK_CONST(0xffffffff) << FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_SHIFT)
#define FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_RANGE                  31:0
#define FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_WOFFSET                        0x0
#define FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_PRIVATE_KEY4_0_PRIVATE_KEY4_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_ARM_JTAG_DIS_0  
#define FUSE_ARM_JTAG_DIS_0                     _MK_ADDR_CONST(0x1b8)
#define FUSE_ARM_JTAG_DIS_0_WORD_COUNT                  0x1
#define FUSE_ARM_JTAG_DIS_0_RESET_VAL                   _MK_MASK_CONST(0x1)
#define FUSE_ARM_JTAG_DIS_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_ARM_JTAG_DIS_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_ARM_JTAG_DIS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_ARM_JTAG_DIS_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_ARM_JTAG_DIS_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_ARM_JTAG_DIS_0_ARM_JTAG_DIS_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_ARM_JTAG_DIS_0_ARM_JTAG_DIS_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_ARM_JTAG_DIS_0_ARM_JTAG_DIS_SHIFT)
#define FUSE_ARM_JTAG_DIS_0_ARM_JTAG_DIS_RANGE                  0:0
#define FUSE_ARM_JTAG_DIS_0_ARM_JTAG_DIS_WOFFSET                        0x0
#define FUSE_ARM_JTAG_DIS_0_ARM_JTAG_DIS_DEFAULT                        _MK_MASK_CONST(0x1)
#define FUSE_ARM_JTAG_DIS_0_ARM_JTAG_DIS_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_ARM_JTAG_DIS_0_ARM_JTAG_DIS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_ARM_JTAG_DIS_0_ARM_JTAG_DIS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_BOOT_DEVICE_INFO_0  
#define FUSE_BOOT_DEVICE_INFO_0                 _MK_ADDR_CONST(0x1bc)
#define FUSE_BOOT_DEVICE_INFO_0_WORD_COUNT                      0x1
#define FUSE_BOOT_DEVICE_INFO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_BOOT_DEVICE_INFO_0_RESET_MASK                      _MK_MASK_CONST(0x7f)
#define FUSE_BOOT_DEVICE_INFO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FUSE_BOOT_DEVICE_INFO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FUSE_BOOT_DEVICE_INFO_0_READ_MASK                       _MK_MASK_CONST(0x7f)
#define FUSE_BOOT_DEVICE_INFO_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_FIELD                  (_MK_MASK_CONST(0x7f) << FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_SHIFT)
#define FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_RANGE                  6:0
#define FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_WOFFSET                        0x0
#define FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_DEFAULT_MASK                   _MK_MASK_CONST(0x7f)
#define FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_BOOT_DEVICE_INFO_0_BOOT_DEVICE_INFO_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_RESERVED_SW_0  
#define FUSE_RESERVED_SW_0                      _MK_ADDR_CONST(0x1c0)
#define FUSE_RESERVED_SW_0_WORD_COUNT                   0x1
#define FUSE_RESERVED_SW_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_SW_0_RESET_MASK                   _MK_MASK_CONST(0xff)
#define FUSE_RESERVED_SW_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_SW_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_SW_0_READ_MASK                    _MK_MASK_CONST(0xff)
#define FUSE_RESERVED_SW_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_SW_0_RESERVED_SW_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_RESERVED_SW_0_RESERVED_SW_FIELD                    (_MK_MASK_CONST(0xff) << FUSE_RESERVED_SW_0_RESERVED_SW_SHIFT)
#define FUSE_RESERVED_SW_0_RESERVED_SW_RANGE                    7:0
#define FUSE_RESERVED_SW_0_RESERVED_SW_WOFFSET                  0x0
#define FUSE_RESERVED_SW_0_RESERVED_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_SW_0_RESERVED_SW_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define FUSE_RESERVED_SW_0_RESERVED_SW_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_RESERVED_SW_0_RESERVED_SW_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_0_0  
#define FUSE_SPARE_BIT_0_0                      _MK_ADDR_CONST(0x1c4)
#define FUSE_SPARE_BIT_0_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_0_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_0_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_0_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_0_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_0_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_0_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_0_0_SPARE_BIT_0_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_0_0_SPARE_BIT_0_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_0_0_SPARE_BIT_0_SHIFT)
#define FUSE_SPARE_BIT_0_0_SPARE_BIT_0_RANGE                    0:0
#define FUSE_SPARE_BIT_0_0_SPARE_BIT_0_WOFFSET                  0x0
#define FUSE_SPARE_BIT_0_0_SPARE_BIT_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_0_0_SPARE_BIT_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_0_0_SPARE_BIT_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_0_0_SPARE_BIT_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_1_0  
#define FUSE_SPARE_BIT_1_0                      _MK_ADDR_CONST(0x1c8)
#define FUSE_SPARE_BIT_1_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_1_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_1_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_1_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_1_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_1_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_1_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_1_0_SPARE_BIT_1_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_1_0_SPARE_BIT_1_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_1_0_SPARE_BIT_1_SHIFT)
#define FUSE_SPARE_BIT_1_0_SPARE_BIT_1_RANGE                    0:0
#define FUSE_SPARE_BIT_1_0_SPARE_BIT_1_WOFFSET                  0x0
#define FUSE_SPARE_BIT_1_0_SPARE_BIT_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_1_0_SPARE_BIT_1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_1_0_SPARE_BIT_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_1_0_SPARE_BIT_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_2_0  
#define FUSE_SPARE_BIT_2_0                      _MK_ADDR_CONST(0x1cc)
#define FUSE_SPARE_BIT_2_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_2_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_2_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_2_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_2_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_2_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_2_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_2_0_SPARE_BIT_2_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_2_0_SPARE_BIT_2_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_2_0_SPARE_BIT_2_SHIFT)
#define FUSE_SPARE_BIT_2_0_SPARE_BIT_2_RANGE                    0:0
#define FUSE_SPARE_BIT_2_0_SPARE_BIT_2_WOFFSET                  0x0
#define FUSE_SPARE_BIT_2_0_SPARE_BIT_2_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_2_0_SPARE_BIT_2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_2_0_SPARE_BIT_2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_2_0_SPARE_BIT_2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_3_0  
#define FUSE_SPARE_BIT_3_0                      _MK_ADDR_CONST(0x1d0)
#define FUSE_SPARE_BIT_3_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_3_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_3_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_3_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_3_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_3_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_3_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_3_0_SPARE_BIT_3_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_3_0_SPARE_BIT_3_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_3_0_SPARE_BIT_3_SHIFT)
#define FUSE_SPARE_BIT_3_0_SPARE_BIT_3_RANGE                    0:0
#define FUSE_SPARE_BIT_3_0_SPARE_BIT_3_WOFFSET                  0x0
#define FUSE_SPARE_BIT_3_0_SPARE_BIT_3_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_3_0_SPARE_BIT_3_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_3_0_SPARE_BIT_3_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_3_0_SPARE_BIT_3_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_4_0  
#define FUSE_SPARE_BIT_4_0                      _MK_ADDR_CONST(0x1d4)
#define FUSE_SPARE_BIT_4_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_4_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_4_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_4_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_4_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_4_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_4_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_4_0_SPARE_BIT_4_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_4_0_SPARE_BIT_4_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_4_0_SPARE_BIT_4_SHIFT)
#define FUSE_SPARE_BIT_4_0_SPARE_BIT_4_RANGE                    0:0
#define FUSE_SPARE_BIT_4_0_SPARE_BIT_4_WOFFSET                  0x0
#define FUSE_SPARE_BIT_4_0_SPARE_BIT_4_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_4_0_SPARE_BIT_4_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_4_0_SPARE_BIT_4_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_4_0_SPARE_BIT_4_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_5_0  
#define FUSE_SPARE_BIT_5_0                      _MK_ADDR_CONST(0x1d8)
#define FUSE_SPARE_BIT_5_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_5_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_5_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_5_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_5_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_5_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_5_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_5_0_SPARE_BIT_5_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_5_0_SPARE_BIT_5_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_5_0_SPARE_BIT_5_SHIFT)
#define FUSE_SPARE_BIT_5_0_SPARE_BIT_5_RANGE                    0:0
#define FUSE_SPARE_BIT_5_0_SPARE_BIT_5_WOFFSET                  0x0
#define FUSE_SPARE_BIT_5_0_SPARE_BIT_5_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_5_0_SPARE_BIT_5_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_5_0_SPARE_BIT_5_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_5_0_SPARE_BIT_5_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_6_0  
#define FUSE_SPARE_BIT_6_0                      _MK_ADDR_CONST(0x1dc)
#define FUSE_SPARE_BIT_6_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_6_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_6_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_6_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_6_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_6_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_6_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_6_0_SPARE_BIT_6_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_6_0_SPARE_BIT_6_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_6_0_SPARE_BIT_6_SHIFT)
#define FUSE_SPARE_BIT_6_0_SPARE_BIT_6_RANGE                    0:0
#define FUSE_SPARE_BIT_6_0_SPARE_BIT_6_WOFFSET                  0x0
#define FUSE_SPARE_BIT_6_0_SPARE_BIT_6_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_6_0_SPARE_BIT_6_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_6_0_SPARE_BIT_6_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_6_0_SPARE_BIT_6_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_7_0  
#define FUSE_SPARE_BIT_7_0                      _MK_ADDR_CONST(0x1e0)
#define FUSE_SPARE_BIT_7_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_7_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_7_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_7_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_7_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_7_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_7_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_7_0_SPARE_BIT_7_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_7_0_SPARE_BIT_7_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_7_0_SPARE_BIT_7_SHIFT)
#define FUSE_SPARE_BIT_7_0_SPARE_BIT_7_RANGE                    0:0
#define FUSE_SPARE_BIT_7_0_SPARE_BIT_7_WOFFSET                  0x0
#define FUSE_SPARE_BIT_7_0_SPARE_BIT_7_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_7_0_SPARE_BIT_7_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_7_0_SPARE_BIT_7_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_7_0_SPARE_BIT_7_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_8_0  
#define FUSE_SPARE_BIT_8_0                      _MK_ADDR_CONST(0x1e4)
#define FUSE_SPARE_BIT_8_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_8_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_8_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_8_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_8_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_8_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_8_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_8_0_SPARE_BIT_8_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_8_0_SPARE_BIT_8_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_8_0_SPARE_BIT_8_SHIFT)
#define FUSE_SPARE_BIT_8_0_SPARE_BIT_8_RANGE                    0:0
#define FUSE_SPARE_BIT_8_0_SPARE_BIT_8_WOFFSET                  0x0
#define FUSE_SPARE_BIT_8_0_SPARE_BIT_8_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_8_0_SPARE_BIT_8_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_8_0_SPARE_BIT_8_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_8_0_SPARE_BIT_8_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_9_0  
#define FUSE_SPARE_BIT_9_0                      _MK_ADDR_CONST(0x1e8)
#define FUSE_SPARE_BIT_9_0_WORD_COUNT                   0x1
#define FUSE_SPARE_BIT_9_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_9_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_9_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_9_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_9_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_9_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_9_0_SPARE_BIT_9_SHIFT                    _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_9_0_SPARE_BIT_9_FIELD                    (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_9_0_SPARE_BIT_9_SHIFT)
#define FUSE_SPARE_BIT_9_0_SPARE_BIT_9_RANGE                    0:0
#define FUSE_SPARE_BIT_9_0_SPARE_BIT_9_WOFFSET                  0x0
#define FUSE_SPARE_BIT_9_0_SPARE_BIT_9_DEFAULT                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_9_0_SPARE_BIT_9_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_9_0_SPARE_BIT_9_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_9_0_SPARE_BIT_9_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_10_0  
#define FUSE_SPARE_BIT_10_0                     _MK_ADDR_CONST(0x1ec)
#define FUSE_SPARE_BIT_10_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_10_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_10_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_10_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_10_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_10_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_10_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_10_0_SPARE_BIT_10_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_10_0_SPARE_BIT_10_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_10_0_SPARE_BIT_10_SHIFT)
#define FUSE_SPARE_BIT_10_0_SPARE_BIT_10_RANGE                  0:0
#define FUSE_SPARE_BIT_10_0_SPARE_BIT_10_WOFFSET                        0x0
#define FUSE_SPARE_BIT_10_0_SPARE_BIT_10_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_10_0_SPARE_BIT_10_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_10_0_SPARE_BIT_10_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_10_0_SPARE_BIT_10_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_11_0  
#define FUSE_SPARE_BIT_11_0                     _MK_ADDR_CONST(0x1f0)
#define FUSE_SPARE_BIT_11_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_11_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_11_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_11_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_11_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_11_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_11_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_11_0_SPARE_BIT_11_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_11_0_SPARE_BIT_11_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_11_0_SPARE_BIT_11_SHIFT)
#define FUSE_SPARE_BIT_11_0_SPARE_BIT_11_RANGE                  0:0
#define FUSE_SPARE_BIT_11_0_SPARE_BIT_11_WOFFSET                        0x0
#define FUSE_SPARE_BIT_11_0_SPARE_BIT_11_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_11_0_SPARE_BIT_11_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_11_0_SPARE_BIT_11_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_11_0_SPARE_BIT_11_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_12_0  
#define FUSE_SPARE_BIT_12_0                     _MK_ADDR_CONST(0x1f4)
#define FUSE_SPARE_BIT_12_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_12_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_12_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_12_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_12_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_12_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_12_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_12_0_SPARE_BIT_12_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_12_0_SPARE_BIT_12_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_12_0_SPARE_BIT_12_SHIFT)
#define FUSE_SPARE_BIT_12_0_SPARE_BIT_12_RANGE                  0:0
#define FUSE_SPARE_BIT_12_0_SPARE_BIT_12_WOFFSET                        0x0
#define FUSE_SPARE_BIT_12_0_SPARE_BIT_12_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_12_0_SPARE_BIT_12_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_12_0_SPARE_BIT_12_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_12_0_SPARE_BIT_12_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_13_0  
#define FUSE_SPARE_BIT_13_0                     _MK_ADDR_CONST(0x1f8)
#define FUSE_SPARE_BIT_13_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_13_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_13_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_13_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_13_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_13_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_13_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_13_0_SPARE_BIT_13_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_13_0_SPARE_BIT_13_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_13_0_SPARE_BIT_13_SHIFT)
#define FUSE_SPARE_BIT_13_0_SPARE_BIT_13_RANGE                  0:0
#define FUSE_SPARE_BIT_13_0_SPARE_BIT_13_WOFFSET                        0x0
#define FUSE_SPARE_BIT_13_0_SPARE_BIT_13_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_13_0_SPARE_BIT_13_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_13_0_SPARE_BIT_13_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_13_0_SPARE_BIT_13_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_14_0  
#define FUSE_SPARE_BIT_14_0                     _MK_ADDR_CONST(0x1fc)
#define FUSE_SPARE_BIT_14_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_14_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_14_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_14_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_14_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_14_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_14_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_14_0_SPARE_BIT_14_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_14_0_SPARE_BIT_14_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_14_0_SPARE_BIT_14_SHIFT)
#define FUSE_SPARE_BIT_14_0_SPARE_BIT_14_RANGE                  0:0
#define FUSE_SPARE_BIT_14_0_SPARE_BIT_14_WOFFSET                        0x0
#define FUSE_SPARE_BIT_14_0_SPARE_BIT_14_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_14_0_SPARE_BIT_14_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_14_0_SPARE_BIT_14_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_14_0_SPARE_BIT_14_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FUSE_SPARE_BIT_15_0  
#define FUSE_SPARE_BIT_15_0                     _MK_ADDR_CONST(0x200)
#define FUSE_SPARE_BIT_15_0_WORD_COUNT                  0x1
#define FUSE_SPARE_BIT_15_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_15_0_RESET_MASK                  _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_15_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_15_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_15_0_READ_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_15_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_15_0_SPARE_BIT_15_SHIFT                  _MK_SHIFT_CONST(0)
#define FUSE_SPARE_BIT_15_0_SPARE_BIT_15_FIELD                  (_MK_MASK_CONST(0x1) << FUSE_SPARE_BIT_15_0_SPARE_BIT_15_SHIFT)
#define FUSE_SPARE_BIT_15_0_SPARE_BIT_15_RANGE                  0:0
#define FUSE_SPARE_BIT_15_0_SPARE_BIT_15_WOFFSET                        0x0
#define FUSE_SPARE_BIT_15_0_SPARE_BIT_15_DEFAULT                        _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_15_0_SPARE_BIT_15_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FUSE_SPARE_BIT_15_0_SPARE_BIT_15_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FUSE_SPARE_BIT_15_0_SPARE_BIT_15_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_ARFUSE_REGS(_op_) \
_op_(FUSE_FUSECTRL_0) \
_op_(FUSE_FUSETIME1_0) \
_op_(FUSE_FUSETIME2_0) \
_op_(FUSE_FUSEDATA0_0) \
_op_(FUSE_FUSEDATA1_0) \
_op_(FUSE_FUSEDATA2_0) \
_op_(FUSE_FUSEDATA3_0) \
_op_(FUSE_FUSEDATA4_0) \
_op_(FUSE_FUSEDATA5_0) \
_op_(FUSE_FUSEDATA6_0) \
_op_(FUSE_FUSEDATA7_0) \
_op_(FUSE_FUSEDATA8_0) \
_op_(FUSE_FUSEDATA9_0) \
_op_(FUSE_FUSEDATA10_0) \
_op_(FUSE_FUSEDATA11_0) \
_op_(FUSE_FUSEDATA12_0) \
_op_(FUSE_FUSEDATA13_0) \
_op_(FUSE_FUSEDATA14_0) \
_op_(FUSE_FUSEDATA15_0) \
_op_(FUSE_FUSEDATA16_0) \
_op_(FUSE_FUSEDATA17_0) \
_op_(FUSE_FUSEDATA18_0) \
_op_(FUSE_FUSEDATA19_0) \
_op_(FUSE_FUSEDATA20_0) \
_op_(FUSE_FUSEDATA21_0) \
_op_(FUSE_FUSEWRDATA0_0) \
_op_(FUSE_FUSEWRDATA1_0) \
_op_(FUSE_FUSEWRDATA2_0) \
_op_(FUSE_FUSEWRDATA3_0) \
_op_(FUSE_FUSEWRDATA4_0) \
_op_(FUSE_FUSEWRDATA5_0) \
_op_(FUSE_FUSEWRDATA6_0) \
_op_(FUSE_FUSEWRDATA7_0) \
_op_(FUSE_FUSEWRDATA8_0) \
_op_(FUSE_FUSEWRDATA9_0) \
_op_(FUSE_FUSEWRDATA10_0) \
_op_(FUSE_FUSEWRDATA11_0) \
_op_(FUSE_FUSEWRDATA12_0) \
_op_(FUSE_FUSEWRDATA13_0) \
_op_(FUSE_FUSEWRDATA14_0) \
_op_(FUSE_FUSEWRDATA15_0) \
_op_(FUSE_FUSEWRDATA16_0) \
_op_(FUSE_FUSEWRDATA17_0) \
_op_(FUSE_FUSEWRDATA18_0) \
_op_(FUSE_FUSEWRDATA19_0) \
_op_(FUSE_FUSEWRDATA20_0) \
_op_(FUSE_FUSEWRDATA21_0) \
_op_(FUSE_FUSEBYPASS_0) \
_op_(FUSE_PRIVATEKEYDISABLE_0) \
_op_(FUSE_PRODUCTION_MODE_0) \
_op_(FUSE_JTAG_SECUREID_VALID_0) \
_op_(FUSE_JTAG_SECUREID_0_0) \
_op_(FUSE_JTAG_SECUREID_1_0) \
_op_(FUSE_SKU_INFO_0) \
_op_(FUSE_PROCESS_CALIB_0) \
_op_(FUSE_IO_CALIB_0) \
_op_(FUSE_DAC_CRT_CALIB_0) \
_op_(FUSE_DAC_HDTV_CALIB_0) \
_op_(FUSE_DAC_SDTV_CALIB_0) \
_op_(FUSE_CMC_DATARAM0_0_0) \
_op_(FUSE_CMC_DATARAM0_1_0) \
_op_(FUSE_CMC_DATARAM0_2_0) \
_op_(FUSE_CMC_DATARAM0_3_0) \
_op_(FUSE_CMC_DATARAM1_0_0) \
_op_(FUSE_CMC_DATARAM1_1_0) \
_op_(FUSE_CMC_DATARAM1_2_0) \
_op_(FUSE_CMC_DATARAM1_3_0) \
_op_(FUSE_FA_0) \
_op_(FUSE_RESERVED_PRODUCTION_0) \
_op_(FUSE_HDMI_LANE0_CALIB_0) \
_op_(FUSE_HDMI_LANE1_CALIB_0) \
_op_(FUSE_HDMI_LANE2_CALIB_0) \
_op_(FUSE_HDMI_LANE3_CALIB_0) \
_op_(FUSE_SECURITY_MODE_0) \
_op_(FUSE_PRIVATE_KEY0_0) \
_op_(FUSE_PRIVATE_KEY1_0) \
_op_(FUSE_PRIVATE_KEY2_0) \
_op_(FUSE_PRIVATE_KEY3_0) \
_op_(FUSE_PRIVATE_KEY4_0) \
_op_(FUSE_ARM_JTAG_DIS_0) \
_op_(FUSE_BOOT_DEVICE_INFO_0) \
_op_(FUSE_RESERVED_SW_0) \
_op_(FUSE_SPARE_BIT_0_0) \
_op_(FUSE_SPARE_BIT_1_0) \
_op_(FUSE_SPARE_BIT_2_0) \
_op_(FUSE_SPARE_BIT_3_0) \
_op_(FUSE_SPARE_BIT_4_0) \
_op_(FUSE_SPARE_BIT_5_0) \
_op_(FUSE_SPARE_BIT_6_0) \
_op_(FUSE_SPARE_BIT_7_0) \
_op_(FUSE_SPARE_BIT_8_0) \
_op_(FUSE_SPARE_BIT_9_0) \
_op_(FUSE_SPARE_BIT_10_0) \
_op_(FUSE_SPARE_BIT_11_0) \
_op_(FUSE_SPARE_BIT_12_0) \
_op_(FUSE_SPARE_BIT_13_0) \
_op_(FUSE_SPARE_BIT_14_0) \
_op_(FUSE_SPARE_BIT_15_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_FUSE       0x00000000

//
// ARFUSE REGISTER BANKS
//

#define FUSE0_FIRST_REG 0x0000 // FUSE_FUSECTRL_0
#define FUSE0_LAST_REG 0x00b8 // FUSE_FUSEWRDATA21_0
#define FUSE1_FIRST_REG 0x00e0 // FUSE_FUSEBYPASS_0
#define FUSE1_LAST_REG 0x00e4 // FUSE_PRIVATEKEYDISABLE_0
#define FUSE2_FIRST_REG 0x0100 // FUSE_PRODUCTION_MODE_0
#define FUSE2_LAST_REG 0x015c // FUSE_HDMI_LANE3_CALIB_0
#define FUSE3_FIRST_REG 0x01a0 // FUSE_SECURITY_MODE_0
#define FUSE3_LAST_REG 0x0200 // FUSE_SPARE_BIT_15_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARFUSE_H_INC_
