/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARSPI_H_INC_
#define ___ARSPI_H_INC_

// Register SPI_COMMAND_0  
#define SPI_COMMAND_0                   _MK_ADDR_CONST(0x0)
#define SPI_COMMAND_0_WORD_COUNT                        0x1
#define SPI_COMMAND_0_RESET_VAL                         _MK_MASK_CONST(0x10000420)
#define SPI_COMMAND_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define SPI_COMMAND_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define SPI_COMMAND_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// Reserved = 0
#define SPI_COMMAND_0_N_A_1_SHIFT                       _MK_SHIFT_CONST(31)
#define SPI_COMMAND_0_N_A_1_FIELD                       (_MK_MASK_CONST(0x1) << SPI_COMMAND_0_N_A_1_SHIFT)
#define SPI_COMMAND_0_N_A_1_RANGE                       31:31
#define SPI_COMMAND_0_N_A_1_WOFFSET                     0x0
#define SPI_COMMAND_0_N_A_1_DEFAULT                     _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_N_A_1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_N_A_1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_N_A_1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Default: 0 Go Mode enable bit. Software sets this bit to 1 to enable transmit or receive of packets without specifying the no. of packets.  In receive mode, the controller receives one packet whenever software sets this bit.  In transmit mode, controller transmits all data present in the TX FIFO until TX FIFO becomes empty. If packed mode is enabled, then all packets in the last word from the TX FIFO are transmitted before finishing the transfer.  Software must set up all fields in SPI_COMMAND and SPI_DMA_CTL registers before setting this bit to 1.  This bit clears to 0 by the hardware on the completion of the transfer.  
#define SPI_COMMAND_0_GO_SHIFT                  _MK_SHIFT_CONST(30)
#define SPI_COMMAND_0_GO_FIELD                  (_MK_MASK_CONST(0x1) << SPI_COMMAND_0_GO_SHIFT)
#define SPI_COMMAND_0_GO_RANGE                  30:30
#define SPI_COMMAND_0_GO_WOFFSET                        0x0
#define SPI_COMMAND_0_GO_DEFAULT                        _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_GO_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_GO_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_GO_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_GO_DISABLE                        _MK_ENUM_CONST(0)
#define SPI_COMMAND_0_GO_ENABLE                 _MK_ENUM_CONST(1)

// Reserved = 0
#define SPI_COMMAND_0_N_A_2_SHIFT                       _MK_SHIFT_CONST(29)
#define SPI_COMMAND_0_N_A_2_FIELD                       (_MK_MASK_CONST(0x1) << SPI_COMMAND_0_N_A_2_SHIFT)
#define SPI_COMMAND_0_N_A_2_RANGE                       29:29
#define SPI_COMMAND_0_N_A_2_WOFFSET                     0x0
#define SPI_COMMAND_0_N_A_2_DEFAULT                     _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_N_A_2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_N_A_2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_N_A_2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Default: 1.  Master/slave mode select. RO 1 = Controller is operating in master mode.  0 = Controller is operating in slave mode. This bit is read-only and fixed to 1. Only master mode is supported in this design.  
#define SPI_COMMAND_0_M_S_SHIFT                 _MK_SHIFT_CONST(28)
#define SPI_COMMAND_0_M_S_FIELD                 (_MK_MASK_CONST(0x1) << SPI_COMMAND_0_M_S_SHIFT)
#define SPI_COMMAND_0_M_S_RANGE                 28:28
#define SPI_COMMAND_0_M_S_WOFFSET                       0x0
#define SPI_COMMAND_0_M_S_DEFAULT                       _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_M_S_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_M_S_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_M_S_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_M_S_SLAVE                 _MK_ENUM_CONST(0)
#define SPI_COMMAND_0_M_S_MASTER                        _MK_ENUM_CONST(1)

// Active clock signal format. Controls the output enable of the SCK line when the controller is actively doing data transfers.  00: Drive low.  01: Drive high.  10: Pull low.  11: Pull high.  Default: 00
#define SPI_COMMAND_0_ACTIVE_SCLK_SHIFT                 _MK_SHIFT_CONST(26)
#define SPI_COMMAND_0_ACTIVE_SCLK_FIELD                 (_MK_MASK_CONST(0x3) << SPI_COMMAND_0_ACTIVE_SCLK_SHIFT)
#define SPI_COMMAND_0_ACTIVE_SCLK_RANGE                 27:26
#define SPI_COMMAND_0_ACTIVE_SCLK_WOFFSET                       0x0
#define SPI_COMMAND_0_ACTIVE_SCLK_DEFAULT                       _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_ACTIVE_SCLK_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define SPI_COMMAND_0_ACTIVE_SCLK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_ACTIVE_SCLK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_ACTIVE_SCLK_DRIVE_LOW                     _MK_ENUM_CONST(0)
#define SPI_COMMAND_0_ACTIVE_SCLK_DRIVE_HIGH                    _MK_ENUM_CONST(1)
#define SPI_COMMAND_0_ACTIVE_SCLK_PULL_LOW                      _MK_ENUM_CONST(2)
#define SPI_COMMAND_0_ACTIVE_SCLK_PULL_HIGH                     _MK_ENUM_CONST(3)

// Reserved = 0
#define SPI_COMMAND_0_N_A_3_SHIFT                       _MK_SHIFT_CONST(22)
#define SPI_COMMAND_0_N_A_3_FIELD                       (_MK_MASK_CONST(0xf) << SPI_COMMAND_0_N_A_3_SHIFT)
#define SPI_COMMAND_0_N_A_3_RANGE                       25:22
#define SPI_COMMAND_0_N_A_3_WOFFSET                     0x0
#define SPI_COMMAND_0_N_A_3_DEFAULT                     _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_N_A_3_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define SPI_COMMAND_0_N_A_3_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_N_A_3_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Clock phase. Controls how the data is transferred with respect to clock edge.  0 = Data is transferred on first clock edge after CS is driven low.  1 = Data is transferred on second clock edge after CS is driven low.
#define SPI_COMMAND_0_CK_SDA_SHIFT                      _MK_SHIFT_CONST(21)
#define SPI_COMMAND_0_CK_SDA_FIELD                      (_MK_MASK_CONST(0x1) << SPI_COMMAND_0_CK_SDA_SHIFT)
#define SPI_COMMAND_0_CK_SDA_RANGE                      21:21
#define SPI_COMMAND_0_CK_SDA_WOFFSET                    0x0
#define SPI_COMMAND_0_CK_SDA_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CK_SDA_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_CK_SDA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CK_SDA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CK_SDA_FIRST_CLK_EDGE                     _MK_ENUM_CONST(0)
#define SPI_COMMAND_0_CK_SDA_SECOND_CLK_EDGE                    _MK_ENUM_CONST(1)

// Reserved = 0
#define SPI_COMMAND_0_N_A_4_SHIFT                       _MK_SHIFT_CONST(20)
#define SPI_COMMAND_0_N_A_4_FIELD                       (_MK_MASK_CONST(0x1) << SPI_COMMAND_0_N_A_4_SHIFT)
#define SPI_COMMAND_0_N_A_4_RANGE                       20:20
#define SPI_COMMAND_0_N_A_4_WOFFSET                     0x0
#define SPI_COMMAND_0_N_A_4_DEFAULT                     _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_N_A_4_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_N_A_4_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_N_A_4_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Active Data signal format. Controls the output enable of the SCK line when the controller is actively doing data transfers.  00: Drive low.  01: Drive high.  10: Pull low.  11: Pull high.  Default: 00.
#define SPI_COMMAND_0_ACTIVE_SDA_SHIFT                  _MK_SHIFT_CONST(18)
#define SPI_COMMAND_0_ACTIVE_SDA_FIELD                  (_MK_MASK_CONST(0x3) << SPI_COMMAND_0_ACTIVE_SDA_SHIFT)
#define SPI_COMMAND_0_ACTIVE_SDA_RANGE                  19:18
#define SPI_COMMAND_0_ACTIVE_SDA_WOFFSET                        0x0
#define SPI_COMMAND_0_ACTIVE_SDA_DEFAULT                        _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_ACTIVE_SDA_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define SPI_COMMAND_0_ACTIVE_SDA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_ACTIVE_SDA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_ACTIVE_SDA_DRIVE_LOW                      _MK_ENUM_CONST(0)
#define SPI_COMMAND_0_ACTIVE_SDA_DRIVE_HIGH                     _MK_ENUM_CONST(1)
#define SPI_COMMAND_0_ACTIVE_SDA_PULL_LOW                       _MK_ENUM_CONST(2)
#define SPI_COMMAND_0_ACTIVE_SDA_PULL_HIGH                      _MK_ENUM_CONST(3)

// Reserved
#define SPI_COMMAND_0_N_A_5_SHIFT                       _MK_SHIFT_CONST(17)
#define SPI_COMMAND_0_N_A_5_FIELD                       (_MK_MASK_CONST(0x1) << SPI_COMMAND_0_N_A_5_SHIFT)
#define SPI_COMMAND_0_N_A_5_RANGE                       17:17
#define SPI_COMMAND_0_N_A_5_WOFFSET                     0x0
#define SPI_COMMAND_0_N_A_5_DEFAULT                     _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_N_A_5_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_N_A_5_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_N_A_5_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// CS signal Polarity.  For both SW and HW CS modes, this bit works as the polarity of the CS signal Default:0 
#define SPI_COMMAND_0_CS_POL_SHIFT                      _MK_SHIFT_CONST(16)
#define SPI_COMMAND_0_CS_POL_FIELD                      (_MK_MASK_CONST(0x1) << SPI_COMMAND_0_CS_POL_SHIFT)
#define SPI_COMMAND_0_CS_POL_RANGE                      16:16
#define SPI_COMMAND_0_CS_POL_WOFFSET                    0x0
#define SPI_COMMAND_0_CS_POL_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS_POL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_CS_POL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS_POL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS_POL_ACTIVE_LOW                 _MK_ENUM_CONST(0)
#define SPI_COMMAND_0_CS_POL_ACTIVE_HIGH                        _MK_ENUM_CONST(1)

// Transmit enable.  1 = Transmit is enabled. Data is transmitted out from the TX FIFO to SDA output.  0 = Transmit is disabled.  Default: 0 
#define SPI_COMMAND_0_TXEN_SHIFT                        _MK_SHIFT_CONST(15)
#define SPI_COMMAND_0_TXEN_FIELD                        (_MK_MASK_CONST(0x1) << SPI_COMMAND_0_TXEN_SHIFT)
#define SPI_COMMAND_0_TXEN_RANGE                        15:15
#define SPI_COMMAND_0_TXEN_WOFFSET                      0x0
#define SPI_COMMAND_0_TXEN_DEFAULT                      _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_TXEN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_TXEN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_TXEN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_TXEN_DISABLE                      _MK_ENUM_CONST(0)
#define SPI_COMMAND_0_TXEN_ENABLE                       _MK_ENUM_CONST(1)

// Receive enable.  1 = Receive is enabled. Data is received on SDI line and placed in the RX FIFO.  0 = Receive is disabled.  Default: 0 
#define SPI_COMMAND_0_RXEN_SHIFT                        _MK_SHIFT_CONST(14)
#define SPI_COMMAND_0_RXEN_FIELD                        (_MK_MASK_CONST(0x1) << SPI_COMMAND_0_RXEN_SHIFT)
#define SPI_COMMAND_0_RXEN_RANGE                        14:14
#define SPI_COMMAND_0_RXEN_WOFFSET                      0x0
#define SPI_COMMAND_0_RXEN_DEFAULT                      _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_RXEN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_RXEN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_RXEN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_RXEN_DISABLE                      _MK_ENUM_CONST(0)
#define SPI_COMMAND_0_RXEN_ENABLE                       _MK_ENUM_CONST(1)

// CS signal value/polarity.  If CS_SOFT is 1, then the value in CS_VAL is driven out on SPI_CS. If  CS_SOFT is 0, then this bit works as the polarity of the CS signal and is driven to active state during packet transfers and inactive state in between packet transfers. 
#define SPI_COMMAND_0_CS_VAL_SHIFT                      _MK_SHIFT_CONST(13)
#define SPI_COMMAND_0_CS_VAL_FIELD                      (_MK_MASK_CONST(0x1) << SPI_COMMAND_0_CS_VAL_SHIFT)
#define SPI_COMMAND_0_CS_VAL_RANGE                      13:13
#define SPI_COMMAND_0_CS_VAL_WOFFSET                    0x0
#define SPI_COMMAND_0_CS_VAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS_VAL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_CS_VAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS_VAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS_VAL_LOW                        _MK_ENUM_CONST(0)
#define SPI_COMMAND_0_CS_VAL_HIGH                       _MK_ENUM_CONST(1)

// Software control of SPI_CS signal 1 = SPI_CS is driven with the value in the CS bit.  0 = SPI_CS is driven to active during packet transfers by the hardware.  Default: 0
#define SPI_COMMAND_0_CS_SOFT_SHIFT                     _MK_SHIFT_CONST(12)
#define SPI_COMMAND_0_CS_SOFT_FIELD                     (_MK_MASK_CONST(0x1) << SPI_COMMAND_0_CS_SOFT_SHIFT)
#define SPI_COMMAND_0_CS_SOFT_RANGE                     12:12
#define SPI_COMMAND_0_CS_SOFT_WOFFSET                   0x0
#define SPI_COMMAND_0_CS_SOFT_DEFAULT                   _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS_SOFT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_CS_SOFT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS_SOFT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS_SOFT_HW_CTL                    _MK_ENUM_CONST(0)
#define SPI_COMMAND_0_CS_SOFT_SW_CTL                    _MK_ENUM_CONST(1)

// Programmable delay between two packets if CS is used in hardware mode (CS_SOFT = 0).  Default: 2.
#define SPI_COMMAND_0_CS_DELAY_SHIFT                    _MK_SHIFT_CONST(9)
#define SPI_COMMAND_0_CS_DELAY_FIELD                    (_MK_MASK_CONST(0x7) << SPI_COMMAND_0_CS_DELAY_SHIFT)
#define SPI_COMMAND_0_CS_DELAY_RANGE                    11:9
#define SPI_COMMAND_0_CS_DELAY_WOFFSET                  0x0
#define SPI_COMMAND_0_CS_DELAY_DEFAULT                  _MK_MASK_CONST(0x2)
#define SPI_COMMAND_0_CS_DELAY_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define SPI_COMMAND_0_CS_DELAY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS_DELAY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Enable for Chip select 3: 1 = cs3 is enabled.  0 = cs3 is disabled. (Default)
#define SPI_COMMAND_0_CS3_EN_SHIFT                      _MK_SHIFT_CONST(8)
#define SPI_COMMAND_0_CS3_EN_FIELD                      (_MK_MASK_CONST(0x1) << SPI_COMMAND_0_CS3_EN_SHIFT)
#define SPI_COMMAND_0_CS3_EN_RANGE                      8:8
#define SPI_COMMAND_0_CS3_EN_WOFFSET                    0x0
#define SPI_COMMAND_0_CS3_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS3_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_CS3_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS3_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS3_EN_DISABLE                    _MK_ENUM_CONST(0)
#define SPI_COMMAND_0_CS3_EN_ENABLE                     _MK_ENUM_CONST(1)

// Enable for Chip select 2: 1 = cs2 is enabled.  0 = cs2 is disabled. (Default)
#define SPI_COMMAND_0_CS2_EN_SHIFT                      _MK_SHIFT_CONST(7)
#define SPI_COMMAND_0_CS2_EN_FIELD                      (_MK_MASK_CONST(0x1) << SPI_COMMAND_0_CS2_EN_SHIFT)
#define SPI_COMMAND_0_CS2_EN_RANGE                      7:7
#define SPI_COMMAND_0_CS2_EN_WOFFSET                    0x0
#define SPI_COMMAND_0_CS2_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS2_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_CS2_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS2_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS2_EN_DISABLE                    _MK_ENUM_CONST(0)
#define SPI_COMMAND_0_CS2_EN_ENABLE                     _MK_ENUM_CONST(1)

// Enable for Chip select 1: 1 = cs1 is enabled.  0 = cs1 is disabled. (Default)
#define SPI_COMMAND_0_CS1_EN_SHIFT                      _MK_SHIFT_CONST(6)
#define SPI_COMMAND_0_CS1_EN_FIELD                      (_MK_MASK_CONST(0x1) << SPI_COMMAND_0_CS1_EN_SHIFT)
#define SPI_COMMAND_0_CS1_EN_RANGE                      6:6
#define SPI_COMMAND_0_CS1_EN_WOFFSET                    0x0
#define SPI_COMMAND_0_CS1_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS1_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_CS1_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS1_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS1_EN_DISABLE                    _MK_ENUM_CONST(0)
#define SPI_COMMAND_0_CS1_EN_ENABLE                     _MK_ENUM_CONST(1)

// Enable for Chip select 0: 1 = cs0 is enabled(Default).  0 = cs0 is disabled
#define SPI_COMMAND_0_CS0_EN_SHIFT                      _MK_SHIFT_CONST(5)
#define SPI_COMMAND_0_CS0_EN_FIELD                      (_MK_MASK_CONST(0x1) << SPI_COMMAND_0_CS0_EN_SHIFT)
#define SPI_COMMAND_0_CS0_EN_RANGE                      5:5
#define SPI_COMMAND_0_CS0_EN_WOFFSET                    0x0
#define SPI_COMMAND_0_CS0_EN_DEFAULT                    _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_CS0_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SPI_COMMAND_0_CS0_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS0_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_CS0_EN_DISABLE                    _MK_ENUM_CONST(0)
#define SPI_COMMAND_0_CS0_EN_ENABLE                     _MK_ENUM_CONST(1)

// Bit stream length.  0 = Single bit transfer.  1 = 2 bit transfer N = N + 1 bit transfer.  31 = 32 bit transfer (max) Default: 0 
#define SPI_COMMAND_0_BIT_LENGTH_SHIFT                  _MK_SHIFT_CONST(0)
#define SPI_COMMAND_0_BIT_LENGTH_FIELD                  (_MK_MASK_CONST(0x1f) << SPI_COMMAND_0_BIT_LENGTH_SHIFT)
#define SPI_COMMAND_0_BIT_LENGTH_RANGE                  4:0
#define SPI_COMMAND_0_BIT_LENGTH_WOFFSET                        0x0
#define SPI_COMMAND_0_BIT_LENGTH_DEFAULT                        _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_BIT_LENGTH_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define SPI_COMMAND_0_BIT_LENGTH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SPI_COMMAND_0_BIT_LENGTH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register SPI_STATUS_0  
#define SPI_STATUS_0                    _MK_ADDR_CONST(0x4)
#define SPI_STATUS_0_WORD_COUNT                         0x1
#define SPI_STATUS_0_RESET_VAL                  _MK_MASK_CONST(0x2800000)
#define SPI_STATUS_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define SPI_STATUS_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define SPI_STATUS_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
// Busy bit. Indicates that the controller is currently doing a data transfer.  This bit is set at the start of every transfer and will be cleared at the end of every transfer.  Default: 0 
#define SPI_STATUS_0_BSY_SHIFT                  _MK_SHIFT_CONST(31)
#define SPI_STATUS_0_BSY_FIELD                  (_MK_MASK_CONST(0x1) << SPI_STATUS_0_BSY_SHIFT)
#define SPI_STATUS_0_BSY_RANGE                  31:31
#define SPI_STATUS_0_BSY_WOFFSET                        0x0
#define SPI_STATUS_0_BSY_DEFAULT                        _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_BSY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SPI_STATUS_0_BSY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_BSY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_BSY_NOT_BUSY                       _MK_ENUM_CONST(0)
#define SPI_STATUS_0_BSY_BUSY                   _MK_ENUM_CONST(1)

// Ready bit. This bit is set at the end of every transfer and an interrupt is also generated if the corresponding interrupt enable is set. Software writes a 1 to clear it. The interrupt is also cleared when this bit is cleared.  Default: 0 
#define SPI_STATUS_0_RDY_SHIFT                  _MK_SHIFT_CONST(30)
#define SPI_STATUS_0_RDY_FIELD                  (_MK_MASK_CONST(0x1) << SPI_STATUS_0_RDY_SHIFT)
#define SPI_STATUS_0_RDY_RANGE                  30:30
#define SPI_STATUS_0_RDY_WOFFSET                        0x0
#define SPI_STATUS_0_RDY_DEFAULT                        _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_RDY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SPI_STATUS_0_RDY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_RDY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_RDY_NOT_READY                      _MK_ENUM_CONST(0)
#define SPI_STATUS_0_RDY_READY                  _MK_ENUM_CONST(1)

// RX FIFO Flush: WO. Software writes 1 to this bit to flush the RX FIFO. This bit will read 1 when the flush operation is in progress and will return to 0 when it is finished.  Default: 0 
#define SPI_STATUS_0_RXF_FLUSH_SHIFT                    _MK_SHIFT_CONST(29)
#define SPI_STATUS_0_RXF_FLUSH_FIELD                    (_MK_MASK_CONST(0x1) << SPI_STATUS_0_RXF_FLUSH_SHIFT)
#define SPI_STATUS_0_RXF_FLUSH_RANGE                    29:29
#define SPI_STATUS_0_RXF_FLUSH_WOFFSET                  0x0
#define SPI_STATUS_0_RXF_FLUSH_DEFAULT                  _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_RXF_FLUSH_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SPI_STATUS_0_RXF_FLUSH_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_RXF_FLUSH_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_RXF_FLUSH_DISABLE                  _MK_ENUM_CONST(0)
#define SPI_STATUS_0_RXF_FLUSH_ENABLE                   _MK_ENUM_CONST(1)

// TX FIFO Flush: WO. Software writes 1 to this bit to flush the TX FIFO. This bit will read 1 when the flush operation is in progress and will return to 0 when it is finished.  Default: 0 
#define SPI_STATUS_0_TXF_FLUSH_SHIFT                    _MK_SHIFT_CONST(28)
#define SPI_STATUS_0_TXF_FLUSH_FIELD                    (_MK_MASK_CONST(0x1) << SPI_STATUS_0_TXF_FLUSH_SHIFT)
#define SPI_STATUS_0_TXF_FLUSH_RANGE                    28:28
#define SPI_STATUS_0_TXF_FLUSH_WOFFSET                  0x0
#define SPI_STATUS_0_TXF_FLUSH_DEFAULT                  _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_TXF_FLUSH_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SPI_STATUS_0_TXF_FLUSH_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_TXF_FLUSH_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_TXF_FLUSH_DISABLE                  _MK_ENUM_CONST(0)
#define SPI_STATUS_0_TXF_FLUSH_ENABLE                   _MK_ENUM_CONST(1)

// RX FIFO Under run: RO.  This bit is set to 1 whenever software tries to read from an empty RX FIFO. An interrupt is generated if the interrupt enable is set for receive operation (IE.RXC in SPI_DMA_CTL register). Software writes a 1 to clear this bit. Clearing this bit also clears the interrupt.  Default: 0 
#define SPI_STATUS_0_RXF_UNR_SHIFT                      _MK_SHIFT_CONST(27)
#define SPI_STATUS_0_RXF_UNR_FIELD                      (_MK_MASK_CONST(0x1) << SPI_STATUS_0_RXF_UNR_SHIFT)
#define SPI_STATUS_0_RXF_UNR_RANGE                      27:27
#define SPI_STATUS_0_RXF_UNR_WOFFSET                    0x0
#define SPI_STATUS_0_RXF_UNR_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_RXF_UNR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SPI_STATUS_0_RXF_UNR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_RXF_UNR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_RXF_UNR_UNSET                      _MK_ENUM_CONST(0)
#define SPI_STATUS_0_RXF_UNR_SET                        _MK_ENUM_CONST(1)

// TX FIFO Overflow: RO.  This bit is set to 1 whenever software tries to write to a full TX FIFO. An interrupt is generated if the interrupt enable is set for transmit operation (IE.TXC in SPI_DMA_CTL register). Software writes a 1 to clear this bit. Clearing this bit also clears the interrupt.  Default: 0 
#define SPI_STATUS_0_TXF_OVF_SHIFT                      _MK_SHIFT_CONST(26)
#define SPI_STATUS_0_TXF_OVF_FIELD                      (_MK_MASK_CONST(0x1) << SPI_STATUS_0_TXF_OVF_SHIFT)
#define SPI_STATUS_0_TXF_OVF_RANGE                      26:26
#define SPI_STATUS_0_TXF_OVF_WOFFSET                    0x0
#define SPI_STATUS_0_TXF_OVF_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_TXF_OVF_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SPI_STATUS_0_TXF_OVF_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_TXF_OVF_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_TXF_OVF_UNSET                      _MK_ENUM_CONST(0)
#define SPI_STATUS_0_TXF_OVF_SET                        _MK_ENUM_CONST(1)

// RX FIFO empty status: RO.  Hardware sets this bit to 1 if RX FIFO is empty. Otherwise, this bit is set to 0.  Default: 1. FIFO is empty at POR.  
#define SPI_STATUS_0_RXF_EMPTY_SHIFT                    _MK_SHIFT_CONST(25)
#define SPI_STATUS_0_RXF_EMPTY_FIELD                    (_MK_MASK_CONST(0x1) << SPI_STATUS_0_RXF_EMPTY_SHIFT)
#define SPI_STATUS_0_RXF_EMPTY_RANGE                    25:25
#define SPI_STATUS_0_RXF_EMPTY_WOFFSET                  0x0
#define SPI_STATUS_0_RXF_EMPTY_DEFAULT                  _MK_MASK_CONST(0x1)
#define SPI_STATUS_0_RXF_EMPTY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SPI_STATUS_0_RXF_EMPTY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_RXF_EMPTY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_RXF_EMPTY_NOT_EMPTY                        _MK_ENUM_CONST(0)
#define SPI_STATUS_0_RXF_EMPTY_EMPTY                    _MK_ENUM_CONST(1)

// RX FIFO full status: RO.  Hardware sets this bit to 1 if RX FIFO is full. Otherwise, this bit is set to 0.  Default: 0. FIFO is empty at POR.  
#define SPI_STATUS_0_RXF_FULL_SHIFT                     _MK_SHIFT_CONST(24)
#define SPI_STATUS_0_RXF_FULL_FIELD                     (_MK_MASK_CONST(0x1) << SPI_STATUS_0_RXF_FULL_SHIFT)
#define SPI_STATUS_0_RXF_FULL_RANGE                     24:24
#define SPI_STATUS_0_RXF_FULL_WOFFSET                   0x0
#define SPI_STATUS_0_RXF_FULL_DEFAULT                   _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_RXF_FULL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SPI_STATUS_0_RXF_FULL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_RXF_FULL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_RXF_FULL_NOT_FULL                  _MK_ENUM_CONST(0)
#define SPI_STATUS_0_RXF_FULL_FULL                      _MK_ENUM_CONST(1)

// TX FIFO empty status: RO.  Hardware sets this bit to 1 if TX FIFO is empty. Otherwise, this bit is set to 0.  Default: 1. FIFO is empty at POR.  
#define SPI_STATUS_0_TXF_EMPTY_SHIFT                    _MK_SHIFT_CONST(23)
#define SPI_STATUS_0_TXF_EMPTY_FIELD                    (_MK_MASK_CONST(0x1) << SPI_STATUS_0_TXF_EMPTY_SHIFT)
#define SPI_STATUS_0_TXF_EMPTY_RANGE                    23:23
#define SPI_STATUS_0_TXF_EMPTY_WOFFSET                  0x0
#define SPI_STATUS_0_TXF_EMPTY_DEFAULT                  _MK_MASK_CONST(0x1)
#define SPI_STATUS_0_TXF_EMPTY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define SPI_STATUS_0_TXF_EMPTY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_TXF_EMPTY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_TXF_EMPTY_NOT_EMPTY                        _MK_ENUM_CONST(0)
#define SPI_STATUS_0_TXF_EMPTY_EMPTY                    _MK_ENUM_CONST(1)

// TX FIFO full status: RO.  Hardware sets this bit to 1 if TX FIFO is full. Otherwise, this bit is set to 0.  Default: 0. FIFO is empty at POR.  
#define SPI_STATUS_0_TXF_FULL_SHIFT                     _MK_SHIFT_CONST(22)
#define SPI_STATUS_0_TXF_FULL_FIELD                     (_MK_MASK_CONST(0x1) << SPI_STATUS_0_TXF_FULL_SHIFT)
#define SPI_STATUS_0_TXF_FULL_RANGE                     22:22
#define SPI_STATUS_0_TXF_FULL_WOFFSET                   0x0
#define SPI_STATUS_0_TXF_FULL_DEFAULT                   _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_TXF_FULL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SPI_STATUS_0_TXF_FULL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_TXF_FULL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_TXF_FULL_NOT_FULL                  _MK_ENUM_CONST(0)
#define SPI_STATUS_0_TXF_FULL_FULL                      _MK_ENUM_CONST(1)

// Reserved = 0
#define SPI_STATUS_0_N_A_6_SHIFT                        _MK_SHIFT_CONST(17)
#define SPI_STATUS_0_N_A_6_FIELD                        (_MK_MASK_CONST(0x1f) << SPI_STATUS_0_N_A_6_SHIFT)
#define SPI_STATUS_0_N_A_6_RANGE                        21:17
#define SPI_STATUS_0_N_A_6_WOFFSET                      0x0
#define SPI_STATUS_0_N_A_6_DEFAULT                      _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_N_A_6_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define SPI_STATUS_0_N_A_6_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_N_A_6_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Selects whether the receive or transmit block count to be read in the field CUR_BLOCK_COUNT.  1: Transmit block count will be read in CUR_BLOCK_COUNT.  0: Receive block count will be read in CUR_BLOCK_COUNT.  Default: 0.  
#define SPI_STATUS_0_SEL_TX_RX_N_SHIFT                  _MK_SHIFT_CONST(16)
#define SPI_STATUS_0_SEL_TX_RX_N_FIELD                  (_MK_MASK_CONST(0x1) << SPI_STATUS_0_SEL_TX_RX_N_SHIFT)
#define SPI_STATUS_0_SEL_TX_RX_N_RANGE                  16:16
#define SPI_STATUS_0_SEL_TX_RX_N_WOFFSET                        0x0
#define SPI_STATUS_0_SEL_TX_RX_N_DEFAULT                        _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_SEL_TX_RX_N_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define SPI_STATUS_0_SEL_TX_RX_N_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_SEL_TX_RX_N_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_SEL_TX_RX_N_SEL_RX_CNT                     _MK_ENUM_CONST(0)
#define SPI_STATUS_0_SEL_TX_RX_N_SEL_TX_CNT                     _MK_ENUM_CONST(1)

// Selects whether the receive or transmit block count to be read in the field CUR_BLOCK_COUNT.  1: Transmit block count will be read in CUR_BLOCK_COUNT.  0: Receive block count will be read in CUR_BLOCK_COUNT.  Default: 0.  
#define SPI_STATUS_0_CUR_BLOCK_COUNT_SHIFT                      _MK_SHIFT_CONST(0)
#define SPI_STATUS_0_CUR_BLOCK_COUNT_FIELD                      (_MK_MASK_CONST(0xffff) << SPI_STATUS_0_CUR_BLOCK_COUNT_SHIFT)
#define SPI_STATUS_0_CUR_BLOCK_COUNT_RANGE                      15:0
#define SPI_STATUS_0_CUR_BLOCK_COUNT_WOFFSET                    0x0
#define SPI_STATUS_0_CUR_BLOCK_COUNT_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_CUR_BLOCK_COUNT_DEFAULT_MASK                       _MK_MASK_CONST(0xffff)
#define SPI_STATUS_0_CUR_BLOCK_COUNT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SPI_STATUS_0_CUR_BLOCK_COUNT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register SPI_RX_CMP_0  
#define SPI_RX_CMP_0                    _MK_ADDR_CONST(0x8)
#define SPI_RX_CMP_0_WORD_COUNT                         0x1
#define SPI_RX_CMP_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define SPI_RX_CMP_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define SPI_RX_CMP_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define SPI_RX_CMP_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SPI_RX_CMP_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define SPI_RX_CMP_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
// Reserved = 0
#define SPI_RX_CMP_0_N_A_7_SHIFT                        _MK_SHIFT_CONST(17)
#define SPI_RX_CMP_0_N_A_7_FIELD                        (_MK_MASK_CONST(0x7fff) << SPI_RX_CMP_0_N_A_7_SHIFT)
#define SPI_RX_CMP_0_N_A_7_RANGE                        31:17
#define SPI_RX_CMP_0_N_A_7_WOFFSET                      0x0
#define SPI_RX_CMP_0_N_A_7_DEFAULT                      _MK_MASK_CONST(0x0)
#define SPI_RX_CMP_0_N_A_7_DEFAULT_MASK                 _MK_MASK_CONST(0x7fff)
#define SPI_RX_CMP_0_N_A_7_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define SPI_RX_CMP_0_N_A_7_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Enable Receive Compare mode.  1 = Enable receive compare mode. Data received on SDI signal is ignored until a compare match occurs, that is, if the mask on the data input by RXCMP_MASK matches the RXCMP_VAL. This is only valid if the BIT_LENGTH field in SPI_COMMAND register is set to 7 (8-bit packet length).  0 = Disable receive compare mode. All data received on SDI signal is placed in the RX FIFO.  Default: 0 
#define SPI_RX_CMP_0_RXCMP_EN_SHIFT                     _MK_SHIFT_CONST(16)
#define SPI_RX_CMP_0_RXCMP_EN_FIELD                     (_MK_MASK_CONST(0x1) << SPI_RX_CMP_0_RXCMP_EN_SHIFT)
#define SPI_RX_CMP_0_RXCMP_EN_RANGE                     16:16
#define SPI_RX_CMP_0_RXCMP_EN_WOFFSET                   0x0
#define SPI_RX_CMP_0_RXCMP_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define SPI_RX_CMP_0_RXCMP_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define SPI_RX_CMP_0_RXCMP_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SPI_RX_CMP_0_RXCMP_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SPI_RX_CMP_0_RXCMP_EN_DISABLE                   _MK_ENUM_CONST(0)
#define SPI_RX_CMP_0_RXCMP_EN_ENABLE                    _MK_ENUM_CONST(1)

// Mask on the receive data.  This mask value is applied to the receive data before comparing it to RXCMP_VAL for a match. A 1 in any bit position in RXCMP_MASK will exclude that bit position in the received data from comparing against corresponding bit position in RXCMP_VAL. Only the bits that have 0 will be compared.  Default: 0 
#define SPI_RX_CMP_0_RXCMP_MASK_SHIFT                   _MK_SHIFT_CONST(8)
#define SPI_RX_CMP_0_RXCMP_MASK_FIELD                   (_MK_MASK_CONST(0xff) << SPI_RX_CMP_0_RXCMP_MASK_SHIFT)
#define SPI_RX_CMP_0_RXCMP_MASK_RANGE                   15:8
#define SPI_RX_CMP_0_RXCMP_MASK_WOFFSET                 0x0
#define SPI_RX_CMP_0_RXCMP_MASK_DEFAULT                 _MK_MASK_CONST(0x0)
#define SPI_RX_CMP_0_RXCMP_MASK_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define SPI_RX_CMP_0_RXCMP_MASK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define SPI_RX_CMP_0_RXCMP_MASK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Receive compare value.  This value is compared to the received data after applying the mask in RXCMP_MASK.  Default:0 
#define SPI_RX_CMP_0_RXCMP_VAL_SHIFT                    _MK_SHIFT_CONST(0)
#define SPI_RX_CMP_0_RXCMP_VAL_FIELD                    (_MK_MASK_CONST(0xff) << SPI_RX_CMP_0_RXCMP_VAL_SHIFT)
#define SPI_RX_CMP_0_RXCMP_VAL_RANGE                    7:0
#define SPI_RX_CMP_0_RXCMP_VAL_WOFFSET                  0x0
#define SPI_RX_CMP_0_RXCMP_VAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define SPI_RX_CMP_0_RXCMP_VAL_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define SPI_RX_CMP_0_RXCMP_VAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define SPI_RX_CMP_0_RXCMP_VAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register SPI_DMA_CTL_0  
#define SPI_DMA_CTL_0                   _MK_ADDR_CONST(0xc)
#define SPI_DMA_CTL_0_WORD_COUNT                        0x1
#define SPI_DMA_CTL_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define SPI_DMA_CTL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define SPI_DMA_CTL_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// Enable DMA mode transfer.  Software writes a 1 to this bit to start a transfer in the DMA mode. All fields in the SPI_COMMAND and SPI_DMA_CTL register must be set before writing a 1 to this bit. This bit is cleared by the controller after all packets have been transferred as indicated by the DMA_BLOCK_SIZE field.  Default: 0 
#define SPI_DMA_CTL_0_DMA_EN_SHIFT                      _MK_SHIFT_CONST(31)
#define SPI_DMA_CTL_0_DMA_EN_FIELD                      (_MK_MASK_CONST(0x1) << SPI_DMA_CTL_0_DMA_EN_SHIFT)
#define SPI_DMA_CTL_0_DMA_EN_RANGE                      31:31
#define SPI_DMA_CTL_0_DMA_EN_WOFFSET                    0x0
#define SPI_DMA_CTL_0_DMA_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_DMA_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SPI_DMA_CTL_0_DMA_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_DMA_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_DMA_EN_DISABLE                    _MK_ENUM_CONST(0)
#define SPI_DMA_CTL_0_DMA_EN_ENABLE                     _MK_ENUM_CONST(1)

// Reserved = 0
#define SPI_DMA_CTL_0_N_A_8_SHIFT                       _MK_SHIFT_CONST(28)
#define SPI_DMA_CTL_0_N_A_8_FIELD                       (_MK_MASK_CONST(0x7) << SPI_DMA_CTL_0_N_A_8_SHIFT)
#define SPI_DMA_CTL_0_N_A_8_RANGE                       30:28
#define SPI_DMA_CTL_0_N_A_8_WOFFSET                     0x0
#define SPI_DMA_CTL_0_N_A_8_DEFAULT                     _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_N_A_8_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define SPI_DMA_CTL_0_N_A_8_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_N_A_8_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Interrupt enable on receive completion.  1 = Enable interrupt generation at the end of a receive transfer.  0 = Disable interrupt generation for receive.  Default: 0 
#define SPI_DMA_CTL_0_IE_RXC_SHIFT                      _MK_SHIFT_CONST(27)
#define SPI_DMA_CTL_0_IE_RXC_FIELD                      (_MK_MASK_CONST(0x1) << SPI_DMA_CTL_0_IE_RXC_SHIFT)
#define SPI_DMA_CTL_0_IE_RXC_RANGE                      27:27
#define SPI_DMA_CTL_0_IE_RXC_WOFFSET                    0x0
#define SPI_DMA_CTL_0_IE_RXC_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_IE_RXC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SPI_DMA_CTL_0_IE_RXC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_IE_RXC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_IE_RXC_DISABLE                    _MK_ENUM_CONST(0)
#define SPI_DMA_CTL_0_IE_RXC_ENABLE                     _MK_ENUM_CONST(1)

// Interrupt enable on transmit completion.  1 = Enable interrupt generation at the end of a transmit transfer.  0 = Disable interrupt generation for transmit.  Default: 0 
#define SPI_DMA_CTL_0_IE_TXC_SHIFT                      _MK_SHIFT_CONST(26)
#define SPI_DMA_CTL_0_IE_TXC_FIELD                      (_MK_MASK_CONST(0x1) << SPI_DMA_CTL_0_IE_TXC_SHIFT)
#define SPI_DMA_CTL_0_IE_TXC_RANGE                      26:26
#define SPI_DMA_CTL_0_IE_TXC_WOFFSET                    0x0
#define SPI_DMA_CTL_0_IE_TXC_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_IE_TXC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SPI_DMA_CTL_0_IE_TXC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_IE_TXC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_IE_TXC_DISABLE                    _MK_ENUM_CONST(0)
#define SPI_DMA_CTL_0_IE_TXC_ENABLE                     _MK_ENUM_CONST(1)

// Reserved = 0
#define SPI_DMA_CTL_0_N_A_9_SHIFT                       _MK_SHIFT_CONST(21)
#define SPI_DMA_CTL_0_N_A_9_FIELD                       (_MK_MASK_CONST(0x1f) << SPI_DMA_CTL_0_N_A_9_SHIFT)
#define SPI_DMA_CTL_0_N_A_9_RANGE                       25:21
#define SPI_DMA_CTL_0_N_A_9_WOFFSET                     0x0
#define SPI_DMA_CTL_0_N_A_9_DEFAULT                     _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_N_A_9_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define SPI_DMA_CTL_0_N_A_9_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_N_A_9_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Packed mode enable bit.  1 = Packed mode is enabled. This is only valid if BIT_LENGTH in SPI_COMMAND register is set to either 7 (8-bit transfer) or 15 (16-bit transfer). When enabled, all 32-bits of data in the FIFO contains valid data packets of either 8-bit or 16-bit length.  0 = Packed mode is disabled.  Default: 0 
#define SPI_DMA_CTL_0_PACKED_SHIFT                      _MK_SHIFT_CONST(20)
#define SPI_DMA_CTL_0_PACKED_FIELD                      (_MK_MASK_CONST(0x1) << SPI_DMA_CTL_0_PACKED_SHIFT)
#define SPI_DMA_CTL_0_PACKED_RANGE                      20:20
#define SPI_DMA_CTL_0_PACKED_WOFFSET                    0x0
#define SPI_DMA_CTL_0_PACKED_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_PACKED_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define SPI_DMA_CTL_0_PACKED_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_PACKED_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_PACKED_DISABLE                    _MK_ENUM_CONST(0)
#define SPI_DMA_CTL_0_PACKED_ENABLE                     _MK_ENUM_CONST(1)

//  Receive FIFO Trigger level 00: 1 word. DMA trigger is asserted whenever there is space for at least 1 word in the TX FIFO.  01: 4 words. DMA trigger is asserted when there is space for 4 words in the TX FIFO.  10: Reserved.  11: Reserved
#define SPI_DMA_CTL_0_RX_TRIG_SHIFT                     _MK_SHIFT_CONST(18)
#define SPI_DMA_CTL_0_RX_TRIG_FIELD                     (_MK_MASK_CONST(0x3) << SPI_DMA_CTL_0_RX_TRIG_SHIFT)
#define SPI_DMA_CTL_0_RX_TRIG_RANGE                     19:18
#define SPI_DMA_CTL_0_RX_TRIG_WOFFSET                   0x0
#define SPI_DMA_CTL_0_RX_TRIG_DEFAULT                   _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_RX_TRIG_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define SPI_DMA_CTL_0_RX_TRIG_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_RX_TRIG_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_RX_TRIG_TRIG1                     _MK_ENUM_CONST(0)
#define SPI_DMA_CTL_0_RX_TRIG_TRIG4                     _MK_ENUM_CONST(1)

// Transmit FIFO trigger level.  00: 1 word. DMA trigger is asserted whenever there is space for at least 1 word in the TX FIFO.  01: 4 words. DMA trigger is asserted when there is space for 4 words in the TX FIFO.  10: Reserved.  11: Reserved.  Default: 00 
#define SPI_DMA_CTL_0_TX_TRIG_SHIFT                     _MK_SHIFT_CONST(16)
#define SPI_DMA_CTL_0_TX_TRIG_FIELD                     (_MK_MASK_CONST(0x3) << SPI_DMA_CTL_0_TX_TRIG_SHIFT)
#define SPI_DMA_CTL_0_TX_TRIG_RANGE                     17:16
#define SPI_DMA_CTL_0_TX_TRIG_WOFFSET                   0x0
#define SPI_DMA_CTL_0_TX_TRIG_DEFAULT                   _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_TX_TRIG_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define SPI_DMA_CTL_0_TX_TRIG_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_TX_TRIG_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_TX_TRIG_TRIG1                     _MK_ENUM_CONST(0)
#define SPI_DMA_CTL_0_TX_TRIG_TRIG4                     _MK_ENUM_CONST(1)

// Size of data block to be transferred using DMA mode.  This field specifies the size of the data block to be transferred through DMA mode.  N: N + 1 Data packets.  Default: 0 
#define SPI_DMA_CTL_0_DMA_BLOCK_SIZE_SHIFT                      _MK_SHIFT_CONST(0)
#define SPI_DMA_CTL_0_DMA_BLOCK_SIZE_FIELD                      (_MK_MASK_CONST(0xffff) << SPI_DMA_CTL_0_DMA_BLOCK_SIZE_SHIFT)
#define SPI_DMA_CTL_0_DMA_BLOCK_SIZE_RANGE                      15:0
#define SPI_DMA_CTL_0_DMA_BLOCK_SIZE_WOFFSET                    0x0
#define SPI_DMA_CTL_0_DMA_BLOCK_SIZE_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_DMA_BLOCK_SIZE_DEFAULT_MASK                       _MK_MASK_CONST(0xffff)
#define SPI_DMA_CTL_0_DMA_BLOCK_SIZE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define SPI_DMA_CTL_0_DMA_BLOCK_SIZE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register SPI_TX_FIFO_0  
#define SPI_TX_FIFO_0                   _MK_ADDR_CONST(0x10)
#define SPI_TX_FIFO_0_WORD_COUNT                        0x1
#define SPI_TX_FIFO_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define SPI_TX_FIFO_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define SPI_TX_FIFO_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define SPI_TX_FIFO_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SPI_TX_FIFO_0_READ_MASK                         _MK_MASK_CONST(0x0)
#define SPI_TX_FIFO_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// TX FIFO
#define SPI_TX_FIFO_0_SPI_TX_FIFO_SHIFT                 _MK_SHIFT_CONST(0)
#define SPI_TX_FIFO_0_SPI_TX_FIFO_FIELD                 (_MK_MASK_CONST(0xffffffff) << SPI_TX_FIFO_0_SPI_TX_FIFO_SHIFT)
#define SPI_TX_FIFO_0_SPI_TX_FIFO_RANGE                 31:0
#define SPI_TX_FIFO_0_SPI_TX_FIFO_WOFFSET                       0x0
#define SPI_TX_FIFO_0_SPI_TX_FIFO_DEFAULT                       _MK_MASK_CONST(0x0)
#define SPI_TX_FIFO_0_SPI_TX_FIFO_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define SPI_TX_FIFO_0_SPI_TX_FIFO_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_TX_FIFO_0_SPI_TX_FIFO_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 20 [0x14] 

// Reserved address 24 [0x18] 

// Reserved address 28 [0x1c] 

// Register SPI_RX_FIFO_0  
#define SPI_RX_FIFO_0                   _MK_ADDR_CONST(0x20)
#define SPI_RX_FIFO_0_WORD_COUNT                        0x1
#define SPI_RX_FIFO_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define SPI_RX_FIFO_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define SPI_RX_FIFO_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define SPI_RX_FIFO_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define SPI_RX_FIFO_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define SPI_RX_FIFO_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
// RX FIFO
#define SPI_RX_FIFO_0_SPI_RX_FIFO_SHIFT                 _MK_SHIFT_CONST(0)
#define SPI_RX_FIFO_0_SPI_RX_FIFO_FIELD                 (_MK_MASK_CONST(0xffffffff) << SPI_RX_FIFO_0_SPI_RX_FIFO_SHIFT)
#define SPI_RX_FIFO_0_SPI_RX_FIFO_RANGE                 31:0
#define SPI_RX_FIFO_0_SPI_RX_FIFO_WOFFSET                       0x0
#define SPI_RX_FIFO_0_SPI_RX_FIFO_DEFAULT                       _MK_MASK_CONST(0x0)
#define SPI_RX_FIFO_0_SPI_RX_FIFO_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define SPI_RX_FIFO_0_SPI_RX_FIFO_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define SPI_RX_FIFO_0_SPI_RX_FIFO_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_ARSPI_REGS(_op_) \
_op_(SPI_COMMAND_0) \
_op_(SPI_STATUS_0) \
_op_(SPI_RX_CMP_0) \
_op_(SPI_DMA_CTL_0) \
_op_(SPI_TX_FIFO_0) \
_op_(SPI_RX_FIFO_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_SPI        0x00000000

//
// ARSPI REGISTER BANKS
//

#define SPI0_FIRST_REG 0x0000 // SPI_COMMAND_0
#define SPI0_LAST_REG 0x0010 // SPI_TX_FIFO_0
#define SPI1_FIRST_REG 0x0020 // SPI_RX_FIFO_0
#define SPI1_LAST_REG 0x0020 // SPI_RX_FIFO_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARSPI_H_INC_
