/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARSTAT_MON_H_INC_
#define ___ARSTAT_MON_H_INC_

// Register STAT_MON_GLB_INT_STATUS_0  
#define STAT_MON_GLB_INT_STATUS_0                       _MK_ADDR_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_WORD_COUNT                    0x1
#define STAT_MON_GLB_INT_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_GLB_INT_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define STAT_MON_GLB_INT_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// CPU Monitor interrupt status. 1 = interrupt detected
#define STAT_MON_GLB_INT_STATUS_0_CPU_INT_SHIFT                 _MK_SHIFT_CONST(31)
#define STAT_MON_GLB_INT_STATUS_0_CPU_INT_FIELD                 (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_CPU_INT_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_CPU_INT_RANGE                 31:31
#define STAT_MON_GLB_INT_STATUS_0_CPU_INT_WOFFSET                       0x0
#define STAT_MON_GLB_INT_STATUS_0_CPU_INT_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_CPU_INT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_CPU_INT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_CPU_INT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_CPU_INT_NOINT                 _MK_ENUM_CONST(0)    // // 0 = interrupt not detected

#define STAT_MON_GLB_INT_STATUS_0_CPU_INT_INT                   _MK_ENUM_CONST(1)

// COP Monitor interrupt status. 1 = interrupt detected
#define STAT_MON_GLB_INT_STATUS_0_COP_INT_SHIFT                 _MK_SHIFT_CONST(30)
#define STAT_MON_GLB_INT_STATUS_0_COP_INT_FIELD                 (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_COP_INT_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_COP_INT_RANGE                 30:30
#define STAT_MON_GLB_INT_STATUS_0_COP_INT_WOFFSET                       0x0
#define STAT_MON_GLB_INT_STATUS_0_COP_INT_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_COP_INT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_COP_INT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_COP_INT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_COP_INT_NOINT                 _MK_ENUM_CONST(0)    // // 0 = interrupt not detected

#define STAT_MON_GLB_INT_STATUS_0_COP_INT_INT                   _MK_ENUM_CONST(1)

// Rsvd
#define STAT_MON_GLB_INT_STATUS_0_N_A4_SHIFT                    _MK_SHIFT_CONST(29)
#define STAT_MON_GLB_INT_STATUS_0_N_A4_FIELD                    (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_N_A4_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_N_A4_RANGE                    29:29
#define STAT_MON_GLB_INT_STATUS_0_N_A4_WOFFSET                  0x0
#define STAT_MON_GLB_INT_STATUS_0_N_A4_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_N_A4_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_N_A4_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_N_A4_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// COP Cache Monitor interrupt status. 1 = interrupt detected
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_INT_SHIFT                      _MK_SHIFT_CONST(28)
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_INT_FIELD                      (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_CACHE2_INT_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_INT_RANGE                      28:28
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_INT_WOFFSET                    0x0
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_INT_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_INT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_INT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_INT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_INT_NOINT                      _MK_ENUM_CONST(0)    // // 0 = interrupt not detected

#define STAT_MON_GLB_INT_STATUS_0_CACHE2_INT_INT                        _MK_ENUM_CONST(1)

// Memory Controller Monitor interrupt status. 1 = interrupt detected
#define STAT_MON_GLB_INT_STATUS_0_MEM_INT_SHIFT                 _MK_SHIFT_CONST(27)
#define STAT_MON_GLB_INT_STATUS_0_MEM_INT_FIELD                 (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_MEM_INT_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_MEM_INT_RANGE                 27:27
#define STAT_MON_GLB_INT_STATUS_0_MEM_INT_WOFFSET                       0x0
#define STAT_MON_GLB_INT_STATUS_0_MEM_INT_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_MEM_INT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_MEM_INT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_MEM_INT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_MEM_INT_NOINT                 _MK_ENUM_CONST(0)    // // 0 = interrupt not detected

#define STAT_MON_GLB_INT_STATUS_0_MEM_INT_INT                   _MK_ENUM_CONST(1)

// Video Pipe Monitor interrupt status. 1 = interrupt detected
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_INT_SHIFT                       _MK_SHIFT_CONST(26)
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_INT_FIELD                       (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_VPIPE_INT_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_INT_RANGE                       26:26
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_INT_WOFFSET                     0x0
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_INT_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_INT_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_INT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_INT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_INT_NOINT                       _MK_ENUM_CONST(0)    // // 0 = interrupt not detected

#define STAT_MON_GLB_INT_STATUS_0_VPIPE_INT_INT                 _MK_ENUM_CONST(1)

// AHB Monitor interrupt status. 1 = interrupt detected
#define STAT_MON_GLB_INT_STATUS_0_AHB_INT_SHIFT                 _MK_SHIFT_CONST(25)
#define STAT_MON_GLB_INT_STATUS_0_AHB_INT_FIELD                 (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_AHB_INT_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_AHB_INT_RANGE                 25:25
#define STAT_MON_GLB_INT_STATUS_0_AHB_INT_WOFFSET                       0x0
#define STAT_MON_GLB_INT_STATUS_0_AHB_INT_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_AHB_INT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_AHB_INT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_AHB_INT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_AHB_INT_NOINT                 _MK_ENUM_CONST(0)    // // 0 = interrupt not detected

#define STAT_MON_GLB_INT_STATUS_0_AHB_INT_INT                   _MK_ENUM_CONST(1)

// APB Monitor interrupt status. 1 = interrupt detected
#define STAT_MON_GLB_INT_STATUS_0_APB_INT_SHIFT                 _MK_SHIFT_CONST(24)
#define STAT_MON_GLB_INT_STATUS_0_APB_INT_FIELD                 (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_APB_INT_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_APB_INT_RANGE                 24:24
#define STAT_MON_GLB_INT_STATUS_0_APB_INT_WOFFSET                       0x0
#define STAT_MON_GLB_INT_STATUS_0_APB_INT_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_APB_INT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_APB_INT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_APB_INT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_APB_INT_NOINT                 _MK_ENUM_CONST(0)    // // 0 = interrupt not detected

#define STAT_MON_GLB_INT_STATUS_0_APB_INT_INT                   _MK_ENUM_CONST(1)

// Semaphore Monitor interrupt status. 1 = interrupt detected
#define STAT_MON_GLB_INT_STATUS_0_SMP_INT_SHIFT                 _MK_SHIFT_CONST(23)
#define STAT_MON_GLB_INT_STATUS_0_SMP_INT_FIELD                 (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_SMP_INT_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_SMP_INT_RANGE                 23:23
#define STAT_MON_GLB_INT_STATUS_0_SMP_INT_WOFFSET                       0x0
#define STAT_MON_GLB_INT_STATUS_0_SMP_INT_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_SMP_INT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_SMP_INT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_SMP_INT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_SMP_INT_NOINT                 _MK_ENUM_CONST(0)    // // 0 = interrupt not detected

#define STAT_MON_GLB_INT_STATUS_0_SMP_INT_INT                   _MK_ENUM_CONST(1)

// Rsvd
#define STAT_MON_GLB_INT_STATUS_0_N_A3_SHIFT                    _MK_SHIFT_CONST(16)
#define STAT_MON_GLB_INT_STATUS_0_N_A3_FIELD                    (_MK_MASK_CONST(0x7f) << STAT_MON_GLB_INT_STATUS_0_N_A3_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_N_A3_RANGE                    22:16
#define STAT_MON_GLB_INT_STATUS_0_N_A3_WOFFSET                  0x0
#define STAT_MON_GLB_INT_STATUS_0_N_A3_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_N_A3_DEFAULT_MASK                     _MK_MASK_CONST(0x7f)
#define STAT_MON_GLB_INT_STATUS_0_N_A3_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_N_A3_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// CPU monitor active status.  1 = active
#define STAT_MON_GLB_INT_STATUS_0_CPU_MON_ACT_SHIFT                     _MK_SHIFT_CONST(15)
#define STAT_MON_GLB_INT_STATUS_0_CPU_MON_ACT_FIELD                     (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_CPU_MON_ACT_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_CPU_MON_ACT_RANGE                     15:15
#define STAT_MON_GLB_INT_STATUS_0_CPU_MON_ACT_WOFFSET                   0x0
#define STAT_MON_GLB_INT_STATUS_0_CPU_MON_ACT_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_CPU_MON_ACT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_CPU_MON_ACT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_CPU_MON_ACT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_CPU_MON_ACT_INACTIVE                  _MK_ENUM_CONST(0)    // // 0 = inactive

#define STAT_MON_GLB_INT_STATUS_0_CPU_MON_ACT_ACTIVE                    _MK_ENUM_CONST(1)

// COP monitor active status. 0 = inactive. 1 = active
#define STAT_MON_GLB_INT_STATUS_0_COP_MON_ACT_SHIFT                     _MK_SHIFT_CONST(14)
#define STAT_MON_GLB_INT_STATUS_0_COP_MON_ACT_FIELD                     (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_COP_MON_ACT_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_COP_MON_ACT_RANGE                     14:14
#define STAT_MON_GLB_INT_STATUS_0_COP_MON_ACT_WOFFSET                   0x0
#define STAT_MON_GLB_INT_STATUS_0_COP_MON_ACT_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_COP_MON_ACT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_COP_MON_ACT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_COP_MON_ACT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_COP_MON_ACT_INACTIVE                  _MK_ENUM_CONST(0)    // // 0 = inactive

#define STAT_MON_GLB_INT_STATUS_0_COP_MON_ACT_ACTIVE                    _MK_ENUM_CONST(1)

// Rsvd
#define STAT_MON_GLB_INT_STATUS_0_N_A2_SHIFT                    _MK_SHIFT_CONST(13)
#define STAT_MON_GLB_INT_STATUS_0_N_A2_FIELD                    (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_N_A2_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_N_A2_RANGE                    13:13
#define STAT_MON_GLB_INT_STATUS_0_N_A2_WOFFSET                  0x0
#define STAT_MON_GLB_INT_STATUS_0_N_A2_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_N_A2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_N_A2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_N_A2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// COP cache monitor active status. 0 = inactive. 1 = active
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_MON_ACT_SHIFT                  _MK_SHIFT_CONST(12)
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_MON_ACT_FIELD                  (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_CACHE2_MON_ACT_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_MON_ACT_RANGE                  12:12
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_MON_ACT_WOFFSET                        0x0
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_MON_ACT_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_MON_ACT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_MON_ACT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_MON_ACT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_CACHE2_MON_ACT_INACTIVE                       _MK_ENUM_CONST(0)    // // 0 = inactive

#define STAT_MON_GLB_INT_STATUS_0_CACHE2_MON_ACT_ACTIVE                 _MK_ENUM_CONST(1)

// Rsvd
#define STAT_MON_GLB_INT_STATUS_0_N_A1_SHIFT                    _MK_SHIFT_CONST(11)
#define STAT_MON_GLB_INT_STATUS_0_N_A1_FIELD                    (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_N_A1_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_N_A1_RANGE                    11:11
#define STAT_MON_GLB_INT_STATUS_0_N_A1_WOFFSET                  0x0
#define STAT_MON_GLB_INT_STATUS_0_N_A1_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_N_A1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_N_A1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_N_A1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// 0 = inactive. 1 = active
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_MON_ACT_SHIFT                   _MK_SHIFT_CONST(10)
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_MON_ACT_FIELD                   (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_VPIPE_MON_ACT_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_MON_ACT_RANGE                   10:10
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_MON_ACT_WOFFSET                 0x0
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_MON_ACT_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_MON_ACT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_MON_ACT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_MON_ACT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_VPIPE_MON_ACT_INACTIVE                        _MK_ENUM_CONST(0)    // // 0 = inactive

#define STAT_MON_GLB_INT_STATUS_0_VPIPE_MON_ACT_ACTIVE                  _MK_ENUM_CONST(1)

// 0 = inactive. 1 = active
#define STAT_MON_GLB_INT_STATUS_0_AHB_MON_ACT_SHIFT                     _MK_SHIFT_CONST(9)
#define STAT_MON_GLB_INT_STATUS_0_AHB_MON_ACT_FIELD                     (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_AHB_MON_ACT_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_AHB_MON_ACT_RANGE                     9:9
#define STAT_MON_GLB_INT_STATUS_0_AHB_MON_ACT_WOFFSET                   0x0
#define STAT_MON_GLB_INT_STATUS_0_AHB_MON_ACT_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_AHB_MON_ACT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_AHB_MON_ACT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_AHB_MON_ACT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_AHB_MON_ACT_INACTIVE                  _MK_ENUM_CONST(0)    // // 0 = inactive

#define STAT_MON_GLB_INT_STATUS_0_AHB_MON_ACT_ACTIVE                    _MK_ENUM_CONST(1)

// 0 = inactive. 1 = active
#define STAT_MON_GLB_INT_STATUS_0_APB_MON_ACT_SHIFT                     _MK_SHIFT_CONST(8)
#define STAT_MON_GLB_INT_STATUS_0_APB_MON_ACT_FIELD                     (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_APB_MON_ACT_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_APB_MON_ACT_RANGE                     8:8
#define STAT_MON_GLB_INT_STATUS_0_APB_MON_ACT_WOFFSET                   0x0
#define STAT_MON_GLB_INT_STATUS_0_APB_MON_ACT_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_APB_MON_ACT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_APB_MON_ACT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_APB_MON_ACT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_APB_MON_ACT_INACTIVE                  _MK_ENUM_CONST(0)    // // 0 = inactive

#define STAT_MON_GLB_INT_STATUS_0_APB_MON_ACT_ACTIVE                    _MK_ENUM_CONST(1)

// 0 = inactive. 1 = active
#define STAT_MON_GLB_INT_STATUS_0_SMP_MON_ACT_SHIFT                     _MK_SHIFT_CONST(7)
#define STAT_MON_GLB_INT_STATUS_0_SMP_MON_ACT_FIELD                     (_MK_MASK_CONST(0x1) << STAT_MON_GLB_INT_STATUS_0_SMP_MON_ACT_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_SMP_MON_ACT_RANGE                     7:7
#define STAT_MON_GLB_INT_STATUS_0_SMP_MON_ACT_WOFFSET                   0x0
#define STAT_MON_GLB_INT_STATUS_0_SMP_MON_ACT_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_SMP_MON_ACT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define STAT_MON_GLB_INT_STATUS_0_SMP_MON_ACT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_SMP_MON_ACT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_SMP_MON_ACT_INACTIVE                  _MK_ENUM_CONST(0)    // // 0 = inactive

#define STAT_MON_GLB_INT_STATUS_0_SMP_MON_ACT_ACTIVE                    _MK_ENUM_CONST(1)

// Rsvd
#define STAT_MON_GLB_INT_STATUS_0_N_A0_SHIFT                    _MK_SHIFT_CONST(0)
#define STAT_MON_GLB_INT_STATUS_0_N_A0_FIELD                    (_MK_MASK_CONST(0x7f) << STAT_MON_GLB_INT_STATUS_0_N_A0_SHIFT)
#define STAT_MON_GLB_INT_STATUS_0_N_A0_RANGE                    6:0
#define STAT_MON_GLB_INT_STATUS_0_N_A0_WOFFSET                  0x0
#define STAT_MON_GLB_INT_STATUS_0_N_A0_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_N_A0_DEFAULT_MASK                     _MK_MASK_CONST(0x7f)
#define STAT_MON_GLB_INT_STATUS_0_N_A0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_GLB_INT_STATUS_0_N_A0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Reserved address 4 [0x4] 

// Reserved address 8 [0x8] 

// Reserved address 12 [0xc] 

// Reserved address 16 [0x10] 

// Reserved address 20 [0x14] 

// Reserved address 24 [0x18] 

// Reserved address 28 [0x1c] 

// Reserved address 32 [0x20] 

// Reserved address 36 [0x24] 

// Reserved address 40 [0x28] 

// Reserved address 44 [0x2c] 

// Reserved address 48 [0x30] 

// Reserved address 52 [0x34] 

// Reserved address 56 [0x38] 

// Reserved address 60 [0x3c] 

// Reserved address 64 [0x40] 

// Reserved address 68 [0x44] 

// Reserved address 72 [0x48] 

// Reserved address 76 [0x4c] 

// Reserved address 80 [0x50] 

// Reserved address 84 [0x54] 

// Reserved address 88 [0x58] 

// Reserved address 92 [0x5c] 

// Reserved address 96 [0x60] 

// Reserved address 100 [0x64] 

// Reserved address 104 [0x68] 

// Reserved address 108 [0x6c] 

// Reserved address 112 [0x70] 

// Reserved address 116 [0x74] 

// Reserved address 120 [0x78] 

// Reserved address 124 [0x7c] 

// Reserved address 128 [0x80] 

// Reserved address 132 [0x84] 

// Reserved address 136 [0x88] 

// Reserved address 140 [0x8c] 

// Reserved address 144 [0x90] 

// Reserved address 148 [0x94] 

// Reserved address 152 [0x98] 

// Reserved address 156 [0x9c] 

// Reserved address 160 [0xa0] 

// Reserved address 164 [0xa4] 

// Reserved address 168 [0xa8] 

// Reserved address 172 [0xac] 

// Reserved address 176 [0xb0] 

// Reserved address 180 [0xb4] 

// Reserved address 184 [0xb8] 

// Reserved address 188 [0xbc] 

// Reserved address 192 [0xc0] 

// Reserved address 196 [0xc4] 

// Reserved address 200 [0xc8] 

// Reserved address 204 [0xcc] 

// Reserved address 208 [0xd0] 

// Reserved address 212 [0xd4] 

// Reserved address 216 [0xd8] 

// Reserved address 220 [0xdc] 

// Reserved address 224 [0xe0] 

// Reserved address 228 [0xe4] 

// Reserved address 232 [0xe8] 

// Reserved address 236 [0xec] 

// Reserved address 240 [0xf0] 

// Reserved address 244 [0xf4] 

// Reserved address 248 [0xf8] 

// Reserved address 252 [0xfc] 

// Register STAT_MON_CPU_MON_CTRL_0  
#define STAT_MON_CPU_MON_CTRL_0                 _MK_ADDR_CONST(0x100)
#define STAT_MON_CPU_MON_CTRL_0_WORD_COUNT                      0x1
#define STAT_MON_CPU_MON_CTRL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define STAT_MON_CPU_MON_CTRL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define STAT_MON_CPU_MON_CTRL_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Enable Monitor. Set by SW to enable sampling. cpu monitor is enabled.
// Cleared in one of the following ways,
// (a) When SW intends to stop the  monitor, it can do so by clearing this field,
// (b) when the sampling period  expires, or
// (c) in case of indefinite sampling mode, 
// the field is cleared  when the statistic counter overflows.
#define STAT_MON_CPU_MON_CTRL_0_ENB_SHIFT                       _MK_SHIFT_CONST(31)
#define STAT_MON_CPU_MON_CTRL_0_ENB_FIELD                       (_MK_MASK_CONST(0x1) << STAT_MON_CPU_MON_CTRL_0_ENB_SHIFT)
#define STAT_MON_CPU_MON_CTRL_0_ENB_RANGE                       31:31
#define STAT_MON_CPU_MON_CTRL_0_ENB_WOFFSET                     0x0
#define STAT_MON_CPU_MON_CTRL_0_ENB_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_ENB_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define STAT_MON_CPU_MON_CTRL_0_ENB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_ENB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_ENB_DISABLE                     _MK_ENUM_CONST(0)    // // cpu monitor is disabled.     

#define STAT_MON_CPU_MON_CTRL_0_ENB_ENABLE                      _MK_ENUM_CONST(1)

// Enable interrupt when sampling period expires. interrupt is enabled.
#define STAT_MON_CPU_MON_CTRL_0_INT_EN_SHIFT                    _MK_SHIFT_CONST(30)
#define STAT_MON_CPU_MON_CTRL_0_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << STAT_MON_CPU_MON_CTRL_0_INT_EN_SHIFT)
#define STAT_MON_CPU_MON_CTRL_0_INT_EN_RANGE                    30:30
#define STAT_MON_CPU_MON_CTRL_0_INT_EN_WOFFSET                  0x0
#define STAT_MON_CPU_MON_CTRL_0_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define STAT_MON_CPU_MON_CTRL_0_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_INT_EN_DISABLE                  _MK_ENUM_CONST(0)    // // interrupt is disabled.     

#define STAT_MON_CPU_MON_CTRL_0_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

// Assert by HW when sampling period expires when  INT_EN is set. 1 = interrupt detected
// SW writing a 1 clears this bit. Writing 0 is ignored.
#define STAT_MON_CPU_MON_CTRL_0_INT_SHIFT                       _MK_SHIFT_CONST(29)
#define STAT_MON_CPU_MON_CTRL_0_INT_FIELD                       (_MK_MASK_CONST(0x1) << STAT_MON_CPU_MON_CTRL_0_INT_SHIFT)
#define STAT_MON_CPU_MON_CTRL_0_INT_RANGE                       29:29
#define STAT_MON_CPU_MON_CTRL_0_INT_WOFFSET                     0x0
#define STAT_MON_CPU_MON_CTRL_0_INT_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_INT_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define STAT_MON_CPU_MON_CTRL_0_INT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_INT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_INT_NOINT                       _MK_ENUM_CONST(0)    // // 0 = interrupt not detected

#define STAT_MON_CPU_MON_CTRL_0_INT_INT                 _MK_ENUM_CONST(1)

// 0 = sample only for the period mentioned in  SAMPLE_PERIOD. sample mode is enabled.
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_MODE_SHIFT                       _MK_SHIFT_CONST(28)
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_MODE_FIELD                       (_MK_MASK_CONST(0x1) << STAT_MON_CPU_MON_CTRL_0_SAMPLE_MODE_SHIFT)
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_MODE_RANGE                       28:28
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_MODE_WOFFSET                     0x0
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_MODE_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_MODE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_MODE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_MODE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_MODE_DISABLE                     _MK_ENUM_CONST(0)    // // sample mode is disabled.     

#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_MODE_ENABLE                      _MK_ENUM_CONST(1)

// Sampling period in milliseconds (implemented as  n+1 counter).
// Programming a 0 imply a 1 millisecond sampling period.
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_PERIOD_SHIFT                     _MK_SHIFT_CONST(20)
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_PERIOD_FIELD                     (_MK_MASK_CONST(0xff) << STAT_MON_CPU_MON_CTRL_0_SAMPLE_PERIOD_SHIFT)
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_PERIOD_RANGE                     27:20
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_PERIOD_WOFFSET                   0x0
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_PERIOD_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_PERIOD_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_PERIOD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_PERIOD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Reserved
#define STAT_MON_CPU_MON_CTRL_0_N_A_SHIFT                       _MK_SHIFT_CONST(4)
#define STAT_MON_CPU_MON_CTRL_0_N_A_FIELD                       (_MK_MASK_CONST(0xffff) << STAT_MON_CPU_MON_CTRL_0_N_A_SHIFT)
#define STAT_MON_CPU_MON_CTRL_0_N_A_RANGE                       19:4
#define STAT_MON_CPU_MON_CTRL_0_N_A_WOFFSET                     0x0
#define STAT_MON_CPU_MON_CTRL_0_N_A_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_N_A_DEFAULT_MASK                        _MK_MASK_CONST(0xffff)
#define STAT_MON_CPU_MON_CTRL_0_N_A_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_N_A_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 4b0000 = automatically detect CPU idle  condition.
// Idle is defined as the period when the halt bit to the 
// processor is asserted in the flow controller.
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_COND_SHIFT                       _MK_SHIFT_CONST(0)
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_COND_FIELD                       (_MK_MASK_CONST(0xf) << STAT_MON_CPU_MON_CTRL_0_SAMPLE_COND_SHIFT)
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_COND_RANGE                       3:0
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_COND_WOFFSET                     0x0
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_COND_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_COND_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_COND_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_CTRL_0_SAMPLE_COND_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register STAT_MON_CPU_MON_STATUS_0  
#define STAT_MON_CPU_MON_STATUS_0                       _MK_ADDR_CONST(0x104)
#define STAT_MON_CPU_MON_STATUS_0_WORD_COUNT                    0x1
#define STAT_MON_CPU_MON_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_CPU_MON_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_STATUS_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define STAT_MON_CPU_MON_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Indicates the number of idle cycles.
// A value of  FFFF:FFFF is an overflow condition.
// If the counter hits this value, it does  not increment from here.
// This counter is always reset when the monitor is  enabled the next time.
#define STAT_MON_CPU_MON_STATUS_0_COUNT_SHIFT                   _MK_SHIFT_CONST(0)
#define STAT_MON_CPU_MON_STATUS_0_COUNT_FIELD                   (_MK_MASK_CONST(0xffffffff) << STAT_MON_CPU_MON_STATUS_0_COUNT_SHIFT)
#define STAT_MON_CPU_MON_STATUS_0_COUNT_RANGE                   31:0
#define STAT_MON_CPU_MON_STATUS_0_COUNT_WOFFSET                 0x0
#define STAT_MON_CPU_MON_STATUS_0_COUNT_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_STATUS_0_COUNT_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_CPU_MON_STATUS_0_COUNT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_CPU_MON_STATUS_0_COUNT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Reserved address 264 [0x108] 

// Reserved address 268 [0x10c] 

// Reserved address 272 [0x110] 

// Reserved address 276 [0x114] 

// Reserved address 280 [0x118] 

// Reserved address 284 [0x11c] 

// Register STAT_MON_COP_MON_CTRL_0  
#define STAT_MON_COP_MON_CTRL_0                 _MK_ADDR_CONST(0x120)
#define STAT_MON_COP_MON_CTRL_0_WORD_COUNT                      0x1
#define STAT_MON_COP_MON_CTRL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define STAT_MON_COP_MON_CTRL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define STAT_MON_COP_MON_CTRL_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Enable Monitor. Set by SW to enable sampling. cop monitor is enabled.
// Cleared in one of the following ways, 
// (a) When SW intends to stop the  monitor, it can do so by clearing this field, 
// (b) when the sampling period  expires, or
// (c) in case of indefinite sampling mode, the field is cleared
// when the statistic counter overflows.
#define STAT_MON_COP_MON_CTRL_0_ENB_SHIFT                       _MK_SHIFT_CONST(31)
#define STAT_MON_COP_MON_CTRL_0_ENB_FIELD                       (_MK_MASK_CONST(0x1) << STAT_MON_COP_MON_CTRL_0_ENB_SHIFT)
#define STAT_MON_COP_MON_CTRL_0_ENB_RANGE                       31:31
#define STAT_MON_COP_MON_CTRL_0_ENB_WOFFSET                     0x0
#define STAT_MON_COP_MON_CTRL_0_ENB_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_ENB_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define STAT_MON_COP_MON_CTRL_0_ENB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_ENB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_ENB_DISABLE                     _MK_ENUM_CONST(0)    // // cop monitor is disabled.     

#define STAT_MON_COP_MON_CTRL_0_ENB_ENABLE                      _MK_ENUM_CONST(1)

// Enable interrupt when sampling period expires. interrupt is enabled.
#define STAT_MON_COP_MON_CTRL_0_INT_EN_SHIFT                    _MK_SHIFT_CONST(30)
#define STAT_MON_COP_MON_CTRL_0_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << STAT_MON_COP_MON_CTRL_0_INT_EN_SHIFT)
#define STAT_MON_COP_MON_CTRL_0_INT_EN_RANGE                    30:30
#define STAT_MON_COP_MON_CTRL_0_INT_EN_WOFFSET                  0x0
#define STAT_MON_COP_MON_CTRL_0_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define STAT_MON_COP_MON_CTRL_0_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_INT_EN_DISABLE                  _MK_ENUM_CONST(0)    // // interrupt is disabled.     

#define STAT_MON_COP_MON_CTRL_0_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

// Assert by HW when sampling period expires when  INT_EN is set. 1 = interrupt detected
// SW writing a 1 clears this bit. Writing 0 is ignored.
#define STAT_MON_COP_MON_CTRL_0_INT_SHIFT                       _MK_SHIFT_CONST(29)
#define STAT_MON_COP_MON_CTRL_0_INT_FIELD                       (_MK_MASK_CONST(0x1) << STAT_MON_COP_MON_CTRL_0_INT_SHIFT)
#define STAT_MON_COP_MON_CTRL_0_INT_RANGE                       29:29
#define STAT_MON_COP_MON_CTRL_0_INT_WOFFSET                     0x0
#define STAT_MON_COP_MON_CTRL_0_INT_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_INT_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define STAT_MON_COP_MON_CTRL_0_INT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_INT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_INT_NOINT                       _MK_ENUM_CONST(0)    // // 0 = interrupt not detected

#define STAT_MON_COP_MON_CTRL_0_INT_INT                 _MK_ENUM_CONST(1)

// 0 = sample only for the period mentioned in  SAMPLE_PERIOD. sample mode is enabled.
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_MODE_SHIFT                       _MK_SHIFT_CONST(28)
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_MODE_FIELD                       (_MK_MASK_CONST(0x1) << STAT_MON_COP_MON_CTRL_0_SAMPLE_MODE_SHIFT)
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_MODE_RANGE                       28:28
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_MODE_WOFFSET                     0x0
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_MODE_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_MODE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_MODE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_MODE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_MODE_DISABLE                     _MK_ENUM_CONST(0)    // // sample mode is disabled.     

#define STAT_MON_COP_MON_CTRL_0_SAMPLE_MODE_ENABLE                      _MK_ENUM_CONST(1)

// Sampling period in milliseconds (implemented as  n+1 counter).
// Programming a 0 imply a 1 millisecond sampling period.
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_PERIOD_SHIFT                     _MK_SHIFT_CONST(20)
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_PERIOD_FIELD                     (_MK_MASK_CONST(0xff) << STAT_MON_COP_MON_CTRL_0_SAMPLE_PERIOD_SHIFT)
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_PERIOD_RANGE                     27:20
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_PERIOD_WOFFSET                   0x0
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_PERIOD_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_PERIOD_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_PERIOD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_PERIOD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Reserved
#define STAT_MON_COP_MON_CTRL_0_N_A_SHIFT                       _MK_SHIFT_CONST(4)
#define STAT_MON_COP_MON_CTRL_0_N_A_FIELD                       (_MK_MASK_CONST(0xffff) << STAT_MON_COP_MON_CTRL_0_N_A_SHIFT)
#define STAT_MON_COP_MON_CTRL_0_N_A_RANGE                       19:4
#define STAT_MON_COP_MON_CTRL_0_N_A_WOFFSET                     0x0
#define STAT_MON_COP_MON_CTRL_0_N_A_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_N_A_DEFAULT_MASK                        _MK_MASK_CONST(0xffff)
#define STAT_MON_COP_MON_CTRL_0_N_A_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_N_A_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 4b0000 = automatically detect COP idle  condition.
// Idle is defined as the period when the halt bit to the 
// processor is asserted in the flow controller.
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_COND_SHIFT                       _MK_SHIFT_CONST(0)
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_COND_FIELD                       (_MK_MASK_CONST(0xf) << STAT_MON_COP_MON_CTRL_0_SAMPLE_COND_SHIFT)
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_COND_RANGE                       3:0
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_COND_WOFFSET                     0x0
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_COND_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_COND_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_COND_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_CTRL_0_SAMPLE_COND_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register STAT_MON_COP_MON_STATUS_0  
#define STAT_MON_COP_MON_STATUS_0                       _MK_ADDR_CONST(0x124)
#define STAT_MON_COP_MON_STATUS_0_WORD_COUNT                    0x1
#define STAT_MON_COP_MON_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_COP_MON_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_STATUS_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define STAT_MON_COP_MON_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Indicates the number of idle cycles.
// A value of  FFFF:FFFF is an overflow condition.
// If the counter hits this value, it does  not increment from here. 
// This counter is always reset when the monitor is  enabled the next time.
#define STAT_MON_COP_MON_STATUS_0_COUNT_SHIFT                   _MK_SHIFT_CONST(0)
#define STAT_MON_COP_MON_STATUS_0_COUNT_FIELD                   (_MK_MASK_CONST(0xffffffff) << STAT_MON_COP_MON_STATUS_0_COUNT_SHIFT)
#define STAT_MON_COP_MON_STATUS_0_COUNT_RANGE                   31:0
#define STAT_MON_COP_MON_STATUS_0_COUNT_WOFFSET                 0x0
#define STAT_MON_COP_MON_STATUS_0_COUNT_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_STATUS_0_COUNT_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_COP_MON_STATUS_0_COUNT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_COP_MON_STATUS_0_COUNT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Reserved address 296 [0x128] 

// Reserved address 300 [0x12c] 

// Reserved address 304 [0x130] 

// Reserved address 308 [0x134] 

// Reserved address 312 [0x138] 

// Reserved address 316 [0x13c] 

// Reserved address 320 [0x140] 

// Reserved address 324 [0x144] 

// Reserved address 328 [0x148] 

// Reserved address 332 [0x14c] 

// Reserved address 336 [0x150] 

// Reserved address 340 [0x154] 

// Reserved address 344 [0x158] 

// Reserved address 348 [0x15c] 

// Register STAT_MON_CACHE2_MON_CTRL_0  
#define STAT_MON_CACHE2_MON_CTRL_0                      _MK_ADDR_CONST(0x160)
#define STAT_MON_CACHE2_MON_CTRL_0_WORD_COUNT                   0x1
#define STAT_MON_CACHE2_MON_CTRL_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define STAT_MON_CACHE2_MON_CTRL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_CACHE2_MON_CTRL_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
// Enable Monitor. Set by SW to enable sampling.  cache2 monitor is enabled.
// Cleared in one of the following ways,
// (a) When SW intends to stop the  monitor, it can do so by clearing this field, or
// (b) when the sampling period  expires.
#define STAT_MON_CACHE2_MON_CTRL_0_ENB_SHIFT                    _MK_SHIFT_CONST(31)
#define STAT_MON_CACHE2_MON_CTRL_0_ENB_FIELD                    (_MK_MASK_CONST(0x1) << STAT_MON_CACHE2_MON_CTRL_0_ENB_SHIFT)
#define STAT_MON_CACHE2_MON_CTRL_0_ENB_RANGE                    31:31
#define STAT_MON_CACHE2_MON_CTRL_0_ENB_WOFFSET                  0x0
#define STAT_MON_CACHE2_MON_CTRL_0_ENB_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_ENB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define STAT_MON_CACHE2_MON_CTRL_0_ENB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_ENB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_ENB_DISABLE                  _MK_ENUM_CONST(0)    // // cache2 monitor is disabled.     

#define STAT_MON_CACHE2_MON_CTRL_0_ENB_ENABLE                   _MK_ENUM_CONST(1)

// Enable interrupt when sampling period expires. interrupt is enabled.
#define STAT_MON_CACHE2_MON_CTRL_0_INT_EN_SHIFT                 _MK_SHIFT_CONST(30)
#define STAT_MON_CACHE2_MON_CTRL_0_INT_EN_FIELD                 (_MK_MASK_CONST(0x1) << STAT_MON_CACHE2_MON_CTRL_0_INT_EN_SHIFT)
#define STAT_MON_CACHE2_MON_CTRL_0_INT_EN_RANGE                 30:30
#define STAT_MON_CACHE2_MON_CTRL_0_INT_EN_WOFFSET                       0x0
#define STAT_MON_CACHE2_MON_CTRL_0_INT_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_INT_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define STAT_MON_CACHE2_MON_CTRL_0_INT_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_INT_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_INT_EN_DISABLE                       _MK_ENUM_CONST(0)    // // interrupt is disabled.     

#define STAT_MON_CACHE2_MON_CTRL_0_INT_EN_ENABLE                        _MK_ENUM_CONST(1)

// Assert by HW when sampling period expires when  INT_EN is set. 1 = interrupt detected
// SW writing a 1 clears this bit. Writing 0 is ignored.
#define STAT_MON_CACHE2_MON_CTRL_0_INT_SHIFT                    _MK_SHIFT_CONST(29)
#define STAT_MON_CACHE2_MON_CTRL_0_INT_FIELD                    (_MK_MASK_CONST(0x1) << STAT_MON_CACHE2_MON_CTRL_0_INT_SHIFT)
#define STAT_MON_CACHE2_MON_CTRL_0_INT_RANGE                    29:29
#define STAT_MON_CACHE2_MON_CTRL_0_INT_WOFFSET                  0x0
#define STAT_MON_CACHE2_MON_CTRL_0_INT_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_INT_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define STAT_MON_CACHE2_MON_CTRL_0_INT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_INT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_INT_NOINT                    _MK_ENUM_CONST(0)    // // 0 = interrupt not detected

#define STAT_MON_CACHE2_MON_CTRL_0_INT_INT                      _MK_ENUM_CONST(1)

// 0 = sample only for the period mentioned in  SAMPLE_PERIOD. sample mode is enabled.
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_MODE_SHIFT                    _MK_SHIFT_CONST(28)
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_MODE_FIELD                    (_MK_MASK_CONST(0x1) << STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_MODE_SHIFT)
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_MODE_RANGE                    28:28
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_MODE_WOFFSET                  0x0
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_MODE_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_MODE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_MODE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_MODE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_MODE_DISABLE                  _MK_ENUM_CONST(0)    // // sample mode is disabled.     

#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_MODE_ENABLE                   _MK_ENUM_CONST(1)

// Sampling period in milliseconds (implemented as  n+1 counter).
// Programming a 0 imply a 1 millisecond sampling period.
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_PERIOD_SHIFT                  _MK_SHIFT_CONST(20)
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_PERIOD_FIELD                  (_MK_MASK_CONST(0xff) << STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_PERIOD_SHIFT)
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_PERIOD_RANGE                  27:20
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_PERIOD_WOFFSET                        0x0
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_PERIOD_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_PERIOD_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_PERIOD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_PERIOD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Reserved
#define STAT_MON_CACHE2_MON_CTRL_0_N_A_SHIFT                    _MK_SHIFT_CONST(4)
#define STAT_MON_CACHE2_MON_CTRL_0_N_A_FIELD                    (_MK_MASK_CONST(0xffff) << STAT_MON_CACHE2_MON_CTRL_0_N_A_SHIFT)
#define STAT_MON_CACHE2_MON_CTRL_0_N_A_RANGE                    19:4
#define STAT_MON_CACHE2_MON_CTRL_0_N_A_WOFFSET                  0x0
#define STAT_MON_CACHE2_MON_CTRL_0_N_A_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_N_A_DEFAULT_MASK                     _MK_MASK_CONST(0xffff)
#define STAT_MON_CACHE2_MON_CTRL_0_N_A_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_N_A_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// 4b0010 = calculate hit/miss for cacheable data  only.
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_COND_SHIFT                    _MK_SHIFT_CONST(0)
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_COND_FIELD                    (_MK_MASK_CONST(0xf) << STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_COND_SHIFT)
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_COND_RANGE                    3:0
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_COND_WOFFSET                  0x0
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_COND_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_COND_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_COND_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_MON_CTRL_0_SAMPLE_COND_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register STAT_MON_CACHE2_REQ_STATUS_0  
#define STAT_MON_CACHE2_REQ_STATUS_0                    _MK_ADDR_CONST(0x164)
#define STAT_MON_CACHE2_REQ_STATUS_0_WORD_COUNT                         0x1
#define STAT_MON_CACHE2_REQ_STATUS_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_REQ_STATUS_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define STAT_MON_CACHE2_REQ_STATUS_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_REQ_STATUS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_REQ_STATUS_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define STAT_MON_CACHE2_REQ_STATUS_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
// Number of cacheable requests from COP during the  sampling period.
#define STAT_MON_CACHE2_REQ_STATUS_0_COUNT_SHIFT                        _MK_SHIFT_CONST(0)
#define STAT_MON_CACHE2_REQ_STATUS_0_COUNT_FIELD                        (_MK_MASK_CONST(0xffffffff) << STAT_MON_CACHE2_REQ_STATUS_0_COUNT_SHIFT)
#define STAT_MON_CACHE2_REQ_STATUS_0_COUNT_RANGE                        31:0
#define STAT_MON_CACHE2_REQ_STATUS_0_COUNT_WOFFSET                      0x0
#define STAT_MON_CACHE2_REQ_STATUS_0_COUNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_REQ_STATUS_0_COUNT_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define STAT_MON_CACHE2_REQ_STATUS_0_COUNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_REQ_STATUS_0_COUNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register STAT_MON_CACHE2_HIT_STATUS_0  
#define STAT_MON_CACHE2_HIT_STATUS_0                    _MK_ADDR_CONST(0x168)
#define STAT_MON_CACHE2_HIT_STATUS_0_WORD_COUNT                         0x1
#define STAT_MON_CACHE2_HIT_STATUS_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_HIT_STATUS_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define STAT_MON_CACHE2_HIT_STATUS_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_HIT_STATUS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_HIT_STATUS_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define STAT_MON_CACHE2_HIT_STATUS_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
// Number of cacheable requests that were hit during  the sampling period.
#define STAT_MON_CACHE2_HIT_STATUS_0_COUNT_SHIFT                        _MK_SHIFT_CONST(0)
#define STAT_MON_CACHE2_HIT_STATUS_0_COUNT_FIELD                        (_MK_MASK_CONST(0xffffffff) << STAT_MON_CACHE2_HIT_STATUS_0_COUNT_SHIFT)
#define STAT_MON_CACHE2_HIT_STATUS_0_COUNT_RANGE                        31:0
#define STAT_MON_CACHE2_HIT_STATUS_0_COUNT_WOFFSET                      0x0
#define STAT_MON_CACHE2_HIT_STATUS_0_COUNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_HIT_STATUS_0_COUNT_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define STAT_MON_CACHE2_HIT_STATUS_0_COUNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_CACHE2_HIT_STATUS_0_COUNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Reserved address 364 [0x16c] 

// Reserved address 368 [0x170] 

// Reserved address 372 [0x174] 

// Reserved address 376 [0x178] 

// Reserved address 380 [0x17c] 

// Register STAT_MON_AHB_MON_CTRL_0  
#define STAT_MON_AHB_MON_CTRL_0                 _MK_ADDR_CONST(0x180)
#define STAT_MON_AHB_MON_CTRL_0_WORD_COUNT                      0x1
#define STAT_MON_AHB_MON_CTRL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define STAT_MON_AHB_MON_CTRL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define STAT_MON_AHB_MON_CTRL_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Enable Monitor. Set by SW to enable sampling.  Cleared when the sampling period expires. AHB monitor is enabled.
#define STAT_MON_AHB_MON_CTRL_0_ENB_SHIFT                       _MK_SHIFT_CONST(31)
#define STAT_MON_AHB_MON_CTRL_0_ENB_FIELD                       (_MK_MASK_CONST(0x1) << STAT_MON_AHB_MON_CTRL_0_ENB_SHIFT)
#define STAT_MON_AHB_MON_CTRL_0_ENB_RANGE                       31:31
#define STAT_MON_AHB_MON_CTRL_0_ENB_WOFFSET                     0x0
#define STAT_MON_AHB_MON_CTRL_0_ENB_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_ENB_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define STAT_MON_AHB_MON_CTRL_0_ENB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_ENB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_ENB_DISABLE                     _MK_ENUM_CONST(0)    // // AHB monitor is disabled.     

#define STAT_MON_AHB_MON_CTRL_0_ENB_ENABLE                      _MK_ENUM_CONST(1)

// Enable interrupt. interrupt is enabled.
#define STAT_MON_AHB_MON_CTRL_0_INT_EN_SHIFT                    _MK_SHIFT_CONST(30)
#define STAT_MON_AHB_MON_CTRL_0_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << STAT_MON_AHB_MON_CTRL_0_INT_EN_SHIFT)
#define STAT_MON_AHB_MON_CTRL_0_INT_EN_RANGE                    30:30
#define STAT_MON_AHB_MON_CTRL_0_INT_EN_WOFFSET                  0x0
#define STAT_MON_AHB_MON_CTRL_0_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define STAT_MON_AHB_MON_CTRL_0_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_EN_DISABLE                  _MK_ENUM_CONST(0)    // // interrupt is disabled.     

#define STAT_MON_AHB_MON_CTRL_0_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

// Assert by HW when sampling period expires when  INT_EN is set. 1 = interrupt detected
// SW writing a 1 clears this bit. Writing 0 is ignored.
#define STAT_MON_AHB_MON_CTRL_0_INT_SHIFT                       _MK_SHIFT_CONST(29)
#define STAT_MON_AHB_MON_CTRL_0_INT_FIELD                       (_MK_MASK_CONST(0x1) << STAT_MON_AHB_MON_CTRL_0_INT_SHIFT)
#define STAT_MON_AHB_MON_CTRL_0_INT_RANGE                       29:29
#define STAT_MON_AHB_MON_CTRL_0_INT_WOFFSET                     0x0
#define STAT_MON_AHB_MON_CTRL_0_INT_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define STAT_MON_AHB_MON_CTRL_0_INT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_NOINT                       _MK_ENUM_CONST(0)    // // 0 = interrupt not detected

#define STAT_MON_AHB_MON_CTRL_0_INT_INT                 _MK_ENUM_CONST(1)

// 0 = sample only for the period mentioned in  SAMPLE_PERIOD. sample mode is enabled.
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_MODE_SHIFT                       _MK_SHIFT_CONST(28)
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_MODE_FIELD                       (_MK_MASK_CONST(0x1) << STAT_MON_AHB_MON_CTRL_0_SAMPLE_MODE_SHIFT)
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_MODE_RANGE                       28:28
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_MODE_WOFFSET                     0x0
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_MODE_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_MODE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_MODE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_MODE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_MODE_DISABLE                     _MK_ENUM_CONST(0)    // // sample mode is disabled.     

#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_MODE_ENABLE                      _MK_ENUM_CONST(1)

// Sampling period in milliseconds (implemented as  n+1 counter).
// Programming a 0 imply a 1 millisecond sampling period.
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_PERIOD_SHIFT                     _MK_SHIFT_CONST(20)
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_PERIOD_FIELD                     (_MK_MASK_CONST(0xff) << STAT_MON_AHB_MON_CTRL_0_SAMPLE_PERIOD_SHIFT)
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_PERIOD_RANGE                     27:20
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_PERIOD_WOFFSET                   0x0
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_PERIOD_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_PERIOD_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_PERIOD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_PERIOD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Enable periodic mode. periodic mode is enabled.
#define STAT_MON_AHB_MON_CTRL_0_ENB_PERIODIC_SHIFT                      _MK_SHIFT_CONST(19)
#define STAT_MON_AHB_MON_CTRL_0_ENB_PERIODIC_FIELD                      (_MK_MASK_CONST(0x1) << STAT_MON_AHB_MON_CTRL_0_ENB_PERIODIC_SHIFT)
#define STAT_MON_AHB_MON_CTRL_0_ENB_PERIODIC_RANGE                      19:19
#define STAT_MON_AHB_MON_CTRL_0_ENB_PERIODIC_WOFFSET                    0x0
#define STAT_MON_AHB_MON_CTRL_0_ENB_PERIODIC_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_ENB_PERIODIC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define STAT_MON_AHB_MON_CTRL_0_ENB_PERIODIC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_ENB_PERIODIC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_ENB_PERIODIC_DISABLE                    _MK_ENUM_CONST(0)    // // periodic mode is disabled.     

#define STAT_MON_AHB_MON_CTRL_0_ENB_PERIODIC_ENABLE                     _MK_ENUM_CONST(1)

// 
#define STAT_MON_AHB_MON_CTRL_0_N_A1_SHIFT                      _MK_SHIFT_CONST(16)
#define STAT_MON_AHB_MON_CTRL_0_N_A1_FIELD                      (_MK_MASK_CONST(0x7) << STAT_MON_AHB_MON_CTRL_0_N_A1_SHIFT)
#define STAT_MON_AHB_MON_CTRL_0_N_A1_RANGE                      18:16
#define STAT_MON_AHB_MON_CTRL_0_N_A1_WOFFSET                    0x0
#define STAT_MON_AHB_MON_CTRL_0_N_A1_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_N_A1_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define STAT_MON_AHB_MON_CTRL_0_N_A1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_N_A1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Interrupt always at end of sample period. interrupt is enabled.
#define STAT_MON_AHB_MON_CTRL_0_INT_AT_END_SHIFT                        _MK_SHIFT_CONST(15)
#define STAT_MON_AHB_MON_CTRL_0_INT_AT_END_FIELD                        (_MK_MASK_CONST(0x1) << STAT_MON_AHB_MON_CTRL_0_INT_AT_END_SHIFT)
#define STAT_MON_AHB_MON_CTRL_0_INT_AT_END_RANGE                        15:15
#define STAT_MON_AHB_MON_CTRL_0_INT_AT_END_WOFFSET                      0x0
#define STAT_MON_AHB_MON_CTRL_0_INT_AT_END_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_AT_END_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define STAT_MON_AHB_MON_CTRL_0_INT_AT_END_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_AT_END_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_AT_END_DISABLE                      _MK_ENUM_CONST(0)    // // interrupt is disabled.     

#define STAT_MON_AHB_MON_CTRL_0_INT_AT_END_ENABLE                       _MK_ENUM_CONST(1)

// Interrupt only if count is below the lower  watermark at the end of sample period. interrupt is enabled.
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_BELOW_WMARK_SHIFT                        _MK_SHIFT_CONST(14)
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_BELOW_WMARK_FIELD                        (_MK_MASK_CONST(0x1) << STAT_MON_AHB_MON_CTRL_0_INT_IF_BELOW_WMARK_SHIFT)
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_BELOW_WMARK_RANGE                        14:14
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_BELOW_WMARK_WOFFSET                      0x0
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_BELOW_WMARK_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_BELOW_WMARK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_BELOW_WMARK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_BELOW_WMARK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_BELOW_WMARK_DISABLE                      _MK_ENUM_CONST(0)    // // interrupt is disabled.     

#define STAT_MON_AHB_MON_CTRL_0_INT_IF_BELOW_WMARK_ENABLE                       _MK_ENUM_CONST(1)

// Interrupt only if count is above the upper  watermark at the end of sample period. interrupt is enabled.
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_ABOVE_WMARK_SHIFT                        _MK_SHIFT_CONST(13)
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_ABOVE_WMARK_FIELD                        (_MK_MASK_CONST(0x1) << STAT_MON_AHB_MON_CTRL_0_INT_IF_ABOVE_WMARK_SHIFT)
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_ABOVE_WMARK_RANGE                        13:13
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_ABOVE_WMARK_WOFFSET                      0x0
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_ABOVE_WMARK_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_ABOVE_WMARK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_ABOVE_WMARK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_ABOVE_WMARK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_IF_ABOVE_WMARK_DISABLE                      _MK_ENUM_CONST(0)    // // interrupt is disabled.     

#define STAT_MON_AHB_MON_CTRL_0_INT_IF_ABOVE_WMARK_ENABLE                       _MK_ENUM_CONST(1)

// Interrupt when count rolls over. interrupt is enabled.
#define STAT_MON_AHB_MON_CTRL_0_INT_WHEN_CNT_ROVER_SHIFT                        _MK_SHIFT_CONST(12)
#define STAT_MON_AHB_MON_CTRL_0_INT_WHEN_CNT_ROVER_FIELD                        (_MK_MASK_CONST(0x1) << STAT_MON_AHB_MON_CTRL_0_INT_WHEN_CNT_ROVER_SHIFT)
#define STAT_MON_AHB_MON_CTRL_0_INT_WHEN_CNT_ROVER_RANGE                        12:12
#define STAT_MON_AHB_MON_CTRL_0_INT_WHEN_CNT_ROVER_WOFFSET                      0x0
#define STAT_MON_AHB_MON_CTRL_0_INT_WHEN_CNT_ROVER_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_WHEN_CNT_ROVER_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define STAT_MON_AHB_MON_CTRL_0_INT_WHEN_CNT_ROVER_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_WHEN_CNT_ROVER_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_INT_WHEN_CNT_ROVER_DISABLE                      _MK_ENUM_CONST(0)    // // interrupt is disabled.     

#define STAT_MON_AHB_MON_CTRL_0_INT_WHEN_CNT_ROVER_ENABLE                       _MK_ENUM_CONST(1)

// Reserved
#define STAT_MON_AHB_MON_CTRL_0_N_A0_SHIFT                      _MK_SHIFT_CONST(9)
#define STAT_MON_AHB_MON_CTRL_0_N_A0_FIELD                      (_MK_MASK_CONST(0x7) << STAT_MON_AHB_MON_CTRL_0_N_A0_SHIFT)
#define STAT_MON_AHB_MON_CTRL_0_N_A0_RANGE                      11:9
#define STAT_MON_AHB_MON_CTRL_0_N_A0_WOFFSET                    0x0
#define STAT_MON_AHB_MON_CTRL_0_N_A0_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_N_A0_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define STAT_MON_AHB_MON_CTRL_0_N_A0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_N_A0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicate which AHB master to monitor. ALL 1s  means any master.
#define STAT_MON_AHB_MON_CTRL_0_MST_NUMBER_SHIFT                        _MK_SHIFT_CONST(4)
#define STAT_MON_AHB_MON_CTRL_0_MST_NUMBER_FIELD                        (_MK_MASK_CONST(0x1f) << STAT_MON_AHB_MON_CTRL_0_MST_NUMBER_SHIFT)
#define STAT_MON_AHB_MON_CTRL_0_MST_NUMBER_RANGE                        8:4
#define STAT_MON_AHB_MON_CTRL_0_MST_NUMBER_WOFFSET                      0x0
#define STAT_MON_AHB_MON_CTRL_0_MST_NUMBER_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_MST_NUMBER_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define STAT_MON_AHB_MON_CTRL_0_MST_NUMBER_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_MST_NUMBER_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// 4b0010 = request/grant latency (one master only). 
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_COND_SHIFT                       _MK_SHIFT_CONST(0)
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_COND_FIELD                       (_MK_MASK_CONST(0xf) << STAT_MON_AHB_MON_CTRL_0_SAMPLE_COND_SHIFT)
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_COND_RANGE                       3:0
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_COND_WOFFSET                     0x0
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_COND_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_COND_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_COND_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_CTRL_0_SAMPLE_COND_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register STAT_MON_AHB_MON_STATUS_0  
#define STAT_MON_AHB_MON_STATUS_0                       _MK_ADDR_CONST(0x184)
#define STAT_MON_AHB_MON_STATUS_0_WORD_COUNT                    0x1
#define STAT_MON_AHB_MON_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_AHB_MON_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_STATUS_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define STAT_MON_AHB_MON_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Count.
#define STAT_MON_AHB_MON_STATUS_0_COUNT_SHIFT                   _MK_SHIFT_CONST(0)
#define STAT_MON_AHB_MON_STATUS_0_COUNT_FIELD                   (_MK_MASK_CONST(0xffffffff) << STAT_MON_AHB_MON_STATUS_0_COUNT_SHIFT)
#define STAT_MON_AHB_MON_STATUS_0_COUNT_RANGE                   31:0
#define STAT_MON_AHB_MON_STATUS_0_COUNT_WOFFSET                 0x0
#define STAT_MON_AHB_MON_STATUS_0_COUNT_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_STATUS_0_COUNT_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_AHB_MON_STATUS_0_COUNT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_MON_STATUS_0_COUNT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register STAT_MON_AHB_LOWER_WMARK_0  
#define STAT_MON_AHB_LOWER_WMARK_0                      _MK_ADDR_CONST(0x188)
#define STAT_MON_AHB_LOWER_WMARK_0_WORD_COUNT                   0x1
#define STAT_MON_AHB_LOWER_WMARK_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_LOWER_WMARK_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define STAT_MON_AHB_LOWER_WMARK_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_LOWER_WMARK_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_LOWER_WMARK_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_AHB_LOWER_WMARK_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
// Lower watermark count value.
#define STAT_MON_AHB_LOWER_WMARK_0_LOWER_WMARK_CNT_SHIFT                        _MK_SHIFT_CONST(0)
#define STAT_MON_AHB_LOWER_WMARK_0_LOWER_WMARK_CNT_FIELD                        (_MK_MASK_CONST(0xffffffff) << STAT_MON_AHB_LOWER_WMARK_0_LOWER_WMARK_CNT_SHIFT)
#define STAT_MON_AHB_LOWER_WMARK_0_LOWER_WMARK_CNT_RANGE                        31:0
#define STAT_MON_AHB_LOWER_WMARK_0_LOWER_WMARK_CNT_WOFFSET                      0x0
#define STAT_MON_AHB_LOWER_WMARK_0_LOWER_WMARK_CNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_LOWER_WMARK_0_LOWER_WMARK_CNT_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define STAT_MON_AHB_LOWER_WMARK_0_LOWER_WMARK_CNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_LOWER_WMARK_0_LOWER_WMARK_CNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register STAT_MON_AHB_UPPER_WMARK_0  
#define STAT_MON_AHB_UPPER_WMARK_0                      _MK_ADDR_CONST(0x18c)
#define STAT_MON_AHB_UPPER_WMARK_0_WORD_COUNT                   0x1
#define STAT_MON_AHB_UPPER_WMARK_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_UPPER_WMARK_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define STAT_MON_AHB_UPPER_WMARK_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_UPPER_WMARK_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_UPPER_WMARK_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_AHB_UPPER_WMARK_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
// Upper watermark count value.
#define STAT_MON_AHB_UPPER_WMARK_0_UPPER_WMARK_CNT_SHIFT                        _MK_SHIFT_CONST(0)
#define STAT_MON_AHB_UPPER_WMARK_0_UPPER_WMARK_CNT_FIELD                        (_MK_MASK_CONST(0xffffffff) << STAT_MON_AHB_UPPER_WMARK_0_UPPER_WMARK_CNT_SHIFT)
#define STAT_MON_AHB_UPPER_WMARK_0_UPPER_WMARK_CNT_RANGE                        31:0
#define STAT_MON_AHB_UPPER_WMARK_0_UPPER_WMARK_CNT_WOFFSET                      0x0
#define STAT_MON_AHB_UPPER_WMARK_0_UPPER_WMARK_CNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_UPPER_WMARK_0_UPPER_WMARK_CNT_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define STAT_MON_AHB_UPPER_WMARK_0_UPPER_WMARK_CNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_AHB_UPPER_WMARK_0_UPPER_WMARK_CNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Reserved address 400 [0x190] 

// Reserved address 404 [0x194] 

// Reserved address 408 [0x198] 

// Reserved address 412 [0x19c] 

// Register STAT_MON_APB_MON_CTRL_0  
#define STAT_MON_APB_MON_CTRL_0                 _MK_ADDR_CONST(0x1a0)
#define STAT_MON_APB_MON_CTRL_0_WORD_COUNT                      0x1
#define STAT_MON_APB_MON_CTRL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define STAT_MON_APB_MON_CTRL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define STAT_MON_APB_MON_CTRL_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Enable Monitor. Set by SW to enable sampling.  Cleared when the sampling period expires. APB monitor is enabled.
#define STAT_MON_APB_MON_CTRL_0_ENB_SHIFT                       _MK_SHIFT_CONST(31)
#define STAT_MON_APB_MON_CTRL_0_ENB_FIELD                       (_MK_MASK_CONST(0x1) << STAT_MON_APB_MON_CTRL_0_ENB_SHIFT)
#define STAT_MON_APB_MON_CTRL_0_ENB_RANGE                       31:31
#define STAT_MON_APB_MON_CTRL_0_ENB_WOFFSET                     0x0
#define STAT_MON_APB_MON_CTRL_0_ENB_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_ENB_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define STAT_MON_APB_MON_CTRL_0_ENB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_ENB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_ENB_DISABLE                     _MK_ENUM_CONST(0)    // // APB monitor is disabled.     

#define STAT_MON_APB_MON_CTRL_0_ENB_ENABLE                      _MK_ENUM_CONST(1)

// Enable interrupt. interrupt is enabled.
#define STAT_MON_APB_MON_CTRL_0_INT_EN_SHIFT                    _MK_SHIFT_CONST(30)
#define STAT_MON_APB_MON_CTRL_0_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << STAT_MON_APB_MON_CTRL_0_INT_EN_SHIFT)
#define STAT_MON_APB_MON_CTRL_0_INT_EN_RANGE                    30:30
#define STAT_MON_APB_MON_CTRL_0_INT_EN_WOFFSET                  0x0
#define STAT_MON_APB_MON_CTRL_0_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define STAT_MON_APB_MON_CTRL_0_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_EN_DISABLE                  _MK_ENUM_CONST(0)    // // interrupt is disabled.     

#define STAT_MON_APB_MON_CTRL_0_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

// Assert by HW when sampling period expires when  INT_EN is set. 1 = interrupt detected
// SW writing a 1 clears this bit. Writing 0 is ignored.
#define STAT_MON_APB_MON_CTRL_0_INT_SHIFT                       _MK_SHIFT_CONST(29)
#define STAT_MON_APB_MON_CTRL_0_INT_FIELD                       (_MK_MASK_CONST(0x1) << STAT_MON_APB_MON_CTRL_0_INT_SHIFT)
#define STAT_MON_APB_MON_CTRL_0_INT_RANGE                       29:29
#define STAT_MON_APB_MON_CTRL_0_INT_WOFFSET                     0x0
#define STAT_MON_APB_MON_CTRL_0_INT_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define STAT_MON_APB_MON_CTRL_0_INT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_NOINT                       _MK_ENUM_CONST(0)    // // 0 = interrupt not detected

#define STAT_MON_APB_MON_CTRL_0_INT_INT                 _MK_ENUM_CONST(1)

// 0 = sample only for the period mentioned in  SAMPLE_PERIOD. sample mode is enabled.
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_MODE_SHIFT                       _MK_SHIFT_CONST(28)
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_MODE_FIELD                       (_MK_MASK_CONST(0x1) << STAT_MON_APB_MON_CTRL_0_SAMPLE_MODE_SHIFT)
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_MODE_RANGE                       28:28
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_MODE_WOFFSET                     0x0
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_MODE_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_MODE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_MODE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_MODE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_MODE_DISABLE                     _MK_ENUM_CONST(0)    // // sample mode is disabled.     

#define STAT_MON_APB_MON_CTRL_0_SAMPLE_MODE_ENABLE                      _MK_ENUM_CONST(1)

// Sampling period in milliseconds (implemented as  n+1 counter).
// Programming a 0 imply a 1 millisecond sampling period.
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_PERIOD_SHIFT                     _MK_SHIFT_CONST(20)
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_PERIOD_FIELD                     (_MK_MASK_CONST(0xff) << STAT_MON_APB_MON_CTRL_0_SAMPLE_PERIOD_SHIFT)
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_PERIOD_RANGE                     27:20
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_PERIOD_WOFFSET                   0x0
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_PERIOD_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_PERIOD_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_PERIOD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_PERIOD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Enable periodic mode. periodic mode is enabled.
#define STAT_MON_APB_MON_CTRL_0_ENB_PERIODIC_SHIFT                      _MK_SHIFT_CONST(19)
#define STAT_MON_APB_MON_CTRL_0_ENB_PERIODIC_FIELD                      (_MK_MASK_CONST(0x1) << STAT_MON_APB_MON_CTRL_0_ENB_PERIODIC_SHIFT)
#define STAT_MON_APB_MON_CTRL_0_ENB_PERIODIC_RANGE                      19:19
#define STAT_MON_APB_MON_CTRL_0_ENB_PERIODIC_WOFFSET                    0x0
#define STAT_MON_APB_MON_CTRL_0_ENB_PERIODIC_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_ENB_PERIODIC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define STAT_MON_APB_MON_CTRL_0_ENB_PERIODIC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_ENB_PERIODIC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_ENB_PERIODIC_DISABLE                    _MK_ENUM_CONST(0)    // // periodic mode is disabled.     

#define STAT_MON_APB_MON_CTRL_0_ENB_PERIODIC_ENABLE                     _MK_ENUM_CONST(1)

// 
#define STAT_MON_APB_MON_CTRL_0_N_A1_SHIFT                      _MK_SHIFT_CONST(16)
#define STAT_MON_APB_MON_CTRL_0_N_A1_FIELD                      (_MK_MASK_CONST(0x7) << STAT_MON_APB_MON_CTRL_0_N_A1_SHIFT)
#define STAT_MON_APB_MON_CTRL_0_N_A1_RANGE                      18:16
#define STAT_MON_APB_MON_CTRL_0_N_A1_WOFFSET                    0x0
#define STAT_MON_APB_MON_CTRL_0_N_A1_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_N_A1_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define STAT_MON_APB_MON_CTRL_0_N_A1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_N_A1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Interrupt always at end of sample period. interrupt is enabled.
#define STAT_MON_APB_MON_CTRL_0_INT_AT_END_SHIFT                        _MK_SHIFT_CONST(15)
#define STAT_MON_APB_MON_CTRL_0_INT_AT_END_FIELD                        (_MK_MASK_CONST(0x1) << STAT_MON_APB_MON_CTRL_0_INT_AT_END_SHIFT)
#define STAT_MON_APB_MON_CTRL_0_INT_AT_END_RANGE                        15:15
#define STAT_MON_APB_MON_CTRL_0_INT_AT_END_WOFFSET                      0x0
#define STAT_MON_APB_MON_CTRL_0_INT_AT_END_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_AT_END_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define STAT_MON_APB_MON_CTRL_0_INT_AT_END_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_AT_END_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_AT_END_DISABLE                      _MK_ENUM_CONST(0)    // // interrupt is disabled.     

#define STAT_MON_APB_MON_CTRL_0_INT_AT_END_ENABLE                       _MK_ENUM_CONST(1)

// Interrupt only if count is below the lower  watermark at the end of sample period. interrupt is enabled.
#define STAT_MON_APB_MON_CTRL_0_INT_IF_BELOW_WMARK_SHIFT                        _MK_SHIFT_CONST(14)
#define STAT_MON_APB_MON_CTRL_0_INT_IF_BELOW_WMARK_FIELD                        (_MK_MASK_CONST(0x1) << STAT_MON_APB_MON_CTRL_0_INT_IF_BELOW_WMARK_SHIFT)
#define STAT_MON_APB_MON_CTRL_0_INT_IF_BELOW_WMARK_RANGE                        14:14
#define STAT_MON_APB_MON_CTRL_0_INT_IF_BELOW_WMARK_WOFFSET                      0x0
#define STAT_MON_APB_MON_CTRL_0_INT_IF_BELOW_WMARK_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_IF_BELOW_WMARK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define STAT_MON_APB_MON_CTRL_0_INT_IF_BELOW_WMARK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_IF_BELOW_WMARK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_IF_BELOW_WMARK_DISABLE                      _MK_ENUM_CONST(0)    // // interrupt is disabled.     

#define STAT_MON_APB_MON_CTRL_0_INT_IF_BELOW_WMARK_ENABLE                       _MK_ENUM_CONST(1)

// Interrupt only if count is above the upper  watermark at the end of sample period. interrupt is enabled.
#define STAT_MON_APB_MON_CTRL_0_INT_IF_ABOVE_WMARK_SHIFT                        _MK_SHIFT_CONST(13)
#define STAT_MON_APB_MON_CTRL_0_INT_IF_ABOVE_WMARK_FIELD                        (_MK_MASK_CONST(0x1) << STAT_MON_APB_MON_CTRL_0_INT_IF_ABOVE_WMARK_SHIFT)
#define STAT_MON_APB_MON_CTRL_0_INT_IF_ABOVE_WMARK_RANGE                        13:13
#define STAT_MON_APB_MON_CTRL_0_INT_IF_ABOVE_WMARK_WOFFSET                      0x0
#define STAT_MON_APB_MON_CTRL_0_INT_IF_ABOVE_WMARK_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_IF_ABOVE_WMARK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define STAT_MON_APB_MON_CTRL_0_INT_IF_ABOVE_WMARK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_IF_ABOVE_WMARK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_IF_ABOVE_WMARK_DISABLE                      _MK_ENUM_CONST(0)    // // interrupt is disabled.     

#define STAT_MON_APB_MON_CTRL_0_INT_IF_ABOVE_WMARK_ENABLE                       _MK_ENUM_CONST(1)

// Interrupt when count rolls over. interrupt is enabled.
#define STAT_MON_APB_MON_CTRL_0_INT_WHEN_CNT_ROVER_SHIFT                        _MK_SHIFT_CONST(12)
#define STAT_MON_APB_MON_CTRL_0_INT_WHEN_CNT_ROVER_FIELD                        (_MK_MASK_CONST(0x1) << STAT_MON_APB_MON_CTRL_0_INT_WHEN_CNT_ROVER_SHIFT)
#define STAT_MON_APB_MON_CTRL_0_INT_WHEN_CNT_ROVER_RANGE                        12:12
#define STAT_MON_APB_MON_CTRL_0_INT_WHEN_CNT_ROVER_WOFFSET                      0x0
#define STAT_MON_APB_MON_CTRL_0_INT_WHEN_CNT_ROVER_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_WHEN_CNT_ROVER_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define STAT_MON_APB_MON_CTRL_0_INT_WHEN_CNT_ROVER_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_WHEN_CNT_ROVER_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_INT_WHEN_CNT_ROVER_DISABLE                      _MK_ENUM_CONST(0)    // // interrupt is disabled.     

#define STAT_MON_APB_MON_CTRL_0_INT_WHEN_CNT_ROVER_ENABLE                       _MK_ENUM_CONST(1)

// Reserved
#define STAT_MON_APB_MON_CTRL_0_N_A0_SHIFT                      _MK_SHIFT_CONST(9)
#define STAT_MON_APB_MON_CTRL_0_N_A0_FIELD                      (_MK_MASK_CONST(0x7) << STAT_MON_APB_MON_CTRL_0_N_A0_SHIFT)
#define STAT_MON_APB_MON_CTRL_0_N_A0_RANGE                      11:9
#define STAT_MON_APB_MON_CTRL_0_N_A0_WOFFSET                    0x0
#define STAT_MON_APB_MON_CTRL_0_N_A0_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_N_A0_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define STAT_MON_APB_MON_CTRL_0_N_A0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_N_A0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Indicate which APB slave to monitor. ALL 1s  means any master.
#define STAT_MON_APB_MON_CTRL_0_SLV_NUMBER_SHIFT                        _MK_SHIFT_CONST(4)
#define STAT_MON_APB_MON_CTRL_0_SLV_NUMBER_FIELD                        (_MK_MASK_CONST(0x1f) << STAT_MON_APB_MON_CTRL_0_SLV_NUMBER_SHIFT)
#define STAT_MON_APB_MON_CTRL_0_SLV_NUMBER_RANGE                        8:4
#define STAT_MON_APB_MON_CTRL_0_SLV_NUMBER_WOFFSET                      0x0
#define STAT_MON_APB_MON_CTRL_0_SLV_NUMBER_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_SLV_NUMBER_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define STAT_MON_APB_MON_CTRL_0_SLV_NUMBER_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_SLV_NUMBER_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// 4b0001 = active data transfer count (one or any  slaves). 
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_COND_SHIFT                       _MK_SHIFT_CONST(0)
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_COND_FIELD                       (_MK_MASK_CONST(0xf) << STAT_MON_APB_MON_CTRL_0_SAMPLE_COND_SHIFT)
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_COND_RANGE                       3:0
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_COND_WOFFSET                     0x0
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_COND_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_COND_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_COND_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_CTRL_0_SAMPLE_COND_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register STAT_MON_APB_MON_STATUS_0  
#define STAT_MON_APB_MON_STATUS_0                       _MK_ADDR_CONST(0x1a4)
#define STAT_MON_APB_MON_STATUS_0_WORD_COUNT                    0x1
#define STAT_MON_APB_MON_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_APB_MON_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_STATUS_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define STAT_MON_APB_MON_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// Count.
#define STAT_MON_APB_MON_STATUS_0_COUNT_SHIFT                   _MK_SHIFT_CONST(0)
#define STAT_MON_APB_MON_STATUS_0_COUNT_FIELD                   (_MK_MASK_CONST(0xffffffff) << STAT_MON_APB_MON_STATUS_0_COUNT_SHIFT)
#define STAT_MON_APB_MON_STATUS_0_COUNT_RANGE                   31:0
#define STAT_MON_APB_MON_STATUS_0_COUNT_WOFFSET                 0x0
#define STAT_MON_APB_MON_STATUS_0_COUNT_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_STATUS_0_COUNT_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_APB_MON_STATUS_0_COUNT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_APB_MON_STATUS_0_COUNT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register STAT_MON_APB_LOWER_WMARK_0  
#define STAT_MON_APB_LOWER_WMARK_0                      _MK_ADDR_CONST(0x1a8)
#define STAT_MON_APB_LOWER_WMARK_0_WORD_COUNT                   0x1
#define STAT_MON_APB_LOWER_WMARK_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define STAT_MON_APB_LOWER_WMARK_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define STAT_MON_APB_LOWER_WMARK_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define STAT_MON_APB_LOWER_WMARK_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define STAT_MON_APB_LOWER_WMARK_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_APB_LOWER_WMARK_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
// Lower watermark count value.
#define STAT_MON_APB_LOWER_WMARK_0_LOWER_WMARK_CNT_SHIFT                        _MK_SHIFT_CONST(0)
#define STAT_MON_APB_LOWER_WMARK_0_LOWER_WMARK_CNT_FIELD                        (_MK_MASK_CONST(0xffffffff) << STAT_MON_APB_LOWER_WMARK_0_LOWER_WMARK_CNT_SHIFT)
#define STAT_MON_APB_LOWER_WMARK_0_LOWER_WMARK_CNT_RANGE                        31:0
#define STAT_MON_APB_LOWER_WMARK_0_LOWER_WMARK_CNT_WOFFSET                      0x0
#define STAT_MON_APB_LOWER_WMARK_0_LOWER_WMARK_CNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_APB_LOWER_WMARK_0_LOWER_WMARK_CNT_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define STAT_MON_APB_LOWER_WMARK_0_LOWER_WMARK_CNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_APB_LOWER_WMARK_0_LOWER_WMARK_CNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register STAT_MON_APB_UPPER_WMARK_0  
#define STAT_MON_APB_UPPER_WMARK_0                      _MK_ADDR_CONST(0x1ac)
#define STAT_MON_APB_UPPER_WMARK_0_WORD_COUNT                   0x1
#define STAT_MON_APB_UPPER_WMARK_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define STAT_MON_APB_UPPER_WMARK_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define STAT_MON_APB_UPPER_WMARK_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define STAT_MON_APB_UPPER_WMARK_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define STAT_MON_APB_UPPER_WMARK_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_APB_UPPER_WMARK_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
// Upper watermark count value.
#define STAT_MON_APB_UPPER_WMARK_0_UPPER_WMARK_CNT_SHIFT                        _MK_SHIFT_CONST(0)
#define STAT_MON_APB_UPPER_WMARK_0_UPPER_WMARK_CNT_FIELD                        (_MK_MASK_CONST(0xffffffff) << STAT_MON_APB_UPPER_WMARK_0_UPPER_WMARK_CNT_SHIFT)
#define STAT_MON_APB_UPPER_WMARK_0_UPPER_WMARK_CNT_RANGE                        31:0
#define STAT_MON_APB_UPPER_WMARK_0_UPPER_WMARK_CNT_WOFFSET                      0x0
#define STAT_MON_APB_UPPER_WMARK_0_UPPER_WMARK_CNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_APB_UPPER_WMARK_0_UPPER_WMARK_CNT_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define STAT_MON_APB_UPPER_WMARK_0_UPPER_WMARK_CNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_APB_UPPER_WMARK_0_UPPER_WMARK_CNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Reserved address 432 [0x1b0] 

// Reserved address 436 [0x1b4] 

// Reserved address 440 [0x1b8] 

// Reserved address 444 [0x1bc] 

// Register STAT_MON_VPIPE_MON_CTRL_0  
#define STAT_MON_VPIPE_MON_CTRL_0                       _MK_ADDR_CONST(0x1c0)
#define STAT_MON_VPIPE_MON_CTRL_0_WORD_COUNT                    0x1
#define STAT_MON_VPIPE_MON_CTRL_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_VPIPE_MON_CTRL_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define STAT_MON_VPIPE_MON_CTRL_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
// Enable Monitor. Set by SW to enable sampling.  vpipe monitor is enabled.
// Cleared in one of the following ways,
// (a) When SW intends to stop the  monitor, it can do so by clearing this field, or
// (b) when the sampling period  expires.
#define STAT_MON_VPIPE_MON_CTRL_0_ENB_SHIFT                     _MK_SHIFT_CONST(31)
#define STAT_MON_VPIPE_MON_CTRL_0_ENB_FIELD                     (_MK_MASK_CONST(0x1) << STAT_MON_VPIPE_MON_CTRL_0_ENB_SHIFT)
#define STAT_MON_VPIPE_MON_CTRL_0_ENB_RANGE                     31:31
#define STAT_MON_VPIPE_MON_CTRL_0_ENB_WOFFSET                   0x0
#define STAT_MON_VPIPE_MON_CTRL_0_ENB_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_ENB_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define STAT_MON_VPIPE_MON_CTRL_0_ENB_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_ENB_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_ENB_DISABLE                   _MK_ENUM_CONST(0)    // // vpipe monitor is disabled.     

#define STAT_MON_VPIPE_MON_CTRL_0_ENB_ENABLE                    _MK_ENUM_CONST(1)

// Enable interrupt when sampling period expires. interrupt is enabled.
#define STAT_MON_VPIPE_MON_CTRL_0_INT_EN_SHIFT                  _MK_SHIFT_CONST(30)
#define STAT_MON_VPIPE_MON_CTRL_0_INT_EN_FIELD                  (_MK_MASK_CONST(0x1) << STAT_MON_VPIPE_MON_CTRL_0_INT_EN_SHIFT)
#define STAT_MON_VPIPE_MON_CTRL_0_INT_EN_RANGE                  30:30
#define STAT_MON_VPIPE_MON_CTRL_0_INT_EN_WOFFSET                        0x0
#define STAT_MON_VPIPE_MON_CTRL_0_INT_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_INT_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define STAT_MON_VPIPE_MON_CTRL_0_INT_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_INT_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_INT_EN_DISABLE                        _MK_ENUM_CONST(0)    // // interrupt is disabled.     

#define STAT_MON_VPIPE_MON_CTRL_0_INT_EN_ENABLE                 _MK_ENUM_CONST(1)

// Assert by HW when sampling period expires when  INT_EN is set. 1 = interrupt detected
// SW writing a 1 clears this bit. Writing 0 is ignored.
#define STAT_MON_VPIPE_MON_CTRL_0_INT_SHIFT                     _MK_SHIFT_CONST(29)
#define STAT_MON_VPIPE_MON_CTRL_0_INT_FIELD                     (_MK_MASK_CONST(0x1) << STAT_MON_VPIPE_MON_CTRL_0_INT_SHIFT)
#define STAT_MON_VPIPE_MON_CTRL_0_INT_RANGE                     29:29
#define STAT_MON_VPIPE_MON_CTRL_0_INT_WOFFSET                   0x0
#define STAT_MON_VPIPE_MON_CTRL_0_INT_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_INT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define STAT_MON_VPIPE_MON_CTRL_0_INT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_INT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_INT_NOINT                     _MK_ENUM_CONST(0)    // // 0 = interrupt not detected

#define STAT_MON_VPIPE_MON_CTRL_0_INT_INT                       _MK_ENUM_CONST(1)

// 0 = sample only for the period mentioned in  SAMPLE_PERIOD. sample mode is enabled.
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_MODE_SHIFT                     _MK_SHIFT_CONST(28)
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_MODE_FIELD                     (_MK_MASK_CONST(0x1) << STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_MODE_SHIFT)
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_MODE_RANGE                     28:28
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_MODE_WOFFSET                   0x0
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_MODE_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_MODE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_MODE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_MODE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_MODE_DISABLE                   _MK_ENUM_CONST(0)    // // sample mode is disabled.     

#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_MODE_ENABLE                    _MK_ENUM_CONST(1)

// Sampling period in milliseconds (implemented as  n+1 counter).
// Programming a 0 imply a 1 millisecond sampling period.
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_PERIOD_SHIFT                   _MK_SHIFT_CONST(20)
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_PERIOD_FIELD                   (_MK_MASK_CONST(0xff) << STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_PERIOD_SHIFT)
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_PERIOD_RANGE                   27:20
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_PERIOD_WOFFSET                 0x0
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_PERIOD_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_PERIOD_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_PERIOD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_PERIOD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Reserved
#define STAT_MON_VPIPE_MON_CTRL_0_N_A_SHIFT                     _MK_SHIFT_CONST(4)
#define STAT_MON_VPIPE_MON_CTRL_0_N_A_FIELD                     (_MK_MASK_CONST(0xffff) << STAT_MON_VPIPE_MON_CTRL_0_N_A_SHIFT)
#define STAT_MON_VPIPE_MON_CTRL_0_N_A_RANGE                     19:4
#define STAT_MON_VPIPE_MON_CTRL_0_N_A_WOFFSET                   0x0
#define STAT_MON_VPIPE_MON_CTRL_0_N_A_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_N_A_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define STAT_MON_VPIPE_MON_CTRL_0_N_A_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_N_A_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// 4b0011 = Monitor total words written during the 
// sample period (writing to external Memory) on slot 2 + AHB: 32-bit data
// writes only (not command data).
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_COND_SHIFT                     _MK_SHIFT_CONST(0)
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_COND_FIELD                     (_MK_MASK_CONST(0xf) << STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_COND_SHIFT)
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_COND_RANGE                     3:0
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_COND_WOFFSET                   0x0
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_COND_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_COND_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_COND_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_CTRL_0_SAMPLE_COND_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register STAT_MON_VPIPE_MON_STATUS_0  
#define STAT_MON_VPIPE_MON_STATUS_0                     _MK_ADDR_CONST(0x1c4)
#define STAT_MON_VPIPE_MON_STATUS_0_WORD_COUNT                  0x1
#define STAT_MON_VPIPE_MON_STATUS_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_STATUS_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define STAT_MON_VPIPE_MON_STATUS_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_STATUS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_STATUS_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define STAT_MON_VPIPE_MON_STATUS_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
// SAMPLE_COND = 4b0011: number of words written to  external memory in the Sample period.
#define STAT_MON_VPIPE_MON_STATUS_0_COUNT_SHIFT                 _MK_SHIFT_CONST(0)
#define STAT_MON_VPIPE_MON_STATUS_0_COUNT_FIELD                 (_MK_MASK_CONST(0xffffffff) << STAT_MON_VPIPE_MON_STATUS_0_COUNT_SHIFT)
#define STAT_MON_VPIPE_MON_STATUS_0_COUNT_RANGE                 31:0
#define STAT_MON_VPIPE_MON_STATUS_0_COUNT_WOFFSET                       0x0
#define STAT_MON_VPIPE_MON_STATUS_0_COUNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_STATUS_0_COUNT_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define STAT_MON_VPIPE_MON_STATUS_0_COUNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_VPIPE_MON_STATUS_0_COUNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 456 [0x1c8] 

// Reserved address 460 [0x1cc] 

// Reserved address 464 [0x1d0] 

// Reserved address 468 [0x1d4] 

// Reserved address 472 [0x1d8] 

// Reserved address 476 [0x1dc] 

// Register STAT_MON_SMP_MON_CTRL_0  
#define STAT_MON_SMP_MON_CTRL_0                 _MK_ADDR_CONST(0x1e0)
#define STAT_MON_SMP_MON_CTRL_0_WORD_COUNT                      0x1
#define STAT_MON_SMP_MON_CTRL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define STAT_MON_SMP_MON_CTRL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define STAT_MON_SMP_MON_CTRL_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Enable Monitor. Set by SW to enable sampling. semaphore monitor is enabled.
// Cleared in one of the following ways,
// (a) When SW intends to stop the  monitor, it can do so by clearing this field, or
// (b) when the sampling period  expires.
#define STAT_MON_SMP_MON_CTRL_0_ENB_SHIFT                       _MK_SHIFT_CONST(31)
#define STAT_MON_SMP_MON_CTRL_0_ENB_FIELD                       (_MK_MASK_CONST(0x1) << STAT_MON_SMP_MON_CTRL_0_ENB_SHIFT)
#define STAT_MON_SMP_MON_CTRL_0_ENB_RANGE                       31:31
#define STAT_MON_SMP_MON_CTRL_0_ENB_WOFFSET                     0x0
#define STAT_MON_SMP_MON_CTRL_0_ENB_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_ENB_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define STAT_MON_SMP_MON_CTRL_0_ENB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_ENB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_ENB_DISABLE                     _MK_ENUM_CONST(0)    // // semaphore monitor is disabled.     

#define STAT_MON_SMP_MON_CTRL_0_ENB_ENABLE                      _MK_ENUM_CONST(1)

// Enable interrupt when sampling period expires. interrupt is enabled.
#define STAT_MON_SMP_MON_CTRL_0_INT_EN_SHIFT                    _MK_SHIFT_CONST(30)
#define STAT_MON_SMP_MON_CTRL_0_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << STAT_MON_SMP_MON_CTRL_0_INT_EN_SHIFT)
#define STAT_MON_SMP_MON_CTRL_0_INT_EN_RANGE                    30:30
#define STAT_MON_SMP_MON_CTRL_0_INT_EN_WOFFSET                  0x0
#define STAT_MON_SMP_MON_CTRL_0_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define STAT_MON_SMP_MON_CTRL_0_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_INT_EN_DISABLE                  _MK_ENUM_CONST(0)    // // interrupt is disabled.     

#define STAT_MON_SMP_MON_CTRL_0_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

// Assert by HW when sampling period expires when INT_EN  is set. 1 = interrupt detected
// SW writing a 1 clears this bit. Writing 0 is ignored.
#define STAT_MON_SMP_MON_CTRL_0_INT_SHIFT                       _MK_SHIFT_CONST(29)
#define STAT_MON_SMP_MON_CTRL_0_INT_FIELD                       (_MK_MASK_CONST(0x1) << STAT_MON_SMP_MON_CTRL_0_INT_SHIFT)
#define STAT_MON_SMP_MON_CTRL_0_INT_RANGE                       29:29
#define STAT_MON_SMP_MON_CTRL_0_INT_WOFFSET                     0x0
#define STAT_MON_SMP_MON_CTRL_0_INT_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_INT_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define STAT_MON_SMP_MON_CTRL_0_INT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_INT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_INT_NOINT                       _MK_ENUM_CONST(0)    // // 0 = interrupt not detected

#define STAT_MON_SMP_MON_CTRL_0_INT_INT                 _MK_ENUM_CONST(1)

// 0 = sample only for the period mentioned in  SAMPLE_PERIOD. sample mode is enabled.
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_MODE_SHIFT                       _MK_SHIFT_CONST(28)
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_MODE_FIELD                       (_MK_MASK_CONST(0x1) << STAT_MON_SMP_MON_CTRL_0_SAMPLE_MODE_SHIFT)
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_MODE_RANGE                       28:28
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_MODE_WOFFSET                     0x0
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_MODE_DEFAULT                     _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_MODE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_MODE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_MODE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_MODE_DISABLE                     _MK_ENUM_CONST(0)    // // sample mode is disabled.     

#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_MODE_ENABLE                      _MK_ENUM_CONST(1)

// Sampling period in milliseconds (implemented as  n+1 counter).
// Programming a 0 imply a 1 millisecond sampling period.
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_PERIOD_SHIFT                     _MK_SHIFT_CONST(20)
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_PERIOD_FIELD                     (_MK_MASK_CONST(0xff) << STAT_MON_SMP_MON_CTRL_0_SAMPLE_PERIOD_SHIFT)
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_PERIOD_RANGE                     27:20
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_PERIOD_WOFFSET                   0x0
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_PERIOD_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_PERIOD_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_PERIOD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_SAMPLE_PERIOD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// 
#define STAT_MON_SMP_MON_CTRL_0_N_A1_SHIFT                      _MK_SHIFT_CONST(19)
#define STAT_MON_SMP_MON_CTRL_0_N_A1_FIELD                      (_MK_MASK_CONST(0x1) << STAT_MON_SMP_MON_CTRL_0_N_A1_SHIFT)
#define STAT_MON_SMP_MON_CTRL_0_N_A1_RANGE                      19:19
#define STAT_MON_SMP_MON_CTRL_0_N_A1_WOFFSET                    0x0
#define STAT_MON_SMP_MON_CTRL_0_N_A1_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_N_A1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define STAT_MON_SMP_MON_CTRL_0_N_A1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_N_A1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  0 = clk count mode (in number of  sclk).  countmode is enabled.
#define STAT_MON_SMP_MON_CTRL_0_CLK_CNT_MODE_SHIFT                      _MK_SHIFT_CONST(18)
#define STAT_MON_SMP_MON_CTRL_0_CLK_CNT_MODE_FIELD                      (_MK_MASK_CONST(0x1) << STAT_MON_SMP_MON_CTRL_0_CLK_CNT_MODE_SHIFT)
#define STAT_MON_SMP_MON_CTRL_0_CLK_CNT_MODE_RANGE                      18:18
#define STAT_MON_SMP_MON_CTRL_0_CLK_CNT_MODE_WOFFSET                    0x0
#define STAT_MON_SMP_MON_CTRL_0_CLK_CNT_MODE_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_CLK_CNT_MODE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define STAT_MON_SMP_MON_CTRL_0_CLK_CNT_MODE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_CLK_CNT_MODE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_CLK_CNT_MODE_DISABLE                    _MK_ENUM_CONST(0)    // // count mode is disabled.     

#define STAT_MON_SMP_MON_CTRL_0_CLK_CNT_MODE_ENABLE                     _MK_ENUM_CONST(1)

// Reserved
#define STAT_MON_SMP_MON_CTRL_0_N_A0_SHIFT                      _MK_SHIFT_CONST(9)
#define STAT_MON_SMP_MON_CTRL_0_N_A0_FIELD                      (_MK_MASK_CONST(0x1ff) << STAT_MON_SMP_MON_CTRL_0_N_A0_SHIFT)
#define STAT_MON_SMP_MON_CTRL_0_N_A0_RANGE                      17:9
#define STAT_MON_SMP_MON_CTRL_0_N_A0_WOFFSET                    0x0
#define STAT_MON_SMP_MON_CTRL_0_N_A0_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_N_A0_DEFAULT_MASK                       _MK_MASK_CONST(0x1ff)
#define STAT_MON_SMP_MON_CTRL_0_N_A0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_N_A0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// 5h1F: start counter when CMP.31 is set.
#define STAT_MON_SMP_MON_CTRL_0_START_COND_SHIFT                        _MK_SHIFT_CONST(4)
#define STAT_MON_SMP_MON_CTRL_0_START_COND_FIELD                        (_MK_MASK_CONST(0x1f) << STAT_MON_SMP_MON_CTRL_0_START_COND_SHIFT)
#define STAT_MON_SMP_MON_CTRL_0_START_COND_RANGE                        8:4
#define STAT_MON_SMP_MON_CTRL_0_START_COND_WOFFSET                      0x0
#define STAT_MON_SMP_MON_CTRL_0_START_COND_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_START_COND_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define STAT_MON_SMP_MON_CTRL_0_START_COND_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_START_COND_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//  The sample period expires, whichever happens  first.
#define STAT_MON_SMP_MON_CTRL_0_STOP_COND_SHIFT                 _MK_SHIFT_CONST(0)
#define STAT_MON_SMP_MON_CTRL_0_STOP_COND_FIELD                 (_MK_MASK_CONST(0xf) << STAT_MON_SMP_MON_CTRL_0_STOP_COND_SHIFT)
#define STAT_MON_SMP_MON_CTRL_0_STOP_COND_RANGE                 3:0
#define STAT_MON_SMP_MON_CTRL_0_STOP_COND_WOFFSET                       0x0
#define STAT_MON_SMP_MON_CTRL_0_STOP_COND_DEFAULT                       _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_STOP_COND_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define STAT_MON_SMP_MON_CTRL_0_STOP_COND_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_CTRL_0_STOP_COND_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register STAT_MON_SMP_MON_STATUS_0  
#define STAT_MON_SMP_MON_STATUS_0                       _MK_ADDR_CONST(0x1e4)
#define STAT_MON_SMP_MON_STATUS_0_WORD_COUNT                    0x1
#define STAT_MON_SMP_MON_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_SMP_MON_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_STATUS_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define STAT_MON_SMP_MON_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
// count
#define STAT_MON_SMP_MON_STATUS_0_COUNT_SHIFT                   _MK_SHIFT_CONST(0)
#define STAT_MON_SMP_MON_STATUS_0_COUNT_FIELD                   (_MK_MASK_CONST(0xffffffff) << STAT_MON_SMP_MON_STATUS_0_COUNT_SHIFT)
#define STAT_MON_SMP_MON_STATUS_0_COUNT_RANGE                   31:0
#define STAT_MON_SMP_MON_STATUS_0_COUNT_WOFFSET                 0x0
#define STAT_MON_SMP_MON_STATUS_0_COUNT_DEFAULT                 _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_STATUS_0_COUNT_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define STAT_MON_SMP_MON_STATUS_0_COUNT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define STAT_MON_SMP_MON_STATUS_0_COUNT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_ARSTAT_MON_REGS(_op_) \
_op_(STAT_MON_GLB_INT_STATUS_0) \
_op_(STAT_MON_CPU_MON_CTRL_0) \
_op_(STAT_MON_CPU_MON_STATUS_0) \
_op_(STAT_MON_COP_MON_CTRL_0) \
_op_(STAT_MON_COP_MON_STATUS_0) \
_op_(STAT_MON_CACHE2_MON_CTRL_0) \
_op_(STAT_MON_CACHE2_REQ_STATUS_0) \
_op_(STAT_MON_CACHE2_HIT_STATUS_0) \
_op_(STAT_MON_AHB_MON_CTRL_0) \
_op_(STAT_MON_AHB_MON_STATUS_0) \
_op_(STAT_MON_AHB_LOWER_WMARK_0) \
_op_(STAT_MON_AHB_UPPER_WMARK_0) \
_op_(STAT_MON_APB_MON_CTRL_0) \
_op_(STAT_MON_APB_MON_STATUS_0) \
_op_(STAT_MON_APB_LOWER_WMARK_0) \
_op_(STAT_MON_APB_UPPER_WMARK_0) \
_op_(STAT_MON_VPIPE_MON_CTRL_0) \
_op_(STAT_MON_VPIPE_MON_STATUS_0) \
_op_(STAT_MON_SMP_MON_CTRL_0) \
_op_(STAT_MON_SMP_MON_STATUS_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_STAT_MON   0x00000000

//
// ARSTAT_MON REGISTER BANKS
//

#define STAT_MON0_FIRST_REG 0x0000 // STAT_MON_GLB_INT_STATUS_0
#define STAT_MON0_LAST_REG 0x0000 // STAT_MON_GLB_INT_STATUS_0
#define STAT_MON1_FIRST_REG 0x0100 // STAT_MON_CPU_MON_CTRL_0
#define STAT_MON1_LAST_REG 0x0104 // STAT_MON_CPU_MON_STATUS_0
#define STAT_MON2_FIRST_REG 0x0120 // STAT_MON_COP_MON_CTRL_0
#define STAT_MON2_LAST_REG 0x0124 // STAT_MON_COP_MON_STATUS_0
#define STAT_MON3_FIRST_REG 0x0160 // STAT_MON_CACHE2_MON_CTRL_0
#define STAT_MON3_LAST_REG 0x0168 // STAT_MON_CACHE2_HIT_STATUS_0
#define STAT_MON4_FIRST_REG 0x0180 // STAT_MON_AHB_MON_CTRL_0
#define STAT_MON4_LAST_REG 0x018c // STAT_MON_AHB_UPPER_WMARK_0
#define STAT_MON5_FIRST_REG 0x01a0 // STAT_MON_APB_MON_CTRL_0
#define STAT_MON5_LAST_REG 0x01ac // STAT_MON_APB_UPPER_WMARK_0
#define STAT_MON6_FIRST_REG 0x01c0 // STAT_MON_VPIPE_MON_CTRL_0
#define STAT_MON6_LAST_REG 0x01c4 // STAT_MON_VPIPE_MON_STATUS_0
#define STAT_MON7_FIRST_REG 0x01e0 // STAT_MON_SMP_MON_CTRL_0
#define STAT_MON7_LAST_REG 0x01e4 // STAT_MON_SMP_MON_STATUS_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARSTAT_MON_H_INC_
