/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARUART_H_INC_
#define ___ARUART_H_INC_

// Register UART_THR_DLAB_0_0  
#define UART_THR_DLAB_0_0                       _MK_ADDR_CONST(0x0)
#define UART_THR_DLAB_0_0_WORD_COUNT                    0x1
#define UART_THR_DLAB_0_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define UART_THR_DLAB_0_0_RESET_MASK                    _MK_MASK_CONST(0xff)
#define UART_THR_DLAB_0_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define UART_THR_DLAB_0_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define UART_THR_DLAB_0_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define UART_THR_DLAB_0_0_WRITE_MASK                    _MK_MASK_CONST(0xff)
// Transmit holding register, holds the character to  be transmitted by the UART. In FIFO mode, a write to this FIFO places the  data at the end of the FIFO.
#define UART_THR_DLAB_0_0_THR_A_SHIFT                   _MK_SHIFT_CONST(0)
#define UART_THR_DLAB_0_0_THR_A_FIELD                   (_MK_MASK_CONST(0xff) << UART_THR_DLAB_0_0_THR_A_SHIFT)
#define UART_THR_DLAB_0_0_THR_A_RANGE                   7:0
#define UART_THR_DLAB_0_0_THR_A_WOFFSET                 0x0
#define UART_THR_DLAB_0_0_THR_A_DEFAULT                 _MK_MASK_CONST(0x0)
#define UART_THR_DLAB_0_0_THR_A_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define UART_THR_DLAB_0_0_THR_A_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_THR_DLAB_0_0_THR_A_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Receive Buffer Register.  Rx Data read from here.
#define UART_THR_DLAB_0_0_RBR_A_SHIFT                   _MK_SHIFT_CONST(0)
#define UART_THR_DLAB_0_0_RBR_A_FIELD                   (_MK_MASK_CONST(0xff) << UART_THR_DLAB_0_0_RBR_A_SHIFT)
#define UART_THR_DLAB_0_0_RBR_A_RANGE                   7:0
#define UART_THR_DLAB_0_0_RBR_A_WOFFSET                 0x0
#define UART_THR_DLAB_0_0_RBR_A_DEFAULT                 _MK_MASK_CONST(0x0)
#define UART_THR_DLAB_0_0_RBR_A_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define UART_THR_DLAB_0_0_RBR_A_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_THR_DLAB_0_0_RBR_A_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Divisor Latch LSB (low 8 bits of 16-bit Baud Divisor)
#define UART_THR_DLAB_0_0_DLL_A_SHIFT                   _MK_SHIFT_CONST(0)
#define UART_THR_DLAB_0_0_DLL_A_FIELD                   (_MK_MASK_CONST(0xff) << UART_THR_DLAB_0_0_DLL_A_SHIFT)
#define UART_THR_DLAB_0_0_DLL_A_RANGE                   7:0
#define UART_THR_DLAB_0_0_DLL_A_WOFFSET                 0x0
#define UART_THR_DLAB_0_0_DLL_A_DEFAULT                 _MK_MASK_CONST(0x0)
#define UART_THR_DLAB_0_0_DLL_A_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define UART_THR_DLAB_0_0_DLL_A_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_THR_DLAB_0_0_DLL_A_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register UART_IER_DLAB_0_0  
#define UART_IER_DLAB_0_0                       _MK_ADDR_CONST(0x4)
#define UART_IER_DLAB_0_0_WORD_COUNT                    0x1
#define UART_IER_DLAB_0_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_RESET_MASK                    _MK_MASK_CONST(0xff)
#define UART_IER_DLAB_0_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define UART_IER_DLAB_0_0_WRITE_MASK                    _MK_MASK_CONST(0xff)
// Reserved
#define UART_IER_DLAB_0_0_N_A_SHIFT                     _MK_SHIFT_CONST(6)
#define UART_IER_DLAB_0_0_N_A_FIELD                     (_MK_MASK_CONST(0x3) << UART_IER_DLAB_0_0_N_A_SHIFT)
#define UART_IER_DLAB_0_0_N_A_RANGE                     7:6
#define UART_IER_DLAB_0_0_N_A_WOFFSET                   0x0
#define UART_IER_DLAB_0_0_N_A_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_N_A_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define UART_IER_DLAB_0_0_N_A_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_N_A_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Interrupt Enable for End of Received Data  1 = Enable    
#define UART_IER_DLAB_0_0_IE_EORD_SHIFT                 _MK_SHIFT_CONST(5)
#define UART_IER_DLAB_0_0_IE_EORD_FIELD                 (_MK_MASK_CONST(0x1) << UART_IER_DLAB_0_0_IE_EORD_SHIFT)
#define UART_IER_DLAB_0_0_IE_EORD_RANGE                 5:5
#define UART_IER_DLAB_0_0_IE_EORD_WOFFSET                       0x0
#define UART_IER_DLAB_0_0_IE_EORD_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_EORD_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define UART_IER_DLAB_0_0_IE_EORD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_EORD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_EORD_DISABLE                       _MK_ENUM_CONST(0)
#define UART_IER_DLAB_0_0_IE_EORD_ENABLE                        _MK_ENUM_CONST(1)

// Interrupt Enable for Rx FIFO timeout       1 = Enable
#define UART_IER_DLAB_0_0_IE_RX_TIMEOUT_SHIFT                   _MK_SHIFT_CONST(4)
#define UART_IER_DLAB_0_0_IE_RX_TIMEOUT_FIELD                   (_MK_MASK_CONST(0x1) << UART_IER_DLAB_0_0_IE_RX_TIMEOUT_SHIFT)
#define UART_IER_DLAB_0_0_IE_RX_TIMEOUT_RANGE                   4:4
#define UART_IER_DLAB_0_0_IE_RX_TIMEOUT_WOFFSET                 0x0
#define UART_IER_DLAB_0_0_IE_RX_TIMEOUT_DEFAULT                 _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_RX_TIMEOUT_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define UART_IER_DLAB_0_0_IE_RX_TIMEOUT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_RX_TIMEOUT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_RX_TIMEOUT_DISABLE                 _MK_ENUM_CONST(0)
#define UART_IER_DLAB_0_0_IE_RX_TIMEOUT_ENABLE                  _MK_ENUM_CONST(1)

// Interrupt Enable for Modem Status Interrupt 
#define UART_IER_DLAB_0_0_IE_MSI_SHIFT                  _MK_SHIFT_CONST(3)
#define UART_IER_DLAB_0_0_IE_MSI_FIELD                  (_MK_MASK_CONST(0x1) << UART_IER_DLAB_0_0_IE_MSI_SHIFT)
#define UART_IER_DLAB_0_0_IE_MSI_RANGE                  3:3
#define UART_IER_DLAB_0_0_IE_MSI_WOFFSET                        0x0
#define UART_IER_DLAB_0_0_IE_MSI_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_MSI_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define UART_IER_DLAB_0_0_IE_MSI_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_MSI_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_MSI_DISABLE                        _MK_ENUM_CONST(0)
#define UART_IER_DLAB_0_0_IE_MSI_ENABLE                 _MK_ENUM_CONST(1)

// Interrupt Enable for Receiver Line Status Interrupt 
#define UART_IER_DLAB_0_0_IE_RXS_SHIFT                  _MK_SHIFT_CONST(2)
#define UART_IER_DLAB_0_0_IE_RXS_FIELD                  (_MK_MASK_CONST(0x1) << UART_IER_DLAB_0_0_IE_RXS_SHIFT)
#define UART_IER_DLAB_0_0_IE_RXS_RANGE                  2:2
#define UART_IER_DLAB_0_0_IE_RXS_WOFFSET                        0x0
#define UART_IER_DLAB_0_0_IE_RXS_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_RXS_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define UART_IER_DLAB_0_0_IE_RXS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_RXS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_RXS_DISABLE                        _MK_ENUM_CONST(0)
#define UART_IER_DLAB_0_0_IE_RXS_ENABLE                 _MK_ENUM_CONST(1)

// Interrupt Enable for Transmitter Holding Register Empty interrupt 
#define UART_IER_DLAB_0_0_IE_THR_SHIFT                  _MK_SHIFT_CONST(1)
#define UART_IER_DLAB_0_0_IE_THR_FIELD                  (_MK_MASK_CONST(0x1) << UART_IER_DLAB_0_0_IE_THR_SHIFT)
#define UART_IER_DLAB_0_0_IE_THR_RANGE                  1:1
#define UART_IER_DLAB_0_0_IE_THR_WOFFSET                        0x0
#define UART_IER_DLAB_0_0_IE_THR_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_THR_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define UART_IER_DLAB_0_0_IE_THR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_THR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_THR_DISABLE                        _MK_ENUM_CONST(0)
#define UART_IER_DLAB_0_0_IE_THR_ENABLE                 _MK_ENUM_CONST(1)

// Interrupt Enable for Received Data Interrupt 
#define UART_IER_DLAB_0_0_IE_RHR_SHIFT                  _MK_SHIFT_CONST(0)
#define UART_IER_DLAB_0_0_IE_RHR_FIELD                  (_MK_MASK_CONST(0x1) << UART_IER_DLAB_0_0_IE_RHR_SHIFT)
#define UART_IER_DLAB_0_0_IE_RHR_RANGE                  0:0
#define UART_IER_DLAB_0_0_IE_RHR_WOFFSET                        0x0
#define UART_IER_DLAB_0_0_IE_RHR_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_RHR_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define UART_IER_DLAB_0_0_IE_RHR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_RHR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define UART_IER_DLAB_0_0_IE_RHR_DISABLE                        _MK_ENUM_CONST(0)
#define UART_IER_DLAB_0_0_IE_RHR_ENABLE                 _MK_ENUM_CONST(1)


// Register UART_IIR_FCR_0  
#define UART_IIR_FCR_0                  _MK_ADDR_CONST(0x8)
#define UART_IIR_FCR_0_WORD_COUNT                       0x1
#define UART_IIR_FCR_0_RESET_VAL                        _MK_MASK_CONST(0x1)
#define UART_IIR_FCR_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define UART_IIR_FCR_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define UART_IIR_FCR_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
// FIFO Mode Status  0=16450 mode(no FIFO), 1 = 16550 mode(FIFO)
#define UART_IIR_FCR_0_EN_FIFO_SHIFT                    _MK_SHIFT_CONST(6)
#define UART_IIR_FCR_0_EN_FIFO_FIELD                    (_MK_MASK_CONST(0x3) << UART_IIR_FCR_0_EN_FIFO_SHIFT)
#define UART_IIR_FCR_0_EN_FIFO_RANGE                    7:6
#define UART_IIR_FCR_0_EN_FIFO_WOFFSET                  0x0
#define UART_IIR_FCR_0_EN_FIFO_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_EN_FIFO_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define UART_IIR_FCR_0_EN_FIFO_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_EN_FIFO_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_EN_FIFO_MODE_16550                       _MK_ENUM_CONST(1)
#define UART_IIR_FCR_0_EN_FIFO_MODE_16450                       _MK_ENUM_CONST(0)

// Reserved
#define UART_IIR_FCR_0_N_A_SHIFT                        _MK_SHIFT_CONST(4)
#define UART_IIR_FCR_0_N_A_FIELD                        (_MK_MASK_CONST(0x3) << UART_IIR_FCR_0_N_A_SHIFT)
#define UART_IIR_FCR_0_N_A_RANGE                        5:4
#define UART_IIR_FCR_0_N_A_WOFFSET                      0x0
#define UART_IIR_FCR_0_N_A_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_N_A_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define UART_IIR_FCR_0_N_A_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_N_A_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Encoded Interrupt ID   Refer to IIR[3:0] table above
#define UART_IIR_FCR_0_IS_PRI2_SHIFT                    _MK_SHIFT_CONST(3)
#define UART_IIR_FCR_0_IS_PRI2_FIELD                    (_MK_MASK_CONST(0x1) << UART_IIR_FCR_0_IS_PRI2_SHIFT)
#define UART_IIR_FCR_0_IS_PRI2_RANGE                    3:3
#define UART_IIR_FCR_0_IS_PRI2_WOFFSET                  0x0
#define UART_IIR_FCR_0_IS_PRI2_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_IS_PRI2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define UART_IIR_FCR_0_IS_PRI2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_IS_PRI2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_IS_PRI2_DISABLE                  _MK_ENUM_CONST(0)
#define UART_IIR_FCR_0_IS_PRI2_ENABLE                   _MK_ENUM_CONST(1)

// Encoded Interrupt ID   Refer to IIR[3:0] table above
#define UART_IIR_FCR_0_IS_PRI1_SHIFT                    _MK_SHIFT_CONST(2)
#define UART_IIR_FCR_0_IS_PRI1_FIELD                    (_MK_MASK_CONST(0x1) << UART_IIR_FCR_0_IS_PRI1_SHIFT)
#define UART_IIR_FCR_0_IS_PRI1_RANGE                    2:2
#define UART_IIR_FCR_0_IS_PRI1_WOFFSET                  0x0
#define UART_IIR_FCR_0_IS_PRI1_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_IS_PRI1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define UART_IIR_FCR_0_IS_PRI1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_IS_PRI1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_IS_PRI1_DISABLE                  _MK_ENUM_CONST(0)
#define UART_IIR_FCR_0_IS_PRI1_ENABLE                   _MK_ENUM_CONST(1)

// Encoded Interrupt ID   Refer to IIR[3:0] table above
#define UART_IIR_FCR_0_IS_PRI0_SHIFT                    _MK_SHIFT_CONST(1)
#define UART_IIR_FCR_0_IS_PRI0_FIELD                    (_MK_MASK_CONST(0x1) << UART_IIR_FCR_0_IS_PRI0_SHIFT)
#define UART_IIR_FCR_0_IS_PRI0_RANGE                    1:1
#define UART_IIR_FCR_0_IS_PRI0_WOFFSET                  0x0
#define UART_IIR_FCR_0_IS_PRI0_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_IS_PRI0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define UART_IIR_FCR_0_IS_PRI0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_IS_PRI0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_IS_PRI0_DISABLE                  _MK_ENUM_CONST(0)
#define UART_IIR_FCR_0_IS_PRI0_ENABLE                   _MK_ENUM_CONST(1)

// Interrupt Pending if ZERO
#define UART_IIR_FCR_0_IS_STA_SHIFT                     _MK_SHIFT_CONST(0)
#define UART_IIR_FCR_0_IS_STA_FIELD                     (_MK_MASK_CONST(0x1) << UART_IIR_FCR_0_IS_STA_SHIFT)
#define UART_IIR_FCR_0_IS_STA_RANGE                     0:0
#define UART_IIR_FCR_0_IS_STA_WOFFSET                   0x0
#define UART_IIR_FCR_0_IS_STA_DEFAULT                   _MK_MASK_CONST(0x1)
#define UART_IIR_FCR_0_IS_STA_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define UART_IIR_FCR_0_IS_STA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_IS_STA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_IS_STA_INTR_PEND                 _MK_ENUM_CONST(0)
#define UART_IIR_FCR_0_IS_STA_NO_INTR_PEND                      _MK_ENUM_CONST(1)

// 11 = FIFO full count >= 16 
#define UART_IIR_FCR_0_RX_TRIG_SHIFT                    _MK_SHIFT_CONST(6)
#define UART_IIR_FCR_0_RX_TRIG_FIELD                    (_MK_MASK_CONST(0x3) << UART_IIR_FCR_0_RX_TRIG_SHIFT)
#define UART_IIR_FCR_0_RX_TRIG_RANGE                    7:6
#define UART_IIR_FCR_0_RX_TRIG_WOFFSET                  0x0
#define UART_IIR_FCR_0_RX_TRIG_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_RX_TRIG_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define UART_IIR_FCR_0_RX_TRIG_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_RX_TRIG_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_RX_TRIG_FIFO_COUNT_GREATER_1                     _MK_ENUM_CONST(0)
#define UART_IIR_FCR_0_RX_TRIG_FIFO_COUNT_GREATER_4                     _MK_ENUM_CONST(1)
#define UART_IIR_FCR_0_RX_TRIG_FIFO_COUNT_GREATER_8                     _MK_ENUM_CONST(2)
#define UART_IIR_FCR_0_RX_TRIG_FIFO_COUNT_GREATER_12                    _MK_ENUM_CONST(3)

// 11 = FIFO empty count >= 16 
#define UART_IIR_FCR_0_TX_TRIG_SHIFT                    _MK_SHIFT_CONST(4)
#define UART_IIR_FCR_0_TX_TRIG_FIELD                    (_MK_MASK_CONST(0x3) << UART_IIR_FCR_0_TX_TRIG_SHIFT)
#define UART_IIR_FCR_0_TX_TRIG_RANGE                    5:4
#define UART_IIR_FCR_0_TX_TRIG_WOFFSET                  0x0
#define UART_IIR_FCR_0_TX_TRIG_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_TX_TRIG_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define UART_IIR_FCR_0_TX_TRIG_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_TX_TRIG_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_TX_TRIG_FIFO_COUNT_GREATER_1                     _MK_ENUM_CONST(0)
#define UART_IIR_FCR_0_TX_TRIG_FIFO_COUNT_GREATER_4                     _MK_ENUM_CONST(1)
#define UART_IIR_FCR_0_TX_TRIG_FIFO_COUNT_GREATER_8                     _MK_ENUM_CONST(2)
#define UART_IIR_FCR_0_TX_TRIG_FIFO_COUNT_GREATER_12                    _MK_ENUM_CONST(3)

// 0:DMA_Mode_0     1:DMA_MODE_1
#define UART_IIR_FCR_0_DMA_SHIFT                        _MK_SHIFT_CONST(3)
#define UART_IIR_FCR_0_DMA_FIELD                        (_MK_MASK_CONST(0x1) << UART_IIR_FCR_0_DMA_SHIFT)
#define UART_IIR_FCR_0_DMA_RANGE                        3:3
#define UART_IIR_FCR_0_DMA_WOFFSET                      0x0
#define UART_IIR_FCR_0_DMA_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_DMA_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define UART_IIR_FCR_0_DMA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_DMA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_DMA_NO_CHANGE                    _MK_ENUM_CONST(0)
#define UART_IIR_FCR_0_DMA_CHANGE                       _MK_ENUM_CONST(1)

// 1 = Clears the contents of the transmit FIFO and  resets its counter logic to 0 (the transmit shift register is not cleared or  altered). This bit returns to 0 after clearing the FIFOs.
#define UART_IIR_FCR_0_TX_CLR_SHIFT                     _MK_SHIFT_CONST(2)
#define UART_IIR_FCR_0_TX_CLR_FIELD                     (_MK_MASK_CONST(0x1) << UART_IIR_FCR_0_TX_CLR_SHIFT)
#define UART_IIR_FCR_0_TX_CLR_RANGE                     2:2
#define UART_IIR_FCR_0_TX_CLR_WOFFSET                   0x0
#define UART_IIR_FCR_0_TX_CLR_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_TX_CLR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define UART_IIR_FCR_0_TX_CLR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_TX_CLR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_TX_CLR_NO_CLEAR                  _MK_ENUM_CONST(0)
#define UART_IIR_FCR_0_TX_CLR_CLEAR                     _MK_ENUM_CONST(1)

// 1 = Clears the contents of the receive FIFO and  resets its counter logic to 0 (the receive shift register is not cleared or  altered). This bit returns to 0 after clearing the FIFOs.
#define UART_IIR_FCR_0_RX_CLR_SHIFT                     _MK_SHIFT_CONST(1)
#define UART_IIR_FCR_0_RX_CLR_FIELD                     (_MK_MASK_CONST(0x1) << UART_IIR_FCR_0_RX_CLR_SHIFT)
#define UART_IIR_FCR_0_RX_CLR_RANGE                     1:1
#define UART_IIR_FCR_0_RX_CLR_WOFFSET                   0x0
#define UART_IIR_FCR_0_RX_CLR_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_RX_CLR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define UART_IIR_FCR_0_RX_CLR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_RX_CLR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_RX_CLR_NO_CLEAR                  _MK_ENUM_CONST(0)
#define UART_IIR_FCR_0_RX_CLR_CLEAR                     _MK_ENUM_CONST(1)

// 1 = Enable the transmit and receive FIFO. This  bit should be enabled
#define UART_IIR_FCR_0_FCR_EN_FIFO_SHIFT                        _MK_SHIFT_CONST(0)
#define UART_IIR_FCR_0_FCR_EN_FIFO_FIELD                        (_MK_MASK_CONST(0x1) << UART_IIR_FCR_0_FCR_EN_FIFO_SHIFT)
#define UART_IIR_FCR_0_FCR_EN_FIFO_RANGE                        0:0
#define UART_IIR_FCR_0_FCR_EN_FIFO_WOFFSET                      0x0
#define UART_IIR_FCR_0_FCR_EN_FIFO_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_FCR_EN_FIFO_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define UART_IIR_FCR_0_FCR_EN_FIFO_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_FCR_EN_FIFO_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define UART_IIR_FCR_0_FCR_EN_FIFO_DISABLE                      _MK_ENUM_CONST(0)
#define UART_IIR_FCR_0_FCR_EN_FIFO_ENABLE                       _MK_ENUM_CONST(1)


// Register UART_LCR_0  
#define UART_LCR_0                      _MK_ADDR_CONST(0xc)
#define UART_LCR_0_WORD_COUNT                   0x1
#define UART_LCR_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define UART_LCR_0_RESET_MASK                   _MK_MASK_CONST(0xff)
#define UART_LCR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define UART_LCR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define UART_LCR_0_READ_MASK                    _MK_MASK_CONST(0xff)
#define UART_LCR_0_WRITE_MASK                   _MK_MASK_CONST(0xff)
// Divisor Latch Access Bit (set to allow programming of the DLH,DLM Divisors)
#define UART_LCR_0_DLAB_SHIFT                   _MK_SHIFT_CONST(7)
#define UART_LCR_0_DLAB_FIELD                   (_MK_MASK_CONST(0x1) << UART_LCR_0_DLAB_SHIFT)
#define UART_LCR_0_DLAB_RANGE                   7:7
#define UART_LCR_0_DLAB_WOFFSET                 0x0
#define UART_LCR_0_DLAB_DEFAULT                 _MK_MASK_CONST(0x0)
#define UART_LCR_0_DLAB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define UART_LCR_0_DLAB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_LCR_0_DLAB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define UART_LCR_0_DLAB_DISABLE                 _MK_ENUM_CONST(0)
#define UART_LCR_0_DLAB_ENABLE                  _MK_ENUM_CONST(1)

// Set BREAK condition -- Transmitter will send all zeroes to indicate BREAK
#define UART_LCR_0_SET_B_SHIFT                  _MK_SHIFT_CONST(6)
#define UART_LCR_0_SET_B_FIELD                  (_MK_MASK_CONST(0x1) << UART_LCR_0_SET_B_SHIFT)
#define UART_LCR_0_SET_B_RANGE                  6:6
#define UART_LCR_0_SET_B_WOFFSET                        0x0
#define UART_LCR_0_SET_B_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_LCR_0_SET_B_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define UART_LCR_0_SET_B_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define UART_LCR_0_SET_B_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define UART_LCR_0_SET_B_NO_BREAK                       _MK_ENUM_CONST(0)
#define UART_LCR_0_SET_B_BREAK                  _MK_ENUM_CONST(1)

// Set (force) parity to value in LCR [4]
#define UART_LCR_0_SET_P_SHIFT                  _MK_SHIFT_CONST(5)
#define UART_LCR_0_SET_P_FIELD                  (_MK_MASK_CONST(0x1) << UART_LCR_0_SET_P_SHIFT)
#define UART_LCR_0_SET_P_RANGE                  5:5
#define UART_LCR_0_SET_P_WOFFSET                        0x0
#define UART_LCR_0_SET_P_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_LCR_0_SET_P_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define UART_LCR_0_SET_P_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define UART_LCR_0_SET_P_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define UART_LCR_0_SET_P_NO_PARITY                      _MK_ENUM_CONST(0)
#define UART_LCR_0_SET_P_PARITY                 _MK_ENUM_CONST(1)

// Even parity format. There will always be an even  number of 1s in the binary representation (PAR = 1)
#define UART_LCR_0_EVEN_SHIFT                   _MK_SHIFT_CONST(4)
#define UART_LCR_0_EVEN_FIELD                   (_MK_MASK_CONST(0x1) << UART_LCR_0_EVEN_SHIFT)
#define UART_LCR_0_EVEN_RANGE                   4:4
#define UART_LCR_0_EVEN_WOFFSET                 0x0
#define UART_LCR_0_EVEN_DEFAULT                 _MK_MASK_CONST(0x0)
#define UART_LCR_0_EVEN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define UART_LCR_0_EVEN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_LCR_0_EVEN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define UART_LCR_0_EVEN_DISABLE                 _MK_ENUM_CONST(0)
#define UART_LCR_0_EVEN_ENABLE                  _MK_ENUM_CONST(1)

// 0 = No parity sent
#define UART_LCR_0_PAR_SHIFT                    _MK_SHIFT_CONST(3)
#define UART_LCR_0_PAR_FIELD                    (_MK_MASK_CONST(0x1) << UART_LCR_0_PAR_SHIFT)
#define UART_LCR_0_PAR_RANGE                    3:3
#define UART_LCR_0_PAR_WOFFSET                  0x0
#define UART_LCR_0_PAR_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_LCR_0_PAR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define UART_LCR_0_PAR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_LCR_0_PAR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define UART_LCR_0_PAR_NO_PARITY                        _MK_ENUM_CONST(0)
#define UART_LCR_0_PAR_PARITY                   _MK_ENUM_CONST(1)

// 0 = Transmit 1 stop bit, 1 = Transmit 2 stop bits (receiver always checks for 1 stop bit)
#define UART_LCR_0_STOP_SHIFT                   _MK_SHIFT_CONST(2)
#define UART_LCR_0_STOP_FIELD                   (_MK_MASK_CONST(0x1) << UART_LCR_0_STOP_SHIFT)
#define UART_LCR_0_STOP_RANGE                   2:2
#define UART_LCR_0_STOP_WOFFSET                 0x0
#define UART_LCR_0_STOP_DEFAULT                 _MK_MASK_CONST(0x0)
#define UART_LCR_0_STOP_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define UART_LCR_0_STOP_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_LCR_0_STOP_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define UART_LCR_0_STOP_DISABLE                 _MK_ENUM_CONST(0)
#define UART_LCR_0_STOP_ENABLE                  _MK_ENUM_CONST(1)

// 3=Word length of 8
#define UART_LCR_0_WD_SIZE_SHIFT                        _MK_SHIFT_CONST(0)
#define UART_LCR_0_WD_SIZE_FIELD                        (_MK_MASK_CONST(0x3) << UART_LCR_0_WD_SIZE_SHIFT)
#define UART_LCR_0_WD_SIZE_RANGE                        1:0
#define UART_LCR_0_WD_SIZE_WOFFSET                      0x0
#define UART_LCR_0_WD_SIZE_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_LCR_0_WD_SIZE_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define UART_LCR_0_WD_SIZE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_LCR_0_WD_SIZE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define UART_LCR_0_WD_SIZE_WORD_LENGTH_5                        _MK_ENUM_CONST(0)
#define UART_LCR_0_WD_SIZE_WORD_LENGTH_6                        _MK_ENUM_CONST(1)
#define UART_LCR_0_WD_SIZE_WORD_LENGTH_7                        _MK_ENUM_CONST(2)
#define UART_LCR_0_WD_SIZE_WORD_LENGTH_8                        _MK_ENUM_CONST(3)


// Register UART_MCR_0  
#define UART_MCR_0                      _MK_ADDR_CONST(0x10)
#define UART_MCR_0_WORD_COUNT                   0x1
#define UART_MCR_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define UART_MCR_0_RESET_MASK                   _MK_MASK_CONST(0xff)
#define UART_MCR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define UART_MCR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define UART_MCR_0_READ_MASK                    _MK_MASK_CONST(0xff)
#define UART_MCR_0_WRITE_MASK                   _MK_MASK_CONST(0xff)
// Reserved
#define UART_MCR_0_N_A_SHIFT                    _MK_SHIFT_CONST(7)
#define UART_MCR_0_N_A_FIELD                    (_MK_MASK_CONST(0x1) << UART_MCR_0_N_A_SHIFT)
#define UART_MCR_0_N_A_RANGE                    7:7
#define UART_MCR_0_N_A_WOFFSET                  0x0
#define UART_MCR_0_N_A_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_MCR_0_N_A_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define UART_MCR_0_N_A_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_MCR_0_N_A_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// 1 = Enable RTS Hardware Flow Control
#define UART_MCR_0_RTS_EN_SHIFT                 _MK_SHIFT_CONST(6)
#define UART_MCR_0_RTS_EN_FIELD                 (_MK_MASK_CONST(0x1) << UART_MCR_0_RTS_EN_SHIFT)
#define UART_MCR_0_RTS_EN_RANGE                 6:6
#define UART_MCR_0_RTS_EN_WOFFSET                       0x0
#define UART_MCR_0_RTS_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_MCR_0_RTS_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define UART_MCR_0_RTS_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define UART_MCR_0_RTS_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define UART_MCR_0_RTS_EN_DISABLE                       _MK_ENUM_CONST(0)
#define UART_MCR_0_RTS_EN_ENABLE                        _MK_ENUM_CONST(1)

// 1 = Enable CTS Hardware Flow Control
#define UART_MCR_0_CTS_EN_SHIFT                 _MK_SHIFT_CONST(5)
#define UART_MCR_0_CTS_EN_FIELD                 (_MK_MASK_CONST(0x1) << UART_MCR_0_CTS_EN_SHIFT)
#define UART_MCR_0_CTS_EN_RANGE                 5:5
#define UART_MCR_0_CTS_EN_WOFFSET                       0x0
#define UART_MCR_0_CTS_EN_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_MCR_0_CTS_EN_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define UART_MCR_0_CTS_EN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define UART_MCR_0_CTS_EN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define UART_MCR_0_CTS_EN_DISABLE                       _MK_ENUM_CONST(0)
#define UART_MCR_0_CTS_EN_ENABLE                        _MK_ENUM_CONST(1)

// 1 = enable internal loop back of Serial Out to In
#define UART_MCR_0_LOOPBK_SHIFT                 _MK_SHIFT_CONST(4)
#define UART_MCR_0_LOOPBK_FIELD                 (_MK_MASK_CONST(0x1) << UART_MCR_0_LOOPBK_SHIFT)
#define UART_MCR_0_LOOPBK_RANGE                 4:4
#define UART_MCR_0_LOOPBK_WOFFSET                       0x0
#define UART_MCR_0_LOOPBK_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_MCR_0_LOOPBK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define UART_MCR_0_LOOPBK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define UART_MCR_0_LOOPBK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define UART_MCR_0_LOOPBK_DISABLE                       _MK_ENUM_CONST(0)
#define UART_MCR_0_LOOPBK_ENABLE                        _MK_ENUM_CONST(1)

// nOUT2  (Not Used)
#define UART_MCR_0_OUT2_SHIFT                   _MK_SHIFT_CONST(3)
#define UART_MCR_0_OUT2_FIELD                   (_MK_MASK_CONST(0x1) << UART_MCR_0_OUT2_SHIFT)
#define UART_MCR_0_OUT2_RANGE                   3:3
#define UART_MCR_0_OUT2_WOFFSET                 0x0
#define UART_MCR_0_OUT2_DEFAULT                 _MK_MASK_CONST(0x0)
#define UART_MCR_0_OUT2_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define UART_MCR_0_OUT2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_MCR_0_OUT2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define UART_MCR_0_OUT2_DISABLE                 _MK_ENUM_CONST(0)
#define UART_MCR_0_OUT2_ENABLE                  _MK_ENUM_CONST(1)

// nOUT1  (Not Used)
#define UART_MCR_0_OUT1_SHIFT                   _MK_SHIFT_CONST(2)
#define UART_MCR_0_OUT1_FIELD                   (_MK_MASK_CONST(0x1) << UART_MCR_0_OUT1_SHIFT)
#define UART_MCR_0_OUT1_RANGE                   2:2
#define UART_MCR_0_OUT1_WOFFSET                 0x0
#define UART_MCR_0_OUT1_DEFAULT                 _MK_MASK_CONST(0x0)
#define UART_MCR_0_OUT1_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define UART_MCR_0_OUT1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_MCR_0_OUT1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define UART_MCR_0_OUT1_DISABLE                 _MK_ENUM_CONST(0)
#define UART_MCR_0_OUT1_ENABLE                  _MK_ENUM_CONST(1)

// 0 = Force RTS to high if RTS HW flow control not enabled
#define UART_MCR_0_RTS_SHIFT                    _MK_SHIFT_CONST(1)
#define UART_MCR_0_RTS_FIELD                    (_MK_MASK_CONST(0x1) << UART_MCR_0_RTS_SHIFT)
#define UART_MCR_0_RTS_RANGE                    1:1
#define UART_MCR_0_RTS_WOFFSET                  0x0
#define UART_MCR_0_RTS_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_MCR_0_RTS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define UART_MCR_0_RTS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_MCR_0_RTS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define UART_MCR_0_RTS_FORCE_RTS_HI                     _MK_ENUM_CONST(0)
#define UART_MCR_0_RTS_FORCE_RTS_LOW                    _MK_ENUM_CONST(1)

// 1 = Force DTR to high
#define UART_MCR_0_DTR_SHIFT                    _MK_SHIFT_CONST(0)
#define UART_MCR_0_DTR_FIELD                    (_MK_MASK_CONST(0x1) << UART_MCR_0_DTR_SHIFT)
#define UART_MCR_0_DTR_RANGE                    0:0
#define UART_MCR_0_DTR_WOFFSET                  0x0
#define UART_MCR_0_DTR_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_MCR_0_DTR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define UART_MCR_0_DTR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_MCR_0_DTR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define UART_MCR_0_DTR_FORCE_DTR_HI                     _MK_ENUM_CONST(0)
#define UART_MCR_0_DTR_FORCE_DTR_LOW                    _MK_ENUM_CONST(1)


// Register UART_LSR_0  
#define UART_LSR_0                      _MK_ADDR_CONST(0x14)
#define UART_LSR_0_WORD_COUNT                   0x1
#define UART_LSR_0_RESET_VAL                    _MK_MASK_CONST(0x60)
#define UART_LSR_0_RESET_MASK                   _MK_MASK_CONST(0xff)
#define UART_LSR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define UART_LSR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define UART_LSR_0_READ_MASK                    _MK_MASK_CONST(0xff)
#define UART_LSR_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
// 1 = Receive FIFO Error
#define UART_LSR_0_FIFOE_SHIFT                  _MK_SHIFT_CONST(7)
#define UART_LSR_0_FIFOE_FIELD                  (_MK_MASK_CONST(0x1) << UART_LSR_0_FIFOE_SHIFT)
#define UART_LSR_0_FIFOE_RANGE                  7:7
#define UART_LSR_0_FIFOE_WOFFSET                        0x0
#define UART_LSR_0_FIFOE_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_LSR_0_FIFOE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define UART_LSR_0_FIFOE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define UART_LSR_0_FIFOE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define UART_LSR_0_FIFOE_NO_ERR                 _MK_ENUM_CONST(0)
#define UART_LSR_0_FIFOE_ERR                    _MK_ENUM_CONST(1)

// Transmit Shift Reg empty status
#define UART_LSR_0_TMTY_SHIFT                   _MK_SHIFT_CONST(6)
#define UART_LSR_0_TMTY_FIELD                   (_MK_MASK_CONST(0x1) << UART_LSR_0_TMTY_SHIFT)
#define UART_LSR_0_TMTY_RANGE                   6:6
#define UART_LSR_0_TMTY_WOFFSET                 0x0
#define UART_LSR_0_TMTY_DEFAULT                 _MK_MASK_CONST(0x1)
#define UART_LSR_0_TMTY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define UART_LSR_0_TMTY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_LSR_0_TMTY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define UART_LSR_0_TMTY_NO_EMPTY                        _MK_ENUM_CONST(0)
#define UART_LSR_0_TMTY_EMPTY                   _MK_ENUM_CONST(1)

// 1 = Transmit Holding Register is  Empty -- OK to write data
#define UART_LSR_0_THRE_SHIFT                   _MK_SHIFT_CONST(5)
#define UART_LSR_0_THRE_FIELD                   (_MK_MASK_CONST(0x1) << UART_LSR_0_THRE_SHIFT)
#define UART_LSR_0_THRE_RANGE                   5:5
#define UART_LSR_0_THRE_WOFFSET                 0x0
#define UART_LSR_0_THRE_DEFAULT                 _MK_MASK_CONST(0x1)
#define UART_LSR_0_THRE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define UART_LSR_0_THRE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_LSR_0_THRE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define UART_LSR_0_THRE_FULL                    _MK_ENUM_CONST(0)
#define UART_LSR_0_THRE_EMPTY                   _MK_ENUM_CONST(1)

// 1 = BREAK condition detected on line
#define UART_LSR_0_BRK_SHIFT                    _MK_SHIFT_CONST(4)
#define UART_LSR_0_BRK_FIELD                    (_MK_MASK_CONST(0x1) << UART_LSR_0_BRK_SHIFT)
#define UART_LSR_0_BRK_RANGE                    4:4
#define UART_LSR_0_BRK_WOFFSET                  0x0
#define UART_LSR_0_BRK_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_LSR_0_BRK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define UART_LSR_0_BRK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_LSR_0_BRK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define UART_LSR_0_BRK_NO_BREAK                 _MK_ENUM_CONST(0)
#define UART_LSR_0_BRK_BREAK                    _MK_ENUM_CONST(1)

// 1 = Framing Errpr
#define UART_LSR_0_FERR_SHIFT                   _MK_SHIFT_CONST(3)
#define UART_LSR_0_FERR_FIELD                   (_MK_MASK_CONST(0x1) << UART_LSR_0_FERR_SHIFT)
#define UART_LSR_0_FERR_RANGE                   3:3
#define UART_LSR_0_FERR_WOFFSET                 0x0
#define UART_LSR_0_FERR_DEFAULT                 _MK_MASK_CONST(0x0)
#define UART_LSR_0_FERR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define UART_LSR_0_FERR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_LSR_0_FERR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define UART_LSR_0_FERR_NO_FRAME_ERR                    _MK_ENUM_CONST(0)
#define UART_LSR_0_FERR_FRAME_ERR                       _MK_ENUM_CONST(1)

// 1 = Parity Error
#define UART_LSR_0_PERR_SHIFT                   _MK_SHIFT_CONST(2)
#define UART_LSR_0_PERR_FIELD                   (_MK_MASK_CONST(0x1) << UART_LSR_0_PERR_SHIFT)
#define UART_LSR_0_PERR_RANGE                   2:2
#define UART_LSR_0_PERR_WOFFSET                 0x0
#define UART_LSR_0_PERR_DEFAULT                 _MK_MASK_CONST(0x0)
#define UART_LSR_0_PERR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define UART_LSR_0_PERR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_LSR_0_PERR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define UART_LSR_0_PERR_NO_PARITY_ERR                   _MK_ENUM_CONST(0)
#define UART_LSR_0_PERR_PARITY_ERR                      _MK_ENUM_CONST(1)

// 1 = Receiver Overrun Error
#define UART_LSR_0_OVRF_SHIFT                   _MK_SHIFT_CONST(1)
#define UART_LSR_0_OVRF_FIELD                   (_MK_MASK_CONST(0x1) << UART_LSR_0_OVRF_SHIFT)
#define UART_LSR_0_OVRF_RANGE                   1:1
#define UART_LSR_0_OVRF_WOFFSET                 0x0
#define UART_LSR_0_OVRF_DEFAULT                 _MK_MASK_CONST(0x0)
#define UART_LSR_0_OVRF_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define UART_LSR_0_OVRF_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_LSR_0_OVRF_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define UART_LSR_0_OVRF_NO_OVERRUN_ERROR                        _MK_ENUM_CONST(0)
#define UART_LSR_0_OVRF_OVERRUN_ERROR                   _MK_ENUM_CONST(1)

// 1 = Receiver Data Ready (Data available to read)
#define UART_LSR_0_RDR_SHIFT                    _MK_SHIFT_CONST(0)
#define UART_LSR_0_RDR_FIELD                    (_MK_MASK_CONST(0x1) << UART_LSR_0_RDR_SHIFT)
#define UART_LSR_0_RDR_RANGE                    0:0
#define UART_LSR_0_RDR_WOFFSET                  0x0
#define UART_LSR_0_RDR_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_LSR_0_RDR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define UART_LSR_0_RDR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_LSR_0_RDR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define UART_LSR_0_RDR_NO_DATA_IN_FIFO                  _MK_ENUM_CONST(0)
#define UART_LSR_0_RDR_DATA_IN_FIFO                     _MK_ENUM_CONST(1)


// Register UART_MSR_0  
#define UART_MSR_0                      _MK_ADDR_CONST(0x18)
#define UART_MSR_0_WORD_COUNT                   0x1
#define UART_MSR_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define UART_MSR_0_RESET_MASK                   _MK_MASK_CONST(0xff)
#define UART_MSR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define UART_MSR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define UART_MSR_0_READ_MASK                    _MK_MASK_CONST(0xff)
#define UART_MSR_0_WRITE_MASK                   _MK_MASK_CONST(0xff)
// State of Carrier detect pin
#define UART_MSR_0_CD_SHIFT                     _MK_SHIFT_CONST(7)
#define UART_MSR_0_CD_FIELD                     (_MK_MASK_CONST(0x1) << UART_MSR_0_CD_SHIFT)
#define UART_MSR_0_CD_RANGE                     7:7
#define UART_MSR_0_CD_WOFFSET                   0x0
#define UART_MSR_0_CD_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_MSR_0_CD_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define UART_MSR_0_CD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_MSR_0_CD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define UART_MSR_0_CD_DISABLE                   _MK_ENUM_CONST(0)
#define UART_MSR_0_CD_ENABLE                    _MK_ENUM_CONST(1)

// State of Ring Indicator pin
#define UART_MSR_0_RI_SHIFT                     _MK_SHIFT_CONST(6)
#define UART_MSR_0_RI_FIELD                     (_MK_MASK_CONST(0x1) << UART_MSR_0_RI_SHIFT)
#define UART_MSR_0_RI_RANGE                     6:6
#define UART_MSR_0_RI_WOFFSET                   0x0
#define UART_MSR_0_RI_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_MSR_0_RI_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define UART_MSR_0_RI_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_MSR_0_RI_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define UART_MSR_0_RI_DISABLE                   _MK_ENUM_CONST(0)
#define UART_MSR_0_RI_ENABLE                    _MK_ENUM_CONST(1)

// State of Data set ready pin
#define UART_MSR_0_DSR_SHIFT                    _MK_SHIFT_CONST(5)
#define UART_MSR_0_DSR_FIELD                    (_MK_MASK_CONST(0x1) << UART_MSR_0_DSR_SHIFT)
#define UART_MSR_0_DSR_RANGE                    5:5
#define UART_MSR_0_DSR_WOFFSET                  0x0
#define UART_MSR_0_DSR_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_MSR_0_DSR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define UART_MSR_0_DSR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_MSR_0_DSR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define UART_MSR_0_DSR_DISABLE                  _MK_ENUM_CONST(0)
#define UART_MSR_0_DSR_ENABLE                   _MK_ENUM_CONST(1)

// State of Clear to send pin
#define UART_MSR_0_CTS_SHIFT                    _MK_SHIFT_CONST(4)
#define UART_MSR_0_CTS_FIELD                    (_MK_MASK_CONST(0x1) << UART_MSR_0_CTS_SHIFT)
#define UART_MSR_0_CTS_RANGE                    4:4
#define UART_MSR_0_CTS_WOFFSET                  0x0
#define UART_MSR_0_CTS_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_MSR_0_CTS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define UART_MSR_0_CTS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_MSR_0_CTS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define UART_MSR_0_CTS_DISABLE                  _MK_ENUM_CONST(0)
#define UART_MSR_0_CTS_ENABLE                   _MK_ENUM_CONST(1)

// Change (Delta) in CD state detected 
#define UART_MSR_0_DCD_SHIFT                    _MK_SHIFT_CONST(3)
#define UART_MSR_0_DCD_FIELD                    (_MK_MASK_CONST(0x1) << UART_MSR_0_DCD_SHIFT)
#define UART_MSR_0_DCD_RANGE                    3:3
#define UART_MSR_0_DCD_WOFFSET                  0x0
#define UART_MSR_0_DCD_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_MSR_0_DCD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define UART_MSR_0_DCD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_MSR_0_DCD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define UART_MSR_0_DCD_DISABLE                  _MK_ENUM_CONST(0)
#define UART_MSR_0_DCD_ENABLE                   _MK_ENUM_CONST(1)

// Change (Delta) in RI state detected
#define UART_MSR_0_DRI_SHIFT                    _MK_SHIFT_CONST(2)
#define UART_MSR_0_DRI_FIELD                    (_MK_MASK_CONST(0x1) << UART_MSR_0_DRI_SHIFT)
#define UART_MSR_0_DRI_RANGE                    2:2
#define UART_MSR_0_DRI_WOFFSET                  0x0
#define UART_MSR_0_DRI_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_MSR_0_DRI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define UART_MSR_0_DRI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_MSR_0_DRI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define UART_MSR_0_DRI_DISABLE                  _MK_ENUM_CONST(0)
#define UART_MSR_0_DRI_ENABLE                   _MK_ENUM_CONST(1)

// Change (Delta) in DSR state detected
#define UART_MSR_0_DDSR_SHIFT                   _MK_SHIFT_CONST(1)
#define UART_MSR_0_DDSR_FIELD                   (_MK_MASK_CONST(0x1) << UART_MSR_0_DDSR_SHIFT)
#define UART_MSR_0_DDSR_RANGE                   1:1
#define UART_MSR_0_DDSR_WOFFSET                 0x0
#define UART_MSR_0_DDSR_DEFAULT                 _MK_MASK_CONST(0x0)
#define UART_MSR_0_DDSR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define UART_MSR_0_DDSR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_MSR_0_DDSR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define UART_MSR_0_DDSR_DISABLE                 _MK_ENUM_CONST(0)
#define UART_MSR_0_DDSR_ENABLE                  _MK_ENUM_CONST(1)

// Change (Delta) in CTS state detected
#define UART_MSR_0_DCTS_SHIFT                   _MK_SHIFT_CONST(0)
#define UART_MSR_0_DCTS_FIELD                   (_MK_MASK_CONST(0x1) << UART_MSR_0_DCTS_SHIFT)
#define UART_MSR_0_DCTS_RANGE                   0:0
#define UART_MSR_0_DCTS_WOFFSET                 0x0
#define UART_MSR_0_DCTS_DEFAULT                 _MK_MASK_CONST(0x0)
#define UART_MSR_0_DCTS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define UART_MSR_0_DCTS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_MSR_0_DCTS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define UART_MSR_0_DCTS_DISABLE                 _MK_ENUM_CONST(0)
#define UART_MSR_0_DCTS_ENABLE                  _MK_ENUM_CONST(1)


// Register UART_SPR_0  
#define UART_SPR_0                      _MK_ADDR_CONST(0x1c)
#define UART_SPR_0_WORD_COUNT                   0x1
#define UART_SPR_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define UART_SPR_0_RESET_MASK                   _MK_MASK_CONST(0xff)
#define UART_SPR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define UART_SPR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define UART_SPR_0_READ_MASK                    _MK_MASK_CONST(0xff)
#define UART_SPR_0_WRITE_MASK                   _MK_MASK_CONST(0xff)
// Scratchpad register (not used internally) 
#define UART_SPR_0_SPR_A_SHIFT                  _MK_SHIFT_CONST(0)
#define UART_SPR_0_SPR_A_FIELD                  (_MK_MASK_CONST(0xff) << UART_SPR_0_SPR_A_SHIFT)
#define UART_SPR_0_SPR_A_RANGE                  7:0
#define UART_SPR_0_SPR_A_WOFFSET                        0x0
#define UART_SPR_0_SPR_A_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_SPR_0_SPR_A_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define UART_SPR_0_SPR_A_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define UART_SPR_0_SPR_A_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register UART_IRDA_CSR_0  
#define UART_IRDA_CSR_0                 _MK_ADDR_CONST(0x20)
#define UART_IRDA_CSR_0_WORD_COUNT                      0x1
#define UART_IRDA_CSR_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_RESET_MASK                      _MK_MASK_CONST(0xff)
#define UART_IRDA_CSR_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define UART_IRDA_CSR_0_WRITE_MASK                      _MK_MASK_CONST(0xff)
//  1 = Enable SIR coder 0 = Disable  SIR coder
#define UART_IRDA_CSR_0_SIR_A_SHIFT                     _MK_SHIFT_CONST(7)
#define UART_IRDA_CSR_0_SIR_A_FIELD                     (_MK_MASK_CONST(0x1) << UART_IRDA_CSR_0_SIR_A_SHIFT)
#define UART_IRDA_CSR_0_SIR_A_RANGE                     7:7
#define UART_IRDA_CSR_0_SIR_A_WOFFSET                   0x0
#define UART_IRDA_CSR_0_SIR_A_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_SIR_A_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define UART_IRDA_CSR_0_SIR_A_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_SIR_A_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_SIR_A_DISABLE                   _MK_ENUM_CONST(0)
#define UART_IRDA_CSR_0_SIR_A_ENABLE                    _MK_ENUM_CONST(1)

// 0=3/16th Baud Pulse, 1=4/16
#define UART_IRDA_CSR_0_PWT_A_SHIFT                     _MK_SHIFT_CONST(6)
#define UART_IRDA_CSR_0_PWT_A_FIELD                     (_MK_MASK_CONST(0x1) << UART_IRDA_CSR_0_PWT_A_SHIFT)
#define UART_IRDA_CSR_0_PWT_A_RANGE                     6:6
#define UART_IRDA_CSR_0_PWT_A_WOFFSET                   0x0
#define UART_IRDA_CSR_0_PWT_A_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_PWT_A_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define UART_IRDA_CSR_0_PWT_A_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_PWT_A_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_PWT_A_BAUD_PULSE_3_14                   _MK_ENUM_CONST(0)
#define UART_IRDA_CSR_0_PWT_A_BAUD_PULSE_4_14                   _MK_ENUM_CONST(1)

// Reserved = 0
#define UART_IRDA_CSR_0_N_A_SHIFT                       _MK_SHIFT_CONST(4)
#define UART_IRDA_CSR_0_N_A_FIELD                       (_MK_MASK_CONST(0x3) << UART_IRDA_CSR_0_N_A_SHIFT)
#define UART_IRDA_CSR_0_N_A_RANGE                       5:4
#define UART_IRDA_CSR_0_N_A_WOFFSET                     0x0
#define UART_IRDA_CSR_0_N_A_DEFAULT                     _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_N_A_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define UART_IRDA_CSR_0_N_A_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_N_A_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Inverts the normally inactive high nRTS pin
#define UART_IRDA_CSR_0_INVERT_RTS_SHIFT                        _MK_SHIFT_CONST(3)
#define UART_IRDA_CSR_0_INVERT_RTS_FIELD                        (_MK_MASK_CONST(0x1) << UART_IRDA_CSR_0_INVERT_RTS_SHIFT)
#define UART_IRDA_CSR_0_INVERT_RTS_RANGE                        3:3
#define UART_IRDA_CSR_0_INVERT_RTS_WOFFSET                      0x0
#define UART_IRDA_CSR_0_INVERT_RTS_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_INVERT_RTS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define UART_IRDA_CSR_0_INVERT_RTS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_INVERT_RTS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_INVERT_RTS_DISABLE                      _MK_ENUM_CONST(0)
#define UART_IRDA_CSR_0_INVERT_RTS_ENABLE                       _MK_ENUM_CONST(1)

// Inverts the normally inactive high nCTS pin
#define UART_IRDA_CSR_0_INVERT_CTS_SHIFT                        _MK_SHIFT_CONST(2)
#define UART_IRDA_CSR_0_INVERT_CTS_FIELD                        (_MK_MASK_CONST(0x1) << UART_IRDA_CSR_0_INVERT_CTS_SHIFT)
#define UART_IRDA_CSR_0_INVERT_CTS_RANGE                        2:2
#define UART_IRDA_CSR_0_INVERT_CTS_WOFFSET                      0x0
#define UART_IRDA_CSR_0_INVERT_CTS_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_INVERT_CTS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define UART_IRDA_CSR_0_INVERT_CTS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_INVERT_CTS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_INVERT_CTS_DISABLE                      _MK_ENUM_CONST(0)
#define UART_IRDA_CSR_0_INVERT_CTS_ENABLE                       _MK_ENUM_CONST(1)

// Inverts the normally inactive high TXD pin
#define UART_IRDA_CSR_0_INVERT_TXD_SHIFT                        _MK_SHIFT_CONST(1)
#define UART_IRDA_CSR_0_INVERT_TXD_FIELD                        (_MK_MASK_CONST(0x1) << UART_IRDA_CSR_0_INVERT_TXD_SHIFT)
#define UART_IRDA_CSR_0_INVERT_TXD_RANGE                        1:1
#define UART_IRDA_CSR_0_INVERT_TXD_WOFFSET                      0x0
#define UART_IRDA_CSR_0_INVERT_TXD_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_INVERT_TXD_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define UART_IRDA_CSR_0_INVERT_TXD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_INVERT_TXD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_INVERT_TXD_DISABLE                      _MK_ENUM_CONST(0)
#define UART_IRDA_CSR_0_INVERT_TXD_ENABLE                       _MK_ENUM_CONST(1)

// Inverts the normally inactive high RXD pin
#define UART_IRDA_CSR_0_INVERT_RXD_SHIFT                        _MK_SHIFT_CONST(0)
#define UART_IRDA_CSR_0_INVERT_RXD_FIELD                        (_MK_MASK_CONST(0x1) << UART_IRDA_CSR_0_INVERT_RXD_SHIFT)
#define UART_IRDA_CSR_0_INVERT_RXD_RANGE                        0:0
#define UART_IRDA_CSR_0_INVERT_RXD_WOFFSET                      0x0
#define UART_IRDA_CSR_0_INVERT_RXD_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_INVERT_RXD_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define UART_IRDA_CSR_0_INVERT_RXD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_INVERT_RXD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define UART_IRDA_CSR_0_INVERT_RXD_DISABLE                      _MK_ENUM_CONST(0)
#define UART_IRDA_CSR_0_INVERT_RXD_ENABLE                       _MK_ENUM_CONST(1)


// Reserved address 36 [0x24] 

// Reserved address 40 [0x28] 

// Reserved address 44 [0x2c] 

// Reserved address 48 [0x30] 

// Reserved address 52 [0x34] 

// Reserved address 56 [0x38] 

// Register UART_ASR_0  
#define UART_ASR_0                      _MK_ADDR_CONST(0x3c)
#define UART_ASR_0_WORD_COUNT                   0x1
#define UART_ASR_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define UART_ASR_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define UART_ASR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define UART_ASR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define UART_ASR_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define UART_ASR_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
// This bit is set when the controller finishes  counting the clocks between two successive clock edges after there is a write  to ASR with dont care data. 
#define UART_ASR_0_VALID_SHIFT                  _MK_SHIFT_CONST(31)
#define UART_ASR_0_VALID_FIELD                  (_MK_MASK_CONST(0x1) << UART_ASR_0_VALID_SHIFT)
#define UART_ASR_0_VALID_RANGE                  31:31
#define UART_ASR_0_VALID_WOFFSET                        0x0
#define UART_ASR_0_VALID_DEFAULT                        _MK_MASK_CONST(0x0)
#define UART_ASR_0_VALID_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define UART_ASR_0_VALID_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define UART_ASR_0_VALID_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define UART_ASR_0_VALID_UN_SET                 _MK_ENUM_CONST(0)
#define UART_ASR_0_VALID_SET                    _MK_ENUM_CONST(1)

// This bit is set when there is a write to ASR and  is reset when the controller finishes counting the clock edges between two  successive clock edges.
#define UART_ASR_0_BUSY_SHIFT                   _MK_SHIFT_CONST(30)
#define UART_ASR_0_BUSY_FIELD                   (_MK_MASK_CONST(0x1) << UART_ASR_0_BUSY_SHIFT)
#define UART_ASR_0_BUSY_RANGE                   30:30
#define UART_ASR_0_BUSY_WOFFSET                 0x0
#define UART_ASR_0_BUSY_DEFAULT                 _MK_MASK_CONST(0x0)
#define UART_ASR_0_BUSY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define UART_ASR_0_BUSY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_ASR_0_BUSY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define UART_ASR_0_BUSY_NO_BUSY                 _MK_ENUM_CONST(0)
#define UART_ASR_0_BUSY_BUSY                    _MK_ENUM_CONST(1)

// Reserved = 0
#define UART_ASR_0_N_A_SHIFT                    _MK_SHIFT_CONST(16)
#define UART_ASR_0_N_A_FIELD                    (_MK_MASK_CONST(0x3fff) << UART_ASR_0_N_A_SHIFT)
#define UART_ASR_0_N_A_RANGE                    29:16
#define UART_ASR_0_N_A_WOFFSET                  0x0
#define UART_ASR_0_N_A_DEFAULT                  _MK_MASK_CONST(0x0)
#define UART_ASR_0_N_A_DEFAULT_MASK                     _MK_MASK_CONST(0x3fff)
#define UART_ASR_0_N_A_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define UART_ASR_0_N_A_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Shows the bits [15:8] of the count of clock edges  between two successive clock edges.
#define UART_ASR_0_RX_RATE_SENSE_H_SHIFT                        _MK_SHIFT_CONST(8)
#define UART_ASR_0_RX_RATE_SENSE_H_FIELD                        (_MK_MASK_CONST(0xff) << UART_ASR_0_RX_RATE_SENSE_H_SHIFT)
#define UART_ASR_0_RX_RATE_SENSE_H_RANGE                        15:8
#define UART_ASR_0_RX_RATE_SENSE_H_WOFFSET                      0x0
#define UART_ASR_0_RX_RATE_SENSE_H_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_ASR_0_RX_RATE_SENSE_H_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define UART_ASR_0_RX_RATE_SENSE_H_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_ASR_0_RX_RATE_SENSE_H_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Shows the bits[7:0] of the count of clock edges  between two successive clock edges.
#define UART_ASR_0_RX_RATE_SENSE_L_SHIFT                        _MK_SHIFT_CONST(0)
#define UART_ASR_0_RX_RATE_SENSE_L_FIELD                        (_MK_MASK_CONST(0xff) << UART_ASR_0_RX_RATE_SENSE_L_SHIFT)
#define UART_ASR_0_RX_RATE_SENSE_L_RANGE                        7:0
#define UART_ASR_0_RX_RATE_SENSE_L_WOFFSET                      0x0
#define UART_ASR_0_RX_RATE_SENSE_L_DEFAULT                      _MK_MASK_CONST(0x0)
#define UART_ASR_0_RX_RATE_SENSE_L_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define UART_ASR_0_RX_RATE_SENSE_L_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define UART_ASR_0_RX_RATE_SENSE_L_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_ARUART_REGS(_op_) \
_op_(UART_THR_DLAB_0_0) \
_op_(UART_IER_DLAB_0_0) \
_op_(UART_IIR_FCR_0) \
_op_(UART_LCR_0) \
_op_(UART_MCR_0) \
_op_(UART_LSR_0) \
_op_(UART_MSR_0) \
_op_(UART_SPR_0) \
_op_(UART_IRDA_CSR_0) \
_op_(UART_ASR_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_UART       0x00000000

//
// ARUART REGISTER BANKS
//

#define UART0_FIRST_REG 0x0000 // UART_THR_DLAB_0_0
#define UART0_LAST_REG 0x0020 // UART_IRDA_CSR_0
#define UART1_FIRST_REG 0x003c // UART_ASR_0
#define UART1_LAST_REG 0x003c // UART_ASR_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARUART_H_INC_
