/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARMSELECT_H_INC_
#define ___ARMSELECT_H_INC_

// Register MSELECT_CONFIG_0  
#define MSELECT_CONFIG_0                        _MK_ADDR_CONST(0x0)
#define MSELECT_CONFIG_0_WORD_COUNT                     0x1
#define MSELECT_CONFIG_0_RESET_VAL                      _MK_MASK_CONST(0xa8)
#define MSELECT_CONFIG_0_RESET_MASK                     _MK_MASK_CONST(0xff)
#define MSELECT_CONFIG_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define MSELECT_CONFIG_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MSELECT_CONFIG_0_READ_MASK                      _MK_MASK_CONST(0xff)
#define MSELECT_CONFIG_0_WRITE_MASK                     _MK_MASK_CONST(0x1f)
#define MSELECT_CONFIG_0_SAFE_MODE_SHIFT                        _MK_SHIFT_CONST(0)
#define MSELECT_CONFIG_0_SAFE_MODE_FIELD                        (_MK_MASK_CONST(0x1) << MSELECT_CONFIG_0_SAFE_MODE_SHIFT)
#define MSELECT_CONFIG_0_SAFE_MODE_RANGE                        0:0
#define MSELECT_CONFIG_0_SAFE_MODE_WOFFSET                      0x0
#define MSELECT_CONFIG_0_SAFE_MODE_DEFAULT                      _MK_MASK_CONST(0x0)
#define MSELECT_CONFIG_0_SAFE_MODE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MSELECT_CONFIG_0_SAFE_MODE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MSELECT_CONFIG_0_SAFE_MODE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define MSELECT_CONFIG_0_SLOW_MODE_SHIFT                        _MK_SHIFT_CONST(1)
#define MSELECT_CONFIG_0_SLOW_MODE_FIELD                        (_MK_MASK_CONST(0x1) << MSELECT_CONFIG_0_SLOW_MODE_SHIFT)
#define MSELECT_CONFIG_0_SLOW_MODE_RANGE                        1:1
#define MSELECT_CONFIG_0_SLOW_MODE_WOFFSET                      0x0
#define MSELECT_CONFIG_0_SLOW_MODE_DEFAULT                      _MK_MASK_CONST(0x0)
#define MSELECT_CONFIG_0_SLOW_MODE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MSELECT_CONFIG_0_SLOW_MODE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MSELECT_CONFIG_0_SLOW_MODE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define MSELECT_CONFIG_0_SW_COHERENCY_SHIFT                     _MK_SHIFT_CONST(2)
#define MSELECT_CONFIG_0_SW_COHERENCY_FIELD                     (_MK_MASK_CONST(0x1) << MSELECT_CONFIG_0_SW_COHERENCY_SHIFT)
#define MSELECT_CONFIG_0_SW_COHERENCY_RANGE                     2:2
#define MSELECT_CONFIG_0_SW_COHERENCY_WOFFSET                   0x0
#define MSELECT_CONFIG_0_SW_COHERENCY_DEFAULT                   _MK_MASK_CONST(0x0)
#define MSELECT_CONFIG_0_SW_COHERENCY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MSELECT_CONFIG_0_SW_COHERENCY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MSELECT_CONFIG_0_SW_COHERENCY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define MSELECT_CONFIG_0_NON_BUFF_MC_SHIFT                      _MK_SHIFT_CONST(3)
#define MSELECT_CONFIG_0_NON_BUFF_MC_FIELD                      (_MK_MASK_CONST(0x1) << MSELECT_CONFIG_0_NON_BUFF_MC_SHIFT)
#define MSELECT_CONFIG_0_NON_BUFF_MC_RANGE                      3:3
#define MSELECT_CONFIG_0_NON_BUFF_MC_WOFFSET                    0x0
#define MSELECT_CONFIG_0_NON_BUFF_MC_DEFAULT                    _MK_MASK_CONST(0x1)
#define MSELECT_CONFIG_0_NON_BUFF_MC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MSELECT_CONFIG_0_NON_BUFF_MC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MSELECT_CONFIG_0_NON_BUFF_MC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MSELECT_CONFIG_0_ENABLE_PTW_L2_SHIFT                    _MK_SHIFT_CONST(4)
#define MSELECT_CONFIG_0_ENABLE_PTW_L2_FIELD                    (_MK_MASK_CONST(0x1) << MSELECT_CONFIG_0_ENABLE_PTW_L2_SHIFT)
#define MSELECT_CONFIG_0_ENABLE_PTW_L2_RANGE                    4:4
#define MSELECT_CONFIG_0_ENABLE_PTW_L2_WOFFSET                  0x0
#define MSELECT_CONFIG_0_ENABLE_PTW_L2_DEFAULT                  _MK_MASK_CONST(0x0)
#define MSELECT_CONFIG_0_ENABLE_PTW_L2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MSELECT_CONFIG_0_ENABLE_PTW_L2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MSELECT_CONFIG_0_ENABLE_PTW_L2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define MSELECT_CONFIG_0_ENABLE_EMEM_APERTURE_SHIFT                     _MK_SHIFT_CONST(5)
#define MSELECT_CONFIG_0_ENABLE_EMEM_APERTURE_FIELD                     (_MK_MASK_CONST(0x1) << MSELECT_CONFIG_0_ENABLE_EMEM_APERTURE_SHIFT)
#define MSELECT_CONFIG_0_ENABLE_EMEM_APERTURE_RANGE                     5:5
#define MSELECT_CONFIG_0_ENABLE_EMEM_APERTURE_WOFFSET                   0x0
#define MSELECT_CONFIG_0_ENABLE_EMEM_APERTURE_DEFAULT                   _MK_MASK_CONST(0x1)
#define MSELECT_CONFIG_0_ENABLE_EMEM_APERTURE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MSELECT_CONFIG_0_ENABLE_EMEM_APERTURE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MSELECT_CONFIG_0_ENABLE_EMEM_APERTURE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define MSELECT_CONFIG_0_ENABLE_IMEM_APERTURE_SHIFT                     _MK_SHIFT_CONST(6)
#define MSELECT_CONFIG_0_ENABLE_IMEM_APERTURE_FIELD                     (_MK_MASK_CONST(0x1) << MSELECT_CONFIG_0_ENABLE_IMEM_APERTURE_SHIFT)
#define MSELECT_CONFIG_0_ENABLE_IMEM_APERTURE_RANGE                     6:6
#define MSELECT_CONFIG_0_ENABLE_IMEM_APERTURE_WOFFSET                   0x0
#define MSELECT_CONFIG_0_ENABLE_IMEM_APERTURE_DEFAULT                   _MK_MASK_CONST(0x0)
#define MSELECT_CONFIG_0_ENABLE_IMEM_APERTURE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MSELECT_CONFIG_0_ENABLE_IMEM_APERTURE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MSELECT_CONFIG_0_ENABLE_IMEM_APERTURE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define MSELECT_CONFIG_0_ENABLE_GART_APERTURE_SHIFT                     _MK_SHIFT_CONST(7)
#define MSELECT_CONFIG_0_ENABLE_GART_APERTURE_FIELD                     (_MK_MASK_CONST(0x1) << MSELECT_CONFIG_0_ENABLE_GART_APERTURE_SHIFT)
#define MSELECT_CONFIG_0_ENABLE_GART_APERTURE_RANGE                     7:7
#define MSELECT_CONFIG_0_ENABLE_GART_APERTURE_WOFFSET                   0x0
#define MSELECT_CONFIG_0_ENABLE_GART_APERTURE_DEFAULT                   _MK_MASK_CONST(0x1)
#define MSELECT_CONFIG_0_ENABLE_GART_APERTURE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MSELECT_CONFIG_0_ENABLE_GART_APERTURE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MSELECT_CONFIG_0_ENABLE_GART_APERTURE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register MSELECT_PERIPHBASE_0  
#define MSELECT_PERIPHBASE_0                    _MK_ADDR_CONST(0x4)
#define MSELECT_PERIPHBASE_0_WORD_COUNT                         0x1
#define MSELECT_PERIPHBASE_0_RESET_VAL                  _MK_MASK_CONST(0x50040000)
#define MSELECT_PERIPHBASE_0_RESET_MASK                         _MK_MASK_CONST(0xffffe000)
#define MSELECT_PERIPHBASE_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define MSELECT_PERIPHBASE_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MSELECT_PERIPHBASE_0_READ_MASK                  _MK_MASK_CONST(0xffffe000)
#define MSELECT_PERIPHBASE_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define MSELECT_PERIPHBASE_0_ADDR_SHIFT                 _MK_SHIFT_CONST(13)
#define MSELECT_PERIPHBASE_0_ADDR_FIELD                 (_MK_MASK_CONST(0x7ffff) << MSELECT_PERIPHBASE_0_ADDR_SHIFT)
#define MSELECT_PERIPHBASE_0_ADDR_RANGE                 31:13
#define MSELECT_PERIPHBASE_0_ADDR_WOFFSET                       0x0
#define MSELECT_PERIPHBASE_0_ADDR_DEFAULT                       _MK_MASK_CONST(0x28020)
#define MSELECT_PERIPHBASE_0_ADDR_DEFAULT_MASK                  _MK_MASK_CONST(0x7ffff)
#define MSELECT_PERIPHBASE_0_ADDR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MSELECT_PERIPHBASE_0_ADDR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register MSELECT_EMEM_BOM_0  
#define MSELECT_EMEM_BOM_0                      _MK_ADDR_CONST(0x8)
#define MSELECT_EMEM_BOM_0_WORD_COUNT                   0x1
#define MSELECT_EMEM_BOM_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define MSELECT_EMEM_BOM_0_RESET_MASK                   _MK_MASK_CONST(0xfffff000)
#define MSELECT_EMEM_BOM_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MSELECT_EMEM_BOM_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MSELECT_EMEM_BOM_0_READ_MASK                    _MK_MASK_CONST(0xfffff000)
#define MSELECT_EMEM_BOM_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define MSELECT_EMEM_BOM_0_ADDR_SHIFT                   _MK_SHIFT_CONST(12)
#define MSELECT_EMEM_BOM_0_ADDR_FIELD                   (_MK_MASK_CONST(0xfffff) << MSELECT_EMEM_BOM_0_ADDR_SHIFT)
#define MSELECT_EMEM_BOM_0_ADDR_RANGE                   31:12
#define MSELECT_EMEM_BOM_0_ADDR_WOFFSET                 0x0
#define MSELECT_EMEM_BOM_0_ADDR_DEFAULT                 _MK_MASK_CONST(0x0)
#define MSELECT_EMEM_BOM_0_ADDR_DEFAULT_MASK                    _MK_MASK_CONST(0xfffff)
#define MSELECT_EMEM_BOM_0_ADDR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MSELECT_EMEM_BOM_0_ADDR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register MSELECT_EMEM_TOM_0  
#define MSELECT_EMEM_TOM_0                      _MK_ADDR_CONST(0xc)
#define MSELECT_EMEM_TOM_0_WORD_COUNT                   0x1
#define MSELECT_EMEM_TOM_0_RESET_VAL                    _MK_MASK_CONST(0x3ffff000)
#define MSELECT_EMEM_TOM_0_RESET_MASK                   _MK_MASK_CONST(0xfffff000)
#define MSELECT_EMEM_TOM_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MSELECT_EMEM_TOM_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MSELECT_EMEM_TOM_0_READ_MASK                    _MK_MASK_CONST(0xfffff000)
#define MSELECT_EMEM_TOM_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define MSELECT_EMEM_TOM_0_ADDR_SHIFT                   _MK_SHIFT_CONST(12)
#define MSELECT_EMEM_TOM_0_ADDR_FIELD                   (_MK_MASK_CONST(0xfffff) << MSELECT_EMEM_TOM_0_ADDR_SHIFT)
#define MSELECT_EMEM_TOM_0_ADDR_RANGE                   31:12
#define MSELECT_EMEM_TOM_0_ADDR_WOFFSET                 0x0
#define MSELECT_EMEM_TOM_0_ADDR_DEFAULT                 _MK_MASK_CONST(0x3ffff)
#define MSELECT_EMEM_TOM_0_ADDR_DEFAULT_MASK                    _MK_MASK_CONST(0xfffff)
#define MSELECT_EMEM_TOM_0_ADDR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MSELECT_EMEM_TOM_0_ADDR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register MSELECT_IMEM_BOM_0  
#define MSELECT_IMEM_BOM_0                      _MK_ADDR_CONST(0x10)
#define MSELECT_IMEM_BOM_0_WORD_COUNT                   0x1
#define MSELECT_IMEM_BOM_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define MSELECT_IMEM_BOM_0_RESET_MASK                   _MK_MASK_CONST(0xfffff000)
#define MSELECT_IMEM_BOM_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MSELECT_IMEM_BOM_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MSELECT_IMEM_BOM_0_READ_MASK                    _MK_MASK_CONST(0xfffff000)
#define MSELECT_IMEM_BOM_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define MSELECT_IMEM_BOM_0_ADDR_SHIFT                   _MK_SHIFT_CONST(12)
#define MSELECT_IMEM_BOM_0_ADDR_FIELD                   (_MK_MASK_CONST(0xfffff) << MSELECT_IMEM_BOM_0_ADDR_SHIFT)
#define MSELECT_IMEM_BOM_0_ADDR_RANGE                   31:12
#define MSELECT_IMEM_BOM_0_ADDR_WOFFSET                 0x0
#define MSELECT_IMEM_BOM_0_ADDR_DEFAULT                 _MK_MASK_CONST(0x0)
#define MSELECT_IMEM_BOM_0_ADDR_DEFAULT_MASK                    _MK_MASK_CONST(0xfffff)
#define MSELECT_IMEM_BOM_0_ADDR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MSELECT_IMEM_BOM_0_ADDR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register MSELECT_IMEM_TOM_0  
#define MSELECT_IMEM_TOM_0                      _MK_ADDR_CONST(0x14)
#define MSELECT_IMEM_TOM_0_WORD_COUNT                   0x1
#define MSELECT_IMEM_TOM_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define MSELECT_IMEM_TOM_0_RESET_MASK                   _MK_MASK_CONST(0xfffff000)
#define MSELECT_IMEM_TOM_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MSELECT_IMEM_TOM_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MSELECT_IMEM_TOM_0_READ_MASK                    _MK_MASK_CONST(0xfffff000)
#define MSELECT_IMEM_TOM_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define MSELECT_IMEM_TOM_0_ADDR_SHIFT                   _MK_SHIFT_CONST(12)
#define MSELECT_IMEM_TOM_0_ADDR_FIELD                   (_MK_MASK_CONST(0xfffff) << MSELECT_IMEM_TOM_0_ADDR_SHIFT)
#define MSELECT_IMEM_TOM_0_ADDR_RANGE                   31:12
#define MSELECT_IMEM_TOM_0_ADDR_WOFFSET                 0x0
#define MSELECT_IMEM_TOM_0_ADDR_DEFAULT                 _MK_MASK_CONST(0x0)
#define MSELECT_IMEM_TOM_0_ADDR_DEFAULT_MASK                    _MK_MASK_CONST(0xfffff)
#define MSELECT_IMEM_TOM_0_ADDR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MSELECT_IMEM_TOM_0_ADDR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register MSELECT_GART_BOM_0  
#define MSELECT_GART_BOM_0                      _MK_ADDR_CONST(0x18)
#define MSELECT_GART_BOM_0_WORD_COUNT                   0x1
#define MSELECT_GART_BOM_0_RESET_VAL                    _MK_MASK_CONST(0x58000000)
#define MSELECT_GART_BOM_0_RESET_MASK                   _MK_MASK_CONST(0xfffff000)
#define MSELECT_GART_BOM_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MSELECT_GART_BOM_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MSELECT_GART_BOM_0_READ_MASK                    _MK_MASK_CONST(0xfffff000)
#define MSELECT_GART_BOM_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define MSELECT_GART_BOM_0_ADDR_SHIFT                   _MK_SHIFT_CONST(12)
#define MSELECT_GART_BOM_0_ADDR_FIELD                   (_MK_MASK_CONST(0xfffff) << MSELECT_GART_BOM_0_ADDR_SHIFT)
#define MSELECT_GART_BOM_0_ADDR_RANGE                   31:12
#define MSELECT_GART_BOM_0_ADDR_WOFFSET                 0x0
#define MSELECT_GART_BOM_0_ADDR_DEFAULT                 _MK_MASK_CONST(0x58000)
#define MSELECT_GART_BOM_0_ADDR_DEFAULT_MASK                    _MK_MASK_CONST(0xfffff)
#define MSELECT_GART_BOM_0_ADDR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MSELECT_GART_BOM_0_ADDR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register MSELECT_GART_TOM_0  
#define MSELECT_GART_TOM_0                      _MK_ADDR_CONST(0x1c)
#define MSELECT_GART_TOM_0_WORD_COUNT                   0x1
#define MSELECT_GART_TOM_0_RESET_VAL                    _MK_MASK_CONST(0x58fff000)
#define MSELECT_GART_TOM_0_RESET_MASK                   _MK_MASK_CONST(0xfffff000)
#define MSELECT_GART_TOM_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MSELECT_GART_TOM_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MSELECT_GART_TOM_0_READ_MASK                    _MK_MASK_CONST(0xfffff000)
#define MSELECT_GART_TOM_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define MSELECT_GART_TOM_0_ADDR_SHIFT                   _MK_SHIFT_CONST(12)
#define MSELECT_GART_TOM_0_ADDR_FIELD                   (_MK_MASK_CONST(0xfffff) << MSELECT_GART_TOM_0_ADDR_SHIFT)
#define MSELECT_GART_TOM_0_ADDR_RANGE                   31:12
#define MSELECT_GART_TOM_0_ADDR_WOFFSET                 0x0
#define MSELECT_GART_TOM_0_ADDR_DEFAULT                 _MK_MASK_CONST(0x58fff)
#define MSELECT_GART_TOM_0_ADDR_DEFAULT_MASK                    _MK_MASK_CONST(0xfffff)
#define MSELECT_GART_TOM_0_ADDR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MSELECT_GART_TOM_0_ADDR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Packet IF2AXI_PKT
#define IF2AXI_PKT_SIZE 112

// [63:0]
#define IF2AXI_PKT_DATA_SHIFT                   _MK_SHIFT_CONST(0)
#define IF2AXI_PKT_DATA_FIELD                   (_MK_MASK_CONST(0xffffffff) << IF2AXI_PKT_DATA_SHIFT)
#define IF2AXI_PKT_DATA_RANGE                   _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define IF2AXI_PKT_DATA_ROW                     0

// [31:0]
#define IF2AXI_PKT_ADDR_SHIFT                   _MK_SHIFT_CONST(64)
#define IF2AXI_PKT_ADDR_FIELD                   (_MK_MASK_CONST(0xffffffff) << IF2AXI_PKT_ADDR_SHIFT)
#define IF2AXI_PKT_ADDR_RANGE                   _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define IF2AXI_PKT_ADDR_ROW                     0

#define IF2AXI_PKT_RST_n_SHIFT                  _MK_SHIFT_CONST(96)
#define IF2AXI_PKT_RST_n_FIELD                  (_MK_MASK_CONST(0x1) << IF2AXI_PKT_RST_n_SHIFT)
#define IF2AXI_PKT_RST_n_RANGE                  _MK_SHIFT_CONST(96):_MK_SHIFT_CONST(96)
#define IF2AXI_PKT_RST_n_ROW                    0

#define IF2AXI_PKT_CS_n_SHIFT                   _MK_SHIFT_CONST(97)
#define IF2AXI_PKT_CS_n_FIELD                   (_MK_MASK_CONST(0x1) << IF2AXI_PKT_CS_n_SHIFT)
#define IF2AXI_PKT_CS_n_RANGE                   _MK_SHIFT_CONST(97):_MK_SHIFT_CONST(97)
#define IF2AXI_PKT_CS_n_ROW                     0

#define IF2AXI_PKT_RD_n_SHIFT                   _MK_SHIFT_CONST(98)
#define IF2AXI_PKT_RD_n_FIELD                   (_MK_MASK_CONST(0x1) << IF2AXI_PKT_RD_n_SHIFT)
#define IF2AXI_PKT_RD_n_RANGE                   _MK_SHIFT_CONST(98):_MK_SHIFT_CONST(98)
#define IF2AXI_PKT_RD_n_ROW                     0

#define IF2AXI_PKT_WR_n_SHIFT                   _MK_SHIFT_CONST(99)
#define IF2AXI_PKT_WR_n_FIELD                   (_MK_MASK_CONST(0x1) << IF2AXI_PKT_WR_n_SHIFT)
#define IF2AXI_PKT_WR_n_RANGE                   _MK_SHIFT_CONST(99):_MK_SHIFT_CONST(99)
#define IF2AXI_PKT_WR_n_ROW                     0

#define IF2AXI_PKT_BE_n_SHIFT                   _MK_SHIFT_CONST(100)
#define IF2AXI_PKT_BE_n_FIELD                   (_MK_MASK_CONST(0xff) << IF2AXI_PKT_BE_n_SHIFT)
#define IF2AXI_PKT_BE_n_RANGE                   _MK_SHIFT_CONST(107):_MK_SHIFT_CONST(100)
#define IF2AXI_PKT_BE_n_ROW                     0

#define IF2AXI_PKT_ID_SHIFT                     _MK_SHIFT_CONST(108)
#define IF2AXI_PKT_ID_FIELD                     (_MK_MASK_CONST(0xf) << IF2AXI_PKT_ID_SHIFT)
#define IF2AXI_PKT_ID_RANGE                     _MK_SHIFT_CONST(111):_MK_SHIFT_CONST(108)
#define IF2AXI_PKT_ID_ROW                       0


// Packet AXI2IF_PKT
#define AXI2IF_PKT_SIZE 100

#define AXI2IF_PKT_DATA_SHIFT                   _MK_SHIFT_CONST(0)
#define AXI2IF_PKT_DATA_FIELD                   (_MK_MASK_CONST(0xffffffff) << AXI2IF_PKT_DATA_SHIFT)
#define AXI2IF_PKT_DATA_RANGE                   _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define AXI2IF_PKT_DATA_ROW                     0

#define AXI2IF_PKT_ID_SHIFT                     _MK_SHIFT_CONST(64)
#define AXI2IF_PKT_ID_FIELD                     (_MK_MASK_CONST(0xf) << AXI2IF_PKT_ID_SHIFT)
#define AXI2IF_PKT_ID_RANGE                     _MK_SHIFT_CONST(67):_MK_SHIFT_CONST(64)
#define AXI2IF_PKT_ID_ROW                       0

#define AXI2IF_PKT_INT_n_SHIFT                  _MK_SHIFT_CONST(68)
#define AXI2IF_PKT_INT_n_FIELD                  (_MK_MASK_CONST(0xffffffff) << AXI2IF_PKT_INT_n_SHIFT)
#define AXI2IF_PKT_INT_n_RANGE                  _MK_SHIFT_CONST(99):_MK_SHIFT_CONST(68)
#define AXI2IF_PKT_INT_n_ROW                    0


// Packet NV_ID_PKT
#define NV_ID_PKT_SIZE 8

#define NV_ID_PKT_mpid_SHIFT                    _MK_SHIFT_CONST(0)
#define NV_ID_PKT_mpid_FIELD                    (_MK_MASK_CONST(0x3) << NV_ID_PKT_mpid_SHIFT)
#define NV_ID_PKT_mpid_RANGE                    _MK_SHIFT_CONST(1):_MK_SHIFT_CONST(0)
#define NV_ID_PKT_mpid_ROW                      0

#define NV_ID_PKT_msid_SHIFT                    _MK_SHIFT_CONST(2)
#define NV_ID_PKT_msid_FIELD                    (_MK_MASK_CONST(0x7) << NV_ID_PKT_msid_SHIFT)
#define NV_ID_PKT_msid_RANGE                    _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(2)
#define NV_ID_PKT_msid_ROW                      0

#define NV_ID_PKT_tid_SHIFT                     _MK_SHIFT_CONST(0)
#define NV_ID_PKT_tid_FIELD                     (_MK_MASK_CONST(0x1f) << NV_ID_PKT_tid_SHIFT)
#define NV_ID_PKT_tid_RANGE                     _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(0)
#define NV_ID_PKT_tid_ROW                       0

#define NV_ID_PKT_mid_SHIFT                     _MK_SHIFT_CONST(5)
#define NV_ID_PKT_mid_FIELD                     (_MK_MASK_CONST(0x3) << NV_ID_PKT_mid_SHIFT)
#define NV_ID_PKT_mid_RANGE                     _MK_SHIFT_CONST(6):_MK_SHIFT_CONST(5)
#define NV_ID_PKT_mid_ROW                       0

#define NV_ID_PKT_cid_SHIFT                     _MK_SHIFT_CONST(7)
#define NV_ID_PKT_cid_FIELD                     (_MK_MASK_CONST(0x1) << NV_ID_PKT_cid_SHIFT)
#define NV_ID_PKT_cid_RANGE                     _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(7)
#define NV_ID_PKT_cid_ROW                       0
#define NV_ID_PKT_cid_MEM                       _MK_ENUM_CONST(0)
#define NV_ID_PKT_cid_NISO                      _MK_ENUM_CONST(0)
#define NV_ID_PKT_cid_CFG                       _MK_ENUM_CONST(1)
#define NV_ID_PKT_cid_ISO                       _MK_ENUM_CONST(1)


// Packet MSELECT_A_PKT
#define MSELECT_A_PKT_SIZE 58

#define MSELECT_A_PKT_aaddr_SHIFT                       _MK_SHIFT_CONST(0)
#define MSELECT_A_PKT_aaddr_FIELD                       (_MK_MASK_CONST(0xffffffff) << MSELECT_A_PKT_aaddr_SHIFT)
#define MSELECT_A_PKT_aaddr_RANGE                       _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define MSELECT_A_PKT_aaddr_ROW                 0

#define MSELECT_A_PKT_aid_SHIFT                 _MK_SHIFT_CONST(32)
#define MSELECT_A_PKT_aid_FIELD                 (_MK_MASK_CONST(0xff) << MSELECT_A_PKT_aid_SHIFT)
#define MSELECT_A_PKT_aid_RANGE                 _MK_SHIFT_CONST(39):_MK_SHIFT_CONST(32)
#define MSELECT_A_PKT_aid_ROW                   0

#define MSELECT_A_PKT_alen_SHIFT                        _MK_SHIFT_CONST(40)
#define MSELECT_A_PKT_alen_FIELD                        (_MK_MASK_CONST(0xf) << MSELECT_A_PKT_alen_SHIFT)
#define MSELECT_A_PKT_alen_RANGE                        _MK_SHIFT_CONST(43):_MK_SHIFT_CONST(40)
#define MSELECT_A_PKT_alen_ROW                  0

#define MSELECT_A_PKT_asize_SHIFT                       _MK_SHIFT_CONST(44)
#define MSELECT_A_PKT_asize_FIELD                       (_MK_MASK_CONST(0x7) << MSELECT_A_PKT_asize_SHIFT)
#define MSELECT_A_PKT_asize_RANGE                       _MK_SHIFT_CONST(46):_MK_SHIFT_CONST(44)
#define MSELECT_A_PKT_asize_ROW                 2

#define MSELECT_A_PKT_aburst_SHIFT                      _MK_SHIFT_CONST(47)
#define MSELECT_A_PKT_aburst_FIELD                      (_MK_MASK_CONST(0x3) << MSELECT_A_PKT_aburst_SHIFT)
#define MSELECT_A_PKT_aburst_RANGE                      _MK_SHIFT_CONST(48):_MK_SHIFT_CONST(47)
#define MSELECT_A_PKT_aburst_ROW                        0
#define MSELECT_A_PKT_aburst_FIXED                      _MK_ENUM_CONST(0)
#define MSELECT_A_PKT_aburst_INCR                       _MK_ENUM_CONST(1)
#define MSELECT_A_PKT_aburst_WRAP                       _MK_ENUM_CONST(2)
#define MSELECT_A_PKT_aburst_RSVD                       _MK_ENUM_CONST(3)

#define MSELECT_A_PKT_alock_SHIFT                       _MK_SHIFT_CONST(49)
#define MSELECT_A_PKT_alock_FIELD                       (_MK_MASK_CONST(0x3) << MSELECT_A_PKT_alock_SHIFT)
#define MSELECT_A_PKT_alock_RANGE                       _MK_SHIFT_CONST(50):_MK_SHIFT_CONST(49)
#define MSELECT_A_PKT_alock_ROW                 0

#define MSELECT_A_PKT_acache_SHIFT                      _MK_SHIFT_CONST(51)
#define MSELECT_A_PKT_acache_FIELD                      (_MK_MASK_CONST(0xf) << MSELECT_A_PKT_acache_SHIFT)
#define MSELECT_A_PKT_acache_RANGE                      _MK_SHIFT_CONST(54):_MK_SHIFT_CONST(51)
#define MSELECT_A_PKT_acache_ROW                        0

#define MSELECT_A_PKT_aprot_SHIFT                       _MK_SHIFT_CONST(55)
#define MSELECT_A_PKT_aprot_FIELD                       (_MK_MASK_CONST(0x7) << MSELECT_A_PKT_aprot_SHIFT)
#define MSELECT_A_PKT_aprot_RANGE                       _MK_SHIFT_CONST(57):_MK_SHIFT_CONST(55)
#define MSELECT_A_PKT_aprot_ROW                 0


// Packet MSELECT_W_PKT
#define MSELECT_W_PKT_SIZE 81

#define MSELECT_W_PKT_wdata_SHIFT                       _MK_SHIFT_CONST(0)
#define MSELECT_W_PKT_wdata_FIELD                       (_MK_MASK_CONST(0xffffffff) << MSELECT_W_PKT_wdata_SHIFT)
#define MSELECT_W_PKT_wdata_RANGE                       _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define MSELECT_W_PKT_wdata_ROW                 0

#define MSELECT_W_PKT_wid_SHIFT                 _MK_SHIFT_CONST(64)
#define MSELECT_W_PKT_wid_FIELD                 (_MK_MASK_CONST(0xff) << MSELECT_W_PKT_wid_SHIFT)
#define MSELECT_W_PKT_wid_RANGE                 _MK_SHIFT_CONST(71):_MK_SHIFT_CONST(64)
#define MSELECT_W_PKT_wid_ROW                   0

#define MSELECT_W_PKT_wstrb_SHIFT                       _MK_SHIFT_CONST(72)
#define MSELECT_W_PKT_wstrb_FIELD                       (_MK_MASK_CONST(0xff) << MSELECT_W_PKT_wstrb_SHIFT)
#define MSELECT_W_PKT_wstrb_RANGE                       _MK_SHIFT_CONST(79):_MK_SHIFT_CONST(72)
#define MSELECT_W_PKT_wstrb_ROW                 0

#define MSELECT_W_PKT_wlast_SHIFT                       _MK_SHIFT_CONST(80)
#define MSELECT_W_PKT_wlast_FIELD                       (_MK_MASK_CONST(0x1) << MSELECT_W_PKT_wlast_SHIFT)
#define MSELECT_W_PKT_wlast_RANGE                       _MK_SHIFT_CONST(80):_MK_SHIFT_CONST(80)
#define MSELECT_W_PKT_wlast_ROW                 0


// Packet MSELECT_B_PKT
#define MSELECT_B_PKT_SIZE 10

#define MSELECT_B_PKT_bid_SHIFT                 _MK_SHIFT_CONST(0)
#define MSELECT_B_PKT_bid_FIELD                 (_MK_MASK_CONST(0xff) << MSELECT_B_PKT_bid_SHIFT)
#define MSELECT_B_PKT_bid_RANGE                 _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(0)
#define MSELECT_B_PKT_bid_ROW                   0

#define MSELECT_B_PKT_bresp_SHIFT                       _MK_SHIFT_CONST(8)
#define MSELECT_B_PKT_bresp_FIELD                       (_MK_MASK_CONST(0x3) << MSELECT_B_PKT_bresp_SHIFT)
#define MSELECT_B_PKT_bresp_RANGE                       _MK_SHIFT_CONST(9):_MK_SHIFT_CONST(8)
#define MSELECT_B_PKT_bresp_ROW                 0
#define MSELECT_B_PKT_bresp_OKAY                        _MK_ENUM_CONST(0)
#define MSELECT_B_PKT_bresp_EXOKAY                      _MK_ENUM_CONST(1)
#define MSELECT_B_PKT_bresp_SLVERR                      _MK_ENUM_CONST(2)
#define MSELECT_B_PKT_bresp_DECERR                      _MK_ENUM_CONST(3)


// Packet MSELECT_R_PKT
#define MSELECT_R_PKT_SIZE 75

#define MSELECT_R_PKT_rdata_SHIFT                       _MK_SHIFT_CONST(0)
#define MSELECT_R_PKT_rdata_FIELD                       (_MK_MASK_CONST(0xffffffff) << MSELECT_R_PKT_rdata_SHIFT)
#define MSELECT_R_PKT_rdata_RANGE                       _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define MSELECT_R_PKT_rdata_ROW                 0

#define MSELECT_R_PKT_rid_SHIFT                 _MK_SHIFT_CONST(64)
#define MSELECT_R_PKT_rid_FIELD                 (_MK_MASK_CONST(0xff) << MSELECT_R_PKT_rid_SHIFT)
#define MSELECT_R_PKT_rid_RANGE                 _MK_SHIFT_CONST(71):_MK_SHIFT_CONST(64)
#define MSELECT_R_PKT_rid_ROW                   0

#define MSELECT_R_PKT_rresp_SHIFT                       _MK_SHIFT_CONST(72)
#define MSELECT_R_PKT_rresp_FIELD                       (_MK_MASK_CONST(0x3) << MSELECT_R_PKT_rresp_SHIFT)
#define MSELECT_R_PKT_rresp_RANGE                       _MK_SHIFT_CONST(73):_MK_SHIFT_CONST(72)
#define MSELECT_R_PKT_rresp_ROW                 0
#define MSELECT_R_PKT_rresp_OKAY                        _MK_ENUM_CONST(0)
#define MSELECT_R_PKT_rresp_EXOKAY                      _MK_ENUM_CONST(1)
#define MSELECT_R_PKT_rresp_SLVERR                      _MK_ENUM_CONST(2)
#define MSELECT_R_PKT_rresp_DECERR                      _MK_ENUM_CONST(3)

#define MSELECT_R_PKT_rlast_SHIFT                       _MK_SHIFT_CONST(74)
#define MSELECT_R_PKT_rlast_FIELD                       (_MK_MASK_CONST(0x1) << MSELECT_R_PKT_rlast_SHIFT)
#define MSELECT_R_PKT_rlast_RANGE                       _MK_SHIFT_CONST(74):_MK_SHIFT_CONST(74)
#define MSELECT_R_PKT_rlast_ROW                 0

#define NV_MSELECT_EMEM_BYPASS_RD_ALIGN 8
#define NV_MSELECT_EMEM_BYPASS_RD_LEN   3
#define NV_MSELECT_EMEM_BYPASS_RD_SIZE  3
#define NV_MSELECT_EMEM_BYPASS_RD_BURST 2
#define NV_MSELECT_EMEM_BYPASS_WR_ALIGN 32
#define NV_MSELECT_EMEM_BYPASS_WR_LEN   3
#define NV_MSELECT_EMEM_BYPASS_WR_SIZE  3
#define NV_MSELECT_EMEM_BYPASS_WR_BURST 1
#define NV_MSELECT_PERIPH_R_ID_FIFO_DEPTH       5
#define NV_MSELECT_PERIPH_B_ID_FIFO_DEPTH       11

//
// REGISTER LIST
//
#define LIST_ARMSELECT_REGS(_op_) \
_op_(MSELECT_CONFIG_0) \
_op_(MSELECT_PERIPHBASE_0) \
_op_(MSELECT_EMEM_BOM_0) \
_op_(MSELECT_EMEM_TOM_0) \
_op_(MSELECT_IMEM_BOM_0) \
_op_(MSELECT_IMEM_TOM_0) \
_op_(MSELECT_GART_BOM_0) \
_op_(MSELECT_GART_TOM_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_MSELECT    0x00000000

//
// ARMSELECT REGISTER BANKS
//

#define MSELECT0_FIRST_REG 0x0000 // MSELECT_CONFIG_0
#define MSELECT0_LAST_REG 0x001c // MSELECT_GART_TOM_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARMSELECT_H_INC_
