/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARAPBPM_H_INC_
#define ___ARAPBPM_H_INC_

// Register APBDEV_PMC_CNTRL_0  
#define APBDEV_PMC_CNTRL_0                      _MK_ADDR_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SECURE                       0x0
#define APBDEV_PMC_CNTRL_0_WORD_COUNT                   0x1
#define APBDEV_PMC_CNTRL_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_RESET_MASK                   _MK_MASK_CONST(0x7ffff)
#define APBDEV_PMC_CNTRL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_READ_MASK                    _MK_MASK_CONST(0x7ffff)
#define APBDEV_PMC_CNTRL_0_WRITE_MASK                   _MK_MASK_CONST(0x7ffff)
// Disable 32KHz clock to KBC 
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_SHIFT)
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_RANGE                    0:0
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_WOFFSET                  0x0
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_DISABLE                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_KBC_CLK_DIS_ENABLE                   _MK_ENUM_CONST(1)

// Disable  32KHz clock to RTC                          
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_SHIFT                    _MK_SHIFT_CONST(1)
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_SHIFT)
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_RANGE                    1:1
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_WOFFSET                  0x0
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_DISABLE                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_RTC_CLK_DIS_ENABLE                   _MK_ENUM_CONST(1)

// Software reset to RTC
#define APBDEV_PMC_CNTRL_0_RTC_RST_SHIFT                        _MK_SHIFT_CONST(2)
#define APBDEV_PMC_CNTRL_0_RTC_RST_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_RTC_RST_SHIFT)
#define APBDEV_PMC_CNTRL_0_RTC_RST_RANGE                        2:2
#define APBDEV_PMC_CNTRL_0_RTC_RST_WOFFSET                      0x0
#define APBDEV_PMC_CNTRL_0_RTC_RST_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_RTC_RST_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_RTC_RST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_RTC_RST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_RTC_RST_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_RTC_RST_ENABLE                       _MK_ENUM_CONST(1)

// Software reset to KBC  
#define APBDEV_PMC_CNTRL_0_KBC_RST_SHIFT                        _MK_SHIFT_CONST(3)
#define APBDEV_PMC_CNTRL_0_KBC_RST_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_KBC_RST_SHIFT)
#define APBDEV_PMC_CNTRL_0_KBC_RST_RANGE                        3:3
#define APBDEV_PMC_CNTRL_0_KBC_RST_WOFFSET                      0x0
#define APBDEV_PMC_CNTRL_0_KBC_RST_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_KBC_RST_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_KBC_RST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_KBC_RST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_KBC_RST_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_KBC_RST_ENABLE                       _MK_ENUM_CONST(1)

// Reset to CAR - generates 2 clock cycle  pulse. 
#define APBDEV_PMC_CNTRL_0_MAIN_RST_SHIFT                       _MK_SHIFT_CONST(4)
#define APBDEV_PMC_CNTRL_0_MAIN_RST_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_MAIN_RST_SHIFT)
#define APBDEV_PMC_CNTRL_0_MAIN_RST_RANGE                       4:4
#define APBDEV_PMC_CNTRL_0_MAIN_RST_WOFFSET                     0x0
#define APBDEV_PMC_CNTRL_0_MAIN_RST_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_MAIN_RST_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_MAIN_RST_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_MAIN_RST_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_MAIN_RST_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_MAIN_RST_ENABLE                      _MK_ENUM_CONST(1)

// Enables latching wakeup events - stops latching   on transition from 1 to 0(sequence - set to 1,set to 0) 
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_SHIFT                   _MK_SHIFT_CONST(5)
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_SHIFT)
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_RANGE                   5:5
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_WOFFSET                 0x0
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_DISABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_LATCHWAKE_EN_ENABLE                  _MK_ENUM_CONST(1)

// Disable  detecting glitch on wakeup event- in default operation glitches are ignored on wakeup lines. if this bit is set to 1, glitch (event shorter than half 32khz clock, will be causing wakeup from lp0
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_SHIFT                  _MK_SHIFT_CONST(6)
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_SHIFT)
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_RANGE                  6:6
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_WOFFSET                        0x0
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_DISABLE                        _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_GLITCHDET_DIS_ENABLE                 _MK_ENUM_CONST(1)

// Enables blinking counter and blink output -works only if BLINK field in DPD_PADS_ORIDE is set to 1
#define APBDEV_PMC_CNTRL_0_BLINK_EN_SHIFT                       _MK_SHIFT_CONST(7)
#define APBDEV_PMC_CNTRL_0_BLINK_EN_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_BLINK_EN_SHIFT)
#define APBDEV_PMC_CNTRL_0_BLINK_EN_RANGE                       7:7
#define APBDEV_PMC_CNTRL_0_BLINK_EN_WOFFSET                     0x0
#define APBDEV_PMC_CNTRL_0_BLINK_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_BLINK_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_BLINK_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_BLINK_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_BLINK_EN_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_BLINK_EN_ENABLE                      _MK_ENUM_CONST(1)

// Inverts power request polarity
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_SHIFT                        _MK_SHIFT_CONST(8)
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_SHIFT)
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_RANGE                        8:8
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_WOFFSET                      0x0
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_NORMAL                       _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_PWRREQ_POLARITY_INVERT                       _MK_ENUM_CONST(1)

// Power request output enable. resets to tristate
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_SHIFT                      _MK_SHIFT_CONST(9)
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_PWRREQ_OE_SHIFT)
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_RANGE                      9:9
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_WOFFSET                    0x0
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_PWRREQ_OE_ENABLE                     _MK_ENUM_CONST(1)

// Inverts system clock enable polarity 
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_SHIFT                        _MK_SHIFT_CONST(10)
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_SHIFT)
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_RANGE                        10:10
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_WOFFSET                      0x0
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_NORMAL                       _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_SYSCLK_POLARITY_INVERT                       _MK_ENUM_CONST(1)

// Enables output of system enable clock - works only if SYS_CLK field in DPD_PADS_ORIDE is set to 1. resets to tristate
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_SHIFT                      _MK_SHIFT_CONST(11)
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_SYSCLK_OE_SHIFT)
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_RANGE                      11:11
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_WOFFSET                    0x0
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_SYSCLK_OE_ENABLE                     _MK_ENUM_CONST(1)

// Disable  power gating - global override, will override function of PWRGATE_TOGGLE register. all partitions will stay enabled. 
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_SHIFT                    _MK_SHIFT_CONST(12)
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_PWRGATE_DIS_SHIFT)
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_RANGE                    12:12
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_WOFFSET                  0x0
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_DISABLE                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_PWRGATE_DIS_ENABLE                   _MK_ENUM_CONST(1)

// AO intitlized  purely sftw diagnostic and interpretation
#define APBDEV_PMC_CNTRL_0_AOINIT_SHIFT                 _MK_SHIFT_CONST(13)
#define APBDEV_PMC_CNTRL_0_AOINIT_FIELD                 (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_AOINIT_SHIFT)
#define APBDEV_PMC_CNTRL_0_AOINIT_RANGE                 13:13
#define APBDEV_PMC_CNTRL_0_AOINIT_WOFFSET                       0x0
#define APBDEV_PMC_CNTRL_0_AOINIT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_AOINIT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_AOINIT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_AOINIT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_AOINIT_NOTDONE                       _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_AOINIT_DONE                  _MK_ENUM_CONST(1)

// when set causes side effect of entering lp0 after powering down cpu
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_SHIFT                        _MK_SHIFT_CONST(14)
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_SHIFT)
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_RANGE                        14:14
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_WOFFSET                      0x0
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_SIDE_EFFECT_LP0_ENABLE                       _MK_ENUM_CONST(1)

// Inverts power request polarity
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_POLARITY_SHIFT                     _MK_SHIFT_CONST(15)
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_POLARITY_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_CPUPWRREQ_POLARITY_SHIFT)
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_POLARITY_RANGE                     15:15
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_POLARITY_WOFFSET                   0x0
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_POLARITY_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_POLARITY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_POLARITY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_POLARITY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_POLARITY_NORMAL                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_POLARITY_INVERT                    _MK_ENUM_CONST(1)

// Power request output enable. resets to tristate
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_OE_SHIFT                   _MK_SHIFT_CONST(16)
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_OE_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_CPUPWRREQ_OE_SHIFT)
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_OE_RANGE                   16:16
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_OE_WOFFSET                 0x0
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_OE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_OE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_OE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_OE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_OE_DISABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_CPUPWRREQ_OE_ENABLE                  _MK_ENUM_CONST(1)

// Inverts INTR polarity
#define APBDEV_PMC_CNTRL_0_INTR_POLARITY_SHIFT                  _MK_SHIFT_CONST(17)
#define APBDEV_PMC_CNTRL_0_INTR_POLARITY_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_INTR_POLARITY_SHIFT)
#define APBDEV_PMC_CNTRL_0_INTR_POLARITY_RANGE                  17:17
#define APBDEV_PMC_CNTRL_0_INTR_POLARITY_WOFFSET                        0x0
#define APBDEV_PMC_CNTRL_0_INTR_POLARITY_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_INTR_POLARITY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_INTR_POLARITY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_INTR_POLARITY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_INTR_POLARITY_DISABLE                        _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_INTR_POLARITY_ENABLE                 _MK_ENUM_CONST(1)

// Fuse override
#define APBDEV_PMC_CNTRL_0_FUSE_OVERRIDE_SHIFT                  _MK_SHIFT_CONST(18)
#define APBDEV_PMC_CNTRL_0_FUSE_OVERRIDE_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_CNTRL_0_FUSE_OVERRIDE_SHIFT)
#define APBDEV_PMC_CNTRL_0_FUSE_OVERRIDE_RANGE                  18:18
#define APBDEV_PMC_CNTRL_0_FUSE_OVERRIDE_WOFFSET                        0x0
#define APBDEV_PMC_CNTRL_0_FUSE_OVERRIDE_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_FUSE_OVERRIDE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CNTRL_0_FUSE_OVERRIDE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_FUSE_OVERRIDE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CNTRL_0_FUSE_OVERRIDE_DISABLE                        _MK_ENUM_CONST(0)
#define APBDEV_PMC_CNTRL_0_FUSE_OVERRIDE_ENABLE                 _MK_ENUM_CONST(1)


// Register APBDEV_PMC_SEC_DISABLE_0  
#define APBDEV_PMC_SEC_DISABLE_0                        _MK_ADDR_CONST(0x4)
#define APBDEV_PMC_SEC_DISABLE_0_SECURE                         0x0
#define APBDEV_PMC_SEC_DISABLE_0_WORD_COUNT                     0x1
#define APBDEV_PMC_SEC_DISABLE_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_RESET_MASK                     _MK_MASK_CONST(0xf)
#define APBDEV_PMC_SEC_DISABLE_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_READ_MASK                      _MK_MASK_CONST(0xf)
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_MASK                     _MK_MASK_CONST(0xf)
// disable write to secure registers
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_SEC_DISABLE_0_WRITE_SHIFT)
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_RANGE                    0:0
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_WOFFSET                  0x0
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_OFF                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_SEC_DISABLE_0_WRITE_ON                       _MK_ENUM_CONST(1)

// disable read  from  secure registers
#define APBDEV_PMC_SEC_DISABLE_0_READ_SHIFT                     _MK_SHIFT_CONST(1)
#define APBDEV_PMC_SEC_DISABLE_0_READ_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_SEC_DISABLE_0_READ_SHIFT)
#define APBDEV_PMC_SEC_DISABLE_0_READ_RANGE                     1:1
#define APBDEV_PMC_SEC_DISABLE_0_READ_WOFFSET                   0x0
#define APBDEV_PMC_SEC_DISABLE_0_READ_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_READ_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SEC_DISABLE_0_READ_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_READ_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_READ_OFF                       _MK_ENUM_CONST(0)
#define APBDEV_PMC_SEC_DISABLE_0_READ_ON                        _MK_ENUM_CONST(1)

// disable write to bondout secure registers
#define APBDEV_PMC_SEC_DISABLE_0_BWRITE_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDEV_PMC_SEC_DISABLE_0_BWRITE_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_SEC_DISABLE_0_BWRITE_SHIFT)
#define APBDEV_PMC_SEC_DISABLE_0_BWRITE_RANGE                   2:2
#define APBDEV_PMC_SEC_DISABLE_0_BWRITE_WOFFSET                 0x0
#define APBDEV_PMC_SEC_DISABLE_0_BWRITE_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_BWRITE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SEC_DISABLE_0_BWRITE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_BWRITE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_BWRITE_OFF                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_SEC_DISABLE_0_BWRITE_ON                      _MK_ENUM_CONST(1)

// disable read  from bondout secure registers
#define APBDEV_PMC_SEC_DISABLE_0_BREAD_SHIFT                    _MK_SHIFT_CONST(3)
#define APBDEV_PMC_SEC_DISABLE_0_BREAD_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_SEC_DISABLE_0_BREAD_SHIFT)
#define APBDEV_PMC_SEC_DISABLE_0_BREAD_RANGE                    3:3
#define APBDEV_PMC_SEC_DISABLE_0_BREAD_WOFFSET                  0x0
#define APBDEV_PMC_SEC_DISABLE_0_BREAD_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_BREAD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SEC_DISABLE_0_BREAD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_BREAD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SEC_DISABLE_0_BREAD_OFF                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_SEC_DISABLE_0_BREAD_ON                       _MK_ENUM_CONST(1)


// Register APBDEV_PMC_PMC_SWRST_0  
#define APBDEV_PMC_PMC_SWRST_0                  _MK_ADDR_CONST(0x8)
#define APBDEV_PMC_PMC_SWRST_0_SECURE                   0x0
#define APBDEV_PMC_PMC_SWRST_0_WORD_COUNT                       0x1
#define APBDEV_PMC_PMC_SWRST_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PMC_SWRST_0_RESET_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PMC_SWRST_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PMC_SWRST_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PMC_SWRST_0_READ_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PMC_SWRST_0_WRITE_MASK                       _MK_MASK_CONST(0x1)
//software reset to pmc only
#define APBDEV_PMC_PMC_SWRST_0_RST_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PMC_SWRST_0_RST_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_PMC_SWRST_0_RST_SHIFT)
#define APBDEV_PMC_PMC_SWRST_0_RST_RANGE                        0:0
#define APBDEV_PMC_PMC_SWRST_0_RST_WOFFSET                      0x0
#define APBDEV_PMC_PMC_SWRST_0_RST_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PMC_SWRST_0_RST_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PMC_SWRST_0_RST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PMC_SWRST_0_RST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PMC_SWRST_0_RST_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_PMC_SWRST_0_RST_ENABLE                       _MK_ENUM_CONST(1)


// Register APBDEV_PMC_WAKE_MASK_0  
#define APBDEV_PMC_WAKE_MASK_0                  _MK_ADDR_CONST(0xc)
#define APBDEV_PMC_WAKE_MASK_0_SECURE                   0x0
#define APBDEV_PMC_WAKE_MASK_0_WORD_COUNT                       0x1
#define APBDEV_PMC_WAKE_MASK_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_WAKE_MASK_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_WAKE_MASK_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// pin  0-15  wake enable      
#define APBDEV_PMC_WAKE_MASK_0_EVENT_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_FIELD                      (_MK_MASK_CONST(0xffff) << APBDEV_PMC_WAKE_MASK_0_EVENT_SHIFT)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_RANGE                      15:0
#define APBDEV_PMC_WAKE_MASK_0_EVENT_WOFFSET                    0x0
#define APBDEV_PMC_WAKE_MASK_0_EVENT_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_DEFAULT_MASK                       _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_ENABLE                     _MK_ENUM_CONST(1)

// RTC  wake enable                
#define APBDEV_PMC_WAKE_MASK_0_RTC_SHIFT                        _MK_SHIFT_CONST(16)
#define APBDEV_PMC_WAKE_MASK_0_RTC_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_MASK_0_RTC_SHIFT)
#define APBDEV_PMC_WAKE_MASK_0_RTC_RANGE                        16:16
#define APBDEV_PMC_WAKE_MASK_0_RTC_WOFFSET                      0x0
#define APBDEV_PMC_WAKE_MASK_0_RTC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_RTC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_MASK_0_RTC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_RTC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_RTC_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_MASK_0_RTC_ENABLE                       _MK_ENUM_CONST(1)

// KBC  wake  enable                
#define APBDEV_PMC_WAKE_MASK_0_KBC_SHIFT                        _MK_SHIFT_CONST(17)
#define APBDEV_PMC_WAKE_MASK_0_KBC_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_MASK_0_KBC_SHIFT)
#define APBDEV_PMC_WAKE_MASK_0_KBC_RANGE                        17:17
#define APBDEV_PMC_WAKE_MASK_0_KBC_WOFFSET                      0x0
#define APBDEV_PMC_WAKE_MASK_0_KBC_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_KBC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_MASK_0_KBC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_KBC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_KBC_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_MASK_0_KBC_ENABLE                       _MK_ENUM_CONST(1)

// PWR_INT wake enable               
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_SHIFT                    _MK_SHIFT_CONST(18)
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_MASK_0_PWR_INT_SHIFT)
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_RANGE                    18:18
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_WOFFSET                  0x0
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_DISABLE                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_MASK_0_PWR_INT_ENABLE                   _MK_ENUM_CONST(1)

#define APBDEV_PMC_WAKE_MASK_0_USB_EVENT_SHIFT                  _MK_SHIFT_CONST(19)
#define APBDEV_PMC_WAKE_MASK_0_USB_EVENT_FIELD                  (_MK_MASK_CONST(0xf) << APBDEV_PMC_WAKE_MASK_0_USB_EVENT_SHIFT)
#define APBDEV_PMC_WAKE_MASK_0_USB_EVENT_RANGE                  22:19
#define APBDEV_PMC_WAKE_MASK_0_USB_EVENT_WOFFSET                        0x0
#define APBDEV_PMC_WAKE_MASK_0_USB_EVENT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_USB_EVENT_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define APBDEV_PMC_WAKE_MASK_0_USB_EVENT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_USB_EVENT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_USB_EVENT_ACTIVE_LOW                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_MASK_0_USB_EVENT_ACTIVE_HIGH                    _MK_ENUM_CONST(1)

#define APBDEV_PMC_WAKE_MASK_0_EVENT_RES_SHIFT                  _MK_SHIFT_CONST(23)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_RES_FIELD                  (_MK_MASK_CONST(0xff) << APBDEV_PMC_WAKE_MASK_0_EVENT_RES_SHIFT)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_RES_RANGE                  30:23
#define APBDEV_PMC_WAKE_MASK_0_EVENT_RES_WOFFSET                        0x0
#define APBDEV_PMC_WAKE_MASK_0_EVENT_RES_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_RES_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_RES_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_RES_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_RES_DISABLE                        _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_MASK_0_EVENT_RES_ENABLE                 _MK_ENUM_CONST(1)

// external reset wake enable
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_SHIFT                    _MK_SHIFT_CONST(31)
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_MASK_0_RESET_N_SHIFT)
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_RANGE                    31:31
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_WOFFSET                  0x0
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_DISABLE                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_MASK_0_RESET_N_ENABLE                   _MK_ENUM_CONST(1)


// Register APBDEV_PMC_WAKE_LVL_0  
#define APBDEV_PMC_WAKE_LVL_0                   _MK_ADDR_CONST(0x10)
#define APBDEV_PMC_WAKE_LVL_0_SECURE                    0x0
#define APBDEV_PMC_WAKE_LVL_0_WORD_COUNT                        0x1
#define APBDEV_PMC_WAKE_LVL_0_RESET_VAL                         _MK_MASK_CONST(0x7f9fffff)
#define APBDEV_PMC_WAKE_LVL_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_WAKE_LVL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_WAKE_LVL_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// pin 0-15 wake  level       
#define APBDEV_PMC_WAKE_LVL_0_EVENT_SHIFT                       _MK_SHIFT_CONST(0)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_FIELD                       (_MK_MASK_CONST(0xffff) << APBDEV_PMC_WAKE_LVL_0_EVENT_SHIFT)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_RANGE                       15:0
#define APBDEV_PMC_WAKE_LVL_0_EVENT_WOFFSET                     0x0
#define APBDEV_PMC_WAKE_LVL_0_EVENT_DEFAULT                     _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_DEFAULT_MASK                        _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_ACTIVE_LOW                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_ACTIVE_HIGH                 _MK_ENUM_CONST(1)

// RTC  wake  level               
#define APBDEV_PMC_WAKE_LVL_0_RTC_SHIFT                 _MK_SHIFT_CONST(16)
#define APBDEV_PMC_WAKE_LVL_0_RTC_FIELD                 (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_LVL_0_RTC_SHIFT)
#define APBDEV_PMC_WAKE_LVL_0_RTC_RANGE                 16:16
#define APBDEV_PMC_WAKE_LVL_0_RTC_WOFFSET                       0x0
#define APBDEV_PMC_WAKE_LVL_0_RTC_DEFAULT                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_LVL_0_RTC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_LVL_0_RTC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_RTC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_RTC_ACTIVE_LOW                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_LVL_0_RTC_ACTIVE_HIGH                   _MK_ENUM_CONST(1)

// KBC  wake level                
#define APBDEV_PMC_WAKE_LVL_0_KBC_SHIFT                 _MK_SHIFT_CONST(17)
#define APBDEV_PMC_WAKE_LVL_0_KBC_FIELD                 (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_LVL_0_KBC_SHIFT)
#define APBDEV_PMC_WAKE_LVL_0_KBC_RANGE                 17:17
#define APBDEV_PMC_WAKE_LVL_0_KBC_WOFFSET                       0x0
#define APBDEV_PMC_WAKE_LVL_0_KBC_DEFAULT                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_LVL_0_KBC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_LVL_0_KBC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_KBC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_KBC_ACTIVE_LOW                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_LVL_0_KBC_ACTIVE_HIGH                   _MK_ENUM_CONST(1)

// power interrupt - now pernamently tied to  bit 18            
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_SHIFT                     _MK_SHIFT_CONST(18)
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_LVL_0_PWR_INT_SHIFT)
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_RANGE                     18:18
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_WOFFSET                   0x0
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_ACTIVE_LOW                        _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_LVL_0_PWR_INT_ACTIVE_HIGH                       _MK_ENUM_CONST(1)

#define APBDEV_PMC_WAKE_LVL_0_USB_EVENT_SHIFT                   _MK_SHIFT_CONST(19)
#define APBDEV_PMC_WAKE_LVL_0_USB_EVENT_FIELD                   (_MK_MASK_CONST(0xf) << APBDEV_PMC_WAKE_LVL_0_USB_EVENT_SHIFT)
#define APBDEV_PMC_WAKE_LVL_0_USB_EVENT_RANGE                   22:19
#define APBDEV_PMC_WAKE_LVL_0_USB_EVENT_WOFFSET                 0x0
#define APBDEV_PMC_WAKE_LVL_0_USB_EVENT_DEFAULT                 _MK_MASK_CONST(0x3)
#define APBDEV_PMC_WAKE_LVL_0_USB_EVENT_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define APBDEV_PMC_WAKE_LVL_0_USB_EVENT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_USB_EVENT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_USB_EVENT_ACTIVE_LOW                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_LVL_0_USB_EVENT_ACTIVE_HIGH                     _MK_ENUM_CONST(1)

#define APBDEV_PMC_WAKE_LVL_0_EVENT_RES_SHIFT                   _MK_SHIFT_CONST(23)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_RES_FIELD                   (_MK_MASK_CONST(0xff) << APBDEV_PMC_WAKE_LVL_0_EVENT_RES_SHIFT)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_RES_RANGE                   30:23
#define APBDEV_PMC_WAKE_LVL_0_EVENT_RES_WOFFSET                 0x0
#define APBDEV_PMC_WAKE_LVL_0_EVENT_RES_DEFAULT                 _MK_MASK_CONST(0xff)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_RES_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_RES_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_RES_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_RES_ACTIVE_LOW                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_LVL_0_EVENT_RES_ACTIVE_HIGH                     _MK_ENUM_CONST(1)

// external reset wake level (low active!)              
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_SHIFT                     _MK_SHIFT_CONST(31)
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_LVL_0_RESET_N_SHIFT)
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_RANGE                     31:31
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_WOFFSET                   0x0
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_ACTIVE_LOW                        _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_LVL_0_RESET_N_ACTIVE_HIGH                       _MK_ENUM_CONST(1)


// Register APBDEV_PMC_WAKE_STATUS_0  
#define APBDEV_PMC_WAKE_STATUS_0                        _MK_ADDR_CONST(0x14)
#define APBDEV_PMC_WAKE_STATUS_0_SECURE                         0x0
#define APBDEV_PMC_WAKE_STATUS_0_WORD_COUNT                     0x1
#define APBDEV_PMC_WAKE_STATUS_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_WAKE_STATUS_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_WAKE_STATUS_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
// pin 0-15 wake    
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_FIELD                    (_MK_MASK_CONST(0xffff) << APBDEV_PMC_WAKE_STATUS_0_EVENT_SHIFT)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_RANGE                    15:0
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_WOFFSET                  0x0
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_DEFAULT_MASK                     _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_NOT_SET                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_SET                      _MK_ENUM_CONST(1)

// RTC wake                
#define APBDEV_PMC_WAKE_STATUS_0_RTC_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDEV_PMC_WAKE_STATUS_0_RTC_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_STATUS_0_RTC_SHIFT)
#define APBDEV_PMC_WAKE_STATUS_0_RTC_RANGE                      16:16
#define APBDEV_PMC_WAKE_STATUS_0_RTC_WOFFSET                    0x0
#define APBDEV_PMC_WAKE_STATUS_0_RTC_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_RTC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_STATUS_0_RTC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_RTC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_RTC_NOT_SET                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_STATUS_0_RTC_SET                        _MK_ENUM_CONST(1)

// KBC wake              
#define APBDEV_PMC_WAKE_STATUS_0_KBC_SHIFT                      _MK_SHIFT_CONST(17)
#define APBDEV_PMC_WAKE_STATUS_0_KBC_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_STATUS_0_KBC_SHIFT)
#define APBDEV_PMC_WAKE_STATUS_0_KBC_RANGE                      17:17
#define APBDEV_PMC_WAKE_STATUS_0_KBC_WOFFSET                    0x0
#define APBDEV_PMC_WAKE_STATUS_0_KBC_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_KBC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_STATUS_0_KBC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_KBC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_KBC_NOT_SET                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_STATUS_0_KBC_SET                        _MK_ENUM_CONST(1)

// power interrupt            
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_SHIFT                  _MK_SHIFT_CONST(18)
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_STATUS_0_PWR_INT_SHIFT)
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_RANGE                  18:18
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_WOFFSET                        0x0
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_NOT_SET                        _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_STATUS_0_PWR_INT_SET                    _MK_ENUM_CONST(1)

// USB wake events
#define APBDEV_PMC_WAKE_STATUS_0_USB_EVENT_SHIFT                        _MK_SHIFT_CONST(19)
#define APBDEV_PMC_WAKE_STATUS_0_USB_EVENT_FIELD                        (_MK_MASK_CONST(0xf) << APBDEV_PMC_WAKE_STATUS_0_USB_EVENT_SHIFT)
#define APBDEV_PMC_WAKE_STATUS_0_USB_EVENT_RANGE                        22:19
#define APBDEV_PMC_WAKE_STATUS_0_USB_EVENT_WOFFSET                      0x0
#define APBDEV_PMC_WAKE_STATUS_0_USB_EVENT_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_USB_EVENT_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define APBDEV_PMC_WAKE_STATUS_0_USB_EVENT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_USB_EVENT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_USB_EVENT_NOT_SET                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_STATUS_0_USB_EVENT_SET                  _MK_ENUM_CONST(1)

#define APBDEV_PMC_WAKE_STATUS_0_EVENT_RES_SHIFT                        _MK_SHIFT_CONST(23)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_RES_FIELD                        (_MK_MASK_CONST(0xff) << APBDEV_PMC_WAKE_STATUS_0_EVENT_RES_SHIFT)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_RES_RANGE                        30:23
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_RES_WOFFSET                      0x0
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_RES_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_RES_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_RES_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_RES_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_RES_NOT_SET                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_STATUS_0_EVENT_RES_SET                  _MK_ENUM_CONST(1)

// external reset            
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_SHIFT                  _MK_SHIFT_CONST(31)
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_WAKE_STATUS_0_RESET_N_SHIFT)
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_RANGE                  31:31
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_WOFFSET                        0x0
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_NOT_SET                        _MK_ENUM_CONST(0)
#define APBDEV_PMC_WAKE_STATUS_0_RESET_N_SET                    _MK_ENUM_CONST(1)


// Register APBDEV_PMC_SW_WAKE_STATUS_0  
#define APBDEV_PMC_SW_WAKE_STATUS_0                     _MK_ADDR_CONST(0x18)
#define APBDEV_PMC_SW_WAKE_STATUS_0_SECURE                      0x0
#define APBDEV_PMC_SW_WAKE_STATUS_0_WORD_COUNT                  0x1
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SW_WAKE_STATUS_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SW_WAKE_STATUS_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// pin 0-15 wake    
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_SHIFT                 _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_FIELD                 (_MK_MASK_CONST(0xffff) << APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_SHIFT)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_RANGE                 15:0
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_WOFFSET                       0x0
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_DISABLE                       _MK_ENUM_CONST(0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_ENABLE                        _MK_ENUM_CONST(1)

// RTC wake                
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_SHIFT                   _MK_SHIFT_CONST(16)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_SW_WAKE_STATUS_0_RTC_SHIFT)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_RANGE                   16:16
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_WOFFSET                 0x0
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_DISABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RTC_ENABLE                  _MK_ENUM_CONST(1)

// KBC wake              
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_SHIFT                   _MK_SHIFT_CONST(17)
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_SW_WAKE_STATUS_0_KBC_SHIFT)
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_RANGE                   17:17
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_WOFFSET                 0x0
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_DISABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_KBC_ENABLE                  _MK_ENUM_CONST(1)

// power interrupt            
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_SHIFT                       _MK_SHIFT_CONST(18)
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_SHIFT)
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_RANGE                       18:18
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_WOFFSET                     0x0
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_NOT_SET                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_PWR_INT_SET                 _MK_ENUM_CONST(1)

// USB wake events
#define APBDEV_PMC_SW_WAKE_STATUS_0_USB_EVENT_SHIFT                     _MK_SHIFT_CONST(19)
#define APBDEV_PMC_SW_WAKE_STATUS_0_USB_EVENT_FIELD                     (_MK_MASK_CONST(0xf) << APBDEV_PMC_SW_WAKE_STATUS_0_USB_EVENT_SHIFT)
#define APBDEV_PMC_SW_WAKE_STATUS_0_USB_EVENT_RANGE                     22:19
#define APBDEV_PMC_SW_WAKE_STATUS_0_USB_EVENT_WOFFSET                   0x0
#define APBDEV_PMC_SW_WAKE_STATUS_0_USB_EVENT_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_USB_EVENT_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define APBDEV_PMC_SW_WAKE_STATUS_0_USB_EVENT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_USB_EVENT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_USB_EVENT_NOT_SET                   _MK_ENUM_CONST(0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_USB_EVENT_SET                       _MK_ENUM_CONST(1)

#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_RES_SHIFT                     _MK_SHIFT_CONST(23)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_RES_FIELD                     (_MK_MASK_CONST(0xff) << APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_RES_SHIFT)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_RES_RANGE                     30:23
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_RES_WOFFSET                   0x0
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_RES_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_RES_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_RES_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_RES_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_RES_NOT_SET                   _MK_ENUM_CONST(0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_EVENT_RES_SET                       _MK_ENUM_CONST(1)

// external reset            
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_SHIFT                       _MK_SHIFT_CONST(31)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_SHIFT)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_RANGE                       31:31
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_WOFFSET                     0x0
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_NOT_SET                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_SW_WAKE_STATUS_0_RESET_N_SET                 _MK_ENUM_CONST(1)


// Register APBDEV_PMC_DPD_PADS_ORIDE_0  
#define APBDEV_PMC_DPD_PADS_ORIDE_0                     _MK_ADDR_CONST(0x1c)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SECURE                      0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_WORD_COUNT                  0x1
#define APBDEV_PMC_DPD_PADS_ORIDE_0_RESET_VAL                   _MK_MASK_CONST(0x200000)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_RESET_MASK                  _MK_MASK_CONST(0x3ffffff)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_READ_MASK                   _MK_MASK_CONST(0x3ffffff)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_WRITE_MASK                  _MK_MASK_CONST(0x3ffffff)
//override dpd idle state with column 0 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_RANGE                      0:0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL0_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 1 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_SHIFT                      _MK_SHIFT_CONST(1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_RANGE                      1:1
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL1_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 2 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_SHIFT                      _MK_SHIFT_CONST(2)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_RANGE                      2:2
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL2_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 3 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_SHIFT                      _MK_SHIFT_CONST(3)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_RANGE                      3:3
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL3_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 4 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_SHIFT                      _MK_SHIFT_CONST(4)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_RANGE                      4:4
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL4_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 5 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_SHIFT                      _MK_SHIFT_CONST(5)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_RANGE                      5:5
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL5_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 6 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_SHIFT                      _MK_SHIFT_CONST(6)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_RANGE                      6:6
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL6_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 7 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_SHIFT                      _MK_SHIFT_CONST(7)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_RANGE                      7:7
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL7_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 8 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_SHIFT                      _MK_SHIFT_CONST(8)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_RANGE                      8:8
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL8_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 9 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_SHIFT                      _MK_SHIFT_CONST(9)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_RANGE                      9:9
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL9_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with column 10 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_SHIFT                     _MK_SHIFT_CONST(10)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_RANGE                     10:10
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_WOFFSET                   0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_DISABLE                   _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL10_ENABLE                    _MK_ENUM_CONST(1)

//override dpd idle state with column 11 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_SHIFT                     _MK_SHIFT_CONST(11)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_RANGE                     11:11
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_WOFFSET                   0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_DISABLE                   _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL11_ENABLE                    _MK_ENUM_CONST(1)

//override dpd idle state with column 12 output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_SHIFT                     _MK_SHIFT_CONST(12)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_RANGE                     12:12
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_WOFFSET                   0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_DISABLE                   _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_COL12_ENABLE                    _MK_ENUM_CONST(1)

//override dpd idle state with row 0  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_SHIFT                      _MK_SHIFT_CONST(13)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_RANGE                      13:13
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW0_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with row 1  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_SHIFT                      _MK_SHIFT_CONST(14)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_RANGE                      14:14
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW1_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with row 2  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_SHIFT                      _MK_SHIFT_CONST(15)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_RANGE                      15:15
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW2_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with row 3  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_RANGE                      16:16
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW3_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with row 4  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_SHIFT                      _MK_SHIFT_CONST(17)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_RANGE                      17:17
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW4_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with row 5  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_SHIFT                      _MK_SHIFT_CONST(18)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_RANGE                      18:18
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW5_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with row 6  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_SHIFT                      _MK_SHIFT_CONST(19)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_RANGE                      19:19
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW6_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with blink ouptut
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_SHIFT                 _MK_SHIFT_CONST(20)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_FIELD                 (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_RANGE                 20:20
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_WOFFSET                       0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_DISABLE                       _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_BLINK_ENABLE                        _MK_ENUM_CONST(1)

//override dpd idle state with column with sys_clk_request output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_SHIFT                       _MK_SHIFT_CONST(21)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_RANGE                       21:21
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_WOFFSET                     0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_DEFAULT                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_SYS_CLK_ENABLE                      _MK_ENUM_CONST(1)

//override dpd idle state with row 7  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW7_SHIFT                      _MK_SHIFT_CONST(22)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW7_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW7_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW7_RANGE                      22:22
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW7_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW7_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW7_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW7_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW7_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with row 8  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW8_SHIFT                      _MK_SHIFT_CONST(23)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW8_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW8_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW8_RANGE                      23:23
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW8_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW8_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW8_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW8_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW8_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW8_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW8_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with row 9  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW9_SHIFT                      _MK_SHIFT_CONST(24)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW9_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW9_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW9_RANGE                      24:24
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW9_WOFFSET                    0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW9_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW9_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW9_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW9_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW9_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW9_ENABLE                     _MK_ENUM_CONST(1)

//override dpd idle state with row 10  output
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW10_SHIFT                     _MK_SHIFT_CONST(25)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW10_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW10_SHIFT)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW10_RANGE                     25:25
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW10_WOFFSET                   0x0
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW10_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW10_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW10_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW10_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW10_DISABLE                   _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_PADS_ORIDE_0_KBC_ROW10_ENABLE                    _MK_ENUM_CONST(1)


// Register APBDEV_PMC_DPD_SAMPLE_0  
#define APBDEV_PMC_DPD_SAMPLE_0                 _MK_ADDR_CONST(0x20)
#define APBDEV_PMC_DPD_SAMPLE_0_SECURE                  0x0
#define APBDEV_PMC_DPD_SAMPLE_0_WORD_COUNT                      0x1
#define APBDEV_PMC_DPD_SAMPLE_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_SAMPLE_0_RESET_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_SAMPLE_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_SAMPLE_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_SAMPLE_0_READ_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_SAMPLE_0_WRITE_MASK                      _MK_MASK_CONST(0x1)
// will set sampling of pads value
#define APBDEV_PMC_DPD_SAMPLE_0_ON_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_DPD_SAMPLE_0_ON_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_SAMPLE_0_ON_SHIFT)
#define APBDEV_PMC_DPD_SAMPLE_0_ON_RANGE                        0:0
#define APBDEV_PMC_DPD_SAMPLE_0_ON_WOFFSET                      0x0
#define APBDEV_PMC_DPD_SAMPLE_0_ON_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_SAMPLE_0_ON_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_SAMPLE_0_ON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_SAMPLE_0_ON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_SAMPLE_0_ON_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_SAMPLE_0_ON_ENABLE                       _MK_ENUM_CONST(1)


// Register APBDEV_PMC_DPD_ENABLE_0  
#define APBDEV_PMC_DPD_ENABLE_0                 _MK_ADDR_CONST(0x24)
#define APBDEV_PMC_DPD_ENABLE_0_SECURE                  0x0
#define APBDEV_PMC_DPD_ENABLE_0_WORD_COUNT                      0x1
#define APBDEV_PMC_DPD_ENABLE_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_ENABLE_0_RESET_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_ENABLE_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_ENABLE_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_ENABLE_0_READ_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_ENABLE_0_WRITE_MASK                      _MK_MASK_CONST(0x1)
// will set sampling of pads value
#define APBDEV_PMC_DPD_ENABLE_0_ON_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_DPD_ENABLE_0_ON_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_DPD_ENABLE_0_ON_SHIFT)
#define APBDEV_PMC_DPD_ENABLE_0_ON_RANGE                        0:0
#define APBDEV_PMC_DPD_ENABLE_0_ON_WOFFSET                      0x0
#define APBDEV_PMC_DPD_ENABLE_0_ON_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_ENABLE_0_ON_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DPD_ENABLE_0_ON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_ENABLE_0_ON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DPD_ENABLE_0_ON_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_DPD_ENABLE_0_ON_ENABLE                       _MK_ENUM_CONST(1)


// Register APBDEV_PMC_PWRGATE_TIMER_OFF_0  
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0                  _MK_ADDR_CONST(0x28)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_SECURE                   0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_WORD_COUNT                       0x1
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RESET_VAL                        _MK_MASK_CONST(0xeca97531)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// timer value for rail 0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_RANGE                      3:0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_WOFFSET                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// timer value for rail 1
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_SHIFT                      _MK_SHIFT_CONST(4)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_RANGE                      7:4
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_WOFFSET                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_DEFAULT                    _MK_MASK_CONST(0x3)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// timer value for rail 2
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_SHIFT                      _MK_SHIFT_CONST(8)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_RANGE                      11:8
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_WOFFSET                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_DEFAULT                    _MK_MASK_CONST(0x5)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// timer value for rail 3
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_SHIFT                      _MK_SHIFT_CONST(12)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_RANGE                      15:12
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_WOFFSET                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_DEFAULT                    _MK_MASK_CONST(0x7)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// timer value for rail 4
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_SHIFT                      _MK_SHIFT_CONST(16)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_RANGE                      19:16
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_WOFFSET                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_DEFAULT                    _MK_MASK_CONST(0x9)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// timer value for rail 5
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_SHIFT                      _MK_SHIFT_CONST(20)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_RANGE                      23:20
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_WOFFSET                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_DEFAULT                    _MK_MASK_CONST(0xa)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// timer value for rail 6
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_SHIFT                      _MK_SHIFT_CONST(24)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_RANGE                      27:24
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_WOFFSET                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_DEFAULT                    _MK_MASK_CONST(0xc)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// timer value for rail 7
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_SHIFT                      _MK_SHIFT_CONST(28)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_FIELD                      (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_RANGE                      31:28
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_WOFFSET                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_DEFAULT                    _MK_MASK_CONST(0xe)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_OFF_0_RAIL7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_PWRGATE_TIMER_ON_0  
#define APBDEV_PMC_PWRGATE_TIMER_ON_0                   _MK_ADDR_CONST(0x2c)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_SECURE                    0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_WORD_COUNT                        0x1
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RESET_VAL                         _MK_MASK_CONST(0xeca97531)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// timer value for rail 0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_SHIFT                       _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_FIELD                       (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_RANGE                       3:0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_WOFFSET                     0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_DEFAULT                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// timer value for rail 1
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_SHIFT                       _MK_SHIFT_CONST(4)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_FIELD                       (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_RANGE                       7:4
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_WOFFSET                     0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_DEFAULT                     _MK_MASK_CONST(0x3)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// timer value for rail 2
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_SHIFT                       _MK_SHIFT_CONST(8)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_FIELD                       (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_RANGE                       11:8
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_WOFFSET                     0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_DEFAULT                     _MK_MASK_CONST(0x5)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// timer value for rail 3
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_SHIFT                       _MK_SHIFT_CONST(12)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_FIELD                       (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_RANGE                       15:12
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_WOFFSET                     0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_DEFAULT                     _MK_MASK_CONST(0x7)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL3_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// timer value for rail 4
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_SHIFT                       _MK_SHIFT_CONST(16)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_FIELD                       (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_RANGE                       19:16
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_WOFFSET                     0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_DEFAULT                     _MK_MASK_CONST(0x9)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL4_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// timer value for rail 5
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_SHIFT                       _MK_SHIFT_CONST(20)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_FIELD                       (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_RANGE                       23:20
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_WOFFSET                     0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_DEFAULT                     _MK_MASK_CONST(0xa)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL5_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// timer value for rail 6
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_SHIFT                       _MK_SHIFT_CONST(24)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_FIELD                       (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_RANGE                       27:24
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_WOFFSET                     0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_DEFAULT                     _MK_MASK_CONST(0xc)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL6_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// timer value for rail 7
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_SHIFT                       _MK_SHIFT_CONST(28)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_FIELD                       (_MK_MASK_CONST(0xf) << APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_SHIFT)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_RANGE                       31:28
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_WOFFSET                     0x0
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_DEFAULT                     _MK_MASK_CONST(0xe)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TIMER_ON_0_RAIL7_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_PWRGATE_TOGGLE_0  
#define APBDEV_PMC_PWRGATE_TOGGLE_0                     _MK_ADDR_CONST(0x30)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_SECURE                      0x0
#define APBDEV_PMC_PWRGATE_TOGGLE_0_WORD_COUNT                  0x1
#define APBDEV_PMC_PWRGATE_TOGGLE_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_RESET_MASK                  _MK_MASK_CONST(0x107)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_READ_MASK                   _MK_MASK_CONST(0x107)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_WRITE_MASK                  _MK_MASK_CONST(0x107)
//id of partition to be toggled 
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_FIELD                        (_MK_MASK_CONST(0x7) << APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_SHIFT)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_RANGE                        2:0
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_WOFFSET                      0x0
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_DEFAULT_MASK                 _MK_MASK_CONST(0x7)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_CP                   _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_TD                   _MK_ENUM_CONST(1)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_VE                   _MK_ENUM_CONST(2)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_VDE                  _MK_ENUM_CONST(4)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_PCX                  _MK_ENUM_CONST(3)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_L2C                  _MK_ENUM_CONST(5)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_PARTID_MPE                  _MK_ENUM_CONST(6)

//start power down/up
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_SHIFT                 _MK_SHIFT_CONST(8)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_FIELD                 (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWRGATE_TOGGLE_0_START_SHIFT)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_RANGE                 8:8
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_WOFFSET                       0x0
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_DISABLE                       _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWRGATE_TOGGLE_0_START_ENABLE                        _MK_ENUM_CONST(1)


// Register APBDEV_PMC_REMOVE_CLAMPING_CMD_0  
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0                        _MK_ADDR_CONST(0x34)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_SECURE                         0x0
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_WORD_COUNT                     0x1
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_RESET_MASK                     _MK_MASK_CONST(0x7f)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_READ_MASK                      _MK_MASK_CONST(0x7f)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_WRITE_MASK                     _MK_MASK_CONST(0x7f)
//remove clamping to CPU
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_SHIFT)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_RANGE                      0:0
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_WOFFSET                    0x0
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_CPU_ENABLE                     _MK_ENUM_CONST(1)

//remove clamping to TD
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_SHIFT                       _MK_SHIFT_CONST(1)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_SHIFT)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_RANGE                       1:1
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_WOFFSET                     0x0
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_TD_ENABLE                      _MK_ENUM_CONST(1)

//remove clamping to VE
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_SHIFT                       _MK_SHIFT_CONST(2)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_SHIFT)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_RANGE                       2:2
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_WOFFSET                     0x0
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VE_ENABLE                      _MK_ENUM_CONST(1)

//remove clamping to VDE
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VDE_SHIFT                      _MK_SHIFT_CONST(3)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VDE_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VDE_SHIFT)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VDE_RANGE                      3:3
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VDE_WOFFSET                    0x0
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VDE_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VDE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VDE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VDE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VDE_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_VDE_ENABLE                     _MK_ENUM_CONST(1)

//remove clamping to PCX
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_PCX_SHIFT                      _MK_SHIFT_CONST(4)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_PCX_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_REMOVE_CLAMPING_CMD_0_PCX_SHIFT)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_PCX_RANGE                      4:4
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_PCX_WOFFSET                    0x0
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_PCX_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_PCX_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_PCX_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_PCX_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_PCX_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_PCX_ENABLE                     _MK_ENUM_CONST(1)

//remove clamping to L2_CACHE
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_L2C_SHIFT                      _MK_SHIFT_CONST(5)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_L2C_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_REMOVE_CLAMPING_CMD_0_L2C_SHIFT)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_L2C_RANGE                      5:5
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_L2C_WOFFSET                    0x0
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_L2C_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_L2C_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_L2C_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_L2C_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_L2C_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_L2C_ENABLE                     _MK_ENUM_CONST(1)

//remove clamping to MPE_CACHE
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_MPE_SHIFT                      _MK_SHIFT_CONST(6)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_MPE_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_REMOVE_CLAMPING_CMD_0_MPE_SHIFT)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_MPE_RANGE                      6:6
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_MPE_WOFFSET                    0x0
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_MPE_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_MPE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_MPE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_MPE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_MPE_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_REMOVE_CLAMPING_CMD_0_MPE_ENABLE                     _MK_ENUM_CONST(1)


// Register APBDEV_PMC_PWRGATE_STATUS_0  
#define APBDEV_PMC_PWRGATE_STATUS_0                     _MK_ADDR_CONST(0x38)
#define APBDEV_PMC_PWRGATE_STATUS_0_SECURE                      0x0
#define APBDEV_PMC_PWRGATE_STATUS_0_WORD_COUNT                  0x1
#define APBDEV_PMC_PWRGATE_STATUS_0_RESET_VAL                   _MK_MASK_CONST(0x7f)
#define APBDEV_PMC_PWRGATE_STATUS_0_RESET_MASK                  _MK_MASK_CONST(0x7f)
#define APBDEV_PMC_PWRGATE_STATUS_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_READ_MASK                   _MK_MASK_CONST(0x7f)
#define APBDEV_PMC_PWRGATE_STATUS_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
//status of CPU partition
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_SHIFT                   _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWRGATE_STATUS_0_CPU_SHIFT)
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_RANGE                   0:0
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_WOFFSET                 0x0
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_DEFAULT                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_OFF                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWRGATE_STATUS_0_CPU_ON                      _MK_ENUM_CONST(1)

//status of TD  Partition
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_SHIFT                    _MK_SHIFT_CONST(1)
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWRGATE_STATUS_0_TD_SHIFT)
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_RANGE                    1:1
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_WOFFSET                  0x0
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_DEFAULT                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_OFF                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWRGATE_STATUS_0_TD_ON                       _MK_ENUM_CONST(1)

//status of VE  partition
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_SHIFT                    _MK_SHIFT_CONST(2)
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWRGATE_STATUS_0_VE_SHIFT)
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_RANGE                    2:2
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_WOFFSET                  0x0
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_DEFAULT                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_OFF                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWRGATE_STATUS_0_VE_ON                       _MK_ENUM_CONST(1)

//status of VDE  partition
#define APBDEV_PMC_PWRGATE_STATUS_0_VDE_SHIFT                   _MK_SHIFT_CONST(4)
#define APBDEV_PMC_PWRGATE_STATUS_0_VDE_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWRGATE_STATUS_0_VDE_SHIFT)
#define APBDEV_PMC_PWRGATE_STATUS_0_VDE_RANGE                   4:4
#define APBDEV_PMC_PWRGATE_STATUS_0_VDE_WOFFSET                 0x0
#define APBDEV_PMC_PWRGATE_STATUS_0_VDE_DEFAULT                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_VDE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_VDE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_VDE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_VDE_OFF                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWRGATE_STATUS_0_VDE_ON                      _MK_ENUM_CONST(1)

//status of PCX  partition
#define APBDEV_PMC_PWRGATE_STATUS_0_PCX_SHIFT                   _MK_SHIFT_CONST(3)
#define APBDEV_PMC_PWRGATE_STATUS_0_PCX_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWRGATE_STATUS_0_PCX_SHIFT)
#define APBDEV_PMC_PWRGATE_STATUS_0_PCX_RANGE                   3:3
#define APBDEV_PMC_PWRGATE_STATUS_0_PCX_WOFFSET                 0x0
#define APBDEV_PMC_PWRGATE_STATUS_0_PCX_DEFAULT                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_PCX_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_PCX_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_PCX_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_PCX_OFF                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWRGATE_STATUS_0_PCX_ON                      _MK_ENUM_CONST(1)

//status of L2C  partition
#define APBDEV_PMC_PWRGATE_STATUS_0_L2C_SHIFT                   _MK_SHIFT_CONST(5)
#define APBDEV_PMC_PWRGATE_STATUS_0_L2C_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWRGATE_STATUS_0_L2C_SHIFT)
#define APBDEV_PMC_PWRGATE_STATUS_0_L2C_RANGE                   5:5
#define APBDEV_PMC_PWRGATE_STATUS_0_L2C_WOFFSET                 0x0
#define APBDEV_PMC_PWRGATE_STATUS_0_L2C_DEFAULT                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_L2C_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_L2C_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_L2C_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_L2C_OFF                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWRGATE_STATUS_0_L2C_ON                      _MK_ENUM_CONST(1)

//status of MPE  partition
#define APBDEV_PMC_PWRGATE_STATUS_0_MPE_SHIFT                   _MK_SHIFT_CONST(6)
#define APBDEV_PMC_PWRGATE_STATUS_0_MPE_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWRGATE_STATUS_0_MPE_SHIFT)
#define APBDEV_PMC_PWRGATE_STATUS_0_MPE_RANGE                   6:6
#define APBDEV_PMC_PWRGATE_STATUS_0_MPE_WOFFSET                 0x0
#define APBDEV_PMC_PWRGATE_STATUS_0_MPE_DEFAULT                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_MPE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWRGATE_STATUS_0_MPE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_MPE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGATE_STATUS_0_MPE_OFF                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWRGATE_STATUS_0_MPE_ON                      _MK_ENUM_CONST(1)


// Register APBDEV_PMC_PWRGOOD_TIMER_0  
#define APBDEV_PMC_PWRGOOD_TIMER_0                      _MK_ADDR_CONST(0x3c)
#define APBDEV_PMC_PWRGOOD_TIMER_0_SECURE                       0x0
#define APBDEV_PMC_PWRGOOD_TIMER_0_WORD_COUNT                   0x1
#define APBDEV_PMC_PWRGOOD_TIMER_0_RESET_VAL                    _MK_MASK_CONST(0x7f)
#define APBDEV_PMC_PWRGOOD_TIMER_0_RESET_MASK                   _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_PWRGOOD_TIMER_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGOOD_TIMER_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGOOD_TIMER_0_READ_MASK                    _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_PWRGOOD_TIMER_0_WRITE_MASK                   _MK_MASK_CONST(0xffff)
// pmu timer * 32
#define APBDEV_PMC_PWRGOOD_TIMER_0_PMU_TIM_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PWRGOOD_TIMER_0_PMU_TIM_FIELD                        (_MK_MASK_CONST(0xff) << APBDEV_PMC_PWRGOOD_TIMER_0_PMU_TIM_SHIFT)
#define APBDEV_PMC_PWRGOOD_TIMER_0_PMU_TIM_RANGE                        7:0
#define APBDEV_PMC_PWRGOOD_TIMER_0_PMU_TIM_WOFFSET                      0x0
#define APBDEV_PMC_PWRGOOD_TIMER_0_PMU_TIM_DEFAULT                      _MK_MASK_CONST(0x7f)
#define APBDEV_PMC_PWRGOOD_TIMER_0_PMU_TIM_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define APBDEV_PMC_PWRGOOD_TIMER_0_PMU_TIM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGOOD_TIMER_0_PMU_TIM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// xtal timer * 32
#define APBDEV_PMC_PWRGOOD_TIMER_0_DATA_SHIFT                   _MK_SHIFT_CONST(8)
#define APBDEV_PMC_PWRGOOD_TIMER_0_DATA_FIELD                   (_MK_MASK_CONST(0xff) << APBDEV_PMC_PWRGOOD_TIMER_0_DATA_SHIFT)
#define APBDEV_PMC_PWRGOOD_TIMER_0_DATA_RANGE                   15:8
#define APBDEV_PMC_PWRGOOD_TIMER_0_DATA_WOFFSET                 0x0
#define APBDEV_PMC_PWRGOOD_TIMER_0_DATA_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGOOD_TIMER_0_DATA_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define APBDEV_PMC_PWRGOOD_TIMER_0_DATA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWRGOOD_TIMER_0_DATA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_BLINK_TIMER_0  
#define APBDEV_PMC_BLINK_TIMER_0                        _MK_ADDR_CONST(0x40)
#define APBDEV_PMC_BLINK_TIMER_0_SECURE                         0x0
#define APBDEV_PMC_BLINK_TIMER_0_WORD_COUNT                     0x1
#define APBDEV_PMC_BLINK_TIMER_0_RESET_VAL                      _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_BLINK_TIMER_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_BLINK_TIMER_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BLINK_TIMER_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BLINK_TIMER_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_BLINK_TIMER_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
// time on 
#define APBDEV_PMC_BLINK_TIMER_0_DATA_ON_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_ON_FIELD                  (_MK_MASK_CONST(0x7fff) << APBDEV_PMC_BLINK_TIMER_0_DATA_ON_SHIFT)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_ON_RANGE                  14:0
#define APBDEV_PMC_BLINK_TIMER_0_DATA_ON_WOFFSET                        0x0
#define APBDEV_PMC_BLINK_TIMER_0_DATA_ON_DEFAULT                        _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_ON_DEFAULT_MASK                   _MK_MASK_CONST(0x7fff)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_ON_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_ON_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// if 0 32khz clock 
#define APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_SHIFT                      _MK_SHIFT_CONST(15)
#define APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_SHIFT)
#define APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_RANGE                      15:15
#define APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_WOFFSET                    0x0
#define APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BLINK_TIMER_0_FORCE_BLINK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// time off         
#define APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_SHIFT                 _MK_SHIFT_CONST(16)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_FIELD                 (_MK_MASK_CONST(0xffff) << APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_SHIFT)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_RANGE                 31:16
#define APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_WOFFSET                       0x0
#define APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_DEFAULT                       _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BLINK_TIMER_0_DATA_OFF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_NO_IOPOWER_0  
#define APBDEV_PMC_NO_IOPOWER_0                 _MK_ADDR_CONST(0x44)
#define APBDEV_PMC_NO_IOPOWER_0_SECURE                  0x0
#define APBDEV_PMC_NO_IOPOWER_0_WORD_COUNT                      0x1
#define APBDEV_PMC_NO_IOPOWER_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_RESET_MASK                      _MK_MASK_CONST(0x3ff)
#define APBDEV_PMC_NO_IOPOWER_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_READ_MASK                       _MK_MASK_CONST(0x3ff)
#define APBDEV_PMC_NO_IOPOWER_0_WRITE_MASK                      _MK_MASK_CONST(0x3ff)
//rail ao IOs   
#define APBDEV_PMC_NO_IOPOWER_0_SYS_SHIFT                       _MK_SHIFT_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_SYS_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_SYS_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_SYS_RANGE                       0:0
#define APBDEV_PMC_NO_IOPOWER_0_SYS_WOFFSET                     0x0
#define APBDEV_PMC_NO_IOPOWER_0_SYS_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_SYS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_SYS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_SYS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_SYS_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_SYS_ENABLE                      _MK_ENUM_CONST(1)

//rail at3 IOs 
#define APBDEV_PMC_NO_IOPOWER_0_NAND_SHIFT                      _MK_SHIFT_CONST(1)
#define APBDEV_PMC_NO_IOPOWER_0_NAND_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_NAND_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_NAND_RANGE                      1:1
#define APBDEV_PMC_NO_IOPOWER_0_NAND_WOFFSET                    0x0
#define APBDEV_PMC_NO_IOPOWER_0_NAND_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_NAND_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_NAND_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_NAND_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_NAND_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_NAND_ENABLE                     _MK_ENUM_CONST(1)

//rail dbg IOs   
#define APBDEV_PMC_NO_IOPOWER_0_UART_SHIFT                      _MK_SHIFT_CONST(2)
#define APBDEV_PMC_NO_IOPOWER_0_UART_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_UART_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_UART_RANGE                      2:2
#define APBDEV_PMC_NO_IOPOWER_0_UART_WOFFSET                    0x0
#define APBDEV_PMC_NO_IOPOWER_0_UART_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_UART_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_UART_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_UART_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_UART_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_UART_ENABLE                     _MK_ENUM_CONST(1)

//rail dlcd IOs   
#define APBDEV_PMC_NO_IOPOWER_0_BB_SHIFT                        _MK_SHIFT_CONST(3)
#define APBDEV_PMC_NO_IOPOWER_0_BB_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_BB_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_BB_RANGE                        3:3
#define APBDEV_PMC_NO_IOPOWER_0_BB_WOFFSET                      0x0
#define APBDEV_PMC_NO_IOPOWER_0_BB_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_BB_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_BB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_BB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_BB_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_BB_ENABLE                       _MK_ENUM_CONST(1)

//rail dvi IOs   
#define APBDEV_PMC_NO_IOPOWER_0_VI_SHIFT                        _MK_SHIFT_CONST(4)
#define APBDEV_PMC_NO_IOPOWER_0_VI_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_VI_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_VI_RANGE                        4:4
#define APBDEV_PMC_NO_IOPOWER_0_VI_WOFFSET                      0x0
#define APBDEV_PMC_NO_IOPOWER_0_VI_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_VI_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_VI_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_VI_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_VI_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_VI_ENABLE                       _MK_ENUM_CONST(1)

//rail i2s IOs   
#define APBDEV_PMC_NO_IOPOWER_0_AUDIO_SHIFT                     _MK_SHIFT_CONST(5)
#define APBDEV_PMC_NO_IOPOWER_0_AUDIO_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_AUDIO_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_AUDIO_RANGE                     5:5
#define APBDEV_PMC_NO_IOPOWER_0_AUDIO_WOFFSET                   0x0
#define APBDEV_PMC_NO_IOPOWER_0_AUDIO_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_AUDIO_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_AUDIO_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_AUDIO_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_AUDIO_DISABLE                   _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_AUDIO_ENABLE                    _MK_ENUM_CONST(1)

//rail lcd IOs   
#define APBDEV_PMC_NO_IOPOWER_0_LCD_SHIFT                       _MK_SHIFT_CONST(6)
#define APBDEV_PMC_NO_IOPOWER_0_LCD_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_LCD_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_LCD_RANGE                       6:6
#define APBDEV_PMC_NO_IOPOWER_0_LCD_WOFFSET                     0x0
#define APBDEV_PMC_NO_IOPOWER_0_LCD_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_LCD_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_LCD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_LCD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_LCD_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_LCD_ENABLE                      _MK_ENUM_CONST(1)

//rail mem IOs   
#define APBDEV_PMC_NO_IOPOWER_0_MEM_SHIFT                       _MK_SHIFT_CONST(7)
#define APBDEV_PMC_NO_IOPOWER_0_MEM_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_MEM_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_MEM_RANGE                       7:7
#define APBDEV_PMC_NO_IOPOWER_0_MEM_WOFFSET                     0x0
#define APBDEV_PMC_NO_IOPOWER_0_MEM_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_MEM_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_MEM_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_MEM_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_MEM_DISABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_MEM_ENABLE                      _MK_ENUM_CONST(1)

//rail sd IOs   
#define APBDEV_PMC_NO_IOPOWER_0_SD_SHIFT                        _MK_SHIFT_CONST(8)
#define APBDEV_PMC_NO_IOPOWER_0_SD_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_SD_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_SD_RANGE                        8:8
#define APBDEV_PMC_NO_IOPOWER_0_SD_WOFFSET                      0x0
#define APBDEV_PMC_NO_IOPOWER_0_SD_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_SD_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_SD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_SD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_SD_DISABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_SD_ENABLE                       _MK_ENUM_CONST(1)

//rail mipi IOs   
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_SHIFT                      _MK_SHIFT_CONST(9)
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_NO_IOPOWER_0_MIPI_SHIFT)
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_RANGE                      9:9
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_WOFFSET                    0x0
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_DISABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_NO_IOPOWER_0_MIPI_ENABLE                     _MK_ENUM_CONST(1)


// Register APBDEV_PMC_PWR_DET_0  
#define APBDEV_PMC_PWR_DET_0                    _MK_ADDR_CONST(0x48)
#define APBDEV_PMC_PWR_DET_0_SECURE                     0x0
#define APBDEV_PMC_PWR_DET_0_WORD_COUNT                         0x1
#define APBDEV_PMC_PWR_DET_0_RESET_VAL                  _MK_MASK_CONST(0x1ff)
#define APBDEV_PMC_PWR_DET_0_RESET_MASK                         _MK_MASK_CONST(0x1ff)
#define APBDEV_PMC_PWR_DET_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_READ_MASK                  _MK_MASK_CONST(0x1ff)
#define APBDEV_PMC_PWR_DET_0_WRITE_MASK                         _MK_MASK_CONST(0x1ff)
//rail ao IOs   
#define APBDEV_PMC_PWR_DET_0_SYS_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PWR_DET_0_SYS_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_SYS_SHIFT)
#define APBDEV_PMC_PWR_DET_0_SYS_RANGE                  0:0
#define APBDEV_PMC_PWR_DET_0_SYS_WOFFSET                        0x0
#define APBDEV_PMC_PWR_DET_0_SYS_DEFAULT                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_SYS_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_SYS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_SYS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_SYS_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_SYS_DISABLE                        _MK_ENUM_CONST(1)

//rail at3 IOs 
#define APBDEV_PMC_PWR_DET_0_NAND_SHIFT                 _MK_SHIFT_CONST(1)
#define APBDEV_PMC_PWR_DET_0_NAND_FIELD                 (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_NAND_SHIFT)
#define APBDEV_PMC_PWR_DET_0_NAND_RANGE                 1:1
#define APBDEV_PMC_PWR_DET_0_NAND_WOFFSET                       0x0
#define APBDEV_PMC_PWR_DET_0_NAND_DEFAULT                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_NAND_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_NAND_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_NAND_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_NAND_ENABLE                        _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_NAND_DISABLE                       _MK_ENUM_CONST(1)

//rail dbg IOs   
#define APBDEV_PMC_PWR_DET_0_UART_SHIFT                 _MK_SHIFT_CONST(2)
#define APBDEV_PMC_PWR_DET_0_UART_FIELD                 (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_UART_SHIFT)
#define APBDEV_PMC_PWR_DET_0_UART_RANGE                 2:2
#define APBDEV_PMC_PWR_DET_0_UART_WOFFSET                       0x0
#define APBDEV_PMC_PWR_DET_0_UART_DEFAULT                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_UART_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_UART_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_UART_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_UART_ENABLE                        _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_UART_DISABLE                       _MK_ENUM_CONST(1)

//rail dlcd IOs   
#define APBDEV_PMC_PWR_DET_0_BB_SHIFT                   _MK_SHIFT_CONST(3)
#define APBDEV_PMC_PWR_DET_0_BB_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_BB_SHIFT)
#define APBDEV_PMC_PWR_DET_0_BB_RANGE                   3:3
#define APBDEV_PMC_PWR_DET_0_BB_WOFFSET                 0x0
#define APBDEV_PMC_PWR_DET_0_BB_DEFAULT                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_BB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_BB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_BB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_BB_ENABLE                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_BB_DISABLE                 _MK_ENUM_CONST(1)

//rail dvi IOs   
#define APBDEV_PMC_PWR_DET_0_VI_SHIFT                   _MK_SHIFT_CONST(4)
#define APBDEV_PMC_PWR_DET_0_VI_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_VI_SHIFT)
#define APBDEV_PMC_PWR_DET_0_VI_RANGE                   4:4
#define APBDEV_PMC_PWR_DET_0_VI_WOFFSET                 0x0
#define APBDEV_PMC_PWR_DET_0_VI_DEFAULT                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_VI_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_VI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_VI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_VI_ENABLE                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_VI_DISABLE                 _MK_ENUM_CONST(1)

//rail i2s IOs   
#define APBDEV_PMC_PWR_DET_0_AUDIO_SHIFT                        _MK_SHIFT_CONST(5)
#define APBDEV_PMC_PWR_DET_0_AUDIO_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_AUDIO_SHIFT)
#define APBDEV_PMC_PWR_DET_0_AUDIO_RANGE                        5:5
#define APBDEV_PMC_PWR_DET_0_AUDIO_WOFFSET                      0x0
#define APBDEV_PMC_PWR_DET_0_AUDIO_DEFAULT                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_AUDIO_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_AUDIO_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_AUDIO_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_AUDIO_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_AUDIO_DISABLE                      _MK_ENUM_CONST(1)

//rail lcd IOs   
#define APBDEV_PMC_PWR_DET_0_LCD_SHIFT                  _MK_SHIFT_CONST(6)
#define APBDEV_PMC_PWR_DET_0_LCD_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_LCD_SHIFT)
#define APBDEV_PMC_PWR_DET_0_LCD_RANGE                  6:6
#define APBDEV_PMC_PWR_DET_0_LCD_WOFFSET                        0x0
#define APBDEV_PMC_PWR_DET_0_LCD_DEFAULT                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_LCD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_LCD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_LCD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_LCD_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_LCD_DISABLE                        _MK_ENUM_CONST(1)

//rail mem IOs   
#define APBDEV_PMC_PWR_DET_0_MEM_SHIFT                  _MK_SHIFT_CONST(7)
#define APBDEV_PMC_PWR_DET_0_MEM_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_MEM_SHIFT)
#define APBDEV_PMC_PWR_DET_0_MEM_RANGE                  7:7
#define APBDEV_PMC_PWR_DET_0_MEM_WOFFSET                        0x0
#define APBDEV_PMC_PWR_DET_0_MEM_DEFAULT                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_MEM_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_MEM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_MEM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_MEM_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_MEM_DISABLE                        _MK_ENUM_CONST(1)

//rail sd IOs   
#define APBDEV_PMC_PWR_DET_0_SD_SHIFT                   _MK_SHIFT_CONST(8)
#define APBDEV_PMC_PWR_DET_0_SD_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_0_SD_SHIFT)
#define APBDEV_PMC_PWR_DET_0_SD_RANGE                   8:8
#define APBDEV_PMC_PWR_DET_0_SD_WOFFSET                 0x0
#define APBDEV_PMC_PWR_DET_0_SD_DEFAULT                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_SD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_0_SD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_SD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_0_SD_ENABLE                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_0_SD_DISABLE                 _MK_ENUM_CONST(1)


// Register APBDEV_PMC_PWR_DET_LATCH_0  
#define APBDEV_PMC_PWR_DET_LATCH_0                      _MK_ADDR_CONST(0x4c)
#define APBDEV_PMC_PWR_DET_LATCH_0_SECURE                       0x0
#define APBDEV_PMC_PWR_DET_LATCH_0_WORD_COUNT                   0x1
#define APBDEV_PMC_PWR_DET_LATCH_0_RESET_VAL                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_LATCH_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_LATCH_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_LATCH_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_LATCH_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_LATCH_0_WRITE_MASK                   _MK_MASK_CONST(0x1)
//power detect latch, latches value as long set to 1  
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_LATCH_0_LATCH_SHIFT)
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_RANGE                  0:0
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_WOFFSET                        0x0
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_DEFAULT                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_ENABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_LATCH_0_LATCH_DISABLE                        _MK_ENUM_CONST(1)


// Register APBDEV_PMC_SCRATCH0_0  // Scratch register 
#define APBDEV_PMC_SCRATCH0_0                   _MK_ADDR_CONST(0x50)
#define APBDEV_PMC_SCRATCH0_0_SECURE                    0x0
#define APBDEV_PMC_SCRATCH0_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH0_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH0_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH0_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH0_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH0_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH0_0_SCRATCH0_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH0_0_SCRATCH0_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH0_0_SCRATCH0_SHIFT)
#define APBDEV_PMC_SCRATCH0_0_SCRATCH0_RANGE                    31:0
#define APBDEV_PMC_SCRATCH0_0_SCRATCH0_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH0_0_SCRATCH0_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH0_0_SCRATCH0_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH0_0_SCRATCH0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH0_0_SCRATCH0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH1_0  // Scratch register 
#define APBDEV_PMC_SCRATCH1_0                   _MK_ADDR_CONST(0x54)
#define APBDEV_PMC_SCRATCH1_0_SECURE                    0x0
#define APBDEV_PMC_SCRATCH1_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH1_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH1_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH1_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH1_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH1_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH1_0_SCRATCH1_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH1_0_SCRATCH1_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH1_0_SCRATCH1_SHIFT)
#define APBDEV_PMC_SCRATCH1_0_SCRATCH1_RANGE                    31:0
#define APBDEV_PMC_SCRATCH1_0_SCRATCH1_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH1_0_SCRATCH1_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH1_0_SCRATCH1_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH1_0_SCRATCH1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH1_0_SCRATCH1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH2_0  // Scratch register 
#define APBDEV_PMC_SCRATCH2_0                   _MK_ADDR_CONST(0x58)
#define APBDEV_PMC_SCRATCH2_0_SECURE                    0x0
#define APBDEV_PMC_SCRATCH2_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH2_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH2_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH2_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH2_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH2_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH2_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH2_0_SCRATCH2_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH2_0_SCRATCH2_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH2_0_SCRATCH2_SHIFT)
#define APBDEV_PMC_SCRATCH2_0_SCRATCH2_RANGE                    31:0
#define APBDEV_PMC_SCRATCH2_0_SCRATCH2_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH2_0_SCRATCH2_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH2_0_SCRATCH2_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH2_0_SCRATCH2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH2_0_SCRATCH2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH3_0  // Scratch register 
#define APBDEV_PMC_SCRATCH3_0                   _MK_ADDR_CONST(0x5c)
#define APBDEV_PMC_SCRATCH3_0_SECURE                    0x0
#define APBDEV_PMC_SCRATCH3_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH3_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH3_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH3_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH3_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH3_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH3_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH3_0_SCRATCH3_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH3_0_SCRATCH3_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH3_0_SCRATCH3_SHIFT)
#define APBDEV_PMC_SCRATCH3_0_SCRATCH3_RANGE                    31:0
#define APBDEV_PMC_SCRATCH3_0_SCRATCH3_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH3_0_SCRATCH3_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH3_0_SCRATCH3_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH3_0_SCRATCH3_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH3_0_SCRATCH3_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH4_0  // Scratch register 
#define APBDEV_PMC_SCRATCH4_0                   _MK_ADDR_CONST(0x60)
#define APBDEV_PMC_SCRATCH4_0_SECURE                    0x0
#define APBDEV_PMC_SCRATCH4_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH4_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH4_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH4_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH4_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH4_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH4_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH4_0_SCRATCH4_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH4_0_SCRATCH4_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH4_0_SCRATCH4_SHIFT)
#define APBDEV_PMC_SCRATCH4_0_SCRATCH4_RANGE                    31:0
#define APBDEV_PMC_SCRATCH4_0_SCRATCH4_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH4_0_SCRATCH4_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH4_0_SCRATCH4_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH4_0_SCRATCH4_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH4_0_SCRATCH4_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH5_0  // Scratch register 
#define APBDEV_PMC_SCRATCH5_0                   _MK_ADDR_CONST(0x64)
#define APBDEV_PMC_SCRATCH5_0_SECURE                    0x0
#define APBDEV_PMC_SCRATCH5_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH5_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH5_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH5_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH5_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH5_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH5_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH5_0_SCRATCH5_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH5_0_SCRATCH5_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH5_0_SCRATCH5_SHIFT)
#define APBDEV_PMC_SCRATCH5_0_SCRATCH5_RANGE                    31:0
#define APBDEV_PMC_SCRATCH5_0_SCRATCH5_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH5_0_SCRATCH5_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH5_0_SCRATCH5_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH5_0_SCRATCH5_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH5_0_SCRATCH5_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH6_0  // Scratch register 
#define APBDEV_PMC_SCRATCH6_0                   _MK_ADDR_CONST(0x68)
#define APBDEV_PMC_SCRATCH6_0_SECURE                    0x0
#define APBDEV_PMC_SCRATCH6_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH6_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH6_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH6_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH6_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH6_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH6_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH6_0_SCRATCH6_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH6_0_SCRATCH6_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH6_0_SCRATCH6_SHIFT)
#define APBDEV_PMC_SCRATCH6_0_SCRATCH6_RANGE                    31:0
#define APBDEV_PMC_SCRATCH6_0_SCRATCH6_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH6_0_SCRATCH6_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH6_0_SCRATCH6_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH6_0_SCRATCH6_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH6_0_SCRATCH6_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH7_0  // Scratch register 
#define APBDEV_PMC_SCRATCH7_0                   _MK_ADDR_CONST(0x6c)
#define APBDEV_PMC_SCRATCH7_0_SECURE                    0x0
#define APBDEV_PMC_SCRATCH7_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH7_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH7_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH7_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH7_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH7_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH7_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH7_0_SCRATCH7_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH7_0_SCRATCH7_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH7_0_SCRATCH7_SHIFT)
#define APBDEV_PMC_SCRATCH7_0_SCRATCH7_RANGE                    31:0
#define APBDEV_PMC_SCRATCH7_0_SCRATCH7_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH7_0_SCRATCH7_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH7_0_SCRATCH7_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH7_0_SCRATCH7_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH7_0_SCRATCH7_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH8_0  // Scratch register 
#define APBDEV_PMC_SCRATCH8_0                   _MK_ADDR_CONST(0x70)
#define APBDEV_PMC_SCRATCH8_0_SECURE                    0x0
#define APBDEV_PMC_SCRATCH8_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH8_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH8_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH8_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH8_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH8_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH8_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH8_0_SCRATCH8_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH8_0_SCRATCH8_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH8_0_SCRATCH8_SHIFT)
#define APBDEV_PMC_SCRATCH8_0_SCRATCH8_RANGE                    31:0
#define APBDEV_PMC_SCRATCH8_0_SCRATCH8_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH8_0_SCRATCH8_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH8_0_SCRATCH8_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH8_0_SCRATCH8_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH8_0_SCRATCH8_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH9_0  // Scratch register 
#define APBDEV_PMC_SCRATCH9_0                   _MK_ADDR_CONST(0x74)
#define APBDEV_PMC_SCRATCH9_0_SECURE                    0x0
#define APBDEV_PMC_SCRATCH9_0_WORD_COUNT                        0x1
#define APBDEV_PMC_SCRATCH9_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH9_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH9_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH9_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH9_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH9_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH9_0_SCRATCH9_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH9_0_SCRATCH9_FIELD                    (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH9_0_SCRATCH9_SHIFT)
#define APBDEV_PMC_SCRATCH9_0_SCRATCH9_RANGE                    31:0
#define APBDEV_PMC_SCRATCH9_0_SCRATCH9_WOFFSET                  0x0
#define APBDEV_PMC_SCRATCH9_0_SCRATCH9_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH9_0_SCRATCH9_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH9_0_SCRATCH9_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH9_0_SCRATCH9_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH10_0  // Scratch register 
#define APBDEV_PMC_SCRATCH10_0                  _MK_ADDR_CONST(0x78)
#define APBDEV_PMC_SCRATCH10_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH10_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH10_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH10_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH10_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH10_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH10_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH10_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH10_0_SCRATCH10_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH10_0_SCRATCH10_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH10_0_SCRATCH10_SHIFT)
#define APBDEV_PMC_SCRATCH10_0_SCRATCH10_RANGE                  31:0
#define APBDEV_PMC_SCRATCH10_0_SCRATCH10_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH10_0_SCRATCH10_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH10_0_SCRATCH10_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH10_0_SCRATCH10_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH10_0_SCRATCH10_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH11_0  // Scratch register 
#define APBDEV_PMC_SCRATCH11_0                  _MK_ADDR_CONST(0x7c)
#define APBDEV_PMC_SCRATCH11_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH11_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH11_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH11_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH11_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH11_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH11_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH11_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH11_0_SCRATCH11_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH11_0_SCRATCH11_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH11_0_SCRATCH11_SHIFT)
#define APBDEV_PMC_SCRATCH11_0_SCRATCH11_RANGE                  31:0
#define APBDEV_PMC_SCRATCH11_0_SCRATCH11_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH11_0_SCRATCH11_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH11_0_SCRATCH11_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH11_0_SCRATCH11_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH11_0_SCRATCH11_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH12_0  // Scratch register 
#define APBDEV_PMC_SCRATCH12_0                  _MK_ADDR_CONST(0x80)
#define APBDEV_PMC_SCRATCH12_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH12_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH12_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH12_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH12_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH12_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH12_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH12_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH12_0_SCRATCH12_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH12_0_SCRATCH12_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH12_0_SCRATCH12_SHIFT)
#define APBDEV_PMC_SCRATCH12_0_SCRATCH12_RANGE                  31:0
#define APBDEV_PMC_SCRATCH12_0_SCRATCH12_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH12_0_SCRATCH12_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH12_0_SCRATCH12_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH12_0_SCRATCH12_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH12_0_SCRATCH12_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH13_0  // Scratch register 
#define APBDEV_PMC_SCRATCH13_0                  _MK_ADDR_CONST(0x84)
#define APBDEV_PMC_SCRATCH13_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH13_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH13_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH13_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH13_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH13_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH13_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH13_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH13_0_SCRATCH13_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH13_0_SCRATCH13_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH13_0_SCRATCH13_SHIFT)
#define APBDEV_PMC_SCRATCH13_0_SCRATCH13_RANGE                  31:0
#define APBDEV_PMC_SCRATCH13_0_SCRATCH13_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH13_0_SCRATCH13_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH13_0_SCRATCH13_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH13_0_SCRATCH13_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH13_0_SCRATCH13_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH14_0  // Scratch register 
#define APBDEV_PMC_SCRATCH14_0                  _MK_ADDR_CONST(0x88)
#define APBDEV_PMC_SCRATCH14_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH14_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH14_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH14_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH14_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH14_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH14_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH14_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH14_0_SCRATCH14_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH14_0_SCRATCH14_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH14_0_SCRATCH14_SHIFT)
#define APBDEV_PMC_SCRATCH14_0_SCRATCH14_RANGE                  31:0
#define APBDEV_PMC_SCRATCH14_0_SCRATCH14_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH14_0_SCRATCH14_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH14_0_SCRATCH14_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH14_0_SCRATCH14_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH14_0_SCRATCH14_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH15_0  // Scratch register 
#define APBDEV_PMC_SCRATCH15_0                  _MK_ADDR_CONST(0x8c)
#define APBDEV_PMC_SCRATCH15_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH15_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH15_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH15_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH15_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH15_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH15_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH15_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH15_0_SCRATCH15_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH15_0_SCRATCH15_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH15_0_SCRATCH15_SHIFT)
#define APBDEV_PMC_SCRATCH15_0_SCRATCH15_RANGE                  31:0
#define APBDEV_PMC_SCRATCH15_0_SCRATCH15_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH15_0_SCRATCH15_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH15_0_SCRATCH15_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH15_0_SCRATCH15_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH15_0_SCRATCH15_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH16_0  // Scratch register 
#define APBDEV_PMC_SCRATCH16_0                  _MK_ADDR_CONST(0x90)
#define APBDEV_PMC_SCRATCH16_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH16_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH16_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH16_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH16_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH16_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH16_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH16_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH16_0_SCRATCH16_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH16_0_SCRATCH16_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH16_0_SCRATCH16_SHIFT)
#define APBDEV_PMC_SCRATCH16_0_SCRATCH16_RANGE                  31:0
#define APBDEV_PMC_SCRATCH16_0_SCRATCH16_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH16_0_SCRATCH16_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH16_0_SCRATCH16_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH16_0_SCRATCH16_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH16_0_SCRATCH16_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH17_0  // Scratch register 
#define APBDEV_PMC_SCRATCH17_0                  _MK_ADDR_CONST(0x94)
#define APBDEV_PMC_SCRATCH17_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH17_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH17_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH17_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH17_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH17_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH17_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH17_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH17_0_SCRATCH17_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH17_0_SCRATCH17_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH17_0_SCRATCH17_SHIFT)
#define APBDEV_PMC_SCRATCH17_0_SCRATCH17_RANGE                  31:0
#define APBDEV_PMC_SCRATCH17_0_SCRATCH17_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH17_0_SCRATCH17_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH17_0_SCRATCH17_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH17_0_SCRATCH17_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH17_0_SCRATCH17_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH18_0  // Scratch register 
#define APBDEV_PMC_SCRATCH18_0                  _MK_ADDR_CONST(0x98)
#define APBDEV_PMC_SCRATCH18_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH18_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH18_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH18_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH18_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH18_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH18_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH18_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH18_0_SCRATCH18_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH18_0_SCRATCH18_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH18_0_SCRATCH18_SHIFT)
#define APBDEV_PMC_SCRATCH18_0_SCRATCH18_RANGE                  31:0
#define APBDEV_PMC_SCRATCH18_0_SCRATCH18_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH18_0_SCRATCH18_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH18_0_SCRATCH18_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH18_0_SCRATCH18_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH18_0_SCRATCH18_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH19_0  // Scratch register 
#define APBDEV_PMC_SCRATCH19_0                  _MK_ADDR_CONST(0x9c)
#define APBDEV_PMC_SCRATCH19_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH19_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH19_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH19_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH19_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH19_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH19_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH19_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH19_0_SCRATCH19_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH19_0_SCRATCH19_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH19_0_SCRATCH19_SHIFT)
#define APBDEV_PMC_SCRATCH19_0_SCRATCH19_RANGE                  31:0
#define APBDEV_PMC_SCRATCH19_0_SCRATCH19_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH19_0_SCRATCH19_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH19_0_SCRATCH19_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH19_0_SCRATCH19_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH19_0_SCRATCH19_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH20_0  // Scratch register 
#define APBDEV_PMC_SCRATCH20_0                  _MK_ADDR_CONST(0xa0)
#define APBDEV_PMC_SCRATCH20_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH20_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH20_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH20_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH20_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH20_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH20_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH20_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH20_0_SCRATCH20_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH20_0_SCRATCH20_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH20_0_SCRATCH20_SHIFT)
#define APBDEV_PMC_SCRATCH20_0_SCRATCH20_RANGE                  31:0
#define APBDEV_PMC_SCRATCH20_0_SCRATCH20_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH20_0_SCRATCH20_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH20_0_SCRATCH20_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH20_0_SCRATCH20_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH20_0_SCRATCH20_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH21_0  // Scratch register 
#define APBDEV_PMC_SCRATCH21_0                  _MK_ADDR_CONST(0xa4)
#define APBDEV_PMC_SCRATCH21_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH21_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH21_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH21_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH21_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH21_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH21_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH21_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH21_0_SCRATCH21_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH21_0_SCRATCH21_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH21_0_SCRATCH21_SHIFT)
#define APBDEV_PMC_SCRATCH21_0_SCRATCH21_RANGE                  31:0
#define APBDEV_PMC_SCRATCH21_0_SCRATCH21_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH21_0_SCRATCH21_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH21_0_SCRATCH21_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH21_0_SCRATCH21_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH21_0_SCRATCH21_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH22_0  // Scratch register 
#define APBDEV_PMC_SCRATCH22_0                  _MK_ADDR_CONST(0xa8)
#define APBDEV_PMC_SCRATCH22_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH22_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH22_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH22_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH22_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH22_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH22_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH22_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH22_0_SCRATCH22_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH22_0_SCRATCH22_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH22_0_SCRATCH22_SHIFT)
#define APBDEV_PMC_SCRATCH22_0_SCRATCH22_RANGE                  31:0
#define APBDEV_PMC_SCRATCH22_0_SCRATCH22_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH22_0_SCRATCH22_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH22_0_SCRATCH22_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH22_0_SCRATCH22_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH22_0_SCRATCH22_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH23_0  // Scratch register 
#define APBDEV_PMC_SCRATCH23_0                  _MK_ADDR_CONST(0xac)
#define APBDEV_PMC_SCRATCH23_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH23_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH23_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH23_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH23_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH23_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH23_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH23_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH23_0_SCRATCH23_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH23_0_SCRATCH23_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH23_0_SCRATCH23_SHIFT)
#define APBDEV_PMC_SCRATCH23_0_SCRATCH23_RANGE                  31:0
#define APBDEV_PMC_SCRATCH23_0_SCRATCH23_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH23_0_SCRATCH23_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH23_0_SCRATCH23_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH23_0_SCRATCH23_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH23_0_SCRATCH23_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SECURE_SCRATCH0_0  // Secure scratch register
#define APBDEV_PMC_SECURE_SCRATCH0_0                    _MK_ADDR_CONST(0xb0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE                     0x0
#define APBDEV_PMC_SECURE_SCRATCH0_0_WORD_COUNT                         0x1
#define APBDEV_PMC_SECURE_SCRATCH0_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH0_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_FIELD                      (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_SHIFT)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_RANGE                      31:0
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_WOFFSET                    0x0
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH0_0_SECURE_SCRATCH0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SECURE_SCRATCH1_0  // Secure scratch register
#define APBDEV_PMC_SECURE_SCRATCH1_0                    _MK_ADDR_CONST(0xb4)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE                     0x0
#define APBDEV_PMC_SECURE_SCRATCH1_0_WORD_COUNT                         0x1
#define APBDEV_PMC_SECURE_SCRATCH1_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH1_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH1_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH1_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_FIELD                      (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_SHIFT)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_RANGE                      31:0
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_WOFFSET                    0x0
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH1_0_SECURE_SCRATCH1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SECURE_SCRATCH2_0  // Secure scratch register
#define APBDEV_PMC_SECURE_SCRATCH2_0                    _MK_ADDR_CONST(0xb8)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE                     0x0
#define APBDEV_PMC_SECURE_SCRATCH2_0_WORD_COUNT                         0x1
#define APBDEV_PMC_SECURE_SCRATCH2_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH2_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH2_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH2_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_FIELD                      (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_SHIFT)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_RANGE                      31:0
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_WOFFSET                    0x0
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH2_0_SECURE_SCRATCH2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SECURE_SCRATCH3_0  // Secure scratch register
#define APBDEV_PMC_SECURE_SCRATCH3_0                    _MK_ADDR_CONST(0xbc)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE                     0x0
#define APBDEV_PMC_SECURE_SCRATCH3_0_WORD_COUNT                         0x1
#define APBDEV_PMC_SECURE_SCRATCH3_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH3_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH3_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH3_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_FIELD                      (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_SHIFT)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_RANGE                      31:0
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_WOFFSET                    0x0
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH3_0_SECURE_SCRATCH3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SECURE_SCRATCH4_0  // Secure scratch register
#define APBDEV_PMC_SECURE_SCRATCH4_0                    _MK_ADDR_CONST(0xc0)
#define APBDEV_PMC_SECURE_SCRATCH4_0_SECURE                     0x0
#define APBDEV_PMC_SECURE_SCRATCH4_0_WORD_COUNT                         0x1
#define APBDEV_PMC_SECURE_SCRATCH4_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH4_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH4_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH4_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH4_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH4_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH4_0_SECURE_SCRATCH4_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SECURE_SCRATCH4_0_SECURE_SCRATCH4_FIELD                      (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SECURE_SCRATCH4_0_SECURE_SCRATCH4_SHIFT)
#define APBDEV_PMC_SECURE_SCRATCH4_0_SECURE_SCRATCH4_RANGE                      31:0
#define APBDEV_PMC_SECURE_SCRATCH4_0_SECURE_SCRATCH4_WOFFSET                    0x0
#define APBDEV_PMC_SECURE_SCRATCH4_0_SECURE_SCRATCH4_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH4_0_SECURE_SCRATCH4_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH4_0_SECURE_SCRATCH4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH4_0_SECURE_SCRATCH4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SECURE_SCRATCH5_0  // Secure scratch register
#define APBDEV_PMC_SECURE_SCRATCH5_0                    _MK_ADDR_CONST(0xc4)
#define APBDEV_PMC_SECURE_SCRATCH5_0_SECURE                     0x0
#define APBDEV_PMC_SECURE_SCRATCH5_0_WORD_COUNT                         0x1
#define APBDEV_PMC_SECURE_SCRATCH5_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH5_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH5_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH5_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH5_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH5_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SECURE_SCRATCH5_0_SECURE_SCRATCH5_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SECURE_SCRATCH5_0_SECURE_SCRATCH5_FIELD                      (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SECURE_SCRATCH5_0_SECURE_SCRATCH5_SHIFT)
#define APBDEV_PMC_SECURE_SCRATCH5_0_SECURE_SCRATCH5_RANGE                      31:0
#define APBDEV_PMC_SECURE_SCRATCH5_0_SECURE_SCRATCH5_WOFFSET                    0x0
#define APBDEV_PMC_SECURE_SCRATCH5_0_SECURE_SCRATCH5_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH5_0_SECURE_SCRATCH5_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH5_0_SECURE_SCRATCH5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SECURE_SCRATCH5_0_SECURE_SCRATCH5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_CPUPWRGOOD_TIMER_0  
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0                   _MK_ADDR_CONST(0xc8)
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0_SECURE                    0x0
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0_WORD_COUNT                        0x1
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0_RESET_VAL                         _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
// timer data
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0_DATA_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0_DATA_FIELD                        (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_CPUPWRGOOD_TIMER_0_DATA_SHIFT)
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0_DATA_RANGE                        31:0
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0_DATA_WOFFSET                      0x0
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0_DATA_DEFAULT                      _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0_DATA_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0_DATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CPUPWRGOOD_TIMER_0_DATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_CPUPWROFF_TIMER_0  
#define APBDEV_PMC_CPUPWROFF_TIMER_0                    _MK_ADDR_CONST(0xcc)
#define APBDEV_PMC_CPUPWROFF_TIMER_0_SECURE                     0x0
#define APBDEV_PMC_CPUPWROFF_TIMER_0_WORD_COUNT                         0x1
#define APBDEV_PMC_CPUPWROFF_TIMER_0_RESET_VAL                  _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_CPUPWROFF_TIMER_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_CPUPWROFF_TIMER_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CPUPWROFF_TIMER_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CPUPWROFF_TIMER_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_CPUPWROFF_TIMER_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
// timer data
#define APBDEV_PMC_CPUPWROFF_TIMER_0_DATA_SHIFT                 _MK_SHIFT_CONST(0)
#define APBDEV_PMC_CPUPWROFF_TIMER_0_DATA_FIELD                 (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_CPUPWROFF_TIMER_0_DATA_SHIFT)
#define APBDEV_PMC_CPUPWROFF_TIMER_0_DATA_RANGE                 31:0
#define APBDEV_PMC_CPUPWROFF_TIMER_0_DATA_WOFFSET                       0x0
#define APBDEV_PMC_CPUPWROFF_TIMER_0_DATA_DEFAULT                       _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_CPUPWROFF_TIMER_0_DATA_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_CPUPWROFF_TIMER_0_DATA_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CPUPWROFF_TIMER_0_DATA_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_PG_MASK_0  
#define APBDEV_PMC_PG_MASK_0                    _MK_ADDR_CONST(0xd0)
#define APBDEV_PMC_PG_MASK_0_SECURE                     0x0
#define APBDEV_PMC_PG_MASK_0_WORD_COUNT                         0x1
#define APBDEV_PMC_PG_MASK_0_RESET_VAL                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_PG_MASK_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_PG_MASK_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PG_MASK_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PG_MASK_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_PG_MASK_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
// Mask TD rail
#define APBDEV_PMC_PG_MASK_0_TD_SHIFT                   _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PG_MASK_0_TD_FIELD                   (_MK_MASK_CONST(0xff) << APBDEV_PMC_PG_MASK_0_TD_SHIFT)
#define APBDEV_PMC_PG_MASK_0_TD_RANGE                   7:0
#define APBDEV_PMC_PG_MASK_0_TD_WOFFSET                 0x0
#define APBDEV_PMC_PG_MASK_0_TD_DEFAULT                 _MK_MASK_CONST(0xff)
#define APBDEV_PMC_PG_MASK_0_TD_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define APBDEV_PMC_PG_MASK_0_TD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PG_MASK_0_TD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Mask VE rail
#define APBDEV_PMC_PG_MASK_0_VE_SHIFT                   _MK_SHIFT_CONST(8)
#define APBDEV_PMC_PG_MASK_0_VE_FIELD                   (_MK_MASK_CONST(0xff) << APBDEV_PMC_PG_MASK_0_VE_SHIFT)
#define APBDEV_PMC_PG_MASK_0_VE_RANGE                   15:8
#define APBDEV_PMC_PG_MASK_0_VE_WOFFSET                 0x0
#define APBDEV_PMC_PG_MASK_0_VE_DEFAULT                 _MK_MASK_CONST(0xff)
#define APBDEV_PMC_PG_MASK_0_VE_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define APBDEV_PMC_PG_MASK_0_VE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PG_MASK_0_VE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Mask VDE rail
#define APBDEV_PMC_PG_MASK_0_VD_SHIFT                   _MK_SHIFT_CONST(16)
#define APBDEV_PMC_PG_MASK_0_VD_FIELD                   (_MK_MASK_CONST(0xff) << APBDEV_PMC_PG_MASK_0_VD_SHIFT)
#define APBDEV_PMC_PG_MASK_0_VD_RANGE                   23:16
#define APBDEV_PMC_PG_MASK_0_VD_WOFFSET                 0x0
#define APBDEV_PMC_PG_MASK_0_VD_DEFAULT                 _MK_MASK_CONST(0xff)
#define APBDEV_PMC_PG_MASK_0_VD_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define APBDEV_PMC_PG_MASK_0_VD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PG_MASK_0_VD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Mask PCX rail
#define APBDEV_PMC_PG_MASK_0_PX_SHIFT                   _MK_SHIFT_CONST(24)
#define APBDEV_PMC_PG_MASK_0_PX_FIELD                   (_MK_MASK_CONST(0xff) << APBDEV_PMC_PG_MASK_0_PX_SHIFT)
#define APBDEV_PMC_PG_MASK_0_PX_RANGE                   31:24
#define APBDEV_PMC_PG_MASK_0_PX_WOFFSET                 0x0
#define APBDEV_PMC_PG_MASK_0_PX_DEFAULT                 _MK_MASK_CONST(0xff)
#define APBDEV_PMC_PG_MASK_0_PX_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define APBDEV_PMC_PG_MASK_0_PX_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PG_MASK_0_PX_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_PG_MASK_1_0  
#define APBDEV_PMC_PG_MASK_1_0                  _MK_ADDR_CONST(0xd4)
#define APBDEV_PMC_PG_MASK_1_0_SECURE                   0x0
#define APBDEV_PMC_PG_MASK_1_0_WORD_COUNT                       0x1
#define APBDEV_PMC_PG_MASK_1_0_RESET_VAL                        _MK_MASK_CONST(0xff01)
#define APBDEV_PMC_PG_MASK_1_0_RESET_MASK                       _MK_MASK_CONST(0xff01)
#define APBDEV_PMC_PG_MASK_1_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PG_MASK_1_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PG_MASK_1_0_READ_MASK                        _MK_MASK_CONST(0xff01)
#define APBDEV_PMC_PG_MASK_1_0_WRITE_MASK                       _MK_MASK_CONST(0xff01)
// MASK L2C rail
#define APBDEV_PMC_PG_MASK_1_0_L2C_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PG_MASK_1_0_L2C_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_PG_MASK_1_0_L2C_SHIFT)
#define APBDEV_PMC_PG_MASK_1_0_L2C_RANGE                        0:0
#define APBDEV_PMC_PG_MASK_1_0_L2C_WOFFSET                      0x0
#define APBDEV_PMC_PG_MASK_1_0_L2C_DEFAULT                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PG_MASK_1_0_L2C_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PG_MASK_1_0_L2C_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PG_MASK_1_0_L2C_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// MASK MPE rail
#define APBDEV_PMC_PG_MASK_1_0_MPE_SHIFT                        _MK_SHIFT_CONST(8)
#define APBDEV_PMC_PG_MASK_1_0_MPE_FIELD                        (_MK_MASK_CONST(0xff) << APBDEV_PMC_PG_MASK_1_0_MPE_SHIFT)
#define APBDEV_PMC_PG_MASK_1_0_MPE_RANGE                        15:8
#define APBDEV_PMC_PG_MASK_1_0_MPE_WOFFSET                      0x0
#define APBDEV_PMC_PG_MASK_1_0_MPE_DEFAULT                      _MK_MASK_CONST(0xff)
#define APBDEV_PMC_PG_MASK_1_0_MPE_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define APBDEV_PMC_PG_MASK_1_0_MPE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PG_MASK_1_0_MPE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_AUTO_WAKE_LVL_0  
#define APBDEV_PMC_AUTO_WAKE_LVL_0                      _MK_ADDR_CONST(0xd8)
#define APBDEV_PMC_AUTO_WAKE_LVL_0_SECURE                       0x0
#define APBDEV_PMC_AUTO_WAKE_LVL_0_WORD_COUNT                   0x1
#define APBDEV_PMC_AUTO_WAKE_LVL_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_AUTO_WAKE_LVL_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_AUTO_WAKE_LVL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_AUTO_WAKE_LVL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_AUTO_WAKE_LVL_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_AUTO_WAKE_LVL_0_WRITE_MASK                   _MK_MASK_CONST(0x1)
//Causes PMC to sample the wake pads
#define APBDEV_PMC_AUTO_WAKE_LVL_0_SMPL_SHIFT                   _MK_SHIFT_CONST(0)
#define APBDEV_PMC_AUTO_WAKE_LVL_0_SMPL_FIELD                   (_MK_MASK_CONST(0x1) << APBDEV_PMC_AUTO_WAKE_LVL_0_SMPL_SHIFT)
#define APBDEV_PMC_AUTO_WAKE_LVL_0_SMPL_RANGE                   0:0
#define APBDEV_PMC_AUTO_WAKE_LVL_0_SMPL_WOFFSET                 0x0
#define APBDEV_PMC_AUTO_WAKE_LVL_0_SMPL_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_AUTO_WAKE_LVL_0_SMPL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_AUTO_WAKE_LVL_0_SMPL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_AUTO_WAKE_LVL_0_SMPL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_AUTO_WAKE_LVL_0_SMPL_DISABLE                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_AUTO_WAKE_LVL_0_SMPL_ENABLE                  _MK_ENUM_CONST(1)


// Register APBDEV_PMC_AUTO_WAKE_LVL_MASK_0  
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0                 _MK_ADDR_CONST(0xdc)
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_SECURE                  0x0
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_WORD_COUNT                      0x1
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_VALUE_SHIFT                     _MK_SHIFT_CONST(0)
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_VALUE_FIELD                     (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_VALUE_SHIFT)
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_VALUE_RANGE                     31:0
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_VALUE_WOFFSET                   0x0
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_VALUE_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_VALUE_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_VALUE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_AUTO_WAKE_LVL_MASK_0_VALUE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_WAKE_DELAY_0  
#define APBDEV_PMC_WAKE_DELAY_0                 _MK_ADDR_CONST(0xe0)
#define APBDEV_PMC_WAKE_DELAY_0_SECURE                  0x0
#define APBDEV_PMC_WAKE_DELAY_0_WORD_COUNT                      0x1
#define APBDEV_PMC_WAKE_DELAY_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_DELAY_0_RESET_MASK                      _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_WAKE_DELAY_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_DELAY_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_DELAY_0_READ_MASK                       _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_WAKE_DELAY_0_WRITE_MASK                      _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_WAKE_DELAY_0_VALUE_SHIFT                     _MK_SHIFT_CONST(0)
#define APBDEV_PMC_WAKE_DELAY_0_VALUE_FIELD                     (_MK_MASK_CONST(0xffff) << APBDEV_PMC_WAKE_DELAY_0_VALUE_SHIFT)
#define APBDEV_PMC_WAKE_DELAY_0_VALUE_RANGE                     15:0
#define APBDEV_PMC_WAKE_DELAY_0_VALUE_WOFFSET                   0x0
#define APBDEV_PMC_WAKE_DELAY_0_VALUE_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_DELAY_0_VALUE_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_WAKE_DELAY_0_VALUE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_WAKE_DELAY_0_VALUE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_PWR_DET_VAL_0  
#define APBDEV_PMC_PWR_DET_VAL_0                        _MK_ADDR_CONST(0xe4)
#define APBDEV_PMC_PWR_DET_VAL_0_SECURE                         0x0
#define APBDEV_PMC_PWR_DET_VAL_0_WORD_COUNT                     0x1
#define APBDEV_PMC_PWR_DET_VAL_0_RESET_VAL                      _MK_MASK_CONST(0x1ff)
#define APBDEV_PMC_PWR_DET_VAL_0_RESET_MASK                     _MK_MASK_CONST(0x1ff)
#define APBDEV_PMC_PWR_DET_VAL_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_READ_MASK                      _MK_MASK_CONST(0x1ff)
#define APBDEV_PMC_PWR_DET_VAL_0_WRITE_MASK                     _MK_MASK_CONST(0x1ff)
//rail ao IOs   
#define APBDEV_PMC_PWR_DET_VAL_0_SYS_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PWR_DET_VAL_0_SYS_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_VAL_0_SYS_SHIFT)
#define APBDEV_PMC_PWR_DET_VAL_0_SYS_RANGE                      0:0
#define APBDEV_PMC_PWR_DET_VAL_0_SYS_WOFFSET                    0x0
#define APBDEV_PMC_PWR_DET_VAL_0_SYS_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_SYS_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_SYS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_SYS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_SYS_ENABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_VAL_0_SYS_DISABLE                    _MK_ENUM_CONST(1)

//rail at3 IOs 
#define APBDEV_PMC_PWR_DET_VAL_0_NAND_SHIFT                     _MK_SHIFT_CONST(1)
#define APBDEV_PMC_PWR_DET_VAL_0_NAND_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_VAL_0_NAND_SHIFT)
#define APBDEV_PMC_PWR_DET_VAL_0_NAND_RANGE                     1:1
#define APBDEV_PMC_PWR_DET_VAL_0_NAND_WOFFSET                   0x0
#define APBDEV_PMC_PWR_DET_VAL_0_NAND_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_NAND_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_NAND_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_NAND_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_NAND_ENABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_VAL_0_NAND_DISABLE                   _MK_ENUM_CONST(1)

//rail dbg IOs   
#define APBDEV_PMC_PWR_DET_VAL_0_UART_SHIFT                     _MK_SHIFT_CONST(2)
#define APBDEV_PMC_PWR_DET_VAL_0_UART_FIELD                     (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_VAL_0_UART_SHIFT)
#define APBDEV_PMC_PWR_DET_VAL_0_UART_RANGE                     2:2
#define APBDEV_PMC_PWR_DET_VAL_0_UART_WOFFSET                   0x0
#define APBDEV_PMC_PWR_DET_VAL_0_UART_DEFAULT                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_UART_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_UART_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_UART_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_UART_ENABLE                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_VAL_0_UART_DISABLE                   _MK_ENUM_CONST(1)

//rail dlcd IOs   
#define APBDEV_PMC_PWR_DET_VAL_0_BB_SHIFT                       _MK_SHIFT_CONST(3)
#define APBDEV_PMC_PWR_DET_VAL_0_BB_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_VAL_0_BB_SHIFT)
#define APBDEV_PMC_PWR_DET_VAL_0_BB_RANGE                       3:3
#define APBDEV_PMC_PWR_DET_VAL_0_BB_WOFFSET                     0x0
#define APBDEV_PMC_PWR_DET_VAL_0_BB_DEFAULT                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_BB_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_BB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_BB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_BB_ENABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_VAL_0_BB_DISABLE                     _MK_ENUM_CONST(1)

//rail dvi IOs   
#define APBDEV_PMC_PWR_DET_VAL_0_VI_SHIFT                       _MK_SHIFT_CONST(4)
#define APBDEV_PMC_PWR_DET_VAL_0_VI_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_VAL_0_VI_SHIFT)
#define APBDEV_PMC_PWR_DET_VAL_0_VI_RANGE                       4:4
#define APBDEV_PMC_PWR_DET_VAL_0_VI_WOFFSET                     0x0
#define APBDEV_PMC_PWR_DET_VAL_0_VI_DEFAULT                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_VI_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_VI_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_VI_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_VI_ENABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_VAL_0_VI_DISABLE                     _MK_ENUM_CONST(1)

//rail i2s IOs   
#define APBDEV_PMC_PWR_DET_VAL_0_AUDIO_SHIFT                    _MK_SHIFT_CONST(5)
#define APBDEV_PMC_PWR_DET_VAL_0_AUDIO_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_VAL_0_AUDIO_SHIFT)
#define APBDEV_PMC_PWR_DET_VAL_0_AUDIO_RANGE                    5:5
#define APBDEV_PMC_PWR_DET_VAL_0_AUDIO_WOFFSET                  0x0
#define APBDEV_PMC_PWR_DET_VAL_0_AUDIO_DEFAULT                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_AUDIO_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_AUDIO_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_AUDIO_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_AUDIO_ENABLE                   _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_VAL_0_AUDIO_DISABLE                  _MK_ENUM_CONST(1)

//rail lcd IOs   
#define APBDEV_PMC_PWR_DET_VAL_0_LCD_SHIFT                      _MK_SHIFT_CONST(6)
#define APBDEV_PMC_PWR_DET_VAL_0_LCD_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_VAL_0_LCD_SHIFT)
#define APBDEV_PMC_PWR_DET_VAL_0_LCD_RANGE                      6:6
#define APBDEV_PMC_PWR_DET_VAL_0_LCD_WOFFSET                    0x0
#define APBDEV_PMC_PWR_DET_VAL_0_LCD_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_LCD_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_LCD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_LCD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_LCD_ENABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_VAL_0_LCD_DISABLE                    _MK_ENUM_CONST(1)

//rail mem IOs   
#define APBDEV_PMC_PWR_DET_VAL_0_MEM_SHIFT                      _MK_SHIFT_CONST(7)
#define APBDEV_PMC_PWR_DET_VAL_0_MEM_FIELD                      (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_VAL_0_MEM_SHIFT)
#define APBDEV_PMC_PWR_DET_VAL_0_MEM_RANGE                      7:7
#define APBDEV_PMC_PWR_DET_VAL_0_MEM_WOFFSET                    0x0
#define APBDEV_PMC_PWR_DET_VAL_0_MEM_DEFAULT                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_MEM_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_MEM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_MEM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_MEM_ENABLE                     _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_VAL_0_MEM_DISABLE                    _MK_ENUM_CONST(1)

//rail sd IOs   
#define APBDEV_PMC_PWR_DET_VAL_0_SD_SHIFT                       _MK_SHIFT_CONST(8)
#define APBDEV_PMC_PWR_DET_VAL_0_SD_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_PWR_DET_VAL_0_SD_SHIFT)
#define APBDEV_PMC_PWR_DET_VAL_0_SD_RANGE                       8:8
#define APBDEV_PMC_PWR_DET_VAL_0_SD_WOFFSET                     0x0
#define APBDEV_PMC_PWR_DET_VAL_0_SD_DEFAULT                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_SD_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PWR_DET_VAL_0_SD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_SD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PWR_DET_VAL_0_SD_ENABLE                      _MK_ENUM_CONST(0)
#define APBDEV_PMC_PWR_DET_VAL_0_SD_DISABLE                     _MK_ENUM_CONST(1)


// Register APBDEV_PMC_DDR_PWR_0  
#define APBDEV_PMC_DDR_PWR_0                    _MK_ADDR_CONST(0xe8)
#define APBDEV_PMC_DDR_PWR_0_SECURE                     0x0
#define APBDEV_PMC_DDR_PWR_0_WORD_COUNT                         0x1
#define APBDEV_PMC_DDR_PWR_0_RESET_VAL                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DDR_PWR_0_RESET_MASK                         _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DDR_PWR_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DDR_PWR_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DDR_PWR_0_READ_MASK                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DDR_PWR_0_WRITE_MASK                         _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DDR_PWR_0_VAL_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_DDR_PWR_0_VAL_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_DDR_PWR_0_VAL_SHIFT)
#define APBDEV_PMC_DDR_PWR_0_VAL_RANGE                  0:0
#define APBDEV_PMC_DDR_PWR_0_VAL_WOFFSET                        0x0
#define APBDEV_PMC_DDR_PWR_0_VAL_DEFAULT                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DDR_PWR_0_VAL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_DDR_PWR_0_VAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DDR_PWR_0_VAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_DDR_PWR_0_VAL_E_12V                  _MK_ENUM_CONST(0)
#define APBDEV_PMC_DDR_PWR_0_VAL_E_18V                  _MK_ENUM_CONST(1)


// Register APBDEV_PMC_USB_DEBOUNCE_DEL_0  
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0                   _MK_ADDR_CONST(0xec)
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0_SECURE                    0x0
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0_WORD_COUNT                        0x1
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0_RESET_MASK                        _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0_READ_MASK                         _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0_WRITE_MASK                        _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0_VAL_SHIFT                 _MK_SHIFT_CONST(0)
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0_VAL_FIELD                 (_MK_MASK_CONST(0xffff) << APBDEV_PMC_USB_DEBOUNCE_DEL_0_VAL_SHIFT)
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0_VAL_RANGE                 15:0
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0_VAL_WOFFSET                       0x0
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0_VAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0_VAL_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0_VAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_USB_DEBOUNCE_DEL_0_VAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_USB_AO_0  
#define APBDEV_PMC_USB_AO_0                     _MK_ADDR_CONST(0xf0)
#define APBDEV_PMC_USB_AO_0_SECURE                      0x0
#define APBDEV_PMC_USB_AO_0_WORD_COUNT                  0x1
#define APBDEV_PMC_USB_AO_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_USB_AO_0_RESET_MASK                  _MK_MASK_CONST(0xf)
#define APBDEV_PMC_USB_AO_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_USB_AO_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_USB_AO_0_READ_MASK                   _MK_MASK_CONST(0xf)
#define APBDEV_PMC_USB_AO_0_WRITE_MASK                  _MK_MASK_CONST(0xf)
#define APBDEV_PMC_USB_AO_0_UB_ID_PD_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_USB_AO_0_UB_ID_PD_FIELD                      (_MK_MASK_CONST(0x3) << APBDEV_PMC_USB_AO_0_UB_ID_PD_SHIFT)
#define APBDEV_PMC_USB_AO_0_UB_ID_PD_RANGE                      1:0
#define APBDEV_PMC_USB_AO_0_UB_ID_PD_WOFFSET                    0x0
#define APBDEV_PMC_USB_AO_0_UB_ID_PD_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_USB_AO_0_UB_ID_PD_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define APBDEV_PMC_USB_AO_0_UB_ID_PD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_USB_AO_0_UB_ID_PD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define APBDEV_PMC_USB_AO_0_VBUS_WAKEUP_PD_SHIFT                        _MK_SHIFT_CONST(2)
#define APBDEV_PMC_USB_AO_0_VBUS_WAKEUP_PD_FIELD                        (_MK_MASK_CONST(0x3) << APBDEV_PMC_USB_AO_0_VBUS_WAKEUP_PD_SHIFT)
#define APBDEV_PMC_USB_AO_0_VBUS_WAKEUP_PD_RANGE                        3:2
#define APBDEV_PMC_USB_AO_0_VBUS_WAKEUP_PD_WOFFSET                      0x0
#define APBDEV_PMC_USB_AO_0_VBUS_WAKEUP_PD_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_USB_AO_0_VBUS_WAKEUP_PD_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define APBDEV_PMC_USB_AO_0_VBUS_WAKEUP_PD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_USB_AO_0_VBUS_WAKEUP_PD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_CRYPTO_OP_0  
#define APBDEV_PMC_CRYPTO_OP_0                  _MK_ADDR_CONST(0xf4)
#define APBDEV_PMC_CRYPTO_OP_0_SECURE                   0x0
#define APBDEV_PMC_CRYPTO_OP_0_WORD_COUNT                       0x1
#define APBDEV_PMC_CRYPTO_OP_0_RESET_VAL                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CRYPTO_OP_0_RESET_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CRYPTO_OP_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CRYPTO_OP_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CRYPTO_OP_0_READ_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CRYPTO_OP_0_WRITE_MASK                       _MK_MASK_CONST(0x1)
//Disabled by default
#define APBDEV_PMC_CRYPTO_OP_0_VAL_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_CRYPTO_OP_0_VAL_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_CRYPTO_OP_0_VAL_SHIFT)
#define APBDEV_PMC_CRYPTO_OP_0_VAL_RANGE                        0:0
#define APBDEV_PMC_CRYPTO_OP_0_VAL_WOFFSET                      0x0
#define APBDEV_PMC_CRYPTO_OP_0_VAL_DEFAULT                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CRYPTO_OP_0_VAL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_CRYPTO_OP_0_VAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CRYPTO_OP_0_VAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_CRYPTO_OP_0_VAL_ENABLE                       _MK_ENUM_CONST(0)
#define APBDEV_PMC_CRYPTO_OP_0_VAL_DISABLE                      _MK_ENUM_CONST(1)


// Register APBDEV_PMC_PLLP_WB0_OVERRIDE_0  
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0                  _MK_ADDR_CONST(0xf8)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_SECURE                   0x0
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_WORD_COUNT                       0x1
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_RESET_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_READ_MASK                        _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_WRITE_MASK                       _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_VAL_SHIFT                        _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_VAL_FIELD                        (_MK_MASK_CONST(0xf) << APBDEV_PMC_PLLP_WB0_OVERRIDE_0_VAL_SHIFT)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_VAL_RANGE                        3:0
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_VAL_WOFFSET                      0x0
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_VAL_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_VAL_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_VAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_VAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// 1 = override CAR PLLP setting, 0 = no override.
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OVERRIDE_ENABLE_SHIFT                    _MK_SHIFT_CONST(0)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OVERRIDE_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OVERRIDE_ENABLE_SHIFT)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OVERRIDE_ENABLE_RANGE                    0:0
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OVERRIDE_ENABLE_WOFFSET                  0x0
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OVERRIDE_ENABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OVERRIDE_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OVERRIDE_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OVERRIDE_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// 1 = enable PLLP, 0 = disable PLLP.
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_PLLP_ENABLE_SHIFT                        _MK_SHIFT_CONST(1)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_PLLP_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << APBDEV_PMC_PLLP_WB0_OVERRIDE_0_PLLP_ENABLE_SHIFT)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_PLLP_ENABLE_RANGE                        1:1
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_PLLP_ENABLE_WOFFSET                      0x0
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_PLLP_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_PLLP_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_PLLP_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_PLLP_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// 00 = 13MHz, 01 = 19.2MHz, 10 = 12MHz, 11 = 26MHz.
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OSC_FREQ_SHIFT                   _MK_SHIFT_CONST(2)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OSC_FREQ_FIELD                   (_MK_MASK_CONST(0x3) << APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OSC_FREQ_SHIFT)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OSC_FREQ_RANGE                   3:2
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OSC_FREQ_WOFFSET                 0x0
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OSC_FREQ_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OSC_FREQ_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OSC_FREQ_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_PLLP_WB0_OVERRIDE_0_OSC_FREQ_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH24_0  // Scratch register 
#define APBDEV_PMC_SCRATCH24_0                  _MK_ADDR_CONST(0xfc)
#define APBDEV_PMC_SCRATCH24_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH24_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH24_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH24_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH24_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH24_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH24_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH24_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH24_0_SCRATCH24_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH24_0_SCRATCH24_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH24_0_SCRATCH24_SHIFT)
#define APBDEV_PMC_SCRATCH24_0_SCRATCH24_RANGE                  31:0
#define APBDEV_PMC_SCRATCH24_0_SCRATCH24_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH24_0_SCRATCH24_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH24_0_SCRATCH24_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH24_0_SCRATCH24_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH24_0_SCRATCH24_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH25_0  // Scratch register 
#define APBDEV_PMC_SCRATCH25_0                  _MK_ADDR_CONST(0x100)
#define APBDEV_PMC_SCRATCH25_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH25_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH25_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH25_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH25_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH25_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH25_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH25_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH25_0_SCRATCH25_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH25_0_SCRATCH25_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH25_0_SCRATCH25_SHIFT)
#define APBDEV_PMC_SCRATCH25_0_SCRATCH25_RANGE                  31:0
#define APBDEV_PMC_SCRATCH25_0_SCRATCH25_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH25_0_SCRATCH25_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH25_0_SCRATCH25_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH25_0_SCRATCH25_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH25_0_SCRATCH25_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH26_0  // Scratch register 
#define APBDEV_PMC_SCRATCH26_0                  _MK_ADDR_CONST(0x104)
#define APBDEV_PMC_SCRATCH26_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH26_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH26_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH26_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH26_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH26_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH26_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH26_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH26_0_SCRATCH26_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH26_0_SCRATCH26_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH26_0_SCRATCH26_SHIFT)
#define APBDEV_PMC_SCRATCH26_0_SCRATCH26_RANGE                  31:0
#define APBDEV_PMC_SCRATCH26_0_SCRATCH26_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH26_0_SCRATCH26_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH26_0_SCRATCH26_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH26_0_SCRATCH26_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH26_0_SCRATCH26_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH27_0  // Scratch register 
#define APBDEV_PMC_SCRATCH27_0                  _MK_ADDR_CONST(0x108)
#define APBDEV_PMC_SCRATCH27_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH27_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH27_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH27_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH27_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH27_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH27_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH27_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH27_0_SCRATCH27_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH27_0_SCRATCH27_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH27_0_SCRATCH27_SHIFT)
#define APBDEV_PMC_SCRATCH27_0_SCRATCH27_RANGE                  31:0
#define APBDEV_PMC_SCRATCH27_0_SCRATCH27_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH27_0_SCRATCH27_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH27_0_SCRATCH27_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH27_0_SCRATCH27_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH27_0_SCRATCH27_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH28_0  // Scratch register 
#define APBDEV_PMC_SCRATCH28_0                  _MK_ADDR_CONST(0x10c)
#define APBDEV_PMC_SCRATCH28_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH28_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH28_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH28_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH28_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH28_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH28_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH28_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH28_0_SCRATCH28_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH28_0_SCRATCH28_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH28_0_SCRATCH28_SHIFT)
#define APBDEV_PMC_SCRATCH28_0_SCRATCH28_RANGE                  31:0
#define APBDEV_PMC_SCRATCH28_0_SCRATCH28_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH28_0_SCRATCH28_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH28_0_SCRATCH28_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH28_0_SCRATCH28_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH28_0_SCRATCH28_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH29_0  // Scratch register 
#define APBDEV_PMC_SCRATCH29_0                  _MK_ADDR_CONST(0x110)
#define APBDEV_PMC_SCRATCH29_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH29_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH29_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH29_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH29_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH29_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH29_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH29_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH29_0_SCRATCH29_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH29_0_SCRATCH29_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH29_0_SCRATCH29_SHIFT)
#define APBDEV_PMC_SCRATCH29_0_SCRATCH29_RANGE                  31:0
#define APBDEV_PMC_SCRATCH29_0_SCRATCH29_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH29_0_SCRATCH29_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH29_0_SCRATCH29_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH29_0_SCRATCH29_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH29_0_SCRATCH29_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH30_0  // Scratch register 
#define APBDEV_PMC_SCRATCH30_0                  _MK_ADDR_CONST(0x114)
#define APBDEV_PMC_SCRATCH30_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH30_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH30_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH30_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH30_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH30_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH30_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH30_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH30_0_SCRATCH30_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH30_0_SCRATCH30_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH30_0_SCRATCH30_SHIFT)
#define APBDEV_PMC_SCRATCH30_0_SCRATCH30_RANGE                  31:0
#define APBDEV_PMC_SCRATCH30_0_SCRATCH30_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH30_0_SCRATCH30_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH30_0_SCRATCH30_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH30_0_SCRATCH30_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH30_0_SCRATCH30_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH31_0  // Scratch register 
#define APBDEV_PMC_SCRATCH31_0                  _MK_ADDR_CONST(0x118)
#define APBDEV_PMC_SCRATCH31_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH31_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH31_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH31_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH31_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH31_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH31_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH31_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH31_0_SCRATCH31_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH31_0_SCRATCH31_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH31_0_SCRATCH31_SHIFT)
#define APBDEV_PMC_SCRATCH31_0_SCRATCH31_RANGE                  31:0
#define APBDEV_PMC_SCRATCH31_0_SCRATCH31_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH31_0_SCRATCH31_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH31_0_SCRATCH31_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH31_0_SCRATCH31_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH31_0_SCRATCH31_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH32_0  // Scratch register 
#define APBDEV_PMC_SCRATCH32_0                  _MK_ADDR_CONST(0x11c)
#define APBDEV_PMC_SCRATCH32_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH32_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH32_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH32_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH32_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH32_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH32_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH32_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH32_0_SCRATCH32_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH32_0_SCRATCH32_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH32_0_SCRATCH32_SHIFT)
#define APBDEV_PMC_SCRATCH32_0_SCRATCH32_RANGE                  31:0
#define APBDEV_PMC_SCRATCH32_0_SCRATCH32_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH32_0_SCRATCH32_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH32_0_SCRATCH32_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH32_0_SCRATCH32_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH32_0_SCRATCH32_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH33_0  // Scratch register 
#define APBDEV_PMC_SCRATCH33_0                  _MK_ADDR_CONST(0x120)
#define APBDEV_PMC_SCRATCH33_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH33_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH33_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH33_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH33_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH33_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH33_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH33_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH33_0_SCRATCH33_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH33_0_SCRATCH33_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH33_0_SCRATCH33_SHIFT)
#define APBDEV_PMC_SCRATCH33_0_SCRATCH33_RANGE                  31:0
#define APBDEV_PMC_SCRATCH33_0_SCRATCH33_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH33_0_SCRATCH33_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH33_0_SCRATCH33_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH33_0_SCRATCH33_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH33_0_SCRATCH33_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH34_0  // Scratch register 
#define APBDEV_PMC_SCRATCH34_0                  _MK_ADDR_CONST(0x124)
#define APBDEV_PMC_SCRATCH34_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH34_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH34_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH34_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH34_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH34_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH34_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH34_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH34_0_SCRATCH34_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH34_0_SCRATCH34_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH34_0_SCRATCH34_SHIFT)
#define APBDEV_PMC_SCRATCH34_0_SCRATCH34_RANGE                  31:0
#define APBDEV_PMC_SCRATCH34_0_SCRATCH34_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH34_0_SCRATCH34_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH34_0_SCRATCH34_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH34_0_SCRATCH34_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH34_0_SCRATCH34_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH35_0  // Scratch register 
#define APBDEV_PMC_SCRATCH35_0                  _MK_ADDR_CONST(0x128)
#define APBDEV_PMC_SCRATCH35_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH35_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH35_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH35_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH35_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH35_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH35_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH35_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH35_0_SCRATCH35_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH35_0_SCRATCH35_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH35_0_SCRATCH35_SHIFT)
#define APBDEV_PMC_SCRATCH35_0_SCRATCH35_RANGE                  31:0
#define APBDEV_PMC_SCRATCH35_0_SCRATCH35_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH35_0_SCRATCH35_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH35_0_SCRATCH35_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH35_0_SCRATCH35_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH35_0_SCRATCH35_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH36_0  // Scratch register 
#define APBDEV_PMC_SCRATCH36_0                  _MK_ADDR_CONST(0x12c)
#define APBDEV_PMC_SCRATCH36_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH36_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH36_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH36_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH36_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH36_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH36_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH36_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH36_0_SCRATCH36_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH36_0_SCRATCH36_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH36_0_SCRATCH36_SHIFT)
#define APBDEV_PMC_SCRATCH36_0_SCRATCH36_RANGE                  31:0
#define APBDEV_PMC_SCRATCH36_0_SCRATCH36_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH36_0_SCRATCH36_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH36_0_SCRATCH36_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH36_0_SCRATCH36_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH36_0_SCRATCH36_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH37_0  // Scratch register 
#define APBDEV_PMC_SCRATCH37_0                  _MK_ADDR_CONST(0x130)
#define APBDEV_PMC_SCRATCH37_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH37_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH37_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH37_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH37_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH37_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH37_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH37_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH37_0_SCRATCH37_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH37_0_SCRATCH37_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH37_0_SCRATCH37_SHIFT)
#define APBDEV_PMC_SCRATCH37_0_SCRATCH37_RANGE                  31:0
#define APBDEV_PMC_SCRATCH37_0_SCRATCH37_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH37_0_SCRATCH37_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH37_0_SCRATCH37_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH37_0_SCRATCH37_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH37_0_SCRATCH37_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH38_0  // Scratch register 
#define APBDEV_PMC_SCRATCH38_0                  _MK_ADDR_CONST(0x134)
#define APBDEV_PMC_SCRATCH38_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH38_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH38_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH38_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH38_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH38_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH38_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH38_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH38_0_SCRATCH38_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH38_0_SCRATCH38_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH38_0_SCRATCH38_SHIFT)
#define APBDEV_PMC_SCRATCH38_0_SCRATCH38_RANGE                  31:0
#define APBDEV_PMC_SCRATCH38_0_SCRATCH38_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH38_0_SCRATCH38_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH38_0_SCRATCH38_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH38_0_SCRATCH38_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH38_0_SCRATCH38_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH39_0  // Scratch register 
#define APBDEV_PMC_SCRATCH39_0                  _MK_ADDR_CONST(0x138)
#define APBDEV_PMC_SCRATCH39_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH39_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH39_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH39_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH39_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH39_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH39_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH39_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH39_0_SCRATCH39_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH39_0_SCRATCH39_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH39_0_SCRATCH39_SHIFT)
#define APBDEV_PMC_SCRATCH39_0_SCRATCH39_RANGE                  31:0
#define APBDEV_PMC_SCRATCH39_0_SCRATCH39_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH39_0_SCRATCH39_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH39_0_SCRATCH39_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH39_0_SCRATCH39_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH39_0_SCRATCH39_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH40_0  // Scratch register 
#define APBDEV_PMC_SCRATCH40_0                  _MK_ADDR_CONST(0x13c)
#define APBDEV_PMC_SCRATCH40_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH40_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH40_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH40_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH40_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH40_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH40_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH40_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH40_0_SCRATCH40_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH40_0_SCRATCH40_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH40_0_SCRATCH40_SHIFT)
#define APBDEV_PMC_SCRATCH40_0_SCRATCH40_RANGE                  31:0
#define APBDEV_PMC_SCRATCH40_0_SCRATCH40_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH40_0_SCRATCH40_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH40_0_SCRATCH40_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH40_0_SCRATCH40_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH40_0_SCRATCH40_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH41_0  // Scratch register 
#define APBDEV_PMC_SCRATCH41_0                  _MK_ADDR_CONST(0x140)
#define APBDEV_PMC_SCRATCH41_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH41_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH41_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH41_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH41_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH41_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH41_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH41_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH41_0_SCRATCH41_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH41_0_SCRATCH41_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH41_0_SCRATCH41_SHIFT)
#define APBDEV_PMC_SCRATCH41_0_SCRATCH41_RANGE                  31:0
#define APBDEV_PMC_SCRATCH41_0_SCRATCH41_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH41_0_SCRATCH41_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH41_0_SCRATCH41_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH41_0_SCRATCH41_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH41_0_SCRATCH41_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SCRATCH42_0  // Scratch register 
#define APBDEV_PMC_SCRATCH42_0                  _MK_ADDR_CONST(0x144)
#define APBDEV_PMC_SCRATCH42_0_SECURE                   0x0
#define APBDEV_PMC_SCRATCH42_0_WORD_COUNT                       0x1
#define APBDEV_PMC_SCRATCH42_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH42_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH42_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH42_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH42_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_SCRATCH42_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
// General purpose register storage         
#define APBDEV_PMC_SCRATCH42_0_SCRATCH42_SHIFT                  _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SCRATCH42_0_SCRATCH42_FIELD                  (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_SCRATCH42_0_SCRATCH42_SHIFT)
#define APBDEV_PMC_SCRATCH42_0_SCRATCH42_RANGE                  31:0
#define APBDEV_PMC_SCRATCH42_0_SCRATCH42_WOFFSET                        0x0
#define APBDEV_PMC_SCRATCH42_0_SCRATCH42_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH42_0_SCRATCH42_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH42_0_SCRATCH42_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SCRATCH42_0_SCRATCH42_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_BONDOUT_MIRROR0_0  // Secure scratch register
#define APBDEV_PMC_BONDOUT_MIRROR0_0                    _MK_ADDR_CONST(0x148)
#define APBDEV_PMC_BONDOUT_MIRROR0_0_SECURE                     0x0
#define APBDEV_PMC_BONDOUT_MIRROR0_0_WORD_COUNT                         0x1
#define APBDEV_PMC_BONDOUT_MIRROR0_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR0_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR0_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR0_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR0_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_BONDOUT_MIRROR0_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_BONDOUT_MIRROR0_0_BONDOUT_MIRROR0_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_BONDOUT_MIRROR0_0_BONDOUT_MIRROR0_FIELD                      (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_BONDOUT_MIRROR0_0_BONDOUT_MIRROR0_SHIFT)
#define APBDEV_PMC_BONDOUT_MIRROR0_0_BONDOUT_MIRROR0_RANGE                      31:0
#define APBDEV_PMC_BONDOUT_MIRROR0_0_BONDOUT_MIRROR0_WOFFSET                    0x0
#define APBDEV_PMC_BONDOUT_MIRROR0_0_BONDOUT_MIRROR0_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR0_0_BONDOUT_MIRROR0_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR0_0_BONDOUT_MIRROR0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR0_0_BONDOUT_MIRROR0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_BONDOUT_MIRROR1_0  // Secure scratch register
#define APBDEV_PMC_BONDOUT_MIRROR1_0                    _MK_ADDR_CONST(0x14c)
#define APBDEV_PMC_BONDOUT_MIRROR1_0_SECURE                     0x0
#define APBDEV_PMC_BONDOUT_MIRROR1_0_WORD_COUNT                         0x1
#define APBDEV_PMC_BONDOUT_MIRROR1_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR1_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR1_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR1_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR1_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_BONDOUT_MIRROR1_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_BONDOUT_MIRROR1_0_BONDOUT_MIRROR1_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_BONDOUT_MIRROR1_0_BONDOUT_MIRROR1_FIELD                      (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_BONDOUT_MIRROR1_0_BONDOUT_MIRROR1_SHIFT)
#define APBDEV_PMC_BONDOUT_MIRROR1_0_BONDOUT_MIRROR1_RANGE                      31:0
#define APBDEV_PMC_BONDOUT_MIRROR1_0_BONDOUT_MIRROR1_WOFFSET                    0x0
#define APBDEV_PMC_BONDOUT_MIRROR1_0_BONDOUT_MIRROR1_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR1_0_BONDOUT_MIRROR1_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR1_0_BONDOUT_MIRROR1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR1_0_BONDOUT_MIRROR1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_BONDOUT_MIRROR2_0  // Secure scratch register
#define APBDEV_PMC_BONDOUT_MIRROR2_0                    _MK_ADDR_CONST(0x150)
#define APBDEV_PMC_BONDOUT_MIRROR2_0_SECURE                     0x0
#define APBDEV_PMC_BONDOUT_MIRROR2_0_WORD_COUNT                         0x1
#define APBDEV_PMC_BONDOUT_MIRROR2_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR2_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR2_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR2_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR2_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_BONDOUT_MIRROR2_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define APBDEV_PMC_BONDOUT_MIRROR2_0_BONDOUT_MIRROR2_SHIFT                      _MK_SHIFT_CONST(0)
#define APBDEV_PMC_BONDOUT_MIRROR2_0_BONDOUT_MIRROR2_FIELD                      (_MK_MASK_CONST(0xffffffff) << APBDEV_PMC_BONDOUT_MIRROR2_0_BONDOUT_MIRROR2_SHIFT)
#define APBDEV_PMC_BONDOUT_MIRROR2_0_BONDOUT_MIRROR2_RANGE                      31:0
#define APBDEV_PMC_BONDOUT_MIRROR2_0_BONDOUT_MIRROR2_WOFFSET                    0x0
#define APBDEV_PMC_BONDOUT_MIRROR2_0_BONDOUT_MIRROR2_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR2_0_BONDOUT_MIRROR2_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR2_0_BONDOUT_MIRROR2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR2_0_BONDOUT_MIRROR2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_SYS_33V_EN_0  
#define APBDEV_PMC_SYS_33V_EN_0                 _MK_ADDR_CONST(0x154)
#define APBDEV_PMC_SYS_33V_EN_0_SECURE                  0x0
#define APBDEV_PMC_SYS_33V_EN_0_WORD_COUNT                      0x1
#define APBDEV_PMC_SYS_33V_EN_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SYS_33V_EN_0_RESET_MASK                      _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SYS_33V_EN_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SYS_33V_EN_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SYS_33V_EN_0_READ_MASK                       _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SYS_33V_EN_0_WRITE_MASK                      _MK_MASK_CONST(0x1)
// 1 - 3.3v, 0 - 1.8v
#define APBDEV_PMC_SYS_33V_EN_0_val_SHIFT                       _MK_SHIFT_CONST(0)
#define APBDEV_PMC_SYS_33V_EN_0_val_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_SYS_33V_EN_0_val_SHIFT)
#define APBDEV_PMC_SYS_33V_EN_0_val_RANGE                       0:0
#define APBDEV_PMC_SYS_33V_EN_0_val_WOFFSET                     0x0
#define APBDEV_PMC_SYS_33V_EN_0_val_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SYS_33V_EN_0_val_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_SYS_33V_EN_0_val_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_SYS_33V_EN_0_val_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0  
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0                      _MK_ADDR_CONST(0x158)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_SECURE                       0x0
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_WORD_COUNT                   0x1
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_RESET_MASK                   _MK_MASK_CONST(0x3)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_READ_MASK                    _MK_MASK_CONST(0x3)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_WRITE_MASK                   _MK_MASK_CONST(0x3)
// disable write to bondout secure registers
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BWRITE_SHIFT                 _MK_SHIFT_CONST(0)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BWRITE_FIELD                 (_MK_MASK_CONST(0x1) << APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BWRITE_SHIFT)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BWRITE_RANGE                 0:0
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BWRITE_WOFFSET                       0x0
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BWRITE_DEFAULT                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BWRITE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BWRITE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BWRITE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BWRITE_OFF                   _MK_ENUM_CONST(0)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BWRITE_ON                    _MK_ENUM_CONST(1)

// disable read  from bondout secure registers
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BREAD_SHIFT                  _MK_SHIFT_CONST(1)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BREAD_FIELD                  (_MK_MASK_CONST(0x1) << APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BREAD_SHIFT)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BREAD_RANGE                  1:1
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BREAD_WOFFSET                        0x0
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BREAD_DEFAULT                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BREAD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BREAD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BREAD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BREAD_OFF                    _MK_ENUM_CONST(0)
#define APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0_BREAD_ON                     _MK_ENUM_CONST(1)


// Register APBDEV_PMC_GATE_0  
#define APBDEV_PMC_GATE_0                       _MK_ADDR_CONST(0x15c)
#define APBDEV_PMC_GATE_0_SECURE                        0x0
#define APBDEV_PMC_GATE_0_WORD_COUNT                    0x1
#define APBDEV_PMC_GATE_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_GATE_0_RESET_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_GATE_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define APBDEV_PMC_GATE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define APBDEV_PMC_GATE_0_READ_MASK                     _MK_MASK_CONST(0x1)
#define APBDEV_PMC_GATE_0_WRITE_MASK                    _MK_MASK_CONST(0x1)
#define APBDEV_PMC_GATE_0_GATE_WAKE_SHIFT                       _MK_SHIFT_CONST(0)
#define APBDEV_PMC_GATE_0_GATE_WAKE_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_GATE_0_GATE_WAKE_SHIFT)
#define APBDEV_PMC_GATE_0_GATE_WAKE_RANGE                       0:0
#define APBDEV_PMC_GATE_0_GATE_WAKE_WOFFSET                     0x0
#define APBDEV_PMC_GATE_0_GATE_WAKE_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_GATE_0_GATE_WAKE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_GATE_0_GATE_WAKE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_GATE_0_GATE_WAKE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_GATE_0_GATE_WAKE_OFF                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_GATE_0_GATE_WAKE_ON                  _MK_ENUM_CONST(1)

#define APBDEV_PMC_GATE_0_GATE_DBNS_SHIFT                       _MK_SHIFT_CONST(0)
#define APBDEV_PMC_GATE_0_GATE_DBNS_FIELD                       (_MK_MASK_CONST(0x1) << APBDEV_PMC_GATE_0_GATE_DBNS_SHIFT)
#define APBDEV_PMC_GATE_0_GATE_DBNS_RANGE                       0:0
#define APBDEV_PMC_GATE_0_GATE_DBNS_WOFFSET                     0x0
#define APBDEV_PMC_GATE_0_GATE_DBNS_DEFAULT                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_GATE_0_GATE_DBNS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define APBDEV_PMC_GATE_0_GATE_DBNS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define APBDEV_PMC_GATE_0_GATE_DBNS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define APBDEV_PMC_GATE_0_GATE_DBNS_OFF                 _MK_ENUM_CONST(0)
#define APBDEV_PMC_GATE_0_GATE_DBNS_ON                  _MK_ENUM_CONST(1)


//
// REGISTER LIST
//
#define LIST_ARAPBPM_REGS(_op_) \
_op_(APBDEV_PMC_CNTRL_0) \
_op_(APBDEV_PMC_SEC_DISABLE_0) \
_op_(APBDEV_PMC_PMC_SWRST_0) \
_op_(APBDEV_PMC_WAKE_MASK_0) \
_op_(APBDEV_PMC_WAKE_LVL_0) \
_op_(APBDEV_PMC_WAKE_STATUS_0) \
_op_(APBDEV_PMC_SW_WAKE_STATUS_0) \
_op_(APBDEV_PMC_DPD_PADS_ORIDE_0) \
_op_(APBDEV_PMC_DPD_SAMPLE_0) \
_op_(APBDEV_PMC_DPD_ENABLE_0) \
_op_(APBDEV_PMC_PWRGATE_TIMER_OFF_0) \
_op_(APBDEV_PMC_PWRGATE_TIMER_ON_0) \
_op_(APBDEV_PMC_PWRGATE_TOGGLE_0) \
_op_(APBDEV_PMC_REMOVE_CLAMPING_CMD_0) \
_op_(APBDEV_PMC_PWRGATE_STATUS_0) \
_op_(APBDEV_PMC_PWRGOOD_TIMER_0) \
_op_(APBDEV_PMC_BLINK_TIMER_0) \
_op_(APBDEV_PMC_NO_IOPOWER_0) \
_op_(APBDEV_PMC_PWR_DET_0) \
_op_(APBDEV_PMC_PWR_DET_LATCH_0) \
_op_(APBDEV_PMC_SCRATCH0_0) \
_op_(APBDEV_PMC_SCRATCH1_0) \
_op_(APBDEV_PMC_SCRATCH2_0) \
_op_(APBDEV_PMC_SCRATCH3_0) \
_op_(APBDEV_PMC_SCRATCH4_0) \
_op_(APBDEV_PMC_SCRATCH5_0) \
_op_(APBDEV_PMC_SCRATCH6_0) \
_op_(APBDEV_PMC_SCRATCH7_0) \
_op_(APBDEV_PMC_SCRATCH8_0) \
_op_(APBDEV_PMC_SCRATCH9_0) \
_op_(APBDEV_PMC_SCRATCH10_0) \
_op_(APBDEV_PMC_SCRATCH11_0) \
_op_(APBDEV_PMC_SCRATCH12_0) \
_op_(APBDEV_PMC_SCRATCH13_0) \
_op_(APBDEV_PMC_SCRATCH14_0) \
_op_(APBDEV_PMC_SCRATCH15_0) \
_op_(APBDEV_PMC_SCRATCH16_0) \
_op_(APBDEV_PMC_SCRATCH17_0) \
_op_(APBDEV_PMC_SCRATCH18_0) \
_op_(APBDEV_PMC_SCRATCH19_0) \
_op_(APBDEV_PMC_SCRATCH20_0) \
_op_(APBDEV_PMC_SCRATCH21_0) \
_op_(APBDEV_PMC_SCRATCH22_0) \
_op_(APBDEV_PMC_SCRATCH23_0) \
_op_(APBDEV_PMC_SECURE_SCRATCH0_0) \
_op_(APBDEV_PMC_SECURE_SCRATCH1_0) \
_op_(APBDEV_PMC_SECURE_SCRATCH2_0) \
_op_(APBDEV_PMC_SECURE_SCRATCH3_0) \
_op_(APBDEV_PMC_SECURE_SCRATCH4_0) \
_op_(APBDEV_PMC_SECURE_SCRATCH5_0) \
_op_(APBDEV_PMC_CPUPWRGOOD_TIMER_0) \
_op_(APBDEV_PMC_CPUPWROFF_TIMER_0) \
_op_(APBDEV_PMC_PG_MASK_0) \
_op_(APBDEV_PMC_PG_MASK_1_0) \
_op_(APBDEV_PMC_AUTO_WAKE_LVL_0) \
_op_(APBDEV_PMC_AUTO_WAKE_LVL_MASK_0) \
_op_(APBDEV_PMC_WAKE_DELAY_0) \
_op_(APBDEV_PMC_PWR_DET_VAL_0) \
_op_(APBDEV_PMC_DDR_PWR_0) \
_op_(APBDEV_PMC_USB_DEBOUNCE_DEL_0) \
_op_(APBDEV_PMC_USB_AO_0) \
_op_(APBDEV_PMC_CRYPTO_OP_0) \
_op_(APBDEV_PMC_PLLP_WB0_OVERRIDE_0) \
_op_(APBDEV_PMC_SCRATCH24_0) \
_op_(APBDEV_PMC_SCRATCH25_0) \
_op_(APBDEV_PMC_SCRATCH26_0) \
_op_(APBDEV_PMC_SCRATCH27_0) \
_op_(APBDEV_PMC_SCRATCH28_0) \
_op_(APBDEV_PMC_SCRATCH29_0) \
_op_(APBDEV_PMC_SCRATCH30_0) \
_op_(APBDEV_PMC_SCRATCH31_0) \
_op_(APBDEV_PMC_SCRATCH32_0) \
_op_(APBDEV_PMC_SCRATCH33_0) \
_op_(APBDEV_PMC_SCRATCH34_0) \
_op_(APBDEV_PMC_SCRATCH35_0) \
_op_(APBDEV_PMC_SCRATCH36_0) \
_op_(APBDEV_PMC_SCRATCH37_0) \
_op_(APBDEV_PMC_SCRATCH38_0) \
_op_(APBDEV_PMC_SCRATCH39_0) \
_op_(APBDEV_PMC_SCRATCH40_0) \
_op_(APBDEV_PMC_SCRATCH41_0) \
_op_(APBDEV_PMC_SCRATCH42_0) \
_op_(APBDEV_PMC_BONDOUT_MIRROR0_0) \
_op_(APBDEV_PMC_BONDOUT_MIRROR1_0) \
_op_(APBDEV_PMC_BONDOUT_MIRROR2_0) \
_op_(APBDEV_PMC_SYS_33V_EN_0) \
_op_(APBDEV_PMC_BONDOUT_MIRROR_ACCESS_0) \
_op_(APBDEV_PMC_GATE_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_APBDEV_PMC 0x00000000

//
// ARAPBPM REGISTER BANKS
//

#define APBDEV_PMC0_FIRST_REG 0x0000 // APBDEV_PMC_CNTRL_0
#define APBDEV_PMC0_LAST_REG 0x015c // APBDEV_PMC_GATE_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARAPBPM_H_INC_
