/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARCLK_RST_H_INC_
#define ___ARCLK_RST_H_INC_

// Register CLK_RST_CONTROLLER_RST_SOURCE_0  
#define CLK_RST_CONTROLLER_RST_SOURCE_0                 _MK_ADDR_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SECURE                  0x0
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WORD_COUNT                      0x1
#define CLK_RST_CONTROLLER_RST_SOURCE_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_RESET_MASK                      _MK_MASK_CONST(0x3f37)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_READ_MASK                       _MK_MASK_CONST(0x3f37)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WRITE_MASK                      _MK_MASK_CONST(0x37)
// System reset by SW (RO)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_SYS_RST_STA_SHIFT                   _MK_SHIFT_CONST(13)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_SYS_RST_STA_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_SYS_RST_STA_SHIFT)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_SYS_RST_STA_RANGE                   13:13
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_SYS_RST_STA_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_SYS_RST_STA_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_SYS_RST_STA_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_SYS_RST_STA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_SYS_RST_STA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// System reset by watch dog timer (RO)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_STA_SHIFT                   _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_STA_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_STA_SHIFT)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_STA_RANGE                   12:12
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_STA_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_STA_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_STA_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_STA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_STA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// COP reset by SW (RO)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_COP_RST_STA_SHIFT                   _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_COP_RST_STA_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_COP_RST_STA_SHIFT)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_COP_RST_STA_RANGE                   11:11
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_COP_RST_STA_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_COP_RST_STA_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_COP_RST_STA_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_COP_RST_STA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_COP_RST_STA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// COP reset by watch dog timer (RO)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_STA_SHIFT                   _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_STA_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_STA_SHIFT)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_STA_RANGE                   10:10
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_STA_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_STA_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_STA_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_STA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_STA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// CPU reset by SW (RO)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_CPU_RST_STA_SHIFT                   _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_CPU_RST_STA_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_CPU_RST_STA_SHIFT)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_CPU_RST_STA_RANGE                   9:9
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_CPU_RST_STA_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_CPU_RST_STA_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_CPU_RST_STA_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_CPU_RST_STA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_SWR_CPU_RST_STA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// CPU reset by watch dog timer (RO)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_STA_SHIFT                   _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_STA_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_STA_SHIFT)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_STA_RANGE                   8:8
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_STA_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_STA_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_STA_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_STA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_STA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Enable Watch Dog Timer (Dead Man Timer)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_EN_SHIFT                    _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_EN_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_EN_SHIFT)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_EN_RANGE                    5:5
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_EN_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_EN_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_EN_ENABLE                   _MK_ENUM_CONST(1)

// Watch Dog Timer Select
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SEL_SHIFT                   _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SEL_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SEL_SHIFT)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SEL_RANGE                   4:4
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SEL_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SEL_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SEL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SEL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SEL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SEL_INIT_ENUM                       TIMER1
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SEL_TIMER1                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SEL_TIMER2                  _MK_ENUM_CONST(1)

// Enable Watch Dog Timer reset for system.
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_EN_SHIFT                    _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_EN_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_EN_SHIFT)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_EN_RANGE                    2:2
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_EN_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_EN_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_EN_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_SYS_RST_EN_ENABLE                   _MK_ENUM_CONST(1)

// Enable Watch Dog Timer reset for COP
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_EN_SHIFT                    _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_EN_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_EN_SHIFT)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_EN_RANGE                    1:1
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_EN_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_EN_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_EN_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_COP_RST_EN_ENABLE                   _MK_ENUM_CONST(1)

// Enable Watch Dog Timer reset for CPU
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_EN_SHIFT                    _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_EN_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_EN_SHIFT)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_EN_RANGE                    0:0
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_EN_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_EN_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_EN_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_SOURCE_0_WDT_CPU_RST_EN_ENABLE                   _MK_ENUM_CONST(1)


// Register CLK_RST_CONTROLLER_RST_DEVICES_L_0  
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0                      _MK_ADDR_CONST(0x4)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_RESET_VAL                    _MK_MASK_CONST(0x3ffffec9)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_RESET_MASK                   _MK_MASK_CONST(0xbfffffff)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_READ_MASK                    _MK_MASK_CONST(0xbfffffff)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_WRITE_MASK                   _MK_MASK_CONST(0xbfffffff)
// Reset COP cache controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CACHE2_RST_SHIFT                 _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CACHE2_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CACHE2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CACHE2_RST_RANGE                 31:31
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CACHE2_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CACHE2_RST_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CACHE2_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CACHE2_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CACHE2_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CACHE2_RST_INIT_ENUM                     DISABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CACHE2_RST_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CACHE2_RST_ENABLE                        _MK_ENUM_CONST(1)

// Reset vector co-processor.
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VCP_RST_SHIFT                    _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VCP_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VCP_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VCP_RST_RANGE                    29:29
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VCP_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VCP_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VCP_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VCP_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VCP_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VCP_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VCP_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VCP_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset HOST1X.
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_HOST1X_RST_SHIFT                 _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_HOST1X_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_HOST1X_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_HOST1X_RST_RANGE                 28:28
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_HOST1X_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_HOST1X_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_HOST1X_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_HOST1X_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_HOST1X_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_HOST1X_RST_INIT_ENUM                     ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_HOST1X_RST_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_HOST1X_RST_ENABLE                        _MK_ENUM_CONST(1)

// Reset DISP1 controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP1_RST_SHIFT                  _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP1_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP1_RST_RANGE                  27:27
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP1_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP1_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP1_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP1_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP1_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP1_RST_INIT_ENUM                      ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP1_RST_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP1_RST_ENABLE                 _MK_ENUM_CONST(1)

// Reset DISP2 controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP2_RST_SHIFT                  _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP2_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP2_RST_RANGE                  26:26
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP2_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP2_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP2_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP2_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP2_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP2_RST_INIT_ENUM                      ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP2_RST_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_DISP2_RST_ENABLE                 _MK_ENUM_CONST(1)

// Reset IDE controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_IDE_RST_SHIFT                    _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_IDE_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_IDE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_IDE_RST_RANGE                    25:25
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_IDE_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_IDE_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_IDE_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_IDE_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_IDE_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_IDE_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_IDE_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_IDE_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset 3D controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_3D_RST_SHIFT                     _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_3D_RST_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_3D_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_3D_RST_RANGE                     24:24
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_3D_RST_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_3D_RST_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_3D_RST_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_3D_RST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_3D_RST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_3D_RST_INIT_ENUM                 ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_3D_RST_DISABLE                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_3D_RST_ENABLE                    _MK_ENUM_CONST(1)

// Reset ISP controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_ISP_RST_SHIFT                    _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_ISP_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_ISP_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_ISP_RST_RANGE                    23:23
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_ISP_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_ISP_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_ISP_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_ISP_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_ISP_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_ISP_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_ISP_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_ISP_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset USB controller
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_USBD_RST_SHIFT                   _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_USBD_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_USBD_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_USBD_RST_RANGE                   22:22
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_USBD_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_USBD_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_USBD_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_USBD_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_USBD_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_USBD_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_USBD_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_USBD_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset 2D graphics engine controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_2D_RST_SHIFT                     _MK_SHIFT_CONST(21)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_2D_RST_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_2D_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_2D_RST_RANGE                     21:21
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_2D_RST_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_2D_RST_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_2D_RST_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_2D_RST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_2D_RST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_2D_RST_INIT_ENUM                 ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_2D_RST_DISABLE                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_2D_RST_ENABLE                    _MK_ENUM_CONST(1)

// Reset VI controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VI_RST_SHIFT                     _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VI_RST_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VI_RST_RANGE                     20:20
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VI_RST_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VI_RST_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VI_RST_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VI_RST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VI_RST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VI_RST_INIT_ENUM                 ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VI_RST_DISABLE                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_VI_RST_ENABLE                    _MK_ENUM_CONST(1)

// Reset EPP controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_EPP_RST_SHIFT                    _MK_SHIFT_CONST(19)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_EPP_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_EPP_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_EPP_RST_RANGE                    19:19
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_EPP_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_EPP_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_EPP_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_EPP_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_EPP_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_EPP_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_EPP_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_EPP_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset I2S 2 Controller
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S2_RST_SHIFT                   _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S2_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S2_RST_RANGE                   18:18
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S2_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S2_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S2_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S2_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S2_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S2_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S2_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S2_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset Pulse Width Modulator
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_PWM_RST_SHIFT                    _MK_SHIFT_CONST(17)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_PWM_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_PWM_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_PWM_RST_RANGE                    17:17
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_PWM_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_PWM_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_PWM_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_PWM_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_PWM_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_PWM_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_PWM_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_PWM_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset Three Wire Controller
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TWC_RST_SHIFT                    _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TWC_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TWC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TWC_RST_RANGE                    16:16
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TWC_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TWC_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TWC_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TWC_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TWC_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TWC_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TWC_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TWC_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset SDMMC4 controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC4_RST_SHIFT                 _MK_SHIFT_CONST(15)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC4_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC4_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC4_RST_RANGE                 15:15
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC4_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC4_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC4_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC4_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC4_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC4_RST_INIT_ENUM                     ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC4_RST_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC4_RST_ENABLE                        _MK_ENUM_CONST(1)

// Reset SDMMC1 controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC1_RST_SHIFT                 _MK_SHIFT_CONST(14)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC1_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC1_RST_RANGE                 14:14
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC1_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC1_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC1_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC1_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC1_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC1_RST_INIT_ENUM                     ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC1_RST_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC1_RST_ENABLE                        _MK_ENUM_CONST(1)

// Reset NAND flash controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_NDFLASH_RST_SHIFT                        _MK_SHIFT_CONST(13)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_NDFLASH_RST_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_NDFLASH_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_NDFLASH_RST_RANGE                        13:13
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_NDFLASH_RST_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_NDFLASH_RST_DEFAULT                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_NDFLASH_RST_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_NDFLASH_RST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_NDFLASH_RST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_NDFLASH_RST_INIT_ENUM                    ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_NDFLASH_RST_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_NDFLASH_RST_ENABLE                       _MK_ENUM_CONST(1)

// Reset I2C1 Controller
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2C1_RST_SHIFT                   _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2C1_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2C1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2C1_RST_RANGE                   12:12
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2C1_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2C1_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2C1_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2C1_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2C1_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2C1_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2C1_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2C1_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset I2S 1 Controller
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S1_RST_SHIFT                   _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S1_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S1_RST_RANGE                   11:11
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S1_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S1_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S1_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S1_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S1_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S1_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S1_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_I2S1_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset SPDIF Controller
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SPDIF_RST_SHIFT                  _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SPDIF_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SPDIF_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SPDIF_RST_RANGE                  10:10
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SPDIF_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SPDIF_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SPDIF_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SPDIF_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SPDIF_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SPDIF_RST_INIT_ENUM                      ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SPDIF_RST_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SPDIF_RST_ENABLE                 _MK_ENUM_CONST(1)

// Reset SDMMC2 Controller
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC2_RST_SHIFT                 _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC2_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC2_RST_RANGE                 9:9
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC2_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC2_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC2_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC2_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC2_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC2_RST_INIT_ENUM                     ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC2_RST_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_SDMMC2_RST_ENABLE                        _MK_ENUM_CONST(1)

// Reset GPIO Controller
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_GPIO_RST_SHIFT                   _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_GPIO_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_GPIO_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_GPIO_RST_RANGE                   8:8
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_GPIO_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_GPIO_RST_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_GPIO_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_GPIO_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_GPIO_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_GPIO_RST_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_GPIO_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_GPIO_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset UARTB/VFIR Controller
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTB_RST_SHIFT                  _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTB_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTB_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTB_RST_RANGE                  7:7
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTB_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTB_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTB_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTB_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTB_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTB_RST_INIT_ENUM                      ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTB_RST_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTB_RST_ENABLE                 _MK_ENUM_CONST(1)

// Reset UARTA Controller 
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTA_RST_SHIFT                  _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTA_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTA_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTA_RST_RANGE                  6:6
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTA_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTA_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTA_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTA_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTA_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTA_RST_INIT_ENUM                      ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTA_RST_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_UARTA_RST_ENABLE                 _MK_ENUM_CONST(1)

// Reset Timer Controller
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TMR_RST_SHIFT                    _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TMR_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TMR_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TMR_RST_RANGE                    5:5
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TMR_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TMR_RST_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TMR_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TMR_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TMR_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TMR_RST_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TMR_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TMR_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset RTC Controller
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_RTC_RST_SHIFT                    _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_RTC_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_RTC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_RTC_RST_RANGE                    4:4
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_RTC_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_RTC_RST_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_RTC_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_RTC_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_RTC_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_RTC_RST_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_RTC_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_RTC_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset AC97 Controller
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_AC97_RST_SHIFT                   _MK_SHIFT_CONST(3)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_AC97_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_AC97_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_AC97_RST_RANGE                   3:3
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_AC97_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_AC97_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_AC97_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_AC97_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_AC97_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_AC97_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_AC97_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_AC97_RST_ENABLE                  _MK_ENUM_CONST(1)

// Write 1 to pulse System Reset Signal. HW clears  this bit
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TRIG_SYS_RST_SHIFT                       _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TRIG_SYS_RST_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TRIG_SYS_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TRIG_SYS_RST_RANGE                       2:2
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TRIG_SYS_RST_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TRIG_SYS_RST_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TRIG_SYS_RST_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TRIG_SYS_RST_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TRIG_SYS_RST_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TRIG_SYS_RST_INIT_ENUM                   DISABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TRIG_SYS_RST_DISABLE                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_TRIG_SYS_RST_ENABLE                      _MK_ENUM_CONST(1)

// Write 1 to force COP Reset Signal. SW needs to  clear this bit when done.
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_COP_RST_SHIFT                    _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_COP_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_COP_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_COP_RST_RANGE                    1:1
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_COP_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_COP_RST_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_COP_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_COP_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_COP_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_COP_RST_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_COP_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_COP_RST_ENABLE                   _MK_ENUM_CONST(1)

// Write 1 to force CPU Reset Signal. SW needs to  clear this bit when done.
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CPU_RST_SHIFT                    _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CPU_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CPU_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CPU_RST_RANGE                    0:0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CPU_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CPU_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CPU_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CPU_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CPU_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CPU_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CPU_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_L_0_SWR_CPU_RST_ENABLE                   _MK_ENUM_CONST(1)


// Register CLK_RST_CONTROLLER_RST_DEVICES_H_0  
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0                      _MK_ADDR_CONST(0x8)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_RESET_VAL                    _MK_MASK_CONST(0xfefffb77)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_RESET_MASK                   _MK_MASK_CONST(0xfefffff7)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_READ_MASK                    _MK_MASK_CONST(0xfefffff7)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_WRITE_MASK                   _MK_MASK_CONST(0xfefffff7)
// Reset BSEV controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEV_RST_SHIFT                   _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEV_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEV_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEV_RST_RANGE                   31:31
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEV_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEV_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEV_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEV_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEV_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEV_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEV_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEV_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset BSEA controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEA_RST_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEA_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEA_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEA_RST_RANGE                   30:30
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEA_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEA_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEA_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEA_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEA_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEA_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEA_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_BSEA_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset VDE & BSEV controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_VDE_RST_SHIFT                    _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_VDE_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_VDE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_VDE_RST_RANGE                    29:29
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_VDE_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_VDE_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_VDE_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_VDE_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_VDE_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_VDE_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_VDE_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_VDE_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset MPE controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MPE_RST_SHIFT                    _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MPE_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MPE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MPE_RST_RANGE                    28:28
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MPE_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MPE_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MPE_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MPE_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MPE_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MPE_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MPE_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MPE_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset USB3 controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB3_RST_SHIFT                   _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB3_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB3_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB3_RST_RANGE                   27:27
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB3_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB3_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB3_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB3_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB3_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB3_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB3_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB3_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset USB2 controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB2_RST_SHIFT                   _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB2_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB2_RST_RANGE                   26:26
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB2_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB2_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB2_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB2_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB2_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB2_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB2_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_USB2_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset EMC controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_EMC_RST_SHIFT                    _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_EMC_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_EMC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_EMC_RST_RANGE                    25:25
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_EMC_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_EMC_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_EMC_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_EMC_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_EMC_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_EMC_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_EMC_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_EMC_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset UART C Controller
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_UARTC_RST_SHIFT                  _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_UARTC_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_UARTC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_UARTC_RST_RANGE                  23:23
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_UARTC_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_UARTC_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_UARTC_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_UARTC_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_UARTC_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_UARTC_RST_INIT_ENUM                      ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_UARTC_RST_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_UARTC_RST_ENABLE                 _MK_ENUM_CONST(1)

// Reset I2C 2 controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_I2C2_RST_SHIFT                   _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_I2C2_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_I2C2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_I2C2_RST_RANGE                   22:22
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_I2C2_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_I2C2_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_I2C2_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_I2C2_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_I2C2_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_I2C2_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_I2C2_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_I2C2_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset TVDAC controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVDAC_RST_SHIFT                  _MK_SHIFT_CONST(21)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVDAC_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVDAC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVDAC_RST_RANGE                  21:21
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVDAC_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVDAC_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVDAC_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVDAC_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVDAC_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVDAC_RST_INIT_ENUM                      ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVDAC_RST_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVDAC_RST_ENABLE                 _MK_ENUM_CONST(1)

// Reset CSI controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_CSI_RST_SHIFT                    _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_CSI_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_CSI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_CSI_RST_RANGE                    20:20
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_CSI_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_CSI_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_CSI_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_CSI_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_CSI_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_CSI_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_CSI_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_CSI_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset HDMI
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_HDMI_RST_SHIFT                   _MK_SHIFT_CONST(19)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_HDMI_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_HDMI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_HDMI_RST_RANGE                   19:19
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_HDMI_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_HDMI_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_HDMI_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_HDMI_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_HDMI_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_HDMI_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_HDMI_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_HDMI_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset MIPI base-band controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MIPI_RST_SHIFT                   _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MIPI_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MIPI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MIPI_RST_RANGE                   18:18
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MIPI_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MIPI_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MIPI_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MIPI_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MIPI_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MIPI_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MIPI_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MIPI_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset TVO/CVE controller
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVO_RST_SHIFT                    _MK_SHIFT_CONST(17)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVO_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVO_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVO_RST_RANGE                    17:17
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVO_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVO_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVO_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVO_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVO_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVO_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVO_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_TVO_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset DSI controller
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DSI_RST_SHIFT                    _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DSI_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DSI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DSI_RST_RANGE                    16:16
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DSI_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DSI_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DSI_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DSI_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DSI_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DSI_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DSI_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DSI_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset DVC-I2C Controller
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DVC_I2C_RST_SHIFT                        _MK_SHIFT_CONST(15)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DVC_I2C_RST_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DVC_I2C_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DVC_I2C_RST_RANGE                        15:15
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DVC_I2C_RST_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DVC_I2C_RST_DEFAULT                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DVC_I2C_RST_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DVC_I2C_RST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DVC_I2C_RST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DVC_I2C_RST_INIT_ENUM                    ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DVC_I2C_RST_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_DVC_I2C_RST_ENABLE                       _MK_ENUM_CONST(1)

// Reset SBC 3 Controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC3_RST_SHIFT                   _MK_SHIFT_CONST(14)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC3_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC3_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC3_RST_RANGE                   14:14
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC3_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC3_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC3_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC3_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC3_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC3_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC3_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC3_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset XIO controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_XIO_RST_SHIFT                    _MK_SHIFT_CONST(13)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_XIO_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_XIO_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_XIO_RST_RANGE                    13:13
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_XIO_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_XIO_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_XIO_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_XIO_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_XIO_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_XIO_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_XIO_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_XIO_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset SBC 2 Controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC2_RST_SHIFT                   _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC2_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC2_RST_RANGE                   12:12
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC2_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC2_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC2_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC2_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC2_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC2_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC2_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC2_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset SPI 1 Controller
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SPI1_RST_SHIFT                   _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SPI1_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SPI1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SPI1_RST_RANGE                   11:11
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SPI1_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SPI1_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SPI1_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SPI1_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SPI1_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SPI1_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SPI1_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SPI1_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset NOR Flash Controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_NOR_RST_SHIFT                    _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_NOR_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_NOR_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_NOR_RST_RANGE                    10:10
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_NOR_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_NOR_RST_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_NOR_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_NOR_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_NOR_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_NOR_RST_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_NOR_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_NOR_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset NOR Flash Controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SNOR_RST_SHIFT                   _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SNOR_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SNOR_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SNOR_RST_RANGE                   10:10
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SNOR_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SNOR_RST_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SNOR_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SNOR_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SNOR_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SNOR_RST_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SNOR_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SNOR_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset SBC 1 Controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC1_RST_SHIFT                   _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC1_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC1_RST_RANGE                   9:9
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC1_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC1_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC1_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC1_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC1_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC1_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC1_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_SBC1_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset KFuse controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KFUSE_RST_SHIFT                  _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KFUSE_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KFUSE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KFUSE_RST_RANGE                  8:8
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KFUSE_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KFUSE_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KFUSE_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KFUSE_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KFUSE_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KFUSE_RST_INIT_ENUM                      ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KFUSE_RST_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KFUSE_RST_ENABLE                 _MK_ENUM_CONST(1)

// Reset Fuse controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_FUSE_RST_SHIFT                   _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_FUSE_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_FUSE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_FUSE_RST_RANGE                   7:7
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_FUSE_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_FUSE_RST_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_FUSE_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_FUSE_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_FUSE_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_FUSE_RST_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_FUSE_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_FUSE_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset PMC controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_PMC_RST_SHIFT                    _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_PMC_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_PMC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_PMC_RST_RANGE                    6:6
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_PMC_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_PMC_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_PMC_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_PMC_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_PMC_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_PMC_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_PMC_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_PMC_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset statistic monitor
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_STAT_MON_RST_SHIFT                       _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_STAT_MON_RST_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_STAT_MON_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_STAT_MON_RST_RANGE                       5:5
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_STAT_MON_RST_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_STAT_MON_RST_DEFAULT                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_STAT_MON_RST_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_STAT_MON_RST_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_STAT_MON_RST_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_STAT_MON_RST_INIT_ENUM                   ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_STAT_MON_RST_DISABLE                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_STAT_MON_RST_ENABLE                      _MK_ENUM_CONST(1)

// Reset Keyboard controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KBC_RST_SHIFT                    _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KBC_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KBC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KBC_RST_RANGE                    4:4
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KBC_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KBC_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KBC_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KBC_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KBC_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KBC_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KBC_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_KBC_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset APB-DMA.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_APBDMA_RST_SHIFT                 _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_APBDMA_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_APBDMA_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_APBDMA_RST_RANGE                 2:2
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_APBDMA_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_APBDMA_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_APBDMA_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_APBDMA_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_APBDMA_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_APBDMA_RST_INIT_ENUM                     ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_APBDMA_RST_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_APBDMA_RST_ENABLE                        _MK_ENUM_CONST(1)

// Reset AHB-DMA.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_AHBDMA_RST_SHIFT                 _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_AHBDMA_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_AHBDMA_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_AHBDMA_RST_RANGE                 1:1
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_AHBDMA_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_AHBDMA_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_AHBDMA_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_AHBDMA_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_AHBDMA_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_AHBDMA_RST_INIT_ENUM                     ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_AHBDMA_RST_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_AHBDMA_RST_ENABLE                        _MK_ENUM_CONST(1)

// Reset MC.
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MEM_RST_SHIFT                    _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MEM_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MEM_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MEM_RST_RANGE                    0:0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MEM_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MEM_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MEM_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MEM_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MEM_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MEM_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MEM_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_H_0_SWR_MEM_RST_ENABLE                   _MK_ENUM_CONST(1)


// Register CLK_RST_CONTROLLER_RST_DEVICES_U_0  
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0                      _MK_ADDR_CONST(0xc)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_RESET_VAL                    _MK_MASK_CONST(0x15ff)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_RESET_MASK                   _MK_MASK_CONST(0x1fff)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_READ_MASK                    _MK_MASK_CONST(0x1fff)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_WRITE_MASK                   _MK_MASK_CONST(0x1fff)
// Reset LA logic.
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_LA_RST_SHIFT                     _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_LA_RST_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_LA_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_LA_RST_RANGE                     12:12
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_LA_RST_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_LA_RST_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_LA_RST_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_LA_RST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_LA_RST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_LA_RST_INIT_ENUM                 ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_LA_RST_DISABLE                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_LA_RST_ENABLE                    _MK_ENUM_CONST(1)

// Reset AVPUCQ logic.
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AVPUCQ_RST_SHIFT                 _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AVPUCQ_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AVPUCQ_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AVPUCQ_RST_RANGE                 11:11
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AVPUCQ_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AVPUCQ_RST_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AVPUCQ_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AVPUCQ_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AVPUCQ_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AVPUCQ_RST_INIT_ENUM                     DISABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AVPUCQ_RST_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AVPUCQ_RST_ENABLE                        _MK_ENUM_CONST(1)

// Reset PCIEXCLK logic.
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIEXCLK_RST_SHIFT                       _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIEXCLK_RST_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIEXCLK_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIEXCLK_RST_RANGE                       10:10
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIEXCLK_RST_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIEXCLK_RST_DEFAULT                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIEXCLK_RST_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIEXCLK_RST_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIEXCLK_RST_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIEXCLK_RST_INIT_ENUM                   ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIEXCLK_RST_DISABLE                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIEXCLK_RST_ENABLE                      _MK_ENUM_CONST(1)

// Reset Coresight controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_CSITE_RST_SHIFT                  _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_CSITE_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_CSITE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_CSITE_RST_RANGE                  9:9
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_CSITE_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_CSITE_RST_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_CSITE_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_CSITE_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_CSITE_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_CSITE_RST_INIT_ENUM                      DISABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_CSITE_RST_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_CSITE_RST_ENABLE                 _MK_ENUM_CONST(1)

// Reset AFI controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AFI_RST_SHIFT                    _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AFI_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AFI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AFI_RST_RANGE                    8:8
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AFI_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AFI_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AFI_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AFI_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AFI_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AFI_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AFI_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_AFI_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset OWR controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_OWR_RST_SHIFT                    _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_OWR_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_OWR_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_OWR_RST_RANGE                    7:7
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_OWR_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_OWR_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_OWR_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_OWR_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_OWR_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_OWR_RST_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_OWR_RST_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_OWR_RST_ENABLE                   _MK_ENUM_CONST(1)

// Reset PCIE controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIE_RST_SHIFT                   _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIE_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIE_RST_RANGE                   6:6
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIE_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIE_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIE_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIE_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIE_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIE_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIE_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_PCIE_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset SDMMC3 controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SDMMC3_RST_SHIFT                 _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SDMMC3_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SDMMC3_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SDMMC3_RST_RANGE                 5:5
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SDMMC3_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SDMMC3_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SDMMC3_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SDMMC3_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SDMMC3_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SDMMC3_RST_INIT_ENUM                     ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SDMMC3_RST_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SDMMC3_RST_ENABLE                        _MK_ENUM_CONST(1)

// Reset SBC4 controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SBC4_RST_SHIFT                   _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SBC4_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SBC4_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SBC4_RST_RANGE                   4:4
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SBC4_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SBC4_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SBC4_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SBC4_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SBC4_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SBC4_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SBC4_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SBC4_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset I2C3 controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_I2C3_RST_SHIFT                   _MK_SHIFT_CONST(3)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_I2C3_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_I2C3_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_I2C3_RST_RANGE                   3:3
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_I2C3_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_I2C3_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_I2C3_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_I2C3_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_I2C3_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_I2C3_RST_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_I2C3_RST_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_I2C3_RST_ENABLE                  _MK_ENUM_CONST(1)

// Reset UARTE controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTE_RST_SHIFT                  _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTE_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTE_RST_RANGE                  2:2
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTE_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTE_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTE_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTE_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTE_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTE_RST_INIT_ENUM                      ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTE_RST_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTE_RST_ENABLE                 _MK_ENUM_CONST(1)

// Reset UARTD controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTD_RST_SHIFT                  _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTD_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTD_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTD_RST_RANGE                  1:1
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTD_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTD_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTD_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTD_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTD_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTD_RST_INIT_ENUM                      ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTD_RST_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_UARTD_RST_ENABLE                 _MK_ENUM_CONST(1)

// Reset SPEEDO controller.
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SPEEDO_RST_SHIFT                 _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SPEEDO_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SPEEDO_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SPEEDO_RST_RANGE                 0:0
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SPEEDO_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SPEEDO_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SPEEDO_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SPEEDO_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SPEEDO_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SPEEDO_RST_INIT_ENUM                     ENABLE
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SPEEDO_RST_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEVICES_U_0_SWR_SPEEDO_RST_ENABLE                        _MK_ENUM_CONST(1)


// Register CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0  
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0                      _MK_ADDR_CONST(0x10)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_RESET_VAL                    _MK_MASK_CONST(0x80000130)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_RESET_MASK                   _MK_MASK_CONST(0xbffffff9)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_READ_MASK                    _MK_MASK_CONST(0xbffffff9)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_WRITE_MASK                   _MK_MASK_CONST(0xbffffff9)
// Enable clock to COP cache controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CACHE2_SHIFT                 _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CACHE2_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CACHE2_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CACHE2_RANGE                 31:31
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CACHE2_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CACHE2_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CACHE2_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CACHE2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CACHE2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CACHE2_INIT_ENUM                     ENABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CACHE2_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CACHE2_ENABLE                        _MK_ENUM_CONST(1)

// Enable clock to vector co-processor.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VCP_SHIFT                    _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VCP_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VCP_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VCP_RANGE                    29:29
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VCP_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VCP_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VCP_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VCP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VCP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VCP_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VCP_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VCP_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to HOST1X.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_HOST1X_SHIFT                 _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_HOST1X_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_HOST1X_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_HOST1X_RANGE                 28:28
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_HOST1X_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_HOST1X_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_HOST1X_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_HOST1X_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_HOST1X_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_HOST1X_INIT_ENUM                     DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_HOST1X_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_HOST1X_ENABLE                        _MK_ENUM_CONST(1)

// Enable clock to DISP1 controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP1_SHIFT                  _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP1_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP1_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP1_RANGE                  27:27
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP1_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP1_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP1_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP1_INIT_ENUM                      DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP1_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP1_ENABLE                 _MK_ENUM_CONST(1)

// Enable clock to DISP2 controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP2_SHIFT                  _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP2_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP2_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP2_RANGE                  26:26
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP2_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP2_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP2_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP2_INIT_ENUM                      DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP2_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_DISP2_ENABLE                 _MK_ENUM_CONST(1)

// Enable clock to IDE controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_IDE_SHIFT                    _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_IDE_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_IDE_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_IDE_RANGE                    25:25
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_IDE_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_IDE_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_IDE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_IDE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_IDE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_IDE_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_IDE_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_IDE_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to 3D controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_3D_SHIFT                     _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_3D_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_3D_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_3D_RANGE                     24:24
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_3D_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_3D_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_3D_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_3D_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_3D_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_3D_INIT_ENUM                 DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_3D_DISABLE                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_3D_ENABLE                    _MK_ENUM_CONST(1)

// Enable clock to ISP controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_ISP_SHIFT                    _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_ISP_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_ISP_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_ISP_RANGE                    23:23
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_ISP_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_ISP_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_ISP_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_ISP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_ISP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_ISP_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_ISP_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_ISP_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to USB controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_USBD_SHIFT                   _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_USBD_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_USBD_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_USBD_RANGE                   22:22
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_USBD_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_USBD_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_USBD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_USBD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_USBD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_USBD_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_USBD_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_USBD_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to 2D graphics engine.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_2D_SHIFT                     _MK_SHIFT_CONST(21)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_2D_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_2D_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_2D_RANGE                     21:21
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_2D_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_2D_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_2D_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_2D_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_2D_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_2D_INIT_ENUM                 DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_2D_DISABLE                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_2D_ENABLE                    _MK_ENUM_CONST(1)

// Enable clock to VI controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VI_SHIFT                     _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VI_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VI_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VI_RANGE                     20:20
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VI_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VI_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VI_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VI_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VI_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VI_INIT_ENUM                 DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VI_DISABLE                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_VI_ENABLE                    _MK_ENUM_CONST(1)

// Enable clock to EPP controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_EPP_SHIFT                    _MK_SHIFT_CONST(19)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_EPP_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_EPP_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_EPP_RANGE                    19:19
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_EPP_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_EPP_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_EPP_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_EPP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_EPP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_EPP_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_EPP_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_EPP_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to I2S 2 controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S2_SHIFT                   _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S2_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S2_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S2_RANGE                   18:18
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S2_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S2_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S2_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S2_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S2_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S2_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to PWM (Pulse Width Modulator)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_PWM_SHIFT                    _MK_SHIFT_CONST(17)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_PWM_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_PWM_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_PWM_RANGE                    17:17
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_PWM_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_PWM_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_PWM_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_PWM_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_PWM_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_PWM_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_PWM_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_PWM_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to 3-Wire Interface Controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TWC_SHIFT                    _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TWC_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TWC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TWC_RANGE                    16:16
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TWC_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TWC_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TWC_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TWC_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TWC_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TWC_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TWC_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TWC_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to SDMMC4 controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC4_SHIFT                 _MK_SHIFT_CONST(15)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC4_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC4_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC4_RANGE                 15:15
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC4_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC4_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC4_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC4_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC4_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC4_INIT_ENUM                     DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC4_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC4_ENABLE                        _MK_ENUM_CONST(1)

// Enable clock to SDMMC1 controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC1_SHIFT                 _MK_SHIFT_CONST(14)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC1_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC1_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC1_RANGE                 14:14
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC1_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC1_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC1_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC1_INIT_ENUM                     DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC1_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC1_ENABLE                        _MK_ENUM_CONST(1)

// Enable clock to NAND flash controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_NDFLASH_SHIFT                        _MK_SHIFT_CONST(13)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_NDFLASH_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_NDFLASH_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_NDFLASH_RANGE                        13:13
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_NDFLASH_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_NDFLASH_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_NDFLASH_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_NDFLASH_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_NDFLASH_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_NDFLASH_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_NDFLASH_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_NDFLASH_ENABLE                       _MK_ENUM_CONST(1)

// Enable clock to I2C1 Controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2C1_SHIFT                   _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2C1_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2C1_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2C1_RANGE                   12:12
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2C1_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2C1_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2C1_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2C1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2C1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2C1_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2C1_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2C1_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to I2S1 Controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S1_SHIFT                   _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S1_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S1_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S1_RANGE                   11:11
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S1_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S1_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S1_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S1_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S1_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_I2S1_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to SPDIF Controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SPDIF_SHIFT                  _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SPDIF_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SPDIF_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SPDIF_RANGE                  10:10
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SPDIF_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SPDIF_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SPDIF_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SPDIF_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SPDIF_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SPDIF_INIT_ENUM                      DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SPDIF_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SPDIF_ENABLE                 _MK_ENUM_CONST(1)

// Enable clock to SDMMC2 controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC2_SHIFT                 _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC2_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC2_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC2_RANGE                 9:9
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC2_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC2_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC2_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC2_INIT_ENUM                     DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC2_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_SDMMC2_ENABLE                        _MK_ENUM_CONST(1)

// Enable clock to GPIO Controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_GPIO_SHIFT                   _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_GPIO_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_GPIO_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_GPIO_RANGE                   8:8
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_GPIO_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_GPIO_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_GPIO_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_GPIO_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_GPIO_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_GPIO_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_GPIO_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_GPIO_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to UARTB/VFIR Controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTB_SHIFT                  _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTB_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTB_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTB_RANGE                  7:7
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTB_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTB_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTB_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTB_INIT_ENUM                      DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTB_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTB_ENABLE                 _MK_ENUM_CONST(1)

// Enable clock to UARTA Controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTA_SHIFT                  _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTA_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTA_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTA_RANGE                  6:6
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTA_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTA_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTA_INIT_ENUM                      DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTA_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_UARTA_ENABLE                 _MK_ENUM_CONST(1)

// Enable clock to Timer Controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TMR_SHIFT                    _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TMR_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TMR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TMR_RANGE                    5:5
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TMR_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TMR_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TMR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TMR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TMR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TMR_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TMR_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_TMR_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to RTC Controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_RTC_SHIFT                    _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_RTC_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_RTC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_RTC_RANGE                    4:4
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_RTC_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_RTC_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_RTC_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_RTC_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_RTC_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_RTC_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_RTC_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_RTC_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to AC97 Controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_AC97_SHIFT                   _MK_SHIFT_CONST(3)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_AC97_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_AC97_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_AC97_RANGE                   3:3
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_AC97_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_AC97_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_AC97_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_AC97_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_AC97_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_AC97_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_AC97_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_AC97_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to CPU.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CPU_SHIFT                    _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CPU_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CPU_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CPU_RANGE                    0:0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CPU_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CPU_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CPU_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CPU_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CPU_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CPU_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CPU_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_L_0_CLK_ENB_CPU_ENABLE                   _MK_ENUM_CONST(1)


// Register CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0  
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0                      _MK_ADDR_CONST(0x14)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_RESET_VAL                    _MK_MASK_CONST(0x480)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_RESET_MASK                   _MK_MASK_CONST(0xfefffff7)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_READ_MASK                    _MK_MASK_CONST(0xfefffff7)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_WRITE_MASK                   _MK_MASK_CONST(0xfefffff7)
// Enable clock to BSEV Controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEV_SHIFT                   _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEV_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEV_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEV_RANGE                   31:31
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEV_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEV_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEV_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEV_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEV_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEV_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEV_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEV_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to BSEA Controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEA_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEA_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEA_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEA_RANGE                   30:30
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEA_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEA_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEA_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEA_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEA_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_BSEA_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to VDE Controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_VDE_SHIFT                    _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_VDE_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_VDE_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_VDE_RANGE                    29:29
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_VDE_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_VDE_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_VDE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_VDE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_VDE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_VDE_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_VDE_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_VDE_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to MPE controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MPE_SHIFT                    _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MPE_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MPE_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MPE_RANGE                    28:28
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MPE_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MPE_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MPE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MPE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MPE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MPE_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MPE_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MPE_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to USB3 controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB3_SHIFT                   _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB3_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB3_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB3_RANGE                   27:27
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB3_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB3_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB3_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB3_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB3_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB3_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB3_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB3_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to USB2 controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB2_SHIFT                   _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB2_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB2_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB2_RANGE                   26:26
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB2_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB2_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB2_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB2_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB2_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_USB2_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to EMC controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_EMC_SHIFT                    _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_EMC_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_EMC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_EMC_RANGE                    25:25
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_EMC_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_EMC_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_EMC_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_EMC_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_EMC_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_EMC_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_EMC_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_EMC_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to UART-C Controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_UARTC_SHIFT                  _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_UARTC_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_UARTC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_UARTC_RANGE                  23:23
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_UARTC_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_UARTC_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_UARTC_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_UARTC_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_UARTC_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_UARTC_INIT_ENUM                      DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_UARTC_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_UARTC_ENABLE                 _MK_ENUM_CONST(1)

// Enable clock to I2C2 controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_I2C2_SHIFT                   _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_I2C2_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_I2C2_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_I2C2_RANGE                   22:22
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_I2C2_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_I2C2_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_I2C2_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_I2C2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_I2C2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_I2C2_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_I2C2_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_I2C2_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to TVDAC controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVDAC_SHIFT                  _MK_SHIFT_CONST(21)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVDAC_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVDAC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVDAC_RANGE                  21:21
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVDAC_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVDAC_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVDAC_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVDAC_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVDAC_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVDAC_INIT_ENUM                      DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVDAC_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVDAC_ENABLE                 _MK_ENUM_CONST(1)

// Enable clock to CSI controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_CSI_SHIFT                    _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_CSI_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_CSI_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_CSI_RANGE                    20:20
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_CSI_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_CSI_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_CSI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_CSI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_CSI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_CSI_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_CSI_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_CSI_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to HDMI
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_HDMI_SHIFT                   _MK_SHIFT_CONST(19)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_HDMI_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_HDMI_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_HDMI_RANGE                   19:19
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_HDMI_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_HDMI_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_HDMI_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_HDMI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_HDMI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_HDMI_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_HDMI_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_HDMI_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to MIPI base-band controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MIPI_SHIFT                   _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MIPI_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MIPI_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MIPI_RANGE                   18:18
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MIPI_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MIPI_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MIPI_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MIPI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MIPI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MIPI_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MIPI_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MIPI_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to TVO/CVE controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVO_SHIFT                    _MK_SHIFT_CONST(17)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVO_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVO_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVO_RANGE                    17:17
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVO_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVO_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVO_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVO_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVO_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVO_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVO_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_TVO_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to DSI controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DSI_SHIFT                    _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DSI_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DSI_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DSI_RANGE                    16:16
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DSI_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DSI_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DSI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DSI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DSI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DSI_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DSI_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DSI_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to DVC-I2C Controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DVC_I2C_SHIFT                        _MK_SHIFT_CONST(15)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DVC_I2C_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DVC_I2C_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DVC_I2C_RANGE                        15:15
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DVC_I2C_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DVC_I2C_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DVC_I2C_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DVC_I2C_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DVC_I2C_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DVC_I2C_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DVC_I2C_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_DVC_I2C_ENABLE                       _MK_ENUM_CONST(1)

// Enable clock to SBC 3 Controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC3_SHIFT                   _MK_SHIFT_CONST(14)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC3_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC3_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC3_RANGE                   14:14
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC3_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC3_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC3_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC3_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC3_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC3_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC3_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC3_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to XIO Controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_XIO_SHIFT                    _MK_SHIFT_CONST(13)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_XIO_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_XIO_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_XIO_RANGE                    13:13
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_XIO_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_XIO_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_XIO_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_XIO_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_XIO_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_XIO_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_XIO_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_XIO_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to SBC 2 Controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC2_SHIFT                   _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC2_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC2_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC2_RANGE                   12:12
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC2_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC2_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC2_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC2_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC2_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC2_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to SPI 1 Controller
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SPI1_SHIFT                   _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SPI1_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SPI1_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SPI1_RANGE                   11:11
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SPI1_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SPI1_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SPI1_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SPI1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SPI1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SPI1_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SPI1_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SPI1_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to NOR Flash Controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_NOR_SHIFT                    _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_NOR_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_NOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_NOR_RANGE                    10:10
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_NOR_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_NOR_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_NOR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_NOR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_NOR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_NOR_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_NOR_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_NOR_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to NOR Flash Controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SNOR_SHIFT                   _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SNOR_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SNOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SNOR_RANGE                   10:10
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SNOR_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SNOR_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SNOR_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SNOR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SNOR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SNOR_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SNOR_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SNOR_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to SBC 1 Controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC1_SHIFT                   _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC1_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC1_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC1_RANGE                   9:9
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC1_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC1_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC1_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC1_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC1_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_SBC1_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to KFUSE controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KFUSE_SHIFT                  _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KFUSE_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KFUSE_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KFUSE_RANGE                  8:8
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KFUSE_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KFUSE_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KFUSE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KFUSE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KFUSE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KFUSE_INIT_ENUM                      DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KFUSE_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KFUSE_ENABLE                 _MK_ENUM_CONST(1)

// Enable clock to FUSE controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_FUSE_SHIFT                   _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_FUSE_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_FUSE_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_FUSE_RANGE                   7:7
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_FUSE_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_FUSE_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_FUSE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_FUSE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_FUSE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_FUSE_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_FUSE_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_FUSE_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to PMC controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_PMC_SHIFT                    _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_PMC_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_PMC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_PMC_RANGE                    6:6
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_PMC_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_PMC_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_PMC_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_PMC_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_PMC_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_PMC_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_PMC_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_PMC_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to statistic monitor.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_STAT_MON_SHIFT                       _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_STAT_MON_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_STAT_MON_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_STAT_MON_RANGE                       5:5
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_STAT_MON_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_STAT_MON_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_STAT_MON_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_STAT_MON_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_STAT_MON_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_STAT_MON_INIT_ENUM                   DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_STAT_MON_DISABLE                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_STAT_MON_ENABLE                      _MK_ENUM_CONST(1)

// Enable clock to keyboard controller.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KBC_SHIFT                    _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KBC_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KBC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KBC_RANGE                    4:4
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KBC_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KBC_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KBC_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KBC_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KBC_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KBC_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KBC_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_KBC_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to APB-DMA.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_APBDMA_SHIFT                 _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_APBDMA_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_APBDMA_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_APBDMA_RANGE                 2:2
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_APBDMA_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_APBDMA_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_APBDMA_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_APBDMA_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_APBDMA_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_APBDMA_INIT_ENUM                     DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_APBDMA_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_APBDMA_ENABLE                        _MK_ENUM_CONST(1)

// Enable clock to AHB-DMA.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_AHBDMA_SHIFT                 _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_AHBDMA_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_AHBDMA_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_AHBDMA_RANGE                 1:1
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_AHBDMA_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_AHBDMA_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_AHBDMA_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_AHBDMA_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_AHBDMA_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_AHBDMA_INIT_ENUM                     DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_AHBDMA_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_AHBDMA_ENABLE                        _MK_ENUM_CONST(1)

// Enable clock to MC/EMC.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MEM_SHIFT                    _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MEM_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MEM_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MEM_RANGE                    0:0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MEM_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MEM_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MEM_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MEM_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MEM_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MEM_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MEM_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_H_0_CLK_ENB_MEM_ENABLE                   _MK_ENUM_CONST(1)


// Register CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0  
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0                      _MK_ADDR_CONST(0x18)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_RESET_VAL                    _MK_MASK_CONST(0x7f00a00)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_RESET_MASK                   _MK_MASK_CONST(0x77f01bff)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_READ_MASK                    _MK_MASK_CONST(0x77f01bff)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_WRITE_MASK                   _MK_MASK_CONST(0x77f01bff)
// Enable clock to DEV1 pad.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV1_OUT_SHIFT                       _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV1_OUT_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV1_OUT_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV1_OUT_RANGE                       30:30
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV1_OUT_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV1_OUT_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV1_OUT_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV1_OUT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV1_OUT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV1_OUT_INIT_ENUM                   DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV1_OUT_DISABLE                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV1_OUT_ENABLE                      _MK_ENUM_CONST(1)

// Enable clock to DEV2 pad.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV2_OUT_SHIFT                       _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV2_OUT_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV2_OUT_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV2_OUT_RANGE                       29:29
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV2_OUT_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV2_OUT_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV2_OUT_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV2_OUT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV2_OUT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV2_OUT_INIT_ENUM                   DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV2_OUT_DISABLE                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_DEV2_OUT_ENABLE                      _MK_ENUM_CONST(1)

// Enable clock to SUS pad.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SUS_OUT_SHIFT                        _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SUS_OUT_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SUS_OUT_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SUS_OUT_RANGE                        28:28
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SUS_OUT_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SUS_OUT_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SUS_OUT_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SUS_OUT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SUS_OUT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SUS_OUT_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SUS_OUT_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SUS_OUT_ENABLE                       _MK_ENUM_CONST(1)

// Enable CLK_M clk doubler.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_M_DOUBLER_ENB_SHIFT                      _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_M_DOUBLER_ENB_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_M_DOUBLER_ENB_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_M_DOUBLER_ENB_RANGE                      26:26
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_M_DOUBLER_ENB_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_M_DOUBLER_ENB_DEFAULT                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_M_DOUBLER_ENB_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_M_DOUBLER_ENB_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_M_DOUBLER_ENB_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_M_DOUBLER_ENB_INIT_ENUM                  ENABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_M_DOUBLER_ENB_DISABLE                    _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_M_DOUBLER_ENB_ENABLE                     _MK_ENUM_CONST(1)

// Enable audio sync clk doubler.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_SYNC_CLK_DOUBLER_ENB_SHIFT                   _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_SYNC_CLK_DOUBLER_ENB_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_SYNC_CLK_DOUBLER_ENB_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_SYNC_CLK_DOUBLER_ENB_RANGE                   25:25
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_SYNC_CLK_DOUBLER_ENB_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_SYNC_CLK_DOUBLER_ENB_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_SYNC_CLK_DOUBLER_ENB_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_SYNC_CLK_DOUBLER_ENB_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_SYNC_CLK_DOUBLER_ENB_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_SYNC_CLK_DOUBLER_ENB_INIT_ENUM                       ENABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_SYNC_CLK_DOUBLER_ENB_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_SYNC_CLK_DOUBLER_ENB_ENABLE                  _MK_ENUM_CONST(1)

// Enable COP cache ram clk.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CRAM2_SHIFT                  _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CRAM2_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CRAM2_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CRAM2_RANGE                  24:24
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CRAM2_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CRAM2_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CRAM2_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CRAM2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CRAM2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CRAM2_INIT_ENUM                      ENABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CRAM2_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CRAM2_ENABLE                 _MK_ENUM_CONST(1)

// Enable IRAMD clk.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMD_SHIFT                  _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMD_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMD_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMD_RANGE                  23:23
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMD_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMD_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMD_INIT_ENUM                      ENABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMD_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMD_ENABLE                 _MK_ENUM_CONST(1)

// Enable IRAMC clk.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMC_SHIFT                  _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMC_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMC_RANGE                  22:22
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMC_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMC_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMC_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMC_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMC_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMC_INIT_ENUM                      ENABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMC_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMC_ENABLE                 _MK_ENUM_CONST(1)

// Enable IRAMB clk.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMB_SHIFT                  _MK_SHIFT_CONST(21)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMB_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMB_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMB_RANGE                  21:21
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMB_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMB_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMB_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMB_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMB_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMB_INIT_ENUM                      ENABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMB_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMB_ENABLE                 _MK_ENUM_CONST(1)

// Enable IRAMB clk.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMA_SHIFT                  _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMA_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMA_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMA_RANGE                  20:20
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMA_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMA_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMA_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMA_INIT_ENUM                      ENABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMA_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_IRAMA_ENABLE                 _MK_ENUM_CONST(1)

// Enable clock to LA.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_LA_SHIFT                     _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_LA_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_LA_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_LA_RANGE                     12:12
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_LA_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_LA_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_LA_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_LA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_LA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_LA_INIT_ENUM                 DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_LA_DISABLE                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_LA_ENABLE                    _MK_ENUM_CONST(1)

// Enable clock to AVPUCQ.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AVPUCQ_SHIFT                 _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AVPUCQ_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AVPUCQ_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AVPUCQ_RANGE                 11:11
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AVPUCQ_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AVPUCQ_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AVPUCQ_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AVPUCQ_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AVPUCQ_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AVPUCQ_INIT_ENUM                     ENABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AVPUCQ_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AVPUCQ_ENABLE                        _MK_ENUM_CONST(1)

// Enable clock to Coresight.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CSITE_SHIFT                  _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CSITE_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CSITE_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CSITE_RANGE                  9:9
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CSITE_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CSITE_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CSITE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CSITE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CSITE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CSITE_INIT_ENUM                      ENABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CSITE_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_CSITE_ENABLE                 _MK_ENUM_CONST(1)

// Enable clock to AFI.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AFI_SHIFT                    _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AFI_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AFI_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AFI_RANGE                    8:8
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AFI_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AFI_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AFI_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AFI_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AFI_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AFI_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AFI_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_AFI_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to OWR.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_OWR_SHIFT                    _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_OWR_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_OWR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_OWR_RANGE                    7:7
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_OWR_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_OWR_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_OWR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_OWR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_OWR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_OWR_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_OWR_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_OWR_ENABLE                   _MK_ENUM_CONST(1)

// Enable clock to PCIE.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_PCIE_SHIFT                   _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_PCIE_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_PCIE_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_PCIE_RANGE                   6:6
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_PCIE_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_PCIE_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_PCIE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_PCIE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_PCIE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_PCIE_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_PCIE_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_PCIE_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to SDMMC3.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SDMMC3_SHIFT                 _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SDMMC3_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SDMMC3_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SDMMC3_RANGE                 5:5
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SDMMC3_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SDMMC3_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SDMMC3_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SDMMC3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SDMMC3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SDMMC3_INIT_ENUM                     DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SDMMC3_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SDMMC3_ENABLE                        _MK_ENUM_CONST(1)

// Enable clock to SBC4.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SBC4_SHIFT                   _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SBC4_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SBC4_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SBC4_RANGE                   4:4
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SBC4_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SBC4_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SBC4_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SBC4_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SBC4_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SBC4_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SBC4_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SBC4_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to I2C3.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_I2C3_SHIFT                   _MK_SHIFT_CONST(3)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_I2C3_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_I2C3_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_I2C3_RANGE                   3:3
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_I2C3_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_I2C3_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_I2C3_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_I2C3_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_I2C3_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_I2C3_INIT_ENUM                       DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_I2C3_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_I2C3_ENABLE                  _MK_ENUM_CONST(1)

// Enable clock to UARTE.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTE_SHIFT                  _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTE_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTE_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTE_RANGE                  2:2
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTE_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTE_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTE_INIT_ENUM                      DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTE_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTE_ENABLE                 _MK_ENUM_CONST(1)

// Enable clock to UARTD.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTD_SHIFT                  _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTD_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTD_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTD_RANGE                  1:1
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTD_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTD_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTD_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTD_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTD_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTD_INIT_ENUM                      DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTD_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_UARTD_ENABLE                 _MK_ENUM_CONST(1)

// Enable clock to SPEEDO.
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SPEEDO_SHIFT                 _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SPEEDO_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SPEEDO_SHIFT)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SPEEDO_RANGE                 0:0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SPEEDO_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SPEEDO_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SPEEDO_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SPEEDO_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SPEEDO_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SPEEDO_INIT_ENUM                     DISABLE
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SPEEDO_DISABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_OUT_ENB_U_0_CLK_ENB_SPEEDO_ENABLE                        _MK_ENUM_CONST(1)


// Reserved address 28 [0x1c] 

// Register CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0  
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0                  _MK_ADDR_CONST(0x20)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_RESET_VAL                        _MK_MASK_CONST(0x10000000)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_RESET_MASK                       _MK_MASK_CONST(0xff00ffff)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_READ_MASK                        _MK_MASK_CONST(0xff00ffff)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_WRITE_MASK                       _MK_MASK_CONST(0xff00ffff)
// 0000=32KHz Clock source; 
// 0001=IDLE Clock Source;
// 001X=Run clock source; 
// 01XX=IRQ Clock Source;
// 1XXX=FIQ Clock Source
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_STATE_SHIFT                  _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_STATE_FIELD                  (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_STATE_SHIFT)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_STATE_RANGE                  31:28
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_STATE_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_STATE_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_STATE_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_STATE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_STATE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_STATE_STDBY                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_STATE_IDLE                   _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_STATE_RUN                    _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_STATE_IRQ                    _MK_ENUM_CONST(4)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_STATE_FIQ                    _MK_ENUM_CONST(8)

//  0 = NOP ; 1=Burst on COP FIQ
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_FIQ_SHIFT                  _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_FIQ_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_FIQ_SHIFT)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_FIQ_RANGE                  27:27
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_FIQ_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_FIQ_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_FIQ_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_FIQ_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_FIQ_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  0 = NOP ; 1=Burst on CPU FIQ
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_FIQ_SHIFT                  _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_FIQ_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_FIQ_SHIFT)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_FIQ_RANGE                  26:26
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_FIQ_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_FIQ_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_FIQ_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_FIQ_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_FIQ_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  0 = NOP ; 1=Burst on COP IRQ
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_IRQ_SHIFT                  _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_IRQ_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_IRQ_SHIFT)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_IRQ_RANGE                  25:25
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_IRQ_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_IRQ_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_IRQ_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_IRQ_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_COP_AUTO_CWAKEUP_FROM_IRQ_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  0 = NOP ; 1=Burst on CPU IRQ
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_IRQ_SHIFT                  _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_IRQ_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_IRQ_SHIFT)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_IRQ_RANGE                  24:24
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_IRQ_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_IRQ_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_IRQ_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_IRQ_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CPU_AUTO_CWAKEUP_FROM_IRQ_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  0000 = clk_m,
//  0001 = pllC_out0,
//  0010 = clk_s,
//  0011 = pllM_out0,
//  0100 = pllP_out0,
//  0101 = pllP_out4,
//  0110 = pllP_out3,
//  0111 = clk_d,
//  1xxx = PLLX_out0,
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_SHIFT                 _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_SHIFT)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_RANGE                 15:12
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_CLKM                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_PLLC_OUT0                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_CLKS                  _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_PLLM_OUT0                     _MK_ENUM_CONST(3)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_PLLP_OUT0                     _MK_ENUM_CONST(4)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_PLLP_OUT4                     _MK_ENUM_CONST(5)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_PLLP_OUT3                     _MK_ENUM_CONST(6)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_CLKD                  _MK_ENUM_CONST(7)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_FIQ_SOURCE_PLLX_OUT0                     _MK_ENUM_CONST(8)

//  Same definitions as CWAKEUP_FIQ_SOURCE
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_SHIFT                 _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_SHIFT)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_RANGE                 11:8
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_CLKM                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_PLLC_OUT0                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_CLKS                  _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_PLLM_OUT0                     _MK_ENUM_CONST(3)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_PLLP_OUT0                     _MK_ENUM_CONST(4)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_PLLP_OUT4                     _MK_ENUM_CONST(5)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_PLLP_OUT3                     _MK_ENUM_CONST(6)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_CLKD                  _MK_ENUM_CONST(7)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IRQ_SOURCE_PLLX_OUT0                     _MK_ENUM_CONST(8)

//  Same definitions as CWAKEUP_FIQ_SOURCE
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_SHIFT                 _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_SHIFT)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_RANGE                 7:4
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_CLKM                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_PLLC_OUT0                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_CLKS                  _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_PLLM_OUT0                     _MK_ENUM_CONST(3)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_PLLP_OUT0                     _MK_ENUM_CONST(4)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_PLLP_OUT4                     _MK_ENUM_CONST(5)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_PLLP_OUT3                     _MK_ENUM_CONST(6)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_CLKD                  _MK_ENUM_CONST(7)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_RUN_SOURCE_PLLX_OUT0                     _MK_ENUM_CONST(8)

//  Same definitions as CWAKEUP_FIQ
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_SHIFT                        _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_FIELD                        (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_SHIFT)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_RANGE                        3:0
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_CLKM                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_PLLC_OUT0                    _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_CLKS                 _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_PLLM_OUT0                    _MK_ENUM_CONST(3)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_PLLP_OUT0                    _MK_ENUM_CONST(4)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_PLLP_OUT4                    _MK_ENUM_CONST(5)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_PLLP_OUT3                    _MK_ENUM_CONST(6)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_CLKD                 _MK_ENUM_CONST(7)
#define CLK_RST_CONTROLLER_CCLK_BURST_POLICY_0_CWAKEUP_IDLE_SOURCE_PLLX_OUT0                    _MK_ENUM_CONST(8)


// Register CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0  
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0                 _MK_ADDR_CONST(0x24)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SECURE                  0x0
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_WORD_COUNT                      0x1
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_RESET_MASK                      _MK_MASK_CONST(0x8f00ffff)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_READ_MASK                       _MK_MASK_CONST(0x8f00ffff)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_WRITE_MASK                      _MK_MASK_CONST(0x8f00ffff)
//  0 = disable divider.
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_ENB_SHIFT                    _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_ENB_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_ENB_SHIFT)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_ENB_RANGE                    31:31
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_ENB_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_ENB_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_ENB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_ENB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_ENB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_ENB_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_ENB_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_ENB_ENABLE                   _MK_ENUM_CONST(1)

//  0 = enable FIQ, disable FIQ.
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_FIQ_SHIFT                       _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_FIQ_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_FIQ_SHIFT)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_FIQ_RANGE                       27:27
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_FIQ_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_FIQ_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_FIQ_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_FIQ_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_FIQ_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  0 = enable FIQ, disable FIQ.
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_FIQ_SHIFT                       _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_FIQ_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_FIQ_SHIFT)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_FIQ_RANGE                       26:26
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_FIQ_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_FIQ_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_FIQ_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_FIQ_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_FIQ_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  0 = enable IRQ, disable IRQ.
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_IRQ_SHIFT                       _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_IRQ_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_IRQ_SHIFT)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_IRQ_RANGE                       25:25
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_IRQ_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_IRQ_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_IRQ_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_IRQ_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_COP_IRQ_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  0 = enable IRQ, disable IRQ.
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_IRQ_SHIFT                       _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_IRQ_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_IRQ_SHIFT)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_IRQ_RANGE                       24:24
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_IRQ_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_IRQ_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_IRQ_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_IRQ_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIS_FROM_CPU_IRQ_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Actual value = n + 1.
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVIDEND_SHIFT                       _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVIDEND_FIELD                       (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVIDEND_SHIFT)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVIDEND_RANGE                       15:8
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVIDEND_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVIDEND_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVIDEND_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVIDEND_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVIDEND_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Actual value = n + 1.
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVISOR_SHIFT                        _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVISOR_FIELD                        (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVISOR_RANGE                        7:0
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVISOR_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVISOR_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVISOR_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVISOR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_CCLK_DIVIDER_0_SUPER_CDIV_DIVISOR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0  
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0                  _MK_ADDR_CONST(0x28)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_RESET_VAL                        _MK_MASK_CONST(0x10000000)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_RESET_MASK                       _MK_MASK_CONST(0xff007777)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_READ_MASK                        _MK_MASK_CONST(0xff007777)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_WRITE_MASK                       _MK_MASK_CONST(0xff007777)
// 0000=32KHz Clock source; 
// 0001=IDLE Clock Source;
// 001X=Run clock source; 
// 01XX=IRQ Clock Source;
// 1XXX=FIQ Clock Source
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SYS_STATE_SHIFT                  _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SYS_STATE_FIELD                  (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SYS_STATE_SHIFT)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SYS_STATE_RANGE                  31:28
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SYS_STATE_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SYS_STATE_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SYS_STATE_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SYS_STATE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SYS_STATE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SYS_STATE_STDBY                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SYS_STATE_IDLE                   _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SYS_STATE_RUN                    _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SYS_STATE_IRQ                    _MK_ENUM_CONST(4)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SYS_STATE_FIQ                    _MK_ENUM_CONST(8)

//  0 = NOP ; 1=Burst on COP FIQ
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_FIQ_SHIFT                  _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_FIQ_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_FIQ_SHIFT)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_FIQ_RANGE                  27:27
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_FIQ_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_FIQ_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_FIQ_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_FIQ_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_FIQ_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  0 = NOP ; 1=Burst on CPU FIQ
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_FIQ_SHIFT                  _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_FIQ_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_FIQ_SHIFT)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_FIQ_RANGE                  26:26
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_FIQ_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_FIQ_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_FIQ_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_FIQ_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_FIQ_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  0 = NOP ; 1=Burst on COP IRQ
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_IRQ_SHIFT                  _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_IRQ_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_IRQ_SHIFT)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_IRQ_RANGE                  25:25
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_IRQ_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_IRQ_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_IRQ_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_IRQ_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_COP_AUTO_SWAKEUP_FROM_IRQ_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  0 = NOP ; 1=Burst on CPU IRQ
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_IRQ_SHIFT                  _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_IRQ_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_IRQ_SHIFT)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_IRQ_RANGE                  24:24
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_IRQ_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_IRQ_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_IRQ_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_IRQ_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_CPU_AUTO_SWAKEUP_FROM_IRQ_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  000 = clk_m,
//  001 = pllC_out1,
//  010 = pllP_out4,
//  011 = pllP_out3,
//  100 = pllP_out2,
//  101 = clk_d,
//  110 = clk_s,
//  111 = pllM_out1,
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_SHIFT                 _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_FIELD                 (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_SHIFT)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_RANGE                 14:12
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_CLKM                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_PLLC_OUT1                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_PLLP_OUT4                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_PLLP_OUT3                     _MK_ENUM_CONST(3)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_PLLP_OUT2                     _MK_ENUM_CONST(4)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_CLKD                  _MK_ENUM_CONST(5)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_CLKS                  _MK_ENUM_CONST(6)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_FIQ_SOURCE_PLLM_OUT1                     _MK_ENUM_CONST(7)

//  Same definitions as SWAKEUP_FIQ_SOURCE
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_SHIFT                 _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_FIELD                 (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_SHIFT)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_RANGE                 10:8
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_CLKM                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_PLLC_OUT1                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_PLLP_OUT4                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_PLLP_OUT3                     _MK_ENUM_CONST(3)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_PLLP_OUT2                     _MK_ENUM_CONST(4)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_CLKD                  _MK_ENUM_CONST(5)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_CLKS                  _MK_ENUM_CONST(6)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IRQ_SOURCE_PLLM_OUT1                     _MK_ENUM_CONST(7)

//  Same definitions as SWAKEUP_FIQ_SOURCE
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_SHIFT                 _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_FIELD                 (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_SHIFT)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_RANGE                 6:4
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_CLKM                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_PLLC_OUT1                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_PLLP_OUT4                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_PLLP_OUT3                     _MK_ENUM_CONST(3)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_PLLP_OUT2                     _MK_ENUM_CONST(4)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_CLKD                  _MK_ENUM_CONST(5)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_CLKS                  _MK_ENUM_CONST(6)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_RUN_SOURCE_PLLM_OUT1                     _MK_ENUM_CONST(7)

//  Same definitions as SWAKEUP_FIQ_SOURCE
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_SHIFT                        _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_FIELD                        (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_SHIFT)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_RANGE                        2:0
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_DEFAULT_MASK                 _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_CLKM                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_PLLC_OUT1                    _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_PLLP_OUT4                    _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_PLLP_OUT3                    _MK_ENUM_CONST(3)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_PLLP_OUT2                    _MK_ENUM_CONST(4)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_CLKD                 _MK_ENUM_CONST(5)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_CLKS                 _MK_ENUM_CONST(6)
#define CLK_RST_CONTROLLER_SCLK_BURST_POLICY_0_SWAKEUP_IDLE_SOURCE_PLLM_OUT1                    _MK_ENUM_CONST(7)


// Register CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0  
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0                 _MK_ADDR_CONST(0x2c)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SECURE                  0x0
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_WORD_COUNT                      0x1
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_RESET_MASK                      _MK_MASK_CONST(0x8f00ffff)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_READ_MASK                       _MK_MASK_CONST(0x8f00ffff)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_WRITE_MASK                      _MK_MASK_CONST(0x8f00ffff)
//  0 = disable divider.
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_ENB_SHIFT                    _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_ENB_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_ENB_SHIFT)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_ENB_RANGE                    31:31
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_ENB_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_ENB_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_ENB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_ENB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_ENB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_ENB_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_ENB_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_ENB_ENABLE                   _MK_ENUM_CONST(1)

//  0 = enable FIQ, disable FIQ.
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_FIQ_SHIFT                       _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_FIQ_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_FIQ_SHIFT)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_FIQ_RANGE                       27:27
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_FIQ_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_FIQ_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_FIQ_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_FIQ_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_FIQ_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  0 = enable FIQ, disable FIQ.
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_FIQ_SHIFT                       _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_FIQ_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_FIQ_SHIFT)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_FIQ_RANGE                       26:26
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_FIQ_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_FIQ_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_FIQ_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_FIQ_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_FIQ_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  0 = enable IRQ, disable IRQ.
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_IRQ_SHIFT                       _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_IRQ_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_IRQ_SHIFT)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_IRQ_RANGE                       25:25
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_IRQ_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_IRQ_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_IRQ_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_IRQ_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_COP_IRQ_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  0 = enable IRQ, disable IRQ.
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_IRQ_SHIFT                       _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_IRQ_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_IRQ_SHIFT)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_IRQ_RANGE                       24:24
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_IRQ_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_IRQ_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_IRQ_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_IRQ_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIS_FROM_CPU_IRQ_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Actual value = n + 1.
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVIDEND_SHIFT                       _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVIDEND_FIELD                       (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVIDEND_SHIFT)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVIDEND_RANGE                       15:8
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVIDEND_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVIDEND_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVIDEND_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVIDEND_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVIDEND_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Actual value = n + 1.
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVISOR_SHIFT                        _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVISOR_FIELD                        (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVISOR_RANGE                        7:0
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVISOR_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVISOR_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVISOR_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVISOR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_SUPER_SCLK_DIVIDER_0_SUPER_SDIV_DIVISOR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0  
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0                    _MK_ADDR_CONST(0x30)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_SECURE                     0x0
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_WORD_COUNT                         0x1
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_RESET_MASK                         _MK_MASK_CONST(0xbb)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_READ_MASK                  _MK_MASK_CONST(0xbb)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_WRITE_MASK                         _MK_MASK_CONST(0xbb)
//  0=enable HCLK, 1=disable HCLK.
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_HCLK_DIS_SHIFT                     _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_HCLK_DIS_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_HCLK_DIS_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_HCLK_DIS_RANGE                     7:7
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_HCLK_DIS_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_HCLK_DIS_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_HCLK_DIS_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_HCLK_DIS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_HCLK_DIS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//  1/(n+1) of SCLK.
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_AHB_RATE_SHIFT                     _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_AHB_RATE_FIELD                     (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_AHB_RATE_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_AHB_RATE_RANGE                     5:4
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_AHB_RATE_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_AHB_RATE_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_AHB_RATE_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_AHB_RATE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_AHB_RATE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//  0=enable PCLK, 1=disable PCLK.
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_PCLK_DIS_SHIFT                     _MK_SHIFT_CONST(3)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_PCLK_DIS_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_PCLK_DIS_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_PCLK_DIS_RANGE                     3:3
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_PCLK_DIS_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_PCLK_DIS_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_PCLK_DIS_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_PCLK_DIS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_PCLK_DIS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//  1/(n+1) of HCLK.
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_APB_RATE_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_APB_RATE_FIELD                     (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_APB_RATE_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_APB_RATE_RANGE                     1:0
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_APB_RATE_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_APB_RATE_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_APB_RATE_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_APB_RATE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SYSTEM_RATE_0_APB_RATE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PROG_DLY_CLK_0  
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0                       _MK_ADDR_CONST(0x34)
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_SECURE                        0x0
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_WORD_COUNT                    0x1
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_RESET_VAL                     _MK_MASK_CONST(0x7700)
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_RESET_MASK                    _MK_MASK_CONST(0xff00)
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_READ_MASK                     _MK_MASK_CONST(0xff00)
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_WRITE_MASK                    _MK_MASK_CONST(0xff00)
// 16 Taps of selectable delay for CLK_M clk doubler
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_CLK_D_DELCLK_SEL_SHIFT                        _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_CLK_D_DELCLK_SEL_FIELD                        (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PROG_DLY_CLK_0_CLK_D_DELCLK_SEL_SHIFT)
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_CLK_D_DELCLK_SEL_RANGE                        15:12
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_CLK_D_DELCLK_SEL_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_CLK_D_DELCLK_SEL_DEFAULT                      _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_CLK_D_DELCLK_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_CLK_D_DELCLK_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_CLK_D_DELCLK_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// 16 Taps of selectable delay for SYNC_CLK clk doubler
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_SYNC_CLK_DELCLK_SEL_SHIFT                     _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_SYNC_CLK_DELCLK_SEL_FIELD                     (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PROG_DLY_CLK_0_SYNC_CLK_DELCLK_SEL_SHIFT)
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_SYNC_CLK_DELCLK_SEL_RANGE                     11:8
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_SYNC_CLK_DELCLK_SEL_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_SYNC_CLK_DELCLK_SEL_DEFAULT                   _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_SYNC_CLK_DELCLK_SEL_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_SYNC_CLK_DELCLK_SEL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PROG_DLY_CLK_0_SYNC_CLK_DELCLK_SEL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0  
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0                        _MK_ADDR_CONST(0x38)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SECURE                         0x0
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_WORD_COUNT                     0x1
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_RESET_MASK                     _MK_MASK_CONST(0x1f)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_READ_MASK                      _MK_MASK_CONST(0x1f)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_WRITE_MASK                     _MK_MASK_CONST(0x1f)
//  0 = Enable AUDIO SYNC CLK
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_DIS_SHIFT                     _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_DIS_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_DIS_SHIFT)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_DIS_RANGE                     4:4
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_DIS_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_DIS_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_DIS_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_DIS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_DIS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// 0000 = SPDIFIN recovered bit clock.
// 0001 = I2S1 bit clock.
// 0010 = I2S2 bit clock.
// 0011 = AC97 bit clock.
// 0100 = pllA_out0.
// 0101 = external audio clock (dap_mclk2).
// 0110 = external audio clock (dap_mclk1).
// 0111 = external vimclk (vimclk).
// 1xxx = reserved
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_SHIFT                    _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_FIELD                    (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_SHIFT)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_RANGE                    3:0
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_SPDIFIN                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_I2S1                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_I2S2                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_AC97                     _MK_ENUM_CONST(3)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_PLLA_OUT0                        _MK_ENUM_CONST(4)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_EXT_AUDIO_CLK2                   _MK_ENUM_CONST(5)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_EXT_AUDIO_CLK1                   _MK_ENUM_CONST(6)
#define CLK_RST_CONTROLLER_AUDIO_SYNC_CLK_RATE_0_SYNC_CLK_RATE_EXT_VIMCLK                       _MK_ENUM_CONST(7)


// Reserved address 60 [0x3c] 

// Register CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0  
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0                        _MK_ADDR_CONST(0x40)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_SECURE                         0x0
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_WORD_COUNT                     0x1
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_RESET_MASK                     _MK_MASK_CONST(0xff007777)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_READ_MASK                      _MK_MASK_CONST(0xff007777)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_WRITE_MASK                     _MK_MASK_CONST(0xff007777)
// 0000=no skip.
// 0001=skip base on IDLE Clock skip rate;
// 001X=skip base on Run clock skip rate; 
// 01XX=skip base on IRQ Clock skip rate;
// 1XXX=skip base on FIQ Clock skip rate
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_STATE_SHIFT                       _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_STATE_FIELD                       (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_STATE_SHIFT)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_STATE_RANGE                       31:28
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_STATE_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_STATE_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_STATE_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_STATE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_STATE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  0 = NOP ; 1=Burst on COP FIQ
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_FIQ_SHIFT                    _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_FIQ_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_FIQ_SHIFT)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_FIQ_RANGE                    27:27
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_FIQ_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_FIQ_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_FIQ_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_FIQ_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_FIQ_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//  0 = NOP ; 1=Burst on CPU FIQ
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_FIQ_SHIFT                    _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_FIQ_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_FIQ_SHIFT)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_FIQ_RANGE                    26:26
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_FIQ_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_FIQ_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_FIQ_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_FIQ_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_FIQ_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//  0 = NOP ; 1=Burst on COP IRQ
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_IRQ_SHIFT                    _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_IRQ_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_IRQ_SHIFT)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_IRQ_RANGE                    25:25
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_IRQ_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_IRQ_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_IRQ_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_IRQ_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_COP_IRQ_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//  0 = NOP ; 1=Burst on CPU IRQ
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_IRQ_SHIFT                    _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_IRQ_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_IRQ_SHIFT)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_IRQ_RANGE                    24:24
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_IRQ_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_IRQ_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_IRQ_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_IRQ_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_ENB_FROM_CPU_IRQ_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//  skip n/16 clock.
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_FIQ_SHIFT                    _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_FIQ_FIELD                    (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_FIQ_SHIFT)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_FIQ_RANGE                    14:12
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_FIQ_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_FIQ_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_FIQ_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_FIQ_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_FIQ_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//  Same definitions as COP_CLK_SKIP_RATE_FIQ
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IRQ_SHIFT                    _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IRQ_FIELD                    (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IRQ_SHIFT)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IRQ_RANGE                    10:8
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IRQ_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IRQ_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IRQ_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IRQ_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IRQ_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//  Same definitions as COP_CLK_SKIP_RATE_FIQ
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_RUN_SHIFT                    _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_RUN_FIELD                    (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_RUN_SHIFT)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_RUN_RANGE                    6:4
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_RUN_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_RUN_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_RUN_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_RUN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_RUN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//  Same definitions as COP_CLK_SKIP_RATE_FIQ
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IDLE_SHIFT                   _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IDLE_FIELD                   (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IDLE_SHIFT)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IDLE_RANGE                   2:0
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IDLE_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IDLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IDLE_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IDLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_COP_CLK_SKIP_POLICY_0_COP_CLK_SKIP_RATE_IDLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_MASK_ARM_0  
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0                       _MK_ADDR_CONST(0x44)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_SECURE                        0x0
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_WORD_COUNT                    0x1
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_RESET_MASK                    _MK_MASK_CONST(0x80030003)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_READ_MASK                     _MK_MASK_CONST(0x80030003)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_WRITE_MASK                    _MK_MASK_CONST(0x30003)
//  1 = ARM11 AXI pipe is flushed.
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_AXI_FLUSH_DONE_SHIFT                  _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_AXI_FLUSH_DONE_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_MASK_ARM_0_AXI_FLUSH_DONE_SHIFT)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_AXI_FLUSH_DONE_RANGE                  31:31
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_AXI_FLUSH_DONE_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_AXI_FLUSH_DONE_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_AXI_FLUSH_DONE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_AXI_FLUSH_DONE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_AXI_FLUSH_DONE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  1 = reset CPU0 when flow control assert halt.
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_RST_CPU0_WHEN_HALT_SHIFT                      _MK_SHIFT_CONST(17)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_RST_CPU0_WHEN_HALT_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_MASK_ARM_0_RST_CPU0_WHEN_HALT_SHIFT)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_RST_CPU0_WHEN_HALT_RANGE                      17:17
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_RST_CPU0_WHEN_HALT_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_RST_CPU0_WHEN_HALT_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_RST_CPU0_WHEN_HALT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_RST_CPU0_WHEN_HALT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_RST_CPU0_WHEN_HALT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  1 = HW will stop clock to CPU when halt, 0 = no clock stop.
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_CPU_HALT_SHIFT                       _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_CPU_HALT_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_CPU_HALT_SHIFT)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_CPU_HALT_RANGE                       16:16
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_CPU_HALT_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_CPU_HALT_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_CPU_HALT_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_CPU_HALT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_CPU_HALT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  00 = no clock masking.
//  01 = u2_nwait_r.
//  10 = u2_nwait_r.
//  11 = no clock masking.
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_COP_SHIFT                    _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_COP_FIELD                    (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_COP_SHIFT)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_COP_RANGE                    1:0
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_COP_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_COP_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_COP_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_COP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_MASK_ARM_0_CLK_MASK_COP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_MISC_CLK_ENB_0  
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0                       _MK_ADDR_CONST(0x48)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_SECURE                        0x0
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_WORD_COUNT                    0x1
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_RESET_MASK                    _MK_MASK_CONST(0x10f00000)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_READ_MASK                     _MK_MASK_CONST(0x10f00000)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_WRITE_MASK                    _MK_MASK_CONST(0x10f00000)
// 1 = VISIBLE, 0 = NOT VISIBLE.
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_CFG_ALL_VISIBLE_SHIFT                 _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_CFG_ALL_VISIBLE_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_MISC_CLK_ENB_0_CFG_ALL_VISIBLE_SHIFT)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_CFG_ALL_VISIBLE_RANGE                 28:28
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_CFG_ALL_VISIBLE_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_CFG_ALL_VISIBLE_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_CFG_ALL_VISIBLE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_CFG_ALL_VISIBLE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_CFG_ALL_VISIBLE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// 00 = osc, 01 = osc/2, 10 = osc/4, 11 = osc/8.
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV1_OSC_DIV_SEL_SHIFT                        _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV1_OSC_DIV_SEL_FIELD                        (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV1_OSC_DIV_SEL_SHIFT)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV1_OSC_DIV_SEL_RANGE                        23:22
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV1_OSC_DIV_SEL_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV1_OSC_DIV_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV1_OSC_DIV_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV1_OSC_DIV_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV1_OSC_DIV_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// 00 = osc, 01 = osc/2, 10 = osc/4, 11 = osc/8.
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV2_OSC_DIV_SEL_SHIFT                        _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV2_OSC_DIV_SEL_FIELD                        (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV2_OSC_DIV_SEL_SHIFT)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV2_OSC_DIV_SEL_RANGE                        21:20
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV2_OSC_DIV_SEL_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV2_OSC_DIV_SEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV2_OSC_DIV_SEL_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV2_OSC_DIV_SEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_MISC_CLK_ENB_0_DEV2_OSC_DIV_SEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0  
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0                      _MK_ADDR_CONST(0x4c)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_RESET_VAL                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_RESET_MASK                   _MK_MASK_CONST(0x303)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_READ_MASK                    _MK_MASK_CONST(0x303)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_WRITE_MASK                   _MK_MASK_CONST(0x303)
// Clock divider ratio for the cpu bridge devices
// connected to CPU/L2-cache.
//   00 = div-by-1.
//   01 = div-by-2.
//   10 = div-by-3.
//   11 = div-by-4.
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU_BRIDGE_CLKDIV_SHIFT                      _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU_BRIDGE_CLKDIV_FIELD                      (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU_BRIDGE_CLKDIV_SHIFT)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU_BRIDGE_CLKDIV_RANGE                      1:0
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU_BRIDGE_CLKDIV_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU_BRIDGE_CLKDIV_DEFAULT                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU_BRIDGE_CLKDIV_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU_BRIDGE_CLKDIV_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU_BRIDGE_CLKDIV_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// 1 = CPU0 clock stop, 0 = CPU0 clock run.
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU0_CLK_STP_SHIFT                   _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU0_CLK_STP_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU0_CLK_STP_SHIFT)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU0_CLK_STP_RANGE                   8:8
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU0_CLK_STP_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU0_CLK_STP_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU0_CLK_STP_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU0_CLK_STP_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU0_CLK_STP_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// 1 = CPU1 clock stop, 0 = CPU1 clock run.
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU1_CLK_STP_SHIFT                   _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU1_CLK_STP_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU1_CLK_STP_SHIFT)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU1_CLK_STP_RANGE                   9:9
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU1_CLK_STP_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU1_CLK_STP_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU1_CLK_STP_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU1_CLK_STP_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_CPU_CMPLX_0_CPU1_CLK_STP_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_OSC_CTRL_0  
#define CLK_RST_CONTROLLER_OSC_CTRL_0                   _MK_ADDR_CONST(0x50)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_SECURE                    0x0
#define CLK_RST_CONTROLLER_OSC_CTRL_0_WORD_COUNT                        0x1
#define CLK_RST_CONTROLLER_OSC_CTRL_0_RESET_VAL                         _MK_MASK_CONST(0x3f1)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_RESET_MASK                        _MK_MASK_CONST(0xfff1f3f3)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_READ_MASK                         _MK_MASK_CONST(0xfff1f3f3)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_WRITE_MASK                        _MK_MASK_CONST(0xfff1f3f3)
// 00 = 13MHz, 01 = 19.2MHz, 10 = 12MHz, 11 = 26MHz.
#define CLK_RST_CONTROLLER_OSC_CTRL_0_OSC_FREQ_SHIFT                    _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_OSC_FREQ_FIELD                    (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_OSC_CTRL_0_OSC_FREQ_SHIFT)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_OSC_FREQ_RANGE                    31:30
#define CLK_RST_CONTROLLER_OSC_CTRL_0_OSC_FREQ_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_OSC_CTRL_0_OSC_FREQ_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_OSC_FREQ_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_OSC_FREQ_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_OSC_FREQ_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// PLL reference clock divide.  00 = /1, 01 = /2, 10 = /4, 11 = reserve.
#define CLK_RST_CONTROLLER_OSC_CTRL_0_PLL_REF_DIV_SHIFT                 _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_PLL_REF_DIV_FIELD                 (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_OSC_CTRL_0_PLL_REF_DIV_SHIFT)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_PLL_REF_DIV_RANGE                 29:28
#define CLK_RST_CONTROLLER_OSC_CTRL_0_PLL_REF_DIV_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_OSC_CTRL_0_PLL_REF_DIV_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_PLL_REF_DIV_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_PLL_REF_DIV_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_PLL_REF_DIV_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Crystal oscillator spare register control.
#define CLK_RST_CONTROLLER_OSC_CTRL_0_OSCFI_SPARE_SHIFT                 _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_OSCFI_SPARE_FIELD                 (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_OSC_CTRL_0_OSCFI_SPARE_SHIFT)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_OSCFI_SPARE_RANGE                 27:20
#define CLK_RST_CONTROLLER_OSC_CTRL_0_OSCFI_SPARE_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_OSC_CTRL_0_OSCFI_SPARE_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_OSCFI_SPARE_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_OSCFI_SPARE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_OSCFI_SPARE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Crystal oscillator duty cycle control.
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XODS_SHIFT                        _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XODS_FIELD                        (_MK_MASK_CONST(0x1f) << CLK_RST_CONTROLLER_OSC_CTRL_0_XODS_SHIFT)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XODS_RANGE                        16:12
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XODS_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XODS_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XODS_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XODS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XODS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Crystal oscillator drive strength control.
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOFS_SHIFT                        _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOFS_FIELD                        (_MK_MASK_CONST(0x3f) << CLK_RST_CONTROLLER_OSC_CTRL_0_XOFS_SHIFT)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOFS_RANGE                        9:4
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOFS_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOFS_DEFAULT                      _MK_MASK_CONST(0x3f)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOFS_DEFAULT_MASK                 _MK_MASK_CONST(0x3f)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOFS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOFS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Crystal oscillator bypass enable (1 = enable bypass).
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOBP_SHIFT                        _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOBP_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_OSC_CTRL_0_XOBP_SHIFT)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOBP_RANGE                        1:1
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOBP_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOBP_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOBP_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOBP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOBP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Crystal oscillator enable (1 = enable).
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOE_SHIFT                 _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOE_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_OSC_CTRL_0_XOE_SHIFT)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOE_RANGE                 0:0
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOE_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOE_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_CTRL_0_XOE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLL_LFSR_0  
#define CLK_RST_CONTROLLER_PLL_LFSR_0                   _MK_ADDR_CONST(0x54)
#define CLK_RST_CONTROLLER_PLL_LFSR_0_SECURE                    0x0
#define CLK_RST_CONTROLLER_PLL_LFSR_0_WORD_COUNT                        0x1
#define CLK_RST_CONTROLLER_PLL_LFSR_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLL_LFSR_0_RESET_MASK                        _MK_MASK_CONST(0xffff)
#define CLK_RST_CONTROLLER_PLL_LFSR_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLL_LFSR_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLL_LFSR_0_READ_MASK                         _MK_MASK_CONST(0xffff)
#define CLK_RST_CONTROLLER_PLL_LFSR_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
// Random number generated from PLL linear feedback shift register.
#define CLK_RST_CONTROLLER_PLL_LFSR_0_RND_SHIFT                 _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLL_LFSR_0_RND_FIELD                 (_MK_MASK_CONST(0xffff) << CLK_RST_CONTROLLER_PLL_LFSR_0_RND_SHIFT)
#define CLK_RST_CONTROLLER_PLL_LFSR_0_RND_RANGE                 15:0
#define CLK_RST_CONTROLLER_PLL_LFSR_0_RND_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLL_LFSR_0_RND_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLL_LFSR_0_RND_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define CLK_RST_CONTROLLER_PLL_LFSR_0_RND_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLL_LFSR_0_RND_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_OSC_FREQ_DET_0  
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0                       _MK_ADDR_CONST(0x58)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_SECURE                        0x0
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_WORD_COUNT                    0x1
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_RESET_MASK                    _MK_MASK_CONST(0x8000000f)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_READ_MASK                     _MK_MASK_CONST(0x8000000f)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_WRITE_MASK                    _MK_MASK_CONST(0x8000000f)
// 0 = default, 1 = enable osc frequency detect. 
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_OSC_FREQ_DET_TRIG_SHIFT                       _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_OSC_FREQ_DET_TRIG_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_OSC_FREQ_DET_0_OSC_FREQ_DET_TRIG_SHIFT)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_OSC_FREQ_DET_TRIG_RANGE                       31:31
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_OSC_FREQ_DET_TRIG_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_OSC_FREQ_DET_TRIG_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_OSC_FREQ_DET_TRIG_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_OSC_FREQ_DET_TRIG_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_OSC_FREQ_DET_TRIG_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_OSC_FREQ_DET_TRIG_INIT_ENUM                   DISABLE
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_OSC_FREQ_DET_TRIG_DISABLE                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_OSC_FREQ_DET_TRIG_ENABLE                      _MK_ENUM_CONST(1)

// Indicate the # of 32KHz clock period as window in n+1 scheme.
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_REF_CLK_WIN_CFG_SHIFT                 _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_REF_CLK_WIN_CFG_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_OSC_FREQ_DET_0_REF_CLK_WIN_CFG_SHIFT)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_REF_CLK_WIN_CFG_RANGE                 3:0
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_REF_CLK_WIN_CFG_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_REF_CLK_WIN_CFG_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_REF_CLK_WIN_CFG_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_REF_CLK_WIN_CFG_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_0_REF_CLK_WIN_CFG_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0  
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0                        _MK_ADDR_CONST(0x5c)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_SECURE                         0x0
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_WORD_COUNT                     0x1
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_RESET_MASK                     _MK_MASK_CONST(0x8000ffff)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_READ_MASK                      _MK_MASK_CONST(0x8000ffff)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
// 0 = not busy, 1 = busy.
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_BUSY_SHIFT                        _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_BUSY_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_BUSY_SHIFT)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_BUSY_RANGE                        31:31
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_BUSY_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_BUSY_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_BUSY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_BUSY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_BUSY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// indicate the number of osc count within the 32KHz clock reference window.
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_CNT_SHIFT                 _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_CNT_FIELD                 (_MK_MASK_CONST(0xffff) << CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_CNT_SHIFT)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_CNT_RANGE                 15:0
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_CNT_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_CNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_CNT_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_CNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_OSC_FREQ_DET_STATUS_0_OSC_FREQ_DET_CNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0  
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0                   _MK_ADDR_CONST(0x60)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_SECURE                    0x0
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_WORD_COUNT                        0x1
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_RESET_MASK                        _MK_MASK_CONST(0x3ff)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_READ_MASK                         _MK_MASK_CONST(0x3ff)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_WRITE_MASK                        _MK_MASK_CONST(0x3ff)
// PTO counter reset.
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_RST_SHIFT                 _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_RST_SHIFT)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_RST_RANGE                 9:9
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_RST_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// enable PTO counter.
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_EN_SHIFT                  _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_EN_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_EN_SHIFT)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_EN_RANGE                  8:8
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_EN_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_CNT_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// PLL PTO source select.
// 0000 = PLLX PTO div-2.
// 0001 = PLLC PTO div-2.
// 0010 = PLLM PTO div-2.
// 0011 = PLLP PTO div-2.
// 0100 = PLLA PTO div-2.
// 0101 = PLLU PTO div-2.
// 0110 = PLLD PTO div-2.
// 0111 = PLLE PTO div-2.
// 1000 = PLLS PTO div-2.
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_SRC_SEL_SHIFT                 _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_SRC_SEL_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_SRC_SEL_SHIFT)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_SRC_SEL_RANGE                 7:4
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_SRC_SEL_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_SRC_SEL_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_SRC_SEL_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_SRC_SEL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_SRC_SEL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Indicate the # of 32KHz clock period as window in n+1 scheme.
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_REF_CLK_WIN_CFG_SHIFT                 _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_REF_CLK_WIN_CFG_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_REF_CLK_WIN_CFG_SHIFT)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_REF_CLK_WIN_CFG_RANGE                 3:0
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_REF_CLK_WIN_CFG_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_REF_CLK_WIN_CFG_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_REF_CLK_WIN_CFG_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_REF_CLK_WIN_CFG_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_CNTL_0_PTO_REF_CLK_WIN_CFG_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0  
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0                 _MK_ADDR_CONST(0x64)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_SECURE                  0x0
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_WORD_COUNT                      0x1
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_RESET_MASK                      _MK_MASK_CONST(0x8000ffff)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_READ_MASK                       _MK_MASK_CONST(0x8000ffff)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
// 0 = not busy, 1 = busy.
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_BUSY_SHIFT                  _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_BUSY_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_BUSY_SHIFT)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_BUSY_RANGE                  31:31
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_BUSY_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_BUSY_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_BUSY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_BUSY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_BUSY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// indicate the number of PTO clock count within the 32KHz clock reference window.
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_SHIFT                       _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_FIELD                       (_MK_MASK_CONST(0xffff) << CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_SHIFT)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_RANGE                       15:0
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_DEFAULT_MASK                        _MK_MASK_CONST(0xffff)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PTO_CLK_CNT_STATUS_0_PTO_CLK_CNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLLE_SS_CNTL_0  
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0                       _MK_ADDR_CONST(0x68)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_SECURE                        0x0
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_WORD_COUNT                    0x1
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_RESET_VAL                     _MK_MASK_CONST(0x5e00)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
// interpolator bias current. 
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTEGOFFSET_SHIFT                        _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTEGOFFSET_FIELD                        (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTEGOFFSET_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTEGOFFSET_RANGE                        31:30
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTEGOFFSET_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTEGOFFSET_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTEGOFFSET_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTEGOFFSET_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTEGOFFSET_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Triangle generator increment interval control.
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINCINTRV_SHIFT                        _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINCINTRV_FIELD                        (_MK_MASK_CONST(0x3f) << CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINCINTRV_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINCINTRV_RANGE                        29:24
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINCINTRV_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINCINTRV_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINCINTRV_DEFAULT_MASK                 _MK_MASK_CONST(0x3f)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINCINTRV_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINCINTRV_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Triangle generator increment control.
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINC_SHIFT                     _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINC_FIELD                     (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINC_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINC_RANGE                     23:16
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINC_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINC_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINC_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINC_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINC_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// 0 gives down spread, 1 gives up-spread.
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINVERT_SHIFT                  _MK_SHIFT_CONST(15)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINVERT_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINVERT_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINVERT_RANGE                  15:15
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINVERT_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINVERT_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINVERT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINVERT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCINVERT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// 0 gives control to SSCINVERT, 1 enables center spread.
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCCENTER_SHIFT                  _MK_SHIFT_CONST(14)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCCENTER_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCCENTER_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCCENTER_RANGE                  14:14
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCCENTER_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCCENTER_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCCENTER_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCCENTER_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCCENTER_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Bypass from pulse density modulator. Normally set to zero.
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCPDMBYP_SHIFT                  _MK_SHIFT_CONST(13)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCPDMBYP_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCPDMBYP_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCPDMBYP_RANGE                  13:13
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCPDMBYP_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCPDMBYP_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCPDMBYP_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCPDMBYP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCPDMBYP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// 0 enables spreading, 1 disables spreading.
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCBYP_SHIFT                     _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCBYP_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCBYP_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCBYP_RANGE                     12:12
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCBYP_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCBYP_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCBYP_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCBYP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCBYP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Interpolator reset. 0=normal operation  1=resets SS machine.
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTERP_RESET_SHIFT                       _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTERP_RESET_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTERP_RESET_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTERP_RESET_RANGE                       11:11
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTERP_RESET_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTERP_RESET_DEFAULT                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTERP_RESET_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTERP_RESET_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_INTERP_RESET_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// When set feedback clock bypasses interpolator. Default value is zero.
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_BYPASS_SS_SHIFT                  _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_BYPASS_SS_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_BYPASS_SS_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_BYPASS_SS_RANGE                  10:10
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_BYPASS_SS_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_BYPASS_SS_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_BYPASS_SS_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_BYPASS_SS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_BYPASS_SS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Enables reference current for external devices like PLL_DIFFCLKBUF_CML.
// Overrides IDDQ and ENABLE for bandgap.
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_EN_IREF_SHIFT                    _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_EN_IREF_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_EN_IREF_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_EN_IREF_RANGE                    9:9
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_EN_IREF_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_EN_IREF_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_EN_IREF_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_EN_IREF_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_EN_IREF_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Spread limit control.
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCMAX_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCMAX_FIELD                     (_MK_MASK_CONST(0x1ff) << CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCMAX_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCMAX_RANGE                     8:0
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCMAX_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCMAX_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCMAX_DEFAULT_MASK                      _MK_MASK_CONST(0x1ff)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCMAX_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_SS_CNTL_0_PLLE_SSCMAX_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Reserved address 108 [0x6c] 

// Register CLK_RST_CONTROLLER_BOND_OUT_L_0  
#define CLK_RST_CONTROLLER_BOND_OUT_L_0                 _MK_ADDR_CONST(0x70)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_SECURE                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_WORD_COUNT                      0x1
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_RESET_MASK                      _MK_MASK_CONST(0xbffffff9)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_READ_MASK                       _MK_MASK_CONST(0xbffffff9)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_WRITE_MASK                      _MK_MASK_CONST(0xbffffff9)
// Bond out COP cache controller.
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CACHE2_SHIFT                   _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CACHE2_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CACHE2_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CACHE2_RANGE                   31:31
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CACHE2_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CACHE2_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CACHE2_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CACHE2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CACHE2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Bond out vector co-processor.
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VCP_SHIFT                      _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VCP_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VCP_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VCP_RANGE                      29:29
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VCP_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VCP_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VCP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VCP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VCP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out HOST1X.
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_HOST1X_SHIFT                   _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_HOST1X_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_HOST1X_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_HOST1X_RANGE                   28:28
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_HOST1X_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_HOST1X_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_HOST1X_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_HOST1X_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_HOST1X_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Bond out DISP1 controller.
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP1_SHIFT                    _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP1_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP1_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP1_RANGE                    27:27
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP1_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP1_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out DISP2 controller.
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP2_SHIFT                    _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP2_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP2_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP2_RANGE                    26:26
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP2_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP2_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_DISP2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out IDE controller
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_IDE_SHIFT                      _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_IDE_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_IDE_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_IDE_RANGE                      25:25
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_IDE_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_IDE_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_IDE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_IDE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_IDE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out 3D controller.
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_3D_SHIFT                       _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_3D_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_3D_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_3D_RANGE                       24:24
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_3D_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_3D_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_3D_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_3D_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_3D_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Bond out ISP controller.
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_ISP_SHIFT                      _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_ISP_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_ISP_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_ISP_RANGE                      23:23
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_ISP_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_ISP_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_ISP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_ISP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_ISP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out USB controller
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_USBD_SHIFT                     _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_USBD_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_USBD_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_USBD_RANGE                     22:22
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_USBD_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_USBD_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_USBD_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_USBD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_USBD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out 2D graphics engine.
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_2D_SHIFT                       _MK_SHIFT_CONST(21)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_2D_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_2D_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_2D_RANGE                       21:21
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_2D_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_2D_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_2D_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_2D_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_2D_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Bond out VI controller.
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VI_SHIFT                       _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VI_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VI_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VI_RANGE                       20:20
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VI_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VI_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VI_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VI_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_VI_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Bond out EPP controller.
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_EPP_SHIFT                      _MK_SHIFT_CONST(19)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_EPP_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_EPP_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_EPP_RANGE                      19:19
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_EPP_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_EPP_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_EPP_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_EPP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_EPP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out I2S 2 controller
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S2_SHIFT                     _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S2_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S2_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S2_RANGE                     18:18
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S2_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S2_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out PWM (Pulse Width Modulator)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_PWM_SHIFT                      _MK_SHIFT_CONST(17)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_PWM_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_PWM_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_PWM_RANGE                      17:17
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_PWM_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_PWM_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_PWM_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_PWM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_PWM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out 3-Wire Interface Controller
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TWC_SHIFT                      _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TWC_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TWC_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TWC_RANGE                      16:16
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TWC_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TWC_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TWC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TWC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TWC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out SDMMC4 controller.
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC4_SHIFT                   _MK_SHIFT_CONST(15)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC4_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC4_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC4_RANGE                   15:15
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC4_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC4_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC4_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC4_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC4_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Bond out SDMMC1 controller.
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC1_SHIFT                   _MK_SHIFT_CONST(14)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC1_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC1_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC1_RANGE                   14:14
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC1_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC1_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC1_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Bond out NAND flash controller.
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_NDFLASH_SHIFT                  _MK_SHIFT_CONST(13)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_NDFLASH_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_NDFLASH_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_NDFLASH_RANGE                  13:13
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_NDFLASH_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_NDFLASH_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_NDFLASH_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_NDFLASH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_NDFLASH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Bond out I2C1 Controller
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2C1_SHIFT                     _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2C1_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2C1_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2C1_RANGE                     12:12
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2C1_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2C1_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2C1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2C1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2C1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out I2S1 Controller
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S1_SHIFT                     _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S1_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S1_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S1_RANGE                     11:11
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S1_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S1_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_I2S1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out SPDIF Controller
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SPDIF_SHIFT                    _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SPDIF_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SPDIF_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SPDIF_RANGE                    10:10
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SPDIF_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SPDIF_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SPDIF_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SPDIF_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SPDIF_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out SDMMC2 controller.
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC2_SHIFT                   _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC2_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC2_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC2_RANGE                   9:9
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC2_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC2_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC2_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_SDMMC2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Bond out GPIO Controller
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_GPIO_SHIFT                     _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_GPIO_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_GPIO_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_GPIO_RANGE                     8:8
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_GPIO_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_GPIO_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_GPIO_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_GPIO_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_GPIO_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out UARTB/VFIR Controller
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTB_SHIFT                    _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTB_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTB_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTB_RANGE                    7:7
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTB_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTB_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out UARTA Controller
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTA_SHIFT                    _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTA_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTA_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTA_RANGE                    6:6
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTA_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTA_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTA_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_UARTA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out Timer Controller
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TMR_SHIFT                      _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TMR_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TMR_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TMR_RANGE                      5:5
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TMR_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TMR_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TMR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TMR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_TMR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out RTC Controller
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_RTC_SHIFT                      _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_RTC_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_RTC_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_RTC_RANGE                      4:4
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_RTC_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_RTC_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_RTC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_RTC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_RTC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out AC97 Controller
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_AC97_SHIFT                     _MK_SHIFT_CONST(3)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_AC97_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_AC97_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_AC97_RANGE                     3:3
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_AC97_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_AC97_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_AC97_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_AC97_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_AC97_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out CPU.
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CPU_SHIFT                      _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CPU_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CPU_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CPU_RANGE                      0:0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CPU_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CPU_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CPU_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CPU_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_L_0_BOND_OUT_CPU_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_BOND_OUT_H_0  
#define CLK_RST_CONTROLLER_BOND_OUT_H_0                 _MK_ADDR_CONST(0x74)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_SECURE                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_WORD_COUNT                      0x1
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_RESET_MASK                      _MK_MASK_CONST(0xfefffff7)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_READ_MASK                       _MK_MASK_CONST(0xfefffff7)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_WRITE_MASK                      _MK_MASK_CONST(0xfefffff7)
// Bond out BSEV Controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEV_SHIFT                     _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEV_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEV_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEV_RANGE                     31:31
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEV_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEV_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEV_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEV_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEV_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out BSEA Controller
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEA_SHIFT                     _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEA_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEA_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEA_RANGE                     30:30
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEA_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEA_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEA_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEA_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_BSEA_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out VDE Controller
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_VDE_SHIFT                      _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_VDE_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_VDE_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_VDE_RANGE                      29:29
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_VDE_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_VDE_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_VDE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_VDE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_VDE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out MPE controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MPE_SHIFT                      _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MPE_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MPE_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MPE_RANGE                      28:28
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MPE_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MPE_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MPE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MPE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MPE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out USB3 controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB3_SHIFT                     _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB3_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB3_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB3_RANGE                     27:27
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB3_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB3_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB3_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out USB2 controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB2_SHIFT                     _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB2_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB2_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB2_RANGE                     26:26
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB2_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB2_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_USB2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out EMC controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_EMC_SHIFT                      _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_EMC_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_EMC_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_EMC_RANGE                      25:25
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_EMC_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_EMC_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_EMC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_EMC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_EMC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out UART-C Controller
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_UARTC_SHIFT                    _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_UARTC_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_UARTC_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_UARTC_RANGE                    23:23
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_UARTC_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_UARTC_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_UARTC_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_UARTC_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_UARTC_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out I2C2 controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_I2C2_SHIFT                     _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_I2C2_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_I2C2_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_I2C2_RANGE                     22:22
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_I2C2_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_I2C2_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_I2C2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_I2C2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_I2C2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out TVDAC controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVDAC_SHIFT                    _MK_SHIFT_CONST(21)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVDAC_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVDAC_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVDAC_RANGE                    21:21
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVDAC_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVDAC_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVDAC_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVDAC_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVDAC_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out CSI controller
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_CSI_SHIFT                      _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_CSI_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_CSI_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_CSI_RANGE                      20:20
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_CSI_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_CSI_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_CSI_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_CSI_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_CSI_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out HDMI
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_HDMI_SHIFT                     _MK_SHIFT_CONST(19)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_HDMI_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_HDMI_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_HDMI_RANGE                     19:19
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_HDMI_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_HDMI_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_HDMI_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_HDMI_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_HDMI_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out MIPI base-band controller
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MIPI_SHIFT                     _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MIPI_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MIPI_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MIPI_RANGE                     18:18
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MIPI_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MIPI_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MIPI_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MIPI_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MIPI_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out TVO/CVE controller
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVO_SHIFT                      _MK_SHIFT_CONST(17)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVO_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVO_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVO_RANGE                      17:17
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVO_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVO_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVO_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVO_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_TVO_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out DSI controller
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DSI_SHIFT                      _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DSI_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DSI_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DSI_RANGE                      16:16
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DSI_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DSI_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DSI_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DSI_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DSI_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out DVC-I2C Controller
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DVC_I2C_SHIFT                  _MK_SHIFT_CONST(15)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DVC_I2C_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DVC_I2C_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DVC_I2C_RANGE                  15:15
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DVC_I2C_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DVC_I2C_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DVC_I2C_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DVC_I2C_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_DVC_I2C_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Bond out SBC 3 Controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC3_SHIFT                     _MK_SHIFT_CONST(14)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC3_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC3_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC3_RANGE                     14:14
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC3_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC3_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC3_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out XIO Controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_XIO_SHIFT                      _MK_SHIFT_CONST(13)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_XIO_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_XIO_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_XIO_RANGE                      13:13
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_XIO_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_XIO_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_XIO_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_XIO_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_XIO_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out SBC 2 Controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC2_SHIFT                     _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC2_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC2_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC2_RANGE                     12:12
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC2_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC2_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out SPI 1 Controller
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SPI1_SHIFT                     _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SPI1_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SPI1_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SPI1_RANGE                     11:11
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SPI1_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SPI1_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SPI1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SPI1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SPI1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out NOR Flash Controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_NOR_SHIFT                      _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_NOR_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_NOR_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_NOR_RANGE                      10:10
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_NOR_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_NOR_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_NOR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_NOR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_NOR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out NOR Flash Controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SNOR_SHIFT                     _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SNOR_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SNOR_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SNOR_RANGE                     10:10
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SNOR_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SNOR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SNOR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SNOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SNOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out SBC 1 Controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC1_SHIFT                     _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC1_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC1_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC1_RANGE                     9:9
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC1_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC1_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_SBC1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out KFUSE controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KFUSE_SHIFT                    _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KFUSE_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KFUSE_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KFUSE_RANGE                    8:8
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KFUSE_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KFUSE_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KFUSE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KFUSE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KFUSE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out FUSE controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_FUSE_SHIFT                     _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_FUSE_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_FUSE_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_FUSE_RANGE                     7:7
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_FUSE_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_FUSE_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_FUSE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_FUSE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_FUSE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out PMC controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_PMC_SHIFT                      _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_PMC_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_PMC_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_PMC_RANGE                      6:6
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_PMC_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_PMC_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_PMC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_PMC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_PMC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out statistic monitor.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_STAT_MON_SHIFT                 _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_STAT_MON_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_STAT_MON_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_STAT_MON_RANGE                 5:5
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_STAT_MON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_STAT_MON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_STAT_MON_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_STAT_MON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_STAT_MON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Bond out keyboard controller.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KBC_SHIFT                      _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KBC_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KBC_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KBC_RANGE                      4:4
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KBC_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KBC_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KBC_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KBC_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_KBC_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out APB-DMA.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_APBDMA_SHIFT                   _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_APBDMA_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_APBDMA_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_APBDMA_RANGE                   2:2
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_APBDMA_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_APBDMA_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_APBDMA_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_APBDMA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_APBDMA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Bond out AHB-DMA.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_AHBDMA_SHIFT                   _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_AHBDMA_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_AHBDMA_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_AHBDMA_RANGE                   1:1
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_AHBDMA_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_AHBDMA_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_AHBDMA_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_AHBDMA_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_AHBDMA_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Bond out MC/EMC.
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MEM_SHIFT                      _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MEM_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MEM_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MEM_RANGE                      0:0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MEM_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MEM_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MEM_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MEM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_H_0_BOND_OUT_MEM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_BOND_OUT_U_0  
#define CLK_RST_CONTROLLER_BOND_OUT_U_0                 _MK_ADDR_CONST(0x78)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_SECURE                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_WORD_COUNT                      0x1
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_RESET_MASK                      _MK_MASK_CONST(0x77f01bff)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_READ_MASK                       _MK_MASK_CONST(0x77f01bff)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_WRITE_MASK                      _MK_MASK_CONST(0x77f01bff)
// Bond out DEV1_OUT.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV1_OUT_SHIFT                 _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV1_OUT_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV1_OUT_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV1_OUT_RANGE                 30:30
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV1_OUT_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV1_OUT_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV1_OUT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV1_OUT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV1_OUT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Bond out DEV2_OUT.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV2_OUT_SHIFT                 _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV2_OUT_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV2_OUT_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV2_OUT_RANGE                 29:29
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV2_OUT_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV2_OUT_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV2_OUT_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV2_OUT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_DEV2_OUT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Bond out SUS_OUT.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SUS_OUT_SHIFT                  _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SUS_OUT_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SUS_OUT_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SUS_OUT_RANGE                  28:28
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SUS_OUT_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SUS_OUT_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SUS_OUT_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SUS_OUT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SUS_OUT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Bond out CLK_M_DOUBLER.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CLK_M_DOUBLER_SHIFT                    _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CLK_M_DOUBLER_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CLK_M_DOUBLER_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CLK_M_DOUBLER_RANGE                    26:26
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CLK_M_DOUBLER_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CLK_M_DOUBLER_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CLK_M_DOUBLER_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CLK_M_DOUBLER_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CLK_M_DOUBLER_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out SYNC_CLK_DOUBLER.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SYNC_CLK_DOUBLER_SHIFT                 _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SYNC_CLK_DOUBLER_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SYNC_CLK_DOUBLER_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SYNC_CLK_DOUBLER_RANGE                 25:25
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SYNC_CLK_DOUBLER_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SYNC_CLK_DOUBLER_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SYNC_CLK_DOUBLER_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SYNC_CLK_DOUBLER_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SYNC_CLK_DOUBLER_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Bond out CRAM2.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CRAM2_SHIFT                    _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CRAM2_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CRAM2_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CRAM2_RANGE                    24:24
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CRAM2_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CRAM2_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CRAM2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CRAM2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CRAM2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out IRAMD.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMD_SHIFT                    _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMD_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMD_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMD_RANGE                    23:23
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMD_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMD_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out IRAMC.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMC_SHIFT                    _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMC_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMC_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMC_RANGE                    22:22
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMC_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMC_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMC_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMC_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMC_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out IRAMB.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMB_SHIFT                    _MK_SHIFT_CONST(21)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMB_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMB_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMB_RANGE                    21:21
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMB_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMB_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMB_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMB_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMB_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out IRAMA.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMA_SHIFT                    _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMA_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMA_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMA_RANGE                    20:20
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMA_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMA_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMA_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMA_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_IRAMA_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out LA.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_LA_SHIFT                       _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_LA_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_LA_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_LA_RANGE                       12:12
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_LA_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_LA_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_LA_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_LA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_LA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Bond out AVPUCQ.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AVPUCQ_SHIFT                   _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AVPUCQ_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AVPUCQ_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AVPUCQ_RANGE                   11:11
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AVPUCQ_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AVPUCQ_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AVPUCQ_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AVPUCQ_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AVPUCQ_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Bond out CSITE.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CSITE_SHIFT                    _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CSITE_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CSITE_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CSITE_RANGE                    9:9
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CSITE_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CSITE_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CSITE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CSITE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_CSITE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out AFI.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AFI_SHIFT                      _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AFI_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AFI_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AFI_RANGE                      8:8
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AFI_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AFI_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AFI_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AFI_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_AFI_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out OWR.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_OWR_SHIFT                      _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_OWR_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_OWR_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_OWR_RANGE                      7:7
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_OWR_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_OWR_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_OWR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_OWR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_OWR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Bond out PCIE.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_PCIE_SHIFT                     _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_PCIE_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_PCIE_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_PCIE_RANGE                     6:6
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_PCIE_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_PCIE_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_PCIE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_PCIE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_PCIE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out SDMMC3.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SDMMC3_SHIFT                   _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SDMMC3_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SDMMC3_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SDMMC3_RANGE                   5:5
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SDMMC3_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SDMMC3_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SDMMC3_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SDMMC3_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SDMMC3_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Bond out SBC4.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SBC4_SHIFT                     _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SBC4_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SBC4_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SBC4_RANGE                     4:4
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SBC4_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SBC4_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SBC4_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SBC4_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SBC4_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out I2C3.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_I2C3_SHIFT                     _MK_SHIFT_CONST(3)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_I2C3_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_I2C3_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_I2C3_RANGE                     3:3
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_I2C3_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_I2C3_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_I2C3_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_I2C3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_I2C3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Bond out UARTE.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTE_SHIFT                    _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTE_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTE_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTE_RANGE                    2:2
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTE_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTE_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out UARTD.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTD_SHIFT                    _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTD_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTD_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTD_RANGE                    1:1
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTD_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTD_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTD_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTD_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_UARTD_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Bond out SPEEDO.
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SPEEDO_SHIFT                   _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SPEEDO_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SPEEDO_SHIFT)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SPEEDO_RANGE                   0:0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SPEEDO_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SPEEDO_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SPEEDO_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SPEEDO_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_BOND_OUT_U_0_BOND_OUT_SPEEDO_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Reserved address 124 [0x7c] 

// Register CLK_RST_CONTROLLER_PLLC_BASE_0  
#define CLK_RST_CONTROLLER_PLLC_BASE_0                  _MK_ADDR_CONST(0x80)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLC_BASE_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLC_BASE_0_RESET_VAL                        _MK_MASK_CONST(0x10c)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_RESET_MASK                       _MK_MASK_CONST(0xe873ff1f)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_READ_MASK                        _MK_MASK_CONST(0xe873ff1f)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_WRITE_MASK                       _MK_MASK_CONST(0xe073ff1f)
//  0 = no bypass, 1 = bypass.
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_BYPASS_SHIFT                        _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_BYPASS_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_BYPASS_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_BYPASS_RANGE                        31:31
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_BYPASS_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_BYPASS_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_BYPASS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_BYPASS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_BYPASS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_BYPASS_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_BYPASS_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_BYPASS_ENABLE                       _MK_ENUM_CONST(1)

//  0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_ENABLE_SHIFT                        _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_ENABLE_RANGE                        30:30
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_ENABLE_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_ENABLE_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_ENABLE_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_ENABLE_ENABLE                       _MK_ENUM_CONST(1)

//  0 = enable reference clk, 1 = disable reference clk.
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_REF_DIS_SHIFT                       _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_REF_DIS_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_REF_DIS_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_REF_DIS_RANGE                       29:29
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_REF_DIS_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_REF_DIS_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_REF_DIS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_REF_DIS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_REF_DIS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_REF_DIS_INIT_ENUM                   REF_ENABLE
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_REF_DIS_REF_ENABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_REF_DIS_REF_DISABLE                 _MK_ENUM_CONST(1)

//  0 = not lock, 1 = lock.
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_LOCK_SHIFT                  _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_LOCK_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_LOCK_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_LOCK_RANGE                  27:27
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_LOCK_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_LOCK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_LOCK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_LOCK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_LOCK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  0 = post divider (2^n).
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVP_SHIFT                  _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVP_FIELD                  (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVP_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVP_RANGE                  22:20
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVP_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVP_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVP_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  PLL feedback divider.
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVN_SHIFT                  _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVN_FIELD                  (_MK_MASK_CONST(0x3ff) << CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVN_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVN_RANGE                  17:8
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVN_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVN_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVN_DEFAULT_MASK                   _MK_MASK_CONST(0x3ff)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  PLL input divider.
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVM_SHIFT                  _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVM_FIELD                  (_MK_MASK_CONST(0x1f) << CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVM_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVM_RANGE                  4:0
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVM_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVM_DEFAULT                        _MK_MASK_CONST(0xc)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVM_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_BASE_0_PLLC_DIVM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLLC_OUT_0  
#define CLK_RST_CONTROLLER_PLLC_OUT_0                   _MK_ADDR_CONST(0x84)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_SECURE                    0x0
#define CLK_RST_CONTROLLER_PLLC_OUT_0_WORD_COUNT                        0x1
#define CLK_RST_CONTROLLER_PLLC_OUT_0_RESET_VAL                         _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_RESET_MASK                        _MK_MASK_CONST(0xff03)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_READ_MASK                         _MK_MASK_CONST(0xff03)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_WRITE_MASK                        _MK_MASK_CONST(0xff03)
//  PLLC_OUT1 divider from base PLLC (lsb denote 0.5x).
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RATIO_SHIFT                     _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RATIO_FIELD                     (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RATIO_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RATIO_RANGE                     15:8
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RATIO_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RATIO_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RATIO_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RATIO_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RATIO_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//  PLLC_OUT1 divider clk enable.  0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_CLKEN_SHIFT                     _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_CLKEN_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_CLKEN_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_CLKEN_RANGE                     1:1
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_CLKEN_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_CLKEN_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_CLKEN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_CLKEN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_CLKEN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_CLKEN_INIT_ENUM                 ENABLE
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_CLKEN_DISABLE                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_CLKEN_ENABLE                    _MK_ENUM_CONST(1)

//  PLLC_OUT1 divider reset.  0 = reset, 1 = not reset.
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RSTN_SHIFT                      _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RSTN_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RSTN_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RSTN_RANGE                      0:0
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RSTN_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RSTN_DEFAULT                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RSTN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RSTN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RSTN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RSTN_INIT_ENUM                  RESET_DISABLE
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RSTN_RESET_ENABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLC_OUT_0_PLLC_OUT1_RSTN_RESET_DISABLE                      _MK_ENUM_CONST(1)


// Reserved address 136 [0x88] 

// Register CLK_RST_CONTROLLER_PLLC_MISC_0  
#define CLK_RST_CONTROLLER_PLLC_MISC_0                  _MK_ADDR_CONST(0x8c)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLC_MISC_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLC_MISC_0_RESET_VAL                        _MK_MASK_CONST(0x100)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_RESET_MASK                       _MK_MASK_CONST(0xc0d7ffff)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_READ_MASK                        _MK_MASK_CONST(0xc0d7ffff)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_WRITE_MASK                       _MK_MASK_CONST(0xc0d7ffff)
//  1 = invert PLLC_OUT1 clock.
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_INV_CLK_SHIFT                  _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_INV_CLK_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_INV_CLK_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_INV_CLK_RANGE                  31:31
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_INV_CLK_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_INV_CLK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_INV_CLK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_INV_CLK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_INV_CLK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  1 = bypass PLLC_OUT1 divider.
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_DIV_BYP_SHIFT                  _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_DIV_BYP_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_DIV_BYP_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_DIV_BYP_RANGE                  30:30
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_DIV_BYP_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_DIV_BYP_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_DIV_BYP_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_DIV_BYP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_OUT1_DIV_BYP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  Base PLLC test output select.
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_PTS_SHIFT                   _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_PTS_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_PTS_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_PTS_RANGE                   23:22
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_PTS_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_PTS_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_PTS_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_PTS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_PTS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//  Base PLLC DCCON control.
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_DCCON_SHIFT                 _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_DCCON_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_DCCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_DCCON_RANGE                 20:20
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_DCCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_DCCON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_DCCON_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_DCCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_DCCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  1 = enable, 0 = disable. 
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_ENABLE_SHIFT                   _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_ENABLE_RANGE                   18:18
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_ENABLE_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_ENABLE_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_ENABLE_ENABLE                  _MK_ENUM_CONST(1)

//  lock select.
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_SEL_SHIFT                      _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_SEL_FIELD                      (_MK_MASK_CONST(0x3f) << CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_SEL_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_SEL_RANGE                      17:12
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_SEL_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LOCK_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  Base PLLC charge pump setup control.
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_CPCON_SHIFT                 _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_CPCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_CPCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_CPCON_RANGE                 11:8
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_CPCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_CPCON_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_CPCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_CPCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_CPCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLC loop filter setup control.
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LFCON_SHIFT                 _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LFCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LFCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LFCON_RANGE                 7:4
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LFCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LFCON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LFCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LFCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_LFCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLC VCO range setup control.
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_VCOCON_SHIFT                        _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_VCOCON_FIELD                        (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_VCOCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_VCOCON_RANGE                        3:0
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_VCOCON_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_VCOCON_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_VCOCON_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_VCOCON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLC_MISC_0_PLLC_VCOCON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLLM_BASE_0  
#define CLK_RST_CONTROLLER_PLLM_BASE_0                  _MK_ADDR_CONST(0x90)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLM_BASE_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLM_BASE_0_RESET_VAL                        _MK_MASK_CONST(0x10c)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_RESET_MASK                       _MK_MASK_CONST(0xe873ff1f)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_READ_MASK                        _MK_MASK_CONST(0xe873ff1f)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_WRITE_MASK                       _MK_MASK_CONST(0xe073ff1f)
//  0 = no bypass, 1 = bypass.
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_BYPASS_SHIFT                        _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_BYPASS_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_BYPASS_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_BYPASS_RANGE                        31:31
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_BYPASS_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_BYPASS_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_BYPASS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_BYPASS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_BYPASS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_BYPASS_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_BYPASS_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_BYPASS_ENABLE                       _MK_ENUM_CONST(1)

//  0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_ENABLE_SHIFT                        _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_ENABLE_RANGE                        30:30
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_ENABLE_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_ENABLE_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_ENABLE_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_ENABLE_ENABLE                       _MK_ENUM_CONST(1)

//  0 = enable reference clk, 1 = disable reference clk.
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_REF_DIS_SHIFT                       _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_REF_DIS_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_REF_DIS_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_REF_DIS_RANGE                       29:29
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_REF_DIS_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_REF_DIS_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_REF_DIS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_REF_DIS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_REF_DIS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_REF_DIS_INIT_ENUM                   REF_ENABLE
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_REF_DIS_REF_ENABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_REF_DIS_REF_DISABLE                 _MK_ENUM_CONST(1)

//  0 = not lock, 1 = lock.
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_LOCK_SHIFT                  _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_LOCK_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_LOCK_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_LOCK_RANGE                  27:27
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_LOCK_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_LOCK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_LOCK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_LOCK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_LOCK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  0 = post divider (2^n).
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVP_SHIFT                  _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVP_FIELD                  (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVP_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVP_RANGE                  22:20
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVP_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVP_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVP_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  PLL feedback divider.
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVN_SHIFT                  _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVN_FIELD                  (_MK_MASK_CONST(0x3ff) << CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVN_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVN_RANGE                  17:8
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVN_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVN_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVN_DEFAULT_MASK                   _MK_MASK_CONST(0x3ff)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  PLL input divider.
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVM_SHIFT                  _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVM_FIELD                  (_MK_MASK_CONST(0x1f) << CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVM_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVM_RANGE                  4:0
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVM_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVM_DEFAULT                        _MK_MASK_CONST(0xc)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVM_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_BASE_0_PLLM_DIVM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLLM_OUT_0  
#define CLK_RST_CONTROLLER_PLLM_OUT_0                   _MK_ADDR_CONST(0x94)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_SECURE                    0x0
#define CLK_RST_CONTROLLER_PLLM_OUT_0_WORD_COUNT                        0x1
#define CLK_RST_CONTROLLER_PLLM_OUT_0_RESET_VAL                         _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_RESET_MASK                        _MK_MASK_CONST(0xff03)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_READ_MASK                         _MK_MASK_CONST(0xff03)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_WRITE_MASK                        _MK_MASK_CONST(0xff03)
//  PLLM_OUT1 divider from base PLLM (lsb denote 0.5x).
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RATIO_SHIFT                     _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RATIO_FIELD                     (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RATIO_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RATIO_RANGE                     15:8
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RATIO_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RATIO_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RATIO_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RATIO_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RATIO_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//  PLLM_OUT1 divider clk enable.  0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_CLKEN_SHIFT                     _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_CLKEN_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_CLKEN_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_CLKEN_RANGE                     1:1
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_CLKEN_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_CLKEN_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_CLKEN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_CLKEN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_CLKEN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_CLKEN_INIT_ENUM                 ENABLE
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_CLKEN_DISABLE                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_CLKEN_ENABLE                    _MK_ENUM_CONST(1)

//  PLLM_OUT1 divider reset.  0 = reset, 1 = not reset.
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RSTN_SHIFT                      _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RSTN_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RSTN_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RSTN_RANGE                      0:0
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RSTN_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RSTN_DEFAULT                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RSTN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RSTN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RSTN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RSTN_INIT_ENUM                  RESET_DISABLE
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RSTN_RESET_ENABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLM_OUT_0_PLLM_OUT1_RSTN_RESET_DISABLE                      _MK_ENUM_CONST(1)


// Reserved address 152 [0x98] 

// Register CLK_RST_CONTROLLER_PLLM_MISC_0  
#define CLK_RST_CONTROLLER_PLLM_MISC_0                  _MK_ADDR_CONST(0x9c)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLM_MISC_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLM_MISC_0_RESET_VAL                        _MK_MASK_CONST(0x100)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_RESET_MASK                       _MK_MASK_CONST(0xcfd7ffff)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_READ_MASK                        _MK_MASK_CONST(0xcfd7ffff)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_WRITE_MASK                       _MK_MASK_CONST(0xcfd7ffff)
//  1 = invert PLLM_OUT1 clock.
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_INV_CLK_SHIFT                  _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_INV_CLK_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_INV_CLK_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_INV_CLK_RANGE                  31:31
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_INV_CLK_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_INV_CLK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_INV_CLK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_INV_CLK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_INV_CLK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  1 = bypass PLLM_OUT1 divider.
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_DIV_BYP_SHIFT                  _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_DIV_BYP_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_DIV_BYP_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_DIV_BYP_RANGE                  30:30
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_DIV_BYP_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_DIV_BYP_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_DIV_BYP_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_DIV_BYP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_OUT1_DIV_BYP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  Base PLLM setup.
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_SETUP_SHIFT                 _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_SETUP_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_SETUP_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_SETUP_RANGE                 27:24
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_SETUP_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_SETUP_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_SETUP_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_SETUP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_SETUP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLM test output select.
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_PTS_SHIFT                   _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_PTS_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_PTS_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_PTS_RANGE                   23:22
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_PTS_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_PTS_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_PTS_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_PTS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_PTS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//  Base PLLM DCCON control.
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_DCCON_SHIFT                 _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_DCCON_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_DCCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_DCCON_RANGE                 20:20
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_DCCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_DCCON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_DCCON_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_DCCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_DCCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  1 = enable, 0 = disable. 
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_ENABLE_SHIFT                   _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_ENABLE_RANGE                   18:18
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_ENABLE_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_ENABLE_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_ENABLE_ENABLE                  _MK_ENUM_CONST(1)

//  lock select.
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_SEL_SHIFT                      _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_SEL_FIELD                      (_MK_MASK_CONST(0x3f) << CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_SEL_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_SEL_RANGE                      17:12
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_SEL_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LOCK_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  Base PLLM charge pump setup control.
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_CPCON_SHIFT                 _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_CPCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_CPCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_CPCON_RANGE                 11:8
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_CPCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_CPCON_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_CPCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_CPCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_CPCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLM loop filter setup control.
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LFCON_SHIFT                 _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LFCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LFCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LFCON_RANGE                 7:4
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LFCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LFCON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LFCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LFCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_LFCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLM VCO range setup control.
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_VCOCON_SHIFT                        _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_VCOCON_FIELD                        (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_VCOCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_VCOCON_RANGE                        3:0
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_VCOCON_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_VCOCON_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_VCOCON_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_VCOCON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLM_MISC_0_PLLM_VCOCON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLLP_BASE_0  
#define CLK_RST_CONTROLLER_PLLP_BASE_0                  _MK_ADDR_CONST(0xa0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLP_BASE_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLP_BASE_0_RESET_VAL                        _MK_MASK_CONST(0x10c)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_RESET_MASK                       _MK_MASK_CONST(0xf873ff1f)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_READ_MASK                        _MK_MASK_CONST(0xf873ff1f)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_WRITE_MASK                       _MK_MASK_CONST(0xf073ff1f)
//  0 = no bypass, 1 = bypass.
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BYPASS_SHIFT                        _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BYPASS_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BYPASS_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BYPASS_RANGE                        31:31
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BYPASS_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BYPASS_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BYPASS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BYPASS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BYPASS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BYPASS_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BYPASS_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BYPASS_ENABLE                       _MK_ENUM_CONST(1)

//  0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_ENABLE_SHIFT                        _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_ENABLE_RANGE                        30:30
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_ENABLE_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_ENABLE_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_ENABLE_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_ENABLE_ENABLE                       _MK_ENUM_CONST(1)

//  0 = enable reference clk, 1 = disable reference clk.
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_REF_DIS_SHIFT                       _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_REF_DIS_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_REF_DIS_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_REF_DIS_RANGE                       29:29
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_REF_DIS_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_REF_DIS_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_REF_DIS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_REF_DIS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_REF_DIS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_REF_DIS_INIT_ENUM                   REF_ENABLE
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_REF_DIS_REF_ENABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_REF_DIS_REF_DISABLE                 _MK_ENUM_CONST(1)

//  0 = disallow base override , 1 = allow base override.
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BASE_OVRRIDE_SHIFT                  _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BASE_OVRRIDE_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BASE_OVRRIDE_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BASE_OVRRIDE_RANGE                  28:28
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BASE_OVRRIDE_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BASE_OVRRIDE_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BASE_OVRRIDE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BASE_OVRRIDE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BASE_OVRRIDE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BASE_OVRRIDE_INIT_ENUM                      DISABLE
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BASE_OVRRIDE_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_BASE_OVRRIDE_ENABLE                 _MK_ENUM_CONST(1)

//  0 = not lock, 1 = lock.
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_LOCK_SHIFT                  _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_LOCK_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_LOCK_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_LOCK_RANGE                  27:27
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_LOCK_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_LOCK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_LOCK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_LOCK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_LOCK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  0 = post divider (2^n).
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVP_SHIFT                  _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVP_FIELD                  (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVP_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVP_RANGE                  22:20
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVP_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVP_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVP_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  PLL feedback divider.
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVN_SHIFT                  _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVN_FIELD                  (_MK_MASK_CONST(0x3ff) << CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVN_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVN_RANGE                  17:8
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVN_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVN_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVN_DEFAULT_MASK                   _MK_MASK_CONST(0x3ff)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  PLL input divider.
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVM_SHIFT                  _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVM_FIELD                  (_MK_MASK_CONST(0x1f) << CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVM_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVM_RANGE                  4:0
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVM_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVM_DEFAULT                        _MK_MASK_CONST(0xc)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVM_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_BASE_0_PLLP_DIVM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLLP_OUTA_0  
#define CLK_RST_CONTROLLER_PLLP_OUTA_0                  _MK_ADDR_CONST(0xa4)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_RESET_VAL                        _MK_MASK_CONST(0x30003)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_RESET_MASK                       _MK_MASK_CONST(0xff07ff07)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_READ_MASK                        _MK_MASK_CONST(0xff07ff07)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_WRITE_MASK                       _MK_MASK_CONST(0xff07ff07)
//  PLLP_OUT2 divider from base PLLP (lsb denote 0.5x).
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RATIO_SHIFT                    _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RATIO_FIELD                    (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RATIO_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RATIO_RANGE                    31:24
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RATIO_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RATIO_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RATIO_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RATIO_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RATIO_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//  0 = disallow PLLP_OUT2 ratio override, 1 = enable override.
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_OVRRIDE_SHIFT                  _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_OVRRIDE_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_OVRRIDE_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_OVRRIDE_RANGE                  18:18
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_OVRRIDE_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_OVRRIDE_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_OVRRIDE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_OVRRIDE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_OVRRIDE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_OVRRIDE_INIT_ENUM                      DISABLE
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_OVRRIDE_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_OVRRIDE_ENABLE                 _MK_ENUM_CONST(1)

//  PLLP_OUT2 divider clk enable.  0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_CLKEN_SHIFT                    _MK_SHIFT_CONST(17)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_CLKEN_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_CLKEN_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_CLKEN_RANGE                    17:17
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_CLKEN_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_CLKEN_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_CLKEN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_CLKEN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_CLKEN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_CLKEN_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_CLKEN_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_CLKEN_ENABLE                   _MK_ENUM_CONST(1)

//  PLLP_OUT2 divider reset.  0 = reset, 1 = not reset.
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RSTN_SHIFT                     _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RSTN_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RSTN_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RSTN_RANGE                     16:16
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RSTN_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RSTN_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RSTN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RSTN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RSTN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RSTN_INIT_ENUM                 RESET_DISABLE
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RSTN_RESET_ENABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT2_RSTN_RESET_DISABLE                     _MK_ENUM_CONST(1)

//  PLLP_OUT1 divider from base PLLP (lsb denote 0.5x).
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RATIO_SHIFT                    _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RATIO_FIELD                    (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RATIO_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RATIO_RANGE                    15:8
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RATIO_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RATIO_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RATIO_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RATIO_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RATIO_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//  0 = disallow PLLP_OUT1 ratio override, 1 = enable override.
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_OVRRIDE_SHIFT                  _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_OVRRIDE_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_OVRRIDE_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_OVRRIDE_RANGE                  2:2
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_OVRRIDE_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_OVRRIDE_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_OVRRIDE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_OVRRIDE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_OVRRIDE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_OVRRIDE_INIT_ENUM                      DISABLE
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_OVRRIDE_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_OVRRIDE_ENABLE                 _MK_ENUM_CONST(1)

//  PLLP_OUT1 divider clk enable.  0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_CLKEN_SHIFT                    _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_CLKEN_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_CLKEN_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_CLKEN_RANGE                    1:1
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_CLKEN_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_CLKEN_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_CLKEN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_CLKEN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_CLKEN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_CLKEN_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_CLKEN_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_CLKEN_ENABLE                   _MK_ENUM_CONST(1)

//  PLLP_OUT1 divider reset.  0 = reset, 1 = not reset.
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RSTN_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RSTN_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RSTN_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RSTN_RANGE                     0:0
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RSTN_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RSTN_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RSTN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RSTN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RSTN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RSTN_INIT_ENUM                 RESET_DISABLE
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RSTN_RESET_ENABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_OUTA_0_PLLP_OUT1_RSTN_RESET_DISABLE                     _MK_ENUM_CONST(1)


// Register CLK_RST_CONTROLLER_PLLP_OUTB_0  
#define CLK_RST_CONTROLLER_PLLP_OUTB_0                  _MK_ADDR_CONST(0xa8)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_RESET_VAL                        _MK_MASK_CONST(0x30003)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_RESET_MASK                       _MK_MASK_CONST(0xff07ff07)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_READ_MASK                        _MK_MASK_CONST(0xff07ff07)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_WRITE_MASK                       _MK_MASK_CONST(0xff07ff07)
//  PLLP_OUT4 divider from base PLLP (lsb denote 0.5x).
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RATIO_SHIFT                    _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RATIO_FIELD                    (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RATIO_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RATIO_RANGE                    31:24
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RATIO_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RATIO_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RATIO_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RATIO_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RATIO_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//  0 = disallow PLLP_OUT4 ratio override, 1 = enable override.
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_OVRRIDE_SHIFT                  _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_OVRRIDE_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_OVRRIDE_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_OVRRIDE_RANGE                  18:18
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_OVRRIDE_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_OVRRIDE_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_OVRRIDE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_OVRRIDE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_OVRRIDE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_OVRRIDE_INIT_ENUM                      DISABLE
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_OVRRIDE_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_OVRRIDE_ENABLE                 _MK_ENUM_CONST(1)

//  PLLP_OUT4 divider clk enable.  0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_CLKEN_SHIFT                    _MK_SHIFT_CONST(17)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_CLKEN_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_CLKEN_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_CLKEN_RANGE                    17:17
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_CLKEN_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_CLKEN_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_CLKEN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_CLKEN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_CLKEN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_CLKEN_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_CLKEN_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_CLKEN_ENABLE                   _MK_ENUM_CONST(1)

//  PLLP_OUT4 divider reset.  0 = reset, 1 = not reset.
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RSTN_SHIFT                     _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RSTN_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RSTN_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RSTN_RANGE                     16:16
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RSTN_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RSTN_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RSTN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RSTN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RSTN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RSTN_INIT_ENUM                 RESET_DISABLE
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RSTN_RESET_ENABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT4_RSTN_RESET_DISABLE                     _MK_ENUM_CONST(1)

//  PLLP_OUT3 divider from base PLLP (lsb denote 0.5x).
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RATIO_SHIFT                    _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RATIO_FIELD                    (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RATIO_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RATIO_RANGE                    15:8
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RATIO_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RATIO_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RATIO_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RATIO_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RATIO_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//  0 = disallow PLLP_OUT3 ratio override, 1 = enable override.
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_OVRRIDE_SHIFT                  _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_OVRRIDE_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_OVRRIDE_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_OVRRIDE_RANGE                  2:2
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_OVRRIDE_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_OVRRIDE_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_OVRRIDE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_OVRRIDE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_OVRRIDE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_OVRRIDE_INIT_ENUM                      DISABLE
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_OVRRIDE_DISABLE                        _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_OVRRIDE_ENABLE                 _MK_ENUM_CONST(1)

//  PLLP_OUT3 divider clk enable.  0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_CLKEN_SHIFT                    _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_CLKEN_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_CLKEN_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_CLKEN_RANGE                    1:1
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_CLKEN_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_CLKEN_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_CLKEN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_CLKEN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_CLKEN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_CLKEN_INIT_ENUM                        ENABLE
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_CLKEN_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_CLKEN_ENABLE                   _MK_ENUM_CONST(1)

//  PLLP_OUT3 divider reset.  0 = reset, 1 = not reset.
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RSTN_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RSTN_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RSTN_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RSTN_RANGE                     0:0
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RSTN_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RSTN_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RSTN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RSTN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RSTN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RSTN_INIT_ENUM                 RESET_DISABLE
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RSTN_RESET_ENABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_OUTB_0_PLLP_OUT3_RSTN_RESET_DISABLE                     _MK_ENUM_CONST(1)


// Register CLK_RST_CONTROLLER_PLLP_MISC_0  
#define CLK_RST_CONTROLLER_PLLP_MISC_0                  _MK_ADDR_CONST(0xac)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLP_MISC_0_RESET_VAL                        _MK_MASK_CONST(0x100)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_RESET_MASK                       _MK_MASK_CONST(0xffd7ffff)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_READ_MASK                        _MK_MASK_CONST(0xffd7ffff)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_WRITE_MASK                       _MK_MASK_CONST(0xffd7ffff)
//  1 = invert PLLP_OUT4 clock.
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_INV_CLK_SHIFT                  _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_INV_CLK_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_INV_CLK_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_INV_CLK_RANGE                  31:31
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_INV_CLK_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_INV_CLK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_INV_CLK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_INV_CLK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_INV_CLK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  1 = invert PLLP_OUT3 clock.
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_INV_CLK_SHIFT                  _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_INV_CLK_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_INV_CLK_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_INV_CLK_RANGE                  30:30
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_INV_CLK_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_INV_CLK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_INV_CLK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_INV_CLK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_INV_CLK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  1 = invert PLLP_OUT2 clock.
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_INV_CLK_SHIFT                  _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_INV_CLK_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_INV_CLK_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_INV_CLK_RANGE                  29:29
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_INV_CLK_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_INV_CLK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_INV_CLK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_INV_CLK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_INV_CLK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  1 = invert PLLP_OUT1 clock.
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_INV_CLK_SHIFT                  _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_INV_CLK_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_INV_CLK_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_INV_CLK_RANGE                  28:28
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_INV_CLK_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_INV_CLK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_INV_CLK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_INV_CLK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_INV_CLK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  1 = bypass PLLP_OUT4 divider.
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_DIV_BYP_SHIFT                  _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_DIV_BYP_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_DIV_BYP_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_DIV_BYP_RANGE                  27:27
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_DIV_BYP_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_DIV_BYP_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_DIV_BYP_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_DIV_BYP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT4_DIV_BYP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  1 = bypass PLLP_OUT3 divider.
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_DIV_BYP_SHIFT                  _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_DIV_BYP_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_DIV_BYP_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_DIV_BYP_RANGE                  26:26
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_DIV_BYP_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_DIV_BYP_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_DIV_BYP_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_DIV_BYP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT3_DIV_BYP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  1 = bypass PLLP_OUT2 divider.
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_DIV_BYP_SHIFT                  _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_DIV_BYP_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_DIV_BYP_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_DIV_BYP_RANGE                  25:25
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_DIV_BYP_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_DIV_BYP_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_DIV_BYP_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_DIV_BYP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT2_DIV_BYP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  1 = bypass PLLP_OUT1 divider.
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_DIV_BYP_SHIFT                  _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_DIV_BYP_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_DIV_BYP_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_DIV_BYP_RANGE                  24:24
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_DIV_BYP_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_DIV_BYP_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_DIV_BYP_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_DIV_BYP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_OUT1_DIV_BYP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  Base PLLP test output select.
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_PTS_SHIFT                   _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_PTS_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_PTS_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_PTS_RANGE                   23:22
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_PTS_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_PTS_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_PTS_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_PTS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_PTS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//  Base PLLP DCCON control.
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_DCCON_SHIFT                 _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_DCCON_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_DCCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_DCCON_RANGE                 20:20
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_DCCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_DCCON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_DCCON_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_DCCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_DCCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  1 = enable, 0 = disable. 
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_ENABLE_SHIFT                   _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_ENABLE_RANGE                   18:18
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_ENABLE_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_ENABLE_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_ENABLE_ENABLE                  _MK_ENUM_CONST(1)

//  lock select.
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_SEL_SHIFT                      _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_SEL_FIELD                      (_MK_MASK_CONST(0x3f) << CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_SEL_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_SEL_RANGE                      17:12
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_SEL_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LOCK_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  Base PLLP charge pump setup control.
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_CPCON_SHIFT                 _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_CPCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_CPCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_CPCON_RANGE                 11:8
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_CPCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_CPCON_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_CPCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_CPCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_CPCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLP loop filter setup control.
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LFCON_SHIFT                 _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LFCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LFCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LFCON_RANGE                 7:4
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LFCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LFCON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LFCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LFCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_LFCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLP VCO range setup control.
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_VCOCON_SHIFT                        _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_VCOCON_FIELD                        (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_VCOCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_VCOCON_RANGE                        3:0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_VCOCON_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_VCOCON_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_VCOCON_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_VCOCON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLP_MISC_0_PLLP_VCOCON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLLA_BASE_0  
#define CLK_RST_CONTROLLER_PLLA_BASE_0                  _MK_ADDR_CONST(0xb0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLA_BASE_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLA_BASE_0_RESET_VAL                        _MK_MASK_CONST(0x10c)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_RESET_MASK                       _MK_MASK_CONST(0xe873ff1f)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_READ_MASK                        _MK_MASK_CONST(0xe873ff1f)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_WRITE_MASK                       _MK_MASK_CONST(0xe073ff1f)
//  0 = no bypass, 1 = bypass.
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_BYPASS_SHIFT                        _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_BYPASS_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_BYPASS_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_BYPASS_RANGE                        31:31
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_BYPASS_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_BYPASS_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_BYPASS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_BYPASS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_BYPASS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_BYPASS_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_BYPASS_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_BYPASS_ENABLE                       _MK_ENUM_CONST(1)

//  0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_ENABLE_SHIFT                        _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_ENABLE_RANGE                        30:30
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_ENABLE_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_ENABLE_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_ENABLE_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_ENABLE_ENABLE                       _MK_ENUM_CONST(1)

//  0 = enable reference clk, 1 = disable reference clk.
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_REF_DIS_SHIFT                       _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_REF_DIS_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_REF_DIS_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_REF_DIS_RANGE                       29:29
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_REF_DIS_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_REF_DIS_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_REF_DIS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_REF_DIS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_REF_DIS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_REF_DIS_INIT_ENUM                   REF_ENABLE
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_REF_DIS_REF_ENABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_REF_DIS_REF_DISABLE                 _MK_ENUM_CONST(1)

//  0 = not lock, 1 = lock.
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_LOCK_SHIFT                  _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_LOCK_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_LOCK_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_LOCK_RANGE                  27:27
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_LOCK_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_LOCK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_LOCK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_LOCK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_LOCK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  0 = post divider (2^n).
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVP_SHIFT                  _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVP_FIELD                  (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVP_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVP_RANGE                  22:20
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVP_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVP_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVP_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  PLL feedback divider.
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVN_SHIFT                  _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVN_FIELD                  (_MK_MASK_CONST(0x3ff) << CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVN_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVN_RANGE                  17:8
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVN_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVN_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVN_DEFAULT_MASK                   _MK_MASK_CONST(0x3ff)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  PLL input divider.
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVM_SHIFT                  _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVM_FIELD                  (_MK_MASK_CONST(0x1f) << CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVM_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVM_RANGE                  4:0
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVM_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVM_DEFAULT                        _MK_MASK_CONST(0xc)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVM_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_BASE_0_PLLA_DIVM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLLA_OUT_0  
#define CLK_RST_CONTROLLER_PLLA_OUT_0                   _MK_ADDR_CONST(0xb4)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_SECURE                    0x0
#define CLK_RST_CONTROLLER_PLLA_OUT_0_WORD_COUNT                        0x1
#define CLK_RST_CONTROLLER_PLLA_OUT_0_RESET_VAL                         _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_RESET_MASK                        _MK_MASK_CONST(0xff03)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_READ_MASK                         _MK_MASK_CONST(0xff03)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_WRITE_MASK                        _MK_MASK_CONST(0xff03)
//  PLLA_OUT0 divider from base PLLA (lsb denote 0.5x).
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RATIO_SHIFT                     _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RATIO_FIELD                     (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RATIO_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RATIO_RANGE                     15:8
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RATIO_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RATIO_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RATIO_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RATIO_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RATIO_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RATIO_DISABLE                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RATIO_ENABLE                    _MK_ENUM_CONST(1)

//  PLLA_OUT0 divider clk enable.  0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_CLKEN_SHIFT                     _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_CLKEN_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_CLKEN_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_CLKEN_RANGE                     1:1
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_CLKEN_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_CLKEN_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_CLKEN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_CLKEN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_CLKEN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_CLKEN_INIT_ENUM                 ENABLE
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_CLKEN_DISABLE                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_CLKEN_ENABLE                    _MK_ENUM_CONST(1)

//  PLLA_OUT0 divider reset.  0 = reset, 1 = not reset.
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RSTN_SHIFT                      _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RSTN_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RSTN_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RSTN_RANGE                      0:0
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RSTN_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RSTN_DEFAULT                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RSTN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RSTN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RSTN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RSTN_INIT_ENUM                  RESET_DISABLE
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RSTN_RESET_ENABLE                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLA_OUT_0_PLLA_OUT0_RSTN_RESET_DISABLE                      _MK_ENUM_CONST(1)


// Reserved address 184 [0xb8] 

// Register CLK_RST_CONTROLLER_PLLA_MISC_0  
#define CLK_RST_CONTROLLER_PLLA_MISC_0                  _MK_ADDR_CONST(0xbc)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLA_MISC_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLA_MISC_0_RESET_VAL                        _MK_MASK_CONST(0x100)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_RESET_MASK                       _MK_MASK_CONST(0xc0d7ffff)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_READ_MASK                        _MK_MASK_CONST(0xc0d7ffff)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_WRITE_MASK                       _MK_MASK_CONST(0xc0d7ffff)
//  1 = invert PLLA_OUT0 clock.
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_INV_CLK_SHIFT                  _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_INV_CLK_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_INV_CLK_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_INV_CLK_RANGE                  31:31
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_INV_CLK_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_INV_CLK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_INV_CLK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_INV_CLK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_INV_CLK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  1 = bypass PLLA_OUT0 divider.
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_DIV_BYP_SHIFT                  _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_DIV_BYP_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_DIV_BYP_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_DIV_BYP_RANGE                  30:30
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_DIV_BYP_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_DIV_BYP_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_DIV_BYP_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_DIV_BYP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_OUT0_DIV_BYP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  Base PLLA test output select.
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_PTS_SHIFT                   _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_PTS_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_PTS_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_PTS_RANGE                   23:22
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_PTS_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_PTS_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_PTS_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_PTS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_PTS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//  Base PLLA DCCON control.
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_DCCON_SHIFT                 _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_DCCON_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_DCCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_DCCON_RANGE                 20:20
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_DCCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_DCCON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_DCCON_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_DCCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_DCCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  1 = enable, 0 = disable. 
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_ENABLE_SHIFT                   _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_ENABLE_RANGE                   18:18
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_ENABLE_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_ENABLE_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_ENABLE_ENABLE                  _MK_ENUM_CONST(1)

//  lock select.
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_SEL_SHIFT                      _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_SEL_FIELD                      (_MK_MASK_CONST(0x3f) << CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_SEL_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_SEL_RANGE                      17:12
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_SEL_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LOCK_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  Base PLLA charge pump setup control.
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_CPCON_SHIFT                 _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_CPCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_CPCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_CPCON_RANGE                 11:8
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_CPCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_CPCON_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_CPCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_CPCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_CPCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLA loop filter setup control.
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LFCON_SHIFT                 _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LFCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LFCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LFCON_RANGE                 7:4
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LFCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LFCON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LFCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LFCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_LFCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLA VCO range setup control.
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_VCOCON_SHIFT                        _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_VCOCON_FIELD                        (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_VCOCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_VCOCON_RANGE                        3:0
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_VCOCON_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_VCOCON_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_VCOCON_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_VCOCON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLA_MISC_0_PLLA_VCOCON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLLU_BASE_0  
#define CLK_RST_CONTROLLER_PLLU_BASE_0                  _MK_ADDR_CONST(0xc0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLU_BASE_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLU_BASE_0_RESET_VAL                        _MK_MASK_CONST(0x10c)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_RESET_MASK                       _MK_MASK_CONST(0xe9f3ff1f)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_READ_MASK                        _MK_MASK_CONST(0xe9f3ff1f)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_WRITE_MASK                       _MK_MASK_CONST(0xe1f3ff1f)
//  0 = no bypass, 1 = bypass.
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_BYPASS_SHIFT                        _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_BYPASS_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_BYPASS_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_BYPASS_RANGE                        31:31
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_BYPASS_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_BYPASS_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_BYPASS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_BYPASS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_BYPASS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_BYPASS_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_BYPASS_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_BYPASS_ENABLE                       _MK_ENUM_CONST(1)

//  0 = disable, 1 = enable.  This bit is use only when PLLU_OVERRIDE bit is set.
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_ENABLE_SHIFT                        _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_ENABLE_RANGE                        30:30
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_ENABLE_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_ENABLE_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_ENABLE_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_ENABLE_ENABLE                       _MK_ENUM_CONST(1)

//  0 = enable reference clk, 1 = disable reference clk.
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_REF_DIS_SHIFT                       _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_REF_DIS_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_REF_DIS_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_REF_DIS_RANGE                       29:29
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_REF_DIS_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_REF_DIS_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_REF_DIS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_REF_DIS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_REF_DIS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_REF_DIS_INIT_ENUM                   REF_ENABLE
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_REF_DIS_REF_ENABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_REF_DIS_REF_DISABLE                 _MK_ENUM_CONST(1)

//  0 = not lock, 1 = lock.
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_LOCK_SHIFT                  _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_LOCK_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_LOCK_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_LOCK_RANGE                  27:27
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_LOCK_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_LOCK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_LOCK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_LOCK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_LOCK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// 0 = FO_[ICUSB,HSIC,USB] controlled by USB controllers, 1 = controlled by PLLU_CLKENABLEs.
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_OVERRIDE_SHIFT                      _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_OVERRIDE_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_OVERRIDE_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_OVERRIDE_RANGE                      24:24
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_OVERRIDE_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_OVERRIDE_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_OVERRIDE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_OVERRIDE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_OVERRIDE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  FO_ICUSB output enable.  This bit is use only when PLLU_OVERRIDE bit is set.
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_ICUSB_SHIFT                       _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_ICUSB_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_ICUSB_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_ICUSB_RANGE                       23:23
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_ICUSB_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_ICUSB_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_ICUSB_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_ICUSB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_ICUSB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  FO_HSIC output enable.  This bit is use only when PLLU_OVERRIDE bit is set.
//  Otherwise, USB controllers will control this automatically.  
//  0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_HSIC_SHIFT                        _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_HSIC_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_HSIC_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_HSIC_RANGE                        22:22
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_HSIC_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_HSIC_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_HSIC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_HSIC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_HSIC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//  FO_USB output enable.  This bit is use only when PLLU_OVERRIDE bit is set.
//  Otherwise, USB controllers will control this automatically.  
//  0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_USB_SHIFT                 _MK_SHIFT_CONST(21)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_USB_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_USB_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_USB_RANGE                 21:21
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_USB_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_USB_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_USB_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_USB_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_CLKENABLE_USB_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  0 = post-div of 2, 1 = post-div of 1.
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_VCO_FREQ_SHIFT                      _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_VCO_FREQ_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_VCO_FREQ_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_VCO_FREQ_RANGE                      20:20
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_VCO_FREQ_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_VCO_FREQ_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_VCO_FREQ_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_VCO_FREQ_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_VCO_FREQ_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  PLL feedback divider.
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVN_SHIFT                  _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVN_FIELD                  (_MK_MASK_CONST(0x3ff) << CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVN_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVN_RANGE                  17:8
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVN_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVN_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVN_DEFAULT_MASK                   _MK_MASK_CONST(0x3ff)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  PLL input divider.
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVM_SHIFT                  _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVM_FIELD                  (_MK_MASK_CONST(0x1f) << CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVM_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVM_RANGE                  4:0
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVM_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVM_DEFAULT                        _MK_MASK_CONST(0xc)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVM_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_BASE_0_PLLU_DIVM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 196 [0xc4] 

// Reserved address 200 [0xc8] 

// Register CLK_RST_CONTROLLER_PLLU_MISC_0  
#define CLK_RST_CONTROLLER_PLLU_MISC_0                  _MK_ADDR_CONST(0xcc)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLU_MISC_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLU_MISC_0_RESET_VAL                        _MK_MASK_CONST(0x100)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_RESET_MASK                       _MK_MASK_CONST(0x3843ffff)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_READ_MASK                        _MK_MASK_CONST(0x3843ffff)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_WRITE_MASK                       _MK_MASK_CONST(0x3843ffff)
//  Base PLLU test output select.
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_PTS_SHIFT                   _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_PTS_FIELD                   (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_PTS_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_PTS_RANGE                   29:27
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_PTS_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_PTS_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_PTS_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_PTS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_PTS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//  1 = enable, 0 = disable. 
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_ENABLE_SHIFT                   _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_ENABLE_RANGE                   22:22
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_ENABLE_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_ENABLE_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_ENABLE_ENABLE                  _MK_ENUM_CONST(1)

//  lock select.
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_SEL_SHIFT                      _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_SEL_FIELD                      (_MK_MASK_CONST(0x3f) << CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_SEL_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_SEL_RANGE                      17:12
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_SEL_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LOCK_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  Base PLLU charge pump setup control.
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_CPCON_SHIFT                 _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_CPCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_CPCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_CPCON_RANGE                 11:8
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_CPCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_CPCON_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_CPCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_CPCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_CPCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLU loop filter setup control.
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LFCON_SHIFT                 _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LFCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LFCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LFCON_RANGE                 7:4
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LFCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LFCON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LFCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LFCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_LFCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLU VCO range setup control.
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_VCOCON_SHIFT                        _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_VCOCON_FIELD                        (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_VCOCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_VCOCON_RANGE                        3:0
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_VCOCON_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_VCOCON_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_VCOCON_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_VCOCON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLU_MISC_0_PLLU_VCOCON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLLD_BASE_0  
#define CLK_RST_CONTROLLER_PLLD_BASE_0                  _MK_ADDR_CONST(0xd0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLD_BASE_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLD_BASE_0_RESET_VAL                        _MK_MASK_CONST(0x10c)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_RESET_MASK                       _MK_MASK_CONST(0xe873ff1f)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_READ_MASK                        _MK_MASK_CONST(0xe873ff1f)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_WRITE_MASK                       _MK_MASK_CONST(0xe073ff1f)
//  0 = no bypass, 1 = bypass.
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_BYPASS_SHIFT                        _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_BYPASS_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_BYPASS_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_BYPASS_RANGE                        31:31
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_BYPASS_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_BYPASS_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_BYPASS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_BYPASS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_BYPASS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_BYPASS_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_BYPASS_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_BYPASS_ENABLE                       _MK_ENUM_CONST(1)

//  0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_ENABLE_SHIFT                        _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_ENABLE_RANGE                        30:30
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_ENABLE_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_ENABLE_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_ENABLE_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_ENABLE_ENABLE                       _MK_ENUM_CONST(1)

//  0 = enable reference clk, 1 = disable reference clk.
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_REF_DIS_SHIFT                       _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_REF_DIS_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_REF_DIS_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_REF_DIS_RANGE                       29:29
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_REF_DIS_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_REF_DIS_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_REF_DIS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_REF_DIS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_REF_DIS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_REF_DIS_INIT_ENUM                   REF_ENABLE
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_REF_DIS_REF_ENABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_REF_DIS_REF_DISABLE                 _MK_ENUM_CONST(1)

//  0 = not lock, 1 = lock.
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_LOCK_SHIFT                  _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_LOCK_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_LOCK_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_LOCK_RANGE                  27:27
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_LOCK_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_LOCK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_LOCK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_LOCK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_LOCK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  0 = post divider (2^n).
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVP_SHIFT                  _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVP_FIELD                  (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVP_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVP_RANGE                  22:20
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVP_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVP_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVP_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  PLL feedback divider.
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVN_SHIFT                  _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVN_FIELD                  (_MK_MASK_CONST(0x3ff) << CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVN_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVN_RANGE                  17:8
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVN_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVN_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVN_DEFAULT_MASK                   _MK_MASK_CONST(0x3ff)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  PLL input divider.
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVM_SHIFT                  _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVM_FIELD                  (_MK_MASK_CONST(0x1f) << CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVM_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVM_RANGE                  4:0
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVM_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVM_DEFAULT                        _MK_MASK_CONST(0xc)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVM_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_BASE_0_PLLD_DIVM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 212 [0xd4] 

// Reserved address 216 [0xd8] 

// Register CLK_RST_CONTROLLER_PLLD_MISC_0  
#define CLK_RST_CONTROLLER_PLLD_MISC_0                  _MK_ADDR_CONST(0xdc)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLD_MISC_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLD_MISC_0_RESET_VAL                        _MK_MASK_CONST(0x100)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
//  1 = 5-125MHz, 0 = 40-1000MHz.
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_FO_MODE_SHIFT                       _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_FO_MODE_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_FO_MODE_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_FO_MODE_RANGE                       31:31
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_FO_MODE_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_FO_MODE_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_FO_MODE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_FO_MODE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_FO_MODE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  0 = disable, 1 = normal operation.
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CLKENABLE_SHIFT                     _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CLKENABLE_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CLKENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CLKENABLE_RANGE                     30:30
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CLKENABLE_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CLKENABLE_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CLKENABLE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CLKENABLE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CLKENABLE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//  Base PLLD test output select.
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_PTS_SHIFT                   _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_PTS_FIELD                   (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_PTS_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_PTS_RANGE                   29:27
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_PTS_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_PTS_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_PTS_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_PTS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_PTS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//  load pulse position adjust.
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOADADJ_SHIFT                       _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOADADJ_FIELD                       (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOADADJ_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOADADJ_RANGE                       26:24
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOADADJ_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOADADJ_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOADADJ_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOADADJ_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOADADJ_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  0 = normal operation, 1 = reset.
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DIV_RST_SHIFT                       _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DIV_RST_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DIV_RST_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DIV_RST_RANGE                       23:23
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DIV_RST_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DIV_RST_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DIV_RST_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DIV_RST_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DIV_RST_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  1 = enable, 0 = disable. 
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_ENABLE_SHIFT                   _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_ENABLE_RANGE                   22:22
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_ENABLE_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_ENABLE_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_ENABLE_ENABLE                  _MK_ENUM_CONST(1)

//  lock select.
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_SEL_SHIFT                      _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_SEL_FIELD                      (_MK_MASK_CONST(0x3f) << CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_SEL_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_SEL_RANGE                      21:16
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_SEL_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LOCK_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  Base PLLD DCCON control.
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DCCON_SHIFT                 _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DCCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DCCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DCCON_RANGE                 15:12
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DCCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DCCON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DCCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DCCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_DCCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLD charge pump setup control.
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CPCON_SHIFT                 _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CPCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CPCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CPCON_RANGE                 11:8
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CPCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CPCON_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CPCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CPCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_CPCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLD loop filter setup control.
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LFCON_SHIFT                 _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LFCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LFCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LFCON_RANGE                 7:4
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LFCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LFCON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LFCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LFCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_LFCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLD VCO range setup control.
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_VCOCON_SHIFT                        _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_VCOCON_FIELD                        (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_VCOCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_VCOCON_RANGE                        3:0
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_VCOCON_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_VCOCON_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_VCOCON_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_VCOCON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLD_MISC_0_PLLD_VCOCON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLLX_BASE_0  
#define CLK_RST_CONTROLLER_PLLX_BASE_0                  _MK_ADDR_CONST(0xe0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLX_BASE_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLX_BASE_0_RESET_VAL                        _MK_MASK_CONST(0x10c)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_RESET_MASK                       _MK_MASK_CONST(0xe873ff1f)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_READ_MASK                        _MK_MASK_CONST(0xe873ff1f)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_WRITE_MASK                       _MK_MASK_CONST(0xe073ff1f)
//  0 = no bypass, 1 = bypass.
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_BYPASS_SHIFT                        _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_BYPASS_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_BYPASS_SHIFT)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_BYPASS_RANGE                        31:31
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_BYPASS_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_BYPASS_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_BYPASS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_BYPASS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_BYPASS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_BYPASS_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_BYPASS_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_BYPASS_ENABLE                       _MK_ENUM_CONST(1)

//  0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_ENABLE_SHIFT                        _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_ENABLE_RANGE                        30:30
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_ENABLE_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_ENABLE_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_ENABLE_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_ENABLE_ENABLE                       _MK_ENUM_CONST(1)

//  0 = enable reference clk, 1 = disable reference clk.
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_REF_DIS_SHIFT                       _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_REF_DIS_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_REF_DIS_SHIFT)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_REF_DIS_RANGE                       29:29
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_REF_DIS_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_REF_DIS_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_REF_DIS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_REF_DIS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_REF_DIS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_REF_DIS_INIT_ENUM                   REF_ENABLE
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_REF_DIS_REF_ENABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_REF_DIS_REF_DISABLE                 _MK_ENUM_CONST(1)

//  0 = not lock, 1 = lock.
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_LOCK_SHIFT                  _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_LOCK_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_LOCK_SHIFT)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_LOCK_RANGE                  27:27
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_LOCK_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_LOCK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_LOCK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_LOCK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_LOCK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  0 = post divider (2^n).
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVP_SHIFT                  _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVP_FIELD                  (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVP_SHIFT)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVP_RANGE                  22:20
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVP_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVP_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVP_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  PLL feedback divider.
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVN_SHIFT                  _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVN_FIELD                  (_MK_MASK_CONST(0x3ff) << CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVN_SHIFT)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVN_RANGE                  17:8
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVN_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVN_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVN_DEFAULT_MASK                   _MK_MASK_CONST(0x3ff)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  PLL input divider.
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVM_SHIFT                  _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVM_FIELD                  (_MK_MASK_CONST(0x1f) << CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVM_SHIFT)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVM_RANGE                  4:0
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVM_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVM_DEFAULT                        _MK_MASK_CONST(0xc)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVM_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_BASE_0_PLLX_DIVM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLLX_MISC_0  
#define CLK_RST_CONTROLLER_PLLX_MISC_0                  _MK_ADDR_CONST(0xe4)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLX_MISC_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLX_MISC_0_RESET_VAL                        _MK_MASK_CONST(0x100100)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_RESET_MASK                       _MK_MASK_CONST(0xfd7ffff)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_READ_MASK                        _MK_MASK_CONST(0xfd7ffff)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_WRITE_MASK                       _MK_MASK_CONST(0xfd7ffff)
//  Base PLLX setup.
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_SETUP_SHIFT                 _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_SETUP_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_SETUP_SHIFT)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_SETUP_RANGE                 27:24
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_SETUP_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_SETUP_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_SETUP_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_SETUP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_SETUP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLX test output select.
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_PTS_SHIFT                   _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_PTS_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_PTS_SHIFT)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_PTS_RANGE                   23:22
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_PTS_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_PTS_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_PTS_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_PTS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_PTS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//  Base PLLX DCCON control.
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_DCCON_SHIFT                 _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_DCCON_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_DCCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_DCCON_RANGE                 20:20
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_DCCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_DCCON_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_DCCON_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_DCCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_DCCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  1 = enable, 0 = disable. 
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_ENABLE_SHIFT                   _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_ENABLE_RANGE                   18:18
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_ENABLE_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_ENABLE_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_ENABLE_ENABLE                  _MK_ENUM_CONST(1)

//  lock select.
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_SEL_SHIFT                      _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_SEL_FIELD                      (_MK_MASK_CONST(0x3f) << CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_SEL_SHIFT)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_SEL_RANGE                      17:12
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_SEL_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LOCK_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  Base PLLX charge pump setup control.
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_CPCON_SHIFT                 _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_CPCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_CPCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_CPCON_RANGE                 11:8
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_CPCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_CPCON_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_CPCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_CPCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_CPCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLX loop filter setup control.
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LFCON_SHIFT                 _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LFCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LFCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LFCON_RANGE                 7:4
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LFCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LFCON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LFCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LFCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_LFCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLX VCO range setup control.
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_VCOCON_SHIFT                        _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_VCOCON_FIELD                        (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_VCOCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_VCOCON_RANGE                        3:0
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_VCOCON_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_VCOCON_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_VCOCON_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_VCOCON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLX_MISC_0_PLLX_VCOCON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLLE_BASE_0  
#define CLK_RST_CONTROLLER_PLLE_BASE_0                  _MK_ADDR_CONST(0xe8)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLE_BASE_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLE_BASE_0_RESET_VAL                        _MK_MASK_CONST(0xd18c801)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
//  Enable CML pdivider. 0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_CML_SHIFT                    _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_CML_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_CML_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_CML_RANGE                    31:31
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_CML_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_CML_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_CML_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_CML_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_CML_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_CML_INIT_ENUM                        DISABLE
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_CML_DISABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_CML_ENABLE                   _MK_ENUM_CONST(1)

//  PLL enable. 0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_SHIFT                        _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_RANGE                        30:30
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_ENABLE_ENABLE                       _MK_ENUM_CONST(1)

//  Forces PLL_LOCK to 1.
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_LOCK_OVERRIDE_SHIFT                 _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_LOCK_OVERRIDE_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_LOCK_OVERRIDE_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_LOCK_OVERRIDE_RANGE                 29:29
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_LOCK_OVERRIDE_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_LOCK_OVERRIDE_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_LOCK_OVERRIDE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_LOCK_OVERRIDE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_LOCK_OVERRIDE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  0 gives vcoclk/4, 1 gives vcoclk/2 clock to the interpolator logic. Normally set to zero.
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_FDIV4B_SHIFT                        _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_FDIV4B_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_FDIV4B_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_FDIV4B_RANGE                        28:28
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_FDIV4B_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_FDIV4B_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_FDIV4B_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_FDIV4B_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_FDIV4B_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//  divider control for CLOCKOUT_CML/CLOCKOUTB_CML.
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_CML_SHIFT                     _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_CML_FIELD                     (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_CML_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_CML_RANGE                     27:24
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_CML_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_CML_DEFAULT                   _MK_MASK_CONST(0xd)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_CML_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_CML_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_CML_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//  Base PLLE setup[19:18].
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_EXT_SETUP_19_18_SHIFT                       _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_EXT_SETUP_19_18_FIELD                       (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_EXT_SETUP_19_18_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_EXT_SETUP_19_18_RANGE                       23:22
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_EXT_SETUP_19_18_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_EXT_SETUP_19_18_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_EXT_SETUP_19_18_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_EXT_SETUP_19_18_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_EXT_SETUP_19_18_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  post divider for CLOCKOUT and SYNC_CLOCKOUT.
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_SHIFT                 _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_FIELD                 (_MK_MASK_CONST(0x3f) << CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_RANGE                 21:16
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_DEFAULT                       _MK_MASK_CONST(0x18)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_DEFAULT_MASK                  _MK_MASK_CONST(0x3f)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_PLDIV_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  feedback divider.
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_NDIV_SHIFT                  _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_NDIV_FIELD                  (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_NDIV_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_NDIV_RANGE                  15:8
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_NDIV_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_NDIV_DEFAULT                        _MK_MASK_CONST(0xc8)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_NDIV_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_NDIV_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_NDIV_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  input divider.
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_MDIV_SHIFT                  _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_MDIV_FIELD                  (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_MDIV_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_MDIV_RANGE                  7:0
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_MDIV_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_MDIV_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_MDIV_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_MDIV_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_BASE_0_PLLE_MDIV_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLLE_MISC_0  
#define CLK_RST_CONTROLLER_PLLE_MISC_0                  _MK_ADDR_CONST(0xec)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLE_MISC_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLE_MISC_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_WRITE_MASK                       _MK_MASK_CONST(0xffff07ff)
//  Base PLLE setup[15:0].
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SETUP_SHIFT                 _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SETUP_FIELD                 (_MK_MASK_CONST(0xffff) << CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SETUP_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SETUP_RANGE                 31:16
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SETUP_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SETUP_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SETUP_DEFAULT_MASK                  _MK_MASK_CONST(0xffff)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SETUP_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SETUP_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  When read, this is PLL_READY status: 1 = PLL finish training, 0 = PLL not finish training.
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PLL_READY_SHIFT                     _MK_SHIFT_CONST(15)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PLL_READY_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PLL_READY_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PLL_READY_RANGE                     15:15
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PLL_READY_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PLL_READY_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PLL_READY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PLL_READY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PLL_READY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//  Process monitor debug output.
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_MON_TESTOUT_SHIFT                   _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_MON_TESTOUT_FIELD                   (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_MON_TESTOUT_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_MON_TESTOUT_RANGE                   14:12
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_MON_TESTOUT_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_MON_TESTOUT_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_MON_TESTOUT_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_MON_TESTOUT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_MON_TESTOUT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//  0 = not lock, 1 = lock.
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_SHIFT                  _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_RANGE                  11:11
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  0 = enable reference clk, 1 = disable reference clk.
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_REF_DIS_SHIFT                       _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_REF_DIS_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_REF_DIS_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_REF_DIS_RANGE                       10:10
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_REF_DIS_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_REF_DIS_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_REF_DIS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_REF_DIS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_REF_DIS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_REF_DIS_INIT_ENUM                   REF_ENABLE
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_REF_DIS_REF_ENABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_REF_DIS_REF_DISABLE                 _MK_ENUM_CONST(1)

//  1 = enable, 0 = disable. 
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_ENABLE_SHIFT                   _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_ENABLE_RANGE                   9:9
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_ENABLE_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_ENABLE_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LOCK_ENABLE_ENABLE                  _MK_ENUM_CONST(1)

//  Bypass PLL (similar to PTO control of other PLL).
//  0 = PTO always 0 if PLLE_ENABLE=0 (SYN_CLOCKOUT=0), 
//  0 = PTO = PLLE CLOCKIN if PLLE_ENABLE=1,
//  1 = PTO = PLLE FO (SYN_CLOCKOUT=VCOCLOCK/PLDIV).
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PTS_SHIFT                   _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PTS_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PTS_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PTS_RANGE                   8:8
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PTS_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PTS_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PTS_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PTS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_PTS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//  Base PLLE charge pump gain control.
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KCP_SHIFT                   _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KCP_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KCP_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KCP_RANGE                   7:6
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KCP_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KCP_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KCP_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KCP_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KCP_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//  Base PLLE loop filter resistor control.
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LFRES_SHIFT                 _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LFRES_FIELD                 (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LFRES_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LFRES_RANGE                 5:4
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LFRES_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LFRES_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LFRES_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LFRES_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_LFRES_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLE setup[17:16].
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_EXT_SETUP_17_16_SHIFT                       _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_EXT_SETUP_17_16_FIELD                       (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_EXT_SETUP_17_16_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_EXT_SETUP_17_16_RANGE                       3:2
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_EXT_SETUP_17_16_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_EXT_SETUP_17_16_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_EXT_SETUP_17_16_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_EXT_SETUP_17_16_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_EXT_SETUP_17_16_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  Base PLLE sync mode (leave it at 0).
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SYNC_MODE_SHIFT                     _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SYNC_MODE_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SYNC_MODE_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SYNC_MODE_RANGE                     1:1
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SYNC_MODE_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SYNC_MODE_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SYNC_MODE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SYNC_MODE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_SYNC_MODE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//  Base PLLE VCO gain.
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KVCO_SHIFT                  _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KVCO_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KVCO_SHIFT)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KVCO_RANGE                  0:0
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KVCO_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KVCO_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KVCO_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KVCO_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLE_MISC_0_PLLE_KVCO_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLLS_BASE_0  
#define CLK_RST_CONTROLLER_PLLS_BASE_0                  _MK_ADDR_CONST(0xf0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLS_BASE_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLS_BASE_0_RESET_VAL                        _MK_MASK_CONST(0x101)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_RESET_MASK                       _MK_MASK_CONST(0xe873ff0f)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_READ_MASK                        _MK_MASK_CONST(0xe873ff0f)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_WRITE_MASK                       _MK_MASK_CONST(0xe073ff0f)
//  0 = no bypass, 1 = bypass.
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_BYPASS_SHIFT                        _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_BYPASS_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_BYPASS_SHIFT)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_BYPASS_RANGE                        31:31
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_BYPASS_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_BYPASS_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_BYPASS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_BYPASS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_BYPASS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_BYPASS_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_BYPASS_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_BYPASS_ENABLE                       _MK_ENUM_CONST(1)

//  0 = disable, 1 = enable.
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_ENABLE_SHIFT                        _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_ENABLE_RANGE                        30:30
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_ENABLE_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_ENABLE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_ENABLE_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_ENABLE_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_ENABLE_ENABLE                       _MK_ENUM_CONST(1)

//  0 = enable reference clk, 1 = disable reference clk.
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_REF_DIS_SHIFT                       _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_REF_DIS_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_REF_DIS_SHIFT)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_REF_DIS_RANGE                       29:29
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_REF_DIS_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_REF_DIS_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_REF_DIS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_REF_DIS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_REF_DIS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_REF_DIS_INIT_ENUM                   REF_ENABLE
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_REF_DIS_REF_ENABLE                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_REF_DIS_REF_DISABLE                 _MK_ENUM_CONST(1)

//  0 = not lock, 1 = lock.
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_LOCK_SHIFT                  _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_LOCK_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_LOCK_SHIFT)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_LOCK_RANGE                  27:27
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_LOCK_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_LOCK_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_LOCK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_LOCK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_LOCK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  0 = post divider (2^n).
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVP_SHIFT                  _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVP_FIELD                  (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVP_SHIFT)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVP_RANGE                  22:20
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVP_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVP_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVP_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  PLL feedback divider.
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVN_SHIFT                  _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVN_FIELD                  (_MK_MASK_CONST(0x3ff) << CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVN_SHIFT)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVN_RANGE                  17:8
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVN_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVN_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVN_DEFAULT_MASK                   _MK_MASK_CONST(0x3ff)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  PLL input divider.
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVM_SHIFT                  _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVM_FIELD                  (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVM_SHIFT)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVM_RANGE                  3:0
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVM_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVM_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVM_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_BASE_0_PLLS_DIVM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_PLLS_MISC_0  
#define CLK_RST_CONTROLLER_PLLS_MISC_0                  _MK_ADDR_CONST(0xf4)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_PLLS_MISC_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_PLLS_MISC_0_RESET_VAL                        _MK_MASK_CONST(0x100)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_RESET_MASK                       _MK_MASK_CONST(0xc7ffff)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_READ_MASK                        _MK_MASK_CONST(0xc7ffff)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_WRITE_MASK                       _MK_MASK_CONST(0xc7ffff)
//  Base PLLS test output select.
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_PTS_SHIFT                   _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_PTS_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_PTS_SHIFT)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_PTS_RANGE                   23:22
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_PTS_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_PTS_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_PTS_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_PTS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_PTS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//  1 = enable, 0 = disable. 
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_ENABLE_SHIFT                   _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_ENABLE_SHIFT)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_ENABLE_RANGE                   18:18
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_ENABLE_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_ENABLE_DISABLE                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_ENABLE_ENABLE                  _MK_ENUM_CONST(1)

//  lock select.
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_SEL_SHIFT                      _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_SEL_FIELD                      (_MK_MASK_CONST(0x3f) << CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_SEL_SHIFT)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_SEL_RANGE                      17:12
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_SEL_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LOCK_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  Base PLLS charge pump setup control.
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_CPCON_SHIFT                 _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_CPCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_CPCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_CPCON_RANGE                 11:8
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_CPCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_CPCON_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_CPCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_CPCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_CPCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLS loop filter setup control.
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LFCON_SHIFT                 _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LFCON_FIELD                 (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LFCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LFCON_RANGE                 7:4
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LFCON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LFCON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LFCON_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LFCON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_LFCON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//  Base PLLS VCO range setup control.
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_VCOCON_SHIFT                        _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_VCOCON_FIELD                        (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_VCOCON_SHIFT)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_VCOCON_RANGE                        3:0
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_VCOCON_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_VCOCON_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_VCOCON_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_VCOCON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_PLLS_MISC_0_PLLS_VCOCON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0  
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0                 _MK_ADDR_CONST(0xf8)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_SECURE                  0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_WORD_COUNT                      0x1
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_RESET_MASK                      _MK_MASK_CONST(0xfffffffe)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_READ_MASK                       _MK_MASK_CONST(0xfffffffe)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_WRITE_MASK                      _MK_MASK_CONST(0xfffffffe)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_TVDAC_CLK_OVR_ON_SHIFT                  _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_TVDAC_CLK_OVR_ON_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_TVDAC_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_TVDAC_CLK_OVR_ON_RANGE                  31:31
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_TVDAC_CLK_OVR_ON_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_TVDAC_CLK_OVR_ON_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_TVDAC_CLK_OVR_ON_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_TVDAC_CLK_OVR_ON_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_TVDAC_CLK_OVR_ON_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_PPCS_CLK_OVR_ON_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_PPCS_CLK_OVR_ON_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_PPCS_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_PPCS_CLK_OVR_ON_RANGE                   30:30
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_PPCS_CLK_OVR_ON_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_PPCS_CLK_OVR_ON_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_PPCS_CLK_OVR_ON_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_PPCS_CLK_OVR_ON_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_PPCS_CLK_OVR_ON_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEA_CLK_OVR_ON_SHIFT                   _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEA_CLK_OVR_ON_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEA_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEA_CLK_OVR_ON_RANGE                   29:29
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEA_CLK_OVR_ON_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEA_CLK_OVR_ON_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEA_CLK_OVR_ON_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEA_CLK_OVR_ON_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEA_CLK_OVR_ON_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEV_CLK_OVR_ON_SHIFT                   _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEV_CLK_OVR_ON_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEV_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEV_CLK_OVR_ON_RANGE                   28:28
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEV_CLK_OVR_ON_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEV_CLK_OVR_ON_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEV_CLK_OVR_ON_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEV_CLK_OVR_ON_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_BSEV_CLK_OVR_ON_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VDE_CLK_OVR_ON_SHIFT                    _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VDE_CLK_OVR_ON_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VDE_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VDE_CLK_OVR_ON_RANGE                    27:27
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VDE_CLK_OVR_ON_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VDE_CLK_OVR_ON_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VDE_CLK_OVR_ON_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VDE_CLK_OVR_ON_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VDE_CLK_OVR_ON_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_VPECLK_OVR_ON_SHIFT                        _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_VPECLK_OVR_ON_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_VPECLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_VPECLK_OVR_ON_RANGE                        26:26
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_VPECLK_OVR_ON_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_VPECLK_OVR_ON_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_VPECLK_OVR_ON_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_VPECLK_OVR_ON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_VPECLK_OVR_ON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_TEXCLK_OVR_ON_SHIFT                        _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_TEXCLK_OVR_ON_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_TEXCLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_TEXCLK_OVR_ON_RANGE                        25:25
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_TEXCLK_OVR_ON_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_TEXCLK_OVR_ON_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_TEXCLK_OVR_ON_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_TEXCLK_OVR_ON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_TEXCLK_OVR_ON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_SETUPCLK_OVR_ON_SHIFT                      _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_SETUPCLK_OVR_ON_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_SETUPCLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_SETUPCLK_OVR_ON_RANGE                      24:24
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_SETUPCLK_OVR_ON_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_SETUPCLK_OVR_ON_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_SETUPCLK_OVR_ON_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_SETUPCLK_OVR_ON_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_SETUPCLK_OVR_ON_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_QRASTCLK_OVR_ON_SHIFT                      _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_QRASTCLK_OVR_ON_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_QRASTCLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_QRASTCLK_OVR_ON_RANGE                      23:23
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_QRASTCLK_OVR_ON_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_QRASTCLK_OVR_ON_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_QRASTCLK_OVR_ON_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_QRASTCLK_OVR_ON_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_QRASTCLK_OVR_ON_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_PSEQCLK_OVR_ON_SHIFT                       _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_PSEQCLK_OVR_ON_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_PSEQCLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_PSEQCLK_OVR_ON_RANGE                       22:22
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_PSEQCLK_OVR_ON_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_PSEQCLK_OVR_ON_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_PSEQCLK_OVR_ON_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_PSEQCLK_OVR_ON_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_PSEQCLK_OVR_ON_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_IDXCLK_OVR_ON_SHIFT                        _MK_SHIFT_CONST(21)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_IDXCLK_OVR_ON_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_IDXCLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_IDXCLK_OVR_ON_RANGE                        21:21
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_IDXCLK_OVR_ON_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_IDXCLK_OVR_ON_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_IDXCLK_OVR_ON_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_IDXCLK_OVR_ON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_IDXCLK_OVR_ON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_FDCCLK_OVR_ON_SHIFT                        _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_FDCCLK_OVR_ON_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_FDCCLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_FDCCLK_OVR_ON_RANGE                        20:20
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_FDCCLK_OVR_ON_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_FDCCLK_OVR_ON_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_FDCCLK_OVR_ON_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_FDCCLK_OVR_ON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_FDCCLK_OVR_ON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_DWRCLK_OVR_ON_SHIFT                        _MK_SHIFT_CONST(19)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_DWRCLK_OVR_ON_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_DWRCLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_DWRCLK_OVR_ON_RANGE                        19:19
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_DWRCLK_OVR_ON_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_DWRCLK_OVR_ON_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_DWRCLK_OVR_ON_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_DWRCLK_OVR_ON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_DWRCLK_OVR_ON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_CLIPCLK_OVR_ON_SHIFT                       _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_CLIPCLK_OVR_ON_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_CLIPCLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_CLIPCLK_OVR_ON_RANGE                       18:18
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_CLIPCLK_OVR_ON_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_CLIPCLK_OVR_ON_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_CLIPCLK_OVR_ON_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_CLIPCLK_OVR_ON_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_CLIPCLK_OVR_ON_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ATRASTCLK_OVR_ON_SHIFT                     _MK_SHIFT_CONST(17)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ATRASTCLK_OVR_ON_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ATRASTCLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ATRASTCLK_OVR_ON_RANGE                     17:17
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ATRASTCLK_OVR_ON_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ATRASTCLK_OVR_ON_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ATRASTCLK_OVR_ON_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ATRASTCLK_OVR_ON_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ATRASTCLK_OVR_ON_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ALUCLK_OVR_ON_SHIFT                        _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ALUCLK_OVR_ON_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ALUCLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ALUCLK_OVR_ON_RANGE                        16:16
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ALUCLK_OVR_ON_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ALUCLK_OVR_ON_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ALUCLK_OVR_ON_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ALUCLK_OVR_ON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR3D_ALUCLK_OVR_ON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VI_CLK_OVR_ON_SHIFT                     _MK_SHIFT_CONST(15)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VI_CLK_OVR_ON_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VI_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VI_CLK_OVR_ON_RANGE                     15:15
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VI_CLK_OVR_ON_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VI_CLK_OVR_ON_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VI_CLK_OVR_ON_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VI_CLK_OVR_ON_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_VI_CLK_OVR_ON_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPE_CLK_OVR_ON_SHIFT                    _MK_SHIFT_CONST(14)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPE_CLK_OVR_ON_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPE_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPE_CLK_OVR_ON_RANGE                    14:14
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPE_CLK_OVR_ON_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPE_CLK_OVR_ON_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPE_CLK_OVR_ON_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPE_CLK_OVR_ON_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPE_CLK_OVR_ON_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPCORE_CLK_OVR_ON_SHIFT                 _MK_SHIFT_CONST(13)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPCORE_CLK_OVR_ON_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPCORE_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPCORE_CLK_OVR_ON_RANGE                 13:13
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPCORE_CLK_OVR_ON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPCORE_CLK_OVR_ON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPCORE_CLK_OVR_ON_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPCORE_CLK_OVR_ON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MPCORE_CLK_OVR_ON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MC_CLK_OVR_ON_SHIFT                     _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MC_CLK_OVR_ON_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MC_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MC_CLK_OVR_ON_RANGE                     12:12
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MC_CLK_OVR_ON_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MC_CLK_OVR_ON_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MC_CLK_OVR_ON_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MC_CLK_OVR_ON_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_MC_CLK_OVR_ON_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_KBC_CLK_OVR_ON_SHIFT                    _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_KBC_CLK_OVR_ON_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_KBC_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_KBC_CLK_OVR_ON_RANGE                    11:11
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_KBC_CLK_OVR_ON_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_KBC_CLK_OVR_ON_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_KBC_CLK_OVR_ON_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_KBC_CLK_OVR_ON_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_KBC_CLK_OVR_ON_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RIF_CLK_OVR_ON_SHIFT                 _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RIF_CLK_OVR_ON_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RIF_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RIF_CLK_OVR_ON_RANGE                 10:10
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RIF_CLK_OVR_ON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RIF_CLK_OVR_ON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RIF_CLK_OVR_ON_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RIF_CLK_OVR_ON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RIF_CLK_OVR_ON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RDMA_CLK_OVR_ON_SHIFT                        _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RDMA_CLK_OVR_ON_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RDMA_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RDMA_CLK_OVR_ON_RANGE                        9:9
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RDMA_CLK_OVR_ON_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RDMA_CLK_OVR_ON_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RDMA_CLK_OVR_ON_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RDMA_CLK_OVR_ON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_RDMA_CLK_OVR_ON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_INTFC_OVR_ON_SHIFT                   _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_INTFC_OVR_ON_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_INTFC_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_INTFC_OVR_ON_RANGE                   8:8
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_INTFC_OVR_ON_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_INTFC_OVR_ON_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_INTFC_OVR_ON_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_INTFC_OVR_ON_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_INTFC_OVR_ON_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CLK_OVR_ON_SHIFT                     _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CLK_OVR_ON_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CLK_OVR_ON_RANGE                     7:7
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CLK_OVR_ON_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CLK_OVR_ON_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CLK_OVR_ON_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CLK_OVR_ON_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CLK_OVR_ON_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CDMA_CLK_OVR_ON_SHIFT                        _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CDMA_CLK_OVR_ON_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CDMA_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CDMA_CLK_OVR_ON_RANGE                        6:6
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CDMA_CLK_OVR_ON_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CDMA_CLK_OVR_ON_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CDMA_CLK_OVR_ON_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CDMA_CLK_OVR_ON_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_HC_CDMA_CLK_OVR_ON_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR2D_CLK_OVR_ON_SHIFT                   _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR2D_CLK_OVR_ON_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR2D_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR2D_CLK_OVR_ON_RANGE                   5:5
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR2D_CLK_OVR_ON_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR2D_CLK_OVR_ON_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR2D_CLK_OVR_ON_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR2D_CLK_OVR_ON_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_GR2D_CLK_OVR_ON_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EPP_CLK_OVR_ON_SHIFT                    _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EPP_CLK_OVR_ON_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EPP_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EPP_CLK_OVR_ON_RANGE                    4:4
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EPP_CLK_OVR_ON_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EPP_CLK_OVR_ON_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EPP_CLK_OVR_ON_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EPP_CLK_OVR_ON_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EPP_CLK_OVR_ON_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EMC_CLK_OVR_ON_SHIFT                    _MK_SHIFT_CONST(3)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EMC_CLK_OVR_ON_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EMC_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EMC_CLK_OVR_ON_RANGE                    3:3
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EMC_CLK_OVR_ON_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EMC_CLK_OVR_ON_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EMC_CLK_OVR_ON_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EMC_CLK_OVR_ON_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_EMC_CLK_OVR_ON_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DCB_CLK_OVR_ON_SHIFT                    _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DCB_CLK_OVR_ON_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DCB_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DCB_CLK_OVR_ON_RANGE                    2:2
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DCB_CLK_OVR_ON_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DCB_CLK_OVR_ON_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DCB_CLK_OVR_ON_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DCB_CLK_OVR_ON_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DCB_CLK_OVR_ON_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DC_CLK_OVR_ON_SHIFT                     _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DC_CLK_OVR_ON_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DC_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DC_CLK_OVR_ON_RANGE                     1:1
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DC_CLK_OVR_ON_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DC_CLK_OVR_ON_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DC_CLK_OVR_ON_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DC_CLK_OVR_ON_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRA_0_DC_CLK_OVR_ON_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0  
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0                 _MK_ADDR_CONST(0xfc)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_SECURE                  0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_WORD_COUNT                      0x1
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_RESET_MASK                      _MK_MASK_CONST(0x3fff)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_READ_MASK                       _MK_MASK_CONST(0x3fff)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_WRITE_MASK                      _MK_MASK_CONST(0x3fff)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB1_CLK_OVR_ON_SHIFT                   _MK_SHIFT_CONST(13)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB1_CLK_OVR_ON_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB1_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB1_CLK_OVR_ON_RANGE                   13:13
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB1_CLK_OVR_ON_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB1_CLK_OVR_ON_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB1_CLK_OVR_ON_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB1_CLK_OVR_ON_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB1_CLK_OVR_ON_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB3_CLK_OVR_ON_SHIFT                   _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB3_CLK_OVR_ON_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB3_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB3_CLK_OVR_ON_RANGE                   12:12
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB3_CLK_OVR_ON_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB3_CLK_OVR_ON_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB3_CLK_OVR_ON_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB3_CLK_OVR_ON_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB3_CLK_OVR_ON_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_AVPC_CLK_OVR_ON_SHIFT                   _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_AVPC_CLK_OVR_ON_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_AVPC_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_AVPC_CLK_OVR_ON_RANGE                   11:11
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_AVPC_CLK_OVR_ON_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_AVPC_CLK_OVR_ON_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_AVPC_CLK_OVR_ON_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_AVPC_CLK_OVR_ON_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_AVPC_CLK_OVR_ON_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB2_CLK_OVR_ON_SHIFT                   _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB2_CLK_OVR_ON_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB2_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB2_CLK_OVR_ON_RANGE                   10:10
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB2_CLK_OVR_ON_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB2_CLK_OVR_ON_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB2_CLK_OVR_ON_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB2_CLK_OVR_ON_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_USB2_CLK_OVR_ON_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEC_CLK_OVR_ON_SHIFT                       _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEC_CLK_OVR_ON_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEC_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEC_CLK_OVR_ON_RANGE                       9:9
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEC_CLK_OVR_ON_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEC_CLK_OVR_ON_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEC_CLK_OVR_ON_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEC_CLK_OVR_ON_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEC_CLK_OVR_ON_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEB_CLK_OVR_ON_SHIFT                       _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEB_CLK_OVR_ON_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEB_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEB_CLK_OVR_ON_RANGE                       8:8
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEB_CLK_OVR_ON_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEB_CLK_OVR_ON_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEB_CLK_OVR_ON_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEB_CLK_OVR_ON_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEB_CLK_OVR_ON_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_REGS_CLK_OVR_ON_SHIFT                       _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_REGS_CLK_OVR_ON_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_REGS_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_REGS_CLK_OVR_ON_RANGE                       7:7
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_REGS_CLK_OVR_ON_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_REGS_CLK_OVR_ON_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_REGS_CLK_OVR_ON_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_REGS_CLK_OVR_ON_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_REGS_CLK_OVR_ON_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEA_CLK_OVR_ON_SHIFT                       _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEA_CLK_OVR_ON_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEA_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEA_CLK_OVR_ON_RANGE                       6:6
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEA_CLK_OVR_ON_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEA_CLK_OVR_ON_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEA_CLK_OVR_ON_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEA_CLK_OVR_ON_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MPEA_CLK_OVR_ON_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_PMEM_CLK_OVR_ON_SHIFT                       _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_PMEM_CLK_OVR_ON_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_PMEM_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_PMEM_CLK_OVR_ON_RANGE                       5:5
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_PMEM_CLK_OVR_ON_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_PMEM_CLK_OVR_ON_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_PMEM_CLK_OVR_ON_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_PMEM_CLK_OVR_ON_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_PMEM_CLK_OVR_ON_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_IB_CLK_OVR_ON_SHIFT                 _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_IB_CLK_OVR_ON_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_IB_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_IB_CLK_OVR_ON_RANGE                 4:4
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_IB_CLK_OVR_ON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_IB_CLK_OVR_ON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_IB_CLK_OVR_ON_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_IB_CLK_OVR_ON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_IB_CLK_OVR_ON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MEMRD_CLK_OVR_ON_SHIFT                      _MK_SHIFT_CONST(3)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MEMRD_CLK_OVR_ON_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MEMRD_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MEMRD_CLK_OVR_ON_RANGE                      3:3
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MEMRD_CLK_OVR_ON_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MEMRD_CLK_OVR_ON_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MEMRD_CLK_OVR_ON_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MEMRD_CLK_OVR_ON_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_MEMRD_CLK_OVR_ON_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_RC_CLK_OVR_ON_SHIFT                 _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_RC_CLK_OVR_ON_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_RC_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_RC_CLK_OVR_ON_RANGE                 2:2
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_RC_CLK_OVR_ON_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_RC_CLK_OVR_ON_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_RC_CLK_OVR_ON_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_RC_CLK_OVR_ON_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_MPE_RC_CLK_OVR_ON_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_CSI_CLK_OVR_ON_SHIFT                    _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_CSI_CLK_OVR_ON_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_CSI_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_CSI_CLK_OVR_ON_RANGE                    1:1
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_CSI_CLK_OVR_ON_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_CSI_CLK_OVR_ON_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_CSI_CLK_OVR_ON_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_CSI_CLK_OVR_ON_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_CSI_CLK_OVR_ON_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_RTC_CLK_OVR_ON_SHIFT                    _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_RTC_CLK_OVR_ON_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_RTC_CLK_OVR_ON_SHIFT)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_RTC_CLK_OVR_ON_RANGE                    0:0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_RTC_CLK_OVR_ON_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_RTC_CLK_OVR_ON_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_RTC_CLK_OVR_ON_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_RTC_CLK_OVR_ON_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LVL2_CLK_GATE_OVRB_0_RTC_CLK_OVR_ON_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0                    _MK_ADDR_CONST(0x100)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_SECURE                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_WORD_COUNT                         0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_RESET_VAL                  _MK_MASK_CONST(0xd0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_RESET_MASK                         _MK_MASK_CONST(0xd00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_READ_MASK                  _MK_MASK_CONST(0xd00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_WRITE_MASK                         _MK_MASK_CONST(0xd00000ff)
//  00 = pllA_out0
//  01 = audio SYNC_CLK x 2
//  10 = pllP_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_SRC_SHIFT                 _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_SRC_FIELD                 (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_SRC_RANGE                 31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_SRC_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_SRC_DEFAULT                       _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_SRC_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_SRC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_SRC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_SRC_INIT_ENUM                     CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_SRC_PLLA_OUT0                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_SRC_SYNC_CLK_X2                   _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_SRC_PLLP_OUT0                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_SRC_CLK_M                 _MK_ENUM_CONST(3)

// 1 = enable I2S1 master clock, disable I2S1 master clock.
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_MASTER_CLKEN_SHIFT                    _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_MASTER_CLKEN_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_MASTER_CLKEN_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_MASTER_CLKEN_RANGE                    28:28
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_MASTER_CLKEN_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_MASTER_CLKEN_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_MASTER_CLKEN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_MASTER_CLKEN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_MASTER_CLKEN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//  N  = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_DIVISOR_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_DIVISOR_FIELD                     (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_DIVISOR_RANGE                     7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_DIVISOR_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_DIVISOR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_DIVISOR_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_DIVISOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S1_0_I2S1_CLK_DIVISOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0                    _MK_ADDR_CONST(0x104)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_SECURE                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_WORD_COUNT                         0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_RESET_VAL                  _MK_MASK_CONST(0xd0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_RESET_MASK                         _MK_MASK_CONST(0xd00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_READ_MASK                  _MK_MASK_CONST(0xd00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_WRITE_MASK                         _MK_MASK_CONST(0xd00000ff)
//  00 = pllA_out0
//  01 = audio SYNC_CLK x 2
//  10 = pllP_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_SRC_SHIFT                 _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_SRC_FIELD                 (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_SRC_RANGE                 31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_SRC_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_SRC_DEFAULT                       _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_SRC_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_SRC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_SRC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_SRC_INIT_ENUM                     CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_SRC_PLLA_OUT0                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_SRC_SYNC_CLK_X2                   _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_SRC_PLLP_OUT0                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_SRC_CLK_M                 _MK_ENUM_CONST(3)

// 1 = enable I2S2 master clock, disable I2S2 master clock.
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_MASTER_CLKEN_SHIFT                    _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_MASTER_CLKEN_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_MASTER_CLKEN_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_MASTER_CLKEN_RANGE                    28:28
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_MASTER_CLKEN_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_MASTER_CLKEN_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_MASTER_CLKEN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_MASTER_CLKEN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_MASTER_CLKEN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//  N  = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_DIVISOR_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_DIVISOR_FIELD                     (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_DIVISOR_RANGE                     7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_DIVISOR_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_DIVISOR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_DIVISOR_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_DIVISOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2S2_0_I2S2_CLK_DIVISOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0                       _MK_ADDR_CONST(0x108)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SECURE                        0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_WORD_COUNT                    0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_RESET_VAL                     _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_RESET_MASK                    _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_READ_MASK                     _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_WRITE_MASK                    _MK_MASK_CONST(0xc00000ff)
//  00 = pllA_out0
//  01 = audio SYNC_CLK x 2
//  10 = pllP_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_SRC_SHIFT                        _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_SRC_FIELD                        (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_SRC_RANGE                        31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_SRC_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_SRC_DEFAULT                      _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_SRC_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_SRC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_SRC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_SRC_INIT_ENUM                    CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_SRC_PLLA_OUT0                    _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_SRC_SYNC_CLK_X2                  _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_SRC_PLLP_OUT0                    _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_SRC_CLK_M                        _MK_ENUM_CONST(3)

//  N  = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_DIVISOR_SHIFT                    _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_DIVISOR_FIELD                    (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_DIVISOR_RANGE                    7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_DIVISOR_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_DIVISOR_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_DIVISOR_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_DIVISOR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_OUT_0_SPDIFOUT_CLK_DIVISOR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0                        _MK_ADDR_CONST(0x10c)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SECURE                         0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_WORD_COUNT                     0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_RESET_MASK                     _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_READ_MASK                      _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_WRITE_MASK                     _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = 1'b0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_SRC_SHIFT                  _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_SRC_FIELD                  (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_SRC_RANGE                  31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_SRC_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_SRC_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_SRC_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_SRC_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_SRC_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_SRC_INIT_ENUM                      PLLP_OUT0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_SRC_PLLP_OUT0                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_SRC_PLLC_OUT0                      _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_SRC_PLLM_OUT0                      _MK_ENUM_CONST(2)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_DIVISOR_SHIFT                      _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_DIVISOR_FIELD                      (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_DIVISOR_RANGE                      7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_DIVISOR_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_DIVISOR_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_DIVISOR_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_DIVISOR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPDIF_IN_0_SPDIFIN_CLK_DIVISOR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0                     _MK_ADDR_CONST(0x110)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_SECURE                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_WORD_COUNT                  0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_RESET_VAL                   _MK_MASK_CONST(0x30000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_RESET_MASK                  _MK_MASK_CONST(0x700000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_READ_MASK                   _MK_MASK_CONST(0x700000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_WRITE_MASK                  _MK_MASK_CONST(0x700000ff)
//  000 = pllP_out0
//  001 = pllC_out0
//  010 = audio SYNC_CLK x 2
//  011 = clk_m
//  100 = clk_s
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_SRC_SHIFT                   _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_SRC_FIELD                   (_MK_MASK_CONST(0x7) << CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_SRC_RANGE                   30:28
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_SRC_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_SRC_DEFAULT                 _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_SRC_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_SRC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_SRC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_SRC_INIT_ENUM                       CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_SRC_PLLP_OUT0                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_SRC_PLLC_OUT0                       _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_SRC_SYNC_CLK_X2                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_SRC_CLK_M                   _MK_ENUM_CONST(3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_SRC_CLK_S                   _MK_ENUM_CONST(4)

//  N  = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_DIVISOR_SHIFT                       _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_DIVISOR_FIELD                       (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_DIVISOR_RANGE                       7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_DIVISOR_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_DIVISOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_DIVISOR_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_DIVISOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_PWM_0_PWM_CLK_DIVISOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0                    _MK_ADDR_CONST(0x114)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SECURE                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_WORD_COUNT                         0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_RESET_VAL                  _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_RESET_MASK                         _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_READ_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_WRITE_MASK                         _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_SRC_SHIFT                 _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_SRC_FIELD                 (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_SRC_RANGE                 31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_SRC_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_SRC_DEFAULT                       _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_SRC_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_SRC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_SRC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_SRC_INIT_ENUM                     CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_SRC_PLLP_OUT0                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_SRC_PLLC_OUT0                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_SRC_PLLM_OUT0                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_SRC_CLK_M                 _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_DIVISOR_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_DIVISOR_FIELD                     (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_DIVISOR_RANGE                     7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_DIVISOR_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_DIVISOR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_DIVISOR_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_DIVISOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SPI1_0_SPI1_CLK_DIVISOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0                    _MK_ADDR_CONST(0x118)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SECURE                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_WORD_COUNT                         0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_RESET_VAL                  _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_RESET_MASK                         _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_READ_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_WRITE_MASK                         _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_SRC_SHIFT                 _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_SRC_FIELD                 (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_SRC_RANGE                 31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_SRC_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_SRC_DEFAULT                       _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_SRC_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_SRC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_SRC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_SRC_INIT_ENUM                     CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_SRC_PLLP_OUT0                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_SRC_PLLC_OUT0                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_SRC_PLLM_OUT0                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_SRC_CLK_M                 _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_DIVISOR_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_DIVISOR_FIELD                     (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_DIVISOR_RANGE                     7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_DIVISOR_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_DIVISOR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_DIVISOR_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_DIVISOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC2_0_SBC2_CLK_DIVISOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0                    _MK_ADDR_CONST(0x11c)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SECURE                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_WORD_COUNT                         0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_RESET_VAL                  _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_RESET_MASK                         _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_READ_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_WRITE_MASK                         _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_SRC_SHIFT                 _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_SRC_FIELD                 (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_SRC_RANGE                 31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_SRC_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_SRC_DEFAULT                       _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_SRC_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_SRC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_SRC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_SRC_INIT_ENUM                     CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_SRC_PLLP_OUT0                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_SRC_PLLC_OUT0                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_SRC_PLLM_OUT0                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_SRC_CLK_M                 _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_DIVISOR_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_DIVISOR_FIELD                     (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_DIVISOR_RANGE                     7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_DIVISOR_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_DIVISOR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_DIVISOR_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_DIVISOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC3_0_SBC3_CLK_DIVISOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0                     _MK_ADDR_CONST(0x120)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_SECURE                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_WORD_COUNT                  0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_RESET_VAL                   _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_RESET_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_READ_MASK                   _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_WRITE_MASK                  _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_SRC_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_SRC_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_SRC_RANGE                   31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_SRC_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_SRC_DEFAULT                 _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_SRC_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_SRC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_SRC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_SRC_INIT_ENUM                       CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_SRC_PLLP_OUT0                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_SRC_PLLC_OUT0                       _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_SRC_PLLM_OUT0                       _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_SRC_CLK_M                   _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_DIVISOR_SHIFT                       _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_DIVISOR_FIELD                       (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_DIVISOR_RANGE                       7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_DIVISOR_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_DIVISOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_DIVISOR_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_DIVISOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_XIO_0_XIO_CLK_DIVISOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0                    _MK_ADDR_CONST(0x124)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_SECURE                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_WORD_COUNT                         0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_RESET_VAL                  _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_RESET_MASK                         _MK_MASK_CONST(0xc000ffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_READ_MASK                  _MK_MASK_CONST(0xc000ffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_WRITE_MASK                         _MK_MASK_CONST(0xc000ffff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_SRC_SHIFT                 _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_SRC_FIELD                 (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_SRC_RANGE                 31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_SRC_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_SRC_DEFAULT                       _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_SRC_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_SRC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_SRC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_SRC_INIT_ENUM                     CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_SRC_PLLP_OUT0                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_SRC_PLLC_OUT0                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_SRC_PLLM_OUT0                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_SRC_CLK_M                 _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 1.0x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_DIVISOR_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_DIVISOR_FIELD                     (_MK_MASK_CONST(0xffff) << CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_DIVISOR_RANGE                     15:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_DIVISOR_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_DIVISOR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_DIVISOR_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_DIVISOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C1_0_I2C1_CLK_DIVISOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0                 _MK_ADDR_CONST(0x128)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_SECURE                  0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_WORD_COUNT                      0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_RESET_VAL                       _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_RESET_MASK                      _MK_MASK_CONST(0xc000ffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_READ_MASK                       _MK_MASK_CONST(0xc000ffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_WRITE_MASK                      _MK_MASK_CONST(0xc000ffff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_SRC_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_SRC_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_SRC_RANGE                   31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_SRC_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_SRC_DEFAULT                 _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_SRC_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_SRC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_SRC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_SRC_INIT_ENUM                       CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_SRC_PLLP_OUT0                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_SRC_PLLC_OUT0                       _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_SRC_PLLM_OUT0                       _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_SRC_CLK_M                   _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 1.0x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_DIVISOR_SHIFT                       _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_DIVISOR_FIELD                       (_MK_MASK_CONST(0xffff) << CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_DIVISOR_RANGE                       15:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_DIVISOR_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_DIVISOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_DIVISOR_DEFAULT_MASK                        _MK_MASK_CONST(0xffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_DIVISOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DVC_I2C_0_DVC_I2C_CLK_DIVISOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0                     _MK_ADDR_CONST(0x12c)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_SECURE                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_WORD_COUNT                  0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_RESET_VAL                   _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_RESET_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_READ_MASK                   _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_WRITE_MASK                  _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_SRC_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_SRC_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_SRC_RANGE                   31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_SRC_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_SRC_DEFAULT                 _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_SRC_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_SRC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_SRC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_SRC_INIT_ENUM                       CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_SRC_PLLP_OUT0                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_SRC_PLLC_OUT0                       _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_SRC_PLLM_OUT0                       _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_SRC_CLK_M                   _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_DIVISOR_SHIFT                       _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_DIVISOR_FIELD                       (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_DIVISOR_RANGE                       7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_DIVISOR_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_DIVISOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_DIVISOR_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_DIVISOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TWC_0_TWC_CLK_DIVISOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Reserved address 304 [0x130] 

// Register CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0                    _MK_ADDR_CONST(0x134)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SECURE                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_WORD_COUNT                         0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_RESET_VAL                  _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_RESET_MASK                         _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_READ_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_WRITE_MASK                         _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_SRC_SHIFT                 _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_SRC_FIELD                 (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_SRC_RANGE                 31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_SRC_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_SRC_DEFAULT                       _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_SRC_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_SRC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_SRC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_SRC_INIT_ENUM                     CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_SRC_PLLP_OUT0                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_SRC_PLLC_OUT0                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_SRC_PLLM_OUT0                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_SRC_CLK_M                 _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_DIVISOR_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_DIVISOR_FIELD                     (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_DIVISOR_RANGE                     7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_DIVISOR_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_DIVISOR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_DIVISOR_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_DIVISOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC1_0_SBC1_CLK_DIVISOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0                   _MK_ADDR_CONST(0x138)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_SECURE                    0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_WORD_COUNT                        0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_RESET_VAL                         _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_RESET_MASK                        _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_READ_MASK                         _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_WRITE_MASK                        _MK_MASK_CONST(0xc0000000)
//  00 = pllP_out0
//  01 = pllD_out0
//  10 = pllC_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_DISP1_CLK_SRC_SHIFT                       _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_DISP1_CLK_SRC_FIELD                       (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_DISP1_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_DISP1_CLK_SRC_RANGE                       31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_DISP1_CLK_SRC_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_DISP1_CLK_SRC_DEFAULT                     _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_DISP1_CLK_SRC_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_DISP1_CLK_SRC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_DISP1_CLK_SRC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_DISP1_CLK_SRC_INIT_ENUM                   CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_DISP1_CLK_SRC_PLLP_OUT0                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_DISP1_CLK_SRC_PLLD_OUT0                   _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_DISP1_CLK_SRC_PLLC_OUT0                   _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP1_0_DISP1_CLK_SRC_CLK_M                       _MK_ENUM_CONST(3)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0                   _MK_ADDR_CONST(0x13c)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_SECURE                    0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_WORD_COUNT                        0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_RESET_VAL                         _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_RESET_MASK                        _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_READ_MASK                         _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_WRITE_MASK                        _MK_MASK_CONST(0xc0000000)
//  00 = pllP_out0
//  01 = pllD_out0
//  10 = pllC_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_DISP2_CLK_SRC_SHIFT                       _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_DISP2_CLK_SRC_FIELD                       (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_DISP2_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_DISP2_CLK_SRC_RANGE                       31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_DISP2_CLK_SRC_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_DISP2_CLK_SRC_DEFAULT                     _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_DISP2_CLK_SRC_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_DISP2_CLK_SRC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_DISP2_CLK_SRC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_DISP2_CLK_SRC_INIT_ENUM                   CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_DISP2_CLK_SRC_PLLP_OUT0                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_DISP2_CLK_SRC_PLLD_OUT0                   _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_DISP2_CLK_SRC_PLLC_OUT0                   _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_DISP2_0_DISP2_CLK_SRC_CLK_M                       _MK_ENUM_CONST(3)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0                     _MK_ADDR_CONST(0x140)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_SECURE                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_WORD_COUNT                  0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_RESET_VAL                   _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_RESET_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_READ_MASK                   _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_WRITE_MASK                  _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllD_out0
//  10 = pllC_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_SRC_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_SRC_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_SRC_RANGE                   31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_SRC_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_SRC_DEFAULT                 _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_SRC_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_SRC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_SRC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_SRC_INIT_ENUM                       CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_SRC_PLLP_OUT0                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_SRC_PLLD_OUT0                       _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_SRC_PLLC_OUT0                       _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_SRC_CLK_M                   _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_DIVISOR_SHIFT                       _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_DIVISOR_FIELD                       (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_DIVISOR_RANGE                       7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_DIVISOR_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_DIVISOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_DIVISOR_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_DIVISOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CVE_0_CVE_CLK_DIVISOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0                     _MK_ADDR_CONST(0x144)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_SECURE                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_WORD_COUNT                  0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_RESET_VAL                   _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_RESET_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_READ_MASK                   _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_WRITE_MASK                  _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_SRC_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_SRC_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_SRC_RANGE                   31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_SRC_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_SRC_DEFAULT                 _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_SRC_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_SRC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_SRC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_SRC_INIT_ENUM                       CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_SRC_PLLP_OUT0                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_SRC_PLLC_OUT0                       _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_SRC_PLLM_OUT0                       _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_SRC_CLK_M                   _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_DIVISOR_SHIFT                       _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_DIVISOR_FIELD                       (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_DIVISOR_RANGE                       7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_DIVISOR_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_DIVISOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_DIVISOR_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_DIVISOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_IDE_0_IDE_CLK_DIVISOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_VI_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0                      _MK_ADDR_CONST(0x148)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_RESET_MASK                   _MK_MASK_CONST(0xc30000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_READ_MASK                    _MK_MASK_CONST(0xc30000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_WRITE_MASK                   _MK_MASK_CONST(0xc30000ff)
//  00 = pllM_out0
//  01 = pllC_out0
//  10 = pllP_out0
//  11 = pllA_out0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SRC_SHIFT                     _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SRC_FIELD                     (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SRC_RANGE                     31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SRC_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SRC_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SRC_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SRC_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SRC_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SRC_INIT_ENUM                 PLLM_OUT0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SRC_PLLM_OUT0                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SRC_PLLC_OUT0                 _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SRC_PLLP_OUT0                 _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SRC_PLLA_OUT0                 _MK_ENUM_CONST(3)

// 0 = pd2vi_clk, 1 = vi_sensor_clk.
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_PD2VI_CLK_SEL_SHIFT                  _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_PD2VI_CLK_SEL_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_PD2VI_CLK_SEL_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_PD2VI_CLK_SEL_RANGE                  25:25
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_PD2VI_CLK_SEL_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_PD2VI_CLK_SEL_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_PD2VI_CLK_SEL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_PD2VI_CLK_SEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_PD2VI_CLK_SEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// 0 = select internal clock, 1 = select external clock (pd2vi_clk).
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SEL_SHIFT                     _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SEL_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SEL_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SEL_RANGE                     24:24
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SEL_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SEL_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SEL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SEL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SEL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SEL_INIT_ENUM                 INTERNAL
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SEL_INTERNAL                  _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_SEL_EXTERNAL                  _MK_ENUM_CONST(1)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_DIVISOR_SHIFT                 _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_DIVISOR_FIELD                 (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_DIVISOR_RANGE                 7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_DIVISOR_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_DIVISOR_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_DIVISOR_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_DIVISOR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_0_VI_CLK_DIVISOR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 332 [0x14c] 

// Register CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0                  _MK_ADDR_CONST(0x150)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_RESET_VAL                        _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_RESET_MASK                       _MK_MASK_CONST(0xc08f00ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_READ_MASK                        _MK_MASK_CONST(0xc08f00ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_WRITE_MASK                       _MK_MASK_CONST(0xc08f00ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_SRC_SHIFT                     _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_SRC_FIELD                     (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_SRC_RANGE                     31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_SRC_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_SRC_DEFAULT                   _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_SRC_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_SRC_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_SRC_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_SRC_INIT_ENUM                 CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_SRC_PLLP_OUT0                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_SRC_PLLC_OUT0                 _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_SRC_PLLM_OUT0                 _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_SRC_CLK_M                     _MK_ENUM_CONST(3)

// 1 = use internal feedback clock.
// 0 = use external feedback clock.
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_SEL_SHIFT                  _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_SEL_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_SEL_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_SEL_RANGE                  23:23
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_SEL_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_SEL_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_SEL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_SEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_SEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// 16-tap of internal feedback clock delay.
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_DLY_SHIFT                  _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_DLY_FIELD                  (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_DLY_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_DLY_RANGE                  19:16
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_DLY_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_DLY_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_DLY_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_DLY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_INT_FB_DLY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_DIVISOR_SHIFT                 _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_DIVISOR_FIELD                 (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_DIVISOR_RANGE                 7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_DIVISOR_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_DIVISOR_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_DIVISOR_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_DIVISOR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC1_0_SDMMC1_CLK_DIVISOR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0                  _MK_ADDR_CONST(0x154)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_RESET_VAL                        _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_RESET_MASK                       _MK_MASK_CONST(0xc08f00ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_READ_MASK                        _MK_MASK_CONST(0xc08f00ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_WRITE_MASK                       _MK_MASK_CONST(0xc08f00ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_SRC_SHIFT                     _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_SRC_FIELD                     (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_SRC_RANGE                     31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_SRC_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_SRC_DEFAULT                   _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_SRC_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_SRC_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_SRC_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_SRC_INIT_ENUM                 CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_SRC_PLLP_OUT0                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_SRC_PLLC_OUT0                 _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_SRC_PLLM_OUT0                 _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_SRC_CLK_M                     _MK_ENUM_CONST(3)

// 1 = use internal feedback clock.
// 0 = use external feedback clock.
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_SEL_SHIFT                  _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_SEL_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_SEL_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_SEL_RANGE                  23:23
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_SEL_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_SEL_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_SEL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_SEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_SEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// 16-tap of internal feedback clock delay.
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_DLY_SHIFT                  _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_DLY_FIELD                  (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_DLY_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_DLY_RANGE                  19:16
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_DLY_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_DLY_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_DLY_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_DLY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_INT_FB_DLY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_DIVISOR_SHIFT                 _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_DIVISOR_FIELD                 (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_DIVISOR_RANGE                 7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_DIVISOR_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_DIVISOR_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_DIVISOR_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_DIVISOR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC2_0_SDMMC2_CLK_DIVISOR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0                     _MK_ADDR_CONST(0x158)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_SECURE                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_WORD_COUNT                  0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_RESET_MASK                  _MK_MASK_CONST(0xc000ffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_READ_MASK                   _MK_MASK_CONST(0xc000ffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_WRITE_MASK                  _MK_MASK_CONST(0xc000ffff)
//  00 = pllM_out0
//  01 = pllC_out0
//  10 = pllP_out0
//  11 = pllA_out0
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_SRC_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_SRC_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_SRC_RANGE                   31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_SRC_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_SRC_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_SRC_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_SRC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_SRC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_SRC_INIT_ENUM                       PLLM_OUT0
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_SRC_PLLM_OUT0                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_SRC_PLLC_OUT0                       _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_SRC_PLLP_OUT0                       _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_SRC_PLLA_OUT0                       _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
//  if all 0's, this idle divisor field will not be use.
//  for non-zero values, when host1x is idle, this field will be use
//  instead of G3D_CLK_DIVISOR.
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_IDLE_DIVISOR_SHIFT                      _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_IDLE_DIVISOR_FIELD                      (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_IDLE_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_IDLE_DIVISOR_RANGE                      15:8
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_IDLE_DIVISOR_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_IDLE_DIVISOR_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_IDLE_DIVISOR_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_IDLE_DIVISOR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_IDLE_DIVISOR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_DIVISOR_SHIFT                       _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_DIVISOR_FIELD                       (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_DIVISOR_RANGE                       7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_DIVISOR_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_DIVISOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_DIVISOR_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_DIVISOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G3D_0_G3D_CLK_DIVISOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0                     _MK_ADDR_CONST(0x15c)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_SECURE                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_WORD_COUNT                  0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_RESET_MASK                  _MK_MASK_CONST(0xc000ffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_READ_MASK                   _MK_MASK_CONST(0xc000ffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_WRITE_MASK                  _MK_MASK_CONST(0xc000ffff)
//  00 = pllM_out0
//  01 = pllC_out0
//  10 = pllP_out0
//  11 = pllA_out0
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_SRC_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_SRC_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_SRC_RANGE                   31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_SRC_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_SRC_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_SRC_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_SRC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_SRC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_SRC_INIT_ENUM                       PLLM_OUT0
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_SRC_PLLM_OUT0                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_SRC_PLLC_OUT0                       _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_SRC_PLLP_OUT0                       _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_SRC_PLLA_OUT0                       _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
//  if all 0's, this idle divisor field will not be use.
//  for non-zero values, when host1x is idle, this field will be use
//  instead of G2D_CLK_DIVISOR.
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_IDLE_DIVISOR_SHIFT                      _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_IDLE_DIVISOR_FIELD                      (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_IDLE_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_IDLE_DIVISOR_RANGE                      15:8
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_IDLE_DIVISOR_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_IDLE_DIVISOR_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_IDLE_DIVISOR_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_IDLE_DIVISOR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_IDLE_DIVISOR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_DIVISOR_SHIFT                       _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_DIVISOR_FIELD                       (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_DIVISOR_RANGE                       7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_DIVISOR_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_DIVISOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_DIVISOR_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_DIVISOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_G2D_0_G2D_CLK_DIVISOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0                 _MK_ADDR_CONST(0x160)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_SECURE                  0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_WORD_COUNT                      0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_RESET_VAL                       _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_RESET_MASK                      _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_READ_MASK                       _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_WRITE_MASK                      _MK_MASK_CONST(0xc00000ff)
// 00 = pllP_out0
// 01 = pllC_out0
// 10 = pllM_out0
// 11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_SRC_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_SRC_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_SRC_RANGE                   31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_SRC_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_SRC_DEFAULT                 _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_SRC_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_SRC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_SRC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_SRC_INIT_ENUM                       CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_SRC_PLLP_OUT0                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_SRC_PLLC_OUT0                       _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_SRC_PLLM_OUT0                       _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_SRC_CLK_M                   _MK_ENUM_CONST(3)

// N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_DIVISOR_SHIFT                       _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_DIVISOR_FIELD                       (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_DIVISOR_RANGE                       7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_DIVISOR_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_DIVISOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_DIVISOR_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_DIVISOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NDFLASH_0_NDFLASH_CLK_DIVISOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0                  _MK_ADDR_CONST(0x164)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_RESET_VAL                        _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_RESET_MASK                       _MK_MASK_CONST(0xc08f00ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_READ_MASK                        _MK_MASK_CONST(0xc08f00ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_WRITE_MASK                       _MK_MASK_CONST(0xc08f00ff)
// 00 = pllP_out0
// 01 = pllC_out0
// 10 = pllM_out0
// 11 = CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_SRC_SHIFT                     _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_SRC_FIELD                     (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_SRC_RANGE                     31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_SRC_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_SRC_DEFAULT                   _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_SRC_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_SRC_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_SRC_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_SRC_INIT_ENUM                 CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_SRC_PLLP_OUT0                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_SRC_PLLC_OUT0                 _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_SRC_PLLM_OUT0                 _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_SRC_CLK_M                     _MK_ENUM_CONST(3)

// 1 = use internal feedback clock.
// 0 = use external feedback clock.
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_SEL_SHIFT                  _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_SEL_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_SEL_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_SEL_RANGE                  23:23
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_SEL_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_SEL_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_SEL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_SEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_SEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// 16-tap of internal feedback clock delay.
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_DLY_SHIFT                  _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_DLY_FIELD                  (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_DLY_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_DLY_RANGE                  19:16
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_DLY_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_DLY_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_DLY_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_DLY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_INT_FB_DLY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_DIVISOR_SHIFT                 _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_DIVISOR_FIELD                 (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_DIVISOR_RANGE                 7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_DIVISOR_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_DIVISOR_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_DIVISOR_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_DIVISOR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC4_0_SDMMC4_CLK_DIVISOR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0                    _MK_ADDR_CONST(0x168)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_SECURE                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_WORD_COUNT                         0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_RESET_VAL                  _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_RESET_MASK                         _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_READ_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_WRITE_MASK                         _MK_MASK_CONST(0xc00000ff)
// 00 = pllP_out0
// 01 = pllC_out0
// 10 = pllM_out0
// 11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_SRC_SHIFT                 _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_SRC_FIELD                 (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_SRC_RANGE                 31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_SRC_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_SRC_DEFAULT                       _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_SRC_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_SRC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_SRC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_SRC_INIT_ENUM                     CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_SRC_PLLP_OUT0                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_SRC_PLLC_OUT0                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_SRC_PLLM_OUT0                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_SRC_CLK_M                 _MK_ENUM_CONST(3)

// N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_DIVISOR_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_DIVISOR_FIELD                     (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_DIVISOR_RANGE                     7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_DIVISOR_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_DIVISOR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_DIVISOR_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_DIVISOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VFIR_0_VFIR_CLK_DIVISOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0                     _MK_ADDR_CONST(0x16c)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_SECURE                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_WORD_COUNT                  0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_RESET_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_READ_MASK                   _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_WRITE_MASK                  _MK_MASK_CONST(0xc00000ff)
//  00 = pllM_out0
//  01 = pllC_out0
//  10 = pllP_out0
//  11 = pllA_out0
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_SRC_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_SRC_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_SRC_RANGE                   31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_SRC_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_SRC_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_SRC_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_SRC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_SRC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_SRC_INIT_ENUM                       PLLM_OUT0
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_SRC_PLLM_OUT0                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_SRC_PLLC_OUT0                       _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_SRC_PLLP_OUT0                       _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_SRC_PLLA_OUT0                       _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_DIVISOR_SHIFT                       _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_DIVISOR_FIELD                       (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_DIVISOR_RANGE                       7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_DIVISOR_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_DIVISOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_DIVISOR_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_DIVISOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EPP_0_EPP_CLK_DIVISOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0                     _MK_ADDR_CONST(0x170)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_SECURE                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_WORD_COUNT                  0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_RESET_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_READ_MASK                   _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_WRITE_MASK                  _MK_MASK_CONST(0xc00000ff)
//  00 = pllM_out0
//  01 = pllC_out0
//  10 = pllP_out0
//  11 = pllA_out0
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_SRC_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_SRC_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_SRC_RANGE                   31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_SRC_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_SRC_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_SRC_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_SRC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_SRC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_SRC_INIT_ENUM                       PLLM_out0
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_SRC_PLLM_OUT0                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_SRC_PLLC_OUT0                       _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_SRC_PLLP_OUT0                       _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_SRC_PLLA_OUT0                       _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_DIVISOR_SHIFT                       _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_DIVISOR_FIELD                       (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_DIVISOR_RANGE                       7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_DIVISOR_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_DIVISOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_DIVISOR_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_DIVISOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MPE_0_MPE_CLK_DIVISOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0                    _MK_ADDR_CONST(0x174)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_SECURE                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_WORD_COUNT                         0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_RESET_VAL                  _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_RESET_MASK                         _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_READ_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_WRITE_MASK                         _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_SRC_SHIFT                 _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_SRC_FIELD                 (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_SRC_RANGE                 31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_SRC_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_SRC_DEFAULT                       _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_SRC_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_SRC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_SRC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_SRC_INIT_ENUM                     CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_SRC_PLLP_OUT0                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_SRC_PLLC_OUT0                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_SRC_PLLM_OUT0                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_SRC_CLK_M                 _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_DIVISOR_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_DIVISOR_FIELD                     (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_DIVISOR_RANGE                     7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_DIVISOR_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_DIVISOR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_DIVISOR_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_DIVISOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_MIPI_0_MIPI_CLK_DIVISOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0                   _MK_ADDR_CONST(0x178)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_SECURE                    0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_WORD_COUNT                        0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_RESET_VAL                         _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_RESET_MASK                        _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_READ_MASK                         _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_WRITE_MASK                        _MK_MASK_CONST(0xc0000000)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_UARTA_CLK_SRC_SHIFT                       _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_UARTA_CLK_SRC_FIELD                       (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_UARTA_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_UARTA_CLK_SRC_RANGE                       31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_UARTA_CLK_SRC_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_UARTA_CLK_SRC_DEFAULT                     _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_UARTA_CLK_SRC_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_UARTA_CLK_SRC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_UARTA_CLK_SRC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_UARTA_CLK_SRC_INIT_ENUM                   CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_UARTA_CLK_SRC_PLLP_OUT0                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_UARTA_CLK_SRC_PLLC_OUT0                   _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_UARTA_CLK_SRC_PLLM_OUT0                   _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTA_0_UARTA_CLK_SRC_CLK_M                       _MK_ENUM_CONST(3)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0                   _MK_ADDR_CONST(0x17c)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_SECURE                    0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_WORD_COUNT                        0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_RESET_VAL                         _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_RESET_MASK                        _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_READ_MASK                         _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_WRITE_MASK                        _MK_MASK_CONST(0xc0000000)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_UARTB_CLK_SRC_SHIFT                       _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_UARTB_CLK_SRC_FIELD                       (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_UARTB_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_UARTB_CLK_SRC_RANGE                       31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_UARTB_CLK_SRC_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_UARTB_CLK_SRC_DEFAULT                     _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_UARTB_CLK_SRC_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_UARTB_CLK_SRC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_UARTB_CLK_SRC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_UARTB_CLK_SRC_INIT_ENUM                   CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_UARTB_CLK_SRC_PLLP_OUT0                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_UARTB_CLK_SRC_PLLC_OUT0                   _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_UARTB_CLK_SRC_PLLM_OUT0                   _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTB_0_UARTB_CLK_SRC_CLK_M                       _MK_ENUM_CONST(3)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0                  _MK_ADDR_CONST(0x180)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_RESET_MASK                       _MK_MASK_CONST(0xc000ffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_READ_MASK                        _MK_MASK_CONST(0xc000ffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_WRITE_MASK                       _MK_MASK_CONST(0xc000ffff)
//  00 = pllM_out0
//  01 = pllC_out0
//  10 = pllP_out0
//  11 = pllA_out0
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_SRC_SHIFT                     _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_SRC_FIELD                     (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_SRC_RANGE                     31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_SRC_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_SRC_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_SRC_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_SRC_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_SRC_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_SRC_INIT_ENUM                 PLLM_OUT0
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_SRC_PLLM_OUT0                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_SRC_PLLC_OUT0                 _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_SRC_PLLP_OUT0                 _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_SRC_PLLA_OUT0                 _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
//  if all 0's, this idle divisor field will not be use.
//  for non-zero values, when host1x is idle, this field will be use
//  instead of HOST1X_CLK_DIVISOR.
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_IDLE_DIVISOR_SHIFT                        _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_IDLE_DIVISOR_FIELD                        (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_IDLE_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_IDLE_DIVISOR_RANGE                        15:8
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_IDLE_DIVISOR_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_IDLE_DIVISOR_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_IDLE_DIVISOR_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_IDLE_DIVISOR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_IDLE_DIVISOR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_DIVISOR_SHIFT                 _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_DIVISOR_FIELD                 (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_DIVISOR_RANGE                 7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_DIVISOR_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_DIVISOR_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_DIVISOR_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_DIVISOR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HOST1X_0_HOST1X_CLK_DIVISOR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 388 [0x184] 

// Register CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0                     _MK_ADDR_CONST(0x188)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_SECURE                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_WORD_COUNT                  0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_RESET_VAL                   _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_RESET_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_READ_MASK                   _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_WRITE_MASK                  _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllD_out0
//  10 = pllC_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_SRC_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_SRC_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_SRC_RANGE                   31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_SRC_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_SRC_DEFAULT                 _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_SRC_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_SRC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_SRC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_SRC_INIT_ENUM                       CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_SRC_PLLP_OUT0                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_SRC_PLLD_OUT0                       _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_SRC_PLLC_OUT0                       _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_SRC_CLK_M                   _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_DIVISOR_SHIFT                       _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_DIVISOR_FIELD                       (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_DIVISOR_RANGE                       7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_DIVISOR_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_DIVISOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_DIVISOR_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_DIVISOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVO_0_TVO_CLK_DIVISOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0                    _MK_ADDR_CONST(0x18c)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_SECURE                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_WORD_COUNT                         0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_RESET_VAL                  _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_RESET_MASK                         _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_READ_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_WRITE_MASK                         _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllD_out0
//  10 = pllC_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_SRC_SHIFT                 _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_SRC_FIELD                 (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_SRC_RANGE                 31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_SRC_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_SRC_DEFAULT                       _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_SRC_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_SRC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_SRC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_SRC_INIT_ENUM                     CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_SRC_PLLP_OUT0                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_SRC_PLLD_OUT0                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_SRC_PLLC_OUT0                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_SRC_CLK_M                 _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_DIVISOR_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_DIVISOR_FIELD                     (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_DIVISOR_RANGE                     7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_DIVISOR_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_DIVISOR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_DIVISOR_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_DIVISOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_HDMI_0_HDMI_CLK_DIVISOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Reserved address 400 [0x190] 

// Register CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0                   _MK_ADDR_CONST(0x194)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_SECURE                    0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_WORD_COUNT                        0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_RESET_VAL                         _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_RESET_MASK                        _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_READ_MASK                         _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_WRITE_MASK                        _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllD_out0
//  10 = pllC_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_SRC_SHIFT                       _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_SRC_FIELD                       (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_SRC_RANGE                       31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_SRC_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_SRC_DEFAULT                     _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_SRC_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_SRC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_SRC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_SRC_INIT_ENUM                   CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_SRC_PLLP_OUT0                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_SRC_PLLD_OUT0                   _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_SRC_PLLC_OUT0                   _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_SRC_CLK_M                       _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_DIVISOR_SHIFT                   _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_DIVISOR_FIELD                   (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_DIVISOR_RANGE                   7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_DIVISOR_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_DIVISOR_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_DIVISOR_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_DIVISOR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_TVDAC_0_TVDAC_CLK_DIVISOR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0                    _MK_ADDR_CONST(0x198)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_SECURE                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_WORD_COUNT                         0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_RESET_VAL                  _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_RESET_MASK                         _MK_MASK_CONST(0xc000ffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_READ_MASK                  _MK_MASK_CONST(0xc000ffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_WRITE_MASK                         _MK_MASK_CONST(0xc000ffff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_SRC_SHIFT                 _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_SRC_FIELD                 (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_SRC_RANGE                 31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_SRC_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_SRC_DEFAULT                       _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_SRC_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_SRC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_SRC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_SRC_INIT_ENUM                     CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_SRC_PLLP_OUT0                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_SRC_PLLC_OUT0                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_SRC_PLLM_OUT0                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_SRC_CLK_M                 _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 1.0x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_DIVISOR_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_DIVISOR_FIELD                     (_MK_MASK_CONST(0xffff) << CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_DIVISOR_RANGE                     15:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_DIVISOR_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_DIVISOR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_DIVISOR_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_DIVISOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C2_0_I2C2_CLK_DIVISOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0                     _MK_ADDR_CONST(0x19c)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_SECURE                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_WORD_COUNT                  0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_RESET_VAL                   _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_RESET_MASK                  _MK_MASK_CONST(0xe30000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_READ_MASK                   _MK_MASK_CONST(0xe30000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_WRITE_MASK                  _MK_MASK_CONST(0xe30000ff)
// 00 = pllM_out0
// 01 = pllC_out0
// 10 = pllP_out0
// 11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_SRC_SHIFT                        _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_SRC_FIELD                        (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_SRC_RANGE                        31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_SRC_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_SRC_DEFAULT                      _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_SRC_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_SRC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_SRC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_SRC_INIT_ENUM                    CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_SRC_PLLM_OUT0                    _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_SRC_PLLC_OUT0                    _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_SRC_PLLP_OUT0                    _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_SRC_CLK_M                        _MK_ENUM_CONST(3)

// 1 = use un-divided PllM_out0 as clock source.
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_USE_PLLM_UD_SHIFT                   _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_USE_PLLM_UD_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_USE_PLLM_UD_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_USE_PLLM_UD_RANGE                   29:29
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_USE_PLLM_UD_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_USE_PLLM_UD_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_USE_PLLM_UD_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_USE_PLLM_UD_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_USE_PLLM_UD_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//  1 = enable EMC 2X clock.
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_ENB_SHIFT                        _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_ENB_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_ENB_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_ENB_RANGE                        25:25
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_ENB_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_ENB_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_ENB_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_ENB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_ENB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_ENB_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_ENB_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_ENB_ENABLE                       _MK_ENUM_CONST(1)

//  1 = enable EMC 1X clock.
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_1X_CLK_ENB_SHIFT                        _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_1X_CLK_ENB_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_1X_CLK_ENB_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_1X_CLK_ENB_RANGE                        24:24
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_1X_CLK_ENB_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_1X_CLK_ENB_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_1X_CLK_ENB_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_1X_CLK_ENB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_1X_CLK_ENB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_1X_CLK_ENB_INIT_ENUM                    DISABLE
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_1X_CLK_ENB_DISABLE                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_1X_CLK_ENB_ENABLE                       _MK_ENUM_CONST(1)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_DIVISOR_SHIFT                    _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_DIVISOR_FIELD                    (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_DIVISOR_RANGE                    7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_DIVISOR_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_DIVISOR_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_DIVISOR_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_DIVISOR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_EMC_0_EMC_2X_CLK_DIVISOR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0                   _MK_ADDR_CONST(0x1a0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_SECURE                    0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_WORD_COUNT                        0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_RESET_VAL                         _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_RESET_MASK                        _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_READ_MASK                         _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_WRITE_MASK                        _MK_MASK_CONST(0xc0000000)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_UARTC_CLK_SRC_SHIFT                       _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_UARTC_CLK_SRC_FIELD                       (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_UARTC_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_UARTC_CLK_SRC_RANGE                       31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_UARTC_CLK_SRC_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_UARTC_CLK_SRC_DEFAULT                     _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_UARTC_CLK_SRC_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_UARTC_CLK_SRC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_UARTC_CLK_SRC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_UARTC_CLK_SRC_INIT_ENUM                   CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_UARTC_CLK_SRC_PLLP_OUT0                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_UARTC_CLK_SRC_PLLC_OUT0                   _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_UARTC_CLK_SRC_PLLM_OUT0                   _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTC_0_UARTC_CLK_SRC_CLK_M                       _MK_ENUM_CONST(3)


// Reserved address 420 [0x1a4] 

// Register CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0                       _MK_ADDR_CONST(0x1a8)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_SECURE                        0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_WORD_COUNT                    0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_RESET_MASK                    _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_READ_MASK                     _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_WRITE_MASK                    _MK_MASK_CONST(0xc00000ff)
//  00 = pllM_out0
//  01 = pllC_out0
//  10 = pllP_out0
//  11 = pllA_out0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_SRC_SHIFT                       _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_SRC_FIELD                       (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_SRC_RANGE                       31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_SRC_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_SRC_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_SRC_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_SRC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_SRC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_SRC_INIT_ENUM                   PLLM_OUT0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_SRC_PLLM_OUT0                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_SRC_PLLC_OUT0                   _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_SRC_PLLP_OUT0                   _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_SRC_PLLA_OUT0                   _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_DIVISOR_SHIFT                   _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_DIVISOR_FIELD                   (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_DIVISOR_RANGE                   7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_DIVISOR_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_DIVISOR_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_DIVISOR_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_DIVISOR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VI_SENSOR_0_VI_SENSOR_CLK_DIVISOR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Reserved address 428 [0x1ac] 

// Reserved address 432 [0x1b0] 

// Register CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0                    _MK_ADDR_CONST(0x1b4)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SECURE                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_WORD_COUNT                         0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_RESET_VAL                  _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_RESET_MASK                         _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_READ_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_WRITE_MASK                         _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_SRC_SHIFT                 _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_SRC_FIELD                 (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_SRC_RANGE                 31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_SRC_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_SRC_DEFAULT                       _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_SRC_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_SRC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_SRC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_SRC_INIT_ENUM                     CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_SRC_PLLP_OUT0                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_SRC_PLLC_OUT0                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_SRC_PLLM_OUT0                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_SRC_CLK_M                 _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_DIVISOR_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_DIVISOR_FIELD                     (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_DIVISOR_RANGE                     7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_DIVISOR_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_DIVISOR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_DIVISOR_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_DIVISOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SBC4_0_SBC4_CLK_DIVISOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0                    _MK_ADDR_CONST(0x1b8)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_SECURE                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_WORD_COUNT                         0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_RESET_VAL                  _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_RESET_MASK                         _MK_MASK_CONST(0xc000ffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_READ_MASK                  _MK_MASK_CONST(0xc000ffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_WRITE_MASK                         _MK_MASK_CONST(0xc000ffff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_SRC_SHIFT                 _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_SRC_FIELD                 (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_SRC_RANGE                 31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_SRC_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_SRC_DEFAULT                       _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_SRC_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_SRC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_SRC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_SRC_INIT_ENUM                     CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_SRC_PLLP_OUT0                     _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_SRC_PLLC_OUT0                     _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_SRC_PLLM_OUT0                     _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_SRC_CLK_M                 _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 1.0x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_DIVISOR_SHIFT                     _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_DIVISOR_FIELD                     (_MK_MASK_CONST(0xffff) << CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_DIVISOR_RANGE                     15:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_DIVISOR_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_DIVISOR_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_DIVISOR_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_DIVISOR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_I2C3_0_I2C3_CLK_DIVISOR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0                  _MK_ADDR_CONST(0x1bc)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SECURE                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_WORD_COUNT                       0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_RESET_VAL                        _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_RESET_MASK                       _MK_MASK_CONST(0xc08f00ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_READ_MASK                        _MK_MASK_CONST(0xc08f00ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_WRITE_MASK                       _MK_MASK_CONST(0xc08f00ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_SRC_SHIFT                     _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_SRC_FIELD                     (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_SRC_RANGE                     31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_SRC_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_SRC_DEFAULT                   _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_SRC_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_SRC_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_SRC_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_SRC_INIT_ENUM                 CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_SRC_PLLP_OUT0                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_SRC_PLLC_OUT0                 _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_SRC_PLLM_OUT0                 _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_SRC_CLK_M                     _MK_ENUM_CONST(3)

// 1 = use internal feedback clock.
// 0 = use external feedback clock.
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_SEL_SHIFT                  _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_SEL_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_SEL_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_SEL_RANGE                  23:23
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_SEL_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_SEL_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_SEL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_SEL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_SEL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// 16-tap of internal feedback clock delay.
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_DLY_SHIFT                  _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_DLY_FIELD                  (_MK_MASK_CONST(0xf) << CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_DLY_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_DLY_RANGE                  19:16
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_DLY_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_DLY_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_DLY_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_DLY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_INT_FB_DLY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_DIVISOR_SHIFT                 _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_DIVISOR_FIELD                 (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_DIVISOR_RANGE                 7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_DIVISOR_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_DIVISOR_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_DIVISOR_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_DIVISOR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_SDMMC3_0_SDMMC3_CLK_DIVISOR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0                   _MK_ADDR_CONST(0x1c0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_SECURE                    0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_WORD_COUNT                        0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_RESET_VAL                         _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_RESET_MASK                        _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_READ_MASK                         _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_WRITE_MASK                        _MK_MASK_CONST(0xc0000000)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_UARTD_CLK_SRC_SHIFT                       _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_UARTD_CLK_SRC_FIELD                       (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_UARTD_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_UARTD_CLK_SRC_RANGE                       31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_UARTD_CLK_SRC_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_UARTD_CLK_SRC_DEFAULT                     _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_UARTD_CLK_SRC_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_UARTD_CLK_SRC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_UARTD_CLK_SRC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_UARTD_CLK_SRC_INIT_ENUM                   CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_UARTD_CLK_SRC_PLLP_OUT0                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_UARTD_CLK_SRC_PLLC_OUT0                   _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_UARTD_CLK_SRC_PLLM_OUT0                   _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTD_0_UARTD_CLK_SRC_CLK_M                       _MK_ENUM_CONST(3)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0                   _MK_ADDR_CONST(0x1c4)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_SECURE                    0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_WORD_COUNT                        0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_RESET_VAL                         _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_RESET_MASK                        _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_READ_MASK                         _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_WRITE_MASK                        _MK_MASK_CONST(0xc0000000)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_UARTE_CLK_SRC_SHIFT                       _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_UARTE_CLK_SRC_FIELD                       (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_UARTE_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_UARTE_CLK_SRC_RANGE                       31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_UARTE_CLK_SRC_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_UARTE_CLK_SRC_DEFAULT                     _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_UARTE_CLK_SRC_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_UARTE_CLK_SRC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_UARTE_CLK_SRC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_UARTE_CLK_SRC_INIT_ENUM                   CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_UARTE_CLK_SRC_PLLP_OUT0                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_UARTE_CLK_SRC_PLLC_OUT0                   _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_UARTE_CLK_SRC_PLLM_OUT0                   _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_UARTE_0_UARTE_CLK_SRC_CLK_M                       _MK_ENUM_CONST(3)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0                     _MK_ADDR_CONST(0x1c8)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_SECURE                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_WORD_COUNT                  0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_RESET_VAL                   _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_RESET_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_READ_MASK                   _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_WRITE_MASK                  _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_SRC_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_SRC_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_SRC_RANGE                   31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_SRC_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_SRC_DEFAULT                 _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_SRC_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_SRC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_SRC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_SRC_INIT_ENUM                       CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_SRC_PLLP_OUT0                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_SRC_PLLC_OUT0                       _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_SRC_PLLM_OUT0                       _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_SRC_CLK_M                   _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_DIVISOR_SHIFT                       _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_DIVISOR_FIELD                       (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_DIVISOR_RANGE                       7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_DIVISOR_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_DIVISOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_DIVISOR_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_DIVISOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_VDE_0_VDE_CLK_DIVISOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0                     _MK_ADDR_CONST(0x1cc)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_SECURE                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_WORD_COUNT                  0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_RESET_VAL                   _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_RESET_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_READ_MASK                   _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_WRITE_MASK                  _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_SRC_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_SRC_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_SRC_RANGE                   31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_SRC_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_SRC_DEFAULT                 _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_SRC_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_SRC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_SRC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_SRC_INIT_ENUM                       CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_SRC_PLLP_OUT0                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_SRC_PLLC_OUT0                       _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_SRC_PLLM_OUT0                       _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_SRC_CLK_M                   _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_DIVISOR_SHIFT                       _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_DIVISOR_FIELD                       (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_DIVISOR_RANGE                       7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_DIVISOR_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_DIVISOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_DIVISOR_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_DIVISOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OWR_0_OWR_CLK_DIVISOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0                     _MK_ADDR_CONST(0x1d0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SECURE                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_WORD_COUNT                  0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_RESET_VAL                   _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_RESET_MASK                  _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_READ_MASK                   _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_WRITE_MASK                  _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_SRC_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_SRC_FIELD                   (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_SRC_RANGE                   31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_SRC_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_SRC_DEFAULT                 _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_SRC_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_SRC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_SRC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_SRC_INIT_ENUM                       CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_SRC_PLLP_OUT0                       _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_SRC_PLLC_OUT0                       _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_SRC_PLLM_OUT0                       _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_SRC_CLK_M                   _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_DIVISOR_SHIFT                       _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_DIVISOR_FIELD                       (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_DIVISOR_RANGE                       7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_DIVISOR_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_DIVISOR_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_DIVISOR_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_DIVISOR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_NOR_CLK_DIVISOR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_SRC_SHIFT                  _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_SRC_FIELD                  (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_SRC_RANGE                  31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_SRC_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_SRC_DEFAULT                        _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_SRC_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_SRC_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_SRC_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_SRC_INIT_ENUM                      CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_SRC_PLLP_OUT0                      _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_SRC_PLLC_OUT0                      _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_SRC_PLLM_OUT0                      _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_SRC_CLK_M                  _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_DIVISOR_SHIFT                      _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_DIVISOR_FIELD                      (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_DIVISOR_RANGE                      7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_DIVISOR_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_DIVISOR_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_DIVISOR_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_DIVISOR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_NOR_0_SNOR_CLK_DIVISOR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0                   _MK_ADDR_CONST(0x1d4)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_SECURE                    0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_WORD_COUNT                        0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_RESET_VAL                         _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_RESET_MASK                        _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_READ_MASK                         _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_WRITE_MASK                        _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_SRC_SHIFT                       _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_SRC_FIELD                       (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_SRC_RANGE                       31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_SRC_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_SRC_DEFAULT                     _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_SRC_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_SRC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_SRC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_SRC_INIT_ENUM                   CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_SRC_PLLP_OUT0                   _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_SRC_PLLC_OUT0                   _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_SRC_PLLM_OUT0                   _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_SRC_CLK_M                       _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_DIVISOR_SHIFT                   _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_DIVISOR_FIELD                   (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_DIVISOR_RANGE                   7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_DIVISOR_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_DIVISOR_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_DIVISOR_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_DIVISOR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_CSITE_0_CSITE_CLK_DIVISOR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Reserved address 472 [0x1d8] 

// Reserved address 476 [0x1dc] 

// Reserved address 480 [0x1e0] 

// Reserved address 484 [0x1e4] 

// Reserved address 488 [0x1e8] 

// Reserved address 492 [0x1ec] 

// Reserved address 496 [0x1f0] 

// Reserved address 500 [0x1f4] 

// Register CLK_RST_CONTROLLER_CLK_SOURCE_LA_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0                      _MK_ADDR_CONST(0x1f8)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_RESET_VAL                    _MK_MASK_CONST(0xc0000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_RESET_MASK                   _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_READ_MASK                    _MK_MASK_CONST(0xc00000ff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_WRITE_MASK                   _MK_MASK_CONST(0xc00000ff)
//  00 = pllP_out0
//  01 = pllC_out0
//  10 = pllM_out0
//  11 = clk_m
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_SRC_SHIFT                     _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_SRC_FIELD                     (_MK_MASK_CONST(0x3) << CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_SRC_RANGE                     31:30
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_SRC_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_SRC_DEFAULT                   _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_SRC_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_SRC_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_SRC_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_SRC_INIT_ENUM                 CLK_M
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_SRC_PLLP_OUT0                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_SRC_PLLC_OUT0                 _MK_ENUM_CONST(1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_SRC_PLLM_OUT0                 _MK_ENUM_CONST(2)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_SRC_CLK_M                     _MK_ENUM_CONST(3)

//  N = Divide by (n+1) (lsb denote 0.5x)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_DIVISOR_SHIFT                 _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_DIVISOR_FIELD                 (_MK_MASK_CONST(0xff) << CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_DIVISOR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_DIVISOR_RANGE                 7:0
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_DIVISOR_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_DIVISOR_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_DIVISOR_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_DIVISOR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_LA_0_LA_CLK_DIVISOR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0  
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0                     _MK_ADDR_CONST(0x1fc)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_SECURE                      0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_WORD_COUNT                  0x1
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_RESET_MASK                  _MK_MASK_CONST(0x10000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_READ_MASK                   _MK_MASK_CONST(0x10000000)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_WRITE_MASK                  _MK_MASK_CONST(0x10000000)
//  0 = external oscillator
//  1 = internal PLL_S
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_OSC_CLK_SRC_SHIFT                   _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_OSC_CLK_SRC_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_OSC_CLK_SRC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_OSC_CLK_SRC_RANGE                   28:28
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_OSC_CLK_SRC_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_OSC_CLK_SRC_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_OSC_CLK_SRC_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_OSC_CLK_SRC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_OSC_CLK_SRC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_OSC_CLK_SRC_INIT_ENUM                       EXT_OSC
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_OSC_CLK_SRC_EXT_OSC                 _MK_ENUM_CONST(0)
#define CLK_RST_CONTROLLER_CLK_SOURCE_OSC_0_OSC_CLK_SRC_INT_PLLS_OUT                    _MK_ENUM_CONST(1)


// Register CLK_RST_CONTROLLER_LOCK_BOND_OUT_0  
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0                      _MK_ADDR_CONST(0x200)
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_RESET_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_READ_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_WRITE_MASK                   _MK_MASK_CONST(0x1)
// 1 = lock all BOND_OUT_[L,H,U] registers.
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_LOCK_BOND_OUT_REG_SHIFT                      _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_LOCK_BOND_OUT_REG_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_LOCK_BOND_OUT_REG_SHIFT)
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_LOCK_BOND_OUT_REG_RANGE                      0:0
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_LOCK_BOND_OUT_REG_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_LOCK_BOND_OUT_REG_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_LOCK_BOND_OUT_REG_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_LOCK_BOND_OUT_REG_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_LOCK_BOND_OUT_0_LOCK_BOND_OUT_REG_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Reserved address 516 [0x204] 

// Reserved address 520 [0x208] 

// Reserved address 524 [0x20c] 

// Reserved address 528 [0x210] 

// Reserved address 532 [0x214] 

// Reserved address 536 [0x218] 

// Reserved address 540 [0x21c] 

// Reserved address 544 [0x220] 

// Reserved address 548 [0x224] 

// Reserved address 552 [0x228] 

// Reserved address 556 [0x22c] 

// Reserved address 560 [0x230] 

// Reserved address 564 [0x234] 

// Reserved address 568 [0x238] 

// Reserved address 572 [0x23c] 

// Reserved address 576 [0x240] 

// Reserved address 580 [0x244] 

// Reserved address 584 [0x248] 

// Reserved address 588 [0x24c] 

// Reserved address 592 [0x250] 

// Reserved address 596 [0x254] 

// Reserved address 600 [0x258] 

// Reserved address 604 [0x25c] 

// Reserved address 608 [0x260] 

// Reserved address 612 [0x264] 

// Reserved address 616 [0x268] 

// Reserved address 620 [0x26c] 

// Reserved address 624 [0x270] 

// Reserved address 628 [0x274] 

// Reserved address 632 [0x278] 

// Reserved address 636 [0x27c] 

// Reserved address 640 [0x280] 

// Reserved address 644 [0x284] 

// Reserved address 648 [0x288] 

// Reserved address 652 [0x28c] 

// Reserved address 656 [0x290] 

// Reserved address 660 [0x294] 

// Reserved address 664 [0x298] 

// Reserved address 668 [0x29c] 

// Reserved address 672 [0x2a0] 

// Reserved address 676 [0x2a4] 

// Reserved address 680 [0x2a8] 

// Reserved address 684 [0x2ac] 

// Reserved address 688 [0x2b0] 

// Reserved address 692 [0x2b4] 

// Reserved address 696 [0x2b8] 

// Reserved address 700 [0x2bc] 

// Reserved address 704 [0x2c0] 

// Reserved address 708 [0x2c4] 

// Reserved address 712 [0x2c8] 

// Reserved address 716 [0x2cc] 

// Reserved address 720 [0x2d0] 

// Reserved address 724 [0x2d4] 

// Reserved address 728 [0x2d8] 

// Reserved address 732 [0x2dc] 

// Reserved address 736 [0x2e0] 

// Reserved address 740 [0x2e4] 

// Reserved address 744 [0x2e8] 

// Reserved address 748 [0x2ec] 

// Reserved address 752 [0x2f0] 

// Reserved address 756 [0x2f4] 

// Reserved address 760 [0x2f8] 

// Reserved address 764 [0x2fc] 

// Register CLK_RST_CONTROLLER_RST_DEV_L_SET_0  
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0                      _MK_ADDR_CONST(0x300)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_RESET_VAL                    _MK_MASK_CONST(0x3ffffec9)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_RESET_MASK                   _MK_MASK_CONST(0xbfffffff)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_READ_MASK                    _MK_MASK_CONST(0xbfffffff)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_WRITE_MASK                   _MK_MASK_CONST(0xbfffffff)
// set reset COP cache controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CACHE2_RST_SHIFT                 _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CACHE2_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CACHE2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CACHE2_RST_RANGE                 31:31
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CACHE2_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CACHE2_RST_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CACHE2_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CACHE2_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CACHE2_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// set reset vector co-processor.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VCP_RST_SHIFT                    _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VCP_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VCP_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VCP_RST_RANGE                    29:29
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VCP_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VCP_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VCP_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VCP_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VCP_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset HOST1X.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_HOST1X_RST_SHIFT                 _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_HOST1X_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_HOST1X_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_HOST1X_RST_RANGE                 28:28
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_HOST1X_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_HOST1X_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_HOST1X_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_HOST1X_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_HOST1X_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// set reset DISP1 controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP1_RST_SHIFT                  _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP1_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP1_RST_RANGE                  27:27
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP1_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP1_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP1_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP1_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP1_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// set reset DISP2 controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP2_RST_SHIFT                  _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP2_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP2_RST_RANGE                  26:26
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP2_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP2_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP2_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP2_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_DISP2_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// set reset IDE controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_IDE_RST_SHIFT                    _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_IDE_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_IDE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_IDE_RST_RANGE                    25:25
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_IDE_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_IDE_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_IDE_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_IDE_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_IDE_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset 3D controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_3D_RST_SHIFT                     _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_3D_RST_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_3D_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_3D_RST_RANGE                     24:24
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_3D_RST_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_3D_RST_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_3D_RST_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_3D_RST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_3D_RST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// set reset ISP controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_ISP_RST_SHIFT                    _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_ISP_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_ISP_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_ISP_RST_RANGE                    23:23
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_ISP_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_ISP_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_ISP_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_ISP_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_ISP_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset USB controller
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_USBD_RST_SHIFT                   _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_USBD_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_USBD_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_USBD_RST_RANGE                   22:22
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_USBD_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_USBD_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_USBD_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_USBD_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_USBD_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset 2D graphics engine controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_2D_RST_SHIFT                     _MK_SHIFT_CONST(21)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_2D_RST_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_2D_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_2D_RST_RANGE                     21:21
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_2D_RST_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_2D_RST_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_2D_RST_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_2D_RST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_2D_RST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// set reset VI controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VI_RST_SHIFT                     _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VI_RST_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VI_RST_RANGE                     20:20
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VI_RST_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VI_RST_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VI_RST_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VI_RST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_VI_RST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// set reset EPP controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_EPP_RST_SHIFT                    _MK_SHIFT_CONST(19)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_EPP_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_EPP_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_EPP_RST_RANGE                    19:19
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_EPP_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_EPP_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_EPP_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_EPP_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_EPP_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset I2S 2 Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S2_RST_SHIFT                   _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S2_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S2_RST_RANGE                   18:18
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S2_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S2_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S2_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S2_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S2_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset Pulse Width Modulator
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_PWM_RST_SHIFT                    _MK_SHIFT_CONST(17)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_PWM_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_PWM_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_PWM_RST_RANGE                    17:17
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_PWM_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_PWM_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_PWM_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_PWM_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_PWM_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset Three Wire Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TWC_RST_SHIFT                    _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TWC_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TWC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TWC_RST_RANGE                    16:16
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TWC_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TWC_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TWC_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TWC_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TWC_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset SDMMC4 controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC4_RST_SHIFT                 _MK_SHIFT_CONST(15)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC4_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC4_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC4_RST_RANGE                 15:15
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC4_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC4_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC4_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC4_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC4_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// set reset SDMMC1 controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC1_RST_SHIFT                 _MK_SHIFT_CONST(14)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC1_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC1_RST_RANGE                 14:14
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC1_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC1_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC1_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC1_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC1_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// set reset NAND flash controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_NDFLASH_RST_SHIFT                        _MK_SHIFT_CONST(13)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_NDFLASH_RST_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_NDFLASH_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_NDFLASH_RST_RANGE                        13:13
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_NDFLASH_RST_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_NDFLASH_RST_DEFAULT                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_NDFLASH_RST_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_NDFLASH_RST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_NDFLASH_RST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// set reset I2C1 Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2C1_RST_SHIFT                   _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2C1_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2C1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2C1_RST_RANGE                   12:12
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2C1_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2C1_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2C1_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2C1_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2C1_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset I2S 1 Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S1_RST_SHIFT                   _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S1_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S1_RST_RANGE                   11:11
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S1_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S1_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S1_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S1_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_I2S1_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset SPDIF Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SPDIF_RST_SHIFT                  _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SPDIF_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SPDIF_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SPDIF_RST_RANGE                  10:10
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SPDIF_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SPDIF_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SPDIF_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SPDIF_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SPDIF_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// set reset SDMMC2 Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC2_RST_SHIFT                 _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC2_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC2_RST_RANGE                 9:9
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC2_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC2_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC2_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC2_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_SDMMC2_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// set reset GPIO Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_GPIO_RST_SHIFT                   _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_GPIO_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_GPIO_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_GPIO_RST_RANGE                   8:8
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_GPIO_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_GPIO_RST_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_GPIO_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_GPIO_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_GPIO_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset UARTB/VFIR Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTB_RST_SHIFT                  _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTB_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTB_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTB_RST_RANGE                  7:7
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTB_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTB_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTB_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTB_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTB_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// set reset UARTA Controller 
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTA_RST_SHIFT                  _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTA_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTA_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTA_RST_RANGE                  6:6
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTA_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTA_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTA_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTA_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_UARTA_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// set reset Timer Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TMR_RST_SHIFT                    _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TMR_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TMR_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TMR_RST_RANGE                    5:5
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TMR_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TMR_RST_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TMR_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TMR_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TMR_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset RTC Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_RTC_RST_SHIFT                    _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_RTC_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_RTC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_RTC_RST_RANGE                    4:4
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_RTC_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_RTC_RST_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_RTC_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_RTC_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_RTC_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset AC97 Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_AC97_RST_SHIFT                   _MK_SHIFT_CONST(3)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_AC97_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_AC97_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_AC97_RST_RANGE                   3:3
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_AC97_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_AC97_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_AC97_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_AC97_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_AC97_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Write 1 to pulse System Reset Signal.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TRIG_SYS_RST_SHIFT                       _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TRIG_SYS_RST_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TRIG_SYS_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TRIG_SYS_RST_RANGE                       2:2
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TRIG_SYS_RST_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TRIG_SYS_RST_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TRIG_SYS_RST_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TRIG_SYS_RST_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_TRIG_SYS_RST_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// set reset COP.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_COP_RST_SHIFT                    _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_COP_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_COP_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_COP_RST_RANGE                    1:1
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_COP_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_COP_RST_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_COP_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_COP_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_COP_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset CPU.
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CPU_RST_SHIFT                    _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CPU_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CPU_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CPU_RST_RANGE                    0:0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CPU_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CPU_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CPU_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CPU_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_SET_0_SET_CPU_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_RST_DEV_L_CLR_0  
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0                      _MK_ADDR_CONST(0x304)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_RESET_VAL                    _MK_MASK_CONST(0x3ffffec9)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_RESET_MASK                   _MK_MASK_CONST(0xbffffffb)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_READ_MASK                    _MK_MASK_CONST(0xbffffffb)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_WRITE_MASK                   _MK_MASK_CONST(0xbffffffb)
// clear reset COP cache controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CACHE2_RST_SHIFT                 _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CACHE2_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CACHE2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CACHE2_RST_RANGE                 31:31
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CACHE2_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CACHE2_RST_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CACHE2_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CACHE2_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CACHE2_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// clear reset vector co-processor.
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VCP_RST_SHIFT                    _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VCP_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VCP_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VCP_RST_RANGE                    29:29
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VCP_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VCP_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VCP_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VCP_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VCP_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset HOST1X.
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_HOST1X_RST_SHIFT                 _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_HOST1X_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_HOST1X_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_HOST1X_RST_RANGE                 28:28
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_HOST1X_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_HOST1X_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_HOST1X_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_HOST1X_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_HOST1X_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// clear reset DISP1 controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP1_RST_SHIFT                  _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP1_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP1_RST_RANGE                  27:27
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP1_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP1_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP1_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP1_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP1_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// clear reset DISP2 controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP2_RST_SHIFT                  _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP2_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP2_RST_RANGE                  26:26
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP2_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP2_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP2_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP2_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_DISP2_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// clear reset IDE controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_IDE_RST_SHIFT                    _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_IDE_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_IDE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_IDE_RST_RANGE                    25:25
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_IDE_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_IDE_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_IDE_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_IDE_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_IDE_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset 3D controlelr.
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_3D_RST_SHIFT                     _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_3D_RST_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_3D_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_3D_RST_RANGE                     24:24
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_3D_RST_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_3D_RST_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_3D_RST_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_3D_RST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_3D_RST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// clear reset ISP controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_ISP_RST_SHIFT                    _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_ISP_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_ISP_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_ISP_RST_RANGE                    23:23
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_ISP_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_ISP_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_ISP_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_ISP_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_ISP_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset USB controller
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_USBD_RST_SHIFT                   _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_USBD_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_USBD_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_USBD_RST_RANGE                   22:22
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_USBD_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_USBD_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_USBD_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_USBD_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_USBD_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset 2D graphics engine controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_2D_RST_SHIFT                     _MK_SHIFT_CONST(21)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_2D_RST_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_2D_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_2D_RST_RANGE                     21:21
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_2D_RST_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_2D_RST_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_2D_RST_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_2D_RST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_2D_RST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// clear reset VI controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VI_RST_SHIFT                     _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VI_RST_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VI_RST_RANGE                     20:20
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VI_RST_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VI_RST_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VI_RST_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VI_RST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_VI_RST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// clear reset EPP controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_EPP_RST_SHIFT                    _MK_SHIFT_CONST(19)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_EPP_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_EPP_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_EPP_RST_RANGE                    19:19
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_EPP_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_EPP_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_EPP_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_EPP_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_EPP_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset I2S 2 Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S2_RST_SHIFT                   _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S2_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S2_RST_RANGE                   18:18
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S2_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S2_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S2_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S2_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S2_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset Pulse Width Modulator
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_PWM_RST_SHIFT                    _MK_SHIFT_CONST(17)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_PWM_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_PWM_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_PWM_RST_RANGE                    17:17
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_PWM_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_PWM_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_PWM_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_PWM_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_PWM_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset Three Wire Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TWC_RST_SHIFT                    _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TWC_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TWC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TWC_RST_RANGE                    16:16
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TWC_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TWC_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TWC_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TWC_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TWC_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset SDMMC4 controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC4_RST_SHIFT                 _MK_SHIFT_CONST(15)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC4_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC4_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC4_RST_RANGE                 15:15
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC4_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC4_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC4_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC4_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC4_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// clear reset SDMMC1 controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC1_RST_SHIFT                 _MK_SHIFT_CONST(14)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC1_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC1_RST_RANGE                 14:14
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC1_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC1_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC1_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC1_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC1_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// clear reset NAND flash controller.
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_NDFLASH_RST_SHIFT                        _MK_SHIFT_CONST(13)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_NDFLASH_RST_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_NDFLASH_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_NDFLASH_RST_RANGE                        13:13
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_NDFLASH_RST_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_NDFLASH_RST_DEFAULT                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_NDFLASH_RST_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_NDFLASH_RST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_NDFLASH_RST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// clear reset I2C1 Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2C1_RST_SHIFT                   _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2C1_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2C1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2C1_RST_RANGE                   12:12
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2C1_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2C1_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2C1_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2C1_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2C1_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset I2S 1 Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S1_RST_SHIFT                   _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S1_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S1_RST_RANGE                   11:11
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S1_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S1_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S1_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S1_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_I2S1_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset SPDIF Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SPDIF_RST_SHIFT                  _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SPDIF_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SPDIF_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SPDIF_RST_RANGE                  10:10
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SPDIF_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SPDIF_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SPDIF_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SPDIF_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SPDIF_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// clear reset SDMMC2 Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC2_RST_SHIFT                 _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC2_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC2_RST_RANGE                 9:9
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC2_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC2_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC2_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC2_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_SDMMC2_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// clear reset GPIO Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_GPIO_RST_SHIFT                   _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_GPIO_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_GPIO_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_GPIO_RST_RANGE                   8:8
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_GPIO_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_GPIO_RST_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_GPIO_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_GPIO_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_GPIO_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset UARTB/VFIR Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTB_RST_SHIFT                  _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTB_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTB_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTB_RST_RANGE                  7:7
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTB_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTB_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTB_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTB_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTB_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// clear reset UARTA Controller 
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTA_RST_SHIFT                  _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTA_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTA_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTA_RST_RANGE                  6:6
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTA_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTA_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTA_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTA_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_UARTA_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// clear reset Timer Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TMR_RST_SHIFT                    _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TMR_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TMR_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TMR_RST_RANGE                    5:5
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TMR_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TMR_RST_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TMR_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TMR_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_TMR_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset RTC Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_RTC_RST_SHIFT                    _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_RTC_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_RTC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_RTC_RST_RANGE                    4:4
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_RTC_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_RTC_RST_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_RTC_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_RTC_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_RTC_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset AC97 Controller
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_AC97_RST_SHIFT                   _MK_SHIFT_CONST(3)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_AC97_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_AC97_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_AC97_RST_RANGE                   3:3
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_AC97_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_AC97_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_AC97_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_AC97_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_AC97_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset COP.
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_COP_RST_SHIFT                    _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_COP_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_COP_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_COP_RST_RANGE                    1:1
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_COP_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_COP_RST_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_COP_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_COP_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_COP_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset CPU.
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CPU_RST_SHIFT                    _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CPU_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CPU_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CPU_RST_RANGE                    0:0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CPU_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CPU_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CPU_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CPU_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_L_CLR_0_CLR_CPU_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_RST_DEV_H_SET_0  
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0                      _MK_ADDR_CONST(0x308)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_RESET_VAL                    _MK_MASK_CONST(0xfefffb77)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_RESET_MASK                   _MK_MASK_CONST(0xfefffff7)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_READ_MASK                    _MK_MASK_CONST(0xfefffff7)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_WRITE_MASK                   _MK_MASK_CONST(0xfefffff7)
// set reset BSEV controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEV_RST_SHIFT                   _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEV_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEV_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEV_RST_RANGE                   31:31
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEV_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEV_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEV_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEV_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEV_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset BSEA controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEA_RST_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEA_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEA_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEA_RST_RANGE                   30:30
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEA_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEA_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEA_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEA_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_BSEA_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset VDE controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_VDE_RST_SHIFT                    _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_VDE_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_VDE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_VDE_RST_RANGE                    29:29
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_VDE_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_VDE_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_VDE_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_VDE_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_VDE_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset MPE controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MPE_RST_SHIFT                    _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MPE_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MPE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MPE_RST_RANGE                    28:28
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MPE_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MPE_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MPE_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MPE_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MPE_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset USB3 controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB3_RST_SHIFT                   _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB3_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB3_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB3_RST_RANGE                   27:27
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB3_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB3_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB3_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB3_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB3_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset USB2 controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB2_RST_SHIFT                   _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB2_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB2_RST_RANGE                   26:26
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB2_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB2_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB2_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB2_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_USB2_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset EMC controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_EMC_RST_SHIFT                    _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_EMC_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_EMC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_EMC_RST_RANGE                    25:25
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_EMC_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_EMC_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_EMC_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_EMC_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_EMC_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset UART C Controller
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_UARTC_RST_SHIFT                  _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_UARTC_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_UARTC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_UARTC_RST_RANGE                  23:23
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_UARTC_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_UARTC_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_UARTC_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_UARTC_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_UARTC_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// set reset I2C 2 controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_I2C2_RST_SHIFT                   _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_I2C2_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_I2C2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_I2C2_RST_RANGE                   22:22
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_I2C2_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_I2C2_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_I2C2_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_I2C2_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_I2C2_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset TVDAC controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVDAC_RST_SHIFT                  _MK_SHIFT_CONST(21)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVDAC_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVDAC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVDAC_RST_RANGE                  21:21
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVDAC_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVDAC_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVDAC_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVDAC_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVDAC_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// set reset CSI controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_CSI_RST_SHIFT                    _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_CSI_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_CSI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_CSI_RST_RANGE                    20:20
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_CSI_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_CSI_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_CSI_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_CSI_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_CSI_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset HDMI
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_HDMI_RST_SHIFT                   _MK_SHIFT_CONST(19)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_HDMI_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_HDMI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_HDMI_RST_RANGE                   19:19
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_HDMI_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_HDMI_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_HDMI_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_HDMI_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_HDMI_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset MIPI base-band controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MIPI_RST_SHIFT                   _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MIPI_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MIPI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MIPI_RST_RANGE                   18:18
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MIPI_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MIPI_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MIPI_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MIPI_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MIPI_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset TVO/CVE controller
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVO_RST_SHIFT                    _MK_SHIFT_CONST(17)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVO_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVO_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVO_RST_RANGE                    17:17
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVO_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVO_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVO_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVO_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_TVO_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset DSI controller
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DSI_RST_SHIFT                    _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DSI_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DSI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DSI_RST_RANGE                    16:16
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DSI_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DSI_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DSI_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DSI_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DSI_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset DVC-I2C Controller
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DVC_I2C_RST_SHIFT                        _MK_SHIFT_CONST(15)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DVC_I2C_RST_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DVC_I2C_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DVC_I2C_RST_RANGE                        15:15
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DVC_I2C_RST_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DVC_I2C_RST_DEFAULT                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DVC_I2C_RST_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DVC_I2C_RST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_DVC_I2C_RST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// set reset SBC 3 Controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC3_RST_SHIFT                   _MK_SHIFT_CONST(14)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC3_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC3_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC3_RST_RANGE                   14:14
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC3_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC3_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC3_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC3_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC3_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset XIO controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_XIO_RST_SHIFT                    _MK_SHIFT_CONST(13)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_XIO_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_XIO_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_XIO_RST_RANGE                    13:13
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_XIO_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_XIO_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_XIO_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_XIO_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_XIO_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset SBC 2 Controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC2_RST_SHIFT                   _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC2_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC2_RST_RANGE                   12:12
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC2_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC2_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC2_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC2_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC2_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset SPI 1 Controller
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SPI1_RST_SHIFT                   _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SPI1_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SPI1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SPI1_RST_RANGE                   11:11
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SPI1_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SPI1_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SPI1_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SPI1_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SPI1_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset NOR Flash Controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_NOR_RST_SHIFT                    _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_NOR_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_NOR_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_NOR_RST_RANGE                    10:10
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_NOR_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_NOR_RST_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_NOR_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_NOR_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_NOR_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset NOR Flash Controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SNOR_RST_SHIFT                   _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SNOR_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SNOR_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SNOR_RST_RANGE                   10:10
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SNOR_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SNOR_RST_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SNOR_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SNOR_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SNOR_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset SBC 1 Controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC1_RST_SHIFT                   _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC1_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC1_RST_RANGE                   9:9
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC1_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC1_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC1_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC1_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_SBC1_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset KFuse controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KFUSE_RST_SHIFT                  _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KFUSE_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KFUSE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KFUSE_RST_RANGE                  8:8
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KFUSE_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KFUSE_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KFUSE_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KFUSE_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KFUSE_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// set reset Fuse controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_FUSE_RST_SHIFT                   _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_FUSE_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_FUSE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_FUSE_RST_RANGE                   7:7
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_FUSE_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_FUSE_RST_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_FUSE_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_FUSE_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_FUSE_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset PMC controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_PMC_RST_SHIFT                    _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_PMC_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_PMC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_PMC_RST_RANGE                    6:6
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_PMC_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_PMC_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_PMC_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_PMC_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_PMC_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset statistic monitor
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_STAT_MON_RST_SHIFT                       _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_STAT_MON_RST_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_STAT_MON_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_STAT_MON_RST_RANGE                       5:5
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_STAT_MON_RST_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_STAT_MON_RST_DEFAULT                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_STAT_MON_RST_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_STAT_MON_RST_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_STAT_MON_RST_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// set reset Keyboard controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KBC_RST_SHIFT                    _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KBC_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KBC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KBC_RST_RANGE                    4:4
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KBC_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KBC_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KBC_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KBC_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_KBC_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset APB-DMA.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_APBDMA_RST_SHIFT                 _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_APBDMA_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_APBDMA_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_APBDMA_RST_RANGE                 2:2
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_APBDMA_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_APBDMA_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_APBDMA_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_APBDMA_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_APBDMA_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// set reset AHB-DMA.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_AHBDMA_RST_SHIFT                 _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_AHBDMA_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_AHBDMA_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_AHBDMA_RST_RANGE                 1:1
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_AHBDMA_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_AHBDMA_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_AHBDMA_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_AHBDMA_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_AHBDMA_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// set reset MC.
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MEM_RST_SHIFT                    _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MEM_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MEM_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MEM_RST_RANGE                    0:0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MEM_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MEM_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MEM_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MEM_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_SET_0_SET_MEM_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_RST_DEV_H_CLR_0  
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0                      _MK_ADDR_CONST(0x30c)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_RESET_VAL                    _MK_MASK_CONST(0xfefffb77)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_RESET_MASK                   _MK_MASK_CONST(0xfefffff7)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_READ_MASK                    _MK_MASK_CONST(0xfefffff7)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_WRITE_MASK                   _MK_MASK_CONST(0xfefffff7)
// clear reset BSEV controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEV_RST_SHIFT                   _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEV_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEV_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEV_RST_RANGE                   31:31
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEV_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEV_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEV_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEV_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEV_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset BSEA controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEA_RST_SHIFT                   _MK_SHIFT_CONST(30)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEA_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEA_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEA_RST_RANGE                   30:30
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEA_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEA_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEA_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEA_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_BSEA_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset VDE controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_VDE_RST_SHIFT                    _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_VDE_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_VDE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_VDE_RST_RANGE                    29:29
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_VDE_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_VDE_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_VDE_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_VDE_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_VDE_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset MPE controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MPE_RST_SHIFT                    _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MPE_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MPE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MPE_RST_RANGE                    28:28
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MPE_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MPE_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MPE_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MPE_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MPE_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset USB3 controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB3_RST_SHIFT                   _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB3_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB3_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB3_RST_RANGE                   27:27
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB3_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB3_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB3_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB3_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB3_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset USB2 controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB2_RST_SHIFT                   _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB2_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB2_RST_RANGE                   26:26
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB2_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB2_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB2_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB2_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_USB2_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset EMC controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_EMC_RST_SHIFT                    _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_EMC_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_EMC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_EMC_RST_RANGE                    25:25
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_EMC_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_EMC_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_EMC_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_EMC_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_EMC_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset UART C Controller
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_UARTC_RST_SHIFT                  _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_UARTC_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_UARTC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_UARTC_RST_RANGE                  23:23
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_UARTC_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_UARTC_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_UARTC_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_UARTC_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_UARTC_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// clear reset I2C 2 controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_I2C2_RST_SHIFT                   _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_I2C2_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_I2C2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_I2C2_RST_RANGE                   22:22
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_I2C2_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_I2C2_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_I2C2_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_I2C2_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_I2C2_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset TVDAC controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVDAC_RST_SHIFT                  _MK_SHIFT_CONST(21)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVDAC_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVDAC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVDAC_RST_RANGE                  21:21
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVDAC_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVDAC_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVDAC_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVDAC_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVDAC_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// clear reset CSI controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_CSI_RST_SHIFT                    _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_CSI_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_CSI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_CSI_RST_RANGE                    20:20
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_CSI_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_CSI_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_CSI_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_CSI_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_CSI_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset HDMI
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_HDMI_RST_SHIFT                   _MK_SHIFT_CONST(19)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_HDMI_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_HDMI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_HDMI_RST_RANGE                   19:19
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_HDMI_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_HDMI_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_HDMI_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_HDMI_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_HDMI_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset MIPI base-band controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MIPI_RST_SHIFT                   _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MIPI_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MIPI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MIPI_RST_RANGE                   18:18
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MIPI_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MIPI_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MIPI_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MIPI_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MIPI_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset TVO/CVE controller
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVO_RST_SHIFT                    _MK_SHIFT_CONST(17)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVO_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVO_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVO_RST_RANGE                    17:17
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVO_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVO_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVO_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVO_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_TVO_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset DSI controller
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DSI_RST_SHIFT                    _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DSI_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DSI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DSI_RST_RANGE                    16:16
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DSI_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DSI_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DSI_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DSI_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DSI_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset DVC-I2C Controller
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DVC_I2C_RST_SHIFT                        _MK_SHIFT_CONST(15)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DVC_I2C_RST_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DVC_I2C_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DVC_I2C_RST_RANGE                        15:15
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DVC_I2C_RST_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DVC_I2C_RST_DEFAULT                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DVC_I2C_RST_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DVC_I2C_RST_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_DVC_I2C_RST_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// clear reset SBC 3 Controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC3_RST_SHIFT                   _MK_SHIFT_CONST(14)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC3_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC3_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC3_RST_RANGE                   14:14
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC3_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC3_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC3_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC3_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC3_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset XIO controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_XIO_RST_SHIFT                    _MK_SHIFT_CONST(13)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_XIO_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_XIO_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_XIO_RST_RANGE                    13:13
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_XIO_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_XIO_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_XIO_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_XIO_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_XIO_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset SBC 2 Controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC2_RST_SHIFT                   _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC2_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC2_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC2_RST_RANGE                   12:12
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC2_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC2_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC2_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC2_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC2_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset SPI 1 Controller
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SPI1_RST_SHIFT                   _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SPI1_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SPI1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SPI1_RST_RANGE                   11:11
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SPI1_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SPI1_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SPI1_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SPI1_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SPI1_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset NOR Flash Controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_NOR_RST_SHIFT                    _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_NOR_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_NOR_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_NOR_RST_RANGE                    10:10
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_NOR_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_NOR_RST_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_NOR_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_NOR_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_NOR_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset NOR Flash Controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SNOR_RST_SHIFT                   _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SNOR_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SNOR_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SNOR_RST_RANGE                   10:10
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SNOR_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SNOR_RST_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SNOR_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SNOR_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SNOR_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset SBC 1 Controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC1_RST_SHIFT                   _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC1_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC1_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC1_RST_RANGE                   9:9
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC1_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC1_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC1_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC1_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_SBC1_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset KFuse controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KFUSE_RST_SHIFT                  _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KFUSE_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KFUSE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KFUSE_RST_RANGE                  8:8
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KFUSE_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KFUSE_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KFUSE_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KFUSE_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KFUSE_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// clear reset Fuse controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_FUSE_RST_SHIFT                   _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_FUSE_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_FUSE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_FUSE_RST_RANGE                   7:7
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_FUSE_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_FUSE_RST_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_FUSE_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_FUSE_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_FUSE_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset PMC controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_PMC_RST_SHIFT                    _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_PMC_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_PMC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_PMC_RST_RANGE                    6:6
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_PMC_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_PMC_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_PMC_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_PMC_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_PMC_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset statistic monitor
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_STAT_MON_RST_SHIFT                       _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_STAT_MON_RST_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_STAT_MON_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_STAT_MON_RST_RANGE                       5:5
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_STAT_MON_RST_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_STAT_MON_RST_DEFAULT                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_STAT_MON_RST_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_STAT_MON_RST_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_STAT_MON_RST_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// clear reset Keyboard controller.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KBC_RST_SHIFT                    _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KBC_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KBC_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KBC_RST_RANGE                    4:4
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KBC_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KBC_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KBC_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KBC_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_KBC_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset APB-DMA.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_APBDMA_RST_SHIFT                 _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_APBDMA_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_APBDMA_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_APBDMA_RST_RANGE                 2:2
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_APBDMA_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_APBDMA_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_APBDMA_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_APBDMA_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_APBDMA_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// clear reset AHB-DMA.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_AHBDMA_RST_SHIFT                 _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_AHBDMA_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_AHBDMA_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_AHBDMA_RST_RANGE                 1:1
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_AHBDMA_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_AHBDMA_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_AHBDMA_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_AHBDMA_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_AHBDMA_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// clear reset MC.
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MEM_RST_SHIFT                    _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MEM_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MEM_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MEM_RST_RANGE                    0:0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MEM_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MEM_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MEM_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MEM_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_H_CLR_0_CLR_MEM_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_RST_DEV_U_SET_0  
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0                      _MK_ADDR_CONST(0x310)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_RESET_VAL                    _MK_MASK_CONST(0x15ff)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_RESET_MASK                   _MK_MASK_CONST(0x1fff)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_READ_MASK                    _MK_MASK_CONST(0x1fff)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_WRITE_MASK                   _MK_MASK_CONST(0x1fff)
// set reset LA logic.
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_LA_RST_SHIFT                     _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_LA_RST_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_LA_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_LA_RST_RANGE                     12:12
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_LA_RST_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_LA_RST_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_LA_RST_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_LA_RST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_LA_RST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// set reset AVPUCQ logic.
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AVPUCQ_RST_SHIFT                 _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AVPUCQ_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AVPUCQ_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AVPUCQ_RST_RANGE                 11:11
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AVPUCQ_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AVPUCQ_RST_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AVPUCQ_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AVPUCQ_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AVPUCQ_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// set reset PCIEXCLK logic.
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIEXCLK_RST_SHIFT                       _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIEXCLK_RST_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIEXCLK_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIEXCLK_RST_RANGE                       10:10
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIEXCLK_RST_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIEXCLK_RST_DEFAULT                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIEXCLK_RST_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIEXCLK_RST_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIEXCLK_RST_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// set reset CSITE controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_CSITE_RST_SHIFT                  _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_CSITE_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_CSITE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_CSITE_RST_RANGE                  9:9
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_CSITE_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_CSITE_RST_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_CSITE_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_CSITE_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_CSITE_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// set reset AFI controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AFI_RST_SHIFT                    _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AFI_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AFI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AFI_RST_RANGE                    8:8
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AFI_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AFI_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AFI_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AFI_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_AFI_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset OWR controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_OWR_RST_SHIFT                    _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_OWR_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_OWR_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_OWR_RST_RANGE                    7:7
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_OWR_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_OWR_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_OWR_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_OWR_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_OWR_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set reset PCIE controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIE_RST_SHIFT                   _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIE_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIE_RST_RANGE                   6:6
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIE_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIE_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIE_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIE_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_PCIE_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset SDMMC3 controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SDMMC3_RST_SHIFT                 _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SDMMC3_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SDMMC3_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SDMMC3_RST_RANGE                 5:5
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SDMMC3_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SDMMC3_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SDMMC3_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SDMMC3_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SDMMC3_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// set reset SBC4 controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SBC4_RST_SHIFT                   _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SBC4_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SBC4_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SBC4_RST_RANGE                   4:4
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SBC4_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SBC4_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SBC4_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SBC4_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SBC4_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset I2C3 controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_I2C3_RST_SHIFT                   _MK_SHIFT_CONST(3)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_I2C3_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_I2C3_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_I2C3_RST_RANGE                   3:3
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_I2C3_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_I2C3_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_I2C3_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_I2C3_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_I2C3_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// set reset UARTE controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTE_RST_SHIFT                  _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTE_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTE_RST_RANGE                  2:2
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTE_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTE_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTE_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTE_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTE_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// set reset UARTD controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTD_RST_SHIFT                  _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTD_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTD_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTD_RST_RANGE                  1:1
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTD_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTD_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTD_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTD_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_UARTD_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// set reset SPEEDO controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SPEEDO_RST_SHIFT                 _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SPEEDO_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SPEEDO_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SPEEDO_RST_RANGE                 0:0
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SPEEDO_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SPEEDO_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SPEEDO_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SPEEDO_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_SET_0_SET_SPEEDO_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_RST_DEV_U_CLR_0  
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0                      _MK_ADDR_CONST(0x314)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_RESET_VAL                    _MK_MASK_CONST(0x15ff)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_RESET_MASK                   _MK_MASK_CONST(0x1fff)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_READ_MASK                    _MK_MASK_CONST(0x1fff)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_WRITE_MASK                   _MK_MASK_CONST(0x1fff)
// clear reset LA logic.
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_LA_RST_SHIFT                     _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_LA_RST_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_LA_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_LA_RST_RANGE                     12:12
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_LA_RST_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_LA_RST_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_LA_RST_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_LA_RST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_LA_RST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// clear reset AVPUCQ logic.
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AVPUCQ_RST_SHIFT                 _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AVPUCQ_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AVPUCQ_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AVPUCQ_RST_RANGE                 11:11
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AVPUCQ_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AVPUCQ_RST_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AVPUCQ_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AVPUCQ_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AVPUCQ_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// clear reset PCIEXCLK logic.
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIEXCLK_RST_SHIFT                       _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIEXCLK_RST_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIEXCLK_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIEXCLK_RST_RANGE                       10:10
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIEXCLK_RST_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIEXCLK_RST_DEFAULT                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIEXCLK_RST_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIEXCLK_RST_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIEXCLK_RST_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// clear reset CSITE controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_CSITE_RST_SHIFT                  _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_CSITE_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_CSITE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_CSITE_RST_RANGE                  9:9
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_CSITE_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_CSITE_RST_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_CSITE_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_CSITE_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_CSITE_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// clear reset AFI controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AFI_RST_SHIFT                    _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AFI_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AFI_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AFI_RST_RANGE                    8:8
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AFI_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AFI_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AFI_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AFI_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_AFI_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset OWR controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_OWR_RST_SHIFT                    _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_OWR_RST_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_OWR_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_OWR_RST_RANGE                    7:7
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_OWR_RST_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_OWR_RST_DEFAULT                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_OWR_RST_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_OWR_RST_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_OWR_RST_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear reset PCIE controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIE_RST_SHIFT                   _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIE_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIE_RST_RANGE                   6:6
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIE_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIE_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIE_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIE_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_PCIE_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset SDMMC3 controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SDMMC3_RST_SHIFT                 _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SDMMC3_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SDMMC3_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SDMMC3_RST_RANGE                 5:5
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SDMMC3_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SDMMC3_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SDMMC3_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SDMMC3_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SDMMC3_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// clear reset SBC4 controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SBC4_RST_SHIFT                   _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SBC4_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SBC4_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SBC4_RST_RANGE                   4:4
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SBC4_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SBC4_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SBC4_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SBC4_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SBC4_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset I2C3 controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_I2C3_RST_SHIFT                   _MK_SHIFT_CONST(3)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_I2C3_RST_FIELD                   (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_I2C3_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_I2C3_RST_RANGE                   3:3
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_I2C3_RST_WOFFSET                 0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_I2C3_RST_DEFAULT                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_I2C3_RST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_I2C3_RST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_I2C3_RST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// clear reset UARTE controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTE_RST_SHIFT                  _MK_SHIFT_CONST(2)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTE_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTE_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTE_RST_RANGE                  2:2
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTE_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTE_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTE_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTE_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTE_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// clear reset UARTD controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTD_RST_SHIFT                  _MK_SHIFT_CONST(1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTD_RST_FIELD                  (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTD_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTD_RST_RANGE                  1:1
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTD_RST_WOFFSET                        0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTD_RST_DEFAULT                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTD_RST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTD_RST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_UARTD_RST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// clear reset SPEEDO controller.
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SPEEDO_RST_SHIFT                 _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SPEEDO_RST_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SPEEDO_RST_SHIFT)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SPEEDO_RST_RANGE                 0:0
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SPEEDO_RST_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SPEEDO_RST_DEFAULT                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SPEEDO_RST_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SPEEDO_RST_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_RST_DEV_U_CLR_0_CLR_SPEEDO_RST_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 792 [0x318] 

// Reserved address 796 [0x31c] 

// Register CLK_RST_CONTROLLER_CLK_ENB_L_SET_0  
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0                      _MK_ADDR_CONST(0x320)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_RESET_VAL                    _MK_MASK_CONST(0x80000130)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_RESET_MASK                   _MK_MASK_CONST(0xbffffff9)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_READ_MASK                    _MK_MASK_CONST(0xbffffff9)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_WRITE_MASK                   _MK_MASK_CONST(0xbffffff9)
// set enable clock to COP cache controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CACHE2_SHIFT                     _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CACHE2_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CACHE2_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CACHE2_RANGE                     31:31
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CACHE2_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CACHE2_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CACHE2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CACHE2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CACHE2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// set enable clock to vector co-processor.
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VCP_SHIFT                        _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VCP_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VCP_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VCP_RANGE                        29:29
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VCP_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VCP_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VCP_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VCP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VCP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// set enable clock to HOST1X.
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_HOST1X_SHIFT                     _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_HOST1X_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_HOST1X_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_HOST1X_RANGE                     28:28
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_HOST1X_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_HOST1X_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_HOST1X_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_HOST1X_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_HOST1X_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// set enable clock to DISP1 controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP1_SHIFT                      _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP1_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP1_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP1_RANGE                      27:27
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP1_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP1_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// set enable clock to DISP2 controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP2_SHIFT                      _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP2_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP2_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP2_RANGE                      26:26
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP2_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP2_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_DISP2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// set enable clock to IDE controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_IDE_SHIFT                        _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_IDE_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_IDE_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_IDE_RANGE                        25:25
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_IDE_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_IDE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_IDE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_IDE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_IDE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// set enable clock to 3D controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_3D_SHIFT                 _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_3D_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_3D_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_3D_RANGE                 24:24
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_3D_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_3D_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_3D_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_3D_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_3D_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// set enable clock to ISP controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_ISP_SHIFT                        _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_ISP_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_ISP_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_ISP_RANGE                        23:23
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_ISP_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_ISP_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_ISP_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_ISP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_ISP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// set enable clock to USB controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_USBD_SHIFT                       _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_USBD_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_USBD_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_USBD_RANGE                       22:22
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_USBD_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_USBD_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_USBD_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_USBD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_USBD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// set enable clock to 2D graphics engine.
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_2D_SHIFT                 _MK_SHIFT_CONST(21)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_2D_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_2D_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_2D_RANGE                 21:21
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_2D_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_2D_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_2D_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_2D_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_2D_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// set enable clock to VI controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VI_SHIFT                 _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VI_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VI_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VI_RANGE                 20:20
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VI_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VI_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VI_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VI_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_VI_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// set enable clock to EPP controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_EPP_SHIFT                        _MK_SHIFT_CONST(19)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_EPP_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_EPP_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_EPP_RANGE                        19:19
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_EPP_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_EPP_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_EPP_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_EPP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_EPP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// set enable clock to I2S 2 controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S2_SHIFT                       _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S2_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S2_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S2_RANGE                       18:18
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S2_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S2_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// set enable clock to PWM (Pulse Width Modulator)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_PWM_SHIFT                        _MK_SHIFT_CONST(17)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_PWM_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_PWM_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_PWM_RANGE                        17:17
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_PWM_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_PWM_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_PWM_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_PWM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_PWM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// set enable clock to 3-Wire Interface Controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TWC_SHIFT                        _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TWC_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TWC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TWC_RANGE                        16:16
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TWC_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TWC_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TWC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TWC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TWC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// set enable clock to SDMMC4 controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC4_SHIFT                     _MK_SHIFT_CONST(15)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC4_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC4_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC4_RANGE                     15:15
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC4_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC4_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC4_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC4_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC4_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// set enable clock to SDMMC1 controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC1_SHIFT                     _MK_SHIFT_CONST(14)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC1_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC1_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC1_RANGE                     14:14
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC1_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC1_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// set enable clock to NAND flash controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_NDFLASH_SHIFT                    _MK_SHIFT_CONST(13)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_NDFLASH_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_NDFLASH_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_NDFLASH_RANGE                    13:13
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_NDFLASH_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_NDFLASH_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_NDFLASH_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_NDFLASH_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_NDFLASH_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set enable clock to I2C1 Controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2C1_SHIFT                       _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2C1_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2C1_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2C1_RANGE                       12:12
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2C1_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2C1_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2C1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2C1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2C1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// set enable clock to I2S1 Controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S1_SHIFT                       _MK_SHIFT_CONST(11)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S1_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S1_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S1_RANGE                       11:11
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S1_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S1_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_I2S1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// set enable clock to SPDIF Controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SPDIF_SHIFT                      _MK_SHIFT_CONST(10)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SPDIF_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SPDIF_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SPDIF_RANGE                      10:10
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SPDIF_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SPDIF_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SPDIF_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SPDIF_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SPDIF_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// set enable clock to SDMMC2 controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC2_SHIFT                     _MK_SHIFT_CONST(9)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC2_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC2_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC2_RANGE                     9:9
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC2_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC2_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_SDMMC2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// set enable clock to GPIO Controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_GPIO_SHIFT                       _MK_SHIFT_CONST(8)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_GPIO_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_GPIO_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_GPIO_RANGE                       8:8
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_GPIO_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_GPIO_DEFAULT                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_GPIO_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_GPIO_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_GPIO_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// set enable clock to UARTB/VFIR Controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTB_SHIFT                      _MK_SHIFT_CONST(7)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTB_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTB_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTB_RANGE                      7:7
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTB_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTB_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTB_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTB_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTB_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// set enable clock to UARTA Controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTA_SHIFT                      _MK_SHIFT_CONST(6)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTA_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTA_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTA_RANGE                      6:6
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTA_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTA_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTA_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_UARTA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// set enable clock to Timer Controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TMR_SHIFT                        _MK_SHIFT_CONST(5)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TMR_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TMR_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TMR_RANGE                        5:5
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TMR_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TMR_DEFAULT                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TMR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TMR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_TMR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// set enable clock to RTC Controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_RTC_SHIFT                        _MK_SHIFT_CONST(4)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_RTC_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_RTC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_RTC_RANGE                        4:4
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_RTC_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_RTC_DEFAULT                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_RTC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_RTC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_RTC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// set enable clock to AC97 Controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_AC97_SHIFT                       _MK_SHIFT_CONST(3)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_AC97_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_AC97_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_AC97_RANGE                       3:3
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_AC97_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_AC97_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_AC97_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_AC97_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_AC97_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// set enable clock to CPU.
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CPU_SHIFT                        _MK_SHIFT_CONST(0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CPU_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CPU_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CPU_RANGE                        0:0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CPU_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CPU_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CPU_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CPU_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_SET_0_SET_CLK_ENB_CPU_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0  
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0                      _MK_ADDR_CONST(0x324)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_SECURE                       0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_WORD_COUNT                   0x1
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_RESET_VAL                    _MK_MASK_CONST(0x80000130)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_RESET_MASK                   _MK_MASK_CONST(0xbffffff9)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_READ_MASK                    _MK_MASK_CONST(0xbffffff9)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_WRITE_MASK                   _MK_MASK_CONST(0xbffffff9)
// clear enable clock to COP cache controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_CACHE2_SHIFT                     _MK_SHIFT_CONST(31)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_CACHE2_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_CACHE2_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_CACHE2_RANGE                     31:31
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_CACHE2_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_CACHE2_DEFAULT                   _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_CACHE2_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_CACHE2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_CACHE2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// clear enable clock to vector co-processor.
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VCP_SHIFT                        _MK_SHIFT_CONST(29)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VCP_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VCP_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VCP_RANGE                        29:29
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VCP_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VCP_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VCP_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VCP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VCP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// clear enable clock to HOST1X.
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_HOST1X_SHIFT                     _MK_SHIFT_CONST(28)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_HOST1X_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_HOST1X_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_HOST1X_RANGE                     28:28
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_HOST1X_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_HOST1X_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_HOST1X_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_HOST1X_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_HOST1X_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// clear enable clock to DISP1 controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP1_SHIFT                      _MK_SHIFT_CONST(27)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP1_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP1_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP1_RANGE                      27:27
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP1_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP1_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// clear enable clock to DISP2 controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP2_SHIFT                      _MK_SHIFT_CONST(26)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP2_FIELD                      (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP2_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP2_RANGE                      26:26
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP2_WOFFSET                    0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP2_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_DISP2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// clear enable clock to IDE controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_IDE_SHIFT                        _MK_SHIFT_CONST(25)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_IDE_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_IDE_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_IDE_RANGE                        25:25
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_IDE_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_IDE_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_IDE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_IDE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_IDE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// clear enable clock to 3D controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_3D_SHIFT                 _MK_SHIFT_CONST(24)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_3D_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_3D_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_3D_RANGE                 24:24
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_3D_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_3D_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_3D_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_3D_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_3D_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// clear enable clock to ISP controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_ISP_SHIFT                        _MK_SHIFT_CONST(23)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_ISP_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_ISP_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_ISP_RANGE                        23:23
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_ISP_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_ISP_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_ISP_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_ISP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_ISP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// clear enable clock to USB controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_USBD_SHIFT                       _MK_SHIFT_CONST(22)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_USBD_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_USBD_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_USBD_RANGE                       22:22
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_USBD_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_USBD_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_USBD_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_USBD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_USBD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// clear enable clock to 2D graphics engine.
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_2D_SHIFT                 _MK_SHIFT_CONST(21)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_2D_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_2D_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_2D_RANGE                 21:21
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_2D_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_2D_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_2D_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_2D_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_2D_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// clear enable clock to VI controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VI_SHIFT                 _MK_SHIFT_CONST(20)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VI_FIELD                 (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VI_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VI_RANGE                 20:20
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VI_WOFFSET                       0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VI_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VI_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VI_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_VI_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// clear enable clock to EPP controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_EPP_SHIFT                        _MK_SHIFT_CONST(19)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_EPP_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_EPP_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_EPP_RANGE                        19:19
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_EPP_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_EPP_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_EPP_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_EPP_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_EPP_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// clear enable clock to I2S 2 controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_I2S2_SHIFT                       _MK_SHIFT_CONST(18)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_I2S2_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_I2S2_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_I2S2_RANGE                       18:18
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_I2S2_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_I2S2_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_I2S2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_I2S2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_I2S2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// clear enable clock to PWM (Pulse Width Modulator)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_PWM_SHIFT                        _MK_SHIFT_CONST(17)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_PWM_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_PWM_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_PWM_RANGE                        17:17
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_PWM_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_PWM_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_PWM_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_PWM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_PWM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// clear enable clock to 3-Wire Interface Controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_TWC_SHIFT                        _MK_SHIFT_CONST(16)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_TWC_FIELD                        (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_TWC_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_TWC_RANGE                        16:16
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_TWC_WOFFSET                      0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_TWC_DEFAULT                      _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_TWC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_TWC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_TWC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// clear enable clock to SDMMC4 controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC4_SHIFT                     _MK_SHIFT_CONST(15)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC4_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC4_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC4_RANGE                     15:15
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC4_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC4_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC4_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC4_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC4_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// clear enable clock to SDMMC1 controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC1_SHIFT                     _MK_SHIFT_CONST(14)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC1_FIELD                     (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC1_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC1_RANGE                     14:14
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC1_WOFFSET                   0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC1_DEFAULT                   _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_SDMMC1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// clear enable clock to NAND flash controller.
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_NDFLASH_SHIFT                    _MK_SHIFT_CONST(13)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_NDFLASH_FIELD                    (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_NDFLASH_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_NDFLASH_RANGE                    13:13
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_NDFLASH_WOFFSET                  0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_NDFLASH_DEFAULT                  _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_NDFLASH_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_NDFLASH_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_NDFLASH_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// clear enable clock to I2C1 Controller
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_I2C1_SHIFT                       _MK_SHIFT_CONST(12)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_I2C1_FIELD                       (_MK_MASK_CONST(0x1) << CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_I2C1_SHIFT)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_I2C1_RANGE                       12:12
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_I2C1_WOFFSET                     0x0
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_I2C1_DEFAULT                     _MK_MASK_CONST(0x0)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CLK_ENB_I2C1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define CLK_RST_CONTROLLER_CLK_ENB_L_CLR_0_CLR_CL