/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARDVC_H_INC_
#define ___ARDVC_H_INC_

// Register DVC_CTRL_REG1_0  
#define DVC_CTRL_REG1_0                 _MK_ADDR_CONST(0x0)
#define DVC_CTRL_REG1_0_SECURE                  0x0
#define DVC_CTRL_REG1_0_WORD_COUNT                      0x1
#define DVC_CTRL_REG1_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG1_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define DVC_CTRL_REG1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG1_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define DVC_CTRL_REG1_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
//Number of ref_clks to wait for PMU voltage change  request to take effect
#define DVC_CTRL_REG1_0_PMU_WAIT_CNT_SHIFT                      _MK_SHIFT_CONST(11)
#define DVC_CTRL_REG1_0_PMU_WAIT_CNT_FIELD                      (_MK_MASK_CONST(0x1fffff) << DVC_CTRL_REG1_0_PMU_WAIT_CNT_SHIFT)
#define DVC_CTRL_REG1_0_PMU_WAIT_CNT_RANGE                      31:11
#define DVC_CTRL_REG1_0_PMU_WAIT_CNT_WOFFSET                    0x0
#define DVC_CTRL_REG1_0_PMU_WAIT_CNT_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG1_0_PMU_WAIT_CNT_DEFAULT_MASK                       _MK_MASK_CONST(0x1fffff)
#define DVC_CTRL_REG1_0_PMU_WAIT_CNT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG1_0_PMU_WAIT_CNT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//Enable Interrupt  0: disable (default), 1:Enable
#define DVC_CTRL_REG1_0_INTR_EN_SHIFT                   _MK_SHIFT_CONST(10)
#define DVC_CTRL_REG1_0_INTR_EN_FIELD                   (_MK_MASK_CONST(0x1) << DVC_CTRL_REG1_0_INTR_EN_SHIFT)
#define DVC_CTRL_REG1_0_INTR_EN_RANGE                   10:10
#define DVC_CTRL_REG1_0_INTR_EN_WOFFSET                 0x0
#define DVC_CTRL_REG1_0_INTR_EN_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG1_0_INTR_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define DVC_CTRL_REG1_0_INTR_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG1_0_INTR_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG1_0_INTR_EN_DISABLE                 _MK_ENUM_CONST(0)
#define DVC_CTRL_REG1_0_INTR_EN_ENABLE                  _MK_ENUM_CONST(1)

// 0:not present , 1:present
#define DVC_CTRL_REG1_0_EXT_PMU_SHIFT                   _MK_SHIFT_CONST(9)
#define DVC_CTRL_REG1_0_EXT_PMU_FIELD                   (_MK_MASK_CONST(0x1) << DVC_CTRL_REG1_0_EXT_PMU_SHIFT)
#define DVC_CTRL_REG1_0_EXT_PMU_RANGE                   9:9
#define DVC_CTRL_REG1_0_EXT_PMU_WOFFSET                 0x0
#define DVC_CTRL_REG1_0_EXT_PMU_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG1_0_EXT_PMU_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define DVC_CTRL_REG1_0_EXT_PMU_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG1_0_EXT_PMU_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG1_0_EXT_PMU_NOT_PRESENT                     _MK_ENUM_CONST(0)
#define DVC_CTRL_REG1_0_EXT_PMU_PRESENT                 _MK_ENUM_CONST(1)

// Number of iterations to adjust the voltage
#define DVC_CTRL_REG1_0_NUM_ITER_SHIFT                  _MK_SHIFT_CONST(2)
#define DVC_CTRL_REG1_0_NUM_ITER_FIELD                  (_MK_MASK_CONST(0x7f) << DVC_CTRL_REG1_0_NUM_ITER_SHIFT)
#define DVC_CTRL_REG1_0_NUM_ITER_RANGE                  8:2
#define DVC_CTRL_REG1_0_NUM_ITER_WOFFSET                        0x0
#define DVC_CTRL_REG1_0_NUM_ITER_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG1_0_NUM_ITER_DEFAULT_MASK                   _MK_MASK_CONST(0x7f)
#define DVC_CTRL_REG1_0_NUM_ITER_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG1_0_NUM_ITER_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// 0: disable(default) , 1: Fixed Voltage adjust  mode , 2: Continuous mode
#define DVC_CTRL_REG1_0_MODE_SHIFT                      _MK_SHIFT_CONST(0)
#define DVC_CTRL_REG1_0_MODE_FIELD                      (_MK_MASK_CONST(0x3) << DVC_CTRL_REG1_0_MODE_SHIFT)
#define DVC_CTRL_REG1_0_MODE_RANGE                      1:0
#define DVC_CTRL_REG1_0_MODE_WOFFSET                    0x0
#define DVC_CTRL_REG1_0_MODE_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG1_0_MODE_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define DVC_CTRL_REG1_0_MODE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG1_0_MODE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG1_0_MODE_DISABLE                    _MK_ENUM_CONST(0)
#define DVC_CTRL_REG1_0_MODE_FIX_MODE                   _MK_ENUM_CONST(1)
#define DVC_CTRL_REG1_0_MODE_CONT_MODE                  _MK_ENUM_CONST(2)


// Register DVC_CTRL_REG2_0  
#define DVC_CTRL_REG2_0                 _MK_ADDR_CONST(0x4)
#define DVC_CTRL_REG2_0_SECURE                  0x0
#define DVC_CTRL_REG2_0_WORD_COUNT                      0x1
#define DVC_CTRL_REG2_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG2_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define DVC_CTRL_REG2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG2_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define DVC_CTRL_REG2_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Wakeup timer, in terms of number of ref clocks, for voltage adjustment process.
#define DVC_CTRL_REG2_0_TIMER_CNT_SHIFT                 _MK_SHIFT_CONST(9)
#define DVC_CTRL_REG2_0_TIMER_CNT_FIELD                 (_MK_MASK_CONST(0x7fffff) << DVC_CTRL_REG2_0_TIMER_CNT_SHIFT)
#define DVC_CTRL_REG2_0_TIMER_CNT_RANGE                 31:9
#define DVC_CTRL_REG2_0_TIMER_CNT_WOFFSET                       0x0
#define DVC_CTRL_REG2_0_TIMER_CNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG2_0_TIMER_CNT_DEFAULT_MASK                  _MK_MASK_CONST(0x7fffff)
#define DVC_CTRL_REG2_0_TIMER_CNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG2_0_TIMER_CNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// The period in terms of number of ref clks, during  which perf counter is incremented.
#define DVC_CTRL_REG2_0_ROSC_SA_CNT_SHIFT                       _MK_SHIFT_CONST(2)
#define DVC_CTRL_REG2_0_ROSC_SA_CNT_FIELD                       (_MK_MASK_CONST(0x7f) << DVC_CTRL_REG2_0_ROSC_SA_CNT_SHIFT)
#define DVC_CTRL_REG2_0_ROSC_SA_CNT_RANGE                       8:2
#define DVC_CTRL_REG2_0_ROSC_SA_CNT_WOFFSET                     0x0
#define DVC_CTRL_REG2_0_ROSC_SA_CNT_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG2_0_ROSC_SA_CNT_DEFAULT_MASK                        _MK_MASK_CONST(0x7f)
#define DVC_CTRL_REG2_0_ROSC_SA_CNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG2_0_ROSC_SA_CNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Number of ref clocks to wait for the ring oscillator  settle.
#define DVC_CTRL_REG2_0_ROSC_START_DEL_SHIFT                    _MK_SHIFT_CONST(0)
#define DVC_CTRL_REG2_0_ROSC_START_DEL_FIELD                    (_MK_MASK_CONST(0x3) << DVC_CTRL_REG2_0_ROSC_START_DEL_SHIFT)
#define DVC_CTRL_REG2_0_ROSC_START_DEL_RANGE                    1:0
#define DVC_CTRL_REG2_0_ROSC_START_DEL_WOFFSET                  0x0
#define DVC_CTRL_REG2_0_ROSC_START_DEL_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG2_0_ROSC_START_DEL_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define DVC_CTRL_REG2_0_ROSC_START_DEL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG2_0_ROSC_START_DEL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register DVC_CTRL_REG3_0  
#define DVC_CTRL_REG3_0                 _MK_ADDR_CONST(0x8)
#define DVC_CTRL_REG3_0_SECURE                  0x0
#define DVC_CTRL_REG3_0_WORD_COUNT                      0x1
#define DVC_CTRL_REG3_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_RESET_MASK                      _MK_MASK_CONST(0xf7ffc3ff)
#define DVC_CTRL_REG3_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_READ_MASK                       _MK_MASK_CONST(0xf7ffc3ff)
#define DVC_CTRL_REG3_0_WRITE_MASK                      _MK_MASK_CONST(0xf7ffc3ff)
// Status bit which s/w should write to let DVC know that PMU has been programmed. DVC will then clear this bit.
#define DVC_CTRL_REG3_0_SW_PROG_PMU_DONE_SHIFT                  _MK_SHIFT_CONST(31)
#define DVC_CTRL_REG3_0_SW_PROG_PMU_DONE_FIELD                  (_MK_MASK_CONST(0x1) << DVC_CTRL_REG3_0_SW_PROG_PMU_DONE_SHIFT)
#define DVC_CTRL_REG3_0_SW_PROG_PMU_DONE_RANGE                  31:31
#define DVC_CTRL_REG3_0_SW_PROG_PMU_DONE_WOFFSET                        0x0
#define DVC_CTRL_REG3_0_SW_PROG_PMU_DONE_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_SW_PROG_PMU_DONE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define DVC_CTRL_REG3_0_SW_PROG_PMU_DONE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_SW_PROG_PMU_DONE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Enable I2C intr which is triggered after I2C transfer is done.
#define DVC_CTRL_REG3_0_I2C_DONE_INTR_EN_SHIFT                  _MK_SHIFT_CONST(30)
#define DVC_CTRL_REG3_0_I2C_DONE_INTR_EN_FIELD                  (_MK_MASK_CONST(0x1) << DVC_CTRL_REG3_0_I2C_DONE_INTR_EN_SHIFT)
#define DVC_CTRL_REG3_0_I2C_DONE_INTR_EN_RANGE                  30:30
#define DVC_CTRL_REG3_0_I2C_DONE_INTR_EN_WOFFSET                        0x0
#define DVC_CTRL_REG3_0_I2C_DONE_INTR_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_I2C_DONE_INTR_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define DVC_CTRL_REG3_0_I2C_DONE_INTR_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_I2C_DONE_INTR_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_I2C_DONE_INTR_EN_DISABLE                        _MK_ENUM_CONST(0)
#define DVC_CTRL_REG3_0_I2C_DONE_INTR_EN_ENABLE                 _MK_ENUM_CONST(1)

// PMU voltage program ready intr enable
#define DVC_CTRL_REG3_0_PMU_VOLT_READY_INTR_EN_SHIFT                    _MK_SHIFT_CONST(29)
#define DVC_CTRL_REG3_0_PMU_VOLT_READY_INTR_EN_FIELD                    (_MK_MASK_CONST(0x1) << DVC_CTRL_REG3_0_PMU_VOLT_READY_INTR_EN_SHIFT)
#define DVC_CTRL_REG3_0_PMU_VOLT_READY_INTR_EN_RANGE                    29:29
#define DVC_CTRL_REG3_0_PMU_VOLT_READY_INTR_EN_WOFFSET                  0x0
#define DVC_CTRL_REG3_0_PMU_VOLT_READY_INTR_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_PMU_VOLT_READY_INTR_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define DVC_CTRL_REG3_0_PMU_VOLT_READY_INTR_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_PMU_VOLT_READY_INTR_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_PMU_VOLT_READY_INTR_EN_DISABLE                  _MK_ENUM_CONST(0)
#define DVC_CTRL_REG3_0_PMU_VOLT_READY_INTR_EN_ENABLE                   _MK_ENUM_CONST(1)

// Enable for target performance adjustment done interrupt.
#define DVC_CTRL_REG3_0_TGT_PERF_DONE_INTR_EN_SHIFT                     _MK_SHIFT_CONST(28)
#define DVC_CTRL_REG3_0_TGT_PERF_DONE_INTR_EN_FIELD                     (_MK_MASK_CONST(0x1) << DVC_CTRL_REG3_0_TGT_PERF_DONE_INTR_EN_SHIFT)
#define DVC_CTRL_REG3_0_TGT_PERF_DONE_INTR_EN_RANGE                     28:28
#define DVC_CTRL_REG3_0_TGT_PERF_DONE_INTR_EN_WOFFSET                   0x0
#define DVC_CTRL_REG3_0_TGT_PERF_DONE_INTR_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_TGT_PERF_DONE_INTR_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define DVC_CTRL_REG3_0_TGT_PERF_DONE_INTR_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_TGT_PERF_DONE_INTR_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_TGT_PERF_DONE_INTR_EN_DISABLE                   _MK_ENUM_CONST(0)
#define DVC_CTRL_REG3_0_TGT_PERF_DONE_INTR_EN_ENABLE                    _MK_ENUM_CONST(1)

// Select either hardware or software to program the PMU via I2C.
#define DVC_CTRL_REG3_0_I2C_HW_SW_PROG_SHIFT                    _MK_SHIFT_CONST(26)
#define DVC_CTRL_REG3_0_I2C_HW_SW_PROG_FIELD                    (_MK_MASK_CONST(0x1) << DVC_CTRL_REG3_0_I2C_HW_SW_PROG_SHIFT)
#define DVC_CTRL_REG3_0_I2C_HW_SW_PROG_RANGE                    26:26
#define DVC_CTRL_REG3_0_I2C_HW_SW_PROG_WOFFSET                  0x0
#define DVC_CTRL_REG3_0_I2C_HW_SW_PROG_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_I2C_HW_SW_PROG_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define DVC_CTRL_REG3_0_I2C_HW_SW_PROG_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_I2C_HW_SW_PROG_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_I2C_HW_SW_PROG_HW                       _MK_ENUM_CONST(0)
#define DVC_CTRL_REG3_0_I2C_HW_SW_PROG_SW                       _MK_ENUM_CONST(1)

// Enable Wakeup timer.
#define DVC_CTRL_REG3_0_TIMER_EN_SHIFT                  _MK_SHIFT_CONST(25)
#define DVC_CTRL_REG3_0_TIMER_EN_FIELD                  (_MK_MASK_CONST(0x1) << DVC_CTRL_REG3_0_TIMER_EN_SHIFT)
#define DVC_CTRL_REG3_0_TIMER_EN_RANGE                  25:25
#define DVC_CTRL_REG3_0_TIMER_EN_WOFFSET                        0x0
#define DVC_CTRL_REG3_0_TIMER_EN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_TIMER_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define DVC_CTRL_REG3_0_TIMER_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_TIMER_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_TIMER_EN_DISABLE                        _MK_ENUM_CONST(0)
#define DVC_CTRL_REG3_0_TIMER_EN_ENABLE                 _MK_ENUM_CONST(1)

// Number of decrement requests, after an increment  request, to wait for, before voltage change is applied.
#define DVC_CTRL_REG3_0_HYST_CNTR_SHIFT                 _MK_SHIFT_CONST(22)
#define DVC_CTRL_REG3_0_HYST_CNTR_FIELD                 (_MK_MASK_CONST(0x7) << DVC_CTRL_REG3_0_HYST_CNTR_SHIFT)
#define DVC_CTRL_REG3_0_HYST_CNTR_RANGE                 24:22
#define DVC_CTRL_REG3_0_HYST_CNTR_WOFFSET                       0x0
#define DVC_CTRL_REG3_0_HYST_CNTR_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_HYST_CNTR_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define DVC_CTRL_REG3_0_HYST_CNTR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_HYST_CNTR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Self clearing bit that if set causes one  performance monitor sample to be taken 
#define DVC_CTRL_REG3_0_TRIG_PM_SA_SHIFT                        _MK_SHIFT_CONST(21)
#define DVC_CTRL_REG3_0_TRIG_PM_SA_FIELD                        (_MK_MASK_CONST(0x1) << DVC_CTRL_REG3_0_TRIG_PM_SA_SHIFT)
#define DVC_CTRL_REG3_0_TRIG_PM_SA_RANGE                        21:21
#define DVC_CTRL_REG3_0_TRIG_PM_SA_WOFFSET                      0x0
#define DVC_CTRL_REG3_0_TRIG_PM_SA_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_TRIG_PM_SA_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define DVC_CTRL_REG3_0_TRIG_PM_SA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_TRIG_PM_SA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Select 1 of 32 path of ring oscillator adder
#define DVC_CTRL_REG3_0_MUX_SEL_SHIFT                   _MK_SHIFT_CONST(16)
#define DVC_CTRL_REG3_0_MUX_SEL_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_CTRL_REG3_0_MUX_SEL_SHIFT)
#define DVC_CTRL_REG3_0_MUX_SEL_RANGE                   20:16
#define DVC_CTRL_REG3_0_MUX_SEL_WOFFSET                 0x0
#define DVC_CTRL_REG3_0_MUX_SEL_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_MUX_SEL_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_CTRL_REG3_0_MUX_SEL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_MUX_SEL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// 0:not long path , 1:select long path for clk
#define DVC_CTRL_REG3_0_LONG_PATH_EN_SHIFT                      _MK_SHIFT_CONST(15)
#define DVC_CTRL_REG3_0_LONG_PATH_EN_FIELD                      (_MK_MASK_CONST(0x1) << DVC_CTRL_REG3_0_LONG_PATH_EN_SHIFT)
#define DVC_CTRL_REG3_0_LONG_PATH_EN_RANGE                      15:15
#define DVC_CTRL_REG3_0_LONG_PATH_EN_WOFFSET                    0x0
#define DVC_CTRL_REG3_0_LONG_PATH_EN_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_LONG_PATH_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define DVC_CTRL_REG3_0_LONG_PATH_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_LONG_PATH_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_LONG_PATH_EN_DISABLE                    _MK_ENUM_CONST(0)
#define DVC_CTRL_REG3_0_LONG_PATH_EN_ENABLE                     _MK_ENUM_CONST(1)

// Select between adder ring oscillator (0) and speedo ring oscillator (1).
#define DVC_CTRL_REG3_0_RING_OSC_SEL_SHIFT                      _MK_SHIFT_CONST(14)
#define DVC_CTRL_REG3_0_RING_OSC_SEL_FIELD                      (_MK_MASK_CONST(0x1) << DVC_CTRL_REG3_0_RING_OSC_SEL_SHIFT)
#define DVC_CTRL_REG3_0_RING_OSC_SEL_RANGE                      14:14
#define DVC_CTRL_REG3_0_RING_OSC_SEL_WOFFSET                    0x0
#define DVC_CTRL_REG3_0_RING_OSC_SEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_RING_OSC_SEL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define DVC_CTRL_REG3_0_RING_OSC_SEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_RING_OSC_SEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_RING_OSC_SEL_OLD                        _MK_ENUM_CONST(0)
#define DVC_CTRL_REG3_0_RING_OSC_SEL_NEW                        _MK_ENUM_CONST(1)

// (actual perf-target perf)>threshold, voltage  tuning is done if enabled
#define DVC_CTRL_REG3_0_VA_TH_H_SHIFT                   _MK_SHIFT_CONST(0)
#define DVC_CTRL_REG3_0_VA_TH_H_FIELD                   (_MK_MASK_CONST(0x3ff) << DVC_CTRL_REG3_0_VA_TH_H_SHIFT)
#define DVC_CTRL_REG3_0_VA_TH_H_RANGE                   9:0
#define DVC_CTRL_REG3_0_VA_TH_H_WOFFSET                 0x0
#define DVC_CTRL_REG3_0_VA_TH_H_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_VA_TH_H_DEFAULT_MASK                    _MK_MASK_CONST(0x3ff)
#define DVC_CTRL_REG3_0_VA_TH_H_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_CTRL_REG3_0_VA_TH_H_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register DVC_STATUS_REG_0  
#define DVC_STATUS_REG_0                        _MK_ADDR_CONST(0xc)
#define DVC_STATUS_REG_0_SECURE                         0x0
#define DVC_STATUS_REG_0_WORD_COUNT                     0x1
#define DVC_STATUS_REG_0_RESET_VAL                      _MK_MASK_CONST(0x60000)
#define DVC_STATUS_REG_0_RESET_MASK                     _MK_MASK_CONST(0x7fffffff)
#define DVC_STATUS_REG_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_READ_MASK                      _MK_MASK_CONST(0x7fffffff)
#define DVC_STATUS_REG_0_WRITE_MASK                     _MK_MASK_CONST(0x7fffffff)
// Interrupt to indicate I2C transfer is done
#define DVC_STATUS_REG_0_I2C_DONE_INTR_SHIFT                    _MK_SHIFT_CONST(30)
#define DVC_STATUS_REG_0_I2C_DONE_INTR_FIELD                    (_MK_MASK_CONST(0x1) << DVC_STATUS_REG_0_I2C_DONE_INTR_SHIFT)
#define DVC_STATUS_REG_0_I2C_DONE_INTR_RANGE                    30:30
#define DVC_STATUS_REG_0_I2C_DONE_INTR_WOFFSET                  0x0
#define DVC_STATUS_REG_0_I2C_DONE_INTR_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_I2C_DONE_INTR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define DVC_STATUS_REG_0_I2C_DONE_INTR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_I2C_DONE_INTR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Interrupt indicating that voltage adjustment value is ready and can be programmed to PMU via I2C by software.
#define DVC_STATUS_REG_0_PMU_VOLT_READY_INTR_SHIFT                      _MK_SHIFT_CONST(29)
#define DVC_STATUS_REG_0_PMU_VOLT_READY_INTR_FIELD                      (_MK_MASK_CONST(0x1) << DVC_STATUS_REG_0_PMU_VOLT_READY_INTR_SHIFT)
#define DVC_STATUS_REG_0_PMU_VOLT_READY_INTR_RANGE                      29:29
#define DVC_STATUS_REG_0_PMU_VOLT_READY_INTR_WOFFSET                    0x0
#define DVC_STATUS_REG_0_PMU_VOLT_READY_INTR_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_PMU_VOLT_READY_INTR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define DVC_STATUS_REG_0_PMU_VOLT_READY_INTR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_PMU_VOLT_READY_INTR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Interrupt to firmware to indicate voltage change has been completed.
#define DVC_STATUS_REG_0_TGT_PERF_DONE_INTR_SHIFT                       _MK_SHIFT_CONST(28)
#define DVC_STATUS_REG_0_TGT_PERF_DONE_INTR_FIELD                       (_MK_MASK_CONST(0x1) << DVC_STATUS_REG_0_TGT_PERF_DONE_INTR_SHIFT)
#define DVC_STATUS_REG_0_TGT_PERF_DONE_INTR_RANGE                       28:28
#define DVC_STATUS_REG_0_TGT_PERF_DONE_INTR_WOFFSET                     0x0
#define DVC_STATUS_REG_0_TGT_PERF_DONE_INTR_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_TGT_PERF_DONE_INTR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define DVC_STATUS_REG_0_TGT_PERF_DONE_INTR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_TGT_PERF_DONE_INTR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// DVC/PMU is busy adjusting voltage.
#define DVC_STATUS_REG_0_BUSY_SHIFT                     _MK_SHIFT_CONST(27)
#define DVC_STATUS_REG_0_BUSY_FIELD                     (_MK_MASK_CONST(0x1) << DVC_STATUS_REG_0_BUSY_SHIFT)
#define DVC_STATUS_REG_0_BUSY_RANGE                     27:27
#define DVC_STATUS_REG_0_BUSY_WOFFSET                   0x0
#define DVC_STATUS_REG_0_BUSY_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_BUSY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define DVC_STATUS_REG_0_BUSY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_BUSY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Carry output from the adder of the new ring oscillator
#define DVC_STATUS_REG_0_CARRY_OUT_SHIFT                        _MK_SHIFT_CONST(26)
#define DVC_STATUS_REG_0_CARRY_OUT_FIELD                        (_MK_MASK_CONST(0x1) << DVC_STATUS_REG_0_CARRY_OUT_SHIFT)
#define DVC_STATUS_REG_0_CARRY_OUT_RANGE                        26:26
#define DVC_STATUS_REG_0_CARRY_OUT_WOFFSET                      0x0
#define DVC_STATUS_REG_0_CARRY_OUT_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_CARRY_OUT_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define DVC_STATUS_REG_0_CARRY_OUT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_CARRY_OUT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// I2C Status bits 
#define DVC_STATUS_REG_0_I2C_STATUS_SHIFT                       _MK_SHIFT_CONST(22)
#define DVC_STATUS_REG_0_I2C_STATUS_FIELD                       (_MK_MASK_CONST(0xf) << DVC_STATUS_REG_0_I2C_STATUS_SHIFT)
#define DVC_STATUS_REG_0_I2C_STATUS_RANGE                       25:22
#define DVC_STATUS_REG_0_I2C_STATUS_WOFFSET                     0x0
#define DVC_STATUS_REG_0_I2C_STATUS_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_I2C_STATUS_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define DVC_STATUS_REG_0_I2C_STATUS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_I2C_STATUS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Indicates error for I2C master in data transfer
#define DVC_STATUS_REG_0_I2C_ERROR_SHIFT                        _MK_SHIFT_CONST(21)
#define DVC_STATUS_REG_0_I2C_ERROR_FIELD                        (_MK_MASK_CONST(0x1) << DVC_STATUS_REG_0_I2C_ERROR_SHIFT)
#define DVC_STATUS_REG_0_I2C_ERROR_RANGE                        21:21
#define DVC_STATUS_REG_0_I2C_ERROR_WOFFSET                      0x0
#define DVC_STATUS_REG_0_I2C_ERROR_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_I2C_ERROR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define DVC_STATUS_REG_0_I2C_ERROR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_I2C_ERROR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Measured performance count less than target performance count condition detected.
#define DVC_STATUS_REG_0_TGT_PM_UNDERRUN_SHIFT                  _MK_SHIFT_CONST(20)
#define DVC_STATUS_REG_0_TGT_PM_UNDERRUN_FIELD                  (_MK_MASK_CONST(0x1) << DVC_STATUS_REG_0_TGT_PM_UNDERRUN_SHIFT)
#define DVC_STATUS_REG_0_TGT_PM_UNDERRUN_RANGE                  20:20
#define DVC_STATUS_REG_0_TGT_PM_UNDERRUN_WOFFSET                        0x0
#define DVC_STATUS_REG_0_TGT_PM_UNDERRUN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_TGT_PM_UNDERRUN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define DVC_STATUS_REG_0_TGT_PM_UNDERRUN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_TGT_PM_UNDERRUN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Voltage adjustment exceeds the limit
#define DVC_STATUS_REG_0_VADJ_ERR_SHIFT                 _MK_SHIFT_CONST(19)
#define DVC_STATUS_REG_0_VADJ_ERR_FIELD                 (_MK_MASK_CONST(0x1) << DVC_STATUS_REG_0_VADJ_ERR_SHIFT)
#define DVC_STATUS_REG_0_VADJ_ERR_RANGE                 19:19
#define DVC_STATUS_REG_0_VADJ_ERR_WOFFSET                       0x0
#define DVC_STATUS_REG_0_VADJ_ERR_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_VADJ_ERR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define DVC_STATUS_REG_0_VADJ_ERR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_VADJ_ERR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Value of the voltage that has been applied.
#define DVC_STATUS_REG_0_CURR_VOLT_SHIFT                        _MK_SHIFT_CONST(14)
#define DVC_STATUS_REG_0_CURR_VOLT_FIELD                        (_MK_MASK_CONST(0x1f) << DVC_STATUS_REG_0_CURR_VOLT_SHIFT)
#define DVC_STATUS_REG_0_CURR_VOLT_RANGE                        18:14
#define DVC_STATUS_REG_0_CURR_VOLT_WOFFSET                      0x0
#define DVC_STATUS_REG_0_CURR_VOLT_DEFAULT                      _MK_MASK_CONST(0x18)
#define DVC_STATUS_REG_0_CURR_VOLT_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define DVC_STATUS_REG_0_CURR_VOLT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_CURR_VOLT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Performance monitor sample value for the last sample
#define DVC_STATUS_REG_0_PMON_VALUE_SHIFT                       _MK_SHIFT_CONST(0)
#define DVC_STATUS_REG_0_PMON_VALUE_FIELD                       (_MK_MASK_CONST(0x3fff) << DVC_STATUS_REG_0_PMON_VALUE_SHIFT)
#define DVC_STATUS_REG_0_PMON_VALUE_RANGE                       13:0
#define DVC_STATUS_REG_0_PMON_VALUE_WOFFSET                     0x0
#define DVC_STATUS_REG_0_PMON_VALUE_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_PMON_VALUE_DEFAULT_MASK                        _MK_MASK_CONST(0x3fff)
#define DVC_STATUS_REG_0_PMON_VALUE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_STATUS_REG_0_PMON_VALUE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register DVC_I2C_CTRL_REG_0  
#define DVC_I2C_CTRL_REG_0                      _MK_ADDR_CONST(0x10)
#define DVC_I2C_CTRL_REG_0_SECURE                       0x0
#define DVC_I2C_CTRL_REG_0_WORD_COUNT                   0x1
#define DVC_I2C_CTRL_REG_0_RESET_VAL                    _MK_MASK_CONST(0x14514000)
#define DVC_I2C_CTRL_REG_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define DVC_I2C_CTRL_REG_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define DVC_I2C_CTRL_REG_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
// 1 or 2 or 3 Commands for writing to PMU-I2C slave.
// 000=>  1 cmd vsel1 only to core
// 001=>  2 cmd's vsel1 & vsel2 to the core & AO
// 010=>  3 cmd's vsel1 & vsel2 & vsel3 to the core, AO and CPU
// 011=> NA
// 100 => 2 cmd's vsel1 to the core, vsel2 is S/W controlled
// 101 & 110 = > NA
// 111 => 3 cmd's vsel1 to the core , vsel2 & vsel3 are S/W controlled
#define DVC_I2C_CTRL_REG_0_MULTI_CMD_SHIFT                      _MK_SHIFT_CONST(29)
#define DVC_I2C_CTRL_REG_0_MULTI_CMD_FIELD                      (_MK_MASK_CONST(0x7) << DVC_I2C_CTRL_REG_0_MULTI_CMD_SHIFT)
#define DVC_I2C_CTRL_REG_0_MULTI_CMD_RANGE                      31:29
#define DVC_I2C_CTRL_REG_0_MULTI_CMD_WOFFSET                    0x0
#define DVC_I2C_CTRL_REG_0_MULTI_CMD_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_MULTI_CMD_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define DVC_I2C_CTRL_REG_0_MULTI_CMD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_MULTI_CMD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Size of vsel3 to match with PMU
#define DVC_I2C_CTRL_REG_0_SIZE3_SHIFT                  _MK_SHIFT_CONST(26)
#define DVC_I2C_CTRL_REG_0_SIZE3_FIELD                  (_MK_MASK_CONST(0x7) << DVC_I2C_CTRL_REG_0_SIZE3_SHIFT)
#define DVC_I2C_CTRL_REG_0_SIZE3_RANGE                  28:26
#define DVC_I2C_CTRL_REG_0_SIZE3_WOFFSET                        0x0
#define DVC_I2C_CTRL_REG_0_SIZE3_DEFAULT                        _MK_MASK_CONST(0x5)
#define DVC_I2C_CTRL_REG_0_SIZE3_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define DVC_I2C_CTRL_REG_0_SIZE3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_SIZE3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Shift vsel3 to match with PMU
#define DVC_I2C_CTRL_REG_0_SHIFT3_SHIFT                 _MK_SHIFT_CONST(23)
#define DVC_I2C_CTRL_REG_0_SHIFT3_FIELD                 (_MK_MASK_CONST(0x7) << DVC_I2C_CTRL_REG_0_SHIFT3_SHIFT)
#define DVC_I2C_CTRL_REG_0_SHIFT3_RANGE                 25:23
#define DVC_I2C_CTRL_REG_0_SHIFT3_WOFFSET                       0x0
#define DVC_I2C_CTRL_REG_0_SHIFT3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_SHIFT3_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define DVC_I2C_CTRL_REG_0_SHIFT3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_SHIFT3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Size of vsel2 to match with PMU
#define DVC_I2C_CTRL_REG_0_SIZE2_SHIFT                  _MK_SHIFT_CONST(20)
#define DVC_I2C_CTRL_REG_0_SIZE2_FIELD                  (_MK_MASK_CONST(0x7) << DVC_I2C_CTRL_REG_0_SIZE2_SHIFT)
#define DVC_I2C_CTRL_REG_0_SIZE2_RANGE                  22:20
#define DVC_I2C_CTRL_REG_0_SIZE2_WOFFSET                        0x0
#define DVC_I2C_CTRL_REG_0_SIZE2_DEFAULT                        _MK_MASK_CONST(0x5)
#define DVC_I2C_CTRL_REG_0_SIZE2_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define DVC_I2C_CTRL_REG_0_SIZE2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_SIZE2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Shift vsel2 to match with PMU
#define DVC_I2C_CTRL_REG_0_SHIFT2_SHIFT                 _MK_SHIFT_CONST(17)
#define DVC_I2C_CTRL_REG_0_SHIFT2_FIELD                 (_MK_MASK_CONST(0x7) << DVC_I2C_CTRL_REG_0_SHIFT2_SHIFT)
#define DVC_I2C_CTRL_REG_0_SHIFT2_RANGE                 19:17
#define DVC_I2C_CTRL_REG_0_SHIFT2_WOFFSET                       0x0
#define DVC_I2C_CTRL_REG_0_SHIFT2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_SHIFT2_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define DVC_I2C_CTRL_REG_0_SHIFT2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_SHIFT2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Size of vsel to match with PMU
#define DVC_I2C_CTRL_REG_0_SIZE1_SHIFT                  _MK_SHIFT_CONST(14)
#define DVC_I2C_CTRL_REG_0_SIZE1_FIELD                  (_MK_MASK_CONST(0x7) << DVC_I2C_CTRL_REG_0_SIZE1_SHIFT)
#define DVC_I2C_CTRL_REG_0_SIZE1_RANGE                  16:14
#define DVC_I2C_CTRL_REG_0_SIZE1_WOFFSET                        0x0
#define DVC_I2C_CTRL_REG_0_SIZE1_DEFAULT                        _MK_MASK_CONST(0x5)
#define DVC_I2C_CTRL_REG_0_SIZE1_DEFAULT_MASK                   _MK_MASK_CONST(0x7)
#define DVC_I2C_CTRL_REG_0_SIZE1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_SIZE1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Shift vsel to match with PMU
#define DVC_I2C_CTRL_REG_0_SHIFT1_SHIFT                 _MK_SHIFT_CONST(11)
#define DVC_I2C_CTRL_REG_0_SHIFT1_FIELD                 (_MK_MASK_CONST(0x7) << DVC_I2C_CTRL_REG_0_SHIFT1_SHIFT)
#define DVC_I2C_CTRL_REG_0_SHIFT1_RANGE                 13:11
#define DVC_I2C_CTRL_REG_0_SHIFT1_WOFFSET                       0x0
#define DVC_I2C_CTRL_REG_0_SHIFT1_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_SHIFT1_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define DVC_I2C_CTRL_REG_0_SHIFT1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_SHIFT1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// 7 bit or 10 bit addressing
#define DVC_I2C_CTRL_REG_0_ADDR_7BIT_10BIT_SHIFT                        _MK_SHIFT_CONST(10)
#define DVC_I2C_CTRL_REG_0_ADDR_7BIT_10BIT_FIELD                        (_MK_MASK_CONST(0x1) << DVC_I2C_CTRL_REG_0_ADDR_7BIT_10BIT_SHIFT)
#define DVC_I2C_CTRL_REG_0_ADDR_7BIT_10BIT_RANGE                        10:10
#define DVC_I2C_CTRL_REG_0_ADDR_7BIT_10BIT_WOFFSET                      0x0
#define DVC_I2C_CTRL_REG_0_ADDR_7BIT_10BIT_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_ADDR_7BIT_10BIT_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define DVC_I2C_CTRL_REG_0_ADDR_7BIT_10BIT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_ADDR_7BIT_10BIT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// External slave ID Address
#define DVC_I2C_CTRL_REG_0_SLAVE_ID_SHIFT                       _MK_SHIFT_CONST(0)
#define DVC_I2C_CTRL_REG_0_SLAVE_ID_FIELD                       (_MK_MASK_CONST(0x3ff) << DVC_I2C_CTRL_REG_0_SLAVE_ID_SHIFT)
#define DVC_I2C_CTRL_REG_0_SLAVE_ID_RANGE                       9:0
#define DVC_I2C_CTRL_REG_0_SLAVE_ID_WOFFSET                     0x0
#define DVC_I2C_CTRL_REG_0_SLAVE_ID_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_SLAVE_ID_DEFAULT_MASK                        _MK_MASK_CONST(0x3ff)
#define DVC_I2C_CTRL_REG_0_SLAVE_ID_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_I2C_CTRL_REG_0_SLAVE_ID_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register DVC_I2C_ADDR_DATA_REG_0  
#define DVC_I2C_ADDR_DATA_REG_0                 _MK_ADDR_CONST(0x14)
#define DVC_I2C_ADDR_DATA_REG_0_SECURE                  0x0
#define DVC_I2C_ADDR_DATA_REG_0_WORD_COUNT                      0x1
#define DVC_I2C_ADDR_DATA_REG_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define DVC_I2C_ADDR_DATA_REG_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define DVC_I2C_ADDR_DATA_REG_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
// Optional second data
#define DVC_I2C_ADDR_DATA_REG_0_DATA2_SHIFT                     _MK_SHIFT_CONST(24)
#define DVC_I2C_ADDR_DATA_REG_0_DATA2_FIELD                     (_MK_MASK_CONST(0xff) << DVC_I2C_ADDR_DATA_REG_0_DATA2_SHIFT)
#define DVC_I2C_ADDR_DATA_REG_0_DATA2_RANGE                     31:24
#define DVC_I2C_ADDR_DATA_REG_0_DATA2_WOFFSET                   0x0
#define DVC_I2C_ADDR_DATA_REG_0_DATA2_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_0_DATA2_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define DVC_I2C_ADDR_DATA_REG_0_DATA2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_0_DATA2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Optional second addr
#define DVC_I2C_ADDR_DATA_REG_0_ADDR2_SHIFT                     _MK_SHIFT_CONST(16)
#define DVC_I2C_ADDR_DATA_REG_0_ADDR2_FIELD                     (_MK_MASK_CONST(0xff) << DVC_I2C_ADDR_DATA_REG_0_ADDR2_SHIFT)
#define DVC_I2C_ADDR_DATA_REG_0_ADDR2_RANGE                     23:16
#define DVC_I2C_ADDR_DATA_REG_0_ADDR2_WOFFSET                   0x0
#define DVC_I2C_ADDR_DATA_REG_0_ADDR2_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_0_ADDR2_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define DVC_I2C_ADDR_DATA_REG_0_ADDR2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_0_ADDR2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Default data
#define DVC_I2C_ADDR_DATA_REG_0_DATA1_SHIFT                     _MK_SHIFT_CONST(8)
#define DVC_I2C_ADDR_DATA_REG_0_DATA1_FIELD                     (_MK_MASK_CONST(0xff) << DVC_I2C_ADDR_DATA_REG_0_DATA1_SHIFT)
#define DVC_I2C_ADDR_DATA_REG_0_DATA1_RANGE                     15:8
#define DVC_I2C_ADDR_DATA_REG_0_DATA1_WOFFSET                   0x0
#define DVC_I2C_ADDR_DATA_REG_0_DATA1_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_0_DATA1_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define DVC_I2C_ADDR_DATA_REG_0_DATA1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_0_DATA1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Addr for voltage sel
#define DVC_I2C_ADDR_DATA_REG_0_ADDR1_SHIFT                     _MK_SHIFT_CONST(0)
#define DVC_I2C_ADDR_DATA_REG_0_ADDR1_FIELD                     (_MK_MASK_CONST(0xff) << DVC_I2C_ADDR_DATA_REG_0_ADDR1_SHIFT)
#define DVC_I2C_ADDR_DATA_REG_0_ADDR1_RANGE                     7:0
#define DVC_I2C_ADDR_DATA_REG_0_ADDR1_WOFFSET                   0x0
#define DVC_I2C_ADDR_DATA_REG_0_ADDR1_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_0_ADDR1_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define DVC_I2C_ADDR_DATA_REG_0_ADDR1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_0_ADDR1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register DVC_RING_OSC_ADDER_IN1_0  
#define DVC_RING_OSC_ADDER_IN1_0                        _MK_ADDR_CONST(0x18)
#define DVC_RING_OSC_ADDER_IN1_0_SECURE                         0x0
#define DVC_RING_OSC_ADDER_IN1_0_WORD_COUNT                     0x1
#define DVC_RING_OSC_ADDER_IN1_0_RESET_VAL                      _MK_MASK_CONST(0xffffffff)
#define DVC_RING_OSC_ADDER_IN1_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define DVC_RING_OSC_ADDER_IN1_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define DVC_RING_OSC_ADDER_IN1_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define DVC_RING_OSC_ADDER_IN1_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define DVC_RING_OSC_ADDER_IN1_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
// Ring osc adder input1
#define DVC_RING_OSC_ADDER_IN1_0_ADDER_IN1_SHIFT                        _MK_SHIFT_CONST(0)
#define DVC_RING_OSC_ADDER_IN1_0_ADDER_IN1_FIELD                        (_MK_MASK_CONST(0xffffffff) << DVC_RING_OSC_ADDER_IN1_0_ADDER_IN1_SHIFT)
#define DVC_RING_OSC_ADDER_IN1_0_ADDER_IN1_RANGE                        31:0
#define DVC_RING_OSC_ADDER_IN1_0_ADDER_IN1_WOFFSET                      0x0
#define DVC_RING_OSC_ADDER_IN1_0_ADDER_IN1_DEFAULT                      _MK_MASK_CONST(0xffffffff)
#define DVC_RING_OSC_ADDER_IN1_0_ADDER_IN1_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define DVC_RING_OSC_ADDER_IN1_0_ADDER_IN1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_RING_OSC_ADDER_IN1_0_ADDER_IN1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_RING_OSC_ADDER_IN1_0_ADDER_IN1_INIT_ENUM                    -1


// Register DVC_RING_OSC_ADDER_IN2_0  
#define DVC_RING_OSC_ADDER_IN2_0                        _MK_ADDR_CONST(0x1c)
#define DVC_RING_OSC_ADDER_IN2_0_SECURE                         0x0
#define DVC_RING_OSC_ADDER_IN2_0_WORD_COUNT                     0x1
#define DVC_RING_OSC_ADDER_IN2_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define DVC_RING_OSC_ADDER_IN2_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define DVC_RING_OSC_ADDER_IN2_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define DVC_RING_OSC_ADDER_IN2_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define DVC_RING_OSC_ADDER_IN2_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define DVC_RING_OSC_ADDER_IN2_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
// Ring osc adder input2
#define DVC_RING_OSC_ADDER_IN2_0_ADDER_IN2_SHIFT                        _MK_SHIFT_CONST(0)
#define DVC_RING_OSC_ADDER_IN2_0_ADDER_IN2_FIELD                        (_MK_MASK_CONST(0xffffffff) << DVC_RING_OSC_ADDER_IN2_0_ADDER_IN2_SHIFT)
#define DVC_RING_OSC_ADDER_IN2_0_ADDER_IN2_RANGE                        31:0
#define DVC_RING_OSC_ADDER_IN2_0_ADDER_IN2_WOFFSET                      0x0
#define DVC_RING_OSC_ADDER_IN2_0_ADDER_IN2_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_RING_OSC_ADDER_IN2_0_ADDER_IN2_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define DVC_RING_OSC_ADDER_IN2_0_ADDER_IN2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_RING_OSC_ADDER_IN2_0_ADDER_IN2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register DVC_REQ_REGISTER_0  
#define DVC_REQ_REGISTER_0                      _MK_ADDR_CONST(0x20)
#define DVC_REQ_REGISTER_0_SECURE                       0x0
#define DVC_REQ_REGISTER_0_WORD_COUNT                   0x1
#define DVC_REQ_REGISTER_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_REQ_REGISTER_0_RESET_MASK                   _MK_MASK_CONST(0x7f)
#define DVC_REQ_REGISTER_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_REQ_REGISTER_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_REQ_REGISTER_0_READ_MASK                    _MK_MASK_CONST(0x7f)
#define DVC_REQ_REGISTER_0_WRITE_MASK                   _MK_MASK_CONST(0x7f)
// Self clearing bit , which firmware can use to trigger DVC voltage change
#define DVC_REQ_REGISTER_0_REQ_VLD_SHIFT                        _MK_SHIFT_CONST(6)
#define DVC_REQ_REGISTER_0_REQ_VLD_FIELD                        (_MK_MASK_CONST(0x1) << DVC_REQ_REGISTER_0_REQ_VLD_SHIFT)
#define DVC_REQ_REGISTER_0_REQ_VLD_RANGE                        6:6
#define DVC_REQ_REGISTER_0_REQ_VLD_WOFFSET                      0x0
#define DVC_REQ_REGISTER_0_REQ_VLD_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_REQ_REGISTER_0_REQ_VLD_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define DVC_REQ_REGISTER_0_REQ_VLD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_REQ_REGISTER_0_REQ_VLD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_REQ_REGISTER_0_REQ_VLD_INVALID                      _MK_ENUM_CONST(0)
#define DVC_REQ_REGISTER_0_REQ_VLD_VALID                        _MK_ENUM_CONST(1)

// firmware target performance
#define DVC_REQ_REGISTER_0_NORM_FREQ_SHIFT                      _MK_SHIFT_CONST(0)
#define DVC_REQ_REGISTER_0_NORM_FREQ_FIELD                      (_MK_MASK_CONST(0x3f) << DVC_REQ_REGISTER_0_NORM_FREQ_SHIFT)
#define DVC_REQ_REGISTER_0_NORM_FREQ_RANGE                      5:0
#define DVC_REQ_REGISTER_0_NORM_FREQ_WOFFSET                    0x0
#define DVC_REQ_REGISTER_0_NORM_FREQ_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_REQ_REGISTER_0_NORM_FREQ_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define DVC_REQ_REGISTER_0_NORM_FREQ_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_REQ_REGISTER_0_NORM_FREQ_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register DVC_I2C_ADDR_DATA_REG_3_0  
#define DVC_I2C_ADDR_DATA_REG_3_0                       _MK_ADDR_CONST(0x24)
#define DVC_I2C_ADDR_DATA_REG_3_0_SECURE                        0x0
#define DVC_I2C_ADDR_DATA_REG_3_0_WORD_COUNT                    0x1
#define DVC_I2C_ADDR_DATA_REG_3_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_3_0_RESET_MASK                    _MK_MASK_CONST(0xffff)
#define DVC_I2C_ADDR_DATA_REG_3_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_3_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_3_0_READ_MASK                     _MK_MASK_CONST(0xffff)
#define DVC_I2C_ADDR_DATA_REG_3_0_WRITE_MASK                    _MK_MASK_CONST(0xffff)
//Default Data
#define DVC_I2C_ADDR_DATA_REG_3_0_DATA3_SHIFT                   _MK_SHIFT_CONST(8)
#define DVC_I2C_ADDR_DATA_REG_3_0_DATA3_FIELD                   (_MK_MASK_CONST(0xff) << DVC_I2C_ADDR_DATA_REG_3_0_DATA3_SHIFT)
#define DVC_I2C_ADDR_DATA_REG_3_0_DATA3_RANGE                   15:8
#define DVC_I2C_ADDR_DATA_REG_3_0_DATA3_WOFFSET                 0x0
#define DVC_I2C_ADDR_DATA_REG_3_0_DATA3_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_3_0_DATA3_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define DVC_I2C_ADDR_DATA_REG_3_0_DATA3_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_3_0_DATA3_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Addr For Volatge sel 3
#define DVC_I2C_ADDR_DATA_REG_3_0_ADDR3_SHIFT                   _MK_SHIFT_CONST(0)
#define DVC_I2C_ADDR_DATA_REG_3_0_ADDR3_FIELD                   (_MK_MASK_CONST(0xff) << DVC_I2C_ADDR_DATA_REG_3_0_ADDR3_SHIFT)
#define DVC_I2C_ADDR_DATA_REG_3_0_ADDR3_RANGE                   7:0
#define DVC_I2C_ADDR_DATA_REG_3_0_ADDR3_WOFFSET                 0x0
#define DVC_I2C_ADDR_DATA_REG_3_0_ADDR3_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_3_0_ADDR3_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define DVC_I2C_ADDR_DATA_REG_3_0_ADDR3_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_I2C_ADDR_DATA_REG_3_0_ADDR3_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Reserved address 40 [0x28] 

// Reserved address 44 [0x2c] 

// Reserved address 48 [0x30] 

// Reserved address 52 [0x34] 

// Reserved address 56 [0x38] 

// Reserved address 60 [0x3c] 

// Register DVC_I2C_CNFG_0  
#define DVC_I2C_CNFG_0                  _MK_ADDR_CONST(0x40)
#define DVC_I2C_CNFG_0_SECURE                   0x0
#define DVC_I2C_CNFG_0_WORD_COUNT                       0x1
#define DVC_I2C_CNFG_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_RESET_MASK                       _MK_MASK_CONST(0x7fff)
#define DVC_I2C_CNFG_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_READ_MASK                        _MK_MASK_CONST(0x7fff)
#define DVC_I2C_CNFG_0_WRITE_MASK                       _MK_MASK_CONST(0x7fff)
// Debounce period for sda and scl lines
// 0 = No debounce
// 1 = 2T
// 2  = 4T
// 3 =  6T etc
// where T is the period of the fix PLL 
//clk source coming to i2c.
//Maximum debounce period programmable is 
//14T.A debounce period of >50ns is desirable
#define DVC_I2C_CNFG_0_DEBOUNCE_CNT_SHIFT                       _MK_SHIFT_CONST(12)
#define DVC_I2C_CNFG_0_DEBOUNCE_CNT_FIELD                       (_MK_MASK_CONST(0x7) << DVC_I2C_CNFG_0_DEBOUNCE_CNT_SHIFT)
#define DVC_I2C_CNFG_0_DEBOUNCE_CNT_RANGE                       14:12
#define DVC_I2C_CNFG_0_DEBOUNCE_CNT_WOFFSET                     0x0
#define DVC_I2C_CNFG_0_DEBOUNCE_CNT_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_DEBOUNCE_CNT_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define DVC_I2C_CNFG_0_DEBOUNCE_CNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_DEBOUNCE_CNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Write 1 to enable new master fsm
// 0 = old fsm
#define DVC_I2C_CNFG_0_NEW_MASTER_FSM_SHIFT                     _MK_SHIFT_CONST(11)
#define DVC_I2C_CNFG_0_NEW_MASTER_FSM_FIELD                     (_MK_MASK_CONST(0x1) << DVC_I2C_CNFG_0_NEW_MASTER_FSM_SHIFT)
#define DVC_I2C_CNFG_0_NEW_MASTER_FSM_RANGE                     11:11
#define DVC_I2C_CNFG_0_NEW_MASTER_FSM_WOFFSET                   0x0
#define DVC_I2C_CNFG_0_NEW_MASTER_FSM_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_NEW_MASTER_FSM_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define DVC_I2C_CNFG_0_NEW_MASTER_FSM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_NEW_MASTER_FSM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_NEW_MASTER_FSM_DISABLE                   _MK_ENUM_CONST(0)
#define DVC_I2C_CNFG_0_NEW_MASTER_FSM_ENABLE                    _MK_ENUM_CONST(1)

// Write 1 to initiate transfer in packet mode.
#define DVC_I2C_CNFG_0_PACKET_MODE_EN_SHIFT                     _MK_SHIFT_CONST(10)
#define DVC_I2C_CNFG_0_PACKET_MODE_EN_FIELD                     (_MK_MASK_CONST(0x1) << DVC_I2C_CNFG_0_PACKET_MODE_EN_SHIFT)
#define DVC_I2C_CNFG_0_PACKET_MODE_EN_RANGE                     10:10
#define DVC_I2C_CNFG_0_PACKET_MODE_EN_WOFFSET                   0x0
#define DVC_I2C_CNFG_0_PACKET_MODE_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_PACKET_MODE_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define DVC_I2C_CNFG_0_PACKET_MODE_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_PACKET_MODE_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_PACKET_MODE_EN_NOP                       _MK_ENUM_CONST(0)
#define DVC_I2C_CNFG_0_PACKET_MODE_EN_GO                        _MK_ENUM_CONST(1)

// Writing a 1 causes the master to initiate the
// transaction in normal mode. Values of other  bits are not
// affected when this bit is 1,Cleared by 
// hardware.  Other bits of the register are
// masked for writes when this bit is programmed
// to one.hence,firware should first configure
// all other registrs and  bits [8:0] of 
// I2C_CNFG register before the bit
// I2C_CNFG[9] is programmed to Zero.
#define DVC_I2C_CNFG_0_SEND_SHIFT                       _MK_SHIFT_CONST(9)
#define DVC_I2C_CNFG_0_SEND_FIELD                       (_MK_MASK_CONST(0x1) << DVC_I2C_CNFG_0_SEND_SHIFT)
#define DVC_I2C_CNFG_0_SEND_RANGE                       9:9
#define DVC_I2C_CNFG_0_SEND_WOFFSET                     0x0
#define DVC_I2C_CNFG_0_SEND_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_SEND_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define DVC_I2C_CNFG_0_SEND_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_SEND_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_SEND_NOP                 _MK_ENUM_CONST(0)
#define DVC_I2C_CNFG_0_SEND_GO                  _MK_ENUM_CONST(1)

// Enable mode to handle devices that do not generate ACK. 
// 1 - dont look for an ack at the end of the Enable
#define DVC_I2C_CNFG_0_NOACK_SHIFT                      _MK_SHIFT_CONST(8)
#define DVC_I2C_CNFG_0_NOACK_FIELD                      (_MK_MASK_CONST(0x1) << DVC_I2C_CNFG_0_NOACK_SHIFT)
#define DVC_I2C_CNFG_0_NOACK_RANGE                      8:8
#define DVC_I2C_CNFG_0_NOACK_WOFFSET                    0x0
#define DVC_I2C_CNFG_0_NOACK_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_NOACK_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define DVC_I2C_CNFG_0_NOACK_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_NOACK_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_NOACK_DISABLE                    _MK_ENUM_CONST(0)
#define DVC_I2C_CNFG_0_NOACK_ENABLE                     _MK_ENUM_CONST(1)

// Read/Write Command for Slave 2:
// 1 -  Read Transaction; 0 -  write Transaction.
// For a 7-bit slave address,this bit must match
// with the LSB of address byte for slave 2.
// Valid only when  bit-4 of this register is 
// set
#define DVC_I2C_CNFG_0_CMD2_SHIFT                       _MK_SHIFT_CONST(7)
#define DVC_I2C_CNFG_0_CMD2_FIELD                       (_MK_MASK_CONST(0x1) << DVC_I2C_CNFG_0_CMD2_SHIFT)
#define DVC_I2C_CNFG_0_CMD2_RANGE                       7:7
#define DVC_I2C_CNFG_0_CMD2_WOFFSET                     0x0
#define DVC_I2C_CNFG_0_CMD2_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_CMD2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define DVC_I2C_CNFG_0_CMD2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_CMD2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_CMD2_DISABLE                     _MK_ENUM_CONST(0)
#define DVC_I2C_CNFG_0_CMD2_ENABLE                      _MK_ENUM_CONST(1)

// Read/Write Command for Slave 1: 
// 1 - Read Transaction; 0 -  write Transaction.
// Command for Slave 1: For a 7-bit slave address
// this bit must match with the LSB of address 
// byte for slave1.
#define DVC_I2C_CNFG_0_CMD1_SHIFT                       _MK_SHIFT_CONST(6)
#define DVC_I2C_CNFG_0_CMD1_FIELD                       (_MK_MASK_CONST(0x1) << DVC_I2C_CNFG_0_CMD1_SHIFT)
#define DVC_I2C_CNFG_0_CMD1_RANGE                       6:6
#define DVC_I2C_CNFG_0_CMD1_WOFFSET                     0x0
#define DVC_I2C_CNFG_0_CMD1_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_CMD1_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define DVC_I2C_CNFG_0_CMD1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_CMD1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_CMD1_DISABLE                     _MK_ENUM_CONST(0)
#define DVC_I2C_CNFG_0_CMD1_ENABLE                      _MK_ENUM_CONST(1)

//  1 = Yes, a Start byte needs to be  sent.
#define DVC_I2C_CNFG_0_START_SHIFT                      _MK_SHIFT_CONST(5)
#define DVC_I2C_CNFG_0_START_FIELD                      (_MK_MASK_CONST(0x1) << DVC_I2C_CNFG_0_START_SHIFT)
#define DVC_I2C_CNFG_0_START_RANGE                      5:5
#define DVC_I2C_CNFG_0_START_WOFFSET                    0x0
#define DVC_I2C_CNFG_0_START_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_START_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define DVC_I2C_CNFG_0_START_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_START_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_START_DISABLE                    _MK_ENUM_CONST(0)
#define DVC_I2C_CNFG_0_START_ENABLE                     _MK_ENUM_CONST(1)

//  1 - Enables a two slave transaction ;
//  0 = No command for Slave 2 present.
#define DVC_I2C_CNFG_0_SLV2_SHIFT                       _MK_SHIFT_CONST(4)
#define DVC_I2C_CNFG_0_SLV2_FIELD                       (_MK_MASK_CONST(0x1) << DVC_I2C_CNFG_0_SLV2_SHIFT)
#define DVC_I2C_CNFG_0_SLV2_RANGE                       4:4
#define DVC_I2C_CNFG_0_SLV2_WOFFSET                     0x0
#define DVC_I2C_CNFG_0_SLV2_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_SLV2_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define DVC_I2C_CNFG_0_SLV2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_SLV2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_SLV2_DISABLE                     _MK_ENUM_CONST(0)
#define DVC_I2C_CNFG_0_SLV2_ENABLE                      _MK_ENUM_CONST(1)

// The Number of bytes to be transmitted per
// transaction 000= 1byte ... 111 = 8bytes;
// In a two slave transaction number of bytes
// should be programmed less than 011.
#define DVC_I2C_CNFG_0_LENGTH_SHIFT                     _MK_SHIFT_CONST(1)
#define DVC_I2C_CNFG_0_LENGTH_FIELD                     (_MK_MASK_CONST(0x7) << DVC_I2C_CNFG_0_LENGTH_SHIFT)
#define DVC_I2C_CNFG_0_LENGTH_RANGE                     3:1
#define DVC_I2C_CNFG_0_LENGTH_WOFFSET                   0x0
#define DVC_I2C_CNFG_0_LENGTH_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_LENGTH_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define DVC_I2C_CNFG_0_LENGTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_LENGTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Address mode defines whether a 7-bit or a 
// 10-bit slave address is programmed. 1 = 10-bit
// device address 0  = 7-bit device address  
#define DVC_I2C_CNFG_0_A_MOD_SHIFT                      _MK_SHIFT_CONST(0)
#define DVC_I2C_CNFG_0_A_MOD_FIELD                      (_MK_MASK_CONST(0x1) << DVC_I2C_CNFG_0_A_MOD_SHIFT)
#define DVC_I2C_CNFG_0_A_MOD_RANGE                      0:0
#define DVC_I2C_CNFG_0_A_MOD_WOFFSET                    0x0
#define DVC_I2C_CNFG_0_A_MOD_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_A_MOD_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define DVC_I2C_CNFG_0_A_MOD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_A_MOD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CNFG_0_A_MOD_SEVEN_BIT_DEVICE_ADDRESS                   _MK_ENUM_CONST(0)
#define DVC_I2C_CNFG_0_A_MOD_TEN_BIT_DEVICE_ADDRESS                     _MK_ENUM_CONST(1)


// Register DVC_I2C_CMD_ADDR0_0  
#define DVC_I2C_CMD_ADDR0_0                     _MK_ADDR_CONST(0x44)
#define DVC_I2C_CMD_ADDR0_0_SECURE                      0x0
#define DVC_I2C_CMD_ADDR0_0_WORD_COUNT                  0x1
#define DVC_I2C_CMD_ADDR0_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_ADDR0_0_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_I2C_CMD_ADDR0_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_ADDR0_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_ADDR0_0_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_I2C_CMD_ADDR0_0_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
// In case of 7-Bit mode address is written in the 
// I2C_CMD_ADDR0[7:1] and I2C_CMD_ADDR0[0] indicates the
// read/write transaction.I2C_CMD_ADDR0[0] bit must match 
// with the I2C_CNFG[6].
// In case of 10-Bit mode addess is written in 
// I2C_CMD_ADDR0[9:0] and I2C_CNFG[6]  indicates the 
// read/write transaction. 
#define DVC_I2C_CMD_ADDR0_0_ADDR0_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_I2C_CMD_ADDR0_0_ADDR0_FIELD                 (_MK_MASK_CONST(0x3ff) << DVC_I2C_CMD_ADDR0_0_ADDR0_SHIFT)
#define DVC_I2C_CMD_ADDR0_0_ADDR0_RANGE                 9:0
#define DVC_I2C_CMD_ADDR0_0_ADDR0_WOFFSET                       0x0
#define DVC_I2C_CMD_ADDR0_0_ADDR0_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_ADDR0_0_ADDR0_DEFAULT_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_I2C_CMD_ADDR0_0_ADDR0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_ADDR0_0_ADDR0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register DVC_I2C_CMD_ADDR1_0  
#define DVC_I2C_CMD_ADDR1_0                     _MK_ADDR_CONST(0x48)
#define DVC_I2C_CMD_ADDR1_0_SECURE                      0x0
#define DVC_I2C_CMD_ADDR1_0_WORD_COUNT                  0x1
#define DVC_I2C_CMD_ADDR1_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_ADDR1_0_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_I2C_CMD_ADDR1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_ADDR1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_ADDR1_0_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_I2C_CMD_ADDR1_0_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
// In case of 7-Bit mode address is written in the 
// I2C_CMD_ADDR0[7:1] and I2C_CMD_ADDR0[0] indicates the 
// read/write transaction.I2C_CMD_ADDR0[0] bit must match
// with the I2C_CNFG[7].        
// In case of 10-Bit mode addess is written in 
// I2C_CMD_ADDR0[9:0] and I2C_CNFG[7] indicates the 
// read/write transaction. 
#define DVC_I2C_CMD_ADDR1_0_ADDR1_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_I2C_CMD_ADDR1_0_ADDR1_FIELD                 (_MK_MASK_CONST(0x3ff) << DVC_I2C_CMD_ADDR1_0_ADDR1_SHIFT)
#define DVC_I2C_CMD_ADDR1_0_ADDR1_RANGE                 9:0
#define DVC_I2C_CMD_ADDR1_0_ADDR1_WOFFSET                       0x0
#define DVC_I2C_CMD_ADDR1_0_ADDR1_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_ADDR1_0_ADDR1_DEFAULT_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_I2C_CMD_ADDR1_0_ADDR1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_ADDR1_0_ADDR1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register DVC_I2C_CMD_DATA1_0  
#define DVC_I2C_CMD_DATA1_0                     _MK_ADDR_CONST(0x4c)
#define DVC_I2C_CMD_DATA1_0_SECURE                      0x0
#define DVC_I2C_CMD_DATA1_0_WORD_COUNT                  0x1
#define DVC_I2C_CMD_DATA1_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA1_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define DVC_I2C_CMD_DATA1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA1_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define DVC_I2C_CMD_DATA1_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// Fourth data byte to be sent/received
#define DVC_I2C_CMD_DATA1_0_DATA4_SHIFT                 _MK_SHIFT_CONST(24)
#define DVC_I2C_CMD_DATA1_0_DATA4_FIELD                 (_MK_MASK_CONST(0xff) << DVC_I2C_CMD_DATA1_0_DATA4_SHIFT)
#define DVC_I2C_CMD_DATA1_0_DATA4_RANGE                 31:24
#define DVC_I2C_CMD_DATA1_0_DATA4_WOFFSET                       0x0
#define DVC_I2C_CMD_DATA1_0_DATA4_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA1_0_DATA4_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define DVC_I2C_CMD_DATA1_0_DATA4_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA1_0_DATA4_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Third data byte to be sent/received
#define DVC_I2C_CMD_DATA1_0_DATA3_SHIFT                 _MK_SHIFT_CONST(16)
#define DVC_I2C_CMD_DATA1_0_DATA3_FIELD                 (_MK_MASK_CONST(0xff) << DVC_I2C_CMD_DATA1_0_DATA3_SHIFT)
#define DVC_I2C_CMD_DATA1_0_DATA3_RANGE                 23:16
#define DVC_I2C_CMD_DATA1_0_DATA3_WOFFSET                       0x0
#define DVC_I2C_CMD_DATA1_0_DATA3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA1_0_DATA3_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define DVC_I2C_CMD_DATA1_0_DATA3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA1_0_DATA3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Second data byte to be sent/received
#define DVC_I2C_CMD_DATA1_0_DATA2_SHIFT                 _MK_SHIFT_CONST(8)
#define DVC_I2C_CMD_DATA1_0_DATA2_FIELD                 (_MK_MASK_CONST(0xff) << DVC_I2C_CMD_DATA1_0_DATA2_SHIFT)
#define DVC_I2C_CMD_DATA1_0_DATA2_RANGE                 15:8
#define DVC_I2C_CMD_DATA1_0_DATA2_WOFFSET                       0x0
#define DVC_I2C_CMD_DATA1_0_DATA2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA1_0_DATA2_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define DVC_I2C_CMD_DATA1_0_DATA2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA1_0_DATA2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This register contains the first data byte to be  sent/received.
#define DVC_I2C_CMD_DATA1_0_DATA1_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_I2C_CMD_DATA1_0_DATA1_FIELD                 (_MK_MASK_CONST(0xff) << DVC_I2C_CMD_DATA1_0_DATA1_SHIFT)
#define DVC_I2C_CMD_DATA1_0_DATA1_RANGE                 7:0
#define DVC_I2C_CMD_DATA1_0_DATA1_WOFFSET                       0x0
#define DVC_I2C_CMD_DATA1_0_DATA1_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA1_0_DATA1_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define DVC_I2C_CMD_DATA1_0_DATA1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA1_0_DATA1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register DVC_I2C_CMD_DATA2_0  
#define DVC_I2C_CMD_DATA2_0                     _MK_ADDR_CONST(0x50)
#define DVC_I2C_CMD_DATA2_0_SECURE                      0x0
#define DVC_I2C_CMD_DATA2_0_WORD_COUNT                  0x1
#define DVC_I2C_CMD_DATA2_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA2_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define DVC_I2C_CMD_DATA2_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA2_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA2_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define DVC_I2C_CMD_DATA2_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
// Eighth data byte to be sent/received
#define DVC_I2C_CMD_DATA2_0_DATA8_SHIFT                 _MK_SHIFT_CONST(24)
#define DVC_I2C_CMD_DATA2_0_DATA8_FIELD                 (_MK_MASK_CONST(0xff) << DVC_I2C_CMD_DATA2_0_DATA8_SHIFT)
#define DVC_I2C_CMD_DATA2_0_DATA8_RANGE                 31:24
#define DVC_I2C_CMD_DATA2_0_DATA8_WOFFSET                       0x0
#define DVC_I2C_CMD_DATA2_0_DATA8_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA2_0_DATA8_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define DVC_I2C_CMD_DATA2_0_DATA8_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA2_0_DATA8_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Seventh data byte to be sent/received
#define DVC_I2C_CMD_DATA2_0_DATA7_SHIFT                 _MK_SHIFT_CONST(16)
#define DVC_I2C_CMD_DATA2_0_DATA7_FIELD                 (_MK_MASK_CONST(0xff) << DVC_I2C_CMD_DATA2_0_DATA7_SHIFT)
#define DVC_I2C_CMD_DATA2_0_DATA7_RANGE                 23:16
#define DVC_I2C_CMD_DATA2_0_DATA7_WOFFSET                       0x0
#define DVC_I2C_CMD_DATA2_0_DATA7_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA2_0_DATA7_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define DVC_I2C_CMD_DATA2_0_DATA7_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA2_0_DATA7_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Sixth data byte to be sent/received
#define DVC_I2C_CMD_DATA2_0_DATA6_SHIFT                 _MK_SHIFT_CONST(8)
#define DVC_I2C_CMD_DATA2_0_DATA6_FIELD                 (_MK_MASK_CONST(0xff) << DVC_I2C_CMD_DATA2_0_DATA6_SHIFT)
#define DVC_I2C_CMD_DATA2_0_DATA6_RANGE                 15:8
#define DVC_I2C_CMD_DATA2_0_DATA6_WOFFSET                       0x0
#define DVC_I2C_CMD_DATA2_0_DATA6_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA2_0_DATA6_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define DVC_I2C_CMD_DATA2_0_DATA6_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA2_0_DATA6_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// This register contains the Fifth data byte to be  sent/received.
#define DVC_I2C_CMD_DATA2_0_DATA5_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_I2C_CMD_DATA2_0_DATA5_FIELD                 (_MK_MASK_CONST(0xff) << DVC_I2C_CMD_DATA2_0_DATA5_SHIFT)
#define DVC_I2C_CMD_DATA2_0_DATA5_RANGE                 7:0
#define DVC_I2C_CMD_DATA2_0_DATA5_WOFFSET                       0x0
#define DVC_I2C_CMD_DATA2_0_DATA5_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA2_0_DATA5_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define DVC_I2C_CMD_DATA2_0_DATA5_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_CMD_DATA2_0_DATA5_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 84 [0x54] 

// Reserved address 88 [0x58] 

// Register DVC_I2C_STATUS_0  
#define DVC_I2C_STATUS_0                        _MK_ADDR_CONST(0x5c)
#define DVC_I2C_STATUS_0_SECURE                         0x0
#define DVC_I2C_STATUS_0_WORD_COUNT                     0x1
#define DVC_I2C_STATUS_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define DVC_I2C_STATUS_0_RESET_MASK                     _MK_MASK_CONST(0x1ff)
#define DVC_I2C_STATUS_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define DVC_I2C_STATUS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define DVC_I2C_STATUS_0_READ_MASK                      _MK_MASK_CONST(0x1ff)
#define DVC_I2C_STATUS_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
//  1 = Busy.
#define DVC_I2C_STATUS_0_BUSY_SHIFT                     _MK_SHIFT_CONST(8)
#define DVC_I2C_STATUS_0_BUSY_FIELD                     (_MK_MASK_CONST(0x1) << DVC_I2C_STATUS_0_BUSY_SHIFT)
#define DVC_I2C_STATUS_0_BUSY_RANGE                     8:8
#define DVC_I2C_STATUS_0_BUSY_WOFFSET                   0x0
#define DVC_I2C_STATUS_0_BUSY_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_I2C_STATUS_0_BUSY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define DVC_I2C_STATUS_0_BUSY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_I2C_STATUS_0_BUSY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define DVC_I2C_STATUS_0_BUSY_NOT_BUSY                  _MK_ENUM_CONST(0)
#define DVC_I2C_STATUS_0_BUSY_BUSY                      _MK_ENUM_CONST(1)

// Transaction for Slave2 for x byte failed. x is 'h0 to 'ha.
// all others invalid 
#define DVC_I2C_STATUS_0_CMD2_STAT_SHIFT                        _MK_SHIFT_CONST(4)
#define DVC_I2C_STATUS_0_CMD2_STAT_FIELD                        (_MK_MASK_CONST(0xf) << DVC_I2C_STATUS_0_CMD2_STAT_SHIFT)
#define DVC_I2C_STATUS_0_CMD2_STAT_RANGE                        7:4
#define DVC_I2C_STATUS_0_CMD2_STAT_WOFFSET                      0x0
#define DVC_I2C_STATUS_0_CMD2_STAT_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_I2C_STATUS_0_CMD2_STAT_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define DVC_I2C_STATUS_0_CMD2_STAT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_I2C_STATUS_0_CMD2_STAT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_I2C_STATUS_0_CMD2_STAT_SL2_XFER_SUCCESSFUL                  _MK_ENUM_CONST(0)
#define DVC_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE1                  _MK_ENUM_CONST(1)
#define DVC_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE2                  _MK_ENUM_CONST(2)
#define DVC_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE3                  _MK_ENUM_CONST(3)
#define DVC_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE4                  _MK_ENUM_CONST(4)
#define DVC_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE5                  _MK_ENUM_CONST(5)
#define DVC_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE6                  _MK_ENUM_CONST(6)
#define DVC_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE7                  _MK_ENUM_CONST(7)
#define DVC_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE8                  _MK_ENUM_CONST(8)
#define DVC_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE9                  _MK_ENUM_CONST(9)
#define DVC_I2C_STATUS_0_CMD2_STAT_SL2_NOACK_FOR_BYTE10                 _MK_ENUM_CONST(10)

// Transaction for Slave1 for x byte failed. x is 'h0 to 'ha.
// all others invalid
#define DVC_I2C_STATUS_0_CMD1_STAT_SHIFT                        _MK_SHIFT_CONST(0)
#define DVC_I2C_STATUS_0_CMD1_STAT_FIELD                        (_MK_MASK_CONST(0xf) << DVC_I2C_STATUS_0_CMD1_STAT_SHIFT)
#define DVC_I2C_STATUS_0_CMD1_STAT_RANGE                        3:0
#define DVC_I2C_STATUS_0_CMD1_STAT_WOFFSET                      0x0
#define DVC_I2C_STATUS_0_CMD1_STAT_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_I2C_STATUS_0_CMD1_STAT_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define DVC_I2C_STATUS_0_CMD1_STAT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_I2C_STATUS_0_CMD1_STAT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_I2C_STATUS_0_CMD1_STAT_SL1_XFER_SUCCESSFUL                  _MK_ENUM_CONST(0)
#define DVC_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE1                  _MK_ENUM_CONST(1)
#define DVC_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE2                  _MK_ENUM_CONST(2)
#define DVC_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE3                  _MK_ENUM_CONST(3)
#define DVC_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE4                  _MK_ENUM_CONST(4)
#define DVC_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE5                  _MK_ENUM_CONST(5)
#define DVC_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE6                  _MK_ENUM_CONST(6)
#define DVC_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE7                  _MK_ENUM_CONST(7)
#define DVC_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE8                  _MK_ENUM_CONST(8)
#define DVC_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE9                  _MK_ENUM_CONST(9)
#define DVC_I2C_STATUS_0_CMD1_STAT_SL1_NOACK_FOR_BYTE10                 _MK_ENUM_CONST(10)


// Packet I2C_IO_PACKET_HEADER_0
#define I2C_IO_PACKET_HEADER_0_SIZE 32

#define I2C_IO_PACKET_HEADER_0_RESERVED0_3_SHIFT                        _MK_SHIFT_CONST(30)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_3_FIELD                        (_MK_MASK_CONST(0x3) << I2C_IO_PACKET_HEADER_0_RESERVED0_3_SHIFT)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_3_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(30)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_3_ROW                  0

#define I2C_IO_PACKET_HEADER_0_HDRSZ_SHIFT                      _MK_SHIFT_CONST(28)
#define I2C_IO_PACKET_HEADER_0_HDRSZ_FIELD                      (_MK_MASK_CONST(0x3) << I2C_IO_PACKET_HEADER_0_HDRSZ_SHIFT)
#define I2C_IO_PACKET_HEADER_0_HDRSZ_RANGE                      _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(28)
#define I2C_IO_PACKET_HEADER_0_HDRSZ_ROW                        0
#define I2C_IO_PACKET_HEADER_0_HDRSZ_ONE                        _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_HDRSZ_TWO                        _MK_ENUM_CONST(1)
#define I2C_IO_PACKET_HEADER_0_HDRSZ_THREE                      _MK_ENUM_CONST(2)
#define I2C_IO_PACKET_HEADER_0_HDRSZ_FOUR                       _MK_ENUM_CONST(3)

#define I2C_IO_PACKET_HEADER_0_RESERVED0_2_SHIFT                        _MK_SHIFT_CONST(24)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_2_FIELD                        (_MK_MASK_CONST(0xf) << I2C_IO_PACKET_HEADER_0_RESERVED0_2_SHIFT)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_2_RANGE                        _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(24)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_2_ROW                  0

#define I2C_IO_PACKET_HEADER_0_PKTID_SHIFT                      _MK_SHIFT_CONST(16)
#define I2C_IO_PACKET_HEADER_0_PKTID_FIELD                      (_MK_MASK_CONST(0xff) << I2C_IO_PACKET_HEADER_0_PKTID_SHIFT)
#define I2C_IO_PACKET_HEADER_0_PKTID_RANGE                      _MK_SHIFT_CONST(23):_MK_SHIFT_CONST(16)
#define I2C_IO_PACKET_HEADER_0_PKTID_ROW                        0

#define I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_SHIFT                      _MK_SHIFT_CONST(12)
#define I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_FIELD                      (_MK_MASK_CONST(0xf) << I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_SHIFT)
#define I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_RANGE                      _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(12)
#define I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_ROW                        0
#define I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_I2C1                       _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_I2C2                       _MK_ENUM_CONST(1)
#define I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_I2C3                       _MK_ENUM_CONST(2)
#define I2C_IO_PACKET_HEADER_0_CONTROLLER_ID_DVC_I2C                    _MK_ENUM_CONST(3)

#define I2C_IO_PACKET_HEADER_0_RESERVED0_1_SHIFT                        _MK_SHIFT_CONST(8)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_1_FIELD                        (_MK_MASK_CONST(0xf) << I2C_IO_PACKET_HEADER_0_RESERVED0_1_SHIFT)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_1_RANGE                        _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(8)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_1_ROW                  0

#define I2C_IO_PACKET_HEADER_0_PROTOCOL_SHIFT                   _MK_SHIFT_CONST(4)
#define I2C_IO_PACKET_HEADER_0_PROTOCOL_FIELD                   (_MK_MASK_CONST(0xf) << I2C_IO_PACKET_HEADER_0_PROTOCOL_SHIFT)
#define I2C_IO_PACKET_HEADER_0_PROTOCOL_RANGE                   _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(4)
#define I2C_IO_PACKET_HEADER_0_PROTOCOL_ROW                     0
#define I2C_IO_PACKET_HEADER_0_PROTOCOL_RESERVED                        _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_PROTOCOL_I2C                     _MK_ENUM_CONST(1)

#define I2C_IO_PACKET_HEADER_0_RESERVED0_0_SHIFT                        _MK_SHIFT_CONST(3)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_0_FIELD                        (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_RESERVED0_0_SHIFT)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_0_RANGE                        _MK_SHIFT_CONST(3):_MK_SHIFT_CONST(3)
#define I2C_IO_PACKET_HEADER_0_RESERVED0_0_ROW                  0

#define I2C_IO_PACKET_HEADER_0_PKTTYPE_SHIFT                    _MK_SHIFT_CONST(0)
#define I2C_IO_PACKET_HEADER_0_PKTTYPE_FIELD                    (_MK_MASK_CONST(0x7) << I2C_IO_PACKET_HEADER_0_PKTTYPE_SHIFT)
#define I2C_IO_PACKET_HEADER_0_PKTTYPE_RANGE                    _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(0)
#define I2C_IO_PACKET_HEADER_0_PKTTYPE_ROW                      0

#define I2C_IO_PACKET_HEADER_0_RESERVED1_0_SHIFT                        _MK_SHIFT_CONST(12)
#define I2C_IO_PACKET_HEADER_0_RESERVED1_0_FIELD                        (_MK_MASK_CONST(0xfffff) << I2C_IO_PACKET_HEADER_0_RESERVED1_0_SHIFT)
#define I2C_IO_PACKET_HEADER_0_RESERVED1_0_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(12)
#define I2C_IO_PACKET_HEADER_0_RESERVED1_0_ROW                  1

#define I2C_IO_PACKET_HEADER_0_PAYLOADSIZE_SHIFT                        _MK_SHIFT_CONST(0)
#define I2C_IO_PACKET_HEADER_0_PAYLOADSIZE_FIELD                        (_MK_MASK_CONST(0xfff) << I2C_IO_PACKET_HEADER_0_PAYLOADSIZE_SHIFT)
#define I2C_IO_PACKET_HEADER_0_PAYLOADSIZE_RANGE                        _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define I2C_IO_PACKET_HEADER_0_PAYLOADSIZE_ROW                  1

#define I2C_IO_PACKET_HEADER_0_RESERVED2_0_SHIFT                        _MK_SHIFT_CONST(23)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_0_FIELD                        (_MK_MASK_CONST(0x1ff) << I2C_IO_PACKET_HEADER_0_RESERVED2_0_SHIFT)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_0_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(23)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_0_ROW                  2

#define I2C_IO_PACKET_HEADER_0_HS_MODE_SHIFT                    _MK_SHIFT_CONST(22)
#define I2C_IO_PACKET_HEADER_0_HS_MODE_FIELD                    (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_HS_MODE_SHIFT)
#define I2C_IO_PACKET_HEADER_0_HS_MODE_RANGE                    _MK_SHIFT_CONST(22):_MK_SHIFT_CONST(22)
#define I2C_IO_PACKET_HEADER_0_HS_MODE_ROW                      2
#define I2C_IO_PACKET_HEADER_0_HS_MODE_DISABLE                  _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_HS_MODE_ENABLE                   _MK_ENUM_CONST(1)

#define I2C_IO_PACKET_HEADER_0_CONTUNE_ON_NACK_SHIFT                    _MK_SHIFT_CONST(21)
#define I2C_IO_PACKET_HEADER_0_CONTUNE_ON_NACK_FIELD                    (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_CONTUNE_ON_NACK_SHIFT)
#define I2C_IO_PACKET_HEADER_0_CONTUNE_ON_NACK_RANGE                    _MK_SHIFT_CONST(21):_MK_SHIFT_CONST(21)
#define I2C_IO_PACKET_HEADER_0_CONTUNE_ON_NACK_ROW                      2
#define I2C_IO_PACKET_HEADER_0_CONTUNE_ON_NACK_DISABLE                  _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_CONTUNE_ON_NACK_ENABLE                   _MK_ENUM_CONST(1)

#define I2C_IO_PACKET_HEADER_0_SEND_START_BYTE_SHIFT                    _MK_SHIFT_CONST(20)
#define I2C_IO_PACKET_HEADER_0_SEND_START_BYTE_FIELD                    (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_SEND_START_BYTE_SHIFT)
#define I2C_IO_PACKET_HEADER_0_SEND_START_BYTE_RANGE                    _MK_SHIFT_CONST(20):_MK_SHIFT_CONST(20)
#define I2C_IO_PACKET_HEADER_0_SEND_START_BYTE_ROW                      2
#define I2C_IO_PACKET_HEADER_0_SEND_START_BYTE_DISABLE                  _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_SEND_START_BYTE_ENABLE                   _MK_ENUM_CONST(1)

#define I2C_IO_PACKET_HEADER_0_READ_SHIFT                       _MK_SHIFT_CONST(19)
#define I2C_IO_PACKET_HEADER_0_READ_FIELD                       (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_READ_SHIFT)
#define I2C_IO_PACKET_HEADER_0_READ_RANGE                       _MK_SHIFT_CONST(19):_MK_SHIFT_CONST(19)
#define I2C_IO_PACKET_HEADER_0_READ_ROW                 2
#define I2C_IO_PACKET_HEADER_0_READ_WRITE                       _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_READ_READ                        _MK_ENUM_CONST(1)

#define I2C_IO_PACKET_HEADER_0_ADDR_MODE_SHIFT                  _MK_SHIFT_CONST(18)
#define I2C_IO_PACKET_HEADER_0_ADDR_MODE_FIELD                  (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_ADDR_MODE_SHIFT)
#define I2C_IO_PACKET_HEADER_0_ADDR_MODE_RANGE                  _MK_SHIFT_CONST(18):_MK_SHIFT_CONST(18)
#define I2C_IO_PACKET_HEADER_0_ADDR_MODE_ROW                    2
#define I2C_IO_PACKET_HEADER_0_ADDR_MODE_SEVEN_BIT                      _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_ADDR_MODE_TEN_BIT                        _MK_ENUM_CONST(1)

#define I2C_IO_PACKET_HEADER_0_IE_SHIFT                 _MK_SHIFT_CONST(17)
#define I2C_IO_PACKET_HEADER_0_IE_FIELD                 (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_IE_SHIFT)
#define I2C_IO_PACKET_HEADER_0_IE_RANGE                 _MK_SHIFT_CONST(17):_MK_SHIFT_CONST(17)
#define I2C_IO_PACKET_HEADER_0_IE_ROW                   2
#define I2C_IO_PACKET_HEADER_0_IE_DISABLE                       _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_IE_ENABLE                        _MK_ENUM_CONST(1)

#define I2C_IO_PACKET_HEADER_0_REPEAT_START_SHIFT                       _MK_SHIFT_CONST(16)
#define I2C_IO_PACKET_HEADER_0_REPEAT_START_FIELD                       (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_REPEAT_START_SHIFT)
#define I2C_IO_PACKET_HEADER_0_REPEAT_START_RANGE                       _MK_SHIFT_CONST(16):_MK_SHIFT_CONST(16)
#define I2C_IO_PACKET_HEADER_0_REPEAT_START_ROW                 2
#define I2C_IO_PACKET_HEADER_0_REPEAT_START_STOP                        _MK_ENUM_CONST(0)
#define I2C_IO_PACKET_HEADER_0_REPEAT_START_REPEAT_START                        _MK_ENUM_CONST(1)

#define I2C_IO_PACKET_HEADER_0_RESERVED2_1_SHIFT                        _MK_SHIFT_CONST(15)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_1_FIELD                        (_MK_MASK_CONST(0x1) << I2C_IO_PACKET_HEADER_0_RESERVED2_1_SHIFT)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_1_RANGE                        _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(15)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_1_ROW                  2

#define I2C_IO_PACKET_HEADER_0_HS_MASTER_ADDR_SHIFT                     _MK_SHIFT_CONST(12)
#define I2C_IO_PACKET_HEADER_0_HS_MASTER_ADDR_FIELD                     (_MK_MASK_CONST(0x7) << I2C_IO_PACKET_HEADER_0_HS_MASTER_ADDR_SHIFT)
#define I2C_IO_PACKET_HEADER_0_HS_MASTER_ADDR_RANGE                     _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(12)
#define I2C_IO_PACKET_HEADER_0_HS_MASTER_ADDR_ROW                       2

#define I2C_IO_PACKET_HEADER_0_RESERVED2_2_SHIFT                        _MK_SHIFT_CONST(10)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_2_FIELD                        (_MK_MASK_CONST(0x3) << I2C_IO_PACKET_HEADER_0_RESERVED2_2_SHIFT)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_2_RANGE                        _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(10)
#define I2C_IO_PACKET_HEADER_0_RESERVED2_2_ROW                  2

#define I2C_IO_PACKET_HEADER_0_SLAVE_ADDR_SHIFT                 _MK_SHIFT_CONST(0)
#define I2C_IO_PACKET_HEADER_0_SLAVE_ADDR_FIELD                 (_MK_MASK_CONST(0x3ff) << I2C_IO_PACKET_HEADER_0_SLAVE_ADDR_SHIFT)
#define I2C_IO_PACKET_HEADER_0_SLAVE_ADDR_RANGE                 _MK_SHIFT_CONST(9):_MK_SHIFT_CONST(0)
#define I2C_IO_PACKET_HEADER_0_SLAVE_ADDR_ROW                   2


// Register DVC_I2C_TX_PACKET_FIFO_0  
#define DVC_I2C_TX_PACKET_FIFO_0                        _MK_ADDR_CONST(0x60)
#define DVC_I2C_TX_PACKET_FIFO_0_SECURE                         0x0
#define DVC_I2C_TX_PACKET_FIFO_0_WORD_COUNT                     0x1
#define DVC_I2C_TX_PACKET_FIFO_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define DVC_I2C_TX_PACKET_FIFO_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define DVC_I2C_TX_PACKET_FIFO_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define DVC_I2C_TX_PACKET_FIFO_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define DVC_I2C_TX_PACKET_FIFO_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define DVC_I2C_TX_PACKET_FIFO_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
//SW writes packets into this register  
//A packet may contain generic
#define DVC_I2C_TX_PACKET_FIFO_0_TX_PACKET_SHIFT                        _MK_SHIFT_CONST(0)
#define DVC_I2C_TX_PACKET_FIFO_0_TX_PACKET_FIELD                        (_MK_MASK_CONST(0xffffffff) << DVC_I2C_TX_PACKET_FIFO_0_TX_PACKET_SHIFT)
#define DVC_I2C_TX_PACKET_FIFO_0_TX_PACKET_RANGE                        31:0
#define DVC_I2C_TX_PACKET_FIFO_0_TX_PACKET_WOFFSET                      0x0
#define DVC_I2C_TX_PACKET_FIFO_0_TX_PACKET_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_I2C_TX_PACKET_FIFO_0_TX_PACKET_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define DVC_I2C_TX_PACKET_FIFO_0_TX_PACKET_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_I2C_TX_PACKET_FIFO_0_TX_PACKET_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register DVC_I2C_RX_FIFO_0  
#define DVC_I2C_RX_FIFO_0                       _MK_ADDR_CONST(0x64)
#define DVC_I2C_RX_FIFO_0_SECURE                        0x0
#define DVC_I2C_RX_FIFO_0_WORD_COUNT                    0x1
#define DVC_I2C_RX_FIFO_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define DVC_I2C_RX_FIFO_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define DVC_I2C_RX_FIFO_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define DVC_I2C_RX_FIFO_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define DVC_I2C_RX_FIFO_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define DVC_I2C_RX_FIFO_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
//SW Reads data from this register,causes pop  
#define DVC_I2C_RX_FIFO_0_RD_DATA_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_I2C_RX_FIFO_0_RD_DATA_FIELD                 (_MK_MASK_CONST(0xffffffff) << DVC_I2C_RX_FIFO_0_RD_DATA_SHIFT)
#define DVC_I2C_RX_FIFO_0_RD_DATA_RANGE                 31:0
#define DVC_I2C_RX_FIFO_0_RD_DATA_WOFFSET                       0x0
#define DVC_I2C_RX_FIFO_0_RD_DATA_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_I2C_RX_FIFO_0_RD_DATA_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define DVC_I2C_RX_FIFO_0_RD_DATA_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_I2C_RX_FIFO_0_RD_DATA_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register DVC_PACKET_TRANSFER_STATUS_0  
#define DVC_PACKET_TRANSFER_STATUS_0                    _MK_ADDR_CONST(0x68)
#define DVC_PACKET_TRANSFER_STATUS_0_SECURE                     0x0
#define DVC_PACKET_TRANSFER_STATUS_0_WORD_COUNT                         0x1
#define DVC_PACKET_TRANSFER_STATUS_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_RESET_MASK                         _MK_MASK_CONST(0x1ffffff)
#define DVC_PACKET_TRANSFER_STATUS_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_READ_MASK                  _MK_MASK_CONST(0x1ffffff)
#define DVC_PACKET_TRANSFER_STATUS_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
//The packet transfer for which last packet is set has been
//completed       
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_SHIFT                    _MK_SHIFT_CONST(24)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_FIELD                    (_MK_MASK_CONST(0x1) << DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_SHIFT)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_RANGE                    24:24
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_WOFFSET                  0x0
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_UNSET                    _MK_ENUM_CONST(0)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_COMPLETE_SET                      _MK_ENUM_CONST(1)

//The current packet id for which the transaction is 
//happening on the bus
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_SHIFT                      _MK_SHIFT_CONST(16)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_FIELD                      (_MK_MASK_CONST(0xff) << DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_SHIFT)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_RANGE                      23:16
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_WOFFSET                    0x0
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_PKT_ID_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

//The number of bytes transferred in the current packet 
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_SHIFT                     _MK_SHIFT_CONST(4)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_FIELD                     (_MK_MASK_CONST(0xfff) << DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_SHIFT)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_RANGE                     15:4
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_WOFFSET                   0x0
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_DEFAULT_MASK                      _MK_MASK_CONST(0xfff)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_TRANSFER_BYTENUM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

//No ack recieved for the addr byte
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_SHIFT                       _MK_SHIFT_CONST(3)
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_FIELD                       (_MK_MASK_CONST(0x1) << DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_SHIFT)
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_RANGE                       3:3
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_WOFFSET                     0x0
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_UNSET                       _MK_ENUM_CONST(0)
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_ADDR_SET                 _MK_ENUM_CONST(1)

//No ack recieved for the data byte
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_SHIFT                       _MK_SHIFT_CONST(2)
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_FIELD                       (_MK_MASK_CONST(0x1) << DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_SHIFT)
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_RANGE                       2:2
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_WOFFSET                     0x0
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_UNSET                       _MK_ENUM_CONST(0)
#define DVC_PACKET_TRANSFER_STATUS_0_NOACK_FOR_DATA_SET                 _MK_ENUM_CONST(1)

//Arbitration lost for the current byte
#define DVC_PACKET_TRANSFER_STATUS_0_ARB_LOST_SHIFT                     _MK_SHIFT_CONST(1)
#define DVC_PACKET_TRANSFER_STATUS_0_ARB_LOST_FIELD                     (_MK_MASK_CONST(0x1) << DVC_PACKET_TRANSFER_STATUS_0_ARB_LOST_SHIFT)
#define DVC_PACKET_TRANSFER_STATUS_0_ARB_LOST_RANGE                     1:1
#define DVC_PACKET_TRANSFER_STATUS_0_ARB_LOST_WOFFSET                   0x0
#define DVC_PACKET_TRANSFER_STATUS_0_ARB_LOST_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_ARB_LOST_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define DVC_PACKET_TRANSFER_STATUS_0_ARB_LOST_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_ARB_LOST_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_ARB_LOST_UNSET                     _MK_ENUM_CONST(0)
#define DVC_PACKET_TRANSFER_STATUS_0_ARB_LOST_SET                       _MK_ENUM_CONST(1)

//1 = Controller is busy
#define DVC_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_SHIFT                      _MK_SHIFT_CONST(0)
#define DVC_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_FIELD                      (_MK_MASK_CONST(0x1) << DVC_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_SHIFT)
#define DVC_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_RANGE                      0:0
#define DVC_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_WOFFSET                    0x0
#define DVC_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define DVC_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define DVC_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_UNSET                      _MK_ENUM_CONST(0)
#define DVC_PACKET_TRANSFER_STATUS_0_CONTROLLER_BUSY_SET                        _MK_ENUM_CONST(1)


// Register DVC_FIFO_CONTROL_0  
#define DVC_FIFO_CONTROL_0                      _MK_ADDR_CONST(0x6c)
#define DVC_FIFO_CONTROL_0_SECURE                       0x0
#define DVC_FIFO_CONTROL_0_WORD_COUNT                   0x1
#define DVC_FIFO_CONTROL_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_FIFO_CONTROL_0_RESET_MASK                   _MK_MASK_CONST(0xff)
#define DVC_FIFO_CONTROL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_FIFO_CONTROL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_FIFO_CONTROL_0_READ_MASK                    _MK_MASK_CONST(0xff)
#define DVC_FIFO_CONTROL_0_WRITE_MASK                   _MK_MASK_CONST(0xff)
//Transmit fifo trigger level 
//000 = 1 word,  Dma trigger is asserted when 
//at least one word empty in the fifo 
//010 = 2 word,  Dma trigger is asserted when 
//at least 2 words empty in the fifo 
#define DVC_FIFO_CONTROL_0_TX_FIFO_TRIG_SHIFT                   _MK_SHIFT_CONST(5)
#define DVC_FIFO_CONTROL_0_TX_FIFO_TRIG_FIELD                   (_MK_MASK_CONST(0x7) << DVC_FIFO_CONTROL_0_TX_FIFO_TRIG_SHIFT)
#define DVC_FIFO_CONTROL_0_TX_FIFO_TRIG_RANGE                   7:5
#define DVC_FIFO_CONTROL_0_TX_FIFO_TRIG_WOFFSET                 0x0
#define DVC_FIFO_CONTROL_0_TX_FIFO_TRIG_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_FIFO_CONTROL_0_TX_FIFO_TRIG_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define DVC_FIFO_CONTROL_0_TX_FIFO_TRIG_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_FIFO_CONTROL_0_TX_FIFO_TRIG_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//Receive fifo trigger level 
//000 = 1 word  Dma trigger is asserted when 
//at least one word full in the fifo 
//010 = 2 word  Dma trigger is asserted when 
//at least 2 word full in the fifo 
#define DVC_FIFO_CONTROL_0_RX_FIFO_TRIG_SHIFT                   _MK_SHIFT_CONST(2)
#define DVC_FIFO_CONTROL_0_RX_FIFO_TRIG_FIELD                   (_MK_MASK_CONST(0x7) << DVC_FIFO_CONTROL_0_RX_FIFO_TRIG_SHIFT)
#define DVC_FIFO_CONTROL_0_RX_FIFO_TRIG_RANGE                   4:2
#define DVC_FIFO_CONTROL_0_RX_FIFO_TRIG_WOFFSET                 0x0
#define DVC_FIFO_CONTROL_0_RX_FIFO_TRIG_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_FIFO_CONTROL_0_RX_FIFO_TRIG_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define DVC_FIFO_CONTROL_0_RX_FIFO_TRIG_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_FIFO_CONTROL_0_RX_FIFO_TRIG_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

//1= flush the tx fifo,cleared after fifo is flushed
#define DVC_FIFO_CONTROL_0_TX_FIFO_FLUSH_SHIFT                  _MK_SHIFT_CONST(1)
#define DVC_FIFO_CONTROL_0_TX_FIFO_FLUSH_FIELD                  (_MK_MASK_CONST(0x1) << DVC_FIFO_CONTROL_0_TX_FIFO_FLUSH_SHIFT)
#define DVC_FIFO_CONTROL_0_TX_FIFO_FLUSH_RANGE                  1:1
#define DVC_FIFO_CONTROL_0_TX_FIFO_FLUSH_WOFFSET                        0x0
#define DVC_FIFO_CONTROL_0_TX_FIFO_FLUSH_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_FIFO_CONTROL_0_TX_FIFO_FLUSH_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define DVC_FIFO_CONTROL_0_TX_FIFO_FLUSH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_FIFO_CONTROL_0_TX_FIFO_FLUSH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define DVC_FIFO_CONTROL_0_TX_FIFO_FLUSH_UNSET                  _MK_ENUM_CONST(0)
#define DVC_FIFO_CONTROL_0_TX_FIFO_FLUSH_SET                    _MK_ENUM_CONST(1)

//1= flush the rx fifo,cleared after fifo is flushed 
#define DVC_FIFO_CONTROL_0_RX_FIFO_FLUSH_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_FIFO_CONTROL_0_RX_FIFO_FLUSH_FIELD                  (_MK_MASK_CONST(0x1) << DVC_FIFO_CONTROL_0_RX_FIFO_FLUSH_SHIFT)
#define DVC_FIFO_CONTROL_0_RX_FIFO_FLUSH_RANGE                  0:0
#define DVC_FIFO_CONTROL_0_RX_FIFO_FLUSH_WOFFSET                        0x0
#define DVC_FIFO_CONTROL_0_RX_FIFO_FLUSH_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_FIFO_CONTROL_0_RX_FIFO_FLUSH_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define DVC_FIFO_CONTROL_0_RX_FIFO_FLUSH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_FIFO_CONTROL_0_RX_FIFO_FLUSH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define DVC_FIFO_CONTROL_0_RX_FIFO_FLUSH_UNSET                  _MK_ENUM_CONST(0)
#define DVC_FIFO_CONTROL_0_RX_FIFO_FLUSH_SET                    _MK_ENUM_CONST(1)


// Register DVC_FIFO_STATUS_0  
#define DVC_FIFO_STATUS_0                       _MK_ADDR_CONST(0x70)
#define DVC_FIFO_STATUS_0_SECURE                        0x0
#define DVC_FIFO_STATUS_0_WORD_COUNT                    0x1
#define DVC_FIFO_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define DVC_FIFO_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0xff)
#define DVC_FIFO_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define DVC_FIFO_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define DVC_FIFO_STATUS_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define DVC_FIFO_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
//The number of slots that can be written to the tx fifo
//0000 = tx_fifo full
//0001 = 1 slot empty 
//0010 = 2 slots empty 
#define DVC_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_SHIFT                       _MK_SHIFT_CONST(4)
#define DVC_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_FIELD                       (_MK_MASK_CONST(0xf) << DVC_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_SHIFT)
#define DVC_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_RANGE                       7:4
#define DVC_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_WOFFSET                     0x0
#define DVC_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define DVC_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_FIFO_STATUS_0_TX_FIFO_EMPTY_CNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

//The number of slots to be read from  the rx fifo
//0000 = rx_fifo empty
//0001 = 1 slot  full
//0010 = 2 slots  full
#define DVC_FIFO_STATUS_0_RX_FIFO_FULL_CNT_SHIFT                        _MK_SHIFT_CONST(0)
#define DVC_FIFO_STATUS_0_RX_FIFO_FULL_CNT_FIELD                        (_MK_MASK_CONST(0xf) << DVC_FIFO_STATUS_0_RX_FIFO_FULL_CNT_SHIFT)
#define DVC_FIFO_STATUS_0_RX_FIFO_FULL_CNT_RANGE                        3:0
#define DVC_FIFO_STATUS_0_RX_FIFO_FULL_CNT_WOFFSET                      0x0
#define DVC_FIFO_STATUS_0_RX_FIFO_FULL_CNT_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_FIFO_STATUS_0_RX_FIFO_FULL_CNT_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define DVC_FIFO_STATUS_0_RX_FIFO_FULL_CNT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_FIFO_STATUS_0_RX_FIFO_FULL_CNT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register DVC_INTERRUPT_MASK_REGISTER_0  
#define DVC_INTERRUPT_MASK_REGISTER_0                   _MK_ADDR_CONST(0x74)
#define DVC_INTERRUPT_MASK_REGISTER_0_SECURE                    0x0
#define DVC_INTERRUPT_MASK_REGISTER_0_WORD_COUNT                        0x1
#define DVC_INTERRUPT_MASK_REGISTER_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_RESET_MASK                        _MK_MASK_CONST(0x7f)
#define DVC_INTERRUPT_MASK_REGISTER_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_READ_MASK                         _MK_MASK_CONST(0x7f)
#define DVC_INTERRUPT_MASK_REGISTER_0_WRITE_MASK                        _MK_MASK_CONST(0x7f)
#define DVC_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_SHIFT                    _MK_SHIFT_CONST(6)
#define DVC_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << DVC_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_SHIFT)
#define DVC_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_RANGE                    6:6
#define DVC_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_WOFFSET                  0x0
#define DVC_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define DVC_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define DVC_INTERRUPT_MASK_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_SHIFT                    _MK_SHIFT_CONST(5)
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_SHIFT)
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_RANGE                    5:5
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_WOFFSET                  0x0
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_OVF_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_SHIFT                    _MK_SHIFT_CONST(4)
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_FIELD                    (_MK_MASK_CONST(0x1) << DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_SHIFT)
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_RANGE                    4:4
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_WOFFSET                  0x0
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_DISABLE                  _MK_ENUM_CONST(0)
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_UNF_INT_EN_ENABLE                   _MK_ENUM_CONST(1)

#define DVC_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_SHIFT                        _MK_SHIFT_CONST(3)
#define DVC_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_FIELD                        (_MK_MASK_CONST(0x1) << DVC_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_SHIFT)
#define DVC_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_RANGE                        3:3
#define DVC_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_WOFFSET                      0x0
#define DVC_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define DVC_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_DISABLE                      _MK_ENUM_CONST(0)
#define DVC_INTERRUPT_MASK_REGISTER_0_NOACK_INT_EN_ENABLE                       _MK_ENUM_CONST(1)

#define DVC_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_SHIFT                     _MK_SHIFT_CONST(2)
#define DVC_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_FIELD                     (_MK_MASK_CONST(0x1) << DVC_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_SHIFT)
#define DVC_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_RANGE                     2:2
#define DVC_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_WOFFSET                   0x0
#define DVC_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define DVC_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_DISABLE                   _MK_ENUM_CONST(0)
#define DVC_INTERRUPT_MASK_REGISTER_0_ARB_LOST_INT_EN_ENABLE                    _MK_ENUM_CONST(1)

#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_SHIFT                       _MK_SHIFT_CONST(1)
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_FIELD                       (_MK_MASK_CONST(0x1) << DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_SHIFT)
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_RANGE                       1:1
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_WOFFSET                     0x0
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define DVC_INTERRUPT_MASK_REGISTER_0_TFIFO_DATA_REQ_INT_EN_ENABLE                      _MK_ENUM_CONST(1)

#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_SHIFT                       _MK_SHIFT_CONST(0)
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_FIELD                       (_MK_MASK_CONST(0x1) << DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_SHIFT)
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_RANGE                       0:0
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_WOFFSET                     0x0
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_DISABLE                     _MK_ENUM_CONST(0)
#define DVC_INTERRUPT_MASK_REGISTER_0_RFIFO_DATA_REQ_INT_EN_ENABLE                      _MK_ENUM_CONST(1)


// Register DVC_INTERRUPT_STATUS_REGISTER_0  //This register indicates the status bit for which the interrupt is set.If set,Write 1 to clear it
//However TFIFO_DATA_REQ,RFIFO_DATA_REQ fields depend on the fifo trigger levels and cannot be cleared.
#define DVC_INTERRUPT_STATUS_REGISTER_0                 _MK_ADDR_CONST(0x78)
#define DVC_INTERRUPT_STATUS_REGISTER_0_SECURE                  0x0
#define DVC_INTERRUPT_STATUS_REGISTER_0_WORD_COUNT                      0x1
#define DVC_INTERRUPT_STATUS_REGISTER_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_RESET_MASK                      _MK_MASK_CONST(0xff)
#define DVC_INTERRUPT_STATUS_REGISTER_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define DVC_INTERRUPT_STATUS_REGISTER_0_WRITE_MASK                      _MK_MASK_CONST(0xff)
//A packet has been transferred succesfully.
//TRANSFER_PKT_ID filed can be used to know the 
//current byte under transfer.This bit can be
//masked by the IE field in the i2c specific header
#define DVC_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_SHIFT                      _MK_SHIFT_CONST(7)
#define DVC_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_FIELD                      (_MK_MASK_CONST(0x1) << DVC_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_SHIFT)
#define DVC_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_RANGE                      7:7
#define DVC_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_WOFFSET                    0x0
#define DVC_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define DVC_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_UNSET                      _MK_ENUM_CONST(0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_PACKET_XFER_COMPLETE_SET                        _MK_ENUM_CONST(1)

//All the packets transferred succesfully
#define DVC_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_SHIFT                 _MK_SHIFT_CONST(6)
#define DVC_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_FIELD                 (_MK_MASK_CONST(0x1) << DVC_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_SHIFT)
#define DVC_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_RANGE                 6:6
#define DVC_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_WOFFSET                       0x0
#define DVC_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define DVC_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_UNSET                 _MK_ENUM_CONST(0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_ALL_PACKETS_XFER_COMPLETE_SET                   _MK_ENUM_CONST(1)

//Tx fifo overflow
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_FIELD                 (_MK_MASK_CONST(0x1) << DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_SHIFT)
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_RANGE                 5:5
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_WOFFSET                       0x0
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_UNSET                 _MK_ENUM_CONST(0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_OVF_SET                   _MK_ENUM_CONST(1)

//rx fifo underflow
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_SHIFT                 _MK_SHIFT_CONST(4)
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_FIELD                 (_MK_MASK_CONST(0x1) << DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_SHIFT)
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_RANGE                 4:4
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_WOFFSET                       0x0
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_UNSET                 _MK_ENUM_CONST(0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_UNF_SET                   _MK_ENUM_CONST(1)

//No ACK from slave
#define DVC_INTERRUPT_STATUS_REGISTER_0_NOACK_SHIFT                     _MK_SHIFT_CONST(3)
#define DVC_INTERRUPT_STATUS_REGISTER_0_NOACK_FIELD                     (_MK_MASK_CONST(0x1) << DVC_INTERRUPT_STATUS_REGISTER_0_NOACK_SHIFT)
#define DVC_INTERRUPT_STATUS_REGISTER_0_NOACK_RANGE                     3:3
#define DVC_INTERRUPT_STATUS_REGISTER_0_NOACK_WOFFSET                   0x0
#define DVC_INTERRUPT_STATUS_REGISTER_0_NOACK_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_NOACK_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define DVC_INTERRUPT_STATUS_REGISTER_0_NOACK_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_NOACK_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_NOACK_UNSET                     _MK_ENUM_CONST(0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_NOACK_SET                       _MK_ENUM_CONST(1)

//Arbitration lost
#define DVC_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_SHIFT                  _MK_SHIFT_CONST(2)
#define DVC_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_FIELD                  (_MK_MASK_CONST(0x1) << DVC_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_SHIFT)
#define DVC_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_RANGE                  2:2
#define DVC_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_WOFFSET                        0x0
#define DVC_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define DVC_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_UNSET                  _MK_ENUM_CONST(0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_ARB_LOST_SET                    _MK_ENUM_CONST(1)

//Tx fifo data req
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_SHIFT                    _MK_SHIFT_CONST(1)
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_FIELD                    (_MK_MASK_CONST(0x1) << DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_SHIFT)
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_RANGE                    1:1
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_WOFFSET                  0x0
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_UNSET                    _MK_ENUM_CONST(0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_TFIFO_DATA_REQ_SET                      _MK_ENUM_CONST(1)

//rx fifo data req
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_SHIFT                    _MK_SHIFT_CONST(0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_FIELD                    (_MK_MASK_CONST(0x1) << DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_SHIFT)
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_RANGE                    0:0
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_WOFFSET                  0x0
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_UNSET                    _MK_ENUM_CONST(0)
#define DVC_INTERRUPT_STATUS_REGISTER_0_RFIFO_DATA_REQ_SET                      _MK_ENUM_CONST(1)


// Register DVC_I2C_CLK_DIVISOR_REGISTER_0  
#define DVC_I2C_CLK_DIVISOR_REGISTER_0                  _MK_ADDR_CONST(0x7c)
#define DVC_I2C_CLK_DIVISOR_REGISTER_0_SECURE                   0x0
#define DVC_I2C_CLK_DIVISOR_REGISTER_0_WORD_COUNT                       0x1
#define DVC_I2C_CLK_DIVISOR_REGISTER_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define DVC_I2C_CLK_DIVISOR_REGISTER_0_RESET_MASK                       _MK_MASK_CONST(0xffff)
#define DVC_I2C_CLK_DIVISOR_REGISTER_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define DVC_I2C_CLK_DIVISOR_REGISTER_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define DVC_I2C_CLK_DIVISOR_REGISTER_0_READ_MASK                        _MK_MASK_CONST(0xffff)
#define DVC_I2C_CLK_DIVISOR_REGISTER_0_WRITE_MASK                       _MK_MASK_CONST(0xffff)
//N= divide by n+1
#define DVC_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_SHIFT                     _MK_SHIFT_CONST(0)
#define DVC_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_FIELD                     (_MK_MASK_CONST(0xffff) << DVC_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_SHIFT)
#define DVC_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_RANGE                     15:0
#define DVC_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_WOFFSET                   0x0
#define DVC_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_DEFAULT_MASK                      _MK_MASK_CONST(0xffff)
#define DVC_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_I2C_CLK_DIVISOR_REGISTER_0_I2C_CLK_DIVISOR_HSMODE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_0  
#define DVC_VSEL_MAP_LUT_0                      _MK_ADDR_CONST(0x80)
#define DVC_VSEL_MAP_LUT_0_SECURE                       0x0
#define DVC_VSEL_MAP_LUT_0_WORD_COUNT                   0x1
#define DVC_VSEL_MAP_LUT_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_0_RESET_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_0_READ_MASK                    _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_0_WRITE_MASK                   _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_0_VSEL3_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_0_VSEL3_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_0_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_0_VSEL3_RANGE                  9:5
#define DVC_VSEL_MAP_LUT_0_VSEL3_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_0_VSEL3_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_0_VSEL3_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_0_VSEL3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_0_VSEL3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_0_VSEL2_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_0_VSEL2_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_0_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_0_VSEL2_RANGE                  4:0
#define DVC_VSEL_MAP_LUT_0_VSEL2_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_0_VSEL2_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_0_VSEL2_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_0_VSEL2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_0_VSEL2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT  
#define DVC_VSEL_MAP_LUT                        _MK_ADDR_CONST(0x80)
#define DVC_VSEL_MAP_LUT_SECURE                         0x0
#define DVC_VSEL_MAP_LUT_WORD_COUNT                     0x1
#define DVC_VSEL_MAP_LUT_RESET_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_RESET_MASK                     _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_READ_MASK                      _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_WRITE_MASK                     _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_VSEL3_SHIFT                    _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_VSEL3_FIELD                    (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_VSEL3_RANGE                    9:5
#define DVC_VSEL_MAP_LUT_VSEL3_WOFFSET                  0x0
#define DVC_VSEL_MAP_LUT_VSEL3_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_VSEL3_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_VSEL3_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_VSEL3_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_VSEL2_SHIFT                    _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_VSEL2_FIELD                    (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_VSEL2_RANGE                    4:0
#define DVC_VSEL_MAP_LUT_VSEL2_WOFFSET                  0x0
#define DVC_VSEL_MAP_LUT_VSEL2_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_VSEL2_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_VSEL2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_VSEL2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_1  
#define DVC_VSEL_MAP_LUT_1                      _MK_ADDR_CONST(0x84)
#define DVC_VSEL_MAP_LUT_1_SECURE                       0x0
#define DVC_VSEL_MAP_LUT_1_WORD_COUNT                   0x1
#define DVC_VSEL_MAP_LUT_1_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_1_RESET_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_1_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_1_READ_MASK                    _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_1_WRITE_MASK                   _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_1_VSEL3_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_1_VSEL3_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_1_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_1_VSEL3_RANGE                  9:5
#define DVC_VSEL_MAP_LUT_1_VSEL3_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_1_VSEL3_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_1_VSEL3_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_1_VSEL3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_1_VSEL3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_1_VSEL2_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_1_VSEL2_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_1_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_1_VSEL2_RANGE                  4:0
#define DVC_VSEL_MAP_LUT_1_VSEL2_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_1_VSEL2_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_1_VSEL2_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_1_VSEL2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_1_VSEL2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_2  
#define DVC_VSEL_MAP_LUT_2                      _MK_ADDR_CONST(0x88)
#define DVC_VSEL_MAP_LUT_2_SECURE                       0x0
#define DVC_VSEL_MAP_LUT_2_WORD_COUNT                   0x1
#define DVC_VSEL_MAP_LUT_2_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_2_RESET_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_2_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_2_READ_MASK                    _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_2_WRITE_MASK                   _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_2_VSEL3_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_2_VSEL3_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_2_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_2_VSEL3_RANGE                  9:5
#define DVC_VSEL_MAP_LUT_2_VSEL3_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_2_VSEL3_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_2_VSEL3_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_2_VSEL3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_2_VSEL3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_2_VSEL2_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_2_VSEL2_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_2_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_2_VSEL2_RANGE                  4:0
#define DVC_VSEL_MAP_LUT_2_VSEL2_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_2_VSEL2_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_2_VSEL2_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_2_VSEL2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_2_VSEL2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_3  
#define DVC_VSEL_MAP_LUT_3                      _MK_ADDR_CONST(0x8c)
#define DVC_VSEL_MAP_LUT_3_SECURE                       0x0
#define DVC_VSEL_MAP_LUT_3_WORD_COUNT                   0x1
#define DVC_VSEL_MAP_LUT_3_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_3_RESET_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_3_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_3_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_3_READ_MASK                    _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_3_WRITE_MASK                   _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_3_VSEL3_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_3_VSEL3_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_3_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_3_VSEL3_RANGE                  9:5
#define DVC_VSEL_MAP_LUT_3_VSEL3_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_3_VSEL3_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_3_VSEL3_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_3_VSEL3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_3_VSEL3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_3_VSEL2_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_3_VSEL2_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_3_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_3_VSEL2_RANGE                  4:0
#define DVC_VSEL_MAP_LUT_3_VSEL2_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_3_VSEL2_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_3_VSEL2_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_3_VSEL2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_3_VSEL2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_4  
#define DVC_VSEL_MAP_LUT_4                      _MK_ADDR_CONST(0x90)
#define DVC_VSEL_MAP_LUT_4_SECURE                       0x0
#define DVC_VSEL_MAP_LUT_4_WORD_COUNT                   0x1
#define DVC_VSEL_MAP_LUT_4_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_4_RESET_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_4_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_4_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_4_READ_MASK                    _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_4_WRITE_MASK                   _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_4_VSEL3_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_4_VSEL3_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_4_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_4_VSEL3_RANGE                  9:5
#define DVC_VSEL_MAP_LUT_4_VSEL3_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_4_VSEL3_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_4_VSEL3_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_4_VSEL3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_4_VSEL3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_4_VSEL2_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_4_VSEL2_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_4_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_4_VSEL2_RANGE                  4:0
#define DVC_VSEL_MAP_LUT_4_VSEL2_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_4_VSEL2_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_4_VSEL2_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_4_VSEL2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_4_VSEL2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_5  
#define DVC_VSEL_MAP_LUT_5                      _MK_ADDR_CONST(0x94)
#define DVC_VSEL_MAP_LUT_5_SECURE                       0x0
#define DVC_VSEL_MAP_LUT_5_WORD_COUNT                   0x1
#define DVC_VSEL_MAP_LUT_5_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_5_RESET_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_5_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_5_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_5_READ_MASK                    _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_5_WRITE_MASK                   _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_5_VSEL3_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_5_VSEL3_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_5_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_5_VSEL3_RANGE                  9:5
#define DVC_VSEL_MAP_LUT_5_VSEL3_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_5_VSEL3_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_5_VSEL3_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_5_VSEL3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_5_VSEL3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_5_VSEL2_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_5_VSEL2_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_5_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_5_VSEL2_RANGE                  4:0
#define DVC_VSEL_MAP_LUT_5_VSEL2_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_5_VSEL2_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_5_VSEL2_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_5_VSEL2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_5_VSEL2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_6  
#define DVC_VSEL_MAP_LUT_6                      _MK_ADDR_CONST(0x98)
#define DVC_VSEL_MAP_LUT_6_SECURE                       0x0
#define DVC_VSEL_MAP_LUT_6_WORD_COUNT                   0x1
#define DVC_VSEL_MAP_LUT_6_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_6_RESET_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_6_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_6_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_6_READ_MASK                    _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_6_WRITE_MASK                   _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_6_VSEL3_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_6_VSEL3_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_6_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_6_VSEL3_RANGE                  9:5
#define DVC_VSEL_MAP_LUT_6_VSEL3_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_6_VSEL3_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_6_VSEL3_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_6_VSEL3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_6_VSEL3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_6_VSEL2_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_6_VSEL2_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_6_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_6_VSEL2_RANGE                  4:0
#define DVC_VSEL_MAP_LUT_6_VSEL2_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_6_VSEL2_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_6_VSEL2_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_6_VSEL2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_6_VSEL2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_7  
#define DVC_VSEL_MAP_LUT_7                      _MK_ADDR_CONST(0x9c)
#define DVC_VSEL_MAP_LUT_7_SECURE                       0x0
#define DVC_VSEL_MAP_LUT_7_WORD_COUNT                   0x1
#define DVC_VSEL_MAP_LUT_7_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_7_RESET_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_7_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_7_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_7_READ_MASK                    _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_7_WRITE_MASK                   _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_7_VSEL3_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_7_VSEL3_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_7_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_7_VSEL3_RANGE                  9:5
#define DVC_VSEL_MAP_LUT_7_VSEL3_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_7_VSEL3_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_7_VSEL3_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_7_VSEL3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_7_VSEL3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_7_VSEL2_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_7_VSEL2_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_7_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_7_VSEL2_RANGE                  4:0
#define DVC_VSEL_MAP_LUT_7_VSEL2_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_7_VSEL2_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_7_VSEL2_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_7_VSEL2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_7_VSEL2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_8  
#define DVC_VSEL_MAP_LUT_8                      _MK_ADDR_CONST(0xa0)
#define DVC_VSEL_MAP_LUT_8_SECURE                       0x0
#define DVC_VSEL_MAP_LUT_8_WORD_COUNT                   0x1
#define DVC_VSEL_MAP_LUT_8_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_8_RESET_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_8_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_8_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_8_READ_MASK                    _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_8_WRITE_MASK                   _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_8_VSEL3_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_8_VSEL3_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_8_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_8_VSEL3_RANGE                  9:5
#define DVC_VSEL_MAP_LUT_8_VSEL3_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_8_VSEL3_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_8_VSEL3_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_8_VSEL3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_8_VSEL3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_8_VSEL2_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_8_VSEL2_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_8_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_8_VSEL2_RANGE                  4:0
#define DVC_VSEL_MAP_LUT_8_VSEL2_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_8_VSEL2_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_8_VSEL2_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_8_VSEL2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_8_VSEL2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_9  
#define DVC_VSEL_MAP_LUT_9                      _MK_ADDR_CONST(0xa4)
#define DVC_VSEL_MAP_LUT_9_SECURE                       0x0
#define DVC_VSEL_MAP_LUT_9_WORD_COUNT                   0x1
#define DVC_VSEL_MAP_LUT_9_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_9_RESET_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_9_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_9_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_9_READ_MASK                    _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_9_WRITE_MASK                   _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_9_VSEL3_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_9_VSEL3_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_9_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_9_VSEL3_RANGE                  9:5
#define DVC_VSEL_MAP_LUT_9_VSEL3_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_9_VSEL3_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_9_VSEL3_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_9_VSEL3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_9_VSEL3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_9_VSEL2_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_9_VSEL2_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_9_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_9_VSEL2_RANGE                  4:0
#define DVC_VSEL_MAP_LUT_9_VSEL2_WOFFSET                        0x0
#define DVC_VSEL_MAP_LUT_9_VSEL2_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_9_VSEL2_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_9_VSEL2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_9_VSEL2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_10  
#define DVC_VSEL_MAP_LUT_10                     _MK_ADDR_CONST(0xa8)
#define DVC_VSEL_MAP_LUT_10_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_10_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_10_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_10_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_10_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_10_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_10_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_10_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_10_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_10_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_10_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_10_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_10_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_10_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_10_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_10_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_10_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_10_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_10_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_10_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_10_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_10_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_10_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_10_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_10_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_10_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_11  
#define DVC_VSEL_MAP_LUT_11                     _MK_ADDR_CONST(0xac)
#define DVC_VSEL_MAP_LUT_11_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_11_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_11_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_11_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_11_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_11_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_11_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_11_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_11_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_11_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_11_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_11_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_11_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_11_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_11_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_11_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_11_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_11_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_11_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_11_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_11_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_11_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_11_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_11_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_11_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_11_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_12  
#define DVC_VSEL_MAP_LUT_12                     _MK_ADDR_CONST(0xb0)
#define DVC_VSEL_MAP_LUT_12_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_12_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_12_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_12_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_12_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_12_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_12_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_12_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_12_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_12_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_12_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_12_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_12_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_12_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_12_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_12_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_12_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_12_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_12_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_12_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_12_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_12_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_12_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_12_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_12_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_12_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_13  
#define DVC_VSEL_MAP_LUT_13                     _MK_ADDR_CONST(0xb4)
#define DVC_VSEL_MAP_LUT_13_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_13_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_13_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_13_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_13_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_13_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_13_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_13_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_13_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_13_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_13_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_13_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_13_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_13_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_13_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_13_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_13_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_13_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_13_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_13_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_13_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_13_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_13_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_13_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_13_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_13_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_14  
#define DVC_VSEL_MAP_LUT_14                     _MK_ADDR_CONST(0xb8)
#define DVC_VSEL_MAP_LUT_14_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_14_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_14_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_14_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_14_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_14_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_14_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_14_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_14_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_14_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_14_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_14_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_14_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_14_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_14_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_14_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_14_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_14_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_14_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_14_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_14_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_14_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_14_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_14_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_14_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_14_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_15  
#define DVC_VSEL_MAP_LUT_15                     _MK_ADDR_CONST(0xbc)
#define DVC_VSEL_MAP_LUT_15_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_15_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_15_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_15_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_15_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_15_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_15_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_15_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_15_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_15_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_15_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_15_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_15_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_15_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_15_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_15_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_15_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_15_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_15_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_15_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_15_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_15_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_15_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_15_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_15_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_15_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_16  
#define DVC_VSEL_MAP_LUT_16                     _MK_ADDR_CONST(0xc0)
#define DVC_VSEL_MAP_LUT_16_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_16_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_16_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_16_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_16_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_16_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_16_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_16_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_16_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_16_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_16_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_16_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_16_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_16_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_16_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_16_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_16_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_16_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_16_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_16_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_16_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_16_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_16_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_16_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_16_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_16_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_17  
#define DVC_VSEL_MAP_LUT_17                     _MK_ADDR_CONST(0xc4)
#define DVC_VSEL_MAP_LUT_17_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_17_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_17_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_17_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_17_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_17_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_17_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_17_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_17_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_17_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_17_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_17_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_17_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_17_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_17_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_17_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_17_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_17_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_17_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_17_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_17_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_17_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_17_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_17_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_17_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_17_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_18  
#define DVC_VSEL_MAP_LUT_18                     _MK_ADDR_CONST(0xc8)
#define DVC_VSEL_MAP_LUT_18_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_18_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_18_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_18_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_18_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_18_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_18_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_18_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_18_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_18_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_18_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_18_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_18_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_18_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_18_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_18_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_18_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_18_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_18_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_18_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_18_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_18_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_18_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_18_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_18_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_18_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_19  
#define DVC_VSEL_MAP_LUT_19                     _MK_ADDR_CONST(0xcc)
#define DVC_VSEL_MAP_LUT_19_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_19_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_19_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_19_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_19_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_19_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_19_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_19_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_19_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_19_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_19_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_19_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_19_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_19_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_19_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_19_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_19_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_19_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_19_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_19_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_19_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_19_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_19_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_19_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_19_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_19_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_20  
#define DVC_VSEL_MAP_LUT_20                     _MK_ADDR_CONST(0xd0)
#define DVC_VSEL_MAP_LUT_20_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_20_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_20_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_20_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_20_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_20_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_20_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_20_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_20_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_20_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_20_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_20_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_20_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_20_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_20_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_20_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_20_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_20_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_20_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_20_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_20_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_20_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_20_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_20_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_20_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_20_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_21  
#define DVC_VSEL_MAP_LUT_21                     _MK_ADDR_CONST(0xd4)
#define DVC_VSEL_MAP_LUT_21_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_21_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_21_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_21_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_21_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_21_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_21_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_21_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_21_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_21_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_21_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_21_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_21_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_21_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_21_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_21_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_21_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_21_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_21_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_21_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_21_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_21_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_21_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_21_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_21_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_21_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_22  
#define DVC_VSEL_MAP_LUT_22                     _MK_ADDR_CONST(0xd8)
#define DVC_VSEL_MAP_LUT_22_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_22_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_22_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_22_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_22_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_22_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_22_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_22_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_22_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_22_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_22_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_22_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_22_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_22_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_22_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_22_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_22_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_22_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_22_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_22_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_22_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_22_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_22_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_22_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_22_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_22_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_23  
#define DVC_VSEL_MAP_LUT_23                     _MK_ADDR_CONST(0xdc)
#define DVC_VSEL_MAP_LUT_23_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_23_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_23_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_23_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_23_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_23_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_23_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_23_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_23_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_23_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_23_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_23_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_23_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_23_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_23_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_23_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_23_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_23_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_23_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_23_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_23_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_23_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_23_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_23_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_23_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_23_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_24  
#define DVC_VSEL_MAP_LUT_24                     _MK_ADDR_CONST(0xe0)
#define DVC_VSEL_MAP_LUT_24_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_24_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_24_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_24_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_24_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_24_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_24_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_24_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_24_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_24_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_24_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_24_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_24_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_24_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_24_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_24_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_24_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_24_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_24_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_24_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_24_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_24_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_24_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_24_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_24_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_24_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_25  
#define DVC_VSEL_MAP_LUT_25                     _MK_ADDR_CONST(0xe4)
#define DVC_VSEL_MAP_LUT_25_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_25_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_25_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_25_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_25_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_25_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_25_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_25_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_25_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_25_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_25_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_25_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_25_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_25_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_25_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_25_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_25_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_25_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_25_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_25_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_25_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_25_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_25_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_25_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_25_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_25_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_26  
#define DVC_VSEL_MAP_LUT_26                     _MK_ADDR_CONST(0xe8)
#define DVC_VSEL_MAP_LUT_26_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_26_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_26_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_26_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_26_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_26_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_26_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_26_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_26_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_26_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_26_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_26_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_26_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_26_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_26_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_26_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_26_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_26_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_26_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_26_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_26_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_26_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_26_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_26_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_26_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_26_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_27  
#define DVC_VSEL_MAP_LUT_27                     _MK_ADDR_CONST(0xec)
#define DVC_VSEL_MAP_LUT_27_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_27_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_27_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_27_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_27_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_27_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_27_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_27_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_27_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_27_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_27_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_27_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_27_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_27_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_27_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_27_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_27_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_27_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_27_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_27_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_27_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_27_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_27_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_27_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_27_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_27_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_28  
#define DVC_VSEL_MAP_LUT_28                     _MK_ADDR_CONST(0xf0)
#define DVC_VSEL_MAP_LUT_28_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_28_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_28_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_28_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_28_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_28_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_28_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_28_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_28_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_28_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_28_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_28_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_28_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_28_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_28_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_28_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_28_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_28_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_28_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_28_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_28_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_28_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_28_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_28_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_28_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_28_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_29  
#define DVC_VSEL_MAP_LUT_29                     _MK_ADDR_CONST(0xf4)
#define DVC_VSEL_MAP_LUT_29_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_29_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_29_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_29_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_29_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_29_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_29_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_29_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_29_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_29_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_29_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_29_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_29_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_29_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_29_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_29_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_29_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_29_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_29_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_29_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_29_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_29_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_29_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_29_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_29_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_29_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_30  
#define DVC_VSEL_MAP_LUT_30                     _MK_ADDR_CONST(0xf8)
#define DVC_VSEL_MAP_LUT_30_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_30_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_30_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_30_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_30_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_30_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_30_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_30_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_30_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_30_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_30_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_30_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_30_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_30_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_30_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_30_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_30_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_30_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_30_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_30_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_30_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_30_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_30_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_30_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_30_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_30_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VSEL_MAP_LUT_31  
#define DVC_VSEL_MAP_LUT_31                     _MK_ADDR_CONST(0xfc)
#define DVC_VSEL_MAP_LUT_31_SECURE                      0x0
#define DVC_VSEL_MAP_LUT_31_WORD_COUNT                  0x1
#define DVC_VSEL_MAP_LUT_31_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_31_RESET_MASK                  _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_31_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_31_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_31_READ_MASK                   _MK_MASK_CONST(0x3ff)
#define DVC_VSEL_MAP_LUT_31_WRITE_MASK                  _MK_MASK_CONST(0x3ff)
//VSEL3 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_31_VSEL3_SHIFT                 _MK_SHIFT_CONST(5)
#define DVC_VSEL_MAP_LUT_31_VSEL3_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_31_VSEL3_SHIFT)
#define DVC_VSEL_MAP_LUT_31_VSEL3_RANGE                 9:5
#define DVC_VSEL_MAP_LUT_31_VSEL3_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_31_VSEL3_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_31_VSEL3_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_31_VSEL3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_31_VSEL3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

//VSEL2 Corresponding to VSEL1
#define DVC_VSEL_MAP_LUT_31_VSEL2_SHIFT                 _MK_SHIFT_CONST(0)
#define DVC_VSEL_MAP_LUT_31_VSEL2_FIELD                 (_MK_MASK_CONST(0x1f) << DVC_VSEL_MAP_LUT_31_VSEL2_SHIFT)
#define DVC_VSEL_MAP_LUT_31_VSEL2_RANGE                 4:0
#define DVC_VSEL_MAP_LUT_31_VSEL2_WOFFSET                       0x0
#define DVC_VSEL_MAP_LUT_31_VSEL2_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_31_VSEL2_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define DVC_VSEL_MAP_LUT_31_VSEL2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VSEL_MAP_LUT_31_VSEL2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_0  
#define DVC_VLUT_0                      _MK_ADDR_CONST(0x100)
#define DVC_VLUT_0_SECURE                       0x0
#define DVC_VLUT_0_WORD_COUNT                   0x1
#define DVC_VLUT_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_0_RESET_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_0_READ_MASK                    _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_0_WRITE_MASK                   _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_0_PMCNT_SHIFT                  _MK_SHIFT_CONST(10)
#define DVC_VLUT_0_PMCNT_FIELD                  (_MK_MASK_CONST(0x3fff) << DVC_VLUT_0_PMCNT_SHIFT)
#define DVC_VLUT_0_PMCNT_RANGE                  23:10
#define DVC_VLUT_0_PMCNT_WOFFSET                        0x0
#define DVC_VLUT_0_PMCNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_0_PMCNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_0_PMCNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_0_PMCNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_0_VMIN_SHIFT                   _MK_SHIFT_CONST(5)
#define DVC_VLUT_0_VMIN_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_0_VMIN_SHIFT)
#define DVC_VLUT_0_VMIN_RANGE                   9:5
#define DVC_VLUT_0_VMIN_WOFFSET                 0x0
#define DVC_VLUT_0_VMIN_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_0_VMIN_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_0_VMIN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_0_VMIN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_0_VMAX_SHIFT                   _MK_SHIFT_CONST(0)
#define DVC_VLUT_0_VMAX_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_0_VMAX_SHIFT)
#define DVC_VLUT_0_VMAX_RANGE                   4:0
#define DVC_VLUT_0_VMAX_WOFFSET                 0x0
#define DVC_VLUT_0_VMAX_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_0_VMAX_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_0_VMAX_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_0_VMAX_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Ram DVC_VLUT  
#define DVC_VLUT                        _MK_ADDR_CONST(0x100)
#define DVC_VLUT_SECURE                         0x0
#define DVC_VLUT_WORD_COUNT                     0x1
#define DVC_VLUT_RESET_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_RESET_MASK                     _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define DVC_VLUT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_READ_MASK                      _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_WRITE_MASK                     _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_PMCNT_SHIFT                    _MK_SHIFT_CONST(10)
#define DVC_VLUT_PMCNT_FIELD                    (_MK_MASK_CONST(0x3fff) << DVC_VLUT_PMCNT_SHIFT)
#define DVC_VLUT_PMCNT_RANGE                    23:10
#define DVC_VLUT_PMCNT_WOFFSET                  0x0
#define DVC_VLUT_PMCNT_DEFAULT                  _MK_MASK_CONST(0x0)
#define DVC_VLUT_PMCNT_DEFAULT_MASK                     _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_PMCNT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_PMCNT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_VMIN_SHIFT                     _MK_SHIFT_CONST(5)
#define DVC_VLUT_VMIN_FIELD                     (_MK_MASK_CONST(0x1f) << DVC_VLUT_VMIN_SHIFT)
#define DVC_VLUT_VMIN_RANGE                     9:5
#define DVC_VLUT_VMIN_WOFFSET                   0x0
#define DVC_VLUT_VMIN_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_VMIN_DEFAULT_MASK                      _MK_MASK_CONST(0x1f)
#define DVC_VLUT_VMIN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_VMIN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_VMAX_SHIFT                     _MK_SHIFT_CONST(0)
#define DVC_VLUT_VMAX_FIELD                     (_MK_MASK_CONST(0x1f) << DVC_VLUT_VMAX_SHIFT)
#define DVC_VLUT_VMAX_RANGE                     4:0
#define DVC_VLUT_VMAX_WOFFSET                   0x0
#define DVC_VLUT_VMAX_DEFAULT                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_VMAX_DEFAULT_MASK                      _MK_MASK_CONST(0x1f)
#define DVC_VLUT_VMAX_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_VMAX_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_1  
#define DVC_VLUT_1                      _MK_ADDR_CONST(0x104)
#define DVC_VLUT_1_SECURE                       0x0
#define DVC_VLUT_1_WORD_COUNT                   0x1
#define DVC_VLUT_1_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_1_RESET_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_1_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_1_READ_MASK                    _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_1_WRITE_MASK                   _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_1_PMCNT_SHIFT                  _MK_SHIFT_CONST(10)
#define DVC_VLUT_1_PMCNT_FIELD                  (_MK_MASK_CONST(0x3fff) << DVC_VLUT_1_PMCNT_SHIFT)
#define DVC_VLUT_1_PMCNT_RANGE                  23:10
#define DVC_VLUT_1_PMCNT_WOFFSET                        0x0
#define DVC_VLUT_1_PMCNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_1_PMCNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_1_PMCNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_1_PMCNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_1_VMIN_SHIFT                   _MK_SHIFT_CONST(5)
#define DVC_VLUT_1_VMIN_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_1_VMIN_SHIFT)
#define DVC_VLUT_1_VMIN_RANGE                   9:5
#define DVC_VLUT_1_VMIN_WOFFSET                 0x0
#define DVC_VLUT_1_VMIN_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_1_VMIN_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_1_VMIN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_1_VMIN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_1_VMAX_SHIFT                   _MK_SHIFT_CONST(0)
#define DVC_VLUT_1_VMAX_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_1_VMAX_SHIFT)
#define DVC_VLUT_1_VMAX_RANGE                   4:0
#define DVC_VLUT_1_VMAX_WOFFSET                 0x0
#define DVC_VLUT_1_VMAX_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_1_VMAX_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_1_VMAX_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_1_VMAX_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_2  
#define DVC_VLUT_2                      _MK_ADDR_CONST(0x108)
#define DVC_VLUT_2_SECURE                       0x0
#define DVC_VLUT_2_WORD_COUNT                   0x1
#define DVC_VLUT_2_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_2_RESET_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_2_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_2_READ_MASK                    _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_2_WRITE_MASK                   _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_2_PMCNT_SHIFT                  _MK_SHIFT_CONST(10)
#define DVC_VLUT_2_PMCNT_FIELD                  (_MK_MASK_CONST(0x3fff) << DVC_VLUT_2_PMCNT_SHIFT)
#define DVC_VLUT_2_PMCNT_RANGE                  23:10
#define DVC_VLUT_2_PMCNT_WOFFSET                        0x0
#define DVC_VLUT_2_PMCNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_2_PMCNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_2_PMCNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_2_PMCNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_2_VMIN_SHIFT                   _MK_SHIFT_CONST(5)
#define DVC_VLUT_2_VMIN_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_2_VMIN_SHIFT)
#define DVC_VLUT_2_VMIN_RANGE                   9:5
#define DVC_VLUT_2_VMIN_WOFFSET                 0x0
#define DVC_VLUT_2_VMIN_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_2_VMIN_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_2_VMIN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_2_VMIN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_2_VMAX_SHIFT                   _MK_SHIFT_CONST(0)
#define DVC_VLUT_2_VMAX_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_2_VMAX_SHIFT)
#define DVC_VLUT_2_VMAX_RANGE                   4:0
#define DVC_VLUT_2_VMAX_WOFFSET                 0x0
#define DVC_VLUT_2_VMAX_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_2_VMAX_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_2_VMAX_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_2_VMAX_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_3  
#define DVC_VLUT_3                      _MK_ADDR_CONST(0x10c)
#define DVC_VLUT_3_SECURE                       0x0
#define DVC_VLUT_3_WORD_COUNT                   0x1
#define DVC_VLUT_3_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_3_RESET_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_3_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_3_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_3_READ_MASK                    _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_3_WRITE_MASK                   _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_3_PMCNT_SHIFT                  _MK_SHIFT_CONST(10)
#define DVC_VLUT_3_PMCNT_FIELD                  (_MK_MASK_CONST(0x3fff) << DVC_VLUT_3_PMCNT_SHIFT)
#define DVC_VLUT_3_PMCNT_RANGE                  23:10
#define DVC_VLUT_3_PMCNT_WOFFSET                        0x0
#define DVC_VLUT_3_PMCNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_3_PMCNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_3_PMCNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_3_PMCNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_3_VMIN_SHIFT                   _MK_SHIFT_CONST(5)
#define DVC_VLUT_3_VMIN_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_3_VMIN_SHIFT)
#define DVC_VLUT_3_VMIN_RANGE                   9:5
#define DVC_VLUT_3_VMIN_WOFFSET                 0x0
#define DVC_VLUT_3_VMIN_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_3_VMIN_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_3_VMIN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_3_VMIN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_3_VMAX_SHIFT                   _MK_SHIFT_CONST(0)
#define DVC_VLUT_3_VMAX_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_3_VMAX_SHIFT)
#define DVC_VLUT_3_VMAX_RANGE                   4:0
#define DVC_VLUT_3_VMAX_WOFFSET                 0x0
#define DVC_VLUT_3_VMAX_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_3_VMAX_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_3_VMAX_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_3_VMAX_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_4  
#define DVC_VLUT_4                      _MK_ADDR_CONST(0x110)
#define DVC_VLUT_4_SECURE                       0x0
#define DVC_VLUT_4_WORD_COUNT                   0x1
#define DVC_VLUT_4_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_4_RESET_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_4_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_4_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_4_READ_MASK                    _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_4_WRITE_MASK                   _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_4_PMCNT_SHIFT                  _MK_SHIFT_CONST(10)
#define DVC_VLUT_4_PMCNT_FIELD                  (_MK_MASK_CONST(0x3fff) << DVC_VLUT_4_PMCNT_SHIFT)
#define DVC_VLUT_4_PMCNT_RANGE                  23:10
#define DVC_VLUT_4_PMCNT_WOFFSET                        0x0
#define DVC_VLUT_4_PMCNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_4_PMCNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_4_PMCNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_4_PMCNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_4_VMIN_SHIFT                   _MK_SHIFT_CONST(5)
#define DVC_VLUT_4_VMIN_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_4_VMIN_SHIFT)
#define DVC_VLUT_4_VMIN_RANGE                   9:5
#define DVC_VLUT_4_VMIN_WOFFSET                 0x0
#define DVC_VLUT_4_VMIN_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_4_VMIN_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_4_VMIN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_4_VMIN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_4_VMAX_SHIFT                   _MK_SHIFT_CONST(0)
#define DVC_VLUT_4_VMAX_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_4_VMAX_SHIFT)
#define DVC_VLUT_4_VMAX_RANGE                   4:0
#define DVC_VLUT_4_VMAX_WOFFSET                 0x0
#define DVC_VLUT_4_VMAX_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_4_VMAX_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_4_VMAX_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_4_VMAX_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_5  
#define DVC_VLUT_5                      _MK_ADDR_CONST(0x114)
#define DVC_VLUT_5_SECURE                       0x0
#define DVC_VLUT_5_WORD_COUNT                   0x1
#define DVC_VLUT_5_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_5_RESET_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_5_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_5_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_5_READ_MASK                    _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_5_WRITE_MASK                   _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_5_PMCNT_SHIFT                  _MK_SHIFT_CONST(10)
#define DVC_VLUT_5_PMCNT_FIELD                  (_MK_MASK_CONST(0x3fff) << DVC_VLUT_5_PMCNT_SHIFT)
#define DVC_VLUT_5_PMCNT_RANGE                  23:10
#define DVC_VLUT_5_PMCNT_WOFFSET                        0x0
#define DVC_VLUT_5_PMCNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_5_PMCNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_5_PMCNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_5_PMCNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_5_VMIN_SHIFT                   _MK_SHIFT_CONST(5)
#define DVC_VLUT_5_VMIN_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_5_VMIN_SHIFT)
#define DVC_VLUT_5_VMIN_RANGE                   9:5
#define DVC_VLUT_5_VMIN_WOFFSET                 0x0
#define DVC_VLUT_5_VMIN_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_5_VMIN_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_5_VMIN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_5_VMIN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_5_VMAX_SHIFT                   _MK_SHIFT_CONST(0)
#define DVC_VLUT_5_VMAX_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_5_VMAX_SHIFT)
#define DVC_VLUT_5_VMAX_RANGE                   4:0
#define DVC_VLUT_5_VMAX_WOFFSET                 0x0
#define DVC_VLUT_5_VMAX_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_5_VMAX_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_5_VMAX_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_5_VMAX_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_6  
#define DVC_VLUT_6                      _MK_ADDR_CONST(0x118)
#define DVC_VLUT_6_SECURE                       0x0
#define DVC_VLUT_6_WORD_COUNT                   0x1
#define DVC_VLUT_6_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_6_RESET_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_6_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_6_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_6_READ_MASK                    _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_6_WRITE_MASK                   _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_6_PMCNT_SHIFT                  _MK_SHIFT_CONST(10)
#define DVC_VLUT_6_PMCNT_FIELD                  (_MK_MASK_CONST(0x3fff) << DVC_VLUT_6_PMCNT_SHIFT)
#define DVC_VLUT_6_PMCNT_RANGE                  23:10
#define DVC_VLUT_6_PMCNT_WOFFSET                        0x0
#define DVC_VLUT_6_PMCNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_6_PMCNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_6_PMCNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_6_PMCNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_6_VMIN_SHIFT                   _MK_SHIFT_CONST(5)
#define DVC_VLUT_6_VMIN_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_6_VMIN_SHIFT)
#define DVC_VLUT_6_VMIN_RANGE                   9:5
#define DVC_VLUT_6_VMIN_WOFFSET                 0x0
#define DVC_VLUT_6_VMIN_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_6_VMIN_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_6_VMIN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_6_VMIN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_6_VMAX_SHIFT                   _MK_SHIFT_CONST(0)
#define DVC_VLUT_6_VMAX_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_6_VMAX_SHIFT)
#define DVC_VLUT_6_VMAX_RANGE                   4:0
#define DVC_VLUT_6_VMAX_WOFFSET                 0x0
#define DVC_VLUT_6_VMAX_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_6_VMAX_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_6_VMAX_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_6_VMAX_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_7  
#define DVC_VLUT_7                      _MK_ADDR_CONST(0x11c)
#define DVC_VLUT_7_SECURE                       0x0
#define DVC_VLUT_7_WORD_COUNT                   0x1
#define DVC_VLUT_7_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_7_RESET_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_7_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_7_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_7_READ_MASK                    _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_7_WRITE_MASK                   _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_7_PMCNT_SHIFT                  _MK_SHIFT_CONST(10)
#define DVC_VLUT_7_PMCNT_FIELD                  (_MK_MASK_CONST(0x3fff) << DVC_VLUT_7_PMCNT_SHIFT)
#define DVC_VLUT_7_PMCNT_RANGE                  23:10
#define DVC_VLUT_7_PMCNT_WOFFSET                        0x0
#define DVC_VLUT_7_PMCNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_7_PMCNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_7_PMCNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_7_PMCNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_7_VMIN_SHIFT                   _MK_SHIFT_CONST(5)
#define DVC_VLUT_7_VMIN_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_7_VMIN_SHIFT)
#define DVC_VLUT_7_VMIN_RANGE                   9:5
#define DVC_VLUT_7_VMIN_WOFFSET                 0x0
#define DVC_VLUT_7_VMIN_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_7_VMIN_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_7_VMIN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_7_VMIN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_7_VMAX_SHIFT                   _MK_SHIFT_CONST(0)
#define DVC_VLUT_7_VMAX_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_7_VMAX_SHIFT)
#define DVC_VLUT_7_VMAX_RANGE                   4:0
#define DVC_VLUT_7_VMAX_WOFFSET                 0x0
#define DVC_VLUT_7_VMAX_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_7_VMAX_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_7_VMAX_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_7_VMAX_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_8  
#define DVC_VLUT_8                      _MK_ADDR_CONST(0x120)
#define DVC_VLUT_8_SECURE                       0x0
#define DVC_VLUT_8_WORD_COUNT                   0x1
#define DVC_VLUT_8_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_8_RESET_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_8_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_8_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_8_READ_MASK                    _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_8_WRITE_MASK                   _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_8_PMCNT_SHIFT                  _MK_SHIFT_CONST(10)
#define DVC_VLUT_8_PMCNT_FIELD                  (_MK_MASK_CONST(0x3fff) << DVC_VLUT_8_PMCNT_SHIFT)
#define DVC_VLUT_8_PMCNT_RANGE                  23:10
#define DVC_VLUT_8_PMCNT_WOFFSET                        0x0
#define DVC_VLUT_8_PMCNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_8_PMCNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_8_PMCNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_8_PMCNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_8_VMIN_SHIFT                   _MK_SHIFT_CONST(5)
#define DVC_VLUT_8_VMIN_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_8_VMIN_SHIFT)
#define DVC_VLUT_8_VMIN_RANGE                   9:5
#define DVC_VLUT_8_VMIN_WOFFSET                 0x0
#define DVC_VLUT_8_VMIN_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_8_VMIN_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_8_VMIN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_8_VMIN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_8_VMAX_SHIFT                   _MK_SHIFT_CONST(0)
#define DVC_VLUT_8_VMAX_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_8_VMAX_SHIFT)
#define DVC_VLUT_8_VMAX_RANGE                   4:0
#define DVC_VLUT_8_VMAX_WOFFSET                 0x0
#define DVC_VLUT_8_VMAX_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_8_VMAX_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_8_VMAX_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_8_VMAX_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_9  
#define DVC_VLUT_9                      _MK_ADDR_CONST(0x124)
#define DVC_VLUT_9_SECURE                       0x0
#define DVC_VLUT_9_WORD_COUNT                   0x1
#define DVC_VLUT_9_RESET_VAL                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_9_RESET_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_9_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_9_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_9_READ_MASK                    _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_9_WRITE_MASK                   _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_9_PMCNT_SHIFT                  _MK_SHIFT_CONST(10)
#define DVC_VLUT_9_PMCNT_FIELD                  (_MK_MASK_CONST(0x3fff) << DVC_VLUT_9_PMCNT_SHIFT)
#define DVC_VLUT_9_PMCNT_RANGE                  23:10
#define DVC_VLUT_9_PMCNT_WOFFSET                        0x0
#define DVC_VLUT_9_PMCNT_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_9_PMCNT_DEFAULT_MASK                   _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_9_PMCNT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_9_PMCNT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_9_VMIN_SHIFT                   _MK_SHIFT_CONST(5)
#define DVC_VLUT_9_VMIN_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_9_VMIN_SHIFT)
#define DVC_VLUT_9_VMIN_RANGE                   9:5
#define DVC_VLUT_9_VMIN_WOFFSET                 0x0
#define DVC_VLUT_9_VMIN_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_9_VMIN_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_9_VMIN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_9_VMIN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_9_VMAX_SHIFT                   _MK_SHIFT_CONST(0)
#define DVC_VLUT_9_VMAX_FIELD                   (_MK_MASK_CONST(0x1f) << DVC_VLUT_9_VMAX_SHIFT)
#define DVC_VLUT_9_VMAX_RANGE                   4:0
#define DVC_VLUT_9_VMAX_WOFFSET                 0x0
#define DVC_VLUT_9_VMAX_DEFAULT                 _MK_MASK_CONST(0x0)
#define DVC_VLUT_9_VMAX_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define DVC_VLUT_9_VMAX_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_9_VMAX_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_10  
#define DVC_VLUT_10                     _MK_ADDR_CONST(0x128)
#define DVC_VLUT_10_SECURE                      0x0
#define DVC_VLUT_10_WORD_COUNT                  0x1
#define DVC_VLUT_10_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_10_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_10_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_10_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_10_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_10_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_10_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_10_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_10_PMCNT_SHIFT)
#define DVC_VLUT_10_PMCNT_RANGE                 23:10
#define DVC_VLUT_10_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_10_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_10_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_10_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_10_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_10_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_10_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_10_VMIN_SHIFT)
#define DVC_VLUT_10_VMIN_RANGE                  9:5
#define DVC_VLUT_10_VMIN_WOFFSET                        0x0
#define DVC_VLUT_10_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_10_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_10_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_10_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_10_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_10_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_10_VMAX_SHIFT)
#define DVC_VLUT_10_VMAX_RANGE                  4:0
#define DVC_VLUT_10_VMAX_WOFFSET                        0x0
#define DVC_VLUT_10_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_10_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_10_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_10_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_11  
#define DVC_VLUT_11                     _MK_ADDR_CONST(0x12c)
#define DVC_VLUT_11_SECURE                      0x0
#define DVC_VLUT_11_WORD_COUNT                  0x1
#define DVC_VLUT_11_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_11_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_11_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_11_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_11_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_11_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_11_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_11_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_11_PMCNT_SHIFT)
#define DVC_VLUT_11_PMCNT_RANGE                 23:10
#define DVC_VLUT_11_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_11_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_11_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_11_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_11_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_11_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_11_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_11_VMIN_SHIFT)
#define DVC_VLUT_11_VMIN_RANGE                  9:5
#define DVC_VLUT_11_VMIN_WOFFSET                        0x0
#define DVC_VLUT_11_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_11_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_11_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_11_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_11_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_11_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_11_VMAX_SHIFT)
#define DVC_VLUT_11_VMAX_RANGE                  4:0
#define DVC_VLUT_11_VMAX_WOFFSET                        0x0
#define DVC_VLUT_11_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_11_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_11_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_11_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_12  
#define DVC_VLUT_12                     _MK_ADDR_CONST(0x130)
#define DVC_VLUT_12_SECURE                      0x0
#define DVC_VLUT_12_WORD_COUNT                  0x1
#define DVC_VLUT_12_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_12_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_12_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_12_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_12_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_12_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_12_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_12_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_12_PMCNT_SHIFT)
#define DVC_VLUT_12_PMCNT_RANGE                 23:10
#define DVC_VLUT_12_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_12_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_12_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_12_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_12_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_12_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_12_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_12_VMIN_SHIFT)
#define DVC_VLUT_12_VMIN_RANGE                  9:5
#define DVC_VLUT_12_VMIN_WOFFSET                        0x0
#define DVC_VLUT_12_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_12_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_12_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_12_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_12_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_12_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_12_VMAX_SHIFT)
#define DVC_VLUT_12_VMAX_RANGE                  4:0
#define DVC_VLUT_12_VMAX_WOFFSET                        0x0
#define DVC_VLUT_12_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_12_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_12_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_12_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_13  
#define DVC_VLUT_13                     _MK_ADDR_CONST(0x134)
#define DVC_VLUT_13_SECURE                      0x0
#define DVC_VLUT_13_WORD_COUNT                  0x1
#define DVC_VLUT_13_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_13_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_13_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_13_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_13_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_13_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_13_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_13_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_13_PMCNT_SHIFT)
#define DVC_VLUT_13_PMCNT_RANGE                 23:10
#define DVC_VLUT_13_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_13_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_13_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_13_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_13_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_13_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_13_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_13_VMIN_SHIFT)
#define DVC_VLUT_13_VMIN_RANGE                  9:5
#define DVC_VLUT_13_VMIN_WOFFSET                        0x0
#define DVC_VLUT_13_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_13_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_13_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_13_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_13_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_13_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_13_VMAX_SHIFT)
#define DVC_VLUT_13_VMAX_RANGE                  4:0
#define DVC_VLUT_13_VMAX_WOFFSET                        0x0
#define DVC_VLUT_13_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_13_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_13_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_13_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_14  
#define DVC_VLUT_14                     _MK_ADDR_CONST(0x138)
#define DVC_VLUT_14_SECURE                      0x0
#define DVC_VLUT_14_WORD_COUNT                  0x1
#define DVC_VLUT_14_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_14_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_14_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_14_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_14_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_14_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_14_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_14_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_14_PMCNT_SHIFT)
#define DVC_VLUT_14_PMCNT_RANGE                 23:10
#define DVC_VLUT_14_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_14_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_14_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_14_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_14_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_14_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_14_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_14_VMIN_SHIFT)
#define DVC_VLUT_14_VMIN_RANGE                  9:5
#define DVC_VLUT_14_VMIN_WOFFSET                        0x0
#define DVC_VLUT_14_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_14_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_14_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_14_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_14_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_14_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_14_VMAX_SHIFT)
#define DVC_VLUT_14_VMAX_RANGE                  4:0
#define DVC_VLUT_14_VMAX_WOFFSET                        0x0
#define DVC_VLUT_14_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_14_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_14_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_14_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_15  
#define DVC_VLUT_15                     _MK_ADDR_CONST(0x13c)
#define DVC_VLUT_15_SECURE                      0x0
#define DVC_VLUT_15_WORD_COUNT                  0x1
#define DVC_VLUT_15_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_15_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_15_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_15_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_15_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_15_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_15_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_15_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_15_PMCNT_SHIFT)
#define DVC_VLUT_15_PMCNT_RANGE                 23:10
#define DVC_VLUT_15_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_15_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_15_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_15_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_15_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_15_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_15_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_15_VMIN_SHIFT)
#define DVC_VLUT_15_VMIN_RANGE                  9:5
#define DVC_VLUT_15_VMIN_WOFFSET                        0x0
#define DVC_VLUT_15_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_15_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_15_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_15_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_15_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_15_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_15_VMAX_SHIFT)
#define DVC_VLUT_15_VMAX_RANGE                  4:0
#define DVC_VLUT_15_VMAX_WOFFSET                        0x0
#define DVC_VLUT_15_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_15_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_15_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_15_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_16  
#define DVC_VLUT_16                     _MK_ADDR_CONST(0x140)
#define DVC_VLUT_16_SECURE                      0x0
#define DVC_VLUT_16_WORD_COUNT                  0x1
#define DVC_VLUT_16_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_16_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_16_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_16_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_16_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_16_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_16_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_16_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_16_PMCNT_SHIFT)
#define DVC_VLUT_16_PMCNT_RANGE                 23:10
#define DVC_VLUT_16_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_16_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_16_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_16_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_16_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_16_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_16_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_16_VMIN_SHIFT)
#define DVC_VLUT_16_VMIN_RANGE                  9:5
#define DVC_VLUT_16_VMIN_WOFFSET                        0x0
#define DVC_VLUT_16_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_16_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_16_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_16_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_16_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_16_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_16_VMAX_SHIFT)
#define DVC_VLUT_16_VMAX_RANGE                  4:0
#define DVC_VLUT_16_VMAX_WOFFSET                        0x0
#define DVC_VLUT_16_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_16_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_16_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_16_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_17  
#define DVC_VLUT_17                     _MK_ADDR_CONST(0x144)
#define DVC_VLUT_17_SECURE                      0x0
#define DVC_VLUT_17_WORD_COUNT                  0x1
#define DVC_VLUT_17_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_17_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_17_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_17_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_17_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_17_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_17_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_17_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_17_PMCNT_SHIFT)
#define DVC_VLUT_17_PMCNT_RANGE                 23:10
#define DVC_VLUT_17_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_17_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_17_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_17_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_17_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_17_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_17_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_17_VMIN_SHIFT)
#define DVC_VLUT_17_VMIN_RANGE                  9:5
#define DVC_VLUT_17_VMIN_WOFFSET                        0x0
#define DVC_VLUT_17_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_17_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_17_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_17_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_17_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_17_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_17_VMAX_SHIFT)
#define DVC_VLUT_17_VMAX_RANGE                  4:0
#define DVC_VLUT_17_VMAX_WOFFSET                        0x0
#define DVC_VLUT_17_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_17_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_17_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_17_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_18  
#define DVC_VLUT_18                     _MK_ADDR_CONST(0x148)
#define DVC_VLUT_18_SECURE                      0x0
#define DVC_VLUT_18_WORD_COUNT                  0x1
#define DVC_VLUT_18_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_18_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_18_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_18_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_18_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_18_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_18_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_18_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_18_PMCNT_SHIFT)
#define DVC_VLUT_18_PMCNT_RANGE                 23:10
#define DVC_VLUT_18_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_18_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_18_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_18_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_18_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_18_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_18_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_18_VMIN_SHIFT)
#define DVC_VLUT_18_VMIN_RANGE                  9:5
#define DVC_VLUT_18_VMIN_WOFFSET                        0x0
#define DVC_VLUT_18_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_18_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_18_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_18_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_18_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_18_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_18_VMAX_SHIFT)
#define DVC_VLUT_18_VMAX_RANGE                  4:0
#define DVC_VLUT_18_VMAX_WOFFSET                        0x0
#define DVC_VLUT_18_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_18_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_18_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_18_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_19  
#define DVC_VLUT_19                     _MK_ADDR_CONST(0x14c)
#define DVC_VLUT_19_SECURE                      0x0
#define DVC_VLUT_19_WORD_COUNT                  0x1
#define DVC_VLUT_19_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_19_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_19_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_19_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_19_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_19_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_19_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_19_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_19_PMCNT_SHIFT)
#define DVC_VLUT_19_PMCNT_RANGE                 23:10
#define DVC_VLUT_19_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_19_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_19_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_19_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_19_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_19_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_19_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_19_VMIN_SHIFT)
#define DVC_VLUT_19_VMIN_RANGE                  9:5
#define DVC_VLUT_19_VMIN_WOFFSET                        0x0
#define DVC_VLUT_19_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_19_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_19_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_19_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_19_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_19_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_19_VMAX_SHIFT)
#define DVC_VLUT_19_VMAX_RANGE                  4:0
#define DVC_VLUT_19_VMAX_WOFFSET                        0x0
#define DVC_VLUT_19_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_19_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_19_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_19_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_20  
#define DVC_VLUT_20                     _MK_ADDR_CONST(0x150)
#define DVC_VLUT_20_SECURE                      0x0
#define DVC_VLUT_20_WORD_COUNT                  0x1
#define DVC_VLUT_20_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_20_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_20_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_20_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_20_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_20_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_20_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_20_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_20_PMCNT_SHIFT)
#define DVC_VLUT_20_PMCNT_RANGE                 23:10
#define DVC_VLUT_20_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_20_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_20_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_20_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_20_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_20_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_20_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_20_VMIN_SHIFT)
#define DVC_VLUT_20_VMIN_RANGE                  9:5
#define DVC_VLUT_20_VMIN_WOFFSET                        0x0
#define DVC_VLUT_20_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_20_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_20_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_20_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_20_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_20_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_20_VMAX_SHIFT)
#define DVC_VLUT_20_VMAX_RANGE                  4:0
#define DVC_VLUT_20_VMAX_WOFFSET                        0x0
#define DVC_VLUT_20_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_20_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_20_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_20_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_21  
#define DVC_VLUT_21                     _MK_ADDR_CONST(0x154)
#define DVC_VLUT_21_SECURE                      0x0
#define DVC_VLUT_21_WORD_COUNT                  0x1
#define DVC_VLUT_21_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_21_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_21_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_21_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_21_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_21_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_21_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_21_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_21_PMCNT_SHIFT)
#define DVC_VLUT_21_PMCNT_RANGE                 23:10
#define DVC_VLUT_21_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_21_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_21_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_21_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_21_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_21_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_21_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_21_VMIN_SHIFT)
#define DVC_VLUT_21_VMIN_RANGE                  9:5
#define DVC_VLUT_21_VMIN_WOFFSET                        0x0
#define DVC_VLUT_21_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_21_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_21_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_21_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_21_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_21_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_21_VMAX_SHIFT)
#define DVC_VLUT_21_VMAX_RANGE                  4:0
#define DVC_VLUT_21_VMAX_WOFFSET                        0x0
#define DVC_VLUT_21_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_21_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_21_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_21_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_22  
#define DVC_VLUT_22                     _MK_ADDR_CONST(0x158)
#define DVC_VLUT_22_SECURE                      0x0
#define DVC_VLUT_22_WORD_COUNT                  0x1
#define DVC_VLUT_22_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_22_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_22_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_22_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_22_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_22_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_22_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_22_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_22_PMCNT_SHIFT)
#define DVC_VLUT_22_PMCNT_RANGE                 23:10
#define DVC_VLUT_22_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_22_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_22_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_22_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_22_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_22_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_22_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_22_VMIN_SHIFT)
#define DVC_VLUT_22_VMIN_RANGE                  9:5
#define DVC_VLUT_22_VMIN_WOFFSET                        0x0
#define DVC_VLUT_22_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_22_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_22_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_22_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_22_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_22_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_22_VMAX_SHIFT)
#define DVC_VLUT_22_VMAX_RANGE                  4:0
#define DVC_VLUT_22_VMAX_WOFFSET                        0x0
#define DVC_VLUT_22_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_22_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_22_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_22_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_23  
#define DVC_VLUT_23                     _MK_ADDR_CONST(0x15c)
#define DVC_VLUT_23_SECURE                      0x0
#define DVC_VLUT_23_WORD_COUNT                  0x1
#define DVC_VLUT_23_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_23_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_23_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_23_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_23_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_23_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_23_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_23_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_23_PMCNT_SHIFT)
#define DVC_VLUT_23_PMCNT_RANGE                 23:10
#define DVC_VLUT_23_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_23_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_23_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_23_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_23_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_23_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_23_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_23_VMIN_SHIFT)
#define DVC_VLUT_23_VMIN_RANGE                  9:5
#define DVC_VLUT_23_VMIN_WOFFSET                        0x0
#define DVC_VLUT_23_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_23_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_23_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_23_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_23_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_23_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_23_VMAX_SHIFT)
#define DVC_VLUT_23_VMAX_RANGE                  4:0
#define DVC_VLUT_23_VMAX_WOFFSET                        0x0
#define DVC_VLUT_23_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_23_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_23_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_23_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_24  
#define DVC_VLUT_24                     _MK_ADDR_CONST(0x160)
#define DVC_VLUT_24_SECURE                      0x0
#define DVC_VLUT_24_WORD_COUNT                  0x1
#define DVC_VLUT_24_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_24_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_24_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_24_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_24_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_24_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_24_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_24_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_24_PMCNT_SHIFT)
#define DVC_VLUT_24_PMCNT_RANGE                 23:10
#define DVC_VLUT_24_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_24_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_24_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_24_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_24_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_24_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_24_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_24_VMIN_SHIFT)
#define DVC_VLUT_24_VMIN_RANGE                  9:5
#define DVC_VLUT_24_VMIN_WOFFSET                        0x0
#define DVC_VLUT_24_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_24_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_24_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_24_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_24_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_24_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_24_VMAX_SHIFT)
#define DVC_VLUT_24_VMAX_RANGE                  4:0
#define DVC_VLUT_24_VMAX_WOFFSET                        0x0
#define DVC_VLUT_24_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_24_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_24_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_24_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_25  
#define DVC_VLUT_25                     _MK_ADDR_CONST(0x164)
#define DVC_VLUT_25_SECURE                      0x0
#define DVC_VLUT_25_WORD_COUNT                  0x1
#define DVC_VLUT_25_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_25_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_25_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_25_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_25_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_25_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_25_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_25_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_25_PMCNT_SHIFT)
#define DVC_VLUT_25_PMCNT_RANGE                 23:10
#define DVC_VLUT_25_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_25_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_25_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_25_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_25_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_25_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_25_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_25_VMIN_SHIFT)
#define DVC_VLUT_25_VMIN_RANGE                  9:5
#define DVC_VLUT_25_VMIN_WOFFSET                        0x0
#define DVC_VLUT_25_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_25_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_25_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_25_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_25_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_25_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_25_VMAX_SHIFT)
#define DVC_VLUT_25_VMAX_RANGE                  4:0
#define DVC_VLUT_25_VMAX_WOFFSET                        0x0
#define DVC_VLUT_25_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_25_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_25_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_25_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_26  
#define DVC_VLUT_26                     _MK_ADDR_CONST(0x168)
#define DVC_VLUT_26_SECURE                      0x0
#define DVC_VLUT_26_WORD_COUNT                  0x1
#define DVC_VLUT_26_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_26_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_26_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_26_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_26_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_26_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_26_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_26_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_26_PMCNT_SHIFT)
#define DVC_VLUT_26_PMCNT_RANGE                 23:10
#define DVC_VLUT_26_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_26_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_26_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_26_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_26_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_26_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_26_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_26_VMIN_SHIFT)
#define DVC_VLUT_26_VMIN_RANGE                  9:5
#define DVC_VLUT_26_VMIN_WOFFSET                        0x0
#define DVC_VLUT_26_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_26_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_26_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_26_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_26_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_26_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_26_VMAX_SHIFT)
#define DVC_VLUT_26_VMAX_RANGE                  4:0
#define DVC_VLUT_26_VMAX_WOFFSET                        0x0
#define DVC_VLUT_26_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_26_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_26_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_26_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_27  
#define DVC_VLUT_27                     _MK_ADDR_CONST(0x16c)
#define DVC_VLUT_27_SECURE                      0x0
#define DVC_VLUT_27_WORD_COUNT                  0x1
#define DVC_VLUT_27_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_27_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_27_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_27_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_27_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_27_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_27_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_27_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_27_PMCNT_SHIFT)
#define DVC_VLUT_27_PMCNT_RANGE                 23:10
#define DVC_VLUT_27_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_27_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_27_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_27_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_27_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_27_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_27_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_27_VMIN_SHIFT)
#define DVC_VLUT_27_VMIN_RANGE                  9:5
#define DVC_VLUT_27_VMIN_WOFFSET                        0x0
#define DVC_VLUT_27_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_27_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_27_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_27_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_27_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_27_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_27_VMAX_SHIFT)
#define DVC_VLUT_27_VMAX_RANGE                  4:0
#define DVC_VLUT_27_VMAX_WOFFSET                        0x0
#define DVC_VLUT_27_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_27_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_27_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_27_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_28  
#define DVC_VLUT_28                     _MK_ADDR_CONST(0x170)
#define DVC_VLUT_28_SECURE                      0x0
#define DVC_VLUT_28_WORD_COUNT                  0x1
#define DVC_VLUT_28_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_28_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_28_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_28_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_28_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_28_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_28_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_28_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_28_PMCNT_SHIFT)
#define DVC_VLUT_28_PMCNT_RANGE                 23:10
#define DVC_VLUT_28_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_28_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_28_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_28_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_28_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_28_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_28_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_28_VMIN_SHIFT)
#define DVC_VLUT_28_VMIN_RANGE                  9:5
#define DVC_VLUT_28_VMIN_WOFFSET                        0x0
#define DVC_VLUT_28_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_28_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_28_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_28_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_28_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_28_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_28_VMAX_SHIFT)
#define DVC_VLUT_28_VMAX_RANGE                  4:0
#define DVC_VLUT_28_VMAX_WOFFSET                        0x0
#define DVC_VLUT_28_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_28_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_28_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_28_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_29  
#define DVC_VLUT_29                     _MK_ADDR_CONST(0x174)
#define DVC_VLUT_29_SECURE                      0x0
#define DVC_VLUT_29_WORD_COUNT                  0x1
#define DVC_VLUT_29_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_29_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_29_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_29_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_29_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_29_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_29_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_29_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_29_PMCNT_SHIFT)
#define DVC_VLUT_29_PMCNT_RANGE                 23:10
#define DVC_VLUT_29_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_29_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_29_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_29_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_29_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_29_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_29_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_29_VMIN_SHIFT)
#define DVC_VLUT_29_VMIN_RANGE                  9:5
#define DVC_VLUT_29_VMIN_WOFFSET                        0x0
#define DVC_VLUT_29_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_29_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_29_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_29_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_29_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_29_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_29_VMAX_SHIFT)
#define DVC_VLUT_29_VMAX_RANGE                  4:0
#define DVC_VLUT_29_VMAX_WOFFSET                        0x0
#define DVC_VLUT_29_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_29_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_29_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_29_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_30  
#define DVC_VLUT_30                     _MK_ADDR_CONST(0x178)
#define DVC_VLUT_30_SECURE                      0x0
#define DVC_VLUT_30_WORD_COUNT                  0x1
#define DVC_VLUT_30_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_30_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_30_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_30_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_30_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_30_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_30_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_30_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_30_PMCNT_SHIFT)
#define DVC_VLUT_30_PMCNT_RANGE                 23:10
#define DVC_VLUT_30_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_30_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_30_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_30_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_30_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_30_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_30_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_30_VMIN_SHIFT)
#define DVC_VLUT_30_VMIN_RANGE                  9:5
#define DVC_VLUT_30_VMIN_WOFFSET                        0x0
#define DVC_VLUT_30_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_30_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_30_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_30_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_30_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_30_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_30_VMAX_SHIFT)
#define DVC_VLUT_30_VMAX_RANGE                  4:0
#define DVC_VLUT_30_VMAX_WOFFSET                        0x0
#define DVC_VLUT_30_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_30_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_30_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_30_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_31  
#define DVC_VLUT_31                     _MK_ADDR_CONST(0x17c)
#define DVC_VLUT_31_SECURE                      0x0
#define DVC_VLUT_31_WORD_COUNT                  0x1
#define DVC_VLUT_31_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_31_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_31_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_31_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_31_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_31_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_31_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_31_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_31_PMCNT_SHIFT)
#define DVC_VLUT_31_PMCNT_RANGE                 23:10
#define DVC_VLUT_31_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_31_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_31_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_31_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_31_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_31_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_31_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_31_VMIN_SHIFT)
#define DVC_VLUT_31_VMIN_RANGE                  9:5
#define DVC_VLUT_31_VMIN_WOFFSET                        0x0
#define DVC_VLUT_31_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_31_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_31_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_31_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_31_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_31_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_31_VMAX_SHIFT)
#define DVC_VLUT_31_VMAX_RANGE                  4:0
#define DVC_VLUT_31_VMAX_WOFFSET                        0x0
#define DVC_VLUT_31_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_31_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_31_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_31_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_32  
#define DVC_VLUT_32                     _MK_ADDR_CONST(0x180)
#define DVC_VLUT_32_SECURE                      0x0
#define DVC_VLUT_32_WORD_COUNT                  0x1
#define DVC_VLUT_32_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_32_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_32_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_32_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_32_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_32_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_32_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_32_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_32_PMCNT_SHIFT)
#define DVC_VLUT_32_PMCNT_RANGE                 23:10
#define DVC_VLUT_32_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_32_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_32_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_32_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_32_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_32_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_32_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_32_VMIN_SHIFT)
#define DVC_VLUT_32_VMIN_RANGE                  9:5
#define DVC_VLUT_32_VMIN_WOFFSET                        0x0
#define DVC_VLUT_32_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_32_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_32_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_32_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_32_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_32_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_32_VMAX_SHIFT)
#define DVC_VLUT_32_VMAX_RANGE                  4:0
#define DVC_VLUT_32_VMAX_WOFFSET                        0x0
#define DVC_VLUT_32_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_32_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_32_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_32_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_33  
#define DVC_VLUT_33                     _MK_ADDR_CONST(0x184)
#define DVC_VLUT_33_SECURE                      0x0
#define DVC_VLUT_33_WORD_COUNT                  0x1
#define DVC_VLUT_33_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_33_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_33_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_33_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_33_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_33_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_33_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_33_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_33_PMCNT_SHIFT)
#define DVC_VLUT_33_PMCNT_RANGE                 23:10
#define DVC_VLUT_33_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_33_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_33_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_33_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_33_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_33_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_33_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_33_VMIN_SHIFT)
#define DVC_VLUT_33_VMIN_RANGE                  9:5
#define DVC_VLUT_33_VMIN_WOFFSET                        0x0
#define DVC_VLUT_33_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_33_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_33_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_33_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_33_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_33_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_33_VMAX_SHIFT)
#define DVC_VLUT_33_VMAX_RANGE                  4:0
#define DVC_VLUT_33_VMAX_WOFFSET                        0x0
#define DVC_VLUT_33_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_33_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_33_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_33_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_34  
#define DVC_VLUT_34                     _MK_ADDR_CONST(0x188)
#define DVC_VLUT_34_SECURE                      0x0
#define DVC_VLUT_34_WORD_COUNT                  0x1
#define DVC_VLUT_34_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_34_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_34_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_34_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_34_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_34_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_34_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_34_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_34_PMCNT_SHIFT)
#define DVC_VLUT_34_PMCNT_RANGE                 23:10
#define DVC_VLUT_34_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_34_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_34_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_34_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_34_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_34_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_34_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_34_VMIN_SHIFT)
#define DVC_VLUT_34_VMIN_RANGE                  9:5
#define DVC_VLUT_34_VMIN_WOFFSET                        0x0
#define DVC_VLUT_34_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_34_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_34_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_34_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_34_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_34_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_34_VMAX_SHIFT)
#define DVC_VLUT_34_VMAX_RANGE                  4:0
#define DVC_VLUT_34_VMAX_WOFFSET                        0x0
#define DVC_VLUT_34_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_34_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_34_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_34_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_35  
#define DVC_VLUT_35                     _MK_ADDR_CONST(0x18c)
#define DVC_VLUT_35_SECURE                      0x0
#define DVC_VLUT_35_WORD_COUNT                  0x1
#define DVC_VLUT_35_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_35_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_35_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_35_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_35_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_35_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_35_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_35_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_35_PMCNT_SHIFT)
#define DVC_VLUT_35_PMCNT_RANGE                 23:10
#define DVC_VLUT_35_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_35_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_35_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_35_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_35_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_35_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_35_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_35_VMIN_SHIFT)
#define DVC_VLUT_35_VMIN_RANGE                  9:5
#define DVC_VLUT_35_VMIN_WOFFSET                        0x0
#define DVC_VLUT_35_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_35_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_35_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_35_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_35_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_35_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_35_VMAX_SHIFT)
#define DVC_VLUT_35_VMAX_RANGE                  4:0
#define DVC_VLUT_35_VMAX_WOFFSET                        0x0
#define DVC_VLUT_35_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_35_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_35_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_35_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_36  
#define DVC_VLUT_36                     _MK_ADDR_CONST(0x190)
#define DVC_VLUT_36_SECURE                      0x0
#define DVC_VLUT_36_WORD_COUNT                  0x1
#define DVC_VLUT_36_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_36_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_36_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_36_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_36_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_36_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_36_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_36_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_36_PMCNT_SHIFT)
#define DVC_VLUT_36_PMCNT_RANGE                 23:10
#define DVC_VLUT_36_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_36_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_36_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_36_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_36_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_36_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_36_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_36_VMIN_SHIFT)
#define DVC_VLUT_36_VMIN_RANGE                  9:5
#define DVC_VLUT_36_VMIN_WOFFSET                        0x0
#define DVC_VLUT_36_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_36_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_36_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_36_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_36_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_36_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_36_VMAX_SHIFT)
#define DVC_VLUT_36_VMAX_RANGE                  4:0
#define DVC_VLUT_36_VMAX_WOFFSET                        0x0
#define DVC_VLUT_36_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_36_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_36_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_36_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_37  
#define DVC_VLUT_37                     _MK_ADDR_CONST(0x194)
#define DVC_VLUT_37_SECURE                      0x0
#define DVC_VLUT_37_WORD_COUNT                  0x1
#define DVC_VLUT_37_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_37_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_37_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_37_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_37_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_37_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_37_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_37_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_37_PMCNT_SHIFT)
#define DVC_VLUT_37_PMCNT_RANGE                 23:10
#define DVC_VLUT_37_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_37_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_37_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_37_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_37_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_37_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_37_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_37_VMIN_SHIFT)
#define DVC_VLUT_37_VMIN_RANGE                  9:5
#define DVC_VLUT_37_VMIN_WOFFSET                        0x0
#define DVC_VLUT_37_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_37_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_37_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_37_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_37_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_37_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_37_VMAX_SHIFT)
#define DVC_VLUT_37_VMAX_RANGE                  4:0
#define DVC_VLUT_37_VMAX_WOFFSET                        0x0
#define DVC_VLUT_37_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_37_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_37_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_37_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_38  
#define DVC_VLUT_38                     _MK_ADDR_CONST(0x198)
#define DVC_VLUT_38_SECURE                      0x0
#define DVC_VLUT_38_WORD_COUNT                  0x1
#define DVC_VLUT_38_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_38_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_38_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_38_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_38_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_38_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_38_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_38_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_38_PMCNT_SHIFT)
#define DVC_VLUT_38_PMCNT_RANGE                 23:10
#define DVC_VLUT_38_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_38_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_38_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_38_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_38_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_38_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_38_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_38_VMIN_SHIFT)
#define DVC_VLUT_38_VMIN_RANGE                  9:5
#define DVC_VLUT_38_VMIN_WOFFSET                        0x0
#define DVC_VLUT_38_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_38_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_38_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_38_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_38_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_38_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_38_VMAX_SHIFT)
#define DVC_VLUT_38_VMAX_RANGE                  4:0
#define DVC_VLUT_38_VMAX_WOFFSET                        0x0
#define DVC_VLUT_38_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_38_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_38_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_38_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_39  
#define DVC_VLUT_39                     _MK_ADDR_CONST(0x19c)
#define DVC_VLUT_39_SECURE                      0x0
#define DVC_VLUT_39_WORD_COUNT                  0x1
#define DVC_VLUT_39_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_39_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_39_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_39_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_39_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_39_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_39_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_39_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_39_PMCNT_SHIFT)
#define DVC_VLUT_39_PMCNT_RANGE                 23:10
#define DVC_VLUT_39_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_39_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_39_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_39_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_39_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_39_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_39_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_39_VMIN_SHIFT)
#define DVC_VLUT_39_VMIN_RANGE                  9:5
#define DVC_VLUT_39_VMIN_WOFFSET                        0x0
#define DVC_VLUT_39_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_39_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_39_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_39_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_39_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_39_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_39_VMAX_SHIFT)
#define DVC_VLUT_39_VMAX_RANGE                  4:0
#define DVC_VLUT_39_VMAX_WOFFSET                        0x0
#define DVC_VLUT_39_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_39_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_39_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_39_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_40  
#define DVC_VLUT_40                     _MK_ADDR_CONST(0x1a0)
#define DVC_VLUT_40_SECURE                      0x0
#define DVC_VLUT_40_WORD_COUNT                  0x1
#define DVC_VLUT_40_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_40_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_40_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_40_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_40_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_40_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_40_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_40_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_40_PMCNT_SHIFT)
#define DVC_VLUT_40_PMCNT_RANGE                 23:10
#define DVC_VLUT_40_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_40_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_40_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_40_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_40_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_40_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_40_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_40_VMIN_SHIFT)
#define DVC_VLUT_40_VMIN_RANGE                  9:5
#define DVC_VLUT_40_VMIN_WOFFSET                        0x0
#define DVC_VLUT_40_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_40_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_40_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_40_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_40_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_40_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_40_VMAX_SHIFT)
#define DVC_VLUT_40_VMAX_RANGE                  4:0
#define DVC_VLUT_40_VMAX_WOFFSET                        0x0
#define DVC_VLUT_40_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_40_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_40_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_40_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_41  
#define DVC_VLUT_41                     _MK_ADDR_CONST(0x1a4)
#define DVC_VLUT_41_SECURE                      0x0
#define DVC_VLUT_41_WORD_COUNT                  0x1
#define DVC_VLUT_41_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_41_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_41_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_41_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_41_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_41_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_41_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_41_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_41_PMCNT_SHIFT)
#define DVC_VLUT_41_PMCNT_RANGE                 23:10
#define DVC_VLUT_41_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_41_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_41_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_41_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_41_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_41_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_41_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_41_VMIN_SHIFT)
#define DVC_VLUT_41_VMIN_RANGE                  9:5
#define DVC_VLUT_41_VMIN_WOFFSET                        0x0
#define DVC_VLUT_41_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_41_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_41_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_41_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_41_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_41_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_41_VMAX_SHIFT)
#define DVC_VLUT_41_VMAX_RANGE                  4:0
#define DVC_VLUT_41_VMAX_WOFFSET                        0x0
#define DVC_VLUT_41_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_41_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_41_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_41_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_42  
#define DVC_VLUT_42                     _MK_ADDR_CONST(0x1a8)
#define DVC_VLUT_42_SECURE                      0x0
#define DVC_VLUT_42_WORD_COUNT                  0x1
#define DVC_VLUT_42_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_42_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_42_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_42_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_42_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_42_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_42_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_42_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_42_PMCNT_SHIFT)
#define DVC_VLUT_42_PMCNT_RANGE                 23:10
#define DVC_VLUT_42_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_42_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_42_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_42_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_42_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_42_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_42_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_42_VMIN_SHIFT)
#define DVC_VLUT_42_VMIN_RANGE                  9:5
#define DVC_VLUT_42_VMIN_WOFFSET                        0x0
#define DVC_VLUT_42_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_42_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_42_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_42_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_42_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_42_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_42_VMAX_SHIFT)
#define DVC_VLUT_42_VMAX_RANGE                  4:0
#define DVC_VLUT_42_VMAX_WOFFSET                        0x0
#define DVC_VLUT_42_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_42_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_42_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_42_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_43  
#define DVC_VLUT_43                     _MK_ADDR_CONST(0x1ac)
#define DVC_VLUT_43_SECURE                      0x0
#define DVC_VLUT_43_WORD_COUNT                  0x1
#define DVC_VLUT_43_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_43_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_43_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_43_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_43_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_43_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_43_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_43_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_43_PMCNT_SHIFT)
#define DVC_VLUT_43_PMCNT_RANGE                 23:10
#define DVC_VLUT_43_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_43_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_43_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_43_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_43_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_43_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_43_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_43_VMIN_SHIFT)
#define DVC_VLUT_43_VMIN_RANGE                  9:5
#define DVC_VLUT_43_VMIN_WOFFSET                        0x0
#define DVC_VLUT_43_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_43_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_43_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_43_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_43_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_43_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_43_VMAX_SHIFT)
#define DVC_VLUT_43_VMAX_RANGE                  4:0
#define DVC_VLUT_43_VMAX_WOFFSET                        0x0
#define DVC_VLUT_43_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_43_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_43_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_43_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_44  
#define DVC_VLUT_44                     _MK_ADDR_CONST(0x1b0)
#define DVC_VLUT_44_SECURE                      0x0
#define DVC_VLUT_44_WORD_COUNT                  0x1
#define DVC_VLUT_44_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_44_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_44_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_44_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_44_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_44_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_44_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_44_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_44_PMCNT_SHIFT)
#define DVC_VLUT_44_PMCNT_RANGE                 23:10
#define DVC_VLUT_44_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_44_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_44_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_44_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_44_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_44_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_44_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_44_VMIN_SHIFT)
#define DVC_VLUT_44_VMIN_RANGE                  9:5
#define DVC_VLUT_44_VMIN_WOFFSET                        0x0
#define DVC_VLUT_44_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_44_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_44_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_44_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_44_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_44_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_44_VMAX_SHIFT)
#define DVC_VLUT_44_VMAX_RANGE                  4:0
#define DVC_VLUT_44_VMAX_WOFFSET                        0x0
#define DVC_VLUT_44_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_44_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_44_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_44_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_45  
#define DVC_VLUT_45                     _MK_ADDR_CONST(0x1b4)
#define DVC_VLUT_45_SECURE                      0x0
#define DVC_VLUT_45_WORD_COUNT                  0x1
#define DVC_VLUT_45_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_45_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_45_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_45_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_45_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_45_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_45_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_45_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_45_PMCNT_SHIFT)
#define DVC_VLUT_45_PMCNT_RANGE                 23:10
#define DVC_VLUT_45_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_45_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_45_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_45_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_45_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_45_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_45_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_45_VMIN_SHIFT)
#define DVC_VLUT_45_VMIN_RANGE                  9:5
#define DVC_VLUT_45_VMIN_WOFFSET                        0x0
#define DVC_VLUT_45_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_45_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_45_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_45_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_45_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_45_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_45_VMAX_SHIFT)
#define DVC_VLUT_45_VMAX_RANGE                  4:0
#define DVC_VLUT_45_VMAX_WOFFSET                        0x0
#define DVC_VLUT_45_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_45_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_45_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_45_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_46  
#define DVC_VLUT_46                     _MK_ADDR_CONST(0x1b8)
#define DVC_VLUT_46_SECURE                      0x0
#define DVC_VLUT_46_WORD_COUNT                  0x1
#define DVC_VLUT_46_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_46_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_46_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_46_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_46_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_46_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_46_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_46_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_46_PMCNT_SHIFT)
#define DVC_VLUT_46_PMCNT_RANGE                 23:10
#define DVC_VLUT_46_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_46_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_46_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_46_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_46_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_46_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_46_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_46_VMIN_SHIFT)
#define DVC_VLUT_46_VMIN_RANGE                  9:5
#define DVC_VLUT_46_VMIN_WOFFSET                        0x0
#define DVC_VLUT_46_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_46_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_46_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_46_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_46_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_46_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_46_VMAX_SHIFT)
#define DVC_VLUT_46_VMAX_RANGE                  4:0
#define DVC_VLUT_46_VMAX_WOFFSET                        0x0
#define DVC_VLUT_46_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_46_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_46_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_46_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_47  
#define DVC_VLUT_47                     _MK_ADDR_CONST(0x1bc)
#define DVC_VLUT_47_SECURE                      0x0
#define DVC_VLUT_47_WORD_COUNT                  0x1
#define DVC_VLUT_47_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_47_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_47_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_47_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_47_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_47_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_47_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_47_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_47_PMCNT_SHIFT)
#define DVC_VLUT_47_PMCNT_RANGE                 23:10
#define DVC_VLUT_47_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_47_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_47_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_47_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_47_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_47_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_47_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_47_VMIN_SHIFT)
#define DVC_VLUT_47_VMIN_RANGE                  9:5
#define DVC_VLUT_47_VMIN_WOFFSET                        0x0
#define DVC_VLUT_47_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_47_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_47_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_47_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_47_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_47_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_47_VMAX_SHIFT)
#define DVC_VLUT_47_VMAX_RANGE                  4:0
#define DVC_VLUT_47_VMAX_WOFFSET                        0x0
#define DVC_VLUT_47_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_47_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_47_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_47_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_48  
#define DVC_VLUT_48                     _MK_ADDR_CONST(0x1c0)
#define DVC_VLUT_48_SECURE                      0x0
#define DVC_VLUT_48_WORD_COUNT                  0x1
#define DVC_VLUT_48_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_48_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_48_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_48_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_48_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_48_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_48_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_48_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_48_PMCNT_SHIFT)
#define DVC_VLUT_48_PMCNT_RANGE                 23:10
#define DVC_VLUT_48_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_48_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_48_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_48_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_48_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_48_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_48_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_48_VMIN_SHIFT)
#define DVC_VLUT_48_VMIN_RANGE                  9:5
#define DVC_VLUT_48_VMIN_WOFFSET                        0x0
#define DVC_VLUT_48_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_48_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_48_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_48_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_48_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_48_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_48_VMAX_SHIFT)
#define DVC_VLUT_48_VMAX_RANGE                  4:0
#define DVC_VLUT_48_VMAX_WOFFSET                        0x0
#define DVC_VLUT_48_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_48_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_48_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_48_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_49  
#define DVC_VLUT_49                     _MK_ADDR_CONST(0x1c4)
#define DVC_VLUT_49_SECURE                      0x0
#define DVC_VLUT_49_WORD_COUNT                  0x1
#define DVC_VLUT_49_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_49_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_49_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_49_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_49_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_49_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_49_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_49_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_49_PMCNT_SHIFT)
#define DVC_VLUT_49_PMCNT_RANGE                 23:10
#define DVC_VLUT_49_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_49_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_49_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_49_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_49_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_49_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_49_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_49_VMIN_SHIFT)
#define DVC_VLUT_49_VMIN_RANGE                  9:5
#define DVC_VLUT_49_VMIN_WOFFSET                        0x0
#define DVC_VLUT_49_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_49_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_49_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_49_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_49_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_49_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_49_VMAX_SHIFT)
#define DVC_VLUT_49_VMAX_RANGE                  4:0
#define DVC_VLUT_49_VMAX_WOFFSET                        0x0
#define DVC_VLUT_49_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_49_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_49_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_49_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_50  
#define DVC_VLUT_50                     _MK_ADDR_CONST(0x1c8)
#define DVC_VLUT_50_SECURE                      0x0
#define DVC_VLUT_50_WORD_COUNT                  0x1
#define DVC_VLUT_50_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_50_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_50_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_50_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_50_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_50_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_50_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_50_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_50_PMCNT_SHIFT)
#define DVC_VLUT_50_PMCNT_RANGE                 23:10
#define DVC_VLUT_50_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_50_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_50_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_50_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_50_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_50_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_50_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_50_VMIN_SHIFT)
#define DVC_VLUT_50_VMIN_RANGE                  9:5
#define DVC_VLUT_50_VMIN_WOFFSET                        0x0
#define DVC_VLUT_50_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_50_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_50_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_50_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_50_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_50_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_50_VMAX_SHIFT)
#define DVC_VLUT_50_VMAX_RANGE                  4:0
#define DVC_VLUT_50_VMAX_WOFFSET                        0x0
#define DVC_VLUT_50_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_50_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_50_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_50_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_51  
#define DVC_VLUT_51                     _MK_ADDR_CONST(0x1cc)
#define DVC_VLUT_51_SECURE                      0x0
#define DVC_VLUT_51_WORD_COUNT                  0x1
#define DVC_VLUT_51_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_51_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_51_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_51_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_51_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_51_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_51_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_51_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_51_PMCNT_SHIFT)
#define DVC_VLUT_51_PMCNT_RANGE                 23:10
#define DVC_VLUT_51_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_51_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_51_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_51_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_51_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_51_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_51_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_51_VMIN_SHIFT)
#define DVC_VLUT_51_VMIN_RANGE                  9:5
#define DVC_VLUT_51_VMIN_WOFFSET                        0x0
#define DVC_VLUT_51_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_51_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_51_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_51_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_51_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_51_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_51_VMAX_SHIFT)
#define DVC_VLUT_51_VMAX_RANGE                  4:0
#define DVC_VLUT_51_VMAX_WOFFSET                        0x0
#define DVC_VLUT_51_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_51_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_51_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_51_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_52  
#define DVC_VLUT_52                     _MK_ADDR_CONST(0x1d0)
#define DVC_VLUT_52_SECURE                      0x0
#define DVC_VLUT_52_WORD_COUNT                  0x1
#define DVC_VLUT_52_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_52_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_52_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_52_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_52_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_52_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_52_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_52_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_52_PMCNT_SHIFT)
#define DVC_VLUT_52_PMCNT_RANGE                 23:10
#define DVC_VLUT_52_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_52_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_52_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_52_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_52_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_52_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_52_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_52_VMIN_SHIFT)
#define DVC_VLUT_52_VMIN_RANGE                  9:5
#define DVC_VLUT_52_VMIN_WOFFSET                        0x0
#define DVC_VLUT_52_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_52_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_52_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_52_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_52_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_52_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_52_VMAX_SHIFT)
#define DVC_VLUT_52_VMAX_RANGE                  4:0
#define DVC_VLUT_52_VMAX_WOFFSET                        0x0
#define DVC_VLUT_52_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_52_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_52_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_52_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_53  
#define DVC_VLUT_53                     _MK_ADDR_CONST(0x1d4)
#define DVC_VLUT_53_SECURE                      0x0
#define DVC_VLUT_53_WORD_COUNT                  0x1
#define DVC_VLUT_53_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_53_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_53_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_53_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_53_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_53_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_53_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_53_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_53_PMCNT_SHIFT)
#define DVC_VLUT_53_PMCNT_RANGE                 23:10
#define DVC_VLUT_53_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_53_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_53_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_53_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_53_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_53_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_53_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_53_VMIN_SHIFT)
#define DVC_VLUT_53_VMIN_RANGE                  9:5
#define DVC_VLUT_53_VMIN_WOFFSET                        0x0
#define DVC_VLUT_53_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_53_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_53_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_53_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_53_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_53_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_53_VMAX_SHIFT)
#define DVC_VLUT_53_VMAX_RANGE                  4:0
#define DVC_VLUT_53_VMAX_WOFFSET                        0x0
#define DVC_VLUT_53_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_53_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_53_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_53_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_54  
#define DVC_VLUT_54                     _MK_ADDR_CONST(0x1d8)
#define DVC_VLUT_54_SECURE                      0x0
#define DVC_VLUT_54_WORD_COUNT                  0x1
#define DVC_VLUT_54_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_54_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_54_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_54_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_54_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_54_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_54_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_54_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_54_PMCNT_SHIFT)
#define DVC_VLUT_54_PMCNT_RANGE                 23:10
#define DVC_VLUT_54_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_54_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_54_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_54_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_54_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_54_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_54_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_54_VMIN_SHIFT)
#define DVC_VLUT_54_VMIN_RANGE                  9:5
#define DVC_VLUT_54_VMIN_WOFFSET                        0x0
#define DVC_VLUT_54_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_54_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_54_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_54_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_54_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_54_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_54_VMAX_SHIFT)
#define DVC_VLUT_54_VMAX_RANGE                  4:0
#define DVC_VLUT_54_VMAX_WOFFSET                        0x0
#define DVC_VLUT_54_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_54_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_54_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_54_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_55  
#define DVC_VLUT_55                     _MK_ADDR_CONST(0x1dc)
#define DVC_VLUT_55_SECURE                      0x0
#define DVC_VLUT_55_WORD_COUNT                  0x1
#define DVC_VLUT_55_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_55_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_55_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_55_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_55_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_55_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_55_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_55_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_55_PMCNT_SHIFT)
#define DVC_VLUT_55_PMCNT_RANGE                 23:10
#define DVC_VLUT_55_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_55_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_55_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_55_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_55_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_55_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_55_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_55_VMIN_SHIFT)
#define DVC_VLUT_55_VMIN_RANGE                  9:5
#define DVC_VLUT_55_VMIN_WOFFSET                        0x0
#define DVC_VLUT_55_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_55_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_55_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_55_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_55_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_55_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_55_VMAX_SHIFT)
#define DVC_VLUT_55_VMAX_RANGE                  4:0
#define DVC_VLUT_55_VMAX_WOFFSET                        0x0
#define DVC_VLUT_55_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_55_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_55_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_55_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_56  
#define DVC_VLUT_56                     _MK_ADDR_CONST(0x1e0)
#define DVC_VLUT_56_SECURE                      0x0
#define DVC_VLUT_56_WORD_COUNT                  0x1
#define DVC_VLUT_56_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_56_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_56_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_56_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_56_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_56_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_56_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_56_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_56_PMCNT_SHIFT)
#define DVC_VLUT_56_PMCNT_RANGE                 23:10
#define DVC_VLUT_56_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_56_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_56_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_56_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_56_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_56_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_56_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_56_VMIN_SHIFT)
#define DVC_VLUT_56_VMIN_RANGE                  9:5
#define DVC_VLUT_56_VMIN_WOFFSET                        0x0
#define DVC_VLUT_56_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_56_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_56_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_56_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_56_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_56_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_56_VMAX_SHIFT)
#define DVC_VLUT_56_VMAX_RANGE                  4:0
#define DVC_VLUT_56_VMAX_WOFFSET                        0x0
#define DVC_VLUT_56_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_56_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_56_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_56_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_57  
#define DVC_VLUT_57                     _MK_ADDR_CONST(0x1e4)
#define DVC_VLUT_57_SECURE                      0x0
#define DVC_VLUT_57_WORD_COUNT                  0x1
#define DVC_VLUT_57_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_57_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_57_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_57_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_57_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_57_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_57_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_57_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_57_PMCNT_SHIFT)
#define DVC_VLUT_57_PMCNT_RANGE                 23:10
#define DVC_VLUT_57_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_57_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_57_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_57_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_57_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_57_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_57_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_57_VMIN_SHIFT)
#define DVC_VLUT_57_VMIN_RANGE                  9:5
#define DVC_VLUT_57_VMIN_WOFFSET                        0x0
#define DVC_VLUT_57_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_57_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_57_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_57_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_57_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_57_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_57_VMAX_SHIFT)
#define DVC_VLUT_57_VMAX_RANGE                  4:0
#define DVC_VLUT_57_VMAX_WOFFSET                        0x0
#define DVC_VLUT_57_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_57_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_57_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_57_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_58  
#define DVC_VLUT_58                     _MK_ADDR_CONST(0x1e8)
#define DVC_VLUT_58_SECURE                      0x0
#define DVC_VLUT_58_WORD_COUNT                  0x1
#define DVC_VLUT_58_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_58_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_58_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_58_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_58_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_58_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_58_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_58_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_58_PMCNT_SHIFT)
#define DVC_VLUT_58_PMCNT_RANGE                 23:10
#define DVC_VLUT_58_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_58_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_58_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_58_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_58_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_58_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_58_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_58_VMIN_SHIFT)
#define DVC_VLUT_58_VMIN_RANGE                  9:5
#define DVC_VLUT_58_VMIN_WOFFSET                        0x0
#define DVC_VLUT_58_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_58_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_58_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_58_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_58_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_58_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_58_VMAX_SHIFT)
#define DVC_VLUT_58_VMAX_RANGE                  4:0
#define DVC_VLUT_58_VMAX_WOFFSET                        0x0
#define DVC_VLUT_58_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_58_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_58_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_58_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_59  
#define DVC_VLUT_59                     _MK_ADDR_CONST(0x1ec)
#define DVC_VLUT_59_SECURE                      0x0
#define DVC_VLUT_59_WORD_COUNT                  0x1
#define DVC_VLUT_59_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_59_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_59_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_59_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_59_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_59_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_59_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_59_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_59_PMCNT_SHIFT)
#define DVC_VLUT_59_PMCNT_RANGE                 23:10
#define DVC_VLUT_59_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_59_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_59_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_59_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_59_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_59_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_59_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_59_VMIN_SHIFT)
#define DVC_VLUT_59_VMIN_RANGE                  9:5
#define DVC_VLUT_59_VMIN_WOFFSET                        0x0
#define DVC_VLUT_59_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_59_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_59_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_59_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_59_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_59_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_59_VMAX_SHIFT)
#define DVC_VLUT_59_VMAX_RANGE                  4:0
#define DVC_VLUT_59_VMAX_WOFFSET                        0x0
#define DVC_VLUT_59_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_59_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_59_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_59_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_60  
#define DVC_VLUT_60                     _MK_ADDR_CONST(0x1f0)
#define DVC_VLUT_60_SECURE                      0x0
#define DVC_VLUT_60_WORD_COUNT                  0x1
#define DVC_VLUT_60_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_60_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_60_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_60_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_60_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_60_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_60_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_60_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_60_PMCNT_SHIFT)
#define DVC_VLUT_60_PMCNT_RANGE                 23:10
#define DVC_VLUT_60_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_60_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_60_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_60_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_60_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_60_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_60_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_60_VMIN_SHIFT)
#define DVC_VLUT_60_VMIN_RANGE                  9:5
#define DVC_VLUT_60_VMIN_WOFFSET                        0x0
#define DVC_VLUT_60_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_60_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_60_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_60_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_60_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_60_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_60_VMAX_SHIFT)
#define DVC_VLUT_60_VMAX_RANGE                  4:0
#define DVC_VLUT_60_VMAX_WOFFSET                        0x0
#define DVC_VLUT_60_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_60_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_60_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_60_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_61  
#define DVC_VLUT_61                     _MK_ADDR_CONST(0x1f4)
#define DVC_VLUT_61_SECURE                      0x0
#define DVC_VLUT_61_WORD_COUNT                  0x1
#define DVC_VLUT_61_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_61_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_61_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_61_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_61_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_61_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_61_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_61_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_61_PMCNT_SHIFT)
#define DVC_VLUT_61_PMCNT_RANGE                 23:10
#define DVC_VLUT_61_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_61_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_61_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_61_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_61_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_61_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_61_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_61_VMIN_SHIFT)
#define DVC_VLUT_61_VMIN_RANGE                  9:5
#define DVC_VLUT_61_VMIN_WOFFSET                        0x0
#define DVC_VLUT_61_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_61_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_61_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_61_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_61_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_61_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_61_VMAX_SHIFT)
#define DVC_VLUT_61_VMAX_RANGE                  4:0
#define DVC_VLUT_61_VMAX_WOFFSET                        0x0
#define DVC_VLUT_61_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_61_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_61_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_61_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_62  
#define DVC_VLUT_62                     _MK_ADDR_CONST(0x1f8)
#define DVC_VLUT_62_SECURE                      0x0
#define DVC_VLUT_62_WORD_COUNT                  0x1
#define DVC_VLUT_62_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_62_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_62_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_62_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_62_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_62_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_62_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_62_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_62_PMCNT_SHIFT)
#define DVC_VLUT_62_PMCNT_RANGE                 23:10
#define DVC_VLUT_62_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_62_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_62_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_62_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_62_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_62_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_62_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_62_VMIN_SHIFT)
#define DVC_VLUT_62_VMIN_RANGE                  9:5
#define DVC_VLUT_62_VMIN_WOFFSET                        0x0
#define DVC_VLUT_62_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_62_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_62_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_62_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_62_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_62_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_62_VMAX_SHIFT)
#define DVC_VLUT_62_VMAX_RANGE                  4:0
#define DVC_VLUT_62_VMAX_WOFFSET                        0x0
#define DVC_VLUT_62_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_62_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_62_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_62_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Ram DVC_VLUT_63  
#define DVC_VLUT_63                     _MK_ADDR_CONST(0x1fc)
#define DVC_VLUT_63_SECURE                      0x0
#define DVC_VLUT_63_WORD_COUNT                  0x1
#define DVC_VLUT_63_RESET_VAL                   _MK_MASK_CONST(0x0)
#define DVC_VLUT_63_RESET_MASK                  _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_63_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define DVC_VLUT_63_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_63_READ_MASK                   _MK_MASK_CONST(0xffffff)
#define DVC_VLUT_63_WRITE_MASK                  _MK_MASK_CONST(0xffffff)
// Target performance count
#define DVC_VLUT_63_PMCNT_SHIFT                 _MK_SHIFT_CONST(10)
#define DVC_VLUT_63_PMCNT_FIELD                 (_MK_MASK_CONST(0x3fff) << DVC_VLUT_63_PMCNT_SHIFT)
#define DVC_VLUT_63_PMCNT_RANGE                 23:10
#define DVC_VLUT_63_PMCNT_WOFFSET                       0x0
#define DVC_VLUT_63_PMCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define DVC_VLUT_63_PMCNT_DEFAULT_MASK                  _MK_MASK_CONST(0x3fff)
#define DVC_VLUT_63_PMCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define DVC_VLUT_63_PMCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Minimum voltage selection value for a given  frequency
#define DVC_VLUT_63_VMIN_SHIFT                  _MK_SHIFT_CONST(5)
#define DVC_VLUT_63_VMIN_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_63_VMIN_SHIFT)
#define DVC_VLUT_63_VMIN_RANGE                  9:5
#define DVC_VLUT_63_VMIN_WOFFSET                        0x0
#define DVC_VLUT_63_VMIN_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_63_VMIN_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_63_VMIN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_63_VMIN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Maximum voltage selection value for a given  frequency
#define DVC_VLUT_63_VMAX_SHIFT                  _MK_SHIFT_CONST(0)
#define DVC_VLUT_63_VMAX_FIELD                  (_MK_MASK_CONST(0x1f) << DVC_VLUT_63_VMAX_SHIFT)
#define DVC_VLUT_63_VMAX_RANGE                  4:0
#define DVC_VLUT_63_VMAX_WOFFSET                        0x0
#define DVC_VLUT_63_VMAX_DEFAULT                        _MK_MASK_CONST(0x0)
#define DVC_VLUT_63_VMAX_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define DVC_VLUT_63_VMAX_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define DVC_VLUT_63_VMAX_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_ARDVC_REGS(_op_) \
_op_(DVC_CTRL_REG1_0) \
_op_(DVC_CTRL_REG2_0) \
_op_(DVC_CTRL_REG3_0) \
_op_(DVC_STATUS_REG_0) \
_op_(DVC_I2C_CTRL_REG_0) \
_op_(DVC_I2C_ADDR_DATA_REG_0) \
_op_(DVC_RING_OSC_ADDER_IN1_0) \
_op_(DVC_RING_OSC_ADDER_IN2_0) \
_op_(DVC_REQ_REGISTER_0) \
_op_(DVC_I2C_ADDR_DATA_REG_3_0) \
_op_(DVC_I2C_CNFG_0) \
_op_(DVC_I2C_CMD_ADDR0_0) \
_op_(DVC_I2C_CMD_ADDR1_0) \
_op_(DVC_I2C_CMD_DATA1_0) \
_op_(DVC_I2C_CMD_DATA2_0) \
_op_(DVC_I2C_STATUS_0) \
_op_(DVC_I2C_TX_PACKET_FIFO_0) \
_op_(DVC_I2C_RX_FIFO_0) \
_op_(DVC_PACKET_TRANSFER_STATUS_0) \
_op_(DVC_FIFO_CONTROL_0) \
_op_(DVC_FIFO_STATUS_0) \
_op_(DVC_INTERRUPT_MASK_REGISTER_0) \
_op_(DVC_INTERRUPT_STATUS_REGISTER_0) \
_op_(DVC_I2C_CLK_DIVISOR_REGISTER_0) \
_op_(DVC_VSEL_MAP_LUT_0) \
_op_(DVC_VSEL_MAP_LUT) \
_op_(DVC_VSEL_MAP_LUT_1) \
_op_(DVC_VSEL_MAP_LUT_2) \
_op_(DVC_VSEL_MAP_LUT_3) \
_op_(DVC_VSEL_MAP_LUT_4) \
_op_(DVC_VSEL_MAP_LUT_5) \
_op_(DVC_VSEL_MAP_LUT_6) \
_op_(DVC_VSEL_MAP_LUT_7) \
_op_(DVC_VSEL_MAP_LUT_8) \
_op_(DVC_VSEL_MAP_LUT_9) \
_op_(DVC_VSEL_MAP_LUT_10) \
_op_(DVC_VSEL_MAP_LUT_11) \
_op_(DVC_VSEL_MAP_LUT_12) \
_op_(DVC_VSEL_MAP_LUT_13) \
_op_(DVC_VSEL_MAP_LUT_14) \
_op_(DVC_VSEL_MAP_LUT_15) \
_op_(DVC_VSEL_MAP_LUT_16) \
_op_(DVC_VSEL_MAP_LUT_17) \
_op_(DVC_VSEL_MAP_LUT_18) \
_op_(DVC_VSEL_MAP_LUT_19) \
_op_(DVC_VSEL_MAP_LUT_20) \
_op_(DVC_VSEL_MAP_LUT_21) \
_op_(DVC_VSEL_MAP_LUT_22) \
_op_(DVC_VSEL_MAP_LUT_23) \
_op_(DVC_VSEL_MAP_LUT_24) \
_op_(DVC_VSEL_MAP_LUT_25) \
_op_(DVC_VSEL_MAP_LUT_26) \
_op_(DVC_VSEL_MAP_LUT_27) \
_op_(DVC_VSEL_MAP_LUT_28) \
_op_(DVC_VSEL_MAP_LUT_29) \
_op_(DVC_VSEL_MAP_LUT_30) \
_op_(DVC_VSEL_MAP_LUT_31) \
_op_(DVC_VLUT_0) \
_op_(DVC_VLUT) \
_op_(DVC_VLUT_1) \
_op_(DVC_VLUT_2) \
_op_(DVC_VLUT_3) \
_op_(DVC_VLUT_4) \
_op_(DVC_VLUT_5) \
_op_(DVC_VLUT_6) \
_op_(DVC_VLUT_7) \
_op_(DVC_VLUT_8) \
_op_(DVC_VLUT_9) \
_op_(DVC_VLUT_10) \
_op_(DVC_VLUT_11) \
_op_(DVC_VLUT_12) \
_op_(DVC_VLUT_13) \
_op_(DVC_VLUT_14) \
_op_(DVC_VLUT_15) \
_op_(DVC_VLUT_16) \
_op_(DVC_VLUT_17) \
_op_(DVC_VLUT_18) \
_op_(DVC_VLUT_19) \
_op_(DVC_VLUT_20) \
_op_(DVC_VLUT_21) \
_op_(DVC_VLUT_22) \
_op_(DVC_VLUT_23) \
_op_(DVC_VLUT_24) \
_op_(DVC_VLUT_25) \
_op_(DVC_VLUT_26) \
_op_(DVC_VLUT_27) \
_op_(DVC_VLUT_28) \
_op_(DVC_VLUT_29) \
_op_(DVC_VLUT_30) \
_op_(DVC_VLUT_31) \
_op_(DVC_VLUT_32) \
_op_(DVC_VLUT_33) \
_op_(DVC_VLUT_34) \
_op_(DVC_VLUT_35) \
_op_(DVC_VLUT_36) \
_op_(DVC_VLUT_37) \
_op_(DVC_VLUT_38) \
_op_(DVC_VLUT_39) \
_op_(DVC_VLUT_40) \
_op_(DVC_VLUT_41) \
_op_(DVC_VLUT_42) \
_op_(DVC_VLUT_43) \
_op_(DVC_VLUT_44) \
_op_(DVC_VLUT_45) \
_op_(DVC_VLUT_46) \
_op_(DVC_VLUT_47) \
_op_(DVC_VLUT_48) \
_op_(DVC_VLUT_49) \
_op_(DVC_VLUT_50) \
_op_(DVC_VLUT_51) \
_op_(DVC_VLUT_52) \
_op_(DVC_VLUT_53) \
_op_(DVC_VLUT_54) \
_op_(DVC_VLUT_55) \
_op_(DVC_VLUT_56) \
_op_(DVC_VLUT_57) \
_op_(DVC_VLUT_58) \
_op_(DVC_VLUT_59) \
_op_(DVC_VLUT_60) \
_op_(DVC_VLUT_61) \
_op_(DVC_VLUT_62) \
_op_(DVC_VLUT_63)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_DVC        0x00000000

//
// ARDVC REGISTER BANKS
//

#define DVC0_FIRST_REG 0x0000 // DVC_CTRL_REG1_0
#define DVC0_LAST_REG 0x0024 // DVC_I2C_ADDR_DATA_REG_3_0
#define DVC1_FIRST_REG 0x0040 // DVC_I2C_CNFG_0
#define DVC1_LAST_REG 0x0050 // DVC_I2C_CMD_DATA2_0
#define DVC2_FIRST_REG 0x005c // DVC_I2C_STATUS_0
#define DVC2_LAST_REG 0x01fc // DVC_VLUT_63

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARDVC_H_INC_
