/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___AREMC_H_INC_
#define ___AREMC_H_INC_
#define EMC_FBIO_DATA_MAX       31
#define EMC_FBIO_DATA_WIDTH     32
#define EMC_FBIO_DOE_MAX        3
#define EMC_FBIO_DOE_WIDTH      4
#define MAX_EMC_TIMING_WDV      15

// Register EMC_INTSTATUS_0  // Interrupt Status Register.
#define EMC_INTSTATUS_0                 _MK_ADDR_CONST(0x0)
#define EMC_INTSTATUS_0_SECURE                  0x0
#define EMC_INTSTATUS_0_WORD_COUNT                      0x1
#define EMC_INTSTATUS_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_RESET_MASK                      _MK_MASK_CONST(0x38)
#define EMC_INTSTATUS_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_READ_MASK                       _MK_MASK_CONST(0x38)
#define EMC_INTSTATUS_0_WRITE_MASK                      _MK_MASK_CONST(0x38)
// Refresh request overflow timeout.
#define EMC_INTSTATUS_0_REFRESH_OVERFLOW_INT_SHIFT                      _MK_SHIFT_CONST(3)
#define EMC_INTSTATUS_0_REFRESH_OVERFLOW_INT_FIELD                      (_MK_MASK_CONST(0x1) << EMC_INTSTATUS_0_REFRESH_OVERFLOW_INT_SHIFT)
#define EMC_INTSTATUS_0_REFRESH_OVERFLOW_INT_RANGE                      3:3
#define EMC_INTSTATUS_0_REFRESH_OVERFLOW_INT_WOFFSET                    0x0
#define EMC_INTSTATUS_0_REFRESH_OVERFLOW_INT_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_REFRESH_OVERFLOW_INT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_INTSTATUS_0_REFRESH_OVERFLOW_INT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_REFRESH_OVERFLOW_INT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_REFRESH_OVERFLOW_INT_INIT_ENUM                  CLEAR
#define EMC_INTSTATUS_0_REFRESH_OVERFLOW_INT_CLEAR                      _MK_ENUM_CONST(0)
#define EMC_INTSTATUS_0_REFRESH_OVERFLOW_INT_SET                        _MK_ENUM_CONST(1)

// CAR/EMC clock-change handshake complete.
#define EMC_INTSTATUS_0_CLKCHANGE_COMPLETE_INT_SHIFT                    _MK_SHIFT_CONST(4)
#define EMC_INTSTATUS_0_CLKCHANGE_COMPLETE_INT_FIELD                    (_MK_MASK_CONST(0x1) << EMC_INTSTATUS_0_CLKCHANGE_COMPLETE_INT_SHIFT)
#define EMC_INTSTATUS_0_CLKCHANGE_COMPLETE_INT_RANGE                    4:4
#define EMC_INTSTATUS_0_CLKCHANGE_COMPLETE_INT_WOFFSET                  0x0
#define EMC_INTSTATUS_0_CLKCHANGE_COMPLETE_INT_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_CLKCHANGE_COMPLETE_INT_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_INTSTATUS_0_CLKCHANGE_COMPLETE_INT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_CLKCHANGE_COMPLETE_INT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_CLKCHANGE_COMPLETE_INT_INIT_ENUM                        CLEAR
#define EMC_INTSTATUS_0_CLKCHANGE_COMPLETE_INT_CLEAR                    _MK_ENUM_CONST(0)
#define EMC_INTSTATUS_0_CLKCHANGE_COMPLETE_INT_SET                      _MK_ENUM_CONST(1)

// LPDDR2 MRR data is available to be read.
#define EMC_INTSTATUS_0_MRR_DIVLD_INT_SHIFT                     _MK_SHIFT_CONST(5)
#define EMC_INTSTATUS_0_MRR_DIVLD_INT_FIELD                     (_MK_MASK_CONST(0x1) << EMC_INTSTATUS_0_MRR_DIVLD_INT_SHIFT)
#define EMC_INTSTATUS_0_MRR_DIVLD_INT_RANGE                     5:5
#define EMC_INTSTATUS_0_MRR_DIVLD_INT_WOFFSET                   0x0
#define EMC_INTSTATUS_0_MRR_DIVLD_INT_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_MRR_DIVLD_INT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define EMC_INTSTATUS_0_MRR_DIVLD_INT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_MRR_DIVLD_INT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_INTSTATUS_0_MRR_DIVLD_INT_INIT_ENUM                 CLEAR
#define EMC_INTSTATUS_0_MRR_DIVLD_INT_CLEAR                     _MK_ENUM_CONST(0)
#define EMC_INTSTATUS_0_MRR_DIVLD_INT_SET                       _MK_ENUM_CONST(1)


// Register EMC_INTMASK_0  // Interrupt Mask Register. 
#define EMC_INTMASK_0                   _MK_ADDR_CONST(0x4)
#define EMC_INTMASK_0_SECURE                    0x0
#define EMC_INTMASK_0_WORD_COUNT                        0x1
#define EMC_INTMASK_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_RESET_MASK                        _MK_MASK_CONST(0x38)
#define EMC_INTMASK_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_READ_MASK                         _MK_MASK_CONST(0x38)
#define EMC_INTMASK_0_WRITE_MASK                        _MK_MASK_CONST(0x38)
// Mask for refresh request overflow timeout.
#define EMC_INTMASK_0_REFRESH_OVERFLOW_INTMASK_SHIFT                    _MK_SHIFT_CONST(3)
#define EMC_INTMASK_0_REFRESH_OVERFLOW_INTMASK_FIELD                    (_MK_MASK_CONST(0x1) << EMC_INTMASK_0_REFRESH_OVERFLOW_INTMASK_SHIFT)
#define EMC_INTMASK_0_REFRESH_OVERFLOW_INTMASK_RANGE                    3:3
#define EMC_INTMASK_0_REFRESH_OVERFLOW_INTMASK_WOFFSET                  0x0
#define EMC_INTMASK_0_REFRESH_OVERFLOW_INTMASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_REFRESH_OVERFLOW_INTMASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_INTMASK_0_REFRESH_OVERFLOW_INTMASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_REFRESH_OVERFLOW_INTMASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_REFRESH_OVERFLOW_INTMASK_INIT_ENUM                        MASKED
#define EMC_INTMASK_0_REFRESH_OVERFLOW_INTMASK_MASKED                   _MK_ENUM_CONST(0)
#define EMC_INTMASK_0_REFRESH_OVERFLOW_INTMASK_UNMASKED                 _MK_ENUM_CONST(1)

// Mask for CAR/EMC clock-change handshake complete.
#define EMC_INTMASK_0_CLKCHANGE_COMPLETE_INTMASK_SHIFT                  _MK_SHIFT_CONST(4)
#define EMC_INTMASK_0_CLKCHANGE_COMPLETE_INTMASK_FIELD                  (_MK_MASK_CONST(0x1) << EMC_INTMASK_0_CLKCHANGE_COMPLETE_INTMASK_SHIFT)
#define EMC_INTMASK_0_CLKCHANGE_COMPLETE_INTMASK_RANGE                  4:4
#define EMC_INTMASK_0_CLKCHANGE_COMPLETE_INTMASK_WOFFSET                        0x0
#define EMC_INTMASK_0_CLKCHANGE_COMPLETE_INTMASK_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_CLKCHANGE_COMPLETE_INTMASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define EMC_INTMASK_0_CLKCHANGE_COMPLETE_INTMASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_CLKCHANGE_COMPLETE_INTMASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_CLKCHANGE_COMPLETE_INTMASK_INIT_ENUM                      MASKED
#define EMC_INTMASK_0_CLKCHANGE_COMPLETE_INTMASK_MASKED                 _MK_ENUM_CONST(0)
#define EMC_INTMASK_0_CLKCHANGE_COMPLETE_INTMASK_UNMASKED                       _MK_ENUM_CONST(1)

// Mask for MRR data available.
#define EMC_INTMASK_0_MRR_DIVLD_INTMASK_SHIFT                   _MK_SHIFT_CONST(5)
#define EMC_INTMASK_0_MRR_DIVLD_INTMASK_FIELD                   (_MK_MASK_CONST(0x1) << EMC_INTMASK_0_MRR_DIVLD_INTMASK_SHIFT)
#define EMC_INTMASK_0_MRR_DIVLD_INTMASK_RANGE                   5:5
#define EMC_INTMASK_0_MRR_DIVLD_INTMASK_WOFFSET                 0x0
#define EMC_INTMASK_0_MRR_DIVLD_INTMASK_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_MRR_DIVLD_INTMASK_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define EMC_INTMASK_0_MRR_DIVLD_INTMASK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_MRR_DIVLD_INTMASK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_INTMASK_0_MRR_DIVLD_INTMASK_INIT_ENUM                       MASKED
#define EMC_INTMASK_0_MRR_DIVLD_INTMASK_MASKED                  _MK_ENUM_CONST(0)
#define EMC_INTMASK_0_MRR_DIVLD_INTMASK_UNMASKED                        _MK_ENUM_CONST(1)


// Register EMC_DBG_0  // Debug Register
#define EMC_DBG_0                       _MK_ADDR_CONST(0x8)
#define EMC_DBG_0_SECURE                        0x0
#define EMC_DBG_0_WORD_COUNT                    0x1
#define EMC_DBG_0_RESET_VAL                     _MK_MASK_CONST(0x1000400)
#define EMC_DBG_0_RESET_MASK                    _MK_MASK_CONST(0x1000637)
#define EMC_DBG_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_DBG_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_DBG_0_READ_MASK                     _MK_MASK_CONST(0x1000637)
#define EMC_DBG_0_WRITE_MASK                    _MK_MASK_CONST(0x1000637)
// controls whether reads to the configuration registers are done from the assembly or active state.
#define EMC_DBG_0_READ_MUX_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_DBG_0_READ_MUX_FIELD                        (_MK_MASK_CONST(0x1) << EMC_DBG_0_READ_MUX_SHIFT)
#define EMC_DBG_0_READ_MUX_RANGE                        0:0
#define EMC_DBG_0_READ_MUX_WOFFSET                      0x0
#define EMC_DBG_0_READ_MUX_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DBG_0_READ_MUX_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define EMC_DBG_0_READ_MUX_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_DBG_0_READ_MUX_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_DBG_0_READ_MUX_INIT_ENUM                    ACTIVE
#define EMC_DBG_0_READ_MUX_ACTIVE                       _MK_ENUM_CONST(0)
#define EMC_DBG_0_READ_MUX_ASSEMBLY                     _MK_ENUM_CONST(1)

// controls whether writes to the configuration registers are done from the assembly or active state.
#define EMC_DBG_0_WRITE_MUX_SHIFT                       _MK_SHIFT_CONST(1)
#define EMC_DBG_0_WRITE_MUX_FIELD                       (_MK_MASK_CONST(0x1) << EMC_DBG_0_WRITE_MUX_SHIFT)
#define EMC_DBG_0_WRITE_MUX_RANGE                       1:1
#define EMC_DBG_0_WRITE_MUX_WOFFSET                     0x0
#define EMC_DBG_0_WRITE_MUX_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_DBG_0_WRITE_MUX_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define EMC_DBG_0_WRITE_MUX_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_DBG_0_WRITE_MUX_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_DBG_0_WRITE_MUX_INIT_ENUM                   ASSEMBLY
#define EMC_DBG_0_WRITE_MUX_ASSEMBLY                    _MK_ENUM_CONST(0)
#define EMC_DBG_0_WRITE_MUX_ACTIVE                      _MK_ENUM_CONST(1)

// causes the active state to get updated with the assembly state immediately upon writing the TIMING_CONTROL register.
#define EMC_DBG_0_FORCE_UPDATE_SHIFT                    _MK_SHIFT_CONST(2)
#define EMC_DBG_0_FORCE_UPDATE_FIELD                    (_MK_MASK_CONST(0x1) << EMC_DBG_0_FORCE_UPDATE_SHIFT)
#define EMC_DBG_0_FORCE_UPDATE_RANGE                    2:2
#define EMC_DBG_0_FORCE_UPDATE_WOFFSET                  0x0
#define EMC_DBG_0_FORCE_UPDATE_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_DBG_0_FORCE_UPDATE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_DBG_0_FORCE_UPDATE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DBG_0_FORCE_UPDATE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DBG_0_FORCE_UPDATE_INIT_ENUM                        DISABLED
#define EMC_DBG_0_FORCE_UPDATE_DISABLED                 _MK_ENUM_CONST(0)
#define EMC_DBG_0_FORCE_UPDATE_ENABLED                  _MK_ENUM_CONST(1)

// should be set to MRS_256 when a non-mobile DRAM is used because they require a 200 cycle
// delay between the DLL reset and any read commands.
#define EMC_DBG_0_MRS_WAIT_SHIFT                        _MK_SHIFT_CONST(4)
#define EMC_DBG_0_MRS_WAIT_FIELD                        (_MK_MASK_CONST(0x1) << EMC_DBG_0_MRS_WAIT_SHIFT)
#define EMC_DBG_0_MRS_WAIT_RANGE                        4:4
#define EMC_DBG_0_MRS_WAIT_WOFFSET                      0x0
#define EMC_DBG_0_MRS_WAIT_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DBG_0_MRS_WAIT_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define EMC_DBG_0_MRS_WAIT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_DBG_0_MRS_WAIT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_DBG_0_MRS_WAIT_INIT_ENUM                    MRS_2
#define EMC_DBG_0_MRS_WAIT_MRS_2                        _MK_ENUM_CONST(0)
#define EMC_DBG_0_MRS_WAIT_MRS_256                      _MK_ENUM_CONST(1)

// specifies whether or not to periodic reset the FBIO read-data fifo during normal operation.
// The periodic resets can be used for graceful recovery from an intermittent failure condition;
// only the initial reset is absolutely required.
#define EMC_DBG_0_PERIODIC_QRST_SHIFT                   _MK_SHIFT_CONST(5)
#define EMC_DBG_0_PERIODIC_QRST_FIELD                   (_MK_MASK_CONST(0x1) << EMC_DBG_0_PERIODIC_QRST_SHIFT)
#define EMC_DBG_0_PERIODIC_QRST_RANGE                   5:5
#define EMC_DBG_0_PERIODIC_QRST_WOFFSET                 0x0
#define EMC_DBG_0_PERIODIC_QRST_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_DBG_0_PERIODIC_QRST_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define EMC_DBG_0_PERIODIC_QRST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DBG_0_PERIODIC_QRST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_DBG_0_PERIODIC_QRST_INIT_ENUM                       DISABLED
#define EMC_DBG_0_PERIODIC_QRST_DISABLED                        _MK_ENUM_CONST(0)
#define EMC_DBG_0_PERIODIC_QRST_ENABLED                 _MK_ENUM_CONST(1)

// controls whether the dqm signals during reads are managed for power (not relevant for DDR).
// If set to MANAGED, EMC only turns them on when necessary.  If set to ALWAYS_ON, the dqm signals are
// enabled during non-write operation.
#define EMC_DBG_0_READ_DQM_CTRL_SHIFT                   _MK_SHIFT_CONST(9)
#define EMC_DBG_0_READ_DQM_CTRL_FIELD                   (_MK_MASK_CONST(0x1) << EMC_DBG_0_READ_DQM_CTRL_SHIFT)
#define EMC_DBG_0_READ_DQM_CTRL_RANGE                   9:9
#define EMC_DBG_0_READ_DQM_CTRL_WOFFSET                 0x0
#define EMC_DBG_0_READ_DQM_CTRL_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_DBG_0_READ_DQM_CTRL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define EMC_DBG_0_READ_DQM_CTRL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DBG_0_READ_DQM_CTRL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_DBG_0_READ_DQM_CTRL_INIT_ENUM                       MANAGED
#define EMC_DBG_0_READ_DQM_CTRL_MANAGED                 _MK_ENUM_CONST(0)
#define EMC_DBG_0_READ_DQM_CTRL_ALWAYS_ON                       _MK_ENUM_CONST(1)

// determines whether the busy signal from the auto-precharge cancellation (APC) fifo
// is allowed to stall requests to the EMC.
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_SHIFT                        _MK_SHIFT_CONST(10)
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_FIELD                        (_MK_MASK_CONST(0x1) << EMC_DBG_0_AP_REQ_BUSY_CTRL_SHIFT)
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_RANGE                        10:10
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_WOFFSET                      0x0
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_DEFAULT                      _MK_MASK_CONST(0x1)
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_INIT_ENUM                    ENABLED
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_DISABLED                     _MK_ENUM_CONST(0)
#define EMC_DBG_0_AP_REQ_BUSY_CTRL_ENABLED                      _MK_ENUM_CONST(1)

// determines the priority of cfg accesses to the DRAM.  Setting this register to ENABLED
// gives DRAM config cycles (refresh, mrs, emrs, etc.) higher priority over real time requestors.
// The DISABLED setting gives the real time requestors higher priority than DRAM config cycles.
// Do not program to DISABLED unless for debugging.
#define EMC_DBG_0_CFG_PRIORITY_SHIFT                    _MK_SHIFT_CONST(24)
#define EMC_DBG_0_CFG_PRIORITY_FIELD                    (_MK_MASK_CONST(0x1) << EMC_DBG_0_CFG_PRIORITY_SHIFT)
#define EMC_DBG_0_CFG_PRIORITY_RANGE                    24:24
#define EMC_DBG_0_CFG_PRIORITY_WOFFSET                  0x0
#define EMC_DBG_0_CFG_PRIORITY_DEFAULT                  _MK_MASK_CONST(0x1)
#define EMC_DBG_0_CFG_PRIORITY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_DBG_0_CFG_PRIORITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DBG_0_CFG_PRIORITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DBG_0_CFG_PRIORITY_INIT_ENUM                        ENABLED
#define EMC_DBG_0_CFG_PRIORITY_DISABLED                 _MK_ENUM_CONST(0)
#define EMC_DBG_0_CFG_PRIORITY_ENABLED                  _MK_ENUM_CONST(1)


// Register EMC_CFG_0  // Configuration Register
#define EMC_CFG_0                       _MK_ADDR_CONST(0xc)
#define EMC_CFG_0_SECURE                        0x0
#define EMC_CFG_0_WORD_COUNT                    0x1
#define EMC_CFG_0_RESET_VAL                     _MK_MASK_CONST(0x300ff00)
#define EMC_CFG_0_RESET_MASK                    _MK_MASK_CONST(0xe301ff01)
#define EMC_CFG_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_CFG_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_CFG_0_READ_MASK                     _MK_MASK_CONST(0xe301ff01)
#define EMC_CFG_0_WRITE_MASK                    _MK_MASK_CONST(0xe301ff01)
// preemptively closes all of the banks after the EMC has been idle for PRE_IDLE_CYCLES cycles and
// there are banks open. PRE_IDLE_EN can be enabled if violating tRAS max is an issue.
#define EMC_CFG_0_PRE_IDLE_EN_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_CFG_0_PRE_IDLE_EN_FIELD                     (_MK_MASK_CONST(0x1) << EMC_CFG_0_PRE_IDLE_EN_SHIFT)
#define EMC_CFG_0_PRE_IDLE_EN_RANGE                     0:0
#define EMC_CFG_0_PRE_IDLE_EN_WOFFSET                   0x0
#define EMC_CFG_0_PRE_IDLE_EN_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_CFG_0_PRE_IDLE_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define EMC_CFG_0_PRE_IDLE_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_CFG_0_PRE_IDLE_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_CFG_0_PRE_IDLE_EN_INIT_ENUM                 DISABLED
#define EMC_CFG_0_PRE_IDLE_EN_DISABLED                  _MK_ENUM_CONST(0)
#define EMC_CFG_0_PRE_IDLE_EN_ENABLED                   _MK_ENUM_CONST(1)

// cycles after which an idle bank may be closed. Note that 0 is an illegal setting for PRE_IDLE_CYCLES.
#define EMC_CFG_0_PRE_IDLE_CYCLES_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_CFG_0_PRE_IDLE_CYCLES_FIELD                 (_MK_MASK_CONST(0xff) << EMC_CFG_0_PRE_IDLE_CYCLES_SHIFT)
#define EMC_CFG_0_PRE_IDLE_CYCLES_RANGE                 15:8
#define EMC_CFG_0_PRE_IDLE_CYCLES_WOFFSET                       0x0
#define EMC_CFG_0_PRE_IDLE_CYCLES_DEFAULT                       _MK_MASK_CONST(0xff)
#define EMC_CFG_0_PRE_IDLE_CYCLES_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_CFG_0_PRE_IDLE_CYCLES_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CFG_0_PRE_IDLE_CYCLES_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// used to try to clear the auto-precharge bit on the previous request if the next request
// is on the same page.  The previous request has to be in reach for this to happen.
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_SHIFT                     _MK_SHIFT_CONST(16)
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_FIELD                     (_MK_MASK_CONST(0x1) << EMC_CFG_0_CLEAR_AP_PREV_SPREQ_SHIFT)
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_RANGE                     16:16
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_WOFFSET                   0x0
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_INIT_ENUM                 DISABLED
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_DISABLED                  _MK_ENUM_CONST(0)
#define EMC_CFG_0_CLEAR_AP_PREV_SPREQ_ENABLED                   _MK_ENUM_CONST(1)

// enable auto-precharge in the EMC for reads. This bits, when set to DISABLE, will override the settings in the MC
// register. Otherwise, they permit clients to make auto-precharge requests as specified by the Memory Controller.
#define EMC_CFG_0_AUTO_PRE_RD_SHIFT                     _MK_SHIFT_CONST(24)
#define EMC_CFG_0_AUTO_PRE_RD_FIELD                     (_MK_MASK_CONST(0x1) << EMC_CFG_0_AUTO_PRE_RD_SHIFT)
#define EMC_CFG_0_AUTO_PRE_RD_RANGE                     24:24
#define EMC_CFG_0_AUTO_PRE_RD_WOFFSET                   0x0
#define EMC_CFG_0_AUTO_PRE_RD_DEFAULT                   _MK_MASK_CONST(0x1)
#define EMC_CFG_0_AUTO_PRE_RD_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define EMC_CFG_0_AUTO_PRE_RD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_CFG_0_AUTO_PRE_RD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_CFG_0_AUTO_PRE_RD_INIT_ENUM                 ENABLED
#define EMC_CFG_0_AUTO_PRE_RD_DISABLED                  _MK_ENUM_CONST(0)
#define EMC_CFG_0_AUTO_PRE_RD_ENABLED                   _MK_ENUM_CONST(1)

// enable auto-precharge in the EMC for writes. This bits, when set to DISABLE, will override the settings in the MC
// register. Otherwise, they permit clients to make auto-precharge requests as specified by the Memory Controller.
#define EMC_CFG_0_AUTO_PRE_WR_SHIFT                     _MK_SHIFT_CONST(25)
#define EMC_CFG_0_AUTO_PRE_WR_FIELD                     (_MK_MASK_CONST(0x1) << EMC_CFG_0_AUTO_PRE_WR_SHIFT)
#define EMC_CFG_0_AUTO_PRE_WR_RANGE                     25:25
#define EMC_CFG_0_AUTO_PRE_WR_WOFFSET                   0x0
#define EMC_CFG_0_AUTO_PRE_WR_DEFAULT                   _MK_MASK_CONST(0x1)
#define EMC_CFG_0_AUTO_PRE_WR_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define EMC_CFG_0_AUTO_PRE_WR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_CFG_0_AUTO_PRE_WR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_CFG_0_AUTO_PRE_WR_INIT_ENUM                 ENABLED
#define EMC_CFG_0_AUTO_PRE_WR_DISABLED                  _MK_ENUM_CONST(0)
#define EMC_CFG_0_AUTO_PRE_WR_ENABLED                   _MK_ENUM_CONST(1)

// allows the DRAM controller to perform opportunistic active powerdown control using the CKE
// pin on the DRAM. The behavior of the powerdown control logic is controlled by the PDEX2* and *2PDEN
// registers. The value of DRAM_ACPD should only be changed when CKE is low, e.g., during software-controlled
// self-refresh or before DRAM initialization.
// If enabling ACPD, you should ALWAYS enable DRAM_CLKSTOP_PDSR_ONLY.
// Not doing so will result in sub-optimal power-down & clockstop performance.  The powerdown conditions are
// met within a couple of cycles after the clock has stopped, so the clock must be restarted & minimum clock
// timings met before powerdown can be issued and clock restopped.
#define EMC_CFG_0_DRAM_ACPD_SHIFT                       _MK_SHIFT_CONST(29)
#define EMC_CFG_0_DRAM_ACPD_FIELD                       (_MK_MASK_CONST(0x1) << EMC_CFG_0_DRAM_ACPD_SHIFT)
#define EMC_CFG_0_DRAM_ACPD_RANGE                       29:29
#define EMC_CFG_0_DRAM_ACPD_WOFFSET                     0x0
#define EMC_CFG_0_DRAM_ACPD_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_CFG_0_DRAM_ACPD_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define EMC_CFG_0_DRAM_ACPD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CFG_0_DRAM_ACPD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_CFG_0_DRAM_ACPD_INIT_ENUM                   NO_POWERDOWN
#define EMC_CFG_0_DRAM_ACPD_NO_POWERDOWN                        _MK_ENUM_CONST(0)
#define EMC_CFG_0_DRAM_ACPD_ACTIVE_POWERDOWN                    _MK_ENUM_CONST(1)

// clockstop (if enabled) only allowed to happen if CKE=0 (for all CKE bits associated w/ clock)
#define EMC_CFG_0_DRAM_CLKSTOP_PDSR_ONLY_SHIFT                  _MK_SHIFT_CONST(30)
#define EMC_CFG_0_DRAM_CLKSTOP_PDSR_ONLY_FIELD                  (_MK_MASK_CONST(0x1) << EMC_CFG_0_DRAM_CLKSTOP_PDSR_ONLY_SHIFT)
#define EMC_CFG_0_DRAM_CLKSTOP_PDSR_ONLY_RANGE                  30:30
#define EMC_CFG_0_DRAM_CLKSTOP_PDSR_ONLY_WOFFSET                        0x0
#define EMC_CFG_0_DRAM_CLKSTOP_PDSR_ONLY_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_CFG_0_DRAM_CLKSTOP_PDSR_ONLY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define EMC_CFG_0_DRAM_CLKSTOP_PDSR_ONLY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_CFG_0_DRAM_CLKSTOP_PDSR_ONLY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_CFG_0_DRAM_CLKSTOP_PDSR_ONLY_INIT_ENUM                      DISABLED
#define EMC_CFG_0_DRAM_CLKSTOP_PDSR_ONLY_DISABLED                       _MK_ENUM_CONST(0)
#define EMC_CFG_0_DRAM_CLKSTOP_PDSR_ONLY_ENABLED                        _MK_ENUM_CONST(1)

// allows the DRAM controller to turn off the clock to the DRAM when it is safe to do so
// (no operations are ongoing, and tRFC, tMRS, tRP, etc. have all been satisfied).
#define EMC_CFG_0_DRAM_CLKSTOP_SHIFT                    _MK_SHIFT_CONST(31)
#define EMC_CFG_0_DRAM_CLKSTOP_FIELD                    (_MK_MASK_CONST(0x1) << EMC_CFG_0_DRAM_CLKSTOP_SHIFT)
#define EMC_CFG_0_DRAM_CLKSTOP_RANGE                    31:31
#define EMC_CFG_0_DRAM_CLKSTOP_WOFFSET                  0x0
#define EMC_CFG_0_DRAM_CLKSTOP_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CFG_0_DRAM_CLKSTOP_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_CFG_0_DRAM_CLKSTOP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CFG_0_DRAM_CLKSTOP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_CFG_0_DRAM_CLKSTOP_INIT_ENUM                        DISABLED
#define EMC_CFG_0_DRAM_CLKSTOP_DISABLED                 _MK_ENUM_CONST(0)
#define EMC_CFG_0_DRAM_CLKSTOP_ENABLED                  _MK_ENUM_CONST(1)


// Register EMC_ADR_CFG_0  // External memory address config Register
#define EMC_ADR_CFG_0                   _MK_ADDR_CONST(0x10)
#define EMC_ADR_CFG_0_SECURE                    0x0
#define EMC_ADR_CFG_0_WORD_COUNT                        0x1
#define EMC_ADR_CFG_0_RESET_VAL                         _MK_MASK_CONST(0x40202)
#define EMC_ADR_CFG_0_RESET_MASK                        _MK_MASK_CONST(0x30f0307)
#define EMC_ADR_CFG_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_READ_MASK                         _MK_MASK_CONST(0x30f0307)
#define EMC_ADR_CFG_0_WRITE_MASK                        _MK_MASK_CONST(0x30f0307)
// width of column address of the attached SDRAM device.
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_FIELD                       (_MK_MASK_CONST(0x7) << EMC_ADR_CFG_0_EMEM_COLWIDTH_SHIFT)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_RANGE                       2:0
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_WOFFSET                     0x0
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_DEFAULT                     _MK_MASK_CONST(0x2)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_INIT_ENUM                   W9
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_W7                  _MK_ENUM_CONST(0)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_W8                  _MK_ENUM_CONST(1)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_W9                  _MK_ENUM_CONST(2)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_W10                 _MK_ENUM_CONST(3)
#define EMC_ADR_CFG_0_EMEM_COLWIDTH_W11                 _MK_ENUM_CONST(4)

// width of bank address of the attached SDRAM device.
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_SHIFT                      _MK_SHIFT_CONST(8)
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_FIELD                      (_MK_MASK_CONST(0x3) << EMC_ADR_CFG_0_EMEM_BANKWIDTH_SHIFT)
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_RANGE                      9:8
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_WOFFSET                    0x0
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_DEFAULT                    _MK_MASK_CONST(0x2)
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_INIT_ENUM                  W2
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_W1                 _MK_ENUM_CONST(1)
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_W2                 _MK_ENUM_CONST(2)
#define EMC_ADR_CFG_0_EMEM_BANKWIDTH_W3                 _MK_ENUM_CONST(3)

// size of the attached SDRAM device used to generate width of row address.
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_SHIFT                        _MK_SHIFT_CONST(16)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_FIELD                        (_MK_MASK_CONST(0xf) << EMC_ADR_CFG_0_EMEM_DEVSIZE_SHIFT)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_RANGE                        19:16
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_WOFFSET                      0x0
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_DEFAULT                      _MK_MASK_CONST(0x4)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_INIT_ENUM                    D64MB
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D4MB                 _MK_ENUM_CONST(0)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D8MB                 _MK_ENUM_CONST(1)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D16MB                        _MK_ENUM_CONST(2)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D32MB                        _MK_ENUM_CONST(3)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D64MB                        _MK_ENUM_CONST(4)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D128MB                       _MK_ENUM_CONST(5)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D256MB                       _MK_ENUM_CONST(6)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D512MB                       _MK_ENUM_CONST(7)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D1024MB                      _MK_ENUM_CONST(8)
#define EMC_ADR_CFG_0_EMEM_DEVSIZE_D1GB                 _MK_ENUM_CONST(8)

// the number of attached devices.
// If more than one device is attached, the DEVSIZE, COLWIDTH, and BANKWIDTH configurations for the second device
// will be defined by the fields in ADR_CFG_1, while the fields in ADR_CFG will only apply to the first device.
#define EMC_ADR_CFG_0_EMEM_NUMDEV_SHIFT                 _MK_SHIFT_CONST(24)
#define EMC_ADR_CFG_0_EMEM_NUMDEV_FIELD                 (_MK_MASK_CONST(0x3) << EMC_ADR_CFG_0_EMEM_NUMDEV_SHIFT)
#define EMC_ADR_CFG_0_EMEM_NUMDEV_RANGE                 25:24
#define EMC_ADR_CFG_0_EMEM_NUMDEV_WOFFSET                       0x0
#define EMC_ADR_CFG_0_EMEM_NUMDEV_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_NUMDEV_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define EMC_ADR_CFG_0_EMEM_NUMDEV_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_NUMDEV_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_0_EMEM_NUMDEV_INIT_ENUM                     N1
#define EMC_ADR_CFG_0_EMEM_NUMDEV_N1                    _MK_ENUM_CONST(0)
#define EMC_ADR_CFG_0_EMEM_NUMDEV_N2                    _MK_ENUM_CONST(1)


// Register EMC_ADR_CFG_1_0  // External memory address config Register, Device[1]
#define EMC_ADR_CFG_1_0                 _MK_ADDR_CONST(0x14)
#define EMC_ADR_CFG_1_0_SECURE                  0x0
#define EMC_ADR_CFG_1_0_WORD_COUNT                      0x1
#define EMC_ADR_CFG_1_0_RESET_VAL                       _MK_MASK_CONST(0x40202)
#define EMC_ADR_CFG_1_0_RESET_MASK                      _MK_MASK_CONST(0xf0307)
#define EMC_ADR_CFG_1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_1_0_READ_MASK                       _MK_MASK_CONST(0xf0307)
#define EMC_ADR_CFG_1_0_WRITE_MASK                      _MK_MASK_CONST(0xf0307)
// width of column address of the attached SDRAM device.
#define EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_SHIFT                    _MK_SHIFT_CONST(0)
#define EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_FIELD                    (_MK_MASK_CONST(0x7) << EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_SHIFT)
#define EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_RANGE                    2:0
#define EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_WOFFSET                  0x0
#define EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_DEFAULT                  _MK_MASK_CONST(0x2)
#define EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_INIT_ENUM                        W9
#define EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_W7                       _MK_ENUM_CONST(0)
#define EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_W8                       _MK_ENUM_CONST(1)
#define EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_W9                       _MK_ENUM_CONST(2)
#define EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_W10                      _MK_ENUM_CONST(3)
#define EMC_ADR_CFG_1_0_EMEM1_COLWIDTH_W11                      _MK_ENUM_CONST(4)

// width of bank address of the attached SDRAM device.
#define EMC_ADR_CFG_1_0_EMEM1_BANKWIDTH_SHIFT                   _MK_SHIFT_CONST(8)
#define EMC_ADR_CFG_1_0_EMEM1_BANKWIDTH_FIELD                   (_MK_MASK_CONST(0x3) << EMC_ADR_CFG_1_0_EMEM1_BANKWIDTH_SHIFT)
#define EMC_ADR_CFG_1_0_EMEM1_BANKWIDTH_RANGE                   9:8
#define EMC_ADR_CFG_1_0_EMEM1_BANKWIDTH_WOFFSET                 0x0
#define EMC_ADR_CFG_1_0_EMEM1_BANKWIDTH_DEFAULT                 _MK_MASK_CONST(0x2)
#define EMC_ADR_CFG_1_0_EMEM1_BANKWIDTH_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define EMC_ADR_CFG_1_0_EMEM1_BANKWIDTH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_1_0_EMEM1_BANKWIDTH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_1_0_EMEM1_BANKWIDTH_INIT_ENUM                       W2
#define EMC_ADR_CFG_1_0_EMEM1_BANKWIDTH_W1                      _MK_ENUM_CONST(1)
#define EMC_ADR_CFG_1_0_EMEM1_BANKWIDTH_W2                      _MK_ENUM_CONST(2)
#define EMC_ADR_CFG_1_0_EMEM1_BANKWIDTH_W3                      _MK_ENUM_CONST(3)

// size of the attached SDRAM device used to generate width of row address.
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_SHIFT                     _MK_SHIFT_CONST(16)
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_FIELD                     (_MK_MASK_CONST(0xf) << EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_SHIFT)
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_RANGE                     19:16
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_WOFFSET                   0x0
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_DEFAULT                   _MK_MASK_CONST(0x4)
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_INIT_ENUM                 D64MB
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_D4MB                      _MK_ENUM_CONST(0)
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_D8MB                      _MK_ENUM_CONST(1)
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_D16MB                     _MK_ENUM_CONST(2)
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_D32MB                     _MK_ENUM_CONST(3)
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_D64MB                     _MK_ENUM_CONST(4)
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_D128MB                    _MK_ENUM_CONST(5)
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_D256MB                    _MK_ENUM_CONST(6)
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_D512MB                    _MK_ENUM_CONST(7)
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_D1024MB                   _MK_ENUM_CONST(8)
#define EMC_ADR_CFG_1_0_EMEM1_DEVSIZE_D1GB                      _MK_ENUM_CONST(8)


// Reserved address 24 [0x18] 

// Reserved address 28 [0x1c] 

// Register EMC_REFCTRL_0  // Refresh Control Register
#define EMC_REFCTRL_0                   _MK_ADDR_CONST(0x20)
#define EMC_REFCTRL_0_SECURE                    0x0
#define EMC_REFCTRL_0_WORD_COUNT                        0x1
#define EMC_REFCTRL_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_REFCTRL_0_RESET_MASK                        _MK_MASK_CONST(0x80000003)
#define EMC_REFCTRL_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_REFCTRL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_REFCTRL_0_READ_MASK                         _MK_MASK_CONST(0x80000003)
#define EMC_REFCTRL_0_WRITE_MASK                        _MK_MASK_CONST(0x80000003)
// disables refresh to individual attached device (1 bit per dram chip-select).
#define EMC_REFCTRL_0_DEVICE_REFRESH_DISABLE_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC_REFCTRL_0_DEVICE_REFRESH_DISABLE_FIELD                      (_MK_MASK_CONST(0x3) << EMC_REFCTRL_0_DEVICE_REFRESH_DISABLE_SHIFT)
#define EMC_REFCTRL_0_DEVICE_REFRESH_DISABLE_RANGE                      1:0
#define EMC_REFCTRL_0_DEVICE_REFRESH_DISABLE_WOFFSET                    0x0
#define EMC_REFCTRL_0_DEVICE_REFRESH_DISABLE_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_REFCTRL_0_DEVICE_REFRESH_DISABLE_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define EMC_REFCTRL_0_DEVICE_REFRESH_DISABLE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_REFCTRL_0_DEVICE_REFRESH_DISABLE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// enable refresh controller. 
#define EMC_REFCTRL_0_REF_VALID_SHIFT                   _MK_SHIFT_CONST(31)
#define EMC_REFCTRL_0_REF_VALID_FIELD                   (_MK_MASK_CONST(0x1) << EMC_REFCTRL_0_REF_VALID_SHIFT)
#define EMC_REFCTRL_0_REF_VALID_RANGE                   31:31
#define EMC_REFCTRL_0_REF_VALID_WOFFSET                 0x0
#define EMC_REFCTRL_0_REF_VALID_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_REFCTRL_0_REF_VALID_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define EMC_REFCTRL_0_REF_VALID_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_REFCTRL_0_REF_VALID_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_REFCTRL_0_REF_VALID_INIT_ENUM                       DISABLED
#define EMC_REFCTRL_0_REF_VALID_DISABLED                        _MK_ENUM_CONST(0)
#define EMC_REFCTRL_0_REF_VALID_ENABLED                 _MK_ENUM_CONST(1)


// Register EMC_PIN_0  // Controls state of selected DRAM pins
#define EMC_PIN_0                       _MK_ADDR_CONST(0x24)
#define EMC_PIN_0_SECURE                        0x0
#define EMC_PIN_0_WORD_COUNT                    0x1
#define EMC_PIN_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_PIN_0_RESET_MASK                    _MK_MASK_CONST(0x11)
#define EMC_PIN_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_PIN_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_PIN_0_READ_MASK                     _MK_MASK_CONST(0x11)
#define EMC_PIN_0_WRITE_MASK                    _MK_MASK_CONST(0x11)
// selects the level of the CKE pin.
// This can be used to place the DRAM in power down state.  PIN_CKE value is applied all CKE pins.
#define EMC_PIN_0_PIN_CKE_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_PIN_0_PIN_CKE_FIELD                 (_MK_MASK_CONST(0x1) << EMC_PIN_0_PIN_CKE_SHIFT)
#define EMC_PIN_0_PIN_CKE_RANGE                 0:0
#define EMC_PIN_0_PIN_CKE_WOFFSET                       0x0
#define EMC_PIN_0_PIN_CKE_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_PIN_0_PIN_CKE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_PIN_0_PIN_CKE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_PIN_0_PIN_CKE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_PIN_0_PIN_CKE_INIT_ENUM                     POWERDOWN
#define EMC_PIN_0_PIN_CKE_POWERDOWN                     _MK_ENUM_CONST(0)
#define EMC_PIN_0_PIN_CKE_NORMAL                        _MK_ENUM_CONST(1)

// is used to always mask DRAM writes.
// This pin should only be used for initialization.  Certain DRAM vendors (e.g., Samsung),
// require the DQM to be high during initialization.  The register value should be set to NORMAL
// after the initialization sequence.
#define EMC_PIN_0_PIN_DQM_SHIFT                 _MK_SHIFT_CONST(4)
#define EMC_PIN_0_PIN_DQM_FIELD                 (_MK_MASK_CONST(0x1) << EMC_PIN_0_PIN_DQM_SHIFT)
#define EMC_PIN_0_PIN_DQM_RANGE                 4:4
#define EMC_PIN_0_PIN_DQM_WOFFSET                       0x0
#define EMC_PIN_0_PIN_DQM_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_PIN_0_PIN_DQM_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_PIN_0_PIN_DQM_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_PIN_0_PIN_DQM_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_PIN_0_PIN_DQM_INIT_ENUM                     NORMAL
#define EMC_PIN_0_PIN_DQM_NORMAL                        _MK_ENUM_CONST(0)
#define EMC_PIN_0_PIN_DQM_INACTIVE                      _MK_ENUM_CONST(1)


// Register EMC_TIMING_CONTROL_0  // Triggers an update of the timing-related registers
#define EMC_TIMING_CONTROL_0                    _MK_ADDR_CONST(0x28)
#define EMC_TIMING_CONTROL_0_SECURE                     0x0
#define EMC_TIMING_CONTROL_0_WORD_COUNT                         0x1
#define EMC_TIMING_CONTROL_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_TIMING_CONTROL_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define EMC_TIMING_CONTROL_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_TIMING_CONTROL_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_TIMING_CONTROL_0_READ_MASK                  _MK_MASK_CONST(0x1)
#define EMC_TIMING_CONTROL_0_WRITE_MASK                         _MK_MASK_CONST(0x1)
#define EMC_TIMING_CONTROL_0_TIMING_UPDATE_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_TIMING_CONTROL_0_TIMING_UPDATE_FIELD                        (_MK_MASK_CONST(0x1) << EMC_TIMING_CONTROL_0_TIMING_UPDATE_SHIFT)
#define EMC_TIMING_CONTROL_0_TIMING_UPDATE_RANGE                        0:0
#define EMC_TIMING_CONTROL_0_TIMING_UPDATE_WOFFSET                      0x0
#define EMC_TIMING_CONTROL_0_TIMING_UPDATE_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_TIMING_CONTROL_0_TIMING_UPDATE_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_TIMING_CONTROL_0_TIMING_UPDATE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_TIMING_CONTROL_0_TIMING_UPDATE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register EMC_RC_0  // DRAM timing parameter
#define EMC_RC_0                        _MK_ADDR_CONST(0x2c)
#define EMC_RC_0_SECURE                         0x0
#define EMC_RC_0_WORD_COUNT                     0x1
#define EMC_RC_0_RESET_VAL                      _MK_MASK_CONST(0x3f)
#define EMC_RC_0_RESET_MASK                     _MK_MASK_CONST(0x3f)
#define EMC_RC_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_RC_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_RC_0_READ_MASK                      _MK_MASK_CONST(0x3f)
#define EMC_RC_0_WRITE_MASK                     _MK_MASK_CONST(0x3f)
// specifies the row cycle time.
// This is the minimum number of cycles between activate commands to the same bank.
#define EMC_RC_0_RC_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_RC_0_RC_FIELD                       (_MK_MASK_CONST(0x3f) << EMC_RC_0_RC_SHIFT)
#define EMC_RC_0_RC_RANGE                       5:0
#define EMC_RC_0_RC_WOFFSET                     0x0
#define EMC_RC_0_RC_DEFAULT                     _MK_MASK_CONST(0x3f)
#define EMC_RC_0_RC_DEFAULT_MASK                        _MK_MASK_CONST(0x3f)
#define EMC_RC_0_RC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_RC_0_RC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_RFC_0  // DRAM timing parameter
#define EMC_RFC_0                       _MK_ADDR_CONST(0x30)
#define EMC_RFC_0_SECURE                        0x0
#define EMC_RFC_0_WORD_COUNT                    0x1
#define EMC_RFC_0_RESET_VAL                     _MK_MASK_CONST(0x3f)
#define EMC_RFC_0_RESET_MASK                    _MK_MASK_CONST(0x1ff)
#define EMC_RFC_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_RFC_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_RFC_0_READ_MASK                     _MK_MASK_CONST(0x1ff)
#define EMC_RFC_0_WRITE_MASK                    _MK_MASK_CONST(0x1ff)
// specifies the auto refresh cycle time.
// This is the minimum number of cycles between an auto refresh command and a subsequent auto refresh
// or activate command.
#define EMC_RFC_0_RFC_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_RFC_0_RFC_FIELD                     (_MK_MASK_CONST(0x1ff) << EMC_RFC_0_RFC_SHIFT)
#define EMC_RFC_0_RFC_RANGE                     8:0
#define EMC_RFC_0_RFC_WOFFSET                   0x0
#define EMC_RFC_0_RFC_DEFAULT                   _MK_MASK_CONST(0x3f)
#define EMC_RFC_0_RFC_DEFAULT_MASK                      _MK_MASK_CONST(0x1ff)
#define EMC_RFC_0_RFC_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_RFC_0_RFC_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_RAS_0  // DRAM timing parameter
#define EMC_RAS_0                       _MK_ADDR_CONST(0x34)
#define EMC_RAS_0_SECURE                        0x0
#define EMC_RAS_0_WORD_COUNT                    0x1
#define EMC_RAS_0_RESET_VAL                     _MK_MASK_CONST(0x3f)
#define EMC_RAS_0_RESET_MASK                    _MK_MASK_CONST(0x3f)
#define EMC_RAS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_RAS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_RAS_0_READ_MASK                     _MK_MASK_CONST(0x3f)
#define EMC_RAS_0_WRITE_MASK                    _MK_MASK_CONST(0x3f)
// specifies the row active time. 
// This is the minimum number of cycles between an activate command and a precharge command to the same bank.
#define EMC_RAS_0_RAS_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_RAS_0_RAS_FIELD                     (_MK_MASK_CONST(0x3f) << EMC_RAS_0_RAS_SHIFT)
#define EMC_RAS_0_RAS_RANGE                     5:0
#define EMC_RAS_0_RAS_WOFFSET                   0x0
#define EMC_RAS_0_RAS_DEFAULT                   _MK_MASK_CONST(0x3f)
#define EMC_RAS_0_RAS_DEFAULT_MASK                      _MK_MASK_CONST(0x3f)
#define EMC_RAS_0_RAS_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_RAS_0_RAS_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_RP_0  // DRAM timing parameter
#define EMC_RP_0                        _MK_ADDR_CONST(0x38)
#define EMC_RP_0_SECURE                         0x0
#define EMC_RP_0_WORD_COUNT                     0x1
#define EMC_RP_0_RESET_VAL                      _MK_MASK_CONST(0x3f)
#define EMC_RP_0_RESET_MASK                     _MK_MASK_CONST(0x3f)
#define EMC_RP_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_RP_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_RP_0_READ_MASK                      _MK_MASK_CONST(0x3f)
#define EMC_RP_0_WRITE_MASK                     _MK_MASK_CONST(0x3f)
// specifies the row precharge time.
// This is the minimum number of cycles between a precharge command and an activate command to the same bank.
#define EMC_RP_0_RP_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_RP_0_RP_FIELD                       (_MK_MASK_CONST(0x3f) << EMC_RP_0_RP_SHIFT)
#define EMC_RP_0_RP_RANGE                       5:0
#define EMC_RP_0_RP_WOFFSET                     0x0
#define EMC_RP_0_RP_DEFAULT                     _MK_MASK_CONST(0x3f)
#define EMC_RP_0_RP_DEFAULT_MASK                        _MK_MASK_CONST(0x3f)
#define EMC_RP_0_RP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_RP_0_RP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_R2W_0  // DRAM timing parameter
#define EMC_R2W_0                       _MK_ADDR_CONST(0x3c)
#define EMC_R2W_0_SECURE                        0x0
#define EMC_R2W_0_WORD_COUNT                    0x1
#define EMC_R2W_0_RESET_VAL                     _MK_MASK_CONST(0x1f)
#define EMC_R2W_0_RESET_MASK                    _MK_MASK_CONST(0x1f)
#define EMC_R2W_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_R2W_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_R2W_0_READ_MASK                     _MK_MASK_CONST(0x1f)
#define EMC_R2W_0_WRITE_MASK                    _MK_MASK_CONST(0x1f)
// specifies the minimum number of cycles from any read command to any write command,
// irrespective of bank.  This parameter guarantees the read->write turn-around time on the bus.
// Set to ((CL+1)-WL + R2W_bus_turnaround_clks). If ODT is enabled,  set to ((CL+1)-WL + R2W_bus_turnaround_clks + 1)).
// Largest programming value is 29
#define EMC_R2W_0_R2W_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_R2W_0_R2W_FIELD                     (_MK_MASK_CONST(0x1f) << EMC_R2W_0_R2W_SHIFT)
#define EMC_R2W_0_R2W_RANGE                     4:0
#define EMC_R2W_0_R2W_WOFFSET                   0x0
#define EMC_R2W_0_R2W_DEFAULT                   _MK_MASK_CONST(0x1f)
#define EMC_R2W_0_R2W_DEFAULT_MASK                      _MK_MASK_CONST(0x1f)
#define EMC_R2W_0_R2W_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_R2W_0_R2W_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_W2R_0  // DRAM timing parameter
#define EMC_W2R_0                       _MK_ADDR_CONST(0x40)
#define EMC_W2R_0_SECURE                        0x0
#define EMC_W2R_0_WORD_COUNT                    0x1
#define EMC_W2R_0_RESET_VAL                     _MK_MASK_CONST(0x1f)
#define EMC_W2R_0_RESET_MASK                    _MK_MASK_CONST(0x1f)
#define EMC_W2R_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_W2R_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_W2R_0_READ_MASK                     _MK_MASK_CONST(0x1f)
#define EMC_W2R_0_WRITE_MASK                    _MK_MASK_CONST(0x1f)
// specifies the minimum number of cycles from a write command to a read command,
// irrespective of bank. Set to ((WL+1) + tWTR).
// Largest programming value is 29
#define EMC_W2R_0_W2R_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_W2R_0_W2R_FIELD                     (_MK_MASK_CONST(0x1f) << EMC_W2R_0_W2R_SHIFT)
#define EMC_W2R_0_W2R_RANGE                     4:0
#define EMC_W2R_0_W2R_WOFFSET                   0x0
#define EMC_W2R_0_W2R_DEFAULT                   _MK_MASK_CONST(0x1f)
#define EMC_W2R_0_W2R_DEFAULT_MASK                      _MK_MASK_CONST(0x1f)
#define EMC_W2R_0_W2R_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_W2R_0_W2R_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_R2P_0  // DRAM timing parameter
#define EMC_R2P_0                       _MK_ADDR_CONST(0x44)
#define EMC_R2P_0_SECURE                        0x0
#define EMC_R2P_0_WORD_COUNT                    0x1
#define EMC_R2P_0_RESET_VAL                     _MK_MASK_CONST(0x1f)
#define EMC_R2P_0_RESET_MASK                    _MK_MASK_CONST(0x1f)
#define EMC_R2P_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_R2P_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_R2P_0_READ_MASK                     _MK_MASK_CONST(0x1f)
#define EMC_R2P_0_WRITE_MASK                    _MK_MASK_CONST(0x1f)
// specifies the minimum number of cycles from a read command to
// a precharge command for the same bank.  Set to 1 clock.
#define EMC_R2P_0_R2P_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_R2P_0_R2P_FIELD                     (_MK_MASK_CONST(0x1f) << EMC_R2P_0_R2P_SHIFT)
#define EMC_R2P_0_R2P_RANGE                     4:0
#define EMC_R2P_0_R2P_WOFFSET                   0x0
#define EMC_R2P_0_R2P_DEFAULT                   _MK_MASK_CONST(0x1f)
#define EMC_R2P_0_R2P_DEFAULT_MASK                      _MK_MASK_CONST(0x1f)
#define EMC_R2P_0_R2P_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_R2P_0_R2P_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_W2P_0  // DRAM timing parameter
#define EMC_W2P_0                       _MK_ADDR_CONST(0x48)
#define EMC_W2P_0_SECURE                        0x0
#define EMC_W2P_0_WORD_COUNT                    0x1
#define EMC_W2P_0_RESET_VAL                     _MK_MASK_CONST(0x1f)
#define EMC_W2P_0_RESET_MASK                    _MK_MASK_CONST(0x1f)
#define EMC_W2P_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_W2P_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_W2P_0_READ_MASK                     _MK_MASK_CONST(0x1f)
#define EMC_W2P_0_WRITE_MASK                    _MK_MASK_CONST(0x1f)
// specifies the minimum number of cycles from a write command to
// a precharge command for the same bank. Set to ((WL+1) + tWR).
#define EMC_W2P_0_W2P_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_W2P_0_W2P_FIELD                     (_MK_MASK_CONST(0x1f) << EMC_W2P_0_W2P_SHIFT)
#define EMC_W2P_0_W2P_RANGE                     4:0
#define EMC_W2P_0_W2P_WOFFSET                   0x0
#define EMC_W2P_0_W2P_DEFAULT                   _MK_MASK_CONST(0x1f)
#define EMC_W2P_0_W2P_DEFAULT_MASK                      _MK_MASK_CONST(0x1f)
#define EMC_W2P_0_W2P_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_W2P_0_W2P_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_RD_RCD_0  // DRAM timing parameter
#define EMC_RD_RCD_0                    _MK_ADDR_CONST(0x4c)
#define EMC_RD_RCD_0_SECURE                     0x0
#define EMC_RD_RCD_0_WORD_COUNT                         0x1
#define EMC_RD_RCD_0_RESET_VAL                  _MK_MASK_CONST(0x1f)
#define EMC_RD_RCD_0_RESET_MASK                         _MK_MASK_CONST(0x3f)
#define EMC_RD_RCD_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_RD_RCD_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_RD_RCD_0_READ_MASK                  _MK_MASK_CONST(0x3f)
#define EMC_RD_RCD_0_WRITE_MASK                         _MK_MASK_CONST(0x3f)
// specifies the ras to cas delay.
// RD_RCD is the minimum number of cycles between an activate command and a read command to the same bank.
#define EMC_RD_RCD_0_RD_RCD_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_RD_RCD_0_RD_RCD_FIELD                       (_MK_MASK_CONST(0x3f) << EMC_RD_RCD_0_RD_RCD_SHIFT)
#define EMC_RD_RCD_0_RD_RCD_RANGE                       5:0
#define EMC_RD_RCD_0_RD_RCD_WOFFSET                     0x0
#define EMC_RD_RCD_0_RD_RCD_DEFAULT                     _MK_MASK_CONST(0x1f)
#define EMC_RD_RCD_0_RD_RCD_DEFAULT_MASK                        _MK_MASK_CONST(0x3f)
#define EMC_RD_RCD_0_RD_RCD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_RD_RCD_0_RD_RCD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_WR_RCD_0  // DRAM timing parameter
#define EMC_WR_RCD_0                    _MK_ADDR_CONST(0x50)
#define EMC_WR_RCD_0_SECURE                     0x0
#define EMC_WR_RCD_0_WORD_COUNT                         0x1
#define EMC_WR_RCD_0_RESET_VAL                  _MK_MASK_CONST(0x1f)
#define EMC_WR_RCD_0_RESET_MASK                         _MK_MASK_CONST(0x3f)
#define EMC_WR_RCD_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_WR_RCD_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_WR_RCD_0_READ_MASK                  _MK_MASK_CONST(0x3f)
#define EMC_WR_RCD_0_WRITE_MASK                         _MK_MASK_CONST(0x3f)
// minimum number of cycles between an activate command and a
// write command to the same bank.
#define EMC_WR_RCD_0_WR_RCD_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_WR_RCD_0_WR_RCD_FIELD                       (_MK_MASK_CONST(0x3f) << EMC_WR_RCD_0_WR_RCD_SHIFT)
#define EMC_WR_RCD_0_WR_RCD_RANGE                       5:0
#define EMC_WR_RCD_0_WR_RCD_WOFFSET                     0x0
#define EMC_WR_RCD_0_WR_RCD_DEFAULT                     _MK_MASK_CONST(0x1f)
#define EMC_WR_RCD_0_WR_RCD_DEFAULT_MASK                        _MK_MASK_CONST(0x3f)
#define EMC_WR_RCD_0_WR_RCD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_WR_RCD_0_WR_RCD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_RRD_0  // DRAM timing parameter
#define EMC_RRD_0                       _MK_ADDR_CONST(0x54)
#define EMC_RRD_0_SECURE                        0x0
#define EMC_RRD_0_WORD_COUNT                    0x1
#define EMC_RRD_0_RESET_VAL                     _MK_MASK_CONST(0xf)
#define EMC_RRD_0_RESET_MASK                    _MK_MASK_CONST(0xf)
#define EMC_RRD_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_RRD_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_RRD_0_READ_MASK                     _MK_MASK_CONST(0xf)
#define EMC_RRD_0_WRITE_MASK                    _MK_MASK_CONST(0xf)
// specifies the Bank X Act to Bank Y Act command delay.
#define EMC_RRD_0_RRD_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_RRD_0_RRD_FIELD                     (_MK_MASK_CONST(0xf) << EMC_RRD_0_RRD_SHIFT)
#define EMC_RRD_0_RRD_RANGE                     3:0
#define EMC_RRD_0_RRD_WOFFSET                   0x0
#define EMC_RRD_0_RRD_DEFAULT                   _MK_MASK_CONST(0xf)
#define EMC_RRD_0_RRD_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define EMC_RRD_0_RRD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_RRD_0_RRD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_REXT_0  // DRAM timing parameter
#define EMC_REXT_0                      _MK_ADDR_CONST(0x58)
#define EMC_REXT_0_SECURE                       0x0
#define EMC_REXT_0_WORD_COUNT                   0x1
#define EMC_REXT_0_RESET_VAL                    _MK_MASK_CONST(0x1)
#define EMC_REXT_0_RESET_MASK                   _MK_MASK_CONST(0xf)
#define EMC_REXT_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_REXT_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_REXT_0_READ_MASK                    _MK_MASK_CONST(0xf)
#define EMC_REXT_0_WRITE_MASK                   _MK_MASK_CONST(0xf)
// specifies the read to read delay for reads when 
// multiple physical devices are present.
#define EMC_REXT_0_REXT_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_REXT_0_REXT_FIELD                   (_MK_MASK_CONST(0xf) << EMC_REXT_0_REXT_SHIFT)
#define EMC_REXT_0_REXT_RANGE                   3:0
#define EMC_REXT_0_REXT_WOFFSET                 0x0
#define EMC_REXT_0_REXT_DEFAULT                 _MK_MASK_CONST(0x1)
#define EMC_REXT_0_REXT_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define EMC_REXT_0_REXT_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_REXT_0_REXT_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_WDV_0  // DRAM timing parameter
#define EMC_WDV_0                       _MK_ADDR_CONST(0x5c)
#define EMC_WDV_0_SECURE                        0x0
#define EMC_WDV_0_WORD_COUNT                    0x1
#define EMC_WDV_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_WDV_0_RESET_MASK                    _MK_MASK_CONST(0xf)
#define EMC_WDV_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_WDV_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_WDV_0_READ_MASK                     _MK_MASK_CONST(0xf)
#define EMC_WDV_0_WRITE_MASK                    _MK_MASK_CONST(0xf)
// the number of cycles to post (delay) write data from being asserted
// to the rams. Set to 0 for DDR1 operation. For DDR1, the delay obtained is the programmed value + 1.
#define EMC_WDV_0_WDV_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_WDV_0_WDV_FIELD                     (_MK_MASK_CONST(0xf) << EMC_WDV_0_WDV_SHIFT)
#define EMC_WDV_0_WDV_RANGE                     3:0
#define EMC_WDV_0_WDV_WOFFSET                   0x0
#define EMC_WDV_0_WDV_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_WDV_0_WDV_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define EMC_WDV_0_WDV_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_WDV_0_WDV_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_WDV_0_WDV_MAX                       _MK_ENUM_CONST(15)


// Register EMC_QUSE_0  // DRAM timing parameter
#define EMC_QUSE_0                      _MK_ADDR_CONST(0x60)
#define EMC_QUSE_0_SECURE                       0x0
#define EMC_QUSE_0_WORD_COUNT                   0x1
#define EMC_QUSE_0_RESET_VAL                    _MK_MASK_CONST(0x2)
#define EMC_QUSE_0_RESET_MASK                   _MK_MASK_CONST(0xf)
#define EMC_QUSE_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_QUSE_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_QUSE_0_READ_MASK                    _MK_MASK_CONST(0xf)
#define EMC_QUSE_0_WRITE_MASK                   _MK_MASK_CONST(0xf)
// tells the chip when to look for read return data.
#define EMC_QUSE_0_QUSE_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_QUSE_0_QUSE_FIELD                   (_MK_MASK_CONST(0xf) << EMC_QUSE_0_QUSE_SHIFT)
#define EMC_QUSE_0_QUSE_RANGE                   3:0
#define EMC_QUSE_0_QUSE_WOFFSET                 0x0
#define EMC_QUSE_0_QUSE_DEFAULT                 _MK_MASK_CONST(0x2)
#define EMC_QUSE_0_QUSE_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define EMC_QUSE_0_QUSE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_QUSE_0_QUSE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_QRST_0  // DRAM timing parameter
#define EMC_QRST_0                      _MK_ADDR_CONST(0x64)
#define EMC_QRST_0_SECURE                       0x0
#define EMC_QRST_0_WORD_COUNT                   0x1
#define EMC_QRST_0_RESET_VAL                    _MK_MASK_CONST(0x1)
#define EMC_QRST_0_RESET_MASK                   _MK_MASK_CONST(0xf)
#define EMC_QRST_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_QRST_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_QRST_0_READ_MASK                    _MK_MASK_CONST(0xf)
#define EMC_QRST_0_WRITE_MASK                   _MK_MASK_CONST(0xf)
// time from expiration of QSAFE until reset is issued
#define EMC_QRST_0_QRST_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_QRST_0_QRST_FIELD                   (_MK_MASK_CONST(0xf) << EMC_QRST_0_QRST_SHIFT)
#define EMC_QRST_0_QRST_RANGE                   3:0
#define EMC_QRST_0_QRST_WOFFSET                 0x0
#define EMC_QRST_0_QRST_DEFAULT                 _MK_MASK_CONST(0x1)
#define EMC_QRST_0_QRST_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define EMC_QRST_0_QRST_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_QRST_0_QRST_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_QSAFE_0  // DRAM timing parameter
#define EMC_QSAFE_0                     _MK_ADDR_CONST(0x68)
#define EMC_QSAFE_0_SECURE                      0x0
#define EMC_QSAFE_0_WORD_COUNT                  0x1
#define EMC_QSAFE_0_RESET_VAL                   _MK_MASK_CONST(0x7)
#define EMC_QSAFE_0_RESET_MASK                  _MK_MASK_CONST(0xf)
#define EMC_QSAFE_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EMC_QSAFE_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_QSAFE_0_READ_MASK                   _MK_MASK_CONST(0xf)
#define EMC_QSAFE_0_WRITE_MASK                  _MK_MASK_CONST(0xf)
// time from a read command to when it is safe to issue a QRST (delayed by the QRST parameter).
#define EMC_QSAFE_0_QSAFE_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_QSAFE_0_QSAFE_FIELD                 (_MK_MASK_CONST(0xf) << EMC_QSAFE_0_QSAFE_SHIFT)
#define EMC_QSAFE_0_QSAFE_RANGE                 3:0
#define EMC_QSAFE_0_QSAFE_WOFFSET                       0x0
#define EMC_QSAFE_0_QSAFE_DEFAULT                       _MK_MASK_CONST(0x7)
#define EMC_QSAFE_0_QSAFE_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define EMC_QSAFE_0_QSAFE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_QSAFE_0_QSAFE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_RDV_0  // DRAM timing parameter
#define EMC_RDV_0                       _MK_ADDR_CONST(0x6c)
#define EMC_RDV_0_SECURE                        0x0
#define EMC_RDV_0_WORD_COUNT                    0x1
#define EMC_RDV_0_RESET_VAL                     _MK_MASK_CONST(0x8)
#define EMC_RDV_0_RESET_MASK                    _MK_MASK_CONST(0x1f)
#define EMC_RDV_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_RDV_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_RDV_0_READ_MASK                     _MK_MASK_CONST(0x1f)
#define EMC_RDV_0_WRITE_MASK                    _MK_MASK_CONST(0x1f)
// time from read command to latching the read data from the pad macros.
#define EMC_RDV_0_RDV_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_RDV_0_RDV_FIELD                     (_MK_MASK_CONST(0x1f) << EMC_RDV_0_RDV_SHIFT)
#define EMC_RDV_0_RDV_RANGE                     4:0
#define EMC_RDV_0_RDV_WOFFSET                   0x0
#define EMC_RDV_0_RDV_DEFAULT                   _MK_MASK_CONST(0x8)
#define EMC_RDV_0_RDV_DEFAULT_MASK                      _MK_MASK_CONST(0x1f)
#define EMC_RDV_0_RDV_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_RDV_0_RDV_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_RDV_0_RDV_MAX                       _MK_ENUM_CONST(15)


// Register EMC_REFRESH_0  // DRAM timing parameter
#define EMC_REFRESH_0                   _MK_ADDR_CONST(0x70)
#define EMC_REFRESH_0_SECURE                    0x0
#define EMC_REFRESH_0_WORD_COUNT                        0x1
#define EMC_REFRESH_0_RESET_VAL                         _MK_MASK_CONST(0x1f)
#define EMC_REFRESH_0_RESET_MASK                        _MK_MASK_CONST(0x1f)
#define EMC_REFRESH_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_REFRESH_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_REFRESH_0_READ_MASK                         _MK_MASK_CONST(0xffff)
#define EMC_REFRESH_0_WRITE_MASK                        _MK_MASK_CONST(0xffff)
#define EMC_REFRESH_0_REFRESH_LO_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_REFRESH_0_REFRESH_LO_FIELD                  (_MK_MASK_CONST(0x1f) << EMC_REFRESH_0_REFRESH_LO_SHIFT)
#define EMC_REFRESH_0_REFRESH_LO_RANGE                  4:0
#define EMC_REFRESH_0_REFRESH_LO_WOFFSET                        0x0
#define EMC_REFRESH_0_REFRESH_LO_DEFAULT                        _MK_MASK_CONST(0x1f)
#define EMC_REFRESH_0_REFRESH_LO_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define EMC_REFRESH_0_REFRESH_LO_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_REFRESH_0_REFRESH_LO_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_REFRESH_0_REFRESH_LO_INIT_ENUM                      MAX
#define EMC_REFRESH_0_REFRESH_LO_MAX                    _MK_ENUM_CONST(31)

// specifies the interval between refresh requests.
#define EMC_REFRESH_0_REFRESH_SHIFT                     _MK_SHIFT_CONST(5)
#define EMC_REFRESH_0_REFRESH_FIELD                     (_MK_MASK_CONST(0x7ff) << EMC_REFRESH_0_REFRESH_SHIFT)
#define EMC_REFRESH_0_REFRESH_RANGE                     15:5
#define EMC_REFRESH_0_REFRESH_WOFFSET                   0x0
#define EMC_REFRESH_0_REFRESH_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_REFRESH_0_REFRESH_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_REFRESH_0_REFRESH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_REFRESH_0_REFRESH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_BURST_REFRESH_NUM_0  // DRAM timing parameter
#define EMC_BURST_REFRESH_NUM_0                 _MK_ADDR_CONST(0x74)
#define EMC_BURST_REFRESH_NUM_0_SECURE                  0x0
#define EMC_BURST_REFRESH_NUM_0_WORD_COUNT                      0x1
#define EMC_BURST_REFRESH_NUM_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_BURST_REFRESH_NUM_0_RESET_MASK                      _MK_MASK_CONST(0xf)
#define EMC_BURST_REFRESH_NUM_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_BURST_REFRESH_NUM_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_BURST_REFRESH_NUM_0_READ_MASK                       _MK_MASK_CONST(0xf)
#define EMC_BURST_REFRESH_NUM_0_WRITE_MASK                      _MK_MASK_CONST(0xf)
// specify the refresh burst count.
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_FIELD                 (_MK_MASK_CONST(0xf) << EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_SHIFT)
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_RANGE                 3:0
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_WOFFSET                       0x0
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_INIT_ENUM                     BR1
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_BR1                   _MK_ENUM_CONST(0)
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_BR2                   _MK_ENUM_CONST(1)
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_BR4                   _MK_ENUM_CONST(2)
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_BR8                   _MK_ENUM_CONST(3)
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_BR16                  _MK_ENUM_CONST(4)
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_BR32                  _MK_ENUM_CONST(5)
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_BR64                  _MK_ENUM_CONST(6)
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_BR128                 _MK_ENUM_CONST(7)
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_BR256                 _MK_ENUM_CONST(8)
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_BR512                 _MK_ENUM_CONST(9)
#define EMC_BURST_REFRESH_NUM_0_BURST_REFRESH_NUM_MAX                   _MK_ENUM_CONST(9)


// Register EMC_PDEX2WR_0  // DRAM timing parameter
#define EMC_PDEX2WR_0                   _MK_ADDR_CONST(0x78)
#define EMC_PDEX2WR_0_SECURE                    0x0
#define EMC_PDEX2WR_0_WORD_COUNT                        0x1
#define EMC_PDEX2WR_0_RESET_VAL                         _MK_MASK_CONST(0xe)
#define EMC_PDEX2WR_0_RESET_MASK                        _MK_MASK_CONST(0xf)
#define EMC_PDEX2WR_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_PDEX2WR_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_PDEX2WR_0_READ_MASK                         _MK_MASK_CONST(0xf)
#define EMC_PDEX2WR_0_WRITE_MASK                        _MK_MASK_CONST(0xf)
// specify the timing delay from exit of powerdown mode to a write command.
// Largest allowed value is 14
#define EMC_PDEX2WR_0_PDEX2WR_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_PDEX2WR_0_PDEX2WR_FIELD                     (_MK_MASK_CONST(0xf) << EMC_PDEX2WR_0_PDEX2WR_SHIFT)
#define EMC_PDEX2WR_0_PDEX2WR_RANGE                     3:0
#define EMC_PDEX2WR_0_PDEX2WR_WOFFSET                   0x0
#define EMC_PDEX2WR_0_PDEX2WR_DEFAULT                   _MK_MASK_CONST(0xe)
#define EMC_PDEX2WR_0_PDEX2WR_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define EMC_PDEX2WR_0_PDEX2WR_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_PDEX2WR_0_PDEX2WR_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_PDEX2RD_0  // DRAM timing parameter
#define EMC_PDEX2RD_0                   _MK_ADDR_CONST(0x7c)
#define EMC_PDEX2RD_0_SECURE                    0x0
#define EMC_PDEX2RD_0_WORD_COUNT                        0x1
#define EMC_PDEX2RD_0_RESET_VAL                         _MK_MASK_CONST(0xe)
#define EMC_PDEX2RD_0_RESET_MASK                        _MK_MASK_CONST(0xf)
#define EMC_PDEX2RD_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_PDEX2RD_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_PDEX2RD_0_READ_MASK                         _MK_MASK_CONST(0xf)
#define EMC_PDEX2RD_0_WRITE_MASK                        _MK_MASK_CONST(0xf)
// specify the timing delay from exit of powerdown mode to a read command.
// Largest allowed value is 14
#define EMC_PDEX2RD_0_PDEX2RD_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_PDEX2RD_0_PDEX2RD_FIELD                     (_MK_MASK_CONST(0xf) << EMC_PDEX2RD_0_PDEX2RD_SHIFT)
#define EMC_PDEX2RD_0_PDEX2RD_RANGE                     3:0
#define EMC_PDEX2RD_0_PDEX2RD_WOFFSET                   0x0
#define EMC_PDEX2RD_0_PDEX2RD_DEFAULT                   _MK_MASK_CONST(0xe)
#define EMC_PDEX2RD_0_PDEX2RD_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define EMC_PDEX2RD_0_PDEX2RD_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_PDEX2RD_0_PDEX2RD_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_PCHG2PDEN_0  // DRAM timing parameter
#define EMC_PCHG2PDEN_0                 _MK_ADDR_CONST(0x80)
#define EMC_PCHG2PDEN_0_SECURE                  0x0
#define EMC_PCHG2PDEN_0_WORD_COUNT                      0x1
#define EMC_PCHG2PDEN_0_RESET_VAL                       _MK_MASK_CONST(0xf)
#define EMC_PCHG2PDEN_0_RESET_MASK                      _MK_MASK_CONST(0x1f)
#define EMC_PCHG2PDEN_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_PCHG2PDEN_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_PCHG2PDEN_0_READ_MASK                       _MK_MASK_CONST(0x1f)
#define EMC_PCHG2PDEN_0_WRITE_MASK                      _MK_MASK_CONST(0x1f)
//  specify the timing delay from a precharge command to powerdown entry.
#define EMC_PCHG2PDEN_0_PCHG2PDEN_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_PCHG2PDEN_0_PCHG2PDEN_FIELD                 (_MK_MASK_CONST(0x1f) << EMC_PCHG2PDEN_0_PCHG2PDEN_SHIFT)
#define EMC_PCHG2PDEN_0_PCHG2PDEN_RANGE                 4:0
#define EMC_PCHG2PDEN_0_PCHG2PDEN_WOFFSET                       0x0
#define EMC_PCHG2PDEN_0_PCHG2PDEN_DEFAULT                       _MK_MASK_CONST(0xf)
#define EMC_PCHG2PDEN_0_PCHG2PDEN_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define EMC_PCHG2PDEN_0_PCHG2PDEN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_PCHG2PDEN_0_PCHG2PDEN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_ACT2PDEN_0  // DRAM timing parameter
#define EMC_ACT2PDEN_0                  _MK_ADDR_CONST(0x84)
#define EMC_ACT2PDEN_0_SECURE                   0x0
#define EMC_ACT2PDEN_0_WORD_COUNT                       0x1
#define EMC_ACT2PDEN_0_RESET_VAL                        _MK_MASK_CONST(0xf)
#define EMC_ACT2PDEN_0_RESET_MASK                       _MK_MASK_CONST(0x1f)
#define EMC_ACT2PDEN_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_ACT2PDEN_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_ACT2PDEN_0_READ_MASK                        _MK_MASK_CONST(0x1f)
#define EMC_ACT2PDEN_0_WRITE_MASK                       _MK_MASK_CONST(0x1f)
// specify the timing delay from an activate, mrs or emrs command to powerdown entry.
#define EMC_ACT2PDEN_0_ACT2PDEN_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_ACT2PDEN_0_ACT2PDEN_FIELD                   (_MK_MASK_CONST(0x1f) << EMC_ACT2PDEN_0_ACT2PDEN_SHIFT)
#define EMC_ACT2PDEN_0_ACT2PDEN_RANGE                   4:0
#define EMC_ACT2PDEN_0_ACT2PDEN_WOFFSET                 0x0
#define EMC_ACT2PDEN_0_ACT2PDEN_DEFAULT                 _MK_MASK_CONST(0xf)
#define EMC_ACT2PDEN_0_ACT2PDEN_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define EMC_ACT2PDEN_0_ACT2PDEN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_ACT2PDEN_0_ACT2PDEN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_AR2PDEN_0  // DRAM timing parameter
#define EMC_AR2PDEN_0                   _MK_ADDR_CONST(0x88)
#define EMC_AR2PDEN_0_SECURE                    0x0
#define EMC_AR2PDEN_0_WORD_COUNT                        0x1
#define EMC_AR2PDEN_0_RESET_VAL                         _MK_MASK_CONST(0x1f)
#define EMC_AR2PDEN_0_RESET_MASK                        _MK_MASK_CONST(0x1f)
#define EMC_AR2PDEN_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_AR2PDEN_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_AR2PDEN_0_READ_MASK                         _MK_MASK_CONST(0x1f)
#define EMC_AR2PDEN_0_WRITE_MASK                        _MK_MASK_CONST(0x1f)
// specify the timing delay from an autorefresh command to powerdown entry.
#define EMC_AR2PDEN_0_AR2PDEN_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_AR2PDEN_0_AR2PDEN_FIELD                     (_MK_MASK_CONST(0x1f) << EMC_AR2PDEN_0_AR2PDEN_SHIFT)
#define EMC_AR2PDEN_0_AR2PDEN_RANGE                     4:0
#define EMC_AR2PDEN_0_AR2PDEN_WOFFSET                   0x0
#define EMC_AR2PDEN_0_AR2PDEN_DEFAULT                   _MK_MASK_CONST(0x1f)
#define EMC_AR2PDEN_0_AR2PDEN_DEFAULT_MASK                      _MK_MASK_CONST(0x1f)
#define EMC_AR2PDEN_0_AR2PDEN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_AR2PDEN_0_AR2PDEN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_RW2PDEN_0  // DRAM timing parameter
#define EMC_RW2PDEN_0                   _MK_ADDR_CONST(0x8c)
#define EMC_RW2PDEN_0_SECURE                    0x0
#define EMC_RW2PDEN_0_WORD_COUNT                        0x1
#define EMC_RW2PDEN_0_RESET_VAL                         _MK_MASK_CONST(0xf)
#define EMC_RW2PDEN_0_RESET_MASK                        _MK_MASK_CONST(0x3f)
#define EMC_RW2PDEN_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_RW2PDEN_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_RW2PDEN_0_READ_MASK                         _MK_MASK_CONST(0x3f)
#define EMC_RW2PDEN_0_WRITE_MASK                        _MK_MASK_CONST(0x3f)
// specify the timing delay from a read/write command to powerdown entry.
//  Auto-precharge timing must be taken into account when programming this field (affects lpddr & lpddr2/ddr2 differently).
#define EMC_RW2PDEN_0_RW2PDEN_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_RW2PDEN_0_RW2PDEN_FIELD                     (_MK_MASK_CONST(0x3f) << EMC_RW2PDEN_0_RW2PDEN_SHIFT)
#define EMC_RW2PDEN_0_RW2PDEN_RANGE                     5:0
#define EMC_RW2PDEN_0_RW2PDEN_WOFFSET                   0x0
#define EMC_RW2PDEN_0_RW2PDEN_DEFAULT                   _MK_MASK_CONST(0xf)
#define EMC_RW2PDEN_0_RW2PDEN_DEFAULT_MASK                      _MK_MASK_CONST(0x3f)
#define EMC_RW2PDEN_0_RW2PDEN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_RW2PDEN_0_RW2PDEN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_TXSR_0  // DRAM timing parameter
#define EMC_TXSR_0                      _MK_ADDR_CONST(0x90)
#define EMC_TXSR_0_SECURE                       0x0
#define EMC_TXSR_0_WORD_COUNT                   0x1
#define EMC_TXSR_0_RESET_VAL                    _MK_MASK_CONST(0x7ff)
#define EMC_TXSR_0_RESET_MASK                   _MK_MASK_CONST(0xfff)
#define EMC_TXSR_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_TXSR_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_TXSR_0_READ_MASK                    _MK_MASK_CONST(0xfff)
#define EMC_TXSR_0_WRITE_MASK                   _MK_MASK_CONST(0xfff)
// cycles between self-refresh exit & first DRAM command
// Largest allowed value is 0xffe
#define EMC_TXSR_0_TXSR_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_TXSR_0_TXSR_FIELD                   (_MK_MASK_CONST(0xfff) << EMC_TXSR_0_TXSR_SHIFT)
#define EMC_TXSR_0_TXSR_RANGE                   11:0
#define EMC_TXSR_0_TXSR_WOFFSET                 0x0
#define EMC_TXSR_0_TXSR_DEFAULT                 _MK_MASK_CONST(0x7ff)
#define EMC_TXSR_0_TXSR_DEFAULT_MASK                    _MK_MASK_CONST(0xfff)
#define EMC_TXSR_0_TXSR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_TXSR_0_TXSR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_TCKE_0  // DRAM timing parameter
#define EMC_TCKE_0                      _MK_ADDR_CONST(0x94)
#define EMC_TCKE_0_SECURE                       0x0
#define EMC_TCKE_0_WORD_COUNT                   0x1
#define EMC_TCKE_0_RESET_VAL                    _MK_MASK_CONST(0xe)
#define EMC_TCKE_0_RESET_MASK                   _MK_MASK_CONST(0xf)
#define EMC_TCKE_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_TCKE_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_TCKE_0_READ_MASK                    _MK_MASK_CONST(0xf)
#define EMC_TCKE_0_WRITE_MASK                   _MK_MASK_CONST(0xf)
// specify minimum CKE pulse width.
#define EMC_TCKE_0_TCKE_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_TCKE_0_TCKE_FIELD                   (_MK_MASK_CONST(0xf) << EMC_TCKE_0_TCKE_SHIFT)
#define EMC_TCKE_0_TCKE_RANGE                   3:0
#define EMC_TCKE_0_TCKE_WOFFSET                 0x0
#define EMC_TCKE_0_TCKE_DEFAULT                 _MK_MASK_CONST(0xe)
#define EMC_TCKE_0_TCKE_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define EMC_TCKE_0_TCKE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_TCKE_0_TCKE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_TFAW_0  // DRAM timing parameter
#define EMC_TFAW_0                      _MK_ADDR_CONST(0x98)
#define EMC_TFAW_0_SECURE                       0x0
#define EMC_TFAW_0_WORD_COUNT                   0x1
#define EMC_TFAW_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define EMC_TFAW_0_RESET_MASK                   _MK_MASK_CONST(0x3f)
#define EMC_TFAW_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_TFAW_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_TFAW_0_READ_MASK                    _MK_MASK_CONST(0x3f)
#define EMC_TFAW_0_WRITE_MASK                   _MK_MASK_CONST(0x3f)
// specify the width of the FAW (four-activate window) for 8-bank devices.
// Set to 0 to disable this timing check. Only 4 activates may occur withing the rolling window. 
#define EMC_TFAW_0_TFAW_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_TFAW_0_TFAW_FIELD                   (_MK_MASK_CONST(0x3f) << EMC_TFAW_0_TFAW_SHIFT)
#define EMC_TFAW_0_TFAW_RANGE                   5:0
#define EMC_TFAW_0_TFAW_WOFFSET                 0x0
#define EMC_TFAW_0_TFAW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_TFAW_0_TFAW_DEFAULT_MASK                    _MK_MASK_CONST(0x3f)
#define EMC_TFAW_0_TFAW_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_TFAW_0_TFAW_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_TRPAB_0  // DRAM timing parameter
#define EMC_TRPAB_0                     _MK_ADDR_CONST(0x9c)
#define EMC_TRPAB_0_SECURE                      0x0
#define EMC_TRPAB_0_WORD_COUNT                  0x1
#define EMC_TRPAB_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define EMC_TRPAB_0_RESET_MASK                  _MK_MASK_CONST(0x3f)
#define EMC_TRPAB_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EMC_TRPAB_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_TRPAB_0_READ_MASK                   _MK_MASK_CONST(0x3f)
#define EMC_TRPAB_0_WRITE_MASK                  _MK_MASK_CONST(0x3f)
// specify precharge-all tRP allowance for 8-bank devices.
// Setting this field to 0 will cause EMC to use TRP.TRP for precharge-all.
#define EMC_TRPAB_0_TRPAB_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_TRPAB_0_TRPAB_FIELD                 (_MK_MASK_CONST(0x3f) << EMC_TRPAB_0_TRPAB_SHIFT)
#define EMC_TRPAB_0_TRPAB_RANGE                 5:0
#define EMC_TRPAB_0_TRPAB_WOFFSET                       0x0
#define EMC_TRPAB_0_TRPAB_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_TRPAB_0_TRPAB_DEFAULT_MASK                  _MK_MASK_CONST(0x3f)
#define EMC_TRPAB_0_TRPAB_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_TRPAB_0_TRPAB_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_TCLKSTABLE_0  // DRAM timing parameter
#define EMC_TCLKSTABLE_0                        _MK_ADDR_CONST(0xa0)
#define EMC_TCLKSTABLE_0_SECURE                         0x0
#define EMC_TCLKSTABLE_0_WORD_COUNT                     0x1
#define EMC_TCLKSTABLE_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define EMC_TCLKSTABLE_0_RESET_MASK                     _MK_MASK_CONST(0xf)
#define EMC_TCLKSTABLE_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_TCLKSTABLE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_TCLKSTABLE_0_READ_MASK                      _MK_MASK_CONST(0xf)
#define EMC_TCLKSTABLE_0_WRITE_MASK                     _MK_MASK_CONST(0xf)
// specify minimum number of cycles of a stable clock period
// prior to exiting powerdown or self-refresh modes.
#define EMC_TCLKSTABLE_0_TCLKSTABLE_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_TCLKSTABLE_0_TCLKSTABLE_FIELD                       (_MK_MASK_CONST(0xf) << EMC_TCLKSTABLE_0_TCLKSTABLE_SHIFT)
#define EMC_TCLKSTABLE_0_TCLKSTABLE_RANGE                       3:0
#define EMC_TCLKSTABLE_0_TCLKSTABLE_WOFFSET                     0x0
#define EMC_TCLKSTABLE_0_TCLKSTABLE_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_TCLKSTABLE_0_TCLKSTABLE_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define EMC_TCLKSTABLE_0_TCLKSTABLE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_TCLKSTABLE_0_TCLKSTABLE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_TCLKSTOP_0  // DRAM timing parameter
#define EMC_TCLKSTOP_0                  _MK_ADDR_CONST(0xa4)
#define EMC_TCLKSTOP_0_SECURE                   0x0
#define EMC_TCLKSTOP_0_WORD_COUNT                       0x1
#define EMC_TCLKSTOP_0_RESET_VAL                        _MK_MASK_CONST(0x2)
#define EMC_TCLKSTOP_0_RESET_MASK                       _MK_MASK_CONST(0xf)
#define EMC_TCLKSTOP_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_TCLKSTOP_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_TCLKSTOP_0_READ_MASK                        _MK_MASK_CONST(0xf)
#define EMC_TCLKSTOP_0_WRITE_MASK                       _MK_MASK_CONST(0xf)
// delay from last command to stopping the external clock to DRAM devices.
#define EMC_TCLKSTOP_0_TCLKSTOP_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_TCLKSTOP_0_TCLKSTOP_FIELD                   (_MK_MASK_CONST(0xf) << EMC_TCLKSTOP_0_TCLKSTOP_SHIFT)
#define EMC_TCLKSTOP_0_TCLKSTOP_RANGE                   3:0
#define EMC_TCLKSTOP_0_TCLKSTOP_WOFFSET                 0x0
#define EMC_TCLKSTOP_0_TCLKSTOP_DEFAULT                 _MK_MASK_CONST(0x2)
#define EMC_TCLKSTOP_0_TCLKSTOP_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define EMC_TCLKSTOP_0_TCLKSTOP_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_TCLKSTOP_0_TCLKSTOP_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_TREFBW_0  // DRAM timing parameter
#define EMC_TREFBW_0                    _MK_ADDR_CONST(0xa8)
#define EMC_TREFBW_0_SECURE                     0x0
#define EMC_TREFBW_0_WORD_COUNT                         0x1
#define EMC_TREFBW_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_TREFBW_0_RESET_MASK                         _MK_MASK_CONST(0x3fff)
#define EMC_TREFBW_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_TREFBW_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_TREFBW_0_READ_MASK                  _MK_MASK_CONST(0x3fff)
#define EMC_TREFBW_0_WRITE_MASK                         _MK_MASK_CONST(0x3fff)
// specify the width of the burst-refresh window.
// If set to a non-zero value, only 8 refreshes will occur in this rolling window.
// Set to 0 to disable this timing check. 
#define EMC_TREFBW_0_TREFBW_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_TREFBW_0_TREFBW_FIELD                       (_MK_MASK_CONST(0x3fff) << EMC_TREFBW_0_TREFBW_SHIFT)
#define EMC_TREFBW_0_TREFBW_RANGE                       13:0
#define EMC_TREFBW_0_TREFBW_WOFFSET                     0x0
#define EMC_TREFBW_0_TREFBW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_TREFBW_0_TREFBW_DEFAULT_MASK                        _MK_MASK_CONST(0x3fff)
#define EMC_TREFBW_0_TREFBW_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_TREFBW_0_TREFBW_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_QUSE_EXTRA_0  
#define EMC_QUSE_EXTRA_0                        _MK_ADDR_CONST(0xac)
#define EMC_QUSE_EXTRA_0_SECURE                         0x0
#define EMC_QUSE_EXTRA_0_WORD_COUNT                     0x1
#define EMC_QUSE_EXTRA_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define EMC_QUSE_EXTRA_0_RESET_MASK                     _MK_MASK_CONST(0xf)
#define EMC_QUSE_EXTRA_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_QUSE_EXTRA_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_QUSE_EXTRA_0_READ_MASK                      _MK_MASK_CONST(0xf)
#define EMC_QUSE_EXTRA_0_WRITE_MASK                     _MK_MASK_CONST(0xf)
#define EMC_QUSE_EXTRA_0_QUSE_EXTRA_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_QUSE_EXTRA_0_QUSE_EXTRA_FIELD                       (_MK_MASK_CONST(0xf) << EMC_QUSE_EXTRA_0_QUSE_EXTRA_SHIFT)
#define EMC_QUSE_EXTRA_0_QUSE_EXTRA_RANGE                       3:0
#define EMC_QUSE_EXTRA_0_QUSE_EXTRA_WOFFSET                     0x0
#define EMC_QUSE_EXTRA_0_QUSE_EXTRA_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_QUSE_EXTRA_0_QUSE_EXTRA_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define EMC_QUSE_EXTRA_0_QUSE_EXTRA_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_QUSE_EXTRA_0_QUSE_EXTRA_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_ODT_WRITE_0  
#define EMC_ODT_WRITE_0                 _MK_ADDR_CONST(0xb0)
#define EMC_ODT_WRITE_0_SECURE                  0x0
#define EMC_ODT_WRITE_0_WORD_COUNT                      0x1
#define EMC_ODT_WRITE_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_ODT_WRITE_0_RESET_MASK                      _MK_MASK_CONST(0xc0000007)
#define EMC_ODT_WRITE_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_ODT_WRITE_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_ODT_WRITE_0_READ_MASK                       _MK_MASK_CONST(0xc0000007)
#define EMC_ODT_WRITE_0_WRITE_MASK                      _MK_MASK_CONST(0xc0000007)
// Set this field = ABS ( WL - ceiling(tAOND) - 2 ).
// The valid programming range is 0 <= ODT_WR_DELAY <= 2 if ODT_B4_WRITE=0, 0 <= ODT_WR_DELAY <= 1 if ODT_B4_WRITE=1
#define EMC_ODT_WRITE_0_ODT_WR_DELAY_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC_ODT_WRITE_0_ODT_WR_DELAY_FIELD                      (_MK_MASK_CONST(0x7) << EMC_ODT_WRITE_0_ODT_WR_DELAY_SHIFT)
#define EMC_ODT_WRITE_0_ODT_WR_DELAY_RANGE                      2:0
#define EMC_ODT_WRITE_0_ODT_WR_DELAY_WOFFSET                    0x0
#define EMC_ODT_WRITE_0_ODT_WR_DELAY_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_ODT_WRITE_0_ODT_WR_DELAY_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define EMC_ODT_WRITE_0_ODT_WR_DELAY_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_ODT_WRITE_0_ODT_WR_DELAY_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// If this field == 1, ODT is turned on ODT_WR_DELAY cycles prior to dram WRITE command.
// If this field == 0, ODT is turned on ODT_WR_DELAY cycles after dram WRITE command.
// Set ODT_B4_WRITE to 1 if ( WL - ceiling(tAOND) - 2 ) < 0.
#define EMC_ODT_WRITE_0_ODT_B4_WRITE_SHIFT                      _MK_SHIFT_CONST(30)
#define EMC_ODT_WRITE_0_ODT_B4_WRITE_FIELD                      (_MK_MASK_CONST(0x1) << EMC_ODT_WRITE_0_ODT_B4_WRITE_SHIFT)
#define EMC_ODT_WRITE_0_ODT_B4_WRITE_RANGE                      30:30
#define EMC_ODT_WRITE_0_ODT_B4_WRITE_WOFFSET                    0x0
#define EMC_ODT_WRITE_0_ODT_B4_WRITE_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_ODT_WRITE_0_ODT_B4_WRITE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_ODT_WRITE_0_ODT_B4_WRITE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_ODT_WRITE_0_ODT_B4_WRITE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// enables ODT to be turned on prior to issuing write to DRAM.
// If ENABLE_ODT_DURING_WRITE = 1 and DISABLE_ODT_DURING_READ = 0, ODT will always be enabled after 1st write.
#define EMC_ODT_WRITE_0_ENABLE_ODT_DURING_WRITE_SHIFT                   _MK_SHIFT_CONST(31)
#define EMC_ODT_WRITE_0_ENABLE_ODT_DURING_WRITE_FIELD                   (_MK_MASK_CONST(0x1) << EMC_ODT_WRITE_0_ENABLE_ODT_DURING_WRITE_SHIFT)
#define EMC_ODT_WRITE_0_ENABLE_ODT_DURING_WRITE_RANGE                   31:31
#define EMC_ODT_WRITE_0_ENABLE_ODT_DURING_WRITE_WOFFSET                 0x0
#define EMC_ODT_WRITE_0_ENABLE_ODT_DURING_WRITE_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_ODT_WRITE_0_ENABLE_ODT_DURING_WRITE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define EMC_ODT_WRITE_0_ENABLE_ODT_DURING_WRITE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_ODT_WRITE_0_ENABLE_ODT_DURING_WRITE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_ODT_READ_0  
#define EMC_ODT_READ_0                  _MK_ADDR_CONST(0xb4)
#define EMC_ODT_READ_0_SECURE                   0x0
#define EMC_ODT_READ_0_WORD_COUNT                       0x1
#define EMC_ODT_READ_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define EMC_ODT_READ_0_RESET_MASK                       _MK_MASK_CONST(0xc0000007)
#define EMC_ODT_READ_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_ODT_READ_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_ODT_READ_0_READ_MASK                        _MK_MASK_CONST(0xc0000007)
#define EMC_ODT_READ_0_WRITE_MASK                       _MK_MASK_CONST(0xc0000007)
// Set this field = ABS ( RL - ceiling(tAOFD) - 2 ).
// The valid programming range is 0 <= ODT_RD_DELAY <= 2 if ODT_B4_READ=0, 0 <= ODT_RD_DELAY <= 1 if ODT_B4_READ=1
#define EMC_ODT_READ_0_ODT_RD_DELAY_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_ODT_READ_0_ODT_RD_DELAY_FIELD                       (_MK_MASK_CONST(0x7) << EMC_ODT_READ_0_ODT_RD_DELAY_SHIFT)
#define EMC_ODT_READ_0_ODT_RD_DELAY_RANGE                       2:0
#define EMC_ODT_READ_0_ODT_RD_DELAY_WOFFSET                     0x0
#define EMC_ODT_READ_0_ODT_RD_DELAY_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_ODT_READ_0_ODT_RD_DELAY_DEFAULT_MASK                        _MK_MASK_CONST(0x7)
#define EMC_ODT_READ_0_ODT_RD_DELAY_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_ODT_READ_0_ODT_RD_DELAY_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// If this field == 1, ODT is turned off ODT_RD_DELAY cycles prior to dram READ command.
// If this field == 0, ODT is turned off ODT_RD_DELAY cycles after dram READ command.
// Set ODT_B4_READ to 1 if ( RL - ceiling(tAOFD) - 2 ) < 0.
#define EMC_ODT_READ_0_ODT_B4_READ_SHIFT                        _MK_SHIFT_CONST(30)
#define EMC_ODT_READ_0_ODT_B4_READ_FIELD                        (_MK_MASK_CONST(0x1) << EMC_ODT_READ_0_ODT_B4_READ_SHIFT)
#define EMC_ODT_READ_0_ODT_B4_READ_RANGE                        30:30
#define EMC_ODT_READ_0_ODT_B4_READ_WOFFSET                      0x0
#define EMC_ODT_READ_0_ODT_B4_READ_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_ODT_READ_0_ODT_B4_READ_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define EMC_ODT_READ_0_ODT_B4_READ_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_ODT_READ_0_ODT_B4_READ_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// enables ODT to be turned off prior to issuing read to DRAM.
// If this field == 0, ODT state will not be changed for reads. 
// If this field == 1, Turn off ODT prior to READ command
//   (has no effect if ODT ENABLE_ODT_DURING_WRITE == 0, as ODT will always be disabled). 
#define EMC_ODT_READ_0_DISABLE_ODT_DURING_READ_SHIFT                    _MK_SHIFT_CONST(31)
#define EMC_ODT_READ_0_DISABLE_ODT_DURING_READ_FIELD                    (_MK_MASK_CONST(0x1) << EMC_ODT_READ_0_DISABLE_ODT_DURING_READ_SHIFT)
#define EMC_ODT_READ_0_DISABLE_ODT_DURING_READ_RANGE                    31:31
#define EMC_ODT_READ_0_DISABLE_ODT_DURING_READ_WOFFSET                  0x0
#define EMC_ODT_READ_0_DISABLE_ODT_DURING_READ_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_ODT_READ_0_DISABLE_ODT_DURING_READ_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_ODT_READ_0_DISABLE_ODT_DURING_READ_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_ODT_READ_0_DISABLE_ODT_DURING_READ_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Reserved address 184 [0xb8] 

// Reserved address 188 [0xbc] 

// Reserved address 192 [0xc0] 

// Reserved address 196 [0xc4] 

// Reserved address 200 [0xc8] 

// Register EMC_MRS_0  // Command trigger: MRS
#define EMC_MRS_0                       _MK_ADDR_CONST(0xcc)
#define EMC_MRS_0_SECURE                        0x0
#define EMC_MRS_0_WORD_COUNT                    0x1
#define EMC_MRS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_MRS_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_MRS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_MRS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_MRS_0_READ_MASK                     _MK_MASK_CONST(0xc0303fff)
#define EMC_MRS_0_WRITE_MASK                    _MK_MASK_CONST(0xc0303fff)
// mode-register data to be written. 
#define EMC_MRS_0_MRS_ADR_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_MRS_0_MRS_ADR_FIELD                 (_MK_MASK_CONST(0x3fff) << EMC_MRS_0_MRS_ADR_SHIFT)
#define EMC_MRS_0_MRS_ADR_RANGE                 13:0
#define EMC_MRS_0_MRS_ADR_WOFFSET                       0x0
#define EMC_MRS_0_MRS_ADR_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_MRS_0_MRS_ADR_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_MRS_0_MRS_ADR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_MRS_0_MRS_ADR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Set to 0x0 for MRS.
#define EMC_MRS_0_MRS_BA_SHIFT                  _MK_SHIFT_CONST(20)
#define EMC_MRS_0_MRS_BA_FIELD                  (_MK_MASK_CONST(0x3) << EMC_MRS_0_MRS_BA_SHIFT)
#define EMC_MRS_0_MRS_BA_RANGE                  21:20
#define EMC_MRS_0_MRS_BA_WOFFSET                        0x0
#define EMC_MRS_0_MRS_BA_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_MRS_0_MRS_BA_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_MRS_0_MRS_BA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_MRS_0_MRS_BA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// active low chip-select, 0x0 applies command to both devices, 0x2 to for only dev0, 0x1 for only dev1.
#define EMC_MRS_0_MRS_DEV_SELECTN_SHIFT                 _MK_SHIFT_CONST(30)
#define EMC_MRS_0_MRS_DEV_SELECTN_FIELD                 (_MK_MASK_CONST(0x3) << EMC_MRS_0_MRS_DEV_SELECTN_SHIFT)
#define EMC_MRS_0_MRS_DEV_SELECTN_RANGE                 31:30
#define EMC_MRS_0_MRS_DEV_SELECTN_WOFFSET                       0x0
#define EMC_MRS_0_MRS_DEV_SELECTN_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_MRS_0_MRS_DEV_SELECTN_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_MRS_0_MRS_DEV_SELECTN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_MRS_0_MRS_DEV_SELECTN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_EMRS_0  // Command trigger: EMRS
#define EMC_EMRS_0                      _MK_ADDR_CONST(0xd0)
#define EMC_EMRS_0_SECURE                       0x0
#define EMC_EMRS_0_WORD_COUNT                   0x1
#define EMC_EMRS_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_RESET_MASK                   _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_READ_MASK                    _MK_MASK_CONST(0xc0303fff)
#define EMC_EMRS_0_WRITE_MASK                   _MK_MASK_CONST(0xc0303fff)
// mode-register data to be written. 
#define EMC_EMRS_0_EMRS_ADR_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_EMRS_0_EMRS_ADR_FIELD                       (_MK_MASK_CONST(0x3fff) << EMC_EMRS_0_EMRS_ADR_SHIFT)
#define EMC_EMRS_0_EMRS_ADR_RANGE                       13:0
#define EMC_EMRS_0_EMRS_ADR_WOFFSET                     0x0
#define EMC_EMRS_0_EMRS_ADR_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_EMRS_ADR_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_EMRS_ADR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_EMRS_ADR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Set to 0x1 for EMRS (and where applicable, 0x2 for EMRS2, and 0x3 for EMRS3).
#define EMC_EMRS_0_EMRS_BA_SHIFT                        _MK_SHIFT_CONST(20)
#define EMC_EMRS_0_EMRS_BA_FIELD                        (_MK_MASK_CONST(0x3) << EMC_EMRS_0_EMRS_BA_SHIFT)
#define EMC_EMRS_0_EMRS_BA_RANGE                        21:20
#define EMC_EMRS_0_EMRS_BA_WOFFSET                      0x0
#define EMC_EMRS_0_EMRS_BA_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_EMRS_BA_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_EMRS_BA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_EMRS_BA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// active low chip-select, 0x0 applies command to both devices, 0x2 to for only dev0, 0x1 for only dev1.
#define EMC_EMRS_0_EMRS_DEV_SELECTN_SHIFT                       _MK_SHIFT_CONST(30)
#define EMC_EMRS_0_EMRS_DEV_SELECTN_FIELD                       (_MK_MASK_CONST(0x3) << EMC_EMRS_0_EMRS_DEV_SELECTN_SHIFT)
#define EMC_EMRS_0_EMRS_DEV_SELECTN_RANGE                       31:30
#define EMC_EMRS_0_EMRS_DEV_SELECTN_WOFFSET                     0x0
#define EMC_EMRS_0_EMRS_DEV_SELECTN_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_EMRS_DEV_SELECTN_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_EMRS_DEV_SELECTN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_EMRS_0_EMRS_DEV_SELECTN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_REF_0  // Command trigger: Refresh
#define EMC_REF_0                       _MK_ADDR_CONST(0xd4)
#define EMC_REF_0_SECURE                        0x0
#define EMC_REF_0_WORD_COUNT                    0x1
#define EMC_REF_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_REF_0_RESET_MASK                    _MK_MASK_CONST(0xff01)
#define EMC_REF_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_REF_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_REF_0_READ_MASK                     _MK_MASK_CONST(0xff01)
#define EMC_REF_0_WRITE_MASK                    _MK_MASK_CONST(0xff01)
// causes the hardware to perform a REFRESH to all DRAM banks.
#define EMC_REF_0_REF_CMD_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_REF_0_REF_CMD_FIELD                 (_MK_MASK_CONST(0x1) << EMC_REF_0_REF_CMD_SHIFT)
#define EMC_REF_0_REF_CMD_RANGE                 0:0
#define EMC_REF_0_REF_CMD_WOFFSET                       0x0
#define EMC_REF_0_REF_CMD_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_REF_0_REF_CMD_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_REF_0_REF_CMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_REF_0_REF_CMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// perform (REF_NUM + 1) refresh cycles.
#define EMC_REF_0_REF_NUM_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_REF_0_REF_NUM_FIELD                 (_MK_MASK_CONST(0xff) << EMC_REF_0_REF_NUM_SHIFT)
#define EMC_REF_0_REF_NUM_RANGE                 15:8
#define EMC_REF_0_REF_NUM_WOFFSET                       0x0
#define EMC_REF_0_REF_NUM_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_REF_0_REF_NUM_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_REF_0_REF_NUM_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_REF_0_REF_NUM_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_PRE_0  // Command trigger: Precharge-All
#define EMC_PRE_0                       _MK_ADDR_CONST(0xd8)
#define EMC_PRE_0_SECURE                        0x0
#define EMC_PRE_0_WORD_COUNT                    0x1
#define EMC_PRE_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_PRE_0_RESET_MASK                    _MK_MASK_CONST(0x1)
#define EMC_PRE_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_PRE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_PRE_0_READ_MASK                     _MK_MASK_CONST(0xc0000001)
#define EMC_PRE_0_WRITE_MASK                    _MK_MASK_CONST(0xc0000001)
// causes the hardware to perform a PRECHARGE to all DRAM banks.
#define EMC_PRE_0_PRE_CMD_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_PRE_0_PRE_CMD_FIELD                 (_MK_MASK_CONST(0x1) << EMC_PRE_0_PRE_CMD_SHIFT)
#define EMC_PRE_0_PRE_CMD_RANGE                 0:0
#define EMC_PRE_0_PRE_CMD_WOFFSET                       0x0
#define EMC_PRE_0_PRE_CMD_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_PRE_0_PRE_CMD_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_PRE_0_PRE_CMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_PRE_0_PRE_CMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// active low chip-select, 0x0 applies command to both devices, 0x2 to for only dev0, 0x1 for only dev1.
#define EMC_PRE_0_PRE_DEV_SELECTN_SHIFT                 _MK_SHIFT_CONST(30)
#define EMC_PRE_0_PRE_DEV_SELECTN_FIELD                 (_MK_MASK_CONST(0x3) << EMC_PRE_0_PRE_DEV_SELECTN_SHIFT)
#define EMC_PRE_0_PRE_DEV_SELECTN_RANGE                 31:30
#define EMC_PRE_0_PRE_DEV_SELECTN_WOFFSET                       0x0
#define EMC_PRE_0_PRE_DEV_SELECTN_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_PRE_0_PRE_DEV_SELECTN_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_PRE_0_PRE_DEV_SELECTN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_PRE_0_PRE_DEV_SELECTN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_NOP_0  // Command trigger: NOP
#define EMC_NOP_0                       _MK_ADDR_CONST(0xdc)
#define EMC_NOP_0_SECURE                        0x0
#define EMC_NOP_0_WORD_COUNT                    0x1
#define EMC_NOP_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_NOP_0_RESET_MASK                    _MK_MASK_CONST(0x1)
#define EMC_NOP_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_NOP_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_NOP_0_READ_MASK                     _MK_MASK_CONST(0x1)
#define EMC_NOP_0_WRITE_MASK                    _MK_MASK_CONST(0x1)
// causes the hardware to perform a NOP to all DRAM banks.
#define EMC_NOP_0_NOP_CMD_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_NOP_0_NOP_CMD_FIELD                 (_MK_MASK_CONST(0x1) << EMC_NOP_0_NOP_CMD_SHIFT)
#define EMC_NOP_0_NOP_CMD_RANGE                 0:0
#define EMC_NOP_0_NOP_CMD_WOFFSET                       0x0
#define EMC_NOP_0_NOP_CMD_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_NOP_0_NOP_CMD_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_NOP_0_NOP_CMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_NOP_0_NOP_CMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_SELF_REF_0  // Command trigger: SELF REFRESH
#define EMC_SELF_REF_0                  _MK_ADDR_CONST(0xe0)
#define EMC_SELF_REF_0_SECURE                   0x0
#define EMC_SELF_REF_0_WORD_COUNT                       0x1
#define EMC_SELF_REF_0_RESET_VAL                        _MK_MASK_CONST(0xc0000000)
#define EMC_SELF_REF_0_RESET_MASK                       _MK_MASK_CONST(0xc0000001)
#define EMC_SELF_REF_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_SELF_REF_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_SELF_REF_0_READ_MASK                        _MK_MASK_CONST(0xc0000001)
#define EMC_SELF_REF_0_WRITE_MASK                       _MK_MASK_CONST(0xc0000001)
// causes the hardware to issue a SELF_REFRESH command. While CMD:ENABLED, the CKE pin is held deasserted. The CMD:ENABLED state will override the PIN:CKE setting.
// The DRAM will ignore all accesses until CMD:DISABLED.
#define EMC_SELF_REF_0_SELF_REF_CMD_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_SELF_REF_0_SELF_REF_CMD_FIELD                       (_MK_MASK_CONST(0x1) << EMC_SELF_REF_0_SELF_REF_CMD_SHIFT)
#define EMC_SELF_REF_0_SELF_REF_CMD_RANGE                       0:0
#define EMC_SELF_REF_0_SELF_REF_CMD_WOFFSET                     0x0
#define EMC_SELF_REF_0_SELF_REF_CMD_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_SELF_REF_0_SELF_REF_CMD_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define EMC_SELF_REF_0_SELF_REF_CMD_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_SELF_REF_0_SELF_REF_CMD_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_SELF_REF_0_SELF_REF_CMD_INIT_ENUM                   DISABLED
#define EMC_SELF_REF_0_SELF_REF_CMD_DISABLED                    _MK_ENUM_CONST(0)
#define EMC_SELF_REF_0_SELF_REF_CMD_ENABLED                     _MK_ENUM_CONST(1)

// active low chip-select, 0x0 applies command to both devices, 0x2 to for only dev0, 0x1 for only dev1, 0x3 for neither device.
#define EMC_SELF_REF_0_SREF_DEV_SELECTN_SHIFT                   _MK_SHIFT_CONST(30)
#define EMC_SELF_REF_0_SREF_DEV_SELECTN_FIELD                   (_MK_MASK_CONST(0x3) << EMC_SELF_REF_0_SREF_DEV_SELECTN_SHIFT)
#define EMC_SELF_REF_0_SREF_DEV_SELECTN_RANGE                   31:30
#define EMC_SELF_REF_0_SREF_DEV_SELECTN_WOFFSET                 0x0
#define EMC_SELF_REF_0_SREF_DEV_SELECTN_DEFAULT                 _MK_MASK_CONST(0x3)
#define EMC_SELF_REF_0_SREF_DEV_SELECTN_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define EMC_SELF_REF_0_SREF_DEV_SELECTN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_SELF_REF_0_SREF_DEV_SELECTN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_DPD_0  // Command trigger: Deep Power Down
#define EMC_DPD_0                       _MK_ADDR_CONST(0xe4)
#define EMC_DPD_0_SECURE                        0x0
#define EMC_DPD_0_WORD_COUNT                    0x1
#define EMC_DPD_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_DPD_0_RESET_MASK                    _MK_MASK_CONST(0x1)
#define EMC_DPD_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_DPD_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_DPD_0_READ_MASK                     _MK_MASK_CONST(0xc0000001)
#define EMC_DPD_0_WRITE_MASK                    _MK_MASK_CONST(0xc0000001)
// causes the hardware to issue the deep power down command (Burst Terminate w/ cke low). While in DPD mode, the DRAM will not maintain data integrity.
// While CMD:ENABLED, the CKE pin is held deasserted. The CMD:ENABLED state will override the PIN:CKE setting.
// The DRAM will ignore all accesses until CMD:DISABLED.
#define EMC_DPD_0_DPD_CMD_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_DPD_0_DPD_CMD_FIELD                 (_MK_MASK_CONST(0x1) << EMC_DPD_0_DPD_CMD_SHIFT)
#define EMC_DPD_0_DPD_CMD_RANGE                 0:0
#define EMC_DPD_0_DPD_CMD_WOFFSET                       0x0
#define EMC_DPD_0_DPD_CMD_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DPD_0_DPD_CMD_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_DPD_0_DPD_CMD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DPD_0_DPD_CMD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_DPD_0_DPD_CMD_INIT_ENUM                     DISABLED
#define EMC_DPD_0_DPD_CMD_DISABLED                      _MK_ENUM_CONST(0)
#define EMC_DPD_0_DPD_CMD_ENABLED                       _MK_ENUM_CONST(1)

// active low chip-select, 0x0 applies command to both devices, 0x2 to for only dev0, 0x1 for only dev1.
#define EMC_DPD_0_DPD_DEV_SELECTN_SHIFT                 _MK_SHIFT_CONST(30)
#define EMC_DPD_0_DPD_DEV_SELECTN_FIELD                 (_MK_MASK_CONST(0x3) << EMC_DPD_0_DPD_DEV_SELECTN_SHIFT)
#define EMC_DPD_0_DPD_DEV_SELECTN_RANGE                 31:30
#define EMC_DPD_0_DPD_DEV_SELECTN_WOFFSET                       0x0
#define EMC_DPD_0_DPD_DEV_SELECTN_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DPD_0_DPD_DEV_SELECTN_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DPD_0_DPD_DEV_SELECTN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DPD_0_DPD_DEV_SELECTN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_MRW_0  // Command trigger: MRW
#define EMC_MRW_0                       _MK_ADDR_CONST(0xe8)
#define EMC_MRW_0_SECURE                        0x0
#define EMC_MRW_0_WORD_COUNT                    0x1
#define EMC_MRW_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_MRW_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_MRW_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_MRW_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_MRW_0_READ_MASK                     _MK_MASK_CONST(0x0)
#define EMC_MRW_0_WRITE_MASK                    _MK_MASK_CONST(0xc0ff00ff)
// data to be written
#define EMC_MRW_0_MRW_OP_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_MRW_0_MRW_OP_FIELD                  (_MK_MASK_CONST(0xff) << EMC_MRW_0_MRW_OP_SHIFT)
#define EMC_MRW_0_MRW_OP_RANGE                  7:0
#define EMC_MRW_0_MRW_OP_WOFFSET                        0x0
#define EMC_MRW_0_MRW_OP_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_MRW_0_MRW_OP_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_MRW_0_MRW_OP_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_MRW_0_MRW_OP_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// register address
#define EMC_MRW_0_MRW_MA_SHIFT                  _MK_SHIFT_CONST(16)
#define EMC_MRW_0_MRW_MA_FIELD                  (_MK_MASK_CONST(0xff) << EMC_MRW_0_MRW_MA_SHIFT)
#define EMC_MRW_0_MRW_MA_RANGE                  23:16
#define EMC_MRW_0_MRW_MA_WOFFSET                        0x0
#define EMC_MRW_0_MRW_MA_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_MRW_0_MRW_MA_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_MRW_0_MRW_MA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_MRW_0_MRW_MA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// active-low chip-select,  0x0 applies command to both devices, 0x2 to for only dev0, 0x1 for dev1.
#define EMC_MRW_0_MRW_DEV_SELECTN_SHIFT                 _MK_SHIFT_CONST(30)
#define EMC_MRW_0_MRW_DEV_SELECTN_FIELD                 (_MK_MASK_CONST(0x3) << EMC_MRW_0_MRW_DEV_SELECTN_SHIFT)
#define EMC_MRW_0_MRW_DEV_SELECTN_RANGE                 31:30
#define EMC_MRW_0_MRW_DEV_SELECTN_WOFFSET                       0x0
#define EMC_MRW_0_MRW_DEV_SELECTN_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_MRW_0_MRW_DEV_SELECTN_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_MRW_0_MRW_DEV_SELECTN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_MRW_0_MRW_DEV_SELECTN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_MRR_0  // Command trigger: MRR
#define EMC_MRR_0                       _MK_ADDR_CONST(0xec)
#define EMC_MRR_0_SECURE                        0x0
#define EMC_MRR_0_WORD_COUNT                    0x1
#define EMC_MRR_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_MRR_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_MRR_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_MRR_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_MRR_0_READ_MASK                     _MK_MASK_CONST(0xffff)
#define EMC_MRR_0_WRITE_MASK                    _MK_MASK_CONST(0xc0ff0000)
// data returned
#define EMC_MRR_0_MRR_DATA_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_MRR_0_MRR_DATA_FIELD                        (_MK_MASK_CONST(0xffff) << EMC_MRR_0_MRR_DATA_SHIFT)
#define EMC_MRR_0_MRR_DATA_RANGE                        15:0
#define EMC_MRR_0_MRR_DATA_WOFFSET                      0x0
#define EMC_MRR_0_MRR_DATA_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_MRR_0_MRR_DATA_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_MRR_0_MRR_DATA_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_MRR_0_MRR_DATA_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// register address
#define EMC_MRR_0_MRR_MA_SHIFT                  _MK_SHIFT_CONST(16)
#define EMC_MRR_0_MRR_MA_FIELD                  (_MK_MASK_CONST(0xff) << EMC_MRR_0_MRR_MA_SHIFT)
#define EMC_MRR_0_MRR_MA_RANGE                  23:16
#define EMC_MRR_0_MRR_MA_WOFFSET                        0x0
#define EMC_MRR_0_MRR_MA_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_MRR_0_MRR_MA_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_MRR_0_MRR_MA_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_MRR_0_MRR_MA_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// active-low chip-select, choose which device to send the command to. (enum for safety).
#define EMC_MRR_0_MRR_DEV_SELECTN_SHIFT                 _MK_SHIFT_CONST(30)
#define EMC_MRR_0_MRR_DEV_SELECTN_FIELD                 (_MK_MASK_CONST(0x3) << EMC_MRR_0_MRR_DEV_SELECTN_SHIFT)
#define EMC_MRR_0_MRR_DEV_SELECTN_RANGE                 31:30
#define EMC_MRR_0_MRR_DEV_SELECTN_WOFFSET                       0x0
#define EMC_MRR_0_MRR_DEV_SELECTN_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_MRR_0_MRR_DEV_SELECTN_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_MRR_0_MRR_DEV_SELECTN_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_MRR_0_MRR_DEV_SELECTN_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_MRR_0_MRR_DEV_SELECTN_ILLEGAL                       _MK_ENUM_CONST(0)
#define EMC_MRR_0_MRR_DEV_SELECTN_DEV1                  _MK_ENUM_CONST(1)
#define EMC_MRR_0_MRR_DEV_SELECTN_DEV0                  _MK_ENUM_CONST(2)
#define EMC_MRR_0_MRR_DEV_SELECTN_RESERVED                      _MK_ENUM_CONST(3)


// Register EMC_CMDQ_0  // Command Queue Depth register
#define EMC_CMDQ_0                      _MK_ADDR_CONST(0xf0)
#define EMC_CMDQ_0_SECURE                       0x0
#define EMC_CMDQ_0_WORD_COUNT                   0x1
#define EMC_CMDQ_0_RESET_VAL                    _MK_MASK_CONST(0x10004408)
#define EMC_CMDQ_0_RESET_MASK                   _MK_MASK_CONST(0x1f00771f)
#define EMC_CMDQ_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_CMDQ_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_CMDQ_0_READ_MASK                    _MK_MASK_CONST(0x1f00771f)
#define EMC_CMDQ_0_WRITE_MASK                   _MK_MASK_CONST(0x1f00771f)
#define EMC_CMDQ_0_RW_DEPTH_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_CMDQ_0_RW_DEPTH_FIELD                       (_MK_MASK_CONST(0x1f) << EMC_CMDQ_0_RW_DEPTH_SHIFT)
#define EMC_CMDQ_0_RW_DEPTH_RANGE                       4:0
#define EMC_CMDQ_0_RW_DEPTH_WOFFSET                     0x0
#define EMC_CMDQ_0_RW_DEPTH_DEFAULT                     _MK_MASK_CONST(0x8)
#define EMC_CMDQ_0_RW_DEPTH_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define EMC_CMDQ_0_RW_DEPTH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CMDQ_0_RW_DEPTH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define EMC_CMDQ_0_ACT_DEPTH_SHIFT                      _MK_SHIFT_CONST(8)
#define EMC_CMDQ_0_ACT_DEPTH_FIELD                      (_MK_MASK_CONST(0x7) << EMC_CMDQ_0_ACT_DEPTH_SHIFT)
#define EMC_CMDQ_0_ACT_DEPTH_RANGE                      10:8
#define EMC_CMDQ_0_ACT_DEPTH_WOFFSET                    0x0
#define EMC_CMDQ_0_ACT_DEPTH_DEFAULT                    _MK_MASK_CONST(0x4)
#define EMC_CMDQ_0_ACT_DEPTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define EMC_CMDQ_0_ACT_DEPTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CMDQ_0_ACT_DEPTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define EMC_CMDQ_0_PRE_DEPTH_SHIFT                      _MK_SHIFT_CONST(12)
#define EMC_CMDQ_0_PRE_DEPTH_FIELD                      (_MK_MASK_CONST(0x7) << EMC_CMDQ_0_PRE_DEPTH_SHIFT)
#define EMC_CMDQ_0_PRE_DEPTH_RANGE                      14:12
#define EMC_CMDQ_0_PRE_DEPTH_WOFFSET                    0x0
#define EMC_CMDQ_0_PRE_DEPTH_DEFAULT                    _MK_MASK_CONST(0x4)
#define EMC_CMDQ_0_PRE_DEPTH_DEFAULT_MASK                       _MK_MASK_CONST(0x7)
#define EMC_CMDQ_0_PRE_DEPTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CMDQ_0_PRE_DEPTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define EMC_CMDQ_0_RW_WD_DEPTH_SHIFT                    _MK_SHIFT_CONST(24)
#define EMC_CMDQ_0_RW_WD_DEPTH_FIELD                    (_MK_MASK_CONST(0x1f) << EMC_CMDQ_0_RW_WD_DEPTH_SHIFT)
#define EMC_CMDQ_0_RW_WD_DEPTH_RANGE                    28:24
#define EMC_CMDQ_0_RW_WD_DEPTH_WOFFSET                  0x0
#define EMC_CMDQ_0_RW_WD_DEPTH_DEFAULT                  _MK_MASK_CONST(0x10)
#define EMC_CMDQ_0_RW_WD_DEPTH_DEFAULT_MASK                     _MK_MASK_CONST(0x1f)
#define EMC_CMDQ_0_RW_WD_DEPTH_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CMDQ_0_RW_WD_DEPTH_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register EMC_FBIO_CFG1_0  // FBIO configuration register
#define EMC_FBIO_CFG1_0                 _MK_ADDR_CONST(0xf4)
#define EMC_FBIO_CFG1_0_SECURE                  0x0
#define EMC_FBIO_CFG1_0_WORD_COUNT                      0x1
#define EMC_FBIO_CFG1_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG1_0_RESET_MASK                      _MK_MASK_CONST(0x10000)
#define EMC_FBIO_CFG1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG1_0_READ_MASK                       _MK_MASK_CONST(0x10000)
#define EMC_FBIO_CFG1_0_WRITE_MASK                      _MK_MASK_CONST(0x10000)
// determines whether the output enable is the same width as data (DEN_EARLY=0) or 1/2 bit time wider on either end (DEN_EARLY=1).
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_SHIFT                     _MK_SHIFT_CONST(16)
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_FIELD                     (_MK_MASK_CONST(0x1) << EMC_FBIO_CFG1_0_CFG_DEN_EARLY_SHIFT)
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_RANGE                     16:16
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_WOFFSET                   0x0
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_INIT_ENUM                 DISABLE
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_DISABLE                   _MK_ENUM_CONST(0)
#define EMC_FBIO_CFG1_0_CFG_DEN_EARLY_ENABLE                    _MK_ENUM_CONST(1)


// Register EMC_FBIO_DQSIB_DLY_0  // FBIO configuration register
#define EMC_FBIO_DQSIB_DLY_0                    _MK_ADDR_CONST(0xf8)
#define EMC_FBIO_DQSIB_DLY_0_SECURE                     0x0
#define EMC_FBIO_DQSIB_DLY_0_WORD_COUNT                         0x1
#define EMC_FBIO_DQSIB_DLY_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_FBIO_DQSIB_DLY_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_FIELD                 (_MK_MASK_CONST(0xff) << EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_SHIFT)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_RANGE                 7:0
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_WOFFSET                       0x0
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_FIELD                 (_MK_MASK_CONST(0xff) << EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_SHIFT)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_RANGE                 15:8
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_WOFFSET                       0x0
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_FIELD                 (_MK_MASK_CONST(0xff) << EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_SHIFT)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_RANGE                 23:16
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_WOFFSET                       0x0
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_SHIFT                 _MK_SHIFT_CONST(24)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_FIELD                 (_MK_MASK_CONST(0xff) << EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_SHIFT)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_RANGE                 31:24
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_WOFFSET                       0x0
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_0_CFG_DQSIB_DLY_BYTE_3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_FBIO_DQSIB_DLY_MSB_0  // FBIO configuration register
#define EMC_FBIO_DQSIB_DLY_MSB_0                        _MK_ADDR_CONST(0xfc)
#define EMC_FBIO_DQSIB_DLY_MSB_0_SECURE                         0x0
#define EMC_FBIO_DQSIB_DLY_MSB_0_WORD_COUNT                     0x1
#define EMC_FBIO_DQSIB_DLY_MSB_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_MSB_0_RESET_MASK                     _MK_MASK_CONST(0x3030303)
#define EMC_FBIO_DQSIB_DLY_MSB_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_MSB_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_MSB_0_READ_MASK                      _MK_MASK_CONST(0x3030303)
#define EMC_FBIO_DQSIB_DLY_MSB_0_WRITE_MASK                     _MK_MASK_CONST(0x3030303)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_0_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_0_FIELD                 (_MK_MASK_CONST(0x3) << EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_0_SHIFT)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_0_RANGE                 1:0
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_0_WOFFSET                       0x0
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_0_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_1_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_1_FIELD                 (_MK_MASK_CONST(0x3) << EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_1_SHIFT)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_1_RANGE                 9:8
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_1_WOFFSET                       0x0
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_1_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_1_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_2_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_2_FIELD                 (_MK_MASK_CONST(0x3) << EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_2_SHIFT)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_2_RANGE                 17:16
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_2_WOFFSET                       0x0
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_2_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_2_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_3_SHIFT                 _MK_SHIFT_CONST(24)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_3_FIELD                 (_MK_MASK_CONST(0x3) << EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_3_SHIFT)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_3_RANGE                 25:24
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_3_WOFFSET                       0x0
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_3_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_3_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_DQSIB_DLY_MSB_0_CFG_DQSIB_DLY_MSB_BYTE_3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_FBIO_SPARE_0  // FBIO spare register
#define EMC_FBIO_SPARE_0                        _MK_ADDR_CONST(0x100)
#define EMC_FBIO_SPARE_0_SECURE                         0x0
#define EMC_FBIO_SPARE_0_WORD_COUNT                     0x1
#define EMC_FBIO_SPARE_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_SPARE_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_FBIO_SPARE_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_FBIO_SPARE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_FBIO_SPARE_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define EMC_FBIO_SPARE_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_FIELD                   (_MK_MASK_CONST(0xffffffff) << EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_SHIFT)
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_RANGE                   31:0
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_WOFFSET                 0x0
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_DEFAULT_MASK                    _MK_MASK_CONST(0xffffffff)
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_SPARE_0_CFG_FBIO_SPARE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_FBIO_CFG5_0  // FBIO configuration Register 
#define EMC_FBIO_CFG5_0                 _MK_ADDR_CONST(0x104)
#define EMC_FBIO_CFG5_0_SECURE                  0x0
#define EMC_FBIO_CFG5_0_WORD_COUNT                      0x1
#define EMC_FBIO_CFG5_0_RESET_VAL                       _MK_MASK_CONST(0x1)
#define EMC_FBIO_CFG5_0_RESET_MASK                      _MK_MASK_CONST(0x793)
#define EMC_FBIO_CFG5_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_READ_MASK                       _MK_MASK_CONST(0x793)
#define EMC_FBIO_CFG5_0_WRITE_MASK                      _MK_MASK_CONST(0x793)
// specifies which DRAM protocol to use for the attached device(s).
#define EMC_FBIO_CFG5_0_DRAM_TYPE_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_FIELD                 (_MK_MASK_CONST(0x3) << EMC_FBIO_CFG5_0_DRAM_TYPE_SHIFT)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_RANGE                 1:0
#define EMC_FBIO_CFG5_0_DRAM_TYPE_WOFFSET                       0x0
#define EMC_FBIO_CFG5_0_DRAM_TYPE_DEFAULT                       _MK_MASK_CONST(0x1)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_INIT_ENUM                     DDR1
#define EMC_FBIO_CFG5_0_DRAM_TYPE_RESERVED                      _MK_ENUM_CONST(0)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_DDR1                  _MK_ENUM_CONST(1)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_LPDDR2                        _MK_ENUM_CONST(2)
#define EMC_FBIO_CFG5_0_DRAM_TYPE_DDR2                  _MK_ENUM_CONST(3)

//  specifies whether the DRAM data-bus is 16-bits or 32-bits wide.
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_SHIFT                        _MK_SHIFT_CONST(4)
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_FIELD                        (_MK_MASK_CONST(0x1) << EMC_FBIO_CFG5_0_DRAM_WIDTH_SHIFT)
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_RANGE                        4:4
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_WOFFSET                      0x0
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_INIT_ENUM                    X32
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_X32                  _MK_ENUM_CONST(0)
#define EMC_FBIO_CFG5_0_DRAM_WIDTH_X16                  _MK_ENUM_CONST(1)

// enables differential signalling on dqs strobes (lpddr2/ddr2 options)
#define EMC_FBIO_CFG5_0_DIFFERENTIAL_DQS_SHIFT                  _MK_SHIFT_CONST(7)
#define EMC_FBIO_CFG5_0_DIFFERENTIAL_DQS_FIELD                  (_MK_MASK_CONST(0x1) << EMC_FBIO_CFG5_0_DIFFERENTIAL_DQS_SHIFT)
#define EMC_FBIO_CFG5_0_DIFFERENTIAL_DQS_RANGE                  7:7
#define EMC_FBIO_CFG5_0_DIFFERENTIAL_DQS_WOFFSET                        0x0
#define EMC_FBIO_CFG5_0_DIFFERENTIAL_DQS_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DIFFERENTIAL_DQS_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define EMC_FBIO_CFG5_0_DIFFERENTIAL_DQS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DIFFERENTIAL_DQS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DIFFERENTIAL_DQS_INIT_ENUM                      DISABLED
#define EMC_FBIO_CFG5_0_DIFFERENTIAL_DQS_DISABLED                       _MK_ENUM_CONST(0)
#define EMC_FBIO_CFG5_0_DIFFERENTIAL_DQS_ENABLED                        _MK_ENUM_CONST(1)

// enables CTT_TERMINATION mode in pads (ddr2 support)
#define EMC_FBIO_CFG5_0_CTT_TERMINATION_SHIFT                   _MK_SHIFT_CONST(8)
#define EMC_FBIO_CFG5_0_CTT_TERMINATION_FIELD                   (_MK_MASK_CONST(0x1) << EMC_FBIO_CFG5_0_CTT_TERMINATION_SHIFT)
#define EMC_FBIO_CFG5_0_CTT_TERMINATION_RANGE                   8:8
#define EMC_FBIO_CFG5_0_CTT_TERMINATION_WOFFSET                 0x0
#define EMC_FBIO_CFG5_0_CTT_TERMINATION_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_CTT_TERMINATION_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define EMC_FBIO_CFG5_0_CTT_TERMINATION_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_CTT_TERMINATION_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_CTT_TERMINATION_INIT_ENUM                       DISABLED
#define EMC_FBIO_CFG5_0_CTT_TERMINATION_DISABLED                        _MK_ENUM_CONST(0)
#define EMC_FBIO_CFG5_0_CTT_TERMINATION_ENABLED                 _MK_ENUM_CONST(1)

// enables pulldowns on dqs lines (and pullups on DQS_N if DIFFERENTIAL_DQS).
#define EMC_FBIO_CFG5_0_DQS_PULLD_SHIFT                 _MK_SHIFT_CONST(9)
#define EMC_FBIO_CFG5_0_DQS_PULLD_FIELD                 (_MK_MASK_CONST(0x1) << EMC_FBIO_CFG5_0_DQS_PULLD_SHIFT)
#define EMC_FBIO_CFG5_0_DQS_PULLD_RANGE                 9:9
#define EMC_FBIO_CFG5_0_DQS_PULLD_WOFFSET                       0x0
#define EMC_FBIO_CFG5_0_DQS_PULLD_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DQS_PULLD_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_FBIO_CFG5_0_DQS_PULLD_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DQS_PULLD_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DQS_PULLD_INIT_ENUM                     DISABLED
#define EMC_FBIO_CFG5_0_DQS_PULLD_DISABLED                      _MK_ENUM_CONST(0)
#define EMC_FBIO_CFG5_0_DQS_PULLD_ENABLED                       _MK_ENUM_CONST(1)

// disables reads/writes to a device until the precharge command has been issued by the dram internally.
#define EMC_FBIO_CFG5_0_DISABLE_CONCURRENT_AUTOPRE_SHIFT                        _MK_SHIFT_CONST(10)
#define EMC_FBIO_CFG5_0_DISABLE_CONCURRENT_AUTOPRE_FIELD                        (_MK_MASK_CONST(0x1) << EMC_FBIO_CFG5_0_DISABLE_CONCURRENT_AUTOPRE_SHIFT)
#define EMC_FBIO_CFG5_0_DISABLE_CONCURRENT_AUTOPRE_RANGE                        10:10
#define EMC_FBIO_CFG5_0_DISABLE_CONCURRENT_AUTOPRE_WOFFSET                      0x0
#define EMC_FBIO_CFG5_0_DISABLE_CONCURRENT_AUTOPRE_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DISABLE_CONCURRENT_AUTOPRE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define EMC_FBIO_CFG5_0_DISABLE_CONCURRENT_AUTOPRE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DISABLE_CONCURRENT_AUTOPRE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG5_0_DISABLE_CONCURRENT_AUTOPRE_INIT_ENUM                    DISABLED
#define EMC_FBIO_CFG5_0_DISABLE_CONCURRENT_AUTOPRE_DISABLED                     _MK_ENUM_CONST(0)
#define EMC_FBIO_CFG5_0_DISABLE_CONCURRENT_AUTOPRE_ENABLED                      _MK_ENUM_CONST(1)


// Register EMC_FBIO_WRPTR_EQ_2_0  // FBIO wrptr register
#define EMC_FBIO_WRPTR_EQ_2_0                   _MK_ADDR_CONST(0x108)
#define EMC_FBIO_WRPTR_EQ_2_0_SECURE                    0x0
#define EMC_FBIO_WRPTR_EQ_2_0_WORD_COUNT                        0x1
#define EMC_FBIO_WRPTR_EQ_2_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_FBIO_WRPTR_EQ_2_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define EMC_FBIO_WRPTR_EQ_2_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_WRPTR_EQ_2_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_FBIO_WRPTR_EQ_2_0_READ_MASK                         _MK_MASK_CONST(0xf)
#define EMC_FBIO_WRPTR_EQ_2_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_FIELD                       (_MK_MASK_CONST(0xf) << EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_SHIFT)
#define EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_RANGE                       3:0
#define EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_WOFFSET                     0x0
#define EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_WRPTR_EQ_2_0_FB_WRPTR_EQ_2_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_FBIO_QUSE_DLY_0  // FBIO configuration register
#define EMC_FBIO_QUSE_DLY_0                     _MK_ADDR_CONST(0x10c)
#define EMC_FBIO_QUSE_DLY_0_SECURE                      0x0
#define EMC_FBIO_QUSE_DLY_0_WORD_COUNT                  0x1
#define EMC_FBIO_QUSE_DLY_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EMC_FBIO_QUSE_DLY_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_FIELD                   (_MK_MASK_CONST(0xff) << EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_SHIFT)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_RANGE                   7:0
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_WOFFSET                 0x0
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_SHIFT                   _MK_SHIFT_CONST(8)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_FIELD                   (_MK_MASK_CONST(0xff) << EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_SHIFT)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_RANGE                   15:8
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_WOFFSET                 0x0
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_SHIFT                   _MK_SHIFT_CONST(16)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_FIELD                   (_MK_MASK_CONST(0xff) << EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_SHIFT)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_RANGE                   23:16
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_WOFFSET                 0x0
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_SHIFT                   _MK_SHIFT_CONST(24)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_FIELD                   (_MK_MASK_CONST(0xff) << EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_SHIFT)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_RANGE                   31:24
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_WOFFSET                 0x0
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_0_CFG_QUSE_DLY_BYTE_3_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_FBIO_QUSE_DLY_MSB_0  // FBIO configuration register
#define EMC_FBIO_QUSE_DLY_MSB_0                 _MK_ADDR_CONST(0x110)
#define EMC_FBIO_QUSE_DLY_MSB_0_SECURE                  0x0
#define EMC_FBIO_QUSE_DLY_MSB_0_WORD_COUNT                      0x1
#define EMC_FBIO_QUSE_DLY_MSB_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_MSB_0_RESET_MASK                      _MK_MASK_CONST(0x3030303)
#define EMC_FBIO_QUSE_DLY_MSB_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_MSB_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_MSB_0_READ_MASK                       _MK_MASK_CONST(0x3030303)
#define EMC_FBIO_QUSE_DLY_MSB_0_WRITE_MASK                      _MK_MASK_CONST(0x3030303)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_0_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_0_FIELD                   (_MK_MASK_CONST(0x3) << EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_0_SHIFT)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_0_RANGE                   1:0
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_0_WOFFSET                 0x0
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_0_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_1_SHIFT                   _MK_SHIFT_CONST(8)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_1_FIELD                   (_MK_MASK_CONST(0x3) << EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_1_SHIFT)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_1_RANGE                   9:8
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_1_WOFFSET                 0x0
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_1_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_2_SHIFT                   _MK_SHIFT_CONST(16)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_2_FIELD                   (_MK_MASK_CONST(0x3) << EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_2_SHIFT)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_2_RANGE                   17:16
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_2_WOFFSET                 0x0
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_2_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_2_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_3_SHIFT                   _MK_SHIFT_CONST(24)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_3_FIELD                   (_MK_MASK_CONST(0x3) << EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_3_SHIFT)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_3_RANGE                   25:24
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_3_WOFFSET                 0x0
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_3_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_3_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_3_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_FBIO_QUSE_DLY_MSB_0_CFG_QUSE_DLY_MSB_BYTE_3_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_FBIO_CFG6_0  // FBIO configuration register   
#define EMC_FBIO_CFG6_0                 _MK_ADDR_CONST(0x114)
#define EMC_FBIO_CFG6_0_SECURE                  0x0
#define EMC_FBIO_CFG6_0_WORD_COUNT                      0x1
#define EMC_FBIO_CFG6_0_RESET_VAL                       _MK_MASK_CONST(0x2)
#define EMC_FBIO_CFG6_0_RESET_MASK                      _MK_MASK_CONST(0x7)
#define EMC_FBIO_CFG6_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG6_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG6_0_READ_MASK                       _MK_MASK_CONST(0x7)
#define EMC_FBIO_CFG6_0_WRITE_MASK                      _MK_MASK_CONST(0x7)
#define EMC_FBIO_CFG6_0_CFG_QUSE_LATE_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_FBIO_CFG6_0_CFG_QUSE_LATE_FIELD                     (_MK_MASK_CONST(0x7) << EMC_FBIO_CFG6_0_CFG_QUSE_LATE_SHIFT)
#define EMC_FBIO_CFG6_0_CFG_QUSE_LATE_RANGE                     2:0
#define EMC_FBIO_CFG6_0_CFG_QUSE_LATE_WOFFSET                   0x0
#define EMC_FBIO_CFG6_0_CFG_QUSE_LATE_DEFAULT                   _MK_MASK_CONST(0x2)
#define EMC_FBIO_CFG6_0_CFG_QUSE_LATE_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define EMC_FBIO_CFG6_0_CFG_QUSE_LATE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_FBIO_CFG6_0_CFG_QUSE_LATE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Reserved address 280 [0x118] 

// Reserved address 284 [0x11c] 

// Register EMC_DQS_TRIMMER_RD0_0  
#define EMC_DQS_TRIMMER_RD0_0                   _MK_ADDR_CONST(0x120)
#define EMC_DQS_TRIMMER_RD0_0_SECURE                    0x0
#define EMC_DQS_TRIMMER_RD0_0_WORD_COUNT                        0x1
#define EMC_DQS_TRIMMER_RD0_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_READ_MASK                         _MK_MASK_CONST(0x3ff03ff)
#define EMC_DQS_TRIMMER_RD0_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_DQS_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_FIELD                        (_MK_MASK_CONST(0x3ff) << EMC_DQS_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_SHIFT)
#define EMC_DQS_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_RANGE                        9:0
#define EMC_DQS_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_WOFFSET                      0x0
#define EMC_DQS_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_QUSE_CURRENT_TRIM_VAL_BYTE_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_FIELD                 (_MK_MASK_CONST(0x3ff) << EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_SHIFT)
#define EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_RANGE                 25:16
#define EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_WOFFSET                       0x0
#define EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD0_0_DQS_CURRENT_TRIM_VAL_BYTE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_DQS_TRIMMER_RD1_0  
#define EMC_DQS_TRIMMER_RD1_0                   _MK_ADDR_CONST(0x124)
#define EMC_DQS_TRIMMER_RD1_0_SECURE                    0x0
#define EMC_DQS_TRIMMER_RD1_0_WORD_COUNT                        0x1
#define EMC_DQS_TRIMMER_RD1_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_READ_MASK                         _MK_MASK_CONST(0x3ff03ff)
#define EMC_DQS_TRIMMER_RD1_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_DQS_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_FIELD                        (_MK_MASK_CONST(0x3ff) << EMC_DQS_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_SHIFT)
#define EMC_DQS_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_RANGE                        9:0
#define EMC_DQS_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_WOFFSET                      0x0
#define EMC_DQS_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_QUSE_CURRENT_TRIM_VAL_BYTE_1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_FIELD                 (_MK_MASK_CONST(0x3ff) << EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_SHIFT)
#define EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_RANGE                 25:16
#define EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_WOFFSET                       0x0
#define EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD1_0_DQS_CURRENT_TRIM_VAL_BYTE_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_DQS_TRIMMER_RD2_0  
#define EMC_DQS_TRIMMER_RD2_0                   _MK_ADDR_CONST(0x128)
#define EMC_DQS_TRIMMER_RD2_0_SECURE                    0x0
#define EMC_DQS_TRIMMER_RD2_0_WORD_COUNT                        0x1
#define EMC_DQS_TRIMMER_RD2_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_READ_MASK                         _MK_MASK_CONST(0x3ff03ff)
#define EMC_DQS_TRIMMER_RD2_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_DQS_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_FIELD                        (_MK_MASK_CONST(0x3ff) << EMC_DQS_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_SHIFT)
#define EMC_DQS_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_RANGE                        9:0
#define EMC_DQS_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_WOFFSET                      0x0
#define EMC_DQS_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_QUSE_CURRENT_TRIM_VAL_BYTE_2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_FIELD                 (_MK_MASK_CONST(0x3ff) << EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_SHIFT)
#define EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_RANGE                 25:16
#define EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_WOFFSET                       0x0
#define EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD2_0_DQS_CURRENT_TRIM_VAL_BYTE_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_DQS_TRIMMER_RD3_0  
#define EMC_DQS_TRIMMER_RD3_0                   _MK_ADDR_CONST(0x12c)
#define EMC_DQS_TRIMMER_RD3_0_SECURE                    0x0
#define EMC_DQS_TRIMMER_RD3_0_WORD_COUNT                        0x1
#define EMC_DQS_TRIMMER_RD3_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_READ_MASK                         _MK_MASK_CONST(0x3ff03ff)
#define EMC_DQS_TRIMMER_RD3_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_DQS_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_FIELD                        (_MK_MASK_CONST(0x3ff) << EMC_DQS_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_SHIFT)
#define EMC_DQS_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_RANGE                        9:0
#define EMC_DQS_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_WOFFSET                      0x0
#define EMC_DQS_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_QUSE_CURRENT_TRIM_VAL_BYTE_3_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_FIELD                 (_MK_MASK_CONST(0x3ff) << EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_SHIFT)
#define EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_RANGE                 25:16
#define EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_WOFFSET                       0x0
#define EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DQS_TRIMMER_RD3_0_DQS_CURRENT_TRIM_VAL_BYTE_3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 304 [0x130] 

// Reserved address 308 [0x134] 

// Reserved address 312 [0x138] 

// Reserved address 316 [0x13c] 

// Register EMC_CLKEN_OVERRIDE_0  
#define EMC_CLKEN_OVERRIDE_0                    _MK_ADDR_CONST(0x140)
#define EMC_CLKEN_OVERRIDE_0_SECURE                     0x0
#define EMC_CLKEN_OVERRIDE_0_WORD_COUNT                         0x1
#define EMC_CLKEN_OVERRIDE_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_RESET_MASK                         _MK_MASK_CONST(0x7f)
#define EMC_CLKEN_OVERRIDE_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_READ_MASK                  _MK_MASK_CONST(0x7f)
#define EMC_CLKEN_OVERRIDE_0_WRITE_MASK                         _MK_MASK_CONST(0x7f)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_FIELD                        (_MK_MASK_CONST(0x1) << EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_SHIFT)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_RANGE                        0:0
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_WOFFSET                      0x0
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_INIT_ENUM                    CLK_GATED
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_CLK_GATED                    _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_CLK_ALWAYS_ON                        _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_DISABLE                      _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_ENABLE                       _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_DISABLED                     _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_ARB_CLKEN_OVR_ENABLED                      _MK_ENUM_CONST(1)

#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_SHIFT                       _MK_SHIFT_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_FIELD                       (_MK_MASK_CONST(0x1) << EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_SHIFT)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_RANGE                       1:1
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_WOFFSET                     0x0
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_INIT_ENUM                   CLK_GATED
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_CLK_GATED                   _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_CLK_ALWAYS_ON                       _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_DISABLE                     _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_ENABLE                      _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_DISABLED                    _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_CMDQ_CLKEN_OVR_ENABLED                     _MK_ENUM_CONST(1)

#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_SHIFT                      _MK_SHIFT_CONST(2)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_FIELD                      (_MK_MASK_CONST(0x1) << EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_SHIFT)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_RANGE                      2:2
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_WOFFSET                    0x0
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_INIT_ENUM                  CLK_GATED
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_CLK_GATED                  _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_CLK_ALWAYS_ON                      _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_DISABLE                    _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_ENABLE                     _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_DISABLED                   _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_DRAMC_CLKEN_OVR_ENABLED                    _MK_ENUM_CONST(1)

#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_SHIFT                 _MK_SHIFT_CONST(3)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_FIELD                 (_MK_MASK_CONST(0x1) << EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_SHIFT)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_RANGE                 3:3
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_WOFFSET                       0x0
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_INIT_ENUM                     CLK_GATED
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_CLK_GATED                     _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_CLK_ALWAYS_ON                 _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_DISABLE                       _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_ENABLE                        _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_DISABLED                      _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_RR_CLKEN_OVR_ENABLED                       _MK_ENUM_CONST(1)

#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_SHIFT                 _MK_SHIFT_CONST(4)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_FIELD                 (_MK_MASK_CONST(0x1) << EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_SHIFT)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_RANGE                 4:4
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_WOFFSET                       0x0
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_INIT_ENUM                     CLK_GATED
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_CLK_GATED                     _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_CLK_ALWAYS_ON                 _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_DISABLE                       _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_ENABLE                        _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_DISABLED                      _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_LL_CLKEN_OVR_ENABLED                       _MK_ENUM_CONST(1)

#define EMC_CLKEN_OVERRIDE_0_LLSTATS_CLKEN_OVR_SHIFT                    _MK_SHIFT_CONST(5)
#define EMC_CLKEN_OVERRIDE_0_LLSTATS_CLKEN_OVR_FIELD                    (_MK_MASK_CONST(0x1) << EMC_CLKEN_OVERRIDE_0_LLSTATS_CLKEN_OVR_SHIFT)
#define EMC_CLKEN_OVERRIDE_0_LLSTATS_CLKEN_OVR_RANGE                    5:5
#define EMC_CLKEN_OVERRIDE_0_LLSTATS_CLKEN_OVR_WOFFSET                  0x0
#define EMC_CLKEN_OVERRIDE_0_LLSTATS_CLKEN_OVR_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_LLSTATS_CLKEN_OVR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_CLKEN_OVERRIDE_0_LLSTATS_CLKEN_OVR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_LLSTATS_CLKEN_OVR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_LLSTATS_CLKEN_OVR_INIT_ENUM                        CLK_GATED
#define EMC_CLKEN_OVERRIDE_0_LLSTATS_CLKEN_OVR_CLK_GATED                        _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_LLSTATS_CLKEN_OVR_CLK_ALWAYS_ON                    _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_LLSTATS_CLKEN_OVR_DISABLE                  _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_LLSTATS_CLKEN_OVR_ENABLE                   _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_LLSTATS_CLKEN_OVR_DISABLED                 _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_LLSTATS_CLKEN_OVR_ENABLED                  _MK_ENUM_CONST(1)

#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_SHIFT                      _MK_SHIFT_CONST(6)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_FIELD                      (_MK_MASK_CONST(0x1) << EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_SHIFT)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_RANGE                      6:6
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_WOFFSET                    0x0
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_INIT_ENUM                  CLK_GATED
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_CLK_GATED                  _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_CLK_ALWAYS_ON                      _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_DISABLE                    _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_ENABLE                     _MK_ENUM_CONST(1)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_DISABLED                   _MK_ENUM_CONST(0)
#define EMC_CLKEN_OVERRIDE_0_STATS_CLKEN_OVR_ENABLED                    _MK_ENUM_CONST(1)

#define NV_MC_EMEM_DFIFO_DEPTH  4
#define NV_MC_IMEM_DFIFO_DEPTH  5
#define NV_MC_EMEM_APFIFO_DEPTH 5
#define NV_MC_ARB_EMEM_REGLEVEL 3
#define NV_MC_EMEM_REQ_ID_WIDEREQ       8
#define NV_MC_EMEM_RDI_ID_WIDERDI       8
#define NV_MC_EMEM_REQ_ID_ILLEGALACC    7
#define NV_MC_EMEM_RDI_ID_ILLEGALACC    7
#define NV_MC_EMEM_REQ_ID_LLRAWDECR     6
#define NV_MC_EMEM_RDI_ID_LLRAWDECR     6
#define NV_MC_EMEM_REQ_ID_APCIGNORE     5
#define NV_MC_EMEM_RDI_ID_APCIGNORE     5

// Packet MC2EMC
#define MC2EMC_SIZE 186

#define MC2EMC_WDO_SHIFT                        _MK_SHIFT_CONST(0)
#define MC2EMC_WDO_FIELD                        (_MK_MASK_CONST(0xffffffff) << MC2EMC_WDO_SHIFT)
#define MC2EMC_WDO_RANGE                        _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(0)
#define MC2EMC_WDO_ROW                  0

#define MC2EMC_WDO_0_SHIFT                      _MK_SHIFT_CONST(0)
#define MC2EMC_WDO_0_FIELD                      (_MK_MASK_CONST(0xffffffff) << MC2EMC_WDO_0_SHIFT)
#define MC2EMC_WDO_0_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define MC2EMC_WDO_0_ROW                        0

#define MC2EMC_WDO_1_SHIFT                      _MK_SHIFT_CONST(32)
#define MC2EMC_WDO_1_FIELD                      (_MK_MASK_CONST(0xffffffff) << MC2EMC_WDO_1_SHIFT)
#define MC2EMC_WDO_1_RANGE                      _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define MC2EMC_WDO_1_ROW                        0

#define MC2EMC_WDO_2_SHIFT                      _MK_SHIFT_CONST(64)
#define MC2EMC_WDO_2_FIELD                      (_MK_MASK_CONST(0xffffffff) << MC2EMC_WDO_2_SHIFT)
#define MC2EMC_WDO_2_RANGE                      _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define MC2EMC_WDO_2_ROW                        0

#define MC2EMC_WDO_3_SHIFT                      _MK_SHIFT_CONST(96)
#define MC2EMC_WDO_3_FIELD                      (_MK_MASK_CONST(0xffffffff) << MC2EMC_WDO_3_SHIFT)
#define MC2EMC_WDO_3_RANGE                      _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(96)
#define MC2EMC_WDO_3_ROW                        0

#define MC2EMC_BE_SHIFT                 _MK_SHIFT_CONST(128)
#define MC2EMC_BE_FIELD                 (_MK_MASK_CONST(0xffff) << MC2EMC_BE_SHIFT)
#define MC2EMC_BE_RANGE                 _MK_SHIFT_CONST(143):_MK_SHIFT_CONST(128)
#define MC2EMC_BE_ROW                   0

#define MC2EMC_ADR_SHIFT                        _MK_SHIFT_CONST(144)
#define MC2EMC_ADR_FIELD                        (_MK_MASK_CONST(0x3ffffff) << MC2EMC_ADR_SHIFT)
#define MC2EMC_ADR_RANGE                        _MK_SHIFT_CONST(169):_MK_SHIFT_CONST(144)
#define MC2EMC_ADR_ROW                  0

#define MC2EMC_REQ_ID_SHIFT                     _MK_SHIFT_CONST(170)
#define MC2EMC_REQ_ID_FIELD                     (_MK_MASK_CONST(0x1ff) << MC2EMC_REQ_ID_SHIFT)
#define MC2EMC_REQ_ID_RANGE                     _MK_SHIFT_CONST(178):_MK_SHIFT_CONST(170)
#define MC2EMC_REQ_ID_ROW                       0

#define MC2EMC_AP_SHIFT                 _MK_SHIFT_CONST(179)
#define MC2EMC_AP_FIELD                 (_MK_MASK_CONST(0x1) << MC2EMC_AP_SHIFT)
#define MC2EMC_AP_RANGE                 _MK_SHIFT_CONST(179):_MK_SHIFT_CONST(179)
#define MC2EMC_AP_ROW                   0

#define MC2EMC_WE_SHIFT                 _MK_SHIFT_CONST(180)
#define MC2EMC_WE_FIELD                 (_MK_MASK_CONST(0x1) << MC2EMC_WE_SHIFT)
#define MC2EMC_WE_RANGE                 _MK_SHIFT_CONST(180):_MK_SHIFT_CONST(180)
#define MC2EMC_WE_ROW                   0

#define MC2EMC_TAG_SHIFT                        _MK_SHIFT_CONST(181)
#define MC2EMC_TAG_FIELD                        (_MK_MASK_CONST(0x1f) << MC2EMC_TAG_SHIFT)
#define MC2EMC_TAG_RANGE                        _MK_SHIFT_CONST(185):_MK_SHIFT_CONST(181)
#define MC2EMC_TAG_ROW                  0


// Packet MC2EMC_APC
#define MC2EMC_APC_SIZE 3

#define MC2EMC_APC_CLR_SHIFT                    _MK_SHIFT_CONST(0)
#define MC2EMC_APC_CLR_FIELD                    (_MK_MASK_CONST(0x1) << MC2EMC_APC_CLR_SHIFT)
#define MC2EMC_APC_CLR_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define MC2EMC_APC_CLR_ROW                      0

#define MC2EMC_APC_BANK_SHIFT                   _MK_SHIFT_CONST(1)
#define MC2EMC_APC_BANK_FIELD                   (_MK_MASK_CONST(0x3) << MC2EMC_APC_BANK_SHIFT)
#define MC2EMC_APC_BANK_RANGE                   _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(1)
#define MC2EMC_APC_BANK_ROW                     0


// Packet EMC2MC
#define EMC2MC_SIZE 137

#define EMC2MC_RDI_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC2MC_RDI_FIELD                        (_MK_MASK_CONST(0xffffffff) << EMC2MC_RDI_SHIFT)
#define EMC2MC_RDI_RANGE                        _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(0)
#define EMC2MC_RDI_ROW                  0

#define EMC2MC_RDI_0_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC2MC_RDI_0_FIELD                      (_MK_MASK_CONST(0xffffffff) << EMC2MC_RDI_0_SHIFT)
#define EMC2MC_RDI_0_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define EMC2MC_RDI_0_ROW                        0

#define EMC2MC_RDI_1_SHIFT                      _MK_SHIFT_CONST(32)
#define EMC2MC_RDI_1_FIELD                      (_MK_MASK_CONST(0xffffffff) << EMC2MC_RDI_1_SHIFT)
#define EMC2MC_RDI_1_RANGE                      _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define EMC2MC_RDI_1_ROW                        0

#define EMC2MC_RDI_2_SHIFT                      _MK_SHIFT_CONST(64)
#define EMC2MC_RDI_2_FIELD                      (_MK_MASK_CONST(0xffffffff) << EMC2MC_RDI_2_SHIFT)
#define EMC2MC_RDI_2_RANGE                      _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define EMC2MC_RDI_2_ROW                        0

#define EMC2MC_RDI_3_SHIFT                      _MK_SHIFT_CONST(96)
#define EMC2MC_RDI_3_FIELD                      (_MK_MASK_CONST(0xffffffff) << EMC2MC_RDI_3_SHIFT)
#define EMC2MC_RDI_3_RANGE                      _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(96)
#define EMC2MC_RDI_3_ROW                        0

#define EMC2MC_RDI_ID_SHIFT                     _MK_SHIFT_CONST(128)
#define EMC2MC_RDI_ID_FIELD                     (_MK_MASK_CONST(0x1ff) << EMC2MC_RDI_ID_SHIFT)
#define EMC2MC_RDI_ID_RANGE                     _MK_SHIFT_CONST(136):_MK_SHIFT_CONST(128)
#define EMC2MC_RDI_ID_ROW                       0


// Packet MC2EMC_LL
#define MC2EMC_LL_SIZE 33

#define MC2EMC_LL_ADR_SHIFT                     _MK_SHIFT_CONST(0)
#define MC2EMC_LL_ADR_FIELD                     (_MK_MASK_CONST(0x7ffffff) << MC2EMC_LL_ADR_SHIFT)
#define MC2EMC_LL_ADR_RANGE                     _MK_SHIFT_CONST(26):_MK_SHIFT_CONST(0)
#define MC2EMC_LL_ADR_ROW                       0

#define MC2EMC_LL_TAG_SHIFT                     _MK_SHIFT_CONST(27)
#define MC2EMC_LL_TAG_FIELD                     (_MK_MASK_CONST(0x1f) << MC2EMC_LL_TAG_SHIFT)
#define MC2EMC_LL_TAG_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(27)
#define MC2EMC_LL_TAG_ROW                       0

#define MC2EMC_LL_DOUBLEREQ_SHIFT                       _MK_SHIFT_CONST(32)
#define MC2EMC_LL_DOUBLEREQ_FIELD                       (_MK_MASK_CONST(0x1) << MC2EMC_LL_DOUBLEREQ_SHIFT)
#define MC2EMC_LL_DOUBLEREQ_RANGE                       _MK_SHIFT_CONST(32):_MK_SHIFT_CONST(32)
#define MC2EMC_LL_DOUBLEREQ_ROW                 0


// Packet EMC2MC_LL
#define EMC2MC_LL_SIZE 64

#define EMC2MC_LL_RDI_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC2MC_LL_RDI_FIELD                     (_MK_MASK_CONST(0xffffffff) << EMC2MC_LL_RDI_SHIFT)
#define EMC2MC_LL_RDI_RANGE                     _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define EMC2MC_LL_RDI_ROW                       0


// Packet MC2EMC_LL_CRITINFO
#define MC2EMC_LL_CRITINFO_SIZE 11

#define MC2EMC_LL_CRITINFO_HP_SHIFT                     _MK_SHIFT_CONST(0)
#define MC2EMC_LL_CRITINFO_HP_FIELD                     (_MK_MASK_CONST(0x1f) << MC2EMC_LL_CRITINFO_HP_SHIFT)
#define MC2EMC_LL_CRITINFO_HP_RANGE                     _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(0)
#define MC2EMC_LL_CRITINFO_HP_ROW                       0

#define MC2EMC_LL_CRITINFO_TIMEOUT_SHIFT                        _MK_SHIFT_CONST(5)
#define MC2EMC_LL_CRITINFO_TIMEOUT_FIELD                        (_MK_MASK_CONST(0x3f) << MC2EMC_LL_CRITINFO_TIMEOUT_SHIFT)
#define MC2EMC_LL_CRITINFO_TIMEOUT_RANGE                        _MK_SHIFT_CONST(10):_MK_SHIFT_CONST(5)
#define MC2EMC_LL_CRITINFO_TIMEOUT_ROW                  0


// Packet MC2EMC_LL_ARBINFO
#define MC2EMC_LL_ARBINFO_SIZE 2

#define MC2EMC_LL_ARBINFO_BANK_SHIFT                    _MK_SHIFT_CONST(0)
#define MC2EMC_LL_ARBINFO_BANK_FIELD                    (_MK_MASK_CONST(0x3) << MC2EMC_LL_ARBINFO_BANK_SHIFT)
#define MC2EMC_LL_ARBINFO_BANK_RANGE                    _MK_SHIFT_CONST(1):_MK_SHIFT_CONST(0)
#define MC2EMC_LL_ARBINFO_BANK_ROW                      0


// Packet CMC2MC_AXI_A
#define CMC2MC_AXI_A_SIZE 63

#define CMC2MC_AXI_A_AADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define CMC2MC_AXI_A_AADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << CMC2MC_AXI_A_AADDR_SHIFT)
#define CMC2MC_AXI_A_AADDR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CMC2MC_AXI_A_AADDR_ROW                  0

#define CMC2MC_AXI_A_AID_SHIFT                  _MK_SHIFT_CONST(32)
#define CMC2MC_AXI_A_AID_FIELD                  (_MK_MASK_CONST(0x1fff) << CMC2MC_AXI_A_AID_SHIFT)
#define CMC2MC_AXI_A_AID_RANGE                  _MK_SHIFT_CONST(44):_MK_SHIFT_CONST(32)
#define CMC2MC_AXI_A_AID_ROW                    0

#define CMC2MC_AXI_A_ALEN_SHIFT                 _MK_SHIFT_CONST(45)
#define CMC2MC_AXI_A_ALEN_FIELD                 (_MK_MASK_CONST(0xf) << CMC2MC_AXI_A_ALEN_SHIFT)
#define CMC2MC_AXI_A_ALEN_RANGE                 _MK_SHIFT_CONST(48):_MK_SHIFT_CONST(45)
#define CMC2MC_AXI_A_ALEN_ROW                   0
#define CMC2MC_AXI_A_ALEN_ONEDATA                       _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_ALEN_TWODATA                       _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_ALEN_THREEDATA                     _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_ALEN_FOURDATA                      _MK_ENUM_CONST(3)
#define CMC2MC_AXI_A_ALEN_FIVEDATA                      _MK_ENUM_CONST(4)
#define CMC2MC_AXI_A_ALEN_SIXDATA                       _MK_ENUM_CONST(5)
#define CMC2MC_AXI_A_ALEN_SEVENDATA                     _MK_ENUM_CONST(6)
#define CMC2MC_AXI_A_ALEN_EIGHTDATA                     _MK_ENUM_CONST(7)
#define CMC2MC_AXI_A_ALEN_NINEDATA                      _MK_ENUM_CONST(8)
#define CMC2MC_AXI_A_ALEN_TENDATA                       _MK_ENUM_CONST(9)
#define CMC2MC_AXI_A_ALEN_ELEVENDATA                    _MK_ENUM_CONST(10)
#define CMC2MC_AXI_A_ALEN_TWELVEDATA                    _MK_ENUM_CONST(11)
#define CMC2MC_AXI_A_ALEN_THIRTEENDATA                  _MK_ENUM_CONST(12)
#define CMC2MC_AXI_A_ALEN_FOURTEENDATA                  _MK_ENUM_CONST(13)
#define CMC2MC_AXI_A_ALEN_FIFTHTEENDATA                 _MK_ENUM_CONST(14)
#define CMC2MC_AXI_A_ALEN_SIXTEENDATA                   _MK_ENUM_CONST(15)

#define CMC2MC_AXI_A_ASIZE_SHIFT                        _MK_SHIFT_CONST(49)
#define CMC2MC_AXI_A_ASIZE_FIELD                        (_MK_MASK_CONST(0x7) << CMC2MC_AXI_A_ASIZE_SHIFT)
#define CMC2MC_AXI_A_ASIZE_RANGE                        _MK_SHIFT_CONST(51):_MK_SHIFT_CONST(49)
#define CMC2MC_AXI_A_ASIZE_ROW                  0
#define CMC2MC_AXI_A_ASIZE_ONEBYTE                      _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_ASIZE_TWOBYTES                     _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_ASIZE_FOURBYTES                    _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_ASIZE_EIGHTBYTES                   _MK_ENUM_CONST(3)
#define CMC2MC_AXI_A_ASIZE_SIXTEENBYTES                 _MK_ENUM_CONST(4)
#define CMC2MC_AXI_A_ASIZE_THIRTYTWOBYTES                       _MK_ENUM_CONST(5)
#define CMC2MC_AXI_A_ASIZE_SIXTYFOURBYTES                       _MK_ENUM_CONST(6)
#define CMC2MC_AXI_A_ASIZE_ONEHUNDREDTWENTYEIGHTBYTES                   _MK_ENUM_CONST(7)

#define CMC2MC_AXI_A_ABURST_SHIFT                       _MK_SHIFT_CONST(52)
#define CMC2MC_AXI_A_ABURST_FIELD                       (_MK_MASK_CONST(0x3) << CMC2MC_AXI_A_ABURST_SHIFT)
#define CMC2MC_AXI_A_ABURST_RANGE                       _MK_SHIFT_CONST(53):_MK_SHIFT_CONST(52)
#define CMC2MC_AXI_A_ABURST_ROW                 0
#define CMC2MC_AXI_A_ABURST_FIXED                       _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_ABURST_INCR                        _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_ABURST_WRAP                        _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_ABURST_RSVD                        _MK_ENUM_CONST(3)

#define CMC2MC_AXI_A_ALOCK_SHIFT                        _MK_SHIFT_CONST(54)
#define CMC2MC_AXI_A_ALOCK_FIELD                        (_MK_MASK_CONST(0x3) << CMC2MC_AXI_A_ALOCK_SHIFT)
#define CMC2MC_AXI_A_ALOCK_RANGE                        _MK_SHIFT_CONST(55):_MK_SHIFT_CONST(54)
#define CMC2MC_AXI_A_ALOCK_ROW                  0
#define CMC2MC_AXI_A_ALOCK_NORMAL                       _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_ALOCK_EXCLUSIVE                    _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_ALOCK_LOCKED                       _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_ALOCK_RSVD                 _MK_ENUM_CONST(3)

#define CMC2MC_AXI_A_ACACHE_SHIFT                       _MK_SHIFT_CONST(56)
#define CMC2MC_AXI_A_ACACHE_FIELD                       (_MK_MASK_CONST(0xf) << CMC2MC_AXI_A_ACACHE_SHIFT)
#define CMC2MC_AXI_A_ACACHE_RANGE                       _MK_SHIFT_CONST(59):_MK_SHIFT_CONST(56)
#define CMC2MC_AXI_A_ACACHE_ROW                 0
#define CMC2MC_AXI_A_ACACHE_NONCACHEABLE_NONBUFFERABLE                  _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_ACACHE_BUFFERABLE                  _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_ACACHE_CACHEABLE_DONOTALLOCATE                     _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_ACACHE_CACHEABLE_BUFFERABLE_DONOTALLOCATE                  _MK_ENUM_CONST(3)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREAD                        _MK_ENUM_CONST(6)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREAD                   _MK_ENUM_CONST(7)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONWRITE                       _MK_ENUM_CONST(10)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONWRITE                  _MK_ENUM_CONST(11)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREADWRITE                   _MK_ENUM_CONST(14)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREADWRITE                      _MK_ENUM_CONST(15)

#define CMC2MC_AXI_A_APROT_SHIFT                        _MK_SHIFT_CONST(60)
#define CMC2MC_AXI_A_APROT_FIELD                        (_MK_MASK_CONST(0x7) << CMC2MC_AXI_A_APROT_SHIFT)
#define CMC2MC_AXI_A_APROT_RANGE                        _MK_SHIFT_CONST(62):_MK_SHIFT_CONST(60)
#define CMC2MC_AXI_A_APROT_ROW                  0
#define CMC2MC_AXI_A_APROT_DATA_SECURE_NORMAL                   _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_APROT_DATA_SECURE_PRIVILEGED                       _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_APROT_DATA_NONSECURE_NORMAL                        _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_APROT_DATA_NONSECURE_PRIVILEGED                    _MK_ENUM_CONST(3)
#define CMC2MC_AXI_A_APROT_INST_SECURE_NORMAL                   _MK_ENUM_CONST(4)
#define CMC2MC_AXI_A_APROT_INST_SECURE_PRIVILEGED                       _MK_ENUM_CONST(5)
#define CMC2MC_AXI_A_APROT_INST_NONSECURE_NORMAL                        _MK_ENUM_CONST(6)
#define CMC2MC_AXI_A_APROT_INST_NONSECURE_PRIVILEGED                    _MK_ENUM_CONST(7)


// Packet CMC2MC_AXI_W
#define CMC2MC_AXI_W_SIZE 86

#define CMC2MC_AXI_W_WDATA_SHIFT                        _MK_SHIFT_CONST(0)
#define CMC2MC_AXI_W_WDATA_FIELD                        (_MK_MASK_CONST(0xffffffff) << CMC2MC_AXI_W_WDATA_SHIFT)
#define CMC2MC_AXI_W_WDATA_RANGE                        _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define CMC2MC_AXI_W_WDATA_ROW                  0

#define CMC2MC_AXI_W_WID_SHIFT                  _MK_SHIFT_CONST(64)
#define CMC2MC_AXI_W_WID_FIELD                  (_MK_MASK_CONST(0x1fff) << CMC2MC_AXI_W_WID_SHIFT)
#define CMC2MC_AXI_W_WID_RANGE                  _MK_SHIFT_CONST(76):_MK_SHIFT_CONST(64)
#define CMC2MC_AXI_W_WID_ROW                    0

#define CMC2MC_AXI_W_WSTRB_SHIFT                        _MK_SHIFT_CONST(77)
#define CMC2MC_AXI_W_WSTRB_FIELD                        (_MK_MASK_CONST(0xff) << CMC2MC_AXI_W_WSTRB_SHIFT)
#define CMC2MC_AXI_W_WSTRB_RANGE                        _MK_SHIFT_CONST(84):_MK_SHIFT_CONST(77)
#define CMC2MC_AXI_W_WSTRB_ROW                  0

#define CMC2MC_AXI_W_WLAST_SHIFT                        _MK_SHIFT_CONST(85)
#define CMC2MC_AXI_W_WLAST_FIELD                        (_MK_MASK_CONST(0x1) << CMC2MC_AXI_W_WLAST_SHIFT)
#define CMC2MC_AXI_W_WLAST_RANGE                        _MK_SHIFT_CONST(85):_MK_SHIFT_CONST(85)
#define CMC2MC_AXI_W_WLAST_ROW                  0
#define CMC2MC_AXI_W_WLAST_DISABLED                     _MK_ENUM_CONST(0)
#define CMC2MC_AXI_W_WLAST_ENABLED                      _MK_ENUM_CONST(1)


// Packet CMC2MC_AXI_B
#define CMC2MC_AXI_B_SIZE 15

#define CMC2MC_AXI_B_BID_SHIFT                  _MK_SHIFT_CONST(0)
#define CMC2MC_AXI_B_BID_FIELD                  (_MK_MASK_CONST(0x1fff) << CMC2MC_AXI_B_BID_SHIFT)
#define CMC2MC_AXI_B_BID_RANGE                  _MK_SHIFT_CONST(12):_MK_SHIFT_CONST(0)
#define CMC2MC_AXI_B_BID_ROW                    0

#define CMC2MC_AXI_B_BRESP_SHIFT                        _MK_SHIFT_CONST(13)
#define CMC2MC_AXI_B_BRESP_FIELD                        (_MK_MASK_CONST(0x3) << CMC2MC_AXI_B_BRESP_SHIFT)
#define CMC2MC_AXI_B_BRESP_RANGE                        _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(13)
#define CMC2MC_AXI_B_BRESP_ROW                  0
#define CMC2MC_AXI_B_BRESP_OKAY                 _MK_ENUM_CONST(0)
#define CMC2MC_AXI_B_BRESP_EXOKAY                       _MK_ENUM_CONST(1)
#define CMC2MC_AXI_B_BRESP_SLVERR                       _MK_ENUM_CONST(2)
#define CMC2MC_AXI_B_BRESP_DECERR                       _MK_ENUM_CONST(3)


// Packet CMC2MC_AXI_R
#define CMC2MC_AXI_R_SIZE 80

#define CMC2MC_AXI_R_RDATA_SHIFT                        _MK_SHIFT_CONST(0)
#define CMC2MC_AXI_R_RDATA_FIELD                        (_MK_MASK_CONST(0xffffffff) << CMC2MC_AXI_R_RDATA_SHIFT)
#define CMC2MC_AXI_R_RDATA_RANGE                        _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define CMC2MC_AXI_R_RDATA_ROW                  0

#define CMC2MC_AXI_R_RID_SHIFT                  _MK_SHIFT_CONST(64)
#define CMC2MC_AXI_R_RID_FIELD                  (_MK_MASK_CONST(0x1fff) << CMC2MC_AXI_R_RID_SHIFT)
#define CMC2MC_AXI_R_RID_RANGE                  _MK_SHIFT_CONST(76):_MK_SHIFT_CONST(64)
#define CMC2MC_AXI_R_RID_ROW                    0

#define CMC2MC_AXI_R_RRESP_SHIFT                        _MK_SHIFT_CONST(77)
#define CMC2MC_AXI_R_RRESP_FIELD                        (_MK_MASK_CONST(0x3) << CMC2MC_AXI_R_RRESP_SHIFT)
#define CMC2MC_AXI_R_RRESP_RANGE                        _MK_SHIFT_CONST(78):_MK_SHIFT_CONST(77)
#define CMC2MC_AXI_R_RRESP_ROW                  0
#define CMC2MC_AXI_R_RRESP_OKAY                 _MK_ENUM_CONST(0)
#define CMC2MC_AXI_R_RRESP_EXOKAY                       _MK_ENUM_CONST(1)
#define CMC2MC_AXI_R_RRESP_SLVERR                       _MK_ENUM_CONST(2)
#define CMC2MC_AXI_R_RRESP_DECERR                       _MK_ENUM_CONST(3)

#define CMC2MC_AXI_R_RLAST_SHIFT                        _MK_SHIFT_CONST(79)
#define CMC2MC_AXI_R_RLAST_FIELD                        (_MK_MASK_CONST(0x1) << CMC2MC_AXI_R_RLAST_SHIFT)
#define CMC2MC_AXI_R_RLAST_RANGE                        _MK_SHIFT_CONST(79):_MK_SHIFT_CONST(79)
#define CMC2MC_AXI_R_RLAST_ROW                  0
#define CMC2MC_AXI_R_RLAST_DISABLED                     _MK_ENUM_CONST(0)
#define CMC2MC_AXI_R_RLAST_ENABLED                      _MK_ENUM_CONST(1)


// Packet MSELECT2MC_AXI_A
#define MSELECT2MC_AXI_A_SIZE 63

#define MSELECT2MC_AXI_A_AADDR_SHIFT                    _MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_A_AADDR_FIELD                    (_MK_MASK_CONST(0xffffffff) << MSELECT2MC_AXI_A_AADDR_SHIFT)
#define MSELECT2MC_AXI_A_AADDR_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_A_AADDR_ROW                      0

#define MSELECT2MC_AXI_A_AID_SHIFT                      _MK_SHIFT_CONST(32)
#define MSELECT2MC_AXI_A_AID_FIELD                      (_MK_MASK_CONST(0x1fff) << MSELECT2MC_AXI_A_AID_SHIFT)
#define MSELECT2MC_AXI_A_AID_RANGE                      _MK_SHIFT_CONST(44):_MK_SHIFT_CONST(32)
#define MSELECT2MC_AXI_A_AID_ROW                        0

#define MSELECT2MC_AXI_A_ALEN_SHIFT                     _MK_SHIFT_CONST(45)
#define MSELECT2MC_AXI_A_ALEN_FIELD                     (_MK_MASK_CONST(0xf) << MSELECT2MC_AXI_A_ALEN_SHIFT)
#define MSELECT2MC_AXI_A_ALEN_RANGE                     _MK_SHIFT_CONST(48):_MK_SHIFT_CONST(45)
#define MSELECT2MC_AXI_A_ALEN_ROW                       0
#define MSELECT2MC_AXI_A_ALEN_ONEDATA                   _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_ALEN_TWODATA                   _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_ALEN_THREEDATA                 _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_ALEN_FOURDATA                  _MK_ENUM_CONST(3)
#define MSELECT2MC_AXI_A_ALEN_FIVEDATA                  _MK_ENUM_CONST(4)
#define MSELECT2MC_AXI_A_ALEN_SIXDATA                   _MK_ENUM_CONST(5)
#define MSELECT2MC_AXI_A_ALEN_SEVENDATA                 _MK_ENUM_CONST(6)
#define MSELECT2MC_AXI_A_ALEN_EIGHTDATA                 _MK_ENUM_CONST(7)
#define MSELECT2MC_AXI_A_ALEN_NINEDATA                  _MK_ENUM_CONST(8)
#define MSELECT2MC_AXI_A_ALEN_TENDATA                   _MK_ENUM_CONST(9)
#define MSELECT2MC_AXI_A_ALEN_ELEVENDATA                        _MK_ENUM_CONST(10)
#define MSELECT2MC_AXI_A_ALEN_TWELVEDATA                        _MK_ENUM_CONST(11)
#define MSELECT2MC_AXI_A_ALEN_THIRTEENDATA                      _MK_ENUM_CONST(12)
#define MSELECT2MC_AXI_A_ALEN_FOURTEENDATA                      _MK_ENUM_CONST(13)
#define MSELECT2MC_AXI_A_ALEN_FIFTHTEENDATA                     _MK_ENUM_CONST(14)
#define MSELECT2MC_AXI_A_ALEN_SIXTEENDATA                       _MK_ENUM_CONST(15)

#define MSELECT2MC_AXI_A_ASIZE_SHIFT                    _MK_SHIFT_CONST(49)
#define MSELECT2MC_AXI_A_ASIZE_FIELD                    (_MK_MASK_CONST(0x7) << MSELECT2MC_AXI_A_ASIZE_SHIFT)
#define MSELECT2MC_AXI_A_ASIZE_RANGE                    _MK_SHIFT_CONST(51):_MK_SHIFT_CONST(49)
#define MSELECT2MC_AXI_A_ASIZE_ROW                      0
#define MSELECT2MC_AXI_A_ASIZE_ONEBYTE                  _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_ASIZE_TWOBYTES                 _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_ASIZE_FOURBYTES                        _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_ASIZE_EIGHTBYTES                       _MK_ENUM_CONST(3)
#define MSELECT2MC_AXI_A_ASIZE_SIXTEENBYTES                     _MK_ENUM_CONST(4)
#define MSELECT2MC_AXI_A_ASIZE_THIRTYTWOBYTES                   _MK_ENUM_CONST(5)
#define MSELECT2MC_AXI_A_ASIZE_SIXTYFOURBYTES                   _MK_ENUM_CONST(6)
#define MSELECT2MC_AXI_A_ASIZE_ONEHUNDREDTWENTYEIGHTBYTES                       _MK_ENUM_CONST(7)

#define MSELECT2MC_AXI_A_ABURST_SHIFT                   _MK_SHIFT_CONST(52)
#define MSELECT2MC_AXI_A_ABURST_FIELD                   (_MK_MASK_CONST(0x3) << MSELECT2MC_AXI_A_ABURST_SHIFT)
#define MSELECT2MC_AXI_A_ABURST_RANGE                   _MK_SHIFT_CONST(53):_MK_SHIFT_CONST(52)
#define MSELECT2MC_AXI_A_ABURST_ROW                     0
#define MSELECT2MC_AXI_A_ABURST_FIXED                   _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_ABURST_INCR                    _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_ABURST_WRAP                    _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_ABURST_RSVD                    _MK_ENUM_CONST(3)

#define MSELECT2MC_AXI_A_ALOCK_SHIFT                    _MK_SHIFT_CONST(54)
#define MSELECT2MC_AXI_A_ALOCK_FIELD                    (_MK_MASK_CONST(0x3) << MSELECT2MC_AXI_A_ALOCK_SHIFT)
#define MSELECT2MC_AXI_A_ALOCK_RANGE                    _MK_SHIFT_CONST(55):_MK_SHIFT_CONST(54)
#define MSELECT2MC_AXI_A_ALOCK_ROW                      0
#define MSELECT2MC_AXI_A_ALOCK_NORMAL                   _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_ALOCK_EXCLUSIVE                        _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_ALOCK_LOCKED                   _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_ALOCK_RSVD                     _MK_ENUM_CONST(3)

#define MSELECT2MC_AXI_A_ACACHE_SHIFT                   _MK_SHIFT_CONST(56)
#define MSELECT2MC_AXI_A_ACACHE_FIELD                   (_MK_MASK_CONST(0xf) << MSELECT2MC_AXI_A_ACACHE_SHIFT)
#define MSELECT2MC_AXI_A_ACACHE_RANGE                   _MK_SHIFT_CONST(59):_MK_SHIFT_CONST(56)
#define MSELECT2MC_AXI_A_ACACHE_ROW                     0
#define MSELECT2MC_AXI_A_ACACHE_NONCACHEABLE_NONBUFFERABLE                      _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_ACACHE_BUFFERABLE                      _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLE_DONOTALLOCATE                 _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLE_BUFFERABLE_DONOTALLOCATE                      _MK_ENUM_CONST(3)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREAD                    _MK_ENUM_CONST(6)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREAD                       _MK_ENUM_CONST(7)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONWRITE                   _MK_ENUM_CONST(10)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONWRITE                      _MK_ENUM_CONST(11)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREADWRITE                       _MK_ENUM_CONST(14)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREADWRITE                  _MK_ENUM_CONST(15)

#define MSELECT2MC_AXI_A_APROT_SHIFT                    _MK_SHIFT_CONST(60)
#define MSELECT2MC_AXI_A_APROT_FIELD                    (_MK_MASK_CONST(0x7) << MSELECT2MC_AXI_A_APROT_SHIFT)
#define MSELECT2MC_AXI_A_APROT_RANGE                    _MK_SHIFT_CONST(62):_MK_SHIFT_CONST(60)
#define MSELECT2MC_AXI_A_APROT_ROW                      0
#define MSELECT2MC_AXI_A_APROT_DATA_SECURE_NORMAL                       _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_APROT_DATA_SECURE_PRIVILEGED                   _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_APROT_DATA_NONSECURE_NORMAL                    _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_APROT_DATA_NONSECURE_PRIVILEGED                        _MK_ENUM_CONST(3)
#define MSELECT2MC_AXI_A_APROT_INST_SECURE_NORMAL                       _MK_ENUM_CONST(4)
#define MSELECT2MC_AXI_A_APROT_INST_SECURE_PRIVILEGED                   _MK_ENUM_CONST(5)
#define MSELECT2MC_AXI_A_APROT_INST_NONSECURE_NORMAL                    _MK_ENUM_CONST(6)
#define MSELECT2MC_AXI_A_APROT_INST_NONSECURE_PRIVILEGED                        _MK_ENUM_CONST(7)


// Packet MSELECT2MC_AXI_W
#define MSELECT2MC_AXI_W_SIZE 86

#define MSELECT2MC_AXI_W_WDATA_SHIFT                    _MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_W_WDATA_FIELD                    (_MK_MASK_CONST(0xffffffff) << MSELECT2MC_AXI_W_WDATA_SHIFT)
#define MSELECT2MC_AXI_W_WDATA_RANGE                    _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_W_WDATA_ROW                      0

#define MSELECT2MC_AXI_W_WID_SHIFT                      _MK_SHIFT_CONST(64)
#define MSELECT2MC_AXI_W_WID_FIELD                      (_MK_MASK_CONST(0x1fff) << MSELECT2MC_AXI_W_WID_SHIFT)
#define MSELECT2MC_AXI_W_WID_RANGE                      _MK_SHIFT_CONST(76):_MK_SHIFT_CONST(64)
#define MSELECT2MC_AXI_W_WID_ROW                        0

#define MSELECT2MC_AXI_W_WSTRB_SHIFT                    _MK_SHIFT_CONST(77)
#define MSELECT2MC_AXI_W_WSTRB_FIELD                    (_MK_MASK_CONST(0xff) << MSELECT2MC_AXI_W_WSTRB_SHIFT)
#define MSELECT2MC_AXI_W_WSTRB_RANGE                    _MK_SHIFT_CONST(84):_MK_SHIFT_CONST(77)
#define MSELECT2MC_AXI_W_WSTRB_ROW                      0

#define MSELECT2MC_AXI_W_WLAST_SHIFT                    _MK_SHIFT_CONST(85)
#define MSELECT2MC_AXI_W_WLAST_FIELD                    (_MK_MASK_CONST(0x1) << MSELECT2MC_AXI_W_WLAST_SHIFT)
#define MSELECT2MC_AXI_W_WLAST_RANGE                    _MK_SHIFT_CONST(85):_MK_SHIFT_CONST(85)
#define MSELECT2MC_AXI_W_WLAST_ROW                      0
#define MSELECT2MC_AXI_W_WLAST_DISABLED                 _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_W_WLAST_ENABLED                  _MK_ENUM_CONST(1)


// Packet MSELECT2MC_AXI_B
#define MSELECT2MC_AXI_B_SIZE 15

#define MSELECT2MC_AXI_B_BID_SHIFT                      _MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_B_BID_FIELD                      (_MK_MASK_CONST(0x1fff) << MSELECT2MC_AXI_B_BID_SHIFT)
#define MSELECT2MC_AXI_B_BID_RANGE                      _MK_SHIFT_CONST(12):_MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_B_BID_ROW                        0

#define MSELECT2MC_AXI_B_BRESP_SHIFT                    _MK_SHIFT_CONST(13)
#define MSELECT2MC_AXI_B_BRESP_FIELD                    (_MK_MASK_CONST(0x3) << MSELECT2MC_AXI_B_BRESP_SHIFT)
#define MSELECT2MC_AXI_B_BRESP_RANGE                    _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(13)
#define MSELECT2MC_AXI_B_BRESP_ROW                      0
#define MSELECT2MC_AXI_B_BRESP_OKAY                     _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_B_BRESP_EXOKAY                   _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_B_BRESP_SLVERR                   _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_B_BRESP_DECERR                   _MK_ENUM_CONST(3)


// Packet MSELECT2MC_AXI_R
#define MSELECT2MC_AXI_R_SIZE 80

#define MSELECT2MC_AXI_R_RDATA_SHIFT                    _MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_R_RDATA_FIELD                    (_MK_MASK_CONST(0xffffffff) << MSELECT2MC_AXI_R_RDATA_SHIFT)
#define MSELECT2MC_AXI_R_RDATA_RANGE                    _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_R_RDATA_ROW                      0

#define MSELECT2MC_AXI_R_RID_SHIFT                      _MK_SHIFT_CONST(64)
#define MSELECT2MC_AXI_R_RID_FIELD                      (_MK_MASK_CONST(0x1fff) << MSELECT2MC_AXI_R_RID_SHIFT)
#define MSELECT2MC_AXI_R_RID_RANGE                      _MK_SHIFT_CONST(76):_MK_SHIFT_CONST(64)
#define MSELECT2MC_AXI_R_RID_ROW                        0

#define MSELECT2MC_AXI_R_RRESP_SHIFT                    _MK_SHIFT_CONST(77)
#define MSELECT2MC_AXI_R_RRESP_FIELD                    (_MK_MASK_CONST(0x3) << MSELECT2MC_AXI_R_RRESP_SHIFT)
#define MSELECT2MC_AXI_R_RRESP_RANGE                    _MK_SHIFT_CONST(78):_MK_SHIFT_CONST(77)
#define MSELECT2MC_AXI_R_RRESP_ROW                      0
#define MSELECT2MC_AXI_R_RRESP_OKAY                     _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_R_RRESP_EXOKAY                   _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_R_RRESP_SLVERR                   _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_R_RRESP_DECERR                   _MK_ENUM_CONST(3)

#define MSELECT2MC_AXI_R_RLAST_SHIFT                    _MK_SHIFT_CONST(79)
#define MSELECT2MC_AXI_R_RLAST_FIELD                    (_MK_MASK_CONST(0x1) << MSELECT2MC_AXI_R_RLAST_SHIFT)
#define MSELECT2MC_AXI_R_RLAST_RANGE                    _MK_SHIFT_CONST(79):_MK_SHIFT_CONST(79)
#define MSELECT2MC_AXI_R_RLAST_ROW                      0
#define MSELECT2MC_AXI_R_RLAST_DISABLED                 _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_R_RLAST_ENABLED                  _MK_ENUM_CONST(1)


// Packet AXI2MC_AXI_A
#define AXI2MC_AXI_A_SIZE 63

#define AXI2MC_AXI_A_AADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define AXI2MC_AXI_A_AADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << AXI2MC_AXI_A_AADDR_SHIFT)
#define AXI2MC_AXI_A_AADDR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define AXI2MC_AXI_A_AADDR_ROW                  0

#define AXI2MC_AXI_A_AID_SHIFT                  _MK_SHIFT_CONST(32)
#define AXI2MC_AXI_A_AID_FIELD                  (_MK_MASK_CONST(0x1fff) << AXI2MC_AXI_A_AID_SHIFT)
#define AXI2MC_AXI_A_AID_RANGE                  _MK_SHIFT_CONST(44):_MK_SHIFT_CONST(32)
#define AXI2MC_AXI_A_AID_ROW                    0

#define AXI2MC_AXI_A_ALEN_SHIFT                 _MK_SHIFT_CONST(45)
#define AXI2MC_AXI_A_ALEN_FIELD                 (_MK_MASK_CONST(0xf) << AXI2MC_AXI_A_ALEN_SHIFT)
#define AXI2MC_AXI_A_ALEN_RANGE                 _MK_SHIFT_CONST(48):_MK_SHIFT_CONST(45)
#define AXI2MC_AXI_A_ALEN_ROW                   0
#define AXI2MC_AXI_A_ALEN_ONEDATA                       _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_ALEN_TWODATA                       _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_ALEN_THREEDATA                     _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_ALEN_FOURDATA                      _MK_ENUM_CONST(3)
#define AXI2MC_AXI_A_ALEN_FIVEDATA                      _MK_ENUM_CONST(4)
#define AXI2MC_AXI_A_ALEN_SIXDATA                       _MK_ENUM_CONST(5)
#define AXI2MC_AXI_A_ALEN_SEVENDATA                     _MK_ENUM_CONST(6)
#define AXI2MC_AXI_A_ALEN_EIGHTDATA                     _MK_ENUM_CONST(7)
#define AXI2MC_AXI_A_ALEN_NINEDATA                      _MK_ENUM_CONST(8)
#define AXI2MC_AXI_A_ALEN_TENDATA                       _MK_ENUM_CONST(9)
#define AXI2MC_AXI_A_ALEN_ELEVENDATA                    _MK_ENUM_CONST(10)
#define AXI2MC_AXI_A_ALEN_TWELVEDATA                    _MK_ENUM_CONST(11)
#define AXI2MC_AXI_A_ALEN_THIRTEENDATA                  _MK_ENUM_CONST(12)
#define AXI2MC_AXI_A_ALEN_FOURTEENDATA                  _MK_ENUM_CONST(13)
#define AXI2MC_AXI_A_ALEN_FIFTHTEENDATA                 _MK_ENUM_CONST(14)
#define AXI2MC_AXI_A_ALEN_SIXTEENDATA                   _MK_ENUM_CONST(15)

#define AXI2MC_AXI_A_ASIZE_SHIFT                        _MK_SHIFT_CONST(49)
#define AXI2MC_AXI_A_ASIZE_FIELD                        (_MK_MASK_CONST(0x7) << AXI2MC_AXI_A_ASIZE_SHIFT)
#define AXI2MC_AXI_A_ASIZE_RANGE                        _MK_SHIFT_CONST(51):_MK_SHIFT_CONST(49)
#define AXI2MC_AXI_A_ASIZE_ROW                  0
#define AXI2MC_AXI_A_ASIZE_ONEBYTE                      _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_ASIZE_TWOBYTES                     _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_ASIZE_FOURBYTES                    _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_ASIZE_EIGHTBYTES                   _MK_ENUM_CONST(3)
#define AXI2MC_AXI_A_ASIZE_SIXTEENBYTES                 _MK_ENUM_CONST(4)
#define AXI2MC_AXI_A_ASIZE_THIRTYTWOBYTES                       _MK_ENUM_CONST(5)
#define AXI2MC_AXI_A_ASIZE_SIXTYFOURBYTES                       _MK_ENUM_CONST(6)
#define AXI2MC_AXI_A_ASIZE_ONEHUNDREDTWENTYEIGHTBYTES                   _MK_ENUM_CONST(7)

#define AXI2MC_AXI_A_ABURST_SHIFT                       _MK_SHIFT_CONST(52)
#define AXI2MC_AXI_A_ABURST_FIELD                       (_MK_MASK_CONST(0x3) << AXI2MC_AXI_A_ABURST_SHIFT)
#define AXI2MC_AXI_A_ABURST_RANGE                       _MK_SHIFT_CONST(53):_MK_SHIFT_CONST(52)
#define AXI2MC_AXI_A_ABURST_ROW                 0
#define AXI2MC_AXI_A_ABURST_FIXED                       _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_ABURST_INCR                        _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_ABURST_WRAP                        _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_ABURST_RSVD                        _MK_ENUM_CONST(3)

#define AXI2MC_AXI_A_ALOCK_SHIFT                        _MK_SHIFT_CONST(54)
#define AXI2MC_AXI_A_ALOCK_FIELD                        (_MK_MASK_CONST(0x3) << AXI2MC_AXI_A_ALOCK_SHIFT)
#define AXI2MC_AXI_A_ALOCK_RANGE                        _MK_SHIFT_CONST(55):_MK_SHIFT_CONST(54)
#define AXI2MC_AXI_A_ALOCK_ROW                  0
#define AXI2MC_AXI_A_ALOCK_NORMAL                       _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_ALOCK_EXCLUSIVE                    _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_ALOCK_LOCKED                       _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_ALOCK_RSVD                 _MK_ENUM_CONST(3)

#define AXI2MC_AXI_A_ACACHE_SHIFT                       _MK_SHIFT_CONST(56)
#define AXI2MC_AXI_A_ACACHE_FIELD                       (_MK_MASK_CONST(0xf) << AXI2MC_AXI_A_ACACHE_SHIFT)
#define AXI2MC_AXI_A_ACACHE_RANGE                       _MK_SHIFT_CONST(59):_MK_SHIFT_CONST(56)
#define AXI2MC_AXI_A_ACACHE_ROW                 0
#define AXI2MC_AXI_A_ACACHE_NONCACHEABLE_NONBUFFERABLE                  _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_ACACHE_BUFFERABLE                  _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_ACACHE_CACHEABLE_DONOTALLOCATE                     _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_ACACHE_CACHEABLE_BUFFERABLE_DONOTALLOCATE                  _MK_ENUM_CONST(3)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREAD                        _MK_ENUM_CONST(6)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREAD                   _MK_ENUM_CONST(7)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONWRITE                       _MK_ENUM_CONST(10)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONWRITE                  _MK_ENUM_CONST(11)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREADWRITE                   _MK_ENUM_CONST(14)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREADWRITE                      _MK_ENUM_CONST(15)

#define AXI2MC_AXI_A_APROT_SHIFT                        _MK_SHIFT_CONST(60)
#define AXI2MC_AXI_A_APROT_FIELD                        (_MK_MASK_CONST(0x7) << AXI2MC_AXI_A_APROT_SHIFT)
#define AXI2MC_AXI_A_APROT_RANGE                        _MK_SHIFT_CONST(62):_MK_SHIFT_CONST(60)
#define AXI2MC_AXI_A_APROT_ROW                  0
#define AXI2MC_AXI_A_APROT_DATA_SECURE_NORMAL                   _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_APROT_DATA_SECURE_PRIVILEGED                       _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_APROT_DATA_NONSECURE_NORMAL                        _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_APROT_DATA_NONSECURE_PRIVILEGED                    _MK_ENUM_CONST(3)
#define AXI2MC_AXI_A_APROT_INST_SECURE_NORMAL                   _MK_ENUM_CONST(4)
#define AXI2MC_AXI_A_APROT_INST_SECURE_PRIVILEGED                       _MK_ENUM_CONST(5)
#define AXI2MC_AXI_A_APROT_INST_NONSECURE_NORMAL                        _MK_ENUM_CONST(6)
#define AXI2MC_AXI_A_APROT_INST_NONSECURE_PRIVILEGED                    _MK_ENUM_CONST(7)


// Packet AXI2MC_AXI_W
#define AXI2MC_AXI_W_SIZE 302

#define AXI2MC_AXI_W_WDATA_SHIFT                        _MK_SHIFT_CONST(0)
#define AXI2MC_AXI_W_WDATA_FIELD                        (_MK_MASK_CONST(0xffffffff) << AXI2MC_AXI_W_WDATA_SHIFT)
#define AXI2MC_AXI_W_WDATA_RANGE                        _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(0)
#define AXI2MC_AXI_W_WDATA_ROW                  0

#define AXI2MC_AXI_W_WID_SHIFT                  _MK_SHIFT_CONST(256)
#define AXI2MC_AXI_W_WID_FIELD                  (_MK_MASK_CONST(0x1fff) << AXI2MC_AXI_W_WID_SHIFT)
#define AXI2MC_AXI_W_WID_RANGE                  _MK_SHIFT_CONST(268):_MK_SHIFT_CONST(256)
#define AXI2MC_AXI_W_WID_ROW                    0

#define AXI2MC_AXI_W_WSTRB_SHIFT                        _MK_SHIFT_CONST(269)
#define AXI2MC_AXI_W_WSTRB_FIELD                        (_MK_MASK_CONST(0xffffffff) << AXI2MC_AXI_W_WSTRB_SHIFT)
#define AXI2MC_AXI_W_WSTRB_RANGE                        _MK_SHIFT_CONST(300):_MK_SHIFT_CONST(269)
#define AXI2MC_AXI_W_WSTRB_ROW                  0

#define AXI2MC_AXI_W_WLAST_SHIFT                        _MK_SHIFT_CONST(301)
#define AXI2MC_AXI_W_WLAST_FIELD                        (_MK_MASK_CONST(0x1) << AXI2MC_AXI_W_WLAST_SHIFT)
#define AXI2MC_AXI_W_WLAST_RANGE                        _MK_SHIFT_CONST(301):_MK_SHIFT_CONST(301)
#define AXI2MC_AXI_W_WLAST_ROW                  0
#define AXI2MC_AXI_W_WLAST_DISABLED                     _MK_ENUM_CONST(0)
#define AXI2MC_AXI_W_WLAST_ENABLED                      _MK_ENUM_CONST(1)


// Packet AXI2MC_AXI_B
#define AXI2MC_AXI_B_SIZE 15

#define AXI2MC_AXI_B_BID_SHIFT                  _MK_SHIFT_CONST(0)
#define AXI2MC_AXI_B_BID_FIELD                  (_MK_MASK_CONST(0x1fff) << AXI2MC_AXI_B_BID_SHIFT)
#define AXI2MC_AXI_B_BID_RANGE                  _MK_SHIFT_CONST(12):_MK_SHIFT_CONST(0)
#define AXI2MC_AXI_B_BID_ROW                    0

#define AXI2MC_AXI_B_BRESP_SHIFT                        _MK_SHIFT_CONST(13)
#define AXI2MC_AXI_B_BRESP_FIELD                        (_MK_MASK_CONST(0x3) << AXI2MC_AXI_B_BRESP_SHIFT)
#define AXI2MC_AXI_B_BRESP_RANGE                        _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(13)
#define AXI2MC_AXI_B_BRESP_ROW                  0
#define AXI2MC_AXI_B_BRESP_OKAY                 _MK_ENUM_CONST(0)
#define AXI2MC_AXI_B_BRESP_EXOKAY                       _MK_ENUM_CONST(1)
#define AXI2MC_AXI_B_BRESP_SLVERR                       _MK_ENUM_CONST(2)
#define AXI2MC_AXI_B_BRESP_DECERR                       _MK_ENUM_CONST(3)


// Packet AXI2MC_AXI_R
#define AXI2MC_AXI_R_SIZE 272

#define AXI2MC_AXI_R_RDATA_SHIFT                        _MK_SHIFT_CONST(0)
#define AXI2MC_AXI_R_RDATA_FIELD                        (_MK_MASK_CONST(0xffffffff) << AXI2MC_AXI_R_RDATA_SHIFT)
#define AXI2MC_AXI_R_RDATA_RANGE                        _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(0)
#define AXI2MC_AXI_R_RDATA_ROW                  0

#define AXI2MC_AXI_R_RID_SHIFT                  _MK_SHIFT_CONST(256)
#define AXI2MC_AXI_R_RID_FIELD                  (_MK_MASK_CONST(0x1fff) << AXI2MC_AXI_R_RID_SHIFT)
#define AXI2MC_AXI_R_RID_RANGE                  _MK_SHIFT_CONST(268):_MK_SHIFT_CONST(256)
#define AXI2MC_AXI_R_RID_ROW                    0

#define AXI2MC_AXI_R_RRESP_SHIFT                        _MK_SHIFT_CONST(269)
#define AXI2MC_AXI_R_RRESP_FIELD                        (_MK_MASK_CONST(0x3) << AXI2MC_AXI_R_RRESP_SHIFT)
#define AXI2MC_AXI_R_RRESP_RANGE                        _MK_SHIFT_CONST(270):_MK_SHIFT_CONST(269)
#define AXI2MC_AXI_R_RRESP_ROW                  0
#define AXI2MC_AXI_R_RRESP_OKAY                 _MK_ENUM_CONST(0)
#define AXI2MC_AXI_R_RRESP_EXOKAY                       _MK_ENUM_CONST(1)
#define AXI2MC_AXI_R_RRESP_SLVERR                       _MK_ENUM_CONST(2)
#define AXI2MC_AXI_R_RRESP_DECERR                       _MK_ENUM_CONST(3)

#define AXI2MC_AXI_R_RLAST_SHIFT                        _MK_SHIFT_CONST(271)
#define AXI2MC_AXI_R_RLAST_FIELD                        (_MK_MASK_CONST(0x1) << AXI2MC_AXI_R_RLAST_SHIFT)
#define AXI2MC_AXI_R_RLAST_RANGE                        _MK_SHIFT_CONST(271):_MK_SHIFT_CONST(271)
#define AXI2MC_AXI_R_RLAST_ROW                  0
#define AXI2MC_AXI_R_RLAST_DISABLED                     _MK_ENUM_CONST(0)
#define AXI2MC_AXI_R_RLAST_ENABLED                      _MK_ENUM_CONST(1)


// Packet MC_AXI_RWREQ
#define MC_AXI_RWREQ_SIZE 112

#define MC_AXI_RWREQ_AADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define MC_AXI_RWREQ_AADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << MC_AXI_RWREQ_AADDR_SHIFT)
#define MC_AXI_RWREQ_AADDR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define MC_AXI_RWREQ_AADDR_ROW                  0

#define MC_AXI_RWREQ_AID_SHIFT                  _MK_SHIFT_CONST(32)
#define MC_AXI_RWREQ_AID_FIELD                  (_MK_MASK_CONST(0x1fff) << MC_AXI_RWREQ_AID_SHIFT)
#define MC_AXI_RWREQ_AID_RANGE                  _MK_SHIFT_CONST(44):_MK_SHIFT_CONST(32)
#define MC_AXI_RWREQ_AID_ROW                    0

#define MC_AXI_RWREQ_ALEN_SHIFT                 _MK_SHIFT_CONST(45)
#define MC_AXI_RWREQ_ALEN_FIELD                 (_MK_MASK_CONST(0xf) << MC_AXI_RWREQ_ALEN_SHIFT)
#define MC_AXI_RWREQ_ALEN_RANGE                 _MK_SHIFT_CONST(48):_MK_SHIFT_CONST(45)
#define MC_AXI_RWREQ_ALEN_ROW                   0

#define MC_AXI_RWREQ_ASIZE_SHIFT                        _MK_SHIFT_CONST(49)
#define MC_AXI_RWREQ_ASIZE_FIELD                        (_MK_MASK_CONST(0x7) << MC_AXI_RWREQ_ASIZE_SHIFT)
#define MC_AXI_RWREQ_ASIZE_RANGE                        _MK_SHIFT_CONST(51):_MK_SHIFT_CONST(49)
#define MC_AXI_RWREQ_ASIZE_ROW                  2

#define MC_AXI_RWREQ_ABURST_SHIFT                       _MK_SHIFT_CONST(52)
#define MC_AXI_RWREQ_ABURST_FIELD                       (_MK_MASK_CONST(0x3) << MC_AXI_RWREQ_ABURST_SHIFT)
#define MC_AXI_RWREQ_ABURST_RANGE                       _MK_SHIFT_CONST(53):_MK_SHIFT_CONST(52)
#define MC_AXI_RWREQ_ABURST_ROW                 0
#define MC_AXI_RWREQ_ABURST_FIXED                       _MK_ENUM_CONST(0)
#define MC_AXI_RWREQ_ABURST_INCR                        _MK_ENUM_CONST(1)
#define MC_AXI_RWREQ_ABURST_WRAP                        _MK_ENUM_CONST(2)
#define MC_AXI_RWREQ_ABURST_RSVD                        _MK_ENUM_CONST(3)

#define MC_AXI_RWREQ_ALOCK_SHIFT                        _MK_SHIFT_CONST(54)
#define MC_AXI_RWREQ_ALOCK_FIELD                        (_MK_MASK_CONST(0x3) << MC_AXI_RWREQ_ALOCK_SHIFT)
#define MC_AXI_RWREQ_ALOCK_RANGE                        _MK_SHIFT_CONST(55):_MK_SHIFT_CONST(54)
#define MC_AXI_RWREQ_ALOCK_ROW                  0

#define MC_AXI_RWREQ_ACACHE_SHIFT                       _MK_SHIFT_CONST(56)
#define MC_AXI_RWREQ_ACACHE_FIELD                       (_MK_MASK_CONST(0xf) << MC_AXI_RWREQ_ACACHE_SHIFT)
#define MC_AXI_RWREQ_ACACHE_RANGE                       _MK_SHIFT_CONST(59):_MK_SHIFT_CONST(56)
#define MC_AXI_RWREQ_ACACHE_ROW                 0

#define MC_AXI_RWREQ_APROT_SHIFT                        _MK_SHIFT_CONST(60)
#define MC_AXI_RWREQ_APROT_FIELD                        (_MK_MASK_CONST(0x7) << MC_AXI_RWREQ_APROT_SHIFT)
#define MC_AXI_RWREQ_APROT_RANGE                        _MK_SHIFT_CONST(62):_MK_SHIFT_CONST(60)
#define MC_AXI_RWREQ_APROT_ROW                  0

#define MC_AXI_RWREQ_ASB_SHIFT                  _MK_SHIFT_CONST(63)
#define MC_AXI_RWREQ_ASB_FIELD                  (_MK_MASK_CONST(0x3) << MC_AXI_RWREQ_ASB_SHIFT)
#define MC_AXI_RWREQ_ASB_RANGE                  _MK_SHIFT_CONST(64):_MK_SHIFT_CONST(63)
#define MC_AXI_RWREQ_ASB_ROW                    0

#define MC_AXI_RWREQ_ARW_SHIFT                  _MK_SHIFT_CONST(65)
#define MC_AXI_RWREQ_ARW_FIELD                  (_MK_MASK_CONST(0x1) << MC_AXI_RWREQ_ARW_SHIFT)
#define MC_AXI_RWREQ_ARW_RANGE                  _MK_SHIFT_CONST(65):_MK_SHIFT_CONST(65)
#define MC_AXI_RWREQ_ARW_ROW                    0

#define MC_AXI_RWREQ_ACT_AADDR_SHIFT                    _MK_SHIFT_CONST(66)
#define MC_AXI_RWREQ_ACT_AADDR_FIELD                    (_MK_MASK_CONST(0xffffffff) << MC_AXI_RWREQ_ACT_AADDR_SHIFT)
#define MC_AXI_RWREQ_ACT_AADDR_RANGE                    _MK_SHIFT_CONST(97):_MK_SHIFT_CONST(66)
#define MC_AXI_RWREQ_ACT_AADDR_ROW                      0

#define MC_AXI_RWREQ_ACT_ALEN_SHIFT                     _MK_SHIFT_CONST(98)
#define MC_AXI_RWREQ_ACT_ALEN_FIELD                     (_MK_MASK_CONST(0xf) << MC_AXI_RWREQ_ACT_ALEN_SHIFT)
#define MC_AXI_RWREQ_ACT_ALEN_RANGE                     _MK_SHIFT_CONST(101):_MK_SHIFT_CONST(98)
#define MC_AXI_RWREQ_ACT_ALEN_ROW                       0

#define MC_AXI_RWREQ_ACT_ASIZE_SHIFT                    _MK_SHIFT_CONST(102)
#define MC_AXI_RWREQ_ACT_ASIZE_FIELD                    (_MK_MASK_CONST(0x7) << MC_AXI_RWREQ_ACT_ASIZE_SHIFT)
#define MC_AXI_RWREQ_ACT_ASIZE_RANGE                    _MK_SHIFT_CONST(104):_MK_SHIFT_CONST(102)
#define MC_AXI_RWREQ_ACT_ASIZE_ROW                      0

#define MC_AXI_RWREQ_DOUBLEREQ_SHIFT                    _MK_SHIFT_CONST(105)
#define MC_AXI_RWREQ_DOUBLEREQ_FIELD                    (_MK_MASK_CONST(0x1) << MC_AXI_RWREQ_DOUBLEREQ_SHIFT)
#define MC_AXI_RWREQ_DOUBLEREQ_RANGE                    _MK_SHIFT_CONST(105):_MK_SHIFT_CONST(105)
#define MC_AXI_RWREQ_DOUBLEREQ_ROW                      0

#define MC_AXI_RWREQ_ILLEGALACC_SHIFT                   _MK_SHIFT_CONST(106)
#define MC_AXI_RWREQ_ILLEGALACC_FIELD                   (_MK_MASK_CONST(0x1) << MC_AXI_RWREQ_ILLEGALACC_SHIFT)
#define MC_AXI_RWREQ_ILLEGALACC_RANGE                   _MK_SHIFT_CONST(106):_MK_SHIFT_CONST(106)
#define MC_AXI_RWREQ_ILLEGALACC_ROW                     0

#define MC_AXI_RWREQ_TAG_SHIFT                  _MK_SHIFT_CONST(107)
#define MC_AXI_RWREQ_TAG_FIELD                  (_MK_MASK_CONST(0x1f) << MC_AXI_RWREQ_TAG_SHIFT)
#define MC_AXI_RWREQ_TAG_RANGE                  _MK_SHIFT_CONST(111):_MK_SHIFT_CONST(107)
#define MC_AXI_RWREQ_TAG_ROW                    0


// Packet CSR_C2MC_RESET
#define CSR_C2MC_RESET_SIZE 1

#define CSR_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CSR_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CSR_C2MC_RESET_RSTN_SHIFT)
#define CSR_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CSR_C2MC_RESET_RSTN_ROW                 0


// Packet CSR_C2MC_REQ
#define CSR_C2MC_REQ_SIZE 32

#define CSR_C2MC_REQ_ADR_SHIFT                  _MK_SHIFT_CONST(0)
#define CSR_C2MC_REQ_ADR_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSR_C2MC_REQ_ADR_SHIFT)
#define CSR_C2MC_REQ_ADR_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSR_C2MC_REQ_ADR_ROW                    0


// Packet CSR_C2MC_SIZE
#define CSR_C2MC_SIZE_SIZE 1

#define CSR_C2MC_SIZE_SIZE_SHIFT                        _MK_SHIFT_CONST(0)
#define CSR_C2MC_SIZE_SIZE_FIELD                        (_MK_MASK_CONST(0x1) << CSR_C2MC_SIZE_SIZE_SHIFT)
#define CSR_C2MC_SIZE_SIZE_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CSR_C2MC_SIZE_SIZE_ROW                  0


// Packet CSR_C2MC_SECURE
#define CSR_C2MC_SECURE_SIZE 1

#define CSR_C2MC_SECURE_SECURE_SHIFT                    _MK_SHIFT_CONST(0)
#define CSR_C2MC_SECURE_SECURE_FIELD                    (_MK_MASK_CONST(0x1) << CSR_C2MC_SECURE_SECURE_SHIFT)
#define CSR_C2MC_SECURE_SECURE_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CSR_C2MC_SECURE_SECURE_ROW                      0


// Packet CSR_C2MC_TAG
#define CSR_C2MC_TAG_SIZE 5

#define CSR_C2MC_TAG_TAG_SHIFT                  _MK_SHIFT_CONST(0)
#define CSR_C2MC_TAG_TAG_FIELD                  (_MK_MASK_CONST(0x1f) << CSR_C2MC_TAG_TAG_SHIFT)
#define CSR_C2MC_TAG_TAG_RANGE                  _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(0)
#define CSR_C2MC_TAG_TAG_ROW                    0


// Packet CSR_C2MC_BP_REQ
#define CSR_C2MC_BP_REQ_SIZE 48

#define CSR_C2MC_BP_REQ_BASEADR_SHIFT                   _MK_SHIFT_CONST(0)
#define CSR_C2MC_BP_REQ_BASEADR_FIELD                   (_MK_MASK_CONST(0xffffffff) << CSR_C2MC_BP_REQ_BASEADR_SHIFT)
#define CSR_C2MC_BP_REQ_BASEADR_RANGE                   _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSR_C2MC_BP_REQ_BASEADR_ROW                     0

#define CSR_C2MC_BP_REQ_PITCH_SHIFT                     _MK_SHIFT_CONST(32)
#define CSR_C2MC_BP_REQ_PITCH_FIELD                     (_MK_MASK_CONST(0xffff) << CSR_C2MC_BP_REQ_PITCH_SHIFT)
#define CSR_C2MC_BP_REQ_PITCH_RANGE                     _MK_SHIFT_CONST(47):_MK_SHIFT_CONST(32)
#define CSR_C2MC_BP_REQ_PITCH_ROW                       0


// Packet CSR_C2MC_ADRXY
#define CSR_C2MC_ADRXY_SIZE 30

#define CSR_C2MC_ADRXY_OFFX_SHIFT                       _MK_SHIFT_CONST(0)
#define CSR_C2MC_ADRXY_OFFX_FIELD                       (_MK_MASK_CONST(0xffff) << CSR_C2MC_ADRXY_OFFX_SHIFT)
#define CSR_C2MC_ADRXY_OFFX_RANGE                       _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define CSR_C2MC_ADRXY_OFFX_ROW                 0

#define CSR_C2MC_ADRXY_OFFY_SHIFT                       _MK_SHIFT_CONST(16)
#define CSR_C2MC_ADRXY_OFFY_FIELD                       (_MK_MASK_CONST(0x3fff) << CSR_C2MC_ADRXY_OFFY_SHIFT)
#define CSR_C2MC_ADRXY_OFFY_RANGE                       _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(16)
#define CSR_C2MC_ADRXY_OFFY_ROW                 0


// Packet CSR_C2MC_TILE
#define CSR_C2MC_TILE_SIZE 33

#define CSR_C2MC_TILE_LINADR_SHIFT                      _MK_SHIFT_CONST(0)
#define CSR_C2MC_TILE_LINADR_FIELD                      (_MK_MASK_CONST(0xffffffff) << CSR_C2MC_TILE_LINADR_SHIFT)
#define CSR_C2MC_TILE_LINADR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSR_C2MC_TILE_LINADR_ROW                        0

#define CSR_C2MC_TILE_TMODE_SHIFT                       _MK_SHIFT_CONST(32)
#define CSR_C2MC_TILE_TMODE_FIELD                       (_MK_MASK_CONST(0x1) << CSR_C2MC_TILE_TMODE_SHIFT)
#define CSR_C2MC_TILE_TMODE_RANGE                       _MK_SHIFT_CONST(32):_MK_SHIFT_CONST(32)
#define CSR_C2MC_TILE_TMODE_ROW                 0
#define CSR_C2MC_TILE_TMODE_LINEAR                      _MK_ENUM_CONST(0)
#define CSR_C2MC_TILE_TMODE_TILED                       _MK_ENUM_CONST(1)


// Packet CSR_C2MC_RDI
#define CSR_C2MC_RDI_SIZE 256

#define CSR_C2MC_RDI_RDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CSR_C2MC_RDI_RDI_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSR_C2MC_RDI_RDI_SHIFT)
#define CSR_C2MC_RDI_RDI_RANGE                  _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(0)
#define CSR_C2MC_RDI_RDI_ROW                    0


// Packet CSR_C2MC_HP
#define CSR_C2MC_HP_SIZE 38

// high-priority threshold
#define CSR_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CSR_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSR_C2MC_HP_HPTH_SHIFT)
#define CSR_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSR_C2MC_HP_HPTH_ROW                    0

// high-priority timer
#define CSR_C2MC_HP_HPTM_SHIFT                  _MK_SHIFT_CONST(32)
#define CSR_C2MC_HP_HPTM_FIELD                  (_MK_MASK_CONST(0x3f) << CSR_C2MC_HP_HPTM_SHIFT)
#define CSR_C2MC_HP_HPTM_RANGE                  _MK_SHIFT_CONST(37):_MK_SHIFT_CONST(32)
#define CSR_C2MC_HP_HPTM_ROW                    0


// Packet CSR_C2MC_HYST
#define CSR_C2MC_HYST_SIZE 32

#define CSR_C2MC_HYST_HYST_REQ_TM_SHIFT                 _MK_SHIFT_CONST(0)
#define CSR_C2MC_HYST_HYST_REQ_TM_FIELD                 (_MK_MASK_CONST(0xff) << CSR_C2MC_HYST_HYST_REQ_TM_SHIFT)
#define CSR_C2MC_HYST_HYST_REQ_TM_RANGE                 _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(0)
#define CSR_C2MC_HYST_HYST_REQ_TM_ROW                   0

#define CSR_C2MC_HYST_DHYST_TM_SHIFT                    _MK_SHIFT_CONST(8)
#define CSR_C2MC_HYST_DHYST_TM_FIELD                    (_MK_MASK_CONST(0xff) << CSR_C2MC_HYST_DHYST_TM_SHIFT)
#define CSR_C2MC_HYST_DHYST_TM_RANGE                    _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(8)
#define CSR_C2MC_HYST_DHYST_TM_ROW                      0

#define CSR_C2MC_HYST_DHYST_TH_SHIFT                    _MK_SHIFT_CONST(16)
#define CSR_C2MC_HYST_DHYST_TH_FIELD                    (_MK_MASK_CONST(0xff) << CSR_C2MC_HYST_DHYST_TH_SHIFT)
#define CSR_C2MC_HYST_DHYST_TH_RANGE                    _MK_SHIFT_CONST(23):_MK_SHIFT_CONST(16)
#define CSR_C2MC_HYST_DHYST_TH_ROW                      0

#define CSR_C2MC_HYST_HYST_TM_SHIFT                     _MK_SHIFT_CONST(24)
#define CSR_C2MC_HYST_HYST_TM_FIELD                     (_MK_MASK_CONST(0xf) << CSR_C2MC_HYST_HYST_TM_SHIFT)
#define CSR_C2MC_HYST_HYST_TM_RANGE                     _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(24)
#define CSR_C2MC_HYST_HYST_TM_ROW                       0

#define CSR_C2MC_HYST_HYST_REQ_TH_SHIFT                 _MK_SHIFT_CONST(28)
#define CSR_C2MC_HYST_HYST_REQ_TH_FIELD                 (_MK_MASK_CONST(0x7) << CSR_C2MC_HYST_HYST_REQ_TH_SHIFT)
#define CSR_C2MC_HYST_HYST_REQ_TH_RANGE                 _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(28)
#define CSR_C2MC_HYST_HYST_REQ_TH_ROW                   0

#define CSR_C2MC_HYST_HYST_EN_SHIFT                     _MK_SHIFT_CONST(31)
#define CSR_C2MC_HYST_HYST_EN_FIELD                     (_MK_MASK_CONST(0x1) << CSR_C2MC_HYST_HYST_EN_SHIFT)
#define CSR_C2MC_HYST_HYST_EN_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define CSR_C2MC_HYST_HYST_EN_ROW                       0


// Packet CSW_C2MC_RESET
#define CSW_C2MC_RESET_SIZE 1

#define CSW_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CSW_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CSW_C2MC_RESET_RSTN_SHIFT)
#define CSW_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CSW_C2MC_RESET_RSTN_ROW                 0


// Packet CSW_C2MC_REQ
#define CSW_C2MC_REQ_SIZE 321

#define CSW_C2MC_REQ_ADR_SHIFT                  _MK_SHIFT_CONST(0)
#define CSW_C2MC_REQ_ADR_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_REQ_ADR_SHIFT)
#define CSW_C2MC_REQ_ADR_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_REQ_ADR_ROW                    0

#define CSW_C2MC_REQ_BE_SHIFT                   _MK_SHIFT_CONST(32)
#define CSW_C2MC_REQ_BE_FIELD                   (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_REQ_BE_SHIFT)
#define CSW_C2MC_REQ_BE_RANGE                   _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CSW_C2MC_REQ_BE_ROW                     0

#define CSW_C2MC_REQ_WDO_SHIFT                  _MK_SHIFT_CONST(64)
#define CSW_C2MC_REQ_WDO_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_REQ_WDO_SHIFT)
#define CSW_C2MC_REQ_WDO_RANGE                  _MK_SHIFT_CONST(319):_MK_SHIFT_CONST(64)
#define CSW_C2MC_REQ_WDO_ROW                    0

#define CSW_C2MC_REQ_TAG_SHIFT                  _MK_SHIFT_CONST(320)
#define CSW_C2MC_REQ_TAG_FIELD                  (_MK_MASK_CONST(0x1) << CSW_C2MC_REQ_TAG_SHIFT)
#define CSW_C2MC_REQ_TAG_RANGE                  _MK_SHIFT_CONST(320):_MK_SHIFT_CONST(320)
#define CSW_C2MC_REQ_TAG_ROW                    0


// Packet CSW_C2MC_SECURE
#define CSW_C2MC_SECURE_SIZE 1

#define CSW_C2MC_SECURE_SECURE_SHIFT                    _MK_SHIFT_CONST(0)
#define CSW_C2MC_SECURE_SECURE_FIELD                    (_MK_MASK_CONST(0x1) << CSW_C2MC_SECURE_SECURE_SHIFT)
#define CSW_C2MC_SECURE_SECURE_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CSW_C2MC_SECURE_SECURE_ROW                      0


// Packet CSW_C2MC_BP_REQ
#define CSW_C2MC_BP_REQ_SIZE 337

#define CSW_C2MC_BP_REQ_BASEADR_SHIFT                   _MK_SHIFT_CONST(0)
#define CSW_C2MC_BP_REQ_BASEADR_FIELD                   (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_BP_REQ_BASEADR_SHIFT)
#define CSW_C2MC_BP_REQ_BASEADR_RANGE                   _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_BP_REQ_BASEADR_ROW                     0

#define CSW_C2MC_BP_REQ_PITCH_SHIFT                     _MK_SHIFT_CONST(32)
#define CSW_C2MC_BP_REQ_PITCH_FIELD                     (_MK_MASK_CONST(0xffff) << CSW_C2MC_BP_REQ_PITCH_SHIFT)
#define CSW_C2MC_BP_REQ_PITCH_RANGE                     _MK_SHIFT_CONST(47):_MK_SHIFT_CONST(32)
#define CSW_C2MC_BP_REQ_PITCH_ROW                       0

#define CSW_C2MC_BP_REQ_BE_SHIFT                        _MK_SHIFT_CONST(48)
#define CSW_C2MC_BP_REQ_BE_FIELD                        (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_BP_REQ_BE_SHIFT)
#define CSW_C2MC_BP_REQ_BE_RANGE                        _MK_SHIFT_CONST(79):_MK_SHIFT_CONST(48)
#define CSW_C2MC_BP_REQ_BE_ROW                  0

#define CSW_C2MC_BP_REQ_WDO_SHIFT                       _MK_SHIFT_CONST(80)
#define CSW_C2MC_BP_REQ_WDO_FIELD                       (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_BP_REQ_WDO_SHIFT)
#define CSW_C2MC_BP_REQ_WDO_RANGE                       _MK_SHIFT_CONST(335):_MK_SHIFT_CONST(80)
#define CSW_C2MC_BP_REQ_WDO_ROW                 0

#define CSW_C2MC_BP_REQ_TAG_SHIFT                       _MK_SHIFT_CONST(336)
#define CSW_C2MC_BP_REQ_TAG_FIELD                       (_MK_MASK_CONST(0x1) << CSW_C2MC_BP_REQ_TAG_SHIFT)
#define CSW_C2MC_BP_REQ_TAG_RANGE                       _MK_SHIFT_CONST(336):_MK_SHIFT_CONST(336)
#define CSW_C2MC_BP_REQ_TAG_ROW                 0


// Packet CSW_C2MC_ADRXY
#define CSW_C2MC_ADRXY_SIZE 30

#define CSW_C2MC_ADRXY_OFFX_SHIFT                       _MK_SHIFT_CONST(0)
#define CSW_C2MC_ADRXY_OFFX_FIELD                       (_MK_MASK_CONST(0xffff) << CSW_C2MC_ADRXY_OFFX_SHIFT)
#define CSW_C2MC_ADRXY_OFFX_RANGE                       _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define CSW_C2MC_ADRXY_OFFX_ROW                 0

#define CSW_C2MC_ADRXY_OFFY_SHIFT                       _MK_SHIFT_CONST(16)
#define CSW_C2MC_ADRXY_OFFY_FIELD                       (_MK_MASK_CONST(0x3fff) << CSW_C2MC_ADRXY_OFFY_SHIFT)
#define CSW_C2MC_ADRXY_OFFY_RANGE                       _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(16)
#define CSW_C2MC_ADRXY_OFFY_ROW                 0


// Packet CSW_C2MC_TILE
#define CSW_C2MC_TILE_SIZE 33

#define CSW_C2MC_TILE_LINADR_SHIFT                      _MK_SHIFT_CONST(0)
#define CSW_C2MC_TILE_LINADR_FIELD                      (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_TILE_LINADR_SHIFT)
#define CSW_C2MC_TILE_LINADR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_TILE_LINADR_ROW                        0

#define CSW_C2MC_TILE_TMODE_SHIFT                       _MK_SHIFT_CONST(32)
#define CSW_C2MC_TILE_TMODE_FIELD                       (_MK_MASK_CONST(0x1) << CSW_C2MC_TILE_TMODE_SHIFT)
#define CSW_C2MC_TILE_TMODE_RANGE                       _MK_SHIFT_CONST(32):_MK_SHIFT_CONST(32)
#define CSW_C2MC_TILE_TMODE_ROW                 0
#define CSW_C2MC_TILE_TMODE_LINEAR                      _MK_ENUM_CONST(0)
#define CSW_C2MC_TILE_TMODE_TILED                       _MK_ENUM_CONST(1)


// Packet CSW_C2MC_XDI
#define CSW_C2MC_XDI_SIZE 32

// sometimes fake data
#define CSW_C2MC_XDI_XDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CSW_C2MC_XDI_XDI_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_XDI_XDI_SHIFT)
#define CSW_C2MC_XDI_XDI_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_XDI_XDI_ROW                    0


// Packet CSW_C2MC_HP
#define CSW_C2MC_HP_SIZE 32

// high-priority threshold
#define CSW_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CSW_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_HP_HPTH_SHIFT)
#define CSW_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_HP_HPTH_ROW                    0


// Packet CSW_C2MC_WCOAL
#define CSW_C2MC_WCOAL_SIZE 32

// write-coalescing time-out
#define CSW_C2MC_WCOAL_WCOALTM_SHIFT                    _MK_SHIFT_CONST(0)
#define CSW_C2MC_WCOAL_WCOALTM_FIELD                    (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_WCOAL_WCOALTM_SHIFT)
#define CSW_C2MC_WCOAL_WCOALTM_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_WCOAL_WCOALTM_ROW                      0


// Packet CSW_C2MC_HYST
#define CSW_C2MC_HYST_SIZE 32

// hysteresis control register
#define CSW_C2MC_HYST_HYST_SHIFT                        _MK_SHIFT_CONST(0)
#define CSW_C2MC_HYST_HYST_FIELD                        (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_HYST_HYST_SHIFT)
#define CSW_C2MC_HYST_HYST_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_HYST_HYST_ROW                  0


// Packet CBR_C2MC_RESET
#define CBR_C2MC_RESET_SIZE 1

#define CBR_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CBR_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CBR_C2MC_RESET_RSTN_SHIFT)
#define CBR_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBR_C2MC_RESET_RSTN_ROW                 0


// Packet CBR_C2MC_REQP
#define CBR_C2MC_REQP_SIZE 263

#define CBR_C2MC_REQP_ADR_SHIFT                 _MK_SHIFT_CONST(0)
#define CBR_C2MC_REQP_ADR_FIELD                 (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_ADR_SHIFT)
#define CBR_C2MC_REQP_ADR_RANGE                 _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBR_C2MC_REQP_ADR_ROW                   0

#define CBR_C2MC_REQP_ADRU_SHIFT                        _MK_SHIFT_CONST(32)
#define CBR_C2MC_REQP_ADRU_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_ADRU_SHIFT)
#define CBR_C2MC_REQP_ADRU_RANGE                        _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CBR_C2MC_REQP_ADRU_ROW                  0

#define CBR_C2MC_REQP_ADRV_SHIFT                        _MK_SHIFT_CONST(64)
#define CBR_C2MC_REQP_ADRV_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_ADRV_SHIFT)
#define CBR_C2MC_REQP_ADRV_RANGE                        _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define CBR_C2MC_REQP_ADRV_ROW                  0

#define CBR_C2MC_REQP_LS_SHIFT                  _MK_SHIFT_CONST(96)
#define CBR_C2MC_REQP_LS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_LS_SHIFT)
#define CBR_C2MC_REQP_LS_RANGE                  _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(96)
#define CBR_C2MC_REQP_LS_ROW                    0

#define CBR_C2MC_REQP_LSUV_SHIFT                        _MK_SHIFT_CONST(128)
#define CBR_C2MC_REQP_LSUV_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_LSUV_SHIFT)
#define CBR_C2MC_REQP_LSUV_RANGE                        _MK_SHIFT_CONST(159):_MK_SHIFT_CONST(128)
#define CBR_C2MC_REQP_LSUV_ROW                  0

#define CBR_C2MC_REQP_HS_SHIFT                  _MK_SHIFT_CONST(160)
#define CBR_C2MC_REQP_HS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_HS_SHIFT)
#define CBR_C2MC_REQP_HS_RANGE                  _MK_SHIFT_CONST(191):_MK_SHIFT_CONST(160)
#define CBR_C2MC_REQP_HS_ROW                    0

#define CBR_C2MC_REQP_VS_SHIFT                  _MK_SHIFT_CONST(192)
#define CBR_C2MC_REQP_VS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_VS_SHIFT)
#define CBR_C2MC_REQP_VS_RANGE                  _MK_SHIFT_CONST(223):_MK_SHIFT_CONST(192)
#define CBR_C2MC_REQP_VS_ROW                    0

#define CBR_C2MC_REQP_DL_SHIFT                  _MK_SHIFT_CONST(224)
#define CBR_C2MC_REQP_DL_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_DL_SHIFT)
#define CBR_C2MC_REQP_DL_RANGE                  _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(224)
#define CBR_C2MC_REQP_DL_ROW                    0

#define CBR_C2MC_REQP_HD_SHIFT                  _MK_SHIFT_CONST(256)
#define CBR_C2MC_REQP_HD_FIELD                  (_MK_MASK_CONST(0x1) << CBR_C2MC_REQP_HD_SHIFT)
#define CBR_C2MC_REQP_HD_RANGE                  _MK_SHIFT_CONST(256):_MK_SHIFT_CONST(256)
#define CBR_C2MC_REQP_HD_ROW                    0

#define CBR_C2MC_REQP_VD_SHIFT                  _MK_SHIFT_CONST(257)
#define CBR_C2MC_REQP_VD_FIELD                  (_MK_MASK_CONST(0x1) << CBR_C2MC_REQP_VD_SHIFT)
#define CBR_C2MC_REQP_VD_RANGE                  _MK_SHIFT_CONST(257):_MK_SHIFT_CONST(257)
#define CBR_C2MC_REQP_VD_ROW                    0

#define CBR_C2MC_REQP_VX2_SHIFT                 _MK_SHIFT_CONST(258)
#define CBR_C2MC_REQP_VX2_FIELD                 (_MK_MASK_CONST(0x1) << CBR_C2MC_REQP_VX2_SHIFT)
#define CBR_C2MC_REQP_VX2_RANGE                 _MK_SHIFT_CONST(258):_MK_SHIFT_CONST(258)
#define CBR_C2MC_REQP_VX2_ROW                   0

#define CBR_C2MC_REQP_LP_SHIFT                  _MK_SHIFT_CONST(259)
#define CBR_C2MC_REQP_LP_FIELD                  (_MK_MASK_CONST(0x1) << CBR_C2MC_REQP_LP_SHIFT)
#define CBR_C2MC_REQP_LP_RANGE                  _MK_SHIFT_CONST(259):_MK_SHIFT_CONST(259)
#define CBR_C2MC_REQP_LP_ROW                    0

#define CBR_C2MC_REQP_YUV_SHIFT                 _MK_SHIFT_CONST(260)
#define CBR_C2MC_REQP_YUV_FIELD                 (_MK_MASK_CONST(0x7) << CBR_C2MC_REQP_YUV_SHIFT)
#define CBR_C2MC_REQP_YUV_RANGE                 _MK_SHIFT_CONST(262):_MK_SHIFT_CONST(260)
#define CBR_C2MC_REQP_YUV_ROW                   0


// Packet CBR_C2MC_SECURE
#define CBR_C2MC_SECURE_SIZE 1

#define CBR_C2MC_SECURE_SECURE_SHIFT                    _MK_SHIFT_CONST(0)
#define CBR_C2MC_SECURE_SECURE_FIELD                    (_MK_MASK_CONST(0x1) << CBR_C2MC_SECURE_SECURE_SHIFT)
#define CBR_C2MC_SECURE_SECURE_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBR_C2MC_SECURE_SECURE_ROW                      0


// Packet CBR_C2MC_ADRXY
#define CBR_C2MC_ADRXY_SIZE 44

#define CBR_C2MC_ADRXY_OFFX_SHIFT                       _MK_SHIFT_CONST(0)
#define CBR_C2MC_ADRXY_OFFX_FIELD                       (_MK_MASK_CONST(0xffff) << CBR_C2MC_ADRXY_OFFX_SHIFT)
#define CBR_C2MC_ADRXY_OFFX_RANGE                       _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define CBR_C2MC_ADRXY_OFFX_ROW                 0

#define CBR_C2MC_ADRXY_OFFY_SHIFT                       _MK_SHIFT_CONST(16)
#define CBR_C2MC_ADRXY_OFFY_FIELD                       (_MK_MASK_CONST(0x3fff) << CBR_C2MC_ADRXY_OFFY_SHIFT)
#define CBR_C2MC_ADRXY_OFFY_RANGE                       _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(16)
#define CBR_C2MC_ADRXY_OFFY_ROW                 0

#define CBR_C2MC_ADRXY_OFFYUV_SHIFT                     _MK_SHIFT_CONST(30)
#define CBR_C2MC_ADRXY_OFFYUV_FIELD                     (_MK_MASK_CONST(0x3fff) << CBR_C2MC_ADRXY_OFFYUV_SHIFT)
#define CBR_C2MC_ADRXY_OFFYUV_RANGE                     _MK_SHIFT_CONST(43):_MK_SHIFT_CONST(30)
#define CBR_C2MC_ADRXY_OFFYUV_ROW                       0


// Packet CBR_C2MC_TILE
#define CBR_C2MC_TILE_SIZE 98

#define CBR_C2MC_TILE_LINADR_SHIFT                      _MK_SHIFT_CONST(0)
#define CBR_C2MC_TILE_LINADR_FIELD                      (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_TILE_LINADR_SHIFT)
#define CBR_C2MC_TILE_LINADR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBR_C2MC_TILE_LINADR_ROW                        0

#define CBR_C2MC_TILE_LINADRU_SHIFT                     _MK_SHIFT_CONST(32)
#define CBR_C2MC_TILE_LINADRU_FIELD                     (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_TILE_LINADRU_SHIFT)
#define CBR_C2MC_TILE_LINADRU_RANGE                     _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CBR_C2MC_TILE_LINADRU_ROW                       0

#define CBR_C2MC_TILE_LINADRV_SHIFT                     _MK_SHIFT_CONST(64)
#define CBR_C2MC_TILE_LINADRV_FIELD                     (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_TILE_LINADRV_SHIFT)
#define CBR_C2MC_TILE_LINADRV_RANGE                     _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define CBR_C2MC_TILE_LINADRV_ROW                       0

#define CBR_C2MC_TILE_TMODE_SHIFT                       _MK_SHIFT_CONST(96)
#define CBR_C2MC_TILE_TMODE_FIELD                       (_MK_MASK_CONST(0x1) << CBR_C2MC_TILE_TMODE_SHIFT)
#define CBR_C2MC_TILE_TMODE_RANGE                       _MK_SHIFT_CONST(96):_MK_SHIFT_CONST(96)
#define CBR_C2MC_TILE_TMODE_ROW                 0
#define CBR_C2MC_TILE_TMODE_LINEAR                      _MK_ENUM_CONST(0)
#define CBR_C2MC_TILE_TMODE_TILED                       _MK_ENUM_CONST(1)

#define CBR_C2MC_TILE_TMODEUV_SHIFT                     _MK_SHIFT_CONST(97)
#define CBR_C2MC_TILE_TMODEUV_FIELD                     (_MK_MASK_CONST(0x1) << CBR_C2MC_TILE_TMODEUV_SHIFT)
#define CBR_C2MC_TILE_TMODEUV_RANGE                     _MK_SHIFT_CONST(97):_MK_SHIFT_CONST(97)
#define CBR_C2MC_TILE_TMODEUV_ROW                       0
#define CBR_C2MC_TILE_TMODEUV_LINEAR                    _MK_ENUM_CONST(0)
#define CBR_C2MC_TILE_TMODEUV_TILED                     _MK_ENUM_CONST(1)


// Packet CBR_C2MC_RDYP
#define CBR_C2MC_RDYP_SIZE 1

// fake data
#define CBR_C2MC_RDYP_RDYP_SHIFT                        _MK_SHIFT_CONST(0)
#define CBR_C2MC_RDYP_RDYP_FIELD                        (_MK_MASK_CONST(0x1) << CBR_C2MC_RDYP_RDYP_SHIFT)
#define CBR_C2MC_RDYP_RDYP_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBR_C2MC_RDYP_RDYP_ROW                  0


// Packet CBR_C2MC_OUTSTD
#define CBR_C2MC_OUTSTD_SIZE 1

#define CBR_C2MC_OUTSTD_OUTSTD_SHIFT                    _MK_SHIFT_CONST(0)
#define CBR_C2MC_OUTSTD_OUTSTD_FIELD                    (_MK_MASK_CONST(0x1) << CBR_C2MC_OUTSTD_OUTSTD_SHIFT)
#define CBR_C2MC_OUTSTD_OUTSTD_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBR_C2MC_OUTSTD_OUTSTD_ROW                      0


// Packet CBR_C2MC_STOP
#define CBR_C2MC_STOP_SIZE 1

#define CBR_C2MC_STOP_STOP_SHIFT                        _MK_SHIFT_CONST(0)
#define CBR_C2MC_STOP_STOP_FIELD                        (_MK_MASK_CONST(0x1) << CBR_C2MC_STOP_STOP_SHIFT)
#define CBR_C2MC_STOP_STOP_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBR_C2MC_STOP_STOP_ROW                  0


// Packet CBR_C2MC_RDI
#define CBR_C2MC_RDI_SIZE 262

#define CBR_C2MC_RDI_RDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CBR_C2MC_RDI_RDI_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_RDI_RDI_SHIFT)
#define CBR_C2MC_RDI_RDI_RANGE                  _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(0)
#define CBR_C2MC_RDI_RDI_ROW                    0

#define CBR_C2MC_RDI_RDILST_SHIFT                       _MK_SHIFT_CONST(256)
#define CBR_C2MC_RDI_RDILST_FIELD                       (_MK_MASK_CONST(0x1) << CBR_C2MC_RDI_RDILST_SHIFT)
#define CBR_C2MC_RDI_RDILST_RANGE                       _MK_SHIFT_CONST(256):_MK_SHIFT_CONST(256)
#define CBR_C2MC_RDI_RDILST_ROW                 0

#define CBR_C2MC_RDI_RDINB_SHIFT                        _MK_SHIFT_CONST(257)
#define CBR_C2MC_RDI_RDINB_FIELD                        (_MK_MASK_CONST(0x1f) << CBR_C2MC_RDI_RDINB_SHIFT)
#define CBR_C2MC_RDI_RDINB_RANGE                        _MK_SHIFT_CONST(261):_MK_SHIFT_CONST(257)
#define CBR_C2MC_RDI_RDINB_ROW                  0


// Packet CBR_C2MC_DOREQ
#define CBR_C2MC_DOREQ_SIZE 64

#define CBR_C2MC_DOREQ_ADR_SHIFT                        _MK_SHIFT_CONST(0)
#define CBR_C2MC_DOREQ_ADR_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_DOREQ_ADR_SHIFT)
#define CBR_C2MC_DOREQ_ADR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBR_C2MC_DOREQ_ADR_ROW                  0

#define CBR_C2MC_DOREQ_LS_SHIFT                 _MK_SHIFT_CONST(32)
#define CBR_C2MC_DOREQ_LS_FIELD                 (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_DOREQ_LS_SHIFT)
#define CBR_C2MC_DOREQ_LS_RANGE                 _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CBR_C2MC_DOREQ_LS_ROW                   0


// Packet CBR_C2MC_HP
#define CBR_C2MC_HP_SIZE 71

// high-priority threshold
#define CBR_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CBR_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_HP_HPTH_SHIFT)
#define CBR_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBR_C2MC_HP_HPTH_ROW                    0

// high-priority timer
#define CBR_C2MC_HP_HPTM_SHIFT                  _MK_SHIFT_CONST(32)
#define CBR_C2MC_HP_HPTM_FIELD                  (_MK_MASK_CONST(0x3f) << CBR_C2MC_HP_HPTM_SHIFT)
#define CBR_C2MC_HP_HPTM_RANGE                  _MK_SHIFT_CONST(37):_MK_SHIFT_CONST(32)
#define CBR_C2MC_HP_HPTM_ROW                    0

// suppression - start of frame
#define CBR_C2MC_HP_HPSOF_SHIFT                 _MK_SHIFT_CONST(38)
#define CBR_C2MC_HP_HPSOF_FIELD                 (_MK_MASK_CONST(0x1) << CBR_C2MC_HP_HPSOF_SHIFT)
#define CBR_C2MC_HP_HPSOF_RANGE                 _MK_SHIFT_CONST(38):_MK_SHIFT_CONST(38)
#define CBR_C2MC_HP_HPSOF_ROW                   0

// suppression - cycles per word
#define CBR_C2MC_HP_HPCPW_SHIFT                 _MK_SHIFT_CONST(39)
#define CBR_C2MC_HP_HPCPW_FIELD                 (_MK_MASK_CONST(0xffff) << CBR_C2MC_HP_HPCPW_SHIFT)
#define CBR_C2MC_HP_HPCPW_RANGE                 _MK_SHIFT_CONST(54):_MK_SHIFT_CONST(39)
#define CBR_C2MC_HP_HPCPW_ROW                   0

// suppression - words per line
#define CBR_C2MC_HP_HPCBNPW_SHIFT                       _MK_SHIFT_CONST(55)
#define CBR_C2MC_HP_HPCBNPW_FIELD                       (_MK_MASK_CONST(0xffff) << CBR_C2MC_HP_HPCBNPW_SHIFT)
#define CBR_C2MC_HP_HPCBNPW_RANGE                       _MK_SHIFT_CONST(70):_MK_SHIFT_CONST(55)
#define CBR_C2MC_HP_HPCBNPW_ROW                 0


// Packet CBR_C2MC_HYST
#define CBR_C2MC_HYST_SIZE 32

#define CBR_C2MC_HYST_HYST_REQ_TM_SHIFT                 _MK_SHIFT_CONST(0)
#define CBR_C2MC_HYST_HYST_REQ_TM_FIELD                 (_MK_MASK_CONST(0xff) << CBR_C2MC_HYST_HYST_REQ_TM_SHIFT)
#define CBR_C2MC_HYST_HYST_REQ_TM_RANGE                 _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(0)
#define CBR_C2MC_HYST_HYST_REQ_TM_ROW                   0

#define CBR_C2MC_HYST_DHYST_TM_SHIFT                    _MK_SHIFT_CONST(8)
#define CBR_C2MC_HYST_DHYST_TM_FIELD                    (_MK_MASK_CONST(0xff) << CBR_C2MC_HYST_DHYST_TM_SHIFT)
#define CBR_C2MC_HYST_DHYST_TM_RANGE                    _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(8)
#define CBR_C2MC_HYST_DHYST_TM_ROW                      0

#define CBR_C2MC_HYST_DHYST_TH_SHIFT                    _MK_SHIFT_CONST(16)
#define CBR_C2MC_HYST_DHYST_TH_FIELD                    (_MK_MASK_CONST(0xff) << CBR_C2MC_HYST_DHYST_TH_SHIFT)
#define CBR_C2MC_HYST_DHYST_TH_RANGE                    _MK_SHIFT_CONST(23):_MK_SHIFT_CONST(16)
#define CBR_C2MC_HYST_DHYST_TH_ROW                      0

#define CBR_C2MC_HYST_HYST_TM_SHIFT                     _MK_SHIFT_CONST(24)
#define CBR_C2MC_HYST_HYST_TM_FIELD                     (_MK_MASK_CONST(0xf) << CBR_C2MC_HYST_HYST_TM_SHIFT)
#define CBR_C2MC_HYST_HYST_TM_RANGE                     _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(24)
#define CBR_C2MC_HYST_HYST_TM_ROW                       0

#define CBR_C2MC_HYST_HYST_REQ_TH_SHIFT                 _MK_SHIFT_CONST(28)
#define CBR_C2MC_HYST_HYST_REQ_TH_FIELD                 (_MK_MASK_CONST(0x7) << CBR_C2MC_HYST_HYST_REQ_TH_SHIFT)
#define CBR_C2MC_HYST_HYST_REQ_TH_RANGE                 _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(28)
#define CBR_C2MC_HYST_HYST_REQ_TH_ROW                   0

#define CBR_C2MC_HYST_HYST_EN_SHIFT                     _MK_SHIFT_CONST(31)
#define CBR_C2MC_HYST_HYST_EN_FIELD                     (_MK_MASK_CONST(0x1) << CBR_C2MC_HYST_HYST_EN_SHIFT)
#define CBR_C2MC_HYST_HYST_EN_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define CBR_C2MC_HYST_HYST_EN_ROW                       0


// Packet CBW_C2MC_RESET
#define CBW_C2MC_RESET_SIZE 1

#define CBW_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CBW_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CBW_C2MC_RESET_RSTN_SHIFT)
#define CBW_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBW_C2MC_RESET_RSTN_ROW                 0


// Packet CBW_C2MC_REQP
#define CBW_C2MC_REQP_SIZE 134

#define CBW_C2MC_REQP_ADR_SHIFT                 _MK_SHIFT_CONST(0)
#define CBW_C2MC_REQP_ADR_FIELD                 (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_REQP_ADR_SHIFT)
#define CBW_C2MC_REQP_ADR_RANGE                 _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBW_C2MC_REQP_ADR_ROW                   0

#define CBW_C2MC_REQP_LS_SHIFT                  _MK_SHIFT_CONST(32)
#define CBW_C2MC_REQP_LS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_REQP_LS_SHIFT)
#define CBW_C2MC_REQP_LS_RANGE                  _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CBW_C2MC_REQP_LS_ROW                    0

#define CBW_C2MC_REQP_HS_SHIFT                  _MK_SHIFT_CONST(64)
#define CBW_C2MC_REQP_HS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_REQP_HS_SHIFT)
#define CBW_C2MC_REQP_HS_RANGE                  _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define CBW_C2MC_REQP_HS_ROW                    0

#define CBW_C2MC_REQP_VS_SHIFT                  _MK_SHIFT_CONST(96)
#define CBW_C2MC_REQP_VS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_REQP_VS_SHIFT)
#define CBW_C2MC_REQP_VS_RANGE                  _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(96)
#define CBW_C2MC_REQP_VS_ROW                    0

#define CBW_C2MC_REQP_HD_SHIFT                  _MK_SHIFT_CONST(128)
#define CBW_C2MC_REQP_HD_FIELD                  (_MK_MASK_CONST(0x1) << CBW_C2MC_REQP_HD_SHIFT)
#define CBW_C2MC_REQP_HD_RANGE                  _MK_SHIFT_CONST(128):_MK_SHIFT_CONST(128)
#define CBW_C2MC_REQP_HD_ROW                    0

#define CBW_C2MC_REQP_VD_SHIFT                  _MK_SHIFT_CONST(129)
#define CBW_C2MC_REQP_VD_FIELD                  (_MK_MASK_CONST(0x1) << CBW_C2MC_REQP_VD_SHIFT)
#define CBW_C2MC_REQP_VD_RANGE                  _MK_SHIFT_CONST(129):_MK_SHIFT_CONST(129)
#define CBW_C2MC_REQP_VD_ROW                    0

#define CBW_C2MC_REQP_BPP_SHIFT                 _MK_SHIFT_CONST(130)
#define CBW_C2MC_REQP_BPP_FIELD                 (_MK_MASK_CONST(0x3) << CBW_C2MC_REQP_BPP_SHIFT)
#define CBW_C2MC_REQP_BPP_RANGE                 _MK_SHIFT_CONST(131):_MK_SHIFT_CONST(130)
#define CBW_C2MC_REQP_BPP_ROW                   0

#define CBW_C2MC_REQP_XY_SHIFT                  _MK_SHIFT_CONST(132)
#define CBW_C2MC_REQP_XY_FIELD                  (_MK_MASK_CONST(0x1) << CBW_C2MC_REQP_XY_SHIFT)
#define CBW_C2MC_REQP_XY_RANGE                  _MK_SHIFT_CONST(132):_MK_SHIFT_CONST(132)
#define CBW_C2MC_REQP_XY_ROW                    0

#define CBW_C2MC_REQP_PK_SHIFT                  _MK_SHIFT_CONST(133)
#define CBW_C2MC_REQP_PK_FIELD                  (_MK_MASK_CONST(0x1) << CBW_C2MC_REQP_PK_SHIFT)
#define CBW_C2MC_REQP_PK_RANGE                  _MK_SHIFT_CONST(133):_MK_SHIFT_CONST(133)
#define CBW_C2MC_REQP_PK_ROW                    0


// Packet CBW_C2MC_SECURE
#define CBW_C2MC_SECURE_SIZE 1

#define CBW_C2MC_SECURE_SECURE_SHIFT                    _MK_SHIFT_CONST(0)
#define CBW_C2MC_SECURE_SECURE_FIELD                    (_MK_MASK_CONST(0x1) << CBW_C2MC_SECURE_SECURE_SHIFT)
#define CBW_C2MC_SECURE_SECURE_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBW_C2MC_SECURE_SECURE_ROW                      0


// Packet CBW_C2MC_ADRXY
#define CBW_C2MC_ADRXY_SIZE 30

#define CBW_C2MC_ADRXY_OFFX_SHIFT                       _MK_SHIFT_CONST(0)
#define CBW_C2MC_ADRXY_OFFX_FIELD                       (_MK_MASK_CONST(0xffff) << CBW_C2MC_ADRXY_OFFX_SHIFT)
#define CBW_C2MC_ADRXY_OFFX_RANGE                       _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define CBW_C2MC_ADRXY_OFFX_ROW                 0

#define CBW_C2MC_ADRXY_OFFY_SHIFT                       _MK_SHIFT_CONST(16)
#define CBW_C2MC_ADRXY_OFFY_FIELD                       (_MK_MASK_CONST(0x3fff) << CBW_C2MC_ADRXY_OFFY_SHIFT)
#define CBW_C2MC_ADRXY_OFFY_RANGE                       _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(16)
#define CBW_C2MC_ADRXY_OFFY_ROW                 0


// Packet CBW_C2MC_TILE
#define CBW_C2MC_TILE_SIZE 33

#define CBW_C2MC_TILE_LINADR_SHIFT                      _MK_SHIFT_CONST(0)
#define CBW_C2MC_TILE_LINADR_FIELD                      (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_TILE_LINADR_SHIFT)
#define CBW_C2MC_TILE_LINADR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBW_C2MC_TILE_LINADR_ROW                        0

#define CBW_C2MC_TILE_TMODE_SHIFT                       _MK_SHIFT_CONST(32)
#define CBW_C2MC_TILE_TMODE_FIELD                       (_MK_MASK_CONST(0x1) << CBW_C2MC_TILE_TMODE_SHIFT)
#define CBW_C2MC_TILE_TMODE_RANGE                       _MK_SHIFT_CONST(32):_MK_SHIFT_CONST(32)
#define CBW_C2MC_TILE_TMODE_ROW                 0
#define CBW_C2MC_TILE_TMODE_LINEAR                      _MK_ENUM_CONST(0)
#define CBW_C2MC_TILE_TMODE_TILED                       _MK_ENUM_CONST(1)


// Packet CBW_C2MC_RDYP
#define CBW_C2MC_RDYP_SIZE 1

// fake data
#define CBW_C2MC_RDYP_RDYP_SHIFT                        _MK_SHIFT_CONST(0)
#define CBW_C2MC_RDYP_RDYP_FIELD                        (_MK_MASK_CONST(0x1) << CBW_C2MC_RDYP_RDYP_SHIFT)
#define CBW_C2MC_RDYP_RDYP_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBW_C2MC_RDYP_RDYP_ROW                  0


// Packet CBW_C2MC_STOP
#define CBW_C2MC_STOP_SIZE 1

#define CBW_C2MC_STOP_STOP_SHIFT                        _MK_SHIFT_CONST(0)
#define CBW_C2MC_STOP_STOP_FIELD                        (_MK_MASK_CONST(0x1) << CBW_C2MC_STOP_STOP_SHIFT)
#define CBW_C2MC_STOP_STOP_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBW_C2MC_STOP_STOP_ROW                  0


// Packet CBW_C2MC_XDI
#define CBW_C2MC_XDI_SIZE 1

// fake data
#define CBW_C2MC_XDI_XDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CBW_C2MC_XDI_XDI_FIELD                  (_MK_MASK_CONST(0x1) << CBW_C2MC_XDI_XDI_SHIFT)
#define CBW_C2MC_XDI_XDI_RANGE                  _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBW_C2MC_XDI_XDI_ROW                    0


// Packet CBW_C2MC_DOREQ
#define CBW_C2MC_DOREQ_SIZE 321

#define CBW_C2MC_DOREQ_ADR_SHIFT                        _MK_SHIFT_CONST(0)
#define CBW_C2MC_DOREQ_ADR_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_DOREQ_ADR_SHIFT)
#define CBW_C2MC_DOREQ_ADR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBW_C2MC_DOREQ_ADR_ROW                  0

#define CBW_C2MC_DOREQ_BE_SHIFT                 _MK_SHIFT_CONST(32)
#define CBW_C2MC_DOREQ_BE_FIELD                 (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_DOREQ_BE_SHIFT)
#define CBW_C2MC_DOREQ_BE_RANGE                 _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CBW_C2MC_DOREQ_BE_ROW                   0

#define CBW_C2MC_DOREQ_WDO_SHIFT                        _MK_SHIFT_CONST(64)
#define CBW_C2MC_DOREQ_WDO_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_DOREQ_WDO_SHIFT)
#define CBW_C2MC_DOREQ_WDO_RANGE                        _MK_SHIFT_CONST(319):_MK_SHIFT_CONST(64)
#define CBW_C2MC_DOREQ_WDO_ROW                  0

#define CBW_C2MC_DOREQ_TAG_SHIFT                        _MK_SHIFT_CONST(320)
#define CBW_C2MC_DOREQ_TAG_FIELD                        (_MK_MASK_CONST(0x1) << CBW_C2MC_DOREQ_TAG_SHIFT)
#define CBW_C2MC_DOREQ_TAG_RANGE                        _MK_SHIFT_CONST(320):_MK_SHIFT_CONST(320)
#define CBW_C2MC_DOREQ_TAG_ROW                  0


// Packet CBW_C2MC_HP
#define CBW_C2MC_HP_SIZE 32

// high-priority threshold
#define CBW_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CBW_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_HP_HPTH_SHIFT)
#define CBW_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBW_C2MC_HP_HPTH_ROW                    0


// Packet CBW_C2MC_WCOAL
#define CBW_C2MC_WCOAL_SIZE 32

// write-coalescing time-out
#define CBW_C2MC_WCOAL_WCOALTM_SHIFT                    _MK_SHIFT_CONST(0)
#define CBW_C2MC_WCOAL_WCOALTM_FIELD                    (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_WCOAL_WCOALTM_SHIFT)
#define CBW_C2MC_WCOAL_WCOALTM_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBW_C2MC_WCOAL_WCOALTM_ROW                      0


// Packet CBW_C2MC_HYST
#define CBW_C2MC_HYST_SIZE 32

#define CBW_C2MC_HYST_HYST_REQ_TM_SHIFT                 _MK_SHIFT_CONST(0)
#define CBW_C2MC_HYST_HYST_REQ_TM_FIELD                 (_MK_MASK_CONST(0xfff) << CBW_C2MC_HYST_HYST_REQ_TM_SHIFT)
#define CBW_C2MC_HYST_HYST_REQ_TM_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define CBW_C2MC_HYST_HYST_REQ_TM_ROW                   0

#define CBW_C2MC_HYST_HYST_REQ_TH_SHIFT                 _MK_SHIFT_CONST(28)
#define CBW_C2MC_HYST_HYST_REQ_TH_FIELD                 (_MK_MASK_CONST(0x7) << CBW_C2MC_HYST_HYST_REQ_TH_SHIFT)
#define CBW_C2MC_HYST_HYST_REQ_TH_RANGE                 _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(28)
#define CBW_C2MC_HYST_HYST_REQ_TH_ROW                   0

#define CBW_C2MC_HYST_HYST_EN_SHIFT                     _MK_SHIFT_CONST(31)
#define CBW_C2MC_HYST_HYST_EN_FIELD                     (_MK_MASK_CONST(0x1) << CBW_C2MC_HYST_HYST_EN_SHIFT)
#define CBW_C2MC_HYST_HYST_EN_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define CBW_C2MC_HYST_HYST_EN_ROW                       0


// Packet CCR_C2MC_RESET
#define CCR_C2MC_RESET_SIZE 1

#define CCR_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CCR_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CCR_C2MC_RESET_RSTN_SHIFT)
#define CCR_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CCR_C2MC_RESET_RSTN_ROW                 0


// Packet CCR_C2MC_REQ
#define CCR_C2MC_REQ_SIZE 101

#define CCR_C2MC_REQ_ADR_SHIFT                  _MK_SHIFT_CONST(0)
#define CCR_C2MC_REQ_ADR_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_REQ_ADR_SHIFT)
#define CCR_C2MC_REQ_ADR_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCR_C2MC_REQ_ADR_ROW                    0

#define CCR_C2MC_REQ_LS_SHIFT                   _MK_SHIFT_CONST(32)
#define CCR_C2MC_REQ_LS_FIELD                   (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_REQ_LS_SHIFT)
#define CCR_C2MC_REQ_LS_RANGE                   _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CCR_C2MC_REQ_LS_ROW                     0

// HI is apparently a reserved keyword
#define CCR_C2MC_REQ_HINC_SHIFT                 _MK_SHIFT_CONST(64)
#define CCR_C2MC_REQ_HINC_FIELD                 (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_REQ_HINC_SHIFT)
#define CCR_C2MC_REQ_HINC_RANGE                 _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define CCR_C2MC_REQ_HINC_ROW                   0

#define CCR_C2MC_REQ_ACMD_SHIFT                 _MK_SHIFT_CONST(96)
#define CCR_C2MC_REQ_ACMD_FIELD                 (_MK_MASK_CONST(0x3) << CCR_C2MC_REQ_ACMD_SHIFT)
#define CCR_C2MC_REQ_ACMD_RANGE                 _MK_SHIFT_CONST(97):_MK_SHIFT_CONST(96)
#define CCR_C2MC_REQ_ACMD_ROW                   0

#define CCR_C2MC_REQ_LN_SHIFT                   _MK_SHIFT_CONST(98)
#define CCR_C2MC_REQ_LN_FIELD                   (_MK_MASK_CONST(0x1) << CCR_C2MC_REQ_LN_SHIFT)
#define CCR_C2MC_REQ_LN_RANGE                   _MK_SHIFT_CONST(98):_MK_SHIFT_CONST(98)
#define CCR_C2MC_REQ_LN_ROW                     0

#define CCR_C2MC_REQ_HD_SHIFT                   _MK_SHIFT_CONST(99)
#define CCR_C2MC_REQ_HD_FIELD                   (_MK_MASK_CONST(0x1) << CCR_C2MC_REQ_HD_SHIFT)
#define CCR_C2MC_REQ_HD_RANGE                   _MK_SHIFT_CONST(99):_MK_SHIFT_CONST(99)
#define CCR_C2MC_REQ_HD_ROW                     0

#define CCR_C2MC_REQ_VD_SHIFT                   _MK_SHIFT_CONST(100)
#define CCR_C2MC_REQ_VD_FIELD                   (_MK_MASK_CONST(0x1) << CCR_C2MC_REQ_VD_SHIFT)
#define CCR_C2MC_REQ_VD_RANGE                   _MK_SHIFT_CONST(100):_MK_SHIFT_CONST(100)
#define CCR_C2MC_REQ_VD_ROW                     0


// Packet CCR_C2MC_SECURE
#define CCR_C2MC_SECURE_SIZE 1

#define CCR_C2MC_SECURE_SECURE_SHIFT                    _MK_SHIFT_CONST(0)
#define CCR_C2MC_SECURE_SECURE_FIELD                    (_MK_MASK_CONST(0x1) << CCR_C2MC_SECURE_SECURE_SHIFT)
#define CCR_C2MC_SECURE_SECURE_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CCR_C2MC_SECURE_SECURE_ROW                      0


// Packet CCR_C2MC_RDI
#define CCR_C2MC_RDI_SIZE 256

#define CCR_C2MC_RDI_RDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CCR_C2MC_RDI_RDI_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_RDI_RDI_SHIFT)
#define CCR_C2MC_RDI_RDI_RANGE                  _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(0)
#define CCR_C2MC_RDI_RDI_ROW                    0


// Packet CCR_C2MC_HP
#define CCR_C2MC_HP_SIZE 38

// high-priority threshold
#define CCR_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CCR_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_HP_HPTH_SHIFT)
#define CCR_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCR_C2MC_HP_HPTH_ROW                    0

// high-priority timer
#define CCR_C2MC_HP_HPTM_SHIFT                  _MK_SHIFT_CONST(32)
#define CCR_C2MC_HP_HPTM_FIELD                  (_MK_MASK_CONST(0x3f) << CCR_C2MC_HP_HPTM_SHIFT)
#define CCR_C2MC_HP_HPTM_RANGE                  _MK_SHIFT_CONST(37):_MK_SHIFT_CONST(32)
#define CCR_C2MC_HP_HPTM_ROW                    0


// Packet CCR_C2MC_HYST
#define CCR_C2MC_HYST_SIZE 32

// hysteresis control register
#define CCR_C2MC_HYST_HYST_SHIFT                        _MK_SHIFT_CONST(0)
#define CCR_C2MC_HYST_HYST_FIELD                        (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_HYST_HYST_SHIFT)
#define CCR_C2MC_HYST_HYST_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCR_C2MC_HYST_HYST_ROW                  0


// Packet CCW_C2MC_RESET
#define CCW_C2MC_RESET_SIZE 1

#define CCW_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CCW_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CCW_C2MC_RESET_RSTN_SHIFT)
#define CCW_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CCW_C2MC_RESET_RSTN_ROW                 0


// Packet CCW_C2MC_REQ
#define CCW_C2MC_REQ_SIZE 417

#define CCW_C2MC_REQ_ADR_SHIFT                  _MK_SHIFT_CONST(0)
#define CCW_C2MC_REQ_ADR_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_REQ_ADR_SHIFT)
#define CCW_C2MC_REQ_ADR_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCW_C2MC_REQ_ADR_ROW                    0

#define CCW_C2MC_REQ_LS_SHIFT                   _MK_SHIFT_CONST(32)
#define CCW_C2MC_REQ_LS_FIELD                   (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_REQ_LS_SHIFT)
#define CCW_C2MC_REQ_LS_RANGE                   _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CCW_C2MC_REQ_LS_ROW                     0

// HI is apparently a reserved keyword
#define CCW_C2MC_REQ_HINC_SHIFT                 _MK_SHIFT_CONST(64)
#define CCW_C2MC_REQ_HINC_FIELD                 (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_REQ_HINC_SHIFT)
#define CCW_C2MC_REQ_HINC_RANGE                 _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define CCW_C2MC_REQ_HINC_ROW                   0

#define CCW_C2MC_REQ_ACMD_SHIFT                 _MK_SHIFT_CONST(96)
#define CCW_C2MC_REQ_ACMD_FIELD                 (_MK_MASK_CONST(0x3) << CCW_C2MC_REQ_ACMD_SHIFT)
#define CCW_C2MC_REQ_ACMD_RANGE                 _MK_SHIFT_CONST(97):_MK_SHIFT_CONST(96)
#define CCW_C2MC_REQ_ACMD_ROW                   0

#define CCW_C2MC_REQ_LN_SHIFT                   _MK_SHIFT_CONST(98)
#define CCW_C2MC_REQ_LN_FIELD                   (_MK_MASK_CONST(0x1) << CCW_C2MC_REQ_LN_SHIFT)
#define CCW_C2MC_REQ_LN_RANGE                   _MK_SHIFT_CONST(98):_MK_SHIFT_CONST(98)
#define CCW_C2MC_REQ_LN_ROW                     0

#define CCW_C2MC_REQ_HD_SHIFT                   _MK_SHIFT_CONST(99)
#define CCW_C2MC_REQ_HD_FIELD                   (_MK_MASK_CONST(0x1) << CCW_C2MC_REQ_HD_SHIFT)
#define CCW_C2MC_REQ_HD_RANGE                   _MK_SHIFT_CONST(99):_MK_SHIFT_CONST(99)
#define CCW_C2MC_REQ_HD_ROW                     0

#define CCW_C2MC_REQ_VD_SHIFT                   _MK_SHIFT_CONST(100)
#define CCW_C2MC_REQ_VD_FIELD                   (_MK_MASK_CONST(0x1) << CCW_C2MC_REQ_VD_SHIFT)
#define CCW_C2MC_REQ_VD_RANGE                   _MK_SHIFT_CONST(100):_MK_SHIFT_CONST(100)
#define CCW_C2MC_REQ_VD_ROW                     0

#define CCW_C2MC_REQ_BPP_SHIFT                  _MK_SHIFT_CONST(101)
#define CCW_C2MC_REQ_BPP_FIELD                  (_MK_MASK_CONST(0x3) << CCW_C2MC_REQ_BPP_SHIFT)
#define CCW_C2MC_REQ_BPP_RANGE                  _MK_SHIFT_CONST(102):_MK_SHIFT_CONST(101)
#define CCW_C2MC_REQ_BPP_ROW                    0

#define CCW_C2MC_REQ_XY_SHIFT                   _MK_SHIFT_CONST(103)
#define CCW_C2MC_REQ_XY_FIELD                   (_MK_MASK_CONST(0x1) << CCW_C2MC_REQ_XY_SHIFT)
#define CCW_C2MC_REQ_XY_RANGE                   _MK_SHIFT_CONST(103):_MK_SHIFT_CONST(103)
#define CCW_C2MC_REQ_XY_ROW                     0

#define CCW_C2MC_REQ_BE_SHIFT                   _MK_SHIFT_CONST(128)
#define CCW_C2MC_REQ_BE_FIELD                   (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_REQ_BE_SHIFT)
#define CCW_C2MC_REQ_BE_RANGE                   _MK_SHIFT_CONST(159):_MK_SHIFT_CONST(128)
#define CCW_C2MC_REQ_BE_ROW                     0

#define CCW_C2MC_REQ_WDO_SHIFT                  _MK_SHIFT_CONST(160)
#define CCW_C2MC_REQ_WDO_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_REQ_WDO_SHIFT)
#define CCW_C2MC_REQ_WDO_RANGE                  _MK_SHIFT_CONST(415):_MK_SHIFT_CONST(160)
#define CCW_C2MC_REQ_WDO_ROW                    0

#define CCW_C2MC_REQ_TAG_SHIFT                  _MK_SHIFT_CONST(416)
#define CCW_C2MC_REQ_TAG_FIELD                  (_MK_MASK_CONST(0x1) << CCW_C2MC_REQ_TAG_SHIFT)
#define CCW_C2MC_REQ_TAG_RANGE                  _MK_SHIFT_CONST(416):_MK_SHIFT_CONST(416)
#define CCW_C2MC_REQ_TAG_ROW                    0


// Packet CCW_C2MC_SECURE
#define CCW_C2MC_SECURE_SIZE 1

#define CCW_C2MC_SECURE_SECURE_SHIFT                    _MK_SHIFT_CONST(0)
#define CCW_C2MC_SECURE_SECURE_FIELD                    (_MK_MASK_CONST(0x1) << CCW_C2MC_SECURE_SECURE_SHIFT)
#define CCW_C2MC_SECURE_SECURE_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CCW_C2MC_SECURE_SECURE_ROW                      0


// Packet CCW_C2MC_ADRXY
#define CCW_C2MC_ADRXY_SIZE 30

#define CCW_C2MC_ADRXY_OFFX_SHIFT                       _MK_SHIFT_CONST(0)
#define CCW_C2MC_ADRXY_OFFX_FIELD                       (_MK_MASK_CONST(0xffff) << CCW_C2MC_ADRXY_OFFX_SHIFT)
#define CCW_C2MC_ADRXY_OFFX_RANGE                       _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define CCW_C2MC_ADRXY_OFFX_ROW                 0

#define CCW_C2MC_ADRXY_OFFY_SHIFT                       _MK_SHIFT_CONST(16)
#define CCW_C2MC_ADRXY_OFFY_FIELD                       (_MK_MASK_CONST(0x3fff) << CCW_C2MC_ADRXY_OFFY_SHIFT)
#define CCW_C2MC_ADRXY_OFFY_RANGE                       _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(16)
#define CCW_C2MC_ADRXY_OFFY_ROW                 0


// Packet CCW_C2MC_TILE
#define CCW_C2MC_TILE_SIZE 33

#define CCW_C2MC_TILE_LINADR_SHIFT                      _MK_SHIFT_CONST(0)
#define CCW_C2MC_TILE_LINADR_FIELD                      (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_TILE_LINADR_SHIFT)
#define CCW_C2MC_TILE_LINADR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCW_C2MC_TILE_LINADR_ROW                        0

#define CCW_C2MC_TILE_TMODE_SHIFT                       _MK_SHIFT_CONST(32)
#define CCW_C2MC_TILE_TMODE_FIELD                       (_MK_MASK_CONST(0x1) << CCW_C2MC_TILE_TMODE_SHIFT)
#define CCW_C2MC_TILE_TMODE_RANGE                       _MK_SHIFT_CONST(32):_MK_SHIFT_CONST(32)
#define CCW_C2MC_TILE_TMODE_ROW                 0
#define CCW_C2MC_TILE_TMODE_LINEAR                      _MK_ENUM_CONST(0)
#define CCW_C2MC_TILE_TMODE_TILED                       _MK_ENUM_CONST(1)


// Packet CCW_C2MC_XDI
#define CCW_C2MC_XDI_SIZE 1

// fake data
#define CCW_C2MC_XDI_XDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CCW_C2MC_XDI_XDI_FIELD                  (_MK_MASK_CONST(0x1) << CCW_C2MC_XDI_XDI_SHIFT)
#define CCW_C2MC_XDI_XDI_RANGE                  _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CCW_C2MC_XDI_XDI_ROW                    0


// Packet CCW_C2MC_HP
#define CCW_C2MC_HP_SIZE 32

// high-priority threshold
#define CCW_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CCW_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_HP_HPTH_SHIFT)
#define CCW_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCW_C2MC_HP_HPTH_ROW                    0


// Packet CCW_C2MC_WCOAL
#define CCW_C2MC_WCOAL_SIZE 32

// write-coalescing time-out
#define CCW_C2MC_WCOAL_WCOALTM_SHIFT                    _MK_SHIFT_CONST(0)
#define CCW_C2MC_WCOAL_WCOALTM_FIELD                    (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_WCOAL_WCOALTM_SHIFT)
#define CCW_C2MC_WCOAL_WCOALTM_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCW_C2MC_WCOAL_WCOALTM_ROW                      0


// Packet CCW_C2MC_HYST
#define CCW_C2MC_HYST_SIZE 32

#define CCW_C2MC_HYST_HYST_REQ_TM_SHIFT                 _MK_SHIFT_CONST(0)
#define CCW_C2MC_HYST_HYST_REQ_TM_FIELD                 (_MK_MASK_CONST(0xfff) << CCW_C2MC_HYST_HYST_REQ_TM_SHIFT)
#define CCW_C2MC_HYST_HYST_REQ_TM_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define CCW_C2MC_HYST_HYST_REQ_TM_ROW                   0

#define CCW_C2MC_HYST_HYST_REQ_TH_SHIFT                 _MK_SHIFT_CONST(28)
#define CCW_C2MC_HYST_HYST_REQ_TH_FIELD                 (_MK_MASK_CONST(0x7) << CCW_C2MC_HYST_HYST_REQ_TH_SHIFT)
#define CCW_C2MC_HYST_HYST_REQ_TH_RANGE                 _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(28)
#define CCW_C2MC_HYST_HYST_REQ_TH_ROW                   0

#define CCW_C2MC_HYST_HYST_EN_SHIFT                     _MK_SHIFT_CONST(31)
#define CCW_C2MC_HYST_HYST_EN_FIELD                     (_MK_MASK_CONST(0x1) << CCW_C2MC_HYST_HYST_EN_SHIFT)
#define CCW_C2MC_HYST_HYST_EN_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define CCW_C2MC_HYST_HYST_EN_ROW                       0


// Packet SC_MCCIF_ASYNC
#define SC_MCCIF_ASYNC_SIZE 4

#define SC_MCCIF_ASYNC_RDCL_RDFAST_SHIFT                        _MK_SHIFT_CONST(0)
#define SC_MCCIF_ASYNC_RDCL_RDFAST_FIELD                        (_MK_MASK_CONST(0x1) << SC_MCCIF_ASYNC_RDCL_RDFAST_SHIFT)
#define SC_MCCIF_ASYNC_RDCL_RDFAST_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define SC_MCCIF_ASYNC_RDCL_RDFAST_ROW                  0

#define SC_MCCIF_ASYNC_RDMC_RDFAST_SHIFT                        _MK_SHIFT_CONST(1)
#define SC_MCCIF_ASYNC_RDMC_RDFAST_FIELD                        (_MK_MASK_CONST(0x1) << SC_MCCIF_ASYNC_RDMC_RDFAST_SHIFT)
#define SC_MCCIF_ASYNC_RDMC_RDFAST_RANGE                        _MK_SHIFT_CONST(1):_MK_SHIFT_CONST(1)
#define SC_MCCIF_ASYNC_RDMC_RDFAST_ROW                  0

#define SC_MCCIF_ASYNC_WRCL_MCLE2X_SHIFT                        _MK_SHIFT_CONST(2)
#define SC_MCCIF_ASYNC_WRCL_MCLE2X_FIELD                        (_MK_MASK_CONST(0x1) << SC_MCCIF_ASYNC_WRCL_MCLE2X_SHIFT)
#define SC_MCCIF_ASYNC_WRCL_MCLE2X_RANGE                        _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(2)
#define SC_MCCIF_ASYNC_WRCL_MCLE2X_ROW                  0

#define SC_MCCIF_ASYNC_WRMC_CLLE2X_SHIFT                        _MK_SHIFT_CONST(3)
#define SC_MCCIF_ASYNC_WRMC_CLLE2X_FIELD                        (_MK_MASK_CONST(0x1) << SC_MCCIF_ASYNC_WRMC_CLLE2X_SHIFT)
#define SC_MCCIF_ASYNC_WRMC_CLLE2X_RANGE                        _MK_SHIFT_CONST(3):_MK_SHIFT_CONST(3)
#define SC_MCCIF_ASYNC_WRMC_CLLE2X_ROW                  0


// Register EMC_LL_ARB_CONFIG_0  // LOW-LATENCY arbiter configuration
#define EMC_LL_ARB_CONFIG_0                     _MK_ADDR_CONST(0x144)
#define EMC_LL_ARB_CONFIG_0_SECURE                      0x0
#define EMC_LL_ARB_CONFIG_0_WORD_COUNT                  0x1
#define EMC_LL_ARB_CONFIG_0_RESET_VAL                   _MK_MASK_CONST(0x2003)
#define EMC_LL_ARB_CONFIG_0_RESET_MASK                  _MK_MASK_CONST(0x3f00f10f)
#define EMC_LL_ARB_CONFIG_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_READ_MASK                   _MK_MASK_CONST(0x3f00f10f)
#define EMC_LL_ARB_CONFIG_0_WRITE_MASK                  _MK_MASK_CONST(0x3f00f10f)
#define EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_FIELD                   (_MK_MASK_CONST(0xf) << EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_SHIFT)
#define EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_RANGE                   3:0
#define EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_WOFFSET                 0x0
#define EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_DEFAULT                 _MK_MASK_CONST(0x3)
#define EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_DIE_OFF_EXP_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_SHIFT                     _MK_SHIFT_CONST(8)
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_FIELD                     (_MK_MASK_CONST(0x1) << EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_SHIFT)
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_RANGE                     8:8
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_WOFFSET                   0x0
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_INIT_ENUM                 DISABLED
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_DISABLED                  _MK_ENUM_CONST(0)
#define EMC_LL_ARB_CONFIG_0_ALLOW_IDLE_INSERT_ENABLED                   _MK_ENUM_CONST(1)

#define EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_SHIFT                  _MK_SHIFT_CONST(12)
#define EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_FIELD                  (_MK_MASK_CONST(0xf) << EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_SHIFT)
#define EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_RANGE                  15:12
#define EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_WOFFSET                        0x0
#define EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_DEFAULT                        _MK_MASK_CONST(0x2)
#define EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_MAX_LL_GREED_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// set to one to get AP15 behavior
#define EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_DISABLE_SHIFT                    _MK_SHIFT_CONST(24)
#define EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_DISABLE_FIELD                    (_MK_MASK_CONST(0x1) << EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_DISABLE_SHIFT)
#define EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_DISABLE_RANGE                    24:24
#define EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_DISABLE_WOFFSET                  0x0
#define EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_DISABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_DISABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_DISABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_DISABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set to one to get AP15 behavior
#define EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_AFTER_DISABLE_SHIFT                      _MK_SHIFT_CONST(25)
#define EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_AFTER_DISABLE_FIELD                      (_MK_MASK_CONST(0x1) << EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_AFTER_DISABLE_SHIFT)
#define EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_AFTER_DISABLE_RANGE                      25:25
#define EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_AFTER_DISABLE_WOFFSET                    0x0
#define EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_AFTER_DISABLE_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_AFTER_DISABLE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_AFTER_DISABLE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_LL_GREED_DIFF_BANK_AFTER_DISABLE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// set to one to get AP15 behavior
#define EMC_LL_ARB_CONFIG_0_LL_FORCE_INSERT_WR_DISABLE_SHIFT                    _MK_SHIFT_CONST(26)
#define EMC_LL_ARB_CONFIG_0_LL_FORCE_INSERT_WR_DISABLE_FIELD                    (_MK_MASK_CONST(0x1) << EMC_LL_ARB_CONFIG_0_LL_FORCE_INSERT_WR_DISABLE_SHIFT)
#define EMC_LL_ARB_CONFIG_0_LL_FORCE_INSERT_WR_DISABLE_RANGE                    26:26
#define EMC_LL_ARB_CONFIG_0_LL_FORCE_INSERT_WR_DISABLE_WOFFSET                  0x0
#define EMC_LL_ARB_CONFIG_0_LL_FORCE_INSERT_WR_DISABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_LL_FORCE_INSERT_WR_DISABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_LL_ARB_CONFIG_0_LL_FORCE_INSERT_WR_DISABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_LL_FORCE_INSERT_WR_DISABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set to one to get AP15 behavior
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_BEFORE_DISABLE_SHIFT                    _MK_SHIFT_CONST(27)
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_BEFORE_DISABLE_FIELD                    (_MK_MASK_CONST(0x1) << EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_BEFORE_DISABLE_SHIFT)
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_BEFORE_DISABLE_RANGE                    27:27
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_BEFORE_DISABLE_WOFFSET                  0x0
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_BEFORE_DISABLE_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_BEFORE_DISABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_BEFORE_DISABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_BEFORE_DISABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// set to one to get AP15 behavior
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_TOGGLE_SHIFT                      _MK_SHIFT_CONST(28)
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_TOGGLE_FIELD                      (_MK_MASK_CONST(0x1) << EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_TOGGLE_SHIFT)
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_TOGGLE_RANGE                      28:28
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_TOGGLE_WOFFSET                    0x0
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_TOGGLE_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_TOGGLE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_TOGGLE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_TOGGLE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// set to zero to get AP15 behavior
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_REMOVE_SHIFT                      _MK_SHIFT_CONST(29)
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_REMOVE_FIELD                      (_MK_MASK_CONST(0x1) << EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_REMOVE_SHIFT)
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_REMOVE_RANGE                      29:29
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_REMOVE_WOFFSET                    0x0
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_REMOVE_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_REMOVE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_REMOVE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_LL_ARB_CONFIG_0_LL_INSERT_DIFF_BANK_AFTER_REMOVE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register EMC_T_MIN_CRITICAL_HP_0  // LOW-LATENCY arbiter configuration
#define EMC_T_MIN_CRITICAL_HP_0                 _MK_ADDR_CONST(0x148)
#define EMC_T_MIN_CRITICAL_HP_0_SECURE                  0x0
#define EMC_T_MIN_CRITICAL_HP_0_WORD_COUNT                      0x1
#define EMC_T_MIN_CRITICAL_HP_0_RESET_VAL                       _MK_MASK_CONST(0xa080600)
#define EMC_T_MIN_CRITICAL_HP_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_CRITICAL_HP_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_HP_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_HP_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_CRITICAL_HP_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_FIELD                   (_MK_MASK_CONST(0xff) << EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_SHIFT)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_RANGE                   7:0
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_WOFFSET                 0x0
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_SHIFT                   _MK_SHIFT_CONST(8)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_FIELD                   (_MK_MASK_CONST(0xff) << EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_SHIFT)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_RANGE                   15:8
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_WOFFSET                 0x0
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_DEFAULT                 _MK_MASK_CONST(0x6)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_SHIFT                   _MK_SHIFT_CONST(16)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_FIELD                   (_MK_MASK_CONST(0xff) << EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_SHIFT)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_RANGE                   23:16
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_WOFFSET                 0x0
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_DEFAULT                 _MK_MASK_CONST(0x8)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_SHIFT                   _MK_SHIFT_CONST(24)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_FIELD                   (_MK_MASK_CONST(0xff) << EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_SHIFT)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_RANGE                   31:24
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_WOFFSET                 0x0
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_DEFAULT                 _MK_MASK_CONST(0xa)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_HP_0_T_MIN_CRIT_HP_3_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_T_MIN_CRITICAL_TIMEOUT_0  // LOW-LATENCY arbiter configuration
#define EMC_T_MIN_CRITICAL_TIMEOUT_0                    _MK_ADDR_CONST(0x14c)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_SECURE                     0x0
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_WORD_COUNT                         0x1
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_RESET_VAL                  _MK_MASK_CONST(0xa080600)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_FIELD                 (_MK_MASK_CONST(0xff) << EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_SHIFT)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_RANGE                 7:0
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_WOFFSET                       0x0
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_FIELD                 (_MK_MASK_CONST(0xff) << EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_SHIFT)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_RANGE                 15:8
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_WOFFSET                       0x0
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_DEFAULT                       _MK_MASK_CONST(0x6)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_FIELD                 (_MK_MASK_CONST(0xff) << EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_SHIFT)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_RANGE                 23:16
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_WOFFSET                       0x0
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_DEFAULT                       _MK_MASK_CONST(0x8)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_SHIFT                 _MK_SHIFT_CONST(24)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_FIELD                 (_MK_MASK_CONST(0xff) << EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_SHIFT)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_RANGE                 31:24
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_WOFFSET                       0x0
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_DEFAULT                       _MK_MASK_CONST(0xa)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_T_MIN_CRITICAL_TIMEOUT_0_T_MIN_CRIT_TIMEOUT_3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_T_MIN_LOAD_0  // LOW-LATENCY arbiter configuration
#define EMC_T_MIN_LOAD_0                        _MK_ADDR_CONST(0x150)
#define EMC_T_MIN_LOAD_0_SECURE                         0x0
#define EMC_T_MIN_LOAD_0_WORD_COUNT                     0x1
#define EMC_T_MIN_LOAD_0_RESET_VAL                      _MK_MASK_CONST(0x8040200)
#define EMC_T_MIN_LOAD_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_LOAD_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_T_MIN_LOAD_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_T_MIN_LOAD_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_LOAD_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_FIELD                     (_MK_MASK_CONST(0xff) << EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_SHIFT)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_RANGE                     7:0
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_WOFFSET                   0x0
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_SHIFT                     _MK_SHIFT_CONST(8)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_FIELD                     (_MK_MASK_CONST(0xff) << EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_SHIFT)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_RANGE                     15:8
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_WOFFSET                   0x0
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_DEFAULT                   _MK_MASK_CONST(0x2)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_SHIFT                     _MK_SHIFT_CONST(16)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_FIELD                     (_MK_MASK_CONST(0xff) << EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_SHIFT)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_RANGE                     23:16
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_WOFFSET                   0x0
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_DEFAULT                   _MK_MASK_CONST(0x4)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_SHIFT                     _MK_SHIFT_CONST(24)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_FIELD                     (_MK_MASK_CONST(0xff) << EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_SHIFT)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_RANGE                     31:24
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_WOFFSET                   0x0
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_DEFAULT                   _MK_MASK_CONST(0x8)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_T_MIN_LOAD_0_T_MIN_LOAD_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_T_MAX_CRITICAL_HP_0  // LOW-LATENCY arbiter configuration
#define EMC_T_MAX_CRITICAL_HP_0                 _MK_ADDR_CONST(0x154)
#define EMC_T_MAX_CRITICAL_HP_0_SECURE                  0x0
#define EMC_T_MAX_CRITICAL_HP_0_WORD_COUNT                      0x1
#define EMC_T_MAX_CRITICAL_HP_0_RESET_VAL                       _MK_MASK_CONST(0xb0a0901)
#define EMC_T_MAX_CRITICAL_HP_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_CRITICAL_HP_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_HP_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_HP_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_CRITICAL_HP_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_FIELD                   (_MK_MASK_CONST(0xff) << EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_SHIFT)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_RANGE                   7:0
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_WOFFSET                 0x0
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_DEFAULT                 _MK_MASK_CONST(0x1)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_SHIFT                   _MK_SHIFT_CONST(8)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_FIELD                   (_MK_MASK_CONST(0xff) << EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_SHIFT)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_RANGE                   15:8
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_WOFFSET                 0x0
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_DEFAULT                 _MK_MASK_CONST(0x9)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_SHIFT                   _MK_SHIFT_CONST(16)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_FIELD                   (_MK_MASK_CONST(0xff) << EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_SHIFT)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_RANGE                   23:16
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_WOFFSET                 0x0
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_DEFAULT                 _MK_MASK_CONST(0xa)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_2_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_SHIFT                   _MK_SHIFT_CONST(24)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_FIELD                   (_MK_MASK_CONST(0xff) << EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_SHIFT)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_RANGE                   31:24
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_WOFFSET                 0x0
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_DEFAULT                 _MK_MASK_CONST(0xb)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_HP_0_T_MAX_CRIT_HP_3_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_T_MAX_CRITICAL_TIMEOUT_0  // LOW-LATENCY arbiter configuration
#define EMC_T_MAX_CRITICAL_TIMEOUT_0                    _MK_ADDR_CONST(0x158)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_SECURE                     0x0
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_WORD_COUNT                         0x1
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_RESET_VAL                  _MK_MASK_CONST(0xb0a0901)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_FIELD                 (_MK_MASK_CONST(0xff) << EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_SHIFT)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_RANGE                 7:0
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_WOFFSET                       0x0
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_DEFAULT                       _MK_MASK_CONST(0x1)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_SHIFT                 _MK_SHIFT_CONST(8)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_FIELD                 (_MK_MASK_CONST(0xff) << EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_SHIFT)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_RANGE                 15:8
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_WOFFSET                       0x0
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_DEFAULT                       _MK_MASK_CONST(0x9)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_FIELD                 (_MK_MASK_CONST(0xff) << EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_SHIFT)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_RANGE                 23:16
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_WOFFSET                       0x0
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_DEFAULT                       _MK_MASK_CONST(0xa)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_SHIFT                 _MK_SHIFT_CONST(24)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_FIELD                 (_MK_MASK_CONST(0xff) << EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_SHIFT)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_RANGE                 31:24
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_WOFFSET                       0x0
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_DEFAULT                       _MK_MASK_CONST(0xb)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_T_MAX_CRITICAL_TIMEOUT_0_T_MAX_CRIT_TIMEOUT_3_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_T_MAX_LOAD_0  // LOW-LATENCY arbiter configuration
#define EMC_T_MAX_LOAD_0                        _MK_ADDR_CONST(0x15c)
#define EMC_T_MAX_LOAD_0_SECURE                         0x0
#define EMC_T_MAX_LOAD_0_WORD_COUNT                     0x1
#define EMC_T_MAX_LOAD_0_RESET_VAL                      _MK_MASK_CONST(0x20100804)
#define EMC_T_MAX_LOAD_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_LOAD_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_T_MAX_LOAD_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_T_MAX_LOAD_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_LOAD_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_FIELD                     (_MK_MASK_CONST(0xff) << EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_SHIFT)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_RANGE                     7:0
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_WOFFSET                   0x0
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_DEFAULT                   _MK_MASK_CONST(0x4)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_SHIFT                     _MK_SHIFT_CONST(8)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_FIELD                     (_MK_MASK_CONST(0xff) << EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_SHIFT)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_RANGE                     15:8
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_WOFFSET                   0x0
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_DEFAULT                   _MK_MASK_CONST(0x8)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_SHIFT                     _MK_SHIFT_CONST(16)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_FIELD                     (_MK_MASK_CONST(0xff) << EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_SHIFT)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_RANGE                     23:16
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_WOFFSET                   0x0
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_DEFAULT                   _MK_MASK_CONST(0x10)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_2_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_SHIFT                     _MK_SHIFT_CONST(24)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_FIELD                     (_MK_MASK_CONST(0xff) << EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_SHIFT)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_RANGE                     31:24
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_WOFFSET                   0x0
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_DEFAULT                   _MK_MASK_CONST(0x20)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_T_MAX_LOAD_0_T_MAX_LOAD_3_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_STAT_CONTROL_0  
#define EMC_STAT_CONTROL_0                      _MK_ADDR_CONST(0x160)
#define EMC_STAT_CONTROL_0_SECURE                       0x0
#define EMC_STAT_CONTROL_0_WORD_COUNT                   0x1
#define EMC_STAT_CONTROL_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_RESET_MASK                   _MK_MASK_CONST(0x30307)
#define EMC_STAT_CONTROL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_READ_MASK                    _MK_MASK_CONST(0x30307)
#define EMC_STAT_CONTROL_0_WRITE_MASK                   _MK_MASK_CONST(0x30307)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_SHIFT                    _MK_SHIFT_CONST(0)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_FIELD                    (_MK_MASK_CONST(0x7) << EMC_STAT_CONTROL_0_LLMC_GATHER_SHIFT)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_RANGE                    2:0
#define EMC_STAT_CONTROL_0_LLMC_GATHER_WOFFSET                  0x0
#define EMC_STAT_CONTROL_0_LLMC_GATHER_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_INIT_ENUM                        RST
#define EMC_STAT_CONTROL_0_LLMC_GATHER_RST                      _MK_ENUM_CONST(0)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_CLEAR                    _MK_ENUM_CONST(1)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_DISABLE                  _MK_ENUM_CONST(2)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_ENABLE                   _MK_ENUM_CONST(3)
#define EMC_STAT_CONTROL_0_LLMC_GATHER_SLAVE_TO_MC                      _MK_ENUM_CONST(4)

#define EMC_STAT_CONTROL_0_PWR_GATHER_SHIFT                     _MK_SHIFT_CONST(8)
#define EMC_STAT_CONTROL_0_PWR_GATHER_FIELD                     (_MK_MASK_CONST(0x3) << EMC_STAT_CONTROL_0_PWR_GATHER_SHIFT)
#define EMC_STAT_CONTROL_0_PWR_GATHER_RANGE                     9:8
#define EMC_STAT_CONTROL_0_PWR_GATHER_WOFFSET                   0x0
#define EMC_STAT_CONTROL_0_PWR_GATHER_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_PWR_GATHER_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define EMC_STAT_CONTROL_0_PWR_GATHER_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_PWR_GATHER_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_PWR_GATHER_INIT_ENUM                 RST
#define EMC_STAT_CONTROL_0_PWR_GATHER_RST                       _MK_ENUM_CONST(0)
#define EMC_STAT_CONTROL_0_PWR_GATHER_CLEAR                     _MK_ENUM_CONST(1)
#define EMC_STAT_CONTROL_0_PWR_GATHER_DISABLE                   _MK_ENUM_CONST(2)
#define EMC_STAT_CONTROL_0_PWR_GATHER_ENABLE                    _MK_ENUM_CONST(3)

#define EMC_STAT_CONTROL_0_DRAM_GATHER_SHIFT                    _MK_SHIFT_CONST(16)
#define EMC_STAT_CONTROL_0_DRAM_GATHER_FIELD                    (_MK_MASK_CONST(0x3) << EMC_STAT_CONTROL_0_DRAM_GATHER_SHIFT)
#define EMC_STAT_CONTROL_0_DRAM_GATHER_RANGE                    17:16
#define EMC_STAT_CONTROL_0_DRAM_GATHER_WOFFSET                  0x0
#define EMC_STAT_CONTROL_0_DRAM_GATHER_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_DRAM_GATHER_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define EMC_STAT_CONTROL_0_DRAM_GATHER_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_DRAM_GATHER_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_CONTROL_0_DRAM_GATHER_INIT_ENUM                        RST
#define EMC_STAT_CONTROL_0_DRAM_GATHER_RST                      _MK_ENUM_CONST(0)
#define EMC_STAT_CONTROL_0_DRAM_GATHER_CLEAR                    _MK_ENUM_CONST(1)
#define EMC_STAT_CONTROL_0_DRAM_GATHER_DISABLE                  _MK_ENUM_CONST(2)
#define EMC_STAT_CONTROL_0_DRAM_GATHER_ENABLE                   _MK_ENUM_CONST(3)


// Register EMC_STAT_STATUS_0  
#define EMC_STAT_STATUS_0                       _MK_ADDR_CONST(0x164)
#define EMC_STAT_STATUS_0_SECURE                        0x0
#define EMC_STAT_STATUS_0_WORD_COUNT                    0x1
#define EMC_STAT_STATUS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_READ_MASK                     _MK_MASK_CONST(0x10101)
#define EMC_STAT_STATUS_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_LLMC_LIMIT_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC_STAT_STATUS_0_LLMC_LIMIT_FIELD                      (_MK_MASK_CONST(0x1) << EMC_STAT_STATUS_0_LLMC_LIMIT_SHIFT)
#define EMC_STAT_STATUS_0_LLMC_LIMIT_RANGE                      0:0
#define EMC_STAT_STATUS_0_LLMC_LIMIT_WOFFSET                    0x0
#define EMC_STAT_STATUS_0_LLMC_LIMIT_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_LLMC_LIMIT_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_LLMC_LIMIT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_LLMC_LIMIT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define EMC_STAT_STATUS_0_PWR_LIMIT_SHIFT                       _MK_SHIFT_CONST(8)
#define EMC_STAT_STATUS_0_PWR_LIMIT_FIELD                       (_MK_MASK_CONST(0x1) << EMC_STAT_STATUS_0_PWR_LIMIT_SHIFT)
#define EMC_STAT_STATUS_0_PWR_LIMIT_RANGE                       8:8
#define EMC_STAT_STATUS_0_PWR_LIMIT_WOFFSET                     0x0
#define EMC_STAT_STATUS_0_PWR_LIMIT_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_PWR_LIMIT_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_PWR_LIMIT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_PWR_LIMIT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define EMC_STAT_STATUS_0_DRAM_LIMIT_SHIFT                      _MK_SHIFT_CONST(16)
#define EMC_STAT_STATUS_0_DRAM_LIMIT_FIELD                      (_MK_MASK_CONST(0x1) << EMC_STAT_STATUS_0_DRAM_LIMIT_SHIFT)
#define EMC_STAT_STATUS_0_DRAM_LIMIT_RANGE                      16:16
#define EMC_STAT_STATUS_0_DRAM_LIMIT_WOFFSET                    0x0
#define EMC_STAT_STATUS_0_DRAM_LIMIT_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_DRAM_LIMIT_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_DRAM_LIMIT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_STATUS_0_DRAM_LIMIT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register EMC_STAT_LLMC_ADDR_LOW_0  
#define EMC_STAT_LLMC_ADDR_LOW_0                        _MK_ADDR_CONST(0x168)
#define EMC_STAT_LLMC_ADDR_LOW_0_SECURE                         0x0
#define EMC_STAT_LLMC_ADDR_LOW_0_WORD_COUNT                     0x1
#define EMC_STAT_LLMC_ADDR_LOW_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_LOW_0_RESET_MASK                     _MK_MASK_CONST(0x3ffffff0)
#define EMC_STAT_LLMC_ADDR_LOW_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_LOW_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_LOW_0_READ_MASK                      _MK_MASK_CONST(0x3ffffff0)
#define EMC_STAT_LLMC_ADDR_LOW_0_WRITE_MASK                     _MK_MASK_CONST(0x3ffffff0)
#define EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_SHIFT                    _MK_SHIFT_CONST(4)
#define EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_FIELD                    (_MK_MASK_CONST(0x3ffffff) << EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_SHIFT)
#define EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_RANGE                    29:4
#define EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_WOFFSET                  0x0
#define EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_DEFAULT_MASK                     _MK_MASK_CONST(0x3ffffff)
#define EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_LOW_0_LLMC_ADDR_LOW_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register EMC_STAT_LLMC_ADDR_HIGH_0  
#define EMC_STAT_LLMC_ADDR_HIGH_0                       _MK_ADDR_CONST(0x16c)
#define EMC_STAT_LLMC_ADDR_HIGH_0_SECURE                        0x0
#define EMC_STAT_LLMC_ADDR_HIGH_0_WORD_COUNT                    0x1
#define EMC_STAT_LLMC_ADDR_HIGH_0_RESET_VAL                     _MK_MASK_CONST(0x3ffffff0)
#define EMC_STAT_LLMC_ADDR_HIGH_0_RESET_MASK                    _MK_MASK_CONST(0x3ffffff0)
#define EMC_STAT_LLMC_ADDR_HIGH_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_HIGH_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_HIGH_0_READ_MASK                     _MK_MASK_CONST(0x3ffffff0)
#define EMC_STAT_LLMC_ADDR_HIGH_0_WRITE_MASK                    _MK_MASK_CONST(0x3ffffff0)
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_SHIFT                  _MK_SHIFT_CONST(4)
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_FIELD                  (_MK_MASK_CONST(0x3ffffff) << EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_SHIFT)
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_RANGE                  29:4
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_WOFFSET                        0x0
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_DEFAULT                        _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_DEFAULT_MASK                   _MK_MASK_CONST(0x3ffffff)
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_ADDR_HIGH_0_LLMC_ADDR_HIGH_INIT_ENUM                      -1


// Register EMC_STAT_LLMC_CLOCK_LIMIT_0  
#define EMC_STAT_LLMC_CLOCK_LIMIT_0                     _MK_ADDR_CONST(0x170)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_SECURE                      0x0
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_WORD_COUNT                  0x1
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_RESET_VAL                   _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_FIELD                      (_MK_MASK_CONST(0xffffffff) << EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_SHIFT)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_RANGE                      31:0
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_WOFFSET                    0x0
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_DEFAULT                    _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_DEFAULT_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCK_LIMIT_0_LLMC_CLOCK_LIMIT_INIT_ENUM                  -1


// Register EMC_STAT_LLMC_CLOCKS_0  
#define EMC_STAT_LLMC_CLOCKS_0                  _MK_ADDR_CONST(0x174)
#define EMC_STAT_LLMC_CLOCKS_0_SECURE                   0x0
#define EMC_STAT_LLMC_CLOCKS_0_WORD_COUNT                       0x1
#define EMC_STAT_LLMC_CLOCKS_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCKS_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCKS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCKS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCKS_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CLOCKS_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_FIELD                        (_MK_MASK_CONST(0xffffffff) << EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_SHIFT)
#define EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_RANGE                        31:0
#define EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_WOFFSET                      0x0
#define EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CLOCKS_0_LLMC_CLOCKS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Packet AREMC_STAT_CONTROL
#define AREMC_STAT_CONTROL_SIZE 28

#define AREMC_STAT_CONTROL_MODE_SHIFT                   _MK_SHIFT_CONST(0)
#define AREMC_STAT_CONTROL_MODE_FIELD                   (_MK_MASK_CONST(0x3) << AREMC_STAT_CONTROL_MODE_SHIFT)
#define AREMC_STAT_CONTROL_MODE_RANGE                   _MK_SHIFT_CONST(1):_MK_SHIFT_CONST(0)
#define AREMC_STAT_CONTROL_MODE_ROW                     0
#define AREMC_STAT_CONTROL_MODE_BANDWIDTH                       _MK_ENUM_CONST(0)
#define AREMC_STAT_CONTROL_MODE_LATENCY_AVG                     _MK_ENUM_CONST(1)
#define AREMC_STAT_CONTROL_MODE_LATENCY_HISTO                   _MK_ENUM_CONST(2)

#define AREMC_STAT_CONTROL_SKIP_SHIFT                   _MK_SHIFT_CONST(4)
#define AREMC_STAT_CONTROL_SKIP_FIELD                   (_MK_MASK_CONST(0x7) << AREMC_STAT_CONTROL_SKIP_SHIFT)
#define AREMC_STAT_CONTROL_SKIP_RANGE                   _MK_SHIFT_CONST(6):_MK_SHIFT_CONST(4)
#define AREMC_STAT_CONTROL_SKIP_ROW                     0

#define AREMC_STAT_CONTROL_CLIENT_TYPE_SHIFT                    _MK_SHIFT_CONST(8)
#define AREMC_STAT_CONTROL_CLIENT_TYPE_FIELD                    (_MK_MASK_CONST(0x1) << AREMC_STAT_CONTROL_CLIENT_TYPE_SHIFT)
#define AREMC_STAT_CONTROL_CLIENT_TYPE_RANGE                    _MK_SHIFT_CONST(8):_MK_SHIFT_CONST(8)
#define AREMC_STAT_CONTROL_CLIENT_TYPE_ROW                      0
#define AREMC_STAT_CONTROL_CLIENT_TYPE_MPCORER                  _MK_ENUM_CONST(0)

#define AREMC_STAT_CONTROL_EVENT_SHIFT                  _MK_SHIFT_CONST(16)
#define AREMC_STAT_CONTROL_EVENT_FIELD                  (_MK_MASK_CONST(0x1) << AREMC_STAT_CONTROL_EVENT_SHIFT)
#define AREMC_STAT_CONTROL_EVENT_RANGE                  _MK_SHIFT_CONST(16):_MK_SHIFT_CONST(16)
#define AREMC_STAT_CONTROL_EVENT_ROW                    0
#define AREMC_STAT_CONTROL_EVENT_QUALIFIED                      _MK_ENUM_CONST(0)

#define AREMC_STAT_CONTROL_FILTER_CLIENT_SHIFT                  _MK_SHIFT_CONST(26)
#define AREMC_STAT_CONTROL_FILTER_CLIENT_FIELD                  (_MK_MASK_CONST(0x1) << AREMC_STAT_CONTROL_FILTER_CLIENT_SHIFT)
#define AREMC_STAT_CONTROL_FILTER_CLIENT_RANGE                  _MK_SHIFT_CONST(26):_MK_SHIFT_CONST(26)
#define AREMC_STAT_CONTROL_FILTER_CLIENT_ROW                    0
#define AREMC_STAT_CONTROL_FILTER_CLIENT_DISABLE                        _MK_ENUM_CONST(0)
#define AREMC_STAT_CONTROL_FILTER_CLIENT_ENABLE                 _MK_ENUM_CONST(1)

#define AREMC_STAT_CONTROL_FILTER_ADDR_SHIFT                    _MK_SHIFT_CONST(27)
#define AREMC_STAT_CONTROL_FILTER_ADDR_FIELD                    (_MK_MASK_CONST(0x1) << AREMC_STAT_CONTROL_FILTER_ADDR_SHIFT)
#define AREMC_STAT_CONTROL_FILTER_ADDR_RANGE                    _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(27)
#define AREMC_STAT_CONTROL_FILTER_ADDR_ROW                      0
#define AREMC_STAT_CONTROL_FILTER_ADDR_DISABLE                  _MK_ENUM_CONST(0)
#define AREMC_STAT_CONTROL_FILTER_ADDR_ENABLE                   _MK_ENUM_CONST(1)


// Register EMC_STAT_LLMC_CONTROL_0_0  
#define EMC_STAT_LLMC_CONTROL_0_0                       _MK_ADDR_CONST(0x178)
#define EMC_STAT_LLMC_CONTROL_0_0_SECURE                        0x0
#define EMC_STAT_LLMC_CONTROL_0_0_WORD_COUNT                    0x1
#define EMC_STAT_LLMC_CONTROL_0_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CONTROL_0_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CONTROL_0_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CONTROL_0_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CONTROL_0_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CONTROL_0_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_FIELD                  (_MK_MASK_CONST(0xffffffff) << EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_SHIFT)
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_RANGE                  31:0
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_WOFFSET                        0x0
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_DEFAULT_MASK                   _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_CONTROL_0_0_LLMC_CONTROL_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 380 [0x17c] 

// Packet AREMC_STAT_HIST_LIMIT
#define AREMC_STAT_HIST_LIMIT_SIZE 32

#define AREMC_STAT_HIST_LIMIT_LOW_SHIFT                 _MK_SHIFT_CONST(0)
#define AREMC_STAT_HIST_LIMIT_LOW_FIELD                 (_MK_MASK_CONST(0xffff) << AREMC_STAT_HIST_LIMIT_LOW_SHIFT)
#define AREMC_STAT_HIST_LIMIT_LOW_RANGE                 _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define AREMC_STAT_HIST_LIMIT_LOW_ROW                   0

#define AREMC_STAT_HIST_LIMIT_HIGH_SHIFT                        _MK_SHIFT_CONST(16)
#define AREMC_STAT_HIST_LIMIT_HIGH_FIELD                        (_MK_MASK_CONST(0xffff) << AREMC_STAT_HIST_LIMIT_HIGH_SHIFT)
#define AREMC_STAT_HIST_LIMIT_HIGH_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(16)
#define AREMC_STAT_HIST_LIMIT_HIGH_ROW                  0


// Register EMC_STAT_LLMC_HIST_LIMIT_0_0  
#define EMC_STAT_LLMC_HIST_LIMIT_0_0                    _MK_ADDR_CONST(0x180)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_SECURE                     0x0
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_WORD_COUNT                         0x1
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_RESET_VAL                  _MK_MASK_CONST(0xffff0000)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_SHIFT                    _MK_SHIFT_CONST(0)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_FIELD                    (_MK_MASK_CONST(0xffffffff) << EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_SHIFT)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_RANGE                    31:0
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_WOFFSET                  0x0
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_DEFAULT                  _MK_MASK_CONST(0xffff0000)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_DEFAULT_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_LIMIT_0_0_LLMC_HIST_LIMIT_0_INIT_ENUM                        -65536


// Reserved address 388 [0x184] 

// Register EMC_STAT_LLMC_COUNT_0_0  
#define EMC_STAT_LLMC_COUNT_0_0                 _MK_ADDR_CONST(0x188)
#define EMC_STAT_LLMC_COUNT_0_0_SECURE                  0x0
#define EMC_STAT_LLMC_COUNT_0_0_WORD_COUNT                      0x1
#define EMC_STAT_LLMC_COUNT_0_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_COUNT_0_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_COUNT_0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_COUNT_0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_COUNT_0_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_COUNT_0_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_FIELD                      (_MK_MASK_CONST(0xffffffff) << EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_SHIFT)
#define EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_RANGE                      31:0
#define EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_WOFFSET                    0x0
#define EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_COUNT_0_0_LLMC_COUNT_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Reserved address 396 [0x18c] 

// Register EMC_STAT_LLMC_HIST_0_0  
#define EMC_STAT_LLMC_HIST_0_0                  _MK_ADDR_CONST(0x190)
#define EMC_STAT_LLMC_HIST_0_0_SECURE                   0x0
#define EMC_STAT_LLMC_HIST_0_0_WORD_COUNT                       0x1
#define EMC_STAT_LLMC_HIST_0_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_0_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_0_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_0_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_0_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_LLMC_HIST_0_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_FIELD                        (_MK_MASK_CONST(0xffffffff) << EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_SHIFT)
#define EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_RANGE                        31:0
#define EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_WOFFSET                      0x0
#define EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_STAT_LLMC_HIST_0_0_LLMC_HIST_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Reserved address 404 [0x194] 

// Register EMC_STAT_PWR_CLOCK_LIMIT_0  
#define EMC_STAT_PWR_CLOCK_LIMIT_0                      _MK_ADDR_CONST(0x198)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_SECURE                       0x0
#define EMC_STAT_PWR_CLOCK_LIMIT_0_WORD_COUNT                   0x1
#define EMC_STAT_PWR_CLOCK_LIMIT_0_RESET_VAL                    _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_FIELD                        (_MK_MASK_CONST(0xffffffff) << EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_SHIFT)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_RANGE                        31:0
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_WOFFSET                      0x0
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_DEFAULT                      _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCK_LIMIT_0_PWR_CLOCK_LIMIT_INIT_ENUM                    -1


// Register EMC_STAT_PWR_CLOCKS_0  
#define EMC_STAT_PWR_CLOCKS_0                   _MK_ADDR_CONST(0x19c)
#define EMC_STAT_PWR_CLOCKS_0_SECURE                    0x0
#define EMC_STAT_PWR_CLOCKS_0_WORD_COUNT                        0x1
#define EMC_STAT_PWR_CLOCKS_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCKS_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCKS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCKS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCKS_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_PWR_CLOCKS_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_FIELD                  (_MK_MASK_CONST(0xffffffff) << EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_SHIFT)
#define EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_RANGE                  31:0
#define EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_WOFFSET                        0x0
#define EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_CLOCKS_0_PWR_CLOCKS_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register EMC_STAT_PWR_COUNT_0  
#define EMC_STAT_PWR_COUNT_0                    _MK_ADDR_CONST(0x1a0)
#define EMC_STAT_PWR_COUNT_0_SECURE                     0x0
#define EMC_STAT_PWR_COUNT_0_WORD_COUNT                         0x1
#define EMC_STAT_PWR_COUNT_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_COUNT_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_COUNT_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_COUNT_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_COUNT_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_PWR_COUNT_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_COUNT_0_PWR_COUNT_SHIFT                    _MK_SHIFT_CONST(0)
#define EMC_STAT_PWR_COUNT_0_PWR_COUNT_FIELD                    (_MK_MASK_CONST(0xffffffff) << EMC_STAT_PWR_COUNT_0_PWR_COUNT_SHIFT)
#define EMC_STAT_PWR_COUNT_0_PWR_COUNT_RANGE                    31:0
#define EMC_STAT_PWR_COUNT_0_PWR_COUNT_WOFFSET                  0x0
#define EMC_STAT_PWR_COUNT_0_PWR_COUNT_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_COUNT_0_PWR_COUNT_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_COUNT_0_PWR_COUNT_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_PWR_COUNT_0_PWR_COUNT_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_CLOCK_LIMIT_LO_0  
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0                  _MK_ADDR_CONST(0x1a4)
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_SECURE                   0x0
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_WORD_COUNT                       0x1
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_RESET_VAL                        _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_DRAM_CLOCK_LIMIT_LO_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_DRAM_CLOCK_LIMIT_LO_FIELD                        (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_DRAM_CLOCK_LIMIT_LO_SHIFT)
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_DRAM_CLOCK_LIMIT_LO_RANGE                        31:0
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_DRAM_CLOCK_LIMIT_LO_WOFFSET                      0x0
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_DRAM_CLOCK_LIMIT_LO_DEFAULT                      _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_DRAM_CLOCK_LIMIT_LO_DEFAULT_MASK                 _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_DRAM_CLOCK_LIMIT_LO_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_DRAM_CLOCK_LIMIT_LO_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCK_LIMIT_LO_0_DRAM_CLOCK_LIMIT_LO_INIT_ENUM                    -1


// Register EMC_STAT_DRAM_CLOCK_LIMIT_HI_0  
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0                  _MK_ADDR_CONST(0x1a8)
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_SECURE                   0x0
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_WORD_COUNT                       0x1
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_RESET_VAL                        _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_DRAM_CLOCK_LIMIT_HI_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_DRAM_CLOCK_LIMIT_HI_FIELD                        (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_DRAM_CLOCK_LIMIT_HI_SHIFT)
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_DRAM_CLOCK_LIMIT_HI_RANGE                        7:0
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_DRAM_CLOCK_LIMIT_HI_WOFFSET                      0x0
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_DRAM_CLOCK_LIMIT_HI_DEFAULT                      _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_DRAM_CLOCK_LIMIT_HI_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_DRAM_CLOCK_LIMIT_HI_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCK_LIMIT_HI_0_DRAM_CLOCK_LIMIT_HI_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_CLOCKS_LO_0  
#define EMC_STAT_DRAM_CLOCKS_LO_0                       _MK_ADDR_CONST(0x1ac)
#define EMC_STAT_DRAM_CLOCKS_LO_0_SECURE                        0x0
#define EMC_STAT_DRAM_CLOCKS_LO_0_WORD_COUNT                    0x1
#define EMC_STAT_DRAM_CLOCKS_LO_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCKS_LO_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCKS_LO_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCKS_LO_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCKS_LO_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_CLOCKS_LO_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCKS_LO_0_DRAM_CLOCKS_LO_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_CLOCKS_LO_0_DRAM_CLOCKS_LO_FIELD                  (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_CLOCKS_LO_0_DRAM_CLOCKS_LO_SHIFT)
#define EMC_STAT_DRAM_CLOCKS_LO_0_DRAM_CLOCKS_LO_RANGE                  31:0
#define EMC_STAT_DRAM_CLOCKS_LO_0_DRAM_CLOCKS_LO_WOFFSET                        0x0
#define EMC_STAT_DRAM_CLOCKS_LO_0_DRAM_CLOCKS_LO_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCKS_LO_0_DRAM_CLOCKS_LO_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCKS_LO_0_DRAM_CLOCKS_LO_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCKS_LO_0_DRAM_CLOCKS_LO_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_CLOCKS_HI_0  
#define EMC_STAT_DRAM_CLOCKS_HI_0                       _MK_ADDR_CONST(0x1b0)
#define EMC_STAT_DRAM_CLOCKS_HI_0_SECURE                        0x0
#define EMC_STAT_DRAM_CLOCKS_HI_0_WORD_COUNT                    0x1
#define EMC_STAT_DRAM_CLOCKS_HI_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCKS_HI_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCKS_HI_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCKS_HI_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCKS_HI_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_CLOCKS_HI_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCKS_HI_0_DRAM_CLOCKS_HI_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_CLOCKS_HI_0_DRAM_CLOCKS_HI_FIELD                  (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_CLOCKS_HI_0_DRAM_CLOCKS_HI_SHIFT)
#define EMC_STAT_DRAM_CLOCKS_HI_0_DRAM_CLOCKS_HI_RANGE                  7:0
#define EMC_STAT_DRAM_CLOCKS_HI_0_DRAM_CLOCKS_HI_WOFFSET                        0x0
#define EMC_STAT_DRAM_CLOCKS_HI_0_DRAM_CLOCKS_HI_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCKS_HI_0_DRAM_CLOCKS_HI_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCKS_HI_0_DRAM_CLOCKS_HI_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_CLOCKS_HI_0_DRAM_CLOCKS_HI_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0  
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0                    _MK_ADDR_CONST(0x1b4)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_SECURE                     0x0
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_WORD_COUNT                         0x1
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_DEV0_ACTIVATE_CNT_LO_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_DEV0_ACTIVATE_CNT_LO_FIELD                 (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_DEV0_ACTIVATE_CNT_LO_SHIFT)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_DEV0_ACTIVATE_CNT_LO_RANGE                 31:0
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_DEV0_ACTIVATE_CNT_LO_WOFFSET                       0x0
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_DEV0_ACTIVATE_CNT_LO_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_DEV0_ACTIVATE_CNT_LO_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_DEV0_ACTIVATE_CNT_LO_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0_DEV0_ACTIVATE_CNT_LO_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0  
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0                    _MK_ADDR_CONST(0x1b8)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_SECURE                     0x0
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_WORD_COUNT                         0x1
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_READ_MASK                  _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_DEV0_ACTIVATE_CNT_HI_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_DEV0_ACTIVATE_CNT_HI_FIELD                 (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_DEV0_ACTIVATE_CNT_HI_SHIFT)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_DEV0_ACTIVATE_CNT_HI_RANGE                 7:0
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_DEV0_ACTIVATE_CNT_HI_WOFFSET                       0x0
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_DEV0_ACTIVATE_CNT_HI_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_DEV0_ACTIVATE_CNT_HI_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_DEV0_ACTIVATE_CNT_HI_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0_DEV0_ACTIVATE_CNT_HI_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_READ_CNT_LO_0  
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0                        _MK_ADDR_CONST(0x1bc)
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_SECURE                         0x0
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_WORD_COUNT                     0x1
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_DEV0_READ_CNT_LO_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_DEV0_READ_CNT_LO_FIELD                 (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_DEV0_READ_CNT_LO_SHIFT)
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_DEV0_READ_CNT_LO_RANGE                 31:0
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_DEV0_READ_CNT_LO_WOFFSET                       0x0
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_DEV0_READ_CNT_LO_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_DEV0_READ_CNT_LO_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_DEV0_READ_CNT_LO_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_LO_0_DEV0_READ_CNT_LO_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_READ_CNT_HI_0  
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0                        _MK_ADDR_CONST(0x1c0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_SECURE                         0x0
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_WORD_COUNT                     0x1
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_READ_MASK                      _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_DEV0_READ_CNT_HI_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_DEV0_READ_CNT_HI_FIELD                 (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_DEV0_READ_CNT_HI_SHIFT)
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_DEV0_READ_CNT_HI_RANGE                 7:0
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_DEV0_READ_CNT_HI_WOFFSET                       0x0
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_DEV0_READ_CNT_HI_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_DEV0_READ_CNT_HI_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_DEV0_READ_CNT_HI_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_READ_CNT_HI_0_DEV0_READ_CNT_HI_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0  
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0                       _MK_ADDR_CONST(0x1c4)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_SECURE                        0x0
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_WORD_COUNT                    0x1
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_DEV0_WRITE_CNT_LO_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_DEV0_WRITE_CNT_LO_FIELD                       (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_DEV0_WRITE_CNT_LO_SHIFT)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_DEV0_WRITE_CNT_LO_RANGE                       31:0
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_DEV0_WRITE_CNT_LO_WOFFSET                     0x0
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_DEV0_WRITE_CNT_LO_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_DEV0_WRITE_CNT_LO_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_DEV0_WRITE_CNT_LO_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0_DEV0_WRITE_CNT_LO_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0  
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0                       _MK_ADDR_CONST(0x1c8)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_SECURE                        0x0
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_WORD_COUNT                    0x1
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_DEV0_WRITE_CNT_HI_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_DEV0_WRITE_CNT_HI_FIELD                       (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_DEV0_WRITE_CNT_HI_SHIFT)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_DEV0_WRITE_CNT_HI_RANGE                       7:0
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_DEV0_WRITE_CNT_HI_WOFFSET                     0x0
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_DEV0_WRITE_CNT_HI_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_DEV0_WRITE_CNT_HI_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_DEV0_WRITE_CNT_HI_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0_DEV0_WRITE_CNT_HI_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_REF_CNT_LO_0  
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0                 _MK_ADDR_CONST(0x1cc)
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_DEV0_REF_CNT_LO_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_DEV0_REF_CNT_LO_FIELD                   (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_DEV0_REF_CNT_LO_SHIFT)
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_DEV0_REF_CNT_LO_RANGE                   31:0
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_DEV0_REF_CNT_LO_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_DEV0_REF_CNT_LO_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_DEV0_REF_CNT_LO_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_DEV0_REF_CNT_LO_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_LO_0_DEV0_REF_CNT_LO_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_REF_CNT_HI_0  
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0                 _MK_ADDR_CONST(0x1d0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_DEV0_REF_CNT_HI_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_DEV0_REF_CNT_HI_FIELD                   (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_DEV0_REF_CNT_HI_SHIFT)
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_DEV0_REF_CNT_HI_RANGE                   7:0
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_DEV0_REF_CNT_HI_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_DEV0_REF_CNT_HI_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_DEV0_REF_CNT_HI_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_DEV0_REF_CNT_HI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_REF_CNT_HI_0_DEV0_REF_CNT_HI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0  
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0                       _MK_ADDR_CONST(0x1d4)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_SECURE                        0x0
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_WORD_COUNT                    0x1
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_FIELD                       (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_SHIFT)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_RANGE                       31:0
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_WOFFSET                     0x0
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0  
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0                       _MK_ADDR_CONST(0x1d8)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_SECURE                        0x0
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_WORD_COUNT                    0x1
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_FIELD                       (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_SHIFT)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_RANGE                       7:0
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_WOFFSET                     0x0
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0  
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0                       _MK_ADDR_CONST(0x1dc)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_SECURE                        0x0
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_WORD_COUNT                    0x1
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_FIELD                       (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_SHIFT)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_RANGE                       31:0
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_WOFFSET                     0x0
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0  
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0                       _MK_ADDR_CONST(0x1e0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_SECURE                        0x0
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_WORD_COUNT                    0x1
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_FIELD                       (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_SHIFT)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_RANGE                       7:0
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_WOFFSET                     0x0
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0  
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0                    _MK_ADDR_CONST(0x1e4)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_SECURE                     0x0
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_WORD_COUNT                         0x1
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_DEV0_CKE_EQ1_CLKS_LO_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_DEV0_CKE_EQ1_CLKS_LO_FIELD                 (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_DEV0_CKE_EQ1_CLKS_LO_SHIFT)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_DEV0_CKE_EQ1_CLKS_LO_RANGE                 31:0
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_DEV0_CKE_EQ1_CLKS_LO_WOFFSET                       0x0
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_DEV0_CKE_EQ1_CLKS_LO_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_DEV0_CKE_EQ1_CLKS_LO_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_DEV0_CKE_EQ1_CLKS_LO_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0_DEV0_CKE_EQ1_CLKS_LO_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0  
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0                    _MK_ADDR_CONST(0x1e8)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_SECURE                     0x0
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_WORD_COUNT                         0x1
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_READ_MASK                  _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_DEV0_CKE_EQ1_CLKS_HI_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_DEV0_CKE_EQ1_CLKS_HI_FIELD                 (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_DEV0_CKE_EQ1_CLKS_HI_SHIFT)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_DEV0_CKE_EQ1_CLKS_HI_RANGE                 7:0
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_DEV0_CKE_EQ1_CLKS_HI_WOFFSET                       0x0
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_DEV0_CKE_EQ1_CLKS_HI_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_DEV0_CKE_EQ1_CLKS_HI_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_DEV0_CKE_EQ1_CLKS_HI_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0_DEV0_CKE_EQ1_CLKS_HI_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0  
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0                 _MK_ADDR_CONST(0x1ec)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_DEV0_EXTCLKS_CKE_EQ1_LO_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_DEV0_EXTCLKS_CKE_EQ1_LO_FIELD                   (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_DEV0_EXTCLKS_CKE_EQ1_LO_SHIFT)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_DEV0_EXTCLKS_CKE_EQ1_LO_RANGE                   31:0
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_DEV0_EXTCLKS_CKE_EQ1_LO_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_DEV0_EXTCLKS_CKE_EQ1_LO_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_DEV0_EXTCLKS_CKE_EQ1_LO_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_DEV0_EXTCLKS_CKE_EQ1_LO_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0_DEV0_EXTCLKS_CKE_EQ1_LO_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0  
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0                 _MK_ADDR_CONST(0x1f0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_DEV0_EXTCLKS_CKE_EQ1_HI_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_DEV0_EXTCLKS_CKE_EQ1_HI_FIELD                   (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_DEV0_EXTCLKS_CKE_EQ1_HI_SHIFT)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_DEV0_EXTCLKS_CKE_EQ1_HI_RANGE                   7:0
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_DEV0_EXTCLKS_CKE_EQ1_HI_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_DEV0_EXTCLKS_CKE_EQ1_HI_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_DEV0_EXTCLKS_CKE_EQ1_HI_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_DEV0_EXTCLKS_CKE_EQ1_HI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0_DEV0_EXTCLKS_CKE_EQ1_HI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0  
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0                 _MK_ADDR_CONST(0x1f4)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_DEV0_EXTCLKS_CKE_EQ0_LO_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_DEV0_EXTCLKS_CKE_EQ0_LO_FIELD                   (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_DEV0_EXTCLKS_CKE_EQ0_LO_SHIFT)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_DEV0_EXTCLKS_CKE_EQ0_LO_RANGE                   31:0
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_DEV0_EXTCLKS_CKE_EQ0_LO_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_DEV0_EXTCLKS_CKE_EQ0_LO_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_DEV0_EXTCLKS_CKE_EQ0_LO_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_DEV0_EXTCLKS_CKE_EQ0_LO_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0_DEV0_EXTCLKS_CKE_EQ0_LO_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0  
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0                 _MK_ADDR_CONST(0x1f8)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_DEV0_EXTCLKS_CKE_EQ0_HI_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_DEV0_EXTCLKS_CKE_EQ0_HI_FIELD                   (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_DEV0_EXTCLKS_CKE_EQ0_HI_SHIFT)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_DEV0_EXTCLKS_CKE_EQ0_HI_RANGE                   7:0
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_DEV0_EXTCLKS_CKE_EQ0_HI_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_DEV0_EXTCLKS_CKE_EQ0_HI_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_DEV0_EXTCLKS_CKE_EQ0_HI_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_DEV0_EXTCLKS_CKE_EQ0_HI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0_DEV0_EXTCLKS_CKE_EQ0_HI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0  
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0                    _MK_ADDR_CONST(0x1fc)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_SECURE                     0x0
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_WORD_COUNT                         0x1
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_DEV1_ACTIVATE_CNT_LO_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_DEV1_ACTIVATE_CNT_LO_FIELD                 (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_DEV1_ACTIVATE_CNT_LO_SHIFT)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_DEV1_ACTIVATE_CNT_LO_RANGE                 31:0
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_DEV1_ACTIVATE_CNT_LO_WOFFSET                       0x0
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_DEV1_ACTIVATE_CNT_LO_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_DEV1_ACTIVATE_CNT_LO_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_DEV1_ACTIVATE_CNT_LO_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0_DEV1_ACTIVATE_CNT_LO_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0  
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0                    _MK_ADDR_CONST(0x200)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_SECURE                     0x0
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_WORD_COUNT                         0x1
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_READ_MASK                  _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_DEV1_ACTIVATE_CNT_HI_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_DEV1_ACTIVATE_CNT_HI_FIELD                 (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_DEV1_ACTIVATE_CNT_HI_SHIFT)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_DEV1_ACTIVATE_CNT_HI_RANGE                 7:0
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_DEV1_ACTIVATE_CNT_HI_WOFFSET                       0x0
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_DEV1_ACTIVATE_CNT_HI_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_DEV1_ACTIVATE_CNT_HI_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_DEV1_ACTIVATE_CNT_HI_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0_DEV1_ACTIVATE_CNT_HI_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_READ_CNT_LO_0  
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0                        _MK_ADDR_CONST(0x204)
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_SECURE                         0x0
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_WORD_COUNT                     0x1
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_DEV1_READ_CNT_LO_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_DEV1_READ_CNT_LO_FIELD                 (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_DEV1_READ_CNT_LO_SHIFT)
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_DEV1_READ_CNT_LO_RANGE                 31:0
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_DEV1_READ_CNT_LO_WOFFSET                       0x0
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_DEV1_READ_CNT_LO_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_DEV1_READ_CNT_LO_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_DEV1_READ_CNT_LO_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_LO_0_DEV1_READ_CNT_LO_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_READ_CNT_HI_0  
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0                        _MK_ADDR_CONST(0x208)
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_SECURE                         0x0
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_WORD_COUNT                     0x1
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_READ_MASK                      _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_DEV1_READ_CNT_HI_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_DEV1_READ_CNT_HI_FIELD                 (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_DEV1_READ_CNT_HI_SHIFT)
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_DEV1_READ_CNT_HI_RANGE                 7:0
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_DEV1_READ_CNT_HI_WOFFSET                       0x0
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_DEV1_READ_CNT_HI_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_DEV1_READ_CNT_HI_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_DEV1_READ_CNT_HI_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_READ_CNT_HI_0_DEV1_READ_CNT_HI_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0  
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0                       _MK_ADDR_CONST(0x20c)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_SECURE                        0x0
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_WORD_COUNT                    0x1
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_DEV1_WRITE_CNT_LO_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_DEV1_WRITE_CNT_LO_FIELD                       (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_DEV1_WRITE_CNT_LO_SHIFT)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_DEV1_WRITE_CNT_LO_RANGE                       31:0
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_DEV1_WRITE_CNT_LO_WOFFSET                     0x0
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_DEV1_WRITE_CNT_LO_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_DEV1_WRITE_CNT_LO_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_DEV1_WRITE_CNT_LO_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0_DEV1_WRITE_CNT_LO_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0  
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0                       _MK_ADDR_CONST(0x210)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_SECURE                        0x0
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_WORD_COUNT                    0x1
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_DEV1_WRITE_CNT_HI_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_DEV1_WRITE_CNT_HI_FIELD                       (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_DEV1_WRITE_CNT_HI_SHIFT)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_DEV1_WRITE_CNT_HI_RANGE                       7:0
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_DEV1_WRITE_CNT_HI_WOFFSET                     0x0
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_DEV1_WRITE_CNT_HI_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_DEV1_WRITE_CNT_HI_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_DEV1_WRITE_CNT_HI_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0_DEV1_WRITE_CNT_HI_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_REF_CNT_LO_0  
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0                 _MK_ADDR_CONST(0x214)
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_DEV1_REF_CNT_LO_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_DEV1_REF_CNT_LO_FIELD                   (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_DEV1_REF_CNT_LO_SHIFT)
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_DEV1_REF_CNT_LO_RANGE                   31:0
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_DEV1_REF_CNT_LO_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_DEV1_REF_CNT_LO_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_DEV1_REF_CNT_LO_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_DEV1_REF_CNT_LO_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_LO_0_DEV1_REF_CNT_LO_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_REF_CNT_HI_0  
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0                 _MK_ADDR_CONST(0x218)
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_DEV1_REF_CNT_HI_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_DEV1_REF_CNT_HI_FIELD                   (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_DEV1_REF_CNT_HI_SHIFT)
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_DEV1_REF_CNT_HI_RANGE                   7:0
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_DEV1_REF_CNT_HI_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_DEV1_REF_CNT_HI_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_DEV1_REF_CNT_HI_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_DEV1_REF_CNT_HI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_REF_CNT_HI_0_DEV1_REF_CNT_HI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0  
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0                       _MK_ADDR_CONST(0x21c)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_SECURE                        0x0
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_WORD_COUNT                    0x1
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_FIELD                       (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_SHIFT)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_RANGE                       31:0
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_WOFFSET                     0x0
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0  
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0                       _MK_ADDR_CONST(0x220)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_SECURE                        0x0
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_WORD_COUNT                    0x1
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_FIELD                       (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_SHIFT)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_RANGE                       7:0
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_WOFFSET                     0x0
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0  
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0                       _MK_ADDR_CONST(0x224)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_SECURE                        0x0
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_WORD_COUNT                    0x1
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_FIELD                       (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_SHIFT)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_RANGE                       31:0
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_WOFFSET                     0x0
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0  
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0                       _MK_ADDR_CONST(0x228)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_SECURE                        0x0
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_WORD_COUNT                    0x1
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_RESET_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_WRITE_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_FIELD                       (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_SHIFT)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_RANGE                       7:0
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_WOFFSET                     0x0
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0  
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0                    _MK_ADDR_CONST(0x22c)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_SECURE                     0x0
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_WORD_COUNT                         0x1
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_DEV1_CKE_EQ1_CLKS_LO_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_DEV1_CKE_EQ1_CLKS_LO_FIELD                 (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_DEV1_CKE_EQ1_CLKS_LO_SHIFT)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_DEV1_CKE_EQ1_CLKS_LO_RANGE                 31:0
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_DEV1_CKE_EQ1_CLKS_LO_WOFFSET                       0x0
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_DEV1_CKE_EQ1_CLKS_LO_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_DEV1_CKE_EQ1_CLKS_LO_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_DEV1_CKE_EQ1_CLKS_LO_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0_DEV1_CKE_EQ1_CLKS_LO_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0  
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0                    _MK_ADDR_CONST(0x230)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_SECURE                     0x0
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_WORD_COUNT                         0x1
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_READ_MASK                  _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_DEV1_CKE_EQ1_CLKS_HI_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_DEV1_CKE_EQ1_CLKS_HI_FIELD                 (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_DEV1_CKE_EQ1_CLKS_HI_SHIFT)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_DEV1_CKE_EQ1_CLKS_HI_RANGE                 7:0
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_DEV1_CKE_EQ1_CLKS_HI_WOFFSET                       0x0
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_DEV1_CKE_EQ1_CLKS_HI_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_DEV1_CKE_EQ1_CLKS_HI_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_DEV1_CKE_EQ1_CLKS_HI_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0_DEV1_CKE_EQ1_CLKS_HI_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0  
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0                 _MK_ADDR_CONST(0x234)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_DEV1_EXTCLKS_CKE_EQ1_LO_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_DEV1_EXTCLKS_CKE_EQ1_LO_FIELD                   (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_DEV1_EXTCLKS_CKE_EQ1_LO_SHIFT)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_DEV1_EXTCLKS_CKE_EQ1_LO_RANGE                   31:0
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_DEV1_EXTCLKS_CKE_EQ1_LO_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_DEV1_EXTCLKS_CKE_EQ1_LO_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_DEV1_EXTCLKS_CKE_EQ1_LO_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_DEV1_EXTCLKS_CKE_EQ1_LO_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0_DEV1_EXTCLKS_CKE_EQ1_LO_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0  
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0                 _MK_ADDR_CONST(0x238)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_DEV1_EXTCLKS_CKE_EQ1_HI_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_DEV1_EXTCLKS_CKE_EQ1_HI_FIELD                   (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_DEV1_EXTCLKS_CKE_EQ1_HI_SHIFT)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_DEV1_EXTCLKS_CKE_EQ1_HI_RANGE                   7:0
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_DEV1_EXTCLKS_CKE_EQ1_HI_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_DEV1_EXTCLKS_CKE_EQ1_HI_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_DEV1_EXTCLKS_CKE_EQ1_HI_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_DEV1_EXTCLKS_CKE_EQ1_HI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0_DEV1_EXTCLKS_CKE_EQ1_HI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0  
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0                 _MK_ADDR_CONST(0x23c)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_DEV1_EXTCLKS_CKE_EQ0_LO_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_DEV1_EXTCLKS_CKE_EQ0_LO_FIELD                   (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_DEV1_EXTCLKS_CKE_EQ0_LO_SHIFT)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_DEV1_EXTCLKS_CKE_EQ0_LO_RANGE                   31:0
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_DEV1_EXTCLKS_CKE_EQ0_LO_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_DEV1_EXTCLKS_CKE_EQ0_LO_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_DEV1_EXTCLKS_CKE_EQ0_LO_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_DEV1_EXTCLKS_CKE_EQ0_LO_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0_DEV1_EXTCLKS_CKE_EQ0_LO_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0  
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0                 _MK_ADDR_CONST(0x240)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_DEV1_EXTCLKS_CKE_EQ0_HI_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_DEV1_EXTCLKS_CKE_EQ0_HI_FIELD                   (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_DEV1_EXTCLKS_CKE_EQ0_HI_SHIFT)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_DEV1_EXTCLKS_CKE_EQ0_HI_RANGE                   7:0
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_DEV1_EXTCLKS_CKE_EQ0_HI_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_DEV1_EXTCLKS_CKE_EQ0_HI_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_DEV1_EXTCLKS_CKE_EQ0_HI_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_DEV1_EXTCLKS_CKE_EQ0_HI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0_DEV1_EXTCLKS_CKE_EQ0_HI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0  
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0                 _MK_ADDR_CONST(0x244)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_FIELD                   (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_SHIFT)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_RANGE                   31:0
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0  
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0                 _MK_ADDR_CONST(0x248)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_FIELD                   (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_SHIFT)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_RANGE                   7:0
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0  
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0                 _MK_ADDR_CONST(0x24c)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_FIELD                   (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_SHIFT)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_RANGE                   31:0
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0  
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0                 _MK_ADDR_CONST(0x250)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_FIELD                   (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_SHIFT)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_RANGE                   7:0
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0  
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0                 _MK_ADDR_CONST(0x254)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_FIELD                   (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_SHIFT)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_RANGE                   31:0
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0  
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0                 _MK_ADDR_CONST(0x258)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_FIELD                   (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_SHIFT)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_RANGE                   7:0
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0  
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0                 _MK_ADDR_CONST(0x25c)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_FIELD                   (_MK_MASK_CONST(0xffffffff) << EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_SHIFT)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_RANGE                   31:0
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0  
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0                 _MK_ADDR_CONST(0x260)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_SECURE                  0x0
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_WORD_COUNT                      0x1
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_RESET_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_WRITE_MASK                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_SHIFT                   _MK_SHIFT_CONST(0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_FIELD                   (_MK_MASK_CONST(0xff) << EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_SHIFT)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_RANGE                   7:0
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_WOFFSET                 0x0
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Reserved address 612 [0x264] 

// Reserved address 616 [0x268] 

// Reserved address 620 [0x26c] 

// Reserved address 624 [0x270] 

// Reserved address 628 [0x274] 

// Reserved address 632 [0x278] 

// Reserved address 636 [0x27c] 

// Reserved address 640 [0x280] 

// Reserved address 644 [0x284] 

// Reserved address 648 [0x288] 

// Reserved address 652 [0x28c] 

// Reserved address 656 [0x290] 

// Reserved address 660 [0x294] 

// Reserved address 664 [0x298] 

// Reserved address 668 [0x29c] 

// Reserved address 672 [0x2a0] 

// Register EMC_AUTO_CAL_CONFIG_0  // Auto-calibration settings for EMC pads
#define EMC_AUTO_CAL_CONFIG_0                   _MK_ADDR_CONST(0x2a4)
#define EMC_AUTO_CAL_CONFIG_0_SECURE                    0x0
#define EMC_AUTO_CAL_CONFIG_0_WORD_COUNT                        0x1
#define EMC_AUTO_CAL_CONFIG_0_RESET_VAL                         _MK_MASK_CONST(0xa60000)
#define EMC_AUTO_CAL_CONFIG_0_RESET_MASK                        _MK_MASK_CONST(0xf3ff1f1f)
#define EMC_AUTO_CAL_CONFIG_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_READ_MASK                         _MK_MASK_CONST(0xf3ff1f1f)
#define EMC_AUTO_CAL_CONFIG_0_WRITE_MASK                        _MK_MASK_CONST(0x73ff1f1f)
// 2's complement offset for pull-up value
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_FIELD                  (_MK_MASK_CONST(0x1f) << EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_SHIFT)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_RANGE                  4:0
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_WOFFSET                        0x0
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PU_OFFSET_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// 2's complement offset for pull-down value
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_SHIFT                  _MK_SHIFT_CONST(8)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_FIELD                  (_MK_MASK_CONST(0x1f) << EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_SHIFT)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_RANGE                  12:8
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_WOFFSET                        0x0
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_PD_OFFSET_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

// Auto Cal calibration step interval (in emc clocks)
// - the default is set for 1.0us calibration step at 166MHz
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_SHIFT                       _MK_SHIFT_CONST(16)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_FIELD                       (_MK_MASK_CONST(0x3ff) << EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_SHIFT)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_RANGE                       25:16
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_WOFFSET                     0x0
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_DEFAULT                     _MK_MASK_CONST(0xa6)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_DEFAULT_MASK                        _MK_MASK_CONST(0x3ff)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_STEP_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// 0 (Normal operation) pad DRVDN/UP_SLWR/F tied to AUTO_CAL output
//                      DRDVDN/UP_SLWR/F[3:0] = AUTO_CAL_PULLDOWN/UP[4:1]
// 1 (override) use CFG2TMC_*_DRVDN/UP_SLWR/F pins to control pad slew inputs
#define EMC_AUTO_CAL_CONFIG_0_AUTOCAL_SLW_OVERRIDE_SHIFT                        _MK_SHIFT_CONST(28)
#define EMC_AUTO_CAL_CONFIG_0_AUTOCAL_SLW_OVERRIDE_FIELD                        (_MK_MASK_CONST(0x1) << EMC_AUTO_CAL_CONFIG_0_AUTOCAL_SLW_OVERRIDE_SHIFT)
#define EMC_AUTO_CAL_CONFIG_0_AUTOCAL_SLW_OVERRIDE_RANGE                        28:28
#define EMC_AUTO_CAL_CONFIG_0_AUTOCAL_SLW_OVERRIDE_WOFFSET                      0x0
#define EMC_AUTO_CAL_CONFIG_0_AUTOCAL_SLW_OVERRIDE_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTOCAL_SLW_OVERRIDE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define EMC_AUTO_CAL_CONFIG_0_AUTOCAL_SLW_OVERRIDE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTOCAL_SLW_OVERRIDE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// 1 (normal operation): use EMC generated pullup/dn (override or autocal) 0 (disabled): use cfg2tmc_xm2* register settings for pullup/dn
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_ENABLE_SHIFT                     _MK_SHIFT_CONST(29)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_ENABLE_FIELD                     (_MK_MASK_CONST(0x1) << EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_ENABLE_SHIFT)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_ENABLE_RANGE                     29:29
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_ENABLE_WOFFSET                   0x0
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_ENABLE_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_ENABLE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_ENABLE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_ENABLE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_ENABLE_INIT_ENUM                 DISABLED
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_ENABLE_DISABLED                  _MK_ENUM_CONST(0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_ENABLE_ENABLED                   _MK_ENUM_CONST(1)

// 0 (normal operation): use AUTO_CAL_PU/PD_OFFSET as an offset 
//                       to the calibration tate machine setting
// 1 (override)        : use AUTO_CAL_PU/PD_OFFSET register 
//                       values directly
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_SHIFT                   _MK_SHIFT_CONST(30)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_FIELD                   (_MK_MASK_CONST(0x1) << EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_SHIFT)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_RANGE                   30:30
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_WOFFSET                 0x0
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_OVERRIDE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Writing a one to this bit starts the calibration state
// machine.  This bit must be set even if the override is
// set in order to latch in the override value.
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_SHIFT                      _MK_SHIFT_CONST(31)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_FIELD                      (_MK_MASK_CONST(0x1) << EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_SHIFT)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_RANGE                      31:31
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_WOFFSET                    0x0
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_CONFIG_0_AUTO_CAL_START_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register EMC_AUTO_CAL_INTERVAL_0  // EMC pad calibration interval
#define EMC_AUTO_CAL_INTERVAL_0                 _MK_ADDR_CONST(0x2a8)
#define EMC_AUTO_CAL_INTERVAL_0_SECURE                  0x0
#define EMC_AUTO_CAL_INTERVAL_0_WORD_COUNT                      0x1
#define EMC_AUTO_CAL_INTERVAL_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_INTERVAL_0_RESET_MASK                      _MK_MASK_CONST(0xfffffff)
#define EMC_AUTO_CAL_INTERVAL_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_INTERVAL_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_INTERVAL_0_READ_MASK                       _MK_MASK_CONST(0xfffffff)
#define EMC_AUTO_CAL_INTERVAL_0_WRITE_MASK                      _MK_MASK_CONST(0xfffffff)
// 0: do calibration once
// Otherwise, auto-calibration occurs at intervals equivalent
// to the programmed number of cycles.
#define EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_FIELD                 (_MK_MASK_CONST(0xfffffff) << EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_SHIFT)
#define EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_RANGE                 27:0
#define EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_WOFFSET                       0x0
#define EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_DEFAULT_MASK                  _MK_MASK_CONST(0xfffffff)
#define EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_INTERVAL_0_AUTO_CAL_INTERVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_AUTO_CAL_STATUS_0  // EMC pad calibration status
#define EMC_AUTO_CAL_STATUS_0                   _MK_ADDR_CONST(0x2ac)
#define EMC_AUTO_CAL_STATUS_0_SECURE                    0x0
#define EMC_AUTO_CAL_STATUS_0_WORD_COUNT                        0x1
#define EMC_AUTO_CAL_STATUS_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_READ_MASK                         _MK_MASK_CONST(0x9f1f1f1f)
#define EMC_AUTO_CAL_STATUS_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
// Pullup code generated by auto-calibration
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_FIELD                     (_MK_MASK_CONST(0x1f) << EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_SHIFT)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_RANGE                     4:0
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_WOFFSET                   0x0
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Pulldown code generated by auto-calibration
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_SHIFT                   _MK_SHIFT_CONST(8)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_FIELD                   (_MK_MASK_CONST(0x1f) << EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_SHIFT)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_RANGE                   12:8
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_WOFFSET                 0x0
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Pullup code sent to pads
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_SHIFT                 _MK_SHIFT_CONST(16)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_FIELD                 (_MK_MASK_CONST(0x1f) << EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_SHIFT)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_RANGE                 20:16
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_WOFFSET                       0x0
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLUP_ADJ_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

// Pulldown code sent to pads
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_SHIFT                       _MK_SHIFT_CONST(24)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_FIELD                       (_MK_MASK_CONST(0x1f) << EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_SHIFT)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_RANGE                       28:24
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_WOFFSET                     0x0
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_PULLDOWN_ADJ_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// One when auto calibrate is active
// - valid only after auto calibrate sequence has 
// completed (EMC_CAL_ACTIVE == 0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_SHIFT                     _MK_SHIFT_CONST(31)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_FIELD                     (_MK_MASK_CONST(0x1) << EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_SHIFT)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_RANGE                     31:31
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_WOFFSET                   0x0
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_AUTO_CAL_STATUS_0_AUTO_CAL_ACTIVE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register EMC_REQ_CTRL_0  // Request status/control
#define EMC_REQ_CTRL_0                  _MK_ADDR_CONST(0x2b0)
#define EMC_REQ_CTRL_0_SECURE                   0x0
#define EMC_REQ_CTRL_0_WORD_COUNT                       0x1
#define EMC_REQ_CTRL_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define EMC_REQ_CTRL_0_RESET_MASK                       _MK_MASK_CONST(0x3)
#define EMC_REQ_CTRL_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define EMC_REQ_CTRL_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_REQ_CTRL_0_READ_MASK                        _MK_MASK_CONST(0x3)
#define EMC_REQ_CTRL_0_WRITE_MASK                       _MK_MASK_CONST(0x3)
// Stall incoming read transactions (1st non-LL read will stall all transactions)
#define EMC_REQ_CTRL_0_STALL_ALL_READS_SHIFT                    _MK_SHIFT_CONST(0)
#define EMC_REQ_CTRL_0_STALL_ALL_READS_FIELD                    (_MK_MASK_CONST(0x1) << EMC_REQ_CTRL_0_STALL_ALL_READS_SHIFT)
#define EMC_REQ_CTRL_0_STALL_ALL_READS_RANGE                    0:0
#define EMC_REQ_CTRL_0_STALL_ALL_READS_WOFFSET                  0x0
#define EMC_REQ_CTRL_0_STALL_ALL_READS_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_REQ_CTRL_0_STALL_ALL_READS_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_REQ_CTRL_0_STALL_ALL_READS_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_REQ_CTRL_0_STALL_ALL_READS_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// Stall incoming write transactions
#define EMC_REQ_CTRL_0_STALL_ALL_WRITES_SHIFT                   _MK_SHIFT_CONST(1)
#define EMC_REQ_CTRL_0_STALL_ALL_WRITES_FIELD                   (_MK_MASK_CONST(0x1) << EMC_REQ_CTRL_0_STALL_ALL_WRITES_SHIFT)
#define EMC_REQ_CTRL_0_STALL_ALL_WRITES_RANGE                   1:1
#define EMC_REQ_CTRL_0_STALL_ALL_WRITES_WOFFSET                 0x0
#define EMC_REQ_CTRL_0_STALL_ALL_WRITES_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_REQ_CTRL_0_STALL_ALL_WRITES_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define EMC_REQ_CTRL_0_STALL_ALL_WRITES_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_REQ_CTRL_0_STALL_ALL_WRITES_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register EMC_EMC_STATUS_0  // EMC state-machine status
#define EMC_EMC_STATUS_0                        _MK_ADDR_CONST(0x2b4)
#define EMC_EMC_STATUS_0_SECURE                         0x0
#define EMC_EMC_STATUS_0_WORD_COUNT                     0x1
#define EMC_EMC_STATUS_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_READ_MASK                      _MK_MASK_CONST(0x1f3337)
#define EMC_EMC_STATUS_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
// Request fifo is empty
#define EMC_EMC_STATUS_0_EMC_REQ_FIFO_EMPTY_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_EMC_STATUS_0_EMC_REQ_FIFO_EMPTY_FIELD                       (_MK_MASK_CONST(0x1) << EMC_EMC_STATUS_0_EMC_REQ_FIFO_EMPTY_SHIFT)
#define EMC_EMC_STATUS_0_EMC_REQ_FIFO_EMPTY_RANGE                       0:0
#define EMC_EMC_STATUS_0_EMC_REQ_FIFO_EMPTY_WOFFSET                     0x0
#define EMC_EMC_STATUS_0_EMC_REQ_FIFO_EMPTY_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_EMC_REQ_FIFO_EMPTY_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_EMC_REQ_FIFO_EMPTY_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_EMC_REQ_FIFO_EMPTY_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// LL Request fifo is empty
#define EMC_EMC_STATUS_0_EMC_LL_REQ_FIFO_EMPTY_SHIFT                    _MK_SHIFT_CONST(1)
#define EMC_EMC_STATUS_0_EMC_LL_REQ_FIFO_EMPTY_FIELD                    (_MK_MASK_CONST(0x1) << EMC_EMC_STATUS_0_EMC_LL_REQ_FIFO_EMPTY_SHIFT)
#define EMC_EMC_STATUS_0_EMC_LL_REQ_FIFO_EMPTY_RANGE                    1:1
#define EMC_EMC_STATUS_0_EMC_LL_REQ_FIFO_EMPTY_WOFFSET                  0x0
#define EMC_EMC_STATUS_0_EMC_LL_REQ_FIFO_EMPTY_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_EMC_LL_REQ_FIFO_EMPTY_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_EMC_LL_REQ_FIFO_EMPTY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_EMC_LL_REQ_FIFO_EMPTY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// All non-stalled requests have completed 
#define EMC_EMC_STATUS_0_NO_OUTSTANDING_TRANSACTIONS_SHIFT                      _MK_SHIFT_CONST(2)
#define EMC_EMC_STATUS_0_NO_OUTSTANDING_TRANSACTIONS_FIELD                      (_MK_MASK_CONST(0x1) << EMC_EMC_STATUS_0_NO_OUTSTANDING_TRANSACTIONS_SHIFT)
#define EMC_EMC_STATUS_0_NO_OUTSTANDING_TRANSACTIONS_RANGE                      2:2
#define EMC_EMC_STATUS_0_NO_OUTSTANDING_TRANSACTIONS_WOFFSET                    0x0
#define EMC_EMC_STATUS_0_NO_OUTSTANDING_TRANSACTIONS_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_NO_OUTSTANDING_TRANSACTIONS_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_NO_OUTSTANDING_TRANSACTIONS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_NO_OUTSTANDING_TRANSACTIONS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// dev[n] has entered powerdown state (incoming req's will awaken if not stalled)
#define EMC_EMC_STATUS_0_DRAM_IN_POWERDOWN_SHIFT                        _MK_SHIFT_CONST(4)
#define EMC_EMC_STATUS_0_DRAM_IN_POWERDOWN_FIELD                        (_MK_MASK_CONST(0x3) << EMC_EMC_STATUS_0_DRAM_IN_POWERDOWN_SHIFT)
#define EMC_EMC_STATUS_0_DRAM_IN_POWERDOWN_RANGE                        5:4
#define EMC_EMC_STATUS_0_DRAM_IN_POWERDOWN_WOFFSET                      0x0
#define EMC_EMC_STATUS_0_DRAM_IN_POWERDOWN_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_DRAM_IN_POWERDOWN_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_DRAM_IN_POWERDOWN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_DRAM_IN_POWERDOWN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// dev[n] has been put into self-refresh (will remain until SR exit cmd).
#define EMC_EMC_STATUS_0_DRAM_IN_SELF_REFRESH_SHIFT                     _MK_SHIFT_CONST(8)
#define EMC_EMC_STATUS_0_DRAM_IN_SELF_REFRESH_FIELD                     (_MK_MASK_CONST(0x3) << EMC_EMC_STATUS_0_DRAM_IN_SELF_REFRESH_SHIFT)
#define EMC_EMC_STATUS_0_DRAM_IN_SELF_REFRESH_RANGE                     9:8
#define EMC_EMC_STATUS_0_DRAM_IN_SELF_REFRESH_WOFFSET                   0x0
#define EMC_EMC_STATUS_0_DRAM_IN_SELF_REFRESH_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_DRAM_IN_SELF_REFRESH_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_DRAM_IN_SELF_REFRESH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_DRAM_IN_SELF_REFRESH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// dev[n] has been put into deep powerdown state
#define EMC_EMC_STATUS_0_DRAM_IN_DPD_SHIFT                      _MK_SHIFT_CONST(12)
#define EMC_EMC_STATUS_0_DRAM_IN_DPD_FIELD                      (_MK_MASK_CONST(0x3) << EMC_EMC_STATUS_0_DRAM_IN_DPD_SHIFT)
#define EMC_EMC_STATUS_0_DRAM_IN_DPD_RANGE                      13:12
#define EMC_EMC_STATUS_0_DRAM_IN_DPD_WOFFSET                    0x0
#define EMC_EMC_STATUS_0_DRAM_IN_DPD_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_DRAM_IN_DPD_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_DRAM_IN_DPD_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_DRAM_IN_DPD_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// mrr fifospace available
#define EMC_EMC_STATUS_0_MRR_FIFO_SPACE_SHIFT                   _MK_SHIFT_CONST(16)
#define EMC_EMC_STATUS_0_MRR_FIFO_SPACE_FIELD                   (_MK_MASK_CONST(0xf) << EMC_EMC_STATUS_0_MRR_FIFO_SPACE_SHIFT)
#define EMC_EMC_STATUS_0_MRR_FIFO_SPACE_RANGE                   19:16
#define EMC_EMC_STATUS_0_MRR_FIFO_SPACE_WOFFSET                 0x0
#define EMC_EMC_STATUS_0_MRR_FIFO_SPACE_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_MRR_FIFO_SPACE_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_MRR_FIFO_SPACE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_MRR_FIFO_SPACE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// mrr data available for reading
#define EMC_EMC_STATUS_0_MRR_DIVLD_SHIFT                        _MK_SHIFT_CONST(20)
#define EMC_EMC_STATUS_0_MRR_DIVLD_FIELD                        (_MK_MASK_CONST(0x1) << EMC_EMC_STATUS_0_MRR_DIVLD_SHIFT)
#define EMC_EMC_STATUS_0_MRR_DIVLD_RANGE                        20:20
#define EMC_EMC_STATUS_0_MRR_DIVLD_WOFFSET                      0x0
#define EMC_EMC_STATUS_0_MRR_DIVLD_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_MRR_DIVLD_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_MRR_DIVLD_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_EMC_STATUS_0_MRR_DIVLD_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register EMC_CFG_2_0  // EMC Configuration
#define EMC_CFG_2_0                     _MK_ADDR_CONST(0x2b8)
#define EMC_CFG_2_0_SECURE                      0x0
#define EMC_CFG_2_0_WORD_COUNT                  0x1
#define EMC_CFG_2_0_RESET_VAL                   _MK_MASK_CONST(0x3)
#define EMC_CFG_2_0_RESET_MASK                  _MK_MASK_CONST(0x80330707)
#define EMC_CFG_2_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_READ_MASK                   _MK_MASK_CONST(0x80330707)
#define EMC_CFG_2_0_WRITE_MASK                  _MK_MASK_CONST(0x80330707)
// allows EMC and CAR to handshake on PLL divider/source changes.
#define EMC_CFG_2_0_CLKCHANGE_REQ_ENABLE_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_CFG_2_0_CLKCHANGE_REQ_ENABLE_FIELD                  (_MK_MASK_CONST(0x1) << EMC_CFG_2_0_CLKCHANGE_REQ_ENABLE_SHIFT)
#define EMC_CFG_2_0_CLKCHANGE_REQ_ENABLE_RANGE                  0:0
#define EMC_CFG_2_0_CLKCHANGE_REQ_ENABLE_WOFFSET                        0x0
#define EMC_CFG_2_0_CLKCHANGE_REQ_ENABLE_DEFAULT                        _MK_MASK_CONST(0x1)
#define EMC_CFG_2_0_CLKCHANGE_REQ_ENABLE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define EMC_CFG_2_0_CLKCHANGE_REQ_ENABLE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_CLKCHANGE_REQ_ENABLE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_CLKCHANGE_REQ_ENABLE_INIT_ENUM                      ENABLED
#define EMC_CFG_2_0_CLKCHANGE_REQ_ENABLE_DISABLED                       _MK_ENUM_CONST(0)
#define EMC_CFG_2_0_CLKCHANGE_REQ_ENABLE_ENABLED                        _MK_ENUM_CONST(1)

// Forces dram into power-down during CLKCHANGE.
#define EMC_CFG_2_0_CLKCHANGE_PD_ENABLE_SHIFT                   _MK_SHIFT_CONST(1)
#define EMC_CFG_2_0_CLKCHANGE_PD_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << EMC_CFG_2_0_CLKCHANGE_PD_ENABLE_SHIFT)
#define EMC_CFG_2_0_CLKCHANGE_PD_ENABLE_RANGE                   1:1
#define EMC_CFG_2_0_CLKCHANGE_PD_ENABLE_WOFFSET                 0x0
#define EMC_CFG_2_0_CLKCHANGE_PD_ENABLE_DEFAULT                 _MK_MASK_CONST(0x1)
#define EMC_CFG_2_0_CLKCHANGE_PD_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define EMC_CFG_2_0_CLKCHANGE_PD_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_CLKCHANGE_PD_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_CLKCHANGE_PD_ENABLE_INIT_ENUM                       ENABLED
#define EMC_CFG_2_0_CLKCHANGE_PD_ENABLE_DISABLED                        _MK_ENUM_CONST(0)
#define EMC_CFG_2_0_CLKCHANGE_PD_ENABLE_ENABLED                 _MK_ENUM_CONST(1)

// Forces dram into self-refresh during CLKCHANGE.   Takes precedent over CLKCHANGE_PD_ENABLE if both are set.
#define EMC_CFG_2_0_CLKCHANGE_SR_ENABLE_SHIFT                   _MK_SHIFT_CONST(2)
#define EMC_CFG_2_0_CLKCHANGE_SR_ENABLE_FIELD                   (_MK_MASK_CONST(0x1) << EMC_CFG_2_0_CLKCHANGE_SR_ENABLE_SHIFT)
#define EMC_CFG_2_0_CLKCHANGE_SR_ENABLE_RANGE                   2:2
#define EMC_CFG_2_0_CLKCHANGE_SR_ENABLE_WOFFSET                 0x0
#define EMC_CFG_2_0_CLKCHANGE_SR_ENABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_CLKCHANGE_SR_ENABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define EMC_CFG_2_0_CLKCHANGE_SR_ENABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_CLKCHANGE_SR_ENABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_CLKCHANGE_SR_ENABLE_INIT_ENUM                       DISABLED
#define EMC_CFG_2_0_CLKCHANGE_SR_ENABLE_DISABLED                        _MK_ENUM_CONST(0)
#define EMC_CFG_2_0_CLKCHANGE_SR_ENABLE_ENABLED                 _MK_ENUM_CONST(1)

// Remaps address/command pins for LPDDR_POP ball-out otherwise    uses standard LPDDR2 pin configuration.
#define EMC_CFG_2_0_PIN_CONFIG_SHIFT                    _MK_SHIFT_CONST(8)
#define EMC_CFG_2_0_PIN_CONFIG_FIELD                    (_MK_MASK_CONST(0x3) << EMC_CFG_2_0_PIN_CONFIG_SHIFT)
#define EMC_CFG_2_0_PIN_CONFIG_RANGE                    9:8
#define EMC_CFG_2_0_PIN_CONFIG_WOFFSET                  0x0
#define EMC_CFG_2_0_PIN_CONFIG_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_PIN_CONFIG_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define EMC_CFG_2_0_PIN_CONFIG_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_PIN_CONFIG_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_PIN_CONFIG_INIT_ENUM                        LPDDR2
#define EMC_CFG_2_0_PIN_CONFIG_LPDDR2                   _MK_ENUM_CONST(0)
#define EMC_CFG_2_0_PIN_CONFIG_LPDDR_POP                        _MK_ENUM_CONST(1)
#define EMC_CFG_2_0_PIN_CONFIG_RESERVED                 _MK_ENUM_CONST(2)

// Used to select source for DRAM clock.  If enabled, xm2_addr_mclk pins   instead of xm2_mclk.  the former is located adjacent to addr pins used
//   in lpddr2 (for lower clk to addr skew).  If disabled, xm2_addr_mclk will
//   be disabled & xm2_mclk will output DRAM clock (required for LPDDR_POP).
#define EMC_CFG_2_0_USE_ADDR_CLK_SHIFT                  _MK_SHIFT_CONST(10)
#define EMC_CFG_2_0_USE_ADDR_CLK_FIELD                  (_MK_MASK_CONST(0x1) << EMC_CFG_2_0_USE_ADDR_CLK_SHIFT)
#define EMC_CFG_2_0_USE_ADDR_CLK_RANGE                  10:10
#define EMC_CFG_2_0_USE_ADDR_CLK_WOFFSET                        0x0
#define EMC_CFG_2_0_USE_ADDR_CLK_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_USE_ADDR_CLK_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define EMC_CFG_2_0_USE_ADDR_CLK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_USE_ADDR_CLK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_USE_ADDR_CLK_INIT_ENUM                      DISABLED
#define EMC_CFG_2_0_USE_ADDR_CLK_DISABLED                       _MK_ENUM_CONST(0)
#define EMC_CFG_2_0_USE_ADDR_CLK_ENABLED                        _MK_ENUM_CONST(1)

// Indicates which AP bytelane is connected to DRAM byte 0 (over which MRR data is returned).
#define EMC_CFG_2_0_MRR_BYTESEL_SHIFT                   _MK_SHIFT_CONST(16)
#define EMC_CFG_2_0_MRR_BYTESEL_FIELD                   (_MK_MASK_CONST(0x3) << EMC_CFG_2_0_MRR_BYTESEL_SHIFT)
#define EMC_CFG_2_0_MRR_BYTESEL_RANGE                   17:16
#define EMC_CFG_2_0_MRR_BYTESEL_WOFFSET                 0x0
#define EMC_CFG_2_0_MRR_BYTESEL_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_MRR_BYTESEL_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define EMC_CFG_2_0_MRR_BYTESEL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_MRR_BYTESEL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// If using 2 X16 DRAM on a single CS to form 32-bit wide data,
//   indicates which bytelane 2nd DRAM's byte 0 is connected to.
#define EMC_CFG_2_0_MRR_BYTESEL_X16_SHIFT                       _MK_SHIFT_CONST(20)
#define EMC_CFG_2_0_MRR_BYTESEL_X16_FIELD                       (_MK_MASK_CONST(0x3) << EMC_CFG_2_0_MRR_BYTESEL_X16_SHIFT)
#define EMC_CFG_2_0_MRR_BYTESEL_X16_RANGE                       21:20
#define EMC_CFG_2_0_MRR_BYTESEL_X16_WOFFSET                     0x0
#define EMC_CFG_2_0_MRR_BYTESEL_X16_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_MRR_BYTESEL_X16_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define EMC_CFG_2_0_MRR_BYTESEL_X16_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_MRR_BYTESEL_X16_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// CYA bit, gives priority to activates over precharges,  determining which    (precharge/activate) is processed first if both are pending and unblocked.
#define EMC_CFG_2_0_DRAMC_PRE_B4_ACT_SHIFT                      _MK_SHIFT_CONST(31)
#define EMC_CFG_2_0_DRAMC_PRE_B4_ACT_FIELD                      (_MK_MASK_CONST(0x1) << EMC_CFG_2_0_DRAMC_PRE_B4_ACT_SHIFT)
#define EMC_CFG_2_0_DRAMC_PRE_B4_ACT_RANGE                      31:31
#define EMC_CFG_2_0_DRAMC_PRE_B4_ACT_WOFFSET                    0x0
#define EMC_CFG_2_0_DRAMC_PRE_B4_ACT_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_DRAMC_PRE_B4_ACT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_CFG_2_0_DRAMC_PRE_B4_ACT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_DRAMC_PRE_B4_ACT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_CFG_2_0_DRAMC_PRE_B4_ACT_INIT_ENUM                  DISABLED
#define EMC_CFG_2_0_DRAMC_PRE_B4_ACT_DISABLED                   _MK_ENUM_CONST(0)
#define EMC_CFG_2_0_DRAMC_PRE_B4_ACT_ENABLED                    _MK_ENUM_CONST(1)


// Register EMC_CFG_DIG_DLL_0  // Configure Digital DLL
#define EMC_CFG_DIG_DLL_0                       _MK_ADDR_CONST(0x2bc)
#define EMC_CFG_DIG_DLL_0_SECURE                        0x0
#define EMC_CFG_DIG_DLL_0_WORD_COUNT                    0x1
#define EMC_CFG_DIG_DLL_0_RESET_VAL                     _MK_MASK_CONST(0x57)
#define EMC_CFG_DIG_DLL_0_RESET_MASK                    _MK_MASK_CONST(0x7bff0fff)
#define EMC_CFG_DIG_DLL_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_READ_MASK                     _MK_MASK_CONST(0xfbff0fff)
#define EMC_CFG_DIG_DLL_0_WRITE_MASK                    _MK_MASK_CONST(0x3bff0fff)
// Enable digital DLL's.
#define EMC_CFG_DIG_DLL_0_CFG_DLL_EN_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_EN_FIELD                      (_MK_MASK_CONST(0x1) << EMC_CFG_DIG_DLL_0_CFG_DLL_EN_SHIFT)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_EN_RANGE                      0:0
#define EMC_CFG_DIG_DLL_0_CFG_DLL_EN_WOFFSET                    0x0
#define EMC_CFG_DIG_DLL_0_CFG_DLL_EN_DEFAULT                    _MK_MASK_CONST(0x1)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_EN_INIT_ENUM                  ENABLED
#define EMC_CFG_DIG_DLL_0_CFG_DLL_EN_DISABLED                   _MK_ENUM_CONST(0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_EN_ENABLED                    _MK_ENUM_CONST(1)

// Enable DL trimmer cells (embedded in pads).
#define EMC_CFG_DIG_DLL_0_CFG_DLI_TRIMMER_EN_SHIFT                      _MK_SHIFT_CONST(1)
#define EMC_CFG_DIG_DLL_0_CFG_DLI_TRIMMER_EN_FIELD                      (_MK_MASK_CONST(0x1) << EMC_CFG_DIG_DLL_0_CFG_DLI_TRIMMER_EN_SHIFT)
#define EMC_CFG_DIG_DLL_0_CFG_DLI_TRIMMER_EN_RANGE                      1:1
#define EMC_CFG_DIG_DLL_0_CFG_DLI_TRIMMER_EN_WOFFSET                    0x0
#define EMC_CFG_DIG_DLL_0_CFG_DLI_TRIMMER_EN_DEFAULT                    _MK_MASK_CONST(0x1)
#define EMC_CFG_DIG_DLL_0_CFG_DLI_TRIMMER_EN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_CFG_DIG_DLL_0_CFG_DLI_TRIMMER_EN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLI_TRIMMER_EN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLI_TRIMMER_EN_INIT_ENUM                  ENABLED
#define EMC_CFG_DIG_DLL_0_CFG_DLI_TRIMMER_EN_DISABLED                   _MK_ENUM_CONST(0)
#define EMC_CFG_DIG_DLL_0_CFG_DLI_TRIMMER_EN_ENABLED                    _MK_ENUM_CONST(1)

// Override DLL's DLI output w/ OVERRIDE_VAL (still uses mult/offset).
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_EN_SHIFT                     _MK_SHIFT_CONST(2)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_EN_FIELD                     (_MK_MASK_CONST(0x1) << EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_EN_SHIFT)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_EN_RANGE                     2:2
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_EN_WOFFSET                   0x0
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_EN_DEFAULT                   _MK_MASK_CONST(0x1)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_EN_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_EN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_EN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_EN_INIT_ENUM                 ENABLED
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_EN_DISABLED                  _MK_ENUM_CONST(0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_EN_ENABLED                   _MK_ENUM_CONST(1)

// Turn off upper DLL & use lower dll output to drive all trimmers.
#define EMC_CFG_DIG_DLL_0_CFG_USE_SINGLE_DLL_SHIFT                      _MK_SHIFT_CONST(3)
#define EMC_CFG_DIG_DLL_0_CFG_USE_SINGLE_DLL_FIELD                      (_MK_MASK_CONST(0x1) << EMC_CFG_DIG_DLL_0_CFG_USE_SINGLE_DLL_SHIFT)
#define EMC_CFG_DIG_DLL_0_CFG_USE_SINGLE_DLL_RANGE                      3:3
#define EMC_CFG_DIG_DLL_0_CFG_USE_SINGLE_DLL_WOFFSET                    0x0
#define EMC_CFG_DIG_DLL_0_CFG_USE_SINGLE_DLL_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_USE_SINGLE_DLL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define EMC_CFG_DIG_DLL_0_CFG_USE_SINGLE_DLL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_USE_SINGLE_DLL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_USE_SINGLE_DLL_INIT_ENUM                  DISABLED
#define EMC_CFG_DIG_DLL_0_CFG_USE_SINGLE_DLL_DISABLED                   _MK_ENUM_CONST(0)
#define EMC_CFG_DIG_DLL_0_CFG_USE_SINGLE_DLL_ENABLED                    _MK_ENUM_CONST(1)

// Set trimmer values directly for each byte via    FBIO_QUSE_DLY/FBIO_DQS_DLY & FBIO_QUSE_DLY_MSB/FBIO_DQS_DLY_MSB.
#define EMC_CFG_DIG_DLL_0_CFG_PERBYTE_TRIMMER_OVERRIDE_SHIFT                    _MK_SHIFT_CONST(4)
#define EMC_CFG_DIG_DLL_0_CFG_PERBYTE_TRIMMER_OVERRIDE_FIELD                    (_MK_MASK_CONST(0x1) << EMC_CFG_DIG_DLL_0_CFG_PERBYTE_TRIMMER_OVERRIDE_SHIFT)
#define EMC_CFG_DIG_DLL_0_CFG_PERBYTE_TRIMMER_OVERRIDE_RANGE                    4:4
#define EMC_CFG_DIG_DLL_0_CFG_PERBYTE_TRIMMER_OVERRIDE_WOFFSET                  0x0
#define EMC_CFG_DIG_DLL_0_CFG_PERBYTE_TRIMMER_OVERRIDE_DEFAULT                  _MK_MASK_CONST(0x1)
#define EMC_CFG_DIG_DLL_0_CFG_PERBYTE_TRIMMER_OVERRIDE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define EMC_CFG_DIG_DLL_0_CFG_PERBYTE_TRIMMER_OVERRIDE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_PERBYTE_TRIMMER_OVERRIDE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_PERBYTE_TRIMMER_OVERRIDE_INIT_ENUM                        ENABLED
#define EMC_CFG_DIG_DLL_0_CFG_PERBYTE_TRIMMER_OVERRIDE_DISABLED                 _MK_ENUM_CONST(0)
#define EMC_CFG_DIG_DLL_0_CFG_PERBYTE_TRIMMER_OVERRIDE_ENABLED                  _MK_ENUM_CONST(1)

// Enable DLL for use w/ lowspeed EMCCLK operation (<200MHz).
#define EMC_CFG_DIG_DLL_0_CFG_DLL_LOWSPEED_SHIFT                        _MK_SHIFT_CONST(5)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_LOWSPEED_FIELD                        (_MK_MASK_CONST(0x1) << EMC_CFG_DIG_DLL_0_CFG_DLL_LOWSPEED_SHIFT)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_LOWSPEED_RANGE                        5:5
#define EMC_CFG_DIG_DLL_0_CFG_DLL_LOWSPEED_WOFFSET                      0x0
#define EMC_CFG_DIG_DLL_0_CFG_DLL_LOWSPEED_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_LOWSPEED_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_LOWSPEED_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_LOWSPEED_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Controls how frequently DLL runs, as follows
#define EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_SHIFT                    _MK_SHIFT_CONST(6)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_FIELD                    (_MK_MASK_CONST(0x3) << EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_SHIFT)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_RANGE                    7:6
#define EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_WOFFSET                  0x0
#define EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_DEFAULT                  _MK_MASK_CONST(0x1)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_INIT_ENUM                        RUN_TIL_LOCK
#define EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_RUN_CONTINUOUS                   _MK_ENUM_CONST(0)    // // DLL will run continuously (only disabled during reads).  This option will consume the most power.

#define EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_RUN_TIL_LOCK                     _MK_ENUM_CONST(1)    // // after DLL_RESET is set, DLL will run until it has locked, then be disabled

#define EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_RUN_PERIODIC                     _MK_ENUM_CONST(2)    // // DLL will be re-enabled w/ each refresh to make sure LOCK is maintained

#define EMC_CFG_DIG_DLL_0_CFG_DLL_MODE_RESERVED                 _MK_ENUM_CONST(3)

// DLL Loop filter control (2^(udset+3)).
#define EMC_CFG_DIG_DLL_0_CFG_DLL_UDSET_SHIFT                   _MK_SHIFT_CONST(8)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_UDSET_FIELD                   (_MK_MASK_CONST(0xf) << EMC_CFG_DIG_DLL_0_CFG_DLL_UDSET_SHIFT)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_UDSET_RANGE                   11:8
#define EMC_CFG_DIG_DLL_0_CFG_DLL_UDSET_WOFFSET                 0x0
#define EMC_CFG_DIG_DLL_0_CFG_DLL_UDSET_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_UDSET_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_UDSET_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_UDSET_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// Value to use in place of DLI output if CFG_DLL_OVERRIDE_EN is set.
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_VAL_SHIFT                    _MK_SHIFT_CONST(16)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_VAL_FIELD                    (_MK_MASK_CONST(0x3ff) << EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_VAL_SHIFT)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_VAL_RANGE                    25:16
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_VAL_WOFFSET                  0x0
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_VAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_VAL_DEFAULT_MASK                     _MK_MASK_CONST(0x3ff)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_VAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_OVERRIDE_VAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// CYA bit -- disable override of DLL logic when DLL_ALM is set
//     (otherwise overrides DLI to 0x3FF).
#define EMC_CFG_DIG_DLL_0_CFG_DLL_ALARM_DISABLE_SHIFT                   _MK_SHIFT_CONST(27)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_ALARM_DISABLE_FIELD                   (_MK_MASK_CONST(0x1) << EMC_CFG_DIG_DLL_0_CFG_DLL_ALARM_DISABLE_SHIFT)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_ALARM_DISABLE_RANGE                   27:27
#define EMC_CFG_DIG_DLL_0_CFG_DLL_ALARM_DISABLE_WOFFSET                 0x0
#define EMC_CFG_DIG_DLL_0_CFG_DLL_ALARM_DISABLE_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_ALARM_DISABLE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_ALARM_DISABLE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_ALARM_DISABLE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

// CYA in case DLL has problems locking. DLL will be treated as locked 
//     after LIMIT emcclk cycles. Counter is reset w/ DLL_RESET (from above) 
//     or w/ each periodic update (if using RUN_PERIODIC).  Settings are:
//       00:  LIMIT = 2^12
//       01:  LIMIT = 2^15
//       10:  LIMIT = 2^16
//       11:  LIMIT = 2^16 + 2^17
#define EMC_CFG_DIG_DLL_0_CFG_DLL_LOCK_LIMIT_SHIFT                      _MK_SHIFT_CONST(28)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_LOCK_LIMIT_FIELD                      (_MK_MASK_CONST(0x3) << EMC_CFG_DIG_DLL_0_CFG_DLL_LOCK_LIMIT_SHIFT)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_LOCK_LIMIT_RANGE                      29:28
#define EMC_CFG_DIG_DLL_0_CFG_DLL_LOCK_LIMIT_WOFFSET                    0x0
#define EMC_CFG_DIG_DLL_0_CFG_DLL_LOCK_LIMIT_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_LOCK_LIMIT_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_LOCK_LIMIT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_LOCK_LIMIT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// Writing 1 to this register will send reset pulse to DLL's on next shadow
//     update.  Must reset DLL's when changing clock frequency by factor >= 2
#define EMC_CFG_DIG_DLL_0_DLL_RESET_SHIFT                       _MK_SHIFT_CONST(30)
#define EMC_CFG_DIG_DLL_0_DLL_RESET_FIELD                       (_MK_MASK_CONST(0x1) << EMC_CFG_DIG_DLL_0_DLL_RESET_SHIFT)
#define EMC_CFG_DIG_DLL_0_DLL_RESET_RANGE                       30:30
#define EMC_CFG_DIG_DLL_0_DLL_RESET_WOFFSET                     0x0
#define EMC_CFG_DIG_DLL_0_DLL_RESET_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_DLL_RESET_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define EMC_CFG_DIG_DLL_0_DLL_RESET_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_DLL_RESET_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

// Writing 1 to this register causes override_val to be used in place of
// DLL output until DLL_LOCK is obtained.  Takes effect on next shadow update.
#define EMC_CFG_DIG_DLL_0_CFG_DLL_USE_OVERRIDE_UNTIL_LOCK_SHIFT                 _MK_SHIFT_CONST(31)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_USE_OVERRIDE_UNTIL_LOCK_FIELD                 (_MK_MASK_CONST(0x1) << EMC_CFG_DIG_DLL_0_CFG_DLL_USE_OVERRIDE_UNTIL_LOCK_SHIFT)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_USE_OVERRIDE_UNTIL_LOCK_RANGE                 31:31
#define EMC_CFG_DIG_DLL_0_CFG_DLL_USE_OVERRIDE_UNTIL_LOCK_WOFFSET                       0x0
#define EMC_CFG_DIG_DLL_0_CFG_DLL_USE_OVERRIDE_UNTIL_LOCK_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_USE_OVERRIDE_UNTIL_LOCK_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_USE_OVERRIDE_UNTIL_LOCK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CFG_DIG_DLL_0_CFG_DLL_USE_OVERRIDE_UNTIL_LOCK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_DLL_XFORM_DQS_0  // Configure Digital DLL
#define EMC_DLL_XFORM_DQS_0                     _MK_ADDR_CONST(0x2c0)
#define EMC_DLL_XFORM_DQS_0_SECURE                      0x0
#define EMC_DLL_XFORM_DQS_0_WORD_COUNT                  0x1
#define EMC_DLL_XFORM_DQS_0_RESET_VAL                   _MK_MASK_CONST(0x10)
#define EMC_DLL_XFORM_DQS_0_RESET_MASK                  _MK_MASK_CONST(0x7fff1f)
#define EMC_DLL_XFORM_DQS_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EMC_DLL_XFORM_DQS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_DLL_XFORM_DQS_0_READ_MASK                   _MK_MASK_CONST(0x7fff1f)
#define EMC_DLL_XFORM_DQS_0_WRITE_MASK                  _MK_MASK_CONST(0x7fff1f)
#define EMC_DLL_XFORM_DQS_0_XFORM_DQS_MULT_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC_DLL_XFORM_DQS_0_XFORM_DQS_MULT_FIELD                        (_MK_MASK_CONST(0x1f) << EMC_DLL_XFORM_DQS_0_XFORM_DQS_MULT_SHIFT)
#define EMC_DLL_XFORM_DQS_0_XFORM_DQS_MULT_RANGE                        4:0
#define EMC_DLL_XFORM_DQS_0_XFORM_DQS_MULT_WOFFSET                      0x0
#define EMC_DLL_XFORM_DQS_0_XFORM_DQS_MULT_DEFAULT                      _MK_MASK_CONST(0x10)
#define EMC_DLL_XFORM_DQS_0_XFORM_DQS_MULT_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define EMC_DLL_XFORM_DQS_0_XFORM_DQS_MULT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_DLL_XFORM_DQS_0_XFORM_DQS_MULT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define EMC_DLL_XFORM_DQS_0_XFORM_DQS_OFFS_SHIFT                        _MK_SHIFT_CONST(8)
#define EMC_DLL_XFORM_DQS_0_XFORM_DQS_OFFS_FIELD                        (_MK_MASK_CONST(0x7fff) << EMC_DLL_XFORM_DQS_0_XFORM_DQS_OFFS_SHIFT)
#define EMC_DLL_XFORM_DQS_0_XFORM_DQS_OFFS_RANGE                        22:8
#define EMC_DLL_XFORM_DQS_0_XFORM_DQS_OFFS_WOFFSET                      0x0
#define EMC_DLL_XFORM_DQS_0_XFORM_DQS_OFFS_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DLL_XFORM_DQS_0_XFORM_DQS_OFFS_DEFAULT_MASK                 _MK_MASK_CONST(0x7fff)
#define EMC_DLL_XFORM_DQS_0_XFORM_DQS_OFFS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_DLL_XFORM_DQS_0_XFORM_DQS_OFFS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register EMC_DLL_XFORM_QUSE_0  // Configure Digital DLL
#define EMC_DLL_XFORM_QUSE_0                    _MK_ADDR_CONST(0x2c4)
#define EMC_DLL_XFORM_QUSE_0_SECURE                     0x0
#define EMC_DLL_XFORM_QUSE_0_WORD_COUNT                         0x1
#define EMC_DLL_XFORM_QUSE_0_RESET_VAL                  _MK_MASK_CONST(0x8)
#define EMC_DLL_XFORM_QUSE_0_RESET_MASK                         _MK_MASK_CONST(0x7fff1f)
#define EMC_DLL_XFORM_QUSE_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define EMC_DLL_XFORM_QUSE_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_DLL_XFORM_QUSE_0_READ_MASK                  _MK_MASK_CONST(0x7fff1f)
#define EMC_DLL_XFORM_QUSE_0_WRITE_MASK                         _MK_MASK_CONST(0x7fff1f)
#define EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_MULT_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_MULT_FIELD                      (_MK_MASK_CONST(0x1f) << EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_MULT_SHIFT)
#define EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_MULT_RANGE                      4:0
#define EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_MULT_WOFFSET                    0x0
#define EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_MULT_DEFAULT                    _MK_MASK_CONST(0x8)
#define EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_MULT_DEFAULT_MASK                       _MK_MASK_CONST(0x1f)
#define EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_MULT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_MULT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_OFFS_SHIFT                      _MK_SHIFT_CONST(8)
#define EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_OFFS_FIELD                      (_MK_MASK_CONST(0x7fff) << EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_OFFS_SHIFT)
#define EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_OFFS_RANGE                      22:8
#define EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_OFFS_WOFFSET                    0x0
#define EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_OFFS_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_OFFS_DEFAULT_MASK                       _MK_MASK_CONST(0x7fff)
#define EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_OFFS_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_DLL_XFORM_QUSE_0_XFORM_QUSE_OFFS_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register EMC_DIG_DLL_UPPER_STATUS_0  // Digital DLL Status
#define EMC_DIG_DLL_UPPER_STATUS_0                      _MK_ADDR_CONST(0x2c8)
#define EMC_DIG_DLL_UPPER_STATUS_0_SECURE                       0x0
#define EMC_DIG_DLL_UPPER_STATUS_0_WORD_COUNT                   0x1
#define EMC_DIG_DLL_UPPER_STATUS_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_RESET_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_READ_MASK                    _MK_MASK_CONST(0xe3ff)
#define EMC_DIG_DLL_UPPER_STATUS_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_OUT_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_OUT_FIELD                  (_MK_MASK_CONST(0x3ff) << EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_OUT_SHIFT)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_OUT_RANGE                  9:0
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_OUT_WOFFSET                        0x0
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_OUT_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_OUT_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_OUT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_OUT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_TIMEOUT_SHIFT                 _MK_SHIFT_CONST(13)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_TIMEOUT_FIELD                 (_MK_MASK_CONST(0x1) << EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_TIMEOUT_SHIFT)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_TIMEOUT_RANGE                 13:13
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_TIMEOUT_WOFFSET                       0x0
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_TIMEOUT_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_TIMEOUT_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_TIMEOUT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_TIMEOUT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_ALARM_SHIFT                        _MK_SHIFT_CONST(14)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_ALARM_FIELD                        (_MK_MASK_CONST(0x1) << EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_ALARM_SHIFT)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_ALARM_RANGE                        14:14
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_ALARM_WOFFSET                      0x0
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_ALARM_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_ALARM_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_ALARM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_ALARM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_SHIFT                 _MK_SHIFT_CONST(15)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_FIELD                 (_MK_MASK_CONST(0x1) << EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_SHIFT)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_RANGE                 15:15
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_WOFFSET                       0x0
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_UPPER_STATUS_0_DLL_UPPER_LOCK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_DIG_DLL_LOWER_STATUS_0  // Digital DLL Status
#define EMC_DIG_DLL_LOWER_STATUS_0                      _MK_ADDR_CONST(0x2cc)
#define EMC_DIG_DLL_LOWER_STATUS_0_SECURE                       0x0
#define EMC_DIG_DLL_LOWER_STATUS_0_WORD_COUNT                   0x1
#define EMC_DIG_DLL_LOWER_STATUS_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_RESET_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_READ_MASK                    _MK_MASK_CONST(0xe3ff)
#define EMC_DIG_DLL_LOWER_STATUS_0_WRITE_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_OUT_SHIFT                  _MK_SHIFT_CONST(0)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_OUT_FIELD                  (_MK_MASK_CONST(0x3ff) << EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_OUT_SHIFT)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_OUT_RANGE                  9:0
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_OUT_WOFFSET                        0x0
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_OUT_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_OUT_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_OUT_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_OUT_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_TIMEOUT_SHIFT                 _MK_SHIFT_CONST(13)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_TIMEOUT_FIELD                 (_MK_MASK_CONST(0x1) << EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_TIMEOUT_SHIFT)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_TIMEOUT_RANGE                 13:13
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_TIMEOUT_WOFFSET                       0x0
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_TIMEOUT_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_TIMEOUT_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_TIMEOUT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_TIMEOUT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_ALARM_SHIFT                        _MK_SHIFT_CONST(14)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_ALARM_FIELD                        (_MK_MASK_CONST(0x1) << EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_ALARM_SHIFT)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_ALARM_RANGE                        14:14
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_ALARM_WOFFSET                      0x0
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_ALARM_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_ALARM_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_ALARM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_ALARM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_SHIFT                 _MK_SHIFT_CONST(15)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_FIELD                 (_MK_MASK_CONST(0x1) << EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_SHIFT)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_RANGE                 15:15
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_WOFFSET                       0x0
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_DIG_DLL_LOWER_STATUS_0_DLL_LOWER_LOCK_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_CFG_CLKTRIM_0_0  // Configures m4clk trimmers
#define EMC_CFG_CLKTRIM_0_0                     _MK_ADDR_CONST(0x2d0)
#define EMC_CFG_CLKTRIM_0_0_SECURE                      0x0
#define EMC_CFG_CLKTRIM_0_0_WORD_COUNT                  0x1
#define EMC_CFG_CLKTRIM_0_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_RESET_MASK                  _MK_MASK_CONST(0x3fffffff)
#define EMC_CFG_CLKTRIM_0_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_READ_MASK                   _MK_MASK_CONST(0x3fffffff)
#define EMC_CFG_CLKTRIM_0_0_WRITE_MASK                  _MK_MASK_CONST(0x3fffffff)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA0_CLKTRIM_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA0_CLKTRIM_FIELD                     (_MK_MASK_CONST(0x3f) << EMC_CFG_CLKTRIM_0_0_CFG_DATA0_CLKTRIM_SHIFT)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA0_CLKTRIM_RANGE                     5:0
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA0_CLKTRIM_WOFFSET                   0x0
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA0_CLKTRIM_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA0_CLKTRIM_DEFAULT_MASK                      _MK_MASK_CONST(0x3f)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA0_CLKTRIM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA0_CLKTRIM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA0_CLKTRIM_MAX                       _MK_ENUM_CONST(47)

#define EMC_CFG_CLKTRIM_0_0_CFG_DATA1_CLKTRIM_SHIFT                     _MK_SHIFT_CONST(6)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA1_CLKTRIM_FIELD                     (_MK_MASK_CONST(0x3f) << EMC_CFG_CLKTRIM_0_0_CFG_DATA1_CLKTRIM_SHIFT)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA1_CLKTRIM_RANGE                     11:6
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA1_CLKTRIM_WOFFSET                   0x0
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA1_CLKTRIM_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA1_CLKTRIM_DEFAULT_MASK                      _MK_MASK_CONST(0x3f)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA1_CLKTRIM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA1_CLKTRIM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA1_CLKTRIM_MAX                       _MK_ENUM_CONST(47)

#define EMC_CFG_CLKTRIM_0_0_CFG_DATA2_CLKTRIM_SHIFT                     _MK_SHIFT_CONST(12)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA2_CLKTRIM_FIELD                     (_MK_MASK_CONST(0x3f) << EMC_CFG_CLKTRIM_0_0_CFG_DATA2_CLKTRIM_SHIFT)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA2_CLKTRIM_RANGE                     17:12
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA2_CLKTRIM_WOFFSET                   0x0
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA2_CLKTRIM_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA2_CLKTRIM_DEFAULT_MASK                      _MK_MASK_CONST(0x3f)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA2_CLKTRIM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA2_CLKTRIM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA2_CLKTRIM_MAX                       _MK_ENUM_CONST(47)

#define EMC_CFG_CLKTRIM_0_0_CFG_DATA3_CLKTRIM_SHIFT                     _MK_SHIFT_CONST(18)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA3_CLKTRIM_FIELD                     (_MK_MASK_CONST(0x3f) << EMC_CFG_CLKTRIM_0_0_CFG_DATA3_CLKTRIM_SHIFT)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA3_CLKTRIM_RANGE                     23:18
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA3_CLKTRIM_WOFFSET                   0x0
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA3_CLKTRIM_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA3_CLKTRIM_DEFAULT_MASK                      _MK_MASK_CONST(0x3f)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA3_CLKTRIM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA3_CLKTRIM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_CFG_DATA3_CLKTRIM_MAX                       _MK_ENUM_CONST(47)

#define EMC_CFG_CLKTRIM_0_0_CFG_MCLK_ADDR_CLKTRIM_SHIFT                 _MK_SHIFT_CONST(24)
#define EMC_CFG_CLKTRIM_0_0_CFG_MCLK_ADDR_CLKTRIM_FIELD                 (_MK_MASK_CONST(0x3f) << EMC_CFG_CLKTRIM_0_0_CFG_MCLK_ADDR_CLKTRIM_SHIFT)
#define EMC_CFG_CLKTRIM_0_0_CFG_MCLK_ADDR_CLKTRIM_RANGE                 29:24
#define EMC_CFG_CLKTRIM_0_0_CFG_MCLK_ADDR_CLKTRIM_WOFFSET                       0x0
#define EMC_CFG_CLKTRIM_0_0_CFG_MCLK_ADDR_CLKTRIM_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_CFG_MCLK_ADDR_CLKTRIM_DEFAULT_MASK                  _MK_MASK_CONST(0x3f)
#define EMC_CFG_CLKTRIM_0_0_CFG_MCLK_ADDR_CLKTRIM_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_CFG_MCLK_ADDR_CLKTRIM_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_0_0_CFG_MCLK_ADDR_CLKTRIM_MAX                   _MK_ENUM_CONST(47)


// Register EMC_CFG_CLKTRIM_1_0  // Configures m4clk trimmers
#define EMC_CFG_CLKTRIM_1_0                     _MK_ADDR_CONST(0x2d4)
#define EMC_CFG_CLKTRIM_1_0_SECURE                      0x0
#define EMC_CFG_CLKTRIM_1_0_WORD_COUNT                  0x1
#define EMC_CFG_CLKTRIM_1_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_RESET_MASK                  _MK_MASK_CONST(0x3fffffff)
#define EMC_CFG_CLKTRIM_1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_READ_MASK                   _MK_MASK_CONST(0x3fffffff)
#define EMC_CFG_CLKTRIM_1_0_WRITE_MASK                  _MK_MASK_CONST(0x3fffffff)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS0_CLKTRIM_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS0_CLKTRIM_FIELD                      (_MK_MASK_CONST(0x3f) << EMC_CFG_CLKTRIM_1_0_CFG_DQS0_CLKTRIM_SHIFT)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS0_CLKTRIM_RANGE                      5:0
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS0_CLKTRIM_WOFFSET                    0x0
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS0_CLKTRIM_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS0_CLKTRIM_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS0_CLKTRIM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS0_CLKTRIM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS0_CLKTRIM_MAX                        _MK_ENUM_CONST(47)

#define EMC_CFG_CLKTRIM_1_0_CFG_DQS1_CLKTRIM_SHIFT                      _MK_SHIFT_CONST(6)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS1_CLKTRIM_FIELD                      (_MK_MASK_CONST(0x3f) << EMC_CFG_CLKTRIM_1_0_CFG_DQS1_CLKTRIM_SHIFT)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS1_CLKTRIM_RANGE                      11:6
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS1_CLKTRIM_WOFFSET                    0x0
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS1_CLKTRIM_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS1_CLKTRIM_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS1_CLKTRIM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS1_CLKTRIM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS1_CLKTRIM_MAX                        _MK_ENUM_CONST(47)

#define EMC_CFG_CLKTRIM_1_0_CFG_DQS2_CLKTRIM_SHIFT                      _MK_SHIFT_CONST(12)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS2_CLKTRIM_FIELD                      (_MK_MASK_CONST(0x3f) << EMC_CFG_CLKTRIM_1_0_CFG_DQS2_CLKTRIM_SHIFT)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS2_CLKTRIM_RANGE                      17:12
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS2_CLKTRIM_WOFFSET                    0x0
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS2_CLKTRIM_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS2_CLKTRIM_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS2_CLKTRIM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS2_CLKTRIM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS2_CLKTRIM_MAX                        _MK_ENUM_CONST(47)

#define EMC_CFG_CLKTRIM_1_0_CFG_DQS3_CLKTRIM_SHIFT                      _MK_SHIFT_CONST(18)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS3_CLKTRIM_FIELD                      (_MK_MASK_CONST(0x3f) << EMC_CFG_CLKTRIM_1_0_CFG_DQS3_CLKTRIM_SHIFT)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS3_CLKTRIM_RANGE                      23:18
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS3_CLKTRIM_WOFFSET                    0x0
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS3_CLKTRIM_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS3_CLKTRIM_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS3_CLKTRIM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS3_CLKTRIM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_CFG_DQS3_CLKTRIM_MAX                        _MK_ENUM_CONST(47)

#define EMC_CFG_CLKTRIM_1_0_CFG_MCLK_CLKTRIM_SHIFT                      _MK_SHIFT_CONST(24)
#define EMC_CFG_CLKTRIM_1_0_CFG_MCLK_CLKTRIM_FIELD                      (_MK_MASK_CONST(0x3f) << EMC_CFG_CLKTRIM_1_0_CFG_MCLK_CLKTRIM_SHIFT)
#define EMC_CFG_CLKTRIM_1_0_CFG_MCLK_CLKTRIM_RANGE                      29:24
#define EMC_CFG_CLKTRIM_1_0_CFG_MCLK_CLKTRIM_WOFFSET                    0x0
#define EMC_CFG_CLKTRIM_1_0_CFG_MCLK_CLKTRIM_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_CFG_MCLK_CLKTRIM_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define EMC_CFG_CLKTRIM_1_0_CFG_MCLK_CLKTRIM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_CFG_MCLK_CLKTRIM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_1_0_CFG_MCLK_CLKTRIM_MAX                        _MK_ENUM_CONST(47)


// Register EMC_CFG_CLKTRIM_2_0  // Configures m4clk trimmers
#define EMC_CFG_CLKTRIM_2_0                     _MK_ADDR_CONST(0x2d8)
#define EMC_CFG_CLKTRIM_2_0_SECURE                      0x0
#define EMC_CFG_CLKTRIM_2_0_WORD_COUNT                  0x1
#define EMC_CFG_CLKTRIM_2_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_RESET_MASK                  _MK_MASK_CONST(0x3fffffff)
#define EMC_CFG_CLKTRIM_2_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_READ_MASK                   _MK_MASK_CONST(0x3fffffff)
#define EMC_CFG_CLKTRIM_2_0_WRITE_MASK                  _MK_MASK_CONST(0x3fffffff)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ0_CLKTRIM_SHIFT                       _MK_SHIFT_CONST(0)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ0_CLKTRIM_FIELD                       (_MK_MASK_CONST(0x3f) << EMC_CFG_CLKTRIM_2_0_CFG_DQ0_CLKTRIM_SHIFT)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ0_CLKTRIM_RANGE                       5:0
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ0_CLKTRIM_WOFFSET                     0x0
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ0_CLKTRIM_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ0_CLKTRIM_DEFAULT_MASK                        _MK_MASK_CONST(0x3f)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ0_CLKTRIM_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ0_CLKTRIM_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ0_CLKTRIM_MAX                 _MK_ENUM_CONST(47)

#define EMC_CFG_CLKTRIM_2_0_CFG_DQ1_CLKTRIM_SHIFT                       _MK_SHIFT_CONST(6)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ1_CLKTRIM_FIELD                       (_MK_MASK_CONST(0x3f) << EMC_CFG_CLKTRIM_2_0_CFG_DQ1_CLKTRIM_SHIFT)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ1_CLKTRIM_RANGE                       11:6
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ1_CLKTRIM_WOFFSET                     0x0
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ1_CLKTRIM_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ1_CLKTRIM_DEFAULT_MASK                        _MK_MASK_CONST(0x3f)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ1_CLKTRIM_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ1_CLKTRIM_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ1_CLKTRIM_MAX                 _MK_ENUM_CONST(47)

#define EMC_CFG_CLKTRIM_2_0_CFG_DQ2_CLKTRIM_SHIFT                       _MK_SHIFT_CONST(12)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ2_CLKTRIM_FIELD                       (_MK_MASK_CONST(0x3f) << EMC_CFG_CLKTRIM_2_0_CFG_DQ2_CLKTRIM_SHIFT)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ2_CLKTRIM_RANGE                       17:12
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ2_CLKTRIM_WOFFSET                     0x0
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ2_CLKTRIM_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ2_CLKTRIM_DEFAULT_MASK                        _MK_MASK_CONST(0x3f)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ2_CLKTRIM_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ2_CLKTRIM_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ2_CLKTRIM_MAX                 _MK_ENUM_CONST(47)

#define EMC_CFG_CLKTRIM_2_0_CFG_DQ3_CLKTRIM_SHIFT                       _MK_SHIFT_CONST(18)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ3_CLKTRIM_FIELD                       (_MK_MASK_CONST(0x3f) << EMC_CFG_CLKTRIM_2_0_CFG_DQ3_CLKTRIM_SHIFT)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ3_CLKTRIM_RANGE                       23:18
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ3_CLKTRIM_WOFFSET                     0x0
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ3_CLKTRIM_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ3_CLKTRIM_DEFAULT_MASK                        _MK_MASK_CONST(0x3f)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ3_CLKTRIM_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ3_CLKTRIM_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_CFG_DQ3_CLKTRIM_MAX                 _MK_ENUM_CONST(47)

#define EMC_CFG_CLKTRIM_2_0_CFG_CMD_CLKTRIM_SHIFT                       _MK_SHIFT_CONST(24)
#define EMC_CFG_CLKTRIM_2_0_CFG_CMD_CLKTRIM_FIELD                       (_MK_MASK_CONST(0x3f) << EMC_CFG_CLKTRIM_2_0_CFG_CMD_CLKTRIM_SHIFT)
#define EMC_CFG_CLKTRIM_2_0_CFG_CMD_CLKTRIM_RANGE                       29:24
#define EMC_CFG_CLKTRIM_2_0_CFG_CMD_CLKTRIM_WOFFSET                     0x0
#define EMC_CFG_CLKTRIM_2_0_CFG_CMD_CLKTRIM_DEFAULT                     _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_CFG_CMD_CLKTRIM_DEFAULT_MASK                        _MK_MASK_CONST(0x3f)
#define EMC_CFG_CLKTRIM_2_0_CFG_CMD_CLKTRIM_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_CFG_CMD_CLKTRIM_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_CFG_CLKTRIM_2_0_CFG_CMD_CLKTRIM_MAX                 _MK_ENUM_CONST(47)


// Register EMC_CTT_TERM_CTRL_0  // Configure CTT termination output drive strength
#define EMC_CTT_TERM_CTRL_0                     _MK_ADDR_CONST(0x2dc)
#define EMC_CTT_TERM_CTRL_0_SECURE                      0x0
#define EMC_CTT_TERM_CTRL_0_WORD_COUNT                  0x1
#define EMC_CTT_TERM_CTRL_0_RESET_VAL                   _MK_MASK_CONST(0x802)
#define EMC_CTT_TERM_CTRL_0_RESET_MASK                  _MK_MASK_CONST(0x80001f07)
#define EMC_CTT_TERM_CTRL_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EMC_CTT_TERM_CTRL_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_CTT_TERM_CTRL_0_READ_MASK                   _MK_MASK_CONST(0x9f0f9f07)
#define EMC_CTT_TERM_CTRL_0_WRITE_MASK                  _MK_MASK_CONST(0x80001f07)
// 
#define EMC_CTT_TERM_CTRL_0_TERM_SLOPE_SHIFT                    _MK_SHIFT_CONST(0)
#define EMC_CTT_TERM_CTRL_0_TERM_SLOPE_FIELD                    (_MK_MASK_CONST(0x7) << EMC_CTT_TERM_CTRL_0_TERM_SLOPE_SHIFT)
#define EMC_CTT_TERM_CTRL_0_TERM_SLOPE_RANGE                    2:0
#define EMC_CTT_TERM_CTRL_0_TERM_SLOPE_WOFFSET                  0x0
#define EMC_CTT_TERM_CTRL_0_TERM_SLOPE_DEFAULT                  _MK_MASK_CONST(0x2)
#define EMC_CTT_TERM_CTRL_0_TERM_SLOPE_DEFAULT_MASK                     _MK_MASK_CONST(0x7)
#define EMC_CTT_TERM_CTRL_0_TERM_SLOPE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CTT_TERM_CTRL_0_TERM_SLOPE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

//
#define EMC_CTT_TERM_CTRL_0_TERM_OFFSET_SHIFT                   _MK_SHIFT_CONST(8)
#define EMC_CTT_TERM_CTRL_0_TERM_OFFSET_FIELD                   (_MK_MASK_CONST(0x1f) << EMC_CTT_TERM_CTRL_0_TERM_OFFSET_SHIFT)
#define EMC_CTT_TERM_CTRL_0_TERM_OFFSET_RANGE                   12:8
#define EMC_CTT_TERM_CTRL_0_TERM_OFFSET_WOFFSET                 0x0
#define EMC_CTT_TERM_CTRL_0_TERM_OFFSET_DEFAULT                 _MK_MASK_CONST(0x8)
#define EMC_CTT_TERM_CTRL_0_TERM_OFFSET_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define EMC_CTT_TERM_CTRL_0_TERM_OFFSET_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define EMC_CTT_TERM_CTRL_0_TERM_OFFSET_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define EMC_CTT_TERM_CTRL_0_TERM_DRVDN_SHIFT                    _MK_SHIFT_CONST(15)
#define EMC_CTT_TERM_CTRL_0_TERM_DRVDN_FIELD                    (_MK_MASK_CONST(0x1f) << EMC_CTT_TERM_CTRL_0_TERM_DRVDN_SHIFT)
#define EMC_CTT_TERM_CTRL_0_TERM_DRVDN_RANGE                    19:15
#define EMC_CTT_TERM_CTRL_0_TERM_DRVDN_WOFFSET                  0x0
#define EMC_CTT_TERM_CTRL_0_TERM_DRVDN_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CTT_TERM_CTRL_0_TERM_DRVDN_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_CTT_TERM_CTRL_0_TERM_DRVDN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CTT_TERM_CTRL_0_TERM_DRVDN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define EMC_CTT_TERM_CTRL_0_TERM_DRVUP_SHIFT                    _MK_SHIFT_CONST(24)
#define EMC_CTT_TERM_CTRL_0_TERM_DRVUP_FIELD                    (_MK_MASK_CONST(0x1f) << EMC_CTT_TERM_CTRL_0_TERM_DRVUP_SHIFT)
#define EMC_CTT_TERM_CTRL_0_TERM_DRVUP_RANGE                    28:24
#define EMC_CTT_TERM_CTRL_0_TERM_DRVUP_WOFFSET                  0x0
#define EMC_CTT_TERM_CTRL_0_TERM_DRVUP_DEFAULT                  _MK_MASK_CONST(0x0)
#define EMC_CTT_TERM_CTRL_0_TERM_DRVUP_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_CTT_TERM_CTRL_0_TERM_DRVUP_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CTT_TERM_CTRL_0_TERM_DRVUP_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

// 
#define EMC_CTT_TERM_CTRL_0_TERM_OVERRIDE_SHIFT                 _MK_SHIFT_CONST(31)
#define EMC_CTT_TERM_CTRL_0_TERM_OVERRIDE_FIELD                 (_MK_MASK_CONST(0x1) << EMC_CTT_TERM_CTRL_0_TERM_OVERRIDE_SHIFT)
#define EMC_CTT_TERM_CTRL_0_TERM_OVERRIDE_RANGE                 31:31
#define EMC_CTT_TERM_CTRL_0_TERM_OVERRIDE_WOFFSET                       0x0
#define EMC_CTT_TERM_CTRL_0_TERM_OVERRIDE_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_CTT_TERM_CTRL_0_TERM_OVERRIDE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define EMC_CTT_TERM_CTRL_0_TERM_OVERRIDE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_CTT_TERM_CTRL_0_TERM_OVERRIDE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_CTT_TERM_CTRL_0_TERM_OVERRIDE_INIT_ENUM                     DISABLED
#define EMC_CTT_TERM_CTRL_0_TERM_OVERRIDE_DISABLED                      _MK_ENUM_CONST(0)
#define EMC_CTT_TERM_CTRL_0_TERM_OVERRIDE_ENABLED                       _MK_ENUM_CONST(1)


// Register EMC_ZCAL_REF_CNT_0  // Configure ZQ Calibration
#define EMC_ZCAL_REF_CNT_0                      _MK_ADDR_CONST(0x2e0)
#define EMC_ZCAL_REF_CNT_0_SECURE                       0x0
#define EMC_ZCAL_REF_CNT_0_WORD_COUNT                   0x1
#define EMC_ZCAL_REF_CNT_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define EMC_ZCAL_REF_CNT_0_RESET_MASK                   _MK_MASK_CONST(0xffffff)
#define EMC_ZCAL_REF_CNT_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_ZCAL_REF_CNT_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_ZCAL_REF_CNT_0_READ_MASK                    _MK_MASK_CONST(0xffffff)
#define EMC_ZCAL_REF_CNT_0_WRITE_MASK                   _MK_MASK_CONST(0xffffff)
// Number of refreshes to wait between issuance of ZCAL_MRW_CMD.  If 0, ZCAL is disabled and internal counter will be reset.
#define EMC_ZCAL_REF_CNT_0_ZCAL_REF_INTERVAL_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC_ZCAL_REF_CNT_0_ZCAL_REF_INTERVAL_FIELD                      (_MK_MASK_CONST(0xffffff) << EMC_ZCAL_REF_CNT_0_ZCAL_REF_INTERVAL_SHIFT)
#define EMC_ZCAL_REF_CNT_0_ZCAL_REF_INTERVAL_RANGE                      23:0
#define EMC_ZCAL_REF_CNT_0_ZCAL_REF_INTERVAL_WOFFSET                    0x0
#define EMC_ZCAL_REF_CNT_0_ZCAL_REF_INTERVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_ZCAL_REF_CNT_0_ZCAL_REF_INTERVAL_DEFAULT_MASK                       _MK_MASK_CONST(0xffffff)
#define EMC_ZCAL_REF_CNT_0_ZCAL_REF_INTERVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_ZCAL_REF_CNT_0_ZCAL_REF_INTERVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register EMC_ZCAL_WAIT_CNT_0  // Configure ZQ Calibration
#define EMC_ZCAL_WAIT_CNT_0                     _MK_ADDR_CONST(0x2e4)
#define EMC_ZCAL_WAIT_CNT_0_SECURE                      0x0
#define EMC_ZCAL_WAIT_CNT_0_WORD_COUNT                  0x1
#define EMC_ZCAL_WAIT_CNT_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define EMC_ZCAL_WAIT_CNT_0_RESET_MASK                  _MK_MASK_CONST(0xff)
#define EMC_ZCAL_WAIT_CNT_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define EMC_ZCAL_WAIT_CNT_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define EMC_ZCAL_WAIT_CNT_0_READ_MASK                   _MK_MASK_CONST(0xff)
#define EMC_ZCAL_WAIT_CNT_0_WRITE_MASK                  _MK_MASK_CONST(0xff)
// Number of emc clocks to wait before issuing any commands after sending ZCAL_MRW_CMD.
#define EMC_ZCAL_WAIT_CNT_0_ZCAL_WAIT_CNT_SHIFT                 _MK_SHIFT_CONST(0)
#define EMC_ZCAL_WAIT_CNT_0_ZCAL_WAIT_CNT_FIELD                 (_MK_MASK_CONST(0xff) << EMC_ZCAL_WAIT_CNT_0_ZCAL_WAIT_CNT_SHIFT)
#define EMC_ZCAL_WAIT_CNT_0_ZCAL_WAIT_CNT_RANGE                 7:0
#define EMC_ZCAL_WAIT_CNT_0_ZCAL_WAIT_CNT_WOFFSET                       0x0
#define EMC_ZCAL_WAIT_CNT_0_ZCAL_WAIT_CNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define EMC_ZCAL_WAIT_CNT_0_ZCAL_WAIT_CNT_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define EMC_ZCAL_WAIT_CNT_0_ZCAL_WAIT_CNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_ZCAL_WAIT_CNT_0_ZCAL_WAIT_CNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register EMC_ZCAL_MRW_CMD_0  // Configure ZQ Calibration
#define EMC_ZCAL_MRW_CMD_0                      _MK_ADDR_CONST(0x2e8)
#define EMC_ZCAL_MRW_CMD_0_SECURE                       0x0
#define EMC_ZCAL_MRW_CMD_0_WORD_COUNT                   0x1
#define EMC_ZCAL_MRW_CMD_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define EMC_ZCAL_MRW_CMD_0_RESET_MASK                   _MK_MASK_CONST(0x0)
#define EMC_ZCAL_MRW_CMD_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define EMC_ZCAL_MRW_CMD_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_ZCAL_MRW_CMD_0_READ_MASK                    _MK_MASK_CONST(0x0)
#define EMC_ZCAL_MRW_CMD_0_WRITE_MASK                   _MK_MASK_CONST(0xc0ff00ff)
// MRW OP field to be sent after ZCAL_REF_CNT
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_OP_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_OP_FIELD                      (_MK_MASK_CONST(0xff) << EMC_ZCAL_MRW_CMD_0_ZQ_MRW_OP_SHIFT)
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_OP_RANGE                      7:0
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_OP_WOFFSET                    0x0
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_OP_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_OP_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_OP_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_OP_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// MRW MA field to be sent after ZCAL_REF_CNT
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_MA_SHIFT                      _MK_SHIFT_CONST(16)
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_MA_FIELD                      (_MK_MASK_CONST(0xff) << EMC_ZCAL_MRW_CMD_0_ZQ_MRW_MA_SHIFT)
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_MA_RANGE                      23:16
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_MA_WOFFSET                    0x0
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_MA_DEFAULT                    _MK_MASK_CONST(0x0)
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_MA_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_MA_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_MA_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

// active-low chip-select, 0x0 applies command to both devices (will happen 1 at a time), 0x2 to for only dev0, 0x1 for dev1.
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_DEV_SELECTN_SHIFT                     _MK_SHIFT_CONST(30)
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_DEV_SELECTN_FIELD                     (_MK_MASK_CONST(0x3) << EMC_ZCAL_MRW_CMD_0_ZQ_MRW_DEV_SELECTN_SHIFT)
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_DEV_SELECTN_RANGE                     31:30
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_DEV_SELECTN_WOFFSET                   0x0
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_DEV_SELECTN_DEFAULT                   _MK_MASK_CONST(0x0)
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_DEV_SELECTN_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_DEV_SELECTN_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define EMC_ZCAL_MRW_CMD_0_ZQ_MRW_DEV_SELECTN_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


//
// REGISTER LIST
//
#define LIST_AREMC_REGS(_op_) \
_op_(EMC_INTSTATUS_0) \
_op_(EMC_INTMASK_0) \
_op_(EMC_DBG_0) \
_op_(EMC_CFG_0) \
_op_(EMC_ADR_CFG_0) \
_op_(EMC_ADR_CFG_1_0) \
_op_(EMC_REFCTRL_0) \
_op_(EMC_PIN_0) \
_op_(EMC_TIMING_CONTROL_0) \
_op_(EMC_RC_0) \
_op_(EMC_RFC_0) \
_op_(EMC_RAS_0) \
_op_(EMC_RP_0) \
_op_(EMC_R2W_0) \
_op_(EMC_W2R_0) \
_op_(EMC_R2P_0) \
_op_(EMC_W2P_0) \
_op_(EMC_RD_RCD_0) \
_op_(EMC_WR_RCD_0) \
_op_(EMC_RRD_0) \
_op_(EMC_REXT_0) \
_op_(EMC_WDV_0) \
_op_(EMC_QUSE_0) \
_op_(EMC_QRST_0) \
_op_(EMC_QSAFE_0) \
_op_(EMC_RDV_0) \
_op_(EMC_REFRESH_0) \
_op_(EMC_BURST_REFRESH_NUM_0) \
_op_(EMC_PDEX2WR_0) \
_op_(EMC_PDEX2RD_0) \
_op_(EMC_PCHG2PDEN_0) \
_op_(EMC_ACT2PDEN_0) \
_op_(EMC_AR2PDEN_0) \
_op_(EMC_RW2PDEN_0) \
_op_(EMC_TXSR_0) \
_op_(EMC_TCKE_0) \
_op_(EMC_TFAW_0) \
_op_(EMC_TRPAB_0) \
_op_(EMC_TCLKSTABLE_0) \
_op_(EMC_TCLKSTOP_0) \
_op_(EMC_TREFBW_0) \
_op_(EMC_QUSE_EXTRA_0) \
_op_(EMC_ODT_WRITE_0) \
_op_(EMC_ODT_READ_0) \
_op_(EMC_MRS_0) \
_op_(EMC_EMRS_0) \
_op_(EMC_REF_0) \
_op_(EMC_PRE_0) \
_op_(EMC_NOP_0) \
_op_(EMC_SELF_REF_0) \
_op_(EMC_DPD_0) \
_op_(EMC_MRW_0) \
_op_(EMC_MRR_0) \
_op_(EMC_CMDQ_0) \
_op_(EMC_FBIO_CFG1_0) \
_op_(EMC_FBIO_DQSIB_DLY_0) \
_op_(EMC_FBIO_DQSIB_DLY_MSB_0) \
_op_(EMC_FBIO_SPARE_0) \
_op_(EMC_FBIO_CFG5_0) \
_op_(EMC_FBIO_WRPTR_EQ_2_0) \
_op_(EMC_FBIO_QUSE_DLY_0) \
_op_(EMC_FBIO_QUSE_DLY_MSB_0) \
_op_(EMC_FBIO_CFG6_0) \
_op_(EMC_DQS_TRIMMER_RD0_0) \
_op_(EMC_DQS_TRIMMER_RD1_0) \
_op_(EMC_DQS_TRIMMER_RD2_0) \
_op_(EMC_DQS_TRIMMER_RD3_0) \
_op_(EMC_CLKEN_OVERRIDE_0) \
_op_(EMC_LL_ARB_CONFIG_0) \
_op_(EMC_T_MIN_CRITICAL_HP_0) \
_op_(EMC_T_MIN_CRITICAL_TIMEOUT_0) \
_op_(EMC_T_MIN_LOAD_0) \
_op_(EMC_T_MAX_CRITICAL_HP_0) \
_op_(EMC_T_MAX_CRITICAL_TIMEOUT_0) \
_op_(EMC_T_MAX_LOAD_0) \
_op_(EMC_STAT_CONTROL_0) \
_op_(EMC_STAT_STATUS_0) \
_op_(EMC_STAT_LLMC_ADDR_LOW_0) \
_op_(EMC_STAT_LLMC_ADDR_HIGH_0) \
_op_(EMC_STAT_LLMC_CLOCK_LIMIT_0) \
_op_(EMC_STAT_LLMC_CLOCKS_0) \
_op_(EMC_STAT_LLMC_CONTROL_0_0) \
_op_(EMC_STAT_LLMC_HIST_LIMIT_0_0) \
_op_(EMC_STAT_LLMC_COUNT_0_0) \
_op_(EMC_STAT_LLMC_HIST_0_0) \
_op_(EMC_STAT_PWR_CLOCK_LIMIT_0) \
_op_(EMC_STAT_PWR_CLOCKS_0) \
_op_(EMC_STAT_PWR_COUNT_0) \
_op_(EMC_STAT_DRAM_CLOCK_LIMIT_LO_0) \
_op_(EMC_STAT_DRAM_CLOCK_LIMIT_HI_0) \
_op_(EMC_STAT_DRAM_CLOCKS_LO_0) \
_op_(EMC_STAT_DRAM_CLOCKS_HI_0) \
_op_(EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_LO_0) \
_op_(EMC_STAT_DRAM_DEV0_ACTIVATE_CNT_HI_0) \
_op_(EMC_STAT_DRAM_DEV0_READ_CNT_LO_0) \
_op_(EMC_STAT_DRAM_DEV0_READ_CNT_HI_0) \
_op_(EMC_STAT_DRAM_DEV0_WRITE_CNT_LO_0) \
_op_(EMC_STAT_DRAM_DEV0_WRITE_CNT_HI_0) \
_op_(EMC_STAT_DRAM_DEV0_REF_CNT_LO_0) \
_op_(EMC_STAT_DRAM_DEV0_REF_CNT_HI_0) \
_op_(EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0) \
_op_(EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0) \
_op_(EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0) \
_op_(EMC_STAT_DRAM_DEV0_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0) \
_op_(EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_LO_0) \
_op_(EMC_STAT_DRAM_DEV0_CKE_EQ1_CLKS_HI_0) \
_op_(EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_LO_0) \
_op_(EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ1_HI_0) \
_op_(EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_LO_0) \
_op_(EMC_STAT_DRAM_DEV0_EXTCLKS_CKE_EQ0_HI_0) \
_op_(EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_LO_0) \
_op_(EMC_STAT_DRAM_DEV1_ACTIVATE_CNT_HI_0) \
_op_(EMC_STAT_DRAM_DEV1_READ_CNT_LO_0) \
_op_(EMC_STAT_DRAM_DEV1_READ_CNT_HI_0) \
_op_(EMC_STAT_DRAM_DEV1_WRITE_CNT_LO_0) \
_op_(EMC_STAT_DRAM_DEV1_WRITE_CNT_HI_0) \
_op_(EMC_STAT_DRAM_DEV1_REF_CNT_LO_0) \
_op_(EMC_STAT_DRAM_DEV1_REF_CNT_HI_0) \
_op_(EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_LO_0) \
_op_(EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ1_HI_0) \
_op_(EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_LO_0) \
_op_(EMC_STAT_DRAM_DEV1_CUMM_BANKS_ACTIVE_CKE_EQ0_HI_0) \
_op_(EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_LO_0) \
_op_(EMC_STAT_DRAM_DEV1_CKE_EQ1_CLKS_HI_0) \
_op_(EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_LO_0) \
_op_(EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ1_HI_0) \
_op_(EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_LO_0) \
_op_(EMC_STAT_DRAM_DEV1_EXTCLKS_CKE_EQ0_HI_0) \
_op_(EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_LO_0) \
_op_(EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ1_HI_0) \
_op_(EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_LO_0) \
_op_(EMC_STAT_DRAM_DEV0_NO_BANKS_ACTIVE_CKE_EQ0_HI_0) \
_op_(EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_LO_0) \
_op_(EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ1_HI_0) \
_op_(EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_LO_0) \
_op_(EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0) \
_op_(EMC_AUTO_CAL_CONFIG_0) \
_op_(EMC_AUTO_CAL_INTERVAL_0) \
_op_(EMC_AUTO_CAL_STATUS_0) \
_op_(EMC_REQ_CTRL_0) \
_op_(EMC_EMC_STATUS_0) \
_op_(EMC_CFG_2_0) \
_op_(EMC_CFG_DIG_DLL_0) \
_op_(EMC_DLL_XFORM_DQS_0) \
_op_(EMC_DLL_XFORM_QUSE_0) \
_op_(EMC_DIG_DLL_UPPER_STATUS_0) \
_op_(EMC_DIG_DLL_LOWER_STATUS_0) \
_op_(EMC_CFG_CLKTRIM_0_0) \
_op_(EMC_CFG_CLKTRIM_1_0) \
_op_(EMC_CFG_CLKTRIM_2_0) \
_op_(EMC_CTT_TERM_CTRL_0) \
_op_(EMC_ZCAL_REF_CNT_0) \
_op_(EMC_ZCAL_WAIT_CNT_0) \
_op_(EMC_ZCAL_MRW_CMD_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_EMC        0x00000000

//
// AREMC REGISTER BANKS
//

#define EMC0_FIRST_REG 0x0000 // EMC_INTSTATUS_0
#define EMC0_LAST_REG 0x0014 // EMC_ADR_CFG_1_0
#define EMC1_FIRST_REG 0x0020 // EMC_REFCTRL_0
#define EMC1_LAST_REG 0x00b4 // EMC_ODT_READ_0
#define EMC2_FIRST_REG 0x00cc // EMC_MRS_0
#define EMC2_LAST_REG 0x0114 // EMC_FBIO_CFG6_0
#define EMC3_FIRST_REG 0x0120 // EMC_DQS_TRIMMER_RD0_0
#define EMC3_LAST_REG 0x012c // EMC_DQS_TRIMMER_RD3_0
#define EMC4_FIRST_REG 0x0140 // EMC_CLKEN_OVERRIDE_0
#define EMC4_LAST_REG 0x0178 // EMC_STAT_LLMC_CONTROL_0_0
#define EMC5_FIRST_REG 0x0180 // EMC_STAT_LLMC_HIST_LIMIT_0_0
#define EMC5_LAST_REG 0x0180 // EMC_STAT_LLMC_HIST_LIMIT_0_0
#define EMC6_FIRST_REG 0x0188 // EMC_STAT_LLMC_COUNT_0_0
#define EMC6_LAST_REG 0x0188 // EMC_STAT_LLMC_COUNT_0_0
#define EMC7_FIRST_REG 0x0190 // EMC_STAT_LLMC_HIST_0_0
#define EMC7_LAST_REG 0x0190 // EMC_STAT_LLMC_HIST_0_0
#define EMC8_FIRST_REG 0x0198 // EMC_STAT_PWR_CLOCK_LIMIT_0
#define EMC8_LAST_REG 0x0260 // EMC_STAT_DRAM_DEV1_NO_BANKS_ACTIVE_CKE_EQ0_HI_0
#define EMC9_FIRST_REG 0x02a4 // EMC_AUTO_CAL_CONFIG_0
#define EMC9_LAST_REG 0x02e8 // EMC_ZCAL_MRW_CMD_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___AREMC_H_INC_
