/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARFIC_DIST_H_INC_
#define ___ARFIC_DIST_H_INC_

// Register FIC_DIST_DISTRIBUTOR_ENABLE_0  
#define FIC_DIST_DISTRIBUTOR_ENABLE_0                   _MK_ADDR_CONST(0x1000)
#define FIC_DIST_DISTRIBUTOR_ENABLE_0_SECURE                    0x0
#define FIC_DIST_DISTRIBUTOR_ENABLE_0_WORD_COUNT                        0x1
#define FIC_DIST_DISTRIBUTOR_ENABLE_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define FIC_DIST_DISTRIBUTOR_ENABLE_0_RESET_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_DISTRIBUTOR_ENABLE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define FIC_DIST_DISTRIBUTOR_ENABLE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define FIC_DIST_DISTRIBUTOR_ENABLE_0_READ_MASK                         _MK_MASK_CONST(0x1)
#define FIC_DIST_DISTRIBUTOR_ENABLE_0_WRITE_MASK                        _MK_MASK_CONST(0x1)
// Controls if the Distributor responds to changes in the
// status of its interrupt inputs, SPI or PPI
#define FIC_DIST_DISTRIBUTOR_ENABLE_0_INTERRUPT_IN_ENABLE_SHIFT                 _MK_SHIFT_CONST(0)
#define FIC_DIST_DISTRIBUTOR_ENABLE_0_INTERRUPT_IN_ENABLE_FIELD                 (_MK_MASK_CONST(0x1) << FIC_DIST_DISTRIBUTOR_ENABLE_0_INTERRUPT_IN_ENABLE_SHIFT)
#define FIC_DIST_DISTRIBUTOR_ENABLE_0_INTERRUPT_IN_ENABLE_RANGE                 0:0
#define FIC_DIST_DISTRIBUTOR_ENABLE_0_INTERRUPT_IN_ENABLE_WOFFSET                       0x0
#define FIC_DIST_DISTRIBUTOR_ENABLE_0_INTERRUPT_IN_ENABLE_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_DISTRIBUTOR_ENABLE_0_INTERRUPT_IN_ENABLE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define FIC_DIST_DISTRIBUTOR_ENABLE_0_INTERRUPT_IN_ENABLE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_DISTRIBUTOR_ENABLE_0_INTERRUPT_IN_ENABLE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register FIC_DIST_IC_TYPE_0  
#define FIC_DIST_IC_TYPE_0                      _MK_ADDR_CONST(0x1004)
#define FIC_DIST_IC_TYPE_0_SECURE                       0x0
#define FIC_DIST_IC_TYPE_0_WORD_COUNT                   0x1
#define FIC_DIST_IC_TYPE_0_RESET_VAL                    _MK_MASK_CONST(0x424)
#define FIC_DIST_IC_TYPE_0_RESET_MASK                   _MK_MASK_CONST(0xfcff)
#define FIC_DIST_IC_TYPE_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_IC_TYPE_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FIC_DIST_IC_TYPE_0_READ_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_IC_TYPE_0_WRITE_MASK                   _MK_MASK_CONST(0xfcff)
// Indicates the number of INTIDs provided
#define FIC_DIST_IC_TYPE_0_IT_LINES_NUMBER_SHIFT                        _MK_SHIFT_CONST(0)
#define FIC_DIST_IC_TYPE_0_IT_LINES_NUMBER_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_IC_TYPE_0_IT_LINES_NUMBER_SHIFT)
#define FIC_DIST_IC_TYPE_0_IT_LINES_NUMBER_RANGE                        4:0
#define FIC_DIST_IC_TYPE_0_IT_LINES_NUMBER_WOFFSET                      0x0
#define FIC_DIST_IC_TYPE_0_IT_LINES_NUMBER_DEFAULT                      _MK_MASK_CONST(0x4)
#define FIC_DIST_IC_TYPE_0_IT_LINES_NUMBER_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_IC_TYPE_0_IT_LINES_NUMBER_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_IC_TYPE_0_IT_LINES_NUMBER_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Indicates the number of CPUs in the system
#define FIC_DIST_IC_TYPE_0_CPU_NUMBER_SHIFT                     _MK_SHIFT_CONST(5)
#define FIC_DIST_IC_TYPE_0_CPU_NUMBER_FIELD                     (_MK_MASK_CONST(0x7) << FIC_DIST_IC_TYPE_0_CPU_NUMBER_SHIFT)
#define FIC_DIST_IC_TYPE_0_CPU_NUMBER_RANGE                     7:5
#define FIC_DIST_IC_TYPE_0_CPU_NUMBER_WOFFSET                   0x0
#define FIC_DIST_IC_TYPE_0_CPU_NUMBER_DEFAULT                   _MK_MASK_CONST(0x1)
#define FIC_DIST_IC_TYPE_0_CPU_NUMBER_DEFAULT_MASK                      _MK_MASK_CONST(0x7)
#define FIC_DIST_IC_TYPE_0_CPU_NUMBER_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_IC_TYPE_0_CPU_NUMBER_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

// Indicates the number of security domains in the system
#define FIC_DIST_IC_TYPE_0_DOMAINS_SHIFT                        _MK_SHIFT_CONST(10)
#define FIC_DIST_IC_TYPE_0_DOMAINS_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_IC_TYPE_0_DOMAINS_SHIFT)
#define FIC_DIST_IC_TYPE_0_DOMAINS_RANGE                        10:10
#define FIC_DIST_IC_TYPE_0_DOMAINS_WOFFSET                      0x0
#define FIC_DIST_IC_TYPE_0_DOMAINS_DEFAULT                      _MK_MASK_CONST(0x1)
#define FIC_DIST_IC_TYPE_0_DOMAINS_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_IC_TYPE_0_DOMAINS_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_IC_TYPE_0_DOMAINS_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

// Indicates the number of Lockable SPI
#define FIC_DIST_IC_TYPE_0_LSPI_SHIFT                   _MK_SHIFT_CONST(11)
#define FIC_DIST_IC_TYPE_0_LSPI_FIELD                   (_MK_MASK_CONST(0x1f) << FIC_DIST_IC_TYPE_0_LSPI_SHIFT)
#define FIC_DIST_IC_TYPE_0_LSPI_RANGE                   15:11
#define FIC_DIST_IC_TYPE_0_LSPI_WOFFSET                 0x0
#define FIC_DIST_IC_TYPE_0_LSPI_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_IC_TYPE_0_LSPI_DEFAULT_MASK                    _MK_MASK_CONST(0x1f)
#define FIC_DIST_IC_TYPE_0_LSPI_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_IC_TYPE_0_LSPI_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FIC_DIST_DISTRIBUTOR_IDENT_0  
#define FIC_DIST_DISTRIBUTOR_IDENT_0                    _MK_ADDR_CONST(0x1008)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_SECURE                     0x0
#define FIC_DIST_DISTRIBUTOR_IDENT_0_WORD_COUNT                         0x1
#define FIC_DIST_DISTRIBUTOR_IDENT_0_RESET_VAL                  _MK_MASK_CONST(0x100043b)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_RESET_MASK                         _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_READ_MASK                  _MK_MASK_CONST(0x0)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_WRITE_MASK                         _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTOR_SHIFT                  _MK_SHIFT_CONST(0)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTOR_FIELD                  (_MK_MASK_CONST(0xfff) << FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTOR_SHIFT)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTOR_RANGE                  11:0
#define FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTOR_WOFFSET                        0x0
#define FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTOR_DEFAULT                        _MK_MASK_CONST(0x43b)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTOR_DEFAULT_MASK                   _MK_MASK_CONST(0xfff)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTOR_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTOR_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_DISTRIBUTOR_IDENT_0_REVISION_NUMBER_SHIFT                      _MK_SHIFT_CONST(12)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_REVISION_NUMBER_FIELD                      (_MK_MASK_CONST(0xfff) << FIC_DIST_DISTRIBUTOR_IDENT_0_REVISION_NUMBER_SHIFT)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_REVISION_NUMBER_RANGE                      23:12
#define FIC_DIST_DISTRIBUTOR_IDENT_0_REVISION_NUMBER_WOFFSET                    0x0
#define FIC_DIST_DISTRIBUTOR_IDENT_0_REVISION_NUMBER_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_REVISION_NUMBER_DEFAULT_MASK                       _MK_MASK_CONST(0xfff)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_REVISION_NUMBER_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_REVISION_NUMBER_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTATION_DEFINED_SHIFT                       _MK_SHIFT_CONST(24)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTATION_DEFINED_FIELD                       (_MK_MASK_CONST(0xff) << FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTATION_DEFINED_SHIFT)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTATION_DEFINED_RANGE                       31:24
#define FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTATION_DEFINED_WOFFSET                     0x0
#define FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTATION_DEFINED_DEFAULT                     _MK_MASK_CONST(0x1)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTATION_DEFINED_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTATION_DEFINED_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_DISTRIBUTOR_IDENT_0_IMPLEMENTATION_DEFINED_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Reserved address 4108 [0x100c] 

// Reserved address 4112 [0x1010] 

// Reserved address 4116 [0x1014] 

// Reserved address 4120 [0x1018] 

// Reserved address 4124 [0x101c] 

// Reserved address 4128 [0x1020] 

// Reserved address 4132 [0x1024] 

// Reserved address 4136 [0x1028] 

// Reserved address 4140 [0x102c] 

// Reserved address 4144 [0x1030] 

// Reserved address 4148 [0x1034] 

// Reserved address 4152 [0x1038] 

// Reserved address 4156 [0x103c] 

// Reserved address 4160 [0x1040] 

// Reserved address 4164 [0x1044] 

// Reserved address 4168 [0x1048] 

// Reserved address 4172 [0x104c] 

// Reserved address 4176 [0x1050] 

// Reserved address 4180 [0x1054] 

// Reserved address 4184 [0x1058] 

// Reserved address 4188 [0x105c] 

// Reserved address 4192 [0x1060] 

// Reserved address 4196 [0x1064] 

// Reserved address 4200 [0x1068] 

// Reserved address 4204 [0x106c] 

// Reserved address 4208 [0x1070] 

// Reserved address 4212 [0x1074] 

// Reserved address 4216 [0x1078] 

// Reserved address 4220 [0x107c] 

// Register FIC_DIST_INTERRUPT_SECURITY_0_0  
#define FIC_DIST_INTERRUPT_SECURITY_0_0                 _MK_ADDR_CONST(0x1080)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_SECURE                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_WORD_COUNT                      0x1
#define FIC_DIST_INTERRUPT_SECURITY_0_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_RESET_MASK                      _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_READ_MASK                       _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_WRITE_MASK                      _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_0_SHIFT                      _MK_SHIFT_CONST(0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_0_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_0_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_0_RANGE                      0:0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_0_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_1_SHIFT                      _MK_SHIFT_CONST(1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_1_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_1_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_1_RANGE                      1:1
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_1_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_1_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_2_SHIFT                      _MK_SHIFT_CONST(2)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_2_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_2_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_2_RANGE                      2:2
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_2_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_2_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_3_SHIFT                      _MK_SHIFT_CONST(3)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_3_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_3_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_3_RANGE                      3:3
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_3_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_3_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_4_SHIFT                      _MK_SHIFT_CONST(4)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_4_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_4_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_4_RANGE                      4:4
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_4_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_4_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_4_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_5_SHIFT                      _MK_SHIFT_CONST(5)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_5_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_5_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_5_RANGE                      5:5
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_5_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_5_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_5_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_6_SHIFT                      _MK_SHIFT_CONST(6)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_6_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_6_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_6_RANGE                      6:6
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_6_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_6_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_6_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_7_SHIFT                      _MK_SHIFT_CONST(7)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_7_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_7_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_7_RANGE                      7:7
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_7_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_7_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_7_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_8_SHIFT                      _MK_SHIFT_CONST(8)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_8_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_8_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_8_RANGE                      8:8
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_8_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_8_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_8_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_8_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_8_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_9_SHIFT                      _MK_SHIFT_CONST(9)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_9_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_9_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_9_RANGE                      9:9
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_9_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_9_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_9_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_9_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_9_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_10_SHIFT                     _MK_SHIFT_CONST(10)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_10_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_10_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_10_RANGE                     10:10
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_10_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_10_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_10_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_10_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_10_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_11_SHIFT                     _MK_SHIFT_CONST(11)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_11_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_11_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_11_RANGE                     11:11
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_11_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_11_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_11_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_11_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_11_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_12_SHIFT                     _MK_SHIFT_CONST(12)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_12_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_12_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_12_RANGE                     12:12
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_12_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_12_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_12_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_12_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_12_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_13_SHIFT                     _MK_SHIFT_CONST(13)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_13_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_13_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_13_RANGE                     13:13
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_13_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_13_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_13_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_13_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_13_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_14_SHIFT                     _MK_SHIFT_CONST(14)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_14_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_14_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_14_RANGE                     14:14
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_14_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_14_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_14_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_14_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_14_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_15_SHIFT                     _MK_SHIFT_CONST(15)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_15_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_15_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_15_RANGE                     15:15
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_15_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_15_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_15_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_15_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_STI_15_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_4_SHIFT                      _MK_SHIFT_CONST(27)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_4_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_4_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_4_RANGE                      27:27
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_4_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_4_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_4_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_0_SHIFT                      _MK_SHIFT_CONST(28)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_0_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_0_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_0_RANGE                      28:28
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_0_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_1_SHIFT                      _MK_SHIFT_CONST(29)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_1_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_1_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_1_RANGE                      29:29
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_1_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_1_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_2_SHIFT                      _MK_SHIFT_CONST(30)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_2_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_2_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_2_RANGE                      30:30
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_2_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_2_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_3_SHIFT                      _MK_SHIFT_CONST(31)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_3_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_3_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_3_RANGE                      31:31
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_3_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_3_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_0_0_INT_NS_PPI_3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FIC_DIST_INTERRUPT_SECURITY_1_0  
#define FIC_DIST_INTERRUPT_SECURITY_1_0                 _MK_ADDR_CONST(0x1084)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_SECURE                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_WORD_COUNT                      0x1
#define FIC_DIST_INTERRUPT_SECURITY_1_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_0_SHIFT                      _MK_SHIFT_CONST(0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_0_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_0_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_0_RANGE                      0:0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_0_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_1_SHIFT                      _MK_SHIFT_CONST(1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_1_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_1_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_1_RANGE                      1:1
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_1_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_1_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_2_SHIFT                      _MK_SHIFT_CONST(2)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_2_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_2_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_2_RANGE                      2:2
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_2_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_2_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_3_SHIFT                      _MK_SHIFT_CONST(3)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_3_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_3_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_3_RANGE                      3:3
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_3_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_3_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_4_SHIFT                      _MK_SHIFT_CONST(4)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_4_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_4_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_4_RANGE                      4:4
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_4_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_4_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_4_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_5_SHIFT                      _MK_SHIFT_CONST(5)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_5_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_5_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_5_RANGE                      5:5
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_5_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_5_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_5_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_6_SHIFT                      _MK_SHIFT_CONST(6)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_6_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_6_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_6_RANGE                      6:6
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_6_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_6_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_6_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_7_SHIFT                      _MK_SHIFT_CONST(7)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_7_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_7_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_7_RANGE                      7:7
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_7_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_7_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_7_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_8_SHIFT                      _MK_SHIFT_CONST(8)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_8_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_8_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_8_RANGE                      8:8
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_8_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_8_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_8_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_8_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_8_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_9_SHIFT                      _MK_SHIFT_CONST(9)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_9_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_9_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_9_RANGE                      9:9
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_9_WOFFSET                    0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_9_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_9_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_9_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_9_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_10_SHIFT                     _MK_SHIFT_CONST(10)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_10_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_10_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_10_RANGE                     10:10
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_10_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_10_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_10_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_10_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_10_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_11_SHIFT                     _MK_SHIFT_CONST(11)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_11_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_11_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_11_RANGE                     11:11
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_11_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_11_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_11_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_11_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_11_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_12_SHIFT                     _MK_SHIFT_CONST(12)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_12_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_12_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_12_RANGE                     12:12
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_12_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_12_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_12_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_12_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_12_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_13_SHIFT                     _MK_SHIFT_CONST(13)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_13_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_13_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_13_RANGE                     13:13
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_13_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_13_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_13_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_13_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_13_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_14_SHIFT                     _MK_SHIFT_CONST(14)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_14_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_14_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_14_RANGE                     14:14
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_14_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_14_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_14_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_14_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_14_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_15_SHIFT                     _MK_SHIFT_CONST(15)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_15_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_15_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_15_RANGE                     15:15
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_15_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_15_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_15_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_15_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_15_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_16_SHIFT                     _MK_SHIFT_CONST(16)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_16_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_16_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_16_RANGE                     16:16
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_16_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_16_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_16_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_16_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_16_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_17_SHIFT                     _MK_SHIFT_CONST(17)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_17_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_17_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_17_RANGE                     17:17
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_17_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_17_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_17_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_17_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_17_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_18_SHIFT                     _MK_SHIFT_CONST(18)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_18_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_18_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_18_RANGE                     18:18
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_18_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_18_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_18_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_18_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_18_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_19_SHIFT                     _MK_SHIFT_CONST(19)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_19_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_19_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_19_RANGE                     19:19
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_19_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_19_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_19_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_19_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_19_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_20_SHIFT                     _MK_SHIFT_CONST(20)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_20_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_20_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_20_RANGE                     20:20
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_20_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_20_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_20_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_20_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_20_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_21_SHIFT                     _MK_SHIFT_CONST(21)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_21_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_21_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_21_RANGE                     21:21
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_21_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_21_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_21_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_21_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_21_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_22_SHIFT                     _MK_SHIFT_CONST(22)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_22_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_22_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_22_RANGE                     22:22
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_22_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_22_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_22_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_22_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_22_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_23_SHIFT                     _MK_SHIFT_CONST(23)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_23_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_23_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_23_RANGE                     23:23
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_23_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_23_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_23_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_23_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_23_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_24_SHIFT                     _MK_SHIFT_CONST(24)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_24_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_24_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_24_RANGE                     24:24
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_24_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_24_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_24_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_24_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_24_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_25_SHIFT                     _MK_SHIFT_CONST(25)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_25_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_25_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_25_RANGE                     25:25
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_25_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_25_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_25_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_25_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_25_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_26_SHIFT                     _MK_SHIFT_CONST(26)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_26_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_26_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_26_RANGE                     26:26
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_26_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_26_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_26_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_26_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_26_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_27_SHIFT                     _MK_SHIFT_CONST(27)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_27_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_27_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_27_RANGE                     27:27
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_27_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_27_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_27_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_27_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_27_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_28_SHIFT                     _MK_SHIFT_CONST(28)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_28_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_28_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_28_RANGE                     28:28
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_28_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_28_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_28_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_28_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_28_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_29_SHIFT                     _MK_SHIFT_CONST(29)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_29_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_29_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_29_RANGE                     29:29
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_29_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_29_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_29_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_29_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_29_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_30_SHIFT                     _MK_SHIFT_CONST(30)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_30_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_30_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_30_RANGE                     30:30
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_30_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_30_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_30_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_30_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_30_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_31_SHIFT                     _MK_SHIFT_CONST(31)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_31_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_31_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_31_RANGE                     31:31
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_31_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_31_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_31_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_31_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_1_0_INT_NS_SPI_31_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FIC_DIST_INTERRUPT_SECURITY_2_0  
#define FIC_DIST_INTERRUPT_SECURITY_2_0                 _MK_ADDR_CONST(0x1088)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_SECURE                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_WORD_COUNT                      0x1
#define FIC_DIST_INTERRUPT_SECURITY_2_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_32_SHIFT                     _MK_SHIFT_CONST(0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_32_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_32_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_32_RANGE                     0:0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_32_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_32_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_32_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_32_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_32_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_33_SHIFT                     _MK_SHIFT_CONST(1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_33_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_33_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_33_RANGE                     1:1
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_33_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_33_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_33_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_33_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_33_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_34_SHIFT                     _MK_SHIFT_CONST(2)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_34_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_34_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_34_RANGE                     2:2
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_34_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_34_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_34_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_34_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_34_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_35_SHIFT                     _MK_SHIFT_CONST(3)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_35_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_35_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_35_RANGE                     3:3
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_35_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_35_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_35_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_35_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_35_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_36_SHIFT                     _MK_SHIFT_CONST(4)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_36_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_36_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_36_RANGE                     4:4
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_36_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_36_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_36_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_36_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_36_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_37_SHIFT                     _MK_SHIFT_CONST(5)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_37_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_37_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_37_RANGE                     5:5
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_37_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_37_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_37_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_37_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_37_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_38_SHIFT                     _MK_SHIFT_CONST(6)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_38_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_38_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_38_RANGE                     6:6
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_38_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_38_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_38_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_38_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_38_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_39_SHIFT                     _MK_SHIFT_CONST(7)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_39_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_39_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_39_RANGE                     7:7
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_39_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_39_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_39_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_39_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_39_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_40_SHIFT                     _MK_SHIFT_CONST(8)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_40_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_40_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_40_RANGE                     8:8
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_40_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_40_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_40_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_40_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_40_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_41_SHIFT                     _MK_SHIFT_CONST(9)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_41_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_41_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_41_RANGE                     9:9
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_41_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_41_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_41_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_41_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_41_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_42_SHIFT                     _MK_SHIFT_CONST(10)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_42_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_42_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_42_RANGE                     10:10
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_42_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_42_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_42_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_42_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_42_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_43_SHIFT                     _MK_SHIFT_CONST(11)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_43_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_43_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_43_RANGE                     11:11
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_43_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_43_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_43_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_43_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_43_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_44_SHIFT                     _MK_SHIFT_CONST(12)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_44_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_44_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_44_RANGE                     12:12
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_44_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_44_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_44_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_44_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_44_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_45_SHIFT                     _MK_SHIFT_CONST(13)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_45_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_45_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_45_RANGE                     13:13
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_45_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_45_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_45_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_45_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_45_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_46_SHIFT                     _MK_SHIFT_CONST(14)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_46_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_46_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_46_RANGE                     14:14
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_46_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_46_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_46_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_46_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_46_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_47_SHIFT                     _MK_SHIFT_CONST(15)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_47_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_47_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_47_RANGE                     15:15
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_47_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_47_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_47_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_47_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_47_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_48_SHIFT                     _MK_SHIFT_CONST(16)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_48_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_48_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_48_RANGE                     16:16
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_48_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_48_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_48_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_48_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_48_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_49_SHIFT                     _MK_SHIFT_CONST(17)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_49_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_49_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_49_RANGE                     17:17
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_49_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_49_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_49_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_49_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_49_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_50_SHIFT                     _MK_SHIFT_CONST(18)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_50_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_50_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_50_RANGE                     18:18
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_50_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_50_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_50_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_50_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_50_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_51_SHIFT                     _MK_SHIFT_CONST(19)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_51_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_51_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_51_RANGE                     19:19
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_51_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_51_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_51_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_51_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_51_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_52_SHIFT                     _MK_SHIFT_CONST(20)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_52_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_52_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_52_RANGE                     20:20
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_52_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_52_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_52_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_52_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_52_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_53_SHIFT                     _MK_SHIFT_CONST(21)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_53_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_53_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_53_RANGE                     21:21
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_53_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_53_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_53_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_53_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_53_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_54_SHIFT                     _MK_SHIFT_CONST(22)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_54_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_54_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_54_RANGE                     22:22
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_54_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_54_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_54_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_54_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_54_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_55_SHIFT                     _MK_SHIFT_CONST(23)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_55_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_55_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_55_RANGE                     23:23
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_55_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_55_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_55_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_55_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_55_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_56_SHIFT                     _MK_SHIFT_CONST(24)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_56_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_56_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_56_RANGE                     24:24
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_56_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_56_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_56_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_56_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_56_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_57_SHIFT                     _MK_SHIFT_CONST(25)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_57_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_57_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_57_RANGE                     25:25
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_57_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_57_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_57_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_57_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_57_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_58_SHIFT                     _MK_SHIFT_CONST(26)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_58_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_58_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_58_RANGE                     26:26
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_58_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_58_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_58_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_58_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_58_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_59_SHIFT                     _MK_SHIFT_CONST(27)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_59_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_59_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_59_RANGE                     27:27
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_59_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_59_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_59_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_59_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_59_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_60_SHIFT                     _MK_SHIFT_CONST(28)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_60_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_60_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_60_RANGE                     28:28
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_60_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_60_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_60_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_60_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_60_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_61_SHIFT                     _MK_SHIFT_CONST(29)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_61_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_61_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_61_RANGE                     29:29
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_61_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_61_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_61_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_61_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_61_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_62_SHIFT                     _MK_SHIFT_CONST(30)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_62_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_62_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_62_RANGE                     30:30
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_62_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_62_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_62_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_62_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_62_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_63_SHIFT                     _MK_SHIFT_CONST(31)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_63_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_63_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_63_RANGE                     31:31
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_63_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_63_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_63_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_63_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_2_0_INT_NS_SPI_63_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FIC_DIST_INTERRUPT_SECURITY_3_0  
#define FIC_DIST_INTERRUPT_SECURITY_3_0                 _MK_ADDR_CONST(0x108c)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_SECURE                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_WORD_COUNT                      0x1
#define FIC_DIST_INTERRUPT_SECURITY_3_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_64_SHIFT                     _MK_SHIFT_CONST(0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_64_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_64_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_64_RANGE                     0:0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_64_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_64_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_64_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_64_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_64_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_65_SHIFT                     _MK_SHIFT_CONST(1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_65_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_65_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_65_RANGE                     1:1
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_65_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_65_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_65_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_65_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_65_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_66_SHIFT                     _MK_SHIFT_CONST(2)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_66_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_66_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_66_RANGE                     2:2
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_66_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_66_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_66_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_66_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_66_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_67_SHIFT                     _MK_SHIFT_CONST(3)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_67_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_67_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_67_RANGE                     3:3
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_67_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_67_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_67_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_67_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_67_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_68_SHIFT                     _MK_SHIFT_CONST(4)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_68_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_68_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_68_RANGE                     4:4
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_68_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_68_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_68_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_68_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_68_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_69_SHIFT                     _MK_SHIFT_CONST(5)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_69_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_69_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_69_RANGE                     5:5
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_69_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_69_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_69_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_69_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_69_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_70_SHIFT                     _MK_SHIFT_CONST(6)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_70_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_70_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_70_RANGE                     6:6
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_70_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_70_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_70_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_70_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_70_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_71_SHIFT                     _MK_SHIFT_CONST(7)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_71_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_71_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_71_RANGE                     7:7
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_71_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_71_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_71_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_71_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_71_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_72_SHIFT                     _MK_SHIFT_CONST(8)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_72_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_72_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_72_RANGE                     8:8
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_72_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_72_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_72_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_72_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_72_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_73_SHIFT                     _MK_SHIFT_CONST(9)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_73_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_73_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_73_RANGE                     9:9
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_73_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_73_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_73_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_73_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_73_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_74_SHIFT                     _MK_SHIFT_CONST(10)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_74_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_74_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_74_RANGE                     10:10
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_74_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_74_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_74_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_74_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_74_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_75_SHIFT                     _MK_SHIFT_CONST(11)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_75_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_75_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_75_RANGE                     11:11
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_75_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_75_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_75_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_75_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_75_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_76_SHIFT                     _MK_SHIFT_CONST(12)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_76_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_76_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_76_RANGE                     12:12
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_76_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_76_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_76_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_76_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_76_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_77_SHIFT                     _MK_SHIFT_CONST(13)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_77_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_77_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_77_RANGE                     13:13
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_77_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_77_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_77_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_77_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_77_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_78_SHIFT                     _MK_SHIFT_CONST(14)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_78_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_78_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_78_RANGE                     14:14
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_78_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_78_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_78_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_78_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_78_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_79_SHIFT                     _MK_SHIFT_CONST(15)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_79_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_79_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_79_RANGE                     15:15
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_79_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_79_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_79_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_79_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_79_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_80_SHIFT                     _MK_SHIFT_CONST(16)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_80_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_80_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_80_RANGE                     16:16
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_80_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_80_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_80_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_80_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_80_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_81_SHIFT                     _MK_SHIFT_CONST(17)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_81_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_81_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_81_RANGE                     17:17
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_81_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_81_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_81_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_81_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_81_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_82_SHIFT                     _MK_SHIFT_CONST(18)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_82_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_82_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_82_RANGE                     18:18
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_82_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_82_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_82_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_82_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_82_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_83_SHIFT                     _MK_SHIFT_CONST(19)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_83_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_83_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_83_RANGE                     19:19
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_83_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_83_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_83_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_83_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_83_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_84_SHIFT                     _MK_SHIFT_CONST(20)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_84_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_84_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_84_RANGE                     20:20
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_84_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_84_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_84_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_84_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_84_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_85_SHIFT                     _MK_SHIFT_CONST(21)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_85_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_85_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_85_RANGE                     21:21
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_85_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_85_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_85_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_85_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_85_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_86_SHIFT                     _MK_SHIFT_CONST(22)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_86_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_86_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_86_RANGE                     22:22
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_86_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_86_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_86_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_86_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_86_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_87_SHIFT                     _MK_SHIFT_CONST(23)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_87_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_87_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_87_RANGE                     23:23
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_87_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_87_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_87_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_87_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_87_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_88_SHIFT                     _MK_SHIFT_CONST(24)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_88_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_88_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_88_RANGE                     24:24
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_88_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_88_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_88_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_88_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_88_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_89_SHIFT                     _MK_SHIFT_CONST(25)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_89_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_89_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_89_RANGE                     25:25
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_89_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_89_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_89_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_89_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_89_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_90_SHIFT                     _MK_SHIFT_CONST(26)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_90_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_90_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_90_RANGE                     26:26
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_90_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_90_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_90_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_90_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_90_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_91_SHIFT                     _MK_SHIFT_CONST(27)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_91_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_91_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_91_RANGE                     27:27
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_91_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_91_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_91_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_91_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_91_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_92_SHIFT                     _MK_SHIFT_CONST(28)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_92_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_92_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_92_RANGE                     28:28
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_92_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_92_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_92_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_92_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_92_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_93_SHIFT                     _MK_SHIFT_CONST(29)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_93_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_93_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_93_RANGE                     29:29
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_93_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_93_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_93_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_93_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_93_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_94_SHIFT                     _MK_SHIFT_CONST(30)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_94_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_94_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_94_RANGE                     30:30
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_94_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_94_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_94_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_94_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_94_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_95_SHIFT                     _MK_SHIFT_CONST(31)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_95_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_95_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_95_RANGE                     31:31
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_95_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_95_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_95_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_95_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_3_0_INT_NS_SPI_95_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FIC_DIST_INTERRUPT_SECURITY_4_0  
#define FIC_DIST_INTERRUPT_SECURITY_4_0                 _MK_ADDR_CONST(0x1090)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_SECURE                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_WORD_COUNT                      0x1
#define FIC_DIST_INTERRUPT_SECURITY_4_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_96_SHIFT                     _MK_SHIFT_CONST(0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_96_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_96_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_96_RANGE                     0:0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_96_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_96_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_96_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_96_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_96_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_97_SHIFT                     _MK_SHIFT_CONST(1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_97_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_97_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_97_RANGE                     1:1
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_97_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_97_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_97_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_97_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_97_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_98_SHIFT                     _MK_SHIFT_CONST(2)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_98_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_98_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_98_RANGE                     2:2
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_98_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_98_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_98_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_98_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_98_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_99_SHIFT                     _MK_SHIFT_CONST(3)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_99_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_99_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_99_RANGE                     3:3
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_99_WOFFSET                   0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_99_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_99_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_99_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_99_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_100_SHIFT                    _MK_SHIFT_CONST(4)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_100_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_100_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_100_RANGE                    4:4
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_100_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_100_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_100_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_100_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_100_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_101_SHIFT                    _MK_SHIFT_CONST(5)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_101_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_101_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_101_RANGE                    5:5
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_101_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_101_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_101_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_101_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_101_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_102_SHIFT                    _MK_SHIFT_CONST(6)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_102_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_102_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_102_RANGE                    6:6
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_102_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_102_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_102_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_102_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_102_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_103_SHIFT                    _MK_SHIFT_CONST(7)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_103_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_103_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_103_RANGE                    7:7
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_103_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_103_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_103_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_103_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_103_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_104_SHIFT                    _MK_SHIFT_CONST(8)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_104_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_104_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_104_RANGE                    8:8
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_104_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_104_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_104_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_104_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_104_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_105_SHIFT                    _MK_SHIFT_CONST(9)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_105_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_105_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_105_RANGE                    9:9
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_105_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_105_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_105_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_105_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_105_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_106_SHIFT                    _MK_SHIFT_CONST(10)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_106_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_106_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_106_RANGE                    10:10
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_106_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_106_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_106_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_106_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_106_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_107_SHIFT                    _MK_SHIFT_CONST(11)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_107_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_107_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_107_RANGE                    11:11
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_107_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_107_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_107_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_107_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_107_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_108_SHIFT                    _MK_SHIFT_CONST(12)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_108_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_108_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_108_RANGE                    12:12
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_108_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_108_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_108_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_108_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_108_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_109_SHIFT                    _MK_SHIFT_CONST(13)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_109_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_109_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_109_RANGE                    13:13
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_109_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_109_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_109_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_109_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_109_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_110_SHIFT                    _MK_SHIFT_CONST(14)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_110_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_110_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_110_RANGE                    14:14
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_110_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_110_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_110_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_110_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_110_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_111_SHIFT                    _MK_SHIFT_CONST(15)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_111_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_111_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_111_RANGE                    15:15
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_111_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_111_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_111_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_111_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_111_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_112_SHIFT                    _MK_SHIFT_CONST(16)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_112_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_112_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_112_RANGE                    16:16
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_112_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_112_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_112_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_112_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_112_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_113_SHIFT                    _MK_SHIFT_CONST(17)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_113_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_113_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_113_RANGE                    17:17
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_113_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_113_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_113_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_113_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_113_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_114_SHIFT                    _MK_SHIFT_CONST(18)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_114_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_114_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_114_RANGE                    18:18
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_114_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_114_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_114_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_114_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_114_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_115_SHIFT                    _MK_SHIFT_CONST(19)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_115_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_115_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_115_RANGE                    19:19
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_115_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_115_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_115_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_115_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_115_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_116_SHIFT                    _MK_SHIFT_CONST(20)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_116_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_116_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_116_RANGE                    20:20
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_116_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_116_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_116_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_116_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_116_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_117_SHIFT                    _MK_SHIFT_CONST(21)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_117_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_117_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_117_RANGE                    21:21
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_117_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_117_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_117_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_117_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_117_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_118_SHIFT                    _MK_SHIFT_CONST(22)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_118_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_118_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_118_RANGE                    22:22
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_118_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_118_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_118_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_118_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_118_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_119_SHIFT                    _MK_SHIFT_CONST(23)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_119_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_119_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_119_RANGE                    23:23
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_119_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_119_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_119_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_119_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_119_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_120_SHIFT                    _MK_SHIFT_CONST(24)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_120_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_120_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_120_RANGE                    24:24
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_120_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_120_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_120_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_120_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_120_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_121_SHIFT                    _MK_SHIFT_CONST(25)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_121_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_121_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_121_RANGE                    25:25
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_121_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_121_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_121_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_121_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_121_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_122_SHIFT                    _MK_SHIFT_CONST(26)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_122_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_122_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_122_RANGE                    26:26
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_122_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_122_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_122_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_122_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_122_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_123_SHIFT                    _MK_SHIFT_CONST(27)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_123_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_123_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_123_RANGE                    27:27
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_123_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_123_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_123_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_123_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_123_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_124_SHIFT                    _MK_SHIFT_CONST(28)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_124_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_124_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_124_RANGE                    28:28
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_124_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_124_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_124_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_124_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_124_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_125_SHIFT                    _MK_SHIFT_CONST(29)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_125_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_125_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_125_RANGE                    29:29
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_125_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_125_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_125_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_125_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_125_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_126_SHIFT                    _MK_SHIFT_CONST(30)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_126_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_126_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_126_RANGE                    30:30
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_126_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_126_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_126_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_126_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_126_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_127_SHIFT                    _MK_SHIFT_CONST(31)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_127_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_127_SHIFT)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_127_RANGE                    31:31
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_127_WOFFSET                  0x0
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_127_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_127_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_127_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_INTERRUPT_SECURITY_4_0_INT_NS_SPI_127_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Reserved address 4244 [0x1094] 

// Reserved address 4248 [0x1098] 

// Reserved address 4252 [0x109c] 

// Reserved address 4256 [0x10a0] 

// Reserved address 4260 [0x10a4] 

// Reserved address 4264 [0x10a8] 

// Reserved address 4268 [0x10ac] 

// Reserved address 4272 [0x10b0] 

// Reserved address 4276 [0x10b4] 

// Reserved address 4280 [0x10b8] 

// Reserved address 4284 [0x10bc] 

// Reserved address 4288 [0x10c0] 

// Reserved address 4292 [0x10c4] 

// Reserved address 4296 [0x10c8] 

// Reserved address 4300 [0x10cc] 

// Reserved address 4304 [0x10d0] 

// Reserved address 4308 [0x10d4] 

// Reserved address 4312 [0x10d8] 

// Reserved address 4316 [0x10dc] 

// Reserved address 4320 [0x10e0] 

// Reserved address 4324 [0x10e4] 

// Reserved address 4328 [0x10e8] 

// Reserved address 4332 [0x10ec] 

// Reserved address 4336 [0x10f0] 

// Reserved address 4340 [0x10f4] 

// Reserved address 4344 [0x10f8] 

// Reserved address 4348 [0x10fc] 

// Register FIC_DIST_ENABLE_SET_0_0  
#define FIC_DIST_ENABLE_SET_0_0                 _MK_ADDR_CONST(0x1100)
#define FIC_DIST_ENABLE_SET_0_0_SECURE                  0x0
#define FIC_DIST_ENABLE_SET_0_0_WORD_COUNT                      0x1
#define FIC_DIST_ENABLE_SET_0_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_RESET_MASK                      _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_ENABLE_SET_0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_READ_MASK                       _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_ENABLE_SET_0_0_WRITE_MASK                      _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_0_SHIFT                      _MK_SHIFT_CONST(0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_0_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_0_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_0_RANGE                      0:0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_0_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_1_SHIFT                      _MK_SHIFT_CONST(1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_1_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_1_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_1_RANGE                      1:1
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_1_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_1_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_2_SHIFT                      _MK_SHIFT_CONST(2)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_2_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_2_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_2_RANGE                      2:2
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_2_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_2_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_3_SHIFT                      _MK_SHIFT_CONST(3)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_3_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_3_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_3_RANGE                      3:3
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_3_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_3_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_4_SHIFT                      _MK_SHIFT_CONST(4)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_4_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_4_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_4_RANGE                      4:4
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_4_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_4_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_4_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_5_SHIFT                      _MK_SHIFT_CONST(5)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_5_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_5_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_5_RANGE                      5:5
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_5_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_5_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_5_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_6_SHIFT                      _MK_SHIFT_CONST(6)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_6_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_6_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_6_RANGE                      6:6
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_6_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_6_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_6_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_7_SHIFT                      _MK_SHIFT_CONST(7)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_7_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_7_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_7_RANGE                      7:7
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_7_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_7_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_7_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_8_SHIFT                      _MK_SHIFT_CONST(8)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_8_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_8_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_8_RANGE                      8:8
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_8_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_8_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_8_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_8_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_8_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_9_SHIFT                      _MK_SHIFT_CONST(9)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_9_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_9_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_9_RANGE                      9:9
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_9_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_9_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_9_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_9_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_9_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_10_SHIFT                     _MK_SHIFT_CONST(10)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_10_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_10_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_10_RANGE                     10:10
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_10_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_10_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_10_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_10_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_10_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_11_SHIFT                     _MK_SHIFT_CONST(11)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_11_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_11_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_11_RANGE                     11:11
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_11_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_11_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_11_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_11_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_11_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_12_SHIFT                     _MK_SHIFT_CONST(12)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_12_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_12_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_12_RANGE                     12:12
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_12_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_12_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_12_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_12_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_12_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_13_SHIFT                     _MK_SHIFT_CONST(13)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_13_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_13_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_13_RANGE                     13:13
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_13_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_13_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_13_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_13_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_13_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_14_SHIFT                     _MK_SHIFT_CONST(14)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_14_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_14_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_14_RANGE                     14:14
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_14_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_14_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_14_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_14_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_14_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_15_SHIFT                     _MK_SHIFT_CONST(15)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_15_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_15_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_15_RANGE                     15:15
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_15_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_15_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_15_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_15_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_STI_15_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_4_SHIFT                      _MK_SHIFT_CONST(27)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_4_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_4_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_4_RANGE                      27:27
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_4_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_4_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_4_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_0_SHIFT                      _MK_SHIFT_CONST(28)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_0_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_0_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_0_RANGE                      28:28
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_0_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_1_SHIFT                      _MK_SHIFT_CONST(29)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_1_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_1_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_1_RANGE                      29:29
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_1_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_1_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_2_SHIFT                      _MK_SHIFT_CONST(30)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_2_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_2_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_2_RANGE                      30:30
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_2_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_2_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_3_SHIFT                      _MK_SHIFT_CONST(31)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_3_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_3_SHIFT)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_3_RANGE                      31:31
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_3_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_3_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_0_0_EN_SET_PPI_3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FIC_DIST_ENABLE_SET_1_0  
#define FIC_DIST_ENABLE_SET_1_0                 _MK_ADDR_CONST(0x1104)
#define FIC_DIST_ENABLE_SET_1_0_SECURE                  0x0
#define FIC_DIST_ENABLE_SET_1_0_WORD_COUNT                      0x1
#define FIC_DIST_ENABLE_SET_1_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_SET_1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_SET_1_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_0_SHIFT                      _MK_SHIFT_CONST(0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_0_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_0_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_0_RANGE                      0:0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_0_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_1_SHIFT                      _MK_SHIFT_CONST(1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_1_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_1_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_1_RANGE                      1:1
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_1_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_1_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_2_SHIFT                      _MK_SHIFT_CONST(2)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_2_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_2_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_2_RANGE                      2:2
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_2_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_2_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_3_SHIFT                      _MK_SHIFT_CONST(3)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_3_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_3_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_3_RANGE                      3:3
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_3_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_3_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_4_SHIFT                      _MK_SHIFT_CONST(4)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_4_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_4_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_4_RANGE                      4:4
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_4_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_4_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_4_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_5_SHIFT                      _MK_SHIFT_CONST(5)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_5_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_5_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_5_RANGE                      5:5
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_5_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_5_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_5_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_6_SHIFT                      _MK_SHIFT_CONST(6)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_6_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_6_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_6_RANGE                      6:6
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_6_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_6_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_6_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_7_SHIFT                      _MK_SHIFT_CONST(7)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_7_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_7_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_7_RANGE                      7:7
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_7_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_7_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_7_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_8_SHIFT                      _MK_SHIFT_CONST(8)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_8_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_8_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_8_RANGE                      8:8
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_8_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_8_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_8_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_8_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_8_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_9_SHIFT                      _MK_SHIFT_CONST(9)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_9_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_9_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_9_RANGE                      9:9
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_9_WOFFSET                    0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_9_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_9_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_9_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_9_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_10_SHIFT                     _MK_SHIFT_CONST(10)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_10_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_10_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_10_RANGE                     10:10
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_10_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_10_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_10_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_10_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_10_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_11_SHIFT                     _MK_SHIFT_CONST(11)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_11_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_11_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_11_RANGE                     11:11
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_11_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_11_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_11_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_11_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_11_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_12_SHIFT                     _MK_SHIFT_CONST(12)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_12_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_12_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_12_RANGE                     12:12
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_12_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_12_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_12_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_12_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_12_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_13_SHIFT                     _MK_SHIFT_CONST(13)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_13_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_13_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_13_RANGE                     13:13
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_13_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_13_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_13_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_13_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_13_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_14_SHIFT                     _MK_SHIFT_CONST(14)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_14_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_14_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_14_RANGE                     14:14
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_14_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_14_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_14_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_14_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_14_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_15_SHIFT                     _MK_SHIFT_CONST(15)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_15_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_15_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_15_RANGE                     15:15
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_15_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_15_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_15_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_15_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_15_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_16_SHIFT                     _MK_SHIFT_CONST(16)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_16_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_16_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_16_RANGE                     16:16
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_16_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_16_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_16_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_16_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_16_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_17_SHIFT                     _MK_SHIFT_CONST(17)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_17_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_17_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_17_RANGE                     17:17
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_17_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_17_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_17_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_17_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_17_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_18_SHIFT                     _MK_SHIFT_CONST(18)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_18_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_18_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_18_RANGE                     18:18
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_18_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_18_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_18_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_18_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_18_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_19_SHIFT                     _MK_SHIFT_CONST(19)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_19_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_19_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_19_RANGE                     19:19
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_19_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_19_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_19_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_19_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_19_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_20_SHIFT                     _MK_SHIFT_CONST(20)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_20_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_20_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_20_RANGE                     20:20
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_20_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_20_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_20_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_20_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_20_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_21_SHIFT                     _MK_SHIFT_CONST(21)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_21_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_21_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_21_RANGE                     21:21
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_21_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_21_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_21_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_21_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_21_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_22_SHIFT                     _MK_SHIFT_CONST(22)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_22_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_22_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_22_RANGE                     22:22
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_22_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_22_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_22_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_22_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_22_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_23_SHIFT                     _MK_SHIFT_CONST(23)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_23_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_23_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_23_RANGE                     23:23
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_23_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_23_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_23_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_23_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_23_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_24_SHIFT                     _MK_SHIFT_CONST(24)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_24_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_24_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_24_RANGE                     24:24
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_24_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_24_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_24_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_24_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_24_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_25_SHIFT                     _MK_SHIFT_CONST(25)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_25_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_25_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_25_RANGE                     25:25
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_25_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_25_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_25_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_25_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_25_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_26_SHIFT                     _MK_SHIFT_CONST(26)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_26_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_26_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_26_RANGE                     26:26
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_26_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_26_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_26_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_26_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_26_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_27_SHIFT                     _MK_SHIFT_CONST(27)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_27_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_27_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_27_RANGE                     27:27
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_27_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_27_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_27_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_27_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_27_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_28_SHIFT                     _MK_SHIFT_CONST(28)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_28_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_28_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_28_RANGE                     28:28
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_28_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_28_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_28_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_28_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_28_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_29_SHIFT                     _MK_SHIFT_CONST(29)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_29_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_29_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_29_RANGE                     29:29
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_29_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_29_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_29_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_29_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_29_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_30_SHIFT                     _MK_SHIFT_CONST(30)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_30_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_30_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_30_RANGE                     30:30
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_30_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_30_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_30_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_30_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_30_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_31_SHIFT                     _MK_SHIFT_CONST(31)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_31_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_31_SHIFT)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_31_RANGE                     31:31
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_31_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_31_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_31_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_31_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_1_0_EN_SET_SPI_31_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FIC_DIST_ENABLE_SET_2_0  
#define FIC_DIST_ENABLE_SET_2_0                 _MK_ADDR_CONST(0x1108)
#define FIC_DIST_ENABLE_SET_2_0_SECURE                  0x0
#define FIC_DIST_ENABLE_SET_2_0_WORD_COUNT                      0x1
#define FIC_DIST_ENABLE_SET_2_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_SET_2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_SET_2_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_32_SHIFT                     _MK_SHIFT_CONST(0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_32_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_32_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_32_RANGE                     0:0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_32_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_32_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_32_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_32_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_32_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_33_SHIFT                     _MK_SHIFT_CONST(1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_33_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_33_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_33_RANGE                     1:1
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_33_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_33_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_33_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_33_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_33_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_34_SHIFT                     _MK_SHIFT_CONST(2)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_34_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_34_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_34_RANGE                     2:2
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_34_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_34_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_34_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_34_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_34_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_35_SHIFT                     _MK_SHIFT_CONST(3)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_35_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_35_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_35_RANGE                     3:3
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_35_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_35_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_35_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_35_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_35_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_36_SHIFT                     _MK_SHIFT_CONST(4)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_36_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_36_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_36_RANGE                     4:4
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_36_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_36_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_36_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_36_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_36_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_37_SHIFT                     _MK_SHIFT_CONST(5)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_37_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_37_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_37_RANGE                     5:5
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_37_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_37_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_37_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_37_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_37_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_38_SHIFT                     _MK_SHIFT_CONST(6)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_38_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_38_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_38_RANGE                     6:6
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_38_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_38_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_38_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_38_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_38_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_39_SHIFT                     _MK_SHIFT_CONST(7)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_39_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_39_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_39_RANGE                     7:7
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_39_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_39_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_39_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_39_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_39_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_40_SHIFT                     _MK_SHIFT_CONST(8)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_40_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_40_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_40_RANGE                     8:8
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_40_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_40_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_40_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_40_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_40_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_41_SHIFT                     _MK_SHIFT_CONST(9)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_41_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_41_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_41_RANGE                     9:9
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_41_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_41_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_41_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_41_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_41_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_42_SHIFT                     _MK_SHIFT_CONST(10)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_42_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_42_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_42_RANGE                     10:10
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_42_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_42_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_42_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_42_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_42_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_43_SHIFT                     _MK_SHIFT_CONST(11)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_43_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_43_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_43_RANGE                     11:11
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_43_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_43_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_43_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_43_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_43_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_44_SHIFT                     _MK_SHIFT_CONST(12)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_44_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_44_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_44_RANGE                     12:12
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_44_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_44_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_44_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_44_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_44_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_45_SHIFT                     _MK_SHIFT_CONST(13)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_45_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_45_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_45_RANGE                     13:13
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_45_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_45_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_45_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_45_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_45_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_46_SHIFT                     _MK_SHIFT_CONST(14)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_46_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_46_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_46_RANGE                     14:14
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_46_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_46_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_46_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_46_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_46_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_47_SHIFT                     _MK_SHIFT_CONST(15)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_47_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_47_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_47_RANGE                     15:15
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_47_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_47_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_47_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_47_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_47_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_48_SHIFT                     _MK_SHIFT_CONST(16)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_48_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_48_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_48_RANGE                     16:16
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_48_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_48_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_48_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_48_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_48_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_49_SHIFT                     _MK_SHIFT_CONST(17)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_49_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_49_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_49_RANGE                     17:17
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_49_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_49_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_49_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_49_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_49_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_50_SHIFT                     _MK_SHIFT_CONST(18)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_50_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_50_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_50_RANGE                     18:18
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_50_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_50_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_50_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_50_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_50_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_51_SHIFT                     _MK_SHIFT_CONST(19)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_51_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_51_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_51_RANGE                     19:19
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_51_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_51_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_51_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_51_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_51_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_52_SHIFT                     _MK_SHIFT_CONST(20)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_52_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_52_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_52_RANGE                     20:20
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_52_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_52_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_52_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_52_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_52_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_53_SHIFT                     _MK_SHIFT_CONST(21)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_53_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_53_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_53_RANGE                     21:21
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_53_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_53_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_53_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_53_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_53_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_54_SHIFT                     _MK_SHIFT_CONST(22)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_54_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_54_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_54_RANGE                     22:22
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_54_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_54_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_54_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_54_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_54_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_55_SHIFT                     _MK_SHIFT_CONST(23)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_55_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_55_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_55_RANGE                     23:23
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_55_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_55_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_55_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_55_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_55_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_56_SHIFT                     _MK_SHIFT_CONST(24)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_56_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_56_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_56_RANGE                     24:24
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_56_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_56_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_56_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_56_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_56_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_57_SHIFT                     _MK_SHIFT_CONST(25)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_57_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_57_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_57_RANGE                     25:25
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_57_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_57_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_57_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_57_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_57_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_58_SHIFT                     _MK_SHIFT_CONST(26)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_58_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_58_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_58_RANGE                     26:26
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_58_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_58_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_58_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_58_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_58_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_59_SHIFT                     _MK_SHIFT_CONST(27)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_59_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_59_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_59_RANGE                     27:27
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_59_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_59_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_59_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_59_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_59_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_60_SHIFT                     _MK_SHIFT_CONST(28)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_60_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_60_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_60_RANGE                     28:28
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_60_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_60_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_60_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_60_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_60_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_61_SHIFT                     _MK_SHIFT_CONST(29)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_61_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_61_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_61_RANGE                     29:29
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_61_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_61_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_61_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_61_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_61_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_62_SHIFT                     _MK_SHIFT_CONST(30)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_62_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_62_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_62_RANGE                     30:30
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_62_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_62_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_62_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_62_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_62_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_63_SHIFT                     _MK_SHIFT_CONST(31)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_63_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_63_SHIFT)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_63_RANGE                     31:31
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_63_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_63_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_63_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_63_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_2_0_EN_SET_SPI_63_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FIC_DIST_ENABLE_SET_3_0  
#define FIC_DIST_ENABLE_SET_3_0                 _MK_ADDR_CONST(0x110c)
#define FIC_DIST_ENABLE_SET_3_0_SECURE                  0x0
#define FIC_DIST_ENABLE_SET_3_0_WORD_COUNT                      0x1
#define FIC_DIST_ENABLE_SET_3_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_SET_3_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_SET_3_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_64_SHIFT                     _MK_SHIFT_CONST(0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_64_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_64_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_64_RANGE                     0:0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_64_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_64_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_64_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_64_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_64_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_65_SHIFT                     _MK_SHIFT_CONST(1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_65_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_65_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_65_RANGE                     1:1
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_65_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_65_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_65_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_65_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_65_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_66_SHIFT                     _MK_SHIFT_CONST(2)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_66_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_66_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_66_RANGE                     2:2
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_66_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_66_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_66_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_66_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_66_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_67_SHIFT                     _MK_SHIFT_CONST(3)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_67_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_67_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_67_RANGE                     3:3
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_67_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_67_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_67_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_67_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_67_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_68_SHIFT                     _MK_SHIFT_CONST(4)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_68_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_68_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_68_RANGE                     4:4
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_68_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_68_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_68_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_68_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_68_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_69_SHIFT                     _MK_SHIFT_CONST(5)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_69_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_69_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_69_RANGE                     5:5
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_69_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_69_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_69_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_69_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_69_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_70_SHIFT                     _MK_SHIFT_CONST(6)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_70_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_70_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_70_RANGE                     6:6
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_70_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_70_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_70_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_70_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_70_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_71_SHIFT                     _MK_SHIFT_CONST(7)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_71_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_71_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_71_RANGE                     7:7
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_71_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_71_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_71_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_71_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_71_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_72_SHIFT                     _MK_SHIFT_CONST(8)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_72_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_72_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_72_RANGE                     8:8
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_72_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_72_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_72_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_72_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_72_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_73_SHIFT                     _MK_SHIFT_CONST(9)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_73_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_73_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_73_RANGE                     9:9
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_73_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_73_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_73_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_73_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_73_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_74_SHIFT                     _MK_SHIFT_CONST(10)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_74_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_74_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_74_RANGE                     10:10
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_74_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_74_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_74_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_74_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_74_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_75_SHIFT                     _MK_SHIFT_CONST(11)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_75_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_75_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_75_RANGE                     11:11
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_75_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_75_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_75_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_75_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_75_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_76_SHIFT                     _MK_SHIFT_CONST(12)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_76_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_76_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_76_RANGE                     12:12
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_76_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_76_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_76_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_76_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_76_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_77_SHIFT                     _MK_SHIFT_CONST(13)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_77_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_77_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_77_RANGE                     13:13
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_77_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_77_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_77_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_77_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_77_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_78_SHIFT                     _MK_SHIFT_CONST(14)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_78_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_78_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_78_RANGE                     14:14
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_78_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_78_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_78_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_78_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_78_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_79_SHIFT                     _MK_SHIFT_CONST(15)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_79_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_79_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_79_RANGE                     15:15
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_79_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_79_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_79_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_79_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_79_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_80_SHIFT                     _MK_SHIFT_CONST(16)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_80_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_80_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_80_RANGE                     16:16
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_80_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_80_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_80_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_80_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_80_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_81_SHIFT                     _MK_SHIFT_CONST(17)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_81_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_81_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_81_RANGE                     17:17
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_81_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_81_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_81_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_81_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_81_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_82_SHIFT                     _MK_SHIFT_CONST(18)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_82_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_82_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_82_RANGE                     18:18
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_82_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_82_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_82_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_82_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_82_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_83_SHIFT                     _MK_SHIFT_CONST(19)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_83_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_83_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_83_RANGE                     19:19
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_83_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_83_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_83_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_83_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_83_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_84_SHIFT                     _MK_SHIFT_CONST(20)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_84_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_84_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_84_RANGE                     20:20
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_84_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_84_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_84_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_84_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_84_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_85_SHIFT                     _MK_SHIFT_CONST(21)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_85_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_85_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_85_RANGE                     21:21
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_85_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_85_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_85_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_85_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_85_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_86_SHIFT                     _MK_SHIFT_CONST(22)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_86_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_86_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_86_RANGE                     22:22
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_86_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_86_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_86_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_86_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_86_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_87_SHIFT                     _MK_SHIFT_CONST(23)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_87_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_87_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_87_RANGE                     23:23
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_87_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_87_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_87_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_87_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_87_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_88_SHIFT                     _MK_SHIFT_CONST(24)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_88_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_88_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_88_RANGE                     24:24
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_88_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_88_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_88_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_88_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_88_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_89_SHIFT                     _MK_SHIFT_CONST(25)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_89_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_89_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_89_RANGE                     25:25
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_89_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_89_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_89_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_89_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_89_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_90_SHIFT                     _MK_SHIFT_CONST(26)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_90_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_90_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_90_RANGE                     26:26
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_90_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_90_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_90_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_90_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_90_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_91_SHIFT                     _MK_SHIFT_CONST(27)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_91_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_91_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_91_RANGE                     27:27
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_91_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_91_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_91_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_91_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_91_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_92_SHIFT                     _MK_SHIFT_CONST(28)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_92_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_92_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_92_RANGE                     28:28
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_92_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_92_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_92_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_92_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_92_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_93_SHIFT                     _MK_SHIFT_CONST(29)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_93_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_93_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_93_RANGE                     29:29
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_93_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_93_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_93_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_93_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_93_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_94_SHIFT                     _MK_SHIFT_CONST(30)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_94_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_94_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_94_RANGE                     30:30
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_94_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_94_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_94_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_94_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_94_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_95_SHIFT                     _MK_SHIFT_CONST(31)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_95_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_95_SHIFT)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_95_RANGE                     31:31
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_95_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_95_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_95_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_95_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_3_0_EN_SET_SPI_95_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FIC_DIST_ENABLE_SET_4_0  
#define FIC_DIST_ENABLE_SET_4_0                 _MK_ADDR_CONST(0x1110)
#define FIC_DIST_ENABLE_SET_4_0_SECURE                  0x0
#define FIC_DIST_ENABLE_SET_4_0_WORD_COUNT                      0x1
#define FIC_DIST_ENABLE_SET_4_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_SET_4_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_SET_4_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_96_SHIFT                     _MK_SHIFT_CONST(0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_96_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_96_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_96_RANGE                     0:0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_96_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_96_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_96_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_96_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_96_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_97_SHIFT                     _MK_SHIFT_CONST(1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_97_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_97_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_97_RANGE                     1:1
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_97_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_97_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_97_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_97_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_97_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_98_SHIFT                     _MK_SHIFT_CONST(2)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_98_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_98_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_98_RANGE                     2:2
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_98_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_98_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_98_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_98_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_98_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_99_SHIFT                     _MK_SHIFT_CONST(3)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_99_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_99_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_99_RANGE                     3:3
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_99_WOFFSET                   0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_99_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_99_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_99_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_99_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_100_SHIFT                    _MK_SHIFT_CONST(4)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_100_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_100_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_100_RANGE                    4:4
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_100_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_100_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_100_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_100_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_100_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_101_SHIFT                    _MK_SHIFT_CONST(5)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_101_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_101_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_101_RANGE                    5:5
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_101_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_101_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_101_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_101_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_101_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_102_SHIFT                    _MK_SHIFT_CONST(6)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_102_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_102_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_102_RANGE                    6:6
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_102_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_102_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_102_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_102_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_102_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_103_SHIFT                    _MK_SHIFT_CONST(7)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_103_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_103_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_103_RANGE                    7:7
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_103_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_103_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_103_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_103_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_103_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_104_SHIFT                    _MK_SHIFT_CONST(8)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_104_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_104_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_104_RANGE                    8:8
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_104_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_104_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_104_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_104_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_104_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_105_SHIFT                    _MK_SHIFT_CONST(9)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_105_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_105_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_105_RANGE                    9:9
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_105_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_105_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_105_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_105_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_105_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_106_SHIFT                    _MK_SHIFT_CONST(10)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_106_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_106_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_106_RANGE                    10:10
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_106_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_106_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_106_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_106_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_106_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_107_SHIFT                    _MK_SHIFT_CONST(11)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_107_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_107_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_107_RANGE                    11:11
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_107_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_107_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_107_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_107_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_107_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_108_SHIFT                    _MK_SHIFT_CONST(12)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_108_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_108_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_108_RANGE                    12:12
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_108_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_108_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_108_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_108_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_108_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_109_SHIFT                    _MK_SHIFT_CONST(13)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_109_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_109_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_109_RANGE                    13:13
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_109_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_109_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_109_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_109_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_109_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_110_SHIFT                    _MK_SHIFT_CONST(14)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_110_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_110_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_110_RANGE                    14:14
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_110_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_110_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_110_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_110_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_110_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_111_SHIFT                    _MK_SHIFT_CONST(15)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_111_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_111_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_111_RANGE                    15:15
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_111_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_111_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_111_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_111_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_111_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_112_SHIFT                    _MK_SHIFT_CONST(16)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_112_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_112_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_112_RANGE                    16:16
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_112_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_112_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_112_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_112_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_112_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_113_SHIFT                    _MK_SHIFT_CONST(17)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_113_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_113_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_113_RANGE                    17:17
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_113_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_113_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_113_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_113_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_113_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_114_SHIFT                    _MK_SHIFT_CONST(18)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_114_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_114_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_114_RANGE                    18:18
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_114_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_114_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_114_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_114_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_114_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_115_SHIFT                    _MK_SHIFT_CONST(19)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_115_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_115_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_115_RANGE                    19:19
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_115_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_115_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_115_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_115_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_115_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_116_SHIFT                    _MK_SHIFT_CONST(20)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_116_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_116_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_116_RANGE                    20:20
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_116_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_116_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_116_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_116_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_116_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_117_SHIFT                    _MK_SHIFT_CONST(21)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_117_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_117_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_117_RANGE                    21:21
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_117_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_117_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_117_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_117_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_117_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_118_SHIFT                    _MK_SHIFT_CONST(22)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_118_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_118_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_118_RANGE                    22:22
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_118_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_118_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_118_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_118_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_118_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_119_SHIFT                    _MK_SHIFT_CONST(23)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_119_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_119_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_119_RANGE                    23:23
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_119_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_119_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_119_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_119_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_119_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_120_SHIFT                    _MK_SHIFT_CONST(24)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_120_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_120_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_120_RANGE                    24:24
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_120_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_120_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_120_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_120_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_120_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_121_SHIFT                    _MK_SHIFT_CONST(25)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_121_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_121_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_121_RANGE                    25:25
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_121_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_121_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_121_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_121_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_121_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_122_SHIFT                    _MK_SHIFT_CONST(26)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_122_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_122_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_122_RANGE                    26:26
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_122_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_122_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_122_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_122_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_122_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_123_SHIFT                    _MK_SHIFT_CONST(27)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_123_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_123_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_123_RANGE                    27:27
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_123_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_123_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_123_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_123_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_123_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_124_SHIFT                    _MK_SHIFT_CONST(28)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_124_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_124_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_124_RANGE                    28:28
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_124_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_124_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_124_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_124_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_124_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_125_SHIFT                    _MK_SHIFT_CONST(29)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_125_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_125_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_125_RANGE                    29:29
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_125_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_125_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_125_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_125_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_125_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_126_SHIFT                    _MK_SHIFT_CONST(30)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_126_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_126_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_126_RANGE                    30:30
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_126_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_126_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_126_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_126_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_126_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_127_SHIFT                    _MK_SHIFT_CONST(31)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_127_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_127_SHIFT)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_127_RANGE                    31:31
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_127_WOFFSET                  0x0
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_127_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_127_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_127_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_SET_4_0_EN_SET_SPI_127_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Reserved address 4372 [0x1114] 

// Reserved address 4376 [0x1118] 

// Reserved address 4380 [0x111c] 

// Reserved address 4384 [0x1120] 

// Reserved address 4388 [0x1124] 

// Reserved address 4392 [0x1128] 

// Reserved address 4396 [0x112c] 

// Reserved address 4400 [0x1130] 

// Reserved address 4404 [0x1134] 

// Reserved address 4408 [0x1138] 

// Reserved address 4412 [0x113c] 

// Reserved address 4416 [0x1140] 

// Reserved address 4420 [0x1144] 

// Reserved address 4424 [0x1148] 

// Reserved address 4428 [0x114c] 

// Reserved address 4432 [0x1150] 

// Reserved address 4436 [0x1154] 

// Reserved address 4440 [0x1158] 

// Reserved address 4444 [0x115c] 

// Reserved address 4448 [0x1160] 

// Reserved address 4452 [0x1164] 

// Reserved address 4456 [0x1168] 

// Reserved address 4460 [0x116c] 

// Reserved address 4464 [0x1170] 

// Reserved address 4468 [0x1174] 

// Reserved address 4472 [0x1178] 

// Reserved address 4476 [0x117c] 

// Register FIC_DIST_ENABLE_CLEAR_0_0  
#define FIC_DIST_ENABLE_CLEAR_0_0                       _MK_ADDR_CONST(0x1180)
#define FIC_DIST_ENABLE_CLEAR_0_0_SECURE                        0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_WORD_COUNT                    0x1
#define FIC_DIST_ENABLE_CLEAR_0_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_RESET_MASK                    _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_ENABLE_CLEAR_0_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_READ_MASK                     _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_ENABLE_CLEAR_0_0_WRITE_MASK                    _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_0_SHIFT                    _MK_SHIFT_CONST(0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_0_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_0_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_0_RANGE                    0:0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_0_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_1_SHIFT                    _MK_SHIFT_CONST(1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_1_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_1_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_1_RANGE                    1:1
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_1_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_2_SHIFT                    _MK_SHIFT_CONST(2)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_2_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_2_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_2_RANGE                    2:2
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_2_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_2_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_3_SHIFT                    _MK_SHIFT_CONST(3)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_3_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_3_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_3_RANGE                    3:3
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_3_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_3_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_3_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_3_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_3_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_4_SHIFT                    _MK_SHIFT_CONST(4)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_4_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_4_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_4_RANGE                    4:4
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_4_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_4_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_4_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_4_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_4_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_5_SHIFT                    _MK_SHIFT_CONST(5)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_5_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_5_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_5_RANGE                    5:5
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_5_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_5_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_5_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_5_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_5_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_6_SHIFT                    _MK_SHIFT_CONST(6)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_6_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_6_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_6_RANGE                    6:6
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_6_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_6_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_6_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_6_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_6_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_7_SHIFT                    _MK_SHIFT_CONST(7)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_7_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_7_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_7_RANGE                    7:7
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_7_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_7_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_7_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_7_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_7_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_8_SHIFT                    _MK_SHIFT_CONST(8)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_8_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_8_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_8_RANGE                    8:8
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_8_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_8_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_8_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_8_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_8_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_9_SHIFT                    _MK_SHIFT_CONST(9)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_9_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_9_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_9_RANGE                    9:9
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_9_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_9_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_9_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_9_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_9_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_10_SHIFT                   _MK_SHIFT_CONST(10)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_10_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_10_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_10_RANGE                   10:10
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_10_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_10_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_10_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_10_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_10_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_11_SHIFT                   _MK_SHIFT_CONST(11)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_11_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_11_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_11_RANGE                   11:11
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_11_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_11_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_11_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_11_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_11_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_12_SHIFT                   _MK_SHIFT_CONST(12)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_12_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_12_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_12_RANGE                   12:12
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_12_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_12_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_12_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_12_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_12_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_13_SHIFT                   _MK_SHIFT_CONST(13)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_13_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_13_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_13_RANGE                   13:13
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_13_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_13_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_13_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_13_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_13_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_14_SHIFT                   _MK_SHIFT_CONST(14)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_14_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_14_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_14_RANGE                   14:14
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_14_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_14_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_14_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_14_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_14_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_15_SHIFT                   _MK_SHIFT_CONST(15)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_15_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_15_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_15_RANGE                   15:15
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_15_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_15_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_15_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_15_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_STI_15_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_4_SHIFT                    _MK_SHIFT_CONST(27)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_4_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_4_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_4_RANGE                    27:27
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_4_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_4_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_4_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_4_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_4_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_0_SHIFT                    _MK_SHIFT_CONST(28)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_0_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_0_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_0_RANGE                    28:28
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_0_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_1_SHIFT                    _MK_SHIFT_CONST(29)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_1_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_1_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_1_RANGE                    29:29
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_1_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_2_SHIFT                    _MK_SHIFT_CONST(30)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_2_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_2_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_2_RANGE                    30:30
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_2_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_2_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_3_SHIFT                    _MK_SHIFT_CONST(31)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_3_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_3_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_3_RANGE                    31:31
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_3_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_3_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_3_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_3_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_0_0_EN_CLR_PPI_3_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FIC_DIST_ENABLE_CLEAR_1_0  
#define FIC_DIST_ENABLE_CLEAR_1_0                       _MK_ADDR_CONST(0x1184)
#define FIC_DIST_ENABLE_CLEAR_1_0_SECURE                        0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_WORD_COUNT                    0x1
#define FIC_DIST_ENABLE_CLEAR_1_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_CLEAR_1_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_CLEAR_1_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_0_SHIFT                    _MK_SHIFT_CONST(0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_0_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_0_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_0_RANGE                    0:0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_0_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_1_SHIFT                    _MK_SHIFT_CONST(1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_1_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_1_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_1_RANGE                    1:1
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_1_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_2_SHIFT                    _MK_SHIFT_CONST(2)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_2_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_2_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_2_RANGE                    2:2
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_2_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_2_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_3_SHIFT                    _MK_SHIFT_CONST(3)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_3_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_3_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_3_RANGE                    3:3
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_3_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_3_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_3_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_3_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_3_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_4_SHIFT                    _MK_SHIFT_CONST(4)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_4_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_4_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_4_RANGE                    4:4
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_4_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_4_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_4_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_4_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_4_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_5_SHIFT                    _MK_SHIFT_CONST(5)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_5_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_5_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_5_RANGE                    5:5
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_5_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_5_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_5_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_5_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_5_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_6_SHIFT                    _MK_SHIFT_CONST(6)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_6_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_6_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_6_RANGE                    6:6
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_6_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_6_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_6_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_6_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_6_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_7_SHIFT                    _MK_SHIFT_CONST(7)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_7_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_7_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_7_RANGE                    7:7
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_7_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_7_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_7_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_7_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_7_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_8_SHIFT                    _MK_SHIFT_CONST(8)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_8_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_8_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_8_RANGE                    8:8
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_8_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_8_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_8_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_8_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_8_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_9_SHIFT                    _MK_SHIFT_CONST(9)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_9_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_9_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_9_RANGE                    9:9
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_9_WOFFSET                  0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_9_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_9_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_9_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_9_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_10_SHIFT                   _MK_SHIFT_CONST(10)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_10_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_10_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_10_RANGE                   10:10
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_10_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_10_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_10_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_10_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_10_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_11_SHIFT                   _MK_SHIFT_CONST(11)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_11_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_11_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_11_RANGE                   11:11
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_11_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_11_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_11_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_11_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_11_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_12_SHIFT                   _MK_SHIFT_CONST(12)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_12_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_12_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_12_RANGE                   12:12
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_12_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_12_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_12_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_12_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_12_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_13_SHIFT                   _MK_SHIFT_CONST(13)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_13_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_13_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_13_RANGE                   13:13
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_13_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_13_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_13_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_13_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_13_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_14_SHIFT                   _MK_SHIFT_CONST(14)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_14_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_14_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_14_RANGE                   14:14
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_14_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_14_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_14_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_14_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_14_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_15_SHIFT                   _MK_SHIFT_CONST(15)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_15_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_15_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_15_RANGE                   15:15
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_15_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_15_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_15_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_15_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_15_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_16_SHIFT                   _MK_SHIFT_CONST(16)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_16_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_16_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_16_RANGE                   16:16
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_16_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_16_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_16_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_16_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_16_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_17_SHIFT                   _MK_SHIFT_CONST(17)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_17_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_17_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_17_RANGE                   17:17
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_17_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_17_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_17_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_17_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_17_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_18_SHIFT                   _MK_SHIFT_CONST(18)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_18_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_18_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_18_RANGE                   18:18
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_18_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_18_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_18_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_18_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_18_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_19_SHIFT                   _MK_SHIFT_CONST(19)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_19_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_19_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_19_RANGE                   19:19
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_19_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_19_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_19_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_19_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_19_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_20_SHIFT                   _MK_SHIFT_CONST(20)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_20_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_20_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_20_RANGE                   20:20
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_20_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_20_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_20_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_20_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_20_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_21_SHIFT                   _MK_SHIFT_CONST(21)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_21_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_21_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_21_RANGE                   21:21
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_21_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_21_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_21_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_21_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_21_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_22_SHIFT                   _MK_SHIFT_CONST(22)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_22_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_22_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_22_RANGE                   22:22
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_22_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_22_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_22_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_22_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_22_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_23_SHIFT                   _MK_SHIFT_CONST(23)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_23_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_23_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_23_RANGE                   23:23
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_23_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_23_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_23_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_23_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_23_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_24_SHIFT                   _MK_SHIFT_CONST(24)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_24_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_24_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_24_RANGE                   24:24
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_24_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_24_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_24_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_24_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_24_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_25_SHIFT                   _MK_SHIFT_CONST(25)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_25_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_25_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_25_RANGE                   25:25
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_25_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_25_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_25_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_25_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_25_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_26_SHIFT                   _MK_SHIFT_CONST(26)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_26_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_26_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_26_RANGE                   26:26
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_26_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_26_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_26_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_26_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_26_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_27_SHIFT                   _MK_SHIFT_CONST(27)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_27_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_27_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_27_RANGE                   27:27
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_27_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_27_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_27_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_27_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_27_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_28_SHIFT                   _MK_SHIFT_CONST(28)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_28_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_28_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_28_RANGE                   28:28
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_28_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_28_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_28_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_28_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_28_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_29_SHIFT                   _MK_SHIFT_CONST(29)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_29_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_29_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_29_RANGE                   29:29
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_29_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_29_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_29_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_29_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_29_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_30_SHIFT                   _MK_SHIFT_CONST(30)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_30_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_30_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_30_RANGE                   30:30
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_30_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_30_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_30_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_30_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_30_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_31_SHIFT                   _MK_SHIFT_CONST(31)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_31_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_31_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_31_RANGE                   31:31
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_31_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_31_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_31_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_31_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_1_0_EN_CLR_SPI_31_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FIC_DIST_ENABLE_CLEAR_2_0  
#define FIC_DIST_ENABLE_CLEAR_2_0                       _MK_ADDR_CONST(0x1188)
#define FIC_DIST_ENABLE_CLEAR_2_0_SECURE                        0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_WORD_COUNT                    0x1
#define FIC_DIST_ENABLE_CLEAR_2_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_CLEAR_2_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_CLEAR_2_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_32_SHIFT                   _MK_SHIFT_CONST(0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_32_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_32_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_32_RANGE                   0:0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_32_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_32_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_32_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_32_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_32_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_33_SHIFT                   _MK_SHIFT_CONST(1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_33_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_33_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_33_RANGE                   1:1
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_33_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_33_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_33_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_33_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_33_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_34_SHIFT                   _MK_SHIFT_CONST(2)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_34_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_34_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_34_RANGE                   2:2
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_34_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_34_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_34_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_34_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_34_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_35_SHIFT                   _MK_SHIFT_CONST(3)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_35_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_35_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_35_RANGE                   3:3
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_35_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_35_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_35_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_35_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_35_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_36_SHIFT                   _MK_SHIFT_CONST(4)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_36_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_36_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_36_RANGE                   4:4
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_36_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_36_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_36_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_36_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_36_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_37_SHIFT                   _MK_SHIFT_CONST(5)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_37_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_37_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_37_RANGE                   5:5
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_37_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_37_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_37_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_37_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_37_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_38_SHIFT                   _MK_SHIFT_CONST(6)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_38_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_38_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_38_RANGE                   6:6
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_38_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_38_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_38_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_38_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_38_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_39_SHIFT                   _MK_SHIFT_CONST(7)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_39_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_39_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_39_RANGE                   7:7
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_39_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_39_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_39_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_39_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_39_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_40_SHIFT                   _MK_SHIFT_CONST(8)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_40_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_40_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_40_RANGE                   8:8
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_40_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_40_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_40_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_40_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_40_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_41_SHIFT                   _MK_SHIFT_CONST(9)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_41_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_41_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_41_RANGE                   9:9
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_41_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_41_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_41_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_41_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_41_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_42_SHIFT                   _MK_SHIFT_CONST(10)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_42_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_42_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_42_RANGE                   10:10
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_42_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_42_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_42_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_42_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_42_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_43_SHIFT                   _MK_SHIFT_CONST(11)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_43_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_43_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_43_RANGE                   11:11
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_43_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_43_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_43_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_43_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_43_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_44_SHIFT                   _MK_SHIFT_CONST(12)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_44_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_44_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_44_RANGE                   12:12
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_44_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_44_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_44_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_44_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_44_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_45_SHIFT                   _MK_SHIFT_CONST(13)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_45_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_45_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_45_RANGE                   13:13
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_45_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_45_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_45_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_45_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_45_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_46_SHIFT                   _MK_SHIFT_CONST(14)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_46_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_46_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_46_RANGE                   14:14
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_46_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_46_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_46_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_46_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_46_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_47_SHIFT                   _MK_SHIFT_CONST(15)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_47_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_47_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_47_RANGE                   15:15
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_47_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_47_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_47_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_47_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_47_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_48_SHIFT                   _MK_SHIFT_CONST(16)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_48_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_48_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_48_RANGE                   16:16
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_48_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_48_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_48_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_48_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_48_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_49_SHIFT                   _MK_SHIFT_CONST(17)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_49_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_49_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_49_RANGE                   17:17
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_49_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_49_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_49_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_49_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_49_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_50_SHIFT                   _MK_SHIFT_CONST(18)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_50_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_50_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_50_RANGE                   18:18
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_50_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_50_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_50_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_50_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_50_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_51_SHIFT                   _MK_SHIFT_CONST(19)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_51_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_51_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_51_RANGE                   19:19
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_51_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_51_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_51_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_51_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_51_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_52_SHIFT                   _MK_SHIFT_CONST(20)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_52_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_52_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_52_RANGE                   20:20
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_52_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_52_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_52_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_52_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_52_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_53_SHIFT                   _MK_SHIFT_CONST(21)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_53_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_53_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_53_RANGE                   21:21
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_53_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_53_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_53_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_53_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_53_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_54_SHIFT                   _MK_SHIFT_CONST(22)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_54_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_54_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_54_RANGE                   22:22
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_54_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_54_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_54_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_54_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_54_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_55_SHIFT                   _MK_SHIFT_CONST(23)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_55_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_55_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_55_RANGE                   23:23
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_55_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_55_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_55_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_55_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_55_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_56_SHIFT                   _MK_SHIFT_CONST(24)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_56_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_56_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_56_RANGE                   24:24
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_56_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_56_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_56_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_56_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_56_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_57_SHIFT                   _MK_SHIFT_CONST(25)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_57_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_57_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_57_RANGE                   25:25
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_57_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_57_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_57_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_57_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_57_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_58_SHIFT                   _MK_SHIFT_CONST(26)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_58_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_58_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_58_RANGE                   26:26
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_58_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_58_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_58_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_58_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_58_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_59_SHIFT                   _MK_SHIFT_CONST(27)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_59_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_59_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_59_RANGE                   27:27
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_59_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_59_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_59_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_59_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_59_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_60_SHIFT                   _MK_SHIFT_CONST(28)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_60_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_60_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_60_RANGE                   28:28
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_60_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_60_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_60_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_60_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_60_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_61_SHIFT                   _MK_SHIFT_CONST(29)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_61_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_61_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_61_RANGE                   29:29
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_61_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_61_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_61_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_61_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_61_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_62_SHIFT                   _MK_SHIFT_CONST(30)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_62_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_62_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_62_RANGE                   30:30
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_62_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_62_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_62_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_62_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_62_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_63_SHIFT                   _MK_SHIFT_CONST(31)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_63_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_63_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_63_RANGE                   31:31
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_63_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_63_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_63_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_63_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_2_0_EN_CLR_SPI_63_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FIC_DIST_ENABLE_CLEAR_3_0  
#define FIC_DIST_ENABLE_CLEAR_3_0                       _MK_ADDR_CONST(0x118c)
#define FIC_DIST_ENABLE_CLEAR_3_0_SECURE                        0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_WORD_COUNT                    0x1
#define FIC_DIST_ENABLE_CLEAR_3_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_CLEAR_3_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_CLEAR_3_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_64_SHIFT                   _MK_SHIFT_CONST(0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_64_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_64_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_64_RANGE                   0:0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_64_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_64_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_64_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_64_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_64_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_65_SHIFT                   _MK_SHIFT_CONST(1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_65_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_65_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_65_RANGE                   1:1
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_65_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_65_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_65_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_65_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_65_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_66_SHIFT                   _MK_SHIFT_CONST(2)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_66_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_66_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_66_RANGE                   2:2
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_66_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_66_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_66_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_66_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_66_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_67_SHIFT                   _MK_SHIFT_CONST(3)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_67_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_67_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_67_RANGE                   3:3
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_67_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_67_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_67_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_67_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_67_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_68_SHIFT                   _MK_SHIFT_CONST(4)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_68_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_68_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_68_RANGE                   4:4
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_68_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_68_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_68_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_68_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_68_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_69_SHIFT                   _MK_SHIFT_CONST(5)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_69_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_69_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_69_RANGE                   5:5
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_69_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_69_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_69_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_69_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_69_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_70_SHIFT                   _MK_SHIFT_CONST(6)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_70_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_70_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_70_RANGE                   6:6
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_70_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_70_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_70_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_70_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_70_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_71_SHIFT                   _MK_SHIFT_CONST(7)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_71_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_71_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_71_RANGE                   7:7
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_71_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_71_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_71_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_71_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_71_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_72_SHIFT                   _MK_SHIFT_CONST(8)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_72_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_72_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_72_RANGE                   8:8
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_72_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_72_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_72_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_72_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_72_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_73_SHIFT                   _MK_SHIFT_CONST(9)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_73_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_73_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_73_RANGE                   9:9
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_73_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_73_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_73_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_73_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_73_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_74_SHIFT                   _MK_SHIFT_CONST(10)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_74_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_74_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_74_RANGE                   10:10
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_74_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_74_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_74_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_74_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_74_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_75_SHIFT                   _MK_SHIFT_CONST(11)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_75_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_75_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_75_RANGE                   11:11
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_75_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_75_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_75_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_75_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_75_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_76_SHIFT                   _MK_SHIFT_CONST(12)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_76_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_76_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_76_RANGE                   12:12
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_76_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_76_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_76_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_76_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_76_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_77_SHIFT                   _MK_SHIFT_CONST(13)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_77_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_77_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_77_RANGE                   13:13
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_77_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_77_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_77_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_77_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_77_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_78_SHIFT                   _MK_SHIFT_CONST(14)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_78_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_78_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_78_RANGE                   14:14
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_78_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_78_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_78_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_78_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_78_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_79_SHIFT                   _MK_SHIFT_CONST(15)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_79_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_79_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_79_RANGE                   15:15
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_79_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_79_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_79_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_79_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_79_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_80_SHIFT                   _MK_SHIFT_CONST(16)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_80_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_80_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_80_RANGE                   16:16
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_80_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_80_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_80_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_80_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_80_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_81_SHIFT                   _MK_SHIFT_CONST(17)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_81_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_81_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_81_RANGE                   17:17
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_81_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_81_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_81_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_81_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_81_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_82_SHIFT                   _MK_SHIFT_CONST(18)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_82_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_82_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_82_RANGE                   18:18
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_82_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_82_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_82_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_82_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_82_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_83_SHIFT                   _MK_SHIFT_CONST(19)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_83_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_83_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_83_RANGE                   19:19
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_83_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_83_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_83_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_83_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_83_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_84_SHIFT                   _MK_SHIFT_CONST(20)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_84_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_84_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_84_RANGE                   20:20
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_84_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_84_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_84_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_84_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_84_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_85_SHIFT                   _MK_SHIFT_CONST(21)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_85_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_85_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_85_RANGE                   21:21
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_85_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_85_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_85_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_85_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_85_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_86_SHIFT                   _MK_SHIFT_CONST(22)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_86_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_86_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_86_RANGE                   22:22
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_86_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_86_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_86_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_86_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_86_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_87_SHIFT                   _MK_SHIFT_CONST(23)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_87_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_87_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_87_RANGE                   23:23
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_87_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_87_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_87_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_87_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_87_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_88_SHIFT                   _MK_SHIFT_CONST(24)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_88_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_88_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_88_RANGE                   24:24
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_88_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_88_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_88_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_88_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_88_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_89_SHIFT                   _MK_SHIFT_CONST(25)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_89_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_89_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_89_RANGE                   25:25
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_89_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_89_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_89_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_89_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_89_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_90_SHIFT                   _MK_SHIFT_CONST(26)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_90_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_90_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_90_RANGE                   26:26
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_90_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_90_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_90_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_90_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_90_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_91_SHIFT                   _MK_SHIFT_CONST(27)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_91_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_91_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_91_RANGE                   27:27
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_91_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_91_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_91_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_91_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_91_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_92_SHIFT                   _MK_SHIFT_CONST(28)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_92_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_92_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_92_RANGE                   28:28
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_92_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_92_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_92_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_92_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_92_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_93_SHIFT                   _MK_SHIFT_CONST(29)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_93_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_93_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_93_RANGE                   29:29
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_93_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_93_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_93_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_93_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_93_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_94_SHIFT                   _MK_SHIFT_CONST(30)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_94_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_94_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_94_RANGE                   30:30
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_94_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_94_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_94_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_94_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_94_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_95_SHIFT                   _MK_SHIFT_CONST(31)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_95_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_95_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_95_RANGE                   31:31
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_95_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_95_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_95_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_95_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_3_0_EN_CLR_SPI_95_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FIC_DIST_ENABLE_CLEAR_4_0  
#define FIC_DIST_ENABLE_CLEAR_4_0                       _MK_ADDR_CONST(0x1190)
#define FIC_DIST_ENABLE_CLEAR_4_0_SECURE                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_WORD_COUNT                    0x1
#define FIC_DIST_ENABLE_CLEAR_4_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_CLEAR_4_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_CLEAR_4_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_96_SHIFT                   _MK_SHIFT_CONST(0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_96_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_96_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_96_RANGE                   0:0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_96_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_96_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_96_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_96_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_96_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_97_SHIFT                   _MK_SHIFT_CONST(1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_97_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_97_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_97_RANGE                   1:1
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_97_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_97_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_97_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_97_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_97_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_98_SHIFT                   _MK_SHIFT_CONST(2)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_98_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_98_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_98_RANGE                   2:2
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_98_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_98_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_98_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_98_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_98_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_99_SHIFT                   _MK_SHIFT_CONST(3)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_99_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_99_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_99_RANGE                   3:3
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_99_WOFFSET                 0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_99_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_99_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_99_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_99_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_100_SHIFT                  _MK_SHIFT_CONST(4)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_100_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_100_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_100_RANGE                  4:4
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_100_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_100_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_100_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_100_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_100_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_101_SHIFT                  _MK_SHIFT_CONST(5)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_101_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_101_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_101_RANGE                  5:5
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_101_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_101_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_101_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_101_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_101_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_102_SHIFT                  _MK_SHIFT_CONST(6)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_102_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_102_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_102_RANGE                  6:6
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_102_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_102_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_102_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_102_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_102_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_103_SHIFT                  _MK_SHIFT_CONST(7)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_103_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_103_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_103_RANGE                  7:7
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_103_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_103_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_103_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_103_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_103_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_104_SHIFT                  _MK_SHIFT_CONST(8)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_104_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_104_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_104_RANGE                  8:8
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_104_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_104_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_104_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_104_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_104_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_105_SHIFT                  _MK_SHIFT_CONST(9)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_105_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_105_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_105_RANGE                  9:9
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_105_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_105_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_105_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_105_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_105_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_106_SHIFT                  _MK_SHIFT_CONST(10)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_106_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_106_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_106_RANGE                  10:10
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_106_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_106_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_106_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_106_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_106_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_107_SHIFT                  _MK_SHIFT_CONST(11)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_107_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_107_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_107_RANGE                  11:11
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_107_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_107_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_107_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_107_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_107_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_108_SHIFT                  _MK_SHIFT_CONST(12)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_108_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_108_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_108_RANGE                  12:12
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_108_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_108_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_108_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_108_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_108_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_109_SHIFT                  _MK_SHIFT_CONST(13)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_109_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_109_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_109_RANGE                  13:13
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_109_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_109_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_109_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_109_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_109_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_110_SHIFT                  _MK_SHIFT_CONST(14)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_110_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_110_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_110_RANGE                  14:14
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_110_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_110_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_110_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_110_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_110_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_111_SHIFT                  _MK_SHIFT_CONST(15)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_111_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_111_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_111_RANGE                  15:15
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_111_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_111_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_111_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_111_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_111_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_112_SHIFT                  _MK_SHIFT_CONST(16)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_112_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_112_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_112_RANGE                  16:16
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_112_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_112_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_112_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_112_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_112_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_113_SHIFT                  _MK_SHIFT_CONST(17)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_113_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_113_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_113_RANGE                  17:17
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_113_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_113_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_113_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_113_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_113_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_114_SHIFT                  _MK_SHIFT_CONST(18)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_114_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_114_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_114_RANGE                  18:18
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_114_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_114_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_114_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_114_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_114_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_115_SHIFT                  _MK_SHIFT_CONST(19)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_115_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_115_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_115_RANGE                  19:19
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_115_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_115_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_115_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_115_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_115_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_116_SHIFT                  _MK_SHIFT_CONST(20)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_116_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_116_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_116_RANGE                  20:20
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_116_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_116_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_116_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_116_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_116_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_117_SHIFT                  _MK_SHIFT_CONST(21)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_117_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_117_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_117_RANGE                  21:21
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_117_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_117_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_117_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_117_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_117_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_118_SHIFT                  _MK_SHIFT_CONST(22)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_118_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_118_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_118_RANGE                  22:22
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_118_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_118_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_118_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_118_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_118_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_119_SHIFT                  _MK_SHIFT_CONST(23)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_119_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_119_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_119_RANGE                  23:23
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_119_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_119_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_119_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_119_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_119_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_120_SHIFT                  _MK_SHIFT_CONST(24)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_120_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_120_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_120_RANGE                  24:24
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_120_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_120_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_120_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_120_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_120_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_121_SHIFT                  _MK_SHIFT_CONST(25)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_121_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_121_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_121_RANGE                  25:25
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_121_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_121_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_121_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_121_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_121_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_122_SHIFT                  _MK_SHIFT_CONST(26)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_122_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_122_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_122_RANGE                  26:26
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_122_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_122_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_122_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_122_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_122_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_123_SHIFT                  _MK_SHIFT_CONST(27)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_123_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_123_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_123_RANGE                  27:27
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_123_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_123_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_123_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_123_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_123_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_124_SHIFT                  _MK_SHIFT_CONST(28)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_124_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_124_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_124_RANGE                  28:28
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_124_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_124_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_124_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_124_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_124_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_125_SHIFT                  _MK_SHIFT_CONST(29)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_125_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_125_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_125_RANGE                  29:29
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_125_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_125_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_125_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_125_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_125_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_126_SHIFT                  _MK_SHIFT_CONST(30)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_126_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_126_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_126_RANGE                  30:30
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_126_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_126_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_126_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_126_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_126_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_127_SHIFT                  _MK_SHIFT_CONST(31)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_127_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_127_SHIFT)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_127_RANGE                  31:31
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_127_WOFFSET                        0x0
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_127_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_127_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_127_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ENABLE_CLEAR_4_0_EN_CLR_SPI_127_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 4500 [0x1194] 

// Reserved address 4504 [0x1198] 

// Reserved address 4508 [0x119c] 

// Reserved address 4512 [0x11a0] 

// Reserved address 4516 [0x11a4] 

// Reserved address 4520 [0x11a8] 

// Reserved address 4524 [0x11ac] 

// Reserved address 4528 [0x11b0] 

// Reserved address 4532 [0x11b4] 

// Reserved address 4536 [0x11b8] 

// Reserved address 4540 [0x11bc] 

// Reserved address 4544 [0x11c0] 

// Reserved address 4548 [0x11c4] 

// Reserved address 4552 [0x11c8] 

// Reserved address 4556 [0x11cc] 

// Reserved address 4560 [0x11d0] 

// Reserved address 4564 [0x11d4] 

// Reserved address 4568 [0x11d8] 

// Reserved address 4572 [0x11dc] 

// Reserved address 4576 [0x11e0] 

// Reserved address 4580 [0x11e4] 

// Reserved address 4584 [0x11e8] 

// Reserved address 4588 [0x11ec] 

// Reserved address 4592 [0x11f0] 

// Reserved address 4596 [0x11f4] 

// Reserved address 4600 [0x11f8] 

// Reserved address 4604 [0x11fc] 

// Register FIC_DIST_PENDING_SET_0_0  
#define FIC_DIST_PENDING_SET_0_0                        _MK_ADDR_CONST(0x1200)
#define FIC_DIST_PENDING_SET_0_0_SECURE                         0x0
#define FIC_DIST_PENDING_SET_0_0_WORD_COUNT                     0x1
#define FIC_DIST_PENDING_SET_0_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_RESET_MASK                     _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_PENDING_SET_0_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_READ_MASK                      _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_PENDING_SET_0_0_WRITE_MASK                     _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_0_SHIFT                        _MK_SHIFT_CONST(0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_0_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_0_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_0_RANGE                        0:0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_0_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_0_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_1_SHIFT                        _MK_SHIFT_CONST(1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_1_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_1_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_1_RANGE                        1:1
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_1_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_1_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_1_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_2_SHIFT                        _MK_SHIFT_CONST(2)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_2_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_2_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_2_RANGE                        2:2
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_2_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_2_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_2_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_3_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_3_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_3_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_3_RANGE                        3:3
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_3_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_3_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_3_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_3_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_3_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_4_SHIFT                        _MK_SHIFT_CONST(4)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_4_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_4_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_4_RANGE                        4:4
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_4_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_4_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_4_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_4_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_4_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_5_SHIFT                        _MK_SHIFT_CONST(5)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_5_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_5_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_5_RANGE                        5:5
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_5_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_5_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_5_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_5_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_5_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_6_SHIFT                        _MK_SHIFT_CONST(6)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_6_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_6_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_6_RANGE                        6:6
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_6_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_6_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_6_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_6_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_6_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_7_SHIFT                        _MK_SHIFT_CONST(7)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_7_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_7_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_7_RANGE                        7:7
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_7_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_7_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_7_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_7_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_7_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_8_SHIFT                        _MK_SHIFT_CONST(8)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_8_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_8_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_8_RANGE                        8:8
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_8_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_8_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_8_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_8_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_8_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_9_SHIFT                        _MK_SHIFT_CONST(9)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_9_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_9_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_9_RANGE                        9:9
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_9_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_9_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_9_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_9_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_9_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_10_SHIFT                       _MK_SHIFT_CONST(10)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_10_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_10_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_10_RANGE                       10:10
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_10_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_10_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_10_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_10_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_10_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_11_SHIFT                       _MK_SHIFT_CONST(11)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_11_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_11_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_11_RANGE                       11:11
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_11_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_11_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_11_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_11_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_11_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_12_SHIFT                       _MK_SHIFT_CONST(12)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_12_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_12_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_12_RANGE                       12:12
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_12_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_12_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_12_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_12_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_12_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_13_SHIFT                       _MK_SHIFT_CONST(13)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_13_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_13_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_13_RANGE                       13:13
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_13_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_13_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_13_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_13_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_13_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_14_SHIFT                       _MK_SHIFT_CONST(14)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_14_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_14_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_14_RANGE                       14:14
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_14_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_14_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_14_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_14_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_14_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_15_SHIFT                       _MK_SHIFT_CONST(15)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_15_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_15_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_15_RANGE                       15:15
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_15_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_15_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_15_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_15_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_STI_15_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_4_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_4_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_4_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_4_RANGE                        27:27
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_4_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_4_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_4_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_4_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_4_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_0_SHIFT                        _MK_SHIFT_CONST(28)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_0_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_0_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_0_RANGE                        28:28
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_0_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_0_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_1_SHIFT                        _MK_SHIFT_CONST(29)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_1_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_1_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_1_RANGE                        29:29
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_1_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_1_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_1_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_2_SHIFT                        _MK_SHIFT_CONST(30)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_2_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_2_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_2_RANGE                        30:30
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_2_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_2_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_2_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_3_SHIFT                        _MK_SHIFT_CONST(31)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_3_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_3_SHIFT)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_3_RANGE                        31:31
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_3_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_3_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_3_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_3_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_0_0_PENDING_SET_PPI_3_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PENDING_SET_1_0  
#define FIC_DIST_PENDING_SET_1_0                        _MK_ADDR_CONST(0x1204)
#define FIC_DIST_PENDING_SET_1_0_SECURE                         0x0
#define FIC_DIST_PENDING_SET_1_0_WORD_COUNT                     0x1
#define FIC_DIST_PENDING_SET_1_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_SET_1_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_SET_1_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_0_SHIFT                        _MK_SHIFT_CONST(0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_0_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_0_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_0_RANGE                        0:0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_0_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_0_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_0_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_0_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_1_SHIFT                        _MK_SHIFT_CONST(1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_1_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_1_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_1_RANGE                        1:1
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_1_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_1_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_1_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_1_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_1_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_2_SHIFT                        _MK_SHIFT_CONST(2)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_2_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_2_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_2_RANGE                        2:2
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_2_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_2_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_2_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_2_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_2_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_3_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_3_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_3_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_3_RANGE                        3:3
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_3_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_3_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_3_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_3_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_3_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_4_SHIFT                        _MK_SHIFT_CONST(4)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_4_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_4_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_4_RANGE                        4:4
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_4_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_4_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_4_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_4_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_4_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_5_SHIFT                        _MK_SHIFT_CONST(5)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_5_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_5_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_5_RANGE                        5:5
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_5_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_5_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_5_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_5_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_5_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_6_SHIFT                        _MK_SHIFT_CONST(6)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_6_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_6_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_6_RANGE                        6:6
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_6_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_6_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_6_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_6_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_6_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_7_SHIFT                        _MK_SHIFT_CONST(7)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_7_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_7_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_7_RANGE                        7:7
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_7_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_7_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_7_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_7_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_7_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_8_SHIFT                        _MK_SHIFT_CONST(8)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_8_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_8_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_8_RANGE                        8:8
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_8_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_8_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_8_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_8_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_8_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_9_SHIFT                        _MK_SHIFT_CONST(9)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_9_FIELD                        (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_9_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_9_RANGE                        9:9
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_9_WOFFSET                      0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_9_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_9_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_9_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_9_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_10_SHIFT                       _MK_SHIFT_CONST(10)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_10_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_10_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_10_RANGE                       10:10
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_10_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_10_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_10_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_10_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_10_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_11_SHIFT                       _MK_SHIFT_CONST(11)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_11_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_11_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_11_RANGE                       11:11
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_11_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_11_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_11_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_11_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_11_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_12_SHIFT                       _MK_SHIFT_CONST(12)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_12_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_12_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_12_RANGE                       12:12
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_12_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_12_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_12_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_12_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_12_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_13_SHIFT                       _MK_SHIFT_CONST(13)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_13_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_13_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_13_RANGE                       13:13
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_13_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_13_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_13_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_13_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_13_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_14_SHIFT                       _MK_SHIFT_CONST(14)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_14_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_14_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_14_RANGE                       14:14
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_14_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_14_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_14_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_14_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_14_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_15_SHIFT                       _MK_SHIFT_CONST(15)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_15_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_15_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_15_RANGE                       15:15
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_15_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_15_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_15_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_15_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_15_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_16_SHIFT                       _MK_SHIFT_CONST(16)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_16_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_16_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_16_RANGE                       16:16
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_16_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_16_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_16_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_16_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_16_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_17_SHIFT                       _MK_SHIFT_CONST(17)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_17_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_17_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_17_RANGE                       17:17
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_17_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_17_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_17_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_17_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_17_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_18_SHIFT                       _MK_SHIFT_CONST(18)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_18_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_18_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_18_RANGE                       18:18
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_18_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_18_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_18_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_18_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_18_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_19_SHIFT                       _MK_SHIFT_CONST(19)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_19_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_19_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_19_RANGE                       19:19
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_19_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_19_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_19_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_19_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_19_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_20_SHIFT                       _MK_SHIFT_CONST(20)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_20_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_20_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_20_RANGE                       20:20
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_20_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_20_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_20_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_20_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_20_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_21_SHIFT                       _MK_SHIFT_CONST(21)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_21_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_21_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_21_RANGE                       21:21
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_21_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_21_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_21_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_21_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_21_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_22_SHIFT                       _MK_SHIFT_CONST(22)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_22_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_22_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_22_RANGE                       22:22
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_22_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_22_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_22_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_22_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_22_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_23_SHIFT                       _MK_SHIFT_CONST(23)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_23_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_23_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_23_RANGE                       23:23
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_23_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_23_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_23_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_23_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_23_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_24_SHIFT                       _MK_SHIFT_CONST(24)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_24_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_24_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_24_RANGE                       24:24
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_24_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_24_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_24_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_24_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_24_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_25_SHIFT                       _MK_SHIFT_CONST(25)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_25_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_25_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_25_RANGE                       25:25
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_25_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_25_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_25_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_25_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_25_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_26_SHIFT                       _MK_SHIFT_CONST(26)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_26_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_26_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_26_RANGE                       26:26
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_26_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_26_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_26_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_26_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_26_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_27_SHIFT                       _MK_SHIFT_CONST(27)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_27_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_27_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_27_RANGE                       27:27
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_27_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_27_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_27_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_27_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_27_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_28_SHIFT                       _MK_SHIFT_CONST(28)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_28_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_28_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_28_RANGE                       28:28
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_28_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_28_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_28_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_28_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_28_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_29_SHIFT                       _MK_SHIFT_CONST(29)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_29_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_29_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_29_RANGE                       29:29
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_29_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_29_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_29_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_29_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_29_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_30_SHIFT                       _MK_SHIFT_CONST(30)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_30_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_30_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_30_RANGE                       30:30
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_30_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_30_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_30_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_30_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_30_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_31_SHIFT                       _MK_SHIFT_CONST(31)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_31_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_31_SHIFT)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_31_RANGE                       31:31
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_31_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_31_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_31_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_31_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_1_0_PENDING_SET_SPI_31_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FIC_DIST_PENDING_SET_2_0  
#define FIC_DIST_PENDING_SET_2_0                        _MK_ADDR_CONST(0x1208)
#define FIC_DIST_PENDING_SET_2_0_SECURE                         0x0
#define FIC_DIST_PENDING_SET_2_0_WORD_COUNT                     0x1
#define FIC_DIST_PENDING_SET_2_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_SET_2_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_SET_2_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_32_SHIFT                       _MK_SHIFT_CONST(0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_32_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_32_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_32_RANGE                       0:0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_32_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_32_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_32_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_32_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_32_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_33_SHIFT                       _MK_SHIFT_CONST(1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_33_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_33_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_33_RANGE                       1:1
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_33_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_33_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_33_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_33_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_33_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_34_SHIFT                       _MK_SHIFT_CONST(2)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_34_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_34_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_34_RANGE                       2:2
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_34_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_34_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_34_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_34_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_34_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_35_SHIFT                       _MK_SHIFT_CONST(3)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_35_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_35_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_35_RANGE                       3:3
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_35_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_35_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_35_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_35_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_35_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_36_SHIFT                       _MK_SHIFT_CONST(4)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_36_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_36_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_36_RANGE                       4:4
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_36_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_36_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_36_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_36_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_36_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_37_SHIFT                       _MK_SHIFT_CONST(5)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_37_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_37_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_37_RANGE                       5:5
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_37_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_37_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_37_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_37_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_37_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_38_SHIFT                       _MK_SHIFT_CONST(6)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_38_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_38_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_38_RANGE                       6:6
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_38_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_38_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_38_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_38_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_38_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_39_SHIFT                       _MK_SHIFT_CONST(7)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_39_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_39_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_39_RANGE                       7:7
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_39_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_39_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_39_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_39_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_39_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_40_SHIFT                       _MK_SHIFT_CONST(8)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_40_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_40_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_40_RANGE                       8:8
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_40_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_40_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_40_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_40_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_40_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_41_SHIFT                       _MK_SHIFT_CONST(9)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_41_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_41_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_41_RANGE                       9:9
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_41_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_41_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_41_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_41_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_41_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_42_SHIFT                       _MK_SHIFT_CONST(10)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_42_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_42_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_42_RANGE                       10:10
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_42_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_42_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_42_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_42_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_42_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_43_SHIFT                       _MK_SHIFT_CONST(11)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_43_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_43_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_43_RANGE                       11:11
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_43_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_43_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_43_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_43_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_43_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_44_SHIFT                       _MK_SHIFT_CONST(12)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_44_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_44_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_44_RANGE                       12:12
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_44_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_44_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_44_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_44_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_44_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_45_SHIFT                       _MK_SHIFT_CONST(13)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_45_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_45_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_45_RANGE                       13:13
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_45_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_45_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_45_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_45_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_45_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_46_SHIFT                       _MK_SHIFT_CONST(14)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_46_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_46_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_46_RANGE                       14:14
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_46_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_46_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_46_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_46_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_46_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_47_SHIFT                       _MK_SHIFT_CONST(15)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_47_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_47_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_47_RANGE                       15:15
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_47_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_47_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_47_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_47_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_47_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_48_SHIFT                       _MK_SHIFT_CONST(16)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_48_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_48_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_48_RANGE                       16:16
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_48_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_48_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_48_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_48_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_48_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_49_SHIFT                       _MK_SHIFT_CONST(17)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_49_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_49_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_49_RANGE                       17:17
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_49_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_49_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_49_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_49_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_49_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_50_SHIFT                       _MK_SHIFT_CONST(18)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_50_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_50_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_50_RANGE                       18:18
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_50_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_50_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_50_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_50_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_50_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_51_SHIFT                       _MK_SHIFT_CONST(19)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_51_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_51_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_51_RANGE                       19:19
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_51_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_51_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_51_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_51_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_51_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_52_SHIFT                       _MK_SHIFT_CONST(20)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_52_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_52_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_52_RANGE                       20:20
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_52_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_52_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_52_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_52_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_52_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_53_SHIFT                       _MK_SHIFT_CONST(21)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_53_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_53_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_53_RANGE                       21:21
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_53_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_53_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_53_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_53_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_53_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_54_SHIFT                       _MK_SHIFT_CONST(22)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_54_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_54_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_54_RANGE                       22:22
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_54_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_54_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_54_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_54_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_54_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_55_SHIFT                       _MK_SHIFT_CONST(23)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_55_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_55_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_55_RANGE                       23:23
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_55_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_55_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_55_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_55_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_55_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_56_SHIFT                       _MK_SHIFT_CONST(24)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_56_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_56_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_56_RANGE                       24:24
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_56_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_56_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_56_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_56_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_56_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_57_SHIFT                       _MK_SHIFT_CONST(25)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_57_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_57_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_57_RANGE                       25:25
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_57_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_57_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_57_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_57_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_57_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_58_SHIFT                       _MK_SHIFT_CONST(26)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_58_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_58_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_58_RANGE                       26:26
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_58_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_58_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_58_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_58_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_58_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_59_SHIFT                       _MK_SHIFT_CONST(27)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_59_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_59_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_59_RANGE                       27:27
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_59_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_59_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_59_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_59_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_59_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_60_SHIFT                       _MK_SHIFT_CONST(28)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_60_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_60_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_60_RANGE                       28:28
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_60_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_60_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_60_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_60_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_60_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_61_SHIFT                       _MK_SHIFT_CONST(29)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_61_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_61_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_61_RANGE                       29:29
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_61_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_61_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_61_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_61_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_61_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_62_SHIFT                       _MK_SHIFT_CONST(30)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_62_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_62_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_62_RANGE                       30:30
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_62_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_62_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_62_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_62_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_62_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_63_SHIFT                       _MK_SHIFT_CONST(31)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_63_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_63_SHIFT)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_63_RANGE                       31:31
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_63_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_63_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_63_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_63_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_2_0_PENDING_SET_SPI_63_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FIC_DIST_PENDING_SET_3_0  
#define FIC_DIST_PENDING_SET_3_0                        _MK_ADDR_CONST(0x120c)
#define FIC_DIST_PENDING_SET_3_0_SECURE                         0x0
#define FIC_DIST_PENDING_SET_3_0_WORD_COUNT                     0x1
#define FIC_DIST_PENDING_SET_3_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_SET_3_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_SET_3_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_64_SHIFT                       _MK_SHIFT_CONST(0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_64_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_64_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_64_RANGE                       0:0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_64_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_64_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_64_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_64_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_64_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_65_SHIFT                       _MK_SHIFT_CONST(1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_65_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_65_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_65_RANGE                       1:1
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_65_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_65_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_65_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_65_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_65_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_66_SHIFT                       _MK_SHIFT_CONST(2)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_66_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_66_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_66_RANGE                       2:2
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_66_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_66_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_66_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_66_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_66_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_67_SHIFT                       _MK_SHIFT_CONST(3)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_67_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_67_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_67_RANGE                       3:3
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_67_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_67_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_67_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_67_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_67_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_68_SHIFT                       _MK_SHIFT_CONST(4)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_68_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_68_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_68_RANGE                       4:4
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_68_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_68_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_68_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_68_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_68_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_69_SHIFT                       _MK_SHIFT_CONST(5)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_69_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_69_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_69_RANGE                       5:5
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_69_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_69_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_69_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_69_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_69_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_70_SHIFT                       _MK_SHIFT_CONST(6)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_70_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_70_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_70_RANGE                       6:6
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_70_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_70_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_70_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_70_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_70_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_71_SHIFT                       _MK_SHIFT_CONST(7)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_71_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_71_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_71_RANGE                       7:7
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_71_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_71_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_71_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_71_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_71_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_72_SHIFT                       _MK_SHIFT_CONST(8)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_72_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_72_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_72_RANGE                       8:8
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_72_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_72_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_72_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_72_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_72_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_73_SHIFT                       _MK_SHIFT_CONST(9)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_73_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_73_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_73_RANGE                       9:9
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_73_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_73_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_73_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_73_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_73_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_74_SHIFT                       _MK_SHIFT_CONST(10)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_74_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_74_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_74_RANGE                       10:10
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_74_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_74_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_74_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_74_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_74_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_75_SHIFT                       _MK_SHIFT_CONST(11)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_75_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_75_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_75_RANGE                       11:11
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_75_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_75_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_75_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_75_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_75_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_76_SHIFT                       _MK_SHIFT_CONST(12)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_76_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_76_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_76_RANGE                       12:12
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_76_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_76_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_76_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_76_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_76_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_77_SHIFT                       _MK_SHIFT_CONST(13)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_77_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_77_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_77_RANGE                       13:13
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_77_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_77_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_77_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_77_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_77_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_78_SHIFT                       _MK_SHIFT_CONST(14)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_78_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_78_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_78_RANGE                       14:14
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_78_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_78_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_78_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_78_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_78_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_79_SHIFT                       _MK_SHIFT_CONST(15)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_79_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_79_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_79_RANGE                       15:15
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_79_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_79_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_79_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_79_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_79_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_80_SHIFT                       _MK_SHIFT_CONST(16)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_80_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_80_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_80_RANGE                       16:16
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_80_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_80_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_80_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_80_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_80_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_81_SHIFT                       _MK_SHIFT_CONST(17)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_81_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_81_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_81_RANGE                       17:17
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_81_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_81_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_81_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_81_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_81_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_82_SHIFT                       _MK_SHIFT_CONST(18)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_82_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_82_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_82_RANGE                       18:18
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_82_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_82_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_82_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_82_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_82_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_83_SHIFT                       _MK_SHIFT_CONST(19)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_83_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_83_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_83_RANGE                       19:19
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_83_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_83_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_83_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_83_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_83_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_84_SHIFT                       _MK_SHIFT_CONST(20)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_84_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_84_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_84_RANGE                       20:20
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_84_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_84_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_84_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_84_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_84_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_85_SHIFT                       _MK_SHIFT_CONST(21)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_85_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_85_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_85_RANGE                       21:21
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_85_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_85_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_85_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_85_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_85_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_86_SHIFT                       _MK_SHIFT_CONST(22)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_86_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_86_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_86_RANGE                       22:22
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_86_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_86_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_86_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_86_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_86_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_87_SHIFT                       _MK_SHIFT_CONST(23)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_87_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_87_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_87_RANGE                       23:23
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_87_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_87_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_87_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_87_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_87_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_88_SHIFT                       _MK_SHIFT_CONST(24)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_88_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_88_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_88_RANGE                       24:24
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_88_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_88_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_88_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_88_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_88_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_89_SHIFT                       _MK_SHIFT_CONST(25)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_89_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_89_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_89_RANGE                       25:25
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_89_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_89_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_89_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_89_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_89_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_90_SHIFT                       _MK_SHIFT_CONST(26)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_90_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_90_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_90_RANGE                       26:26
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_90_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_90_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_90_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_90_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_90_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_91_SHIFT                       _MK_SHIFT_CONST(27)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_91_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_91_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_91_RANGE                       27:27
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_91_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_91_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_91_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_91_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_91_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_92_SHIFT                       _MK_SHIFT_CONST(28)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_92_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_92_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_92_RANGE                       28:28
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_92_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_92_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_92_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_92_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_92_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_93_SHIFT                       _MK_SHIFT_CONST(29)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_93_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_93_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_93_RANGE                       29:29
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_93_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_93_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_93_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_93_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_93_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_94_SHIFT                       _MK_SHIFT_CONST(30)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_94_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_94_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_94_RANGE                       30:30
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_94_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_94_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_94_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_94_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_94_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_95_SHIFT                       _MK_SHIFT_CONST(31)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_95_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_95_SHIFT)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_95_RANGE                       31:31
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_95_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_95_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_95_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_95_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_3_0_PENDING_SET_SPI_95_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FIC_DIST_PENDING_SET_4_0  
#define FIC_DIST_PENDING_SET_4_0                        _MK_ADDR_CONST(0x1210)
#define FIC_DIST_PENDING_SET_4_0_SECURE                         0x0
#define FIC_DIST_PENDING_SET_4_0_WORD_COUNT                     0x1
#define FIC_DIST_PENDING_SET_4_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_SET_4_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_SET_4_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_96_SHIFT                       _MK_SHIFT_CONST(0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_96_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_96_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_96_RANGE                       0:0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_96_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_96_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_96_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_96_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_96_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_97_SHIFT                       _MK_SHIFT_CONST(1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_97_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_97_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_97_RANGE                       1:1
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_97_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_97_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_97_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_97_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_97_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_98_SHIFT                       _MK_SHIFT_CONST(2)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_98_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_98_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_98_RANGE                       2:2
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_98_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_98_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_98_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_98_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_98_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_99_SHIFT                       _MK_SHIFT_CONST(3)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_99_FIELD                       (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_99_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_99_RANGE                       3:3
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_99_WOFFSET                     0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_99_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_99_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_99_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_99_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_100_SHIFT                      _MK_SHIFT_CONST(4)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_100_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_100_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_100_RANGE                      4:4
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_100_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_100_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_100_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_100_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_100_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_101_SHIFT                      _MK_SHIFT_CONST(5)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_101_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_101_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_101_RANGE                      5:5
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_101_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_101_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_101_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_101_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_101_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_102_SHIFT                      _MK_SHIFT_CONST(6)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_102_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_102_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_102_RANGE                      6:6
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_102_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_102_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_102_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_102_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_102_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_103_SHIFT                      _MK_SHIFT_CONST(7)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_103_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_103_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_103_RANGE                      7:7
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_103_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_103_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_103_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_103_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_103_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_104_SHIFT                      _MK_SHIFT_CONST(8)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_104_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_104_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_104_RANGE                      8:8
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_104_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_104_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_104_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_104_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_104_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_105_SHIFT                      _MK_SHIFT_CONST(9)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_105_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_105_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_105_RANGE                      9:9
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_105_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_105_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_105_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_105_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_105_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_106_SHIFT                      _MK_SHIFT_CONST(10)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_106_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_106_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_106_RANGE                      10:10
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_106_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_106_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_106_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_106_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_106_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_107_SHIFT                      _MK_SHIFT_CONST(11)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_107_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_107_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_107_RANGE                      11:11
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_107_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_107_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_107_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_107_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_107_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_108_SHIFT                      _MK_SHIFT_CONST(12)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_108_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_108_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_108_RANGE                      12:12
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_108_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_108_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_108_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_108_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_108_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_109_SHIFT                      _MK_SHIFT_CONST(13)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_109_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_109_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_109_RANGE                      13:13
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_109_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_109_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_109_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_109_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_109_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_110_SHIFT                      _MK_SHIFT_CONST(14)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_110_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_110_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_110_RANGE                      14:14
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_110_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_110_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_110_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_110_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_110_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_111_SHIFT                      _MK_SHIFT_CONST(15)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_111_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_111_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_111_RANGE                      15:15
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_111_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_111_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_111_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_111_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_111_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_112_SHIFT                      _MK_SHIFT_CONST(16)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_112_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_112_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_112_RANGE                      16:16
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_112_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_112_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_112_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_112_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_112_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_113_SHIFT                      _MK_SHIFT_CONST(17)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_113_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_113_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_113_RANGE                      17:17
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_113_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_113_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_113_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_113_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_113_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_114_SHIFT                      _MK_SHIFT_CONST(18)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_114_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_114_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_114_RANGE                      18:18
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_114_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_114_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_114_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_114_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_114_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_115_SHIFT                      _MK_SHIFT_CONST(19)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_115_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_115_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_115_RANGE                      19:19
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_115_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_115_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_115_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_115_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_115_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_116_SHIFT                      _MK_SHIFT_CONST(20)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_116_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_116_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_116_RANGE                      20:20
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_116_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_116_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_116_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_116_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_116_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_117_SHIFT                      _MK_SHIFT_CONST(21)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_117_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_117_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_117_RANGE                      21:21
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_117_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_117_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_117_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_117_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_117_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_118_SHIFT                      _MK_SHIFT_CONST(22)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_118_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_118_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_118_RANGE                      22:22
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_118_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_118_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_118_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_118_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_118_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_119_SHIFT                      _MK_SHIFT_CONST(23)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_119_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_119_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_119_RANGE                      23:23
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_119_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_119_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_119_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_119_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_119_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_120_SHIFT                      _MK_SHIFT_CONST(24)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_120_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_120_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_120_RANGE                      24:24
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_120_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_120_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_120_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_120_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_120_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_121_SHIFT                      _MK_SHIFT_CONST(25)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_121_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_121_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_121_RANGE                      25:25
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_121_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_121_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_121_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_121_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_121_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_122_SHIFT                      _MK_SHIFT_CONST(26)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_122_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_122_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_122_RANGE                      26:26
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_122_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_122_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_122_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_122_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_122_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_123_SHIFT                      _MK_SHIFT_CONST(27)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_123_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_123_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_123_RANGE                      27:27
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_123_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_123_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_123_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_123_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_123_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_124_SHIFT                      _MK_SHIFT_CONST(28)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_124_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_124_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_124_RANGE                      28:28
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_124_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_124_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_124_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_124_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_124_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_125_SHIFT                      _MK_SHIFT_CONST(29)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_125_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_125_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_125_RANGE                      29:29
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_125_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_125_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_125_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_125_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_125_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_126_SHIFT                      _MK_SHIFT_CONST(30)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_126_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_126_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_126_RANGE                      30:30
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_126_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_126_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_126_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_126_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_126_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_127_SHIFT                      _MK_SHIFT_CONST(31)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_127_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_127_SHIFT)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_127_RANGE                      31:31
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_127_WOFFSET                    0x0
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_127_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_127_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_127_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_SET_4_0_PENDING_SET_SPI_127_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Reserved address 4628 [0x1214] 

// Reserved address 4632 [0x1218] 

// Reserved address 4636 [0x121c] 

// Reserved address 4640 [0x1220] 

// Reserved address 4644 [0x1224] 

// Reserved address 4648 [0x1228] 

// Reserved address 4652 [0x122c] 

// Reserved address 4656 [0x1230] 

// Reserved address 4660 [0x1234] 

// Reserved address 4664 [0x1238] 

// Reserved address 4668 [0x123c] 

// Reserved address 4672 [0x1240] 

// Reserved address 4676 [0x1244] 

// Reserved address 4680 [0x1248] 

// Reserved address 4684 [0x124c] 

// Reserved address 4688 [0x1250] 

// Reserved address 4692 [0x1254] 

// Reserved address 4696 [0x1258] 

// Reserved address 4700 [0x125c] 

// Reserved address 4704 [0x1260] 

// Reserved address 4708 [0x1264] 

// Reserved address 4712 [0x1268] 

// Reserved address 4716 [0x126c] 

// Reserved address 4720 [0x1270] 

// Reserved address 4724 [0x1274] 

// Reserved address 4728 [0x1278] 

// Reserved address 4732 [0x127c] 

// Register FIC_DIST_PENDING_CLEAR_0_0  
#define FIC_DIST_PENDING_CLEAR_0_0                      _MK_ADDR_CONST(0x1280)
#define FIC_DIST_PENDING_CLEAR_0_0_SECURE                       0x0
#define FIC_DIST_PENDING_CLEAR_0_0_WORD_COUNT                   0x1
#define FIC_DIST_PENDING_CLEAR_0_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_RESET_MASK                   _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_PENDING_CLEAR_0_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_READ_MASK                    _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_PENDING_CLEAR_0_0_WRITE_MASK                   _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_0_SHIFT                      _MK_SHIFT_CONST(0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_0_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_0_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_0_RANGE                      0:0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_0_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_1_SHIFT                      _MK_SHIFT_CONST(1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_1_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_1_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_1_RANGE                      1:1
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_1_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_1_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_2_SHIFT                      _MK_SHIFT_CONST(2)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_2_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_2_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_2_RANGE                      2:2
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_2_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_2_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_3_SHIFT                      _MK_SHIFT_CONST(3)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_3_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_3_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_3_RANGE                      3:3
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_3_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_3_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_4_SHIFT                      _MK_SHIFT_CONST(4)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_4_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_4_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_4_RANGE                      4:4
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_4_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_4_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_4_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_5_SHIFT                      _MK_SHIFT_CONST(5)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_5_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_5_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_5_RANGE                      5:5
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_5_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_5_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_5_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_6_SHIFT                      _MK_SHIFT_CONST(6)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_6_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_6_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_6_RANGE                      6:6
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_6_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_6_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_6_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_7_SHIFT                      _MK_SHIFT_CONST(7)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_7_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_7_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_7_RANGE                      7:7
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_7_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_7_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_7_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_8_SHIFT                      _MK_SHIFT_CONST(8)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_8_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_8_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_8_RANGE                      8:8
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_8_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_8_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_8_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_8_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_8_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_9_SHIFT                      _MK_SHIFT_CONST(9)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_9_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_9_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_9_RANGE                      9:9
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_9_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_9_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_9_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_9_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_9_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_10_SHIFT                     _MK_SHIFT_CONST(10)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_10_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_10_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_10_RANGE                     10:10
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_10_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_10_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_10_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_10_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_10_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_11_SHIFT                     _MK_SHIFT_CONST(11)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_11_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_11_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_11_RANGE                     11:11
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_11_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_11_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_11_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_11_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_11_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_12_SHIFT                     _MK_SHIFT_CONST(12)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_12_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_12_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_12_RANGE                     12:12
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_12_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_12_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_12_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_12_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_12_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_13_SHIFT                     _MK_SHIFT_CONST(13)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_13_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_13_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_13_RANGE                     13:13
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_13_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_13_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_13_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_13_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_13_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_14_SHIFT                     _MK_SHIFT_CONST(14)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_14_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_14_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_14_RANGE                     14:14
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_14_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_14_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_14_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_14_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_14_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_15_SHIFT                     _MK_SHIFT_CONST(15)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_15_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_15_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_15_RANGE                     15:15
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_15_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_15_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_15_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_15_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_STI_15_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_4_SHIFT                      _MK_SHIFT_CONST(27)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_4_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_4_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_4_RANGE                      27:27
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_4_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_4_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_4_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_0_SHIFT                      _MK_SHIFT_CONST(28)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_0_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_0_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_0_RANGE                      28:28
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_0_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_1_SHIFT                      _MK_SHIFT_CONST(29)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_1_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_1_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_1_RANGE                      29:29
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_1_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_1_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_2_SHIFT                      _MK_SHIFT_CONST(30)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_2_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_2_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_2_RANGE                      30:30
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_2_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_2_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_3_SHIFT                      _MK_SHIFT_CONST(31)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_3_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_3_SHIFT)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_3_RANGE                      31:31
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_3_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_3_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_0_0_PENDING_CLR_PPI_3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register FIC_DIST_PENDING_CLEAR_1_0  
#define FIC_DIST_PENDING_CLEAR_1_0                      _MK_ADDR_CONST(0x1284)
#define FIC_DIST_PENDING_CLEAR_1_0_SECURE                       0x0
#define FIC_DIST_PENDING_CLEAR_1_0_WORD_COUNT                   0x1
#define FIC_DIST_PENDING_CLEAR_1_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_CLEAR_1_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_CLEAR_1_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_0_SHIFT                      _MK_SHIFT_CONST(0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_0_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_0_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_0_RANGE                      0:0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_0_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_0_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_0_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_0_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_1_SHIFT                      _MK_SHIFT_CONST(1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_1_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_1_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_1_RANGE                      1:1
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_1_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_1_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_1_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_1_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_1_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_2_SHIFT                      _MK_SHIFT_CONST(2)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_2_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_2_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_2_RANGE                      2:2
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_2_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_2_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_2_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_2_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_2_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_3_SHIFT                      _MK_SHIFT_CONST(3)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_3_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_3_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_3_RANGE                      3:3
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_3_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_3_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_3_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_3_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_3_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_4_SHIFT                      _MK_SHIFT_CONST(4)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_4_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_4_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_4_RANGE                      4:4
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_4_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_4_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_4_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_4_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_4_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_5_SHIFT                      _MK_SHIFT_CONST(5)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_5_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_5_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_5_RANGE                      5:5
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_5_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_5_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_5_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_5_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_5_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_6_SHIFT                      _MK_SHIFT_CONST(6)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_6_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_6_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_6_RANGE                      6:6
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_6_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_6_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_6_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_6_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_6_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_7_SHIFT                      _MK_SHIFT_CONST(7)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_7_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_7_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_7_RANGE                      7:7
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_7_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_7_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_7_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_7_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_7_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_8_SHIFT                      _MK_SHIFT_CONST(8)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_8_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_8_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_8_RANGE                      8:8
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_8_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_8_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_8_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_8_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_8_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_9_SHIFT                      _MK_SHIFT_CONST(9)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_9_FIELD                      (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_9_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_9_RANGE                      9:9
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_9_WOFFSET                    0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_9_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_9_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_9_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_9_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_10_SHIFT                     _MK_SHIFT_CONST(10)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_10_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_10_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_10_RANGE                     10:10
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_10_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_10_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_10_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_10_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_10_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_11_SHIFT                     _MK_SHIFT_CONST(11)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_11_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_11_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_11_RANGE                     11:11
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_11_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_11_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_11_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_11_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_11_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_12_SHIFT                     _MK_SHIFT_CONST(12)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_12_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_12_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_12_RANGE                     12:12
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_12_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_12_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_12_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_12_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_12_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_13_SHIFT                     _MK_SHIFT_CONST(13)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_13_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_13_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_13_RANGE                     13:13
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_13_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_13_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_13_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_13_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_13_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_14_SHIFT                     _MK_SHIFT_CONST(14)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_14_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_14_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_14_RANGE                     14:14
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_14_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_14_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_14_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_14_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_14_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_15_SHIFT                     _MK_SHIFT_CONST(15)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_15_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_15_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_15_RANGE                     15:15
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_15_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_15_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_15_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_15_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_15_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_16_SHIFT                     _MK_SHIFT_CONST(16)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_16_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_16_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_16_RANGE                     16:16
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_16_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_16_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_16_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_16_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_16_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_17_SHIFT                     _MK_SHIFT_CONST(17)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_17_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_17_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_17_RANGE                     17:17
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_17_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_17_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_17_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_17_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_17_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_18_SHIFT                     _MK_SHIFT_CONST(18)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_18_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_18_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_18_RANGE                     18:18
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_18_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_18_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_18_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_18_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_18_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_19_SHIFT                     _MK_SHIFT_CONST(19)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_19_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_19_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_19_RANGE                     19:19
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_19_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_19_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_19_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_19_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_19_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_20_SHIFT                     _MK_SHIFT_CONST(20)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_20_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_20_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_20_RANGE                     20:20
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_20_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_20_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_20_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_20_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_20_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_21_SHIFT                     _MK_SHIFT_CONST(21)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_21_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_21_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_21_RANGE                     21:21
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_21_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_21_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_21_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_21_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_21_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_22_SHIFT                     _MK_SHIFT_CONST(22)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_22_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_22_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_22_RANGE                     22:22
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_22_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_22_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_22_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_22_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_22_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_23_SHIFT                     _MK_SHIFT_CONST(23)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_23_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_23_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_23_RANGE                     23:23
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_23_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_23_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_23_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_23_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_23_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_24_SHIFT                     _MK_SHIFT_CONST(24)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_24_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_24_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_24_RANGE                     24:24
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_24_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_24_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_24_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_24_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_24_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_25_SHIFT                     _MK_SHIFT_CONST(25)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_25_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_25_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_25_RANGE                     25:25
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_25_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_25_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_25_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_25_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_25_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_26_SHIFT                     _MK_SHIFT_CONST(26)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_26_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_26_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_26_RANGE                     26:26
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_26_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_26_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_26_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_26_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_26_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_27_SHIFT                     _MK_SHIFT_CONST(27)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_27_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_27_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_27_RANGE                     27:27
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_27_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_27_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_27_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_27_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_27_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_28_SHIFT                     _MK_SHIFT_CONST(28)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_28_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_28_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_28_RANGE                     28:28
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_28_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_28_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_28_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_28_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_28_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_29_SHIFT                     _MK_SHIFT_CONST(29)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_29_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_29_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_29_RANGE                     29:29
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_29_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_29_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_29_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_29_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_29_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_30_SHIFT                     _MK_SHIFT_CONST(30)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_30_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_30_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_30_RANGE                     30:30
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_30_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_30_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_30_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_30_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_30_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_31_SHIFT                     _MK_SHIFT_CONST(31)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_31_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_31_SHIFT)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_31_RANGE                     31:31
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_31_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_31_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_31_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_31_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_1_0_PENDING_CLR_SPI_31_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FIC_DIST_PENDING_CLEAR_2_0  
#define FIC_DIST_PENDING_CLEAR_2_0                      _MK_ADDR_CONST(0x1288)
#define FIC_DIST_PENDING_CLEAR_2_0_SECURE                       0x0
#define FIC_DIST_PENDING_CLEAR_2_0_WORD_COUNT                   0x1
#define FIC_DIST_PENDING_CLEAR_2_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_CLEAR_2_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_CLEAR_2_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_32_SHIFT                     _MK_SHIFT_CONST(0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_32_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_32_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_32_RANGE                     0:0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_32_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_32_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_32_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_32_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_32_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_33_SHIFT                     _MK_SHIFT_CONST(1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_33_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_33_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_33_RANGE                     1:1
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_33_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_33_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_33_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_33_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_33_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_34_SHIFT                     _MK_SHIFT_CONST(2)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_34_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_34_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_34_RANGE                     2:2
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_34_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_34_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_34_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_34_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_34_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_35_SHIFT                     _MK_SHIFT_CONST(3)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_35_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_35_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_35_RANGE                     3:3
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_35_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_35_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_35_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_35_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_35_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_36_SHIFT                     _MK_SHIFT_CONST(4)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_36_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_36_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_36_RANGE                     4:4
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_36_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_36_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_36_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_36_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_36_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_37_SHIFT                     _MK_SHIFT_CONST(5)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_37_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_37_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_37_RANGE                     5:5
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_37_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_37_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_37_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_37_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_37_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_38_SHIFT                     _MK_SHIFT_CONST(6)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_38_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_38_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_38_RANGE                     6:6
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_38_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_38_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_38_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_38_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_38_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_39_SHIFT                     _MK_SHIFT_CONST(7)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_39_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_39_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_39_RANGE                     7:7
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_39_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_39_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_39_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_39_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_39_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_40_SHIFT                     _MK_SHIFT_CONST(8)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_40_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_40_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_40_RANGE                     8:8
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_40_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_40_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_40_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_40_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_40_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_41_SHIFT                     _MK_SHIFT_CONST(9)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_41_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_41_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_41_RANGE                     9:9
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_41_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_41_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_41_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_41_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_41_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_42_SHIFT                     _MK_SHIFT_CONST(10)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_42_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_42_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_42_RANGE                     10:10
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_42_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_42_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_42_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_42_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_42_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_43_SHIFT                     _MK_SHIFT_CONST(11)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_43_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_43_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_43_RANGE                     11:11
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_43_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_43_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_43_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_43_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_43_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_44_SHIFT                     _MK_SHIFT_CONST(12)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_44_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_44_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_44_RANGE                     12:12
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_44_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_44_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_44_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_44_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_44_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_45_SHIFT                     _MK_SHIFT_CONST(13)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_45_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_45_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_45_RANGE                     13:13
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_45_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_45_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_45_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_45_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_45_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_46_SHIFT                     _MK_SHIFT_CONST(14)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_46_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_46_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_46_RANGE                     14:14
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_46_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_46_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_46_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_46_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_46_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_47_SHIFT                     _MK_SHIFT_CONST(15)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_47_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_47_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_47_RANGE                     15:15
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_47_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_47_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_47_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_47_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_47_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_48_SHIFT                     _MK_SHIFT_CONST(16)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_48_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_48_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_48_RANGE                     16:16
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_48_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_48_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_48_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_48_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_48_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_49_SHIFT                     _MK_SHIFT_CONST(17)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_49_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_49_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_49_RANGE                     17:17
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_49_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_49_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_49_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_49_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_49_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_50_SHIFT                     _MK_SHIFT_CONST(18)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_50_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_50_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_50_RANGE                     18:18
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_50_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_50_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_50_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_50_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_50_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_51_SHIFT                     _MK_SHIFT_CONST(19)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_51_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_51_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_51_RANGE                     19:19
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_51_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_51_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_51_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_51_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_51_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_52_SHIFT                     _MK_SHIFT_CONST(20)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_52_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_52_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_52_RANGE                     20:20
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_52_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_52_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_52_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_52_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_52_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_53_SHIFT                     _MK_SHIFT_CONST(21)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_53_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_53_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_53_RANGE                     21:21
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_53_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_53_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_53_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_53_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_53_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_54_SHIFT                     _MK_SHIFT_CONST(22)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_54_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_54_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_54_RANGE                     22:22
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_54_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_54_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_54_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_54_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_54_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_55_SHIFT                     _MK_SHIFT_CONST(23)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_55_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_55_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_55_RANGE                     23:23
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_55_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_55_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_55_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_55_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_55_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_56_SHIFT                     _MK_SHIFT_CONST(24)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_56_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_56_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_56_RANGE                     24:24
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_56_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_56_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_56_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_56_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_56_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_57_SHIFT                     _MK_SHIFT_CONST(25)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_57_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_57_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_57_RANGE                     25:25
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_57_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_57_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_57_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_57_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_57_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_58_SHIFT                     _MK_SHIFT_CONST(26)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_58_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_58_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_58_RANGE                     26:26
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_58_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_58_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_58_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_58_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_58_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_59_SHIFT                     _MK_SHIFT_CONST(27)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_59_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_59_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_59_RANGE                     27:27
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_59_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_59_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_59_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_59_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_59_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_60_SHIFT                     _MK_SHIFT_CONST(28)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_60_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_60_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_60_RANGE                     28:28
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_60_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_60_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_60_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_60_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_60_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_61_SHIFT                     _MK_SHIFT_CONST(29)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_61_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_61_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_61_RANGE                     29:29
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_61_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_61_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_61_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_61_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_61_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_62_SHIFT                     _MK_SHIFT_CONST(30)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_62_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_62_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_62_RANGE                     30:30
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_62_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_62_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_62_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_62_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_62_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_63_SHIFT                     _MK_SHIFT_CONST(31)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_63_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_63_SHIFT)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_63_RANGE                     31:31
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_63_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_63_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_63_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_63_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_2_0_PENDING_CLR_SPI_63_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FIC_DIST_PENDING_CLEAR_3_0  
#define FIC_DIST_PENDING_CLEAR_3_0                      _MK_ADDR_CONST(0x128c)
#define FIC_DIST_PENDING_CLEAR_3_0_SECURE                       0x0
#define FIC_DIST_PENDING_CLEAR_3_0_WORD_COUNT                   0x1
#define FIC_DIST_PENDING_CLEAR_3_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_CLEAR_3_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_CLEAR_3_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_64_SHIFT                     _MK_SHIFT_CONST(0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_64_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_64_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_64_RANGE                     0:0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_64_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_64_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_64_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_64_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_64_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_65_SHIFT                     _MK_SHIFT_CONST(1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_65_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_65_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_65_RANGE                     1:1
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_65_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_65_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_65_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_65_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_65_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_66_SHIFT                     _MK_SHIFT_CONST(2)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_66_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_66_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_66_RANGE                     2:2
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_66_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_66_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_66_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_66_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_66_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_67_SHIFT                     _MK_SHIFT_CONST(3)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_67_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_67_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_67_RANGE                     3:3
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_67_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_67_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_67_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_67_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_67_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_68_SHIFT                     _MK_SHIFT_CONST(4)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_68_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_68_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_68_RANGE                     4:4
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_68_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_68_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_68_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_68_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_68_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_69_SHIFT                     _MK_SHIFT_CONST(5)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_69_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_69_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_69_RANGE                     5:5
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_69_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_69_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_69_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_69_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_69_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_70_SHIFT                     _MK_SHIFT_CONST(6)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_70_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_70_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_70_RANGE                     6:6
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_70_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_70_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_70_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_70_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_70_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_71_SHIFT                     _MK_SHIFT_CONST(7)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_71_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_71_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_71_RANGE                     7:7
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_71_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_71_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_71_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_71_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_71_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_72_SHIFT                     _MK_SHIFT_CONST(8)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_72_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_72_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_72_RANGE                     8:8
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_72_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_72_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_72_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_72_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_72_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_73_SHIFT                     _MK_SHIFT_CONST(9)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_73_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_73_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_73_RANGE                     9:9
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_73_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_73_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_73_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_73_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_73_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_74_SHIFT                     _MK_SHIFT_CONST(10)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_74_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_74_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_74_RANGE                     10:10
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_74_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_74_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_74_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_74_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_74_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_75_SHIFT                     _MK_SHIFT_CONST(11)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_75_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_75_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_75_RANGE                     11:11
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_75_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_75_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_75_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_75_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_75_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_76_SHIFT                     _MK_SHIFT_CONST(12)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_76_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_76_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_76_RANGE                     12:12
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_76_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_76_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_76_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_76_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_76_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_77_SHIFT                     _MK_SHIFT_CONST(13)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_77_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_77_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_77_RANGE                     13:13
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_77_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_77_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_77_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_77_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_77_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_78_SHIFT                     _MK_SHIFT_CONST(14)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_78_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_78_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_78_RANGE                     14:14
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_78_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_78_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_78_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_78_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_78_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_79_SHIFT                     _MK_SHIFT_CONST(15)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_79_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_79_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_79_RANGE                     15:15
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_79_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_79_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_79_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_79_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_79_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_80_SHIFT                     _MK_SHIFT_CONST(16)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_80_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_80_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_80_RANGE                     16:16
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_80_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_80_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_80_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_80_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_80_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_81_SHIFT                     _MK_SHIFT_CONST(17)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_81_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_81_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_81_RANGE                     17:17
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_81_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_81_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_81_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_81_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_81_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_82_SHIFT                     _MK_SHIFT_CONST(18)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_82_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_82_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_82_RANGE                     18:18
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_82_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_82_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_82_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_82_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_82_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_83_SHIFT                     _MK_SHIFT_CONST(19)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_83_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_83_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_83_RANGE                     19:19
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_83_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_83_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_83_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_83_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_83_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_84_SHIFT                     _MK_SHIFT_CONST(20)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_84_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_84_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_84_RANGE                     20:20
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_84_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_84_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_84_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_84_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_84_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_85_SHIFT                     _MK_SHIFT_CONST(21)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_85_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_85_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_85_RANGE                     21:21
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_85_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_85_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_85_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_85_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_85_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_86_SHIFT                     _MK_SHIFT_CONST(22)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_86_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_86_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_86_RANGE                     22:22
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_86_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_86_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_86_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_86_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_86_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_87_SHIFT                     _MK_SHIFT_CONST(23)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_87_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_87_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_87_RANGE                     23:23
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_87_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_87_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_87_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_87_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_87_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_88_SHIFT                     _MK_SHIFT_CONST(24)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_88_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_88_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_88_RANGE                     24:24
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_88_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_88_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_88_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_88_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_88_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_89_SHIFT                     _MK_SHIFT_CONST(25)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_89_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_89_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_89_RANGE                     25:25
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_89_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_89_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_89_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_89_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_89_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_90_SHIFT                     _MK_SHIFT_CONST(26)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_90_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_90_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_90_RANGE                     26:26
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_90_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_90_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_90_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_90_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_90_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_91_SHIFT                     _MK_SHIFT_CONST(27)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_91_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_91_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_91_RANGE                     27:27
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_91_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_91_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_91_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_91_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_91_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_92_SHIFT                     _MK_SHIFT_CONST(28)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_92_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_92_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_92_RANGE                     28:28
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_92_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_92_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_92_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_92_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_92_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_93_SHIFT                     _MK_SHIFT_CONST(29)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_93_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_93_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_93_RANGE                     29:29
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_93_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_93_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_93_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_93_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_93_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_94_SHIFT                     _MK_SHIFT_CONST(30)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_94_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_94_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_94_RANGE                     30:30
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_94_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_94_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_94_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_94_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_94_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_95_SHIFT                     _MK_SHIFT_CONST(31)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_95_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_95_SHIFT)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_95_RANGE                     31:31
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_95_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_95_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_95_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_95_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_3_0_PENDING_CLR_SPI_95_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FIC_DIST_PENDING_CLEAR_4_0  
#define FIC_DIST_PENDING_CLEAR_4_0                      _MK_ADDR_CONST(0x1290)
#define FIC_DIST_PENDING_CLEAR_4_0_SECURE                       0x0
#define FIC_DIST_PENDING_CLEAR_4_0_WORD_COUNT                   0x1
#define FIC_DIST_PENDING_CLEAR_4_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_CLEAR_4_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_CLEAR_4_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_96_SHIFT                     _MK_SHIFT_CONST(0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_96_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_96_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_96_RANGE                     0:0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_96_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_96_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_96_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_96_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_96_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_97_SHIFT                     _MK_SHIFT_CONST(1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_97_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_97_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_97_RANGE                     1:1
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_97_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_97_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_97_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_97_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_97_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_98_SHIFT                     _MK_SHIFT_CONST(2)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_98_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_98_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_98_RANGE                     2:2
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_98_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_98_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_98_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_98_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_98_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_99_SHIFT                     _MK_SHIFT_CONST(3)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_99_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_99_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_99_RANGE                     3:3
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_99_WOFFSET                   0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_99_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_99_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_99_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_99_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_100_SHIFT                    _MK_SHIFT_CONST(4)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_100_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_100_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_100_RANGE                    4:4
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_100_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_100_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_100_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_100_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_100_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_101_SHIFT                    _MK_SHIFT_CONST(5)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_101_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_101_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_101_RANGE                    5:5
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_101_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_101_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_101_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_101_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_101_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_102_SHIFT                    _MK_SHIFT_CONST(6)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_102_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_102_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_102_RANGE                    6:6
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_102_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_102_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_102_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_102_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_102_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_103_SHIFT                    _MK_SHIFT_CONST(7)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_103_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_103_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_103_RANGE                    7:7
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_103_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_103_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_103_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_103_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_103_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_104_SHIFT                    _MK_SHIFT_CONST(8)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_104_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_104_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_104_RANGE                    8:8
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_104_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_104_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_104_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_104_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_104_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_105_SHIFT                    _MK_SHIFT_CONST(9)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_105_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_105_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_105_RANGE                    9:9
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_105_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_105_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_105_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_105_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_105_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_106_SHIFT                    _MK_SHIFT_CONST(10)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_106_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_106_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_106_RANGE                    10:10
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_106_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_106_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_106_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_106_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_106_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_107_SHIFT                    _MK_SHIFT_CONST(11)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_107_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_107_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_107_RANGE                    11:11
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_107_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_107_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_107_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_107_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_107_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_108_SHIFT                    _MK_SHIFT_CONST(12)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_108_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_108_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_108_RANGE                    12:12
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_108_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_108_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_108_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_108_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_108_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_109_SHIFT                    _MK_SHIFT_CONST(13)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_109_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_109_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_109_RANGE                    13:13
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_109_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_109_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_109_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_109_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_109_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_110_SHIFT                    _MK_SHIFT_CONST(14)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_110_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_110_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_110_RANGE                    14:14
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_110_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_110_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_110_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_110_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_110_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_111_SHIFT                    _MK_SHIFT_CONST(15)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_111_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_111_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_111_RANGE                    15:15
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_111_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_111_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_111_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_111_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_111_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_112_SHIFT                    _MK_SHIFT_CONST(16)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_112_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_112_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_112_RANGE                    16:16
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_112_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_112_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_112_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_112_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_112_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_113_SHIFT                    _MK_SHIFT_CONST(17)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_113_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_113_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_113_RANGE                    17:17
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_113_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_113_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_113_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_113_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_113_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_114_SHIFT                    _MK_SHIFT_CONST(18)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_114_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_114_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_114_RANGE                    18:18
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_114_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_114_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_114_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_114_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_114_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_115_SHIFT                    _MK_SHIFT_CONST(19)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_115_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_115_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_115_RANGE                    19:19
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_115_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_115_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_115_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_115_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_115_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_116_SHIFT                    _MK_SHIFT_CONST(20)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_116_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_116_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_116_RANGE                    20:20
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_116_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_116_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_116_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_116_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_116_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_117_SHIFT                    _MK_SHIFT_CONST(21)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_117_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_117_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_117_RANGE                    21:21
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_117_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_117_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_117_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_117_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_117_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_118_SHIFT                    _MK_SHIFT_CONST(22)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_118_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_118_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_118_RANGE                    22:22
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_118_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_118_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_118_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_118_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_118_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_119_SHIFT                    _MK_SHIFT_CONST(23)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_119_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_119_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_119_RANGE                    23:23
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_119_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_119_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_119_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_119_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_119_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_120_SHIFT                    _MK_SHIFT_CONST(24)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_120_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_120_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_120_RANGE                    24:24
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_120_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_120_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_120_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_120_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_120_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_121_SHIFT                    _MK_SHIFT_CONST(25)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_121_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_121_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_121_RANGE                    25:25
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_121_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_121_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_121_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_121_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_121_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_122_SHIFT                    _MK_SHIFT_CONST(26)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_122_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_122_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_122_RANGE                    26:26
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_122_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_122_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_122_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_122_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_122_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_123_SHIFT                    _MK_SHIFT_CONST(27)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_123_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_123_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_123_RANGE                    27:27
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_123_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_123_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_123_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_123_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_123_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_124_SHIFT                    _MK_SHIFT_CONST(28)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_124_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_124_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_124_RANGE                    28:28
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_124_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_124_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_124_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_124_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_124_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_125_SHIFT                    _MK_SHIFT_CONST(29)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_125_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_125_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_125_RANGE                    29:29
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_125_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_125_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_125_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_125_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_125_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_126_SHIFT                    _MK_SHIFT_CONST(30)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_126_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_126_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_126_RANGE                    30:30
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_126_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_126_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_126_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_126_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_126_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_127_SHIFT                    _MK_SHIFT_CONST(31)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_127_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_127_SHIFT)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_127_RANGE                    31:31
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_127_WOFFSET                  0x0
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_127_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_127_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_127_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PENDING_CLEAR_4_0_PENDING_CLR_SPI_127_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Reserved address 4756 [0x1294] 

// Reserved address 4760 [0x1298] 

// Reserved address 4764 [0x129c] 

// Reserved address 4768 [0x12a0] 

// Reserved address 4772 [0x12a4] 

// Reserved address 4776 [0x12a8] 

// Reserved address 4780 [0x12ac] 

// Reserved address 4784 [0x12b0] 

// Reserved address 4788 [0x12b4] 

// Reserved address 4792 [0x12b8] 

// Reserved address 4796 [0x12bc] 

// Reserved address 4800 [0x12c0] 

// Reserved address 4804 [0x12c4] 

// Reserved address 4808 [0x12c8] 

// Reserved address 4812 [0x12cc] 

// Reserved address 4816 [0x12d0] 

// Reserved address 4820 [0x12d4] 

// Reserved address 4824 [0x12d8] 

// Reserved address 4828 [0x12dc] 

// Reserved address 4832 [0x12e0] 

// Reserved address 4836 [0x12e4] 

// Reserved address 4840 [0x12e8] 

// Reserved address 4844 [0x12ec] 

// Reserved address 4848 [0x12f0] 

// Reserved address 4852 [0x12f4] 

// Reserved address 4856 [0x12f8] 

// Reserved address 4860 [0x12fc] 

// Register FIC_DIST_ACTIVE_STATUS_0_0  
#define FIC_DIST_ACTIVE_STATUS_0_0                      _MK_ADDR_CONST(0x1300)
#define FIC_DIST_ACTIVE_STATUS_0_0_SECURE                       0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_WORD_COUNT                   0x1
#define FIC_DIST_ACTIVE_STATUS_0_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_RESET_MASK                   _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_ACTIVE_STATUS_0_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_READ_MASK                    _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_ACTIVE_STATUS_0_0_WRITE_MASK                   _MK_MASK_CONST(0xf800ffff)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_0_SHIFT                    _MK_SHIFT_CONST(0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_0_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_0_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_0_RANGE                    0:0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_0_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_1_SHIFT                    _MK_SHIFT_CONST(1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_1_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_1_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_1_RANGE                    1:1
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_1_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_2_SHIFT                    _MK_SHIFT_CONST(2)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_2_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_2_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_2_RANGE                    2:2
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_2_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_2_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_3_SHIFT                    _MK_SHIFT_CONST(3)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_3_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_3_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_3_RANGE                    3:3
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_3_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_3_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_3_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_3_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_3_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_4_SHIFT                    _MK_SHIFT_CONST(4)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_4_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_4_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_4_RANGE                    4:4
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_4_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_4_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_4_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_4_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_4_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_5_SHIFT                    _MK_SHIFT_CONST(5)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_5_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_5_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_5_RANGE                    5:5
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_5_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_5_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_5_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_5_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_5_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_6_SHIFT                    _MK_SHIFT_CONST(6)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_6_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_6_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_6_RANGE                    6:6
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_6_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_6_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_6_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_6_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_6_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_7_SHIFT                    _MK_SHIFT_CONST(7)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_7_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_7_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_7_RANGE                    7:7
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_7_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_7_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_7_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_7_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_7_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_8_SHIFT                    _MK_SHIFT_CONST(8)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_8_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_8_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_8_RANGE                    8:8
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_8_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_8_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_8_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_8_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_8_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_9_SHIFT                    _MK_SHIFT_CONST(9)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_9_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_9_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_9_RANGE                    9:9
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_9_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_9_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_9_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_9_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_9_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_10_SHIFT                   _MK_SHIFT_CONST(10)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_10_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_10_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_10_RANGE                   10:10
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_10_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_10_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_10_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_10_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_10_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_11_SHIFT                   _MK_SHIFT_CONST(11)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_11_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_11_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_11_RANGE                   11:11
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_11_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_11_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_11_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_11_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_11_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_12_SHIFT                   _MK_SHIFT_CONST(12)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_12_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_12_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_12_RANGE                   12:12
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_12_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_12_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_12_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_12_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_12_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_13_SHIFT                   _MK_SHIFT_CONST(13)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_13_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_13_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_13_RANGE                   13:13
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_13_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_13_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_13_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_13_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_13_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_14_SHIFT                   _MK_SHIFT_CONST(14)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_14_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_14_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_14_RANGE                   14:14
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_14_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_14_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_14_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_14_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_14_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_15_SHIFT                   _MK_SHIFT_CONST(15)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_15_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_15_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_15_RANGE                   15:15
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_15_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_15_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_15_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_15_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_STI_15_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_4_SHIFT                    _MK_SHIFT_CONST(27)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_4_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_4_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_4_RANGE                    27:27
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_4_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_4_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_4_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_4_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_4_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_0_SHIFT                    _MK_SHIFT_CONST(28)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_0_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_0_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_0_RANGE                    28:28
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_0_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_1_SHIFT                    _MK_SHIFT_CONST(29)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_1_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_1_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_1_RANGE                    29:29
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_1_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_2_SHIFT                    _MK_SHIFT_CONST(30)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_2_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_2_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_2_RANGE                    30:30
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_2_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_2_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_3_SHIFT                    _MK_SHIFT_CONST(31)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_3_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_3_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_3_RANGE                    31:31
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_3_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_3_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_3_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_3_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_0_0_ACTIVE_STATUS_PPI_3_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FIC_DIST_ACTIVE_STATUS_1_0  
#define FIC_DIST_ACTIVE_STATUS_1_0                      _MK_ADDR_CONST(0x1304)
#define FIC_DIST_ACTIVE_STATUS_1_0_SECURE                       0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_WORD_COUNT                   0x1
#define FIC_DIST_ACTIVE_STATUS_1_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ACTIVE_STATUS_1_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ACTIVE_STATUS_1_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_0_SHIFT                    _MK_SHIFT_CONST(0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_0_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_0_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_0_RANGE                    0:0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_0_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_1_SHIFT                    _MK_SHIFT_CONST(1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_1_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_1_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_1_RANGE                    1:1
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_1_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_2_SHIFT                    _MK_SHIFT_CONST(2)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_2_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_2_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_2_RANGE                    2:2
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_2_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_2_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_2_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_2_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_2_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_3_SHIFT                    _MK_SHIFT_CONST(3)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_3_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_3_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_3_RANGE                    3:3
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_3_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_3_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_3_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_3_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_3_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_4_SHIFT                    _MK_SHIFT_CONST(4)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_4_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_4_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_4_RANGE                    4:4
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_4_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_4_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_4_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_4_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_4_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_5_SHIFT                    _MK_SHIFT_CONST(5)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_5_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_5_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_5_RANGE                    5:5
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_5_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_5_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_5_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_5_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_5_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_6_SHIFT                    _MK_SHIFT_CONST(6)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_6_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_6_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_6_RANGE                    6:6
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_6_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_6_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_6_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_6_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_6_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_7_SHIFT                    _MK_SHIFT_CONST(7)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_7_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_7_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_7_RANGE                    7:7
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_7_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_7_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_7_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_7_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_7_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_8_SHIFT                    _MK_SHIFT_CONST(8)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_8_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_8_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_8_RANGE                    8:8
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_8_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_8_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_8_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_8_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_8_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_9_SHIFT                    _MK_SHIFT_CONST(9)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_9_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_9_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_9_RANGE                    9:9
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_9_WOFFSET                  0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_9_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_9_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_9_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_9_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_10_SHIFT                   _MK_SHIFT_CONST(10)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_10_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_10_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_10_RANGE                   10:10
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_10_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_10_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_10_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_10_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_10_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_11_SHIFT                   _MK_SHIFT_CONST(11)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_11_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_11_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_11_RANGE                   11:11
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_11_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_11_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_11_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_11_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_11_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_12_SHIFT                   _MK_SHIFT_CONST(12)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_12_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_12_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_12_RANGE                   12:12
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_12_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_12_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_12_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_12_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_12_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_13_SHIFT                   _MK_SHIFT_CONST(13)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_13_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_13_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_13_RANGE                   13:13
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_13_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_13_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_13_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_13_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_13_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_14_SHIFT                   _MK_SHIFT_CONST(14)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_14_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_14_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_14_RANGE                   14:14
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_14_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_14_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_14_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_14_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_14_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_15_SHIFT                   _MK_SHIFT_CONST(15)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_15_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_15_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_15_RANGE                   15:15
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_15_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_15_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_15_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_15_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_15_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_16_SHIFT                   _MK_SHIFT_CONST(16)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_16_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_16_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_16_RANGE                   16:16
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_16_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_16_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_16_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_16_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_16_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_17_SHIFT                   _MK_SHIFT_CONST(17)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_17_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_17_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_17_RANGE                   17:17
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_17_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_17_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_17_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_17_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_17_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_18_SHIFT                   _MK_SHIFT_CONST(18)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_18_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_18_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_18_RANGE                   18:18
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_18_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_18_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_18_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_18_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_18_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_19_SHIFT                   _MK_SHIFT_CONST(19)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_19_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_19_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_19_RANGE                   19:19
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_19_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_19_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_19_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_19_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_19_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_20_SHIFT                   _MK_SHIFT_CONST(20)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_20_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_20_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_20_RANGE                   20:20
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_20_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_20_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_20_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_20_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_20_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_21_SHIFT                   _MK_SHIFT_CONST(21)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_21_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_21_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_21_RANGE                   21:21
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_21_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_21_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_21_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_21_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_21_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_22_SHIFT                   _MK_SHIFT_CONST(22)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_22_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_22_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_22_RANGE                   22:22
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_22_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_22_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_22_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_22_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_22_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_23_SHIFT                   _MK_SHIFT_CONST(23)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_23_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_23_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_23_RANGE                   23:23
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_23_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_23_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_23_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_23_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_23_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_24_SHIFT                   _MK_SHIFT_CONST(24)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_24_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_24_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_24_RANGE                   24:24
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_24_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_24_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_24_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_24_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_24_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_25_SHIFT                   _MK_SHIFT_CONST(25)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_25_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_25_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_25_RANGE                   25:25
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_25_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_25_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_25_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_25_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_25_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_26_SHIFT                   _MK_SHIFT_CONST(26)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_26_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_26_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_26_RANGE                   26:26
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_26_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_26_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_26_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_26_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_26_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_27_SHIFT                   _MK_SHIFT_CONST(27)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_27_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_27_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_27_RANGE                   27:27
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_27_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_27_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_27_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_27_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_27_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_28_SHIFT                   _MK_SHIFT_CONST(28)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_28_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_28_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_28_RANGE                   28:28
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_28_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_28_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_28_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_28_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_28_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_29_SHIFT                   _MK_SHIFT_CONST(29)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_29_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_29_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_29_RANGE                   29:29
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_29_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_29_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_29_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_29_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_29_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_30_SHIFT                   _MK_SHIFT_CONST(30)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_30_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_30_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_30_RANGE                   30:30
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_30_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_30_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_30_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_30_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_30_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_31_SHIFT                   _MK_SHIFT_CONST(31)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_31_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_31_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_31_RANGE                   31:31
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_31_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_31_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_31_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_31_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_1_0_ACTIVE_STATUS_SPI_31_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FIC_DIST_ACTIVE_STATUS_2_0  
#define FIC_DIST_ACTIVE_STATUS_2_0                      _MK_ADDR_CONST(0x1308)
#define FIC_DIST_ACTIVE_STATUS_2_0_SECURE                       0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_WORD_COUNT                   0x1
#define FIC_DIST_ACTIVE_STATUS_2_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ACTIVE_STATUS_2_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ACTIVE_STATUS_2_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_32_SHIFT                   _MK_SHIFT_CONST(0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_32_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_32_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_32_RANGE                   0:0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_32_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_32_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_32_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_32_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_32_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_33_SHIFT                   _MK_SHIFT_CONST(1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_33_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_33_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_33_RANGE                   1:1
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_33_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_33_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_33_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_33_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_33_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_34_SHIFT                   _MK_SHIFT_CONST(2)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_34_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_34_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_34_RANGE                   2:2
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_34_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_34_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_34_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_34_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_34_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_35_SHIFT                   _MK_SHIFT_CONST(3)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_35_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_35_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_35_RANGE                   3:3
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_35_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_35_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_35_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_35_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_35_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_36_SHIFT                   _MK_SHIFT_CONST(4)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_36_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_36_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_36_RANGE                   4:4
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_36_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_36_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_36_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_36_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_36_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_37_SHIFT                   _MK_SHIFT_CONST(5)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_37_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_37_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_37_RANGE                   5:5
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_37_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_37_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_37_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_37_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_37_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_38_SHIFT                   _MK_SHIFT_CONST(6)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_38_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_38_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_38_RANGE                   6:6
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_38_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_38_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_38_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_38_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_38_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_39_SHIFT                   _MK_SHIFT_CONST(7)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_39_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_39_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_39_RANGE                   7:7
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_39_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_39_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_39_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_39_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_39_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_40_SHIFT                   _MK_SHIFT_CONST(8)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_40_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_40_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_40_RANGE                   8:8
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_40_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_40_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_40_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_40_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_40_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_41_SHIFT                   _MK_SHIFT_CONST(9)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_41_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_41_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_41_RANGE                   9:9
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_41_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_41_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_41_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_41_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_41_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_42_SHIFT                   _MK_SHIFT_CONST(10)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_42_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_42_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_42_RANGE                   10:10
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_42_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_42_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_42_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_42_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_42_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_43_SHIFT                   _MK_SHIFT_CONST(11)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_43_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_43_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_43_RANGE                   11:11
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_43_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_43_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_43_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_43_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_43_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_44_SHIFT                   _MK_SHIFT_CONST(12)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_44_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_44_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_44_RANGE                   12:12
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_44_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_44_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_44_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_44_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_44_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_45_SHIFT                   _MK_SHIFT_CONST(13)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_45_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_45_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_45_RANGE                   13:13
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_45_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_45_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_45_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_45_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_45_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_46_SHIFT                   _MK_SHIFT_CONST(14)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_46_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_46_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_46_RANGE                   14:14
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_46_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_46_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_46_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_46_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_46_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_47_SHIFT                   _MK_SHIFT_CONST(15)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_47_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_47_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_47_RANGE                   15:15
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_47_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_47_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_47_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_47_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_47_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_48_SHIFT                   _MK_SHIFT_CONST(16)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_48_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_48_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_48_RANGE                   16:16
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_48_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_48_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_48_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_48_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_48_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_49_SHIFT                   _MK_SHIFT_CONST(17)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_49_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_49_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_49_RANGE                   17:17
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_49_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_49_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_49_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_49_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_49_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_50_SHIFT                   _MK_SHIFT_CONST(18)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_50_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_50_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_50_RANGE                   18:18
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_50_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_50_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_50_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_50_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_50_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_51_SHIFT                   _MK_SHIFT_CONST(19)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_51_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_51_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_51_RANGE                   19:19
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_51_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_51_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_51_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_51_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_51_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_52_SHIFT                   _MK_SHIFT_CONST(20)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_52_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_52_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_52_RANGE                   20:20
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_52_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_52_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_52_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_52_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_52_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_53_SHIFT                   _MK_SHIFT_CONST(21)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_53_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_53_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_53_RANGE                   21:21
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_53_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_53_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_53_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_53_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_53_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_54_SHIFT                   _MK_SHIFT_CONST(22)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_54_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_54_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_54_RANGE                   22:22
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_54_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_54_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_54_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_54_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_54_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_55_SHIFT                   _MK_SHIFT_CONST(23)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_55_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_55_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_55_RANGE                   23:23
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_55_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_55_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_55_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_55_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_55_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_56_SHIFT                   _MK_SHIFT_CONST(24)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_56_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_56_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_56_RANGE                   24:24
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_56_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_56_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_56_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_56_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_56_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_57_SHIFT                   _MK_SHIFT_CONST(25)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_57_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_57_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_57_RANGE                   25:25
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_57_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_57_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_57_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_57_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_57_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_58_SHIFT                   _MK_SHIFT_CONST(26)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_58_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_58_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_58_RANGE                   26:26
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_58_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_58_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_58_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_58_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_58_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_59_SHIFT                   _MK_SHIFT_CONST(27)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_59_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_59_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_59_RANGE                   27:27
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_59_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_59_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_59_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_59_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_59_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_60_SHIFT                   _MK_SHIFT_CONST(28)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_60_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_60_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_60_RANGE                   28:28
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_60_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_60_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_60_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_60_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_60_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_61_SHIFT                   _MK_SHIFT_CONST(29)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_61_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_61_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_61_RANGE                   29:29
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_61_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_61_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_61_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_61_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_61_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_62_SHIFT                   _MK_SHIFT_CONST(30)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_62_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_62_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_62_RANGE                   30:30
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_62_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_62_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_62_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_62_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_62_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_63_SHIFT                   _MK_SHIFT_CONST(31)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_63_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_63_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_63_RANGE                   31:31
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_63_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_63_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_63_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_63_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_2_0_ACTIVE_STATUS_SPI_63_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FIC_DIST_ACTIVE_STATUS_3_0  
#define FIC_DIST_ACTIVE_STATUS_3_0                      _MK_ADDR_CONST(0x130c)
#define FIC_DIST_ACTIVE_STATUS_3_0_SECURE                       0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_WORD_COUNT                   0x1
#define FIC_DIST_ACTIVE_STATUS_3_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ACTIVE_STATUS_3_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ACTIVE_STATUS_3_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_64_SHIFT                   _MK_SHIFT_CONST(0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_64_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_64_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_64_RANGE                   0:0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_64_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_64_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_64_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_64_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_64_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_65_SHIFT                   _MK_SHIFT_CONST(1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_65_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_65_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_65_RANGE                   1:1
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_65_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_65_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_65_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_65_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_65_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_66_SHIFT                   _MK_SHIFT_CONST(2)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_66_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_66_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_66_RANGE                   2:2
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_66_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_66_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_66_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_66_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_66_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_67_SHIFT                   _MK_SHIFT_CONST(3)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_67_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_67_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_67_RANGE                   3:3
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_67_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_67_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_67_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_67_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_67_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_68_SHIFT                   _MK_SHIFT_CONST(4)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_68_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_68_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_68_RANGE                   4:4
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_68_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_68_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_68_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_68_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_68_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_69_SHIFT                   _MK_SHIFT_CONST(5)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_69_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_69_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_69_RANGE                   5:5
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_69_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_69_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_69_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_69_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_69_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_70_SHIFT                   _MK_SHIFT_CONST(6)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_70_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_70_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_70_RANGE                   6:6
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_70_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_70_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_70_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_70_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_70_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_71_SHIFT                   _MK_SHIFT_CONST(7)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_71_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_71_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_71_RANGE                   7:7
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_71_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_71_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_71_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_71_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_71_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_72_SHIFT                   _MK_SHIFT_CONST(8)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_72_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_72_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_72_RANGE                   8:8
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_72_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_72_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_72_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_72_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_72_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_73_SHIFT                   _MK_SHIFT_CONST(9)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_73_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_73_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_73_RANGE                   9:9
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_73_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_73_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_73_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_73_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_73_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_74_SHIFT                   _MK_SHIFT_CONST(10)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_74_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_74_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_74_RANGE                   10:10
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_74_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_74_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_74_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_74_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_74_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_75_SHIFT                   _MK_SHIFT_CONST(11)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_75_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_75_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_75_RANGE                   11:11
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_75_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_75_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_75_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_75_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_75_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_76_SHIFT                   _MK_SHIFT_CONST(12)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_76_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_76_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_76_RANGE                   12:12
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_76_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_76_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_76_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_76_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_76_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_77_SHIFT                   _MK_SHIFT_CONST(13)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_77_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_77_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_77_RANGE                   13:13
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_77_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_77_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_77_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_77_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_77_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_78_SHIFT                   _MK_SHIFT_CONST(14)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_78_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_78_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_78_RANGE                   14:14
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_78_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_78_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_78_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_78_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_78_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_79_SHIFT                   _MK_SHIFT_CONST(15)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_79_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_79_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_79_RANGE                   15:15
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_79_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_79_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_79_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_79_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_79_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_80_SHIFT                   _MK_SHIFT_CONST(16)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_80_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_80_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_80_RANGE                   16:16
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_80_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_80_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_80_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_80_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_80_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_81_SHIFT                   _MK_SHIFT_CONST(17)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_81_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_81_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_81_RANGE                   17:17
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_81_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_81_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_81_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_81_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_81_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_82_SHIFT                   _MK_SHIFT_CONST(18)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_82_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_82_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_82_RANGE                   18:18
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_82_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_82_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_82_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_82_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_82_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_83_SHIFT                   _MK_SHIFT_CONST(19)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_83_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_83_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_83_RANGE                   19:19
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_83_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_83_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_83_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_83_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_83_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_84_SHIFT                   _MK_SHIFT_CONST(20)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_84_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_84_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_84_RANGE                   20:20
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_84_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_84_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_84_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_84_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_84_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_85_SHIFT                   _MK_SHIFT_CONST(21)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_85_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_85_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_85_RANGE                   21:21
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_85_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_85_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_85_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_85_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_85_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_86_SHIFT                   _MK_SHIFT_CONST(22)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_86_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_86_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_86_RANGE                   22:22
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_86_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_86_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_86_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_86_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_86_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_87_SHIFT                   _MK_SHIFT_CONST(23)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_87_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_87_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_87_RANGE                   23:23
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_87_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_87_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_87_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_87_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_87_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_88_SHIFT                   _MK_SHIFT_CONST(24)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_88_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_88_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_88_RANGE                   24:24
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_88_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_88_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_88_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_88_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_88_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_89_SHIFT                   _MK_SHIFT_CONST(25)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_89_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_89_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_89_RANGE                   25:25
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_89_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_89_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_89_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_89_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_89_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_90_SHIFT                   _MK_SHIFT_CONST(26)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_90_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_90_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_90_RANGE                   26:26
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_90_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_90_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_90_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_90_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_90_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_91_SHIFT                   _MK_SHIFT_CONST(27)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_91_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_91_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_91_RANGE                   27:27
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_91_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_91_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_91_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_91_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_91_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_92_SHIFT                   _MK_SHIFT_CONST(28)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_92_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_92_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_92_RANGE                   28:28
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_92_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_92_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_92_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_92_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_92_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_93_SHIFT                   _MK_SHIFT_CONST(29)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_93_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_93_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_93_RANGE                   29:29
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_93_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_93_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_93_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_93_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_93_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_94_SHIFT                   _MK_SHIFT_CONST(30)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_94_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_94_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_94_RANGE                   30:30
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_94_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_94_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_94_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_94_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_94_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_95_SHIFT                   _MK_SHIFT_CONST(31)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_95_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_95_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_95_RANGE                   31:31
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_95_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_95_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_95_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_95_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_3_0_ACTIVE_STATUS_SPI_95_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register FIC_DIST_ACTIVE_STATUS_4_0  
#define FIC_DIST_ACTIVE_STATUS_4_0                      _MK_ADDR_CONST(0x1310)
#define FIC_DIST_ACTIVE_STATUS_4_0_SECURE                       0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_WORD_COUNT                   0x1
#define FIC_DIST_ACTIVE_STATUS_4_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ACTIVE_STATUS_4_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ACTIVE_STATUS_4_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_96_SHIFT                   _MK_SHIFT_CONST(0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_96_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_96_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_96_RANGE                   0:0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_96_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_96_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_96_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_96_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_96_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_97_SHIFT                   _MK_SHIFT_CONST(1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_97_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_97_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_97_RANGE                   1:1
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_97_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_97_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_97_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_97_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_97_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_98_SHIFT                   _MK_SHIFT_CONST(2)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_98_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_98_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_98_RANGE                   2:2
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_98_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_98_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_98_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_98_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_98_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_99_SHIFT                   _MK_SHIFT_CONST(3)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_99_FIELD                   (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_99_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_99_RANGE                   3:3
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_99_WOFFSET                 0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_99_DEFAULT                 _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_99_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_99_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_99_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_100_SHIFT                  _MK_SHIFT_CONST(4)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_100_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_100_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_100_RANGE                  4:4
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_100_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_100_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_100_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_100_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_100_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_101_SHIFT                  _MK_SHIFT_CONST(5)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_101_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_101_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_101_RANGE                  5:5
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_101_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_101_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_101_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_101_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_101_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_102_SHIFT                  _MK_SHIFT_CONST(6)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_102_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_102_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_102_RANGE                  6:6
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_102_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_102_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_102_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_102_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_102_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_103_SHIFT                  _MK_SHIFT_CONST(7)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_103_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_103_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_103_RANGE                  7:7
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_103_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_103_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_103_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_103_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_103_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_104_SHIFT                  _MK_SHIFT_CONST(8)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_104_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_104_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_104_RANGE                  8:8
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_104_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_104_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_104_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_104_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_104_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_105_SHIFT                  _MK_SHIFT_CONST(9)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_105_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_105_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_105_RANGE                  9:9
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_105_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_105_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_105_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_105_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_105_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_106_SHIFT                  _MK_SHIFT_CONST(10)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_106_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_106_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_106_RANGE                  10:10
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_106_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_106_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_106_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_106_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_106_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_107_SHIFT                  _MK_SHIFT_CONST(11)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_107_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_107_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_107_RANGE                  11:11
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_107_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_107_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_107_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_107_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_107_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_108_SHIFT                  _MK_SHIFT_CONST(12)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_108_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_108_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_108_RANGE                  12:12
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_108_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_108_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_108_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_108_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_108_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_109_SHIFT                  _MK_SHIFT_CONST(13)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_109_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_109_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_109_RANGE                  13:13
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_109_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_109_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_109_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_109_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_109_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_110_SHIFT                  _MK_SHIFT_CONST(14)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_110_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_110_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_110_RANGE                  14:14
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_110_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_110_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_110_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_110_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_110_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_111_SHIFT                  _MK_SHIFT_CONST(15)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_111_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_111_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_111_RANGE                  15:15
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_111_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_111_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_111_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_111_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_111_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_112_SHIFT                  _MK_SHIFT_CONST(16)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_112_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_112_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_112_RANGE                  16:16
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_112_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_112_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_112_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_112_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_112_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_113_SHIFT                  _MK_SHIFT_CONST(17)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_113_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_113_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_113_RANGE                  17:17
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_113_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_113_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_113_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_113_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_113_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_114_SHIFT                  _MK_SHIFT_CONST(18)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_114_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_114_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_114_RANGE                  18:18
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_114_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_114_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_114_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_114_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_114_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_115_SHIFT                  _MK_SHIFT_CONST(19)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_115_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_115_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_115_RANGE                  19:19
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_115_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_115_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_115_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_115_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_115_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_116_SHIFT                  _MK_SHIFT_CONST(20)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_116_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_116_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_116_RANGE                  20:20
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_116_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_116_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_116_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_116_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_116_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_117_SHIFT                  _MK_SHIFT_CONST(21)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_117_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_117_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_117_RANGE                  21:21
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_117_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_117_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_117_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_117_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_117_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_118_SHIFT                  _MK_SHIFT_CONST(22)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_118_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_118_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_118_RANGE                  22:22
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_118_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_118_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_118_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_118_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_118_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_119_SHIFT                  _MK_SHIFT_CONST(23)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_119_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_119_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_119_RANGE                  23:23
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_119_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_119_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_119_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_119_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_119_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_120_SHIFT                  _MK_SHIFT_CONST(24)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_120_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_120_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_120_RANGE                  24:24
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_120_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_120_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_120_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_120_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_120_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_121_SHIFT                  _MK_SHIFT_CONST(25)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_121_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_121_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_121_RANGE                  25:25
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_121_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_121_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_121_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_121_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_121_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_122_SHIFT                  _MK_SHIFT_CONST(26)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_122_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_122_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_122_RANGE                  26:26
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_122_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_122_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_122_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_122_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_122_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_123_SHIFT                  _MK_SHIFT_CONST(27)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_123_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_123_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_123_RANGE                  27:27
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_123_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_123_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_123_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_123_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_123_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_124_SHIFT                  _MK_SHIFT_CONST(28)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_124_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_124_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_124_RANGE                  28:28
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_124_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_124_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_124_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_124_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_124_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_125_SHIFT                  _MK_SHIFT_CONST(29)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_125_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_125_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_125_RANGE                  29:29
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_125_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_125_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_125_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_125_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_125_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_126_SHIFT                  _MK_SHIFT_CONST(30)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_126_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_126_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_126_RANGE                  30:30
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_126_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_126_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_126_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_126_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_126_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_127_SHIFT                  _MK_SHIFT_CONST(31)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_127_FIELD                  (_MK_MASK_CONST(0x1) << FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_127_SHIFT)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_127_RANGE                  31:31
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_127_WOFFSET                        0x0
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_127_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_127_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_127_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_ACTIVE_STATUS_4_0_ACTIVE_STATUS_SPI_127_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Reserved address 4884 [0x1314] 

// Reserved address 4888 [0x1318] 

// Reserved address 4892 [0x131c] 

// Reserved address 4896 [0x1320] 

// Reserved address 4900 [0x1324] 

// Reserved address 4904 [0x1328] 

// Reserved address 4908 [0x132c] 

// Reserved address 4912 [0x1330] 

// Reserved address 4916 [0x1334] 

// Reserved address 4920 [0x1338] 

// Reserved address 4924 [0x133c] 

// Reserved address 4928 [0x1340] 

// Reserved address 4932 [0x1344] 

// Reserved address 4936 [0x1348] 

// Reserved address 4940 [0x134c] 

// Reserved address 4944 [0x1350] 

// Reserved address 4948 [0x1354] 

// Reserved address 4952 [0x1358] 

// Reserved address 4956 [0x135c] 

// Reserved address 4960 [0x1360] 

// Reserved address 4964 [0x1364] 

// Reserved address 4968 [0x1368] 

// Reserved address 4972 [0x136c] 

// Reserved address 4976 [0x1370] 

// Reserved address 4980 [0x1374] 

// Reserved address 4984 [0x1378] 

// Reserved address 4988 [0x137c] 

// Reserved address 4992 [0x1380] 

// Reserved address 4996 [0x1384] 

// Reserved address 5000 [0x1388] 

// Reserved address 5004 [0x138c] 

// Reserved address 5008 [0x1390] 

// Reserved address 5012 [0x1394] 

// Reserved address 5016 [0x1398] 

// Reserved address 5020 [0x139c] 

// Reserved address 5024 [0x13a0] 

// Reserved address 5028 [0x13a4] 

// Reserved address 5032 [0x13a8] 

// Reserved address 5036 [0x13ac] 

// Reserved address 5040 [0x13b0] 

// Reserved address 5044 [0x13b4] 

// Reserved address 5048 [0x13b8] 

// Reserved address 5052 [0x13bc] 

// Reserved address 5056 [0x13c0] 

// Reserved address 5060 [0x13c4] 

// Reserved address 5064 [0x13c8] 

// Reserved address 5068 [0x13cc] 

// Reserved address 5072 [0x13d0] 

// Reserved address 5076 [0x13d4] 

// Reserved address 5080 [0x13d8] 

// Reserved address 5084 [0x13dc] 

// Reserved address 5088 [0x13e0] 

// Reserved address 5092 [0x13e4] 

// Reserved address 5096 [0x13e8] 

// Reserved address 5100 [0x13ec] 

// Reserved address 5104 [0x13f0] 

// Reserved address 5108 [0x13f4] 

// Reserved address 5112 [0x13f8] 

// Reserved address 5116 [0x13fc] 

// Register FIC_DIST_PRIORITY_LEVEL_0_0  
#define FIC_DIST_PRIORITY_LEVEL_0_0                     _MK_ADDR_CONST(0x1400)
#define FIC_DIST_PRIORITY_LEVEL_0_0_SECURE                      0x0
#define FIC_DIST_PRIORITY_LEVEL_0_0_WORD_COUNT                  0x1
#define FIC_DIST_PRIORITY_LEVEL_0_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_0_0_RESET_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_0_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_0_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_0_0_READ_MASK                   _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_0_0_WRITE_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_0_SHIFT                  _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_0_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_0_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_0_RANGE                  7:3
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_0_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_0_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_1_SHIFT                  _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_1_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_1_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_1_RANGE                  15:11
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_1_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_1_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_2_SHIFT                  _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_2_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_2_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_2_RANGE                  23:19
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_2_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_2_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_2_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_3_SHIFT                  _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_3_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_3_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_3_RANGE                  31:27
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_3_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_3_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_3_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_0_0_PRIORITY_LEVEL_STI_3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_1_0  
#define FIC_DIST_PRIORITY_LEVEL_1_0                     _MK_ADDR_CONST(0x1404)
#define FIC_DIST_PRIORITY_LEVEL_1_0_SECURE                      0x0
#define FIC_DIST_PRIORITY_LEVEL_1_0_WORD_COUNT                  0x1
#define FIC_DIST_PRIORITY_LEVEL_1_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_1_0_RESET_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_1_0_READ_MASK                   _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_1_0_WRITE_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_4_SHIFT                  _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_4_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_4_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_4_RANGE                  7:3
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_4_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_4_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_4_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_4_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_4_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_5_SHIFT                  _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_5_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_5_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_5_RANGE                  15:11
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_5_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_5_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_5_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_5_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_5_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_6_SHIFT                  _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_6_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_6_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_6_RANGE                  23:19
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_6_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_6_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_6_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_6_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_6_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_7_SHIFT                  _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_7_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_7_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_7_RANGE                  31:27
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_7_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_7_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_7_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_7_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_1_0_PRIORITY_LEVEL_STI_7_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_2_0  
#define FIC_DIST_PRIORITY_LEVEL_2_0                     _MK_ADDR_CONST(0x1408)
#define FIC_DIST_PRIORITY_LEVEL_2_0_SECURE                      0x0
#define FIC_DIST_PRIORITY_LEVEL_2_0_WORD_COUNT                  0x1
#define FIC_DIST_PRIORITY_LEVEL_2_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_2_0_RESET_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_2_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_2_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_2_0_READ_MASK                   _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_2_0_WRITE_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_8_SHIFT                  _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_8_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_8_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_8_RANGE                  7:3
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_8_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_8_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_8_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_8_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_8_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_9_SHIFT                  _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_9_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_9_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_9_RANGE                  15:11
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_9_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_9_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_9_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_9_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_9_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_10_SHIFT                 _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_10_FIELD                 (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_10_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_10_RANGE                 23:19
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_10_WOFFSET                       0x0
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_10_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_10_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_10_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_10_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_11_SHIFT                 _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_11_FIELD                 (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_11_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_11_RANGE                 31:27
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_11_WOFFSET                       0x0
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_11_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_11_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_11_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_2_0_PRIORITY_LEVEL_STI_11_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_3_0  
#define FIC_DIST_PRIORITY_LEVEL_3_0                     _MK_ADDR_CONST(0x140c)
#define FIC_DIST_PRIORITY_LEVEL_3_0_SECURE                      0x0
#define FIC_DIST_PRIORITY_LEVEL_3_0_WORD_COUNT                  0x1
#define FIC_DIST_PRIORITY_LEVEL_3_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_3_0_RESET_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_3_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_3_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_3_0_READ_MASK                   _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_3_0_WRITE_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_12_SHIFT                 _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_12_FIELD                 (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_12_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_12_RANGE                 7:3
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_12_WOFFSET                       0x0
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_12_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_12_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_12_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_12_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_13_SHIFT                 _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_13_FIELD                 (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_13_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_13_RANGE                 15:11
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_13_WOFFSET                       0x0
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_13_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_13_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_13_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_13_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_14_SHIFT                 _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_14_FIELD                 (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_14_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_14_RANGE                 23:19
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_14_WOFFSET                       0x0
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_14_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_14_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_14_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_14_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_15_SHIFT                 _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_15_FIELD                 (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_15_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_15_RANGE                 31:27
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_15_WOFFSET                       0x0
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_15_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_15_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_15_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_3_0_PRIORITY_LEVEL_STI_15_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 5136 [0x1410] 

// Reserved address 5140 [0x1414] 

// Register FIC_DIST_PRIORITY_LEVEL_6_0  
#define FIC_DIST_PRIORITY_LEVEL_6_0                     _MK_ADDR_CONST(0x1418)
#define FIC_DIST_PRIORITY_LEVEL_6_0_SECURE                      0x0
#define FIC_DIST_PRIORITY_LEVEL_6_0_WORD_COUNT                  0x1
#define FIC_DIST_PRIORITY_LEVEL_6_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_6_0_RESET_MASK                  _MK_MASK_CONST(0xf8000000)
#define FIC_DIST_PRIORITY_LEVEL_6_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_6_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_6_0_READ_MASK                   _MK_MASK_CONST(0xf8000000)
#define FIC_DIST_PRIORITY_LEVEL_6_0_WRITE_MASK                  _MK_MASK_CONST(0xf8000000)
#define FIC_DIST_PRIORITY_LEVEL_6_0_PRIORITY_LEVEL_PPI_4_SHIFT                  _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_6_0_PRIORITY_LEVEL_PPI_4_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_6_0_PRIORITY_LEVEL_PPI_4_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_6_0_PRIORITY_LEVEL_PPI_4_RANGE                  31:27
#define FIC_DIST_PRIORITY_LEVEL_6_0_PRIORITY_LEVEL_PPI_4_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_6_0_PRIORITY_LEVEL_PPI_4_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_6_0_PRIORITY_LEVEL_PPI_4_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_6_0_PRIORITY_LEVEL_PPI_4_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_6_0_PRIORITY_LEVEL_PPI_4_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_7_0  
#define FIC_DIST_PRIORITY_LEVEL_7_0                     _MK_ADDR_CONST(0x141c)
#define FIC_DIST_PRIORITY_LEVEL_7_0_SECURE                      0x0
#define FIC_DIST_PRIORITY_LEVEL_7_0_WORD_COUNT                  0x1
#define FIC_DIST_PRIORITY_LEVEL_7_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_7_0_RESET_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_7_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_7_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_7_0_READ_MASK                   _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_7_0_WRITE_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_0_SHIFT                  _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_0_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_0_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_0_RANGE                  7:3
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_0_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_0_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_1_SHIFT                  _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_1_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_1_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_1_RANGE                  15:11
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_1_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_1_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_2_SHIFT                  _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_2_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_2_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_2_RANGE                  23:19
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_2_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_2_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_2_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_3_SHIFT                  _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_3_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_3_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_3_RANGE                  31:27
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_3_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_3_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_3_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_7_0_PRIORITY_LEVEL_PPI_3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_8_0  
#define FIC_DIST_PRIORITY_LEVEL_8_0                     _MK_ADDR_CONST(0x1420)
#define FIC_DIST_PRIORITY_LEVEL_8_0_SECURE                      0x0
#define FIC_DIST_PRIORITY_LEVEL_8_0_WORD_COUNT                  0x1
#define FIC_DIST_PRIORITY_LEVEL_8_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_8_0_RESET_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_8_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_8_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_8_0_READ_MASK                   _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_8_0_WRITE_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_0_SHIFT                  _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_0_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_0_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_0_RANGE                  7:3
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_0_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_0_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_0_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_0_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_1_SHIFT                  _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_1_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_1_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_1_RANGE                  15:11
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_1_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_1_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_1_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_1_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_1_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_2_SHIFT                  _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_2_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_2_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_2_RANGE                  23:19
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_2_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_2_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_2_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_2_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_2_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_3_SHIFT                  _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_3_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_3_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_3_RANGE                  31:27
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_3_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_3_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_3_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_3_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_8_0_PRIORITY_LEVEL_SPI_3_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_9_0  
#define FIC_DIST_PRIORITY_LEVEL_9_0                     _MK_ADDR_CONST(0x1424)
#define FIC_DIST_PRIORITY_LEVEL_9_0_SECURE                      0x0
#define FIC_DIST_PRIORITY_LEVEL_9_0_WORD_COUNT                  0x1
#define FIC_DIST_PRIORITY_LEVEL_9_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_9_0_RESET_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_9_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_9_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_9_0_READ_MASK                   _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_9_0_WRITE_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_4_SHIFT                  _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_4_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_4_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_4_RANGE                  7:3
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_4_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_4_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_4_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_4_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_4_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_5_SHIFT                  _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_5_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_5_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_5_RANGE                  15:11
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_5_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_5_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_5_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_5_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_5_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_6_SHIFT                  _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_6_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_6_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_6_RANGE                  23:19
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_6_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_6_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_6_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_6_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_6_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_7_SHIFT                  _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_7_FIELD                  (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_7_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_7_RANGE                  31:27
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_7_WOFFSET                        0x0
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_7_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_7_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_7_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_9_0_PRIORITY_LEVEL_SPI_7_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_10_0  
#define FIC_DIST_PRIORITY_LEVEL_10_0                    _MK_ADDR_CONST(0x1428)
#define FIC_DIST_PRIORITY_LEVEL_10_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_10_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_10_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_10_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_10_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_10_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_10_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_10_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_8_SHIFT                 _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_8_FIELD                 (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_8_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_8_RANGE                 7:3
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_8_WOFFSET                       0x0
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_8_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_8_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_8_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_8_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_9_SHIFT                 _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_9_FIELD                 (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_9_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_9_RANGE                 15:11
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_9_WOFFSET                       0x0
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_9_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_9_DEFAULT_MASK                  _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_9_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_9_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_10_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_10_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_10_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_10_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_10_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_10_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_10_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_10_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_10_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_11_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_11_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_11_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_11_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_11_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_11_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_11_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_11_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_10_0_PRIORITY_LEVEL_SPI_11_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_11_0  
#define FIC_DIST_PRIORITY_LEVEL_11_0                    _MK_ADDR_CONST(0x142c)
#define FIC_DIST_PRIORITY_LEVEL_11_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_11_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_11_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_11_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_11_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_11_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_11_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_11_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_12_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_12_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_12_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_12_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_12_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_12_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_12_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_12_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_12_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_13_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_13_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_13_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_13_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_13_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_13_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_13_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_13_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_13_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_14_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_14_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_14_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_14_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_14_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_14_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_14_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_14_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_14_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_15_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_15_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_15_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_15_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_15_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_15_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_15_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_15_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_11_0_PRIORITY_LEVEL_SPI_15_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_12_0  
#define FIC_DIST_PRIORITY_LEVEL_12_0                    _MK_ADDR_CONST(0x1430)
#define FIC_DIST_PRIORITY_LEVEL_12_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_12_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_12_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_12_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_12_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_12_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_12_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_12_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_16_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_16_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_16_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_16_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_16_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_16_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_16_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_16_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_16_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_17_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_17_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_17_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_17_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_17_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_17_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_17_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_17_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_17_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_18_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_18_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_18_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_18_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_18_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_18_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_18_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_18_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_18_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_19_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_19_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_19_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_19_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_19_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_19_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_19_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_19_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_12_0_PRIORITY_LEVEL_SPI_19_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_13_0  
#define FIC_DIST_PRIORITY_LEVEL_13_0                    _MK_ADDR_CONST(0x1434)
#define FIC_DIST_PRIORITY_LEVEL_13_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_13_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_13_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_13_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_13_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_13_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_13_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_13_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_20_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_20_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_20_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_20_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_20_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_20_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_20_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_20_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_20_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_21_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_21_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_21_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_21_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_21_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_21_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_21_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_21_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_21_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_22_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_22_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_22_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_22_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_22_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_22_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_22_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_22_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_22_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_23_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_23_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_23_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_23_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_23_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_23_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_23_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_23_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_13_0_PRIORITY_LEVEL_SPI_23_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_14_0  
#define FIC_DIST_PRIORITY_LEVEL_14_0                    _MK_ADDR_CONST(0x1438)
#define FIC_DIST_PRIORITY_LEVEL_14_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_14_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_14_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_14_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_14_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_14_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_14_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_14_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_24_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_24_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_24_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_24_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_24_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_24_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_24_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_24_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_24_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_25_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_25_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_25_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_25_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_25_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_25_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_25_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_25_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_25_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_26_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_26_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_26_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_26_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_26_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_26_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_26_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_26_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_26_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_27_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_27_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_27_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_27_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_27_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_27_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_27_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_27_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_14_0_PRIORITY_LEVEL_SPI_27_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_15_0  
#define FIC_DIST_PRIORITY_LEVEL_15_0                    _MK_ADDR_CONST(0x143c)
#define FIC_DIST_PRIORITY_LEVEL_15_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_15_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_15_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_15_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_15_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_15_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_15_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_15_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_28_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_28_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_28_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_28_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_28_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_28_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_28_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_28_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_28_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_29_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_29_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_29_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_29_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_29_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_29_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_29_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_29_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_29_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_30_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_30_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_30_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_30_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_30_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_30_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_30_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_30_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_30_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_31_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_31_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_31_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_31_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_31_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_31_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_31_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_31_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_15_0_PRIORITY_LEVEL_SPI_31_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_16_0  
#define FIC_DIST_PRIORITY_LEVEL_16_0                    _MK_ADDR_CONST(0x1440)
#define FIC_DIST_PRIORITY_LEVEL_16_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_16_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_16_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_16_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_16_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_16_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_16_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_16_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_32_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_32_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_32_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_32_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_32_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_32_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_32_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_32_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_32_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_33_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_33_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_33_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_33_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_33_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_33_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_33_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_33_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_33_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_34_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_34_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_34_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_34_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_34_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_34_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_34_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_34_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_34_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_35_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_35_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_35_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_35_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_35_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_35_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_35_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_35_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_16_0_PRIORITY_LEVEL_SPI_35_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_17_0  
#define FIC_DIST_PRIORITY_LEVEL_17_0                    _MK_ADDR_CONST(0x1444)
#define FIC_DIST_PRIORITY_LEVEL_17_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_17_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_17_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_17_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_17_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_17_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_17_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_17_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_36_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_36_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_36_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_36_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_36_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_36_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_36_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_36_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_36_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_37_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_37_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_37_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_37_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_37_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_37_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_37_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_37_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_37_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_38_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_38_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_38_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_38_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_38_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_38_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_38_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_38_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_38_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_39_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_39_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_39_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_39_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_39_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_39_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_39_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_39_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_17_0_PRIORITY_LEVEL_SPI_39_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_18_0  
#define FIC_DIST_PRIORITY_LEVEL_18_0                    _MK_ADDR_CONST(0x1448)
#define FIC_DIST_PRIORITY_LEVEL_18_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_18_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_18_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_18_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_18_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_18_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_18_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_18_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_40_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_40_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_40_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_40_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_40_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_40_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_40_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_40_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_40_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_41_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_41_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_41_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_41_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_41_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_41_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_41_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_41_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_41_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_42_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_42_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_42_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_42_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_42_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_42_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_42_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_42_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_42_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_43_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_43_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_43_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_43_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_43_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_43_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_43_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_43_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_18_0_PRIORITY_LEVEL_SPI_43_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_19_0  
#define FIC_DIST_PRIORITY_LEVEL_19_0                    _MK_ADDR_CONST(0x144c)
#define FIC_DIST_PRIORITY_LEVEL_19_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_19_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_19_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_19_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_19_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_19_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_19_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_19_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_44_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_44_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_44_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_44_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_44_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_44_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_44_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_44_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_44_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_45_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_45_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_45_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_45_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_45_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_45_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_45_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_45_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_45_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_46_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_46_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_46_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_46_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_46_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_46_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_46_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_46_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_46_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_47_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_47_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_47_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_47_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_47_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_47_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_47_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_47_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_19_0_PRIORITY_LEVEL_SPI_47_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_20_0  
#define FIC_DIST_PRIORITY_LEVEL_20_0                    _MK_ADDR_CONST(0x1450)
#define FIC_DIST_PRIORITY_LEVEL_20_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_20_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_20_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_20_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_20_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_20_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_20_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_20_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_48_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_48_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_48_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_48_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_48_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_48_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_48_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_48_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_48_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_49_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_49_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_49_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_49_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_49_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_49_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_49_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_49_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_49_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_50_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_50_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_50_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_50_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_50_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_50_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_50_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_50_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_50_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_51_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_51_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_51_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_51_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_51_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_51_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_51_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_51_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_20_0_PRIORITY_LEVEL_SPI_51_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_21_0  
#define FIC_DIST_PRIORITY_LEVEL_21_0                    _MK_ADDR_CONST(0x1454)
#define FIC_DIST_PRIORITY_LEVEL_21_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_21_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_21_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_21_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_21_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_21_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_21_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_21_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_52_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_52_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_52_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_52_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_52_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_52_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_52_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_52_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_52_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_53_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_53_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_53_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_53_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_53_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_53_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_53_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_53_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_53_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_54_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_54_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_54_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_54_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_54_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_54_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_54_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_54_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_54_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_55_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_55_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_55_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_55_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_55_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_55_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_55_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_55_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_21_0_PRIORITY_LEVEL_SPI_55_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_22_0  
#define FIC_DIST_PRIORITY_LEVEL_22_0                    _MK_ADDR_CONST(0x1458)
#define FIC_DIST_PRIORITY_LEVEL_22_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_22_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_22_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_22_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_22_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_22_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_22_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_22_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_56_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_56_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_56_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_56_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_56_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_56_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_56_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_56_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_56_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_57_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_57_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_57_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_57_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_57_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_57_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_57_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_57_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_57_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_58_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_58_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_58_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_58_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_58_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_58_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_58_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_58_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_58_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_59_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_59_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_59_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_59_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_59_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_59_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_59_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_59_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_22_0_PRIORITY_LEVEL_SPI_59_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_23_0  
#define FIC_DIST_PRIORITY_LEVEL_23_0                    _MK_ADDR_CONST(0x145c)
#define FIC_DIST_PRIORITY_LEVEL_23_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_23_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_23_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_23_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_23_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_23_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_23_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_23_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_60_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_60_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_60_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_60_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_60_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_60_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_60_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_60_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_60_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_61_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_61_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_61_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_61_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_61_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_61_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_61_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_61_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_61_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_62_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_62_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_62_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_62_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_62_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_62_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_62_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_62_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_62_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_63_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_63_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_63_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_63_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_63_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_63_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_63_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_63_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_23_0_PRIORITY_LEVEL_SPI_63_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_24_0  
#define FIC_DIST_PRIORITY_LEVEL_24_0                    _MK_ADDR_CONST(0x1460)
#define FIC_DIST_PRIORITY_LEVEL_24_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_24_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_24_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_24_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_24_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_24_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_24_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_24_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_64_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_64_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_64_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_64_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_64_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_64_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_64_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_64_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_64_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_65_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_65_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_65_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_65_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_65_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_65_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_65_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_65_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_65_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_66_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_66_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_66_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_66_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_66_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_66_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_66_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_66_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_66_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_67_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_67_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_67_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_67_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_67_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_67_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_67_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_67_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_24_0_PRIORITY_LEVEL_SPI_67_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_25_0  
#define FIC_DIST_PRIORITY_LEVEL_25_0                    _MK_ADDR_CONST(0x1464)
#define FIC_DIST_PRIORITY_LEVEL_25_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_25_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_25_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_25_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_25_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_25_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_25_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_25_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_68_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_68_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_68_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_68_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_68_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_68_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_68_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_68_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_68_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_69_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_69_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_69_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_69_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_69_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_69_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_69_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_69_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_69_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_70_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_70_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_70_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_70_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_70_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_70_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_70_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_70_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_70_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_71_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_71_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_71_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_71_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_71_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_71_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_71_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_71_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_25_0_PRIORITY_LEVEL_SPI_71_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_26_0  
#define FIC_DIST_PRIORITY_LEVEL_26_0                    _MK_ADDR_CONST(0x1468)
#define FIC_DIST_PRIORITY_LEVEL_26_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_26_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_26_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_26_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_26_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_26_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_26_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_26_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_72_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_72_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_72_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_72_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_72_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_72_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_72_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_72_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_72_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_73_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_73_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_73_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_73_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_73_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_73_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_73_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_73_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_73_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_74_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_74_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_74_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_74_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_74_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_74_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_74_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_74_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_74_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_75_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_75_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_75_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_75_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_75_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_75_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_75_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_75_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_26_0_PRIORITY_LEVEL_SPI_75_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_27_0  
#define FIC_DIST_PRIORITY_LEVEL_27_0                    _MK_ADDR_CONST(0x146c)
#define FIC_DIST_PRIORITY_LEVEL_27_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_27_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_27_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_27_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_27_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_27_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_27_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_27_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_76_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_76_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_76_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_76_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_76_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_76_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_76_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_76_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_76_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_77_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_77_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_77_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_77_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_77_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_77_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_77_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_77_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_77_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_78_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_78_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_78_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_78_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_78_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_78_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_78_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_78_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_78_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_79_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_79_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_79_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_79_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_79_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_79_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_79_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_79_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_27_0_PRIORITY_LEVEL_SPI_79_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_28_0  
#define FIC_DIST_PRIORITY_LEVEL_28_0                    _MK_ADDR_CONST(0x1470)
#define FIC_DIST_PRIORITY_LEVEL_28_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_28_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_28_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_28_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_28_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_28_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_28_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_28_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_80_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_80_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_80_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_80_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_80_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_80_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_80_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_80_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_80_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_81_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_81_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_81_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_81_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_81_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_81_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_81_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_81_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_81_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_82_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_82_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_82_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_82_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_82_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_82_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_82_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_82_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_82_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_83_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_83_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_83_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_83_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_83_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_83_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_83_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_83_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_28_0_PRIORITY_LEVEL_SPI_83_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_29_0  
#define FIC_DIST_PRIORITY_LEVEL_29_0                    _MK_ADDR_CONST(0x1474)
#define FIC_DIST_PRIORITY_LEVEL_29_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_29_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_29_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_29_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_29_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_29_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_29_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_29_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_84_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_84_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_84_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_84_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_84_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_84_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_84_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_84_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_84_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_85_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_85_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_85_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_85_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_85_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_85_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_85_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_85_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_85_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_86_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_86_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_86_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_86_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_86_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_86_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_86_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_86_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_86_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_87_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_87_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_87_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_87_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_87_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_87_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_87_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_87_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_29_0_PRIORITY_LEVEL_SPI_87_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_30_0  
#define FIC_DIST_PRIORITY_LEVEL_30_0                    _MK_ADDR_CONST(0x1478)
#define FIC_DIST_PRIORITY_LEVEL_30_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_30_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_30_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_30_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_30_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_30_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_30_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_30_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_88_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_88_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_88_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_88_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_88_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_88_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_88_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_88_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_88_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_89_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_89_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_89_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_89_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_89_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_89_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_89_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_89_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_89_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_90_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_90_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_90_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_90_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_90_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_90_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_90_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_90_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_90_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_91_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_91_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_91_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_91_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_91_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_91_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_91_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_91_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_30_0_PRIORITY_LEVEL_SPI_91_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_31_0  
#define FIC_DIST_PRIORITY_LEVEL_31_0                    _MK_ADDR_CONST(0x147c)
#define FIC_DIST_PRIORITY_LEVEL_31_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_31_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_31_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_31_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_31_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_31_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_31_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_31_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_92_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_92_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_92_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_92_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_92_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_92_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_92_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_92_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_92_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_93_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_93_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_93_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_93_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_93_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_93_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_93_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_93_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_93_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_94_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_94_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_94_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_94_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_94_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_94_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_94_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_94_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_94_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_95_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_95_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_95_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_95_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_95_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_95_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_95_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_95_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_31_0_PRIORITY_LEVEL_SPI_95_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_32_0  
#define FIC_DIST_PRIORITY_LEVEL_32_0                    _MK_ADDR_CONST(0x1480)
#define FIC_DIST_PRIORITY_LEVEL_32_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_32_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_32_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_32_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_32_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_32_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_32_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_32_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_96_SHIFT                        _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_96_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_96_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_96_RANGE                        7:3
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_96_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_96_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_96_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_96_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_96_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_97_SHIFT                        _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_97_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_97_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_97_RANGE                        15:11
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_97_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_97_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_97_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_97_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_97_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_98_SHIFT                        _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_98_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_98_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_98_RANGE                        23:19
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_98_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_98_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_98_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_98_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_98_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_99_SHIFT                        _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_99_FIELD                        (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_99_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_99_RANGE                        31:27
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_99_WOFFSET                      0x0
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_99_DEFAULT                      _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_99_DEFAULT_MASK                 _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_99_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_32_0_PRIORITY_LEVEL_SPI_99_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_33_0  
#define FIC_DIST_PRIORITY_LEVEL_33_0                    _MK_ADDR_CONST(0x1484)
#define FIC_DIST_PRIORITY_LEVEL_33_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_33_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_33_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_33_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_33_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_33_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_33_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_33_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_100_SHIFT                       _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_100_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_100_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_100_RANGE                       7:3
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_100_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_100_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_100_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_100_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_100_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_101_SHIFT                       _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_101_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_101_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_101_RANGE                       15:11
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_101_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_101_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_101_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_101_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_101_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_102_SHIFT                       _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_102_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_102_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_102_RANGE                       23:19
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_102_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_102_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_102_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_102_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_102_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_103_SHIFT                       _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_103_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_103_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_103_RANGE                       31:27
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_103_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_103_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_103_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_103_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_33_0_PRIORITY_LEVEL_SPI_103_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_34_0  
#define FIC_DIST_PRIORITY_LEVEL_34_0                    _MK_ADDR_CONST(0x1488)
#define FIC_DIST_PRIORITY_LEVEL_34_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_34_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_34_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_34_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_34_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_34_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_34_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_34_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_104_SHIFT                       _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_104_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_104_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_104_RANGE                       7:3
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_104_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_104_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_104_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_104_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_104_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_105_SHIFT                       _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_105_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_105_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_105_RANGE                       15:11
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_105_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_105_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_105_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_105_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_105_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_106_SHIFT                       _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_106_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_106_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_106_RANGE                       23:19
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_106_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_106_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_106_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_106_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_106_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_107_SHIFT                       _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_107_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_107_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_107_RANGE                       31:27
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_107_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_107_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_107_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_107_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_34_0_PRIORITY_LEVEL_SPI_107_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_35_0  
#define FIC_DIST_PRIORITY_LEVEL_35_0                    _MK_ADDR_CONST(0x148c)
#define FIC_DIST_PRIORITY_LEVEL_35_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_35_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_35_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_35_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_35_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_35_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_35_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_35_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_108_SHIFT                       _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_108_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_108_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_108_RANGE                       7:3
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_108_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_108_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_108_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_108_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_108_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_109_SHIFT                       _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_109_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_109_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_109_RANGE                       15:11
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_109_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_109_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_109_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_109_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_109_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_110_SHIFT                       _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_110_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_110_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_110_RANGE                       23:19
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_110_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_110_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_110_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_110_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_110_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_111_SHIFT                       _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_111_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_111_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_111_RANGE                       31:27
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_111_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_111_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_111_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_111_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_35_0_PRIORITY_LEVEL_SPI_111_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_36_0  
#define FIC_DIST_PRIORITY_LEVEL_36_0                    _MK_ADDR_CONST(0x1490)
#define FIC_DIST_PRIORITY_LEVEL_36_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_36_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_36_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_36_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_36_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_36_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_36_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_36_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_112_SHIFT                       _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_112_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_112_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_112_RANGE                       7:3
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_112_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_112_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_112_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_112_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_112_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_113_SHIFT                       _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_113_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_113_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_113_RANGE                       15:11
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_113_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_113_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_113_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_113_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_113_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_114_SHIFT                       _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_114_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_114_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_114_RANGE                       23:19
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_114_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_114_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_114_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_114_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_114_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_115_SHIFT                       _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_115_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_115_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_115_RANGE                       31:27
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_115_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_115_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_115_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_115_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_36_0_PRIORITY_LEVEL_SPI_115_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_37_0  
#define FIC_DIST_PRIORITY_LEVEL_37_0                    _MK_ADDR_CONST(0x1494)
#define FIC_DIST_PRIORITY_LEVEL_37_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_37_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_37_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_37_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_37_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_37_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_37_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_37_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_116_SHIFT                       _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_116_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_116_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_116_RANGE                       7:3
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_116_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_116_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_116_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_116_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_116_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_117_SHIFT                       _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_117_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_117_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_117_RANGE                       15:11
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_117_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_117_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_117_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_117_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_117_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_118_SHIFT                       _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_118_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_118_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_118_RANGE                       23:19
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_118_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_118_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_118_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_118_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_118_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_119_SHIFT                       _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_119_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_119_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_119_RANGE                       31:27
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_119_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_119_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_119_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_119_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_37_0_PRIORITY_LEVEL_SPI_119_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_38_0  
#define FIC_DIST_PRIORITY_LEVEL_38_0                    _MK_ADDR_CONST(0x1498)
#define FIC_DIST_PRIORITY_LEVEL_38_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_38_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_38_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_38_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_38_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_38_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_38_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_38_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_120_SHIFT                       _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_120_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_120_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_120_RANGE                       7:3
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_120_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_120_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_120_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_120_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_120_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_121_SHIFT                       _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_121_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_121_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_121_RANGE                       15:11
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_121_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_121_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_121_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_121_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_121_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_122_SHIFT                       _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_122_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_122_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_122_RANGE                       23:19
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_122_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_122_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_122_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_122_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_122_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_123_SHIFT                       _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_123_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_123_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_123_RANGE                       31:27
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_123_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_123_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_123_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_123_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_38_0_PRIORITY_LEVEL_SPI_123_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register FIC_DIST_PRIORITY_LEVEL_39_0  
#define FIC_DIST_PRIORITY_LEVEL_39_0                    _MK_ADDR_CONST(0x149c)
#define FIC_DIST_PRIORITY_LEVEL_39_0_SECURE                     0x0
#define FIC_DIST_PRIORITY_LEVEL_39_0_WORD_COUNT                         0x1
#define FIC_DIST_PRIORITY_LEVEL_39_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_39_0_RESET_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_39_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_39_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_39_0_READ_MASK                  _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_39_0_WRITE_MASK                         _MK_MASK_CONST(0xf8f8f8f8)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_124_SHIFT                       _MK_SHIFT_CONST(3)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_124_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_124_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_124_RANGE                       7:3
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_124_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_124_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_124_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_124_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_124_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_125_SHIFT                       _MK_SHIFT_CONST(11)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_125_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_125_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_125_RANGE                       15:11
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_125_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_125_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_125_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_125_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_125_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_126_SHIFT                       _MK_SHIFT_CONST(19)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_126_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_126_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_126_RANGE                       23:19
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_126_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_126_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_126_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_126_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_126_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_127_SHIFT                       _MK_SHIFT_CONST(27)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_127_FIELD                       (_MK_MASK_CONST(0x1f) << FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_127_SHIFT)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_127_RANGE                       31:27
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_127_WOFFSET                     0x0
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_127_DEFAULT                     _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_127_DEFAULT_MASK                        _MK_MASK_CONST(0x1f)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_127_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_PRIORITY_LEVEL_39_0_PRIORITY_LEVEL_SPI_127_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Reserved address 5280 [0x14a0] 

// Reserved address 5284 [0x14a4] 

// Reserved address 5288 [0x14a8] 

// Reserved address 5292 [0x14ac] 

// Reserved address 5296 [0x14b0] 

// Reserved address 5300 [0x14b4] 

// Reserved address 5304 [0x14b8] 

// Reserved address 5308 [0x14bc] 

// Reserved address 5312 [0x14c0] 

// Reserved address 5316 [0x14c4] 

// Reserved address 5320 [0x14c8] 

// Reserved address 5324 [0x14cc] 

// Reserved address 5328 [0x14d0] 

// Reserved address 5332 [0x14d4] 

// Reserved address 5336 [0x14d8] 

// Reserved address 5340 [0x14dc] 

// Reserved address 5344 [0x14e0] 

// Reserved address 5348 [0x14e4] 

// Reserved address 5352 [0x14e8] 

// Reserved address 5356 [0x14ec] 

// Reserved address 5360 [0x14f0] 

// Reserved address 5364 [0x14f4] 

// Reserved address 5368 [0x14f8] 

// Reserved address 5372 [0x14fc] 

// Reserved address 5376 [0x1500] 

// Reserved address 5380 [0x1504] 

// Reserved address 5384 [0x1508] 

// Reserved address 5388 [0x150c] 

// Reserved address 5392 [0x1510] 

// Reserved address 5396 [0x1514] 

// Reserved address 5400 [0x1518] 

// Reserved address 5404 [0x151c] 

// Reserved address 5408 [0x1520] 

// Reserved address 5412 [0x1524] 

// Reserved address 5416 [0x1528] 

// Reserved address 5420 [0x152c] 

// Reserved address 5424 [0x1530] 

// Reserved address 5428 [0x1534] 

// Reserved address 5432 [0x1538] 

// Reserved address 5436 [0x153c] 

// Reserved address 5440 [0x1540] 

// Reserved address 5444 [0x1544] 

// Reserved address 5448 [0x1548] 

// Reserved address 5452 [0x154c] 

// Reserved address 5456 [0x1550] 

// Reserved address 5460 [0x1554] 

// Reserved address 5464 [0x1558] 

// Reserved address 5468 [0x155c] 

// Reserved address 5472 [0x1560] 

// Reserved address 5476 [0x1564] 

// Reserved address 5480 [0x1568] 

// Reserved address 5484 [0x156c] 

// Reserved address 5488 [0x1570] 

// Reserved address 5492 [0x1574] 

// Reserved address 5496 [0x1578] 

// Reserved address 5500 [0x157c] 

// Reserved address 5504 [0x1580] 

// Reserved address 5508 [0x1584] 

// Reserved address 5512 [0x1588] 

// Reserved address 5516 [0x158c] 

// Reserved address 5520 [0x1590] 

// Reserved address 5524 [0x1594] 

// Reserved address 5528 [0x1598] 

// Reserved address 5532 [0x159c] 

// Reserved address 5536 [0x15a0] 

// Reserved address 5540 [0x15a4] 

// Reserved address 5544 [0x15a8] 

// Reserved address 5548 [0x15ac] 

// Reserved address 5552 [0x15b0] 

// Reserved address 5556 [0x15b4] 

// Reserved address 5560 [0x15b8] 

// Reserved address 5564 [0x15bc] 

// Reserved address 5568 [0x15c0] 

// Reserved address 5572 [0x15c4] 

// Reserved address 5576 [0x15c8] 

// Reserved address 5580 [0x15cc] 

// Reserved address 5584 [0x15d0] 

// Reserved address 5588 [0x15d4] 

// Reserved address 5592 [0x15d8] 

// Reserved address 5596 [0x15dc] 

// Reserved address 5600 [0x15e0] 

// Reserved address 5604 [0x15e4] 

// Reserved address 5608 [0x15e8] 

// Reserved address 5612 [0x15ec] 

// Reserved address 5616 [0x15f0] 

// Reserved address 5620 [0x15f4] 

// Reserved address 5624 [0x15f8] 

// Reserved address 5628 [0x15fc] 

// Reserved address 5632 [0x1600] 

// Reserved address 5636 [0x1604] 

// Reserved address 5640 [0x1608] 

// Reserved address 5644 [0x160c] 

// Reserved address 5648 [0x1610] 

// Reserved address 5652 [0x1614] 

// Reserved address 5656 [0x1618] 

// Reserved address 5660 [0x161c] 

// Reserved address 5664 [0x1620] 

// Reserved address 5668 [0x1624] 

// Reserved address 5672 [0x1628] 

// Reserved address 5676 [0x162c] 

// Reserved address 5680 [0x1630] 

// Reserved address 5684 [0x1634] 

// Reserved address 5688 [0x1638] 

// Reserved address 5692 [0x163c] 

// Reserved address 5696 [0x1640] 

// Reserved address 5700 [0x1644] 

// Reserved address 5704 [0x1648] 

// Reserved address 5708 [0x164c] 

// Reserved address 5712 [0x1650] 

// Reserved address 5716 [0x1654] 

// Reserved address 5720 [0x1658] 

// Reserved address 5724 [0x165c] 

// Reserved address 5728 [0x1660] 

// Reserved address 5732 [0x1664] 

// Reserved address 5736 [0x1668] 

// Reserved address 5740 [0x166c] 

// Reserved address 5744 [0x1670] 

// Reserved address 5748 [0x1674] 

// Reserved address 5752 [0x1678] 

// Reserved address 5756 [0x167c] 

// Reserved address 5760 [0x1680] 

// Reserved address 5764 [0x1684] 

// Reserved address 5768 [0x1688] 

// Reserved address 5772 [0x168c] 

// Reserved address 5776 [0x1690] 

// Reserved address 5780 [0x1694] 

// Reserved address 5784 [0x1698] 

// Reserved address 5788 [0x169c] 

// Reserved address 5792 [0x16a0] 

// Reserved address 5796 [0x16a4] 

// Reserved address 5800 [0x16a8] 

// Reserved address 5804 [0x16ac] 

// Reserved address 5808 [0x16b0] 

// Reserved address 5812 [0x16b4] 

// Reserved address 5816 [0x16b8] 

// Reserved address 5820 [0x16bc] 

// Reserved address 5824 [0x16c0] 

// Reserved address 5828 [0x16c4] 

// Reserved address 5832 [0x16c8] 

// Reserved address 5836 [0x16cc] 

// Reserved address 5840 [0x16d0] 

// Reserved address 5844 [0x16d4] 

// Reserved address 5848 [0x16d8] 

// Reserved address 5852 [0x16dc] 

// Reserved address 5856 [0x16e0] 

// Reserved address 5860 [0x16e4] 

// Reserved address 5864 [0x16e8] 

// Reserved address 5868 [0x16ec] 

// Reserved address 5872 [0x16f0] 

// Reserved address 5876 [0x16f4] 

// Reserved address 5880 [0x16f8] 

// Reserved address 5884 [0x16fc] 

// Reserved address 5888 [0x1700] 

// Reserved address 5892 [0x1704] 

// Reserved address 5896 [0x1708] 

// Reserved address 5900 [0x170c] 

// Reserved address 5904 [0x1710] 

// Reserved address 5908 [0x1714] 

// Reserved address 5912 [0x1718] 

// Reserved address 5916 [0x171c] 

// Reserved address 5920 [0x1720] 

// Reserved address 5924 [0x1724] 

// Reserved address 5928 [0x1728] 

// Reserved address 5932 [0x172c] 

// Reserved address 5936 [0x1730] 

// Reserved address 5940 [0x1734] 

// Reserved address 5944 [0x1738] 

// Reserved address 5948 [0x173c] 

// Reserved address 5952 [0x1740] 

// Reserved address 5956 [0x1744] 

// Reserved address 5960 [0x1748] 

// Reserved address 5964 [0x174c] 

// Reserved address 5968 [0x1750] 

// Reserved address 5972 [0x1754] 

// Reserved address 5976 [0x1758] 

// Reserved address 5980 [0x175c] 

// Reserved address 5984 [0x1760] 

// Reserved address 5988 [0x1764] 

// Reserved address 5992 [0x1768] 

// Reserved address 5996 [0x176c] 

// Reserved address 6000 [0x1770] 

// Reserved address 6004 [0x1774] 

// Reserved address 6008 [0x1778] 

// Reserved address 6012 [0x177c] 

// Reserved address 6016 [0x1780] 

// Reserved address 6020 [0x1784] 

// Reserved address 6024 [0x1788] 

// Reserved address 6028 [0x178c] 

// Reserved address 6032 [0x1790] 

// Reserved address 6036 [0x1794] 

// Reserved address 6040 [0x1798] 

// Reserved address 6044 [0x179c] 

// Reserved address 6048 [0x17a0] 

// Reserved address 6052 [0x17a4] 

// Reserved address 6056 [0x17a8] 

// Reserved address 6060 [0x17ac] 

// Reserved address 6064 [0x17b0] 

// Reserved address 6068 [0x17b4] 

// Reserved address 6072 [0x17b8] 

// Reserved address 6076 [0x17bc] 

// Reserved address 6080 [0x17c0] 

// Reserved address 6084 [0x17c4] 

// Reserved address 6088 [0x17c8] 

// Reserved address 6092 [0x17cc] 

// Reserved address 6096 [0x17d0] 

// Reserved address 6100 [0x17d4] 

// Reserved address 6104 [0x17d8] 

// Reserved address 6108 [0x17dc] 

// Reserved address 6112 [0x17e0] 

// Reserved address 6116 [0x17e4] 

// Reserved address 6120 [0x17e8] 

// Reserved address 6124 [0x17ec] 

// Reserved address 6128 [0x17f0] 

// Reserved address 6132 [0x17f4] 

// Reserved address 6136 [0x17f8] 

// Reserved address 6140 [0x17fc] 

// Register FIC_DIST_SPI_TARGET_0_0  
#define FIC_DIST_SPI_TARGET_0_0                 _MK_ADDR_CONST(0x1800)
#define FIC_DIST_SPI_TARGET_0_0_SECURE                  0x0
#define FIC_DIST_SPI_TARGET_0_0_WORD_COUNT                      0x1
#define FIC_DIST_SPI_TARGET_0_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_RESET_MASK                      _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_READ_MASK                       _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_0_0_WRITE_MASK                      _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU0_SHIFT                     _MK_SHIFT_CONST(0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU0_RANGE                     0:0
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU1_SHIFT                     _MK_SHIFT_CONST(1)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU1_RANGE                     1:1
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_0_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU0_SHIFT                     _MK_SHIFT_CONST(8)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU0_RANGE                     8:8
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU1_SHIFT                     _MK_SHIFT_CONST(9)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU1_RANGE                     9:9
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_1_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU0_SHIFT                     _MK_SHIFT_CONST(16)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU0_RANGE                     16:16
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU1_SHIFT                     _MK_SHIFT_CONST(17)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU1_RANGE                     17:17
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_2_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU0_SHIFT                     _MK_SHIFT_CONST(24)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU0_RANGE                     24:24
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU1_SHIFT                     _MK_SHIFT_CONST(25)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU1_RANGE                     25:25
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_0_0_SPI_TARGET_STI_3_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FIC_DIST_SPI_TARGET_1_0  
#define FIC_DIST_SPI_TARGET_1_0                 _MK_ADDR_CONST(0x1804)
#define FIC_DIST_SPI_TARGET_1_0_SECURE                  0x0
#define FIC_DIST_SPI_TARGET_1_0_WORD_COUNT                      0x1
#define FIC_DIST_SPI_TARGET_1_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_RESET_MASK                      _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_READ_MASK                       _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_1_0_WRITE_MASK                      _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU0_SHIFT                     _MK_SHIFT_CONST(0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU0_RANGE                     0:0
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU1_SHIFT                     _MK_SHIFT_CONST(1)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU1_RANGE                     1:1
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_4_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU0_SHIFT                     _MK_SHIFT_CONST(8)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU0_RANGE                     8:8
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU1_SHIFT                     _MK_SHIFT_CONST(9)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU1_RANGE                     9:9
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_5_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU0_SHIFT                     _MK_SHIFT_CONST(16)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU0_RANGE                     16:16
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU1_SHIFT                     _MK_SHIFT_CONST(17)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU1_RANGE                     17:17
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_6_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU0_SHIFT                     _MK_SHIFT_CONST(24)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU0_RANGE                     24:24
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU1_SHIFT                     _MK_SHIFT_CONST(25)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU1_RANGE                     25:25
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_1_0_SPI_TARGET_STI_7_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FIC_DIST_SPI_TARGET_2_0  
#define FIC_DIST_SPI_TARGET_2_0                 _MK_ADDR_CONST(0x1808)
#define FIC_DIST_SPI_TARGET_2_0_SECURE                  0x0
#define FIC_DIST_SPI_TARGET_2_0_WORD_COUNT                      0x1
#define FIC_DIST_SPI_TARGET_2_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_RESET_MASK                      _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_READ_MASK                       _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_2_0_WRITE_MASK                      _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU0_SHIFT                     _MK_SHIFT_CONST(0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU0_RANGE                     0:0
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU1_SHIFT                     _MK_SHIFT_CONST(1)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU1_RANGE                     1:1
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_8_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU0_SHIFT                     _MK_SHIFT_CONST(8)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU0_RANGE                     8:8
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU1_SHIFT                     _MK_SHIFT_CONST(9)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU1_RANGE                     9:9
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_9_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU0_SHIFT                    _MK_SHIFT_CONST(16)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU0_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU0_RANGE                    16:16
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU0_WOFFSET                  0x0
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU1_SHIFT                    _MK_SHIFT_CONST(17)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU1_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU1_RANGE                    17:17
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU1_WOFFSET                  0x0
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_10_CPU1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU0_SHIFT                    _MK_SHIFT_CONST(24)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU0_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU0_RANGE                    24:24
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU0_WOFFSET                  0x0
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU1_SHIFT                    _MK_SHIFT_CONST(25)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU1_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU1_RANGE                    25:25
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU1_WOFFSET                  0x0
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_2_0_SPI_TARGET_STI_11_CPU1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register FIC_DIST_SPI_TARGET_3_0  
#define FIC_DIST_SPI_TARGET_3_0                 _MK_ADDR_CONST(0x180c)
#define FIC_DIST_SPI_TARGET_3_0_SECURE                  0x0
#define FIC_DIST_SPI_TARGET_3_0_WORD_COUNT                      0x1
#define FIC_DIST_SPI_TARGET_3_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_RESET_MASK                      _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_3_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_READ_MASK                       _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_3_0_WRITE_MASK                      _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU0_SHIFT                    _MK_SHIFT_CONST(0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU0_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU0_RANGE                    0:0
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU0_WOFFSET                  0x0
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU1_SHIFT                    _MK_SHIFT_CONST(1)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU1_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU1_RANGE                    1:1
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU1_WOFFSET                  0x0
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_12_CPU1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU0_SHIFT                    _MK_SHIFT_CONST(8)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU0_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU0_RANGE                    8:8
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU0_WOFFSET                  0x0
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU1_SHIFT                    _MK_SHIFT_CONST(9)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU1_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU1_RANGE                    9:9
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU1_WOFFSET                  0x0
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_13_CPU1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU0_SHIFT                    _MK_SHIFT_CONST(16)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU0_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU0_RANGE                    16:16
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU0_WOFFSET                  0x0
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU1_SHIFT                    _MK_SHIFT_CONST(17)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU1_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU1_RANGE                    17:17
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU1_WOFFSET                  0x0
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_14_CPU1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU0_SHIFT                    _MK_SHIFT_CONST(24)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU0_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU0_RANGE                    24:24
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU0_WOFFSET                  0x0
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU0_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU0_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU0_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU1_SHIFT                    _MK_SHIFT_CONST(25)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU1_FIELD                    (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU1_RANGE                    25:25
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU1_WOFFSET                  0x0
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU1_DEFAULT                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU1_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU1_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_3_0_SPI_TARGET_STI_15_CPU1_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Reserved address 6160 [0x1810] 

// Reserved address 6164 [0x1814] 

// Reserved address 6168 [0x1818] 

// Reserved address 6172 [0x181c] 

// Register FIC_DIST_SPI_TARGET_4_0  
#define FIC_DIST_SPI_TARGET_4_0                 _MK_ADDR_CONST(0x1820)
#define FIC_DIST_SPI_TARGET_4_0_SECURE                  0x0
#define FIC_DIST_SPI_TARGET_4_0_WORD_COUNT                      0x1
#define FIC_DIST_SPI_TARGET_4_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_RESET_MASK                      _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_4_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_READ_MASK                       _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_4_0_WRITE_MASK                      _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU0_SHIFT                     _MK_SHIFT_CONST(0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU0_RANGE                     0:0
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU1_SHIFT                     _MK_SHIFT_CONST(1)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU1_RANGE                     1:1
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_0_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU0_SHIFT                     _MK_SHIFT_CONST(8)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU0_RANGE                     8:8
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU1_SHIFT                     _MK_SHIFT_CONST(9)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU1_RANGE                     9:9
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_1_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU0_SHIFT                     _MK_SHIFT_CONST(16)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU0_RANGE                     16:16
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU1_SHIFT                     _MK_SHIFT_CONST(17)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU1_RANGE                     17:17
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_2_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU0_SHIFT                     _MK_SHIFT_CONST(24)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU0_RANGE                     24:24
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU1_SHIFT                     _MK_SHIFT_CONST(25)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU1_RANGE                     25:25
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_4_0_SPI_TARGET_SPI_3_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register FIC_DIST_SPI_TARGET_5_0  
#define FIC_DIST_SPI_TARGET_5_0                 _MK_ADDR_CONST(0x1824)
#define FIC_DIST_SPI_TARGET_5_0_SECURE                  0x0
#define FIC_DIST_SPI_TARGET_5_0_WORD_COUNT                      0x1
#define FIC_DIST_SPI_TARGET_5_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_RESET_MASK                      _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_5_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_READ_MASK                       _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_5_0_WRITE_MASK                      _MK_MASK_CONST(0x3030303)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU0_SHIFT                     _MK_SHIFT_CONST(0)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU0_RANGE                     0:0
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU1_SHIFT                     _MK_SHIFT_CONST(1)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU1_RANGE                     1:1
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_4_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU0_SHIFT                     _MK_SHIFT_CONST(8)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU0_RANGE                     8:8
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU1_SHIFT                     _MK_SHIFT_CONST(9)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU1_RANGE                     9:9
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_5_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU0_SHIFT                     _MK_SHIFT_CONST(16)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU0_RANGE                     16:16
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU1_SHIFT                     _MK_SHIFT_CONST(17)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU1_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU1_SHIFT)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU1_RANGE                     17:17
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU1_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU1_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU1_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_6_CPU1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_7_CPU0_SHIFT                     _MK_SHIFT_CONST(24)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_7_CPU0_FIELD                     (_MK_MASK_CONST(0x1) << FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_7_CPU0_SHIFT)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_7_CPU0_RANGE                     24:24
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_7_CPU0_WOFFSET                   0x0
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_7_CPU0_DEFAULT                   _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_7_CPU0_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_7_CPU0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_7_CPU0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_7_CPU1_SHIFT                     _MK_SHIFT_CONST(25)
#define FIC_DIST_SPI_TARGET_5_0_SPI_TARGET_SPI_7_CPU1_FIELD                 