/*
 * Copyright (c) 2009 NVIDIA Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the NVIDIA Corporation nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
//
// DO NOT EDIT - generated by simspec!
//

#ifndef ___ARMC_H_INC_
#define ___ARMC_H_INC_

// Register MC_INTSTATUS_0  
#define MC_INTSTATUS_0                  _MK_ADDR_CONST(0x0)
#define MC_INTSTATUS_0_SECURE                   0x0
#define MC_INTSTATUS_0_WORD_COUNT                       0x1
#define MC_INTSTATUS_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define MC_INTSTATUS_0_RESET_MASK                       _MK_MASK_CONST(0x1c0)
#define MC_INTSTATUS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define MC_INTSTATUS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_INTSTATUS_0_READ_MASK                        _MK_MASK_CONST(0x1c0)
#define MC_INTSTATUS_0_WRITE_MASK                       _MK_MASK_CONST(0x1c0)
// EMEM Address Decode Error for a non AXI client.
#define MC_INTSTATUS_0_DECERR_EMEM_OTHERS_INT_SHIFT                     _MK_SHIFT_CONST(6)
#define MC_INTSTATUS_0_DECERR_EMEM_OTHERS_INT_FIELD                     (_MK_MASK_CONST(0x1) << MC_INTSTATUS_0_DECERR_EMEM_OTHERS_INT_SHIFT)
#define MC_INTSTATUS_0_DECERR_EMEM_OTHERS_INT_RANGE                     6:6
#define MC_INTSTATUS_0_DECERR_EMEM_OTHERS_INT_WOFFSET                   0x0
#define MC_INTSTATUS_0_DECERR_EMEM_OTHERS_INT_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_INTSTATUS_0_DECERR_EMEM_OTHERS_INT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_INTSTATUS_0_DECERR_EMEM_OTHERS_INT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_INTSTATUS_0_DECERR_EMEM_OTHERS_INT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_INTSTATUS_0_DECERR_EMEM_OTHERS_INT_INIT_ENUM                 CLEAR
#define MC_INTSTATUS_0_DECERR_EMEM_OTHERS_INT_CLEAR                     _MK_ENUM_CONST(0)
#define MC_INTSTATUS_0_DECERR_EMEM_OTHERS_INT_SET                       _MK_ENUM_CONST(1)

// A GART access was attepted to an invalid page.
#define MC_INTSTATUS_0_INVALID_GART_PAGE_INT_SHIFT                      _MK_SHIFT_CONST(7)
#define MC_INTSTATUS_0_INVALID_GART_PAGE_INT_FIELD                      (_MK_MASK_CONST(0x1) << MC_INTSTATUS_0_INVALID_GART_PAGE_INT_SHIFT)
#define MC_INTSTATUS_0_INVALID_GART_PAGE_INT_RANGE                      7:7
#define MC_INTSTATUS_0_INVALID_GART_PAGE_INT_WOFFSET                    0x0
#define MC_INTSTATUS_0_INVALID_GART_PAGE_INT_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_INTSTATUS_0_INVALID_GART_PAGE_INT_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_INTSTATUS_0_INVALID_GART_PAGE_INT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_INTSTATUS_0_INVALID_GART_PAGE_INT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_INTSTATUS_0_INVALID_GART_PAGE_INT_INIT_ENUM                  CLEAR
#define MC_INTSTATUS_0_INVALID_GART_PAGE_INT_CLEAR                      _MK_ENUM_CONST(0)
#define MC_INTSTATUS_0_INVALID_GART_PAGE_INT_SET                        _MK_ENUM_CONST(1)

// A nonsecure access was attempted to a secured region.
#define MC_INTSTATUS_0_SECURITY_VIOLATION_INT_SHIFT                     _MK_SHIFT_CONST(8)
#define MC_INTSTATUS_0_SECURITY_VIOLATION_INT_FIELD                     (_MK_MASK_CONST(0x1) << MC_INTSTATUS_0_SECURITY_VIOLATION_INT_SHIFT)
#define MC_INTSTATUS_0_SECURITY_VIOLATION_INT_RANGE                     8:8
#define MC_INTSTATUS_0_SECURITY_VIOLATION_INT_WOFFSET                   0x0
#define MC_INTSTATUS_0_SECURITY_VIOLATION_INT_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_INTSTATUS_0_SECURITY_VIOLATION_INT_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_INTSTATUS_0_SECURITY_VIOLATION_INT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_INTSTATUS_0_SECURITY_VIOLATION_INT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_INTSTATUS_0_SECURITY_VIOLATION_INT_INIT_ENUM                 CLEAR
#define MC_INTSTATUS_0_SECURITY_VIOLATION_INT_CLEAR                     _MK_ENUM_CONST(0)
#define MC_INTSTATUS_0_SECURITY_VIOLATION_INT_SET                       _MK_ENUM_CONST(1)


// Register MC_INTMASK_0  
#define MC_INTMASK_0                    _MK_ADDR_CONST(0x4)
#define MC_INTMASK_0_SECURE                     0x0
#define MC_INTMASK_0_WORD_COUNT                         0x1
#define MC_INTMASK_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define MC_INTMASK_0_RESET_MASK                         _MK_MASK_CONST(0x1c0)
#define MC_INTMASK_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define MC_INTMASK_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_INTMASK_0_READ_MASK                  _MK_MASK_CONST(0x1c0)
#define MC_INTMASK_0_WRITE_MASK                         _MK_MASK_CONST(0x1c0)
// EMEM Address Decode Error for a non AXI client.
#define MC_INTMASK_0_DECERR_EMEM_OTHERS_INTMASK_SHIFT                   _MK_SHIFT_CONST(6)
#define MC_INTMASK_0_DECERR_EMEM_OTHERS_INTMASK_FIELD                   (_MK_MASK_CONST(0x1) << MC_INTMASK_0_DECERR_EMEM_OTHERS_INTMASK_SHIFT)
#define MC_INTMASK_0_DECERR_EMEM_OTHERS_INTMASK_RANGE                   6:6
#define MC_INTMASK_0_DECERR_EMEM_OTHERS_INTMASK_WOFFSET                 0x0
#define MC_INTMASK_0_DECERR_EMEM_OTHERS_INTMASK_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_INTMASK_0_DECERR_EMEM_OTHERS_INTMASK_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_INTMASK_0_DECERR_EMEM_OTHERS_INTMASK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_INTMASK_0_DECERR_EMEM_OTHERS_INTMASK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_INTMASK_0_DECERR_EMEM_OTHERS_INTMASK_INIT_ENUM                       MASKED
#define MC_INTMASK_0_DECERR_EMEM_OTHERS_INTMASK_MASKED                  _MK_ENUM_CONST(0)
#define MC_INTMASK_0_DECERR_EMEM_OTHERS_INTMASK_UNMASKED                        _MK_ENUM_CONST(1)

// A GART access was attepted to an invalid page.
#define MC_INTMASK_0_INVALID_GART_PAGE_INTMASK_SHIFT                    _MK_SHIFT_CONST(7)
#define MC_INTMASK_0_INVALID_GART_PAGE_INTMASK_FIELD                    (_MK_MASK_CONST(0x1) << MC_INTMASK_0_INVALID_GART_PAGE_INTMASK_SHIFT)
#define MC_INTMASK_0_INVALID_GART_PAGE_INTMASK_RANGE                    7:7
#define MC_INTMASK_0_INVALID_GART_PAGE_INTMASK_WOFFSET                  0x0
#define MC_INTMASK_0_INVALID_GART_PAGE_INTMASK_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_INTMASK_0_INVALID_GART_PAGE_INTMASK_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_INTMASK_0_INVALID_GART_PAGE_INTMASK_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_INTMASK_0_INVALID_GART_PAGE_INTMASK_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_INTMASK_0_INVALID_GART_PAGE_INTMASK_INIT_ENUM                        MASKED
#define MC_INTMASK_0_INVALID_GART_PAGE_INTMASK_MASKED                   _MK_ENUM_CONST(0)
#define MC_INTMASK_0_INVALID_GART_PAGE_INTMASK_UNMASKED                 _MK_ENUM_CONST(1)

// A nonsecure access was attempted to a secured region.
#define MC_INTMASK_0_SECURITY_VIOLATION_INTMASK_SHIFT                   _MK_SHIFT_CONST(8)
#define MC_INTMASK_0_SECURITY_VIOLATION_INTMASK_FIELD                   (_MK_MASK_CONST(0x1) << MC_INTMASK_0_SECURITY_VIOLATION_INTMASK_SHIFT)
#define MC_INTMASK_0_SECURITY_VIOLATION_INTMASK_RANGE                   8:8
#define MC_INTMASK_0_SECURITY_VIOLATION_INTMASK_WOFFSET                 0x0
#define MC_INTMASK_0_SECURITY_VIOLATION_INTMASK_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_INTMASK_0_SECURITY_VIOLATION_INTMASK_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_INTMASK_0_SECURITY_VIOLATION_INTMASK_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_INTMASK_0_SECURITY_VIOLATION_INTMASK_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_INTMASK_0_SECURITY_VIOLATION_INTMASK_INIT_ENUM                       MASKED
#define MC_INTMASK_0_SECURITY_VIOLATION_INTMASK_MASKED                  _MK_ENUM_CONST(0)
#define MC_INTMASK_0_SECURITY_VIOLATION_INTMASK_UNMASKED                        _MK_ENUM_CONST(1)


// Reserved address 8 [0x8] 

// Register MC_EMEM_CFG_0  
#define MC_EMEM_CFG_0                   _MK_ADDR_CONST(0xc)
#define MC_EMEM_CFG_0_SECURE                    0x0
#define MC_EMEM_CFG_0_WORD_COUNT                        0x1
#define MC_EMEM_CFG_0_RESET_VAL                         _MK_MASK_CONST(0x10000)
#define MC_EMEM_CFG_0_RESET_MASK                        _MK_MASK_CONST(0x3fffff)
#define MC_EMEM_CFG_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define MC_EMEM_CFG_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_EMEM_CFG_0_READ_MASK                         _MK_MASK_CONST(0x3fffff)
#define MC_EMEM_CFG_0_WRITE_MASK                        _MK_MASK_CONST(0x3fffff)
#define MC_EMEM_CFG_0_EMEM_SIZE_KB_SHIFT                        _MK_SHIFT_CONST(0)
#define MC_EMEM_CFG_0_EMEM_SIZE_KB_FIELD                        (_MK_MASK_CONST(0x3fffff) << MC_EMEM_CFG_0_EMEM_SIZE_KB_SHIFT)
#define MC_EMEM_CFG_0_EMEM_SIZE_KB_RANGE                        21:0
#define MC_EMEM_CFG_0_EMEM_SIZE_KB_WOFFSET                      0x0
#define MC_EMEM_CFG_0_EMEM_SIZE_KB_DEFAULT                      _MK_MASK_CONST(0x10000)
#define MC_EMEM_CFG_0_EMEM_SIZE_KB_DEFAULT_MASK                 _MK_MASK_CONST(0x3fffff)
#define MC_EMEM_CFG_0_EMEM_SIZE_KB_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_EMEM_CFG_0_EMEM_SIZE_KB_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register MC_EMEM_ADR_CFG_0  
#define MC_EMEM_ADR_CFG_0                       _MK_ADDR_CONST(0x10)
#define MC_EMEM_ADR_CFG_0_SECURE                        0x0
#define MC_EMEM_ADR_CFG_0_WORD_COUNT                    0x1
#define MC_EMEM_ADR_CFG_0_RESET_VAL                     _MK_MASK_CONST(0x40202)
#define MC_EMEM_ADR_CFG_0_RESET_MASK                    _MK_MASK_CONST(0x30f0307)
#define MC_EMEM_ADR_CFG_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_EMEM_ADR_CFG_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_EMEM_ADR_CFG_0_READ_MASK                     _MK_MASK_CONST(0x30f0307)
#define MC_EMEM_ADR_CFG_0_WRITE_MASK                    _MK_MASK_CONST(0x30f0307)
#define MC_EMEM_ADR_CFG_0_EMEM_COLWIDTH_SHIFT                   _MK_SHIFT_CONST(0)
#define MC_EMEM_ADR_CFG_0_EMEM_COLWIDTH_FIELD                   (_MK_MASK_CONST(0x7) << MC_EMEM_ADR_CFG_0_EMEM_COLWIDTH_SHIFT)
#define MC_EMEM_ADR_CFG_0_EMEM_COLWIDTH_RANGE                   2:0
#define MC_EMEM_ADR_CFG_0_EMEM_COLWIDTH_WOFFSET                 0x0
#define MC_EMEM_ADR_CFG_0_EMEM_COLWIDTH_DEFAULT                 _MK_MASK_CONST(0x2)
#define MC_EMEM_ADR_CFG_0_EMEM_COLWIDTH_DEFAULT_MASK                    _MK_MASK_CONST(0x7)
#define MC_EMEM_ADR_CFG_0_EMEM_COLWIDTH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_EMEM_ADR_CFG_0_EMEM_COLWIDTH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_EMEM_ADR_CFG_0_EMEM_COLWIDTH_INIT_ENUM                       W9
#define MC_EMEM_ADR_CFG_0_EMEM_COLWIDTH_W7                      _MK_ENUM_CONST(0)
#define MC_EMEM_ADR_CFG_0_EMEM_COLWIDTH_W8                      _MK_ENUM_CONST(1)
#define MC_EMEM_ADR_CFG_0_EMEM_COLWIDTH_W9                      _MK_ENUM_CONST(2)
#define MC_EMEM_ADR_CFG_0_EMEM_COLWIDTH_W10                     _MK_ENUM_CONST(3)
#define MC_EMEM_ADR_CFG_0_EMEM_COLWIDTH_W11                     _MK_ENUM_CONST(4)

#define MC_EMEM_ADR_CFG_0_EMEM_BANKWIDTH_SHIFT                  _MK_SHIFT_CONST(8)
#define MC_EMEM_ADR_CFG_0_EMEM_BANKWIDTH_FIELD                  (_MK_MASK_CONST(0x3) << MC_EMEM_ADR_CFG_0_EMEM_BANKWIDTH_SHIFT)
#define MC_EMEM_ADR_CFG_0_EMEM_BANKWIDTH_RANGE                  9:8
#define MC_EMEM_ADR_CFG_0_EMEM_BANKWIDTH_WOFFSET                        0x0
#define MC_EMEM_ADR_CFG_0_EMEM_BANKWIDTH_DEFAULT                        _MK_MASK_CONST(0x2)
#define MC_EMEM_ADR_CFG_0_EMEM_BANKWIDTH_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define MC_EMEM_ADR_CFG_0_EMEM_BANKWIDTH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_EMEM_ADR_CFG_0_EMEM_BANKWIDTH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_EMEM_ADR_CFG_0_EMEM_BANKWIDTH_INIT_ENUM                      W2
#define MC_EMEM_ADR_CFG_0_EMEM_BANKWIDTH_W1                     _MK_ENUM_CONST(1)
#define MC_EMEM_ADR_CFG_0_EMEM_BANKWIDTH_W2                     _MK_ENUM_CONST(2)
#define MC_EMEM_ADR_CFG_0_EMEM_BANKWIDTH_W3                     _MK_ENUM_CONST(3)

#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_SHIFT                    _MK_SHIFT_CONST(16)
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_FIELD                    (_MK_MASK_CONST(0xf) << MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_SHIFT)
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_RANGE                    19:16
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_WOFFSET                  0x0
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_DEFAULT                  _MK_MASK_CONST(0x4)
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_INIT_ENUM                        D64MB
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_D4MB                     _MK_ENUM_CONST(0)
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_D8MB                     _MK_ENUM_CONST(1)
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_D16MB                    _MK_ENUM_CONST(2)
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_D32MB                    _MK_ENUM_CONST(3)
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_D64MB                    _MK_ENUM_CONST(4)
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_D128MB                   _MK_ENUM_CONST(5)
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_D256MB                   _MK_ENUM_CONST(6)
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_D512MB                   _MK_ENUM_CONST(7)
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_D1024MB                  _MK_ENUM_CONST(8)
#define MC_EMEM_ADR_CFG_0_EMEM_DEVSIZE_D1GB                     _MK_ENUM_CONST(8)

#define MC_EMEM_ADR_CFG_0_EMEM_NUMDEV_SHIFT                     _MK_SHIFT_CONST(24)
#define MC_EMEM_ADR_CFG_0_EMEM_NUMDEV_FIELD                     (_MK_MASK_CONST(0x3) << MC_EMEM_ADR_CFG_0_EMEM_NUMDEV_SHIFT)
#define MC_EMEM_ADR_CFG_0_EMEM_NUMDEV_RANGE                     25:24
#define MC_EMEM_ADR_CFG_0_EMEM_NUMDEV_WOFFSET                   0x0
#define MC_EMEM_ADR_CFG_0_EMEM_NUMDEV_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_EMEM_ADR_CFG_0_EMEM_NUMDEV_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define MC_EMEM_ADR_CFG_0_EMEM_NUMDEV_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_EMEM_ADR_CFG_0_EMEM_NUMDEV_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_EMEM_ADR_CFG_0_EMEM_NUMDEV_INIT_ENUM                 N1
#define MC_EMEM_ADR_CFG_0_EMEM_NUMDEV_N1                        _MK_ENUM_CONST(0)
#define MC_EMEM_ADR_CFG_0_EMEM_NUMDEV_N2                        _MK_ENUM_CONST(1)

#define NV_MC_ARB_EMEM_SPMSB    5

// Register MC_EMEM_ARB_CFG0_0  
#define MC_EMEM_ARB_CFG0_0                      _MK_ADDR_CONST(0x14)
#define MC_EMEM_ARB_CFG0_0_SECURE                       0x0
#define MC_EMEM_ARB_CFG0_0_WORD_COUNT                   0x1
#define MC_EMEM_ARB_CFG0_0_RESET_VAL                    _MK_MASK_CONST(0x102030)
#define MC_EMEM_ARB_CFG0_0_RESET_MASK                   _MK_MASK_CONST(0x703fffff)
#define MC_EMEM_ARB_CFG0_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG0_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG0_0_READ_MASK                    _MK_MASK_CONST(0x703fffff)
#define MC_EMEM_ARB_CFG0_0_WRITE_MASK                   _MK_MASK_CONST(0x703fffff)
#define MC_EMEM_ARB_CFG0_0_EMEM_RWCNT_TH_SHIFT                  _MK_SHIFT_CONST(0)
#define MC_EMEM_ARB_CFG0_0_EMEM_RWCNT_TH_FIELD                  (_MK_MASK_CONST(0xff) << MC_EMEM_ARB_CFG0_0_EMEM_RWCNT_TH_SHIFT)
#define MC_EMEM_ARB_CFG0_0_EMEM_RWCNT_TH_RANGE                  7:0
#define MC_EMEM_ARB_CFG0_0_EMEM_RWCNT_TH_WOFFSET                        0x0
#define MC_EMEM_ARB_CFG0_0_EMEM_RWCNT_TH_DEFAULT                        _MK_MASK_CONST(0x30)
#define MC_EMEM_ARB_CFG0_0_EMEM_RWCNT_TH_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define MC_EMEM_ARB_CFG0_0_EMEM_RWCNT_TH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG0_0_EMEM_RWCNT_TH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define MC_EMEM_ARB_CFG0_0_EMEM_WRCNT_TH_SHIFT                  _MK_SHIFT_CONST(8)
#define MC_EMEM_ARB_CFG0_0_EMEM_WRCNT_TH_FIELD                  (_MK_MASK_CONST(0xff) << MC_EMEM_ARB_CFG0_0_EMEM_WRCNT_TH_SHIFT)
#define MC_EMEM_ARB_CFG0_0_EMEM_WRCNT_TH_RANGE                  15:8
#define MC_EMEM_ARB_CFG0_0_EMEM_WRCNT_TH_WOFFSET                        0x0
#define MC_EMEM_ARB_CFG0_0_EMEM_WRCNT_TH_DEFAULT                        _MK_MASK_CONST(0x20)
#define MC_EMEM_ARB_CFG0_0_EMEM_WRCNT_TH_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define MC_EMEM_ARB_CFG0_0_EMEM_WRCNT_TH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG0_0_EMEM_WRCNT_TH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define MC_EMEM_ARB_CFG0_0_EMEM_SP_MAX_GRANT_OVERALL_SHIFT                      _MK_SHIFT_CONST(16)
#define MC_EMEM_ARB_CFG0_0_EMEM_SP_MAX_GRANT_OVERALL_FIELD                      (_MK_MASK_CONST(0x3f) << MC_EMEM_ARB_CFG0_0_EMEM_SP_MAX_GRANT_OVERALL_SHIFT)
#define MC_EMEM_ARB_CFG0_0_EMEM_SP_MAX_GRANT_OVERALL_RANGE                      21:16
#define MC_EMEM_ARB_CFG0_0_EMEM_SP_MAX_GRANT_OVERALL_WOFFSET                    0x0
#define MC_EMEM_ARB_CFG0_0_EMEM_SP_MAX_GRANT_OVERALL_DEFAULT                    _MK_MASK_CONST(0x10)
#define MC_EMEM_ARB_CFG0_0_EMEM_SP_MAX_GRANT_OVERALL_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define MC_EMEM_ARB_CFG0_0_EMEM_SP_MAX_GRANT_OVERALL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG0_0_EMEM_SP_MAX_GRANT_OVERALL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_SP_ON_AUTOPC_SHIFT                        _MK_SHIFT_CONST(28)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_SP_ON_AUTOPC_FIELD                        (_MK_MASK_CONST(0x1) << MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_SP_ON_AUTOPC_SHIFT)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_SP_ON_AUTOPC_RANGE                        28:28
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_SP_ON_AUTOPC_WOFFSET                      0x0
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_SP_ON_AUTOPC_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_SP_ON_AUTOPC_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_SP_ON_AUTOPC_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_SP_ON_AUTOPC_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_SP_ON_AUTOPC_INIT_ENUM                    DISABLE
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_SP_ON_AUTOPC_DISABLE                      _MK_ENUM_CONST(0)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_SP_ON_AUTOPC_ENABLE                       _MK_ENUM_CONST(1)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_SP_ON_AUTOPC_DISABLED                     _MK_ENUM_CONST(0)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_SP_ON_AUTOPC_ENABLED                      _MK_ENUM_CONST(1)

#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_AP_PREV_SPREQ_SHIFT                       _MK_SHIFT_CONST(29)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_AP_PREV_SPREQ_FIELD                       (_MK_MASK_CONST(0x1) << MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_AP_PREV_SPREQ_SHIFT)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_AP_PREV_SPREQ_RANGE                       29:29
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_AP_PREV_SPREQ_WOFFSET                     0x0
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_AP_PREV_SPREQ_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_AP_PREV_SPREQ_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_AP_PREV_SPREQ_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_AP_PREV_SPREQ_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_AP_PREV_SPREQ_INIT_ENUM                   DISABLE
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_AP_PREV_SPREQ_DISABLE                     _MK_ENUM_CONST(0)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_AP_PREV_SPREQ_ENABLE                      _MK_ENUM_CONST(1)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_AP_PREV_SPREQ_DISABLED                    _MK_ENUM_CONST(0)
#define MC_EMEM_ARB_CFG0_0_EMEM_CLEAR_AP_PREV_SPREQ_ENABLED                     _MK_ENUM_CONST(1)

#define MC_EMEM_ARB_CFG0_0_EMEM_NOBLOCK_BY_BANK_WHEN_HP_SHIFT                   _MK_SHIFT_CONST(30)
#define MC_EMEM_ARB_CFG0_0_EMEM_NOBLOCK_BY_BANK_WHEN_HP_FIELD                   (_MK_MASK_CONST(0x1) << MC_EMEM_ARB_CFG0_0_EMEM_NOBLOCK_BY_BANK_WHEN_HP_SHIFT)
#define MC_EMEM_ARB_CFG0_0_EMEM_NOBLOCK_BY_BANK_WHEN_HP_RANGE                   30:30
#define MC_EMEM_ARB_CFG0_0_EMEM_NOBLOCK_BY_BANK_WHEN_HP_WOFFSET                 0x0
#define MC_EMEM_ARB_CFG0_0_EMEM_NOBLOCK_BY_BANK_WHEN_HP_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG0_0_EMEM_NOBLOCK_BY_BANK_WHEN_HP_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_EMEM_ARB_CFG0_0_EMEM_NOBLOCK_BY_BANK_WHEN_HP_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG0_0_EMEM_NOBLOCK_BY_BANK_WHEN_HP_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG0_0_EMEM_NOBLOCK_BY_BANK_WHEN_HP_INIT_ENUM                       DISABLE
#define MC_EMEM_ARB_CFG0_0_EMEM_NOBLOCK_BY_BANK_WHEN_HP_DISABLE                 _MK_ENUM_CONST(0)
#define MC_EMEM_ARB_CFG0_0_EMEM_NOBLOCK_BY_BANK_WHEN_HP_ENABLE                  _MK_ENUM_CONST(1)
#define MC_EMEM_ARB_CFG0_0_EMEM_NOBLOCK_BY_BANK_WHEN_HP_DISABLED                        _MK_ENUM_CONST(0)
#define MC_EMEM_ARB_CFG0_0_EMEM_NOBLOCK_BY_BANK_WHEN_HP_ENABLED                 _MK_ENUM_CONST(1)


// Register MC_EMEM_ARB_CFG1_0  
#define MC_EMEM_ARB_CFG1_0                      _MK_ADDR_CONST(0x18)
#define MC_EMEM_ARB_CFG1_0_SECURE                       0x0
#define MC_EMEM_ARB_CFG1_0_WORD_COUNT                   0x1
#define MC_EMEM_ARB_CFG1_0_RESET_VAL                    _MK_MASK_CONST(0x1010f7df)
#define MC_EMEM_ARB_CFG1_0_RESET_MASK                   _MK_MASK_CONST(0x3f3ff7df)
#define MC_EMEM_ARB_CFG1_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG1_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG1_0_READ_MASK                    _MK_MASK_CONST(0x3f3ff7df)
#define MC_EMEM_ARB_CFG1_0_WRITE_MASK                   _MK_MASK_CONST(0x3f3ff7df)
#define MC_EMEM_ARB_CFG1_0_EMEM_RCL_MASK_SHIFT                  _MK_SHIFT_CONST(0)
#define MC_EMEM_ARB_CFG1_0_EMEM_RCL_MASK_FIELD                  (_MK_MASK_CONST(0x1f) << MC_EMEM_ARB_CFG1_0_EMEM_RCL_MASK_SHIFT)
#define MC_EMEM_ARB_CFG1_0_EMEM_RCL_MASK_RANGE                  4:0
#define MC_EMEM_ARB_CFG1_0_EMEM_RCL_MASK_WOFFSET                        0x0
#define MC_EMEM_ARB_CFG1_0_EMEM_RCL_MASK_DEFAULT                        _MK_MASK_CONST(0x1f)
#define MC_EMEM_ARB_CFG1_0_EMEM_RCL_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define MC_EMEM_ARB_CFG1_0_EMEM_RCL_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG1_0_EMEM_RCL_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG1_0_EMEM_RCL_MASK_INIT_ENUM                      ALL
#define MC_EMEM_ARB_CFG1_0_EMEM_RCL_MASK_NONE                   _MK_ENUM_CONST(0)
#define MC_EMEM_ARB_CFG1_0_EMEM_RCL_MASK_ALL                    _MK_ENUM_CONST(31)

#define MC_EMEM_ARB_CFG1_0_EMEM_WCL_MASK_SHIFT                  _MK_SHIFT_CONST(6)
#define MC_EMEM_ARB_CFG1_0_EMEM_WCL_MASK_FIELD                  (_MK_MASK_CONST(0x1f) << MC_EMEM_ARB_CFG1_0_EMEM_WCL_MASK_SHIFT)
#define MC_EMEM_ARB_CFG1_0_EMEM_WCL_MASK_RANGE                  10:6
#define MC_EMEM_ARB_CFG1_0_EMEM_WCL_MASK_WOFFSET                        0x0
#define MC_EMEM_ARB_CFG1_0_EMEM_WCL_MASK_DEFAULT                        _MK_MASK_CONST(0x1f)
#define MC_EMEM_ARB_CFG1_0_EMEM_WCL_MASK_DEFAULT_MASK                   _MK_MASK_CONST(0x1f)
#define MC_EMEM_ARB_CFG1_0_EMEM_WCL_MASK_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG1_0_EMEM_WCL_MASK_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG1_0_EMEM_WCL_MASK_INIT_ENUM                      ALL
#define MC_EMEM_ARB_CFG1_0_EMEM_WCL_MASK_NONE                   _MK_ENUM_CONST(0)
#define MC_EMEM_ARB_CFG1_0_EMEM_WCL_MASK_ALL                    _MK_ENUM_CONST(31)

#define MC_EMEM_ARB_CFG1_0_EMEM_NORWSWITCH_BKBLOCK_SHIFT                        _MK_SHIFT_CONST(12)
#define MC_EMEM_ARB_CFG1_0_EMEM_NORWSWITCH_BKBLOCK_FIELD                        (_MK_MASK_CONST(0x1) << MC_EMEM_ARB_CFG1_0_EMEM_NORWSWITCH_BKBLOCK_SHIFT)
#define MC_EMEM_ARB_CFG1_0_EMEM_NORWSWITCH_BKBLOCK_RANGE                        12:12
#define MC_EMEM_ARB_CFG1_0_EMEM_NORWSWITCH_BKBLOCK_WOFFSET                      0x0
#define MC_EMEM_ARB_CFG1_0_EMEM_NORWSWITCH_BKBLOCK_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_EMEM_ARB_CFG1_0_EMEM_NORWSWITCH_BKBLOCK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_EMEM_ARB_CFG1_0_EMEM_NORWSWITCH_BKBLOCK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG1_0_EMEM_NORWSWITCH_BKBLOCK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG1_0_EMEM_NORWSWITCH_BKBLOCK_INIT_ENUM                    ENABLE
#define MC_EMEM_ARB_CFG1_0_EMEM_NORWSWITCH_BKBLOCK_DISABLE                      _MK_ENUM_CONST(0)
#define MC_EMEM_ARB_CFG1_0_EMEM_NORWSWITCH_BKBLOCK_ENABLE                       _MK_ENUM_CONST(1)
#define MC_EMEM_ARB_CFG1_0_EMEM_NORWSWITCH_BKBLOCK_DISABLED                     _MK_ENUM_CONST(0)
#define MC_EMEM_ARB_CFG1_0_EMEM_NORWSWITCH_BKBLOCK_ENABLED                      _MK_ENUM_CONST(1)

#define MC_EMEM_ARB_CFG1_0_EMEM_NOWRSWITCH_BKBLOCK_SHIFT                        _MK_SHIFT_CONST(13)
#define MC_EMEM_ARB_CFG1_0_EMEM_NOWRSWITCH_BKBLOCK_FIELD                        (_MK_MASK_CONST(0x1) << MC_EMEM_ARB_CFG1_0_EMEM_NOWRSWITCH_BKBLOCK_SHIFT)
#define MC_EMEM_ARB_CFG1_0_EMEM_NOWRSWITCH_BKBLOCK_RANGE                        13:13
#define MC_EMEM_ARB_CFG1_0_EMEM_NOWRSWITCH_BKBLOCK_WOFFSET                      0x0
#define MC_EMEM_ARB_CFG1_0_EMEM_NOWRSWITCH_BKBLOCK_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_EMEM_ARB_CFG1_0_EMEM_NOWRSWITCH_BKBLOCK_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_EMEM_ARB_CFG1_0_EMEM_NOWRSWITCH_BKBLOCK_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG1_0_EMEM_NOWRSWITCH_BKBLOCK_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG1_0_EMEM_NOWRSWITCH_BKBLOCK_INIT_ENUM                    ENABLE
#define MC_EMEM_ARB_CFG1_0_EMEM_NOWRSWITCH_BKBLOCK_DISABLE                      _MK_ENUM_CONST(0)
#define MC_EMEM_ARB_CFG1_0_EMEM_NOWRSWITCH_BKBLOCK_ENABLE                       _MK_ENUM_CONST(1)
#define MC_EMEM_ARB_CFG1_0_EMEM_NOWRSWITCH_BKBLOCK_DISABLED                     _MK_ENUM_CONST(0)
#define MC_EMEM_ARB_CFG1_0_EMEM_NOWRSWITCH_BKBLOCK_ENABLED                      _MK_ENUM_CONST(1)

#define MC_EMEM_ARB_CFG1_0_EMEM_RWSWITCH_RWINEXPIRED_SHIFT                      _MK_SHIFT_CONST(14)
#define MC_EMEM_ARB_CFG1_0_EMEM_RWSWITCH_RWINEXPIRED_FIELD                      (_MK_MASK_CONST(0x1) << MC_EMEM_ARB_CFG1_0_EMEM_RWSWITCH_RWINEXPIRED_SHIFT)
#define MC_EMEM_ARB_CFG1_0_EMEM_RWSWITCH_RWINEXPIRED_RANGE                      14:14
#define MC_EMEM_ARB_CFG1_0_EMEM_RWSWITCH_RWINEXPIRED_WOFFSET                    0x0
#define MC_EMEM_ARB_CFG1_0_EMEM_RWSWITCH_RWINEXPIRED_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_EMEM_ARB_CFG1_0_EMEM_RWSWITCH_RWINEXPIRED_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_EMEM_ARB_CFG1_0_EMEM_RWSWITCH_RWINEXPIRED_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG1_0_EMEM_RWSWITCH_RWINEXPIRED_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG1_0_EMEM_RWSWITCH_RWINEXPIRED_INIT_ENUM                  ENABLE
#define MC_EMEM_ARB_CFG1_0_EMEM_RWSWITCH_RWINEXPIRED_DISABLE                    _MK_ENUM_CONST(0)
#define MC_EMEM_ARB_CFG1_0_EMEM_RWSWITCH_RWINEXPIRED_ENABLE                     _MK_ENUM_CONST(1)
#define MC_EMEM_ARB_CFG1_0_EMEM_RWSWITCH_RWINEXPIRED_DISABLED                   _MK_ENUM_CONST(0)
#define MC_EMEM_ARB_CFG1_0_EMEM_RWSWITCH_RWINEXPIRED_ENABLED                    _MK_ENUM_CONST(1)

#define MC_EMEM_ARB_CFG1_0_EMEM_WRSWITCH_WWINEXPIRED_SHIFT                      _MK_SHIFT_CONST(15)
#define MC_EMEM_ARB_CFG1_0_EMEM_WRSWITCH_WWINEXPIRED_FIELD                      (_MK_MASK_CONST(0x1) << MC_EMEM_ARB_CFG1_0_EMEM_WRSWITCH_WWINEXPIRED_SHIFT)
#define MC_EMEM_ARB_CFG1_0_EMEM_WRSWITCH_WWINEXPIRED_RANGE                      15:15
#define MC_EMEM_ARB_CFG1_0_EMEM_WRSWITCH_WWINEXPIRED_WOFFSET                    0x0
#define MC_EMEM_ARB_CFG1_0_EMEM_WRSWITCH_WWINEXPIRED_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_EMEM_ARB_CFG1_0_EMEM_WRSWITCH_WWINEXPIRED_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_EMEM_ARB_CFG1_0_EMEM_WRSWITCH_WWINEXPIRED_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG1_0_EMEM_WRSWITCH_WWINEXPIRED_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG1_0_EMEM_WRSWITCH_WWINEXPIRED_INIT_ENUM                  ENABLE
#define MC_EMEM_ARB_CFG1_0_EMEM_WRSWITCH_WWINEXPIRED_DISABLE                    _MK_ENUM_CONST(0)
#define MC_EMEM_ARB_CFG1_0_EMEM_WRSWITCH_WWINEXPIRED_ENABLE                     _MK_ENUM_CONST(1)
#define MC_EMEM_ARB_CFG1_0_EMEM_WRSWITCH_WWINEXPIRED_DISABLED                   _MK_ENUM_CONST(0)
#define MC_EMEM_ARB_CFG1_0_EMEM_WRSWITCH_WWINEXPIRED_ENABLED                    _MK_ENUM_CONST(1)

#define MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_SHIFT                      _MK_SHIFT_CONST(16)
#define MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_FIELD                      (_MK_MASK_CONST(0x3f) << MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_SHIFT)
#define MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_RANGE                      21:16
#define MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_WOFFSET                    0x0
#define MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_DEFAULT                    _MK_MASK_CONST(0x10)
#define MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_DEFAULT_MASK                       _MK_MASK_CONST(0x3f)
#define MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_RW_SHIFT                   _MK_SHIFT_CONST(24)
#define MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_RW_FIELD                   (_MK_MASK_CONST(0x3f) << MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_RW_SHIFT)
#define MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_RW_RANGE                   29:24
#define MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_RW_WOFFSET                 0x0
#define MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_RW_DEFAULT                 _MK_MASK_CONST(0x10)
#define MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_RW_DEFAULT_MASK                    _MK_MASK_CONST(0x3f)
#define MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_RW_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG1_0_EMEM_SP_MAX_GRANT_RW_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register MC_EMEM_ARB_CFG2_0  
#define MC_EMEM_ARB_CFG2_0                      _MK_ADDR_CONST(0x1c)
#define MC_EMEM_ARB_CFG2_0_SECURE                       0x0
#define MC_EMEM_ARB_CFG2_0_WORD_COUNT                   0x1
#define MC_EMEM_ARB_CFG2_0_RESET_VAL                    _MK_MASK_CONST(0xc080c08)
#define MC_EMEM_ARB_CFG2_0_RESET_MASK                   _MK_MASK_CONST(0x3f3f3f3f)
#define MC_EMEM_ARB_CFG2_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG2_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG2_0_READ_MASK                    _MK_MASK_CONST(0x3f3f3f3f)
#define MC_EMEM_ARB_CFG2_0_WRITE_MASK                   _MK_MASK_CONST(0x3f3f3f3f)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_RD_TH_SHIFT                     _MK_SHIFT_CONST(0)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_RD_TH_FIELD                     (_MK_MASK_CONST(0x3f) << MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_RD_TH_SHIFT)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_RD_TH_RANGE                     5:0
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_RD_TH_WOFFSET                   0x0
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_RD_TH_DEFAULT                   _MK_MASK_CONST(0x8)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_RD_TH_DEFAULT_MASK                      _MK_MASK_CONST(0x3f)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_RD_TH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_RD_TH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_RD_TH_SHIFT                 _MK_SHIFT_CONST(8)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_RD_TH_FIELD                 (_MK_MASK_CONST(0x3f) << MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_RD_TH_SHIFT)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_RD_TH_RANGE                 13:8
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_RD_TH_WOFFSET                       0x0
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_RD_TH_DEFAULT                       _MK_MASK_CONST(0xc)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_RD_TH_DEFAULT_MASK                  _MK_MASK_CONST(0x3f)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_RD_TH_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_RD_TH_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_WR_TH_SHIFT                     _MK_SHIFT_CONST(16)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_WR_TH_FIELD                     (_MK_MASK_CONST(0x3f) << MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_WR_TH_SHIFT)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_WR_TH_RANGE                     21:16
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_WR_TH_WOFFSET                   0x0
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_WR_TH_DEFAULT                   _MK_MASK_CONST(0x8)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_WR_TH_DEFAULT_MASK                      _MK_MASK_CONST(0x3f)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_WR_TH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_WR_TH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_WR_TH_SHIFT                 _MK_SHIFT_CONST(24)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_WR_TH_FIELD                 (_MK_MASK_CONST(0x3f) << MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_WR_TH_SHIFT)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_WR_TH_RANGE                 29:24
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_WR_TH_WOFFSET                       0x0
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_WR_TH_DEFAULT                       _MK_MASK_CONST(0xc)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_WR_TH_DEFAULT_MASK                  _MK_MASK_CONST(0x3f)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_WR_TH_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_EMEM_ARB_CFG2_0_EMEM_BANKCNT_NSP_WR_TH_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 32 [0x20] 

// Register MC_GART_CONFIG_0  
#define MC_GART_CONFIG_0                        _MK_ADDR_CONST(0x24)
#define MC_GART_CONFIG_0_SECURE                         0x0
#define MC_GART_CONFIG_0_WORD_COUNT                     0x1
#define MC_GART_CONFIG_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define MC_GART_CONFIG_0_RESET_MASK                     _MK_MASK_CONST(0x1)
#define MC_GART_CONFIG_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define MC_GART_CONFIG_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_GART_CONFIG_0_READ_MASK                      _MK_MASK_CONST(0x1)
#define MC_GART_CONFIG_0_WRITE_MASK                     _MK_MASK_CONST(0x1)
#define MC_GART_CONFIG_0_GART_ENABLE_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_GART_CONFIG_0_GART_ENABLE_FIELD                      (_MK_MASK_CONST(0x1) << MC_GART_CONFIG_0_GART_ENABLE_SHIFT)
#define MC_GART_CONFIG_0_GART_ENABLE_RANGE                      0:0
#define MC_GART_CONFIG_0_GART_ENABLE_WOFFSET                    0x0
#define MC_GART_CONFIG_0_GART_ENABLE_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_GART_CONFIG_0_GART_ENABLE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_GART_CONFIG_0_GART_ENABLE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_GART_CONFIG_0_GART_ENABLE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_GART_CONFIG_0_GART_ENABLE_INIT_ENUM                  DISABLE
#define MC_GART_CONFIG_0_GART_ENABLE_DISABLE                    _MK_ENUM_CONST(0)
#define MC_GART_CONFIG_0_GART_ENABLE_ENABLE                     _MK_ENUM_CONST(1)


// Register MC_GART_ENTRY_ADDR_0  
#define MC_GART_ENTRY_ADDR_0                    _MK_ADDR_CONST(0x28)
#define MC_GART_ENTRY_ADDR_0_SECURE                     0x0
#define MC_GART_ENTRY_ADDR_0_WORD_COUNT                         0x1
#define MC_GART_ENTRY_ADDR_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_ADDR_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_ADDR_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_ADDR_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_ADDR_0_READ_MASK                  _MK_MASK_CONST(0x1fff000)
#define MC_GART_ENTRY_ADDR_0_WRITE_MASK                         _MK_MASK_CONST(0x1fff000)
#define MC_GART_ENTRY_ADDR_0_GART_ENTRY_ADDR_TABLE_ADDR_SHIFT                   _MK_SHIFT_CONST(12)
#define MC_GART_ENTRY_ADDR_0_GART_ENTRY_ADDR_TABLE_ADDR_FIELD                   (_MK_MASK_CONST(0x1fff) << MC_GART_ENTRY_ADDR_0_GART_ENTRY_ADDR_TABLE_ADDR_SHIFT)
#define MC_GART_ENTRY_ADDR_0_GART_ENTRY_ADDR_TABLE_ADDR_RANGE                   24:12
#define MC_GART_ENTRY_ADDR_0_GART_ENTRY_ADDR_TABLE_ADDR_WOFFSET                 0x0
#define MC_GART_ENTRY_ADDR_0_GART_ENTRY_ADDR_TABLE_ADDR_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_ADDR_0_GART_ENTRY_ADDR_TABLE_ADDR_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_ADDR_0_GART_ENTRY_ADDR_TABLE_ADDR_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_ADDR_0_GART_ENTRY_ADDR_TABLE_ADDR_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register MC_GART_ENTRY_DATA_0  
#define MC_GART_ENTRY_DATA_0                    _MK_ADDR_CONST(0x2c)
#define MC_GART_ENTRY_DATA_0_SECURE                     0x0
#define MC_GART_ENTRY_DATA_0_WORD_COUNT                         0x1
#define MC_GART_ENTRY_DATA_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_DATA_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_DATA_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_DATA_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_DATA_0_READ_MASK                  _MK_MASK_CONST(0xfffff000)
#define MC_GART_ENTRY_DATA_0_WRITE_MASK                         _MK_MASK_CONST(0xfffff000)
#define MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_VALID_SHIFT                      _MK_SHIFT_CONST(31)
#define MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_VALID_FIELD                      (_MK_MASK_CONST(0x1) << MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_VALID_SHIFT)
#define MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_VALID_RANGE                      31:31
#define MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_VALID_WOFFSET                    0x0
#define MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_VALID_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_VALID_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_VALID_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_VALID_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_SHIFT                    _MK_SHIFT_CONST(12)
#define MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_FIELD                    (_MK_MASK_CONST(0x7ffff) << MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_SHIFT)
#define MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_RANGE                    30:12
#define MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_WOFFSET                  0x0
#define MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_GART_ENTRY_DATA_0_GART_ENTRY_DATA_PHYS_ADDR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register MC_GART_ERROR_REQ_0  
#define MC_GART_ERROR_REQ_0                     _MK_ADDR_CONST(0x30)
#define MC_GART_ERROR_REQ_0_SECURE                      0x0
#define MC_GART_ERROR_REQ_0_WORD_COUNT                  0x1
#define MC_GART_ERROR_REQ_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_REQ_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_REQ_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_REQ_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_REQ_0_READ_MASK                   _MK_MASK_CONST(0x7f)
#define MC_GART_ERROR_REQ_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_REQ_0_GART_ERROR_DIRECTION_SHIFT                  _MK_SHIFT_CONST(0)
#define MC_GART_ERROR_REQ_0_GART_ERROR_DIRECTION_FIELD                  (_MK_MASK_CONST(0x1) << MC_GART_ERROR_REQ_0_GART_ERROR_DIRECTION_SHIFT)
#define MC_GART_ERROR_REQ_0_GART_ERROR_DIRECTION_RANGE                  0:0
#define MC_GART_ERROR_REQ_0_GART_ERROR_DIRECTION_WOFFSET                        0x0
#define MC_GART_ERROR_REQ_0_GART_ERROR_DIRECTION_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_REQ_0_GART_ERROR_DIRECTION_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_REQ_0_GART_ERROR_DIRECTION_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_REQ_0_GART_ERROR_DIRECTION_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_REQ_0_GART_ERROR_DIRECTION_READ                   _MK_ENUM_CONST(0)
#define MC_GART_ERROR_REQ_0_GART_ERROR_DIRECTION_WRITE                  _MK_ENUM_CONST(1)

#define MC_GART_ERROR_REQ_0_GART_ERROR_CLIENT_ID_SHIFT                  _MK_SHIFT_CONST(1)
#define MC_GART_ERROR_REQ_0_GART_ERROR_CLIENT_ID_FIELD                  (_MK_MASK_CONST(0x3f) << MC_GART_ERROR_REQ_0_GART_ERROR_CLIENT_ID_SHIFT)
#define MC_GART_ERROR_REQ_0_GART_ERROR_CLIENT_ID_RANGE                  6:1
#define MC_GART_ERROR_REQ_0_GART_ERROR_CLIENT_ID_WOFFSET                        0x0
#define MC_GART_ERROR_REQ_0_GART_ERROR_CLIENT_ID_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_REQ_0_GART_ERROR_CLIENT_ID_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_REQ_0_GART_ERROR_CLIENT_ID_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_REQ_0_GART_ERROR_CLIENT_ID_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register MC_GART_ERROR_ADDR_0  
#define MC_GART_ERROR_ADDR_0                    _MK_ADDR_CONST(0x34)
#define MC_GART_ERROR_ADDR_0_SECURE                     0x0
#define MC_GART_ERROR_ADDR_0_WORD_COUNT                         0x1
#define MC_GART_ERROR_ADDR_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_ADDR_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_ADDR_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_ADDR_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_ADDR_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define MC_GART_ERROR_ADDR_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_ADDR_0_GART_ERROR_ADDRESS_SHIFT                   _MK_SHIFT_CONST(0)
#define MC_GART_ERROR_ADDR_0_GART_ERROR_ADDRESS_FIELD                   (_MK_MASK_CONST(0xffffffff) << MC_GART_ERROR_ADDR_0_GART_ERROR_ADDRESS_SHIFT)
#define MC_GART_ERROR_ADDR_0_GART_ERROR_ADDRESS_RANGE                   31:0
#define MC_GART_ERROR_ADDR_0_GART_ERROR_ADDRESS_WOFFSET                 0x0
#define MC_GART_ERROR_ADDR_0_GART_ERROR_ADDRESS_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_ADDR_0_GART_ERROR_ADDRESS_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_ADDR_0_GART_ERROR_ADDRESS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_GART_ERROR_ADDR_0_GART_ERROR_ADDRESS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Reserved address 56 [0x38] 

// Register MC_TIMEOUT_CTRL_0  
#define MC_TIMEOUT_CTRL_0                       _MK_ADDR_CONST(0x3c)
#define MC_TIMEOUT_CTRL_0_SECURE                        0x0
#define MC_TIMEOUT_CTRL_0_WORD_COUNT                    0x1
#define MC_TIMEOUT_CTRL_0_RESET_VAL                     _MK_MASK_CONST(0x28)
#define MC_TIMEOUT_CTRL_0_RESET_MASK                    _MK_MASK_CONST(0x78)
#define MC_TIMEOUT_CTRL_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_CTRL_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_CTRL_0_READ_MASK                     _MK_MASK_CONST(0x78)
#define MC_TIMEOUT_CTRL_0_WRITE_MASK                    _MK_MASK_CONST(0x78)
#define MC_TIMEOUT_CTRL_0_EMEM_TM_SFACTOR_SHIFT                 _MK_SHIFT_CONST(3)
#define MC_TIMEOUT_CTRL_0_EMEM_TM_SFACTOR_FIELD                 (_MK_MASK_CONST(0x7) << MC_TIMEOUT_CTRL_0_EMEM_TM_SFACTOR_SHIFT)
#define MC_TIMEOUT_CTRL_0_EMEM_TM_SFACTOR_RANGE                 5:3
#define MC_TIMEOUT_CTRL_0_EMEM_TM_SFACTOR_WOFFSET                       0x0
#define MC_TIMEOUT_CTRL_0_EMEM_TM_SFACTOR_DEFAULT                       _MK_MASK_CONST(0x5)
#define MC_TIMEOUT_CTRL_0_EMEM_TM_SFACTOR_DEFAULT_MASK                  _MK_MASK_CONST(0x7)
#define MC_TIMEOUT_CTRL_0_EMEM_TM_SFACTOR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_CTRL_0_EMEM_TM_SFACTOR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_CTRL_0_TMCREDITS_SHIFT                       _MK_SHIFT_CONST(6)
#define MC_TIMEOUT_CTRL_0_TMCREDITS_FIELD                       (_MK_MASK_CONST(0x1) << MC_TIMEOUT_CTRL_0_TMCREDITS_SHIFT)
#define MC_TIMEOUT_CTRL_0_TMCREDITS_RANGE                       6:6
#define MC_TIMEOUT_CTRL_0_TMCREDITS_WOFFSET                     0x0
#define MC_TIMEOUT_CTRL_0_TMCREDITS_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_CTRL_0_TMCREDITS_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_TIMEOUT_CTRL_0_TMCREDITS_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_CTRL_0_TMCREDITS_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_CTRL_0_TMCREDITS_INIT_ENUM                   FROM_CIF_FIFO
#define MC_TIMEOUT_CTRL_0_TMCREDITS_FROM_CIF_FIFO                       _MK_ENUM_CONST(0)
#define MC_TIMEOUT_CTRL_0_TMCREDITS_ONE                 _MK_ENUM_CONST(1)


// Reserved address 64 [0x40] 

// Reserved address 68 [0x44] 

// Reserved address 72 [0x48] 

// Reserved address 76 [0x4c] 

// Reserved address 80 [0x50] 

// Reserved address 84 [0x54] 

// Register MC_DECERR_EMEM_OTHERS_STATUS_0  
#define MC_DECERR_EMEM_OTHERS_STATUS_0                  _MK_ADDR_CONST(0x58)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_SECURE                   0x0
#define MC_DECERR_EMEM_OTHERS_STATUS_0_WORD_COUNT                       0x1
#define MC_DECERR_EMEM_OTHERS_STATUS_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_READ_MASK                        _MK_MASK_CONST(0x8000003f)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_ID_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_ID_FIELD                      (_MK_MASK_CONST(0x3f) << MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_ID_SHIFT)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_ID_RANGE                      5:0
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_ID_WOFFSET                    0x0
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_ID_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_ID_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_ID_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_ID_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_RW_SHIFT                      _MK_SHIFT_CONST(31)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_RW_FIELD                      (_MK_MASK_CONST(0x1) << MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_RW_SHIFT)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_RW_RANGE                      31:31
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_RW_WOFFSET                    0x0
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_RW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_RW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_RW_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_RW_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_RW_READ                       _MK_ENUM_CONST(0)
#define MC_DECERR_EMEM_OTHERS_STATUS_0_DECERR_EMEM_OTHERS_RW_WRITE                      _MK_ENUM_CONST(1)


// Register MC_DECERR_EMEM_OTHERS_ADR_0  
#define MC_DECERR_EMEM_OTHERS_ADR_0                     _MK_ADDR_CONST(0x5c)
#define MC_DECERR_EMEM_OTHERS_ADR_0_SECURE                      0x0
#define MC_DECERR_EMEM_OTHERS_ADR_0_WORD_COUNT                  0x1
#define MC_DECERR_EMEM_OTHERS_ADR_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_ADR_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_ADR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_ADR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_ADR_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define MC_DECERR_EMEM_OTHERS_ADR_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_ADR_0_DECERR_EMEM_OTHERS_ADR_SHIFT                        _MK_SHIFT_CONST(0)
#define MC_DECERR_EMEM_OTHERS_ADR_0_DECERR_EMEM_OTHERS_ADR_FIELD                        (_MK_MASK_CONST(0xffffffff) << MC_DECERR_EMEM_OTHERS_ADR_0_DECERR_EMEM_OTHERS_ADR_SHIFT)
#define MC_DECERR_EMEM_OTHERS_ADR_0_DECERR_EMEM_OTHERS_ADR_RANGE                        31:0
#define MC_DECERR_EMEM_OTHERS_ADR_0_DECERR_EMEM_OTHERS_ADR_WOFFSET                      0x0
#define MC_DECERR_EMEM_OTHERS_ADR_0_DECERR_EMEM_OTHERS_ADR_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_ADR_0_DECERR_EMEM_OTHERS_ADR_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_ADR_0_DECERR_EMEM_OTHERS_ADR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_DECERR_EMEM_OTHERS_ADR_0_DECERR_EMEM_OTHERS_ADR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Reserved address 96 [0x60] 

// Reserved address 100 [0x64] 

// Register MC_CLKEN_OVERRIDE_0  
#define MC_CLKEN_OVERRIDE_0                     _MK_ADDR_CONST(0x68)
#define MC_CLKEN_OVERRIDE_0_SECURE                      0x0
#define MC_CLKEN_OVERRIDE_0_WORD_COUNT                  0x1
#define MC_CLKEN_OVERRIDE_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define MC_CLKEN_OVERRIDE_0_RESET_MASK                  _MK_MASK_CONST(0x1d)
#define MC_CLKEN_OVERRIDE_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define MC_CLKEN_OVERRIDE_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLKEN_OVERRIDE_0_READ_MASK                   _MK_MASK_CONST(0x1d)
#define MC_CLKEN_OVERRIDE_0_WRITE_MASK                  _MK_MASK_CONST(0x1d)
#define MC_CLKEN_OVERRIDE_0_CIF_CLKEN_OVR_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_CLKEN_OVERRIDE_0_CIF_CLKEN_OVR_FIELD                 (_MK_MASK_CONST(0x1) << MC_CLKEN_OVERRIDE_0_CIF_CLKEN_OVR_SHIFT)
#define MC_CLKEN_OVERRIDE_0_CIF_CLKEN_OVR_RANGE                 0:0
#define MC_CLKEN_OVERRIDE_0_CIF_CLKEN_OVR_WOFFSET                       0x0
#define MC_CLKEN_OVERRIDE_0_CIF_CLKEN_OVR_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLKEN_OVERRIDE_0_CIF_CLKEN_OVR_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_CLKEN_OVERRIDE_0_CIF_CLKEN_OVR_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLKEN_OVERRIDE_0_CIF_CLKEN_OVR_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_CLKEN_OVERRIDE_0_CIF_CLKEN_OVR_INIT_ENUM                     CLK_GATED
#define MC_CLKEN_OVERRIDE_0_CIF_CLKEN_OVR_CLK_GATED                     _MK_ENUM_CONST(0)
#define MC_CLKEN_OVERRIDE_0_CIF_CLKEN_OVR_CLK_ALWAYS_ON                 _MK_ENUM_CONST(1)
#define MC_CLKEN_OVERRIDE_0_CIF_CLKEN_OVR_DISABLE                       _MK_ENUM_CONST(0)
#define MC_CLKEN_OVERRIDE_0_CIF_CLKEN_OVR_ENABLE                        _MK_ENUM_CONST(1)
#define MC_CLKEN_OVERRIDE_0_CIF_CLKEN_OVR_DISABLED                      _MK_ENUM_CONST(0)
#define MC_CLKEN_OVERRIDE_0_CIF_CLKEN_OVR_ENABLED                       _MK_ENUM_CONST(1)

#define MC_CLKEN_OVERRIDE_0_ESEQ_CLKEN_OVR_SHIFT                        _MK_SHIFT_CONST(2)
#define MC_CLKEN_OVERRIDE_0_ESEQ_CLKEN_OVR_FIELD                        (_MK_MASK_CONST(0x1) << MC_CLKEN_OVERRIDE_0_ESEQ_CLKEN_OVR_SHIFT)
#define MC_CLKEN_OVERRIDE_0_ESEQ_CLKEN_OVR_RANGE                        2:2
#define MC_CLKEN_OVERRIDE_0_ESEQ_CLKEN_OVR_WOFFSET                      0x0
#define MC_CLKEN_OVERRIDE_0_ESEQ_CLKEN_OVR_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_CLKEN_OVERRIDE_0_ESEQ_CLKEN_OVR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_CLKEN_OVERRIDE_0_ESEQ_CLKEN_OVR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLKEN_OVERRIDE_0_ESEQ_CLKEN_OVR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_CLKEN_OVERRIDE_0_ESEQ_CLKEN_OVR_INIT_ENUM                    CLK_GATED
#define MC_CLKEN_OVERRIDE_0_ESEQ_CLKEN_OVR_CLK_GATED                    _MK_ENUM_CONST(0)
#define MC_CLKEN_OVERRIDE_0_ESEQ_CLKEN_OVR_CLK_ALWAYS_ON                        _MK_ENUM_CONST(1)
#define MC_CLKEN_OVERRIDE_0_ESEQ_CLKEN_OVR_DISABLE                      _MK_ENUM_CONST(0)
#define MC_CLKEN_OVERRIDE_0_ESEQ_CLKEN_OVR_ENABLE                       _MK_ENUM_CONST(1)
#define MC_CLKEN_OVERRIDE_0_ESEQ_CLKEN_OVR_DISABLED                     _MK_ENUM_CONST(0)
#define MC_CLKEN_OVERRIDE_0_ESEQ_CLKEN_OVR_ENABLED                      _MK_ENUM_CONST(1)

#define MC_CLKEN_OVERRIDE_0_REGS_CLKEN_OVR_SHIFT                        _MK_SHIFT_CONST(3)
#define MC_CLKEN_OVERRIDE_0_REGS_CLKEN_OVR_FIELD                        (_MK_MASK_CONST(0x1) << MC_CLKEN_OVERRIDE_0_REGS_CLKEN_OVR_SHIFT)
#define MC_CLKEN_OVERRIDE_0_REGS_CLKEN_OVR_RANGE                        3:3
#define MC_CLKEN_OVERRIDE_0_REGS_CLKEN_OVR_WOFFSET                      0x0
#define MC_CLKEN_OVERRIDE_0_REGS_CLKEN_OVR_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_CLKEN_OVERRIDE_0_REGS_CLKEN_OVR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_CLKEN_OVERRIDE_0_REGS_CLKEN_OVR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLKEN_OVERRIDE_0_REGS_CLKEN_OVR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_CLKEN_OVERRIDE_0_REGS_CLKEN_OVR_INIT_ENUM                    CLK_GATED
#define MC_CLKEN_OVERRIDE_0_REGS_CLKEN_OVR_CLK_GATED                    _MK_ENUM_CONST(0)
#define MC_CLKEN_OVERRIDE_0_REGS_CLKEN_OVR_CLK_ALWAYS_ON                        _MK_ENUM_CONST(1)
#define MC_CLKEN_OVERRIDE_0_REGS_CLKEN_OVR_DISABLE                      _MK_ENUM_CONST(0)
#define MC_CLKEN_OVERRIDE_0_REGS_CLKEN_OVR_ENABLE                       _MK_ENUM_CONST(1)
#define MC_CLKEN_OVERRIDE_0_REGS_CLKEN_OVR_DISABLED                     _MK_ENUM_CONST(0)
#define MC_CLKEN_OVERRIDE_0_REGS_CLKEN_OVR_ENABLED                      _MK_ENUM_CONST(1)

#define MC_CLKEN_OVERRIDE_0_GART_CLKEN_OVR_SHIFT                        _MK_SHIFT_CONST(4)
#define MC_CLKEN_OVERRIDE_0_GART_CLKEN_OVR_FIELD                        (_MK_MASK_CONST(0x1) << MC_CLKEN_OVERRIDE_0_GART_CLKEN_OVR_SHIFT)
#define MC_CLKEN_OVERRIDE_0_GART_CLKEN_OVR_RANGE                        4:4
#define MC_CLKEN_OVERRIDE_0_GART_CLKEN_OVR_WOFFSET                      0x0
#define MC_CLKEN_OVERRIDE_0_GART_CLKEN_OVR_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_CLKEN_OVERRIDE_0_GART_CLKEN_OVR_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_CLKEN_OVERRIDE_0_GART_CLKEN_OVR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLKEN_OVERRIDE_0_GART_CLKEN_OVR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_CLKEN_OVERRIDE_0_GART_CLKEN_OVR_INIT_ENUM                    CLK_GATED
#define MC_CLKEN_OVERRIDE_0_GART_CLKEN_OVR_CLK_GATED                    _MK_ENUM_CONST(0)
#define MC_CLKEN_OVERRIDE_0_GART_CLKEN_OVR_CLK_ALWAYS_ON                        _MK_ENUM_CONST(1)
#define MC_CLKEN_OVERRIDE_0_GART_CLKEN_OVR_DISABLE                      _MK_ENUM_CONST(0)
#define MC_CLKEN_OVERRIDE_0_GART_CLKEN_OVR_ENABLE                       _MK_ENUM_CONST(1)
#define MC_CLKEN_OVERRIDE_0_GART_CLKEN_OVR_DISABLED                     _MK_ENUM_CONST(0)
#define MC_CLKEN_OVERRIDE_0_GART_CLKEN_OVR_ENABLED                      _MK_ENUM_CONST(1)


// Register MC_SECURITY_CFG0_0  
#define MC_SECURITY_CFG0_0                      _MK_ADDR_CONST(0x6c)
#define MC_SECURITY_CFG0_0_SECURE                       0x1
#define MC_SECURITY_CFG0_0_WORD_COUNT                   0x1
#define MC_SECURITY_CFG0_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define MC_SECURITY_CFG0_0_RESET_MASK                   _MK_MASK_CONST(0xfff00000)
#define MC_SECURITY_CFG0_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MC_SECURITY_CFG0_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_SECURITY_CFG0_0_READ_MASK                    _MK_MASK_CONST(0xfff00000)
#define MC_SECURITY_CFG0_0_WRITE_MASK                   _MK_MASK_CONST(0xfff00000)
#define MC_SECURITY_CFG0_0_SECURITY_BOM_SHIFT                   _MK_SHIFT_CONST(20)
#define MC_SECURITY_CFG0_0_SECURITY_BOM_FIELD                   (_MK_MASK_CONST(0xfff) << MC_SECURITY_CFG0_0_SECURITY_BOM_SHIFT)
#define MC_SECURITY_CFG0_0_SECURITY_BOM_RANGE                   31:20
#define MC_SECURITY_CFG0_0_SECURITY_BOM_WOFFSET                 0x0
#define MC_SECURITY_CFG0_0_SECURITY_BOM_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_SECURITY_CFG0_0_SECURITY_BOM_DEFAULT_MASK                    _MK_MASK_CONST(0xfff)
#define MC_SECURITY_CFG0_0_SECURITY_BOM_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_SECURITY_CFG0_0_SECURITY_BOM_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register MC_SECURITY_CFG1_0  
#define MC_SECURITY_CFG1_0                      _MK_ADDR_CONST(0x70)
#define MC_SECURITY_CFG1_0_SECURE                       0x1
#define MC_SECURITY_CFG1_0_WORD_COUNT                   0x1
#define MC_SECURITY_CFG1_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define MC_SECURITY_CFG1_0_RESET_MASK                   _MK_MASK_CONST(0xfff)
#define MC_SECURITY_CFG1_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MC_SECURITY_CFG1_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_SECURITY_CFG1_0_READ_MASK                    _MK_MASK_CONST(0xfff)
#define MC_SECURITY_CFG1_0_WRITE_MASK                   _MK_MASK_CONST(0xfff)
#define MC_SECURITY_CFG1_0_SECURITY_SIZE_MB_SHIFT                       _MK_SHIFT_CONST(0)
#define MC_SECURITY_CFG1_0_SECURITY_SIZE_MB_FIELD                       (_MK_MASK_CONST(0xfff) << MC_SECURITY_CFG1_0_SECURITY_SIZE_MB_SHIFT)
#define MC_SECURITY_CFG1_0_SECURITY_SIZE_MB_RANGE                       11:0
#define MC_SECURITY_CFG1_0_SECURITY_SIZE_MB_WOFFSET                     0x0
#define MC_SECURITY_CFG1_0_SECURITY_SIZE_MB_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_SECURITY_CFG1_0_SECURITY_SIZE_MB_DEFAULT_MASK                        _MK_MASK_CONST(0xfff)
#define MC_SECURITY_CFG1_0_SECURITY_SIZE_MB_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_SECURITY_CFG1_0_SECURITY_SIZE_MB_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register MC_SECURITY_VIOLATION_STATUS_0  
#define MC_SECURITY_VIOLATION_STATUS_0                  _MK_ADDR_CONST(0x74)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURE                   0x0
#define MC_SECURITY_VIOLATION_STATUS_0_WORD_COUNT                       0x1
#define MC_SECURITY_VIOLATION_STATUS_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_STATUS_0_RESET_MASK                       _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_STATUS_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_STATUS_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_STATUS_0_READ_MASK                        _MK_MASK_CONST(0xc000003f)
#define MC_SECURITY_VIOLATION_STATUS_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_ID_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_ID_FIELD                      (_MK_MASK_CONST(0x3f) << MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_ID_SHIFT)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_ID_RANGE                      5:0
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_ID_WOFFSET                    0x0
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_ID_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_ID_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_ID_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_ID_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_TYPE_SHIFT                    _MK_SHIFT_CONST(30)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_TYPE_FIELD                    (_MK_MASK_CONST(0x1) << MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_TYPE_SHIFT)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_TYPE_RANGE                    30:30
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_TYPE_WOFFSET                  0x0
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_TYPE_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_TYPE_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_TYPE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_TYPE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_TYPE_TRUSTZONE                        _MK_ENUM_CONST(0)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_TYPE_CARVEOUT                 _MK_ENUM_CONST(1)

#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_RW_SHIFT                      _MK_SHIFT_CONST(31)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_RW_FIELD                      (_MK_MASK_CONST(0x1) << MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_RW_SHIFT)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_RW_RANGE                      31:31
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_RW_WOFFSET                    0x0
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_RW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_RW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_RW_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_RW_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_RW_READ                       _MK_ENUM_CONST(0)
#define MC_SECURITY_VIOLATION_STATUS_0_SECURITY_VIOLATION_RW_WRITE                      _MK_ENUM_CONST(1)


// Register MC_SECURITY_VIOLATION_ADR_0  
#define MC_SECURITY_VIOLATION_ADR_0                     _MK_ADDR_CONST(0x78)
#define MC_SECURITY_VIOLATION_ADR_0_SECURE                      0x0
#define MC_SECURITY_VIOLATION_ADR_0_WORD_COUNT                  0x1
#define MC_SECURITY_VIOLATION_ADR_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_ADR_0_RESET_MASK                  _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_ADR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_ADR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_ADR_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define MC_SECURITY_VIOLATION_ADR_0_WRITE_MASK                  _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_ADR_0_SECURITY_VIOLATION_ADR_SHIFT                        _MK_SHIFT_CONST(0)
#define MC_SECURITY_VIOLATION_ADR_0_SECURITY_VIOLATION_ADR_FIELD                        (_MK_MASK_CONST(0xffffffff) << MC_SECURITY_VIOLATION_ADR_0_SECURITY_VIOLATION_ADR_SHIFT)
#define MC_SECURITY_VIOLATION_ADR_0_SECURITY_VIOLATION_ADR_RANGE                        31:0
#define MC_SECURITY_VIOLATION_ADR_0_SECURITY_VIOLATION_ADR_WOFFSET                      0x0
#define MC_SECURITY_VIOLATION_ADR_0_SECURITY_VIOLATION_ADR_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_ADR_0_SECURITY_VIOLATION_ADR_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_ADR_0_SECURITY_VIOLATION_ADR_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_SECURITY_VIOLATION_ADR_0_SECURITY_VIOLATION_ADR_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register MC_SECURITY_CFG2_0  
#define MC_SECURITY_CFG2_0                      _MK_ADDR_CONST(0x7c)
#define MC_SECURITY_CFG2_0_SECURE                       0x1
#define MC_SECURITY_CFG2_0_WORD_COUNT                   0x1
#define MC_SECURITY_CFG2_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define MC_SECURITY_CFG2_0_RESET_MASK                   _MK_MASK_CONST(0xfff00000)
#define MC_SECURITY_CFG2_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MC_SECURITY_CFG2_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_SECURITY_CFG2_0_READ_MASK                    _MK_MASK_CONST(0xfff00000)
#define MC_SECURITY_CFG2_0_WRITE_MASK                   _MK_MASK_CONST(0xfff00000)
#define MC_SECURITY_CFG2_0_CARVEOUT_BOM_SHIFT                   _MK_SHIFT_CONST(20)
#define MC_SECURITY_CFG2_0_CARVEOUT_BOM_FIELD                   (_MK_MASK_CONST(0xfff) << MC_SECURITY_CFG2_0_CARVEOUT_BOM_SHIFT)
#define MC_SECURITY_CFG2_0_CARVEOUT_BOM_RANGE                   31:20
#define MC_SECURITY_CFG2_0_CARVEOUT_BOM_WOFFSET                 0x0
#define MC_SECURITY_CFG2_0_CARVEOUT_BOM_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_SECURITY_CFG2_0_CARVEOUT_BOM_DEFAULT_MASK                    _MK_MASK_CONST(0xfff)
#define MC_SECURITY_CFG2_0_CARVEOUT_BOM_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_SECURITY_CFG2_0_CARVEOUT_BOM_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Reserved address 128 [0x80] 

// Reserved address 132 [0x84] 

// Reserved address 136 [0x88] 

// Reserved address 140 [0x8c] 

// Register MC_STAT_CONTROL_0  
#define MC_STAT_CONTROL_0                       _MK_ADDR_CONST(0x90)
#define MC_STAT_CONTROL_0_SECURE                        0x0
#define MC_STAT_CONTROL_0_WORD_COUNT                    0x1
#define MC_STAT_CONTROL_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define MC_STAT_CONTROL_0_RESET_MASK                    _MK_MASK_CONST(0x300)
#define MC_STAT_CONTROL_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_STAT_CONTROL_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_STAT_CONTROL_0_READ_MASK                     _MK_MASK_CONST(0x300)
#define MC_STAT_CONTROL_0_WRITE_MASK                    _MK_MASK_CONST(0x300)
#define MC_STAT_CONTROL_0_EMC_GATHER_SHIFT                      _MK_SHIFT_CONST(8)
#define MC_STAT_CONTROL_0_EMC_GATHER_FIELD                      (_MK_MASK_CONST(0x3) << MC_STAT_CONTROL_0_EMC_GATHER_SHIFT)
#define MC_STAT_CONTROL_0_EMC_GATHER_RANGE                      9:8
#define MC_STAT_CONTROL_0_EMC_GATHER_WOFFSET                    0x0
#define MC_STAT_CONTROL_0_EMC_GATHER_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_STAT_CONTROL_0_EMC_GATHER_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define MC_STAT_CONTROL_0_EMC_GATHER_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_STAT_CONTROL_0_EMC_GATHER_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_STAT_CONTROL_0_EMC_GATHER_INIT_ENUM                  RST
#define MC_STAT_CONTROL_0_EMC_GATHER_RST                        _MK_ENUM_CONST(0)
#define MC_STAT_CONTROL_0_EMC_GATHER_CLEAR                      _MK_ENUM_CONST(1)
#define MC_STAT_CONTROL_0_EMC_GATHER_DISABLE                    _MK_ENUM_CONST(2)
#define MC_STAT_CONTROL_0_EMC_GATHER_ENABLE                     _MK_ENUM_CONST(3)


// Register MC_STAT_STATUS_0  
#define MC_STAT_STATUS_0                        _MK_ADDR_CONST(0x94)
#define MC_STAT_STATUS_0_SECURE                         0x0
#define MC_STAT_STATUS_0_WORD_COUNT                     0x1
#define MC_STAT_STATUS_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define MC_STAT_STATUS_0_RESET_MASK                     _MK_MASK_CONST(0x0)
#define MC_STAT_STATUS_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define MC_STAT_STATUS_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_STAT_STATUS_0_READ_MASK                      _MK_MASK_CONST(0x100)
#define MC_STAT_STATUS_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define MC_STAT_STATUS_0_EMC_LIMIT_SHIFT                        _MK_SHIFT_CONST(8)
#define MC_STAT_STATUS_0_EMC_LIMIT_FIELD                        (_MK_MASK_CONST(0x1) << MC_STAT_STATUS_0_EMC_LIMIT_SHIFT)
#define MC_STAT_STATUS_0_EMC_LIMIT_RANGE                        8:8
#define MC_STAT_STATUS_0_EMC_LIMIT_WOFFSET                      0x0
#define MC_STAT_STATUS_0_EMC_LIMIT_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_STAT_STATUS_0_EMC_LIMIT_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_STAT_STATUS_0_EMC_LIMIT_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_STAT_STATUS_0_EMC_LIMIT_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register MC_STAT_EMC_ADDR_LOW_0  
#define MC_STAT_EMC_ADDR_LOW_0                  _MK_ADDR_CONST(0x98)
#define MC_STAT_EMC_ADDR_LOW_0_SECURE                   0x0
#define MC_STAT_EMC_ADDR_LOW_0_WORD_COUNT                       0x1
#define MC_STAT_EMC_ADDR_LOW_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_ADDR_LOW_0_RESET_MASK                       _MK_MASK_CONST(0x3ffffff0)
#define MC_STAT_EMC_ADDR_LOW_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_ADDR_LOW_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_ADDR_LOW_0_READ_MASK                        _MK_MASK_CONST(0x3ffffff0)
#define MC_STAT_EMC_ADDR_LOW_0_WRITE_MASK                       _MK_MASK_CONST(0x3ffffff0)
#define MC_STAT_EMC_ADDR_LOW_0_EMC_ADDR_LOW_SHIFT                       _MK_SHIFT_CONST(4)
#define MC_STAT_EMC_ADDR_LOW_0_EMC_ADDR_LOW_FIELD                       (_MK_MASK_CONST(0x3ffffff) << MC_STAT_EMC_ADDR_LOW_0_EMC_ADDR_LOW_SHIFT)
#define MC_STAT_EMC_ADDR_LOW_0_EMC_ADDR_LOW_RANGE                       29:4
#define MC_STAT_EMC_ADDR_LOW_0_EMC_ADDR_LOW_WOFFSET                     0x0
#define MC_STAT_EMC_ADDR_LOW_0_EMC_ADDR_LOW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_ADDR_LOW_0_EMC_ADDR_LOW_DEFAULT_MASK                        _MK_MASK_CONST(0x3ffffff)
#define MC_STAT_EMC_ADDR_LOW_0_EMC_ADDR_LOW_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_ADDR_LOW_0_EMC_ADDR_LOW_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register MC_STAT_EMC_ADDR_HIGH_0  
#define MC_STAT_EMC_ADDR_HIGH_0                 _MK_ADDR_CONST(0x9c)
#define MC_STAT_EMC_ADDR_HIGH_0_SECURE                  0x0
#define MC_STAT_EMC_ADDR_HIGH_0_WORD_COUNT                      0x1
#define MC_STAT_EMC_ADDR_HIGH_0_RESET_VAL                       _MK_MASK_CONST(0x3ffffff0)
#define MC_STAT_EMC_ADDR_HIGH_0_RESET_MASK                      _MK_MASK_CONST(0x3ffffff0)
#define MC_STAT_EMC_ADDR_HIGH_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_ADDR_HIGH_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_ADDR_HIGH_0_READ_MASK                       _MK_MASK_CONST(0x3ffffff0)
#define MC_STAT_EMC_ADDR_HIGH_0_WRITE_MASK                      _MK_MASK_CONST(0x3ffffff0)
#define MC_STAT_EMC_ADDR_HIGH_0_EMC_ADDR_HIGH_SHIFT                     _MK_SHIFT_CONST(4)
#define MC_STAT_EMC_ADDR_HIGH_0_EMC_ADDR_HIGH_FIELD                     (_MK_MASK_CONST(0x3ffffff) << MC_STAT_EMC_ADDR_HIGH_0_EMC_ADDR_HIGH_SHIFT)
#define MC_STAT_EMC_ADDR_HIGH_0_EMC_ADDR_HIGH_RANGE                     29:4
#define MC_STAT_EMC_ADDR_HIGH_0_EMC_ADDR_HIGH_WOFFSET                   0x0
#define MC_STAT_EMC_ADDR_HIGH_0_EMC_ADDR_HIGH_DEFAULT                   _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_ADDR_HIGH_0_EMC_ADDR_HIGH_DEFAULT_MASK                      _MK_MASK_CONST(0x3ffffff)
#define MC_STAT_EMC_ADDR_HIGH_0_EMC_ADDR_HIGH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_ADDR_HIGH_0_EMC_ADDR_HIGH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_ADDR_HIGH_0_EMC_ADDR_HIGH_INIT_ENUM                 -1


// Register MC_STAT_EMC_CLOCK_LIMIT_0  
#define MC_STAT_EMC_CLOCK_LIMIT_0                       _MK_ADDR_CONST(0xa0)
#define MC_STAT_EMC_CLOCK_LIMIT_0_SECURE                        0x0
#define MC_STAT_EMC_CLOCK_LIMIT_0_WORD_COUNT                    0x1
#define MC_STAT_EMC_CLOCK_LIMIT_0_RESET_VAL                     _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_CLOCK_LIMIT_0_RESET_MASK                    _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_CLOCK_LIMIT_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CLOCK_LIMIT_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CLOCK_LIMIT_0_READ_MASK                     _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_CLOCK_LIMIT_0_WRITE_MASK                    _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_CLOCK_LIMIT_0_EMC_CLOCK_LIMIT_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_STAT_EMC_CLOCK_LIMIT_0_EMC_CLOCK_LIMIT_FIELD                 (_MK_MASK_CONST(0xffffffff) << MC_STAT_EMC_CLOCK_LIMIT_0_EMC_CLOCK_LIMIT_SHIFT)
#define MC_STAT_EMC_CLOCK_LIMIT_0_EMC_CLOCK_LIMIT_RANGE                 31:0
#define MC_STAT_EMC_CLOCK_LIMIT_0_EMC_CLOCK_LIMIT_WOFFSET                       0x0
#define MC_STAT_EMC_CLOCK_LIMIT_0_EMC_CLOCK_LIMIT_DEFAULT                       _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_CLOCK_LIMIT_0_EMC_CLOCK_LIMIT_DEFAULT_MASK                  _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_CLOCK_LIMIT_0_EMC_CLOCK_LIMIT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CLOCK_LIMIT_0_EMC_CLOCK_LIMIT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CLOCK_LIMIT_0_EMC_CLOCK_LIMIT_INIT_ENUM                     -1


// Register MC_STAT_EMC_CLOCKS_0  
#define MC_STAT_EMC_CLOCKS_0                    _MK_ADDR_CONST(0xa4)
#define MC_STAT_EMC_CLOCKS_0_SECURE                     0x0
#define MC_STAT_EMC_CLOCKS_0_WORD_COUNT                         0x1
#define MC_STAT_EMC_CLOCKS_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CLOCKS_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CLOCKS_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CLOCKS_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CLOCKS_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_CLOCKS_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CLOCKS_0_EMC_CLOCKS_SHIFT                   _MK_SHIFT_CONST(0)
#define MC_STAT_EMC_CLOCKS_0_EMC_CLOCKS_FIELD                   (_MK_MASK_CONST(0xffffffff) << MC_STAT_EMC_CLOCKS_0_EMC_CLOCKS_SHIFT)
#define MC_STAT_EMC_CLOCKS_0_EMC_CLOCKS_RANGE                   31:0
#define MC_STAT_EMC_CLOCKS_0_EMC_CLOCKS_WOFFSET                 0x0
#define MC_STAT_EMC_CLOCKS_0_EMC_CLOCKS_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CLOCKS_0_EMC_CLOCKS_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CLOCKS_0_EMC_CLOCKS_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CLOCKS_0_EMC_CLOCKS_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Packet ARMC_STAT_CONTROL
#define ARMC_STAT_CONTROL_SIZE 32

#define ARMC_STAT_CONTROL_MODE_SHIFT                    _MK_SHIFT_CONST(0)
#define ARMC_STAT_CONTROL_MODE_FIELD                    (_MK_MASK_CONST(0x3) << ARMC_STAT_CONTROL_MODE_SHIFT)
#define ARMC_STAT_CONTROL_MODE_RANGE                    _MK_SHIFT_CONST(1):_MK_SHIFT_CONST(0)
#define ARMC_STAT_CONTROL_MODE_ROW                      0
#define ARMC_STAT_CONTROL_MODE_BANDWIDTH                        _MK_ENUM_CONST(0)
#define ARMC_STAT_CONTROL_MODE_LATENCY_AVG                      _MK_ENUM_CONST(1)
#define ARMC_STAT_CONTROL_MODE_LATENCY_HISTO                    _MK_ENUM_CONST(2)

#define ARMC_STAT_CONTROL_SKIP_SHIFT                    _MK_SHIFT_CONST(4)
#define ARMC_STAT_CONTROL_SKIP_FIELD                    (_MK_MASK_CONST(0x7) << ARMC_STAT_CONTROL_SKIP_SHIFT)
#define ARMC_STAT_CONTROL_SKIP_RANGE                    _MK_SHIFT_CONST(6):_MK_SHIFT_CONST(4)
#define ARMC_STAT_CONTROL_SKIP_ROW                      0

#define ARMC_STAT_CONTROL_CLIENT_ID_SHIFT                       _MK_SHIFT_CONST(8)
#define ARMC_STAT_CONTROL_CLIENT_ID_FIELD                       (_MK_MASK_CONST(0x3f) << ARMC_STAT_CONTROL_CLIENT_ID_SHIFT)
#define ARMC_STAT_CONTROL_CLIENT_ID_RANGE                       _MK_SHIFT_CONST(13):_MK_SHIFT_CONST(8)
#define ARMC_STAT_CONTROL_CLIENT_ID_ROW                 0

#define ARMC_STAT_CONTROL_EVENT_SHIFT                   _MK_SHIFT_CONST(16)
#define ARMC_STAT_CONTROL_EVENT_FIELD                   (_MK_MASK_CONST(0xff) << ARMC_STAT_CONTROL_EVENT_SHIFT)
#define ARMC_STAT_CONTROL_EVENT_RANGE                   _MK_SHIFT_CONST(23):_MK_SHIFT_CONST(16)
#define ARMC_STAT_CONTROL_EVENT_ROW                     0
#define ARMC_STAT_CONTROL_EVENT_QUALIFIED                       _MK_ENUM_CONST(0)
#define ARMC_STAT_CONTROL_EVENT_ANY_READ                        _MK_ENUM_CONST(1)
#define ARMC_STAT_CONTROL_EVENT_ANY_WRITE                       _MK_ENUM_CONST(2)
#define ARMC_STAT_CONTROL_EVENT_RD_WR_CHANGE                    _MK_ENUM_CONST(3)
#define ARMC_STAT_CONTROL_EVENT_SUCCESSIVE                      _MK_ENUM_CONST(4)
#define ARMC_STAT_CONTROL_EVENT_ARB_BANK_AA                     _MK_ENUM_CONST(5)
#define ARMC_STAT_CONTROL_EVENT_ARB_BANK_BB                     _MK_ENUM_CONST(6)
#define ARMC_STAT_CONTROL_EVENT_PAGE_MISS                       _MK_ENUM_CONST(7)
#define ARMC_STAT_CONTROL_EVENT_AUTO_PRECHARGE                  _MK_ENUM_CONST(8)

#define ARMC_STAT_CONTROL_PRI_EVENT_SHIFT                       _MK_SHIFT_CONST(24)
#define ARMC_STAT_CONTROL_PRI_EVENT_FIELD                       (_MK_MASK_CONST(0x3) << ARMC_STAT_CONTROL_PRI_EVENT_SHIFT)
#define ARMC_STAT_CONTROL_PRI_EVENT_RANGE                       _MK_SHIFT_CONST(25):_MK_SHIFT_CONST(24)
#define ARMC_STAT_CONTROL_PRI_EVENT_ROW                 0
#define ARMC_STAT_CONTROL_PRI_EVENT_HP                  _MK_ENUM_CONST(0)
#define ARMC_STAT_CONTROL_PRI_EVENT_TM                  _MK_ENUM_CONST(1)
#define ARMC_STAT_CONTROL_PRI_EVENT_BW                  _MK_ENUM_CONST(2)

#define ARMC_STAT_CONTROL_FILTER_CLIENT_SHIFT                   _MK_SHIFT_CONST(26)
#define ARMC_STAT_CONTROL_FILTER_CLIENT_FIELD                   (_MK_MASK_CONST(0x1) << ARMC_STAT_CONTROL_FILTER_CLIENT_SHIFT)
#define ARMC_STAT_CONTROL_FILTER_CLIENT_RANGE                   _MK_SHIFT_CONST(26):_MK_SHIFT_CONST(26)
#define ARMC_STAT_CONTROL_FILTER_CLIENT_ROW                     0
#define ARMC_STAT_CONTROL_FILTER_CLIENT_DISABLE                 _MK_ENUM_CONST(0)
#define ARMC_STAT_CONTROL_FILTER_CLIENT_ENABLE                  _MK_ENUM_CONST(1)

#define ARMC_STAT_CONTROL_FILTER_ADDR_SHIFT                     _MK_SHIFT_CONST(27)
#define ARMC_STAT_CONTROL_FILTER_ADDR_FIELD                     (_MK_MASK_CONST(0x1) << ARMC_STAT_CONTROL_FILTER_ADDR_SHIFT)
#define ARMC_STAT_CONTROL_FILTER_ADDR_RANGE                     _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(27)
#define ARMC_STAT_CONTROL_FILTER_ADDR_ROW                       0
#define ARMC_STAT_CONTROL_FILTER_ADDR_DISABLE                   _MK_ENUM_CONST(0)
#define ARMC_STAT_CONTROL_FILTER_ADDR_ENABLE                    _MK_ENUM_CONST(1)

#define ARMC_STAT_CONTROL_FILTER_PRI_SHIFT                      _MK_SHIFT_CONST(28)
#define ARMC_STAT_CONTROL_FILTER_PRI_FIELD                      (_MK_MASK_CONST(0x3) << ARMC_STAT_CONTROL_FILTER_PRI_SHIFT)
#define ARMC_STAT_CONTROL_FILTER_PRI_RANGE                      _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(28)
#define ARMC_STAT_CONTROL_FILTER_PRI_ROW                        0
#define ARMC_STAT_CONTROL_FILTER_PRI_DISABLE                    _MK_ENUM_CONST(0)
#define ARMC_STAT_CONTROL_FILTER_PRI_NO                 _MK_ENUM_CONST(1)
#define ARMC_STAT_CONTROL_FILTER_PRI_YES                        _MK_ENUM_CONST(2)

#define ARMC_STAT_CONTROL_FILTER_COALESCED_SHIFT                        _MK_SHIFT_CONST(30)
#define ARMC_STAT_CONTROL_FILTER_COALESCED_FIELD                        (_MK_MASK_CONST(0x3) << ARMC_STAT_CONTROL_FILTER_COALESCED_SHIFT)
#define ARMC_STAT_CONTROL_FILTER_COALESCED_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(30)
#define ARMC_STAT_CONTROL_FILTER_COALESCED_ROW                  0
#define ARMC_STAT_CONTROL_FILTER_COALESCED_DISABLE                      _MK_ENUM_CONST(0)
#define ARMC_STAT_CONTROL_FILTER_COALESCED_NO                   _MK_ENUM_CONST(1)
#define ARMC_STAT_CONTROL_FILTER_COALESCED_YES                  _MK_ENUM_CONST(2)


// Register MC_STAT_EMC_CONTROL_0_0  
#define MC_STAT_EMC_CONTROL_0_0                 _MK_ADDR_CONST(0xa8)
#define MC_STAT_EMC_CONTROL_0_0_SECURE                  0x0
#define MC_STAT_EMC_CONTROL_0_0_WORD_COUNT                      0x1
#define MC_STAT_EMC_CONTROL_0_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CONTROL_0_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_CONTROL_0_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CONTROL_0_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CONTROL_0_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_CONTROL_0_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_CONTROL_0_0_EMC_CONTROL_0_SHIFT                     _MK_SHIFT_CONST(0)
#define MC_STAT_EMC_CONTROL_0_0_EMC_CONTROL_0_FIELD                     (_MK_MASK_CONST(0xffffffff) << MC_STAT_EMC_CONTROL_0_0_EMC_CONTROL_0_SHIFT)
#define MC_STAT_EMC_CONTROL_0_0_EMC_CONTROL_0_RANGE                     31:0
#define MC_STAT_EMC_CONTROL_0_0_EMC_CONTROL_0_WOFFSET                   0x0
#define MC_STAT_EMC_CONTROL_0_0_EMC_CONTROL_0_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CONTROL_0_0_EMC_CONTROL_0_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_CONTROL_0_0_EMC_CONTROL_0_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CONTROL_0_0_EMC_CONTROL_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register MC_STAT_EMC_CONTROL_1_0  
#define MC_STAT_EMC_CONTROL_1_0                 _MK_ADDR_CONST(0xac)
#define MC_STAT_EMC_CONTROL_1_0_SECURE                  0x0
#define MC_STAT_EMC_CONTROL_1_0_WORD_COUNT                      0x1
#define MC_STAT_EMC_CONTROL_1_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CONTROL_1_0_RESET_MASK                      _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_CONTROL_1_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CONTROL_1_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CONTROL_1_0_READ_MASK                       _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_CONTROL_1_0_WRITE_MASK                      _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_CONTROL_1_0_EMC_CONTROL_1_SHIFT                     _MK_SHIFT_CONST(0)
#define MC_STAT_EMC_CONTROL_1_0_EMC_CONTROL_1_FIELD                     (_MK_MASK_CONST(0xffffffff) << MC_STAT_EMC_CONTROL_1_0_EMC_CONTROL_1_SHIFT)
#define MC_STAT_EMC_CONTROL_1_0_EMC_CONTROL_1_RANGE                     31:0
#define MC_STAT_EMC_CONTROL_1_0_EMC_CONTROL_1_WOFFSET                   0x0
#define MC_STAT_EMC_CONTROL_1_0_EMC_CONTROL_1_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CONTROL_1_0_EMC_CONTROL_1_DEFAULT_MASK                      _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_CONTROL_1_0_EMC_CONTROL_1_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_CONTROL_1_0_EMC_CONTROL_1_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Packet ARMC_STAT_HIST_LIMIT
#define ARMC_STAT_HIST_LIMIT_SIZE 32

#define ARMC_STAT_HIST_LIMIT_LOW_SHIFT                  _MK_SHIFT_CONST(0)
#define ARMC_STAT_HIST_LIMIT_LOW_FIELD                  (_MK_MASK_CONST(0xffff) << ARMC_STAT_HIST_LIMIT_LOW_SHIFT)
#define ARMC_STAT_HIST_LIMIT_LOW_RANGE                  _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define ARMC_STAT_HIST_LIMIT_LOW_ROW                    0

#define ARMC_STAT_HIST_LIMIT_HIGH_SHIFT                 _MK_SHIFT_CONST(16)
#define ARMC_STAT_HIST_LIMIT_HIGH_FIELD                 (_MK_MASK_CONST(0xffff) << ARMC_STAT_HIST_LIMIT_HIGH_SHIFT)
#define ARMC_STAT_HIST_LIMIT_HIGH_RANGE                 _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(16)
#define ARMC_STAT_HIST_LIMIT_HIGH_ROW                   0


// Register MC_STAT_EMC_HIST_LIMIT_0_0  
#define MC_STAT_EMC_HIST_LIMIT_0_0                      _MK_ADDR_CONST(0xb0)
#define MC_STAT_EMC_HIST_LIMIT_0_0_SECURE                       0x0
#define MC_STAT_EMC_HIST_LIMIT_0_0_WORD_COUNT                   0x1
#define MC_STAT_EMC_HIST_LIMIT_0_0_RESET_VAL                    _MK_MASK_CONST(0xffff0000)
#define MC_STAT_EMC_HIST_LIMIT_0_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_HIST_LIMIT_0_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_LIMIT_0_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_LIMIT_0_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_HIST_LIMIT_0_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_HIST_LIMIT_0_0_EMC_HIST_LIMIT_0_SHIFT                       _MK_SHIFT_CONST(0)
#define MC_STAT_EMC_HIST_LIMIT_0_0_EMC_HIST_LIMIT_0_FIELD                       (_MK_MASK_CONST(0xffffffff) << MC_STAT_EMC_HIST_LIMIT_0_0_EMC_HIST_LIMIT_0_SHIFT)
#define MC_STAT_EMC_HIST_LIMIT_0_0_EMC_HIST_LIMIT_0_RANGE                       31:0
#define MC_STAT_EMC_HIST_LIMIT_0_0_EMC_HIST_LIMIT_0_WOFFSET                     0x0
#define MC_STAT_EMC_HIST_LIMIT_0_0_EMC_HIST_LIMIT_0_DEFAULT                     _MK_MASK_CONST(0xffff0000)
#define MC_STAT_EMC_HIST_LIMIT_0_0_EMC_HIST_LIMIT_0_DEFAULT_MASK                        _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_HIST_LIMIT_0_0_EMC_HIST_LIMIT_0_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_LIMIT_0_0_EMC_HIST_LIMIT_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_LIMIT_0_0_EMC_HIST_LIMIT_0_INIT_ENUM                   -65536


// Register MC_STAT_EMC_HIST_LIMIT_1_0  
#define MC_STAT_EMC_HIST_LIMIT_1_0                      _MK_ADDR_CONST(0xb4)
#define MC_STAT_EMC_HIST_LIMIT_1_0_SECURE                       0x0
#define MC_STAT_EMC_HIST_LIMIT_1_0_WORD_COUNT                   0x1
#define MC_STAT_EMC_HIST_LIMIT_1_0_RESET_VAL                    _MK_MASK_CONST(0xffff0000)
#define MC_STAT_EMC_HIST_LIMIT_1_0_RESET_MASK                   _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_HIST_LIMIT_1_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_LIMIT_1_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_LIMIT_1_0_READ_MASK                    _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_HIST_LIMIT_1_0_WRITE_MASK                   _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_HIST_LIMIT_1_0_EMC_HIST_LIMIT_1_SHIFT                       _MK_SHIFT_CONST(0)
#define MC_STAT_EMC_HIST_LIMIT_1_0_EMC_HIST_LIMIT_1_FIELD                       (_MK_MASK_CONST(0xffffffff) << MC_STAT_EMC_HIST_LIMIT_1_0_EMC_HIST_LIMIT_1_SHIFT)
#define MC_STAT_EMC_HIST_LIMIT_1_0_EMC_HIST_LIMIT_1_RANGE                       31:0
#define MC_STAT_EMC_HIST_LIMIT_1_0_EMC_HIST_LIMIT_1_WOFFSET                     0x0
#define MC_STAT_EMC_HIST_LIMIT_1_0_EMC_HIST_LIMIT_1_DEFAULT                     _MK_MASK_CONST(0xffff0000)
#define MC_STAT_EMC_HIST_LIMIT_1_0_EMC_HIST_LIMIT_1_DEFAULT_MASK                        _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_HIST_LIMIT_1_0_EMC_HIST_LIMIT_1_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_LIMIT_1_0_EMC_HIST_LIMIT_1_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_LIMIT_1_0_EMC_HIST_LIMIT_1_INIT_ENUM                   -65536


// Register MC_STAT_EMC_COUNT_0_0  
#define MC_STAT_EMC_COUNT_0_0                   _MK_ADDR_CONST(0xb8)
#define MC_STAT_EMC_COUNT_0_0_SECURE                    0x0
#define MC_STAT_EMC_COUNT_0_0_WORD_COUNT                        0x1
#define MC_STAT_EMC_COUNT_0_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_COUNT_0_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_COUNT_0_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_COUNT_0_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_COUNT_0_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_COUNT_0_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_COUNT_0_0_EMC_COUNT_0_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_STAT_EMC_COUNT_0_0_EMC_COUNT_0_FIELD                 (_MK_MASK_CONST(0xffffffff) << MC_STAT_EMC_COUNT_0_0_EMC_COUNT_0_SHIFT)
#define MC_STAT_EMC_COUNT_0_0_EMC_COUNT_0_RANGE                 31:0
#define MC_STAT_EMC_COUNT_0_0_EMC_COUNT_0_WOFFSET                       0x0
#define MC_STAT_EMC_COUNT_0_0_EMC_COUNT_0_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_COUNT_0_0_EMC_COUNT_0_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_COUNT_0_0_EMC_COUNT_0_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_COUNT_0_0_EMC_COUNT_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register MC_STAT_EMC_COUNT_1_0  
#define MC_STAT_EMC_COUNT_1_0                   _MK_ADDR_CONST(0xbc)
#define MC_STAT_EMC_COUNT_1_0_SECURE                    0x0
#define MC_STAT_EMC_COUNT_1_0_WORD_COUNT                        0x1
#define MC_STAT_EMC_COUNT_1_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_COUNT_1_0_RESET_MASK                        _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_COUNT_1_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_COUNT_1_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_COUNT_1_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_COUNT_1_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_COUNT_1_0_EMC_COUNT_1_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_STAT_EMC_COUNT_1_0_EMC_COUNT_1_FIELD                 (_MK_MASK_CONST(0xffffffff) << MC_STAT_EMC_COUNT_1_0_EMC_COUNT_1_SHIFT)
#define MC_STAT_EMC_COUNT_1_0_EMC_COUNT_1_RANGE                 31:0
#define MC_STAT_EMC_COUNT_1_0_EMC_COUNT_1_WOFFSET                       0x0
#define MC_STAT_EMC_COUNT_1_0_EMC_COUNT_1_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_COUNT_1_0_EMC_COUNT_1_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_COUNT_1_0_EMC_COUNT_1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_COUNT_1_0_EMC_COUNT_1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register MC_STAT_EMC_HIST_0_0  
#define MC_STAT_EMC_HIST_0_0                    _MK_ADDR_CONST(0xc0)
#define MC_STAT_EMC_HIST_0_0_SECURE                     0x0
#define MC_STAT_EMC_HIST_0_0_WORD_COUNT                         0x1
#define MC_STAT_EMC_HIST_0_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_0_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_0_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_0_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_0_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_HIST_0_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_0_0_EMC_HIST_0_SHIFT                   _MK_SHIFT_CONST(0)
#define MC_STAT_EMC_HIST_0_0_EMC_HIST_0_FIELD                   (_MK_MASK_CONST(0xffffffff) << MC_STAT_EMC_HIST_0_0_EMC_HIST_0_SHIFT)
#define MC_STAT_EMC_HIST_0_0_EMC_HIST_0_RANGE                   31:0
#define MC_STAT_EMC_HIST_0_0_EMC_HIST_0_WOFFSET                 0x0
#define MC_STAT_EMC_HIST_0_0_EMC_HIST_0_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_0_0_EMC_HIST_0_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_0_0_EMC_HIST_0_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_0_0_EMC_HIST_0_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register MC_STAT_EMC_HIST_1_0  
#define MC_STAT_EMC_HIST_1_0                    _MK_ADDR_CONST(0xc4)
#define MC_STAT_EMC_HIST_1_0_SECURE                     0x0
#define MC_STAT_EMC_HIST_1_0_WORD_COUNT                         0x1
#define MC_STAT_EMC_HIST_1_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_1_0_RESET_MASK                         _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_1_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_1_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_1_0_READ_MASK                  _MK_MASK_CONST(0xffffffff)
#define MC_STAT_EMC_HIST_1_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_1_0_EMC_HIST_1_SHIFT                   _MK_SHIFT_CONST(0)
#define MC_STAT_EMC_HIST_1_0_EMC_HIST_1_FIELD                   (_MK_MASK_CONST(0xffffffff) << MC_STAT_EMC_HIST_1_0_EMC_HIST_1_SHIFT)
#define MC_STAT_EMC_HIST_1_0_EMC_HIST_1_RANGE                   31:0
#define MC_STAT_EMC_HIST_1_0_EMC_HIST_1_WOFFSET                 0x0
#define MC_STAT_EMC_HIST_1_0_EMC_HIST_1_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_1_0_EMC_HIST_1_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_1_0_EMC_HIST_1_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_STAT_EMC_HIST_1_0_EMC_HIST_1_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define MC_CLIENT_CTRL_DISABLE  0
#define MC_CLIENT_CTRL_ENABLE   1

// Register MC_CLIENT_CTRL_0  
#define MC_CLIENT_CTRL_0                        _MK_ADDR_CONST(0x100)
#define MC_CLIENT_CTRL_0_SECURE                         0x0
#define MC_CLIENT_CTRL_0_WORD_COUNT                     0x1
#define MC_CLIENT_CTRL_0_RESET_VAL                      _MK_MASK_CONST(0x7fff)
#define MC_CLIENT_CTRL_0_RESET_MASK                     _MK_MASK_CONST(0x7fff)
#define MC_CLIENT_CTRL_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_READ_MASK                      _MK_MASK_CONST(0x7fff)
#define MC_CLIENT_CTRL_0_WRITE_MASK                     _MK_MASK_CONST(0x7fff)
#define MC_CLIENT_CTRL_0_AVPC_ENABLE_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_CLIENT_CTRL_0_AVPC_ENABLE_FIELD                      (_MK_MASK_CONST(0x1) << MC_CLIENT_CTRL_0_AVPC_ENABLE_SHIFT)
#define MC_CLIENT_CTRL_0_AVPC_ENABLE_RANGE                      0:0
#define MC_CLIENT_CTRL_0_AVPC_ENABLE_WOFFSET                    0x0
#define MC_CLIENT_CTRL_0_AVPC_ENABLE_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_AVPC_ENABLE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_AVPC_ENABLE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_AVPC_ENABLE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_AVPC_ENABLE_INIT_ENUM                  ENABLE
#define MC_CLIENT_CTRL_0_AVPC_ENABLE_DISABLE                    _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_AVPC_ENABLE_ENABLE                     _MK_ENUM_CONST(1)
#define MC_CLIENT_CTRL_0_AVPC_ENABLE_DISABLED                   _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_AVPC_ENABLE_ENABLED                    _MK_ENUM_CONST(1)

#define MC_CLIENT_CTRL_0_DC_ENABLE_SHIFT                        _MK_SHIFT_CONST(1)
#define MC_CLIENT_CTRL_0_DC_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << MC_CLIENT_CTRL_0_DC_ENABLE_SHIFT)
#define MC_CLIENT_CTRL_0_DC_ENABLE_RANGE                        1:1
#define MC_CLIENT_CTRL_0_DC_ENABLE_WOFFSET                      0x0
#define MC_CLIENT_CTRL_0_DC_ENABLE_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_DC_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_DC_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_DC_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_DC_ENABLE_INIT_ENUM                    ENABLE
#define MC_CLIENT_CTRL_0_DC_ENABLE_DISABLE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_DC_ENABLE_ENABLE                       _MK_ENUM_CONST(1)
#define MC_CLIENT_CTRL_0_DC_ENABLE_DISABLED                     _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_DC_ENABLE_ENABLED                      _MK_ENUM_CONST(1)

#define MC_CLIENT_CTRL_0_DCB_ENABLE_SHIFT                       _MK_SHIFT_CONST(2)
#define MC_CLIENT_CTRL_0_DCB_ENABLE_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_CTRL_0_DCB_ENABLE_SHIFT)
#define MC_CLIENT_CTRL_0_DCB_ENABLE_RANGE                       2:2
#define MC_CLIENT_CTRL_0_DCB_ENABLE_WOFFSET                     0x0
#define MC_CLIENT_CTRL_0_DCB_ENABLE_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_DCB_ENABLE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_DCB_ENABLE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_DCB_ENABLE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_DCB_ENABLE_INIT_ENUM                   ENABLE
#define MC_CLIENT_CTRL_0_DCB_ENABLE_DISABLE                     _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_DCB_ENABLE_ENABLE                      _MK_ENUM_CONST(1)
#define MC_CLIENT_CTRL_0_DCB_ENABLE_DISABLED                    _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_DCB_ENABLE_ENABLED                     _MK_ENUM_CONST(1)

#define MC_CLIENT_CTRL_0_EPP_ENABLE_SHIFT                       _MK_SHIFT_CONST(3)
#define MC_CLIENT_CTRL_0_EPP_ENABLE_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_CTRL_0_EPP_ENABLE_SHIFT)
#define MC_CLIENT_CTRL_0_EPP_ENABLE_RANGE                       3:3
#define MC_CLIENT_CTRL_0_EPP_ENABLE_WOFFSET                     0x0
#define MC_CLIENT_CTRL_0_EPP_ENABLE_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_EPP_ENABLE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_EPP_ENABLE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_EPP_ENABLE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_EPP_ENABLE_INIT_ENUM                   ENABLE
#define MC_CLIENT_CTRL_0_EPP_ENABLE_DISABLE                     _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_EPP_ENABLE_ENABLE                      _MK_ENUM_CONST(1)
#define MC_CLIENT_CTRL_0_EPP_ENABLE_DISABLED                    _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_EPP_ENABLE_ENABLED                     _MK_ENUM_CONST(1)

#define MC_CLIENT_CTRL_0_G2_ENABLE_SHIFT                        _MK_SHIFT_CONST(4)
#define MC_CLIENT_CTRL_0_G2_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << MC_CLIENT_CTRL_0_G2_ENABLE_SHIFT)
#define MC_CLIENT_CTRL_0_G2_ENABLE_RANGE                        4:4
#define MC_CLIENT_CTRL_0_G2_ENABLE_WOFFSET                      0x0
#define MC_CLIENT_CTRL_0_G2_ENABLE_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_G2_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_G2_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_G2_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_G2_ENABLE_INIT_ENUM                    ENABLE
#define MC_CLIENT_CTRL_0_G2_ENABLE_DISABLE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_G2_ENABLE_ENABLE                       _MK_ENUM_CONST(1)
#define MC_CLIENT_CTRL_0_G2_ENABLE_DISABLED                     _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_G2_ENABLE_ENABLED                      _MK_ENUM_CONST(1)

#define MC_CLIENT_CTRL_0_HC_ENABLE_SHIFT                        _MK_SHIFT_CONST(5)
#define MC_CLIENT_CTRL_0_HC_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << MC_CLIENT_CTRL_0_HC_ENABLE_SHIFT)
#define MC_CLIENT_CTRL_0_HC_ENABLE_RANGE                        5:5
#define MC_CLIENT_CTRL_0_HC_ENABLE_WOFFSET                      0x0
#define MC_CLIENT_CTRL_0_HC_ENABLE_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_HC_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_HC_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_HC_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_HC_ENABLE_INIT_ENUM                    ENABLE
#define MC_CLIENT_CTRL_0_HC_ENABLE_DISABLE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_HC_ENABLE_ENABLE                       _MK_ENUM_CONST(1)
#define MC_CLIENT_CTRL_0_HC_ENABLE_DISABLED                     _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_HC_ENABLE_ENABLED                      _MK_ENUM_CONST(1)

#define MC_CLIENT_CTRL_0_ISP_ENABLE_SHIFT                       _MK_SHIFT_CONST(6)
#define MC_CLIENT_CTRL_0_ISP_ENABLE_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_CTRL_0_ISP_ENABLE_SHIFT)
#define MC_CLIENT_CTRL_0_ISP_ENABLE_RANGE                       6:6
#define MC_CLIENT_CTRL_0_ISP_ENABLE_WOFFSET                     0x0
#define MC_CLIENT_CTRL_0_ISP_ENABLE_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_ISP_ENABLE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_ISP_ENABLE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_ISP_ENABLE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_ISP_ENABLE_INIT_ENUM                   ENABLE
#define MC_CLIENT_CTRL_0_ISP_ENABLE_DISABLE                     _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_ISP_ENABLE_ENABLE                      _MK_ENUM_CONST(1)
#define MC_CLIENT_CTRL_0_ISP_ENABLE_DISABLED                    _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_ISP_ENABLE_ENABLED                     _MK_ENUM_CONST(1)

#define MC_CLIENT_CTRL_0_MPCORE_ENABLE_SHIFT                    _MK_SHIFT_CONST(7)
#define MC_CLIENT_CTRL_0_MPCORE_ENABLE_FIELD                    (_MK_MASK_CONST(0x1) << MC_CLIENT_CTRL_0_MPCORE_ENABLE_SHIFT)
#define MC_CLIENT_CTRL_0_MPCORE_ENABLE_RANGE                    7:7
#define MC_CLIENT_CTRL_0_MPCORE_ENABLE_WOFFSET                  0x0
#define MC_CLIENT_CTRL_0_MPCORE_ENABLE_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_MPCORE_ENABLE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_MPCORE_ENABLE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_MPCORE_ENABLE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_MPCORE_ENABLE_INIT_ENUM                        ENABLE
#define MC_CLIENT_CTRL_0_MPCORE_ENABLE_DISABLE                  _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_MPCORE_ENABLE_ENABLE                   _MK_ENUM_CONST(1)
#define MC_CLIENT_CTRL_0_MPCORE_ENABLE_DISABLED                 _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_MPCORE_ENABLE_ENABLED                  _MK_ENUM_CONST(1)

#define MC_CLIENT_CTRL_0_MPEA_ENABLE_SHIFT                      _MK_SHIFT_CONST(8)
#define MC_CLIENT_CTRL_0_MPEA_ENABLE_FIELD                      (_MK_MASK_CONST(0x1) << MC_CLIENT_CTRL_0_MPEA_ENABLE_SHIFT)
#define MC_CLIENT_CTRL_0_MPEA_ENABLE_RANGE                      8:8
#define MC_CLIENT_CTRL_0_MPEA_ENABLE_WOFFSET                    0x0
#define MC_CLIENT_CTRL_0_MPEA_ENABLE_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_MPEA_ENABLE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_MPEA_ENABLE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_MPEA_ENABLE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_MPEA_ENABLE_INIT_ENUM                  ENABLE
#define MC_CLIENT_CTRL_0_MPEA_ENABLE_DISABLE                    _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_MPEA_ENABLE_ENABLE                     _MK_ENUM_CONST(1)
#define MC_CLIENT_CTRL_0_MPEA_ENABLE_DISABLED                   _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_MPEA_ENABLE_ENABLED                    _MK_ENUM_CONST(1)

#define MC_CLIENT_CTRL_0_MPEB_ENABLE_SHIFT                      _MK_SHIFT_CONST(9)
#define MC_CLIENT_CTRL_0_MPEB_ENABLE_FIELD                      (_MK_MASK_CONST(0x1) << MC_CLIENT_CTRL_0_MPEB_ENABLE_SHIFT)
#define MC_CLIENT_CTRL_0_MPEB_ENABLE_RANGE                      9:9
#define MC_CLIENT_CTRL_0_MPEB_ENABLE_WOFFSET                    0x0
#define MC_CLIENT_CTRL_0_MPEB_ENABLE_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_MPEB_ENABLE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_MPEB_ENABLE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_MPEB_ENABLE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_MPEB_ENABLE_INIT_ENUM                  ENABLE
#define MC_CLIENT_CTRL_0_MPEB_ENABLE_DISABLE                    _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_MPEB_ENABLE_ENABLE                     _MK_ENUM_CONST(1)
#define MC_CLIENT_CTRL_0_MPEB_ENABLE_DISABLED                   _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_MPEB_ENABLE_ENABLED                    _MK_ENUM_CONST(1)

#define MC_CLIENT_CTRL_0_MPEC_ENABLE_SHIFT                      _MK_SHIFT_CONST(10)
#define MC_CLIENT_CTRL_0_MPEC_ENABLE_FIELD                      (_MK_MASK_CONST(0x1) << MC_CLIENT_CTRL_0_MPEC_ENABLE_SHIFT)
#define MC_CLIENT_CTRL_0_MPEC_ENABLE_RANGE                      10:10
#define MC_CLIENT_CTRL_0_MPEC_ENABLE_WOFFSET                    0x0
#define MC_CLIENT_CTRL_0_MPEC_ENABLE_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_MPEC_ENABLE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_MPEC_ENABLE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_MPEC_ENABLE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_MPEC_ENABLE_INIT_ENUM                  ENABLE
#define MC_CLIENT_CTRL_0_MPEC_ENABLE_DISABLE                    _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_MPEC_ENABLE_ENABLE                     _MK_ENUM_CONST(1)
#define MC_CLIENT_CTRL_0_MPEC_ENABLE_DISABLED                   _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_MPEC_ENABLE_ENABLED                    _MK_ENUM_CONST(1)

#define MC_CLIENT_CTRL_0_NV_ENABLE_SHIFT                        _MK_SHIFT_CONST(11)
#define MC_CLIENT_CTRL_0_NV_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << MC_CLIENT_CTRL_0_NV_ENABLE_SHIFT)
#define MC_CLIENT_CTRL_0_NV_ENABLE_RANGE                        11:11
#define MC_CLIENT_CTRL_0_NV_ENABLE_WOFFSET                      0x0
#define MC_CLIENT_CTRL_0_NV_ENABLE_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_NV_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_NV_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_NV_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_NV_ENABLE_INIT_ENUM                    ENABLE
#define MC_CLIENT_CTRL_0_NV_ENABLE_DISABLE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_NV_ENABLE_ENABLE                       _MK_ENUM_CONST(1)
#define MC_CLIENT_CTRL_0_NV_ENABLE_DISABLED                     _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_NV_ENABLE_ENABLED                      _MK_ENUM_CONST(1)

#define MC_CLIENT_CTRL_0_PPCS_ENABLE_SHIFT                      _MK_SHIFT_CONST(12)
#define MC_CLIENT_CTRL_0_PPCS_ENABLE_FIELD                      (_MK_MASK_CONST(0x1) << MC_CLIENT_CTRL_0_PPCS_ENABLE_SHIFT)
#define MC_CLIENT_CTRL_0_PPCS_ENABLE_RANGE                      12:12
#define MC_CLIENT_CTRL_0_PPCS_ENABLE_WOFFSET                    0x0
#define MC_CLIENT_CTRL_0_PPCS_ENABLE_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_PPCS_ENABLE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_PPCS_ENABLE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_PPCS_ENABLE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_PPCS_ENABLE_INIT_ENUM                  ENABLE
#define MC_CLIENT_CTRL_0_PPCS_ENABLE_DISABLE                    _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_PPCS_ENABLE_ENABLE                     _MK_ENUM_CONST(1)
#define MC_CLIENT_CTRL_0_PPCS_ENABLE_DISABLED                   _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_PPCS_ENABLE_ENABLED                    _MK_ENUM_CONST(1)

#define MC_CLIENT_CTRL_0_VDE_ENABLE_SHIFT                       _MK_SHIFT_CONST(13)
#define MC_CLIENT_CTRL_0_VDE_ENABLE_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_CTRL_0_VDE_ENABLE_SHIFT)
#define MC_CLIENT_CTRL_0_VDE_ENABLE_RANGE                       13:13
#define MC_CLIENT_CTRL_0_VDE_ENABLE_WOFFSET                     0x0
#define MC_CLIENT_CTRL_0_VDE_ENABLE_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_VDE_ENABLE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_VDE_ENABLE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_VDE_ENABLE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_VDE_ENABLE_INIT_ENUM                   ENABLE
#define MC_CLIENT_CTRL_0_VDE_ENABLE_DISABLE                     _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_VDE_ENABLE_ENABLE                      _MK_ENUM_CONST(1)
#define MC_CLIENT_CTRL_0_VDE_ENABLE_DISABLED                    _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_VDE_ENABLE_ENABLED                     _MK_ENUM_CONST(1)

#define MC_CLIENT_CTRL_0_VI_ENABLE_SHIFT                        _MK_SHIFT_CONST(14)
#define MC_CLIENT_CTRL_0_VI_ENABLE_FIELD                        (_MK_MASK_CONST(0x1) << MC_CLIENT_CTRL_0_VI_ENABLE_SHIFT)
#define MC_CLIENT_CTRL_0_VI_ENABLE_RANGE                        14:14
#define MC_CLIENT_CTRL_0_VI_ENABLE_WOFFSET                      0x0
#define MC_CLIENT_CTRL_0_VI_ENABLE_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_VI_ENABLE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_CLIENT_CTRL_0_VI_ENABLE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_VI_ENABLE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_CTRL_0_VI_ENABLE_INIT_ENUM                    ENABLE
#define MC_CLIENT_CTRL_0_VI_ENABLE_DISABLE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_VI_ENABLE_ENABLE                       _MK_ENUM_CONST(1)
#define MC_CLIENT_CTRL_0_VI_ENABLE_DISABLED                     _MK_ENUM_CONST(0)
#define MC_CLIENT_CTRL_0_VI_ENABLE_ENABLED                      _MK_ENUM_CONST(1)

#define MC_CLIENT_HOTRESETN_DISABLE     1
#define MC_CLIENT_HOTRESETN_ENABLE      0

// Register MC_CLIENT_HOTRESETN_0  
#define MC_CLIENT_HOTRESETN_0                   _MK_ADDR_CONST(0x104)
#define MC_CLIENT_HOTRESETN_0_SECURE                    0x0
#define MC_CLIENT_HOTRESETN_0_WORD_COUNT                        0x1
#define MC_CLIENT_HOTRESETN_0_RESET_VAL                         _MK_MASK_CONST(0x7fff)
#define MC_CLIENT_HOTRESETN_0_RESET_MASK                        _MK_MASK_CONST(0x7fff)
#define MC_CLIENT_HOTRESETN_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_READ_MASK                         _MK_MASK_CONST(0x7fff)
#define MC_CLIENT_HOTRESETN_0_WRITE_MASK                        _MK_MASK_CONST(0x7fff)
#define MC_CLIENT_HOTRESETN_0_AVPC_HOTRESETN_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_CLIENT_HOTRESETN_0_AVPC_HOTRESETN_FIELD                      (_MK_MASK_CONST(0x1) << MC_CLIENT_HOTRESETN_0_AVPC_HOTRESETN_SHIFT)
#define MC_CLIENT_HOTRESETN_0_AVPC_HOTRESETN_RANGE                      0:0
#define MC_CLIENT_HOTRESETN_0_AVPC_HOTRESETN_WOFFSET                    0x0
#define MC_CLIENT_HOTRESETN_0_AVPC_HOTRESETN_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_AVPC_HOTRESETN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_AVPC_HOTRESETN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_AVPC_HOTRESETN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_AVPC_HOTRESETN_INIT_ENUM                  DISABLE
#define MC_CLIENT_HOTRESETN_0_AVPC_HOTRESETN_ENABLE                     _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_AVPC_HOTRESETN_DISABLE                    _MK_ENUM_CONST(1)
#define MC_CLIENT_HOTRESETN_0_AVPC_HOTRESETN_ENABLED                    _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_AVPC_HOTRESETN_DISABLED                   _MK_ENUM_CONST(1)

#define MC_CLIENT_HOTRESETN_0_DC_HOTRESETN_SHIFT                        _MK_SHIFT_CONST(1)
#define MC_CLIENT_HOTRESETN_0_DC_HOTRESETN_FIELD                        (_MK_MASK_CONST(0x1) << MC_CLIENT_HOTRESETN_0_DC_HOTRESETN_SHIFT)
#define MC_CLIENT_HOTRESETN_0_DC_HOTRESETN_RANGE                        1:1
#define MC_CLIENT_HOTRESETN_0_DC_HOTRESETN_WOFFSET                      0x0
#define MC_CLIENT_HOTRESETN_0_DC_HOTRESETN_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_DC_HOTRESETN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_DC_HOTRESETN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_DC_HOTRESETN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_DC_HOTRESETN_INIT_ENUM                    DISABLE
#define MC_CLIENT_HOTRESETN_0_DC_HOTRESETN_ENABLE                       _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_DC_HOTRESETN_DISABLE                      _MK_ENUM_CONST(1)
#define MC_CLIENT_HOTRESETN_0_DC_HOTRESETN_ENABLED                      _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_DC_HOTRESETN_DISABLED                     _MK_ENUM_CONST(1)

#define MC_CLIENT_HOTRESETN_0_DCB_HOTRESETN_SHIFT                       _MK_SHIFT_CONST(2)
#define MC_CLIENT_HOTRESETN_0_DCB_HOTRESETN_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_HOTRESETN_0_DCB_HOTRESETN_SHIFT)
#define MC_CLIENT_HOTRESETN_0_DCB_HOTRESETN_RANGE                       2:2
#define MC_CLIENT_HOTRESETN_0_DCB_HOTRESETN_WOFFSET                     0x0
#define MC_CLIENT_HOTRESETN_0_DCB_HOTRESETN_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_DCB_HOTRESETN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_DCB_HOTRESETN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_DCB_HOTRESETN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_DCB_HOTRESETN_INIT_ENUM                   DISABLE
#define MC_CLIENT_HOTRESETN_0_DCB_HOTRESETN_ENABLE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_DCB_HOTRESETN_DISABLE                     _MK_ENUM_CONST(1)
#define MC_CLIENT_HOTRESETN_0_DCB_HOTRESETN_ENABLED                     _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_DCB_HOTRESETN_DISABLED                    _MK_ENUM_CONST(1)

#define MC_CLIENT_HOTRESETN_0_EPP_HOTRESETN_SHIFT                       _MK_SHIFT_CONST(3)
#define MC_CLIENT_HOTRESETN_0_EPP_HOTRESETN_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_HOTRESETN_0_EPP_HOTRESETN_SHIFT)
#define MC_CLIENT_HOTRESETN_0_EPP_HOTRESETN_RANGE                       3:3
#define MC_CLIENT_HOTRESETN_0_EPP_HOTRESETN_WOFFSET                     0x0
#define MC_CLIENT_HOTRESETN_0_EPP_HOTRESETN_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_EPP_HOTRESETN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_EPP_HOTRESETN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_EPP_HOTRESETN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_EPP_HOTRESETN_INIT_ENUM                   DISABLE
#define MC_CLIENT_HOTRESETN_0_EPP_HOTRESETN_ENABLE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_EPP_HOTRESETN_DISABLE                     _MK_ENUM_CONST(1)
#define MC_CLIENT_HOTRESETN_0_EPP_HOTRESETN_ENABLED                     _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_EPP_HOTRESETN_DISABLED                    _MK_ENUM_CONST(1)

#define MC_CLIENT_HOTRESETN_0_G2_HOTRESETN_SHIFT                        _MK_SHIFT_CONST(4)
#define MC_CLIENT_HOTRESETN_0_G2_HOTRESETN_FIELD                        (_MK_MASK_CONST(0x1) << MC_CLIENT_HOTRESETN_0_G2_HOTRESETN_SHIFT)
#define MC_CLIENT_HOTRESETN_0_G2_HOTRESETN_RANGE                        4:4
#define MC_CLIENT_HOTRESETN_0_G2_HOTRESETN_WOFFSET                      0x0
#define MC_CLIENT_HOTRESETN_0_G2_HOTRESETN_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_G2_HOTRESETN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_G2_HOTRESETN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_G2_HOTRESETN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_G2_HOTRESETN_INIT_ENUM                    DISABLE
#define MC_CLIENT_HOTRESETN_0_G2_HOTRESETN_ENABLE                       _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_G2_HOTRESETN_DISABLE                      _MK_ENUM_CONST(1)
#define MC_CLIENT_HOTRESETN_0_G2_HOTRESETN_ENABLED                      _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_G2_HOTRESETN_DISABLED                     _MK_ENUM_CONST(1)

#define MC_CLIENT_HOTRESETN_0_HC_HOTRESETN_SHIFT                        _MK_SHIFT_CONST(5)
#define MC_CLIENT_HOTRESETN_0_HC_HOTRESETN_FIELD                        (_MK_MASK_CONST(0x1) << MC_CLIENT_HOTRESETN_0_HC_HOTRESETN_SHIFT)
#define MC_CLIENT_HOTRESETN_0_HC_HOTRESETN_RANGE                        5:5
#define MC_CLIENT_HOTRESETN_0_HC_HOTRESETN_WOFFSET                      0x0
#define MC_CLIENT_HOTRESETN_0_HC_HOTRESETN_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_HC_HOTRESETN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_HC_HOTRESETN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_HC_HOTRESETN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_HC_HOTRESETN_INIT_ENUM                    DISABLE
#define MC_CLIENT_HOTRESETN_0_HC_HOTRESETN_ENABLE                       _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_HC_HOTRESETN_DISABLE                      _MK_ENUM_CONST(1)
#define MC_CLIENT_HOTRESETN_0_HC_HOTRESETN_ENABLED                      _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_HC_HOTRESETN_DISABLED                     _MK_ENUM_CONST(1)

#define MC_CLIENT_HOTRESETN_0_ISP_HOTRESETN_SHIFT                       _MK_SHIFT_CONST(6)
#define MC_CLIENT_HOTRESETN_0_ISP_HOTRESETN_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_HOTRESETN_0_ISP_HOTRESETN_SHIFT)
#define MC_CLIENT_HOTRESETN_0_ISP_HOTRESETN_RANGE                       6:6
#define MC_CLIENT_HOTRESETN_0_ISP_HOTRESETN_WOFFSET                     0x0
#define MC_CLIENT_HOTRESETN_0_ISP_HOTRESETN_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_ISP_HOTRESETN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_ISP_HOTRESETN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_ISP_HOTRESETN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_ISP_HOTRESETN_INIT_ENUM                   DISABLE
#define MC_CLIENT_HOTRESETN_0_ISP_HOTRESETN_ENABLE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_ISP_HOTRESETN_DISABLE                     _MK_ENUM_CONST(1)
#define MC_CLIENT_HOTRESETN_0_ISP_HOTRESETN_ENABLED                     _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_ISP_HOTRESETN_DISABLED                    _MK_ENUM_CONST(1)

#define MC_CLIENT_HOTRESETN_0_MPCORE_HOTRESETN_SHIFT                    _MK_SHIFT_CONST(7)
#define MC_CLIENT_HOTRESETN_0_MPCORE_HOTRESETN_FIELD                    (_MK_MASK_CONST(0x1) << MC_CLIENT_HOTRESETN_0_MPCORE_HOTRESETN_SHIFT)
#define MC_CLIENT_HOTRESETN_0_MPCORE_HOTRESETN_RANGE                    7:7
#define MC_CLIENT_HOTRESETN_0_MPCORE_HOTRESETN_WOFFSET                  0x0
#define MC_CLIENT_HOTRESETN_0_MPCORE_HOTRESETN_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_MPCORE_HOTRESETN_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_MPCORE_HOTRESETN_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_MPCORE_HOTRESETN_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_MPCORE_HOTRESETN_INIT_ENUM                        DISABLE
#define MC_CLIENT_HOTRESETN_0_MPCORE_HOTRESETN_ENABLE                   _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_MPCORE_HOTRESETN_DISABLE                  _MK_ENUM_CONST(1)
#define MC_CLIENT_HOTRESETN_0_MPCORE_HOTRESETN_ENABLED                  _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_MPCORE_HOTRESETN_DISABLED                 _MK_ENUM_CONST(1)

#define MC_CLIENT_HOTRESETN_0_MPEA_HOTRESETN_SHIFT                      _MK_SHIFT_CONST(8)
#define MC_CLIENT_HOTRESETN_0_MPEA_HOTRESETN_FIELD                      (_MK_MASK_CONST(0x1) << MC_CLIENT_HOTRESETN_0_MPEA_HOTRESETN_SHIFT)
#define MC_CLIENT_HOTRESETN_0_MPEA_HOTRESETN_RANGE                      8:8
#define MC_CLIENT_HOTRESETN_0_MPEA_HOTRESETN_WOFFSET                    0x0
#define MC_CLIENT_HOTRESETN_0_MPEA_HOTRESETN_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_MPEA_HOTRESETN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_MPEA_HOTRESETN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_MPEA_HOTRESETN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_MPEA_HOTRESETN_INIT_ENUM                  DISABLE
#define MC_CLIENT_HOTRESETN_0_MPEA_HOTRESETN_ENABLE                     _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_MPEA_HOTRESETN_DISABLE                    _MK_ENUM_CONST(1)
#define MC_CLIENT_HOTRESETN_0_MPEA_HOTRESETN_ENABLED                    _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_MPEA_HOTRESETN_DISABLED                   _MK_ENUM_CONST(1)

#define MC_CLIENT_HOTRESETN_0_MPEB_HOTRESETN_SHIFT                      _MK_SHIFT_CONST(9)
#define MC_CLIENT_HOTRESETN_0_MPEB_HOTRESETN_FIELD                      (_MK_MASK_CONST(0x1) << MC_CLIENT_HOTRESETN_0_MPEB_HOTRESETN_SHIFT)
#define MC_CLIENT_HOTRESETN_0_MPEB_HOTRESETN_RANGE                      9:9
#define MC_CLIENT_HOTRESETN_0_MPEB_HOTRESETN_WOFFSET                    0x0
#define MC_CLIENT_HOTRESETN_0_MPEB_HOTRESETN_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_MPEB_HOTRESETN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_MPEB_HOTRESETN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_MPEB_HOTRESETN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_MPEB_HOTRESETN_INIT_ENUM                  DISABLE
#define MC_CLIENT_HOTRESETN_0_MPEB_HOTRESETN_ENABLE                     _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_MPEB_HOTRESETN_DISABLE                    _MK_ENUM_CONST(1)
#define MC_CLIENT_HOTRESETN_0_MPEB_HOTRESETN_ENABLED                    _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_MPEB_HOTRESETN_DISABLED                   _MK_ENUM_CONST(1)

#define MC_CLIENT_HOTRESETN_0_MPEC_HOTRESETN_SHIFT                      _MK_SHIFT_CONST(10)
#define MC_CLIENT_HOTRESETN_0_MPEC_HOTRESETN_FIELD                      (_MK_MASK_CONST(0x1) << MC_CLIENT_HOTRESETN_0_MPEC_HOTRESETN_SHIFT)
#define MC_CLIENT_HOTRESETN_0_MPEC_HOTRESETN_RANGE                      10:10
#define MC_CLIENT_HOTRESETN_0_MPEC_HOTRESETN_WOFFSET                    0x0
#define MC_CLIENT_HOTRESETN_0_MPEC_HOTRESETN_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_MPEC_HOTRESETN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_MPEC_HOTRESETN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_MPEC_HOTRESETN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_MPEC_HOTRESETN_INIT_ENUM                  DISABLE
#define MC_CLIENT_HOTRESETN_0_MPEC_HOTRESETN_ENABLE                     _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_MPEC_HOTRESETN_DISABLE                    _MK_ENUM_CONST(1)
#define MC_CLIENT_HOTRESETN_0_MPEC_HOTRESETN_ENABLED                    _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_MPEC_HOTRESETN_DISABLED                   _MK_ENUM_CONST(1)

#define MC_CLIENT_HOTRESETN_0_NV_HOTRESETN_SHIFT                        _MK_SHIFT_CONST(11)
#define MC_CLIENT_HOTRESETN_0_NV_HOTRESETN_FIELD                        (_MK_MASK_CONST(0x1) << MC_CLIENT_HOTRESETN_0_NV_HOTRESETN_SHIFT)
#define MC_CLIENT_HOTRESETN_0_NV_HOTRESETN_RANGE                        11:11
#define MC_CLIENT_HOTRESETN_0_NV_HOTRESETN_WOFFSET                      0x0
#define MC_CLIENT_HOTRESETN_0_NV_HOTRESETN_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_NV_HOTRESETN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_NV_HOTRESETN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_NV_HOTRESETN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_NV_HOTRESETN_INIT_ENUM                    DISABLE
#define MC_CLIENT_HOTRESETN_0_NV_HOTRESETN_ENABLE                       _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_NV_HOTRESETN_DISABLE                      _MK_ENUM_CONST(1)
#define MC_CLIENT_HOTRESETN_0_NV_HOTRESETN_ENABLED                      _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_NV_HOTRESETN_DISABLED                     _MK_ENUM_CONST(1)

#define MC_CLIENT_HOTRESETN_0_PPCS_HOTRESETN_SHIFT                      _MK_SHIFT_CONST(12)
#define MC_CLIENT_HOTRESETN_0_PPCS_HOTRESETN_FIELD                      (_MK_MASK_CONST(0x1) << MC_CLIENT_HOTRESETN_0_PPCS_HOTRESETN_SHIFT)
#define MC_CLIENT_HOTRESETN_0_PPCS_HOTRESETN_RANGE                      12:12
#define MC_CLIENT_HOTRESETN_0_PPCS_HOTRESETN_WOFFSET                    0x0
#define MC_CLIENT_HOTRESETN_0_PPCS_HOTRESETN_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_PPCS_HOTRESETN_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_PPCS_HOTRESETN_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_PPCS_HOTRESETN_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_PPCS_HOTRESETN_INIT_ENUM                  DISABLE
#define MC_CLIENT_HOTRESETN_0_PPCS_HOTRESETN_ENABLE                     _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_PPCS_HOTRESETN_DISABLE                    _MK_ENUM_CONST(1)
#define MC_CLIENT_HOTRESETN_0_PPCS_HOTRESETN_ENABLED                    _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_PPCS_HOTRESETN_DISABLED                   _MK_ENUM_CONST(1)

#define MC_CLIENT_HOTRESETN_0_VDE_HOTRESETN_SHIFT                       _MK_SHIFT_CONST(13)
#define MC_CLIENT_HOTRESETN_0_VDE_HOTRESETN_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_HOTRESETN_0_VDE_HOTRESETN_SHIFT)
#define MC_CLIENT_HOTRESETN_0_VDE_HOTRESETN_RANGE                       13:13
#define MC_CLIENT_HOTRESETN_0_VDE_HOTRESETN_WOFFSET                     0x0
#define MC_CLIENT_HOTRESETN_0_VDE_HOTRESETN_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_VDE_HOTRESETN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_VDE_HOTRESETN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_VDE_HOTRESETN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_VDE_HOTRESETN_INIT_ENUM                   DISABLE
#define MC_CLIENT_HOTRESETN_0_VDE_HOTRESETN_ENABLE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_VDE_HOTRESETN_DISABLE                     _MK_ENUM_CONST(1)
#define MC_CLIENT_HOTRESETN_0_VDE_HOTRESETN_ENABLED                     _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_VDE_HOTRESETN_DISABLED                    _MK_ENUM_CONST(1)

#define MC_CLIENT_HOTRESETN_0_VI_HOTRESETN_SHIFT                        _MK_SHIFT_CONST(14)
#define MC_CLIENT_HOTRESETN_0_VI_HOTRESETN_FIELD                        (_MK_MASK_CONST(0x1) << MC_CLIENT_HOTRESETN_0_VI_HOTRESETN_SHIFT)
#define MC_CLIENT_HOTRESETN_0_VI_HOTRESETN_RANGE                        14:14
#define MC_CLIENT_HOTRESETN_0_VI_HOTRESETN_WOFFSET                      0x0
#define MC_CLIENT_HOTRESETN_0_VI_HOTRESETN_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_VI_HOTRESETN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_CLIENT_HOTRESETN_0_VI_HOTRESETN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_VI_HOTRESETN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_HOTRESETN_0_VI_HOTRESETN_INIT_ENUM                    DISABLE
#define MC_CLIENT_HOTRESETN_0_VI_HOTRESETN_ENABLE                       _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_VI_HOTRESETN_DISABLE                      _MK_ENUM_CONST(1)
#define MC_CLIENT_HOTRESETN_0_VI_HOTRESETN_ENABLED                      _MK_ENUM_CONST(0)
#define MC_CLIENT_HOTRESETN_0_VI_HOTRESETN_DISABLED                     _MK_ENUM_CONST(1)


// Register MC_AXI_DECERR_OVR_0  
#define MC_AXI_DECERR_OVR_0                     _MK_ADDR_CONST(0x108)
#define MC_AXI_DECERR_OVR_0_SECURE                      0x0
#define MC_AXI_DECERR_OVR_0_WORD_COUNT                  0x1
#define MC_AXI_DECERR_OVR_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define MC_AXI_DECERR_OVR_0_RESET_MASK                  _MK_MASK_CONST(0x3)
#define MC_AXI_DECERR_OVR_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define MC_AXI_DECERR_OVR_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_AXI_DECERR_OVR_0_READ_MASK                   _MK_MASK_CONST(0x3)
#define MC_AXI_DECERR_OVR_0_WRITE_MASK                  _MK_MASK_CONST(0x3)
#define MC_AXI_DECERR_OVR_0_MPCORER_DECERR_OVR_SHIFT                    _MK_SHIFT_CONST(0)
#define MC_AXI_DECERR_OVR_0_MPCORER_DECERR_OVR_FIELD                    (_MK_MASK_CONST(0x1) << MC_AXI_DECERR_OVR_0_MPCORER_DECERR_OVR_SHIFT)
#define MC_AXI_DECERR_OVR_0_MPCORER_DECERR_OVR_RANGE                    0:0
#define MC_AXI_DECERR_OVR_0_MPCORER_DECERR_OVR_WOFFSET                  0x0
#define MC_AXI_DECERR_OVR_0_MPCORER_DECERR_OVR_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AXI_DECERR_OVR_0_MPCORER_DECERR_OVR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_AXI_DECERR_OVR_0_MPCORER_DECERR_OVR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AXI_DECERR_OVR_0_MPCORER_DECERR_OVR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_AXI_DECERR_OVR_0_MPCORER_DECERR_OVR_INIT_ENUM                        DISABLE
#define MC_AXI_DECERR_OVR_0_MPCORER_DECERR_OVR_DECERR_ALLOWED                   _MK_ENUM_CONST(0)
#define MC_AXI_DECERR_OVR_0_MPCORER_DECERR_OVR_ALWAYS_OK                        _MK_ENUM_CONST(1)
#define MC_AXI_DECERR_OVR_0_MPCORER_DECERR_OVR_DISABLE                  _MK_ENUM_CONST(0)
#define MC_AXI_DECERR_OVR_0_MPCORER_DECERR_OVR_ENABLE                   _MK_ENUM_CONST(1)
#define MC_AXI_DECERR_OVR_0_MPCORER_DECERR_OVR_DISABLED                 _MK_ENUM_CONST(0)
#define MC_AXI_DECERR_OVR_0_MPCORER_DECERR_OVR_ENABLED                  _MK_ENUM_CONST(1)

#define MC_AXI_DECERR_OVR_0_MPCOREW_DECERR_OVR_SHIFT                    _MK_SHIFT_CONST(1)
#define MC_AXI_DECERR_OVR_0_MPCOREW_DECERR_OVR_FIELD                    (_MK_MASK_CONST(0x1) << MC_AXI_DECERR_OVR_0_MPCOREW_DECERR_OVR_SHIFT)
#define MC_AXI_DECERR_OVR_0_MPCOREW_DECERR_OVR_RANGE                    1:1
#define MC_AXI_DECERR_OVR_0_MPCOREW_DECERR_OVR_WOFFSET                  0x0
#define MC_AXI_DECERR_OVR_0_MPCOREW_DECERR_OVR_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AXI_DECERR_OVR_0_MPCOREW_DECERR_OVR_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_AXI_DECERR_OVR_0_MPCOREW_DECERR_OVR_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AXI_DECERR_OVR_0_MPCOREW_DECERR_OVR_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_AXI_DECERR_OVR_0_MPCOREW_DECERR_OVR_INIT_ENUM                        DISABLE
#define MC_AXI_DECERR_OVR_0_MPCOREW_DECERR_OVR_DECERR_ALLOWED                   _MK_ENUM_CONST(0)
#define MC_AXI_DECERR_OVR_0_MPCOREW_DECERR_OVR_ALWAYS_OK                        _MK_ENUM_CONST(1)
#define MC_AXI_DECERR_OVR_0_MPCOREW_DECERR_OVR_DISABLE                  _MK_ENUM_CONST(0)
#define MC_AXI_DECERR_OVR_0_MPCOREW_DECERR_OVR_ENABLE                   _MK_ENUM_CONST(1)
#define MC_AXI_DECERR_OVR_0_MPCOREW_DECERR_OVR_DISABLED                 _MK_ENUM_CONST(0)
#define MC_AXI_DECERR_OVR_0_MPCOREW_DECERR_OVR_ENABLED                  _MK_ENUM_CONST(1)

#define MC_CLIENT_LL_CTRL_DISABLE       0
#define MC_CLIENT_LL_CTRL_ENABLE        1

// Register MC_LOWLATENCY_CONFIG_0  
#define MC_LOWLATENCY_CONFIG_0                  _MK_ADDR_CONST(0x10c)
#define MC_LOWLATENCY_CONFIG_0_SECURE                   0x0
#define MC_LOWLATENCY_CONFIG_0_WORD_COUNT                       0x1
#define MC_LOWLATENCY_CONFIG_0_RESET_VAL                        _MK_MASK_CONST(0x80000003)
#define MC_LOWLATENCY_CONFIG_0_RESET_MASK                       _MK_MASK_CONST(0x80000003)
#define MC_LOWLATENCY_CONFIG_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_CONFIG_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_CONFIG_0_READ_MASK                        _MK_MASK_CONST(0x80000003)
#define MC_LOWLATENCY_CONFIG_0_WRITE_MASK                       _MK_MASK_CONST(0x80000003)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_SHIFT                    _MK_SHIFT_CONST(0)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_FIELD                    (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_SHIFT)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_RANGE                    0:0
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_WOFFSET                  0x0
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_INIT_ENUM                        ENABLE
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_DISABLE                  _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_ENABLE                   _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_DISABLED                 _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_CTRL_ENABLED                  _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_SHIFT                       _MK_SHIFT_CONST(1)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_FIELD                       (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_SHIFT)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_RANGE                       1:1
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_WOFFSET                     0x0
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_INIT_ENUM                   ENABLE
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_DISABLE                     _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_ENABLE                      _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_DISABLED                    _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_CONFIG_0_MPCORER_LL_SEND_BOTH_ENABLED                     _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_SHIFT                 _MK_SHIFT_CONST(31)
#define MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_FIELD                 (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_SHIFT)
#define MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_RANGE                 31:31
#define MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_WOFFSET                       0x0
#define MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_DEFAULT                       _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_INIT_ENUM                     ENABLE
#define MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_DISABLE                       _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_ENABLE                        _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_DISABLED                      _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_CONFIG_0_LL_DRAM_INTERLEAVE_ENABLED                       _MK_ENUM_CONST(1)


// Register MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0  
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0                     _MK_ADDR_CONST(0x110)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_SECURE                      0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_WORD_COUNT                  0x1
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_RESET_VAL                   _MK_MASK_CONST(0xfffff)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_RESET_MASK                  _MK_MASK_CONST(0xfffff)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_READ_MASK                   _MK_MASK_CONST(0xfffff)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_WRITE_MASK                  _MK_MASK_CONST(0xfffff)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPU_LL_RAW_PARTICIPATE_SHIFT                       _MK_SHIFT_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPU_LL_RAW_PARTICIPATE_FIELD                       (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPU_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPU_LL_RAW_PARTICIPATE_RANGE                       0:0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPU_LL_RAW_PARTICIPATE_WOFFSET                     0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPU_LL_RAW_PARTICIPATE_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPU_LL_RAW_PARTICIPATE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPU_LL_RAW_PARTICIPATE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPU_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPU_LL_RAW_PARTICIPATE_INIT_ENUM                   ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPU_LL_RAW_PARTICIPATE_DISABLE                     _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPU_LL_RAW_PARTICIPATE_ENABLE                      _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPU_LL_RAW_PARTICIPATE_DISABLED                    _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPU_LL_RAW_PARTICIPATE_ENABLED                     _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPV_LL_RAW_PARTICIPATE_SHIFT                       _MK_SHIFT_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPV_LL_RAW_PARTICIPATE_FIELD                       (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPV_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPV_LL_RAW_PARTICIPATE_RANGE                       1:1
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPV_LL_RAW_PARTICIPATE_WOFFSET                     0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPV_LL_RAW_PARTICIPATE_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPV_LL_RAW_PARTICIPATE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPV_LL_RAW_PARTICIPATE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPV_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPV_LL_RAW_PARTICIPATE_INIT_ENUM                   ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPV_LL_RAW_PARTICIPATE_DISABLE                     _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPV_LL_RAW_PARTICIPATE_ENABLE                      _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPV_LL_RAW_PARTICIPATE_DISABLED                    _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPV_LL_RAW_PARTICIPATE_ENABLED                     _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPY_LL_RAW_PARTICIPATE_SHIFT                       _MK_SHIFT_CONST(2)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPY_LL_RAW_PARTICIPATE_FIELD                       (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPY_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPY_LL_RAW_PARTICIPATE_RANGE                       2:2
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPY_LL_RAW_PARTICIPATE_WOFFSET                     0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPY_LL_RAW_PARTICIPATE_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPY_LL_RAW_PARTICIPATE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPY_LL_RAW_PARTICIPATE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPY_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPY_LL_RAW_PARTICIPATE_INIT_ENUM                   ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPY_LL_RAW_PARTICIPATE_DISABLE                     _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPY_LL_RAW_PARTICIPATE_ENABLE                      _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPY_LL_RAW_PARTICIPATE_DISABLED                    _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_EPPY_LL_RAW_PARTICIPATE_ENABLED                     _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPEUNIFBW_LL_RAW_PARTICIPATE_SHIFT                  _MK_SHIFT_CONST(3)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPEUNIFBW_LL_RAW_PARTICIPATE_FIELD                  (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPEUNIFBW_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPEUNIFBW_LL_RAW_PARTICIPATE_RANGE                  3:3
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPEUNIFBW_LL_RAW_PARTICIPATE_WOFFSET                        0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPEUNIFBW_LL_RAW_PARTICIPATE_DEFAULT                        _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPEUNIFBW_LL_RAW_PARTICIPATE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPEUNIFBW_LL_RAW_PARTICIPATE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPEUNIFBW_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPEUNIFBW_LL_RAW_PARTICIPATE_INIT_ENUM                      ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPEUNIFBW_LL_RAW_PARTICIPATE_DISABLE                        _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPEUNIFBW_LL_RAW_PARTICIPATE_ENABLE                 _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPEUNIFBW_LL_RAW_PARTICIPATE_DISABLED                       _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPEUNIFBW_LL_RAW_PARTICIPATE_ENABLED                        _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWSB_LL_RAW_PARTICIPATE_SHIFT                      _MK_SHIFT_CONST(4)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWSB_LL_RAW_PARTICIPATE_FIELD                      (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWSB_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWSB_LL_RAW_PARTICIPATE_RANGE                      4:4
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWSB_LL_RAW_PARTICIPATE_WOFFSET                    0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWSB_LL_RAW_PARTICIPATE_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWSB_LL_RAW_PARTICIPATE_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWSB_LL_RAW_PARTICIPATE_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWSB_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWSB_LL_RAW_PARTICIPATE_INIT_ENUM                  ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWSB_LL_RAW_PARTICIPATE_DISABLE                    _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWSB_LL_RAW_PARTICIPATE_ENABLE                     _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWSB_LL_RAW_PARTICIPATE_DISABLED                   _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWSB_LL_RAW_PARTICIPATE_ENABLED                    _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWU_LL_RAW_PARTICIPATE_SHIFT                       _MK_SHIFT_CONST(5)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWU_LL_RAW_PARTICIPATE_FIELD                       (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWU_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWU_LL_RAW_PARTICIPATE_RANGE                       5:5
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWU_LL_RAW_PARTICIPATE_WOFFSET                     0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWU_LL_RAW_PARTICIPATE_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWU_LL_RAW_PARTICIPATE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWU_LL_RAW_PARTICIPATE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWU_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWU_LL_RAW_PARTICIPATE_INIT_ENUM                   ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWU_LL_RAW_PARTICIPATE_DISABLE                     _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWU_LL_RAW_PARTICIPATE_ENABLE                      _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWU_LL_RAW_PARTICIPATE_DISABLED                    _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWU_LL_RAW_PARTICIPATE_ENABLED                     _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWV_LL_RAW_PARTICIPATE_SHIFT                       _MK_SHIFT_CONST(6)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWV_LL_RAW_PARTICIPATE_FIELD                       (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWV_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWV_LL_RAW_PARTICIPATE_RANGE                       6:6
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWV_LL_RAW_PARTICIPATE_WOFFSET                     0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWV_LL_RAW_PARTICIPATE_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWV_LL_RAW_PARTICIPATE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWV_LL_RAW_PARTICIPATE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWV_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWV_LL_RAW_PARTICIPATE_INIT_ENUM                   ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWV_LL_RAW_PARTICIPATE_DISABLE                     _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWV_LL_RAW_PARTICIPATE_ENABLE                      _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWV_LL_RAW_PARTICIPATE_DISABLED                    _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWV_LL_RAW_PARTICIPATE_ENABLED                     _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWY_LL_RAW_PARTICIPATE_SHIFT                       _MK_SHIFT_CONST(7)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWY_LL_RAW_PARTICIPATE_FIELD                       (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWY_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWY_LL_RAW_PARTICIPATE_RANGE                       7:7
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWY_LL_RAW_PARTICIPATE_WOFFSET                     0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWY_LL_RAW_PARTICIPATE_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWY_LL_RAW_PARTICIPATE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWY_LL_RAW_PARTICIPATE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWY_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWY_LL_RAW_PARTICIPATE_INIT_ENUM                   ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWY_LL_RAW_PARTICIPATE_DISABLE                     _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWY_LL_RAW_PARTICIPATE_ENABLE                      _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWY_LL_RAW_PARTICIPATE_DISABLED                    _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VIWY_LL_RAW_PARTICIPATE_ENABLED                     _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_G2DW_LL_RAW_PARTICIPATE_SHIFT                       _MK_SHIFT_CONST(8)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_G2DW_LL_RAW_PARTICIPATE_FIELD                       (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_G2DW_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_G2DW_LL_RAW_PARTICIPATE_RANGE                       8:8
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_G2DW_LL_RAW_PARTICIPATE_WOFFSET                     0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_G2DW_LL_RAW_PARTICIPATE_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_G2DW_LL_RAW_PARTICIPATE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_G2DW_LL_RAW_PARTICIPATE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_G2DW_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_G2DW_LL_RAW_PARTICIPATE_INIT_ENUM                   ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_G2DW_LL_RAW_PARTICIPATE_DISABLE                     _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_G2DW_LL_RAW_PARTICIPATE_ENABLE                      _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_G2DW_LL_RAW_PARTICIPATE_DISABLED                    _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_G2DW_LL_RAW_PARTICIPATE_ENABLED                     _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_AVPCARM7W_LL_RAW_PARTICIPATE_SHIFT                  _MK_SHIFT_CONST(9)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_AVPCARM7W_LL_RAW_PARTICIPATE_FIELD                  (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_AVPCARM7W_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_AVPCARM7W_LL_RAW_PARTICIPATE_RANGE                  9:9
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_AVPCARM7W_LL_RAW_PARTICIPATE_WOFFSET                        0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_AVPCARM7W_LL_RAW_PARTICIPATE_DEFAULT                        _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_AVPCARM7W_LL_RAW_PARTICIPATE_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_AVPCARM7W_LL_RAW_PARTICIPATE_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_AVPCARM7W_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_AVPCARM7W_LL_RAW_PARTICIPATE_INIT_ENUM                      ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_AVPCARM7W_LL_RAW_PARTICIPATE_DISABLE                        _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_AVPCARM7W_LL_RAW_PARTICIPATE_ENABLE                 _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_AVPCARM7W_LL_RAW_PARTICIPATE_DISABLED                       _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_AVPCARM7W_LL_RAW_PARTICIPATE_ENABLED                        _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_FDCDWR_LL_RAW_PARTICIPATE_SHIFT                     _MK_SHIFT_CONST(10)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_FDCDWR_LL_RAW_PARTICIPATE_FIELD                     (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_FDCDWR_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_FDCDWR_LL_RAW_PARTICIPATE_RANGE                     10:10
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_FDCDWR_LL_RAW_PARTICIPATE_WOFFSET                   0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_FDCDWR_LL_RAW_PARTICIPATE_DEFAULT                   _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_FDCDWR_LL_RAW_PARTICIPATE_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_FDCDWR_LL_RAW_PARTICIPATE_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_FDCDWR_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_FDCDWR_LL_RAW_PARTICIPATE_INIT_ENUM                 ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_FDCDWR_LL_RAW_PARTICIPATE_DISABLE                   _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_FDCDWR_LL_RAW_PARTICIPATE_ENABLE                    _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_FDCDWR_LL_RAW_PARTICIPATE_DISABLED                  _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_FDCDWR_LL_RAW_PARTICIPATE_ENABLED                   _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_HOST1XW_LL_RAW_PARTICIPATE_SHIFT                    _MK_SHIFT_CONST(11)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_HOST1XW_LL_RAW_PARTICIPATE_FIELD                    (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_HOST1XW_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_HOST1XW_LL_RAW_PARTICIPATE_RANGE                    11:11
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_HOST1XW_LL_RAW_PARTICIPATE_WOFFSET                  0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_HOST1XW_LL_RAW_PARTICIPATE_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_HOST1XW_LL_RAW_PARTICIPATE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_HOST1XW_LL_RAW_PARTICIPATE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_HOST1XW_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_HOST1XW_LL_RAW_PARTICIPATE_INIT_ENUM                        ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_HOST1XW_LL_RAW_PARTICIPATE_DISABLE                  _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_HOST1XW_LL_RAW_PARTICIPATE_ENABLE                   _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_HOST1XW_LL_RAW_PARTICIPATE_DISABLED                 _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_HOST1XW_LL_RAW_PARTICIPATE_ENABLED                  _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_ISPW_LL_RAW_PARTICIPATE_SHIFT                       _MK_SHIFT_CONST(12)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_ISPW_LL_RAW_PARTICIPATE_FIELD                       (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_ISPW_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_ISPW_LL_RAW_PARTICIPATE_RANGE                       12:12
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_ISPW_LL_RAW_PARTICIPATE_WOFFSET                     0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_ISPW_LL_RAW_PARTICIPATE_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_ISPW_LL_RAW_PARTICIPATE_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_ISPW_LL_RAW_PARTICIPATE_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_ISPW_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_ISPW_LL_RAW_PARTICIPATE_INIT_ENUM                   ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_ISPW_LL_RAW_PARTICIPATE_DISABLE                     _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_ISPW_LL_RAW_PARTICIPATE_ENABLE                      _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_ISPW_LL_RAW_PARTICIPATE_DISABLED                    _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_ISPW_LL_RAW_PARTICIPATE_ENABLED                     _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPCOREW_LL_RAW_PARTICIPATE_SHIFT                    _MK_SHIFT_CONST(13)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPCOREW_LL_RAW_PARTICIPATE_FIELD                    (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPCOREW_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPCOREW_LL_RAW_PARTICIPATE_RANGE                    13:13
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPCOREW_LL_RAW_PARTICIPATE_WOFFSET                  0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPCOREW_LL_RAW_PARTICIPATE_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPCOREW_LL_RAW_PARTICIPATE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPCOREW_LL_RAW_PARTICIPATE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPCOREW_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPCOREW_LL_RAW_PARTICIPATE_INIT_ENUM                        ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPCOREW_LL_RAW_PARTICIPATE_DISABLE                  _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPCOREW_LL_RAW_PARTICIPATE_ENABLE                   _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPCOREW_LL_RAW_PARTICIPATE_DISABLED                 _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPCOREW_LL_RAW_PARTICIPATE_ENABLED                  _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPECSWR_LL_RAW_PARTICIPATE_SHIFT                    _MK_SHIFT_CONST(14)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPECSWR_LL_RAW_PARTICIPATE_FIELD                    (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPECSWR_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPECSWR_LL_RAW_PARTICIPATE_RANGE                    14:14
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPECSWR_LL_RAW_PARTICIPATE_WOFFSET                  0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPECSWR_LL_RAW_PARTICIPATE_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPECSWR_LL_RAW_PARTICIPATE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPECSWR_LL_RAW_PARTICIPATE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPECSWR_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPECSWR_LL_RAW_PARTICIPATE_INIT_ENUM                        ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPECSWR_LL_RAW_PARTICIPATE_DISABLE                  _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPECSWR_LL_RAW_PARTICIPATE_ENABLE                   _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPECSWR_LL_RAW_PARTICIPATE_DISABLED                 _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_MPECSWR_LL_RAW_PARTICIPATE_ENABLED                  _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBDMAW_LL_RAW_PARTICIPATE_SHIFT                        _MK_SHIFT_CONST(15)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBDMAW_LL_RAW_PARTICIPATE_FIELD                        (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBDMAW_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBDMAW_LL_RAW_PARTICIPATE_RANGE                        15:15
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBDMAW_LL_RAW_PARTICIPATE_WOFFSET                      0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBDMAW_LL_RAW_PARTICIPATE_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBDMAW_LL_RAW_PARTICIPATE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBDMAW_LL_RAW_PARTICIPATE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBDMAW_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBDMAW_LL_RAW_PARTICIPATE_INIT_ENUM                    ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBDMAW_LL_RAW_PARTICIPATE_DISABLE                      _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBDMAW_LL_RAW_PARTICIPATE_ENABLE                       _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBDMAW_LL_RAW_PARTICIPATE_DISABLED                     _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBDMAW_LL_RAW_PARTICIPATE_ENABLED                      _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBSLVW_LL_RAW_PARTICIPATE_SHIFT                        _MK_SHIFT_CONST(16)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBSLVW_LL_RAW_PARTICIPATE_FIELD                        (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBSLVW_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBSLVW_LL_RAW_PARTICIPATE_RANGE                        16:16
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBSLVW_LL_RAW_PARTICIPATE_WOFFSET                      0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBSLVW_LL_RAW_PARTICIPATE_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBSLVW_LL_RAW_PARTICIPATE_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBSLVW_LL_RAW_PARTICIPATE_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBSLVW_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBSLVW_LL_RAW_PARTICIPATE_INIT_ENUM                    ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBSLVW_LL_RAW_PARTICIPATE_DISABLE                      _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBSLVW_LL_RAW_PARTICIPATE_ENABLE                       _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBSLVW_LL_RAW_PARTICIPATE_DISABLED                     _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_PPCSAHBSLVW_LL_RAW_PARTICIPATE_ENABLED                      _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEBSEVW_LL_RAW_PARTICIPATE_SHIFT                   _MK_SHIFT_CONST(17)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEBSEVW_LL_RAW_PARTICIPATE_FIELD                   (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEBSEVW_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEBSEVW_LL_RAW_PARTICIPATE_RANGE                   17:17
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEBSEVW_LL_RAW_PARTICIPATE_WOFFSET                 0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEBSEVW_LL_RAW_PARTICIPATE_DEFAULT                 _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEBSEVW_LL_RAW_PARTICIPATE_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEBSEVW_LL_RAW_PARTICIPATE_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEBSEVW_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEBSEVW_LL_RAW_PARTICIPATE_INIT_ENUM                       ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEBSEVW_LL_RAW_PARTICIPATE_DISABLE                 _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEBSEVW_LL_RAW_PARTICIPATE_ENABLE                  _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEBSEVW_LL_RAW_PARTICIPATE_DISABLED                        _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEBSEVW_LL_RAW_PARTICIPATE_ENABLED                 _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEMBEW_LL_RAW_PARTICIPATE_SHIFT                    _MK_SHIFT_CONST(18)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEMBEW_LL_RAW_PARTICIPATE_FIELD                    (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEMBEW_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEMBEW_LL_RAW_PARTICIPATE_RANGE                    18:18
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEMBEW_LL_RAW_PARTICIPATE_WOFFSET                  0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEMBEW_LL_RAW_PARTICIPATE_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEMBEW_LL_RAW_PARTICIPATE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEMBEW_LL_RAW_PARTICIPATE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEMBEW_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEMBEW_LL_RAW_PARTICIPATE_INIT_ENUM                        ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEMBEW_LL_RAW_PARTICIPATE_DISABLE                  _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEMBEW_LL_RAW_PARTICIPATE_ENABLE                   _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEMBEW_LL_RAW_PARTICIPATE_DISABLED                 _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDEMBEW_LL_RAW_PARTICIPATE_ENABLED                  _MK_ENUM_CONST(1)

#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDETPMW_LL_RAW_PARTICIPATE_SHIFT                    _MK_SHIFT_CONST(19)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDETPMW_LL_RAW_PARTICIPATE_FIELD                    (_MK_MASK_CONST(0x1) << MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDETPMW_LL_RAW_PARTICIPATE_SHIFT)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDETPMW_LL_RAW_PARTICIPATE_RANGE                    19:19
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDETPMW_LL_RAW_PARTICIPATE_WOFFSET                  0x0
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDETPMW_LL_RAW_PARTICIPATE_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDETPMW_LL_RAW_PARTICIPATE_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDETPMW_LL_RAW_PARTICIPATE_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDETPMW_LL_RAW_PARTICIPATE_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDETPMW_LL_RAW_PARTICIPATE_INIT_ENUM                        ENABLE
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDETPMW_LL_RAW_PARTICIPATE_DISABLE                  _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDETPMW_LL_RAW_PARTICIPATE_ENABLE                   _MK_ENUM_CONST(1)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDETPMW_LL_RAW_PARTICIPATE_DISABLED                 _MK_ENUM_CONST(0)
#define MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0_VDETPMW_LL_RAW_PARTICIPATE_ENABLED                  _MK_ENUM_CONST(1)

#define MC_CLIENT_BWSHARE_DISABLE       0
#define MC_CLIENT_BWSHARE_ENABLE        1

// Register MC_BWSHARE_TMVAL_0  
#define MC_BWSHARE_TMVAL_0                      _MK_ADDR_CONST(0x114)
#define MC_BWSHARE_TMVAL_0_SECURE                       0x0
#define MC_BWSHARE_TMVAL_0_WORD_COUNT                   0x1
#define MC_BWSHARE_TMVAL_0_RESET_VAL                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_TMVAL_0_RESET_MASK                   _MK_MASK_CONST(0xff)
#define MC_BWSHARE_TMVAL_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_TMVAL_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_TMVAL_0_READ_MASK                    _MK_MASK_CONST(0xff)
#define MC_BWSHARE_TMVAL_0_WRITE_MASK                   _MK_MASK_CONST(0xff)
#define MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR1_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR1_FIELD                 (_MK_MASK_CONST(0xf) << MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR1_SHIFT)
#define MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR1_RANGE                 3:0
#define MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR1_WOFFSET                       0x0
#define MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR1_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR1_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR1_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR1_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR2_SHIFT                 _MK_SHIFT_CONST(4)
#define MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR2_FIELD                 (_MK_MASK_CONST(0xf) << MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR2_SHIFT)
#define MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR2_RANGE                 7:4
#define MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR2_WOFFSET                       0x0
#define MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR2_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR2_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR2_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_TMVAL_0_BW_TM_SFACTOR2_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Reserved address 280 [0x118] 

// Reserved address 284 [0x11c] 

// Register MC_BWSHARE_EMEM_CTRL_0_0  
#define MC_BWSHARE_EMEM_CTRL_0_0                        _MK_ADDR_CONST(0x120)
#define MC_BWSHARE_EMEM_CTRL_0_0_SECURE                         0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_WORD_COUNT                     0x1
#define MC_BWSHARE_EMEM_CTRL_0_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_RESET_MASK                     _MK_MASK_CONST(0xffffffff)
#define MC_BWSHARE_EMEM_CTRL_0_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_READ_MASK                      _MK_MASK_CONST(0xffffffff)
#define MC_BWSHARE_EMEM_CTRL_0_0_WRITE_MASK                     _MK_MASK_CONST(0xffffffff)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0A_BW_EMEM_SHIFT                        _MK_SHIFT_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0A_BW_EMEM_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0A_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0A_BW_EMEM_RANGE                        0:0
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0A_BW_EMEM_WOFFSET                      0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0A_BW_EMEM_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0A_BW_EMEM_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0A_BW_EMEM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0A_BW_EMEM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0A_BW_EMEM_INIT_ENUM                    DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0A_BW_EMEM_DISABLE                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0A_BW_EMEM_ENABLE                       _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0A_BW_EMEM_DISABLED                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0A_BW_EMEM_ENABLED                      _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0AB_BW_EMEM_SHIFT                       _MK_SHIFT_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0AB_BW_EMEM_FIELD                       (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0AB_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0AB_BW_EMEM_RANGE                       1:1
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0AB_BW_EMEM_WOFFSET                     0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0AB_BW_EMEM_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0AB_BW_EMEM_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0AB_BW_EMEM_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0AB_BW_EMEM_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0AB_BW_EMEM_INIT_ENUM                   DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0AB_BW_EMEM_DISABLE                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0AB_BW_EMEM_ENABLE                      _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0AB_BW_EMEM_DISABLED                    _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0AB_BW_EMEM_ENABLED                     _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0B_BW_EMEM_SHIFT                        _MK_SHIFT_CONST(2)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0B_BW_EMEM_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0B_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0B_BW_EMEM_RANGE                        2:2
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0B_BW_EMEM_WOFFSET                      0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0B_BW_EMEM_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0B_BW_EMEM_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0B_BW_EMEM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0B_BW_EMEM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0B_BW_EMEM_INIT_ENUM                    DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0B_BW_EMEM_DISABLE                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0B_BW_EMEM_ENABLE                       _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0B_BW_EMEM_DISABLED                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0B_BW_EMEM_ENABLED                      _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0BB_BW_EMEM_SHIFT                       _MK_SHIFT_CONST(3)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0BB_BW_EMEM_FIELD                       (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0BB_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0BB_BW_EMEM_RANGE                       3:3
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0BB_BW_EMEM_WOFFSET                     0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0BB_BW_EMEM_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0BB_BW_EMEM_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0BB_BW_EMEM_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0BB_BW_EMEM_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0BB_BW_EMEM_INIT_ENUM                   DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0BB_BW_EMEM_DISABLE                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0BB_BW_EMEM_ENABLE                      _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0BB_BW_EMEM_DISABLED                    _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0BB_BW_EMEM_ENABLED                     _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0C_BW_EMEM_SHIFT                        _MK_SHIFT_CONST(4)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0C_BW_EMEM_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0C_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0C_BW_EMEM_RANGE                        4:4
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0C_BW_EMEM_WOFFSET                      0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0C_BW_EMEM_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0C_BW_EMEM_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0C_BW_EMEM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0C_BW_EMEM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0C_BW_EMEM_INIT_ENUM                    DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0C_BW_EMEM_DISABLE                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0C_BW_EMEM_ENABLE                       _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0C_BW_EMEM_DISABLED                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0C_BW_EMEM_ENABLED                      _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0CB_BW_EMEM_SHIFT                       _MK_SHIFT_CONST(5)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0CB_BW_EMEM_FIELD                       (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0CB_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0CB_BW_EMEM_RANGE                       5:5
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0CB_BW_EMEM_WOFFSET                     0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0CB_BW_EMEM_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0CB_BW_EMEM_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0CB_BW_EMEM_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0CB_BW_EMEM_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0CB_BW_EMEM_INIT_ENUM                   DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0CB_BW_EMEM_DISABLE                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0CB_BW_EMEM_ENABLE                      _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0CB_BW_EMEM_DISABLED                    _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY0CB_BW_EMEM_ENABLED                     _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1B_BW_EMEM_SHIFT                        _MK_SHIFT_CONST(6)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1B_BW_EMEM_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1B_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1B_BW_EMEM_RANGE                        6:6
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1B_BW_EMEM_WOFFSET                      0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1B_BW_EMEM_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1B_BW_EMEM_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1B_BW_EMEM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1B_BW_EMEM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1B_BW_EMEM_INIT_ENUM                    DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1B_BW_EMEM_DISABLE                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1B_BW_EMEM_ENABLE                       _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1B_BW_EMEM_DISABLED                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1B_BW_EMEM_ENABLED                      _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1BB_BW_EMEM_SHIFT                       _MK_SHIFT_CONST(7)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1BB_BW_EMEM_FIELD                       (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1BB_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1BB_BW_EMEM_RANGE                       7:7
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1BB_BW_EMEM_WOFFSET                     0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1BB_BW_EMEM_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1BB_BW_EMEM_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1BB_BW_EMEM_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1BB_BW_EMEM_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1BB_BW_EMEM_INIT_ENUM                   DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1BB_BW_EMEM_DISABLE                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1BB_BW_EMEM_ENABLE                      _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1BB_BW_EMEM_DISABLED                    _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAY1BB_BW_EMEM_ENABLED                     _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_EPPUP_BW_EMEM_SHIFT                    _MK_SHIFT_CONST(8)
#define MC_BWSHARE_EMEM_CTRL_0_0_EPPUP_BW_EMEM_FIELD                    (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_EPPUP_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_EPPUP_BW_EMEM_RANGE                    8:8
#define MC_BWSHARE_EMEM_CTRL_0_0_EPPUP_BW_EMEM_WOFFSET                  0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_EPPUP_BW_EMEM_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_EPPUP_BW_EMEM_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_EPPUP_BW_EMEM_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_EPPUP_BW_EMEM_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_EPPUP_BW_EMEM_INIT_ENUM                        DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_EPPUP_BW_EMEM_DISABLE                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_EPPUP_BW_EMEM_ENABLE                   _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_EPPUP_BW_EMEM_DISABLED                 _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_EPPUP_BW_EMEM_ENABLED                  _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_G2PR_BW_EMEM_SHIFT                     _MK_SHIFT_CONST(9)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2PR_BW_EMEM_FIELD                     (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_G2PR_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2PR_BW_EMEM_RANGE                     9:9
#define MC_BWSHARE_EMEM_CTRL_0_0_G2PR_BW_EMEM_WOFFSET                   0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_G2PR_BW_EMEM_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2PR_BW_EMEM_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2PR_BW_EMEM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2PR_BW_EMEM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2PR_BW_EMEM_INIT_ENUM                 DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_G2PR_BW_EMEM_DISABLE                   _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2PR_BW_EMEM_ENABLE                    _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2PR_BW_EMEM_DISABLED                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2PR_BW_EMEM_ENABLED                   _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_G2SR_BW_EMEM_SHIFT                     _MK_SHIFT_CONST(10)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2SR_BW_EMEM_FIELD                     (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_G2SR_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2SR_BW_EMEM_RANGE                     10:10
#define MC_BWSHARE_EMEM_CTRL_0_0_G2SR_BW_EMEM_WOFFSET                   0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_G2SR_BW_EMEM_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2SR_BW_EMEM_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2SR_BW_EMEM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2SR_BW_EMEM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2SR_BW_EMEM_INIT_ENUM                 DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_G2SR_BW_EMEM_DISABLE                   _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2SR_BW_EMEM_ENABLE                    _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2SR_BW_EMEM_DISABLED                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2SR_BW_EMEM_ENABLED                   _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_MPEUNIFBR_BW_EMEM_SHIFT                        _MK_SHIFT_CONST(11)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEUNIFBR_BW_EMEM_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_MPEUNIFBR_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEUNIFBR_BW_EMEM_RANGE                        11:11
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEUNIFBR_BW_EMEM_WOFFSET                      0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEUNIFBR_BW_EMEM_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEUNIFBR_BW_EMEM_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEUNIFBR_BW_EMEM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEUNIFBR_BW_EMEM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEUNIFBR_BW_EMEM_INIT_ENUM                    DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEUNIFBR_BW_EMEM_DISABLE                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEUNIFBR_BW_EMEM_ENABLE                       _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEUNIFBR_BW_EMEM_DISABLED                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEUNIFBR_BW_EMEM_ENABLED                      _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_VIRUV_BW_EMEM_SHIFT                    _MK_SHIFT_CONST(12)
#define MC_BWSHARE_EMEM_CTRL_0_0_VIRUV_BW_EMEM_FIELD                    (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_VIRUV_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_VIRUV_BW_EMEM_RANGE                    12:12
#define MC_BWSHARE_EMEM_CTRL_0_0_VIRUV_BW_EMEM_WOFFSET                  0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_VIRUV_BW_EMEM_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VIRUV_BW_EMEM_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_VIRUV_BW_EMEM_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VIRUV_BW_EMEM_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VIRUV_BW_EMEM_INIT_ENUM                        DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_VIRUV_BW_EMEM_DISABLE                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VIRUV_BW_EMEM_ENABLE                   _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_VIRUV_BW_EMEM_DISABLED                 _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VIRUV_BW_EMEM_ENABLED                  _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_AVPCARM7R_BW_EMEM_SHIFT                        _MK_SHIFT_CONST(13)
#define MC_BWSHARE_EMEM_CTRL_0_0_AVPCARM7R_BW_EMEM_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_AVPCARM7R_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_AVPCARM7R_BW_EMEM_RANGE                        13:13
#define MC_BWSHARE_EMEM_CTRL_0_0_AVPCARM7R_BW_EMEM_WOFFSET                      0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_AVPCARM7R_BW_EMEM_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_AVPCARM7R_BW_EMEM_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_AVPCARM7R_BW_EMEM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_AVPCARM7R_BW_EMEM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_AVPCARM7R_BW_EMEM_INIT_ENUM                    DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_AVPCARM7R_BW_EMEM_DISABLE                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_AVPCARM7R_BW_EMEM_ENABLE                       _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_AVPCARM7R_BW_EMEM_DISABLED                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_AVPCARM7R_BW_EMEM_ENABLED                      _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHC_BW_EMEM_SHIFT                        _MK_SHIFT_CONST(14)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHC_BW_EMEM_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHC_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHC_BW_EMEM_RANGE                        14:14
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHC_BW_EMEM_WOFFSET                      0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHC_BW_EMEM_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHC_BW_EMEM_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHC_BW_EMEM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHC_BW_EMEM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHC_BW_EMEM_INIT_ENUM                    DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHC_BW_EMEM_DISABLE                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHC_BW_EMEM_ENABLE                       _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHC_BW_EMEM_DISABLED                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHC_BW_EMEM_ENABLED                      _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHCB_BW_EMEM_SHIFT                       _MK_SHIFT_CONST(15)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHCB_BW_EMEM_FIELD                       (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHCB_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHCB_BW_EMEM_RANGE                       15:15
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHCB_BW_EMEM_WOFFSET                     0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHCB_BW_EMEM_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHCB_BW_EMEM_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHCB_BW_EMEM_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHCB_BW_EMEM_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHCB_BW_EMEM_INIT_ENUM                   DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHCB_BW_EMEM_DISABLE                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHCB_BW_EMEM_ENABLE                      _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHCB_BW_EMEM_DISABLED                    _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_DISPLAYHCB_BW_EMEM_ENABLED                     _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_FDCDRD_BW_EMEM_SHIFT                   _MK_SHIFT_CONST(16)
#define MC_BWSHARE_EMEM_CTRL_0_0_FDCDRD_BW_EMEM_FIELD                   (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_FDCDRD_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_FDCDRD_BW_EMEM_RANGE                   16:16
#define MC_BWSHARE_EMEM_CTRL_0_0_FDCDRD_BW_EMEM_WOFFSET                 0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_FDCDRD_BW_EMEM_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_FDCDRD_BW_EMEM_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_FDCDRD_BW_EMEM_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_FDCDRD_BW_EMEM_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_FDCDRD_BW_EMEM_INIT_ENUM                       DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_FDCDRD_BW_EMEM_DISABLE                 _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_FDCDRD_BW_EMEM_ENABLE                  _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_FDCDRD_BW_EMEM_DISABLED                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_FDCDRD_BW_EMEM_ENABLED                 _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_G2DR_BW_EMEM_SHIFT                     _MK_SHIFT_CONST(17)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2DR_BW_EMEM_FIELD                     (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_G2DR_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2DR_BW_EMEM_RANGE                     17:17
#define MC_BWSHARE_EMEM_CTRL_0_0_G2DR_BW_EMEM_WOFFSET                   0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_G2DR_BW_EMEM_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2DR_BW_EMEM_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2DR_BW_EMEM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2DR_BW_EMEM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2DR_BW_EMEM_INIT_ENUM                 DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_G2DR_BW_EMEM_DISABLE                   _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2DR_BW_EMEM_ENABLE                    _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2DR_BW_EMEM_DISABLED                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_G2DR_BW_EMEM_ENABLED                   _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XDMAR_BW_EMEM_SHIFT                       _MK_SHIFT_CONST(18)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XDMAR_BW_EMEM_FIELD                       (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_HOST1XDMAR_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XDMAR_BW_EMEM_RANGE                       18:18
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XDMAR_BW_EMEM_WOFFSET                     0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XDMAR_BW_EMEM_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XDMAR_BW_EMEM_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XDMAR_BW_EMEM_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XDMAR_BW_EMEM_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XDMAR_BW_EMEM_INIT_ENUM                   DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XDMAR_BW_EMEM_DISABLE                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XDMAR_BW_EMEM_ENABLE                      _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XDMAR_BW_EMEM_DISABLED                    _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XDMAR_BW_EMEM_ENABLED                     _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XR_BW_EMEM_SHIFT                  _MK_SHIFT_CONST(19)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XR_BW_EMEM_FIELD                  (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_HOST1XR_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XR_BW_EMEM_RANGE                  19:19
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XR_BW_EMEM_WOFFSET                        0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XR_BW_EMEM_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XR_BW_EMEM_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XR_BW_EMEM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XR_BW_EMEM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XR_BW_EMEM_INIT_ENUM                      DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XR_BW_EMEM_DISABLE                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XR_BW_EMEM_ENABLE                 _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XR_BW_EMEM_DISABLED                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_HOST1XR_BW_EMEM_ENABLED                        _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_IDXSRD_BW_EMEM_SHIFT                   _MK_SHIFT_CONST(20)
#define MC_BWSHARE_EMEM_CTRL_0_0_IDXSRD_BW_EMEM_FIELD                   (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_IDXSRD_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_IDXSRD_BW_EMEM_RANGE                   20:20
#define MC_BWSHARE_EMEM_CTRL_0_0_IDXSRD_BW_EMEM_WOFFSET                 0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_IDXSRD_BW_EMEM_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_IDXSRD_BW_EMEM_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_IDXSRD_BW_EMEM_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_IDXSRD_BW_EMEM_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_IDXSRD_BW_EMEM_INIT_ENUM                       DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_IDXSRD_BW_EMEM_DISABLE                 _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_IDXSRD_BW_EMEM_ENABLE                  _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_IDXSRD_BW_EMEM_DISABLED                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_IDXSRD_BW_EMEM_ENABLED                 _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_MPCORER_BW_EMEM_SHIFT                  _MK_SHIFT_CONST(21)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPCORER_BW_EMEM_FIELD                  (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_MPCORER_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPCORER_BW_EMEM_RANGE                  21:21
#define MC_BWSHARE_EMEM_CTRL_0_0_MPCORER_BW_EMEM_WOFFSET                        0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_MPCORER_BW_EMEM_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPCORER_BW_EMEM_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPCORER_BW_EMEM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPCORER_BW_EMEM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPCORER_BW_EMEM_INIT_ENUM                      DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_MPCORER_BW_EMEM_DISABLE                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPCORER_BW_EMEM_ENABLE                 _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPCORER_BW_EMEM_DISABLED                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPCORER_BW_EMEM_ENABLED                        _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_MPE_IPRED_BW_EMEM_SHIFT                        _MK_SHIFT_CONST(22)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPE_IPRED_BW_EMEM_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_MPE_IPRED_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPE_IPRED_BW_EMEM_RANGE                        22:22
#define MC_BWSHARE_EMEM_CTRL_0_0_MPE_IPRED_BW_EMEM_WOFFSET                      0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_MPE_IPRED_BW_EMEM_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPE_IPRED_BW_EMEM_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPE_IPRED_BW_EMEM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPE_IPRED_BW_EMEM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPE_IPRED_BW_EMEM_INIT_ENUM                    DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_MPE_IPRED_BW_EMEM_DISABLE                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPE_IPRED_BW_EMEM_ENABLE                       _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPE_IPRED_BW_EMEM_DISABLED                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPE_IPRED_BW_EMEM_ENABLED                      _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_MPEAMEMRD_BW_EMEM_SHIFT                        _MK_SHIFT_CONST(23)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEAMEMRD_BW_EMEM_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_MPEAMEMRD_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEAMEMRD_BW_EMEM_RANGE                        23:23
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEAMEMRD_BW_EMEM_WOFFSET                      0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEAMEMRD_BW_EMEM_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEAMEMRD_BW_EMEM_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEAMEMRD_BW_EMEM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEAMEMRD_BW_EMEM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEAMEMRD_BW_EMEM_INIT_ENUM                    DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEAMEMRD_BW_EMEM_DISABLE                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEAMEMRD_BW_EMEM_ENABLE                       _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEAMEMRD_BW_EMEM_DISABLED                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPEAMEMRD_BW_EMEM_ENABLED                      _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_MPECSRD_BW_EMEM_SHIFT                  _MK_SHIFT_CONST(24)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPECSRD_BW_EMEM_FIELD                  (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_MPECSRD_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPECSRD_BW_EMEM_RANGE                  24:24
#define MC_BWSHARE_EMEM_CTRL_0_0_MPECSRD_BW_EMEM_WOFFSET                        0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_MPECSRD_BW_EMEM_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPECSRD_BW_EMEM_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPECSRD_BW_EMEM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPECSRD_BW_EMEM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPECSRD_BW_EMEM_INIT_ENUM                      DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_MPECSRD_BW_EMEM_DISABLE                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPECSRD_BW_EMEM_ENABLE                 _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPECSRD_BW_EMEM_DISABLED                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_MPECSRD_BW_EMEM_ENABLED                        _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBDMAR_BW_EMEM_SHIFT                      _MK_SHIFT_CONST(25)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBDMAR_BW_EMEM_FIELD                      (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBDMAR_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBDMAR_BW_EMEM_RANGE                      25:25
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBDMAR_BW_EMEM_WOFFSET                    0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBDMAR_BW_EMEM_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBDMAR_BW_EMEM_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBDMAR_BW_EMEM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBDMAR_BW_EMEM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBDMAR_BW_EMEM_INIT_ENUM                  DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBDMAR_BW_EMEM_DISABLE                    _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBDMAR_BW_EMEM_ENABLE                     _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBDMAR_BW_EMEM_DISABLED                   _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBDMAR_BW_EMEM_ENABLED                    _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBSLVR_BW_EMEM_SHIFT                      _MK_SHIFT_CONST(26)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBSLVR_BW_EMEM_FIELD                      (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBSLVR_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBSLVR_BW_EMEM_RANGE                      26:26
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBSLVR_BW_EMEM_WOFFSET                    0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBSLVR_BW_EMEM_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBSLVR_BW_EMEM_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBSLVR_BW_EMEM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBSLVR_BW_EMEM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBSLVR_BW_EMEM_INIT_ENUM                  DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBSLVR_BW_EMEM_DISABLE                    _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBSLVR_BW_EMEM_ENABLE                     _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBSLVR_BW_EMEM_DISABLED                   _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_PPCSAHBSLVR_BW_EMEM_ENABLED                    _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_TEXSRD_BW_EMEM_SHIFT                   _MK_SHIFT_CONST(27)
#define MC_BWSHARE_EMEM_CTRL_0_0_TEXSRD_BW_EMEM_FIELD                   (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_TEXSRD_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_TEXSRD_BW_EMEM_RANGE                   27:27
#define MC_BWSHARE_EMEM_CTRL_0_0_TEXSRD_BW_EMEM_WOFFSET                 0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_TEXSRD_BW_EMEM_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_TEXSRD_BW_EMEM_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_TEXSRD_BW_EMEM_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_TEXSRD_BW_EMEM_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_TEXSRD_BW_EMEM_INIT_ENUM                       DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_TEXSRD_BW_EMEM_DISABLE                 _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_TEXSRD_BW_EMEM_ENABLE                  _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_TEXSRD_BW_EMEM_DISABLED                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_TEXSRD_BW_EMEM_ENABLED                 _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_VDEBSEVR_BW_EMEM_SHIFT                 _MK_SHIFT_CONST(28)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEBSEVR_BW_EMEM_FIELD                 (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_VDEBSEVR_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEBSEVR_BW_EMEM_RANGE                 28:28
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEBSEVR_BW_EMEM_WOFFSET                       0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEBSEVR_BW_EMEM_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEBSEVR_BW_EMEM_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEBSEVR_BW_EMEM_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEBSEVR_BW_EMEM_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEBSEVR_BW_EMEM_INIT_ENUM                     DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEBSEVR_BW_EMEM_DISABLE                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEBSEVR_BW_EMEM_ENABLE                        _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEBSEVR_BW_EMEM_DISABLED                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEBSEVR_BW_EMEM_ENABLED                       _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMBER_BW_EMEM_SHIFT                  _MK_SHIFT_CONST(29)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMBER_BW_EMEM_FIELD                  (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_VDEMBER_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMBER_BW_EMEM_RANGE                  29:29
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMBER_BW_EMEM_WOFFSET                        0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMBER_BW_EMEM_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMBER_BW_EMEM_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMBER_BW_EMEM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMBER_BW_EMEM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMBER_BW_EMEM_INIT_ENUM                      DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMBER_BW_EMEM_DISABLE                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMBER_BW_EMEM_ENABLE                 _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMBER_BW_EMEM_DISABLED                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMBER_BW_EMEM_ENABLED                        _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMCER_BW_EMEM_SHIFT                  _MK_SHIFT_CONST(30)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMCER_BW_EMEM_FIELD                  (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_VDEMCER_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMCER_BW_EMEM_RANGE                  30:30
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMCER_BW_EMEM_WOFFSET                        0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMCER_BW_EMEM_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMCER_BW_EMEM_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMCER_BW_EMEM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMCER_BW_EMEM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMCER_BW_EMEM_INIT_ENUM                      DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMCER_BW_EMEM_DISABLE                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMCER_BW_EMEM_ENABLE                 _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMCER_BW_EMEM_DISABLED                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDEMCER_BW_EMEM_ENABLED                        _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_0_0_VDETPER_BW_EMEM_SHIFT                  _MK_SHIFT_CONST(31)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDETPER_BW_EMEM_FIELD                  (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_0_0_VDETPER_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDETPER_BW_EMEM_RANGE                  31:31
#define MC_BWSHARE_EMEM_CTRL_0_0_VDETPER_BW_EMEM_WOFFSET                        0x0
#define MC_BWSHARE_EMEM_CTRL_0_0_VDETPER_BW_EMEM_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDETPER_BW_EMEM_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDETPER_BW_EMEM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDETPER_BW_EMEM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDETPER_BW_EMEM_INIT_ENUM                      DISABLE
#define MC_BWSHARE_EMEM_CTRL_0_0_VDETPER_BW_EMEM_DISABLE                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDETPER_BW_EMEM_ENABLE                 _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDETPER_BW_EMEM_DISABLED                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_0_0_VDETPER_BW_EMEM_ENABLED                        _MK_ENUM_CONST(1)


// Register MC_BWSHARE_EMEM_CTRL_1_0  
#define MC_BWSHARE_EMEM_CTRL_1_0                        _MK_ADDR_CONST(0x124)
#define MC_BWSHARE_EMEM_CTRL_1_0_SECURE                         0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_WORD_COUNT                     0x1
#define MC_BWSHARE_EMEM_CTRL_1_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_RESET_MASK                     _MK_MASK_CONST(0xfffff)
#define MC_BWSHARE_EMEM_CTRL_1_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_READ_MASK                      _MK_MASK_CONST(0xfffff)
#define MC_BWSHARE_EMEM_CTRL_1_0_WRITE_MASK                     _MK_MASK_CONST(0xfffff)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPU_BW_EMEM_SHIFT                     _MK_SHIFT_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPU_BW_EMEM_FIELD                     (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_EPPU_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPU_BW_EMEM_RANGE                     0:0
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPU_BW_EMEM_WOFFSET                   0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPU_BW_EMEM_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPU_BW_EMEM_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPU_BW_EMEM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPU_BW_EMEM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPU_BW_EMEM_INIT_ENUM                 DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPU_BW_EMEM_DISABLE                   _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPU_BW_EMEM_ENABLE                    _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPU_BW_EMEM_DISABLED                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPU_BW_EMEM_ENABLED                   _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_EPPV_BW_EMEM_SHIFT                     _MK_SHIFT_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPV_BW_EMEM_FIELD                     (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_EPPV_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPV_BW_EMEM_RANGE                     1:1
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPV_BW_EMEM_WOFFSET                   0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPV_BW_EMEM_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPV_BW_EMEM_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPV_BW_EMEM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPV_BW_EMEM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPV_BW_EMEM_INIT_ENUM                 DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPV_BW_EMEM_DISABLE                   _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPV_BW_EMEM_ENABLE                    _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPV_BW_EMEM_DISABLED                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPV_BW_EMEM_ENABLED                   _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_EPPY_BW_EMEM_SHIFT                     _MK_SHIFT_CONST(2)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPY_BW_EMEM_FIELD                     (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_EPPY_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPY_BW_EMEM_RANGE                     2:2
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPY_BW_EMEM_WOFFSET                   0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPY_BW_EMEM_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPY_BW_EMEM_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPY_BW_EMEM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPY_BW_EMEM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPY_BW_EMEM_INIT_ENUM                 DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPY_BW_EMEM_DISABLE                   _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPY_BW_EMEM_ENABLE                    _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPY_BW_EMEM_DISABLED                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_EPPY_BW_EMEM_ENABLED                   _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_MPEUNIFBW_BW_EMEM_SHIFT                        _MK_SHIFT_CONST(3)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPEUNIFBW_BW_EMEM_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_MPEUNIFBW_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPEUNIFBW_BW_EMEM_RANGE                        3:3
#define MC_BWSHARE_EMEM_CTRL_1_0_MPEUNIFBW_BW_EMEM_WOFFSET                      0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_MPEUNIFBW_BW_EMEM_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPEUNIFBW_BW_EMEM_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPEUNIFBW_BW_EMEM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPEUNIFBW_BW_EMEM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPEUNIFBW_BW_EMEM_INIT_ENUM                    DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_MPEUNIFBW_BW_EMEM_DISABLE                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPEUNIFBW_BW_EMEM_ENABLE                       _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPEUNIFBW_BW_EMEM_DISABLED                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPEUNIFBW_BW_EMEM_ENABLED                      _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_VIWSB_BW_EMEM_SHIFT                    _MK_SHIFT_CONST(4)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWSB_BW_EMEM_FIELD                    (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_VIWSB_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWSB_BW_EMEM_RANGE                    4:4
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWSB_BW_EMEM_WOFFSET                  0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWSB_BW_EMEM_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWSB_BW_EMEM_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWSB_BW_EMEM_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWSB_BW_EMEM_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWSB_BW_EMEM_INIT_ENUM                        DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWSB_BW_EMEM_DISABLE                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWSB_BW_EMEM_ENABLE                   _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWSB_BW_EMEM_DISABLED                 _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWSB_BW_EMEM_ENABLED                  _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_VIWU_BW_EMEM_SHIFT                     _MK_SHIFT_CONST(5)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWU_BW_EMEM_FIELD                     (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_VIWU_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWU_BW_EMEM_RANGE                     5:5
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWU_BW_EMEM_WOFFSET                   0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWU_BW_EMEM_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWU_BW_EMEM_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWU_BW_EMEM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWU_BW_EMEM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWU_BW_EMEM_INIT_ENUM                 DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWU_BW_EMEM_DISABLE                   _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWU_BW_EMEM_ENABLE                    _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWU_BW_EMEM_DISABLED                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWU_BW_EMEM_ENABLED                   _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_VIWV_BW_EMEM_SHIFT                     _MK_SHIFT_CONST(6)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWV_BW_EMEM_FIELD                     (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_VIWV_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWV_BW_EMEM_RANGE                     6:6
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWV_BW_EMEM_WOFFSET                   0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWV_BW_EMEM_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWV_BW_EMEM_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWV_BW_EMEM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWV_BW_EMEM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWV_BW_EMEM_INIT_ENUM                 DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWV_BW_EMEM_DISABLE                   _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWV_BW_EMEM_ENABLE                    _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWV_BW_EMEM_DISABLED                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWV_BW_EMEM_ENABLED                   _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_VIWY_BW_EMEM_SHIFT                     _MK_SHIFT_CONST(7)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWY_BW_EMEM_FIELD                     (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_VIWY_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWY_BW_EMEM_RANGE                     7:7
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWY_BW_EMEM_WOFFSET                   0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWY_BW_EMEM_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWY_BW_EMEM_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWY_BW_EMEM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWY_BW_EMEM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWY_BW_EMEM_INIT_ENUM                 DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWY_BW_EMEM_DISABLE                   _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWY_BW_EMEM_ENABLE                    _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWY_BW_EMEM_DISABLED                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VIWY_BW_EMEM_ENABLED                   _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_G2DW_BW_EMEM_SHIFT                     _MK_SHIFT_CONST(8)
#define MC_BWSHARE_EMEM_CTRL_1_0_G2DW_BW_EMEM_FIELD                     (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_G2DW_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_G2DW_BW_EMEM_RANGE                     8:8
#define MC_BWSHARE_EMEM_CTRL_1_0_G2DW_BW_EMEM_WOFFSET                   0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_G2DW_BW_EMEM_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_G2DW_BW_EMEM_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_G2DW_BW_EMEM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_G2DW_BW_EMEM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_G2DW_BW_EMEM_INIT_ENUM                 DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_G2DW_BW_EMEM_DISABLE                   _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_G2DW_BW_EMEM_ENABLE                    _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_G2DW_BW_EMEM_DISABLED                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_G2DW_BW_EMEM_ENABLED                   _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_AVPCARM7W_BW_EMEM_SHIFT                        _MK_SHIFT_CONST(9)
#define MC_BWSHARE_EMEM_CTRL_1_0_AVPCARM7W_BW_EMEM_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_AVPCARM7W_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_AVPCARM7W_BW_EMEM_RANGE                        9:9
#define MC_BWSHARE_EMEM_CTRL_1_0_AVPCARM7W_BW_EMEM_WOFFSET                      0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_AVPCARM7W_BW_EMEM_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_AVPCARM7W_BW_EMEM_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_AVPCARM7W_BW_EMEM_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_AVPCARM7W_BW_EMEM_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_AVPCARM7W_BW_EMEM_INIT_ENUM                    DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_AVPCARM7W_BW_EMEM_DISABLE                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_AVPCARM7W_BW_EMEM_ENABLE                       _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_AVPCARM7W_BW_EMEM_DISABLED                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_AVPCARM7W_BW_EMEM_ENABLED                      _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_FDCDWR_BW_EMEM_SHIFT                   _MK_SHIFT_CONST(10)
#define MC_BWSHARE_EMEM_CTRL_1_0_FDCDWR_BW_EMEM_FIELD                   (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_FDCDWR_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_FDCDWR_BW_EMEM_RANGE                   10:10
#define MC_BWSHARE_EMEM_CTRL_1_0_FDCDWR_BW_EMEM_WOFFSET                 0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_FDCDWR_BW_EMEM_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_FDCDWR_BW_EMEM_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_FDCDWR_BW_EMEM_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_FDCDWR_BW_EMEM_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_FDCDWR_BW_EMEM_INIT_ENUM                       DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_FDCDWR_BW_EMEM_DISABLE                 _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_FDCDWR_BW_EMEM_ENABLE                  _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_FDCDWR_BW_EMEM_DISABLED                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_FDCDWR_BW_EMEM_ENABLED                 _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_HOST1XW_BW_EMEM_SHIFT                  _MK_SHIFT_CONST(11)
#define MC_BWSHARE_EMEM_CTRL_1_0_HOST1XW_BW_EMEM_FIELD                  (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_HOST1XW_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_HOST1XW_BW_EMEM_RANGE                  11:11
#define MC_BWSHARE_EMEM_CTRL_1_0_HOST1XW_BW_EMEM_WOFFSET                        0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_HOST1XW_BW_EMEM_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_HOST1XW_BW_EMEM_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_HOST1XW_BW_EMEM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_HOST1XW_BW_EMEM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_HOST1XW_BW_EMEM_INIT_ENUM                      DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_HOST1XW_BW_EMEM_DISABLE                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_HOST1XW_BW_EMEM_ENABLE                 _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_HOST1XW_BW_EMEM_DISABLED                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_HOST1XW_BW_EMEM_ENABLED                        _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_ISPW_BW_EMEM_SHIFT                     _MK_SHIFT_CONST(12)
#define MC_BWSHARE_EMEM_CTRL_1_0_ISPW_BW_EMEM_FIELD                     (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_ISPW_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_ISPW_BW_EMEM_RANGE                     12:12
#define MC_BWSHARE_EMEM_CTRL_1_0_ISPW_BW_EMEM_WOFFSET                   0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_ISPW_BW_EMEM_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_ISPW_BW_EMEM_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_ISPW_BW_EMEM_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_ISPW_BW_EMEM_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_ISPW_BW_EMEM_INIT_ENUM                 DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_ISPW_BW_EMEM_DISABLE                   _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_ISPW_BW_EMEM_ENABLE                    _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_ISPW_BW_EMEM_DISABLED                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_ISPW_BW_EMEM_ENABLED                   _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_MPCOREW_BW_EMEM_SHIFT                  _MK_SHIFT_CONST(13)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPCOREW_BW_EMEM_FIELD                  (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_MPCOREW_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPCOREW_BW_EMEM_RANGE                  13:13
#define MC_BWSHARE_EMEM_CTRL_1_0_MPCOREW_BW_EMEM_WOFFSET                        0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_MPCOREW_BW_EMEM_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPCOREW_BW_EMEM_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPCOREW_BW_EMEM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPCOREW_BW_EMEM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPCOREW_BW_EMEM_INIT_ENUM                      DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_MPCOREW_BW_EMEM_DISABLE                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPCOREW_BW_EMEM_ENABLE                 _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPCOREW_BW_EMEM_DISABLED                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPCOREW_BW_EMEM_ENABLED                        _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_MPECSWR_BW_EMEM_SHIFT                  _MK_SHIFT_CONST(14)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPECSWR_BW_EMEM_FIELD                  (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_MPECSWR_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPECSWR_BW_EMEM_RANGE                  14:14
#define MC_BWSHARE_EMEM_CTRL_1_0_MPECSWR_BW_EMEM_WOFFSET                        0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_MPECSWR_BW_EMEM_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPECSWR_BW_EMEM_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPECSWR_BW_EMEM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPECSWR_BW_EMEM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPECSWR_BW_EMEM_INIT_ENUM                      DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_MPECSWR_BW_EMEM_DISABLE                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPECSWR_BW_EMEM_ENABLE                 _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPECSWR_BW_EMEM_DISABLED                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_MPECSWR_BW_EMEM_ENABLED                        _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBDMAW_BW_EMEM_SHIFT                      _MK_SHIFT_CONST(15)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBDMAW_BW_EMEM_FIELD                      (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBDMAW_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBDMAW_BW_EMEM_RANGE                      15:15
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBDMAW_BW_EMEM_WOFFSET                    0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBDMAW_BW_EMEM_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBDMAW_BW_EMEM_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBDMAW_BW_EMEM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBDMAW_BW_EMEM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBDMAW_BW_EMEM_INIT_ENUM                  DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBDMAW_BW_EMEM_DISABLE                    _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBDMAW_BW_EMEM_ENABLE                     _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBDMAW_BW_EMEM_DISABLED                   _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBDMAW_BW_EMEM_ENABLED                    _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBSLVW_BW_EMEM_SHIFT                      _MK_SHIFT_CONST(16)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBSLVW_BW_EMEM_FIELD                      (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBSLVW_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBSLVW_BW_EMEM_RANGE                      16:16
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBSLVW_BW_EMEM_WOFFSET                    0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBSLVW_BW_EMEM_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBSLVW_BW_EMEM_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBSLVW_BW_EMEM_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBSLVW_BW_EMEM_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBSLVW_BW_EMEM_INIT_ENUM                  DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBSLVW_BW_EMEM_DISABLE                    _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBSLVW_BW_EMEM_ENABLE                     _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBSLVW_BW_EMEM_DISABLED                   _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_PPCSAHBSLVW_BW_EMEM_ENABLED                    _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_VDEBSEVW_BW_EMEM_SHIFT                 _MK_SHIFT_CONST(17)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEBSEVW_BW_EMEM_FIELD                 (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_VDEBSEVW_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEBSEVW_BW_EMEM_RANGE                 17:17
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEBSEVW_BW_EMEM_WOFFSET                       0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEBSEVW_BW_EMEM_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEBSEVW_BW_EMEM_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEBSEVW_BW_EMEM_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEBSEVW_BW_EMEM_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEBSEVW_BW_EMEM_INIT_ENUM                     DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEBSEVW_BW_EMEM_DISABLE                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEBSEVW_BW_EMEM_ENABLE                        _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEBSEVW_BW_EMEM_DISABLED                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEBSEVW_BW_EMEM_ENABLED                       _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_VDEMBEW_BW_EMEM_SHIFT                  _MK_SHIFT_CONST(18)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEMBEW_BW_EMEM_FIELD                  (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_VDEMBEW_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEMBEW_BW_EMEM_RANGE                  18:18
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEMBEW_BW_EMEM_WOFFSET                        0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEMBEW_BW_EMEM_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEMBEW_BW_EMEM_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEMBEW_BW_EMEM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEMBEW_BW_EMEM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEMBEW_BW_EMEM_INIT_ENUM                      DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEMBEW_BW_EMEM_DISABLE                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEMBEW_BW_EMEM_ENABLE                 _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEMBEW_BW_EMEM_DISABLED                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDEMBEW_BW_EMEM_ENABLED                        _MK_ENUM_CONST(1)

#define MC_BWSHARE_EMEM_CTRL_1_0_VDETPMW_BW_EMEM_SHIFT                  _MK_SHIFT_CONST(19)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDETPMW_BW_EMEM_FIELD                  (_MK_MASK_CONST(0x1) << MC_BWSHARE_EMEM_CTRL_1_0_VDETPMW_BW_EMEM_SHIFT)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDETPMW_BW_EMEM_RANGE                  19:19
#define MC_BWSHARE_EMEM_CTRL_1_0_VDETPMW_BW_EMEM_WOFFSET                        0x0
#define MC_BWSHARE_EMEM_CTRL_1_0_VDETPMW_BW_EMEM_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDETPMW_BW_EMEM_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDETPMW_BW_EMEM_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDETPMW_BW_EMEM_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDETPMW_BW_EMEM_INIT_ENUM                      DISABLE
#define MC_BWSHARE_EMEM_CTRL_1_0_VDETPMW_BW_EMEM_DISABLE                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDETPMW_BW_EMEM_ENABLE                 _MK_ENUM_CONST(1)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDETPMW_BW_EMEM_DISABLED                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_EMEM_CTRL_1_0_VDETPMW_BW_EMEM_ENABLED                        _MK_ENUM_CONST(1)

#define MC_CLIENT_AP_CTRL_DISABLE       0
#define MC_CLIENT_AP_CTRL_ENABLE        1

// Register MC_AP_CTRL_0_0  
#define MC_AP_CTRL_0_0                  _MK_ADDR_CONST(0x128)
#define MC_AP_CTRL_0_0_SECURE                   0x0
#define MC_AP_CTRL_0_0_WORD_COUNT                       0x1
#define MC_AP_CTRL_0_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define MC_AP_CTRL_0_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define MC_AP_CTRL_0_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
#define MC_AP_CTRL_0_0_DISPLAY0A_APVAL_SHIFT                    _MK_SHIFT_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY0A_APVAL_FIELD                    (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_DISPLAY0A_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_DISPLAY0A_APVAL_RANGE                    0:0
#define MC_AP_CTRL_0_0_DISPLAY0A_APVAL_WOFFSET                  0x0
#define MC_AP_CTRL_0_0_DISPLAY0A_APVAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0A_APVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_DISPLAY0A_APVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0A_APVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0A_APVAL_INIT_ENUM                        DISABLE
#define MC_AP_CTRL_0_0_DISPLAY0A_APVAL_DISABLE                  _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY0A_APVAL_ENABLE                   _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_DISPLAY0A_APVAL_DISABLED                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY0A_APVAL_ENABLED                  _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_DISPLAY0AB_APVAL_SHIFT                   _MK_SHIFT_CONST(1)
#define MC_AP_CTRL_0_0_DISPLAY0AB_APVAL_FIELD                   (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_DISPLAY0AB_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_DISPLAY0AB_APVAL_RANGE                   1:1
#define MC_AP_CTRL_0_0_DISPLAY0AB_APVAL_WOFFSET                 0x0
#define MC_AP_CTRL_0_0_DISPLAY0AB_APVAL_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0AB_APVAL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_DISPLAY0AB_APVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0AB_APVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0AB_APVAL_INIT_ENUM                       DISABLE
#define MC_AP_CTRL_0_0_DISPLAY0AB_APVAL_DISABLE                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY0AB_APVAL_ENABLE                  _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_DISPLAY0AB_APVAL_DISABLED                        _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY0AB_APVAL_ENABLED                 _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_DISPLAY0B_APVAL_SHIFT                    _MK_SHIFT_CONST(2)
#define MC_AP_CTRL_0_0_DISPLAY0B_APVAL_FIELD                    (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_DISPLAY0B_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_DISPLAY0B_APVAL_RANGE                    2:2
#define MC_AP_CTRL_0_0_DISPLAY0B_APVAL_WOFFSET                  0x0
#define MC_AP_CTRL_0_0_DISPLAY0B_APVAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0B_APVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_DISPLAY0B_APVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0B_APVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0B_APVAL_INIT_ENUM                        DISABLE
#define MC_AP_CTRL_0_0_DISPLAY0B_APVAL_DISABLE                  _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY0B_APVAL_ENABLE                   _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_DISPLAY0B_APVAL_DISABLED                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY0B_APVAL_ENABLED                  _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_DISPLAY0BB_APVAL_SHIFT                   _MK_SHIFT_CONST(3)
#define MC_AP_CTRL_0_0_DISPLAY0BB_APVAL_FIELD                   (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_DISPLAY0BB_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_DISPLAY0BB_APVAL_RANGE                   3:3
#define MC_AP_CTRL_0_0_DISPLAY0BB_APVAL_WOFFSET                 0x0
#define MC_AP_CTRL_0_0_DISPLAY0BB_APVAL_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0BB_APVAL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_DISPLAY0BB_APVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0BB_APVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0BB_APVAL_INIT_ENUM                       DISABLE
#define MC_AP_CTRL_0_0_DISPLAY0BB_APVAL_DISABLE                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY0BB_APVAL_ENABLE                  _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_DISPLAY0BB_APVAL_DISABLED                        _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY0BB_APVAL_ENABLED                 _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_DISPLAY0C_APVAL_SHIFT                    _MK_SHIFT_CONST(4)
#define MC_AP_CTRL_0_0_DISPLAY0C_APVAL_FIELD                    (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_DISPLAY0C_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_DISPLAY0C_APVAL_RANGE                    4:4
#define MC_AP_CTRL_0_0_DISPLAY0C_APVAL_WOFFSET                  0x0
#define MC_AP_CTRL_0_0_DISPLAY0C_APVAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0C_APVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_DISPLAY0C_APVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0C_APVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0C_APVAL_INIT_ENUM                        DISABLE
#define MC_AP_CTRL_0_0_DISPLAY0C_APVAL_DISABLE                  _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY0C_APVAL_ENABLE                   _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_DISPLAY0C_APVAL_DISABLED                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY0C_APVAL_ENABLED                  _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_DISPLAY0CB_APVAL_SHIFT                   _MK_SHIFT_CONST(5)
#define MC_AP_CTRL_0_0_DISPLAY0CB_APVAL_FIELD                   (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_DISPLAY0CB_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_DISPLAY0CB_APVAL_RANGE                   5:5
#define MC_AP_CTRL_0_0_DISPLAY0CB_APVAL_WOFFSET                 0x0
#define MC_AP_CTRL_0_0_DISPLAY0CB_APVAL_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0CB_APVAL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_DISPLAY0CB_APVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0CB_APVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY0CB_APVAL_INIT_ENUM                       DISABLE
#define MC_AP_CTRL_0_0_DISPLAY0CB_APVAL_DISABLE                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY0CB_APVAL_ENABLE                  _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_DISPLAY0CB_APVAL_DISABLED                        _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY0CB_APVAL_ENABLED                 _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_DISPLAY1B_APVAL_SHIFT                    _MK_SHIFT_CONST(6)
#define MC_AP_CTRL_0_0_DISPLAY1B_APVAL_FIELD                    (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_DISPLAY1B_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_DISPLAY1B_APVAL_RANGE                    6:6
#define MC_AP_CTRL_0_0_DISPLAY1B_APVAL_WOFFSET                  0x0
#define MC_AP_CTRL_0_0_DISPLAY1B_APVAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY1B_APVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_DISPLAY1B_APVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY1B_APVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY1B_APVAL_INIT_ENUM                        DISABLE
#define MC_AP_CTRL_0_0_DISPLAY1B_APVAL_DISABLE                  _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY1B_APVAL_ENABLE                   _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_DISPLAY1B_APVAL_DISABLED                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY1B_APVAL_ENABLED                  _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_DISPLAY1BB_APVAL_SHIFT                   _MK_SHIFT_CONST(7)
#define MC_AP_CTRL_0_0_DISPLAY1BB_APVAL_FIELD                   (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_DISPLAY1BB_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_DISPLAY1BB_APVAL_RANGE                   7:7
#define MC_AP_CTRL_0_0_DISPLAY1BB_APVAL_WOFFSET                 0x0
#define MC_AP_CTRL_0_0_DISPLAY1BB_APVAL_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY1BB_APVAL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_DISPLAY1BB_APVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY1BB_APVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAY1BB_APVAL_INIT_ENUM                       DISABLE
#define MC_AP_CTRL_0_0_DISPLAY1BB_APVAL_DISABLE                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY1BB_APVAL_ENABLE                  _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_DISPLAY1BB_APVAL_DISABLED                        _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAY1BB_APVAL_ENABLED                 _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_EPPUP_APVAL_SHIFT                        _MK_SHIFT_CONST(8)
#define MC_AP_CTRL_0_0_EPPUP_APVAL_FIELD                        (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_EPPUP_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_EPPUP_APVAL_RANGE                        8:8
#define MC_AP_CTRL_0_0_EPPUP_APVAL_WOFFSET                      0x0
#define MC_AP_CTRL_0_0_EPPUP_APVAL_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_EPPUP_APVAL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_EPPUP_APVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_EPPUP_APVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_EPPUP_APVAL_INIT_ENUM                    DISABLE
#define MC_AP_CTRL_0_0_EPPUP_APVAL_DISABLE                      _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_EPPUP_APVAL_ENABLE                       _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_EPPUP_APVAL_DISABLED                     _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_EPPUP_APVAL_ENABLED                      _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_G2PR_APVAL_SHIFT                 _MK_SHIFT_CONST(9)
#define MC_AP_CTRL_0_0_G2PR_APVAL_FIELD                 (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_G2PR_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_G2PR_APVAL_RANGE                 9:9
#define MC_AP_CTRL_0_0_G2PR_APVAL_WOFFSET                       0x0
#define MC_AP_CTRL_0_0_G2PR_APVAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_G2PR_APVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_G2PR_APVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_G2PR_APVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_G2PR_APVAL_INIT_ENUM                     DISABLE
#define MC_AP_CTRL_0_0_G2PR_APVAL_DISABLE                       _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_G2PR_APVAL_ENABLE                        _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_G2PR_APVAL_DISABLED                      _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_G2PR_APVAL_ENABLED                       _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_G2SR_APVAL_SHIFT                 _MK_SHIFT_CONST(10)
#define MC_AP_CTRL_0_0_G2SR_APVAL_FIELD                 (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_G2SR_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_G2SR_APVAL_RANGE                 10:10
#define MC_AP_CTRL_0_0_G2SR_APVAL_WOFFSET                       0x0
#define MC_AP_CTRL_0_0_G2SR_APVAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_G2SR_APVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_G2SR_APVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_G2SR_APVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_G2SR_APVAL_INIT_ENUM                     DISABLE
#define MC_AP_CTRL_0_0_G2SR_APVAL_DISABLE                       _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_G2SR_APVAL_ENABLE                        _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_G2SR_APVAL_DISABLED                      _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_G2SR_APVAL_ENABLED                       _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_MPEUNIFBR_APVAL_SHIFT                    _MK_SHIFT_CONST(11)
#define MC_AP_CTRL_0_0_MPEUNIFBR_APVAL_FIELD                    (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_MPEUNIFBR_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_MPEUNIFBR_APVAL_RANGE                    11:11
#define MC_AP_CTRL_0_0_MPEUNIFBR_APVAL_WOFFSET                  0x0
#define MC_AP_CTRL_0_0_MPEUNIFBR_APVAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_MPEUNIFBR_APVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_MPEUNIFBR_APVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_MPEUNIFBR_APVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_MPEUNIFBR_APVAL_INIT_ENUM                        DISABLE
#define MC_AP_CTRL_0_0_MPEUNIFBR_APVAL_DISABLE                  _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_MPEUNIFBR_APVAL_ENABLE                   _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_MPEUNIFBR_APVAL_DISABLED                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_MPEUNIFBR_APVAL_ENABLED                  _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_VIRUV_APVAL_SHIFT                        _MK_SHIFT_CONST(12)
#define MC_AP_CTRL_0_0_VIRUV_APVAL_FIELD                        (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_VIRUV_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_VIRUV_APVAL_RANGE                        12:12
#define MC_AP_CTRL_0_0_VIRUV_APVAL_WOFFSET                      0x0
#define MC_AP_CTRL_0_0_VIRUV_APVAL_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_VIRUV_APVAL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_VIRUV_APVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_VIRUV_APVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_VIRUV_APVAL_INIT_ENUM                    DISABLE
#define MC_AP_CTRL_0_0_VIRUV_APVAL_DISABLE                      _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_VIRUV_APVAL_ENABLE                       _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_VIRUV_APVAL_DISABLED                     _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_VIRUV_APVAL_ENABLED                      _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_AVPCARM7R_APVAL_SHIFT                    _MK_SHIFT_CONST(13)
#define MC_AP_CTRL_0_0_AVPCARM7R_APVAL_FIELD                    (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_AVPCARM7R_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_AVPCARM7R_APVAL_RANGE                    13:13
#define MC_AP_CTRL_0_0_AVPCARM7R_APVAL_WOFFSET                  0x0
#define MC_AP_CTRL_0_0_AVPCARM7R_APVAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_AVPCARM7R_APVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_AVPCARM7R_APVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_AVPCARM7R_APVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_AVPCARM7R_APVAL_INIT_ENUM                        DISABLE
#define MC_AP_CTRL_0_0_AVPCARM7R_APVAL_DISABLE                  _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_AVPCARM7R_APVAL_ENABLE                   _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_AVPCARM7R_APVAL_DISABLED                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_AVPCARM7R_APVAL_ENABLED                  _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_DISPLAYHC_APVAL_SHIFT                    _MK_SHIFT_CONST(14)
#define MC_AP_CTRL_0_0_DISPLAYHC_APVAL_FIELD                    (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_DISPLAYHC_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_DISPLAYHC_APVAL_RANGE                    14:14
#define MC_AP_CTRL_0_0_DISPLAYHC_APVAL_WOFFSET                  0x0
#define MC_AP_CTRL_0_0_DISPLAYHC_APVAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAYHC_APVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_DISPLAYHC_APVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAYHC_APVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAYHC_APVAL_INIT_ENUM                        DISABLE
#define MC_AP_CTRL_0_0_DISPLAYHC_APVAL_DISABLE                  _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAYHC_APVAL_ENABLE                   _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_DISPLAYHC_APVAL_DISABLED                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAYHC_APVAL_ENABLED                  _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_DISPLAYHCB_APVAL_SHIFT                   _MK_SHIFT_CONST(15)
#define MC_AP_CTRL_0_0_DISPLAYHCB_APVAL_FIELD                   (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_DISPLAYHCB_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_DISPLAYHCB_APVAL_RANGE                   15:15
#define MC_AP_CTRL_0_0_DISPLAYHCB_APVAL_WOFFSET                 0x0
#define MC_AP_CTRL_0_0_DISPLAYHCB_APVAL_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAYHCB_APVAL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_DISPLAYHCB_APVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAYHCB_APVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_DISPLAYHCB_APVAL_INIT_ENUM                       DISABLE
#define MC_AP_CTRL_0_0_DISPLAYHCB_APVAL_DISABLE                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAYHCB_APVAL_ENABLE                  _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_DISPLAYHCB_APVAL_DISABLED                        _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_DISPLAYHCB_APVAL_ENABLED                 _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_FDCDRD_APVAL_SHIFT                       _MK_SHIFT_CONST(16)
#define MC_AP_CTRL_0_0_FDCDRD_APVAL_FIELD                       (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_FDCDRD_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_FDCDRD_APVAL_RANGE                       16:16
#define MC_AP_CTRL_0_0_FDCDRD_APVAL_WOFFSET                     0x0
#define MC_AP_CTRL_0_0_FDCDRD_APVAL_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_FDCDRD_APVAL_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_FDCDRD_APVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_FDCDRD_APVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_FDCDRD_APVAL_INIT_ENUM                   DISABLE
#define MC_AP_CTRL_0_0_FDCDRD_APVAL_DISABLE                     _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_FDCDRD_APVAL_ENABLE                      _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_FDCDRD_APVAL_DISABLED                    _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_FDCDRD_APVAL_ENABLED                     _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_G2DR_APVAL_SHIFT                 _MK_SHIFT_CONST(17)
#define MC_AP_CTRL_0_0_G2DR_APVAL_FIELD                 (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_G2DR_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_G2DR_APVAL_RANGE                 17:17
#define MC_AP_CTRL_0_0_G2DR_APVAL_WOFFSET                       0x0
#define MC_AP_CTRL_0_0_G2DR_APVAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_G2DR_APVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_G2DR_APVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_G2DR_APVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_G2DR_APVAL_INIT_ENUM                     DISABLE
#define MC_AP_CTRL_0_0_G2DR_APVAL_DISABLE                       _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_G2DR_APVAL_ENABLE                        _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_G2DR_APVAL_DISABLED                      _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_G2DR_APVAL_ENABLED                       _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_HOST1XDMAR_APVAL_SHIFT                   _MK_SHIFT_CONST(18)
#define MC_AP_CTRL_0_0_HOST1XDMAR_APVAL_FIELD                   (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_HOST1XDMAR_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_HOST1XDMAR_APVAL_RANGE                   18:18
#define MC_AP_CTRL_0_0_HOST1XDMAR_APVAL_WOFFSET                 0x0
#define MC_AP_CTRL_0_0_HOST1XDMAR_APVAL_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_HOST1XDMAR_APVAL_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_HOST1XDMAR_APVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_HOST1XDMAR_APVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_HOST1XDMAR_APVAL_INIT_ENUM                       DISABLE
#define MC_AP_CTRL_0_0_HOST1XDMAR_APVAL_DISABLE                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_HOST1XDMAR_APVAL_ENABLE                  _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_HOST1XDMAR_APVAL_DISABLED                        _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_HOST1XDMAR_APVAL_ENABLED                 _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_HOST1XR_APVAL_SHIFT                      _MK_SHIFT_CONST(19)
#define MC_AP_CTRL_0_0_HOST1XR_APVAL_FIELD                      (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_HOST1XR_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_HOST1XR_APVAL_RANGE                      19:19
#define MC_AP_CTRL_0_0_HOST1XR_APVAL_WOFFSET                    0x0
#define MC_AP_CTRL_0_0_HOST1XR_APVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_HOST1XR_APVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_HOST1XR_APVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_HOST1XR_APVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_HOST1XR_APVAL_INIT_ENUM                  DISABLE
#define MC_AP_CTRL_0_0_HOST1XR_APVAL_DISABLE                    _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_HOST1XR_APVAL_ENABLE                     _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_HOST1XR_APVAL_DISABLED                   _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_HOST1XR_APVAL_ENABLED                    _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_IDXSRD_APVAL_SHIFT                       _MK_SHIFT_CONST(20)
#define MC_AP_CTRL_0_0_IDXSRD_APVAL_FIELD                       (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_IDXSRD_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_IDXSRD_APVAL_RANGE                       20:20
#define MC_AP_CTRL_0_0_IDXSRD_APVAL_WOFFSET                     0x0
#define MC_AP_CTRL_0_0_IDXSRD_APVAL_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_IDXSRD_APVAL_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_IDXSRD_APVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_IDXSRD_APVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_IDXSRD_APVAL_INIT_ENUM                   DISABLE
#define MC_AP_CTRL_0_0_IDXSRD_APVAL_DISABLE                     _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_IDXSRD_APVAL_ENABLE                      _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_IDXSRD_APVAL_DISABLED                    _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_IDXSRD_APVAL_ENABLED                     _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_MPCORER_APVAL_SHIFT                      _MK_SHIFT_CONST(21)
#define MC_AP_CTRL_0_0_MPCORER_APVAL_FIELD                      (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_MPCORER_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_MPCORER_APVAL_RANGE                      21:21
#define MC_AP_CTRL_0_0_MPCORER_APVAL_WOFFSET                    0x0
#define MC_AP_CTRL_0_0_MPCORER_APVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_MPCORER_APVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_MPCORER_APVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_MPCORER_APVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_MPCORER_APVAL_INIT_ENUM                  DISABLE
#define MC_AP_CTRL_0_0_MPCORER_APVAL_DISABLE                    _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_MPCORER_APVAL_ENABLE                     _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_MPCORER_APVAL_DISABLED                   _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_MPCORER_APVAL_ENABLED                    _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_MPE_IPRED_APVAL_SHIFT                    _MK_SHIFT_CONST(22)
#define MC_AP_CTRL_0_0_MPE_IPRED_APVAL_FIELD                    (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_MPE_IPRED_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_MPE_IPRED_APVAL_RANGE                    22:22
#define MC_AP_CTRL_0_0_MPE_IPRED_APVAL_WOFFSET                  0x0
#define MC_AP_CTRL_0_0_MPE_IPRED_APVAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_MPE_IPRED_APVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_MPE_IPRED_APVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_MPE_IPRED_APVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_MPE_IPRED_APVAL_INIT_ENUM                        DISABLE
#define MC_AP_CTRL_0_0_MPE_IPRED_APVAL_DISABLE                  _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_MPE_IPRED_APVAL_ENABLE                   _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_MPE_IPRED_APVAL_DISABLED                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_MPE_IPRED_APVAL_ENABLED                  _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_MPEAMEMRD_APVAL_SHIFT                    _MK_SHIFT_CONST(23)
#define MC_AP_CTRL_0_0_MPEAMEMRD_APVAL_FIELD                    (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_MPEAMEMRD_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_MPEAMEMRD_APVAL_RANGE                    23:23
#define MC_AP_CTRL_0_0_MPEAMEMRD_APVAL_WOFFSET                  0x0
#define MC_AP_CTRL_0_0_MPEAMEMRD_APVAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_MPEAMEMRD_APVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_MPEAMEMRD_APVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_MPEAMEMRD_APVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_MPEAMEMRD_APVAL_INIT_ENUM                        DISABLE
#define MC_AP_CTRL_0_0_MPEAMEMRD_APVAL_DISABLE                  _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_MPEAMEMRD_APVAL_ENABLE                   _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_MPEAMEMRD_APVAL_DISABLED                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_MPEAMEMRD_APVAL_ENABLED                  _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_MPECSRD_APVAL_SHIFT                      _MK_SHIFT_CONST(24)
#define MC_AP_CTRL_0_0_MPECSRD_APVAL_FIELD                      (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_MPECSRD_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_MPECSRD_APVAL_RANGE                      24:24
#define MC_AP_CTRL_0_0_MPECSRD_APVAL_WOFFSET                    0x0
#define MC_AP_CTRL_0_0_MPECSRD_APVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_MPECSRD_APVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_MPECSRD_APVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_MPECSRD_APVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_MPECSRD_APVAL_INIT_ENUM                  DISABLE
#define MC_AP_CTRL_0_0_MPECSRD_APVAL_DISABLE                    _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_MPECSRD_APVAL_ENABLE                     _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_MPECSRD_APVAL_DISABLED                   _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_MPECSRD_APVAL_ENABLED                    _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_PPCSAHBDMAR_APVAL_SHIFT                  _MK_SHIFT_CONST(25)
#define MC_AP_CTRL_0_0_PPCSAHBDMAR_APVAL_FIELD                  (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_PPCSAHBDMAR_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_PPCSAHBDMAR_APVAL_RANGE                  25:25
#define MC_AP_CTRL_0_0_PPCSAHBDMAR_APVAL_WOFFSET                        0x0
#define MC_AP_CTRL_0_0_PPCSAHBDMAR_APVAL_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_PPCSAHBDMAR_APVAL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_PPCSAHBDMAR_APVAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_PPCSAHBDMAR_APVAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_PPCSAHBDMAR_APVAL_INIT_ENUM                      DISABLE
#define MC_AP_CTRL_0_0_PPCSAHBDMAR_APVAL_DISABLE                        _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_PPCSAHBDMAR_APVAL_ENABLE                 _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_PPCSAHBDMAR_APVAL_DISABLED                       _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_PPCSAHBDMAR_APVAL_ENABLED                        _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_PPCSAHBSLVR_APVAL_SHIFT                  _MK_SHIFT_CONST(26)
#define MC_AP_CTRL_0_0_PPCSAHBSLVR_APVAL_FIELD                  (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_PPCSAHBSLVR_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_PPCSAHBSLVR_APVAL_RANGE                  26:26
#define MC_AP_CTRL_0_0_PPCSAHBSLVR_APVAL_WOFFSET                        0x0
#define MC_AP_CTRL_0_0_PPCSAHBSLVR_APVAL_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_PPCSAHBSLVR_APVAL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_PPCSAHBSLVR_APVAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_PPCSAHBSLVR_APVAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_PPCSAHBSLVR_APVAL_INIT_ENUM                      DISABLE
#define MC_AP_CTRL_0_0_PPCSAHBSLVR_APVAL_DISABLE                        _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_PPCSAHBSLVR_APVAL_ENABLE                 _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_PPCSAHBSLVR_APVAL_DISABLED                       _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_PPCSAHBSLVR_APVAL_ENABLED                        _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_TEXSRD_APVAL_SHIFT                       _MK_SHIFT_CONST(27)
#define MC_AP_CTRL_0_0_TEXSRD_APVAL_FIELD                       (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_TEXSRD_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_TEXSRD_APVAL_RANGE                       27:27
#define MC_AP_CTRL_0_0_TEXSRD_APVAL_WOFFSET                     0x0
#define MC_AP_CTRL_0_0_TEXSRD_APVAL_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_TEXSRD_APVAL_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_TEXSRD_APVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_TEXSRD_APVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_TEXSRD_APVAL_INIT_ENUM                   DISABLE
#define MC_AP_CTRL_0_0_TEXSRD_APVAL_DISABLE                     _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_TEXSRD_APVAL_ENABLE                      _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_TEXSRD_APVAL_DISABLED                    _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_TEXSRD_APVAL_ENABLED                     _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_VDEBSEVR_APVAL_SHIFT                     _MK_SHIFT_CONST(28)
#define MC_AP_CTRL_0_0_VDEBSEVR_APVAL_FIELD                     (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_VDEBSEVR_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_VDEBSEVR_APVAL_RANGE                     28:28
#define MC_AP_CTRL_0_0_VDEBSEVR_APVAL_WOFFSET                   0x0
#define MC_AP_CTRL_0_0_VDEBSEVR_APVAL_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_VDEBSEVR_APVAL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_VDEBSEVR_APVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_VDEBSEVR_APVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_VDEBSEVR_APVAL_INIT_ENUM                 DISABLE
#define MC_AP_CTRL_0_0_VDEBSEVR_APVAL_DISABLE                   _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_VDEBSEVR_APVAL_ENABLE                    _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_VDEBSEVR_APVAL_DISABLED                  _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_VDEBSEVR_APVAL_ENABLED                   _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_VDEMBER_APVAL_SHIFT                      _MK_SHIFT_CONST(29)
#define MC_AP_CTRL_0_0_VDEMBER_APVAL_FIELD                      (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_VDEMBER_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_VDEMBER_APVAL_RANGE                      29:29
#define MC_AP_CTRL_0_0_VDEMBER_APVAL_WOFFSET                    0x0
#define MC_AP_CTRL_0_0_VDEMBER_APVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_VDEMBER_APVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_VDEMBER_APVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_VDEMBER_APVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_VDEMBER_APVAL_INIT_ENUM                  DISABLE
#define MC_AP_CTRL_0_0_VDEMBER_APVAL_DISABLE                    _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_VDEMBER_APVAL_ENABLE                     _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_VDEMBER_APVAL_DISABLED                   _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_VDEMBER_APVAL_ENABLED                    _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_VDEMCER_APVAL_SHIFT                      _MK_SHIFT_CONST(30)
#define MC_AP_CTRL_0_0_VDEMCER_APVAL_FIELD                      (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_VDEMCER_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_VDEMCER_APVAL_RANGE                      30:30
#define MC_AP_CTRL_0_0_VDEMCER_APVAL_WOFFSET                    0x0
#define MC_AP_CTRL_0_0_VDEMCER_APVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_VDEMCER_APVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_VDEMCER_APVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_VDEMCER_APVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_VDEMCER_APVAL_INIT_ENUM                  DISABLE
#define MC_AP_CTRL_0_0_VDEMCER_APVAL_DISABLE                    _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_VDEMCER_APVAL_ENABLE                     _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_VDEMCER_APVAL_DISABLED                   _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_VDEMCER_APVAL_ENABLED                    _MK_ENUM_CONST(1)

#define MC_AP_CTRL_0_0_VDETPER_APVAL_SHIFT                      _MK_SHIFT_CONST(31)
#define MC_AP_CTRL_0_0_VDETPER_APVAL_FIELD                      (_MK_MASK_CONST(0x1) << MC_AP_CTRL_0_0_VDETPER_APVAL_SHIFT)
#define MC_AP_CTRL_0_0_VDETPER_APVAL_RANGE                      31:31
#define MC_AP_CTRL_0_0_VDETPER_APVAL_WOFFSET                    0x0
#define MC_AP_CTRL_0_0_VDETPER_APVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_VDETPER_APVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_0_0_VDETPER_APVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_VDETPER_APVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_0_0_VDETPER_APVAL_INIT_ENUM                  DISABLE
#define MC_AP_CTRL_0_0_VDETPER_APVAL_DISABLE                    _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_VDETPER_APVAL_ENABLE                     _MK_ENUM_CONST(1)
#define MC_AP_CTRL_0_0_VDETPER_APVAL_DISABLED                   _MK_ENUM_CONST(0)
#define MC_AP_CTRL_0_0_VDETPER_APVAL_ENABLED                    _MK_ENUM_CONST(1)


// Register MC_AP_CTRL_1_0  
#define MC_AP_CTRL_1_0                  _MK_ADDR_CONST(0x12c)
#define MC_AP_CTRL_1_0_SECURE                   0x0
#define MC_AP_CTRL_1_0_WORD_COUNT                       0x1
#define MC_AP_CTRL_1_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_RESET_MASK                       _MK_MASK_CONST(0xfffff)
#define MC_AP_CTRL_1_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_READ_MASK                        _MK_MASK_CONST(0xfffff)
#define MC_AP_CTRL_1_0_WRITE_MASK                       _MK_MASK_CONST(0xfffff)
#define MC_AP_CTRL_1_0_EPPU_APVAL_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_AP_CTRL_1_0_EPPU_APVAL_FIELD                 (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_EPPU_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_EPPU_APVAL_RANGE                 0:0
#define MC_AP_CTRL_1_0_EPPU_APVAL_WOFFSET                       0x0
#define MC_AP_CTRL_1_0_EPPU_APVAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_EPPU_APVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_EPPU_APVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_EPPU_APVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_EPPU_APVAL_INIT_ENUM                     DISABLE
#define MC_AP_CTRL_1_0_EPPU_APVAL_DISABLE                       _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_EPPU_APVAL_ENABLE                        _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_EPPU_APVAL_DISABLED                      _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_EPPU_APVAL_ENABLED                       _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_EPPV_APVAL_SHIFT                 _MK_SHIFT_CONST(1)
#define MC_AP_CTRL_1_0_EPPV_APVAL_FIELD                 (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_EPPV_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_EPPV_APVAL_RANGE                 1:1
#define MC_AP_CTRL_1_0_EPPV_APVAL_WOFFSET                       0x0
#define MC_AP_CTRL_1_0_EPPV_APVAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_EPPV_APVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_EPPV_APVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_EPPV_APVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_EPPV_APVAL_INIT_ENUM                     DISABLE
#define MC_AP_CTRL_1_0_EPPV_APVAL_DISABLE                       _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_EPPV_APVAL_ENABLE                        _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_EPPV_APVAL_DISABLED                      _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_EPPV_APVAL_ENABLED                       _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_EPPY_APVAL_SHIFT                 _MK_SHIFT_CONST(2)
#define MC_AP_CTRL_1_0_EPPY_APVAL_FIELD                 (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_EPPY_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_EPPY_APVAL_RANGE                 2:2
#define MC_AP_CTRL_1_0_EPPY_APVAL_WOFFSET                       0x0
#define MC_AP_CTRL_1_0_EPPY_APVAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_EPPY_APVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_EPPY_APVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_EPPY_APVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_EPPY_APVAL_INIT_ENUM                     DISABLE
#define MC_AP_CTRL_1_0_EPPY_APVAL_DISABLE                       _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_EPPY_APVAL_ENABLE                        _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_EPPY_APVAL_DISABLED                      _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_EPPY_APVAL_ENABLED                       _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_MPEUNIFBW_APVAL_SHIFT                    _MK_SHIFT_CONST(3)
#define MC_AP_CTRL_1_0_MPEUNIFBW_APVAL_FIELD                    (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_MPEUNIFBW_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_MPEUNIFBW_APVAL_RANGE                    3:3
#define MC_AP_CTRL_1_0_MPEUNIFBW_APVAL_WOFFSET                  0x0
#define MC_AP_CTRL_1_0_MPEUNIFBW_APVAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_MPEUNIFBW_APVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_MPEUNIFBW_APVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_MPEUNIFBW_APVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_MPEUNIFBW_APVAL_INIT_ENUM                        DISABLE
#define MC_AP_CTRL_1_0_MPEUNIFBW_APVAL_DISABLE                  _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_MPEUNIFBW_APVAL_ENABLE                   _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_MPEUNIFBW_APVAL_DISABLED                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_MPEUNIFBW_APVAL_ENABLED                  _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_VIWSB_APVAL_SHIFT                        _MK_SHIFT_CONST(4)
#define MC_AP_CTRL_1_0_VIWSB_APVAL_FIELD                        (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_VIWSB_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_VIWSB_APVAL_RANGE                        4:4
#define MC_AP_CTRL_1_0_VIWSB_APVAL_WOFFSET                      0x0
#define MC_AP_CTRL_1_0_VIWSB_APVAL_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VIWSB_APVAL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_VIWSB_APVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VIWSB_APVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VIWSB_APVAL_INIT_ENUM                    DISABLE
#define MC_AP_CTRL_1_0_VIWSB_APVAL_DISABLE                      _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_VIWSB_APVAL_ENABLE                       _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_VIWSB_APVAL_DISABLED                     _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_VIWSB_APVAL_ENABLED                      _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_VIWU_APVAL_SHIFT                 _MK_SHIFT_CONST(5)
#define MC_AP_CTRL_1_0_VIWU_APVAL_FIELD                 (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_VIWU_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_VIWU_APVAL_RANGE                 5:5
#define MC_AP_CTRL_1_0_VIWU_APVAL_WOFFSET                       0x0
#define MC_AP_CTRL_1_0_VIWU_APVAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VIWU_APVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_VIWU_APVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VIWU_APVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VIWU_APVAL_INIT_ENUM                     DISABLE
#define MC_AP_CTRL_1_0_VIWU_APVAL_DISABLE                       _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_VIWU_APVAL_ENABLE                        _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_VIWU_APVAL_DISABLED                      _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_VIWU_APVAL_ENABLED                       _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_VIWV_APVAL_SHIFT                 _MK_SHIFT_CONST(6)
#define MC_AP_CTRL_1_0_VIWV_APVAL_FIELD                 (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_VIWV_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_VIWV_APVAL_RANGE                 6:6
#define MC_AP_CTRL_1_0_VIWV_APVAL_WOFFSET                       0x0
#define MC_AP_CTRL_1_0_VIWV_APVAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VIWV_APVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_VIWV_APVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VIWV_APVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VIWV_APVAL_INIT_ENUM                     DISABLE
#define MC_AP_CTRL_1_0_VIWV_APVAL_DISABLE                       _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_VIWV_APVAL_ENABLE                        _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_VIWV_APVAL_DISABLED                      _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_VIWV_APVAL_ENABLED                       _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_VIWY_APVAL_SHIFT                 _MK_SHIFT_CONST(7)
#define MC_AP_CTRL_1_0_VIWY_APVAL_FIELD                 (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_VIWY_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_VIWY_APVAL_RANGE                 7:7
#define MC_AP_CTRL_1_0_VIWY_APVAL_WOFFSET                       0x0
#define MC_AP_CTRL_1_0_VIWY_APVAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VIWY_APVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_VIWY_APVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VIWY_APVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VIWY_APVAL_INIT_ENUM                     DISABLE
#define MC_AP_CTRL_1_0_VIWY_APVAL_DISABLE                       _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_VIWY_APVAL_ENABLE                        _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_VIWY_APVAL_DISABLED                      _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_VIWY_APVAL_ENABLED                       _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_G2DW_APVAL_SHIFT                 _MK_SHIFT_CONST(8)
#define MC_AP_CTRL_1_0_G2DW_APVAL_FIELD                 (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_G2DW_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_G2DW_APVAL_RANGE                 8:8
#define MC_AP_CTRL_1_0_G2DW_APVAL_WOFFSET                       0x0
#define MC_AP_CTRL_1_0_G2DW_APVAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_G2DW_APVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_G2DW_APVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_G2DW_APVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_G2DW_APVAL_INIT_ENUM                     DISABLE
#define MC_AP_CTRL_1_0_G2DW_APVAL_DISABLE                       _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_G2DW_APVAL_ENABLE                        _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_G2DW_APVAL_DISABLED                      _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_G2DW_APVAL_ENABLED                       _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_AVPCARM7W_APVAL_SHIFT                    _MK_SHIFT_CONST(9)
#define MC_AP_CTRL_1_0_AVPCARM7W_APVAL_FIELD                    (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_AVPCARM7W_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_AVPCARM7W_APVAL_RANGE                    9:9
#define MC_AP_CTRL_1_0_AVPCARM7W_APVAL_WOFFSET                  0x0
#define MC_AP_CTRL_1_0_AVPCARM7W_APVAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_AVPCARM7W_APVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_AVPCARM7W_APVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_AVPCARM7W_APVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_AVPCARM7W_APVAL_INIT_ENUM                        DISABLE
#define MC_AP_CTRL_1_0_AVPCARM7W_APVAL_DISABLE                  _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_AVPCARM7W_APVAL_ENABLE                   _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_AVPCARM7W_APVAL_DISABLED                 _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_AVPCARM7W_APVAL_ENABLED                  _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_FDCDWR_APVAL_SHIFT                       _MK_SHIFT_CONST(10)
#define MC_AP_CTRL_1_0_FDCDWR_APVAL_FIELD                       (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_FDCDWR_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_FDCDWR_APVAL_RANGE                       10:10
#define MC_AP_CTRL_1_0_FDCDWR_APVAL_WOFFSET                     0x0
#define MC_AP_CTRL_1_0_FDCDWR_APVAL_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_FDCDWR_APVAL_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_FDCDWR_APVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_FDCDWR_APVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_FDCDWR_APVAL_INIT_ENUM                   DISABLE
#define MC_AP_CTRL_1_0_FDCDWR_APVAL_DISABLE                     _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_FDCDWR_APVAL_ENABLE                      _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_FDCDWR_APVAL_DISABLED                    _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_FDCDWR_APVAL_ENABLED                     _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_HOST1XW_APVAL_SHIFT                      _MK_SHIFT_CONST(11)
#define MC_AP_CTRL_1_0_HOST1XW_APVAL_FIELD                      (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_HOST1XW_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_HOST1XW_APVAL_RANGE                      11:11
#define MC_AP_CTRL_1_0_HOST1XW_APVAL_WOFFSET                    0x0
#define MC_AP_CTRL_1_0_HOST1XW_APVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_HOST1XW_APVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_HOST1XW_APVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_HOST1XW_APVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_HOST1XW_APVAL_INIT_ENUM                  DISABLE
#define MC_AP_CTRL_1_0_HOST1XW_APVAL_DISABLE                    _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_HOST1XW_APVAL_ENABLE                     _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_HOST1XW_APVAL_DISABLED                   _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_HOST1XW_APVAL_ENABLED                    _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_ISPW_APVAL_SHIFT                 _MK_SHIFT_CONST(12)
#define MC_AP_CTRL_1_0_ISPW_APVAL_FIELD                 (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_ISPW_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_ISPW_APVAL_RANGE                 12:12
#define MC_AP_CTRL_1_0_ISPW_APVAL_WOFFSET                       0x0
#define MC_AP_CTRL_1_0_ISPW_APVAL_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_ISPW_APVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_ISPW_APVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_ISPW_APVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_ISPW_APVAL_INIT_ENUM                     DISABLE
#define MC_AP_CTRL_1_0_ISPW_APVAL_DISABLE                       _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_ISPW_APVAL_ENABLE                        _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_ISPW_APVAL_DISABLED                      _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_ISPW_APVAL_ENABLED                       _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_MPCOREW_APVAL_SHIFT                      _MK_SHIFT_CONST(13)
#define MC_AP_CTRL_1_0_MPCOREW_APVAL_FIELD                      (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_MPCOREW_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_MPCOREW_APVAL_RANGE                      13:13
#define MC_AP_CTRL_1_0_MPCOREW_APVAL_WOFFSET                    0x0
#define MC_AP_CTRL_1_0_MPCOREW_APVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_MPCOREW_APVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_MPCOREW_APVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_MPCOREW_APVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_MPCOREW_APVAL_INIT_ENUM                  DISABLE
#define MC_AP_CTRL_1_0_MPCOREW_APVAL_DISABLE                    _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_MPCOREW_APVAL_ENABLE                     _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_MPCOREW_APVAL_DISABLED                   _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_MPCOREW_APVAL_ENABLED                    _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_MPECSWR_APVAL_SHIFT                      _MK_SHIFT_CONST(14)
#define MC_AP_CTRL_1_0_MPECSWR_APVAL_FIELD                      (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_MPECSWR_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_MPECSWR_APVAL_RANGE                      14:14
#define MC_AP_CTRL_1_0_MPECSWR_APVAL_WOFFSET                    0x0
#define MC_AP_CTRL_1_0_MPECSWR_APVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_MPECSWR_APVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_MPECSWR_APVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_MPECSWR_APVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_MPECSWR_APVAL_INIT_ENUM                  DISABLE
#define MC_AP_CTRL_1_0_MPECSWR_APVAL_DISABLE                    _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_MPECSWR_APVAL_ENABLE                     _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_MPECSWR_APVAL_DISABLED                   _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_MPECSWR_APVAL_ENABLED                    _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_PPCSAHBDMAW_APVAL_SHIFT                  _MK_SHIFT_CONST(15)
#define MC_AP_CTRL_1_0_PPCSAHBDMAW_APVAL_FIELD                  (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_PPCSAHBDMAW_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_PPCSAHBDMAW_APVAL_RANGE                  15:15
#define MC_AP_CTRL_1_0_PPCSAHBDMAW_APVAL_WOFFSET                        0x0
#define MC_AP_CTRL_1_0_PPCSAHBDMAW_APVAL_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_PPCSAHBDMAW_APVAL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_PPCSAHBDMAW_APVAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_PPCSAHBDMAW_APVAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_PPCSAHBDMAW_APVAL_INIT_ENUM                      DISABLE
#define MC_AP_CTRL_1_0_PPCSAHBDMAW_APVAL_DISABLE                        _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_PPCSAHBDMAW_APVAL_ENABLE                 _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_PPCSAHBDMAW_APVAL_DISABLED                       _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_PPCSAHBDMAW_APVAL_ENABLED                        _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_PPCSAHBSLVW_APVAL_SHIFT                  _MK_SHIFT_CONST(16)
#define MC_AP_CTRL_1_0_PPCSAHBSLVW_APVAL_FIELD                  (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_PPCSAHBSLVW_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_PPCSAHBSLVW_APVAL_RANGE                  16:16
#define MC_AP_CTRL_1_0_PPCSAHBSLVW_APVAL_WOFFSET                        0x0
#define MC_AP_CTRL_1_0_PPCSAHBSLVW_APVAL_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_PPCSAHBSLVW_APVAL_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_PPCSAHBSLVW_APVAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_PPCSAHBSLVW_APVAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_PPCSAHBSLVW_APVAL_INIT_ENUM                      DISABLE
#define MC_AP_CTRL_1_0_PPCSAHBSLVW_APVAL_DISABLE                        _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_PPCSAHBSLVW_APVAL_ENABLE                 _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_PPCSAHBSLVW_APVAL_DISABLED                       _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_PPCSAHBSLVW_APVAL_ENABLED                        _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_VDEBSEVW_APVAL_SHIFT                     _MK_SHIFT_CONST(17)
#define MC_AP_CTRL_1_0_VDEBSEVW_APVAL_FIELD                     (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_VDEBSEVW_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_VDEBSEVW_APVAL_RANGE                     17:17
#define MC_AP_CTRL_1_0_VDEBSEVW_APVAL_WOFFSET                   0x0
#define MC_AP_CTRL_1_0_VDEBSEVW_APVAL_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VDEBSEVW_APVAL_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_VDEBSEVW_APVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VDEBSEVW_APVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VDEBSEVW_APVAL_INIT_ENUM                 DISABLE
#define MC_AP_CTRL_1_0_VDEBSEVW_APVAL_DISABLE                   _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_VDEBSEVW_APVAL_ENABLE                    _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_VDEBSEVW_APVAL_DISABLED                  _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_VDEBSEVW_APVAL_ENABLED                   _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_VDEMBEW_APVAL_SHIFT                      _MK_SHIFT_CONST(18)
#define MC_AP_CTRL_1_0_VDEMBEW_APVAL_FIELD                      (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_VDEMBEW_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_VDEMBEW_APVAL_RANGE                      18:18
#define MC_AP_CTRL_1_0_VDEMBEW_APVAL_WOFFSET                    0x0
#define MC_AP_CTRL_1_0_VDEMBEW_APVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VDEMBEW_APVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_VDEMBEW_APVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VDEMBEW_APVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VDEMBEW_APVAL_INIT_ENUM                  DISABLE
#define MC_AP_CTRL_1_0_VDEMBEW_APVAL_DISABLE                    _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_VDEMBEW_APVAL_ENABLE                     _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_VDEMBEW_APVAL_DISABLED                   _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_VDEMBEW_APVAL_ENABLED                    _MK_ENUM_CONST(1)

#define MC_AP_CTRL_1_0_VDETPMW_APVAL_SHIFT                      _MK_SHIFT_CONST(19)
#define MC_AP_CTRL_1_0_VDETPMW_APVAL_FIELD                      (_MK_MASK_CONST(0x1) << MC_AP_CTRL_1_0_VDETPMW_APVAL_SHIFT)
#define MC_AP_CTRL_1_0_VDETPMW_APVAL_RANGE                      19:19
#define MC_AP_CTRL_1_0_VDETPMW_APVAL_WOFFSET                    0x0
#define MC_AP_CTRL_1_0_VDETPMW_APVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VDETPMW_APVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_AP_CTRL_1_0_VDETPMW_APVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VDETPMW_APVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_AP_CTRL_1_0_VDETPMW_APVAL_INIT_ENUM                  DISABLE
#define MC_AP_CTRL_1_0_VDETPMW_APVAL_DISABLE                    _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_VDETPMW_APVAL_ENABLE                     _MK_ENUM_CONST(1)
#define MC_AP_CTRL_1_0_VDETPMW_APVAL_DISABLED                   _MK_ENUM_CONST(0)
#define MC_AP_CTRL_1_0_VDETPMW_APVAL_ENABLED                    _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_INACTIVE     0
#define MC_CLIENT_ACTIVITY_MONITOR_ACTIVE       1

// Reserved address 304 [0x130] 

// Reserved address 308 [0x134] 

// Register MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0  
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0                     _MK_ADDR_CONST(0x138)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_SECURE                      0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_WORD_COUNT                  0x1
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_RESET_MASK                  _MK_MASK_CONST(0xffffffff)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_READ_MASK                   _MK_MASK_CONST(0xffffffff)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_WRITE_MASK                  _MK_MASK_CONST(0xffffffff)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0A_EMEM_ACTIVITY_SHIFT                       _MK_SHIFT_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0A_EMEM_ACTIVITY_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0A_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0A_EMEM_ACTIVITY_RANGE                       0:0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0A_EMEM_ACTIVITY_WOFFSET                     0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0A_EMEM_ACTIVITY_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0A_EMEM_ACTIVITY_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0A_EMEM_ACTIVITY_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0A_EMEM_ACTIVITY_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0A_EMEM_ACTIVITY_INIT_ENUM                   DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0A_EMEM_ACTIVITY_INACTIVE                    _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0A_EMEM_ACTIVITY_ACTIVE                      _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0AB_EMEM_ACTIVITY_SHIFT                      _MK_SHIFT_CONST(1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0AB_EMEM_ACTIVITY_FIELD                      (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0AB_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0AB_EMEM_ACTIVITY_RANGE                      1:1
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0AB_EMEM_ACTIVITY_WOFFSET                    0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0AB_EMEM_ACTIVITY_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0AB_EMEM_ACTIVITY_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0AB_EMEM_ACTIVITY_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0AB_EMEM_ACTIVITY_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0AB_EMEM_ACTIVITY_INIT_ENUM                  DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0AB_EMEM_ACTIVITY_INACTIVE                   _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0AB_EMEM_ACTIVITY_ACTIVE                     _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0B_EMEM_ACTIVITY_SHIFT                       _MK_SHIFT_CONST(2)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0B_EMEM_ACTIVITY_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0B_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0B_EMEM_ACTIVITY_RANGE                       2:2
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0B_EMEM_ACTIVITY_WOFFSET                     0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0B_EMEM_ACTIVITY_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0B_EMEM_ACTIVITY_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0B_EMEM_ACTIVITY_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0B_EMEM_ACTIVITY_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0B_EMEM_ACTIVITY_INIT_ENUM                   DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0B_EMEM_ACTIVITY_INACTIVE                    _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0B_EMEM_ACTIVITY_ACTIVE                      _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0BB_EMEM_ACTIVITY_SHIFT                      _MK_SHIFT_CONST(3)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0BB_EMEM_ACTIVITY_FIELD                      (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0BB_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0BB_EMEM_ACTIVITY_RANGE                      3:3
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0BB_EMEM_ACTIVITY_WOFFSET                    0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0BB_EMEM_ACTIVITY_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0BB_EMEM_ACTIVITY_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0BB_EMEM_ACTIVITY_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0BB_EMEM_ACTIVITY_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0BB_EMEM_ACTIVITY_INIT_ENUM                  DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0BB_EMEM_ACTIVITY_INACTIVE                   _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0BB_EMEM_ACTIVITY_ACTIVE                     _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0C_EMEM_ACTIVITY_SHIFT                       _MK_SHIFT_CONST(4)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0C_EMEM_ACTIVITY_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0C_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0C_EMEM_ACTIVITY_RANGE                       4:4
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0C_EMEM_ACTIVITY_WOFFSET                     0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0C_EMEM_ACTIVITY_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0C_EMEM_ACTIVITY_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0C_EMEM_ACTIVITY_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0C_EMEM_ACTIVITY_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0C_EMEM_ACTIVITY_INIT_ENUM                   DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0C_EMEM_ACTIVITY_INACTIVE                    _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0C_EMEM_ACTIVITY_ACTIVE                      _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0CB_EMEM_ACTIVITY_SHIFT                      _MK_SHIFT_CONST(5)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0CB_EMEM_ACTIVITY_FIELD                      (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0CB_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0CB_EMEM_ACTIVITY_RANGE                      5:5
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0CB_EMEM_ACTIVITY_WOFFSET                    0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0CB_EMEM_ACTIVITY_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0CB_EMEM_ACTIVITY_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0CB_EMEM_ACTIVITY_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0CB_EMEM_ACTIVITY_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0CB_EMEM_ACTIVITY_INIT_ENUM                  DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0CB_EMEM_ACTIVITY_INACTIVE                   _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY0CB_EMEM_ACTIVITY_ACTIVE                     _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1B_EMEM_ACTIVITY_SHIFT                       _MK_SHIFT_CONST(6)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1B_EMEM_ACTIVITY_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1B_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1B_EMEM_ACTIVITY_RANGE                       6:6
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1B_EMEM_ACTIVITY_WOFFSET                     0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1B_EMEM_ACTIVITY_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1B_EMEM_ACTIVITY_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1B_EMEM_ACTIVITY_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1B_EMEM_ACTIVITY_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1B_EMEM_ACTIVITY_INIT_ENUM                   DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1B_EMEM_ACTIVITY_INACTIVE                    _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1B_EMEM_ACTIVITY_ACTIVE                      _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1BB_EMEM_ACTIVITY_SHIFT                      _MK_SHIFT_CONST(7)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1BB_EMEM_ACTIVITY_FIELD                      (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1BB_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1BB_EMEM_ACTIVITY_RANGE                      7:7
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1BB_EMEM_ACTIVITY_WOFFSET                    0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1BB_EMEM_ACTIVITY_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1BB_EMEM_ACTIVITY_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1BB_EMEM_ACTIVITY_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1BB_EMEM_ACTIVITY_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1BB_EMEM_ACTIVITY_INIT_ENUM                  DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1BB_EMEM_ACTIVITY_INACTIVE                   _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAY1BB_EMEM_ACTIVITY_ACTIVE                     _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_EPPUP_EMEM_ACTIVITY_SHIFT                   _MK_SHIFT_CONST(8)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_EPPUP_EMEM_ACTIVITY_FIELD                   (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_EPPUP_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_EPPUP_EMEM_ACTIVITY_RANGE                   8:8
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_EPPUP_EMEM_ACTIVITY_WOFFSET                 0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_EPPUP_EMEM_ACTIVITY_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_EPPUP_EMEM_ACTIVITY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_EPPUP_EMEM_ACTIVITY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_EPPUP_EMEM_ACTIVITY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_EPPUP_EMEM_ACTIVITY_INIT_ENUM                       DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_EPPUP_EMEM_ACTIVITY_INACTIVE                        _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_EPPUP_EMEM_ACTIVITY_ACTIVE                  _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2PR_EMEM_ACTIVITY_SHIFT                    _MK_SHIFT_CONST(9)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2PR_EMEM_ACTIVITY_FIELD                    (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2PR_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2PR_EMEM_ACTIVITY_RANGE                    9:9
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2PR_EMEM_ACTIVITY_WOFFSET                  0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2PR_EMEM_ACTIVITY_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2PR_EMEM_ACTIVITY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2PR_EMEM_ACTIVITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2PR_EMEM_ACTIVITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2PR_EMEM_ACTIVITY_INIT_ENUM                        DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2PR_EMEM_ACTIVITY_INACTIVE                 _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2PR_EMEM_ACTIVITY_ACTIVE                   _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2SR_EMEM_ACTIVITY_SHIFT                    _MK_SHIFT_CONST(10)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2SR_EMEM_ACTIVITY_FIELD                    (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2SR_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2SR_EMEM_ACTIVITY_RANGE                    10:10
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2SR_EMEM_ACTIVITY_WOFFSET                  0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2SR_EMEM_ACTIVITY_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2SR_EMEM_ACTIVITY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2SR_EMEM_ACTIVITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2SR_EMEM_ACTIVITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2SR_EMEM_ACTIVITY_INIT_ENUM                        DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2SR_EMEM_ACTIVITY_INACTIVE                 _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2SR_EMEM_ACTIVITY_ACTIVE                   _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEUNIFBR_EMEM_ACTIVITY_SHIFT                       _MK_SHIFT_CONST(11)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEUNIFBR_EMEM_ACTIVITY_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEUNIFBR_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEUNIFBR_EMEM_ACTIVITY_RANGE                       11:11
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEUNIFBR_EMEM_ACTIVITY_WOFFSET                     0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEUNIFBR_EMEM_ACTIVITY_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEUNIFBR_EMEM_ACTIVITY_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEUNIFBR_EMEM_ACTIVITY_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEUNIFBR_EMEM_ACTIVITY_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEUNIFBR_EMEM_ACTIVITY_INIT_ENUM                   DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEUNIFBR_EMEM_ACTIVITY_INACTIVE                    _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEUNIFBR_EMEM_ACTIVITY_ACTIVE                      _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VIRUV_EMEM_ACTIVITY_SHIFT                   _MK_SHIFT_CONST(12)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VIRUV_EMEM_ACTIVITY_FIELD                   (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VIRUV_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VIRUV_EMEM_ACTIVITY_RANGE                   12:12
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VIRUV_EMEM_ACTIVITY_WOFFSET                 0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VIRUV_EMEM_ACTIVITY_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VIRUV_EMEM_ACTIVITY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VIRUV_EMEM_ACTIVITY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VIRUV_EMEM_ACTIVITY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VIRUV_EMEM_ACTIVITY_INIT_ENUM                       DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VIRUV_EMEM_ACTIVITY_INACTIVE                        _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VIRUV_EMEM_ACTIVITY_ACTIVE                  _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_AVPCARM7R_EMEM_ACTIVITY_SHIFT                       _MK_SHIFT_CONST(13)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_AVPCARM7R_EMEM_ACTIVITY_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_AVPCARM7R_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_AVPCARM7R_EMEM_ACTIVITY_RANGE                       13:13
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_AVPCARM7R_EMEM_ACTIVITY_WOFFSET                     0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_AVPCARM7R_EMEM_ACTIVITY_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_AVPCARM7R_EMEM_ACTIVITY_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_AVPCARM7R_EMEM_ACTIVITY_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_AVPCARM7R_EMEM_ACTIVITY_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_AVPCARM7R_EMEM_ACTIVITY_INIT_ENUM                   DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_AVPCARM7R_EMEM_ACTIVITY_INACTIVE                    _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_AVPCARM7R_EMEM_ACTIVITY_ACTIVE                      _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHC_EMEM_ACTIVITY_SHIFT                       _MK_SHIFT_CONST(14)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHC_EMEM_ACTIVITY_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHC_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHC_EMEM_ACTIVITY_RANGE                       14:14
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHC_EMEM_ACTIVITY_WOFFSET                     0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHC_EMEM_ACTIVITY_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHC_EMEM_ACTIVITY_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHC_EMEM_ACTIVITY_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHC_EMEM_ACTIVITY_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHC_EMEM_ACTIVITY_INIT_ENUM                   DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHC_EMEM_ACTIVITY_INACTIVE                    _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHC_EMEM_ACTIVITY_ACTIVE                      _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHCB_EMEM_ACTIVITY_SHIFT                      _MK_SHIFT_CONST(15)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHCB_EMEM_ACTIVITY_FIELD                      (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHCB_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHCB_EMEM_ACTIVITY_RANGE                      15:15
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHCB_EMEM_ACTIVITY_WOFFSET                    0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHCB_EMEM_ACTIVITY_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHCB_EMEM_ACTIVITY_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHCB_EMEM_ACTIVITY_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHCB_EMEM_ACTIVITY_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHCB_EMEM_ACTIVITY_INIT_ENUM                  DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHCB_EMEM_ACTIVITY_INACTIVE                   _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_DISPLAYHCB_EMEM_ACTIVITY_ACTIVE                     _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_FDCDRD_EMEM_ACTIVITY_SHIFT                  _MK_SHIFT_CONST(16)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_FDCDRD_EMEM_ACTIVITY_FIELD                  (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_FDCDRD_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_FDCDRD_EMEM_ACTIVITY_RANGE                  16:16
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_FDCDRD_EMEM_ACTIVITY_WOFFSET                        0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_FDCDRD_EMEM_ACTIVITY_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_FDCDRD_EMEM_ACTIVITY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_FDCDRD_EMEM_ACTIVITY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_FDCDRD_EMEM_ACTIVITY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_FDCDRD_EMEM_ACTIVITY_INIT_ENUM                      DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_FDCDRD_EMEM_ACTIVITY_INACTIVE                       _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_FDCDRD_EMEM_ACTIVITY_ACTIVE                 _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2DR_EMEM_ACTIVITY_SHIFT                    _MK_SHIFT_CONST(17)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2DR_EMEM_ACTIVITY_FIELD                    (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2DR_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2DR_EMEM_ACTIVITY_RANGE                    17:17
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2DR_EMEM_ACTIVITY_WOFFSET                  0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2DR_EMEM_ACTIVITY_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2DR_EMEM_ACTIVITY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2DR_EMEM_ACTIVITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2DR_EMEM_ACTIVITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2DR_EMEM_ACTIVITY_INIT_ENUM                        DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2DR_EMEM_ACTIVITY_INACTIVE                 _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_G2DR_EMEM_ACTIVITY_ACTIVE                   _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XDMAR_EMEM_ACTIVITY_SHIFT                      _MK_SHIFT_CONST(18)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XDMAR_EMEM_ACTIVITY_FIELD                      (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XDMAR_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XDMAR_EMEM_ACTIVITY_RANGE                      18:18
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XDMAR_EMEM_ACTIVITY_WOFFSET                    0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XDMAR_EMEM_ACTIVITY_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XDMAR_EMEM_ACTIVITY_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XDMAR_EMEM_ACTIVITY_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XDMAR_EMEM_ACTIVITY_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XDMAR_EMEM_ACTIVITY_INIT_ENUM                  DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XDMAR_EMEM_ACTIVITY_INACTIVE                   _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XDMAR_EMEM_ACTIVITY_ACTIVE                     _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XR_EMEM_ACTIVITY_SHIFT                 _MK_SHIFT_CONST(19)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XR_EMEM_ACTIVITY_FIELD                 (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XR_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XR_EMEM_ACTIVITY_RANGE                 19:19
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XR_EMEM_ACTIVITY_WOFFSET                       0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XR_EMEM_ACTIVITY_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XR_EMEM_ACTIVITY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XR_EMEM_ACTIVITY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XR_EMEM_ACTIVITY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XR_EMEM_ACTIVITY_INIT_ENUM                     DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XR_EMEM_ACTIVITY_INACTIVE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_HOST1XR_EMEM_ACTIVITY_ACTIVE                        _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_IDXSRD_EMEM_ACTIVITY_SHIFT                  _MK_SHIFT_CONST(20)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_IDXSRD_EMEM_ACTIVITY_FIELD                  (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_IDXSRD_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_IDXSRD_EMEM_ACTIVITY_RANGE                  20:20
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_IDXSRD_EMEM_ACTIVITY_WOFFSET                        0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_IDXSRD_EMEM_ACTIVITY_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_IDXSRD_EMEM_ACTIVITY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_IDXSRD_EMEM_ACTIVITY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_IDXSRD_EMEM_ACTIVITY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_IDXSRD_EMEM_ACTIVITY_INIT_ENUM                      DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_IDXSRD_EMEM_ACTIVITY_INACTIVE                       _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_IDXSRD_EMEM_ACTIVITY_ACTIVE                 _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPCORER_EMEM_ACTIVITY_SHIFT                 _MK_SHIFT_CONST(21)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPCORER_EMEM_ACTIVITY_FIELD                 (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPCORER_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPCORER_EMEM_ACTIVITY_RANGE                 21:21
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPCORER_EMEM_ACTIVITY_WOFFSET                       0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPCORER_EMEM_ACTIVITY_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPCORER_EMEM_ACTIVITY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPCORER_EMEM_ACTIVITY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPCORER_EMEM_ACTIVITY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPCORER_EMEM_ACTIVITY_INIT_ENUM                     DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPCORER_EMEM_ACTIVITY_INACTIVE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPCORER_EMEM_ACTIVITY_ACTIVE                        _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPE_IPRED_EMEM_ACTIVITY_SHIFT                       _MK_SHIFT_CONST(22)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPE_IPRED_EMEM_ACTIVITY_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPE_IPRED_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPE_IPRED_EMEM_ACTIVITY_RANGE                       22:22
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPE_IPRED_EMEM_ACTIVITY_WOFFSET                     0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPE_IPRED_EMEM_ACTIVITY_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPE_IPRED_EMEM_ACTIVITY_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPE_IPRED_EMEM_ACTIVITY_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPE_IPRED_EMEM_ACTIVITY_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPE_IPRED_EMEM_ACTIVITY_INIT_ENUM                   DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPE_IPRED_EMEM_ACTIVITY_INACTIVE                    _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPE_IPRED_EMEM_ACTIVITY_ACTIVE                      _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEAMEMRD_EMEM_ACTIVITY_SHIFT                       _MK_SHIFT_CONST(23)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEAMEMRD_EMEM_ACTIVITY_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEAMEMRD_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEAMEMRD_EMEM_ACTIVITY_RANGE                       23:23
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEAMEMRD_EMEM_ACTIVITY_WOFFSET                     0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEAMEMRD_EMEM_ACTIVITY_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEAMEMRD_EMEM_ACTIVITY_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEAMEMRD_EMEM_ACTIVITY_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEAMEMRD_EMEM_ACTIVITY_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEAMEMRD_EMEM_ACTIVITY_INIT_ENUM                   DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEAMEMRD_EMEM_ACTIVITY_INACTIVE                    _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPEAMEMRD_EMEM_ACTIVITY_ACTIVE                      _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPECSRD_EMEM_ACTIVITY_SHIFT                 _MK_SHIFT_CONST(24)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPECSRD_EMEM_ACTIVITY_FIELD                 (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPECSRD_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPECSRD_EMEM_ACTIVITY_RANGE                 24:24
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPECSRD_EMEM_ACTIVITY_WOFFSET                       0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPECSRD_EMEM_ACTIVITY_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPECSRD_EMEM_ACTIVITY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPECSRD_EMEM_ACTIVITY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPECSRD_EMEM_ACTIVITY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPECSRD_EMEM_ACTIVITY_INIT_ENUM                     DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPECSRD_EMEM_ACTIVITY_INACTIVE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_MPECSRD_EMEM_ACTIVITY_ACTIVE                        _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBDMAR_EMEM_ACTIVITY_SHIFT                     _MK_SHIFT_CONST(25)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBDMAR_EMEM_ACTIVITY_FIELD                     (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBDMAR_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBDMAR_EMEM_ACTIVITY_RANGE                     25:25
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBDMAR_EMEM_ACTIVITY_WOFFSET                   0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBDMAR_EMEM_ACTIVITY_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBDMAR_EMEM_ACTIVITY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBDMAR_EMEM_ACTIVITY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBDMAR_EMEM_ACTIVITY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBDMAR_EMEM_ACTIVITY_INIT_ENUM                 DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBDMAR_EMEM_ACTIVITY_INACTIVE                  _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBDMAR_EMEM_ACTIVITY_ACTIVE                    _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBSLVR_EMEM_ACTIVITY_SHIFT                     _MK_SHIFT_CONST(26)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBSLVR_EMEM_ACTIVITY_FIELD                     (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBSLVR_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBSLVR_EMEM_ACTIVITY_RANGE                     26:26
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBSLVR_EMEM_ACTIVITY_WOFFSET                   0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBSLVR_EMEM_ACTIVITY_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBSLVR_EMEM_ACTIVITY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBSLVR_EMEM_ACTIVITY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBSLVR_EMEM_ACTIVITY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBSLVR_EMEM_ACTIVITY_INIT_ENUM                 DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBSLVR_EMEM_ACTIVITY_INACTIVE                  _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_PPCSAHBSLVR_EMEM_ACTIVITY_ACTIVE                    _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_TEXSRD_EMEM_ACTIVITY_SHIFT                  _MK_SHIFT_CONST(27)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_TEXSRD_EMEM_ACTIVITY_FIELD                  (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_TEXSRD_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_TEXSRD_EMEM_ACTIVITY_RANGE                  27:27
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_TEXSRD_EMEM_ACTIVITY_WOFFSET                        0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_TEXSRD_EMEM_ACTIVITY_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_TEXSRD_EMEM_ACTIVITY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_TEXSRD_EMEM_ACTIVITY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_TEXSRD_EMEM_ACTIVITY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_TEXSRD_EMEM_ACTIVITY_INIT_ENUM                      DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_TEXSRD_EMEM_ACTIVITY_INACTIVE                       _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_TEXSRD_EMEM_ACTIVITY_ACTIVE                 _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEBSEVR_EMEM_ACTIVITY_SHIFT                        _MK_SHIFT_CONST(28)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEBSEVR_EMEM_ACTIVITY_FIELD                        (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEBSEVR_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEBSEVR_EMEM_ACTIVITY_RANGE                        28:28
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEBSEVR_EMEM_ACTIVITY_WOFFSET                      0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEBSEVR_EMEM_ACTIVITY_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEBSEVR_EMEM_ACTIVITY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEBSEVR_EMEM_ACTIVITY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEBSEVR_EMEM_ACTIVITY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEBSEVR_EMEM_ACTIVITY_INIT_ENUM                    DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEBSEVR_EMEM_ACTIVITY_INACTIVE                     _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEBSEVR_EMEM_ACTIVITY_ACTIVE                       _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMBER_EMEM_ACTIVITY_SHIFT                 _MK_SHIFT_CONST(29)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMBER_EMEM_ACTIVITY_FIELD                 (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMBER_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMBER_EMEM_ACTIVITY_RANGE                 29:29
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMBER_EMEM_ACTIVITY_WOFFSET                       0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMBER_EMEM_ACTIVITY_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMBER_EMEM_ACTIVITY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMBER_EMEM_ACTIVITY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMBER_EMEM_ACTIVITY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMBER_EMEM_ACTIVITY_INIT_ENUM                     DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMBER_EMEM_ACTIVITY_INACTIVE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMBER_EMEM_ACTIVITY_ACTIVE                        _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMCER_EMEM_ACTIVITY_SHIFT                 _MK_SHIFT_CONST(30)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMCER_EMEM_ACTIVITY_FIELD                 (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMCER_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMCER_EMEM_ACTIVITY_RANGE                 30:30
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMCER_EMEM_ACTIVITY_WOFFSET                       0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMCER_EMEM_ACTIVITY_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMCER_EMEM_ACTIVITY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMCER_EMEM_ACTIVITY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMCER_EMEM_ACTIVITY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMCER_EMEM_ACTIVITY_INIT_ENUM                     DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMCER_EMEM_ACTIVITY_INACTIVE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDEMCER_EMEM_ACTIVITY_ACTIVE                        _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDETPER_EMEM_ACTIVITY_SHIFT                 _MK_SHIFT_CONST(31)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDETPER_EMEM_ACTIVITY_FIELD                 (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDETPER_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDETPER_EMEM_ACTIVITY_RANGE                 31:31
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDETPER_EMEM_ACTIVITY_WOFFSET                       0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDETPER_EMEM_ACTIVITY_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDETPER_EMEM_ACTIVITY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDETPER_EMEM_ACTIVITY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDETPER_EMEM_ACTIVITY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDETPER_EMEM_ACTIVITY_INIT_ENUM                     DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDETPER_EMEM_ACTIVITY_INACTIVE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0_VDETPER_EMEM_ACTIVITY_ACTIVE                        _MK_ENUM_CONST(1)


// Register MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0  
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0                     _MK_ADDR_CONST(0x13c)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_SECURE                      0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_WORD_COUNT                  0x1
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_RESET_MASK                  _MK_MASK_CONST(0xfffff)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_READ_MASK                   _MK_MASK_CONST(0xfffff)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_WRITE_MASK                  _MK_MASK_CONST(0xfffff)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPU_EMEM_ACTIVITY_SHIFT                    _MK_SHIFT_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPU_EMEM_ACTIVITY_FIELD                    (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPU_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPU_EMEM_ACTIVITY_RANGE                    0:0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPU_EMEM_ACTIVITY_WOFFSET                  0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPU_EMEM_ACTIVITY_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPU_EMEM_ACTIVITY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPU_EMEM_ACTIVITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPU_EMEM_ACTIVITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPU_EMEM_ACTIVITY_INIT_ENUM                        DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPU_EMEM_ACTIVITY_INACTIVE                 _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPU_EMEM_ACTIVITY_ACTIVE                   _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPV_EMEM_ACTIVITY_SHIFT                    _MK_SHIFT_CONST(1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPV_EMEM_ACTIVITY_FIELD                    (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPV_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPV_EMEM_ACTIVITY_RANGE                    1:1
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPV_EMEM_ACTIVITY_WOFFSET                  0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPV_EMEM_ACTIVITY_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPV_EMEM_ACTIVITY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPV_EMEM_ACTIVITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPV_EMEM_ACTIVITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPV_EMEM_ACTIVITY_INIT_ENUM                        DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPV_EMEM_ACTIVITY_INACTIVE                 _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPV_EMEM_ACTIVITY_ACTIVE                   _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPY_EMEM_ACTIVITY_SHIFT                    _MK_SHIFT_CONST(2)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPY_EMEM_ACTIVITY_FIELD                    (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPY_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPY_EMEM_ACTIVITY_RANGE                    2:2
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPY_EMEM_ACTIVITY_WOFFSET                  0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPY_EMEM_ACTIVITY_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPY_EMEM_ACTIVITY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPY_EMEM_ACTIVITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPY_EMEM_ACTIVITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPY_EMEM_ACTIVITY_INIT_ENUM                        DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPY_EMEM_ACTIVITY_INACTIVE                 _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_EPPY_EMEM_ACTIVITY_ACTIVE                   _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPEUNIFBW_EMEM_ACTIVITY_SHIFT                       _MK_SHIFT_CONST(3)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPEUNIFBW_EMEM_ACTIVITY_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPEUNIFBW_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPEUNIFBW_EMEM_ACTIVITY_RANGE                       3:3
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPEUNIFBW_EMEM_ACTIVITY_WOFFSET                     0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPEUNIFBW_EMEM_ACTIVITY_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPEUNIFBW_EMEM_ACTIVITY_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPEUNIFBW_EMEM_ACTIVITY_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPEUNIFBW_EMEM_ACTIVITY_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPEUNIFBW_EMEM_ACTIVITY_INIT_ENUM                   DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPEUNIFBW_EMEM_ACTIVITY_INACTIVE                    _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPEUNIFBW_EMEM_ACTIVITY_ACTIVE                      _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWSB_EMEM_ACTIVITY_SHIFT                   _MK_SHIFT_CONST(4)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWSB_EMEM_ACTIVITY_FIELD                   (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWSB_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWSB_EMEM_ACTIVITY_RANGE                   4:4
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWSB_EMEM_ACTIVITY_WOFFSET                 0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWSB_EMEM_ACTIVITY_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWSB_EMEM_ACTIVITY_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWSB_EMEM_ACTIVITY_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWSB_EMEM_ACTIVITY_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWSB_EMEM_ACTIVITY_INIT_ENUM                       DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWSB_EMEM_ACTIVITY_INACTIVE                        _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWSB_EMEM_ACTIVITY_ACTIVE                  _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWU_EMEM_ACTIVITY_SHIFT                    _MK_SHIFT_CONST(5)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWU_EMEM_ACTIVITY_FIELD                    (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWU_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWU_EMEM_ACTIVITY_RANGE                    5:5
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWU_EMEM_ACTIVITY_WOFFSET                  0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWU_EMEM_ACTIVITY_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWU_EMEM_ACTIVITY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWU_EMEM_ACTIVITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWU_EMEM_ACTIVITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWU_EMEM_ACTIVITY_INIT_ENUM                        DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWU_EMEM_ACTIVITY_INACTIVE                 _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWU_EMEM_ACTIVITY_ACTIVE                   _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWV_EMEM_ACTIVITY_SHIFT                    _MK_SHIFT_CONST(6)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWV_EMEM_ACTIVITY_FIELD                    (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWV_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWV_EMEM_ACTIVITY_RANGE                    6:6
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWV_EMEM_ACTIVITY_WOFFSET                  0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWV_EMEM_ACTIVITY_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWV_EMEM_ACTIVITY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWV_EMEM_ACTIVITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWV_EMEM_ACTIVITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWV_EMEM_ACTIVITY_INIT_ENUM                        DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWV_EMEM_ACTIVITY_INACTIVE                 _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWV_EMEM_ACTIVITY_ACTIVE                   _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWY_EMEM_ACTIVITY_SHIFT                    _MK_SHIFT_CONST(7)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWY_EMEM_ACTIVITY_FIELD                    (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWY_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWY_EMEM_ACTIVITY_RANGE                    7:7
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWY_EMEM_ACTIVITY_WOFFSET                  0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWY_EMEM_ACTIVITY_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWY_EMEM_ACTIVITY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWY_EMEM_ACTIVITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWY_EMEM_ACTIVITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWY_EMEM_ACTIVITY_INIT_ENUM                        DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWY_EMEM_ACTIVITY_INACTIVE                 _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VIWY_EMEM_ACTIVITY_ACTIVE                   _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_G2DW_EMEM_ACTIVITY_SHIFT                    _MK_SHIFT_CONST(8)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_G2DW_EMEM_ACTIVITY_FIELD                    (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_G2DW_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_G2DW_EMEM_ACTIVITY_RANGE                    8:8
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_G2DW_EMEM_ACTIVITY_WOFFSET                  0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_G2DW_EMEM_ACTIVITY_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_G2DW_EMEM_ACTIVITY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_G2DW_EMEM_ACTIVITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_G2DW_EMEM_ACTIVITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_G2DW_EMEM_ACTIVITY_INIT_ENUM                        DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_G2DW_EMEM_ACTIVITY_INACTIVE                 _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_G2DW_EMEM_ACTIVITY_ACTIVE                   _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_AVPCARM7W_EMEM_ACTIVITY_SHIFT                       _MK_SHIFT_CONST(9)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_AVPCARM7W_EMEM_ACTIVITY_FIELD                       (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_AVPCARM7W_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_AVPCARM7W_EMEM_ACTIVITY_RANGE                       9:9
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_AVPCARM7W_EMEM_ACTIVITY_WOFFSET                     0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_AVPCARM7W_EMEM_ACTIVITY_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_AVPCARM7W_EMEM_ACTIVITY_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_AVPCARM7W_EMEM_ACTIVITY_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_AVPCARM7W_EMEM_ACTIVITY_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_AVPCARM7W_EMEM_ACTIVITY_INIT_ENUM                   DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_AVPCARM7W_EMEM_ACTIVITY_INACTIVE                    _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_AVPCARM7W_EMEM_ACTIVITY_ACTIVE                      _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_FDCDWR_EMEM_ACTIVITY_SHIFT                  _MK_SHIFT_CONST(10)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_FDCDWR_EMEM_ACTIVITY_FIELD                  (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_FDCDWR_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_FDCDWR_EMEM_ACTIVITY_RANGE                  10:10
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_FDCDWR_EMEM_ACTIVITY_WOFFSET                        0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_FDCDWR_EMEM_ACTIVITY_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_FDCDWR_EMEM_ACTIVITY_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_FDCDWR_EMEM_ACTIVITY_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_FDCDWR_EMEM_ACTIVITY_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_FDCDWR_EMEM_ACTIVITY_INIT_ENUM                      DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_FDCDWR_EMEM_ACTIVITY_INACTIVE                       _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_FDCDWR_EMEM_ACTIVITY_ACTIVE                 _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_HOST1XW_EMEM_ACTIVITY_SHIFT                 _MK_SHIFT_CONST(11)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_HOST1XW_EMEM_ACTIVITY_FIELD                 (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_HOST1XW_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_HOST1XW_EMEM_ACTIVITY_RANGE                 11:11
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_HOST1XW_EMEM_ACTIVITY_WOFFSET                       0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_HOST1XW_EMEM_ACTIVITY_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_HOST1XW_EMEM_ACTIVITY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_HOST1XW_EMEM_ACTIVITY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_HOST1XW_EMEM_ACTIVITY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_HOST1XW_EMEM_ACTIVITY_INIT_ENUM                     DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_HOST1XW_EMEM_ACTIVITY_INACTIVE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_HOST1XW_EMEM_ACTIVITY_ACTIVE                        _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_ISPW_EMEM_ACTIVITY_SHIFT                    _MK_SHIFT_CONST(12)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_ISPW_EMEM_ACTIVITY_FIELD                    (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_ISPW_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_ISPW_EMEM_ACTIVITY_RANGE                    12:12
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_ISPW_EMEM_ACTIVITY_WOFFSET                  0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_ISPW_EMEM_ACTIVITY_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_ISPW_EMEM_ACTIVITY_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_ISPW_EMEM_ACTIVITY_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_ISPW_EMEM_ACTIVITY_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_ISPW_EMEM_ACTIVITY_INIT_ENUM                        DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_ISPW_EMEM_ACTIVITY_INACTIVE                 _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_ISPW_EMEM_ACTIVITY_ACTIVE                   _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPCOREW_EMEM_ACTIVITY_SHIFT                 _MK_SHIFT_CONST(13)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPCOREW_EMEM_ACTIVITY_FIELD                 (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPCOREW_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPCOREW_EMEM_ACTIVITY_RANGE                 13:13
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPCOREW_EMEM_ACTIVITY_WOFFSET                       0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPCOREW_EMEM_ACTIVITY_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPCOREW_EMEM_ACTIVITY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPCOREW_EMEM_ACTIVITY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPCOREW_EMEM_ACTIVITY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPCOREW_EMEM_ACTIVITY_INIT_ENUM                     DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPCOREW_EMEM_ACTIVITY_INACTIVE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPCOREW_EMEM_ACTIVITY_ACTIVE                        _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPECSWR_EMEM_ACTIVITY_SHIFT                 _MK_SHIFT_CONST(14)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPECSWR_EMEM_ACTIVITY_FIELD                 (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPECSWR_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPECSWR_EMEM_ACTIVITY_RANGE                 14:14
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPECSWR_EMEM_ACTIVITY_WOFFSET                       0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPECSWR_EMEM_ACTIVITY_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPECSWR_EMEM_ACTIVITY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPECSWR_EMEM_ACTIVITY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPECSWR_EMEM_ACTIVITY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPECSWR_EMEM_ACTIVITY_INIT_ENUM                     DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPECSWR_EMEM_ACTIVITY_INACTIVE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_MPECSWR_EMEM_ACTIVITY_ACTIVE                        _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBDMAW_EMEM_ACTIVITY_SHIFT                     _MK_SHIFT_CONST(15)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBDMAW_EMEM_ACTIVITY_FIELD                     (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBDMAW_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBDMAW_EMEM_ACTIVITY_RANGE                     15:15
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBDMAW_EMEM_ACTIVITY_WOFFSET                   0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBDMAW_EMEM_ACTIVITY_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBDMAW_EMEM_ACTIVITY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBDMAW_EMEM_ACTIVITY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBDMAW_EMEM_ACTIVITY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBDMAW_EMEM_ACTIVITY_INIT_ENUM                 DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBDMAW_EMEM_ACTIVITY_INACTIVE                  _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBDMAW_EMEM_ACTIVITY_ACTIVE                    _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBSLVW_EMEM_ACTIVITY_SHIFT                     _MK_SHIFT_CONST(16)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBSLVW_EMEM_ACTIVITY_FIELD                     (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBSLVW_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBSLVW_EMEM_ACTIVITY_RANGE                     16:16
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBSLVW_EMEM_ACTIVITY_WOFFSET                   0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBSLVW_EMEM_ACTIVITY_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBSLVW_EMEM_ACTIVITY_DEFAULT_MASK                      _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBSLVW_EMEM_ACTIVITY_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBSLVW_EMEM_ACTIVITY_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBSLVW_EMEM_ACTIVITY_INIT_ENUM                 DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBSLVW_EMEM_ACTIVITY_INACTIVE                  _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_PPCSAHBSLVW_EMEM_ACTIVITY_ACTIVE                    _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEBSEVW_EMEM_ACTIVITY_SHIFT                        _MK_SHIFT_CONST(17)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEBSEVW_EMEM_ACTIVITY_FIELD                        (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEBSEVW_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEBSEVW_EMEM_ACTIVITY_RANGE                        17:17
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEBSEVW_EMEM_ACTIVITY_WOFFSET                      0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEBSEVW_EMEM_ACTIVITY_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEBSEVW_EMEM_ACTIVITY_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEBSEVW_EMEM_ACTIVITY_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEBSEVW_EMEM_ACTIVITY_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEBSEVW_EMEM_ACTIVITY_INIT_ENUM                    DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEBSEVW_EMEM_ACTIVITY_INACTIVE                     _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEBSEVW_EMEM_ACTIVITY_ACTIVE                       _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEMBEW_EMEM_ACTIVITY_SHIFT                 _MK_SHIFT_CONST(18)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEMBEW_EMEM_ACTIVITY_FIELD                 (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEMBEW_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEMBEW_EMEM_ACTIVITY_RANGE                 18:18
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEMBEW_EMEM_ACTIVITY_WOFFSET                       0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEMBEW_EMEM_ACTIVITY_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEMBEW_EMEM_ACTIVITY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEMBEW_EMEM_ACTIVITY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEMBEW_EMEM_ACTIVITY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEMBEW_EMEM_ACTIVITY_INIT_ENUM                     DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEMBEW_EMEM_ACTIVITY_INACTIVE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDEMBEW_EMEM_ACTIVITY_ACTIVE                        _MK_ENUM_CONST(1)

#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDETPMW_EMEM_ACTIVITY_SHIFT                 _MK_SHIFT_CONST(19)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDETPMW_EMEM_ACTIVITY_FIELD                 (_MK_MASK_CONST(0x1) << MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDETPMW_EMEM_ACTIVITY_SHIFT)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDETPMW_EMEM_ACTIVITY_RANGE                 19:19
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDETPMW_EMEM_ACTIVITY_WOFFSET                       0x0
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDETPMW_EMEM_ACTIVITY_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDETPMW_EMEM_ACTIVITY_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDETPMW_EMEM_ACTIVITY_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDETPMW_EMEM_ACTIVITY_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDETPMW_EMEM_ACTIVITY_INIT_ENUM                     DISABLE
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDETPMW_EMEM_ACTIVITY_INACTIVE                      _MK_ENUM_CONST(0)
#define MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0_VDETPMW_EMEM_ACTIVITY_ACTIVE                        _MK_ENUM_CONST(1)


// Register MC_AVPC_ORRC_0  
#define MC_AVPC_ORRC_0                  _MK_ADDR_CONST(0x140)
#define MC_AVPC_ORRC_0_SECURE                   0x0
#define MC_AVPC_ORRC_0_WORD_COUNT                       0x1
#define MC_AVPC_ORRC_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define MC_AVPC_ORRC_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define MC_AVPC_ORRC_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define MC_AVPC_ORRC_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_AVPC_ORRC_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define MC_AVPC_ORRC_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define MC_AVPC_ORRC_0_AVPC_OUTREQCNT_SHIFT                     _MK_SHIFT_CONST(0)
#define MC_AVPC_ORRC_0_AVPC_OUTREQCNT_FIELD                     (_MK_MASK_CONST(0xff) << MC_AVPC_ORRC_0_AVPC_OUTREQCNT_SHIFT)
#define MC_AVPC_ORRC_0_AVPC_OUTREQCNT_RANGE                     7:0
#define MC_AVPC_ORRC_0_AVPC_OUTREQCNT_WOFFSET                   0x0
#define MC_AVPC_ORRC_0_AVPC_OUTREQCNT_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_AVPC_ORRC_0_AVPC_OUTREQCNT_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_AVPC_ORRC_0_AVPC_OUTREQCNT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_AVPC_ORRC_0_AVPC_OUTREQCNT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register MC_DC_ORRC_0  
#define MC_DC_ORRC_0                    _MK_ADDR_CONST(0x144)
#define MC_DC_ORRC_0_SECURE                     0x0
#define MC_DC_ORRC_0_WORD_COUNT                         0x1
#define MC_DC_ORRC_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define MC_DC_ORRC_0_RESET_MASK                         _MK_MASK_CONST(0xff)
#define MC_DC_ORRC_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define MC_DC_ORRC_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_DC_ORRC_0_READ_MASK                  _MK_MASK_CONST(0xff)
#define MC_DC_ORRC_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define MC_DC_ORRC_0_DC_OUTREQCNT_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_DC_ORRC_0_DC_OUTREQCNT_FIELD                 (_MK_MASK_CONST(0xff) << MC_DC_ORRC_0_DC_OUTREQCNT_SHIFT)
#define MC_DC_ORRC_0_DC_OUTREQCNT_RANGE                 7:0
#define MC_DC_ORRC_0_DC_OUTREQCNT_WOFFSET                       0x0
#define MC_DC_ORRC_0_DC_OUTREQCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_DC_ORRC_0_DC_OUTREQCNT_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define MC_DC_ORRC_0_DC_OUTREQCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_DC_ORRC_0_DC_OUTREQCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register MC_DCB_ORRC_0  
#define MC_DCB_ORRC_0                   _MK_ADDR_CONST(0x148)
#define MC_DCB_ORRC_0_SECURE                    0x0
#define MC_DCB_ORRC_0_WORD_COUNT                        0x1
#define MC_DCB_ORRC_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define MC_DCB_ORRC_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define MC_DCB_ORRC_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define MC_DCB_ORRC_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_DCB_ORRC_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define MC_DCB_ORRC_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define MC_DCB_ORRC_0_DCB_OUTREQCNT_SHIFT                       _MK_SHIFT_CONST(0)
#define MC_DCB_ORRC_0_DCB_OUTREQCNT_FIELD                       (_MK_MASK_CONST(0xff) << MC_DCB_ORRC_0_DCB_OUTREQCNT_SHIFT)
#define MC_DCB_ORRC_0_DCB_OUTREQCNT_RANGE                       7:0
#define MC_DCB_ORRC_0_DCB_OUTREQCNT_WOFFSET                     0x0
#define MC_DCB_ORRC_0_DCB_OUTREQCNT_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_DCB_ORRC_0_DCB_OUTREQCNT_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define MC_DCB_ORRC_0_DCB_OUTREQCNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_DCB_ORRC_0_DCB_OUTREQCNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register MC_EPP_ORRC_0  
#define MC_EPP_ORRC_0                   _MK_ADDR_CONST(0x14c)
#define MC_EPP_ORRC_0_SECURE                    0x0
#define MC_EPP_ORRC_0_WORD_COUNT                        0x1
#define MC_EPP_ORRC_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define MC_EPP_ORRC_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define MC_EPP_ORRC_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define MC_EPP_ORRC_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_EPP_ORRC_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define MC_EPP_ORRC_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define MC_EPP_ORRC_0_EPP_OUTREQCNT_SHIFT                       _MK_SHIFT_CONST(0)
#define MC_EPP_ORRC_0_EPP_OUTREQCNT_FIELD                       (_MK_MASK_CONST(0xff) << MC_EPP_ORRC_0_EPP_OUTREQCNT_SHIFT)
#define MC_EPP_ORRC_0_EPP_OUTREQCNT_RANGE                       7:0
#define MC_EPP_ORRC_0_EPP_OUTREQCNT_WOFFSET                     0x0
#define MC_EPP_ORRC_0_EPP_OUTREQCNT_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_EPP_ORRC_0_EPP_OUTREQCNT_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define MC_EPP_ORRC_0_EPP_OUTREQCNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_EPP_ORRC_0_EPP_OUTREQCNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register MC_G2_ORRC_0  
#define MC_G2_ORRC_0                    _MK_ADDR_CONST(0x150)
#define MC_G2_ORRC_0_SECURE                     0x0
#define MC_G2_ORRC_0_WORD_COUNT                         0x1
#define MC_G2_ORRC_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define MC_G2_ORRC_0_RESET_MASK                         _MK_MASK_CONST(0xff)
#define MC_G2_ORRC_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define MC_G2_ORRC_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_G2_ORRC_0_READ_MASK                  _MK_MASK_CONST(0xff)
#define MC_G2_ORRC_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define MC_G2_ORRC_0_G2_OUTREQCNT_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_G2_ORRC_0_G2_OUTREQCNT_FIELD                 (_MK_MASK_CONST(0xff) << MC_G2_ORRC_0_G2_OUTREQCNT_SHIFT)
#define MC_G2_ORRC_0_G2_OUTREQCNT_RANGE                 7:0
#define MC_G2_ORRC_0_G2_OUTREQCNT_WOFFSET                       0x0
#define MC_G2_ORRC_0_G2_OUTREQCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_G2_ORRC_0_G2_OUTREQCNT_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define MC_G2_ORRC_0_G2_OUTREQCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_G2_ORRC_0_G2_OUTREQCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register MC_HC_ORRC_0  
#define MC_HC_ORRC_0                    _MK_ADDR_CONST(0x154)
#define MC_HC_ORRC_0_SECURE                     0x0
#define MC_HC_ORRC_0_WORD_COUNT                         0x1
#define MC_HC_ORRC_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define MC_HC_ORRC_0_RESET_MASK                         _MK_MASK_CONST(0xff)
#define MC_HC_ORRC_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define MC_HC_ORRC_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_HC_ORRC_0_READ_MASK                  _MK_MASK_CONST(0xff)
#define MC_HC_ORRC_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define MC_HC_ORRC_0_HC_OUTREQCNT_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_HC_ORRC_0_HC_OUTREQCNT_FIELD                 (_MK_MASK_CONST(0xff) << MC_HC_ORRC_0_HC_OUTREQCNT_SHIFT)
#define MC_HC_ORRC_0_HC_OUTREQCNT_RANGE                 7:0
#define MC_HC_ORRC_0_HC_OUTREQCNT_WOFFSET                       0x0
#define MC_HC_ORRC_0_HC_OUTREQCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_HC_ORRC_0_HC_OUTREQCNT_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define MC_HC_ORRC_0_HC_OUTREQCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_HC_ORRC_0_HC_OUTREQCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register MC_ISP_ORRC_0  
#define MC_ISP_ORRC_0                   _MK_ADDR_CONST(0x158)
#define MC_ISP_ORRC_0_SECURE                    0x0
#define MC_ISP_ORRC_0_WORD_COUNT                        0x1
#define MC_ISP_ORRC_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define MC_ISP_ORRC_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define MC_ISP_ORRC_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define MC_ISP_ORRC_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_ISP_ORRC_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define MC_ISP_ORRC_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define MC_ISP_ORRC_0_ISP_OUTREQCNT_SHIFT                       _MK_SHIFT_CONST(0)
#define MC_ISP_ORRC_0_ISP_OUTREQCNT_FIELD                       (_MK_MASK_CONST(0xff) << MC_ISP_ORRC_0_ISP_OUTREQCNT_SHIFT)
#define MC_ISP_ORRC_0_ISP_OUTREQCNT_RANGE                       7:0
#define MC_ISP_ORRC_0_ISP_OUTREQCNT_WOFFSET                     0x0
#define MC_ISP_ORRC_0_ISP_OUTREQCNT_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_ISP_ORRC_0_ISP_OUTREQCNT_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define MC_ISP_ORRC_0_ISP_OUTREQCNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_ISP_ORRC_0_ISP_OUTREQCNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register MC_MPCORE_ORRC_0  
#define MC_MPCORE_ORRC_0                        _MK_ADDR_CONST(0x15c)
#define MC_MPCORE_ORRC_0_SECURE                         0x0
#define MC_MPCORE_ORRC_0_WORD_COUNT                     0x1
#define MC_MPCORE_ORRC_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define MC_MPCORE_ORRC_0_RESET_MASK                     _MK_MASK_CONST(0xff)
#define MC_MPCORE_ORRC_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define MC_MPCORE_ORRC_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_MPCORE_ORRC_0_READ_MASK                      _MK_MASK_CONST(0xff)
#define MC_MPCORE_ORRC_0_WRITE_MASK                     _MK_MASK_CONST(0x0)
#define MC_MPCORE_ORRC_0_MPCORE_OUTREQCNT_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_MPCORE_ORRC_0_MPCORE_OUTREQCNT_FIELD                 (_MK_MASK_CONST(0xff) << MC_MPCORE_ORRC_0_MPCORE_OUTREQCNT_SHIFT)
#define MC_MPCORE_ORRC_0_MPCORE_OUTREQCNT_RANGE                 7:0
#define MC_MPCORE_ORRC_0_MPCORE_OUTREQCNT_WOFFSET                       0x0
#define MC_MPCORE_ORRC_0_MPCORE_OUTREQCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_MPCORE_ORRC_0_MPCORE_OUTREQCNT_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define MC_MPCORE_ORRC_0_MPCORE_OUTREQCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_MPCORE_ORRC_0_MPCORE_OUTREQCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register MC_MPEA_ORRC_0  
#define MC_MPEA_ORRC_0                  _MK_ADDR_CONST(0x160)
#define MC_MPEA_ORRC_0_SECURE                   0x0
#define MC_MPEA_ORRC_0_WORD_COUNT                       0x1
#define MC_MPEA_ORRC_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define MC_MPEA_ORRC_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define MC_MPEA_ORRC_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define MC_MPEA_ORRC_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_MPEA_ORRC_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define MC_MPEA_ORRC_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define MC_MPEA_ORRC_0_MPEA_OUTREQCNT_SHIFT                     _MK_SHIFT_CONST(0)
#define MC_MPEA_ORRC_0_MPEA_OUTREQCNT_FIELD                     (_MK_MASK_CONST(0xff) << MC_MPEA_ORRC_0_MPEA_OUTREQCNT_SHIFT)
#define MC_MPEA_ORRC_0_MPEA_OUTREQCNT_RANGE                     7:0
#define MC_MPEA_ORRC_0_MPEA_OUTREQCNT_WOFFSET                   0x0
#define MC_MPEA_ORRC_0_MPEA_OUTREQCNT_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_MPEA_ORRC_0_MPEA_OUTREQCNT_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_MPEA_ORRC_0_MPEA_OUTREQCNT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_MPEA_ORRC_0_MPEA_OUTREQCNT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register MC_MPEB_ORRC_0  
#define MC_MPEB_ORRC_0                  _MK_ADDR_CONST(0x164)
#define MC_MPEB_ORRC_0_SECURE                   0x0
#define MC_MPEB_ORRC_0_WORD_COUNT                       0x1
#define MC_MPEB_ORRC_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define MC_MPEB_ORRC_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define MC_MPEB_ORRC_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define MC_MPEB_ORRC_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_MPEB_ORRC_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define MC_MPEB_ORRC_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define MC_MPEB_ORRC_0_MPEB_OUTREQCNT_SHIFT                     _MK_SHIFT_CONST(0)
#define MC_MPEB_ORRC_0_MPEB_OUTREQCNT_FIELD                     (_MK_MASK_CONST(0xff) << MC_MPEB_ORRC_0_MPEB_OUTREQCNT_SHIFT)
#define MC_MPEB_ORRC_0_MPEB_OUTREQCNT_RANGE                     7:0
#define MC_MPEB_ORRC_0_MPEB_OUTREQCNT_WOFFSET                   0x0
#define MC_MPEB_ORRC_0_MPEB_OUTREQCNT_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_MPEB_ORRC_0_MPEB_OUTREQCNT_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_MPEB_ORRC_0_MPEB_OUTREQCNT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_MPEB_ORRC_0_MPEB_OUTREQCNT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register MC_MPEC_ORRC_0  
#define MC_MPEC_ORRC_0                  _MK_ADDR_CONST(0x168)
#define MC_MPEC_ORRC_0_SECURE                   0x0
#define MC_MPEC_ORRC_0_WORD_COUNT                       0x1
#define MC_MPEC_ORRC_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define MC_MPEC_ORRC_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define MC_MPEC_ORRC_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define MC_MPEC_ORRC_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_MPEC_ORRC_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define MC_MPEC_ORRC_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define MC_MPEC_ORRC_0_MPEC_OUTREQCNT_SHIFT                     _MK_SHIFT_CONST(0)
#define MC_MPEC_ORRC_0_MPEC_OUTREQCNT_FIELD                     (_MK_MASK_CONST(0xff) << MC_MPEC_ORRC_0_MPEC_OUTREQCNT_SHIFT)
#define MC_MPEC_ORRC_0_MPEC_OUTREQCNT_RANGE                     7:0
#define MC_MPEC_ORRC_0_MPEC_OUTREQCNT_WOFFSET                   0x0
#define MC_MPEC_ORRC_0_MPEC_OUTREQCNT_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_MPEC_ORRC_0_MPEC_OUTREQCNT_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_MPEC_ORRC_0_MPEC_OUTREQCNT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_MPEC_ORRC_0_MPEC_OUTREQCNT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register MC_NV_ORRC_0  
#define MC_NV_ORRC_0                    _MK_ADDR_CONST(0x16c)
#define MC_NV_ORRC_0_SECURE                     0x0
#define MC_NV_ORRC_0_WORD_COUNT                         0x1
#define MC_NV_ORRC_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define MC_NV_ORRC_0_RESET_MASK                         _MK_MASK_CONST(0xff)
#define MC_NV_ORRC_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define MC_NV_ORRC_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_NV_ORRC_0_READ_MASK                  _MK_MASK_CONST(0xff)
#define MC_NV_ORRC_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define MC_NV_ORRC_0_NV_OUTREQCNT_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_NV_ORRC_0_NV_OUTREQCNT_FIELD                 (_MK_MASK_CONST(0xff) << MC_NV_ORRC_0_NV_OUTREQCNT_SHIFT)
#define MC_NV_ORRC_0_NV_OUTREQCNT_RANGE                 7:0
#define MC_NV_ORRC_0_NV_OUTREQCNT_WOFFSET                       0x0
#define MC_NV_ORRC_0_NV_OUTREQCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_NV_ORRC_0_NV_OUTREQCNT_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define MC_NV_ORRC_0_NV_OUTREQCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_NV_ORRC_0_NV_OUTREQCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register MC_PPCS_ORRC_0  
#define MC_PPCS_ORRC_0                  _MK_ADDR_CONST(0x170)
#define MC_PPCS_ORRC_0_SECURE                   0x0
#define MC_PPCS_ORRC_0_WORD_COUNT                       0x1
#define MC_PPCS_ORRC_0_RESET_VAL                        _MK_MASK_CONST(0x0)
#define MC_PPCS_ORRC_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define MC_PPCS_ORRC_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define MC_PPCS_ORRC_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_PPCS_ORRC_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define MC_PPCS_ORRC_0_WRITE_MASK                       _MK_MASK_CONST(0x0)
#define MC_PPCS_ORRC_0_PPCS_OUTREQCNT_SHIFT                     _MK_SHIFT_CONST(0)
#define MC_PPCS_ORRC_0_PPCS_OUTREQCNT_FIELD                     (_MK_MASK_CONST(0xff) << MC_PPCS_ORRC_0_PPCS_OUTREQCNT_SHIFT)
#define MC_PPCS_ORRC_0_PPCS_OUTREQCNT_RANGE                     7:0
#define MC_PPCS_ORRC_0_PPCS_OUTREQCNT_WOFFSET                   0x0
#define MC_PPCS_ORRC_0_PPCS_OUTREQCNT_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_PPCS_ORRC_0_PPCS_OUTREQCNT_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_PPCS_ORRC_0_PPCS_OUTREQCNT_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_PPCS_ORRC_0_PPCS_OUTREQCNT_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register MC_VDE_ORRC_0  
#define MC_VDE_ORRC_0                   _MK_ADDR_CONST(0x174)
#define MC_VDE_ORRC_0_SECURE                    0x0
#define MC_VDE_ORRC_0_WORD_COUNT                        0x1
#define MC_VDE_ORRC_0_RESET_VAL                         _MK_MASK_CONST(0x0)
#define MC_VDE_ORRC_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define MC_VDE_ORRC_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define MC_VDE_ORRC_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_VDE_ORRC_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define MC_VDE_ORRC_0_WRITE_MASK                        _MK_MASK_CONST(0x0)
#define MC_VDE_ORRC_0_VDE_OUTREQCNT_SHIFT                       _MK_SHIFT_CONST(0)
#define MC_VDE_ORRC_0_VDE_OUTREQCNT_FIELD                       (_MK_MASK_CONST(0xff) << MC_VDE_ORRC_0_VDE_OUTREQCNT_SHIFT)
#define MC_VDE_ORRC_0_VDE_OUTREQCNT_RANGE                       7:0
#define MC_VDE_ORRC_0_VDE_OUTREQCNT_WOFFSET                     0x0
#define MC_VDE_ORRC_0_VDE_OUTREQCNT_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_VDE_ORRC_0_VDE_OUTREQCNT_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define MC_VDE_ORRC_0_VDE_OUTREQCNT_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_VDE_ORRC_0_VDE_OUTREQCNT_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register MC_VI_ORRC_0  
#define MC_VI_ORRC_0                    _MK_ADDR_CONST(0x178)
#define MC_VI_ORRC_0_SECURE                     0x0
#define MC_VI_ORRC_0_WORD_COUNT                         0x1
#define MC_VI_ORRC_0_RESET_VAL                  _MK_MASK_CONST(0x0)
#define MC_VI_ORRC_0_RESET_MASK                         _MK_MASK_CONST(0xff)
#define MC_VI_ORRC_0_SW_DEFAULT_VAL                     _MK_MASK_CONST(0x0)
#define MC_VI_ORRC_0_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_VI_ORRC_0_READ_MASK                  _MK_MASK_CONST(0xff)
#define MC_VI_ORRC_0_WRITE_MASK                         _MK_MASK_CONST(0x0)
#define MC_VI_ORRC_0_VI_OUTREQCNT_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_VI_ORRC_0_VI_OUTREQCNT_FIELD                 (_MK_MASK_CONST(0xff) << MC_VI_ORRC_0_VI_OUTREQCNT_SHIFT)
#define MC_VI_ORRC_0_VI_OUTREQCNT_RANGE                 7:0
#define MC_VI_ORRC_0_VI_OUTREQCNT_WOFFSET                       0x0
#define MC_VI_ORRC_0_VI_OUTREQCNT_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_VI_ORRC_0_VI_OUTREQCNT_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define MC_VI_ORRC_0_VI_OUTREQCNT_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_VI_ORRC_0_VI_OUTREQCNT_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register MC_FPRI_CTRL_AVPC_0  
#define MC_FPRI_CTRL_AVPC_0                     _MK_ADDR_CONST(0x17c)
#define MC_FPRI_CTRL_AVPC_0_SECURE                      0x0
#define MC_FPRI_CTRL_AVPC_0_WORD_COUNT                  0x1
#define MC_FPRI_CTRL_AVPC_0_RESET_VAL                   _MK_MASK_CONST(0x5)
#define MC_FPRI_CTRL_AVPC_0_RESET_MASK                  _MK_MASK_CONST(0xf)
#define MC_FPRI_CTRL_AVPC_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_AVPC_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_AVPC_0_READ_MASK                   _MK_MASK_CONST(0xf)
#define MC_FPRI_CTRL_AVPC_0_WRITE_MASK                  _MK_MASK_CONST(0xf)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7R_PRIVAL_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7R_PRIVAL_FIELD                      (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_AVPC_0_AVPCARM7R_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7R_PRIVAL_RANGE                      1:0
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7R_PRIVAL_WOFFSET                    0x0
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7R_PRIVAL_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7R_PRIVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7R_PRIVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7R_PRIVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7R_PRIVAL_INIT_ENUM                  LOW
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7R_PRIVAL_LOWEST                     _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7R_PRIVAL_LOW                        _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7R_PRIVAL_MED                        _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7R_PRIVAL_HIGH                       _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_AVPC_0_AVPCARM7W_PRIVAL_SHIFT                      _MK_SHIFT_CONST(2)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7W_PRIVAL_FIELD                      (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_AVPC_0_AVPCARM7W_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7W_PRIVAL_RANGE                      3:2
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7W_PRIVAL_WOFFSET                    0x0
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7W_PRIVAL_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7W_PRIVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7W_PRIVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7W_PRIVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7W_PRIVAL_INIT_ENUM                  LOW
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7W_PRIVAL_LOWEST                     _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7W_PRIVAL_LOW                        _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7W_PRIVAL_MED                        _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_AVPC_0_AVPCARM7W_PRIVAL_HIGH                       _MK_ENUM_CONST(3)


// Register MC_FPRI_CTRL_DC_0  
#define MC_FPRI_CTRL_DC_0                       _MK_ADDR_CONST(0x180)
#define MC_FPRI_CTRL_DC_0_SECURE                        0x0
#define MC_FPRI_CTRL_DC_0_WORD_COUNT                    0x1
#define MC_FPRI_CTRL_DC_0_RESET_VAL                     _MK_MASK_CONST(0x155)
#define MC_FPRI_CTRL_DC_0_RESET_MASK                    _MK_MASK_CONST(0x3ff)
#define MC_FPRI_CTRL_DC_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DC_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DC_0_READ_MASK                     _MK_MASK_CONST(0x3ff)
#define MC_FPRI_CTRL_DC_0_WRITE_MASK                    _MK_MASK_CONST(0x3ff)
#define MC_FPRI_CTRL_DC_0_DISPLAY0A_PRIVAL_SHIFT                        _MK_SHIFT_CONST(0)
#define MC_FPRI_CTRL_DC_0_DISPLAY0A_PRIVAL_FIELD                        (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_DC_0_DISPLAY0A_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_DC_0_DISPLAY0A_PRIVAL_RANGE                        1:0
#define MC_FPRI_CTRL_DC_0_DISPLAY0A_PRIVAL_WOFFSET                      0x0
#define MC_FPRI_CTRL_DC_0_DISPLAY0A_PRIVAL_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_DC_0_DISPLAY0A_PRIVAL_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_DC_0_DISPLAY0A_PRIVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DC_0_DISPLAY0A_PRIVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DC_0_DISPLAY0A_PRIVAL_INIT_ENUM                    LOW
#define MC_FPRI_CTRL_DC_0_DISPLAY0A_PRIVAL_LOWEST                       _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_DC_0_DISPLAY0A_PRIVAL_LOW                  _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_DC_0_DISPLAY0A_PRIVAL_MED                  _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_DC_0_DISPLAY0A_PRIVAL_HIGH                 _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_DC_0_DISPLAY0B_PRIVAL_SHIFT                        _MK_SHIFT_CONST(2)
#define MC_FPRI_CTRL_DC_0_DISPLAY0B_PRIVAL_FIELD                        (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_DC_0_DISPLAY0B_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_DC_0_DISPLAY0B_PRIVAL_RANGE                        3:2
#define MC_FPRI_CTRL_DC_0_DISPLAY0B_PRIVAL_WOFFSET                      0x0
#define MC_FPRI_CTRL_DC_0_DISPLAY0B_PRIVAL_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_DC_0_DISPLAY0B_PRIVAL_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_DC_0_DISPLAY0B_PRIVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DC_0_DISPLAY0B_PRIVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DC_0_DISPLAY0B_PRIVAL_INIT_ENUM                    LOW
#define MC_FPRI_CTRL_DC_0_DISPLAY0B_PRIVAL_LOWEST                       _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_DC_0_DISPLAY0B_PRIVAL_LOW                  _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_DC_0_DISPLAY0B_PRIVAL_MED                  _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_DC_0_DISPLAY0B_PRIVAL_HIGH                 _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_DC_0_DISPLAY0C_PRIVAL_SHIFT                        _MK_SHIFT_CONST(4)
#define MC_FPRI_CTRL_DC_0_DISPLAY0C_PRIVAL_FIELD                        (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_DC_0_DISPLAY0C_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_DC_0_DISPLAY0C_PRIVAL_RANGE                        5:4
#define MC_FPRI_CTRL_DC_0_DISPLAY0C_PRIVAL_WOFFSET                      0x0
#define MC_FPRI_CTRL_DC_0_DISPLAY0C_PRIVAL_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_DC_0_DISPLAY0C_PRIVAL_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_DC_0_DISPLAY0C_PRIVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DC_0_DISPLAY0C_PRIVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DC_0_DISPLAY0C_PRIVAL_INIT_ENUM                    LOW
#define MC_FPRI_CTRL_DC_0_DISPLAY0C_PRIVAL_LOWEST                       _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_DC_0_DISPLAY0C_PRIVAL_LOW                  _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_DC_0_DISPLAY0C_PRIVAL_MED                  _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_DC_0_DISPLAY0C_PRIVAL_HIGH                 _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_DC_0_DISPLAY1B_PRIVAL_SHIFT                        _MK_SHIFT_CONST(6)
#define MC_FPRI_CTRL_DC_0_DISPLAY1B_PRIVAL_FIELD                        (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_DC_0_DISPLAY1B_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_DC_0_DISPLAY1B_PRIVAL_RANGE                        7:6
#define MC_FPRI_CTRL_DC_0_DISPLAY1B_PRIVAL_WOFFSET                      0x0
#define MC_FPRI_CTRL_DC_0_DISPLAY1B_PRIVAL_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_DC_0_DISPLAY1B_PRIVAL_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_DC_0_DISPLAY1B_PRIVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DC_0_DISPLAY1B_PRIVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DC_0_DISPLAY1B_PRIVAL_INIT_ENUM                    LOW
#define MC_FPRI_CTRL_DC_0_DISPLAY1B_PRIVAL_LOWEST                       _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_DC_0_DISPLAY1B_PRIVAL_LOW                  _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_DC_0_DISPLAY1B_PRIVAL_MED                  _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_DC_0_DISPLAY1B_PRIVAL_HIGH                 _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_DC_0_DISPLAYHC_PRIVAL_SHIFT                        _MK_SHIFT_CONST(8)
#define MC_FPRI_CTRL_DC_0_DISPLAYHC_PRIVAL_FIELD                        (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_DC_0_DISPLAYHC_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_DC_0_DISPLAYHC_PRIVAL_RANGE                        9:8
#define MC_FPRI_CTRL_DC_0_DISPLAYHC_PRIVAL_WOFFSET                      0x0
#define MC_FPRI_CTRL_DC_0_DISPLAYHC_PRIVAL_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_DC_0_DISPLAYHC_PRIVAL_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_DC_0_DISPLAYHC_PRIVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DC_0_DISPLAYHC_PRIVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DC_0_DISPLAYHC_PRIVAL_INIT_ENUM                    LOW
#define MC_FPRI_CTRL_DC_0_DISPLAYHC_PRIVAL_LOWEST                       _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_DC_0_DISPLAYHC_PRIVAL_LOW                  _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_DC_0_DISPLAYHC_PRIVAL_MED                  _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_DC_0_DISPLAYHC_PRIVAL_HIGH                 _MK_ENUM_CONST(3)


// Register MC_FPRI_CTRL_DCB_0  
#define MC_FPRI_CTRL_DCB_0                      _MK_ADDR_CONST(0x184)
#define MC_FPRI_CTRL_DCB_0_SECURE                       0x0
#define MC_FPRI_CTRL_DCB_0_WORD_COUNT                   0x1
#define MC_FPRI_CTRL_DCB_0_RESET_VAL                    _MK_MASK_CONST(0x155)
#define MC_FPRI_CTRL_DCB_0_RESET_MASK                   _MK_MASK_CONST(0x3ff)
#define MC_FPRI_CTRL_DCB_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DCB_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DCB_0_READ_MASK                    _MK_MASK_CONST(0x3ff)
#define MC_FPRI_CTRL_DCB_0_WRITE_MASK                   _MK_MASK_CONST(0x3ff)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0AB_PRIVAL_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0AB_PRIVAL_FIELD                      (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_DCB_0_DISPLAY0AB_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0AB_PRIVAL_RANGE                      1:0
#define MC_FPRI_CTRL_DCB_0_DISPLAY0AB_PRIVAL_WOFFSET                    0x0
#define MC_FPRI_CTRL_DCB_0_DISPLAY0AB_PRIVAL_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0AB_PRIVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0AB_PRIVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0AB_PRIVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0AB_PRIVAL_INIT_ENUM                  LOW
#define MC_FPRI_CTRL_DCB_0_DISPLAY0AB_PRIVAL_LOWEST                     _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0AB_PRIVAL_LOW                        _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0AB_PRIVAL_MED                        _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0AB_PRIVAL_HIGH                       _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_DCB_0_DISPLAY0BB_PRIVAL_SHIFT                      _MK_SHIFT_CONST(2)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0BB_PRIVAL_FIELD                      (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_DCB_0_DISPLAY0BB_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0BB_PRIVAL_RANGE                      3:2
#define MC_FPRI_CTRL_DCB_0_DISPLAY0BB_PRIVAL_WOFFSET                    0x0
#define MC_FPRI_CTRL_DCB_0_DISPLAY0BB_PRIVAL_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0BB_PRIVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0BB_PRIVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0BB_PRIVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0BB_PRIVAL_INIT_ENUM                  LOW
#define MC_FPRI_CTRL_DCB_0_DISPLAY0BB_PRIVAL_LOWEST                     _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0BB_PRIVAL_LOW                        _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0BB_PRIVAL_MED                        _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0BB_PRIVAL_HIGH                       _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_DCB_0_DISPLAY0CB_PRIVAL_SHIFT                      _MK_SHIFT_CONST(4)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0CB_PRIVAL_FIELD                      (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_DCB_0_DISPLAY0CB_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0CB_PRIVAL_RANGE                      5:4
#define MC_FPRI_CTRL_DCB_0_DISPLAY0CB_PRIVAL_WOFFSET                    0x0
#define MC_FPRI_CTRL_DCB_0_DISPLAY0CB_PRIVAL_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0CB_PRIVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0CB_PRIVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0CB_PRIVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0CB_PRIVAL_INIT_ENUM                  LOW
#define MC_FPRI_CTRL_DCB_0_DISPLAY0CB_PRIVAL_LOWEST                     _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0CB_PRIVAL_LOW                        _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0CB_PRIVAL_MED                        _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_DCB_0_DISPLAY0CB_PRIVAL_HIGH                       _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_DCB_0_DISPLAY1BB_PRIVAL_SHIFT                      _MK_SHIFT_CONST(6)
#define MC_FPRI_CTRL_DCB_0_DISPLAY1BB_PRIVAL_FIELD                      (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_DCB_0_DISPLAY1BB_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_DCB_0_DISPLAY1BB_PRIVAL_RANGE                      7:6
#define MC_FPRI_CTRL_DCB_0_DISPLAY1BB_PRIVAL_WOFFSET                    0x0
#define MC_FPRI_CTRL_DCB_0_DISPLAY1BB_PRIVAL_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_DCB_0_DISPLAY1BB_PRIVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_DCB_0_DISPLAY1BB_PRIVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DCB_0_DISPLAY1BB_PRIVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DCB_0_DISPLAY1BB_PRIVAL_INIT_ENUM                  LOW
#define MC_FPRI_CTRL_DCB_0_DISPLAY1BB_PRIVAL_LOWEST                     _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_DCB_0_DISPLAY1BB_PRIVAL_LOW                        _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_DCB_0_DISPLAY1BB_PRIVAL_MED                        _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_DCB_0_DISPLAY1BB_PRIVAL_HIGH                       _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_DCB_0_DISPLAYHCB_PRIVAL_SHIFT                      _MK_SHIFT_CONST(8)
#define MC_FPRI_CTRL_DCB_0_DISPLAYHCB_PRIVAL_FIELD                      (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_DCB_0_DISPLAYHCB_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_DCB_0_DISPLAYHCB_PRIVAL_RANGE                      9:8
#define MC_FPRI_CTRL_DCB_0_DISPLAYHCB_PRIVAL_WOFFSET                    0x0
#define MC_FPRI_CTRL_DCB_0_DISPLAYHCB_PRIVAL_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_DCB_0_DISPLAYHCB_PRIVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_DCB_0_DISPLAYHCB_PRIVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DCB_0_DISPLAYHCB_PRIVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_DCB_0_DISPLAYHCB_PRIVAL_INIT_ENUM                  LOW
#define MC_FPRI_CTRL_DCB_0_DISPLAYHCB_PRIVAL_LOWEST                     _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_DCB_0_DISPLAYHCB_PRIVAL_LOW                        _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_DCB_0_DISPLAYHCB_PRIVAL_MED                        _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_DCB_0_DISPLAYHCB_PRIVAL_HIGH                       _MK_ENUM_CONST(3)


// Register MC_FPRI_CTRL_EPP_0  
#define MC_FPRI_CTRL_EPP_0                      _MK_ADDR_CONST(0x188)
#define MC_FPRI_CTRL_EPP_0_SECURE                       0x0
#define MC_FPRI_CTRL_EPP_0_WORD_COUNT                   0x1
#define MC_FPRI_CTRL_EPP_0_RESET_VAL                    _MK_MASK_CONST(0x55)
#define MC_FPRI_CTRL_EPP_0_RESET_MASK                   _MK_MASK_CONST(0xff)
#define MC_FPRI_CTRL_EPP_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_EPP_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_EPP_0_READ_MASK                    _MK_MASK_CONST(0xff)
#define MC_FPRI_CTRL_EPP_0_WRITE_MASK                   _MK_MASK_CONST(0xff)
#define MC_FPRI_CTRL_EPP_0_EPPUP_PRIVAL_SHIFT                   _MK_SHIFT_CONST(0)
#define MC_FPRI_CTRL_EPP_0_EPPUP_PRIVAL_FIELD                   (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_EPP_0_EPPUP_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_EPP_0_EPPUP_PRIVAL_RANGE                   1:0
#define MC_FPRI_CTRL_EPP_0_EPPUP_PRIVAL_WOFFSET                 0x0
#define MC_FPRI_CTRL_EPP_0_EPPUP_PRIVAL_DEFAULT                 _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_EPP_0_EPPUP_PRIVAL_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_EPP_0_EPPUP_PRIVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_EPP_0_EPPUP_PRIVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_EPP_0_EPPUP_PRIVAL_INIT_ENUM                       LOW
#define MC_FPRI_CTRL_EPP_0_EPPUP_PRIVAL_LOWEST                  _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_EPP_0_EPPUP_PRIVAL_LOW                     _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_EPP_0_EPPUP_PRIVAL_MED                     _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_EPP_0_EPPUP_PRIVAL_HIGH                    _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_EPP_0_EPPU_PRIVAL_SHIFT                    _MK_SHIFT_CONST(2)
#define MC_FPRI_CTRL_EPP_0_EPPU_PRIVAL_FIELD                    (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_EPP_0_EPPU_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_EPP_0_EPPU_PRIVAL_RANGE                    3:2
#define MC_FPRI_CTRL_EPP_0_EPPU_PRIVAL_WOFFSET                  0x0
#define MC_FPRI_CTRL_EPP_0_EPPU_PRIVAL_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_EPP_0_EPPU_PRIVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_EPP_0_EPPU_PRIVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_EPP_0_EPPU_PRIVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_EPP_0_EPPU_PRIVAL_INIT_ENUM                        LOW
#define MC_FPRI_CTRL_EPP_0_EPPU_PRIVAL_LOWEST                   _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_EPP_0_EPPU_PRIVAL_LOW                      _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_EPP_0_EPPU_PRIVAL_MED                      _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_EPP_0_EPPU_PRIVAL_HIGH                     _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_EPP_0_EPPV_PRIVAL_SHIFT                    _MK_SHIFT_CONST(4)
#define MC_FPRI_CTRL_EPP_0_EPPV_PRIVAL_FIELD                    (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_EPP_0_EPPV_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_EPP_0_EPPV_PRIVAL_RANGE                    5:4
#define MC_FPRI_CTRL_EPP_0_EPPV_PRIVAL_WOFFSET                  0x0
#define MC_FPRI_CTRL_EPP_0_EPPV_PRIVAL_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_EPP_0_EPPV_PRIVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_EPP_0_EPPV_PRIVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_EPP_0_EPPV_PRIVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_EPP_0_EPPV_PRIVAL_INIT_ENUM                        LOW
#define MC_FPRI_CTRL_EPP_0_EPPV_PRIVAL_LOWEST                   _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_EPP_0_EPPV_PRIVAL_LOW                      _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_EPP_0_EPPV_PRIVAL_MED                      _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_EPP_0_EPPV_PRIVAL_HIGH                     _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_EPP_0_EPPY_PRIVAL_SHIFT                    _MK_SHIFT_CONST(6)
#define MC_FPRI_CTRL_EPP_0_EPPY_PRIVAL_FIELD                    (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_EPP_0_EPPY_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_EPP_0_EPPY_PRIVAL_RANGE                    7:6
#define MC_FPRI_CTRL_EPP_0_EPPY_PRIVAL_WOFFSET                  0x0
#define MC_FPRI_CTRL_EPP_0_EPPY_PRIVAL_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_EPP_0_EPPY_PRIVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_EPP_0_EPPY_PRIVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_EPP_0_EPPY_PRIVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_EPP_0_EPPY_PRIVAL_INIT_ENUM                        LOW
#define MC_FPRI_CTRL_EPP_0_EPPY_PRIVAL_LOWEST                   _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_EPP_0_EPPY_PRIVAL_LOW                      _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_EPP_0_EPPY_PRIVAL_MED                      _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_EPP_0_EPPY_PRIVAL_HIGH                     _MK_ENUM_CONST(3)


// Register MC_FPRI_CTRL_G2_0  
#define MC_FPRI_CTRL_G2_0                       _MK_ADDR_CONST(0x18c)
#define MC_FPRI_CTRL_G2_0_SECURE                        0x0
#define MC_FPRI_CTRL_G2_0_WORD_COUNT                    0x1
#define MC_FPRI_CTRL_G2_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_G2_0_RESET_MASK                    _MK_MASK_CONST(0xff)
#define MC_FPRI_CTRL_G2_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_G2_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_G2_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define MC_FPRI_CTRL_G2_0_WRITE_MASK                    _MK_MASK_CONST(0xff)
#define MC_FPRI_CTRL_G2_0_G2PR_PRIVAL_SHIFT                     _MK_SHIFT_CONST(0)
#define MC_FPRI_CTRL_G2_0_G2PR_PRIVAL_FIELD                     (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_G2_0_G2PR_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_G2_0_G2PR_PRIVAL_RANGE                     1:0
#define MC_FPRI_CTRL_G2_0_G2PR_PRIVAL_WOFFSET                   0x0
#define MC_FPRI_CTRL_G2_0_G2PR_PRIVAL_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_G2_0_G2PR_PRIVAL_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_G2_0_G2PR_PRIVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_G2_0_G2PR_PRIVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_G2_0_G2PR_PRIVAL_INIT_ENUM                 LOWEST
#define MC_FPRI_CTRL_G2_0_G2PR_PRIVAL_LOWEST                    _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_G2_0_G2PR_PRIVAL_LOW                       _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_G2_0_G2PR_PRIVAL_MED                       _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_G2_0_G2PR_PRIVAL_HIGH                      _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_G2_0_G2SR_PRIVAL_SHIFT                     _MK_SHIFT_CONST(2)
#define MC_FPRI_CTRL_G2_0_G2SR_PRIVAL_FIELD                     (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_G2_0_G2SR_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_G2_0_G2SR_PRIVAL_RANGE                     3:2
#define MC_FPRI_CTRL_G2_0_G2SR_PRIVAL_WOFFSET                   0x0
#define MC_FPRI_CTRL_G2_0_G2SR_PRIVAL_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_G2_0_G2SR_PRIVAL_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_G2_0_G2SR_PRIVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_G2_0_G2SR_PRIVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_G2_0_G2SR_PRIVAL_INIT_ENUM                 LOWEST
#define MC_FPRI_CTRL_G2_0_G2SR_PRIVAL_LOWEST                    _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_G2_0_G2SR_PRIVAL_LOW                       _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_G2_0_G2SR_PRIVAL_MED                       _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_G2_0_G2SR_PRIVAL_HIGH                      _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_G2_0_G2DR_PRIVAL_SHIFT                     _MK_SHIFT_CONST(4)
#define MC_FPRI_CTRL_G2_0_G2DR_PRIVAL_FIELD                     (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_G2_0_G2DR_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_G2_0_G2DR_PRIVAL_RANGE                     5:4
#define MC_FPRI_CTRL_G2_0_G2DR_PRIVAL_WOFFSET                   0x0
#define MC_FPRI_CTRL_G2_0_G2DR_PRIVAL_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_G2_0_G2DR_PRIVAL_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_G2_0_G2DR_PRIVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_G2_0_G2DR_PRIVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_G2_0_G2DR_PRIVAL_INIT_ENUM                 LOWEST
#define MC_FPRI_CTRL_G2_0_G2DR_PRIVAL_LOWEST                    _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_G2_0_G2DR_PRIVAL_LOW                       _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_G2_0_G2DR_PRIVAL_MED                       _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_G2_0_G2DR_PRIVAL_HIGH                      _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_G2_0_G2DW_PRIVAL_SHIFT                     _MK_SHIFT_CONST(6)
#define MC_FPRI_CTRL_G2_0_G2DW_PRIVAL_FIELD                     (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_G2_0_G2DW_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_G2_0_G2DW_PRIVAL_RANGE                     7:6
#define MC_FPRI_CTRL_G2_0_G2DW_PRIVAL_WOFFSET                   0x0
#define MC_FPRI_CTRL_G2_0_G2DW_PRIVAL_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_G2_0_G2DW_PRIVAL_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_G2_0_G2DW_PRIVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_G2_0_G2DW_PRIVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_G2_0_G2DW_PRIVAL_INIT_ENUM                 LOWEST
#define MC_FPRI_CTRL_G2_0_G2DW_PRIVAL_LOWEST                    _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_G2_0_G2DW_PRIVAL_LOW                       _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_G2_0_G2DW_PRIVAL_MED                       _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_G2_0_G2DW_PRIVAL_HIGH                      _MK_ENUM_CONST(3)


// Register MC_FPRI_CTRL_HC_0  
#define MC_FPRI_CTRL_HC_0                       _MK_ADDR_CONST(0x190)
#define MC_FPRI_CTRL_HC_0_SECURE                        0x0
#define MC_FPRI_CTRL_HC_0_WORD_COUNT                    0x1
#define MC_FPRI_CTRL_HC_0_RESET_VAL                     _MK_MASK_CONST(0x15)
#define MC_FPRI_CTRL_HC_0_RESET_MASK                    _MK_MASK_CONST(0x3f)
#define MC_FPRI_CTRL_HC_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_HC_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_HC_0_READ_MASK                     _MK_MASK_CONST(0x3f)
#define MC_FPRI_CTRL_HC_0_WRITE_MASK                    _MK_MASK_CONST(0x3f)
#define MC_FPRI_CTRL_HC_0_HOST1XDMAR_PRIVAL_SHIFT                       _MK_SHIFT_CONST(0)
#define MC_FPRI_CTRL_HC_0_HOST1XDMAR_PRIVAL_FIELD                       (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_HC_0_HOST1XDMAR_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_HC_0_HOST1XDMAR_PRIVAL_RANGE                       1:0
#define MC_FPRI_CTRL_HC_0_HOST1XDMAR_PRIVAL_WOFFSET                     0x0
#define MC_FPRI_CTRL_HC_0_HOST1XDMAR_PRIVAL_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_HC_0_HOST1XDMAR_PRIVAL_DEFAULT_MASK                        _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_HC_0_HOST1XDMAR_PRIVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_HC_0_HOST1XDMAR_PRIVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_HC_0_HOST1XDMAR_PRIVAL_INIT_ENUM                   LOW
#define MC_FPRI_CTRL_HC_0_HOST1XDMAR_PRIVAL_LOWEST                      _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_HC_0_HOST1XDMAR_PRIVAL_LOW                 _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_HC_0_HOST1XDMAR_PRIVAL_MED                 _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_HC_0_HOST1XDMAR_PRIVAL_HIGH                        _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_HC_0_HOST1XR_PRIVAL_SHIFT                  _MK_SHIFT_CONST(2)
#define MC_FPRI_CTRL_HC_0_HOST1XR_PRIVAL_FIELD                  (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_HC_0_HOST1XR_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_HC_0_HOST1XR_PRIVAL_RANGE                  3:2
#define MC_FPRI_CTRL_HC_0_HOST1XR_PRIVAL_WOFFSET                        0x0
#define MC_FPRI_CTRL_HC_0_HOST1XR_PRIVAL_DEFAULT                        _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_HC_0_HOST1XR_PRIVAL_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_HC_0_HOST1XR_PRIVAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_HC_0_HOST1XR_PRIVAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_HC_0_HOST1XR_PRIVAL_INIT_ENUM                      LOW
#define MC_FPRI_CTRL_HC_0_HOST1XR_PRIVAL_LOWEST                 _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_HC_0_HOST1XR_PRIVAL_LOW                    _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_HC_0_HOST1XR_PRIVAL_MED                    _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_HC_0_HOST1XR_PRIVAL_HIGH                   _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_HC_0_HOST1XW_PRIVAL_SHIFT                  _MK_SHIFT_CONST(4)
#define MC_FPRI_CTRL_HC_0_HOST1XW_PRIVAL_FIELD                  (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_HC_0_HOST1XW_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_HC_0_HOST1XW_PRIVAL_RANGE                  5:4
#define MC_FPRI_CTRL_HC_0_HOST1XW_PRIVAL_WOFFSET                        0x0
#define MC_FPRI_CTRL_HC_0_HOST1XW_PRIVAL_DEFAULT                        _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_HC_0_HOST1XW_PRIVAL_DEFAULT_MASK                   _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_HC_0_HOST1XW_PRIVAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_HC_0_HOST1XW_PRIVAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_HC_0_HOST1XW_PRIVAL_INIT_ENUM                      LOW
#define MC_FPRI_CTRL_HC_0_HOST1XW_PRIVAL_LOWEST                 _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_HC_0_HOST1XW_PRIVAL_LOW                    _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_HC_0_HOST1XW_PRIVAL_MED                    _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_HC_0_HOST1XW_PRIVAL_HIGH                   _MK_ENUM_CONST(3)


// Register MC_FPRI_CTRL_ISP_0  
#define MC_FPRI_CTRL_ISP_0                      _MK_ADDR_CONST(0x194)
#define MC_FPRI_CTRL_ISP_0_SECURE                       0x0
#define MC_FPRI_CTRL_ISP_0_WORD_COUNT                   0x1
#define MC_FPRI_CTRL_ISP_0_RESET_VAL                    _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_ISP_0_RESET_MASK                   _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_ISP_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_ISP_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_ISP_0_READ_MASK                    _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_ISP_0_WRITE_MASK                   _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_ISP_0_ISPW_PRIVAL_SHIFT                    _MK_SHIFT_CONST(0)
#define MC_FPRI_CTRL_ISP_0_ISPW_PRIVAL_FIELD                    (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_ISP_0_ISPW_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_ISP_0_ISPW_PRIVAL_RANGE                    1:0
#define MC_FPRI_CTRL_ISP_0_ISPW_PRIVAL_WOFFSET                  0x0
#define MC_FPRI_CTRL_ISP_0_ISPW_PRIVAL_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_ISP_0_ISPW_PRIVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_ISP_0_ISPW_PRIVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_ISP_0_ISPW_PRIVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_ISP_0_ISPW_PRIVAL_INIT_ENUM                        LOW
#define MC_FPRI_CTRL_ISP_0_ISPW_PRIVAL_LOWEST                   _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_ISP_0_ISPW_PRIVAL_LOW                      _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_ISP_0_ISPW_PRIVAL_MED                      _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_ISP_0_ISPW_PRIVAL_HIGH                     _MK_ENUM_CONST(3)


// Register MC_FPRI_CTRL_MPCORE_0  
#define MC_FPRI_CTRL_MPCORE_0                   _MK_ADDR_CONST(0x198)
#define MC_FPRI_CTRL_MPCORE_0_SECURE                    0x0
#define MC_FPRI_CTRL_MPCORE_0_WORD_COUNT                        0x1
#define MC_FPRI_CTRL_MPCORE_0_RESET_VAL                         _MK_MASK_CONST(0x5)
#define MC_FPRI_CTRL_MPCORE_0_RESET_MASK                        _MK_MASK_CONST(0xf)
#define MC_FPRI_CTRL_MPCORE_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPCORE_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPCORE_0_READ_MASK                         _MK_MASK_CONST(0xf)
#define MC_FPRI_CTRL_MPCORE_0_WRITE_MASK                        _MK_MASK_CONST(0xf)
#define MC_FPRI_CTRL_MPCORE_0_MPCORER_PRIVAL_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_FPRI_CTRL_MPCORE_0_MPCORER_PRIVAL_FIELD                      (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_MPCORE_0_MPCORER_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_MPCORE_0_MPCORER_PRIVAL_RANGE                      1:0
#define MC_FPRI_CTRL_MPCORE_0_MPCORER_PRIVAL_WOFFSET                    0x0
#define MC_FPRI_CTRL_MPCORE_0_MPCORER_PRIVAL_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_MPCORE_0_MPCORER_PRIVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_MPCORE_0_MPCORER_PRIVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPCORE_0_MPCORER_PRIVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPCORE_0_MPCORER_PRIVAL_INIT_ENUM                  LOW
#define MC_FPRI_CTRL_MPCORE_0_MPCORER_PRIVAL_LOWEST                     _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_MPCORE_0_MPCORER_PRIVAL_LOW                        _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_MPCORE_0_MPCORER_PRIVAL_MED                        _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_MPCORE_0_MPCORER_PRIVAL_HIGH                       _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_MPCORE_0_MPCOREW_PRIVAL_SHIFT                      _MK_SHIFT_CONST(2)
#define MC_FPRI_CTRL_MPCORE_0_MPCOREW_PRIVAL_FIELD                      (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_MPCORE_0_MPCOREW_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_MPCORE_0_MPCOREW_PRIVAL_RANGE                      3:2
#define MC_FPRI_CTRL_MPCORE_0_MPCOREW_PRIVAL_WOFFSET                    0x0
#define MC_FPRI_CTRL_MPCORE_0_MPCOREW_PRIVAL_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_MPCORE_0_MPCOREW_PRIVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_MPCORE_0_MPCOREW_PRIVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPCORE_0_MPCOREW_PRIVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPCORE_0_MPCOREW_PRIVAL_INIT_ENUM                  LOW
#define MC_FPRI_CTRL_MPCORE_0_MPCOREW_PRIVAL_LOWEST                     _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_MPCORE_0_MPCOREW_PRIVAL_LOW                        _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_MPCORE_0_MPCOREW_PRIVAL_MED                        _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_MPCORE_0_MPCOREW_PRIVAL_HIGH                       _MK_ENUM_CONST(3)


// Register MC_FPRI_CTRL_MPEA_0  
#define MC_FPRI_CTRL_MPEA_0                     _MK_ADDR_CONST(0x19c)
#define MC_FPRI_CTRL_MPEA_0_SECURE                      0x0
#define MC_FPRI_CTRL_MPEA_0_WORD_COUNT                  0x1
#define MC_FPRI_CTRL_MPEA_0_RESET_VAL                   _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_MPEA_0_RESET_MASK                  _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_MPEA_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEA_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEA_0_READ_MASK                   _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_MPEA_0_WRITE_MASK                  _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_MPEA_0_MPEAMEMRD_PRIVAL_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_FPRI_CTRL_MPEA_0_MPEAMEMRD_PRIVAL_FIELD                      (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_MPEA_0_MPEAMEMRD_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_MPEA_0_MPEAMEMRD_PRIVAL_RANGE                      1:0
#define MC_FPRI_CTRL_MPEA_0_MPEAMEMRD_PRIVAL_WOFFSET                    0x0
#define MC_FPRI_CTRL_MPEA_0_MPEAMEMRD_PRIVAL_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_MPEA_0_MPEAMEMRD_PRIVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_MPEA_0_MPEAMEMRD_PRIVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEA_0_MPEAMEMRD_PRIVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEA_0_MPEAMEMRD_PRIVAL_INIT_ENUM                  LOW
#define MC_FPRI_CTRL_MPEA_0_MPEAMEMRD_PRIVAL_LOWEST                     _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_MPEA_0_MPEAMEMRD_PRIVAL_LOW                        _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_MPEA_0_MPEAMEMRD_PRIVAL_MED                        _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_MPEA_0_MPEAMEMRD_PRIVAL_HIGH                       _MK_ENUM_CONST(3)


// Register MC_FPRI_CTRL_MPEB_0  
#define MC_FPRI_CTRL_MPEB_0                     _MK_ADDR_CONST(0x1a0)
#define MC_FPRI_CTRL_MPEB_0_SECURE                      0x0
#define MC_FPRI_CTRL_MPEB_0_WORD_COUNT                  0x1
#define MC_FPRI_CTRL_MPEB_0_RESET_VAL                   _MK_MASK_CONST(0x15)
#define MC_FPRI_CTRL_MPEB_0_RESET_MASK                  _MK_MASK_CONST(0x3f)
#define MC_FPRI_CTRL_MPEB_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEB_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEB_0_READ_MASK                   _MK_MASK_CONST(0x3f)
#define MC_FPRI_CTRL_MPEB_0_WRITE_MASK                  _MK_MASK_CONST(0x3f)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBR_PRIVAL_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBR_PRIVAL_FIELD                      (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_MPEB_0_MPEUNIFBR_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBR_PRIVAL_RANGE                      1:0
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBR_PRIVAL_WOFFSET                    0x0
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBR_PRIVAL_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBR_PRIVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBR_PRIVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBR_PRIVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBR_PRIVAL_INIT_ENUM                  LOW
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBR_PRIVAL_LOWEST                     _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBR_PRIVAL_LOW                        _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBR_PRIVAL_MED                        _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBR_PRIVAL_HIGH                       _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_MPEB_0_MPE_IPRED_PRIVAL_SHIFT                      _MK_SHIFT_CONST(2)
#define MC_FPRI_CTRL_MPEB_0_MPE_IPRED_PRIVAL_FIELD                      (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_MPEB_0_MPE_IPRED_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_MPEB_0_MPE_IPRED_PRIVAL_RANGE                      3:2
#define MC_FPRI_CTRL_MPEB_0_MPE_IPRED_PRIVAL_WOFFSET                    0x0
#define MC_FPRI_CTRL_MPEB_0_MPE_IPRED_PRIVAL_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_MPEB_0_MPE_IPRED_PRIVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_MPEB_0_MPE_IPRED_PRIVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEB_0_MPE_IPRED_PRIVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEB_0_MPE_IPRED_PRIVAL_INIT_ENUM                  LOW
#define MC_FPRI_CTRL_MPEB_0_MPE_IPRED_PRIVAL_LOWEST                     _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_MPEB_0_MPE_IPRED_PRIVAL_LOW                        _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_MPEB_0_MPE_IPRED_PRIVAL_MED                        _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_MPEB_0_MPE_IPRED_PRIVAL_HIGH                       _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBW_PRIVAL_SHIFT                      _MK_SHIFT_CONST(4)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBW_PRIVAL_FIELD                      (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_MPEB_0_MPEUNIFBW_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBW_PRIVAL_RANGE                      5:4
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBW_PRIVAL_WOFFSET                    0x0
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBW_PRIVAL_DEFAULT                    _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBW_PRIVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBW_PRIVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBW_PRIVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBW_PRIVAL_INIT_ENUM                  LOW
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBW_PRIVAL_LOWEST                     _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBW_PRIVAL_LOW                        _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBW_PRIVAL_MED                        _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_MPEB_0_MPEUNIFBW_PRIVAL_HIGH                       _MK_ENUM_CONST(3)


// Register MC_FPRI_CTRL_MPEC_0  
#define MC_FPRI_CTRL_MPEC_0                     _MK_ADDR_CONST(0x1a4)
#define MC_FPRI_CTRL_MPEC_0_SECURE                      0x0
#define MC_FPRI_CTRL_MPEC_0_WORD_COUNT                  0x1
#define MC_FPRI_CTRL_MPEC_0_RESET_VAL                   _MK_MASK_CONST(0x5)
#define MC_FPRI_CTRL_MPEC_0_RESET_MASK                  _MK_MASK_CONST(0xf)
#define MC_FPRI_CTRL_MPEC_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEC_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEC_0_READ_MASK                   _MK_MASK_CONST(0xf)
#define MC_FPRI_CTRL_MPEC_0_WRITE_MASK                  _MK_MASK_CONST(0xf)
#define MC_FPRI_CTRL_MPEC_0_MPECSRD_PRIVAL_SHIFT                        _MK_SHIFT_CONST(0)
#define MC_FPRI_CTRL_MPEC_0_MPECSRD_PRIVAL_FIELD                        (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_MPEC_0_MPECSRD_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_MPEC_0_MPECSRD_PRIVAL_RANGE                        1:0
#define MC_FPRI_CTRL_MPEC_0_MPECSRD_PRIVAL_WOFFSET                      0x0
#define MC_FPRI_CTRL_MPEC_0_MPECSRD_PRIVAL_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_MPEC_0_MPECSRD_PRIVAL_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_MPEC_0_MPECSRD_PRIVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEC_0_MPECSRD_PRIVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEC_0_MPECSRD_PRIVAL_INIT_ENUM                    LOW
#define MC_FPRI_CTRL_MPEC_0_MPECSRD_PRIVAL_LOWEST                       _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_MPEC_0_MPECSRD_PRIVAL_LOW                  _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_MPEC_0_MPECSRD_PRIVAL_MED                  _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_MPEC_0_MPECSRD_PRIVAL_HIGH                 _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_MPEC_0_MPECSWR_PRIVAL_SHIFT                        _MK_SHIFT_CONST(2)
#define MC_FPRI_CTRL_MPEC_0_MPECSWR_PRIVAL_FIELD                        (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_MPEC_0_MPECSWR_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_MPEC_0_MPECSWR_PRIVAL_RANGE                        3:2
#define MC_FPRI_CTRL_MPEC_0_MPECSWR_PRIVAL_WOFFSET                      0x0
#define MC_FPRI_CTRL_MPEC_0_MPECSWR_PRIVAL_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_MPEC_0_MPECSWR_PRIVAL_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_MPEC_0_MPECSWR_PRIVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEC_0_MPECSWR_PRIVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_MPEC_0_MPECSWR_PRIVAL_INIT_ENUM                    LOW
#define MC_FPRI_CTRL_MPEC_0_MPECSWR_PRIVAL_LOWEST                       _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_MPEC_0_MPECSWR_PRIVAL_LOW                  _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_MPEC_0_MPECSWR_PRIVAL_MED                  _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_MPEC_0_MPECSWR_PRIVAL_HIGH                 _MK_ENUM_CONST(3)


// Register MC_FPRI_CTRL_NV_0  
#define MC_FPRI_CTRL_NV_0                       _MK_ADDR_CONST(0x1a8)
#define MC_FPRI_CTRL_NV_0_SECURE                        0x0
#define MC_FPRI_CTRL_NV_0_WORD_COUNT                    0x1
#define MC_FPRI_CTRL_NV_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_NV_0_RESET_MASK                    _MK_MASK_CONST(0xff)
#define MC_FPRI_CTRL_NV_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_NV_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_NV_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define MC_FPRI_CTRL_NV_0_WRITE_MASK                    _MK_MASK_CONST(0xff)
#define MC_FPRI_CTRL_NV_0_FDCDRD_PRIVAL_SHIFT                   _MK_SHIFT_CONST(0)
#define MC_FPRI_CTRL_NV_0_FDCDRD_PRIVAL_FIELD                   (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_NV_0_FDCDRD_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_NV_0_FDCDRD_PRIVAL_RANGE                   1:0
#define MC_FPRI_CTRL_NV_0_FDCDRD_PRIVAL_WOFFSET                 0x0
#define MC_FPRI_CTRL_NV_0_FDCDRD_PRIVAL_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_NV_0_FDCDRD_PRIVAL_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_NV_0_FDCDRD_PRIVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_NV_0_FDCDRD_PRIVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_NV_0_FDCDRD_PRIVAL_INIT_ENUM                       LOWEST
#define MC_FPRI_CTRL_NV_0_FDCDRD_PRIVAL_LOWEST                  _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_NV_0_FDCDRD_PRIVAL_LOW                     _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_NV_0_FDCDRD_PRIVAL_MED                     _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_NV_0_FDCDRD_PRIVAL_HIGH                    _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_NV_0_IDXSRD_PRIVAL_SHIFT                   _MK_SHIFT_CONST(2)
#define MC_FPRI_CTRL_NV_0_IDXSRD_PRIVAL_FIELD                   (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_NV_0_IDXSRD_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_NV_0_IDXSRD_PRIVAL_RANGE                   3:2
#define MC_FPRI_CTRL_NV_0_IDXSRD_PRIVAL_WOFFSET                 0x0
#define MC_FPRI_CTRL_NV_0_IDXSRD_PRIVAL_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_NV_0_IDXSRD_PRIVAL_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_NV_0_IDXSRD_PRIVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_NV_0_IDXSRD_PRIVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_NV_0_IDXSRD_PRIVAL_INIT_ENUM                       LOWEST
#define MC_FPRI_CTRL_NV_0_IDXSRD_PRIVAL_LOWEST                  _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_NV_0_IDXSRD_PRIVAL_LOW                     _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_NV_0_IDXSRD_PRIVAL_MED                     _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_NV_0_IDXSRD_PRIVAL_HIGH                    _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_NV_0_TEXSRD_PRIVAL_SHIFT                   _MK_SHIFT_CONST(4)
#define MC_FPRI_CTRL_NV_0_TEXSRD_PRIVAL_FIELD                   (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_NV_0_TEXSRD_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_NV_0_TEXSRD_PRIVAL_RANGE                   5:4
#define MC_FPRI_CTRL_NV_0_TEXSRD_PRIVAL_WOFFSET                 0x0
#define MC_FPRI_CTRL_NV_0_TEXSRD_PRIVAL_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_NV_0_TEXSRD_PRIVAL_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_NV_0_TEXSRD_PRIVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_NV_0_TEXSRD_PRIVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_NV_0_TEXSRD_PRIVAL_INIT_ENUM                       LOWEST
#define MC_FPRI_CTRL_NV_0_TEXSRD_PRIVAL_LOWEST                  _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_NV_0_TEXSRD_PRIVAL_LOW                     _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_NV_0_TEXSRD_PRIVAL_MED                     _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_NV_0_TEXSRD_PRIVAL_HIGH                    _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_NV_0_FDCDWR_PRIVAL_SHIFT                   _MK_SHIFT_CONST(6)
#define MC_FPRI_CTRL_NV_0_FDCDWR_PRIVAL_FIELD                   (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_NV_0_FDCDWR_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_NV_0_FDCDWR_PRIVAL_RANGE                   7:6
#define MC_FPRI_CTRL_NV_0_FDCDWR_PRIVAL_WOFFSET                 0x0
#define MC_FPRI_CTRL_NV_0_FDCDWR_PRIVAL_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_NV_0_FDCDWR_PRIVAL_DEFAULT_MASK                    _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_NV_0_FDCDWR_PRIVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_NV_0_FDCDWR_PRIVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_NV_0_FDCDWR_PRIVAL_INIT_ENUM                       LOWEST
#define MC_FPRI_CTRL_NV_0_FDCDWR_PRIVAL_LOWEST                  _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_NV_0_FDCDWR_PRIVAL_LOW                     _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_NV_0_FDCDWR_PRIVAL_MED                     _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_NV_0_FDCDWR_PRIVAL_HIGH                    _MK_ENUM_CONST(3)


// Register MC_FPRI_CTRL_PPCS_0  
#define MC_FPRI_CTRL_PPCS_0                     _MK_ADDR_CONST(0x1ac)
#define MC_FPRI_CTRL_PPCS_0_SECURE                      0x0
#define MC_FPRI_CTRL_PPCS_0_WORD_COUNT                  0x1
#define MC_FPRI_CTRL_PPCS_0_RESET_VAL                   _MK_MASK_CONST(0x55)
#define MC_FPRI_CTRL_PPCS_0_RESET_MASK                  _MK_MASK_CONST(0xff)
#define MC_FPRI_CTRL_PPCS_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_PPCS_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_PPCS_0_READ_MASK                   _MK_MASK_CONST(0xff)
#define MC_FPRI_CTRL_PPCS_0_WRITE_MASK                  _MK_MASK_CONST(0xff)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAR_PRIVAL_SHIFT                    _MK_SHIFT_CONST(0)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAR_PRIVAL_FIELD                    (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAR_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAR_PRIVAL_RANGE                    1:0
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAR_PRIVAL_WOFFSET                  0x0
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAR_PRIVAL_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAR_PRIVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAR_PRIVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAR_PRIVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAR_PRIVAL_INIT_ENUM                        LOW
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAR_PRIVAL_LOWEST                   _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAR_PRIVAL_LOW                      _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAR_PRIVAL_MED                      _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAR_PRIVAL_HIGH                     _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVR_PRIVAL_SHIFT                    _MK_SHIFT_CONST(2)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVR_PRIVAL_FIELD                    (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVR_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVR_PRIVAL_RANGE                    3:2
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVR_PRIVAL_WOFFSET                  0x0
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVR_PRIVAL_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVR_PRIVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVR_PRIVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVR_PRIVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVR_PRIVAL_INIT_ENUM                        LOW
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVR_PRIVAL_LOWEST                   _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVR_PRIVAL_LOW                      _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVR_PRIVAL_MED                      _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVR_PRIVAL_HIGH                     _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAW_PRIVAL_SHIFT                    _MK_SHIFT_CONST(4)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAW_PRIVAL_FIELD                    (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAW_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAW_PRIVAL_RANGE                    5:4
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAW_PRIVAL_WOFFSET                  0x0
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAW_PRIVAL_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAW_PRIVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAW_PRIVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAW_PRIVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAW_PRIVAL_INIT_ENUM                        LOW
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAW_PRIVAL_LOWEST                   _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAW_PRIVAL_LOW                      _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAW_PRIVAL_MED                      _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBDMAW_PRIVAL_HIGH                     _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVW_PRIVAL_SHIFT                    _MK_SHIFT_CONST(6)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVW_PRIVAL_FIELD                    (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVW_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVW_PRIVAL_RANGE                    7:6
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVW_PRIVAL_WOFFSET                  0x0
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVW_PRIVAL_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVW_PRIVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVW_PRIVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVW_PRIVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVW_PRIVAL_INIT_ENUM                        LOW
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVW_PRIVAL_LOWEST                   _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVW_PRIVAL_LOW                      _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVW_PRIVAL_MED                      _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_PPCS_0_PPCSAHBSLVW_PRIVAL_HIGH                     _MK_ENUM_CONST(3)


// Register MC_FPRI_CTRL_VDE_0  
#define MC_FPRI_CTRL_VDE_0                      _MK_ADDR_CONST(0x1b0)
#define MC_FPRI_CTRL_VDE_0_SECURE                       0x0
#define MC_FPRI_CTRL_VDE_0_WORD_COUNT                   0x1
#define MC_FPRI_CTRL_VDE_0_RESET_VAL                    _MK_MASK_CONST(0x1555)
#define MC_FPRI_CTRL_VDE_0_RESET_MASK                   _MK_MASK_CONST(0x3fff)
#define MC_FPRI_CTRL_VDE_0_SW_DEFAULT_VAL                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VDE_0_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VDE_0_READ_MASK                    _MK_MASK_CONST(0x3fff)
#define MC_FPRI_CTRL_VDE_0_WRITE_MASK                   _MK_MASK_CONST(0x3fff)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVR_PRIVAL_SHIFT                        _MK_SHIFT_CONST(0)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVR_PRIVAL_FIELD                        (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_VDE_0_VDEBSEVR_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVR_PRIVAL_RANGE                        1:0
#define MC_FPRI_CTRL_VDE_0_VDEBSEVR_PRIVAL_WOFFSET                      0x0
#define MC_FPRI_CTRL_VDE_0_VDEBSEVR_PRIVAL_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVR_PRIVAL_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVR_PRIVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVR_PRIVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVR_PRIVAL_INIT_ENUM                    LOW
#define MC_FPRI_CTRL_VDE_0_VDEBSEVR_PRIVAL_LOWEST                       _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVR_PRIVAL_LOW                  _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVR_PRIVAL_MED                  _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVR_PRIVAL_HIGH                 _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_VDE_0_VDEMBER_PRIVAL_SHIFT                 _MK_SHIFT_CONST(2)
#define MC_FPRI_CTRL_VDE_0_VDEMBER_PRIVAL_FIELD                 (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_VDE_0_VDEMBER_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_VDE_0_VDEMBER_PRIVAL_RANGE                 3:2
#define MC_FPRI_CTRL_VDE_0_VDEMBER_PRIVAL_WOFFSET                       0x0
#define MC_FPRI_CTRL_VDE_0_VDEMBER_PRIVAL_DEFAULT                       _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_VDE_0_VDEMBER_PRIVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_VDE_0_VDEMBER_PRIVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VDE_0_VDEMBER_PRIVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VDE_0_VDEMBER_PRIVAL_INIT_ENUM                     LOW
#define MC_FPRI_CTRL_VDE_0_VDEMBER_PRIVAL_LOWEST                        _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_VDE_0_VDEMBER_PRIVAL_LOW                   _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_VDE_0_VDEMBER_PRIVAL_MED                   _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_VDE_0_VDEMBER_PRIVAL_HIGH                  _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_VDE_0_VDEMCER_PRIVAL_SHIFT                 _MK_SHIFT_CONST(4)
#define MC_FPRI_CTRL_VDE_0_VDEMCER_PRIVAL_FIELD                 (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_VDE_0_VDEMCER_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_VDE_0_VDEMCER_PRIVAL_RANGE                 5:4
#define MC_FPRI_CTRL_VDE_0_VDEMCER_PRIVAL_WOFFSET                       0x0
#define MC_FPRI_CTRL_VDE_0_VDEMCER_PRIVAL_DEFAULT                       _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_VDE_0_VDEMCER_PRIVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_VDE_0_VDEMCER_PRIVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VDE_0_VDEMCER_PRIVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VDE_0_VDEMCER_PRIVAL_INIT_ENUM                     LOW
#define MC_FPRI_CTRL_VDE_0_VDEMCER_PRIVAL_LOWEST                        _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_VDE_0_VDEMCER_PRIVAL_LOW                   _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_VDE_0_VDEMCER_PRIVAL_MED                   _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_VDE_0_VDEMCER_PRIVAL_HIGH                  _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_VDE_0_VDETPER_PRIVAL_SHIFT                 _MK_SHIFT_CONST(6)
#define MC_FPRI_CTRL_VDE_0_VDETPER_PRIVAL_FIELD                 (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_VDE_0_VDETPER_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_VDE_0_VDETPER_PRIVAL_RANGE                 7:6
#define MC_FPRI_CTRL_VDE_0_VDETPER_PRIVAL_WOFFSET                       0x0
#define MC_FPRI_CTRL_VDE_0_VDETPER_PRIVAL_DEFAULT                       _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_VDE_0_VDETPER_PRIVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_VDE_0_VDETPER_PRIVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VDE_0_VDETPER_PRIVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VDE_0_VDETPER_PRIVAL_INIT_ENUM                     LOW
#define MC_FPRI_CTRL_VDE_0_VDETPER_PRIVAL_LOWEST                        _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_VDE_0_VDETPER_PRIVAL_LOW                   _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_VDE_0_VDETPER_PRIVAL_MED                   _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_VDE_0_VDETPER_PRIVAL_HIGH                  _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_VDE_0_VDEBSEVW_PRIVAL_SHIFT                        _MK_SHIFT_CONST(8)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVW_PRIVAL_FIELD                        (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_VDE_0_VDEBSEVW_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVW_PRIVAL_RANGE                        9:8
#define MC_FPRI_CTRL_VDE_0_VDEBSEVW_PRIVAL_WOFFSET                      0x0
#define MC_FPRI_CTRL_VDE_0_VDEBSEVW_PRIVAL_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVW_PRIVAL_DEFAULT_MASK                 _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVW_PRIVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVW_PRIVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVW_PRIVAL_INIT_ENUM                    LOW
#define MC_FPRI_CTRL_VDE_0_VDEBSEVW_PRIVAL_LOWEST                       _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVW_PRIVAL_LOW                  _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVW_PRIVAL_MED                  _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_VDE_0_VDEBSEVW_PRIVAL_HIGH                 _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_VDE_0_VDEMBEW_PRIVAL_SHIFT                 _MK_SHIFT_CONST(10)
#define MC_FPRI_CTRL_VDE_0_VDEMBEW_PRIVAL_FIELD                 (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_VDE_0_VDEMBEW_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_VDE_0_VDEMBEW_PRIVAL_RANGE                 11:10
#define MC_FPRI_CTRL_VDE_0_VDEMBEW_PRIVAL_WOFFSET                       0x0
#define MC_FPRI_CTRL_VDE_0_VDEMBEW_PRIVAL_DEFAULT                       _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_VDE_0_VDEMBEW_PRIVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_VDE_0_VDEMBEW_PRIVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VDE_0_VDEMBEW_PRIVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VDE_0_VDEMBEW_PRIVAL_INIT_ENUM                     LOW
#define MC_FPRI_CTRL_VDE_0_VDEMBEW_PRIVAL_LOWEST                        _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_VDE_0_VDEMBEW_PRIVAL_LOW                   _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_VDE_0_VDEMBEW_PRIVAL_MED                   _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_VDE_0_VDEMBEW_PRIVAL_HIGH                  _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_VDE_0_VDETPMW_PRIVAL_SHIFT                 _MK_SHIFT_CONST(12)
#define MC_FPRI_CTRL_VDE_0_VDETPMW_PRIVAL_FIELD                 (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_VDE_0_VDETPMW_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_VDE_0_VDETPMW_PRIVAL_RANGE                 13:12
#define MC_FPRI_CTRL_VDE_0_VDETPMW_PRIVAL_WOFFSET                       0x0
#define MC_FPRI_CTRL_VDE_0_VDETPMW_PRIVAL_DEFAULT                       _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_VDE_0_VDETPMW_PRIVAL_DEFAULT_MASK                  _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_VDE_0_VDETPMW_PRIVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VDE_0_VDETPMW_PRIVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VDE_0_VDETPMW_PRIVAL_INIT_ENUM                     LOW
#define MC_FPRI_CTRL_VDE_0_VDETPMW_PRIVAL_LOWEST                        _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_VDE_0_VDETPMW_PRIVAL_LOW                   _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_VDE_0_VDETPMW_PRIVAL_MED                   _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_VDE_0_VDETPMW_PRIVAL_HIGH                  _MK_ENUM_CONST(3)


// Register MC_FPRI_CTRL_VI_0  
#define MC_FPRI_CTRL_VI_0                       _MK_ADDR_CONST(0x1b4)
#define MC_FPRI_CTRL_VI_0_SECURE                        0x0
#define MC_FPRI_CTRL_VI_0_WORD_COUNT                    0x1
#define MC_FPRI_CTRL_VI_0_RESET_VAL                     _MK_MASK_CONST(0x155)
#define MC_FPRI_CTRL_VI_0_RESET_MASK                    _MK_MASK_CONST(0x3ff)
#define MC_FPRI_CTRL_VI_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VI_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VI_0_READ_MASK                     _MK_MASK_CONST(0x3ff)
#define MC_FPRI_CTRL_VI_0_WRITE_MASK                    _MK_MASK_CONST(0x3ff)
#define MC_FPRI_CTRL_VI_0_VIRUV_PRIVAL_SHIFT                    _MK_SHIFT_CONST(0)
#define MC_FPRI_CTRL_VI_0_VIRUV_PRIVAL_FIELD                    (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_VI_0_VIRUV_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_VI_0_VIRUV_PRIVAL_RANGE                    1:0
#define MC_FPRI_CTRL_VI_0_VIRUV_PRIVAL_WOFFSET                  0x0
#define MC_FPRI_CTRL_VI_0_VIRUV_PRIVAL_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_VI_0_VIRUV_PRIVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_VI_0_VIRUV_PRIVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VI_0_VIRUV_PRIVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VI_0_VIRUV_PRIVAL_INIT_ENUM                        LOW
#define MC_FPRI_CTRL_VI_0_VIRUV_PRIVAL_LOWEST                   _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_VI_0_VIRUV_PRIVAL_LOW                      _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_VI_0_VIRUV_PRIVAL_MED                      _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_VI_0_VIRUV_PRIVAL_HIGH                     _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_VI_0_VIWSB_PRIVAL_SHIFT                    _MK_SHIFT_CONST(2)
#define MC_FPRI_CTRL_VI_0_VIWSB_PRIVAL_FIELD                    (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_VI_0_VIWSB_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_VI_0_VIWSB_PRIVAL_RANGE                    3:2
#define MC_FPRI_CTRL_VI_0_VIWSB_PRIVAL_WOFFSET                  0x0
#define MC_FPRI_CTRL_VI_0_VIWSB_PRIVAL_DEFAULT                  _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_VI_0_VIWSB_PRIVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_VI_0_VIWSB_PRIVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VI_0_VIWSB_PRIVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VI_0_VIWSB_PRIVAL_INIT_ENUM                        LOW
#define MC_FPRI_CTRL_VI_0_VIWSB_PRIVAL_LOWEST                   _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_VI_0_VIWSB_PRIVAL_LOW                      _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_VI_0_VIWSB_PRIVAL_MED                      _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_VI_0_VIWSB_PRIVAL_HIGH                     _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_VI_0_VIWU_PRIVAL_SHIFT                     _MK_SHIFT_CONST(4)
#define MC_FPRI_CTRL_VI_0_VIWU_PRIVAL_FIELD                     (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_VI_0_VIWU_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_VI_0_VIWU_PRIVAL_RANGE                     5:4
#define MC_FPRI_CTRL_VI_0_VIWU_PRIVAL_WOFFSET                   0x0
#define MC_FPRI_CTRL_VI_0_VIWU_PRIVAL_DEFAULT                   _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_VI_0_VIWU_PRIVAL_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_VI_0_VIWU_PRIVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VI_0_VIWU_PRIVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VI_0_VIWU_PRIVAL_INIT_ENUM                 LOW
#define MC_FPRI_CTRL_VI_0_VIWU_PRIVAL_LOWEST                    _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_VI_0_VIWU_PRIVAL_LOW                       _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_VI_0_VIWU_PRIVAL_MED                       _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_VI_0_VIWU_PRIVAL_HIGH                      _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_VI_0_VIWV_PRIVAL_SHIFT                     _MK_SHIFT_CONST(6)
#define MC_FPRI_CTRL_VI_0_VIWV_PRIVAL_FIELD                     (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_VI_0_VIWV_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_VI_0_VIWV_PRIVAL_RANGE                     7:6
#define MC_FPRI_CTRL_VI_0_VIWV_PRIVAL_WOFFSET                   0x0
#define MC_FPRI_CTRL_VI_0_VIWV_PRIVAL_DEFAULT                   _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_VI_0_VIWV_PRIVAL_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_VI_0_VIWV_PRIVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VI_0_VIWV_PRIVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VI_0_VIWV_PRIVAL_INIT_ENUM                 LOW
#define MC_FPRI_CTRL_VI_0_VIWV_PRIVAL_LOWEST                    _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_VI_0_VIWV_PRIVAL_LOW                       _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_VI_0_VIWV_PRIVAL_MED                       _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_VI_0_VIWV_PRIVAL_HIGH                      _MK_ENUM_CONST(3)

#define MC_FPRI_CTRL_VI_0_VIWY_PRIVAL_SHIFT                     _MK_SHIFT_CONST(8)
#define MC_FPRI_CTRL_VI_0_VIWY_PRIVAL_FIELD                     (_MK_MASK_CONST(0x3) << MC_FPRI_CTRL_VI_0_VIWY_PRIVAL_SHIFT)
#define MC_FPRI_CTRL_VI_0_VIWY_PRIVAL_RANGE                     9:8
#define MC_FPRI_CTRL_VI_0_VIWY_PRIVAL_WOFFSET                   0x0
#define MC_FPRI_CTRL_VI_0_VIWY_PRIVAL_DEFAULT                   _MK_MASK_CONST(0x1)
#define MC_FPRI_CTRL_VI_0_VIWY_PRIVAL_DEFAULT_MASK                      _MK_MASK_CONST(0x3)
#define MC_FPRI_CTRL_VI_0_VIWY_PRIVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VI_0_VIWY_PRIVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_FPRI_CTRL_VI_0_VIWY_PRIVAL_INIT_ENUM                 LOW
#define MC_FPRI_CTRL_VI_0_VIWY_PRIVAL_LOWEST                    _MK_ENUM_CONST(0)
#define MC_FPRI_CTRL_VI_0_VIWY_PRIVAL_LOW                       _MK_ENUM_CONST(1)
#define MC_FPRI_CTRL_VI_0_VIWY_PRIVAL_MED                       _MK_ENUM_CONST(2)
#define MC_FPRI_CTRL_VI_0_VIWY_PRIVAL_HIGH                      _MK_ENUM_CONST(3)


// Register MC_TIMEOUT_AVPC_0  
#define MC_TIMEOUT_AVPC_0                       _MK_ADDR_CONST(0x1b8)
#define MC_TIMEOUT_AVPC_0_SECURE                        0x0
#define MC_TIMEOUT_AVPC_0_WORD_COUNT                    0x1
#define MC_TIMEOUT_AVPC_0_RESET_VAL                     _MK_MASK_CONST(0x88)
#define MC_TIMEOUT_AVPC_0_RESET_MASK                    _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_AVPC_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_AVPC_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_AVPC_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_AVPC_0_WRITE_MASK                    _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_AVPC_0_AVPCARM7R_TMVAL_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_AVPC_0_AVPCARM7R_TMVAL_FIELD                 (_MK_MASK_CONST(0xf) << MC_TIMEOUT_AVPC_0_AVPCARM7R_TMVAL_SHIFT)
#define MC_TIMEOUT_AVPC_0_AVPCARM7R_TMVAL_RANGE                 3:0
#define MC_TIMEOUT_AVPC_0_AVPCARM7R_TMVAL_WOFFSET                       0x0
#define MC_TIMEOUT_AVPC_0_AVPCARM7R_TMVAL_DEFAULT                       _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_AVPC_0_AVPCARM7R_TMVAL_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_AVPC_0_AVPCARM7R_TMVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_AVPC_0_AVPCARM7R_TMVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_AVPC_0_AVPCARM7W_TMVAL_SHIFT                 _MK_SHIFT_CONST(4)
#define MC_TIMEOUT_AVPC_0_AVPCARM7W_TMVAL_FIELD                 (_MK_MASK_CONST(0xf) << MC_TIMEOUT_AVPC_0_AVPCARM7W_TMVAL_SHIFT)
#define MC_TIMEOUT_AVPC_0_AVPCARM7W_TMVAL_RANGE                 7:4
#define MC_TIMEOUT_AVPC_0_AVPCARM7W_TMVAL_WOFFSET                       0x0
#define MC_TIMEOUT_AVPC_0_AVPCARM7W_TMVAL_DEFAULT                       _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_AVPC_0_AVPCARM7W_TMVAL_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_AVPC_0_AVPCARM7W_TMVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_AVPC_0_AVPCARM7W_TMVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_DC_0  
#define MC_TIMEOUT_DC_0                 _MK_ADDR_CONST(0x1bc)
#define MC_TIMEOUT_DC_0_SECURE                  0x0
#define MC_TIMEOUT_DC_0_WORD_COUNT                      0x1
#define MC_TIMEOUT_DC_0_RESET_VAL                       _MK_MASK_CONST(0x88888)
#define MC_TIMEOUT_DC_0_RESET_MASK                      _MK_MASK_CONST(0xfffff)
#define MC_TIMEOUT_DC_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_DC_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_DC_0_READ_MASK                       _MK_MASK_CONST(0xfffff)
#define MC_TIMEOUT_DC_0_WRITE_MASK                      _MK_MASK_CONST(0xfffff)
#define MC_TIMEOUT_DC_0_DISPLAY0A_TMVAL_SHIFT                   _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_DC_0_DISPLAY0A_TMVAL_FIELD                   (_MK_MASK_CONST(0xf) << MC_TIMEOUT_DC_0_DISPLAY0A_TMVAL_SHIFT)
#define MC_TIMEOUT_DC_0_DISPLAY0A_TMVAL_RANGE                   3:0
#define MC_TIMEOUT_DC_0_DISPLAY0A_TMVAL_WOFFSET                 0x0
#define MC_TIMEOUT_DC_0_DISPLAY0A_TMVAL_DEFAULT                 _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_DC_0_DISPLAY0A_TMVAL_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_DC_0_DISPLAY0A_TMVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_DC_0_DISPLAY0A_TMVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_DC_0_DISPLAY0B_TMVAL_SHIFT                   _MK_SHIFT_CONST(4)
#define MC_TIMEOUT_DC_0_DISPLAY0B_TMVAL_FIELD                   (_MK_MASK_CONST(0xf) << MC_TIMEOUT_DC_0_DISPLAY0B_TMVAL_SHIFT)
#define MC_TIMEOUT_DC_0_DISPLAY0B_TMVAL_RANGE                   7:4
#define MC_TIMEOUT_DC_0_DISPLAY0B_TMVAL_WOFFSET                 0x0
#define MC_TIMEOUT_DC_0_DISPLAY0B_TMVAL_DEFAULT                 _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_DC_0_DISPLAY0B_TMVAL_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_DC_0_DISPLAY0B_TMVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_DC_0_DISPLAY0B_TMVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_DC_0_DISPLAY0C_TMVAL_SHIFT                   _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_DC_0_DISPLAY0C_TMVAL_FIELD                   (_MK_MASK_CONST(0xf) << MC_TIMEOUT_DC_0_DISPLAY0C_TMVAL_SHIFT)
#define MC_TIMEOUT_DC_0_DISPLAY0C_TMVAL_RANGE                   11:8
#define MC_TIMEOUT_DC_0_DISPLAY0C_TMVAL_WOFFSET                 0x0
#define MC_TIMEOUT_DC_0_DISPLAY0C_TMVAL_DEFAULT                 _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_DC_0_DISPLAY0C_TMVAL_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_DC_0_DISPLAY0C_TMVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_DC_0_DISPLAY0C_TMVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_DC_0_DISPLAY1B_TMVAL_SHIFT                   _MK_SHIFT_CONST(12)
#define MC_TIMEOUT_DC_0_DISPLAY1B_TMVAL_FIELD                   (_MK_MASK_CONST(0xf) << MC_TIMEOUT_DC_0_DISPLAY1B_TMVAL_SHIFT)
#define MC_TIMEOUT_DC_0_DISPLAY1B_TMVAL_RANGE                   15:12
#define MC_TIMEOUT_DC_0_DISPLAY1B_TMVAL_WOFFSET                 0x0
#define MC_TIMEOUT_DC_0_DISPLAY1B_TMVAL_DEFAULT                 _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_DC_0_DISPLAY1B_TMVAL_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_DC_0_DISPLAY1B_TMVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_DC_0_DISPLAY1B_TMVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_DC_0_DISPLAYHC_TMVAL_SHIFT                   _MK_SHIFT_CONST(16)
#define MC_TIMEOUT_DC_0_DISPLAYHC_TMVAL_FIELD                   (_MK_MASK_CONST(0xf) << MC_TIMEOUT_DC_0_DISPLAYHC_TMVAL_SHIFT)
#define MC_TIMEOUT_DC_0_DISPLAYHC_TMVAL_RANGE                   19:16
#define MC_TIMEOUT_DC_0_DISPLAYHC_TMVAL_WOFFSET                 0x0
#define MC_TIMEOUT_DC_0_DISPLAYHC_TMVAL_DEFAULT                 _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_DC_0_DISPLAYHC_TMVAL_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_DC_0_DISPLAYHC_TMVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_DC_0_DISPLAYHC_TMVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_DCB_0  
#define MC_TIMEOUT_DCB_0                        _MK_ADDR_CONST(0x1c0)
#define MC_TIMEOUT_DCB_0_SECURE                         0x0
#define MC_TIMEOUT_DCB_0_WORD_COUNT                     0x1
#define MC_TIMEOUT_DCB_0_RESET_VAL                      _MK_MASK_CONST(0x88888)
#define MC_TIMEOUT_DCB_0_RESET_MASK                     _MK_MASK_CONST(0xfffff)
#define MC_TIMEOUT_DCB_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_DCB_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_DCB_0_READ_MASK                      _MK_MASK_CONST(0xfffff)
#define MC_TIMEOUT_DCB_0_WRITE_MASK                     _MK_MASK_CONST(0xfffff)
#define MC_TIMEOUT_DCB_0_DISPLAY0AB_TMVAL_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_DCB_0_DISPLAY0AB_TMVAL_FIELD                 (_MK_MASK_CONST(0xf) << MC_TIMEOUT_DCB_0_DISPLAY0AB_TMVAL_SHIFT)
#define MC_TIMEOUT_DCB_0_DISPLAY0AB_TMVAL_RANGE                 3:0
#define MC_TIMEOUT_DCB_0_DISPLAY0AB_TMVAL_WOFFSET                       0x0
#define MC_TIMEOUT_DCB_0_DISPLAY0AB_TMVAL_DEFAULT                       _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_DCB_0_DISPLAY0AB_TMVAL_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_DCB_0_DISPLAY0AB_TMVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_DCB_0_DISPLAY0AB_TMVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_DCB_0_DISPLAY0BB_TMVAL_SHIFT                 _MK_SHIFT_CONST(4)
#define MC_TIMEOUT_DCB_0_DISPLAY0BB_TMVAL_FIELD                 (_MK_MASK_CONST(0xf) << MC_TIMEOUT_DCB_0_DISPLAY0BB_TMVAL_SHIFT)
#define MC_TIMEOUT_DCB_0_DISPLAY0BB_TMVAL_RANGE                 7:4
#define MC_TIMEOUT_DCB_0_DISPLAY0BB_TMVAL_WOFFSET                       0x0
#define MC_TIMEOUT_DCB_0_DISPLAY0BB_TMVAL_DEFAULT                       _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_DCB_0_DISPLAY0BB_TMVAL_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_DCB_0_DISPLAY0BB_TMVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_DCB_0_DISPLAY0BB_TMVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_DCB_0_DISPLAY0CB_TMVAL_SHIFT                 _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_DCB_0_DISPLAY0CB_TMVAL_FIELD                 (_MK_MASK_CONST(0xf) << MC_TIMEOUT_DCB_0_DISPLAY0CB_TMVAL_SHIFT)
#define MC_TIMEOUT_DCB_0_DISPLAY0CB_TMVAL_RANGE                 11:8
#define MC_TIMEOUT_DCB_0_DISPLAY0CB_TMVAL_WOFFSET                       0x0
#define MC_TIMEOUT_DCB_0_DISPLAY0CB_TMVAL_DEFAULT                       _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_DCB_0_DISPLAY0CB_TMVAL_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_DCB_0_DISPLAY0CB_TMVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_DCB_0_DISPLAY0CB_TMVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_DCB_0_DISPLAY1BB_TMVAL_SHIFT                 _MK_SHIFT_CONST(12)
#define MC_TIMEOUT_DCB_0_DISPLAY1BB_TMVAL_FIELD                 (_MK_MASK_CONST(0xf) << MC_TIMEOUT_DCB_0_DISPLAY1BB_TMVAL_SHIFT)
#define MC_TIMEOUT_DCB_0_DISPLAY1BB_TMVAL_RANGE                 15:12
#define MC_TIMEOUT_DCB_0_DISPLAY1BB_TMVAL_WOFFSET                       0x0
#define MC_TIMEOUT_DCB_0_DISPLAY1BB_TMVAL_DEFAULT                       _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_DCB_0_DISPLAY1BB_TMVAL_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_DCB_0_DISPLAY1BB_TMVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_DCB_0_DISPLAY1BB_TMVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_DCB_0_DISPLAYHCB_TMVAL_SHIFT                 _MK_SHIFT_CONST(16)
#define MC_TIMEOUT_DCB_0_DISPLAYHCB_TMVAL_FIELD                 (_MK_MASK_CONST(0xf) << MC_TIMEOUT_DCB_0_DISPLAYHCB_TMVAL_SHIFT)
#define MC_TIMEOUT_DCB_0_DISPLAYHCB_TMVAL_RANGE                 19:16
#define MC_TIMEOUT_DCB_0_DISPLAYHCB_TMVAL_WOFFSET                       0x0
#define MC_TIMEOUT_DCB_0_DISPLAYHCB_TMVAL_DEFAULT                       _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_DCB_0_DISPLAYHCB_TMVAL_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_DCB_0_DISPLAYHCB_TMVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_DCB_0_DISPLAYHCB_TMVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_EPP_0  
#define MC_TIMEOUT_EPP_0                        _MK_ADDR_CONST(0x1c4)
#define MC_TIMEOUT_EPP_0_SECURE                         0x0
#define MC_TIMEOUT_EPP_0_WORD_COUNT                     0x1
#define MC_TIMEOUT_EPP_0_RESET_VAL                      _MK_MASK_CONST(0x8888)
#define MC_TIMEOUT_EPP_0_RESET_MASK                     _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_EPP_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_EPP_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_EPP_0_READ_MASK                      _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_EPP_0_WRITE_MASK                     _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_EPP_0_EPPUP_TMVAL_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_EPP_0_EPPUP_TMVAL_FIELD                      (_MK_MASK_CONST(0xf) << MC_TIMEOUT_EPP_0_EPPUP_TMVAL_SHIFT)
#define MC_TIMEOUT_EPP_0_EPPUP_TMVAL_RANGE                      3:0
#define MC_TIMEOUT_EPP_0_EPPUP_TMVAL_WOFFSET                    0x0
#define MC_TIMEOUT_EPP_0_EPPUP_TMVAL_DEFAULT                    _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_EPP_0_EPPUP_TMVAL_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_EPP_0_EPPUP_TMVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_EPP_0_EPPUP_TMVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_EPP_0_EPPU_TMVAL_SHIFT                       _MK_SHIFT_CONST(4)
#define MC_TIMEOUT_EPP_0_EPPU_TMVAL_FIELD                       (_MK_MASK_CONST(0xf) << MC_TIMEOUT_EPP_0_EPPU_TMVAL_SHIFT)
#define MC_TIMEOUT_EPP_0_EPPU_TMVAL_RANGE                       7:4
#define MC_TIMEOUT_EPP_0_EPPU_TMVAL_WOFFSET                     0x0
#define MC_TIMEOUT_EPP_0_EPPU_TMVAL_DEFAULT                     _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_EPP_0_EPPU_TMVAL_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_EPP_0_EPPU_TMVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_EPP_0_EPPU_TMVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_EPP_0_EPPV_TMVAL_SHIFT                       _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_EPP_0_EPPV_TMVAL_FIELD                       (_MK_MASK_CONST(0xf) << MC_TIMEOUT_EPP_0_EPPV_TMVAL_SHIFT)
#define MC_TIMEOUT_EPP_0_EPPV_TMVAL_RANGE                       11:8
#define MC_TIMEOUT_EPP_0_EPPV_TMVAL_WOFFSET                     0x0
#define MC_TIMEOUT_EPP_0_EPPV_TMVAL_DEFAULT                     _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_EPP_0_EPPV_TMVAL_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_EPP_0_EPPV_TMVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_EPP_0_EPPV_TMVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_EPP_0_EPPY_TMVAL_SHIFT                       _MK_SHIFT_CONST(12)
#define MC_TIMEOUT_EPP_0_EPPY_TMVAL_FIELD                       (_MK_MASK_CONST(0xf) << MC_TIMEOUT_EPP_0_EPPY_TMVAL_SHIFT)
#define MC_TIMEOUT_EPP_0_EPPY_TMVAL_RANGE                       15:12
#define MC_TIMEOUT_EPP_0_EPPY_TMVAL_WOFFSET                     0x0
#define MC_TIMEOUT_EPP_0_EPPY_TMVAL_DEFAULT                     _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_EPP_0_EPPY_TMVAL_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_EPP_0_EPPY_TMVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_EPP_0_EPPY_TMVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_G2_0  
#define MC_TIMEOUT_G2_0                 _MK_ADDR_CONST(0x1c8)
#define MC_TIMEOUT_G2_0_SECURE                  0x0
#define MC_TIMEOUT_G2_0_WORD_COUNT                      0x1
#define MC_TIMEOUT_G2_0_RESET_VAL                       _MK_MASK_CONST(0x8888)
#define MC_TIMEOUT_G2_0_RESET_MASK                      _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_G2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_G2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_G2_0_READ_MASK                       _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_G2_0_WRITE_MASK                      _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_G2_0_G2PR_TMVAL_SHIFT                        _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_G2_0_G2PR_TMVAL_FIELD                        (_MK_MASK_CONST(0xf) << MC_TIMEOUT_G2_0_G2PR_TMVAL_SHIFT)
#define MC_TIMEOUT_G2_0_G2PR_TMVAL_RANGE                        3:0
#define MC_TIMEOUT_G2_0_G2PR_TMVAL_WOFFSET                      0x0
#define MC_TIMEOUT_G2_0_G2PR_TMVAL_DEFAULT                      _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_G2_0_G2PR_TMVAL_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_G2_0_G2PR_TMVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_G2_0_G2PR_TMVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_G2_0_G2SR_TMVAL_SHIFT                        _MK_SHIFT_CONST(4)
#define MC_TIMEOUT_G2_0_G2SR_TMVAL_FIELD                        (_MK_MASK_CONST(0xf) << MC_TIMEOUT_G2_0_G2SR_TMVAL_SHIFT)
#define MC_TIMEOUT_G2_0_G2SR_TMVAL_RANGE                        7:4
#define MC_TIMEOUT_G2_0_G2SR_TMVAL_WOFFSET                      0x0
#define MC_TIMEOUT_G2_0_G2SR_TMVAL_DEFAULT                      _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_G2_0_G2SR_TMVAL_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_G2_0_G2SR_TMVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_G2_0_G2SR_TMVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_G2_0_G2DR_TMVAL_SHIFT                        _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_G2_0_G2DR_TMVAL_FIELD                        (_MK_MASK_CONST(0xf) << MC_TIMEOUT_G2_0_G2DR_TMVAL_SHIFT)
#define MC_TIMEOUT_G2_0_G2DR_TMVAL_RANGE                        11:8
#define MC_TIMEOUT_G2_0_G2DR_TMVAL_WOFFSET                      0x0
#define MC_TIMEOUT_G2_0_G2DR_TMVAL_DEFAULT                      _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_G2_0_G2DR_TMVAL_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_G2_0_G2DR_TMVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_G2_0_G2DR_TMVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_G2_0_G2DW_TMVAL_SHIFT                        _MK_SHIFT_CONST(12)
#define MC_TIMEOUT_G2_0_G2DW_TMVAL_FIELD                        (_MK_MASK_CONST(0xf) << MC_TIMEOUT_G2_0_G2DW_TMVAL_SHIFT)
#define MC_TIMEOUT_G2_0_G2DW_TMVAL_RANGE                        15:12
#define MC_TIMEOUT_G2_0_G2DW_TMVAL_WOFFSET                      0x0
#define MC_TIMEOUT_G2_0_G2DW_TMVAL_DEFAULT                      _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_G2_0_G2DW_TMVAL_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_G2_0_G2DW_TMVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_G2_0_G2DW_TMVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_HC_0  
#define MC_TIMEOUT_HC_0                 _MK_ADDR_CONST(0x1cc)
#define MC_TIMEOUT_HC_0_SECURE                  0x0
#define MC_TIMEOUT_HC_0_WORD_COUNT                      0x1
#define MC_TIMEOUT_HC_0_RESET_VAL                       _MK_MASK_CONST(0x888)
#define MC_TIMEOUT_HC_0_RESET_MASK                      _MK_MASK_CONST(0xfff)
#define MC_TIMEOUT_HC_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_HC_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_HC_0_READ_MASK                       _MK_MASK_CONST(0xfff)
#define MC_TIMEOUT_HC_0_WRITE_MASK                      _MK_MASK_CONST(0xfff)
#define MC_TIMEOUT_HC_0_HOST1XDMAR_TMVAL_SHIFT                  _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_HC_0_HOST1XDMAR_TMVAL_FIELD                  (_MK_MASK_CONST(0xf) << MC_TIMEOUT_HC_0_HOST1XDMAR_TMVAL_SHIFT)
#define MC_TIMEOUT_HC_0_HOST1XDMAR_TMVAL_RANGE                  3:0
#define MC_TIMEOUT_HC_0_HOST1XDMAR_TMVAL_WOFFSET                        0x0
#define MC_TIMEOUT_HC_0_HOST1XDMAR_TMVAL_DEFAULT                        _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_HC_0_HOST1XDMAR_TMVAL_DEFAULT_MASK                   _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_HC_0_HOST1XDMAR_TMVAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_HC_0_HOST1XDMAR_TMVAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_HC_0_HOST1XR_TMVAL_SHIFT                     _MK_SHIFT_CONST(4)
#define MC_TIMEOUT_HC_0_HOST1XR_TMVAL_FIELD                     (_MK_MASK_CONST(0xf) << MC_TIMEOUT_HC_0_HOST1XR_TMVAL_SHIFT)
#define MC_TIMEOUT_HC_0_HOST1XR_TMVAL_RANGE                     7:4
#define MC_TIMEOUT_HC_0_HOST1XR_TMVAL_WOFFSET                   0x0
#define MC_TIMEOUT_HC_0_HOST1XR_TMVAL_DEFAULT                   _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_HC_0_HOST1XR_TMVAL_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_HC_0_HOST1XR_TMVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_HC_0_HOST1XR_TMVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_HC_0_HOST1XW_TMVAL_SHIFT                     _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_HC_0_HOST1XW_TMVAL_FIELD                     (_MK_MASK_CONST(0xf) << MC_TIMEOUT_HC_0_HOST1XW_TMVAL_SHIFT)
#define MC_TIMEOUT_HC_0_HOST1XW_TMVAL_RANGE                     11:8
#define MC_TIMEOUT_HC_0_HOST1XW_TMVAL_WOFFSET                   0x0
#define MC_TIMEOUT_HC_0_HOST1XW_TMVAL_DEFAULT                   _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_HC_0_HOST1XW_TMVAL_DEFAULT_MASK                      _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_HC_0_HOST1XW_TMVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_HC_0_HOST1XW_TMVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_ISP_0  
#define MC_TIMEOUT_ISP_0                        _MK_ADDR_CONST(0x1d0)
#define MC_TIMEOUT_ISP_0_SECURE                         0x0
#define MC_TIMEOUT_ISP_0_WORD_COUNT                     0x1
#define MC_TIMEOUT_ISP_0_RESET_VAL                      _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_ISP_0_RESET_MASK                     _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_ISP_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_ISP_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_ISP_0_READ_MASK                      _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_ISP_0_WRITE_MASK                     _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_ISP_0_ISPW_TMVAL_SHIFT                       _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_ISP_0_ISPW_TMVAL_FIELD                       (_MK_MASK_CONST(0xf) << MC_TIMEOUT_ISP_0_ISPW_TMVAL_SHIFT)
#define MC_TIMEOUT_ISP_0_ISPW_TMVAL_RANGE                       3:0
#define MC_TIMEOUT_ISP_0_ISPW_TMVAL_WOFFSET                     0x0
#define MC_TIMEOUT_ISP_0_ISPW_TMVAL_DEFAULT                     _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_ISP_0_ISPW_TMVAL_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_ISP_0_ISPW_TMVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_ISP_0_ISPW_TMVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_MPCORE_0  
#define MC_TIMEOUT_MPCORE_0                     _MK_ADDR_CONST(0x1d4)
#define MC_TIMEOUT_MPCORE_0_SECURE                      0x0
#define MC_TIMEOUT_MPCORE_0_WORD_COUNT                  0x1
#define MC_TIMEOUT_MPCORE_0_RESET_VAL                   _MK_MASK_CONST(0x88)
#define MC_TIMEOUT_MPCORE_0_RESET_MASK                  _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_MPCORE_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_MPCORE_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_MPCORE_0_READ_MASK                   _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_MPCORE_0_WRITE_MASK                  _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_MPCORE_0_MPCORER_TMVAL_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_MPCORE_0_MPCORER_TMVAL_FIELD                 (_MK_MASK_CONST(0xf) << MC_TIMEOUT_MPCORE_0_MPCORER_TMVAL_SHIFT)
#define MC_TIMEOUT_MPCORE_0_MPCORER_TMVAL_RANGE                 3:0
#define MC_TIMEOUT_MPCORE_0_MPCORER_TMVAL_WOFFSET                       0x0
#define MC_TIMEOUT_MPCORE_0_MPCORER_TMVAL_DEFAULT                       _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_MPCORE_0_MPCORER_TMVAL_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_MPCORE_0_MPCORER_TMVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_MPCORE_0_MPCORER_TMVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_MPCORE_0_MPCOREW_TMVAL_SHIFT                 _MK_SHIFT_CONST(4)
#define MC_TIMEOUT_MPCORE_0_MPCOREW_TMVAL_FIELD                 (_MK_MASK_CONST(0xf) << MC_TIMEOUT_MPCORE_0_MPCOREW_TMVAL_SHIFT)
#define MC_TIMEOUT_MPCORE_0_MPCOREW_TMVAL_RANGE                 7:4
#define MC_TIMEOUT_MPCORE_0_MPCOREW_TMVAL_WOFFSET                       0x0
#define MC_TIMEOUT_MPCORE_0_MPCOREW_TMVAL_DEFAULT                       _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_MPCORE_0_MPCOREW_TMVAL_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_MPCORE_0_MPCOREW_TMVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_MPCORE_0_MPCOREW_TMVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_MPEA_0  
#define MC_TIMEOUT_MPEA_0                       _MK_ADDR_CONST(0x1d8)
#define MC_TIMEOUT_MPEA_0_SECURE                        0x0
#define MC_TIMEOUT_MPEA_0_WORD_COUNT                    0x1
#define MC_TIMEOUT_MPEA_0_RESET_VAL                     _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_MPEA_0_RESET_MASK                    _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_MPEA_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_MPEA_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_MPEA_0_READ_MASK                     _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_MPEA_0_WRITE_MASK                    _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_MPEA_0_MPEAMEMRD_TMVAL_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_MPEA_0_MPEAMEMRD_TMVAL_FIELD                 (_MK_MASK_CONST(0xf) << MC_TIMEOUT_MPEA_0_MPEAMEMRD_TMVAL_SHIFT)
#define MC_TIMEOUT_MPEA_0_MPEAMEMRD_TMVAL_RANGE                 3:0
#define MC_TIMEOUT_MPEA_0_MPEAMEMRD_TMVAL_WOFFSET                       0x0
#define MC_TIMEOUT_MPEA_0_MPEAMEMRD_TMVAL_DEFAULT                       _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_MPEA_0_MPEAMEMRD_TMVAL_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_MPEA_0_MPEAMEMRD_TMVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_MPEA_0_MPEAMEMRD_TMVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_MPEB_0  
#define MC_TIMEOUT_MPEB_0                       _MK_ADDR_CONST(0x1dc)
#define MC_TIMEOUT_MPEB_0_SECURE                        0x0
#define MC_TIMEOUT_MPEB_0_WORD_COUNT                    0x1
#define MC_TIMEOUT_MPEB_0_RESET_VAL                     _MK_MASK_CONST(0x888)
#define MC_TIMEOUT_MPEB_0_RESET_MASK                    _MK_MASK_CONST(0xfff)
#define MC_TIMEOUT_MPEB_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_MPEB_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_MPEB_0_READ_MASK                     _MK_MASK_CONST(0xfff)
#define MC_TIMEOUT_MPEB_0_WRITE_MASK                    _MK_MASK_CONST(0xfff)
#define MC_TIMEOUT_MPEB_0_MPEUNIFBR_TMVAL_SHIFT                 _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_MPEB_0_MPEUNIFBR_TMVAL_FIELD                 (_MK_MASK_CONST(0xf) << MC_TIMEOUT_MPEB_0_MPEUNIFBR_TMVAL_SHIFT)
#define MC_TIMEOUT_MPEB_0_MPEUNIFBR_TMVAL_RANGE                 3:0
#define MC_TIMEOUT_MPEB_0_MPEUNIFBR_TMVAL_WOFFSET                       0x0
#define MC_TIMEOUT_MPEB_0_MPEUNIFBR_TMVAL_DEFAULT                       _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_MPEB_0_MPEUNIFBR_TMVAL_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_MPEB_0_MPEUNIFBR_TMVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_MPEB_0_MPEUNIFBR_TMVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_MPEB_0_MPE_IPRED_TMVAL_SHIFT                 _MK_SHIFT_CONST(4)
#define MC_TIMEOUT_MPEB_0_MPE_IPRED_TMVAL_FIELD                 (_MK_MASK_CONST(0xf) << MC_TIMEOUT_MPEB_0_MPE_IPRED_TMVAL_SHIFT)
#define MC_TIMEOUT_MPEB_0_MPE_IPRED_TMVAL_RANGE                 7:4
#define MC_TIMEOUT_MPEB_0_MPE_IPRED_TMVAL_WOFFSET                       0x0
#define MC_TIMEOUT_MPEB_0_MPE_IPRED_TMVAL_DEFAULT                       _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_MPEB_0_MPE_IPRED_TMVAL_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_MPEB_0_MPE_IPRED_TMVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_MPEB_0_MPE_IPRED_TMVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_MPEB_0_MPEUNIFBW_TMVAL_SHIFT                 _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_MPEB_0_MPEUNIFBW_TMVAL_FIELD                 (_MK_MASK_CONST(0xf) << MC_TIMEOUT_MPEB_0_MPEUNIFBW_TMVAL_SHIFT)
#define MC_TIMEOUT_MPEB_0_MPEUNIFBW_TMVAL_RANGE                 11:8
#define MC_TIMEOUT_MPEB_0_MPEUNIFBW_TMVAL_WOFFSET                       0x0
#define MC_TIMEOUT_MPEB_0_MPEUNIFBW_TMVAL_DEFAULT                       _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_MPEB_0_MPEUNIFBW_TMVAL_DEFAULT_MASK                  _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_MPEB_0_MPEUNIFBW_TMVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_MPEB_0_MPEUNIFBW_TMVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_MPEC_0  
#define MC_TIMEOUT_MPEC_0                       _MK_ADDR_CONST(0x1e0)
#define MC_TIMEOUT_MPEC_0_SECURE                        0x0
#define MC_TIMEOUT_MPEC_0_WORD_COUNT                    0x1
#define MC_TIMEOUT_MPEC_0_RESET_VAL                     _MK_MASK_CONST(0x88)
#define MC_TIMEOUT_MPEC_0_RESET_MASK                    _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_MPEC_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_MPEC_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_MPEC_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_MPEC_0_WRITE_MASK                    _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_MPEC_0_MPECSRD_TMVAL_SHIFT                   _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_MPEC_0_MPECSRD_TMVAL_FIELD                   (_MK_MASK_CONST(0xf) << MC_TIMEOUT_MPEC_0_MPECSRD_TMVAL_SHIFT)
#define MC_TIMEOUT_MPEC_0_MPECSRD_TMVAL_RANGE                   3:0
#define MC_TIMEOUT_MPEC_0_MPECSRD_TMVAL_WOFFSET                 0x0
#define MC_TIMEOUT_MPEC_0_MPECSRD_TMVAL_DEFAULT                 _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_MPEC_0_MPECSRD_TMVAL_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_MPEC_0_MPECSRD_TMVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_MPEC_0_MPECSRD_TMVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_MPEC_0_MPECSWR_TMVAL_SHIFT                   _MK_SHIFT_CONST(4)
#define MC_TIMEOUT_MPEC_0_MPECSWR_TMVAL_FIELD                   (_MK_MASK_CONST(0xf) << MC_TIMEOUT_MPEC_0_MPECSWR_TMVAL_SHIFT)
#define MC_TIMEOUT_MPEC_0_MPECSWR_TMVAL_RANGE                   7:4
#define MC_TIMEOUT_MPEC_0_MPECSWR_TMVAL_WOFFSET                 0x0
#define MC_TIMEOUT_MPEC_0_MPECSWR_TMVAL_DEFAULT                 _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_MPEC_0_MPECSWR_TMVAL_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_MPEC_0_MPECSWR_TMVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_MPEC_0_MPECSWR_TMVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_NV_0  
#define MC_TIMEOUT_NV_0                 _MK_ADDR_CONST(0x1e4)
#define MC_TIMEOUT_NV_0_SECURE                  0x0
#define MC_TIMEOUT_NV_0_WORD_COUNT                      0x1
#define MC_TIMEOUT_NV_0_RESET_VAL                       _MK_MASK_CONST(0x8888)
#define MC_TIMEOUT_NV_0_RESET_MASK                      _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_NV_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_NV_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_NV_0_READ_MASK                       _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_NV_0_WRITE_MASK                      _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_NV_0_FDCDRD_TMVAL_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_NV_0_FDCDRD_TMVAL_FIELD                      (_MK_MASK_CONST(0xf) << MC_TIMEOUT_NV_0_FDCDRD_TMVAL_SHIFT)
#define MC_TIMEOUT_NV_0_FDCDRD_TMVAL_RANGE                      3:0
#define MC_TIMEOUT_NV_0_FDCDRD_TMVAL_WOFFSET                    0x0
#define MC_TIMEOUT_NV_0_FDCDRD_TMVAL_DEFAULT                    _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_NV_0_FDCDRD_TMVAL_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_NV_0_FDCDRD_TMVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_NV_0_FDCDRD_TMVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_NV_0_IDXSRD_TMVAL_SHIFT                      _MK_SHIFT_CONST(4)
#define MC_TIMEOUT_NV_0_IDXSRD_TMVAL_FIELD                      (_MK_MASK_CONST(0xf) << MC_TIMEOUT_NV_0_IDXSRD_TMVAL_SHIFT)
#define MC_TIMEOUT_NV_0_IDXSRD_TMVAL_RANGE                      7:4
#define MC_TIMEOUT_NV_0_IDXSRD_TMVAL_WOFFSET                    0x0
#define MC_TIMEOUT_NV_0_IDXSRD_TMVAL_DEFAULT                    _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_NV_0_IDXSRD_TMVAL_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_NV_0_IDXSRD_TMVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_NV_0_IDXSRD_TMVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_NV_0_TEXSRD_TMVAL_SHIFT                      _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_NV_0_TEXSRD_TMVAL_FIELD                      (_MK_MASK_CONST(0xf) << MC_TIMEOUT_NV_0_TEXSRD_TMVAL_SHIFT)
#define MC_TIMEOUT_NV_0_TEXSRD_TMVAL_RANGE                      11:8
#define MC_TIMEOUT_NV_0_TEXSRD_TMVAL_WOFFSET                    0x0
#define MC_TIMEOUT_NV_0_TEXSRD_TMVAL_DEFAULT                    _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_NV_0_TEXSRD_TMVAL_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_NV_0_TEXSRD_TMVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_NV_0_TEXSRD_TMVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_NV_0_FDCDWR_TMVAL_SHIFT                      _MK_SHIFT_CONST(12)
#define MC_TIMEOUT_NV_0_FDCDWR_TMVAL_FIELD                      (_MK_MASK_CONST(0xf) << MC_TIMEOUT_NV_0_FDCDWR_TMVAL_SHIFT)
#define MC_TIMEOUT_NV_0_FDCDWR_TMVAL_RANGE                      15:12
#define MC_TIMEOUT_NV_0_FDCDWR_TMVAL_WOFFSET                    0x0
#define MC_TIMEOUT_NV_0_FDCDWR_TMVAL_DEFAULT                    _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_NV_0_FDCDWR_TMVAL_DEFAULT_MASK                       _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_NV_0_FDCDWR_TMVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_NV_0_FDCDWR_TMVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_PPCS_0  
#define MC_TIMEOUT_PPCS_0                       _MK_ADDR_CONST(0x1e8)
#define MC_TIMEOUT_PPCS_0_SECURE                        0x0
#define MC_TIMEOUT_PPCS_0_WORD_COUNT                    0x1
#define MC_TIMEOUT_PPCS_0_RESET_VAL                     _MK_MASK_CONST(0x8888)
#define MC_TIMEOUT_PPCS_0_RESET_MASK                    _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_PPCS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_PPCS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_PPCS_0_READ_MASK                     _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_PPCS_0_WRITE_MASK                    _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_PPCS_0_PPCSAHBDMAR_TMVAL_SHIFT                       _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_PPCS_0_PPCSAHBDMAR_TMVAL_FIELD                       (_MK_MASK_CONST(0xf) << MC_TIMEOUT_PPCS_0_PPCSAHBDMAR_TMVAL_SHIFT)
#define MC_TIMEOUT_PPCS_0_PPCSAHBDMAR_TMVAL_RANGE                       3:0
#define MC_TIMEOUT_PPCS_0_PPCSAHBDMAR_TMVAL_WOFFSET                     0x0
#define MC_TIMEOUT_PPCS_0_PPCSAHBDMAR_TMVAL_DEFAULT                     _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_PPCS_0_PPCSAHBDMAR_TMVAL_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_PPCS_0_PPCSAHBDMAR_TMVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_PPCS_0_PPCSAHBDMAR_TMVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_PPCS_0_PPCSAHBSLVR_TMVAL_SHIFT                       _MK_SHIFT_CONST(4)
#define MC_TIMEOUT_PPCS_0_PPCSAHBSLVR_TMVAL_FIELD                       (_MK_MASK_CONST(0xf) << MC_TIMEOUT_PPCS_0_PPCSAHBSLVR_TMVAL_SHIFT)
#define MC_TIMEOUT_PPCS_0_PPCSAHBSLVR_TMVAL_RANGE                       7:4
#define MC_TIMEOUT_PPCS_0_PPCSAHBSLVR_TMVAL_WOFFSET                     0x0
#define MC_TIMEOUT_PPCS_0_PPCSAHBSLVR_TMVAL_DEFAULT                     _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_PPCS_0_PPCSAHBSLVR_TMVAL_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_PPCS_0_PPCSAHBSLVR_TMVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_PPCS_0_PPCSAHBSLVR_TMVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_PPCS_0_PPCSAHBDMAW_TMVAL_SHIFT                       _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_PPCS_0_PPCSAHBDMAW_TMVAL_FIELD                       (_MK_MASK_CONST(0xf) << MC_TIMEOUT_PPCS_0_PPCSAHBDMAW_TMVAL_SHIFT)
#define MC_TIMEOUT_PPCS_0_PPCSAHBDMAW_TMVAL_RANGE                       11:8
#define MC_TIMEOUT_PPCS_0_PPCSAHBDMAW_TMVAL_WOFFSET                     0x0
#define MC_TIMEOUT_PPCS_0_PPCSAHBDMAW_TMVAL_DEFAULT                     _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_PPCS_0_PPCSAHBDMAW_TMVAL_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_PPCS_0_PPCSAHBDMAW_TMVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_PPCS_0_PPCSAHBDMAW_TMVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_PPCS_0_PPCSAHBSLVW_TMVAL_SHIFT                       _MK_SHIFT_CONST(12)
#define MC_TIMEOUT_PPCS_0_PPCSAHBSLVW_TMVAL_FIELD                       (_MK_MASK_CONST(0xf) << MC_TIMEOUT_PPCS_0_PPCSAHBSLVW_TMVAL_SHIFT)
#define MC_TIMEOUT_PPCS_0_PPCSAHBSLVW_TMVAL_RANGE                       15:12
#define MC_TIMEOUT_PPCS_0_PPCSAHBSLVW_TMVAL_WOFFSET                     0x0
#define MC_TIMEOUT_PPCS_0_PPCSAHBSLVW_TMVAL_DEFAULT                     _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_PPCS_0_PPCSAHBSLVW_TMVAL_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_PPCS_0_PPCSAHBSLVW_TMVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_PPCS_0_PPCSAHBSLVW_TMVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_VDE_0  
#define MC_TIMEOUT_VDE_0                        _MK_ADDR_CONST(0x1ec)
#define MC_TIMEOUT_VDE_0_SECURE                         0x0
#define MC_TIMEOUT_VDE_0_WORD_COUNT                     0x1
#define MC_TIMEOUT_VDE_0_RESET_VAL                      _MK_MASK_CONST(0x4444444)
#define MC_TIMEOUT_VDE_0_RESET_MASK                     _MK_MASK_CONST(0xfffffff)
#define MC_TIMEOUT_VDE_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_VDE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_VDE_0_READ_MASK                      _MK_MASK_CONST(0xfffffff)
#define MC_TIMEOUT_VDE_0_WRITE_MASK                     _MK_MASK_CONST(0xfffffff)
#define MC_TIMEOUT_VDE_0_VDEBSEVR_TMVAL_SHIFT                   _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_VDE_0_VDEBSEVR_TMVAL_FIELD                   (_MK_MASK_CONST(0xf) << MC_TIMEOUT_VDE_0_VDEBSEVR_TMVAL_SHIFT)
#define MC_TIMEOUT_VDE_0_VDEBSEVR_TMVAL_RANGE                   3:0
#define MC_TIMEOUT_VDE_0_VDEBSEVR_TMVAL_WOFFSET                 0x0
#define MC_TIMEOUT_VDE_0_VDEBSEVR_TMVAL_DEFAULT                 _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_VDE_0_VDEBSEVR_TMVAL_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_VDE_0_VDEBSEVR_TMVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_VDE_0_VDEBSEVR_TMVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_VDE_0_VDEMBER_TMVAL_SHIFT                    _MK_SHIFT_CONST(4)
#define MC_TIMEOUT_VDE_0_VDEMBER_TMVAL_FIELD                    (_MK_MASK_CONST(0xf) << MC_TIMEOUT_VDE_0_VDEMBER_TMVAL_SHIFT)
#define MC_TIMEOUT_VDE_0_VDEMBER_TMVAL_RANGE                    7:4
#define MC_TIMEOUT_VDE_0_VDEMBER_TMVAL_WOFFSET                  0x0
#define MC_TIMEOUT_VDE_0_VDEMBER_TMVAL_DEFAULT                  _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_VDE_0_VDEMBER_TMVAL_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_VDE_0_VDEMBER_TMVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_VDE_0_VDEMBER_TMVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_VDE_0_VDEMCER_TMVAL_SHIFT                    _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_VDE_0_VDEMCER_TMVAL_FIELD                    (_MK_MASK_CONST(0xf) << MC_TIMEOUT_VDE_0_VDEMCER_TMVAL_SHIFT)
#define MC_TIMEOUT_VDE_0_VDEMCER_TMVAL_RANGE                    11:8
#define MC_TIMEOUT_VDE_0_VDEMCER_TMVAL_WOFFSET                  0x0
#define MC_TIMEOUT_VDE_0_VDEMCER_TMVAL_DEFAULT                  _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_VDE_0_VDEMCER_TMVAL_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_VDE_0_VDEMCER_TMVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_VDE_0_VDEMCER_TMVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_VDE_0_VDETPER_TMVAL_SHIFT                    _MK_SHIFT_CONST(12)
#define MC_TIMEOUT_VDE_0_VDETPER_TMVAL_FIELD                    (_MK_MASK_CONST(0xf) << MC_TIMEOUT_VDE_0_VDETPER_TMVAL_SHIFT)
#define MC_TIMEOUT_VDE_0_VDETPER_TMVAL_RANGE                    15:12
#define MC_TIMEOUT_VDE_0_VDETPER_TMVAL_WOFFSET                  0x0
#define MC_TIMEOUT_VDE_0_VDETPER_TMVAL_DEFAULT                  _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_VDE_0_VDETPER_TMVAL_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_VDE_0_VDETPER_TMVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_VDE_0_VDETPER_TMVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_VDE_0_VDEBSEVW_TMVAL_SHIFT                   _MK_SHIFT_CONST(16)
#define MC_TIMEOUT_VDE_0_VDEBSEVW_TMVAL_FIELD                   (_MK_MASK_CONST(0xf) << MC_TIMEOUT_VDE_0_VDEBSEVW_TMVAL_SHIFT)
#define MC_TIMEOUT_VDE_0_VDEBSEVW_TMVAL_RANGE                   19:16
#define MC_TIMEOUT_VDE_0_VDEBSEVW_TMVAL_WOFFSET                 0x0
#define MC_TIMEOUT_VDE_0_VDEBSEVW_TMVAL_DEFAULT                 _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_VDE_0_VDEBSEVW_TMVAL_DEFAULT_MASK                    _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_VDE_0_VDEBSEVW_TMVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_VDE_0_VDEBSEVW_TMVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_VDE_0_VDEMBEW_TMVAL_SHIFT                    _MK_SHIFT_CONST(20)
#define MC_TIMEOUT_VDE_0_VDEMBEW_TMVAL_FIELD                    (_MK_MASK_CONST(0xf) << MC_TIMEOUT_VDE_0_VDEMBEW_TMVAL_SHIFT)
#define MC_TIMEOUT_VDE_0_VDEMBEW_TMVAL_RANGE                    23:20
#define MC_TIMEOUT_VDE_0_VDEMBEW_TMVAL_WOFFSET                  0x0
#define MC_TIMEOUT_VDE_0_VDEMBEW_TMVAL_DEFAULT                  _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_VDE_0_VDEMBEW_TMVAL_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_VDE_0_VDEMBEW_TMVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_VDE_0_VDEMBEW_TMVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_VDE_0_VDETPMW_TMVAL_SHIFT                    _MK_SHIFT_CONST(24)
#define MC_TIMEOUT_VDE_0_VDETPMW_TMVAL_FIELD                    (_MK_MASK_CONST(0xf) << MC_TIMEOUT_VDE_0_VDETPMW_TMVAL_SHIFT)
#define MC_TIMEOUT_VDE_0_VDETPMW_TMVAL_RANGE                    27:24
#define MC_TIMEOUT_VDE_0_VDETPMW_TMVAL_WOFFSET                  0x0
#define MC_TIMEOUT_VDE_0_VDETPMW_TMVAL_DEFAULT                  _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_VDE_0_VDETPMW_TMVAL_DEFAULT_MASK                     _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_VDE_0_VDETPMW_TMVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_VDE_0_VDETPMW_TMVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_VI_0  
#define MC_TIMEOUT_VI_0                 _MK_ADDR_CONST(0x1f0)
#define MC_TIMEOUT_VI_0_SECURE                  0x0
#define MC_TIMEOUT_VI_0_WORD_COUNT                      0x1
#define MC_TIMEOUT_VI_0_RESET_VAL                       _MK_MASK_CONST(0x88888)
#define MC_TIMEOUT_VI_0_RESET_MASK                      _MK_MASK_CONST(0xfffff)
#define MC_TIMEOUT_VI_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_VI_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_VI_0_READ_MASK                       _MK_MASK_CONST(0xfffff)
#define MC_TIMEOUT_VI_0_WRITE_MASK                      _MK_MASK_CONST(0xfffff)
#define MC_TIMEOUT_VI_0_VIRUV_TMVAL_SHIFT                       _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_VI_0_VIRUV_TMVAL_FIELD                       (_MK_MASK_CONST(0xf) << MC_TIMEOUT_VI_0_VIRUV_TMVAL_SHIFT)
#define MC_TIMEOUT_VI_0_VIRUV_TMVAL_RANGE                       3:0
#define MC_TIMEOUT_VI_0_VIRUV_TMVAL_WOFFSET                     0x0
#define MC_TIMEOUT_VI_0_VIRUV_TMVAL_DEFAULT                     _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_VI_0_VIRUV_TMVAL_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_VI_0_VIRUV_TMVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_VI_0_VIRUV_TMVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_VI_0_VIWSB_TMVAL_SHIFT                       _MK_SHIFT_CONST(4)
#define MC_TIMEOUT_VI_0_VIWSB_TMVAL_FIELD                       (_MK_MASK_CONST(0xf) << MC_TIMEOUT_VI_0_VIWSB_TMVAL_SHIFT)
#define MC_TIMEOUT_VI_0_VIWSB_TMVAL_RANGE                       7:4
#define MC_TIMEOUT_VI_0_VIWSB_TMVAL_WOFFSET                     0x0
#define MC_TIMEOUT_VI_0_VIWSB_TMVAL_DEFAULT                     _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_VI_0_VIWSB_TMVAL_DEFAULT_MASK                        _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_VI_0_VIWSB_TMVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_VI_0_VIWSB_TMVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_VI_0_VIWU_TMVAL_SHIFT                        _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_VI_0_VIWU_TMVAL_FIELD                        (_MK_MASK_CONST(0xf) << MC_TIMEOUT_VI_0_VIWU_TMVAL_SHIFT)
#define MC_TIMEOUT_VI_0_VIWU_TMVAL_RANGE                        11:8
#define MC_TIMEOUT_VI_0_VIWU_TMVAL_WOFFSET                      0x0
#define MC_TIMEOUT_VI_0_VIWU_TMVAL_DEFAULT                      _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_VI_0_VIWU_TMVAL_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_VI_0_VIWU_TMVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_VI_0_VIWU_TMVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_VI_0_VIWV_TMVAL_SHIFT                        _MK_SHIFT_CONST(12)
#define MC_TIMEOUT_VI_0_VIWV_TMVAL_FIELD                        (_MK_MASK_CONST(0xf) << MC_TIMEOUT_VI_0_VIWV_TMVAL_SHIFT)
#define MC_TIMEOUT_VI_0_VIWV_TMVAL_RANGE                        15:12
#define MC_TIMEOUT_VI_0_VIWV_TMVAL_WOFFSET                      0x0
#define MC_TIMEOUT_VI_0_VIWV_TMVAL_DEFAULT                      _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_VI_0_VIWV_TMVAL_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_VI_0_VIWV_TMVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_VI_0_VIWV_TMVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_VI_0_VIWY_TMVAL_SHIFT                        _MK_SHIFT_CONST(16)
#define MC_TIMEOUT_VI_0_VIWY_TMVAL_FIELD                        (_MK_MASK_CONST(0xf) << MC_TIMEOUT_VI_0_VIWY_TMVAL_SHIFT)
#define MC_TIMEOUT_VI_0_VIWY_TMVAL_RANGE                        19:16
#define MC_TIMEOUT_VI_0_VIWY_TMVAL_WOFFSET                      0x0
#define MC_TIMEOUT_VI_0_VIWY_TMVAL_DEFAULT                      _MK_MASK_CONST(0x8)
#define MC_TIMEOUT_VI_0_VIWY_TMVAL_DEFAULT_MASK                 _MK_MASK_CONST(0xf)
#define MC_TIMEOUT_VI_0_VIWY_TMVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_VI_0_VIWY_TMVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_RCOAL_AVPC_0  
#define MC_TIMEOUT_RCOAL_AVPC_0                 _MK_ADDR_CONST(0x1f4)
#define MC_TIMEOUT_RCOAL_AVPC_0_SECURE                  0x0
#define MC_TIMEOUT_RCOAL_AVPC_0_WORD_COUNT                      0x1
#define MC_TIMEOUT_RCOAL_AVPC_0_RESET_VAL                       _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_AVPC_0_RESET_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_AVPC_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_AVPC_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_AVPC_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_AVPC_0_WRITE_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_AVPC_0_AVPCARM7R_RCOAL_TMVAL_SHIFT                     _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_RCOAL_AVPC_0_AVPCARM7R_RCOAL_TMVAL_FIELD                     (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_AVPC_0_AVPCARM7R_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_AVPC_0_AVPCARM7R_RCOAL_TMVAL_RANGE                     7:0
#define MC_TIMEOUT_RCOAL_AVPC_0_AVPCARM7R_RCOAL_TMVAL_WOFFSET                   0x0
#define MC_TIMEOUT_RCOAL_AVPC_0_AVPCARM7R_RCOAL_TMVAL_DEFAULT                   _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_AVPC_0_AVPCARM7R_RCOAL_TMVAL_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_AVPC_0_AVPCARM7R_RCOAL_TMVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_AVPC_0_AVPCARM7R_RCOAL_TMVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_RCOAL_DC_0  
#define MC_TIMEOUT_RCOAL_DC_0                   _MK_ADDR_CONST(0x1f8)
#define MC_TIMEOUT_RCOAL_DC_0_SECURE                    0x0
#define MC_TIMEOUT_RCOAL_DC_0_WORD_COUNT                        0x1
#define MC_TIMEOUT_RCOAL_DC_0_RESET_VAL                         _MK_MASK_CONST(0x4040404)
#define MC_TIMEOUT_RCOAL_DC_0_RESET_MASK                        _MK_MASK_CONST(0xffffffff)
#define MC_TIMEOUT_RCOAL_DC_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_DC_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_DC_0_READ_MASK                         _MK_MASK_CONST(0xffffffff)
#define MC_TIMEOUT_RCOAL_DC_0_WRITE_MASK                        _MK_MASK_CONST(0xffffffff)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0A_RCOAL_TMVAL_SHIFT                       _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0A_RCOAL_TMVAL_FIELD                       (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_DC_0_DISPLAY0A_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0A_RCOAL_TMVAL_RANGE                       7:0
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0A_RCOAL_TMVAL_WOFFSET                     0x0
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0A_RCOAL_TMVAL_DEFAULT                     _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0A_RCOAL_TMVAL_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0A_RCOAL_TMVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0A_RCOAL_TMVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0B_RCOAL_TMVAL_SHIFT                       _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0B_RCOAL_TMVAL_FIELD                       (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_DC_0_DISPLAY0B_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0B_RCOAL_TMVAL_RANGE                       15:8
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0B_RCOAL_TMVAL_WOFFSET                     0x0
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0B_RCOAL_TMVAL_DEFAULT                     _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0B_RCOAL_TMVAL_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0B_RCOAL_TMVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0B_RCOAL_TMVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0C_RCOAL_TMVAL_SHIFT                       _MK_SHIFT_CONST(16)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0C_RCOAL_TMVAL_FIELD                       (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_DC_0_DISPLAY0C_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0C_RCOAL_TMVAL_RANGE                       23:16
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0C_RCOAL_TMVAL_WOFFSET                     0x0
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0C_RCOAL_TMVAL_DEFAULT                     _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0C_RCOAL_TMVAL_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0C_RCOAL_TMVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY0C_RCOAL_TMVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY1B_RCOAL_TMVAL_SHIFT                       _MK_SHIFT_CONST(24)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY1B_RCOAL_TMVAL_FIELD                       (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_DC_0_DISPLAY1B_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY1B_RCOAL_TMVAL_RANGE                       31:24
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY1B_RCOAL_TMVAL_WOFFSET                     0x0
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY1B_RCOAL_TMVAL_DEFAULT                     _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY1B_RCOAL_TMVAL_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY1B_RCOAL_TMVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_DC_0_DISPLAY1B_RCOAL_TMVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT1_RCOAL_DC_0  
#define MC_TIMEOUT1_RCOAL_DC_0                  _MK_ADDR_CONST(0x1fc)
#define MC_TIMEOUT1_RCOAL_DC_0_SECURE                   0x0
#define MC_TIMEOUT1_RCOAL_DC_0_WORD_COUNT                       0x1
#define MC_TIMEOUT1_RCOAL_DC_0_RESET_VAL                        _MK_MASK_CONST(0x4)
#define MC_TIMEOUT1_RCOAL_DC_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define MC_TIMEOUT1_RCOAL_DC_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT1_RCOAL_DC_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT1_RCOAL_DC_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define MC_TIMEOUT1_RCOAL_DC_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
#define MC_TIMEOUT1_RCOAL_DC_0_DISPLAYHC_RCOAL_TMVAL_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_TIMEOUT1_RCOAL_DC_0_DISPLAYHC_RCOAL_TMVAL_FIELD                      (_MK_MASK_CONST(0xff) << MC_TIMEOUT1_RCOAL_DC_0_DISPLAYHC_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT1_RCOAL_DC_0_DISPLAYHC_RCOAL_TMVAL_RANGE                      7:0
#define MC_TIMEOUT1_RCOAL_DC_0_DISPLAYHC_RCOAL_TMVAL_WOFFSET                    0x0
#define MC_TIMEOUT1_RCOAL_DC_0_DISPLAYHC_RCOAL_TMVAL_DEFAULT                    _MK_MASK_CONST(0x4)
#define MC_TIMEOUT1_RCOAL_DC_0_DISPLAYHC_RCOAL_TMVAL_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define MC_TIMEOUT1_RCOAL_DC_0_DISPLAYHC_RCOAL_TMVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_TIMEOUT1_RCOAL_DC_0_DISPLAYHC_RCOAL_TMVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_RCOAL_DCB_0  
#define MC_TIMEOUT_RCOAL_DCB_0                  _MK_ADDR_CONST(0x200)
#define MC_TIMEOUT_RCOAL_DCB_0_SECURE                   0x0
#define MC_TIMEOUT_RCOAL_DCB_0_WORD_COUNT                       0x1
#define MC_TIMEOUT_RCOAL_DCB_0_RESET_VAL                        _MK_MASK_CONST(0x4040404)
#define MC_TIMEOUT_RCOAL_DCB_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define MC_TIMEOUT_RCOAL_DCB_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_DCB_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_DCB_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define MC_TIMEOUT_RCOAL_DCB_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0AB_RCOAL_TMVAL_SHIFT                     _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0AB_RCOAL_TMVAL_FIELD                     (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0AB_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0AB_RCOAL_TMVAL_RANGE                     7:0
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0AB_RCOAL_TMVAL_WOFFSET                   0x0
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0AB_RCOAL_TMVAL_DEFAULT                   _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0AB_RCOAL_TMVAL_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0AB_RCOAL_TMVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0AB_RCOAL_TMVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0BB_RCOAL_TMVAL_SHIFT                     _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0BB_RCOAL_TMVAL_FIELD                     (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0BB_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0BB_RCOAL_TMVAL_RANGE                     15:8
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0BB_RCOAL_TMVAL_WOFFSET                   0x0
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0BB_RCOAL_TMVAL_DEFAULT                   _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0BB_RCOAL_TMVAL_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0BB_RCOAL_TMVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0BB_RCOAL_TMVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0CB_RCOAL_TMVAL_SHIFT                     _MK_SHIFT_CONST(16)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0CB_RCOAL_TMVAL_FIELD                     (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0CB_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0CB_RCOAL_TMVAL_RANGE                     23:16
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0CB_RCOAL_TMVAL_WOFFSET                   0x0
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0CB_RCOAL_TMVAL_DEFAULT                   _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0CB_RCOAL_TMVAL_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0CB_RCOAL_TMVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY0CB_RCOAL_TMVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY1BB_RCOAL_TMVAL_SHIFT                     _MK_SHIFT_CONST(24)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY1BB_RCOAL_TMVAL_FIELD                     (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_DCB_0_DISPLAY1BB_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY1BB_RCOAL_TMVAL_RANGE                     31:24
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY1BB_RCOAL_TMVAL_WOFFSET                   0x0
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY1BB_RCOAL_TMVAL_DEFAULT                   _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY1BB_RCOAL_TMVAL_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY1BB_RCOAL_TMVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_DCB_0_DISPLAY1BB_RCOAL_TMVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT1_RCOAL_DCB_0  
#define MC_TIMEOUT1_RCOAL_DCB_0                 _MK_ADDR_CONST(0x204)
#define MC_TIMEOUT1_RCOAL_DCB_0_SECURE                  0x0
#define MC_TIMEOUT1_RCOAL_DCB_0_WORD_COUNT                      0x1
#define MC_TIMEOUT1_RCOAL_DCB_0_RESET_VAL                       _MK_MASK_CONST(0x4)
#define MC_TIMEOUT1_RCOAL_DCB_0_RESET_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT1_RCOAL_DCB_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT1_RCOAL_DCB_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_TIMEOUT1_RCOAL_DCB_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define MC_TIMEOUT1_RCOAL_DCB_0_WRITE_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT1_RCOAL_DCB_0_DISPLAYHCB_RCOAL_TMVAL_SHIFT                    _MK_SHIFT_CONST(0)
#define MC_TIMEOUT1_RCOAL_DCB_0_DISPLAYHCB_RCOAL_TMVAL_FIELD                    (_MK_MASK_CONST(0xff) << MC_TIMEOUT1_RCOAL_DCB_0_DISPLAYHCB_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT1_RCOAL_DCB_0_DISPLAYHCB_RCOAL_TMVAL_RANGE                    7:0
#define MC_TIMEOUT1_RCOAL_DCB_0_DISPLAYHCB_RCOAL_TMVAL_WOFFSET                  0x0
#define MC_TIMEOUT1_RCOAL_DCB_0_DISPLAYHCB_RCOAL_TMVAL_DEFAULT                  _MK_MASK_CONST(0x4)
#define MC_TIMEOUT1_RCOAL_DCB_0_DISPLAYHCB_RCOAL_TMVAL_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define MC_TIMEOUT1_RCOAL_DCB_0_DISPLAYHCB_RCOAL_TMVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_TIMEOUT1_RCOAL_DCB_0_DISPLAYHCB_RCOAL_TMVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_RCOAL_EPP_0  
#define MC_TIMEOUT_RCOAL_EPP_0                  _MK_ADDR_CONST(0x208)
#define MC_TIMEOUT_RCOAL_EPP_0_SECURE                   0x0
#define MC_TIMEOUT_RCOAL_EPP_0_WORD_COUNT                       0x1
#define MC_TIMEOUT_RCOAL_EPP_0_RESET_VAL                        _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_EPP_0_RESET_MASK                       _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_EPP_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_EPP_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_EPP_0_READ_MASK                        _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_EPP_0_WRITE_MASK                       _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_EPP_0_EPPUP_RCOAL_TMVAL_SHIFT                  _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_RCOAL_EPP_0_EPPUP_RCOAL_TMVAL_FIELD                  (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_EPP_0_EPPUP_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_EPP_0_EPPUP_RCOAL_TMVAL_RANGE                  7:0
#define MC_TIMEOUT_RCOAL_EPP_0_EPPUP_RCOAL_TMVAL_WOFFSET                        0x0
#define MC_TIMEOUT_RCOAL_EPP_0_EPPUP_RCOAL_TMVAL_DEFAULT                        _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_EPP_0_EPPUP_RCOAL_TMVAL_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_EPP_0_EPPUP_RCOAL_TMVAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_EPP_0_EPPUP_RCOAL_TMVAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_RCOAL_G2_0  
#define MC_TIMEOUT_RCOAL_G2_0                   _MK_ADDR_CONST(0x20c)
#define MC_TIMEOUT_RCOAL_G2_0_SECURE                    0x0
#define MC_TIMEOUT_RCOAL_G2_0_WORD_COUNT                        0x1
#define MC_TIMEOUT_RCOAL_G2_0_RESET_VAL                         _MK_MASK_CONST(0x40404)
#define MC_TIMEOUT_RCOAL_G2_0_RESET_MASK                        _MK_MASK_CONST(0xffffff)
#define MC_TIMEOUT_RCOAL_G2_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_G2_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_G2_0_READ_MASK                         _MK_MASK_CONST(0xffffff)
#define MC_TIMEOUT_RCOAL_G2_0_WRITE_MASK                        _MK_MASK_CONST(0xffffff)
#define MC_TIMEOUT_RCOAL_G2_0_G2PR_RCOAL_TMVAL_SHIFT                    _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_RCOAL_G2_0_G2PR_RCOAL_TMVAL_FIELD                    (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_G2_0_G2PR_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_G2_0_G2PR_RCOAL_TMVAL_RANGE                    7:0
#define MC_TIMEOUT_RCOAL_G2_0_G2PR_RCOAL_TMVAL_WOFFSET                  0x0
#define MC_TIMEOUT_RCOAL_G2_0_G2PR_RCOAL_TMVAL_DEFAULT                  _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_G2_0_G2PR_RCOAL_TMVAL_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_G2_0_G2PR_RCOAL_TMVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_G2_0_G2PR_RCOAL_TMVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_RCOAL_G2_0_G2SR_RCOAL_TMVAL_SHIFT                    _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_RCOAL_G2_0_G2SR_RCOAL_TMVAL_FIELD                    (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_G2_0_G2SR_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_G2_0_G2SR_RCOAL_TMVAL_RANGE                    15:8
#define MC_TIMEOUT_RCOAL_G2_0_G2SR_RCOAL_TMVAL_WOFFSET                  0x0
#define MC_TIMEOUT_RCOAL_G2_0_G2SR_RCOAL_TMVAL_DEFAULT                  _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_G2_0_G2SR_RCOAL_TMVAL_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_G2_0_G2SR_RCOAL_TMVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_G2_0_G2SR_RCOAL_TMVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_RCOAL_G2_0_G2DR_RCOAL_TMVAL_SHIFT                    _MK_SHIFT_CONST(16)
#define MC_TIMEOUT_RCOAL_G2_0_G2DR_RCOAL_TMVAL_FIELD                    (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_G2_0_G2DR_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_G2_0_G2DR_RCOAL_TMVAL_RANGE                    23:16
#define MC_TIMEOUT_RCOAL_G2_0_G2DR_RCOAL_TMVAL_WOFFSET                  0x0
#define MC_TIMEOUT_RCOAL_G2_0_G2DR_RCOAL_TMVAL_DEFAULT                  _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_G2_0_G2DR_RCOAL_TMVAL_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_G2_0_G2DR_RCOAL_TMVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_G2_0_G2DR_RCOAL_TMVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_RCOAL_HC_0  
#define MC_TIMEOUT_RCOAL_HC_0                   _MK_ADDR_CONST(0x210)
#define MC_TIMEOUT_RCOAL_HC_0_SECURE                    0x0
#define MC_TIMEOUT_RCOAL_HC_0_WORD_COUNT                        0x1
#define MC_TIMEOUT_RCOAL_HC_0_RESET_VAL                         _MK_MASK_CONST(0x404)
#define MC_TIMEOUT_RCOAL_HC_0_RESET_MASK                        _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_RCOAL_HC_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_HC_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_HC_0_READ_MASK                         _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_RCOAL_HC_0_WRITE_MASK                        _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_RCOAL_HC_0_HOST1XDMAR_RCOAL_TMVAL_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_RCOAL_HC_0_HOST1XDMAR_RCOAL_TMVAL_FIELD                      (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_HC_0_HOST1XDMAR_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_HC_0_HOST1XDMAR_RCOAL_TMVAL_RANGE                      7:0
#define MC_TIMEOUT_RCOAL_HC_0_HOST1XDMAR_RCOAL_TMVAL_WOFFSET                    0x0
#define MC_TIMEOUT_RCOAL_HC_0_HOST1XDMAR_RCOAL_TMVAL_DEFAULT                    _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_HC_0_HOST1XDMAR_RCOAL_TMVAL_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_HC_0_HOST1XDMAR_RCOAL_TMVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_HC_0_HOST1XDMAR_RCOAL_TMVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_RCOAL_HC_0_HOST1XR_RCOAL_TMVAL_SHIFT                 _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_RCOAL_HC_0_HOST1XR_RCOAL_TMVAL_FIELD                 (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_HC_0_HOST1XR_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_HC_0_HOST1XR_RCOAL_TMVAL_RANGE                 15:8
#define MC_TIMEOUT_RCOAL_HC_0_HOST1XR_RCOAL_TMVAL_WOFFSET                       0x0
#define MC_TIMEOUT_RCOAL_HC_0_HOST1XR_RCOAL_TMVAL_DEFAULT                       _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_HC_0_HOST1XR_RCOAL_TMVAL_DEFAULT_MASK                  _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_HC_0_HOST1XR_RCOAL_TMVAL_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_HC_0_HOST1XR_RCOAL_TMVAL_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_RCOAL_MPCORE_0  
#define MC_TIMEOUT_RCOAL_MPCORE_0                       _MK_ADDR_CONST(0x214)
#define MC_TIMEOUT_RCOAL_MPCORE_0_SECURE                        0x0
#define MC_TIMEOUT_RCOAL_MPCORE_0_WORD_COUNT                    0x1
#define MC_TIMEOUT_RCOAL_MPCORE_0_RESET_VAL                     _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_MPCORE_0_RESET_MASK                    _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_MPCORE_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_MPCORE_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_MPCORE_0_READ_MASK                     _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_MPCORE_0_WRITE_MASK                    _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_MPCORE_0_MPCORER_RCOAL_TMVAL_SHIFT                     _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_RCOAL_MPCORE_0_MPCORER_RCOAL_TMVAL_FIELD                     (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_MPCORE_0_MPCORER_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_MPCORE_0_MPCORER_RCOAL_TMVAL_RANGE                     7:0
#define MC_TIMEOUT_RCOAL_MPCORE_0_MPCORER_RCOAL_TMVAL_WOFFSET                   0x0
#define MC_TIMEOUT_RCOAL_MPCORE_0_MPCORER_RCOAL_TMVAL_DEFAULT                   _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_MPCORE_0_MPCORER_RCOAL_TMVAL_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_MPCORE_0_MPCORER_RCOAL_TMVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_MPCORE_0_MPCORER_RCOAL_TMVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_RCOAL_MPEA_0  
#define MC_TIMEOUT_RCOAL_MPEA_0                 _MK_ADDR_CONST(0x218)
#define MC_TIMEOUT_RCOAL_MPEA_0_SECURE                  0x0
#define MC_TIMEOUT_RCOAL_MPEA_0_WORD_COUNT                      0x1
#define MC_TIMEOUT_RCOAL_MPEA_0_RESET_VAL                       _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_MPEA_0_RESET_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_MPEA_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_MPEA_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_MPEA_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_MPEA_0_WRITE_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_MPEA_0_MPEAMEMRD_RCOAL_TMVAL_SHIFT                     _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_RCOAL_MPEA_0_MPEAMEMRD_RCOAL_TMVAL_FIELD                     (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_MPEA_0_MPEAMEMRD_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_MPEA_0_MPEAMEMRD_RCOAL_TMVAL_RANGE                     7:0
#define MC_TIMEOUT_RCOAL_MPEA_0_MPEAMEMRD_RCOAL_TMVAL_WOFFSET                   0x0
#define MC_TIMEOUT_RCOAL_MPEA_0_MPEAMEMRD_RCOAL_TMVAL_DEFAULT                   _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_MPEA_0_MPEAMEMRD_RCOAL_TMVAL_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_MPEA_0_MPEAMEMRD_RCOAL_TMVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_MPEA_0_MPEAMEMRD_RCOAL_TMVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_RCOAL_MPEB_0  
#define MC_TIMEOUT_RCOAL_MPEB_0                 _MK_ADDR_CONST(0x21c)
#define MC_TIMEOUT_RCOAL_MPEB_0_SECURE                  0x0
#define MC_TIMEOUT_RCOAL_MPEB_0_WORD_COUNT                      0x1
#define MC_TIMEOUT_RCOAL_MPEB_0_RESET_VAL                       _MK_MASK_CONST(0x404)
#define MC_TIMEOUT_RCOAL_MPEB_0_RESET_MASK                      _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_RCOAL_MPEB_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_MPEB_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_MPEB_0_READ_MASK                       _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_RCOAL_MPEB_0_WRITE_MASK                      _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_RCOAL_MPEB_0_MPEUNIFBR_RCOAL_TMVAL_SHIFT                     _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_RCOAL_MPEB_0_MPEUNIFBR_RCOAL_TMVAL_FIELD                     (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_MPEB_0_MPEUNIFBR_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_MPEB_0_MPEUNIFBR_RCOAL_TMVAL_RANGE                     7:0
#define MC_TIMEOUT_RCOAL_MPEB_0_MPEUNIFBR_RCOAL_TMVAL_WOFFSET                   0x0
#define MC_TIMEOUT_RCOAL_MPEB_0_MPEUNIFBR_RCOAL_TMVAL_DEFAULT                   _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_MPEB_0_MPEUNIFBR_RCOAL_TMVAL_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_MPEB_0_MPEUNIFBR_RCOAL_TMVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_MPEB_0_MPEUNIFBR_RCOAL_TMVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_RCOAL_MPEB_0_MPE_IPRED_RCOAL_TMVAL_SHIFT                     _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_RCOAL_MPEB_0_MPE_IPRED_RCOAL_TMVAL_FIELD                     (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_MPEB_0_MPE_IPRED_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_MPEB_0_MPE_IPRED_RCOAL_TMVAL_RANGE                     15:8
#define MC_TIMEOUT_RCOAL_MPEB_0_MPE_IPRED_RCOAL_TMVAL_WOFFSET                   0x0
#define MC_TIMEOUT_RCOAL_MPEB_0_MPE_IPRED_RCOAL_TMVAL_DEFAULT                   _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_MPEB_0_MPE_IPRED_RCOAL_TMVAL_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_MPEB_0_MPE_IPRED_RCOAL_TMVAL_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_MPEB_0_MPE_IPRED_RCOAL_TMVAL_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_RCOAL_MPEC_0  
#define MC_TIMEOUT_RCOAL_MPEC_0                 _MK_ADDR_CONST(0x220)
#define MC_TIMEOUT_RCOAL_MPEC_0_SECURE                  0x0
#define MC_TIMEOUT_RCOAL_MPEC_0_WORD_COUNT                      0x1
#define MC_TIMEOUT_RCOAL_MPEC_0_RESET_VAL                       _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_MPEC_0_RESET_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_MPEC_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_MPEC_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_MPEC_0_READ_MASK                       _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_MPEC_0_WRITE_MASK                      _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_MPEC_0_MPECSRD_RCOAL_TMVAL_SHIFT                       _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_RCOAL_MPEC_0_MPECSRD_RCOAL_TMVAL_FIELD                       (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_MPEC_0_MPECSRD_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_MPEC_0_MPECSRD_RCOAL_TMVAL_RANGE                       7:0
#define MC_TIMEOUT_RCOAL_MPEC_0_MPECSRD_RCOAL_TMVAL_WOFFSET                     0x0
#define MC_TIMEOUT_RCOAL_MPEC_0_MPECSRD_RCOAL_TMVAL_DEFAULT                     _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_MPEC_0_MPECSRD_RCOAL_TMVAL_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_MPEC_0_MPECSRD_RCOAL_TMVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_MPEC_0_MPECSRD_RCOAL_TMVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_RCOAL_NV_0  
#define MC_TIMEOUT_RCOAL_NV_0                   _MK_ADDR_CONST(0x224)
#define MC_TIMEOUT_RCOAL_NV_0_SECURE                    0x0
#define MC_TIMEOUT_RCOAL_NV_0_WORD_COUNT                        0x1
#define MC_TIMEOUT_RCOAL_NV_0_RESET_VAL                         _MK_MASK_CONST(0x404)
#define MC_TIMEOUT_RCOAL_NV_0_RESET_MASK                        _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_RCOAL_NV_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_NV_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_NV_0_READ_MASK                         _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_RCOAL_NV_0_WRITE_MASK                        _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_RCOAL_NV_0_IDXSRD_RCOAL_TMVAL_SHIFT                  _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_RCOAL_NV_0_IDXSRD_RCOAL_TMVAL_FIELD                  (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_NV_0_IDXSRD_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_NV_0_IDXSRD_RCOAL_TMVAL_RANGE                  7:0
#define MC_TIMEOUT_RCOAL_NV_0_IDXSRD_RCOAL_TMVAL_WOFFSET                        0x0
#define MC_TIMEOUT_RCOAL_NV_0_IDXSRD_RCOAL_TMVAL_DEFAULT                        _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_NV_0_IDXSRD_RCOAL_TMVAL_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_NV_0_IDXSRD_RCOAL_TMVAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_NV_0_IDXSRD_RCOAL_TMVAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_RCOAL_NV_0_TEXSRD_RCOAL_TMVAL_SHIFT                  _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_RCOAL_NV_0_TEXSRD_RCOAL_TMVAL_FIELD                  (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_NV_0_TEXSRD_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_NV_0_TEXSRD_RCOAL_TMVAL_RANGE                  15:8
#define MC_TIMEOUT_RCOAL_NV_0_TEXSRD_RCOAL_TMVAL_WOFFSET                        0x0
#define MC_TIMEOUT_RCOAL_NV_0_TEXSRD_RCOAL_TMVAL_DEFAULT                        _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_NV_0_TEXSRD_RCOAL_TMVAL_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_NV_0_TEXSRD_RCOAL_TMVAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_NV_0_TEXSRD_RCOAL_TMVAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_RCOAL_PPCS_0  
#define MC_TIMEOUT_RCOAL_PPCS_0                 _MK_ADDR_CONST(0x228)
#define MC_TIMEOUT_RCOAL_PPCS_0_SECURE                  0x0
#define MC_TIMEOUT_RCOAL_PPCS_0_WORD_COUNT                      0x1
#define MC_TIMEOUT_RCOAL_PPCS_0_RESET_VAL                       _MK_MASK_CONST(0x404)
#define MC_TIMEOUT_RCOAL_PPCS_0_RESET_MASK                      _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_RCOAL_PPCS_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_PPCS_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_PPCS_0_READ_MASK                       _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_RCOAL_PPCS_0_WRITE_MASK                      _MK_MASK_CONST(0xffff)
#define MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBDMAR_RCOAL_TMVAL_SHIFT                   _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBDMAR_RCOAL_TMVAL_FIELD                   (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBDMAR_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBDMAR_RCOAL_TMVAL_RANGE                   7:0
#define MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBDMAR_RCOAL_TMVAL_WOFFSET                 0x0
#define MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBDMAR_RCOAL_TMVAL_DEFAULT                 _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBDMAR_RCOAL_TMVAL_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBDMAR_RCOAL_TMVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBDMAR_RCOAL_TMVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBSLVR_RCOAL_TMVAL_SHIFT                   _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBSLVR_RCOAL_TMVAL_FIELD                   (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBSLVR_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBSLVR_RCOAL_TMVAL_RANGE                   15:8
#define MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBSLVR_RCOAL_TMVAL_WOFFSET                 0x0
#define MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBSLVR_RCOAL_TMVAL_DEFAULT                 _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBSLVR_RCOAL_TMVAL_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBSLVR_RCOAL_TMVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_PPCS_0_PPCSAHBSLVR_RCOAL_TMVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_RCOAL_VDE_0  
#define MC_TIMEOUT_RCOAL_VDE_0                  _MK_ADDR_CONST(0x22c)
#define MC_TIMEOUT_RCOAL_VDE_0_SECURE                   0x0
#define MC_TIMEOUT_RCOAL_VDE_0_WORD_COUNT                       0x1
#define MC_TIMEOUT_RCOAL_VDE_0_RESET_VAL                        _MK_MASK_CONST(0x4040404)
#define MC_TIMEOUT_RCOAL_VDE_0_RESET_MASK                       _MK_MASK_CONST(0xffffffff)
#define MC_TIMEOUT_RCOAL_VDE_0_SW_DEFAULT_VAL                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_VDE_0_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_VDE_0_READ_MASK                        _MK_MASK_CONST(0xffffffff)
#define MC_TIMEOUT_RCOAL_VDE_0_WRITE_MASK                       _MK_MASK_CONST(0xffffffff)
#define MC_TIMEOUT_RCOAL_VDE_0_VDEBSEVR_RCOAL_TMVAL_SHIFT                       _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_RCOAL_VDE_0_VDEBSEVR_RCOAL_TMVAL_FIELD                       (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_VDE_0_VDEBSEVR_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_VDE_0_VDEBSEVR_RCOAL_TMVAL_RANGE                       7:0
#define MC_TIMEOUT_RCOAL_VDE_0_VDEBSEVR_RCOAL_TMVAL_WOFFSET                     0x0
#define MC_TIMEOUT_RCOAL_VDE_0_VDEBSEVR_RCOAL_TMVAL_DEFAULT                     _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_VDE_0_VDEBSEVR_RCOAL_TMVAL_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_VDE_0_VDEBSEVR_RCOAL_TMVAL_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_VDE_0_VDEBSEVR_RCOAL_TMVAL_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_RCOAL_VDE_0_VDEMBER_RCOAL_TMVAL_SHIFT                        _MK_SHIFT_CONST(8)
#define MC_TIMEOUT_RCOAL_VDE_0_VDEMBER_RCOAL_TMVAL_FIELD                        (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_VDE_0_VDEMBER_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_VDE_0_VDEMBER_RCOAL_TMVAL_RANGE                        15:8
#define MC_TIMEOUT_RCOAL_VDE_0_VDEMBER_RCOAL_TMVAL_WOFFSET                      0x0
#define MC_TIMEOUT_RCOAL_VDE_0_VDEMBER_RCOAL_TMVAL_DEFAULT                      _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_VDE_0_VDEMBER_RCOAL_TMVAL_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_VDE_0_VDEMBER_RCOAL_TMVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_VDE_0_VDEMBER_RCOAL_TMVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_RCOAL_VDE_0_VDEMCER_RCOAL_TMVAL_SHIFT                        _MK_SHIFT_CONST(16)
#define MC_TIMEOUT_RCOAL_VDE_0_VDEMCER_RCOAL_TMVAL_FIELD                        (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_VDE_0_VDEMCER_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_VDE_0_VDEMCER_RCOAL_TMVAL_RANGE                        23:16
#define MC_TIMEOUT_RCOAL_VDE_0_VDEMCER_RCOAL_TMVAL_WOFFSET                      0x0
#define MC_TIMEOUT_RCOAL_VDE_0_VDEMCER_RCOAL_TMVAL_DEFAULT                      _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_VDE_0_VDEMCER_RCOAL_TMVAL_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_VDE_0_VDEMCER_RCOAL_TMVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_VDE_0_VDEMCER_RCOAL_TMVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)

#define MC_TIMEOUT_RCOAL_VDE_0_VDETPER_RCOAL_TMVAL_SHIFT                        _MK_SHIFT_CONST(24)
#define MC_TIMEOUT_RCOAL_VDE_0_VDETPER_RCOAL_TMVAL_FIELD                        (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_VDE_0_VDETPER_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_VDE_0_VDETPER_RCOAL_TMVAL_RANGE                        31:24
#define MC_TIMEOUT_RCOAL_VDE_0_VDETPER_RCOAL_TMVAL_WOFFSET                      0x0
#define MC_TIMEOUT_RCOAL_VDE_0_VDETPER_RCOAL_TMVAL_DEFAULT                      _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_VDE_0_VDETPER_RCOAL_TMVAL_DEFAULT_MASK                 _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_VDE_0_VDETPER_RCOAL_TMVAL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_VDE_0_VDETPER_RCOAL_TMVAL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)


// Register MC_TIMEOUT_RCOAL_VI_0  
#define MC_TIMEOUT_RCOAL_VI_0                   _MK_ADDR_CONST(0x230)
#define MC_TIMEOUT_RCOAL_VI_0_SECURE                    0x0
#define MC_TIMEOUT_RCOAL_VI_0_WORD_COUNT                        0x1
#define MC_TIMEOUT_RCOAL_VI_0_RESET_VAL                         _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_VI_0_RESET_MASK                        _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_VI_0_SW_DEFAULT_VAL                    _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_VI_0_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_VI_0_READ_MASK                         _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_VI_0_WRITE_MASK                        _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_VI_0_VIRUV_RCOAL_TMVAL_SHIFT                   _MK_SHIFT_CONST(0)
#define MC_TIMEOUT_RCOAL_VI_0_VIRUV_RCOAL_TMVAL_FIELD                   (_MK_MASK_CONST(0xff) << MC_TIMEOUT_RCOAL_VI_0_VIRUV_RCOAL_TMVAL_SHIFT)
#define MC_TIMEOUT_RCOAL_VI_0_VIRUV_RCOAL_TMVAL_RANGE                   7:0
#define MC_TIMEOUT_RCOAL_VI_0_VIRUV_RCOAL_TMVAL_WOFFSET                 0x0
#define MC_TIMEOUT_RCOAL_VI_0_VIRUV_RCOAL_TMVAL_DEFAULT                 _MK_MASK_CONST(0x4)
#define MC_TIMEOUT_RCOAL_VI_0_VIRUV_RCOAL_TMVAL_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define MC_TIMEOUT_RCOAL_VI_0_VIRUV_RCOAL_TMVAL_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_TIMEOUT_RCOAL_VI_0_VIRUV_RCOAL_TMVAL_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define MC_CLIENT_RCOAL_AUTODISABLE_DISABLE     0
#define MC_CLIENT_RCOAL_AUTODISABLE_ENABLE      1

// Register MC_RCOAL_AUTODISABLE_0_0  
#define MC_RCOAL_AUTODISABLE_0_0                        _MK_ADDR_CONST(0x234)
#define MC_RCOAL_AUTODISABLE_0_0_SECURE                         0x0
#define MC_RCOAL_AUTODISABLE_0_0_WORD_COUNT                     0x1
#define MC_RCOAL_AUTODISABLE_0_0_RESET_VAL                      _MK_MASK_CONST(0x1fff)
#define MC_RCOAL_AUTODISABLE_0_0_RESET_MASK                     _MK_MASK_CONST(0x1fff)
#define MC_RCOAL_AUTODISABLE_0_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_READ_MASK                      _MK_MASK_CONST(0x1fff)
#define MC_RCOAL_AUTODISABLE_0_0_WRITE_MASK                     _MK_MASK_CONST(0x1fff)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0A_RCOAL_AUTODISABLE_EN_SHIFT                   _MK_SHIFT_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0A_RCOAL_AUTODISABLE_EN_FIELD                   (_MK_MASK_CONST(0x1) << MC_RCOAL_AUTODISABLE_0_0_DISPLAY0A_RCOAL_AUTODISABLE_EN_SHIFT)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0A_RCOAL_AUTODISABLE_EN_RANGE                   0:0
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0A_RCOAL_AUTODISABLE_EN_WOFFSET                 0x0
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0A_RCOAL_AUTODISABLE_EN_DEFAULT                 _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0A_RCOAL_AUTODISABLE_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0A_RCOAL_AUTODISABLE_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0A_RCOAL_AUTODISABLE_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0A_RCOAL_AUTODISABLE_EN_INIT_ENUM                       ENABLE
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0A_RCOAL_AUTODISABLE_EN_DISABLE                 _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0A_RCOAL_AUTODISABLE_EN_ENABLE                  _MK_ENUM_CONST(1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0A_RCOAL_AUTODISABLE_EN_DISABLED                        _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0A_RCOAL_AUTODISABLE_EN_ENABLED                 _MK_ENUM_CONST(1)

#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0AB_RCOAL_AUTODISABLE_EN_SHIFT                  _MK_SHIFT_CONST(1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0AB_RCOAL_AUTODISABLE_EN_FIELD                  (_MK_MASK_CONST(0x1) << MC_RCOAL_AUTODISABLE_0_0_DISPLAY0AB_RCOAL_AUTODISABLE_EN_SHIFT)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0AB_RCOAL_AUTODISABLE_EN_RANGE                  1:1
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0AB_RCOAL_AUTODISABLE_EN_WOFFSET                        0x0
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0AB_RCOAL_AUTODISABLE_EN_DEFAULT                        _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0AB_RCOAL_AUTODISABLE_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0AB_RCOAL_AUTODISABLE_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0AB_RCOAL_AUTODISABLE_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0AB_RCOAL_AUTODISABLE_EN_INIT_ENUM                      ENABLE
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0AB_RCOAL_AUTODISABLE_EN_DISABLE                        _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0AB_RCOAL_AUTODISABLE_EN_ENABLE                 _MK_ENUM_CONST(1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0AB_RCOAL_AUTODISABLE_EN_DISABLED                       _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0AB_RCOAL_AUTODISABLE_EN_ENABLED                        _MK_ENUM_CONST(1)

#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0B_RCOAL_AUTODISABLE_EN_SHIFT                   _MK_SHIFT_CONST(2)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0B_RCOAL_AUTODISABLE_EN_FIELD                   (_MK_MASK_CONST(0x1) << MC_RCOAL_AUTODISABLE_0_0_DISPLAY0B_RCOAL_AUTODISABLE_EN_SHIFT)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0B_RCOAL_AUTODISABLE_EN_RANGE                   2:2
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0B_RCOAL_AUTODISABLE_EN_WOFFSET                 0x0
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0B_RCOAL_AUTODISABLE_EN_DEFAULT                 _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0B_RCOAL_AUTODISABLE_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0B_RCOAL_AUTODISABLE_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0B_RCOAL_AUTODISABLE_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0B_RCOAL_AUTODISABLE_EN_INIT_ENUM                       ENABLE
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0B_RCOAL_AUTODISABLE_EN_DISABLE                 _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0B_RCOAL_AUTODISABLE_EN_ENABLE                  _MK_ENUM_CONST(1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0B_RCOAL_AUTODISABLE_EN_DISABLED                        _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0B_RCOAL_AUTODISABLE_EN_ENABLED                 _MK_ENUM_CONST(1)

#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0BB_RCOAL_AUTODISABLE_EN_SHIFT                  _MK_SHIFT_CONST(3)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0BB_RCOAL_AUTODISABLE_EN_FIELD                  (_MK_MASK_CONST(0x1) << MC_RCOAL_AUTODISABLE_0_0_DISPLAY0BB_RCOAL_AUTODISABLE_EN_SHIFT)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0BB_RCOAL_AUTODISABLE_EN_RANGE                  3:3
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0BB_RCOAL_AUTODISABLE_EN_WOFFSET                        0x0
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0BB_RCOAL_AUTODISABLE_EN_DEFAULT                        _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0BB_RCOAL_AUTODISABLE_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0BB_RCOAL_AUTODISABLE_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0BB_RCOAL_AUTODISABLE_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0BB_RCOAL_AUTODISABLE_EN_INIT_ENUM                      ENABLE
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0BB_RCOAL_AUTODISABLE_EN_DISABLE                        _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0BB_RCOAL_AUTODISABLE_EN_ENABLE                 _MK_ENUM_CONST(1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0BB_RCOAL_AUTODISABLE_EN_DISABLED                       _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0BB_RCOAL_AUTODISABLE_EN_ENABLED                        _MK_ENUM_CONST(1)

#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0C_RCOAL_AUTODISABLE_EN_SHIFT                   _MK_SHIFT_CONST(4)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0C_RCOAL_AUTODISABLE_EN_FIELD                   (_MK_MASK_CONST(0x1) << MC_RCOAL_AUTODISABLE_0_0_DISPLAY0C_RCOAL_AUTODISABLE_EN_SHIFT)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0C_RCOAL_AUTODISABLE_EN_RANGE                   4:4
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0C_RCOAL_AUTODISABLE_EN_WOFFSET                 0x0
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0C_RCOAL_AUTODISABLE_EN_DEFAULT                 _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0C_RCOAL_AUTODISABLE_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0C_RCOAL_AUTODISABLE_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0C_RCOAL_AUTODISABLE_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0C_RCOAL_AUTODISABLE_EN_INIT_ENUM                       ENABLE
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0C_RCOAL_AUTODISABLE_EN_DISABLE                 _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0C_RCOAL_AUTODISABLE_EN_ENABLE                  _MK_ENUM_CONST(1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0C_RCOAL_AUTODISABLE_EN_DISABLED                        _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0C_RCOAL_AUTODISABLE_EN_ENABLED                 _MK_ENUM_CONST(1)

#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0CB_RCOAL_AUTODISABLE_EN_SHIFT                  _MK_SHIFT_CONST(5)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0CB_RCOAL_AUTODISABLE_EN_FIELD                  (_MK_MASK_CONST(0x1) << MC_RCOAL_AUTODISABLE_0_0_DISPLAY0CB_RCOAL_AUTODISABLE_EN_SHIFT)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0CB_RCOAL_AUTODISABLE_EN_RANGE                  5:5
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0CB_RCOAL_AUTODISABLE_EN_WOFFSET                        0x0
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0CB_RCOAL_AUTODISABLE_EN_DEFAULT                        _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0CB_RCOAL_AUTODISABLE_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0CB_RCOAL_AUTODISABLE_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0CB_RCOAL_AUTODISABLE_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0CB_RCOAL_AUTODISABLE_EN_INIT_ENUM                      ENABLE
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0CB_RCOAL_AUTODISABLE_EN_DISABLE                        _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0CB_RCOAL_AUTODISABLE_EN_ENABLE                 _MK_ENUM_CONST(1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0CB_RCOAL_AUTODISABLE_EN_DISABLED                       _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY0CB_RCOAL_AUTODISABLE_EN_ENABLED                        _MK_ENUM_CONST(1)

#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1B_RCOAL_AUTODISABLE_EN_SHIFT                   _MK_SHIFT_CONST(6)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1B_RCOAL_AUTODISABLE_EN_FIELD                   (_MK_MASK_CONST(0x1) << MC_RCOAL_AUTODISABLE_0_0_DISPLAY1B_RCOAL_AUTODISABLE_EN_SHIFT)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1B_RCOAL_AUTODISABLE_EN_RANGE                   6:6
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1B_RCOAL_AUTODISABLE_EN_WOFFSET                 0x0
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1B_RCOAL_AUTODISABLE_EN_DEFAULT                 _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1B_RCOAL_AUTODISABLE_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1B_RCOAL_AUTODISABLE_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1B_RCOAL_AUTODISABLE_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1B_RCOAL_AUTODISABLE_EN_INIT_ENUM                       ENABLE
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1B_RCOAL_AUTODISABLE_EN_DISABLE                 _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1B_RCOAL_AUTODISABLE_EN_ENABLE                  _MK_ENUM_CONST(1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1B_RCOAL_AUTODISABLE_EN_DISABLED                        _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1B_RCOAL_AUTODISABLE_EN_ENABLED                 _MK_ENUM_CONST(1)

#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1BB_RCOAL_AUTODISABLE_EN_SHIFT                  _MK_SHIFT_CONST(7)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1BB_RCOAL_AUTODISABLE_EN_FIELD                  (_MK_MASK_CONST(0x1) << MC_RCOAL_AUTODISABLE_0_0_DISPLAY1BB_RCOAL_AUTODISABLE_EN_SHIFT)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1BB_RCOAL_AUTODISABLE_EN_RANGE                  7:7
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1BB_RCOAL_AUTODISABLE_EN_WOFFSET                        0x0
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1BB_RCOAL_AUTODISABLE_EN_DEFAULT                        _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1BB_RCOAL_AUTODISABLE_EN_DEFAULT_MASK                   _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1BB_RCOAL_AUTODISABLE_EN_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1BB_RCOAL_AUTODISABLE_EN_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1BB_RCOAL_AUTODISABLE_EN_INIT_ENUM                      ENABLE
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1BB_RCOAL_AUTODISABLE_EN_DISABLE                        _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1BB_RCOAL_AUTODISABLE_EN_ENABLE                 _MK_ENUM_CONST(1)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1BB_RCOAL_AUTODISABLE_EN_DISABLED                       _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_DISPLAY1BB_RCOAL_AUTODISABLE_EN_ENABLED                        _MK_ENUM_CONST(1)

#define MC_RCOAL_AUTODISABLE_0_0_EPPUP_RCOAL_AUTODISABLE_EN_SHIFT                       _MK_SHIFT_CONST(8)
#define MC_RCOAL_AUTODISABLE_0_0_EPPUP_RCOAL_AUTODISABLE_EN_FIELD                       (_MK_MASK_CONST(0x1) << MC_RCOAL_AUTODISABLE_0_0_EPPUP_RCOAL_AUTODISABLE_EN_SHIFT)
#define MC_RCOAL_AUTODISABLE_0_0_EPPUP_RCOAL_AUTODISABLE_EN_RANGE                       8:8
#define MC_RCOAL_AUTODISABLE_0_0_EPPUP_RCOAL_AUTODISABLE_EN_WOFFSET                     0x0
#define MC_RCOAL_AUTODISABLE_0_0_EPPUP_RCOAL_AUTODISABLE_EN_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_EPPUP_RCOAL_AUTODISABLE_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_EPPUP_RCOAL_AUTODISABLE_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_EPPUP_RCOAL_AUTODISABLE_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_EPPUP_RCOAL_AUTODISABLE_EN_INIT_ENUM                   ENABLE
#define MC_RCOAL_AUTODISABLE_0_0_EPPUP_RCOAL_AUTODISABLE_EN_DISABLE                     _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_EPPUP_RCOAL_AUTODISABLE_EN_ENABLE                      _MK_ENUM_CONST(1)
#define MC_RCOAL_AUTODISABLE_0_0_EPPUP_RCOAL_AUTODISABLE_EN_DISABLED                    _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_EPPUP_RCOAL_AUTODISABLE_EN_ENABLED                     _MK_ENUM_CONST(1)

#define MC_RCOAL_AUTODISABLE_0_0_G2PR_RCOAL_AUTODISABLE_EN_SHIFT                        _MK_SHIFT_CONST(9)
#define MC_RCOAL_AUTODISABLE_0_0_G2PR_RCOAL_AUTODISABLE_EN_FIELD                        (_MK_MASK_CONST(0x1) << MC_RCOAL_AUTODISABLE_0_0_G2PR_RCOAL_AUTODISABLE_EN_SHIFT)
#define MC_RCOAL_AUTODISABLE_0_0_G2PR_RCOAL_AUTODISABLE_EN_RANGE                        9:9
#define MC_RCOAL_AUTODISABLE_0_0_G2PR_RCOAL_AUTODISABLE_EN_WOFFSET                      0x0
#define MC_RCOAL_AUTODISABLE_0_0_G2PR_RCOAL_AUTODISABLE_EN_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_G2PR_RCOAL_AUTODISABLE_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_G2PR_RCOAL_AUTODISABLE_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_G2PR_RCOAL_AUTODISABLE_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_G2PR_RCOAL_AUTODISABLE_EN_INIT_ENUM                    ENABLE
#define MC_RCOAL_AUTODISABLE_0_0_G2PR_RCOAL_AUTODISABLE_EN_DISABLE                      _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_G2PR_RCOAL_AUTODISABLE_EN_ENABLE                       _MK_ENUM_CONST(1)
#define MC_RCOAL_AUTODISABLE_0_0_G2PR_RCOAL_AUTODISABLE_EN_DISABLED                     _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_G2PR_RCOAL_AUTODISABLE_EN_ENABLED                      _MK_ENUM_CONST(1)

#define MC_RCOAL_AUTODISABLE_0_0_G2SR_RCOAL_AUTODISABLE_EN_SHIFT                        _MK_SHIFT_CONST(10)
#define MC_RCOAL_AUTODISABLE_0_0_G2SR_RCOAL_AUTODISABLE_EN_FIELD                        (_MK_MASK_CONST(0x1) << MC_RCOAL_AUTODISABLE_0_0_G2SR_RCOAL_AUTODISABLE_EN_SHIFT)
#define MC_RCOAL_AUTODISABLE_0_0_G2SR_RCOAL_AUTODISABLE_EN_RANGE                        10:10
#define MC_RCOAL_AUTODISABLE_0_0_G2SR_RCOAL_AUTODISABLE_EN_WOFFSET                      0x0
#define MC_RCOAL_AUTODISABLE_0_0_G2SR_RCOAL_AUTODISABLE_EN_DEFAULT                      _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_G2SR_RCOAL_AUTODISABLE_EN_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_G2SR_RCOAL_AUTODISABLE_EN_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_G2SR_RCOAL_AUTODISABLE_EN_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_G2SR_RCOAL_AUTODISABLE_EN_INIT_ENUM                    ENABLE
#define MC_RCOAL_AUTODISABLE_0_0_G2SR_RCOAL_AUTODISABLE_EN_DISABLE                      _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_G2SR_RCOAL_AUTODISABLE_EN_ENABLE                       _MK_ENUM_CONST(1)
#define MC_RCOAL_AUTODISABLE_0_0_G2SR_RCOAL_AUTODISABLE_EN_DISABLED                     _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_G2SR_RCOAL_AUTODISABLE_EN_ENABLED                      _MK_ENUM_CONST(1)

#define MC_RCOAL_AUTODISABLE_0_0_MPEUNIFBR_RCOAL_AUTODISABLE_EN_SHIFT                   _MK_SHIFT_CONST(11)
#define MC_RCOAL_AUTODISABLE_0_0_MPEUNIFBR_RCOAL_AUTODISABLE_EN_FIELD                   (_MK_MASK_CONST(0x1) << MC_RCOAL_AUTODISABLE_0_0_MPEUNIFBR_RCOAL_AUTODISABLE_EN_SHIFT)
#define MC_RCOAL_AUTODISABLE_0_0_MPEUNIFBR_RCOAL_AUTODISABLE_EN_RANGE                   11:11
#define MC_RCOAL_AUTODISABLE_0_0_MPEUNIFBR_RCOAL_AUTODISABLE_EN_WOFFSET                 0x0
#define MC_RCOAL_AUTODISABLE_0_0_MPEUNIFBR_RCOAL_AUTODISABLE_EN_DEFAULT                 _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_MPEUNIFBR_RCOAL_AUTODISABLE_EN_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_MPEUNIFBR_RCOAL_AUTODISABLE_EN_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_MPEUNIFBR_RCOAL_AUTODISABLE_EN_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_MPEUNIFBR_RCOAL_AUTODISABLE_EN_INIT_ENUM                       ENABLE
#define MC_RCOAL_AUTODISABLE_0_0_MPEUNIFBR_RCOAL_AUTODISABLE_EN_DISABLE                 _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_MPEUNIFBR_RCOAL_AUTODISABLE_EN_ENABLE                  _MK_ENUM_CONST(1)
#define MC_RCOAL_AUTODISABLE_0_0_MPEUNIFBR_RCOAL_AUTODISABLE_EN_DISABLED                        _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_MPEUNIFBR_RCOAL_AUTODISABLE_EN_ENABLED                 _MK_ENUM_CONST(1)

#define MC_RCOAL_AUTODISABLE_0_0_VIRUV_RCOAL_AUTODISABLE_EN_SHIFT                       _MK_SHIFT_CONST(12)
#define MC_RCOAL_AUTODISABLE_0_0_VIRUV_RCOAL_AUTODISABLE_EN_FIELD                       (_MK_MASK_CONST(0x1) << MC_RCOAL_AUTODISABLE_0_0_VIRUV_RCOAL_AUTODISABLE_EN_SHIFT)
#define MC_RCOAL_AUTODISABLE_0_0_VIRUV_RCOAL_AUTODISABLE_EN_RANGE                       12:12
#define MC_RCOAL_AUTODISABLE_0_0_VIRUV_RCOAL_AUTODISABLE_EN_WOFFSET                     0x0
#define MC_RCOAL_AUTODISABLE_0_0_VIRUV_RCOAL_AUTODISABLE_EN_DEFAULT                     _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_VIRUV_RCOAL_AUTODISABLE_EN_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_RCOAL_AUTODISABLE_0_0_VIRUV_RCOAL_AUTODISABLE_EN_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_VIRUV_RCOAL_AUTODISABLE_EN_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_RCOAL_AUTODISABLE_0_0_VIRUV_RCOAL_AUTODISABLE_EN_INIT_ENUM                   ENABLE
#define MC_RCOAL_AUTODISABLE_0_0_VIRUV_RCOAL_AUTODISABLE_EN_DISABLE                     _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_VIRUV_RCOAL_AUTODISABLE_EN_ENABLE                      _MK_ENUM_CONST(1)
#define MC_RCOAL_AUTODISABLE_0_0_VIRUV_RCOAL_AUTODISABLE_EN_DISABLED                    _MK_ENUM_CONST(0)
#define MC_RCOAL_AUTODISABLE_0_0_VIRUV_RCOAL_AUTODISABLE_EN_ENABLED                     _MK_ENUM_CONST(1)

#define MC_BWSHARE_INCVAL_SIZE  11
#define MC_BWSHARE_HIGHTH_SIZE  8
#define MC_BWSHARE_MAXTH_SIZE   8
#define MC_BWSHARE_ALWAYSINC_DISABLE    0
#define MC_BWSHARE_ALWAYSINC_ENABLE     1
#define MC_BWSHARE_TMSFACTORSEL_1       0
#define MC_BWSHARE_TMSFACTORSEL_2       1

// Register MC_BWSHARE_AVPC_0  
#define MC_BWSHARE_AVPC_0                       _MK_ADDR_CONST(0x238)
#define MC_BWSHARE_AVPC_0_SECURE                        0x0
#define MC_BWSHARE_AVPC_0_WORD_COUNT                    0x1
#define MC_BWSHARE_AVPC_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_AVPC_0_RESET_MASK                    _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_AVPC_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_AVPC_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_AVPC_0_READ_MASK                     _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_AVPC_0_WRITE_MASK                    _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_AVPC_0_AVPC_BW_INCVAL_SHIFT                  _MK_SHIFT_CONST(0)
#define MC_BWSHARE_AVPC_0_AVPC_BW_INCVAL_FIELD                  (_MK_MASK_CONST(0x7ff) << MC_BWSHARE_AVPC_0_AVPC_BW_INCVAL_SHIFT)
#define MC_BWSHARE_AVPC_0_AVPC_BW_INCVAL_RANGE                  10:0
#define MC_BWSHARE_AVPC_0_AVPC_BW_INCVAL_WOFFSET                        0x0
#define MC_BWSHARE_AVPC_0_AVPC_BW_INCVAL_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_AVPC_0_AVPC_BW_INCVAL_DEFAULT_MASK                   _MK_MASK_CONST(0x7ff)
#define MC_BWSHARE_AVPC_0_AVPC_BW_INCVAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_AVPC_0_AVPC_BW_INCVAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define MC_BWSHARE_AVPC_0_AVPC_BW_HIGHTH_SHIFT                  _MK_SHIFT_CONST(11)
#define MC_BWSHARE_AVPC_0_AVPC_BW_HIGHTH_FIELD                  (_MK_MASK_CONST(0xff) << MC_BWSHARE_AVPC_0_AVPC_BW_HIGHTH_SHIFT)
#define MC_BWSHARE_AVPC_0_AVPC_BW_HIGHTH_RANGE                  18:11
#define MC_BWSHARE_AVPC_0_AVPC_BW_HIGHTH_WOFFSET                        0x0
#define MC_BWSHARE_AVPC_0_AVPC_BW_HIGHTH_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_AVPC_0_AVPC_BW_HIGHTH_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define MC_BWSHARE_AVPC_0_AVPC_BW_HIGHTH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_AVPC_0_AVPC_BW_HIGHTH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define MC_BWSHARE_AVPC_0_AVPC_BW_MAXTH_SHIFT                   _MK_SHIFT_CONST(19)
#define MC_BWSHARE_AVPC_0_AVPC_BW_MAXTH_FIELD                   (_MK_MASK_CONST(0xff) << MC_BWSHARE_AVPC_0_AVPC_BW_MAXTH_SHIFT)
#define MC_BWSHARE_AVPC_0_AVPC_BW_MAXTH_RANGE                   26:19
#define MC_BWSHARE_AVPC_0_AVPC_BW_MAXTH_WOFFSET                 0x0
#define MC_BWSHARE_AVPC_0_AVPC_BW_MAXTH_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_AVPC_0_AVPC_BW_MAXTH_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define MC_BWSHARE_AVPC_0_AVPC_BW_MAXTH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_AVPC_0_AVPC_BW_MAXTH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define MC_BWSHARE_AVPC_0_AVPC_BW_ALWAYSINC_SHIFT                       _MK_SHIFT_CONST(27)
#define MC_BWSHARE_AVPC_0_AVPC_BW_ALWAYSINC_FIELD                       (_MK_MASK_CONST(0x1) << MC_BWSHARE_AVPC_0_AVPC_BW_ALWAYSINC_SHIFT)
#define MC_BWSHARE_AVPC_0_AVPC_BW_ALWAYSINC_RANGE                       27:27
#define MC_BWSHARE_AVPC_0_AVPC_BW_ALWAYSINC_WOFFSET                     0x0
#define MC_BWSHARE_AVPC_0_AVPC_BW_ALWAYSINC_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_AVPC_0_AVPC_BW_ALWAYSINC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_BWSHARE_AVPC_0_AVPC_BW_ALWAYSINC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_AVPC_0_AVPC_BW_ALWAYSINC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_AVPC_0_AVPC_BW_ALWAYSINC_INIT_ENUM                   DISABLE
#define MC_BWSHARE_AVPC_0_AVPC_BW_ALWAYSINC_DISABLE                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_AVPC_0_AVPC_BW_ALWAYSINC_ENABLE                      _MK_ENUM_CONST(1)
#define MC_BWSHARE_AVPC_0_AVPC_BW_ALWAYSINC_DISABLED                    _MK_ENUM_CONST(0)
#define MC_BWSHARE_AVPC_0_AVPC_BW_ALWAYSINC_ENABLED                     _MK_ENUM_CONST(1)

#define MC_BWSHARE_AVPC_0_AVPC_BW_TMSFACTORSEL_SHIFT                    _MK_SHIFT_CONST(28)
#define MC_BWSHARE_AVPC_0_AVPC_BW_TMSFACTORSEL_FIELD                    (_MK_MASK_CONST(0x1) << MC_BWSHARE_AVPC_0_AVPC_BW_TMSFACTORSEL_SHIFT)
#define MC_BWSHARE_AVPC_0_AVPC_BW_TMSFACTORSEL_RANGE                    28:28
#define MC_BWSHARE_AVPC_0_AVPC_BW_TMSFACTORSEL_WOFFSET                  0x0
#define MC_BWSHARE_AVPC_0_AVPC_BW_TMSFACTORSEL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_AVPC_0_AVPC_BW_TMSFACTORSEL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_BWSHARE_AVPC_0_AVPC_BW_TMSFACTORSEL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_AVPC_0_AVPC_BW_TMSFACTORSEL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_AVPC_0_AVPC_BW_TMSFACTORSEL_INIT_ENUM                        TM_SFACTOR1
#define MC_BWSHARE_AVPC_0_AVPC_BW_TMSFACTORSEL_TM_SFACTOR1                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_AVPC_0_AVPC_BW_TMSFACTORSEL_TM_SFACTOR2                      _MK_ENUM_CONST(1)


// Register MC_BWSHARE_DC_0  
#define MC_BWSHARE_DC_0                 _MK_ADDR_CONST(0x23c)
#define MC_BWSHARE_DC_0_SECURE                  0x0
#define MC_BWSHARE_DC_0_WORD_COUNT                      0x1
#define MC_BWSHARE_DC_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DC_0_RESET_MASK                      _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_DC_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DC_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DC_0_READ_MASK                       _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_DC_0_WRITE_MASK                      _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_DC_0_DC_BW_INCVAL_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_BWSHARE_DC_0_DC_BW_INCVAL_FIELD                      (_MK_MASK_CONST(0x7ff) << MC_BWSHARE_DC_0_DC_BW_INCVAL_SHIFT)
#define MC_BWSHARE_DC_0_DC_BW_INCVAL_RANGE                      10:0
#define MC_BWSHARE_DC_0_DC_BW_INCVAL_WOFFSET                    0x0
#define MC_BWSHARE_DC_0_DC_BW_INCVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DC_0_DC_BW_INCVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x7ff)
#define MC_BWSHARE_DC_0_DC_BW_INCVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DC_0_DC_BW_INCVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_BWSHARE_DC_0_DC_BW_HIGHTH_SHIFT                      _MK_SHIFT_CONST(11)
#define MC_BWSHARE_DC_0_DC_BW_HIGHTH_FIELD                      (_MK_MASK_CONST(0xff) << MC_BWSHARE_DC_0_DC_BW_HIGHTH_SHIFT)
#define MC_BWSHARE_DC_0_DC_BW_HIGHTH_RANGE                      18:11
#define MC_BWSHARE_DC_0_DC_BW_HIGHTH_WOFFSET                    0x0
#define MC_BWSHARE_DC_0_DC_BW_HIGHTH_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DC_0_DC_BW_HIGHTH_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define MC_BWSHARE_DC_0_DC_BW_HIGHTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DC_0_DC_BW_HIGHTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_BWSHARE_DC_0_DC_BW_MAXTH_SHIFT                       _MK_SHIFT_CONST(19)
#define MC_BWSHARE_DC_0_DC_BW_MAXTH_FIELD                       (_MK_MASK_CONST(0xff) << MC_BWSHARE_DC_0_DC_BW_MAXTH_SHIFT)
#define MC_BWSHARE_DC_0_DC_BW_MAXTH_RANGE                       26:19
#define MC_BWSHARE_DC_0_DC_BW_MAXTH_WOFFSET                     0x0
#define MC_BWSHARE_DC_0_DC_BW_MAXTH_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DC_0_DC_BW_MAXTH_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define MC_BWSHARE_DC_0_DC_BW_MAXTH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DC_0_DC_BW_MAXTH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_BWSHARE_DC_0_DC_BW_ALWAYSINC_SHIFT                   _MK_SHIFT_CONST(27)
#define MC_BWSHARE_DC_0_DC_BW_ALWAYSINC_FIELD                   (_MK_MASK_CONST(0x1) << MC_BWSHARE_DC_0_DC_BW_ALWAYSINC_SHIFT)
#define MC_BWSHARE_DC_0_DC_BW_ALWAYSINC_RANGE                   27:27
#define MC_BWSHARE_DC_0_DC_BW_ALWAYSINC_WOFFSET                 0x0
#define MC_BWSHARE_DC_0_DC_BW_ALWAYSINC_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DC_0_DC_BW_ALWAYSINC_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_BWSHARE_DC_0_DC_BW_ALWAYSINC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DC_0_DC_BW_ALWAYSINC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DC_0_DC_BW_ALWAYSINC_INIT_ENUM                       DISABLE
#define MC_BWSHARE_DC_0_DC_BW_ALWAYSINC_DISABLE                 _MK_ENUM_CONST(0)
#define MC_BWSHARE_DC_0_DC_BW_ALWAYSINC_ENABLE                  _MK_ENUM_CONST(1)
#define MC_BWSHARE_DC_0_DC_BW_ALWAYSINC_DISABLED                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_DC_0_DC_BW_ALWAYSINC_ENABLED                 _MK_ENUM_CONST(1)

#define MC_BWSHARE_DC_0_DC_BW_TMSFACTORSEL_SHIFT                        _MK_SHIFT_CONST(28)
#define MC_BWSHARE_DC_0_DC_BW_TMSFACTORSEL_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_DC_0_DC_BW_TMSFACTORSEL_SHIFT)
#define MC_BWSHARE_DC_0_DC_BW_TMSFACTORSEL_RANGE                        28:28
#define MC_BWSHARE_DC_0_DC_BW_TMSFACTORSEL_WOFFSET                      0x0
#define MC_BWSHARE_DC_0_DC_BW_TMSFACTORSEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DC_0_DC_BW_TMSFACTORSEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_DC_0_DC_BW_TMSFACTORSEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DC_0_DC_BW_TMSFACTORSEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DC_0_DC_BW_TMSFACTORSEL_INIT_ENUM                    TM_SFACTOR1
#define MC_BWSHARE_DC_0_DC_BW_TMSFACTORSEL_TM_SFACTOR1                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_DC_0_DC_BW_TMSFACTORSEL_TM_SFACTOR2                  _MK_ENUM_CONST(1)


// Register MC_BWSHARE_DCB_0  
#define MC_BWSHARE_DCB_0                        _MK_ADDR_CONST(0x240)
#define MC_BWSHARE_DCB_0_SECURE                         0x0
#define MC_BWSHARE_DCB_0_WORD_COUNT                     0x1
#define MC_BWSHARE_DCB_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DCB_0_RESET_MASK                     _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_DCB_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DCB_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DCB_0_READ_MASK                      _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_DCB_0_WRITE_MASK                     _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_DCB_0_DCB_BW_INCVAL_SHIFT                    _MK_SHIFT_CONST(0)
#define MC_BWSHARE_DCB_0_DCB_BW_INCVAL_FIELD                    (_MK_MASK_CONST(0x7ff) << MC_BWSHARE_DCB_0_DCB_BW_INCVAL_SHIFT)
#define MC_BWSHARE_DCB_0_DCB_BW_INCVAL_RANGE                    10:0
#define MC_BWSHARE_DCB_0_DCB_BW_INCVAL_WOFFSET                  0x0
#define MC_BWSHARE_DCB_0_DCB_BW_INCVAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DCB_0_DCB_BW_INCVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x7ff)
#define MC_BWSHARE_DCB_0_DCB_BW_INCVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DCB_0_DCB_BW_INCVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define MC_BWSHARE_DCB_0_DCB_BW_HIGHTH_SHIFT                    _MK_SHIFT_CONST(11)
#define MC_BWSHARE_DCB_0_DCB_BW_HIGHTH_FIELD                    (_MK_MASK_CONST(0xff) << MC_BWSHARE_DCB_0_DCB_BW_HIGHTH_SHIFT)
#define MC_BWSHARE_DCB_0_DCB_BW_HIGHTH_RANGE                    18:11
#define MC_BWSHARE_DCB_0_DCB_BW_HIGHTH_WOFFSET                  0x0
#define MC_BWSHARE_DCB_0_DCB_BW_HIGHTH_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DCB_0_DCB_BW_HIGHTH_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define MC_BWSHARE_DCB_0_DCB_BW_HIGHTH_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DCB_0_DCB_BW_HIGHTH_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define MC_BWSHARE_DCB_0_DCB_BW_MAXTH_SHIFT                     _MK_SHIFT_CONST(19)
#define MC_BWSHARE_DCB_0_DCB_BW_MAXTH_FIELD                     (_MK_MASK_CONST(0xff) << MC_BWSHARE_DCB_0_DCB_BW_MAXTH_SHIFT)
#define MC_BWSHARE_DCB_0_DCB_BW_MAXTH_RANGE                     26:19
#define MC_BWSHARE_DCB_0_DCB_BW_MAXTH_WOFFSET                   0x0
#define MC_BWSHARE_DCB_0_DCB_BW_MAXTH_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DCB_0_DCB_BW_MAXTH_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_BWSHARE_DCB_0_DCB_BW_MAXTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DCB_0_DCB_BW_MAXTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define MC_BWSHARE_DCB_0_DCB_BW_ALWAYSINC_SHIFT                 _MK_SHIFT_CONST(27)
#define MC_BWSHARE_DCB_0_DCB_BW_ALWAYSINC_FIELD                 (_MK_MASK_CONST(0x1) << MC_BWSHARE_DCB_0_DCB_BW_ALWAYSINC_SHIFT)
#define MC_BWSHARE_DCB_0_DCB_BW_ALWAYSINC_RANGE                 27:27
#define MC_BWSHARE_DCB_0_DCB_BW_ALWAYSINC_WOFFSET                       0x0
#define MC_BWSHARE_DCB_0_DCB_BW_ALWAYSINC_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DCB_0_DCB_BW_ALWAYSINC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_BWSHARE_DCB_0_DCB_BW_ALWAYSINC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DCB_0_DCB_BW_ALWAYSINC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DCB_0_DCB_BW_ALWAYSINC_INIT_ENUM                     DISABLE
#define MC_BWSHARE_DCB_0_DCB_BW_ALWAYSINC_DISABLE                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_DCB_0_DCB_BW_ALWAYSINC_ENABLE                        _MK_ENUM_CONST(1)
#define MC_BWSHARE_DCB_0_DCB_BW_ALWAYSINC_DISABLED                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_DCB_0_DCB_BW_ALWAYSINC_ENABLED                       _MK_ENUM_CONST(1)

#define MC_BWSHARE_DCB_0_DCB_BW_TMSFACTORSEL_SHIFT                      _MK_SHIFT_CONST(28)
#define MC_BWSHARE_DCB_0_DCB_BW_TMSFACTORSEL_FIELD                      (_MK_MASK_CONST(0x1) << MC_BWSHARE_DCB_0_DCB_BW_TMSFACTORSEL_SHIFT)
#define MC_BWSHARE_DCB_0_DCB_BW_TMSFACTORSEL_RANGE                      28:28
#define MC_BWSHARE_DCB_0_DCB_BW_TMSFACTORSEL_WOFFSET                    0x0
#define MC_BWSHARE_DCB_0_DCB_BW_TMSFACTORSEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DCB_0_DCB_BW_TMSFACTORSEL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_BWSHARE_DCB_0_DCB_BW_TMSFACTORSEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DCB_0_DCB_BW_TMSFACTORSEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_DCB_0_DCB_BW_TMSFACTORSEL_INIT_ENUM                  TM_SFACTOR1
#define MC_BWSHARE_DCB_0_DCB_BW_TMSFACTORSEL_TM_SFACTOR1                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_DCB_0_DCB_BW_TMSFACTORSEL_TM_SFACTOR2                        _MK_ENUM_CONST(1)


// Register MC_BWSHARE_EPP_0  
#define MC_BWSHARE_EPP_0                        _MK_ADDR_CONST(0x244)
#define MC_BWSHARE_EPP_0_SECURE                         0x0
#define MC_BWSHARE_EPP_0_WORD_COUNT                     0x1
#define MC_BWSHARE_EPP_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EPP_0_RESET_MASK                     _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_EPP_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EPP_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EPP_0_READ_MASK                      _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_EPP_0_WRITE_MASK                     _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_EPP_0_EPP_BW_INCVAL_SHIFT                    _MK_SHIFT_CONST(0)
#define MC_BWSHARE_EPP_0_EPP_BW_INCVAL_FIELD                    (_MK_MASK_CONST(0x7ff) << MC_BWSHARE_EPP_0_EPP_BW_INCVAL_SHIFT)
#define MC_BWSHARE_EPP_0_EPP_BW_INCVAL_RANGE                    10:0
#define MC_BWSHARE_EPP_0_EPP_BW_INCVAL_WOFFSET                  0x0
#define MC_BWSHARE_EPP_0_EPP_BW_INCVAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EPP_0_EPP_BW_INCVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x7ff)
#define MC_BWSHARE_EPP_0_EPP_BW_INCVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EPP_0_EPP_BW_INCVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define MC_BWSHARE_EPP_0_EPP_BW_HIGHTH_SHIFT                    _MK_SHIFT_CONST(11)
#define MC_BWSHARE_EPP_0_EPP_BW_HIGHTH_FIELD                    (_MK_MASK_CONST(0xff) << MC_BWSHARE_EPP_0_EPP_BW_HIGHTH_SHIFT)
#define MC_BWSHARE_EPP_0_EPP_BW_HIGHTH_RANGE                    18:11
#define MC_BWSHARE_EPP_0_EPP_BW_HIGHTH_WOFFSET                  0x0
#define MC_BWSHARE_EPP_0_EPP_BW_HIGHTH_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EPP_0_EPP_BW_HIGHTH_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define MC_BWSHARE_EPP_0_EPP_BW_HIGHTH_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EPP_0_EPP_BW_HIGHTH_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define MC_BWSHARE_EPP_0_EPP_BW_MAXTH_SHIFT                     _MK_SHIFT_CONST(19)
#define MC_BWSHARE_EPP_0_EPP_BW_MAXTH_FIELD                     (_MK_MASK_CONST(0xff) << MC_BWSHARE_EPP_0_EPP_BW_MAXTH_SHIFT)
#define MC_BWSHARE_EPP_0_EPP_BW_MAXTH_RANGE                     26:19
#define MC_BWSHARE_EPP_0_EPP_BW_MAXTH_WOFFSET                   0x0
#define MC_BWSHARE_EPP_0_EPP_BW_MAXTH_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EPP_0_EPP_BW_MAXTH_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_BWSHARE_EPP_0_EPP_BW_MAXTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EPP_0_EPP_BW_MAXTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define MC_BWSHARE_EPP_0_EPP_BW_ALWAYSINC_SHIFT                 _MK_SHIFT_CONST(27)
#define MC_BWSHARE_EPP_0_EPP_BW_ALWAYSINC_FIELD                 (_MK_MASK_CONST(0x1) << MC_BWSHARE_EPP_0_EPP_BW_ALWAYSINC_SHIFT)
#define MC_BWSHARE_EPP_0_EPP_BW_ALWAYSINC_RANGE                 27:27
#define MC_BWSHARE_EPP_0_EPP_BW_ALWAYSINC_WOFFSET                       0x0
#define MC_BWSHARE_EPP_0_EPP_BW_ALWAYSINC_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EPP_0_EPP_BW_ALWAYSINC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EPP_0_EPP_BW_ALWAYSINC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EPP_0_EPP_BW_ALWAYSINC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EPP_0_EPP_BW_ALWAYSINC_INIT_ENUM                     DISABLE
#define MC_BWSHARE_EPP_0_EPP_BW_ALWAYSINC_DISABLE                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_EPP_0_EPP_BW_ALWAYSINC_ENABLE                        _MK_ENUM_CONST(1)
#define MC_BWSHARE_EPP_0_EPP_BW_ALWAYSINC_DISABLED                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_EPP_0_EPP_BW_ALWAYSINC_ENABLED                       _MK_ENUM_CONST(1)

#define MC_BWSHARE_EPP_0_EPP_BW_TMSFACTORSEL_SHIFT                      _MK_SHIFT_CONST(28)
#define MC_BWSHARE_EPP_0_EPP_BW_TMSFACTORSEL_FIELD                      (_MK_MASK_CONST(0x1) << MC_BWSHARE_EPP_0_EPP_BW_TMSFACTORSEL_SHIFT)
#define MC_BWSHARE_EPP_0_EPP_BW_TMSFACTORSEL_RANGE                      28:28
#define MC_BWSHARE_EPP_0_EPP_BW_TMSFACTORSEL_WOFFSET                    0x0
#define MC_BWSHARE_EPP_0_EPP_BW_TMSFACTORSEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EPP_0_EPP_BW_TMSFACTORSEL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_BWSHARE_EPP_0_EPP_BW_TMSFACTORSEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EPP_0_EPP_BW_TMSFACTORSEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_EPP_0_EPP_BW_TMSFACTORSEL_INIT_ENUM                  TM_SFACTOR1
#define MC_BWSHARE_EPP_0_EPP_BW_TMSFACTORSEL_TM_SFACTOR1                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_EPP_0_EPP_BW_TMSFACTORSEL_TM_SFACTOR2                        _MK_ENUM_CONST(1)


// Register MC_BWSHARE_G2_0  
#define MC_BWSHARE_G2_0                 _MK_ADDR_CONST(0x248)
#define MC_BWSHARE_G2_0_SECURE                  0x0
#define MC_BWSHARE_G2_0_WORD_COUNT                      0x1
#define MC_BWSHARE_G2_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_G2_0_RESET_MASK                      _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_G2_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_G2_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_BWSHARE_G2_0_READ_MASK                       _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_G2_0_WRITE_MASK                      _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_G2_0_G2_BW_INCVAL_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_BWSHARE_G2_0_G2_BW_INCVAL_FIELD                      (_MK_MASK_CONST(0x7ff) << MC_BWSHARE_G2_0_G2_BW_INCVAL_SHIFT)
#define MC_BWSHARE_G2_0_G2_BW_INCVAL_RANGE                      10:0
#define MC_BWSHARE_G2_0_G2_BW_INCVAL_WOFFSET                    0x0
#define MC_BWSHARE_G2_0_G2_BW_INCVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_G2_0_G2_BW_INCVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x7ff)
#define MC_BWSHARE_G2_0_G2_BW_INCVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_G2_0_G2_BW_INCVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_BWSHARE_G2_0_G2_BW_HIGHTH_SHIFT                      _MK_SHIFT_CONST(11)
#define MC_BWSHARE_G2_0_G2_BW_HIGHTH_FIELD                      (_MK_MASK_CONST(0xff) << MC_BWSHARE_G2_0_G2_BW_HIGHTH_SHIFT)
#define MC_BWSHARE_G2_0_G2_BW_HIGHTH_RANGE                      18:11
#define MC_BWSHARE_G2_0_G2_BW_HIGHTH_WOFFSET                    0x0
#define MC_BWSHARE_G2_0_G2_BW_HIGHTH_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_G2_0_G2_BW_HIGHTH_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define MC_BWSHARE_G2_0_G2_BW_HIGHTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_G2_0_G2_BW_HIGHTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_BWSHARE_G2_0_G2_BW_MAXTH_SHIFT                       _MK_SHIFT_CONST(19)
#define MC_BWSHARE_G2_0_G2_BW_MAXTH_FIELD                       (_MK_MASK_CONST(0xff) << MC_BWSHARE_G2_0_G2_BW_MAXTH_SHIFT)
#define MC_BWSHARE_G2_0_G2_BW_MAXTH_RANGE                       26:19
#define MC_BWSHARE_G2_0_G2_BW_MAXTH_WOFFSET                     0x0
#define MC_BWSHARE_G2_0_G2_BW_MAXTH_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_G2_0_G2_BW_MAXTH_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define MC_BWSHARE_G2_0_G2_BW_MAXTH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_G2_0_G2_BW_MAXTH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_BWSHARE_G2_0_G2_BW_ALWAYSINC_SHIFT                   _MK_SHIFT_CONST(27)
#define MC_BWSHARE_G2_0_G2_BW_ALWAYSINC_FIELD                   (_MK_MASK_CONST(0x1) << MC_BWSHARE_G2_0_G2_BW_ALWAYSINC_SHIFT)
#define MC_BWSHARE_G2_0_G2_BW_ALWAYSINC_RANGE                   27:27
#define MC_BWSHARE_G2_0_G2_BW_ALWAYSINC_WOFFSET                 0x0
#define MC_BWSHARE_G2_0_G2_BW_ALWAYSINC_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_G2_0_G2_BW_ALWAYSINC_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_BWSHARE_G2_0_G2_BW_ALWAYSINC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_G2_0_G2_BW_ALWAYSINC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_G2_0_G2_BW_ALWAYSINC_INIT_ENUM                       DISABLE
#define MC_BWSHARE_G2_0_G2_BW_ALWAYSINC_DISABLE                 _MK_ENUM_CONST(0)
#define MC_BWSHARE_G2_0_G2_BW_ALWAYSINC_ENABLE                  _MK_ENUM_CONST(1)
#define MC_BWSHARE_G2_0_G2_BW_ALWAYSINC_DISABLED                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_G2_0_G2_BW_ALWAYSINC_ENABLED                 _MK_ENUM_CONST(1)

#define MC_BWSHARE_G2_0_G2_BW_TMSFACTORSEL_SHIFT                        _MK_SHIFT_CONST(28)
#define MC_BWSHARE_G2_0_G2_BW_TMSFACTORSEL_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_G2_0_G2_BW_TMSFACTORSEL_SHIFT)
#define MC_BWSHARE_G2_0_G2_BW_TMSFACTORSEL_RANGE                        28:28
#define MC_BWSHARE_G2_0_G2_BW_TMSFACTORSEL_WOFFSET                      0x0
#define MC_BWSHARE_G2_0_G2_BW_TMSFACTORSEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_G2_0_G2_BW_TMSFACTORSEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_G2_0_G2_BW_TMSFACTORSEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_G2_0_G2_BW_TMSFACTORSEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_G2_0_G2_BW_TMSFACTORSEL_INIT_ENUM                    TM_SFACTOR1
#define MC_BWSHARE_G2_0_G2_BW_TMSFACTORSEL_TM_SFACTOR1                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_G2_0_G2_BW_TMSFACTORSEL_TM_SFACTOR2                  _MK_ENUM_CONST(1)


// Register MC_BWSHARE_HC_0  
#define MC_BWSHARE_HC_0                 _MK_ADDR_CONST(0x24c)
#define MC_BWSHARE_HC_0_SECURE                  0x0
#define MC_BWSHARE_HC_0_WORD_COUNT                      0x1
#define MC_BWSHARE_HC_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_HC_0_RESET_MASK                      _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_HC_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_HC_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_BWSHARE_HC_0_READ_MASK                       _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_HC_0_WRITE_MASK                      _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_HC_0_HC_BW_INCVAL_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_BWSHARE_HC_0_HC_BW_INCVAL_FIELD                      (_MK_MASK_CONST(0x7ff) << MC_BWSHARE_HC_0_HC_BW_INCVAL_SHIFT)
#define MC_BWSHARE_HC_0_HC_BW_INCVAL_RANGE                      10:0
#define MC_BWSHARE_HC_0_HC_BW_INCVAL_WOFFSET                    0x0
#define MC_BWSHARE_HC_0_HC_BW_INCVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_HC_0_HC_BW_INCVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x7ff)
#define MC_BWSHARE_HC_0_HC_BW_INCVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_HC_0_HC_BW_INCVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_BWSHARE_HC_0_HC_BW_HIGHTH_SHIFT                      _MK_SHIFT_CONST(11)
#define MC_BWSHARE_HC_0_HC_BW_HIGHTH_FIELD                      (_MK_MASK_CONST(0xff) << MC_BWSHARE_HC_0_HC_BW_HIGHTH_SHIFT)
#define MC_BWSHARE_HC_0_HC_BW_HIGHTH_RANGE                      18:11
#define MC_BWSHARE_HC_0_HC_BW_HIGHTH_WOFFSET                    0x0
#define MC_BWSHARE_HC_0_HC_BW_HIGHTH_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_HC_0_HC_BW_HIGHTH_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define MC_BWSHARE_HC_0_HC_BW_HIGHTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_HC_0_HC_BW_HIGHTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_BWSHARE_HC_0_HC_BW_MAXTH_SHIFT                       _MK_SHIFT_CONST(19)
#define MC_BWSHARE_HC_0_HC_BW_MAXTH_FIELD                       (_MK_MASK_CONST(0xff) << MC_BWSHARE_HC_0_HC_BW_MAXTH_SHIFT)
#define MC_BWSHARE_HC_0_HC_BW_MAXTH_RANGE                       26:19
#define MC_BWSHARE_HC_0_HC_BW_MAXTH_WOFFSET                     0x0
#define MC_BWSHARE_HC_0_HC_BW_MAXTH_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_HC_0_HC_BW_MAXTH_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define MC_BWSHARE_HC_0_HC_BW_MAXTH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_HC_0_HC_BW_MAXTH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_BWSHARE_HC_0_HC_BW_ALWAYSINC_SHIFT                   _MK_SHIFT_CONST(27)
#define MC_BWSHARE_HC_0_HC_BW_ALWAYSINC_FIELD                   (_MK_MASK_CONST(0x1) << MC_BWSHARE_HC_0_HC_BW_ALWAYSINC_SHIFT)
#define MC_BWSHARE_HC_0_HC_BW_ALWAYSINC_RANGE                   27:27
#define MC_BWSHARE_HC_0_HC_BW_ALWAYSINC_WOFFSET                 0x0
#define MC_BWSHARE_HC_0_HC_BW_ALWAYSINC_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_HC_0_HC_BW_ALWAYSINC_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_BWSHARE_HC_0_HC_BW_ALWAYSINC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_HC_0_HC_BW_ALWAYSINC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_HC_0_HC_BW_ALWAYSINC_INIT_ENUM                       DISABLE
#define MC_BWSHARE_HC_0_HC_BW_ALWAYSINC_DISABLE                 _MK_ENUM_CONST(0)
#define MC_BWSHARE_HC_0_HC_BW_ALWAYSINC_ENABLE                  _MK_ENUM_CONST(1)
#define MC_BWSHARE_HC_0_HC_BW_ALWAYSINC_DISABLED                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_HC_0_HC_BW_ALWAYSINC_ENABLED                 _MK_ENUM_CONST(1)

#define MC_BWSHARE_HC_0_HC_BW_TMSFACTORSEL_SHIFT                        _MK_SHIFT_CONST(28)
#define MC_BWSHARE_HC_0_HC_BW_TMSFACTORSEL_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_HC_0_HC_BW_TMSFACTORSEL_SHIFT)
#define MC_BWSHARE_HC_0_HC_BW_TMSFACTORSEL_RANGE                        28:28
#define MC_BWSHARE_HC_0_HC_BW_TMSFACTORSEL_WOFFSET                      0x0
#define MC_BWSHARE_HC_0_HC_BW_TMSFACTORSEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_HC_0_HC_BW_TMSFACTORSEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_HC_0_HC_BW_TMSFACTORSEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_HC_0_HC_BW_TMSFACTORSEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_HC_0_HC_BW_TMSFACTORSEL_INIT_ENUM                    TM_SFACTOR1
#define MC_BWSHARE_HC_0_HC_BW_TMSFACTORSEL_TM_SFACTOR1                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_HC_0_HC_BW_TMSFACTORSEL_TM_SFACTOR2                  _MK_ENUM_CONST(1)


// Register MC_BWSHARE_ISP_0  
#define MC_BWSHARE_ISP_0                        _MK_ADDR_CONST(0x250)
#define MC_BWSHARE_ISP_0_SECURE                         0x0
#define MC_BWSHARE_ISP_0_WORD_COUNT                     0x1
#define MC_BWSHARE_ISP_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_ISP_0_RESET_MASK                     _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_ISP_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define MC_BWSHARE_ISP_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_ISP_0_READ_MASK                      _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_ISP_0_WRITE_MASK                     _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_ISP_0_ISP_BW_INCVAL_SHIFT                    _MK_SHIFT_CONST(0)
#define MC_BWSHARE_ISP_0_ISP_BW_INCVAL_FIELD                    (_MK_MASK_CONST(0x7ff) << MC_BWSHARE_ISP_0_ISP_BW_INCVAL_SHIFT)
#define MC_BWSHARE_ISP_0_ISP_BW_INCVAL_RANGE                    10:0
#define MC_BWSHARE_ISP_0_ISP_BW_INCVAL_WOFFSET                  0x0
#define MC_BWSHARE_ISP_0_ISP_BW_INCVAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_ISP_0_ISP_BW_INCVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x7ff)
#define MC_BWSHARE_ISP_0_ISP_BW_INCVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_ISP_0_ISP_BW_INCVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define MC_BWSHARE_ISP_0_ISP_BW_HIGHTH_SHIFT                    _MK_SHIFT_CONST(11)
#define MC_BWSHARE_ISP_0_ISP_BW_HIGHTH_FIELD                    (_MK_MASK_CONST(0xff) << MC_BWSHARE_ISP_0_ISP_BW_HIGHTH_SHIFT)
#define MC_BWSHARE_ISP_0_ISP_BW_HIGHTH_RANGE                    18:11
#define MC_BWSHARE_ISP_0_ISP_BW_HIGHTH_WOFFSET                  0x0
#define MC_BWSHARE_ISP_0_ISP_BW_HIGHTH_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_ISP_0_ISP_BW_HIGHTH_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define MC_BWSHARE_ISP_0_ISP_BW_HIGHTH_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_ISP_0_ISP_BW_HIGHTH_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define MC_BWSHARE_ISP_0_ISP_BW_MAXTH_SHIFT                     _MK_SHIFT_CONST(19)
#define MC_BWSHARE_ISP_0_ISP_BW_MAXTH_FIELD                     (_MK_MASK_CONST(0xff) << MC_BWSHARE_ISP_0_ISP_BW_MAXTH_SHIFT)
#define MC_BWSHARE_ISP_0_ISP_BW_MAXTH_RANGE                     26:19
#define MC_BWSHARE_ISP_0_ISP_BW_MAXTH_WOFFSET                   0x0
#define MC_BWSHARE_ISP_0_ISP_BW_MAXTH_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_ISP_0_ISP_BW_MAXTH_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_BWSHARE_ISP_0_ISP_BW_MAXTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_ISP_0_ISP_BW_MAXTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define MC_BWSHARE_ISP_0_ISP_BW_ALWAYSINC_SHIFT                 _MK_SHIFT_CONST(27)
#define MC_BWSHARE_ISP_0_ISP_BW_ALWAYSINC_FIELD                 (_MK_MASK_CONST(0x1) << MC_BWSHARE_ISP_0_ISP_BW_ALWAYSINC_SHIFT)
#define MC_BWSHARE_ISP_0_ISP_BW_ALWAYSINC_RANGE                 27:27
#define MC_BWSHARE_ISP_0_ISP_BW_ALWAYSINC_WOFFSET                       0x0
#define MC_BWSHARE_ISP_0_ISP_BW_ALWAYSINC_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_ISP_0_ISP_BW_ALWAYSINC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_BWSHARE_ISP_0_ISP_BW_ALWAYSINC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_ISP_0_ISP_BW_ALWAYSINC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_ISP_0_ISP_BW_ALWAYSINC_INIT_ENUM                     DISABLE
#define MC_BWSHARE_ISP_0_ISP_BW_ALWAYSINC_DISABLE                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_ISP_0_ISP_BW_ALWAYSINC_ENABLE                        _MK_ENUM_CONST(1)
#define MC_BWSHARE_ISP_0_ISP_BW_ALWAYSINC_DISABLED                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_ISP_0_ISP_BW_ALWAYSINC_ENABLED                       _MK_ENUM_CONST(1)

#define MC_BWSHARE_ISP_0_ISP_BW_TMSFACTORSEL_SHIFT                      _MK_SHIFT_CONST(28)
#define MC_BWSHARE_ISP_0_ISP_BW_TMSFACTORSEL_FIELD                      (_MK_MASK_CONST(0x1) << MC_BWSHARE_ISP_0_ISP_BW_TMSFACTORSEL_SHIFT)
#define MC_BWSHARE_ISP_0_ISP_BW_TMSFACTORSEL_RANGE                      28:28
#define MC_BWSHARE_ISP_0_ISP_BW_TMSFACTORSEL_WOFFSET                    0x0
#define MC_BWSHARE_ISP_0_ISP_BW_TMSFACTORSEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_ISP_0_ISP_BW_TMSFACTORSEL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_BWSHARE_ISP_0_ISP_BW_TMSFACTORSEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_ISP_0_ISP_BW_TMSFACTORSEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_ISP_0_ISP_BW_TMSFACTORSEL_INIT_ENUM                  TM_SFACTOR1
#define MC_BWSHARE_ISP_0_ISP_BW_TMSFACTORSEL_TM_SFACTOR1                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_ISP_0_ISP_BW_TMSFACTORSEL_TM_SFACTOR2                        _MK_ENUM_CONST(1)


// Register MC_BWSHARE_MPCORE_0  
#define MC_BWSHARE_MPCORE_0                     _MK_ADDR_CONST(0x254)
#define MC_BWSHARE_MPCORE_0_SECURE                      0x0
#define MC_BWSHARE_MPCORE_0_WORD_COUNT                  0x1
#define MC_BWSHARE_MPCORE_0_RESET_VAL                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPCORE_0_RESET_MASK                  _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_MPCORE_0_SW_DEFAULT_VAL                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPCORE_0_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPCORE_0_READ_MASK                   _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_MPCORE_0_WRITE_MASK                  _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_INCVAL_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_INCVAL_FIELD                      (_MK_MASK_CONST(0x7ff) << MC_BWSHARE_MPCORE_0_MPCORE_BW_INCVAL_SHIFT)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_INCVAL_RANGE                      10:0
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_INCVAL_WOFFSET                    0x0
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_INCVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_INCVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x7ff)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_INCVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_INCVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_BWSHARE_MPCORE_0_MPCORE_BW_HIGHTH_SHIFT                      _MK_SHIFT_CONST(11)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_HIGHTH_FIELD                      (_MK_MASK_CONST(0xff) << MC_BWSHARE_MPCORE_0_MPCORE_BW_HIGHTH_SHIFT)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_HIGHTH_RANGE                      18:11
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_HIGHTH_WOFFSET                    0x0
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_HIGHTH_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_HIGHTH_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_HIGHTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_HIGHTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_BWSHARE_MPCORE_0_MPCORE_BW_MAXTH_SHIFT                       _MK_SHIFT_CONST(19)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_MAXTH_FIELD                       (_MK_MASK_CONST(0xff) << MC_BWSHARE_MPCORE_0_MPCORE_BW_MAXTH_SHIFT)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_MAXTH_RANGE                       26:19
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_MAXTH_WOFFSET                     0x0
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_MAXTH_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_MAXTH_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_MAXTH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_MAXTH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_BWSHARE_MPCORE_0_MPCORE_BW_ALWAYSINC_SHIFT                   _MK_SHIFT_CONST(27)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_ALWAYSINC_FIELD                   (_MK_MASK_CONST(0x1) << MC_BWSHARE_MPCORE_0_MPCORE_BW_ALWAYSINC_SHIFT)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_ALWAYSINC_RANGE                   27:27
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_ALWAYSINC_WOFFSET                 0x0
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_ALWAYSINC_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_ALWAYSINC_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_ALWAYSINC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_ALWAYSINC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_ALWAYSINC_INIT_ENUM                       DISABLE
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_ALWAYSINC_DISABLE                 _MK_ENUM_CONST(0)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_ALWAYSINC_ENABLE                  _MK_ENUM_CONST(1)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_ALWAYSINC_DISABLED                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_ALWAYSINC_ENABLED                 _MK_ENUM_CONST(1)

#define MC_BWSHARE_MPCORE_0_MPCORE_BW_TMSFACTORSEL_SHIFT                        _MK_SHIFT_CONST(28)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_TMSFACTORSEL_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_MPCORE_0_MPCORE_BW_TMSFACTORSEL_SHIFT)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_TMSFACTORSEL_RANGE                        28:28
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_TMSFACTORSEL_WOFFSET                      0x0
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_TMSFACTORSEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_TMSFACTORSEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_TMSFACTORSEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_TMSFACTORSEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_TMSFACTORSEL_INIT_ENUM                    TM_SFACTOR1
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_TMSFACTORSEL_TM_SFACTOR1                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_MPCORE_0_MPCORE_BW_TMSFACTORSEL_TM_SFACTOR2                  _MK_ENUM_CONST(1)


// Register MC_BWSHARE_MPEA_0  
#define MC_BWSHARE_MPEA_0                       _MK_ADDR_CONST(0x258)
#define MC_BWSHARE_MPEA_0_SECURE                        0x0
#define MC_BWSHARE_MPEA_0_WORD_COUNT                    0x1
#define MC_BWSHARE_MPEA_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEA_0_RESET_MASK                    _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_MPEA_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEA_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEA_0_READ_MASK                     _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_MPEA_0_WRITE_MASK                    _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_MPEA_0_MPEA_BW_INCVAL_SHIFT                  _MK_SHIFT_CONST(0)
#define MC_BWSHARE_MPEA_0_MPEA_BW_INCVAL_FIELD                  (_MK_MASK_CONST(0x7ff) << MC_BWSHARE_MPEA_0_MPEA_BW_INCVAL_SHIFT)
#define MC_BWSHARE_MPEA_0_MPEA_BW_INCVAL_RANGE                  10:0
#define MC_BWSHARE_MPEA_0_MPEA_BW_INCVAL_WOFFSET                        0x0
#define MC_BWSHARE_MPEA_0_MPEA_BW_INCVAL_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEA_0_MPEA_BW_INCVAL_DEFAULT_MASK                   _MK_MASK_CONST(0x7ff)
#define MC_BWSHARE_MPEA_0_MPEA_BW_INCVAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEA_0_MPEA_BW_INCVAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define MC_BWSHARE_MPEA_0_MPEA_BW_HIGHTH_SHIFT                  _MK_SHIFT_CONST(11)
#define MC_BWSHARE_MPEA_0_MPEA_BW_HIGHTH_FIELD                  (_MK_MASK_CONST(0xff) << MC_BWSHARE_MPEA_0_MPEA_BW_HIGHTH_SHIFT)
#define MC_BWSHARE_MPEA_0_MPEA_BW_HIGHTH_RANGE                  18:11
#define MC_BWSHARE_MPEA_0_MPEA_BW_HIGHTH_WOFFSET                        0x0
#define MC_BWSHARE_MPEA_0_MPEA_BW_HIGHTH_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEA_0_MPEA_BW_HIGHTH_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define MC_BWSHARE_MPEA_0_MPEA_BW_HIGHTH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEA_0_MPEA_BW_HIGHTH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define MC_BWSHARE_MPEA_0_MPEA_BW_MAXTH_SHIFT                   _MK_SHIFT_CONST(19)
#define MC_BWSHARE_MPEA_0_MPEA_BW_MAXTH_FIELD                   (_MK_MASK_CONST(0xff) << MC_BWSHARE_MPEA_0_MPEA_BW_MAXTH_SHIFT)
#define MC_BWSHARE_MPEA_0_MPEA_BW_MAXTH_RANGE                   26:19
#define MC_BWSHARE_MPEA_0_MPEA_BW_MAXTH_WOFFSET                 0x0
#define MC_BWSHARE_MPEA_0_MPEA_BW_MAXTH_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEA_0_MPEA_BW_MAXTH_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define MC_BWSHARE_MPEA_0_MPEA_BW_MAXTH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEA_0_MPEA_BW_MAXTH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define MC_BWSHARE_MPEA_0_MPEA_BW_ALWAYSINC_SHIFT                       _MK_SHIFT_CONST(27)
#define MC_BWSHARE_MPEA_0_MPEA_BW_ALWAYSINC_FIELD                       (_MK_MASK_CONST(0x1) << MC_BWSHARE_MPEA_0_MPEA_BW_ALWAYSINC_SHIFT)
#define MC_BWSHARE_MPEA_0_MPEA_BW_ALWAYSINC_RANGE                       27:27
#define MC_BWSHARE_MPEA_0_MPEA_BW_ALWAYSINC_WOFFSET                     0x0
#define MC_BWSHARE_MPEA_0_MPEA_BW_ALWAYSINC_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEA_0_MPEA_BW_ALWAYSINC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_BWSHARE_MPEA_0_MPEA_BW_ALWAYSINC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEA_0_MPEA_BW_ALWAYSINC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEA_0_MPEA_BW_ALWAYSINC_INIT_ENUM                   DISABLE
#define MC_BWSHARE_MPEA_0_MPEA_BW_ALWAYSINC_DISABLE                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_MPEA_0_MPEA_BW_ALWAYSINC_ENABLE                      _MK_ENUM_CONST(1)
#define MC_BWSHARE_MPEA_0_MPEA_BW_ALWAYSINC_DISABLED                    _MK_ENUM_CONST(0)
#define MC_BWSHARE_MPEA_0_MPEA_BW_ALWAYSINC_ENABLED                     _MK_ENUM_CONST(1)

#define MC_BWSHARE_MPEA_0_MPEA_BW_TMSFACTORSEL_SHIFT                    _MK_SHIFT_CONST(28)
#define MC_BWSHARE_MPEA_0_MPEA_BW_TMSFACTORSEL_FIELD                    (_MK_MASK_CONST(0x1) << MC_BWSHARE_MPEA_0_MPEA_BW_TMSFACTORSEL_SHIFT)
#define MC_BWSHARE_MPEA_0_MPEA_BW_TMSFACTORSEL_RANGE                    28:28
#define MC_BWSHARE_MPEA_0_MPEA_BW_TMSFACTORSEL_WOFFSET                  0x0
#define MC_BWSHARE_MPEA_0_MPEA_BW_TMSFACTORSEL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEA_0_MPEA_BW_TMSFACTORSEL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_BWSHARE_MPEA_0_MPEA_BW_TMSFACTORSEL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEA_0_MPEA_BW_TMSFACTORSEL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEA_0_MPEA_BW_TMSFACTORSEL_INIT_ENUM                        TM_SFACTOR1
#define MC_BWSHARE_MPEA_0_MPEA_BW_TMSFACTORSEL_TM_SFACTOR1                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_MPEA_0_MPEA_BW_TMSFACTORSEL_TM_SFACTOR2                      _MK_ENUM_CONST(1)


// Register MC_BWSHARE_MPEB_0  
#define MC_BWSHARE_MPEB_0                       _MK_ADDR_CONST(0x25c)
#define MC_BWSHARE_MPEB_0_SECURE                        0x0
#define MC_BWSHARE_MPEB_0_WORD_COUNT                    0x1
#define MC_BWSHARE_MPEB_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEB_0_RESET_MASK                    _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_MPEB_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEB_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEB_0_READ_MASK                     _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_MPEB_0_WRITE_MASK                    _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_MPEB_0_MPEB_BW_INCVAL_SHIFT                  _MK_SHIFT_CONST(0)
#define MC_BWSHARE_MPEB_0_MPEB_BW_INCVAL_FIELD                  (_MK_MASK_CONST(0x7ff) << MC_BWSHARE_MPEB_0_MPEB_BW_INCVAL_SHIFT)
#define MC_BWSHARE_MPEB_0_MPEB_BW_INCVAL_RANGE                  10:0
#define MC_BWSHARE_MPEB_0_MPEB_BW_INCVAL_WOFFSET                        0x0
#define MC_BWSHARE_MPEB_0_MPEB_BW_INCVAL_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEB_0_MPEB_BW_INCVAL_DEFAULT_MASK                   _MK_MASK_CONST(0x7ff)
#define MC_BWSHARE_MPEB_0_MPEB_BW_INCVAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEB_0_MPEB_BW_INCVAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define MC_BWSHARE_MPEB_0_MPEB_BW_HIGHTH_SHIFT                  _MK_SHIFT_CONST(11)
#define MC_BWSHARE_MPEB_0_MPEB_BW_HIGHTH_FIELD                  (_MK_MASK_CONST(0xff) << MC_BWSHARE_MPEB_0_MPEB_BW_HIGHTH_SHIFT)
#define MC_BWSHARE_MPEB_0_MPEB_BW_HIGHTH_RANGE                  18:11
#define MC_BWSHARE_MPEB_0_MPEB_BW_HIGHTH_WOFFSET                        0x0
#define MC_BWSHARE_MPEB_0_MPEB_BW_HIGHTH_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEB_0_MPEB_BW_HIGHTH_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define MC_BWSHARE_MPEB_0_MPEB_BW_HIGHTH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEB_0_MPEB_BW_HIGHTH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define MC_BWSHARE_MPEB_0_MPEB_BW_MAXTH_SHIFT                   _MK_SHIFT_CONST(19)
#define MC_BWSHARE_MPEB_0_MPEB_BW_MAXTH_FIELD                   (_MK_MASK_CONST(0xff) << MC_BWSHARE_MPEB_0_MPEB_BW_MAXTH_SHIFT)
#define MC_BWSHARE_MPEB_0_MPEB_BW_MAXTH_RANGE                   26:19
#define MC_BWSHARE_MPEB_0_MPEB_BW_MAXTH_WOFFSET                 0x0
#define MC_BWSHARE_MPEB_0_MPEB_BW_MAXTH_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEB_0_MPEB_BW_MAXTH_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define MC_BWSHARE_MPEB_0_MPEB_BW_MAXTH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEB_0_MPEB_BW_MAXTH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define MC_BWSHARE_MPEB_0_MPEB_BW_ALWAYSINC_SHIFT                       _MK_SHIFT_CONST(27)
#define MC_BWSHARE_MPEB_0_MPEB_BW_ALWAYSINC_FIELD                       (_MK_MASK_CONST(0x1) << MC_BWSHARE_MPEB_0_MPEB_BW_ALWAYSINC_SHIFT)
#define MC_BWSHARE_MPEB_0_MPEB_BW_ALWAYSINC_RANGE                       27:27
#define MC_BWSHARE_MPEB_0_MPEB_BW_ALWAYSINC_WOFFSET                     0x0
#define MC_BWSHARE_MPEB_0_MPEB_BW_ALWAYSINC_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEB_0_MPEB_BW_ALWAYSINC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_BWSHARE_MPEB_0_MPEB_BW_ALWAYSINC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEB_0_MPEB_BW_ALWAYSINC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEB_0_MPEB_BW_ALWAYSINC_INIT_ENUM                   DISABLE
#define MC_BWSHARE_MPEB_0_MPEB_BW_ALWAYSINC_DISABLE                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_MPEB_0_MPEB_BW_ALWAYSINC_ENABLE                      _MK_ENUM_CONST(1)
#define MC_BWSHARE_MPEB_0_MPEB_BW_ALWAYSINC_DISABLED                    _MK_ENUM_CONST(0)
#define MC_BWSHARE_MPEB_0_MPEB_BW_ALWAYSINC_ENABLED                     _MK_ENUM_CONST(1)

#define MC_BWSHARE_MPEB_0_MPEB_BW_TMSFACTORSEL_SHIFT                    _MK_SHIFT_CONST(28)
#define MC_BWSHARE_MPEB_0_MPEB_BW_TMSFACTORSEL_FIELD                    (_MK_MASK_CONST(0x1) << MC_BWSHARE_MPEB_0_MPEB_BW_TMSFACTORSEL_SHIFT)
#define MC_BWSHARE_MPEB_0_MPEB_BW_TMSFACTORSEL_RANGE                    28:28
#define MC_BWSHARE_MPEB_0_MPEB_BW_TMSFACTORSEL_WOFFSET                  0x0
#define MC_BWSHARE_MPEB_0_MPEB_BW_TMSFACTORSEL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEB_0_MPEB_BW_TMSFACTORSEL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_BWSHARE_MPEB_0_MPEB_BW_TMSFACTORSEL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEB_0_MPEB_BW_TMSFACTORSEL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEB_0_MPEB_BW_TMSFACTORSEL_INIT_ENUM                        TM_SFACTOR1
#define MC_BWSHARE_MPEB_0_MPEB_BW_TMSFACTORSEL_TM_SFACTOR1                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_MPEB_0_MPEB_BW_TMSFACTORSEL_TM_SFACTOR2                      _MK_ENUM_CONST(1)


// Register MC_BWSHARE_MPEC_0  
#define MC_BWSHARE_MPEC_0                       _MK_ADDR_CONST(0x260)
#define MC_BWSHARE_MPEC_0_SECURE                        0x0
#define MC_BWSHARE_MPEC_0_WORD_COUNT                    0x1
#define MC_BWSHARE_MPEC_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEC_0_RESET_MASK                    _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_MPEC_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEC_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEC_0_READ_MASK                     _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_MPEC_0_WRITE_MASK                    _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_MPEC_0_MPEC_BW_INCVAL_SHIFT                  _MK_SHIFT_CONST(0)
#define MC_BWSHARE_MPEC_0_MPEC_BW_INCVAL_FIELD                  (_MK_MASK_CONST(0x7ff) << MC_BWSHARE_MPEC_0_MPEC_BW_INCVAL_SHIFT)
#define MC_BWSHARE_MPEC_0_MPEC_BW_INCVAL_RANGE                  10:0
#define MC_BWSHARE_MPEC_0_MPEC_BW_INCVAL_WOFFSET                        0x0
#define MC_BWSHARE_MPEC_0_MPEC_BW_INCVAL_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEC_0_MPEC_BW_INCVAL_DEFAULT_MASK                   _MK_MASK_CONST(0x7ff)
#define MC_BWSHARE_MPEC_0_MPEC_BW_INCVAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEC_0_MPEC_BW_INCVAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define MC_BWSHARE_MPEC_0_MPEC_BW_HIGHTH_SHIFT                  _MK_SHIFT_CONST(11)
#define MC_BWSHARE_MPEC_0_MPEC_BW_HIGHTH_FIELD                  (_MK_MASK_CONST(0xff) << MC_BWSHARE_MPEC_0_MPEC_BW_HIGHTH_SHIFT)
#define MC_BWSHARE_MPEC_0_MPEC_BW_HIGHTH_RANGE                  18:11
#define MC_BWSHARE_MPEC_0_MPEC_BW_HIGHTH_WOFFSET                        0x0
#define MC_BWSHARE_MPEC_0_MPEC_BW_HIGHTH_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEC_0_MPEC_BW_HIGHTH_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define MC_BWSHARE_MPEC_0_MPEC_BW_HIGHTH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEC_0_MPEC_BW_HIGHTH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define MC_BWSHARE_MPEC_0_MPEC_BW_MAXTH_SHIFT                   _MK_SHIFT_CONST(19)
#define MC_BWSHARE_MPEC_0_MPEC_BW_MAXTH_FIELD                   (_MK_MASK_CONST(0xff) << MC_BWSHARE_MPEC_0_MPEC_BW_MAXTH_SHIFT)
#define MC_BWSHARE_MPEC_0_MPEC_BW_MAXTH_RANGE                   26:19
#define MC_BWSHARE_MPEC_0_MPEC_BW_MAXTH_WOFFSET                 0x0
#define MC_BWSHARE_MPEC_0_MPEC_BW_MAXTH_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEC_0_MPEC_BW_MAXTH_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define MC_BWSHARE_MPEC_0_MPEC_BW_MAXTH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEC_0_MPEC_BW_MAXTH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define MC_BWSHARE_MPEC_0_MPEC_BW_ALWAYSINC_SHIFT                       _MK_SHIFT_CONST(27)
#define MC_BWSHARE_MPEC_0_MPEC_BW_ALWAYSINC_FIELD                       (_MK_MASK_CONST(0x1) << MC_BWSHARE_MPEC_0_MPEC_BW_ALWAYSINC_SHIFT)
#define MC_BWSHARE_MPEC_0_MPEC_BW_ALWAYSINC_RANGE                       27:27
#define MC_BWSHARE_MPEC_0_MPEC_BW_ALWAYSINC_WOFFSET                     0x0
#define MC_BWSHARE_MPEC_0_MPEC_BW_ALWAYSINC_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEC_0_MPEC_BW_ALWAYSINC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_BWSHARE_MPEC_0_MPEC_BW_ALWAYSINC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEC_0_MPEC_BW_ALWAYSINC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEC_0_MPEC_BW_ALWAYSINC_INIT_ENUM                   DISABLE
#define MC_BWSHARE_MPEC_0_MPEC_BW_ALWAYSINC_DISABLE                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_MPEC_0_MPEC_BW_ALWAYSINC_ENABLE                      _MK_ENUM_CONST(1)
#define MC_BWSHARE_MPEC_0_MPEC_BW_ALWAYSINC_DISABLED                    _MK_ENUM_CONST(0)
#define MC_BWSHARE_MPEC_0_MPEC_BW_ALWAYSINC_ENABLED                     _MK_ENUM_CONST(1)

#define MC_BWSHARE_MPEC_0_MPEC_BW_TMSFACTORSEL_SHIFT                    _MK_SHIFT_CONST(28)
#define MC_BWSHARE_MPEC_0_MPEC_BW_TMSFACTORSEL_FIELD                    (_MK_MASK_CONST(0x1) << MC_BWSHARE_MPEC_0_MPEC_BW_TMSFACTORSEL_SHIFT)
#define MC_BWSHARE_MPEC_0_MPEC_BW_TMSFACTORSEL_RANGE                    28:28
#define MC_BWSHARE_MPEC_0_MPEC_BW_TMSFACTORSEL_WOFFSET                  0x0
#define MC_BWSHARE_MPEC_0_MPEC_BW_TMSFACTORSEL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEC_0_MPEC_BW_TMSFACTORSEL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_BWSHARE_MPEC_0_MPEC_BW_TMSFACTORSEL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEC_0_MPEC_BW_TMSFACTORSEL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_MPEC_0_MPEC_BW_TMSFACTORSEL_INIT_ENUM                        TM_SFACTOR1
#define MC_BWSHARE_MPEC_0_MPEC_BW_TMSFACTORSEL_TM_SFACTOR1                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_MPEC_0_MPEC_BW_TMSFACTORSEL_TM_SFACTOR2                      _MK_ENUM_CONST(1)


// Register MC_BWSHARE_NV_0  
#define MC_BWSHARE_NV_0                 _MK_ADDR_CONST(0x264)
#define MC_BWSHARE_NV_0_SECURE                  0x0
#define MC_BWSHARE_NV_0_WORD_COUNT                      0x1
#define MC_BWSHARE_NV_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_NV_0_RESET_MASK                      _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_NV_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_NV_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_BWSHARE_NV_0_READ_MASK                       _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_NV_0_WRITE_MASK                      _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_NV_0_NV_BW_INCVAL_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_BWSHARE_NV_0_NV_BW_INCVAL_FIELD                      (_MK_MASK_CONST(0x7ff) << MC_BWSHARE_NV_0_NV_BW_INCVAL_SHIFT)
#define MC_BWSHARE_NV_0_NV_BW_INCVAL_RANGE                      10:0
#define MC_BWSHARE_NV_0_NV_BW_INCVAL_WOFFSET                    0x0
#define MC_BWSHARE_NV_0_NV_BW_INCVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_NV_0_NV_BW_INCVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x7ff)
#define MC_BWSHARE_NV_0_NV_BW_INCVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_NV_0_NV_BW_INCVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_BWSHARE_NV_0_NV_BW_HIGHTH_SHIFT                      _MK_SHIFT_CONST(11)
#define MC_BWSHARE_NV_0_NV_BW_HIGHTH_FIELD                      (_MK_MASK_CONST(0xff) << MC_BWSHARE_NV_0_NV_BW_HIGHTH_SHIFT)
#define MC_BWSHARE_NV_0_NV_BW_HIGHTH_RANGE                      18:11
#define MC_BWSHARE_NV_0_NV_BW_HIGHTH_WOFFSET                    0x0
#define MC_BWSHARE_NV_0_NV_BW_HIGHTH_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_NV_0_NV_BW_HIGHTH_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define MC_BWSHARE_NV_0_NV_BW_HIGHTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_NV_0_NV_BW_HIGHTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_BWSHARE_NV_0_NV_BW_MAXTH_SHIFT                       _MK_SHIFT_CONST(19)
#define MC_BWSHARE_NV_0_NV_BW_MAXTH_FIELD                       (_MK_MASK_CONST(0xff) << MC_BWSHARE_NV_0_NV_BW_MAXTH_SHIFT)
#define MC_BWSHARE_NV_0_NV_BW_MAXTH_RANGE                       26:19
#define MC_BWSHARE_NV_0_NV_BW_MAXTH_WOFFSET                     0x0
#define MC_BWSHARE_NV_0_NV_BW_MAXTH_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_NV_0_NV_BW_MAXTH_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define MC_BWSHARE_NV_0_NV_BW_MAXTH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_NV_0_NV_BW_MAXTH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_BWSHARE_NV_0_NV_BW_ALWAYSINC_SHIFT                   _MK_SHIFT_CONST(27)
#define MC_BWSHARE_NV_0_NV_BW_ALWAYSINC_FIELD                   (_MK_MASK_CONST(0x1) << MC_BWSHARE_NV_0_NV_BW_ALWAYSINC_SHIFT)
#define MC_BWSHARE_NV_0_NV_BW_ALWAYSINC_RANGE                   27:27
#define MC_BWSHARE_NV_0_NV_BW_ALWAYSINC_WOFFSET                 0x0
#define MC_BWSHARE_NV_0_NV_BW_ALWAYSINC_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_NV_0_NV_BW_ALWAYSINC_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_BWSHARE_NV_0_NV_BW_ALWAYSINC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_NV_0_NV_BW_ALWAYSINC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_NV_0_NV_BW_ALWAYSINC_INIT_ENUM                       DISABLE
#define MC_BWSHARE_NV_0_NV_BW_ALWAYSINC_DISABLE                 _MK_ENUM_CONST(0)
#define MC_BWSHARE_NV_0_NV_BW_ALWAYSINC_ENABLE                  _MK_ENUM_CONST(1)
#define MC_BWSHARE_NV_0_NV_BW_ALWAYSINC_DISABLED                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_NV_0_NV_BW_ALWAYSINC_ENABLED                 _MK_ENUM_CONST(1)

#define MC_BWSHARE_NV_0_NV_BW_TMSFACTORSEL_SHIFT                        _MK_SHIFT_CONST(28)
#define MC_BWSHARE_NV_0_NV_BW_TMSFACTORSEL_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_NV_0_NV_BW_TMSFACTORSEL_SHIFT)
#define MC_BWSHARE_NV_0_NV_BW_TMSFACTORSEL_RANGE                        28:28
#define MC_BWSHARE_NV_0_NV_BW_TMSFACTORSEL_WOFFSET                      0x0
#define MC_BWSHARE_NV_0_NV_BW_TMSFACTORSEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_NV_0_NV_BW_TMSFACTORSEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_NV_0_NV_BW_TMSFACTORSEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_NV_0_NV_BW_TMSFACTORSEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_NV_0_NV_BW_TMSFACTORSEL_INIT_ENUM                    TM_SFACTOR1
#define MC_BWSHARE_NV_0_NV_BW_TMSFACTORSEL_TM_SFACTOR1                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_NV_0_NV_BW_TMSFACTORSEL_TM_SFACTOR2                  _MK_ENUM_CONST(1)


// Register MC_BWSHARE_PPCS_0  
#define MC_BWSHARE_PPCS_0                       _MK_ADDR_CONST(0x268)
#define MC_BWSHARE_PPCS_0_SECURE                        0x0
#define MC_BWSHARE_PPCS_0_WORD_COUNT                    0x1
#define MC_BWSHARE_PPCS_0_RESET_VAL                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_PPCS_0_RESET_MASK                    _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_PPCS_0_SW_DEFAULT_VAL                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_PPCS_0_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_PPCS_0_READ_MASK                     _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_PPCS_0_WRITE_MASK                    _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_PPCS_0_PPCS_BW_INCVAL_SHIFT                  _MK_SHIFT_CONST(0)
#define MC_BWSHARE_PPCS_0_PPCS_BW_INCVAL_FIELD                  (_MK_MASK_CONST(0x7ff) << MC_BWSHARE_PPCS_0_PPCS_BW_INCVAL_SHIFT)
#define MC_BWSHARE_PPCS_0_PPCS_BW_INCVAL_RANGE                  10:0
#define MC_BWSHARE_PPCS_0_PPCS_BW_INCVAL_WOFFSET                        0x0
#define MC_BWSHARE_PPCS_0_PPCS_BW_INCVAL_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_PPCS_0_PPCS_BW_INCVAL_DEFAULT_MASK                   _MK_MASK_CONST(0x7ff)
#define MC_BWSHARE_PPCS_0_PPCS_BW_INCVAL_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_PPCS_0_PPCS_BW_INCVAL_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define MC_BWSHARE_PPCS_0_PPCS_BW_HIGHTH_SHIFT                  _MK_SHIFT_CONST(11)
#define MC_BWSHARE_PPCS_0_PPCS_BW_HIGHTH_FIELD                  (_MK_MASK_CONST(0xff) << MC_BWSHARE_PPCS_0_PPCS_BW_HIGHTH_SHIFT)
#define MC_BWSHARE_PPCS_0_PPCS_BW_HIGHTH_RANGE                  18:11
#define MC_BWSHARE_PPCS_0_PPCS_BW_HIGHTH_WOFFSET                        0x0
#define MC_BWSHARE_PPCS_0_PPCS_BW_HIGHTH_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_PPCS_0_PPCS_BW_HIGHTH_DEFAULT_MASK                   _MK_MASK_CONST(0xff)
#define MC_BWSHARE_PPCS_0_PPCS_BW_HIGHTH_SW_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_PPCS_0_PPCS_BW_HIGHTH_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)

#define MC_BWSHARE_PPCS_0_PPCS_BW_MAXTH_SHIFT                   _MK_SHIFT_CONST(19)
#define MC_BWSHARE_PPCS_0_PPCS_BW_MAXTH_FIELD                   (_MK_MASK_CONST(0xff) << MC_BWSHARE_PPCS_0_PPCS_BW_MAXTH_SHIFT)
#define MC_BWSHARE_PPCS_0_PPCS_BW_MAXTH_RANGE                   26:19
#define MC_BWSHARE_PPCS_0_PPCS_BW_MAXTH_WOFFSET                 0x0
#define MC_BWSHARE_PPCS_0_PPCS_BW_MAXTH_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_PPCS_0_PPCS_BW_MAXTH_DEFAULT_MASK                    _MK_MASK_CONST(0xff)
#define MC_BWSHARE_PPCS_0_PPCS_BW_MAXTH_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_PPCS_0_PPCS_BW_MAXTH_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)

#define MC_BWSHARE_PPCS_0_PPCS_BW_ALWAYSINC_SHIFT                       _MK_SHIFT_CONST(27)
#define MC_BWSHARE_PPCS_0_PPCS_BW_ALWAYSINC_FIELD                       (_MK_MASK_CONST(0x1) << MC_BWSHARE_PPCS_0_PPCS_BW_ALWAYSINC_SHIFT)
#define MC_BWSHARE_PPCS_0_PPCS_BW_ALWAYSINC_RANGE                       27:27
#define MC_BWSHARE_PPCS_0_PPCS_BW_ALWAYSINC_WOFFSET                     0x0
#define MC_BWSHARE_PPCS_0_PPCS_BW_ALWAYSINC_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_PPCS_0_PPCS_BW_ALWAYSINC_DEFAULT_MASK                        _MK_MASK_CONST(0x1)
#define MC_BWSHARE_PPCS_0_PPCS_BW_ALWAYSINC_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_PPCS_0_PPCS_BW_ALWAYSINC_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_PPCS_0_PPCS_BW_ALWAYSINC_INIT_ENUM                   DISABLE
#define MC_BWSHARE_PPCS_0_PPCS_BW_ALWAYSINC_DISABLE                     _MK_ENUM_CONST(0)
#define MC_BWSHARE_PPCS_0_PPCS_BW_ALWAYSINC_ENABLE                      _MK_ENUM_CONST(1)
#define MC_BWSHARE_PPCS_0_PPCS_BW_ALWAYSINC_DISABLED                    _MK_ENUM_CONST(0)
#define MC_BWSHARE_PPCS_0_PPCS_BW_ALWAYSINC_ENABLED                     _MK_ENUM_CONST(1)

#define MC_BWSHARE_PPCS_0_PPCS_BW_TMSFACTORSEL_SHIFT                    _MK_SHIFT_CONST(28)
#define MC_BWSHARE_PPCS_0_PPCS_BW_TMSFACTORSEL_FIELD                    (_MK_MASK_CONST(0x1) << MC_BWSHARE_PPCS_0_PPCS_BW_TMSFACTORSEL_SHIFT)
#define MC_BWSHARE_PPCS_0_PPCS_BW_TMSFACTORSEL_RANGE                    28:28
#define MC_BWSHARE_PPCS_0_PPCS_BW_TMSFACTORSEL_WOFFSET                  0x0
#define MC_BWSHARE_PPCS_0_PPCS_BW_TMSFACTORSEL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_PPCS_0_PPCS_BW_TMSFACTORSEL_DEFAULT_MASK                     _MK_MASK_CONST(0x1)
#define MC_BWSHARE_PPCS_0_PPCS_BW_TMSFACTORSEL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_PPCS_0_PPCS_BW_TMSFACTORSEL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_PPCS_0_PPCS_BW_TMSFACTORSEL_INIT_ENUM                        TM_SFACTOR1
#define MC_BWSHARE_PPCS_0_PPCS_BW_TMSFACTORSEL_TM_SFACTOR1                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_PPCS_0_PPCS_BW_TMSFACTORSEL_TM_SFACTOR2                      _MK_ENUM_CONST(1)


// Register MC_BWSHARE_VDE_0  
#define MC_BWSHARE_VDE_0                        _MK_ADDR_CONST(0x26c)
#define MC_BWSHARE_VDE_0_SECURE                         0x0
#define MC_BWSHARE_VDE_0_WORD_COUNT                     0x1
#define MC_BWSHARE_VDE_0_RESET_VAL                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VDE_0_RESET_MASK                     _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_VDE_0_SW_DEFAULT_VAL                         _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VDE_0_SW_DEFAULT_MASK                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VDE_0_READ_MASK                      _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_VDE_0_WRITE_MASK                     _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_VDE_0_VDE_BW_INCVAL_SHIFT                    _MK_SHIFT_CONST(0)
#define MC_BWSHARE_VDE_0_VDE_BW_INCVAL_FIELD                    (_MK_MASK_CONST(0x7ff) << MC_BWSHARE_VDE_0_VDE_BW_INCVAL_SHIFT)
#define MC_BWSHARE_VDE_0_VDE_BW_INCVAL_RANGE                    10:0
#define MC_BWSHARE_VDE_0_VDE_BW_INCVAL_WOFFSET                  0x0
#define MC_BWSHARE_VDE_0_VDE_BW_INCVAL_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VDE_0_VDE_BW_INCVAL_DEFAULT_MASK                     _MK_MASK_CONST(0x7ff)
#define MC_BWSHARE_VDE_0_VDE_BW_INCVAL_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VDE_0_VDE_BW_INCVAL_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define MC_BWSHARE_VDE_0_VDE_BW_HIGHTH_SHIFT                    _MK_SHIFT_CONST(11)
#define MC_BWSHARE_VDE_0_VDE_BW_HIGHTH_FIELD                    (_MK_MASK_CONST(0xff) << MC_BWSHARE_VDE_0_VDE_BW_HIGHTH_SHIFT)
#define MC_BWSHARE_VDE_0_VDE_BW_HIGHTH_RANGE                    18:11
#define MC_BWSHARE_VDE_0_VDE_BW_HIGHTH_WOFFSET                  0x0
#define MC_BWSHARE_VDE_0_VDE_BW_HIGHTH_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VDE_0_VDE_BW_HIGHTH_DEFAULT_MASK                     _MK_MASK_CONST(0xff)
#define MC_BWSHARE_VDE_0_VDE_BW_HIGHTH_SW_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VDE_0_VDE_BW_HIGHTH_SW_DEFAULT_MASK                  _MK_MASK_CONST(0x0)

#define MC_BWSHARE_VDE_0_VDE_BW_MAXTH_SHIFT                     _MK_SHIFT_CONST(19)
#define MC_BWSHARE_VDE_0_VDE_BW_MAXTH_FIELD                     (_MK_MASK_CONST(0xff) << MC_BWSHARE_VDE_0_VDE_BW_MAXTH_SHIFT)
#define MC_BWSHARE_VDE_0_VDE_BW_MAXTH_RANGE                     26:19
#define MC_BWSHARE_VDE_0_VDE_BW_MAXTH_WOFFSET                   0x0
#define MC_BWSHARE_VDE_0_VDE_BW_MAXTH_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VDE_0_VDE_BW_MAXTH_DEFAULT_MASK                      _MK_MASK_CONST(0xff)
#define MC_BWSHARE_VDE_0_VDE_BW_MAXTH_SW_DEFAULT                        _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VDE_0_VDE_BW_MAXTH_SW_DEFAULT_MASK                   _MK_MASK_CONST(0x0)

#define MC_BWSHARE_VDE_0_VDE_BW_ALWAYSINC_SHIFT                 _MK_SHIFT_CONST(27)
#define MC_BWSHARE_VDE_0_VDE_BW_ALWAYSINC_FIELD                 (_MK_MASK_CONST(0x1) << MC_BWSHARE_VDE_0_VDE_BW_ALWAYSINC_SHIFT)
#define MC_BWSHARE_VDE_0_VDE_BW_ALWAYSINC_RANGE                 27:27
#define MC_BWSHARE_VDE_0_VDE_BW_ALWAYSINC_WOFFSET                       0x0
#define MC_BWSHARE_VDE_0_VDE_BW_ALWAYSINC_DEFAULT                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VDE_0_VDE_BW_ALWAYSINC_DEFAULT_MASK                  _MK_MASK_CONST(0x1)
#define MC_BWSHARE_VDE_0_VDE_BW_ALWAYSINC_SW_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VDE_0_VDE_BW_ALWAYSINC_SW_DEFAULT_MASK                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VDE_0_VDE_BW_ALWAYSINC_INIT_ENUM                     DISABLE
#define MC_BWSHARE_VDE_0_VDE_BW_ALWAYSINC_DISABLE                       _MK_ENUM_CONST(0)
#define MC_BWSHARE_VDE_0_VDE_BW_ALWAYSINC_ENABLE                        _MK_ENUM_CONST(1)
#define MC_BWSHARE_VDE_0_VDE_BW_ALWAYSINC_DISABLED                      _MK_ENUM_CONST(0)
#define MC_BWSHARE_VDE_0_VDE_BW_ALWAYSINC_ENABLED                       _MK_ENUM_CONST(1)

#define MC_BWSHARE_VDE_0_VDE_BW_TMSFACTORSEL_SHIFT                      _MK_SHIFT_CONST(28)
#define MC_BWSHARE_VDE_0_VDE_BW_TMSFACTORSEL_FIELD                      (_MK_MASK_CONST(0x1) << MC_BWSHARE_VDE_0_VDE_BW_TMSFACTORSEL_SHIFT)
#define MC_BWSHARE_VDE_0_VDE_BW_TMSFACTORSEL_RANGE                      28:28
#define MC_BWSHARE_VDE_0_VDE_BW_TMSFACTORSEL_WOFFSET                    0x0
#define MC_BWSHARE_VDE_0_VDE_BW_TMSFACTORSEL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VDE_0_VDE_BW_TMSFACTORSEL_DEFAULT_MASK                       _MK_MASK_CONST(0x1)
#define MC_BWSHARE_VDE_0_VDE_BW_TMSFACTORSEL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VDE_0_VDE_BW_TMSFACTORSEL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VDE_0_VDE_BW_TMSFACTORSEL_INIT_ENUM                  TM_SFACTOR1
#define MC_BWSHARE_VDE_0_VDE_BW_TMSFACTORSEL_TM_SFACTOR1                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_VDE_0_VDE_BW_TMSFACTORSEL_TM_SFACTOR2                        _MK_ENUM_CONST(1)


// Register MC_BWSHARE_VI_0  
#define MC_BWSHARE_VI_0                 _MK_ADDR_CONST(0x270)
#define MC_BWSHARE_VI_0_SECURE                  0x0
#define MC_BWSHARE_VI_0_WORD_COUNT                      0x1
#define MC_BWSHARE_VI_0_RESET_VAL                       _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VI_0_RESET_MASK                      _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_VI_0_SW_DEFAULT_VAL                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VI_0_SW_DEFAULT_MASK                         _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VI_0_READ_MASK                       _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_VI_0_WRITE_MASK                      _MK_MASK_CONST(0x1fffffff)
#define MC_BWSHARE_VI_0_VI_BW_INCVAL_SHIFT                      _MK_SHIFT_CONST(0)
#define MC_BWSHARE_VI_0_VI_BW_INCVAL_FIELD                      (_MK_MASK_CONST(0x7ff) << MC_BWSHARE_VI_0_VI_BW_INCVAL_SHIFT)
#define MC_BWSHARE_VI_0_VI_BW_INCVAL_RANGE                      10:0
#define MC_BWSHARE_VI_0_VI_BW_INCVAL_WOFFSET                    0x0
#define MC_BWSHARE_VI_0_VI_BW_INCVAL_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VI_0_VI_BW_INCVAL_DEFAULT_MASK                       _MK_MASK_CONST(0x7ff)
#define MC_BWSHARE_VI_0_VI_BW_INCVAL_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VI_0_VI_BW_INCVAL_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_BWSHARE_VI_0_VI_BW_HIGHTH_SHIFT                      _MK_SHIFT_CONST(11)
#define MC_BWSHARE_VI_0_VI_BW_HIGHTH_FIELD                      (_MK_MASK_CONST(0xff) << MC_BWSHARE_VI_0_VI_BW_HIGHTH_SHIFT)
#define MC_BWSHARE_VI_0_VI_BW_HIGHTH_RANGE                      18:11
#define MC_BWSHARE_VI_0_VI_BW_HIGHTH_WOFFSET                    0x0
#define MC_BWSHARE_VI_0_VI_BW_HIGHTH_DEFAULT                    _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VI_0_VI_BW_HIGHTH_DEFAULT_MASK                       _MK_MASK_CONST(0xff)
#define MC_BWSHARE_VI_0_VI_BW_HIGHTH_SW_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VI_0_VI_BW_HIGHTH_SW_DEFAULT_MASK                    _MK_MASK_CONST(0x0)

#define MC_BWSHARE_VI_0_VI_BW_MAXTH_SHIFT                       _MK_SHIFT_CONST(19)
#define MC_BWSHARE_VI_0_VI_BW_MAXTH_FIELD                       (_MK_MASK_CONST(0xff) << MC_BWSHARE_VI_0_VI_BW_MAXTH_SHIFT)
#define MC_BWSHARE_VI_0_VI_BW_MAXTH_RANGE                       26:19
#define MC_BWSHARE_VI_0_VI_BW_MAXTH_WOFFSET                     0x0
#define MC_BWSHARE_VI_0_VI_BW_MAXTH_DEFAULT                     _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VI_0_VI_BW_MAXTH_DEFAULT_MASK                        _MK_MASK_CONST(0xff)
#define MC_BWSHARE_VI_0_VI_BW_MAXTH_SW_DEFAULT                  _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VI_0_VI_BW_MAXTH_SW_DEFAULT_MASK                     _MK_MASK_CONST(0x0)

#define MC_BWSHARE_VI_0_VI_BW_ALWAYSINC_SHIFT                   _MK_SHIFT_CONST(27)
#define MC_BWSHARE_VI_0_VI_BW_ALWAYSINC_FIELD                   (_MK_MASK_CONST(0x1) << MC_BWSHARE_VI_0_VI_BW_ALWAYSINC_SHIFT)
#define MC_BWSHARE_VI_0_VI_BW_ALWAYSINC_RANGE                   27:27
#define MC_BWSHARE_VI_0_VI_BW_ALWAYSINC_WOFFSET                 0x0
#define MC_BWSHARE_VI_0_VI_BW_ALWAYSINC_DEFAULT                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VI_0_VI_BW_ALWAYSINC_DEFAULT_MASK                    _MK_MASK_CONST(0x1)
#define MC_BWSHARE_VI_0_VI_BW_ALWAYSINC_SW_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VI_0_VI_BW_ALWAYSINC_SW_DEFAULT_MASK                 _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VI_0_VI_BW_ALWAYSINC_INIT_ENUM                       DISABLE
#define MC_BWSHARE_VI_0_VI_BW_ALWAYSINC_DISABLE                 _MK_ENUM_CONST(0)
#define MC_BWSHARE_VI_0_VI_BW_ALWAYSINC_ENABLE                  _MK_ENUM_CONST(1)
#define MC_BWSHARE_VI_0_VI_BW_ALWAYSINC_DISABLED                        _MK_ENUM_CONST(0)
#define MC_BWSHARE_VI_0_VI_BW_ALWAYSINC_ENABLED                 _MK_ENUM_CONST(1)

#define MC_BWSHARE_VI_0_VI_BW_TMSFACTORSEL_SHIFT                        _MK_SHIFT_CONST(28)
#define MC_BWSHARE_VI_0_VI_BW_TMSFACTORSEL_FIELD                        (_MK_MASK_CONST(0x1) << MC_BWSHARE_VI_0_VI_BW_TMSFACTORSEL_SHIFT)
#define MC_BWSHARE_VI_0_VI_BW_TMSFACTORSEL_RANGE                        28:28
#define MC_BWSHARE_VI_0_VI_BW_TMSFACTORSEL_WOFFSET                      0x0
#define MC_BWSHARE_VI_0_VI_BW_TMSFACTORSEL_DEFAULT                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VI_0_VI_BW_TMSFACTORSEL_DEFAULT_MASK                 _MK_MASK_CONST(0x1)
#define MC_BWSHARE_VI_0_VI_BW_TMSFACTORSEL_SW_DEFAULT                   _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VI_0_VI_BW_TMSFACTORSEL_SW_DEFAULT_MASK                      _MK_MASK_CONST(0x0)
#define MC_BWSHARE_VI_0_VI_BW_TMSFACTORSEL_INIT_ENUM                    TM_SFACTOR1
#define MC_BWSHARE_VI_0_VI_BW_TMSFACTORSEL_TM_SFACTOR1                  _MK_ENUM_CONST(0)
#define MC_BWSHARE_VI_0_VI_BW_TMSFACTORSEL_TM_SFACTOR2                  _MK_ENUM_CONST(1)

#define NV_MC_EMEM_DFIFO_DEPTH  4
#define NV_MC_IMEM_DFIFO_DEPTH  5
#define NV_MC_EMEM_APFIFO_DEPTH 5
#define NV_MC_ARB_EMEM_REGLEVEL 3
#define NV_MC_EMEM_REQ_ID_WIDEREQ       8
#define NV_MC_EMEM_RDI_ID_WIDERDI       8
#define NV_MC_EMEM_REQ_ID_ILLEGALACC    7
#define NV_MC_EMEM_RDI_ID_ILLEGALACC    7
#define NV_MC_EMEM_REQ_ID_LLRAWDECR     6
#define NV_MC_EMEM_RDI_ID_LLRAWDECR     6
#define NV_MC_EMEM_REQ_ID_APCIGNORE     5
#define NV_MC_EMEM_RDI_ID_APCIGNORE     5

// Packet MC2EMC
#define MC2EMC_SIZE 186

#define MC2EMC_WDO_SHIFT                        _MK_SHIFT_CONST(0)
#define MC2EMC_WDO_FIELD                        (_MK_MASK_CONST(0xffffffff) << MC2EMC_WDO_SHIFT)
#define MC2EMC_WDO_RANGE                        _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(0)
#define MC2EMC_WDO_ROW                  0

#define MC2EMC_WDO_0_SHIFT                      _MK_SHIFT_CONST(0)
#define MC2EMC_WDO_0_FIELD                      (_MK_MASK_CONST(0xffffffff) << MC2EMC_WDO_0_SHIFT)
#define MC2EMC_WDO_0_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define MC2EMC_WDO_0_ROW                        0

#define MC2EMC_WDO_1_SHIFT                      _MK_SHIFT_CONST(32)
#define MC2EMC_WDO_1_FIELD                      (_MK_MASK_CONST(0xffffffff) << MC2EMC_WDO_1_SHIFT)
#define MC2EMC_WDO_1_RANGE                      _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define MC2EMC_WDO_1_ROW                        0

#define MC2EMC_WDO_2_SHIFT                      _MK_SHIFT_CONST(64)
#define MC2EMC_WDO_2_FIELD                      (_MK_MASK_CONST(0xffffffff) << MC2EMC_WDO_2_SHIFT)
#define MC2EMC_WDO_2_RANGE                      _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define MC2EMC_WDO_2_ROW                        0

#define MC2EMC_WDO_3_SHIFT                      _MK_SHIFT_CONST(96)
#define MC2EMC_WDO_3_FIELD                      (_MK_MASK_CONST(0xffffffff) << MC2EMC_WDO_3_SHIFT)
#define MC2EMC_WDO_3_RANGE                      _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(96)
#define MC2EMC_WDO_3_ROW                        0

#define MC2EMC_BE_SHIFT                 _MK_SHIFT_CONST(128)
#define MC2EMC_BE_FIELD                 (_MK_MASK_CONST(0xffff) << MC2EMC_BE_SHIFT)
#define MC2EMC_BE_RANGE                 _MK_SHIFT_CONST(143):_MK_SHIFT_CONST(128)
#define MC2EMC_BE_ROW                   0

#define MC2EMC_ADR_SHIFT                        _MK_SHIFT_CONST(144)
#define MC2EMC_ADR_FIELD                        (_MK_MASK_CONST(0x3ffffff) << MC2EMC_ADR_SHIFT)
#define MC2EMC_ADR_RANGE                        _MK_SHIFT_CONST(169):_MK_SHIFT_CONST(144)
#define MC2EMC_ADR_ROW                  0

#define MC2EMC_REQ_ID_SHIFT                     _MK_SHIFT_CONST(170)
#define MC2EMC_REQ_ID_FIELD                     (_MK_MASK_CONST(0x1ff) << MC2EMC_REQ_ID_SHIFT)
#define MC2EMC_REQ_ID_RANGE                     _MK_SHIFT_CONST(178):_MK_SHIFT_CONST(170)
#define MC2EMC_REQ_ID_ROW                       0

#define MC2EMC_AP_SHIFT                 _MK_SHIFT_CONST(179)
#define MC2EMC_AP_FIELD                 (_MK_MASK_CONST(0x1) << MC2EMC_AP_SHIFT)
#define MC2EMC_AP_RANGE                 _MK_SHIFT_CONST(179):_MK_SHIFT_CONST(179)
#define MC2EMC_AP_ROW                   0

#define MC2EMC_WE_SHIFT                 _MK_SHIFT_CONST(180)
#define MC2EMC_WE_FIELD                 (_MK_MASK_CONST(0x1) << MC2EMC_WE_SHIFT)
#define MC2EMC_WE_RANGE                 _MK_SHIFT_CONST(180):_MK_SHIFT_CONST(180)
#define MC2EMC_WE_ROW                   0

#define MC2EMC_TAG_SHIFT                        _MK_SHIFT_CONST(181)
#define MC2EMC_TAG_FIELD                        (_MK_MASK_CONST(0x1f) << MC2EMC_TAG_SHIFT)
#define MC2EMC_TAG_RANGE                        _MK_SHIFT_CONST(185):_MK_SHIFT_CONST(181)
#define MC2EMC_TAG_ROW                  0


// Packet MC2EMC_APC
#define MC2EMC_APC_SIZE 3

#define MC2EMC_APC_CLR_SHIFT                    _MK_SHIFT_CONST(0)
#define MC2EMC_APC_CLR_FIELD                    (_MK_MASK_CONST(0x1) << MC2EMC_APC_CLR_SHIFT)
#define MC2EMC_APC_CLR_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define MC2EMC_APC_CLR_ROW                      0

#define MC2EMC_APC_BANK_SHIFT                   _MK_SHIFT_CONST(1)
#define MC2EMC_APC_BANK_FIELD                   (_MK_MASK_CONST(0x3) << MC2EMC_APC_BANK_SHIFT)
#define MC2EMC_APC_BANK_RANGE                   _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(1)
#define MC2EMC_APC_BANK_ROW                     0


// Packet EMC2MC
#define EMC2MC_SIZE 137

#define EMC2MC_RDI_SHIFT                        _MK_SHIFT_CONST(0)
#define EMC2MC_RDI_FIELD                        (_MK_MASK_CONST(0xffffffff) << EMC2MC_RDI_SHIFT)
#define EMC2MC_RDI_RANGE                        _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(0)
#define EMC2MC_RDI_ROW                  0

#define EMC2MC_RDI_0_SHIFT                      _MK_SHIFT_CONST(0)
#define EMC2MC_RDI_0_FIELD                      (_MK_MASK_CONST(0xffffffff) << EMC2MC_RDI_0_SHIFT)
#define EMC2MC_RDI_0_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define EMC2MC_RDI_0_ROW                        0

#define EMC2MC_RDI_1_SHIFT                      _MK_SHIFT_CONST(32)
#define EMC2MC_RDI_1_FIELD                      (_MK_MASK_CONST(0xffffffff) << EMC2MC_RDI_1_SHIFT)
#define EMC2MC_RDI_1_RANGE                      _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define EMC2MC_RDI_1_ROW                        0

#define EMC2MC_RDI_2_SHIFT                      _MK_SHIFT_CONST(64)
#define EMC2MC_RDI_2_FIELD                      (_MK_MASK_CONST(0xffffffff) << EMC2MC_RDI_2_SHIFT)
#define EMC2MC_RDI_2_RANGE                      _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define EMC2MC_RDI_2_ROW                        0

#define EMC2MC_RDI_3_SHIFT                      _MK_SHIFT_CONST(96)
#define EMC2MC_RDI_3_FIELD                      (_MK_MASK_CONST(0xffffffff) << EMC2MC_RDI_3_SHIFT)
#define EMC2MC_RDI_3_RANGE                      _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(96)
#define EMC2MC_RDI_3_ROW                        0

#define EMC2MC_RDI_ID_SHIFT                     _MK_SHIFT_CONST(128)
#define EMC2MC_RDI_ID_FIELD                     (_MK_MASK_CONST(0x1ff) << EMC2MC_RDI_ID_SHIFT)
#define EMC2MC_RDI_ID_RANGE                     _MK_SHIFT_CONST(136):_MK_SHIFT_CONST(128)
#define EMC2MC_RDI_ID_ROW                       0


// Packet MC2EMC_LL
#define MC2EMC_LL_SIZE 33

#define MC2EMC_LL_ADR_SHIFT                     _MK_SHIFT_CONST(0)
#define MC2EMC_LL_ADR_FIELD                     (_MK_MASK_CONST(0x7ffffff) << MC2EMC_LL_ADR_SHIFT)
#define MC2EMC_LL_ADR_RANGE                     _MK_SHIFT_CONST(26):_MK_SHIFT_CONST(0)
#define MC2EMC_LL_ADR_ROW                       0

#define MC2EMC_LL_TAG_SHIFT                     _MK_SHIFT_CONST(27)
#define MC2EMC_LL_TAG_FIELD                     (_MK_MASK_CONST(0x1f) << MC2EMC_LL_TAG_SHIFT)
#define MC2EMC_LL_TAG_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(27)
#define MC2EMC_LL_TAG_ROW                       0

#define MC2EMC_LL_DOUBLEREQ_SHIFT                       _MK_SHIFT_CONST(32)
#define MC2EMC_LL_DOUBLEREQ_FIELD                       (_MK_MASK_CONST(0x1) << MC2EMC_LL_DOUBLEREQ_SHIFT)
#define MC2EMC_LL_DOUBLEREQ_RANGE                       _MK_SHIFT_CONST(32):_MK_SHIFT_CONST(32)
#define MC2EMC_LL_DOUBLEREQ_ROW                 0


// Packet EMC2MC_LL
#define EMC2MC_LL_SIZE 64

#define EMC2MC_LL_RDI_SHIFT                     _MK_SHIFT_CONST(0)
#define EMC2MC_LL_RDI_FIELD                     (_MK_MASK_CONST(0xffffffff) << EMC2MC_LL_RDI_SHIFT)
#define EMC2MC_LL_RDI_RANGE                     _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define EMC2MC_LL_RDI_ROW                       0


// Packet MC2EMC_LL_CRITINFO
#define MC2EMC_LL_CRITINFO_SIZE 11

#define MC2EMC_LL_CRITINFO_HP_SHIFT                     _MK_SHIFT_CONST(0)
#define MC2EMC_LL_CRITINFO_HP_FIELD                     (_MK_MASK_CONST(0x1f) << MC2EMC_LL_CRITINFO_HP_SHIFT)
#define MC2EMC_LL_CRITINFO_HP_RANGE                     _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(0)
#define MC2EMC_LL_CRITINFO_HP_ROW                       0

#define MC2EMC_LL_CRITINFO_TIMEOUT_SHIFT                        _MK_SHIFT_CONST(5)
#define MC2EMC_LL_CRITINFO_TIMEOUT_FIELD                        (_MK_MASK_CONST(0x3f) << MC2EMC_LL_CRITINFO_TIMEOUT_SHIFT)
#define MC2EMC_LL_CRITINFO_TIMEOUT_RANGE                        _MK_SHIFT_CONST(10):_MK_SHIFT_CONST(5)
#define MC2EMC_LL_CRITINFO_TIMEOUT_ROW                  0


// Packet MC2EMC_LL_ARBINFO
#define MC2EMC_LL_ARBINFO_SIZE 2

#define MC2EMC_LL_ARBINFO_BANK_SHIFT                    _MK_SHIFT_CONST(0)
#define MC2EMC_LL_ARBINFO_BANK_FIELD                    (_MK_MASK_CONST(0x3) << MC2EMC_LL_ARBINFO_BANK_SHIFT)
#define MC2EMC_LL_ARBINFO_BANK_RANGE                    _MK_SHIFT_CONST(1):_MK_SHIFT_CONST(0)
#define MC2EMC_LL_ARBINFO_BANK_ROW                      0


// Packet CMC2MC_AXI_A
#define CMC2MC_AXI_A_SIZE 63

#define CMC2MC_AXI_A_AADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define CMC2MC_AXI_A_AADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << CMC2MC_AXI_A_AADDR_SHIFT)
#define CMC2MC_AXI_A_AADDR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CMC2MC_AXI_A_AADDR_ROW                  0

#define CMC2MC_AXI_A_AID_SHIFT                  _MK_SHIFT_CONST(32)
#define CMC2MC_AXI_A_AID_FIELD                  (_MK_MASK_CONST(0x1fff) << CMC2MC_AXI_A_AID_SHIFT)
#define CMC2MC_AXI_A_AID_RANGE                  _MK_SHIFT_CONST(44):_MK_SHIFT_CONST(32)
#define CMC2MC_AXI_A_AID_ROW                    0

#define CMC2MC_AXI_A_ALEN_SHIFT                 _MK_SHIFT_CONST(45)
#define CMC2MC_AXI_A_ALEN_FIELD                 (_MK_MASK_CONST(0xf) << CMC2MC_AXI_A_ALEN_SHIFT)
#define CMC2MC_AXI_A_ALEN_RANGE                 _MK_SHIFT_CONST(48):_MK_SHIFT_CONST(45)
#define CMC2MC_AXI_A_ALEN_ROW                   0
#define CMC2MC_AXI_A_ALEN_ONEDATA                       _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_ALEN_TWODATA                       _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_ALEN_THREEDATA                     _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_ALEN_FOURDATA                      _MK_ENUM_CONST(3)
#define CMC2MC_AXI_A_ALEN_FIVEDATA                      _MK_ENUM_CONST(4)
#define CMC2MC_AXI_A_ALEN_SIXDATA                       _MK_ENUM_CONST(5)
#define CMC2MC_AXI_A_ALEN_SEVENDATA                     _MK_ENUM_CONST(6)
#define CMC2MC_AXI_A_ALEN_EIGHTDATA                     _MK_ENUM_CONST(7)
#define CMC2MC_AXI_A_ALEN_NINEDATA                      _MK_ENUM_CONST(8)
#define CMC2MC_AXI_A_ALEN_TENDATA                       _MK_ENUM_CONST(9)
#define CMC2MC_AXI_A_ALEN_ELEVENDATA                    _MK_ENUM_CONST(10)
#define CMC2MC_AXI_A_ALEN_TWELVEDATA                    _MK_ENUM_CONST(11)
#define CMC2MC_AXI_A_ALEN_THIRTEENDATA                  _MK_ENUM_CONST(12)
#define CMC2MC_AXI_A_ALEN_FOURTEENDATA                  _MK_ENUM_CONST(13)
#define CMC2MC_AXI_A_ALEN_FIFTHTEENDATA                 _MK_ENUM_CONST(14)
#define CMC2MC_AXI_A_ALEN_SIXTEENDATA                   _MK_ENUM_CONST(15)

#define CMC2MC_AXI_A_ASIZE_SHIFT                        _MK_SHIFT_CONST(49)
#define CMC2MC_AXI_A_ASIZE_FIELD                        (_MK_MASK_CONST(0x7) << CMC2MC_AXI_A_ASIZE_SHIFT)
#define CMC2MC_AXI_A_ASIZE_RANGE                        _MK_SHIFT_CONST(51):_MK_SHIFT_CONST(49)
#define CMC2MC_AXI_A_ASIZE_ROW                  0
#define CMC2MC_AXI_A_ASIZE_ONEBYTE                      _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_ASIZE_TWOBYTES                     _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_ASIZE_FOURBYTES                    _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_ASIZE_EIGHTBYTES                   _MK_ENUM_CONST(3)
#define CMC2MC_AXI_A_ASIZE_SIXTEENBYTES                 _MK_ENUM_CONST(4)
#define CMC2MC_AXI_A_ASIZE_THIRTYTWOBYTES                       _MK_ENUM_CONST(5)
#define CMC2MC_AXI_A_ASIZE_SIXTYFOURBYTES                       _MK_ENUM_CONST(6)
#define CMC2MC_AXI_A_ASIZE_ONEHUNDREDTWENTYEIGHTBYTES                   _MK_ENUM_CONST(7)

#define CMC2MC_AXI_A_ABURST_SHIFT                       _MK_SHIFT_CONST(52)
#define CMC2MC_AXI_A_ABURST_FIELD                       (_MK_MASK_CONST(0x3) << CMC2MC_AXI_A_ABURST_SHIFT)
#define CMC2MC_AXI_A_ABURST_RANGE                       _MK_SHIFT_CONST(53):_MK_SHIFT_CONST(52)
#define CMC2MC_AXI_A_ABURST_ROW                 0
#define CMC2MC_AXI_A_ABURST_FIXED                       _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_ABURST_INCR                        _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_ABURST_WRAP                        _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_ABURST_RSVD                        _MK_ENUM_CONST(3)

#define CMC2MC_AXI_A_ALOCK_SHIFT                        _MK_SHIFT_CONST(54)
#define CMC2MC_AXI_A_ALOCK_FIELD                        (_MK_MASK_CONST(0x3) << CMC2MC_AXI_A_ALOCK_SHIFT)
#define CMC2MC_AXI_A_ALOCK_RANGE                        _MK_SHIFT_CONST(55):_MK_SHIFT_CONST(54)
#define CMC2MC_AXI_A_ALOCK_ROW                  0
#define CMC2MC_AXI_A_ALOCK_NORMAL                       _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_ALOCK_EXCLUSIVE                    _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_ALOCK_LOCKED                       _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_ALOCK_RSVD                 _MK_ENUM_CONST(3)

#define CMC2MC_AXI_A_ACACHE_SHIFT                       _MK_SHIFT_CONST(56)
#define CMC2MC_AXI_A_ACACHE_FIELD                       (_MK_MASK_CONST(0xf) << CMC2MC_AXI_A_ACACHE_SHIFT)
#define CMC2MC_AXI_A_ACACHE_RANGE                       _MK_SHIFT_CONST(59):_MK_SHIFT_CONST(56)
#define CMC2MC_AXI_A_ACACHE_ROW                 0
#define CMC2MC_AXI_A_ACACHE_NONCACHEABLE_NONBUFFERABLE                  _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_ACACHE_BUFFERABLE                  _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_ACACHE_CACHEABLE_DONOTALLOCATE                     _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_ACACHE_CACHEABLE_BUFFERABLE_DONOTALLOCATE                  _MK_ENUM_CONST(3)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREAD                        _MK_ENUM_CONST(6)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREAD                   _MK_ENUM_CONST(7)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONWRITE                       _MK_ENUM_CONST(10)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONWRITE                  _MK_ENUM_CONST(11)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREADWRITE                   _MK_ENUM_CONST(14)
#define CMC2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREADWRITE                      _MK_ENUM_CONST(15)

#define CMC2MC_AXI_A_APROT_SHIFT                        _MK_SHIFT_CONST(60)
#define CMC2MC_AXI_A_APROT_FIELD                        (_MK_MASK_CONST(0x7) << CMC2MC_AXI_A_APROT_SHIFT)
#define CMC2MC_AXI_A_APROT_RANGE                        _MK_SHIFT_CONST(62):_MK_SHIFT_CONST(60)
#define CMC2MC_AXI_A_APROT_ROW                  0
#define CMC2MC_AXI_A_APROT_DATA_SECURE_NORMAL                   _MK_ENUM_CONST(0)
#define CMC2MC_AXI_A_APROT_DATA_SECURE_PRIVILEGED                       _MK_ENUM_CONST(1)
#define CMC2MC_AXI_A_APROT_DATA_NONSECURE_NORMAL                        _MK_ENUM_CONST(2)
#define CMC2MC_AXI_A_APROT_DATA_NONSECURE_PRIVILEGED                    _MK_ENUM_CONST(3)
#define CMC2MC_AXI_A_APROT_INST_SECURE_NORMAL                   _MK_ENUM_CONST(4)
#define CMC2MC_AXI_A_APROT_INST_SECURE_PRIVILEGED                       _MK_ENUM_CONST(5)
#define CMC2MC_AXI_A_APROT_INST_NONSECURE_NORMAL                        _MK_ENUM_CONST(6)
#define CMC2MC_AXI_A_APROT_INST_NONSECURE_PRIVILEGED                    _MK_ENUM_CONST(7)


// Packet CMC2MC_AXI_W
#define CMC2MC_AXI_W_SIZE 86

#define CMC2MC_AXI_W_WDATA_SHIFT                        _MK_SHIFT_CONST(0)
#define CMC2MC_AXI_W_WDATA_FIELD                        (_MK_MASK_CONST(0xffffffff) << CMC2MC_AXI_W_WDATA_SHIFT)
#define CMC2MC_AXI_W_WDATA_RANGE                        _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define CMC2MC_AXI_W_WDATA_ROW                  0

#define CMC2MC_AXI_W_WID_SHIFT                  _MK_SHIFT_CONST(64)
#define CMC2MC_AXI_W_WID_FIELD                  (_MK_MASK_CONST(0x1fff) << CMC2MC_AXI_W_WID_SHIFT)
#define CMC2MC_AXI_W_WID_RANGE                  _MK_SHIFT_CONST(76):_MK_SHIFT_CONST(64)
#define CMC2MC_AXI_W_WID_ROW                    0

#define CMC2MC_AXI_W_WSTRB_SHIFT                        _MK_SHIFT_CONST(77)
#define CMC2MC_AXI_W_WSTRB_FIELD                        (_MK_MASK_CONST(0xff) << CMC2MC_AXI_W_WSTRB_SHIFT)
#define CMC2MC_AXI_W_WSTRB_RANGE                        _MK_SHIFT_CONST(84):_MK_SHIFT_CONST(77)
#define CMC2MC_AXI_W_WSTRB_ROW                  0

#define CMC2MC_AXI_W_WLAST_SHIFT                        _MK_SHIFT_CONST(85)
#define CMC2MC_AXI_W_WLAST_FIELD                        (_MK_MASK_CONST(0x1) << CMC2MC_AXI_W_WLAST_SHIFT)
#define CMC2MC_AXI_W_WLAST_RANGE                        _MK_SHIFT_CONST(85):_MK_SHIFT_CONST(85)
#define CMC2MC_AXI_W_WLAST_ROW                  0
#define CMC2MC_AXI_W_WLAST_DISABLED                     _MK_ENUM_CONST(0)
#define CMC2MC_AXI_W_WLAST_ENABLED                      _MK_ENUM_CONST(1)


// Packet CMC2MC_AXI_B
#define CMC2MC_AXI_B_SIZE 15

#define CMC2MC_AXI_B_BID_SHIFT                  _MK_SHIFT_CONST(0)
#define CMC2MC_AXI_B_BID_FIELD                  (_MK_MASK_CONST(0x1fff) << CMC2MC_AXI_B_BID_SHIFT)
#define CMC2MC_AXI_B_BID_RANGE                  _MK_SHIFT_CONST(12):_MK_SHIFT_CONST(0)
#define CMC2MC_AXI_B_BID_ROW                    0

#define CMC2MC_AXI_B_BRESP_SHIFT                        _MK_SHIFT_CONST(13)
#define CMC2MC_AXI_B_BRESP_FIELD                        (_MK_MASK_CONST(0x3) << CMC2MC_AXI_B_BRESP_SHIFT)
#define CMC2MC_AXI_B_BRESP_RANGE                        _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(13)
#define CMC2MC_AXI_B_BRESP_ROW                  0
#define CMC2MC_AXI_B_BRESP_OKAY                 _MK_ENUM_CONST(0)
#define CMC2MC_AXI_B_BRESP_EXOKAY                       _MK_ENUM_CONST(1)
#define CMC2MC_AXI_B_BRESP_SLVERR                       _MK_ENUM_CONST(2)
#define CMC2MC_AXI_B_BRESP_DECERR                       _MK_ENUM_CONST(3)


// Packet CMC2MC_AXI_R
#define CMC2MC_AXI_R_SIZE 80

#define CMC2MC_AXI_R_RDATA_SHIFT                        _MK_SHIFT_CONST(0)
#define CMC2MC_AXI_R_RDATA_FIELD                        (_MK_MASK_CONST(0xffffffff) << CMC2MC_AXI_R_RDATA_SHIFT)
#define CMC2MC_AXI_R_RDATA_RANGE                        _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define CMC2MC_AXI_R_RDATA_ROW                  0

#define CMC2MC_AXI_R_RID_SHIFT                  _MK_SHIFT_CONST(64)
#define CMC2MC_AXI_R_RID_FIELD                  (_MK_MASK_CONST(0x1fff) << CMC2MC_AXI_R_RID_SHIFT)
#define CMC2MC_AXI_R_RID_RANGE                  _MK_SHIFT_CONST(76):_MK_SHIFT_CONST(64)
#define CMC2MC_AXI_R_RID_ROW                    0

#define CMC2MC_AXI_R_RRESP_SHIFT                        _MK_SHIFT_CONST(77)
#define CMC2MC_AXI_R_RRESP_FIELD                        (_MK_MASK_CONST(0x3) << CMC2MC_AXI_R_RRESP_SHIFT)
#define CMC2MC_AXI_R_RRESP_RANGE                        _MK_SHIFT_CONST(78):_MK_SHIFT_CONST(77)
#define CMC2MC_AXI_R_RRESP_ROW                  0
#define CMC2MC_AXI_R_RRESP_OKAY                 _MK_ENUM_CONST(0)
#define CMC2MC_AXI_R_RRESP_EXOKAY                       _MK_ENUM_CONST(1)
#define CMC2MC_AXI_R_RRESP_SLVERR                       _MK_ENUM_CONST(2)
#define CMC2MC_AXI_R_RRESP_DECERR                       _MK_ENUM_CONST(3)

#define CMC2MC_AXI_R_RLAST_SHIFT                        _MK_SHIFT_CONST(79)
#define CMC2MC_AXI_R_RLAST_FIELD                        (_MK_MASK_CONST(0x1) << CMC2MC_AXI_R_RLAST_SHIFT)
#define CMC2MC_AXI_R_RLAST_RANGE                        _MK_SHIFT_CONST(79):_MK_SHIFT_CONST(79)
#define CMC2MC_AXI_R_RLAST_ROW                  0
#define CMC2MC_AXI_R_RLAST_DISABLED                     _MK_ENUM_CONST(0)
#define CMC2MC_AXI_R_RLAST_ENABLED                      _MK_ENUM_CONST(1)


// Packet MSELECT2MC_AXI_A
#define MSELECT2MC_AXI_A_SIZE 63

#define MSELECT2MC_AXI_A_AADDR_SHIFT                    _MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_A_AADDR_FIELD                    (_MK_MASK_CONST(0xffffffff) << MSELECT2MC_AXI_A_AADDR_SHIFT)
#define MSELECT2MC_AXI_A_AADDR_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_A_AADDR_ROW                      0

#define MSELECT2MC_AXI_A_AID_SHIFT                      _MK_SHIFT_CONST(32)
#define MSELECT2MC_AXI_A_AID_FIELD                      (_MK_MASK_CONST(0x1fff) << MSELECT2MC_AXI_A_AID_SHIFT)
#define MSELECT2MC_AXI_A_AID_RANGE                      _MK_SHIFT_CONST(44):_MK_SHIFT_CONST(32)
#define MSELECT2MC_AXI_A_AID_ROW                        0

#define MSELECT2MC_AXI_A_ALEN_SHIFT                     _MK_SHIFT_CONST(45)
#define MSELECT2MC_AXI_A_ALEN_FIELD                     (_MK_MASK_CONST(0xf) << MSELECT2MC_AXI_A_ALEN_SHIFT)
#define MSELECT2MC_AXI_A_ALEN_RANGE                     _MK_SHIFT_CONST(48):_MK_SHIFT_CONST(45)
#define MSELECT2MC_AXI_A_ALEN_ROW                       0
#define MSELECT2MC_AXI_A_ALEN_ONEDATA                   _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_ALEN_TWODATA                   _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_ALEN_THREEDATA                 _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_ALEN_FOURDATA                  _MK_ENUM_CONST(3)
#define MSELECT2MC_AXI_A_ALEN_FIVEDATA                  _MK_ENUM_CONST(4)
#define MSELECT2MC_AXI_A_ALEN_SIXDATA                   _MK_ENUM_CONST(5)
#define MSELECT2MC_AXI_A_ALEN_SEVENDATA                 _MK_ENUM_CONST(6)
#define MSELECT2MC_AXI_A_ALEN_EIGHTDATA                 _MK_ENUM_CONST(7)
#define MSELECT2MC_AXI_A_ALEN_NINEDATA                  _MK_ENUM_CONST(8)
#define MSELECT2MC_AXI_A_ALEN_TENDATA                   _MK_ENUM_CONST(9)
#define MSELECT2MC_AXI_A_ALEN_ELEVENDATA                        _MK_ENUM_CONST(10)
#define MSELECT2MC_AXI_A_ALEN_TWELVEDATA                        _MK_ENUM_CONST(11)
#define MSELECT2MC_AXI_A_ALEN_THIRTEENDATA                      _MK_ENUM_CONST(12)
#define MSELECT2MC_AXI_A_ALEN_FOURTEENDATA                      _MK_ENUM_CONST(13)
#define MSELECT2MC_AXI_A_ALEN_FIFTHTEENDATA                     _MK_ENUM_CONST(14)
#define MSELECT2MC_AXI_A_ALEN_SIXTEENDATA                       _MK_ENUM_CONST(15)

#define MSELECT2MC_AXI_A_ASIZE_SHIFT                    _MK_SHIFT_CONST(49)
#define MSELECT2MC_AXI_A_ASIZE_FIELD                    (_MK_MASK_CONST(0x7) << MSELECT2MC_AXI_A_ASIZE_SHIFT)
#define MSELECT2MC_AXI_A_ASIZE_RANGE                    _MK_SHIFT_CONST(51):_MK_SHIFT_CONST(49)
#define MSELECT2MC_AXI_A_ASIZE_ROW                      0
#define MSELECT2MC_AXI_A_ASIZE_ONEBYTE                  _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_ASIZE_TWOBYTES                 _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_ASIZE_FOURBYTES                        _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_ASIZE_EIGHTBYTES                       _MK_ENUM_CONST(3)
#define MSELECT2MC_AXI_A_ASIZE_SIXTEENBYTES                     _MK_ENUM_CONST(4)
#define MSELECT2MC_AXI_A_ASIZE_THIRTYTWOBYTES                   _MK_ENUM_CONST(5)
#define MSELECT2MC_AXI_A_ASIZE_SIXTYFOURBYTES                   _MK_ENUM_CONST(6)
#define MSELECT2MC_AXI_A_ASIZE_ONEHUNDREDTWENTYEIGHTBYTES                       _MK_ENUM_CONST(7)

#define MSELECT2MC_AXI_A_ABURST_SHIFT                   _MK_SHIFT_CONST(52)
#define MSELECT2MC_AXI_A_ABURST_FIELD                   (_MK_MASK_CONST(0x3) << MSELECT2MC_AXI_A_ABURST_SHIFT)
#define MSELECT2MC_AXI_A_ABURST_RANGE                   _MK_SHIFT_CONST(53):_MK_SHIFT_CONST(52)
#define MSELECT2MC_AXI_A_ABURST_ROW                     0
#define MSELECT2MC_AXI_A_ABURST_FIXED                   _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_ABURST_INCR                    _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_ABURST_WRAP                    _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_ABURST_RSVD                    _MK_ENUM_CONST(3)

#define MSELECT2MC_AXI_A_ALOCK_SHIFT                    _MK_SHIFT_CONST(54)
#define MSELECT2MC_AXI_A_ALOCK_FIELD                    (_MK_MASK_CONST(0x3) << MSELECT2MC_AXI_A_ALOCK_SHIFT)
#define MSELECT2MC_AXI_A_ALOCK_RANGE                    _MK_SHIFT_CONST(55):_MK_SHIFT_CONST(54)
#define MSELECT2MC_AXI_A_ALOCK_ROW                      0
#define MSELECT2MC_AXI_A_ALOCK_NORMAL                   _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_ALOCK_EXCLUSIVE                        _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_ALOCK_LOCKED                   _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_ALOCK_RSVD                     _MK_ENUM_CONST(3)

#define MSELECT2MC_AXI_A_ACACHE_SHIFT                   _MK_SHIFT_CONST(56)
#define MSELECT2MC_AXI_A_ACACHE_FIELD                   (_MK_MASK_CONST(0xf) << MSELECT2MC_AXI_A_ACACHE_SHIFT)
#define MSELECT2MC_AXI_A_ACACHE_RANGE                   _MK_SHIFT_CONST(59):_MK_SHIFT_CONST(56)
#define MSELECT2MC_AXI_A_ACACHE_ROW                     0
#define MSELECT2MC_AXI_A_ACACHE_NONCACHEABLE_NONBUFFERABLE                      _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_ACACHE_BUFFERABLE                      _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLE_DONOTALLOCATE                 _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLE_BUFFERABLE_DONOTALLOCATE                      _MK_ENUM_CONST(3)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREAD                    _MK_ENUM_CONST(6)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREAD                       _MK_ENUM_CONST(7)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONWRITE                   _MK_ENUM_CONST(10)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONWRITE                      _MK_ENUM_CONST(11)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREADWRITE                       _MK_ENUM_CONST(14)
#define MSELECT2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREADWRITE                  _MK_ENUM_CONST(15)

#define MSELECT2MC_AXI_A_APROT_SHIFT                    _MK_SHIFT_CONST(60)
#define MSELECT2MC_AXI_A_APROT_FIELD                    (_MK_MASK_CONST(0x7) << MSELECT2MC_AXI_A_APROT_SHIFT)
#define MSELECT2MC_AXI_A_APROT_RANGE                    _MK_SHIFT_CONST(62):_MK_SHIFT_CONST(60)
#define MSELECT2MC_AXI_A_APROT_ROW                      0
#define MSELECT2MC_AXI_A_APROT_DATA_SECURE_NORMAL                       _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_A_APROT_DATA_SECURE_PRIVILEGED                   _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_A_APROT_DATA_NONSECURE_NORMAL                    _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_A_APROT_DATA_NONSECURE_PRIVILEGED                        _MK_ENUM_CONST(3)
#define MSELECT2MC_AXI_A_APROT_INST_SECURE_NORMAL                       _MK_ENUM_CONST(4)
#define MSELECT2MC_AXI_A_APROT_INST_SECURE_PRIVILEGED                   _MK_ENUM_CONST(5)
#define MSELECT2MC_AXI_A_APROT_INST_NONSECURE_NORMAL                    _MK_ENUM_CONST(6)
#define MSELECT2MC_AXI_A_APROT_INST_NONSECURE_PRIVILEGED                        _MK_ENUM_CONST(7)


// Packet MSELECT2MC_AXI_W
#define MSELECT2MC_AXI_W_SIZE 86

#define MSELECT2MC_AXI_W_WDATA_SHIFT                    _MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_W_WDATA_FIELD                    (_MK_MASK_CONST(0xffffffff) << MSELECT2MC_AXI_W_WDATA_SHIFT)
#define MSELECT2MC_AXI_W_WDATA_RANGE                    _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_W_WDATA_ROW                      0

#define MSELECT2MC_AXI_W_WID_SHIFT                      _MK_SHIFT_CONST(64)
#define MSELECT2MC_AXI_W_WID_FIELD                      (_MK_MASK_CONST(0x1fff) << MSELECT2MC_AXI_W_WID_SHIFT)
#define MSELECT2MC_AXI_W_WID_RANGE                      _MK_SHIFT_CONST(76):_MK_SHIFT_CONST(64)
#define MSELECT2MC_AXI_W_WID_ROW                        0

#define MSELECT2MC_AXI_W_WSTRB_SHIFT                    _MK_SHIFT_CONST(77)
#define MSELECT2MC_AXI_W_WSTRB_FIELD                    (_MK_MASK_CONST(0xff) << MSELECT2MC_AXI_W_WSTRB_SHIFT)
#define MSELECT2MC_AXI_W_WSTRB_RANGE                    _MK_SHIFT_CONST(84):_MK_SHIFT_CONST(77)
#define MSELECT2MC_AXI_W_WSTRB_ROW                      0

#define MSELECT2MC_AXI_W_WLAST_SHIFT                    _MK_SHIFT_CONST(85)
#define MSELECT2MC_AXI_W_WLAST_FIELD                    (_MK_MASK_CONST(0x1) << MSELECT2MC_AXI_W_WLAST_SHIFT)
#define MSELECT2MC_AXI_W_WLAST_RANGE                    _MK_SHIFT_CONST(85):_MK_SHIFT_CONST(85)
#define MSELECT2MC_AXI_W_WLAST_ROW                      0
#define MSELECT2MC_AXI_W_WLAST_DISABLED                 _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_W_WLAST_ENABLED                  _MK_ENUM_CONST(1)


// Packet MSELECT2MC_AXI_B
#define MSELECT2MC_AXI_B_SIZE 15

#define MSELECT2MC_AXI_B_BID_SHIFT                      _MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_B_BID_FIELD                      (_MK_MASK_CONST(0x1fff) << MSELECT2MC_AXI_B_BID_SHIFT)
#define MSELECT2MC_AXI_B_BID_RANGE                      _MK_SHIFT_CONST(12):_MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_B_BID_ROW                        0

#define MSELECT2MC_AXI_B_BRESP_SHIFT                    _MK_SHIFT_CONST(13)
#define MSELECT2MC_AXI_B_BRESP_FIELD                    (_MK_MASK_CONST(0x3) << MSELECT2MC_AXI_B_BRESP_SHIFT)
#define MSELECT2MC_AXI_B_BRESP_RANGE                    _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(13)
#define MSELECT2MC_AXI_B_BRESP_ROW                      0
#define MSELECT2MC_AXI_B_BRESP_OKAY                     _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_B_BRESP_EXOKAY                   _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_B_BRESP_SLVERR                   _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_B_BRESP_DECERR                   _MK_ENUM_CONST(3)


// Packet MSELECT2MC_AXI_R
#define MSELECT2MC_AXI_R_SIZE 80

#define MSELECT2MC_AXI_R_RDATA_SHIFT                    _MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_R_RDATA_FIELD                    (_MK_MASK_CONST(0xffffffff) << MSELECT2MC_AXI_R_RDATA_SHIFT)
#define MSELECT2MC_AXI_R_RDATA_RANGE                    _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(0)
#define MSELECT2MC_AXI_R_RDATA_ROW                      0

#define MSELECT2MC_AXI_R_RID_SHIFT                      _MK_SHIFT_CONST(64)
#define MSELECT2MC_AXI_R_RID_FIELD                      (_MK_MASK_CONST(0x1fff) << MSELECT2MC_AXI_R_RID_SHIFT)
#define MSELECT2MC_AXI_R_RID_RANGE                      _MK_SHIFT_CONST(76):_MK_SHIFT_CONST(64)
#define MSELECT2MC_AXI_R_RID_ROW                        0

#define MSELECT2MC_AXI_R_RRESP_SHIFT                    _MK_SHIFT_CONST(77)
#define MSELECT2MC_AXI_R_RRESP_FIELD                    (_MK_MASK_CONST(0x3) << MSELECT2MC_AXI_R_RRESP_SHIFT)
#define MSELECT2MC_AXI_R_RRESP_RANGE                    _MK_SHIFT_CONST(78):_MK_SHIFT_CONST(77)
#define MSELECT2MC_AXI_R_RRESP_ROW                      0
#define MSELECT2MC_AXI_R_RRESP_OKAY                     _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_R_RRESP_EXOKAY                   _MK_ENUM_CONST(1)
#define MSELECT2MC_AXI_R_RRESP_SLVERR                   _MK_ENUM_CONST(2)
#define MSELECT2MC_AXI_R_RRESP_DECERR                   _MK_ENUM_CONST(3)

#define MSELECT2MC_AXI_R_RLAST_SHIFT                    _MK_SHIFT_CONST(79)
#define MSELECT2MC_AXI_R_RLAST_FIELD                    (_MK_MASK_CONST(0x1) << MSELECT2MC_AXI_R_RLAST_SHIFT)
#define MSELECT2MC_AXI_R_RLAST_RANGE                    _MK_SHIFT_CONST(79):_MK_SHIFT_CONST(79)
#define MSELECT2MC_AXI_R_RLAST_ROW                      0
#define MSELECT2MC_AXI_R_RLAST_DISABLED                 _MK_ENUM_CONST(0)
#define MSELECT2MC_AXI_R_RLAST_ENABLED                  _MK_ENUM_CONST(1)


// Packet AXI2MC_AXI_A
#define AXI2MC_AXI_A_SIZE 63

#define AXI2MC_AXI_A_AADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define AXI2MC_AXI_A_AADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << AXI2MC_AXI_A_AADDR_SHIFT)
#define AXI2MC_AXI_A_AADDR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define AXI2MC_AXI_A_AADDR_ROW                  0

#define AXI2MC_AXI_A_AID_SHIFT                  _MK_SHIFT_CONST(32)
#define AXI2MC_AXI_A_AID_FIELD                  (_MK_MASK_CONST(0x1fff) << AXI2MC_AXI_A_AID_SHIFT)
#define AXI2MC_AXI_A_AID_RANGE                  _MK_SHIFT_CONST(44):_MK_SHIFT_CONST(32)
#define AXI2MC_AXI_A_AID_ROW                    0

#define AXI2MC_AXI_A_ALEN_SHIFT                 _MK_SHIFT_CONST(45)
#define AXI2MC_AXI_A_ALEN_FIELD                 (_MK_MASK_CONST(0xf) << AXI2MC_AXI_A_ALEN_SHIFT)
#define AXI2MC_AXI_A_ALEN_RANGE                 _MK_SHIFT_CONST(48):_MK_SHIFT_CONST(45)
#define AXI2MC_AXI_A_ALEN_ROW                   0
#define AXI2MC_AXI_A_ALEN_ONEDATA                       _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_ALEN_TWODATA                       _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_ALEN_THREEDATA                     _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_ALEN_FOURDATA                      _MK_ENUM_CONST(3)
#define AXI2MC_AXI_A_ALEN_FIVEDATA                      _MK_ENUM_CONST(4)
#define AXI2MC_AXI_A_ALEN_SIXDATA                       _MK_ENUM_CONST(5)
#define AXI2MC_AXI_A_ALEN_SEVENDATA                     _MK_ENUM_CONST(6)
#define AXI2MC_AXI_A_ALEN_EIGHTDATA                     _MK_ENUM_CONST(7)
#define AXI2MC_AXI_A_ALEN_NINEDATA                      _MK_ENUM_CONST(8)
#define AXI2MC_AXI_A_ALEN_TENDATA                       _MK_ENUM_CONST(9)
#define AXI2MC_AXI_A_ALEN_ELEVENDATA                    _MK_ENUM_CONST(10)
#define AXI2MC_AXI_A_ALEN_TWELVEDATA                    _MK_ENUM_CONST(11)
#define AXI2MC_AXI_A_ALEN_THIRTEENDATA                  _MK_ENUM_CONST(12)
#define AXI2MC_AXI_A_ALEN_FOURTEENDATA                  _MK_ENUM_CONST(13)
#define AXI2MC_AXI_A_ALEN_FIFTHTEENDATA                 _MK_ENUM_CONST(14)
#define AXI2MC_AXI_A_ALEN_SIXTEENDATA                   _MK_ENUM_CONST(15)

#define AXI2MC_AXI_A_ASIZE_SHIFT                        _MK_SHIFT_CONST(49)
#define AXI2MC_AXI_A_ASIZE_FIELD                        (_MK_MASK_CONST(0x7) << AXI2MC_AXI_A_ASIZE_SHIFT)
#define AXI2MC_AXI_A_ASIZE_RANGE                        _MK_SHIFT_CONST(51):_MK_SHIFT_CONST(49)
#define AXI2MC_AXI_A_ASIZE_ROW                  0
#define AXI2MC_AXI_A_ASIZE_ONEBYTE                      _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_ASIZE_TWOBYTES                     _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_ASIZE_FOURBYTES                    _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_ASIZE_EIGHTBYTES                   _MK_ENUM_CONST(3)
#define AXI2MC_AXI_A_ASIZE_SIXTEENBYTES                 _MK_ENUM_CONST(4)
#define AXI2MC_AXI_A_ASIZE_THIRTYTWOBYTES                       _MK_ENUM_CONST(5)
#define AXI2MC_AXI_A_ASIZE_SIXTYFOURBYTES                       _MK_ENUM_CONST(6)
#define AXI2MC_AXI_A_ASIZE_ONEHUNDREDTWENTYEIGHTBYTES                   _MK_ENUM_CONST(7)

#define AXI2MC_AXI_A_ABURST_SHIFT                       _MK_SHIFT_CONST(52)
#define AXI2MC_AXI_A_ABURST_FIELD                       (_MK_MASK_CONST(0x3) << AXI2MC_AXI_A_ABURST_SHIFT)
#define AXI2MC_AXI_A_ABURST_RANGE                       _MK_SHIFT_CONST(53):_MK_SHIFT_CONST(52)
#define AXI2MC_AXI_A_ABURST_ROW                 0
#define AXI2MC_AXI_A_ABURST_FIXED                       _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_ABURST_INCR                        _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_ABURST_WRAP                        _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_ABURST_RSVD                        _MK_ENUM_CONST(3)

#define AXI2MC_AXI_A_ALOCK_SHIFT                        _MK_SHIFT_CONST(54)
#define AXI2MC_AXI_A_ALOCK_FIELD                        (_MK_MASK_CONST(0x3) << AXI2MC_AXI_A_ALOCK_SHIFT)
#define AXI2MC_AXI_A_ALOCK_RANGE                        _MK_SHIFT_CONST(55):_MK_SHIFT_CONST(54)
#define AXI2MC_AXI_A_ALOCK_ROW                  0
#define AXI2MC_AXI_A_ALOCK_NORMAL                       _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_ALOCK_EXCLUSIVE                    _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_ALOCK_LOCKED                       _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_ALOCK_RSVD                 _MK_ENUM_CONST(3)

#define AXI2MC_AXI_A_ACACHE_SHIFT                       _MK_SHIFT_CONST(56)
#define AXI2MC_AXI_A_ACACHE_FIELD                       (_MK_MASK_CONST(0xf) << AXI2MC_AXI_A_ACACHE_SHIFT)
#define AXI2MC_AXI_A_ACACHE_RANGE                       _MK_SHIFT_CONST(59):_MK_SHIFT_CONST(56)
#define AXI2MC_AXI_A_ACACHE_ROW                 0
#define AXI2MC_AXI_A_ACACHE_NONCACHEABLE_NONBUFFERABLE                  _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_ACACHE_BUFFERABLE                  _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_ACACHE_CACHEABLE_DONOTALLOCATE                     _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_ACACHE_CACHEABLE_BUFFERABLE_DONOTALLOCATE                  _MK_ENUM_CONST(3)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREAD                        _MK_ENUM_CONST(6)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREAD                   _MK_ENUM_CONST(7)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONWRITE                       _MK_ENUM_CONST(10)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONWRITE                  _MK_ENUM_CONST(11)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITETHROUGH_ALLOCATEONREADWRITE                   _MK_ENUM_CONST(14)
#define AXI2MC_AXI_A_ACACHE_CACHEABLEWRITEBACK_ALLOCATEONREADWRITE                      _MK_ENUM_CONST(15)

#define AXI2MC_AXI_A_APROT_SHIFT                        _MK_SHIFT_CONST(60)
#define AXI2MC_AXI_A_APROT_FIELD                        (_MK_MASK_CONST(0x7) << AXI2MC_AXI_A_APROT_SHIFT)
#define AXI2MC_AXI_A_APROT_RANGE                        _MK_SHIFT_CONST(62):_MK_SHIFT_CONST(60)
#define AXI2MC_AXI_A_APROT_ROW                  0
#define AXI2MC_AXI_A_APROT_DATA_SECURE_NORMAL                   _MK_ENUM_CONST(0)
#define AXI2MC_AXI_A_APROT_DATA_SECURE_PRIVILEGED                       _MK_ENUM_CONST(1)
#define AXI2MC_AXI_A_APROT_DATA_NONSECURE_NORMAL                        _MK_ENUM_CONST(2)
#define AXI2MC_AXI_A_APROT_DATA_NONSECURE_PRIVILEGED                    _MK_ENUM_CONST(3)
#define AXI2MC_AXI_A_APROT_INST_SECURE_NORMAL                   _MK_ENUM_CONST(4)
#define AXI2MC_AXI_A_APROT_INST_SECURE_PRIVILEGED                       _MK_ENUM_CONST(5)
#define AXI2MC_AXI_A_APROT_INST_NONSECURE_NORMAL                        _MK_ENUM_CONST(6)
#define AXI2MC_AXI_A_APROT_INST_NONSECURE_PRIVILEGED                    _MK_ENUM_CONST(7)


// Packet AXI2MC_AXI_W
#define AXI2MC_AXI_W_SIZE 302

#define AXI2MC_AXI_W_WDATA_SHIFT                        _MK_SHIFT_CONST(0)
#define AXI2MC_AXI_W_WDATA_FIELD                        (_MK_MASK_CONST(0xffffffff) << AXI2MC_AXI_W_WDATA_SHIFT)
#define AXI2MC_AXI_W_WDATA_RANGE                        _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(0)
#define AXI2MC_AXI_W_WDATA_ROW                  0

#define AXI2MC_AXI_W_WID_SHIFT                  _MK_SHIFT_CONST(256)
#define AXI2MC_AXI_W_WID_FIELD                  (_MK_MASK_CONST(0x1fff) << AXI2MC_AXI_W_WID_SHIFT)
#define AXI2MC_AXI_W_WID_RANGE                  _MK_SHIFT_CONST(268):_MK_SHIFT_CONST(256)
#define AXI2MC_AXI_W_WID_ROW                    0

#define AXI2MC_AXI_W_WSTRB_SHIFT                        _MK_SHIFT_CONST(269)
#define AXI2MC_AXI_W_WSTRB_FIELD                        (_MK_MASK_CONST(0xffffffff) << AXI2MC_AXI_W_WSTRB_SHIFT)
#define AXI2MC_AXI_W_WSTRB_RANGE                        _MK_SHIFT_CONST(300):_MK_SHIFT_CONST(269)
#define AXI2MC_AXI_W_WSTRB_ROW                  0

#define AXI2MC_AXI_W_WLAST_SHIFT                        _MK_SHIFT_CONST(301)
#define AXI2MC_AXI_W_WLAST_FIELD                        (_MK_MASK_CONST(0x1) << AXI2MC_AXI_W_WLAST_SHIFT)
#define AXI2MC_AXI_W_WLAST_RANGE                        _MK_SHIFT_CONST(301):_MK_SHIFT_CONST(301)
#define AXI2MC_AXI_W_WLAST_ROW                  0
#define AXI2MC_AXI_W_WLAST_DISABLED                     _MK_ENUM_CONST(0)
#define AXI2MC_AXI_W_WLAST_ENABLED                      _MK_ENUM_CONST(1)


// Packet AXI2MC_AXI_B
#define AXI2MC_AXI_B_SIZE 15

#define AXI2MC_AXI_B_BID_SHIFT                  _MK_SHIFT_CONST(0)
#define AXI2MC_AXI_B_BID_FIELD                  (_MK_MASK_CONST(0x1fff) << AXI2MC_AXI_B_BID_SHIFT)
#define AXI2MC_AXI_B_BID_RANGE                  _MK_SHIFT_CONST(12):_MK_SHIFT_CONST(0)
#define AXI2MC_AXI_B_BID_ROW                    0

#define AXI2MC_AXI_B_BRESP_SHIFT                        _MK_SHIFT_CONST(13)
#define AXI2MC_AXI_B_BRESP_FIELD                        (_MK_MASK_CONST(0x3) << AXI2MC_AXI_B_BRESP_SHIFT)
#define AXI2MC_AXI_B_BRESP_RANGE                        _MK_SHIFT_CONST(14):_MK_SHIFT_CONST(13)
#define AXI2MC_AXI_B_BRESP_ROW                  0
#define AXI2MC_AXI_B_BRESP_OKAY                 _MK_ENUM_CONST(0)
#define AXI2MC_AXI_B_BRESP_EXOKAY                       _MK_ENUM_CONST(1)
#define AXI2MC_AXI_B_BRESP_SLVERR                       _MK_ENUM_CONST(2)
#define AXI2MC_AXI_B_BRESP_DECERR                       _MK_ENUM_CONST(3)


// Packet AXI2MC_AXI_R
#define AXI2MC_AXI_R_SIZE 272

#define AXI2MC_AXI_R_RDATA_SHIFT                        _MK_SHIFT_CONST(0)
#define AXI2MC_AXI_R_RDATA_FIELD                        (_MK_MASK_CONST(0xffffffff) << AXI2MC_AXI_R_RDATA_SHIFT)
#define AXI2MC_AXI_R_RDATA_RANGE                        _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(0)
#define AXI2MC_AXI_R_RDATA_ROW                  0

#define AXI2MC_AXI_R_RID_SHIFT                  _MK_SHIFT_CONST(256)
#define AXI2MC_AXI_R_RID_FIELD                  (_MK_MASK_CONST(0x1fff) << AXI2MC_AXI_R_RID_SHIFT)
#define AXI2MC_AXI_R_RID_RANGE                  _MK_SHIFT_CONST(268):_MK_SHIFT_CONST(256)
#define AXI2MC_AXI_R_RID_ROW                    0

#define AXI2MC_AXI_R_RRESP_SHIFT                        _MK_SHIFT_CONST(269)
#define AXI2MC_AXI_R_RRESP_FIELD                        (_MK_MASK_CONST(0x3) << AXI2MC_AXI_R_RRESP_SHIFT)
#define AXI2MC_AXI_R_RRESP_RANGE                        _MK_SHIFT_CONST(270):_MK_SHIFT_CONST(269)
#define AXI2MC_AXI_R_RRESP_ROW                  0
#define AXI2MC_AXI_R_RRESP_OKAY                 _MK_ENUM_CONST(0)
#define AXI2MC_AXI_R_RRESP_EXOKAY                       _MK_ENUM_CONST(1)
#define AXI2MC_AXI_R_RRESP_SLVERR                       _MK_ENUM_CONST(2)
#define AXI2MC_AXI_R_RRESP_DECERR                       _MK_ENUM_CONST(3)

#define AXI2MC_AXI_R_RLAST_SHIFT                        _MK_SHIFT_CONST(271)
#define AXI2MC_AXI_R_RLAST_FIELD                        (_MK_MASK_CONST(0x1) << AXI2MC_AXI_R_RLAST_SHIFT)
#define AXI2MC_AXI_R_RLAST_RANGE                        _MK_SHIFT_CONST(271):_MK_SHIFT_CONST(271)
#define AXI2MC_AXI_R_RLAST_ROW                  0
#define AXI2MC_AXI_R_RLAST_DISABLED                     _MK_ENUM_CONST(0)
#define AXI2MC_AXI_R_RLAST_ENABLED                      _MK_ENUM_CONST(1)


// Packet MC_AXI_RWREQ
#define MC_AXI_RWREQ_SIZE 112

#define MC_AXI_RWREQ_AADDR_SHIFT                        _MK_SHIFT_CONST(0)
#define MC_AXI_RWREQ_AADDR_FIELD                        (_MK_MASK_CONST(0xffffffff) << MC_AXI_RWREQ_AADDR_SHIFT)
#define MC_AXI_RWREQ_AADDR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define MC_AXI_RWREQ_AADDR_ROW                  0

#define MC_AXI_RWREQ_AID_SHIFT                  _MK_SHIFT_CONST(32)
#define MC_AXI_RWREQ_AID_FIELD                  (_MK_MASK_CONST(0x1fff) << MC_AXI_RWREQ_AID_SHIFT)
#define MC_AXI_RWREQ_AID_RANGE                  _MK_SHIFT_CONST(44):_MK_SHIFT_CONST(32)
#define MC_AXI_RWREQ_AID_ROW                    0

#define MC_AXI_RWREQ_ALEN_SHIFT                 _MK_SHIFT_CONST(45)
#define MC_AXI_RWREQ_ALEN_FIELD                 (_MK_MASK_CONST(0xf) << MC_AXI_RWREQ_ALEN_SHIFT)
#define MC_AXI_RWREQ_ALEN_RANGE                 _MK_SHIFT_CONST(48):_MK_SHIFT_CONST(45)
#define MC_AXI_RWREQ_ALEN_ROW                   0

#define MC_AXI_RWREQ_ASIZE_SHIFT                        _MK_SHIFT_CONST(49)
#define MC_AXI_RWREQ_ASIZE_FIELD                        (_MK_MASK_CONST(0x7) << MC_AXI_RWREQ_ASIZE_SHIFT)
#define MC_AXI_RWREQ_ASIZE_RANGE                        _MK_SHIFT_CONST(51):_MK_SHIFT_CONST(49)
#define MC_AXI_RWREQ_ASIZE_ROW                  2

#define MC_AXI_RWREQ_ABURST_SHIFT                       _MK_SHIFT_CONST(52)
#define MC_AXI_RWREQ_ABURST_FIELD                       (_MK_MASK_CONST(0x3) << MC_AXI_RWREQ_ABURST_SHIFT)
#define MC_AXI_RWREQ_ABURST_RANGE                       _MK_SHIFT_CONST(53):_MK_SHIFT_CONST(52)
#define MC_AXI_RWREQ_ABURST_ROW                 0
#define MC_AXI_RWREQ_ABURST_FIXED                       _MK_ENUM_CONST(0)
#define MC_AXI_RWREQ_ABURST_INCR                        _MK_ENUM_CONST(1)
#define MC_AXI_RWREQ_ABURST_WRAP                        _MK_ENUM_CONST(2)
#define MC_AXI_RWREQ_ABURST_RSVD                        _MK_ENUM_CONST(3)

#define MC_AXI_RWREQ_ALOCK_SHIFT                        _MK_SHIFT_CONST(54)
#define MC_AXI_RWREQ_ALOCK_FIELD                        (_MK_MASK_CONST(0x3) << MC_AXI_RWREQ_ALOCK_SHIFT)
#define MC_AXI_RWREQ_ALOCK_RANGE                        _MK_SHIFT_CONST(55):_MK_SHIFT_CONST(54)
#define MC_AXI_RWREQ_ALOCK_ROW                  0

#define MC_AXI_RWREQ_ACACHE_SHIFT                       _MK_SHIFT_CONST(56)
#define MC_AXI_RWREQ_ACACHE_FIELD                       (_MK_MASK_CONST(0xf) << MC_AXI_RWREQ_ACACHE_SHIFT)
#define MC_AXI_RWREQ_ACACHE_RANGE                       _MK_SHIFT_CONST(59):_MK_SHIFT_CONST(56)
#define MC_AXI_RWREQ_ACACHE_ROW                 0

#define MC_AXI_RWREQ_APROT_SHIFT                        _MK_SHIFT_CONST(60)
#define MC_AXI_RWREQ_APROT_FIELD                        (_MK_MASK_CONST(0x7) << MC_AXI_RWREQ_APROT_SHIFT)
#define MC_AXI_RWREQ_APROT_RANGE                        _MK_SHIFT_CONST(62):_MK_SHIFT_CONST(60)
#define MC_AXI_RWREQ_APROT_ROW                  0

#define MC_AXI_RWREQ_ASB_SHIFT                  _MK_SHIFT_CONST(63)
#define MC_AXI_RWREQ_ASB_FIELD                  (_MK_MASK_CONST(0x3) << MC_AXI_RWREQ_ASB_SHIFT)
#define MC_AXI_RWREQ_ASB_RANGE                  _MK_SHIFT_CONST(64):_MK_SHIFT_CONST(63)
#define MC_AXI_RWREQ_ASB_ROW                    0

#define MC_AXI_RWREQ_ARW_SHIFT                  _MK_SHIFT_CONST(65)
#define MC_AXI_RWREQ_ARW_FIELD                  (_MK_MASK_CONST(0x1) << MC_AXI_RWREQ_ARW_SHIFT)
#define MC_AXI_RWREQ_ARW_RANGE                  _MK_SHIFT_CONST(65):_MK_SHIFT_CONST(65)
#define MC_AXI_RWREQ_ARW_ROW                    0

#define MC_AXI_RWREQ_ACT_AADDR_SHIFT                    _MK_SHIFT_CONST(66)
#define MC_AXI_RWREQ_ACT_AADDR_FIELD                    (_MK_MASK_CONST(0xffffffff) << MC_AXI_RWREQ_ACT_AADDR_SHIFT)
#define MC_AXI_RWREQ_ACT_AADDR_RANGE                    _MK_SHIFT_CONST(97):_MK_SHIFT_CONST(66)
#define MC_AXI_RWREQ_ACT_AADDR_ROW                      0

#define MC_AXI_RWREQ_ACT_ALEN_SHIFT                     _MK_SHIFT_CONST(98)
#define MC_AXI_RWREQ_ACT_ALEN_FIELD                     (_MK_MASK_CONST(0xf) << MC_AXI_RWREQ_ACT_ALEN_SHIFT)
#define MC_AXI_RWREQ_ACT_ALEN_RANGE                     _MK_SHIFT_CONST(101):_MK_SHIFT_CONST(98)
#define MC_AXI_RWREQ_ACT_ALEN_ROW                       0

#define MC_AXI_RWREQ_ACT_ASIZE_SHIFT                    _MK_SHIFT_CONST(102)
#define MC_AXI_RWREQ_ACT_ASIZE_FIELD                    (_MK_MASK_CONST(0x7) << MC_AXI_RWREQ_ACT_ASIZE_SHIFT)
#define MC_AXI_RWREQ_ACT_ASIZE_RANGE                    _MK_SHIFT_CONST(104):_MK_SHIFT_CONST(102)
#define MC_AXI_RWREQ_ACT_ASIZE_ROW                      0

#define MC_AXI_RWREQ_DOUBLEREQ_SHIFT                    _MK_SHIFT_CONST(105)
#define MC_AXI_RWREQ_DOUBLEREQ_FIELD                    (_MK_MASK_CONST(0x1) << MC_AXI_RWREQ_DOUBLEREQ_SHIFT)
#define MC_AXI_RWREQ_DOUBLEREQ_RANGE                    _MK_SHIFT_CONST(105):_MK_SHIFT_CONST(105)
#define MC_AXI_RWREQ_DOUBLEREQ_ROW                      0

#define MC_AXI_RWREQ_ILLEGALACC_SHIFT                   _MK_SHIFT_CONST(106)
#define MC_AXI_RWREQ_ILLEGALACC_FIELD                   (_MK_MASK_CONST(0x1) << MC_AXI_RWREQ_ILLEGALACC_SHIFT)
#define MC_AXI_RWREQ_ILLEGALACC_RANGE                   _MK_SHIFT_CONST(106):_MK_SHIFT_CONST(106)
#define MC_AXI_RWREQ_ILLEGALACC_ROW                     0

#define MC_AXI_RWREQ_TAG_SHIFT                  _MK_SHIFT_CONST(107)
#define MC_AXI_RWREQ_TAG_FIELD                  (_MK_MASK_CONST(0x1f) << MC_AXI_RWREQ_TAG_SHIFT)
#define MC_AXI_RWREQ_TAG_RANGE                  _MK_SHIFT_CONST(111):_MK_SHIFT_CONST(107)
#define MC_AXI_RWREQ_TAG_ROW                    0


// Packet CSR_C2MC_RESET
#define CSR_C2MC_RESET_SIZE 1

#define CSR_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CSR_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CSR_C2MC_RESET_RSTN_SHIFT)
#define CSR_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CSR_C2MC_RESET_RSTN_ROW                 0


// Packet CSR_C2MC_REQ
#define CSR_C2MC_REQ_SIZE 32

#define CSR_C2MC_REQ_ADR_SHIFT                  _MK_SHIFT_CONST(0)
#define CSR_C2MC_REQ_ADR_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSR_C2MC_REQ_ADR_SHIFT)
#define CSR_C2MC_REQ_ADR_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSR_C2MC_REQ_ADR_ROW                    0


// Packet CSR_C2MC_SIZE
#define CSR_C2MC_SIZE_SIZE 1

#define CSR_C2MC_SIZE_SIZE_SHIFT                        _MK_SHIFT_CONST(0)
#define CSR_C2MC_SIZE_SIZE_FIELD                        (_MK_MASK_CONST(0x1) << CSR_C2MC_SIZE_SIZE_SHIFT)
#define CSR_C2MC_SIZE_SIZE_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CSR_C2MC_SIZE_SIZE_ROW                  0


// Packet CSR_C2MC_SECURE
#define CSR_C2MC_SECURE_SIZE 1

#define CSR_C2MC_SECURE_SECURE_SHIFT                    _MK_SHIFT_CONST(0)
#define CSR_C2MC_SECURE_SECURE_FIELD                    (_MK_MASK_CONST(0x1) << CSR_C2MC_SECURE_SECURE_SHIFT)
#define CSR_C2MC_SECURE_SECURE_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CSR_C2MC_SECURE_SECURE_ROW                      0


// Packet CSR_C2MC_TAG
#define CSR_C2MC_TAG_SIZE 5

#define CSR_C2MC_TAG_TAG_SHIFT                  _MK_SHIFT_CONST(0)
#define CSR_C2MC_TAG_TAG_FIELD                  (_MK_MASK_CONST(0x1f) << CSR_C2MC_TAG_TAG_SHIFT)
#define CSR_C2MC_TAG_TAG_RANGE                  _MK_SHIFT_CONST(4):_MK_SHIFT_CONST(0)
#define CSR_C2MC_TAG_TAG_ROW                    0


// Packet CSR_C2MC_BP_REQ
#define CSR_C2MC_BP_REQ_SIZE 48

#define CSR_C2MC_BP_REQ_BASEADR_SHIFT                   _MK_SHIFT_CONST(0)
#define CSR_C2MC_BP_REQ_BASEADR_FIELD                   (_MK_MASK_CONST(0xffffffff) << CSR_C2MC_BP_REQ_BASEADR_SHIFT)
#define CSR_C2MC_BP_REQ_BASEADR_RANGE                   _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSR_C2MC_BP_REQ_BASEADR_ROW                     0

#define CSR_C2MC_BP_REQ_PITCH_SHIFT                     _MK_SHIFT_CONST(32)
#define CSR_C2MC_BP_REQ_PITCH_FIELD                     (_MK_MASK_CONST(0xffff) << CSR_C2MC_BP_REQ_PITCH_SHIFT)
#define CSR_C2MC_BP_REQ_PITCH_RANGE                     _MK_SHIFT_CONST(47):_MK_SHIFT_CONST(32)
#define CSR_C2MC_BP_REQ_PITCH_ROW                       0


// Packet CSR_C2MC_ADRXY
#define CSR_C2MC_ADRXY_SIZE 30

#define CSR_C2MC_ADRXY_OFFX_SHIFT                       _MK_SHIFT_CONST(0)
#define CSR_C2MC_ADRXY_OFFX_FIELD                       (_MK_MASK_CONST(0xffff) << CSR_C2MC_ADRXY_OFFX_SHIFT)
#define CSR_C2MC_ADRXY_OFFX_RANGE                       _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define CSR_C2MC_ADRXY_OFFX_ROW                 0

#define CSR_C2MC_ADRXY_OFFY_SHIFT                       _MK_SHIFT_CONST(16)
#define CSR_C2MC_ADRXY_OFFY_FIELD                       (_MK_MASK_CONST(0x3fff) << CSR_C2MC_ADRXY_OFFY_SHIFT)
#define CSR_C2MC_ADRXY_OFFY_RANGE                       _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(16)
#define CSR_C2MC_ADRXY_OFFY_ROW                 0


// Packet CSR_C2MC_TILE
#define CSR_C2MC_TILE_SIZE 33

#define CSR_C2MC_TILE_LINADR_SHIFT                      _MK_SHIFT_CONST(0)
#define CSR_C2MC_TILE_LINADR_FIELD                      (_MK_MASK_CONST(0xffffffff) << CSR_C2MC_TILE_LINADR_SHIFT)
#define CSR_C2MC_TILE_LINADR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSR_C2MC_TILE_LINADR_ROW                        0

#define CSR_C2MC_TILE_TMODE_SHIFT                       _MK_SHIFT_CONST(32)
#define CSR_C2MC_TILE_TMODE_FIELD                       (_MK_MASK_CONST(0x1) << CSR_C2MC_TILE_TMODE_SHIFT)
#define CSR_C2MC_TILE_TMODE_RANGE                       _MK_SHIFT_CONST(32):_MK_SHIFT_CONST(32)
#define CSR_C2MC_TILE_TMODE_ROW                 0
#define CSR_C2MC_TILE_TMODE_LINEAR                      _MK_ENUM_CONST(0)
#define CSR_C2MC_TILE_TMODE_TILED                       _MK_ENUM_CONST(1)


// Packet CSR_C2MC_RDI
#define CSR_C2MC_RDI_SIZE 256

#define CSR_C2MC_RDI_RDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CSR_C2MC_RDI_RDI_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSR_C2MC_RDI_RDI_SHIFT)
#define CSR_C2MC_RDI_RDI_RANGE                  _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(0)
#define CSR_C2MC_RDI_RDI_ROW                    0


// Packet CSR_C2MC_HP
#define CSR_C2MC_HP_SIZE 38

// high-priority threshold
#define CSR_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CSR_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSR_C2MC_HP_HPTH_SHIFT)
#define CSR_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSR_C2MC_HP_HPTH_ROW                    0

// high-priority timer
#define CSR_C2MC_HP_HPTM_SHIFT                  _MK_SHIFT_CONST(32)
#define CSR_C2MC_HP_HPTM_FIELD                  (_MK_MASK_CONST(0x3f) << CSR_C2MC_HP_HPTM_SHIFT)
#define CSR_C2MC_HP_HPTM_RANGE                  _MK_SHIFT_CONST(37):_MK_SHIFT_CONST(32)
#define CSR_C2MC_HP_HPTM_ROW                    0


// Packet CSR_C2MC_HYST
#define CSR_C2MC_HYST_SIZE 32

#define CSR_C2MC_HYST_HYST_REQ_TM_SHIFT                 _MK_SHIFT_CONST(0)
#define CSR_C2MC_HYST_HYST_REQ_TM_FIELD                 (_MK_MASK_CONST(0xff) << CSR_C2MC_HYST_HYST_REQ_TM_SHIFT)
#define CSR_C2MC_HYST_HYST_REQ_TM_RANGE                 _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(0)
#define CSR_C2MC_HYST_HYST_REQ_TM_ROW                   0

#define CSR_C2MC_HYST_DHYST_TM_SHIFT                    _MK_SHIFT_CONST(8)
#define CSR_C2MC_HYST_DHYST_TM_FIELD                    (_MK_MASK_CONST(0xff) << CSR_C2MC_HYST_DHYST_TM_SHIFT)
#define CSR_C2MC_HYST_DHYST_TM_RANGE                    _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(8)
#define CSR_C2MC_HYST_DHYST_TM_ROW                      0

#define CSR_C2MC_HYST_DHYST_TH_SHIFT                    _MK_SHIFT_CONST(16)
#define CSR_C2MC_HYST_DHYST_TH_FIELD                    (_MK_MASK_CONST(0xff) << CSR_C2MC_HYST_DHYST_TH_SHIFT)
#define CSR_C2MC_HYST_DHYST_TH_RANGE                    _MK_SHIFT_CONST(23):_MK_SHIFT_CONST(16)
#define CSR_C2MC_HYST_DHYST_TH_ROW                      0

#define CSR_C2MC_HYST_HYST_TM_SHIFT                     _MK_SHIFT_CONST(24)
#define CSR_C2MC_HYST_HYST_TM_FIELD                     (_MK_MASK_CONST(0xf) << CSR_C2MC_HYST_HYST_TM_SHIFT)
#define CSR_C2MC_HYST_HYST_TM_RANGE                     _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(24)
#define CSR_C2MC_HYST_HYST_TM_ROW                       0

#define CSR_C2MC_HYST_HYST_REQ_TH_SHIFT                 _MK_SHIFT_CONST(28)
#define CSR_C2MC_HYST_HYST_REQ_TH_FIELD                 (_MK_MASK_CONST(0x7) << CSR_C2MC_HYST_HYST_REQ_TH_SHIFT)
#define CSR_C2MC_HYST_HYST_REQ_TH_RANGE                 _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(28)
#define CSR_C2MC_HYST_HYST_REQ_TH_ROW                   0

#define CSR_C2MC_HYST_HYST_EN_SHIFT                     _MK_SHIFT_CONST(31)
#define CSR_C2MC_HYST_HYST_EN_FIELD                     (_MK_MASK_CONST(0x1) << CSR_C2MC_HYST_HYST_EN_SHIFT)
#define CSR_C2MC_HYST_HYST_EN_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define CSR_C2MC_HYST_HYST_EN_ROW                       0


// Packet CSW_C2MC_RESET
#define CSW_C2MC_RESET_SIZE 1

#define CSW_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CSW_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CSW_C2MC_RESET_RSTN_SHIFT)
#define CSW_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CSW_C2MC_RESET_RSTN_ROW                 0


// Packet CSW_C2MC_REQ
#define CSW_C2MC_REQ_SIZE 321

#define CSW_C2MC_REQ_ADR_SHIFT                  _MK_SHIFT_CONST(0)
#define CSW_C2MC_REQ_ADR_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_REQ_ADR_SHIFT)
#define CSW_C2MC_REQ_ADR_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_REQ_ADR_ROW                    0

#define CSW_C2MC_REQ_BE_SHIFT                   _MK_SHIFT_CONST(32)
#define CSW_C2MC_REQ_BE_FIELD                   (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_REQ_BE_SHIFT)
#define CSW_C2MC_REQ_BE_RANGE                   _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CSW_C2MC_REQ_BE_ROW                     0

#define CSW_C2MC_REQ_WDO_SHIFT                  _MK_SHIFT_CONST(64)
#define CSW_C2MC_REQ_WDO_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_REQ_WDO_SHIFT)
#define CSW_C2MC_REQ_WDO_RANGE                  _MK_SHIFT_CONST(319):_MK_SHIFT_CONST(64)
#define CSW_C2MC_REQ_WDO_ROW                    0

#define CSW_C2MC_REQ_TAG_SHIFT                  _MK_SHIFT_CONST(320)
#define CSW_C2MC_REQ_TAG_FIELD                  (_MK_MASK_CONST(0x1) << CSW_C2MC_REQ_TAG_SHIFT)
#define CSW_C2MC_REQ_TAG_RANGE                  _MK_SHIFT_CONST(320):_MK_SHIFT_CONST(320)
#define CSW_C2MC_REQ_TAG_ROW                    0


// Packet CSW_C2MC_SECURE
#define CSW_C2MC_SECURE_SIZE 1

#define CSW_C2MC_SECURE_SECURE_SHIFT                    _MK_SHIFT_CONST(0)
#define CSW_C2MC_SECURE_SECURE_FIELD                    (_MK_MASK_CONST(0x1) << CSW_C2MC_SECURE_SECURE_SHIFT)
#define CSW_C2MC_SECURE_SECURE_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CSW_C2MC_SECURE_SECURE_ROW                      0


// Packet CSW_C2MC_BP_REQ
#define CSW_C2MC_BP_REQ_SIZE 337

#define CSW_C2MC_BP_REQ_BASEADR_SHIFT                   _MK_SHIFT_CONST(0)
#define CSW_C2MC_BP_REQ_BASEADR_FIELD                   (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_BP_REQ_BASEADR_SHIFT)
#define CSW_C2MC_BP_REQ_BASEADR_RANGE                   _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_BP_REQ_BASEADR_ROW                     0

#define CSW_C2MC_BP_REQ_PITCH_SHIFT                     _MK_SHIFT_CONST(32)
#define CSW_C2MC_BP_REQ_PITCH_FIELD                     (_MK_MASK_CONST(0xffff) << CSW_C2MC_BP_REQ_PITCH_SHIFT)
#define CSW_C2MC_BP_REQ_PITCH_RANGE                     _MK_SHIFT_CONST(47):_MK_SHIFT_CONST(32)
#define CSW_C2MC_BP_REQ_PITCH_ROW                       0

#define CSW_C2MC_BP_REQ_BE_SHIFT                        _MK_SHIFT_CONST(48)
#define CSW_C2MC_BP_REQ_BE_FIELD                        (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_BP_REQ_BE_SHIFT)
#define CSW_C2MC_BP_REQ_BE_RANGE                        _MK_SHIFT_CONST(79):_MK_SHIFT_CONST(48)
#define CSW_C2MC_BP_REQ_BE_ROW                  0

#define CSW_C2MC_BP_REQ_WDO_SHIFT                       _MK_SHIFT_CONST(80)
#define CSW_C2MC_BP_REQ_WDO_FIELD                       (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_BP_REQ_WDO_SHIFT)
#define CSW_C2MC_BP_REQ_WDO_RANGE                       _MK_SHIFT_CONST(335):_MK_SHIFT_CONST(80)
#define CSW_C2MC_BP_REQ_WDO_ROW                 0

#define CSW_C2MC_BP_REQ_TAG_SHIFT                       _MK_SHIFT_CONST(336)
#define CSW_C2MC_BP_REQ_TAG_FIELD                       (_MK_MASK_CONST(0x1) << CSW_C2MC_BP_REQ_TAG_SHIFT)
#define CSW_C2MC_BP_REQ_TAG_RANGE                       _MK_SHIFT_CONST(336):_MK_SHIFT_CONST(336)
#define CSW_C2MC_BP_REQ_TAG_ROW                 0


// Packet CSW_C2MC_ADRXY
#define CSW_C2MC_ADRXY_SIZE 30

#define CSW_C2MC_ADRXY_OFFX_SHIFT                       _MK_SHIFT_CONST(0)
#define CSW_C2MC_ADRXY_OFFX_FIELD                       (_MK_MASK_CONST(0xffff) << CSW_C2MC_ADRXY_OFFX_SHIFT)
#define CSW_C2MC_ADRXY_OFFX_RANGE                       _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define CSW_C2MC_ADRXY_OFFX_ROW                 0

#define CSW_C2MC_ADRXY_OFFY_SHIFT                       _MK_SHIFT_CONST(16)
#define CSW_C2MC_ADRXY_OFFY_FIELD                       (_MK_MASK_CONST(0x3fff) << CSW_C2MC_ADRXY_OFFY_SHIFT)
#define CSW_C2MC_ADRXY_OFFY_RANGE                       _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(16)
#define CSW_C2MC_ADRXY_OFFY_ROW                 0


// Packet CSW_C2MC_TILE
#define CSW_C2MC_TILE_SIZE 33

#define CSW_C2MC_TILE_LINADR_SHIFT                      _MK_SHIFT_CONST(0)
#define CSW_C2MC_TILE_LINADR_FIELD                      (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_TILE_LINADR_SHIFT)
#define CSW_C2MC_TILE_LINADR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_TILE_LINADR_ROW                        0

#define CSW_C2MC_TILE_TMODE_SHIFT                       _MK_SHIFT_CONST(32)
#define CSW_C2MC_TILE_TMODE_FIELD                       (_MK_MASK_CONST(0x1) << CSW_C2MC_TILE_TMODE_SHIFT)
#define CSW_C2MC_TILE_TMODE_RANGE                       _MK_SHIFT_CONST(32):_MK_SHIFT_CONST(32)
#define CSW_C2MC_TILE_TMODE_ROW                 0
#define CSW_C2MC_TILE_TMODE_LINEAR                      _MK_ENUM_CONST(0)
#define CSW_C2MC_TILE_TMODE_TILED                       _MK_ENUM_CONST(1)


// Packet CSW_C2MC_XDI
#define CSW_C2MC_XDI_SIZE 32

// sometimes fake data
#define CSW_C2MC_XDI_XDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CSW_C2MC_XDI_XDI_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_XDI_XDI_SHIFT)
#define CSW_C2MC_XDI_XDI_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_XDI_XDI_ROW                    0


// Packet CSW_C2MC_HP
#define CSW_C2MC_HP_SIZE 32

// high-priority threshold
#define CSW_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CSW_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_HP_HPTH_SHIFT)
#define CSW_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_HP_HPTH_ROW                    0


// Packet CSW_C2MC_WCOAL
#define CSW_C2MC_WCOAL_SIZE 32

// write-coalescing time-out
#define CSW_C2MC_WCOAL_WCOALTM_SHIFT                    _MK_SHIFT_CONST(0)
#define CSW_C2MC_WCOAL_WCOALTM_FIELD                    (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_WCOAL_WCOALTM_SHIFT)
#define CSW_C2MC_WCOAL_WCOALTM_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_WCOAL_WCOALTM_ROW                      0


// Packet CSW_C2MC_HYST
#define CSW_C2MC_HYST_SIZE 32

// hysteresis control register
#define CSW_C2MC_HYST_HYST_SHIFT                        _MK_SHIFT_CONST(0)
#define CSW_C2MC_HYST_HYST_FIELD                        (_MK_MASK_CONST(0xffffffff) << CSW_C2MC_HYST_HYST_SHIFT)
#define CSW_C2MC_HYST_HYST_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CSW_C2MC_HYST_HYST_ROW                  0


// Packet CBR_C2MC_RESET
#define CBR_C2MC_RESET_SIZE 1

#define CBR_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CBR_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CBR_C2MC_RESET_RSTN_SHIFT)
#define CBR_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBR_C2MC_RESET_RSTN_ROW                 0


// Packet CBR_C2MC_REQP
#define CBR_C2MC_REQP_SIZE 263

#define CBR_C2MC_REQP_ADR_SHIFT                 _MK_SHIFT_CONST(0)
#define CBR_C2MC_REQP_ADR_FIELD                 (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_ADR_SHIFT)
#define CBR_C2MC_REQP_ADR_RANGE                 _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBR_C2MC_REQP_ADR_ROW                   0

#define CBR_C2MC_REQP_ADRU_SHIFT                        _MK_SHIFT_CONST(32)
#define CBR_C2MC_REQP_ADRU_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_ADRU_SHIFT)
#define CBR_C2MC_REQP_ADRU_RANGE                        _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CBR_C2MC_REQP_ADRU_ROW                  0

#define CBR_C2MC_REQP_ADRV_SHIFT                        _MK_SHIFT_CONST(64)
#define CBR_C2MC_REQP_ADRV_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_ADRV_SHIFT)
#define CBR_C2MC_REQP_ADRV_RANGE                        _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define CBR_C2MC_REQP_ADRV_ROW                  0

#define CBR_C2MC_REQP_LS_SHIFT                  _MK_SHIFT_CONST(96)
#define CBR_C2MC_REQP_LS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_LS_SHIFT)
#define CBR_C2MC_REQP_LS_RANGE                  _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(96)
#define CBR_C2MC_REQP_LS_ROW                    0

#define CBR_C2MC_REQP_LSUV_SHIFT                        _MK_SHIFT_CONST(128)
#define CBR_C2MC_REQP_LSUV_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_LSUV_SHIFT)
#define CBR_C2MC_REQP_LSUV_RANGE                        _MK_SHIFT_CONST(159):_MK_SHIFT_CONST(128)
#define CBR_C2MC_REQP_LSUV_ROW                  0

#define CBR_C2MC_REQP_HS_SHIFT                  _MK_SHIFT_CONST(160)
#define CBR_C2MC_REQP_HS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_HS_SHIFT)
#define CBR_C2MC_REQP_HS_RANGE                  _MK_SHIFT_CONST(191):_MK_SHIFT_CONST(160)
#define CBR_C2MC_REQP_HS_ROW                    0

#define CBR_C2MC_REQP_VS_SHIFT                  _MK_SHIFT_CONST(192)
#define CBR_C2MC_REQP_VS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_VS_SHIFT)
#define CBR_C2MC_REQP_VS_RANGE                  _MK_SHIFT_CONST(223):_MK_SHIFT_CONST(192)
#define CBR_C2MC_REQP_VS_ROW                    0

#define CBR_C2MC_REQP_DL_SHIFT                  _MK_SHIFT_CONST(224)
#define CBR_C2MC_REQP_DL_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_REQP_DL_SHIFT)
#define CBR_C2MC_REQP_DL_RANGE                  _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(224)
#define CBR_C2MC_REQP_DL_ROW                    0

#define CBR_C2MC_REQP_HD_SHIFT                  _MK_SHIFT_CONST(256)
#define CBR_C2MC_REQP_HD_FIELD                  (_MK_MASK_CONST(0x1) << CBR_C2MC_REQP_HD_SHIFT)
#define CBR_C2MC_REQP_HD_RANGE                  _MK_SHIFT_CONST(256):_MK_SHIFT_CONST(256)
#define CBR_C2MC_REQP_HD_ROW                    0

#define CBR_C2MC_REQP_VD_SHIFT                  _MK_SHIFT_CONST(257)
#define CBR_C2MC_REQP_VD_FIELD                  (_MK_MASK_CONST(0x1) << CBR_C2MC_REQP_VD_SHIFT)
#define CBR_C2MC_REQP_VD_RANGE                  _MK_SHIFT_CONST(257):_MK_SHIFT_CONST(257)
#define CBR_C2MC_REQP_VD_ROW                    0

#define CBR_C2MC_REQP_VX2_SHIFT                 _MK_SHIFT_CONST(258)
#define CBR_C2MC_REQP_VX2_FIELD                 (_MK_MASK_CONST(0x1) << CBR_C2MC_REQP_VX2_SHIFT)
#define CBR_C2MC_REQP_VX2_RANGE                 _MK_SHIFT_CONST(258):_MK_SHIFT_CONST(258)
#define CBR_C2MC_REQP_VX2_ROW                   0

#define CBR_C2MC_REQP_LP_SHIFT                  _MK_SHIFT_CONST(259)
#define CBR_C2MC_REQP_LP_FIELD                  (_MK_MASK_CONST(0x1) << CBR_C2MC_REQP_LP_SHIFT)
#define CBR_C2MC_REQP_LP_RANGE                  _MK_SHIFT_CONST(259):_MK_SHIFT_CONST(259)
#define CBR_C2MC_REQP_LP_ROW                    0

#define CBR_C2MC_REQP_YUV_SHIFT                 _MK_SHIFT_CONST(260)
#define CBR_C2MC_REQP_YUV_FIELD                 (_MK_MASK_CONST(0x7) << CBR_C2MC_REQP_YUV_SHIFT)
#define CBR_C2MC_REQP_YUV_RANGE                 _MK_SHIFT_CONST(262):_MK_SHIFT_CONST(260)
#define CBR_C2MC_REQP_YUV_ROW                   0


// Packet CBR_C2MC_SECURE
#define CBR_C2MC_SECURE_SIZE 1

#define CBR_C2MC_SECURE_SECURE_SHIFT                    _MK_SHIFT_CONST(0)
#define CBR_C2MC_SECURE_SECURE_FIELD                    (_MK_MASK_CONST(0x1) << CBR_C2MC_SECURE_SECURE_SHIFT)
#define CBR_C2MC_SECURE_SECURE_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBR_C2MC_SECURE_SECURE_ROW                      0


// Packet CBR_C2MC_ADRXY
#define CBR_C2MC_ADRXY_SIZE 44

#define CBR_C2MC_ADRXY_OFFX_SHIFT                       _MK_SHIFT_CONST(0)
#define CBR_C2MC_ADRXY_OFFX_FIELD                       (_MK_MASK_CONST(0xffff) << CBR_C2MC_ADRXY_OFFX_SHIFT)
#define CBR_C2MC_ADRXY_OFFX_RANGE                       _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define CBR_C2MC_ADRXY_OFFX_ROW                 0

#define CBR_C2MC_ADRXY_OFFY_SHIFT                       _MK_SHIFT_CONST(16)
#define CBR_C2MC_ADRXY_OFFY_FIELD                       (_MK_MASK_CONST(0x3fff) << CBR_C2MC_ADRXY_OFFY_SHIFT)
#define CBR_C2MC_ADRXY_OFFY_RANGE                       _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(16)
#define CBR_C2MC_ADRXY_OFFY_ROW                 0

#define CBR_C2MC_ADRXY_OFFYUV_SHIFT                     _MK_SHIFT_CONST(30)
#define CBR_C2MC_ADRXY_OFFYUV_FIELD                     (_MK_MASK_CONST(0x3fff) << CBR_C2MC_ADRXY_OFFYUV_SHIFT)
#define CBR_C2MC_ADRXY_OFFYUV_RANGE                     _MK_SHIFT_CONST(43):_MK_SHIFT_CONST(30)
#define CBR_C2MC_ADRXY_OFFYUV_ROW                       0


// Packet CBR_C2MC_TILE
#define CBR_C2MC_TILE_SIZE 98

#define CBR_C2MC_TILE_LINADR_SHIFT                      _MK_SHIFT_CONST(0)
#define CBR_C2MC_TILE_LINADR_FIELD                      (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_TILE_LINADR_SHIFT)
#define CBR_C2MC_TILE_LINADR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBR_C2MC_TILE_LINADR_ROW                        0

#define CBR_C2MC_TILE_LINADRU_SHIFT                     _MK_SHIFT_CONST(32)
#define CBR_C2MC_TILE_LINADRU_FIELD                     (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_TILE_LINADRU_SHIFT)
#define CBR_C2MC_TILE_LINADRU_RANGE                     _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CBR_C2MC_TILE_LINADRU_ROW                       0

#define CBR_C2MC_TILE_LINADRV_SHIFT                     _MK_SHIFT_CONST(64)
#define CBR_C2MC_TILE_LINADRV_FIELD                     (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_TILE_LINADRV_SHIFT)
#define CBR_C2MC_TILE_LINADRV_RANGE                     _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define CBR_C2MC_TILE_LINADRV_ROW                       0

#define CBR_C2MC_TILE_TMODE_SHIFT                       _MK_SHIFT_CONST(96)
#define CBR_C2MC_TILE_TMODE_FIELD                       (_MK_MASK_CONST(0x1) << CBR_C2MC_TILE_TMODE_SHIFT)
#define CBR_C2MC_TILE_TMODE_RANGE                       _MK_SHIFT_CONST(96):_MK_SHIFT_CONST(96)
#define CBR_C2MC_TILE_TMODE_ROW                 0
#define CBR_C2MC_TILE_TMODE_LINEAR                      _MK_ENUM_CONST(0)
#define CBR_C2MC_TILE_TMODE_TILED                       _MK_ENUM_CONST(1)

#define CBR_C2MC_TILE_TMODEUV_SHIFT                     _MK_SHIFT_CONST(97)
#define CBR_C2MC_TILE_TMODEUV_FIELD                     (_MK_MASK_CONST(0x1) << CBR_C2MC_TILE_TMODEUV_SHIFT)
#define CBR_C2MC_TILE_TMODEUV_RANGE                     _MK_SHIFT_CONST(97):_MK_SHIFT_CONST(97)
#define CBR_C2MC_TILE_TMODEUV_ROW                       0
#define CBR_C2MC_TILE_TMODEUV_LINEAR                    _MK_ENUM_CONST(0)
#define CBR_C2MC_TILE_TMODEUV_TILED                     _MK_ENUM_CONST(1)


// Packet CBR_C2MC_RDYP
#define CBR_C2MC_RDYP_SIZE 1

// fake data
#define CBR_C2MC_RDYP_RDYP_SHIFT                        _MK_SHIFT_CONST(0)
#define CBR_C2MC_RDYP_RDYP_FIELD                        (_MK_MASK_CONST(0x1) << CBR_C2MC_RDYP_RDYP_SHIFT)
#define CBR_C2MC_RDYP_RDYP_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBR_C2MC_RDYP_RDYP_ROW                  0


// Packet CBR_C2MC_OUTSTD
#define CBR_C2MC_OUTSTD_SIZE 1

#define CBR_C2MC_OUTSTD_OUTSTD_SHIFT                    _MK_SHIFT_CONST(0)
#define CBR_C2MC_OUTSTD_OUTSTD_FIELD                    (_MK_MASK_CONST(0x1) << CBR_C2MC_OUTSTD_OUTSTD_SHIFT)
#define CBR_C2MC_OUTSTD_OUTSTD_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBR_C2MC_OUTSTD_OUTSTD_ROW                      0


// Packet CBR_C2MC_STOP
#define CBR_C2MC_STOP_SIZE 1

#define CBR_C2MC_STOP_STOP_SHIFT                        _MK_SHIFT_CONST(0)
#define CBR_C2MC_STOP_STOP_FIELD                        (_MK_MASK_CONST(0x1) << CBR_C2MC_STOP_STOP_SHIFT)
#define CBR_C2MC_STOP_STOP_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBR_C2MC_STOP_STOP_ROW                  0


// Packet CBR_C2MC_RDI
#define CBR_C2MC_RDI_SIZE 262

#define CBR_C2MC_RDI_RDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CBR_C2MC_RDI_RDI_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_RDI_RDI_SHIFT)
#define CBR_C2MC_RDI_RDI_RANGE                  _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(0)
#define CBR_C2MC_RDI_RDI_ROW                    0

#define CBR_C2MC_RDI_RDILST_SHIFT                       _MK_SHIFT_CONST(256)
#define CBR_C2MC_RDI_RDILST_FIELD                       (_MK_MASK_CONST(0x1) << CBR_C2MC_RDI_RDILST_SHIFT)
#define CBR_C2MC_RDI_RDILST_RANGE                       _MK_SHIFT_CONST(256):_MK_SHIFT_CONST(256)
#define CBR_C2MC_RDI_RDILST_ROW                 0

#define CBR_C2MC_RDI_RDINB_SHIFT                        _MK_SHIFT_CONST(257)
#define CBR_C2MC_RDI_RDINB_FIELD                        (_MK_MASK_CONST(0x1f) << CBR_C2MC_RDI_RDINB_SHIFT)
#define CBR_C2MC_RDI_RDINB_RANGE                        _MK_SHIFT_CONST(261):_MK_SHIFT_CONST(257)
#define CBR_C2MC_RDI_RDINB_ROW                  0


// Packet CBR_C2MC_DOREQ
#define CBR_C2MC_DOREQ_SIZE 64

#define CBR_C2MC_DOREQ_ADR_SHIFT                        _MK_SHIFT_CONST(0)
#define CBR_C2MC_DOREQ_ADR_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_DOREQ_ADR_SHIFT)
#define CBR_C2MC_DOREQ_ADR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBR_C2MC_DOREQ_ADR_ROW                  0

#define CBR_C2MC_DOREQ_LS_SHIFT                 _MK_SHIFT_CONST(32)
#define CBR_C2MC_DOREQ_LS_FIELD                 (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_DOREQ_LS_SHIFT)
#define CBR_C2MC_DOREQ_LS_RANGE                 _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CBR_C2MC_DOREQ_LS_ROW                   0


// Packet CBR_C2MC_HP
#define CBR_C2MC_HP_SIZE 71

// high-priority threshold
#define CBR_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CBR_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBR_C2MC_HP_HPTH_SHIFT)
#define CBR_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBR_C2MC_HP_HPTH_ROW                    0

// high-priority timer
#define CBR_C2MC_HP_HPTM_SHIFT                  _MK_SHIFT_CONST(32)
#define CBR_C2MC_HP_HPTM_FIELD                  (_MK_MASK_CONST(0x3f) << CBR_C2MC_HP_HPTM_SHIFT)
#define CBR_C2MC_HP_HPTM_RANGE                  _MK_SHIFT_CONST(37):_MK_SHIFT_CONST(32)
#define CBR_C2MC_HP_HPTM_ROW                    0

// suppression - start of frame
#define CBR_C2MC_HP_HPSOF_SHIFT                 _MK_SHIFT_CONST(38)
#define CBR_C2MC_HP_HPSOF_FIELD                 (_MK_MASK_CONST(0x1) << CBR_C2MC_HP_HPSOF_SHIFT)
#define CBR_C2MC_HP_HPSOF_RANGE                 _MK_SHIFT_CONST(38):_MK_SHIFT_CONST(38)
#define CBR_C2MC_HP_HPSOF_ROW                   0

// suppression - cycles per word
#define CBR_C2MC_HP_HPCPW_SHIFT                 _MK_SHIFT_CONST(39)
#define CBR_C2MC_HP_HPCPW_FIELD                 (_MK_MASK_CONST(0xffff) << CBR_C2MC_HP_HPCPW_SHIFT)
#define CBR_C2MC_HP_HPCPW_RANGE                 _MK_SHIFT_CONST(54):_MK_SHIFT_CONST(39)
#define CBR_C2MC_HP_HPCPW_ROW                   0

// suppression - words per line
#define CBR_C2MC_HP_HPCBNPW_SHIFT                       _MK_SHIFT_CONST(55)
#define CBR_C2MC_HP_HPCBNPW_FIELD                       (_MK_MASK_CONST(0xffff) << CBR_C2MC_HP_HPCBNPW_SHIFT)
#define CBR_C2MC_HP_HPCBNPW_RANGE                       _MK_SHIFT_CONST(70):_MK_SHIFT_CONST(55)
#define CBR_C2MC_HP_HPCBNPW_ROW                 0


// Packet CBR_C2MC_HYST
#define CBR_C2MC_HYST_SIZE 32

#define CBR_C2MC_HYST_HYST_REQ_TM_SHIFT                 _MK_SHIFT_CONST(0)
#define CBR_C2MC_HYST_HYST_REQ_TM_FIELD                 (_MK_MASK_CONST(0xff) << CBR_C2MC_HYST_HYST_REQ_TM_SHIFT)
#define CBR_C2MC_HYST_HYST_REQ_TM_RANGE                 _MK_SHIFT_CONST(7):_MK_SHIFT_CONST(0)
#define CBR_C2MC_HYST_HYST_REQ_TM_ROW                   0

#define CBR_C2MC_HYST_DHYST_TM_SHIFT                    _MK_SHIFT_CONST(8)
#define CBR_C2MC_HYST_DHYST_TM_FIELD                    (_MK_MASK_CONST(0xff) << CBR_C2MC_HYST_DHYST_TM_SHIFT)
#define CBR_C2MC_HYST_DHYST_TM_RANGE                    _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(8)
#define CBR_C2MC_HYST_DHYST_TM_ROW                      0

#define CBR_C2MC_HYST_DHYST_TH_SHIFT                    _MK_SHIFT_CONST(16)
#define CBR_C2MC_HYST_DHYST_TH_FIELD                    (_MK_MASK_CONST(0xff) << CBR_C2MC_HYST_DHYST_TH_SHIFT)
#define CBR_C2MC_HYST_DHYST_TH_RANGE                    _MK_SHIFT_CONST(23):_MK_SHIFT_CONST(16)
#define CBR_C2MC_HYST_DHYST_TH_ROW                      0

#define CBR_C2MC_HYST_HYST_TM_SHIFT                     _MK_SHIFT_CONST(24)
#define CBR_C2MC_HYST_HYST_TM_FIELD                     (_MK_MASK_CONST(0xf) << CBR_C2MC_HYST_HYST_TM_SHIFT)
#define CBR_C2MC_HYST_HYST_TM_RANGE                     _MK_SHIFT_CONST(27):_MK_SHIFT_CONST(24)
#define CBR_C2MC_HYST_HYST_TM_ROW                       0

#define CBR_C2MC_HYST_HYST_REQ_TH_SHIFT                 _MK_SHIFT_CONST(28)
#define CBR_C2MC_HYST_HYST_REQ_TH_FIELD                 (_MK_MASK_CONST(0x7) << CBR_C2MC_HYST_HYST_REQ_TH_SHIFT)
#define CBR_C2MC_HYST_HYST_REQ_TH_RANGE                 _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(28)
#define CBR_C2MC_HYST_HYST_REQ_TH_ROW                   0

#define CBR_C2MC_HYST_HYST_EN_SHIFT                     _MK_SHIFT_CONST(31)
#define CBR_C2MC_HYST_HYST_EN_FIELD                     (_MK_MASK_CONST(0x1) << CBR_C2MC_HYST_HYST_EN_SHIFT)
#define CBR_C2MC_HYST_HYST_EN_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define CBR_C2MC_HYST_HYST_EN_ROW                       0


// Packet CBW_C2MC_RESET
#define CBW_C2MC_RESET_SIZE 1

#define CBW_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CBW_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CBW_C2MC_RESET_RSTN_SHIFT)
#define CBW_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBW_C2MC_RESET_RSTN_ROW                 0


// Packet CBW_C2MC_REQP
#define CBW_C2MC_REQP_SIZE 134

#define CBW_C2MC_REQP_ADR_SHIFT                 _MK_SHIFT_CONST(0)
#define CBW_C2MC_REQP_ADR_FIELD                 (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_REQP_ADR_SHIFT)
#define CBW_C2MC_REQP_ADR_RANGE                 _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBW_C2MC_REQP_ADR_ROW                   0

#define CBW_C2MC_REQP_LS_SHIFT                  _MK_SHIFT_CONST(32)
#define CBW_C2MC_REQP_LS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_REQP_LS_SHIFT)
#define CBW_C2MC_REQP_LS_RANGE                  _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CBW_C2MC_REQP_LS_ROW                    0

#define CBW_C2MC_REQP_HS_SHIFT                  _MK_SHIFT_CONST(64)
#define CBW_C2MC_REQP_HS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_REQP_HS_SHIFT)
#define CBW_C2MC_REQP_HS_RANGE                  _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define CBW_C2MC_REQP_HS_ROW                    0

#define CBW_C2MC_REQP_VS_SHIFT                  _MK_SHIFT_CONST(96)
#define CBW_C2MC_REQP_VS_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_REQP_VS_SHIFT)
#define CBW_C2MC_REQP_VS_RANGE                  _MK_SHIFT_CONST(127):_MK_SHIFT_CONST(96)
#define CBW_C2MC_REQP_VS_ROW                    0

#define CBW_C2MC_REQP_HD_SHIFT                  _MK_SHIFT_CONST(128)
#define CBW_C2MC_REQP_HD_FIELD                  (_MK_MASK_CONST(0x1) << CBW_C2MC_REQP_HD_SHIFT)
#define CBW_C2MC_REQP_HD_RANGE                  _MK_SHIFT_CONST(128):_MK_SHIFT_CONST(128)
#define CBW_C2MC_REQP_HD_ROW                    0

#define CBW_C2MC_REQP_VD_SHIFT                  _MK_SHIFT_CONST(129)
#define CBW_C2MC_REQP_VD_FIELD                  (_MK_MASK_CONST(0x1) << CBW_C2MC_REQP_VD_SHIFT)
#define CBW_C2MC_REQP_VD_RANGE                  _MK_SHIFT_CONST(129):_MK_SHIFT_CONST(129)
#define CBW_C2MC_REQP_VD_ROW                    0

#define CBW_C2MC_REQP_BPP_SHIFT                 _MK_SHIFT_CONST(130)
#define CBW_C2MC_REQP_BPP_FIELD                 (_MK_MASK_CONST(0x3) << CBW_C2MC_REQP_BPP_SHIFT)
#define CBW_C2MC_REQP_BPP_RANGE                 _MK_SHIFT_CONST(131):_MK_SHIFT_CONST(130)
#define CBW_C2MC_REQP_BPP_ROW                   0

#define CBW_C2MC_REQP_XY_SHIFT                  _MK_SHIFT_CONST(132)
#define CBW_C2MC_REQP_XY_FIELD                  (_MK_MASK_CONST(0x1) << CBW_C2MC_REQP_XY_SHIFT)
#define CBW_C2MC_REQP_XY_RANGE                  _MK_SHIFT_CONST(132):_MK_SHIFT_CONST(132)
#define CBW_C2MC_REQP_XY_ROW                    0

#define CBW_C2MC_REQP_PK_SHIFT                  _MK_SHIFT_CONST(133)
#define CBW_C2MC_REQP_PK_FIELD                  (_MK_MASK_CONST(0x1) << CBW_C2MC_REQP_PK_SHIFT)
#define CBW_C2MC_REQP_PK_RANGE                  _MK_SHIFT_CONST(133):_MK_SHIFT_CONST(133)
#define CBW_C2MC_REQP_PK_ROW                    0


// Packet CBW_C2MC_SECURE
#define CBW_C2MC_SECURE_SIZE 1

#define CBW_C2MC_SECURE_SECURE_SHIFT                    _MK_SHIFT_CONST(0)
#define CBW_C2MC_SECURE_SECURE_FIELD                    (_MK_MASK_CONST(0x1) << CBW_C2MC_SECURE_SECURE_SHIFT)
#define CBW_C2MC_SECURE_SECURE_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBW_C2MC_SECURE_SECURE_ROW                      0


// Packet CBW_C2MC_ADRXY
#define CBW_C2MC_ADRXY_SIZE 30

#define CBW_C2MC_ADRXY_OFFX_SHIFT                       _MK_SHIFT_CONST(0)
#define CBW_C2MC_ADRXY_OFFX_FIELD                       (_MK_MASK_CONST(0xffff) << CBW_C2MC_ADRXY_OFFX_SHIFT)
#define CBW_C2MC_ADRXY_OFFX_RANGE                       _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define CBW_C2MC_ADRXY_OFFX_ROW                 0

#define CBW_C2MC_ADRXY_OFFY_SHIFT                       _MK_SHIFT_CONST(16)
#define CBW_C2MC_ADRXY_OFFY_FIELD                       (_MK_MASK_CONST(0x3fff) << CBW_C2MC_ADRXY_OFFY_SHIFT)
#define CBW_C2MC_ADRXY_OFFY_RANGE                       _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(16)
#define CBW_C2MC_ADRXY_OFFY_ROW                 0


// Packet CBW_C2MC_TILE
#define CBW_C2MC_TILE_SIZE 33

#define CBW_C2MC_TILE_LINADR_SHIFT                      _MK_SHIFT_CONST(0)
#define CBW_C2MC_TILE_LINADR_FIELD                      (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_TILE_LINADR_SHIFT)
#define CBW_C2MC_TILE_LINADR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBW_C2MC_TILE_LINADR_ROW                        0

#define CBW_C2MC_TILE_TMODE_SHIFT                       _MK_SHIFT_CONST(32)
#define CBW_C2MC_TILE_TMODE_FIELD                       (_MK_MASK_CONST(0x1) << CBW_C2MC_TILE_TMODE_SHIFT)
#define CBW_C2MC_TILE_TMODE_RANGE                       _MK_SHIFT_CONST(32):_MK_SHIFT_CONST(32)
#define CBW_C2MC_TILE_TMODE_ROW                 0
#define CBW_C2MC_TILE_TMODE_LINEAR                      _MK_ENUM_CONST(0)
#define CBW_C2MC_TILE_TMODE_TILED                       _MK_ENUM_CONST(1)


// Packet CBW_C2MC_RDYP
#define CBW_C2MC_RDYP_SIZE 1

// fake data
#define CBW_C2MC_RDYP_RDYP_SHIFT                        _MK_SHIFT_CONST(0)
#define CBW_C2MC_RDYP_RDYP_FIELD                        (_MK_MASK_CONST(0x1) << CBW_C2MC_RDYP_RDYP_SHIFT)
#define CBW_C2MC_RDYP_RDYP_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBW_C2MC_RDYP_RDYP_ROW                  0


// Packet CBW_C2MC_STOP
#define CBW_C2MC_STOP_SIZE 1

#define CBW_C2MC_STOP_STOP_SHIFT                        _MK_SHIFT_CONST(0)
#define CBW_C2MC_STOP_STOP_FIELD                        (_MK_MASK_CONST(0x1) << CBW_C2MC_STOP_STOP_SHIFT)
#define CBW_C2MC_STOP_STOP_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBW_C2MC_STOP_STOP_ROW                  0


// Packet CBW_C2MC_XDI
#define CBW_C2MC_XDI_SIZE 1

// fake data
#define CBW_C2MC_XDI_XDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CBW_C2MC_XDI_XDI_FIELD                  (_MK_MASK_CONST(0x1) << CBW_C2MC_XDI_XDI_SHIFT)
#define CBW_C2MC_XDI_XDI_RANGE                  _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CBW_C2MC_XDI_XDI_ROW                    0


// Packet CBW_C2MC_DOREQ
#define CBW_C2MC_DOREQ_SIZE 321

#define CBW_C2MC_DOREQ_ADR_SHIFT                        _MK_SHIFT_CONST(0)
#define CBW_C2MC_DOREQ_ADR_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_DOREQ_ADR_SHIFT)
#define CBW_C2MC_DOREQ_ADR_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBW_C2MC_DOREQ_ADR_ROW                  0

#define CBW_C2MC_DOREQ_BE_SHIFT                 _MK_SHIFT_CONST(32)
#define CBW_C2MC_DOREQ_BE_FIELD                 (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_DOREQ_BE_SHIFT)
#define CBW_C2MC_DOREQ_BE_RANGE                 _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CBW_C2MC_DOREQ_BE_ROW                   0

#define CBW_C2MC_DOREQ_WDO_SHIFT                        _MK_SHIFT_CONST(64)
#define CBW_C2MC_DOREQ_WDO_FIELD                        (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_DOREQ_WDO_SHIFT)
#define CBW_C2MC_DOREQ_WDO_RANGE                        _MK_SHIFT_CONST(319):_MK_SHIFT_CONST(64)
#define CBW_C2MC_DOREQ_WDO_ROW                  0

#define CBW_C2MC_DOREQ_TAG_SHIFT                        _MK_SHIFT_CONST(320)
#define CBW_C2MC_DOREQ_TAG_FIELD                        (_MK_MASK_CONST(0x1) << CBW_C2MC_DOREQ_TAG_SHIFT)
#define CBW_C2MC_DOREQ_TAG_RANGE                        _MK_SHIFT_CONST(320):_MK_SHIFT_CONST(320)
#define CBW_C2MC_DOREQ_TAG_ROW                  0


// Packet CBW_C2MC_HP
#define CBW_C2MC_HP_SIZE 32

// high-priority threshold
#define CBW_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CBW_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_HP_HPTH_SHIFT)
#define CBW_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBW_C2MC_HP_HPTH_ROW                    0


// Packet CBW_C2MC_WCOAL
#define CBW_C2MC_WCOAL_SIZE 32

// write-coalescing time-out
#define CBW_C2MC_WCOAL_WCOALTM_SHIFT                    _MK_SHIFT_CONST(0)
#define CBW_C2MC_WCOAL_WCOALTM_FIELD                    (_MK_MASK_CONST(0xffffffff) << CBW_C2MC_WCOAL_WCOALTM_SHIFT)
#define CBW_C2MC_WCOAL_WCOALTM_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CBW_C2MC_WCOAL_WCOALTM_ROW                      0


// Packet CBW_C2MC_HYST
#define CBW_C2MC_HYST_SIZE 32

#define CBW_C2MC_HYST_HYST_REQ_TM_SHIFT                 _MK_SHIFT_CONST(0)
#define CBW_C2MC_HYST_HYST_REQ_TM_FIELD                 (_MK_MASK_CONST(0xfff) << CBW_C2MC_HYST_HYST_REQ_TM_SHIFT)
#define CBW_C2MC_HYST_HYST_REQ_TM_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define CBW_C2MC_HYST_HYST_REQ_TM_ROW                   0

#define CBW_C2MC_HYST_HYST_REQ_TH_SHIFT                 _MK_SHIFT_CONST(28)
#define CBW_C2MC_HYST_HYST_REQ_TH_FIELD                 (_MK_MASK_CONST(0x7) << CBW_C2MC_HYST_HYST_REQ_TH_SHIFT)
#define CBW_C2MC_HYST_HYST_REQ_TH_RANGE                 _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(28)
#define CBW_C2MC_HYST_HYST_REQ_TH_ROW                   0

#define CBW_C2MC_HYST_HYST_EN_SHIFT                     _MK_SHIFT_CONST(31)
#define CBW_C2MC_HYST_HYST_EN_FIELD                     (_MK_MASK_CONST(0x1) << CBW_C2MC_HYST_HYST_EN_SHIFT)
#define CBW_C2MC_HYST_HYST_EN_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define CBW_C2MC_HYST_HYST_EN_ROW                       0


// Packet CCR_C2MC_RESET
#define CCR_C2MC_RESET_SIZE 1

#define CCR_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CCR_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CCR_C2MC_RESET_RSTN_SHIFT)
#define CCR_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CCR_C2MC_RESET_RSTN_ROW                 0


// Packet CCR_C2MC_REQ
#define CCR_C2MC_REQ_SIZE 101

#define CCR_C2MC_REQ_ADR_SHIFT                  _MK_SHIFT_CONST(0)
#define CCR_C2MC_REQ_ADR_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_REQ_ADR_SHIFT)
#define CCR_C2MC_REQ_ADR_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCR_C2MC_REQ_ADR_ROW                    0

#define CCR_C2MC_REQ_LS_SHIFT                   _MK_SHIFT_CONST(32)
#define CCR_C2MC_REQ_LS_FIELD                   (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_REQ_LS_SHIFT)
#define CCR_C2MC_REQ_LS_RANGE                   _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CCR_C2MC_REQ_LS_ROW                     0

// HI is apparently a reserved keyword
#define CCR_C2MC_REQ_HINC_SHIFT                 _MK_SHIFT_CONST(64)
#define CCR_C2MC_REQ_HINC_FIELD                 (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_REQ_HINC_SHIFT)
#define CCR_C2MC_REQ_HINC_RANGE                 _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define CCR_C2MC_REQ_HINC_ROW                   0

#define CCR_C2MC_REQ_ACMD_SHIFT                 _MK_SHIFT_CONST(96)
#define CCR_C2MC_REQ_ACMD_FIELD                 (_MK_MASK_CONST(0x3) << CCR_C2MC_REQ_ACMD_SHIFT)
#define CCR_C2MC_REQ_ACMD_RANGE                 _MK_SHIFT_CONST(97):_MK_SHIFT_CONST(96)
#define CCR_C2MC_REQ_ACMD_ROW                   0

#define CCR_C2MC_REQ_LN_SHIFT                   _MK_SHIFT_CONST(98)
#define CCR_C2MC_REQ_LN_FIELD                   (_MK_MASK_CONST(0x1) << CCR_C2MC_REQ_LN_SHIFT)
#define CCR_C2MC_REQ_LN_RANGE                   _MK_SHIFT_CONST(98):_MK_SHIFT_CONST(98)
#define CCR_C2MC_REQ_LN_ROW                     0

#define CCR_C2MC_REQ_HD_SHIFT                   _MK_SHIFT_CONST(99)
#define CCR_C2MC_REQ_HD_FIELD                   (_MK_MASK_CONST(0x1) << CCR_C2MC_REQ_HD_SHIFT)
#define CCR_C2MC_REQ_HD_RANGE                   _MK_SHIFT_CONST(99):_MK_SHIFT_CONST(99)
#define CCR_C2MC_REQ_HD_ROW                     0

#define CCR_C2MC_REQ_VD_SHIFT                   _MK_SHIFT_CONST(100)
#define CCR_C2MC_REQ_VD_FIELD                   (_MK_MASK_CONST(0x1) << CCR_C2MC_REQ_VD_SHIFT)
#define CCR_C2MC_REQ_VD_RANGE                   _MK_SHIFT_CONST(100):_MK_SHIFT_CONST(100)
#define CCR_C2MC_REQ_VD_ROW                     0


// Packet CCR_C2MC_SECURE
#define CCR_C2MC_SECURE_SIZE 1

#define CCR_C2MC_SECURE_SECURE_SHIFT                    _MK_SHIFT_CONST(0)
#define CCR_C2MC_SECURE_SECURE_FIELD                    (_MK_MASK_CONST(0x1) << CCR_C2MC_SECURE_SECURE_SHIFT)
#define CCR_C2MC_SECURE_SECURE_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CCR_C2MC_SECURE_SECURE_ROW                      0


// Packet CCR_C2MC_RDI
#define CCR_C2MC_RDI_SIZE 256

#define CCR_C2MC_RDI_RDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CCR_C2MC_RDI_RDI_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_RDI_RDI_SHIFT)
#define CCR_C2MC_RDI_RDI_RANGE                  _MK_SHIFT_CONST(255):_MK_SHIFT_CONST(0)
#define CCR_C2MC_RDI_RDI_ROW                    0


// Packet CCR_C2MC_HP
#define CCR_C2MC_HP_SIZE 38

// high-priority threshold
#define CCR_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CCR_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_HP_HPTH_SHIFT)
#define CCR_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCR_C2MC_HP_HPTH_ROW                    0

// high-priority timer
#define CCR_C2MC_HP_HPTM_SHIFT                  _MK_SHIFT_CONST(32)
#define CCR_C2MC_HP_HPTM_FIELD                  (_MK_MASK_CONST(0x3f) << CCR_C2MC_HP_HPTM_SHIFT)
#define CCR_C2MC_HP_HPTM_RANGE                  _MK_SHIFT_CONST(37):_MK_SHIFT_CONST(32)
#define CCR_C2MC_HP_HPTM_ROW                    0


// Packet CCR_C2MC_HYST
#define CCR_C2MC_HYST_SIZE 32

// hysteresis control register
#define CCR_C2MC_HYST_HYST_SHIFT                        _MK_SHIFT_CONST(0)
#define CCR_C2MC_HYST_HYST_FIELD                        (_MK_MASK_CONST(0xffffffff) << CCR_C2MC_HYST_HYST_SHIFT)
#define CCR_C2MC_HYST_HYST_RANGE                        _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCR_C2MC_HYST_HYST_ROW                  0


// Packet CCW_C2MC_RESET
#define CCW_C2MC_RESET_SIZE 1

#define CCW_C2MC_RESET_RSTN_SHIFT                       _MK_SHIFT_CONST(0)
#define CCW_C2MC_RESET_RSTN_FIELD                       (_MK_MASK_CONST(0x1) << CCW_C2MC_RESET_RSTN_SHIFT)
#define CCW_C2MC_RESET_RSTN_RANGE                       _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CCW_C2MC_RESET_RSTN_ROW                 0


// Packet CCW_C2MC_REQ
#define CCW_C2MC_REQ_SIZE 417

#define CCW_C2MC_REQ_ADR_SHIFT                  _MK_SHIFT_CONST(0)
#define CCW_C2MC_REQ_ADR_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_REQ_ADR_SHIFT)
#define CCW_C2MC_REQ_ADR_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCW_C2MC_REQ_ADR_ROW                    0

#define CCW_C2MC_REQ_LS_SHIFT                   _MK_SHIFT_CONST(32)
#define CCW_C2MC_REQ_LS_FIELD                   (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_REQ_LS_SHIFT)
#define CCW_C2MC_REQ_LS_RANGE                   _MK_SHIFT_CONST(63):_MK_SHIFT_CONST(32)
#define CCW_C2MC_REQ_LS_ROW                     0

// HI is apparently a reserved keyword
#define CCW_C2MC_REQ_HINC_SHIFT                 _MK_SHIFT_CONST(64)
#define CCW_C2MC_REQ_HINC_FIELD                 (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_REQ_HINC_SHIFT)
#define CCW_C2MC_REQ_HINC_RANGE                 _MK_SHIFT_CONST(95):_MK_SHIFT_CONST(64)
#define CCW_C2MC_REQ_HINC_ROW                   0

#define CCW_C2MC_REQ_ACMD_SHIFT                 _MK_SHIFT_CONST(96)
#define CCW_C2MC_REQ_ACMD_FIELD                 (_MK_MASK_CONST(0x3) << CCW_C2MC_REQ_ACMD_SHIFT)
#define CCW_C2MC_REQ_ACMD_RANGE                 _MK_SHIFT_CONST(97):_MK_SHIFT_CONST(96)
#define CCW_C2MC_REQ_ACMD_ROW                   0

#define CCW_C2MC_REQ_LN_SHIFT                   _MK_SHIFT_CONST(98)
#define CCW_C2MC_REQ_LN_FIELD                   (_MK_MASK_CONST(0x1) << CCW_C2MC_REQ_LN_SHIFT)
#define CCW_C2MC_REQ_LN_RANGE                   _MK_SHIFT_CONST(98):_MK_SHIFT_CONST(98)
#define CCW_C2MC_REQ_LN_ROW                     0

#define CCW_C2MC_REQ_HD_SHIFT                   _MK_SHIFT_CONST(99)
#define CCW_C2MC_REQ_HD_FIELD                   (_MK_MASK_CONST(0x1) << CCW_C2MC_REQ_HD_SHIFT)
#define CCW_C2MC_REQ_HD_RANGE                   _MK_SHIFT_CONST(99):_MK_SHIFT_CONST(99)
#define CCW_C2MC_REQ_HD_ROW                     0

#define CCW_C2MC_REQ_VD_SHIFT                   _MK_SHIFT_CONST(100)
#define CCW_C2MC_REQ_VD_FIELD                   (_MK_MASK_CONST(0x1) << CCW_C2MC_REQ_VD_SHIFT)
#define CCW_C2MC_REQ_VD_RANGE                   _MK_SHIFT_CONST(100):_MK_SHIFT_CONST(100)
#define CCW_C2MC_REQ_VD_ROW                     0

#define CCW_C2MC_REQ_BPP_SHIFT                  _MK_SHIFT_CONST(101)
#define CCW_C2MC_REQ_BPP_FIELD                  (_MK_MASK_CONST(0x3) << CCW_C2MC_REQ_BPP_SHIFT)
#define CCW_C2MC_REQ_BPP_RANGE                  _MK_SHIFT_CONST(102):_MK_SHIFT_CONST(101)
#define CCW_C2MC_REQ_BPP_ROW                    0

#define CCW_C2MC_REQ_XY_SHIFT                   _MK_SHIFT_CONST(103)
#define CCW_C2MC_REQ_XY_FIELD                   (_MK_MASK_CONST(0x1) << CCW_C2MC_REQ_XY_SHIFT)
#define CCW_C2MC_REQ_XY_RANGE                   _MK_SHIFT_CONST(103):_MK_SHIFT_CONST(103)
#define CCW_C2MC_REQ_XY_ROW                     0

#define CCW_C2MC_REQ_BE_SHIFT                   _MK_SHIFT_CONST(128)
#define CCW_C2MC_REQ_BE_FIELD                   (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_REQ_BE_SHIFT)
#define CCW_C2MC_REQ_BE_RANGE                   _MK_SHIFT_CONST(159):_MK_SHIFT_CONST(128)
#define CCW_C2MC_REQ_BE_ROW                     0

#define CCW_C2MC_REQ_WDO_SHIFT                  _MK_SHIFT_CONST(160)
#define CCW_C2MC_REQ_WDO_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_REQ_WDO_SHIFT)
#define CCW_C2MC_REQ_WDO_RANGE                  _MK_SHIFT_CONST(415):_MK_SHIFT_CONST(160)
#define CCW_C2MC_REQ_WDO_ROW                    0

#define CCW_C2MC_REQ_TAG_SHIFT                  _MK_SHIFT_CONST(416)
#define CCW_C2MC_REQ_TAG_FIELD                  (_MK_MASK_CONST(0x1) << CCW_C2MC_REQ_TAG_SHIFT)
#define CCW_C2MC_REQ_TAG_RANGE                  _MK_SHIFT_CONST(416):_MK_SHIFT_CONST(416)
#define CCW_C2MC_REQ_TAG_ROW                    0


// Packet CCW_C2MC_SECURE
#define CCW_C2MC_SECURE_SIZE 1

#define CCW_C2MC_SECURE_SECURE_SHIFT                    _MK_SHIFT_CONST(0)
#define CCW_C2MC_SECURE_SECURE_FIELD                    (_MK_MASK_CONST(0x1) << CCW_C2MC_SECURE_SECURE_SHIFT)
#define CCW_C2MC_SECURE_SECURE_RANGE                    _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CCW_C2MC_SECURE_SECURE_ROW                      0


// Packet CCW_C2MC_ADRXY
#define CCW_C2MC_ADRXY_SIZE 30

#define CCW_C2MC_ADRXY_OFFX_SHIFT                       _MK_SHIFT_CONST(0)
#define CCW_C2MC_ADRXY_OFFX_FIELD                       (_MK_MASK_CONST(0xffff) << CCW_C2MC_ADRXY_OFFX_SHIFT)
#define CCW_C2MC_ADRXY_OFFX_RANGE                       _MK_SHIFT_CONST(15):_MK_SHIFT_CONST(0)
#define CCW_C2MC_ADRXY_OFFX_ROW                 0

#define CCW_C2MC_ADRXY_OFFY_SHIFT                       _MK_SHIFT_CONST(16)
#define CCW_C2MC_ADRXY_OFFY_FIELD                       (_MK_MASK_CONST(0x3fff) << CCW_C2MC_ADRXY_OFFY_SHIFT)
#define CCW_C2MC_ADRXY_OFFY_RANGE                       _MK_SHIFT_CONST(29):_MK_SHIFT_CONST(16)
#define CCW_C2MC_ADRXY_OFFY_ROW                 0


// Packet CCW_C2MC_TILE
#define CCW_C2MC_TILE_SIZE 33

#define CCW_C2MC_TILE_LINADR_SHIFT                      _MK_SHIFT_CONST(0)
#define CCW_C2MC_TILE_LINADR_FIELD                      (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_TILE_LINADR_SHIFT)
#define CCW_C2MC_TILE_LINADR_RANGE                      _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCW_C2MC_TILE_LINADR_ROW                        0

#define CCW_C2MC_TILE_TMODE_SHIFT                       _MK_SHIFT_CONST(32)
#define CCW_C2MC_TILE_TMODE_FIELD                       (_MK_MASK_CONST(0x1) << CCW_C2MC_TILE_TMODE_SHIFT)
#define CCW_C2MC_TILE_TMODE_RANGE                       _MK_SHIFT_CONST(32):_MK_SHIFT_CONST(32)
#define CCW_C2MC_TILE_TMODE_ROW                 0
#define CCW_C2MC_TILE_TMODE_LINEAR                      _MK_ENUM_CONST(0)
#define CCW_C2MC_TILE_TMODE_TILED                       _MK_ENUM_CONST(1)


// Packet CCW_C2MC_XDI
#define CCW_C2MC_XDI_SIZE 1

// fake data
#define CCW_C2MC_XDI_XDI_SHIFT                  _MK_SHIFT_CONST(0)
#define CCW_C2MC_XDI_XDI_FIELD                  (_MK_MASK_CONST(0x1) << CCW_C2MC_XDI_XDI_SHIFT)
#define CCW_C2MC_XDI_XDI_RANGE                  _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define CCW_C2MC_XDI_XDI_ROW                    0


// Packet CCW_C2MC_HP
#define CCW_C2MC_HP_SIZE 32

// high-priority threshold
#define CCW_C2MC_HP_HPTH_SHIFT                  _MK_SHIFT_CONST(0)
#define CCW_C2MC_HP_HPTH_FIELD                  (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_HP_HPTH_SHIFT)
#define CCW_C2MC_HP_HPTH_RANGE                  _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCW_C2MC_HP_HPTH_ROW                    0


// Packet CCW_C2MC_WCOAL
#define CCW_C2MC_WCOAL_SIZE 32

// write-coalescing time-out
#define CCW_C2MC_WCOAL_WCOALTM_SHIFT                    _MK_SHIFT_CONST(0)
#define CCW_C2MC_WCOAL_WCOALTM_FIELD                    (_MK_MASK_CONST(0xffffffff) << CCW_C2MC_WCOAL_WCOALTM_SHIFT)
#define CCW_C2MC_WCOAL_WCOALTM_RANGE                    _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(0)
#define CCW_C2MC_WCOAL_WCOALTM_ROW                      0


// Packet CCW_C2MC_HYST
#define CCW_C2MC_HYST_SIZE 32

#define CCW_C2MC_HYST_HYST_REQ_TM_SHIFT                 _MK_SHIFT_CONST(0)
#define CCW_C2MC_HYST_HYST_REQ_TM_FIELD                 (_MK_MASK_CONST(0xfff) << CCW_C2MC_HYST_HYST_REQ_TM_SHIFT)
#define CCW_C2MC_HYST_HYST_REQ_TM_RANGE                 _MK_SHIFT_CONST(11):_MK_SHIFT_CONST(0)
#define CCW_C2MC_HYST_HYST_REQ_TM_ROW                   0

#define CCW_C2MC_HYST_HYST_REQ_TH_SHIFT                 _MK_SHIFT_CONST(28)
#define CCW_C2MC_HYST_HYST_REQ_TH_FIELD                 (_MK_MASK_CONST(0x7) << CCW_C2MC_HYST_HYST_REQ_TH_SHIFT)
#define CCW_C2MC_HYST_HYST_REQ_TH_RANGE                 _MK_SHIFT_CONST(30):_MK_SHIFT_CONST(28)
#define CCW_C2MC_HYST_HYST_REQ_TH_ROW                   0

#define CCW_C2MC_HYST_HYST_EN_SHIFT                     _MK_SHIFT_CONST(31)
#define CCW_C2MC_HYST_HYST_EN_FIELD                     (_MK_MASK_CONST(0x1) << CCW_C2MC_HYST_HYST_EN_SHIFT)
#define CCW_C2MC_HYST_HYST_EN_RANGE                     _MK_SHIFT_CONST(31):_MK_SHIFT_CONST(31)
#define CCW_C2MC_HYST_HYST_EN_ROW                       0


// Packet SC_MCCIF_ASYNC
#define SC_MCCIF_ASYNC_SIZE 4

#define SC_MCCIF_ASYNC_RDCL_RDFAST_SHIFT                        _MK_SHIFT_CONST(0)
#define SC_MCCIF_ASYNC_RDCL_RDFAST_FIELD                        (_MK_MASK_CONST(0x1) << SC_MCCIF_ASYNC_RDCL_RDFAST_SHIFT)
#define SC_MCCIF_ASYNC_RDCL_RDFAST_RANGE                        _MK_SHIFT_CONST(0):_MK_SHIFT_CONST(0)
#define SC_MCCIF_ASYNC_RDCL_RDFAST_ROW                  0

#define SC_MCCIF_ASYNC_RDMC_RDFAST_SHIFT                        _MK_SHIFT_CONST(1)
#define SC_MCCIF_ASYNC_RDMC_RDFAST_FIELD                        (_MK_MASK_CONST(0x1) << SC_MCCIF_ASYNC_RDMC_RDFAST_SHIFT)
#define SC_MCCIF_ASYNC_RDMC_RDFAST_RANGE                        _MK_SHIFT_CONST(1):_MK_SHIFT_CONST(1)
#define SC_MCCIF_ASYNC_RDMC_RDFAST_ROW                  0

#define SC_MCCIF_ASYNC_WRCL_MCLE2X_SHIFT                        _MK_SHIFT_CONST(2)
#define SC_MCCIF_ASYNC_WRCL_MCLE2X_FIELD                        (_MK_MASK_CONST(0x1) << SC_MCCIF_ASYNC_WRCL_MCLE2X_SHIFT)
#define SC_MCCIF_ASYNC_WRCL_MCLE2X_RANGE                        _MK_SHIFT_CONST(2):_MK_SHIFT_CONST(2)
#define SC_MCCIF_ASYNC_WRCL_MCLE2X_ROW                  0

#define SC_MCCIF_ASYNC_WRMC_CLLE2X_SHIFT                        _MK_SHIFT_CONST(3)
#define SC_MCCIF_ASYNC_WRMC_CLLE2X_FIELD                        (_MK_MASK_CONST(0x1) << SC_MCCIF_ASYNC_WRMC_CLLE2X_SHIFT)
#define SC_MCCIF_ASYNC_WRMC_CLLE2X_RANGE                        _MK_SHIFT_CONST(3):_MK_SHIFT_CONST(3)
#define SC_MCCIF_ASYNC_WRMC_CLLE2X_ROW                  0


//
// REGISTER LIST
//
#define LIST_ARMC_REGS(_op_) \
_op_(MC_INTSTATUS_0) \
_op_(MC_INTMASK_0) \
_op_(MC_EMEM_CFG_0) \
_op_(MC_EMEM_ADR_CFG_0) \
_op_(MC_EMEM_ARB_CFG0_0) \
_op_(MC_EMEM_ARB_CFG1_0) \
_op_(MC_EMEM_ARB_CFG2_0) \
_op_(MC_GART_CONFIG_0) \
_op_(MC_GART_ENTRY_ADDR_0) \
_op_(MC_GART_ENTRY_DATA_0) \
_op_(MC_GART_ERROR_REQ_0) \
_op_(MC_GART_ERROR_ADDR_0) \
_op_(MC_TIMEOUT_CTRL_0) \
_op_(MC_DECERR_EMEM_OTHERS_STATUS_0) \
_op_(MC_DECERR_EMEM_OTHERS_ADR_0) \
_op_(MC_CLKEN_OVERRIDE_0) \
_op_(MC_SECURITY_CFG0_0) \
_op_(MC_SECURITY_CFG1_0) \
_op_(MC_SECURITY_VIOLATION_STATUS_0) \
_op_(MC_SECURITY_VIOLATION_ADR_0) \
_op_(MC_SECURITY_CFG2_0) \
_op_(MC_STAT_CONTROL_0) \
_op_(MC_STAT_STATUS_0) \
_op_(MC_STAT_EMC_ADDR_LOW_0) \
_op_(MC_STAT_EMC_ADDR_HIGH_0) \
_op_(MC_STAT_EMC_CLOCK_LIMIT_0) \
_op_(MC_STAT_EMC_CLOCKS_0) \
_op_(MC_STAT_EMC_CONTROL_0_0) \
_op_(MC_STAT_EMC_CONTROL_1_0) \
_op_(MC_STAT_EMC_HIST_LIMIT_0_0) \
_op_(MC_STAT_EMC_HIST_LIMIT_1_0) \
_op_(MC_STAT_EMC_COUNT_0_0) \
_op_(MC_STAT_EMC_COUNT_1_0) \
_op_(MC_STAT_EMC_HIST_0_0) \
_op_(MC_STAT_EMC_HIST_1_0) \
_op_(MC_CLIENT_CTRL_0) \
_op_(MC_CLIENT_HOTRESETN_0) \
_op_(MC_AXI_DECERR_OVR_0) \
_op_(MC_LOWLATENCY_CONFIG_0) \
_op_(MC_LOWLATENCY_RAWLOGIC_WRITE_PARTICIPANTS_0) \
_op_(MC_BWSHARE_TMVAL_0) \
_op_(MC_BWSHARE_EMEM_CTRL_0_0) \
_op_(MC_BWSHARE_EMEM_CTRL_1_0) \
_op_(MC_AP_CTRL_0_0) \
_op_(MC_AP_CTRL_1_0) \
_op_(MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0) \
_op_(MC_CLIENT_ACTIVITY_MONITOR_EMEM_1_0) \
_op_(MC_AVPC_ORRC_0) \
_op_(MC_DC_ORRC_0) \
_op_(MC_DCB_ORRC_0) \
_op_(MC_EPP_ORRC_0) \
_op_(MC_G2_ORRC_0) \
_op_(MC_HC_ORRC_0) \
_op_(MC_ISP_ORRC_0) \
_op_(MC_MPCORE_ORRC_0) \
_op_(MC_MPEA_ORRC_0) \
_op_(MC_MPEB_ORRC_0) \
_op_(MC_MPEC_ORRC_0) \
_op_(MC_NV_ORRC_0) \
_op_(MC_PPCS_ORRC_0) \
_op_(MC_VDE_ORRC_0) \
_op_(MC_VI_ORRC_0) \
_op_(MC_FPRI_CTRL_AVPC_0) \
_op_(MC_FPRI_CTRL_DC_0) \
_op_(MC_FPRI_CTRL_DCB_0) \
_op_(MC_FPRI_CTRL_EPP_0) \
_op_(MC_FPRI_CTRL_G2_0) \
_op_(MC_FPRI_CTRL_HC_0) \
_op_(MC_FPRI_CTRL_ISP_0) \
_op_(MC_FPRI_CTRL_MPCORE_0) \
_op_(MC_FPRI_CTRL_MPEA_0) \
_op_(MC_FPRI_CTRL_MPEB_0) \
_op_(MC_FPRI_CTRL_MPEC_0) \
_op_(MC_FPRI_CTRL_NV_0) \
_op_(MC_FPRI_CTRL_PPCS_0) \
_op_(MC_FPRI_CTRL_VDE_0) \
_op_(MC_FPRI_CTRL_VI_0) \
_op_(MC_TIMEOUT_AVPC_0) \
_op_(MC_TIMEOUT_DC_0) \
_op_(MC_TIMEOUT_DCB_0) \
_op_(MC_TIMEOUT_EPP_0) \
_op_(MC_TIMEOUT_G2_0) \
_op_(MC_TIMEOUT_HC_0) \
_op_(MC_TIMEOUT_ISP_0) \
_op_(MC_TIMEOUT_MPCORE_0) \
_op_(MC_TIMEOUT_MPEA_0) \
_op_(MC_TIMEOUT_MPEB_0) \
_op_(MC_TIMEOUT_MPEC_0) \
_op_(MC_TIMEOUT_NV_0) \
_op_(MC_TIMEOUT_PPCS_0) \
_op_(MC_TIMEOUT_VDE_0) \
_op_(MC_TIMEOUT_VI_0) \
_op_(MC_TIMEOUT_RCOAL_AVPC_0) \
_op_(MC_TIMEOUT_RCOAL_DC_0) \
_op_(MC_TIMEOUT1_RCOAL_DC_0) \
_op_(MC_TIMEOUT_RCOAL_DCB_0) \
_op_(MC_TIMEOUT1_RCOAL_DCB_0) \
_op_(MC_TIMEOUT_RCOAL_EPP_0) \
_op_(MC_TIMEOUT_RCOAL_G2_0) \
_op_(MC_TIMEOUT_RCOAL_HC_0) \
_op_(MC_TIMEOUT_RCOAL_MPCORE_0) \
_op_(MC_TIMEOUT_RCOAL_MPEA_0) \
_op_(MC_TIMEOUT_RCOAL_MPEB_0) \
_op_(MC_TIMEOUT_RCOAL_MPEC_0) \
_op_(MC_TIMEOUT_RCOAL_NV_0) \
_op_(MC_TIMEOUT_RCOAL_PPCS_0) \
_op_(MC_TIMEOUT_RCOAL_VDE_0) \
_op_(MC_TIMEOUT_RCOAL_VI_0) \
_op_(MC_RCOAL_AUTODISABLE_0_0) \
_op_(MC_BWSHARE_AVPC_0) \
_op_(MC_BWSHARE_DC_0) \
_op_(MC_BWSHARE_DCB_0) \
_op_(MC_BWSHARE_EPP_0) \
_op_(MC_BWSHARE_G2_0) \
_op_(MC_BWSHARE_HC_0) \
_op_(MC_BWSHARE_ISP_0) \
_op_(MC_BWSHARE_MPCORE_0) \
_op_(MC_BWSHARE_MPEA_0) \
_op_(MC_BWSHARE_MPEB_0) \
_op_(MC_BWSHARE_MPEC_0) \
_op_(MC_BWSHARE_NV_0) \
_op_(MC_BWSHARE_PPCS_0) \
_op_(MC_BWSHARE_VDE_0) \
_op_(MC_BWSHARE_VI_0)


//
// ADDRESS SPACES
//

#define BASE_ADDRESS_MC 0x00000000

//
// ARMC REGISTER BANKS
//

#define MC0_FIRST_REG 0x0000 // MC_INTSTATUS_0
#define MC0_LAST_REG 0x0004 // MC_INTMASK_0
#define MC1_FIRST_REG 0x000c // MC_EMEM_CFG_0
#define MC1_LAST_REG 0x001c // MC_EMEM_ARB_CFG2_0
#define MC2_FIRST_REG 0x0024 // MC_GART_CONFIG_0
#define MC2_LAST_REG 0x0034 // MC_GART_ERROR_ADDR_0
#define MC3_FIRST_REG 0x003c // MC_TIMEOUT_CTRL_0
#define MC3_LAST_REG 0x003c // MC_TIMEOUT_CTRL_0
#define MC4_FIRST_REG 0x0058 // MC_DECERR_EMEM_OTHERS_STATUS_0
#define MC4_LAST_REG 0x005c // MC_DECERR_EMEM_OTHERS_ADR_0
#define MC5_FIRST_REG 0x0068 // MC_CLKEN_OVERRIDE_0
#define MC5_LAST_REG 0x007c // MC_SECURITY_CFG2_0
#define MC6_FIRST_REG 0x0090 // MC_STAT_CONTROL_0
#define MC6_LAST_REG 0x00c4 // MC_STAT_EMC_HIST_1_0
#define MC7_FIRST_REG 0x0100 // MC_CLIENT_CTRL_0
#define MC7_LAST_REG 0x0114 // MC_BWSHARE_TMVAL_0
#define MC8_FIRST_REG 0x0120 // MC_BWSHARE_EMEM_CTRL_0_0
#define MC8_LAST_REG 0x012c // MC_AP_CTRL_1_0
#define MC9_FIRST_REG 0x0138 // MC_CLIENT_ACTIVITY_MONITOR_EMEM_0_0
#define MC9_LAST_REG 0x0270 // MC_BWSHARE_VI_0

#ifndef _MK_SHIFT_CONST
  #define _MK_SHIFT_CONST(_constant_) _constant_
#endif
#ifndef _MK_MASK_CONST
  #define _MK_MASK_CONST(_constant_) _constant_
#endif
#ifndef _MK_ENUM_CONST
  #define _MK_ENUM_CONST(_constant_) (_constant_ ## UL)
#endif
#ifndef _MK_ADDR_CONST
  #define _MK_ADDR_CONST(_constant_) _constant_
#endif

#endif // ifndef ___ARMC_H_INC_
